// Example 29a: Stack controller
module stack_ctrl32 (  
input wire clr ,
input wire clk ,
input wire push ,
input wire pop ,
output reg we ,
output reg amsel ,
output reg [4:0] wr_addr ,
output reg [4:0] rd_addr ,
output reg full ,
output reg empty  
);
reg full_flag, empty_flag;
reg [4:0] push_addr, pop_addr;

//assign  full = full_flag;
//assign  empty = empty_flag;

always @(posedge clk or posedge clr) 
begin
    if(clr == 1)
	  begin 
      	push_addr = 5'b11111;
        pop_addr = 5'b00000;
      	empty_flag = 1;
      	full_flag = 0;
      	wr_addr <= 5'b11111;
      	rd_addr <= 5'b00000; 
	  end
	else
	  begin 
        if(push == 1)
		  begin 
	      	if(pop == 0)
		      begin 
              	if(full_flag == 0) 
			      begin 
            		push_addr = push_addr - 1;
            		pop_addr = push_addr + 1;
            		empty_flag = 0;
              		if(push_addr == 5'b11111)
				  	  begin 
                		full_flag = 1;
                		push_addr = 5'b00000;
              	  	  end 
              	  end 
		       end
	         else 
		  	   begin 
	  				// write to top of stack (pop_addr) without pushing
	  				// don't change push_addr and pop_addr
          	   end
		   end
         else
		 	begin 
			   if(pop == 1)
		  		  begin 
        			if(empty_flag == 0)
          				pop_addr = pop_addr + 1;
          			if(full_flag == 0)
            			push_addr = push_addr + 1;
          			full_flag = 0;
          			if(pop_addr == 5'b00000)
            			empty_flag = 1;
          		  end 
          	end 
      wr_addr <= push_addr;
      rd_addr <= pop_addr; 
 	end 
end 

always @(*)
begin 
  	full <= full_flag;
	empty <= empty_flag;	
    if((push == 1) && (full_flag == 0))
      	we = 1;
    else
      	we = 0;
    if((push == 1) && (pop == 1)) 
      	amsel = 1;
    else
      	amsel = 0;
end	 

endmodule
