// Example 29b: stack32x16
module stack32x16 (  
input wire clk ,
input wire clr ,
input wire push ,
input wire pop ,
input wire [15:0] d ,
output wire full ,
output wire empty ,
output wire [15:0] q  
);
wire we, amsel;
wire [4:0] wr_addr, rd_addr, wr2_addr;
wire [15:0] open; 

dpram32x16 U1 (
	.a(wr2_addr), 	// Bus [4 : 0] 
	.d(d), 			// Bus [15 : 0] 
	.dpra(rd_addr), // Bus [4 : 0] 
	.clk(clk),
	.we(we),
	.spo(open), 	// Bus [15 : 0] 
	.dpo(q)); 		// Bus [15 : 0] 

stack_ctrl32 U2 (.clr(clr),
	.clk(clk),
	.push(push),
	.pop(pop),
	.we(we),
	.amsel(amsel),
	.wr_addr(wr_addr),
	.rd_addr(rd_addr),
	.full(full),
	.empty(empty)
);

mux2g #(
	.N(5))
Label1 (.a(wr_addr),
	.b(rd_addr),
	.s(amsel),
	.y(wr2_addr)
);

endmodule
