// Example 51: FC16 - ReturnStack.v
module returnStack (  
input wire [15:0] Rin ,
input wire rsel ,
input wire rload ,
input wire rdec ,
input wire clr ,
input wire clk ,
input wire rpush ,
input wire rpop ,
output wire [15:0] R  
);
wire [15:0] R1, Rout, r_in;
// Note wire open is 16 bits in book, should be seperate and 1  bit wide  
// dummy wires.
wire open1;
wire open2;

assign R = Rout;

mux2g #(
	.N(16))
rmux (.a(Rin),
	.b(R1),
	.s(rsel),
	.y(r_in)
);

dreg rreg (.d(r_in),
	.load(rload),
	.dec(rdec),
	.clr(clr),
	.clk(clk),
	.q(Rout)
);

stack32x16 stack
(.clk(clk),
.clr(clr),
.push(rpush),
.pop(rpop),
.d(Rout),
.full(open1),
.empty(open2),
.q(R1)
);


endmodule
