// Example 48: opcodes

  // Data stack instructions    				//Forth WORDS
  parameter nop = 16'h0000;		// NOP  
  parameter dup = 16'h0001;		// DUP  
  parameter swap = 16'h0002;  	// SWAP
  parameter drop = 16'h0003;  	// DROP
  parameter over = 16'h0004;   	// OVER 
  parameter rot = 16'h0005; 		// ROT
  parameter mrot = 16'h0006; 		// -ROT   
  parameter nip = 16'h0007; 		// NIP 
  parameter tuck = 16'h0008; 		// TUCK       
  parameter rot_drop = 16'h0009;  	// ROT_DROP
  parameter rot_drop_swap = 16'h000A;  // ROT_DROP_SWAP	   

  // Function Unit instructions
  parameter plus = 16'h0010; 		// + 
  parameter minus = 16'h0011; 		// - 
  parameter plus1 = 16'h0012; 		// 1+   
  parameter minus1 = 16'h0013;  	// 1-
  parameter invert = 16'h0014; 		// INVERT
  parameter andd = 16'h0015;  	// AND
  parameter orr = 16'h0016;  	// OR
  parameter xorr = 16'h0017;  	// XOR
  parameter twotimes = 16'h0018;    	// 2*
  parameter u2slash = 16'h0019;  	// U2/
  parameter twoslash = 16'h001A;    	// 2/
  parameter rshift = 16'h001B;  	// RSHIFT
  parameter lshift = 16'h001C;		// LSHIFT
  parameter mpp = 16'h001D;		// mpp
  parameter shldc = 16'h001E;		// shldc

  parameter ones = 16'h0020;		// TRUE
  parameter zeros = 16'h0021;		// FALSE 
  parameter zeroequal = 16'h0022;		// 0=
  parameter zeroless = 16'h0023;		// 0<  
  parameter ugt = 16'h0024; 		// U> 
  parameter ult = 16'h0025; 		// U<   
  parameter eq = 16'h0026;  	// =
  parameter ugte = 16'h0027;		// U>=
  parameter ulte = 16'h0028;		// U<=
  parameter neq = 16'h0029;  	// <>
  parameter gt = 16'h002A; 		// > 
  parameter lt = 16'h002B; 		// <   
  parameter gte = 16'h002C;		// >=
  parameter lte = 16'h002D;		// <= 
        
  // Return Stack, Memory Access, and I/O instructions
  parameter tor = 16'h0030;  	// >R
  parameter rfrom = 16'h0031;  	// R>
  parameter rfetch = 16'h0032;  	// R@
  parameter rfromdrop = 16'h0033;    	// R>DROP
  parameter romfetch1 = 16'h0035;    	// ROM1@
  parameter romfetch2 = 16'h0036;		// ROM2@
  parameter sfetch = 16'h0037;    	// S@
  parameter digstore = 16'h0038;  	// DIG!
  parameter ldstore = 16'h0039;		// LD! 
  parameter rxfetch = 16'h003C;    	// RX@
  parameter totx = 16'h003D;    	// >tx
  
  // Literal, Transfer, multi-cycle instructions
  parameter lit = 16'h0100;  	// LIT  
  parameter jmp = 16'h0101;  	// ELSE, THEN
  parameter jz = 16'h0102;  	// IF, WHILE
  parameter drjne = 16'h0103;  	// NEXT
  parameter call = 16'h0104;    	// :
  parameter ret = 16'h0105;  	// ;
  parameter jb0LO = 16'h0106;    	// waitBx
  parameter jb1LO = 16'h0107;  	
  parameter jb2LO = 16'h0108;	
  parameter jb3LO = 16'h0109;
  parameter jb0HI = 16'h010A;    	
  parameter jb1HI = 16'h010B;  	
  parameter jb2HI = 16'h010C;	
  parameter jb3HI = 16'h010D; 
  


