// Example 50: funit16.v
module funit16 (  
input wire [15:0] a ,
input wire [15:0] b ,
input wire [15:0] c ,
input wire [5:0] fcode ,
output reg [15:0] y ,
output reg [15:0] y1  
);
parameter true = 16'hFFFF, false = 16'h0000;
reg [15:0] y1_tmp, result;
reg [16:0] AVector, BVector, CVector, yVector;
integer i, ai;
	
always @(*)
   begin
    // Variables for mul/div
    AVector = {1'b0, a};  
    BVector = {1'b0, b};  
    CVector = {1'b0, c};  
    y1_tmp = false;
    yVector = {1'b0, false};
    y1 = false;
	case(fcode)  
	    6'b010000: 			// b+a
        	   y = b + a;
        	
      	6'b010001:			// b-a
        	   y = b - a; 
        	       
      	6'b010010:			// 1+
        	   y = a + 1;
		
      	6'b010011:			// 1-
        	   y = a - 1; 
        	       
	    6'b010100:			// invert
		   	   y = ~a;
		
	    6'b010101:			// AND
		   	   y = a & b;
		
      	6'b010110:			// OR
		       y = a | b; 
		 
      	6'b010111:			// XOR
		       y = a ^ b; 
		  
      	6'b011000:			// 2*
		   		y = {a[14:0], 1'b0}; 
		 
      	6'b011001:			// U2/
		   		y = {1'b0, a[15:1]}; 
		            	           
      	6'b011010:			// 2/
		   		y = {a[15], a[15:1]};
	
		6'b011011:			// RSHIFT 
			y = b >> a;  
 	
		6'b011100:			// LSHIFT  
			y = b << a;
		
/*		begin 
			  result = b;
			  for(i = 0; i < 4; i = i + 1)
				begin
				  ai = 2^i;
				  if(a[i] == 1)
						  begin	
							  y1_tmp = 0;
							  if(ai <= 3)
								  y1_tmp[15:ai] = result[15-ai:0];
							  result = y1_tmp;
						  end	  
				end
			  y = result;		   
		end	 
*/		
		
		6'b011101:  		// mpp  
 		   begin 
 	  		  if(b[0] == 1) 
         			yVector = AVector + CVector; 
       		  else 
         			yVector = AVector; 
         	  y = yVector[16:1]; 
         	  y1 = {yVector[0], b[15:1]};
		   end

		6'b011110:  		// shldc  
 		   begin 
	  		  yVector = {a, b[15]};  
	  		  y1_tmp = {b[14:0], 1'b0};  
	  		  if(yVector > CVector)
				 begin 
         			yVector = yVector - CVector;  
         			y1_tmp[0] = 1;  
	  		     end 
			  y = yVector[15:0];
			  y1 = y1_tmp; 
		   end
	  	
      	6'b100000:			// TRUE
		   		y = true;

		6'b100001:			// FALSE
		   		y = false;               

      	6'b100010:			// 0=
		   if(a == false)
			 	y = true;
		   else
				y = false;
		   
		
      	6'b100011:			// 0<
		   if(a[3] == 1)
				y = true;
		   else
				y = false;
		       	           
        6'b100100:			// U>	 unsigned comparison
        	if(b > a)
				y = true;
			else
				y = false;

       	6'b100101:			// U<	 unsigned comparison
        	if(b < a)
				y = true;
			else
				y = false;
		
   		6'b100110:			// =
        	if(b == a)
				y = true;
			else
				y = false;
        	
      	6'b100111:			// U>=
        	if(b >= a)
				y = true;
			else
				y = false;
				 
      	6'b101000:			// U<=
        	if(b <= a)
				y = true;
			else
				y = false;
		            	           
        6'b101001:			// <>
        	if(b != a)
				y = true;
			else
				y = false;
   
      	6'b101010:			// >	 signed comparison
        	if({~b[15], b[14:0]} > {~a[15], a[14:0]})
				y = true;
			else
				y = false;
			
    	6'b101011:			// <	 signed comparison
        	if({~b[15], b[14:0]} < {~a[15], a[14:0]})
				y = true;
			else
				y = false;
		
		6'b101100:			// >=	 signed comparison
        	if({~b[15], b[14:0]} >= {~a[15], a[14:0]})
				y = true;
			else
				y = false;
		       	           
      	6'b101101:			// <=	 signed comparison
        	if({~b[15], b[14:0]} <= {~a[15], a[14:0]})
				y = true;
			else
				y = false;
		   
		default: 
		   y = false;
  	endcase       
  end 
  
endmodule
