// Example 48: fc16_top
module fc16_top (  
input wire mclk ,
input wire [3:0] btn ,
input wire [7:0] sw ,
output wire [7:0] ld ,
output wire dp ,
output wire [6:0] a_to_g ,
output wire [3:0] an  
);
wire clk25, clk190, clr, digload, ldload;
wire [15:0] x, S, P, M, T, N, E1, E2;
wire [3:0] btnd;

assign clr = btn[3];
assign S = {8'b00000000, sw};

clkdiv U1 (.mclk(mclk),
	.clr(clr),
	.clk190(clk190),
	.clk25(clk25)
);

debounce4 U2 (.inp(btn),
	.cclk(clk190),
	.clr(clr),
	.outp(btnd)
);

fc16 U3 (.clr(clr),
	.clk(clk25),
	.S(S),
	.M(M),
	.E1(E1),
	.E2(E2),
	.B(btnd),
	.P(P),
	.digload(digload),
	.ldload(ldload),
	.N(N),
	.T(T)
);

fc16_prom U4 (.addr(P),
	.M(M)
);

register #(
	.N(16))
DigReg (.load(digload),
	.clk(clk25),
	.clr(clr),
	.d(T),
	.q(x)
);

register #(
	.N(16))
ldReg (.load(ldload),
	.clk(clk25),
	.clr(clr),
	.d(N[7:0]),
	.q(ld)
);

x7segb U7 (.x(x),
	.cclk(clk190),
	.clr(clr),
	.a_to_g(a_to_g),
	.an(an),
	.dp(dp)
);

endmodule
