// Example 54: fc16_prom.v	sqrt
module fc16_prom (  
input wire [15:0] addr ,
output wire [15:0] M  
);
`include "opcodes.h"

parameter N = 16;	   	// no. of bits in rom word
parameter N_WORDS = 45;	// no. of words in rom
reg [N-1:0] rom [0:N_WORDS-1];
parameter IXLEFT = N*N_WORDS - 1;	// left index of data
integer i;
parameter data = {
	jmp, 			//0
	16'h001c, 		//1
	lit, 			//2
	16'h0003, 		//3
	lit, 			//4
	16'h0001, 		//5
	rot, 			//6
	over, 			//7
	over, 			//8
	lte, 			//9
	jz, 			//a
	16'h0017, 		//b
	mrot, 			//c
	over, 			//d
	plus, 			//e
	swap, 			//f
	lit, 			//10
	16'h0002, 		//11
	plus, 			//12
	swap, 			//13
	rot, 			//14
	jmp, 			//15
	16'h0007, 		//16
	drop, 			//17
	drop, 			//18
	twoslash, 		//19
	minus1, 		//1a
	ret, 			//1b
	jb0HI, 			//1c
	16'h001c, 		//1d
	jb0LO, 			//1e
	16'h001e, 		//1f
	sfetch, 		//20
	dup, 			//21
	digstore, 		//22
	jb0HI, 			//23
	16'h0023, 		//24
	jb0LO, 			//25
	16'h0025, 		//26
	call, 			//27
	16'h0002, 		//28
	digstore, 		//29
	jmp, 			//2a
	16'h001c, 		//2b
	16'h0000 		//2c
	};
	
initial 
	begin 
		for(i = 0; i < N_WORDS; i = i + 1)
			rom[i] = data[(IXLEFT-N*i)-:N];
	end

assign M = rom[addr];

endmodule
