// Example 53: fc16_prom.v	gcd
module fc16_prom (  
input wire [15:0] addr ,
output wire [15:0] M  
);
`include "opcodes.h"

parameter N = 16;	   	// no. of bits in rom word
parameter N_WORDS = 47;	// no. of words in rom
reg [N-1:0] rom [0:N_WORDS-1];
parameter IXLEFT = N*N_WORDS - 1;	// left index of data
integer i;
parameter data = {
	jmp, 			//0
	16'h0017, 		//1
	over, 			//2
	over, 			//3
	neq, 			//4
	jz, 			//5
	16'h0015, 		//6
	over, 			//7
	over, 			//8
	lt, 			//9
	jz, 			//a
	16'h0010, 		//b
	over, 			//c
	minus, 			//d
	jmp, 			//e
	16'h0013, 		//f
	tuck, 			//10
	minus, 			//11
	swap, 			//12
	jmp, 			//13
	16'h0002, 		//14
	drop, 			//15
	ret, 			//16
	jb0HI, 			//17
	16'h0017, 		//18
	jb0LO, 			//19
	16'h0019, 		//1a
	sfetch, 		//1b
	dup, 			//1c
	digstore, 		//1d
	jb0HI, 			//1e
	16'h001e, 		//1f
	jb0LO, 			//20
	16'h0020, 		//21
	sfetch, 		//22
	dup, 			//23
	digstore, 		//24
	jb0HI, 			//25
	16'h0025, 		//26
	jb0LO, 			//27
	16'h0027, 		//28
	call, 			//29
	16'h0002, 		//2a
	digstore, 		//2b
	jmp, 			//2c
	16'h0017, 		//2d
	16'h0000 		//2e
};

initial 
	begin 
		for(i = 0; i < N_WORDS; i = i + 1)
			rom[i] = data[(IXLEFT-N*i)-:N];
	end

assign M = rom[addr];

endmodule
