// Example 52: begin FC16  Controller
module fc16_control (
input wire clr ,
input wire clk ,
input wire [15:0] icode ,
input wire [3: 0] B ,
input wire [15:0] T ,
input wire [15:0] M ,
input wire [15:0] R ,
output reg digload ,
output reg [5:0] fcode ,
output reg pinc ,
output reg tload ,
output reg nload ,
output reg pload ,
output reg iload ,
output reg ldload ,
output reg dpush ,
output reg dpop ,
output reg psel ,
output reg ssel ,
output reg rload ,
output reg rpush ,
output reg rpop ,
output reg rinsel ,
output reg rsel ,
output reg rdec ,
output reg [1:0] nsel ,
output reg [2:0] tsel  
);
`include "opcodes.h"

reg [1:0] current_state, next_state;
parameter fetch = 2'b00, exec = 2'b01, exec_fetch = 2'b10;
reg z, r1;

// State registers
always @(posedge clk or posedge clr)
  begin
  	if (clr == 1)
    	current_state = fetch;
  	else 
		current_state = next_state;
  end 

// C1 module
always @(*)
  begin
     case(current_state)
		fetch: if(M[8] == 1)
			    	next_state = exec;
			   else 	 
			    	next_state = exec_fetch;
		exec_fetch:  
		       if(M[8] == 1)
			    	next_state = exec;
			   else 	 
			    	next_state = exec_fetch;
		exec: next_state = fetch;
	default next_state = fetch;
   endcase		  
  end 
   
// C2
always @(*)
 begin 
	if(T == 0)
		z = 0;
	else
		z = 1;
	if(R == 1)
		r1 = 1;
	else
		r1 = 0;    
    // Initialize all outputs
    fcode = 6'b000000; tsel = 3'b000; pload = 0; tload = 0;
    nload = 0; digload = 0; pinc = 1; iload = 0;
    nsel = 2'b00; ssel = 0; rinsel = 0; rsel = 0;
    rload = 0; rdec = 0; rpush = 0; rpop = 0; 
    dpush = 0; dpop = 0; psel = 0;	ldload = 0;

    if((current_state == fetch) | (current_state == exec_fetch))
         iload = 1; 		// fetch next instruction 
	
    if((current_state == exec) | (current_state == exec_fetch))	
    case(icode)
      
      // Data Stack Instructions
      dup: begin  
         nload = 1; dpush = 1;
         end
      swap: begin 
         tload = 1; nload = 1; 
         tsel = 3'b111;
         end
         
      drop: begin
         tload = 1; nload = 1; 
         tsel = 3'b111; nsel = 2'b01;
         dpop = 1;     
         end
         
      over: begin
 	 	 tload = 1; nload = 1; 
         tsel = 3'b111; 
         dpush = 1;   
         end
                
      rot: begin
         tload = 1; nload = 1; 
         tsel = 3'b110; 
         dpush = 1; dpop = 1;  
         end
            
      mrot: begin 
         tload = 1; nload = 1; 
         tsel = 3'b111; nsel = 2'b01; ssel = 1;
         dpush = 1; dpop = 1;
         end
         
      nip: begin
         nload = 1; 
         nsel = 2'b01;
         dpop = 1; 
          end
        
      tuck: begin
         ssel = 1;
         dpush = 1; 
          end
        
      rot_drop: begin
         dpop = 1;
         end
         
      rot_drop_swap: begin
         tload = 1; nload = 1; 
         tsel = 3'b111; 
         dpop = 1;
         end
         
	// Function unit Instructions         
      plus: begin
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      minus: begin
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      plus1: begin
         tload = 1;  
	 	 fcode = icode[5:0];
         end
	 
      minus1: begin
         tload = 1;  
	 	 fcode = icode[5:0];
         end
	 
      invert: begin
         tload = 1;  
	 	 fcode = icode[5:0];
         end
	 
      andd: begin
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      orr: begin
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      xorr: begin
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      twotimes: begin
         tload = 1;  
	 	 fcode = icode[5:0];
         end
	 
      u2slash: begin
         tload = 1;  
	 	 fcode = icode[5:0];
         end
	 
      twoslash: begin
         tload = 1;  
	 	 fcode = icode[5:0];
         end
	 
      rshift: begin 			// RSHIFT
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;
	 	 fcode = icode[5:0];
         end
	 
      lshift: begin 			// LSHIFT
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;
	 	 fcode = icode[5:0];
         end
	 
      mpp: begin
         tload = 1; nload = 1; nsel = 2'b10; 
	 	 fcode = icode[5:0];
         end
	 
      shldc: begin
         tload = 1; nload = 1; nsel = 2'b10; 
	 	 fcode = icode[5:0];
         end

      ones: begin
         tload = 1; nload = 1; dpush = 1;
	 	 fcode = icode[5:0];
         end
	 
      zeros: begin
         tload = 1; nload = 1; dpush = 1; 
	 	 fcode = icode[5:0];
         end
	 
      zeroequal: begin			// true if T = 0
         tload = 1;   
	 	 fcode = icode[5:0];
         end
	 
      zeroless: begin				// true if T < 0
         tload = 1;  
	 	 fcode = icode[5:0];
         end
	 
      ult: begin 					// U<
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      ugt: begin 					// U>
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      eq: begin 					// =
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      ugte: begin 				// U>=
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      ulte: begin 				// U=
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      neq: begin 					// <>
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	  
      gt: begin 					// >
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      lt: begin 					// <
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      gte: begin 					// >=
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	 
      lte: begin 					// =
         tload = 1; nload = 1; 
         nsel = 2'b01;
         dpop = 1;  
	 	 fcode = icode[5:0];
         end
	  
	  	           	 
	// Return Stack, Memory Access, and I/O Instructions
      tor: begin
         tload = 1; nload = 1; 
         tsel = 3'b111; nsel = 2'b01;
         dpop = 1;
	 	 rload = 1; rpush = 1;
	 	 rinsel = 1;	 
         end
	 
      rfrom: begin
         tload = 1; nload = 1; 
         tsel = 3'b011; 
         dpush = 1;
	 	 rsel = 1; rload = 1; rpop = 1; 
         end
	 
      rfetch: begin
         tload = 1; nload = 1; 
         tsel = 3'b011; 
         dpush = 1;	 
          end
        
      rfromdrop: begin
	  	 rsel = 1; rload = 1; rpop = 1;
         end
	  
      romfetch1: begin			// read ROM in E1
         tload = 1;  
         tsel = 3'b100; 
         end
         	  	  	  
      romfetch2: begin		// read ROM in E2
         tload = 1;  
         tsel = 3'b101; 
          end
       	           	  
	  	  
      sfetch: begin			// read 8-bit S-bus
         tload = 1; nload = 1; 
         tsel = 3'b010; 
         dpush = 1;	
          end
                   	 
      digstore: begin			// store T to digreg and pop data stack
	 	 digload = 1;		
         tload = 1; nload = 1; 
         tsel = 3'b111; nsel = 2'b01;
         dpop = 1;     
         end
	   
      ldstore: begin			// store T to ldreg and pop data stack
	 	 ldload = 1;		
         tload = 1; nload = 1; 
         tsel = 3'b111; nsel = 2'b01;
         dpop = 1;     
         end

      // Literal, Transfer, multi-cycle instructions
      lit: begin
	 	 tload = 1; nload = 1; 
         tsel = 3'b001; 
         dpush = 1;
         end

      jmp: begin
	  	 pload = 1; psel = 0;
	  	 pinc = 0;
         end
	  
      jz: begin					// pop flag
	  	 pload = ~z; psel = 0;
	  	 pinc = z;
      	 tload = 1; nload = 1; 
      	 tsel = 3'b111; nsel = 2'b01;
      	 dpop = 1;     
         end
	  
      drjne: begin
	  	 rdec = ~r1;	
	  	 pload = ~r1; psel = 0;
	  	 pinc = r1;
	  	 rsel = r1;
	  	 rload = r1;
	  	 rpop = r1; 
         end
	  
      call: begin
	  	 pload = 1; 
	  	 rload = 1; 
	  	 rpush = 1;
         end
	  
      ret: begin
	  	 psel = 1;		
	  	 pload = 1;
	  	 rsel = 1;
	  	 rload = 1; rpop = 1;
         end
	  
      jb0LO: begin
	  	pload = ~B[0]; psel = 0;
	  	pinc = B[0];
         end
	  	   
     jb1LO: begin
	  	pload = ~B[1]; psel = 0;
	  	pinc = B[1];
         end
	  
     jb2LO: begin
	  	pload = ~B[2]; psel = 0;
	  	pinc = B[2];
         end
	  	  
     jb3LO: begin
	  	pload = ~B[3]; psel = 0;
	  	pinc = B[3];
         end
	  	  
     jb0HI: begin
	  	pload = B[0]; psel = 0;
	  	pinc = ~B[0];
         end
	  
     jb1HI: begin
	  	pload = B[1]; psel = 0;
	  	pinc = ~B[1];
         end
	  
     jb2HI: begin
	  	pload = B[2]; psel = 0;
	  	pinc = ~B[2];
         end
	  	  	
     jb3HI: begin
	  	pload = B[3]; psel = 0;
	  	pinc = ~B[3];
         end
	  	  	 		
     default ;
   endcase
end 

endmodule
