// Example 48b: FC16 core
module fc16 (  
input wire clr ,
input wire clk ,
input wire [15:0] S ,
input wire [15:0] M ,
input wire [15:0] E1 ,
input wire [15:0] E2 ,
input wire [3:0] B ,
output wire [15:0] P ,
output wire digload ,
output wire ldload ,
output wire [15:0] N ,  
output wire [15:0] T  
);
wire [15:0] Tin, Nout, Tout, Pin, icode;
wire [15:0] Rin, N2, R, Pout, P1, y, y1;
wire [5:0] fcode;
wire [1:0] nsel;
wire [2:0] tsel;
wire tload, nload, ssel, iload, dpush, dpop, pload, pinc;
wire rinsel, psel, rsel, rload, rdec, rpush, rpop;

assign N = Nout;
assign P1 = Pout + 1;
assign P = Pout;
assign T = Tout;

funit16 alu (.a(Tout),
	.b(Nout),
	.c(N2),
	.fcode(fcode),
	.y(y),
	.y1(y1)
);

mux8g #(
	.N(16))
tmux (.a(y),
	.b(M),
	.c(S),
	.d(R),
	.e(E1),
	.f(E2),
	.g(N2),
	.h(Nout),
	.sel(tsel),
	.z(Tin)
);

mux2g #(
	.N(16))
pmux (.a(M),
	.b(R),
	.s(psel),
	.y(Pin)
);

mux2g #(
	.N(16))
rmux (.a(P1),
	.b(Tout),
	.s(rinsel),
	.y(Rin)
);

fc16_control ctrl (.clr(clr),
	.clk(clk),
	.icode(icode),
	.B(B),
	.T(Tout),
	.M(M),
	.R(R),
	.digload(digload),
	.fcode(fcode),
	.pinc(pinc),
	.tload(tload),
	.nload(nload),
	.pload(pload),
	.iload(iload),
	.ldload(ldload),
	.dpush(dpush),
	.dpop(dpop),
	.psel(psel),
	.ssel(ssel),
	.rload(rload),
	.rpush(rpush),
	.rpop(rpop),
	.rinsel(rinsel),
	.rsel(rsel),
	.rdec(rdec),
	.nsel(nsel),
	.tsel(tsel)
);

pc pcount (.d(Pin),
	.pload(pload),
	.inc(pinc),
	.clr(clr),
	.clk(clk),
	.q(Pout)
);

register #(
	.N(16))
ireg (.load(iload),
	.clk(clk),
	.clr(clr),
	.d(M),
	.q(icode)
);

DataStack dstack (.Tin(Tin),
	.y1(y1),
	.nsel(nsel),
	.tload(tload),
	.nload(nload),
	.ssel(ssel),
	.clr(clr),
	.clk(clk),
	.dpush(dpush),
	.dpop(dpop),
	.N2(N2),
	.N(Nout),
	.T(Tout)
);

returnStack rstack (.Rin(Rin),
	.rsel(rsel),
	.rload(rload),
	.rdec(rdec),
	.clr(clr),
	.clk(clk),
	.rpush(rpush),
	.rpop(rpop),
	.R(R)
);

endmodule
