// Example 49: FC16 - DataStack.v
module DataStack (  
input wire [15:0] Tin ,
input wire [15:0] y1 ,
input wire [1:0] nsel ,
input wire tload ,
input wire nload ,
input wire ssel ,
input wire clr ,
input wire clk ,
input wire dpush ,
input wire dpop ,
output wire [15:0] N2 ,  
output wire [15:0] N ,  
output wire [15:0] T  
);
wire [15:0] T1, N1, Nin, N2_int, D1;

assign N = N1;
assign N2 = N2_int;
assign T = T1;

register #(
	.N(16))
Treg (.load(tload),
	.clk(clk),
	.clr(clr),
	.d(Tin),
	.q(T1)
);

register #(
	.N(16))
Nreg (.load(nload),
	.clk(clk),
	.clr(clr),
	.d(Nin),
	.q(N1)
);

mux4g #(
	.N(16))
Nmux (.a(T1),
	.b(N2_int),
	.c(y1),
	.d(0),
	.s(nsel),
	.z(Nin)
);

mux2g #(
	.N(16))
Smux (.a(N1),
	.b(T1),
	.s(ssel),
	.y(D1)
);

// note the text has open for both wires, causing short.  Should be seperated.
// dummy wires
wire open1;
wire open2;
stack32x16 stack1
(.clk(clk),
.clr(clr),
.push(dpush),
.pop(dpop),
.d(D1),
.full(open1),
.empty(open2),
.q(N2_int)
);



endmodule
