function img2 = IMG2ExtMem(imgfile, outfile)
% Convert a .jpg image to 8-bit color
% and save it as a binary file (.exm) 
% for loading to external memory (ram or flash)
% each word contains two 8-bit pixels
% color byte: [R2,R1,R0,G2,G1,G0,B1,B0]
% img2 = Img2ExtMem(imgfile, outfile)
% img2 is 256-bit color image
% imgfile = input .jpg file
% outfile = output .exm file
% Example:
% img2 = IMG2ExtMem('loons640x480.jpg', 'loons640x480.exm');

img = imread(imgfile);
height = size(img, 1)
width = size(img, 2)
   
s = fopen(outfile,'wb');  %opens the output file

cnt = 0;

img2 = img;

for r=1:height
    for c=1:width
        cnt = cnt + 1;
        R = img(r,c,1);
        G = img(r,c,2);
        B = img(r,c,3);
        Rb = dec2bin(R,8);
        Gb = dec2bin(G,8);
        Bb = dec2bin(B,8);
        img2(r,c,1) = bin2dec([Rb(1:3) '00000']);
        img2(r,c,2) = bin2dec([Gb(1:3) '00000']);
        img2(r,c,3) = bin2dec([Bb(1:2) '000000']);
        Outbyte = [ Rb(1:3) Gb(1:3) Bb(1:2) ];
        fwrite(s,uint8(bin2dec(Outbyte)),'uint8');
    end
end

fclose(s);




