/* Based on CPU DB MC9S12XHY256_112, version 3.00.000 (RegistersPrg V2.32) */
/* DataSheet : MC9S12XHY256RMV1 Rev. 0.11 06/2010 */

#include <mc9s12xhy256.h>

/*lint -save -esym(765, *) */


/* * * * *  8-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile MODESTR _MODE;                                    /* Mode Register; 0x0000000B */
volatile PUCRSTR _PUCR;                                    /* Pull-Up Control Register; 0x0000000C */
volatile GPAGESTR _GPAGE;                                  /* Global Page Index Register; 0x00000010 */
volatile DIRECTSTR _DIRECT;                                /* Direct Page Register; 0x00000011 */
volatile MMCCTL1STR _MMCCTL1;                              /* MMC Control Register; 0x00000013 */
volatile PPAGESTR _PPAGE;                                  /* Program Page Index Register; 0x00000015 */
volatile RPAGESTR _RPAGE;                                  /* RAM Page Index Register; 0x00000016 */
volatile EPAGESTR _EPAGE;                                  /* Data FLASH Page Index Register; 0x00000017 */
volatile ECLKCTLSTR _ECLKCTL;                              /* ECLK Control Register; 0x0000001C */
volatile IRQCRSTR _IRQCR;                                  /* Interrupt Control Register; 0x0000001E */
volatile DBGC1STR _DBGC1;                                  /* Debug Control Register 1; 0x00000020 */
volatile DBGSRSTR _DBGSR;                                  /* Debug Status Register; 0x00000021 */
volatile DBGTCRSTR _DBGTCR;                                /* Debug Trace Control Register; 0x00000022 */
volatile DBGC2STR _DBGC2;                                  /* Debug Control Register 2; 0x00000023 */
volatile DBGCNTSTR _DBGCNT;                                /* Debug Count Register; 0x00000026 */
volatile DBGSCRXSTR _DBGSCRX;                              /* Debug State Control Register; 0x00000027 */
volatile DBGXCTLSTR _DBGXCTL;                              /* Debug Comparator Control Register; 0x00000028 */
volatile DBGXAHSTR _DBGXAH;                                /* Debug Comparator Address High Register; 0x00000029 */
volatile DBGXAMSTR _DBGXAM;                                /* Debug Comparator Address Mid Register; 0x0000002A */
volatile DBGXALSTR _DBGXAL;                                /* Debug Comparator Address Low Register; 0x0000002B */
volatile DBGXDHSTR _DBGXDH;                                /* Debug Comparator Data High Register; 0x0000002C */
volatile DBGXDLSTR _DBGXDL;                                /* Debug Comparator Data Low Register; 0x0000002D */
volatile DBGXDHMSTR _DBGXDHM;                              /* Debug Comparator Data High Mask Register; 0x0000002E */
volatile DBGXDLMSTR _DBGXDLM;                              /* Debug Comparator Data Low Mask Register; 0x0000002F */
volatile SYNRSTR _SYNR;                                    /* S12XECRG Synthesizer Register; 0x00000034 */
volatile REFDVSTR _REFDV;                                  /* S12XECRG Reference Divider Register; 0x00000035 */
volatile POSTDIVSTR _POSTDIV;                              /* S12XECRG Post Divider Register; 0x00000036 */
volatile CRGFLGSTR _CRGFLG;                                /* S12XECRG Flags Register; 0x00000037 */
volatile CRGINTSTR _CRGINT;                                /* S12XECRG Interrupt Enable Register; 0x00000038 */
volatile CLKSELSTR _CLKSEL;                                /* S12XECRG Clock Select Register; 0x00000039 */
volatile PLLCTLSTR _PLLCTL;                                /* S12XECRG IPLL Control Register; 0x0000003A */
volatile RTICTLSTR _RTICTL;                                /* ECRG RTI Control Register; 0x0000003B */
volatile COPCTLSTR _COPCTL;                                /* CRG COP Control Register; 0x0000003C */
volatile ARMCOPSTR _ARMCOP;                                /* CRG COP Timer Arm/Reset Register; 0x0000003F */
volatile TIM0_TIOSSTR _TIM0_TIOS;                          /* Timer Input Capture/Output Compare Select; 0x00000040 */
volatile TIM0_CFORCSTR _TIM0_CFORC;                        /* Timer Compare Force Register; 0x00000041 */
volatile TIM0_OC7MSTR _TIM0_OC7M;                          /* Output Compare 7 Mask Register; 0x00000042 */
volatile TIM0_OC7DSTR _TIM0_OC7D;                          /* Output Compare 7 Data Register; 0x00000043 */
volatile TIM0_TSCR1STR _TIM0_TSCR1;                        /* Timer System Control Register1; 0x00000046 */
volatile TIM0_TTOVSTR _TIM0_TTOV;                          /* Timer Toggle On Overflow Register; 0x00000047 */
volatile TIM0_TCTL1STR _TIM0_TCTL1;                        /* Timer Control Register 1; 0x00000048 */
volatile TIM0_TCTL2STR _TIM0_TCTL2;                        /* Timer Control Register 2; 0x00000049 */
volatile TIM0_TCTL3STR _TIM0_TCTL3;                        /* Timer Control Register 3; 0x0000004A */
volatile TIM0_TCTL4STR _TIM0_TCTL4;                        /* Timer Control Register 4; 0x0000004B */
volatile TIM0_TIESTR _TIM0_TIE;                            /* Timer Interrupt Enable Register; 0x0000004C */
volatile TIM0_TSCR2STR _TIM0_TSCR2;                        /* Timer System Control Register 2; 0x0000004D */
volatile TIM0_TFLG1STR _TIM0_TFLG1;                        /* Main Timer Interrupt Flag 1; 0x0000004E */
volatile TIM0_TFLG2STR _TIM0_TFLG2;                        /* Main Timer Interrupt Flag 2; 0x0000004F */
volatile TIM0_PACTLSTR _TIM0_PACTL;                        /* 16-Bit Pulse Accumulator A Control Register; 0x00000060 */
volatile TIM0_PAFLGSTR _TIM0_PAFLG;                        /* Pulse Accumulator A Flag Register; 0x00000061 */
volatile TIM0_OCPDSTR _TIM0_OCPD;                          /* Output Compare Pin Disconnect Register; 0x0000006C */
volatile TIM0_PTPSRSTR _TIM0_PTPSR;                        /* Precision Timer Prescaler Select Register; 0x0000006E */
volatile ATDSTAT0STR _ATDSTAT0;                            /* ATD  Status Register 0; 0x00000076 */
volatile PWMESTR _PWME;                                    /* PWM Enable Register; 0x000000A0 */
volatile PWMPOLSTR _PWMPOL;                                /* PWM Polarity Register; 0x000000A1 */
volatile PWMCLKSTR _PWMCLK;                                /* PWM Clock Select Register; 0x000000A2 */
volatile PWMPRCLKSTR _PWMPRCLK;                            /* PWM Prescale Clock Select Register; 0x000000A3 */
volatile PWMCAESTR _PWMCAE;                                /* PWM Center Align Enable Register; 0x000000A4 */
volatile PWMCTLSTR _PWMCTL;                                /* PWM Control Register; 0x000000A5 */
volatile PWMSCLASTR _PWMSCLA;                              /* PWM Scale A Register; 0x000000A8 */
volatile PWMSCLBSTR _PWMSCLB;                              /* PWM Scale B Register; 0x000000A9 */
volatile PWMSDNSTR _PWMSDN;                                /* PWM Shutdown Register; 0x000000C4 */
volatile SCI0ACR2STR _SCI0ACR2;                            /* SCI 0 Alternative Control Register 2; 0x000000CA */
volatile SCI0CR2STR _SCI0CR2;                              /* SCI 0 Control Register 2; 0x000000CB */
volatile SCI0SR1STR _SCI0SR1;                              /* SCI 0 Status Register 1; 0x000000CC */
volatile SCI0SR2STR _SCI0SR2;                              /* SCI 0 Status Register 2; 0x000000CD */
volatile SCI0DRHSTR _SCI0DRH;                              /* SCI 0 Data Register High; 0x000000CE */
volatile SCI0DRLSTR _SCI0DRL;                              /* SCI 0 Data Register Low; 0x000000CF */
volatile SCI1ACR2STR _SCI1ACR2;                            /* SCI 1 Alternative Control Register 2; 0x000000D2 */
volatile SCI1CR2STR _SCI1CR2;                              /* SCI 1 Control Register 2; 0x000000D3 */
volatile SCI1SR1STR _SCI1SR1;                              /* SCI 1 Status Register 1; 0x000000D4 */
volatile SCI1SR2STR _SCI1SR2;                              /* SCI 1 Status Register 2; 0x000000D5 */
volatile SCI1DRHSTR _SCI1DRH;                              /* SCI 1 Data Register High; 0x000000D6 */
volatile SCI1DRLSTR _SCI1DRL;                              /* SCI 1 Data Register Low; 0x000000D7 */
volatile SPICR1STR _SPICR1;                                /* SPI  Control Register 1; 0x000000D8 */
volatile SPICR2STR _SPICR2;                                /* SPI  Control Register 2; 0x000000D9 */
volatile SPIBRSTR _SPIBR;                                  /* SPI  Baud Rate Register; 0x000000DA */
volatile SPISRSTR _SPISR;                                  /* SPI  Status Register; 0x000000DB */
volatile IIC_IBADSTR _IIC_IBAD;                            /* IIC Address Register; 0x000000E0 */
volatile IIC_IBFDSTR _IIC_IBFD;                            /* IIC Frequency Divider Register; 0x000000E1 */
volatile IIC_IBCRSTR _IIC_IBCR;                            /* IIC Control Register; 0x000000E2 */
volatile IIC_IBSRSTR _IIC_IBSR;                            /* IIC Status Register; 0x000000E3 */
volatile IIC_IBDRSTR _IIC_IBDR;                            /* IIC Data I/O Register; 0x000000E4 */
volatile IIC_IBCR2STR _IIC_IBCR2;                          /* IIC Control Register 2; 0x000000E5 */
volatile FCLKDIVSTR _FCLKDIV;                              /* Flash Clock Divider Register; 0x00000100 */
volatile FSECSTR _FSEC;                                    /* Flash Security Register; 0x00000101 */
volatile FCCOBIXSTR _FCCOBIX;                              /* Flash CCOB Index Register; 0x00000102 */
volatile FECCRIXSTR _FECCRIX;                              /* Flash ECCR Index Register; 0x00000103 */
volatile FCNFGSTR _FCNFG;                                  /* Flash Configuration Register; 0x00000104 */
volatile FERCNFGSTR _FERCNFG;                              /* Flash Error Configuration Register; 0x00000105 */
volatile FSTATSTR _FSTAT;                                  /* Flash Status Register; 0x00000106 */
volatile FERSTATSTR _FERSTAT;                              /* Flash Error Status Register; 0x00000107 */
volatile FPROTSTR _FPROT;                                  /* P-Flash Protection Register; 0x00000108 */
volatile DFPROTSTR _DFPROT;                                /* D-Flash Protection Register; 0x00000109 */
volatile FOPTSTR _FOPT;                                    /* Flash Option Register; 0x00000110 */
volatile IVBRSTR _IVBR;                                    /* Interrupt Vector Base Register; 0x00000121 */
volatile INT_XGPRIOSTR _INT_XGPRIO;                        /* XGATE Interrupt Priority Configuration Register; 0x00000126 */
volatile INT_CFADDRSTR _INT_CFADDR;                        /* Interrupt Request Configuration Address Register; 0x00000127 */
volatile INT_CFDATA0STR _INT_CFDATA0;                      /* Interrupt Request Configuration Data Register 0; 0x00000128 */
volatile INT_CFDATA1STR _INT_CFDATA1;                      /* Interrupt Request Configuration Data Register 1; 0x00000129 */
volatile INT_CFDATA2STR _INT_CFDATA2;                      /* Interrupt Request Configuration Data Register 2; 0x0000012A */
volatile INT_CFDATA3STR _INT_CFDATA3;                      /* Interrupt Request Configuration Data Register 3; 0x0000012B */
volatile INT_CFDATA4STR _INT_CFDATA4;                      /* Interrupt Request Configuration Data Register 4; 0x0000012C */
volatile INT_CFDATA5STR _INT_CFDATA5;                      /* Interrupt Request Configuration Data Register 5; 0x0000012D */
volatile INT_CFDATA6STR _INT_CFDATA6;                      /* Interrupt Request Configuration Data Register 6; 0x0000012E */
volatile INT_CFDATA7STR _INT_CFDATA7;                      /* Interrupt Request Configuration Data Register 7; 0x0000012F */
volatile CAN0CTL0STR _CAN0CTL0;                            /* MSCAN0 Control 0 Register; 0x00000140 */
volatile CAN0CTL1STR _CAN0CTL1;                            /* MSCAN0 Control 1 Register; 0x00000141 */
volatile CAN0BTR0STR _CAN0BTR0;                            /* MSCAN0 Bus Timing Register 0; 0x00000142 */
volatile CAN0BTR1STR _CAN0BTR1;                            /* MSCAN0 Bus Timing Register 1; 0x00000143 */
volatile CAN0RFLGSTR _CAN0RFLG;                            /* MSCAN0 Receiver Flag Register; 0x00000144 */
volatile CAN0RIERSTR _CAN0RIER;                            /* MSCAN0 Receiver Interrupt Enable Register; 0x00000145 */
volatile CAN0TFLGSTR _CAN0TFLG;                            /* MSCAN0 Transmitter Flag Register; 0x00000146 */
volatile CAN0TIERSTR _CAN0TIER;                            /* MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 */
volatile CAN0TARQSTR _CAN0TARQ;                            /* MSCAN0 Transmitter Message Abort Request; 0x00000148 */
volatile CAN0TAAKSTR _CAN0TAAK;                            /* MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 */
volatile CAN0TBSELSTR _CAN0TBSEL;                          /* MSCAN0 Transmit Buffer Selection; 0x0000014A */
volatile CAN0IDACSTR _CAN0IDAC;                            /* MSCAN0 Identifier Acceptance Control Register; 0x0000014B */
volatile CAN0MISCSTR _CAN0MISC;                            /* MSCAN0 Miscellaneous Register; 0x0000014D */
volatile CAN0RXERRSTR _CAN0RXERR;                          /* MSCAN0 Receive Error Counter Register; 0x0000014E */
volatile CAN0TXERRSTR _CAN0TXERR;                          /* MSCAN0 Transmit Error Counter Register; 0x0000014F */
volatile CAN0IDAR0STR _CAN0IDAR0;                          /* MSCAN0 Identifier Acceptance Register 0; 0x00000150 */
volatile CAN0IDAR1STR _CAN0IDAR1;                          /* MSCAN0 Identifier Acceptance Register 1; 0x00000151 */
volatile CAN0IDAR2STR _CAN0IDAR2;                          /* MSCAN0 Identifier Acceptance Register 2; 0x00000152 */
volatile CAN0IDAR3STR _CAN0IDAR3;                          /* MSCAN0 Identifier Acceptance Register 3; 0x00000153 */
volatile CAN0IDMR0STR _CAN0IDMR0;                          /* MSCAN0 Identifier Mask Register 0; 0x00000154 */
volatile CAN0IDMR1STR _CAN0IDMR1;                          /* MSCAN0 Identifier Mask Register 1; 0x00000155 */
volatile CAN0IDMR2STR _CAN0IDMR2;                          /* MSCAN0 Identifier Mask Register 2; 0x00000156 */
volatile CAN0IDMR3STR _CAN0IDMR3;                          /* MSCAN0 Identifier Mask Register 3; 0x00000157 */
volatile CAN0IDAR4STR _CAN0IDAR4;                          /* MSCAN0 Identifier Acceptance Register 4; 0x00000158 */
volatile CAN0IDAR5STR _CAN0IDAR5;                          /* MSCAN0 Identifier Acceptance Register 5; 0x00000159 */
volatile CAN0IDAR6STR _CAN0IDAR6;                          /* MSCAN0 Identifier Acceptance Register 6; 0x0000015A */
volatile CAN0IDAR7STR _CAN0IDAR7;                          /* MSCAN0 Identifier Acceptance Register 7; 0x0000015B */
volatile CAN0IDMR4STR _CAN0IDMR4;                          /* MSCAN0 Identifier Mask Register 4; 0x0000015C */
volatile CAN0IDMR5STR _CAN0IDMR5;                          /* MSCAN0 Identifier Mask Register 5; 0x0000015D */
volatile CAN0IDMR6STR _CAN0IDMR6;                          /* MSCAN0 Identifier Mask Register 6; 0x0000015E */
volatile CAN0IDMR7STR _CAN0IDMR7;                          /* MSCAN0 Identifier Mask Register 7; 0x0000015F */
volatile CAN0RXIDR0STR _CAN0RXIDR0;                        /* MSCAN0 Receive Identifier Register 0; 0x00000160 */
volatile CAN0RXIDR1STR _CAN0RXIDR1;                        /* MSCAN0 Receive Identifier Register 1; 0x00000161 */
volatile CAN0RXIDR2STR _CAN0RXIDR2;                        /* MSCAN0 Receive Identifier Register 2; 0x00000162 */
volatile CAN0RXIDR3STR _CAN0RXIDR3;                        /* MSCAN0 Receive Identifier Register 3; 0x00000163 */
volatile CAN0RXDSR0STR _CAN0RXDSR0;                        /* MSCAN0 Receive Data Segment Register 0; 0x00000164 */
volatile CAN0RXDSR1STR _CAN0RXDSR1;                        /* MSCAN0 Receive Data Segment Register 1; 0x00000165 */
volatile CAN0RXDSR2STR _CAN0RXDSR2;                        /* MSCAN0 Receive Data Segment Register 2; 0x00000166 */
volatile CAN0RXDSR3STR _CAN0RXDSR3;                        /* MSCAN0 Receive Data Segment Register 3; 0x00000167 */
volatile CAN0RXDSR4STR _CAN0RXDSR4;                        /* MSCAN0 Receive Data Segment Register 4; 0x00000168 */
volatile CAN0RXDSR5STR _CAN0RXDSR5;                        /* MSCAN0 Receive Data Segment Register 5; 0x00000169 */
volatile CAN0RXDSR6STR _CAN0RXDSR6;                        /* MSCAN0 Receive Data Segment Register 6; 0x0000016A */
volatile CAN0RXDSR7STR _CAN0RXDSR7;                        /* MSCAN0 Receive Data Segment Register 7; 0x0000016B */
volatile CAN0RXDLRSTR _CAN0RXDLR;                          /* MSCAN0 Receive Data Length Register; 0x0000016C */
volatile CAN0TXIDR0STR _CAN0TXIDR0;                        /* MSCAN0 Transmit Identifier Register 0; 0x00000170 */
volatile CAN0TXIDR1STR _CAN0TXIDR1;                        /* MSCAN0 Transmit Identifier Register 1; 0x00000171 */
volatile CAN0TXIDR2STR _CAN0TXIDR2;                        /* MSCAN0 Transmit Identifier Register 2; 0x00000172 */
volatile CAN0TXIDR3STR _CAN0TXIDR3;                        /* MSCAN0 Transmit Identifier Register 3; 0x00000173 */
volatile CAN0TXDSR0STR _CAN0TXDSR0;                        /* MSCAN0 Transmit Data Segment Register 0; 0x00000174 */
volatile CAN0TXDSR1STR _CAN0TXDSR1;                        /* MSCAN0 Transmit Data Segment Register 1; 0x00000175 */
volatile CAN0TXDSR2STR _CAN0TXDSR2;                        /* MSCAN0 Transmit Data Segment Register 2; 0x00000176 */
volatile CAN0TXDSR3STR _CAN0TXDSR3;                        /* MSCAN0 Transmit Data Segment Register 3; 0x00000177 */
volatile CAN0TXDSR4STR _CAN0TXDSR4;                        /* MSCAN0 Transmit Data Segment Register 4; 0x00000178 */
volatile CAN0TXDSR5STR _CAN0TXDSR5;                        /* MSCAN0 Transmit Data Segment Register 5; 0x00000179 */
volatile CAN0TXDSR6STR _CAN0TXDSR6;                        /* MSCAN0 Transmit Data Segment Register 6; 0x0000017A */
volatile CAN0TXDSR7STR _CAN0TXDSR7;                        /* MSCAN0 Transmit Data Segment Register 7; 0x0000017B */
volatile CAN0TXDLRSTR _CAN0TXDLR;                          /* MSCAN0 Transmit Data Length Register; 0x0000017C */
volatile CAN0TXTBPRSTR _CAN0TXTBPR;                        /* MSCAN0 Transmit Buffer Priority; 0x0000017D */
volatile CAN1CTL0STR _CAN1CTL0;                            /* MSCAN1 Control 0 Register; 0x00000180 */
volatile CAN1CTL1STR _CAN1CTL1;                            /* MSCAN1 Control 1 Register; 0x00000181 */
volatile CAN1BTR0STR _CAN1BTR0;                            /* MSCAN1 Bus Timing Register 0; 0x00000182 */
volatile CAN1BTR1STR _CAN1BTR1;                            /* MSCAN1 Bus Timing Register 1; 0x00000183 */
volatile CAN1RFLGSTR _CAN1RFLG;                            /* MSCAN1 Receiver Flag Register; 0x00000184 */
volatile CAN1RIERSTR _CAN1RIER;                            /* MSCAN1 Receiver Interrupt Enable Register; 0x00000185 */
volatile CAN1TFLGSTR _CAN1TFLG;                            /* MSCAN1 Transmitter Flag Register; 0x00000186 */
volatile CAN1TIERSTR _CAN1TIER;                            /* MSCAN1 Transmitter Interrupt Enable Register; 0x00000187 */
volatile CAN1TARQSTR _CAN1TARQ;                            /* MSCAN1 Transmitter Message Abort Request; 0x00000188 */
volatile CAN1TAAKSTR _CAN1TAAK;                            /* MSCAN1 Transmitter Message Abort Acknowledge; 0x00000189 */
volatile CAN1TBSELSTR _CAN1TBSEL;                          /* MSCAN1 Transmit Buffer Selection; 0x0000018A */
volatile CAN1IDACSTR _CAN1IDAC;                            /* MSCAN1 Identifier Acceptance Control Register; 0x0000018B */
volatile CAN1MISCSTR _CAN1MISC;                            /* MSCAN1 Miscellaneous Register; 0x0000018D */
volatile CAN1RXERRSTR _CAN1RXERR;                          /* MSCAN1 Receive Error Counter Register; 0x0000018E */
volatile CAN1TXERRSTR _CAN1TXERR;                          /* MSCAN1 Transmit Error Counter Register; 0x0000018F */
volatile CAN1IDAR0STR _CAN1IDAR0;                          /* MSCAN1 Identifier Acceptance Register 0; 0x00000190 */
volatile CAN1IDAR1STR _CAN1IDAR1;                          /* MSCAN1 Identifier Acceptance Register 1; 0x00000191 */
volatile CAN1IDAR2STR _CAN1IDAR2;                          /* MSCAN1 Identifier Acceptance Register 2; 0x00000192 */
volatile CAN1IDAR3STR _CAN1IDAR3;                          /* MSCAN1 Identifier Acceptance Register 3; 0x00000193 */
volatile CAN1IDMR0STR _CAN1IDMR0;                          /* MSCAN1 Identifier Mask Register 0; 0x00000194 */
volatile CAN1IDMR1STR _CAN1IDMR1;                          /* MSCAN1 Identifier Mask Register 1; 0x00000195 */
volatile CAN1IDMR2STR _CAN1IDMR2;                          /* MSCAN1 Identifier Mask Register 2; 0x00000196 */
volatile CAN1IDMR3STR _CAN1IDMR3;                          /* MSCAN1 Identifier Mask Register 3; 0x00000197 */
volatile CAN1IDAR4STR _CAN1IDAR4;                          /* MSCAN1 Identifier Acceptance Register 4; 0x00000198 */
volatile CAN1IDAR5STR _CAN1IDAR5;                          /* MSCAN1 Identifier Acceptance Register 5; 0x00000199 */
volatile CAN1IDAR6STR _CAN1IDAR6;                          /* MSCAN1 Identifier Acceptance Register 6; 0x0000019A */
volatile CAN1IDAR7STR _CAN1IDAR7;                          /* MSCAN1 Identifier Acceptance Register 7; 0x0000019B */
volatile CAN1IDMR4STR _CAN1IDMR4;                          /* MSCAN1 Identifier Mask Register 4; 0x0000019C */
volatile CAN1IDMR5STR _CAN1IDMR5;                          /* MSCAN1 Identifier Mask Register 5; 0x0000019D */
volatile CAN1IDMR6STR _CAN1IDMR6;                          /* MSCAN1 Identifier Mask Register 6; 0x0000019E */
volatile CAN1IDMR7STR _CAN1IDMR7;                          /* MSCAN1 Identifier Mask Register 7; 0x0000019F */
volatile CAN1RXIDR0STR _CAN1RXIDR0;                        /* MSCAN1 Receive Identifier Register 0; 0x000001A0 */
volatile CAN1RXIDR1STR _CAN1RXIDR1;                        /* MSCAN1 Receive Identifier Register 1; 0x000001A1 */
volatile CAN1RXIDR2STR _CAN1RXIDR2;                        /* MSCAN1 Receive Identifier Register 2; 0x000001A2 */
volatile CAN1RXIDR3STR _CAN1RXIDR3;                        /* MSCAN1 Receive Identifier Register 3; 0x000001A3 */
volatile CAN1RXDSR0STR _CAN1RXDSR0;                        /* MSCAN1 Receive Data Segment Register 0; 0x000001A4 */
volatile CAN1RXDSR1STR _CAN1RXDSR1;                        /* MSCAN1 Receive Data Segment Register 1; 0x000001A5 */
volatile CAN1RXDSR2STR _CAN1RXDSR2;                        /* MSCAN1 Receive Data Segment Register 2; 0x000001A6 */
volatile CAN1RXDSR3STR _CAN1RXDSR3;                        /* MSCAN1 Receive Data Segment Register 3; 0x000001A7 */
volatile CAN1RXDSR4STR _CAN1RXDSR4;                        /* MSCAN1 Receive Data Segment Register 4; 0x000001A8 */
volatile CAN1RXDSR5STR _CAN1RXDSR5;                        /* MSCAN1 Receive Data Segment Register 5; 0x000001A9 */
volatile CAN1RXDSR6STR _CAN1RXDSR6;                        /* MSCAN1 Receive Data Segment Register 6; 0x000001AA */
volatile CAN1RXDSR7STR _CAN1RXDSR7;                        /* MSCAN1 Receive Data Segment Register 7; 0x000001AB */
volatile CAN1RXDLRSTR _CAN1RXDLR;                          /* MSCAN1 Receive Data Length Register; 0x000001AC */
volatile CAN1TXIDR0STR _CAN1TXIDR0;                        /* MSCAN1 Transmit Identifier Register 0; 0x000001B0 */
volatile CAN1TXIDR1STR _CAN1TXIDR1;                        /* MSCAN1 Transmit Identifier Register 1; 0x000001B1 */
volatile CAN1TXIDR2STR _CAN1TXIDR2;                        /* MSCAN1 Transmit Identifier Register 2; 0x000001B2 */
volatile CAN1TXIDR3STR _CAN1TXIDR3;                        /* MSCAN1 Transmit Identifier Register 3; 0x000001B3 */
volatile CAN1TXDSR0STR _CAN1TXDSR0;                        /* MSCAN1 Transmit Data Segment Register 0; 0x000001B4 */
volatile CAN1TXDSR1STR _CAN1TXDSR1;                        /* MSCAN1 Transmit Data Segment Register 1; 0x000001B5 */
volatile CAN1TXDSR2STR _CAN1TXDSR2;                        /* MSCAN1 Transmit Data Segment Register 2; 0x000001B6 */
volatile CAN1TXDSR3STR _CAN1TXDSR3;                        /* MSCAN1 Transmit Data Segment Register 3; 0x000001B7 */
volatile CAN1TXDSR4STR _CAN1TXDSR4;                        /* MSCAN1 Transmit Data Segment Register 4; 0x000001B8 */
volatile CAN1TXDSR5STR _CAN1TXDSR5;                        /* MSCAN1 Transmit Data Segment Register 5; 0x000001B9 */
volatile CAN1TXDSR6STR _CAN1TXDSR6;                        /* MSCAN1 Transmit Data Segment Register 6; 0x000001BA */
volatile CAN1TXDSR7STR _CAN1TXDSR7;                        /* MSCAN1 Transmit Data Segment Register 7; 0x000001BB */
volatile CAN1TXDLRSTR _CAN1TXDLR;                          /* MSCAN1 Transmit Data Length Register; 0x000001BC */
volatile CAN1TXTBPRSTR _CAN1TXTBPR;                        /* MSCAN1 Transmit Buffer Priority; 0x000001BD */
volatile MCCTL0STR _MCCTL0;                                /* Motor Controller Control Register 0; 0x000001C0 */
volatile MCCTL1STR _MCCTL1;                                /* Motor Controller Control Register 1; 0x000001C1 */
volatile MCCC0STR _MCCC0;                                  /* Motor Controller Control Register 0; 0x000001D0 */
volatile MCCC1STR _MCCC1;                                  /* Motor Controller Control Register 1; 0x000001D1 */
volatile MCCC2STR _MCCC2;                                  /* Motor Controller Control Register 2; 0x000001D2 */
volatile MCCC3STR _MCCC3;                                  /* Motor Controller Control Register 3; 0x000001D3 */
volatile MCCC4STR _MCCC4;                                  /* Motor Controller Control Register 4; 0x000001D4 */
volatile MCCC5STR _MCCC5;                                  /* Motor Controller Control Register 5; 0x000001D5 */
volatile MCCC6STR _MCCC6;                                  /* Motor Controller Control Register 6; 0x000001D6 */
volatile MCCC7STR _MCCC7;                                  /* Motor Controller Control Register 7; 0x000001D7 */
volatile LCDCR0STR _LCDCR0;                                /* LCD Control Register 0; 0x00000200 */
volatile LCDCR1STR _LCDCR1;                                /* LCD Control Register 1; 0x00000201 */
volatile FPENR0STR _FPENR0;                                /* LCD Frontplane Enable Register 0; 0x00000202 */
volatile FPENR1STR _FPENR1;                                /* LCD Frontplane Enable Register 1; 0x00000203 */
volatile FPENR2STR _FPENR2;                                /* LCD Frontplane Enable Register 2; 0x00000204 */
volatile FPENR3STR _FPENR3;                                /* LCD Frontplane Enable Register 3; 0x00000205 */
volatile FPENR4STR _FPENR4;                                /* LCD Frontplane Enable Register 4; 0x00000206 */
volatile LCDRAM0STR _LCDRAM0;                              /* LCD RAM 0; 0x00000208 */
volatile LCDRAM1STR _LCDRAM1;                              /* LCD RAM 1; 0x00000209 */
volatile LCDRAM2STR _LCDRAM2;                              /* LCD RAM 2; 0x0000020A */
volatile LCDRAM3STR _LCDRAM3;                              /* LCD RAM 3; 0x0000020B */
volatile LCDRAM4STR _LCDRAM4;                              /* LCD RAM 4; 0x0000020C */
volatile LCDRAM5STR _LCDRAM5;                              /* LCD RAM 5; 0x0000020D */
volatile LCDRAM6STR _LCDRAM6;                              /* LCD RAM 6; 0x0000020E */
volatile LCDRAM7STR _LCDRAM7;                              /* LCD RAM 7; 0x0000020F */
volatile LCDRAM8STR _LCDRAM8;                              /* LCD RAM 8; 0x00000210 */
volatile LCDRAM9STR _LCDRAM9;                              /* LCD RAM 9; 0x00000211 */
volatile LCDRAM10STR _LCDRAM10;                            /* LCD RAM 10; 0x00000212 */
volatile LCDRAM11STR _LCDRAM11;                            /* LCD RAM 11; 0x00000213 */
volatile LCDRAM12STR _LCDRAM12;                            /* LCD RAM 12; 0x00000214 */
volatile LCDRAM13STR _LCDRAM13;                            /* LCD RAM 13; 0x00000215 */
volatile LCDRAM14STR _LCDRAM14;                            /* LCD RAM 14; 0x00000216 */
volatile LCDRAM15STR _LCDRAM15;                            /* LCD RAM 15; 0x00000217 */
volatile LCDRAM16STR _LCDRAM16;                            /* LCD RAM 16; 0x00000218 */
volatile LCDRAM17STR _LCDRAM17;                            /* LCD RAM 17; 0x00000219 */
volatile LCDRAM18STR _LCDRAM18;                            /* LCD RAM 18; 0x0000021A */
volatile LCDRAM19STR _LCDRAM19;                            /* LCD RAM 19; 0x0000021B */
volatile RTZ0CTLSTR _RTZ0CTL;                              /* SSD0 Return-to-Zero Control Register; 0x00000220 */
volatile MDC0CTLSTR _MDC0CTL;                              /* SSD0 Modulus Down Counter Control Register; 0x00000221 */
volatile SSD0CTLSTR _SSD0CTL;                              /* SSD0 Stepper Stall Detector Control Register; 0x00000222 */
volatile SSD0FLGSTR _SSD0FLG;                              /* SSD0 Stepper Stall Detector Flag Register; 0x00000223 */
volatile RTZ1CTLSTR _RTZ1CTL;                              /* SSD1 Return-to-Zero Control Register; 0x00000228 */
volatile MDC1CTLSTR _MDC1CTL;                              /* SSD1 Modulus Down Counter Control Register; 0x00000229 */
volatile SSD1CTLSTR _SSD1CTL;                              /* SSD1 Stepper Stall Detector Control Register; 0x0000022A */
volatile SSD1FLGSTR _SSD1FLG;                              /* SSD1 Stepper Stall Detector Flag Register; 0x0000022B */
volatile RTZ2CTLSTR _RTZ2CTL;                              /* SSD2 Return-to-Zero Control Register; 0x00000230 */
volatile MDC2CTLSTR _MDC2CTL;                              /* SSD2 Modulus Down Counter Control Register; 0x00000231 */
volatile SSD2CTLSTR _SSD2CTL;                              /* SSD2 Stepper Stall Detector Control Register; 0x00000232 */
volatile SSD2FLGSTR _SSD2FLG;                              /* SSD2 Stepper Stall Detector Flag Register; 0x00000233 */
volatile RTZ3CTLSTR _RTZ3CTL;                              /* SSD3 Return-to-Zero Control Register; 0x00000238 */
volatile MDC3CTLSTR _MDC3CTL;                              /* SSD3 Modulus Down Counter Control Register; 0x00000239 */
volatile SSD3CTLSTR _SSD3CTL;                              /* SSD3 Stepper Stall Detector Control Register; 0x0000023A */
volatile SSD3FLGSTR _SSD3FLG;                              /* SSD3 Stepper Stall Detector Flag Register; 0x0000023B */
volatile PTTSTR _PTT;                                      /* Port T Data Register; 0x00000240 */
volatile PTITSTR _PTIT;                                    /* Port T Input Register; 0x00000241 */
volatile DDRTSTR _DDRT;                                    /* Port T Data Direction Register; 0x00000242 */
volatile PERTSTR _PERT;                                    /* Port T Pull Device Enable Register; 0x00000244 */
volatile PPSTSTR _PPST;                                    /* Port T Polarity Select Register; 0x00000245 */
volatile PTTRRSTR _PTTRR;                                  /* Port T Routing Register; 0x00000247 */
volatile PTSSTR _PTS;                                      /* Port S Data Register; 0x00000248 */
volatile PTISSTR _PTIS;                                    /* Port S Input Register; 0x00000249 */
volatile DDRSSTR _DDRS;                                    /* Port S Data Direction Register; 0x0000024A */
volatile PERSSTR _PERS;                                    /* Port S Pull Device Enable Register; 0x0000024C */
volatile PPSSSTR _PPSS;                                    /* Port S Polarity Select Register; 0x0000024D */
volatile WOMSSTR _WOMS;                                    /* Port S Wired-Or Mode Register; 0x0000024E */
volatile PTSRRSTR _PTSRR;                                  /* Port S Routing Register; 0x0000024F */
volatile PTMSTR _PTM;                                      /* Port M Data Register; 0x00000250 */
volatile PTIMSTR _PTIM;                                    /* Port M Input Register; 0x00000251 */
volatile DDRMSTR _DDRM;                                    /* Port M Data Direction Register; 0x00000252 */
volatile PERMSTR _PERM;                                    /* Port M Pull Device Enable Register; 0x00000254 */
volatile PPSMSTR _PPSM;                                    /* Port M Polarity Select Register; 0x00000255 */
volatile WOMMSTR _WOMM;                                    /* Port M Wired-Or Mode Register; 0x00000256 */
volatile PTPSTR _PTP;                                      /* Port P Data Register; 0x00000258 */
volatile PTIPSTR _PTIP;                                    /* Port P Input Register; 0x00000259 */
volatile DDRPSTR _DDRP;                                    /* Port P Data Direction Register; 0x0000025A */
volatile PERPSTR _PERP;                                    /* Port P Pull Device Enable Register; 0x0000025C */
volatile PPSPSTR _PPSP;                                    /* Port P Polarity Select Register; 0x0000025D */
volatile PTHSTR _PTH;                                      /* Port H Data Register; 0x00000260 */
volatile PTIHSTR _PTIH;                                    /* Port H Input Register; 0x00000261 */
volatile DDRHSTR _DDRH;                                    /* Port H Data Direction Register; 0x00000262 */
volatile PERHSTR _PERH;                                    /* Port H Pull Device Enable Register; 0x00000264 */
volatile PPSHSTR _PPSH;                                    /* Port H Polarity Select Register; 0x00000265 */
volatile WOMHSTR _WOMH;                                    /* Port H Wired-Or Mode Register; 0x00000266 */
volatile PTHRRSTR _PTHRR;                                  /* Port H Routing Register; 0x00000267 */
volatile PTRSTR _PTR;                                      /* Port R Data Register; 0x00000280 */
volatile PTIRSTR _PTIR;                                    /* Port R Input Register; 0x00000281 */
volatile DDRRSTR _DDRR;                                    /* Port R Data Direction Register; 0x00000282 */
volatile PERRSTR _PERR;                                    /* Port R Pull Device Enable Register; 0x00000284 */
volatile PPSRSTR _PPSR;                                    /* Port R Polarity Select Register; 0x00000285 */
volatile WOMRSTR _WOMR;                                    /* Port R Wired-Or Mode Register; 0x00000286 */
volatile PIETSTR _PIET;                                    /* Port T Interrupt Enable Register; 0x00000288 */
volatile PIFTSTR _PIFT;                                    /* Port T Interrupt Flag Register; 0x00000289 */
volatile PIESSTR _PIES;                                    /* Port S Interrupt Enable Register; 0x0000028A */
volatile PIFSSTR _PIFS;                                    /* Port S Interrupt Flag Register; 0x0000028B */
volatile PIE1ADSTR _PIE1AD;                                /* Port ADL Interrupt Enable Register; 0x0000028C */
volatile PIF1ADSTR _PIF1AD;                                /* Port ADL Interrupt Flag Register; 0x0000028D */
volatile PIERSTR _PIER;                                    /* Port R Interrupt Enable Register; 0x0000028E */
volatile PIFRSTR _PIFR;                                    /* Port R Interrupt Flag Register; 0x0000028F */
volatile PTUSTR _PTU;                                      /* Port U Data Register; 0x00000290 */
volatile PTIUSTR _PTIU;                                    /* Port U Input Register; 0x00000291 */
volatile DDRUSTR _DDRU;                                    /* Port U Data Direction Register; 0x00000292 */
volatile PERUSTR _PERU;                                    /* Port U Pull Device Enable Register; 0x00000294 */
volatile PPSUSTR _PPSU;                                    /* Port U Polarity Select Register; 0x00000295 */
volatile SRRUSTR _SRRU;                                    /* Port U Slew Rate Register; 0x00000296 */
volatile PTURRSTR _PTURR;                                  /* Port U Routing Register; 0x00000297 */
volatile PTVSTR _PTV;                                      /* Port V Data Register; 0x00000298 */
volatile PTIVSTR _PTIV;                                    /* Port V Input Register; 0x00000299 */
volatile DDRVSTR _DDRV;                                    /* Port V Data Direction Register; 0x0000029A */
volatile PERVSTR _PERV;                                    /* Port V Pull Device Enable Register; 0x0000029C */
volatile PPSVSTR _PPSV;                                    /* Port V Polarity Select Register; 0x0000029D */
volatile SRRVSTR _SRRV;                                    /* Port V Slew Rate Register; 0x0000029E */
volatile PTVRRSTR _PTVRR;                                  /* Port V Routing Register; 0x0000029F */
volatile TIM1_TIOSSTR _TIM1_TIOS;                          /* Timer Input Capture/Output Compare Select; 0x000002A0 */
volatile TIM1_CFORCSTR _TIM1_CFORC;                        /* Timer Compare Force Register; 0x000002A1 */
volatile TIM1_OC7MSTR _TIM1_OC7M;                          /* Output Compare 7 Mask Register; 0x000002A2 */
volatile TIM1_OC7DSTR _TIM1_OC7D;                          /* Output Compare 7 Data Register; 0x000002A3 */
volatile TIM1_TSCR1STR _TIM1_TSCR1;                        /* Timer System Control Register1; 0x000002A6 */
volatile TIM1_TTOVSTR _TIM1_TTOV;                          /* Timer Toggle On Overflow Register; 0x000002A7 */
volatile TIM1_TCTL1STR _TIM1_TCTL1;                        /* Timer Control Register 1; 0x000002A8 */
volatile TIM1_TCTL2STR _TIM1_TCTL2;                        /* Timer Control Register 2; 0x000002A9 */
volatile TIM1_TCTL3STR _TIM1_TCTL3;                        /* Timer Control Register 3; 0x000002AA */
volatile TIM1_TCTL4STR _TIM1_TCTL4;                        /* Timer Control Register 4; 0x000002AB */
volatile TIM1_TIESTR _TIM1_TIE;                            /* Timer Interrupt Enable Register; 0x000002AC */
volatile TIM1_TSCR2STR _TIM1_TSCR2;                        /* Timer System Control Register 2; 0x000002AD */
volatile TIM1_TFLG1STR _TIM1_TFLG1;                        /* Main Timer Interrupt Flag 1; 0x000002AE */
volatile TIM1_TFLG2STR _TIM1_TFLG2;                        /* Main Timer Interrupt Flag 2; 0x000002AF */
volatile TIM1_PACTLSTR _TIM1_PACTL;                        /* 16-Bit Pulse Accumulator A Control Register; 0x000002C0 */
volatile TIM1_PAFLGSTR _TIM1_PAFLG;                        /* Pulse Accumulator A Flag Register; 0x000002C1 */
volatile TIM1_OCPDSTR _TIM1_OCPD;                          /* Output Compare Pin Disconnect Register; 0x000002CC */
volatile TIM1_PTPSRSTR _TIM1_PTPSR;                        /* Precision Timer Prescaler Select Register; 0x000002CE */
volatile VREGHTCLSTR _VREGHTCL;                            /* HT Control Register; 0x000002F0 */
volatile VREGCTRLSTR _VREGCTRL;                            /* Control Register; 0x000002F1 */
volatile VREGAPICLSTR _VREGAPICL;                          /* Autonomous Periodical Interrupt Control Register; 0x000002F2 */
volatile VREGAPITRSTR _VREGAPITR;                          /* Autonomous Periodical Interrupt Trimming Register; 0x000002F3 */
volatile VREGHTTRSTR _VREGHTTR;                            /* HTTrimming Register; 0x000002F7 */
/* NVFPROT - macro for reading non volatile register       Non Volatile P-Flash Protection Register; 0x0000FF0C */
/* NVDFPROT - macro for reading non volatile register      Non Volatile D-Flash Protection Register; 0x0000FF0D */
/* NVFOPT - macro for reading non volatile register        Non Volatile Flash Option Register; 0x0000FF0E */
/* NVFSEC - macro for reading non volatile register        Non Volatile Flash Security Register; 0x0000FF0F */


/* * * * *  16-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile PORTABSTR _PORTAB;                                /* Port AB Data Register; 0x00000000 */
volatile DDRABSTR _DDRAB;                                  /* Port AB Data Direction Register; 0x00000002 */
volatile PARTIDSTR _PARTID;                                /* Part ID Register; 0x0000001A */
volatile DBGTBSTR _DBGTB;                                  /* Debug Trace Buffer Register; 0x00000024 */
volatile TIM0_TCNTSTR _TIM0_TCNT;                          /* Timer Count Register; 0x00000044 */
volatile TIM0_TC0STR _TIM0_TC0;                            /* Timer Input Capture/Output Compare Register 0; 0x00000050 */
volatile TIM0_TC1STR _TIM0_TC1;                            /* Timer Input Capture/Output Compare Register 1; 0x00000052 */
volatile TIM0_TC2STR _TIM0_TC2;                            /* Timer Input Capture/Output Compare Register 2; 0x00000054 */
volatile TIM0_TC3STR _TIM0_TC3;                            /* Timer Input Capture/Output Compare Register 3; 0x00000056 */
volatile TIM0_TC4STR _TIM0_TC4;                            /* Timer Input Capture/Output Compare Register 4; 0x00000058 */
volatile TIM0_TC5STR _TIM0_TC5;                            /* Timer Input Capture/Output Compare Register 5; 0x0000005A */
volatile TIM0_TC6STR _TIM0_TC6;                            /* Timer Input Capture/Output Compare Register 6; 0x0000005C */
volatile TIM0_TC7STR _TIM0_TC7;                            /* Timer Input Capture/Output Compare Register 7; 0x0000005E */
volatile TIM0_PACNTSTR _TIM0_PACNT;                        /* Pulse Accumulators Count Register; 0x00000062 */
volatile ATDCTL01STR _ATDCTL01;                            /* ATD  Control Register 01; 0x00000070 */
volatile ATDCTL23STR _ATDCTL23;                            /* ATD  Control Register 23; 0x00000072 */
volatile ATDCTL45STR _ATDCTL45;                            /* ATD  Control Register 45; 0x00000074 */
volatile ATDCMPESTR _ATDCMPE;                              /* ATD  Compare Enable Register; 0x00000078 */
volatile ATDSTAT2STR _ATDSTAT2;                            /* ATD  Status Register 2; 0x0000007A */
volatile ATDDIENSTR _ATDDIEN;                              /* ATD  Input Enable Register; 0x0000007C */
volatile ATDCMPHTSTR _ATDCMPHT;                            /* ATD  Compare Higher Than Register; 0x0000007E */
volatile ATDDR0STR _ATDDR0;                                /* ATD  Conversion Result Register 0; 0x00000080 */
volatile ATDDR1STR _ATDDR1;                                /* ATD  Conversion Result Register 1; 0x00000082 */
volatile ATDDR2STR _ATDDR2;                                /* ATD  Conversion Result Register 2; 0x00000084 */
volatile ATDDR3STR _ATDDR3;                                /* ATD  Conversion Result Register 3; 0x00000086 */
volatile ATDDR4STR _ATDDR4;                                /* ATD  Conversion Result Register 4; 0x00000088 */
volatile ATDDR5STR _ATDDR5;                                /* ATD  Conversion Result Register 5; 0x0000008A */
volatile ATDDR6STR _ATDDR6;                                /* ATD  Conversion Result Register 6; 0x0000008C */
volatile ATDDR7STR _ATDDR7;                                /* ATD  Conversion Result Register 7; 0x0000008E */
volatile ATDDR8STR _ATDDR8;                                /* ATD  Conversion Result Register 8; 0x00000090 */
volatile ATDDR9STR _ATDDR9;                                /* ATD  Conversion Result Register 9; 0x00000092 */
volatile ATDDR10STR _ATDDR10;                              /* ATD  Conversion Result Register 10; 0x00000094 */
volatile ATDDR11STR _ATDDR11;                              /* ATD  Conversion Result Register 11; 0x00000096 */
volatile PWMCNT01STR _PWMCNT01;                            /* PWM Channel Counter 01 Register; 0x000000AC */
volatile PWMCNT23STR _PWMCNT23;                            /* PWM Channel Counter 23 Register; 0x000000AE */
volatile PWMCNT45STR _PWMCNT45;                            /* PWM Channel Counter 45 Register; 0x000000B0 */
volatile PWMCNT67STR _PWMCNT67;                            /* PWM Channel Counter 67 Register; 0x000000B2 */
volatile PWMPER01STR _PWMPER01;                            /* PWM Channel Period 01 Register; 0x000000B4 */
volatile PWMPER23STR _PWMPER23;                            /* PWM Channel Period 23 Register; 0x000000B6 */
volatile PWMPER45STR _PWMPER45;                            /* PWM Channel Period 45 Register; 0x000000B8 */
volatile PWMPER67STR _PWMPER67;                            /* PWM Channel Period 67 Register; 0x000000BA */
volatile PWMDTY01STR _PWMDTY01;                            /* PWM Channel Duty 01 Register; 0x000000BC */
volatile PWMDTY23STR _PWMDTY23;                            /* PWM Channel Duty 23 Register; 0x000000BE */
volatile PWMDTY45STR _PWMDTY45;                            /* PWM Channel Duty 45 Register; 0x000000C0 */
volatile PWMDTY67STR _PWMDTY67;                            /* PWM Channel Duty 67 Register; 0x000000C2 */
volatile SCI0BDSTR _SCI0BD;                                /* SCI 0 Baud Rate Register; 0x000000C8 */
volatile SCI1BDSTR _SCI1BD;                                /* SCI 1 Baud Rate Register; 0x000000D0 */
volatile SPIDRSTR _SPIDR;                                  /* SPI  Data Register; 0x000000DC */
volatile FCCOBSTR _FCCOB;                                  /* Flash Common Command Object Register; 0x0000010A */
volatile FECCRSTR _FECCR;                                  /* Flash ECC Error Results Register; 0x0000010E */
volatile CAN0RXTSRSTR _CAN0RXTSR;                          /* MSCAN0 Receive Time Stamp Register; 0x0000016E */
volatile CAN0TXTSRSTR _CAN0TXTSR;                          /* MSCAN0 Transmit Time Stamp Register; 0x0000017E */
volatile CAN1RXTSRSTR _CAN1RXTSR;                          /* MSCAN1 Receive Time Stamp Register; 0x000001AE */
volatile CAN1TXTSRSTR _CAN1TXTSR;                          /* MSCAN1 Transmit Time Stamp Register; 0x000001BE */
volatile MCPERSTR _MCPER;                                  /* Motor Controller Period Register; 0x000001C2 */
volatile MCDC0STR _MCDC0;                                  /* Motor Controller Period Register 0; 0x000001E0 */
volatile MCDC1STR _MCDC1;                                  /* Motor Controller Period Register 1; 0x000001E2 */
volatile MCDC2STR _MCDC2;                                  /* Motor Controller Period Register 2; 0x000001E4 */
volatile MCDC3STR _MCDC3;                                  /* Motor Controller Period Register 3; 0x000001E6 */
volatile MCDC4STR _MCDC4;                                  /* Motor Controller Period Register 4; 0x000001E8 */
volatile MCDC5STR _MCDC5;                                  /* Motor Controller Period Register 5; 0x000001EA */
volatile MCDC6STR _MCDC6;                                  /* Motor Controller Period Register 6; 0x000001EC */
volatile MCDC7STR _MCDC7;                                  /* Motor Controller Period Register 7; 0x000001EE */
volatile MDC0CNTSTR _MDC0CNT;                              /* SSD0 Modulus Down-Counter Count Register; 0x00000224 */
volatile ITG0ACCSTR _ITG0ACC;                              /* SSD0 Integration Accumulator Register; 0x00000226 */
volatile MDC1CNTSTR _MDC1CNT;                              /* SSD1 Modulus Down-Counter Count Register; 0x0000022C */
volatile ITG1ACCSTR _ITG1ACC;                              /* SSD1 Integration Accumulator Register; 0x0000022E */
volatile MDC2CNTSTR _MDC2CNT;                              /* SSD2 Modulus Down-Counter Count Register; 0x00000234 */
volatile ITG2ACCSTR _ITG2ACC;                              /* SSD2 Integration Accumulator Register; 0x00000236 */
volatile MDC3CNTSTR _MDC3CNT;                              /* SSD3 Modulus Down-Counter Count Register; 0x0000023C */
volatile ITG3ACCSTR _ITG3ACC;                              /* SSD3 Integration Accumulator Register; 0x0000023E */
volatile PTPRRSTR _PTPRR;                                  /* Port P Routing Register; 0x0000025E */
volatile PT01ADSTR _PT01AD;                                /* Port AD Data Register; 0x00000270 */
volatile DDR01ADSTR _DDR01AD;                              /* Port AD Data Direction Register; 0x00000272 */
volatile PER01ADSTR _PER01AD;                              /* Port AD Pull Up Enable Register; 0x00000276 */
volatile TIM1_TCNTSTR _TIM1_TCNT;                          /* Timer Count Register; 0x000002A4 */
volatile TIM1_TC0STR _TIM1_TC0;                            /* Timer Input Capture/Output Compare Register 0; 0x000002B0 */
volatile TIM1_TC1STR _TIM1_TC1;                            /* Timer Input Capture/Output Compare Register 1; 0x000002B2 */
volatile TIM1_TC2STR _TIM1_TC2;                            /* Timer Input Capture/Output Compare Register 2; 0x000002B4 */
volatile TIM1_TC3STR _TIM1_TC3;                            /* Timer Input Capture/Output Compare Register 3; 0x000002B6 */
volatile TIM1_TC4STR _TIM1_TC4;                            /* Timer Input Capture/Output Compare Register 4; 0x000002B8 */
volatile TIM1_TC5STR _TIM1_TC5;                            /* Timer Input Capture/Output Compare Register 5; 0x000002BA */
volatile TIM1_TC6STR _TIM1_TC6;                            /* Timer Input Capture/Output Compare Register 6; 0x000002BC */
volatile TIM1_TC7STR _TIM1_TC7;                            /* Timer Input Capture/Output Compare Register 7; 0x000002BE */
volatile TIM1_PACNTSTR _TIM1_PACNT;                        /* Pulse Accumulators Count Register; 0x000002C2 */
volatile VREGAPIRSTR _VREGAPIR;                            /* Autonomous Periodical Interrupt Rate Register; 0x000002F4 */
/* BAKEY0 - macro for reading non volatile register        Backdoor Comparison Key 0; 0x0000FF00 */
/* BAKEY1 - macro for reading non volatile register        Backdoor Comparison Key 1; 0x0000FF02 */
/* BAKEY2 - macro for reading non volatile register        Backdoor Comparison Key 2; 0x0000FF04 */
/* BAKEY3 - macro for reading non volatile register        Backdoor Comparison Key 3; 0x0000FF06 */

/*lint -restore */

/* EOF */
