/* Based on CPU DB MC9S12XF512_144, version 3.00.030 (RegistersPrg V2.32) */
/* DataSheet : MC9S12XF512V1RM Rev.1.18 01-March-2010 */

#include <mc9s12xf512.h>

/*lint -save -esym(765, *) */


/* * * * *  8-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile PORTESTR _PORTE;                                  /* Port E Data Register; 0x00000008 */
volatile DDRESTR _DDRE;                                    /* Port E Data Direction Register; 0x00000009 */
volatile MMCCTL0STR _MMCCTL0;                              /* MMC Control Register; 0x0000000A */
volatile MODESTR _MODE;                                    /* Mode Register; 0x0000000B */
volatile PUCRSTR _PUCR;                                    /* Pull-Up Control Register; 0x0000000C */
volatile RDRIVSTR _RDRIV;                                  /* Reduced Drive Register; 0x0000000D */
volatile EBICTL0STR _EBICTL0;                              /* External Bus Interface Control Register 0; 0x0000000E */
volatile EBICTL1STR _EBICTL1;                              /* External Bus Interface Control Register 1; 0x0000000F */
volatile GPAGESTR _GPAGE;                                  /* Global Page Index Register; 0x00000010 */
volatile DIRECTSTR _DIRECT;                                /* Direct Page Register; 0x00000011 */
volatile MMCCTL1STR _MMCCTL1;                              /* MMC Control Register; 0x00000013 */
volatile PPAGESTR _PPAGE;                                  /* Program Page Index Register; 0x00000015 */
volatile RPAGESTR _RPAGE;                                  /* RAM Page Index Register; 0x00000016 */
volatile EPAGESTR _EPAGE;                                  /* Data FLASH Page Index Register; 0x00000017 */
volatile ECLKCTLSTR _ECLKCTL;                              /* ECLK Control Register; 0x0000001C */
volatile IRQCRSTR _IRQCR;                                  /* Interrupt Control Register; 0x0000001E */
volatile DBGC1STR _DBGC1;                                  /* Debug Control Register 1; 0x00000020 */
volatile DBGSRSTR _DBGSR;                                  /* Debug Status Register; 0x00000021 */
volatile DBGTCRSTR _DBGTCR;                                /* Debug Trace Control Register; 0x00000022 */
volatile DBGC2STR _DBGC2;                                  /* Debug Control Register 2; 0x00000023 */
volatile DBGCNTSTR _DBGCNT;                                /* Debug Count Register; 0x00000026 */
volatile DBGSCRXSTR _DBGSCRX;                              /* Debug State Control Register; 0x00000027 */
volatile DBGXCTLSTR _DBGXCTL;                              /* Debug Comparator Control Register; 0x00000028 */
volatile DBGXAHSTR _DBGXAH;                                /* Debug Comparator Address High Register; 0x00000029 */
volatile DBGXAMSTR _DBGXAM;                                /* Debug Comparator Address Mid Register; 0x0000002A */
volatile DBGXALSTR _DBGXAL;                                /* Debug Comparator Address Low Register; 0x0000002B */
volatile DBGXDHSTR _DBGXDH;                                /* Debug Comparator Data High Register; 0x0000002C */
volatile DBGXDLSTR _DBGXDL;                                /* Debug Comparator Data Low Register; 0x0000002D */
volatile DBGXDHMSTR _DBGXDHM;                              /* Debug Comparator Data High Mask Register; 0x0000002E */
volatile DBGXDLMSTR _DBGXDLM;                              /* Debug Comparator Data Low Mask Register; 0x0000002F */
volatile PORTKSTR _PORTK;                                  /* Port K Data Register; 0x00000032 */
volatile DDRKSTR _DDRK;                                    /* Port K Data Direction Register; 0x00000033 */
volatile SYNRSTR _SYNR;                                    /* S12XECRG Synthesizer Register; 0x00000034 */
volatile REFDVSTR _REFDV;                                  /* S12XECRG Reference Divider Register; 0x00000035 */
volatile POSTDIVSTR _POSTDIV;                              /* S12XECRG Post Divider Register; 0x00000036 */
volatile CRGFLGSTR _CRGFLG;                                /* S12XECRG Flags Register; 0x00000037 */
volatile CRGINTSTR _CRGINT;                                /* S12XECRG Interrupt Enable Register; 0x00000038 */
volatile CLKSELSTR _CLKSEL;                                /* S12XECRG Clock Select Register; 0x00000039 */
volatile PLLCTLSTR _PLLCTL;                                /* S12XECRG IPLL Control Register; 0x0000003A */
volatile RTICTLSTR _RTICTL;                                /* ECRG RTI Control Register; 0x0000003B */
volatile COPCTLSTR _COPCTL;                                /* CRG COP Control Register; 0x0000003C */
volatile ARMCOPSTR _ARMCOP;                                /* CRG COP Timer Arm/Reset Register; 0x0000003F */
volatile TIOSSTR _TIOS;                                    /* Timer Input Capture/Output Compare Select; 0x00000040 */
volatile CFORCSTR _CFORC;                                  /* Timer Compare Force Register; 0x00000041 */
volatile OC7MSTR _OC7M;                                    /* Output Compare 7 Mask Register; 0x00000042 */
volatile OC7DSTR _OC7D;                                    /* Output Compare 7 Data Register; 0x00000043 */
volatile TSCR1STR _TSCR1;                                  /* Timer System Control Register1; 0x00000046 */
volatile TTOVSTR _TTOV;                                    /* Timer Toggle On Overflow Register; 0x00000047 */
volatile TCTL1STR _TCTL1;                                  /* Timer Control Register 1; 0x00000048 */
volatile TCTL2STR _TCTL2;                                  /* Timer Control Register 2; 0x00000049 */
volatile TCTL3STR _TCTL3;                                  /* Timer Control Register 3; 0x0000004A */
volatile TCTL4STR _TCTL4;                                  /* Timer Control Register 4; 0x0000004B */
volatile TIESTR _TIE;                                      /* Timer Interrupt Enable Register; 0x0000004C */
volatile TSCR2STR _TSCR2;                                  /* Timer System Control Register 2; 0x0000004D */
volatile TFLG1STR _TFLG1;                                  /* Main Timer Interrupt Flag 1; 0x0000004E */
volatile TFLG2STR _TFLG2;                                  /* Main Timer Interrupt Flag 2; 0x0000004F */
volatile PACTLSTR _PACTL;                                  /* 16-Bit Pulse Accumulator A Control Register; 0x00000060 */
volatile PAFLGSTR _PAFLG;                                  /* Pulse Accumulator A Flag Register; 0x00000061 */
volatile MCCTLSTR _MCCTL;                                  /* Modulus Down Counter underflow; 0x00000066 */
volatile MCFLGSTR _MCFLG;                                  /* 16-Bit Modulus Down Counter Flag Register; 0x00000067 */
volatile ICPARSTR _ICPAR;                                  /* Input Control Pulse Accumulator Register; 0x00000068 */
volatile DLYCTSTR _DLYCT;                                  /* Delay Counter Control Register; 0x00000069 */
volatile ICOVWSTR _ICOVW;                                  /* Input Control Overwrite Register; 0x0000006A */
volatile ICSYSSTR _ICSYS;                                  /* Input Control System Control Register; 0x0000006B */
volatile OCPDSTR _OCPD;                                    /* Output Compare Pin Disconnect Register; 0x0000006C */
volatile PTPSRSTR _PTPSR;                                  /* Precision Timer Prescaler Select Register; 0x0000006E */
volatile PTMCPSRSTR _PTMCPSR;                              /* Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F */
volatile PBCTLSTR _PBCTL;                                  /* 16-Bit Pulse Accumulator B Control Register; 0x00000070 */
volatile PBFLGSTR _PBFLG;                                  /* Pulse Accumulator B Flag Register; 0x00000071 */
volatile ATDSTAT0STR _ATDSTAT0;                            /* ATD  Status Register 0; 0x00000086 */
volatile SCI0ACR2STR _SCI0ACR2;                            /* SCI 0 Alternative Control Register 2; 0x000000CA */
volatile SCI0CR2STR _SCI0CR2;                              /* SCI 0 Control Register 2; 0x000000CB */
volatile SCI0SR1STR _SCI0SR1;                              /* SCI 0 Status Register 1; 0x000000CC */
volatile SCI0SR2STR _SCI0SR2;                              /* SCI 0 Status Register 2; 0x000000CD */
volatile SCI0DRHSTR _SCI0DRH;                              /* SCI 0 Data Register High; 0x000000CE */
volatile SCI0DRLSTR _SCI0DRL;                              /* SCI 0 Data Register Low; 0x000000CF */
volatile SCI1ACR2STR _SCI1ACR2;                            /* SCI 1 Alternative Control Register 2; 0x000000D2 */
volatile SCI1CR2STR _SCI1CR2;                              /* SCI 1 Control Register 2; 0x000000D3 */
volatile SCI1SR1STR _SCI1SR1;                              /* SCI 1 Status Register 1; 0x000000D4 */
volatile SCI1SR2STR _SCI1SR2;                              /* SCI 1 Status Register 2; 0x000000D5 */
volatile SCI1DRHSTR _SCI1DRH;                              /* SCI 1 Data Register High; 0x000000D6 */
volatile SCI1DRLSTR _SCI1DRL;                              /* SCI 1 Data Register Low; 0x000000D7 */
volatile SPI0CR1STR _SPI0CR1;                              /* SPI 0 Control Register 1; 0x000000D8 */
volatile SPI0CR2STR _SPI0CR2;                              /* SPI 0 Control Register 2; 0x000000D9 */
volatile SPI0BRSTR _SPI0BR;                                /* SPI 0 Baud Rate Register; 0x000000DA */
volatile SPI0SRSTR _SPI0SR;                                /* SPI 0 Status Register; 0x000000DB */
volatile SPI1CR1STR _SPI1CR1;                              /* SPI 1 Control Register 1; 0x000000F0 */
volatile SPI1CR2STR _SPI1CR2;                              /* SPI 1 Control Register 2; 0x000000F1 */
volatile SPI1BRSTR _SPI1BR;                                /* SPI 1 Baud Rate Register; 0x000000F2 */
volatile SPI1SRSTR _SPI1SR;                                /* SPI 1 Status Register; 0x000000F3 */
volatile FCLKDIVSTR _FCLKDIV;                              /* Flash Clock Divider Register; 0x00000100 */
volatile FSECSTR _FSEC;                                    /* Flash Security Register; 0x00000101 */
volatile FCCOBIXSTR _FCCOBIX;                              /* Flash CCOB Index Register; 0x00000102 */
volatile FECCRIXSTR _FECCRIX;                              /* Flash ECCR Index Register; 0x00000103 */
volatile FCNFGSTR _FCNFG;                                  /* Flash Configuration Register; 0x00000104 */
volatile FERCNFGSTR _FERCNFG;                              /* Flash Error Configuration Register; 0x00000105 */
volatile FSTATSTR _FSTAT;                                  /* Flash Status Register; 0x00000106 */
volatile FERSTATSTR _FERSTAT;                              /* Flash Error Status Register; 0x00000107 */
volatile FPROTSTR _FPROT;                                  /* P-Flash Protection Register; 0x00000108 */
volatile EPROTSTR _EPROT;                                  /* EEE Protection Register; 0x00000109 */
volatile FOPTSTR _FOPT;                                    /* Flash Option Register; 0x00000110 */
volatile MPUFLGSTR _MPUFLG;                                /* MPU Flag Register; 0x00000114 */
volatile MPUASTAT0STR _MPUASTAT0;                          /* MPU Address Status Register 0; 0x00000115 */
volatile MPUASTAT1STR _MPUASTAT1;                          /* MPU Address Status Register 1; 0x00000116 */
volatile MPUASTAT2STR _MPUASTAT2;                          /* MPU Address Status Register 2; 0x00000117 */
volatile MPUSELSTR _MPUSEL;                                /* MPU Descriptor Select Register; 0x00000119 */
volatile MPUDESC0STR _MPUDESC0;                            /* MPU Descriptor Register 0; 0x0000011A */
volatile MPUDESC1STR _MPUDESC1;                            /* MPU Descriptor Register 1; 0x0000011B */
volatile MPUDESC2STR _MPUDESC2;                            /* MPU Descriptor Register 2; 0x0000011C */
volatile MPUDESC3STR _MPUDESC3;                            /* MPU Descriptor Register 2; 0x0000011D */
volatile MPUDESC4STR _MPUDESC4;                            /* MPU Descriptor Register 2; 0x0000011E */
volatile MPUDESC5STR _MPUDESC5;                            /* MPU Descriptor Register 2; 0x0000011F */
volatile IVBRSTR _IVBR;                                    /* Interrupt Vector Base Register; 0x00000121 */
volatile INT_XGPRIOSTR _INT_XGPRIO;                        /* XGATE Interrupt Priority Configuration Register; 0x00000126 */
volatile INT_CFADDRSTR _INT_CFADDR;                        /* Interrupt Request Configuration Address Register; 0x00000127 */
volatile INT_CFDATA0STR _INT_CFDATA0;                      /* Interrupt Request Configuration Data Register 0; 0x00000128 */
volatile INT_CFDATA1STR _INT_CFDATA1;                      /* Interrupt Request Configuration Data Register 1; 0x00000129 */
volatile INT_CFDATA2STR _INT_CFDATA2;                      /* Interrupt Request Configuration Data Register 2; 0x0000012A */
volatile INT_CFDATA3STR _INT_CFDATA3;                      /* Interrupt Request Configuration Data Register 3; 0x0000012B */
volatile INT_CFDATA4STR _INT_CFDATA4;                      /* Interrupt Request Configuration Data Register 4; 0x0000012C */
volatile INT_CFDATA5STR _INT_CFDATA5;                      /* Interrupt Request Configuration Data Register 5; 0x0000012D */
volatile INT_CFDATA6STR _INT_CFDATA6;                      /* Interrupt Request Configuration Data Register 6; 0x0000012E */
volatile INT_CFDATA7STR _INT_CFDATA7;                      /* Interrupt Request Configuration Data Register 7; 0x0000012F */
volatile CAN0CTL0STR _CAN0CTL0;                            /* MSCAN0 Control 0 Register; 0x00000140 */
volatile CAN0CTL1STR _CAN0CTL1;                            /* MSCAN0 Control 1 Register; 0x00000141 */
volatile CAN0BTR0STR _CAN0BTR0;                            /* MSCAN0 Bus Timing Register 0; 0x00000142 */
volatile CAN0BTR1STR _CAN0BTR1;                            /* MSCAN0 Bus Timing Register 1; 0x00000143 */
volatile CAN0RFLGSTR _CAN0RFLG;                            /* MSCAN0 Receiver Flag Register; 0x00000144 */
volatile CAN0RIERSTR _CAN0RIER;                            /* MSCAN0 Receiver Interrupt Enable Register; 0x00000145 */
volatile CAN0TFLGSTR _CAN0TFLG;                            /* MSCAN0 Transmitter Flag Register; 0x00000146 */
volatile CAN0TIERSTR _CAN0TIER;                            /* MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 */
volatile CAN0TARQSTR _CAN0TARQ;                            /* MSCAN0 Transmitter Message Abort Request; 0x00000148 */
volatile CAN0TAAKSTR _CAN0TAAK;                            /* MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 */
volatile CAN0TBSELSTR _CAN0TBSEL;                          /* MSCAN0 Transmit Buffer Selection; 0x0000014A */
volatile CAN0IDACSTR _CAN0IDAC;                            /* MSCAN0 Identifier Acceptance Control Register; 0x0000014B */
volatile CAN0MISCSTR _CAN0MISC;                            /* MSCAN0 Miscellaneous Register; 0x0000014D */
volatile CAN0RXERRSTR _CAN0RXERR;                          /* MSCAN0 Receive Error Counter Register; 0x0000014E */
volatile CAN0TXERRSTR _CAN0TXERR;                          /* MSCAN0 Transmit Error Counter Register; 0x0000014F */
volatile CAN0IDAR0STR _CAN0IDAR0;                          /* MSCAN0 Identifier Acceptance Register 0; 0x00000150 */
volatile CAN0IDAR1STR _CAN0IDAR1;                          /* MSCAN0 Identifier Acceptance Register 1; 0x00000151 */
volatile CAN0IDAR2STR _CAN0IDAR2;                          /* MSCAN0 Identifier Acceptance Register 2; 0x00000152 */
volatile CAN0IDAR3STR _CAN0IDAR3;                          /* MSCAN0 Identifier Acceptance Register 3; 0x00000153 */
volatile CAN0IDMR0STR _CAN0IDMR0;                          /* MSCAN0 Identifier Mask Register 0; 0x00000154 */
volatile CAN0IDMR1STR _CAN0IDMR1;                          /* MSCAN0 Identifier Mask Register 1; 0x00000155 */
volatile CAN0IDMR2STR _CAN0IDMR2;                          /* MSCAN0 Identifier Mask Register 2; 0x00000156 */
volatile CAN0IDMR3STR _CAN0IDMR3;                          /* MSCAN0 Identifier Mask Register 3; 0x00000157 */
volatile CAN0IDAR4STR _CAN0IDAR4;                          /* MSCAN0 Identifier Acceptance Register 4; 0x00000158 */
volatile CAN0IDAR5STR _CAN0IDAR5;                          /* MSCAN0 Identifier Acceptance Register 5; 0x00000159 */
volatile CAN0IDAR6STR _CAN0IDAR6;                          /* MSCAN0 Identifier Acceptance Register 6; 0x0000015A */
volatile CAN0IDAR7STR _CAN0IDAR7;                          /* MSCAN0 Identifier Acceptance Register 7; 0x0000015B */
volatile CAN0IDMR4STR _CAN0IDMR4;                          /* MSCAN0 Identifier Mask Register 4; 0x0000015C */
volatile CAN0IDMR5STR _CAN0IDMR5;                          /* MSCAN0 Identifier Mask Register 5; 0x0000015D */
volatile CAN0IDMR6STR _CAN0IDMR6;                          /* MSCAN0 Identifier Mask Register 6; 0x0000015E */
volatile CAN0IDMR7STR _CAN0IDMR7;                          /* MSCAN0 Identifier Mask Register 7; 0x0000015F */
volatile CAN0RXIDR0STR _CAN0RXIDR0;                        /* MSCAN0 Receive Identifier Register 0; 0x00000160 */
volatile CAN0RXIDR1STR _CAN0RXIDR1;                        /* MSCAN0 Receive Identifier Register 1; 0x00000161 */
volatile CAN0RXIDR2STR _CAN0RXIDR2;                        /* MSCAN0 Receive Identifier Register 2; 0x00000162 */
volatile CAN0RXIDR3STR _CAN0RXIDR3;                        /* MSCAN0 Receive Identifier Register 3; 0x00000163 */
volatile CAN0RXDSR0STR _CAN0RXDSR0;                        /* MSCAN0 Receive Data Segment Register 0; 0x00000164 */
volatile CAN0RXDSR1STR _CAN0RXDSR1;                        /* MSCAN0 Receive Data Segment Register 1; 0x00000165 */
volatile CAN0RXDSR2STR _CAN0RXDSR2;                        /* MSCAN0 Receive Data Segment Register 2; 0x00000166 */
volatile CAN0RXDSR3STR _CAN0RXDSR3;                        /* MSCAN0 Receive Data Segment Register 3; 0x00000167 */
volatile CAN0RXDSR4STR _CAN0RXDSR4;                        /* MSCAN0 Receive Data Segment Register 4; 0x00000168 */
volatile CAN0RXDSR5STR _CAN0RXDSR5;                        /* MSCAN0 Receive Data Segment Register 5; 0x00000169 */
volatile CAN0RXDSR6STR _CAN0RXDSR6;                        /* MSCAN0 Receive Data Segment Register 6; 0x0000016A */
volatile CAN0RXDSR7STR _CAN0RXDSR7;                        /* MSCAN0 Receive Data Segment Register 7; 0x0000016B */
volatile CAN0RXDLRSTR _CAN0RXDLR;                          /* MSCAN0 Receive Data Length Register; 0x0000016C */
volatile CAN0TXIDR0STR _CAN0TXIDR0;                        /* MSCAN0 Transmit Identifier Register 0; 0x00000170 */
volatile CAN0TXIDR1STR _CAN0TXIDR1;                        /* MSCAN0 Transmit Identifier Register 1; 0x00000171 */
volatile CAN0TXIDR2STR _CAN0TXIDR2;                        /* MSCAN0 Transmit Identifier Register 2; 0x00000172 */
volatile CAN0TXIDR3STR _CAN0TXIDR3;                        /* MSCAN0 Transmit Identifier Register 3; 0x00000173 */
volatile CAN0TXDSR0STR _CAN0TXDSR0;                        /* MSCAN0 Transmit Data Segment Register 0; 0x00000174 */
volatile CAN0TXDSR1STR _CAN0TXDSR1;                        /* MSCAN0 Transmit Data Segment Register 1; 0x00000175 */
volatile CAN0TXDSR2STR _CAN0TXDSR2;                        /* MSCAN0 Transmit Data Segment Register 2; 0x00000176 */
volatile CAN0TXDSR3STR _CAN0TXDSR3;                        /* MSCAN0 Transmit Data Segment Register 3; 0x00000177 */
volatile CAN0TXDSR4STR _CAN0TXDSR4;                        /* MSCAN0 Transmit Data Segment Register 4; 0x00000178 */
volatile CAN0TXDSR5STR _CAN0TXDSR5;                        /* MSCAN0 Transmit Data Segment Register 5; 0x00000179 */
volatile CAN0TXDSR6STR _CAN0TXDSR6;                        /* MSCAN0 Transmit Data Segment Register 6; 0x0000017A */
volatile CAN0TXDSR7STR _CAN0TXDSR7;                        /* MSCAN0 Transmit Data Segment Register 7; 0x0000017B */
volatile CAN0TXDLRSTR _CAN0TXDLR;                          /* MSCAN0 Transmit Data Length Register; 0x0000017C */
volatile CAN0TXTBPRSTR _CAN0TXTBPR;                        /* MSCAN0 Transmit Buffer Priority; 0x0000017D */
volatile PMFCFG0STR _PMFCFG0;                              /* PMF Configure 0 Register; 0x00000200 */
volatile PMFCFG1STR _PMFCFG1;                              /* PMF Configure 1 Register; 0x00000201 */
volatile PMFCFG2STR _PMFCFG2;                              /* PMF Configure 2 Register; 0x00000202 */
volatile PMFCFG3STR _PMFCFG3;                              /* PMF Configure 3 Register; 0x00000203 */
volatile PMFFCTLSTR _PMFFCTL;                              /* PMF Fault Control Register; 0x00000204 */
volatile PMFFPINSTR _PMFFPIN;                              /* PMF Fault Pin Enable Register; 0x00000205 */
volatile PMFFSTASTR _PMFFSTA;                              /* PMF Fault Status Register; 0x00000206 */
volatile PMFQSMPSTR _PMFQSMP;                              /* PMF Fault Qualifying Samples Register; 0x00000207 */
volatile PMFDMPASTR _PMFDMPA;                              /* PMF Disable Mapping Register; 0x00000208 */
volatile PMFDMPBSTR _PMFDMPB;                              /* PMF Disable Mapping Register; 0x00000209 */
volatile PMFDMPCSTR _PMFDMPC;                              /* PMF Disable Mapping Register; 0x0000020A */
volatile PMFOUTCSTR _PMFOUTC;                              /* PMF Output Control Register; 0x0000020C */
volatile PMFOUTBSTR _PMFOUTB;                              /* PMF Output Control Bit Register; 0x0000020D */
volatile PMFDTMSSTR _PMFDTMS;                              /* PMF Deadtime Sample Register; 0x0000020E */
volatile PMFCCTLSTR _PMFCCTL;                              /* PMF Correction Control Register; 0x0000020F */
volatile PMFENCASTR _PMFENCA;                              /* PMF Enable Control A Register; 0x00000220 */
volatile PMFFQCASTR _PMFFQCA;                              /* PMF Enable Control A Register; 0x00000221 */
volatile PMFENCBSTR _PMFENCB;                              /* PMF Enable Control B Register; 0x00000228 */
volatile PMFFQCBSTR _PMFFQCB;                              /* PMF Frequency Control B Register; 0x00000229 */
volatile PMFENCCSTR _PMFENCC;                              /* PMF Enable Control C Register; 0x00000230 */
volatile PMFFQCCSTR _PMFFQCC;                              /* PMF Frequency Control C Register; 0x00000231 */
volatile PTTSTR _PTT;                                      /* Port T Data Register; 0x00000240 */
volatile PTITSTR _PTIT;                                    /* Port T Input Register; 0x00000241 */
volatile DDRTSTR _DDRT;                                    /* Port T Data Direction Register; 0x00000242 */
volatile RDRTSTR _RDRT;                                    /* Port T Reduced Drive Register; 0x00000243 */
volatile PERTSTR _PERT;                                    /* Port T Pull Device Enable Register; 0x00000244 */
volatile PPSTSTR _PPST;                                    /* Port T Polarity Select Register; 0x00000245 */
volatile PTSSTR _PTS;                                      /* Port S Data Register; 0x00000248 */
volatile PTISSTR _PTIS;                                    /* Port S Input Register; 0x00000249 */
volatile DDRSSTR _DDRS;                                    /* Port S Data Direction Register; 0x0000024A */
volatile RDRSSTR _RDRS;                                    /* Port S Reduced Drive Register; 0x0000024B */
volatile PERSSTR _PERS;                                    /* Port S Pull Device Enable Register; 0x0000024C */
volatile PPSSSTR _PPSS;                                    /* Port S Polarity Select Register; 0x0000024D */
volatile WOMSSTR _WOMS;                                    /* Port S Wired-Or Mode Register; 0x0000024E */
volatile PTMSTR _PTM;                                      /* Port M Data Register; 0x00000250 */
volatile PTIMSTR _PTIM;                                    /* Port M Input Register; 0x00000251 */
volatile DDRMSTR _DDRM;                                    /* Port M Data Direction Register; 0x00000252 */
volatile RDRMSTR _RDRM;                                    /* Port M Reduced Drive Register; 0x00000253 */
volatile PERMSTR _PERM;                                    /* Port M Pull Device Enable Register; 0x00000254 */
volatile PPSMSTR _PPSM;                                    /* Port M Polarity Select Register; 0x00000255 */
volatile WOMMSTR _WOMM;                                    /* Port M Wired-Or Mode Register; 0x00000256 */
volatile PTPSTR _PTP;                                      /* Port P Data Register; 0x00000258 */
volatile PTIPSTR _PTIP;                                    /* Port P Input Register; 0x00000259 */
volatile DDRPSTR _DDRP;                                    /* Port P Data Direction Register; 0x0000025A */
volatile RDRPSTR _RDRP;                                    /* Port P Reduced Drive Register; 0x0000025B */
volatile PERPSTR _PERP;                                    /* Port P Pull Device Enable Register; 0x0000025C */
volatile PPSPSTR _PPSP;                                    /* Port P Polarity Select Register; 0x0000025D */
volatile PTHSTR _PTH;                                      /* Port H Data Register; 0x00000260 */
volatile PTIHSTR _PTIH;                                    /* Port H Input Register; 0x00000261 */
volatile DDRHSTR _DDRH;                                    /* Port H Data Direction Register; 0x00000262 */
volatile RDRHSTR _RDRH;                                    /* Port H Reduced Drive Register; 0x00000263 */
volatile PERHSTR _PERH;                                    /* Port H Pull Device Enable Register; 0x00000264 */
volatile PPSHSTR _PPSH;                                    /* Port H Polarity Select Register; 0x00000265 */
volatile PTJSTR _PTJ;                                      /* Port J Data Register; 0x00000268 */
volatile PTIJSTR _PTIJ;                                    /* Port J Input Register; 0x00000269 */
volatile DDRJSTR _DDRJ;                                    /* Port J Data Direction Register; 0x0000026A */
volatile RDRJSTR _RDRJ;                                    /* Port J Reduced Drive Register; 0x0000026B */
volatile PERJSTR _PERJ;                                    /* Port J Pull Device Enable Register; 0x0000026C */
volatile PPSJSTR _PPSJ;                                    /* Port J Polarity Select Register; 0x0000026D */
volatile VREGHTCLSTR _VREGHTCL;                            /* HT Control Register; 0x000002F0 */
volatile VREGCTRLSTR _VREGCTRL;                            /* Control Register; 0x000002F1 */
volatile VREGAPICLSTR _VREGAPICL;                          /* Autonomous Periodical Interrupt Control Register; 0x000002F2 */
volatile VREGAPITRSTR _VREGAPITR;                          /* Autonomous Periodical Interrupt Trimming Register; 0x000002F3 */
volatile VREGHTTRSTR _VREGHTTR;                            /* HTTrimming Register; 0x000002F7 */
volatile CGMSYNRSTR _CGMSYNR;                              /* Debug Control Register 1; 0x00000300 */
volatile CGMREFDVSTR _CGMREFDV;                            /* CGMIPLL Reference Divider Register; 0x00000301 */
volatile CGMFLGSTR _CGMFLG;                                /* CGMIPLL Flags Register; 0x00000303 */
volatile CGMCTLSTR _CGMCTL;                                /* CGMIPLL Control Register; 0x00000304 */
volatile PITCFLMTSTR _PITCFLMT;                            /* PIT Control and Force Load Micro Timer Register; 0x00000340 */
volatile PITFLTSTR _PITFLT;                                /* PIT Force Load Timer Register; 0x00000341 */
volatile PITCESTR _PITCE;                                  /* PIT Channel Enable Register; 0x00000342 */
volatile PITMUXSTR _PITMUX;                                /* PIT Multiplex Register; 0x00000343 */
volatile PITINTESTR _PITINTE;                              /* PIT Interrupt Enable Register; 0x00000344 */
volatile PITTFSTR _PITTF;                                  /* PIT Time-out Flag Register; 0x00000345 */
volatile PITMTLD0STR _PITMTLD0;                            /* PIT Micro Timer Load Register 0; 0x00000346 */
volatile PITMTLD1STR _PITMTLD1;                            /* PIT Micro Timer Load Register 1; 0x00000347 */
volatile PITCSTPSTR _PITCSTP;                              /* PIT Channel Stop Register; 0x00000368 */
volatile PITTRIGOUTSTR _PITTRIGOUT;                        /* PIT Combined Output Trigger Configuration Register; 0x00000369 */
volatile PITTRIGCTLSTR _PITTRIGCTL;                        /* PIT Input Trigger Control Register; 0x0000036A */
volatile PITTRIGSTATSTR _PITTRIGSTAT;                      /* PIT Input Trigger Status Register; 0x0000036B */
volatile PITTRIGESTR _PITTRIGE;                            /* PIT Input Trigger Channel Enable Register; 0x0000036C */
volatile XGCHIDSTR _XGCHID;                                /* XGATE Channel ID Register; 0x00000382 */
volatile XGCHPLSTR _XGCHPL;                                /* XGATE Channel Priority Level; 0x00000383 */
volatile XGISPSELSTR _XGISPSEL;                            /* XGATE Initial Stack Pointer Select Register; 0x00000385 */
volatile XGCCRSTR _XGCCR;                                  /* XGATE Condition Code Register; 0x0000039D */
/* NVFPROT - macro for reading non volatile register       Non Volatile P-Flash Protection Register; 0x0000FF0C */
/* NVEPROT - macro for reading non volatile register       Non Volatile EEE Protection Register; 0x0000FF0D */
/* NVFOPT - macro for reading non volatile register        Non Volatile Flash Option Register; 0x0000FF0E */
/* NVFSEC - macro for reading non volatile register        Non Volatile Flash Security Register; 0x0000FF0F */


/* * * * *  16-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile PORTABSTR _PORTAB;                                /* Port AB Data Register; 0x00000000 */
volatile DDRABSTR _DDRAB;                                  /* Port AB Data Direction Register; 0x00000002 */
volatile PORTCDSTR _PORTCD;                                /* Port CD Data Register; 0x00000004 */
volatile DDRCDSTR _DDRCD;                                  /* Port CD Data Direction Register; 0x00000006 */
volatile PARTIDSTR _PARTID;                                /* Part ID Register; 0x0000001A */
volatile DBGTBSTR _DBGTB;                                  /* Debug Trace Buffer Register; 0x00000024 */
volatile TCNTSTR _TCNT;                                    /* Timer Count Register; 0x00000044 */
volatile TC0STR _TC0;                                      /* Timer Input Capture/Output Compare Register 0; 0x00000050 */
volatile TC1STR _TC1;                                      /* Timer Input Capture/Output Compare Register 1; 0x00000052 */
volatile TC2STR _TC2;                                      /* Timer Input Capture/Output Compare Register 2; 0x00000054 */
volatile TC3STR _TC3;                                      /* Timer Input Capture/Output Compare Register 3; 0x00000056 */
volatile TC4STR _TC4;                                      /* Timer Input Capture/Output Compare Register 4; 0x00000058 */
volatile TC5STR _TC5;                                      /* Timer Input Capture/Output Compare Register 5; 0x0000005A */
volatile TC6STR _TC6;                                      /* Timer Input Capture/Output Compare Register 6; 0x0000005C */
volatile TC7STR _TC7;                                      /* Timer Input Capture/Output Compare Register 7; 0x0000005E */
volatile PACN32STR _PACN32;                                /* Pulse Accumulators Count 32 Register; 0x00000062 */
volatile PACN10STR _PACN10;                                /* Pulse Accumulators Count 10 Register; 0x00000064 */
volatile PA32HSTR _PA32H;                                  /* 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 */
volatile PA10HSTR _PA10H;                                  /* 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 */
volatile MCCNTSTR _MCCNT;                                  /* Modulus Down-Counter Count Register; 0x00000076 */
volatile TC0HSTR _TC0H;                                    /* Timer Input Capture Holding Registers 0; 0x00000078 */
volatile TC1HSTR _TC1H;                                    /* Timer Input Capture Holding Registers 1; 0x0000007A */
volatile TC2HSTR _TC2H;                                    /* Timer Input Capture Holding Registers 2; 0x0000007C */
volatile TC3HSTR _TC3H;                                    /* Timer Input Capture Holding Registers 3; 0x0000007E */
volatile ATDCTL01STR _ATDCTL01;                            /* ATD  Control Register 01; 0x00000080 */
volatile ATDCTL23STR _ATDCTL23;                            /* ATD  Control Register 23; 0x00000082 */
volatile ATDCTL45STR _ATDCTL45;                            /* ATD  Control Register 45; 0x00000084 */
volatile ATDCMPESTR _ATDCMPE;                              /* ATD  Compare Enable Register; 0x00000088 */
volatile ATDSTAT2STR _ATDSTAT2;                            /* ATD  Status Register 2; 0x0000008A */
volatile ATDDIENSTR _ATDDIEN;                              /* ATD  Input Enable Register; 0x0000008C */
volatile ATDCMPHTSTR _ATDCMPHT;                            /* ATD  Compare Higher Than Register; 0x0000008E */
volatile ATDDR0STR _ATDDR0;                                /* ATD  Conversion Result Register 0; 0x00000090 */
volatile ATDDR1STR _ATDDR1;                                /* ATD  Conversion Result Register 1; 0x00000092 */
volatile ATDDR2STR _ATDDR2;                                /* ATD  Conversion Result Register 2; 0x00000094 */
volatile ATDDR3STR _ATDDR3;                                /* ATD  Conversion Result Register 3; 0x00000096 */
volatile ATDDR4STR _ATDDR4;                                /* ATD  Conversion Result Register 4; 0x00000098 */
volatile ATDDR5STR _ATDDR5;                                /* ATD  Conversion Result Register 5; 0x0000009A */
volatile ATDDR6STR _ATDDR6;                                /* ATD  Conversion Result Register 6; 0x0000009C */
volatile ATDDR7STR _ATDDR7;                                /* ATD  Conversion Result Register 7; 0x0000009E */
volatile ATDDR8STR _ATDDR8;                                /* ATD  Conversion Result Register 8; 0x000000A0 */
volatile ATDDR9STR _ATDDR9;                                /* ATD  Conversion Result Register 9; 0x000000A2 */
volatile ATDDR10STR _ATDDR10;                              /* ATD  Conversion Result Register 10; 0x000000A4 */
volatile ATDDR11STR _ATDDR11;                              /* ATD  Conversion Result Register 11; 0x000000A6 */
volatile ATDDR12STR _ATDDR12;                              /* ATD  Conversion Result Register 12; 0x000000A8 */
volatile ATDDR13STR _ATDDR13;                              /* ATD  Conversion Result Register 13; 0x000000AA */
volatile ATDDR14STR _ATDDR14;                              /* ATD  Conversion Result Register 14; 0x000000AC */
volatile ATDDR15STR _ATDDR15;                              /* ATD  Conversion Result Register 15; 0x000000AE */
volatile SCI0BDSTR _SCI0BD;                                /* SCI 0 Baud Rate Register; 0x000000C8 */
volatile SCI1BDSTR _SCI1BD;                                /* SCI 1 Baud Rate Register; 0x000000D0 */
volatile SPI0DRSTR _SPI0DR;                                /* SPI 0 Data Register; 0x000000DC */
volatile SPI1DRSTR _SPI1DR;                                /* SPI 1 Data Register; 0x000000F4 */
volatile FCCOBSTR _FCCOB;                                  /* Flash Common Command Object Register; 0x0000010A */
volatile ETAGSTR _ETAG;                                    /* EEE Tag Counter Register; 0x0000010C */
volatile FECCRSTR _FECCR;                                  /* Flash ECC Error Results Register; 0x0000010E */
volatile CAN0RXTSRSTR _CAN0RXTSR;                          /* MSCAN0 Receive Time Stamp Register; 0x0000016E */
volatile CAN0TXTSRSTR _CAN0TXTSR;                          /* MSCAN0 Transmit Time Stamp Register; 0x0000017E */
volatile PMFVAL0STR _PMFVAL0;                              /* PMF Value 0 Register; 0x00000210 */
volatile PMFVAL1STR _PMFVAL1;                              /* PMF Value 1 Register; 0x00000212 */
volatile PMFVAL2STR _PMFVAL2;                              /* PMF Value 2 Register; 0x00000214 */
volatile PMFVAL3STR _PMFVAL3;                              /* PMF Value 3 Register; 0x00000216 */
volatile PMFVAL4STR _PMFVAL4;                              /* PMF Value 4 Register; 0x00000218 */
volatile PMFVAL5STR _PMFVAL5;                              /* PMF Value 5 Register; 0x0000021A */
volatile PMFCNTASTR _PMFCNTA;                              /* PMF counter A Register; 0x00000222 */
volatile PMFMODASTR _PMFMODA;                              /* PMF modulo counter A Register; 0x00000224 */
volatile PMFDTMASTR _PMFDTMA;                              /* PMF deadtime A Register; 0x00000226 */
volatile PMFCNTBSTR _PMFCNTB;                              /* PMF counter B Register; 0x0000022A */
volatile PMFMODBSTR _PMFMODB;                              /* PMF modulo counter B Register; 0x0000022C */
volatile PMFDTMBSTR _PMFDTMB;                              /* PMF deadtime B Register; 0x0000022E */
volatile PMFCNTCSTR _PMFCNTC;                              /* PMF counter C Register; 0x00000232 */
volatile PMFMODCSTR _PMFMODC;                              /* PMF modulo counter C Register; 0x00000234 */
volatile PMFDTMCSTR _PMFDTMC;                              /* PMF deadtime C Register; 0x00000236 */
volatile PT01ADSTR _PT01AD;                                /* Port AD Data Register; 0x00000270 */
volatile DDR01ADSTR _DDR01AD;                              /* Port AD Data Direction Register; 0x00000272 */
volatile RDR01ADSTR _RDR01AD;                              /* Port AD Reduced Drive Register; 0x00000274 */
volatile PER01ADSTR _PER01AD;                              /* Port AD Pull Up Enable Register; 0x00000276 */
volatile VREGAPIRSTR _VREGAPIR;                            /* Autonomous Periodical Interrupt Rate Register; 0x000002F4 */
volatile PITLD0STR _PITLD0;                                /* PIT Load Register 0; 0x00000348 */
volatile PITCNT0STR _PITCNT0;                              /* PIT Count Register 0; 0x0000034A */
volatile PITLD1STR _PITLD1;                                /* PIT Load Register 1; 0x0000034C */
volatile PITCNT1STR _PITCNT1;                              /* PIT Count Register 1; 0x0000034E */
volatile PITLD2STR _PITLD2;                                /* PIT Load Register 2; 0x00000350 */
volatile PITCNT2STR _PITCNT2;                              /* PIT Count Register 2; 0x00000352 */
volatile PITLD3STR _PITLD3;                                /* PIT Load Register 3; 0x00000354 */
volatile PITCNT3STR _PITCNT3;                              /* PIT Count Register 3; 0x00000356 */
volatile PITLD4STR _PITLD4;                                /* PIT Load Register 4; 0x00000358 */
volatile PITCNT4STR _PITCNT4;                              /* PIT Count Register 4; 0x0000035A */
volatile PITLD5STR _PITLD5;                                /* PIT Load Register 5; 0x0000035C */
volatile PITCNT5STR _PITCNT5;                              /* PIT Count Register 5; 0x0000035E */
volatile PITLD6STR _PITLD6;                                /* PIT Load Register 6; 0x00000360 */
volatile PITCNT6STR _PITCNT6;                              /* PIT Count Register 6; 0x00000362 */
volatile PITLD7STR _PITLD7;                                /* PIT Load Register 7; 0x00000364 */
volatile PITCNT7STR _PITCNT7;                              /* PIT Count Register 7; 0x00000366 */
volatile XGMCTLSTR _XGMCTL;                                /* XGATE Control Register; 0x00000380 */
volatile XGISP31STR _XGISP31;                              /* XGATE Initial Stack Pointer for Interrupt Priorities 3 to 1; 0x00000386 */
volatile XGIF_7F_70STR _XGIF_7F_70;                        /* XGATE Channel Interrupt Flag Vector; 0x00000388 */
volatile XGIF_6F_60STR _XGIF_6F_60;                        /* XGATE Channel Interrupt Flag Vector; 0x0000038A */
volatile XGIF_5F_50STR _XGIF_5F_50;                        /* XGATE Channel Interrupt Flag Vector; 0x0000038C */
volatile XGIF_4F_40STR _XGIF_4F_40;                        /* XGATE Channel Interrupt Flag Vector; 0x0000038E */
volatile XGIF_3F_30STR _XGIF_3F_30;                        /* XGATE Channel Interrupt Flag Vector; 0x00000390 */
volatile XGIF_2F_20STR _XGIF_2F_20;                        /* XGATE Channel Interrupt Flag Vector; 0x00000392 */
volatile XGIF_1F_10STR _XGIF_1F_10;                        /* XGATE Channel Interrupt Flag Vector; 0x00000394 */
volatile XGIF_0F_00STR _XGIF_0F_00;                        /* XGATE Channel Interrupt Flag Vector; 0x00000396 */
volatile XGSWTSTR _XGSWT;                                  /* XGATE Control Register; 0x00000398 */
volatile XGSEMSTR _XGSEM;                                  /* XGATE Semaphore Register; 0x0000039A */
volatile XGPCSTR _XGPC;                                    /* XGATE Program Counter Register; 0x0000039E */
volatile XGR1STR _XGR1;                                    /* XGATE Register 1; 0x000003A2 */
volatile XGR2STR _XGR2;                                    /* XGATE Register 2; 0x000003A4 */
volatile XGR3STR _XGR3;                                    /* XGATE Register 3; 0x000003A6 */
volatile XGR4STR _XGR4;                                    /* XGATE Register 4; 0x000003A8 */
volatile XGR5STR _XGR5;                                    /* XGATE Register 5; 0x000003AA */
volatile XGR6STR _XGR6;                                    /* XGATE Register 6; 0x000003AC */
volatile XGR7STR _XGR7;                                    /* XGATE Register 7; 0x000003AE */
volatile MVRSTR _MVR;                                      /* Module Version Register; 0x00000400 */
volatile MCRSTR _MCR;                                      /* Module Configuration Register; 0x00000402 */
volatile STBSCRSTR _STBSCR;                                /* Strobe Signal Control Register; 0x00000408 */
volatile STBPCRSTR _STBPCR;                                /* Strobe Port Control Register; 0x0000040A */
volatile MBDSRSTR _MBDSR;                                  /* Message Buffer Data Size Register; 0x0000040C */
volatile MBSSUTRSTR _MBSSUTR;                              /* Message Buffer Segment Size and Utilization Register; 0x0000040E */
volatile POCRSTR _POCR;                                    /* Message Buffer Segment Size and Utilization Register; 0x00000414 */
volatile GIFERSTR _GIFER;                                  /* Message Buffer Segment Size and Utilization Register; 0x00000416 */
volatile PIFR0STR _PIFR0;                                  /* Protocol Interrupt Flag Register; 0x00000418 */
volatile PIFR1STR _PIFR1;                                  /* Protocol Interrupt Flag Register; 0x0000041A */
volatile PIER0STR _PIER0;                                  /* Protocol Interrupt Enable Register; 0x0000041C */
volatile PIER1STR _PIER1;                                  /* Protocol Interrupt Enable Register; 0x0000041E */
volatile CHIERFRSTR _CHIERFR;                              /* Protocol Interrupt Flag Register; 0x00000420 */
volatile MBIVECSTR _MBIVEC;                                /* Message Buffer Data Size Register; 0x00000422 */
volatile CASERCRSTR _CASERCR;                              /* Channel A Status Error Counter Register; 0x00000424 */
volatile CBSERCRSTR _CBSERCR;                              /* Channel B Status Error Counter Register; 0x00000426 */
volatile PSR0STR _PSR0;                                    /* Protocol Status 0 Register; 0x00000428 */
volatile PSR1STR _PSR1;                                    /* Protocol Status 1 Register; 0x0000042A */
volatile PSR2STR _PSR2;                                    /* Protocol Status 0 Register; 0x0000042C */
volatile PSR3STR _PSR3;                                    /* Protocol Status 3 Register; 0x0000042E */
volatile MTCTRSTR _MTCTR;                                  /* Macrotick Counter Register; 0x00000430 */
volatile CYCTRSTR _CYCTR;                                  /* Cycle Counter Register; 0x00000432 */
volatile SLTCTARSTR _SLTCTAR;                              /* Slot Counter Channel A Register; 0x00000434 */
volatile SLTCTBRSTR _SLTCTBR;                              /* Slot Counter Channel B Register; 0x00000436 */
volatile RTCORVRSTR _RTCORVR;                              /* Rate Correction Value Register; 0x00000438 */
volatile OFCORVRSTR _OFCORVR;                              /* Offset Correction Value Register; 0x0000043A */
volatile CIFRRSTR _CIFRR;                                  /* Combined Interrupt Flag Register; 0x0000043C */
volatile SYMATORSTR _SYMATOR;                              /* System Memory Access Time-Out Register Register; 0x0000043E */
volatile SFCNTRSTR _SFCNTR;                                /* Sync Frame Counter Register; 0x00000440 */
volatile SFTORSTR _SFTOR;                                  /* Sync Frame Table Offset Register; 0x00000442 */
volatile SFTCCSRSTR _SFTCCSR;                              /* Sync Frame Table Configuration, Control, Status Register; 0x00000444 */
volatile SFIDRFRSTR _SFIDRFR;                              /* Sync Frame ID Rejection Filter Register; 0x00000446 */
volatile SFIDAFVRSTR _SFIDAFVR;                            /* Sync Frame ID Acceptance Filter Value Register; 0x00000448 */
volatile SFIDAFMRSTR _SFIDAFMR;                            /* Sync Frame ID Acceptance Filter Mask Register; 0x0000044A */
volatile NMVR0STR _NMVR0;                                  /* Network Management Vector Register; 0x0000044C */
volatile NMVR1STR _NMVR1;                                  /* Network Management Vector Register; 0x0000044E */
volatile NMVR2STR _NMVR2;                                  /* Network Management Vector Register; 0x00000450 */
volatile NMVR3STR _NMVR3;                                  /* Network Management Vector Register; 0x00000452 */
volatile NMVR4STR _NMVR4;                                  /* Network Management Vector Register; 0x00000454 */
volatile NMVR5STR _NMVR5;                                  /* Network Management Vector Register; 0x00000456 */
volatile NMVLRSTR _NMVLR;                                  /* Network Management Vector Length Register; 0x00000458 */
volatile TICCRSTR _TICCR;                                  /* Timer Configuration and Control Register; 0x0000045A */
volatile TI1CYSRSTR _TI1CYSR;                              /* Timer 1 Cycle Set Register; 0x0000045C */
volatile TI1MTORSTR _TI1MTOR;                              /* Timer 1 Macrotick Offset Register; 0x0000045E */
volatile TI2CR0_MTCNTSTR _TI2CR0_MTCNT;                    /* Timer 2 Configuration Register 0; 0x00000460 */
volatile TI2CR1_MTOFFSETSTR _TI2CR1_MTOFFSET;              /* Timer 2 Configuration Register 1; 0x00000462 */
volatile SSSRSTR _SSSR;                                    /* Slot Status Selection Register; 0x00000464 */
volatile SSCCRSTR _SSCCR;                                  /* Slot Status Counter Condition Register; 0x00000466 */
volatile SSR0STR _SSR0;                                    /* Slot Status 0 Register; 0x00000468 */
volatile SSR1STR _SSR1;                                    /* Slot Status 1 Register; 0x0000046A */
volatile SSR2STR _SSR2;                                    /* Slot Status 2 Register; 0x0000046C */
volatile SSR3STR _SSR3;                                    /* Slot Status 3 Register; 0x0000046E */
volatile SSR4STR _SSR4;                                    /* Slot Status 4 Register; 0x00000470 */
volatile SSR5STR _SSR5;                                    /* Slot Status 5 Register; 0x00000472 */
volatile SSR6STR _SSR6;                                    /* Slot Status 6 Register; 0x00000474 */
volatile SSR7STR _SSR7;                                    /* Slot Status 7 Register; 0x00000476 */
volatile SSCR0STR _SSCR0;                                  /* Slot Status Counter 0 Register; 0x00000478 */
volatile SSCR1STR _SSCR1;                                  /* Slot Status Counter 1 Register; 0x0000047A */
volatile SSCR2STR _SSCR2;                                  /* Slot Status Counter 2 Register; 0x0000047C */
volatile SSCR3STR _SSCR3;                                  /* Slot Status Counter 3 Register; 0x0000047E */
volatile MTSACFRSTR _MTSACFR;                              /* MTS A Configuration Register; 0x00000480 */
volatile MTSBCFRSTR _MTSBCFR;                              /* MTS B Configuration Register; 0x00000482 */
volatile RSBIRSTR _RSBIR;                                  /* Receive Shadow Buffer Index Register; 0x00000484 */
volatile RFSRSTR _RFSR;                                    /* Receive FIFO Selection Register; 0x00000486 */
volatile RFSIRSTR _RFSIR;                                  /* Receive FIFO Start Index Register; 0x00000488 */
volatile RFDSRSTR _RFDSR;                                  /* Receive FIFO Start Index Register; 0x0000048A */
volatile RFARIRSTR _RFARIR;                                /* Receive FIFO A Read Index Register; 0x0000048C */
volatile RFBRIRSTR _RFBRIR;                                /* Receive FIFO B Read Index Register; 0x0000048E */
volatile RFMIDAFVRSTR _RFMIDAFVR;                          /* Receive FIFO Message ID Acceptance Filter Value Register; 0x00000490 */
volatile RFMIAFMRSTR _RFMIAFMR;                            /* Receive FIFO Message ID Acceptance Filter Mask Register; 0x00000492 */
volatile RFFIDRFVRSTR _RFFIDRFVR;                          /* Receive FIFO Frame ID Rejection Filter Value Register; 0x00000494 */
volatile RFFIDRFMRSTR _RFFIDRFMR;                          /* Receive FIFO Frame ID Rejection Filter Mask Register; 0x00000496 */
volatile RFRFCFRSTR _RFRFCFR;                              /* Receive FIFO Range Filter Configuration Register; 0x00000498 */
volatile RFRFCTRSTR _RFRFCTR;                              /* Receive FIFO Range Filter Control Register; 0x0000049A */
volatile LDTXSLARSTR _LDTXSLAR;                            /* Last Dynamic Transmit Slot Channel A Register; 0x0000049C */
volatile LDTXSLBRSTR _LDTXSLBR;                            /* Last Dynamic Transmit Slot Channel B Register; 0x0000049E */
volatile PCR0STR _PCR0;                                    /* Protocol Configuration Register 0; 0x000004A0 */
volatile PCR1STR _PCR1;                                    /* Protocol Configuration Register 1; 0x000004A2 */
volatile PCR2STR _PCR2;                                    /* Protocol Configuration Register 2; 0x000004A4 */
volatile PCR3STR _PCR3;                                    /* Protocol Configuration Register 3; 0x000004A6 */
volatile PCR4STR _PCR4;                                    /* Protocol Configuration Register 4; 0x000004A8 */
volatile PCR5STR _PCR5;                                    /* Protocol Configuration Register 5; 0x000004AA */
volatile PCR6STR _PCR6;                                    /* Protocol Configuration Register 6; 0x000004AC */
volatile PCR7STR _PCR7;                                    /* Protocol Configuration Register 7; 0x000004AE */
volatile PCR8STR _PCR8;                                    /* Protocol Configuration Register 8; 0x000004B0 */
volatile PCR9STR _PCR9;                                    /* Protocol Configuration Register 9; 0x000004B2 */
volatile PCR10STR _PCR10;                                  /* Protocol Configuration Register 10; 0x000004B4 */
volatile PCR11STR _PCR11;                                  /* Protocol Configuration Register 11; 0x000004B6 */
volatile PCR12STR _PCR12;                                  /* Protocol Configuration Register 12; 0x000004B8 */
volatile PCR13STR _PCR13;                                  /* Protocol Configuration Register 13; 0x000004BA */
volatile PCR14STR _PCR14;                                  /* Protocol Configuration Register 14; 0x000004BC */
volatile PCR15STR _PCR15;                                  /* Protocol Configuration Register 15; 0x000004BE */
volatile PCR16STR _PCR16;                                  /* Protocol Configuration Register 16; 0x000004C0 */
volatile PCR17STR _PCR17;                                  /* Protocol Configuration Register 17; 0x000004C2 */
volatile PCR18STR _PCR18;                                  /* Protocol Configuration Register 18; 0x000004C4 */
volatile PCR19STR _PCR19;                                  /* Protocol Configuration Register 19; 0x000004C6 */
volatile PCR20STR _PCR20;                                  /* Protocol Configuration Register 20; 0x000004C8 */
volatile PCR21STR _PCR21;                                  /* Protocol Configuration Register 21; 0x000004CA */
volatile PCR22STR _PCR22;                                  /* Protocol Configuration Register 22; 0x000004CC */
volatile PCR23STR _PCR23;                                  /* Protocol Configuration Register 23; 0x000004CE */
volatile PCR24STR _PCR24;                                  /* Protocol Configuration Register 24; 0x000004D0 */
volatile PCR25STR _PCR25;                                  /* Protocol Configuration Register 25; 0x000004D2 */
volatile PCR26STR _PCR26;                                  /* Protocol Configuration Register 26; 0x000004D4 */
volatile PCR27STR _PCR27;                                  /* Protocol Configuration Register 27; 0x000004D6 */
volatile PCR28STR _PCR28;                                  /* Protocol Configuration Register 28; 0x000004D8 */
volatile PCR29STR _PCR29;                                  /* Protocol Configuration Register 29; 0x000004DA */
volatile PCR30STR _PCR30;                                  /* Protocol Configuration Register 30; 0x000004DC */
volatile MBCCSR0STR _MBCCSR0;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000500 */
volatile MBCCFR0STR _MBCCFR0;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000502 */
volatile MBFIDR0STR _MBFIDR0;                              /* Message Buffer Frame ID Registers; 0x00000504 */
volatile MBIDXR0STR _MBIDXR0;                              /* Message Buffer Index Registers; 0x00000506 */
volatile MBCCSR1STR _MBCCSR1;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000508 */
volatile MBCCFR1STR _MBCCFR1;                              /* Message Buffer Configuration, Control, Status Registers; 0x0000050A */
volatile MBFIDR1STR _MBFIDR1;                              /* Message Buffer Frame ID Registers; 0x0000050C */
volatile MBIDXR1STR _MBIDXR1;                              /* Message Buffer Index Registers; 0x0000050E */
volatile MBCCSR2STR _MBCCSR2;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000510 */
volatile MBCCFR2STR _MBCCFR2;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000512 */
volatile MBFIDR2STR _MBFIDR2;                              /* Message Buffer Frame ID Registers; 0x00000514 */
volatile MBIDXR2STR _MBIDXR2;                              /* Message Buffer Index Registers; 0x00000516 */
volatile MBCCSR3STR _MBCCSR3;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000518 */
volatile MBCCFR3STR _MBCCFR3;                              /* Message Buffer Configuration, Control, Status Registers; 0x0000051A */
volatile MBFIDR3STR _MBFIDR3;                              /* Message Buffer Frame ID Registers; 0x0000051C */
volatile MBIDXR3STR _MBIDXR3;                              /* Message Buffer Index Registers; 0x0000051E */
volatile MBCCSR4STR _MBCCSR4;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000520 */
volatile MBCCFR4STR _MBCCFR4;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000522 */
volatile MBFIDR4STR _MBFIDR4;                              /* Message Buffer Frame ID Registers; 0x00000524 */
volatile MBIDXR4STR _MBIDXR4;                              /* Message Buffer Index Registers; 0x00000526 */
volatile MBCCSR5STR _MBCCSR5;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000528 */
volatile MBCCFR5STR _MBCCFR5;                              /* Message Buffer Configuration, Control, Status Registers; 0x0000052A */
volatile MBFIDR5STR _MBFIDR5;                              /* Message Buffer Frame ID Registers; 0x0000052C */
volatile MBIDXR5STR _MBIDXR5;                              /* Message Buffer Index Registers; 0x0000052E */
volatile MBCCSR6STR _MBCCSR6;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000530 */
volatile MBCCFR6STR _MBCCFR6;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000532 */
volatile MBFIDR6STR _MBFIDR6;                              /* Message Buffer Frame ID Registers; 0x00000534 */
volatile MBIDXR6STR _MBIDXR6;                              /* Message Buffer Index Registers; 0x00000536 */
volatile MBCCSR7STR _MBCCSR7;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000538 */
volatile MBCCFR7STR _MBCCFR7;                              /* Message Buffer Configuration, Control, Status Registers; 0x0000053A */
volatile MBFIDR7STR _MBFIDR7;                              /* Message Buffer Frame ID Registers; 0x0000053C */
volatile MBIDXR7STR _MBIDXR7;                              /* Message Buffer Index Registers; 0x0000053E */
volatile MBCCSR8STR _MBCCSR8;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000540 */
volatile MBCCFR8STR _MBCCFR8;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000542 */
volatile MBFIDR8STR _MBFIDR8;                              /* Message Buffer Frame ID Registers; 0x00000544 */
volatile MBIDXR8STR _MBIDXR8;                              /* Message Buffer Index Registers; 0x00000546 */
volatile MBCCSR9STR _MBCCSR9;                              /* Message Buffer Configuration, Control, Status Registers; 0x00000548 */
volatile MBCCFR9STR _MBCCFR9;                              /* Message Buffer Configuration, Control, Status Registers; 0x0000054A */
volatile MBFIDR9STR _MBFIDR9;                              /* Message Buffer Frame ID Registers; 0x0000054C */
volatile MBIDXR9STR _MBIDXR9;                              /* Message Buffer Index Registers; 0x0000054E */
volatile MBCCSR10STR _MBCCSR10;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000550 */
volatile MBCCFR10STR _MBCCFR10;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000552 */
volatile MBFIDR10STR _MBFIDR10;                            /* Message Buffer Frame ID Registers; 0x00000554 */
volatile MBIDXR10STR _MBIDXR10;                            /* Message Buffer Index Registers; 0x00000556 */
volatile MBCCSR11STR _MBCCSR11;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000558 */
volatile MBCCFR11STR _MBCCFR11;                            /* Message Buffer Configuration, Control, Status Registers; 0x0000055A */
volatile MBFIDR11STR _MBFIDR11;                            /* Message Buffer Frame ID Registers; 0x0000055C */
volatile MBIDXR11STR _MBIDXR11;                            /* Message Buffer Index Registers; 0x0000055E */
volatile MBCCSR12STR _MBCCSR12;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000560 */
volatile MBCCFR12STR _MBCCFR12;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000562 */
volatile MBFIDR12STR _MBFIDR12;                            /* Message Buffer Frame ID Registers; 0x00000564 */
volatile MBIDXR12STR _MBIDXR12;                            /* Message Buffer Index Registers; 0x00000566 */
volatile MBCCSR13STR _MBCCSR13;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000568 */
volatile MBCCFR13STR _MBCCFR13;                            /* Message Buffer Configuration, Control, Status Registers; 0x0000056A */
volatile MBFIDR13STR _MBFIDR13;                            /* Message Buffer Frame ID Registers; 0x0000056C */
volatile MBIDXR13STR _MBIDXR13;                            /* Message Buffer Index Registers; 0x0000056E */
volatile MBCCSR14STR _MBCCSR14;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000570 */
volatile MBCCFR14STR _MBCCFR14;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000572 */
volatile MBFIDR14STR _MBFIDR14;                            /* Message Buffer Frame ID Registers; 0x00000574 */
volatile MBIDXR14STR _MBIDXR14;                            /* Message Buffer Index Registers; 0x00000576 */
volatile MBCCSR15STR _MBCCSR15;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000578 */
volatile MBCCFR15STR _MBCCFR15;                            /* Message Buffer Configuration, Control, Status Registers; 0x0000057A */
volatile MBFIDR15STR _MBFIDR15;                            /* Message Buffer Frame ID Registers; 0x0000057C */
volatile MBIDXR15STR _MBIDXR15;                            /* Message Buffer Index Registers; 0x0000057E */
volatile MBCCSR16STR _MBCCSR16;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000580 */
volatile MBCCFR16STR _MBCCFR16;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000582 */
volatile MBFIDR16STR _MBFIDR16;                            /* Message Buffer Frame ID Registers; 0x00000584 */
volatile MBIDXR16STR _MBIDXR16;                            /* Message Buffer Index Registers; 0x00000586 */
volatile MBCCSR17STR _MBCCSR17;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000588 */
volatile MBCCFR17STR _MBCCFR17;                            /* Message Buffer Configuration, Control, Status Registers; 0x0000058A */
volatile MBFIDR17STR _MBFIDR17;                            /* Message Buffer Frame ID Registers; 0x0000058C */
volatile MBIDXR17STR _MBIDXR17;                            /* Message Buffer Index Registers; 0x0000058E */
volatile MBCCSR18STR _MBCCSR18;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000590 */
volatile MBCCFR18STR _MBCCFR18;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000592 */
volatile MBFIDR18STR _MBFIDR18;                            /* Message Buffer Frame ID Registers; 0x00000594 */
volatile MBIDXR18STR _MBIDXR18;                            /* Message Buffer Index Registers; 0x00000596 */
volatile MBCCSR19STR _MBCCSR19;                            /* Message Buffer Configuration, Control, Status Registers; 0x00000598 */
volatile MBCCFR19STR _MBCCFR19;                            /* Message Buffer Configuration, Control, Status Registers; 0x0000059A */
volatile MBFIDR19STR _MBFIDR19;                            /* Message Buffer Frame ID Registers; 0x0000059C */
volatile MBIDXR19STR _MBIDXR19;                            /* Message Buffer Index Registers; 0x0000059E */
volatile MBCCSR20STR _MBCCSR20;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005A0 */
volatile MBCCFR20STR _MBCCFR20;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005A2 */
volatile MBFIDR20STR _MBFIDR20;                            /* Message Buffer Frame ID Registers; 0x000005A4 */
volatile MBIDXR20STR _MBIDXR20;                            /* Message Buffer Index Registers; 0x000005A6 */
volatile MBCCSR21STR _MBCCSR21;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005A8 */
volatile MBCCFR21STR _MBCCFR21;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005AA */
volatile MBFIDR21STR _MBFIDR21;                            /* Message Buffer Frame ID Registers; 0x000005AC */
volatile MBIDXR21STR _MBIDXR21;                            /* Message Buffer Index Registers; 0x000005AE */
volatile MBCCSR22STR _MBCCSR22;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005B0 */
volatile MBCCFR22STR _MBCCFR22;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005B2 */
volatile MBFIDR22STR _MBFIDR22;                            /* Message Buffer Frame ID Registers; 0x000005B4 */
volatile MBIDXR22STR _MBIDXR22;                            /* Message Buffer Index Registers; 0x000005B6 */
volatile MBCCSR23STR _MBCCSR23;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005B8 */
volatile MBCCFR23STR _MBCCFR23;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005BA */
volatile MBFIDR23STR _MBFIDR23;                            /* Message Buffer Frame ID Registers; 0x000005BC */
volatile MBIDXR23STR _MBIDXR23;                            /* Message Buffer Index Registers; 0x000005BE */
volatile MBCCSR24STR _MBCCSR24;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005C0 */
volatile MBCCFR24STR _MBCCFR24;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005C2 */
volatile MBFIDR24STR _MBFIDR24;                            /* Message Buffer Frame ID Registers; 0x000005C4 */
volatile MBIDXR24STR _MBIDXR24;                            /* Message Buffer Index Registers; 0x000005C6 */
volatile MBCCSR25STR _MBCCSR25;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005C8 */
volatile MBCCFR25STR _MBCCFR25;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005CA */
volatile MBFIDR25STR _MBFIDR25;                            /* Message Buffer Frame ID Registers; 0x000005CC */
volatile MBIDXR25STR _MBIDXR25;                            /* Message Buffer Index Registers; 0x000005CE */
volatile MBCCSR26STR _MBCCSR26;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005D0 */
volatile MBCCFR26STR _MBCCFR26;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005D2 */
volatile MBFIDR26STR _MBFIDR26;                            /* Message Buffer Frame ID Registers; 0x000005D4 */
volatile MBIDXR26STR _MBIDXR26;                            /* Message Buffer Index Registers; 0x000005D6 */
volatile MBCCSR27STR _MBCCSR27;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005D8 */
volatile MBCCFR27STR _MBCCFR27;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005DA */
volatile MBFIDR27STR _MBFIDR27;                            /* Message Buffer Frame ID Registers; 0x000005DC */
volatile MBIDXR27STR _MBIDXR27;                            /* Message Buffer Index Registers; 0x000005DE */
volatile MBCCSR28STR _MBCCSR28;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005E0 */
volatile MBCCFR28STR _MBCCFR28;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005E2 */
volatile MBFIDR28STR _MBFIDR28;                            /* Message Buffer Frame ID Registers; 0x000005E4 */
volatile MBIDXR28STR _MBIDXR28;                            /* Message Buffer Index Registers; 0x000005E6 */
volatile MBCCSR29STR _MBCCSR29;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005E8 */
volatile MBCCFR29STR _MBCCFR29;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005EA */
volatile MBFIDR29STR _MBFIDR29;                            /* Message Buffer Frame ID Registers; 0x000005EC */
volatile MBIDXR29STR _MBIDXR29;                            /* Message Buffer Index Registers; 0x000005EE */
volatile MBCCSR30STR _MBCCSR30;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005F0 */
volatile MBCCFR30STR _MBCCFR30;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005F2 */
volatile MBFIDR30STR _MBFIDR30;                            /* Message Buffer Frame ID Registers; 0x000005F4 */
volatile MBIDXR30STR _MBIDXR30;                            /* Message Buffer Index Registers; 0x000005F6 */
volatile MBCCSR31STR _MBCCSR31;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005F8 */
volatile MBCCFR31STR _MBCCFR31;                            /* Message Buffer Configuration, Control, Status Registers; 0x000005FA */
volatile MBFIDR31STR _MBFIDR31;                            /* Message Buffer Frame ID Registers; 0x000005FC */
volatile MBIDXR31STR _MBIDXR31;                            /* Message Buffer Index Registers; 0x000005FE */
/* BAKEY0 - macro for reading non volatile register        Backdoor Comparison Key 0; 0x0000FF00 */
/* BAKEY1 - macro for reading non volatile register        Backdoor Comparison Key 1; 0x0000FF02 */
/* BAKEY2 - macro for reading non volatile register        Backdoor Comparison Key 2; 0x0000FF04 */
/* BAKEY3 - macro for reading non volatile register        Backdoor Comparison Key 3; 0x0000FF06 */


/* * * * *  32-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile SYMBADRSTR _SYMBADR;                              /* System Memory Base Address Register; 0x00000404 */

/*lint -restore */

/* EOF */
