/* Based on CPU DB MC9S12H256_144, version 2.87.411 (RegistersPrg V2.28) */
/* DataSheet : 9S12H256BDGV1/D V01.16 */

#include <mc9s12h256.h>

/*lint -save -esym(765, *) */


/* * * * *  8-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile PORTESTR _PORTE;                                  /* Port E Register; 0x00000008 */
volatile DDRESTR _DDRE;                                    /* Port E Data Direction Register; 0x00000009 */
volatile PEARSTR _PEAR;                                    /* Port E Assignment Register; 0x0000000A */
volatile MODESTR _MODE;                                    /* Mode Register; 0x0000000B */
volatile PUCRSTR _PUCR;                                    /* Pull-Up Control Register; 0x0000000C */
volatile RDRIVSTR _RDRIV;                                  /* Reduced Drive of I/O Lines; 0x0000000D */
volatile EBICTLSTR _EBICTL;                                /* External Bus Interface Control; 0x0000000E */
volatile INITRMSTR _INITRM;                                /* Initialization of Internal RAM Position Register; 0x00000010 */
volatile INITRGSTR _INITRG;                                /* Initialization of Internal Registers Position Register; 0x00000011 */
volatile INITEESTR _INITEE;                                /* Initialization of Internal EEPROM Position Register; 0x00000012 */
volatile MISCSTR _MISC;                                    /* Miscellaneous System Control Register; 0x00000013 */
volatile ITCRSTR _ITCR;                                    /* Interrupt Test Control Register; 0x00000015 */
volatile ITESTSTR _ITEST;                                  /* Interrupt Test Register; 0x00000016 */
volatile MEMSIZ0STR _MEMSIZ0;                              /* Memory Size Register Zero; 0x0000001C */
volatile MEMSIZ1STR _MEMSIZ1;                              /* Memory Size Register One; 0x0000001D */
volatile INTCRSTR _INTCR;                                  /* Interrupt Control Register; 0x0000001E */
volatile HPRIOSTR _HPRIO;                                  /* Highest Priority I Interrupt; 0x0000001F */
volatile BKPCT0STR _BKPCT0;                                /* Breakpoint Control Register 0; 0x00000028 */
volatile BKPCT1STR _BKPCT1;                                /* Breakpoint Control Register 1; 0x00000029 */
volatile BKP0XSTR _BKP0X;                                  /* First Address Memory Expansion Breakpoint Register; 0x0000002A */
volatile BKP0HSTR _BKP0H;                                  /* First Address High Byte Breakpoint Register; 0x0000002B */
volatile BKP0LSTR _BKP0L;                                  /* First Address Low Byte Breakpoint Register; 0x0000002C */
volatile BKP1XSTR _BKP1X;                                  /* Second Address Memory Expansion Breakpoint Register; 0x0000002D */
volatile BKP1HSTR _BKP1H;                                  /* Data (Second Address) High Byte Breakpoint Register; 0x0000002E */
volatile BKP1LSTR _BKP1L;                                  /* Data (Second Address) Low Byte Breakpoint Register; 0x0000002F */
volatile PPAGESTR _PPAGE;                                  /* Page Index Register; 0x00000030 */
volatile PORTKSTR _PORTK;                                  /* Port K Data Register; 0x00000032 */
volatile DDRKSTR _DDRK;                                    /* Port K Data Direction Register; 0x00000033 */
volatile SYNRSTR _SYNR;                                    /* CRG Synthesizer Register; 0x00000034 */
volatile REFDVSTR _REFDV;                                  /* CRG Reference Divider Register; 0x00000035 */
volatile CRGFLGSTR _CRGFLG;                                /* CRG Flags Register; 0x00000037 */
volatile CRGINTSTR _CRGINT;                                /* CRG Interrupt Enable Register; 0x00000038 */
volatile CLKSELSTR _CLKSEL;                                /* CRG Clock Select Register; 0x00000039 */
volatile PLLCTLSTR _PLLCTL;                                /* CRG PLL Control Register; 0x0000003A */
volatile RTICTLSTR _RTICTL;                                /* CRG RTI Control Register; 0x0000003B */
volatile COPCTLSTR _COPCTL;                                /* CRG COP Control Register; 0x0000003C */
volatile ARMCOPSTR _ARMCOP;                                /* CRG COP Timer Arm/Reset Register; 0x0000003F */
volatile TIOSSTR _TIOS;                                    /* Timer Input Capture/Output Compare Select; 0x00000040 */
volatile CFORCSTR _CFORC;                                  /* Timer Compare Force Register; 0x00000041 */
volatile OC7MSTR _OC7M;                                    /* Output Compare 7 Mask Register; 0x00000042 */
volatile OC7DSTR _OC7D;                                    /* Output Compare 7 Data Register; 0x00000043 */
volatile TSCR1STR _TSCR1;                                  /* Timer System Control Register1; 0x00000046 */
volatile TTOVSTR _TTOV;                                    /* Timer Toggle On Overflow Register; 0x00000047 */
volatile TCTL1STR _TCTL1;                                  /* Timer Control Register 1; 0x00000048 */
volatile TCTL2STR _TCTL2;                                  /* Timer Control Register 2; 0x00000049 */
volatile TCTL3STR _TCTL3;                                  /* Timer Control Register 3; 0x0000004A */
volatile TCTL4STR _TCTL4;                                  /* Timer Control Register 4; 0x0000004B */
volatile TIESTR _TIE;                                      /* Timer Interrupt Enable Register; 0x0000004C */
volatile TSCR2STR _TSCR2;                                  /* Timer System Control Register 2; 0x0000004D */
volatile TFLG1STR _TFLG1;                                  /* Main Timer Interrupt Flag 1; 0x0000004E */
volatile TFLG2STR _TFLG2;                                  /* Main Timer Interrupt Flag 2; 0x0000004F */
volatile PACTLSTR _PACTL;                                  /* 16-Bit Pulse Accumulator A Control Register; 0x00000060 */
volatile PAFLGSTR _PAFLG;                                  /* Pulse Accumulator A Flag Register; 0x00000061 */
volatile ATDSTAT0STR _ATDSTAT0;                            /* ATD Status Register 0; 0x00000086 */
volatile ATDTEST1STR _ATDTEST1;                            /* ATD Test Register; 0x00000089 */
volatile ATDSTAT2STR _ATDSTAT2;                            /* ATD Status Register 2; 0x0000008A */
volatile ATDSTAT1STR _ATDSTAT1;                            /* ATD Status Register 1; 0x0000008B */
volatile IBADSTR _IBAD;                                    /* IIC Address Register; 0x000000C0 */
volatile IBFDSTR _IBFD;                                    /* IIC Frequency Divider Register; 0x000000C1 */
volatile IBCRSTR _IBCR;                                    /* IIC Control Register; 0x000000C2 */
volatile IBSRSTR _IBSR;                                    /* IIC Status Register; 0x000000C3 */
volatile IBDRSTR _IBDR;                                    /* IIC Data I/O Register; 0x000000C4 */
volatile SCI0CR1STR _SCI0CR1;                              /* SCI 0 Control Register 1; 0x000000CA */
volatile SCI0CR2STR _SCI0CR2;                              /* SCI 0 Control Register 2; 0x000000CB */
volatile SCI0SR1STR _SCI0SR1;                              /* SCI 0 Status Register 1; 0x000000CC */
volatile SCI0SR2STR _SCI0SR2;                              /* SCI 0 Status Register 2; 0x000000CD */
volatile SCI0DRHSTR _SCI0DRH;                              /* SCI 0 Data Register High; 0x000000CE */
volatile SCI0DRLSTR _SCI0DRL;                              /* SCI 0 Data Register Low; 0x000000CF */
volatile SCI1CR1STR _SCI1CR1;                              /* SCI 1 Control Register 1; 0x000000D2 */
volatile SCI1CR2STR _SCI1CR2;                              /* SCI 1 Control Register 2; 0x000000D3 */
volatile SCI1SR1STR _SCI1SR1;                              /* SCI 1 Status Register 1; 0x000000D4 */
volatile SCI1SR2STR _SCI1SR2;                              /* SCI 1 Status Register 2; 0x000000D5 */
volatile SCI1DRHSTR _SCI1DRH;                              /* SCI 1 Data Register High; 0x000000D6 */
volatile SCI1DRLSTR _SCI1DRL;                              /* SCI 1 Data Register Low; 0x000000D7 */
volatile SPICR1STR _SPICR1;                                /* SPI 0 Control Register; 0x000000D8 */
volatile SPICR2STR _SPICR2;                                /* SPI 0 Control Register 2; 0x000000D9 */
volatile SPIBRSTR _SPIBR;                                  /* SPI 0 Baud Rate Register; 0x000000DA */
volatile SPISRSTR _SPISR;                                  /* SPI 0 Status Register; 0x000000DB */
volatile SPIDRSTR _SPIDR;                                  /* SPI 0 Data Register; 0x000000DD */
volatile PWMESTR _PWME;                                    /* PWM Enable Register; 0x000000E0 */
volatile PWMPOLSTR _PWMPOL;                                /* PWM Polarity Register; 0x000000E1 */
volatile PWMCLKSTR _PWMCLK;                                /* PWM Clock Select Register; 0x000000E2 */
volatile PWMPRCLKSTR _PWMPRCLK;                            /* PWM Prescale Clock Select Register; 0x000000E3 */
volatile PWMCAESTR _PWMCAE;                                /* PWM Center Align Enable Register; 0x000000E4 */
volatile PWMCTLSTR _PWMCTL;                                /* PWM Control Register; 0x000000E5 */
volatile PWMSCLASTR _PWMSCLA;                              /* PWM Scale A Register; 0x000000E8 */
volatile PWMSCLBSTR _PWMSCLB;                              /* PWM Scale B Register; 0x000000E9 */
volatile PWMSDNSTR _PWMSDN;                                /* PWM Shutdown Register; 0x000000FE */
volatile FCLKDIVSTR _FCLKDIV;                              /* Flash Clock Divider Register; 0x00000100 */
volatile FSECSTR _FSEC;                                    /* Flash Security Register; 0x00000101 */
volatile FCNFGSTR _FCNFG;                                  /* Flash Configuration Register; 0x00000103 */
volatile FPROTSTR _FPROT;                                  /* Flash Protection Register; 0x00000104 */
volatile FSTATSTR _FSTAT;                                  /* Flash Status Register; 0x00000105 */
volatile FCMDSTR _FCMD;                                    /* Flash Command Buffer and Register; 0x00000106 */
volatile ECLKDIVSTR _ECLKDIV;                              /* EEPROM Clock Divider Register; 0x00000110 */
volatile ECNFGSTR _ECNFG;                                  /* EEPROM Configuration Register; 0x00000113 */
volatile EPROTSTR _EPROT;                                  /* EEPROM Protection Register; 0x00000114 */
volatile ESTATSTR _ESTAT;                                  /* EEPROM Status Register; 0x00000115 */
volatile ECMDSTR _ECMD;                                    /* EEPROM Command Buffer and Register; 0x00000116 */
volatile LCDCR0STR _LCDCR0;                                /* LCD Control Register 0; 0x00000120 */
volatile LCDCR1STR _LCDCR1;                                /* LCD Control Register 1; 0x00000121 */
volatile FPENR0STR _FPENR0;                                /* LCD Frontplane Enable Register 0; 0x00000122 */
volatile FPENR1STR _FPENR1;                                /* LCD Frontplane Enable Register 1; 0x00000123 */
volatile FPENR2STR _FPENR2;                                /* LCD Frontplane Enable Register 2; 0x00000124 */
volatile FPENR3STR _FPENR3;                                /* LCD Frontplane Enable Register 3; 0x00000125 */
volatile LCDRAM0STR _LCDRAM0;                              /* LCD RAM Register 0; 0x00000128 */
volatile LCDRAM1STR _LCDRAM1;                              /* LCD RAM Register 1; 0x00000129 */
volatile LCDRAM2STR _LCDRAM2;                              /* LCD RAM Register 2; 0x0000012A */
volatile LCDRAM3STR _LCDRAM3;                              /* LCD RAM Register 3; 0x0000012B */
volatile LCDRAM4STR _LCDRAM4;                              /* LCD RAM Register 4; 0x0000012C */
volatile LCDRAM5STR _LCDRAM5;                              /* LCD RAM Register 5; 0x0000012D */
volatile LCDRAM6STR _LCDRAM6;                              /* LCD RAM Register 6; 0x0000012E */
volatile LCDRAM7STR _LCDRAM7;                              /* LCD RAM Register 7; 0x0000012F */
volatile LCDRAM8STR _LCDRAM8;                              /* LCD RAM Register 8; 0x00000130 */
volatile LCDRAM9STR _LCDRAM9;                              /* LCD RAM Register 9; 0x00000131 */
volatile LCDRAM10STR _LCDRAM10;                            /* LCD RAM Register 10; 0x00000132 */
volatile LCDRAM11STR _LCDRAM11;                            /* LCD RAM Register 11; 0x00000133 */
volatile LCDRAM12STR _LCDRAM12;                            /* LCD RAM Register 12; 0x00000134 */
volatile LCDRAM13STR _LCDRAM13;                            /* LCD RAM Register 13; 0x00000135 */
volatile LCDRAM14STR _LCDRAM14;                            /* LCD RAM Register 14; 0x00000136 */
volatile LCDRAM15STR _LCDRAM15;                            /* LCD RAM Register 15; 0x00000137 */
volatile CAN0CTL0STR _CAN0CTL0;                            /* MSCAN 0 Control 0 Register; 0x00000140 */
volatile CAN0CTL1STR _CAN0CTL1;                            /* MSCAN 0 Control 1 Register; 0x00000141 */
volatile CAN0BTR0STR _CAN0BTR0;                            /* MSCAN 0 Bus Timing Register 0; 0x00000142 */
volatile CAN0BTR1STR _CAN0BTR1;                            /* MSCAN 0 Bus Timing Register 1; 0x00000143 */
volatile CAN0RFLGSTR _CAN0RFLG;                            /* MSCAN 0 Receiver Flag Register; 0x00000144 */
volatile CAN0RIERSTR _CAN0RIER;                            /* MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 */
volatile CAN0TFLGSTR _CAN0TFLG;                            /* MSCAN 0 Transmitter Flag Register; 0x00000146 */
volatile CAN0TIERSTR _CAN0TIER;                            /* MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 */
volatile CAN0TARQSTR _CAN0TARQ;                            /* MSCAN 0 Transmitter Message Abort Request; 0x00000148 */
volatile CAN0TAAKSTR _CAN0TAAK;                            /* MSCAN 0 Transmitter Message Abort Control; 0x00000149 */
volatile CAN0TBSELSTR _CAN0TBSEL;                          /* MSCAN 0 Transmit Buffer Selection; 0x0000014A */
volatile CAN0IDACSTR _CAN0IDAC;                            /* MSCAN 0 Identifier Acceptance Control Register; 0x0000014B */
volatile CAN0RXERRSTR _CAN0RXERR;                          /* MSCAN 0 Receive Error Counter Register; 0x0000014E */
volatile CAN0TXERRSTR _CAN0TXERR;                          /* MSCAN 0 Transmit Error Counter Register; 0x0000014F */
volatile CAN0IDAR0STR _CAN0IDAR0;                          /* MSCAN 0 Identifier Acceptance Register 0; 0x00000150 */
volatile CAN0IDAR1STR _CAN0IDAR1;                          /* MSCAN 0 Identifier Acceptance Register 1; 0x00000151 */
volatile CAN0IDAR2STR _CAN0IDAR2;                          /* MSCAN 0 Identifier Acceptance Register 2; 0x00000152 */
volatile CAN0IDAR3STR _CAN0IDAR3;                          /* MSCAN 0 Identifier Acceptance Register 3; 0x00000153 */
volatile CAN0IDMR0STR _CAN0IDMR0;                          /* MSCAN 0 Identifier Mask Register 0; 0x00000154 */
volatile CAN0IDMR1STR _CAN0IDMR1;                          /* MSCAN 0 Identifier Mask Register 1; 0x00000155 */
volatile CAN0IDMR2STR _CAN0IDMR2;                          /* MSCAN 0 Identifier Mask Register 2; 0x00000156 */
volatile CAN0IDMR3STR _CAN0IDMR3;                          /* MSCAN 0 Identifier Mask Register 3; 0x00000157 */
volatile CAN0IDAR4STR _CAN0IDAR4;                          /* MSCAN 0 Identifier Acceptance Register 4; 0x00000158 */
volatile CAN0IDAR5STR _CAN0IDAR5;                          /* MSCAN 0 Identifier Acceptance Register 5; 0x00000159 */
volatile CAN0IDAR6STR _CAN0IDAR6;                          /* MSCAN 0 Identifier Acceptance Register 6; 0x0000015A */
volatile CAN0IDAR7STR _CAN0IDAR7;                          /* MSCAN 0 Identifier Acceptance Register 7; 0x0000015B */
volatile CAN0IDMR4STR _CAN0IDMR4;                          /* MSCAN 0 Identifier Mask Register 4; 0x0000015C */
volatile CAN0IDMR5STR _CAN0IDMR5;                          /* MSCAN 0 Identifier Mask Register 5; 0x0000015D */
volatile CAN0IDMR6STR _CAN0IDMR6;                          /* MSCAN 0 Identifier Mask Register 6; 0x0000015E */
volatile CAN0IDMR7STR _CAN0IDMR7;                          /* MSCAN 0 Identifier Mask Register 7; 0x0000015F */
volatile CAN0RXIDR0STR _CAN0RXIDR0;                        /* MSCAN 0 Receive Identifier Register 0; 0x00000160 */
volatile CAN0RXIDR1STR _CAN0RXIDR1;                        /* MSCAN 0 Receive Identifier Register 1; 0x00000161 */
volatile CAN0RXIDR2STR _CAN0RXIDR2;                        /* MSCAN 0 Receive Identifier Register 2; 0x00000162 */
volatile CAN0RXIDR3STR _CAN0RXIDR3;                        /* MSCAN 0 Receive Identifier Register 3; 0x00000163 */
volatile CAN0RXDSR0STR _CAN0RXDSR0;                        /* MSCAN 0 Receive Data Segment Register 0; 0x00000164 */
volatile CAN0RXDSR1STR _CAN0RXDSR1;                        /* MSCAN 0 Receive Data Segment Register 1; 0x00000165 */
volatile CAN0RXDSR2STR _CAN0RXDSR2;                        /* MSCAN 0 Receive Data Segment Register 2; 0x00000166 */
volatile CAN0RXDSR3STR _CAN0RXDSR3;                        /* MSCAN 0 Receive Data Segment Register 3; 0x00000167 */
volatile CAN0RXDSR4STR _CAN0RXDSR4;                        /* MSCAN 0 Receive Data Segment Register 4; 0x00000168 */
volatile CAN0RXDSR5STR _CAN0RXDSR5;                        /* MSCAN 0 Receive Data Segment Register 5; 0x00000169 */
volatile CAN0RXDSR6STR _CAN0RXDSR6;                        /* MSCAN 0 Receive Data Segment Register 6; 0x0000016A */
volatile CAN0RXDSR7STR _CAN0RXDSR7;                        /* MSCAN 0 Receive Data Segment Register 7; 0x0000016B */
volatile CAN0RXDLRSTR _CAN0RXDLR;                          /* MSCAN 0 Receive Data Length Register; 0x0000016C */
volatile CAN0TXIDR0STR _CAN0TXIDR0;                        /* MSCAN 0 Transmit Identifier Register 0; 0x00000170 */
volatile CAN0TXIDR1STR _CAN0TXIDR1;                        /* MSCAN 0 Transmit Identifier Register 1; 0x00000171 */
volatile CAN0TXIDR2STR _CAN0TXIDR2;                        /* MSCAN 0 Transmit Identifier Register 2; 0x00000172 */
volatile CAN0TXIDR3STR _CAN0TXIDR3;                        /* MSCAN 0 Transmit Identifier Register 3; 0x00000173 */
volatile CAN0TXDSR0STR _CAN0TXDSR0;                        /* MSCAN 0 Transmit Data Segment Register 0; 0x00000174 */
volatile CAN0TXDSR1STR _CAN0TXDSR1;                        /* MSCAN 0 Transmit Data Segment Register 1; 0x00000175 */
volatile CAN0TXDSR2STR _CAN0TXDSR2;                        /* MSCAN 0 Transmit Data Segment Register 2; 0x00000176 */
volatile CAN0TXDSR3STR _CAN0TXDSR3;                        /* MSCAN 0 Transmit Data Segment Register 3; 0x00000177 */
volatile CAN0TXDSR4STR _CAN0TXDSR4;                        /* MSCAN 0 Transmit Data Segment Register 4; 0x00000178 */
volatile CAN0TXDSR5STR _CAN0TXDSR5;                        /* MSCAN 0 Transmit Data Segment Register 5; 0x00000179 */
volatile CAN0TXDSR6STR _CAN0TXDSR6;                        /* MSCAN 0 Transmit Data Segment Register 6; 0x0000017A */
volatile CAN0TXDSR7STR _CAN0TXDSR7;                        /* MSCAN 0 Transmit Data Segment Register 7; 0x0000017B */
volatile CAN0TXDLRSTR _CAN0TXDLR;                          /* MSCAN 0 Transmit Data Length Register; 0x0000017C */
volatile CAN0TXTBPRSTR _CAN0TXTBPR;                        /* MSCAN 0 Transmit Buffer Priority; 0x0000017D */
volatile CAN1CTL0STR _CAN1CTL0;                            /* MSCAN 1 Control 0 Register; 0x00000180 */
volatile CAN1CTL1STR _CAN1CTL1;                            /* MSCAN 1 Control 1 Register; 0x00000181 */
volatile CAN1BTR0STR _CAN1BTR0;                            /* MSCAN 1 Bus Timing Register 0; 0x00000182 */
volatile CAN1BTR1STR _CAN1BTR1;                            /* MSCAN 1 Bus Timing Register 1; 0x00000183 */
volatile CAN1RFLGSTR _CAN1RFLG;                            /* MSCAN 1 Receiver Flag Register; 0x00000184 */
volatile CAN1RIERSTR _CAN1RIER;                            /* MSCAN 1 Receiver Interrupt Enable Register; 0x00000185 */
volatile CAN1TFLGSTR _CAN1TFLG;                            /* MSCAN 1 Transmitter Flag Register; 0x00000186 */
volatile CAN1TIERSTR _CAN1TIER;                            /* MSCAN 1 Transmitter Interrupt Enable Register; 0x00000187 */
volatile CAN1TARQSTR _CAN1TARQ;                            /* MSCAN 1 Transmitter Message Abort Request; 0x00000188 */
volatile CAN1TAAKSTR _CAN1TAAK;                            /* MSCAN 1 Transmitter Message Abort Control; 0x00000189 */
volatile CAN1TBSELSTR _CAN1TBSEL;                          /* MSCAN 1 Transmit Buffer Selection; 0x0000018A */
volatile CAN1IDACSTR _CAN1IDAC;                            /* MSCAN 1 Identifier Acceptance Control Register; 0x0000018B */
volatile CAN1RXERRSTR _CAN1RXERR;                          /* MSCAN 1 Receive Error Counter Register; 0x0000018E */
volatile CAN1TXERRSTR _CAN1TXERR;                          /* MSCAN 1 Transmit Error Counter Register; 0x0000018F */
volatile CAN1IDAR0STR _CAN1IDAR0;                          /* MSCAN 1 Identifier Acceptance Register 0; 0x00000190 */
volatile CAN1IDAR1STR _CAN1IDAR1;                          /* MSCAN 1 Identifier Acceptance Register 1; 0x00000191 */
volatile CAN1IDAR2STR _CAN1IDAR2;                          /* MSCAN 1 Identifier Acceptance Register 2; 0x00000192 */
volatile CAN1IDAR3STR _CAN1IDAR3;                          /* MSCAN 1 Identifier Acceptance Register 3; 0x00000193 */
volatile CAN1IDMR0STR _CAN1IDMR0;                          /* MSCAN 1 Identifier Mask Register 0; 0x00000194 */
volatile CAN1IDMR1STR _CAN1IDMR1;                          /* MSCAN 1 Identifier Mask Register 1; 0x00000195 */
volatile CAN1IDMR2STR _CAN1IDMR2;                          /* MSCAN 1 Identifier Mask Register 2; 0x00000196 */
volatile CAN1IDMR3STR _CAN1IDMR3;                          /* MSCAN 1 Identifier Mask Register 3; 0x00000197 */
volatile CAN1IDAR4STR _CAN1IDAR4;                          /* MSCAN 1 Identifier Acceptance Register 4; 0x00000198 */
volatile CAN1IDAR5STR _CAN1IDAR5;                          /* MSCAN 1 Identifier Acceptance Register 5; 0x00000199 */
volatile CAN1IDAR6STR _CAN1IDAR6;                          /* MSCAN 1 Identifier Acceptance Register 6; 0x0000019A */
volatile CAN1IDAR7STR _CAN1IDAR7;                          /* MSCAN 1 Identifier Acceptance Register 7; 0x0000019B */
volatile CAN1IDMR4STR _CAN1IDMR4;                          /* MSCAN 1 Identifier Mask Register 4; 0x0000019C */
volatile CAN1IDMR5STR _CAN1IDMR5;                          /* MSCAN 1 Identifier Mask Register 5; 0x0000019D */
volatile CAN1IDMR6STR _CAN1IDMR6;                          /* MSCAN 1 Identifier Mask Register 6; 0x0000019E */
volatile CAN1IDMR7STR _CAN1IDMR7;                          /* MSCAN 1 Identifier Mask Register 7; 0x0000019F */
volatile CAN1RXIDR0STR _CAN1RXIDR0;                        /* MSCAN 1 Receive Identifier Register 0; 0x000001A0 */
volatile CAN1RXIDR1STR _CAN1RXIDR1;                        /* MSCAN 1 Receive Identifier Register 1; 0x000001A1 */
volatile CAN1RXIDR2STR _CAN1RXIDR2;                        /* MSCAN 1 Receive Identifier Register 2; 0x000001A2 */
volatile CAN1RXIDR3STR _CAN1RXIDR3;                        /* MSCAN 1 Receive Identifier Register 3; 0x000001A3 */
volatile CAN1RXDSR0STR _CAN1RXDSR0;                        /* MSCAN 1 Receive Data Segment Register 0; 0x000001A4 */
volatile CAN1RXDSR1STR _CAN1RXDSR1;                        /* MSCAN 1 Receive Data Segment Register 1; 0x000001A5 */
volatile CAN1RXDSR2STR _CAN1RXDSR2;                        /* MSCAN 1 Receive Data Segment Register 2; 0x000001A6 */
volatile CAN1RXDSR3STR _CAN1RXDSR3;                        /* MSCAN 1 Receive Data Segment Register 3; 0x000001A7 */
volatile CAN1RXDSR4STR _CAN1RXDSR4;                        /* MSCAN 1 Receive Data Segment Register 4; 0x000001A8 */
volatile CAN1RXDSR5STR _CAN1RXDSR5;                        /* MSCAN 1 Receive Data Segment Register 5; 0x000001A9 */
volatile CAN1RXDSR6STR _CAN1RXDSR6;                        /* MSCAN 1 Receive Data Segment Register 6; 0x000001AA */
volatile CAN1RXDSR7STR _CAN1RXDSR7;                        /* MSCAN 1 Receive Data Segment Register 7; 0x000001AB */
volatile CAN1RXDLRSTR _CAN1RXDLR;                          /* MSCAN 1 Receive Data Length Register; 0x000001AC */
volatile CAN1TXIDR0STR _CAN1TXIDR0;                        /* MSCAN 1 Transmit Identifier Register 0; 0x000001B0 */
volatile CAN1TXIDR1STR _CAN1TXIDR1;                        /* MSCAN 1 Transmit Identifier Register 1; 0x000001B1 */
volatile CAN1TXIDR2STR _CAN1TXIDR2;                        /* MSCAN 1 Transmit Identifier Register 2; 0x000001B2 */
volatile CAN1TXIDR3STR _CAN1TXIDR3;                        /* MSCAN 1 Transmit Identifier Register 3; 0x000001B3 */
volatile CAN1TXDSR0STR _CAN1TXDSR0;                        /* MSCAN 1 Transmit Data Segment Register 0; 0x000001B4 */
volatile CAN1TXDSR1STR _CAN1TXDSR1;                        /* MSCAN 1 Transmit Data Segment Register 1; 0x000001B5 */
volatile CAN1TXDSR2STR _CAN1TXDSR2;                        /* MSCAN 1 Transmit Data Segment Register 2; 0x000001B6 */
volatile CAN1TXDSR3STR _CAN1TXDSR3;                        /* MSCAN 1 Transmit Data Segment Register 3; 0x000001B7 */
volatile CAN1TXDSR4STR _CAN1TXDSR4;                        /* MSCAN 1 Transmit Data Segment Register 4; 0x000001B8 */
volatile CAN1TXDSR5STR _CAN1TXDSR5;                        /* MSCAN 1 Transmit Data Segment Register 5; 0x000001B9 */
volatile CAN1TXDSR6STR _CAN1TXDSR6;                        /* MSCAN 1 Transmit Data Segment Register 6; 0x000001BA */
volatile CAN1TXDSR7STR _CAN1TXDSR7;                        /* MSCAN 1 Transmit Data Segment Register 7; 0x000001BB */
volatile CAN1TXDLRSTR _CAN1TXDLR;                          /* MSCAN 1 Transmit Data Length Register; 0x000001BC */
volatile CAN1TXTBPRSTR _CAN1TXTBPR;                        /* MSCAN 1 Transmit Buffer Priority; 0x000001BD */
volatile MCCTL0STR _MCCTL0;                                /* Motor Controller Control Register 0; 0x000001C0 */
volatile MCCTL1STR _MCCTL1;                                /* Motor Controller Control Register 1; 0x000001C1 */
volatile MCCC0STR _MCCC0;                                  /* Motor Controller Control Register Channel 0; 0x000001D0 */
volatile MCCC1STR _MCCC1;                                  /* Motor Controller Control Register Channel 1; 0x000001D1 */
volatile MCCC2STR _MCCC2;                                  /* Motor Controller Control Register Channel 2; 0x000001D2 */
volatile MCCC3STR _MCCC3;                                  /* Motor Controller Control Register Channel 3; 0x000001D3 */
volatile MCCC4STR _MCCC4;                                  /* Motor Controller Control Register Channel 4; 0x000001D4 */
volatile MCCC5STR _MCCC5;                                  /* Motor Controller Control Register Channel 5; 0x000001D5 */
volatile MCCC6STR _MCCC6;                                  /* Motor Controller Control Register Channel 6; 0x000001D6 */
volatile MCCC7STR _MCCC7;                                  /* Motor Controller Control Register Channel 7; 0x000001D7 */
volatile MCCC8STR _MCCC8;                                  /* Motor Controller Control Register Channel 8; 0x000001D8 */
volatile MCCC9STR _MCCC9;                                  /* Motor Controller Control Register Channel 9; 0x000001D9 */
volatile MCCC10STR _MCCC10;                                /* Motor Controller Control Register Channel 10; 0x000001DA */
volatile MCCC11STR _MCCC11;                                /* Motor Controller Control Register Channel 11; 0x000001DB */
volatile PTTSTR _PTT;                                      /* Port T I/O Register; 0x00000200 */
volatile PTITSTR _PTIT;                                    /* Port T Input Register; 0x00000201 */
volatile DDRTSTR _DDRT;                                    /* Port T Data Direction Register; 0x00000202 */
volatile RDRTSTR _RDRT;                                    /* Port T Reduced Drive Register; 0x00000203 */
volatile PERTSTR _PERT;                                    /* Port T Pull Device Enable Register; 0x00000204 */
volatile PPSTSTR _PPST;                                    /* Port T Polarity Select Register; 0x00000205 */
volatile PTSSTR _PTS;                                      /* Port S I/O Register; 0x00000208 */
volatile PTISSTR _PTIS;                                    /* Port S Input Register; 0x00000209 */
volatile DDRSSTR _DDRS;                                    /* Port S Data Direction Register; 0x0000020A */
volatile RDRSSTR _RDRS;                                    /* Port S Reduced Drive Register; 0x0000020B */
volatile PERSSTR _PERS;                                    /* Port S Pull Device Enable Register; 0x0000020C */
volatile PPSSSTR _PPSS;                                    /* Port S Polarity Select Register; 0x0000020D */
volatile WOMSSTR _WOMS;                                    /* Port S Wired-Or Mode Register; 0x0000020E */
volatile PTMSTR _PTM;                                      /* Port M I/O Register; 0x00000210 */
volatile PTIMSTR _PTIM;                                    /* Port M Input Register; 0x00000211 */
volatile DDRMSTR _DDRM;                                    /* Port M Data Direction Register; 0x00000212 */
volatile RDRMSTR _RDRM;                                    /* Port M Reduced Drive Register; 0x00000213 */
volatile PERMSTR _PERM;                                    /* Port M Pull Device Enable Register; 0x00000214 */
volatile PPSMSTR _PPSM;                                    /* Port M Polarity Select Register; 0x00000215 */
volatile WOMMSTR _WOMM;                                    /* Port M Wired-Or Mode Register; 0x00000216 */
volatile PTPSTR _PTP;                                      /* Port P I/O Register; 0x00000218 */
volatile PTIPSTR _PTIP;                                    /* Port P Input Register; 0x00000219 */
volatile DDRPSTR _DDRP;                                    /* Port P Data Direction Register; 0x0000021A */
volatile RDRPSTR _RDRP;                                    /* Port P Reduced Drive Register; 0x0000021B */
volatile PERPSTR _PERP;                                    /* Port P Pull Device Enable Register; 0x0000021C */
volatile PPSPSTR _PPSP;                                    /* Port P Polarity Select Register; 0x0000021D */
volatile PTHSTR _PTH;                                      /* Port H I/O Register; 0x00000220 */
volatile PTIHSTR _PTIH;                                    /* Port H Input Register; 0x00000221 */
volatile DDRHSTR _DDRH;                                    /* Port H Data Direction Register; 0x00000222 */
volatile RDRHSTR _RDRH;                                    /* Port H Reduced Drive Register; 0x00000223 */
volatile PERHSTR _PERH;                                    /* Port H Pull Device Enable Register; 0x00000224 */
volatile PPSHSTR _PPSH;                                    /* Port H Polarity Select Register; 0x00000225 */
volatile PIEHSTR _PIEH;                                    /* Port H Interrupt Enable Register; 0x00000226 */
volatile PIFHSTR _PIFH;                                    /* Port H Interrupt Flag Register; 0x00000227 */
volatile PTJSTR _PTJ;                                      /* Port J I/O Register; 0x00000228 */
volatile PTIJSTR _PTIJ;                                    /* Port J Input Register; 0x00000229 */
volatile DDRJSTR _DDRJ;                                    /* Port J Data Direction Register; 0x0000022A */
volatile RDRJSTR _RDRJ;                                    /* Port J Reduced Drive Register; 0x0000022B */
volatile PERJSTR _PERJ;                                    /* Port J Pull Device Enable Register; 0x0000022C */
volatile PPSJSTR _PPSJ;                                    /* Port J Polarity Select Register; 0x0000022D */
volatile PIEJSTR _PIEJ;                                    /* Port J Interrupt Enable Register; 0x0000022E */
volatile PIFJSTR _PIFJ;                                    /* Port J Interrupt Flag Register; 0x0000022F */
volatile PTLSTR _PTL;                                      /* Port L I/O Register; 0x00000230 */
volatile PTILSTR _PTIL;                                    /* Port L Input Register; 0x00000231 */
volatile DDRLSTR _DDRL;                                    /* Port L Data Direction Register; 0x00000232 */
volatile RDRLSTR _RDRL;                                    /* Port L Reduced Drive Register; 0x00000233 */
volatile PERLSTR _PERL;                                    /* Port L Pull Device Enable Register; 0x00000234 */
volatile PPSLSTR _PPSL;                                    /* Port L Polarity Select Register; 0x00000235 */
volatile PTUSTR _PTU;                                      /* Port U I/O Register; 0x00000238 */
volatile PTIUSTR _PTIU;                                    /* Port U Input Register; 0x00000239 */
volatile DDRUSTR _DDRU;                                    /* Port U Data Direction Register; 0x0000023A */
volatile SRRUSTR _SRRU;                                    /* Port U Slew Rate Register; 0x0000023B */
volatile PERUSTR _PERU;                                    /* Port U Pull Device Enable Register; 0x0000023C */
volatile PPSUSTR _PPSU;                                    /* Port U Polarity Select Register; 0x0000023D */
volatile PTVSTR _PTV;                                      /* Port V I/O Register; 0x00000240 */
volatile PTIVSTR _PTIV;                                    /* Port V Input Register; 0x00000241 */
volatile DDRVSTR _DDRV;                                    /* Port V Data Direction Register; 0x00000242 */
volatile SRRVSTR _SRRV;                                    /* Port V Reduced Drive Register; 0x00000243 */
volatile PERVSTR _PERV;                                    /* Port V Pull Device Enable Register; 0x00000244 */
volatile PPSVSTR _PPSV;                                    /* Port V Polarity Select Register; 0x00000245 */
volatile PTWSTR _PTW;                                      /* Port W I/O Register; 0x00000248 */
volatile PTIWSTR _PTIW;                                    /* Port W Input Register; 0x00000249 */
volatile DDRWSTR _DDRW;                                    /* Port W Data Direction Register; 0x0000024A */
volatile SRRWSTR _SRRW;                                    /* Port W Reduced Drive Register; 0x0000024B */
volatile PERWSTR _PERW;                                    /* Port W Pull Device Enable Register; 0x0000024C */
volatile PPSWSTR _PPSW;                                    /* Port W Polarity Select Register; 0x0000024D */
/* NVFPROT3 - macro for reading non volatile register      Non volatile Block 3 Flash Protection Register; 0x0000FF0A */
/* NVFPROT2 - macro for reading non volatile register      Non volatile Block 2 Flash Protection Register; 0x0000FF0B */
/* NVFPROT1 - macro for reading non volatile register      Non volatile Block 1 Flash Protection Register; 0x0000FF0C */
/* NVFPROT0 - macro for reading non volatile register      Non volatile Block 0 Flash Protection Register; 0x0000FF0D */
/* NVFSEC - macro for reading non volatile register        Non volatile Flash Security Register; 0x0000FF0F */


/* * * * *  16-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile PORTABSTR _PORTAB;                                /* Port AB Register; 0x00000000 */
volatile DDRABSTR _DDRAB;                                  /* Port AB Data Direction Register; 0x00000002 */
volatile PARTIDSTR _PARTID;                                /* Part ID Register; 0x0000001A */
volatile TCNTSTR _TCNT;                                    /* Timer Count Register; 0x00000044 */
volatile TC0STR _TC0;                                      /* Timer Input Capture/Output Compare Register 0; 0x00000050 */
volatile TC1STR _TC1;                                      /* Timer Input Capture/Output Compare Register 1; 0x00000052 */
volatile TC2STR _TC2;                                      /* Timer Input Capture/Output Compare Register 2; 0x00000054 */
volatile TC3STR _TC3;                                      /* Timer Input Capture/Output Compare Register 3; 0x00000056 */
volatile TC4STR _TC4;                                      /* Timer Input Capture/Output Compare Register 4; 0x00000058 */
volatile TC5STR _TC5;                                      /* Timer Input Capture/Output Compare Register 5; 0x0000005A */
volatile TC6STR _TC6;                                      /* Timer Input Capture/Output Compare Register 6; 0x0000005C */
volatile TC7STR _TC7;                                      /* Timer Input Capture/Output Compare Register 7; 0x0000005E */
volatile PACNTSTR _PACNT;                                  /* Pulse Accumulators Count Register; 0x00000062 */
volatile ATDCTL23STR _ATDCTL23;                            /* ATD Control Register 23; 0x00000082 */
volatile ATDCTL45STR _ATDCTL45;                            /* ATD Control Register; 0x00000084 */
volatile ATDDIENSTR _ATDDIEN;                              /* ATD Input Enable Register; 0x0000008C */
volatile PORTADSTR _PORTAD;                                /* Port AD0 Data; 0x0000008E */
volatile ATDDR0STR _ATDDR0;                                /* ATD Conversion Result Register 0; 0x00000090 */
volatile ATDDR1STR _ATDDR1;                                /* ATD Conversion Result Register 1; 0x00000092 */
volatile ATDDR2STR _ATDDR2;                                /* ATD Conversion Result Register 2; 0x00000094 */
volatile ATDDR3STR _ATDDR3;                                /* ATD Conversion Result Register 3; 0x00000096 */
volatile ATDDR4STR _ATDDR4;                                /* ATD Conversion Result Register 4; 0x00000098 */
volatile ATDDR5STR _ATDDR5;                                /* ATD Conversion Result Register 5; 0x0000009A */
volatile ATDDR6STR _ATDDR6;                                /* ATD Conversion Result Register 6; 0x0000009C */
volatile ATDDR7STR _ATDDR7;                                /* ATD Conversion Result Register 7; 0x0000009E */
volatile ATDDR8STR _ATDDR8;                                /* ATD Conversion Result Register 8; 0x000000A0 */
volatile ATDDR9STR _ATDDR9;                                /* ATD Conversion Result Register 9; 0x000000A2 */
volatile ATDDR10STR _ATDDR10;                              /* ATD Conversion Result Register 10; 0x000000A4 */
volatile ATDDR11STR _ATDDR11;                              /* ATD Conversion Result Register 11; 0x000000A6 */
volatile ATDDR12STR _ATDDR12;                              /* ATD Conversion Result Register 12; 0x000000A8 */
volatile ATDDR13STR _ATDDR13;                              /* ATD Conversion Result Register 13; 0x000000AA */
volatile ATDDR14STR _ATDDR14;                              /* ATD Conversion Result Register 14; 0x000000AC */
volatile ATDDR15STR _ATDDR15;                              /* ATD Conversion Result Register 15; 0x000000AE */
volatile SCI0BDSTR _SCI0BD;                                /* SCI 0 Baud Rate Register; 0x000000C8 */
volatile SCI1BDSTR _SCI1BD;                                /* SCI 1 Baud Rate Register; 0x000000D0 */
volatile PWMCNT01STR _PWMCNT01;                            /* PWM Channel Counter 01 Register; 0x000000EC */
volatile PWMCNT23STR _PWMCNT23;                            /* PWM Channel Counter 23 Register; 0x000000EE */
volatile PWMCNT45STR _PWMCNT45;                            /* PWM Channel Counter 45 Register; 0x000000F0 */
volatile PWMPER01STR _PWMPER01;                            /* PWM Channel Period 01 Register; 0x000000F2 */
volatile PWMPER23STR _PWMPER23;                            /* PWM Channel Period 23 Register; 0x000000F4 */
volatile PWMPER45STR _PWMPER45;                            /* PWM Channel Period 45 Register; 0x000000F6 */
volatile PWMDTY01STR _PWMDTY01;                            /* PWM Channel Duty 01 Register; 0x000000F8 */
volatile PWMDTY23STR _PWMDTY23;                            /* PWM Channel Duty 23 Register; 0x000000FA */
volatile PWMDTY45STR _PWMDTY45;                            /* PWM Channel Duty 45 Register; 0x000000FC */
volatile CAN0RXTSRSTR _CAN0RXTSR;                          /* MSCAN 0 Receive Time Stamp Register; 0x0000016E */
volatile CAN0TXTSRSTR _CAN0TXTSR;                          /* MSCAN 0 Transmit Time Stamp Register; 0x0000017E */
volatile CAN1RXTSRSTR _CAN1RXTSR;                          /* MSCAN 1 Receive Time Stamp Register; 0x000001AE */
volatile CAN1TXTSRSTR _CAN1TXTSR;                          /* MSCAN 1 Transmit Time Stamp Register; 0x000001BE */
volatile MCPERSTR _MCPER;                                  /* Motor Controller Period Register, with DITH = 0; 0x000001C2 */
volatile MCDC0STR _MCDC0;                                  /* Motor Controller Duty Cycle Register 0; 0x000001E0 */
volatile MCDC1STR _MCDC1;                                  /* Motor Controller Duty Cycle Register 1; 0x000001E2 */
volatile MCDC2STR _MCDC2;                                  /* Motor Controller Duty Cycle Register 2; 0x000001E4 */
volatile MCDC3STR _MCDC3;                                  /* Motor Controller Duty Cycle Register 3; 0x000001E6 */
volatile MCDC4STR _MCDC4;                                  /* Motor Controller Duty Cycle Register 4; 0x000001E8 */
volatile MCDC5STR _MCDC5;                                  /* Motor Controller Duty Cycle Register 5; 0x000001EA */
volatile MCDC6STR _MCDC6;                                  /* Motor Controller Duty Cycle Register 6; 0x000001EC */
volatile MCDC7STR _MCDC7;                                  /* Motor Controller Duty Cycle Register 7; 0x000001EE */
volatile MCDC8STR _MCDC8;                                  /* Motor Controller Duty Cycle Register 8; 0x000001F0 */
volatile MCDC9STR _MCDC9;                                  /* Motor Controller Duty Cycle Register 9; 0x000001F2 */
volatile MCDC10STR _MCDC10;                                /* Motor Controller Duty Cycle Register 10; 0x000001F4 */
volatile MCDC11STR _MCDC11;                                /* Motor Controller Duty Cycle Register 11; 0x000001F6 */
/* BAKEY0 - macro for reading non volatile register        Backdoor Access Key 0; 0x0000FF00 */
/* BAKEY1 - macro for reading non volatile register        Backdoor Access Key 1; 0x0000FF02 */
/* BAKEY2 - macro for reading non volatile register        Backdoor Access Key 2; 0x0000FF04 */
/* BAKEY3 - macro for reading non volatile register        Backdoor Access Key 3; 0x0000FF06 */

/*lint -restore */

/* EOF */
