; Based on CPU DB MM912J637_48, version 3.00.000 (RegistersPrg V2.33)

; ###################################################################
;     Filename  : mm912j637.inc
;     Processor : MM912J637
;     FileFormat: V2.33
;     DataSheet : MM912_637D1 Rev. 2.0, 8/2011
;     Compiler  : CodeWarrior compiler
;     Date/Time : 9.2.2012, 16:01
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 30.1.2012, V3.00.0:
;              - Registers updated according to the new reference manual revision - MM912_637D1 Rev. 2.0, 8/2011
;              - MMC: Removed register MMCCTL1.
;              - PCR: Removed D2DSMM, D2DSM bits from CTL register.
;              - LIN: Added Transmitter Ready Status(RDY) into SR register.
;              - GPIO: Corrected address of GPIO_IN1,GPIO_OUT1.
;              - WDOG: Added WDTST bit into CTL register.
;
;     File-Format-Revisions:
;      - 15.09.2010, V2.33 :
;               - Empty union is not generated for data overlapping registers, cause there is no bit access
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00002800
RAMEnd:             equ   $00003FFF
DFLASHStart:        equ   $00000400
DFLASHEnd:          equ   $000013FF
ROM_1400Start:      equ   $00001400
ROM_1400End:        equ   $000027FF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_08Start:       equ   $00020000
PAGE_08End:         equ   $00023FFF
PAGE_09Start:       equ   $00024000
PAGE_09End:         equ   $00027FFF
PAGE_0AStart:       equ   $00028000
PAGE_0AEnd:         equ   $0002BFFF
PAGE_0BStart:       equ   $0002C000
PAGE_0BEnd:         equ   $0002FFFF
PAGE_0CStart:       equ   $00030000
PAGE_0CEnd:         equ   $000313FF
PAGE_0C_A800Start:  equ   $00032800
PAGE_0C_A800End:    equ   $00033FFF
PAGE_0EStart:       equ   $00038000
PAGE_0EEnd:         equ   $0003BFFF
;
Vsi:                equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
Vlvi:               equ   $0000FF8A
VReserved57:        equ   $0000FF8C
VReserved56:        equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
VReserved52:        equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
VReserved47:        equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
VReserved43:        equ   $0000FFA8
VReserved42:        equ   $0000FFAA
VReserved41:        equ   $0000FFAC
VReserved40:        equ   $0000FFAE
VReserved39:        equ   $0000FFB0
VReserved38:        equ   $0000FFB2
VReserved37:        equ   $0000FFB4
VReserved36:        equ   $0000FFB6
Vflash:             equ   $0000FFB8
Vflashfd:           equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
VReserved31:        equ   $0000FFC0
VReserved30:        equ   $0000FFC2
VReserved29:        equ   $0000FFC4
Vcpmuplllck:        equ   $0000FFC6
Vcpmuocsns:         equ   $0000FFC8
VReserved26:        equ   $0000FFCA
VReserved25:        equ   $0000FFCC
VReserved24:        equ   $0000FFCE
VReserved23:        equ   $0000FFD0
VReserved22:        equ   $0000FFD2
VReserved21:        equ   $0000FFD4
VReserved20:        equ   $0000FFD6
Vspi:               equ   $0000FFD8
VReserved18:        equ   $0000FFDA
VReserved17:        equ   $0000FFDC
VReserved16:        equ   $0000FFDE
VReserved15:        equ   $0000FFE0
VReserved14:        equ   $0000FFE2
VReserved13:        equ   $0000FFE4
VReserved12:        equ   $0000FFE6
VReserved11:        equ   $0000FFE8
VReserved10:        equ   $0000FFEA
VReserved9:         equ   $0000FFEC
VReserved8:         equ   $0000FFEE
Vrti:               equ   $0000FFF0
Vd2di_ext:          equ   $0000FFF2
Vd2di_err:          equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTA - Port A Data Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_PA0:          equ    0                                         ; Port A Bit 0
PORTA_PA1:          equ    1                                         ; Port A Bit 1
PORTA_PA2:          equ    2                                         ; Port A Bit 2
PORTA_PA3:          equ    3                                         ; Port A Bit 3
PORTA_PA4:          equ    4                                         ; Port A Bit 4
PORTA_PA5:          equ    5                                         ; Port A Bit 5
PORTA_PA6:          equ    6                                         ; Port A Bit 6
PORTA_PA7:          equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_PA0:         equ    %00000001
mPORTA_PA1:         equ    %00000010
mPORTA_PA2:         equ    %00000100
mPORTA_PA3:         equ    %00001000
mPORTA_PA4:         equ    %00010000
mPORTA_PA5:         equ    %00100000
mPORTA_PA6:         equ    %01000000
mPORTA_PA7:         equ    %10000000


;*** PTE - Port E Data Register; 0x00000001 ***
PTE:                equ    $00000001                                ;*** PTE - Port E Data Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTE_PE0:            equ    0                                         ; Port E Bit 0
PTE_PE1:            equ    1                                         ; Port E Bit 1
; bit position masks
mPTE_PE0:           equ    %00000001
mPTE_PE1:           equ    %00000010


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Port A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Port A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Port A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Port A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Port A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Port A Bit 5
DDRA_DDRA6:         equ    6                                         ; Data Direction Port A Bit 6
DDRA_DDRA7:         equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000
mDDRA_DDRA6:        equ    %01000000
mDDRA_DDRA7:        equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000003 ***
DDRE:               equ    $00000003                                ;*** DDRE - Port E Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_DDRE0:         equ    0                                         ; Data Direction Port E Bit 0
DDRE_DDRE1:         equ    1                                         ; Data Direction Port E Bit 1
; bit position masks
mDDRE_DDRE0:        equ    %00000001
mDDRE_DDRE1:        equ    %00000010


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODC:          equ    7                                         ; Mode Select Bit
; bit position masks
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PDPEE:         equ    1                                         ; Pull-down Port E Enable
PUCR_BKPUE:         equ    6                                         ; BKGD and VREGEN Pin Pull-up Enable
; bit position masks
mPUCR_PDPEE:        equ    %00000010
mPUCR_BKPUE:        equ    %01000000


;*** RDRIV - Reduced Drive Register; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPC:         equ    2                                         ; Reduced Drive of Port C
RDRIV_RDPD:         equ    3                                         ; Reduced Drive of Port D
; bit position masks
mRDRIV_RDPC:        equ    %00000100
mRDRIV_RDPD:        equ    %00001000


;*** DIRECT - Direct Page Register; 0x00000011 ***
DIRECT:             equ    $00000011                                ;*** DIRECT - Direct Page Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Index Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Index Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Index Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Index Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Index Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Index Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Index Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Index Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** PPAGE - Program Page Index Register; 0x00000015 ***
PPAGE:              equ    $00000015                                ;*** PPAGE - Program Page Index Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** IVBR - Interrupt Vector Base Register; 0x0000001F ***
IVBR:               equ    $0000001F                                ;*** IVBR - Interrupt Vector Base Register; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR0:     equ    0                                         ; Interrupt Vector Base Address Bits, bit 0
IVBR_IVB_ADDR1:     equ    1                                         ; Interrupt Vector Base Address Bits, bit 1
IVBR_IVB_ADDR2:     equ    2                                         ; Interrupt Vector Base Address Bits, bit 2
IVBR_IVB_ADDR3:     equ    3                                         ; Interrupt Vector Base Address Bits, bit 3
IVBR_IVB_ADDR4:     equ    4                                         ; Interrupt Vector Base Address Bits, bit 4
IVBR_IVB_ADDR5:     equ    5                                         ; Interrupt Vector Base Address Bits, bit 5
IVBR_IVB_ADDR6:     equ    6                                         ; Interrupt Vector Base Address Bits, bit 6
IVBR_IVB_ADDR7:     equ    7                                         ; Interrupt Vector Base Address Bits, bit 7
; bit position masks
mIVBR_IVB_ADDR0:    equ    %00000001
mIVBR_IVB_ADDR1:    equ    %00000010
mIVBR_IVB_ADDR2:    equ    %00000100
mIVBR_IVB_ADDR3:    equ    %00001000
mIVBR_IVB_ADDR4:    equ    %00010000
mIVBR_IVB_ADDR5:    equ    %00100000
mIVBR_IVB_ADDR6:    equ    %01000000
mIVBR_IVB_ADDR7:    equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV0:       equ    0                                         ; Comparator Register Visibility Bits, bit 0
DBGC1_COMRV1:       equ    1                                         ; Comparator Register Visibility Bits, bit 1
DBGC1_DBGBRK:       equ    3                                         ; S12XDBG Breakpoint Enable Bit 1
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV0:      equ    %00000001
mDBGC1_COMRV1:      equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BDM:         equ    %00010000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bits
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bit
DBGTCR_TRCMOD0:     equ    2                                         ; Trace Mode Bits, bit 0
DBGTCR_TRCMOD1:     equ    3                                         ; Trace Mode Bits, bit 1
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bits
; bit position masks
mDBGTCR_TALIGN:     equ    %00000001
mDBGTCR_TRCMOD0:    equ    %00000100
mDBGTCR_TRCMOD1:    equ    %00001000
mDBGTCR_TSOURCE:    equ    %01000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM0:        equ    0                                         ; A and B Comparator Match Control, bit 0
DBGC2_ABCM1:        equ    1                                         ; A and B Comparator Match Control, bit 1
; bit position masks
mDBGC2_ABCM0:       equ    %00000001
mDBGC2_ABCM1:       equ    %00000010


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bits
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bits
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bits
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; State X Sequencer Next State Selection Bit 0
DBGSCRX_SC1:        equ    1                                         ; State X Sequencer Next State Selection Bit 1
DBGSCRX_SC2:        equ    2                                         ; State X Sequencer Next State Selection Bit 2
DBGSCRX_SC3:        equ    3                                         ; State X Sequencer Next State Selection Bit 3
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100
mDBGSCRX_SC3:       equ    %00001000


;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; Debug Match Flag Bit 0
DBGMFR_MC1:         equ    1                                         ; Debug Match Flag Bit 1
DBGMFR_MC2:         equ    2                                         ; Debug Match Flag Bit 2
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_NDB:        equ    1                                         ; Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D)
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_BRK:        equ    4                                         ; Break
DBGXCTL_TAG:        equ    5                                         ; Tag Select
DBGXCTL_SZ:         equ    6                                         ; Size Comparator Value Bit
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_NDB:       equ    %00000010
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_BRK:       equ    %00010000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_SZ:        equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bits
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bits
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bits
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
DBGADH:             equ    $0000002C                                ;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADH_BIT8:        equ    0                                         ; Comparator Data High Compare Bit 8
DBGADH_BIT9:        equ    1                                         ; Comparator Data High Compare Bit 9
DBGADH_BIT10:       equ    2                                         ; Comparator Data High Compare Bit 10
DBGADH_BIT11:       equ    3                                         ; Comparator Data High Compare Bit 11
DBGADH_BIT12:       equ    4                                         ; Comparator Data High Compare Bit 12
DBGADH_BIT13:       equ    5                                         ; Comparator Data High Compare Bit 13
DBGADH_BIT14:       equ    6                                         ; Comparator Data High Compare Bit 14
DBGADH_BIT15:       equ    7                                         ; Comparator Data High Compare Bit 15
; bit position masks
mDBGADH_BIT8:       equ    %00000001
mDBGADH_BIT9:       equ    %00000010
mDBGADH_BIT10:      equ    %00000100
mDBGADH_BIT11:      equ    %00001000
mDBGADH_BIT12:      equ    %00010000
mDBGADH_BIT13:      equ    %00100000
mDBGADH_BIT14:      equ    %01000000
mDBGADH_BIT15:      equ    %10000000


;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
DBGADL:             equ    $0000002D                                ;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADL_BIT0:        equ    0                                         ; Comparator Data Low Compare Bit 0
DBGADL_BIT1:        equ    1                                         ; Comparator Data Low Compare Bit 1
DBGADL_BIT2:        equ    2                                         ; Comparator Data Low Compare Bit 2
DBGADL_BIT3:        equ    3                                         ; Comparator Data Low Compare Bit 3
DBGADL_BIT4:        equ    4                                         ; Comparator Data Low Compare Bit 4
DBGADL_BIT5:        equ    5                                         ; Comparator Data Low Compare Bit 5
DBGADL_BIT6:        equ    6                                         ; Comparator Data Low Compare Bit 6
DBGADL_BIT7:        equ    7                                         ; Comparator Data Low Compare Bit 7
; bit position masks
mDBGADL_BIT0:       equ    %00000001
mDBGADL_BIT1:       equ    %00000010
mDBGADL_BIT2:       equ    %00000100
mDBGADL_BIT3:       equ    %00001000
mDBGADL_BIT4:       equ    %00010000
mDBGADL_BIT5:       equ    %00100000
mDBGADL_BIT6:       equ    %01000000
mDBGADL_BIT7:       equ    %10000000


;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGADHM:            equ    $0000002E                                ;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGADHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGADHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGADHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGADHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGADHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGADHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGADHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGADHM_BIT8:      equ    %00000001
mDBGADHM_BIT9:      equ    %00000010
mDBGADHM_BIT10:     equ    %00000100
mDBGADHM_BIT11:     equ    %00001000
mDBGADHM_BIT12:     equ    %00010000
mDBGADHM_BIT13:     equ    %00100000
mDBGADHM_BIT14:     equ    %01000000
mDBGADHM_BIT15:     equ    %10000000


;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGADLM:            equ    $0000002F                                ;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADLM_BIT0:       equ    0                                         ; Comparator Data Low Mask Bit 0
DBGADLM_BIT1:       equ    1                                         ; Comparator Data Low Mask Bit 1
DBGADLM_BIT2:       equ    2                                         ; Comparator Data Low Mask Bit 2
DBGADLM_BIT3:       equ    3                                         ; Comparator Data Low Mask Bit 3
DBGADLM_BIT4:       equ    4                                         ; Comparator Data Low Mask Bit 4
DBGADLM_BIT5:       equ    5                                         ; Comparator Data Low Mask Bit 5
DBGADLM_BIT6:       equ    6                                         ; Comparator Data Low Mask Bit 6
DBGADLM_BIT7:       equ    7                                         ; Comparator Data Low Mask Bit 7
; bit position masks
mDBGADLM_BIT0:      equ    %00000001
mDBGADLM_BIT1:      equ    %00000010
mDBGADLM_BIT2:      equ    %00000100
mDBGADLM_BIT3:      equ    %00001000
mDBGADLM_BIT4:      equ    %00010000
mDBGADLM_BIT5:      equ    %00100000
mDBGADLM_BIT6:      equ    %01000000
mDBGADLM_BIT7:      equ    %10000000


;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
CPMUSYNR:           equ    $00000034                                ;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUSYNR_SYNDIV0:   equ    0                                         ; Multiplication factor of the IPLL bit 0
CPMUSYNR_SYNDIV1:   equ    1                                         ; Multiplication factor of the IPLL bit 1
CPMUSYNR_SYNDIV2:   equ    2                                         ; Multiplication factor of the IPLL bit 2
CPMUSYNR_SYNDIV3:   equ    3                                         ; Multiplication factor of the IPLL bit 3
CPMUSYNR_SYNDIV4:   equ    4                                         ; Multiplication factor of the IPLL bit 4
CPMUSYNR_SYNDIV5:   equ    5                                         ; Multiplication factor of the IPLL bit 5
CPMUSYNR_VCOFRQ0:   equ    6                                         ; VCO frequency range bit 0
CPMUSYNR_VCOFRQ1:   equ    7                                         ; VCO frequency range bit 1
; bit position masks
mCPMUSYNR_SYNDIV0:  equ    %00000001
mCPMUSYNR_SYNDIV1:  equ    %00000010
mCPMUSYNR_SYNDIV2:  equ    %00000100
mCPMUSYNR_SYNDIV3:  equ    %00001000
mCPMUSYNR_SYNDIV4:  equ    %00010000
mCPMUSYNR_SYNDIV5:  equ    %00100000
mCPMUSYNR_VCOFRQ0:  equ    %01000000
mCPMUSYNR_VCOFRQ1:  equ    %10000000


;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
CPMUREFDIV:         equ    $00000035                                ;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUREFDIV_REFDIV0: equ    0                                         ; Finer granularity for the IPLL multiplier steps bit 0
CPMUREFDIV_REFDIV1: equ    1                                         ; Finer granularity for the IPLL multiplier steps bit 1
CPMUREFDIV_REFDIV2: equ    2                                         ; Finer granularity for the IPLL multiplier steps bit 2
CPMUREFDIV_REFDIV3: equ    3                                         ; Finer granularity for the IPLL multiplier steps bit 3
CPMUREFDIV_REFFRQ0: equ    6                                         ; IPLL optimal stability and lock time configuration bit 0
CPMUREFDIV_REFFRQ1: equ    7                                         ; IPLL optimal stability and lock time configuration bit 1
; bit position masks
mCPMUREFDIV_REFDIV0: equ    %00000001
mCPMUREFDIV_REFDIV1: equ    %00000010
mCPMUREFDIV_REFDIV2: equ    %00000100
mCPMUREFDIV_REFDIV3: equ    %00001000
mCPMUREFDIV_REFFRQ0: equ    %01000000
mCPMUREFDIV_REFFRQ1: equ    %10000000


;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
CPMUPOSTDIV:        equ    $00000036                                ;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPOSTDIV_POSTDIV0: equ    0                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 0
CPMUPOSTDIV_POSTDIV1: equ    1                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 1
CPMUPOSTDIV_POSTDIV2: equ    2                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 2
CPMUPOSTDIV_POSTDIV3: equ    3                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 3
CPMUPOSTDIV_POSTDIV4: equ    4                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 4
; bit position masks
mCPMUPOSTDIV_POSTDIV0: equ    %00000001
mCPMUPOSTDIV_POSTDIV1: equ    %00000010
mCPMUPOSTDIV_POSTDIV2: equ    %00000100
mCPMUPOSTDIV_POSTDIV3: equ    %00001000
mCPMUPOSTDIV_POSTDIV4: equ    %00010000


;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
CPMUFLG:            equ    $00000037                                ;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUFLG_UPOSC:      equ    0                                         ; Oscillator Status Bit
CPMUFLG_OSCIF:      equ    1                                         ; Oscillator Interrupt Flag
CPMUFLG_ILAF:       equ    2                                         ; Illegal Address Reset Flag
CPMUFLG_LOCK:       equ    3                                         ; Lock Status Bit
CPMUFLG_LOCKIF:     equ    4                                         ; IPLL Lock Interrupt Flag
CPMUFLG_LVRF:       equ    5                                         ; Low Voltage Reset Flag
CPMUFLG_PORF:       equ    6                                         ; Power on Reset Flag
CPMUFLG_RTIF:       equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCPMUFLG_UPOSC:     equ    %00000001
mCPMUFLG_OSCIF:     equ    %00000010
mCPMUFLG_ILAF:      equ    %00000100
mCPMUFLG_LOCK:      equ    %00001000
mCPMUFLG_LOCKIF:    equ    %00010000
mCPMUFLG_LVRF:      equ    %00100000
mCPMUFLG_PORF:      equ    %01000000
mCPMUFLG_RTIF:      equ    %10000000


;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
CPMUINT:            equ    $00000038                                ;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUINT_OSCIE:      equ    1                                         ; Oscillator Corrupt Interrupt Enable Bit
CPMUINT_LOCKIE:     equ    4                                         ; Lock Interrupt Enable Bit
CPMUINT_RTIE:       equ    7                                         ; Real Time Interrupt Enable Bit
; bit position masks
mCPMUINT_OSCIE:     equ    %00000010
mCPMUINT_LOCKIE:    equ    %00010000
mCPMUINT_RTIE:      equ    %10000000


;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
CPMUCLKS:           equ    $00000039                                ;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCLKS_COPOSCSEL: equ    0                                         ; COP Clock Select
CPMUCLKS_RTIOSCSEL: equ    1                                         ; RTI Clock Select
CPMUCLKS_PCE:       equ    2                                         ; COP Enable During Pseudo Stop Bit
CPMUCLKS_PRE:       equ    3                                         ; RTI Enable During Pseudo Stop Bit
CPMUCLKS_PSTP:      equ    6                                         ; Pseudo Stop Bit
CPMUCLKS_PLLSEL:    equ    7                                         ; PLL Select Bit
; bit position masks
mCPMUCLKS_COPOSCSEL: equ    %00000001
mCPMUCLKS_RTIOSCSEL: equ    %00000010
mCPMUCLKS_PCE:      equ    %00000100
mCPMUCLKS_PRE:      equ    %00001000
mCPMUCLKS_PSTP:     equ    %01000000
mCPMUCLKS_PLLSEL:   equ    %10000000


;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
CPMUPLL:            equ    $0000003A                                ;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPLL_FM0:        equ    4                                         ; PLL Frequency Modulation Enable Bit 0
CPMUPLL_FM1:        equ    5                                         ; PLL Frequency Modulation Enable Bit 1
; bit position masks
mCPMUPLL_FM0:       equ    %00010000
mCPMUPLL_FM1:       equ    %00100000


;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
CPMURTI:            equ    $0000003B                                ;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMURTI_RTR0:       equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
CPMURTI_RTR1:       equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
CPMURTI_RTR2:       equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
CPMURTI_RTR3:       equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
CPMURTI_RTR4:       equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
CPMURTI_RTR5:       equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
CPMURTI_RTR6:       equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
CPMURTI_RTDEC:      equ    7                                         ; Decimal or Binary Divider Select Bit
; bit position masks
mCPMURTI_RTR0:      equ    %00000001
mCPMURTI_RTR1:      equ    %00000010
mCPMURTI_RTR2:      equ    %00000100
mCPMURTI_RTR3:      equ    %00001000
mCPMURTI_RTR4:      equ    %00010000
mCPMURTI_RTR5:      equ    %00100000
mCPMURTI_RTR6:      equ    %01000000
mCPMURTI_RTDEC:     equ    %10000000


;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
CPMUCOP:            equ    $0000003C                                ;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCOP_CR0:        equ    0                                         ; COP Watchdog Timer Rate select Bit 0
CPMUCOP_CR1:        equ    1                                         ; COP Watchdog Timer Rate select Bit 1
CPMUCOP_CR2:        equ    2                                         ; COP Watchdog Timer Rate select Bit 2
CPMUCOP_WRTMASK:    equ    5                                         ; Write Mask for WCOP
CPMUCOP_RSBCK:      equ    6                                         ; COP and RTI stop in Active BDM mode Bit
CPMUCOP_WCOP:       equ    7                                         ; Window COP mode
; bit position masks
mCPMUCOP_CR0:       equ    %00000001
mCPMUCOP_CR1:       equ    %00000010
mCPMUCOP_CR2:       equ    %00000100
mCPMUCOP_WRTMASK:   equ    %00100000
mCPMUCOP_RSBCK:     equ    %01000000
mCPMUCOP_WCOP:      equ    %10000000


;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
CPMUARMCOP:         equ    $0000003F                                ;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUARMCOP_BIT0:    equ    0                                         ; CPMU COP Timer Arm/Reset Bit 0
CPMUARMCOP_BIT1:    equ    1                                         ; CPMU COP Timer Arm/Reset Bit 1
CPMUARMCOP_BIT2:    equ    2                                         ; CPMU COP Timer Arm/Reset Bit 2
CPMUARMCOP_BIT3:    equ    3                                         ; CPMU COP Timer Arm/Reset Bit 3
CPMUARMCOP_BIT4:    equ    4                                         ; CPMU COP Timer Arm/Reset Bit 4
CPMUARMCOP_BIT5:    equ    5                                         ; CPMU COP Timer Arm/Reset Bit 5
CPMUARMCOP_BIT6:    equ    6                                         ; CPMU COP Timer Arm/Reset Bit 6
CPMUARMCOP_BIT7:    equ    7                                         ; CPMU COP Timer Arm/Reset Bit 7
; bit position masks
mCPMUARMCOP_BIT0:   equ    %00000001
mCPMUARMCOP_BIT1:   equ    %00000010
mCPMUARMCOP_BIT2:   equ    %00000100
mCPMUARMCOP_BIT3:   equ    %00001000
mCPMUARMCOP_BIT4:   equ    %00010000
mCPMUARMCOP_BIT5:   equ    %00100000
mCPMUARMCOP_BIT6:   equ    %01000000
mCPMUARMCOP_BIT7:   equ    %10000000


;*** D2DCTL0 - D2D Control Register 0; 0x000000D8 ***
D2DCTL0:            equ    $000000D8                                ;*** D2DCTL0 - D2D Control Register 0; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DCTL0_D2DCLKDIV0: equ    0                                         ; InterfaceClockDivider, bit 0
D2DCTL0_D2DCLKDIV1: equ    1                                         ; InterfaceClockDivider, bit 1
D2DCTL0_D2DSWAI:    equ    5                                         ; D2D Stop In Wait
D2DCTL0_D2DCW:      equ    6                                         ; D2D Connection Width
D2DCTL0_D2DEN:      equ    7                                         ; D2D Enable
; bit position masks
mD2DCTL0_D2DCLKDIV0: equ    %00000001
mD2DCTL0_D2DCLKDIV1: equ    %00000010
mD2DCTL0_D2DSWAI:   equ    %00100000
mD2DCTL0_D2DCW:     equ    %01000000
mD2DCTL0_D2DEN:     equ    %10000000


;*** D2DCTL1 - D2D Control Register 1; 0x000000D9 ***
D2DCTL1:            equ    $000000D9                                ;*** D2DCTL1 - D2D Control Register 1; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DCTL1_TIMOUT0:    equ    0                                         ; Time-out Setting, bit 0
D2DCTL1_TIMOUT1:    equ    1                                         ; Time-out Setting, bit 1
D2DCTL1_TIMOUT2:    equ    2                                         ; Time-out Setting, bit 2
D2DCTL1_TIMOUT3:    equ    3                                         ; Time-out Setting, bit 3
D2DCTL1_D2DIE:      equ    7                                         ; D2D Interrupt Enable
; bit position masks
mD2DCTL1_TIMOUT0:   equ    %00000001
mD2DCTL1_TIMOUT1:   equ    %00000010
mD2DCTL1_TIMOUT2:   equ    %00000100
mD2DCTL1_TIMOUT3:   equ    %00001000
mD2DCTL1_D2DIE:     equ    %10000000


;*** D2DSTAT0 - D2D Status Register 0; 0x000000DA ***
D2DSTAT0:           equ    $000000DA                                ;*** D2DSTAT0 - D2D Status Register 0; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DSTAT0_PAR0:      equ    0                                         ; Parity Bit
D2DSTAT0_PAR1:      equ    1                                         ; Parity Bit
D2DSTAT0_PARF:      equ    2                                         ; Parity Error Flag
D2DSTAT0_TERRF:     equ    3                                         ; Transaction Error Flag
D2DSTAT0_TIMEF:     equ    4                                         ; TimeOutErrorFlag
D2DSTAT0_CNCLF:     equ    5                                         ; CNCLF
D2DSTAT0_ACKERF:    equ    6                                         ; Acknowledge Error Flag
D2DSTAT0_ERRIF:     equ    7                                         ; D2D error interrupt flag
; bit position masks
mD2DSTAT0_PAR0:     equ    %00000001
mD2DSTAT0_PAR1:     equ    %00000010
mD2DSTAT0_PARF:     equ    %00000100
mD2DSTAT0_TERRF:    equ    %00001000
mD2DSTAT0_TIMEF:    equ    %00010000
mD2DSTAT0_CNCLF:    equ    %00100000
mD2DSTAT0_ACKERF:   equ    %01000000
mD2DSTAT0_ERRIF:    equ    %10000000


;*** D2DSTAT1 - D2D Status Register 1; 0x000000DB ***
D2DSTAT1:           equ    $000000DB                                ;*** D2DSTAT1 - D2D Status Register 1; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DSTAT1_D2DBSY:    equ    6                                         ; D2D Initiator Busy
D2DSTAT1_D2DIF:     equ    7                                         ; D2D InterruptFlag
; bit position masks
mD2DSTAT1_D2DBSY:   equ    %01000000
mD2DSTAT1_D2DIF:    equ    %10000000


;*** D2DADR - D2D Address Buffer Register; 0x000000DC ***
D2DADR:             equ    $000000DC                                ;*** D2DADR - D2D Address Buffer Register; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADR_ADR0:        equ    0                                         ; Transaction Address, bit 0
D2DADR_ADR1:        equ    1                                         ; Transaction Address, bit 1
D2DADR_ADR2:        equ    2                                         ; Transaction Address, bit 2
D2DADR_ADR3:        equ    3                                         ; Transaction Address, bit 3
D2DADR_ADR4:        equ    4                                         ; Transaction Address, bit 4
D2DADR_ADR5:        equ    5                                         ; Transaction Address, bit 5
D2DADR_ADR6:        equ    6                                         ; Transaction Address, bit 6
D2DADR_ADR7:        equ    7                                         ; Transaction Address, bit 7
D2DADR_NBLK:        equ    12                                        ; Transaction Mode
D2DADR_SZ8:         equ    14                                        ; Transaction Size
D2DADR_RWB:         equ    15                                        ; Transaction Read-Write Direction
; bit position masks
mD2DADR_ADR0:       equ    %00000001
mD2DADR_ADR1:       equ    %00000010
mD2DADR_ADR2:       equ    %00000100
mD2DADR_ADR3:       equ    %00001000
mD2DADR_ADR4:       equ    %00010000
mD2DADR_ADR5:       equ    %00100000
mD2DADR_ADR6:       equ    %01000000
mD2DADR_ADR7:       equ    %10000000
mD2DADR_NBLK:       equ    %1000000000000
mD2DADR_SZ8:        equ    %100000000000000
mD2DADR_RWB:        equ    %1000000000000000


;*** D2DADRHI - D2D Address Buffer Register High; 0x000000DC ***
D2DADRHI:           equ    $000000DC                                ;*** D2DADRHI - D2D Address Buffer Register High; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADRHI_NBLK:      equ    4                                         ; Transaction Mode
D2DADRHI_SZ8:       equ    6                                         ; Transaction Size
D2DADRHI_RWB:       equ    7                                         ; Transaction Read-Write Direction
; bit position masks
mD2DADRHI_NBLK:     equ    %00010000
mD2DADRHI_SZ8:      equ    %01000000
mD2DADRHI_RWB:      equ    %10000000


;*** D2DADRLO - D2D Address Buffer Register Low; 0x000000DD ***
D2DADRLO:           equ    $000000DD                                ;*** D2DADRLO - D2D Address Buffer Register Low; 0x000000DD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADRLO_ADR0:      equ    0                                         ; Transaction Address, bit 0
D2DADRLO_ADR1:      equ    1                                         ; Transaction Address, bit 1
D2DADRLO_ADR2:      equ    2                                         ; Transaction Address, bit 2
D2DADRLO_ADR3:      equ    3                                         ; Transaction Address, bit 3
D2DADRLO_ADR4:      equ    4                                         ; Transaction Address, bit 4
D2DADRLO_ADR5:      equ    5                                         ; Transaction Address, bit 5
D2DADRLO_ADR6:      equ    6                                         ; Transaction Address, bit 6
D2DADRLO_ADR7:      equ    7                                         ; Transaction Address, bit 7
; bit position masks
mD2DADRLO_ADR0:     equ    %00000001
mD2DADRLO_ADR1:     equ    %00000010
mD2DADRLO_ADR2:     equ    %00000100
mD2DADRLO_ADR3:     equ    %00001000
mD2DADRLO_ADR4:     equ    %00010000
mD2DADRLO_ADR5:     equ    %00100000
mD2DADRLO_ADR6:     equ    %01000000
mD2DADRLO_ADR7:     equ    %10000000


;*** D2DDATA - D2D Data Buffer Register; 0x000000DE ***
D2DDATA:            equ    $000000DE                                ;*** D2DDATA - D2D Data Buffer Register; 0x000000DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATA_DATA0:      equ    0                                         ; Transaction Data, bit 0
D2DDATA_DATA1:      equ    1                                         ; Transaction Data, bit 1
D2DDATA_DATA2:      equ    2                                         ; Transaction Data, bit 2
D2DDATA_DATA3:      equ    3                                         ; Transaction Data, bit 3
D2DDATA_DATA4:      equ    4                                         ; Transaction Data, bit 4
D2DDATA_DATA5:      equ    5                                         ; Transaction Data, bit 5
D2DDATA_DATA6:      equ    6                                         ; Transaction Data, bit 6
D2DDATA_DATA7:      equ    7                                         ; Transaction Data, bit 7
D2DDATA_DATA8:      equ    8                                         ; Transaction Data, bit 8
D2DDATA_DATA9:      equ    9                                         ; Transaction Data, bit 9
D2DDATA_DATA10:     equ    10                                        ; Transaction Data, bit 10
D2DDATA_DATA11:     equ    11                                        ; Transaction Data, bit 11
D2DDATA_DATA12:     equ    12                                        ; Transaction Data, bit 12
D2DDATA_DATA13:     equ    13                                        ; Transaction Data, bit 13
D2DDATA_DATA14:     equ    14                                        ; Transaction Data, bit 14
D2DDATA_DATA15:     equ    15                                        ; Transaction Data, bit 15
; bit position masks
mD2DDATA_DATA0:     equ    %00000001
mD2DDATA_DATA1:     equ    %00000010
mD2DDATA_DATA2:     equ    %00000100
mD2DDATA_DATA3:     equ    %00001000
mD2DDATA_DATA4:     equ    %00010000
mD2DDATA_DATA5:     equ    %00100000
mD2DDATA_DATA6:     equ    %01000000
mD2DDATA_DATA7:     equ    %10000000
mD2DDATA_DATA8:     equ    %100000000
mD2DDATA_DATA9:     equ    %1000000000
mD2DDATA_DATA10:    equ    %10000000000
mD2DDATA_DATA11:    equ    %100000000000
mD2DDATA_DATA12:    equ    %1000000000000
mD2DDATA_DATA13:    equ    %10000000000000
mD2DDATA_DATA14:    equ    %100000000000000
mD2DDATA_DATA15:    equ    %1000000000000000


;*** D2DDATAHI - D2D Data Buffer Register High; 0x000000DE ***
D2DDATAHI:          equ    $000000DE                                ;*** D2DDATAHI - D2D Data Buffer Register High; 0x000000DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATAHI_DATA8:    equ    0                                         ; Transaction Data, bit 8
D2DDATAHI_DATA9:    equ    1                                         ; Transaction Data, bit 9
D2DDATAHI_DATA10:   equ    2                                         ; Transaction Data, bit 10
D2DDATAHI_DATA11:   equ    3                                         ; Transaction Data, bit 11
D2DDATAHI_DATA12:   equ    4                                         ; Transaction Data, bit 12
D2DDATAHI_DATA13:   equ    5                                         ; Transaction Data, bit 13
D2DDATAHI_DATA14:   equ    6                                         ; Transaction Data, bit 14
D2DDATAHI_DATA15:   equ    7                                         ; Transaction Data, bit 15
; bit position masks
mD2DDATAHI_DATA8:   equ    %00000001
mD2DDATAHI_DATA9:   equ    %00000010
mD2DDATAHI_DATA10:  equ    %00000100
mD2DDATAHI_DATA11:  equ    %00001000
mD2DDATAHI_DATA12:  equ    %00010000
mD2DDATAHI_DATA13:  equ    %00100000
mD2DDATAHI_DATA14:  equ    %01000000
mD2DDATAHI_DATA15:  equ    %10000000


;*** D2DDATALO - D2D Data Buffer Register Low; 0x000000DF ***
D2DDATALO:          equ    $000000DF                                ;*** D2DDATALO - D2D Data Buffer Register Low; 0x000000DF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATALO_DATA0:    equ    0                                         ; Transaction Data, bit 0
D2DDATALO_DATA1:    equ    1                                         ; Transaction Data, bit 1
D2DDATALO_DATA2:    equ    2                                         ; Transaction Data, bit 2
D2DDATALO_DATA3:    equ    3                                         ; Transaction Data, bit 3
D2DDATALO_DATA4:    equ    4                                         ; Transaction Data, bit 4
D2DDATALO_DATA5:    equ    5                                         ; Transaction Data, bit 5
D2DDATALO_DATA6:    equ    6                                         ; Transaction Data, bit 6
D2DDATALO_DATA7:    equ    7                                         ; Transaction Data, bit 7
; bit position masks
mD2DDATALO_DATA0:   equ    %00000001
mD2DDATALO_DATA1:   equ    %00000010
mD2DDATALO_DATA2:   equ    %00000100
mD2DDATALO_DATA3:   equ    %00001000
mD2DDATALO_DATA4:   equ    %00010000
mD2DDATALO_DATA5:   equ    %00100000
mD2DDATALO_DATA6:   equ    %01000000
mD2DDATALO_DATA7:   equ    %10000000


;*** SPICR1 - SPI  Control Register 1; 0x000000E8 ***
SPICR1:             equ    $000000E8                                ;*** SPICR1 - SPI  Control Register 1; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI  Control Register 2; 0x000000E9 ***
SPICR2:             equ    $000000E9                                ;*** SPICR2 - SPI  Control Register 2; 0x000000E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
SPICR2_XFRW:        equ    6                                         ; Transfer Width
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000
mSPICR2_XFRW:       equ    %01000000


;*** SPIBR - SPI  Baud Rate Register; 0x000000EA ***
SPIBR:              equ    $000000EA                                ;*** SPIBR - SPI  Baud Rate Register; 0x000000EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI  Status Register; 0x000000EB ***
SPISR:              equ    $000000EB                                ;*** SPISR - SPI  Status Register; 0x000000EB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI  Data Register; 0x000000EC ***
SPIDR:              equ    $000000EC                                ;*** SPIDR - SPI  Data Register; 0x000000EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDR_R0_T0:        equ    0                                         ; SPI  Data Bit 0
SPIDR_R1_T1:        equ    1                                         ; SPI  Data Bit 1
SPIDR_R2_T2:        equ    2                                         ; SPI  Data Bit 2
SPIDR_R3_T3:        equ    3                                         ; SPI  Data Bit 3
SPIDR_R4_T4:        equ    4                                         ; SPI  Data Bit 4
SPIDR_R5_T5:        equ    5                                         ; SPI  Data Bit 5
SPIDR_R6_T6:        equ    6                                         ; SPI  Data Bit 6
SPIDR_R7_T7:        equ    7                                         ; SPI  Data Bit 7
SPIDR_R8_T8:        equ    8                                         ; SPI  Data Bit 8
SPIDR_R9_T9:        equ    9                                         ; SPI  Data Bit 9
SPIDR_R10_T10:      equ    10                                        ; SPI  Data Bit 10
SPIDR_R11_T11:      equ    11                                        ; SPI  Data Bit 11
SPIDR_R12_T12:      equ    12                                        ; SPI  Data Bit 12
SPIDR_R13_T13:      equ    13                                        ; SPI  Data Bit 13
SPIDR_R14_T14:      equ    14                                        ; SPI  Data Bit 14
SPIDR_R15_T15:      equ    15                                        ; SPI  Data Bit 15
; bit position masks
mSPIDR_R0_T0:       equ    %00000001
mSPIDR_R1_T1:       equ    %00000010
mSPIDR_R2_T2:       equ    %00000100
mSPIDR_R3_T3:       equ    %00001000
mSPIDR_R4_T4:       equ    %00010000
mSPIDR_R5_T5:       equ    %00100000
mSPIDR_R6_T6:       equ    %01000000
mSPIDR_R7_T7:       equ    %10000000
mSPIDR_R8_T8:       equ    %100000000
mSPIDR_R9_T9:       equ    %1000000000
mSPIDR_R10_T10:     equ    %10000000000
mSPIDR_R11_T11:     equ    %100000000000
mSPIDR_R12_T12:     equ    %1000000000000
mSPIDR_R13_T13:     equ    %10000000000000
mSPIDR_R14_T14:     equ    %100000000000000
mSPIDR_R15_T15:     equ    %1000000000000000


;*** SPIDRH - SPI  Data Register High; 0x000000EC ***
SPIDRH:             equ    $000000EC                                ;*** SPIDRH - SPI  Data Register High; 0x000000EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDRH_R8_T8:       equ    0                                         ; SPI  Data Bit 8
SPIDRH_R9_T9:       equ    1                                         ; SPI  Data Bit 9
SPIDRH_R10_T10:     equ    2                                         ; SPI  Data Bit 10
SPIDRH_R11_T11:     equ    3                                         ; SPI  Data Bit 11
SPIDRH_R12_T12:     equ    4                                         ; SPI  Data Bit 12
SPIDRH_R13_T13:     equ    5                                         ; SPI  Data Bit 13
SPIDRH_R14_T14:     equ    6                                         ; SPI  Data Bit 14
SPIDRH_R15_T15:     equ    7                                         ; SPI  Data Bit 15
; bit position masks
mSPIDRH_R8_T8:      equ    %00000001
mSPIDRH_R9_T9:      equ    %00000010
mSPIDRH_R10_T10:    equ    %00000100
mSPIDRH_R11_T11:    equ    %00001000
mSPIDRH_R12_T12:    equ    %00010000
mSPIDRH_R13_T13:    equ    %00100000
mSPIDRH_R14_T14:    equ    %01000000
mSPIDRH_R15_T15:    equ    %10000000


;*** SPIDRL - SPI  Data Register Low; 0x000000ED ***
SPIDRL:             equ    $000000ED                                ;*** SPIDRL - SPI  Data Register Low; 0x000000ED ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDRL_R0_T0:       equ    0                                         ; SPI  Data Bit 0
SPIDRL_R1_T1:       equ    1                                         ; SPI  Data Bit 1
SPIDRL_R2_T2:       equ    2                                         ; SPI  Data Bit 2
SPIDRL_R3_T3:       equ    3                                         ; SPI  Data Bit 3
SPIDRL_R4_T4:       equ    4                                         ; SPI  Data Bit 4
SPIDRL_R5_T5:       equ    5                                         ; SPI  Data Bit 5
SPIDRL_R6_T6:       equ    6                                         ; SPI  Data Bit 6
SPIDRL_R7_T7:       equ    7                                         ; SPI  Data Bit 7
; bit position masks
mSPIDRL_R0_T0:      equ    %00000001
mSPIDRL_R1_T1:      equ    %00000010
mSPIDRL_R2_T2:      equ    %00000100
mSPIDRL_R3_T3:      equ    %00001000
mSPIDRL_R4_T4:      equ    %00010000
mSPIDRL_R5_T5:      equ    %00100000
mSPIDRL_R6_T6:      equ    %01000000
mSPIDRL_R7_T7:      equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Clock Divider Bit 5
FCLKDIV_FDIVLCK:    equ    6                                         ; Clock divider locked
FCLKDIV_FDIVLD:     equ    7                                         ; Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_FDIVLCK:   equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Flash Security Bit 0
FSEC_SEC1:          equ    1                                         ; Flash Security Bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Nonvolatile Bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Nonvolatile Bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Nonvolatile Bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Nonvolatile Bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
FCCOBIX:            equ    $00000102                                ;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBIX_CCOBIX0:    equ    0                                         ; Common Command Register Index Bit 0
FCCOBIX_CCOBIX1:    equ    1                                         ; Common Command Register Index Bit 1
FCCOBIX_CCOBIX2:    equ    2                                         ; Common Command Register Index Bit 2
; bit position masks
mFCCOBIX_CCOBIX0:   equ    %00000001
mFCCOBIX_CCOBIX1:   equ    %00000010
mFCCOBIX_CCOBIX2:   equ    %00000100


;*** FCNFG - Flash Configuration Register; 0x00000104 ***
FCNFG:              equ    $00000104                                ;*** FCNFG - Flash Configuration Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_FSFD:         equ    0                                         ; Force Single Bit Fault Detect
FCNFG_FDFD:         equ    1                                         ; Force Double Bit Fault Detect
FCNFG_IGNSF:        equ    4                                         ; Ignore Single Bit Fault
FCNFG_CCIE:         equ    7                                         ; Command Complete Interrupt Enable
; bit position masks
mFCNFG_FSFD:        equ    %00000001
mFCNFG_FDFD:        equ    %00000010
mFCNFG_IGNSF:       equ    %00010000
mFCNFG_CCIE:        equ    %10000000


;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
FERCNFG:            equ    $00000105                                ;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERCNFG_SFDIE:      equ    0                                         ; Single Bit Fault Detect Interrupt Enable
FERCNFG_DFDIE:      equ    1                                         ; Double Bit Fault Detect Interrupt Enable
; bit position masks
mFERCNFG_SFDIE:     equ    %00000001
mFERCNFG_DFDIE:     equ    %00000010


;*** FSTAT - Flash Status Register; 0x00000106 ***
FSTAT:              equ    $00000106                                ;*** FSTAT - Flash Status Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_MGSTAT0:      equ    0                                         ; Memory Controller Command Completion Status Flag 0
FSTAT_MGSTAT1:      equ    1                                         ; Memory Controller Command Completion Status Flag 1
FSTAT_MGBUSY:       equ    3                                         ; Memory Controller Busy Flag
FSTAT_FPVIOL:       equ    4                                         ; Flash Protection Violation Flag
FSTAT_ACCERR:       equ    5                                         ; Flash Access Error Flag
FSTAT_CCIF:         equ    7                                         ; Command Complete Interrupt Flag
; bit position masks
mFSTAT_MGSTAT0:     equ    %00000001
mFSTAT_MGSTAT1:     equ    %00000010
mFSTAT_MGBUSY:      equ    %00001000
mFSTAT_FPVIOL:      equ    %00010000
mFSTAT_ACCERR:      equ    %00100000
mFSTAT_CCIF:        equ    %10000000


;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
FERSTAT:            equ    $00000107                                ;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERSTAT_SFDIF:      equ    0                                         ; Single Bit Fault Detect Interrupt Flag
FERSTAT_DFDIF:      equ    1                                         ; Double Bit Fault Detect Interrupt Flag
; bit position masks
mFERSTAT_SFDIF:     equ    %00000001
mFERSTAT_DFDIF:     equ    %00000010


;*** FPROT - P-Flash Protection Register; 0x00000108 ***
FPROT:              equ    $00000108                                ;*** FPROT - P-Flash Protection Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address Size Bit 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address Size Bit 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower Address Range Disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher Address Size Bit 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher Address Size Bit 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher Address Range Disable
FPROT_RNV6:         equ    6                                         ; Reserved Nonvolatile Bit
FPROT_FPOPEN:       equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
DFPROT:             equ    $00000109                                ;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DFPROT_DPS0:        equ    0                                         ; D-Flash Protection Size Bit 0
DFPROT_DPS1:        equ    1                                         ; D-Flash Protection Size Bit 1
DFPROT_DPS2:        equ    2                                         ; D-Flash Protection Size Bit 2
DFPROT_DPS3:        equ    3                                         ; D-Flash Protection Size Bit 3
DFPROT_DPOPEN:      equ    7                                         ; D-Flash Protection Control
; bit position masks
mDFPROT_DPS0:       equ    %00000001
mDFPROT_DPS1:       equ    %00000010
mDFPROT_DPS2:       equ    %00000100
mDFPROT_DPS3:       equ    %00001000
mDFPROT_DPOPEN:     equ    %10000000


;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
FCCOB:              equ    $0000010A                                ;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOB_CCOB0:        equ    0                                         ; Flash Common Command Object Bit 0
FCCOB_CCOB1:        equ    1                                         ; Flash Common Command Object Bit 1
FCCOB_CCOB2:        equ    2                                         ; Flash Common Command Object Bit 2
FCCOB_CCOB3:        equ    3                                         ; Flash Common Command Object Bit 3
FCCOB_CCOB4:        equ    4                                         ; Flash Common Command Object Bit 4
FCCOB_CCOB5:        equ    5                                         ; Flash Common Command Object Bit 5
FCCOB_CCOB6:        equ    6                                         ; Flash Common Command Object Bit 6
FCCOB_CCOB7:        equ    7                                         ; Flash Common Command Object Bit 7
FCCOB_CCOB8:        equ    8                                         ; Flash Common Command Object Bit 8
FCCOB_CCOB9:        equ    9                                         ; Flash Common Command Object Bit 9
FCCOB_CCOB10:       equ    10                                        ; Flash Common Command Object Bit 10
FCCOB_CCOB11:       equ    11                                        ; Flash Common Command Object Bit 11
FCCOB_CCOB12:       equ    12                                        ; Flash Common Command Object Bit 12
FCCOB_CCOB13:       equ    13                                        ; Flash Common Command Object Bit 13
FCCOB_CCOB14:       equ    14                                        ; Flash Common Command Object Bit 14
FCCOB_CCOB15:       equ    15                                        ; Flash Common Command Object Bit 15
; bit position masks
mFCCOB_CCOB0:       equ    %00000001
mFCCOB_CCOB1:       equ    %00000010
mFCCOB_CCOB2:       equ    %00000100
mFCCOB_CCOB3:       equ    %00001000
mFCCOB_CCOB4:       equ    %00010000
mFCCOB_CCOB5:       equ    %00100000
mFCCOB_CCOB6:       equ    %01000000
mFCCOB_CCOB7:       equ    %10000000
mFCCOB_CCOB8:       equ    %100000000
mFCCOB_CCOB9:       equ    %1000000000
mFCCOB_CCOB10:      equ    %10000000000
mFCCOB_CCOB11:      equ    %100000000000
mFCCOB_CCOB12:      equ    %1000000000000
mFCCOB_CCOB13:      equ    %10000000000000
mFCCOB_CCOB14:      equ    %100000000000000
mFCCOB_CCOB15:      equ    %1000000000000000


;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
FCCOBHI:            equ    $0000010A                                ;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBHI_CCOB8:      equ    0                                         ; Flash Common Command Object Bit 8
FCCOBHI_CCOB9:      equ    1                                         ; Flash Common Command Object Bit 9
FCCOBHI_CCOB10:     equ    2                                         ; Flash Common Command Object Bit 10
FCCOBHI_CCOB11:     equ    3                                         ; Flash Common Command Object Bit 11
FCCOBHI_CCOB12:     equ    4                                         ; Flash Common Command Object Bit 12
FCCOBHI_CCOB13:     equ    5                                         ; Flash Common Command Object Bit 13
FCCOBHI_CCOB14:     equ    6                                         ; Flash Common Command Object Bit 14
FCCOBHI_CCOB15:     equ    7                                         ; Flash Common Command Object Bit 15
; bit position masks
mFCCOBHI_CCOB8:     equ    %00000001
mFCCOBHI_CCOB9:     equ    %00000010
mFCCOBHI_CCOB10:    equ    %00000100
mFCCOBHI_CCOB11:    equ    %00001000
mFCCOBHI_CCOB12:    equ    %00010000
mFCCOBHI_CCOB13:    equ    %00100000
mFCCOBHI_CCOB14:    equ    %01000000
mFCCOBHI_CCOB15:    equ    %10000000


;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
FCCOBLO:            equ    $0000010B                                ;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBLO_CCOB0:      equ    0                                         ; Flash Common Command Object Bit 0
FCCOBLO_CCOB1:      equ    1                                         ; Flash Common Command Object Bit 1
FCCOBLO_CCOB2:      equ    2                                         ; Flash Common Command Object Bit 2
FCCOBLO_CCOB3:      equ    3                                         ; Flash Common Command Object Bit 3
FCCOBLO_CCOB4:      equ    4                                         ; Flash Common Command Object Bit 4
FCCOBLO_CCOB5:      equ    5                                         ; Flash Common Command Object Bit 5
FCCOBLO_CCOB6:      equ    6                                         ; Flash Common Command Object Bit 6
FCCOBLO_CCOB7:      equ    7                                         ; Flash Common Command Object Bit 7
; bit position masks
mFCCOBLO_CCOB0:     equ    %00000001
mFCCOBLO_CCOB1:     equ    %00000010
mFCCOBLO_CCOB2:     equ    %00000100
mFCCOBLO_CCOB3:     equ    %00001000
mFCCOBLO_CCOB4:     equ    %00010000
mFCCOBLO_CCOB5:     equ    %00100000
mFCCOBLO_CCOB6:     equ    %01000000
mFCCOBLO_CCOB7:     equ    %10000000


;*** FOPT - Flash Option Register; 0x00000110 ***
FOPT:               equ    $00000110                                ;*** FOPT - Flash Option Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_NV0:           equ    0                                         ; Nonvolatile Bit 0
FOPT_NV1:           equ    1                                         ; Nonvolatile Bit 1
FOPT_NV2:           equ    2                                         ; Nonvolatile Bit 2
FOPT_NV3:           equ    3                                         ; Nonvolatile Bit 3
FOPT_NV4:           equ    4                                         ; Nonvolatile Bit 4
FOPT_NV5:           equ    5                                         ; Nonvolatile Bit 5
FOPT_NV6:           equ    6                                         ; Nonvolatile Bit 6
FOPT_NV7:           equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mFOPT_NV0:          equ    %00000001
mFOPT_NV1:          equ    %00000010
mFOPT_NV2:          equ    %00000100
mFOPT_NV3:          equ    %00001000
mFOPT_NV4:          equ    %00010000
mFOPT_NV5:          equ    %00100000
mFOPT_NV6:          equ    %01000000
mFOPT_NV7:          equ    %10000000


;*** PTIA - Port A Input Register; 0x00000120 ***
PTIA:               equ    $00000120                                ;*** PTIA - Port A Input Register; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIA_PTIA0:         equ    0                                         ; Port A input data bit 0
PTIA_PTIA1:         equ    1                                         ; Port A input data bit 1
PTIA_PTIA2:         equ    2                                         ; Port A input data bit 2
PTIA_PTIA3:         equ    3                                         ; Port A input data bit 3
PTIA_PTIA4:         equ    4                                         ; Port A input data bit 4
PTIA_PTIA5:         equ    5                                         ; Port A input data bit 5
PTIA_PTIA6:         equ    6                                         ; Port A input data bit 6
PTIA_PTIA7:         equ    7                                         ; Port A input data bit 7
; bit position masks
mPTIA_PTIA0:        equ    %00000001
mPTIA_PTIA1:        equ    %00000010
mPTIA_PTIA2:        equ    %00000100
mPTIA_PTIA3:        equ    %00001000
mPTIA_PTIA4:        equ    %00010000
mPTIA_PTIA5:        equ    %00100000
mPTIA_PTIA6:        equ    %01000000
mPTIA_PTIA7:        equ    %10000000


;*** PTIE - Port E Input Register; 0x00000121 ***
PTIE:               equ    $00000121                                ;*** PTIE - Port E Input Register; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIE_PTIE0:         equ    0                                         ; Port E input data bit 0
PTIE_PTIE1:         equ    1                                         ; Port E input data bit 1
; bit position masks
mPTIE_PTIE0:        equ    %00000001
mPTIE_PTIE1:        equ    %00000010


;*** CPMULVCTL - Low Voltage Control Register; 0x000001F1 ***
CPMULVCTL:          equ    $000001F1                                ;*** CPMULVCTL - Low Voltage Control Register; 0x000001F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMULVCTL_LVIF:     equ    0                                         ; Low-Voltage Interrupt Flag
CPMULVCTL_LVIE:     equ    1                                         ; Low-Voltage Interrupt Enable Bit
CPMULVCTL_LVDS:     equ    2                                         ; Low-Voltage Detect Status Bit
; bit position masks
mCPMULVCTL_LVIF:    equ    %00000001
mCPMULVCTL_LVIE:    equ    %00000010
mCPMULVCTL_LVDS:    equ    %00000100


;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000001F8 ***
CPMUIRCTRIM:        equ    $000001F8                                ;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000001F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIM_IRCTRIM0: equ    0                                       ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIM_IRCTRIM1: equ    1                                       ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIM_IRCTRIM2: equ    2                                       ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIM_IRCTRIM3: equ    3                                       ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIM_IRCTRIM4: equ    4                                       ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIM_IRCTRIM5: equ    5                                       ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIM_IRCTRIM6: equ    6                                       ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIM_IRCTRIM7: equ    7                                       ; IRC1M Frequency Trim Bit 7
CPMUIRCTRIM_IRCTRIM8: equ    8                                       ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIM_IRCTRIM9: equ    9                                       ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIM_TCTRIM0: equ    12                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIM_TCTRIM1: equ    13                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIM_TCTRIM2: equ    14                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIM_TCTRIM3: equ    15                                       ; IRC1M temperature coeficient Trim Bit 3
; bit position masks
mCPMUIRCTRIM_IRCTRIM0: equ    %00000001
mCPMUIRCTRIM_IRCTRIM1: equ    %00000010
mCPMUIRCTRIM_IRCTRIM2: equ    %00000100
mCPMUIRCTRIM_IRCTRIM3: equ    %00001000
mCPMUIRCTRIM_IRCTRIM4: equ    %00010000
mCPMUIRCTRIM_IRCTRIM5: equ    %00100000
mCPMUIRCTRIM_IRCTRIM6: equ    %01000000
mCPMUIRCTRIM_IRCTRIM7: equ    %10000000
mCPMUIRCTRIM_IRCTRIM8: equ    %100000000
mCPMUIRCTRIM_IRCTRIM9: equ    %1000000000
mCPMUIRCTRIM_TCTRIM0: equ    %1000000000000
mCPMUIRCTRIM_TCTRIM1: equ    %10000000000000
mCPMUIRCTRIM_TCTRIM2: equ    %100000000000000
mCPMUIRCTRIM_TCTRIM3: equ    %1000000000000000


;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000001F8 ***
CPMUIRCTRIMH:       equ    $000001F8                                ;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000001F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIMH_IRCTRIM8: equ    0                                      ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIMH_IRCTRIM9: equ    1                                      ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIMH_TCTRIM0: equ    4                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIMH_TCTRIM1: equ    5                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIMH_TCTRIM2: equ    6                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIMH_TCTRIM3: equ    7                                       ; IRC1M temperature coeficient Trim Bit 3
; bit position masks
mCPMUIRCTRIMH_IRCTRIM8: equ    %00000001
mCPMUIRCTRIMH_IRCTRIM9: equ    %00000010
mCPMUIRCTRIMH_TCTRIM0: equ    %00010000
mCPMUIRCTRIMH_TCTRIM1: equ    %00100000
mCPMUIRCTRIMH_TCTRIM2: equ    %01000000
mCPMUIRCTRIMH_TCTRIM3: equ    %10000000


;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000001F9 ***
CPMUIRCTRIML:       equ    $000001F9                                ;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000001F9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIML_IRCTRIM0: equ    0                                      ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIML_IRCTRIM1: equ    1                                      ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIML_IRCTRIM2: equ    2                                      ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIML_IRCTRIM3: equ    3                                      ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIML_IRCTRIM4: equ    4                                      ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIML_IRCTRIM5: equ    5                                      ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIML_IRCTRIM6: equ    6                                      ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIML_IRCTRIM7: equ    7                                      ; IRC1M Frequency Trim Bit 7
; bit position masks
mCPMUIRCTRIML_IRCTRIM0: equ    %00000001
mCPMUIRCTRIML_IRCTRIM1: equ    %00000010
mCPMUIRCTRIML_IRCTRIM2: equ    %00000100
mCPMUIRCTRIML_IRCTRIM3: equ    %00001000
mCPMUIRCTRIML_IRCTRIM4: equ    %00010000
mCPMUIRCTRIML_IRCTRIM5: equ    %00100000
mCPMUIRCTRIML_IRCTRIM6: equ    %01000000
mCPMUIRCTRIML_IRCTRIM7: equ    %10000000


;*** CPMUOSC - S12CPMU Oscillator Register; 0x000001FA ***
CPMUOSC:            equ    $000001FA                                ;*** CPMUOSC - S12CPMU Oscillator Register; 0x000001FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUOSC_OSCFILT0:   equ    0                                         ; Oscillator Filter Bits, bit 0
CPMUOSC_OSCFILT1:   equ    1                                         ; Oscillator Filter Bits, bit 1
CPMUOSC_OSCFILT2:   equ    2                                         ; Oscillator Filter Bits, bit 2
CPMUOSC_OSCFILT3:   equ    3                                         ; Oscillator Filter Bits, bit 3
CPMUOSC_OSCFILT4:   equ    4                                         ; Oscillator Filter Bits, bit 4
CPMUOSC_OSCPINS_EN: equ    5                                         ; Oscillator Pins EXTAL and XTAL Enable Bit
CPMUOSC_OSCBW:      equ    6                                         ; Oscillator Filter Bandwidth Bit
CPMUOSC_OSCE:       equ    7                                         ; Oscillator Enable Bit
; bit position masks
mCPMUOSC_OSCFILT0:  equ    %00000001
mCPMUOSC_OSCFILT1:  equ    %00000010
mCPMUOSC_OSCFILT2:  equ    %00000100
mCPMUOSC_OSCFILT3:  equ    %00001000
mCPMUOSC_OSCFILT4:  equ    %00010000
mCPMUOSC_OSCPINS_EN: equ    %00100000
mCPMUOSC_OSCBW:     equ    %01000000
mCPMUOSC_OSCE:      equ    %10000000


;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000001FB ***
CPMUPROT:           equ    $000001FB                                ;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000001FB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPROT_PROT:      equ    0                                         ; Clock Configuration Registers Protection Bit
; bit position masks
mCPMUPROT_PROT:     equ    %00000001


;*** B_PCR_CTL - PCR Control Register; 0x00000200 ***
B_PCR_CTL:          equ    $00000200                                ;*** B_PCR_CTL - PCR Control Register; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PCR_CTL_OPM:      equ    0                                         ; Operation mode select 0
B_PCR_CTL_PF:       equ    2                                         ; 1 ms Prescaler 0
B_PCR_CTL_HWR:      equ    5                                         ; Hardware Reset
B_PCR_CTL_UVIE:     equ    6                                         ; Low Supply Voltage Interrupt enable
B_PCR_CTL_HTIE:     equ    7                                         ; High Temperature Interrupt enable
B_PCR_CTL_OPMM:     equ    8                                         ; Operation mode mask 0
B_PCR_CTL_PFM:      equ    10                                        ; Prescalar factor mask 0
B_PCR_CTL_HWRM:     equ    13                                        ; Hardware reset mask
B_PCR_CTL_UVIEM:    equ    14                                        ; Supply Under Voltage interrupt enable mask
B_PCR_CTL_HTIEM:    equ    15                                        ; High temperature interrupt enable mask
; bit position masks
mB_PCR_CTL_OPM:     equ    %00000011
mB_PCR_CTL_PF:      equ    %00001100
mB_PCR_CTL_HWR:     equ    %00100000
mB_PCR_CTL_UVIE:    equ    %01000000
mB_PCR_CTL_HTIE:    equ    %10000000
mB_PCR_CTL_OPMM:    equ    %1100000000
mB_PCR_CTL_PFM:     equ    %110000000000
mB_PCR_CTL_HWRM:    equ    %10000000000000
mB_PCR_CTL_UVIEM:   equ    %100000000000000
mB_PCR_CTL_HTIEM:   equ    %1000000000000000


;*** B_PCR_SR - PCR Status Register; 0x00000202 ***
B_PCR_SR:           equ    $00000202                                ;*** B_PCR_SR - PCR Status Register; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PCR_SR_WUPTB0F:   equ    0                                         ; Wake-up on GPIO 0 event flag
B_PCR_SR_WUPTB1F:   equ    1                                         ; Wake-up on GPIO 1 event flag
B_PCR_SR_WUPTB2F:   equ    2                                         ; Wake-up on GPIO 2 event flag
B_PCR_SR_WUPTB3F:   equ    3                                         ; Wake-up on GPIO 3 event flag
B_PCR_SR_WULINF:    equ    4                                         ; Wake-up on LIN flag
B_PCR_SR_WUCALF:    equ    5                                         ; Wake-up on calibration request flag
B_PCR_SR_WUCTHF:    equ    6                                         ; Wake-up on current threshold Flag
B_PCR_SR_WUAHTHF:   equ    7                                         ; Wake-up on Ah counter threshold Flag
B_PCR_SR_WLPMF:     equ    8                                         ; Wake-up after Low Power Mode Flag
B_PCR_SR_WULTCF:    equ    9                                         ; Life Time Counter Wake Up Flag
B_PCR_SR_LVRF:      equ    10                                        ; VDDL Low Voltage (POR) Reset Flag
B_PCR_SR_HVRF:      equ    11                                        ; VDDH Low Voltage Reset Flag
B_PCR_SR_WDRF:      equ    12                                        ; Watchdog Reset Flag
B_PCR_SR_HWRF:      equ    13                                        ; Hardware Reset Flag
B_PCR_SR_UVF:       equ    14                                        ; Supply Undervoltage Condition Flag
B_PCR_SR_HTF:       equ    15                                        ; High Temperature Condition Flag
; bit position masks
mB_PCR_SR_WUPTB0F:  equ    %00000001
mB_PCR_SR_WUPTB1F:  equ    %00000010
mB_PCR_SR_WUPTB2F:  equ    %00000100
mB_PCR_SR_WUPTB3F:  equ    %00001000
mB_PCR_SR_WULINF:   equ    %00010000
mB_PCR_SR_WUCALF:   equ    %00100000
mB_PCR_SR_WUCTHF:   equ    %01000000
mB_PCR_SR_WUAHTHF:  equ    %10000000
mB_PCR_SR_WLPMF:    equ    %100000000
mB_PCR_SR_WULTCF:   equ    %1000000000
mB_PCR_SR_LVRF:     equ    %10000000000
mB_PCR_SR_HVRF:     equ    %100000000000
mB_PCR_SR_WDRF:     equ    %1000000000000
mB_PCR_SR_HWRF:     equ    %10000000000000
mB_PCR_SR_UVF:      equ    %100000000000000
mB_PCR_SR_HTF:      equ    %1000000000000000


;*** B_PCR_SRH - PCR Status Register High; 0x00000202 ***
B_PCR_SRH:          equ    $00000202                                ;*** B_PCR_SRH - PCR Status Register High; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PCR_SRH_WLPMF:    equ    0                                         ; Wake-up after Low Power Mode Flag
B_PCR_SRH_WULTCF:   equ    1                                         ; Life Time Counter Wake Up Flag
B_PCR_SRH_LVRF:     equ    2                                         ; VDDL Low Voltage (POR) Reset Flag
B_PCR_SRH_HVRF:     equ    3                                         ; VDDH Low Voltage Reset Flag
B_PCR_SRH_WDRF:     equ    4                                         ; Watchdog Reset Flag
B_PCR_SRH_HWRF:     equ    5                                         ; Hardware Reset Flag
B_PCR_SRH_UVF:      equ    6                                         ; Supply Undervoltage Condition Flag
B_PCR_SRH_HTF:      equ    7                                         ; High Temperature Condition Flag
; bit position masks
mB_PCR_SRH_WLPMF:   equ    %00000001
mB_PCR_SRH_WULTCF:  equ    %00000010
mB_PCR_SRH_LVRF:    equ    %00000100
mB_PCR_SRH_HVRF:    equ    %00001000
mB_PCR_SRH_WDRF:    equ    %00010000
mB_PCR_SRH_HWRF:    equ    %00100000
mB_PCR_SRH_UVF:     equ    %01000000
mB_PCR_SRH_HTF:     equ    %10000000


;*** B_PCR_SRL - PCR Status Register Low; 0x00000203 ***
B_PCR_SRL:          equ    $00000203                                ;*** B_PCR_SRL - PCR Status Register Low; 0x00000203 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PCR_SRL_WUPTB0F:  equ    0                                         ; Wake-up on GPIO 0 event flag
B_PCR_SRL_WUPTB1F:  equ    1                                         ; Wake-up on GPIO 1 event flag
B_PCR_SRL_WUPTB2F:  equ    2                                         ; Wake-up on GPIO 2 event flag
B_PCR_SRL_WUPTB3F:  equ    3                                         ; Wake-up on GPIO 3 event flag
B_PCR_SRL_WULINF:   equ    4                                         ; Wake-up on LIN flag
B_PCR_SRL_WUCALF:   equ    5                                         ; Wake-up on calibration request flag
B_PCR_SRL_WUCTHF:   equ    6                                         ; Wake-up on current threshold Flag
B_PCR_SRL_WUAHTHF:  equ    7                                         ; Wake-up on Ah counter threshold Flag
; bit position masks
mB_PCR_SRL_WUPTB0F: equ    %00000001
mB_PCR_SRL_WUPTB1F: equ    %00000010
mB_PCR_SRL_WUPTB2F: equ    %00000100
mB_PCR_SRL_WUPTB3F: equ    %00001000
mB_PCR_SRL_WULINF:  equ    %00010000
mB_PCR_SRL_WUCALF:  equ    %00100000
mB_PCR_SRL_WUCTHF:  equ    %01000000
mB_PCR_SRL_WUAHTHF: equ    %10000000


;*** B_PCR_PRESC - PCR 1ms prescaler; 0x00000204 ***
B_PCR_PRESC:        equ    $00000204                                ;*** B_PCR_PRESC - PCR 1ms prescaler; 0x00000204 ***


;*** B_PCR_WUE - Wake Up Enable Register; 0x00000206 ***
B_PCR_WUE:          equ    $00000206                                ;*** B_PCR_WUE - Wake Up Enable Register; 0x00000206 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PCR_WUE_WULTC:    equ    7                                         ; Wake-up on Life Timer Counter Overflow
B_PCR_WUE_WUPTB0:   equ    8                                         ; Wake-up on GPIO 0 event
B_PCR_WUE_WUPTB1:   equ    9                                         ; Wake-up on GPIO 1 event
B_PCR_WUE_WUPTB2:   equ    10                                        ; Wake-up on GPIO 2 event
B_PCR_WUE_WUPTB3:   equ    11                                        ; Wake-up on GPIO 3 event
B_PCR_WUE_WULIN:    equ    12                                        ; Wake-up on LIN
B_PCR_WUE_WUCAL:    equ    13                                        ; Wake-up on calibration request
B_PCR_WUE_WUCTH:    equ    14                                        ; Wake-up on current threshold
B_PCR_WUE_WUAHTH:   equ    15                                        ; Wake-up on Ah counter
; bit position masks
mB_PCR_WUE_WULTC:   equ    %10000000
mB_PCR_WUE_WUPTB0:  equ    %100000000
mB_PCR_WUE_WUPTB1:  equ    %1000000000
mB_PCR_WUE_WUPTB2:  equ    %10000000000
mB_PCR_WUE_WUPTB3:  equ    %100000000000
mB_PCR_WUE_WULIN:   equ    %1000000000000
mB_PCR_WUE_WUCAL:   equ    %10000000000000
mB_PCR_WUE_WUCTH:   equ    %100000000000000
mB_PCR_WUE_WUAHTH:  equ    %1000000000000000


;*** B_PCR_WUEH - Wake Up Enable Register High; 0x00000206 ***
B_PCR_WUEH:         equ    $00000206                                ;*** B_PCR_WUEH - Wake Up Enable Register High; 0x00000206 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PCR_WUEH_WUPTB0:  equ    0                                         ; Wake-up on GPIO 0 event
B_PCR_WUEH_WUPTB1:  equ    1                                         ; Wake-up on GPIO 1 event
B_PCR_WUEH_WUPTB2:  equ    2                                         ; Wake-up on GPIO 2 event
B_PCR_WUEH_WUPTB3:  equ    3                                         ; Wake-up on GPIO 3 event
B_PCR_WUEH_WULIN:   equ    4                                         ; Wake-up on LIN
B_PCR_WUEH_WUCAL:   equ    5                                         ; Wake-up on calibration request
B_PCR_WUEH_WUCTH:   equ    6                                         ; Wake-up on current threshold
B_PCR_WUEH_WUAHTH:  equ    7                                         ; Wake-up on Ah counter
; bit position masks
mB_PCR_WUEH_WUPTB0: equ    %00000001
mB_PCR_WUEH_WUPTB1: equ    %00000010
mB_PCR_WUEH_WUPTB2: equ    %00000100
mB_PCR_WUEH_WUPTB3: equ    %00001000
mB_PCR_WUEH_WULIN:  equ    %00010000
mB_PCR_WUEH_WUCAL:  equ    %00100000
mB_PCR_WUEH_WUCTH:  equ    %01000000
mB_PCR_WUEH_WUAHTH: equ    %10000000


;*** B_PCR_WUEL - Wake Up Enable Register Low; 0x00000207 ***
B_PCR_WUEL:         equ    $00000207                                ;*** B_PCR_WUEL - Wake Up Enable Register Low; 0x00000207 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PCR_WUEL_WULTC:   equ    7                                         ; Wake-up on Life Timer Counter Overflow
; bit position masks
mB_PCR_WUEL_WULTC:  equ    %10000000


;*** B_INT_SRC - Interrupt source register; 0x00000208 ***
B_INT_SRC:          equ    $00000208                                ;*** B_INT_SRC - Interrupt source register; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_INT_SRC_ERR:      equ    0                                         ; SCI Error Interrupt Status
B_INT_SRC_TX:       equ    1                                         ; SCI Transmit Interrupt Status
B_INT_SRC_RX:       equ    2                                         ; SCI Receive Interrupt Status
B_INT_SRC_CVMI:     equ    3                                         ; Current / Voltage Measurement Interrupt Status
B_INT_SRC_LTC:      equ    4                                         ; Life Time Counter Interrupt Status
B_INT_SRC_CAL:      equ    5                                         ; Calibration Request Interrupt Status
B_INT_SRC_UVI:      equ    8                                         ; Undervoltage Interrupt pending or wake up from Cranking Mode Status
B_INT_SRC_HTI:      equ    9                                         ; High Temperature Interrupt Status
B_INT_SRC_LTI:      equ    10                                        ; LIN Driver Over Temperature Interrupt Status
B_INT_SRC_CH0:      equ    11                                        ; TIM16B4C - TIM Channel 0 Interrupt Status
B_INT_SRC_CH1:      equ    12                                        ; TIM16B4C - TIM Channel 1 Interrupt Status
B_INT_SRC_CH2:      equ    13                                        ; TIM16B4C - TIM Channel 2 Interrupt Status
B_INT_SRC_CH3:      equ    14                                        ; TIM16B4C - TIM Channel 3 Interrupt Status
B_INT_SRC_TOV:      equ    15                                        ; TIM16B4C - Timer Overflow Interrupt Status
; bit position masks
mB_INT_SRC_ERR:     equ    %00000001
mB_INT_SRC_TX:      equ    %00000010
mB_INT_SRC_RX:      equ    %00000100
mB_INT_SRC_CVMI:    equ    %00001000
mB_INT_SRC_LTC:     equ    %00010000
mB_INT_SRC_CAL:     equ    %00100000
mB_INT_SRC_UVI:     equ    %100000000
mB_INT_SRC_HTI:     equ    %1000000000
mB_INT_SRC_LTI:     equ    %10000000000
mB_INT_SRC_CH0:     equ    %100000000000
mB_INT_SRC_CH1:     equ    %1000000000000
mB_INT_SRC_CH2:     equ    %10000000000000
mB_INT_SRC_CH3:     equ    %100000000000000
mB_INT_SRC_TOV:     equ    %1000000000000000


;*** B_INT_SRCH - Interrupt source register high; 0x00000208 ***
B_INT_SRCH:         equ    $00000208                                ;*** B_INT_SRCH - Interrupt source register high; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_INT_SRCH_UVI:     equ    0                                         ; Undervoltage Interrupt pending or wake up from Cranking Mode Status
B_INT_SRCH_HTI:     equ    1                                         ; High Temperature Interrupt Status
B_INT_SRCH_LTI:     equ    2                                         ; LIN Driver Over Temperature Interrupt Status
B_INT_SRCH_CH0:     equ    3                                         ; TIM16B4C - TIM Channel 0 Interrupt Status
B_INT_SRCH_CH1:     equ    4                                         ; TIM16B4C - TIM Channel 1 Interrupt Status
B_INT_SRCH_CH2:     equ    5                                         ; TIM16B4C - TIM Channel 2 Interrupt Status
B_INT_SRCH_CH3:     equ    6                                         ; TIM16B4C - TIM Channel 3 Interrupt Status
B_INT_SRCH_TOV:     equ    7                                         ; TIM16B4C - Timer Overflow Interrupt Status
; bit position masks
mB_INT_SRCH_UVI:    equ    %00000001
mB_INT_SRCH_HTI:    equ    %00000010
mB_INT_SRCH_LTI:    equ    %00000100
mB_INT_SRCH_CH0:    equ    %00001000
mB_INT_SRCH_CH1:    equ    %00010000
mB_INT_SRCH_CH2:    equ    %00100000
mB_INT_SRCH_CH3:    equ    %01000000
mB_INT_SRCH_TOV:    equ    %10000000


;*** B_INT_SRCL - Interrupt source register low; 0x00000209 ***
B_INT_SRCL:         equ    $00000209                                ;*** B_INT_SRCL - Interrupt source register low; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_INT_SRCL_ERR:     equ    0                                         ; SCI Error Interrupt Status
B_INT_SRCL_TX:      equ    1                                         ; SCI Transmit Interrupt Status
B_INT_SRCL_RX:      equ    2                                         ; SCI Receive Interrupt Status
B_INT_SRCL_CVMI:    equ    3                                         ; Current / Voltage Measurement Interrupt Status
B_INT_SRCL_LTC:     equ    4                                         ; Life Time Counter Interrupt Status
B_INT_SRCL_CAL:     equ    5                                         ; Calibration Request Interrupt Status
; bit position masks
mB_INT_SRCL_ERR:    equ    %00000001
mB_INT_SRCL_TX:     equ    %00000010
mB_INT_SRCL_RX:     equ    %00000100
mB_INT_SRCL_CVMI:   equ    %00001000
mB_INT_SRCL_LTC:    equ    %00010000
mB_INT_SRCL_CAL:    equ    %00100000


;*** B_INT_VECT - Interrupt vector register; 0x0000020A ***
B_INT_VECT:         equ    $0000020A                                ;*** B_INT_VECT - Interrupt vector register; 0x0000020A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_INT_VECT_IRQ:     equ    0                                         ; Represents the highest prioritized interrupt pending
; bit position masks
mB_INT_VECT_IRQ:    equ    %00001111


;*** B_INT_MSK - Interrupt mask register; 0x0000020C ***
B_INT_MSK:          equ    $0000020C                                ;*** B_INT_MSK - Interrupt mask register; 0x0000020C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_INT_MSK_ERRM:     equ    0                                         ; SCI Error Interrupt Mask
B_INT_MSK_TXM:      equ    1                                         ; SCI Transmit Interrupt Mask
B_INT_MSK_RXM:      equ    2                                         ; SCI Receive Interrupt Mask
B_INT_MSK_CVMM:     equ    3                                         ; Current / Voltage Measurement Interrupt Mask
B_INT_MSK_LTCM:     equ    4                                         ; Life Time Counter Interrupt Mask
B_INT_MSK_CALM:     equ    5                                         ; Calibration Request Interrupt Mask
B_INT_MSK_UVIM:     equ    8                                         ; Undervoltage Interrupt Mask
B_INT_MSK_HTIM:     equ    9                                         ; High Temperature Interrupt Mask
B_INT_MSK_LTIM:     equ    10                                        ; LIN Driver Over Temperature Interrupt Mask
B_INT_MSK_CH0M:     equ    11                                        ; Timer Channel 1 Interrupt Mask
B_INT_MSK_CH1M:     equ    12                                        ; Timer Channel 1 Interrupt Mask
B_INT_MSK_CH2M:     equ    13                                        ; Timer Channel 2 Interrupt Mask
B_INT_MSK_CH3M:     equ    14                                        ; Timer Channel 3 Interrupt Mask
B_INT_MSK_TOVM:     equ    15                                        ; Timer Overflow Interrupt Mask
; bit position masks
mB_INT_MSK_ERRM:    equ    %00000001
mB_INT_MSK_TXM:     equ    %00000010
mB_INT_MSK_RXM:     equ    %00000100
mB_INT_MSK_CVMM:    equ    %00001000
mB_INT_MSK_LTCM:    equ    %00010000
mB_INT_MSK_CALM:    equ    %00100000
mB_INT_MSK_UVIM:    equ    %100000000
mB_INT_MSK_HTIM:    equ    %1000000000
mB_INT_MSK_LTIM:    equ    %10000000000
mB_INT_MSK_CH0M:    equ    %100000000000
mB_INT_MSK_CH1M:    equ    %1000000000000
mB_INT_MSK_CH2M:    equ    %10000000000000
mB_INT_MSK_CH3M:    equ    %100000000000000
mB_INT_MSK_TOVM:    equ    %1000000000000000


;*** B_INT_MSKH - Interrupt mask register high; 0x0000020C ***
B_INT_MSKH:         equ    $0000020C                                ;*** B_INT_MSKH - Interrupt mask register high; 0x0000020C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_INT_MSKH_UVIM:    equ    0                                         ; Undervoltage Interrupt Mask
B_INT_MSKH_HTIM:    equ    1                                         ; High Temperature Interrupt Mask
B_INT_MSKH_LTIM:    equ    2                                         ; LIN Driver Over Temperature Interrupt Mask
B_INT_MSKH_CH0M:    equ    3                                         ; Timer Channel 1 Interrupt Mask
B_INT_MSKH_CH1M:    equ    4                                         ; Timer Channel 1 Interrupt Mask
B_INT_MSKH_CH2M:    equ    5                                         ; Timer Channel 2 Interrupt Mask
B_INT_MSKH_CH3M:    equ    6                                         ; Timer Channel 3 Interrupt Mask
B_INT_MSKH_TOVM:    equ    7                                         ; Timer Overflow Interrupt Mask
; bit position masks
mB_INT_MSKH_UVIM:   equ    %00000001
mB_INT_MSKH_HTIM:   equ    %00000010
mB_INT_MSKH_LTIM:   equ    %00000100
mB_INT_MSKH_CH0M:   equ    %00001000
mB_INT_MSKH_CH1M:   equ    %00010000
mB_INT_MSKH_CH2M:   equ    %00100000
mB_INT_MSKH_CH3M:   equ    %01000000
mB_INT_MSKH_TOVM:   equ    %10000000


;*** B_INT_MSKL - Interrupt mask register low; 0x0000020D ***
B_INT_MSKL:         equ    $0000020D                                ;*** B_INT_MSKL - Interrupt mask register low; 0x0000020D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_INT_MSKL_ERRM:    equ    0                                         ; SCI Error Interrupt Mask
B_INT_MSKL_TXM:     equ    1                                         ; SCI Transmit Interrupt Mask
B_INT_MSKL_RXM:     equ    2                                         ; SCI Receive Interrupt Mask
B_INT_MSKL_CVMM:    equ    3                                         ; Current / Voltage Measurement Interrupt Mask
B_INT_MSKL_LTCM:    equ    4                                         ; Life Time Counter Interrupt Mask
B_INT_MSKL_CALM:    equ    5                                         ; Calibration Request Interrupt Mask
; bit position masks
mB_INT_MSKL_ERRM:   equ    %00000001
mB_INT_MSKL_TXM:    equ    %00000010
mB_INT_MSKL_RXM:    equ    %00000100
mB_INT_MSKL_CVMM:   equ    %00001000
mB_INT_MSKL_LTCM:   equ    %00010000
mB_INT_MSKL_CALM:   equ    %00100000


;*** B_TRIM_ALF - Trim for accurate 1ms low freq clock; 0x0000020E ***
B_TRIM_ALF:         equ    $0000020E                                ;*** B_TRIM_ALF - Trim for accurate 1ms low freq clock; 0x0000020E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_ALF_APRESC:  equ    0                                         ; ALFCLK Prescaler 0
B_TRIM_ALF_PRDF:    equ    15                                        ; ALFCLK Prescaler ready Flag
; bit position masks
mB_TRIM_ALF_APRESC: equ    %1111111111111
mB_TRIM_ALF_PRDF:   equ    %1000000000000000


;*** B_TRIM_ALFH - Trim for accurate 1ms low freq clock high; 0x0000020E ***
B_TRIM_ALFH:        equ    $0000020E                                ;*** B_TRIM_ALFH - Trim for accurate 1ms low freq clock high; 0x0000020E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_ALFH_APRESC: equ    0                                         ; ALFCLK Prescaler 8
B_TRIM_ALFH_PRDF:   equ    7                                         ; ALFCLK Prescaler ready Flag
; bit position masks
mB_TRIM_ALFH_APRESC: equ    %00011111
mB_TRIM_ALFH_PRDF:  equ    %10000000


;*** B_TRIM_ALFL - Trim for accurate 1ms low freq clock low; 0x0000020F ***
B_TRIM_ALFL:        equ    $0000020F                                ;*** B_TRIM_ALFL - Trim for accurate 1ms low freq clock low; 0x0000020F ***


;*** B_WD_CTL - Watchdog control register; 0x00000210 ***
B_WD_CTL:           equ    $00000210                                ;*** B_WD_CTL - Watchdog control register; 0x00000210 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_WD_CTL_WDTO:      equ    0                                         ; Watchdog Time Out Configuration
B_WD_CTL_WDTST:     equ    7                                         ; Watchdog Test
B_WD_CTL_WDTOM:     equ    8                                         ; Watchdog Time Out - Mask
B_WD_CTL_WDSTM:     equ    15                                        ; Watchdog Test - Mask
; bit position masks
mB_WD_CTL_WDTO:     equ    %00000111
mB_WD_CTL_WDTST:    equ    %10000000
mB_WD_CTL_WDTOM:    equ    %11100000000
mB_WD_CTL_WDSTM:    equ    %1000000000000000


;*** B_WD_SR - Watchdog status register; 0x00000212 ***
B_WD_SR:            equ    $00000212                                ;*** B_WD_SR - Watchdog status register; 0x00000212 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_WD_SR_WDWO:       equ    0                                         ; Watchdog Status
B_WD_SR_WDOFF:      equ    1                                         ; Watchdog Window Status
; bit position masks
mB_WD_SR_WDWO:      equ    %00000001
mB_WD_SR_WDOFF:     equ    %00000010


;*** B_WD_RR - Watchdog rearm register; 0x00000214 ***
B_WD_RR:            equ    $00000214                                ;*** B_WD_RR - Watchdog rearm register; 0x00000214 ***


;*** B_SCIBD - SCI Baud Rate Register; 0x00000218 ***
B_SCIBD:            equ    $00000218                                ;*** B_SCIBD - SCI Baud Rate Register; 0x00000218 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIBD_SBR0:       equ    0                                         ; Baud Rate Modulo Divisor Bit 0
B_SCIBD_SBR1:       equ    1                                         ; Baud Rate Modulo Divisor Bit 1
B_SCIBD_SBR2:       equ    2                                         ; Baud Rate Modulo Divisor Bit 2
B_SCIBD_SBR3:       equ    3                                         ; Baud Rate Modulo Divisor Bit 3
B_SCIBD_SBR4:       equ    4                                         ; Baud Rate Modulo Divisor Bit 4
B_SCIBD_SBR5:       equ    5                                         ; Baud Rate Modulo Divisor Bit 5
B_SCIBD_SBR6:       equ    6                                         ; Baud Rate Modulo Divisor Bit 6
B_SCIBD_SBR7:       equ    7                                         ; Baud Rate Modulo Divisor Bit 7
B_SCIBD_SBR8:       equ    8                                         ; Baud Rate Modulo Divisor Bit 8
B_SCIBD_SBR9:       equ    9                                         ; Baud Rate Modulo Divisor Bit 9
B_SCIBD_SBR10:      equ    10                                        ; Baud Rate Modulo Divisor Bit 10
B_SCIBD_SBR11:      equ    11                                        ; Baud Rate Modulo Divisor Bit 11
B_SCIBD_SBR12:      equ    12                                        ; Baud Rate Modulo Divisor Bit 12
B_SCIBD_RXEDGIE:    equ    14                                        ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
B_SCIBD_LBKDIE:     equ    15                                        ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mB_SCIBD_SBR0:      equ    %00000001
mB_SCIBD_SBR1:      equ    %00000010
mB_SCIBD_SBR2:      equ    %00000100
mB_SCIBD_SBR3:      equ    %00001000
mB_SCIBD_SBR4:      equ    %00010000
mB_SCIBD_SBR5:      equ    %00100000
mB_SCIBD_SBR6:      equ    %01000000
mB_SCIBD_SBR7:      equ    %10000000
mB_SCIBD_SBR8:      equ    %100000000
mB_SCIBD_SBR9:      equ    %1000000000
mB_SCIBD_SBR10:     equ    %10000000000
mB_SCIBD_SBR11:     equ    %100000000000
mB_SCIBD_SBR12:     equ    %1000000000000
mB_SCIBD_RXEDGIE:   equ    %100000000000000
mB_SCIBD_LBKDIE:    equ    %1000000000000000


;*** B_SCIBDH - SCI Baud Rate Register High; 0x00000218 ***
B_SCIBDH:           equ    $00000218                                ;*** B_SCIBDH - SCI Baud Rate Register High; 0x00000218 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIBDH_SBR8:      equ    0                                         ; Baud Rate Modulo Divisor Bit 8
B_SCIBDH_SBR9:      equ    1                                         ; Baud Rate Modulo Divisor Bit 9
B_SCIBDH_SBR10:     equ    2                                         ; Baud Rate Modulo Divisor Bit 10
B_SCIBDH_SBR11:     equ    3                                         ; Baud Rate Modulo Divisor Bit 11
B_SCIBDH_SBR12:     equ    4                                         ; Baud Rate Modulo Divisor Bit 12
B_SCIBDH_RXEDGIE:   equ    6                                         ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
B_SCIBDH_LBKDIE:    equ    7                                         ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mB_SCIBDH_SBR8:     equ    %00000001
mB_SCIBDH_SBR9:     equ    %00000010
mB_SCIBDH_SBR10:    equ    %00000100
mB_SCIBDH_SBR11:    equ    %00001000
mB_SCIBDH_SBR12:    equ    %00010000
mB_SCIBDH_RXEDGIE:  equ    %01000000
mB_SCIBDH_LBKDIE:   equ    %10000000


;*** B_SCIBDL - SCI Baud Rate Register Low; 0x00000219 ***
B_SCIBDL:           equ    $00000219                                ;*** B_SCIBDL - SCI Baud Rate Register Low; 0x00000219 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIBDL_SBR0:      equ    0                                         ; Baud Rate Modulo Divisor Bit 0
B_SCIBDL_SBR1:      equ    1                                         ; Baud Rate Modulo Divisor Bit 1
B_SCIBDL_SBR2:      equ    2                                         ; Baud Rate Modulo Divisor Bit 2
B_SCIBDL_SBR3:      equ    3                                         ; Baud Rate Modulo Divisor Bit 3
B_SCIBDL_SBR4:      equ    4                                         ; Baud Rate Modulo Divisor Bit 4
B_SCIBDL_SBR5:      equ    5                                         ; Baud Rate Modulo Divisor Bit 5
B_SCIBDL_SBR6:      equ    6                                         ; Baud Rate Modulo Divisor Bit 6
B_SCIBDL_SBR7:      equ    7                                         ; Baud Rate Modulo Divisor Bit 7
; bit position masks
mB_SCIBDL_SBR0:     equ    %00000001
mB_SCIBDL_SBR1:     equ    %00000010
mB_SCIBDL_SBR2:     equ    %00000100
mB_SCIBDL_SBR3:     equ    %00001000
mB_SCIBDL_SBR4:     equ    %00010000
mB_SCIBDL_SBR5:     equ    %00100000
mB_SCIBDL_SBR6:     equ    %01000000
mB_SCIBDL_SBR7:     equ    %10000000


;*** B_SCIC1 - SCI Control Register 1; 0x0000021A ***
B_SCIC1:            equ    $0000021A                                ;*** B_SCIC1 - SCI Control Register 1; 0x0000021A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIC1_PT:         equ    0                                         ; Parity Type
B_SCIC1_PE:         equ    1                                         ; Parity Enable
B_SCIC1_ILT:        equ    2                                         ; Idle Line Type Select
B_SCIC1_M:          equ    4                                         ; 9-Bit or 8-Bit Mode Select
B_SCIC1_RSRC:       equ    5                                         ; Receiver Source Select
B_SCIC1_LOOPS:      equ    7                                         ; Loop Mode Select
; bit position masks
mB_SCIC1_PT:        equ    %00000001
mB_SCIC1_PE:        equ    %00000010
mB_SCIC1_ILT:       equ    %00000100
mB_SCIC1_M:         equ    %00010000
mB_SCIC1_RSRC:      equ    %00100000
mB_SCIC1_LOOPS:     equ    %10000000


;*** B_SCIC2 - SCI Control Register 2; 0x0000021B ***
B_SCIC2:            equ    $0000021B                                ;*** B_SCIC2 - SCI Control Register 2; 0x0000021B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIC2_SBK:        equ    0                                         ; Send Break
B_SCIC2_RWU:        equ    1                                         ; Receiver Wakeup Control
B_SCIC2_RE:         equ    2                                         ; Receiver Enable
B_SCIC2_TE:         equ    3                                         ; Transmitter Enable
B_SCIC2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable (for IDLE)
B_SCIC2_RIE:        equ    5                                         ; Receiver Interrupt Enable (for RDRF)
B_SCIC2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable (for TC)
B_SCIC2_TIE:        equ    7                                         ; Transmit Interrupt Enable (for TDRE)
; bit position masks
mB_SCIC2_SBK:       equ    %00000001
mB_SCIC2_RWU:       equ    %00000010
mB_SCIC2_RE:        equ    %00000100
mB_SCIC2_TE:        equ    %00001000
mB_SCIC2_ILIE:      equ    %00010000
mB_SCIC2_RIE:       equ    %00100000
mB_SCIC2_TCIE:      equ    %01000000
mB_SCIC2_TIE:       equ    %10000000


;*** B_SCIS1 - SCI Status Register 1; 0x0000021C ***
B_SCIS1:            equ    $0000021C                                ;*** B_SCIS1 - SCI Status Register 1; 0x0000021C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIS1_PF:         equ    0                                         ; Parity Error Flag
B_SCIS1_FE:         equ    1                                         ; Framing Error Flag
B_SCIS1_NF:         equ    2                                         ; Noise Flag
B_SCIS1_OR:         equ    3                                         ; Receiver Overrun Flag
B_SCIS1_IDLE:       equ    4                                         ; Idle Line Flag
B_SCIS1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
B_SCIS1_TC:         equ    6                                         ; Transmission Complete Flag
B_SCIS1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mB_SCIS1_PF:        equ    %00000001
mB_SCIS1_FE:        equ    %00000010
mB_SCIS1_NF:        equ    %00000100
mB_SCIS1_OR:        equ    %00001000
mB_SCIS1_IDLE:      equ    %00010000
mB_SCIS1_RDRF:      equ    %00100000
mB_SCIS1_TC:        equ    %01000000
mB_SCIS1_TDRE:      equ    %10000000


;*** B_SCIS2 - SCI Status Register 2; 0x0000021D ***
B_SCIS2:            equ    $0000021D                                ;*** B_SCIS2 - SCI Status Register 2; 0x0000021D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIS2_RAF:        equ    0                                         ; Receiver Active Flag
B_SCIS2_LBKDE:      equ    1                                         ; LIN Break Detection Enable
B_SCIS2_BRK13:      equ    2                                         ; Break Character Generation Length
B_SCIS2_RWUID:      equ    3                                         ; Receive Wake Up Idle Detect
B_SCIS2_RXINV:      equ    4                                         ; Receive Data Inversion
B_SCIS2_RXEDGIF:    equ    6                                         ; RxD Pin Active Edge Interrupt Flag
B_SCIS2_LBKDIF:     equ    7                                         ; LIN Break Detect Interrupt Flag
; bit position masks
mB_SCIS2_RAF:       equ    %00000001
mB_SCIS2_LBKDE:     equ    %00000010
mB_SCIS2_BRK13:     equ    %00000100
mB_SCIS2_RWUID:     equ    %00001000
mB_SCIS2_RXINV:     equ    %00010000
mB_SCIS2_RXEDGIF:   equ    %01000000
mB_SCIS2_LBKDIF:    equ    %10000000


;*** B_SCIC3 - SCI Control Register 3; 0x0000021E ***
B_SCIC3:            equ    $0000021E                                ;*** B_SCIC3 - SCI Control Register 3; 0x0000021E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIC3_PEIE:       equ    0                                         ; Parity Error Interrupt Enable
B_SCIC3_FEIE:       equ    1                                         ; Framing Error Interrupt Enable
B_SCIC3_NEIE:       equ    2                                         ; Noise Error Interrupt Enable
B_SCIC3_ORIE:       equ    3                                         ; Overrun Interrupt Enable
B_SCIC3_TXINV:      equ    4                                         ; Transmit Data Inversion
B_SCIC3_TXDIR:      equ    5                                         ; TxD Pin Direction in Single-Wire Mode
B_SCIC3_T8:         equ    6                                         ; Ninth Data Bit for Transmitter
B_SCIC3_R8:         equ    7                                         ; Ninth Data Bit for Receiver
; bit position masks
mB_SCIC3_PEIE:      equ    %00000001
mB_SCIC3_FEIE:      equ    %00000010
mB_SCIC3_NEIE:      equ    %00000100
mB_SCIC3_ORIE:      equ    %00001000
mB_SCIC3_TXINV:     equ    %00010000
mB_SCIC3_TXDIR:     equ    %00100000
mB_SCIC3_T8:        equ    %01000000
mB_SCIC3_R8:        equ    %10000000


;*** B_SCID - SCI Data Register; 0x0000021F ***
B_SCID:             equ    $0000021F                                ;*** B_SCID - SCI Data Register; 0x0000021F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCID_R0_T0:       equ    0                                         ; Receive/Transmit Data Bit 0
B_SCID_R1_T1:       equ    1                                         ; Receive/Transmit Data Bit 1
B_SCID_R2_T2:       equ    2                                         ; Receive/Transmit Data Bit 2
B_SCID_R3_T3:       equ    3                                         ; Receive/Transmit Data Bit 3
B_SCID_R4_T4:       equ    4                                         ; Receive/Transmit Data Bit 4
B_SCID_R5_T5:       equ    5                                         ; Receive/Transmit Data Bit 5
B_SCID_R6_T6:       equ    6                                         ; Receive/Transmit Data Bit 6
B_SCID_R7_T7:       equ    7                                         ; Receive/Transmit Data Bit 7
; bit position masks
mB_SCID_R0_T0:      equ    %00000001
mB_SCID_R1_T1:      equ    %00000010
mB_SCID_R2_T2:      equ    %00000100
mB_SCID_R3_T3:      equ    %00001000
mB_SCID_R4_T4:      equ    %00010000
mB_SCID_R5_T5:      equ    %00100000
mB_SCID_R6_T6:      equ    %01000000
mB_SCID_R7_T7:      equ    %10000000


;*** B_TIOS - Timer Input Capture/Output Compare Select; 0x00000220 ***
B_TIOS:             equ    $00000220                                ;*** B_TIOS - Timer Input Capture/Output Compare Select; 0x00000220 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TIOS_IOS0:        equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
B_TIOS_IOS1:        equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
B_TIOS_IOS2:        equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
B_TIOS_IOS3:        equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
; bit position masks
mB_TIOS_IOS0:       equ    %00000001
mB_TIOS_IOS1:       equ    %00000010
mB_TIOS_IOS2:       equ    %00000100
mB_TIOS_IOS3:       equ    %00001000


;*** B_CFORC - Timer Compare Force Register; 0x00000221 ***
B_CFORC:            equ    $00000221                                ;*** B_CFORC - Timer Compare Force Register; 0x00000221 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_CFORC_FOC0:       equ    0                                         ; Force Output Compare Action for Channel 0
B_CFORC_FOC1:       equ    1                                         ; Force Output Compare Action for Channel 1
B_CFORC_FOC2:       equ    2                                         ; Force Output Compare Action for Channel 2
B_CFORC_FOC3:       equ    3                                         ; Force Output Compare Action for Channel 3
; bit position masks
mB_CFORC_FOC0:      equ    %00000001
mB_CFORC_FOC1:      equ    %00000010
mB_CFORC_FOC2:      equ    %00000100
mB_CFORC_FOC3:      equ    %00001000


;*** B_OC3M - Output Compare 3 Mask Register; 0x00000222 ***
B_OC3M:             equ    $00000222                                ;*** B_OC3M - Output Compare 3 Mask Register; 0x00000222 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_OC3M_OC3M0:       equ    0                                         ; Output Compare 3 Mask Bit 0
B_OC3M_OC3M1:       equ    1                                         ; Output Compare 3 Mask Bit 1
B_OC3M_OC3M2:       equ    2                                         ; Output Compare 3 Mask Bit 2
B_OC3M_OC3M3:       equ    3                                         ; Output Compare 3 Mask Bit 3
; bit position masks
mB_OC3M_OC3M0:      equ    %00000001
mB_OC3M_OC3M1:      equ    %00000010
mB_OC3M_OC3M2:      equ    %00000100
mB_OC3M_OC3M3:      equ    %00001000


;*** B_OC3D - Output Compare 3 Data Register; 0x00000223 ***
B_OC3D:             equ    $00000223                                ;*** B_OC3D - Output Compare 3 Data Register; 0x00000223 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_OC3D_OC3D0:       equ    0                                         ; Output Compare 3 Bit 0
B_OC3D_OC3D1:       equ    1                                         ; Output Compare 3 Bit 1
B_OC3D_OC3D2:       equ    2                                         ; Output Compare 3 Bit 2
B_OC3D_OC3D3:       equ    3                                         ; Output Compare 3 Bit 3
; bit position masks
mB_OC3D_OC3D0:      equ    %00000001
mB_OC3D_OC3D1:      equ    %00000010
mB_OC3D_OC3D2:      equ    %00000100
mB_OC3D_OC3D3:      equ    %00001000


;*** B_TCNT - Timer Count Register; 0x00000224 ***
B_TCNT:             equ    $00000224                                ;*** B_TCNT - Timer Count Register; 0x00000224 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCNT_BIT0:        equ    0                                         ; Timer Count Register Bit 0
B_TCNT_BIT1:        equ    1                                         ; Timer Count Register Bit 1
B_TCNT_BIT2:        equ    2                                         ; Timer Count Register Bit 2
B_TCNT_BIT3:        equ    3                                         ; Timer Count Register Bit 3
B_TCNT_BIT4:        equ    4                                         ; Timer Count Register Bit 4
B_TCNT_BIT5:        equ    5                                         ; Timer Count Register Bit 5
B_TCNT_BIT6:        equ    6                                         ; Timer Count Register Bit 6
B_TCNT_BIT7:        equ    7                                         ; Timer Count Register Bit 7
B_TCNT_BIT8:        equ    8                                         ; Timer Count Register Bit 8
B_TCNT_BIT9:        equ    9                                         ; Timer Count Register Bit 9
B_TCNT_BIT10:       equ    10                                        ; Timer Count Register Bit 10
B_TCNT_BIT11:       equ    11                                        ; Timer Count Register Bit 11
B_TCNT_BIT12:       equ    12                                        ; Timer Count Register Bit 12
B_TCNT_BIT13:       equ    13                                        ; Timer Count Register Bit 13
B_TCNT_BIT14:       equ    14                                        ; Timer Count Register Bit 14
B_TCNT_BIT15:       equ    15                                        ; Timer Count Register Bit 15
; bit position masks
mB_TCNT_BIT0:       equ    %00000001
mB_TCNT_BIT1:       equ    %00000010
mB_TCNT_BIT2:       equ    %00000100
mB_TCNT_BIT3:       equ    %00001000
mB_TCNT_BIT4:       equ    %00010000
mB_TCNT_BIT5:       equ    %00100000
mB_TCNT_BIT6:       equ    %01000000
mB_TCNT_BIT7:       equ    %10000000
mB_TCNT_BIT8:       equ    %100000000
mB_TCNT_BIT9:       equ    %1000000000
mB_TCNT_BIT10:      equ    %10000000000
mB_TCNT_BIT11:      equ    %100000000000
mB_TCNT_BIT12:      equ    %1000000000000
mB_TCNT_BIT13:      equ    %10000000000000
mB_TCNT_BIT14:      equ    %100000000000000
mB_TCNT_BIT15:      equ    %1000000000000000


;*** B_TCNTHi - Timer Count Register High; 0x00000224 ***
B_TCNTHi:           equ    $00000224                                ;*** B_TCNTHi - Timer Count Register High; 0x00000224 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCNTHi_BIT8:      equ    0                                         ; Timer Count Register Bit 8
B_TCNTHi_BIT9:      equ    1                                         ; Timer Count Register Bit 9
B_TCNTHi_BIT10:     equ    2                                         ; Timer Count Register Bit 10
B_TCNTHi_BIT11:     equ    3                                         ; Timer Count Register Bit 11
B_TCNTHi_BIT12:     equ    4                                         ; Timer Count Register Bit 12
B_TCNTHi_BIT13:     equ    5                                         ; Timer Count Register Bit 13
B_TCNTHi_BIT14:     equ    6                                         ; Timer Count Register Bit 14
B_TCNTHi_BIT15:     equ    7                                         ; Timer Count Register Bit 15
; bit position masks
mB_TCNTHi_BIT8:     equ    %00000001
mB_TCNTHi_BIT9:     equ    %00000010
mB_TCNTHi_BIT10:    equ    %00000100
mB_TCNTHi_BIT11:    equ    %00001000
mB_TCNTHi_BIT12:    equ    %00010000
mB_TCNTHi_BIT13:    equ    %00100000
mB_TCNTHi_BIT14:    equ    %01000000
mB_TCNTHi_BIT15:    equ    %10000000


;*** B_TCNTLo - Timer Count Register Low; 0x00000225 ***
B_TCNTLo:           equ    $00000225                                ;*** B_TCNTLo - Timer Count Register Low; 0x00000225 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCNTLo_BIT0:      equ    0                                         ; Timer Count Register Bit 0
B_TCNTLo_BIT1:      equ    1                                         ; Timer Count Register Bit 1
B_TCNTLo_BIT2:      equ    2                                         ; Timer Count Register Bit 2
B_TCNTLo_BIT3:      equ    3                                         ; Timer Count Register Bit 3
B_TCNTLo_BIT4:      equ    4                                         ; Timer Count Register Bit 4
B_TCNTLo_BIT5:      equ    5                                         ; Timer Count Register Bit 5
B_TCNTLo_BIT6:      equ    6                                         ; Timer Count Register Bit 6
B_TCNTLo_BIT7:      equ    7                                         ; Timer Count Register Bit 7
; bit position masks
mB_TCNTLo_BIT0:     equ    %00000001
mB_TCNTLo_BIT1:     equ    %00000010
mB_TCNTLo_BIT2:     equ    %00000100
mB_TCNTLo_BIT3:     equ    %00001000
mB_TCNTLo_BIT4:     equ    %00010000
mB_TCNTLo_BIT5:     equ    %00100000
mB_TCNTLo_BIT6:     equ    %01000000
mB_TCNTLo_BIT7:     equ    %10000000


;*** B_TSCR1 - Timer System Control Register1; 0x00000226 ***
B_TSCR1:            equ    $00000226                                ;*** B_TSCR1 - Timer System Control Register1; 0x00000226 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TSCR1_TFFCA:      equ    4                                         ; Timer Fast Flag Clear All
B_TSCR1_TEN:        equ    7                                         ; Timer Enable
; bit position masks
mB_TSCR1_TFFCA:     equ    %00010000
mB_TSCR1_TEN:       equ    %10000000


;*** B_TTOV - Timer Toggle On Overflow Register; 0x00000227 ***
B_TTOV:             equ    $00000227                                ;*** B_TTOV - Timer Toggle On Overflow Register; 0x00000227 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TTOV_TOV0:        equ    0                                         ; Toggle On Overflow Bit 0
B_TTOV_TOV1:        equ    1                                         ; Toggle On Overflow Bit 1
B_TTOV_TOV2:        equ    2                                         ; Toggle On Overflow Bit 2
B_TTOV_TOV3:        equ    3                                         ; Toggle On Overflow Bit 3
; bit position masks
mB_TTOV_TOV0:       equ    %00000001
mB_TTOV_TOV1:       equ    %00000010
mB_TTOV_TOV2:       equ    %00000100
mB_TTOV_TOV3:       equ    %00001000


;*** B_TCTL1 - Timer Control Register 1; 0x00000228 ***
B_TCTL1:            equ    $00000228                                ;*** B_TCTL1 - Timer Control Register 1; 0x00000228 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCTL1_OL0:        equ    0                                         ; Output Level Bit 0
B_TCTL1_OM0:        equ    1                                         ; Output Mode Bit 0
B_TCTL1_OL1:        equ    2                                         ; Output Lecel Bit 1
B_TCTL1_OM1:        equ    3                                         ; Output Mode Bit 1
B_TCTL1_OL2:        equ    4                                         ; Output Level Bit 2
B_TCTL1_OM2:        equ    5                                         ; Output Mode Bit 2
B_TCTL1_OL3:        equ    6                                         ; Output Level Bit 3
B_TCTL1_OM3:        equ    7                                         ; Output Mode Bit 3
; bit position masks
mB_TCTL1_OL0:       equ    %00000001
mB_TCTL1_OM0:       equ    %00000010
mB_TCTL1_OL1:       equ    %00000100
mB_TCTL1_OM1:       equ    %00001000
mB_TCTL1_OL2:       equ    %00010000
mB_TCTL1_OM2:       equ    %00100000
mB_TCTL1_OL3:       equ    %01000000
mB_TCTL1_OM3:       equ    %10000000


;*** B_TCTL2 - Timer Control Register 2; 0x00000229 ***
B_TCTL2:            equ    $00000229                                ;*** B_TCTL2 - Timer Control Register 2; 0x00000229 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCTL2_EDG0A:      equ    0                                         ; Input Capture Edge 0 Control A
B_TCTL2_EDG0B:      equ    1                                         ; Input Capture Edge 0 Control B
B_TCTL2_EDG1A:      equ    2                                         ; Input Capture Edge 1 Control A
B_TCTL2_EDG1B:      equ    3                                         ; Input Capture Edge 1 Control B
B_TCTL2_EDG2A:      equ    4                                         ; Input Capture Edge 2 Control A
B_TCTL2_EDG2B:      equ    5                                         ; Input Capture Edge 2 Control B
B_TCTL2_EDG3A:      equ    6                                         ; Input Capture Edge 3 Control A
B_TCTL2_EDG3B:      equ    7                                         ; Input Capture Edge 3 Control B
; bit position masks
mB_TCTL2_EDG0A:     equ    %00000001
mB_TCTL2_EDG0B:     equ    %00000010
mB_TCTL2_EDG1A:     equ    %00000100
mB_TCTL2_EDG1B:     equ    %00001000
mB_TCTL2_EDG2A:     equ    %00010000
mB_TCTL2_EDG2B:     equ    %00100000
mB_TCTL2_EDG3A:     equ    %01000000
mB_TCTL2_EDG3B:     equ    %10000000


;*** B_TIE - Timer Interrupt Enable Register; 0x0000022A ***
B_TIE:              equ    $0000022A                                ;*** B_TIE - Timer Interrupt Enable Register; 0x0000022A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TIE_C0I:          equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
B_TIE_C1I:          equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
B_TIE_C2I:          equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
B_TIE_C3I:          equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
; bit position masks
mB_TIE_C0I:         equ    %00000001
mB_TIE_C1I:         equ    %00000010
mB_TIE_C2I:         equ    %00000100
mB_TIE_C3I:         equ    %00001000


;*** B_TSCR2 - Timer System Control Register 2; 0x0000022B ***
B_TSCR2:            equ    $0000022B                                ;*** B_TSCR2 - Timer System Control Register 2; 0x0000022B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TSCR2_PR0:        equ    0                                         ; Timer Prescaler Select Bit 0
B_TSCR2_PR1:        equ    1                                         ; Timer Prescaler Select Bit 1
B_TSCR2_PR2:        equ    2                                         ; Timer Prescaler Select Bit 2
B_TSCR2_TCRE:       equ    3                                         ; Timer Counter Reset Enable
B_TSCR2_TOI:        equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mB_TSCR2_PR0:       equ    %00000001
mB_TSCR2_PR1:       equ    %00000010
mB_TSCR2_PR2:       equ    %00000100
mB_TSCR2_TCRE:      equ    %00001000
mB_TSCR2_TOI:       equ    %10000000


;*** B_TFLG1 - Main Timer Interrupt Flag 1; 0x0000022C ***
B_TFLG1:            equ    $0000022C                                ;*** B_TFLG1 - Main Timer Interrupt Flag 1; 0x0000022C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TFLG1_C0F:        equ    0                                         ; Input Capture/Output Compare Channel Flag 0
B_TFLG1_C1F:        equ    1                                         ; Input Capture/Output Compare Channel Flag 1
B_TFLG1_C2F:        equ    2                                         ; Input Capture/Output Compare Channel Flag 2
B_TFLG1_C3F:        equ    3                                         ; Input Capture/Output Compare Channel Flag 3
; bit position masks
mB_TFLG1_C0F:       equ    %00000001
mB_TFLG1_C1F:       equ    %00000010
mB_TFLG1_C2F:       equ    %00000100
mB_TFLG1_C3F:       equ    %00001000


;*** B_TFLG2 - Main Timer Interrupt Flag 2; 0x0000022D ***
B_TFLG2:            equ    $0000022D                                ;*** B_TFLG2 - Main Timer Interrupt Flag 2; 0x0000022D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TFLG2_TOF:        equ    7                                         ; Timer Overflow Flag
; bit position masks
mB_TFLG2_TOF:       equ    %10000000


;*** B_TC0 - Timer Input Capture/Output Compare Register 0; 0x0000022E ***
B_TC0:              equ    $0000022E                                ;*** B_TC0 - Timer Input Capture/Output Compare Register 0; 0x0000022E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC0_BIT0:         equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 0
B_TC0_BIT1:         equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 1
B_TC0_BIT2:         equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 2
B_TC0_BIT3:         equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 3
B_TC0_BIT4:         equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 4
B_TC0_BIT5:         equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 5
B_TC0_BIT6:         equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 6
B_TC0_BIT7:         equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 7
B_TC0_BIT8:         equ    8                                         ; Timer Input Capture/Output Compare Register 0 Bit 8
B_TC0_BIT9:         equ    9                                         ; Timer Input Capture/Output Compare Register 0 Bit 9
B_TC0_BIT10:        equ    10                                        ; Timer Input Capture/Output Compare Register 0 Bit 10
B_TC0_BIT11:        equ    11                                        ; Timer Input Capture/Output Compare Register 0 Bit 11
B_TC0_BIT12:        equ    12                                        ; Timer Input Capture/Output Compare Register 0 Bit 12
B_TC0_BIT13:        equ    13                                        ; Timer Input Capture/Output Compare Register 0 Bit 13
B_TC0_BIT14:        equ    14                                        ; Timer Input Capture/Output Compare Register 0 Bit 14
B_TC0_BIT15:        equ    15                                        ; Timer Input Capture/Output Compare Register 0 Bit 15
; bit position masks
mB_TC0_BIT0:        equ    %00000001
mB_TC0_BIT1:        equ    %00000010
mB_TC0_BIT2:        equ    %00000100
mB_TC0_BIT3:        equ    %00001000
mB_TC0_BIT4:        equ    %00010000
mB_TC0_BIT5:        equ    %00100000
mB_TC0_BIT6:        equ    %01000000
mB_TC0_BIT7:        equ    %10000000
mB_TC0_BIT8:        equ    %100000000
mB_TC0_BIT9:        equ    %1000000000
mB_TC0_BIT10:       equ    %10000000000
mB_TC0_BIT11:       equ    %100000000000
mB_TC0_BIT12:       equ    %1000000000000
mB_TC0_BIT13:       equ    %10000000000000
mB_TC0_BIT14:       equ    %100000000000000
mB_TC0_BIT15:       equ    %1000000000000000


;*** B_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x0000022E ***
B_TC0Hi:            equ    $0000022E                                ;*** B_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x0000022E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC0Hi_BIT8:       equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 8
B_TC0Hi_BIT9:       equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 9
B_TC0Hi_BIT10:      equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 10
B_TC0Hi_BIT11:      equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 11
B_TC0Hi_BIT12:      equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 12
B_TC0Hi_BIT13:      equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 13
B_TC0Hi_BIT14:      equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 14
B_TC0Hi_BIT15:      equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 15
; bit position masks
mB_TC0Hi_BIT8:      equ    %00000001
mB_TC0Hi_BIT9:      equ    %00000010
mB_TC0Hi_BIT10:     equ    %00000100
mB_TC0Hi_BIT11:     equ    %00001000
mB_TC0Hi_BIT12:     equ    %00010000
mB_TC0Hi_BIT13:     equ    %00100000
mB_TC0Hi_BIT14:     equ    %01000000
mB_TC0Hi_BIT15:     equ    %10000000


;*** B_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x0000022F ***
B_TC0Lo:            equ    $0000022F                                ;*** B_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x0000022F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC0Lo_BIT0:       equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 0
B_TC0Lo_BIT1:       equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 1
B_TC0Lo_BIT2:       equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 2
B_TC0Lo_BIT3:       equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 3
B_TC0Lo_BIT4:       equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 4
B_TC0Lo_BIT5:       equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 5
B_TC0Lo_BIT6:       equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 6
B_TC0Lo_BIT7:       equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 7
; bit position masks
mB_TC0Lo_BIT0:      equ    %00000001
mB_TC0Lo_BIT1:      equ    %00000010
mB_TC0Lo_BIT2:      equ    %00000100
mB_TC0Lo_BIT3:      equ    %00001000
mB_TC0Lo_BIT4:      equ    %00010000
mB_TC0Lo_BIT5:      equ    %00100000
mB_TC0Lo_BIT6:      equ    %01000000
mB_TC0Lo_BIT7:      equ    %10000000


;*** B_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000230 ***
B_TC1:              equ    $00000230                                ;*** B_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000230 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC1_BIT0:         equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 0
B_TC1_BIT1:         equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 1
B_TC1_BIT2:         equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 2
B_TC1_BIT3:         equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 3
B_TC1_BIT4:         equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 4
B_TC1_BIT5:         equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 5
B_TC1_BIT6:         equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 6
B_TC1_BIT7:         equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 7
B_TC1_BIT8:         equ    8                                         ; Timer Input Capture/Output Compare Register 1 Bit 8
B_TC1_BIT9:         equ    9                                         ; Timer Input Capture/Output Compare Register 1 Bit 9
B_TC1_BIT10:        equ    10                                        ; Timer Input Capture/Output Compare Register 1 Bit 10
B_TC1_BIT11:        equ    11                                        ; Timer Input Capture/Output Compare Register 1 Bit 11
B_TC1_BIT12:        equ    12                                        ; Timer Input Capture/Output Compare Register 1 Bit 12
B_TC1_BIT13:        equ    13                                        ; Timer Input Capture/Output Compare Register 1 Bit 13
B_TC1_BIT14:        equ    14                                        ; Timer Input Capture/Output Compare Register 1 Bit 14
B_TC1_BIT15:        equ    15                                        ; Timer Input Capture/Output Compare Register 1 Bit 15
; bit position masks
mB_TC1_BIT0:        equ    %00000001
mB_TC1_BIT1:        equ    %00000010
mB_TC1_BIT2:        equ    %00000100
mB_TC1_BIT3:        equ    %00001000
mB_TC1_BIT4:        equ    %00010000
mB_TC1_BIT5:        equ    %00100000
mB_TC1_BIT6:        equ    %01000000
mB_TC1_BIT7:        equ    %10000000
mB_TC1_BIT8:        equ    %100000000
mB_TC1_BIT9:        equ    %1000000000
mB_TC1_BIT10:       equ    %10000000000
mB_TC1_BIT11:       equ    %100000000000
mB_TC1_BIT12:       equ    %1000000000000
mB_TC1_BIT13:       equ    %10000000000000
mB_TC1_BIT14:       equ    %100000000000000
mB_TC1_BIT15:       equ    %1000000000000000


;*** B_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000230 ***
B_TC1Hi:            equ    $00000230                                ;*** B_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000230 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC1Hi_BIT8:       equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 8
B_TC1Hi_BIT9:       equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 9
B_TC1Hi_BIT10:      equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 10
B_TC1Hi_BIT11:      equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 11
B_TC1Hi_BIT12:      equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 12
B_TC1Hi_BIT13:      equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 13
B_TC1Hi_BIT14:      equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 14
B_TC1Hi_BIT15:      equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 15
; bit position masks
mB_TC1Hi_BIT8:      equ    %00000001
mB_TC1Hi_BIT9:      equ    %00000010
mB_TC1Hi_BIT10:     equ    %00000100
mB_TC1Hi_BIT11:     equ    %00001000
mB_TC1Hi_BIT12:     equ    %00010000
mB_TC1Hi_BIT13:     equ    %00100000
mB_TC1Hi_BIT14:     equ    %01000000
mB_TC1Hi_BIT15:     equ    %10000000


;*** B_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000231 ***
B_TC1Lo:            equ    $00000231                                ;*** B_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000231 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC1Lo_BIT0:       equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 0
B_TC1Lo_BIT1:       equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 1
B_TC1Lo_BIT2:       equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 2
B_TC1Lo_BIT3:       equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 3
B_TC1Lo_BIT4:       equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 4
B_TC1Lo_BIT5:       equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 5
B_TC1Lo_BIT6:       equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 6
B_TC1Lo_BIT7:       equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 7
; bit position masks
mB_TC1Lo_BIT0:      equ    %00000001
mB_TC1Lo_BIT1:      equ    %00000010
mB_TC1Lo_BIT2:      equ    %00000100
mB_TC1Lo_BIT3:      equ    %00001000
mB_TC1Lo_BIT4:      equ    %00010000
mB_TC1Lo_BIT5:      equ    %00100000
mB_TC1Lo_BIT6:      equ    %01000000
mB_TC1Lo_BIT7:      equ    %10000000


;*** B_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000232 ***
B_TC2:              equ    $00000232                                ;*** B_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000232 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC2_BIT0:         equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 0
B_TC2_BIT1:         equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 1
B_TC2_BIT2:         equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 2
B_TC2_BIT3:         equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 3
B_TC2_BIT4:         equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 4
B_TC2_BIT5:         equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 5
B_TC2_BIT6:         equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 6
B_TC2_BIT7:         equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 7
B_TC2_BIT8:         equ    8                                         ; Timer Input Capture/Output Compare Register 2 Bit 8
B_TC2_BIT9:         equ    9                                         ; Timer Input Capture/Output Compare Register 2 Bit 9
B_TC2_BIT10:        equ    10                                        ; Timer Input Capture/Output Compare Register 2 Bit 10
B_TC2_BIT11:        equ    11                                        ; Timer Input Capture/Output Compare Register 2 Bit 11
B_TC2_BIT12:        equ    12                                        ; Timer Input Capture/Output Compare Register 2 Bit 12
B_TC2_BIT13:        equ    13                                        ; Timer Input Capture/Output Compare Register 2 Bit 13
B_TC2_BIT14:        equ    14                                        ; Timer Input Capture/Output Compare Register 2 Bit 14
B_TC2_BIT15:        equ    15                                        ; Timer Input Capture/Output Compare Register 2 Bit 15
; bit position masks
mB_TC2_BIT0:        equ    %00000001
mB_TC2_BIT1:        equ    %00000010
mB_TC2_BIT2:        equ    %00000100
mB_TC2_BIT3:        equ    %00001000
mB_TC2_BIT4:        equ    %00010000
mB_TC2_BIT5:        equ    %00100000
mB_TC2_BIT6:        equ    %01000000
mB_TC2_BIT7:        equ    %10000000
mB_TC2_BIT8:        equ    %100000000
mB_TC2_BIT9:        equ    %1000000000
mB_TC2_BIT10:       equ    %10000000000
mB_TC2_BIT11:       equ    %100000000000
mB_TC2_BIT12:       equ    %1000000000000
mB_TC2_BIT13:       equ    %10000000000000
mB_TC2_BIT14:       equ    %100000000000000
mB_TC2_BIT15:       equ    %1000000000000000


;*** B_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000232 ***
B_TC2Hi:            equ    $00000232                                ;*** B_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000232 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC2Hi_BIT8:       equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 8
B_TC2Hi_BIT9:       equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 9
B_TC2Hi_BIT10:      equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 10
B_TC2Hi_BIT11:      equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 11
B_TC2Hi_BIT12:      equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 12
B_TC2Hi_BIT13:      equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 13
B_TC2Hi_BIT14:      equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 14
B_TC2Hi_BIT15:      equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 15
; bit position masks
mB_TC2Hi_BIT8:      equ    %00000001
mB_TC2Hi_BIT9:      equ    %00000010
mB_TC2Hi_BIT10:     equ    %00000100
mB_TC2Hi_BIT11:     equ    %00001000
mB_TC2Hi_BIT12:     equ    %00010000
mB_TC2Hi_BIT13:     equ    %00100000
mB_TC2Hi_BIT14:     equ    %01000000
mB_TC2Hi_BIT15:     equ    %10000000


;*** B_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000233 ***
B_TC2Lo:            equ    $00000233                                ;*** B_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000233 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC2Lo_BIT0:       equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 0
B_TC2Lo_BIT1:       equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 1
B_TC2Lo_BIT2:       equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 2
B_TC2Lo_BIT3:       equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 3
B_TC2Lo_BIT4:       equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 4
B_TC2Lo_BIT5:       equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 5
B_TC2Lo_BIT6:       equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 6
B_TC2Lo_BIT7:       equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 7
; bit position masks
mB_TC2Lo_BIT0:      equ    %00000001
mB_TC2Lo_BIT1:      equ    %00000010
mB_TC2Lo_BIT2:      equ    %00000100
mB_TC2Lo_BIT3:      equ    %00001000
mB_TC2Lo_BIT4:      equ    %00010000
mB_TC2Lo_BIT5:      equ    %00100000
mB_TC2Lo_BIT6:      equ    %01000000
mB_TC2Lo_BIT7:      equ    %10000000


;*** B_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000234 ***
B_TC3:              equ    $00000234                                ;*** B_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000234 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC3_BIT0:         equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 0
B_TC3_BIT1:         equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 1
B_TC3_BIT2:         equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 2
B_TC3_BIT3:         equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 3
B_TC3_BIT4:         equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 4
B_TC3_BIT5:         equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 5
B_TC3_BIT6:         equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 6
B_TC3_BIT7:         equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 7
B_TC3_BIT8:         equ    8                                         ; Timer Input Capture/Output Compare Register 3 Bit 8
B_TC3_BIT9:         equ    9                                         ; Timer Input Capture/Output Compare Register 3 Bit 9
B_TC3_BIT10:        equ    10                                        ; Timer Input Capture/Output Compare Register 3 Bit 10
B_TC3_BIT11:        equ    11                                        ; Timer Input Capture/Output Compare Register 3 Bit 11
B_TC3_BIT12:        equ    12                                        ; Timer Input Capture/Output Compare Register 3 Bit 12
B_TC3_BIT13:        equ    13                                        ; Timer Input Capture/Output Compare Register 3 Bit 13
B_TC3_BIT14:        equ    14                                        ; Timer Input Capture/Output Compare Register 3 Bit 14
B_TC3_BIT15:        equ    15                                        ; Timer Input Capture/Output Compare Register 3 Bit 15
; bit position masks
mB_TC3_BIT0:        equ    %00000001
mB_TC3_BIT1:        equ    %00000010
mB_TC3_BIT2:        equ    %00000100
mB_TC3_BIT3:        equ    %00001000
mB_TC3_BIT4:        equ    %00010000
mB_TC3_BIT5:        equ    %00100000
mB_TC3_BIT6:        equ    %01000000
mB_TC3_BIT7:        equ    %10000000
mB_TC3_BIT8:        equ    %100000000
mB_TC3_BIT9:        equ    %1000000000
mB_TC3_BIT10:       equ    %10000000000
mB_TC3_BIT11:       equ    %100000000000
mB_TC3_BIT12:       equ    %1000000000000
mB_TC3_BIT13:       equ    %10000000000000
mB_TC3_BIT14:       equ    %100000000000000
mB_TC3_BIT15:       equ    %1000000000000000


;*** B_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000234 ***
B_TC3Hi:            equ    $00000234                                ;*** B_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000234 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC3Hi_BIT8:       equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 8
B_TC3Hi_BIT9:       equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 9
B_TC3Hi_BIT10:      equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 10
B_TC3Hi_BIT11:      equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 11
B_TC3Hi_BIT12:      equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 12
B_TC3Hi_BIT13:      equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 13
B_TC3Hi_BIT14:      equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 14
B_TC3Hi_BIT15:      equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 15
; bit position masks
mB_TC3Hi_BIT8:      equ    %00000001
mB_TC3Hi_BIT9:      equ    %00000010
mB_TC3Hi_BIT10:     equ    %00000100
mB_TC3Hi_BIT11:     equ    %00001000
mB_TC3Hi_BIT12:     equ    %00010000
mB_TC3Hi_BIT13:     equ    %00100000
mB_TC3Hi_BIT14:     equ    %01000000
mB_TC3Hi_BIT15:     equ    %10000000


;*** B_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000235 ***
B_TC3Lo:            equ    $00000235                                ;*** B_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000235 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC3Lo_BIT0:       equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 0
B_TC3Lo_BIT1:       equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 1
B_TC3Lo_BIT2:       equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 2
B_TC3Lo_BIT3:       equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 3
B_TC3Lo_BIT4:       equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 4
B_TC3Lo_BIT5:       equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 5
B_TC3Lo_BIT6:       equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 6
B_TC3Lo_BIT7:       equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 7
; bit position masks
mB_TC3Lo_BIT0:      equ    %00000001
mB_TC3Lo_BIT1:      equ    %00000010
mB_TC3Lo_BIT2:      equ    %00000100
mB_TC3Lo_BIT3:      equ    %00001000
mB_TC3Lo_BIT4:      equ    %00010000
mB_TC3Lo_BIT5:      equ    %00100000
mB_TC3Lo_BIT6:      equ    %01000000
mB_TC3Lo_BIT7:      equ    %10000000


;*** B_LTC_CTL - Life Time Counter control register; 0x00000238 ***
B_LTC_CTL:          equ    $00000238                                ;*** B_LTC_CTL - Life Time Counter control register; 0x00000238 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LTC_CTL_LTCE:     equ    0                                         ; Life Time Counter Enable
B_LTC_CTL_LTCIE:    equ    7                                         ; Life Time Counter Interrupt Enable
B_LTC_CTL_LTCEM:    equ    8                                         ; Life Time Counter Enable Mask
B_LTC_CTL_LTCIEM:   equ    15                                        ; Life Time Counter Interrupt Enable Mask
; bit position masks
mB_LTC_CTL_LTCE:    equ    %00000001
mB_LTC_CTL_LTCIE:   equ    %10000000
mB_LTC_CTL_LTCEM:   equ    %100000000
mB_LTC_CTL_LTCIEM:  equ    %1000000000000000


;*** B_LTC_CTLH - Life Time Counter control register high; 0x00000238 ***
B_LTC_CTLH:         equ    $00000238                                ;*** B_LTC_CTLH - Life Time Counter control register high; 0x00000238 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LTC_CTLH_LTCEM:   equ    0                                         ; Life Time Counter Enable Mask
B_LTC_CTLH_LTCIEM:  equ    7                                         ; Life Time Counter Interrupt Enable Mask
; bit position masks
mB_LTC_CTLH_LTCEM:  equ    %00000001
mB_LTC_CTLH_LTCIEM: equ    %10000000


;*** B_LTC_CTLL - Life Time Counter control register low; 0x00000239 ***
B_LTC_CTLL:         equ    $00000239                                ;*** B_LTC_CTLL - Life Time Counter control register low; 0x00000239 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LTC_CTLL_LTCE:    equ    0                                         ; Life Time Counter Enable
B_LTC_CTLL_LTCIE:   equ    7                                         ; Life Time Counter Interrupt Enable
; bit position masks
mB_LTC_CTLL_LTCE:   equ    %00000001
mB_LTC_CTLL_LTCIE:  equ    %10000000


;*** B_LTC_SR - Life Time Counter status register; 0x0000023A ***
B_LTC_SR:           equ    $0000023A                                ;*** B_LTC_SR - Life Time Counter status register; 0x0000023A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LTC_SR_LTCOF:     equ    7                                         ; Life Time Counter Overflow Flag
; bit position masks
mB_LTC_SR_LTCOF:    equ    %10000000


;*** B_LTC_CNT1 - Life Time Counter Register 1; 0x0000023C ***
B_LTC_CNT1:         equ    $0000023C                                ;*** B_LTC_CNT1 - Life Time Counter Register 1; 0x0000023C ***


;*** B_LTC_CNT0 - Life Time Counter Register 0; 0x0000023E ***
B_LTC_CNT0:         equ    $0000023E                                ;*** B_LTC_CNT0 - Life Time Counter Register 0; 0x0000023E ***


;*** B_GPIO_CTL - GPIO control register; 0x00000240 ***
B_GPIO_CTL:         equ    $00000240                                ;*** B_GPIO_CTL - GPIO control register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_CTL_PE0:     equ    0                                         ; Port 0 Enable
B_GPIO_CTL_PE1:     equ    1                                         ; Port 1 Enable
B_GPIO_CTL_PE2:     equ    2                                         ; Port 2 Enable
B_GPIO_CTL_PE3:     equ    3                                         ; Port 3 Enable
B_GPIO_CTL_DIR0:    equ    4                                         ; Data Direction PTB0
B_GPIO_CTL_DIR1:    equ    5                                         ; Data Direction PTB1
B_GPIO_CTL_DIR2:    equ    6                                         ; Data Direction PTB2
B_GPIO_CTL_PE0M:    equ    8                                         ; Port 0 Enable - Mask
B_GPIO_CTL_PE1M:    equ    9                                         ; Port 1 Enable - Mask
B_GPIO_CTL_PE2M:    equ    10                                        ; Port 2 Enable - Mask
B_GPIO_CTL_PE3M:    equ    11                                        ; Port 3 Enable - Mask
B_GPIO_CTL_DIR0M:   equ    12                                        ; Data Direction PTB0 - Mask
B_GPIO_CTL_DIR1M:   equ    13                                        ; Data Direction PTB1 - Mask
B_GPIO_CTL_DIR2M:   equ    14                                        ; Data Direction PTB2 - Mask
; bit position masks
mB_GPIO_CTL_PE0:    equ    %00000001
mB_GPIO_CTL_PE1:    equ    %00000010
mB_GPIO_CTL_PE2:    equ    %00000100
mB_GPIO_CTL_PE3:    equ    %00001000
mB_GPIO_CTL_DIR0:   equ    %00010000
mB_GPIO_CTL_DIR1:   equ    %00100000
mB_GPIO_CTL_DIR2:   equ    %01000000
mB_GPIO_CTL_PE0M:   equ    %100000000
mB_GPIO_CTL_PE1M:   equ    %1000000000
mB_GPIO_CTL_PE2M:   equ    %10000000000
mB_GPIO_CTL_PE3M:   equ    %100000000000
mB_GPIO_CTL_DIR0M:  equ    %1000000000000
mB_GPIO_CTL_DIR1M:  equ    %10000000000000
mB_GPIO_CTL_DIR2M:  equ    %100000000000000


;*** B_GPIO_PUC - GPIO pull up configuration; 0x00000242 ***
B_GPIO_PUC:         equ    $00000242                                ;*** B_GPIO_PUC - GPIO pull up configuration; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_PUC_PUE0:    equ    0                                         ; PTB0 Pull Up Enable
B_GPIO_PUC_PUE1:    equ    1                                         ; PTB1 Pull Up Enable
B_GPIO_PUC_PUE2:    equ    2                                         ; PTB2 Pull Up Enable
B_GPIO_PUC_PDE3:    equ    3                                         ; PTB3 Pull Down Enable
; bit position masks
mB_GPIO_PUC_PUE0:   equ    %00000001
mB_GPIO_PUC_PUE1:   equ    %00000010
mB_GPIO_PUC_PUE2:   equ    %00000100
mB_GPIO_PUC_PDE3:   equ    %00001000


;*** B_GPIO_DATA - GPIO port data register; 0x00000243 ***
B_GPIO_DATA:        equ    $00000243                                ;*** B_GPIO_DATA - GPIO port data register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_DATA_PD0:    equ    0                                         ; PTB0 Data Register
B_GPIO_DATA_PD1:    equ    1                                         ; PTB1 Data Register
B_GPIO_DATA_PD2:    equ    2                                         ; PTB2 Data Register
B_GPIO_DATA_PD3:    equ    3                                         ; PTB3 Data Register
; bit position masks
mB_GPIO_DATA_PD0:   equ    %00000001
mB_GPIO_DATA_PD1:   equ    %00000010
mB_GPIO_DATA_PD2:   equ    %00000100
mB_GPIO_DATA_PD3:   equ    %00001000


;*** B_GPIO_IN0 - Port 0 input configuration; 0x00000244 ***
B_GPIO_IN0:         equ    $00000244                                ;*** B_GPIO_IN0 - Port 0 input configuration; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_IN0_LINTX:   equ    1                                         ; PTB0 - LIN Module Tx Input
B_GPIO_IN0_SCIRX:   equ    2                                         ; PTB0 - SCI Module Rx Input
B_GPIO_IN0_TCAP0:   equ    3                                         ; PTB0 - Timer Input Capture Channel 0
B_GPIO_IN0_TCAP1:   equ    4                                         ; PTB0 - Timer Input Capture Channel 1
B_GPIO_IN0_TCAP2:   equ    5                                         ; PTB0 - Timer Input Capture Channel 2
B_GPIO_IN0_TCAP3:   equ    6                                         ; PTB0 - Timer Input Capture Channel 3
; bit position masks
mB_GPIO_IN0_LINTX:  equ    %00000010
mB_GPIO_IN0_SCIRX:  equ    %00000100
mB_GPIO_IN0_TCAP0:  equ    %00001000
mB_GPIO_IN0_TCAP1:  equ    %00010000
mB_GPIO_IN0_TCAP2:  equ    %00100000
mB_GPIO_IN0_TCAP3:  equ    %01000000


;*** B_GPIO_OUT0 - Port 0 output configuration; 0x00000245 ***
B_GPIO_OUT0:        equ    $00000245                                ;*** B_GPIO_OUT0 - Port 0 output configuration; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_OUT0_PTBX0:  equ    0                                         ; PTB0 - Output Buffer Control
B_GPIO_OUT0_LINRX:  equ    1                                         ; PTB0 - LIN RX Output
B_GPIO_OUT0_SCITX:  equ    2                                         ; PTB0 - SCI TX Output
B_GPIO_OUT0_TCOMP0: equ    3                                         ; PTB0 - Timer Channel 0 - Output Compare output
B_GPIO_OUT0_TCOMP1: equ    4                                         ; PTB0 - Timer Channel 1 - Output Compare output
B_GPIO_OUT0_TCOMP2: equ    5                                         ; PTB0 - Timer Channel 2 - Output Compare output
B_GPIO_OUT0_TCOMP3: equ    6                                         ; PTB0 - Timer Channel 3 - Output Compare output
B_GPIO_OUT0_WKUP:   equ    7                                         ; PTB0 - Wake Up output
; bit position masks
mB_GPIO_OUT0_PTBX0: equ    %00000001
mB_GPIO_OUT0_LINRX: equ    %00000010
mB_GPIO_OUT0_SCITX: equ    %00000100
mB_GPIO_OUT0_TCOMP0: equ    %00001000
mB_GPIO_OUT0_TCOMP1: equ    %00010000
mB_GPIO_OUT0_TCOMP2: equ    %00100000
mB_GPIO_OUT0_TCOMP3: equ    %01000000
mB_GPIO_OUT0_WKUP:  equ    %10000000


;*** B_GPIO_IN1 - Port 1 input configuration; 0x00000246 ***
B_GPIO_IN1:         equ    $00000246                                ;*** B_GPIO_IN1 - Port 1 input configuration; 0x00000246 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_IN1_LINTX:   equ    1                                         ; PTB1 - LIN Module Tx Input
B_GPIO_IN1_SCIRX:   equ    2                                         ; PTB1 - SCI Module Rx Input
B_GPIO_IN1_TCAP0:   equ    3                                         ; PTB1 - Timer Input Capture Channel 0
B_GPIO_IN1_TCAP1:   equ    4                                         ; PTB1 - Timer Input Capture Channel 1
B_GPIO_IN1_TCAP2:   equ    5                                         ; PTB1 - Timer Input Capture Channel 2
B_GPIO_IN1_TCAP3:   equ    6                                         ; PTB1 - Timer Input Capture Channel 3
; bit position masks
mB_GPIO_IN1_LINTX:  equ    %00000010
mB_GPIO_IN1_SCIRX:  equ    %00000100
mB_GPIO_IN1_TCAP0:  equ    %00001000
mB_GPIO_IN1_TCAP1:  equ    %00010000
mB_GPIO_IN1_TCAP2:  equ    %00100000
mB_GPIO_IN1_TCAP3:  equ    %01000000


;*** B_GPIO_OUT1 - Port 1 output configuration; 0x00000247 ***
B_GPIO_OUT1:        equ    $00000247                                ;*** B_GPIO_OUT1 - Port 1 output configuration; 0x00000247 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_OUT1_PTBX1:  equ    0                                         ; PTB1 - Output Buffer Control
B_GPIO_OUT1_LINRX:  equ    1                                         ; PTB1 - LIN RX Output
B_GPIO_OUT1_SCITX:  equ    2                                         ; PTB1 - SCI TX Output
B_GPIO_OUT1_TCOMP0: equ    3                                         ; PTB1 - Timer Channel 0 - Output Compare output
B_GPIO_OUT1_TCOMP1: equ    4                                         ; PTB1 - Timer Channel 1 - Output Compare output
B_GPIO_OUT1_TCOMP2: equ    5                                         ; PTB1 - Timer Channel 2 - Output Compare output
B_GPIO_OUT1_TCOMP3: equ    6                                         ; PTB1 - Timer Channel 3 - Output Compare output
B_GPIO_OUT1_WKUP:   equ    7                                         ; PTB1 - Wake Up output
; bit position masks
mB_GPIO_OUT1_PTBX1: equ    %00000001
mB_GPIO_OUT1_LINRX: equ    %00000010
mB_GPIO_OUT1_SCITX: equ    %00000100
mB_GPIO_OUT1_TCOMP0: equ    %00001000
mB_GPIO_OUT1_TCOMP1: equ    %00010000
mB_GPIO_OUT1_TCOMP2: equ    %00100000
mB_GPIO_OUT1_TCOMP3: equ    %01000000
mB_GPIO_OUT1_WKUP:  equ    %10000000


;*** B_GPIO_IN2 - Port 2 input configuration; 0x00000248 ***
B_GPIO_IN2:         equ    $00000248                                ;*** B_GPIO_IN2 - Port 2 input configuration; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_IN2_LINTX:   equ    1                                         ; PTB2 - LIN Module Tx Input
B_GPIO_IN2_SCIRX:   equ    2                                         ; PTB2 - SCI Module Rx Input
B_GPIO_IN2_TCAP0:   equ    3                                         ; PTB2 - Timer Input Capture Channel 0
B_GPIO_IN2_TCAP1:   equ    4                                         ; PTB2 - Timer Input Capture Channel 1
B_GPIO_IN2_TCAP2:   equ    5                                         ; PTB2 - Timer Input Capture Channel 2
B_GPIO_IN2_TCAP3:   equ    6                                         ; PTB2 - Timer Input Capture Channel 3
; bit position masks
mB_GPIO_IN2_LINTX:  equ    %00000010
mB_GPIO_IN2_SCIRX:  equ    %00000100
mB_GPIO_IN2_TCAP0:  equ    %00001000
mB_GPIO_IN2_TCAP1:  equ    %00010000
mB_GPIO_IN2_TCAP2:  equ    %00100000
mB_GPIO_IN2_TCAP3:  equ    %01000000


;*** B_GPIO_OUT2 - Port 2 output configuration; 0x00000249 ***
B_GPIO_OUT2:        equ    $00000249                                ;*** B_GPIO_OUT2 - Port 2 output configuration; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_OUT2_PTBX2:  equ    0                                         ; PTB2 - Output Buffer Control
B_GPIO_OUT2_LINRX:  equ    1                                         ; PTB2 - LIN RX Output
B_GPIO_OUT2_SCITX:  equ    2                                         ; PTB2 - SCI TX Output
B_GPIO_OUT2_TCOMP0: equ    3                                         ; PTB2 - Timer Channel 0 - Output Compare output
B_GPIO_OUT2_TCOMP1: equ    4                                         ; PTB2 - Timer Channel 1 - Output Compare output
B_GPIO_OUT2_TCOMP2: equ    5                                         ; PTB2 - Timer Channel 2 - Output Compare output
B_GPIO_OUT2_TCOMP3: equ    6                                         ; PTB2 - Timer Channel 3 - Output Compare output
B_GPIO_OUT2_WKUP:   equ    7                                         ; PTB2 - Wake Up output
; bit position masks
mB_GPIO_OUT2_PTBX2: equ    %00000001
mB_GPIO_OUT2_LINRX: equ    %00000010
mB_GPIO_OUT2_SCITX: equ    %00000100
mB_GPIO_OUT2_TCOMP0: equ    %00001000
mB_GPIO_OUT2_TCOMP1: equ    %00010000
mB_GPIO_OUT2_TCOMP2: equ    %00100000
mB_GPIO_OUT2_TCOMP3: equ    %01000000
mB_GPIO_OUT2_WKUP:  equ    %10000000


;*** B_GPIO_IN3 - Port 3 input configuration; 0x0000024A ***
B_GPIO_IN3:         equ    $0000024A                                ;*** B_GPIO_IN3 - Port 3 input configuration; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_GPIO_IN3_TCAP0:   equ    3                                         ; PTB3 - Timer Input Capture Channel 0
B_GPIO_IN3_TCAP1:   equ    4                                         ; PTB3 - Timer Input Capture Channel 1
B_GPIO_IN3_TCAP2:   equ    5                                         ; PTB3 - Timer Input Capture Channel 2
B_GPIO_IN3_TCAP3:   equ    6                                         ; PTB3 - Timer Input Capture Channel 3
B_GPIO_IN3_PTWU:    equ    7                                         ; PTB3 Wake Up
; bit position masks
mB_GPIO_IN3_TCAP0:  equ    %00001000
mB_GPIO_IN3_TCAP1:  equ    %00010000
mB_GPIO_IN3_TCAP2:  equ    %00100000
mB_GPIO_IN3_TCAP3:  equ    %01000000
mB_GPIO_IN3_PTWU:   equ    %10000000


;*** B_LIN_CTL - LIN control register; 0x00000250 ***
B_LIN_CTL:          equ    $00000250                                ;*** B_LIN_CTL - LIN control register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LIN_CTL_SRS:      equ    0                                         ; Slew Rate Select
B_LIN_CTL_EN:       equ    2                                         ; Module Enable
B_LIN_CTL_LVSD:     equ    3                                         ; Low Voltage Shutdown Disable (J2602 Compliance Control)
B_LIN_CTL_TXD:      equ    4                                         ; Direct Transmitter Control
B_LIN_CTL_OTIE:     equ    7                                         ; Overtemperature Interrupt Enable
B_LIN_CTL_SRSM:     equ    8                                         ; Slew Rate Select - Mask
B_LIN_CTL_ENM:      equ    10                                        ; Module Enable - Mask
B_LIN_CTL_LVSDM:    equ    11                                        ; Low Voltage Shutdown Disable (J2602 Compliance Control) - Mask
B_LIN_CTL_TXDM:     equ    12                                        ; Direct Transmitter Control - Mask
B_LIN_CTL_OTIEM:    equ    15                                        ; Overtemperature Interrupt Enable - Mask
; bit position masks
mB_LIN_CTL_SRS:     equ    %00000011
mB_LIN_CTL_EN:      equ    %00000100
mB_LIN_CTL_LVSD:    equ    %00001000
mB_LIN_CTL_TXD:     equ    %00010000
mB_LIN_CTL_OTIE:    equ    %10000000
mB_LIN_CTL_SRSM:    equ    %1100000000
mB_LIN_CTL_ENM:     equ    %10000000000
mB_LIN_CTL_LVSDM:   equ    %100000000000
mB_LIN_CTL_TXDM:    equ    %1000000000000
mB_LIN_CTL_OTIEM:   equ    %1000000000000000


;*** B_LIN_SR - LIN status register; 0x00000252 ***
B_LIN_SR:           equ    $00000252                                ;*** B_LIN_SR - LIN status register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LIN_SR_TX:        equ    0                                         ; Current TX status
B_LIN_SR_RX:        equ    1                                         ; Current RX status
B_LIN_SR_RDY:       equ    7                                         ; Transmitter Ready Status
B_LIN_SR_UV:        equ    11                                        ; Undervoltage Status
B_LIN_SR_HF:        equ    13                                        ; HF (High Frequency) Condition Status indicating HF disturbance in the LIN module
B_LIN_SR_OT:        equ    15                                        ; Overtemperature Status
; bit position masks
mB_LIN_SR_TX:       equ    %00000001
mB_LIN_SR_RX:       equ    %00000010
mB_LIN_SR_RDY:      equ    %10000000
mB_LIN_SR_UV:       equ    %100000000000
mB_LIN_SR_HF:       equ    %10000000000000
mB_LIN_SR_OT:       equ    %1000000000000000


;*** B_LIN_SRH - LIN status register high; 0x00000252 ***
B_LIN_SRH:          equ    $00000252                                ;*** B_LIN_SRH - LIN status register high; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LIN_SRH_UV:       equ    3                                         ; Undervoltage Status
B_LIN_SRH_HF:       equ    5                                         ; HF (High Frequency) Condition Status indicating HF disturbance in the LIN module
B_LIN_SRH_OT:       equ    7                                         ; Overtemperature Status
; bit position masks
mB_LIN_SRH_UV:      equ    %00001000
mB_LIN_SRH_HF:      equ    %00100000
mB_LIN_SRH_OT:      equ    %10000000


;*** B_LIN_SRL - LIN status register low; 0x00000253 ***
B_LIN_SRL:          equ    $00000253                                ;*** B_LIN_SRL - LIN status register low; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LIN_SRL_TX:       equ    0                                         ; Current TX status
B_LIN_SRL_RX:       equ    1                                         ; Current RX status
B_LIN_SRL_RDY:      equ    7                                         ; Transmitter Ready Status
; bit position masks
mB_LIN_SRL_TX:      equ    %00000001
mB_LIN_SRL_RX:      equ    %00000010
mB_LIN_SRL_RDY:     equ    %10000000


;*** B_LIN_TX - LIN transmit line definition; 0x00000254 ***
B_LIN_TX:           equ    $00000254                                ;*** B_LIN_TX - LIN transmit line definition; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LIN_TX_FROMSCI:   equ    0                                         ; LIN_TX internally routed from SCI
B_LIN_TX_FROMPTB:   equ    1                                         ; LIN_TX internally routed from PTB
; bit position masks
mB_LIN_TX_FROMSCI:  equ    %00000001
mB_LIN_TX_FROMPTB:  equ    %00000010


;*** B_LIN_RX - LIN receive line definition; 0x00000255 ***
B_LIN_RX:           equ    $00000255                                ;*** B_LIN_RX - LIN receive line definition; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LIN_RX_TOSCI:     equ    0                                         ; LIN_RX internally routed to SCI
B_LIN_RX_TOPTB:     equ    1                                         ; LIN_RX internally routed to PTB
B_LIN_RX_TCAP0:     equ    3                                         ; LIN_RX internally routed to Timer Channel 0 Input Capture
B_LIN_RX_TCAP1:     equ    4                                         ; LIN_RX internally routed to Timer Channel 1 Input Capture
B_LIN_RX_TCAP2:     equ    5                                         ; LIN_RX internally routed to Timer Channel 2 Input Capture
B_LIN_RX_TCAP3:     equ    6                                         ; LIN_RX internally routed to Timer Channel 3 Input Capture
; bit position masks
mB_LIN_RX_TOSCI:    equ    %00000001
mB_LIN_RX_TOPTB:    equ    %00000010
mB_LIN_RX_TCAP0:    equ    %00001000
mB_LIN_RX_TCAP1:    equ    %00010000
mB_LIN_RX_TCAP2:    equ    %00100000
mB_LIN_RX_TCAP3:    equ    %01000000


;*** B_ACQ_CTL - Acquisition control register; 0x00000258 ***
B_ACQ_CTL:          equ    $00000258                                ;*** B_ACQ_CTL - Acquisition control register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_CTL_CMEN:     equ    0                                         ; Current Measurement Enable
B_ACQ_CTL_VMEN:     equ    1                                         ; Voltage Measurement Enable
B_ACQ_CTL_ITMEN:    equ    2                                         ; Internal Temperature Measurement Enable
B_ACQ_CTL_ETMEN:    equ    3                                         ; External Temperature Measurement Enable
B_ACQ_CTL_CVMIE:    equ    4                                         ; Current / Voltage Measurement Interrupt Enable
B_ACQ_CTL_OPENE:    equ    5                                         ; Enable Shunt Resistor Open Detection
B_ACQ_CTL_OPTE:     equ    6                                         ; Optional Voltage Sense Enable (Voltage Channel Multiplexer Control)
B_ACQ_CTL_AHCR:     equ    7                                         ; Ampere Hour Counter Reset, this write only bit will reset the ACQ_AHC register
B_ACQ_CTL_CMENM:    equ    8                                         ; Current Measurement Enable - Mask
B_ACQ_CTL_VMENM:    equ    9                                         ; Voltage Measurement Enable - Mask
B_ACQ_CTL_ITMENM:   equ    10                                        ; Internal Temperature Measurement Enable - Mask
B_ACQ_CTL_ETMENM:   equ    11                                        ; External Temperature Measurement Enable - Mask
B_ACQ_CTL_CVMIEM:   equ    12                                        ; Current / Voltage Measurement Interrupt Enable - Mask
B_ACQ_CTL_OPENEM:   equ    13                                        ; Enable Shunt Resistor Open Detection - Mask
B_ACQ_CTL_OPTEM:    equ    14                                        ; Optional Voltage Sense Enable - Mask
B_ACQ_CTL_AHCRM:    equ    15                                        ; Ampere Hour Counter Reset - Mask
; bit position masks
mB_ACQ_CTL_CMEN:    equ    %00000001
mB_ACQ_CTL_VMEN:    equ    %00000010
mB_ACQ_CTL_ITMEN:   equ    %00000100
mB_ACQ_CTL_ETMEN:   equ    %00001000
mB_ACQ_CTL_CVMIE:   equ    %00010000
mB_ACQ_CTL_OPENE:   equ    %00100000
mB_ACQ_CTL_OPTE:    equ    %01000000
mB_ACQ_CTL_AHCR:    equ    %10000000
mB_ACQ_CTL_CMENM:   equ    %100000000
mB_ACQ_CTL_VMENM:   equ    %1000000000
mB_ACQ_CTL_ITMENM:  equ    %10000000000
mB_ACQ_CTL_ETMENM:  equ    %100000000000
mB_ACQ_CTL_CVMIEM:  equ    %1000000000000
mB_ACQ_CTL_OPENEM:  equ    %10000000000000
mB_ACQ_CTL_OPTEM:   equ    %100000000000000
mB_ACQ_CTL_AHCRM:   equ    %1000000000000000


;*** B_ACQ_SR - Acquisition status register; 0x0000025A ***
B_ACQ_SR:           equ    $0000025A                                ;*** B_ACQ_SR - Acquisition status register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_SR_CCHOP:     equ    0                                         ; Chopping Active Status - Current
B_ACQ_SR_VCHOP:     equ    1                                         ; Chopping Active Status - Voltage
B_ACQ_SR_ITCHOP:    equ    2                                         ; Chopping Active Status - Internal Temperature
B_ACQ_SR_ETCHOP:    equ    3                                         ; Chopping Active Status - External Temperature
B_ACQ_SR_VTH:       equ    4                                         ; Digital Voltage High Threshold Reached
B_ACQ_SR_OPEN:      equ    7                                         ; Shunt Resistor Open Detection Status
B_ACQ_SR_CM:        equ    8                                         ; End of Measurement - Current
B_ACQ_SR_VM:        equ    9                                         ; End of Measurement - Voltage
B_ACQ_SR_ITM:       equ    10                                        ; End of Measurement - Internal Temperature
B_ACQ_SR_ETM:       equ    11                                        ; End of Measurement - External Temperature
B_ACQ_SR_CMOW:      equ    12                                        ; Current Measurement Result Overwritten
B_ACQ_SR_VMOW:      equ    13                                        ; Voltage Measurement Result Overwritten
B_ACQ_SR_PGAG:      equ    14                                        ; PGA Gain Change Flag
B_ACQ_SR_AVRF:      equ    15                                        ; VDDA Low Voltage Reset Flag
; bit position masks
mB_ACQ_SR_CCHOP:    equ    %00000001
mB_ACQ_SR_VCHOP:    equ    %00000010
mB_ACQ_SR_ITCHOP:   equ    %00000100
mB_ACQ_SR_ETCHOP:   equ    %00001000
mB_ACQ_SR_VTH:      equ    %00010000
mB_ACQ_SR_OPEN:     equ    %10000000
mB_ACQ_SR_CM:       equ    %100000000
mB_ACQ_SR_VM:       equ    %1000000000
mB_ACQ_SR_ITM:      equ    %10000000000
mB_ACQ_SR_ETM:      equ    %100000000000
mB_ACQ_SR_CMOW:     equ    %1000000000000
mB_ACQ_SR_VMOW:     equ    %10000000000000
mB_ACQ_SR_PGAG:     equ    %100000000000000
mB_ACQ_SR_AVRF:     equ    %1000000000000000


;*** B_ACQ_SRH - Acquisition status register high; 0x0000025A ***
B_ACQ_SRH:          equ    $0000025A                                ;*** B_ACQ_SRH - Acquisition status register high; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_SRH_CM:       equ    0                                         ; End of Measurement - Current
B_ACQ_SRH_VM:       equ    1                                         ; End of Measurement - Voltage
B_ACQ_SRH_ITM:      equ    2                                         ; End of Measurement - Internal Temperature
B_ACQ_SRH_ETM:      equ    3                                         ; End of Measurement - External Temperature
B_ACQ_SRH_CMOW:     equ    4                                         ; Current Measurement Result Overwritten
B_ACQ_SRH_VMOW:     equ    5                                         ; Voltage Measurement Result Overwritten
B_ACQ_SRH_PGAG:     equ    6                                         ; PGA Gain Change Flag
B_ACQ_SRH_AVRF:     equ    7                                         ; VDDA Low Voltage Reset Flag
; bit position masks
mB_ACQ_SRH_CM:      equ    %00000001
mB_ACQ_SRH_VM:      equ    %00000010
mB_ACQ_SRH_ITM:     equ    %00000100
mB_ACQ_SRH_ETM:     equ    %00001000
mB_ACQ_SRH_CMOW:    equ    %00010000
mB_ACQ_SRH_VMOW:    equ    %00100000
mB_ACQ_SRH_PGAG:    equ    %01000000
mB_ACQ_SRH_AVRF:    equ    %10000000


;*** B_ACQ_SRL - Acquisition status register low; 0x0000025B ***
B_ACQ_SRL:          equ    $0000025B                                ;*** B_ACQ_SRL - Acquisition status register low; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_SRL_CCHOP:    equ    0                                         ; Chopping Active Status - Current
B_ACQ_SRL_VCHOP:    equ    1                                         ; Chopping Active Status - Voltage
B_ACQ_SRL_ITCHOP:   equ    2                                         ; Chopping Active Status - Internal Temperature
B_ACQ_SRL_ETCHOP:   equ    3                                         ; Chopping Active Status - External Temperature
B_ACQ_SRL_VTH:      equ    4                                         ; Digital Voltage High Threshold Reached
B_ACQ_SRL_OPEN:     equ    7                                         ; Shunt Resistor Open Detection Status
; bit position masks
mB_ACQ_SRL_CCHOP:   equ    %00000001
mB_ACQ_SRL_VCHOP:   equ    %00000010
mB_ACQ_SRL_ITCHOP:  equ    %00000100
mB_ACQ_SRL_ETCHOP:  equ    %00001000
mB_ACQ_SRL_VTH:     equ    %00010000
mB_ACQ_SRL_OPEN:    equ    %10000000


;*** B_ACQ_ACC1 - Acquisition chain control 1; 0x0000025C ***
B_ACQ_ACC1:         equ    $0000025C                                ;*** B_ACQ_ACC1 - Acquisition chain control 1; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_ACC1_AGEN:    equ    0                                         ; Automatic Gain Control Enable - Mask
B_ACQ_ACC1_CVCHOP:  equ    1                                         ; Chopping Enable - Voltage Measurement Channel - Mask
B_ACQ_ACC1_ITCHOP:  equ    2                                         ; Chopping Enable - Internal Temperature Measurement Channel - Mask
B_ACQ_ACC1_ETCHOP:  equ    3                                         ; Chopping Enable - External Temperature Measurement Channel - Mask
B_ACQ_ACC1_LPFEN:   equ    4                                         ; LPF Enable - Mask
B_ACQ_ACC1_CCOMP:   equ    5                                         ; Current Measurement Channel - Compensation Enable - Mask
B_ACQ_ACC1_VCOMP:   equ    6                                         ; Voltage Measurement Channel - Compensation Enable - Mask
B_ACQ_ACC1_TCOMP:   equ    7                                         ; Temperature Measurement Channel - Compensation Enable - Mask
B_ACQ_ACC1_AGENM:   equ    8                                         ; Temperature Measurement Channel - Compensation Enable
B_ACQ_ACC1_CVCHOPM: equ    9                                         ; Voltage Compensation Enable
B_ACQ_ACC1_ITCHOPM: equ    10                                        ; Current Compensation Enable
B_ACQ_ACC1_ETCHOPM: equ    11                                        ; LPF Enable
B_ACQ_ACC1_LPFENM:  equ    12                                        ; Chopping Enable - External Temperature
B_ACQ_ACC1_CCOMPM:  equ    13                                        ; Chopping Enable - Internal Temperature
B_ACQ_ACC1_VCOMPM:  equ    14                                        ; Chopping Enable - Voltage
B_ACQ_ACC1_TCOMPM:  equ    15                                        ; Automatic Gain Control Enable
; bit position masks
mB_ACQ_ACC1_AGEN:   equ    %00000001
mB_ACQ_ACC1_CVCHOP: equ    %00000010
mB_ACQ_ACC1_ITCHOP: equ    %00000100
mB_ACQ_ACC1_ETCHOP: equ    %00001000
mB_ACQ_ACC1_LPFEN:  equ    %00010000
mB_ACQ_ACC1_CCOMP:  equ    %00100000
mB_ACQ_ACC1_VCOMP:  equ    %01000000
mB_ACQ_ACC1_TCOMP:  equ    %10000000
mB_ACQ_ACC1_AGENM:  equ    %100000000
mB_ACQ_ACC1_CVCHOPM: equ    %1000000000
mB_ACQ_ACC1_ITCHOPM: equ    %10000000000
mB_ACQ_ACC1_ETCHOPM: equ    %100000000000
mB_ACQ_ACC1_LPFENM: equ    %1000000000000
mB_ACQ_ACC1_CCOMPM: equ    %10000000000000
mB_ACQ_ACC1_VCOMPM: equ    %100000000000000
mB_ACQ_ACC1_TCOMPM: equ    %1000000000000000


;*** B_ACQ_ACC0 - Acquisition chain control 0; 0x0000025E ***
B_ACQ_ACC0:         equ    $0000025E                                ;*** B_ACQ_ACC0 - Acquisition chain control 0; 0x0000025E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_ACC0_CDEN:    equ    0                                         ; Timing delay - Current
B_ACQ_ACC0_VDEN:    equ    1                                         ; Timing delay - Voltage
B_ACQ_ACC0_TDEN:    equ    2                                         ; Timing delay - Temperature
B_ACQ_ACC0_CADCG:   equ    3                                         ; Current ADC Gain Select
B_ACQ_ACC0_VADCG:   equ    4                                         ; Voltage ADC Gain Select
B_ACQ_ACC0_TADCG:   equ    5                                         ; Temperature ADC Gain Select
B_ACQ_ACC0_ECAP:    equ    6                                         ; TSUP External Capacitor select
B_ACQ_ACC0_ZERO:    equ    7                                         ; Current and Voltage Sigma Delta Input Short
B_ACQ_ACC0_CDENM:   equ    8                                         ; 100ns Clock delay - Current - Mask
B_ACQ_ACC0_VDENM:   equ    9                                         ; 100ns Clock delay - Voltage - Mask
B_ACQ_ACC0_TDENM:   equ    10                                        ; 100ns Clock delay - Internal Temperature - Mask
B_ACQ_ACC0_CADCGM:  equ    11                                        ; Current ADC Gain Select - Mask
B_ACQ_ACC0_VADCGM:  equ    12                                        ; Voltage ADC Gain Select - Mask
B_ACQ_ACC0_TADCGM:  equ    13                                        ; Temperature ADC Gain Select - Mask
B_ACQ_ACC0_ECAPM:   equ    14                                        ; TSUP External Capacitor - Mask
B_ACQ_ACC0_ZEROM:   equ    15                                        ; Current and Voltage Sigma Delta Input Short - Mask
; bit position masks
mB_ACQ_ACC0_CDEN:   equ    %00000001
mB_ACQ_ACC0_VDEN:   equ    %00000010
mB_ACQ_ACC0_TDEN:   equ    %00000100
mB_ACQ_ACC0_CADCG:  equ    %00001000
mB_ACQ_ACC0_VADCG:  equ    %00010000
mB_ACQ_ACC0_TADCG:  equ    %00100000
mB_ACQ_ACC0_ECAP:   equ    %01000000
mB_ACQ_ACC0_ZERO:   equ    %10000000
mB_ACQ_ACC0_CDENM:  equ    %100000000
mB_ACQ_ACC0_VDENM:  equ    %1000000000
mB_ACQ_ACC0_TDENM:  equ    %10000000000
mB_ACQ_ACC0_CADCGM: equ    %100000000000
mB_ACQ_ACC0_VADCGM: equ    %1000000000000
mB_ACQ_ACC0_TADCGM: equ    %10000000000000
mB_ACQ_ACC0_ECAPM:  equ    %100000000000000
mB_ACQ_ACC0_ZEROM:  equ    %1000000000000000


;*** B_ACQ_DEC - Decimation Rate; 0x00000260 ***
B_ACQ_DEC:          equ    $00000260                                ;*** B_ACQ_DEC - Decimation Rate; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_DEC_DEC:      equ    0                                         ; Decimation Rate Selection
; bit position masks
mB_ACQ_DEC_DEC:     equ    %00000111


;*** B_ACQ_BGC - Decimation Rate; 0x00000261 ***
B_ACQ_BGC:          equ    $00000261                                ;*** B_ACQ_BGC - Decimation Rate; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_BGC_BG1EN:    equ    0                                         ; Bandgap Status
B_ACQ_BGC_BG2EN:    equ    1                                         ; Bandgap 3 Status
B_ACQ_BGC_BG3EN:    equ    2                                         ; Bandgap 3 Status
B_ACQ_BGC_BGLDO:    equ    3                                         ; LDO (Low Dropout Regulator) Bandgap select
B_ACQ_BGC_BGADC:    equ    4                                         ; ADC Bandgap select
; bit position masks
mB_ACQ_BGC_BG1EN:   equ    %00000001
mB_ACQ_BGC_BG2EN:   equ    %00000010
mB_ACQ_BGC_BG3EN:   equ    %00000100
mB_ACQ_BGC_BGLDO:   equ    %00001000
mB_ACQ_BGC_BGADC:   equ    %00110000


;*** B_ACQ_GAIN - PGA gain; 0x00000262 ***
B_ACQ_GAIN:         equ    $00000262                                ;*** B_ACQ_GAIN - PGA gain; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_GAIN_IGAIN:   equ    0                                         ; PGA Gain Register
; bit position masks
mB_ACQ_GAIN_IGAIN:  equ    %00000111


;*** B_ACQ_GCB - PGA gain; 0x00000263 ***
B_ACQ_GCB:          equ    $00000263                                ;*** B_ACQ_GCB - PGA gain; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_GCB_Dlo:      equ    0                                         ; Gain Control Block (GCB) - Down Threshold
B_ACQ_GCB_Dhi:      equ    4                                         ; Gain Control Block (GCB) - Up Threshold
; bit position masks
mB_ACQ_GCB_Dlo:     equ    %00001111
mB_ACQ_GCB_Dhi:     equ    %11110000


;*** B_ACQ_ITEMP - Internal temperature measurement result; 0x00000264 ***
B_ACQ_ITEMP:        equ    $00000264                                ;*** B_ACQ_ITEMP - Internal temperature measurement result; 0x00000264 ***


;*** B_ACQ_ITEMPH - Internal temperature measurement result high; 0x00000264 ***
B_ACQ_ITEMPH:       equ    $00000264                                ;*** B_ACQ_ITEMPH - Internal temperature measurement result high; 0x00000264 ***


;*** B_ACQ_ITEMPL - Internal temperature measurement result low; 0x00000265 ***
B_ACQ_ITEMPL:       equ    $00000265                                ;*** B_ACQ_ITEMPL - Internal temperature measurement result low; 0x00000265 ***


;*** B_ACQ_ETEMP - External temperature measurement result; 0x00000266 ***
B_ACQ_ETEMP:        equ    $00000266                                ;*** B_ACQ_ETEMP - External temperature measurement result; 0x00000266 ***


;*** B_ACQ_ETEMPH - External temperature measurement result high; 0x00000266 ***
B_ACQ_ETEMPH:       equ    $00000266                                ;*** B_ACQ_ETEMPH - External temperature measurement result high; 0x00000266 ***


;*** B_ACQ_ETEMPL - External temperature measurement result low; 0x00000267 ***
B_ACQ_ETEMPL:       equ    $00000267                                ;*** B_ACQ_ETEMPL - External temperature measurement result low; 0x00000267 ***


;*** B_ACQ_CURR1 - Current measurement result 16Bit; 0x00000268 ***
B_ACQ_CURR1:        equ    $00000268                                ;*** B_ACQ_CURR1 - Current measurement result 16Bit; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_CURR1_CURR:   equ    8                                         ; Two's complement 24 Bit signed integer result register for the current measurement channel
; bit position masks
mB_ACQ_CURR1_CURR:  equ    %1111111100000000


;*** B_ACQ_CURR1L - Current measurement result 8Bit; 0x00000269 ***
B_ACQ_CURR1L:       equ    $00000269                                ;*** B_ACQ_CURR1L - Current measurement result 8Bit; 0x00000269 ***


;*** B_ACQ_CURR0 - Current measurement result; 0x0000026A ***
B_ACQ_CURR0:        equ    $0000026A                                ;*** B_ACQ_CURR0 - Current measurement result; 0x0000026A ***


;*** B_ACQ_VOLT - Voltage measurement result; 0x0000026C ***
B_ACQ_VOLT:         equ    $0000026C                                ;*** B_ACQ_VOLT - Voltage measurement result; 0x0000026C ***


;*** B_ACQ_LPFC - Low pass filter coefficient number; 0x0000026E ***
B_ACQ_LPFC:         equ    $0000026E                                ;*** B_ACQ_LPFC - Low pass filter coefficient number; 0x0000026E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_LPFC_LPFC:    equ    0                                         ; Low Pass Filter Coefficient Number
; bit position masks
mB_ACQ_LPFC_LPFC:   equ    %00001111


;*** B_ACQ_TCMP - Low power trigger current measurement period; 0x00000270 ***
B_ACQ_TCMP:         equ    $00000270                                ;*** B_ACQ_TCMP - Low power trigger current measurement period; 0x00000270 ***


;*** B_ACQ_THF - Low power current threshold filtering period; 0x00000272 ***
B_ACQ_THF:          equ    $00000272                                ;*** B_ACQ_THF - Low power current threshold filtering period; 0x00000272 ***


;*** B_ACQ_CVCR - I and V chopper control register; 0x00000274 ***
B_ACQ_CVCR:         equ    $00000274                                ;*** B_ACQ_CVCR - I and V chopper control register; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_CVCR_PGAF:    equ    0                                         ; PGA fast mode enable
B_ACQ_CVCR_IIRC:    equ    1                                         ; IIR Low Pass Filter Coefficient
B_ACQ_CVCR_DBT:     equ    4                                         ; Hold Time After Chopper Swap
B_ACQ_CVCR_PGAFM:   equ    8                                         ; PGA fast mode enable - Mask
B_ACQ_CVCR_IIRCM:   equ    9                                         ; IIR Low Pass Filter Configuration - Mask
B_ACQ_CVCR_DBTM:    equ    12                                        ; Hold Time After Chopper Swap - Mask
; bit position masks
mB_ACQ_CVCR_PGAF:   equ    %00000001
mB_ACQ_CVCR_IIRC:   equ    %00001110
mB_ACQ_CVCR_DBT:    equ    %00110000
mB_ACQ_CVCR_PGAFM:  equ    %100000000
mB_ACQ_CVCR_IIRCM:  equ    %111000000000
mB_ACQ_CVCR_DBTM:   equ    %11000000000000


;*** B_ACQ_CVCRH - I and V chopper control register high; 0x00000274 ***
B_ACQ_CVCRH:        equ    $00000274                                ;*** B_ACQ_CVCRH - I and V chopper control register high; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_CVCRH_PGAFM:  equ    0                                         ; PGA fast mode enable - Mask
B_ACQ_CVCRH_IIRCM:  equ    1                                         ; IIR Low Pass Filter Configuration - Mask
B_ACQ_CVCRH_DBTM:   equ    4                                         ; Hold Time After Chopper Swap - Mask
; bit position masks
mB_ACQ_CVCRH_PGAFM: equ    %00000001
mB_ACQ_CVCRH_IIRCM: equ    %00001110
mB_ACQ_CVCRH_DBTM:  equ    %00110000


;*** B_ACQ_CVCRL - I and V chopper control register high low; 0x00000275 ***
B_ACQ_CVCRL:        equ    $00000275                                ;*** B_ACQ_CVCRL - I and V chopper control register high low; 0x00000275 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_CVCRL_PGAF:   equ    0                                         ; PGA fast mode enable
B_ACQ_CVCRL_IIRC:   equ    1                                         ; IIR Low Pass Filter Coefficient
B_ACQ_CVCRL_DBT:    equ    4                                         ; Hold Time After Chopper Swap
; bit position masks
mB_ACQ_CVCRL_PGAF:  equ    %00000001
mB_ACQ_CVCRL_IIRC:  equ    %00001110
mB_ACQ_CVCRL_DBT:   equ    %00110000


;*** B_ACQ_CTH - Low power current threshold; 0x00000276 ***
B_ACQ_CTH:          equ    $00000276                                ;*** B_ACQ_CTH - Low power current threshold; 0x00000276 ***


;*** B_ACQ_AHTH - Low power Ah counter threshold; 0x00000278 ***
B_ACQ_AHTH:         equ    $00000278                                ;*** B_ACQ_AHTH - Low power Ah counter threshold; 0x00000278 ***


;*** B_ACQ_AHTH1 - Low power Ah counter threshold 1; 0x00000278 ***
B_ACQ_AHTH1:        equ    $00000278                                ;*** B_ACQ_AHTH1 - Low power Ah counter threshold 1; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_AHTH1_AHTH:   equ    0                                         ; Low power Ah counter threshold 1
; bit position masks
mB_ACQ_AHTH1_AHTH:  equ    %111111111111111


;*** B_ACQ_AHTH1H - Low power Ah counter threshold 1 high; 0x00000278 ***
B_ACQ_AHTH1H:       equ    $00000278                                ;*** B_ACQ_AHTH1H - Low power Ah counter threshold 1 high; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACQ_AHTH1H_AHTH:  equ    0                                         ; Low power Ah counter threshold 1 high
; bit position masks
mB_ACQ_AHTH1H_AHTH: equ    %01111111


;*** B_ACQ_AHTH1L - Low power Ah counter threshold 1 low; 0x00000279 ***
B_ACQ_AHTH1L:       equ    $00000279                                ;*** B_ACQ_AHTH1L - Low power Ah counter threshold 1 low; 0x00000279 ***


;*** B_ACQ_AHTH0 - Low power Ah counter threshold 0; 0x0000027A ***
B_ACQ_AHTH0:        equ    $0000027A                                ;*** B_ACQ_AHTH0 - Low power Ah counter threshold 0; 0x0000027A ***


;*** B_ACQ_AHTH0H - Low power Ah counter threshold 0 high; 0x0000027A ***
B_ACQ_AHTH0H:       equ    $0000027A                                ;*** B_ACQ_AHTH0H - Low power Ah counter threshold 0 high; 0x0000027A ***


;*** B_ACQ_AHTH0L - Low power Ah counter threshold 0 low; 0x0000027B ***
B_ACQ_AHTH0L:       equ    $0000027B                                ;*** B_ACQ_AHTH0L - Low power Ah counter threshold 0 low; 0x0000027B ***


;*** B_ACQ_AHC - Low power Ah counter; 0x0000027C ***
B_ACQ_AHC:          equ    $0000027C                                ;*** B_ACQ_AHC - Low power Ah counter; 0x0000027C ***


;*** B_ACQ_AHC1 - Low power Ah counter 1; 0x0000027C ***
B_ACQ_AHC1:         equ    $0000027C                                ;*** B_ACQ_AHC1 - Low power Ah counter 1; 0x0000027C ***


;*** B_ACQ_AHC1H - Low power Ah counter 1 high; 0x0000027C ***
B_ACQ_AHC1H:        equ    $0000027C                                ;*** B_ACQ_AHC1H - Low power Ah counter 1 high; 0x0000027C ***


;*** B_ACQ_AHC1L - Low power Ah counter 1 low; 0x0000027D ***
B_ACQ_AHC1L:        equ    $0000027D                                ;*** B_ACQ_AHC1L - Low power Ah counter 1 low; 0x0000027D ***


;*** B_ACQ_AHC0 - Low power Ah counter 0; 0x0000027E ***
B_ACQ_AHC0:         equ    $0000027E                                ;*** B_ACQ_AHC0 - Low power Ah counter 0; 0x0000027E ***


;*** B_ACQ_AHC0H - Low power Ah counter 0 high; 0x0000027E ***
B_ACQ_AHC0H:        equ    $0000027E                                ;*** B_ACQ_AHC0H - Low power Ah counter 0 high; 0x0000027E ***


;*** B_ACQ_AHC0L - Low power Ah counter 0 low; 0x0000027F ***
B_ACQ_AHC0L:        equ    $0000027F                                ;*** B_ACQ_AHC0L - Low power Ah counter 0 low; 0x0000027F ***


;*** B_LPF_A0 - Low Pass Filter Coefficient A0; 0x00000280 ***
B_LPF_A0:           equ    $00000280                                ;*** B_LPF_A0 - Low Pass Filter Coefficient A0; 0x00000280 ***


;*** B_LPF_A0H - Low Pass Filter Coefficient A0 high; 0x00000280 ***
B_LPF_A0H:          equ    $00000280                                ;*** B_LPF_A0H - Low Pass Filter Coefficient A0 high; 0x00000280 ***


;*** B_LPF_A0L - Low Pass Filter Coefficient A0 low; 0x00000281 ***
B_LPF_A0L:          equ    $00000281                                ;*** B_LPF_A0L - Low Pass Filter Coefficient A0 low; 0x00000281 ***


;*** B_LPF_A1 - Low Pass Filter Coefficient A1; 0x00000282 ***
B_LPF_A1:           equ    $00000282                                ;*** B_LPF_A1 - Low Pass Filter Coefficient A1; 0x00000282 ***


;*** B_LPF_A1H - Low Pass Filter Coefficient A1 high; 0x00000282 ***
B_LPF_A1H:          equ    $00000282                                ;*** B_LPF_A1H - Low Pass Filter Coefficient A1 high; 0x00000282 ***


;*** B_LPF_A1L - Low Pass Filter Coefficient A1 low; 0x00000283 ***
B_LPF_A1L:          equ    $00000283                                ;*** B_LPF_A1L - Low Pass Filter Coefficient A1 low; 0x00000283 ***


;*** B_LPF_A2 - Low Pass Filter Coefficient A2; 0x00000284 ***
B_LPF_A2:           equ    $00000284                                ;*** B_LPF_A2 - Low Pass Filter Coefficient A2; 0x00000284 ***


;*** B_LPF_A2H - Low Pass Filter Coefficient A2 high; 0x00000284 ***
B_LPF_A2H:          equ    $00000284                                ;*** B_LPF_A2H - Low Pass Filter Coefficient A2 high; 0x00000284 ***


;*** B_LPF_A2L - Low Pass Filter Coefficient A2 low; 0x00000285 ***
B_LPF_A2L:          equ    $00000285                                ;*** B_LPF_A2L - Low Pass Filter Coefficient A2 low; 0x00000285 ***


;*** B_LPF_A3 - Low Pass Filter Coefficient A3; 0x00000286 ***
B_LPF_A3:           equ    $00000286                                ;*** B_LPF_A3 - Low Pass Filter Coefficient A3; 0x00000286 ***


;*** B_LPF_A3H - Low Pass Filter Coefficient A3 high; 0x00000286 ***
B_LPF_A3H:          equ    $00000286                                ;*** B_LPF_A3H - Low Pass Filter Coefficient A3 high; 0x00000286 ***


;*** B_LPF_A3L - Low Pass Filter Coefficient A3 low; 0x00000287 ***
B_LPF_A3L:          equ    $00000287                                ;*** B_LPF_A3L - Low Pass Filter Coefficient A3 low; 0x00000287 ***


;*** B_LPF_A4 - Low Pass Filter Coefficient A4; 0x00000288 ***
B_LPF_A4:           equ    $00000288                                ;*** B_LPF_A4 - Low Pass Filter Coefficient A4; 0x00000288 ***


;*** B_LPF_A4H - Low Pass Filter Coefficient A4 high; 0x00000288 ***
B_LPF_A4H:          equ    $00000288                                ;*** B_LPF_A4H - Low Pass Filter Coefficient A4 high; 0x00000288 ***


;*** B_LPF_A4L - Low Pass Filter Coefficient A4 low; 0x00000289 ***
B_LPF_A4L:          equ    $00000289                                ;*** B_LPF_A4L - Low Pass Filter Coefficient A4 low; 0x00000289 ***


;*** B_LPF_A5 - Low Pass Filter Coefficient A5; 0x0000028A ***
B_LPF_A5:           equ    $0000028A                                ;*** B_LPF_A5 - Low Pass Filter Coefficient A5; 0x0000028A ***


;*** B_LPF_A5H - Low Pass Filter Coefficient A5 high; 0x0000028A ***
B_LPF_A5H:          equ    $0000028A                                ;*** B_LPF_A5H - Low Pass Filter Coefficient A5 high; 0x0000028A ***


;*** B_LPF_A5L - Low Pass Filter Coefficient A5 low; 0x0000028B ***
B_LPF_A5L:          equ    $0000028B                                ;*** B_LPF_A5L - Low Pass Filter Coefficient A5 low; 0x0000028B ***


;*** B_LPF_A6 - Low Pass Filter Coefficient A6; 0x0000028C ***
B_LPF_A6:           equ    $0000028C                                ;*** B_LPF_A6 - Low Pass Filter Coefficient A6; 0x0000028C ***


;*** B_LPF_A6H - Low Pass Filter Coefficient A6 high; 0x0000028C ***
B_LPF_A6H:          equ    $0000028C                                ;*** B_LPF_A6H - Low Pass Filter Coefficient A6 high; 0x0000028C ***


;*** B_LPF_A6L - Low Pass Filter Coefficient A6 low; 0x0000028D ***
B_LPF_A6L:          equ    $0000028D                                ;*** B_LPF_A6L - Low Pass Filter Coefficient A6 low; 0x0000028D ***


;*** B_LPF_A7 - Low Pass Filter Coefficient A7; 0x0000028E ***
B_LPF_A7:           equ    $0000028E                                ;*** B_LPF_A7 - Low Pass Filter Coefficient A7; 0x0000028E ***


;*** B_LPF_A7H - Low Pass Filter Coefficient A7 high; 0x0000028E ***
B_LPF_A7H:          equ    $0000028E                                ;*** B_LPF_A7H - Low Pass Filter Coefficient A7 high; 0x0000028E ***


;*** B_LPF_A7L - Low Pass Filter Coefficient A7 low; 0x0000028F ***
B_LPF_A7L:          equ    $0000028F                                ;*** B_LPF_A7L - Low Pass Filter Coefficient A7 low; 0x0000028F ***


;*** B_LPF_A8 - Low Pass Filter Coefficient A8; 0x00000290 ***
B_LPF_A8:           equ    $00000290                                ;*** B_LPF_A8 - Low Pass Filter Coefficient A8; 0x00000290 ***


;*** B_LPF_A8H - Low Pass Filter Coefficient A8 high; 0x00000290 ***
B_LPF_A8H:          equ    $00000290                                ;*** B_LPF_A8H - Low Pass Filter Coefficient A8 high; 0x00000290 ***


;*** B_LPF_A8L - Low Pass Filter Coefficient A8 low; 0x00000291 ***
B_LPF_A8L:          equ    $00000291                                ;*** B_LPF_A8L - Low Pass Filter Coefficient A8 low; 0x00000291 ***


;*** B_LPF_A9 - Low Pass Filter Coefficient A9; 0x00000292 ***
B_LPF_A9:           equ    $00000292                                ;*** B_LPF_A9 - Low Pass Filter Coefficient A9; 0x00000292 ***


;*** B_LPF_A9H - Low Pass Filter Coefficient A9 high; 0x00000292 ***
B_LPF_A9H:          equ    $00000292                                ;*** B_LPF_A9H - Low Pass Filter Coefficient A9 high; 0x00000292 ***


;*** B_LPF_A9L - Low Pass Filter Coefficient A9 low; 0x00000293 ***
B_LPF_A9L:          equ    $00000293                                ;*** B_LPF_A9L - Low Pass Filter Coefficient A9 low; 0x00000293 ***


;*** B_LPF_A10 - Low Pass Filter Coefficient A10; 0x00000294 ***
B_LPF_A10:          equ    $00000294                                ;*** B_LPF_A10 - Low Pass Filter Coefficient A10; 0x00000294 ***


;*** B_LPF_A10H - Low Pass Filter Coefficient A10 high; 0x00000294 ***
B_LPF_A10H:         equ    $00000294                                ;*** B_LPF_A10H - Low Pass Filter Coefficient A10 high; 0x00000294 ***


;*** B_LPF_A10L - Low Pass Filter Coefficient A10 low; 0x00000295 ***
B_LPF_A10L:         equ    $00000295                                ;*** B_LPF_A10L - Low Pass Filter Coefficient A10 low; 0x00000295 ***


;*** B_LPF_A11 - Low Pass Filter Coefficient A11; 0x00000296 ***
B_LPF_A11:          equ    $00000296                                ;*** B_LPF_A11 - Low Pass Filter Coefficient A11; 0x00000296 ***


;*** B_LPF_A11H - Low Pass Filter Coefficient A11 high; 0x00000296 ***
B_LPF_A11H:         equ    $00000296                                ;*** B_LPF_A11H - Low Pass Filter Coefficient A11 high; 0x00000296 ***


;*** B_LPF_A11L - Low Pass Filter Coefficient A11 low; 0x00000297 ***
B_LPF_A11L:         equ    $00000297                                ;*** B_LPF_A11L - Low Pass Filter Coefficient A11 low; 0x00000297 ***


;*** B_LPF_A12 - Low Pass Filter Coefficient A12; 0x00000298 ***
B_LPF_A12:          equ    $00000298                                ;*** B_LPF_A12 - Low Pass Filter Coefficient A12; 0x00000298 ***


;*** B_LPF_A12H - Low Pass Filter Coefficient A12 high; 0x00000298 ***
B_LPF_A12H:         equ    $00000298                                ;*** B_LPF_A12H - Low Pass Filter Coefficient A12 high; 0x00000298 ***


;*** B_LPF_A12L - Low Pass Filter Coefficient A12 low; 0x00000299 ***
B_LPF_A12L:         equ    $00000299                                ;*** B_LPF_A12L - Low Pass Filter Coefficient A12 low; 0x00000299 ***


;*** B_LPF_A13 - Low Pass Filter Coefficient A13; 0x0000029A ***
B_LPF_A13:          equ    $0000029A                                ;*** B_LPF_A13 - Low Pass Filter Coefficient A13; 0x0000029A ***


;*** B_LPF_A13H - Low Pass Filter Coefficient A13 high; 0x0000029A ***
B_LPF_A13H:         equ    $0000029A                                ;*** B_LPF_A13H - Low Pass Filter Coefficient A13 high; 0x0000029A ***


;*** B_LPF_A13L - Low Pass Filter Coefficient A13 low; 0x0000029B ***
B_LPF_A13L:         equ    $0000029B                                ;*** B_LPF_A13L - Low Pass Filter Coefficient A13 low; 0x0000029B ***


;*** B_LPF_A14 - Low Pass Filter Coefficient A14; 0x0000029C ***
B_LPF_A14:          equ    $0000029C                                ;*** B_LPF_A14 - Low Pass Filter Coefficient A14; 0x0000029C ***


;*** B_LPF_A14H - Low Pass Filter Coefficient A14 high; 0x0000029C ***
B_LPF_A14H:         equ    $0000029C                                ;*** B_LPF_A14H - Low Pass Filter Coefficient A14 high; 0x0000029C ***


;*** B_LPF_A14L - Low Pass Filter Coefficient A14 low; 0x0000029D ***
B_LPF_A14L:         equ    $0000029D                                ;*** B_LPF_A14L - Low Pass Filter Coefficient A14 low; 0x0000029D ***


;*** B_LPF_A15 - Low Pass Filter Coefficient A15; 0x0000029E ***
B_LPF_A15:          equ    $0000029E                                ;*** B_LPF_A15 - Low Pass Filter Coefficient A15; 0x0000029E ***


;*** B_LPF_A15H - Low Pass Filter Coefficient A15 high; 0x0000029E ***
B_LPF_A15H:         equ    $0000029E                                ;*** B_LPF_A15H - Low Pass Filter Coefficient A15 high; 0x0000029E ***


;*** B_LPF_A15L - Low Pass Filter Coefficient A15 low; 0x0000029F ***
B_LPF_A15L:         equ    $0000029F                                ;*** B_LPF_A15L - Low Pass Filter Coefficient A15 low; 0x0000029F ***


;*** B_COMP_CTL - Compensation control register; 0x000002A0 ***
B_COMP_CTL:         equ    $000002A0                                ;*** B_COMP_CTL - Compensation control register; 0x000002A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_CTL_CALIE:   equ    0                                         ; Calibration IRQ Enable
B_COMP_CTL_DIAGI:   equ    2                                         ; Diagnostic Mode Current Channel
B_COMP_CTL_DIAGV:   equ    3                                         ; Diagnostic Mode Voltage Channel
B_COMP_CTL_PGAO:    equ    4                                         ; PGA Offset Calibration Start
B_COMP_CTL_PGAZ:    equ    5                                         ; PGA Input Zero
B_COMP_CTL_BGCAL:   equ    6                                         ; Calibration Band Gap Select
B_COMP_CTL_CALIEM:  equ    8                                         ; Calibration IRQ Enable - Mask
B_COMP_CTL_DIAGIM:  equ    10                                        ; Diagnostic Mode Current Channel - Mask
B_COMP_CTL_DIAGVM:  equ    11                                        ; Diagnostic Mode Voltage Channel - Mask
B_COMP_CTL_PGAOM:   equ    12                                        ; PGA Offset Calibration - Mask
B_COMP_CTL_PGAZM:   equ    13                                        ; PGA Input Zero - Mask
B_COMP_CTL_BGCALM:  equ    14                                        ; Calibration Band Gap Select - Mask
; bit position masks
mB_COMP_CTL_CALIE:  equ    %00000001
mB_COMP_CTL_DIAGI:  equ    %00000100
mB_COMP_CTL_DIAGV:  equ    %00001000
mB_COMP_CTL_PGAO:   equ    %00010000
mB_COMP_CTL_PGAZ:   equ    %00100000
mB_COMP_CTL_BGCAL:  equ    %11000000
mB_COMP_CTL_CALIEM: equ    %100000000
mB_COMP_CTL_DIAGIM: equ    %10000000000
mB_COMP_CTL_DIAGVM: equ    %100000000000
mB_COMP_CTL_PGAOM:  equ    %1000000000000
mB_COMP_CTL_PGAZM:  equ    %10000000000000
mB_COMP_CTL_BGCALM: equ    %1100000000000000


;*** B_COMP_SR - Compensation status register; 0x000002A2 ***
B_COMP_SR:          equ    $000002A2                                ;*** B_COMP_SR - Compensation status register; 0x000002A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_SR_CALF:     equ    0                                         ; Calibration Request Status Flag
B_COMP_SR_PGAOF:    equ    4                                         ; PGA Internal Offset Compensation Complete Flag
B_COMP_SR_BGFR:     equ    6                                         ; Band Gap Reference Status Flag
; bit position masks
mB_COMP_SR_CALF:    equ    %00000001
mB_COMP_SR_PGAOF:   equ    %00010000
mB_COMP_SR_BGFR:    equ    %01000000


;*** B_COMP_TF - Temperature filtering period; 0x000002A3 ***
B_COMP_TF:          equ    $000002A3                                ;*** B_COMP_TF - Temperature filtering period; 0x000002A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_TF_TMF:      equ    0                                         ; Recalibration Temperature Filtering Period
; bit position masks
mB_COMP_TF_TMF:     equ    %00000111


;*** B_COMP_TMAX - Max temp before recalibration; 0x000002A4 ***
B_COMP_TMAX:        equ    $000002A4                                ;*** B_COMP_TMAX - Max temp before recalibration; 0x000002A4 ***


;*** B_COMP_TMIN - Min temp before recalibration; 0x000002A6 ***
B_COMP_TMIN:        equ    $000002A6                                ;*** B_COMP_TMIN - Min temp before recalibration; 0x000002A6 ***


;*** B_COMP_VO - Offset voltage compensation; 0x000002AA ***
B_COMP_VO:          equ    $000002AA                                ;*** B_COMP_VO - Offset voltage compensation; 0x000002AA ***


;*** B_COMP_IO - Offset current compensation window; 0x000002AB ***
B_COMP_IO:          equ    $000002AB                                ;*** B_COMP_IO - Offset current compensation window; 0x000002AB ***


;*** B_COMP_VSG - Gain voltage compensation vsense channel; 0x000002AC ***
B_COMP_VSG:         equ    $000002AC                                ;*** B_COMP_VSG - Gain voltage compensation vsense channel; 0x000002AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_VSG_VSGC:    equ    0                                         ; Voltage Channel Gain Compensation Buffer
; bit position masks
mB_COMP_VSG_VSGC:   equ    %1111111111


;*** B_COMP_IG4 - Gain Current Compensation 4; 0x000002B0 ***
B_COMP_IG4:         equ    $000002B0                                ;*** B_COMP_IG4 - Gain Current Compensation 4; 0x000002B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_IG4_IGC4:    equ    0                                         ; Current Gain Compensation Buffer 4
; bit position masks
mB_COMP_IG4_IGC4:   equ    %1111111111


;*** B_COMP_IG8 - Gain Current Compensation 8; 0x000002B2 ***
B_COMP_IG8:         equ    $000002B2                                ;*** B_COMP_IG8 - Gain Current Compensation 8; 0x000002B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_IG8_IGC8:    equ    0                                         ; Current Gain Compensation Buffer 8
; bit position masks
mB_COMP_IG8_IGC8:   equ    %1111111111


;*** B_COMP_IG16 - Gain Current Compensation 16; 0x000002B4 ***
B_COMP_IG16:        equ    $000002B4                                ;*** B_COMP_IG16 - Gain Current Compensation 16; 0x000002B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_IG16_IGC16:  equ    0                                         ; Current Gain Compensation Buffer 16
; bit position masks
mB_COMP_IG16_IGC16: equ    %1111111111


;*** B_COMP_IG32 - Gain Current Compensation 32; 0x000002B6 ***
B_COMP_IG32:        equ    $000002B6                                ;*** B_COMP_IG32 - Gain Current Compensation 32; 0x000002B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_IG32_IGC32:  equ    0                                         ; Current Gain Compensation Buffer 32
; bit position masks
mB_COMP_IG32_IGC32: equ    %1111111111


;*** B_COMP_IG64 - Gain Current Compensation 64; 0x000002B8 ***
B_COMP_IG64:        equ    $000002B8                                ;*** B_COMP_IG64 - Gain Current Compensation 64; 0x000002B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_IG64_IGC64:  equ    0                                         ; Current Gain Compensation Buffer 64
; bit position masks
mB_COMP_IG64_IGC64: equ    %1111111111


;*** B_COMP_IG128 - Gain Current Compensation 128; 0x000002BA ***
B_COMP_IG128:       equ    $000002BA                                ;*** B_COMP_IG128 - Gain Current Compensation 128; 0x000002BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_IG128_IGC128: equ    0                                        ; Current Gain Compensation Buffer 128
; bit position masks
mB_COMP_IG128_IGC128: equ    %1111111111


;*** B_COMP_IG256 - Gain Current Compensation 256; 0x000002BC ***
B_COMP_IG256:       equ    $000002BC                                ;*** B_COMP_IG256 - Gain Current Compensation 256; 0x000002BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_IG256_IGC256: equ    0                                        ; Current Gain Compensation Buffer 256
; bit position masks
mB_COMP_IG256_IGC256: equ    %1111111111


;*** B_COMP_IG512 - Gain Current Compensation 512; 0x000002BE ***
B_COMP_IG512:       equ    $000002BE                                ;*** B_COMP_IG512 - Gain Current Compensation 512; 0x000002BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_IG512_IGC512: equ    0                                        ; Current Gain Compensation Buffer 512
; bit position masks
mB_COMP_IG512_IGC512: equ    %1111111111


;*** B_COMP_PGAO4 - Offset PGA compensation 4; 0x000002C0 ***
B_COMP_PGAO4:       equ    $000002C0                                ;*** B_COMP_PGAO4 - Offset PGA compensation 4; 0x000002C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_PGAO4_PGAOC4: equ    0                                        ; PGA Offset Compensation Buffer 4
; bit position masks
mB_COMP_PGAO4_PGAOC4: equ    %11111111111


;*** B_COMP_PGAO8 - Offset PGA compensation 8; 0x000002C2 ***
B_COMP_PGAO8:       equ    $000002C2                                ;*** B_COMP_PGAO8 - Offset PGA compensation 8; 0x000002C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_PGAO8_PGAOC8: equ    0                                        ; PGA Offset Compensation Buffer 8
; bit position masks
mB_COMP_PGAO8_PGAOC8: equ    %11111111111


;*** B_COMP_PGAO16 - Offset PGA compensation 16; 0x000002C4 ***
B_COMP_PGAO16:      equ    $000002C4                                ;*** B_COMP_PGAO16 - Offset PGA compensation 16; 0x000002C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_PGAO16_PGAOC16: equ    0                                      ; PGA Offset Compensation Buffer 16
; bit position masks
mB_COMP_PGAO16_PGAOC16: equ    %11111111111


;*** B_COMP_PGAO32 - Offset PGA compensation 32; 0x000002C6 ***
B_COMP_PGAO32:      equ    $000002C6                                ;*** B_COMP_PGAO32 - Offset PGA compensation 32; 0x000002C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_PGAO32_PGAOC32: equ    0                                      ; PGA Offset Compensation Buffer 32
; bit position masks
mB_COMP_PGAO32_PGAOC32: equ    %11111111111


;*** B_COMP_PGAO64 - Offset PGA compensation 64; 0x000002C8 ***
B_COMP_PGAO64:      equ    $000002C8                                ;*** B_COMP_PGAO64 - Offset PGA compensation 64; 0x000002C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_PGAO64_PGAOC64: equ    0                                      ; PGA Offset Compensation Buffer 64
; bit position masks
mB_COMP_PGAO64_PGAOC64: equ    %11111111111


;*** B_COMP_PGAO128 - Offset PGA compensation 128; 0x000002CA ***
B_COMP_PGAO128:     equ    $000002CA                                ;*** B_COMP_PGAO128 - Offset PGA compensation 128; 0x000002CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_PGAO128_PGAOC128: equ    0                                    ; PGA Offset Compensation Buffer 128
; bit position masks
mB_COMP_PGAO128_PGAOC128: equ    %11111111111


;*** B_COMP_PGAO256 - Offset PGA compensation 256; 0x000002CC ***
B_COMP_PGAO256:     equ    $000002CC                                ;*** B_COMP_PGAO256 - Offset PGA compensation 256; 0x000002CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_PGAO256_PGAOC256: equ    0                                    ; PGA Offset Compensation Buffer 256
; bit position masks
mB_COMP_PGAO256_PGAOC256: equ    %11111111111


;*** B_COMP_PGAO512 - Offset PGA compensation 512; 0x000002CE ***
B_COMP_PGAO512:     equ    $000002CE                                ;*** B_COMP_PGAO512 - Offset PGA compensation 512; 0x000002CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_COMP_PGAO512_PGAOC512: equ    0                                    ; PGA Offset Compensation Buffer 512
; bit position masks
mB_COMP_PGAO512_PGAOC512: equ    %11111111111


;*** B_COMP_ITO - Internal temperature offset compensation; 0x000002D0 ***
B_COMP_ITO:         equ    $000002D0                                ;*** B_COMP_ITO - Internal temperature offset compensation; 0x000002D0 ***


;*** B_COMP_ITG - Internal temperature gain compensation; 0x000002D1 ***
B_COMP_ITG:         equ    $000002D1                                ;*** B_COMP_ITG - Internal temperature gain compensation; 0x000002D1 ***


;*** B_COMP_ETO - External temperature offset compensation; 0x000002D2 ***
B_COMP_ETO:         equ    $000002D2                                ;*** B_COMP_ETO - External temperature offset compensation; 0x000002D2 ***


;*** B_COMP_ETG - External temperature gain compensation; 0x000002D3 ***
B_COMP_ETG:         equ    $000002D3                                ;*** B_COMP_ETG - External temperature gain compensation; 0x000002D3 ***


;*** B_TRIM_BG0 - Trim bandgap 0; 0x000002E0 ***
B_TRIM_BG0:         equ    $000002E0                                ;*** B_TRIM_BG0 - Trim bandgap 0; 0x000002E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG0_IBG1:    equ    0             
B_TRIM_BG0_IBG2:    equ    3             
B_TRIM_BG0_TCIBG1:  equ    8             
B_TRIM_BG0_TCIBG2:  equ    11             
; bit position masks
mB_TRIM_BG0_IBG1:   equ    %00000111
mB_TRIM_BG0_IBG2:   equ    %00111000
mB_TRIM_BG0_TCIBG1: equ    %11100000000
mB_TRIM_BG0_TCIBG2: equ    %11100000000000


;*** B_TRIM_BG0H - Trim bandgap 0 high; 0x000002E0 ***
B_TRIM_BG0H:        equ    $000002E0                                ;*** B_TRIM_BG0H - Trim bandgap 0 high; 0x000002E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG0H_TCIBG1: equ    0             
B_TRIM_BG0H_TCIBG2: equ    3             
; bit position masks
mB_TRIM_BG0H_TCIBG1: equ    %00000111
mB_TRIM_BG0H_TCIBG2: equ    %00111000


;*** B_TRIM_BG0L - Trim bandgap 0 low; 0x000002E1 ***
B_TRIM_BG0L:        equ    $000002E1                                ;*** B_TRIM_BG0L - Trim bandgap 0 low; 0x000002E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG0L_IBG1:   equ    0             
B_TRIM_BG0L_IBG2:   equ    3             
; bit position masks
mB_TRIM_BG0L_IBG1:  equ    %00000111
mB_TRIM_BG0L_IBG2:  equ    %00111000


;*** B_TRIM_BG1 - Trim bandgap 1; 0x000002E2 ***
B_TRIM_BG1:         equ    $000002E2                                ;*** B_TRIM_BG1 - Trim bandgap 1; 0x000002E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG1_SLPBG:   equ    0             
B_TRIM_BG1_TCBG1:   equ    8             
B_TRIM_BG1_TCBG2:   equ    11             
B_TRIM_BG1_DBG3:    equ    14             
B_TRIM_BG1_UBG3:    equ    15             
; bit position masks
mB_TRIM_BG1_SLPBG:  equ    %00000111
mB_TRIM_BG1_TCBG1:  equ    %11100000000
mB_TRIM_BG1_TCBG2:  equ    %11100000000000
mB_TRIM_BG1_DBG3:   equ    %100000000000000
mB_TRIM_BG1_UBG3:   equ    %1000000000000000


;*** B_TRIM_BG1H - Trim bandgap 1 high; 0x000002E2 ***
B_TRIM_BG1H:        equ    $000002E2                                ;*** B_TRIM_BG1H - Trim bandgap 1 high; 0x000002E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG1H_TCBG1:  equ    0             
B_TRIM_BG1H_TCBG2:  equ    3             
B_TRIM_BG1H_DBG3:   equ    6             
B_TRIM_BG1H_UBG3:   equ    7             
; bit position masks
mB_TRIM_BG1H_TCBG1: equ    %00000111
mB_TRIM_BG1H_TCBG2: equ    %00111000
mB_TRIM_BG1H_DBG3:  equ    %01000000
mB_TRIM_BG1H_UBG3:  equ    %10000000


;*** B_TRIM_BG1L - Trim bandgap 1 low; 0x000002E3 ***
B_TRIM_BG1L:        equ    $000002E3                                ;*** B_TRIM_BG1L - Trim bandgap 1 low; 0x000002E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG1L_SLPBG:  equ    0             
; bit position masks
mB_TRIM_BG1L_SLPBG: equ    %00000111


;*** B_TRIM_BG2 - Trim bandgap 2; 0x000002E4 ***
B_TRIM_BG2:         equ    $000002E4                                ;*** B_TRIM_BG2 - Trim bandgap 2; 0x000002E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG2_V2P5BG1: equ    0             
B_TRIM_BG2_V2P5BG2: equ    4             
B_TRIM_BG2_V1P2BG1: equ    8             
B_TRIM_BG2_V1P2BG2: equ    12             
; bit position masks
mB_TRIM_BG2_V2P5BG1: equ    %00001111
mB_TRIM_BG2_V2P5BG2: equ    %11110000
mB_TRIM_BG2_V1P2BG1: equ    %111100000000
mB_TRIM_BG2_V1P2BG2: equ    %1111000000000000


;*** B_TRIM_BG2H - Trim bandgap 2 high; 0x000002E4 ***
B_TRIM_BG2H:        equ    $000002E4                                ;*** B_TRIM_BG2H - Trim bandgap 2 high; 0x000002E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG2H_V1P2BG1: equ    0             
B_TRIM_BG2H_V1P2BG2: equ    4             
; bit position masks
mB_TRIM_BG2H_V1P2BG1: equ    %00001111
mB_TRIM_BG2H_V1P2BG2: equ    %11110000


;*** B_TRIM_BG2L - Trim bandgap 2 low; 0x000002E5 ***
B_TRIM_BG2L:        equ    $000002E5                                ;*** B_TRIM_BG2L - Trim bandgap 2 low; 0x000002E5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_BG2L_V2P5BG1: equ    0             
B_TRIM_BG2L_V2P5BG2: equ    4             
; bit position masks
mB_TRIM_BG2L_V2P5BG1: equ    %00001111
mB_TRIM_BG2L_V2P5BG2: equ    %11110000


;*** B_TRIM_LIN - Trim lin; 0x000002E6 ***
B_TRIM_LIN:         equ    $000002E6                                ;*** B_TRIM_LIN - Trim lin; 0x000002E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_LIN_LIN:     equ    0             
; bit position masks
mB_TRIM_LIN_LIN:    equ    %00000001


;*** B_TRIM_LVT - Trim low voltage threshold; 0x000002E7 ***
B_TRIM_LVT:         equ    $000002E7                                ;*** B_TRIM_LVT - Trim low voltage threshold; 0x000002E7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_LVT_LVT:     equ    0             
; bit position masks
mB_TRIM_LVT_LVT:    equ    %00000001


;*** B_TRIM_OSC - Trim LP oscillator; 0x000002E8 ***
B_TRIM_OSC:         equ    $000002E8                                ;*** B_TRIM_OSC - Trim LP oscillator; 0x000002E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_OSC_LPOSC:   equ    0             
; bit position masks
mB_TRIM_OSC_LPOSC:  equ    %1111111111111


;*** B_TRIM_OSCH - Trim LP oscillator high; 0x000002E8 ***
B_TRIM_OSCH:        equ    $000002E8                                ;*** B_TRIM_OSCH - Trim LP oscillator high; 0x000002E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TRIM_OSCH_LPOSC:  equ    0             
; bit position masks
mB_TRIM_OSCH_LPOSC: equ    %00011111


;*** B_TRIM_OSCL - Trim LP oscillator low; 0x000002E9 ***
B_TRIM_OSCL:        equ    $000002E9                                ;*** B_TRIM_OSCL - Trim LP oscillator low; 0x000002E9 ***


;*** NB_PCR_CTL - PCR Control Register; 0x00000300 ***
NB_PCR_CTL:         equ    $00000300                                ;*** NB_PCR_CTL - PCR Control Register; 0x00000300 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PCR_CTL_OPM:     equ    0                                         ; Operation mode select 0
NB_PCR_CTL_PF:      equ    2                                         ; 1 ms Prescaler 0
NB_PCR_CTL_HWR:     equ    5                                         ; Hardware Reset
NB_PCR_CTL_UVIE:    equ    6                                         ; Low Supply Voltage Interrupt enable
NB_PCR_CTL_HTIE:    equ    7                                         ; High Temperature Interrupt enable
NB_PCR_CTL_OPMM:    equ    8                                         ; Operation mode mask 0
NB_PCR_CTL_PFM:     equ    10                                        ; Prescalar factor mask 0
NB_PCR_CTL_HWRM:    equ    13                                        ; Hardware reset mask
NB_PCR_CTL_UVIEM:   equ    14                                        ; Supply Under Voltage interrupt enable mask
NB_PCR_CTL_HTIEM:   equ    15                                        ; High temperature interrupt enable mask
; bit position masks
mNB_PCR_CTL_OPM:    equ    %00000011
mNB_PCR_CTL_PF:     equ    %00001100
mNB_PCR_CTL_HWR:    equ    %00100000
mNB_PCR_CTL_UVIE:   equ    %01000000
mNB_PCR_CTL_HTIE:   equ    %10000000
mNB_PCR_CTL_OPMM:   equ    %1100000000
mNB_PCR_CTL_PFM:    equ    %110000000000
mNB_PCR_CTL_HWRM:   equ    %10000000000000
mNB_PCR_CTL_UVIEM:  equ    %100000000000000
mNB_PCR_CTL_HTIEM:  equ    %1000000000000000


;*** NB_PCR_SR - PCR Status Register; 0x00000302 ***
NB_PCR_SR:          equ    $00000302                                ;*** NB_PCR_SR - PCR Status Register; 0x00000302 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PCR_SR_WUPTB0F:  equ    0                                         ; Wake-up on GPIO 0 event flag
NB_PCR_SR_WUPTB1F:  equ    1                                         ; Wake-up on GPIO 1 event flag
NB_PCR_SR_WUPTB2F:  equ    2                                         ; Wake-up on GPIO 2 event flag
NB_PCR_SR_WUPTB3F:  equ    3                                         ; Wake-up on GPIO 3 event flag
NB_PCR_SR_WULINF:   equ    4                                         ; Wake-up on LIN flag
NB_PCR_SR_WUCALF:   equ    5                                         ; Wake-up on calibration request flag
NB_PCR_SR_WUCTHF:   equ    6                                         ; Wake-up on current threshold Flag
NB_PCR_SR_WUAHTHF:  equ    7                                         ; Wake-up on Ah counter threshold Flag
NB_PCR_SR_WLPMF:    equ    8                                         ; Wake-up after Low Power Mode Flag
NB_PCR_SR_WULTCF:   equ    9                                         ; Life Time Counter Wake Up Flag
NB_PCR_SR_LVRF:     equ    10                                        ; VDDL Low Voltage (POR) Reset Flag
NB_PCR_SR_HVRF:     equ    11                                        ; VDDH Low Voltage Reset Flag
NB_PCR_SR_WDRF:     equ    12                                        ; Watchdog Reset Flag
NB_PCR_SR_HWRF:     equ    13                                        ; Hardware Reset Flag
NB_PCR_SR_UVF:      equ    14                                        ; Supply Undervoltage Condition Flag
NB_PCR_SR_HTF:      equ    15                                        ; High Temperature Condition Flag
; bit position masks
mNB_PCR_SR_WUPTB0F: equ    %00000001
mNB_PCR_SR_WUPTB1F: equ    %00000010
mNB_PCR_SR_WUPTB2F: equ    %00000100
mNB_PCR_SR_WUPTB3F: equ    %00001000
mNB_PCR_SR_WULINF:  equ    %00010000
mNB_PCR_SR_WUCALF:  equ    %00100000
mNB_PCR_SR_WUCTHF:  equ    %01000000
mNB_PCR_SR_WUAHTHF: equ    %10000000
mNB_PCR_SR_WLPMF:   equ    %100000000
mNB_PCR_SR_WULTCF:  equ    %1000000000
mNB_PCR_SR_LVRF:    equ    %10000000000
mNB_PCR_SR_HVRF:    equ    %100000000000
mNB_PCR_SR_WDRF:    equ    %1000000000000
mNB_PCR_SR_HWRF:    equ    %10000000000000
mNB_PCR_SR_UVF:     equ    %100000000000000
mNB_PCR_SR_HTF:     equ    %1000000000000000


;*** NB_PCR_SRH - PCR Status Register High; 0x00000302 ***
NB_PCR_SRH:         equ    $00000302                                ;*** NB_PCR_SRH - PCR Status Register High; 0x00000302 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PCR_SRH_WLPMF:   equ    0                                         ; Wake-up after Low Power Mode Flag
NB_PCR_SRH_WULTCF:  equ    1                                         ; Life Time Counter Wake Up Flag
NB_PCR_SRH_LVRF:    equ    2                                         ; VDDL Low Voltage (POR) Reset Flag
NB_PCR_SRH_HVRF:    equ    3                                         ; VDDH Low Voltage Reset Flag
NB_PCR_SRH_WDRF:    equ    4                                         ; Watchdog Reset Flag
NB_PCR_SRH_HWRF:    equ    5                                         ; Hardware Reset Flag
NB_PCR_SRH_UVF:     equ    6                                         ; Supply Undervoltage Condition Flag
NB_PCR_SRH_HTF:     equ    7                                         ; High Temperature Condition Flag
; bit position masks
mNB_PCR_SRH_WLPMF:  equ    %00000001
mNB_PCR_SRH_WULTCF: equ    %00000010
mNB_PCR_SRH_LVRF:   equ    %00000100
mNB_PCR_SRH_HVRF:   equ    %00001000
mNB_PCR_SRH_WDRF:   equ    %00010000
mNB_PCR_SRH_HWRF:   equ    %00100000
mNB_PCR_SRH_UVF:    equ    %01000000
mNB_PCR_SRH_HTF:    equ    %10000000


;*** NB_PCR_SRL - PCR Status Register Low; 0x00000303 ***
NB_PCR_SRL:         equ    $00000303                                ;*** NB_PCR_SRL - PCR Status Register Low; 0x00000303 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PCR_SRL_WUPTB0F: equ    0                                         ; Wake-up on GPIO 0 event flag
NB_PCR_SRL_WUPTB1F: equ    1                                         ; Wake-up on GPIO 1 event flag
NB_PCR_SRL_WUPTB2F: equ    2                                         ; Wake-up on GPIO 2 event flag
NB_PCR_SRL_WUPTB3F: equ    3                                         ; Wake-up on GPIO 3 event flag
NB_PCR_SRL_WULINF:  equ    4                                         ; Wake-up on LIN flag
NB_PCR_SRL_WUCALF:  equ    5                                         ; Wake-up on calibration request flag
NB_PCR_SRL_WUCTHF:  equ    6                                         ; Wake-up on current threshold Flag
NB_PCR_SRL_WUAHTHF: equ    7                                         ; Wake-up on Ah counter threshold Flag
; bit position masks
mNB_PCR_SRL_WUPTB0F: equ    %00000001
mNB_PCR_SRL_WUPTB1F: equ    %00000010
mNB_PCR_SRL_WUPTB2F: equ    %00000100
mNB_PCR_SRL_WUPTB3F: equ    %00001000
mNB_PCR_SRL_WULINF: equ    %00010000
mNB_PCR_SRL_WUCALF: equ    %00100000
mNB_PCR_SRL_WUCTHF: equ    %01000000
mNB_PCR_SRL_WUAHTHF: equ    %10000000


;*** NB_PCR_PRESC - PCR 1ms prescaler; 0x00000304 ***
NB_PCR_PRESC:       equ    $00000304                                ;*** NB_PCR_PRESC - PCR 1ms prescaler; 0x00000304 ***


;*** NB_PCR_WUE - Wake Up Enable Register; 0x00000306 ***
NB_PCR_WUE:         equ    $00000306                                ;*** NB_PCR_WUE - Wake Up Enable Register; 0x00000306 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PCR_WUE_WULTC:   equ    7                                         ; Wake-up on Life Timer Counter Overflow
NB_PCR_WUE_WUPTB0:  equ    8                                         ; Wake-up on GPIO 0 event
NB_PCR_WUE_WUPTB1:  equ    9                                         ; Wake-up on GPIO 1 event
NB_PCR_WUE_WUPTB2:  equ    10                                        ; Wake-up on GPIO 2 event
NB_PCR_WUE_WUPTB3:  equ    11                                        ; Wake-up on GPIO 3 event
NB_PCR_WUE_WULIN:   equ    12                                        ; Wake-up on LIN
NB_PCR_WUE_WUCAL:   equ    13                                        ; Wake-up on calibration request
NB_PCR_WUE_WUCTH:   equ    14                                        ; Wake-up on current threshold
NB_PCR_WUE_WUAHTH:  equ    15                                        ; Wake-up on Ah counter
; bit position masks
mNB_PCR_WUE_WULTC:  equ    %10000000
mNB_PCR_WUE_WUPTB0: equ    %100000000
mNB_PCR_WUE_WUPTB1: equ    %1000000000
mNB_PCR_WUE_WUPTB2: equ    %10000000000
mNB_PCR_WUE_WUPTB3: equ    %100000000000
mNB_PCR_WUE_WULIN:  equ    %1000000000000
mNB_PCR_WUE_WUCAL:  equ    %10000000000000
mNB_PCR_WUE_WUCTH:  equ    %100000000000000
mNB_PCR_WUE_WUAHTH: equ    %1000000000000000


;*** NB_PCR_WUEH - Wake Up Enable Register High; 0x00000306 ***
NB_PCR_WUEH:        equ    $00000306                                ;*** NB_PCR_WUEH - Wake Up Enable Register High; 0x00000306 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PCR_WUEH_WUPTB0: equ    0                                         ; Wake-up on GPIO 0 event
NB_PCR_WUEH_WUPTB1: equ    1                                         ; Wake-up on GPIO 1 event
NB_PCR_WUEH_WUPTB2: equ    2                                         ; Wake-up on GPIO 2 event
NB_PCR_WUEH_WUPTB3: equ    3                                         ; Wake-up on GPIO 3 event
NB_PCR_WUEH_WULIN:  equ    4                                         ; Wake-up on LIN
NB_PCR_WUEH_WUCAL:  equ    5                                         ; Wake-up on calibration request
NB_PCR_WUEH_WUCTH:  equ    6                                         ; Wake-up on current threshold
NB_PCR_WUEH_WUAHTH: equ    7                                         ; Wake-up on Ah counter
; bit position masks
mNB_PCR_WUEH_WUPTB0: equ    %00000001
mNB_PCR_WUEH_WUPTB1: equ    %00000010
mNB_PCR_WUEH_WUPTB2: equ    %00000100
mNB_PCR_WUEH_WUPTB3: equ    %00001000
mNB_PCR_WUEH_WULIN: equ    %00010000
mNB_PCR_WUEH_WUCAL: equ    %00100000
mNB_PCR_WUEH_WUCTH: equ    %01000000
mNB_PCR_WUEH_WUAHTH: equ    %10000000


;*** NB_PCR_WUEL - Wake Up Enable Register Low; 0x00000307 ***
NB_PCR_WUEL:        equ    $00000307                                ;*** NB_PCR_WUEL - Wake Up Enable Register Low; 0x00000307 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PCR_WUEL_WULTC:  equ    7                                         ; Wake-up on Life Timer Counter Overflow
; bit position masks
mNB_PCR_WUEL_WULTC: equ    %10000000


;*** NB_INT_SRC - Interrupt source register; 0x00000308 ***
NB_INT_SRC:         equ    $00000308                                ;*** NB_INT_SRC - Interrupt source register; 0x00000308 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_INT_SRC_ERR:     equ    0                                         ; SCI Error Interrupt Status
NB_INT_SRC_TX:      equ    1                                         ; SCI Transmit Interrupt Status
NB_INT_SRC_RX:      equ    2                                         ; SCI Receive Interrupt Status
NB_INT_SRC_CVMI:    equ    3                                         ; Current / Voltage Measurement Interrupt Status
NB_INT_SRC_LTC:     equ    4                                         ; Life Time Counter Interrupt Status
NB_INT_SRC_CAL:     equ    5                                         ; Calibration Request Interrupt Status
NB_INT_SRC_UVI:     equ    8                                         ; Undervoltage Interrupt pending or wake up from Cranking Mode Status
NB_INT_SRC_HTI:     equ    9                                         ; High Temperature Interrupt Status
NB_INT_SRC_LTI:     equ    10                                        ; LIN Driver Over Temperature Interrupt Status
NB_INT_SRC_CH0:     equ    11                                        ; TIM16B4C - TIM Channel 0 Interrupt Status
NB_INT_SRC_CH1:     equ    12                                        ; TIM16B4C - TIM Channel 1 Interrupt Status
NB_INT_SRC_CH2:     equ    13                                        ; TIM16B4C - TIM Channel 2 Interrupt Status
NB_INT_SRC_CH3:     equ    14                                        ; TIM16B4C - TIM Channel 3 Interrupt Status
NB_INT_SRC_TOV:     equ    15                                        ; TIM16B4C - Timer Overflow Interrupt Status
; bit position masks
mNB_INT_SRC_ERR:    equ    %00000001
mNB_INT_SRC_TX:     equ    %00000010
mNB_INT_SRC_RX:     equ    %00000100
mNB_INT_SRC_CVMI:   equ    %00001000
mNB_INT_SRC_LTC:    equ    %00010000
mNB_INT_SRC_CAL:    equ    %00100000
mNB_INT_SRC_UVI:    equ    %100000000
mNB_INT_SRC_HTI:    equ    %1000000000
mNB_INT_SRC_LTI:    equ    %10000000000
mNB_INT_SRC_CH0:    equ    %100000000000
mNB_INT_SRC_CH1:    equ    %1000000000000
mNB_INT_SRC_CH2:    equ    %10000000000000
mNB_INT_SRC_CH3:    equ    %100000000000000
mNB_INT_SRC_TOV:    equ    %1000000000000000


;*** NB_INT_SRCH - Interrupt source register high; 0x00000308 ***
NB_INT_SRCH:        equ    $00000308                                ;*** NB_INT_SRCH - Interrupt source register high; 0x00000308 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_INT_SRCH_UVI:    equ    0                                         ; Undervoltage Interrupt pending or wake up from Cranking Mode Status
NB_INT_SRCH_HTI:    equ    1                                         ; High Temperature Interrupt Status
NB_INT_SRCH_LTI:    equ    2                                         ; LIN Driver Over Temperature Interrupt Status
NB_INT_SRCH_CH0:    equ    3                                         ; TIM16B4C - TIM Channel 0 Interrupt Status
NB_INT_SRCH_CH1:    equ    4                                         ; TIM16B4C - TIM Channel 1 Interrupt Status
NB_INT_SRCH_CH2:    equ    5                                         ; TIM16B4C - TIM Channel 2 Interrupt Status
NB_INT_SRCH_CH3:    equ    6                                         ; TIM16B4C - TIM Channel 3 Interrupt Status
NB_INT_SRCH_TOV:    equ    7                                         ; TIM16B4C - Timer Overflow Interrupt Status
; bit position masks
mNB_INT_SRCH_UVI:   equ    %00000001
mNB_INT_SRCH_HTI:   equ    %00000010
mNB_INT_SRCH_LTI:   equ    %00000100
mNB_INT_SRCH_CH0:   equ    %00001000
mNB_INT_SRCH_CH1:   equ    %00010000
mNB_INT_SRCH_CH2:   equ    %00100000
mNB_INT_SRCH_CH3:   equ    %01000000
mNB_INT_SRCH_TOV:   equ    %10000000


;*** NB_INT_SRCL - Interrupt source register low; 0x00000309 ***
NB_INT_SRCL:        equ    $00000309                                ;*** NB_INT_SRCL - Interrupt source register low; 0x00000309 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_INT_SRCL_ERR:    equ    0                                         ; SCI Error Interrupt Status
NB_INT_SRCL_TX:     equ    1                                         ; SCI Transmit Interrupt Status
NB_INT_SRCL_RX:     equ    2                                         ; SCI Receive Interrupt Status
NB_INT_SRCL_CVMI:   equ    3                                         ; Current / Voltage Measurement Interrupt Status
NB_INT_SRCL_LTC:    equ    4                                         ; Life Time Counter Interrupt Status
NB_INT_SRCL_CAL:    equ    5                                         ; Calibration Request Interrupt Status
; bit position masks
mNB_INT_SRCL_ERR:   equ    %00000001
mNB_INT_SRCL_TX:    equ    %00000010
mNB_INT_SRCL_RX:    equ    %00000100
mNB_INT_SRCL_CVMI:  equ    %00001000
mNB_INT_SRCL_LTC:   equ    %00010000
mNB_INT_SRCL_CAL:   equ    %00100000


;*** NB_INT_VECT - Interrupt vector register; 0x0000030A ***
NB_INT_VECT:        equ    $0000030A                                ;*** NB_INT_VECT - Interrupt vector register; 0x0000030A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_INT_VECT_IRQ:    equ    0                                         ; Represents the highest prioritized interrupt pending
; bit position masks
mNB_INT_VECT_IRQ:   equ    %00001111


;*** NB_INT_MSK - Interrupt mask register; 0x0000030C ***
NB_INT_MSK:         equ    $0000030C                                ;*** NB_INT_MSK - Interrupt mask register; 0x0000030C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_INT_MSK_ERRM:    equ    0                                         ; SCI Error Interrupt Mask
NB_INT_MSK_TXM:     equ    1                                         ; SCI Transmit Interrupt Mask
NB_INT_MSK_RXM:     equ    2                                         ; SCI Receive Interrupt Mask
NB_INT_MSK_CVMM:    equ    3                                         ; Current / Voltage Measurement Interrupt Mask
NB_INT_MSK_LTCM:    equ    4                                         ; Life Time Counter Interrupt Mask
NB_INT_MSK_CALM:    equ    5                                         ; Calibration Request Interrupt Mask
NB_INT_MSK_UVIM:    equ    8                                         ; Undervoltage Interrupt Mask
NB_INT_MSK_HTIM:    equ    9                                         ; High Temperature Interrupt Mask
NB_INT_MSK_LTIM:    equ    10                                        ; LIN Driver Over Temperature Interrupt Mask
NB_INT_MSK_CH0M:    equ    11                                        ; Timer Channel 1 Interrupt Mask
NB_INT_MSK_CH1M:    equ    12                                        ; Timer Channel 1 Interrupt Mask
NB_INT_MSK_CH2M:    equ    13                                        ; Timer Channel 2 Interrupt Mask
NB_INT_MSK_CH3M:    equ    14                                        ; Timer Channel 3 Interrupt Mask
NB_INT_MSK_TOVM:    equ    15                                        ; Timer Overflow Interrupt Mask
; bit position masks
mNB_INT_MSK_ERRM:   equ    %00000001
mNB_INT_MSK_TXM:    equ    %00000010
mNB_INT_MSK_RXM:    equ    %00000100
mNB_INT_MSK_CVMM:   equ    %00001000
mNB_INT_MSK_LTCM:   equ    %00010000
mNB_INT_MSK_CALM:   equ    %00100000
mNB_INT_MSK_UVIM:   equ    %100000000
mNB_INT_MSK_HTIM:   equ    %1000000000
mNB_INT_MSK_LTIM:   equ    %10000000000
mNB_INT_MSK_CH0M:   equ    %100000000000
mNB_INT_MSK_CH1M:   equ    %1000000000000
mNB_INT_MSK_CH2M:   equ    %10000000000000
mNB_INT_MSK_CH3M:   equ    %100000000000000
mNB_INT_MSK_TOVM:   equ    %1000000000000000


;*** NB_INT_MSKH - Interrupt mask register high; 0x0000030C ***
NB_INT_MSKH:        equ    $0000030C                                ;*** NB_INT_MSKH - Interrupt mask register high; 0x0000030C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_INT_MSKH_UVIM:   equ    0                                         ; Undervoltage Interrupt Mask
NB_INT_MSKH_HTIM:   equ    1                                         ; High Temperature Interrupt Mask
NB_INT_MSKH_LTIM:   equ    2                                         ; LIN Driver Over Temperature Interrupt Mask
NB_INT_MSKH_CH0M:   equ    3                                         ; Timer Channel 1 Interrupt Mask
NB_INT_MSKH_CH1M:   equ    4                                         ; Timer Channel 1 Interrupt Mask
NB_INT_MSKH_CH2M:   equ    5                                         ; Timer Channel 2 Interrupt Mask
NB_INT_MSKH_CH3M:   equ    6                                         ; Timer Channel 3 Interrupt Mask
NB_INT_MSKH_TOVM:   equ    7                                         ; Timer Overflow Interrupt Mask
; bit position masks
mNB_INT_MSKH_UVIM:  equ    %00000001
mNB_INT_MSKH_HTIM:  equ    %00000010
mNB_INT_MSKH_LTIM:  equ    %00000100
mNB_INT_MSKH_CH0M:  equ    %00001000
mNB_INT_MSKH_CH1M:  equ    %00010000
mNB_INT_MSKH_CH2M:  equ    %00100000
mNB_INT_MSKH_CH3M:  equ    %01000000
mNB_INT_MSKH_TOVM:  equ    %10000000


;*** NB_INT_MSKL - Interrupt mask register low; 0x0000030D ***
NB_INT_MSKL:        equ    $0000030D                                ;*** NB_INT_MSKL - Interrupt mask register low; 0x0000030D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_INT_MSKL_ERRM:   equ    0                                         ; SCI Error Interrupt Mask
NB_INT_MSKL_TXM:    equ    1                                         ; SCI Transmit Interrupt Mask
NB_INT_MSKL_RXM:    equ    2                                         ; SCI Receive Interrupt Mask
NB_INT_MSKL_CVMM:   equ    3                                         ; Current / Voltage Measurement Interrupt Mask
NB_INT_MSKL_LTCM:   equ    4                                         ; Life Time Counter Interrupt Mask
NB_INT_MSKL_CALM:   equ    5                                         ; Calibration Request Interrupt Mask
; bit position masks
mNB_INT_MSKL_ERRM:  equ    %00000001
mNB_INT_MSKL_TXM:   equ    %00000010
mNB_INT_MSKL_RXM:   equ    %00000100
mNB_INT_MSKL_CVMM:  equ    %00001000
mNB_INT_MSKL_LTCM:  equ    %00010000
mNB_INT_MSKL_CALM:  equ    %00100000


;*** NB_TRIM_ALF - Trim for accurate 1ms low freq clock; 0x0000030E ***
NB_TRIM_ALF:        equ    $0000030E                                ;*** NB_TRIM_ALF - Trim for accurate 1ms low freq clock; 0x0000030E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_ALF_APRESC: equ    0                                         ; ALFCLK Prescaler 0
NB_TRIM_ALF_PRDF:   equ    15                                        ; ALFCLK Prescaler ready Flag
; bit position masks
mNB_TRIM_ALF_APRESC: equ    %1111111111111
mNB_TRIM_ALF_PRDF:  equ    %1000000000000000


;*** NB_TRIM_ALFH - Trim for accurate 1ms low freq clock high; 0x0000030E ***
NB_TRIM_ALFH:       equ    $0000030E                                ;*** NB_TRIM_ALFH - Trim for accurate 1ms low freq clock high; 0x0000030E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_ALFH_APRESC: equ    0                                        ; ALFCLK Prescaler 8
NB_TRIM_ALFH_PRDF:  equ    7                                         ; ALFCLK Prescaler ready Flag
; bit position masks
mNB_TRIM_ALFH_APRESC: equ    %00011111
mNB_TRIM_ALFH_PRDF: equ    %10000000


;*** NB_TRIM_ALFL - Trim for accurate 1ms low freq clock low; 0x0000030F ***
NB_TRIM_ALFL:       equ    $0000030F                                ;*** NB_TRIM_ALFL - Trim for accurate 1ms low freq clock low; 0x0000030F ***


;*** NB_WD_CTL - Watchdog control register; 0x00000310 ***
NB_WD_CTL:          equ    $00000310                                ;*** NB_WD_CTL - Watchdog control register; 0x00000310 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_WD_CTL_WDTO:     equ    0                                         ; Watchdog Time Out Configuration
NB_WD_CTL_WDTST:    equ    7                                         ; Watchdog Test
NB_WD_CTL_WDTOM:    equ    8                                         ; Watchdog Time Out - Mask
NB_WD_CTL_WDSTM:    equ    15                                        ; Watchdog Test - Mask
; bit position masks
mNB_WD_CTL_WDTO:    equ    %00000111
mNB_WD_CTL_WDTST:   equ    %10000000
mNB_WD_CTL_WDTOM:   equ    %11100000000
mNB_WD_CTL_WDSTM:   equ    %1000000000000000


;*** NB_WD_SR - Watchdog status register; 0x00000312 ***
NB_WD_SR:           equ    $00000312                                ;*** NB_WD_SR - Watchdog status register; 0x00000312 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_WD_SR_WDWO:      equ    0                                         ; Watchdog Status
NB_WD_SR_WDOFF:     equ    1                                         ; Watchdog Window Status
; bit position masks
mNB_WD_SR_WDWO:     equ    %00000001
mNB_WD_SR_WDOFF:    equ    %00000010


;*** NB_WD_RR - Watchdog rearm register; 0x00000314 ***
NB_WD_RR:           equ    $00000314                                ;*** NB_WD_RR - Watchdog rearm register; 0x00000314 ***


;*** NB_SCIBD - SCI Baud Rate Register; 0x00000318 ***
NB_SCIBD:           equ    $00000318                                ;*** NB_SCIBD - SCI Baud Rate Register; 0x00000318 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIBD_SBR0:      equ    0                                         ; Baud Rate Modulo Divisor Bit 0
NB_SCIBD_SBR1:      equ    1                                         ; Baud Rate Modulo Divisor Bit 1
NB_SCIBD_SBR2:      equ    2                                         ; Baud Rate Modulo Divisor Bit 2
NB_SCIBD_SBR3:      equ    3                                         ; Baud Rate Modulo Divisor Bit 3
NB_SCIBD_SBR4:      equ    4                                         ; Baud Rate Modulo Divisor Bit 4
NB_SCIBD_SBR5:      equ    5                                         ; Baud Rate Modulo Divisor Bit 5
NB_SCIBD_SBR6:      equ    6                                         ; Baud Rate Modulo Divisor Bit 6
NB_SCIBD_SBR7:      equ    7                                         ; Baud Rate Modulo Divisor Bit 7
NB_SCIBD_SBR8:      equ    8                                         ; Baud Rate Modulo Divisor Bit 8
NB_SCIBD_SBR9:      equ    9                                         ; Baud Rate Modulo Divisor Bit 9
NB_SCIBD_SBR10:     equ    10                                        ; Baud Rate Modulo Divisor Bit 10
NB_SCIBD_SBR11:     equ    11                                        ; Baud Rate Modulo Divisor Bit 11
NB_SCIBD_SBR12:     equ    12                                        ; Baud Rate Modulo Divisor Bit 12
NB_SCIBD_RXEDGIE:   equ    14                                        ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
NB_SCIBD_LBKDIE:    equ    15                                        ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mNB_SCIBD_SBR0:     equ    %00000001
mNB_SCIBD_SBR1:     equ    %00000010
mNB_SCIBD_SBR2:     equ    %00000100
mNB_SCIBD_SBR3:     equ    %00001000
mNB_SCIBD_SBR4:     equ    %00010000
mNB_SCIBD_SBR5:     equ    %00100000
mNB_SCIBD_SBR6:     equ    %01000000
mNB_SCIBD_SBR7:     equ    %10000000
mNB_SCIBD_SBR8:     equ    %100000000
mNB_SCIBD_SBR9:     equ    %1000000000
mNB_SCIBD_SBR10:    equ    %10000000000
mNB_SCIBD_SBR11:    equ    %100000000000
mNB_SCIBD_SBR12:    equ    %1000000000000
mNB_SCIBD_RXEDGIE:  equ    %100000000000000
mNB_SCIBD_LBKDIE:   equ    %1000000000000000


;*** NB_SCIBDH - SCI Baud Rate Register High; 0x00000318 ***
NB_SCIBDH:          equ    $00000318                                ;*** NB_SCIBDH - SCI Baud Rate Register High; 0x00000318 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIBDH_SBR8:     equ    0                                         ; Baud Rate Modulo Divisor Bit 8
NB_SCIBDH_SBR9:     equ    1                                         ; Baud Rate Modulo Divisor Bit 9
NB_SCIBDH_SBR10:    equ    2                                         ; Baud Rate Modulo Divisor Bit 10
NB_SCIBDH_SBR11:    equ    3                                         ; Baud Rate Modulo Divisor Bit 11
NB_SCIBDH_SBR12:    equ    4                                         ; Baud Rate Modulo Divisor Bit 12
NB_SCIBDH_RXEDGIE:  equ    6                                         ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
NB_SCIBDH_LBKDIE:   equ    7                                         ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mNB_SCIBDH_SBR8:    equ    %00000001
mNB_SCIBDH_SBR9:    equ    %00000010
mNB_SCIBDH_SBR10:   equ    %00000100
mNB_SCIBDH_SBR11:   equ    %00001000
mNB_SCIBDH_SBR12:   equ    %00010000
mNB_SCIBDH_RXEDGIE: equ    %01000000
mNB_SCIBDH_LBKDIE:  equ    %10000000


;*** NB_SCIBDL - SCI Baud Rate Register Low; 0x00000319 ***
NB_SCIBDL:          equ    $00000319                                ;*** NB_SCIBDL - SCI Baud Rate Register Low; 0x00000319 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIBDL_SBR0:     equ    0                                         ; Baud Rate Modulo Divisor Bit 0
NB_SCIBDL_SBR1:     equ    1                                         ; Baud Rate Modulo Divisor Bit 1
NB_SCIBDL_SBR2:     equ    2                                         ; Baud Rate Modulo Divisor Bit 2
NB_SCIBDL_SBR3:     equ    3                                         ; Baud Rate Modulo Divisor Bit 3
NB_SCIBDL_SBR4:     equ    4                                         ; Baud Rate Modulo Divisor Bit 4
NB_SCIBDL_SBR5:     equ    5                                         ; Baud Rate Modulo Divisor Bit 5
NB_SCIBDL_SBR6:     equ    6                                         ; Baud Rate Modulo Divisor Bit 6
NB_SCIBDL_SBR7:     equ    7                                         ; Baud Rate Modulo Divisor Bit 7
; bit position masks
mNB_SCIBDL_SBR0:    equ    %00000001
mNB_SCIBDL_SBR1:    equ    %00000010
mNB_SCIBDL_SBR2:    equ    %00000100
mNB_SCIBDL_SBR3:    equ    %00001000
mNB_SCIBDL_SBR4:    equ    %00010000
mNB_SCIBDL_SBR5:    equ    %00100000
mNB_SCIBDL_SBR6:    equ    %01000000
mNB_SCIBDL_SBR7:    equ    %10000000


;*** NB_SCIC1 - SCI Control Register 1; 0x0000031A ***
NB_SCIC1:           equ    $0000031A                                ;*** NB_SCIC1 - SCI Control Register 1; 0x0000031A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIC1_PT:        equ    0                                         ; Parity Type
NB_SCIC1_PE:        equ    1                                         ; Parity Enable
NB_SCIC1_ILT:       equ    2                                         ; Idle Line Type Select
NB_SCIC1_M:         equ    4                                         ; 9-Bit or 8-Bit Mode Select
NB_SCIC1_RSRC:      equ    5                                         ; Receiver Source Select
NB_SCIC1_LOOPS:     equ    7                                         ; Loop Mode Select
; bit position masks
mNB_SCIC1_PT:       equ    %00000001
mNB_SCIC1_PE:       equ    %00000010
mNB_SCIC1_ILT:      equ    %00000100
mNB_SCIC1_M:        equ    %00010000
mNB_SCIC1_RSRC:     equ    %00100000
mNB_SCIC1_LOOPS:    equ    %10000000


;*** NB_SCIC2 - SCI Control Register 2; 0x0000031B ***
NB_SCIC2:           equ    $0000031B                                ;*** NB_SCIC2 - SCI Control Register 2; 0x0000031B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIC2_SBK:       equ    0                                         ; Send Break
NB_SCIC2_RWU:       equ    1                                         ; Receiver Wakeup Control
NB_SCIC2_RE:        equ    2                                         ; Receiver Enable
NB_SCIC2_TE:        equ    3                                         ; Transmitter Enable
NB_SCIC2_ILIE:      equ    4                                         ; Idle Line Interrupt Enable (for IDLE)
NB_SCIC2_RIE:       equ    5                                         ; Receiver Interrupt Enable (for RDRF)
NB_SCIC2_TCIE:      equ    6                                         ; Transmission Complete Interrupt Enable (for TC)
NB_SCIC2_TIE:       equ    7                                         ; Transmit Interrupt Enable (for TDRE)
; bit position masks
mNB_SCIC2_SBK:      equ    %00000001
mNB_SCIC2_RWU:      equ    %00000010
mNB_SCIC2_RE:       equ    %00000100
mNB_SCIC2_TE:       equ    %00001000
mNB_SCIC2_ILIE:     equ    %00010000
mNB_SCIC2_RIE:      equ    %00100000
mNB_SCIC2_TCIE:     equ    %01000000
mNB_SCIC2_TIE:      equ    %10000000


;*** NB_SCIS1 - SCI Status Register 1; 0x0000031C ***
NB_SCIS1:           equ    $0000031C                                ;*** NB_SCIS1 - SCI Status Register 1; 0x0000031C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIS1_PF:        equ    0                                         ; Parity Error Flag
NB_SCIS1_FE:        equ    1                                         ; Framing Error Flag
NB_SCIS1_NF:        equ    2                                         ; Noise Flag
NB_SCIS1_OR:        equ    3                                         ; Receiver Overrun Flag
NB_SCIS1_IDLE:      equ    4                                         ; Idle Line Flag
NB_SCIS1_RDRF:      equ    5                                         ; Receive Data Register Full Flag
NB_SCIS1_TC:        equ    6                                         ; Transmission Complete Flag
NB_SCIS1_TDRE:      equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mNB_SCIS1_PF:       equ    %00000001
mNB_SCIS1_FE:       equ    %00000010
mNB_SCIS1_NF:       equ    %00000100
mNB_SCIS1_OR:       equ    %00001000
mNB_SCIS1_IDLE:     equ    %00010000
mNB_SCIS1_RDRF:     equ    %00100000
mNB_SCIS1_TC:       equ    %01000000
mNB_SCIS1_TDRE:     equ    %10000000


;*** NB_SCIS2 - SCI Status Register 2; 0x0000031D ***
NB_SCIS2:           equ    $0000031D                                ;*** NB_SCIS2 - SCI Status Register 2; 0x0000031D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIS2_RAF:       equ    0                                         ; Receiver Active Flag
NB_SCIS2_LBKDE:     equ    1                                         ; LIN Break Detection Enable
NB_SCIS2_BRK13:     equ    2                                         ; Break Character Generation Length
NB_SCIS2_RWUID:     equ    3                                         ; Receive Wake Up Idle Detect
NB_SCIS2_RXINV:     equ    4                                         ; Receive Data Inversion
NB_SCIS2_RXEDGIF:   equ    6                                         ; RxD Pin Active Edge Interrupt Flag
NB_SCIS2_LBKDIF:    equ    7                                         ; LIN Break Detect Interrupt Flag
; bit position masks
mNB_SCIS2_RAF:      equ    %00000001
mNB_SCIS2_LBKDE:    equ    %00000010
mNB_SCIS2_BRK13:    equ    %00000100
mNB_SCIS2_RWUID:    equ    %00001000
mNB_SCIS2_RXINV:    equ    %00010000
mNB_SCIS2_RXEDGIF:  equ    %01000000
mNB_SCIS2_LBKDIF:   equ    %10000000


;*** NB_SCIC3 - SCI Control Register 3; 0x0000031E ***
NB_SCIC3:           equ    $0000031E                                ;*** NB_SCIC3 - SCI Control Register 3; 0x0000031E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIC3_PEIE:      equ    0                                         ; Parity Error Interrupt Enable
NB_SCIC3_FEIE:      equ    1                                         ; Framing Error Interrupt Enable
NB_SCIC3_NEIE:      equ    2                                         ; Noise Error Interrupt Enable
NB_SCIC3_ORIE:      equ    3                                         ; Overrun Interrupt Enable
NB_SCIC3_TXINV:     equ    4                                         ; Transmit Data Inversion
NB_SCIC3_TXDIR:     equ    5                                         ; TxD Pin Direction in Single-Wire Mode
NB_SCIC3_T8:        equ    6                                         ; Ninth Data Bit for Transmitter
NB_SCIC3_R8:        equ    7                                         ; Ninth Data Bit for Receiver
; bit position masks
mNB_SCIC3_PEIE:     equ    %00000001
mNB_SCIC3_FEIE:     equ    %00000010
mNB_SCIC3_NEIE:     equ    %00000100
mNB_SCIC3_ORIE:     equ    %00001000
mNB_SCIC3_TXINV:    equ    %00010000
mNB_SCIC3_TXDIR:    equ    %00100000
mNB_SCIC3_T8:       equ    %01000000
mNB_SCIC3_R8:       equ    %10000000


;*** NB_SCID - SCI Data Register; 0x0000031F ***
NB_SCID:            equ    $0000031F                                ;*** NB_SCID - SCI Data Register; 0x0000031F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCID_R0_T0:      equ    0                                         ; Receive/Transmit Data Bit 0
NB_SCID_R1_T1:      equ    1                                         ; Receive/Transmit Data Bit 1
NB_SCID_R2_T2:      equ    2                                         ; Receive/Transmit Data Bit 2
NB_SCID_R3_T3:      equ    3                                         ; Receive/Transmit Data Bit 3
NB_SCID_R4_T4:      equ    4                                         ; Receive/Transmit Data Bit 4
NB_SCID_R5_T5:      equ    5                                         ; Receive/Transmit Data Bit 5
NB_SCID_R6_T6:      equ    6                                         ; Receive/Transmit Data Bit 6
NB_SCID_R7_T7:      equ    7                                         ; Receive/Transmit Data Bit 7
; bit position masks
mNB_SCID_R0_T0:     equ    %00000001
mNB_SCID_R1_T1:     equ    %00000010
mNB_SCID_R2_T2:     equ    %00000100
mNB_SCID_R3_T3:     equ    %00001000
mNB_SCID_R4_T4:     equ    %00010000
mNB_SCID_R5_T5:     equ    %00100000
mNB_SCID_R6_T6:     equ    %01000000
mNB_SCID_R7_T7:     equ    %10000000


;*** NB_TIOS - Timer Input Capture/Output Compare Select; 0x00000320 ***
NB_TIOS:            equ    $00000320                                ;*** NB_TIOS - Timer Input Capture/Output Compare Select; 0x00000320 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TIOS_IOS0:       equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
NB_TIOS_IOS1:       equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
NB_TIOS_IOS2:       equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
NB_TIOS_IOS3:       equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
; bit position masks
mNB_TIOS_IOS0:      equ    %00000001
mNB_TIOS_IOS1:      equ    %00000010
mNB_TIOS_IOS2:      equ    %00000100
mNB_TIOS_IOS3:      equ    %00001000


;*** NB_CFORC - Timer Compare Force Register; 0x00000321 ***
NB_CFORC:           equ    $00000321                                ;*** NB_CFORC - Timer Compare Force Register; 0x00000321 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_CFORC_FOC0:      equ    0                                         ; Force Output Compare Action for Channel 0
NB_CFORC_FOC1:      equ    1                                         ; Force Output Compare Action for Channel 1
NB_CFORC_FOC2:      equ    2                                         ; Force Output Compare Action for Channel 2
NB_CFORC_FOC3:      equ    3                                         ; Force Output Compare Action for Channel 3
; bit position masks
mNB_CFORC_FOC0:     equ    %00000001
mNB_CFORC_FOC1:     equ    %00000010
mNB_CFORC_FOC2:     equ    %00000100
mNB_CFORC_FOC3:     equ    %00001000


;*** NB_OC3M - Output Compare 3 Mask Register; 0x00000322 ***
NB_OC3M:            equ    $00000322                                ;*** NB_OC3M - Output Compare 3 Mask Register; 0x00000322 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_OC3M_OC3M0:      equ    0                                         ; Output Compare 3 Mask Bit 0
NB_OC3M_OC3M1:      equ    1                                         ; Output Compare 3 Mask Bit 1
NB_OC3M_OC3M2:      equ    2                                         ; Output Compare 3 Mask Bit 2
NB_OC3M_OC3M3:      equ    3                                         ; Output Compare 3 Mask Bit 3
; bit position masks
mNB_OC3M_OC3M0:     equ    %00000001
mNB_OC3M_OC3M1:     equ    %00000010
mNB_OC3M_OC3M2:     equ    %00000100
mNB_OC3M_OC3M3:     equ    %00001000


;*** NB_OC3D - Output Compare 3 Data Register; 0x00000323 ***
NB_OC3D:            equ    $00000323                                ;*** NB_OC3D - Output Compare 3 Data Register; 0x00000323 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_OC3D_OC3D0:      equ    0                                         ; Output Compare 3 Bit 0
NB_OC3D_OC3D1:      equ    1                                         ; Output Compare 3 Bit 1
NB_OC3D_OC3D2:      equ    2                                         ; Output Compare 3 Bit 2
NB_OC3D_OC3D3:      equ    3                                         ; Output Compare 3 Bit 3
; bit position masks
mNB_OC3D_OC3D0:     equ    %00000001
mNB_OC3D_OC3D1:     equ    %00000010
mNB_OC3D_OC3D2:     equ    %00000100
mNB_OC3D_OC3D3:     equ    %00001000


;*** NB_TCNT - Timer Count Register; 0x00000324 ***
NB_TCNT:            equ    $00000324                                ;*** NB_TCNT - Timer Count Register; 0x00000324 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCNT_BIT0:       equ    0                                         ; Timer Count Register Bit 0
NB_TCNT_BIT1:       equ    1                                         ; Timer Count Register Bit 1
NB_TCNT_BIT2:       equ    2                                         ; Timer Count Register Bit 2
NB_TCNT_BIT3:       equ    3                                         ; Timer Count Register Bit 3
NB_TCNT_BIT4:       equ    4                                         ; Timer Count Register Bit 4
NB_TCNT_BIT5:       equ    5                                         ; Timer Count Register Bit 5
NB_TCNT_BIT6:       equ    6                                         ; Timer Count Register Bit 6
NB_TCNT_BIT7:       equ    7                                         ; Timer Count Register Bit 7
NB_TCNT_BIT8:       equ    8                                         ; Timer Count Register Bit 8
NB_TCNT_BIT9:       equ    9                                         ; Timer Count Register Bit 9
NB_TCNT_BIT10:      equ    10                                        ; Timer Count Register Bit 10
NB_TCNT_BIT11:      equ    11                                        ; Timer Count Register Bit 11
NB_TCNT_BIT12:      equ    12                                        ; Timer Count Register Bit 12
NB_TCNT_BIT13:      equ    13                                        ; Timer Count Register Bit 13
NB_TCNT_BIT14:      equ    14                                        ; Timer Count Register Bit 14
NB_TCNT_BIT15:      equ    15                                        ; Timer Count Register Bit 15
; bit position masks
mNB_TCNT_BIT0:      equ    %00000001
mNB_TCNT_BIT1:      equ    %00000010
mNB_TCNT_BIT2:      equ    %00000100
mNB_TCNT_BIT3:      equ    %00001000
mNB_TCNT_BIT4:      equ    %00010000
mNB_TCNT_BIT5:      equ    %00100000
mNB_TCNT_BIT6:      equ    %01000000
mNB_TCNT_BIT7:      equ    %10000000
mNB_TCNT_BIT8:      equ    %100000000
mNB_TCNT_BIT9:      equ    %1000000000
mNB_TCNT_BIT10:     equ    %10000000000
mNB_TCNT_BIT11:     equ    %100000000000
mNB_TCNT_BIT12:     equ    %1000000000000
mNB_TCNT_BIT13:     equ    %10000000000000
mNB_TCNT_BIT14:     equ    %100000000000000
mNB_TCNT_BIT15:     equ    %1000000000000000


;*** NB_TCNTHi - Timer Count Register High; 0x00000324 ***
NB_TCNTHi:          equ    $00000324                                ;*** NB_TCNTHi - Timer Count Register High; 0x00000324 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCNTHi_BIT8:     equ    0                                         ; Timer Count Register Bit 8
NB_TCNTHi_BIT9:     equ    1                                         ; Timer Count Register Bit 9
NB_TCNTHi_BIT10:    equ    2                                         ; Timer Count Register Bit 10
NB_TCNTHi_BIT11:    equ    3                                         ; Timer Count Register Bit 11
NB_TCNTHi_BIT12:    equ    4                                         ; Timer Count Register Bit 12
NB_TCNTHi_BIT13:    equ    5                                         ; Timer Count Register Bit 13
NB_TCNTHi_BIT14:    equ    6                                         ; Timer Count Register Bit 14
NB_TCNTHi_BIT15:    equ    7                                         ; Timer Count Register Bit 15
; bit position masks
mNB_TCNTHi_BIT8:    equ    %00000001
mNB_TCNTHi_BIT9:    equ    %00000010
mNB_TCNTHi_BIT10:   equ    %00000100
mNB_TCNTHi_BIT11:   equ    %00001000
mNB_TCNTHi_BIT12:   equ    %00010000
mNB_TCNTHi_BIT13:   equ    %00100000
mNB_TCNTHi_BIT14:   equ    %01000000
mNB_TCNTHi_BIT15:   equ    %10000000


;*** NB_TCNTLo - Timer Count Register Low; 0x00000325 ***
NB_TCNTLo:          equ    $00000325                                ;*** NB_TCNTLo - Timer Count Register Low; 0x00000325 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCNTLo_BIT0:     equ    0                                         ; Timer Count Register Bit 0
NB_TCNTLo_BIT1:     equ    1                                         ; Timer Count Register Bit 1
NB_TCNTLo_BIT2:     equ    2                                         ; Timer Count Register Bit 2
NB_TCNTLo_BIT3:     equ    3                                         ; Timer Count Register Bit 3
NB_TCNTLo_BIT4:     equ    4                                         ; Timer Count Register Bit 4
NB_TCNTLo_BIT5:     equ    5                                         ; Timer Count Register Bit 5
NB_TCNTLo_BIT6:     equ    6                                         ; Timer Count Register Bit 6
NB_TCNTLo_BIT7:     equ    7                                         ; Timer Count Register Bit 7
; bit position masks
mNB_TCNTLo_BIT0:    equ    %00000001
mNB_TCNTLo_BIT1:    equ    %00000010
mNB_TCNTLo_BIT2:    equ    %00000100
mNB_TCNTLo_BIT3:    equ    %00001000
mNB_TCNTLo_BIT4:    equ    %00010000
mNB_TCNTLo_BIT5:    equ    %00100000
mNB_TCNTLo_BIT6:    equ    %01000000
mNB_TCNTLo_BIT7:    equ    %10000000


;*** NB_TSCR1 - Timer System Control Register1; 0x00000326 ***
NB_TSCR1:           equ    $00000326                                ;*** NB_TSCR1 - Timer System Control Register1; 0x00000326 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TSCR1_TFFCA:     equ    4                                         ; Timer Fast Flag Clear All
NB_TSCR1_TEN:       equ    7                                         ; Timer Enable
; bit position masks
mNB_TSCR1_TFFCA:    equ    %00010000
mNB_TSCR1_TEN:      equ    %10000000


;*** NB_TTOV - Timer Toggle On Overflow Register; 0x00000327 ***
NB_TTOV:            equ    $00000327                                ;*** NB_TTOV - Timer Toggle On Overflow Register; 0x00000327 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TTOV_TOV0:       equ    0                                         ; Toggle On Overflow Bit 0
NB_TTOV_TOV1:       equ    1                                         ; Toggle On Overflow Bit 1
NB_TTOV_TOV2:       equ    2                                         ; Toggle On Overflow Bit 2
NB_TTOV_TOV3:       equ    3                                         ; Toggle On Overflow Bit 3
; bit position masks
mNB_TTOV_TOV0:      equ    %00000001
mNB_TTOV_TOV1:      equ    %00000010
mNB_TTOV_TOV2:      equ    %00000100
mNB_TTOV_TOV3:      equ    %00001000


;*** NB_TCTL1 - Timer Control Register 1; 0x00000328 ***
NB_TCTL1:           equ    $00000328                                ;*** NB_TCTL1 - Timer Control Register 1; 0x00000328 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCTL1_OL0:       equ    0                                         ; Output Level Bit 0
NB_TCTL1_OM0:       equ    1                                         ; Output Mode Bit 0
NB_TCTL1_OL1:       equ    2                                         ; Output Lecel Bit 1
NB_TCTL1_OM1:       equ    3                                         ; Output Mode Bit 1
NB_TCTL1_OL2:       equ    4                                         ; Output Level Bit 2
NB_TCTL1_OM2:       equ    5                                         ; Output Mode Bit 2
NB_TCTL1_OL3:       equ    6                                         ; Output Level Bit 3
NB_TCTL1_OM3:       equ    7                                         ; Output Mode Bit 3
; bit position masks
mNB_TCTL1_OL0:      equ    %00000001
mNB_TCTL1_OM0:      equ    %00000010
mNB_TCTL1_OL1:      equ    %00000100
mNB_TCTL1_OM1:      equ    %00001000
mNB_TCTL1_OL2:      equ    %00010000
mNB_TCTL1_OM2:      equ    %00100000
mNB_TCTL1_OL3:      equ    %01000000
mNB_TCTL1_OM3:      equ    %10000000


;*** NB_TCTL2 - Timer Control Register 2; 0x00000329 ***
NB_TCTL2:           equ    $00000329                                ;*** NB_TCTL2 - Timer Control Register 2; 0x00000329 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCTL2_EDG0A:     equ    0                                         ; Input Capture Edge 0 Control A
NB_TCTL2_EDG0B:     equ    1                                         ; Input Capture Edge 0 Control B
NB_TCTL2_EDG1A:     equ    2                                         ; Input Capture Edge 1 Control A
NB_TCTL2_EDG1B:     equ    3                                         ; Input Capture Edge 1 Control B
NB_TCTL2_EDG2A:     equ    4                                         ; Input Capture Edge 2 Control A
NB_TCTL2_EDG2B:     equ    5                                         ; Input Capture Edge 2 Control B
NB_TCTL2_EDG3A:     equ    6                                         ; Input Capture Edge 3 Control A
NB_TCTL2_EDG3B:     equ    7                                         ; Input Capture Edge 3 Control B
; bit position masks
mNB_TCTL2_EDG0A:    equ    %00000001
mNB_TCTL2_EDG0B:    equ    %00000010
mNB_TCTL2_EDG1A:    equ    %00000100
mNB_TCTL2_EDG1B:    equ    %00001000
mNB_TCTL2_EDG2A:    equ    %00010000
mNB_TCTL2_EDG2B:    equ    %00100000
mNB_TCTL2_EDG3A:    equ    %01000000
mNB_TCTL2_EDG3B:    equ    %10000000


;*** NB_TIE - Timer Interrupt Enable Register; 0x0000032A ***
NB_TIE:             equ    $0000032A                                ;*** NB_TIE - Timer Interrupt Enable Register; 0x0000032A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TIE_C0I:         equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
NB_TIE_C1I:         equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
NB_TIE_C2I:         equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
NB_TIE_C3I:         equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
; bit position masks
mNB_TIE_C0I:        equ    %00000001
mNB_TIE_C1I:        equ    %00000010
mNB_TIE_C2I:        equ    %00000100
mNB_TIE_C3I:        equ    %00001000


;*** NB_TSCR2 - Timer System Control Register 2; 0x0000032B ***
NB_TSCR2:           equ    $0000032B                                ;*** NB_TSCR2 - Timer System Control Register 2; 0x0000032B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TSCR2_PR0:       equ    0                                         ; Timer Prescaler Select Bit 0
NB_TSCR2_PR1:       equ    1                                         ; Timer Prescaler Select Bit 1
NB_TSCR2_PR2:       equ    2                                         ; Timer Prescaler Select Bit 2
NB_TSCR2_TCRE:      equ    3                                         ; Timer Counter Reset Enable
NB_TSCR2_TOI:       equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mNB_TSCR2_PR0:      equ    %00000001
mNB_TSCR2_PR1:      equ    %00000010
mNB_TSCR2_PR2:      equ    %00000100
mNB_TSCR2_TCRE:     equ    %00001000
mNB_TSCR2_TOI:      equ    %10000000


;*** NB_TFLG1 - Main Timer Interrupt Flag 1; 0x0000032C ***
NB_TFLG1:           equ    $0000032C                                ;*** NB_TFLG1 - Main Timer Interrupt Flag 1; 0x0000032C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TFLG1_C0F:       equ    0                                         ; Input Capture/Output Compare Channel Flag 0
NB_TFLG1_C1F:       equ    1                                         ; Input Capture/Output Compare Channel Flag 1
NB_TFLG1_C2F:       equ    2                                         ; Input Capture/Output Compare Channel Flag 2
NB_TFLG1_C3F:       equ    3                                         ; Input Capture/Output Compare Channel Flag 3
; bit position masks
mNB_TFLG1_C0F:      equ    %00000001
mNB_TFLG1_C1F:      equ    %00000010
mNB_TFLG1_C2F:      equ    %00000100
mNB_TFLG1_C3F:      equ    %00001000


;*** NB_TFLG2 - Main Timer Interrupt Flag 2; 0x0000032D ***
NB_TFLG2:           equ    $0000032D                                ;*** NB_TFLG2 - Main Timer Interrupt Flag 2; 0x0000032D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TFLG2_TOF:       equ    7                                         ; Timer Overflow Flag
; bit position masks
mNB_TFLG2_TOF:      equ    %10000000


;*** NB_TC0 - Timer Input Capture/Output Compare Register 0; 0x0000032E ***
NB_TC0:             equ    $0000032E                                ;*** NB_TC0 - Timer Input Capture/Output Compare Register 0; 0x0000032E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC0_BIT0:        equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 0
NB_TC0_BIT1:        equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 1
NB_TC0_BIT2:        equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 2
NB_TC0_BIT3:        equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 3
NB_TC0_BIT4:        equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 4
NB_TC0_BIT5:        equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 5
NB_TC0_BIT6:        equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 6
NB_TC0_BIT7:        equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 7
NB_TC0_BIT8:        equ    8                                         ; Timer Input Capture/Output Compare Register 0 Bit 8
NB_TC0_BIT9:        equ    9                                         ; Timer Input Capture/Output Compare Register 0 Bit 9
NB_TC0_BIT10:       equ    10                                        ; Timer Input Capture/Output Compare Register 0 Bit 10
NB_TC0_BIT11:       equ    11                                        ; Timer Input Capture/Output Compare Register 0 Bit 11
NB_TC0_BIT12:       equ    12                                        ; Timer Input Capture/Output Compare Register 0 Bit 12
NB_TC0_BIT13:       equ    13                                        ; Timer Input Capture/Output Compare Register 0 Bit 13
NB_TC0_BIT14:       equ    14                                        ; Timer Input Capture/Output Compare Register 0 Bit 14
NB_TC0_BIT15:       equ    15                                        ; Timer Input Capture/Output Compare Register 0 Bit 15
; bit position masks
mNB_TC0_BIT0:       equ    %00000001
mNB_TC0_BIT1:       equ    %00000010
mNB_TC0_BIT2:       equ    %00000100
mNB_TC0_BIT3:       equ    %00001000
mNB_TC0_BIT4:       equ    %00010000
mNB_TC0_BIT5:       equ    %00100000
mNB_TC0_BIT6:       equ    %01000000
mNB_TC0_BIT7:       equ    %10000000
mNB_TC0_BIT8:       equ    %100000000
mNB_TC0_BIT9:       equ    %1000000000
mNB_TC0_BIT10:      equ    %10000000000
mNB_TC0_BIT11:      equ    %100000000000
mNB_TC0_BIT12:      equ    %1000000000000
mNB_TC0_BIT13:      equ    %10000000000000
mNB_TC0_BIT14:      equ    %100000000000000
mNB_TC0_BIT15:      equ    %1000000000000000


;*** NB_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x0000032E ***
NB_TC0Hi:           equ    $0000032E                                ;*** NB_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x0000032E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC0Hi_BIT8:      equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 8
NB_TC0Hi_BIT9:      equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 9
NB_TC0Hi_BIT10:     equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 10
NB_TC0Hi_BIT11:     equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 11
NB_TC0Hi_BIT12:     equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 12
NB_TC0Hi_BIT13:     equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 13
NB_TC0Hi_BIT14:     equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 14
NB_TC0Hi_BIT15:     equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 15
; bit position masks
mNB_TC0Hi_BIT8:     equ    %00000001
mNB_TC0Hi_BIT9:     equ    %00000010
mNB_TC0Hi_BIT10:    equ    %00000100
mNB_TC0Hi_BIT11:    equ    %00001000
mNB_TC0Hi_BIT12:    equ    %00010000
mNB_TC0Hi_BIT13:    equ    %00100000
mNB_TC0Hi_BIT14:    equ    %01000000
mNB_TC0Hi_BIT15:    equ    %10000000


;*** NB_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x0000032F ***
NB_TC0Lo:           equ    $0000032F                                ;*** NB_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x0000032F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC0Lo_BIT0:      equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 0
NB_TC0Lo_BIT1:      equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 1
NB_TC0Lo_BIT2:      equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 2
NB_TC0Lo_BIT3:      equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 3
NB_TC0Lo_BIT4:      equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 4
NB_TC0Lo_BIT5:      equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 5
NB_TC0Lo_BIT6:      equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 6
NB_TC0Lo_BIT7:      equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 7
; bit position masks
mNB_TC0Lo_BIT0:     equ    %00000001
mNB_TC0Lo_BIT1:     equ    %00000010
mNB_TC0Lo_BIT2:     equ    %00000100
mNB_TC0Lo_BIT3:     equ    %00001000
mNB_TC0Lo_BIT4:     equ    %00010000
mNB_TC0Lo_BIT5:     equ    %00100000
mNB_TC0Lo_BIT6:     equ    %01000000
mNB_TC0Lo_BIT7:     equ    %10000000


;*** NB_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000330 ***
NB_TC1:             equ    $00000330                                ;*** NB_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000330 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC1_BIT0:        equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 0
NB_TC1_BIT1:        equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 1
NB_TC1_BIT2:        equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 2
NB_TC1_BIT3:        equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 3
NB_TC1_BIT4:        equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 4
NB_TC1_BIT5:        equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 5
NB_TC1_BIT6:        equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 6
NB_TC1_BIT7:        equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 7
NB_TC1_BIT8:        equ    8                                         ; Timer Input Capture/Output Compare Register 1 Bit 8
NB_TC1_BIT9:        equ    9                                         ; Timer Input Capture/Output Compare Register 1 Bit 9
NB_TC1_BIT10:       equ    10                                        ; Timer Input Capture/Output Compare Register 1 Bit 10
NB_TC1_BIT11:       equ    11                                        ; Timer Input Capture/Output Compare Register 1 Bit 11
NB_TC1_BIT12:       equ    12                                        ; Timer Input Capture/Output Compare Register 1 Bit 12
NB_TC1_BIT13:       equ    13                                        ; Timer Input Capture/Output Compare Register 1 Bit 13
NB_TC1_BIT14:       equ    14                                        ; Timer Input Capture/Output Compare Register 1 Bit 14
NB_TC1_BIT15:       equ    15                                        ; Timer Input Capture/Output Compare Register 1 Bit 15
; bit position masks
mNB_TC1_BIT0:       equ    %00000001
mNB_TC1_BIT1:       equ    %00000010
mNB_TC1_BIT2:       equ    %00000100
mNB_TC1_BIT3:       equ    %00001000
mNB_TC1_BIT4:       equ    %00010000
mNB_TC1_BIT5:       equ    %00100000
mNB_TC1_BIT6:       equ    %01000000
mNB_TC1_BIT7:       equ    %10000000
mNB_TC1_BIT8:       equ    %100000000
mNB_TC1_BIT9:       equ    %1000000000
mNB_TC1_BIT10:      equ    %10000000000
mNB_TC1_BIT11:      equ    %100000000000
mNB_TC1_BIT12:      equ    %1000000000000
mNB_TC1_BIT13:      equ    %10000000000000
mNB_TC1_BIT14:      equ    %100000000000000
mNB_TC1_BIT15:      equ    %1000000000000000


;*** NB_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000330 ***
NB_TC1Hi:           equ    $00000330                                ;*** NB_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000330 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC1Hi_BIT8:      equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 8
NB_TC1Hi_BIT9:      equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 9
NB_TC1Hi_BIT10:     equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 10
NB_TC1Hi_BIT11:     equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 11
NB_TC1Hi_BIT12:     equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 12
NB_TC1Hi_BIT13:     equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 13
NB_TC1Hi_BIT14:     equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 14
NB_TC1Hi_BIT15:     equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 15
; bit position masks
mNB_TC1Hi_BIT8:     equ    %00000001
mNB_TC1Hi_BIT9:     equ    %00000010
mNB_TC1Hi_BIT10:    equ    %00000100
mNB_TC1Hi_BIT11:    equ    %00001000
mNB_TC1Hi_BIT12:    equ    %00010000
mNB_TC1Hi_BIT13:    equ    %00100000
mNB_TC1Hi_BIT14:    equ    %01000000
mNB_TC1Hi_BIT15:    equ    %10000000


;*** NB_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000331 ***
NB_TC1Lo:           equ    $00000331                                ;*** NB_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000331 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC1Lo_BIT0:      equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 0
NB_TC1Lo_BIT1:      equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 1
NB_TC1Lo_BIT2:      equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 2
NB_TC1Lo_BIT3:      equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 3
NB_TC1Lo_BIT4:      equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 4
NB_TC1Lo_BIT5:      equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 5
NB_TC1Lo_BIT6:      equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 6
NB_TC1Lo_BIT7:      equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 7
; bit position masks
mNB_TC1Lo_BIT0:     equ    %00000001
mNB_TC1Lo_BIT1:     equ    %00000010
mNB_TC1Lo_BIT2:     equ    %00000100
mNB_TC1Lo_BIT3:     equ    %00001000
mNB_TC1Lo_BIT4:     equ    %00010000
mNB_TC1Lo_BIT5:     equ    %00100000
mNB_TC1Lo_BIT6:     equ    %01000000
mNB_TC1Lo_BIT7:     equ    %10000000


;*** NB_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000332 ***
NB_TC2:             equ    $00000332                                ;*** NB_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000332 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC2_BIT0:        equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 0
NB_TC2_BIT1:        equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 1
NB_TC2_BIT2:        equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 2
NB_TC2_BIT3:        equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 3
NB_TC2_BIT4:        equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 4
NB_TC2_BIT5:        equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 5
NB_TC2_BIT6:        equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 6
NB_TC2_BIT7:        equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 7
NB_TC2_BIT8:        equ    8                                         ; Timer Input Capture/Output Compare Register 2 Bit 8
NB_TC2_BIT9:        equ    9                                         ; Timer Input Capture/Output Compare Register 2 Bit 9
NB_TC2_BIT10:       equ    10                                        ; Timer Input Capture/Output Compare Register 2 Bit 10
NB_TC2_BIT11:       equ    11                                        ; Timer Input Capture/Output Compare Register 2 Bit 11
NB_TC2_BIT12:       equ    12                                        ; Timer Input Capture/Output Compare Register 2 Bit 12
NB_TC2_BIT13:       equ    13                                        ; Timer Input Capture/Output Compare Register 2 Bit 13
NB_TC2_BIT14:       equ    14                                        ; Timer Input Capture/Output Compare Register 2 Bit 14
NB_TC2_BIT15:       equ    15                                        ; Timer Input Capture/Output Compare Register 2 Bit 15
; bit position masks
mNB_TC2_BIT0:       equ    %00000001
mNB_TC2_BIT1:       equ    %00000010
mNB_TC2_BIT2:       equ    %00000100
mNB_TC2_BIT3:       equ    %00001000
mNB_TC2_BIT4:       equ    %00010000
mNB_TC2_BIT5:       equ    %00100000
mNB_TC2_BIT6:       equ    %01000000
mNB_TC2_BIT7:       equ    %10000000
mNB_TC2_BIT8:       equ    %100000000
mNB_TC2_BIT9:       equ    %1000000000
mNB_TC2_BIT10:      equ    %10000000000
mNB_TC2_BIT11:      equ    %100000000000
mNB_TC2_BIT12:      equ    %1000000000000
mNB_TC2_BIT13:      equ    %10000000000000
mNB_TC2_BIT14:      equ    %100000000000000
mNB_TC2_BIT15:      equ    %1000000000000000


;*** NB_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000332 ***
NB_TC2Hi:           equ    $00000332                                ;*** NB_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000332 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC2Hi_BIT8:      equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 8
NB_TC2Hi_BIT9:      equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 9
NB_TC2Hi_BIT10:     equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 10
NB_TC2Hi_BIT11:     equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 11
NB_TC2Hi_BIT12:     equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 12
NB_TC2Hi_BIT13:     equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 13
NB_TC2Hi_BIT14:     equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 14
NB_TC2Hi_BIT15:     equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 15
; bit position masks
mNB_TC2Hi_BIT8:     equ    %00000001
mNB_TC2Hi_BIT9:     equ    %00000010
mNB_TC2Hi_BIT10:    equ    %00000100
mNB_TC2Hi_BIT11:    equ    %00001000
mNB_TC2Hi_BIT12:    equ    %00010000
mNB_TC2Hi_BIT13:    equ    %00100000
mNB_TC2Hi_BIT14:    equ    %01000000
mNB_TC2Hi_BIT15:    equ    %10000000


;*** NB_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000333 ***
NB_TC2Lo:           equ    $00000333                                ;*** NB_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000333 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC2Lo_BIT0:      equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 0
NB_TC2Lo_BIT1:      equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 1
NB_TC2Lo_BIT2:      equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 2
NB_TC2Lo_BIT3:      equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 3
NB_TC2Lo_BIT4:      equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 4
NB_TC2Lo_BIT5:      equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 5
NB_TC2Lo_BIT6:      equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 6
NB_TC2Lo_BIT7:      equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 7
; bit position masks
mNB_TC2Lo_BIT0:     equ    %00000001
mNB_TC2Lo_BIT1:     equ    %00000010
mNB_TC2Lo_BIT2:     equ    %00000100
mNB_TC2Lo_BIT3:     equ    %00001000
mNB_TC2Lo_BIT4:     equ    %00010000
mNB_TC2Lo_BIT5:     equ    %00100000
mNB_TC2Lo_BIT6:     equ    %01000000
mNB_TC2Lo_BIT7:     equ    %10000000


;*** NB_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000334 ***
NB_TC3:             equ    $00000334                                ;*** NB_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000334 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC3_BIT0:        equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 0
NB_TC3_BIT1:        equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 1
NB_TC3_BIT2:        equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 2
NB_TC3_BIT3:        equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 3
NB_TC3_BIT4:        equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 4
NB_TC3_BIT5:        equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 5
NB_TC3_BIT6:        equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 6
NB_TC3_BIT7:        equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 7
NB_TC3_BIT8:        equ    8                                         ; Timer Input Capture/Output Compare Register 3 Bit 8
NB_TC3_BIT9:        equ    9                                         ; Timer Input Capture/Output Compare Register 3 Bit 9
NB_TC3_BIT10:       equ    10                                        ; Timer Input Capture/Output Compare Register 3 Bit 10
NB_TC3_BIT11:       equ    11                                        ; Timer Input Capture/Output Compare Register 3 Bit 11
NB_TC3_BIT12:       equ    12                                        ; Timer Input Capture/Output Compare Register 3 Bit 12
NB_TC3_BIT13:       equ    13                                        ; Timer Input Capture/Output Compare Register 3 Bit 13
NB_TC3_BIT14:       equ    14                                        ; Timer Input Capture/Output Compare Register 3 Bit 14
NB_TC3_BIT15:       equ    15                                        ; Timer Input Capture/Output Compare Register 3 Bit 15
; bit position masks
mNB_TC3_BIT0:       equ    %00000001
mNB_TC3_BIT1:       equ    %00000010
mNB_TC3_BIT2:       equ    %00000100
mNB_TC3_BIT3:       equ    %00001000
mNB_TC3_BIT4:       equ    %00010000
mNB_TC3_BIT5:       equ    %00100000
mNB_TC3_BIT6:       equ    %01000000
mNB_TC3_BIT7:       equ    %10000000
mNB_TC3_BIT8:       equ    %100000000
mNB_TC3_BIT9:       equ    %1000000000
mNB_TC3_BIT10:      equ    %10000000000
mNB_TC3_BIT11:      equ    %100000000000
mNB_TC3_BIT12:      equ    %1000000000000
mNB_TC3_BIT13:      equ    %10000000000000
mNB_TC3_BIT14:      equ    %100000000000000
mNB_TC3_BIT15:      equ    %1000000000000000


;*** NB_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000334 ***
NB_TC3Hi:           equ    $00000334                                ;*** NB_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000334 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC3Hi_BIT8:      equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 8
NB_TC3Hi_BIT9:      equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 9
NB_TC3Hi_BIT10:     equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 10
NB_TC3Hi_BIT11:     equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 11
NB_TC3Hi_BIT12:     equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 12
NB_TC3Hi_BIT13:     equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 13
NB_TC3Hi_BIT14:     equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 14
NB_TC3Hi_BIT15:     equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 15
; bit position masks
mNB_TC3Hi_BIT8:     equ    %00000001
mNB_TC3Hi_BIT9:     equ    %00000010
mNB_TC3Hi_BIT10:    equ    %00000100
mNB_TC3Hi_BIT11:    equ    %00001000
mNB_TC3Hi_BIT12:    equ    %00010000
mNB_TC3Hi_BIT13:    equ    %00100000
mNB_TC3Hi_BIT14:    equ    %01000000
mNB_TC3Hi_BIT15:    equ    %10000000


;*** NB_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000335 ***
NB_TC3Lo:           equ    $00000335                                ;*** NB_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000335 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC3Lo_BIT0:      equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 0
NB_TC3Lo_BIT1:      equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 1
NB_TC3Lo_BIT2:      equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 2
NB_TC3Lo_BIT3:      equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 3
NB_TC3Lo_BIT4:      equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 4
NB_TC3Lo_BIT5:      equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 5
NB_TC3Lo_BIT6:      equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 6
NB_TC3Lo_BIT7:      equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 7
; bit position masks
mNB_TC3Lo_BIT0:     equ    %00000001
mNB_TC3Lo_BIT1:     equ    %00000010
mNB_TC3Lo_BIT2:     equ    %00000100
mNB_TC3Lo_BIT3:     equ    %00001000
mNB_TC3Lo_BIT4:     equ    %00010000
mNB_TC3Lo_BIT5:     equ    %00100000
mNB_TC3Lo_BIT6:     equ    %01000000
mNB_TC3Lo_BIT7:     equ    %10000000


;*** NB_LTC_CTL - Life Time Counter control register; 0x00000338 ***
NB_LTC_CTL:         equ    $00000338                                ;*** NB_LTC_CTL - Life Time Counter control register; 0x00000338 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LTC_CTL_LTCE:    equ    0                                         ; Life Time Counter Enable
NB_LTC_CTL_LTCIE:   equ    7                                         ; Life Time Counter Interrupt Enable
NB_LTC_CTL_LTCEM:   equ    8                                         ; Life Time Counter Enable Mask
NB_LTC_CTL_LTCIEM:  equ    15                                        ; Life Time Counter Interrupt Enable Mask
; bit position masks
mNB_LTC_CTL_LTCE:   equ    %00000001
mNB_LTC_CTL_LTCIE:  equ    %10000000
mNB_LTC_CTL_LTCEM:  equ    %100000000
mNB_LTC_CTL_LTCIEM: equ    %1000000000000000


;*** NB_LTC_CTLH - Life Time Counter control register high; 0x00000338 ***
NB_LTC_CTLH:        equ    $00000338                                ;*** NB_LTC_CTLH - Life Time Counter control register high; 0x00000338 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LTC_CTLH_LTCEM:  equ    0                                         ; Life Time Counter Enable Mask
NB_LTC_CTLH_LTCIEM: equ    7                                         ; Life Time Counter Interrupt Enable Mask
; bit position masks
mNB_LTC_CTLH_LTCEM: equ    %00000001
mNB_LTC_CTLH_LTCIEM: equ    %10000000


;*** NB_LTC_CTLL - Life Time Counter control register low; 0x00000339 ***
NB_LTC_CTLL:        equ    $00000339                                ;*** NB_LTC_CTLL - Life Time Counter control register low; 0x00000339 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LTC_CTLL_LTCE:   equ    0                                         ; Life Time Counter Enable
NB_LTC_CTLL_LTCIE:  equ    7                                         ; Life Time Counter Interrupt Enable
; bit position masks
mNB_LTC_CTLL_LTCE:  equ    %00000001
mNB_LTC_CTLL_LTCIE: equ    %10000000


;*** NB_LTC_SR - Life Time Counter status register; 0x0000033A ***
NB_LTC_SR:          equ    $0000033A                                ;*** NB_LTC_SR - Life Time Counter status register; 0x0000033A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LTC_SR_LTCOF:    equ    7                                         ; Life Time Counter Overflow Flag
; bit position masks
mNB_LTC_SR_LTCOF:   equ    %10000000


;*** NB_LTC_CNT1 - Life Time Counter Register 1; 0x0000033C ***
NB_LTC_CNT1:        equ    $0000033C                                ;*** NB_LTC_CNT1 - Life Time Counter Register 1; 0x0000033C ***


;*** NB_LTC_CNT0 - Life Time Counter Register 0; 0x0000033E ***
NB_LTC_CNT0:        equ    $0000033E                                ;*** NB_LTC_CNT0 - Life Time Counter Register 0; 0x0000033E ***


;*** NB_GPIO_CTL - GPIO control register; 0x00000340 ***
NB_GPIO_CTL:        equ    $00000340                                ;*** NB_GPIO_CTL - GPIO control register; 0x00000340 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_CTL_PE0:    equ    0                                         ; Port 0 Enable
NB_GPIO_CTL_PE1:    equ    1                                         ; Port 1 Enable
NB_GPIO_CTL_PE2:    equ    2                                         ; Port 2 Enable
NB_GPIO_CTL_PE3:    equ    3                                         ; Port 3 Enable
NB_GPIO_CTL_DIR0:   equ    4                                         ; Data Direction PTB0
NB_GPIO_CTL_DIR1:   equ    5                                         ; Data Direction PTB1
NB_GPIO_CTL_DIR2:   equ    6                                         ; Data Direction PTB2
NB_GPIO_CTL_PE0M:   equ    8                                         ; Port 0 Enable - Mask
NB_GPIO_CTL_PE1M:   equ    9                                         ; Port 1 Enable - Mask
NB_GPIO_CTL_PE2M:   equ    10                                        ; Port 2 Enable - Mask
NB_GPIO_CTL_PE3M:   equ    11                                        ; Port 3 Enable - Mask
NB_GPIO_CTL_DIR0M:  equ    12                                        ; Data Direction PTB0 - Mask
NB_GPIO_CTL_DIR1M:  equ    13                                        ; Data Direction PTB1 - Mask
NB_GPIO_CTL_DIR2M:  equ    14                                        ; Data Direction PTB2 - Mask
; bit position masks
mNB_GPIO_CTL_PE0:   equ    %00000001
mNB_GPIO_CTL_PE1:   equ    %00000010
mNB_GPIO_CTL_PE2:   equ    %00000100
mNB_GPIO_CTL_PE3:   equ    %00001000
mNB_GPIO_CTL_DIR0:  equ    %00010000
mNB_GPIO_CTL_DIR1:  equ    %00100000
mNB_GPIO_CTL_DIR2:  equ    %01000000
mNB_GPIO_CTL_PE0M:  equ    %100000000
mNB_GPIO_CTL_PE1M:  equ    %1000000000
mNB_GPIO_CTL_PE2M:  equ    %10000000000
mNB_GPIO_CTL_PE3M:  equ    %100000000000
mNB_GPIO_CTL_DIR0M: equ    %1000000000000
mNB_GPIO_CTL_DIR1M: equ    %10000000000000
mNB_GPIO_CTL_DIR2M: equ    %100000000000000


;*** NB_GPIO_PUC - GPIO pull up configuration; 0x00000342 ***
NB_GPIO_PUC:        equ    $00000342                                ;*** NB_GPIO_PUC - GPIO pull up configuration; 0x00000342 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_PUC_PUE0:   equ    0                                         ; PTB0 Pull Up Enable
NB_GPIO_PUC_PUE1:   equ    1                                         ; PTB1 Pull Up Enable
NB_GPIO_PUC_PUE2:   equ    2                                         ; PTB2 Pull Up Enable
NB_GPIO_PUC_PDE3:   equ    3                                         ; PTB3 Pull Down Enable
; bit position masks
mNB_GPIO_PUC_PUE0:  equ    %00000001
mNB_GPIO_PUC_PUE1:  equ    %00000010
mNB_GPIO_PUC_PUE2:  equ    %00000100
mNB_GPIO_PUC_PDE3:  equ    %00001000


;*** NB_GPIO_DATA - GPIO port data register; 0x00000343 ***
NB_GPIO_DATA:       equ    $00000343                                ;*** NB_GPIO_DATA - GPIO port data register; 0x00000343 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_DATA_PD0:   equ    0                                         ; PTB0 Data Register
NB_GPIO_DATA_PD1:   equ    1                                         ; PTB1 Data Register
NB_GPIO_DATA_PD2:   equ    2                                         ; PTB2 Data Register
NB_GPIO_DATA_PD3:   equ    3                                         ; PTB3 Data Register
; bit position masks
mNB_GPIO_DATA_PD0:  equ    %00000001
mNB_GPIO_DATA_PD1:  equ    %00000010
mNB_GPIO_DATA_PD2:  equ    %00000100
mNB_GPIO_DATA_PD3:  equ    %00001000


;*** NB_GPIO_IN0 - Port 0 input configuration; 0x00000344 ***
NB_GPIO_IN0:        equ    $00000344                                ;*** NB_GPIO_IN0 - Port 0 input configuration; 0x00000344 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_IN0_LINTX:  equ    1                                         ; PTB0 - LIN Module Tx Input
NB_GPIO_IN0_SCIRX:  equ    2                                         ; PTB0 - SCI Module Rx Input
NB_GPIO_IN0_TCAP0:  equ    3                                         ; PTB0 - Timer Input Capture Channel 0
NB_GPIO_IN0_TCAP1:  equ    4                                         ; PTB0 - Timer Input Capture Channel 1
NB_GPIO_IN0_TCAP2:  equ    5                                         ; PTB0 - Timer Input Capture Channel 2
NB_GPIO_IN0_TCAP3:  equ    6                                         ; PTB0 - Timer Input Capture Channel 3
; bit position masks
mNB_GPIO_IN0_LINTX: equ    %00000010
mNB_GPIO_IN0_SCIRX: equ    %00000100
mNB_GPIO_IN0_TCAP0: equ    %00001000
mNB_GPIO_IN0_TCAP1: equ    %00010000
mNB_GPIO_IN0_TCAP2: equ    %00100000
mNB_GPIO_IN0_TCAP3: equ    %01000000


;*** NB_GPIO_OUT0 - Port 0 output configuration; 0x00000345 ***
NB_GPIO_OUT0:       equ    $00000345                                ;*** NB_GPIO_OUT0 - Port 0 output configuration; 0x00000345 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_OUT0_PTBX0: equ    0                                         ; PTB0 - Output Buffer Control
NB_GPIO_OUT0_LINRX: equ    1                                         ; PTB0 - LIN RX Output
NB_GPIO_OUT0_SCITX: equ    2                                         ; PTB0 - SCI TX Output
NB_GPIO_OUT0_TCOMP0: equ    3                                        ; PTB0 - Timer Channel 0 - Output Compare output
NB_GPIO_OUT0_TCOMP1: equ    4                                        ; PTB0 - Timer Channel 1 - Output Compare output
NB_GPIO_OUT0_TCOMP2: equ    5                                        ; PTB0 - Timer Channel 2 - Output Compare output
NB_GPIO_OUT0_TCOMP3: equ    6                                        ; PTB0 - Timer Channel 3 - Output Compare output
NB_GPIO_OUT0_WKUP:  equ    7                                         ; PTB0 - Wake Up output
; bit position masks
mNB_GPIO_OUT0_PTBX0: equ    %00000001
mNB_GPIO_OUT0_LINRX: equ    %00000010
mNB_GPIO_OUT0_SCITX: equ    %00000100
mNB_GPIO_OUT0_TCOMP0: equ    %00001000
mNB_GPIO_OUT0_TCOMP1: equ    %00010000
mNB_GPIO_OUT0_TCOMP2: equ    %00100000
mNB_GPIO_OUT0_TCOMP3: equ    %01000000
mNB_GPIO_OUT0_WKUP: equ    %10000000


;*** NB_GPIO_IN1 - Port 1 input configuration; 0x00000346 ***
NB_GPIO_IN1:        equ    $00000346                                ;*** NB_GPIO_IN1 - Port 1 input configuration; 0x00000346 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_IN1_LINTX:  equ    1                                         ; PTB1 - LIN Module Tx Input
NB_GPIO_IN1_SCIRX:  equ    2                                         ; PTB1 - SCI Module Rx Input
NB_GPIO_IN1_TCAP0:  equ    3                                         ; PTB1 - Timer Input Capture Channel 0
NB_GPIO_IN1_TCAP1:  equ    4                                         ; PTB1 - Timer Input Capture Channel 1
NB_GPIO_IN1_TCAP2:  equ    5                                         ; PTB1 - Timer Input Capture Channel 2
NB_GPIO_IN1_TCAP3:  equ    6                                         ; PTB1 - Timer Input Capture Channel 3
; bit position masks
mNB_GPIO_IN1_LINTX: equ    %00000010
mNB_GPIO_IN1_SCIRX: equ    %00000100
mNB_GPIO_IN1_TCAP0: equ    %00001000
mNB_GPIO_IN1_TCAP1: equ    %00010000
mNB_GPIO_IN1_TCAP2: equ    %00100000
mNB_GPIO_IN1_TCAP3: equ    %01000000


;*** NB_GPIO_OUT1 - Port 1 output configuration; 0x00000347 ***
NB_GPIO_OUT1:       equ    $00000347                                ;*** NB_GPIO_OUT1 - Port 1 output configuration; 0x00000347 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_OUT1_PTBX1: equ    0                                         ; PTB1 - Output Buffer Control
NB_GPIO_OUT1_LINRX: equ    1                                         ; PTB1 - LIN RX Output
NB_GPIO_OUT1_SCITX: equ    2                                         ; PTB1 - SCI TX Output
NB_GPIO_OUT1_TCOMP0: equ    3                                        ; PTB1 - Timer Channel 0 - Output Compare output
NB_GPIO_OUT1_TCOMP1: equ    4                                        ; PTB1 - Timer Channel 1 - Output Compare output
NB_GPIO_OUT1_TCOMP2: equ    5                                        ; PTB1 - Timer Channel 2 - Output Compare output
NB_GPIO_OUT1_TCOMP3: equ    6                                        ; PTB1 - Timer Channel 3 - Output Compare output
NB_GPIO_OUT1_WKUP:  equ    7                                         ; PTB1 - Wake Up output
; bit position masks
mNB_GPIO_OUT1_PTBX1: equ    %00000001
mNB_GPIO_OUT1_LINRX: equ    %00000010
mNB_GPIO_OUT1_SCITX: equ    %00000100
mNB_GPIO_OUT1_TCOMP0: equ    %00001000
mNB_GPIO_OUT1_TCOMP1: equ    %00010000
mNB_GPIO_OUT1_TCOMP2: equ    %00100000
mNB_GPIO_OUT1_TCOMP3: equ    %01000000
mNB_GPIO_OUT1_WKUP: equ    %10000000


;*** NB_GPIO_IN2 - Port 2 input configuration; 0x00000348 ***
NB_GPIO_IN2:        equ    $00000348                                ;*** NB_GPIO_IN2 - Port 2 input configuration; 0x00000348 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_IN2_LINTX:  equ    1                                         ; PTB2 - LIN Module Tx Input
NB_GPIO_IN2_SCIRX:  equ    2                                         ; PTB2 - SCI Module Rx Input
NB_GPIO_IN2_TCAP0:  equ    3                                         ; PTB2 - Timer Input Capture Channel 0
NB_GPIO_IN2_TCAP1:  equ    4                                         ; PTB2 - Timer Input Capture Channel 1
NB_GPIO_IN2_TCAP2:  equ    5                                         ; PTB2 - Timer Input Capture Channel 2
NB_GPIO_IN2_TCAP3:  equ    6                                         ; PTB2 - Timer Input Capture Channel 3
; bit position masks
mNB_GPIO_IN2_LINTX: equ    %00000010
mNB_GPIO_IN2_SCIRX: equ    %00000100
mNB_GPIO_IN2_TCAP0: equ    %00001000
mNB_GPIO_IN2_TCAP1: equ    %00010000
mNB_GPIO_IN2_TCAP2: equ    %00100000
mNB_GPIO_IN2_TCAP3: equ    %01000000


;*** NB_GPIO_OUT2 - Port 2 output configuration; 0x00000349 ***
NB_GPIO_OUT2:       equ    $00000349                                ;*** NB_GPIO_OUT2 - Port 2 output configuration; 0x00000349 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_OUT2_PTBX2: equ    0                                         ; PTB2 - Output Buffer Control
NB_GPIO_OUT2_LINRX: equ    1                                         ; PTB2 - LIN RX Output
NB_GPIO_OUT2_SCITX: equ    2                                         ; PTB2 - SCI TX Output
NB_GPIO_OUT2_TCOMP0: equ    3                                        ; PTB2 - Timer Channel 0 - Output Compare output
NB_GPIO_OUT2_TCOMP1: equ    4                                        ; PTB2 - Timer Channel 1 - Output Compare output
NB_GPIO_OUT2_TCOMP2: equ    5                                        ; PTB2 - Timer Channel 2 - Output Compare output
NB_GPIO_OUT2_TCOMP3: equ    6                                        ; PTB2 - Timer Channel 3 - Output Compare output
NB_GPIO_OUT2_WKUP:  equ    7                                         ; PTB2 - Wake Up output
; bit position masks
mNB_GPIO_OUT2_PTBX2: equ    %00000001
mNB_GPIO_OUT2_LINRX: equ    %00000010
mNB_GPIO_OUT2_SCITX: equ    %00000100
mNB_GPIO_OUT2_TCOMP0: equ    %00001000
mNB_GPIO_OUT2_TCOMP1: equ    %00010000
mNB_GPIO_OUT2_TCOMP2: equ    %00100000
mNB_GPIO_OUT2_TCOMP3: equ    %01000000
mNB_GPIO_OUT2_WKUP: equ    %10000000


;*** NB_GPIO_IN3 - Port 3 input configuration; 0x0000034A ***
NB_GPIO_IN3:        equ    $0000034A                                ;*** NB_GPIO_IN3 - Port 3 input configuration; 0x0000034A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_GPIO_IN3_TCAP0:  equ    3                                         ; PTB3 - Timer Input Capture Channel 0
NB_GPIO_IN3_TCAP1:  equ    4                                         ; PTB3 - Timer Input Capture Channel 1
NB_GPIO_IN3_TCAP2:  equ    5                                         ; PTB3 - Timer Input Capture Channel 2
NB_GPIO_IN3_TCAP3:  equ    6                                         ; PTB3 - Timer Input Capture Channel 3
NB_GPIO_IN3_PTWU:   equ    7                                         ; PTB3 Wake Up
; bit position masks
mNB_GPIO_IN3_TCAP0: equ    %00001000
mNB_GPIO_IN3_TCAP1: equ    %00010000
mNB_GPIO_IN3_TCAP2: equ    %00100000
mNB_GPIO_IN3_TCAP3: equ    %01000000
mNB_GPIO_IN3_PTWU:  equ    %10000000


;*** NB_LIN_CTL - LIN control register; 0x00000350 ***
NB_LIN_CTL:         equ    $00000350                                ;*** NB_LIN_CTL - LIN control register; 0x00000350 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LIN_CTL_SRS:     equ    0                                         ; Slew Rate Select
NB_LIN_CTL_EN:      equ    2                                         ; Module Enable
NB_LIN_CTL_LVSD:    equ    3                                         ; Low Voltage Shutdown Disable (J2602 Compliance Control)
NB_LIN_CTL_TXD:     equ    4                                         ; Direct Transmitter Control
NB_LIN_CTL_OTIE:    equ    7                                         ; Overtemperature Interrupt Enable
NB_LIN_CTL_SRSM:    equ    8                                         ; Slew Rate Select - Mask
NB_LIN_CTL_ENM:     equ    10                                        ; Module Enable - Mask
NB_LIN_CTL_LVSDM:   equ    11                                        ; Low Voltage Shutdown Disable (J2602 Compliance Control) - Mask
NB_LIN_CTL_TXDM:    equ    12                                        ; Direct Transmitter Control - Mask
NB_LIN_CTL_OTIEM:   equ    15                                        ; Overtemperature Interrupt Enable - Mask
; bit position masks
mNB_LIN_CTL_SRS:    equ    %00000011
mNB_LIN_CTL_EN:     equ    %00000100
mNB_LIN_CTL_LVSD:   equ    %00001000
mNB_LIN_CTL_TXD:    equ    %00010000
mNB_LIN_CTL_OTIE:   equ    %10000000
mNB_LIN_CTL_SRSM:   equ    %1100000000
mNB_LIN_CTL_ENM:    equ    %10000000000
mNB_LIN_CTL_LVSDM:  equ    %100000000000
mNB_LIN_CTL_TXDM:   equ    %1000000000000
mNB_LIN_CTL_OTIEM:  equ    %1000000000000000


;*** NB_LIN_SR - LIN status register; 0x00000352 ***
NB_LIN_SR:          equ    $00000352                                ;*** NB_LIN_SR - LIN status register; 0x00000352 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LIN_SR_TX:       equ    0                                         ; Current TX status
NB_LIN_SR_RX:       equ    1                                         ; Current RX status
NB_LIN_SR_RDY:      equ    7                                         ; Transmitter Ready Status
NB_LIN_SR_UV:       equ    11                                        ; Undervoltage Status
NB_LIN_SR_HF:       equ    13                                        ; HF (High Frequency) Condition Status indicating HF disturbance in the LIN module
NB_LIN_SR_OT:       equ    15                                        ; Overtemperature Status
; bit position masks
mNB_LIN_SR_TX:      equ    %00000001
mNB_LIN_SR_RX:      equ    %00000010
mNB_LIN_SR_RDY:     equ    %10000000
mNB_LIN_SR_UV:      equ    %100000000000
mNB_LIN_SR_HF:      equ    %10000000000000
mNB_LIN_SR_OT:      equ    %1000000000000000


;*** NB_LIN_SRH - LIN status register high; 0x00000352 ***
NB_LIN_SRH:         equ    $00000352                                ;*** NB_LIN_SRH - LIN status register high; 0x00000352 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LIN_SRH_UV:      equ    3                                         ; Undervoltage Status
NB_LIN_SRH_HF:      equ    5                                         ; HF (High Frequency) Condition Status indicating HF disturbance in the LIN module
NB_LIN_SRH_OT:      equ    7                                         ; Overtemperature Status
; bit position masks
mNB_LIN_SRH_UV:     equ    %00001000
mNB_LIN_SRH_HF:     equ    %00100000
mNB_LIN_SRH_OT:     equ    %10000000


;*** NB_LIN_SRL - LIN status register low; 0x00000353 ***
NB_LIN_SRL:         equ    $00000353                                ;*** NB_LIN_SRL - LIN status register low; 0x00000353 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LIN_SRL_TX:      equ    0                                         ; Current TX status
NB_LIN_SRL_RX:      equ    1                                         ; Current RX status
NB_LIN_SRL_RDY:     equ    7                                         ; Transmitter Ready Status
; bit position masks
mNB_LIN_SRL_TX:     equ    %00000001
mNB_LIN_SRL_RX:     equ    %00000010
mNB_LIN_SRL_RDY:    equ    %10000000


;*** NB_LIN_TX - LIN transmit line definition; 0x00000354 ***
NB_LIN_TX:          equ    $00000354                                ;*** NB_LIN_TX - LIN transmit line definition; 0x00000354 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LIN_TX_FROMSCI:  equ    0                                         ; LIN_TX internally routed from SCI
NB_LIN_TX_FROMPTB:  equ    1                                         ; LIN_TX internally routed from PTB
; bit position masks
mNB_LIN_TX_FROMSCI: equ    %00000001
mNB_LIN_TX_FROMPTB: equ    %00000010


;*** NB_LIN_RX - LIN receive line definition; 0x00000355 ***
NB_LIN_RX:          equ    $00000355                                ;*** NB_LIN_RX - LIN receive line definition; 0x00000355 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LIN_RX_TOSCI:    equ    0                                         ; LIN_RX internally routed to SCI
NB_LIN_RX_TOPTB:    equ    1                                         ; LIN_RX internally routed to PTB
NB_LIN_RX_TCAP0:    equ    3                                         ; LIN_RX internally routed to Timer Channel 0 Input Capture
NB_LIN_RX_TCAP1:    equ    4                                         ; LIN_RX internally routed to Timer Channel 1 Input Capture
NB_LIN_RX_TCAP2:    equ    5                                         ; LIN_RX internally routed to Timer Channel 2 Input Capture
NB_LIN_RX_TCAP3:    equ    6                                         ; LIN_RX internally routed to Timer Channel 3 Input Capture
; bit position masks
mNB_LIN_RX_TOSCI:   equ    %00000001
mNB_LIN_RX_TOPTB:   equ    %00000010
mNB_LIN_RX_TCAP0:   equ    %00001000
mNB_LIN_RX_TCAP1:   equ    %00010000
mNB_LIN_RX_TCAP2:   equ    %00100000
mNB_LIN_RX_TCAP3:   equ    %01000000


;*** NB_ACQ_CTL - Acquisition control register; 0x00000358 ***
NB_ACQ_CTL:         equ    $00000358                                ;*** NB_ACQ_CTL - Acquisition control register; 0x00000358 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_CTL_CMEN:    equ    0                                         ; Current Measurement Enable
NB_ACQ_CTL_VMEN:    equ    1                                         ; Voltage Measurement Enable
NB_ACQ_CTL_ITMEN:   equ    2                                         ; Internal Temperature Measurement Enable
NB_ACQ_CTL_ETMEN:   equ    3                                         ; External Temperature Measurement Enable
NB_ACQ_CTL_CVMIE:   equ    4                                         ; Current / Voltage Measurement Interrupt Enable
NB_ACQ_CTL_OPENE:   equ    5                                         ; Enable Shunt Resistor Open Detection
NB_ACQ_CTL_OPTE:    equ    6                                         ; Optional Voltage Sense Enable (Voltage Channel Multiplexer Control)
NB_ACQ_CTL_AHCR:    equ    7                                         ; Ampere Hour Counter Reset, this write only bit will reset the ACQ_AHC register
NB_ACQ_CTL_CMENM:   equ    8                                         ; Current Measurement Enable - Mask
NB_ACQ_CTL_VMENM:   equ    9                                         ; Voltage Measurement Enable - Mask
NB_ACQ_CTL_ITMENM:  equ    10                                        ; Internal Temperature Measurement Enable - Mask
NB_ACQ_CTL_ETMENM:  equ    11                                        ; External Temperature Measurement Enable - Mask
NB_ACQ_CTL_CVMIEM:  equ    12                                        ; Current / Voltage Measurement Interrupt Enable - Mask
NB_ACQ_CTL_OPENEM:  equ    13                                        ; Enable Shunt Resistor Open Detection - Mask
NB_ACQ_CTL_OPTEM:   equ    14                                        ; Optional Voltage Sense Enable - Mask
NB_ACQ_CTL_AHCRM:   equ    15                                        ; Ampere Hour Counter Reset - Mask
; bit position masks
mNB_ACQ_CTL_CMEN:   equ    %00000001
mNB_ACQ_CTL_VMEN:   equ    %00000010
mNB_ACQ_CTL_ITMEN:  equ    %00000100
mNB_ACQ_CTL_ETMEN:  equ    %00001000
mNB_ACQ_CTL_CVMIE:  equ    %00010000
mNB_ACQ_CTL_OPENE:  equ    %00100000
mNB_ACQ_CTL_OPTE:   equ    %01000000
mNB_ACQ_CTL_AHCR:   equ    %10000000
mNB_ACQ_CTL_CMENM:  equ    %100000000
mNB_ACQ_CTL_VMENM:  equ    %1000000000
mNB_ACQ_CTL_ITMENM: equ    %10000000000
mNB_ACQ_CTL_ETMENM: equ    %100000000000
mNB_ACQ_CTL_CVMIEM: equ    %1000000000000
mNB_ACQ_CTL_OPENEM: equ    %10000000000000
mNB_ACQ_CTL_OPTEM:  equ    %100000000000000
mNB_ACQ_CTL_AHCRM:  equ    %1000000000000000


;*** NB_ACQ_SR - Acquisition status register; 0x0000035A ***
NB_ACQ_SR:          equ    $0000035A                                ;*** NB_ACQ_SR - Acquisition status register; 0x0000035A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_SR_CCHOP:    equ    0                                         ; Chopping Active Status - Current
NB_ACQ_SR_VCHOP:    equ    1                                         ; Chopping Active Status - Voltage
NB_ACQ_SR_ITCHOP:   equ    2                                         ; Chopping Active Status - Internal Temperature
NB_ACQ_SR_ETCHOP:   equ    3                                         ; Chopping Active Status - External Temperature
NB_ACQ_SR_VTH:      equ    4                                         ; Digital Voltage High Threshold Reached
NB_ACQ_SR_OPEN:     equ    7                                         ; Shunt Resistor Open Detection Status
NB_ACQ_SR_CM:       equ    8                                         ; End of Measurement - Current
NB_ACQ_SR_VM:       equ    9                                         ; End of Measurement - Voltage
NB_ACQ_SR_ITM:      equ    10                                        ; End of Measurement - Internal Temperature
NB_ACQ_SR_ETM:      equ    11                                        ; End of Measurement - External Temperature
NB_ACQ_SR_CMOW:     equ    12                                        ; Current Measurement Result Overwritten
NB_ACQ_SR_VMOW:     equ    13                                        ; Voltage Measurement Result Overwritten
NB_ACQ_SR_PGAG:     equ    14                                        ; PGA Gain Change Flag
NB_ACQ_SR_AVRF:     equ    15                                        ; VDDA Low Voltage Reset Flag
; bit position masks
mNB_ACQ_SR_CCHOP:   equ    %00000001
mNB_ACQ_SR_VCHOP:   equ    %00000010
mNB_ACQ_SR_ITCHOP:  equ    %00000100
mNB_ACQ_SR_ETCHOP:  equ    %00001000
mNB_ACQ_SR_VTH:     equ    %00010000
mNB_ACQ_SR_OPEN:    equ    %10000000
mNB_ACQ_SR_CM:      equ    %100000000
mNB_ACQ_SR_VM:      equ    %1000000000
mNB_ACQ_SR_ITM:     equ    %10000000000
mNB_ACQ_SR_ETM:     equ    %100000000000
mNB_ACQ_SR_CMOW:    equ    %1000000000000
mNB_ACQ_SR_VMOW:    equ    %10000000000000
mNB_ACQ_SR_PGAG:    equ    %100000000000000
mNB_ACQ_SR_AVRF:    equ    %1000000000000000


;*** NB_ACQ_SRH - Acquisition status register high; 0x0000035A ***
NB_ACQ_SRH:         equ    $0000035A                                ;*** NB_ACQ_SRH - Acquisition status register high; 0x0000035A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_SRH_CM:      equ    0                                         ; End of Measurement - Current
NB_ACQ_SRH_VM:      equ    1                                         ; End of Measurement - Voltage
NB_ACQ_SRH_ITM:     equ    2                                         ; End of Measurement - Internal Temperature
NB_ACQ_SRH_ETM:     equ    3                                         ; End of Measurement - External Temperature
NB_ACQ_SRH_CMOW:    equ    4                                         ; Current Measurement Result Overwritten
NB_ACQ_SRH_VMOW:    equ    5                                         ; Voltage Measurement Result Overwritten
NB_ACQ_SRH_PGAG:    equ    6                                         ; PGA Gain Change Flag
NB_ACQ_SRH_AVRF:    equ    7                                         ; VDDA Low Voltage Reset Flag
; bit position masks
mNB_ACQ_SRH_CM:     equ    %00000001
mNB_ACQ_SRH_VM:     equ    %00000010
mNB_ACQ_SRH_ITM:    equ    %00000100
mNB_ACQ_SRH_ETM:    equ    %00001000
mNB_ACQ_SRH_CMOW:   equ    %00010000
mNB_ACQ_SRH_VMOW:   equ    %00100000
mNB_ACQ_SRH_PGAG:   equ    %01000000
mNB_ACQ_SRH_AVRF:   equ    %10000000


;*** NB_ACQ_SRL - Acquisition status register low; 0x0000035B ***
NB_ACQ_SRL:         equ    $0000035B                                ;*** NB_ACQ_SRL - Acquisition status register low; 0x0000035B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_SRL_CCHOP:   equ    0                                         ; Chopping Active Status - Current
NB_ACQ_SRL_VCHOP:   equ    1                                         ; Chopping Active Status - Voltage
NB_ACQ_SRL_ITCHOP:  equ    2                                         ; Chopping Active Status - Internal Temperature
NB_ACQ_SRL_ETCHOP:  equ    3                                         ; Chopping Active Status - External Temperature
NB_ACQ_SRL_VTH:     equ    4                                         ; Digital Voltage High Threshold Reached
NB_ACQ_SRL_OPEN:    equ    7                                         ; Shunt Resistor Open Detection Status
; bit position masks
mNB_ACQ_SRL_CCHOP:  equ    %00000001
mNB_ACQ_SRL_VCHOP:  equ    %00000010
mNB_ACQ_SRL_ITCHOP: equ    %00000100
mNB_ACQ_SRL_ETCHOP: equ    %00001000
mNB_ACQ_SRL_VTH:    equ    %00010000
mNB_ACQ_SRL_OPEN:   equ    %10000000


;*** NB_ACQ_ACC1 - Acquisition chain control 1; 0x0000035C ***
NB_ACQ_ACC1:        equ    $0000035C                                ;*** NB_ACQ_ACC1 - Acquisition chain control 1; 0x0000035C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_ACC1_AGEN:   equ    0                                         ; Automatic Gain Control Enable - Mask
NB_ACQ_ACC1_CVCHOP: equ    1                                         ; Chopping Enable - Voltage Measurement Channel - Mask
NB_ACQ_ACC1_ITCHOP: equ    2                                         ; Chopping Enable - Internal Temperature Measurement Channel - Mask
NB_ACQ_ACC1_ETCHOP: equ    3                                         ; Chopping Enable - External Temperature Measurement Channel - Mask
NB_ACQ_ACC1_LPFEN:  equ    4                                         ; LPF Enable - Mask
NB_ACQ_ACC1_CCOMP:  equ    5                                         ; Current Measurement Channel - Compensation Enable - Mask
NB_ACQ_ACC1_VCOMP:  equ    6                                         ; Voltage Measurement Channel - Compensation Enable - Mask
NB_ACQ_ACC1_TCOMP:  equ    7                                         ; Temperature Measurement Channel - Compensation Enable - Mask
NB_ACQ_ACC1_AGENM:  equ    8                                         ; Temperature Measurement Channel - Compensation Enable
NB_ACQ_ACC1_CVCHOPM: equ    9                                        ; Voltage Compensation Enable
NB_ACQ_ACC1_ITCHOPM: equ    10                                       ; Current Compensation Enable
NB_ACQ_ACC1_ETCHOPM: equ    11                                       ; LPF Enable
NB_ACQ_ACC1_LPFENM: equ    12                                        ; Chopping Enable - External Temperature
NB_ACQ_ACC1_CCOMPM: equ    13                                        ; Chopping Enable - Internal Temperature
NB_ACQ_ACC1_VCOMPM: equ    14                                        ; Chopping Enable - Voltage
NB_ACQ_ACC1_TCOMPM: equ    15                                        ; Automatic Gain Control Enable
; bit position masks
mNB_ACQ_ACC1_AGEN:  equ    %00000001
mNB_ACQ_ACC1_CVCHOP: equ    %00000010
mNB_ACQ_ACC1_ITCHOP: equ    %00000100
mNB_ACQ_ACC1_ETCHOP: equ    %00001000
mNB_ACQ_ACC1_LPFEN: equ    %00010000
mNB_ACQ_ACC1_CCOMP: equ    %00100000
mNB_ACQ_ACC1_VCOMP: equ    %01000000
mNB_ACQ_ACC1_TCOMP: equ    %10000000
mNB_ACQ_ACC1_AGENM: equ    %100000000
mNB_ACQ_ACC1_CVCHOPM: equ    %1000000000
mNB_ACQ_ACC1_ITCHOPM: equ    %10000000000
mNB_ACQ_ACC1_ETCHOPM: equ    %100000000000
mNB_ACQ_ACC1_LPFENM: equ    %1000000000000
mNB_ACQ_ACC1_CCOMPM: equ    %10000000000000
mNB_ACQ_ACC1_VCOMPM: equ    %100000000000000
mNB_ACQ_ACC1_TCOMPM: equ    %1000000000000000


;*** NB_ACQ_ACC0 - Acquisition chain control 0; 0x0000035E ***
NB_ACQ_ACC0:        equ    $0000035E                                ;*** NB_ACQ_ACC0 - Acquisition chain control 0; 0x0000035E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_ACC0_CDEN:   equ    0                                         ; Timing delay - Current
NB_ACQ_ACC0_VDEN:   equ    1                                         ; Timing delay - Voltage
NB_ACQ_ACC0_TDEN:   equ    2                                         ; Timing delay - Temperature
NB_ACQ_ACC0_CADCG:  equ    3                                         ; Current ADC Gain Select
NB_ACQ_ACC0_VADCG:  equ    4                                         ; Voltage ADC Gain Select
NB_ACQ_ACC0_TADCG:  equ    5                                         ; Temperature ADC Gain Select
NB_ACQ_ACC0_ECAP:   equ    6                                         ; TSUP External Capacitor select
NB_ACQ_ACC0_ZERO:   equ    7                                         ; Current and Voltage Sigma Delta Input Short
NB_ACQ_ACC0_CDENM:  equ    8                                         ; 100ns Clock delay - Current - Mask
NB_ACQ_ACC0_VDENM:  equ    9                                         ; 100ns Clock delay - Voltage - Mask
NB_ACQ_ACC0_TDENM:  equ    10                                        ; 100ns Clock delay - Internal Temperature - Mask
NB_ACQ_ACC0_CADCGM: equ    11                                        ; Current ADC Gain Select - Mask
NB_ACQ_ACC0_VADCGM: equ    12                                        ; Voltage ADC Gain Select - Mask
NB_ACQ_ACC0_TADCGM: equ    13                                        ; Temperature ADC Gain Select - Mask
NB_ACQ_ACC0_ECAPM:  equ    14                                        ; TSUP External Capacitor - Mask
NB_ACQ_ACC0_ZEROM:  equ    15                                        ; Current and Voltage Sigma Delta Input Short - Mask
; bit position masks
mNB_ACQ_ACC0_CDEN:  equ    %00000001
mNB_ACQ_ACC0_VDEN:  equ    %00000010
mNB_ACQ_ACC0_TDEN:  equ    %00000100
mNB_ACQ_ACC0_CADCG: equ    %00001000
mNB_ACQ_ACC0_VADCG: equ    %00010000
mNB_ACQ_ACC0_TADCG: equ    %00100000
mNB_ACQ_ACC0_ECAP:  equ    %01000000
mNB_ACQ_ACC0_ZERO:  equ    %10000000
mNB_ACQ_ACC0_CDENM: equ    %100000000
mNB_ACQ_ACC0_VDENM: equ    %1000000000
mNB_ACQ_ACC0_TDENM: equ    %10000000000
mNB_ACQ_ACC0_CADCGM: equ    %100000000000
mNB_ACQ_ACC0_VADCGM: equ    %1000000000000
mNB_ACQ_ACC0_TADCGM: equ    %10000000000000
mNB_ACQ_ACC0_ECAPM: equ    %100000000000000
mNB_ACQ_ACC0_ZEROM: equ    %1000000000000000


;*** NB_ACQ_DEC - Decimation Rate; 0x00000360 ***
NB_ACQ_DEC:         equ    $00000360                                ;*** NB_ACQ_DEC - Decimation Rate; 0x00000360 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_DEC_DEC:     equ    0                                         ; Decimation Rate Selection
; bit position masks
mNB_ACQ_DEC_DEC:    equ    %00000111


;*** NB_ACQ_BGC - Decimation Rate; 0x00000361 ***
NB_ACQ_BGC:         equ    $00000361                                ;*** NB_ACQ_BGC - Decimation Rate; 0x00000361 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_BGC_BG1EN:   equ    0                                         ; Bandgap Status
NB_ACQ_BGC_BG2EN:   equ    1                                         ; Bandgap 3 Status
NB_ACQ_BGC_BG3EN:   equ    2                                         ; Bandgap 3 Status
NB_ACQ_BGC_BGLDO:   equ    3                                         ; LDO (Low Dropout Regulator) Bandgap select
NB_ACQ_BGC_BGADC:   equ    4                                         ; ADC Bandgap select
; bit position masks
mNB_ACQ_BGC_BG1EN:  equ    %00000001
mNB_ACQ_BGC_BG2EN:  equ    %00000010
mNB_ACQ_BGC_BG3EN:  equ    %00000100
mNB_ACQ_BGC_BGLDO:  equ    %00001000
mNB_ACQ_BGC_BGADC:  equ    %00110000


;*** NB_ACQ_GAIN - PGA gain; 0x00000362 ***
NB_ACQ_GAIN:        equ    $00000362                                ;*** NB_ACQ_GAIN - PGA gain; 0x00000362 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_GAIN_IGAIN:  equ    0                                         ; PGA Gain Register
; bit position masks
mNB_ACQ_GAIN_IGAIN: equ    %00000111


;*** NB_ACQ_GCB - PGA gain; 0x00000363 ***
NB_ACQ_GCB:         equ    $00000363                                ;*** NB_ACQ_GCB - PGA gain; 0x00000363 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_GCB_Dlo:     equ    0                                         ; Gain Control Block (GCB) - Down Threshold
NB_ACQ_GCB_Dhi:     equ    4                                         ; Gain Control Block (GCB) - Up Threshold
; bit position masks
mNB_ACQ_GCB_Dlo:    equ    %00001111
mNB_ACQ_GCB_Dhi:    equ    %11110000


;*** NB_ACQ_ITEMP - Internal temperature measurement result; 0x00000364 ***
NB_ACQ_ITEMP:       equ    $00000364                                ;*** NB_ACQ_ITEMP - Internal temperature measurement result; 0x00000364 ***


;*** NB_ACQ_ITEMPH - Internal temperature measurement result high; 0x00000364 ***
NB_ACQ_ITEMPH:      equ    $00000364                                ;*** NB_ACQ_ITEMPH - Internal temperature measurement result high; 0x00000364 ***


;*** NB_ACQ_ITEMPL - Internal temperature measurement result low; 0x00000365 ***
NB_ACQ_ITEMPL:      equ    $00000365                                ;*** NB_ACQ_ITEMPL - Internal temperature measurement result low; 0x00000365 ***


;*** NB_ACQ_ETEMP - External temperature measurement result; 0x00000366 ***
NB_ACQ_ETEMP:       equ    $00000366                                ;*** NB_ACQ_ETEMP - External temperature measurement result; 0x00000366 ***


;*** NB_ACQ_ETEMPH - External temperature measurement result high; 0x00000366 ***
NB_ACQ_ETEMPH:      equ    $00000366                                ;*** NB_ACQ_ETEMPH - External temperature measurement result high; 0x00000366 ***


;*** NB_ACQ_ETEMPL - External temperature measurement result low; 0x00000367 ***
NB_ACQ_ETEMPL:      equ    $00000367                                ;*** NB_ACQ_ETEMPL - External temperature measurement result low; 0x00000367 ***


;*** NB_ACQ_CURR1 - Current measurement result 16Bit; 0x00000368 ***
NB_ACQ_CURR1:       equ    $00000368                                ;*** NB_ACQ_CURR1 - Current measurement result 16Bit; 0x00000368 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_CURR1_CURR:  equ    8                                         ; Two's complement 24 Bit signed integer result register for the current measurement channel
; bit position masks
mNB_ACQ_CURR1_CURR: equ    %1111111100000000


;*** NB_ACQ_CURR1L - Current measurement result 8Bit; 0x00000369 ***
NB_ACQ_CURR1L:      equ    $00000369                                ;*** NB_ACQ_CURR1L - Current measurement result 8Bit; 0x00000369 ***


;*** NB_ACQ_CURR0 - Current measurement result; 0x0000036A ***
NB_ACQ_CURR0:       equ    $0000036A                                ;*** NB_ACQ_CURR0 - Current measurement result; 0x0000036A ***


;*** NB_ACQ_VOLT - Voltage measurement result; 0x0000036C ***
NB_ACQ_VOLT:        equ    $0000036C                                ;*** NB_ACQ_VOLT - Voltage measurement result; 0x0000036C ***


;*** NB_ACQ_LPFC - Low pass filter coefficient number; 0x0000036E ***
NB_ACQ_LPFC:        equ    $0000036E                                ;*** NB_ACQ_LPFC - Low pass filter coefficient number; 0x0000036E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_LPFC_LPFC:   equ    0                                         ; Low Pass Filter Coefficient Number
; bit position masks
mNB_ACQ_LPFC_LPFC:  equ    %00001111


;*** NB_ACQ_TCMP - Low power trigger current measurement period; 0x00000370 ***
NB_ACQ_TCMP:        equ    $00000370                                ;*** NB_ACQ_TCMP - Low power trigger current measurement period; 0x00000370 ***


;*** NB_ACQ_THF - Low power current threshold filtering period; 0x00000372 ***
NB_ACQ_THF:         equ    $00000372                                ;*** NB_ACQ_THF - Low power current threshold filtering period; 0x00000372 ***


;*** NB_ACQ_CVCR - I and V chopper control register; 0x00000374 ***
NB_ACQ_CVCR:        equ    $00000374                                ;*** NB_ACQ_CVCR - I and V chopper control register; 0x00000374 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_CVCR_PGAF:   equ    0                                         ; PGA fast mode enable
NB_ACQ_CVCR_IIRC:   equ    1                                         ; IIR Low Pass Filter Coefficient
NB_ACQ_CVCR_DBT:    equ    4                                         ; Hold Time After Chopper Swap
NB_ACQ_CVCR_PGAFM:  equ    8                                         ; PGA fast mode enable - Mask
NB_ACQ_CVCR_IIRCM:  equ    9                                         ; IIR Low Pass Filter Configuration - Mask
NB_ACQ_CVCR_DBTM:   equ    12                                        ; Hold Time After Chopper Swap - Mask
; bit position masks
mNB_ACQ_CVCR_PGAF:  equ    %00000001
mNB_ACQ_CVCR_IIRC:  equ    %00001110
mNB_ACQ_CVCR_DBT:   equ    %00110000
mNB_ACQ_CVCR_PGAFM: equ    %100000000
mNB_ACQ_CVCR_IIRCM: equ    %111000000000
mNB_ACQ_CVCR_DBTM:  equ    %11000000000000


;*** NB_ACQ_CVCRH - I and V chopper control register high; 0x00000374 ***
NB_ACQ_CVCRH:       equ    $00000374                                ;*** NB_ACQ_CVCRH - I and V chopper control register high; 0x00000374 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_CVCRH_PGAFM: equ    0                                         ; PGA fast mode enable - Mask
NB_ACQ_CVCRH_IIRCM: equ    1                                         ; IIR Low Pass Filter Configuration - Mask
NB_ACQ_CVCRH_DBTM:  equ    4                                         ; Hold Time After Chopper Swap - Mask
; bit position masks
mNB_ACQ_CVCRH_PGAFM: equ    %00000001
mNB_ACQ_CVCRH_IIRCM: equ    %00001110
mNB_ACQ_CVCRH_DBTM: equ    %00110000


;*** NB_ACQ_CVCRL - I and V chopper control register high low; 0x00000375 ***
NB_ACQ_CVCRL:       equ    $00000375                                ;*** NB_ACQ_CVCRL - I and V chopper control register high low; 0x00000375 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_CVCRL_PGAF:  equ    0                                         ; PGA fast mode enable
NB_ACQ_CVCRL_IIRC:  equ    1                                         ; IIR Low Pass Filter Coefficient
NB_ACQ_CVCRL_DBT:   equ    4                                         ; Hold Time After Chopper Swap
; bit position masks
mNB_ACQ_CVCRL_PGAF: equ    %00000001
mNB_ACQ_CVCRL_IIRC: equ    %00001110
mNB_ACQ_CVCRL_DBT:  equ    %00110000


;*** NB_ACQ_CTH - Low power current threshold; 0x00000376 ***
NB_ACQ_CTH:         equ    $00000376                                ;*** NB_ACQ_CTH - Low power current threshold; 0x00000376 ***


;*** NB_ACQ_AHTH - Low power Ah counter threshold; 0x00000378 ***
NB_ACQ_AHTH:        equ    $00000378                                ;*** NB_ACQ_AHTH - Low power Ah counter threshold; 0x00000378 ***


;*** NB_ACQ_AHTH1 - Low power Ah counter threshold 1; 0x00000378 ***
NB_ACQ_AHTH1:       equ    $00000378                                ;*** NB_ACQ_AHTH1 - Low power Ah counter threshold 1; 0x00000378 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_AHTH1_AHTH:  equ    0                                         ; Low power Ah counter threshold 1
; bit position masks
mNB_ACQ_AHTH1_AHTH: equ    %111111111111111


;*** NB_ACQ_AHTH1H - Low power Ah counter threshold 1 high; 0x00000378 ***
NB_ACQ_AHTH1H:      equ    $00000378                                ;*** NB_ACQ_AHTH1H - Low power Ah counter threshold 1 high; 0x00000378 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACQ_AHTH1H_AHTH: equ    0                                         ; Low power Ah counter threshold 1 high
; bit position masks
mNB_ACQ_AHTH1H_AHTH: equ    %01111111


;*** NB_ACQ_AHTH1L - Low power Ah counter threshold 1 low; 0x00000379 ***
NB_ACQ_AHTH1L:      equ    $00000379                                ;*** NB_ACQ_AHTH1L - Low power Ah counter threshold 1 low; 0x00000379 ***


;*** NB_ACQ_AHTH0 - Low power Ah counter threshold 0; 0x0000037A ***
NB_ACQ_AHTH0:       equ    $0000037A                                ;*** NB_ACQ_AHTH0 - Low power Ah counter threshold 0; 0x0000037A ***


;*** NB_ACQ_AHTH0H - Low power Ah counter threshold 0 high; 0x0000037A ***
NB_ACQ_AHTH0H:      equ    $0000037A                                ;*** NB_ACQ_AHTH0H - Low power Ah counter threshold 0 high; 0x0000037A ***


;*** NB_ACQ_AHTH0L - Low power Ah counter threshold 0 low; 0x0000037B ***
NB_ACQ_AHTH0L:      equ    $0000037B                                ;*** NB_ACQ_AHTH0L - Low power Ah counter threshold 0 low; 0x0000037B ***


;*** NB_ACQ_AHC - Low power Ah counter; 0x0000037C ***
NB_ACQ_AHC:         equ    $0000037C                                ;*** NB_ACQ_AHC - Low power Ah counter; 0x0000037C ***


;*** NB_ACQ_AHC1 - Low power Ah counter 1; 0x0000037C ***
NB_ACQ_AHC1:        equ    $0000037C                                ;*** NB_ACQ_AHC1 - Low power Ah counter 1; 0x0000037C ***


;*** NB_ACQ_AHC1H - Low power Ah counter 1 high; 0x0000037C ***
NB_ACQ_AHC1H:       equ    $0000037C                                ;*** NB_ACQ_AHC1H - Low power Ah counter 1 high; 0x0000037C ***


;*** NB_ACQ_AHC1L - Low power Ah counter 1 low; 0x0000037D ***
NB_ACQ_AHC1L:       equ    $0000037D                                ;*** NB_ACQ_AHC1L - Low power Ah counter 1 low; 0x0000037D ***


;*** NB_ACQ_AHC0 - Low power Ah counter 0; 0x0000037E ***
NB_ACQ_AHC0:        equ    $0000037E                                ;*** NB_ACQ_AHC0 - Low power Ah counter 0; 0x0000037E ***


;*** NB_ACQ_AHC0H - Low power Ah counter 0 high; 0x0000037E ***
NB_ACQ_AHC0H:       equ    $0000037E                                ;*** NB_ACQ_AHC0H - Low power Ah counter 0 high; 0x0000037E ***


;*** NB_ACQ_AHC0L - Low power Ah counter 0 low; 0x0000037F ***
NB_ACQ_AHC0L:       equ    $0000037F                                ;*** NB_ACQ_AHC0L - Low power Ah counter 0 low; 0x0000037F ***


;*** NB_LPF_A0 - Low Pass Filter Coefficient A0; 0x00000380 ***
NB_LPF_A0:          equ    $00000380                                ;*** NB_LPF_A0 - Low Pass Filter Coefficient A0; 0x00000380 ***


;*** NB_LPF_A0H - Low Pass Filter Coefficient A0 high; 0x00000380 ***
NB_LPF_A0H:         equ    $00000380                                ;*** NB_LPF_A0H - Low Pass Filter Coefficient A0 high; 0x00000380 ***


;*** NB_LPF_A0L - Low Pass Filter Coefficient A0 low; 0x00000381 ***
NB_LPF_A0L:         equ    $00000381                                ;*** NB_LPF_A0L - Low Pass Filter Coefficient A0 low; 0x00000381 ***


;*** NB_LPF_A1 - Low Pass Filter Coefficient A1; 0x00000382 ***
NB_LPF_A1:          equ    $00000382                                ;*** NB_LPF_A1 - Low Pass Filter Coefficient A1; 0x00000382 ***


;*** NB_LPF_A1H - Low Pass Filter Coefficient A1 high; 0x00000382 ***
NB_LPF_A1H:         equ    $00000382                                ;*** NB_LPF_A1H - Low Pass Filter Coefficient A1 high; 0x00000382 ***


;*** NB_LPF_A1L - Low Pass Filter Coefficient A1 low; 0x00000383 ***
NB_LPF_A1L:         equ    $00000383                                ;*** NB_LPF_A1L - Low Pass Filter Coefficient A1 low; 0x00000383 ***


;*** NB_LPF_A2 - Low Pass Filter Coefficient A2; 0x00000384 ***
NB_LPF_A2:          equ    $00000384                                ;*** NB_LPF_A2 - Low Pass Filter Coefficient A2; 0x00000384 ***


;*** NB_LPF_A2H - Low Pass Filter Coefficient A2 high; 0x00000384 ***
NB_LPF_A2H:         equ    $00000384                                ;*** NB_LPF_A2H - Low Pass Filter Coefficient A2 high; 0x00000384 ***


;*** NB_LPF_A2L - Low Pass Filter Coefficient A2 low; 0x00000385 ***
NB_LPF_A2L:         equ    $00000385                                ;*** NB_LPF_A2L - Low Pass Filter Coefficient A2 low; 0x00000385 ***


;*** NB_LPF_A3 - Low Pass Filter Coefficient A3; 0x00000386 ***
NB_LPF_A3:          equ    $00000386                                ;*** NB_LPF_A3 - Low Pass Filter Coefficient A3; 0x00000386 ***


;*** NB_LPF_A3H - Low Pass Filter Coefficient A3 high; 0x00000386 ***
NB_LPF_A3H:         equ    $00000386                                ;*** NB_LPF_A3H - Low Pass Filter Coefficient A3 high; 0x00000386 ***


;*** NB_LPF_A3L - Low Pass Filter Coefficient A3 low; 0x00000387 ***
NB_LPF_A3L:         equ    $00000387                                ;*** NB_LPF_A3L - Low Pass Filter Coefficient A3 low; 0x00000387 ***


;*** NB_LPF_A4 - Low Pass Filter Coefficient A4; 0x00000388 ***
NB_LPF_A4:          equ    $00000388                                ;*** NB_LPF_A4 - Low Pass Filter Coefficient A4; 0x00000388 ***


;*** NB_LPF_A4H - Low Pass Filter Coefficient A4 high; 0x00000388 ***
NB_LPF_A4H:         equ    $00000388                                ;*** NB_LPF_A4H - Low Pass Filter Coefficient A4 high; 0x00000388 ***


;*** NB_LPF_A4L - Low Pass Filter Coefficient A4 low; 0x00000389 ***
NB_LPF_A4L:         equ    $00000389                                ;*** NB_LPF_A4L - Low Pass Filter Coefficient A4 low; 0x00000389 ***


;*** NB_LPF_A5 - Low Pass Filter Coefficient A5; 0x0000038A ***
NB_LPF_A5:          equ    $0000038A                                ;*** NB_LPF_A5 - Low Pass Filter Coefficient A5; 0x0000038A ***


;*** NB_LPF_A5H - Low Pass Filter Coefficient A5 high; 0x0000038A ***
NB_LPF_A5H:         equ    $0000038A                                ;*** NB_LPF_A5H - Low Pass Filter Coefficient A5 high; 0x0000038A ***


;*** NB_LPF_A5L - Low Pass Filter Coefficient A5 low; 0x0000038B ***
NB_LPF_A5L:         equ    $0000038B                                ;*** NB_LPF_A5L - Low Pass Filter Coefficient A5 low; 0x0000038B ***


;*** NB_LPF_A6 - Low Pass Filter Coefficient A6; 0x0000038C ***
NB_LPF_A6:          equ    $0000038C                                ;*** NB_LPF_A6 - Low Pass Filter Coefficient A6; 0x0000038C ***


;*** NB_LPF_A6H - Low Pass Filter Coefficient A6 high; 0x0000038C ***
NB_LPF_A6H:         equ    $0000038C                                ;*** NB_LPF_A6H - Low Pass Filter Coefficient A6 high; 0x0000038C ***


;*** NB_LPF_A6L - Low Pass Filter Coefficient A6 low; 0x0000038D ***
NB_LPF_A6L:         equ    $0000038D                                ;*** NB_LPF_A6L - Low Pass Filter Coefficient A6 low; 0x0000038D ***


;*** NB_LPF_A7 - Low Pass Filter Coefficient A7; 0x0000038E ***
NB_LPF_A7:          equ    $0000038E                                ;*** NB_LPF_A7 - Low Pass Filter Coefficient A7; 0x0000038E ***


;*** NB_LPF_A7H - Low Pass Filter Coefficient A7 high; 0x0000038E ***
NB_LPF_A7H:         equ    $0000038E                                ;*** NB_LPF_A7H - Low Pass Filter Coefficient A7 high; 0x0000038E ***


;*** NB_LPF_A7L - Low Pass Filter Coefficient A7 low; 0x0000038F ***
NB_LPF_A7L:         equ    $0000038F                                ;*** NB_LPF_A7L - Low Pass Filter Coefficient A7 low; 0x0000038F ***


;*** NB_LPF_A8 - Low Pass Filter Coefficient A8; 0x00000390 ***
NB_LPF_A8:          equ    $00000390                                ;*** NB_LPF_A8 - Low Pass Filter Coefficient A8; 0x00000390 ***


;*** NB_LPF_A8H - Low Pass Filter Coefficient A8 high; 0x00000390 ***
NB_LPF_A8H:         equ    $00000390                                ;*** NB_LPF_A8H - Low Pass Filter Coefficient A8 high; 0x00000390 ***


;*** NB_LPF_A8L - Low Pass Filter Coefficient A8 low; 0x00000391 ***
NB_LPF_A8L:         equ    $00000391                                ;*** NB_LPF_A8L - Low Pass Filter Coefficient A8 low; 0x00000391 ***


;*** NB_LPF_A9 - Low Pass Filter Coefficient A9; 0x00000392 ***
NB_LPF_A9:          equ    $00000392                                ;*** NB_LPF_A9 - Low Pass Filter Coefficient A9; 0x00000392 ***


;*** NB_LPF_A9H - Low Pass Filter Coefficient A9 high; 0x00000392 ***
NB_LPF_A9H:         equ    $00000392                                ;*** NB_LPF_A9H - Low Pass Filter Coefficient A9 high; 0x00000392 ***


;*** NB_LPF_A9L - Low Pass Filter Coefficient A9 low; 0x00000393 ***
NB_LPF_A9L:         equ    $00000393                                ;*** NB_LPF_A9L - Low Pass Filter Coefficient A9 low; 0x00000393 ***


;*** NB_LPF_A10 - Low Pass Filter Coefficient A10; 0x00000394 ***
NB_LPF_A10:         equ    $00000394                                ;*** NB_LPF_A10 - Low Pass Filter Coefficient A10; 0x00000394 ***


;*** NB_LPF_A10H - Low Pass Filter Coefficient A10 high; 0x00000394 ***
NB_LPF_A10H:        equ    $00000394                                ;*** NB_LPF_A10H - Low Pass Filter Coefficient A10 high; 0x00000394 ***


;*** NB_LPF_A10L - Low Pass Filter Coefficient A10 low; 0x00000395 ***
NB_LPF_A10L:        equ    $00000395                                ;*** NB_LPF_A10L - Low Pass Filter Coefficient A10 low; 0x00000395 ***


;*** NB_LPF_A11 - Low Pass Filter Coefficient A11; 0x00000396 ***
NB_LPF_A11:         equ    $00000396                                ;*** NB_LPF_A11 - Low Pass Filter Coefficient A11; 0x00000396 ***


;*** NB_LPF_A11H - Low Pass Filter Coefficient A11 high; 0x00000396 ***
NB_LPF_A11H:        equ    $00000396                                ;*** NB_LPF_A11H - Low Pass Filter Coefficient A11 high; 0x00000396 ***


;*** NB_LPF_A11L - Low Pass Filter Coefficient A11 low; 0x00000397 ***
NB_LPF_A11L:        equ    $00000397                                ;*** NB_LPF_A11L - Low Pass Filter Coefficient A11 low; 0x00000397 ***


;*** NB_LPF_A12 - Low Pass Filter Coefficient A12; 0x00000398 ***
NB_LPF_A12:         equ    $00000398                                ;*** NB_LPF_A12 - Low Pass Filter Coefficient A12; 0x00000398 ***


;*** NB_LPF_A12H - Low Pass Filter Coefficient A12 high; 0x00000398 ***
NB_LPF_A12H:        equ    $00000398                                ;*** NB_LPF_A12H - Low Pass Filter Coefficient A12 high; 0x00000398 ***


;*** NB_LPF_A12L - Low Pass Filter Coefficient A12 low; 0x00000399 ***
NB_LPF_A12L:        equ    $00000399                                ;*** NB_LPF_A12L - Low Pass Filter Coefficient A12 low; 0x00000399 ***


;*** NB_LPF_A13 - Low Pass Filter Coefficient A13; 0x0000039A ***
NB_LPF_A13:         equ    $0000039A                                ;*** NB_LPF_A13 - Low Pass Filter Coefficient A13; 0x0000039A ***


;*** NB_LPF_A13H - Low Pass Filter Coefficient A13 high; 0x0000039A ***
NB_LPF_A13H:        equ    $0000039A                                ;*** NB_LPF_A13H - Low Pass Filter Coefficient A13 high; 0x0000039A ***


;*** NB_LPF_A13L - Low Pass Filter Coefficient A13 low; 0x0000039B ***
NB_LPF_A13L:        equ    $0000039B                                ;*** NB_LPF_A13L - Low Pass Filter Coefficient A13 low; 0x0000039B ***


;*** NB_LPF_A14 - Low Pass Filter Coefficient A14; 0x0000039C ***
NB_LPF_A14:         equ    $0000039C                                ;*** NB_LPF_A14 - Low Pass Filter Coefficient A14; 0x0000039C ***


;*** NB_LPF_A14H - Low Pass Filter Coefficient A14 high; 0x0000039C ***
NB_LPF_A14H:        equ    $0000039C                                ;*** NB_LPF_A14H - Low Pass Filter Coefficient A14 high; 0x0000039C ***


;*** NB_LPF_A14L - Low Pass Filter Coefficient A14 low; 0x0000039D ***
NB_LPF_A14L:        equ    $0000039D                                ;*** NB_LPF_A14L - Low Pass Filter Coefficient A14 low; 0x0000039D ***


;*** NB_LPF_A15 - Low Pass Filter Coefficient A15; 0x0000039E ***
NB_LPF_A15:         equ    $0000039E                                ;*** NB_LPF_A15 - Low Pass Filter Coefficient A15; 0x0000039E ***


;*** NB_LPF_A15H - Low Pass Filter Coefficient A15 high; 0x0000039E ***
NB_LPF_A15H:        equ    $0000039E                                ;*** NB_LPF_A15H - Low Pass Filter Coefficient A15 high; 0x0000039E ***


;*** NB_LPF_A15L - Low Pass Filter Coefficient A15 low; 0x0000039F ***
NB_LPF_A15L:        equ    $0000039F                                ;*** NB_LPF_A15L - Low Pass Filter Coefficient A15 low; 0x0000039F ***


;*** NB_COMP_CTL - Compensation control register; 0x000003A0 ***
NB_COMP_CTL:        equ    $000003A0                                ;*** NB_COMP_CTL - Compensation control register; 0x000003A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_CTL_CALIE:  equ    0                                         ; Calibration IRQ Enable
NB_COMP_CTL_DIAGI:  equ    2                                         ; Diagnostic Mode Current Channel
NB_COMP_CTL_DIAGV:  equ    3                                         ; Diagnostic Mode Voltage Channel
NB_COMP_CTL_PGAO:   equ    4                                         ; PGA Offset Calibration Start
NB_COMP_CTL_PGAZ:   equ    5                                         ; PGA Input Zero
NB_COMP_CTL_BGCAL:  equ    6                                         ; Calibration Band Gap Select
NB_COMP_CTL_CALIEM: equ    8                                         ; Calibration IRQ Enable - Mask
NB_COMP_CTL_DIAGIM: equ    10                                        ; Diagnostic Mode Current Channel - Mask
NB_COMP_CTL_DIAGVM: equ    11                                        ; Diagnostic Mode Voltage Channel - Mask
NB_COMP_CTL_PGAOM:  equ    12                                        ; PGA Offset Calibration - Mask
NB_COMP_CTL_PGAZM:  equ    13                                        ; PGA Input Zero - Mask
NB_COMP_CTL_BGCALM: equ    14                                        ; Calibration Band Gap Select - Mask
; bit position masks
mNB_COMP_CTL_CALIE: equ    %00000001
mNB_COMP_CTL_DIAGI: equ    %00000100
mNB_COMP_CTL_DIAGV: equ    %00001000
mNB_COMP_CTL_PGAO:  equ    %00010000
mNB_COMP_CTL_PGAZ:  equ    %00100000
mNB_COMP_CTL_BGCAL: equ    %11000000
mNB_COMP_CTL_CALIEM: equ    %100000000
mNB_COMP_CTL_DIAGIM: equ    %10000000000
mNB_COMP_CTL_DIAGVM: equ    %100000000000
mNB_COMP_CTL_PGAOM: equ    %1000000000000
mNB_COMP_CTL_PGAZM: equ    %10000000000000
mNB_COMP_CTL_BGCALM: equ    %1100000000000000


;*** NB_COMP_SR - Compensation status register; 0x000003A2 ***
NB_COMP_SR:         equ    $000003A2                                ;*** NB_COMP_SR - Compensation status register; 0x000003A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_SR_CALF:    equ    0                                         ; Calibration Request Status Flag
NB_COMP_SR_PGAOF:   equ    4                                         ; PGA Internal Offset Compensation Complete Flag
NB_COMP_SR_BGFR:    equ    6                                         ; Band Gap Reference Status Flag
; bit position masks
mNB_COMP_SR_CALF:   equ    %00000001
mNB_COMP_SR_PGAOF:  equ    %00010000
mNB_COMP_SR_BGFR:   equ    %01000000


;*** NB_COMP_TF - Temperature filtering period; 0x000003A3 ***
NB_COMP_TF:         equ    $000003A3                                ;*** NB_COMP_TF - Temperature filtering period; 0x000003A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_TF_TMF:     equ    0                                         ; Recalibration Temperature Filtering Period
; bit position masks
mNB_COMP_TF_TMF:    equ    %00000111


;*** NB_COMP_TMAX - Max temp before recalibration; 0x000003A4 ***
NB_COMP_TMAX:       equ    $000003A4                                ;*** NB_COMP_TMAX - Max temp before recalibration; 0x000003A4 ***


;*** NB_COMP_TMIN - Min temp before recalibration; 0x000003A6 ***
NB_COMP_TMIN:       equ    $000003A6                                ;*** NB_COMP_TMIN - Min temp before recalibration; 0x000003A6 ***


;*** NB_COMP_VO - Offset voltage compensation; 0x000003AA ***
NB_COMP_VO:         equ    $000003AA                                ;*** NB_COMP_VO - Offset voltage compensation; 0x000003AA ***


;*** NB_COMP_IO - Offset current compensation window; 0x000003AB ***
NB_COMP_IO:         equ    $000003AB                                ;*** NB_COMP_IO - Offset current compensation window; 0x000003AB ***


;*** NB_COMP_VSG - Gain voltage compensation vsense channel; 0x000003AC ***
NB_COMP_VSG:        equ    $000003AC                                ;*** NB_COMP_VSG - Gain voltage compensation vsense channel; 0x000003AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_VSG_VSGC:   equ    0                                         ; Voltage Channel Gain Compensation Buffer
; bit position masks
mNB_COMP_VSG_VSGC:  equ    %1111111111


;*** NB_COMP_IG4 - Gain Current Compensation 4; 0x000003B0 ***
NB_COMP_IG4:        equ    $000003B0                                ;*** NB_COMP_IG4 - Gain Current Compensation 4; 0x000003B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_IG4_IGC4:   equ    0                                         ; Current Gain Compensation Buffer 4
; bit position masks
mNB_COMP_IG4_IGC4:  equ    %1111111111


;*** NB_COMP_IG8 - Gain Current Compensation 8; 0x000003B2 ***
NB_COMP_IG8:        equ    $000003B2                                ;*** NB_COMP_IG8 - Gain Current Compensation 8; 0x000003B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_IG8_IGC8:   equ    0                                         ; Current Gain Compensation Buffer 8
; bit position masks
mNB_COMP_IG8_IGC8:  equ    %1111111111


;*** NB_COMP_IG16 - Gain Current Compensation 16; 0x000003B4 ***
NB_COMP_IG16:       equ    $000003B4                                ;*** NB_COMP_IG16 - Gain Current Compensation 16; 0x000003B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_IG16_IGC16: equ    0                                         ; Current Gain Compensation Buffer 16
; bit position masks
mNB_COMP_IG16_IGC16: equ    %1111111111


;*** NB_COMP_IG32 - Gain Current Compensation 32; 0x000003B6 ***
NB_COMP_IG32:       equ    $000003B6                                ;*** NB_COMP_IG32 - Gain Current Compensation 32; 0x000003B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_IG32_IGC32: equ    0                                         ; Current Gain Compensation Buffer 32
; bit position masks
mNB_COMP_IG32_IGC32: equ    %1111111111


;*** NB_COMP_IG64 - Gain Current Compensation 64; 0x000003B8 ***
NB_COMP_IG64:       equ    $000003B8                                ;*** NB_COMP_IG64 - Gain Current Compensation 64; 0x000003B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_IG64_IGC64: equ    0                                         ; Current Gain Compensation Buffer 64
; bit position masks
mNB_COMP_IG64_IGC64: equ    %1111111111


;*** NB_COMP_IG128 - Gain Current Compensation 128; 0x000003BA ***
NB_COMP_IG128:      equ    $000003BA                                ;*** NB_COMP_IG128 - Gain Current Compensation 128; 0x000003BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_IG128_IGC128: equ    0                                       ; Current Gain Compensation Buffer 128
; bit position masks
mNB_COMP_IG128_IGC128: equ    %1111111111


;*** NB_COMP_IG256 - Gain Current Compensation 256; 0x000003BC ***
NB_COMP_IG256:      equ    $000003BC                                ;*** NB_COMP_IG256 - Gain Current Compensation 256; 0x000003BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_IG256_IGC256: equ    0                                       ; Current Gain Compensation Buffer 256
; bit position masks
mNB_COMP_IG256_IGC256: equ    %1111111111


;*** NB_COMP_IG512 - Gain Current Compensation 512; 0x000003BE ***
NB_COMP_IG512:      equ    $000003BE                                ;*** NB_COMP_IG512 - Gain Current Compensation 512; 0x000003BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_IG512_IGC512: equ    0                                       ; Current Gain Compensation Buffer 512
; bit position masks
mNB_COMP_IG512_IGC512: equ    %1111111111


;*** NB_COMP_PGAO4 - Offset PGA compensation 4; 0x000003C0 ***
NB_COMP_PGAO4:      equ    $000003C0                                ;*** NB_COMP_PGAO4 - Offset PGA compensation 4; 0x000003C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_PGAO4_PGAOC4: equ    0                                       ; PGA Offset Compensation Buffer 4
; bit position masks
mNB_COMP_PGAO4_PGAOC4: equ    %11111111111


;*** NB_COMP_PGAO8 - Offset PGA compensation 8; 0x000003C2 ***
NB_COMP_PGAO8:      equ    $000003C2                                ;*** NB_COMP_PGAO8 - Offset PGA compensation 8; 0x000003C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_PGAO8_PGAOC8: equ    0                                       ; PGA Offset Compensation Buffer 8
; bit position masks
mNB_COMP_PGAO8_PGAOC8: equ    %11111111111


;*** NB_COMP_PGAO16 - Offset PGA compensation 16; 0x000003C4 ***
NB_COMP_PGAO16:     equ    $000003C4                                ;*** NB_COMP_PGAO16 - Offset PGA compensation 16; 0x000003C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_PGAO16_PGAOC16: equ    0                                     ; PGA Offset Compensation Buffer 16
; bit position masks
mNB_COMP_PGAO16_PGAOC16: equ    %11111111111


;*** NB_COMP_PGAO32 - Offset PGA compensation 32; 0x000003C6 ***
NB_COMP_PGAO32:     equ    $000003C6                                ;*** NB_COMP_PGAO32 - Offset PGA compensation 32; 0x000003C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_PGAO32_PGAOC32: equ    0                                     ; PGA Offset Compensation Buffer 32
; bit position masks
mNB_COMP_PGAO32_PGAOC32: equ    %11111111111


;*** NB_COMP_PGAO64 - Offset PGA compensation 64; 0x000003C8 ***
NB_COMP_PGAO64:     equ    $000003C8                                ;*** NB_COMP_PGAO64 - Offset PGA compensation 64; 0x000003C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_PGAO64_PGAOC64: equ    0                                     ; PGA Offset Compensation Buffer 64
; bit position masks
mNB_COMP_PGAO64_PGAOC64: equ    %11111111111


;*** NB_COMP_PGAO128 - Offset PGA compensation 128; 0x000003CA ***
NB_COMP_PGAO128:    equ    $000003CA                                ;*** NB_COMP_PGAO128 - Offset PGA compensation 128; 0x000003CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_PGAO128_PGAOC128: equ    0                                   ; PGA Offset Compensation Buffer 128
; bit position masks
mNB_COMP_PGAO128_PGAOC128: equ    %11111111111


;*** NB_COMP_PGAO256 - Offset PGA compensation 256; 0x000003CC ***
NB_COMP_PGAO256:    equ    $000003CC                                ;*** NB_COMP_PGAO256 - Offset PGA compensation 256; 0x000003CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_PGAO256_PGAOC256: equ    0                                   ; PGA Offset Compensation Buffer 256
; bit position masks
mNB_COMP_PGAO256_PGAOC256: equ    %11111111111


;*** NB_COMP_PGAO512 - Offset PGA compensation 512; 0x000003CE ***
NB_COMP_PGAO512:    equ    $000003CE                                ;*** NB_COMP_PGAO512 - Offset PGA compensation 512; 0x000003CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_COMP_PGAO512_PGAOC512: equ    0                                   ; PGA Offset Compensation Buffer 512
; bit position masks
mNB_COMP_PGAO512_PGAOC512: equ    %11111111111


;*** NB_COMP_ITO - Internal temperature offset compensation; 0x000003D0 ***
NB_COMP_ITO:        equ    $000003D0                                ;*** NB_COMP_ITO - Internal temperature offset compensation; 0x000003D0 ***


;*** NB_COMP_ITG - Internal temperature gain compensation; 0x000003D1 ***
NB_COMP_ITG:        equ    $000003D1                                ;*** NB_COMP_ITG - Internal temperature gain compensation; 0x000003D1 ***


;*** NB_COMP_ETO - External temperature offset compensation; 0x000003D2 ***
NB_COMP_ETO:        equ    $000003D2                                ;*** NB_COMP_ETO - External temperature offset compensation; 0x000003D2 ***


;*** NB_COMP_ETG - External temperature gain compensation; 0x000003D3 ***
NB_COMP_ETG:        equ    $000003D3                                ;*** NB_COMP_ETG - External temperature gain compensation; 0x000003D3 ***


;*** NB_TRIM_BG0 - Trim bandgap 0; 0x000003E0 ***
NB_TRIM_BG0:        equ    $000003E0                                ;*** NB_TRIM_BG0 - Trim bandgap 0; 0x000003E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG0_IBG1:   equ    0             
NB_TRIM_BG0_IBG2:   equ    3             
NB_TRIM_BG0_TCIBG1: equ    8             
NB_TRIM_BG0_TCIBG2: equ    11             
; bit position masks
mNB_TRIM_BG0_IBG1:  equ    %00000111
mNB_TRIM_BG0_IBG2:  equ    %00111000
mNB_TRIM_BG0_TCIBG1: equ    %11100000000
mNB_TRIM_BG0_TCIBG2: equ    %11100000000000


;*** NB_TRIM_BG0H - Trim bandgap 0 high; 0x000003E0 ***
NB_TRIM_BG0H:       equ    $000003E0                                ;*** NB_TRIM_BG0H - Trim bandgap 0 high; 0x000003E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG0H_TCIBG1: equ    0             
NB_TRIM_BG0H_TCIBG2: equ    3             
; bit position masks
mNB_TRIM_BG0H_TCIBG1: equ    %00000111
mNB_TRIM_BG0H_TCIBG2: equ    %00111000


;*** NB_TRIM_BG0L - Trim bandgap 0 low; 0x000003E1 ***
NB_TRIM_BG0L:       equ    $000003E1                                ;*** NB_TRIM_BG0L - Trim bandgap 0 low; 0x000003E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG0L_IBG1:  equ    0             
NB_TRIM_BG0L_IBG2:  equ    3             
; bit position masks
mNB_TRIM_BG0L_IBG1: equ    %00000111
mNB_TRIM_BG0L_IBG2: equ    %00111000


;*** NB_TRIM_BG1 - Trim bandgap 1; 0x000003E2 ***
NB_TRIM_BG1:        equ    $000003E2                                ;*** NB_TRIM_BG1 - Trim bandgap 1; 0x000003E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG1_SLPBG:  equ    0             
NB_TRIM_BG1_TCBG1:  equ    8             
NB_TRIM_BG1_TCBG2:  equ    11             
NB_TRIM_BG1_DBG3:   equ    14             
NB_TRIM_BG1_UBG3:   equ    15             
; bit position masks
mNB_TRIM_BG1_SLPBG: equ    %00000111
mNB_TRIM_BG1_TCBG1: equ    %11100000000
mNB_TRIM_BG1_TCBG2: equ    %11100000000000
mNB_TRIM_BG1_DBG3:  equ    %100000000000000
mNB_TRIM_BG1_UBG3:  equ    %1000000000000000


;*** NB_TRIM_BG1H - Trim bandgap 1 high; 0x000003E2 ***
NB_TRIM_BG1H:       equ    $000003E2                                ;*** NB_TRIM_BG1H - Trim bandgap 1 high; 0x000003E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG1H_TCBG1: equ    0             
NB_TRIM_BG1H_TCBG2: equ    3             
NB_TRIM_BG1H_DBG3:  equ    6             
NB_TRIM_BG1H_UBG3:  equ    7             
; bit position masks
mNB_TRIM_BG1H_TCBG1: equ    %00000111
mNB_TRIM_BG1H_TCBG2: equ    %00111000
mNB_TRIM_BG1H_DBG3: equ    %01000000
mNB_TRIM_BG1H_UBG3: equ    %10000000


;*** NB_TRIM_BG1L - Trim bandgap 1 low; 0x000003E3 ***
NB_TRIM_BG1L:       equ    $000003E3                                ;*** NB_TRIM_BG1L - Trim bandgap 1 low; 0x000003E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG1L_SLPBG: equ    0             
; bit position masks
mNB_TRIM_BG1L_SLPBG: equ    %00000111


;*** NB_TRIM_BG2 - Trim bandgap 2; 0x000003E4 ***
NB_TRIM_BG2:        equ    $000003E4                                ;*** NB_TRIM_BG2 - Trim bandgap 2; 0x000003E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG2_V2P5BG1: equ    0             
NB_TRIM_BG2_V2P5BG2: equ    4             
NB_TRIM_BG2_V1P2BG1: equ    8             
NB_TRIM_BG2_V1P2BG2: equ    12             
; bit position masks
mNB_TRIM_BG2_V2P5BG1: equ    %00001111
mNB_TRIM_BG2_V2P5BG2: equ    %11110000
mNB_TRIM_BG2_V1P2BG1: equ    %111100000000
mNB_TRIM_BG2_V1P2BG2: equ    %1111000000000000


;*** NB_TRIM_BG2H - Trim bandgap 2 high; 0x000003E4 ***
NB_TRIM_BG2H:       equ    $000003E4                                ;*** NB_TRIM_BG2H - Trim bandgap 2 high; 0x000003E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG2H_V1P2BG1: equ    0             
NB_TRIM_BG2H_V1P2BG2: equ    4             
; bit position masks
mNB_TRIM_BG2H_V1P2BG1: equ    %00001111
mNB_TRIM_BG2H_V1P2BG2: equ    %11110000


;*** NB_TRIM_BG2L - Trim bandgap 2 low; 0x000003E5 ***
NB_TRIM_BG2L:       equ    $000003E5                                ;*** NB_TRIM_BG2L - Trim bandgap 2 low; 0x000003E5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_BG2L_V2P5BG1: equ    0             
NB_TRIM_BG2L_V2P5BG2: equ    4             
; bit position masks
mNB_TRIM_BG2L_V2P5BG1: equ    %00001111
mNB_TRIM_BG2L_V2P5BG2: equ    %11110000


;*** NB_TRIM_LIN - Trim lin; 0x000003E6 ***
NB_TRIM_LIN:        equ    $000003E6                                ;*** NB_TRIM_LIN - Trim lin; 0x000003E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_LIN_LIN:    equ    0             
; bit position masks
mNB_TRIM_LIN_LIN:   equ    %00000001


;*** NB_TRIM_LVT - Trim low voltage threshold; 0x000003E7 ***
NB_TRIM_LVT:        equ    $000003E7                                ;*** NB_TRIM_LVT - Trim low voltage threshold; 0x000003E7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_LVT_LVT:    equ    0             
; bit position masks
mNB_TRIM_LVT_LVT:   equ    %00000001


;*** NB_TRIM_OSC - Trim LP oscillator; 0x000003E8 ***
NB_TRIM_OSC:        equ    $000003E8                                ;*** NB_TRIM_OSC - Trim LP oscillator; 0x000003E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_OSC_LPOSC:  equ    0             
; bit position masks
mNB_TRIM_OSC_LPOSC: equ    %1111111111111


;*** NB_TRIM_OSCH - Trim LP oscillator high; 0x000003E8 ***
NB_TRIM_OSCH:       equ    $000003E8                                ;*** NB_TRIM_OSCH - Trim LP oscillator high; 0x000003E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TRIM_OSCH_LPOSC: equ    0             
; bit position masks
mNB_TRIM_OSCH_LPOSC: equ    %00011111


;*** NB_TRIM_OSCL - Trim LP oscillator low; 0x000003E9 ***
NB_TRIM_OSCL:       equ    $000003E9                                ;*** NB_TRIM_OSCL - Trim LP oscillator low; 0x000003E9 ***


;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
NVFPROT:            equ    $0000FF0C                                ;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT_FPLS0:      equ    0                                         ; Flash Protection Lower Address Size Bit 0
NVFPROT_FPLS1:      equ    1                                         ; Flash Protection Lower Address Size Bit 1
NVFPROT_FPLDIS:     equ    2                                         ; Flash Protection Lower Address Range Disable
NVFPROT_FPHS0:      equ    3                                         ; Flash Protection Higher Address Size Bit 0
NVFPROT_FPHS1:      equ    4                                         ; Flash Protection Higher Address Size Bit 1
NVFPROT_FPHDIS:     equ    5                                         ; Flash Protection Higher Address Range Disable
NVFPROT_RNV6:       equ    6                                         ; Reserved Nonvolatile Bit
NVFPROT_FPOPEN:     equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mNVFPROT_FPLS0:     equ    %00000001
mNVFPROT_FPLS1:     equ    %00000010
mNVFPROT_FPLDIS:    equ    %00000100
mNVFPROT_FPHS0:     equ    %00001000
mNVFPROT_FPHS1:     equ    %00010000
mNVFPROT_FPHDIS:    equ    %00100000
mNVFPROT_RNV6:      equ    %01000000
mNVFPROT_FPOPEN:    equ    %10000000


;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
NVDFPROT:           equ    $0000FF0D                                ;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVDFPROT_DPS0:      equ    0                                         ; D-Flash Protection Size Bit 0
NVDFPROT_DPS1:      equ    1                                         ; D-Flash Protection Size Bit 1
NVDFPROT_DPS2:      equ    2                                         ; D-Flash Protection Size Bit 2
NVDFPROT_DPS3:      equ    3                                         ; D-Flash Protection Size Bit 3
NVDFPROT_DPOPEN:    equ    7                                         ; D-Flash Protection Control
; bit position masks
mNVDFPROT_DPS0:     equ    %00000001
mNVDFPROT_DPS1:     equ    %00000010
mNVDFPROT_DPS2:     equ    %00000100
mNVDFPROT_DPS3:     equ    %00001000
mNVDFPROT_DPOPEN:   equ    %10000000


;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
NVFOPT:             equ    $0000FF0E                                ;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFOPT_NV0:         equ    0                                         ; Nonvolatile Bit 0
NVFOPT_NV1:         equ    1                                         ; Nonvolatile Bit 1
NVFOPT_NV2:         equ    2                                         ; Nonvolatile Bit 2
NVFOPT_NV3:         equ    3                                         ; Nonvolatile Bit 3
NVFOPT_NV4:         equ    4                                         ; Nonvolatile Bit 4
NVFOPT_NV5:         equ    5                                         ; Nonvolatile Bit 5
NVFOPT_NV6:         equ    6                                         ; Nonvolatile Bit 6
NVFOPT_NV7:         equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mNVFOPT_NV0:        equ    %00000001
mNVFOPT_NV1:        equ    %00000010
mNVFOPT_NV2:        equ    %00000100
mNVFOPT_NV3:        equ    %00001000
mNVFOPT_NV4:        equ    %00010000
mNVFOPT_NV5:        equ    %00100000
mNVFOPT_NV6:        equ    %01000000
mNVFOPT_NV7:        equ    %10000000


;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Flash Security Bit 0
NVFSEC_SEC1:        equ    1                                         ; Flash Security Bit 1
NVFSEC_RNV2:        equ    2                                         ; Reserved Nonvolatile Bit 2
NVFSEC_RNV3:        equ    3                                         ; Reserved Nonvolatile Bit 3
NVFSEC_RNV4:        equ    4                                         ; Reserved Nonvolatile Bit 4
NVFSEC_RNV5:        equ    5                                         ; Reserved Nonvolatile Bit 5
NVFSEC_KEYEN0:      equ    6                                         ; Backdoor Key Security Enable Bit 0
NVFSEC_KEYEN1:      equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_RNV2:       equ    %00000100
mNVFSEC_RNV3:       equ    %00001000
mNVFSEC_RNV4:       equ    %00010000
mNVFSEC_RNV5:       equ    %00100000
mNVFSEC_KEYEN0:     equ    %01000000
mNVFSEC_KEYEN1:     equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------



; **** 2/1/2012 3:55:23 PM

        IFNDEF __GENERATE_APPLICATION__
MMCCTL1:                                 equ        This_symb_has_been_depreciated
MMCCTL1_IFRON:                           equ        This_symb_has_been_depreciated
mMMCCTL1_IFRON:                          equ        This_symb_has_been_depreciated
B_PCR_CTL_D2DSM:                         equ        This_symb_has_been_depreciated
B_PCR_CTL_D2DSMM:                        equ        This_symb_has_been_depreciated
mB_PCR_CTL_D2DSM:                        equ        This_symb_has_been_depreciated
mB_PCR_CTL_D2DSMM:                       equ        This_symb_has_been_depreciated
NB_PCR_CTL_D2DSM:                        equ        This_symb_has_been_depreciated
NB_PCR_CTL_D2DSMM:                       equ        This_symb_has_been_depreciated
mNB_PCR_CTL_D2DSM:                       equ        This_symb_has_been_depreciated
mNB_PCR_CTL_D2DSMM:                      equ        This_symb_has_been_depreciated
        ENDIF

; EOF
