/* Based on CPU DB MM912J637_48, version 3.00.000 (RegistersPrg V2.33) */
/*
** ###################################################################
**     Filename  : mm912i637.h
**     Processor : MM912I637
**     FileFormat: V2.33
**     DataSheet : MM912_637D1 Rev. 2.0, 8/2011
**     Compiler  : CodeWarrior compiler
**     Date/Time : 9.2.2012, 16:02
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 30.1.2012, V3.00.0:
**              - Registers updated according to the new reference manual revision - MM912_637D1 Rev. 2.0, 8/2011
**              - MMC: Removed register MMCCTL1.
**              - PCR: Removed D2DSMM, D2DSM bits from CTL register.
**              - LIN: Added Transmitter Ready Status(RDY) into SR register.
**              - GPIO: Corrected address of GPIO_IN1,GPIO_OUT1.
**              - WDOG: Added WDTST bit into CTL register.
**
**     File-Format-Revisions:
**      - 15.09.2010, V2.33 :
**               - Empty union is not generated for data overlapping registers, cause there is no bit access
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MM912I637_H
#define _MM912I637_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vsi                63U
#define VectorNumber_VReserved62        62U
#define VectorNumber_VReserved61        61U
#define VectorNumber_VReserved60        60U
#define VectorNumber_VReserved59        59U
#define VectorNumber_Vlvi               58U
#define VectorNumber_VReserved57        57U
#define VectorNumber_VReserved56        56U
#define VectorNumber_VReserved55        55U
#define VectorNumber_VReserved54        54U
#define VectorNumber_VReserved53        53U
#define VectorNumber_VReserved52        52U
#define VectorNumber_VReserved51        51U
#define VectorNumber_VReserved50        50U
#define VectorNumber_VReserved49        49U
#define VectorNumber_VReserved48        48U
#define VectorNumber_VReserved47        47U
#define VectorNumber_VReserved46        46U
#define VectorNumber_VReserved45        45U
#define VectorNumber_VReserved44        44U
#define VectorNumber_VReserved43        43U
#define VectorNumber_VReserved42        42U
#define VectorNumber_VReserved41        41U
#define VectorNumber_VReserved40        40U
#define VectorNumber_VReserved39        39U
#define VectorNumber_VReserved38        38U
#define VectorNumber_VReserved37        37U
#define VectorNumber_VReserved36        36U
#define VectorNumber_Vflash             35U
#define VectorNumber_Vflashfd           34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_VReserved32        32U
#define VectorNumber_VReserved31        31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_VReserved29        29U
#define VectorNumber_Vcpmuplllck        28U
#define VectorNumber_Vcpmuocsns         27U
#define VectorNumber_VReserved26        26U
#define VectorNumber_VReserved25        25U
#define VectorNumber_VReserved24        24U
#define VectorNumber_VReserved23        23U
#define VectorNumber_VReserved22        22U
#define VectorNumber_VReserved21        21U
#define VectorNumber_VReserved20        20U
#define VectorNumber_Vspi               19U
#define VectorNumber_VReserved18        18U
#define VectorNumber_VReserved17        17U
#define VectorNumber_VReserved16        16U
#define VectorNumber_VReserved15        15U
#define VectorNumber_VReserved14        14U
#define VectorNumber_VReserved13        13U
#define VectorNumber_VReserved12        12U
#define VectorNumber_VReserved11        11U
#define VectorNumber_VReserved10        10U
#define VectorNumber_VReserved9         9U
#define VectorNumber_VReserved8         8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Vd2di_ext          6U
#define VectorNumber_Vd2di_err          5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define Vsi                             0xFF80U
#define VReserved62                     0xFF82U
#define VReserved61                     0xFF84U
#define VReserved60                     0xFF86U
#define VReserved59                     0xFF88U
#define Vlvi                            0xFF8AU
#define VReserved57                     0xFF8CU
#define VReserved56                     0xFF8EU
#define VReserved55                     0xFF90U
#define VReserved54                     0xFF92U
#define VReserved53                     0xFF94U
#define VReserved52                     0xFF96U
#define VReserved51                     0xFF98U
#define VReserved50                     0xFF9AU
#define VReserved49                     0xFF9CU
#define VReserved48                     0xFF9EU
#define VReserved47                     0xFFA0U
#define VReserved46                     0xFFA2U
#define VReserved45                     0xFFA4U
#define VReserved44                     0xFFA6U
#define VReserved43                     0xFFA8U
#define VReserved42                     0xFFAAU
#define VReserved41                     0xFFACU
#define VReserved40                     0xFFAEU
#define VReserved39                     0xFFB0U
#define VReserved38                     0xFFB2U
#define VReserved37                     0xFFB4U
#define VReserved36                     0xFFB6U
#define Vflash                          0xFFB8U
#define Vflashfd                        0xFFBAU
#define VReserved33                     0xFFBCU
#define VReserved32                     0xFFBEU
#define VReserved31                     0xFFC0U
#define VReserved30                     0xFFC2U
#define VReserved29                     0xFFC4U
#define Vcpmuplllck                     0xFFC6U
#define Vcpmuocsns                      0xFFC8U
#define VReserved26                     0xFFCAU
#define VReserved25                     0xFFCCU
#define VReserved24                     0xFFCEU
#define VReserved23                     0xFFD0U
#define VReserved22                     0xFFD2U
#define VReserved21                     0xFFD4U
#define VReserved20                     0xFFD6U
#define Vspi                            0xFFD8U
#define VReserved18                     0xFFDAU
#define VReserved17                     0xFFDCU
#define VReserved16                     0xFFDEU
#define VReserved15                     0xFFE0U
#define VReserved14                     0xFFE2U
#define VReserved13                     0xFFE4U
#define VReserved12                     0xFFE6U
#define VReserved11                     0xFFE8U
#define VReserved10                     0xFFEAU
#define VReserved9                      0xFFECU
#define VReserved8                      0xFFEEU
#define Vrti                            0xFFF0U
#define Vd2di_ext                       0xFFF2U
#define Vd2di_err                       0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTA - Port A Data Register; 0x00000000 ***/
typedef union {
  byte Byte;
  struct {
    byte PA0         :1;                                       /* Port A Bit 0 */
    byte PA1         :1;                                       /* Port A Bit 1 */
    byte PA2         :1;                                       /* Port A Bit 2 */
    byte PA3         :1;                                       /* Port A Bit 3 */
    byte PA4         :1;                                       /* Port A Bit 4 */
    byte PA5         :1;                                       /* Port A Bit 5 */
    byte PA6         :1;                                       /* Port A Bit 6 */
    byte PA7         :1;                                       /* Port A Bit 7 */
  } Bits;
} PORTASTR;
extern volatile PORTASTR _PORTA @(REG_BASE + 0x00000000UL);
#define PORTA                           _PORTA.Byte
#define PORTA_PA0                       _PORTA.Bits.PA0
#define PORTA_PA1                       _PORTA.Bits.PA1
#define PORTA_PA2                       _PORTA.Bits.PA2
#define PORTA_PA3                       _PORTA.Bits.PA3
#define PORTA_PA4                       _PORTA.Bits.PA4
#define PORTA_PA5                       _PORTA.Bits.PA5
#define PORTA_PA6                       _PORTA.Bits.PA6
#define PORTA_PA7                       _PORTA.Bits.PA7

#define PORTA_PA0_MASK                  1U
#define PORTA_PA1_MASK                  2U
#define PORTA_PA2_MASK                  4U
#define PORTA_PA3_MASK                  8U
#define PORTA_PA4_MASK                  16U
#define PORTA_PA5_MASK                  32U
#define PORTA_PA6_MASK                  64U
#define PORTA_PA7_MASK                  128U


/*** PTE - Port E Data Register; 0x00000001 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Port E Bit 0 */
    byte PE1         :1;                                       /* Port E Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPE   :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTESTR;
extern volatile PTESTR _PTE @(REG_BASE + 0x00000001UL);
#define PTE                             _PTE.Byte
#define PTE_PE0                         _PTE.Bits.PE0
#define PTE_PE1                         _PTE.Bits.PE1
#define PTE_PE                          _PTE.MergedBits.grpPE

#define PTE_PE0_MASK                    1U
#define PTE_PE1_MASK                    2U
#define PTE_PE_MASK                     3U
#define PTE_PE_BITNUM                   0U


/*** DDRA - Port A Data Direction Register; 0x00000002 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
    byte DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
    byte DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
    byte DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
    byte DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
    byte DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
    byte DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
    byte DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
} DDRASTR;
extern volatile DDRASTR _DDRA @(REG_BASE + 0x00000002UL);
#define DDRA                            _DDRA.Byte
#define DDRA_DDRA0                      _DDRA.Bits.DDRA0
#define DDRA_DDRA1                      _DDRA.Bits.DDRA1
#define DDRA_DDRA2                      _DDRA.Bits.DDRA2
#define DDRA_DDRA3                      _DDRA.Bits.DDRA3
#define DDRA_DDRA4                      _DDRA.Bits.DDRA4
#define DDRA_DDRA5                      _DDRA.Bits.DDRA5
#define DDRA_DDRA6                      _DDRA.Bits.DDRA6
#define DDRA_DDRA7                      _DDRA.Bits.DDRA7

#define DDRA_DDRA0_MASK                 1U
#define DDRA_DDRA1_MASK                 2U
#define DDRA_DDRA2_MASK                 4U
#define DDRA_DDRA3_MASK                 8U
#define DDRA_DDRA4_MASK                 16U
#define DDRA_DDRA5_MASK                 32U
#define DDRA_DDRA6_MASK                 64U
#define DDRA_DDRA7_MASK                 128U


/*** DDRE - Port E Data Direction Register; 0x00000003 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRE0       :1;                                       /* Data Direction Port E Bit 0 */
    byte DDRE1       :1;                                       /* Data Direction Port E Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRE :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000003UL);
#define DDRE                            _DDRE.Byte
#define DDRE_DDRE0                      _DDRE.Bits.DDRE0
#define DDRE_DDRE1                      _DDRE.Bits.DDRE1
#define DDRE_DDRE                       _DDRE.MergedBits.grpDDRE

#define DDRE_DDRE0_MASK                 1U
#define DDRE_DDRE1_MASK                 2U
#define DDRE_DDRE_MASK                  3U
#define DDRE_DDRE_BITNUM                0U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODC        :1;                                       /* Mode Select Bit */
  } Bits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_MODC                       _MODE.Bits.MODC

#define MODE_MODC_MASK                  128U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PDPEE       :1;                                       /* Pull-down Port E Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BKPUE       :1;                                       /* BKGD and VREGEN Pin Pull-up Enable */
    byte             :1; 
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PDPEE                      _PUCR.Bits.PDPEE
#define PUCR_BKPUE                      _PUCR.Bits.BKPUE

#define PUCR_PDPEE_MASK                 2U
#define PUCR_BKPUE_MASK                 64U


/*** RDRIV - Reduced Drive Register; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte RDPC        :1;                                       /* Reduced Drive of Port C */
    byte RDPD        :1;                                       /* Reduced Drive of Port D */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPC                      _RDRIV.Bits.RDPC
#define RDRIV_RDPD                      _RDRIV.Bits.RDPD

#define RDRIV_RDPC_MASK                 4U
#define RDRIV_RDPD_MASK                 8U


/*** DIRECT - Direct Page Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Index Bit 8 */
    byte DP9         :1;                                       /* Direct Page Index Bit 9 */
    byte DP10        :1;                                       /* Direct Page Index Bit 10 */
    byte DP11        :1;                                       /* Direct Page Index Bit 11 */
    byte DP12        :1;                                       /* Direct Page Index Bit 12 */
    byte DP13        :1;                                       /* Direct Page Index Bit 13 */
    byte DP14        :1;                                       /* Direct Page Index Bit 14 */
    byte DP15        :1;                                       /* Direct Page Index Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000011UL);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1U
#define DIRECT_DP9_MASK                 2U
#define DIRECT_DP10_MASK                4U
#define DIRECT_DP11_MASK                8U
#define DIRECT_DP12_MASK                16U
#define DIRECT_DP13_MASK                32U
#define DIRECT_DP14_MASK                64U
#define DIRECT_DP15_MASK                128U


/*** PPAGE - Program Page Index Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIX  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000015UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX                       _PPAGE.MergedBits.grpPIX

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX_MASK                  15U
#define PPAGE_PIX_BITNUM                0U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** IVBR - Interrupt Vector Base Register; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte IVB_ADDR0   :1;                                       /* Interrupt Vector Base Address Bits, bit 0 */
    byte IVB_ADDR1   :1;                                       /* Interrupt Vector Base Address Bits, bit 1 */
    byte IVB_ADDR2   :1;                                       /* Interrupt Vector Base Address Bits, bit 2 */
    byte IVB_ADDR3   :1;                                       /* Interrupt Vector Base Address Bits, bit 3 */
    byte IVB_ADDR4   :1;                                       /* Interrupt Vector Base Address Bits, bit 4 */
    byte IVB_ADDR5   :1;                                       /* Interrupt Vector Base Address Bits, bit 5 */
    byte IVB_ADDR6   :1;                                       /* Interrupt Vector Base Address Bits, bit 6 */
    byte IVB_ADDR7   :1;                                       /* Interrupt Vector Base Address Bits, bit 7 */
  } Bits;
} IVBRSTR;
extern volatile IVBRSTR _IVBR @(REG_BASE + 0x0000001FUL);
#define IVBR                            _IVBR.Byte
#define IVBR_IVB_ADDR0                  _IVBR.Bits.IVB_ADDR0
#define IVBR_IVB_ADDR1                  _IVBR.Bits.IVB_ADDR1
#define IVBR_IVB_ADDR2                  _IVBR.Bits.IVB_ADDR2
#define IVBR_IVB_ADDR3                  _IVBR.Bits.IVB_ADDR3
#define IVBR_IVB_ADDR4                  _IVBR.Bits.IVB_ADDR4
#define IVBR_IVB_ADDR5                  _IVBR.Bits.IVB_ADDR5
#define IVBR_IVB_ADDR6                  _IVBR.Bits.IVB_ADDR6
#define IVBR_IVB_ADDR7                  _IVBR.Bits.IVB_ADDR7

#define IVBR_IVB_ADDR0_MASK             1U
#define IVBR_IVB_ADDR1_MASK             2U
#define IVBR_IVB_ADDR2_MASK             4U
#define IVBR_IVB_ADDR3_MASK             8U
#define IVBR_IVB_ADDR4_MASK             16U
#define IVBR_IVB_ADDR5_MASK             32U
#define IVBR_IVB_ADDR6_MASK             64U
#define IVBR_IVB_ADDR7_MASK             128U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte COMRV0      :1;                                       /* Comparator Register Visibility Bits, bit 0 */
    byte COMRV1      :1;                                       /* Comparator Register Visibility Bits, bit 1 */
    byte             :1; 
    byte DBGBRK      :1;                                       /* S12XDBG Breakpoint Enable Bit 1 */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte             :1; 
    byte TRIG        :1;                                       /* Immediate Trigger Request Bit */
    byte ARM         :1;                                       /* Arm Bit */
  } Bits;
  struct {
    byte grpCOMRV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_COMRV0                    _DBGC1.Bits.COMRV0
#define DBGC1_COMRV1                    _DBGC1.Bits.COMRV1
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BDM                       _DBGC1.Bits.BDM
#define DBGC1_TRIG                      _DBGC1.Bits.TRIG
#define DBGC1_ARM                       _DBGC1.Bits.ARM
#define DBGC1_COMRV                     _DBGC1.MergedBits.grpCOMRV

#define DBGC1_COMRV0_MASK               1U
#define DBGC1_COMRV1_MASK               2U
#define DBGC1_DBGBRK_MASK               8U
#define DBGC1_BDM_MASK                  16U
#define DBGC1_TRIG_MASK                 64U
#define DBGC1_ARM_MASK                  128U
#define DBGC1_COMRV_MASK                3U
#define DBGC1_COMRV_BITNUM              0U


/*** DBGSR - Debug Status Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSF0        :1;                                       /* State Sequencer Flag Bits */
    byte SSF1        :1;                                       /* State Sequencer Flag Bit 1 */
    byte SSF2        :1;                                       /* State Sequencer Flag Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpSSF  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSRSTR;
extern volatile DBGSRSTR _DBGSR @(REG_BASE + 0x00000021UL);
#define DBGSR                           _DBGSR.Byte
#define DBGSR_SSF0                      _DBGSR.Bits.SSF0
#define DBGSR_SSF1                      _DBGSR.Bits.SSF1
#define DBGSR_SSF2                      _DBGSR.Bits.SSF2
#define DBGSR_TBF                       _DBGSR.Bits.TBF
#define DBGSR_SSF                       _DBGSR.MergedBits.grpSSF

#define DBGSR_SSF0_MASK                 1U
#define DBGSR_SSF1_MASK                 2U
#define DBGSR_SSF2_MASK                 4U
#define DBGSR_TBF_MASK                  128U
#define DBGSR_SSF_MASK                  7U
#define DBGSR_SSF_BITNUM                0U


/*** DBGTCR - Debug Trace Control Register; 0x00000022 ***/
typedef union {
  byte Byte;
  struct {
    byte TALIGN      :1;                                       /* Trigger Align Bit */
    byte             :1; 
    byte TRCMOD0     :1;                                       /* Trace Mode Bits, bit 0 */
    byte TRCMOD1     :1;                                       /* Trace Mode Bits, bit 1 */
    byte             :1; 
    byte             :1; 
    byte TSOURCE     :1;                                       /* Trace Source Control Bits */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTRCMOD :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGTCRSTR;
extern volatile DBGTCRSTR _DBGTCR @(REG_BASE + 0x00000022UL);
#define DBGTCR                          _DBGTCR.Byte
#define DBGTCR_TALIGN                   _DBGTCR.Bits.TALIGN
#define DBGTCR_TRCMOD0                  _DBGTCR.Bits.TRCMOD0
#define DBGTCR_TRCMOD1                  _DBGTCR.Bits.TRCMOD1
#define DBGTCR_TSOURCE                  _DBGTCR.Bits.TSOURCE
#define DBGTCR_TRCMOD                   _DBGTCR.MergedBits.grpTRCMOD

#define DBGTCR_TALIGN_MASK              1U
#define DBGTCR_TRCMOD0_MASK             4U
#define DBGTCR_TRCMOD1_MASK             8U
#define DBGTCR_TSOURCE_MASK             64U
#define DBGTCR_TRCMOD_MASK              12U
#define DBGTCR_TRCMOD_BITNUM            2U


/*** DBGC2 - Debug Control Register 2; 0x00000023 ***/
typedef union {
  byte Byte;
  struct {
    byte ABCM0       :1;                                       /* A and B Comparator Match Control, bit 0 */
    byte ABCM1       :1;                                       /* A and B Comparator Match Control, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABCM :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000023UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_ABCM0                     _DBGC2.Bits.ABCM0
#define DBGC2_ABCM1                     _DBGC2.Bits.ABCM1
#define DBGC2_ABCM                      _DBGC2.MergedBits.grpABCM

#define DBGC2_ABCM0_MASK                1U
#define DBGC2_ABCM1_MASK                2U
#define DBGC2_ABCM_MASK                 3U
#define DBGC2_ABCM_BITNUM               0U


/*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Trace Buffer Data Bits */
        byte BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
        byte BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
        byte BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
        byte BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
        byte BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
        byte BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
        byte BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Trace Buffer Data Bits */
        byte BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
        byte BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
        byte BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
        byte BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
        byte BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
        byte BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
        byte BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Trace Buffer Data Bits */
    word BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
    word BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
    word BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
    word BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
    word BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
    word BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
    word BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
    word BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
    word BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
    word BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
    word BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
    word BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
    word BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
    word BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
    word BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000024UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000026 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT0        :1;                                       /* Count Value, bit 0 */
    byte CNT1        :1;                                       /* Count Value, bit 1 */
    byte CNT2        :1;                                       /* Count Value, bit 2 */
    byte CNT3        :1;                                       /* Count Value, bit 3 */
    byte CNT4        :1;                                       /* Count Value, bit 4 */
    byte CNT5        :1;                                       /* Count Value, bit 5 */
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpCNT  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000026UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT0                     _DBGCNT.Bits.CNT0
#define DBGCNT_CNT1                     _DBGCNT.Bits.CNT1
#define DBGCNT_CNT2                     _DBGCNT.Bits.CNT2
#define DBGCNT_CNT3                     _DBGCNT.Bits.CNT3
#define DBGCNT_CNT4                     _DBGCNT.Bits.CNT4
#define DBGCNT_CNT5                     _DBGCNT.Bits.CNT5
#define DBGCNT_TBF                      _DBGCNT.Bits.TBF
#define DBGCNT_CNT                      _DBGCNT.MergedBits.grpCNT

#define DBGCNT_CNT0_MASK                1U
#define DBGCNT_CNT1_MASK                2U
#define DBGCNT_CNT2_MASK                4U
#define DBGCNT_CNT3_MASK                8U
#define DBGCNT_CNT4_MASK                16U
#define DBGCNT_CNT5_MASK                32U
#define DBGCNT_TBF_MASK                 128U
#define DBGCNT_CNT_MASK                 63U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGSCRX - Debug State Control Register; 0x00000027 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** DBGSCRX - Debug State Control Register; Several registers at the same address ***/
    union {
      struct {
        byte SC0         :1;                                       /* State X Sequencer Next State Selection Bit 0 */
        byte SC1         :1;                                       /* State X Sequencer Next State Selection Bit 1 */
        byte SC2         :1;                                       /* State X Sequencer Next State Selection Bit 2 */
        byte SC3         :1;                                       /* State X Sequencer Next State Selection Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGSCRXSTR;
    #define DBGSCRX                     _DBGSCRX.Byte
    #define DBGSCRX_SC0                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC0
    #define DBGSCRX_SC1                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC1
    #define DBGSCRX_SC2                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC2
    #define DBGSCRX_SC3                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC3
    #define DBGSCRX_SC                  _DBGSCRX.SameAddr_STR.DBGSCRXSTR.MergedBits.grpSC
    
    #define DBGSCRX_SC0_MASK            1U
    #define DBGSCRX_SC1_MASK            2U
    #define DBGSCRX_SC2_MASK            4U
    #define DBGSCRX_SC3_MASK            8U
    #define DBGSCRX_SC_MASK             15U
    #define DBGSCRX_SC_BITNUM           0U
    
    /*** DBGMFR - Debug Match Flag Register; Several registers at the same address ***/
    union {
      struct {
        byte MC0         :1;                                       /* Debug Match Flag Bit 0 */
        byte MC1         :1;                                       /* Debug Match Flag Bit 1 */
        byte MC2         :1;                                       /* Debug Match Flag Bit 2 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpMC :3;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGMFRSTR;
    #define DBGMFR                      _DBGSCRX.Byte
    #define DBGMFR_MC0                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC0
    #define DBGMFR_MC1                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC1
    #define DBGMFR_MC2                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC2
    #define DBGMFR_MC                   _DBGSCRX.SameAddr_STR.DBGMFRSTR.MergedBits.grpMC
    
    #define DBGMFR_MC0_MASK             1U
    #define DBGMFR_MC1_MASK             2U
    #define DBGMFR_MC2_MASK             4U
    #define DBGMFR_MC_MASK              7U
    #define DBGMFR_MC_BITNUM            0U
    
  } SameAddr_STR; /*Several registers at the same address */

} DBGSCRXSTR;
extern volatile DBGSCRXSTR _DBGSCRX @(REG_BASE + 0x00000027UL);


/*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte COMPE       :1;                                       /* Determines if comparator is enabled */
    byte NDB         :1;                                       /* Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D) */
    byte RWE         :1;                                       /* Read/Write Enable Bit */
    byte RW          :1;                                       /* Read/Write Comparator Value Bit */
    byte BRK         :1;                                       /* Break */
    byte TAG         :1;                                       /* Tag Select */
    byte SZ          :1;                                       /* Size Comparator Value Bit */
    byte SZE         :1;                                       /* Size Comparator Enable Bit */
  } Bits;
} DBGXCTLSTR;
extern volatile DBGXCTLSTR _DBGXCTL @(REG_BASE + 0x00000028UL);
#define DBGXCTL                         _DBGXCTL.Byte
#define DBGXCTL_COMPE                   _DBGXCTL.Bits.COMPE
#define DBGXCTL_NDB                     _DBGXCTL.Bits.NDB
#define DBGXCTL_RWE                     _DBGXCTL.Bits.RWE
#define DBGXCTL_RW                      _DBGXCTL.Bits.RW
#define DBGXCTL_BRK                     _DBGXCTL.Bits.BRK
#define DBGXCTL_TAG                     _DBGXCTL.Bits.TAG
#define DBGXCTL_SZ                      _DBGXCTL.Bits.SZ
#define DBGXCTL_SZE                     _DBGXCTL.Bits.SZE

#define DBGXCTL_COMPE_MASK              1U
#define DBGXCTL_NDB_MASK                2U
#define DBGXCTL_RWE_MASK                4U
#define DBGXCTL_RW_MASK                 8U
#define DBGXCTL_BRK_MASK                16U
#define DBGXCTL_TAG_MASK                32U
#define DBGXCTL_SZ_MASK                 64U
#define DBGXCTL_SZE_MASK                128U


/*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT16       :1;                                       /* Comparator Address High Compare Bits */
    byte BIT17       :1;                                       /* Comparator Address High Compare Bit 17 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpBIT_16 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGXAHSTR;
extern volatile DBGXAHSTR _DBGXAH @(REG_BASE + 0x00000029UL);
#define DBGXAH                          _DBGXAH.Byte
#define DBGXAH_BIT16                    _DBGXAH.Bits.BIT16
#define DBGXAH_BIT17                    _DBGXAH.Bits.BIT17
#define DBGXAH_BIT_16                   _DBGXAH.MergedBits.grpBIT_16
#define DBGXAH_BIT                      DBGXAH_BIT_16

#define DBGXAH_BIT16_MASK               1U
#define DBGXAH_BIT17_MASK               2U
#define DBGXAH_BIT_16_MASK              3U
#define DBGXAH_BIT_16_BITNUM            0U


/*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Address Mid Compare Bits */
    byte BIT9        :1;                                       /* Comparator Address Mid Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Address Mid Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Address Mid Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Address Mid Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Address Mid Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Address Mid Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Address Mid Compare Bit 15 */
  } Bits;
} DBGXAMSTR;
extern volatile DBGXAMSTR _DBGXAM @(REG_BASE + 0x0000002AUL);
#define DBGXAM                          _DBGXAM.Byte
#define DBGXAM_BIT8                     _DBGXAM.Bits.BIT8
#define DBGXAM_BIT9                     _DBGXAM.Bits.BIT9
#define DBGXAM_BIT10                    _DBGXAM.Bits.BIT10
#define DBGXAM_BIT11                    _DBGXAM.Bits.BIT11
#define DBGXAM_BIT12                    _DBGXAM.Bits.BIT12
#define DBGXAM_BIT13                    _DBGXAM.Bits.BIT13
#define DBGXAM_BIT14                    _DBGXAM.Bits.BIT14
#define DBGXAM_BIT15                    _DBGXAM.Bits.BIT15

#define DBGXAM_BIT8_MASK                1U
#define DBGXAM_BIT9_MASK                2U
#define DBGXAM_BIT10_MASK               4U
#define DBGXAM_BIT11_MASK               8U
#define DBGXAM_BIT12_MASK               16U
#define DBGXAM_BIT13_MASK               32U
#define DBGXAM_BIT14_MASK               64U
#define DBGXAM_BIT15_MASK               128U


/*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bits */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXALSTR;
extern volatile DBGXALSTR _DBGXAL @(REG_BASE + 0x0000002BUL);
#define DBGXAL                          _DBGXAL.Byte
#define DBGXAL_BIT0                     _DBGXAL.Bits.BIT0
#define DBGXAL_BIT1                     _DBGXAL.Bits.BIT1
#define DBGXAL_BIT2                     _DBGXAL.Bits.BIT2
#define DBGXAL_BIT3                     _DBGXAL.Bits.BIT3
#define DBGXAL_BIT4                     _DBGXAL.Bits.BIT4
#define DBGXAL_BIT5                     _DBGXAL.Bits.BIT5
#define DBGXAL_BIT6                     _DBGXAL.Bits.BIT6
#define DBGXAL_BIT7                     _DBGXAL.Bits.BIT7

#define DBGXAL_BIT0_MASK                1U
#define DBGXAL_BIT1_MASK                2U
#define DBGXAL_BIT2_MASK                4U
#define DBGXAL_BIT3_MASK                8U
#define DBGXAL_BIT4_MASK                16U
#define DBGXAL_BIT5_MASK                32U
#define DBGXAL_BIT6_MASK                64U
#define DBGXAL_BIT7_MASK                128U


/*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Compare Bit 15 */
  } Bits;
} DBGADHSTR;
extern volatile DBGADHSTR _DBGADH @(REG_BASE + 0x0000002CUL);
#define DBGADH                          _DBGADH.Byte
#define DBGADH_BIT8                     _DBGADH.Bits.BIT8
#define DBGADH_BIT9                     _DBGADH.Bits.BIT9
#define DBGADH_BIT10                    _DBGADH.Bits.BIT10
#define DBGADH_BIT11                    _DBGADH.Bits.BIT11
#define DBGADH_BIT12                    _DBGADH.Bits.BIT12
#define DBGADH_BIT13                    _DBGADH.Bits.BIT13
#define DBGADH_BIT14                    _DBGADH.Bits.BIT14
#define DBGADH_BIT15                    _DBGADH.Bits.BIT15

#define DBGADH_BIT8_MASK                1U
#define DBGADH_BIT9_MASK                2U
#define DBGADH_BIT10_MASK               4U
#define DBGADH_BIT11_MASK               8U
#define DBGADH_BIT12_MASK               16U
#define DBGADH_BIT13_MASK               32U
#define DBGADH_BIT14_MASK               64U
#define DBGADH_BIT15_MASK               128U


/*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Compare Bit 7 */
  } Bits;
} DBGADLSTR;
extern volatile DBGADLSTR _DBGADL @(REG_BASE + 0x0000002DUL);
#define DBGADL                          _DBGADL.Byte
#define DBGADL_BIT0                     _DBGADL.Bits.BIT0
#define DBGADL_BIT1                     _DBGADL.Bits.BIT1
#define DBGADL_BIT2                     _DBGADL.Bits.BIT2
#define DBGADL_BIT3                     _DBGADL.Bits.BIT3
#define DBGADL_BIT4                     _DBGADL.Bits.BIT4
#define DBGADL_BIT5                     _DBGADL.Bits.BIT5
#define DBGADL_BIT6                     _DBGADL.Bits.BIT6
#define DBGADL_BIT7                     _DBGADL.Bits.BIT7

#define DBGADL_BIT0_MASK                1U
#define DBGADL_BIT1_MASK                2U
#define DBGADL_BIT2_MASK                4U
#define DBGADL_BIT3_MASK                8U
#define DBGADL_BIT4_MASK                16U
#define DBGADL_BIT5_MASK                32U
#define DBGADL_BIT6_MASK                64U
#define DBGADL_BIT7_MASK                128U


/*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Mask Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Mask Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Mask Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Mask Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Mask Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Mask Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Mask Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Mask Bit 15 */
  } Bits;
} DBGADHMSTR;
extern volatile DBGADHMSTR _DBGADHM @(REG_BASE + 0x0000002EUL);
#define DBGADHM                         _DBGADHM.Byte
#define DBGADHM_BIT8                    _DBGADHM.Bits.BIT8
#define DBGADHM_BIT9                    _DBGADHM.Bits.BIT9
#define DBGADHM_BIT10                   _DBGADHM.Bits.BIT10
#define DBGADHM_BIT11                   _DBGADHM.Bits.BIT11
#define DBGADHM_BIT12                   _DBGADHM.Bits.BIT12
#define DBGADHM_BIT13                   _DBGADHM.Bits.BIT13
#define DBGADHM_BIT14                   _DBGADHM.Bits.BIT14
#define DBGADHM_BIT15                   _DBGADHM.Bits.BIT15

#define DBGADHM_BIT8_MASK               1U
#define DBGADHM_BIT9_MASK               2U
#define DBGADHM_BIT10_MASK              4U
#define DBGADHM_BIT11_MASK              8U
#define DBGADHM_BIT12_MASK              16U
#define DBGADHM_BIT13_MASK              32U
#define DBGADHM_BIT14_MASK              64U
#define DBGADHM_BIT15_MASK              128U


/*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Mask Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Mask Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Mask Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Mask Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Mask Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Mask Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Mask Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Mask Bit 7 */
  } Bits;
} DBGADLMSTR;
extern volatile DBGADLMSTR _DBGADLM @(REG_BASE + 0x0000002FUL);
#define DBGADLM                         _DBGADLM.Byte
#define DBGADLM_BIT0                    _DBGADLM.Bits.BIT0
#define DBGADLM_BIT1                    _DBGADLM.Bits.BIT1
#define DBGADLM_BIT2                    _DBGADLM.Bits.BIT2
#define DBGADLM_BIT3                    _DBGADLM.Bits.BIT3
#define DBGADLM_BIT4                    _DBGADLM.Bits.BIT4
#define DBGADLM_BIT5                    _DBGADLM.Bits.BIT5
#define DBGADLM_BIT6                    _DBGADLM.Bits.BIT6
#define DBGADLM_BIT7                    _DBGADLM.Bits.BIT7

#define DBGADLM_BIT0_MASK               1U
#define DBGADLM_BIT1_MASK               2U
#define DBGADLM_BIT2_MASK               4U
#define DBGADLM_BIT3_MASK               8U
#define DBGADLM_BIT4_MASK               16U
#define DBGADLM_BIT5_MASK               32U
#define DBGADLM_BIT6_MASK               64U
#define DBGADLM_BIT7_MASK               128U


/*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYNDIV0     :1;                                       /* Multiplication factor of the IPLL bit 0 */
    byte SYNDIV1     :1;                                       /* Multiplication factor of the IPLL bit 1 */
    byte SYNDIV2     :1;                                       /* Multiplication factor of the IPLL bit 2 */
    byte SYNDIV3     :1;                                       /* Multiplication factor of the IPLL bit 3 */
    byte SYNDIV4     :1;                                       /* Multiplication factor of the IPLL bit 4 */
    byte SYNDIV5     :1;                                       /* Multiplication factor of the IPLL bit 5 */
    byte VCOFRQ0     :1;                                       /* VCO frequency range bit 0 */
    byte VCOFRQ1     :1;                                       /* VCO frequency range bit 1 */
  } Bits;
  struct {
    byte grpSYNDIV :6;
    byte grpVCOFRQ :2;
  } MergedBits;
} CPMUSYNRSTR;
extern volatile CPMUSYNRSTR _CPMUSYNR @(REG_BASE + 0x00000034UL);
#define CPMUSYNR                        _CPMUSYNR.Byte
#define CPMUSYNR_SYNDIV0                _CPMUSYNR.Bits.SYNDIV0
#define CPMUSYNR_SYNDIV1                _CPMUSYNR.Bits.SYNDIV1
#define CPMUSYNR_SYNDIV2                _CPMUSYNR.Bits.SYNDIV2
#define CPMUSYNR_SYNDIV3                _CPMUSYNR.Bits.SYNDIV3
#define CPMUSYNR_SYNDIV4                _CPMUSYNR.Bits.SYNDIV4
#define CPMUSYNR_SYNDIV5                _CPMUSYNR.Bits.SYNDIV5
#define CPMUSYNR_VCOFRQ0                _CPMUSYNR.Bits.VCOFRQ0
#define CPMUSYNR_VCOFRQ1                _CPMUSYNR.Bits.VCOFRQ1
#define CPMUSYNR_SYNDIV                 _CPMUSYNR.MergedBits.grpSYNDIV
#define CPMUSYNR_VCOFRQ                 _CPMUSYNR.MergedBits.grpVCOFRQ

#define CPMUSYNR_SYNDIV0_MASK           1U
#define CPMUSYNR_SYNDIV1_MASK           2U
#define CPMUSYNR_SYNDIV2_MASK           4U
#define CPMUSYNR_SYNDIV3_MASK           8U
#define CPMUSYNR_SYNDIV4_MASK           16U
#define CPMUSYNR_SYNDIV5_MASK           32U
#define CPMUSYNR_VCOFRQ0_MASK           64U
#define CPMUSYNR_VCOFRQ1_MASK           128U
#define CPMUSYNR_SYNDIV_MASK            63U
#define CPMUSYNR_SYNDIV_BITNUM          0U
#define CPMUSYNR_VCOFRQ_MASK            192U
#define CPMUSYNR_VCOFRQ_BITNUM          6U


/*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDIV0     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 0 */
    byte REFDIV1     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 1 */
    byte REFDIV2     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 2 */
    byte REFDIV3     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 3 */
    byte             :1; 
    byte             :1; 
    byte REFFRQ0     :1;                                       /* IPLL optimal stability and lock time configuration bit 0 */
    byte REFFRQ1     :1;                                       /* IPLL optimal stability and lock time configuration bit 1 */
  } Bits;
  struct {
    byte grpREFDIV :4;
    byte         :1;
    byte         :1;
    byte grpREFFRQ :2;
  } MergedBits;
} CPMUREFDIVSTR;
extern volatile CPMUREFDIVSTR _CPMUREFDIV @(REG_BASE + 0x00000035UL);
#define CPMUREFDIV                      _CPMUREFDIV.Byte
#define CPMUREFDIV_REFDIV0              _CPMUREFDIV.Bits.REFDIV0
#define CPMUREFDIV_REFDIV1              _CPMUREFDIV.Bits.REFDIV1
#define CPMUREFDIV_REFDIV2              _CPMUREFDIV.Bits.REFDIV2
#define CPMUREFDIV_REFDIV3              _CPMUREFDIV.Bits.REFDIV3
#define CPMUREFDIV_REFFRQ0              _CPMUREFDIV.Bits.REFFRQ0
#define CPMUREFDIV_REFFRQ1              _CPMUREFDIV.Bits.REFFRQ1
#define CPMUREFDIV_REFDIV               _CPMUREFDIV.MergedBits.grpREFDIV
#define CPMUREFDIV_REFFRQ               _CPMUREFDIV.MergedBits.grpREFFRQ

#define CPMUREFDIV_REFDIV0_MASK         1U
#define CPMUREFDIV_REFDIV1_MASK         2U
#define CPMUREFDIV_REFDIV2_MASK         4U
#define CPMUREFDIV_REFDIV3_MASK         8U
#define CPMUREFDIV_REFFRQ0_MASK         64U
#define CPMUREFDIV_REFFRQ1_MASK         128U
#define CPMUREFDIV_REFDIV_MASK          15U
#define CPMUREFDIV_REFDIV_BITNUM        0U
#define CPMUREFDIV_REFFRQ_MASK          192U
#define CPMUREFDIV_REFFRQ_BITNUM        6U


/*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***/
typedef union {
  byte Byte;
  struct {
    byte POSTDIV0    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 0 */
    byte POSTDIV1    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 1 */
    byte POSTDIV2    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 2 */
    byte POSTDIV3    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 3 */
    byte POSTDIV4    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 4 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPOSTDIV :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CPMUPOSTDIVSTR;
extern volatile CPMUPOSTDIVSTR _CPMUPOSTDIV @(REG_BASE + 0x00000036UL);
#define CPMUPOSTDIV                     _CPMUPOSTDIV.Byte
#define CPMUPOSTDIV_POSTDIV0            _CPMUPOSTDIV.Bits.POSTDIV0
#define CPMUPOSTDIV_POSTDIV1            _CPMUPOSTDIV.Bits.POSTDIV1
#define CPMUPOSTDIV_POSTDIV2            _CPMUPOSTDIV.Bits.POSTDIV2
#define CPMUPOSTDIV_POSTDIV3            _CPMUPOSTDIV.Bits.POSTDIV3
#define CPMUPOSTDIV_POSTDIV4            _CPMUPOSTDIV.Bits.POSTDIV4
#define CPMUPOSTDIV_POSTDIV             _CPMUPOSTDIV.MergedBits.grpPOSTDIV

#define CPMUPOSTDIV_POSTDIV0_MASK       1U
#define CPMUPOSTDIV_POSTDIV1_MASK       2U
#define CPMUPOSTDIV_POSTDIV2_MASK       4U
#define CPMUPOSTDIV_POSTDIV3_MASK       8U
#define CPMUPOSTDIV_POSTDIV4_MASK       16U
#define CPMUPOSTDIV_POSTDIV_MASK        31U
#define CPMUPOSTDIV_POSTDIV_BITNUM      0U


/*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte UPOSC       :1;                                       /* Oscillator Status Bit */
    byte OSCIF       :1;                                       /* Oscillator Interrupt Flag */
    byte ILAF        :1;                                       /* Illegal Address Reset Flag */
    byte LOCK        :1;                                       /* Lock Status Bit */
    byte LOCKIF      :1;                                       /* IPLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CPMUFLGSTR;
extern volatile CPMUFLGSTR _CPMUFLG @(REG_BASE + 0x00000037UL);
#define CPMUFLG                         _CPMUFLG.Byte
#define CPMUFLG_UPOSC                   _CPMUFLG.Bits.UPOSC
#define CPMUFLG_OSCIF                   _CPMUFLG.Bits.OSCIF
#define CPMUFLG_ILAF                    _CPMUFLG.Bits.ILAF
#define CPMUFLG_LOCK                    _CPMUFLG.Bits.LOCK
#define CPMUFLG_LOCKIF                  _CPMUFLG.Bits.LOCKIF
#define CPMUFLG_LVRF                    _CPMUFLG.Bits.LVRF
#define CPMUFLG_PORF                    _CPMUFLG.Bits.PORF
#define CPMUFLG_RTIF                    _CPMUFLG.Bits.RTIF

#define CPMUFLG_UPOSC_MASK              1U
#define CPMUFLG_OSCIF_MASK              2U
#define CPMUFLG_ILAF_MASK               4U
#define CPMUFLG_LOCK_MASK               8U
#define CPMUFLG_LOCKIF_MASK             16U
#define CPMUFLG_LVRF_MASK               32U
#define CPMUFLG_PORF_MASK               64U
#define CPMUFLG_RTIF_MASK               128U


/*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte OSCIE       :1;                                       /* Oscillator Corrupt Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte RTIE        :1;                                       /* Real Time Interrupt Enable Bit */
  } Bits;
} CPMUINTSTR;
extern volatile CPMUINTSTR _CPMUINT @(REG_BASE + 0x00000038UL);
#define CPMUINT                         _CPMUINT.Byte
#define CPMUINT_OSCIE                   _CPMUINT.Bits.OSCIE
#define CPMUINT_LOCKIE                  _CPMUINT.Bits.LOCKIE
#define CPMUINT_RTIE                    _CPMUINT.Bits.RTIE

#define CPMUINT_OSCIE_MASK              2U
#define CPMUINT_LOCKIE_MASK             16U
#define CPMUINT_RTIE_MASK               128U


/*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPOSCSEL   :1;                                       /* COP Clock Select */
    byte RTIOSCSEL   :1;                                       /* RTI Clock Select */
    byte PCE         :1;                                       /* COP Enable During Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable During Pseudo Stop Bit */
    byte             :1; 
    byte             :1; 
    byte PSTP        :1;                                       /* Pseudo Stop Bit */
    byte PLLSEL      :1;                                       /* PLL Select Bit */
  } Bits;
} CPMUCLKSSTR;
extern volatile CPMUCLKSSTR _CPMUCLKS @(REG_BASE + 0x00000039UL);
#define CPMUCLKS                        _CPMUCLKS.Byte
#define CPMUCLKS_COPOSCSEL              _CPMUCLKS.Bits.COPOSCSEL
#define CPMUCLKS_RTIOSCSEL              _CPMUCLKS.Bits.RTIOSCSEL
#define CPMUCLKS_PCE                    _CPMUCLKS.Bits.PCE
#define CPMUCLKS_PRE                    _CPMUCLKS.Bits.PRE
#define CPMUCLKS_PSTP                   _CPMUCLKS.Bits.PSTP
#define CPMUCLKS_PLLSEL                 _CPMUCLKS.Bits.PLLSEL

#define CPMUCLKS_COPOSCSEL_MASK         1U
#define CPMUCLKS_RTIOSCSEL_MASK         2U
#define CPMUCLKS_PCE_MASK               4U
#define CPMUCLKS_PRE_MASK               8U
#define CPMUCLKS_PSTP_MASK              64U
#define CPMUCLKS_PLLSEL_MASK            128U


/*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte FM0         :1;                                       /* PLL Frequency Modulation Enable Bit 0 */
    byte FM1         :1;                                       /* PLL Frequency Modulation Enable Bit 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpFM   :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CPMUPLLSTR;
extern volatile CPMUPLLSTR _CPMUPLL @(REG_BASE + 0x0000003AUL);
#define CPMUPLL                         _CPMUPLL.Byte
#define CPMUPLL_FM0                     _CPMUPLL.Bits.FM0
#define CPMUPLL_FM1                     _CPMUPLL.Bits.FM1
#define CPMUPLL_FM                      _CPMUPLL.MergedBits.grpFM

#define CPMUPLL_FM0_MASK                16U
#define CPMUPLL_FM1_MASK                32U
#define CPMUPLL_FM_MASK                 48U
#define CPMUPLL_FM_BITNUM               4U


/*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte RTDEC       :1;                                       /* Decimal or Binary Divider Select Bit */
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} CPMURTISTR;
extern volatile CPMURTISTR _CPMURTI @(REG_BASE + 0x0000003BUL);
#define CPMURTI                         _CPMURTI.Byte
#define CPMURTI_RTR0                    _CPMURTI.Bits.RTR0
#define CPMURTI_RTR1                    _CPMURTI.Bits.RTR1
#define CPMURTI_RTR2                    _CPMURTI.Bits.RTR2
#define CPMURTI_RTR3                    _CPMURTI.Bits.RTR3
#define CPMURTI_RTR4                    _CPMURTI.Bits.RTR4
#define CPMURTI_RTR5                    _CPMURTI.Bits.RTR5
#define CPMURTI_RTR6                    _CPMURTI.Bits.RTR6
#define CPMURTI_RTDEC                   _CPMURTI.Bits.RTDEC
#define CPMURTI_RTR                     _CPMURTI.MergedBits.grpRTR

#define CPMURTI_RTR0_MASK               1U
#define CPMURTI_RTR1_MASK               2U
#define CPMURTI_RTR2_MASK               4U
#define CPMURTI_RTR3_MASK               8U
#define CPMURTI_RTR4_MASK               16U
#define CPMURTI_RTR5_MASK               32U
#define CPMURTI_RTR6_MASK               64U
#define CPMURTI_RTDEC_MASK              128U
#define CPMURTI_RTR_MASK                127U
#define CPMURTI_RTR_BITNUM              0U


/*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte WRTMASK     :1;                                       /* Write Mask for WCOP */
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CPMUCOPSTR;
extern volatile CPMUCOPSTR _CPMUCOP @(REG_BASE + 0x0000003CUL);
#define CPMUCOP                         _CPMUCOP.Byte
#define CPMUCOP_CR0                     _CPMUCOP.Bits.CR0
#define CPMUCOP_CR1                     _CPMUCOP.Bits.CR1
#define CPMUCOP_CR2                     _CPMUCOP.Bits.CR2
#define CPMUCOP_WRTMASK                 _CPMUCOP.Bits.WRTMASK
#define CPMUCOP_RSBCK                   _CPMUCOP.Bits.RSBCK
#define CPMUCOP_WCOP                    _CPMUCOP.Bits.WCOP
#define CPMUCOP_CR                      _CPMUCOP.MergedBits.grpCR

#define CPMUCOP_CR0_MASK                1U
#define CPMUCOP_CR1_MASK                2U
#define CPMUCOP_CR2_MASK                4U
#define CPMUCOP_WRTMASK_MASK            32U
#define CPMUCOP_RSBCK_MASK              64U
#define CPMUCOP_WCOP_MASK               128U
#define CPMUCOP_CR_MASK                 7U
#define CPMUCOP_CR_BITNUM               0U


/*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CPMU COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CPMU COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CPMU COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CPMU COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CPMU COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CPMU COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CPMU COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CPMU COP Timer Arm/Reset Bit 7 */
  } Bits;
} CPMUARMCOPSTR;
extern volatile CPMUARMCOPSTR _CPMUARMCOP @(REG_BASE + 0x0000003FUL);
#define CPMUARMCOP                      _CPMUARMCOP.Byte
#define CPMUARMCOP_BIT0                 _CPMUARMCOP.Bits.BIT0
#define CPMUARMCOP_BIT1                 _CPMUARMCOP.Bits.BIT1
#define CPMUARMCOP_BIT2                 _CPMUARMCOP.Bits.BIT2
#define CPMUARMCOP_BIT3                 _CPMUARMCOP.Bits.BIT3
#define CPMUARMCOP_BIT4                 _CPMUARMCOP.Bits.BIT4
#define CPMUARMCOP_BIT5                 _CPMUARMCOP.Bits.BIT5
#define CPMUARMCOP_BIT6                 _CPMUARMCOP.Bits.BIT6
#define CPMUARMCOP_BIT7                 _CPMUARMCOP.Bits.BIT7

#define CPMUARMCOP_BIT0_MASK            1U
#define CPMUARMCOP_BIT1_MASK            2U
#define CPMUARMCOP_BIT2_MASK            4U
#define CPMUARMCOP_BIT3_MASK            8U
#define CPMUARMCOP_BIT4_MASK            16U
#define CPMUARMCOP_BIT5_MASK            32U
#define CPMUARMCOP_BIT6_MASK            64U
#define CPMUARMCOP_BIT7_MASK            128U


/*** D2DCTL0 - D2D Control Register 0; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte D2DCLKDIV0  :1;                                       /* InterfaceClockDivider, bit 0 */
    byte D2DCLKDIV1  :1;                                       /* InterfaceClockDivider, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DSWAI     :1;                                       /* D2D Stop In Wait */
    byte D2DCW       :1;                                       /* D2D Connection Width */
    byte D2DEN       :1;                                       /* D2D Enable */
  } Bits;
  struct {
    byte grpD2DCLKDIV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DCTL0STR;
extern volatile D2DCTL0STR _D2DCTL0 @(REG_BASE + 0x000000D8UL);
#define D2DCTL0                         _D2DCTL0.Byte
#define D2DCTL0_D2DCLKDIV0              _D2DCTL0.Bits.D2DCLKDIV0
#define D2DCTL0_D2DCLKDIV1              _D2DCTL0.Bits.D2DCLKDIV1
#define D2DCTL0_D2DSWAI                 _D2DCTL0.Bits.D2DSWAI
#define D2DCTL0_D2DCW                   _D2DCTL0.Bits.D2DCW
#define D2DCTL0_D2DEN                   _D2DCTL0.Bits.D2DEN
/* D2DCTL_ARR: Access 2 D2DCTLx registers in an array */
#define D2DCTL_ARR                      ((volatile byte *) &D2DCTL0)
#define D2DCTL0_D2DCLKDIV               _D2DCTL0.MergedBits.grpD2DCLKDIV

#define D2DCTL0_D2DCLKDIV0_MASK         1U
#define D2DCTL0_D2DCLKDIV1_MASK         2U
#define D2DCTL0_D2DSWAI_MASK            32U
#define D2DCTL0_D2DCW_MASK              64U
#define D2DCTL0_D2DEN_MASK              128U
#define D2DCTL0_D2DCLKDIV_MASK          3U
#define D2DCTL0_D2DCLKDIV_BITNUM        0U


/*** D2DCTL1 - D2D Control Register 1; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte TIMOUT0     :1;                                       /* Time-out Setting, bit 0 */
    byte TIMOUT1     :1;                                       /* Time-out Setting, bit 1 */
    byte TIMOUT2     :1;                                       /* Time-out Setting, bit 2 */
    byte TIMOUT3     :1;                                       /* Time-out Setting, bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DIE       :1;                                       /* D2D Interrupt Enable */
  } Bits;
  struct {
    byte grpTIMOUT :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DCTL1STR;
extern volatile D2DCTL1STR _D2DCTL1 @(REG_BASE + 0x000000D9UL);
#define D2DCTL1                         _D2DCTL1.Byte
#define D2DCTL1_TIMOUT0                 _D2DCTL1.Bits.TIMOUT0
#define D2DCTL1_TIMOUT1                 _D2DCTL1.Bits.TIMOUT1
#define D2DCTL1_TIMOUT2                 _D2DCTL1.Bits.TIMOUT2
#define D2DCTL1_TIMOUT3                 _D2DCTL1.Bits.TIMOUT3
#define D2DCTL1_D2DIE                   _D2DCTL1.Bits.D2DIE
#define D2DCTL1_TIMOUT                  _D2DCTL1.MergedBits.grpTIMOUT

#define D2DCTL1_TIMOUT0_MASK            1U
#define D2DCTL1_TIMOUT1_MASK            2U
#define D2DCTL1_TIMOUT2_MASK            4U
#define D2DCTL1_TIMOUT3_MASK            8U
#define D2DCTL1_D2DIE_MASK              128U
#define D2DCTL1_TIMOUT_MASK             15U
#define D2DCTL1_TIMOUT_BITNUM           0U


/*** D2DSTAT0 - D2D Status Register 0; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte PAR0        :1;                                       /* Parity Bit */
    byte PAR1        :1;                                       /* Parity Bit */
    byte PARF        :1;                                       /* Parity Error Flag */
    byte TERRF       :1;                                       /* Transaction Error Flag */
    byte TIMEF       :1;                                       /* TimeOutErrorFlag */
    byte CNCLF       :1;                                       /* CNCLF */
    byte ACKERF      :1;                                       /* Acknowledge Error Flag */
    byte ERRIF       :1;                                       /* D2D error interrupt flag */
  } Bits;
  struct {
    byte grpPAR  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DSTAT0STR;
extern volatile D2DSTAT0STR _D2DSTAT0 @(REG_BASE + 0x000000DAUL);
#define D2DSTAT0                        _D2DSTAT0.Byte
#define D2DSTAT0_PAR0                   _D2DSTAT0.Bits.PAR0
#define D2DSTAT0_PAR1                   _D2DSTAT0.Bits.PAR1
#define D2DSTAT0_PARF                   _D2DSTAT0.Bits.PARF
#define D2DSTAT0_TERRF                  _D2DSTAT0.Bits.TERRF
#define D2DSTAT0_TIMEF                  _D2DSTAT0.Bits.TIMEF
#define D2DSTAT0_CNCLF                  _D2DSTAT0.Bits.CNCLF
#define D2DSTAT0_ACKERF                 _D2DSTAT0.Bits.ACKERF
#define D2DSTAT0_ERRIF                  _D2DSTAT0.Bits.ERRIF
/* D2DSTAT_ARR: Access 2 D2DSTATx registers in an array */
#define D2DSTAT_ARR                     ((volatile byte *) &D2DSTAT0)
#define D2DSTAT0_PAR                    _D2DSTAT0.MergedBits.grpPAR

#define D2DSTAT0_PAR0_MASK              1U
#define D2DSTAT0_PAR1_MASK              2U
#define D2DSTAT0_PARF_MASK              4U
#define D2DSTAT0_TERRF_MASK             8U
#define D2DSTAT0_TIMEF_MASK             16U
#define D2DSTAT0_CNCLF_MASK             32U
#define D2DSTAT0_ACKERF_MASK            64U
#define D2DSTAT0_ERRIF_MASK             128U
#define D2DSTAT0_PAR_MASK               3U
#define D2DSTAT0_PAR_BITNUM             0U


/*** D2DSTAT1 - D2D Status Register 1; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DBSY      :1;                                       /* D2D Initiator Busy */
    byte D2DIF       :1;                                       /* D2D InterruptFlag */
  } Bits;
} D2DSTAT1STR;
extern volatile D2DSTAT1STR _D2DSTAT1 @(REG_BASE + 0x000000DBUL);
#define D2DSTAT1                        _D2DSTAT1.Byte
#define D2DSTAT1_D2DBSY                 _D2DSTAT1.Bits.D2DBSY
#define D2DSTAT1_D2DIF                  _D2DSTAT1.Bits.D2DIF

#define D2DSTAT1_D2DBSY_MASK            64U
#define D2DSTAT1_D2DIF_MASK             128U


/*** D2DADR - D2D Address Buffer Register; 0x000000DC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** D2DADRHI - D2D Address Buffer Register High; 0x000000DC ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte NBLK        :1;                                       /* Transaction Mode */
        byte             :1; 
        byte SZ8         :1;                                       /* Transaction Size */
        byte RWB         :1;                                       /* Transaction Read-Write Direction */
      } Bits;
    } D2DADRHISTR;
    #define D2DADRHI                    _D2DADR.Overlap_STR.D2DADRHISTR.Byte
    #define D2DADRHI_NBLK               _D2DADR.Overlap_STR.D2DADRHISTR.Bits.NBLK
    #define D2DADRHI_SZ8                _D2DADR.Overlap_STR.D2DADRHISTR.Bits.SZ8
    #define D2DADRHI_RWB                _D2DADR.Overlap_STR.D2DADRHISTR.Bits.RWB
    
    #define D2DADRHI_NBLK_MASK          16U
    #define D2DADRHI_SZ8_MASK           64U
    #define D2DADRHI_RWB_MASK           128U
    

    /*** D2DADRLO - D2D Address Buffer Register Low; 0x000000DD ***/
    union {
      byte Byte;
      struct {
        byte ADR0        :1;                                       /* Transaction Address, bit 0 */
        byte ADR1        :1;                                       /* Transaction Address, bit 1 */
        byte ADR2        :1;                                       /* Transaction Address, bit 2 */
        byte ADR3        :1;                                       /* Transaction Address, bit 3 */
        byte ADR4        :1;                                       /* Transaction Address, bit 4 */
        byte ADR5        :1;                                       /* Transaction Address, bit 5 */
        byte ADR6        :1;                                       /* Transaction Address, bit 6 */
        byte ADR7        :1;                                       /* Transaction Address, bit 7 */
      } Bits;
    } D2DADRLOSTR;
    #define D2DADRLO                    _D2DADR.Overlap_STR.D2DADRLOSTR.Byte
    #define D2DADRLO_ADR0               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR0
    #define D2DADRLO_ADR1               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR1
    #define D2DADRLO_ADR2               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR2
    #define D2DADRLO_ADR3               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR3
    #define D2DADRLO_ADR4               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR4
    #define D2DADRLO_ADR5               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR5
    #define D2DADRLO_ADR6               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR6
    #define D2DADRLO_ADR7               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR7
    
    #define D2DADRLO_ADR0_MASK          1U
    #define D2DADRLO_ADR1_MASK          2U
    #define D2DADRLO_ADR2_MASK          4U
    #define D2DADRLO_ADR3_MASK          8U
    #define D2DADRLO_ADR4_MASK          16U
    #define D2DADRLO_ADR5_MASK          32U
    #define D2DADRLO_ADR6_MASK          64U
    #define D2DADRLO_ADR7_MASK          128U
    
  } Overlap_STR;

  struct {
    word ADR0        :1;                                       /* Transaction Address, bit 0 */
    word ADR1        :1;                                       /* Transaction Address, bit 1 */
    word ADR2        :1;                                       /* Transaction Address, bit 2 */
    word ADR3        :1;                                       /* Transaction Address, bit 3 */
    word ADR4        :1;                                       /* Transaction Address, bit 4 */
    word ADR5        :1;                                       /* Transaction Address, bit 5 */
    word ADR6        :1;                                       /* Transaction Address, bit 6 */
    word ADR7        :1;                                       /* Transaction Address, bit 7 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word NBLK        :1;                                       /* Transaction Mode */
    word             :1; 
    word SZ8         :1;                                       /* Transaction Size */
    word RWB         :1;                                       /* Transaction Read-Write Direction */
  } Bits;
  struct {
    word grpADR  :8;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpSZ_8 :1;
    word         :1;
  } MergedBits;
} D2DADRSTR;
extern volatile D2DADRSTR _D2DADR @(REG_BASE + 0x000000DCUL);
#define D2DADR                          _D2DADR.Word
#define D2DADR_ADR0                     _D2DADR.Bits.ADR0
#define D2DADR_ADR1                     _D2DADR.Bits.ADR1
#define D2DADR_ADR2                     _D2DADR.Bits.ADR2
#define D2DADR_ADR3                     _D2DADR.Bits.ADR3
#define D2DADR_ADR4                     _D2DADR.Bits.ADR4
#define D2DADR_ADR5                     _D2DADR.Bits.ADR5
#define D2DADR_ADR6                     _D2DADR.Bits.ADR6
#define D2DADR_ADR7                     _D2DADR.Bits.ADR7
#define D2DADR_NBLK                     _D2DADR.Bits.NBLK
#define D2DADR_SZ8                      _D2DADR.Bits.SZ8
#define D2DADR_RWB                      _D2DADR.Bits.RWB
#define D2DADR_ADR                      _D2DADR.MergedBits.grpADR

#define D2DADR_ADR0_MASK                1U
#define D2DADR_ADR1_MASK                2U
#define D2DADR_ADR2_MASK                4U
#define D2DADR_ADR3_MASK                8U
#define D2DADR_ADR4_MASK                16U
#define D2DADR_ADR5_MASK                32U
#define D2DADR_ADR6_MASK                64U
#define D2DADR_ADR7_MASK                128U
#define D2DADR_NBLK_MASK                4096U
#define D2DADR_SZ8_MASK                 16384U
#define D2DADR_RWB_MASK                 32768U
#define D2DADR_ADR_MASK                 255U
#define D2DADR_ADR_BITNUM               0U


/*** D2DDATA - D2D Data Buffer Register; 0x000000DE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** D2DDATAHI - D2D Data Buffer Register High; 0x000000DE ***/
    union {
      byte Byte;
      struct {
        byte DATA8       :1;                                       /* Transaction Data, bit 8 */
        byte DATA9       :1;                                       /* Transaction Data, bit 9 */
        byte DATA10      :1;                                       /* Transaction Data, bit 10 */
        byte DATA11      :1;                                       /* Transaction Data, bit 11 */
        byte DATA12      :1;                                       /* Transaction Data, bit 12 */
        byte DATA13      :1;                                       /* Transaction Data, bit 13 */
        byte DATA14      :1;                                       /* Transaction Data, bit 14 */
        byte DATA15      :1;                                       /* Transaction Data, bit 15 */
      } Bits;
    } D2DDATAHISTR;
    #define D2DDATAHI                   _D2DDATA.Overlap_STR.D2DDATAHISTR.Byte
    #define D2DDATAHI_DATA8             _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA8
    #define D2DDATAHI_DATA9             _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA9
    #define D2DDATAHI_DATA10            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA10
    #define D2DDATAHI_DATA11            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA11
    #define D2DDATAHI_DATA12            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA12
    #define D2DDATAHI_DATA13            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA13
    #define D2DDATAHI_DATA14            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA14
    #define D2DDATAHI_DATA15            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA15
    
    #define D2DDATAHI_DATA8_MASK        1U
    #define D2DDATAHI_DATA9_MASK        2U
    #define D2DDATAHI_DATA10_MASK       4U
    #define D2DDATAHI_DATA11_MASK       8U
    #define D2DDATAHI_DATA12_MASK       16U
    #define D2DDATAHI_DATA13_MASK       32U
    #define D2DDATAHI_DATA14_MASK       64U
    #define D2DDATAHI_DATA15_MASK       128U
    

    /*** D2DDATALO - D2D Data Buffer Register Low; 0x000000DF ***/
    union {
      byte Byte;
      struct {
        byte DATA0       :1;                                       /* Transaction Data, bit 0 */
        byte DATA1       :1;                                       /* Transaction Data, bit 1 */
        byte DATA2       :1;                                       /* Transaction Data, bit 2 */
        byte DATA3       :1;                                       /* Transaction Data, bit 3 */
        byte DATA4       :1;                                       /* Transaction Data, bit 4 */
        byte DATA5       :1;                                       /* Transaction Data, bit 5 */
        byte DATA6       :1;                                       /* Transaction Data, bit 6 */
        byte DATA7       :1;                                       /* Transaction Data, bit 7 */
      } Bits;
    } D2DDATALOSTR;
    #define D2DDATALO                   _D2DDATA.Overlap_STR.D2DDATALOSTR.Byte
    #define D2DDATALO_DATA0             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA0
    #define D2DDATALO_DATA1             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA1
    #define D2DDATALO_DATA2             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA2
    #define D2DDATALO_DATA3             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA3
    #define D2DDATALO_DATA4             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA4
    #define D2DDATALO_DATA5             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA5
    #define D2DDATALO_DATA6             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA6
    #define D2DDATALO_DATA7             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA7
    
    #define D2DDATALO_DATA0_MASK        1U
    #define D2DDATALO_DATA1_MASK        2U
    #define D2DDATALO_DATA2_MASK        4U
    #define D2DDATALO_DATA3_MASK        8U
    #define D2DDATALO_DATA4_MASK        16U
    #define D2DDATALO_DATA5_MASK        32U
    #define D2DDATALO_DATA6_MASK        64U
    #define D2DDATALO_DATA7_MASK        128U
    
  } Overlap_STR;

  struct {
    word DATA0       :1;                                       /* Transaction Data, bit 0 */
    word DATA1       :1;                                       /* Transaction Data, bit 1 */
    word DATA2       :1;                                       /* Transaction Data, bit 2 */
    word DATA3       :1;                                       /* Transaction Data, bit 3 */
    word DATA4       :1;                                       /* Transaction Data, bit 4 */
    word DATA5       :1;                                       /* Transaction Data, bit 5 */
    word DATA6       :1;                                       /* Transaction Data, bit 6 */
    word DATA7       :1;                                       /* Transaction Data, bit 7 */
    word DATA8       :1;                                       /* Transaction Data, bit 8 */
    word DATA9       :1;                                       /* Transaction Data, bit 9 */
    word DATA10      :1;                                       /* Transaction Data, bit 10 */
    word DATA11      :1;                                       /* Transaction Data, bit 11 */
    word DATA12      :1;                                       /* Transaction Data, bit 12 */
    word DATA13      :1;                                       /* Transaction Data, bit 13 */
    word DATA14      :1;                                       /* Transaction Data, bit 14 */
    word DATA15      :1;                                       /* Transaction Data, bit 15 */
  } Bits;
} D2DDATASTR;
extern volatile D2DDATASTR _D2DDATA @(REG_BASE + 0x000000DEUL);
#define D2DDATA                         _D2DDATA.Word
#define D2DDATA_DATA0                   _D2DDATA.Bits.DATA0
#define D2DDATA_DATA1                   _D2DDATA.Bits.DATA1
#define D2DDATA_DATA2                   _D2DDATA.Bits.DATA2
#define D2DDATA_DATA3                   _D2DDATA.Bits.DATA3
#define D2DDATA_DATA4                   _D2DDATA.Bits.DATA4
#define D2DDATA_DATA5                   _D2DDATA.Bits.DATA5
#define D2DDATA_DATA6                   _D2DDATA.Bits.DATA6
#define D2DDATA_DATA7                   _D2DDATA.Bits.DATA7
#define D2DDATA_DATA8                   _D2DDATA.Bits.DATA8
#define D2DDATA_DATA9                   _D2DDATA.Bits.DATA9
#define D2DDATA_DATA10                  _D2DDATA.Bits.DATA10
#define D2DDATA_DATA11                  _D2DDATA.Bits.DATA11
#define D2DDATA_DATA12                  _D2DDATA.Bits.DATA12
#define D2DDATA_DATA13                  _D2DDATA.Bits.DATA13
#define D2DDATA_DATA14                  _D2DDATA.Bits.DATA14
#define D2DDATA_DATA15                  _D2DDATA.Bits.DATA15

#define D2DDATA_DATA0_MASK              1U
#define D2DDATA_DATA1_MASK              2U
#define D2DDATA_DATA2_MASK              4U
#define D2DDATA_DATA3_MASK              8U
#define D2DDATA_DATA4_MASK              16U
#define D2DDATA_DATA5_MASK              32U
#define D2DDATA_DATA6_MASK              64U
#define D2DDATA_DATA7_MASK              128U
#define D2DDATA_DATA8_MASK              256U
#define D2DDATA_DATA9_MASK              512U
#define D2DDATA_DATA10_MASK             1024U
#define D2DDATA_DATA11_MASK             2048U
#define D2DDATA_DATA12_MASK             4096U
#define D2DDATA_DATA13_MASK             8192U
#define D2DDATA_DATA14_MASK             16384U
#define D2DDATA_DATA15_MASK             32768U


/*** SPICR1 - SPI  Control Register 1; 0x000000E8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPICR1STR;
extern volatile SPICR1STR _SPICR1 @(REG_BASE + 0x000000E8UL);
#define SPICR1                          _SPICR1.Byte
#define SPICR1_LSBFE                    _SPICR1.Bits.LSBFE
#define SPICR1_SSOE                     _SPICR1.Bits.SSOE
#define SPICR1_CPHA                     _SPICR1.Bits.CPHA
#define SPICR1_CPOL                     _SPICR1.Bits.CPOL
#define SPICR1_MSTR                     _SPICR1.Bits.MSTR
#define SPICR1_SPTIE                    _SPICR1.Bits.SPTIE
#define SPICR1_SPE                      _SPICR1.Bits.SPE
#define SPICR1_SPIE                     _SPICR1.Bits.SPIE

#define SPICR1_LSBFE_MASK               1U
#define SPICR1_SSOE_MASK                2U
#define SPICR1_CPHA_MASK                4U
#define SPICR1_CPOL_MASK                8U
#define SPICR1_MSTR_MASK                16U
#define SPICR1_SPTIE_MASK               32U
#define SPICR1_SPE_MASK                 64U
#define SPICR1_SPIE_MASK                128U


/*** SPICR2 - SPI  Control Register 2; 0x000000E9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte XFRW        :1;                                       /* Transfer Width */
    byte             :1; 
  } Bits;
} SPICR2STR;
extern volatile SPICR2STR _SPICR2 @(REG_BASE + 0x000000E9UL);
#define SPICR2                          _SPICR2.Byte
#define SPICR2_SPC0                     _SPICR2.Bits.SPC0
#define SPICR2_SPISWAI                  _SPICR2.Bits.SPISWAI
#define SPICR2_BIDIROE                  _SPICR2.Bits.BIDIROE
#define SPICR2_MODFEN                   _SPICR2.Bits.MODFEN
#define SPICR2_XFRW                     _SPICR2.Bits.XFRW

#define SPICR2_SPC0_MASK                1U
#define SPICR2_SPISWAI_MASK             2U
#define SPICR2_BIDIROE_MASK             8U
#define SPICR2_MODFEN_MASK              16U
#define SPICR2_XFRW_MASK                64U


/*** SPIBR - SPI  Baud Rate Register; 0x000000EA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPIBRSTR;
extern volatile SPIBRSTR _SPIBR @(REG_BASE + 0x000000EAUL);
#define SPIBR                           _SPIBR.Byte
#define SPIBR_SPR0                      _SPIBR.Bits.SPR0
#define SPIBR_SPR1                      _SPIBR.Bits.SPR1
#define SPIBR_SPR2                      _SPIBR.Bits.SPR2
#define SPIBR_SPPR0                     _SPIBR.Bits.SPPR0
#define SPIBR_SPPR1                     _SPIBR.Bits.SPPR1
#define SPIBR_SPPR2                     _SPIBR.Bits.SPPR2
#define SPIBR_SPR                       _SPIBR.MergedBits.grpSPR
#define SPIBR_SPPR                      _SPIBR.MergedBits.grpSPPR

#define SPIBR_SPR0_MASK                 1U
#define SPIBR_SPR1_MASK                 2U
#define SPIBR_SPR2_MASK                 4U
#define SPIBR_SPPR0_MASK                16U
#define SPIBR_SPPR1_MASK                32U
#define SPIBR_SPPR2_MASK                64U
#define SPIBR_SPR_MASK                  7U
#define SPIBR_SPR_BITNUM                0U
#define SPIBR_SPPR_MASK                 112U
#define SPIBR_SPPR_BITNUM               4U


/*** SPISR - SPI  Status Register; 0x000000EB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPISRSTR;
extern volatile SPISRSTR _SPISR @(REG_BASE + 0x000000EBUL);
#define SPISR                           _SPISR.Byte
#define SPISR_MODF                      _SPISR.Bits.MODF
#define SPISR_SPTEF                     _SPISR.Bits.SPTEF
#define SPISR_SPIF                      _SPISR.Bits.SPIF

#define SPISR_MODF_MASK                 16U
#define SPISR_SPTEF_MASK                32U
#define SPISR_SPIF_MASK                 128U


/*** SPIDR - SPI  Data Register; 0x000000EC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SPIDRH - SPI  Data Register High; 0x000000EC ***/
    union {
      byte Byte;
      struct {
        byte R8_T8       :1;                                       /* SPI  Data Bit 8 */
        byte R9_T9       :1;                                       /* SPI  Data Bit 9 */
        byte R10_T10     :1;                                       /* SPI  Data Bit 10 */
        byte R11_T11     :1;                                       /* SPI  Data Bit 11 */
        byte R12_T12     :1;                                       /* SPI  Data Bit 12 */
        byte R13_T13     :1;                                       /* SPI  Data Bit 13 */
        byte R14_T14     :1;                                       /* SPI  Data Bit 14 */
        byte R15_T15     :1;                                       /* SPI  Data Bit 15 */
      } Bits;
    } SPIDRHSTR;
    #define SPIDRH                      _SPIDR.Overlap_STR.SPIDRHSTR.Byte
    #define SPIDRH_R8_T8                _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R8_T8
    #define SPIDRH_R9_T9                _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R9_T9
    #define SPIDRH_R10_T10              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R10_T10
    #define SPIDRH_R11_T11              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R11_T11
    #define SPIDRH_R12_T12              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R12_T12
    #define SPIDRH_R13_T13              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R13_T13
    #define SPIDRH_R14_T14              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R14_T14
    #define SPIDRH_R15_T15              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R15_T15
    
    #define SPIDRH_R8_T8_MASK           1U
    #define SPIDRH_R9_T9_MASK           2U
    #define SPIDRH_R10_T10_MASK         4U
    #define SPIDRH_R11_T11_MASK         8U
    #define SPIDRH_R12_T12_MASK         16U
    #define SPIDRH_R13_T13_MASK         32U
    #define SPIDRH_R14_T14_MASK         64U
    #define SPIDRH_R15_T15_MASK         128U
    

    /*** SPIDRL - SPI  Data Register Low; 0x000000ED ***/
    union {
      byte Byte;
      struct {
        byte R0_T0       :1;                                       /* SPI  Data Bit 0 */
        byte R1_T1       :1;                                       /* SPI  Data Bit 1 */
        byte R2_T2       :1;                                       /* SPI  Data Bit 2 */
        byte R3_T3       :1;                                       /* SPI  Data Bit 3 */
        byte R4_T4       :1;                                       /* SPI  Data Bit 4 */
        byte R5_T5       :1;                                       /* SPI  Data Bit 5 */
        byte R6_T6       :1;                                       /* SPI  Data Bit 6 */
        byte R7_T7       :1;                                       /* SPI  Data Bit 7 */
      } Bits;
    } SPIDRLSTR;
    #define SPIDRL                      _SPIDR.Overlap_STR.SPIDRLSTR.Byte
    #define SPIDRL_R0_T0                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R0_T0
    #define SPIDRL_R1_T1                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R1_T1
    #define SPIDRL_R2_T2                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R2_T2
    #define SPIDRL_R3_T3                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R3_T3
    #define SPIDRL_R4_T4                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R4_T4
    #define SPIDRL_R5_T5                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R5_T5
    #define SPIDRL_R6_T6                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R6_T6
    #define SPIDRL_R7_T7                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R7_T7
    
    #define SPIDRL_R0_T0_MASK           1U
    #define SPIDRL_R1_T1_MASK           2U
    #define SPIDRL_R2_T2_MASK           4U
    #define SPIDRL_R3_T3_MASK           8U
    #define SPIDRL_R4_T4_MASK           16U
    #define SPIDRL_R5_T5_MASK           32U
    #define SPIDRL_R6_T6_MASK           64U
    #define SPIDRL_R7_T7_MASK           128U
    
  } Overlap_STR;

  struct {
    word R0_T0       :1;                                       /* SPI  Data Bit 0 */
    word R1_T1       :1;                                       /* SPI  Data Bit 1 */
    word R2_T2       :1;                                       /* SPI  Data Bit 2 */
    word R3_T3       :1;                                       /* SPI  Data Bit 3 */
    word R4_T4       :1;                                       /* SPI  Data Bit 4 */
    word R5_T5       :1;                                       /* SPI  Data Bit 5 */
    word R6_T6       :1;                                       /* SPI  Data Bit 6 */
    word R7_T7       :1;                                       /* SPI  Data Bit 7 */
    word R8_T8       :1;                                       /* SPI  Data Bit 8 */
    word R9_T9       :1;                                       /* SPI  Data Bit 9 */
    word R10_T10     :1;                                       /* SPI  Data Bit 10 */
    word R11_T11     :1;                                       /* SPI  Data Bit 11 */
    word R12_T12     :1;                                       /* SPI  Data Bit 12 */
    word R13_T13     :1;                                       /* SPI  Data Bit 13 */
    word R14_T14     :1;                                       /* SPI  Data Bit 14 */
    word R15_T15     :1;                                       /* SPI  Data Bit 15 */
  } Bits;
} SPIDRSTR;
extern volatile SPIDRSTR _SPIDR @(REG_BASE + 0x000000ECUL);
#define SPIDR                           _SPIDR.Word
#define SPIDR_R0_T0                     _SPIDR.Bits.R0_T0
#define SPIDR_R1_T1                     _SPIDR.Bits.R1_T1
#define SPIDR_R2_T2                     _SPIDR.Bits.R2_T2
#define SPIDR_R3_T3                     _SPIDR.Bits.R3_T3
#define SPIDR_R4_T4                     _SPIDR.Bits.R4_T4
#define SPIDR_R5_T5                     _SPIDR.Bits.R5_T5
#define SPIDR_R6_T6                     _SPIDR.Bits.R6_T6
#define SPIDR_R7_T7                     _SPIDR.Bits.R7_T7
#define SPIDR_R8_T8                     _SPIDR.Bits.R8_T8
#define SPIDR_R9_T9                     _SPIDR.Bits.R9_T9
#define SPIDR_R10_T10                   _SPIDR.Bits.R10_T10
#define SPIDR_R11_T11                   _SPIDR.Bits.R11_T11
#define SPIDR_R12_T12                   _SPIDR.Bits.R12_T12
#define SPIDR_R13_T13                   _SPIDR.Bits.R13_T13
#define SPIDR_R14_T14                   _SPIDR.Bits.R14_T14
#define SPIDR_R15_T15                   _SPIDR.Bits.R15_T15

#define SPIDR_R0_T0_MASK                1U
#define SPIDR_R1_T1_MASK                2U
#define SPIDR_R2_T2_MASK                4U
#define SPIDR_R3_T3_MASK                8U
#define SPIDR_R4_T4_MASK                16U
#define SPIDR_R5_T5_MASK                32U
#define SPIDR_R6_T6_MASK                64U
#define SPIDR_R7_T7_MASK                128U
#define SPIDR_R8_T8_MASK                256U
#define SPIDR_R9_T9_MASK                512U
#define SPIDR_R10_T10_MASK              1024U
#define SPIDR_R11_T11_MASK              2048U
#define SPIDR_R12_T12_MASK              4096U
#define SPIDR_R13_T13_MASK              8192U
#define SPIDR_R14_T14_MASK              16384U
#define SPIDR_R15_T15_MASK              32768U


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Clock Divider Bit 5 */
    byte FDIVLCK     :1;                                       /* Clock divider locked */
    byte FDIVLD      :1;                                       /* Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_FDIVLCK                 _FCLKDIV.Bits.FDIVLCK
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_FDIVLCK_MASK            64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               63U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte RNV2        :1;                                       /* Reserved Nonvolatile Bit 2 */
    byte RNV3        :1;                                       /* Reserved Nonvolatile Bit 3 */
    byte RNV4        :1;                                       /* Reserved Nonvolatile Bit 4 */
    byte RNV5        :1;                                       /* Reserved Nonvolatile Bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_RNV2                       _FSEC.Bits.RNV2
#define FSEC_RNV3                       _FSEC.Bits.RNV3
#define FSEC_RNV4                       _FSEC.Bits.RNV4
#define FSEC_RNV5                       _FSEC.Bits.RNV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_RNV_2                      _FSEC.MergedBits.grpRNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_RNV                        FSEC_RNV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_RNV2_MASK                  4U
#define FSEC_RNV3_MASK                  8U
#define FSEC_RNV4_MASK                  16U
#define FSEC_RNV5_MASK                  32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_RNV_2_MASK                 60U
#define FSEC_RNV_2_BITNUM               2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***/
typedef union {
  byte Byte;
  struct {
    byte CCOBIX0     :1;                                       /* Common Command Register Index Bit 0 */
    byte CCOBIX1     :1;                                       /* Common Command Register Index Bit 1 */
    byte CCOBIX2     :1;                                       /* Common Command Register Index Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCCOBIX :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCCOBIXSTR;
extern volatile FCCOBIXSTR _FCCOBIX @(REG_BASE + 0x00000102UL);
#define FCCOBIX                         _FCCOBIX.Byte
#define FCCOBIX_CCOBIX0                 _FCCOBIX.Bits.CCOBIX0
#define FCCOBIX_CCOBIX1                 _FCCOBIX.Bits.CCOBIX1
#define FCCOBIX_CCOBIX2                 _FCCOBIX.Bits.CCOBIX2
#define FCCOBIX_CCOBIX                  _FCCOBIX.MergedBits.grpCCOBIX

#define FCCOBIX_CCOBIX0_MASK            1U
#define FCCOBIX_CCOBIX1_MASK            2U
#define FCCOBIX_CCOBIX2_MASK            4U
#define FCCOBIX_CCOBIX_MASK             7U
#define FCCOBIX_CCOBIX_BITNUM           0U


/*** FCNFG - Flash Configuration Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FSFD        :1;                                       /* Force Single Bit Fault Detect */
    byte FDFD        :1;                                       /* Force Double Bit Fault Detect */
    byte             :1; 
    byte             :1; 
    byte IGNSF       :1;                                       /* Ignore Single Bit Fault */
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000104UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_FSFD                      _FCNFG.Bits.FSFD
#define FCNFG_FDFD                      _FCNFG.Bits.FDFD
#define FCNFG_IGNSF                     _FCNFG.Bits.IGNSF
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE

#define FCNFG_FSFD_MASK                 1U
#define FCNFG_FDFD_MASK                 2U
#define FCNFG_IGNSF_MASK                16U
#define FCNFG_CCIE_MASK                 128U


/*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte SFDIE       :1;                                       /* Single Bit Fault Detect Interrupt Enable */
    byte DFDIE       :1;                                       /* Double Bit Fault Detect Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} FERCNFGSTR;
extern volatile FERCNFGSTR _FERCNFG @(REG_BASE + 0x00000105UL);
#define FERCNFG                         _FERCNFG.Byte
#define FERCNFG_SFDIE                   _FERCNFG.Bits.SFDIE
#define FERCNFG_DFDIE                   _FERCNFG.Bits.DFDIE

#define FERCNFG_SFDIE_MASK              1U
#define FERCNFG_DFDIE_MASK              2U


/*** FSTAT - Flash Status Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte MGSTAT0     :1;                                       /* Memory Controller Command Completion Status Flag 0 */
    byte MGSTAT1     :1;                                       /* Memory Controller Command Completion Status Flag 1 */
    byte             :1; 
    byte MGBUSY      :1;                                       /* Memory Controller Busy Flag */
    byte FPVIOL      :1;                                       /* Flash Protection Violation Flag */
    byte ACCERR      :1;                                       /* Flash Access Error Flag */
    byte             :1; 
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
  } Bits;
  struct {
    byte grpMGSTAT :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000106UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_MGSTAT0                   _FSTAT.Bits.MGSTAT0
#define FSTAT_MGSTAT1                   _FSTAT.Bits.MGSTAT1
#define FSTAT_MGBUSY                    _FSTAT.Bits.MGBUSY
#define FSTAT_FPVIOL                    _FSTAT.Bits.FPVIOL
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_MGSTAT                    _FSTAT.MergedBits.grpMGSTAT

#define FSTAT_MGSTAT0_MASK              1U
#define FSTAT_MGSTAT1_MASK              2U
#define FSTAT_MGBUSY_MASK               8U
#define FSTAT_FPVIOL_MASK               16U
#define FSTAT_ACCERR_MASK               32U
#define FSTAT_CCIF_MASK                 128U
#define FSTAT_MGSTAT_MASK               3U
#define FSTAT_MGSTAT_BITNUM             0U


/*** FERSTAT - Flash Error Status Register; 0x00000107 ***/
typedef union {
  byte Byte;
  struct {
    byte SFDIF       :1;                                       /* Single Bit Fault Detect Interrupt Flag */
    byte DFDIF       :1;                                       /* Double Bit Fault Detect Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} FERSTATSTR;
extern volatile FERSTATSTR _FERSTAT @(REG_BASE + 0x00000107UL);
#define FERSTAT                         _FERSTAT.Byte
#define FERSTAT_SFDIF                   _FERSTAT.Bits.SFDIF
#define FERSTAT_DFDIF                   _FERSTAT.Bits.DFDIF

#define FERSTAT_SFDIF_MASK              1U
#define FERSTAT_DFDIF_MASK              2U


/*** FPROT - P-Flash Protection Register; 0x00000108 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address Size Bit 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address Size Bit 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower Address Range Disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher Address Size Bit 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher Address Size Bit 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher Address Range Disable */
    byte RNV6        :1;                                       /* Reserved Nonvolatile Bit */
    byte FPOPEN      :1;                                       /* Flash Protection Operation Enable */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000108UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_RNV6                      _FPROT.Bits.RNV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_RNV6_MASK                 64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** DFPROT - D-Flash Protection Register; 0x00000109 ***/
typedef union {
  byte Byte;
  struct {
    byte DPS0        :1;                                       /* D-Flash Protection Size Bit 0 */
    byte DPS1        :1;                                       /* D-Flash Protection Size Bit 1 */
    byte DPS2        :1;                                       /* D-Flash Protection Size Bit 2 */
    byte DPS3        :1;                                       /* D-Flash Protection Size Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte DPOPEN      :1;                                       /* D-Flash Protection Control */
  } Bits;
  struct {
    byte grpDPS  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DFPROTSTR;
extern volatile DFPROTSTR _DFPROT @(REG_BASE + 0x00000109UL);
#define DFPROT                          _DFPROT.Byte
#define DFPROT_DPS0                     _DFPROT.Bits.DPS0
#define DFPROT_DPS1                     _DFPROT.Bits.DPS1
#define DFPROT_DPS2                     _DFPROT.Bits.DPS2
#define DFPROT_DPS3                     _DFPROT.Bits.DPS3
#define DFPROT_DPOPEN                   _DFPROT.Bits.DPOPEN
#define DFPROT_DPS                      _DFPROT.MergedBits.grpDPS

#define DFPROT_DPS0_MASK                1U
#define DFPROT_DPS1_MASK                2U
#define DFPROT_DPS2_MASK                4U
#define DFPROT_DPS3_MASK                8U
#define DFPROT_DPOPEN_MASK              128U
#define DFPROT_DPS_MASK                 15U
#define DFPROT_DPS_BITNUM               0U


/*** FCCOB - Flash Common Command Object Register; 0x0000010A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***/
    union {
      byte Byte;
      struct {
        byte CCOB8       :1;                                       /* Flash Common Command Object Bit 8 */
        byte CCOB9       :1;                                       /* Flash Common Command Object Bit 9 */
        byte CCOB10      :1;                                       /* Flash Common Command Object Bit 10 */
        byte CCOB11      :1;                                       /* Flash Common Command Object Bit 11 */
        byte CCOB12      :1;                                       /* Flash Common Command Object Bit 12 */
        byte CCOB13      :1;                                       /* Flash Common Command Object Bit 13 */
        byte CCOB14      :1;                                       /* Flash Common Command Object Bit 14 */
        byte CCOB15      :1;                                       /* Flash Common Command Object Bit 15 */
      } Bits;
    } FCCOBHISTR;
    #define FCCOBHI                     _FCCOB.Overlap_STR.FCCOBHISTR.Byte
    #define FCCOBHI_CCOB8               _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB8
    #define FCCOBHI_CCOB9               _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB9
    #define FCCOBHI_CCOB10              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB10
    #define FCCOBHI_CCOB11              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB11
    #define FCCOBHI_CCOB12              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB12
    #define FCCOBHI_CCOB13              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB13
    #define FCCOBHI_CCOB14              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB14
    #define FCCOBHI_CCOB15              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB15
    
    #define FCCOBHI_CCOB8_MASK          1U
    #define FCCOBHI_CCOB9_MASK          2U
    #define FCCOBHI_CCOB10_MASK         4U
    #define FCCOBHI_CCOB11_MASK         8U
    #define FCCOBHI_CCOB12_MASK         16U
    #define FCCOBHI_CCOB13_MASK         32U
    #define FCCOBHI_CCOB14_MASK         64U
    #define FCCOBHI_CCOB15_MASK         128U
    

    /*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***/
    union {
      byte Byte;
      struct {
        byte CCOB0       :1;                                       /* Flash Common Command Object Bit 0 */
        byte CCOB1       :1;                                       /* Flash Common Command Object Bit 1 */
        byte CCOB2       :1;                                       /* Flash Common Command Object Bit 2 */
        byte CCOB3       :1;                                       /* Flash Common Command Object Bit 3 */
        byte CCOB4       :1;                                       /* Flash Common Command Object Bit 4 */
        byte CCOB5       :1;                                       /* Flash Common Command Object Bit 5 */
        byte CCOB6       :1;                                       /* Flash Common Command Object Bit 6 */
        byte CCOB7       :1;                                       /* Flash Common Command Object Bit 7 */
      } Bits;
    } FCCOBLOSTR;
    #define FCCOBLO                     _FCCOB.Overlap_STR.FCCOBLOSTR.Byte
    #define FCCOBLO_CCOB0               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB0
    #define FCCOBLO_CCOB1               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB1
    #define FCCOBLO_CCOB2               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB2
    #define FCCOBLO_CCOB3               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB3
    #define FCCOBLO_CCOB4               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB4
    #define FCCOBLO_CCOB5               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB5
    #define FCCOBLO_CCOB6               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB6
    #define FCCOBLO_CCOB7               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB7
    
    #define FCCOBLO_CCOB0_MASK          1U
    #define FCCOBLO_CCOB1_MASK          2U
    #define FCCOBLO_CCOB2_MASK          4U
    #define FCCOBLO_CCOB3_MASK          8U
    #define FCCOBLO_CCOB4_MASK          16U
    #define FCCOBLO_CCOB5_MASK          32U
    #define FCCOBLO_CCOB6_MASK          64U
    #define FCCOBLO_CCOB7_MASK          128U
    
  } Overlap_STR;

  struct {
    word CCOB0       :1;                                       /* Flash Common Command Object Bit 0 */
    word CCOB1       :1;                                       /* Flash Common Command Object Bit 1 */
    word CCOB2       :1;                                       /* Flash Common Command Object Bit 2 */
    word CCOB3       :1;                                       /* Flash Common Command Object Bit 3 */
    word CCOB4       :1;                                       /* Flash Common Command Object Bit 4 */
    word CCOB5       :1;                                       /* Flash Common Command Object Bit 5 */
    word CCOB6       :1;                                       /* Flash Common Command Object Bit 6 */
    word CCOB7       :1;                                       /* Flash Common Command Object Bit 7 */
    word CCOB8       :1;                                       /* Flash Common Command Object Bit 8 */
    word CCOB9       :1;                                       /* Flash Common Command Object Bit 9 */
    word CCOB10      :1;                                       /* Flash Common Command Object Bit 10 */
    word CCOB11      :1;                                       /* Flash Common Command Object Bit 11 */
    word CCOB12      :1;                                       /* Flash Common Command Object Bit 12 */
    word CCOB13      :1;                                       /* Flash Common Command Object Bit 13 */
    word CCOB14      :1;                                       /* Flash Common Command Object Bit 14 */
    word CCOB15      :1;                                       /* Flash Common Command Object Bit 15 */
  } Bits;
} FCCOBSTR;
extern volatile FCCOBSTR _FCCOB @(REG_BASE + 0x0000010AUL);
#define FCCOB                           _FCCOB.Word
#define FCCOB_CCOB0                     _FCCOB.Bits.CCOB0
#define FCCOB_CCOB1                     _FCCOB.Bits.CCOB1
#define FCCOB_CCOB2                     _FCCOB.Bits.CCOB2
#define FCCOB_CCOB3                     _FCCOB.Bits.CCOB3
#define FCCOB_CCOB4                     _FCCOB.Bits.CCOB4
#define FCCOB_CCOB5                     _FCCOB.Bits.CCOB5
#define FCCOB_CCOB6                     _FCCOB.Bits.CCOB6
#define FCCOB_CCOB7                     _FCCOB.Bits.CCOB7
#define FCCOB_CCOB8                     _FCCOB.Bits.CCOB8
#define FCCOB_CCOB9                     _FCCOB.Bits.CCOB9
#define FCCOB_CCOB10                    _FCCOB.Bits.CCOB10
#define FCCOB_CCOB11                    _FCCOB.Bits.CCOB11
#define FCCOB_CCOB12                    _FCCOB.Bits.CCOB12
#define FCCOB_CCOB13                    _FCCOB.Bits.CCOB13
#define FCCOB_CCOB14                    _FCCOB.Bits.CCOB14
#define FCCOB_CCOB15                    _FCCOB.Bits.CCOB15

#define FCCOB_CCOB0_MASK                1U
#define FCCOB_CCOB1_MASK                2U
#define FCCOB_CCOB2_MASK                4U
#define FCCOB_CCOB3_MASK                8U
#define FCCOB_CCOB4_MASK                16U
#define FCCOB_CCOB5_MASK                32U
#define FCCOB_CCOB6_MASK                64U
#define FCCOB_CCOB7_MASK                128U
#define FCCOB_CCOB8_MASK                256U
#define FCCOB_CCOB9_MASK                512U
#define FCCOB_CCOB10_MASK               1024U
#define FCCOB_CCOB11_MASK               2048U
#define FCCOB_CCOB12_MASK               4096U
#define FCCOB_CCOB13_MASK               8192U
#define FCCOB_CCOB14_MASK               16384U
#define FCCOB_CCOB15_MASK               32768U


/*** FOPT - Flash Option Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Nonvolatile Bit 0 */
    byte NV1         :1;                                       /* Nonvolatile Bit 1 */
    byte NV2         :1;                                       /* Nonvolatile Bit 2 */
    byte NV3         :1;                                       /* Nonvolatile Bit 3 */
    byte NV4         :1;                                       /* Nonvolatile Bit 4 */
    byte NV5         :1;                                       /* Nonvolatile Bit 5 */
    byte NV6         :1;                                       /* Nonvolatile Bit 6 */
    byte NV7         :1;                                       /* Nonvolatile Bit 7 */
  } Bits;
} FOPTSTR;
extern volatile FOPTSTR _FOPT @(REG_BASE + 0x00000110UL);
#define FOPT                            _FOPT.Byte
#define FOPT_NV0                        _FOPT.Bits.NV0
#define FOPT_NV1                        _FOPT.Bits.NV1
#define FOPT_NV2                        _FOPT.Bits.NV2
#define FOPT_NV3                        _FOPT.Bits.NV3
#define FOPT_NV4                        _FOPT.Bits.NV4
#define FOPT_NV5                        _FOPT.Bits.NV5
#define FOPT_NV6                        _FOPT.Bits.NV6
#define FOPT_NV7                        _FOPT.Bits.NV7

#define FOPT_NV0_MASK                   1U
#define FOPT_NV1_MASK                   2U
#define FOPT_NV2_MASK                   4U
#define FOPT_NV3_MASK                   8U
#define FOPT_NV4_MASK                   16U
#define FOPT_NV5_MASK                   32U
#define FOPT_NV6_MASK                   64U
#define FOPT_NV7_MASK                   128U


/*** PTIA - Port A Input Register; 0x00000120 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIA0       :1;                                       /* Port A input data bit 0 */
    byte PTIA1       :1;                                       /* Port A input data bit 1 */
    byte PTIA2       :1;                                       /* Port A input data bit 2 */
    byte PTIA3       :1;                                       /* Port A input data bit 3 */
    byte PTIA4       :1;                                       /* Port A input data bit 4 */
    byte PTIA5       :1;                                       /* Port A input data bit 5 */
    byte PTIA6       :1;                                       /* Port A input data bit 6 */
    byte PTIA7       :1;                                       /* Port A input data bit 7 */
  } Bits;
} PTIASTR;
extern volatile PTIASTR _PTIA @(REG_BASE + 0x00000120UL);
#define PTIA                            _PTIA.Byte
#define PTIA_PTIA0                      _PTIA.Bits.PTIA0
#define PTIA_PTIA1                      _PTIA.Bits.PTIA1
#define PTIA_PTIA2                      _PTIA.Bits.PTIA2
#define PTIA_PTIA3                      _PTIA.Bits.PTIA3
#define PTIA_PTIA4                      _PTIA.Bits.PTIA4
#define PTIA_PTIA5                      _PTIA.Bits.PTIA5
#define PTIA_PTIA6                      _PTIA.Bits.PTIA6
#define PTIA_PTIA7                      _PTIA.Bits.PTIA7

#define PTIA_PTIA0_MASK                 1U
#define PTIA_PTIA1_MASK                 2U
#define PTIA_PTIA2_MASK                 4U
#define PTIA_PTIA3_MASK                 8U
#define PTIA_PTIA4_MASK                 16U
#define PTIA_PTIA5_MASK                 32U
#define PTIA_PTIA6_MASK                 64U
#define PTIA_PTIA7_MASK                 128U


/*** PTIE - Port E Input Register; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIE0       :1;                                       /* Port E input data bit 0 */
    byte PTIE1       :1;                                       /* Port E input data bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIE :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIESTR;
extern volatile PTIESTR _PTIE @(REG_BASE + 0x00000121UL);
#define PTIE                            _PTIE.Byte
#define PTIE_PTIE0                      _PTIE.Bits.PTIE0
#define PTIE_PTIE1                      _PTIE.Bits.PTIE1
#define PTIE_PTIE                       _PTIE.MergedBits.grpPTIE

#define PTIE_PTIE0_MASK                 1U
#define PTIE_PTIE1_MASK                 2U
#define PTIE_PTIE_MASK                  3U
#define PTIE_PTIE_BITNUM                0U


/*** CPMULVCTL - Low Voltage Control Register; 0x000001F1 ***/
typedef union {
  byte Byte;
  struct {
    byte LVIF        :1;                                       /* Low-Voltage Interrupt Flag */
    byte LVIE        :1;                                       /* Low-Voltage Interrupt Enable Bit */
    byte LVDS        :1;                                       /* Low-Voltage Detect Status Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CPMULVCTLSTR;
extern volatile CPMULVCTLSTR _CPMULVCTL @(REG_BASE + 0x000001F1UL);
#define CPMULVCTL                       _CPMULVCTL.Byte
#define CPMULVCTL_LVIF                  _CPMULVCTL.Bits.LVIF
#define CPMULVCTL_LVIE                  _CPMULVCTL.Bits.LVIE
#define CPMULVCTL_LVDS                  _CPMULVCTL.Bits.LVDS

#define CPMULVCTL_LVIF_MASK             1U
#define CPMULVCTL_LVIE_MASK             2U
#define CPMULVCTL_LVDS_MASK             4U


/*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000001F8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000001F8 ***/
    union {
      byte Byte;
      struct {
        byte IRCTRIM8    :1;                                       /* IRC1M Frequency Trim Bit 8 */
        byte IRCTRIM9    :1;                                       /* IRC1M Frequency Trim Bit 9 */
        byte             :1; 
        byte             :1; 
        byte TCTRIM0     :1;                                       /* IRC1M temperature coeficient Trim Bit 0 */
        byte TCTRIM1     :1;                                       /* IRC1M temperature coeficient Trim Bit 1 */
        byte TCTRIM2     :1;                                       /* IRC1M temperature coeficient Trim Bit 2 */
        byte TCTRIM3     :1;                                       /* IRC1M temperature coeficient Trim Bit 3 */
      } Bits;
      struct {
        byte grpIRCTRIM_8 :2;
        byte     :1;
        byte     :1;
        byte grpTCTRIM :4;
      } MergedBits;
    } CPMUIRCTRIMHSTR;
    #define CPMUIRCTRIMH                _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Byte
    #define CPMUIRCTRIMH_IRCTRIM8       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.IRCTRIM8
    #define CPMUIRCTRIMH_IRCTRIM9       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.IRCTRIM9
    #define CPMUIRCTRIMH_TCTRIM0        _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.TCTRIM0
    #define CPMUIRCTRIMH_TCTRIM1        _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.TCTRIM1
    #define CPMUIRCTRIMH_TCTRIM2        _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.TCTRIM2
    #define CPMUIRCTRIMH_TCTRIM3        _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.TCTRIM3
    #define CPMUIRCTRIMH_IRCTRIM_8      _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.MergedBits.grpIRCTRIM_8
    #define CPMUIRCTRIMH_TCTRIM         _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.MergedBits.grpTCTRIM
    #define CPMUIRCTRIMH_IRCTRIM        CPMUIRCTRIMH_IRCTRIM_8
    
    #define CPMUIRCTRIMH_IRCTRIM8_MASK  1U
    #define CPMUIRCTRIMH_IRCTRIM9_MASK  2U
    #define CPMUIRCTRIMH_TCTRIM0_MASK   16U
    #define CPMUIRCTRIMH_TCTRIM1_MASK   32U
    #define CPMUIRCTRIMH_TCTRIM2_MASK   64U
    #define CPMUIRCTRIMH_TCTRIM3_MASK   128U
    #define CPMUIRCTRIMH_IRCTRIM_8_MASK 3U
    #define CPMUIRCTRIMH_IRCTRIM_8_BITNUM 0U
    #define CPMUIRCTRIMH_TCTRIM_MASK    240U
    #define CPMUIRCTRIMH_TCTRIM_BITNUM  4U
    

    /*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000001F9 ***/
    union {
      byte Byte;
      struct {
        byte IRCTRIM0    :1;                                       /* IRC1M Frequency Trim Bit 0 */
        byte IRCTRIM1    :1;                                       /* IRC1M Frequency Trim Bit 1 */
        byte IRCTRIM2    :1;                                       /* IRC1M Frequency Trim Bit 2 */
        byte IRCTRIM3    :1;                                       /* IRC1M Frequency Trim Bit 3 */
        byte IRCTRIM4    :1;                                       /* IRC1M Frequency Trim Bit 4 */
        byte IRCTRIM5    :1;                                       /* IRC1M Frequency Trim Bit 5 */
        byte IRCTRIM6    :1;                                       /* IRC1M Frequency Trim Bit 6 */
        byte IRCTRIM7    :1;                                       /* IRC1M Frequency Trim Bit 7 */
      } Bits;
    } CPMUIRCTRIMLSTR;
    #define CPMUIRCTRIML                _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Byte
    #define CPMUIRCTRIML_IRCTRIM0       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM0
    #define CPMUIRCTRIML_IRCTRIM1       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM1
    #define CPMUIRCTRIML_IRCTRIM2       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM2
    #define CPMUIRCTRIML_IRCTRIM3       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM3
    #define CPMUIRCTRIML_IRCTRIM4       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM4
    #define CPMUIRCTRIML_IRCTRIM5       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM5
    #define CPMUIRCTRIML_IRCTRIM6       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM6
    #define CPMUIRCTRIML_IRCTRIM7       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM7
    
    #define CPMUIRCTRIML_IRCTRIM0_MASK  1U
    #define CPMUIRCTRIML_IRCTRIM1_MASK  2U
    #define CPMUIRCTRIML_IRCTRIM2_MASK  4U
    #define CPMUIRCTRIML_IRCTRIM3_MASK  8U
    #define CPMUIRCTRIML_IRCTRIM4_MASK  16U
    #define CPMUIRCTRIML_IRCTRIM5_MASK  32U
    #define CPMUIRCTRIML_IRCTRIM6_MASK  64U
    #define CPMUIRCTRIML_IRCTRIM7_MASK  128U
    
  } Overlap_STR;

  struct {
    word IRCTRIM0    :1;                                       /* IRC1M Frequency Trim Bit 0 */
    word IRCTRIM1    :1;                                       /* IRC1M Frequency Trim Bit 1 */
    word IRCTRIM2    :1;                                       /* IRC1M Frequency Trim Bit 2 */
    word IRCTRIM3    :1;                                       /* IRC1M Frequency Trim Bit 3 */
    word IRCTRIM4    :1;                                       /* IRC1M Frequency Trim Bit 4 */
    word IRCTRIM5    :1;                                       /* IRC1M Frequency Trim Bit 5 */
    word IRCTRIM6    :1;                                       /* IRC1M Frequency Trim Bit 6 */
    word IRCTRIM7    :1;                                       /* IRC1M Frequency Trim Bit 7 */
    word IRCTRIM8    :1;                                       /* IRC1M Frequency Trim Bit 8 */
    word IRCTRIM9    :1;                                       /* IRC1M Frequency Trim Bit 9 */
    word             :1; 
    word             :1; 
    word TCTRIM0     :1;                                       /* IRC1M temperature coeficient Trim Bit 0 */
    word TCTRIM1     :1;                                       /* IRC1M temperature coeficient Trim Bit 1 */
    word TCTRIM2     :1;                                       /* IRC1M temperature coeficient Trim Bit 2 */
    word TCTRIM3     :1;                                       /* IRC1M temperature coeficient Trim Bit 3 */
  } Bits;
  struct {
    word grpIRCTRIM :10;
    word         :1;
    word         :1;
    word grpTCTRIM :4;
  } MergedBits;
} CPMUIRCTRIMSTR;
extern volatile CPMUIRCTRIMSTR _CPMUIRCTRIM @(REG_BASE + 0x000001F8UL);
#define CPMUIRCTRIM                     _CPMUIRCTRIM.Word
#define CPMUIRCTRIM_IRCTRIM0            _CPMUIRCTRIM.Bits.IRCTRIM0
#define CPMUIRCTRIM_IRCTRIM1            _CPMUIRCTRIM.Bits.IRCTRIM1
#define CPMUIRCTRIM_IRCTRIM2            _CPMUIRCTRIM.Bits.IRCTRIM2
#define CPMUIRCTRIM_IRCTRIM3            _CPMUIRCTRIM.Bits.IRCTRIM3
#define CPMUIRCTRIM_IRCTRIM4            _CPMUIRCTRIM.Bits.IRCTRIM4
#define CPMUIRCTRIM_IRCTRIM5            _CPMUIRCTRIM.Bits.IRCTRIM5
#define CPMUIRCTRIM_IRCTRIM6            _CPMUIRCTRIM.Bits.IRCTRIM6
#define CPMUIRCTRIM_IRCTRIM7            _CPMUIRCTRIM.Bits.IRCTRIM7
#define CPMUIRCTRIM_IRCTRIM8            _CPMUIRCTRIM.Bits.IRCTRIM8
#define CPMUIRCTRIM_IRCTRIM9            _CPMUIRCTRIM.Bits.IRCTRIM9
#define CPMUIRCTRIM_TCTRIM0             _CPMUIRCTRIM.Bits.TCTRIM0
#define CPMUIRCTRIM_TCTRIM1             _CPMUIRCTRIM.Bits.TCTRIM1
#define CPMUIRCTRIM_TCTRIM2             _CPMUIRCTRIM.Bits.TCTRIM2
#define CPMUIRCTRIM_TCTRIM3             _CPMUIRCTRIM.Bits.TCTRIM3
#define CPMUIRCTRIM_IRCTRIM             _CPMUIRCTRIM.MergedBits.grpIRCTRIM
#define CPMUIRCTRIM_TCTRIM              _CPMUIRCTRIM.MergedBits.grpTCTRIM

#define CPMUIRCTRIM_IRCTRIM0_MASK       1U
#define CPMUIRCTRIM_IRCTRIM1_MASK       2U
#define CPMUIRCTRIM_IRCTRIM2_MASK       4U
#define CPMUIRCTRIM_IRCTRIM3_MASK       8U
#define CPMUIRCTRIM_IRCTRIM4_MASK       16U
#define CPMUIRCTRIM_IRCTRIM5_MASK       32U
#define CPMUIRCTRIM_IRCTRIM6_MASK       64U
#define CPMUIRCTRIM_IRCTRIM7_MASK       128U
#define CPMUIRCTRIM_IRCTRIM8_MASK       256U
#define CPMUIRCTRIM_IRCTRIM9_MASK       512U
#define CPMUIRCTRIM_TCTRIM0_MASK        4096U
#define CPMUIRCTRIM_TCTRIM1_MASK        8192U
#define CPMUIRCTRIM_TCTRIM2_MASK        16384U
#define CPMUIRCTRIM_TCTRIM3_MASK        32768U
#define CPMUIRCTRIM_IRCTRIM_MASK        1023U
#define CPMUIRCTRIM_IRCTRIM_BITNUM      0U
#define CPMUIRCTRIM_TCTRIM_MASK         61440U
#define CPMUIRCTRIM_TCTRIM_BITNUM       12U


/*** CPMUOSC - S12CPMU Oscillator Register; 0x000001FA ***/
typedef union {
  byte Byte;
  struct {
    byte OSCFILT0    :1;                                       /* Oscillator Filter Bits, bit 0 */
    byte OSCFILT1    :1;                                       /* Oscillator Filter Bits, bit 1 */
    byte OSCFILT2    :1;                                       /* Oscillator Filter Bits, bit 2 */
    byte OSCFILT3    :1;                                       /* Oscillator Filter Bits, bit 3 */
    byte OSCFILT4    :1;                                       /* Oscillator Filter Bits, bit 4 */
    byte OSCPINS_EN  :1;                                       /* Oscillator Pins EXTAL and XTAL Enable Bit */
    byte OSCBW       :1;                                       /* Oscillator Filter Bandwidth Bit */
    byte OSCE        :1;                                       /* Oscillator Enable Bit */
  } Bits;
  struct {
    byte grpOSCFILT :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CPMUOSCSTR;
extern volatile CPMUOSCSTR _CPMUOSC @(REG_BASE + 0x000001FAUL);
#define CPMUOSC                         _CPMUOSC.Byte
#define CPMUOSC_OSCFILT0                _CPMUOSC.Bits.OSCFILT0
#define CPMUOSC_OSCFILT1                _CPMUOSC.Bits.OSCFILT1
#define CPMUOSC_OSCFILT2                _CPMUOSC.Bits.OSCFILT2
#define CPMUOSC_OSCFILT3                _CPMUOSC.Bits.OSCFILT3
#define CPMUOSC_OSCFILT4                _CPMUOSC.Bits.OSCFILT4
#define CPMUOSC_OSCPINS_EN              _CPMUOSC.Bits.OSCPINS_EN
#define CPMUOSC_OSCBW                   _CPMUOSC.Bits.OSCBW
#define CPMUOSC_OSCE                    _CPMUOSC.Bits.OSCE
#define CPMUOSC_OSCFILT                 _CPMUOSC.MergedBits.grpOSCFILT

#define CPMUOSC_OSCFILT0_MASK           1U
#define CPMUOSC_OSCFILT1_MASK           2U
#define CPMUOSC_OSCFILT2_MASK           4U
#define CPMUOSC_OSCFILT3_MASK           8U
#define CPMUOSC_OSCFILT4_MASK           16U
#define CPMUOSC_OSCPINS_EN_MASK         32U
#define CPMUOSC_OSCBW_MASK              64U
#define CPMUOSC_OSCE_MASK               128U
#define CPMUOSC_OSCFILT_MASK            31U
#define CPMUOSC_OSCFILT_BITNUM          0U


/*** CPMUPROT - S12CPMUV1 Protection Register; 0x000001FB ***/
typedef union {
  byte Byte;
  struct {
    byte PROT        :1;                                       /* Clock Configuration Registers Protection Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CPMUPROTSTR;
extern volatile CPMUPROTSTR _CPMUPROT @(REG_BASE + 0x000001FBUL);
#define CPMUPROT                        _CPMUPROT.Byte
#define CPMUPROT_PROT                   _CPMUPROT.Bits.PROT

#define CPMUPROT_PROT_MASK              1U


/*** B_PCR_CTL - PCR Control Register; 0x00000200 ***/
typedef union {
  word Word;
  struct {
    word OPM         :2;                                       /* Operation mode select 0 */
    word PF          :2;                                       /* 1 ms Prescaler 0 */
    word             :1; 
    word HWR         :1;                                       /* Hardware Reset */
    word UVIE        :1;                                       /* Low Supply Voltage Interrupt enable */
    word HTIE        :1;                                       /* High Temperature Interrupt enable */
    word OPMM        :2;                                       /* Operation mode mask 0 */
    word PFM         :2;                                       /* Prescalar factor mask 0 */
    word             :1; 
    word HWRM        :1;                                       /* Hardware reset mask */
    word UVIEM       :1;                                       /* Supply Under Voltage interrupt enable mask */
    word HTIEM       :1;                                       /* High temperature interrupt enable mask */
  } Bits;
} B_PCR_CTLSTR;
extern volatile B_PCR_CTLSTR _B_PCR_CTL @(REG_BASE + 0x00000200UL);
#define B_PCR_CTL                       _B_PCR_CTL.Word
#define B_PCR_CTL_OPM                   _B_PCR_CTL.Bits.OPM
#define B_PCR_CTL_PF                    _B_PCR_CTL.Bits.PF
#define B_PCR_CTL_HWR                   _B_PCR_CTL.Bits.HWR
#define B_PCR_CTL_UVIE                  _B_PCR_CTL.Bits.UVIE
#define B_PCR_CTL_HTIE                  _B_PCR_CTL.Bits.HTIE
#define B_PCR_CTL_OPMM                  _B_PCR_CTL.Bits.OPMM
#define B_PCR_CTL_PFM                   _B_PCR_CTL.Bits.PFM
#define B_PCR_CTL_HWRM                  _B_PCR_CTL.Bits.HWRM
#define B_PCR_CTL_UVIEM                 _B_PCR_CTL.Bits.UVIEM
#define B_PCR_CTL_HTIEM                 _B_PCR_CTL.Bits.HTIEM

#define B_PCR_CTL_OPM_MASK              3U
#define B_PCR_CTL_OPM_BITNUM            0U
#define B_PCR_CTL_PF_MASK               12U
#define B_PCR_CTL_PF_BITNUM             2U
#define B_PCR_CTL_HWR_MASK              32U
#define B_PCR_CTL_UVIE_MASK             64U
#define B_PCR_CTL_HTIE_MASK             128U
#define B_PCR_CTL_OPMM_MASK             768U
#define B_PCR_CTL_OPMM_BITNUM           8U
#define B_PCR_CTL_PFM_MASK              3072U
#define B_PCR_CTL_PFM_BITNUM            10U
#define B_PCR_CTL_HWRM_MASK             8192U
#define B_PCR_CTL_UVIEM_MASK            16384U
#define B_PCR_CTL_HTIEM_MASK            32768U


/*** B_PCR_SR - PCR Status Register; 0x00000202 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_PCR_SRH - PCR Status Register High; 0x00000202 ***/
    union {
      byte Byte;
      struct {
        byte WLPMF       :1;                                       /* Wake-up after Low Power Mode Flag */
        byte WULTCF      :1;                                       /* Life Time Counter Wake Up Flag */
        byte LVRF        :1;                                       /* VDDL Low Voltage (POR) Reset Flag */
        byte HVRF        :1;                                       /* VDDH Low Voltage Reset Flag */
        byte WDRF        :1;                                       /* Watchdog Reset Flag */
        byte HWRF        :1;                                       /* Hardware Reset Flag */
        byte UVF         :1;                                       /* Supply Undervoltage Condition Flag */
        byte HTF         :1;                                       /* High Temperature Condition Flag */
      } Bits;
    } B_PCR_SRHSTR;
    #define B_PCR_SRH                   _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Byte
    #define B_PCR_SRH_WLPMF             _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Bits.WLPMF
    #define B_PCR_SRH_WULTCF            _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Bits.WULTCF
    #define B_PCR_SRH_LVRF              _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Bits.LVRF
    #define B_PCR_SRH_HVRF              _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Bits.HVRF
    #define B_PCR_SRH_WDRF              _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Bits.WDRF
    #define B_PCR_SRH_HWRF              _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Bits.HWRF
    #define B_PCR_SRH_UVF               _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Bits.UVF
    #define B_PCR_SRH_HTF               _B_PCR_SR.Overlap_STR.B_PCR_SRHSTR.Bits.HTF
    
    #define B_PCR_SRH_WLPMF_MASK        1U
    #define B_PCR_SRH_WULTCF_MASK       2U
    #define B_PCR_SRH_LVRF_MASK         4U
    #define B_PCR_SRH_HVRF_MASK         8U
    #define B_PCR_SRH_WDRF_MASK         16U
    #define B_PCR_SRH_HWRF_MASK         32U
    #define B_PCR_SRH_UVF_MASK          64U
    #define B_PCR_SRH_HTF_MASK          128U
    

    /*** B_PCR_SRL - PCR Status Register Low; 0x00000203 ***/
    union {
      byte Byte;
      struct {
        byte WUPTB0F     :1;                                       /* Wake-up on GPIO 0 event flag */
        byte WUPTB1F     :1;                                       /* Wake-up on GPIO 1 event flag */
        byte WUPTB2F     :1;                                       /* Wake-up on GPIO 2 event flag */
        byte WUPTB3F     :1;                                       /* Wake-up on GPIO 3 event flag */
        byte WULINF      :1;                                       /* Wake-up on LIN flag */
        byte WUCALF      :1;                                       /* Wake-up on calibration request flag */
        byte WUCTHF      :1;                                       /* Wake-up on current threshold Flag */
        byte WUAHTHF     :1;                                       /* Wake-up on Ah counter threshold Flag */
      } Bits;
    } B_PCR_SRLSTR;
    #define B_PCR_SRL                   _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Byte
    #define B_PCR_SRL_WUPTB0F           _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Bits.WUPTB0F
    #define B_PCR_SRL_WUPTB1F           _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Bits.WUPTB1F
    #define B_PCR_SRL_WUPTB2F           _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Bits.WUPTB2F
    #define B_PCR_SRL_WUPTB3F           _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Bits.WUPTB3F
    #define B_PCR_SRL_WULINF            _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Bits.WULINF
    #define B_PCR_SRL_WUCALF            _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Bits.WUCALF
    #define B_PCR_SRL_WUCTHF            _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Bits.WUCTHF
    #define B_PCR_SRL_WUAHTHF           _B_PCR_SR.Overlap_STR.B_PCR_SRLSTR.Bits.WUAHTHF
    
    #define B_PCR_SRL_WUPTB0F_MASK      1U
    #define B_PCR_SRL_WUPTB1F_MASK      2U
    #define B_PCR_SRL_WUPTB2F_MASK      4U
    #define B_PCR_SRL_WUPTB3F_MASK      8U
    #define B_PCR_SRL_WULINF_MASK       16U
    #define B_PCR_SRL_WUCALF_MASK       32U
    #define B_PCR_SRL_WUCTHF_MASK       64U
    #define B_PCR_SRL_WUAHTHF_MASK      128U
    
  } Overlap_STR;

  struct {
    word WUPTB0F     :1;                                       /* Wake-up on GPIO 0 event flag */
    word WUPTB1F     :1;                                       /* Wake-up on GPIO 1 event flag */
    word WUPTB2F     :1;                                       /* Wake-up on GPIO 2 event flag */
    word WUPTB3F     :1;                                       /* Wake-up on GPIO 3 event flag */
    word WULINF      :1;                                       /* Wake-up on LIN flag */
    word WUCALF      :1;                                       /* Wake-up on calibration request flag */
    word WUCTHF      :1;                                       /* Wake-up on current threshold Flag */
    word WUAHTHF     :1;                                       /* Wake-up on Ah counter threshold Flag */
    word WLPMF       :1;                                       /* Wake-up after Low Power Mode Flag */
    word WULTCF      :1;                                       /* Life Time Counter Wake Up Flag */
    word LVRF        :1;                                       /* VDDL Low Voltage (POR) Reset Flag */
    word HVRF        :1;                                       /* VDDH Low Voltage Reset Flag */
    word WDRF        :1;                                       /* Watchdog Reset Flag */
    word HWRF        :1;                                       /* Hardware Reset Flag */
    word UVF         :1;                                       /* Supply Undervoltage Condition Flag */
    word HTF         :1;                                       /* High Temperature Condition Flag */
  } Bits;
} B_PCR_SRSTR;
extern volatile B_PCR_SRSTR _B_PCR_SR @(REG_BASE + 0x00000202UL);
#define B_PCR_SR                        _B_PCR_SR.Word
#define B_PCR_SR_WUPTB0F                _B_PCR_SR.Bits.WUPTB0F
#define B_PCR_SR_WUPTB1F                _B_PCR_SR.Bits.WUPTB1F
#define B_PCR_SR_WUPTB2F                _B_PCR_SR.Bits.WUPTB2F
#define B_PCR_SR_WUPTB3F                _B_PCR_SR.Bits.WUPTB3F
#define B_PCR_SR_WULINF                 _B_PCR_SR.Bits.WULINF
#define B_PCR_SR_WUCALF                 _B_PCR_SR.Bits.WUCALF
#define B_PCR_SR_WUCTHF                 _B_PCR_SR.Bits.WUCTHF
#define B_PCR_SR_WUAHTHF                _B_PCR_SR.Bits.WUAHTHF
#define B_PCR_SR_WLPMF                  _B_PCR_SR.Bits.WLPMF
#define B_PCR_SR_WULTCF                 _B_PCR_SR.Bits.WULTCF
#define B_PCR_SR_LVRF                   _B_PCR_SR.Bits.LVRF
#define B_PCR_SR_HVRF                   _B_PCR_SR.Bits.HVRF
#define B_PCR_SR_WDRF                   _B_PCR_SR.Bits.WDRF
#define B_PCR_SR_HWRF                   _B_PCR_SR.Bits.HWRF
#define B_PCR_SR_UVF                    _B_PCR_SR.Bits.UVF
#define B_PCR_SR_HTF                    _B_PCR_SR.Bits.HTF

#define B_PCR_SR_WUPTB0F_MASK           1U
#define B_PCR_SR_WUPTB1F_MASK           2U
#define B_PCR_SR_WUPTB2F_MASK           4U
#define B_PCR_SR_WUPTB3F_MASK           8U
#define B_PCR_SR_WULINF_MASK            16U
#define B_PCR_SR_WUCALF_MASK            32U
#define B_PCR_SR_WUCTHF_MASK            64U
#define B_PCR_SR_WUAHTHF_MASK           128U
#define B_PCR_SR_WLPMF_MASK             256U
#define B_PCR_SR_WULTCF_MASK            512U
#define B_PCR_SR_LVRF_MASK              1024U
#define B_PCR_SR_HVRF_MASK              2048U
#define B_PCR_SR_WDRF_MASK              4096U
#define B_PCR_SR_HWRF_MASK              8192U
#define B_PCR_SR_UVF_MASK               16384U
#define B_PCR_SR_HTF_MASK               32768U


/*** B_PCR_PRESC - PCR 1ms prescaler; 0x00000204 ***/
typedef union {
  word Word;
} B_PCR_PRESCSTR;
extern volatile B_PCR_PRESCSTR _B_PCR_PRESC @(REG_BASE + 0x00000204UL);
#define B_PCR_PRESC                     _B_PCR_PRESC.Word


/*** B_PCR_WUE - Wake Up Enable Register; 0x00000206 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_PCR_WUEH - Wake Up Enable Register High; 0x00000206 ***/
    union {
      byte Byte;
      struct {
        byte WUPTB0      :1;                                       /* Wake-up on GPIO 0 event */
        byte WUPTB1      :1;                                       /* Wake-up on GPIO 1 event */
        byte WUPTB2      :1;                                       /* Wake-up on GPIO 2 event */
        byte WUPTB3      :1;                                       /* Wake-up on GPIO 3 event */
        byte WULIN       :1;                                       /* Wake-up on LIN */
        byte WUCAL       :1;                                       /* Wake-up on calibration request */
        byte WUCTH       :1;                                       /* Wake-up on current threshold */
        byte WUAHTH      :1;                                       /* Wake-up on Ah counter */
      } Bits;
      struct {
        byte grpWUPTB :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } B_PCR_WUEHSTR;
    #define B_PCR_WUEH                  _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Byte
    #define B_PCR_WUEH_WUPTB0           _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Bits.WUPTB0
    #define B_PCR_WUEH_WUPTB1           _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Bits.WUPTB1
    #define B_PCR_WUEH_WUPTB2           _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Bits.WUPTB2
    #define B_PCR_WUEH_WUPTB3           _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Bits.WUPTB3
    #define B_PCR_WUEH_WULIN            _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Bits.WULIN
    #define B_PCR_WUEH_WUCAL            _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Bits.WUCAL
    #define B_PCR_WUEH_WUCTH            _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Bits.WUCTH
    #define B_PCR_WUEH_WUAHTH           _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.Bits.WUAHTH
    #define B_PCR_WUEH_WUPTB            _B_PCR_WUE.Overlap_STR.B_PCR_WUEHSTR.MergedBits.grpWUPTB
    
    #define B_PCR_WUEH_WUPTB0_MASK      1U
    #define B_PCR_WUEH_WUPTB1_MASK      2U
    #define B_PCR_WUEH_WUPTB2_MASK      4U
    #define B_PCR_WUEH_WUPTB3_MASK      8U
    #define B_PCR_WUEH_WULIN_MASK       16U
    #define B_PCR_WUEH_WUCAL_MASK       32U
    #define B_PCR_WUEH_WUCTH_MASK       64U
    #define B_PCR_WUEH_WUAHTH_MASK      128U
    #define B_PCR_WUEH_WUPTB_MASK       15U
    #define B_PCR_WUEH_WUPTB_BITNUM     0U
    

    /*** B_PCR_WUEL - Wake Up Enable Register Low; 0x00000207 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte WULTC       :1;                                       /* Wake-up on Life Timer Counter Overflow */
      } Bits;
    } B_PCR_WUELSTR;
    #define B_PCR_WUEL                  _B_PCR_WUE.Overlap_STR.B_PCR_WUELSTR.Byte
    #define B_PCR_WUEL_WULTC            _B_PCR_WUE.Overlap_STR.B_PCR_WUELSTR.Bits.WULTC
    
    #define B_PCR_WUEL_WULTC_MASK       128U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word WULTC       :1;                                       /* Wake-up on Life Timer Counter Overflow */
    word WUPTB0      :1;                                       /* Wake-up on GPIO 0 event */
    word WUPTB1      :1;                                       /* Wake-up on GPIO 1 event */
    word WUPTB2      :1;                                       /* Wake-up on GPIO 2 event */
    word WUPTB3      :1;                                       /* Wake-up on GPIO 3 event */
    word WULIN       :1;                                       /* Wake-up on LIN */
    word WUCAL       :1;                                       /* Wake-up on calibration request */
    word WUCTH       :1;                                       /* Wake-up on current threshold */
    word WUAHTH      :1;                                       /* Wake-up on Ah counter */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpWUPTB :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} B_PCR_WUESTR;
extern volatile B_PCR_WUESTR _B_PCR_WUE @(REG_BASE + 0x00000206UL);
#define B_PCR_WUE                       _B_PCR_WUE.Word
#define B_PCR_WUE_WULTC                 _B_PCR_WUE.Bits.WULTC
#define B_PCR_WUE_WUPTB0                _B_PCR_WUE.Bits.WUPTB0
#define B_PCR_WUE_WUPTB1                _B_PCR_WUE.Bits.WUPTB1
#define B_PCR_WUE_WUPTB2                _B_PCR_WUE.Bits.WUPTB2
#define B_PCR_WUE_WUPTB3                _B_PCR_WUE.Bits.WUPTB3
#define B_PCR_WUE_WULIN                 _B_PCR_WUE.Bits.WULIN
#define B_PCR_WUE_WUCAL                 _B_PCR_WUE.Bits.WUCAL
#define B_PCR_WUE_WUCTH                 _B_PCR_WUE.Bits.WUCTH
#define B_PCR_WUE_WUAHTH                _B_PCR_WUE.Bits.WUAHTH
#define B_PCR_WUE_WUPTB                 _B_PCR_WUE.MergedBits.grpWUPTB

#define B_PCR_WUE_WULTC_MASK            128U
#define B_PCR_WUE_WUPTB0_MASK           256U
#define B_PCR_WUE_WUPTB1_MASK           512U
#define B_PCR_WUE_WUPTB2_MASK           1024U
#define B_PCR_WUE_WUPTB3_MASK           2048U
#define B_PCR_WUE_WULIN_MASK            4096U
#define B_PCR_WUE_WUCAL_MASK            8192U
#define B_PCR_WUE_WUCTH_MASK            16384U
#define B_PCR_WUE_WUAHTH_MASK           32768U
#define B_PCR_WUE_WUPTB_MASK            3840U
#define B_PCR_WUE_WUPTB_BITNUM          8U


/*** B_INT_SRC - Interrupt source register; 0x00000208 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_INT_SRCH - Interrupt source register high; 0x00000208 ***/
    union {
      byte Byte;
      struct {
        byte UVI         :1;                                       /* Undervoltage Interrupt pending or wake up from Cranking Mode Status */
        byte HTI         :1;                                       /* High Temperature Interrupt Status */
        byte LTI         :1;                                       /* LIN Driver Over Temperature Interrupt Status */
        byte CH0         :1;                                       /* TIM16B4C - TIM Channel 0 Interrupt Status */
        byte CH1         :1;                                       /* TIM16B4C - TIM Channel 1 Interrupt Status */
        byte CH2         :1;                                       /* TIM16B4C - TIM Channel 2 Interrupt Status */
        byte CH3         :1;                                       /* TIM16B4C - TIM Channel 3 Interrupt Status */
        byte TOV         :1;                                       /* TIM16B4C - Timer Overflow Interrupt Status */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpCH :4;
        byte     :1;
      } MergedBits;
    } B_INT_SRCHSTR;
    #define B_INT_SRCH                  _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Byte
    #define B_INT_SRCH_UVI              _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Bits.UVI
    #define B_INT_SRCH_HTI              _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Bits.HTI
    #define B_INT_SRCH_LTI              _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Bits.LTI
    #define B_INT_SRCH_CH0              _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Bits.CH0
    #define B_INT_SRCH_CH1              _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Bits.CH1
    #define B_INT_SRCH_CH2              _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Bits.CH2
    #define B_INT_SRCH_CH3              _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Bits.CH3
    #define B_INT_SRCH_TOV              _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.Bits.TOV
    #define B_INT_SRCH_CH               _B_INT_SRC.Overlap_STR.B_INT_SRCHSTR.MergedBits.grpCH
    
    #define B_INT_SRCH_UVI_MASK         1U
    #define B_INT_SRCH_HTI_MASK         2U
    #define B_INT_SRCH_LTI_MASK         4U
    #define B_INT_SRCH_CH0_MASK         8U
    #define B_INT_SRCH_CH1_MASK         16U
    #define B_INT_SRCH_CH2_MASK         32U
    #define B_INT_SRCH_CH3_MASK         64U
    #define B_INT_SRCH_TOV_MASK         128U
    #define B_INT_SRCH_CH_MASK          120U
    #define B_INT_SRCH_CH_BITNUM        3U
    

    /*** B_INT_SRCL - Interrupt source register low; 0x00000209 ***/
    union {
      byte Byte;
      struct {
        byte ERR         :1;                                       /* SCI Error Interrupt Status */
        byte TX          :1;                                       /* SCI Transmit Interrupt Status */
        byte RX          :1;                                       /* SCI Receive Interrupt Status */
        byte CVMI        :1;                                       /* Current / Voltage Measurement Interrupt Status */
        byte LTC         :1;                                       /* Life Time Counter Interrupt Status */
        byte CAL         :1;                                       /* Calibration Request Interrupt Status */
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_INT_SRCLSTR;
    #define B_INT_SRCL                  _B_INT_SRC.Overlap_STR.B_INT_SRCLSTR.Byte
    #define B_INT_SRCL_ERR              _B_INT_SRC.Overlap_STR.B_INT_SRCLSTR.Bits.ERR
    #define B_INT_SRCL_TX               _B_INT_SRC.Overlap_STR.B_INT_SRCLSTR.Bits.TX
    #define B_INT_SRCL_RX               _B_INT_SRC.Overlap_STR.B_INT_SRCLSTR.Bits.RX
    #define B_INT_SRCL_CVMI             _B_INT_SRC.Overlap_STR.B_INT_SRCLSTR.Bits.CVMI
    #define B_INT_SRCL_LTC              _B_INT_SRC.Overlap_STR.B_INT_SRCLSTR.Bits.LTC
    #define B_INT_SRCL_CAL              _B_INT_SRC.Overlap_STR.B_INT_SRCLSTR.Bits.CAL
    
    #define B_INT_SRCL_ERR_MASK         1U
    #define B_INT_SRCL_TX_MASK          2U
    #define B_INT_SRCL_RX_MASK          4U
    #define B_INT_SRCL_CVMI_MASK        8U
    #define B_INT_SRCL_LTC_MASK         16U
    #define B_INT_SRCL_CAL_MASK         32U
    
  } Overlap_STR;

  struct {
    word ERR         :1;                                       /* SCI Error Interrupt Status */
    word TX          :1;                                       /* SCI Transmit Interrupt Status */
    word RX          :1;                                       /* SCI Receive Interrupt Status */
    word CVMI        :1;                                       /* Current / Voltage Measurement Interrupt Status */
    word LTC         :1;                                       /* Life Time Counter Interrupt Status */
    word CAL         :1;                                       /* Calibration Request Interrupt Status */
    word             :1; 
    word             :1; 
    word UVI         :1;                                       /* Undervoltage Interrupt pending or wake up from Cranking Mode Status */
    word HTI         :1;                                       /* High Temperature Interrupt Status */
    word LTI         :1;                                       /* LIN Driver Over Temperature Interrupt Status */
    word CH0         :1;                                       /* TIM16B4C - TIM Channel 0 Interrupt Status */
    word CH1         :1;                                       /* TIM16B4C - TIM Channel 1 Interrupt Status */
    word CH2         :1;                                       /* TIM16B4C - TIM Channel 2 Interrupt Status */
    word CH3         :1;                                       /* TIM16B4C - TIM Channel 3 Interrupt Status */
    word TOV         :1;                                       /* TIM16B4C - Timer Overflow Interrupt Status */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpCH   :4;
    word         :1;
  } MergedBits;
} B_INT_SRCSTR;
extern volatile B_INT_SRCSTR _B_INT_SRC @(REG_BASE + 0x00000208UL);
#define B_INT_SRC                       _B_INT_SRC.Word
#define B_INT_SRC_ERR                   _B_INT_SRC.Bits.ERR
#define B_INT_SRC_TX                    _B_INT_SRC.Bits.TX
#define B_INT_SRC_RX                    _B_INT_SRC.Bits.RX
#define B_INT_SRC_CVMI                  _B_INT_SRC.Bits.CVMI
#define B_INT_SRC_LTC                   _B_INT_SRC.Bits.LTC
#define B_INT_SRC_CAL                   _B_INT_SRC.Bits.CAL
#define B_INT_SRC_UVI                   _B_INT_SRC.Bits.UVI
#define B_INT_SRC_HTI                   _B_INT_SRC.Bits.HTI
#define B_INT_SRC_LTI                   _B_INT_SRC.Bits.LTI
#define B_INT_SRC_CH0                   _B_INT_SRC.Bits.CH0
#define B_INT_SRC_CH1                   _B_INT_SRC.Bits.CH1
#define B_INT_SRC_CH2                   _B_INT_SRC.Bits.CH2
#define B_INT_SRC_CH3                   _B_INT_SRC.Bits.CH3
#define B_INT_SRC_TOV                   _B_INT_SRC.Bits.TOV
#define B_INT_SRC_CH                    _B_INT_SRC.MergedBits.grpCH

#define B_INT_SRC_ERR_MASK              1U
#define B_INT_SRC_TX_MASK               2U
#define B_INT_SRC_RX_MASK               4U
#define B_INT_SRC_CVMI_MASK             8U
#define B_INT_SRC_LTC_MASK              16U
#define B_INT_SRC_CAL_MASK              32U
#define B_INT_SRC_UVI_MASK              256U
#define B_INT_SRC_HTI_MASK              512U
#define B_INT_SRC_LTI_MASK              1024U
#define B_INT_SRC_CH0_MASK              2048U
#define B_INT_SRC_CH1_MASK              4096U
#define B_INT_SRC_CH2_MASK              8192U
#define B_INT_SRC_CH3_MASK              16384U
#define B_INT_SRC_TOV_MASK              32768U
#define B_INT_SRC_CH_MASK               30720U
#define B_INT_SRC_CH_BITNUM             11U


/*** B_INT_VECT - Interrupt vector register; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte IRQ         :4;                                       /* Represents the highest prioritized interrupt pending */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_INT_VECTSTR;
extern volatile B_INT_VECTSTR _B_INT_VECT @(REG_BASE + 0x0000020AUL);
#define B_INT_VECT                      _B_INT_VECT.Byte
#define B_INT_VECT_IRQ                  _B_INT_VECT.Bits.IRQ

#define B_INT_VECT_IRQ_MASK             15U
#define B_INT_VECT_IRQ_BITNUM           0U


/*** B_INT_MSK - Interrupt mask register; 0x0000020C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_INT_MSKH - Interrupt mask register high; 0x0000020C ***/
    union {
      byte Byte;
      struct {
        byte UVIM        :1;                                       /* Undervoltage Interrupt Mask */
        byte HTIM        :1;                                       /* High Temperature Interrupt Mask */
        byte LTIM        :1;                                       /* LIN Driver Over Temperature Interrupt Mask */
        byte CH0M        :1;                                       /* Timer Channel 1 Interrupt Mask */
        byte CH1M        :1;                                       /* Timer Channel 1 Interrupt Mask */
        byte CH2M        :1;                                       /* Timer Channel 2 Interrupt Mask */
        byte CH3M        :1;                                       /* Timer Channel 3 Interrupt Mask */
        byte TOVM        :1;                                       /* Timer Overflow Interrupt Mask */
      } Bits;
    } B_INT_MSKHSTR;
    #define B_INT_MSKH                  _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Byte
    #define B_INT_MSKH_UVIM             _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Bits.UVIM
    #define B_INT_MSKH_HTIM             _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Bits.HTIM
    #define B_INT_MSKH_LTIM             _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Bits.LTIM
    #define B_INT_MSKH_CH0M             _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Bits.CH0M
    #define B_INT_MSKH_CH1M             _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Bits.CH1M
    #define B_INT_MSKH_CH2M             _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Bits.CH2M
    #define B_INT_MSKH_CH3M             _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Bits.CH3M
    #define B_INT_MSKH_TOVM             _B_INT_MSK.Overlap_STR.B_INT_MSKHSTR.Bits.TOVM
    
    #define B_INT_MSKH_UVIM_MASK        1U
    #define B_INT_MSKH_HTIM_MASK        2U
    #define B_INT_MSKH_LTIM_MASK        4U
    #define B_INT_MSKH_CH0M_MASK        8U
    #define B_INT_MSKH_CH1M_MASK        16U
    #define B_INT_MSKH_CH2M_MASK        32U
    #define B_INT_MSKH_CH3M_MASK        64U
    #define B_INT_MSKH_TOVM_MASK        128U
    

    /*** B_INT_MSKL - Interrupt mask register low; 0x0000020D ***/
    union {
      byte Byte;
      struct {
        byte ERRM        :1;                                       /* SCI Error Interrupt Mask */
        byte TXM         :1;                                       /* SCI Transmit Interrupt Mask */
        byte RXM         :1;                                       /* SCI Receive Interrupt Mask */
        byte CVMM        :1;                                       /* Current / Voltage Measurement Interrupt Mask */
        byte LTCM        :1;                                       /* Life Time Counter Interrupt Mask */
        byte CALM        :1;                                       /* Calibration Request Interrupt Mask */
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_INT_MSKLSTR;
    #define B_INT_MSKL                  _B_INT_MSK.Overlap_STR.B_INT_MSKLSTR.Byte
    #define B_INT_MSKL_ERRM             _B_INT_MSK.Overlap_STR.B_INT_MSKLSTR.Bits.ERRM
    #define B_INT_MSKL_TXM              _B_INT_MSK.Overlap_STR.B_INT_MSKLSTR.Bits.TXM
    #define B_INT_MSKL_RXM              _B_INT_MSK.Overlap_STR.B_INT_MSKLSTR.Bits.RXM
    #define B_INT_MSKL_CVMM             _B_INT_MSK.Overlap_STR.B_INT_MSKLSTR.Bits.CVMM
    #define B_INT_MSKL_LTCM             _B_INT_MSK.Overlap_STR.B_INT_MSKLSTR.Bits.LTCM
    #define B_INT_MSKL_CALM             _B_INT_MSK.Overlap_STR.B_INT_MSKLSTR.Bits.CALM
    
    #define B_INT_MSKL_ERRM_MASK        1U
    #define B_INT_MSKL_TXM_MASK         2U
    #define B_INT_MSKL_RXM_MASK         4U
    #define B_INT_MSKL_CVMM_MASK        8U
    #define B_INT_MSKL_LTCM_MASK        16U
    #define B_INT_MSKL_CALM_MASK        32U
    
  } Overlap_STR;

  struct {
    word ERRM        :1;                                       /* SCI Error Interrupt Mask */
    word TXM         :1;                                       /* SCI Transmit Interrupt Mask */
    word RXM         :1;                                       /* SCI Receive Interrupt Mask */
    word CVMM        :1;                                       /* Current / Voltage Measurement Interrupt Mask */
    word LTCM        :1;                                       /* Life Time Counter Interrupt Mask */
    word CALM        :1;                                       /* Calibration Request Interrupt Mask */
    word             :1; 
    word             :1; 
    word UVIM        :1;                                       /* Undervoltage Interrupt Mask */
    word HTIM        :1;                                       /* High Temperature Interrupt Mask */
    word LTIM        :1;                                       /* LIN Driver Over Temperature Interrupt Mask */
    word CH0M        :1;                                       /* Timer Channel 1 Interrupt Mask */
    word CH1M        :1;                                       /* Timer Channel 1 Interrupt Mask */
    word CH2M        :1;                                       /* Timer Channel 2 Interrupt Mask */
    word CH3M        :1;                                       /* Timer Channel 3 Interrupt Mask */
    word TOVM        :1;                                       /* Timer Overflow Interrupt Mask */
  } Bits;
} B_INT_MSKSTR;
extern volatile B_INT_MSKSTR _B_INT_MSK @(REG_BASE + 0x0000020CUL);
#define B_INT_MSK                       _B_INT_MSK.Word
#define B_INT_MSK_ERRM                  _B_INT_MSK.Bits.ERRM
#define B_INT_MSK_TXM                   _B_INT_MSK.Bits.TXM
#define B_INT_MSK_RXM                   _B_INT_MSK.Bits.RXM
#define B_INT_MSK_CVMM                  _B_INT_MSK.Bits.CVMM
#define B_INT_MSK_LTCM                  _B_INT_MSK.Bits.LTCM
#define B_INT_MSK_CALM                  _B_INT_MSK.Bits.CALM
#define B_INT_MSK_UVIM                  _B_INT_MSK.Bits.UVIM
#define B_INT_MSK_HTIM                  _B_INT_MSK.Bits.HTIM
#define B_INT_MSK_LTIM                  _B_INT_MSK.Bits.LTIM
#define B_INT_MSK_CH0M                  _B_INT_MSK.Bits.CH0M
#define B_INT_MSK_CH1M                  _B_INT_MSK.Bits.CH1M
#define B_INT_MSK_CH2M                  _B_INT_MSK.Bits.CH2M
#define B_INT_MSK_CH3M                  _B_INT_MSK.Bits.CH3M
#define B_INT_MSK_TOVM                  _B_INT_MSK.Bits.TOVM

#define B_INT_MSK_ERRM_MASK             1U
#define B_INT_MSK_TXM_MASK              2U
#define B_INT_MSK_RXM_MASK              4U
#define B_INT_MSK_CVMM_MASK             8U
#define B_INT_MSK_LTCM_MASK             16U
#define B_INT_MSK_CALM_MASK             32U
#define B_INT_MSK_UVIM_MASK             256U
#define B_INT_MSK_HTIM_MASK             512U
#define B_INT_MSK_LTIM_MASK             1024U
#define B_INT_MSK_CH0M_MASK             2048U
#define B_INT_MSK_CH1M_MASK             4096U
#define B_INT_MSK_CH2M_MASK             8192U
#define B_INT_MSK_CH3M_MASK             16384U
#define B_INT_MSK_TOVM_MASK             32768U


/*** B_TRIM_ALF - Trim for accurate 1ms low freq clock; 0x0000020E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TRIM_ALFH - Trim for accurate 1ms low freq clock high; 0x0000020E ***/
    union {
      byte Byte;
      struct {
        byte APRESC      :5;                                       /* ALFCLK Prescaler 8 */
        byte             :1; 
        byte             :1; 
        byte PRDF        :1;                                       /* ALFCLK Prescaler ready Flag */
      } Bits;
    } B_TRIM_ALFHSTR;
    #define B_TRIM_ALFH                 _B_TRIM_ALF.Overlap_STR.B_TRIM_ALFHSTR.Byte
    #define B_TRIM_ALFH_APRESC          _B_TRIM_ALF.Overlap_STR.B_TRIM_ALFHSTR.Bits.APRESC
    #define B_TRIM_ALFH_PRDF            _B_TRIM_ALF.Overlap_STR.B_TRIM_ALFHSTR.Bits.PRDF
    
    #define B_TRIM_ALFH_APRESC_MASK     31U
    #define B_TRIM_ALFH_APRESC_BITNUM   0U
    #define B_TRIM_ALFH_PRDF_MASK       128U
    

    /*** B_TRIM_ALFL - Trim for accurate 1ms low freq clock low; 0x0000020F ***/
    union {
      byte Byte;
    } B_TRIM_ALFLSTR;
    #define B_TRIM_ALFL                 _B_TRIM_ALF.Overlap_STR.B_TRIM_ALFLSTR.Byte
    
  } Overlap_STR;

  struct {
    word APRESC      :13;                                      /* ALFCLK Prescaler 0 */
    word             :1; 
    word             :1; 
    word PRDF        :1;                                       /* ALFCLK Prescaler ready Flag */
  } Bits;
} B_TRIM_ALFSTR;
extern volatile B_TRIM_ALFSTR _B_TRIM_ALF @(REG_BASE + 0x0000020EUL);
#define B_TRIM_ALF                      _B_TRIM_ALF.Word
#define B_TRIM_ALF_APRESC               _B_TRIM_ALF.Bits.APRESC
#define B_TRIM_ALF_PRDF                 _B_TRIM_ALF.Bits.PRDF

#define B_TRIM_ALF_APRESC_MASK          8191U
#define B_TRIM_ALF_APRESC_BITNUM        0U
#define B_TRIM_ALF_PRDF_MASK            32768U


/*** B_WD_CTL - Watchdog control register; 0x00000210 ***/
typedef union {
  word Word;
  struct {
    word WDTO        :3;                                       /* Watchdog Time Out Configuration */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word WDTST       :1;                                       /* Watchdog Test */
    word WDTOM       :3;                                       /* Watchdog Time Out - Mask */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word WDSTM       :1;                                       /* Watchdog Test - Mask */
  } Bits;
} B_WD_CTLSTR;
extern volatile B_WD_CTLSTR _B_WD_CTL @(REG_BASE + 0x00000210UL);
#define B_WD_CTL                        _B_WD_CTL.Word
#define B_WD_CTL_WDTO                   _B_WD_CTL.Bits.WDTO
#define B_WD_CTL_WDTST                  _B_WD_CTL.Bits.WDTST
#define B_WD_CTL_WDTOM                  _B_WD_CTL.Bits.WDTOM
#define B_WD_CTL_WDSTM                  _B_WD_CTL.Bits.WDSTM

#define B_WD_CTL_WDTO_MASK              7U
#define B_WD_CTL_WDTO_BITNUM            0U
#define B_WD_CTL_WDTST_MASK             128U
#define B_WD_CTL_WDTOM_MASK             1792U
#define B_WD_CTL_WDTOM_BITNUM           8U
#define B_WD_CTL_WDSTM_MASK             32768U


/*** B_WD_SR - Watchdog status register; 0x00000212 ***/
typedef union {
  byte Byte;
  struct {
    byte WDWO        :1;                                       /* Watchdog Status */
    byte WDOFF       :1;                                       /* Watchdog Window Status */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_WD_SRSTR;
extern volatile B_WD_SRSTR _B_WD_SR @(REG_BASE + 0x00000212UL);
#define B_WD_SR                         _B_WD_SR.Byte
#define B_WD_SR_WDWO                    _B_WD_SR.Bits.WDWO
#define B_WD_SR_WDOFF                   _B_WD_SR.Bits.WDOFF

#define B_WD_SR_WDWO_MASK               1U
#define B_WD_SR_WDOFF_MASK              2U


/*** B_WD_RR - Watchdog rearm register; 0x00000214 ***/
typedef union {
  byte Byte;
} B_WD_RRSTR;
extern volatile B_WD_RRSTR _B_WD_RR @(REG_BASE + 0x00000214UL);
#define B_WD_RR                         _B_WD_RR.Byte


/*** B_SCIBD - SCI Baud Rate Register; 0x00000218 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_SCIBDH - SCI Baud Rate Register High; 0x00000218 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
        byte SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
        byte SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
        byte SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
        byte SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
        byte             :1; 
        byte RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
        byte LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } B_SCIBDHSTR;
    #define B_SCIBDH                    _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Byte
    #define B_SCIBDH_SBR8               _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR8
    #define B_SCIBDH_SBR9               _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR9
    #define B_SCIBDH_SBR10              _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR10
    #define B_SCIBDH_SBR11              _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR11
    #define B_SCIBDH_SBR12              _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR12
    #define B_SCIBDH_RXEDGIE            _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.RXEDGIE
    #define B_SCIBDH_LBKDIE             _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.LBKDIE
    #define B_SCIBDH_SBR_8              _B_SCIBD.Overlap_STR.B_SCIBDHSTR.MergedBits.grpSBR_8
    #define B_SCIBDH_SBR                B_SCIBDH_SBR_8
    
    #define B_SCIBDH_SBR8_MASK          1U
    #define B_SCIBDH_SBR9_MASK          2U
    #define B_SCIBDH_SBR10_MASK         4U
    #define B_SCIBDH_SBR11_MASK         8U
    #define B_SCIBDH_SBR12_MASK         16U
    #define B_SCIBDH_RXEDGIE_MASK       64U
    #define B_SCIBDH_LBKDIE_MASK        128U
    #define B_SCIBDH_SBR_8_MASK         31U
    #define B_SCIBDH_SBR_8_BITNUM       0U
    

    /*** B_SCIBDL - SCI Baud Rate Register Low; 0x00000219 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
        byte SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
        byte SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
        byte SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
        byte SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
        byte SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
        byte SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
        byte SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
      } Bits;
    } B_SCIBDLSTR;
    #define B_SCIBDL                    _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Byte
    #define B_SCIBDL_SBR0               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR0
    #define B_SCIBDL_SBR1               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR1
    #define B_SCIBDL_SBR2               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR2
    #define B_SCIBDL_SBR3               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR3
    #define B_SCIBDL_SBR4               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR4
    #define B_SCIBDL_SBR5               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR5
    #define B_SCIBDL_SBR6               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR6
    #define B_SCIBDL_SBR7               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR7
    
    #define B_SCIBDL_SBR0_MASK          1U
    #define B_SCIBDL_SBR1_MASK          2U
    #define B_SCIBDL_SBR2_MASK          4U
    #define B_SCIBDL_SBR3_MASK          8U
    #define B_SCIBDL_SBR4_MASK          16U
    #define B_SCIBDL_SBR5_MASK          32U
    #define B_SCIBDL_SBR6_MASK          64U
    #define B_SCIBDL_SBR7_MASK          128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
    word SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
    word SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
    word SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
    word SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
    word SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
    word SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
    word SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
    word SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
    word SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
    word SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
    word SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
    word SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
    word             :1; 
    word RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
    word LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
  } Bits;
  struct {
    word grpSBR  :13;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} B_SCIBDSTR;
extern volatile B_SCIBDSTR _B_SCIBD @(REG_BASE + 0x00000218UL);
#define B_SCIBD                         _B_SCIBD.Word
#define B_SCIBD_SBR0                    _B_SCIBD.Bits.SBR0
#define B_SCIBD_SBR1                    _B_SCIBD.Bits.SBR1
#define B_SCIBD_SBR2                    _B_SCIBD.Bits.SBR2
#define B_SCIBD_SBR3                    _B_SCIBD.Bits.SBR3
#define B_SCIBD_SBR4                    _B_SCIBD.Bits.SBR4
#define B_SCIBD_SBR5                    _B_SCIBD.Bits.SBR5
#define B_SCIBD_SBR6                    _B_SCIBD.Bits.SBR6
#define B_SCIBD_SBR7                    _B_SCIBD.Bits.SBR7
#define B_SCIBD_SBR8                    _B_SCIBD.Bits.SBR8
#define B_SCIBD_SBR9                    _B_SCIBD.Bits.SBR9
#define B_SCIBD_SBR10                   _B_SCIBD.Bits.SBR10
#define B_SCIBD_SBR11                   _B_SCIBD.Bits.SBR11
#define B_SCIBD_SBR12                   _B_SCIBD.Bits.SBR12
#define B_SCIBD_RXEDGIE                 _B_SCIBD.Bits.RXEDGIE
#define B_SCIBD_LBKDIE                  _B_SCIBD.Bits.LBKDIE
#define B_SCIBD_SBR                     _B_SCIBD.MergedBits.grpSBR

#define B_SCIBD_SBR0_MASK               1U
#define B_SCIBD_SBR1_MASK               2U
#define B_SCIBD_SBR2_MASK               4U
#define B_SCIBD_SBR3_MASK               8U
#define B_SCIBD_SBR4_MASK               16U
#define B_SCIBD_SBR5_MASK               32U
#define B_SCIBD_SBR6_MASK               64U
#define B_SCIBD_SBR7_MASK               128U
#define B_SCIBD_SBR8_MASK               256U
#define B_SCIBD_SBR9_MASK               512U
#define B_SCIBD_SBR10_MASK              1024U
#define B_SCIBD_SBR11_MASK              2048U
#define B_SCIBD_SBR12_MASK              4096U
#define B_SCIBD_RXEDGIE_MASK            16384U
#define B_SCIBD_LBKDIE_MASK             32768U
#define B_SCIBD_SBR_MASK                8191U
#define B_SCIBD_SBR_BITNUM              0U


/*** B_SCIC1 - SCI Control Register 1; 0x0000021A ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type */
    byte PE          :1;                                       /* Parity Enable */
    byte ILT         :1;                                       /* Idle Line Type Select */
    byte             :1; 
    byte M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    byte RSRC        :1;                                       /* Receiver Source Select */
    byte             :1; 
    byte LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} B_SCIC1STR;
extern volatile B_SCIC1STR _B_SCIC1 @(REG_BASE + 0x0000021AUL);
#define B_SCIC1                         _B_SCIC1.Byte
#define B_SCIC1_PT                      _B_SCIC1.Bits.PT
#define B_SCIC1_PE                      _B_SCIC1.Bits.PE
#define B_SCIC1_ILT                     _B_SCIC1.Bits.ILT
#define B_SCIC1_M                       _B_SCIC1.Bits.M
#define B_SCIC1_RSRC                    _B_SCIC1.Bits.RSRC
#define B_SCIC1_LOOPS                   _B_SCIC1.Bits.LOOPS

#define B_SCIC1_PT_MASK                 1U
#define B_SCIC1_PE_MASK                 2U
#define B_SCIC1_ILT_MASK                4U
#define B_SCIC1_M_MASK                  16U
#define B_SCIC1_RSRC_MASK               32U
#define B_SCIC1_LOOPS_MASK              128U


/*** B_SCIC2 - SCI Control Register 2; 0x0000021B ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break */
    byte RWU         :1;                                       /* Receiver Wakeup Control */
    byte RE          :1;                                       /* Receiver Enable */
    byte TE          :1;                                       /* Transmitter Enable */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    byte RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    byte TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} B_SCIC2STR;
extern volatile B_SCIC2STR _B_SCIC2 @(REG_BASE + 0x0000021BUL);
#define B_SCIC2                         _B_SCIC2.Byte
#define B_SCIC2_SBK                     _B_SCIC2.Bits.SBK
#define B_SCIC2_RWU                     _B_SCIC2.Bits.RWU
#define B_SCIC2_RE                      _B_SCIC2.Bits.RE
#define B_SCIC2_TE                      _B_SCIC2.Bits.TE
#define B_SCIC2_ILIE                    _B_SCIC2.Bits.ILIE
#define B_SCIC2_RIE                     _B_SCIC2.Bits.RIE
#define B_SCIC2_TCIE                    _B_SCIC2.Bits.TCIE
#define B_SCIC2_TIE                     _B_SCIC2.Bits.TIE

#define B_SCIC2_SBK_MASK                1U
#define B_SCIC2_RWU_MASK                2U
#define B_SCIC2_RE_MASK                 4U
#define B_SCIC2_TE_MASK                 8U
#define B_SCIC2_ILIE_MASK               16U
#define B_SCIC2_RIE_MASK                32U
#define B_SCIC2_TCIE_MASK               64U
#define B_SCIC2_TIE_MASK                128U


/*** B_SCIS1 - SCI Status Register 1; 0x0000021C ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Receiver Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmission Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} B_SCIS1STR;
extern volatile B_SCIS1STR _B_SCIS1 @(REG_BASE + 0x0000021CUL);
#define B_SCIS1                         _B_SCIS1.Byte
#define B_SCIS1_PF                      _B_SCIS1.Bits.PF
#define B_SCIS1_FE                      _B_SCIS1.Bits.FE
#define B_SCIS1_NF                      _B_SCIS1.Bits.NF
#define B_SCIS1_OR                      _B_SCIS1.Bits.OR
#define B_SCIS1_IDLE                    _B_SCIS1.Bits.IDLE
#define B_SCIS1_RDRF                    _B_SCIS1.Bits.RDRF
#define B_SCIS1_TC                      _B_SCIS1.Bits.TC
#define B_SCIS1_TDRE                    _B_SCIS1.Bits.TDRE

#define B_SCIS1_PF_MASK                 1U
#define B_SCIS1_FE_MASK                 2U
#define B_SCIS1_NF_MASK                 4U
#define B_SCIS1_OR_MASK                 8U
#define B_SCIS1_IDLE_MASK               16U
#define B_SCIS1_RDRF_MASK               32U
#define B_SCIS1_TC_MASK                 64U
#define B_SCIS1_TDRE_MASK               128U


/*** B_SCIS2 - SCI Status Register 2; 0x0000021D ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte LBKDE       :1;                                       /* LIN Break Detection Enable */
    byte BRK13       :1;                                       /* Break Character Generation Length */
    byte RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    byte RXINV       :1;                                       /* Receive Data Inversion */
    byte             :1; 
    byte RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    byte LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} B_SCIS2STR;
extern volatile B_SCIS2STR _B_SCIS2 @(REG_BASE + 0x0000021DUL);
#define B_SCIS2                         _B_SCIS2.Byte
#define B_SCIS2_RAF                     _B_SCIS2.Bits.RAF
#define B_SCIS2_LBKDE                   _B_SCIS2.Bits.LBKDE
#define B_SCIS2_BRK13                   _B_SCIS2.Bits.BRK13
#define B_SCIS2_RWUID                   _B_SCIS2.Bits.RWUID
#define B_SCIS2_RXINV                   _B_SCIS2.Bits.RXINV
#define B_SCIS2_RXEDGIF                 _B_SCIS2.Bits.RXEDGIF
#define B_SCIS2_LBKDIF                  _B_SCIS2.Bits.LBKDIF

#define B_SCIS2_RAF_MASK                1U
#define B_SCIS2_LBKDE_MASK              2U
#define B_SCIS2_BRK13_MASK              4U
#define B_SCIS2_RWUID_MASK              8U
#define B_SCIS2_RXINV_MASK              16U
#define B_SCIS2_RXEDGIF_MASK            64U
#define B_SCIS2_LBKDIF_MASK             128U


/*** B_SCIC3 - SCI Control Register 3; 0x0000021E ***/
typedef union {
  byte Byte;
  struct {
    byte PEIE        :1;                                       /* Parity Error Interrupt Enable */
    byte FEIE        :1;                                       /* Framing Error Interrupt Enable */
    byte NEIE        :1;                                       /* Noise Error Interrupt Enable */
    byte ORIE        :1;                                       /* Overrun Interrupt Enable */
    byte TXINV       :1;                                       /* Transmit Data Inversion */
    byte TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    byte T8          :1;                                       /* Ninth Data Bit for Transmitter */
    byte R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} B_SCIC3STR;
extern volatile B_SCIC3STR _B_SCIC3 @(REG_BASE + 0x0000021EUL);
#define B_SCIC3                         _B_SCIC3.Byte
#define B_SCIC3_PEIE                    _B_SCIC3.Bits.PEIE
#define B_SCIC3_FEIE                    _B_SCIC3.Bits.FEIE
#define B_SCIC3_NEIE                    _B_SCIC3.Bits.NEIE
#define B_SCIC3_ORIE                    _B_SCIC3.Bits.ORIE
#define B_SCIC3_TXINV                   _B_SCIC3.Bits.TXINV
#define B_SCIC3_TXDIR                   _B_SCIC3.Bits.TXDIR
#define B_SCIC3_T8                      _B_SCIC3.Bits.T8
#define B_SCIC3_R8                      _B_SCIC3.Bits.R8

#define B_SCIC3_PEIE_MASK               1U
#define B_SCIC3_FEIE_MASK               2U
#define B_SCIC3_NEIE_MASK               4U
#define B_SCIC3_ORIE_MASK               8U
#define B_SCIC3_TXINV_MASK              16U
#define B_SCIC3_TXDIR_MASK              32U
#define B_SCIC3_T8_MASK                 64U
#define B_SCIC3_R8_MASK                 128U


/*** B_SCID - SCI Data Register; 0x0000021F ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    byte R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    byte R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    byte R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    byte R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    byte R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    byte R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    byte R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} B_SCIDSTR;
extern volatile B_SCIDSTR _B_SCID @(REG_BASE + 0x0000021FUL);
#define B_SCID                          _B_SCID.Byte
#define B_SCID_R0_T0                    _B_SCID.Bits.R0_T0
#define B_SCID_R1_T1                    _B_SCID.Bits.R1_T1
#define B_SCID_R2_T2                    _B_SCID.Bits.R2_T2
#define B_SCID_R3_T3                    _B_SCID.Bits.R3_T3
#define B_SCID_R4_T4                    _B_SCID.Bits.R4_T4
#define B_SCID_R5_T5                    _B_SCID.Bits.R5_T5
#define B_SCID_R6_T6                    _B_SCID.Bits.R6_T6
#define B_SCID_R7_T7                    _B_SCID.Bits.R7_T7

#define B_SCID_R0_T0_MASK               1U
#define B_SCID_R1_T1_MASK               2U
#define B_SCID_R2_T2_MASK               4U
#define B_SCID_R3_T3_MASK               8U
#define B_SCID_R4_T4_MASK               16U
#define B_SCID_R5_T5_MASK               32U
#define B_SCID_R6_T6_MASK               64U
#define B_SCID_R7_T7_MASK               128U


/*** B_TIOS - Timer Input Capture/Output Compare Select; 0x00000220 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIOS  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_TIOSSTR;
extern volatile B_TIOSSTR _B_TIOS @(REG_BASE + 0x00000220UL);
#define B_TIOS                          _B_TIOS.Byte
#define B_TIOS_IOS0                     _B_TIOS.Bits.IOS0
#define B_TIOS_IOS1                     _B_TIOS.Bits.IOS1
#define B_TIOS_IOS2                     _B_TIOS.Bits.IOS2
#define B_TIOS_IOS3                     _B_TIOS.Bits.IOS3
#define B_TIOS_IOS                      _B_TIOS.MergedBits.grpIOS

#define B_TIOS_IOS0_MASK                1U
#define B_TIOS_IOS1_MASK                2U
#define B_TIOS_IOS2_MASK                4U
#define B_TIOS_IOS3_MASK                8U
#define B_TIOS_IOS_MASK                 15U
#define B_TIOS_IOS_BITNUM               0U


/*** B_CFORC - Timer Compare Force Register; 0x00000221 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpFOC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_CFORCSTR;
extern volatile B_CFORCSTR _B_CFORC @(REG_BASE + 0x00000221UL);
#define B_CFORC                         _B_CFORC.Byte
#define B_CFORC_FOC0                    _B_CFORC.Bits.FOC0
#define B_CFORC_FOC1                    _B_CFORC.Bits.FOC1
#define B_CFORC_FOC2                    _B_CFORC.Bits.FOC2
#define B_CFORC_FOC3                    _B_CFORC.Bits.FOC3
#define B_CFORC_FOC                     _B_CFORC.MergedBits.grpFOC

#define B_CFORC_FOC0_MASK               1U
#define B_CFORC_FOC1_MASK               2U
#define B_CFORC_FOC2_MASK               4U
#define B_CFORC_FOC3_MASK               8U
#define B_CFORC_FOC_MASK                15U
#define B_CFORC_FOC_BITNUM              0U


/*** B_OC3M - Output Compare 3 Mask Register; 0x00000222 ***/
typedef union {
  byte Byte;
  struct {
    byte OC3M0       :1;                                       /* Output Compare 3 Mask Bit 0 */
    byte OC3M1       :1;                                       /* Output Compare 3 Mask Bit 1 */
    byte OC3M2       :1;                                       /* Output Compare 3 Mask Bit 2 */
    byte OC3M3       :1;                                       /* Output Compare 3 Mask Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOC3M :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_OC3MSTR;
extern volatile B_OC3MSTR _B_OC3M @(REG_BASE + 0x00000222UL);
#define B_OC3M                          _B_OC3M.Byte
#define B_OC3M_OC3M0                    _B_OC3M.Bits.OC3M0
#define B_OC3M_OC3M1                    _B_OC3M.Bits.OC3M1
#define B_OC3M_OC3M2                    _B_OC3M.Bits.OC3M2
#define B_OC3M_OC3M3                    _B_OC3M.Bits.OC3M3
#define B_OC3M_OC3M                     _B_OC3M.MergedBits.grpOC3M

#define B_OC3M_OC3M0_MASK               1U
#define B_OC3M_OC3M1_MASK               2U
#define B_OC3M_OC3M2_MASK               4U
#define B_OC3M_OC3M3_MASK               8U
#define B_OC3M_OC3M_MASK                15U
#define B_OC3M_OC3M_BITNUM              0U


/*** B_OC3D - Output Compare 3 Data Register; 0x00000223 ***/
typedef union {
  byte Byte;
  struct {
    byte OC3D0       :1;                                       /* Output Compare 3 Bit 0 */
    byte OC3D1       :1;                                       /* Output Compare 3 Bit 1 */
    byte OC3D2       :1;                                       /* Output Compare 3 Bit 2 */
    byte OC3D3       :1;                                       /* Output Compare 3 Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOC3D :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_OC3DSTR;
extern volatile B_OC3DSTR _B_OC3D @(REG_BASE + 0x00000223UL);
#define B_OC3D                          _B_OC3D.Byte
#define B_OC3D_OC3D0                    _B_OC3D.Bits.OC3D0
#define B_OC3D_OC3D1                    _B_OC3D.Bits.OC3D1
#define B_OC3D_OC3D2                    _B_OC3D.Bits.OC3D2
#define B_OC3D_OC3D3                    _B_OC3D.Bits.OC3D3
#define B_OC3D_OC3D                     _B_OC3D.MergedBits.grpOC3D

#define B_OC3D_OC3D0_MASK               1U
#define B_OC3D_OC3D1_MASK               2U
#define B_OC3D_OC3D2_MASK               4U
#define B_OC3D_OC3D3_MASK               8U
#define B_OC3D_OC3D_MASK                15U
#define B_OC3D_OC3D_BITNUM              0U


/*** B_TCNT - Timer Count Register; 0x00000224 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TCNTHi - Timer Count Register High; 0x00000224 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Count Register Bit 8 */
        byte BIT9        :1;                                       /* Timer Count Register Bit 9 */
        byte BIT10       :1;                                       /* Timer Count Register Bit 10 */
        byte BIT11       :1;                                       /* Timer Count Register Bit 11 */
        byte BIT12       :1;                                       /* Timer Count Register Bit 12 */
        byte BIT13       :1;                                       /* Timer Count Register Bit 13 */
        byte BIT14       :1;                                       /* Timer Count Register Bit 14 */
        byte BIT15       :1;                                       /* Timer Count Register Bit 15 */
      } Bits;
    } B_TCNTHiSTR;
    #define B_TCNTHi                    _B_TCNT.Overlap_STR.B_TCNTHiSTR.Byte
    #define B_TCNTHi_BIT8               _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT8
    #define B_TCNTHi_BIT9               _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT9
    #define B_TCNTHi_BIT10              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT10
    #define B_TCNTHi_BIT11              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT11
    #define B_TCNTHi_BIT12              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT12
    #define B_TCNTHi_BIT13              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT13
    #define B_TCNTHi_BIT14              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT14
    #define B_TCNTHi_BIT15              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT15
    
    #define B_TCNTHi_BIT8_MASK          1U
    #define B_TCNTHi_BIT9_MASK          2U
    #define B_TCNTHi_BIT10_MASK         4U
    #define B_TCNTHi_BIT11_MASK         8U
    #define B_TCNTHi_BIT12_MASK         16U
    #define B_TCNTHi_BIT13_MASK         32U
    #define B_TCNTHi_BIT14_MASK         64U
    #define B_TCNTHi_BIT15_MASK         128U
    

    /*** B_TCNTLo - Timer Count Register Low; 0x00000225 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Count Register Bit 0 */
        byte BIT1        :1;                                       /* Timer Count Register Bit 1 */
        byte BIT2        :1;                                       /* Timer Count Register Bit 2 */
        byte BIT3        :1;                                       /* Timer Count Register Bit 3 */
        byte BIT4        :1;                                       /* Timer Count Register Bit 4 */
        byte BIT5        :1;                                       /* Timer Count Register Bit 5 */
        byte BIT6        :1;                                       /* Timer Count Register Bit 6 */
        byte BIT7        :1;                                       /* Timer Count Register Bit 7 */
      } Bits;
    } B_TCNTLoSTR;
    #define B_TCNTLo                    _B_TCNT.Overlap_STR.B_TCNTLoSTR.Byte
    #define B_TCNTLo_BIT0               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT0
    #define B_TCNTLo_BIT1               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT1
    #define B_TCNTLo_BIT2               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT2
    #define B_TCNTLo_BIT3               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT3
    #define B_TCNTLo_BIT4               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT4
    #define B_TCNTLo_BIT5               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT5
    #define B_TCNTLo_BIT6               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT6
    #define B_TCNTLo_BIT7               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT7
    
    #define B_TCNTLo_BIT0_MASK          1U
    #define B_TCNTLo_BIT1_MASK          2U
    #define B_TCNTLo_BIT2_MASK          4U
    #define B_TCNTLo_BIT3_MASK          8U
    #define B_TCNTLo_BIT4_MASK          16U
    #define B_TCNTLo_BIT5_MASK          32U
    #define B_TCNTLo_BIT6_MASK          64U
    #define B_TCNTLo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Count Register Bit 0 */
    word BIT1        :1;                                       /* Timer Count Register Bit 1 */
    word BIT2        :1;                                       /* Timer Count Register Bit 2 */
    word BIT3        :1;                                       /* Timer Count Register Bit 3 */
    word BIT4        :1;                                       /* Timer Count Register Bit 4 */
    word BIT5        :1;                                       /* Timer Count Register Bit 5 */
    word BIT6        :1;                                       /* Timer Count Register Bit 6 */
    word BIT7        :1;                                       /* Timer Count Register Bit 7 */
    word BIT8        :1;                                       /* Timer Count Register Bit 8 */
    word BIT9        :1;                                       /* Timer Count Register Bit 9 */
    word BIT10       :1;                                       /* Timer Count Register Bit 10 */
    word BIT11       :1;                                       /* Timer Count Register Bit 11 */
    word BIT12       :1;                                       /* Timer Count Register Bit 12 */
    word BIT13       :1;                                       /* Timer Count Register Bit 13 */
    word BIT14       :1;                                       /* Timer Count Register Bit 14 */
    word BIT15       :1;                                       /* Timer Count Register Bit 15 */
  } Bits;
} B_TCNTSTR;
extern volatile B_TCNTSTR _B_TCNT @(REG_BASE + 0x00000224UL);
#define B_TCNT                          _B_TCNT.Word
#define B_TCNT_BIT0                     _B_TCNT.Bits.BIT0
#define B_TCNT_BIT1                     _B_TCNT.Bits.BIT1
#define B_TCNT_BIT2                     _B_TCNT.Bits.BIT2
#define B_TCNT_BIT3                     _B_TCNT.Bits.BIT3
#define B_TCNT_BIT4                     _B_TCNT.Bits.BIT4
#define B_TCNT_BIT5                     _B_TCNT.Bits.BIT5
#define B_TCNT_BIT6                     _B_TCNT.Bits.BIT6
#define B_TCNT_BIT7                     _B_TCNT.Bits.BIT7
#define B_TCNT_BIT8                     _B_TCNT.Bits.BIT8
#define B_TCNT_BIT9                     _B_TCNT.Bits.BIT9
#define B_TCNT_BIT10                    _B_TCNT.Bits.BIT10
#define B_TCNT_BIT11                    _B_TCNT.Bits.BIT11
#define B_TCNT_BIT12                    _B_TCNT.Bits.BIT12
#define B_TCNT_BIT13                    _B_TCNT.Bits.BIT13
#define B_TCNT_BIT14                    _B_TCNT.Bits.BIT14
#define B_TCNT_BIT15                    _B_TCNT.Bits.BIT15

#define B_TCNT_BIT0_MASK                1U
#define B_TCNT_BIT1_MASK                2U
#define B_TCNT_BIT2_MASK                4U
#define B_TCNT_BIT3_MASK                8U
#define B_TCNT_BIT4_MASK                16U
#define B_TCNT_BIT5_MASK                32U
#define B_TCNT_BIT6_MASK                64U
#define B_TCNT_BIT7_MASK                128U
#define B_TCNT_BIT8_MASK                256U
#define B_TCNT_BIT9_MASK                512U
#define B_TCNT_BIT10_MASK               1024U
#define B_TCNT_BIT11_MASK               2048U
#define B_TCNT_BIT12_MASK               4096U
#define B_TCNT_BIT13_MASK               8192U
#define B_TCNT_BIT14_MASK               16384U
#define B_TCNT_BIT15_MASK               32768U


/*** B_TSCR1 - Timer System Control Register1; 0x00000226 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte             :1; 
    byte             :1; 
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} B_TSCR1STR;
extern volatile B_TSCR1STR _B_TSCR1 @(REG_BASE + 0x00000226UL);
#define B_TSCR1                         _B_TSCR1.Byte
#define B_TSCR1_TFFCA                   _B_TSCR1.Bits.TFFCA
#define B_TSCR1_TEN                     _B_TSCR1.Bits.TEN

#define B_TSCR1_TFFCA_MASK              16U
#define B_TSCR1_TEN_MASK                128U


/*** B_TTOV - Timer Toggle On Overflow Register; 0x00000227 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTOV  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_TTOVSTR;
extern volatile B_TTOVSTR _B_TTOV @(REG_BASE + 0x00000227UL);
#define B_TTOV                          _B_TTOV.Byte
#define B_TTOV_TOV0                     _B_TTOV.Bits.TOV0
#define B_TTOV_TOV1                     _B_TTOV.Bits.TOV1
#define B_TTOV_TOV2                     _B_TTOV.Bits.TOV2
#define B_TTOV_TOV3                     _B_TTOV.Bits.TOV3
#define B_TTOV_TOV                      _B_TTOV.MergedBits.grpTOV

#define B_TTOV_TOV0_MASK                1U
#define B_TTOV_TOV1_MASK                2U
#define B_TTOV_TOV2_MASK                4U
#define B_TTOV_TOV3_MASK                8U
#define B_TTOV_TOV_MASK                 15U
#define B_TTOV_TOV_BITNUM               0U


/*** B_TCTL1 - Timer Control Register 1; 0x00000228 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Lecel Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} B_TCTL1STR;
extern volatile B_TCTL1STR _B_TCTL1 @(REG_BASE + 0x00000228UL);
#define B_TCTL1                         _B_TCTL1.Byte
#define B_TCTL1_OL0                     _B_TCTL1.Bits.OL0
#define B_TCTL1_OM0                     _B_TCTL1.Bits.OM0
#define B_TCTL1_OL1                     _B_TCTL1.Bits.OL1
#define B_TCTL1_OM1                     _B_TCTL1.Bits.OM1
#define B_TCTL1_OL2                     _B_TCTL1.Bits.OL2
#define B_TCTL1_OM2                     _B_TCTL1.Bits.OM2
#define B_TCTL1_OL3                     _B_TCTL1.Bits.OL3
#define B_TCTL1_OM3                     _B_TCTL1.Bits.OM3

#define B_TCTL1_OL0_MASK                1U
#define B_TCTL1_OM0_MASK                2U
#define B_TCTL1_OL1_MASK                4U
#define B_TCTL1_OM1_MASK                8U
#define B_TCTL1_OL2_MASK                16U
#define B_TCTL1_OM2_MASK                32U
#define B_TCTL1_OL3_MASK                64U
#define B_TCTL1_OM3_MASK                128U


/*** B_TCTL2 - Timer Control Register 2; 0x00000229 ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge 0 Control A */
    byte EDG0B       :1;                                       /* Input Capture Edge 0 Control B */
    byte EDG1A       :1;                                       /* Input Capture Edge 1 Control A */
    byte EDG1B       :1;                                       /* Input Capture Edge 1 Control B */
    byte EDG2A       :1;                                       /* Input Capture Edge 2 Control A */
    byte EDG2B       :1;                                       /* Input Capture Edge 2 Control B */
    byte EDG3A       :1;                                       /* Input Capture Edge 3 Control A */
    byte EDG3B       :1;                                       /* Input Capture Edge 3 Control B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} B_TCTL2STR;
extern volatile B_TCTL2STR _B_TCTL2 @(REG_BASE + 0x00000229UL);
#define B_TCTL2                         _B_TCTL2.Byte
#define B_TCTL2_EDG0A                   _B_TCTL2.Bits.EDG0A
#define B_TCTL2_EDG0B                   _B_TCTL2.Bits.EDG0B
#define B_TCTL2_EDG1A                   _B_TCTL2.Bits.EDG1A
#define B_TCTL2_EDG1B                   _B_TCTL2.Bits.EDG1B
#define B_TCTL2_EDG2A                   _B_TCTL2.Bits.EDG2A
#define B_TCTL2_EDG2B                   _B_TCTL2.Bits.EDG2B
#define B_TCTL2_EDG3A                   _B_TCTL2.Bits.EDG3A
#define B_TCTL2_EDG3B                   _B_TCTL2.Bits.EDG3B
#define B_TCTL2_EDG0x                   _B_TCTL2.MergedBits.grpEDG0x
#define B_TCTL2_EDG1x                   _B_TCTL2.MergedBits.grpEDG1x
#define B_TCTL2_EDG2x                   _B_TCTL2.MergedBits.grpEDG2x
#define B_TCTL2_EDG3x                   _B_TCTL2.MergedBits.grpEDG3x

#define B_TCTL2_EDG0A_MASK              1U
#define B_TCTL2_EDG0B_MASK              2U
#define B_TCTL2_EDG1A_MASK              4U
#define B_TCTL2_EDG1B_MASK              8U
#define B_TCTL2_EDG2A_MASK              16U
#define B_TCTL2_EDG2B_MASK              32U
#define B_TCTL2_EDG3A_MASK              64U
#define B_TCTL2_EDG3B_MASK              128U
#define B_TCTL2_EDG0x_MASK              3U
#define B_TCTL2_EDG0x_BITNUM            0U
#define B_TCTL2_EDG1x_MASK              12U
#define B_TCTL2_EDG1x_BITNUM            2U
#define B_TCTL2_EDG2x_MASK              48U
#define B_TCTL2_EDG2x_BITNUM            4U
#define B_TCTL2_EDG3x_MASK              192U
#define B_TCTL2_EDG3x_BITNUM            6U


/*** B_TIE - Timer Interrupt Enable Register; 0x0000022A ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_TIESTR;
extern volatile B_TIESTR _B_TIE @(REG_BASE + 0x0000022AUL);
#define B_TIE                           _B_TIE.Byte
#define B_TIE_C0I                       _B_TIE.Bits.C0I
#define B_TIE_C1I                       _B_TIE.Bits.C1I
#define B_TIE_C2I                       _B_TIE.Bits.C2I
#define B_TIE_C3I                       _B_TIE.Bits.C3I

#define B_TIE_C0I_MASK                  1U
#define B_TIE_C1I_MASK                  2U
#define B_TIE_C2I_MASK                  4U
#define B_TIE_C3I_MASK                  8U


/*** B_TSCR2 - Timer System Control Register 2; 0x0000022B ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_TSCR2STR;
extern volatile B_TSCR2STR _B_TSCR2 @(REG_BASE + 0x0000022BUL);
#define B_TSCR2                         _B_TSCR2.Byte
#define B_TSCR2_PR0                     _B_TSCR2.Bits.PR0
#define B_TSCR2_PR1                     _B_TSCR2.Bits.PR1
#define B_TSCR2_PR2                     _B_TSCR2.Bits.PR2
#define B_TSCR2_TCRE                    _B_TSCR2.Bits.TCRE
#define B_TSCR2_TOI                     _B_TSCR2.Bits.TOI
#define B_TSCR2_PR                      _B_TSCR2.MergedBits.grpPR

#define B_TSCR2_PR0_MASK                1U
#define B_TSCR2_PR1_MASK                2U
#define B_TSCR2_PR2_MASK                4U
#define B_TSCR2_TCRE_MASK               8U
#define B_TSCR2_TOI_MASK                128U
#define B_TSCR2_PR_MASK                 7U
#define B_TSCR2_PR_BITNUM               0U


/*** B_TFLG1 - Main Timer Interrupt Flag 1; 0x0000022C ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_TFLG1STR;
extern volatile B_TFLG1STR _B_TFLG1 @(REG_BASE + 0x0000022CUL);
#define B_TFLG1                         _B_TFLG1.Byte
#define B_TFLG1_C0F                     _B_TFLG1.Bits.C0F
#define B_TFLG1_C1F                     _B_TFLG1.Bits.C1F
#define B_TFLG1_C2F                     _B_TFLG1.Bits.C2F
#define B_TFLG1_C3F                     _B_TFLG1.Bits.C3F

#define B_TFLG1_C0F_MASK                1U
#define B_TFLG1_C1F_MASK                2U
#define B_TFLG1_C2F_MASK                4U
#define B_TFLG1_C3F_MASK                8U


/*** B_TFLG2 - Main Timer Interrupt Flag 2; 0x0000022D ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} B_TFLG2STR;
extern volatile B_TFLG2STR _B_TFLG2 @(REG_BASE + 0x0000022DUL);
#define B_TFLG2                         _B_TFLG2.Byte
#define B_TFLG2_TOF                     _B_TFLG2.Bits.TOF

#define B_TFLG2_TOF_MASK                128U


/*** B_TC0 - Timer Input Capture/Output Compare Register 0; 0x0000022E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x0000022E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 15 */
      } Bits;
    } B_TC0HiSTR;
    #define B_TC0Hi                     _B_TC0.Overlap_STR.B_TC0HiSTR.Byte
    #define B_TC0Hi_BIT8                _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT8
    #define B_TC0Hi_BIT9                _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT9
    #define B_TC0Hi_BIT10               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT10
    #define B_TC0Hi_BIT11               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT11
    #define B_TC0Hi_BIT12               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT12
    #define B_TC0Hi_BIT13               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT13
    #define B_TC0Hi_BIT14               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT14
    #define B_TC0Hi_BIT15               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT15
    
    #define B_TC0Hi_BIT8_MASK           1U
    #define B_TC0Hi_BIT9_MASK           2U
    #define B_TC0Hi_BIT10_MASK          4U
    #define B_TC0Hi_BIT11_MASK          8U
    #define B_TC0Hi_BIT12_MASK          16U
    #define B_TC0Hi_BIT13_MASK          32U
    #define B_TC0Hi_BIT14_MASK          64U
    #define B_TC0Hi_BIT15_MASK          128U
    

    /*** B_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x0000022F ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 7 */
      } Bits;
    } B_TC0LoSTR;
    #define B_TC0Lo                     _B_TC0.Overlap_STR.B_TC0LoSTR.Byte
    #define B_TC0Lo_BIT0                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT0
    #define B_TC0Lo_BIT1                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT1
    #define B_TC0Lo_BIT2                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT2
    #define B_TC0Lo_BIT3                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT3
    #define B_TC0Lo_BIT4                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT4
    #define B_TC0Lo_BIT5                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT5
    #define B_TC0Lo_BIT6                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT6
    #define B_TC0Lo_BIT7                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT7
    
    #define B_TC0Lo_BIT0_MASK           1U
    #define B_TC0Lo_BIT1_MASK           2U
    #define B_TC0Lo_BIT2_MASK           4U
    #define B_TC0Lo_BIT3_MASK           8U
    #define B_TC0Lo_BIT4_MASK           16U
    #define B_TC0Lo_BIT5_MASK           32U
    #define B_TC0Lo_BIT6_MASK           64U
    #define B_TC0Lo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 15 */
  } Bits;
} B_TC0STR;
extern volatile B_TC0STR _B_TC0 @(REG_BASE + 0x0000022EUL);
#define B_TC0                           _B_TC0.Word
#define B_TC0_BIT0                      _B_TC0.Bits.BIT0
#define B_TC0_BIT1                      _B_TC0.Bits.BIT1
#define B_TC0_BIT2                      _B_TC0.Bits.BIT2
#define B_TC0_BIT3                      _B_TC0.Bits.BIT3
#define B_TC0_BIT4                      _B_TC0.Bits.BIT4
#define B_TC0_BIT5                      _B_TC0.Bits.BIT5
#define B_TC0_BIT6                      _B_TC0.Bits.BIT6
#define B_TC0_BIT7                      _B_TC0.Bits.BIT7
#define B_TC0_BIT8                      _B_TC0.Bits.BIT8
#define B_TC0_BIT9                      _B_TC0.Bits.BIT9
#define B_TC0_BIT10                     _B_TC0.Bits.BIT10
#define B_TC0_BIT11                     _B_TC0.Bits.BIT11
#define B_TC0_BIT12                     _B_TC0.Bits.BIT12
#define B_TC0_BIT13                     _B_TC0.Bits.BIT13
#define B_TC0_BIT14                     _B_TC0.Bits.BIT14
#define B_TC0_BIT15                     _B_TC0.Bits.BIT15
/* B_TC_ARR: Access 4 B_TCx registers in an array */
#define B_TC_ARR                        ((volatile word *) &B_TC0)

#define B_TC0_BIT0_MASK                 1U
#define B_TC0_BIT1_MASK                 2U
#define B_TC0_BIT2_MASK                 4U
#define B_TC0_BIT3_MASK                 8U
#define B_TC0_BIT4_MASK                 16U
#define B_TC0_BIT5_MASK                 32U
#define B_TC0_BIT6_MASK                 64U
#define B_TC0_BIT7_MASK                 128U
#define B_TC0_BIT8_MASK                 256U
#define B_TC0_BIT9_MASK                 512U
#define B_TC0_BIT10_MASK                1024U
#define B_TC0_BIT11_MASK                2048U
#define B_TC0_BIT12_MASK                4096U
#define B_TC0_BIT13_MASK                8192U
#define B_TC0_BIT14_MASK                16384U
#define B_TC0_BIT15_MASK                32768U


/*** B_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000230 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000230 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 15 */
      } Bits;
    } B_TC1HiSTR;
    #define B_TC1Hi                     _B_TC1.Overlap_STR.B_TC1HiSTR.Byte
    #define B_TC1Hi_BIT8                _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT8
    #define B_TC1Hi_BIT9                _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT9
    #define B_TC1Hi_BIT10               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT10
    #define B_TC1Hi_BIT11               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT11
    #define B_TC1Hi_BIT12               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT12
    #define B_TC1Hi_BIT13               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT13
    #define B_TC1Hi_BIT14               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT14
    #define B_TC1Hi_BIT15               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT15
    
    #define B_TC1Hi_BIT8_MASK           1U
    #define B_TC1Hi_BIT9_MASK           2U
    #define B_TC1Hi_BIT10_MASK          4U
    #define B_TC1Hi_BIT11_MASK          8U
    #define B_TC1Hi_BIT12_MASK          16U
    #define B_TC1Hi_BIT13_MASK          32U
    #define B_TC1Hi_BIT14_MASK          64U
    #define B_TC1Hi_BIT15_MASK          128U
    

    /*** B_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000231 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 7 */
      } Bits;
    } B_TC1LoSTR;
    #define B_TC1Lo                     _B_TC1.Overlap_STR.B_TC1LoSTR.Byte
    #define B_TC1Lo_BIT0                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT0
    #define B_TC1Lo_BIT1                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT1
    #define B_TC1Lo_BIT2                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT2
    #define B_TC1Lo_BIT3                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT3
    #define B_TC1Lo_BIT4                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT4
    #define B_TC1Lo_BIT5                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT5
    #define B_TC1Lo_BIT6                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT6
    #define B_TC1Lo_BIT7                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT7
    
    #define B_TC1Lo_BIT0_MASK           1U
    #define B_TC1Lo_BIT1_MASK           2U
    #define B_TC1Lo_BIT2_MASK           4U
    #define B_TC1Lo_BIT3_MASK           8U
    #define B_TC1Lo_BIT4_MASK           16U
    #define B_TC1Lo_BIT5_MASK           32U
    #define B_TC1Lo_BIT6_MASK           64U
    #define B_TC1Lo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 15 */
  } Bits;
} B_TC1STR;
extern volatile B_TC1STR _B_TC1 @(REG_BASE + 0x00000230UL);
#define B_TC1                           _B_TC1.Word
#define B_TC1_BIT0                      _B_TC1.Bits.BIT0
#define B_TC1_BIT1                      _B_TC1.Bits.BIT1
#define B_TC1_BIT2                      _B_TC1.Bits.BIT2
#define B_TC1_BIT3                      _B_TC1.Bits.BIT3
#define B_TC1_BIT4                      _B_TC1.Bits.BIT4
#define B_TC1_BIT5                      _B_TC1.Bits.BIT5
#define B_TC1_BIT6                      _B_TC1.Bits.BIT6
#define B_TC1_BIT7                      _B_TC1.Bits.BIT7
#define B_TC1_BIT8                      _B_TC1.Bits.BIT8
#define B_TC1_BIT9                      _B_TC1.Bits.BIT9
#define B_TC1_BIT10                     _B_TC1.Bits.BIT10
#define B_TC1_BIT11                     _B_TC1.Bits.BIT11
#define B_TC1_BIT12                     _B_TC1.Bits.BIT12
#define B_TC1_BIT13                     _B_TC1.Bits.BIT13
#define B_TC1_BIT14                     _B_TC1.Bits.BIT14
#define B_TC1_BIT15                     _B_TC1.Bits.BIT15

#define B_TC1_BIT0_MASK                 1U
#define B_TC1_BIT1_MASK                 2U
#define B_TC1_BIT2_MASK                 4U
#define B_TC1_BIT3_MASK                 8U
#define B_TC1_BIT4_MASK                 16U
#define B_TC1_BIT5_MASK                 32U
#define B_TC1_BIT6_MASK                 64U
#define B_TC1_BIT7_MASK                 128U
#define B_TC1_BIT8_MASK                 256U
#define B_TC1_BIT9_MASK                 512U
#define B_TC1_BIT10_MASK                1024U
#define B_TC1_BIT11_MASK                2048U
#define B_TC1_BIT12_MASK                4096U
#define B_TC1_BIT13_MASK                8192U
#define B_TC1_BIT14_MASK                16384U
#define B_TC1_BIT15_MASK                32768U


/*** B_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000232 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000232 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 15 */
      } Bits;
    } B_TC2HiSTR;
    #define B_TC2Hi                     _B_TC2.Overlap_STR.B_TC2HiSTR.Byte
    #define B_TC2Hi_BIT8                _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT8
    #define B_TC2Hi_BIT9                _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT9
    #define B_TC2Hi_BIT10               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT10
    #define B_TC2Hi_BIT11               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT11
    #define B_TC2Hi_BIT12               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT12
    #define B_TC2Hi_BIT13               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT13
    #define B_TC2Hi_BIT14               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT14
    #define B_TC2Hi_BIT15               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT15
    
    #define B_TC2Hi_BIT8_MASK           1U
    #define B_TC2Hi_BIT9_MASK           2U
    #define B_TC2Hi_BIT10_MASK          4U
    #define B_TC2Hi_BIT11_MASK          8U
    #define B_TC2Hi_BIT12_MASK          16U
    #define B_TC2Hi_BIT13_MASK          32U
    #define B_TC2Hi_BIT14_MASK          64U
    #define B_TC2Hi_BIT15_MASK          128U
    

    /*** B_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000233 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 7 */
      } Bits;
    } B_TC2LoSTR;
    #define B_TC2Lo                     _B_TC2.Overlap_STR.B_TC2LoSTR.Byte
    #define B_TC2Lo_BIT0                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT0
    #define B_TC2Lo_BIT1                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT1
    #define B_TC2Lo_BIT2                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT2
    #define B_TC2Lo_BIT3                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT3
    #define B_TC2Lo_BIT4                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT4
    #define B_TC2Lo_BIT5                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT5
    #define B_TC2Lo_BIT6                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT6
    #define B_TC2Lo_BIT7                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT7
    
    #define B_TC2Lo_BIT0_MASK           1U
    #define B_TC2Lo_BIT1_MASK           2U
    #define B_TC2Lo_BIT2_MASK           4U
    #define B_TC2Lo_BIT3_MASK           8U
    #define B_TC2Lo_BIT4_MASK           16U
    #define B_TC2Lo_BIT5_MASK           32U
    #define B_TC2Lo_BIT6_MASK           64U
    #define B_TC2Lo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 15 */
  } Bits;
} B_TC2STR;
extern volatile B_TC2STR _B_TC2 @(REG_BASE + 0x00000232UL);
#define B_TC2                           _B_TC2.Word
#define B_TC2_BIT0                      _B_TC2.Bits.BIT0
#define B_TC2_BIT1                      _B_TC2.Bits.BIT1
#define B_TC2_BIT2                      _B_TC2.Bits.BIT2
#define B_TC2_BIT3                      _B_TC2.Bits.BIT3
#define B_TC2_BIT4                      _B_TC2.Bits.BIT4
#define B_TC2_BIT5                      _B_TC2.Bits.BIT5
#define B_TC2_BIT6                      _B_TC2.Bits.BIT6
#define B_TC2_BIT7                      _B_TC2.Bits.BIT7
#define B_TC2_BIT8                      _B_TC2.Bits.BIT8
#define B_TC2_BIT9                      _B_TC2.Bits.BIT9
#define B_TC2_BIT10                     _B_TC2.Bits.BIT10
#define B_TC2_BIT11                     _B_TC2.Bits.BIT11
#define B_TC2_BIT12                     _B_TC2.Bits.BIT12
#define B_TC2_BIT13                     _B_TC2.Bits.BIT13
#define B_TC2_BIT14                     _B_TC2.Bits.BIT14
#define B_TC2_BIT15                     _B_TC2.Bits.BIT15

#define B_TC2_BIT0_MASK                 1U
#define B_TC2_BIT1_MASK                 2U
#define B_TC2_BIT2_MASK                 4U
#define B_TC2_BIT3_MASK                 8U
#define B_TC2_BIT4_MASK                 16U
#define B_TC2_BIT5_MASK                 32U
#define B_TC2_BIT6_MASK                 64U
#define B_TC2_BIT7_MASK                 128U
#define B_TC2_BIT8_MASK                 256U
#define B_TC2_BIT9_MASK                 512U
#define B_TC2_BIT10_MASK                1024U
#define B_TC2_BIT11_MASK                2048U
#define B_TC2_BIT12_MASK                4096U
#define B_TC2_BIT13_MASK                8192U
#define B_TC2_BIT14_MASK                16384U
#define B_TC2_BIT15_MASK                32768U


/*** B_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000234 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000234 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 15 */
      } Bits;
    } B_TC3HiSTR;
    #define B_TC3Hi                     _B_TC3.Overlap_STR.B_TC3HiSTR.Byte
    #define B_TC3Hi_BIT8                _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT8
    #define B_TC3Hi_BIT9                _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT9
    #define B_TC3Hi_BIT10               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT10
    #define B_TC3Hi_BIT11               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT11
    #define B_TC3Hi_BIT12               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT12
    #define B_TC3Hi_BIT13               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT13
    #define B_TC3Hi_BIT14               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT14
    #define B_TC3Hi_BIT15               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT15
    
    #define B_TC3Hi_BIT8_MASK           1U
    #define B_TC3Hi_BIT9_MASK           2U
    #define B_TC3Hi_BIT10_MASK          4U
    #define B_TC3Hi_BIT11_MASK          8U
    #define B_TC3Hi_BIT12_MASK          16U
    #define B_TC3Hi_BIT13_MASK          32U
    #define B_TC3Hi_BIT14_MASK          64U
    #define B_TC3Hi_BIT15_MASK          128U
    

    /*** B_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000235 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 7 */
      } Bits;
    } B_TC3LoSTR;
    #define B_TC3Lo                     _B_TC3.Overlap_STR.B_TC3LoSTR.Byte
    #define B_TC3Lo_BIT0                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT0
    #define B_TC3Lo_BIT1                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT1
    #define B_TC3Lo_BIT2                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT2
    #define B_TC3Lo_BIT3                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT3
    #define B_TC3Lo_BIT4                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT4
    #define B_TC3Lo_BIT5                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT5
    #define B_TC3Lo_BIT6                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT6
    #define B_TC3Lo_BIT7                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT7
    
    #define B_TC3Lo_BIT0_MASK           1U
    #define B_TC3Lo_BIT1_MASK           2U
    #define B_TC3Lo_BIT2_MASK           4U
    #define B_TC3Lo_BIT3_MASK           8U
    #define B_TC3Lo_BIT4_MASK           16U
    #define B_TC3Lo_BIT5_MASK           32U
    #define B_TC3Lo_BIT6_MASK           64U
    #define B_TC3Lo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 15 */
  } Bits;
} B_TC3STR;
extern volatile B_TC3STR _B_TC3 @(REG_BASE + 0x00000234UL);
#define B_TC3                           _B_TC3.Word
#define B_TC3_BIT0                      _B_TC3.Bits.BIT0
#define B_TC3_BIT1                      _B_TC3.Bits.BIT1
#define B_TC3_BIT2                      _B_TC3.Bits.BIT2
#define B_TC3_BIT3                      _B_TC3.Bits.BIT3
#define B_TC3_BIT4                      _B_TC3.Bits.BIT4
#define B_TC3_BIT5                      _B_TC3.Bits.BIT5
#define B_TC3_BIT6                      _B_TC3.Bits.BIT6
#define B_TC3_BIT7                      _B_TC3.Bits.BIT7
#define B_TC3_BIT8                      _B_TC3.Bits.BIT8
#define B_TC3_BIT9                      _B_TC3.Bits.BIT9
#define B_TC3_BIT10                     _B_TC3.Bits.BIT10
#define B_TC3_BIT11                     _B_TC3.Bits.BIT11
#define B_TC3_BIT12                     _B_TC3.Bits.BIT12
#define B_TC3_BIT13                     _B_TC3.Bits.BIT13
#define B_TC3_BIT14                     _B_TC3.Bits.BIT14
#define B_TC3_BIT15                     _B_TC3.Bits.BIT15

#define B_TC3_BIT0_MASK                 1U
#define B_TC3_BIT1_MASK                 2U
#define B_TC3_BIT2_MASK                 4U
#define B_TC3_BIT3_MASK                 8U
#define B_TC3_BIT4_MASK                 16U
#define B_TC3_BIT5_MASK                 32U
#define B_TC3_BIT6_MASK                 64U
#define B_TC3_BIT7_MASK                 128U
#define B_TC3_BIT8_MASK                 256U
#define B_TC3_BIT9_MASK                 512U
#define B_TC3_BIT10_MASK                1024U
#define B_TC3_BIT11_MASK                2048U
#define B_TC3_BIT12_MASK                4096U
#define B_TC3_BIT13_MASK                8192U
#define B_TC3_BIT14_MASK                16384U
#define B_TC3_BIT15_MASK                32768U


/*** B_LTC_CTL - Life Time Counter control register; 0x00000238 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LTC_CTLH - Life Time Counter control register high; 0x00000238 ***/
    union {
      byte Byte;
      struct {
        byte LTCEM       :1;                                       /* Life Time Counter Enable Mask */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte LTCIEM      :1;                                       /* Life Time Counter Interrupt Enable Mask */
      } Bits;
    } B_LTC_CTLHSTR;
    #define B_LTC_CTLH                  _B_LTC_CTL.Overlap_STR.B_LTC_CTLHSTR.Byte
    #define B_LTC_CTLH_LTCEM            _B_LTC_CTL.Overlap_STR.B_LTC_CTLHSTR.Bits.LTCEM
    #define B_LTC_CTLH_LTCIEM           _B_LTC_CTL.Overlap_STR.B_LTC_CTLHSTR.Bits.LTCIEM
    
    #define B_LTC_CTLH_LTCEM_MASK       1U
    #define B_LTC_CTLH_LTCIEM_MASK      128U
    

    /*** B_LTC_CTLL - Life Time Counter control register low; 0x00000239 ***/
    union {
      byte Byte;
      struct {
        byte LTCE        :1;                                       /* Life Time Counter Enable */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte LTCIE       :1;                                       /* Life Time Counter Interrupt Enable */
      } Bits;
    } B_LTC_CTLLSTR;
    #define B_LTC_CTLL                  _B_LTC_CTL.Overlap_STR.B_LTC_CTLLSTR.Byte
    #define B_LTC_CTLL_LTCE             _B_LTC_CTL.Overlap_STR.B_LTC_CTLLSTR.Bits.LTCE
    #define B_LTC_CTLL_LTCIE            _B_LTC_CTL.Overlap_STR.B_LTC_CTLLSTR.Bits.LTCIE
    
    #define B_LTC_CTLL_LTCE_MASK        1U
    #define B_LTC_CTLL_LTCIE_MASK       128U
    
  } Overlap_STR;

  struct {
    word LTCE        :1;                                       /* Life Time Counter Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word LTCIE       :1;                                       /* Life Time Counter Interrupt Enable */
    word LTCEM       :1;                                       /* Life Time Counter Enable Mask */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word LTCIEM      :1;                                       /* Life Time Counter Interrupt Enable Mask */
  } Bits;
} B_LTC_CTLSTR;
extern volatile B_LTC_CTLSTR _B_LTC_CTL @(REG_BASE + 0x00000238UL);
#define B_LTC_CTL                       _B_LTC_CTL.Word
#define B_LTC_CTL_LTCE                  _B_LTC_CTL.Bits.LTCE
#define B_LTC_CTL_LTCIE                 _B_LTC_CTL.Bits.LTCIE
#define B_LTC_CTL_LTCEM                 _B_LTC_CTL.Bits.LTCEM
#define B_LTC_CTL_LTCIEM                _B_LTC_CTL.Bits.LTCIEM

#define B_LTC_CTL_LTCE_MASK             1U
#define B_LTC_CTL_LTCIE_MASK            128U
#define B_LTC_CTL_LTCEM_MASK            256U
#define B_LTC_CTL_LTCIEM_MASK           32768U


/*** B_LTC_SR - Life Time Counter status register; 0x0000023A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LTCOF       :1;                                       /* Life Time Counter Overflow Flag */
  } Bits;
} B_LTC_SRSTR;
extern volatile B_LTC_SRSTR _B_LTC_SR @(REG_BASE + 0x0000023AUL);
#define B_LTC_SR                        _B_LTC_SR.Byte
#define B_LTC_SR_LTCOF                  _B_LTC_SR.Bits.LTCOF

#define B_LTC_SR_LTCOF_MASK             128U


/*** B_LTC_CNT1 - Life Time Counter Register 1; 0x0000023C ***/
typedef union {
  word Word;
} B_LTC_CNT1STR;
extern volatile B_LTC_CNT1STR _B_LTC_CNT1 @(REG_BASE + 0x0000023CUL);
#define B_LTC_CNT1                      _B_LTC_CNT1.Word


/*** B_LTC_CNT0 - Life Time Counter Register 0; 0x0000023E ***/
typedef union {
  word Word;
} B_LTC_CNT0STR;
extern volatile B_LTC_CNT0STR _B_LTC_CNT0 @(REG_BASE + 0x0000023EUL);
#define B_LTC_CNT0                      _B_LTC_CNT0.Word


/*** B_GPIO_CTL - GPIO control register; 0x00000240 ***/
typedef union {
  word Word;
  struct {
    word PE0         :1;                                       /* Port 0 Enable */
    word PE1         :1;                                       /* Port 1 Enable */
    word PE2         :1;                                       /* Port 2 Enable */
    word PE3         :1;                                       /* Port 3 Enable */
    word DIR0        :1;                                       /* Data Direction PTB0 */
    word DIR1        :1;                                       /* Data Direction PTB1 */
    word DIR2        :1;                                       /* Data Direction PTB2 */
    word             :1; 
    word PE0M        :1;                                       /* Port 0 Enable - Mask */
    word PE1M        :1;                                       /* Port 1 Enable - Mask */
    word PE2M        :1;                                       /* Port 2 Enable - Mask */
    word PE3M        :1;                                       /* Port 3 Enable - Mask */
    word DIR0M       :1;                                       /* Data Direction PTB0 - Mask */
    word DIR1M       :1;                                       /* Data Direction PTB1 - Mask */
    word DIR2M       :1;                                       /* Data Direction PTB2 - Mask */
    word             :1; 
  } Bits;
  struct {
    word grpPE   :4;
    word grpDIR  :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} B_GPIO_CTLSTR;
extern volatile B_GPIO_CTLSTR _B_GPIO_CTL @(REG_BASE + 0x00000240UL);
#define B_GPIO_CTL                      _B_GPIO_CTL.Word
#define B_GPIO_CTL_PE0                  _B_GPIO_CTL.Bits.PE0
#define B_GPIO_CTL_PE1                  _B_GPIO_CTL.Bits.PE1
#define B_GPIO_CTL_PE2                  _B_GPIO_CTL.Bits.PE2
#define B_GPIO_CTL_PE3                  _B_GPIO_CTL.Bits.PE3
#define B_GPIO_CTL_DIR0                 _B_GPIO_CTL.Bits.DIR0
#define B_GPIO_CTL_DIR1                 _B_GPIO_CTL.Bits.DIR1
#define B_GPIO_CTL_DIR2                 _B_GPIO_CTL.Bits.DIR2
#define B_GPIO_CTL_PE0M                 _B_GPIO_CTL.Bits.PE0M
#define B_GPIO_CTL_PE1M                 _B_GPIO_CTL.Bits.PE1M
#define B_GPIO_CTL_PE2M                 _B_GPIO_CTL.Bits.PE2M
#define B_GPIO_CTL_PE3M                 _B_GPIO_CTL.Bits.PE3M
#define B_GPIO_CTL_DIR0M                _B_GPIO_CTL.Bits.DIR0M
#define B_GPIO_CTL_DIR1M                _B_GPIO_CTL.Bits.DIR1M
#define B_GPIO_CTL_DIR2M                _B_GPIO_CTL.Bits.DIR2M
#define B_GPIO_CTL_PE                   _B_GPIO_CTL.MergedBits.grpPE
#define B_GPIO_CTL_DIR                  _B_GPIO_CTL.MergedBits.grpDIR

#define B_GPIO_CTL_PE0_MASK             1U
#define B_GPIO_CTL_PE1_MASK             2U
#define B_GPIO_CTL_PE2_MASK             4U
#define B_GPIO_CTL_PE3_MASK             8U
#define B_GPIO_CTL_DIR0_MASK            16U
#define B_GPIO_CTL_DIR1_MASK            32U
#define B_GPIO_CTL_DIR2_MASK            64U
#define B_GPIO_CTL_PE0M_MASK            256U
#define B_GPIO_CTL_PE1M_MASK            512U
#define B_GPIO_CTL_PE2M_MASK            1024U
#define B_GPIO_CTL_PE3M_MASK            2048U
#define B_GPIO_CTL_DIR0M_MASK           4096U
#define B_GPIO_CTL_DIR1M_MASK           8192U
#define B_GPIO_CTL_DIR2M_MASK           16384U
#define B_GPIO_CTL_PE_MASK              15U
#define B_GPIO_CTL_PE_BITNUM            0U
#define B_GPIO_CTL_DIR_MASK             112U
#define B_GPIO_CTL_DIR_BITNUM           4U


/*** B_GPIO_PUC - GPIO pull up configuration; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte PUE0        :1;                                       /* PTB0 Pull Up Enable */
    byte PUE1        :1;                                       /* PTB1 Pull Up Enable */
    byte PUE2        :1;                                       /* PTB2 Pull Up Enable */
    byte PDE3        :1;                                       /* PTB3 Pull Down Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPUE  :3;
    byte grpPDE_3 :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_GPIO_PUCSTR;
extern volatile B_GPIO_PUCSTR _B_GPIO_PUC @(REG_BASE + 0x00000242UL);
#define B_GPIO_PUC                      _B_GPIO_PUC.Byte
#define B_GPIO_PUC_PUE0                 _B_GPIO_PUC.Bits.PUE0
#define B_GPIO_PUC_PUE1                 _B_GPIO_PUC.Bits.PUE1
#define B_GPIO_PUC_PUE2                 _B_GPIO_PUC.Bits.PUE2
#define B_GPIO_PUC_PDE3                 _B_GPIO_PUC.Bits.PDE3
#define B_GPIO_PUC_PUE                  _B_GPIO_PUC.MergedBits.grpPUE

#define B_GPIO_PUC_PUE0_MASK            1U
#define B_GPIO_PUC_PUE1_MASK            2U
#define B_GPIO_PUC_PUE2_MASK            4U
#define B_GPIO_PUC_PDE3_MASK            8U
#define B_GPIO_PUC_PUE_MASK             7U
#define B_GPIO_PUC_PUE_BITNUM           0U


/*** B_GPIO_DATA - GPIO port data register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte PD0         :1;                                       /* PTB0 Data Register */
    byte PD1         :1;                                       /* PTB1 Data Register */
    byte PD2         :1;                                       /* PTB2 Data Register */
    byte PD3         :1;                                       /* PTB3 Data Register */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPD   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_GPIO_DATASTR;
extern volatile B_GPIO_DATASTR _B_GPIO_DATA @(REG_BASE + 0x00000243UL);
#define B_GPIO_DATA                     _B_GPIO_DATA.Byte
#define B_GPIO_DATA_PD0                 _B_GPIO_DATA.Bits.PD0
#define B_GPIO_DATA_PD1                 _B_GPIO_DATA.Bits.PD1
#define B_GPIO_DATA_PD2                 _B_GPIO_DATA.Bits.PD2
#define B_GPIO_DATA_PD3                 _B_GPIO_DATA.Bits.PD3
#define B_GPIO_DATA_PD                  _B_GPIO_DATA.MergedBits.grpPD

#define B_GPIO_DATA_PD0_MASK            1U
#define B_GPIO_DATA_PD1_MASK            2U
#define B_GPIO_DATA_PD2_MASK            4U
#define B_GPIO_DATA_PD3_MASK            8U
#define B_GPIO_DATA_PD_MASK             15U
#define B_GPIO_DATA_PD_BITNUM           0U


/*** B_GPIO_IN0 - Port 0 input configuration; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LINTX       :1;                                       /* PTB0 - LIN Module Tx Input */
    byte SCIRX       :1;                                       /* PTB0 - SCI Module Rx Input */
    byte TCAP0       :1;                                       /* PTB0 - Timer Input Capture Channel 0 */
    byte TCAP1       :1;                                       /* PTB0 - Timer Input Capture Channel 1 */
    byte TCAP2       :1;                                       /* PTB0 - Timer Input Capture Channel 2 */
    byte TCAP3       :1;                                       /* PTB0 - Timer Input Capture Channel 3 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} B_GPIO_IN0STR;
extern volatile B_GPIO_IN0STR _B_GPIO_IN0 @(REG_BASE + 0x00000244UL);
#define B_GPIO_IN0                      _B_GPIO_IN0.Byte
#define B_GPIO_IN0_LINTX                _B_GPIO_IN0.Bits.LINTX
#define B_GPIO_IN0_SCIRX                _B_GPIO_IN0.Bits.SCIRX
#define B_GPIO_IN0_TCAP0                _B_GPIO_IN0.Bits.TCAP0
#define B_GPIO_IN0_TCAP1                _B_GPIO_IN0.Bits.TCAP1
#define B_GPIO_IN0_TCAP2                _B_GPIO_IN0.Bits.TCAP2
#define B_GPIO_IN0_TCAP3                _B_GPIO_IN0.Bits.TCAP3
#define B_GPIO_IN0_TCAP                 _B_GPIO_IN0.MergedBits.grpTCAP

#define B_GPIO_IN0_LINTX_MASK           2U
#define B_GPIO_IN0_SCIRX_MASK           4U
#define B_GPIO_IN0_TCAP0_MASK           8U
#define B_GPIO_IN0_TCAP1_MASK           16U
#define B_GPIO_IN0_TCAP2_MASK           32U
#define B_GPIO_IN0_TCAP3_MASK           64U
#define B_GPIO_IN0_TCAP_MASK            120U
#define B_GPIO_IN0_TCAP_BITNUM          3U


/*** B_GPIO_OUT0 - Port 0 output configuration; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBX0       :1;                                       /* PTB0 - Output Buffer Control */
    byte LINRX       :1;                                       /* PTB0 - LIN RX Output */
    byte SCITX       :1;                                       /* PTB0 - SCI TX Output */
    byte TCOMP0      :1;                                       /* PTB0 - Timer Channel 0 - Output Compare output */
    byte TCOMP1      :1;                                       /* PTB0 - Timer Channel 1 - Output Compare output */
    byte TCOMP2      :1;                                       /* PTB0 - Timer Channel 2 - Output Compare output */
    byte TCOMP3      :1;                                       /* PTB0 - Timer Channel 3 - Output Compare output */
    byte WKUP        :1;                                       /* PTB0 - Wake Up output */
  } Bits;
  struct {
    byte grpPTBX :1;
    byte         :1;
    byte         :1;
    byte grpTCOMP :4;
    byte         :1;
  } MergedBits;
} B_GPIO_OUT0STR;
extern volatile B_GPIO_OUT0STR _B_GPIO_OUT0 @(REG_BASE + 0x00000245UL);
#define B_GPIO_OUT0                     _B_GPIO_OUT0.Byte
#define B_GPIO_OUT0_PTBX0               _B_GPIO_OUT0.Bits.PTBX0
#define B_GPIO_OUT0_LINRX               _B_GPIO_OUT0.Bits.LINRX
#define B_GPIO_OUT0_SCITX               _B_GPIO_OUT0.Bits.SCITX
#define B_GPIO_OUT0_TCOMP0              _B_GPIO_OUT0.Bits.TCOMP0
#define B_GPIO_OUT0_TCOMP1              _B_GPIO_OUT0.Bits.TCOMP1
#define B_GPIO_OUT0_TCOMP2              _B_GPIO_OUT0.Bits.TCOMP2
#define B_GPIO_OUT0_TCOMP3              _B_GPIO_OUT0.Bits.TCOMP3
#define B_GPIO_OUT0_WKUP                _B_GPIO_OUT0.Bits.WKUP
#define B_GPIO_OUT0_TCOMP               _B_GPIO_OUT0.MergedBits.grpTCOMP

#define B_GPIO_OUT0_PTBX0_MASK          1U
#define B_GPIO_OUT0_LINRX_MASK          2U
#define B_GPIO_OUT0_SCITX_MASK          4U
#define B_GPIO_OUT0_TCOMP0_MASK         8U
#define B_GPIO_OUT0_TCOMP1_MASK         16U
#define B_GPIO_OUT0_TCOMP2_MASK         32U
#define B_GPIO_OUT0_TCOMP3_MASK         64U
#define B_GPIO_OUT0_WKUP_MASK           128U
#define B_GPIO_OUT0_TCOMP_MASK          120U
#define B_GPIO_OUT0_TCOMP_BITNUM        3U


/*** B_GPIO_IN1 - Port 1 input configuration; 0x00000246 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LINTX       :1;                                       /* PTB1 - LIN Module Tx Input */
    byte SCIRX       :1;                                       /* PTB1 - SCI Module Rx Input */
    byte TCAP0       :1;                                       /* PTB1 - Timer Input Capture Channel 0 */
    byte TCAP1       :1;                                       /* PTB1 - Timer Input Capture Channel 1 */
    byte TCAP2       :1;                                       /* PTB1 - Timer Input Capture Channel 2 */
    byte TCAP3       :1;                                       /* PTB1 - Timer Input Capture Channel 3 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} B_GPIO_IN1STR;
extern volatile B_GPIO_IN1STR _B_GPIO_IN1 @(REG_BASE + 0x00000246UL);
#define B_GPIO_IN1                      _B_GPIO_IN1.Byte
#define B_GPIO_IN1_LINTX                _B_GPIO_IN1.Bits.LINTX
#define B_GPIO_IN1_SCIRX                _B_GPIO_IN1.Bits.SCIRX
#define B_GPIO_IN1_TCAP0                _B_GPIO_IN1.Bits.TCAP0
#define B_GPIO_IN1_TCAP1                _B_GPIO_IN1.Bits.TCAP1
#define B_GPIO_IN1_TCAP2                _B_GPIO_IN1.Bits.TCAP2
#define B_GPIO_IN1_TCAP3                _B_GPIO_IN1.Bits.TCAP3
#define B_GPIO_IN1_TCAP                 _B_GPIO_IN1.MergedBits.grpTCAP

#define B_GPIO_IN1_LINTX_MASK           2U
#define B_GPIO_IN1_SCIRX_MASK           4U
#define B_GPIO_IN1_TCAP0_MASK           8U
#define B_GPIO_IN1_TCAP1_MASK           16U
#define B_GPIO_IN1_TCAP2_MASK           32U
#define B_GPIO_IN1_TCAP3_MASK           64U
#define B_GPIO_IN1_TCAP_MASK            120U
#define B_GPIO_IN1_TCAP_BITNUM          3U


/*** B_GPIO_OUT1 - Port 1 output configuration; 0x00000247 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBX1       :1;                                       /* PTB1 - Output Buffer Control */
    byte LINRX       :1;                                       /* PTB1 - LIN RX Output */
    byte SCITX       :1;                                       /* PTB1 - SCI TX Output */
    byte TCOMP0      :1;                                       /* PTB1 - Timer Channel 0 - Output Compare output */
    byte TCOMP1      :1;                                       /* PTB1 - Timer Channel 1 - Output Compare output */
    byte TCOMP2      :1;                                       /* PTB1 - Timer Channel 2 - Output Compare output */
    byte TCOMP3      :1;                                       /* PTB1 - Timer Channel 3 - Output Compare output */
    byte WKUP        :1;                                       /* PTB1 - Wake Up output */
  } Bits;
  struct {
    byte grpPTBX_1 :1;
    byte         :1;
    byte         :1;
    byte grpTCOMP :4;
    byte         :1;
  } MergedBits;
} B_GPIO_OUT1STR;
extern volatile B_GPIO_OUT1STR _B_GPIO_OUT1 @(REG_BASE + 0x00000247UL);
#define B_GPIO_OUT1                     _B_GPIO_OUT1.Byte
#define B_GPIO_OUT1_PTBX1               _B_GPIO_OUT1.Bits.PTBX1
#define B_GPIO_OUT1_LINRX               _B_GPIO_OUT1.Bits.LINRX
#define B_GPIO_OUT1_SCITX               _B_GPIO_OUT1.Bits.SCITX
#define B_GPIO_OUT1_TCOMP0              _B_GPIO_OUT1.Bits.TCOMP0
#define B_GPIO_OUT1_TCOMP1              _B_GPIO_OUT1.Bits.TCOMP1
#define B_GPIO_OUT1_TCOMP2              _B_GPIO_OUT1.Bits.TCOMP2
#define B_GPIO_OUT1_TCOMP3              _B_GPIO_OUT1.Bits.TCOMP3
#define B_GPIO_OUT1_WKUP                _B_GPIO_OUT1.Bits.WKUP
#define B_GPIO_OUT1_TCOMP               _B_GPIO_OUT1.MergedBits.grpTCOMP

#define B_GPIO_OUT1_PTBX1_MASK          1U
#define B_GPIO_OUT1_LINRX_MASK          2U
#define B_GPIO_OUT1_SCITX_MASK          4U
#define B_GPIO_OUT1_TCOMP0_MASK         8U
#define B_GPIO_OUT1_TCOMP1_MASK         16U
#define B_GPIO_OUT1_TCOMP2_MASK         32U
#define B_GPIO_OUT1_TCOMP3_MASK         64U
#define B_GPIO_OUT1_WKUP_MASK           128U
#define B_GPIO_OUT1_TCOMP_MASK          120U
#define B_GPIO_OUT1_TCOMP_BITNUM        3U


/*** B_GPIO_IN2 - Port 2 input configuration; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LINTX       :1;                                       /* PTB2 - LIN Module Tx Input */
    byte SCIRX       :1;                                       /* PTB2 - SCI Module Rx Input */
    byte TCAP0       :1;                                       /* PTB2 - Timer Input Capture Channel 0 */
    byte TCAP1       :1;                                       /* PTB2 - Timer Input Capture Channel 1 */
    byte TCAP2       :1;                                       /* PTB2 - Timer Input Capture Channel 2 */
    byte TCAP3       :1;                                       /* PTB2 - Timer Input Capture Channel 3 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} B_GPIO_IN2STR;
extern volatile B_GPIO_IN2STR _B_GPIO_IN2 @(REG_BASE + 0x00000248UL);
#define B_GPIO_IN2                      _B_GPIO_IN2.Byte
#define B_GPIO_IN2_LINTX                _B_GPIO_IN2.Bits.LINTX
#define B_GPIO_IN2_SCIRX                _B_GPIO_IN2.Bits.SCIRX
#define B_GPIO_IN2_TCAP0                _B_GPIO_IN2.Bits.TCAP0
#define B_GPIO_IN2_TCAP1                _B_GPIO_IN2.Bits.TCAP1
#define B_GPIO_IN2_TCAP2                _B_GPIO_IN2.Bits.TCAP2
#define B_GPIO_IN2_TCAP3                _B_GPIO_IN2.Bits.TCAP3
#define B_GPIO_IN2_TCAP                 _B_GPIO_IN2.MergedBits.grpTCAP

#define B_GPIO_IN2_LINTX_MASK           2U
#define B_GPIO_IN2_SCIRX_MASK           4U
#define B_GPIO_IN2_TCAP0_MASK           8U
#define B_GPIO_IN2_TCAP1_MASK           16U
#define B_GPIO_IN2_TCAP2_MASK           32U
#define B_GPIO_IN2_TCAP3_MASK           64U
#define B_GPIO_IN2_TCAP_MASK            120U
#define B_GPIO_IN2_TCAP_BITNUM          3U


/*** B_GPIO_OUT2 - Port 2 output configuration; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBX2       :1;                                       /* PTB2 - Output Buffer Control */
    byte LINRX       :1;                                       /* PTB2 - LIN RX Output */
    byte SCITX       :1;                                       /* PTB2 - SCI TX Output */
    byte TCOMP0      :1;                                       /* PTB2 - Timer Channel 0 - Output Compare output */
    byte TCOMP1      :1;                                       /* PTB2 - Timer Channel 1 - Output Compare output */
    byte TCOMP2      :1;                                       /* PTB2 - Timer Channel 2 - Output Compare output */
    byte TCOMP3      :1;                                       /* PTB2 - Timer Channel 3 - Output Compare output */
    byte WKUP        :1;                                       /* PTB2 - Wake Up output */
  } Bits;
  struct {
    byte grpPTBX_2 :1;
    byte         :1;
    byte         :1;
    byte grpTCOMP :4;
    byte         :1;
  } MergedBits;
} B_GPIO_OUT2STR;
extern volatile B_GPIO_OUT2STR _B_GPIO_OUT2 @(REG_BASE + 0x00000249UL);
#define B_GPIO_OUT2                     _B_GPIO_OUT2.Byte
#define B_GPIO_OUT2_PTBX2               _B_GPIO_OUT2.Bits.PTBX2
#define B_GPIO_OUT2_LINRX               _B_GPIO_OUT2.Bits.LINRX
#define B_GPIO_OUT2_SCITX               _B_GPIO_OUT2.Bits.SCITX
#define B_GPIO_OUT2_TCOMP0              _B_GPIO_OUT2.Bits.TCOMP0
#define B_GPIO_OUT2_TCOMP1              _B_GPIO_OUT2.Bits.TCOMP1
#define B_GPIO_OUT2_TCOMP2              _B_GPIO_OUT2.Bits.TCOMP2
#define B_GPIO_OUT2_TCOMP3              _B_GPIO_OUT2.Bits.TCOMP3
#define B_GPIO_OUT2_WKUP                _B_GPIO_OUT2.Bits.WKUP
#define B_GPIO_OUT2_TCOMP               _B_GPIO_OUT2.MergedBits.grpTCOMP

#define B_GPIO_OUT2_PTBX2_MASK          1U
#define B_GPIO_OUT2_LINRX_MASK          2U
#define B_GPIO_OUT2_SCITX_MASK          4U
#define B_GPIO_OUT2_TCOMP0_MASK         8U
#define B_GPIO_OUT2_TCOMP1_MASK         16U
#define B_GPIO_OUT2_TCOMP2_MASK         32U
#define B_GPIO_OUT2_TCOMP3_MASK         64U
#define B_GPIO_OUT2_WKUP_MASK           128U
#define B_GPIO_OUT2_TCOMP_MASK          120U
#define B_GPIO_OUT2_TCOMP_BITNUM        3U


/*** B_GPIO_IN3 - Port 3 input configuration; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TCAP0       :1;                                       /* PTB3 - Timer Input Capture Channel 0 */
    byte TCAP1       :1;                                       /* PTB3 - Timer Input Capture Channel 1 */
    byte TCAP2       :1;                                       /* PTB3 - Timer Input Capture Channel 2 */
    byte TCAP3       :1;                                       /* PTB3 - Timer Input Capture Channel 3 */
    byte PTWU        :1;                                       /* PTB3 Wake Up */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} B_GPIO_IN3STR;
extern volatile B_GPIO_IN3STR _B_GPIO_IN3 @(REG_BASE + 0x0000024AUL);
#define B_GPIO_IN3                      _B_GPIO_IN3.Byte
#define B_GPIO_IN3_TCAP0                _B_GPIO_IN3.Bits.TCAP0
#define B_GPIO_IN3_TCAP1                _B_GPIO_IN3.Bits.TCAP1
#define B_GPIO_IN3_TCAP2                _B_GPIO_IN3.Bits.TCAP2
#define B_GPIO_IN3_TCAP3                _B_GPIO_IN3.Bits.TCAP3
#define B_GPIO_IN3_PTWU                 _B_GPIO_IN3.Bits.PTWU
#define B_GPIO_IN3_TCAP                 _B_GPIO_IN3.MergedBits.grpTCAP

#define B_GPIO_IN3_TCAP0_MASK           8U
#define B_GPIO_IN3_TCAP1_MASK           16U
#define B_GPIO_IN3_TCAP2_MASK           32U
#define B_GPIO_IN3_TCAP3_MASK           64U
#define B_GPIO_IN3_PTWU_MASK            128U
#define B_GPIO_IN3_TCAP_MASK            120U
#define B_GPIO_IN3_TCAP_BITNUM          3U


/*** B_LIN_CTL - LIN control register; 0x00000250 ***/
typedef union {
  word Word;
  struct {
    word SRS         :2;                                       /* Slew Rate Select */
    word EN          :1;                                       /* Module Enable */
    word LVSD        :1;                                       /* Low Voltage Shutdown Disable (J2602 Compliance Control) */
    word TXD         :1;                                       /* Direct Transmitter Control */
    word             :1; 
    word             :1; 
    word OTIE        :1;                                       /* Overtemperature Interrupt Enable */
    word SRSM        :2;                                       /* Slew Rate Select - Mask */
    word ENM         :1;                                       /* Module Enable - Mask */
    word LVSDM       :1;                                       /* Low Voltage Shutdown Disable (J2602 Compliance Control) - Mask */
    word TXDM        :1;                                       /* Direct Transmitter Control - Mask */
    word             :1; 
    word             :1; 
    word OTIEM       :1;                                       /* Overtemperature Interrupt Enable - Mask */
  } Bits;
} B_LIN_CTLSTR;
extern volatile B_LIN_CTLSTR _B_LIN_CTL @(REG_BASE + 0x00000250UL);
#define B_LIN_CTL                       _B_LIN_CTL.Word
#define B_LIN_CTL_SRS                   _B_LIN_CTL.Bits.SRS
#define B_LIN_CTL_EN                    _B_LIN_CTL.Bits.EN
#define B_LIN_CTL_LVSD                  _B_LIN_CTL.Bits.LVSD
#define B_LIN_CTL_TXD                   _B_LIN_CTL.Bits.TXD
#define B_LIN_CTL_OTIE                  _B_LIN_CTL.Bits.OTIE
#define B_LIN_CTL_SRSM                  _B_LIN_CTL.Bits.SRSM
#define B_LIN_CTL_ENM                   _B_LIN_CTL.Bits.ENM
#define B_LIN_CTL_LVSDM                 _B_LIN_CTL.Bits.LVSDM
#define B_LIN_CTL_TXDM                  _B_LIN_CTL.Bits.TXDM
#define B_LIN_CTL_OTIEM                 _B_LIN_CTL.Bits.OTIEM

#define B_LIN_CTL_SRS_MASK              3U
#define B_LIN_CTL_SRS_BITNUM            0U
#define B_LIN_CTL_EN_MASK               4U
#define B_LIN_CTL_LVSD_MASK             8U
#define B_LIN_CTL_TXD_MASK              16U
#define B_LIN_CTL_OTIE_MASK             128U
#define B_LIN_CTL_SRSM_MASK             768U
#define B_LIN_CTL_SRSM_BITNUM           8U
#define B_LIN_CTL_ENM_MASK              1024U
#define B_LIN_CTL_LVSDM_MASK            2048U
#define B_LIN_CTL_TXDM_MASK             4096U
#define B_LIN_CTL_OTIEM_MASK            32768U


/*** B_LIN_SR - LIN status register; 0x00000252 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LIN_SRH - LIN status register high; 0x00000252 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte UV          :1;                                       /* Undervoltage Status */
        byte             :1; 
        byte HF          :1;                                       /* HF (High Frequency) Condition Status indicating HF disturbance in the LIN module */
        byte             :1; 
        byte OT          :1;                                       /* Overtemperature Status */
      } Bits;
    } B_LIN_SRHSTR;
    #define B_LIN_SRH                   _B_LIN_SR.Overlap_STR.B_LIN_SRHSTR.Byte
    #define B_LIN_SRH_UV                _B_LIN_SR.Overlap_STR.B_LIN_SRHSTR.Bits.UV
    #define B_LIN_SRH_HF                _B_LIN_SR.Overlap_STR.B_LIN_SRHSTR.Bits.HF
    #define B_LIN_SRH_OT                _B_LIN_SR.Overlap_STR.B_LIN_SRHSTR.Bits.OT
    
    #define B_LIN_SRH_UV_MASK           8U
    #define B_LIN_SRH_HF_MASK           32U
    #define B_LIN_SRH_OT_MASK           128U
    

    /*** B_LIN_SRL - LIN status register low; 0x00000253 ***/
    union {
      byte Byte;
      struct {
        byte TX          :1;                                       /* Current TX status */
        byte RX          :1;                                       /* Current RX status */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte RDY         :1;                                       /* Transmitter Ready Status */
      } Bits;
    } B_LIN_SRLSTR;
    #define B_LIN_SRL                   _B_LIN_SR.Overlap_STR.B_LIN_SRLSTR.Byte
    #define B_LIN_SRL_TX                _B_LIN_SR.Overlap_STR.B_LIN_SRLSTR.Bits.TX
    #define B_LIN_SRL_RX                _B_LIN_SR.Overlap_STR.B_LIN_SRLSTR.Bits.RX
    #define B_LIN_SRL_RDY               _B_LIN_SR.Overlap_STR.B_LIN_SRLSTR.Bits.RDY
    
    #define B_LIN_SRL_TX_MASK           1U
    #define B_LIN_SRL_RX_MASK           2U
    #define B_LIN_SRL_RDY_MASK          128U
    
  } Overlap_STR;

  struct {
    word TX          :1;                                       /* Current TX status */
    word RX          :1;                                       /* Current RX status */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word RDY         :1;                                       /* Transmitter Ready Status */
    word             :1; 
    word             :1; 
    word             :1; 
    word UV          :1;                                       /* Undervoltage Status */
    word             :1; 
    word HF          :1;                                       /* HF (High Frequency) Condition Status indicating HF disturbance in the LIN module */
    word             :1; 
    word OT          :1;                                       /* Overtemperature Status */
  } Bits;
} B_LIN_SRSTR;
extern volatile B_LIN_SRSTR _B_LIN_SR @(REG_BASE + 0x00000252UL);
#define B_LIN_SR                        _B_LIN_SR.Word
#define B_LIN_SR_TX                     _B_LIN_SR.Bits.TX
#define B_LIN_SR_RX                     _B_LIN_SR.Bits.RX
#define B_LIN_SR_RDY                    _B_LIN_SR.Bits.RDY
#define B_LIN_SR_UV                     _B_LIN_SR.Bits.UV
#define B_LIN_SR_HF                     _B_LIN_SR.Bits.HF
#define B_LIN_SR_OT                     _B_LIN_SR.Bits.OT

#define B_LIN_SR_TX_MASK                1U
#define B_LIN_SR_RX_MASK                2U
#define B_LIN_SR_RDY_MASK               128U
#define B_LIN_SR_UV_MASK                2048U
#define B_LIN_SR_HF_MASK                8192U
#define B_LIN_SR_OT_MASK                32768U


/*** B_LIN_TX - LIN transmit line definition; 0x00000254 ***/
typedef union {
  byte Byte;
  struct {
    byte FROMSCI     :1;                                       /* LIN_TX internally routed from SCI */
    byte FROMPTB     :1;                                       /* LIN_TX internally routed from PTB */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_LIN_TXSTR;
extern volatile B_LIN_TXSTR _B_LIN_TX @(REG_BASE + 0x00000254UL);
#define B_LIN_TX                        _B_LIN_TX.Byte
#define B_LIN_TX_FROMSCI                _B_LIN_TX.Bits.FROMSCI
#define B_LIN_TX_FROMPTB                _B_LIN_TX.Bits.FROMPTB

#define B_LIN_TX_FROMSCI_MASK           1U
#define B_LIN_TX_FROMPTB_MASK           2U


/*** B_LIN_RX - LIN receive line definition; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte TOSCI       :1;                                       /* LIN_RX internally routed to SCI */
    byte TOPTB       :1;                                       /* LIN_RX internally routed to PTB */
    byte             :1; 
    byte TCAP0       :1;                                       /* LIN_RX internally routed to Timer Channel 0 Input Capture */
    byte TCAP1       :1;                                       /* LIN_RX internally routed to Timer Channel 1 Input Capture */
    byte TCAP2       :1;                                       /* LIN_RX internally routed to Timer Channel 2 Input Capture */
    byte TCAP3       :1;                                       /* LIN_RX internally routed to Timer Channel 3 Input Capture */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} B_LIN_RXSTR;
extern volatile B_LIN_RXSTR _B_LIN_RX @(REG_BASE + 0x00000255UL);
#define B_LIN_RX                        _B_LIN_RX.Byte
#define B_LIN_RX_TOSCI                  _B_LIN_RX.Bits.TOSCI
#define B_LIN_RX_TOPTB                  _B_LIN_RX.Bits.TOPTB
#define B_LIN_RX_TCAP0                  _B_LIN_RX.Bits.TCAP0
#define B_LIN_RX_TCAP1                  _B_LIN_RX.Bits.TCAP1
#define B_LIN_RX_TCAP2                  _B_LIN_RX.Bits.TCAP2
#define B_LIN_RX_TCAP3                  _B_LIN_RX.Bits.TCAP3
#define B_LIN_RX_TCAP                   _B_LIN_RX.MergedBits.grpTCAP

#define B_LIN_RX_TOSCI_MASK             1U
#define B_LIN_RX_TOPTB_MASK             2U
#define B_LIN_RX_TCAP0_MASK             8U
#define B_LIN_RX_TCAP1_MASK             16U
#define B_LIN_RX_TCAP2_MASK             32U
#define B_LIN_RX_TCAP3_MASK             64U
#define B_LIN_RX_TCAP_MASK              120U
#define B_LIN_RX_TCAP_BITNUM            3U


/*** B_ACQ_CTL - Acquisition control register; 0x00000258 ***/
typedef union {
  word Word;
  struct {
    word CMEN        :1;                                       /* Current Measurement Enable */
    word VMEN        :1;                                       /* Voltage Measurement Enable */
    word ITMEN       :1;                                       /* Internal Temperature Measurement Enable */
    word ETMEN       :1;                                       /* External Temperature Measurement Enable */
    word CVMIE       :1;                                       /* Current / Voltage Measurement Interrupt Enable */
    word OPENE       :1;                                       /* Enable Shunt Resistor Open Detection */
    word OPTE        :1;                                       /* Optional Voltage Sense Enable (Voltage Channel Multiplexer Control) */
    word AHCR        :1;                                       /* Ampere Hour Counter Reset, this write only bit will reset the ACQ_AHC register */
    word CMENM       :1;                                       /* Current Measurement Enable - Mask */
    word VMENM       :1;                                       /* Voltage Measurement Enable - Mask */
    word ITMENM      :1;                                       /* Internal Temperature Measurement Enable - Mask */
    word ETMENM      :1;                                       /* External Temperature Measurement Enable - Mask */
    word CVMIEM      :1;                                       /* Current / Voltage Measurement Interrupt Enable - Mask */
    word OPENEM      :1;                                       /* Enable Shunt Resistor Open Detection - Mask */
    word OPTEM       :1;                                       /* Optional Voltage Sense Enable - Mask */
    word AHCRM       :1;                                       /* Ampere Hour Counter Reset - Mask */
  } Bits;
} B_ACQ_CTLSTR;
extern volatile B_ACQ_CTLSTR _B_ACQ_CTL @(REG_BASE + 0x00000258UL);
#define B_ACQ_CTL                       _B_ACQ_CTL.Word
#define B_ACQ_CTL_CMEN                  _B_ACQ_CTL.Bits.CMEN
#define B_ACQ_CTL_VMEN                  _B_ACQ_CTL.Bits.VMEN
#define B_ACQ_CTL_ITMEN                 _B_ACQ_CTL.Bits.ITMEN
#define B_ACQ_CTL_ETMEN                 _B_ACQ_CTL.Bits.ETMEN
#define B_ACQ_CTL_CVMIE                 _B_ACQ_CTL.Bits.CVMIE
#define B_ACQ_CTL_OPENE                 _B_ACQ_CTL.Bits.OPENE
#define B_ACQ_CTL_OPTE                  _B_ACQ_CTL.Bits.OPTE
#define B_ACQ_CTL_AHCR                  _B_ACQ_CTL.Bits.AHCR
#define B_ACQ_CTL_CMENM                 _B_ACQ_CTL.Bits.CMENM
#define B_ACQ_CTL_VMENM                 _B_ACQ_CTL.Bits.VMENM
#define B_ACQ_CTL_ITMENM                _B_ACQ_CTL.Bits.ITMENM
#define B_ACQ_CTL_ETMENM                _B_ACQ_CTL.Bits.ETMENM
#define B_ACQ_CTL_CVMIEM                _B_ACQ_CTL.Bits.CVMIEM
#define B_ACQ_CTL_OPENEM                _B_ACQ_CTL.Bits.OPENEM
#define B_ACQ_CTL_OPTEM                 _B_ACQ_CTL.Bits.OPTEM
#define B_ACQ_CTL_AHCRM                 _B_ACQ_CTL.Bits.AHCRM

#define B_ACQ_CTL_CMEN_MASK             1U
#define B_ACQ_CTL_VMEN_MASK             2U
#define B_ACQ_CTL_ITMEN_MASK            4U
#define B_ACQ_CTL_ETMEN_MASK            8U
#define B_ACQ_CTL_CVMIE_MASK            16U
#define B_ACQ_CTL_OPENE_MASK            32U
#define B_ACQ_CTL_OPTE_MASK             64U
#define B_ACQ_CTL_AHCR_MASK             128U
#define B_ACQ_CTL_CMENM_MASK            256U
#define B_ACQ_CTL_VMENM_MASK            512U
#define B_ACQ_CTL_ITMENM_MASK           1024U
#define B_ACQ_CTL_ETMENM_MASK           2048U
#define B_ACQ_CTL_CVMIEM_MASK           4096U
#define B_ACQ_CTL_OPENEM_MASK           8192U
#define B_ACQ_CTL_OPTEM_MASK            16384U
#define B_ACQ_CTL_AHCRM_MASK            32768U


/*** B_ACQ_SR - Acquisition status register; 0x0000025A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ACQ_SRH - Acquisition status register high; 0x0000025A ***/
    union {
      byte Byte;
      struct {
        byte CM          :1;                                       /* End of Measurement - Current */
        byte VM          :1;                                       /* End of Measurement - Voltage */
        byte ITM         :1;                                       /* End of Measurement - Internal Temperature */
        byte ETM         :1;                                       /* End of Measurement - External Temperature */
        byte CMOW        :1;                                       /* Current Measurement Result Overwritten */
        byte VMOW        :1;                                       /* Voltage Measurement Result Overwritten */
        byte PGAG        :1;                                       /* PGA Gain Change Flag */
        byte AVRF        :1;                                       /* VDDA Low Voltage Reset Flag */
      } Bits;
    } B_ACQ_SRHSTR;
    #define B_ACQ_SRH                   _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Byte
    #define B_ACQ_SRH_CM                _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Bits.CM
    #define B_ACQ_SRH_VM                _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Bits.VM
    #define B_ACQ_SRH_ITM               _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Bits.ITM
    #define B_ACQ_SRH_ETM               _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Bits.ETM
    #define B_ACQ_SRH_CMOW              _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Bits.CMOW
    #define B_ACQ_SRH_VMOW              _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Bits.VMOW
    #define B_ACQ_SRH_PGAG              _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Bits.PGAG
    #define B_ACQ_SRH_AVRF              _B_ACQ_SR.Overlap_STR.B_ACQ_SRHSTR.Bits.AVRF
    
    #define B_ACQ_SRH_CM_MASK           1U
    #define B_ACQ_SRH_VM_MASK           2U
    #define B_ACQ_SRH_ITM_MASK          4U
    #define B_ACQ_SRH_ETM_MASK          8U
    #define B_ACQ_SRH_CMOW_MASK         16U
    #define B_ACQ_SRH_VMOW_MASK         32U
    #define B_ACQ_SRH_PGAG_MASK         64U
    #define B_ACQ_SRH_AVRF_MASK         128U
    

    /*** B_ACQ_SRL - Acquisition status register low; 0x0000025B ***/
    union {
      byte Byte;
      struct {
        byte CCHOP       :1;                                       /* Chopping Active Status - Current */
        byte VCHOP       :1;                                       /* Chopping Active Status - Voltage */
        byte ITCHOP      :1;                                       /* Chopping Active Status - Internal Temperature */
        byte ETCHOP      :1;                                       /* Chopping Active Status - External Temperature */
        byte VTH         :1;                                       /* Digital Voltage High Threshold Reached */
        byte             :1; 
        byte             :1; 
        byte OPEN        :1;                                       /* Shunt Resistor Open Detection Status */
      } Bits;
    } B_ACQ_SRLSTR;
    #define B_ACQ_SRL                   _B_ACQ_SR.Overlap_STR.B_ACQ_SRLSTR.Byte
    #define B_ACQ_SRL_CCHOP             _B_ACQ_SR.Overlap_STR.B_ACQ_SRLSTR.Bits.CCHOP
    #define B_ACQ_SRL_VCHOP             _B_ACQ_SR.Overlap_STR.B_ACQ_SRLSTR.Bits.VCHOP
    #define B_ACQ_SRL_ITCHOP            _B_ACQ_SR.Overlap_STR.B_ACQ_SRLSTR.Bits.ITCHOP
    #define B_ACQ_SRL_ETCHOP            _B_ACQ_SR.Overlap_STR.B_ACQ_SRLSTR.Bits.ETCHOP
    #define B_ACQ_SRL_VTH               _B_ACQ_SR.Overlap_STR.B_ACQ_SRLSTR.Bits.VTH
    #define B_ACQ_SRL_OPEN              _B_ACQ_SR.Overlap_STR.B_ACQ_SRLSTR.Bits.OPEN
    
    #define B_ACQ_SRL_CCHOP_MASK        1U
    #define B_ACQ_SRL_VCHOP_MASK        2U
    #define B_ACQ_SRL_ITCHOP_MASK       4U
    #define B_ACQ_SRL_ETCHOP_MASK       8U
    #define B_ACQ_SRL_VTH_MASK          16U
    #define B_ACQ_SRL_OPEN_MASK         128U
    
  } Overlap_STR;

  struct {
    word CCHOP       :1;                                       /* Chopping Active Status - Current */
    word VCHOP       :1;                                       /* Chopping Active Status - Voltage */
    word ITCHOP      :1;                                       /* Chopping Active Status - Internal Temperature */
    word ETCHOP      :1;                                       /* Chopping Active Status - External Temperature */
    word VTH         :1;                                       /* Digital Voltage High Threshold Reached */
    word             :1; 
    word             :1; 
    word OPEN        :1;                                       /* Shunt Resistor Open Detection Status */
    word CM          :1;                                       /* End of Measurement - Current */
    word VM          :1;                                       /* End of Measurement - Voltage */
    word ITM         :1;                                       /* End of Measurement - Internal Temperature */
    word ETM         :1;                                       /* End of Measurement - External Temperature */
    word CMOW        :1;                                       /* Current Measurement Result Overwritten */
    word VMOW        :1;                                       /* Voltage Measurement Result Overwritten */
    word PGAG        :1;                                       /* PGA Gain Change Flag */
    word AVRF        :1;                                       /* VDDA Low Voltage Reset Flag */
  } Bits;
} B_ACQ_SRSTR;
extern volatile B_ACQ_SRSTR _B_ACQ_SR @(REG_BASE + 0x0000025AUL);
#define B_ACQ_SR                        _B_ACQ_SR.Word
#define B_ACQ_SR_CCHOP                  _B_ACQ_SR.Bits.CCHOP
#define B_ACQ_SR_VCHOP                  _B_ACQ_SR.Bits.VCHOP
#define B_ACQ_SR_ITCHOP                 _B_ACQ_SR.Bits.ITCHOP
#define B_ACQ_SR_ETCHOP                 _B_ACQ_SR.Bits.ETCHOP
#define B_ACQ_SR_VTH                    _B_ACQ_SR.Bits.VTH
#define B_ACQ_SR_OPEN                   _B_ACQ_SR.Bits.OPEN
#define B_ACQ_SR_CM                     _B_ACQ_SR.Bits.CM
#define B_ACQ_SR_VM                     _B_ACQ_SR.Bits.VM
#define B_ACQ_SR_ITM                    _B_ACQ_SR.Bits.ITM
#define B_ACQ_SR_ETM                    _B_ACQ_SR.Bits.ETM
#define B_ACQ_SR_CMOW                   _B_ACQ_SR.Bits.CMOW
#define B_ACQ_SR_VMOW                   _B_ACQ_SR.Bits.VMOW
#define B_ACQ_SR_PGAG                   _B_ACQ_SR.Bits.PGAG
#define B_ACQ_SR_AVRF                   _B_ACQ_SR.Bits.AVRF

#define B_ACQ_SR_CCHOP_MASK             1U
#define B_ACQ_SR_VCHOP_MASK             2U
#define B_ACQ_SR_ITCHOP_MASK            4U
#define B_ACQ_SR_ETCHOP_MASK            8U
#define B_ACQ_SR_VTH_MASK               16U
#define B_ACQ_SR_OPEN_MASK              128U
#define B_ACQ_SR_CM_MASK                256U
#define B_ACQ_SR_VM_MASK                512U
#define B_ACQ_SR_ITM_MASK               1024U
#define B_ACQ_SR_ETM_MASK               2048U
#define B_ACQ_SR_CMOW_MASK              4096U
#define B_ACQ_SR_VMOW_MASK              8192U
#define B_ACQ_SR_PGAG_MASK              16384U
#define B_ACQ_SR_AVRF_MASK              32768U


/*** B_ACQ_ACC1 - Acquisition chain control 1; 0x0000025C ***/
typedef union {
  word Word;
  struct {
    word AGEN        :1;                                       /* Automatic Gain Control Enable - Mask */
    word CVCHOP      :1;                                       /* Chopping Enable - Voltage Measurement Channel - Mask */
    word ITCHOP      :1;                                       /* Chopping Enable - Internal Temperature Measurement Channel - Mask */
    word ETCHOP      :1;                                       /* Chopping Enable - External Temperature Measurement Channel - Mask */
    word LPFEN       :1;                                       /* LPF Enable - Mask */
    word CCOMP       :1;                                       /* Current Measurement Channel - Compensation Enable - Mask */
    word VCOMP       :1;                                       /* Voltage Measurement Channel - Compensation Enable - Mask */
    word TCOMP       :1;                                       /* Temperature Measurement Channel - Compensation Enable - Mask */
    word AGENM       :1;                                       /* Temperature Measurement Channel - Compensation Enable */
    word CVCHOPM     :1;                                       /* Voltage Compensation Enable */
    word ITCHOPM     :1;                                       /* Current Compensation Enable */
    word ETCHOPM     :1;                                       /* LPF Enable */
    word LPFENM      :1;                                       /* Chopping Enable - External Temperature */
    word CCOMPM      :1;                                       /* Chopping Enable - Internal Temperature */
    word VCOMPM      :1;                                       /* Chopping Enable - Voltage */
    word TCOMPM      :1;                                       /* Automatic Gain Control Enable */
  } Bits;
} B_ACQ_ACC1STR;
extern volatile B_ACQ_ACC1STR _B_ACQ_ACC1 @(REG_BASE + 0x0000025CUL);
#define B_ACQ_ACC1                      _B_ACQ_ACC1.Word
#define B_ACQ_ACC1_AGEN                 _B_ACQ_ACC1.Bits.AGEN
#define B_ACQ_ACC1_CVCHOP               _B_ACQ_ACC1.Bits.CVCHOP
#define B_ACQ_ACC1_ITCHOP               _B_ACQ_ACC1.Bits.ITCHOP
#define B_ACQ_ACC1_ETCHOP               _B_ACQ_ACC1.Bits.ETCHOP
#define B_ACQ_ACC1_LPFEN                _B_ACQ_ACC1.Bits.LPFEN
#define B_ACQ_ACC1_CCOMP                _B_ACQ_ACC1.Bits.CCOMP
#define B_ACQ_ACC1_VCOMP                _B_ACQ_ACC1.Bits.VCOMP
#define B_ACQ_ACC1_TCOMP                _B_ACQ_ACC1.Bits.TCOMP
#define B_ACQ_ACC1_AGENM                _B_ACQ_ACC1.Bits.AGENM
#define B_ACQ_ACC1_CVCHOPM              _B_ACQ_ACC1.Bits.CVCHOPM
#define B_ACQ_ACC1_ITCHOPM              _B_ACQ_ACC1.Bits.ITCHOPM
#define B_ACQ_ACC1_ETCHOPM              _B_ACQ_ACC1.Bits.ETCHOPM
#define B_ACQ_ACC1_LPFENM               _B_ACQ_ACC1.Bits.LPFENM
#define B_ACQ_ACC1_CCOMPM               _B_ACQ_ACC1.Bits.CCOMPM
#define B_ACQ_ACC1_VCOMPM               _B_ACQ_ACC1.Bits.VCOMPM
#define B_ACQ_ACC1_TCOMPM               _B_ACQ_ACC1.Bits.TCOMPM

#define B_ACQ_ACC1_AGEN_MASK            1U
#define B_ACQ_ACC1_CVCHOP_MASK          2U
#define B_ACQ_ACC1_ITCHOP_MASK          4U
#define B_ACQ_ACC1_ETCHOP_MASK          8U
#define B_ACQ_ACC1_LPFEN_MASK           16U
#define B_ACQ_ACC1_CCOMP_MASK           32U
#define B_ACQ_ACC1_VCOMP_MASK           64U
#define B_ACQ_ACC1_TCOMP_MASK           128U
#define B_ACQ_ACC1_AGENM_MASK           256U
#define B_ACQ_ACC1_CVCHOPM_MASK         512U
#define B_ACQ_ACC1_ITCHOPM_MASK         1024U
#define B_ACQ_ACC1_ETCHOPM_MASK         2048U
#define B_ACQ_ACC1_LPFENM_MASK          4096U
#define B_ACQ_ACC1_CCOMPM_MASK          8192U
#define B_ACQ_ACC1_VCOMPM_MASK          16384U
#define B_ACQ_ACC1_TCOMPM_MASK          32768U


/*** B_ACQ_ACC0 - Acquisition chain control 0; 0x0000025E ***/
typedef union {
  word Word;
  struct {
    word CDEN        :1;                                       /* Timing delay - Current */
    word VDEN        :1;                                       /* Timing delay - Voltage */
    word TDEN        :1;                                       /* Timing delay - Temperature */
    word CADCG       :1;                                       /* Current ADC Gain Select */
    word VADCG       :1;                                       /* Voltage ADC Gain Select */
    word TADCG       :1;                                       /* Temperature ADC Gain Select */
    word ECAP        :1;                                       /* TSUP External Capacitor select */
    word ZERO        :1;                                       /* Current and Voltage Sigma Delta Input Short */
    word CDENM       :1;                                       /* 100ns Clock delay - Current - Mask */
    word VDENM       :1;                                       /* 100ns Clock delay - Voltage - Mask */
    word TDENM       :1;                                       /* 100ns Clock delay - Internal Temperature - Mask */
    word CADCGM      :1;                                       /* Current ADC Gain Select - Mask */
    word VADCGM      :1;                                       /* Voltage ADC Gain Select - Mask */
    word TADCGM      :1;                                       /* Temperature ADC Gain Select - Mask */
    word ECAPM       :1;                                       /* TSUP External Capacitor - Mask */
    word ZEROM       :1;                                       /* Current and Voltage Sigma Delta Input Short - Mask */
  } Bits;
} B_ACQ_ACC0STR;
extern volatile B_ACQ_ACC0STR _B_ACQ_ACC0 @(REG_BASE + 0x0000025EUL);
#define B_ACQ_ACC0                      _B_ACQ_ACC0.Word
#define B_ACQ_ACC0_CDEN                 _B_ACQ_ACC0.Bits.CDEN
#define B_ACQ_ACC0_VDEN                 _B_ACQ_ACC0.Bits.VDEN
#define B_ACQ_ACC0_TDEN                 _B_ACQ_ACC0.Bits.TDEN
#define B_ACQ_ACC0_CADCG                _B_ACQ_ACC0.Bits.CADCG
#define B_ACQ_ACC0_VADCG                _B_ACQ_ACC0.Bits.VADCG
#define B_ACQ_ACC0_TADCG                _B_ACQ_ACC0.Bits.TADCG
#define B_ACQ_ACC0_ECAP                 _B_ACQ_ACC0.Bits.ECAP
#define B_ACQ_ACC0_ZERO                 _B_ACQ_ACC0.Bits.ZERO
#define B_ACQ_ACC0_CDENM                _B_ACQ_ACC0.Bits.CDENM
#define B_ACQ_ACC0_VDENM                _B_ACQ_ACC0.Bits.VDENM
#define B_ACQ_ACC0_TDENM                _B_ACQ_ACC0.Bits.TDENM
#define B_ACQ_ACC0_CADCGM               _B_ACQ_ACC0.Bits.CADCGM
#define B_ACQ_ACC0_VADCGM               _B_ACQ_ACC0.Bits.VADCGM
#define B_ACQ_ACC0_TADCGM               _B_ACQ_ACC0.Bits.TADCGM
#define B_ACQ_ACC0_ECAPM                _B_ACQ_ACC0.Bits.ECAPM
#define B_ACQ_ACC0_ZEROM                _B_ACQ_ACC0.Bits.ZEROM

#define B_ACQ_ACC0_CDEN_MASK            1U
#define B_ACQ_ACC0_VDEN_MASK            2U
#define B_ACQ_ACC0_TDEN_MASK            4U
#define B_ACQ_ACC0_CADCG_MASK           8U
#define B_ACQ_ACC0_VADCG_MASK           16U
#define B_ACQ_ACC0_TADCG_MASK           32U
#define B_ACQ_ACC0_ECAP_MASK            64U
#define B_ACQ_ACC0_ZERO_MASK            128U
#define B_ACQ_ACC0_CDENM_MASK           256U
#define B_ACQ_ACC0_VDENM_MASK           512U
#define B_ACQ_ACC0_TDENM_MASK           1024U
#define B_ACQ_ACC0_CADCGM_MASK          2048U
#define B_ACQ_ACC0_VADCGM_MASK          4096U
#define B_ACQ_ACC0_TADCGM_MASK          8192U
#define B_ACQ_ACC0_ECAPM_MASK           16384U
#define B_ACQ_ACC0_ZEROM_MASK           32768U


/*** B_ACQ_DEC - Decimation Rate; 0x00000260 ***/
typedef union {
  byte Byte;
  struct {
    byte DEC         :3;                                       /* Decimation Rate Selection */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_ACQ_DECSTR;
extern volatile B_ACQ_DECSTR _B_ACQ_DEC @(REG_BASE + 0x00000260UL);
#define B_ACQ_DEC                       _B_ACQ_DEC.Byte
#define B_ACQ_DEC_DEC                   _B_ACQ_DEC.Bits.DEC

#define B_ACQ_DEC_DEC_MASK              7U
#define B_ACQ_DEC_DEC_BITNUM            0U


/*** B_ACQ_BGC - Decimation Rate; 0x00000261 ***/
typedef union {
  byte Byte;
  struct {
    byte BG1EN       :1;                                       /* Bandgap Status */
    byte BG2EN       :1;                                       /* Bandgap 3 Status */
    byte BG3EN       :1;                                       /* Bandgap 3 Status */
    byte BGLDO       :1;                                       /* LDO (Low Dropout Regulator) Bandgap select */
    byte BGADC       :2;                                       /* ADC Bandgap select */
    byte             :1; 
    byte             :1; 
  } Bits;
} B_ACQ_BGCSTR;
extern volatile B_ACQ_BGCSTR _B_ACQ_BGC @(REG_BASE + 0x00000261UL);
#define B_ACQ_BGC                       _B_ACQ_BGC.Byte
#define B_ACQ_BGC_BG1EN                 _B_ACQ_BGC.Bits.BG1EN
#define B_ACQ_BGC_BG2EN                 _B_ACQ_BGC.Bits.BG2EN
#define B_ACQ_BGC_BG3EN                 _B_ACQ_BGC.Bits.BG3EN
#define B_ACQ_BGC_BGLDO                 _B_ACQ_BGC.Bits.BGLDO
#define B_ACQ_BGC_BGADC                 _B_ACQ_BGC.Bits.BGADC

#define B_ACQ_BGC_BG1EN_MASK            1U
#define B_ACQ_BGC_BG2EN_MASK            2U
#define B_ACQ_BGC_BG3EN_MASK            4U
#define B_ACQ_BGC_BGLDO_MASK            8U
#define B_ACQ_BGC_BGADC_MASK            48U
#define B_ACQ_BGC_BGADC_BITNUM          4U


/*** B_ACQ_GAIN - PGA gain; 0x00000262 ***/
typedef union {
  byte Byte;
  struct {
    byte IGAIN       :3;                                       /* PGA Gain Register */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_ACQ_GAINSTR;
extern volatile B_ACQ_GAINSTR _B_ACQ_GAIN @(REG_BASE + 0x00000262UL);
#define B_ACQ_GAIN                      _B_ACQ_GAIN.Byte
#define B_ACQ_GAIN_IGAIN                _B_ACQ_GAIN.Bits.IGAIN

#define B_ACQ_GAIN_IGAIN_MASK           7U
#define B_ACQ_GAIN_IGAIN_BITNUM         0U


/*** B_ACQ_GCB - PGA gain; 0x00000263 ***/
typedef union {
  byte Byte;
  struct {
    byte Dlo         :4;                                       /* Gain Control Block (GCB) - Down Threshold */
    byte Dhi         :4;                                       /* Gain Control Block (GCB) - Up Threshold */
  } Bits;
} B_ACQ_GCBSTR;
extern volatile B_ACQ_GCBSTR _B_ACQ_GCB @(REG_BASE + 0x00000263UL);
#define B_ACQ_GCB                       _B_ACQ_GCB.Byte
#define B_ACQ_GCB_Dlo                   _B_ACQ_GCB.Bits.Dlo
#define B_ACQ_GCB_Dhi                   _B_ACQ_GCB.Bits.Dhi

#define B_ACQ_GCB_Dlo_MASK              15U
#define B_ACQ_GCB_Dlo_BITNUM            0U
#define B_ACQ_GCB_Dhi_MASK              240U
#define B_ACQ_GCB_Dhi_BITNUM            4U


/*** B_ACQ_ITEMP - Internal temperature measurement result; 0x00000264 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ACQ_ITEMPH - Internal temperature measurement result high; 0x00000264 ***/
    union {
      byte Byte;
    } B_ACQ_ITEMPHSTR;
    #define B_ACQ_ITEMPH                _B_ACQ_ITEMP.Overlap_STR.B_ACQ_ITEMPHSTR.Byte
    

    /*** B_ACQ_ITEMPL - Internal temperature measurement result low; 0x00000265 ***/
    union {
      byte Byte;
    } B_ACQ_ITEMPLSTR;
    #define B_ACQ_ITEMPL                _B_ACQ_ITEMP.Overlap_STR.B_ACQ_ITEMPLSTR.Byte
    
  } Overlap_STR;

} B_ACQ_ITEMPSTR;
extern volatile B_ACQ_ITEMPSTR _B_ACQ_ITEMP @(REG_BASE + 0x00000264UL);
#define B_ACQ_ITEMP                     _B_ACQ_ITEMP.Word


/*** B_ACQ_ETEMP - External temperature measurement result; 0x00000266 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ACQ_ETEMPH - External temperature measurement result high; 0x00000266 ***/
    union {
      byte Byte;
    } B_ACQ_ETEMPHSTR;
    #define B_ACQ_ETEMPH                _B_ACQ_ETEMP.Overlap_STR.B_ACQ_ETEMPHSTR.Byte
    

    /*** B_ACQ_ETEMPL - External temperature measurement result low; 0x00000267 ***/
    union {
      byte Byte;
    } B_ACQ_ETEMPLSTR;
    #define B_ACQ_ETEMPL                _B_ACQ_ETEMP.Overlap_STR.B_ACQ_ETEMPLSTR.Byte
    
  } Overlap_STR;

} B_ACQ_ETEMPSTR;
extern volatile B_ACQ_ETEMPSTR _B_ACQ_ETEMP @(REG_BASE + 0x00000266UL);
#define B_ACQ_ETEMP                     _B_ACQ_ETEMP.Word


/*** B_ACQ_CURR1 - Current measurement result 16Bit; 0x00000268 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    byte _Reserved_1[1];
    /*** B_ACQ_CURR1L - Current measurement result 8Bit; 0x00000269 ***/
    union {
      byte Byte;
    } B_ACQ_CURR1LSTR;
    #define B_ACQ_CURR1L                _B_ACQ_CURR1.Overlap_STR.B_ACQ_CURR1LSTR.Byte
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word CURR        :8;                                       /* Two's complement 24 Bit signed integer result register for the current measurement channel */
  } Bits;
} B_ACQ_CURR1STR;
extern volatile B_ACQ_CURR1STR _B_ACQ_CURR1 @(REG_BASE + 0x00000268UL);
#define B_ACQ_CURR1                     _B_ACQ_CURR1.Word
#define B_ACQ_CURR1_CURR                _B_ACQ_CURR1.Bits.CURR

#define B_ACQ_CURR1_CURR_MASK           65280U
#define B_ACQ_CURR1_CURR_BITNUM         8U


/*** B_ACQ_CURR0 - Current measurement result; 0x0000026A ***/
typedef union {
  word Word;
} B_ACQ_CURR0STR;
extern volatile B_ACQ_CURR0STR _B_ACQ_CURR0 @(REG_BASE + 0x0000026AUL);
#define B_ACQ_CURR0                     _B_ACQ_CURR0.Word


/*** B_ACQ_VOLT - Voltage measurement result; 0x0000026C ***/
typedef union {
  word Word;
} B_ACQ_VOLTSTR;
extern volatile B_ACQ_VOLTSTR _B_ACQ_VOLT @(REG_BASE + 0x0000026CUL);
#define B_ACQ_VOLT                      _B_ACQ_VOLT.Word


/*** B_ACQ_LPFC - Low pass filter coefficient number; 0x0000026E ***/
typedef union {
  byte Byte;
  struct {
    byte LPFC        :4;                                       /* Low Pass Filter Coefficient Number */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_ACQ_LPFCSTR;
extern volatile B_ACQ_LPFCSTR _B_ACQ_LPFC @(REG_BASE + 0x0000026EUL);
#define B_ACQ_LPFC                      _B_ACQ_LPFC.Byte
#define B_ACQ_LPFC_LPFC                 _B_ACQ_LPFC.Bits.LPFC

#define B_ACQ_LPFC_LPFC_MASK            15U
#define B_ACQ_LPFC_LPFC_BITNUM          0U


/*** B_ACQ_TCMP - Low power trigger current measurement period; 0x00000270 ***/
typedef union {
  word Word;
} B_ACQ_TCMPSTR;
extern volatile B_ACQ_TCMPSTR _B_ACQ_TCMP @(REG_BASE + 0x00000270UL);
#define B_ACQ_TCMP                      _B_ACQ_TCMP.Word


/*** B_ACQ_THF - Low power current threshold filtering period; 0x00000272 ***/
typedef union {
  byte Byte;
} B_ACQ_THFSTR;
extern volatile B_ACQ_THFSTR _B_ACQ_THF @(REG_BASE + 0x00000272UL);
#define B_ACQ_THF                       _B_ACQ_THF.Byte


/*** B_ACQ_CVCR - I and V chopper control register; 0x00000274 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ACQ_CVCRH - I and V chopper control register high; 0x00000274 ***/
    union {
      byte Byte;
      struct {
        byte PGAFM       :1;                                       /* PGA fast mode enable - Mask */
        byte IIRCM       :3;                                       /* IIR Low Pass Filter Configuration - Mask */
        byte DBTM        :2;                                       /* Hold Time After Chopper Swap - Mask */
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_ACQ_CVCRHSTR;
    #define B_ACQ_CVCRH                 _B_ACQ_CVCR.Overlap_STR.B_ACQ_CVCRHSTR.Byte
    #define B_ACQ_CVCRH_PGAFM           _B_ACQ_CVCR.Overlap_STR.B_ACQ_CVCRHSTR.Bits.PGAFM
    #define B_ACQ_CVCRH_IIRCM           _B_ACQ_CVCR.Overlap_STR.B_ACQ_CVCRHSTR.Bits.IIRCM
    #define B_ACQ_CVCRH_DBTM            _B_ACQ_CVCR.Overlap_STR.B_ACQ_CVCRHSTR.Bits.DBTM
    
    #define B_ACQ_CVCRH_PGAFM_MASK      1U
    #define B_ACQ_CVCRH_IIRCM_MASK      14U
    #define B_ACQ_CVCRH_IIRCM_BITNUM    1U
    #define B_ACQ_CVCRH_DBTM_MASK       48U
    #define B_ACQ_CVCRH_DBTM_BITNUM     4U
    

    /*** B_ACQ_CVCRL - I and V chopper control register high low; 0x00000275 ***/
    union {
      byte Byte;
      struct {
        byte PGAF        :1;                                       /* PGA fast mode enable */
        byte IIRC        :3;                                       /* IIR Low Pass Filter Coefficient */
        byte DBT         :2;                                       /* Hold Time After Chopper Swap */
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_ACQ_CVCRLSTR;
    #define B_ACQ_CVCRL                 _B_ACQ_CVCR.Overlap_STR.B_ACQ_CVCRLSTR.Byte
    #define B_ACQ_CVCRL_PGAF            _B_ACQ_CVCR.Overlap_STR.B_ACQ_CVCRLSTR.Bits.PGAF
    #define B_ACQ_CVCRL_IIRC            _B_ACQ_CVCR.Overlap_STR.B_ACQ_CVCRLSTR.Bits.IIRC
    #define B_ACQ_CVCRL_DBT             _B_ACQ_CVCR.Overlap_STR.B_ACQ_CVCRLSTR.Bits.DBT
    
    #define B_ACQ_CVCRL_PGAF_MASK       1U
    #define B_ACQ_CVCRL_IIRC_MASK       14U
    #define B_ACQ_CVCRL_IIRC_BITNUM     1U
    #define B_ACQ_CVCRL_DBT_MASK        48U
    #define B_ACQ_CVCRL_DBT_BITNUM      4U
    
  } Overlap_STR;

  struct {
    word PGAF        :1;                                       /* PGA fast mode enable */
    word IIRC        :3;                                       /* IIR Low Pass Filter Coefficient */
    word DBT         :2;                                       /* Hold Time After Chopper Swap */
    word             :1; 
    word             :1; 
    word PGAFM       :1;                                       /* PGA fast mode enable - Mask */
    word IIRCM       :3;                                       /* IIR Low Pass Filter Configuration - Mask */
    word DBTM        :2;                                       /* Hold Time After Chopper Swap - Mask */
    word             :1; 
    word             :1; 
  } Bits;
} B_ACQ_CVCRSTR;
extern volatile B_ACQ_CVCRSTR _B_ACQ_CVCR @(REG_BASE + 0x00000274UL);
#define B_ACQ_CVCR                      _B_ACQ_CVCR.Word
#define B_ACQ_CVCR_PGAF                 _B_ACQ_CVCR.Bits.PGAF
#define B_ACQ_CVCR_IIRC                 _B_ACQ_CVCR.Bits.IIRC
#define B_ACQ_CVCR_DBT                  _B_ACQ_CVCR.Bits.DBT
#define B_ACQ_CVCR_PGAFM                _B_ACQ_CVCR.Bits.PGAFM
#define B_ACQ_CVCR_IIRCM                _B_ACQ_CVCR.Bits.IIRCM
#define B_ACQ_CVCR_DBTM                 _B_ACQ_CVCR.Bits.DBTM

#define B_ACQ_CVCR_PGAF_MASK            1U
#define B_ACQ_CVCR_IIRC_MASK            14U
#define B_ACQ_CVCR_IIRC_BITNUM          1U
#define B_ACQ_CVCR_DBT_MASK             48U
#define B_ACQ_CVCR_DBT_BITNUM           4U
#define B_ACQ_CVCR_PGAFM_MASK           256U
#define B_ACQ_CVCR_IIRCM_MASK           3584U
#define B_ACQ_CVCR_IIRCM_BITNUM         9U
#define B_ACQ_CVCR_DBTM_MASK            12288U
#define B_ACQ_CVCR_DBTM_BITNUM          12U


/*** B_ACQ_CTH - Low power current threshold; 0x00000276 ***/
typedef union {
  byte Byte;
} B_ACQ_CTHSTR;
extern volatile B_ACQ_CTHSTR _B_ACQ_CTH @(REG_BASE + 0x00000276UL);
#define B_ACQ_CTH                       _B_ACQ_CTH.Byte


/*** B_ACQ_AHTH - Low power Ah counter threshold; 0x00000278 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** B_ACQ_AHTH1 - Low power Ah counter threshold 1; 0x00000278 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** B_ACQ_AHTH1H - Low power Ah counter threshold 1 high; 0x00000278 ***/
        union {
          byte Byte;
          struct {
            byte AHTH        :7;                                       /* Low power Ah counter threshold 1 high */
            byte             :1; 
          } Bits;
        } B_ACQ_AHTH1HSTR;
        #define B_ACQ_AHTH1H            _B_ACQ_AHTH.Overlap_STR.B_ACQ_AHTH1STR.Overlap_STR.B_ACQ_AHTH1HSTR.Byte
        #define B_ACQ_AHTH1H_AHTH       _B_ACQ_AHTH.Overlap_STR.B_ACQ_AHTH1STR.Overlap_STR.B_ACQ_AHTH1HSTR.Bits.AHTH
        
        #define B_ACQ_AHTH1H_AHTH_MASK  127U
        #define B_ACQ_AHTH1H_AHTH_BITNUM 0U
        
    
        /*** B_ACQ_AHTH1L - Low power Ah counter threshold 1 low; 0x00000279 ***/
        union {
          byte Byte;
        } B_ACQ_AHTH1LSTR;
        #define B_ACQ_AHTH1L            _B_ACQ_AHTH.Overlap_STR.B_ACQ_AHTH1STR.Overlap_STR.B_ACQ_AHTH1LSTR.Byte
        
      } Overlap_STR;
    
      struct {
        word AHTH        :15;                                      /* Low power Ah counter threshold 1 */
        word             :1; 
      } Bits;
    } B_ACQ_AHTH1STR;
    #define B_ACQ_AHTH1                 _B_ACQ_AHTH.Overlap_STR.B_ACQ_AHTH1STR.Word
    #define B_ACQ_AHTH1_AHTH            _B_ACQ_AHTH.Overlap_STR.B_ACQ_AHTH1STR.Bits.AHTH
    
    #define B_ACQ_AHTH1_AHTH_MASK       32767U
    #define B_ACQ_AHTH1_AHTH_BITNUM     0U
    

    /*** B_ACQ_AHTH0 - Low power Ah counter threshold 0; 0x0000027A ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** B_ACQ_AHTH0H - Low power Ah counter threshold 0 high; 0x0000027A ***/
        union {
          byte Byte;
        } B_ACQ_AHTH0HSTR;
        #define B_ACQ_AHTH0H            _B_ACQ_AHTH.Overlap_STR.B_ACQ_AHTH0STR.Overlap_STR.B_ACQ_AHTH0HSTR.Byte
        
    
        /*** B_ACQ_AHTH0L - Low power Ah counter threshold 0 low; 0x0000027B ***/
        union {
          byte Byte;
        } B_ACQ_AHTH0LSTR;
        #define B_ACQ_AHTH0L            _B_ACQ_AHTH.Overlap_STR.B_ACQ_AHTH0STR.Overlap_STR.B_ACQ_AHTH0LSTR.Byte
        
      } Overlap_STR;
    
    } B_ACQ_AHTH0STR;
    #define B_ACQ_AHTH0                 _B_ACQ_AHTH.Overlap_STR.B_ACQ_AHTH0STR.Word
    
  } Overlap_STR;

} B_ACQ_AHTHSTR;
extern volatile B_ACQ_AHTHSTR _B_ACQ_AHTH @(REG_BASE + 0x00000278UL);
#define B_ACQ_AHTH                      _B_ACQ_AHTH.Dword


/*** B_ACQ_AHC - Low power Ah counter; 0x0000027C ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** B_ACQ_AHC1 - Low power Ah counter 1; 0x0000027C ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** B_ACQ_AHC1H - Low power Ah counter 1 high; 0x0000027C ***/
        union {
          byte Byte;
        } B_ACQ_AHC1HSTR;
        #define B_ACQ_AHC1H             _B_ACQ_AHC.Overlap_STR.B_ACQ_AHC1STR.Overlap_STR.B_ACQ_AHC1HSTR.Byte
        
    
        /*** B_ACQ_AHC1L - Low power Ah counter 1 low; 0x0000027D ***/
        union {
          byte Byte;
        } B_ACQ_AHC1LSTR;
        #define B_ACQ_AHC1L             _B_ACQ_AHC.Overlap_STR.B_ACQ_AHC1STR.Overlap_STR.B_ACQ_AHC1LSTR.Byte
        
      } Overlap_STR;
    
    } B_ACQ_AHC1STR;
    #define B_ACQ_AHC1                  _B_ACQ_AHC.Overlap_STR.B_ACQ_AHC1STR.Word
    

    /*** B_ACQ_AHC0 - Low power Ah counter 0; 0x0000027E ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** B_ACQ_AHC0H - Low power Ah counter 0 high; 0x0000027E ***/
        union {
          byte Byte;
        } B_ACQ_AHC0HSTR;
        #define B_ACQ_AHC0H             _B_ACQ_AHC.Overlap_STR.B_ACQ_AHC0STR.Overlap_STR.B_ACQ_AHC0HSTR.Byte
        
    
        /*** B_ACQ_AHC0L - Low power Ah counter 0 low; 0x0000027F ***/
        union {
          byte Byte;
        } B_ACQ_AHC0LSTR;
        #define B_ACQ_AHC0L             _B_ACQ_AHC.Overlap_STR.B_ACQ_AHC0STR.Overlap_STR.B_ACQ_AHC0LSTR.Byte
        
      } Overlap_STR;
    
    } B_ACQ_AHC0STR;
    #define B_ACQ_AHC0                  _B_ACQ_AHC.Overlap_STR.B_ACQ_AHC0STR.Word
    
  } Overlap_STR;

} B_ACQ_AHCSTR;
extern volatile B_ACQ_AHCSTR _B_ACQ_AHC @(REG_BASE + 0x0000027CUL);
#define B_ACQ_AHC                       _B_ACQ_AHC.Dword


/*** B_LPF_A0 - Low Pass Filter Coefficient A0; 0x00000280 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A0H - Low Pass Filter Coefficient A0 high; 0x00000280 ***/
    union {
      byte Byte;
    } B_LPF_A0HSTR;
    #define B_LPF_A0H                   _B_LPF_A0.Overlap_STR.B_LPF_A0HSTR.Byte
    

    /*** B_LPF_A0L - Low Pass Filter Coefficient A0 low; 0x00000281 ***/
    union {
      byte Byte;
    } B_LPF_A0LSTR;
    #define B_LPF_A0L                   _B_LPF_A0.Overlap_STR.B_LPF_A0LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A0STR;
extern volatile B_LPF_A0STR _B_LPF_A0 @(REG_BASE + 0x00000280UL);
#define B_LPF_A0                        _B_LPF_A0.Word
/* B_LPF_A_ARR: Access 16 B_LPF_Ax registers in an array */
#define B_LPF_A_ARR                     ((volatile word *) &B_LPF_A0)


/*** B_LPF_A1 - Low Pass Filter Coefficient A1; 0x00000282 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A1H - Low Pass Filter Coefficient A1 high; 0x00000282 ***/
    union {
      byte Byte;
    } B_LPF_A1HSTR;
    #define B_LPF_A1H                   _B_LPF_A1.Overlap_STR.B_LPF_A1HSTR.Byte
    

    /*** B_LPF_A1L - Low Pass Filter Coefficient A1 low; 0x00000283 ***/
    union {
      byte Byte;
    } B_LPF_A1LSTR;
    #define B_LPF_A1L                   _B_LPF_A1.Overlap_STR.B_LPF_A1LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A1STR;
extern volatile B_LPF_A1STR _B_LPF_A1 @(REG_BASE + 0x00000282UL);
#define B_LPF_A1                        _B_LPF_A1.Word


/*** B_LPF_A2 - Low Pass Filter Coefficient A2; 0x00000284 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A2H - Low Pass Filter Coefficient A2 high; 0x00000284 ***/
    union {
      byte Byte;
    } B_LPF_A2HSTR;
    #define B_LPF_A2H                   _B_LPF_A2.Overlap_STR.B_LPF_A2HSTR.Byte
    

    /*** B_LPF_A2L - Low Pass Filter Coefficient A2 low; 0x00000285 ***/
    union {
      byte Byte;
    } B_LPF_A2LSTR;
    #define B_LPF_A2L                   _B_LPF_A2.Overlap_STR.B_LPF_A2LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A2STR;
extern volatile B_LPF_A2STR _B_LPF_A2 @(REG_BASE + 0x00000284UL);
#define B_LPF_A2                        _B_LPF_A2.Word


/*** B_LPF_A3 - Low Pass Filter Coefficient A3; 0x00000286 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A3H - Low Pass Filter Coefficient A3 high; 0x00000286 ***/
    union {
      byte Byte;
    } B_LPF_A3HSTR;
    #define B_LPF_A3H                   _B_LPF_A3.Overlap_STR.B_LPF_A3HSTR.Byte
    

    /*** B_LPF_A3L - Low Pass Filter Coefficient A3 low; 0x00000287 ***/
    union {
      byte Byte;
    } B_LPF_A3LSTR;
    #define B_LPF_A3L                   _B_LPF_A3.Overlap_STR.B_LPF_A3LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A3STR;
extern volatile B_LPF_A3STR _B_LPF_A3 @(REG_BASE + 0x00000286UL);
#define B_LPF_A3                        _B_LPF_A3.Word


/*** B_LPF_A4 - Low Pass Filter Coefficient A4; 0x00000288 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A4H - Low Pass Filter Coefficient A4 high; 0x00000288 ***/
    union {
      byte Byte;
    } B_LPF_A4HSTR;
    #define B_LPF_A4H                   _B_LPF_A4.Overlap_STR.B_LPF_A4HSTR.Byte
    

    /*** B_LPF_A4L - Low Pass Filter Coefficient A4 low; 0x00000289 ***/
    union {
      byte Byte;
    } B_LPF_A4LSTR;
    #define B_LPF_A4L                   _B_LPF_A4.Overlap_STR.B_LPF_A4LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A4STR;
extern volatile B_LPF_A4STR _B_LPF_A4 @(REG_BASE + 0x00000288UL);
#define B_LPF_A4                        _B_LPF_A4.Word


/*** B_LPF_A5 - Low Pass Filter Coefficient A5; 0x0000028A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A5H - Low Pass Filter Coefficient A5 high; 0x0000028A ***/
    union {
      byte Byte;
    } B_LPF_A5HSTR;
    #define B_LPF_A5H                   _B_LPF_A5.Overlap_STR.B_LPF_A5HSTR.Byte
    

    /*** B_LPF_A5L - Low Pass Filter Coefficient A5 low; 0x0000028B ***/
    union {
      byte Byte;
    } B_LPF_A5LSTR;
    #define B_LPF_A5L                   _B_LPF_A5.Overlap_STR.B_LPF_A5LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A5STR;
extern volatile B_LPF_A5STR _B_LPF_A5 @(REG_BASE + 0x0000028AUL);
#define B_LPF_A5                        _B_LPF_A5.Word


/*** B_LPF_A6 - Low Pass Filter Coefficient A6; 0x0000028C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A6H - Low Pass Filter Coefficient A6 high; 0x0000028C ***/
    union {
      byte Byte;
    } B_LPF_A6HSTR;
    #define B_LPF_A6H                   _B_LPF_A6.Overlap_STR.B_LPF_A6HSTR.Byte
    

    /*** B_LPF_A6L - Low Pass Filter Coefficient A6 low; 0x0000028D ***/
    union {
      byte Byte;
    } B_LPF_A6LSTR;
    #define B_LPF_A6L                   _B_LPF_A6.Overlap_STR.B_LPF_A6LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A6STR;
extern volatile B_LPF_A6STR _B_LPF_A6 @(REG_BASE + 0x0000028CUL);
#define B_LPF_A6                        _B_LPF_A6.Word


/*** B_LPF_A7 - Low Pass Filter Coefficient A7; 0x0000028E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A7H - Low Pass Filter Coefficient A7 high; 0x0000028E ***/
    union {
      byte Byte;
    } B_LPF_A7HSTR;
    #define B_LPF_A7H                   _B_LPF_A7.Overlap_STR.B_LPF_A7HSTR.Byte
    

    /*** B_LPF_A7L - Low Pass Filter Coefficient A7 low; 0x0000028F ***/
    union {
      byte Byte;
    } B_LPF_A7LSTR;
    #define B_LPF_A7L                   _B_LPF_A7.Overlap_STR.B_LPF_A7LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A7STR;
extern volatile B_LPF_A7STR _B_LPF_A7 @(REG_BASE + 0x0000028EUL);
#define B_LPF_A7                        _B_LPF_A7.Word


/*** B_LPF_A8 - Low Pass Filter Coefficient A8; 0x00000290 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A8H - Low Pass Filter Coefficient A8 high; 0x00000290 ***/
    union {
      byte Byte;
    } B_LPF_A8HSTR;
    #define B_LPF_A8H                   _B_LPF_A8.Overlap_STR.B_LPF_A8HSTR.Byte
    

    /*** B_LPF_A8L - Low Pass Filter Coefficient A8 low; 0x00000291 ***/
    union {
      byte Byte;
    } B_LPF_A8LSTR;
    #define B_LPF_A8L                   _B_LPF_A8.Overlap_STR.B_LPF_A8LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A8STR;
extern volatile B_LPF_A8STR _B_LPF_A8 @(REG_BASE + 0x00000290UL);
#define B_LPF_A8                        _B_LPF_A8.Word


/*** B_LPF_A9 - Low Pass Filter Coefficient A9; 0x00000292 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A9H - Low Pass Filter Coefficient A9 high; 0x00000292 ***/
    union {
      byte Byte;
    } B_LPF_A9HSTR;
    #define B_LPF_A9H                   _B_LPF_A9.Overlap_STR.B_LPF_A9HSTR.Byte
    

    /*** B_LPF_A9L - Low Pass Filter Coefficient A9 low; 0x00000293 ***/
    union {
      byte Byte;
    } B_LPF_A9LSTR;
    #define B_LPF_A9L                   _B_LPF_A9.Overlap_STR.B_LPF_A9LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A9STR;
extern volatile B_LPF_A9STR _B_LPF_A9 @(REG_BASE + 0x00000292UL);
#define B_LPF_A9                        _B_LPF_A9.Word


/*** B_LPF_A10 - Low Pass Filter Coefficient A10; 0x00000294 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A10H - Low Pass Filter Coefficient A10 high; 0x00000294 ***/
    union {
      byte Byte;
    } B_LPF_A10HSTR;
    #define B_LPF_A10H                  _B_LPF_A10.Overlap_STR.B_LPF_A10HSTR.Byte
    

    /*** B_LPF_A10L - Low Pass Filter Coefficient A10 low; 0x00000295 ***/
    union {
      byte Byte;
    } B_LPF_A10LSTR;
    #define B_LPF_A10L                  _B_LPF_A10.Overlap_STR.B_LPF_A10LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A10STR;
extern volatile B_LPF_A10STR _B_LPF_A10 @(REG_BASE + 0x00000294UL);
#define B_LPF_A10                       _B_LPF_A10.Word


/*** B_LPF_A11 - Low Pass Filter Coefficient A11; 0x00000296 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A11H - Low Pass Filter Coefficient A11 high; 0x00000296 ***/
    union {
      byte Byte;
    } B_LPF_A11HSTR;
    #define B_LPF_A11H                  _B_LPF_A11.Overlap_STR.B_LPF_A11HSTR.Byte
    

    /*** B_LPF_A11L - Low Pass Filter Coefficient A11 low; 0x00000297 ***/
    union {
      byte Byte;
    } B_LPF_A11LSTR;
    #define B_LPF_A11L                  _B_LPF_A11.Overlap_STR.B_LPF_A11LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A11STR;
extern volatile B_LPF_A11STR _B_LPF_A11 @(REG_BASE + 0x00000296UL);
#define B_LPF_A11                       _B_LPF_A11.Word


/*** B_LPF_A12 - Low Pass Filter Coefficient A12; 0x00000298 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A12H - Low Pass Filter Coefficient A12 high; 0x00000298 ***/
    union {
      byte Byte;
    } B_LPF_A12HSTR;
    #define B_LPF_A12H                  _B_LPF_A12.Overlap_STR.B_LPF_A12HSTR.Byte
    

    /*** B_LPF_A12L - Low Pass Filter Coefficient A12 low; 0x00000299 ***/
    union {
      byte Byte;
    } B_LPF_A12LSTR;
    #define B_LPF_A12L                  _B_LPF_A12.Overlap_STR.B_LPF_A12LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A12STR;
extern volatile B_LPF_A12STR _B_LPF_A12 @(REG_BASE + 0x00000298UL);
#define B_LPF_A12                       _B_LPF_A12.Word


/*** B_LPF_A13 - Low Pass Filter Coefficient A13; 0x0000029A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A13H - Low Pass Filter Coefficient A13 high; 0x0000029A ***/
    union {
      byte Byte;
    } B_LPF_A13HSTR;
    #define B_LPF_A13H                  _B_LPF_A13.Overlap_STR.B_LPF_A13HSTR.Byte
    

    /*** B_LPF_A13L - Low Pass Filter Coefficient A13 low; 0x0000029B ***/
    union {
      byte Byte;
    } B_LPF_A13LSTR;
    #define B_LPF_A13L                  _B_LPF_A13.Overlap_STR.B_LPF_A13LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A13STR;
extern volatile B_LPF_A13STR _B_LPF_A13 @(REG_BASE + 0x0000029AUL);
#define B_LPF_A13                       _B_LPF_A13.Word


/*** B_LPF_A14 - Low Pass Filter Coefficient A14; 0x0000029C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A14H - Low Pass Filter Coefficient A14 high; 0x0000029C ***/
    union {
      byte Byte;
    } B_LPF_A14HSTR;
    #define B_LPF_A14H                  _B_LPF_A14.Overlap_STR.B_LPF_A14HSTR.Byte
    

    /*** B_LPF_A14L - Low Pass Filter Coefficient A14 low; 0x0000029D ***/
    union {
      byte Byte;
    } B_LPF_A14LSTR;
    #define B_LPF_A14L                  _B_LPF_A14.Overlap_STR.B_LPF_A14LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A14STR;
extern volatile B_LPF_A14STR _B_LPF_A14 @(REG_BASE + 0x0000029CUL);
#define B_LPF_A14                       _B_LPF_A14.Word


/*** B_LPF_A15 - Low Pass Filter Coefficient A15; 0x0000029E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_LPF_A15H - Low Pass Filter Coefficient A15 high; 0x0000029E ***/
    union {
      byte Byte;
    } B_LPF_A15HSTR;
    #define B_LPF_A15H                  _B_LPF_A15.Overlap_STR.B_LPF_A15HSTR.Byte
    

    /*** B_LPF_A15L - Low Pass Filter Coefficient A15 low; 0x0000029F ***/
    union {
      byte Byte;
    } B_LPF_A15LSTR;
    #define B_LPF_A15L                  _B_LPF_A15.Overlap_STR.B_LPF_A15LSTR.Byte
    
  } Overlap_STR;

} B_LPF_A15STR;
extern volatile B_LPF_A15STR _B_LPF_A15 @(REG_BASE + 0x0000029EUL);
#define B_LPF_A15                       _B_LPF_A15.Word


/*** B_COMP_CTL - Compensation control register; 0x000002A0 ***/
typedef union {
  word Word;
  struct {
    word CALIE       :1;                                       /* Calibration IRQ Enable */
    word             :1; 
    word DIAGI       :1;                                       /* Diagnostic Mode Current Channel */
    word DIAGV       :1;                                       /* Diagnostic Mode Voltage Channel */
    word PGAO        :1;                                       /* PGA Offset Calibration Start */
    word PGAZ        :1;                                       /* PGA Input Zero */
    word BGCAL       :2;                                       /* Calibration Band Gap Select */
    word CALIEM      :1;                                       /* Calibration IRQ Enable - Mask */
    word             :1; 
    word DIAGIM      :1;                                       /* Diagnostic Mode Current Channel - Mask */
    word DIAGVM      :1;                                       /* Diagnostic Mode Voltage Channel - Mask */
    word PGAOM       :1;                                       /* PGA Offset Calibration - Mask */
    word PGAZM       :1;                                       /* PGA Input Zero - Mask */
    word BGCALM      :2;                                       /* Calibration Band Gap Select - Mask */
  } Bits;
} B_COMP_CTLSTR;
extern volatile B_COMP_CTLSTR _B_COMP_CTL @(REG_BASE + 0x000002A0UL);
#define B_COMP_CTL                      _B_COMP_CTL.Word
#define B_COMP_CTL_CALIE                _B_COMP_CTL.Bits.CALIE
#define B_COMP_CTL_DIAGI                _B_COMP_CTL.Bits.DIAGI
#define B_COMP_CTL_DIAGV                _B_COMP_CTL.Bits.DIAGV
#define B_COMP_CTL_PGAO                 _B_COMP_CTL.Bits.PGAO
#define B_COMP_CTL_PGAZ                 _B_COMP_CTL.Bits.PGAZ
#define B_COMP_CTL_BGCAL                _B_COMP_CTL.Bits.BGCAL
#define B_COMP_CTL_CALIEM               _B_COMP_CTL.Bits.CALIEM
#define B_COMP_CTL_DIAGIM               _B_COMP_CTL.Bits.DIAGIM
#define B_COMP_CTL_DIAGVM               _B_COMP_CTL.Bits.DIAGVM
#define B_COMP_CTL_PGAOM                _B_COMP_CTL.Bits.PGAOM
#define B_COMP_CTL_PGAZM                _B_COMP_CTL.Bits.PGAZM
#define B_COMP_CTL_BGCALM               _B_COMP_CTL.Bits.BGCALM

#define B_COMP_CTL_CALIE_MASK           1U
#define B_COMP_CTL_DIAGI_MASK           4U
#define B_COMP_CTL_DIAGV_MASK           8U
#define B_COMP_CTL_PGAO_MASK            16U
#define B_COMP_CTL_PGAZ_MASK            32U
#define B_COMP_CTL_BGCAL_MASK           192U
#define B_COMP_CTL_BGCAL_BITNUM         6U
#define B_COMP_CTL_CALIEM_MASK          256U
#define B_COMP_CTL_DIAGIM_MASK          1024U
#define B_COMP_CTL_DIAGVM_MASK          2048U
#define B_COMP_CTL_PGAOM_MASK           4096U
#define B_COMP_CTL_PGAZM_MASK           8192U
#define B_COMP_CTL_BGCALM_MASK          49152U
#define B_COMP_CTL_BGCALM_BITNUM        14U


/*** B_COMP_SR - Compensation status register; 0x000002A2 ***/
typedef union {
  byte Byte;
  struct {
    byte CALF        :1;                                       /* Calibration Request Status Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PGAOF       :1;                                       /* PGA Internal Offset Compensation Complete Flag */
    byte             :1; 
    byte BGFR        :1;                                       /* Band Gap Reference Status Flag */
    byte             :1; 
  } Bits;
} B_COMP_SRSTR;
extern volatile B_COMP_SRSTR _B_COMP_SR @(REG_BASE + 0x000002A2UL);
#define B_COMP_SR                       _B_COMP_SR.Byte
#define B_COMP_SR_CALF                  _B_COMP_SR.Bits.CALF
#define B_COMP_SR_PGAOF                 _B_COMP_SR.Bits.PGAOF
#define B_COMP_SR_BGFR                  _B_COMP_SR.Bits.BGFR

#define B_COMP_SR_CALF_MASK             1U
#define B_COMP_SR_PGAOF_MASK            16U
#define B_COMP_SR_BGFR_MASK             64U


/*** B_COMP_TF - Temperature filtering period; 0x000002A3 ***/
typedef union {
  byte Byte;
  struct {
    byte TMF         :3;                                       /* Recalibration Temperature Filtering Period */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_COMP_TFSTR;
extern volatile B_COMP_TFSTR _B_COMP_TF @(REG_BASE + 0x000002A3UL);
#define B_COMP_TF                       _B_COMP_TF.Byte
#define B_COMP_TF_TMF                   _B_COMP_TF.Bits.TMF

#define B_COMP_TF_TMF_MASK              7U
#define B_COMP_TF_TMF_BITNUM            0U


/*** B_COMP_TMAX - Max temp before recalibration; 0x000002A4 ***/
typedef union {
  word Word;
} B_COMP_TMAXSTR;
extern volatile B_COMP_TMAXSTR _B_COMP_TMAX @(REG_BASE + 0x000002A4UL);
#define B_COMP_TMAX                     _B_COMP_TMAX.Word


/*** B_COMP_TMIN - Min temp before recalibration; 0x000002A6 ***/
typedef union {
  word Word;
} B_COMP_TMINSTR;
extern volatile B_COMP_TMINSTR _B_COMP_TMIN @(REG_BASE + 0x000002A6UL);
#define B_COMP_TMIN                     _B_COMP_TMIN.Word


/*** B_COMP_VO - Offset voltage compensation; 0x000002AA ***/
typedef union {
  byte Byte;
} B_COMP_VOSTR;
extern volatile B_COMP_VOSTR _B_COMP_VO @(REG_BASE + 0x000002AAUL);
#define B_COMP_VO                       _B_COMP_VO.Byte


/*** B_COMP_IO - Offset current compensation window; 0x000002AB ***/
typedef union {
  byte Byte;
} B_COMP_IOSTR;
extern volatile B_COMP_IOSTR _B_COMP_IO @(REG_BASE + 0x000002ABUL);
#define B_COMP_IO                       _B_COMP_IO.Byte


/*** B_COMP_VSG - Gain voltage compensation vsense channel; 0x000002AC ***/
typedef union {
  word Word;
  struct {
    word VSGC        :10;                                      /* Voltage Channel Gain Compensation Buffer */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_VSGSTR;
extern volatile B_COMP_VSGSTR _B_COMP_VSG @(REG_BASE + 0x000002ACUL);
#define B_COMP_VSG                      _B_COMP_VSG.Word
#define B_COMP_VSG_VSGC                 _B_COMP_VSG.Bits.VSGC

#define B_COMP_VSG_VSGC_MASK            1023U
#define B_COMP_VSG_VSGC_BITNUM          0U


/*** B_COMP_IG4 - Gain Current Compensation 4; 0x000002B0 ***/
typedef union {
  word Word;
  struct {
    word IGC4        :10;                                      /* Current Gain Compensation Buffer 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_IG4STR;
extern volatile B_COMP_IG4STR _B_COMP_IG4 @(REG_BASE + 0x000002B0UL);
#define B_COMP_IG4                      _B_COMP_IG4.Word
#define B_COMP_IG4_IGC4                 _B_COMP_IG4.Bits.IGC4

#define B_COMP_IG4_IGC4_MASK            1023U
#define B_COMP_IG4_IGC4_BITNUM          0U


/*** B_COMP_IG8 - Gain Current Compensation 8; 0x000002B2 ***/
typedef union {
  word Word;
  struct {
    word IGC8        :10;                                      /* Current Gain Compensation Buffer 8 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_IG8STR;
extern volatile B_COMP_IG8STR _B_COMP_IG8 @(REG_BASE + 0x000002B2UL);
#define B_COMP_IG8                      _B_COMP_IG8.Word
#define B_COMP_IG8_IGC8                 _B_COMP_IG8.Bits.IGC8

#define B_COMP_IG8_IGC8_MASK            1023U
#define B_COMP_IG8_IGC8_BITNUM          0U


/*** B_COMP_IG16 - Gain Current Compensation 16; 0x000002B4 ***/
typedef union {
  word Word;
  struct {
    word IGC16       :10;                                      /* Current Gain Compensation Buffer 16 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_IG16STR;
extern volatile B_COMP_IG16STR _B_COMP_IG16 @(REG_BASE + 0x000002B4UL);
#define B_COMP_IG16                     _B_COMP_IG16.Word
#define B_COMP_IG16_IGC16               _B_COMP_IG16.Bits.IGC16

#define B_COMP_IG16_IGC16_MASK          1023U
#define B_COMP_IG16_IGC16_BITNUM        0U


/*** B_COMP_IG32 - Gain Current Compensation 32; 0x000002B6 ***/
typedef union {
  word Word;
  struct {
    word IGC32       :10;                                      /* Current Gain Compensation Buffer 32 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_IG32STR;
extern volatile B_COMP_IG32STR _B_COMP_IG32 @(REG_BASE + 0x000002B6UL);
#define B_COMP_IG32                     _B_COMP_IG32.Word
#define B_COMP_IG32_IGC32               _B_COMP_IG32.Bits.IGC32

#define B_COMP_IG32_IGC32_MASK          1023U
#define B_COMP_IG32_IGC32_BITNUM        0U


/*** B_COMP_IG64 - Gain Current Compensation 64; 0x000002B8 ***/
typedef union {
  word Word;
  struct {
    word IGC64       :10;                                      /* Current Gain Compensation Buffer 64 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_IG64STR;
extern volatile B_COMP_IG64STR _B_COMP_IG64 @(REG_BASE + 0x000002B8UL);
#define B_COMP_IG64                     _B_COMP_IG64.Word
#define B_COMP_IG64_IGC64               _B_COMP_IG64.Bits.IGC64

#define B_COMP_IG64_IGC64_MASK          1023U
#define B_COMP_IG64_IGC64_BITNUM        0U


/*** B_COMP_IG128 - Gain Current Compensation 128; 0x000002BA ***/
typedef union {
  word Word;
  struct {
    word IGC128      :10;                                      /* Current Gain Compensation Buffer 128 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_IG128STR;
extern volatile B_COMP_IG128STR _B_COMP_IG128 @(REG_BASE + 0x000002BAUL);
#define B_COMP_IG128                    _B_COMP_IG128.Word
#define B_COMP_IG128_IGC128             _B_COMP_IG128.Bits.IGC128

#define B_COMP_IG128_IGC128_MASK        1023U
#define B_COMP_IG128_IGC128_BITNUM      0U


/*** B_COMP_IG256 - Gain Current Compensation 256; 0x000002BC ***/
typedef union {
  word Word;
  struct {
    word IGC256      :10;                                      /* Current Gain Compensation Buffer 256 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_IG256STR;
extern volatile B_COMP_IG256STR _B_COMP_IG256 @(REG_BASE + 0x000002BCUL);
#define B_COMP_IG256                    _B_COMP_IG256.Word
#define B_COMP_IG256_IGC256             _B_COMP_IG256.Bits.IGC256

#define B_COMP_IG256_IGC256_MASK        1023U
#define B_COMP_IG256_IGC256_BITNUM      0U


/*** B_COMP_IG512 - Gain Current Compensation 512; 0x000002BE ***/
typedef union {
  word Word;
  struct {
    word IGC512      :10;                                      /* Current Gain Compensation Buffer 512 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_IG512STR;
extern volatile B_COMP_IG512STR _B_COMP_IG512 @(REG_BASE + 0x000002BEUL);
#define B_COMP_IG512                    _B_COMP_IG512.Word
#define B_COMP_IG512_IGC512             _B_COMP_IG512.Bits.IGC512

#define B_COMP_IG512_IGC512_MASK        1023U
#define B_COMP_IG512_IGC512_BITNUM      0U


/*** B_COMP_PGAO4 - Offset PGA compensation 4; 0x000002C0 ***/
typedef union {
  word Word;
  struct {
    word PGAOC4      :11;                                      /* PGA Offset Compensation Buffer 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_PGAO4STR;
extern volatile B_COMP_PGAO4STR _B_COMP_PGAO4 @(REG_BASE + 0x000002C0UL);
#define B_COMP_PGAO4                    _B_COMP_PGAO4.Word
#define B_COMP_PGAO4_PGAOC4             _B_COMP_PGAO4.Bits.PGAOC4

#define B_COMP_PGAO4_PGAOC4_MASK        2047U
#define B_COMP_PGAO4_PGAOC4_BITNUM      0U


/*** B_COMP_PGAO8 - Offset PGA compensation 8; 0x000002C2 ***/
typedef union {
  word Word;
  struct {
    word PGAOC8      :11;                                      /* PGA Offset Compensation Buffer 8 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_PGAO8STR;
extern volatile B_COMP_PGAO8STR _B_COMP_PGAO8 @(REG_BASE + 0x000002C2UL);
#define B_COMP_PGAO8                    _B_COMP_PGAO8.Word
#define B_COMP_PGAO8_PGAOC8             _B_COMP_PGAO8.Bits.PGAOC8

#define B_COMP_PGAO8_PGAOC8_MASK        2047U
#define B_COMP_PGAO8_PGAOC8_BITNUM      0U


/*** B_COMP_PGAO16 - Offset PGA compensation 16; 0x000002C4 ***/
typedef union {
  word Word;
  struct {
    word PGAOC16     :11;                                      /* PGA Offset Compensation Buffer 16 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_PGAO16STR;
extern volatile B_COMP_PGAO16STR _B_COMP_PGAO16 @(REG_BASE + 0x000002C4UL);
#define B_COMP_PGAO16                   _B_COMP_PGAO16.Word
#define B_COMP_PGAO16_PGAOC16           _B_COMP_PGAO16.Bits.PGAOC16

#define B_COMP_PGAO16_PGAOC16_MASK      2047U
#define B_COMP_PGAO16_PGAOC16_BITNUM    0U


/*** B_COMP_PGAO32 - Offset PGA compensation 32; 0x000002C6 ***/
typedef union {
  word Word;
  struct {
    word PGAOC32     :11;                                      /* PGA Offset Compensation Buffer 32 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_PGAO32STR;
extern volatile B_COMP_PGAO32STR _B_COMP_PGAO32 @(REG_BASE + 0x000002C6UL);
#define B_COMP_PGAO32                   _B_COMP_PGAO32.Word
#define B_COMP_PGAO32_PGAOC32           _B_COMP_PGAO32.Bits.PGAOC32

#define B_COMP_PGAO32_PGAOC32_MASK      2047U
#define B_COMP_PGAO32_PGAOC32_BITNUM    0U


/*** B_COMP_PGAO64 - Offset PGA compensation 64; 0x000002C8 ***/
typedef union {
  word Word;
  struct {
    word PGAOC64     :11;                                      /* PGA Offset Compensation Buffer 64 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_PGAO64STR;
extern volatile B_COMP_PGAO64STR _B_COMP_PGAO64 @(REG_BASE + 0x000002C8UL);
#define B_COMP_PGAO64                   _B_COMP_PGAO64.Word
#define B_COMP_PGAO64_PGAOC64           _B_COMP_PGAO64.Bits.PGAOC64

#define B_COMP_PGAO64_PGAOC64_MASK      2047U
#define B_COMP_PGAO64_PGAOC64_BITNUM    0U


/*** B_COMP_PGAO128 - Offset PGA compensation 128; 0x000002CA ***/
typedef union {
  word Word;
  struct {
    word PGAOC128    :11;                                      /* PGA Offset Compensation Buffer 128 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_PGAO128STR;
extern volatile B_COMP_PGAO128STR _B_COMP_PGAO128 @(REG_BASE + 0x000002CAUL);
#define B_COMP_PGAO128                  _B_COMP_PGAO128.Word
#define B_COMP_PGAO128_PGAOC128         _B_COMP_PGAO128.Bits.PGAOC128

#define B_COMP_PGAO128_PGAOC128_MASK    2047U
#define B_COMP_PGAO128_PGAOC128_BITNUM  0U


/*** B_COMP_PGAO256 - Offset PGA compensation 256; 0x000002CC ***/
typedef union {
  word Word;
  struct {
    word PGAOC256    :11;                                      /* PGA Offset Compensation Buffer 256 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_PGAO256STR;
extern volatile B_COMP_PGAO256STR _B_COMP_PGAO256 @(REG_BASE + 0x000002CCUL);
#define B_COMP_PGAO256                  _B_COMP_PGAO256.Word
#define B_COMP_PGAO256_PGAOC256         _B_COMP_PGAO256.Bits.PGAOC256

#define B_COMP_PGAO256_PGAOC256_MASK    2047U
#define B_COMP_PGAO256_PGAOC256_BITNUM  0U


/*** B_COMP_PGAO512 - Offset PGA compensation 512; 0x000002CE ***/
typedef union {
  word Word;
  struct {
    word PGAOC512    :11;                                      /* PGA Offset Compensation Buffer 512 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_COMP_PGAO512STR;
extern volatile B_COMP_PGAO512STR _B_COMP_PGAO512 @(REG_BASE + 0x000002CEUL);
#define B_COMP_PGAO512                  _B_COMP_PGAO512.Word
#define B_COMP_PGAO512_PGAOC512         _B_COMP_PGAO512.Bits.PGAOC512

#define B_COMP_PGAO512_PGAOC512_MASK    2047U
#define B_COMP_PGAO512_PGAOC512_BITNUM  0U


/*** B_COMP_ITO - Internal temperature offset compensation; 0x000002D0 ***/
typedef union {
  byte Byte;
} B_COMP_ITOSTR;
extern volatile B_COMP_ITOSTR _B_COMP_ITO @(REG_BASE + 0x000002D0UL);
#define B_COMP_ITO                      _B_COMP_ITO.Byte


/*** B_COMP_ITG - Internal temperature gain compensation; 0x000002D1 ***/
typedef union {
  byte Byte;
} B_COMP_ITGSTR;
extern volatile B_COMP_ITGSTR _B_COMP_ITG @(REG_BASE + 0x000002D1UL);
#define B_COMP_ITG                      _B_COMP_ITG.Byte


/*** B_COMP_ETO - External temperature offset compensation; 0x000002D2 ***/
typedef union {
  byte Byte;
} B_COMP_ETOSTR;
extern volatile B_COMP_ETOSTR _B_COMP_ETO @(REG_BASE + 0x000002D2UL);
#define B_COMP_ETO                      _B_COMP_ETO.Byte


/*** B_COMP_ETG - External temperature gain compensation; 0x000002D3 ***/
typedef union {
  byte Byte;
} B_COMP_ETGSTR;
extern volatile B_COMP_ETGSTR _B_COMP_ETG @(REG_BASE + 0x000002D3UL);
#define B_COMP_ETG                      _B_COMP_ETG.Byte


/*** B_TRIM_BG0 - Trim bandgap 0; 0x000002E0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TRIM_BG0H - Trim bandgap 0 high; 0x000002E0 ***/
    union {
      byte Byte;
      struct {
        byte TCIBG1      :3; 
        byte TCIBG2      :3; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_TRIM_BG0HSTR;
    #define B_TRIM_BG0H                 _B_TRIM_BG0.Overlap_STR.B_TRIM_BG0HSTR.Byte
    #define B_TRIM_BG0H_TCIBG1          _B_TRIM_BG0.Overlap_STR.B_TRIM_BG0HSTR.Bits.TCIBG1
    #define B_TRIM_BG0H_TCIBG2          _B_TRIM_BG0.Overlap_STR.B_TRIM_BG0HSTR.Bits.TCIBG2
    
    #define B_TRIM_BG0H_TCIBG1_MASK     7U
    #define B_TRIM_BG0H_TCIBG1_BITNUM   0U
    #define B_TRIM_BG0H_TCIBG2_MASK     56U
    #define B_TRIM_BG0H_TCIBG2_BITNUM   3U
    

    /*** B_TRIM_BG0L - Trim bandgap 0 low; 0x000002E1 ***/
    union {
      byte Byte;
      struct {
        byte IBG1        :3; 
        byte IBG2        :3; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_TRIM_BG0LSTR;
    #define B_TRIM_BG0L                 _B_TRIM_BG0.Overlap_STR.B_TRIM_BG0LSTR.Byte
    #define B_TRIM_BG0L_IBG1            _B_TRIM_BG0.Overlap_STR.B_TRIM_BG0LSTR.Bits.IBG1
    #define B_TRIM_BG0L_IBG2            _B_TRIM_BG0.Overlap_STR.B_TRIM_BG0LSTR.Bits.IBG2
    
    #define B_TRIM_BG0L_IBG1_MASK       7U
    #define B_TRIM_BG0L_IBG1_BITNUM     0U
    #define B_TRIM_BG0L_IBG2_MASK       56U
    #define B_TRIM_BG0L_IBG2_BITNUM     3U
    
  } Overlap_STR;

  struct {
    word IBG1        :3; 
    word IBG2        :3; 
    word             :1; 
    word             :1; 
    word TCIBG1      :3; 
    word TCIBG2      :3; 
    word             :1; 
    word             :1; 
  } Bits;
} B_TRIM_BG0STR;
extern volatile B_TRIM_BG0STR _B_TRIM_BG0 @(REG_BASE + 0x000002E0UL);
#define B_TRIM_BG0                      _B_TRIM_BG0.Word
#define B_TRIM_BG0_IBG1                 _B_TRIM_BG0.Bits.IBG1
#define B_TRIM_BG0_IBG2                 _B_TRIM_BG0.Bits.IBG2
#define B_TRIM_BG0_TCIBG1               _B_TRIM_BG0.Bits.TCIBG1
#define B_TRIM_BG0_TCIBG2               _B_TRIM_BG0.Bits.TCIBG2
/* B_TRIM_BG_ARR: Access 3 B_TRIM_BGx registers in an array */
#define B_TRIM_BG_ARR                   ((volatile word *) &B_TRIM_BG0)

#define B_TRIM_BG0_IBG1_MASK            7U
#define B_TRIM_BG0_IBG1_BITNUM          0U
#define B_TRIM_BG0_IBG2_MASK            56U
#define B_TRIM_BG0_IBG2_BITNUM          3U
#define B_TRIM_BG0_TCIBG1_MASK          1792U
#define B_TRIM_BG0_TCIBG1_BITNUM        8U
#define B_TRIM_BG0_TCIBG2_MASK          14336U
#define B_TRIM_BG0_TCIBG2_BITNUM        11U


/*** B_TRIM_BG1 - Trim bandgap 1; 0x000002E2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TRIM_BG1H - Trim bandgap 1 high; 0x000002E2 ***/
    union {
      byte Byte;
      struct {
        byte TCBG1       :3; 
        byte TCBG2       :3; 
        byte DBG3        :1; 
        byte UBG3        :1; 
      } Bits;
    } B_TRIM_BG1HSTR;
    #define B_TRIM_BG1H                 _B_TRIM_BG1.Overlap_STR.B_TRIM_BG1HSTR.Byte
    #define B_TRIM_BG1H_TCBG1           _B_TRIM_BG1.Overlap_STR.B_TRIM_BG1HSTR.Bits.TCBG1
    #define B_TRIM_BG1H_TCBG2           _B_TRIM_BG1.Overlap_STR.B_TRIM_BG1HSTR.Bits.TCBG2
    #define B_TRIM_BG1H_DBG3            _B_TRIM_BG1.Overlap_STR.B_TRIM_BG1HSTR.Bits.DBG3
    #define B_TRIM_BG1H_UBG3            _B_TRIM_BG1.Overlap_STR.B_TRIM_BG1HSTR.Bits.UBG3
    
    #define B_TRIM_BG1H_TCBG1_MASK      7U
    #define B_TRIM_BG1H_TCBG1_BITNUM    0U
    #define B_TRIM_BG1H_TCBG2_MASK      56U
    #define B_TRIM_BG1H_TCBG2_BITNUM    3U
    #define B_TRIM_BG1H_DBG3_MASK       64U
    #define B_TRIM_BG1H_UBG3_MASK       128U
    

    /*** B_TRIM_BG1L - Trim bandgap 1 low; 0x000002E3 ***/
    union {
      byte Byte;
      struct {
        byte SLPBG       :3; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_TRIM_BG1LSTR;
    #define B_TRIM_BG1L                 _B_TRIM_BG1.Overlap_STR.B_TRIM_BG1LSTR.Byte
    #define B_TRIM_BG1L_SLPBG           _B_TRIM_BG1.Overlap_STR.B_TRIM_BG1LSTR.Bits.SLPBG
    
    #define B_TRIM_BG1L_SLPBG_MASK      7U
    #define B_TRIM_BG1L_SLPBG_BITNUM    0U
    
  } Overlap_STR;

  struct {
    word SLPBG       :3; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word TCBG1       :3; 
    word TCBG2       :3; 
    word DBG3        :1; 
    word UBG3        :1; 
  } Bits;
} B_TRIM_BG1STR;
extern volatile B_TRIM_BG1STR _B_TRIM_BG1 @(REG_BASE + 0x000002E2UL);
#define B_TRIM_BG1                      _B_TRIM_BG1.Word
#define B_TRIM_BG1_SLPBG                _B_TRIM_BG1.Bits.SLPBG
#define B_TRIM_BG1_TCBG1                _B_TRIM_BG1.Bits.TCBG1
#define B_TRIM_BG1_TCBG2                _B_TRIM_BG1.Bits.TCBG2
#define B_TRIM_BG1_DBG3                 _B_TRIM_BG1.Bits.DBG3
#define B_TRIM_BG1_UBG3                 _B_TRIM_BG1.Bits.UBG3

#define B_TRIM_BG1_SLPBG_MASK           7U
#define B_TRIM_BG1_SLPBG_BITNUM         0U
#define B_TRIM_BG1_TCBG1_MASK           1792U
#define B_TRIM_BG1_TCBG1_BITNUM         8U
#define B_TRIM_BG1_TCBG2_MASK           14336U
#define B_TRIM_BG1_TCBG2_BITNUM         11U
#define B_TRIM_BG1_DBG3_MASK            16384U
#define B_TRIM_BG1_UBG3_MASK            32768U


/*** B_TRIM_BG2 - Trim bandgap 2; 0x000002E4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TRIM_BG2H - Trim bandgap 2 high; 0x000002E4 ***/
    union {
      byte Byte;
      struct {
        byte V1P2BG1     :4; 
        byte V1P2BG2     :4; 
      } Bits;
    } B_TRIM_BG2HSTR;
    #define B_TRIM_BG2H                 _B_TRIM_BG2.Overlap_STR.B_TRIM_BG2HSTR.Byte
    #define B_TRIM_BG2H_V1P2BG1         _B_TRIM_BG2.Overlap_STR.B_TRIM_BG2HSTR.Bits.V1P2BG1
    #define B_TRIM_BG2H_V1P2BG2         _B_TRIM_BG2.Overlap_STR.B_TRIM_BG2HSTR.Bits.V1P2BG2
    
    #define B_TRIM_BG2H_V1P2BG1_MASK    15U
    #define B_TRIM_BG2H_V1P2BG1_BITNUM  0U
    #define B_TRIM_BG2H_V1P2BG2_MASK    240U
    #define B_TRIM_BG2H_V1P2BG2_BITNUM  4U
    

    /*** B_TRIM_BG2L - Trim bandgap 2 low; 0x000002E5 ***/
    union {
      byte Byte;
      struct {
        byte V2P5BG1     :4; 
        byte V2P5BG2     :4; 
      } Bits;
    } B_TRIM_BG2LSTR;
    #define B_TRIM_BG2L                 _B_TRIM_BG2.Overlap_STR.B_TRIM_BG2LSTR.Byte
    #define B_TRIM_BG2L_V2P5BG1         _B_TRIM_BG2.Overlap_STR.B_TRIM_BG2LSTR.Bits.V2P5BG1
    #define B_TRIM_BG2L_V2P5BG2         _B_TRIM_BG2.Overlap_STR.B_TRIM_BG2LSTR.Bits.V2P5BG2
    
    #define B_TRIM_BG2L_V2P5BG1_MASK    15U
    #define B_TRIM_BG2L_V2P5BG1_BITNUM  0U
    #define B_TRIM_BG2L_V2P5BG2_MASK    240U
    #define B_TRIM_BG2L_V2P5BG2_BITNUM  4U
    
  } Overlap_STR;

  struct {
    word V2P5BG1     :4; 
    word V2P5BG2     :4; 
    word V1P2BG1     :4; 
    word V1P2BG2     :4; 
  } Bits;
} B_TRIM_BG2STR;
extern volatile B_TRIM_BG2STR _B_TRIM_BG2 @(REG_BASE + 0x000002E4UL);
#define B_TRIM_BG2                      _B_TRIM_BG2.Word
#define B_TRIM_BG2_V2P5BG1              _B_TRIM_BG2.Bits.V2P5BG1
#define B_TRIM_BG2_V2P5BG2              _B_TRIM_BG2.Bits.V2P5BG2
#define B_TRIM_BG2_V1P2BG1              _B_TRIM_BG2.Bits.V1P2BG1
#define B_TRIM_BG2_V1P2BG2              _B_TRIM_BG2.Bits.V1P2BG2

#define B_TRIM_BG2_V2P5BG1_MASK         15U
#define B_TRIM_BG2_V2P5BG1_BITNUM       0U
#define B_TRIM_BG2_V2P5BG2_MASK         240U
#define B_TRIM_BG2_V2P5BG2_BITNUM       4U
#define B_TRIM_BG2_V1P2BG1_MASK         3840U
#define B_TRIM_BG2_V1P2BG1_BITNUM       8U
#define B_TRIM_BG2_V1P2BG2_MASK         61440U
#define B_TRIM_BG2_V1P2BG2_BITNUM       12U


/*** B_TRIM_LIN - Trim lin; 0x000002E6 ***/
typedef union {
  byte Byte;
  struct {
    byte LIN         :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_TRIM_LINSTR;
extern volatile B_TRIM_LINSTR _B_TRIM_LIN @(REG_BASE + 0x000002E6UL);
#define B_TRIM_LIN                      _B_TRIM_LIN.Byte
#define B_TRIM_LIN_LIN                  _B_TRIM_LIN.Bits.LIN

#define B_TRIM_LIN_LIN_MASK             1U


/*** B_TRIM_LVT - Trim low voltage threshold; 0x000002E7 ***/
typedef union {
  byte Byte;
  struct {
    byte LVT         :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_TRIM_LVTSTR;
extern volatile B_TRIM_LVTSTR _B_TRIM_LVT @(REG_BASE + 0x000002E7UL);
#define B_TRIM_LVT                      _B_TRIM_LVT.Byte
#define B_TRIM_LVT_LVT                  _B_TRIM_LVT.Bits.LVT

#define B_TRIM_LVT_LVT_MASK             1U


/*** B_TRIM_OSC - Trim LP oscillator; 0x000002E8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TRIM_OSCH - Trim LP oscillator high; 0x000002E8 ***/
    union {
      byte Byte;
      struct {
        byte LPOSC       :5; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_TRIM_OSCHSTR;
    #define B_TRIM_OSCH                 _B_TRIM_OSC.Overlap_STR.B_TRIM_OSCHSTR.Byte
    #define B_TRIM_OSCH_LPOSC           _B_TRIM_OSC.Overlap_STR.B_TRIM_OSCHSTR.Bits.LPOSC
    
    #define B_TRIM_OSCH_LPOSC_MASK      31U
    #define B_TRIM_OSCH_LPOSC_BITNUM    0U
    

    /*** B_TRIM_OSCL - Trim LP oscillator low; 0x000002E9 ***/
    union {
      byte Byte;
    } B_TRIM_OSCLSTR;
    #define B_TRIM_OSCL                 _B_TRIM_OSC.Overlap_STR.B_TRIM_OSCLSTR.Byte
    
  } Overlap_STR;

  struct {
    word LPOSC       :13; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} B_TRIM_OSCSTR;
extern volatile B_TRIM_OSCSTR _B_TRIM_OSC @(REG_BASE + 0x000002E8UL);
#define B_TRIM_OSC                      _B_TRIM_OSC.Word
#define B_TRIM_OSC_LPOSC                _B_TRIM_OSC.Bits.LPOSC

#define B_TRIM_OSC_LPOSC_MASK           8191U
#define B_TRIM_OSC_LPOSC_BITNUM         0U


/*** NB_PCR_CTL - PCR Control Register; 0x00000300 ***/
typedef union {
  word Word;
  struct {
    word OPM         :2;                                       /* Operation mode select 0 */
    word PF          :2;                                       /* 1 ms Prescaler 0 */
    word             :1; 
    word HWR         :1;                                       /* Hardware Reset */
    word UVIE        :1;                                       /* Low Supply Voltage Interrupt enable */
    word HTIE        :1;                                       /* High Temperature Interrupt enable */
    word OPMM        :2;                                       /* Operation mode mask 0 */
    word PFM         :2;                                       /* Prescalar factor mask 0 */
    word             :1; 
    word HWRM        :1;                                       /* Hardware reset mask */
    word UVIEM       :1;                                       /* Supply Under Voltage interrupt enable mask */
    word HTIEM       :1;                                       /* High temperature interrupt enable mask */
  } Bits;
} NB_PCR_CTLSTR;
extern volatile NB_PCR_CTLSTR _NB_PCR_CTL @(REG_BASE + 0x00000300UL);
#define NB_PCR_CTL                      _NB_PCR_CTL.Word
#define NB_PCR_CTL_OPM                  _NB_PCR_CTL.Bits.OPM
#define NB_PCR_CTL_PF                   _NB_PCR_CTL.Bits.PF
#define NB_PCR_CTL_HWR                  _NB_PCR_CTL.Bits.HWR
#define NB_PCR_CTL_UVIE                 _NB_PCR_CTL.Bits.UVIE
#define NB_PCR_CTL_HTIE                 _NB_PCR_CTL.Bits.HTIE
#define NB_PCR_CTL_OPMM                 _NB_PCR_CTL.Bits.OPMM
#define NB_PCR_CTL_PFM                  _NB_PCR_CTL.Bits.PFM
#define NB_PCR_CTL_HWRM                 _NB_PCR_CTL.Bits.HWRM
#define NB_PCR_CTL_UVIEM                _NB_PCR_CTL.Bits.UVIEM
#define NB_PCR_CTL_HTIEM                _NB_PCR_CTL.Bits.HTIEM

#define NB_PCR_CTL_OPM_MASK             3U
#define NB_PCR_CTL_OPM_BITNUM           0U
#define NB_PCR_CTL_PF_MASK              12U
#define NB_PCR_CTL_PF_BITNUM            2U
#define NB_PCR_CTL_HWR_MASK             32U
#define NB_PCR_CTL_UVIE_MASK            64U
#define NB_PCR_CTL_HTIE_MASK            128U
#define NB_PCR_CTL_OPMM_MASK            768U
#define NB_PCR_CTL_OPMM_BITNUM          8U
#define NB_PCR_CTL_PFM_MASK             3072U
#define NB_PCR_CTL_PFM_BITNUM           10U
#define NB_PCR_CTL_HWRM_MASK            8192U
#define NB_PCR_CTL_UVIEM_MASK           16384U
#define NB_PCR_CTL_HTIEM_MASK           32768U


/*** NB_PCR_SR - PCR Status Register; 0x00000302 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_PCR_SRH - PCR Status Register High; 0x00000302 ***/
    union {
      byte Byte;
      struct {
        byte WLPMF       :1;                                       /* Wake-up after Low Power Mode Flag */
        byte WULTCF      :1;                                       /* Life Time Counter Wake Up Flag */
        byte LVRF        :1;                                       /* VDDL Low Voltage (POR) Reset Flag */
        byte HVRF        :1;                                       /* VDDH Low Voltage Reset Flag */
        byte WDRF        :1;                                       /* Watchdog Reset Flag */
        byte HWRF        :1;                                       /* Hardware Reset Flag */
        byte UVF         :1;                                       /* Supply Undervoltage Condition Flag */
        byte HTF         :1;                                       /* High Temperature Condition Flag */
      } Bits;
    } NB_PCR_SRHSTR;
    #define NB_PCR_SRH                  _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Byte
    #define NB_PCR_SRH_WLPMF            _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Bits.WLPMF
    #define NB_PCR_SRH_WULTCF           _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Bits.WULTCF
    #define NB_PCR_SRH_LVRF             _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Bits.LVRF
    #define NB_PCR_SRH_HVRF             _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Bits.HVRF
    #define NB_PCR_SRH_WDRF             _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Bits.WDRF
    #define NB_PCR_SRH_HWRF             _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Bits.HWRF
    #define NB_PCR_SRH_UVF              _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Bits.UVF
    #define NB_PCR_SRH_HTF              _NB_PCR_SR.Overlap_STR.NB_PCR_SRHSTR.Bits.HTF
    
    #define NB_PCR_SRH_WLPMF_MASK       1U
    #define NB_PCR_SRH_WULTCF_MASK      2U
    #define NB_PCR_SRH_LVRF_MASK        4U
    #define NB_PCR_SRH_HVRF_MASK        8U
    #define NB_PCR_SRH_WDRF_MASK        16U
    #define NB_PCR_SRH_HWRF_MASK        32U
    #define NB_PCR_SRH_UVF_MASK         64U
    #define NB_PCR_SRH_HTF_MASK         128U
    

    /*** NB_PCR_SRL - PCR Status Register Low; 0x00000303 ***/
    union {
      byte Byte;
      struct {
        byte WUPTB0F     :1;                                       /* Wake-up on GPIO 0 event flag */
        byte WUPTB1F     :1;                                       /* Wake-up on GPIO 1 event flag */
        byte WUPTB2F     :1;                                       /* Wake-up on GPIO 2 event flag */
        byte WUPTB3F     :1;                                       /* Wake-up on GPIO 3 event flag */
        byte WULINF      :1;                                       /* Wake-up on LIN flag */
        byte WUCALF      :1;                                       /* Wake-up on calibration request flag */
        byte WUCTHF      :1;                                       /* Wake-up on current threshold Flag */
        byte WUAHTHF     :1;                                       /* Wake-up on Ah counter threshold Flag */
      } Bits;
    } NB_PCR_SRLSTR;
    #define NB_PCR_SRL                  _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Byte
    #define NB_PCR_SRL_WUPTB0F          _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Bits.WUPTB0F
    #define NB_PCR_SRL_WUPTB1F          _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Bits.WUPTB1F
    #define NB_PCR_SRL_WUPTB2F          _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Bits.WUPTB2F
    #define NB_PCR_SRL_WUPTB3F          _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Bits.WUPTB3F
    #define NB_PCR_SRL_WULINF           _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Bits.WULINF
    #define NB_PCR_SRL_WUCALF           _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Bits.WUCALF
    #define NB_PCR_SRL_WUCTHF           _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Bits.WUCTHF
    #define NB_PCR_SRL_WUAHTHF          _NB_PCR_SR.Overlap_STR.NB_PCR_SRLSTR.Bits.WUAHTHF
    
    #define NB_PCR_SRL_WUPTB0F_MASK     1U
    #define NB_PCR_SRL_WUPTB1F_MASK     2U
    #define NB_PCR_SRL_WUPTB2F_MASK     4U
    #define NB_PCR_SRL_WUPTB3F_MASK     8U
    #define NB_PCR_SRL_WULINF_MASK      16U
    #define NB_PCR_SRL_WUCALF_MASK      32U
    #define NB_PCR_SRL_WUCTHF_MASK      64U
    #define NB_PCR_SRL_WUAHTHF_MASK     128U
    
  } Overlap_STR;

  struct {
    word WUPTB0F     :1;                                       /* Wake-up on GPIO 0 event flag */
    word WUPTB1F     :1;                                       /* Wake-up on GPIO 1 event flag */
    word WUPTB2F     :1;                                       /* Wake-up on GPIO 2 event flag */
    word WUPTB3F     :1;                                       /* Wake-up on GPIO 3 event flag */
    word WULINF      :1;                                       /* Wake-up on LIN flag */
    word WUCALF      :1;                                       /* Wake-up on calibration request flag */
    word WUCTHF      :1;                                       /* Wake-up on current threshold Flag */
    word WUAHTHF     :1;                                       /* Wake-up on Ah counter threshold Flag */
    word WLPMF       :1;                                       /* Wake-up after Low Power Mode Flag */
    word WULTCF      :1;                                       /* Life Time Counter Wake Up Flag */
    word LVRF        :1;                                       /* VDDL Low Voltage (POR) Reset Flag */
    word HVRF        :1;                                       /* VDDH Low Voltage Reset Flag */
    word WDRF        :1;                                       /* Watchdog Reset Flag */
    word HWRF        :1;                                       /* Hardware Reset Flag */
    word UVF         :1;                                       /* Supply Undervoltage Condition Flag */
    word HTF         :1;                                       /* High Temperature Condition Flag */
  } Bits;
} NB_PCR_SRSTR;
extern volatile NB_PCR_SRSTR _NB_PCR_SR @(REG_BASE + 0x00000302UL);
#define NB_PCR_SR                       _NB_PCR_SR.Word
#define NB_PCR_SR_WUPTB0F               _NB_PCR_SR.Bits.WUPTB0F
#define NB_PCR_SR_WUPTB1F               _NB_PCR_SR.Bits.WUPTB1F
#define NB_PCR_SR_WUPTB2F               _NB_PCR_SR.Bits.WUPTB2F
#define NB_PCR_SR_WUPTB3F               _NB_PCR_SR.Bits.WUPTB3F
#define NB_PCR_SR_WULINF                _NB_PCR_SR.Bits.WULINF
#define NB_PCR_SR_WUCALF                _NB_PCR_SR.Bits.WUCALF
#define NB_PCR_SR_WUCTHF                _NB_PCR_SR.Bits.WUCTHF
#define NB_PCR_SR_WUAHTHF               _NB_PCR_SR.Bits.WUAHTHF
#define NB_PCR_SR_WLPMF                 _NB_PCR_SR.Bits.WLPMF
#define NB_PCR_SR_WULTCF                _NB_PCR_SR.Bits.WULTCF
#define NB_PCR_SR_LVRF                  _NB_PCR_SR.Bits.LVRF
#define NB_PCR_SR_HVRF                  _NB_PCR_SR.Bits.HVRF
#define NB_PCR_SR_WDRF                  _NB_PCR_SR.Bits.WDRF
#define NB_PCR_SR_HWRF                  _NB_PCR_SR.Bits.HWRF
#define NB_PCR_SR_UVF                   _NB_PCR_SR.Bits.UVF
#define NB_PCR_SR_HTF                   _NB_PCR_SR.Bits.HTF

#define NB_PCR_SR_WUPTB0F_MASK          1U
#define NB_PCR_SR_WUPTB1F_MASK          2U
#define NB_PCR_SR_WUPTB2F_MASK          4U
#define NB_PCR_SR_WUPTB3F_MASK          8U
#define NB_PCR_SR_WULINF_MASK           16U
#define NB_PCR_SR_WUCALF_MASK           32U
#define NB_PCR_SR_WUCTHF_MASK           64U
#define NB_PCR_SR_WUAHTHF_MASK          128U
#define NB_PCR_SR_WLPMF_MASK            256U
#define NB_PCR_SR_WULTCF_MASK           512U
#define NB_PCR_SR_LVRF_MASK             1024U
#define NB_PCR_SR_HVRF_MASK             2048U
#define NB_PCR_SR_WDRF_MASK             4096U
#define NB_PCR_SR_HWRF_MASK             8192U
#define NB_PCR_SR_UVF_MASK              16384U
#define NB_PCR_SR_HTF_MASK              32768U


/*** NB_PCR_PRESC - PCR 1ms prescaler; 0x00000304 ***/
typedef union {
  word Word;
} NB_PCR_PRESCSTR;
extern volatile NB_PCR_PRESCSTR _NB_PCR_PRESC @(REG_BASE + 0x00000304UL);
#define NB_PCR_PRESC                    _NB_PCR_PRESC.Word


/*** NB_PCR_WUE - Wake Up Enable Register; 0x00000306 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_PCR_WUEH - Wake Up Enable Register High; 0x00000306 ***/
    union {
      byte Byte;
      struct {
        byte WUPTB0      :1;                                       /* Wake-up on GPIO 0 event */
        byte WUPTB1      :1;                                       /* Wake-up on GPIO 1 event */
        byte WUPTB2      :1;                                       /* Wake-up on GPIO 2 event */
        byte WUPTB3      :1;                                       /* Wake-up on GPIO 3 event */
        byte WULIN       :1;                                       /* Wake-up on LIN */
        byte WUCAL       :1;                                       /* Wake-up on calibration request */
        byte WUCTH       :1;                                       /* Wake-up on current threshold */
        byte WUAHTH      :1;                                       /* Wake-up on Ah counter */
      } Bits;
      struct {
        byte grpWUPTB :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } NB_PCR_WUEHSTR;
    #define NB_PCR_WUEH                 _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Byte
    #define NB_PCR_WUEH_WUPTB0          _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Bits.WUPTB0
    #define NB_PCR_WUEH_WUPTB1          _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Bits.WUPTB1
    #define NB_PCR_WUEH_WUPTB2          _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Bits.WUPTB2
    #define NB_PCR_WUEH_WUPTB3          _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Bits.WUPTB3
    #define NB_PCR_WUEH_WULIN           _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Bits.WULIN
    #define NB_PCR_WUEH_WUCAL           _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Bits.WUCAL
    #define NB_PCR_WUEH_WUCTH           _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Bits.WUCTH
    #define NB_PCR_WUEH_WUAHTH          _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.Bits.WUAHTH
    #define NB_PCR_WUEH_WUPTB           _NB_PCR_WUE.Overlap_STR.NB_PCR_WUEHSTR.MergedBits.grpWUPTB
    
    #define NB_PCR_WUEH_WUPTB0_MASK     1U
    #define NB_PCR_WUEH_WUPTB1_MASK     2U
    #define NB_PCR_WUEH_WUPTB2_MASK     4U
    #define NB_PCR_WUEH_WUPTB3_MASK     8U
    #define NB_PCR_WUEH_WULIN_MASK      16U
    #define NB_PCR_WUEH_WUCAL_MASK      32U
    #define NB_PCR_WUEH_WUCTH_MASK      64U
    #define NB_PCR_WUEH_WUAHTH_MASK     128U
    #define NB_PCR_WUEH_WUPTB_MASK      15U
    #define NB_PCR_WUEH_WUPTB_BITNUM    0U
    

    /*** NB_PCR_WUEL - Wake Up Enable Register Low; 0x00000307 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte WULTC       :1;                                       /* Wake-up on Life Timer Counter Overflow */
      } Bits;
    } NB_PCR_WUELSTR;
    #define NB_PCR_WUEL                 _NB_PCR_WUE.Overlap_STR.NB_PCR_WUELSTR.Byte
    #define NB_PCR_WUEL_WULTC           _NB_PCR_WUE.Overlap_STR.NB_PCR_WUELSTR.Bits.WULTC
    
    #define NB_PCR_WUEL_WULTC_MASK      128U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word WULTC       :1;                                       /* Wake-up on Life Timer Counter Overflow */
    word WUPTB0      :1;                                       /* Wake-up on GPIO 0 event */
    word WUPTB1      :1;                                       /* Wake-up on GPIO 1 event */
    word WUPTB2      :1;                                       /* Wake-up on GPIO 2 event */
    word WUPTB3      :1;                                       /* Wake-up on GPIO 3 event */
    word WULIN       :1;                                       /* Wake-up on LIN */
    word WUCAL       :1;                                       /* Wake-up on calibration request */
    word WUCTH       :1;                                       /* Wake-up on current threshold */
    word WUAHTH      :1;                                       /* Wake-up on Ah counter */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpWUPTB :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} NB_PCR_WUESTR;
extern volatile NB_PCR_WUESTR _NB_PCR_WUE @(REG_BASE + 0x00000306UL);
#define NB_PCR_WUE                      _NB_PCR_WUE.Word
#define NB_PCR_WUE_WULTC                _NB_PCR_WUE.Bits.WULTC
#define NB_PCR_WUE_WUPTB0               _NB_PCR_WUE.Bits.WUPTB0
#define NB_PCR_WUE_WUPTB1               _NB_PCR_WUE.Bits.WUPTB1
#define NB_PCR_WUE_WUPTB2               _NB_PCR_WUE.Bits.WUPTB2
#define NB_PCR_WUE_WUPTB3               _NB_PCR_WUE.Bits.WUPTB3
#define NB_PCR_WUE_WULIN                _NB_PCR_WUE.Bits.WULIN
#define NB_PCR_WUE_WUCAL                _NB_PCR_WUE.Bits.WUCAL
#define NB_PCR_WUE_WUCTH                _NB_PCR_WUE.Bits.WUCTH
#define NB_PCR_WUE_WUAHTH               _NB_PCR_WUE.Bits.WUAHTH
#define NB_PCR_WUE_WUPTB                _NB_PCR_WUE.MergedBits.grpWUPTB

#define NB_PCR_WUE_WULTC_MASK           128U
#define NB_PCR_WUE_WUPTB0_MASK          256U
#define NB_PCR_WUE_WUPTB1_MASK          512U
#define NB_PCR_WUE_WUPTB2_MASK          1024U
#define NB_PCR_WUE_WUPTB3_MASK          2048U
#define NB_PCR_WUE_WULIN_MASK           4096U
#define NB_PCR_WUE_WUCAL_MASK           8192U
#define NB_PCR_WUE_WUCTH_MASK           16384U
#define NB_PCR_WUE_WUAHTH_MASK          32768U
#define NB_PCR_WUE_WUPTB_MASK           3840U
#define NB_PCR_WUE_WUPTB_BITNUM         8U


/*** NB_INT_SRC - Interrupt source register; 0x00000308 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_INT_SRCH - Interrupt source register high; 0x00000308 ***/
    union {
      byte Byte;
      struct {
        byte UVI         :1;                                       /* Undervoltage Interrupt pending or wake up from Cranking Mode Status */
        byte HTI         :1;                                       /* High Temperature Interrupt Status */
        byte LTI         :1;                                       /* LIN Driver Over Temperature Interrupt Status */
        byte CH0         :1;                                       /* TIM16B4C - TIM Channel 0 Interrupt Status */
        byte CH1         :1;                                       /* TIM16B4C - TIM Channel 1 Interrupt Status */
        byte CH2         :1;                                       /* TIM16B4C - TIM Channel 2 Interrupt Status */
        byte CH3         :1;                                       /* TIM16B4C - TIM Channel 3 Interrupt Status */
        byte TOV         :1;                                       /* TIM16B4C - Timer Overflow Interrupt Status */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpCH :4;
        byte     :1;
      } MergedBits;
    } NB_INT_SRCHSTR;
    #define NB_INT_SRCH                 _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Byte
    #define NB_INT_SRCH_UVI             _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Bits.UVI
    #define NB_INT_SRCH_HTI             _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Bits.HTI
    #define NB_INT_SRCH_LTI             _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Bits.LTI
    #define NB_INT_SRCH_CH0             _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Bits.CH0
    #define NB_INT_SRCH_CH1             _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Bits.CH1
    #define NB_INT_SRCH_CH2             _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Bits.CH2
    #define NB_INT_SRCH_CH3             _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Bits.CH3
    #define NB_INT_SRCH_TOV             _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.Bits.TOV
    #define NB_INT_SRCH_CH              _NB_INT_SRC.Overlap_STR.NB_INT_SRCHSTR.MergedBits.grpCH
    
    #define NB_INT_SRCH_UVI_MASK        1U
    #define NB_INT_SRCH_HTI_MASK        2U
    #define NB_INT_SRCH_LTI_MASK        4U
    #define NB_INT_SRCH_CH0_MASK        8U
    #define NB_INT_SRCH_CH1_MASK        16U
    #define NB_INT_SRCH_CH2_MASK        32U
    #define NB_INT_SRCH_CH3_MASK        64U
    #define NB_INT_SRCH_TOV_MASK        128U
    #define NB_INT_SRCH_CH_MASK         120U
    #define NB_INT_SRCH_CH_BITNUM       3U
    

    /*** NB_INT_SRCL - Interrupt source register low; 0x00000309 ***/
    union {
      byte Byte;
      struct {
        byte ERR         :1;                                       /* SCI Error Interrupt Status */
        byte TX          :1;                                       /* SCI Transmit Interrupt Status */
        byte RX          :1;                                       /* SCI Receive Interrupt Status */
        byte CVMI        :1;                                       /* Current / Voltage Measurement Interrupt Status */
        byte LTC         :1;                                       /* Life Time Counter Interrupt Status */
        byte CAL         :1;                                       /* Calibration Request Interrupt Status */
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_INT_SRCLSTR;
    #define NB_INT_SRCL                 _NB_INT_SRC.Overlap_STR.NB_INT_SRCLSTR.Byte
    #define NB_INT_SRCL_ERR             _NB_INT_SRC.Overlap_STR.NB_INT_SRCLSTR.Bits.ERR
    #define NB_INT_SRCL_TX              _NB_INT_SRC.Overlap_STR.NB_INT_SRCLSTR.Bits.TX
    #define NB_INT_SRCL_RX              _NB_INT_SRC.Overlap_STR.NB_INT_SRCLSTR.Bits.RX
    #define NB_INT_SRCL_CVMI            _NB_INT_SRC.Overlap_STR.NB_INT_SRCLSTR.Bits.CVMI
    #define NB_INT_SRCL_LTC             _NB_INT_SRC.Overlap_STR.NB_INT_SRCLSTR.Bits.LTC
    #define NB_INT_SRCL_CAL             _NB_INT_SRC.Overlap_STR.NB_INT_SRCLSTR.Bits.CAL
    
    #define NB_INT_SRCL_ERR_MASK        1U
    #define NB_INT_SRCL_TX_MASK         2U
    #define NB_INT_SRCL_RX_MASK         4U
    #define NB_INT_SRCL_CVMI_MASK       8U
    #define NB_INT_SRCL_LTC_MASK        16U
    #define NB_INT_SRCL_CAL_MASK        32U
    
  } Overlap_STR;

  struct {
    word ERR         :1;                                       /* SCI Error Interrupt Status */
    word TX          :1;                                       /* SCI Transmit Interrupt Status */
    word RX          :1;                                       /* SCI Receive Interrupt Status */
    word CVMI        :1;                                       /* Current / Voltage Measurement Interrupt Status */
    word LTC         :1;                                       /* Life Time Counter Interrupt Status */
    word CAL         :1;                                       /* Calibration Request Interrupt Status */
    word             :1; 
    word             :1; 
    word UVI         :1;                                       /* Undervoltage Interrupt pending or wake up from Cranking Mode Status */
    word HTI         :1;                                       /* High Temperature Interrupt Status */
    word LTI         :1;                                       /* LIN Driver Over Temperature Interrupt Status */
    word CH0         :1;                                       /* TIM16B4C - TIM Channel 0 Interrupt Status */
    word CH1         :1;                                       /* TIM16B4C - TIM Channel 1 Interrupt Status */
    word CH2         :1;                                       /* TIM16B4C - TIM Channel 2 Interrupt Status */
    word CH3         :1;                                       /* TIM16B4C - TIM Channel 3 Interrupt Status */
    word TOV         :1;                                       /* TIM16B4C - Timer Overflow Interrupt Status */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpCH   :4;
    word         :1;
  } MergedBits;
} NB_INT_SRCSTR;
extern volatile NB_INT_SRCSTR _NB_INT_SRC @(REG_BASE + 0x00000308UL);
#define NB_INT_SRC                      _NB_INT_SRC.Word
#define NB_INT_SRC_ERR                  _NB_INT_SRC.Bits.ERR
#define NB_INT_SRC_TX                   _NB_INT_SRC.Bits.TX
#define NB_INT_SRC_RX                   _NB_INT_SRC.Bits.RX
#define NB_INT_SRC_CVMI                 _NB_INT_SRC.Bits.CVMI
#define NB_INT_SRC_LTC                  _NB_INT_SRC.Bits.LTC
#define NB_INT_SRC_CAL                  _NB_INT_SRC.Bits.CAL
#define NB_INT_SRC_UVI                  _NB_INT_SRC.Bits.UVI
#define NB_INT_SRC_HTI                  _NB_INT_SRC.Bits.HTI
#define NB_INT_SRC_LTI                  _NB_INT_SRC.Bits.LTI
#define NB_INT_SRC_CH0                  _NB_INT_SRC.Bits.CH0
#define NB_INT_SRC_CH1                  _NB_INT_SRC.Bits.CH1
#define NB_INT_SRC_CH2                  _NB_INT_SRC.Bits.CH2
#define NB_INT_SRC_CH3                  _NB_INT_SRC.Bits.CH3
#define NB_INT_SRC_TOV                  _NB_INT_SRC.Bits.TOV
#define NB_INT_SRC_CH                   _NB_INT_SRC.MergedBits.grpCH

#define NB_INT_SRC_ERR_MASK             1U
#define NB_INT_SRC_TX_MASK              2U
#define NB_INT_SRC_RX_MASK              4U
#define NB_INT_SRC_CVMI_MASK            8U
#define NB_INT_SRC_LTC_MASK             16U
#define NB_INT_SRC_CAL_MASK             32U
#define NB_INT_SRC_UVI_MASK             256U
#define NB_INT_SRC_HTI_MASK             512U
#define NB_INT_SRC_LTI_MASK             1024U
#define NB_INT_SRC_CH0_MASK             2048U
#define NB_INT_SRC_CH1_MASK             4096U
#define NB_INT_SRC_CH2_MASK             8192U
#define NB_INT_SRC_CH3_MASK             16384U
#define NB_INT_SRC_TOV_MASK             32768U
#define NB_INT_SRC_CH_MASK              30720U
#define NB_INT_SRC_CH_BITNUM            11U


/*** NB_INT_VECT - Interrupt vector register; 0x0000030A ***/
typedef union {
  byte Byte;
  struct {
    byte IRQ         :4;                                       /* Represents the highest prioritized interrupt pending */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_INT_VECTSTR;
extern volatile NB_INT_VECTSTR _NB_INT_VECT @(REG_BASE + 0x0000030AUL);
#define NB_INT_VECT                     _NB_INT_VECT.Byte
#define NB_INT_VECT_IRQ                 _NB_INT_VECT.Bits.IRQ

#define NB_INT_VECT_IRQ_MASK            15U
#define NB_INT_VECT_IRQ_BITNUM          0U


/*** NB_INT_MSK - Interrupt mask register; 0x0000030C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_INT_MSKH - Interrupt mask register high; 0x0000030C ***/
    union {
      byte Byte;
      struct {
        byte UVIM        :1;                                       /* Undervoltage Interrupt Mask */
        byte HTIM        :1;                                       /* High Temperature Interrupt Mask */
        byte LTIM        :1;                                       /* LIN Driver Over Temperature Interrupt Mask */
        byte CH0M        :1;                                       /* Timer Channel 1 Interrupt Mask */
        byte CH1M        :1;                                       /* Timer Channel 1 Interrupt Mask */
        byte CH2M        :1;                                       /* Timer Channel 2 Interrupt Mask */
        byte CH3M        :1;                                       /* Timer Channel 3 Interrupt Mask */
        byte TOVM        :1;                                       /* Timer Overflow Interrupt Mask */
      } Bits;
    } NB_INT_MSKHSTR;
    #define NB_INT_MSKH                 _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Byte
    #define NB_INT_MSKH_UVIM            _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Bits.UVIM
    #define NB_INT_MSKH_HTIM            _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Bits.HTIM
    #define NB_INT_MSKH_LTIM            _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Bits.LTIM
    #define NB_INT_MSKH_CH0M            _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Bits.CH0M
    #define NB_INT_MSKH_CH1M            _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Bits.CH1M
    #define NB_INT_MSKH_CH2M            _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Bits.CH2M
    #define NB_INT_MSKH_CH3M            _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Bits.CH3M
    #define NB_INT_MSKH_TOVM            _NB_INT_MSK.Overlap_STR.NB_INT_MSKHSTR.Bits.TOVM
    
    #define NB_INT_MSKH_UVIM_MASK       1U
    #define NB_INT_MSKH_HTIM_MASK       2U
    #define NB_INT_MSKH_LTIM_MASK       4U
    #define NB_INT_MSKH_CH0M_MASK       8U
    #define NB_INT_MSKH_CH1M_MASK       16U
    #define NB_INT_MSKH_CH2M_MASK       32U
    #define NB_INT_MSKH_CH3M_MASK       64U
    #define NB_INT_MSKH_TOVM_MASK       128U
    

    /*** NB_INT_MSKL - Interrupt mask register low; 0x0000030D ***/
    union {
      byte Byte;
      struct {
        byte ERRM        :1;                                       /* SCI Error Interrupt Mask */
        byte TXM         :1;                                       /* SCI Transmit Interrupt Mask */
        byte RXM         :1;                                       /* SCI Receive Interrupt Mask */
        byte CVMM        :1;                                       /* Current / Voltage Measurement Interrupt Mask */
        byte LTCM        :1;                                       /* Life Time Counter Interrupt Mask */
        byte CALM        :1;                                       /* Calibration Request Interrupt Mask */
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_INT_MSKLSTR;
    #define NB_INT_MSKL                 _NB_INT_MSK.Overlap_STR.NB_INT_MSKLSTR.Byte
    #define NB_INT_MSKL_ERRM            _NB_INT_MSK.Overlap_STR.NB_INT_MSKLSTR.Bits.ERRM
    #define NB_INT_MSKL_TXM             _NB_INT_MSK.Overlap_STR.NB_INT_MSKLSTR.Bits.TXM
    #define NB_INT_MSKL_RXM             _NB_INT_MSK.Overlap_STR.NB_INT_MSKLSTR.Bits.RXM
    #define NB_INT_MSKL_CVMM            _NB_INT_MSK.Overlap_STR.NB_INT_MSKLSTR.Bits.CVMM
    #define NB_INT_MSKL_LTCM            _NB_INT_MSK.Overlap_STR.NB_INT_MSKLSTR.Bits.LTCM
    #define NB_INT_MSKL_CALM            _NB_INT_MSK.Overlap_STR.NB_INT_MSKLSTR.Bits.CALM
    
    #define NB_INT_MSKL_ERRM_MASK       1U
    #define NB_INT_MSKL_TXM_MASK        2U
    #define NB_INT_MSKL_RXM_MASK        4U
    #define NB_INT_MSKL_CVMM_MASK       8U
    #define NB_INT_MSKL_LTCM_MASK       16U
    #define NB_INT_MSKL_CALM_MASK       32U
    
  } Overlap_STR;

  struct {
    word ERRM        :1;                                       /* SCI Error Interrupt Mask */
    word TXM         :1;                                       /* SCI Transmit Interrupt Mask */
    word RXM         :1;                                       /* SCI Receive Interrupt Mask */
    word CVMM        :1;                                       /* Current / Voltage Measurement Interrupt Mask */
    word LTCM        :1;                                       /* Life Time Counter Interrupt Mask */
    word CALM        :1;                                       /* Calibration Request Interrupt Mask */
    word             :1; 
    word             :1; 
    word UVIM        :1;                                       /* Undervoltage Interrupt Mask */
    word HTIM        :1;                                       /* High Temperature Interrupt Mask */
    word LTIM        :1;                                       /* LIN Driver Over Temperature Interrupt Mask */
    word CH0M        :1;                                       /* Timer Channel 1 Interrupt Mask */
    word CH1M        :1;                                       /* Timer Channel 1 Interrupt Mask */
    word CH2M        :1;                                       /* Timer Channel 2 Interrupt Mask */
    word CH3M        :1;                                       /* Timer Channel 3 Interrupt Mask */
    word TOVM        :1;                                       /* Timer Overflow Interrupt Mask */
  } Bits;
} NB_INT_MSKSTR;
extern volatile NB_INT_MSKSTR _NB_INT_MSK @(REG_BASE + 0x0000030CUL);
#define NB_INT_MSK                      _NB_INT_MSK.Word
#define NB_INT_MSK_ERRM                 _NB_INT_MSK.Bits.ERRM
#define NB_INT_MSK_TXM                  _NB_INT_MSK.Bits.TXM
#define NB_INT_MSK_RXM                  _NB_INT_MSK.Bits.RXM
#define NB_INT_MSK_CVMM                 _NB_INT_MSK.Bits.CVMM
#define NB_INT_MSK_LTCM                 _NB_INT_MSK.Bits.LTCM
#define NB_INT_MSK_CALM                 _NB_INT_MSK.Bits.CALM
#define NB_INT_MSK_UVIM                 _NB_INT_MSK.Bits.UVIM
#define NB_INT_MSK_HTIM                 _NB_INT_MSK.Bits.HTIM
#define NB_INT_MSK_LTIM                 _NB_INT_MSK.Bits.LTIM
#define NB_INT_MSK_CH0M                 _NB_INT_MSK.Bits.CH0M
#define NB_INT_MSK_CH1M                 _NB_INT_MSK.Bits.CH1M
#define NB_INT_MSK_CH2M                 _NB_INT_MSK.Bits.CH2M
#define NB_INT_MSK_CH3M                 _NB_INT_MSK.Bits.CH3M
#define NB_INT_MSK_TOVM                 _NB_INT_MSK.Bits.TOVM

#define NB_INT_MSK_ERRM_MASK            1U
#define NB_INT_MSK_TXM_MASK             2U
#define NB_INT_MSK_RXM_MASK             4U
#define NB_INT_MSK_CVMM_MASK            8U
#define NB_INT_MSK_LTCM_MASK            16U
#define NB_INT_MSK_CALM_MASK            32U
#define NB_INT_MSK_UVIM_MASK            256U
#define NB_INT_MSK_HTIM_MASK            512U
#define NB_INT_MSK_LTIM_MASK            1024U
#define NB_INT_MSK_CH0M_MASK            2048U
#define NB_INT_MSK_CH1M_MASK            4096U
#define NB_INT_MSK_CH2M_MASK            8192U
#define NB_INT_MSK_CH3M_MASK            16384U
#define NB_INT_MSK_TOVM_MASK            32768U


/*** NB_TRIM_ALF - Trim for accurate 1ms low freq clock; 0x0000030E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TRIM_ALFH - Trim for accurate 1ms low freq clock high; 0x0000030E ***/
    union {
      byte Byte;
      struct {
        byte APRESC      :5;                                       /* ALFCLK Prescaler 8 */
        byte             :1; 
        byte             :1; 
        byte PRDF        :1;                                       /* ALFCLK Prescaler ready Flag */
      } Bits;
    } NB_TRIM_ALFHSTR;
    #define NB_TRIM_ALFH                _NB_TRIM_ALF.Overlap_STR.NB_TRIM_ALFHSTR.Byte
    #define NB_TRIM_ALFH_APRESC         _NB_TRIM_ALF.Overlap_STR.NB_TRIM_ALFHSTR.Bits.APRESC
    #define NB_TRIM_ALFH_PRDF           _NB_TRIM_ALF.Overlap_STR.NB_TRIM_ALFHSTR.Bits.PRDF
    
    #define NB_TRIM_ALFH_APRESC_MASK    31U
    #define NB_TRIM_ALFH_APRESC_BITNUM  0U
    #define NB_TRIM_ALFH_PRDF_MASK      128U
    

    /*** NB_TRIM_ALFL - Trim for accurate 1ms low freq clock low; 0x0000030F ***/
    union {
      byte Byte;
    } NB_TRIM_ALFLSTR;
    #define NB_TRIM_ALFL                _NB_TRIM_ALF.Overlap_STR.NB_TRIM_ALFLSTR.Byte
    
  } Overlap_STR;

  struct {
    word APRESC      :13;                                      /* ALFCLK Prescaler 0 */
    word             :1; 
    word             :1; 
    word PRDF        :1;                                       /* ALFCLK Prescaler ready Flag */
  } Bits;
} NB_TRIM_ALFSTR;
extern volatile NB_TRIM_ALFSTR _NB_TRIM_ALF @(REG_BASE + 0x0000030EUL);
#define NB_TRIM_ALF                     _NB_TRIM_ALF.Word
#define NB_TRIM_ALF_APRESC              _NB_TRIM_ALF.Bits.APRESC
#define NB_TRIM_ALF_PRDF                _NB_TRIM_ALF.Bits.PRDF

#define NB_TRIM_ALF_APRESC_MASK         8191U
#define NB_TRIM_ALF_APRESC_BITNUM       0U
#define NB_TRIM_ALF_PRDF_MASK           32768U


/*** NB_WD_CTL - Watchdog control register; 0x00000310 ***/
typedef union {
  word Word;
  struct {
    word WDTO        :3;                                       /* Watchdog Time Out Configuration */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word WDTST       :1;                                       /* Watchdog Test */
    word WDTOM       :3;                                       /* Watchdog Time Out - Mask */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word WDSTM       :1;                                       /* Watchdog Test - Mask */
  } Bits;
} NB_WD_CTLSTR;
extern volatile NB_WD_CTLSTR _NB_WD_CTL @(REG_BASE + 0x00000310UL);
#define NB_WD_CTL                       _NB_WD_CTL.Word
#define NB_WD_CTL_WDTO                  _NB_WD_CTL.Bits.WDTO
#define NB_WD_CTL_WDTST                 _NB_WD_CTL.Bits.WDTST
#define NB_WD_CTL_WDTOM                 _NB_WD_CTL.Bits.WDTOM
#define NB_WD_CTL_WDSTM                 _NB_WD_CTL.Bits.WDSTM

#define NB_WD_CTL_WDTO_MASK             7U
#define NB_WD_CTL_WDTO_BITNUM           0U
#define NB_WD_CTL_WDTST_MASK            128U
#define NB_WD_CTL_WDTOM_MASK            1792U
#define NB_WD_CTL_WDTOM_BITNUM          8U
#define NB_WD_CTL_WDSTM_MASK            32768U


/*** NB_WD_SR - Watchdog status register; 0x00000312 ***/
typedef union {
  byte Byte;
  struct {
    byte WDWO        :1;                                       /* Watchdog Status */
    byte WDOFF       :1;                                       /* Watchdog Window Status */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_WD_SRSTR;
extern volatile NB_WD_SRSTR _NB_WD_SR @(REG_BASE + 0x00000312UL);
#define NB_WD_SR                        _NB_WD_SR.Byte
#define NB_WD_SR_WDWO                   _NB_WD_SR.Bits.WDWO
#define NB_WD_SR_WDOFF                  _NB_WD_SR.Bits.WDOFF

#define NB_WD_SR_WDWO_MASK              1U
#define NB_WD_SR_WDOFF_MASK             2U


/*** NB_WD_RR - Watchdog rearm register; 0x00000314 ***/
typedef union {
  byte Byte;
} NB_WD_RRSTR;
extern volatile NB_WD_RRSTR _NB_WD_RR @(REG_BASE + 0x00000314UL);
#define NB_WD_RR                        _NB_WD_RR.Byte


/*** NB_SCIBD - SCI Baud Rate Register; 0x00000318 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_SCIBDH - SCI Baud Rate Register High; 0x00000318 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
        byte SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
        byte SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
        byte SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
        byte SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
        byte             :1; 
        byte RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
        byte LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } NB_SCIBDHSTR;
    #define NB_SCIBDH                   _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Byte
    #define NB_SCIBDH_SBR8              _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR8
    #define NB_SCIBDH_SBR9              _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR9
    #define NB_SCIBDH_SBR10             _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR10
    #define NB_SCIBDH_SBR11             _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR11
    #define NB_SCIBDH_SBR12             _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR12
    #define NB_SCIBDH_RXEDGIE           _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.RXEDGIE
    #define NB_SCIBDH_LBKDIE            _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.LBKDIE
    #define NB_SCIBDH_SBR_8             _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.MergedBits.grpSBR_8
    #define NB_SCIBDH_SBR               NB_SCIBDH_SBR_8
    
    #define NB_SCIBDH_SBR8_MASK         1U
    #define NB_SCIBDH_SBR9_MASK         2U
    #define NB_SCIBDH_SBR10_MASK        4U
    #define NB_SCIBDH_SBR11_MASK        8U
    #define NB_SCIBDH_SBR12_MASK        16U
    #define NB_SCIBDH_RXEDGIE_MASK      64U
    #define NB_SCIBDH_LBKDIE_MASK       128U
    #define NB_SCIBDH_SBR_8_MASK        31U
    #define NB_SCIBDH_SBR_8_BITNUM      0U
    

    /*** NB_SCIBDL - SCI Baud Rate Register Low; 0x00000319 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
        byte SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
        byte SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
        byte SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
        byte SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
        byte SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
        byte SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
        byte SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
      } Bits;
    } NB_SCIBDLSTR;
    #define NB_SCIBDL                   _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Byte
    #define NB_SCIBDL_SBR0              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR0
    #define NB_SCIBDL_SBR1              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR1
    #define NB_SCIBDL_SBR2              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR2
    #define NB_SCIBDL_SBR3              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR3
    #define NB_SCIBDL_SBR4              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR4
    #define NB_SCIBDL_SBR5              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR5
    #define NB_SCIBDL_SBR6              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR6
    #define NB_SCIBDL_SBR7              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR7
    
    #define NB_SCIBDL_SBR0_MASK         1U
    #define NB_SCIBDL_SBR1_MASK         2U
    #define NB_SCIBDL_SBR2_MASK         4U
    #define NB_SCIBDL_SBR3_MASK         8U
    #define NB_SCIBDL_SBR4_MASK         16U
    #define NB_SCIBDL_SBR5_MASK         32U
    #define NB_SCIBDL_SBR6_MASK         64U
    #define NB_SCIBDL_SBR7_MASK         128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
    word SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
    word SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
    word SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
    word SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
    word SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
    word SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
    word SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
    word SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
    word SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
    word SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
    word SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
    word SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
    word             :1; 
    word RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
    word LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
  } Bits;
  struct {
    word grpSBR  :13;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} NB_SCIBDSTR;
extern volatile NB_SCIBDSTR _NB_SCIBD @(REG_BASE + 0x00000318UL);
#define NB_SCIBD                        _NB_SCIBD.Word
#define NB_SCIBD_SBR0                   _NB_SCIBD.Bits.SBR0
#define NB_SCIBD_SBR1                   _NB_SCIBD.Bits.SBR1
#define NB_SCIBD_SBR2                   _NB_SCIBD.Bits.SBR2
#define NB_SCIBD_SBR3                   _NB_SCIBD.Bits.SBR3
#define NB_SCIBD_SBR4                   _NB_SCIBD.Bits.SBR4
#define NB_SCIBD_SBR5                   _NB_SCIBD.Bits.SBR5
#define NB_SCIBD_SBR6                   _NB_SCIBD.Bits.SBR6
#define NB_SCIBD_SBR7                   _NB_SCIBD.Bits.SBR7
#define NB_SCIBD_SBR8                   _NB_SCIBD.Bits.SBR8
#define NB_SCIBD_SBR9                   _NB_SCIBD.Bits.SBR9
#define NB_SCIBD_SBR10                  _NB_SCIBD.Bits.SBR10
#define NB_SCIBD_SBR11                  _NB_SCIBD.Bits.SBR11
#define NB_SCIBD_SBR12                  _NB_SCIBD.Bits.SBR12
#define NB_SCIBD_RXEDGIE                _NB_SCIBD.Bits.RXEDGIE
#define NB_SCIBD_LBKDIE                 _NB_SCIBD.Bits.LBKDIE
#define NB_SCIBD_SBR                    _NB_SCIBD.MergedBits.grpSBR

#define NB_SCIBD_SBR0_MASK              1U
#define NB_SCIBD_SBR1_MASK              2U
#define NB_SCIBD_SBR2_MASK              4U
#define NB_SCIBD_SBR3_MASK              8U
#define NB_SCIBD_SBR4_MASK              16U
#define NB_SCIBD_SBR5_MASK              32U
#define NB_SCIBD_SBR6_MASK              64U
#define NB_SCIBD_SBR7_MASK              128U
#define NB_SCIBD_SBR8_MASK              256U
#define NB_SCIBD_SBR9_MASK              512U
#define NB_SCIBD_SBR10_MASK             1024U
#define NB_SCIBD_SBR11_MASK             2048U
#define NB_SCIBD_SBR12_MASK             4096U
#define NB_SCIBD_RXEDGIE_MASK           16384U
#define NB_SCIBD_LBKDIE_MASK            32768U
#define NB_SCIBD_SBR_MASK               8191U
#define NB_SCIBD_SBR_BITNUM             0U


/*** NB_SCIC1 - SCI Control Register 1; 0x0000031A ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type */
    byte PE          :1;                                       /* Parity Enable */
    byte ILT         :1;                                       /* Idle Line Type Select */
    byte             :1; 
    byte M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    byte RSRC        :1;                                       /* Receiver Source Select */
    byte             :1; 
    byte LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} NB_SCIC1STR;
extern volatile NB_SCIC1STR _NB_SCIC1 @(REG_BASE + 0x0000031AUL);
#define NB_SCIC1                        _NB_SCIC1.Byte
#define NB_SCIC1_PT                     _NB_SCIC1.Bits.PT
#define NB_SCIC1_PE                     _NB_SCIC1.Bits.PE
#define NB_SCIC1_ILT                    _NB_SCIC1.Bits.ILT
#define NB_SCIC1_M                      _NB_SCIC1.Bits.M
#define NB_SCIC1_RSRC                   _NB_SCIC1.Bits.RSRC
#define NB_SCIC1_LOOPS                  _NB_SCIC1.Bits.LOOPS

#define NB_SCIC1_PT_MASK                1U
#define NB_SCIC1_PE_MASK                2U
#define NB_SCIC1_ILT_MASK               4U
#define NB_SCIC1_M_MASK                 16U
#define NB_SCIC1_RSRC_MASK              32U
#define NB_SCIC1_LOOPS_MASK             128U


/*** NB_SCIC2 - SCI Control Register 2; 0x0000031B ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break */
    byte RWU         :1;                                       /* Receiver Wakeup Control */
    byte RE          :1;                                       /* Receiver Enable */
    byte TE          :1;                                       /* Transmitter Enable */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    byte RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    byte TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} NB_SCIC2STR;
extern volatile NB_SCIC2STR _NB_SCIC2 @(REG_BASE + 0x0000031BUL);
#define NB_SCIC2                        _NB_SCIC2.Byte
#define NB_SCIC2_SBK                    _NB_SCIC2.Bits.SBK
#define NB_SCIC2_RWU                    _NB_SCIC2.Bits.RWU
#define NB_SCIC2_RE                     _NB_SCIC2.Bits.RE
#define NB_SCIC2_TE                     _NB_SCIC2.Bits.TE
#define NB_SCIC2_ILIE                   _NB_SCIC2.Bits.ILIE
#define NB_SCIC2_RIE                    _NB_SCIC2.Bits.RIE
#define NB_SCIC2_TCIE                   _NB_SCIC2.Bits.TCIE
#define NB_SCIC2_TIE                    _NB_SCIC2.Bits.TIE

#define NB_SCIC2_SBK_MASK               1U
#define NB_SCIC2_RWU_MASK               2U
#define NB_SCIC2_RE_MASK                4U
#define NB_SCIC2_TE_MASK                8U
#define NB_SCIC2_ILIE_MASK              16U
#define NB_SCIC2_RIE_MASK               32U
#define NB_SCIC2_TCIE_MASK              64U
#define NB_SCIC2_TIE_MASK               128U


/*** NB_SCIS1 - SCI Status Register 1; 0x0000031C ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Receiver Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmission Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} NB_SCIS1STR;
extern volatile NB_SCIS1STR _NB_SCIS1 @(REG_BASE + 0x0000031CUL);
#define NB_SCIS1                        _NB_SCIS1.Byte
#define NB_SCIS1_PF                     _NB_SCIS1.Bits.PF
#define NB_SCIS1_FE                     _NB_SCIS1.Bits.FE
#define NB_SCIS1_NF                     _NB_SCIS1.Bits.NF
#define NB_SCIS1_OR                     _NB_SCIS1.Bits.OR
#define NB_SCIS1_IDLE                   _NB_SCIS1.Bits.IDLE
#define NB_SCIS1_RDRF                   _NB_SCIS1.Bits.RDRF
#define NB_SCIS1_TC                     _NB_SCIS1.Bits.TC
#define NB_SCIS1_TDRE                   _NB_SCIS1.Bits.TDRE

#define NB_SCIS1_PF_MASK                1U
#define NB_SCIS1_FE_MASK                2U
#define NB_SCIS1_NF_MASK                4U
#define NB_SCIS1_OR_MASK                8U
#define NB_SCIS1_IDLE_MASK              16U
#define NB_SCIS1_RDRF_MASK              32U
#define NB_SCIS1_TC_MASK                64U
#define NB_SCIS1_TDRE_MASK              128U


/*** NB_SCIS2 - SCI Status Register 2; 0x0000031D ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte LBKDE       :1;                                       /* LIN Break Detection Enable */
    byte BRK13       :1;                                       /* Break Character Generation Length */
    byte RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    byte RXINV       :1;                                       /* Receive Data Inversion */
    byte             :1; 
    byte RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    byte LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} NB_SCIS2STR;
extern volatile NB_SCIS2STR _NB_SCIS2 @(REG_BASE + 0x0000031DUL);
#define NB_SCIS2                        _NB_SCIS2.Byte
#define NB_SCIS2_RAF                    _NB_SCIS2.Bits.RAF
#define NB_SCIS2_LBKDE                  _NB_SCIS2.Bits.LBKDE
#define NB_SCIS2_BRK13                  _NB_SCIS2.Bits.BRK13
#define NB_SCIS2_RWUID                  _NB_SCIS2.Bits.RWUID
#define NB_SCIS2_RXINV                  _NB_SCIS2.Bits.RXINV
#define NB_SCIS2_RXEDGIF                _NB_SCIS2.Bits.RXEDGIF
#define NB_SCIS2_LBKDIF                 _NB_SCIS2.Bits.LBKDIF

#define NB_SCIS2_RAF_MASK               1U
#define NB_SCIS2_LBKDE_MASK             2U
#define NB_SCIS2_BRK13_MASK             4U
#define NB_SCIS2_RWUID_MASK             8U
#define NB_SCIS2_RXINV_MASK             16U
#define NB_SCIS2_RXEDGIF_MASK           64U
#define NB_SCIS2_LBKDIF_MASK            128U


/*** NB_SCIC3 - SCI Control Register 3; 0x0000031E ***/
typedef union {
  byte Byte;
  struct {
    byte PEIE        :1;                                       /* Parity Error Interrupt Enable */
    byte FEIE        :1;                                       /* Framing Error Interrupt Enable */
    byte NEIE        :1;                                       /* Noise Error Interrupt Enable */
    byte ORIE        :1;                                       /* Overrun Interrupt Enable */
    byte TXINV       :1;                                       /* Transmit Data Inversion */
    byte TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    byte T8          :1;                                       /* Ninth Data Bit for Transmitter */
    byte R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} NB_SCIC3STR;
extern volatile NB_SCIC3STR _NB_SCIC3 @(REG_BASE + 0x0000031EUL);
#define NB_SCIC3                        _NB_SCIC3.Byte
#define NB_SCIC3_PEIE                   _NB_SCIC3.Bits.PEIE
#define NB_SCIC3_FEIE                   _NB_SCIC3.Bits.FEIE
#define NB_SCIC3_NEIE                   _NB_SCIC3.Bits.NEIE
#define NB_SCIC3_ORIE                   _NB_SCIC3.Bits.ORIE
#define NB_SCIC3_TXINV                  _NB_SCIC3.Bits.TXINV
#define NB_SCIC3_TXDIR                  _NB_SCIC3.Bits.TXDIR
#define NB_SCIC3_T8                     _NB_SCIC3.Bits.T8
#define NB_SCIC3_R8                     _NB_SCIC3.Bits.R8

#define NB_SCIC3_PEIE_MASK              1U
#define NB_SCIC3_FEIE_MASK              2U
#define NB_SCIC3_NEIE_MASK              4U
#define NB_SCIC3_ORIE_MASK              8U
#define NB_SCIC3_TXINV_MASK             16U
#define NB_SCIC3_TXDIR_MASK             32U
#define NB_SCIC3_T8_MASK                64U
#define NB_SCIC3_R8_MASK                128U


/*** NB_SCID - SCI Data Register; 0x0000031F ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    byte R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    byte R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    byte R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    byte R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    byte R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    byte R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    byte R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} NB_SCIDSTR;
extern volatile NB_SCIDSTR _NB_SCID @(REG_BASE + 0x0000031FUL);
#define NB_SCID                         _NB_SCID.Byte
#define NB_SCID_R0_T0                   _NB_SCID.Bits.R0_T0
#define NB_SCID_R1_T1                   _NB_SCID.Bits.R1_T1
#define NB_SCID_R2_T2                   _NB_SCID.Bits.R2_T2
#define NB_SCID_R3_T3                   _NB_SCID.Bits.R3_T3
#define NB_SCID_R4_T4                   _NB_SCID.Bits.R4_T4
#define NB_SCID_R5_T5                   _NB_SCID.Bits.R5_T5
#define NB_SCID_R6_T6                   _NB_SCID.Bits.R6_T6
#define NB_SCID_R7_T7                   _NB_SCID.Bits.R7_T7

#define NB_SCID_R0_T0_MASK              1U
#define NB_SCID_R1_T1_MASK              2U
#define NB_SCID_R2_T2_MASK              4U
#define NB_SCID_R3_T3_MASK              8U
#define NB_SCID_R4_T4_MASK              16U
#define NB_SCID_R5_T5_MASK              32U
#define NB_SCID_R6_T6_MASK              64U
#define NB_SCID_R7_T7_MASK              128U


/*** NB_TIOS - Timer Input Capture/Output Compare Select; 0x00000320 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIOS  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_TIOSSTR;
extern volatile NB_TIOSSTR _NB_TIOS @(REG_BASE + 0x00000320UL);
#define NB_TIOS                         _NB_TIOS.Byte
#define NB_TIOS_IOS0                    _NB_TIOS.Bits.IOS0
#define NB_TIOS_IOS1                    _NB_TIOS.Bits.IOS1
#define NB_TIOS_IOS2                    _NB_TIOS.Bits.IOS2
#define NB_TIOS_IOS3                    _NB_TIOS.Bits.IOS3
#define NB_TIOS_IOS                     _NB_TIOS.MergedBits.grpIOS

#define NB_TIOS_IOS0_MASK               1U
#define NB_TIOS_IOS1_MASK               2U
#define NB_TIOS_IOS2_MASK               4U
#define NB_TIOS_IOS3_MASK               8U
#define NB_TIOS_IOS_MASK                15U
#define NB_TIOS_IOS_BITNUM              0U


/*** NB_CFORC - Timer Compare Force Register; 0x00000321 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpFOC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_CFORCSTR;
extern volatile NB_CFORCSTR _NB_CFORC @(REG_BASE + 0x00000321UL);
#define NB_CFORC                        _NB_CFORC.Byte
#define NB_CFORC_FOC0                   _NB_CFORC.Bits.FOC0
#define NB_CFORC_FOC1                   _NB_CFORC.Bits.FOC1
#define NB_CFORC_FOC2                   _NB_CFORC.Bits.FOC2
#define NB_CFORC_FOC3                   _NB_CFORC.Bits.FOC3
#define NB_CFORC_FOC                    _NB_CFORC.MergedBits.grpFOC

#define NB_CFORC_FOC0_MASK              1U
#define NB_CFORC_FOC1_MASK              2U
#define NB_CFORC_FOC2_MASK              4U
#define NB_CFORC_FOC3_MASK              8U
#define NB_CFORC_FOC_MASK               15U
#define NB_CFORC_FOC_BITNUM             0U


/*** NB_OC3M - Output Compare 3 Mask Register; 0x00000322 ***/
typedef union {
  byte Byte;
  struct {
    byte OC3M0       :1;                                       /* Output Compare 3 Mask Bit 0 */
    byte OC3M1       :1;                                       /* Output Compare 3 Mask Bit 1 */
    byte OC3M2       :1;                                       /* Output Compare 3 Mask Bit 2 */
    byte OC3M3       :1;                                       /* Output Compare 3 Mask Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOC3M :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_OC3MSTR;
extern volatile NB_OC3MSTR _NB_OC3M @(REG_BASE + 0x00000322UL);
#define NB_OC3M                         _NB_OC3M.Byte
#define NB_OC3M_OC3M0                   _NB_OC3M.Bits.OC3M0
#define NB_OC3M_OC3M1                   _NB_OC3M.Bits.OC3M1
#define NB_OC3M_OC3M2                   _NB_OC3M.Bits.OC3M2
#define NB_OC3M_OC3M3                   _NB_OC3M.Bits.OC3M3
#define NB_OC3M_OC3M                    _NB_OC3M.MergedBits.grpOC3M

#define NB_OC3M_OC3M0_MASK              1U
#define NB_OC3M_OC3M1_MASK              2U
#define NB_OC3M_OC3M2_MASK              4U
#define NB_OC3M_OC3M3_MASK              8U
#define NB_OC3M_OC3M_MASK               15U
#define NB_OC3M_OC3M_BITNUM             0U


/*** NB_OC3D - Output Compare 3 Data Register; 0x00000323 ***/
typedef union {
  byte Byte;
  struct {
    byte OC3D0       :1;                                       /* Output Compare 3 Bit 0 */
    byte OC3D1       :1;                                       /* Output Compare 3 Bit 1 */
    byte OC3D2       :1;                                       /* Output Compare 3 Bit 2 */
    byte OC3D3       :1;                                       /* Output Compare 3 Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOC3D :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_OC3DSTR;
extern volatile NB_OC3DSTR _NB_OC3D @(REG_BASE + 0x00000323UL);
#define NB_OC3D                         _NB_OC3D.Byte
#define NB_OC3D_OC3D0                   _NB_OC3D.Bits.OC3D0
#define NB_OC3D_OC3D1                   _NB_OC3D.Bits.OC3D1
#define NB_OC3D_OC3D2                   _NB_OC3D.Bits.OC3D2
#define NB_OC3D_OC3D3                   _NB_OC3D.Bits.OC3D3
#define NB_OC3D_OC3D                    _NB_OC3D.MergedBits.grpOC3D

#define NB_OC3D_OC3D0_MASK              1U
#define NB_OC3D_OC3D1_MASK              2U
#define NB_OC3D_OC3D2_MASK              4U
#define NB_OC3D_OC3D3_MASK              8U
#define NB_OC3D_OC3D_MASK               15U
#define NB_OC3D_OC3D_BITNUM             0U


/*** NB_TCNT - Timer Count Register; 0x00000324 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TCNTHi - Timer Count Register High; 0x00000324 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Count Register Bit 8 */
        byte BIT9        :1;                                       /* Timer Count Register Bit 9 */
        byte BIT10       :1;                                       /* Timer Count Register Bit 10 */
        byte BIT11       :1;                                       /* Timer Count Register Bit 11 */
        byte BIT12       :1;                                       /* Timer Count Register Bit 12 */
        byte BIT13       :1;                                       /* Timer Count Register Bit 13 */
        byte BIT14       :1;                                       /* Timer Count Register Bit 14 */
        byte BIT15       :1;                                       /* Timer Count Register Bit 15 */
      } Bits;
    } NB_TCNTHiSTR;
    #define NB_TCNTHi                   _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Byte
    #define NB_TCNTHi_BIT8              _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT8
    #define NB_TCNTHi_BIT9              _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT9
    #define NB_TCNTHi_BIT10             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT10
    #define NB_TCNTHi_BIT11             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT11
    #define NB_TCNTHi_BIT12             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT12
    #define NB_TCNTHi_BIT13             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT13
    #define NB_TCNTHi_BIT14             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT14
    #define NB_TCNTHi_BIT15             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT15
    
    #define NB_TCNTHi_BIT8_MASK         1U
    #define NB_TCNTHi_BIT9_MASK         2U
    #define NB_TCNTHi_BIT10_MASK        4U
    #define NB_TCNTHi_BIT11_MASK        8U
    #define NB_TCNTHi_BIT12_MASK        16U
    #define NB_TCNTHi_BIT13_MASK        32U
    #define NB_TCNTHi_BIT14_MASK        64U
    #define NB_TCNTHi_BIT15_MASK        128U
    

    /*** NB_TCNTLo - Timer Count Register Low; 0x00000325 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Count Register Bit 0 */
        byte BIT1        :1;                                       /* Timer Count Register Bit 1 */
        byte BIT2        :1;                                       /* Timer Count Register Bit 2 */
        byte BIT3        :1;                                       /* Timer Count Register Bit 3 */
        byte BIT4        :1;                                       /* Timer Count Register Bit 4 */
        byte BIT5        :1;                                       /* Timer Count Register Bit 5 */
        byte BIT6        :1;                                       /* Timer Count Register Bit 6 */
        byte BIT7        :1;                                       /* Timer Count Register Bit 7 */
      } Bits;
    } NB_TCNTLoSTR;
    #define NB_TCNTLo                   _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Byte
    #define NB_TCNTLo_BIT0              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT0
    #define NB_TCNTLo_BIT1              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT1
    #define NB_TCNTLo_BIT2              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT2
    #define NB_TCNTLo_BIT3              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT3
    #define NB_TCNTLo_BIT4              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT4
    #define NB_TCNTLo_BIT5              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT5
    #define NB_TCNTLo_BIT6              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT6
    #define NB_TCNTLo_BIT7              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT7
    
    #define NB_TCNTLo_BIT0_MASK         1U
    #define NB_TCNTLo_BIT1_MASK         2U
    #define NB_TCNTLo_BIT2_MASK         4U
    #define NB_TCNTLo_BIT3_MASK         8U
    #define NB_TCNTLo_BIT4_MASK         16U
    #define NB_TCNTLo_BIT5_MASK         32U
    #define NB_TCNTLo_BIT6_MASK         64U
    #define NB_TCNTLo_BIT7_MASK         128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Count Register Bit 0 */
    word BIT1        :1;                                       /* Timer Count Register Bit 1 */
    word BIT2        :1;                                       /* Timer Count Register Bit 2 */
    word BIT3        :1;                                       /* Timer Count Register Bit 3 */
    word BIT4        :1;                                       /* Timer Count Register Bit 4 */
    word BIT5        :1;                                       /* Timer Count Register Bit 5 */
    word BIT6        :1;                                       /* Timer Count Register Bit 6 */
    word BIT7        :1;                                       /* Timer Count Register Bit 7 */
    word BIT8        :1;                                       /* Timer Count Register Bit 8 */
    word BIT9        :1;                                       /* Timer Count Register Bit 9 */
    word BIT10       :1;                                       /* Timer Count Register Bit 10 */
    word BIT11       :1;                                       /* Timer Count Register Bit 11 */
    word BIT12       :1;                                       /* Timer Count Register Bit 12 */
    word BIT13       :1;                                       /* Timer Count Register Bit 13 */
    word BIT14       :1;                                       /* Timer Count Register Bit 14 */
    word BIT15       :1;                                       /* Timer Count Register Bit 15 */
  } Bits;
} NB_TCNTSTR;
extern volatile NB_TCNTSTR _NB_TCNT @(REG_BASE + 0x00000324UL);
#define NB_TCNT                         _NB_TCNT.Word
#define NB_TCNT_BIT0                    _NB_TCNT.Bits.BIT0
#define NB_TCNT_BIT1                    _NB_TCNT.Bits.BIT1
#define NB_TCNT_BIT2                    _NB_TCNT.Bits.BIT2
#define NB_TCNT_BIT3                    _NB_TCNT.Bits.BIT3
#define NB_TCNT_BIT4                    _NB_TCNT.Bits.BIT4
#define NB_TCNT_BIT5                    _NB_TCNT.Bits.BIT5
#define NB_TCNT_BIT6                    _NB_TCNT.Bits.BIT6
#define NB_TCNT_BIT7                    _NB_TCNT.Bits.BIT7
#define NB_TCNT_BIT8                    _NB_TCNT.Bits.BIT8
#define NB_TCNT_BIT9                    _NB_TCNT.Bits.BIT9
#define NB_TCNT_BIT10                   _NB_TCNT.Bits.BIT10
#define NB_TCNT_BIT11                   _NB_TCNT.Bits.BIT11
#define NB_TCNT_BIT12                   _NB_TCNT.Bits.BIT12
#define NB_TCNT_BIT13                   _NB_TCNT.Bits.BIT13
#define NB_TCNT_BIT14                   _NB_TCNT.Bits.BIT14
#define NB_TCNT_BIT15                   _NB_TCNT.Bits.BIT15

#define NB_TCNT_BIT0_MASK               1U
#define NB_TCNT_BIT1_MASK               2U
#define NB_TCNT_BIT2_MASK               4U
#define NB_TCNT_BIT3_MASK               8U
#define NB_TCNT_BIT4_MASK               16U
#define NB_TCNT_BIT5_MASK               32U
#define NB_TCNT_BIT6_MASK               64U
#define NB_TCNT_BIT7_MASK               128U
#define NB_TCNT_BIT8_MASK               256U
#define NB_TCNT_BIT9_MASK               512U
#define NB_TCNT_BIT10_MASK              1024U
#define NB_TCNT_BIT11_MASK              2048U
#define NB_TCNT_BIT12_MASK              4096U
#define NB_TCNT_BIT13_MASK              8192U
#define NB_TCNT_BIT14_MASK              16384U
#define NB_TCNT_BIT15_MASK              32768U


/*** NB_TSCR1 - Timer System Control Register1; 0x00000326 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte             :1; 
    byte             :1; 
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} NB_TSCR1STR;
extern volatile NB_TSCR1STR _NB_TSCR1 @(REG_BASE + 0x00000326UL);
#define NB_TSCR1                        _NB_TSCR1.Byte
#define NB_TSCR1_TFFCA                  _NB_TSCR1.Bits.TFFCA
#define NB_TSCR1_TEN                    _NB_TSCR1.Bits.TEN

#define NB_TSCR1_TFFCA_MASK             16U
#define NB_TSCR1_TEN_MASK               128U


/*** NB_TTOV - Timer Toggle On Overflow Register; 0x00000327 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTOV  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_TTOVSTR;
extern volatile NB_TTOVSTR _NB_TTOV @(REG_BASE + 0x00000327UL);
#define NB_TTOV                         _NB_TTOV.Byte
#define NB_TTOV_TOV0                    _NB_TTOV.Bits.TOV0
#define NB_TTOV_TOV1                    _NB_TTOV.Bits.TOV1
#define NB_TTOV_TOV2                    _NB_TTOV.Bits.TOV2
#define NB_TTOV_TOV3                    _NB_TTOV.Bits.TOV3
#define NB_TTOV_TOV                     _NB_TTOV.MergedBits.grpTOV

#define NB_TTOV_TOV0_MASK               1U
#define NB_TTOV_TOV1_MASK               2U
#define NB_TTOV_TOV2_MASK               4U
#define NB_TTOV_TOV3_MASK               8U
#define NB_TTOV_TOV_MASK                15U
#define NB_TTOV_TOV_BITNUM              0U


/*** NB_TCTL1 - Timer Control Register 1; 0x00000328 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Lecel Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} NB_TCTL1STR;
extern volatile NB_TCTL1STR _NB_TCTL1 @(REG_BASE + 0x00000328UL);
#define NB_TCTL1                        _NB_TCTL1.Byte
#define NB_TCTL1_OL0                    _NB_TCTL1.Bits.OL0
#define NB_TCTL1_OM0                    _NB_TCTL1.Bits.OM0
#define NB_TCTL1_OL1                    _NB_TCTL1.Bits.OL1
#define NB_TCTL1_OM1                    _NB_TCTL1.Bits.OM1
#define NB_TCTL1_OL2                    _NB_TCTL1.Bits.OL2
#define NB_TCTL1_OM2                    _NB_TCTL1.Bits.OM2
#define NB_TCTL1_OL3                    _NB_TCTL1.Bits.OL3
#define NB_TCTL1_OM3                    _NB_TCTL1.Bits.OM3

#define NB_TCTL1_OL0_MASK               1U
#define NB_TCTL1_OM0_MASK               2U
#define NB_TCTL1_OL1_MASK               4U
#define NB_TCTL1_OM1_MASK               8U
#define NB_TCTL1_OL2_MASK               16U
#define NB_TCTL1_OM2_MASK               32U
#define NB_TCTL1_OL3_MASK               64U
#define NB_TCTL1_OM3_MASK               128U


/*** NB_TCTL2 - Timer Control Register 2; 0x00000329 ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge 0 Control A */
    byte EDG0B       :1;                                       /* Input Capture Edge 0 Control B */
    byte EDG1A       :1;                                       /* Input Capture Edge 1 Control A */
    byte EDG1B       :1;                                       /* Input Capture Edge 1 Control B */
    byte EDG2A       :1;                                       /* Input Capture Edge 2 Control A */
    byte EDG2B       :1;                                       /* Input Capture Edge 2 Control B */
    byte EDG3A       :1;                                       /* Input Capture Edge 3 Control A */
    byte EDG3B       :1;                                       /* Input Capture Edge 3 Control B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} NB_TCTL2STR;
extern volatile NB_TCTL2STR _NB_TCTL2 @(REG_BASE + 0x00000329UL);
#define NB_TCTL2                        _NB_TCTL2.Byte
#define NB_TCTL2_EDG0A                  _NB_TCTL2.Bits.EDG0A
#define NB_TCTL2_EDG0B                  _NB_TCTL2.Bits.EDG0B
#define NB_TCTL2_EDG1A                  _NB_TCTL2.Bits.EDG1A
#define NB_TCTL2_EDG1B                  _NB_TCTL2.Bits.EDG1B
#define NB_TCTL2_EDG2A                  _NB_TCTL2.Bits.EDG2A
#define NB_TCTL2_EDG2B                  _NB_TCTL2.Bits.EDG2B
#define NB_TCTL2_EDG3A                  _NB_TCTL2.Bits.EDG3A
#define NB_TCTL2_EDG3B                  _NB_TCTL2.Bits.EDG3B
#define NB_TCTL2_EDG0x                  _NB_TCTL2.MergedBits.grpEDG0x
#define NB_TCTL2_EDG1x                  _NB_TCTL2.MergedBits.grpEDG1x
#define NB_TCTL2_EDG2x                  _NB_TCTL2.MergedBits.grpEDG2x
#define NB_TCTL2_EDG3x                  _NB_TCTL2.MergedBits.grpEDG3x

#define NB_TCTL2_EDG0A_MASK             1U
#define NB_TCTL2_EDG0B_MASK             2U
#define NB_TCTL2_EDG1A_MASK             4U
#define NB_TCTL2_EDG1B_MASK             8U
#define NB_TCTL2_EDG2A_MASK             16U
#define NB_TCTL2_EDG2B_MASK             32U
#define NB_TCTL2_EDG3A_MASK             64U
#define NB_TCTL2_EDG3B_MASK             128U
#define NB_TCTL2_EDG0x_MASK             3U
#define NB_TCTL2_EDG0x_BITNUM           0U
#define NB_TCTL2_EDG1x_MASK             12U
#define NB_TCTL2_EDG1x_BITNUM           2U
#define NB_TCTL2_EDG2x_MASK             48U
#define NB_TCTL2_EDG2x_BITNUM           4U
#define NB_TCTL2_EDG3x_MASK             192U
#define NB_TCTL2_EDG3x_BITNUM           6U


/*** NB_TIE - Timer Interrupt Enable Register; 0x0000032A ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_TIESTR;
extern volatile NB_TIESTR _NB_TIE @(REG_BASE + 0x0000032AUL);
#define NB_TIE                          _NB_TIE.Byte
#define NB_TIE_C0I                      _NB_TIE.Bits.C0I
#define NB_TIE_C1I                      _NB_TIE.Bits.C1I
#define NB_TIE_C2I                      _NB_TIE.Bits.C2I
#define NB_TIE_C3I                      _NB_TIE.Bits.C3I

#define NB_TIE_C0I_MASK                 1U
#define NB_TIE_C1I_MASK                 2U
#define NB_TIE_C2I_MASK                 4U
#define NB_TIE_C3I_MASK                 8U


/*** NB_TSCR2 - Timer System Control Register 2; 0x0000032B ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_TSCR2STR;
extern volatile NB_TSCR2STR _NB_TSCR2 @(REG_BASE + 0x0000032BUL);
#define NB_TSCR2                        _NB_TSCR2.Byte
#define NB_TSCR2_PR0                    _NB_TSCR2.Bits.PR0
#define NB_TSCR2_PR1                    _NB_TSCR2.Bits.PR1
#define NB_TSCR2_PR2                    _NB_TSCR2.Bits.PR2
#define NB_TSCR2_TCRE                   _NB_TSCR2.Bits.TCRE
#define NB_TSCR2_TOI                    _NB_TSCR2.Bits.TOI
#define NB_TSCR2_PR                     _NB_TSCR2.MergedBits.grpPR

#define NB_TSCR2_PR0_MASK               1U
#define NB_TSCR2_PR1_MASK               2U
#define NB_TSCR2_PR2_MASK               4U
#define NB_TSCR2_TCRE_MASK              8U
#define NB_TSCR2_TOI_MASK               128U
#define NB_TSCR2_PR_MASK                7U
#define NB_TSCR2_PR_BITNUM              0U


/*** NB_TFLG1 - Main Timer Interrupt Flag 1; 0x0000032C ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_TFLG1STR;
extern volatile NB_TFLG1STR _NB_TFLG1 @(REG_BASE + 0x0000032CUL);
#define NB_TFLG1                        _NB_TFLG1.Byte
#define NB_TFLG1_C0F                    _NB_TFLG1.Bits.C0F
#define NB_TFLG1_C1F                    _NB_TFLG1.Bits.C1F
#define NB_TFLG1_C2F                    _NB_TFLG1.Bits.C2F
#define NB_TFLG1_C3F                    _NB_TFLG1.Bits.C3F

#define NB_TFLG1_C0F_MASK               1U
#define NB_TFLG1_C1F_MASK               2U
#define NB_TFLG1_C2F_MASK               4U
#define NB_TFLG1_C3F_MASK               8U


/*** NB_TFLG2 - Main Timer Interrupt Flag 2; 0x0000032D ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} NB_TFLG2STR;
extern volatile NB_TFLG2STR _NB_TFLG2 @(REG_BASE + 0x0000032DUL);
#define NB_TFLG2                        _NB_TFLG2.Byte
#define NB_TFLG2_TOF                    _NB_TFLG2.Bits.TOF

#define NB_TFLG2_TOF_MASK               128U


/*** NB_TC0 - Timer Input Capture/Output Compare Register 0; 0x0000032E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x0000032E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 15 */
      } Bits;
    } NB_TC0HiSTR;
    #define NB_TC0Hi                    _NB_TC0.Overlap_STR.NB_TC0HiSTR.Byte
    #define NB_TC0Hi_BIT8               _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT8
    #define NB_TC0Hi_BIT9               _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT9
    #define NB_TC0Hi_BIT10              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT10
    #define NB_TC0Hi_BIT11              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT11
    #define NB_TC0Hi_BIT12              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT12
    #define NB_TC0Hi_BIT13              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT13
    #define NB_TC0Hi_BIT14              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT14
    #define NB_TC0Hi_BIT15              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT15
    
    #define NB_TC0Hi_BIT8_MASK          1U
    #define NB_TC0Hi_BIT9_MASK          2U
    #define NB_TC0Hi_BIT10_MASK         4U
    #define NB_TC0Hi_BIT11_MASK         8U
    #define NB_TC0Hi_BIT12_MASK         16U
    #define NB_TC0Hi_BIT13_MASK         32U
    #define NB_TC0Hi_BIT14_MASK         64U
    #define NB_TC0Hi_BIT15_MASK         128U
    

    /*** NB_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x0000032F ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 7 */
      } Bits;
    } NB_TC0LoSTR;
    #define NB_TC0Lo                    _NB_TC0.Overlap_STR.NB_TC0LoSTR.Byte
    #define NB_TC0Lo_BIT0               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT0
    #define NB_TC0Lo_BIT1               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT1
    #define NB_TC0Lo_BIT2               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT2
    #define NB_TC0Lo_BIT3               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT3
    #define NB_TC0Lo_BIT4               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT4
    #define NB_TC0Lo_BIT5               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT5
    #define NB_TC0Lo_BIT6               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT6
    #define NB_TC0Lo_BIT7               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT7
    
    #define NB_TC0Lo_BIT0_MASK          1U
    #define NB_TC0Lo_BIT1_MASK          2U
    #define NB_TC0Lo_BIT2_MASK          4U
    #define NB_TC0Lo_BIT3_MASK          8U
    #define NB_TC0Lo_BIT4_MASK          16U
    #define NB_TC0Lo_BIT5_MASK          32U
    #define NB_TC0Lo_BIT6_MASK          64U
    #define NB_TC0Lo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 15 */
  } Bits;
} NB_TC0STR;
extern volatile NB_TC0STR _NB_TC0 @(REG_BASE + 0x0000032EUL);
#define NB_TC0                          _NB_TC0.Word
#define NB_TC0_BIT0                     _NB_TC0.Bits.BIT0
#define NB_TC0_BIT1                     _NB_TC0.Bits.BIT1
#define NB_TC0_BIT2                     _NB_TC0.Bits.BIT2
#define NB_TC0_BIT3                     _NB_TC0.Bits.BIT3
#define NB_TC0_BIT4                     _NB_TC0.Bits.BIT4
#define NB_TC0_BIT5                     _NB_TC0.Bits.BIT5
#define NB_TC0_BIT6                     _NB_TC0.Bits.BIT6
#define NB_TC0_BIT7                     _NB_TC0.Bits.BIT7
#define NB_TC0_BIT8                     _NB_TC0.Bits.BIT8
#define NB_TC0_BIT9                     _NB_TC0.Bits.BIT9
#define NB_TC0_BIT10                    _NB_TC0.Bits.BIT10
#define NB_TC0_BIT11                    _NB_TC0.Bits.BIT11
#define NB_TC0_BIT12                    _NB_TC0.Bits.BIT12
#define NB_TC0_BIT13                    _NB_TC0.Bits.BIT13
#define NB_TC0_BIT14                    _NB_TC0.Bits.BIT14
#define NB_TC0_BIT15                    _NB_TC0.Bits.BIT15
/* NB_TC_ARR: Access 4 NB_TCx registers in an array */
#define NB_TC_ARR                       ((volatile word *) &NB_TC0)

#define NB_TC0_BIT0_MASK                1U
#define NB_TC0_BIT1_MASK                2U
#define NB_TC0_BIT2_MASK                4U
#define NB_TC0_BIT3_MASK                8U
#define NB_TC0_BIT4_MASK                16U
#define NB_TC0_BIT5_MASK                32U
#define NB_TC0_BIT6_MASK                64U
#define NB_TC0_BIT7_MASK                128U
#define NB_TC0_BIT8_MASK                256U
#define NB_TC0_BIT9_MASK                512U
#define NB_TC0_BIT10_MASK               1024U
#define NB_TC0_BIT11_MASK               2048U
#define NB_TC0_BIT12_MASK               4096U
#define NB_TC0_BIT13_MASK               8192U
#define NB_TC0_BIT14_MASK               16384U
#define NB_TC0_BIT15_MASK               32768U


/*** NB_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000330 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000330 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 15 */
      } Bits;
    } NB_TC1HiSTR;
    #define NB_TC1Hi                    _NB_TC1.Overlap_STR.NB_TC1HiSTR.Byte
    #define NB_TC1Hi_BIT8               _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT8
    #define NB_TC1Hi_BIT9               _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT9
    #define NB_TC1Hi_BIT10              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT10
    #define NB_TC1Hi_BIT11              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT11
    #define NB_TC1Hi_BIT12              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT12
    #define NB_TC1Hi_BIT13              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT13
    #define NB_TC1Hi_BIT14              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT14
    #define NB_TC1Hi_BIT15              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT15
    
    #define NB_TC1Hi_BIT8_MASK          1U
    #define NB_TC1Hi_BIT9_MASK          2U
    #define NB_TC1Hi_BIT10_MASK         4U
    #define NB_TC1Hi_BIT11_MASK         8U
    #define NB_TC1Hi_BIT12_MASK         16U
    #define NB_TC1Hi_BIT13_MASK         32U
    #define NB_TC1Hi_BIT14_MASK         64U
    #define NB_TC1Hi_BIT15_MASK         128U
    

    /*** NB_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000331 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 7 */
      } Bits;
    } NB_TC1LoSTR;
    #define NB_TC1Lo                    _NB_TC1.Overlap_STR.NB_TC1LoSTR.Byte
    #define NB_TC1Lo_BIT0               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT0
    #define NB_TC1Lo_BIT1               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT1
    #define NB_TC1Lo_BIT2               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT2
    #define NB_TC1Lo_BIT3               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT3
    #define NB_TC1Lo_BIT4               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT4
    #define NB_TC1Lo_BIT5               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT5
    #define NB_TC1Lo_BIT6               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT6
    #define NB_TC1Lo_BIT7               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT7
    
    #define NB_TC1Lo_BIT0_MASK          1U
    #define NB_TC1Lo_BIT1_MASK          2U
    #define NB_TC1Lo_BIT2_MASK          4U
    #define NB_TC1Lo_BIT3_MASK          8U
    #define NB_TC1Lo_BIT4_MASK          16U
    #define NB_TC1Lo_BIT5_MASK          32U
    #define NB_TC1Lo_BIT6_MASK          64U
    #define NB_TC1Lo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 15 */
  } Bits;
} NB_TC1STR;
extern volatile NB_TC1STR _NB_TC1 @(REG_BASE + 0x00000330UL);
#define NB_TC1                          _NB_TC1.Word
#define NB_TC1_BIT0                     _NB_TC1.Bits.BIT0
#define NB_TC1_BIT1                     _NB_TC1.Bits.BIT1
#define NB_TC1_BIT2                     _NB_TC1.Bits.BIT2
#define NB_TC1_BIT3                     _NB_TC1.Bits.BIT3
#define NB_TC1_BIT4                     _NB_TC1.Bits.BIT4
#define NB_TC1_BIT5                     _NB_TC1.Bits.BIT5
#define NB_TC1_BIT6                     _NB_TC1.Bits.BIT6
#define NB_TC1_BIT7                     _NB_TC1.Bits.BIT7
#define NB_TC1_BIT8                     _NB_TC1.Bits.BIT8
#define NB_TC1_BIT9                     _NB_TC1.Bits.BIT9
#define NB_TC1_BIT10                    _NB_TC1.Bits.BIT10
#define NB_TC1_BIT11                    _NB_TC1.Bits.BIT11
#define NB_TC1_BIT12                    _NB_TC1.Bits.BIT12
#define NB_TC1_BIT13                    _NB_TC1.Bits.BIT13
#define NB_TC1_BIT14                    _NB_TC1.Bits.BIT14
#define NB_TC1_BIT15                    _NB_TC1.Bits.BIT15

#define NB_TC1_BIT0_MASK                1U
#define NB_TC1_BIT1_MASK                2U
#define NB_TC1_BIT2_MASK                4U
#define NB_TC1_BIT3_MASK                8U
#define NB_TC1_BIT4_MASK                16U
#define NB_TC1_BIT5_MASK                32U
#define NB_TC1_BIT6_MASK                64U
#define NB_TC1_BIT7_MASK                128U
#define NB_TC1_BIT8_MASK                256U
#define NB_TC1_BIT9_MASK                512U
#define NB_TC1_BIT10_MASK               1024U
#define NB_TC1_BIT11_MASK               2048U
#define NB_TC1_BIT12_MASK               4096U
#define NB_TC1_BIT13_MASK               8192U
#define NB_TC1_BIT14_MASK               16384U
#define NB_TC1_BIT15_MASK               32768U


/*** NB_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000332 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000332 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 15 */
      } Bits;
    } NB_TC2HiSTR;
    #define NB_TC2Hi                    _NB_TC2.Overlap_STR.NB_TC2HiSTR.Byte
    #define NB_TC2Hi_BIT8               _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT8
    #define NB_TC2Hi_BIT9               _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT9
    #define NB_TC2Hi_BIT10              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT10
    #define NB_TC2Hi_BIT11              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT11
    #define NB_TC2Hi_BIT12              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT12
    #define NB_TC2Hi_BIT13              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT13
    #define NB_TC2Hi_BIT14              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT14
    #define NB_TC2Hi_BIT15              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT15
    
    #define NB_TC2Hi_BIT8_MASK          1U
    #define NB_TC2Hi_BIT9_MASK          2U
    #define NB_TC2Hi_BIT10_MASK         4U
    #define NB_TC2Hi_BIT11_MASK         8U
    #define NB_TC2Hi_BIT12_MASK         16U
    #define NB_TC2Hi_BIT13_MASK         32U
    #define NB_TC2Hi_BIT14_MASK         64U
    #define NB_TC2Hi_BIT15_MASK         128U
    

    /*** NB_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000333 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 7 */
      } Bits;
    } NB_TC2LoSTR;
    #define NB_TC2Lo                    _NB_TC2.Overlap_STR.NB_TC2LoSTR.Byte
    #define NB_TC2Lo_BIT0               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT0
    #define NB_TC2Lo_BIT1               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT1
    #define NB_TC2Lo_BIT2               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT2
    #define NB_TC2Lo_BIT3               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT3
    #define NB_TC2Lo_BIT4               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT4
    #define NB_TC2Lo_BIT5               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT5
    #define NB_TC2Lo_BIT6               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT6
    #define NB_TC2Lo_BIT7               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT7
    
    #define NB_TC2Lo_BIT0_MASK          1U
    #define NB_TC2Lo_BIT1_MASK          2U
    #define NB_TC2Lo_BIT2_MASK          4U
    #define NB_TC2Lo_BIT3_MASK          8U
    #define NB_TC2Lo_BIT4_MASK          16U
    #define NB_TC2Lo_BIT5_MASK          32U
    #define NB_TC2Lo_BIT6_MASK          64U
    #define NB_TC2Lo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 15 */
  } Bits;
} NB_TC2STR;
extern volatile NB_TC2STR _NB_TC2 @(REG_BASE + 0x00000332UL);
#define NB_TC2                          _NB_TC2.Word
#define NB_TC2_BIT0                     _NB_TC2.Bits.BIT0
#define NB_TC2_BIT1                     _NB_TC2.Bits.BIT1
#define NB_TC2_BIT2                     _NB_TC2.Bits.BIT2
#define NB_TC2_BIT3                     _NB_TC2.Bits.BIT3
#define NB_TC2_BIT4                     _NB_TC2.Bits.BIT4
#define NB_TC2_BIT5                     _NB_TC2.Bits.BIT5
#define NB_TC2_BIT6                     _NB_TC2.Bits.BIT6
#define NB_TC2_BIT7                     _NB_TC2.Bits.BIT7
#define NB_TC2_BIT8                     _NB_TC2.Bits.BIT8
#define NB_TC2_BIT9                     _NB_TC2.Bits.BIT9
#define NB_TC2_BIT10                    _NB_TC2.Bits.BIT10
#define NB_TC2_BIT11                    _NB_TC2.Bits.BIT11
#define NB_TC2_BIT12                    _NB_TC2.Bits.BIT12
#define NB_TC2_BIT13                    _NB_TC2.Bits.BIT13
#define NB_TC2_BIT14                    _NB_TC2.Bits.BIT14
#define NB_TC2_BIT15                    _NB_TC2.Bits.BIT15

#define NB_TC2_BIT0_MASK                1U
#define NB_TC2_BIT1_MASK                2U
#define NB_TC2_BIT2_MASK                4U
#define NB_TC2_BIT3_MASK                8U
#define NB_TC2_BIT4_MASK                16U
#define NB_TC2_BIT5_MASK                32U
#define NB_TC2_BIT6_MASK                64U
#define NB_TC2_BIT7_MASK                128U
#define NB_TC2_BIT8_MASK                256U
#define NB_TC2_BIT9_MASK                512U
#define NB_TC2_BIT10_MASK               1024U
#define NB_TC2_BIT11_MASK               2048U
#define NB_TC2_BIT12_MASK               4096U
#define NB_TC2_BIT13_MASK               8192U
#define NB_TC2_BIT14_MASK               16384U
#define NB_TC2_BIT15_MASK               32768U


/*** NB_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000334 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000334 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 15 */
      } Bits;
    } NB_TC3HiSTR;
    #define NB_TC3Hi                    _NB_TC3.Overlap_STR.NB_TC3HiSTR.Byte
    #define NB_TC3Hi_BIT8               _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT8
    #define NB_TC3Hi_BIT9               _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT9
    #define NB_TC3Hi_BIT10              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT10
    #define NB_TC3Hi_BIT11              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT11
    #define NB_TC3Hi_BIT12              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT12
    #define NB_TC3Hi_BIT13              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT13
    #define NB_TC3Hi_BIT14              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT14
    #define NB_TC3Hi_BIT15              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT15
    
    #define NB_TC3Hi_BIT8_MASK          1U
    #define NB_TC3Hi_BIT9_MASK          2U
    #define NB_TC3Hi_BIT10_MASK         4U
    #define NB_TC3Hi_BIT11_MASK         8U
    #define NB_TC3Hi_BIT12_MASK         16U
    #define NB_TC3Hi_BIT13_MASK         32U
    #define NB_TC3Hi_BIT14_MASK         64U
    #define NB_TC3Hi_BIT15_MASK         128U
    

    /*** NB_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000335 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 7 */
      } Bits;
    } NB_TC3LoSTR;
    #define NB_TC3Lo                    _NB_TC3.Overlap_STR.NB_TC3LoSTR.Byte
    #define NB_TC3Lo_BIT0               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT0
    #define NB_TC3Lo_BIT1               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT1
    #define NB_TC3Lo_BIT2               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT2
    #define NB_TC3Lo_BIT3               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT3
    #define NB_TC3Lo_BIT4               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT4
    #define NB_TC3Lo_BIT5               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT5
    #define NB_TC3Lo_BIT6               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT6
    #define NB_TC3Lo_BIT7               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT7
    
    #define NB_TC3Lo_BIT0_MASK          1U
    #define NB_TC3Lo_BIT1_MASK          2U
    #define NB_TC3Lo_BIT2_MASK          4U
    #define NB_TC3Lo_BIT3_MASK          8U
    #define NB_TC3Lo_BIT4_MASK          16U
    #define NB_TC3Lo_BIT5_MASK          32U
    #define NB_TC3Lo_BIT6_MASK          64U
    #define NB_TC3Lo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 15 */
  } Bits;
} NB_TC3STR;
extern volatile NB_TC3STR _NB_TC3 @(REG_BASE + 0x00000334UL);
#define NB_TC3                          _NB_TC3.Word
#define NB_TC3_BIT0                     _NB_TC3.Bits.BIT0
#define NB_TC3_BIT1                     _NB_TC3.Bits.BIT1
#define NB_TC3_BIT2                     _NB_TC3.Bits.BIT2
#define NB_TC3_BIT3                     _NB_TC3.Bits.BIT3
#define NB_TC3_BIT4                     _NB_TC3.Bits.BIT4
#define NB_TC3_BIT5                     _NB_TC3.Bits.BIT5
#define NB_TC3_BIT6                     _NB_TC3.Bits.BIT6
#define NB_TC3_BIT7                     _NB_TC3.Bits.BIT7
#define NB_TC3_BIT8                     _NB_TC3.Bits.BIT8
#define NB_TC3_BIT9                     _NB_TC3.Bits.BIT9
#define NB_TC3_BIT10                    _NB_TC3.Bits.BIT10
#define NB_TC3_BIT11                    _NB_TC3.Bits.BIT11
#define NB_TC3_BIT12                    _NB_TC3.Bits.BIT12
#define NB_TC3_BIT13                    _NB_TC3.Bits.BIT13
#define NB_TC3_BIT14                    _NB_TC3.Bits.BIT14
#define NB_TC3_BIT15                    _NB_TC3.Bits.BIT15

#define NB_TC3_BIT0_MASK                1U
#define NB_TC3_BIT1_MASK                2U
#define NB_TC3_BIT2_MASK                4U
#define NB_TC3_BIT3_MASK                8U
#define NB_TC3_BIT4_MASK                16U
#define NB_TC3_BIT5_MASK                32U
#define NB_TC3_BIT6_MASK                64U
#define NB_TC3_BIT7_MASK                128U
#define NB_TC3_BIT8_MASK                256U
#define NB_TC3_BIT9_MASK                512U
#define NB_TC3_BIT10_MASK               1024U
#define NB_TC3_BIT11_MASK               2048U
#define NB_TC3_BIT12_MASK               4096U
#define NB_TC3_BIT13_MASK               8192U
#define NB_TC3_BIT14_MASK               16384U
#define NB_TC3_BIT15_MASK               32768U


/*** NB_LTC_CTL - Life Time Counter control register; 0x00000338 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LTC_CTLH - Life Time Counter control register high; 0x00000338 ***/
    union {
      byte Byte;
      struct {
        byte LTCEM       :1;                                       /* Life Time Counter Enable Mask */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte LTCIEM      :1;                                       /* Life Time Counter Interrupt Enable Mask */
      } Bits;
    } NB_LTC_CTLHSTR;
    #define NB_LTC_CTLH                 _NB_LTC_CTL.Overlap_STR.NB_LTC_CTLHSTR.Byte
    #define NB_LTC_CTLH_LTCEM           _NB_LTC_CTL.Overlap_STR.NB_LTC_CTLHSTR.Bits.LTCEM
    #define NB_LTC_CTLH_LTCIEM          _NB_LTC_CTL.Overlap_STR.NB_LTC_CTLHSTR.Bits.LTCIEM
    
    #define NB_LTC_CTLH_LTCEM_MASK      1U
    #define NB_LTC_CTLH_LTCIEM_MASK     128U
    

    /*** NB_LTC_CTLL - Life Time Counter control register low; 0x00000339 ***/
    union {
      byte Byte;
      struct {
        byte LTCE        :1;                                       /* Life Time Counter Enable */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte LTCIE       :1;                                       /* Life Time Counter Interrupt Enable */
      } Bits;
    } NB_LTC_CTLLSTR;
    #define NB_LTC_CTLL                 _NB_LTC_CTL.Overlap_STR.NB_LTC_CTLLSTR.Byte
    #define NB_LTC_CTLL_LTCE            _NB_LTC_CTL.Overlap_STR.NB_LTC_CTLLSTR.Bits.LTCE
    #define NB_LTC_CTLL_LTCIE           _NB_LTC_CTL.Overlap_STR.NB_LTC_CTLLSTR.Bits.LTCIE
    
    #define NB_LTC_CTLL_LTCE_MASK       1U
    #define NB_LTC_CTLL_LTCIE_MASK      128U
    
  } Overlap_STR;

  struct {
    word LTCE        :1;                                       /* Life Time Counter Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word LTCIE       :1;                                       /* Life Time Counter Interrupt Enable */
    word LTCEM       :1;                                       /* Life Time Counter Enable Mask */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word LTCIEM      :1;                                       /* Life Time Counter Interrupt Enable Mask */
  } Bits;
} NB_LTC_CTLSTR;
extern volatile NB_LTC_CTLSTR _NB_LTC_CTL @(REG_BASE + 0x00000338UL);
#define NB_LTC_CTL                      _NB_LTC_CTL.Word
#define NB_LTC_CTL_LTCE                 _NB_LTC_CTL.Bits.LTCE
#define NB_LTC_CTL_LTCIE                _NB_LTC_CTL.Bits.LTCIE
#define NB_LTC_CTL_LTCEM                _NB_LTC_CTL.Bits.LTCEM
#define NB_LTC_CTL_LTCIEM               _NB_LTC_CTL.Bits.LTCIEM

#define NB_LTC_CTL_LTCE_MASK            1U
#define NB_LTC_CTL_LTCIE_MASK           128U
#define NB_LTC_CTL_LTCEM_MASK           256U
#define NB_LTC_CTL_LTCIEM_MASK          32768U


/*** NB_LTC_SR - Life Time Counter status register; 0x0000033A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LTCOF       :1;                                       /* Life Time Counter Overflow Flag */
  } Bits;
} NB_LTC_SRSTR;
extern volatile NB_LTC_SRSTR _NB_LTC_SR @(REG_BASE + 0x0000033AUL);
#define NB_LTC_SR                       _NB_LTC_SR.Byte
#define NB_LTC_SR_LTCOF                 _NB_LTC_SR.Bits.LTCOF

#define NB_LTC_SR_LTCOF_MASK            128U


/*** NB_LTC_CNT1 - Life Time Counter Register 1; 0x0000033C ***/
typedef union {
  word Word;
} NB_LTC_CNT1STR;
extern volatile NB_LTC_CNT1STR _NB_LTC_CNT1 @(REG_BASE + 0x0000033CUL);
#define NB_LTC_CNT1                     _NB_LTC_CNT1.Word


/*** NB_LTC_CNT0 - Life Time Counter Register 0; 0x0000033E ***/
typedef union {
  word Word;
} NB_LTC_CNT0STR;
extern volatile NB_LTC_CNT0STR _NB_LTC_CNT0 @(REG_BASE + 0x0000033EUL);
#define NB_LTC_CNT0                     _NB_LTC_CNT0.Word


/*** NB_GPIO_CTL - GPIO control register; 0x00000340 ***/
typedef union {
  word Word;
  struct {
    word PE0         :1;                                       /* Port 0 Enable */
    word PE1         :1;                                       /* Port 1 Enable */
    word PE2         :1;                                       /* Port 2 Enable */
    word PE3         :1;                                       /* Port 3 Enable */
    word DIR0        :1;                                       /* Data Direction PTB0 */
    word DIR1        :1;                                       /* Data Direction PTB1 */
    word DIR2        :1;                                       /* Data Direction PTB2 */
    word             :1; 
    word PE0M        :1;                                       /* Port 0 Enable - Mask */
    word PE1M        :1;                                       /* Port 1 Enable - Mask */
    word PE2M        :1;                                       /* Port 2 Enable - Mask */
    word PE3M        :1;                                       /* Port 3 Enable - Mask */
    word DIR0M       :1;                                       /* Data Direction PTB0 - Mask */
    word DIR1M       :1;                                       /* Data Direction PTB1 - Mask */
    word DIR2M       :1;                                       /* Data Direction PTB2 - Mask */
    word             :1; 
  } Bits;
  struct {
    word grpPE   :4;
    word grpDIR  :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} NB_GPIO_CTLSTR;
extern volatile NB_GPIO_CTLSTR _NB_GPIO_CTL @(REG_BASE + 0x00000340UL);
#define NB_GPIO_CTL                     _NB_GPIO_CTL.Word
#define NB_GPIO_CTL_PE0                 _NB_GPIO_CTL.Bits.PE0
#define NB_GPIO_CTL_PE1                 _NB_GPIO_CTL.Bits.PE1
#define NB_GPIO_CTL_PE2                 _NB_GPIO_CTL.Bits.PE2
#define NB_GPIO_CTL_PE3                 _NB_GPIO_CTL.Bits.PE3
#define NB_GPIO_CTL_DIR0                _NB_GPIO_CTL.Bits.DIR0
#define NB_GPIO_CTL_DIR1                _NB_GPIO_CTL.Bits.DIR1
#define NB_GPIO_CTL_DIR2                _NB_GPIO_CTL.Bits.DIR2
#define NB_GPIO_CTL_PE0M                _NB_GPIO_CTL.Bits.PE0M
#define NB_GPIO_CTL_PE1M                _NB_GPIO_CTL.Bits.PE1M
#define NB_GPIO_CTL_PE2M                _NB_GPIO_CTL.Bits.PE2M
#define NB_GPIO_CTL_PE3M                _NB_GPIO_CTL.Bits.PE3M
#define NB_GPIO_CTL_DIR0M               _NB_GPIO_CTL.Bits.DIR0M
#define NB_GPIO_CTL_DIR1M               _NB_GPIO_CTL.Bits.DIR1M
#define NB_GPIO_CTL_DIR2M               _NB_GPIO_CTL.Bits.DIR2M
#define NB_GPIO_CTL_PE                  _NB_GPIO_CTL.MergedBits.grpPE
#define NB_GPIO_CTL_DIR                 _NB_GPIO_CTL.MergedBits.grpDIR

#define NB_GPIO_CTL_PE0_MASK            1U
#define NB_GPIO_CTL_PE1_MASK            2U
#define NB_GPIO_CTL_PE2_MASK            4U
#define NB_GPIO_CTL_PE3_MASK            8U
#define NB_GPIO_CTL_DIR0_MASK           16U
#define NB_GPIO_CTL_DIR1_MASK           32U
#define NB_GPIO_CTL_DIR2_MASK           64U
#define NB_GPIO_CTL_PE0M_MASK           256U
#define NB_GPIO_CTL_PE1M_MASK           512U
#define NB_GPIO_CTL_PE2M_MASK           1024U
#define NB_GPIO_CTL_PE3M_MASK           2048U
#define NB_GPIO_CTL_DIR0M_MASK          4096U
#define NB_GPIO_CTL_DIR1M_MASK          8192U
#define NB_GPIO_CTL_DIR2M_MASK          16384U
#define NB_GPIO_CTL_PE_MASK             15U
#define NB_GPIO_CTL_PE_BITNUM           0U
#define NB_GPIO_CTL_DIR_MASK            112U
#define NB_GPIO_CTL_DIR_BITNUM          4U


/*** NB_GPIO_PUC - GPIO pull up configuration; 0x00000342 ***/
typedef union {
  byte Byte;
  struct {
    byte PUE0        :1;                                       /* PTB0 Pull Up Enable */
    byte PUE1        :1;                                       /* PTB1 Pull Up Enable */
    byte PUE2        :1;                                       /* PTB2 Pull Up Enable */
    byte PDE3        :1;                                       /* PTB3 Pull Down Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPUE  :3;
    byte grpPDE_3 :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_GPIO_PUCSTR;
extern volatile NB_GPIO_PUCSTR _NB_GPIO_PUC @(REG_BASE + 0x00000342UL);
#define NB_GPIO_PUC                     _NB_GPIO_PUC.Byte
#define NB_GPIO_PUC_PUE0                _NB_GPIO_PUC.Bits.PUE0
#define NB_GPIO_PUC_PUE1                _NB_GPIO_PUC.Bits.PUE1
#define NB_GPIO_PUC_PUE2                _NB_GPIO_PUC.Bits.PUE2
#define NB_GPIO_PUC_PDE3                _NB_GPIO_PUC.Bits.PDE3
#define NB_GPIO_PUC_PUE                 _NB_GPIO_PUC.MergedBits.grpPUE

#define NB_GPIO_PUC_PUE0_MASK           1U
#define NB_GPIO_PUC_PUE1_MASK           2U
#define NB_GPIO_PUC_PUE2_MASK           4U
#define NB_GPIO_PUC_PDE3_MASK           8U
#define NB_GPIO_PUC_PUE_MASK            7U
#define NB_GPIO_PUC_PUE_BITNUM          0U


/*** NB_GPIO_DATA - GPIO port data register; 0x00000343 ***/
typedef union {
  byte Byte;
  struct {
    byte PD0         :1;                                       /* PTB0 Data Register */
    byte PD1         :1;                                       /* PTB1 Data Register */
    byte PD2         :1;                                       /* PTB2 Data Register */
    byte PD3         :1;                                       /* PTB3 Data Register */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPD   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_GPIO_DATASTR;
extern volatile NB_GPIO_DATASTR _NB_GPIO_DATA @(REG_BASE + 0x00000343UL);
#define NB_GPIO_DATA                    _NB_GPIO_DATA.Byte
#define NB_GPIO_DATA_PD0                _NB_GPIO_DATA.Bits.PD0
#define NB_GPIO_DATA_PD1                _NB_GPIO_DATA.Bits.PD1
#define NB_GPIO_DATA_PD2                _NB_GPIO_DATA.Bits.PD2
#define NB_GPIO_DATA_PD3                _NB_GPIO_DATA.Bits.PD3
#define NB_GPIO_DATA_PD                 _NB_GPIO_DATA.MergedBits.grpPD

#define NB_GPIO_DATA_PD0_MASK           1U
#define NB_GPIO_DATA_PD1_MASK           2U
#define NB_GPIO_DATA_PD2_MASK           4U
#define NB_GPIO_DATA_PD3_MASK           8U
#define NB_GPIO_DATA_PD_MASK            15U
#define NB_GPIO_DATA_PD_BITNUM          0U


/*** NB_GPIO_IN0 - Port 0 input configuration; 0x00000344 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LINTX       :1;                                       /* PTB0 - LIN Module Tx Input */
    byte SCIRX       :1;                                       /* PTB0 - SCI Module Rx Input */
    byte TCAP0       :1;                                       /* PTB0 - Timer Input Capture Channel 0 */
    byte TCAP1       :1;                                       /* PTB0 - Timer Input Capture Channel 1 */
    byte TCAP2       :1;                                       /* PTB0 - Timer Input Capture Channel 2 */
    byte TCAP3       :1;                                       /* PTB0 - Timer Input Capture Channel 3 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} NB_GPIO_IN0STR;
extern volatile NB_GPIO_IN0STR _NB_GPIO_IN0 @(REG_BASE + 0x00000344UL);
#define NB_GPIO_IN0                     _NB_GPIO_IN0.Byte
#define NB_GPIO_IN0_LINTX               _NB_GPIO_IN0.Bits.LINTX
#define NB_GPIO_IN0_SCIRX               _NB_GPIO_IN0.Bits.SCIRX
#define NB_GPIO_IN0_TCAP0               _NB_GPIO_IN0.Bits.TCAP0
#define NB_GPIO_IN0_TCAP1               _NB_GPIO_IN0.Bits.TCAP1
#define NB_GPIO_IN0_TCAP2               _NB_GPIO_IN0.Bits.TCAP2
#define NB_GPIO_IN0_TCAP3               _NB_GPIO_IN0.Bits.TCAP3
#define NB_GPIO_IN0_TCAP                _NB_GPIO_IN0.MergedBits.grpTCAP

#define NB_GPIO_IN0_LINTX_MASK          2U
#define NB_GPIO_IN0_SCIRX_MASK          4U
#define NB_GPIO_IN0_TCAP0_MASK          8U
#define NB_GPIO_IN0_TCAP1_MASK          16U
#define NB_GPIO_IN0_TCAP2_MASK          32U
#define NB_GPIO_IN0_TCAP3_MASK          64U
#define NB_GPIO_IN0_TCAP_MASK           120U
#define NB_GPIO_IN0_TCAP_BITNUM         3U


/*** NB_GPIO_OUT0 - Port 0 output configuration; 0x00000345 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBX0       :1;                                       /* PTB0 - Output Buffer Control */
    byte LINRX       :1;                                       /* PTB0 - LIN RX Output */
    byte SCITX       :1;                                       /* PTB0 - SCI TX Output */
    byte TCOMP0      :1;                                       /* PTB0 - Timer Channel 0 - Output Compare output */
    byte TCOMP1      :1;                                       /* PTB0 - Timer Channel 1 - Output Compare output */
    byte TCOMP2      :1;                                       /* PTB0 - Timer Channel 2 - Output Compare output */
    byte TCOMP3      :1;                                       /* PTB0 - Timer Channel 3 - Output Compare output */
    byte WKUP        :1;                                       /* PTB0 - Wake Up output */
  } Bits;
  struct {
    byte grpPTBX :1;
    byte         :1;
    byte         :1;
    byte grpTCOMP :4;
    byte         :1;
  } MergedBits;
} NB_GPIO_OUT0STR;
extern volatile NB_GPIO_OUT0STR _NB_GPIO_OUT0 @(REG_BASE + 0x00000345UL);
#define NB_GPIO_OUT0                    _NB_GPIO_OUT0.Byte
#define NB_GPIO_OUT0_PTBX0              _NB_GPIO_OUT0.Bits.PTBX0
#define NB_GPIO_OUT0_LINRX              _NB_GPIO_OUT0.Bits.LINRX
#define NB_GPIO_OUT0_SCITX              _NB_GPIO_OUT0.Bits.SCITX
#define NB_GPIO_OUT0_TCOMP0             _NB_GPIO_OUT0.Bits.TCOMP0
#define NB_GPIO_OUT0_TCOMP1             _NB_GPIO_OUT0.Bits.TCOMP1
#define NB_GPIO_OUT0_TCOMP2             _NB_GPIO_OUT0.Bits.TCOMP2
#define NB_GPIO_OUT0_TCOMP3             _NB_GPIO_OUT0.Bits.TCOMP3
#define NB_GPIO_OUT0_WKUP               _NB_GPIO_OUT0.Bits.WKUP
#define NB_GPIO_OUT0_TCOMP              _NB_GPIO_OUT0.MergedBits.grpTCOMP

#define NB_GPIO_OUT0_PTBX0_MASK         1U
#define NB_GPIO_OUT0_LINRX_MASK         2U
#define NB_GPIO_OUT0_SCITX_MASK         4U
#define NB_GPIO_OUT0_TCOMP0_MASK        8U
#define NB_GPIO_OUT0_TCOMP1_MASK        16U
#define NB_GPIO_OUT0_TCOMP2_MASK        32U
#define NB_GPIO_OUT0_TCOMP3_MASK        64U
#define NB_GPIO_OUT0_WKUP_MASK          128U
#define NB_GPIO_OUT0_TCOMP_MASK         120U
#define NB_GPIO_OUT0_TCOMP_BITNUM       3U


/*** NB_GPIO_IN1 - Port 1 input configuration; 0x00000346 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LINTX       :1;                                       /* PTB1 - LIN Module Tx Input */
    byte SCIRX       :1;                                       /* PTB1 - SCI Module Rx Input */
    byte TCAP0       :1;                                       /* PTB1 - Timer Input Capture Channel 0 */
    byte TCAP1       :1;                                       /* PTB1 - Timer Input Capture Channel 1 */
    byte TCAP2       :1;                                       /* PTB1 - Timer Input Capture Channel 2 */
    byte TCAP3       :1;                                       /* PTB1 - Timer Input Capture Channel 3 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} NB_GPIO_IN1STR;
extern volatile NB_GPIO_IN1STR _NB_GPIO_IN1 @(REG_BASE + 0x00000346UL);
#define NB_GPIO_IN1                     _NB_GPIO_IN1.Byte
#define NB_GPIO_IN1_LINTX               _NB_GPIO_IN1.Bits.LINTX
#define NB_GPIO_IN1_SCIRX               _NB_GPIO_IN1.Bits.SCIRX
#define NB_GPIO_IN1_TCAP0               _NB_GPIO_IN1.Bits.TCAP0
#define NB_GPIO_IN1_TCAP1               _NB_GPIO_IN1.Bits.TCAP1
#define NB_GPIO_IN1_TCAP2               _NB_GPIO_IN1.Bits.TCAP2
#define NB_GPIO_IN1_TCAP3               _NB_GPIO_IN1.Bits.TCAP3
#define NB_GPIO_IN1_TCAP                _NB_GPIO_IN1.MergedBits.grpTCAP

#define NB_GPIO_IN1_LINTX_MASK          2U
#define NB_GPIO_IN1_SCIRX_MASK          4U
#define NB_GPIO_IN1_TCAP0_MASK          8U
#define NB_GPIO_IN1_TCAP1_MASK          16U
#define NB_GPIO_IN1_TCAP2_MASK          32U
#define NB_GPIO_IN1_TCAP3_MASK          64U
#define NB_GPIO_IN1_TCAP_MASK           120U
#define NB_GPIO_IN1_TCAP_BITNUM         3U


/*** NB_GPIO_OUT1 - Port 1 output configuration; 0x00000347 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBX1       :1;                                       /* PTB1 - Output Buffer Control */
    byte LINRX       :1;                                       /* PTB1 - LIN RX Output */
    byte SCITX       :1;                                       /* PTB1 - SCI TX Output */
    byte TCOMP0      :1;                                       /* PTB1 - Timer Channel 0 - Output Compare output */
    byte TCOMP1      :1;                                       /* PTB1 - Timer Channel 1 - Output Compare output */
    byte TCOMP2      :1;                                       /* PTB1 - Timer Channel 2 - Output Compare output */
    byte TCOMP3      :1;                                       /* PTB1 - Timer Channel 3 - Output Compare output */
    byte WKUP        :1;                                       /* PTB1 - Wake Up output */
  } Bits;
  struct {
    byte grpPTBX_1 :1;
    byte         :1;
    byte         :1;
    byte grpTCOMP :4;
    byte         :1;
  } MergedBits;
} NB_GPIO_OUT1STR;
extern volatile NB_GPIO_OUT1STR _NB_GPIO_OUT1 @(REG_BASE + 0x00000347UL);
#define NB_GPIO_OUT1                    _NB_GPIO_OUT1.Byte
#define NB_GPIO_OUT1_PTBX1              _NB_GPIO_OUT1.Bits.PTBX1
#define NB_GPIO_OUT1_LINRX              _NB_GPIO_OUT1.Bits.LINRX
#define NB_GPIO_OUT1_SCITX              _NB_GPIO_OUT1.Bits.SCITX
#define NB_GPIO_OUT1_TCOMP0             _NB_GPIO_OUT1.Bits.TCOMP0
#define NB_GPIO_OUT1_TCOMP1             _NB_GPIO_OUT1.Bits.TCOMP1
#define NB_GPIO_OUT1_TCOMP2             _NB_GPIO_OUT1.Bits.TCOMP2
#define NB_GPIO_OUT1_TCOMP3             _NB_GPIO_OUT1.Bits.TCOMP3
#define NB_GPIO_OUT1_WKUP               _NB_GPIO_OUT1.Bits.WKUP
#define NB_GPIO_OUT1_TCOMP              _NB_GPIO_OUT1.MergedBits.grpTCOMP

#define NB_GPIO_OUT1_PTBX1_MASK         1U
#define NB_GPIO_OUT1_LINRX_MASK         2U
#define NB_GPIO_OUT1_SCITX_MASK         4U
#define NB_GPIO_OUT1_TCOMP0_MASK        8U
#define NB_GPIO_OUT1_TCOMP1_MASK        16U
#define NB_GPIO_OUT1_TCOMP2_MASK        32U
#define NB_GPIO_OUT1_TCOMP3_MASK        64U
#define NB_GPIO_OUT1_WKUP_MASK          128U
#define NB_GPIO_OUT1_TCOMP_MASK         120U
#define NB_GPIO_OUT1_TCOMP_BITNUM       3U


/*** NB_GPIO_IN2 - Port 2 input configuration; 0x00000348 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LINTX       :1;                                       /* PTB2 - LIN Module Tx Input */
    byte SCIRX       :1;                                       /* PTB2 - SCI Module Rx Input */
    byte TCAP0       :1;                                       /* PTB2 - Timer Input Capture Channel 0 */
    byte TCAP1       :1;                                       /* PTB2 - Timer Input Capture Channel 1 */
    byte TCAP2       :1;                                       /* PTB2 - Timer Input Capture Channel 2 */
    byte TCAP3       :1;                                       /* PTB2 - Timer Input Capture Channel 3 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} NB_GPIO_IN2STR;
extern volatile NB_GPIO_IN2STR _NB_GPIO_IN2 @(REG_BASE + 0x00000348UL);
#define NB_GPIO_IN2                     _NB_GPIO_IN2.Byte
#define NB_GPIO_IN2_LINTX               _NB_GPIO_IN2.Bits.LINTX
#define NB_GPIO_IN2_SCIRX               _NB_GPIO_IN2.Bits.SCIRX
#define NB_GPIO_IN2_TCAP0               _NB_GPIO_IN2.Bits.TCAP0
#define NB_GPIO_IN2_TCAP1               _NB_GPIO_IN2.Bits.TCAP1
#define NB_GPIO_IN2_TCAP2               _NB_GPIO_IN2.Bits.TCAP2
#define NB_GPIO_IN2_TCAP3               _NB_GPIO_IN2.Bits.TCAP3
#define NB_GPIO_IN2_TCAP                _NB_GPIO_IN2.MergedBits.grpTCAP

#define NB_GPIO_IN2_LINTX_MASK          2U
#define NB_GPIO_IN2_SCIRX_MASK          4U
#define NB_GPIO_IN2_TCAP0_MASK          8U
#define NB_GPIO_IN2_TCAP1_MASK          16U
#define NB_GPIO_IN2_TCAP2_MASK          32U
#define NB_GPIO_IN2_TCAP3_MASK          64U
#define NB_GPIO_IN2_TCAP_MASK           120U
#define NB_GPIO_IN2_TCAP_BITNUM         3U


/*** NB_GPIO_OUT2 - Port 2 output configuration; 0x00000349 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBX2       :1;                                       /* PTB2 - Output Buffer Control */
    byte LINRX       :1;                                       /* PTB2 - LIN RX Output */
    byte SCITX       :1;                                       /* PTB2 - SCI TX Output */
    byte TCOMP0      :1;                                       /* PTB2 - Timer Channel 0 - Output Compare output */
    byte TCOMP1      :1;                                       /* PTB2 - Timer Channel 1 - Output Compare output */
    byte TCOMP2      :1;                                       /* PTB2 - Timer Channel 2 - Output Compare output */
    byte TCOMP3      :1;                                       /* PTB2 - Timer Channel 3 - Output Compare output */
    byte WKUP        :1;                                       /* PTB2 - Wake Up output */
  } Bits;
  struct {
    byte grpPTBX_2 :1;
    byte         :1;
    byte         :1;
    byte grpTCOMP :4;
    byte         :1;
  } MergedBits;
} NB_GPIO_OUT2STR;
extern volatile NB_GPIO_OUT2STR _NB_GPIO_OUT2 @(REG_BASE + 0x00000349UL);
#define NB_GPIO_OUT2                    _NB_GPIO_OUT2.Byte
#define NB_GPIO_OUT2_PTBX2              _NB_GPIO_OUT2.Bits.PTBX2
#define NB_GPIO_OUT2_LINRX              _NB_GPIO_OUT2.Bits.LINRX
#define NB_GPIO_OUT2_SCITX              _NB_GPIO_OUT2.Bits.SCITX
#define NB_GPIO_OUT2_TCOMP0             _NB_GPIO_OUT2.Bits.TCOMP0
#define NB_GPIO_OUT2_TCOMP1             _NB_GPIO_OUT2.Bits.TCOMP1
#define NB_GPIO_OUT2_TCOMP2             _NB_GPIO_OUT2.Bits.TCOMP2
#define NB_GPIO_OUT2_TCOMP3             _NB_GPIO_OUT2.Bits.TCOMP3
#define NB_GPIO_OUT2_WKUP               _NB_GPIO_OUT2.Bits.WKUP
#define NB_GPIO_OUT2_TCOMP              _NB_GPIO_OUT2.MergedBits.grpTCOMP

#define NB_GPIO_OUT2_PTBX2_MASK         1U
#define NB_GPIO_OUT2_LINRX_MASK         2U
#define NB_GPIO_OUT2_SCITX_MASK         4U
#define NB_GPIO_OUT2_TCOMP0_MASK        8U
#define NB_GPIO_OUT2_TCOMP1_MASK        16U
#define NB_GPIO_OUT2_TCOMP2_MASK        32U
#define NB_GPIO_OUT2_TCOMP3_MASK        64U
#define NB_GPIO_OUT2_WKUP_MASK          128U
#define NB_GPIO_OUT2_TCOMP_MASK         120U
#define NB_GPIO_OUT2_TCOMP_BITNUM       3U


/*** NB_GPIO_IN3 - Port 3 input configuration; 0x0000034A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TCAP0       :1;                                       /* PTB3 - Timer Input Capture Channel 0 */
    byte TCAP1       :1;                                       /* PTB3 - Timer Input Capture Channel 1 */
    byte TCAP2       :1;                                       /* PTB3 - Timer Input Capture Channel 2 */
    byte TCAP3       :1;                                       /* PTB3 - Timer Input Capture Channel 3 */
    byte PTWU        :1;                                       /* PTB3 Wake Up */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} NB_GPIO_IN3STR;
extern volatile NB_GPIO_IN3STR _NB_GPIO_IN3 @(REG_BASE + 0x0000034AUL);
#define NB_GPIO_IN3                     _NB_GPIO_IN3.Byte
#define NB_GPIO_IN3_TCAP0               _NB_GPIO_IN3.Bits.TCAP0
#define NB_GPIO_IN3_TCAP1               _NB_GPIO_IN3.Bits.TCAP1
#define NB_GPIO_IN3_TCAP2               _NB_GPIO_IN3.Bits.TCAP2
#define NB_GPIO_IN3_TCAP3               _NB_GPIO_IN3.Bits.TCAP3
#define NB_GPIO_IN3_PTWU                _NB_GPIO_IN3.Bits.PTWU
#define NB_GPIO_IN3_TCAP                _NB_GPIO_IN3.MergedBits.grpTCAP

#define NB_GPIO_IN3_TCAP0_MASK          8U
#define NB_GPIO_IN3_TCAP1_MASK          16U
#define NB_GPIO_IN3_TCAP2_MASK          32U
#define NB_GPIO_IN3_TCAP3_MASK          64U
#define NB_GPIO_IN3_PTWU_MASK           128U
#define NB_GPIO_IN3_TCAP_MASK           120U
#define NB_GPIO_IN3_TCAP_BITNUM         3U


/*** NB_LIN_CTL - LIN control register; 0x00000350 ***/
typedef union {
  word Word;
  struct {
    word SRS         :2;                                       /* Slew Rate Select */
    word EN          :1;                                       /* Module Enable */
    word LVSD        :1;                                       /* Low Voltage Shutdown Disable (J2602 Compliance Control) */
    word TXD         :1;                                       /* Direct Transmitter Control */
    word             :1; 
    word             :1; 
    word OTIE        :1;                                       /* Overtemperature Interrupt Enable */
    word SRSM        :2;                                       /* Slew Rate Select - Mask */
    word ENM         :1;                                       /* Module Enable - Mask */
    word LVSDM       :1;                                       /* Low Voltage Shutdown Disable (J2602 Compliance Control) - Mask */
    word TXDM        :1;                                       /* Direct Transmitter Control - Mask */
    word             :1; 
    word             :1; 
    word OTIEM       :1;                                       /* Overtemperature Interrupt Enable - Mask */
  } Bits;
} NB_LIN_CTLSTR;
extern volatile NB_LIN_CTLSTR _NB_LIN_CTL @(REG_BASE + 0x00000350UL);
#define NB_LIN_CTL                      _NB_LIN_CTL.Word
#define NB_LIN_CTL_SRS                  _NB_LIN_CTL.Bits.SRS
#define NB_LIN_CTL_EN                   _NB_LIN_CTL.Bits.EN
#define NB_LIN_CTL_LVSD                 _NB_LIN_CTL.Bits.LVSD
#define NB_LIN_CTL_TXD                  _NB_LIN_CTL.Bits.TXD
#define NB_LIN_CTL_OTIE                 _NB_LIN_CTL.Bits.OTIE
#define NB_LIN_CTL_SRSM                 _NB_LIN_CTL.Bits.SRSM
#define NB_LIN_CTL_ENM                  _NB_LIN_CTL.Bits.ENM
#define NB_LIN_CTL_LVSDM                _NB_LIN_CTL.Bits.LVSDM
#define NB_LIN_CTL_TXDM                 _NB_LIN_CTL.Bits.TXDM
#define NB_LIN_CTL_OTIEM                _NB_LIN_CTL.Bits.OTIEM

#define NB_LIN_CTL_SRS_MASK             3U
#define NB_LIN_CTL_SRS_BITNUM           0U
#define NB_LIN_CTL_EN_MASK              4U
#define NB_LIN_CTL_LVSD_MASK            8U
#define NB_LIN_CTL_TXD_MASK             16U
#define NB_LIN_CTL_OTIE_MASK            128U
#define NB_LIN_CTL_SRSM_MASK            768U
#define NB_LIN_CTL_SRSM_BITNUM          8U
#define NB_LIN_CTL_ENM_MASK             1024U
#define NB_LIN_CTL_LVSDM_MASK           2048U
#define NB_LIN_CTL_TXDM_MASK            4096U
#define NB_LIN_CTL_OTIEM_MASK           32768U


/*** NB_LIN_SR - LIN status register; 0x00000352 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LIN_SRH - LIN status register high; 0x00000352 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte UV          :1;                                       /* Undervoltage Status */
        byte             :1; 
        byte HF          :1;                                       /* HF (High Frequency) Condition Status indicating HF disturbance in the LIN module */
        byte             :1; 
        byte OT          :1;                                       /* Overtemperature Status */
      } Bits;
    } NB_LIN_SRHSTR;
    #define NB_LIN_SRH                  _NB_LIN_SR.Overlap_STR.NB_LIN_SRHSTR.Byte
    #define NB_LIN_SRH_UV               _NB_LIN_SR.Overlap_STR.NB_LIN_SRHSTR.Bits.UV
    #define NB_LIN_SRH_HF               _NB_LIN_SR.Overlap_STR.NB_LIN_SRHSTR.Bits.HF
    #define NB_LIN_SRH_OT               _NB_LIN_SR.Overlap_STR.NB_LIN_SRHSTR.Bits.OT
    
    #define NB_LIN_SRH_UV_MASK          8U
    #define NB_LIN_SRH_HF_MASK          32U
    #define NB_LIN_SRH_OT_MASK          128U
    

    /*** NB_LIN_SRL - LIN status register low; 0x00000353 ***/
    union {
      byte Byte;
      struct {
        byte TX          :1;                                       /* Current TX status */
        byte RX          :1;                                       /* Current RX status */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte RDY         :1;                                       /* Transmitter Ready Status */
      } Bits;
    } NB_LIN_SRLSTR;
    #define NB_LIN_SRL                  _NB_LIN_SR.Overlap_STR.NB_LIN_SRLSTR.Byte
    #define NB_LIN_SRL_TX               _NB_LIN_SR.Overlap_STR.NB_LIN_SRLSTR.Bits.TX
    #define NB_LIN_SRL_RX               _NB_LIN_SR.Overlap_STR.NB_LIN_SRLSTR.Bits.RX
    #define NB_LIN_SRL_RDY              _NB_LIN_SR.Overlap_STR.NB_LIN_SRLSTR.Bits.RDY
    
    #define NB_LIN_SRL_TX_MASK          1U
    #define NB_LIN_SRL_RX_MASK          2U
    #define NB_LIN_SRL_RDY_MASK         128U
    
  } Overlap_STR;

  struct {
    word TX          :1;                                       /* Current TX status */
    word RX          :1;                                       /* Current RX status */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word RDY         :1;                                       /* Transmitter Ready Status */
    word             :1; 
    word             :1; 
    word             :1; 
    word UV          :1;                                       /* Undervoltage Status */
    word             :1; 
    word HF          :1;                                       /* HF (High Frequency) Condition Status indicating HF disturbance in the LIN module */
    word             :1; 
    word OT          :1;                                       /* Overtemperature Status */
  } Bits;
} NB_LIN_SRSTR;
extern volatile NB_LIN_SRSTR _NB_LIN_SR @(REG_BASE + 0x00000352UL);
#define NB_LIN_SR                       _NB_LIN_SR.Word
#define NB_LIN_SR_TX                    _NB_LIN_SR.Bits.TX
#define NB_LIN_SR_RX                    _NB_LIN_SR.Bits.RX
#define NB_LIN_SR_RDY                   _NB_LIN_SR.Bits.RDY
#define NB_LIN_SR_UV                    _NB_LIN_SR.Bits.UV
#define NB_LIN_SR_HF                    _NB_LIN_SR.Bits.HF
#define NB_LIN_SR_OT                    _NB_LIN_SR.Bits.OT

#define NB_LIN_SR_TX_MASK               1U
#define NB_LIN_SR_RX_MASK               2U
#define NB_LIN_SR_RDY_MASK              128U
#define NB_LIN_SR_UV_MASK               2048U
#define NB_LIN_SR_HF_MASK               8192U
#define NB_LIN_SR_OT_MASK               32768U


/*** NB_LIN_TX - LIN transmit line definition; 0x00000354 ***/
typedef union {
  byte Byte;
  struct {
    byte FROMSCI     :1;                                       /* LIN_TX internally routed from SCI */
    byte FROMPTB     :1;                                       /* LIN_TX internally routed from PTB */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_LIN_TXSTR;
extern volatile NB_LIN_TXSTR _NB_LIN_TX @(REG_BASE + 0x00000354UL);
#define NB_LIN_TX                       _NB_LIN_TX.Byte
#define NB_LIN_TX_FROMSCI               _NB_LIN_TX.Bits.FROMSCI
#define NB_LIN_TX_FROMPTB               _NB_LIN_TX.Bits.FROMPTB

#define NB_LIN_TX_FROMSCI_MASK          1U
#define NB_LIN_TX_FROMPTB_MASK          2U


/*** NB_LIN_RX - LIN receive line definition; 0x00000355 ***/
typedef union {
  byte Byte;
  struct {
    byte TOSCI       :1;                                       /* LIN_RX internally routed to SCI */
    byte TOPTB       :1;                                       /* LIN_RX internally routed to PTB */
    byte             :1; 
    byte TCAP0       :1;                                       /* LIN_RX internally routed to Timer Channel 0 Input Capture */
    byte TCAP1       :1;                                       /* LIN_RX internally routed to Timer Channel 1 Input Capture */
    byte TCAP2       :1;                                       /* LIN_RX internally routed to Timer Channel 2 Input Capture */
    byte TCAP3       :1;                                       /* LIN_RX internally routed to Timer Channel 3 Input Capture */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpTCAP :4;
    byte         :1;
  } MergedBits;
} NB_LIN_RXSTR;
extern volatile NB_LIN_RXSTR _NB_LIN_RX @(REG_BASE + 0x00000355UL);
#define NB_LIN_RX                       _NB_LIN_RX.Byte
#define NB_LIN_RX_TOSCI                 _NB_LIN_RX.Bits.TOSCI
#define NB_LIN_RX_TOPTB                 _NB_LIN_RX.Bits.TOPTB
#define NB_LIN_RX_TCAP0                 _NB_LIN_RX.Bits.TCAP0
#define NB_LIN_RX_TCAP1                 _NB_LIN_RX.Bits.TCAP1
#define NB_LIN_RX_TCAP2                 _NB_LIN_RX.Bits.TCAP2
#define NB_LIN_RX_TCAP3                 _NB_LIN_RX.Bits.TCAP3
#define NB_LIN_RX_TCAP                  _NB_LIN_RX.MergedBits.grpTCAP

#define NB_LIN_RX_TOSCI_MASK            1U
#define NB_LIN_RX_TOPTB_MASK            2U
#define NB_LIN_RX_TCAP0_MASK            8U
#define NB_LIN_RX_TCAP1_MASK            16U
#define NB_LIN_RX_TCAP2_MASK            32U
#define NB_LIN_RX_TCAP3_MASK            64U
#define NB_LIN_RX_TCAP_MASK             120U
#define NB_LIN_RX_TCAP_BITNUM           3U


/*** NB_ACQ_CTL - Acquisition control register; 0x00000358 ***/
typedef union {
  word Word;
  struct {
    word CMEN        :1;                                       /* Current Measurement Enable */
    word VMEN        :1;                                       /* Voltage Measurement Enable */
    word ITMEN       :1;                                       /* Internal Temperature Measurement Enable */
    word ETMEN       :1;                                       /* External Temperature Measurement Enable */
    word CVMIE       :1;                                       /* Current / Voltage Measurement Interrupt Enable */
    word OPENE       :1;                                       /* Enable Shunt Resistor Open Detection */
    word OPTE        :1;                                       /* Optional Voltage Sense Enable (Voltage Channel Multiplexer Control) */
    word AHCR        :1;                                       /* Ampere Hour Counter Reset, this write only bit will reset the ACQ_AHC register */
    word CMENM       :1;                                       /* Current Measurement Enable - Mask */
    word VMENM       :1;                                       /* Voltage Measurement Enable - Mask */
    word ITMENM      :1;                                       /* Internal Temperature Measurement Enable - Mask */
    word ETMENM      :1;                                       /* External Temperature Measurement Enable - Mask */
    word CVMIEM      :1;                                       /* Current / Voltage Measurement Interrupt Enable - Mask */
    word OPENEM      :1;                                       /* Enable Shunt Resistor Open Detection - Mask */
    word OPTEM       :1;                                       /* Optional Voltage Sense Enable - Mask */
    word AHCRM       :1;                                       /* Ampere Hour Counter Reset - Mask */
  } Bits;
} NB_ACQ_CTLSTR;
extern volatile NB_ACQ_CTLSTR _NB_ACQ_CTL @(REG_BASE + 0x00000358UL);
#define NB_ACQ_CTL                      _NB_ACQ_CTL.Word
#define NB_ACQ_CTL_CMEN                 _NB_ACQ_CTL.Bits.CMEN
#define NB_ACQ_CTL_VMEN                 _NB_ACQ_CTL.Bits.VMEN
#define NB_ACQ_CTL_ITMEN                _NB_ACQ_CTL.Bits.ITMEN
#define NB_ACQ_CTL_ETMEN                _NB_ACQ_CTL.Bits.ETMEN
#define NB_ACQ_CTL_CVMIE                _NB_ACQ_CTL.Bits.CVMIE
#define NB_ACQ_CTL_OPENE                _NB_ACQ_CTL.Bits.OPENE
#define NB_ACQ_CTL_OPTE                 _NB_ACQ_CTL.Bits.OPTE
#define NB_ACQ_CTL_AHCR                 _NB_ACQ_CTL.Bits.AHCR
#define NB_ACQ_CTL_CMENM                _NB_ACQ_CTL.Bits.CMENM
#define NB_ACQ_CTL_VMENM                _NB_ACQ_CTL.Bits.VMENM
#define NB_ACQ_CTL_ITMENM               _NB_ACQ_CTL.Bits.ITMENM
#define NB_ACQ_CTL_ETMENM               _NB_ACQ_CTL.Bits.ETMENM
#define NB_ACQ_CTL_CVMIEM               _NB_ACQ_CTL.Bits.CVMIEM
#define NB_ACQ_CTL_OPENEM               _NB_ACQ_CTL.Bits.OPENEM
#define NB_ACQ_CTL_OPTEM                _NB_ACQ_CTL.Bits.OPTEM
#define NB_ACQ_CTL_AHCRM                _NB_ACQ_CTL.Bits.AHCRM

#define NB_ACQ_CTL_CMEN_MASK            1U
#define NB_ACQ_CTL_VMEN_MASK            2U
#define NB_ACQ_CTL_ITMEN_MASK           4U
#define NB_ACQ_CTL_ETMEN_MASK           8U
#define NB_ACQ_CTL_CVMIE_MASK           16U
#define NB_ACQ_CTL_OPENE_MASK           32U
#define NB_ACQ_CTL_OPTE_MASK            64U
#define NB_ACQ_CTL_AHCR_MASK            128U
#define NB_ACQ_CTL_CMENM_MASK           256U
#define NB_ACQ_CTL_VMENM_MASK           512U
#define NB_ACQ_CTL_ITMENM_MASK          1024U
#define NB_ACQ_CTL_ETMENM_MASK          2048U
#define NB_ACQ_CTL_CVMIEM_MASK          4096U
#define NB_ACQ_CTL_OPENEM_MASK          8192U
#define NB_ACQ_CTL_OPTEM_MASK           16384U
#define NB_ACQ_CTL_AHCRM_MASK           32768U


/*** NB_ACQ_SR - Acquisition status register; 0x0000035A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ACQ_SRH - Acquisition status register high; 0x0000035A ***/
    union {
      byte Byte;
      struct {
        byte CM          :1;                                       /* End of Measurement - Current */
        byte VM          :1;                                       /* End of Measurement - Voltage */
        byte ITM         :1;                                       /* End of Measurement - Internal Temperature */
        byte ETM         :1;                                       /* End of Measurement - External Temperature */
        byte CMOW        :1;                                       /* Current Measurement Result Overwritten */
        byte VMOW        :1;                                       /* Voltage Measurement Result Overwritten */
        byte PGAG        :1;                                       /* PGA Gain Change Flag */
        byte AVRF        :1;                                       /* VDDA Low Voltage Reset Flag */
      } Bits;
    } NB_ACQ_SRHSTR;
    #define NB_ACQ_SRH                  _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Byte
    #define NB_ACQ_SRH_CM               _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Bits.CM
    #define NB_ACQ_SRH_VM               _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Bits.VM
    #define NB_ACQ_SRH_ITM              _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Bits.ITM
    #define NB_ACQ_SRH_ETM              _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Bits.ETM
    #define NB_ACQ_SRH_CMOW             _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Bits.CMOW
    #define NB_ACQ_SRH_VMOW             _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Bits.VMOW
    #define NB_ACQ_SRH_PGAG             _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Bits.PGAG
    #define NB_ACQ_SRH_AVRF             _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRHSTR.Bits.AVRF
    
    #define NB_ACQ_SRH_CM_MASK          1U
    #define NB_ACQ_SRH_VM_MASK          2U
    #define NB_ACQ_SRH_ITM_MASK         4U
    #define NB_ACQ_SRH_ETM_MASK         8U
    #define NB_ACQ_SRH_CMOW_MASK        16U
    #define NB_ACQ_SRH_VMOW_MASK        32U
    #define NB_ACQ_SRH_PGAG_MASK        64U
    #define NB_ACQ_SRH_AVRF_MASK        128U
    

    /*** NB_ACQ_SRL - Acquisition status register low; 0x0000035B ***/
    union {
      byte Byte;
      struct {
        byte CCHOP       :1;                                       /* Chopping Active Status - Current */
        byte VCHOP       :1;                                       /* Chopping Active Status - Voltage */
        byte ITCHOP      :1;                                       /* Chopping Active Status - Internal Temperature */
        byte ETCHOP      :1;                                       /* Chopping Active Status - External Temperature */
        byte VTH         :1;                                       /* Digital Voltage High Threshold Reached */
        byte             :1; 
        byte             :1; 
        byte OPEN        :1;                                       /* Shunt Resistor Open Detection Status */
      } Bits;
    } NB_ACQ_SRLSTR;
    #define NB_ACQ_SRL                  _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRLSTR.Byte
    #define NB_ACQ_SRL_CCHOP            _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRLSTR.Bits.CCHOP
    #define NB_ACQ_SRL_VCHOP            _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRLSTR.Bits.VCHOP
    #define NB_ACQ_SRL_ITCHOP           _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRLSTR.Bits.ITCHOP
    #define NB_ACQ_SRL_ETCHOP           _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRLSTR.Bits.ETCHOP
    #define NB_ACQ_SRL_VTH              _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRLSTR.Bits.VTH
    #define NB_ACQ_SRL_OPEN             _NB_ACQ_SR.Overlap_STR.NB_ACQ_SRLSTR.Bits.OPEN
    
    #define NB_ACQ_SRL_CCHOP_MASK       1U
    #define NB_ACQ_SRL_VCHOP_MASK       2U
    #define NB_ACQ_SRL_ITCHOP_MASK      4U
    #define NB_ACQ_SRL_ETCHOP_MASK      8U
    #define NB_ACQ_SRL_VTH_MASK         16U
    #define NB_ACQ_SRL_OPEN_MASK        128U
    
  } Overlap_STR;

  struct {
    word CCHOP       :1;                                       /* Chopping Active Status - Current */
    word VCHOP       :1;                                       /* Chopping Active Status - Voltage */
    word ITCHOP      :1;                                       /* Chopping Active Status - Internal Temperature */
    word ETCHOP      :1;                                       /* Chopping Active Status - External Temperature */
    word VTH         :1;                                       /* Digital Voltage High Threshold Reached */
    word             :1; 
    word             :1; 
    word OPEN        :1;                                       /* Shunt Resistor Open Detection Status */
    word CM          :1;                                       /* End of Measurement - Current */
    word VM          :1;                                       /* End of Measurement - Voltage */
    word ITM         :1;                                       /* End of Measurement - Internal Temperature */
    word ETM         :1;                                       /* End of Measurement - External Temperature */
    word CMOW        :1;                                       /* Current Measurement Result Overwritten */
    word VMOW        :1;                                       /* Voltage Measurement Result Overwritten */
    word PGAG        :1;                                       /* PGA Gain Change Flag */
    word AVRF        :1;                                       /* VDDA Low Voltage Reset Flag */
  } Bits;
} NB_ACQ_SRSTR;
extern volatile NB_ACQ_SRSTR _NB_ACQ_SR @(REG_BASE + 0x0000035AUL);
#define NB_ACQ_SR                       _NB_ACQ_SR.Word
#define NB_ACQ_SR_CCHOP                 _NB_ACQ_SR.Bits.CCHOP
#define NB_ACQ_SR_VCHOP                 _NB_ACQ_SR.Bits.VCHOP
#define NB_ACQ_SR_ITCHOP                _NB_ACQ_SR.Bits.ITCHOP
#define NB_ACQ_SR_ETCHOP                _NB_ACQ_SR.Bits.ETCHOP
#define NB_ACQ_SR_VTH                   _NB_ACQ_SR.Bits.VTH
#define NB_ACQ_SR_OPEN                  _NB_ACQ_SR.Bits.OPEN
#define NB_ACQ_SR_CM                    _NB_ACQ_SR.Bits.CM
#define NB_ACQ_SR_VM                    _NB_ACQ_SR.Bits.VM
#define NB_ACQ_SR_ITM                   _NB_ACQ_SR.Bits.ITM
#define NB_ACQ_SR_ETM                   _NB_ACQ_SR.Bits.ETM
#define NB_ACQ_SR_CMOW                  _NB_ACQ_SR.Bits.CMOW
#define NB_ACQ_SR_VMOW                  _NB_ACQ_SR.Bits.VMOW
#define NB_ACQ_SR_PGAG                  _NB_ACQ_SR.Bits.PGAG
#define NB_ACQ_SR_AVRF                  _NB_ACQ_SR.Bits.AVRF

#define NB_ACQ_SR_CCHOP_MASK            1U
#define NB_ACQ_SR_VCHOP_MASK            2U
#define NB_ACQ_SR_ITCHOP_MASK           4U
#define NB_ACQ_SR_ETCHOP_MASK           8U
#define NB_ACQ_SR_VTH_MASK              16U
#define NB_ACQ_SR_OPEN_MASK             128U
#define NB_ACQ_SR_CM_MASK               256U
#define NB_ACQ_SR_VM_MASK               512U
#define NB_ACQ_SR_ITM_MASK              1024U
#define NB_ACQ_SR_ETM_MASK              2048U
#define NB_ACQ_SR_CMOW_MASK             4096U
#define NB_ACQ_SR_VMOW_MASK             8192U
#define NB_ACQ_SR_PGAG_MASK             16384U
#define NB_ACQ_SR_AVRF_MASK             32768U


/*** NB_ACQ_ACC1 - Acquisition chain control 1; 0x0000035C ***/
typedef union {
  word Word;
  struct {
    word AGEN        :1;                                       /* Automatic Gain Control Enable - Mask */
    word CVCHOP      :1;                                       /* Chopping Enable - Voltage Measurement Channel - Mask */
    word ITCHOP      :1;                                       /* Chopping Enable - Internal Temperature Measurement Channel - Mask */
    word ETCHOP      :1;                                       /* Chopping Enable - External Temperature Measurement Channel - Mask */
    word LPFEN       :1;                                       /* LPF Enable - Mask */
    word CCOMP       :1;                                       /* Current Measurement Channel - Compensation Enable - Mask */
    word VCOMP       :1;                                       /* Voltage Measurement Channel - Compensation Enable - Mask */
    word TCOMP       :1;                                       /* Temperature Measurement Channel - Compensation Enable - Mask */
    word AGENM       :1;                                       /* Temperature Measurement Channel - Compensation Enable */
    word CVCHOPM     :1;                                       /* Voltage Compensation Enable */
    word ITCHOPM     :1;                                       /* Current Compensation Enable */
    word ETCHOPM     :1;                                       /* LPF Enable */
    word LPFENM      :1;                                       /* Chopping Enable - External Temperature */
    word CCOMPM      :1;                                       /* Chopping Enable - Internal Temperature */
    word VCOMPM      :1;                                       /* Chopping Enable - Voltage */
    word TCOMPM      :1;                                       /* Automatic Gain Control Enable */
  } Bits;
} NB_ACQ_ACC1STR;
extern volatile NB_ACQ_ACC1STR _NB_ACQ_ACC1 @(REG_BASE + 0x0000035CUL);
#define NB_ACQ_ACC1                     _NB_ACQ_ACC1.Word
#define NB_ACQ_ACC1_AGEN                _NB_ACQ_ACC1.Bits.AGEN
#define NB_ACQ_ACC1_CVCHOP              _NB_ACQ_ACC1.Bits.CVCHOP
#define NB_ACQ_ACC1_ITCHOP              _NB_ACQ_ACC1.Bits.ITCHOP
#define NB_ACQ_ACC1_ETCHOP              _NB_ACQ_ACC1.Bits.ETCHOP
#define NB_ACQ_ACC1_LPFEN               _NB_ACQ_ACC1.Bits.LPFEN
#define NB_ACQ_ACC1_CCOMP               _NB_ACQ_ACC1.Bits.CCOMP
#define NB_ACQ_ACC1_VCOMP               _NB_ACQ_ACC1.Bits.VCOMP
#define NB_ACQ_ACC1_TCOMP               _NB_ACQ_ACC1.Bits.TCOMP
#define NB_ACQ_ACC1_AGENM               _NB_ACQ_ACC1.Bits.AGENM
#define NB_ACQ_ACC1_CVCHOPM             _NB_ACQ_ACC1.Bits.CVCHOPM
#define NB_ACQ_ACC1_ITCHOPM             _NB_ACQ_ACC1.Bits.ITCHOPM
#define NB_ACQ_ACC1_ETCHOPM             _NB_ACQ_ACC1.Bits.ETCHOPM
#define NB_ACQ_ACC1_LPFENM              _NB_ACQ_ACC1.Bits.LPFENM
#define NB_ACQ_ACC1_CCOMPM              _NB_ACQ_ACC1.Bits.CCOMPM
#define NB_ACQ_ACC1_VCOMPM              _NB_ACQ_ACC1.Bits.VCOMPM
#define NB_ACQ_ACC1_TCOMPM              _NB_ACQ_ACC1.Bits.TCOMPM

#define NB_ACQ_ACC1_AGEN_MASK           1U
#define NB_ACQ_ACC1_CVCHOP_MASK         2U
#define NB_ACQ_ACC1_ITCHOP_MASK         4U
#define NB_ACQ_ACC1_ETCHOP_MASK         8U
#define NB_ACQ_ACC1_LPFEN_MASK          16U
#define NB_ACQ_ACC1_CCOMP_MASK          32U
#define NB_ACQ_ACC1_VCOMP_MASK          64U
#define NB_ACQ_ACC1_TCOMP_MASK          128U
#define NB_ACQ_ACC1_AGENM_MASK          256U
#define NB_ACQ_ACC1_CVCHOPM_MASK        512U
#define NB_ACQ_ACC1_ITCHOPM_MASK        1024U
#define NB_ACQ_ACC1_ETCHOPM_MASK        2048U
#define NB_ACQ_ACC1_LPFENM_MASK         4096U
#define NB_ACQ_ACC1_CCOMPM_MASK         8192U
#define NB_ACQ_ACC1_VCOMPM_MASK         16384U
#define NB_ACQ_ACC1_TCOMPM_MASK         32768U


/*** NB_ACQ_ACC0 - Acquisition chain control 0; 0x0000035E ***/
typedef union {
  word Word;
  struct {
    word CDEN        :1;                                       /* Timing delay - Current */
    word VDEN        :1;                                       /* Timing delay - Voltage */
    word TDEN        :1;                                       /* Timing delay - Temperature */
    word CADCG       :1;                                       /* Current ADC Gain Select */
    word VADCG       :1;                                       /* Voltage ADC Gain Select */
    word TADCG       :1;                                       /* Temperature ADC Gain Select */
    word ECAP        :1;                                       /* TSUP External Capacitor select */
    word ZERO        :1;                                       /* Current and Voltage Sigma Delta Input Short */
    word CDENM       :1;                                       /* 100ns Clock delay - Current - Mask */
    word VDENM       :1;                                       /* 100ns Clock delay - Voltage - Mask */
    word TDENM       :1;                                       /* 100ns Clock delay - Internal Temperature - Mask */
    word CADCGM      :1;                                       /* Current ADC Gain Select - Mask */
    word VADCGM      :1;                                       /* Voltage ADC Gain Select - Mask */
    word TADCGM      :1;                                       /* Temperature ADC Gain Select - Mask */
    word ECAPM       :1;                                       /* TSUP External Capacitor - Mask */
    word ZEROM       :1;                                       /* Current and Voltage Sigma Delta Input Short - Mask */
  } Bits;
} NB_ACQ_ACC0STR;
extern volatile NB_ACQ_ACC0STR _NB_ACQ_ACC0 @(REG_BASE + 0x0000035EUL);
#define NB_ACQ_ACC0                     _NB_ACQ_ACC0.Word
#define NB_ACQ_ACC0_CDEN                _NB_ACQ_ACC0.Bits.CDEN
#define NB_ACQ_ACC0_VDEN                _NB_ACQ_ACC0.Bits.VDEN
#define NB_ACQ_ACC0_TDEN                _NB_ACQ_ACC0.Bits.TDEN
#define NB_ACQ_ACC0_CADCG               _NB_ACQ_ACC0.Bits.CADCG
#define NB_ACQ_ACC0_VADCG               _NB_ACQ_ACC0.Bits.VADCG
#define NB_ACQ_ACC0_TADCG               _NB_ACQ_ACC0.Bits.TADCG
#define NB_ACQ_ACC0_ECAP                _NB_ACQ_ACC0.Bits.ECAP
#define NB_ACQ_ACC0_ZERO                _NB_ACQ_ACC0.Bits.ZERO
#define NB_ACQ_ACC0_CDENM               _NB_ACQ_ACC0.Bits.CDENM
#define NB_ACQ_ACC0_VDENM               _NB_ACQ_ACC0.Bits.VDENM
#define NB_ACQ_ACC0_TDENM               _NB_ACQ_ACC0.Bits.TDENM
#define NB_ACQ_ACC0_CADCGM              _NB_ACQ_ACC0.Bits.CADCGM
#define NB_ACQ_ACC0_VADCGM              _NB_ACQ_ACC0.Bits.VADCGM
#define NB_ACQ_ACC0_TADCGM              _NB_ACQ_ACC0.Bits.TADCGM
#define NB_ACQ_ACC0_ECAPM               _NB_ACQ_ACC0.Bits.ECAPM
#define NB_ACQ_ACC0_ZEROM               _NB_ACQ_ACC0.Bits.ZEROM

#define NB_ACQ_ACC0_CDEN_MASK           1U
#define NB_ACQ_ACC0_VDEN_MASK           2U
#define NB_ACQ_ACC0_TDEN_MASK           4U
#define NB_ACQ_ACC0_CADCG_MASK          8U
#define NB_ACQ_ACC0_VADCG_MASK          16U
#define NB_ACQ_ACC0_TADCG_MASK          32U
#define NB_ACQ_ACC0_ECAP_MASK           64U
#define NB_ACQ_ACC0_ZERO_MASK           128U
#define NB_ACQ_ACC0_CDENM_MASK          256U
#define NB_ACQ_ACC0_VDENM_MASK          512U
#define NB_ACQ_ACC0_TDENM_MASK          1024U
#define NB_ACQ_ACC0_CADCGM_MASK         2048U
#define NB_ACQ_ACC0_VADCGM_MASK         4096U
#define NB_ACQ_ACC0_TADCGM_MASK         8192U
#define NB_ACQ_ACC0_ECAPM_MASK          16384U
#define NB_ACQ_ACC0_ZEROM_MASK          32768U


/*** NB_ACQ_DEC - Decimation Rate; 0x00000360 ***/
typedef union {
  byte Byte;
  struct {
    byte DEC         :3;                                       /* Decimation Rate Selection */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_ACQ_DECSTR;
extern volatile NB_ACQ_DECSTR _NB_ACQ_DEC @(REG_BASE + 0x00000360UL);
#define NB_ACQ_DEC                      _NB_ACQ_DEC.Byte
#define NB_ACQ_DEC_DEC                  _NB_ACQ_DEC.Bits.DEC

#define NB_ACQ_DEC_DEC_MASK             7U
#define NB_ACQ_DEC_DEC_BITNUM           0U


/*** NB_ACQ_BGC - Decimation Rate; 0x00000361 ***/
typedef union {
  byte Byte;
  struct {
    byte BG1EN       :1;                                       /* Bandgap Status */
    byte BG2EN       :1;                                       /* Bandgap 3 Status */
    byte BG3EN       :1;                                       /* Bandgap 3 Status */
    byte BGLDO       :1;                                       /* LDO (Low Dropout Regulator) Bandgap select */
    byte BGADC       :2;                                       /* ADC Bandgap select */
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_ACQ_BGCSTR;
extern volatile NB_ACQ_BGCSTR _NB_ACQ_BGC @(REG_BASE + 0x00000361UL);
#define NB_ACQ_BGC                      _NB_ACQ_BGC.Byte
#define NB_ACQ_BGC_BG1EN                _NB_ACQ_BGC.Bits.BG1EN
#define NB_ACQ_BGC_BG2EN                _NB_ACQ_BGC.Bits.BG2EN
#define NB_ACQ_BGC_BG3EN                _NB_ACQ_BGC.Bits.BG3EN
#define NB_ACQ_BGC_BGLDO                _NB_ACQ_BGC.Bits.BGLDO
#define NB_ACQ_BGC_BGADC                _NB_ACQ_BGC.Bits.BGADC

#define NB_ACQ_BGC_BG1EN_MASK           1U
#define NB_ACQ_BGC_BG2EN_MASK           2U
#define NB_ACQ_BGC_BG3EN_MASK           4U
#define NB_ACQ_BGC_BGLDO_MASK           8U
#define NB_ACQ_BGC_BGADC_MASK           48U
#define NB_ACQ_BGC_BGADC_BITNUM         4U


/*** NB_ACQ_GAIN - PGA gain; 0x00000362 ***/
typedef union {
  byte Byte;
  struct {
    byte IGAIN       :3;                                       /* PGA Gain Register */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_ACQ_GAINSTR;
extern volatile NB_ACQ_GAINSTR _NB_ACQ_GAIN @(REG_BASE + 0x00000362UL);
#define NB_ACQ_GAIN                     _NB_ACQ_GAIN.Byte
#define NB_ACQ_GAIN_IGAIN               _NB_ACQ_GAIN.Bits.IGAIN

#define NB_ACQ_GAIN_IGAIN_MASK          7U
#define NB_ACQ_GAIN_IGAIN_BITNUM        0U


/*** NB_ACQ_GCB - PGA gain; 0x00000363 ***/
typedef union {
  byte Byte;
  struct {
    byte Dlo         :4;                                       /* Gain Control Block (GCB) - Down Threshold */
    byte Dhi         :4;                                       /* Gain Control Block (GCB) - Up Threshold */
  } Bits;
} NB_ACQ_GCBSTR;
extern volatile NB_ACQ_GCBSTR _NB_ACQ_GCB @(REG_BASE + 0x00000363UL);
#define NB_ACQ_GCB                      _NB_ACQ_GCB.Byte
#define NB_ACQ_GCB_Dlo                  _NB_ACQ_GCB.Bits.Dlo
#define NB_ACQ_GCB_Dhi                  _NB_ACQ_GCB.Bits.Dhi

#define NB_ACQ_GCB_Dlo_MASK             15U
#define NB_ACQ_GCB_Dlo_BITNUM           0U
#define NB_ACQ_GCB_Dhi_MASK             240U
#define NB_ACQ_GCB_Dhi_BITNUM           4U


/*** NB_ACQ_ITEMP - Internal temperature measurement result; 0x00000364 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ACQ_ITEMPH - Internal temperature measurement result high; 0x00000364 ***/
    union {
      byte Byte;
    } NB_ACQ_ITEMPHSTR;
    #define NB_ACQ_ITEMPH               _NB_ACQ_ITEMP.Overlap_STR.NB_ACQ_ITEMPHSTR.Byte
    

    /*** NB_ACQ_ITEMPL - Internal temperature measurement result low; 0x00000365 ***/
    union {
      byte Byte;
    } NB_ACQ_ITEMPLSTR;
    #define NB_ACQ_ITEMPL               _NB_ACQ_ITEMP.Overlap_STR.NB_ACQ_ITEMPLSTR.Byte
    
  } Overlap_STR;

} NB_ACQ_ITEMPSTR;
extern volatile NB_ACQ_ITEMPSTR _NB_ACQ_ITEMP @(REG_BASE + 0x00000364UL);
#define NB_ACQ_ITEMP                    _NB_ACQ_ITEMP.Word


/*** NB_ACQ_ETEMP - External temperature measurement result; 0x00000366 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ACQ_ETEMPH - External temperature measurement result high; 0x00000366 ***/
    union {
      byte Byte;
    } NB_ACQ_ETEMPHSTR;
    #define NB_ACQ_ETEMPH               _NB_ACQ_ETEMP.Overlap_STR.NB_ACQ_ETEMPHSTR.Byte
    

    /*** NB_ACQ_ETEMPL - External temperature measurement result low; 0x00000367 ***/
    union {
      byte Byte;
    } NB_ACQ_ETEMPLSTR;
    #define NB_ACQ_ETEMPL               _NB_ACQ_ETEMP.Overlap_STR.NB_ACQ_ETEMPLSTR.Byte
    
  } Overlap_STR;

} NB_ACQ_ETEMPSTR;
extern volatile NB_ACQ_ETEMPSTR _NB_ACQ_ETEMP @(REG_BASE + 0x00000366UL);
#define NB_ACQ_ETEMP                    _NB_ACQ_ETEMP.Word


/*** NB_ACQ_CURR1 - Current measurement result 16Bit; 0x00000368 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    byte _Reserved_1[1];
    /*** NB_ACQ_CURR1L - Current measurement result 8Bit; 0x00000369 ***/
    union {
      byte Byte;
    } NB_ACQ_CURR1LSTR;
    #define NB_ACQ_CURR1L               _NB_ACQ_CURR1.Overlap_STR.NB_ACQ_CURR1LSTR.Byte
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word CURR        :8;                                       /* Two's complement 24 Bit signed integer result register for the current measurement channel */
  } Bits;
} NB_ACQ_CURR1STR;
extern volatile NB_ACQ_CURR1STR _NB_ACQ_CURR1 @(REG_BASE + 0x00000368UL);
#define NB_ACQ_CURR1                    _NB_ACQ_CURR1.Word
#define NB_ACQ_CURR1_CURR               _NB_ACQ_CURR1.Bits.CURR

#define NB_ACQ_CURR1_CURR_MASK          65280U
#define NB_ACQ_CURR1_CURR_BITNUM        8U


/*** NB_ACQ_CURR0 - Current measurement result; 0x0000036A ***/
typedef union {
  word Word;
} NB_ACQ_CURR0STR;
extern volatile NB_ACQ_CURR0STR _NB_ACQ_CURR0 @(REG_BASE + 0x0000036AUL);
#define NB_ACQ_CURR0                    _NB_ACQ_CURR0.Word


/*** NB_ACQ_VOLT - Voltage measurement result; 0x0000036C ***/
typedef union {
  word Word;
} NB_ACQ_VOLTSTR;
extern volatile NB_ACQ_VOLTSTR _NB_ACQ_VOLT @(REG_BASE + 0x0000036CUL);
#define NB_ACQ_VOLT                     _NB_ACQ_VOLT.Word


/*** NB_ACQ_LPFC - Low pass filter coefficient number; 0x0000036E ***/
typedef union {
  byte Byte;
  struct {
    byte LPFC        :4;                                       /* Low Pass Filter Coefficient Number */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_ACQ_LPFCSTR;
extern volatile NB_ACQ_LPFCSTR _NB_ACQ_LPFC @(REG_BASE + 0x0000036EUL);
#define NB_ACQ_LPFC                     _NB_ACQ_LPFC.Byte
#define NB_ACQ_LPFC_LPFC                _NB_ACQ_LPFC.Bits.LPFC

#define NB_ACQ_LPFC_LPFC_MASK           15U
#define NB_ACQ_LPFC_LPFC_BITNUM         0U


/*** NB_ACQ_TCMP - Low power trigger current measurement period; 0x00000370 ***/
typedef union {
  word Word;
} NB_ACQ_TCMPSTR;
extern volatile NB_ACQ_TCMPSTR _NB_ACQ_TCMP @(REG_BASE + 0x00000370UL);
#define NB_ACQ_TCMP                     _NB_ACQ_TCMP.Word


/*** NB_ACQ_THF - Low power current threshold filtering period; 0x00000372 ***/
typedef union {
  byte Byte;
} NB_ACQ_THFSTR;
extern volatile NB_ACQ_THFSTR _NB_ACQ_THF @(REG_BASE + 0x00000372UL);
#define NB_ACQ_THF                      _NB_ACQ_THF.Byte


/*** NB_ACQ_CVCR - I and V chopper control register; 0x00000374 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ACQ_CVCRH - I and V chopper control register high; 0x00000374 ***/
    union {
      byte Byte;
      struct {
        byte PGAFM       :1;                                       /* PGA fast mode enable - Mask */
        byte IIRCM       :3;                                       /* IIR Low Pass Filter Configuration - Mask */
        byte DBTM        :2;                                       /* Hold Time After Chopper Swap - Mask */
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_ACQ_CVCRHSTR;
    #define NB_ACQ_CVCRH                _NB_ACQ_CVCR.Overlap_STR.NB_ACQ_CVCRHSTR.Byte
    #define NB_ACQ_CVCRH_PGAFM          _NB_ACQ_CVCR.Overlap_STR.NB_ACQ_CVCRHSTR.Bits.PGAFM
    #define NB_ACQ_CVCRH_IIRCM          _NB_ACQ_CVCR.Overlap_STR.NB_ACQ_CVCRHSTR.Bits.IIRCM
    #define NB_ACQ_CVCRH_DBTM           _NB_ACQ_CVCR.Overlap_STR.NB_ACQ_CVCRHSTR.Bits.DBTM
    
    #define NB_ACQ_CVCRH_PGAFM_MASK     1U
    #define NB_ACQ_CVCRH_IIRCM_MASK     14U
    #define NB_ACQ_CVCRH_IIRCM_BITNUM   1U
    #define NB_ACQ_CVCRH_DBTM_MASK      48U
    #define NB_ACQ_CVCRH_DBTM_BITNUM    4U
    

    /*** NB_ACQ_CVCRL - I and V chopper control register high low; 0x00000375 ***/
    union {
      byte Byte;
      struct {
        byte PGAF        :1;                                       /* PGA fast mode enable */
        byte IIRC        :3;                                       /* IIR Low Pass Filter Coefficient */
        byte DBT         :2;                                       /* Hold Time After Chopper Swap */
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_ACQ_CVCRLSTR;
    #define NB_ACQ_CVCRL                _NB_ACQ_CVCR.Overlap_STR.NB_ACQ_CVCRLSTR.Byte
    #define NB_ACQ_CVCRL_PGAF           _NB_ACQ_CVCR.Overlap_STR.NB_ACQ_CVCRLSTR.Bits.PGAF
    #define NB_ACQ_CVCRL_IIRC           _NB_ACQ_CVCR.Overlap_STR.NB_ACQ_CVCRLSTR.Bits.IIRC
    #define NB_ACQ_CVCRL_DBT            _NB_ACQ_CVCR.Overlap_STR.NB_ACQ_CVCRLSTR.Bits.DBT
    
    #define NB_ACQ_CVCRL_PGAF_MASK      1U
    #define NB_ACQ_CVCRL_IIRC_MASK      14U
    #define NB_ACQ_CVCRL_IIRC_BITNUM    1U
    #define NB_ACQ_CVCRL_DBT_MASK       48U
    #define NB_ACQ_CVCRL_DBT_BITNUM     4U
    
  } Overlap_STR;

  struct {
    word PGAF        :1;                                       /* PGA fast mode enable */
    word IIRC        :3;                                       /* IIR Low Pass Filter Coefficient */
    word DBT         :2;                                       /* Hold Time After Chopper Swap */
    word             :1; 
    word             :1; 
    word PGAFM       :1;                                       /* PGA fast mode enable - Mask */
    word IIRCM       :3;                                       /* IIR Low Pass Filter Configuration - Mask */
    word DBTM        :2;                                       /* Hold Time After Chopper Swap - Mask */
    word             :1; 
    word             :1; 
  } Bits;
} NB_ACQ_CVCRSTR;
extern volatile NB_ACQ_CVCRSTR _NB_ACQ_CVCR @(REG_BASE + 0x00000374UL);
#define NB_ACQ_CVCR                     _NB_ACQ_CVCR.Word
#define NB_ACQ_CVCR_PGAF                _NB_ACQ_CVCR.Bits.PGAF
#define NB_ACQ_CVCR_IIRC                _NB_ACQ_CVCR.Bits.IIRC
#define NB_ACQ_CVCR_DBT                 _NB_ACQ_CVCR.Bits.DBT
#define NB_ACQ_CVCR_PGAFM               _NB_ACQ_CVCR.Bits.PGAFM
#define NB_ACQ_CVCR_IIRCM               _NB_ACQ_CVCR.Bits.IIRCM
#define NB_ACQ_CVCR_DBTM                _NB_ACQ_CVCR.Bits.DBTM

#define NB_ACQ_CVCR_PGAF_MASK           1U
#define NB_ACQ_CVCR_IIRC_MASK           14U
#define NB_ACQ_CVCR_IIRC_BITNUM         1U
#define NB_ACQ_CVCR_DBT_MASK            48U
#define NB_ACQ_CVCR_DBT_BITNUM          4U
#define NB_ACQ_CVCR_PGAFM_MASK          256U
#define NB_ACQ_CVCR_IIRCM_MASK          3584U
#define NB_ACQ_CVCR_IIRCM_BITNUM        9U
#define NB_ACQ_CVCR_DBTM_MASK           12288U
#define NB_ACQ_CVCR_DBTM_BITNUM         12U


/*** NB_ACQ_CTH - Low power current threshold; 0x00000376 ***/
typedef union {
  byte Byte;
} NB_ACQ_CTHSTR;
extern volatile NB_ACQ_CTHSTR _NB_ACQ_CTH @(REG_BASE + 0x00000376UL);
#define NB_ACQ_CTH                      _NB_ACQ_CTH.Byte


/*** NB_ACQ_AHTH - Low power Ah counter threshold; 0x00000378 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** NB_ACQ_AHTH1 - Low power Ah counter threshold 1; 0x00000378 ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** NB_ACQ_AHTH1H - Low power Ah counter threshold 1 high; 0x00000378 ***/
        union {
          byte Byte;
          struct {
            byte AHTH        :7;                                       /* Low power Ah counter threshold 1 high */
            byte             :1; 
          } Bits;
        } NB_ACQ_AHTH1HSTR;
        #define NB_ACQ_AHTH1H           _NB_ACQ_AHTH.Overlap_STR.NB_ACQ_AHTH1STR.Overlap_STR.NB_ACQ_AHTH1HSTR.Byte
        #define NB_ACQ_AHTH1H_AHTH      _NB_ACQ_AHTH.Overlap_STR.NB_ACQ_AHTH1STR.Overlap_STR.NB_ACQ_AHTH1HSTR.Bits.AHTH
        
        #define NB_ACQ_AHTH1H_AHTH_MASK 127U
        #define NB_ACQ_AHTH1H_AHTH_BITNUM 0U
        
    
        /*** NB_ACQ_AHTH1L - Low power Ah counter threshold 1 low; 0x00000379 ***/
        union {
          byte Byte;
        } NB_ACQ_AHTH1LSTR;
        #define NB_ACQ_AHTH1L           _NB_ACQ_AHTH.Overlap_STR.NB_ACQ_AHTH1STR.Overlap_STR.NB_ACQ_AHTH1LSTR.Byte
        
      } Overlap_STR;
    
      struct {
        word AHTH        :15;                                      /* Low power Ah counter threshold 1 */
        word             :1; 
      } Bits;
    } NB_ACQ_AHTH1STR;
    #define NB_ACQ_AHTH1                _NB_ACQ_AHTH.Overlap_STR.NB_ACQ_AHTH1STR.Word
    #define NB_ACQ_AHTH1_AHTH           _NB_ACQ_AHTH.Overlap_STR.NB_ACQ_AHTH1STR.Bits.AHTH
    
    #define NB_ACQ_AHTH1_AHTH_MASK      32767U
    #define NB_ACQ_AHTH1_AHTH_BITNUM    0U
    

    /*** NB_ACQ_AHTH0 - Low power Ah counter threshold 0; 0x0000037A ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** NB_ACQ_AHTH0H - Low power Ah counter threshold 0 high; 0x0000037A ***/
        union {
          byte Byte;
        } NB_ACQ_AHTH0HSTR;
        #define NB_ACQ_AHTH0H           _NB_ACQ_AHTH.Overlap_STR.NB_ACQ_AHTH0STR.Overlap_STR.NB_ACQ_AHTH0HSTR.Byte
        
    
        /*** NB_ACQ_AHTH0L - Low power Ah counter threshold 0 low; 0x0000037B ***/
        union {
          byte Byte;
        } NB_ACQ_AHTH0LSTR;
        #define NB_ACQ_AHTH0L           _NB_ACQ_AHTH.Overlap_STR.NB_ACQ_AHTH0STR.Overlap_STR.NB_ACQ_AHTH0LSTR.Byte
        
      } Overlap_STR;
    
    } NB_ACQ_AHTH0STR;
    #define NB_ACQ_AHTH0                _NB_ACQ_AHTH.Overlap_STR.NB_ACQ_AHTH0STR.Word
    
  } Overlap_STR;

} NB_ACQ_AHTHSTR;
extern volatile NB_ACQ_AHTHSTR _NB_ACQ_AHTH @(REG_BASE + 0x00000378UL);
#define NB_ACQ_AHTH                     _NB_ACQ_AHTH.Dword


/*** NB_ACQ_AHC - Low power Ah counter; 0x0000037C ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** NB_ACQ_AHC1 - Low power Ah counter 1; 0x0000037C ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** NB_ACQ_AHC1H - Low power Ah counter 1 high; 0x0000037C ***/
        union {
          byte Byte;
        } NB_ACQ_AHC1HSTR;
        #define NB_ACQ_AHC1H            _NB_ACQ_AHC.Overlap_STR.NB_ACQ_AHC1STR.Overlap_STR.NB_ACQ_AHC1HSTR.Byte
        
    
        /*** NB_ACQ_AHC1L - Low power Ah counter 1 low; 0x0000037D ***/
        union {
          byte Byte;
        } NB_ACQ_AHC1LSTR;
        #define NB_ACQ_AHC1L            _NB_ACQ_AHC.Overlap_STR.NB_ACQ_AHC1STR.Overlap_STR.NB_ACQ_AHC1LSTR.Byte
        
      } Overlap_STR;
    
    } NB_ACQ_AHC1STR;
    #define NB_ACQ_AHC1                 _NB_ACQ_AHC.Overlap_STR.NB_ACQ_AHC1STR.Word
    

    /*** NB_ACQ_AHC0 - Low power Ah counter 0; 0x0000037E ***/
    union {
      word Word;
       /* Overlapped registers: */
      struct {
        /*** NB_ACQ_AHC0H - Low power Ah counter 0 high; 0x0000037E ***/
        union {
          byte Byte;
        } NB_ACQ_AHC0HSTR;
        #define NB_ACQ_AHC0H            _NB_ACQ_AHC.Overlap_STR.NB_ACQ_AHC0STR.Overlap_STR.NB_ACQ_AHC0HSTR.Byte
        
    
        /*** NB_ACQ_AHC0L - Low power Ah counter 0 low; 0x0000037F ***/
        union {
          byte Byte;
        } NB_ACQ_AHC0LSTR;
        #define NB_ACQ_AHC0L            _NB_ACQ_AHC.Overlap_STR.NB_ACQ_AHC0STR.Overlap_STR.NB_ACQ_AHC0LSTR.Byte
        
      } Overlap_STR;
    
    } NB_ACQ_AHC0STR;
    #define NB_ACQ_AHC0                 _NB_ACQ_AHC.Overlap_STR.NB_ACQ_AHC0STR.Word
    
  } Overlap_STR;

} NB_ACQ_AHCSTR;
extern volatile NB_ACQ_AHCSTR _NB_ACQ_AHC @(REG_BASE + 0x0000037CUL);
#define NB_ACQ_AHC                      _NB_ACQ_AHC.Dword


/*** NB_LPF_A0 - Low Pass Filter Coefficient A0; 0x00000380 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A0H - Low Pass Filter Coefficient A0 high; 0x00000380 ***/
    union {
      byte Byte;
    } NB_LPF_A0HSTR;
    #define NB_LPF_A0H                  _NB_LPF_A0.Overlap_STR.NB_LPF_A0HSTR.Byte
    

    /*** NB_LPF_A0L - Low Pass Filter Coefficient A0 low; 0x00000381 ***/
    union {
      byte Byte;
    } NB_LPF_A0LSTR;
    #define NB_LPF_A0L                  _NB_LPF_A0.Overlap_STR.NB_LPF_A0LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A0STR;
extern volatile NB_LPF_A0STR _NB_LPF_A0 @(REG_BASE + 0x00000380UL);
#define NB_LPF_A0                       _NB_LPF_A0.Word
/* NB_LPF_A_ARR: Access 16 NB_LPF_Ax registers in an array */
#define NB_LPF_A_ARR                    ((volatile word *) &NB_LPF_A0)


/*** NB_LPF_A1 - Low Pass Filter Coefficient A1; 0x00000382 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A1H - Low Pass Filter Coefficient A1 high; 0x00000382 ***/
    union {
      byte Byte;
    } NB_LPF_A1HSTR;
    #define NB_LPF_A1H                  _NB_LPF_A1.Overlap_STR.NB_LPF_A1HSTR.Byte
    

    /*** NB_LPF_A1L - Low Pass Filter Coefficient A1 low; 0x00000383 ***/
    union {
      byte Byte;
    } NB_LPF_A1LSTR;
    #define NB_LPF_A1L                  _NB_LPF_A1.Overlap_STR.NB_LPF_A1LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A1STR;
extern volatile NB_LPF_A1STR _NB_LPF_A1 @(REG_BASE + 0x00000382UL);
#define NB_LPF_A1                       _NB_LPF_A1.Word


/*** NB_LPF_A2 - Low Pass Filter Coefficient A2; 0x00000384 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A2H - Low Pass Filter Coefficient A2 high; 0x00000384 ***/
    union {
      byte Byte;
    } NB_LPF_A2HSTR;
    #define NB_LPF_A2H                  _NB_LPF_A2.Overlap_STR.NB_LPF_A2HSTR.Byte
    

    /*** NB_LPF_A2L - Low Pass Filter Coefficient A2 low; 0x00000385 ***/
    union {
      byte Byte;
    } NB_LPF_A2LSTR;
    #define NB_LPF_A2L                  _NB_LPF_A2.Overlap_STR.NB_LPF_A2LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A2STR;
extern volatile NB_LPF_A2STR _NB_LPF_A2 @(REG_BASE + 0x00000384UL);
#define NB_LPF_A2                       _NB_LPF_A2.Word


/*** NB_LPF_A3 - Low Pass Filter Coefficient A3; 0x00000386 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A3H - Low Pass Filter Coefficient A3 high; 0x00000386 ***/
    union {
      byte Byte;
    } NB_LPF_A3HSTR;
    #define NB_LPF_A3H                  _NB_LPF_A3.Overlap_STR.NB_LPF_A3HSTR.Byte
    

    /*** NB_LPF_A3L - Low Pass Filter Coefficient A3 low; 0x00000387 ***/
    union {
      byte Byte;
    } NB_LPF_A3LSTR;
    #define NB_LPF_A3L                  _NB_LPF_A3.Overlap_STR.NB_LPF_A3LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A3STR;
extern volatile NB_LPF_A3STR _NB_LPF_A3 @(REG_BASE + 0x00000386UL);
#define NB_LPF_A3                       _NB_LPF_A3.Word


/*** NB_LPF_A4 - Low Pass Filter Coefficient A4; 0x00000388 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A4H - Low Pass Filter Coefficient A4 high; 0x00000388 ***/
    union {
      byte Byte;
    } NB_LPF_A4HSTR;
    #define NB_LPF_A4H                  _NB_LPF_A4.Overlap_STR.NB_LPF_A4HSTR.Byte
    

    /*** NB_LPF_A4L - Low Pass Filter Coefficient A4 low; 0x00000389 ***/
    union {
      byte Byte;
    } NB_LPF_A4LSTR;
    #define NB_LPF_A4L                  _NB_LPF_A4.Overlap_STR.NB_LPF_A4LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A4STR;
extern volatile NB_LPF_A4STR _NB_LPF_A4 @(REG_BASE + 0x00000388UL);
#define NB_LPF_A4                       _NB_LPF_A4.Word


/*** NB_LPF_A5 - Low Pass Filter Coefficient A5; 0x0000038A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A5H - Low Pass Filter Coefficient A5 high; 0x0000038A ***/
    union {
      byte Byte;
    } NB_LPF_A5HSTR;
    #define NB_LPF_A5H                  _NB_LPF_A5.Overlap_STR.NB_LPF_A5HSTR.Byte
    

    /*** NB_LPF_A5L - Low Pass Filter Coefficient A5 low; 0x0000038B ***/
    union {
      byte Byte;
    } NB_LPF_A5LSTR;
    #define NB_LPF_A5L                  _NB_LPF_A5.Overlap_STR.NB_LPF_A5LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A5STR;
extern volatile NB_LPF_A5STR _NB_LPF_A5 @(REG_BASE + 0x0000038AUL);
#define NB_LPF_A5                       _NB_LPF_A5.Word


/*** NB_LPF_A6 - Low Pass Filter Coefficient A6; 0x0000038C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A6H - Low Pass Filter Coefficient A6 high; 0x0000038C ***/
    union {
      byte Byte;
    } NB_LPF_A6HSTR;
    #define NB_LPF_A6H                  _NB_LPF_A6.Overlap_STR.NB_LPF_A6HSTR.Byte
    

    /*** NB_LPF_A6L - Low Pass Filter Coefficient A6 low; 0x0000038D ***/
    union {
      byte Byte;
    } NB_LPF_A6LSTR;
    #define NB_LPF_A6L                  _NB_LPF_A6.Overlap_STR.NB_LPF_A6LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A6STR;
extern volatile NB_LPF_A6STR _NB_LPF_A6 @(REG_BASE + 0x0000038CUL);
#define NB_LPF_A6                       _NB_LPF_A6.Word


/*** NB_LPF_A7 - Low Pass Filter Coefficient A7; 0x0000038E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A7H - Low Pass Filter Coefficient A7 high; 0x0000038E ***/
    union {
      byte Byte;
    } NB_LPF_A7HSTR;
    #define NB_LPF_A7H                  _NB_LPF_A7.Overlap_STR.NB_LPF_A7HSTR.Byte
    

    /*** NB_LPF_A7L - Low Pass Filter Coefficient A7 low; 0x0000038F ***/
    union {
      byte Byte;
    } NB_LPF_A7LSTR;
    #define NB_LPF_A7L                  _NB_LPF_A7.Overlap_STR.NB_LPF_A7LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A7STR;
extern volatile NB_LPF_A7STR _NB_LPF_A7 @(REG_BASE + 0x0000038EUL);
#define NB_LPF_A7                       _NB_LPF_A7.Word


/*** NB_LPF_A8 - Low Pass Filter Coefficient A8; 0x00000390 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A8H - Low Pass Filter Coefficient A8 high; 0x00000390 ***/
    union {
      byte Byte;
    } NB_LPF_A8HSTR;
    #define NB_LPF_A8H                  _NB_LPF_A8.Overlap_STR.NB_LPF_A8HSTR.Byte
    

    /*** NB_LPF_A8L - Low Pass Filter Coefficient A8 low; 0x00000391 ***/
    union {
      byte Byte;
    } NB_LPF_A8LSTR;
    #define NB_LPF_A8L                  _NB_LPF_A8.Overlap_STR.NB_LPF_A8LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A8STR;
extern volatile NB_LPF_A8STR _NB_LPF_A8 @(REG_BASE + 0x00000390UL);
#define NB_LPF_A8                       _NB_LPF_A8.Word


/*** NB_LPF_A9 - Low Pass Filter Coefficient A9; 0x00000392 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A9H - Low Pass Filter Coefficient A9 high; 0x00000392 ***/
    union {
      byte Byte;
    } NB_LPF_A9HSTR;
    #define NB_LPF_A9H                  _NB_LPF_A9.Overlap_STR.NB_LPF_A9HSTR.Byte
    

    /*** NB_LPF_A9L - Low Pass Filter Coefficient A9 low; 0x00000393 ***/
    union {
      byte Byte;
    } NB_LPF_A9LSTR;
    #define NB_LPF_A9L                  _NB_LPF_A9.Overlap_STR.NB_LPF_A9LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A9STR;
extern volatile NB_LPF_A9STR _NB_LPF_A9 @(REG_BASE + 0x00000392UL);
#define NB_LPF_A9                       _NB_LPF_A9.Word


/*** NB_LPF_A10 - Low Pass Filter Coefficient A10; 0x00000394 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A10H - Low Pass Filter Coefficient A10 high; 0x00000394 ***/
    union {
      byte Byte;
    } NB_LPF_A10HSTR;
    #define NB_LPF_A10H                 _NB_LPF_A10.Overlap_STR.NB_LPF_A10HSTR.Byte
    

    /*** NB_LPF_A10L - Low Pass Filter Coefficient A10 low; 0x00000395 ***/
    union {
      byte Byte;
    } NB_LPF_A10LSTR;
    #define NB_LPF_A10L                 _NB_LPF_A10.Overlap_STR.NB_LPF_A10LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A10STR;
extern volatile NB_LPF_A10STR _NB_LPF_A10 @(REG_BASE + 0x00000394UL);
#define NB_LPF_A10                      _NB_LPF_A10.Word


/*** NB_LPF_A11 - Low Pass Filter Coefficient A11; 0x00000396 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A11H - Low Pass Filter Coefficient A11 high; 0x00000396 ***/
    union {
      byte Byte;
    } NB_LPF_A11HSTR;
    #define NB_LPF_A11H                 _NB_LPF_A11.Overlap_STR.NB_LPF_A11HSTR.Byte
    

    /*** NB_LPF_A11L - Low Pass Filter Coefficient A11 low; 0x00000397 ***/
    union {
      byte Byte;
    } NB_LPF_A11LSTR;
    #define NB_LPF_A11L                 _NB_LPF_A11.Overlap_STR.NB_LPF_A11LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A11STR;
extern volatile NB_LPF_A11STR _NB_LPF_A11 @(REG_BASE + 0x00000396UL);
#define NB_LPF_A11                      _NB_LPF_A11.Word


/*** NB_LPF_A12 - Low Pass Filter Coefficient A12; 0x00000398 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A12H - Low Pass Filter Coefficient A12 high; 0x00000398 ***/
    union {
      byte Byte;
    } NB_LPF_A12HSTR;
    #define NB_LPF_A12H                 _NB_LPF_A12.Overlap_STR.NB_LPF_A12HSTR.Byte
    

    /*** NB_LPF_A12L - Low Pass Filter Coefficient A12 low; 0x00000399 ***/
    union {
      byte Byte;
    } NB_LPF_A12LSTR;
    #define NB_LPF_A12L                 _NB_LPF_A12.Overlap_STR.NB_LPF_A12LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A12STR;
extern volatile NB_LPF_A12STR _NB_LPF_A12 @(REG_BASE + 0x00000398UL);
#define NB_LPF_A12                      _NB_LPF_A12.Word


/*** NB_LPF_A13 - Low Pass Filter Coefficient A13; 0x0000039A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A13H - Low Pass Filter Coefficient A13 high; 0x0000039A ***/
    union {
      byte Byte;
    } NB_LPF_A13HSTR;
    #define NB_LPF_A13H                 _NB_LPF_A13.Overlap_STR.NB_LPF_A13HSTR.Byte
    

    /*** NB_LPF_A13L - Low Pass Filter Coefficient A13 low; 0x0000039B ***/
    union {
      byte Byte;
    } NB_LPF_A13LSTR;
    #define NB_LPF_A13L                 _NB_LPF_A13.Overlap_STR.NB_LPF_A13LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A13STR;
extern volatile NB_LPF_A13STR _NB_LPF_A13 @(REG_BASE + 0x0000039AUL);
#define NB_LPF_A13                      _NB_LPF_A13.Word


/*** NB_LPF_A14 - Low Pass Filter Coefficient A14; 0x0000039C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A14H - Low Pass Filter Coefficient A14 high; 0x0000039C ***/
    union {
      byte Byte;
    } NB_LPF_A14HSTR;
    #define NB_LPF_A14H                 _NB_LPF_A14.Overlap_STR.NB_LPF_A14HSTR.Byte
    

    /*** NB_LPF_A14L - Low Pass Filter Coefficient A14 low; 0x0000039D ***/
    union {
      byte Byte;
    } NB_LPF_A14LSTR;
    #define NB_LPF_A14L                 _NB_LPF_A14.Overlap_STR.NB_LPF_A14LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A14STR;
extern volatile NB_LPF_A14STR _NB_LPF_A14 @(REG_BASE + 0x0000039CUL);
#define NB_LPF_A14                      _NB_LPF_A14.Word


/*** NB_LPF_A15 - Low Pass Filter Coefficient A15; 0x0000039E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_LPF_A15H - Low Pass Filter Coefficient A15 high; 0x0000039E ***/
    union {
      byte Byte;
    } NB_LPF_A15HSTR;
    #define NB_LPF_A15H                 _NB_LPF_A15.Overlap_STR.NB_LPF_A15HSTR.Byte
    

    /*** NB_LPF_A15L - Low Pass Filter Coefficient A15 low; 0x0000039F ***/
    union {
      byte Byte;
    } NB_LPF_A15LSTR;
    #define NB_LPF_A15L                 _NB_LPF_A15.Overlap_STR.NB_LPF_A15LSTR.Byte
    
  } Overlap_STR;

} NB_LPF_A15STR;
extern volatile NB_LPF_A15STR _NB_LPF_A15 @(REG_BASE + 0x0000039EUL);
#define NB_LPF_A15                      _NB_LPF_A15.Word


/*** NB_COMP_CTL - Compensation control register; 0x000003A0 ***/
typedef union {
  word Word;
  struct {
    word CALIE       :1;                                       /* Calibration IRQ Enable */
    word             :1; 
    word DIAGI       :1;                                       /* Diagnostic Mode Current Channel */
    word DIAGV       :1;                                       /* Diagnostic Mode Voltage Channel */
    word PGAO        :1;                                       /* PGA Offset Calibration Start */
    word PGAZ        :1;                                       /* PGA Input Zero */
    word BGCAL       :2;                                       /* Calibration Band Gap Select */
    word CALIEM      :1;                                       /* Calibration IRQ Enable - Mask */
    word             :1; 
    word DIAGIM      :1;                                       /* Diagnostic Mode Current Channel - Mask */
    word DIAGVM      :1;                                       /* Diagnostic Mode Voltage Channel - Mask */
    word PGAOM       :1;                                       /* PGA Offset Calibration - Mask */
    word PGAZM       :1;                                       /* PGA Input Zero - Mask */
    word BGCALM      :2;                                       /* Calibration Band Gap Select - Mask */
  } Bits;
} NB_COMP_CTLSTR;
extern volatile NB_COMP_CTLSTR _NB_COMP_CTL @(REG_BASE + 0x000003A0UL);
#define NB_COMP_CTL                     _NB_COMP_CTL.Word
#define NB_COMP_CTL_CALIE               _NB_COMP_CTL.Bits.CALIE
#define NB_COMP_CTL_DIAGI               _NB_COMP_CTL.Bits.DIAGI
#define NB_COMP_CTL_DIAGV               _NB_COMP_CTL.Bits.DIAGV
#define NB_COMP_CTL_PGAO                _NB_COMP_CTL.Bits.PGAO
#define NB_COMP_CTL_PGAZ                _NB_COMP_CTL.Bits.PGAZ
#define NB_COMP_CTL_BGCAL               _NB_COMP_CTL.Bits.BGCAL
#define NB_COMP_CTL_CALIEM              _NB_COMP_CTL.Bits.CALIEM
#define NB_COMP_CTL_DIAGIM              _NB_COMP_CTL.Bits.DIAGIM
#define NB_COMP_CTL_DIAGVM              _NB_COMP_CTL.Bits.DIAGVM
#define NB_COMP_CTL_PGAOM               _NB_COMP_CTL.Bits.PGAOM
#define NB_COMP_CTL_PGAZM               _NB_COMP_CTL.Bits.PGAZM
#define NB_COMP_CTL_BGCALM              _NB_COMP_CTL.Bits.BGCALM

#define NB_COMP_CTL_CALIE_MASK          1U
#define NB_COMP_CTL_DIAGI_MASK          4U
#define NB_COMP_CTL_DIAGV_MASK          8U
#define NB_COMP_CTL_PGAO_MASK           16U
#define NB_COMP_CTL_PGAZ_MASK           32U
#define NB_COMP_CTL_BGCAL_MASK          192U
#define NB_COMP_CTL_BGCAL_BITNUM        6U
#define NB_COMP_CTL_CALIEM_MASK         256U
#define NB_COMP_CTL_DIAGIM_MASK         1024U
#define NB_COMP_CTL_DIAGVM_MASK         2048U
#define NB_COMP_CTL_PGAOM_MASK          4096U
#define NB_COMP_CTL_PGAZM_MASK          8192U
#define NB_COMP_CTL_BGCALM_MASK         49152U
#define NB_COMP_CTL_BGCALM_BITNUM       14U


/*** NB_COMP_SR - Compensation status register; 0x000003A2 ***/
typedef union {
  byte Byte;
  struct {
    byte CALF        :1;                                       /* Calibration Request Status Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PGAOF       :1;                                       /* PGA Internal Offset Compensation Complete Flag */
    byte             :1; 
    byte BGFR        :1;                                       /* Band Gap Reference Status Flag */
    byte             :1; 
  } Bits;
} NB_COMP_SRSTR;
extern volatile NB_COMP_SRSTR _NB_COMP_SR @(REG_BASE + 0x000003A2UL);
#define NB_COMP_SR                      _NB_COMP_SR.Byte
#define NB_COMP_SR_CALF                 _NB_COMP_SR.Bits.CALF
#define NB_COMP_SR_PGAOF                _NB_COMP_SR.Bits.PGAOF
#define NB_COMP_SR_BGFR                 _NB_COMP_SR.Bits.BGFR

#define NB_COMP_SR_CALF_MASK            1U
#define NB_COMP_SR_PGAOF_MASK           16U
#define NB_COMP_SR_BGFR_MASK            64U


/*** NB_COMP_TF - Temperature filtering period; 0x000003A3 ***/
typedef union {
  byte Byte;
  struct {
    byte TMF         :3;                                       /* Recalibration Temperature Filtering Period */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_COMP_TFSTR;
extern volatile NB_COMP_TFSTR _NB_COMP_TF @(REG_BASE + 0x000003A3UL);
#define NB_COMP_TF                      _NB_COMP_TF.Byte
#define NB_COMP_TF_TMF                  _NB_COMP_TF.Bits.TMF

#define NB_COMP_TF_TMF_MASK             7U
#define NB_COMP_TF_TMF_BITNUM           0U


/*** NB_COMP_TMAX - Max temp before recalibration; 0x000003A4 ***/
typedef union {
  word Word;
} NB_COMP_TMAXSTR;
extern volatile NB_COMP_TMAXSTR _NB_COMP_TMAX @(REG_BASE + 0x000003A4UL);
#define NB_COMP_TMAX                    _NB_COMP_TMAX.Word


/*** NB_COMP_TMIN - Min temp before recalibration; 0x000003A6 ***/
typedef union {
  word Word;
} NB_COMP_TMINSTR;
extern volatile NB_COMP_TMINSTR _NB_COMP_TMIN @(REG_BASE + 0x000003A6UL);
#define NB_COMP_TMIN                    _NB_COMP_TMIN.Word


/*** NB_COMP_VO - Offset voltage compensation; 0x000003AA ***/
typedef union {
  byte Byte;
} NB_COMP_VOSTR;
extern volatile NB_COMP_VOSTR _NB_COMP_VO @(REG_BASE + 0x000003AAUL);
#define NB_COMP_VO                      _NB_COMP_VO.Byte


/*** NB_COMP_IO - Offset current compensation window; 0x000003AB ***/
typedef union {
  byte Byte;
} NB_COMP_IOSTR;
extern volatile NB_COMP_IOSTR _NB_COMP_IO @(REG_BASE + 0x000003ABUL);
#define NB_COMP_IO                      _NB_COMP_IO.Byte


/*** NB_COMP_VSG - Gain voltage compensation vsense channel; 0x000003AC ***/
typedef union {
  word Word;
  struct {
    word VSGC        :10;                                      /* Voltage Channel Gain Compensation Buffer */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_VSGSTR;
extern volatile NB_COMP_VSGSTR _NB_COMP_VSG @(REG_BASE + 0x000003ACUL);
#define NB_COMP_VSG                     _NB_COMP_VSG.Word
#define NB_COMP_VSG_VSGC                _NB_COMP_VSG.Bits.VSGC

#define NB_COMP_VSG_VSGC_MASK           1023U
#define NB_COMP_VSG_VSGC_BITNUM         0U


/*** NB_COMP_IG4 - Gain Current Compensation 4; 0x000003B0 ***/
typedef union {
  word Word;
  struct {
    word IGC4        :10;                                      /* Current Gain Compensation Buffer 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_IG4STR;
extern volatile NB_COMP_IG4STR _NB_COMP_IG4 @(REG_BASE + 0x000003B0UL);
#define NB_COMP_IG4                     _NB_COMP_IG4.Word
#define NB_COMP_IG4_IGC4                _NB_COMP_IG4.Bits.IGC4

#define NB_COMP_IG4_IGC4_MASK           1023U
#define NB_COMP_IG4_IGC4_BITNUM         0U


/*** NB_COMP_IG8 - Gain Current Compensation 8; 0x000003B2 ***/
typedef union {
  word Word;
  struct {
    word IGC8        :10;                                      /* Current Gain Compensation Buffer 8 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_IG8STR;
extern volatile NB_COMP_IG8STR _NB_COMP_IG8 @(REG_BASE + 0x000003B2UL);
#define NB_COMP_IG8                     _NB_COMP_IG8.Word
#define NB_COMP_IG8_IGC8                _NB_COMP_IG8.Bits.IGC8

#define NB_COMP_IG8_IGC8_MASK           1023U
#define NB_COMP_IG8_IGC8_BITNUM         0U


/*** NB_COMP_IG16 - Gain Current Compensation 16; 0x000003B4 ***/
typedef union {
  word Word;
  struct {
    word IGC16       :10;                                      /* Current Gain Compensation Buffer 16 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_IG16STR;
extern volatile NB_COMP_IG16STR _NB_COMP_IG16 @(REG_BASE + 0x000003B4UL);
#define NB_COMP_IG16                    _NB_COMP_IG16.Word
#define NB_COMP_IG16_IGC16              _NB_COMP_IG16.Bits.IGC16

#define NB_COMP_IG16_IGC16_MASK         1023U
#define NB_COMP_IG16_IGC16_BITNUM       0U


/*** NB_COMP_IG32 - Gain Current Compensation 32; 0x000003B6 ***/
typedef union {
  word Word;
  struct {
    word IGC32       :10;                                      /* Current Gain Compensation Buffer 32 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_IG32STR;
extern volatile NB_COMP_IG32STR _NB_COMP_IG32 @(REG_BASE + 0x000003B6UL);
#define NB_COMP_IG32                    _NB_COMP_IG32.Word
#define NB_COMP_IG32_IGC32              _NB_COMP_IG32.Bits.IGC32

#define NB_COMP_IG32_IGC32_MASK         1023U
#define NB_COMP_IG32_IGC32_BITNUM       0U


/*** NB_COMP_IG64 - Gain Current Compensation 64; 0x000003B8 ***/
typedef union {
  word Word;
  struct {
    word IGC64       :10;                                      /* Current Gain Compensation Buffer 64 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_IG64STR;
extern volatile NB_COMP_IG64STR _NB_COMP_IG64 @(REG_BASE + 0x000003B8UL);
#define NB_COMP_IG64                    _NB_COMP_IG64.Word
#define NB_COMP_IG64_IGC64              _NB_COMP_IG64.Bits.IGC64

#define NB_COMP_IG64_IGC64_MASK         1023U
#define NB_COMP_IG64_IGC64_BITNUM       0U


/*** NB_COMP_IG128 - Gain Current Compensation 128; 0x000003BA ***/
typedef union {
  word Word;
  struct {
    word IGC128      :10;                                      /* Current Gain Compensation Buffer 128 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_IG128STR;
extern volatile NB_COMP_IG128STR _NB_COMP_IG128 @(REG_BASE + 0x000003BAUL);
#define NB_COMP_IG128                   _NB_COMP_IG128.Word
#define NB_COMP_IG128_IGC128            _NB_COMP_IG128.Bits.IGC128

#define NB_COMP_IG128_IGC128_MASK       1023U
#define NB_COMP_IG128_IGC128_BITNUM     0U


/*** NB_COMP_IG256 - Gain Current Compensation 256; 0x000003BC ***/
typedef union {
  word Word;
  struct {
    word IGC256      :10;                                      /* Current Gain Compensation Buffer 256 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_IG256STR;
extern volatile NB_COMP_IG256STR _NB_COMP_IG256 @(REG_BASE + 0x000003BCUL);
#define NB_COMP_IG256                   _NB_COMP_IG256.Word
#define NB_COMP_IG256_IGC256            _NB_COMP_IG256.Bits.IGC256

#define NB_COMP_IG256_IGC256_MASK       1023U
#define NB_COMP_IG256_IGC256_BITNUM     0U


/*** NB_COMP_IG512 - Gain Current Compensation 512; 0x000003BE ***/
typedef union {
  word Word;
  struct {
    word IGC512      :10;                                      /* Current Gain Compensation Buffer 512 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_IG512STR;
extern volatile NB_COMP_IG512STR _NB_COMP_IG512 @(REG_BASE + 0x000003BEUL);
#define NB_COMP_IG512                   _NB_COMP_IG512.Word
#define NB_COMP_IG512_IGC512            _NB_COMP_IG512.Bits.IGC512

#define NB_COMP_IG512_IGC512_MASK       1023U
#define NB_COMP_IG512_IGC512_BITNUM     0U


/*** NB_COMP_PGAO4 - Offset PGA compensation 4; 0x000003C0 ***/
typedef union {
  word Word;
  struct {
    word PGAOC4      :11;                                      /* PGA Offset Compensation Buffer 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_PGAO4STR;
extern volatile NB_COMP_PGAO4STR _NB_COMP_PGAO4 @(REG_BASE + 0x000003C0UL);
#define NB_COMP_PGAO4                   _NB_COMP_PGAO4.Word
#define NB_COMP_PGAO4_PGAOC4            _NB_COMP_PGAO4.Bits.PGAOC4

#define NB_COMP_PGAO4_PGAOC4_MASK       2047U
#define NB_COMP_PGAO4_PGAOC4_BITNUM     0U


/*** NB_COMP_PGAO8 - Offset PGA compensation 8; 0x000003C2 ***/
typedef union {
  word Word;
  struct {
    word PGAOC8      :11;                                      /* PGA Offset Compensation Buffer 8 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_PGAO8STR;
extern volatile NB_COMP_PGAO8STR _NB_COMP_PGAO8 @(REG_BASE + 0x000003C2UL);
#define NB_COMP_PGAO8                   _NB_COMP_PGAO8.Word
#define NB_COMP_PGAO8_PGAOC8            _NB_COMP_PGAO8.Bits.PGAOC8

#define NB_COMP_PGAO8_PGAOC8_MASK       2047U
#define NB_COMP_PGAO8_PGAOC8_BITNUM     0U


/*** NB_COMP_PGAO16 - Offset PGA compensation 16; 0x000003C4 ***/
typedef union {
  word Word;
  struct {
    word PGAOC16     :11;                                      /* PGA Offset Compensation Buffer 16 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_PGAO16STR;
extern volatile NB_COMP_PGAO16STR _NB_COMP_PGAO16 @(REG_BASE + 0x000003C4UL);
#define NB_COMP_PGAO16                  _NB_COMP_PGAO16.Word
#define NB_COMP_PGAO16_PGAOC16          _NB_COMP_PGAO16.Bits.PGAOC16

#define NB_COMP_PGAO16_PGAOC16_MASK     2047U
#define NB_COMP_PGAO16_PGAOC16_BITNUM   0U


/*** NB_COMP_PGAO32 - Offset PGA compensation 32; 0x000003C6 ***/
typedef union {
  word Word;
  struct {
    word PGAOC32     :11;                                      /* PGA Offset Compensation Buffer 32 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_PGAO32STR;
extern volatile NB_COMP_PGAO32STR _NB_COMP_PGAO32 @(REG_BASE + 0x000003C6UL);
#define NB_COMP_PGAO32                  _NB_COMP_PGAO32.Word
#define NB_COMP_PGAO32_PGAOC32          _NB_COMP_PGAO32.Bits.PGAOC32

#define NB_COMP_PGAO32_PGAOC32_MASK     2047U
#define NB_COMP_PGAO32_PGAOC32_BITNUM   0U


/*** NB_COMP_PGAO64 - Offset PGA compensation 64; 0x000003C8 ***/
typedef union {
  word Word;
  struct {
    word PGAOC64     :11;                                      /* PGA Offset Compensation Buffer 64 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_PGAO64STR;
extern volatile NB_COMP_PGAO64STR _NB_COMP_PGAO64 @(REG_BASE + 0x000003C8UL);
#define NB_COMP_PGAO64                  _NB_COMP_PGAO64.Word
#define NB_COMP_PGAO64_PGAOC64          _NB_COMP_PGAO64.Bits.PGAOC64

#define NB_COMP_PGAO64_PGAOC64_MASK     2047U
#define NB_COMP_PGAO64_PGAOC64_BITNUM   0U


/*** NB_COMP_PGAO128 - Offset PGA compensation 128; 0x000003CA ***/
typedef union {
  word Word;
  struct {
    word PGAOC128    :11;                                      /* PGA Offset Compensation Buffer 128 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_PGAO128STR;
extern volatile NB_COMP_PGAO128STR _NB_COMP_PGAO128 @(REG_BASE + 0x000003CAUL);
#define NB_COMP_PGAO128                 _NB_COMP_PGAO128.Word
#define NB_COMP_PGAO128_PGAOC128        _NB_COMP_PGAO128.Bits.PGAOC128

#define NB_COMP_PGAO128_PGAOC128_MASK   2047U
#define NB_COMP_PGAO128_PGAOC128_BITNUM 0U


/*** NB_COMP_PGAO256 - Offset PGA compensation 256; 0x000003CC ***/
typedef union {
  word Word;
  struct {
    word PGAOC256    :11;                                      /* PGA Offset Compensation Buffer 256 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_PGAO256STR;
extern volatile NB_COMP_PGAO256STR _NB_COMP_PGAO256 @(REG_BASE + 0x000003CCUL);
#define NB_COMP_PGAO256                 _NB_COMP_PGAO256.Word
#define NB_COMP_PGAO256_PGAOC256        _NB_COMP_PGAO256.Bits.PGAOC256

#define NB_COMP_PGAO256_PGAOC256_MASK   2047U
#define NB_COMP_PGAO256_PGAOC256_BITNUM 0U


/*** NB_COMP_PGAO512 - Offset PGA compensation 512; 0x000003CE ***/
typedef union {
  word Word;
  struct {
    word PGAOC512    :11;                                      /* PGA Offset Compensation Buffer 512 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_COMP_PGAO512STR;
extern volatile NB_COMP_PGAO512STR _NB_COMP_PGAO512 @(REG_BASE + 0x000003CEUL);
#define NB_COMP_PGAO512                 _NB_COMP_PGAO512.Word
#define NB_COMP_PGAO512_PGAOC512        _NB_COMP_PGAO512.Bits.PGAOC512

#define NB_COMP_PGAO512_PGAOC512_MASK   2047U
#define NB_COMP_PGAO512_PGAOC512_BITNUM 0U


/*** NB_COMP_ITO - Internal temperature offset compensation; 0x000003D0 ***/
typedef union {
  byte Byte;
} NB_COMP_ITOSTR;
extern volatile NB_COMP_ITOSTR _NB_COMP_ITO @(REG_BASE + 0x000003D0UL);
#define NB_COMP_ITO                     _NB_COMP_ITO.Byte


/*** NB_COMP_ITG - Internal temperature gain compensation; 0x000003D1 ***/
typedef union {
  byte Byte;
} NB_COMP_ITGSTR;
extern volatile NB_COMP_ITGSTR _NB_COMP_ITG @(REG_BASE + 0x000003D1UL);
#define NB_COMP_ITG                     _NB_COMP_ITG.Byte


/*** NB_COMP_ETO - External temperature offset compensation; 0x000003D2 ***/
typedef union {
  byte Byte;
} NB_COMP_ETOSTR;
extern volatile NB_COMP_ETOSTR _NB_COMP_ETO @(REG_BASE + 0x000003D2UL);
#define NB_COMP_ETO                     _NB_COMP_ETO.Byte


/*** NB_COMP_ETG - External temperature gain compensation; 0x000003D3 ***/
typedef union {
  byte Byte;
} NB_COMP_ETGSTR;
extern volatile NB_COMP_ETGSTR _NB_COMP_ETG @(REG_BASE + 0x000003D3UL);
#define NB_COMP_ETG                     _NB_COMP_ETG.Byte


/*** NB_TRIM_BG0 - Trim bandgap 0; 0x000003E0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TRIM_BG0H - Trim bandgap 0 high; 0x000003E0 ***/
    union {
      byte Byte;
      struct {
        byte TCIBG1      :3; 
        byte TCIBG2      :3; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_TRIM_BG0HSTR;
    #define NB_TRIM_BG0H                _NB_TRIM_BG0.Overlap_STR.NB_TRIM_BG0HSTR.Byte
    #define NB_TRIM_BG0H_TCIBG1         _NB_TRIM_BG0.Overlap_STR.NB_TRIM_BG0HSTR.Bits.TCIBG1
    #define NB_TRIM_BG0H_TCIBG2         _NB_TRIM_BG0.Overlap_STR.NB_TRIM_BG0HSTR.Bits.TCIBG2
    
    #define NB_TRIM_BG0H_TCIBG1_MASK    7U
    #define NB_TRIM_BG0H_TCIBG1_BITNUM  0U
    #define NB_TRIM_BG0H_TCIBG2_MASK    56U
    #define NB_TRIM_BG0H_TCIBG2_BITNUM  3U
    

    /*** NB_TRIM_BG0L - Trim bandgap 0 low; 0x000003E1 ***/
    union {
      byte Byte;
      struct {
        byte IBG1        :3; 
        byte IBG2        :3; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_TRIM_BG0LSTR;
    #define NB_TRIM_BG0L                _NB_TRIM_BG0.Overlap_STR.NB_TRIM_BG0LSTR.Byte
    #define NB_TRIM_BG0L_IBG1           _NB_TRIM_BG0.Overlap_STR.NB_TRIM_BG0LSTR.Bits.IBG1
    #define NB_TRIM_BG0L_IBG2           _NB_TRIM_BG0.Overlap_STR.NB_TRIM_BG0LSTR.Bits.IBG2
    
    #define NB_TRIM_BG0L_IBG1_MASK      7U
    #define NB_TRIM_BG0L_IBG1_BITNUM    0U
    #define NB_TRIM_BG0L_IBG2_MASK      56U
    #define NB_TRIM_BG0L_IBG2_BITNUM    3U
    
  } Overlap_STR;

  struct {
    word IBG1        :3; 
    word IBG2        :3; 
    word             :1; 
    word             :1; 
    word TCIBG1      :3; 
    word TCIBG2      :3; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_TRIM_BG0STR;
extern volatile NB_TRIM_BG0STR _NB_TRIM_BG0 @(REG_BASE + 0x000003E0UL);
#define NB_TRIM_BG0                     _NB_TRIM_BG0.Word
#define NB_TRIM_BG0_IBG1                _NB_TRIM_BG0.Bits.IBG1
#define NB_TRIM_BG0_IBG2                _NB_TRIM_BG0.Bits.IBG2
#define NB_TRIM_BG0_TCIBG1              _NB_TRIM_BG0.Bits.TCIBG1
#define NB_TRIM_BG0_TCIBG2              _NB_TRIM_BG0.Bits.TCIBG2
/* NB_TRIM_BG_ARR: Access 3 NB_TRIM_BGx registers in an array */
#define NB_TRIM_BG_ARR                  ((volatile word *) &NB_TRIM_BG0)

#define NB_TRIM_BG0_IBG1_MASK           7U
#define NB_TRIM_BG0_IBG1_BITNUM         0U
#define NB_TRIM_BG0_IBG2_MASK           56U
#define NB_TRIM_BG0_IBG2_BITNUM         3U
#define NB_TRIM_BG0_TCIBG1_MASK         1792U
#define NB_TRIM_BG0_TCIBG1_BITNUM       8U
#define NB_TRIM_BG0_TCIBG2_MASK         14336U
#define NB_TRIM_BG0_TCIBG2_BITNUM       11U


/*** NB_TRIM_BG1 - Trim bandgap 1; 0x000003E2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TRIM_BG1H - Trim bandgap 1 high; 0x000003E2 ***/
    union {
      byte Byte;
      struct {
        byte TCBG1       :3; 
        byte TCBG2       :3; 
        byte DBG3        :1; 
        byte UBG3        :1; 
      } Bits;
    } NB_TRIM_BG1HSTR;
    #define NB_TRIM_BG1H                _NB_TRIM_BG1.Overlap_STR.NB_TRIM_BG1HSTR.Byte
    #define NB_TRIM_BG1H_TCBG1          _NB_TRIM_BG1.Overlap_STR.NB_TRIM_BG1HSTR.Bits.TCBG1
    #define NB_TRIM_BG1H_TCBG2          _NB_TRIM_BG1.Overlap_STR.NB_TRIM_BG1HSTR.Bits.TCBG2
    #define NB_TRIM_BG1H_DBG3           _NB_TRIM_BG1.Overlap_STR.NB_TRIM_BG1HSTR.Bits.DBG3
    #define NB_TRIM_BG1H_UBG3           _NB_TRIM_BG1.Overlap_STR.NB_TRIM_BG1HSTR.Bits.UBG3
    
    #define NB_TRIM_BG1H_TCBG1_MASK     7U
    #define NB_TRIM_BG1H_TCBG1_BITNUM   0U
    #define NB_TRIM_BG1H_TCBG2_MASK     56U
    #define NB_TRIM_BG1H_TCBG2_BITNUM   3U
    #define NB_TRIM_BG1H_DBG3_MASK      64U
    #define NB_TRIM_BG1H_UBG3_MASK      128U
    

    /*** NB_TRIM_BG1L - Trim bandgap 1 low; 0x000003E3 ***/
    union {
      byte Byte;
      struct {
        byte SLPBG       :3; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_TRIM_BG1LSTR;
    #define NB_TRIM_BG1L                _NB_TRIM_BG1.Overlap_STR.NB_TRIM_BG1LSTR.Byte
    #define NB_TRIM_BG1L_SLPBG          _NB_TRIM_BG1.Overlap_STR.NB_TRIM_BG1LSTR.Bits.SLPBG
    
    #define NB_TRIM_BG1L_SLPBG_MASK     7U
    #define NB_TRIM_BG1L_SLPBG_BITNUM   0U
    
  } Overlap_STR;

  struct {
    word SLPBG       :3; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word TCBG1       :3; 
    word TCBG2       :3; 
    word DBG3        :1; 
    word UBG3        :1; 
  } Bits;
} NB_TRIM_BG1STR;
extern volatile NB_TRIM_BG1STR _NB_TRIM_BG1 @(REG_BASE + 0x000003E2UL);
#define NB_TRIM_BG1                     _NB_TRIM_BG1.Word
#define NB_TRIM_BG1_SLPBG               _NB_TRIM_BG1.Bits.SLPBG
#define NB_TRIM_BG1_TCBG1               _NB_TRIM_BG1.Bits.TCBG1
#define NB_TRIM_BG1_TCBG2               _NB_TRIM_BG1.Bits.TCBG2
#define NB_TRIM_BG1_DBG3                _NB_TRIM_BG1.Bits.DBG3
#define NB_TRIM_BG1_UBG3                _NB_TRIM_BG1.Bits.UBG3

#define NB_TRIM_BG1_SLPBG_MASK          7U
#define NB_TRIM_BG1_SLPBG_BITNUM        0U
#define NB_TRIM_BG1_TCBG1_MASK          1792U
#define NB_TRIM_BG1_TCBG1_BITNUM        8U
#define NB_TRIM_BG1_TCBG2_MASK          14336U
#define NB_TRIM_BG1_TCBG2_BITNUM        11U
#define NB_TRIM_BG1_DBG3_MASK           16384U
#define NB_TRIM_BG1_UBG3_MASK           32768U


/*** NB_TRIM_BG2 - Trim bandgap 2; 0x000003E4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TRIM_BG2H - Trim bandgap 2 high; 0x000003E4 ***/
    union {
      byte Byte;
      struct {
        byte V1P2BG1     :4; 
        byte V1P2BG2     :4; 
      } Bits;
    } NB_TRIM_BG2HSTR;
    #define NB_TRIM_BG2H                _NB_TRIM_BG2.Overlap_STR.NB_TRIM_BG2HSTR.Byte
    #define NB_TRIM_BG2H_V1P2BG1        _NB_TRIM_BG2.Overlap_STR.NB_TRIM_BG2HSTR.Bits.V1P2BG1
    #define NB_TRIM_BG2H_V1P2BG2        _NB_TRIM_BG2.Overlap_STR.NB_TRIM_BG2HSTR.Bits.V1P2BG2
    
    #define NB_TRIM_BG2H_V1P2BG1_MASK   15U
    #define NB_TRIM_BG2H_V1P2BG1_BITNUM 0U
    #define NB_TRIM_BG2H_V1P2BG2_MASK   240U
    #define NB_TRIM_BG2H_V1P2BG2_BITNUM 4U
    

    /*** NB_TRIM_BG2L - Trim bandgap 2 low; 0x000003E5 ***/
    union {
      byte Byte;
      struct {
        byte V2P5BG1     :4; 
        byte V2P5BG2     :4; 
      } Bits;
    } NB_TRIM_BG2LSTR;
    #define NB_TRIM_BG2L                _NB_TRIM_BG2.Overlap_STR.NB_TRIM_BG2LSTR.Byte
    #define NB_TRIM_BG2L_V2P5BG1        _NB_TRIM_BG2.Overlap_STR.NB_TRIM_BG2LSTR.Bits.V2P5BG1
    #define NB_TRIM_BG2L_V2P5BG2        _NB_TRIM_BG2.Overlap_STR.NB_TRIM_BG2LSTR.Bits.V2P5BG2
    
    #define NB_TRIM_BG2L_V2P5BG1_MASK   15U
    #define NB_TRIM_BG2L_V2P5BG1_BITNUM 0U
    #define NB_TRIM_BG2L_V2P5BG2_MASK   240U
    #define NB_TRIM_BG2L_V2P5BG2_BITNUM 4U
    
  } Overlap_STR;

  struct {
    word V2P5BG1     :4; 
    word V2P5BG2     :4; 
    word V1P2BG1     :4; 
    word V1P2BG2     :4; 
  } Bits;
} NB_TRIM_BG2STR;
extern volatile NB_TRIM_BG2STR _NB_TRIM_BG2 @(REG_BASE + 0x000003E4UL);
#define NB_TRIM_BG2                     _NB_TRIM_BG2.Word
#define NB_TRIM_BG2_V2P5BG1             _NB_TRIM_BG2.Bits.V2P5BG1
#define NB_TRIM_BG2_V2P5BG2             _NB_TRIM_BG2.Bits.V2P5BG2
#define NB_TRIM_BG2_V1P2BG1             _NB_TRIM_BG2.Bits.V1P2BG1
#define NB_TRIM_BG2_V1P2BG2             _NB_TRIM_BG2.Bits.V1P2BG2

#define NB_TRIM_BG2_V2P5BG1_MASK        15U
#define NB_TRIM_BG2_V2P5BG1_BITNUM      0U
#define NB_TRIM_BG2_V2P5BG2_MASK        240U
#define NB_TRIM_BG2_V2P5BG2_BITNUM      4U
#define NB_TRIM_BG2_V1P2BG1_MASK        3840U
#define NB_TRIM_BG2_V1P2BG1_BITNUM      8U
#define NB_TRIM_BG2_V1P2BG2_MASK        61440U
#define NB_TRIM_BG2_V1P2BG2_BITNUM      12U


/*** NB_TRIM_LIN - Trim lin; 0x000003E6 ***/
typedef union {
  byte Byte;
  struct {
    byte LIN         :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_TRIM_LINSTR;
extern volatile NB_TRIM_LINSTR _NB_TRIM_LIN @(REG_BASE + 0x000003E6UL);
#define NB_TRIM_LIN                     _NB_TRIM_LIN.Byte
#define NB_TRIM_LIN_LIN                 _NB_TRIM_LIN.Bits.LIN

#define NB_TRIM_LIN_LIN_MASK            1U


/*** NB_TRIM_LVT - Trim low voltage threshold; 0x000003E7 ***/
typedef union {
  byte Byte;
  struct {
    byte LVT         :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_TRIM_LVTSTR;
extern volatile NB_TRIM_LVTSTR _NB_TRIM_LVT @(REG_BASE + 0x000003E7UL);
#define NB_TRIM_LVT                     _NB_TRIM_LVT.Byte
#define NB_TRIM_LVT_LVT                 _NB_TRIM_LVT.Bits.LVT

#define NB_TRIM_LVT_LVT_MASK            1U


/*** NB_TRIM_OSC - Trim LP oscillator; 0x000003E8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TRIM_OSCH - Trim LP oscillator high; 0x000003E8 ***/
    union {
      byte Byte;
      struct {
        byte LPOSC       :5; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_TRIM_OSCHSTR;
    #define NB_TRIM_OSCH                _NB_TRIM_OSC.Overlap_STR.NB_TRIM_OSCHSTR.Byte
    #define NB_TRIM_OSCH_LPOSC          _NB_TRIM_OSC.Overlap_STR.NB_TRIM_OSCHSTR.Bits.LPOSC
    
    #define NB_TRIM_OSCH_LPOSC_MASK     31U
    #define NB_TRIM_OSCH_LPOSC_BITNUM   0U
    

    /*** NB_TRIM_OSCL - Trim LP oscillator low; 0x000003E9 ***/
    union {
      byte Byte;
    } NB_TRIM_OSCLSTR;
    #define NB_TRIM_OSCL                _NB_TRIM_OSC.Overlap_STR.NB_TRIM_OSCLSTR.Byte
    
  } Overlap_STR;

  struct {
    word LPOSC       :13; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NB_TRIM_OSCSTR;
extern volatile NB_TRIM_OSCSTR _NB_TRIM_OSC @(REG_BASE + 0x000003E8UL);
#define NB_TRIM_OSC                     _NB_TRIM_OSC.Word
#define NB_TRIM_OSC_LPOSC               _NB_TRIM_OSC.Bits.LPOSC

#define NB_TRIM_OSC_LPOSC_MASK          8191U
#define NB_TRIM_OSC_LPOSC_BITNUM        0U


/*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Comparison Key Bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Comparison Key Bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Comparison Key Bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Comparison Key Bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Comparison Key Bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Comparison Key Bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Comparison Key Bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Comparison Key Bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Comparison Key Bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Comparison Key Bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Comparison Key Bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Comparison Key Bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Comparison Key Bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Comparison Key Bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Comparison Key Bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Comparison Key Bits, bit 15 */
  } Bits;
} BAKEY0STR;
/* Tip for register initialization in the user code:  const word BAKEY0_INIT @0x0000FF00 = <BAKEY0_INITVAL>; */
#define _BAKEY0 (*(const BAKEY0STR *)0x0000FF00)
#define BAKEY0                          _BAKEY0.Word
#define BAKEY0_KEY0                     _BAKEY0.Bits.KEY0
#define BAKEY0_KEY1                     _BAKEY0.Bits.KEY1
#define BAKEY0_KEY2                     _BAKEY0.Bits.KEY2
#define BAKEY0_KEY3                     _BAKEY0.Bits.KEY3
#define BAKEY0_KEY4                     _BAKEY0.Bits.KEY4
#define BAKEY0_KEY5                     _BAKEY0.Bits.KEY5
#define BAKEY0_KEY6                     _BAKEY0.Bits.KEY6
#define BAKEY0_KEY7                     _BAKEY0.Bits.KEY7
#define BAKEY0_KEY8                     _BAKEY0.Bits.KEY8
#define BAKEY0_KEY9                     _BAKEY0.Bits.KEY9
#define BAKEY0_KEY10                    _BAKEY0.Bits.KEY10
#define BAKEY0_KEY11                    _BAKEY0.Bits.KEY11
#define BAKEY0_KEY12                    _BAKEY0.Bits.KEY12
#define BAKEY0_KEY13                    _BAKEY0.Bits.KEY13
#define BAKEY0_KEY14                    _BAKEY0.Bits.KEY14
#define BAKEY0_KEY15                    _BAKEY0.Bits.KEY15
/* BAKEY_ARR: Access 4 BAKEYx registers in an array */
#define BAKEY_ARR                       ((volatile word *) &BAKEY0)

#define BAKEY0_KEY0_MASK                1U
#define BAKEY0_KEY1_MASK                2U
#define BAKEY0_KEY2_MASK                4U
#define BAKEY0_KEY3_MASK                8U
#define BAKEY0_KEY4_MASK                16U
#define BAKEY0_KEY5_MASK                32U
#define BAKEY0_KEY6_MASK                64U
#define BAKEY0_KEY7_MASK                128U
#define BAKEY0_KEY8_MASK                256U
#define BAKEY0_KEY9_MASK                512U
#define BAKEY0_KEY10_MASK               1024U
#define BAKEY0_KEY11_MASK               2048U
#define BAKEY0_KEY12_MASK               4096U
#define BAKEY0_KEY13_MASK               8192U
#define BAKEY0_KEY14_MASK               16384U
#define BAKEY0_KEY15_MASK               32768U


/*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Comparison Key Bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Comparison Key Bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Comparison Key Bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Comparison Key Bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Comparison Key Bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Comparison Key Bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Comparison Key Bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Comparison Key Bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Comparison Key Bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Comparison Key Bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Comparison Key Bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Comparison Key Bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Comparison Key Bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Comparison Key Bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Comparison Key Bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Comparison Key Bits, bit 15 */
  } Bits;
} BAKEY1STR;
/* Tip for register initialization in the user code:  const word BAKEY1_INIT @0x0000FF02 = <BAKEY1_INITVAL>; */
#define _BAKEY1 (*(const BAKEY1STR *)0x0000FF02)
#define BAKEY1                          _BAKEY1.Word
#define BAKEY1_KEY0                     _BAKEY1.Bits.KEY0
#define BAKEY1_KEY1                     _BAKEY1.Bits.KEY1
#define BAKEY1_KEY2                     _BAKEY1.Bits.KEY2
#define BAKEY1_KEY3                     _BAKEY1.Bits.KEY3
#define BAKEY1_KEY4                     _BAKEY1.Bits.KEY4
#define BAKEY1_KEY5                     _BAKEY1.Bits.KEY5
#define BAKEY1_KEY6                     _BAKEY1.Bits.KEY6
#define BAKEY1_KEY7                     _BAKEY1.Bits.KEY7
#define BAKEY1_KEY8                     _BAKEY1.Bits.KEY8
#define BAKEY1_KEY9                     _BAKEY1.Bits.KEY9
#define BAKEY1_KEY10                    _BAKEY1.Bits.KEY10
#define BAKEY1_KEY11                    _BAKEY1.Bits.KEY11
#define BAKEY1_KEY12                    _BAKEY1.Bits.KEY12
#define BAKEY1_KEY13                    _BAKEY1.Bits.KEY13
#define BAKEY1_KEY14                    _BAKEY1.Bits.KEY14
#define BAKEY1_KEY15                    _BAKEY1.Bits.KEY15

#define BAKEY1_KEY0_MASK                1U
#define BAKEY1_KEY1_MASK                2U
#define BAKEY1_KEY2_MASK                4U
#define BAKEY1_KEY3_MASK                8U
#define BAKEY1_KEY4_MASK                16U
#define BAKEY1_KEY5_MASK                32U
#define BAKEY1_KEY6_MASK                64U
#define BAKEY1_KEY7_MASK                128U
#define BAKEY1_KEY8_MASK                256U
#define BAKEY1_KEY9_MASK                512U
#define BAKEY1_KEY10_MASK               1024U
#define BAKEY1_KEY11_MASK               2048U
#define BAKEY1_KEY12_MASK               4096U
#define BAKEY1_KEY13_MASK               8192U
#define BAKEY1_KEY14_MASK               16384U
#define BAKEY1_KEY15_MASK               32768U


/*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Comparison Key Bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Comparison Key Bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Comparison Key Bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Comparison Key Bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Comparison Key Bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Comparison Key Bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Comparison Key Bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Comparison Key Bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Comparison Key Bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Comparison Key Bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Comparison Key Bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Comparison Key Bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Comparison Key Bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Comparison Key Bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Comparison Key Bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Comparison Key Bits, bit 15 */
  } Bits;
} BAKEY2STR;
/* Tip for register initialization in the user code:  const word BAKEY2_INIT @0x0000FF04 = <BAKEY2_INITVAL>; */
#define _BAKEY2 (*(const BAKEY2STR *)0x0000FF04)
#define BAKEY2                          _BAKEY2.Word
#define BAKEY2_KEY0                     _BAKEY2.Bits.KEY0
#define BAKEY2_KEY1                     _BAKEY2.Bits.KEY1
#define BAKEY2_KEY2                     _BAKEY2.Bits.KEY2
#define BAKEY2_KEY3                     _BAKEY2.Bits.KEY3
#define BAKEY2_KEY4                     _BAKEY2.Bits.KEY4
#define BAKEY2_KEY5                     _BAKEY2.Bits.KEY5
#define BAKEY2_KEY6                     _BAKEY2.Bits.KEY6
#define BAKEY2_KEY7                     _BAKEY2.Bits.KEY7
#define BAKEY2_KEY8                     _BAKEY2.Bits.KEY8
#define BAKEY2_KEY9                     _BAKEY2.Bits.KEY9
#define BAKEY2_KEY10                    _BAKEY2.Bits.KEY10
#define BAKEY2_KEY11                    _BAKEY2.Bits.KEY11
#define BAKEY2_KEY12                    _BAKEY2.Bits.KEY12
#define BAKEY2_KEY13                    _BAKEY2.Bits.KEY13
#define BAKEY2_KEY14                    _BAKEY2.Bits.KEY14
#define BAKEY2_KEY15                    _BAKEY2.Bits.KEY15

#define BAKEY2_KEY0_MASK                1U
#define BAKEY2_KEY1_MASK                2U
#define BAKEY2_KEY2_MASK                4U
#define BAKEY2_KEY3_MASK                8U
#define BAKEY2_KEY4_MASK                16U
#define BAKEY2_KEY5_MASK                32U
#define BAKEY2_KEY6_MASK                64U
#define BAKEY2_KEY7_MASK                128U
#define BAKEY2_KEY8_MASK                256U
#define BAKEY2_KEY9_MASK                512U
#define BAKEY2_KEY10_MASK               1024U
#define BAKEY2_KEY11_MASK               2048U
#define BAKEY2_KEY12_MASK               4096U
#define BAKEY2_KEY13_MASK               8192U
#define BAKEY2_KEY14_MASK               16384U
#define BAKEY2_KEY15_MASK               32768U


/*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Comparison Key Bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Comparison Key Bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Comparison Key Bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Comparison Key Bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Comparison Key Bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Comparison Key Bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Comparison Key Bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Comparison Key Bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Comparison Key Bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Comparison Key Bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Comparison Key Bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Comparison Key Bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Comparison Key Bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Comparison Key Bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Comparison Key Bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Comparison Key Bits, bit 15 */
  } Bits;
} BAKEY3STR;
/* Tip for register initialization in the user code:  const word BAKEY3_INIT @0x0000FF06 = <BAKEY3_INITVAL>; */
#define _BAKEY3 (*(const BAKEY3STR *)0x0000FF06)
#define BAKEY3                          _BAKEY3.Word
#define BAKEY3_KEY0                     _BAKEY3.Bits.KEY0
#define BAKEY3_KEY1                     _BAKEY3.Bits.KEY1
#define BAKEY3_KEY2                     _BAKEY3.Bits.KEY2
#define BAKEY3_KEY3                     _BAKEY3.Bits.KEY3
#define BAKEY3_KEY4                     _BAKEY3.Bits.KEY4
#define BAKEY3_KEY5                     _BAKEY3.Bits.KEY5
#define BAKEY3_KEY6                     _BAKEY3.Bits.KEY6
#define BAKEY3_KEY7                     _BAKEY3.Bits.KEY7
#define BAKEY3_KEY8                     _BAKEY3.Bits.KEY8
#define BAKEY3_KEY9                     _BAKEY3.Bits.KEY9
#define BAKEY3_KEY10                    _BAKEY3.Bits.KEY10
#define BAKEY3_KEY11                    _BAKEY3.Bits.KEY11
#define BAKEY3_KEY12                    _BAKEY3.Bits.KEY12
#define BAKEY3_KEY13                    _BAKEY3.Bits.KEY13
#define BAKEY3_KEY14                    _BAKEY3.Bits.KEY14
#define BAKEY3_KEY15                    _BAKEY3.Bits.KEY15

#define BAKEY3_KEY0_MASK                1U
#define BAKEY3_KEY1_MASK                2U
#define BAKEY3_KEY2_MASK                4U
#define BAKEY3_KEY3_MASK                8U
#define BAKEY3_KEY4_MASK                16U
#define BAKEY3_KEY5_MASK                32U
#define BAKEY3_KEY6_MASK                64U
#define BAKEY3_KEY7_MASK                128U
#define BAKEY3_KEY8_MASK                256U
#define BAKEY3_KEY9_MASK                512U
#define BAKEY3_KEY10_MASK               1024U
#define BAKEY3_KEY11_MASK               2048U
#define BAKEY3_KEY12_MASK               4096U
#define BAKEY3_KEY13_MASK               8192U
#define BAKEY3_KEY14_MASK               16384U
#define BAKEY3_KEY15_MASK               32768U


/*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address Size Bit 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address Size Bit 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower Address Range Disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher Address Size Bit 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher Address Size Bit 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher Address Range Disable */
    byte RNV6        :1;                                       /* Reserved Nonvolatile Bit */
    byte FPOPEN      :1;                                       /* Flash Protection Operation Enable */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} NVFPROTSTR;
/* Tip for register initialization in the user code:  const byte NVFPROT_INIT @0x0000FF0C = <NVFPROT_INITVAL>; */
#define _NVFPROT (*(const NVFPROTSTR *)0x0000FF0C)
#define NVFPROT                         _NVFPROT.Byte
#define NVFPROT_FPLS0                   _NVFPROT.Bits.FPLS0
#define NVFPROT_FPLS1                   _NVFPROT.Bits.FPLS1
#define NVFPROT_FPLDIS                  _NVFPROT.Bits.FPLDIS
#define NVFPROT_FPHS0                   _NVFPROT.Bits.FPHS0
#define NVFPROT_FPHS1                   _NVFPROT.Bits.FPHS1
#define NVFPROT_FPHDIS                  _NVFPROT.Bits.FPHDIS
#define NVFPROT_RNV6                    _NVFPROT.Bits.RNV6
#define NVFPROT_FPOPEN                  _NVFPROT.Bits.FPOPEN
#define NVFPROT_FPLS                    _NVFPROT.MergedBits.grpFPLS
#define NVFPROT_FPHS                    _NVFPROT.MergedBits.grpFPHS

#define NVFPROT_FPLS0_MASK              1U
#define NVFPROT_FPLS1_MASK              2U
#define NVFPROT_FPLDIS_MASK             4U
#define NVFPROT_FPHS0_MASK              8U
#define NVFPROT_FPHS1_MASK              16U
#define NVFPROT_FPHDIS_MASK             32U
#define NVFPROT_RNV6_MASK               64U
#define NVFPROT_FPOPEN_MASK             128U
#define NVFPROT_FPLS_MASK               3U
#define NVFPROT_FPLS_BITNUM             0U
#define NVFPROT_FPHS_MASK               24U
#define NVFPROT_FPHS_BITNUM             3U


/*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***/
typedef union {
  byte Byte;
  struct {
    byte DPS0        :1;                                       /* D-Flash Protection Size Bit 0 */
    byte DPS1        :1;                                       /* D-Flash Protection Size Bit 1 */
    byte DPS2        :1;                                       /* D-Flash Protection Size Bit 2 */
    byte DPS3        :1;                                       /* D-Flash Protection Size Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte DPOPEN      :1;                                       /* D-Flash Protection Control */
  } Bits;
  struct {
    byte grpDPS  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NVDFPROTSTR;
/* Tip for register initialization in the user code:  const byte NVDFPROT_INIT @0x0000FF0D = <NVDFPROT_INITVAL>; */
#define _NVDFPROT (*(const NVDFPROTSTR *)0x0000FF0D)
#define NVDFPROT                        _NVDFPROT.Byte
#define NVDFPROT_DPS0                   _NVDFPROT.Bits.DPS0
#define NVDFPROT_DPS1                   _NVDFPROT.Bits.DPS1
#define NVDFPROT_DPS2                   _NVDFPROT.Bits.DPS2
#define NVDFPROT_DPS3                   _NVDFPROT.Bits.DPS3
#define NVDFPROT_DPOPEN                 _NVDFPROT.Bits.DPOPEN
#define NVDFPROT_DPS                    _NVDFPROT.MergedBits.grpDPS

#define NVDFPROT_DPS0_MASK              1U
#define NVDFPROT_DPS1_MASK              2U
#define NVDFPROT_DPS2_MASK              4U
#define NVDFPROT_DPS3_MASK              8U
#define NVDFPROT_DPOPEN_MASK            128U
#define NVDFPROT_DPS_MASK               15U
#define NVDFPROT_DPS_BITNUM             0U


/*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Nonvolatile Bit 0 */
    byte NV1         :1;                                       /* Nonvolatile Bit 1 */
    byte NV2         :1;                                       /* Nonvolatile Bit 2 */
    byte NV3         :1;                                       /* Nonvolatile Bit 3 */
    byte NV4         :1;                                       /* Nonvolatile Bit 4 */
    byte NV5         :1;                                       /* Nonvolatile Bit 5 */
    byte NV6         :1;                                       /* Nonvolatile Bit 6 */
    byte NV7         :1;                                       /* Nonvolatile Bit 7 */
  } Bits;
} NVFOPTSTR;
/* Tip for register initialization in the user code:  const byte NVFOPT_INIT @0x0000FF0E = <NVFOPT_INITVAL>; */
#define _NVFOPT (*(const NVFOPTSTR *)0x0000FF0E)
#define NVFOPT                          _NVFOPT.Byte
#define NVFOPT_NV0                      _NVFOPT.Bits.NV0
#define NVFOPT_NV1                      _NVFOPT.Bits.NV1
#define NVFOPT_NV2                      _NVFOPT.Bits.NV2
#define NVFOPT_NV3                      _NVFOPT.Bits.NV3
#define NVFOPT_NV4                      _NVFOPT.Bits.NV4
#define NVFOPT_NV5                      _NVFOPT.Bits.NV5
#define NVFOPT_NV6                      _NVFOPT.Bits.NV6
#define NVFOPT_NV7                      _NVFOPT.Bits.NV7

#define NVFOPT_NV0_MASK                 1U
#define NVFOPT_NV1_MASK                 2U
#define NVFOPT_NV2_MASK                 4U
#define NVFOPT_NV3_MASK                 8U
#define NVFOPT_NV4_MASK                 16U
#define NVFOPT_NV5_MASK                 32U
#define NVFOPT_NV6_MASK                 64U
#define NVFOPT_NV7_MASK                 128U


/*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte RNV2        :1;                                       /* Reserved Nonvolatile Bit 2 */
    byte RNV3        :1;                                       /* Reserved Nonvolatile Bit 3 */
    byte RNV4        :1;                                       /* Reserved Nonvolatile Bit 4 */
    byte RNV5        :1;                                       /* Reserved Nonvolatile Bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} NVFSECSTR;
/* Tip for register initialization in the user code:  const byte NVFSEC_INIT @0x0000FF0F = <NVFSEC_INITVAL>; */
#define _NVFSEC (*(const NVFSECSTR *)0x0000FF0F)
#define NVFSEC                          _NVFSEC.Byte
#define NVFSEC_SEC0                     _NVFSEC.Bits.SEC0
#define NVFSEC_SEC1                     _NVFSEC.Bits.SEC1
#define NVFSEC_RNV2                     _NVFSEC.Bits.RNV2
#define NVFSEC_RNV3                     _NVFSEC.Bits.RNV3
#define NVFSEC_RNV4                     _NVFSEC.Bits.RNV4
#define NVFSEC_RNV5                     _NVFSEC.Bits.RNV5
#define NVFSEC_KEYEN0                   _NVFSEC.Bits.KEYEN0
#define NVFSEC_KEYEN1                   _NVFSEC.Bits.KEYEN1
#define NVFSEC_SEC                      _NVFSEC.MergedBits.grpSEC
#define NVFSEC_RNV_2                    _NVFSEC.MergedBits.grpRNV_2
#define NVFSEC_KEYEN                    _NVFSEC.MergedBits.grpKEYEN
#define NVFSEC_RNV                      NVFSEC_RNV_2

#define NVFSEC_SEC0_MASK                1U
#define NVFSEC_SEC1_MASK                2U
#define NVFSEC_RNV2_MASK                4U
#define NVFSEC_RNV3_MASK                8U
#define NVFSEC_RNV4_MASK                16U
#define NVFSEC_RNV5_MASK                32U
#define NVFSEC_KEYEN0_MASK              64U
#define NVFSEC_KEYEN1_MASK              128U
#define NVFSEC_SEC_MASK                 3U
#define NVFSEC_SEC_BITNUM               0U
#define NVFSEC_RNV_2_MASK               60U
#define NVFSEC_RNV_2_BITNUM             2U
#define NVFSEC_KEYEN_MASK               192U
#define NVFSEC_KEYEN_BITNUM             6U


  /* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() (void)(CPMUARMCOP = 0x55U, CPMUARMCOP = 0xAAU)
#endif
#endif /* __RESET_WATCHDOG */


/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/
/* --------------------------------------------------------------------------- */
/* The following symbols were removed, because they were invalid or irrelevant */
/* --------------------------------------------------------------------------- */



/* **** 2/1/2012 3:55:23 PM */

#define MMCCTL1                          This_symb_has_been_depreciated
#define MMCCTL1_IFRON                    This_symb_has_been_depreciated
#define MMCCTL1_IFRON_MASK               This_symb_has_been_depreciated
#define B_PCR_CTL_D2DSM                  This_symb_has_been_depreciated
#define B_PCR_CTL_D2DSMM                 This_symb_has_been_depreciated
#define B_PCR_CTL_D2DSM_MASK             This_symb_has_been_depreciated
#define B_PCR_CTL_D2DSMM_MASK            This_symb_has_been_depreciated
#define NB_PCR_CTL_D2DSM                 This_symb_has_been_depreciated
#define NB_PCR_CTL_D2DSMM                This_symb_has_been_depreciated
#define NB_PCR_CTL_D2DSM_MASK            This_symb_has_been_depreciated
#define NB_PCR_CTL_D2DSMM_MASK           This_symb_has_been_depreciated

#ifndef __V30COMPATIBLE__
#pragma OPTION DEL V30toV31Compatible
#endif
/*lint -restore  +esym(961,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */
#endif
