/* Based on CPU DB MM912H634_48, version 3.00.000 (RegistersPrg V2.33) */
/*
** ###################################################################
**     Filename  : mm912h634.h
**     Processor : MM912H634
**     FileFormat: V2.33
**     DataSheet : MM912x634D1 Rev. 7.0, 04/2012
**     Compiler  : CodeWarrior compiler
**     Date/Time : 7.8.2012, 15:15
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 29.5.2012, V3.00.1:
**              - Corrected names of bits PORTB[PE1,PE0] and DDRB[DDRE1,DDRE0]
**      - 7.8.2012, V3.00.2:
**              - Corrected RAM size
**
**     File-Format-Revisions:
**      - 15.09.2010, V2.33 :
**               - Empty union is not generated for data overlapping registers, cause there is no bit access
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MM912H634_H
#define _MM912H634_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vsi                63U
#define VectorNumber_VReserved62        62U
#define VectorNumber_VReserved61        61U
#define VectorNumber_VReserved60        60U
#define VectorNumber_VReserved59        59U
#define VectorNumber_Vlvi               58U
#define VectorNumber_VReserved57        57U
#define VectorNumber_VReserved56        56U
#define VectorNumber_VReserved55        55U
#define VectorNumber_VReserved54        54U
#define VectorNumber_VReserved53        53U
#define VectorNumber_VReserved52        52U
#define VectorNumber_VReserved51        51U
#define VectorNumber_VReserved50        50U
#define VectorNumber_VReserved49        49U
#define VectorNumber_VReserved48        48U
#define VectorNumber_VReserved47        47U
#define VectorNumber_VReserved46        46U
#define VectorNumber_VReserved45        45U
#define VectorNumber_VReserved44        44U
#define VectorNumber_VReserved43        43U
#define VectorNumber_VReserved42        42U
#define VectorNumber_VReserved41        41U
#define VectorNumber_VReserved40        40U
#define VectorNumber_VReserved39        39U
#define VectorNumber_VReserved38        38U
#define VectorNumber_VReserved37        37U
#define VectorNumber_VReserved36        36U
#define VectorNumber_Vflash             35U
#define VectorNumber_Vflashfd           34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_VReserved32        32U
#define VectorNumber_VReserved31        31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_VReserved29        29U
#define VectorNumber_Vcpmuplllck        28U
#define VectorNumber_Vcpmuocsns         27U
#define VectorNumber_VReserved26        26U
#define VectorNumber_VReserved25        25U
#define VectorNumber_VReserved24        24U
#define VectorNumber_VReserved23        23U
#define VectorNumber_VReserved22        22U
#define VectorNumber_VReserved21        21U
#define VectorNumber_VReserved20        20U
#define VectorNumber_Vspi               19U
#define VectorNumber_VReserved18        18U
#define VectorNumber_VReserved17        17U
#define VectorNumber_VReserved16        16U
#define VectorNumber_VReserved15        15U
#define VectorNumber_VReserved14        14U
#define VectorNumber_VReserved13        13U
#define VectorNumber_VReserved12        12U
#define VectorNumber_VReserved11        11U
#define VectorNumber_VReserved10        10U
#define VectorNumber_VReserved9         9U
#define VectorNumber_VReserved8         8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Vd2di_ext          6U
#define VectorNumber_Vd2di_err          5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define Vsi                             0xFF80U
#define VReserved62                     0xFF82U
#define VReserved61                     0xFF84U
#define VReserved60                     0xFF86U
#define VReserved59                     0xFF88U
#define Vlvi                            0xFF8AU
#define VReserved57                     0xFF8CU
#define VReserved56                     0xFF8EU
#define VReserved55                     0xFF90U
#define VReserved54                     0xFF92U
#define VReserved53                     0xFF94U
#define VReserved52                     0xFF96U
#define VReserved51                     0xFF98U
#define VReserved50                     0xFF9AU
#define VReserved49                     0xFF9CU
#define VReserved48                     0xFF9EU
#define VReserved47                     0xFFA0U
#define VReserved46                     0xFFA2U
#define VReserved45                     0xFFA4U
#define VReserved44                     0xFFA6U
#define VReserved43                     0xFFA8U
#define VReserved42                     0xFFAAU
#define VReserved41                     0xFFACU
#define VReserved40                     0xFFAEU
#define VReserved39                     0xFFB0U
#define VReserved38                     0xFFB2U
#define VReserved37                     0xFFB4U
#define VReserved36                     0xFFB6U
#define Vflash                          0xFFB8U
#define Vflashfd                        0xFFBAU
#define VReserved33                     0xFFBCU
#define VReserved32                     0xFFBEU
#define VReserved31                     0xFFC0U
#define VReserved30                     0xFFC2U
#define VReserved29                     0xFFC4U
#define Vcpmuplllck                     0xFFC6U
#define Vcpmuocsns                      0xFFC8U
#define VReserved26                     0xFFCAU
#define VReserved25                     0xFFCCU
#define VReserved24                     0xFFCEU
#define VReserved23                     0xFFD0U
#define VReserved22                     0xFFD2U
#define VReserved21                     0xFFD4U
#define VReserved20                     0xFFD6U
#define Vspi                            0xFFD8U
#define VReserved18                     0xFFDAU
#define VReserved17                     0xFFDCU
#define VReserved16                     0xFFDEU
#define VReserved15                     0xFFE0U
#define VReserved14                     0xFFE2U
#define VReserved13                     0xFFE4U
#define VReserved12                     0xFFE6U
#define VReserved11                     0xFFE8U
#define VReserved10                     0xFFEAU
#define VReserved9                      0xFFECU
#define VReserved8                      0xFFEEU
#define Vrti                            0xFFF0U
#define Vd2di_ext                       0xFFF2U
#define Vd2di_err                       0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTA - Port A Data Register; 0x00000000 ***/
typedef union {
  byte Byte;
  struct {
    byte PA0         :1;                                       /* Port A Bit 0 */
    byte PA1         :1;                                       /* Port A Bit 1 */
    byte PA2         :1;                                       /* Port A Bit 2 */
    byte PA3         :1;                                       /* Port A Bit 3 */
    byte PA4         :1;                                       /* Port A Bit 4 */
    byte PA5         :1;                                       /* Port A Bit 5 */
    byte PA6         :1;                                       /* Port A Bit 6 */
    byte PA7         :1;                                       /* Port A Bit 7 */
  } Bits;
} PORTASTR;
extern volatile PORTASTR _PORTA @(REG_BASE + 0x00000000UL);
#define PORTA                           _PORTA.Byte
#define PORTA_PA0                       _PORTA.Bits.PA0
#define PORTA_PA1                       _PORTA.Bits.PA1
#define PORTA_PA2                       _PORTA.Bits.PA2
#define PORTA_PA3                       _PORTA.Bits.PA3
#define PORTA_PA4                       _PORTA.Bits.PA4
#define PORTA_PA5                       _PORTA.Bits.PA5
#define PORTA_PA6                       _PORTA.Bits.PA6
#define PORTA_PA7                       _PORTA.Bits.PA7

#define PORTA_PA0_MASK                  1U
#define PORTA_PA1_MASK                  2U
#define PORTA_PA2_MASK                  4U
#define PORTA_PA3_MASK                  8U
#define PORTA_PA4_MASK                  16U
#define PORTA_PA5_MASK                  32U
#define PORTA_PA6_MASK                  64U
#define PORTA_PA7_MASK                  128U


/*** PORTB - Port A Data Register; 0x00000001 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Port B Bit 0 */
    byte PE1         :1;                                       /* Port B Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPE   :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PORTBSTR;
extern volatile PORTBSTR _PORTB @(REG_BASE + 0x00000001UL);
#define PORTB                           _PORTB.Byte
#define PORTB_PE0                       _PORTB.Bits.PE0
#define PORTB_PE1                       _PORTB.Bits.PE1
#define PORTB_PE                        _PORTB.MergedBits.grpPE

#define PORTB_PE0_MASK                  1U
#define PORTB_PE1_MASK                  2U
#define PORTB_PE_MASK                   3U
#define PORTB_PE_BITNUM                 0U


/*** DDRA - Port A Data Direction Register; 0x00000002 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
    byte DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
    byte DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
    byte DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
    byte DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
    byte DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
    byte DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
    byte DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
} DDRASTR;
extern volatile DDRASTR _DDRA @(REG_BASE + 0x00000002UL);
#define DDRA                            _DDRA.Byte
#define DDRA_DDRA0                      _DDRA.Bits.DDRA0
#define DDRA_DDRA1                      _DDRA.Bits.DDRA1
#define DDRA_DDRA2                      _DDRA.Bits.DDRA2
#define DDRA_DDRA3                      _DDRA.Bits.DDRA3
#define DDRA_DDRA4                      _DDRA.Bits.DDRA4
#define DDRA_DDRA5                      _DDRA.Bits.DDRA5
#define DDRA_DDRA6                      _DDRA.Bits.DDRA6
#define DDRA_DDRA7                      _DDRA.Bits.DDRA7

#define DDRA_DDRA0_MASK                 1U
#define DDRA_DDRA1_MASK                 2U
#define DDRA_DDRA2_MASK                 4U
#define DDRA_DDRA3_MASK                 8U
#define DDRA_DDRA4_MASK                 16U
#define DDRA_DDRA5_MASK                 32U
#define DDRA_DDRA6_MASK                 64U
#define DDRA_DDRA7_MASK                 128U


/*** DDRB - Port B Data Direction Register; 0x00000003 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRE0       :1;                                       /* Data Direction Port B Bit 0 */
    byte DDRE1       :1;                                       /* Data Direction Port B Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRE :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRBSTR;
extern volatile DDRBSTR _DDRB @(REG_BASE + 0x00000003UL);
#define DDRB                            _DDRB.Byte
#define DDRB_DDRE0                      _DDRB.Bits.DDRE0
#define DDRB_DDRE1                      _DDRB.Bits.DDRE1
#define DDRB_DDRE                       _DDRB.MergedBits.grpDDRE

#define DDRB_DDRE0_MASK                 1U
#define DDRB_DDRE1_MASK                 2U
#define DDRB_DDRE_MASK                  3U
#define DDRB_DDRE_BITNUM                0U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODC        :1;                                       /* Mode Select Bit */
  } Bits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_MODC                       _MODE.Bits.MODC

#define MODE_MODC_MASK                  128U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PDPBE       :1;                                       /* Pull-down Port B Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BKPUE       :1;                                       /* BKGD and VREGEN Pin Pull-up Enable */
    byte             :1; 
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PDPBE                      _PUCR.Bits.PDPBE
#define PUCR_BKPUE                      _PUCR.Bits.BKPUE

#define PUCR_PDPBE_MASK                 2U
#define PUCR_BKPUE_MASK                 64U


/*** RDRIV - Reduced Drive Register; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte RDPC        :1;                                       /* Reduced Drive of Port C */
    byte RDPD        :1;                                       /* Reduced Drive of Port D */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPC                      _RDRIV.Bits.RDPC
#define RDRIV_RDPD                      _RDRIV.Bits.RDPD

#define RDRIV_RDPC_MASK                 4U
#define RDRIV_RDPD_MASK                 8U


/*** DIRECT - Direct Page Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Index Bit 8 */
    byte DP9         :1;                                       /* Direct Page Index Bit 9 */
    byte DP10        :1;                                       /* Direct Page Index Bit 10 */
    byte DP11        :1;                                       /* Direct Page Index Bit 11 */
    byte DP12        :1;                                       /* Direct Page Index Bit 12 */
    byte DP13        :1;                                       /* Direct Page Index Bit 13 */
    byte DP14        :1;                                       /* Direct Page Index Bit 14 */
    byte DP15        :1;                                       /* Direct Page Index Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000011UL);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1U
#define DIRECT_DP9_MASK                 2U
#define DIRECT_DP10_MASK                4U
#define DIRECT_DP11_MASK                8U
#define DIRECT_DP12_MASK                16U
#define DIRECT_DP13_MASK                32U
#define DIRECT_DP14_MASK                64U
#define DIRECT_DP15_MASK                128U


/*** MMCCTL1 - MMC Control Register; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte IFRON       :1;                                       /* IFR visible in the memory map */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MMCCTL1STR;
extern volatile MMCCTL1STR _MMCCTL1 @(REG_BASE + 0x00000013UL);
#define MMCCTL1                         _MMCCTL1.Byte
#define MMCCTL1_IFRON                   _MMCCTL1.Bits.IFRON

#define MMCCTL1_IFRON_MASK              1U


/*** PPAGE - Program Page Index Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIX  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000015UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX                       _PPAGE.MergedBits.grpPIX

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX_MASK                  15U
#define PPAGE_PIX_BITNUM                0U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** IVBR - Interrupt Vector Base Register; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte IVB_ADDR0   :1;                                       /* Interrupt Vector Base Address Bits, bit 0 */
    byte IVB_ADDR1   :1;                                       /* Interrupt Vector Base Address Bits, bit 1 */
    byte IVB_ADDR2   :1;                                       /* Interrupt Vector Base Address Bits, bit 2 */
    byte IVB_ADDR3   :1;                                       /* Interrupt Vector Base Address Bits, bit 3 */
    byte IVB_ADDR4   :1;                                       /* Interrupt Vector Base Address Bits, bit 4 */
    byte IVB_ADDR5   :1;                                       /* Interrupt Vector Base Address Bits, bit 5 */
    byte IVB_ADDR6   :1;                                       /* Interrupt Vector Base Address Bits, bit 6 */
    byte IVB_ADDR7   :1;                                       /* Interrupt Vector Base Address Bits, bit 7 */
  } Bits;
} IVBRSTR;
extern volatile IVBRSTR _IVBR @(REG_BASE + 0x0000001FUL);
#define IVBR                            _IVBR.Byte
#define IVBR_IVB_ADDR0                  _IVBR.Bits.IVB_ADDR0
#define IVBR_IVB_ADDR1                  _IVBR.Bits.IVB_ADDR1
#define IVBR_IVB_ADDR2                  _IVBR.Bits.IVB_ADDR2
#define IVBR_IVB_ADDR3                  _IVBR.Bits.IVB_ADDR3
#define IVBR_IVB_ADDR4                  _IVBR.Bits.IVB_ADDR4
#define IVBR_IVB_ADDR5                  _IVBR.Bits.IVB_ADDR5
#define IVBR_IVB_ADDR6                  _IVBR.Bits.IVB_ADDR6
#define IVBR_IVB_ADDR7                  _IVBR.Bits.IVB_ADDR7

#define IVBR_IVB_ADDR0_MASK             1U
#define IVBR_IVB_ADDR1_MASK             2U
#define IVBR_IVB_ADDR2_MASK             4U
#define IVBR_IVB_ADDR3_MASK             8U
#define IVBR_IVB_ADDR4_MASK             16U
#define IVBR_IVB_ADDR5_MASK             32U
#define IVBR_IVB_ADDR6_MASK             64U
#define IVBR_IVB_ADDR7_MASK             128U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte COMRV0      :1;                                       /* Comparator Register Visibility Bits, bit 0 */
    byte COMRV1      :1;                                       /* Comparator Register Visibility Bits, bit 1 */
    byte             :1; 
    byte DBGBRK      :1;                                       /* S12XDBG Breakpoint Enable Bit 1 */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte             :1; 
    byte TRIG        :1;                                       /* Immediate Trigger Request Bit */
    byte ARM         :1;                                       /* Arm Bit */
  } Bits;
  struct {
    byte grpCOMRV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_COMRV0                    _DBGC1.Bits.COMRV0
#define DBGC1_COMRV1                    _DBGC1.Bits.COMRV1
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BDM                       _DBGC1.Bits.BDM
#define DBGC1_TRIG                      _DBGC1.Bits.TRIG
#define DBGC1_ARM                       _DBGC1.Bits.ARM
#define DBGC1_COMRV                     _DBGC1.MergedBits.grpCOMRV

#define DBGC1_COMRV0_MASK               1U
#define DBGC1_COMRV1_MASK               2U
#define DBGC1_DBGBRK_MASK               8U
#define DBGC1_BDM_MASK                  16U
#define DBGC1_TRIG_MASK                 64U
#define DBGC1_ARM_MASK                  128U
#define DBGC1_COMRV_MASK                3U
#define DBGC1_COMRV_BITNUM              0U


/*** DBGSR - Debug Status Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSF0        :1;                                       /* State Sequencer Flag Bits */
    byte SSF1        :1;                                       /* State Sequencer Flag Bit 1 */
    byte SSF2        :1;                                       /* State Sequencer Flag Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpSSF  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSRSTR;
extern volatile DBGSRSTR _DBGSR @(REG_BASE + 0x00000021UL);
#define DBGSR                           _DBGSR.Byte
#define DBGSR_SSF0                      _DBGSR.Bits.SSF0
#define DBGSR_SSF1                      _DBGSR.Bits.SSF1
#define DBGSR_SSF2                      _DBGSR.Bits.SSF2
#define DBGSR_TBF                       _DBGSR.Bits.TBF
#define DBGSR_SSF                       _DBGSR.MergedBits.grpSSF

#define DBGSR_SSF0_MASK                 1U
#define DBGSR_SSF1_MASK                 2U
#define DBGSR_SSF2_MASK                 4U
#define DBGSR_TBF_MASK                  128U
#define DBGSR_SSF_MASK                  7U
#define DBGSR_SSF_BITNUM                0U


/*** DBGTCR - Debug Trace Control Register; 0x00000022 ***/
typedef union {
  byte Byte;
  struct {
    byte TALIGN      :1;                                       /* Trigger Align Bit */
    byte             :1; 
    byte TRCMOD0     :1;                                       /* Trace Mode Bits, bit 0 */
    byte TRCMOD1     :1;                                       /* Trace Mode Bits, bit 1 */
    byte             :1; 
    byte             :1; 
    byte TSOURCE     :1;                                       /* Trace Source Control Bits */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTRCMOD :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGTCRSTR;
extern volatile DBGTCRSTR _DBGTCR @(REG_BASE + 0x00000022UL);
#define DBGTCR                          _DBGTCR.Byte
#define DBGTCR_TALIGN                   _DBGTCR.Bits.TALIGN
#define DBGTCR_TRCMOD0                  _DBGTCR.Bits.TRCMOD0
#define DBGTCR_TRCMOD1                  _DBGTCR.Bits.TRCMOD1
#define DBGTCR_TSOURCE                  _DBGTCR.Bits.TSOURCE
#define DBGTCR_TRCMOD                   _DBGTCR.MergedBits.grpTRCMOD

#define DBGTCR_TALIGN_MASK              1U
#define DBGTCR_TRCMOD0_MASK             4U
#define DBGTCR_TRCMOD1_MASK             8U
#define DBGTCR_TSOURCE_MASK             64U
#define DBGTCR_TRCMOD_MASK              12U
#define DBGTCR_TRCMOD_BITNUM            2U


/*** DBGC2 - Debug Control Register 2; 0x00000023 ***/
typedef union {
  byte Byte;
  struct {
    byte ABCM0       :1;                                       /* A and B Comparator Match Control, bit 0 */
    byte ABCM1       :1;                                       /* A and B Comparator Match Control, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABCM :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000023UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_ABCM0                     _DBGC2.Bits.ABCM0
#define DBGC2_ABCM1                     _DBGC2.Bits.ABCM1
#define DBGC2_ABCM                      _DBGC2.MergedBits.grpABCM

#define DBGC2_ABCM0_MASK                1U
#define DBGC2_ABCM1_MASK                2U
#define DBGC2_ABCM_MASK                 3U
#define DBGC2_ABCM_BITNUM               0U


/*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Trace Buffer Data Bits */
        byte BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
        byte BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
        byte BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
        byte BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
        byte BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
        byte BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
        byte BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Trace Buffer Data Bits */
        byte BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
        byte BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
        byte BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
        byte BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
        byte BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
        byte BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
        byte BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Trace Buffer Data Bits */
    word BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
    word BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
    word BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
    word BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
    word BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
    word BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
    word BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
    word BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
    word BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
    word BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
    word BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
    word BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
    word BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
    word BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
    word BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000024UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000026 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT0        :1;                                       /* Count Value, bit 0 */
    byte CNT1        :1;                                       /* Count Value, bit 1 */
    byte CNT2        :1;                                       /* Count Value, bit 2 */
    byte CNT3        :1;                                       /* Count Value, bit 3 */
    byte CNT4        :1;                                       /* Count Value, bit 4 */
    byte CNT5        :1;                                       /* Count Value, bit 5 */
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpCNT  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000026UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT0                     _DBGCNT.Bits.CNT0
#define DBGCNT_CNT1                     _DBGCNT.Bits.CNT1
#define DBGCNT_CNT2                     _DBGCNT.Bits.CNT2
#define DBGCNT_CNT3                     _DBGCNT.Bits.CNT3
#define DBGCNT_CNT4                     _DBGCNT.Bits.CNT4
#define DBGCNT_CNT5                     _DBGCNT.Bits.CNT5
#define DBGCNT_TBF                      _DBGCNT.Bits.TBF
#define DBGCNT_CNT                      _DBGCNT.MergedBits.grpCNT

#define DBGCNT_CNT0_MASK                1U
#define DBGCNT_CNT1_MASK                2U
#define DBGCNT_CNT2_MASK                4U
#define DBGCNT_CNT3_MASK                8U
#define DBGCNT_CNT4_MASK                16U
#define DBGCNT_CNT5_MASK                32U
#define DBGCNT_TBF_MASK                 128U
#define DBGCNT_CNT_MASK                 63U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGSCRX - Debug State Control Register; 0x00000027 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** DBGSCRX - Debug State Control Register; Several registers at the same address ***/
    union {
      struct {
        byte SC0         :1;                                       /* State X Sequencer Next State Selection Bit 0 */
        byte SC1         :1;                                       /* State X Sequencer Next State Selection Bit 1 */
        byte SC2         :1;                                       /* State X Sequencer Next State Selection Bit 2 */
        byte SC3         :1;                                       /* State X Sequencer Next State Selection Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGSCRXSTR;
    #define DBGSCRX                     _DBGSCRX.Byte
    #define DBGSCRX_SC0                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC0
    #define DBGSCRX_SC1                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC1
    #define DBGSCRX_SC2                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC2
    #define DBGSCRX_SC3                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC3
    #define DBGSCRX_SC                  _DBGSCRX.SameAddr_STR.DBGSCRXSTR.MergedBits.grpSC
    
    #define DBGSCRX_SC0_MASK            1U
    #define DBGSCRX_SC1_MASK            2U
    #define DBGSCRX_SC2_MASK            4U
    #define DBGSCRX_SC3_MASK            8U
    #define DBGSCRX_SC_MASK             15U
    #define DBGSCRX_SC_BITNUM           0U
    
    /*** DBGMFR - Debug Match Flag Register; Several registers at the same address ***/
    union {
      struct {
        byte MC0         :1;                                       /* Debug Match Flag Bit 0 */
        byte MC1         :1;                                       /* Debug Match Flag Bit 1 */
        byte MC2         :1;                                       /* Debug Match Flag Bit 2 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpMC :3;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGMFRSTR;
    #define DBGMFR                      _DBGSCRX.Byte
    #define DBGMFR_MC0                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC0
    #define DBGMFR_MC1                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC1
    #define DBGMFR_MC2                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC2
    #define DBGMFR_MC                   _DBGSCRX.SameAddr_STR.DBGMFRSTR.MergedBits.grpMC
    
    #define DBGMFR_MC0_MASK             1U
    #define DBGMFR_MC1_MASK             2U
    #define DBGMFR_MC2_MASK             4U
    #define DBGMFR_MC_MASK              7U
    #define DBGMFR_MC_BITNUM            0U
    
  } SameAddr_STR; /*Several registers at the same address */

} DBGSCRXSTR;
extern volatile DBGSCRXSTR _DBGSCRX @(REG_BASE + 0x00000027UL);


/*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte COMPE       :1;                                       /* Determines if comparator is enabled */
    byte NDB         :1;                                       /* Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D) */
    byte RWE         :1;                                       /* Read/Write Enable Bit */
    byte RW          :1;                                       /* Read/Write Comparator Value Bit */
    byte BRK         :1;                                       /* Break */
    byte TAG         :1;                                       /* Tag Select */
    byte SZ          :1;                                       /* Size Comparator Value Bit */
    byte SZE         :1;                                       /* Size Comparator Enable Bit */
  } Bits;
} DBGXCTLSTR;
extern volatile DBGXCTLSTR _DBGXCTL @(REG_BASE + 0x00000028UL);
#define DBGXCTL                         _DBGXCTL.Byte
#define DBGXCTL_COMPE                   _DBGXCTL.Bits.COMPE
#define DBGXCTL_NDB                     _DBGXCTL.Bits.NDB
#define DBGXCTL_RWE                     _DBGXCTL.Bits.RWE
#define DBGXCTL_RW                      _DBGXCTL.Bits.RW
#define DBGXCTL_BRK                     _DBGXCTL.Bits.BRK
#define DBGXCTL_TAG                     _DBGXCTL.Bits.TAG
#define DBGXCTL_SZ                      _DBGXCTL.Bits.SZ
#define DBGXCTL_SZE                     _DBGXCTL.Bits.SZE

#define DBGXCTL_COMPE_MASK              1U
#define DBGXCTL_NDB_MASK                2U
#define DBGXCTL_RWE_MASK                4U
#define DBGXCTL_RW_MASK                 8U
#define DBGXCTL_BRK_MASK                16U
#define DBGXCTL_TAG_MASK                32U
#define DBGXCTL_SZ_MASK                 64U
#define DBGXCTL_SZE_MASK                128U


/*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT16       :1;                                       /* Comparator Address High Compare Bits */
    byte BIT17       :1;                                       /* Comparator Address High Compare Bit 17 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpBIT_16 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGXAHSTR;
extern volatile DBGXAHSTR _DBGXAH @(REG_BASE + 0x00000029UL);
#define DBGXAH                          _DBGXAH.Byte
#define DBGXAH_BIT16                    _DBGXAH.Bits.BIT16
#define DBGXAH_BIT17                    _DBGXAH.Bits.BIT17
#define DBGXAH_BIT_16                   _DBGXAH.MergedBits.grpBIT_16
#define DBGXAH_BIT                      DBGXAH_BIT_16

#define DBGXAH_BIT16_MASK               1U
#define DBGXAH_BIT17_MASK               2U
#define DBGXAH_BIT_16_MASK              3U
#define DBGXAH_BIT_16_BITNUM            0U


/*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Address Mid Compare Bits */
    byte BIT9        :1;                                       /* Comparator Address Mid Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Address Mid Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Address Mid Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Address Mid Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Address Mid Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Address Mid Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Address Mid Compare Bit 15 */
  } Bits;
} DBGXAMSTR;
extern volatile DBGXAMSTR _DBGXAM @(REG_BASE + 0x0000002AUL);
#define DBGXAM                          _DBGXAM.Byte
#define DBGXAM_BIT8                     _DBGXAM.Bits.BIT8
#define DBGXAM_BIT9                     _DBGXAM.Bits.BIT9
#define DBGXAM_BIT10                    _DBGXAM.Bits.BIT10
#define DBGXAM_BIT11                    _DBGXAM.Bits.BIT11
#define DBGXAM_BIT12                    _DBGXAM.Bits.BIT12
#define DBGXAM_BIT13                    _DBGXAM.Bits.BIT13
#define DBGXAM_BIT14                    _DBGXAM.Bits.BIT14
#define DBGXAM_BIT15                    _DBGXAM.Bits.BIT15

#define DBGXAM_BIT8_MASK                1U
#define DBGXAM_BIT9_MASK                2U
#define DBGXAM_BIT10_MASK               4U
#define DBGXAM_BIT11_MASK               8U
#define DBGXAM_BIT12_MASK               16U
#define DBGXAM_BIT13_MASK               32U
#define DBGXAM_BIT14_MASK               64U
#define DBGXAM_BIT15_MASK               128U


/*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bits */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXALSTR;
extern volatile DBGXALSTR _DBGXAL @(REG_BASE + 0x0000002BUL);
#define DBGXAL                          _DBGXAL.Byte
#define DBGXAL_BIT0                     _DBGXAL.Bits.BIT0
#define DBGXAL_BIT1                     _DBGXAL.Bits.BIT1
#define DBGXAL_BIT2                     _DBGXAL.Bits.BIT2
#define DBGXAL_BIT3                     _DBGXAL.Bits.BIT3
#define DBGXAL_BIT4                     _DBGXAL.Bits.BIT4
#define DBGXAL_BIT5                     _DBGXAL.Bits.BIT5
#define DBGXAL_BIT6                     _DBGXAL.Bits.BIT6
#define DBGXAL_BIT7                     _DBGXAL.Bits.BIT7

#define DBGXAL_BIT0_MASK                1U
#define DBGXAL_BIT1_MASK                2U
#define DBGXAL_BIT2_MASK                4U
#define DBGXAL_BIT3_MASK                8U
#define DBGXAL_BIT4_MASK                16U
#define DBGXAL_BIT5_MASK                32U
#define DBGXAL_BIT6_MASK                64U
#define DBGXAL_BIT7_MASK                128U


/*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Compare Bit 15 */
  } Bits;
} DBGADHSTR;
extern volatile DBGADHSTR _DBGADH @(REG_BASE + 0x0000002CUL);
#define DBGADH                          _DBGADH.Byte
#define DBGADH_BIT8                     _DBGADH.Bits.BIT8
#define DBGADH_BIT9                     _DBGADH.Bits.BIT9
#define DBGADH_BIT10                    _DBGADH.Bits.BIT10
#define DBGADH_BIT11                    _DBGADH.Bits.BIT11
#define DBGADH_BIT12                    _DBGADH.Bits.BIT12
#define DBGADH_BIT13                    _DBGADH.Bits.BIT13
#define DBGADH_BIT14                    _DBGADH.Bits.BIT14
#define DBGADH_BIT15                    _DBGADH.Bits.BIT15

#define DBGADH_BIT8_MASK                1U
#define DBGADH_BIT9_MASK                2U
#define DBGADH_BIT10_MASK               4U
#define DBGADH_BIT11_MASK               8U
#define DBGADH_BIT12_MASK               16U
#define DBGADH_BIT13_MASK               32U
#define DBGADH_BIT14_MASK               64U
#define DBGADH_BIT15_MASK               128U


/*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Compare Bit 7 */
  } Bits;
} DBGADLSTR;
extern volatile DBGADLSTR _DBGADL @(REG_BASE + 0x0000002DUL);
#define DBGADL                          _DBGADL.Byte
#define DBGADL_BIT0                     _DBGADL.Bits.BIT0
#define DBGADL_BIT1                     _DBGADL.Bits.BIT1
#define DBGADL_BIT2                     _DBGADL.Bits.BIT2
#define DBGADL_BIT3                     _DBGADL.Bits.BIT3
#define DBGADL_BIT4                     _DBGADL.Bits.BIT4
#define DBGADL_BIT5                     _DBGADL.Bits.BIT5
#define DBGADL_BIT6                     _DBGADL.Bits.BIT6
#define DBGADL_BIT7                     _DBGADL.Bits.BIT7

#define DBGADL_BIT0_MASK                1U
#define DBGADL_BIT1_MASK                2U
#define DBGADL_BIT2_MASK                4U
#define DBGADL_BIT3_MASK                8U
#define DBGADL_BIT4_MASK                16U
#define DBGADL_BIT5_MASK                32U
#define DBGADL_BIT6_MASK                64U
#define DBGADL_BIT7_MASK                128U


/*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Mask Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Mask Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Mask Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Mask Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Mask Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Mask Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Mask Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Mask Bit 15 */
  } Bits;
} DBGADHMSTR;
extern volatile DBGADHMSTR _DBGADHM @(REG_BASE + 0x0000002EUL);
#define DBGADHM                         _DBGADHM.Byte
#define DBGADHM_BIT8                    _DBGADHM.Bits.BIT8
#define DBGADHM_BIT9                    _DBGADHM.Bits.BIT9
#define DBGADHM_BIT10                   _DBGADHM.Bits.BIT10
#define DBGADHM_BIT11                   _DBGADHM.Bits.BIT11
#define DBGADHM_BIT12                   _DBGADHM.Bits.BIT12
#define DBGADHM_BIT13                   _DBGADHM.Bits.BIT13
#define DBGADHM_BIT14                   _DBGADHM.Bits.BIT14
#define DBGADHM_BIT15                   _DBGADHM.Bits.BIT15

#define DBGADHM_BIT8_MASK               1U
#define DBGADHM_BIT9_MASK               2U
#define DBGADHM_BIT10_MASK              4U
#define DBGADHM_BIT11_MASK              8U
#define DBGADHM_BIT12_MASK              16U
#define DBGADHM_BIT13_MASK              32U
#define DBGADHM_BIT14_MASK              64U
#define DBGADHM_BIT15_MASK              128U


/*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Mask Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Mask Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Mask Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Mask Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Mask Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Mask Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Mask Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Mask Bit 7 */
  } Bits;
} DBGADLMSTR;
extern volatile DBGADLMSTR _DBGADLM @(REG_BASE + 0x0000002FUL);
#define DBGADLM                         _DBGADLM.Byte
#define DBGADLM_BIT0                    _DBGADLM.Bits.BIT0
#define DBGADLM_BIT1                    _DBGADLM.Bits.BIT1
#define DBGADLM_BIT2                    _DBGADLM.Bits.BIT2
#define DBGADLM_BIT3                    _DBGADLM.Bits.BIT3
#define DBGADLM_BIT4                    _DBGADLM.Bits.BIT4
#define DBGADLM_BIT5                    _DBGADLM.Bits.BIT5
#define DBGADLM_BIT6                    _DBGADLM.Bits.BIT6
#define DBGADLM_BIT7                    _DBGADLM.Bits.BIT7

#define DBGADLM_BIT0_MASK               1U
#define DBGADLM_BIT1_MASK               2U
#define DBGADLM_BIT2_MASK               4U
#define DBGADLM_BIT3_MASK               8U
#define DBGADLM_BIT4_MASK               16U
#define DBGADLM_BIT5_MASK               32U
#define DBGADLM_BIT6_MASK               64U
#define DBGADLM_BIT7_MASK               128U


/*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYNDIV0     :1;                                       /* Multiplication factor of the IPLL bit 0 */
    byte SYNDIV1     :1;                                       /* Multiplication factor of the IPLL bit 1 */
    byte SYNDIV2     :1;                                       /* Multiplication factor of the IPLL bit 2 */
    byte SYNDIV3     :1;                                       /* Multiplication factor of the IPLL bit 3 */
    byte SYNDIV4     :1;                                       /* Multiplication factor of the IPLL bit 4 */
    byte SYNDIV5     :1;                                       /* Multiplication factor of the IPLL bit 5 */
    byte VCOFRQ0     :1;                                       /* VCO frequency range bit 0 */
    byte VCOFRQ1     :1;                                       /* VCO frequency range bit 1 */
  } Bits;
  struct {
    byte grpSYNDIV :6;
    byte grpVCOFRQ :2;
  } MergedBits;
} CPMUSYNRSTR;
extern volatile CPMUSYNRSTR _CPMUSYNR @(REG_BASE + 0x00000034UL);
#define CPMUSYNR                        _CPMUSYNR.Byte
#define CPMUSYNR_SYNDIV0                _CPMUSYNR.Bits.SYNDIV0
#define CPMUSYNR_SYNDIV1                _CPMUSYNR.Bits.SYNDIV1
#define CPMUSYNR_SYNDIV2                _CPMUSYNR.Bits.SYNDIV2
#define CPMUSYNR_SYNDIV3                _CPMUSYNR.Bits.SYNDIV3
#define CPMUSYNR_SYNDIV4                _CPMUSYNR.Bits.SYNDIV4
#define CPMUSYNR_SYNDIV5                _CPMUSYNR.Bits.SYNDIV5
#define CPMUSYNR_VCOFRQ0                _CPMUSYNR.Bits.VCOFRQ0
#define CPMUSYNR_VCOFRQ1                _CPMUSYNR.Bits.VCOFRQ1
#define CPMUSYNR_SYNDIV                 _CPMUSYNR.MergedBits.grpSYNDIV
#define CPMUSYNR_VCOFRQ                 _CPMUSYNR.MergedBits.grpVCOFRQ

#define CPMUSYNR_SYNDIV0_MASK           1U
#define CPMUSYNR_SYNDIV1_MASK           2U
#define CPMUSYNR_SYNDIV2_MASK           4U
#define CPMUSYNR_SYNDIV3_MASK           8U
#define CPMUSYNR_SYNDIV4_MASK           16U
#define CPMUSYNR_SYNDIV5_MASK           32U
#define CPMUSYNR_VCOFRQ0_MASK           64U
#define CPMUSYNR_VCOFRQ1_MASK           128U
#define CPMUSYNR_SYNDIV_MASK            63U
#define CPMUSYNR_SYNDIV_BITNUM          0U
#define CPMUSYNR_VCOFRQ_MASK            192U
#define CPMUSYNR_VCOFRQ_BITNUM          6U


/*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDIV0     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 0 */
    byte REFDIV1     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 1 */
    byte REFDIV2     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 2 */
    byte REFDIV3     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 3 */
    byte             :1; 
    byte             :1; 
    byte REFFRQ0     :1;                                       /* IPLL optimal stability and lock time configuration bit 0 */
    byte REFFRQ1     :1;                                       /* IPLL optimal stability and lock time configuration bit 1 */
  } Bits;
  struct {
    byte grpREFDIV :4;
    byte         :1;
    byte         :1;
    byte grpREFFRQ :2;
  } MergedBits;
} CPMUREFDIVSTR;
extern volatile CPMUREFDIVSTR _CPMUREFDIV @(REG_BASE + 0x00000035UL);
#define CPMUREFDIV                      _CPMUREFDIV.Byte
#define CPMUREFDIV_REFDIV0              _CPMUREFDIV.Bits.REFDIV0
#define CPMUREFDIV_REFDIV1              _CPMUREFDIV.Bits.REFDIV1
#define CPMUREFDIV_REFDIV2              _CPMUREFDIV.Bits.REFDIV2
#define CPMUREFDIV_REFDIV3              _CPMUREFDIV.Bits.REFDIV3
#define CPMUREFDIV_REFFRQ0              _CPMUREFDIV.Bits.REFFRQ0
#define CPMUREFDIV_REFFRQ1              _CPMUREFDIV.Bits.REFFRQ1
#define CPMUREFDIV_REFDIV               _CPMUREFDIV.MergedBits.grpREFDIV
#define CPMUREFDIV_REFFRQ               _CPMUREFDIV.MergedBits.grpREFFRQ

#define CPMUREFDIV_REFDIV0_MASK         1U
#define CPMUREFDIV_REFDIV1_MASK         2U
#define CPMUREFDIV_REFDIV2_MASK         4U
#define CPMUREFDIV_REFDIV3_MASK         8U
#define CPMUREFDIV_REFFRQ0_MASK         64U
#define CPMUREFDIV_REFFRQ1_MASK         128U
#define CPMUREFDIV_REFDIV_MASK          15U
#define CPMUREFDIV_REFDIV_BITNUM        0U
#define CPMUREFDIV_REFFRQ_MASK          192U
#define CPMUREFDIV_REFFRQ_BITNUM        6U


/*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***/
typedef union {
  byte Byte;
  struct {
    byte POSTDIV0    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 0 */
    byte POSTDIV1    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 1 */
    byte POSTDIV2    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 2 */
    byte POSTDIV3    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 3 */
    byte POSTDIV4    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 4 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPOSTDIV :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CPMUPOSTDIVSTR;
extern volatile CPMUPOSTDIVSTR _CPMUPOSTDIV @(REG_BASE + 0x00000036UL);
#define CPMUPOSTDIV                     _CPMUPOSTDIV.Byte
#define CPMUPOSTDIV_POSTDIV0            _CPMUPOSTDIV.Bits.POSTDIV0
#define CPMUPOSTDIV_POSTDIV1            _CPMUPOSTDIV.Bits.POSTDIV1
#define CPMUPOSTDIV_POSTDIV2            _CPMUPOSTDIV.Bits.POSTDIV2
#define CPMUPOSTDIV_POSTDIV3            _CPMUPOSTDIV.Bits.POSTDIV3
#define CPMUPOSTDIV_POSTDIV4            _CPMUPOSTDIV.Bits.POSTDIV4
#define CPMUPOSTDIV_POSTDIV             _CPMUPOSTDIV.MergedBits.grpPOSTDIV

#define CPMUPOSTDIV_POSTDIV0_MASK       1U
#define CPMUPOSTDIV_POSTDIV1_MASK       2U
#define CPMUPOSTDIV_POSTDIV2_MASK       4U
#define CPMUPOSTDIV_POSTDIV3_MASK       8U
#define CPMUPOSTDIV_POSTDIV4_MASK       16U
#define CPMUPOSTDIV_POSTDIV_MASK        31U
#define CPMUPOSTDIV_POSTDIV_BITNUM      0U


/*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte UPOSC       :1;                                       /* Oscillator Status Bit */
    byte OSCIF       :1;                                       /* Oscillator Interrupt Flag */
    byte ILAF        :1;                                       /* Illegal Address Reset Flag */
    byte LOCK        :1;                                       /* Lock Status Bit */
    byte LOCKIF      :1;                                       /* IPLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CPMUFLGSTR;
extern volatile CPMUFLGSTR _CPMUFLG @(REG_BASE + 0x00000037UL);
#define CPMUFLG                         _CPMUFLG.Byte
#define CPMUFLG_UPOSC                   _CPMUFLG.Bits.UPOSC
#define CPMUFLG_OSCIF                   _CPMUFLG.Bits.OSCIF
#define CPMUFLG_ILAF                    _CPMUFLG.Bits.ILAF
#define CPMUFLG_LOCK                    _CPMUFLG.Bits.LOCK
#define CPMUFLG_LOCKIF                  _CPMUFLG.Bits.LOCKIF
#define CPMUFLG_LVRF                    _CPMUFLG.Bits.LVRF
#define CPMUFLG_PORF                    _CPMUFLG.Bits.PORF
#define CPMUFLG_RTIF                    _CPMUFLG.Bits.RTIF

#define CPMUFLG_UPOSC_MASK              1U
#define CPMUFLG_OSCIF_MASK              2U
#define CPMUFLG_ILAF_MASK               4U
#define CPMUFLG_LOCK_MASK               8U
#define CPMUFLG_LOCKIF_MASK             16U
#define CPMUFLG_LVRF_MASK               32U
#define CPMUFLG_PORF_MASK               64U
#define CPMUFLG_RTIF_MASK               128U


/*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte OSCIE       :1;                                       /* Oscillator Corrupt Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte RTIE        :1;                                       /* Real Time Interrupt Enable Bit */
  } Bits;
} CPMUINTSTR;
extern volatile CPMUINTSTR _CPMUINT @(REG_BASE + 0x00000038UL);
#define CPMUINT                         _CPMUINT.Byte
#define CPMUINT_OSCIE                   _CPMUINT.Bits.OSCIE
#define CPMUINT_LOCKIE                  _CPMUINT.Bits.LOCKIE
#define CPMUINT_RTIE                    _CPMUINT.Bits.RTIE

#define CPMUINT_OSCIE_MASK              2U
#define CPMUINT_LOCKIE_MASK             16U
#define CPMUINT_RTIE_MASK               128U


/*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPOSCSEL   :1;                                       /* COP Clock Select */
    byte RTIOSCSEL   :1;                                       /* RTI Clock Select */
    byte PCE         :1;                                       /* COP Enable During Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable During Pseudo Stop Bit */
    byte             :1; 
    byte             :1; 
    byte PSTP        :1;                                       /* Pseudo Stop Bit */
    byte PLLSEL      :1;                                       /* PLL Select Bit */
  } Bits;
} CPMUCLKSSTR;
extern volatile CPMUCLKSSTR _CPMUCLKS @(REG_BASE + 0x00000039UL);
#define CPMUCLKS                        _CPMUCLKS.Byte
#define CPMUCLKS_COPOSCSEL              _CPMUCLKS.Bits.COPOSCSEL
#define CPMUCLKS_RTIOSCSEL              _CPMUCLKS.Bits.RTIOSCSEL
#define CPMUCLKS_PCE                    _CPMUCLKS.Bits.PCE
#define CPMUCLKS_PRE                    _CPMUCLKS.Bits.PRE
#define CPMUCLKS_PSTP                   _CPMUCLKS.Bits.PSTP
#define CPMUCLKS_PLLSEL                 _CPMUCLKS.Bits.PLLSEL

#define CPMUCLKS_COPOSCSEL_MASK         1U
#define CPMUCLKS_RTIOSCSEL_MASK         2U
#define CPMUCLKS_PCE_MASK               4U
#define CPMUCLKS_PRE_MASK               8U
#define CPMUCLKS_PSTP_MASK              64U
#define CPMUCLKS_PLLSEL_MASK            128U


/*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte FM0         :1;                                       /* PLL Frequency Modulation Enable Bit 0 */
    byte FM1         :1;                                       /* PLL Frequency Modulation Enable Bit 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpFM   :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CPMUPLLSTR;
extern volatile CPMUPLLSTR _CPMUPLL @(REG_BASE + 0x0000003AUL);
#define CPMUPLL                         _CPMUPLL.Byte
#define CPMUPLL_FM0                     _CPMUPLL.Bits.FM0
#define CPMUPLL_FM1                     _CPMUPLL.Bits.FM1
#define CPMUPLL_FM                      _CPMUPLL.MergedBits.grpFM

#define CPMUPLL_FM0_MASK                16U
#define CPMUPLL_FM1_MASK                32U
#define CPMUPLL_FM_MASK                 48U
#define CPMUPLL_FM_BITNUM               4U


/*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte RTDEC       :1;                                       /* Decimal or Binary Divider Select Bit */
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} CPMURTISTR;
extern volatile CPMURTISTR _CPMURTI @(REG_BASE + 0x0000003BUL);
#define CPMURTI                         _CPMURTI.Byte
#define CPMURTI_RTR0                    _CPMURTI.Bits.RTR0
#define CPMURTI_RTR1                    _CPMURTI.Bits.RTR1
#define CPMURTI_RTR2                    _CPMURTI.Bits.RTR2
#define CPMURTI_RTR3                    _CPMURTI.Bits.RTR3
#define CPMURTI_RTR4                    _CPMURTI.Bits.RTR4
#define CPMURTI_RTR5                    _CPMURTI.Bits.RTR5
#define CPMURTI_RTR6                    _CPMURTI.Bits.RTR6
#define CPMURTI_RTDEC                   _CPMURTI.Bits.RTDEC
#define CPMURTI_RTR                     _CPMURTI.MergedBits.grpRTR

#define CPMURTI_RTR0_MASK               1U
#define CPMURTI_RTR1_MASK               2U
#define CPMURTI_RTR2_MASK               4U
#define CPMURTI_RTR3_MASK               8U
#define CPMURTI_RTR4_MASK               16U
#define CPMURTI_RTR5_MASK               32U
#define CPMURTI_RTR6_MASK               64U
#define CPMURTI_RTDEC_MASK              128U
#define CPMURTI_RTR_MASK                127U
#define CPMURTI_RTR_BITNUM              0U


/*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte WRTMASK     :1;                                       /* Write Mask for WCOP */
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CPMUCOPSTR;
extern volatile CPMUCOPSTR _CPMUCOP @(REG_BASE + 0x0000003CUL);
#define CPMUCOP                         _CPMUCOP.Byte
#define CPMUCOP_CR0                     _CPMUCOP.Bits.CR0
#define CPMUCOP_CR1                     _CPMUCOP.Bits.CR1
#define CPMUCOP_CR2                     _CPMUCOP.Bits.CR2
#define CPMUCOP_WRTMASK                 _CPMUCOP.Bits.WRTMASK
#define CPMUCOP_RSBCK                   _CPMUCOP.Bits.RSBCK
#define CPMUCOP_WCOP                    _CPMUCOP.Bits.WCOP
#define CPMUCOP_CR                      _CPMUCOP.MergedBits.grpCR

#define CPMUCOP_CR0_MASK                1U
#define CPMUCOP_CR1_MASK                2U
#define CPMUCOP_CR2_MASK                4U
#define CPMUCOP_WRTMASK_MASK            32U
#define CPMUCOP_RSBCK_MASK              64U
#define CPMUCOP_WCOP_MASK               128U
#define CPMUCOP_CR_MASK                 7U
#define CPMUCOP_CR_BITNUM               0U


/*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CPMU COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CPMU COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CPMU COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CPMU COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CPMU COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CPMU COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CPMU COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CPMU COP Timer Arm/Reset Bit 7 */
  } Bits;
} CPMUARMCOPSTR;
extern volatile CPMUARMCOPSTR _CPMUARMCOP @(REG_BASE + 0x0000003FUL);
#define CPMUARMCOP                      _CPMUARMCOP.Byte
#define CPMUARMCOP_BIT0                 _CPMUARMCOP.Bits.BIT0
#define CPMUARMCOP_BIT1                 _CPMUARMCOP.Bits.BIT1
#define CPMUARMCOP_BIT2                 _CPMUARMCOP.Bits.BIT2
#define CPMUARMCOP_BIT3                 _CPMUARMCOP.Bits.BIT3
#define CPMUARMCOP_BIT4                 _CPMUARMCOP.Bits.BIT4
#define CPMUARMCOP_BIT5                 _CPMUARMCOP.Bits.BIT5
#define CPMUARMCOP_BIT6                 _CPMUARMCOP.Bits.BIT6
#define CPMUARMCOP_BIT7                 _CPMUARMCOP.Bits.BIT7

#define CPMUARMCOP_BIT0_MASK            1U
#define CPMUARMCOP_BIT1_MASK            2U
#define CPMUARMCOP_BIT2_MASK            4U
#define CPMUARMCOP_BIT3_MASK            8U
#define CPMUARMCOP_BIT4_MASK            16U
#define CPMUARMCOP_BIT5_MASK            32U
#define CPMUARMCOP_BIT6_MASK            64U
#define CPMUARMCOP_BIT7_MASK            128U


/*** D2DCTL0 - D2D Control Register 0; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte D2DCLKDIV0  :1;                                       /* InterfaceClockDivider, bit 0 */
    byte D2DCLKDIV1  :1;                                       /* InterfaceClockDivider, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DSWAI     :1;                                       /* D2D Stop In Wait */
    byte D2DCW       :1;                                       /* D2D Connection Width */
    byte D2DEN       :1;                                       /* D2D Enable */
  } Bits;
  struct {
    byte grpD2DCLKDIV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DCTL0STR;
extern volatile D2DCTL0STR _D2DCTL0 @(REG_BASE + 0x000000D8UL);
#define D2DCTL0                         _D2DCTL0.Byte
#define D2DCTL0_D2DCLKDIV0              _D2DCTL0.Bits.D2DCLKDIV0
#define D2DCTL0_D2DCLKDIV1              _D2DCTL0.Bits.D2DCLKDIV1
#define D2DCTL0_D2DSWAI                 _D2DCTL0.Bits.D2DSWAI
#define D2DCTL0_D2DCW                   _D2DCTL0.Bits.D2DCW
#define D2DCTL0_D2DEN                   _D2DCTL0.Bits.D2DEN
/* D2DCTL_ARR: Access 2 D2DCTLx registers in an array */
#define D2DCTL_ARR                      ((volatile byte *) &D2DCTL0)
#define D2DCTL0_D2DCLKDIV               _D2DCTL0.MergedBits.grpD2DCLKDIV

#define D2DCTL0_D2DCLKDIV0_MASK         1U
#define D2DCTL0_D2DCLKDIV1_MASK         2U
#define D2DCTL0_D2DSWAI_MASK            32U
#define D2DCTL0_D2DCW_MASK              64U
#define D2DCTL0_D2DEN_MASK              128U
#define D2DCTL0_D2DCLKDIV_MASK          3U
#define D2DCTL0_D2DCLKDIV_BITNUM        0U


/*** D2DCTL1 - D2D Control Register 1; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte TIMOUT0     :1;                                       /* Time-out Setting, bit 0 */
    byte TIMOUT1     :1;                                       /* Time-out Setting, bit 1 */
    byte TIMOUT2     :1;                                       /* Time-out Setting, bit 2 */
    byte TIMOUT3     :1;                                       /* Time-out Setting, bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DIE       :1;                                       /* D2D Interrupt Enable */
  } Bits;
  struct {
    byte grpTIMOUT :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DCTL1STR;
extern volatile D2DCTL1STR _D2DCTL1 @(REG_BASE + 0x000000D9UL);
#define D2DCTL1                         _D2DCTL1.Byte
#define D2DCTL1_TIMOUT0                 _D2DCTL1.Bits.TIMOUT0
#define D2DCTL1_TIMOUT1                 _D2DCTL1.Bits.TIMOUT1
#define D2DCTL1_TIMOUT2                 _D2DCTL1.Bits.TIMOUT2
#define D2DCTL1_TIMOUT3                 _D2DCTL1.Bits.TIMOUT3
#define D2DCTL1_D2DIE                   _D2DCTL1.Bits.D2DIE
#define D2DCTL1_TIMOUT                  _D2DCTL1.MergedBits.grpTIMOUT

#define D2DCTL1_TIMOUT0_MASK            1U
#define D2DCTL1_TIMOUT1_MASK            2U
#define D2DCTL1_TIMOUT2_MASK            4U
#define D2DCTL1_TIMOUT3_MASK            8U
#define D2DCTL1_D2DIE_MASK              128U
#define D2DCTL1_TIMOUT_MASK             15U
#define D2DCTL1_TIMOUT_BITNUM           0U


/*** D2DSTAT0 - D2D Status Register 0; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte PAR0        :1;                                       /* Parity Bit */
    byte PAR1        :1;                                       /* Parity Bit */
    byte PARF        :1;                                       /* Parity Error Flag */
    byte TERRF       :1;                                       /* Transaction Error Flag */
    byte TIMEF       :1;                                       /* TimeOutErrorFlag */
    byte CNCLF       :1;                                       /* CNCLF */
    byte ACKERF      :1;                                       /* Acknowledge Error Flag */
    byte ERRIF       :1;                                       /* D2D error interrupt flag */
  } Bits;
  struct {
    byte grpPAR  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} D2DSTAT0STR;
extern volatile D2DSTAT0STR _D2DSTAT0 @(REG_BASE + 0x000000DAUL);
#define D2DSTAT0                        _D2DSTAT0.Byte
#define D2DSTAT0_PAR0                   _D2DSTAT0.Bits.PAR0
#define D2DSTAT0_PAR1                   _D2DSTAT0.Bits.PAR1
#define D2DSTAT0_PARF                   _D2DSTAT0.Bits.PARF
#define D2DSTAT0_TERRF                  _D2DSTAT0.Bits.TERRF
#define D2DSTAT0_TIMEF                  _D2DSTAT0.Bits.TIMEF
#define D2DSTAT0_CNCLF                  _D2DSTAT0.Bits.CNCLF
#define D2DSTAT0_ACKERF                 _D2DSTAT0.Bits.ACKERF
#define D2DSTAT0_ERRIF                  _D2DSTAT0.Bits.ERRIF
/* D2DSTAT_ARR: Access 2 D2DSTATx registers in an array */
#define D2DSTAT_ARR                     ((volatile byte *) &D2DSTAT0)
#define D2DSTAT0_PAR                    _D2DSTAT0.MergedBits.grpPAR

#define D2DSTAT0_PAR0_MASK              1U
#define D2DSTAT0_PAR1_MASK              2U
#define D2DSTAT0_PARF_MASK              4U
#define D2DSTAT0_TERRF_MASK             8U
#define D2DSTAT0_TIMEF_MASK             16U
#define D2DSTAT0_CNCLF_MASK             32U
#define D2DSTAT0_ACKERF_MASK            64U
#define D2DSTAT0_ERRIF_MASK             128U
#define D2DSTAT0_PAR_MASK               3U
#define D2DSTAT0_PAR_BITNUM             0U


/*** D2DSTAT1 - D2D Status Register 1; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte D2DBSY      :1;                                       /* D2D Initiator Busy */
    byte D2DIF       :1;                                       /* D2D InterruptFlag */
  } Bits;
} D2DSTAT1STR;
extern volatile D2DSTAT1STR _D2DSTAT1 @(REG_BASE + 0x000000DBUL);
#define D2DSTAT1                        _D2DSTAT1.Byte
#define D2DSTAT1_D2DBSY                 _D2DSTAT1.Bits.D2DBSY
#define D2DSTAT1_D2DIF                  _D2DSTAT1.Bits.D2DIF

#define D2DSTAT1_D2DBSY_MASK            64U
#define D2DSTAT1_D2DIF_MASK             128U


/*** D2DADR - D2D Address Buffer Register; 0x000000DC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** D2DADRHI - D2D Address Buffer Register High; 0x000000DC ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte NBLK        :1;                                       /* Transaction Mode */
        byte             :1; 
        byte SZ8         :1;                                       /* Transaction Size */
        byte RWB         :1;                                       /* Transaction Read-Write Direction */
      } Bits;
    } D2DADRHISTR;
    #define D2DADRHI                    _D2DADR.Overlap_STR.D2DADRHISTR.Byte
    #define D2DADRHI_NBLK               _D2DADR.Overlap_STR.D2DADRHISTR.Bits.NBLK
    #define D2DADRHI_SZ8                _D2DADR.Overlap_STR.D2DADRHISTR.Bits.SZ8
    #define D2DADRHI_RWB                _D2DADR.Overlap_STR.D2DADRHISTR.Bits.RWB
    
    #define D2DADRHI_NBLK_MASK          16U
    #define D2DADRHI_SZ8_MASK           64U
    #define D2DADRHI_RWB_MASK           128U
    

    /*** D2DADRLO - D2D Address Buffer Register Low; 0x000000DD ***/
    union {
      byte Byte;
      struct {
        byte ADR0        :1;                                       /* Transaction Address, bit 0 */
        byte ADR1        :1;                                       /* Transaction Address, bit 1 */
        byte ADR2        :1;                                       /* Transaction Address, bit 2 */
        byte ADR3        :1;                                       /* Transaction Address, bit 3 */
        byte ADR4        :1;                                       /* Transaction Address, bit 4 */
        byte ADR5        :1;                                       /* Transaction Address, bit 5 */
        byte ADR6        :1;                                       /* Transaction Address, bit 6 */
        byte ADR7        :1;                                       /* Transaction Address, bit 7 */
      } Bits;
    } D2DADRLOSTR;
    #define D2DADRLO                    _D2DADR.Overlap_STR.D2DADRLOSTR.Byte
    #define D2DADRLO_ADR0               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR0
    #define D2DADRLO_ADR1               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR1
    #define D2DADRLO_ADR2               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR2
    #define D2DADRLO_ADR3               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR3
    #define D2DADRLO_ADR4               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR4
    #define D2DADRLO_ADR5               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR5
    #define D2DADRLO_ADR6               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR6
    #define D2DADRLO_ADR7               _D2DADR.Overlap_STR.D2DADRLOSTR.Bits.ADR7
    
    #define D2DADRLO_ADR0_MASK          1U
    #define D2DADRLO_ADR1_MASK          2U
    #define D2DADRLO_ADR2_MASK          4U
    #define D2DADRLO_ADR3_MASK          8U
    #define D2DADRLO_ADR4_MASK          16U
    #define D2DADRLO_ADR5_MASK          32U
    #define D2DADRLO_ADR6_MASK          64U
    #define D2DADRLO_ADR7_MASK          128U
    
  } Overlap_STR;

  struct {
    word ADR0        :1;                                       /* Transaction Address, bit 0 */
    word ADR1        :1;                                       /* Transaction Address, bit 1 */
    word ADR2        :1;                                       /* Transaction Address, bit 2 */
    word ADR3        :1;                                       /* Transaction Address, bit 3 */
    word ADR4        :1;                                       /* Transaction Address, bit 4 */
    word ADR5        :1;                                       /* Transaction Address, bit 5 */
    word ADR6        :1;                                       /* Transaction Address, bit 6 */
    word ADR7        :1;                                       /* Transaction Address, bit 7 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word NBLK        :1;                                       /* Transaction Mode */
    word             :1; 
    word SZ8         :1;                                       /* Transaction Size */
    word RWB         :1;                                       /* Transaction Read-Write Direction */
  } Bits;
  struct {
    word grpADR  :8;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpSZ_8 :1;
    word         :1;
  } MergedBits;
} D2DADRSTR;
extern volatile D2DADRSTR _D2DADR @(REG_BASE + 0x000000DCUL);
#define D2DADR                          _D2DADR.Word
#define D2DADR_ADR0                     _D2DADR.Bits.ADR0
#define D2DADR_ADR1                     _D2DADR.Bits.ADR1
#define D2DADR_ADR2                     _D2DADR.Bits.ADR2
#define D2DADR_ADR3                     _D2DADR.Bits.ADR3
#define D2DADR_ADR4                     _D2DADR.Bits.ADR4
#define D2DADR_ADR5                     _D2DADR.Bits.ADR5
#define D2DADR_ADR6                     _D2DADR.Bits.ADR6
#define D2DADR_ADR7                     _D2DADR.Bits.ADR7
#define D2DADR_NBLK                     _D2DADR.Bits.NBLK
#define D2DADR_SZ8                      _D2DADR.Bits.SZ8
#define D2DADR_RWB                      _D2DADR.Bits.RWB
#define D2DADR_ADR                      _D2DADR.MergedBits.grpADR

#define D2DADR_ADR0_MASK                1U
#define D2DADR_ADR1_MASK                2U
#define D2DADR_ADR2_MASK                4U
#define D2DADR_ADR3_MASK                8U
#define D2DADR_ADR4_MASK                16U
#define D2DADR_ADR5_MASK                32U
#define D2DADR_ADR6_MASK                64U
#define D2DADR_ADR7_MASK                128U
#define D2DADR_NBLK_MASK                4096U
#define D2DADR_SZ8_MASK                 16384U
#define D2DADR_RWB_MASK                 32768U
#define D2DADR_ADR_MASK                 255U
#define D2DADR_ADR_BITNUM               0U


/*** D2DDATA - D2D Data Buffer Register; 0x000000DE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** D2DDATAHI - D2D Data Buffer Register High; 0x000000DE ***/
    union {
      byte Byte;
      struct {
        byte DATA8       :1;                                       /* Transaction Data, bit 8 */
        byte DATA9       :1;                                       /* Transaction Data, bit 9 */
        byte DATA10      :1;                                       /* Transaction Data, bit 10 */
        byte DATA11      :1;                                       /* Transaction Data, bit 11 */
        byte DATA12      :1;                                       /* Transaction Data, bit 12 */
        byte DATA13      :1;                                       /* Transaction Data, bit 13 */
        byte DATA14      :1;                                       /* Transaction Data, bit 14 */
        byte DATA15      :1;                                       /* Transaction Data, bit 15 */
      } Bits;
    } D2DDATAHISTR;
    #define D2DDATAHI                   _D2DDATA.Overlap_STR.D2DDATAHISTR.Byte
    #define D2DDATAHI_DATA8             _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA8
    #define D2DDATAHI_DATA9             _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA9
    #define D2DDATAHI_DATA10            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA10
    #define D2DDATAHI_DATA11            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA11
    #define D2DDATAHI_DATA12            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA12
    #define D2DDATAHI_DATA13            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA13
    #define D2DDATAHI_DATA14            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA14
    #define D2DDATAHI_DATA15            _D2DDATA.Overlap_STR.D2DDATAHISTR.Bits.DATA15
    
    #define D2DDATAHI_DATA8_MASK        1U
    #define D2DDATAHI_DATA9_MASK        2U
    #define D2DDATAHI_DATA10_MASK       4U
    #define D2DDATAHI_DATA11_MASK       8U
    #define D2DDATAHI_DATA12_MASK       16U
    #define D2DDATAHI_DATA13_MASK       32U
    #define D2DDATAHI_DATA14_MASK       64U
    #define D2DDATAHI_DATA15_MASK       128U
    

    /*** D2DDATALO - D2D Data Buffer Register Low; 0x000000DF ***/
    union {
      byte Byte;
      struct {
        byte DATA0       :1;                                       /* Transaction Data, bit 0 */
        byte DATA1       :1;                                       /* Transaction Data, bit 1 */
        byte DATA2       :1;                                       /* Transaction Data, bit 2 */
        byte DATA3       :1;                                       /* Transaction Data, bit 3 */
        byte DATA4       :1;                                       /* Transaction Data, bit 4 */
        byte DATA5       :1;                                       /* Transaction Data, bit 5 */
        byte DATA6       :1;                                       /* Transaction Data, bit 6 */
        byte DATA7       :1;                                       /* Transaction Data, bit 7 */
      } Bits;
    } D2DDATALOSTR;
    #define D2DDATALO                   _D2DDATA.Overlap_STR.D2DDATALOSTR.Byte
    #define D2DDATALO_DATA0             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA0
    #define D2DDATALO_DATA1             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA1
    #define D2DDATALO_DATA2             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA2
    #define D2DDATALO_DATA3             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA3
    #define D2DDATALO_DATA4             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA4
    #define D2DDATALO_DATA5             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA5
    #define D2DDATALO_DATA6             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA6
    #define D2DDATALO_DATA7             _D2DDATA.Overlap_STR.D2DDATALOSTR.Bits.DATA7
    
    #define D2DDATALO_DATA0_MASK        1U
    #define D2DDATALO_DATA1_MASK        2U
    #define D2DDATALO_DATA2_MASK        4U
    #define D2DDATALO_DATA3_MASK        8U
    #define D2DDATALO_DATA4_MASK        16U
    #define D2DDATALO_DATA5_MASK        32U
    #define D2DDATALO_DATA6_MASK        64U
    #define D2DDATALO_DATA7_MASK        128U
    
  } Overlap_STR;

  struct {
    word DATA0       :1;                                       /* Transaction Data, bit 0 */
    word DATA1       :1;                                       /* Transaction Data, bit 1 */
    word DATA2       :1;                                       /* Transaction Data, bit 2 */
    word DATA3       :1;                                       /* Transaction Data, bit 3 */
    word DATA4       :1;                                       /* Transaction Data, bit 4 */
    word DATA5       :1;                                       /* Transaction Data, bit 5 */
    word DATA6       :1;                                       /* Transaction Data, bit 6 */
    word DATA7       :1;                                       /* Transaction Data, bit 7 */
    word DATA8       :1;                                       /* Transaction Data, bit 8 */
    word DATA9       :1;                                       /* Transaction Data, bit 9 */
    word DATA10      :1;                                       /* Transaction Data, bit 10 */
    word DATA11      :1;                                       /* Transaction Data, bit 11 */
    word DATA12      :1;                                       /* Transaction Data, bit 12 */
    word DATA13      :1;                                       /* Transaction Data, bit 13 */
    word DATA14      :1;                                       /* Transaction Data, bit 14 */
    word DATA15      :1;                                       /* Transaction Data, bit 15 */
  } Bits;
} D2DDATASTR;
extern volatile D2DDATASTR _D2DDATA @(REG_BASE + 0x000000DEUL);
#define D2DDATA                         _D2DDATA.Word
#define D2DDATA_DATA0                   _D2DDATA.Bits.DATA0
#define D2DDATA_DATA1                   _D2DDATA.Bits.DATA1
#define D2DDATA_DATA2                   _D2DDATA.Bits.DATA2
#define D2DDATA_DATA3                   _D2DDATA.Bits.DATA3
#define D2DDATA_DATA4                   _D2DDATA.Bits.DATA4
#define D2DDATA_DATA5                   _D2DDATA.Bits.DATA5
#define D2DDATA_DATA6                   _D2DDATA.Bits.DATA6
#define D2DDATA_DATA7                   _D2DDATA.Bits.DATA7
#define D2DDATA_DATA8                   _D2DDATA.Bits.DATA8
#define D2DDATA_DATA9                   _D2DDATA.Bits.DATA9
#define D2DDATA_DATA10                  _D2DDATA.Bits.DATA10
#define D2DDATA_DATA11                  _D2DDATA.Bits.DATA11
#define D2DDATA_DATA12                  _D2DDATA.Bits.DATA12
#define D2DDATA_DATA13                  _D2DDATA.Bits.DATA13
#define D2DDATA_DATA14                  _D2DDATA.Bits.DATA14
#define D2DDATA_DATA15                  _D2DDATA.Bits.DATA15

#define D2DDATA_DATA0_MASK              1U
#define D2DDATA_DATA1_MASK              2U
#define D2DDATA_DATA2_MASK              4U
#define D2DDATA_DATA3_MASK              8U
#define D2DDATA_DATA4_MASK              16U
#define D2DDATA_DATA5_MASK              32U
#define D2DDATA_DATA6_MASK              64U
#define D2DDATA_DATA7_MASK              128U
#define D2DDATA_DATA8_MASK              256U
#define D2DDATA_DATA9_MASK              512U
#define D2DDATA_DATA10_MASK             1024U
#define D2DDATA_DATA11_MASK             2048U
#define D2DDATA_DATA12_MASK             4096U
#define D2DDATA_DATA13_MASK             8192U
#define D2DDATA_DATA14_MASK             16384U
#define D2DDATA_DATA15_MASK             32768U


/*** SPICR1 - SPI  Control Register 1; 0x000000E8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPICR1STR;
extern volatile SPICR1STR _SPICR1 @(REG_BASE + 0x000000E8UL);
#define SPICR1                          _SPICR1.Byte
#define SPICR1_LSBFE                    _SPICR1.Bits.LSBFE
#define SPICR1_SSOE                     _SPICR1.Bits.SSOE
#define SPICR1_CPHA                     _SPICR1.Bits.CPHA
#define SPICR1_CPOL                     _SPICR1.Bits.CPOL
#define SPICR1_MSTR                     _SPICR1.Bits.MSTR
#define SPICR1_SPTIE                    _SPICR1.Bits.SPTIE
#define SPICR1_SPE                      _SPICR1.Bits.SPE
#define SPICR1_SPIE                     _SPICR1.Bits.SPIE

#define SPICR1_LSBFE_MASK               1U
#define SPICR1_SSOE_MASK                2U
#define SPICR1_CPHA_MASK                4U
#define SPICR1_CPOL_MASK                8U
#define SPICR1_MSTR_MASK                16U
#define SPICR1_SPTIE_MASK               32U
#define SPICR1_SPE_MASK                 64U
#define SPICR1_SPIE_MASK                128U


/*** SPICR2 - SPI  Control Register 2; 0x000000E9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte XFRW        :1;                                       /* Transfer Width */
    byte             :1; 
  } Bits;
} SPICR2STR;
extern volatile SPICR2STR _SPICR2 @(REG_BASE + 0x000000E9UL);
#define SPICR2                          _SPICR2.Byte
#define SPICR2_SPC0                     _SPICR2.Bits.SPC0
#define SPICR2_SPISWAI                  _SPICR2.Bits.SPISWAI
#define SPICR2_BIDIROE                  _SPICR2.Bits.BIDIROE
#define SPICR2_MODFEN                   _SPICR2.Bits.MODFEN
#define SPICR2_XFRW                     _SPICR2.Bits.XFRW

#define SPICR2_SPC0_MASK                1U
#define SPICR2_SPISWAI_MASK             2U
#define SPICR2_BIDIROE_MASK             8U
#define SPICR2_MODFEN_MASK              16U
#define SPICR2_XFRW_MASK                64U


/*** SPIBR - SPI  Baud Rate Register; 0x000000EA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPIBRSTR;
extern volatile SPIBRSTR _SPIBR @(REG_BASE + 0x000000EAUL);
#define SPIBR                           _SPIBR.Byte
#define SPIBR_SPR0                      _SPIBR.Bits.SPR0
#define SPIBR_SPR1                      _SPIBR.Bits.SPR1
#define SPIBR_SPR2                      _SPIBR.Bits.SPR2
#define SPIBR_SPPR0                     _SPIBR.Bits.SPPR0
#define SPIBR_SPPR1                     _SPIBR.Bits.SPPR1
#define SPIBR_SPPR2                     _SPIBR.Bits.SPPR2
#define SPIBR_SPR                       _SPIBR.MergedBits.grpSPR
#define SPIBR_SPPR                      _SPIBR.MergedBits.grpSPPR

#define SPIBR_SPR0_MASK                 1U
#define SPIBR_SPR1_MASK                 2U
#define SPIBR_SPR2_MASK                 4U
#define SPIBR_SPPR0_MASK                16U
#define SPIBR_SPPR1_MASK                32U
#define SPIBR_SPPR2_MASK                64U
#define SPIBR_SPR_MASK                  7U
#define SPIBR_SPR_BITNUM                0U
#define SPIBR_SPPR_MASK                 112U
#define SPIBR_SPPR_BITNUM               4U


/*** SPISR - SPI  Status Register; 0x000000EB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPISRSTR;
extern volatile SPISRSTR _SPISR @(REG_BASE + 0x000000EBUL);
#define SPISR                           _SPISR.Byte
#define SPISR_MODF                      _SPISR.Bits.MODF
#define SPISR_SPTEF                     _SPISR.Bits.SPTEF
#define SPISR_SPIF                      _SPISR.Bits.SPIF

#define SPISR_MODF_MASK                 16U
#define SPISR_SPTEF_MASK                32U
#define SPISR_SPIF_MASK                 128U


/*** SPIDR - SPI  Data Register; 0x000000EC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SPIDRH - SPI  Data Register High; 0x000000EC ***/
    union {
      byte Byte;
      struct {
        byte R8_T8       :1;                                       /* SPI  Data Bit 8 */
        byte R9_T9       :1;                                       /* SPI  Data Bit 9 */
        byte R10_T10     :1;                                       /* SPI  Data Bit 10 */
        byte R11_T11     :1;                                       /* SPI  Data Bit 11 */
        byte R12_T12     :1;                                       /* SPI  Data Bit 12 */
        byte R13_T13     :1;                                       /* SPI  Data Bit 13 */
        byte R14_T14     :1;                                       /* SPI  Data Bit 14 */
        byte R15_T15     :1;                                       /* SPI  Data Bit 15 */
      } Bits;
    } SPIDRHSTR;
    #define SPIDRH                      _SPIDR.Overlap_STR.SPIDRHSTR.Byte
    #define SPIDRH_R8_T8                _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R8_T8
    #define SPIDRH_R9_T9                _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R9_T9
    #define SPIDRH_R10_T10              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R10_T10
    #define SPIDRH_R11_T11              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R11_T11
    #define SPIDRH_R12_T12              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R12_T12
    #define SPIDRH_R13_T13              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R13_T13
    #define SPIDRH_R14_T14              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R14_T14
    #define SPIDRH_R15_T15              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R15_T15
    
    #define SPIDRH_R8_T8_MASK           1U
    #define SPIDRH_R9_T9_MASK           2U
    #define SPIDRH_R10_T10_MASK         4U
    #define SPIDRH_R11_T11_MASK         8U
    #define SPIDRH_R12_T12_MASK         16U
    #define SPIDRH_R13_T13_MASK         32U
    #define SPIDRH_R14_T14_MASK         64U
    #define SPIDRH_R15_T15_MASK         128U
    

    /*** SPIDRL - SPI  Data Register Low; 0x000000ED ***/
    union {
      byte Byte;
      struct {
        byte R0_T0       :1;                                       /* SPI  Data Bit 0 */
        byte R1_T1       :1;                                       /* SPI  Data Bit 1 */
        byte R2_T2       :1;                                       /* SPI  Data Bit 2 */
        byte R3_T3       :1;                                       /* SPI  Data Bit 3 */
        byte R4_T4       :1;                                       /* SPI  Data Bit 4 */
        byte R5_T5       :1;                                       /* SPI  Data Bit 5 */
        byte R6_T6       :1;                                       /* SPI  Data Bit 6 */
        byte R7_T7       :1;                                       /* SPI  Data Bit 7 */
      } Bits;
    } SPIDRLSTR;
    #define SPIDRL                      _SPIDR.Overlap_STR.SPIDRLSTR.Byte
    #define SPIDRL_R0_T0                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R0_T0
    #define SPIDRL_R1_T1                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R1_T1
    #define SPIDRL_R2_T2                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R2_T2
    #define SPIDRL_R3_T3                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R3_T3
    #define SPIDRL_R4_T4                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R4_T4
    #define SPIDRL_R5_T5                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R5_T5
    #define SPIDRL_R6_T6                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R6_T6
    #define SPIDRL_R7_T7                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R7_T7
    
    #define SPIDRL_R0_T0_MASK           1U
    #define SPIDRL_R1_T1_MASK           2U
    #define SPIDRL_R2_T2_MASK           4U
    #define SPIDRL_R3_T3_MASK           8U
    #define SPIDRL_R4_T4_MASK           16U
    #define SPIDRL_R5_T5_MASK           32U
    #define SPIDRL_R6_T6_MASK           64U
    #define SPIDRL_R7_T7_MASK           128U
    
  } Overlap_STR;

  struct {
    word R0_T0       :1;                                       /* SPI  Data Bit 0 */
    word R1_T1       :1;                                       /* SPI  Data Bit 1 */
    word R2_T2       :1;                                       /* SPI  Data Bit 2 */
    word R3_T3       :1;                                       /* SPI  Data Bit 3 */
    word R4_T4       :1;                                       /* SPI  Data Bit 4 */
    word R5_T5       :1;                                       /* SPI  Data Bit 5 */
    word R6_T6       :1;                                       /* SPI  Data Bit 6 */
    word R7_T7       :1;                                       /* SPI  Data Bit 7 */
    word R8_T8       :1;                                       /* SPI  Data Bit 8 */
    word R9_T9       :1;                                       /* SPI  Data Bit 9 */
    word R10_T10     :1;                                       /* SPI  Data Bit 10 */
    word R11_T11     :1;                                       /* SPI  Data Bit 11 */
    word R12_T12     :1;                                       /* SPI  Data Bit 12 */
    word R13_T13     :1;                                       /* SPI  Data Bit 13 */
    word R14_T14     :1;                                       /* SPI  Data Bit 14 */
    word R15_T15     :1;                                       /* SPI  Data Bit 15 */
  } Bits;
} SPIDRSTR;
extern volatile SPIDRSTR _SPIDR @(REG_BASE + 0x000000ECUL);
#define SPIDR                           _SPIDR.Word
#define SPIDR_R0_T0                     _SPIDR.Bits.R0_T0
#define SPIDR_R1_T1                     _SPIDR.Bits.R1_T1
#define SPIDR_R2_T2                     _SPIDR.Bits.R2_T2
#define SPIDR_R3_T3                     _SPIDR.Bits.R3_T3
#define SPIDR_R4_T4                     _SPIDR.Bits.R4_T4
#define SPIDR_R5_T5                     _SPIDR.Bits.R5_T5
#define SPIDR_R6_T6                     _SPIDR.Bits.R6_T6
#define SPIDR_R7_T7                     _SPIDR.Bits.R7_T7
#define SPIDR_R8_T8                     _SPIDR.Bits.R8_T8
#define SPIDR_R9_T9                     _SPIDR.Bits.R9_T9
#define SPIDR_R10_T10                   _SPIDR.Bits.R10_T10
#define SPIDR_R11_T11                   _SPIDR.Bits.R11_T11
#define SPIDR_R12_T12                   _SPIDR.Bits.R12_T12
#define SPIDR_R13_T13                   _SPIDR.Bits.R13_T13
#define SPIDR_R14_T14                   _SPIDR.Bits.R14_T14
#define SPIDR_R15_T15                   _SPIDR.Bits.R15_T15

#define SPIDR_R0_T0_MASK                1U
#define SPIDR_R1_T1_MASK                2U
#define SPIDR_R2_T2_MASK                4U
#define SPIDR_R3_T3_MASK                8U
#define SPIDR_R4_T4_MASK                16U
#define SPIDR_R5_T5_MASK                32U
#define SPIDR_R6_T6_MASK                64U
#define SPIDR_R7_T7_MASK                128U
#define SPIDR_R8_T8_MASK                256U
#define SPIDR_R9_T9_MASK                512U
#define SPIDR_R10_T10_MASK              1024U
#define SPIDR_R11_T11_MASK              2048U
#define SPIDR_R12_T12_MASK              4096U
#define SPIDR_R13_T13_MASK              8192U
#define SPIDR_R14_T14_MASK              16384U
#define SPIDR_R15_T15_MASK              32768U


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Clock Divider Bit 5 */
    byte FDIVLCK     :1;                                       /* Clock divider locked */
    byte FDIVLD      :1;                                       /* Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_FDIVLCK                 _FCLKDIV.Bits.FDIVLCK
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_FDIVLCK_MASK            64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               63U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte RNV2        :1;                                       /* Reserved Nonvolatile Bit 2 */
    byte RNV3        :1;                                       /* Reserved Nonvolatile Bit 3 */
    byte RNV4        :1;                                       /* Reserved Nonvolatile Bit 4 */
    byte RNV5        :1;                                       /* Reserved Nonvolatile Bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_RNV2                       _FSEC.Bits.RNV2
#define FSEC_RNV3                       _FSEC.Bits.RNV3
#define FSEC_RNV4                       _FSEC.Bits.RNV4
#define FSEC_RNV5                       _FSEC.Bits.RNV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_RNV_2                      _FSEC.MergedBits.grpRNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_RNV                        FSEC_RNV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_RNV2_MASK                  4U
#define FSEC_RNV3_MASK                  8U
#define FSEC_RNV4_MASK                  16U
#define FSEC_RNV5_MASK                  32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_RNV_2_MASK                 60U
#define FSEC_RNV_2_BITNUM               2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***/
typedef union {
  byte Byte;
  struct {
    byte CCOBIX0     :1;                                       /* Common Command Register Index Bit 0 */
    byte CCOBIX1     :1;                                       /* Common Command Register Index Bit 1 */
    byte CCOBIX2     :1;                                       /* Common Command Register Index Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCCOBIX :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCCOBIXSTR;
extern volatile FCCOBIXSTR _FCCOBIX @(REG_BASE + 0x00000102UL);
#define FCCOBIX                         _FCCOBIX.Byte
#define FCCOBIX_CCOBIX0                 _FCCOBIX.Bits.CCOBIX0
#define FCCOBIX_CCOBIX1                 _FCCOBIX.Bits.CCOBIX1
#define FCCOBIX_CCOBIX2                 _FCCOBIX.Bits.CCOBIX2
#define FCCOBIX_CCOBIX                  _FCCOBIX.MergedBits.grpCCOBIX

#define FCCOBIX_CCOBIX0_MASK            1U
#define FCCOBIX_CCOBIX1_MASK            2U
#define FCCOBIX_CCOBIX2_MASK            4U
#define FCCOBIX_CCOBIX_MASK             7U
#define FCCOBIX_CCOBIX_BITNUM           0U


/*** FCNFG - Flash Configuration Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FSFD        :1;                                       /* Force Single Bit Fault Detect */
    byte FDFD        :1;                                       /* Force Double Bit Fault Detect */
    byte             :1; 
    byte             :1; 
    byte IGNSF       :1;                                       /* Ignore Single Bit Fault */
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000104UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_FSFD                      _FCNFG.Bits.FSFD
#define FCNFG_FDFD                      _FCNFG.Bits.FDFD
#define FCNFG_IGNSF                     _FCNFG.Bits.IGNSF
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE

#define FCNFG_FSFD_MASK                 1U
#define FCNFG_FDFD_MASK                 2U
#define FCNFG_IGNSF_MASK                16U
#define FCNFG_CCIE_MASK                 128U


/*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte SFDIE       :1;                                       /* Single Bit Fault Detect Interrupt Enable */
    byte DFDIE       :1;                                       /* Double Bit Fault Detect Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} FERCNFGSTR;
extern volatile FERCNFGSTR _FERCNFG @(REG_BASE + 0x00000105UL);
#define FERCNFG                         _FERCNFG.Byte
#define FERCNFG_SFDIE                   _FERCNFG.Bits.SFDIE
#define FERCNFG_DFDIE                   _FERCNFG.Bits.DFDIE

#define FERCNFG_SFDIE_MASK              1U
#define FERCNFG_DFDIE_MASK              2U


/*** FSTAT - Flash Status Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte MGSTAT0     :1;                                       /* Memory Controller Command Completion Status Flag 0 */
    byte MGSTAT1     :1;                                       /* Memory Controller Command Completion Status Flag 1 */
    byte             :1; 
    byte MGBUSY      :1;                                       /* Memory Controller Busy Flag */
    byte FPVIOL      :1;                                       /* Flash Protection Violation Flag */
    byte ACCERR      :1;                                       /* Flash Access Error Flag */
    byte             :1; 
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
  } Bits;
  struct {
    byte grpMGSTAT :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000106UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_MGSTAT0                   _FSTAT.Bits.MGSTAT0
#define FSTAT_MGSTAT1                   _FSTAT.Bits.MGSTAT1
#define FSTAT_MGBUSY                    _FSTAT.Bits.MGBUSY
#define FSTAT_FPVIOL                    _FSTAT.Bits.FPVIOL
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_MGSTAT                    _FSTAT.MergedBits.grpMGSTAT

#define FSTAT_MGSTAT0_MASK              1U
#define FSTAT_MGSTAT1_MASK              2U
#define FSTAT_MGBUSY_MASK               8U
#define FSTAT_FPVIOL_MASK               16U
#define FSTAT_ACCERR_MASK               32U
#define FSTAT_CCIF_MASK                 128U
#define FSTAT_MGSTAT_MASK               3U
#define FSTAT_MGSTAT_BITNUM             0U


/*** FERSTAT - Flash Error Status Register; 0x00000107 ***/
typedef union {
  byte Byte;
  struct {
    byte SFDIF       :1;                                       /* Single Bit Fault Detect Interrupt Flag */
    byte DFDIF       :1;                                       /* Double Bit Fault Detect Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} FERSTATSTR;
extern volatile FERSTATSTR _FERSTAT @(REG_BASE + 0x00000107UL);
#define FERSTAT                         _FERSTAT.Byte
#define FERSTAT_SFDIF                   _FERSTAT.Bits.SFDIF
#define FERSTAT_DFDIF                   _FERSTAT.Bits.DFDIF

#define FERSTAT_SFDIF_MASK              1U
#define FERSTAT_DFDIF_MASK              2U


/*** FPROT - P-Flash Protection Register; 0x00000108 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address Size Bit 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address Size Bit 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower Address Range Disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher Address Size Bit 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher Address Size Bit 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher Address Range Disable */
    byte RNV6        :1;                                       /* Reserved Nonvolatile Bit */
    byte FPOPEN      :1;                                       /* Flash Protection Operation Enable */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000108UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_RNV6                      _FPROT.Bits.RNV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_RNV6_MASK                 64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** DFPROT - D-Flash Protection Register; 0x00000109 ***/
typedef union {
  byte Byte;
  struct {
    byte DPS0        :1;                                       /* D-Flash Protection Size Bit 0 */
    byte DPS1        :1;                                       /* D-Flash Protection Size Bit 1 */
    byte DPS2        :1;                                       /* D-Flash Protection Size Bit 2 */
    byte DPS3        :1;                                       /* D-Flash Protection Size Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte DPOPEN      :1;                                       /* D-Flash Protection Control */
  } Bits;
  struct {
    byte grpDPS  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DFPROTSTR;
extern volatile DFPROTSTR _DFPROT @(REG_BASE + 0x00000109UL);
#define DFPROT                          _DFPROT.Byte
#define DFPROT_DPS0                     _DFPROT.Bits.DPS0
#define DFPROT_DPS1                     _DFPROT.Bits.DPS1
#define DFPROT_DPS2                     _DFPROT.Bits.DPS2
#define DFPROT_DPS3                     _DFPROT.Bits.DPS3
#define DFPROT_DPOPEN                   _DFPROT.Bits.DPOPEN
#define DFPROT_DPS                      _DFPROT.MergedBits.grpDPS

#define DFPROT_DPS0_MASK                1U
#define DFPROT_DPS1_MASK                2U
#define DFPROT_DPS2_MASK                4U
#define DFPROT_DPS3_MASK                8U
#define DFPROT_DPOPEN_MASK              128U
#define DFPROT_DPS_MASK                 15U
#define DFPROT_DPS_BITNUM               0U


/*** FCCOB - Flash Common Command Object Register; 0x0000010A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***/
    union {
      byte Byte;
      struct {
        byte CCOB8       :1;                                       /* Flash Common Command Object Bit 8 */
        byte CCOB9       :1;                                       /* Flash Common Command Object Bit 9 */
        byte CCOB10      :1;                                       /* Flash Common Command Object Bit 10 */
        byte CCOB11      :1;                                       /* Flash Common Command Object Bit 11 */
        byte CCOB12      :1;                                       /* Flash Common Command Object Bit 12 */
        byte CCOB13      :1;                                       /* Flash Common Command Object Bit 13 */
        byte CCOB14      :1;                                       /* Flash Common Command Object Bit 14 */
        byte CCOB15      :1;                                       /* Flash Common Command Object Bit 15 */
      } Bits;
    } FCCOBHISTR;
    #define FCCOBHI                     _FCCOB.Overlap_STR.FCCOBHISTR.Byte
    #define FCCOBHI_CCOB8               _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB8
    #define FCCOBHI_CCOB9               _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB9
    #define FCCOBHI_CCOB10              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB10
    #define FCCOBHI_CCOB11              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB11
    #define FCCOBHI_CCOB12              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB12
    #define FCCOBHI_CCOB13              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB13
    #define FCCOBHI_CCOB14              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB14
    #define FCCOBHI_CCOB15              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB15
    
    #define FCCOBHI_CCOB8_MASK          1U
    #define FCCOBHI_CCOB9_MASK          2U
    #define FCCOBHI_CCOB10_MASK         4U
    #define FCCOBHI_CCOB11_MASK         8U
    #define FCCOBHI_CCOB12_MASK         16U
    #define FCCOBHI_CCOB13_MASK         32U
    #define FCCOBHI_CCOB14_MASK         64U
    #define FCCOBHI_CCOB15_MASK         128U
    

    /*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***/
    union {
      byte Byte;
      struct {
        byte CCOB0       :1;                                       /* Flash Common Command Object Bit 0 */
        byte CCOB1       :1;                                       /* Flash Common Command Object Bit 1 */
        byte CCOB2       :1;                                       /* Flash Common Command Object Bit 2 */
        byte CCOB3       :1;                                       /* Flash Common Command Object Bit 3 */
        byte CCOB4       :1;                                       /* Flash Common Command Object Bit 4 */
        byte CCOB5       :1;                                       /* Flash Common Command Object Bit 5 */
        byte CCOB6       :1;                                       /* Flash Common Command Object Bit 6 */
        byte CCOB7       :1;                                       /* Flash Common Command Object Bit 7 */
      } Bits;
    } FCCOBLOSTR;
    #define FCCOBLO                     _FCCOB.Overlap_STR.FCCOBLOSTR.Byte
    #define FCCOBLO_CCOB0               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB0
    #define FCCOBLO_CCOB1               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB1
    #define FCCOBLO_CCOB2               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB2
    #define FCCOBLO_CCOB3               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB3
    #define FCCOBLO_CCOB4               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB4
    #define FCCOBLO_CCOB5               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB5
    #define FCCOBLO_CCOB6               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB6
    #define FCCOBLO_CCOB7               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB7
    
    #define FCCOBLO_CCOB0_MASK          1U
    #define FCCOBLO_CCOB1_MASK          2U
    #define FCCOBLO_CCOB2_MASK          4U
    #define FCCOBLO_CCOB3_MASK          8U
    #define FCCOBLO_CCOB4_MASK          16U
    #define FCCOBLO_CCOB5_MASK          32U
    #define FCCOBLO_CCOB6_MASK          64U
    #define FCCOBLO_CCOB7_MASK          128U
    
  } Overlap_STR;

  struct {
    word CCOB0       :1;                                       /* Flash Common Command Object Bit 0 */
    word CCOB1       :1;                                       /* Flash Common Command Object Bit 1 */
    word CCOB2       :1;                                       /* Flash Common Command Object Bit 2 */
    word CCOB3       :1;                                       /* Flash Common Command Object Bit 3 */
    word CCOB4       :1;                                       /* Flash Common Command Object Bit 4 */
    word CCOB5       :1;                                       /* Flash Common Command Object Bit 5 */
    word CCOB6       :1;                                       /* Flash Common Command Object Bit 6 */
    word CCOB7       :1;                                       /* Flash Common Command Object Bit 7 */
    word CCOB8       :1;                                       /* Flash Common Command Object Bit 8 */
    word CCOB9       :1;                                       /* Flash Common Command Object Bit 9 */
    word CCOB10      :1;                                       /* Flash Common Command Object Bit 10 */
    word CCOB11      :1;                                       /* Flash Common Command Object Bit 11 */
    word CCOB12      :1;                                       /* Flash Common Command Object Bit 12 */
    word CCOB13      :1;                                       /* Flash Common Command Object Bit 13 */
    word CCOB14      :1;                                       /* Flash Common Command Object Bit 14 */
    word CCOB15      :1;                                       /* Flash Common Command Object Bit 15 */
  } Bits;
} FCCOBSTR;
extern volatile FCCOBSTR _FCCOB @(REG_BASE + 0x0000010AUL);
#define FCCOB                           _FCCOB.Word
#define FCCOB_CCOB0                     _FCCOB.Bits.CCOB0
#define FCCOB_CCOB1                     _FCCOB.Bits.CCOB1
#define FCCOB_CCOB2                     _FCCOB.Bits.CCOB2
#define FCCOB_CCOB3                     _FCCOB.Bits.CCOB3
#define FCCOB_CCOB4                     _FCCOB.Bits.CCOB4
#define FCCOB_CCOB5                     _FCCOB.Bits.CCOB5
#define FCCOB_CCOB6                     _FCCOB.Bits.CCOB6
#define FCCOB_CCOB7                     _FCCOB.Bits.CCOB7
#define FCCOB_CCOB8                     _FCCOB.Bits.CCOB8
#define FCCOB_CCOB9                     _FCCOB.Bits.CCOB9
#define FCCOB_CCOB10                    _FCCOB.Bits.CCOB10
#define FCCOB_CCOB11                    _FCCOB.Bits.CCOB11
#define FCCOB_CCOB12                    _FCCOB.Bits.CCOB12
#define FCCOB_CCOB13                    _FCCOB.Bits.CCOB13
#define FCCOB_CCOB14                    _FCCOB.Bits.CCOB14
#define FCCOB_CCOB15                    _FCCOB.Bits.CCOB15

#define FCCOB_CCOB0_MASK                1U
#define FCCOB_CCOB1_MASK                2U
#define FCCOB_CCOB2_MASK                4U
#define FCCOB_CCOB3_MASK                8U
#define FCCOB_CCOB4_MASK                16U
#define FCCOB_CCOB5_MASK                32U
#define FCCOB_CCOB6_MASK                64U
#define FCCOB_CCOB7_MASK                128U
#define FCCOB_CCOB8_MASK                256U
#define FCCOB_CCOB9_MASK                512U
#define FCCOB_CCOB10_MASK               1024U
#define FCCOB_CCOB11_MASK               2048U
#define FCCOB_CCOB12_MASK               4096U
#define FCCOB_CCOB13_MASK               8192U
#define FCCOB_CCOB14_MASK               16384U
#define FCCOB_CCOB15_MASK               32768U


/*** FOPT - Flash Option Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Nonvolatile Bit 0 */
    byte NV1         :1;                                       /* Nonvolatile Bit 1 */
    byte NV2         :1;                                       /* Nonvolatile Bit 2 */
    byte NV3         :1;                                       /* Nonvolatile Bit 3 */
    byte NV4         :1;                                       /* Nonvolatile Bit 4 */
    byte NV5         :1;                                       /* Nonvolatile Bit 5 */
    byte NV6         :1;                                       /* Nonvolatile Bit 6 */
    byte NV7         :1;                                       /* Nonvolatile Bit 7 */
  } Bits;
} FOPTSTR;
extern volatile FOPTSTR _FOPT @(REG_BASE + 0x00000110UL);
#define FOPT                            _FOPT.Byte
#define FOPT_NV0                        _FOPT.Bits.NV0
#define FOPT_NV1                        _FOPT.Bits.NV1
#define FOPT_NV2                        _FOPT.Bits.NV2
#define FOPT_NV3                        _FOPT.Bits.NV3
#define FOPT_NV4                        _FOPT.Bits.NV4
#define FOPT_NV5                        _FOPT.Bits.NV5
#define FOPT_NV6                        _FOPT.Bits.NV6
#define FOPT_NV7                        _FOPT.Bits.NV7

#define FOPT_NV0_MASK                   1U
#define FOPT_NV1_MASK                   2U
#define FOPT_NV2_MASK                   4U
#define FOPT_NV3_MASK                   8U
#define FOPT_NV4_MASK                   16U
#define FOPT_NV5_MASK                   32U
#define FOPT_NV6_MASK                   64U
#define FOPT_NV7_MASK                   128U


/*** PTIA - Port A Input Register; 0x00000120 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIA0       :1;                                       /* Port A input data bit 0 */
    byte PTIA1       :1;                                       /* Port A input data bit 1 */
    byte PTIA2       :1;                                       /* Port A input data bit 2 */
    byte PTIA3       :1;                                       /* Port A input data bit 3 */
    byte PTIA4       :1;                                       /* Port A input data bit 4 */
    byte PTIA5       :1;                                       /* Port A input data bit 5 */
    byte PTIA6       :1;                                       /* Port A input data bit 6 */
    byte PTIA7       :1;                                       /* Port A input data bit 7 */
  } Bits;
} PTIASTR;
extern volatile PTIASTR _PTIA @(REG_BASE + 0x00000120UL);
#define PTIA                            _PTIA.Byte
#define PTIA_PTIA0                      _PTIA.Bits.PTIA0
#define PTIA_PTIA1                      _PTIA.Bits.PTIA1
#define PTIA_PTIA2                      _PTIA.Bits.PTIA2
#define PTIA_PTIA3                      _PTIA.Bits.PTIA3
#define PTIA_PTIA4                      _PTIA.Bits.PTIA4
#define PTIA_PTIA5                      _PTIA.Bits.PTIA5
#define PTIA_PTIA6                      _PTIA.Bits.PTIA6
#define PTIA_PTIA7                      _PTIA.Bits.PTIA7

#define PTIA_PTIA0_MASK                 1U
#define PTIA_PTIA1_MASK                 2U
#define PTIA_PTIA2_MASK                 4U
#define PTIA_PTIA3_MASK                 8U
#define PTIA_PTIA4_MASK                 16U
#define PTIA_PTIA5_MASK                 32U
#define PTIA_PTIA6_MASK                 64U
#define PTIA_PTIA7_MASK                 128U


/*** PTIB - Port B Input Register; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIB0       :1;                                       /* Port B input data bit 0 */
    byte PTIB1       :1;                                       /* Port B input data bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIB :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIBSTR;
extern volatile PTIBSTR _PTIB @(REG_BASE + 0x00000121UL);
#define PTIB                            _PTIB.Byte
#define PTIB_PTIB0                      _PTIB.Bits.PTIB0
#define PTIB_PTIB1                      _PTIB.Bits.PTIB1
#define PTIB_PTIB                       _PTIB.MergedBits.grpPTIB

#define PTIB_PTIB0_MASK                 1U
#define PTIB_PTIB1_MASK                 2U
#define PTIB_PTIB_MASK                  3U
#define PTIB_PTIB_BITNUM                0U


/*** CPMULVCTL - Low Voltage Control Register; 0x000001F1 ***/
typedef union {
  byte Byte;
  struct {
    byte LVIF        :1;                                       /* Low-Voltage Interrupt Flag */
    byte LVIE        :1;                                       /* Low-Voltage Interrupt Enable Bit */
    byte LVDS        :1;                                       /* Low-Voltage Detect Status Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CPMULVCTLSTR;
extern volatile CPMULVCTLSTR _CPMULVCTL @(REG_BASE + 0x000001F1UL);
#define CPMULVCTL                       _CPMULVCTL.Byte
#define CPMULVCTL_LVIF                  _CPMULVCTL.Bits.LVIF
#define CPMULVCTL_LVIE                  _CPMULVCTL.Bits.LVIE
#define CPMULVCTL_LVDS                  _CPMULVCTL.Bits.LVDS

#define CPMULVCTL_LVIF_MASK             1U
#define CPMULVCTL_LVIE_MASK             2U
#define CPMULVCTL_LVDS_MASK             4U


/*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000001F8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000001F8 ***/
    union {
      byte Byte;
      struct {
        byte IRCTRIM8    :1;                                       /* IRC1M Frequency Trim Bit 8 */
        byte IRCTRIM9    :1;                                       /* IRC1M Frequency Trim Bit 9 */
        byte             :1; 
        byte             :1; 
        byte TCTRIM0     :1;                                       /* IRC1M temperature coeficient Trim Bit 0 */
        byte TCTRIM1     :1;                                       /* IRC1M temperature coeficient Trim Bit 1 */
        byte TCTRIM2     :1;                                       /* IRC1M temperature coeficient Trim Bit 2 */
        byte TCTRIM3     :1;                                       /* IRC1M temperature coeficient Trim Bit 3 */
      } Bits;
      struct {
        byte grpIRCTRIM_8 :2;
        byte     :1;
        byte     :1;
        byte grpTCTRIM :4;
      } MergedBits;
    } CPMUIRCTRIMHSTR;
    #define CPMUIRCTRIMH                _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Byte
    #define CPMUIRCTRIMH_IRCTRIM8       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.IRCTRIM8
    #define CPMUIRCTRIMH_IRCTRIM9       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.IRCTRIM9
    #define CPMUIRCTRIMH_TCTRIM0        _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.TCTRIM0
    #define CPMUIRCTRIMH_TCTRIM1        _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.TCTRIM1
    #define CPMUIRCTRIMH_TCTRIM2        _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.TCTRIM2
    #define CPMUIRCTRIMH_TCTRIM3        _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.Bits.TCTRIM3
    #define CPMUIRCTRIMH_IRCTRIM_8      _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.MergedBits.grpIRCTRIM_8
    #define CPMUIRCTRIMH_TCTRIM         _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMHSTR.MergedBits.grpTCTRIM
    #define CPMUIRCTRIMH_IRCTRIM        CPMUIRCTRIMH_IRCTRIM_8
    
    #define CPMUIRCTRIMH_IRCTRIM8_MASK  1U
    #define CPMUIRCTRIMH_IRCTRIM9_MASK  2U
    #define CPMUIRCTRIMH_TCTRIM0_MASK   16U
    #define CPMUIRCTRIMH_TCTRIM1_MASK   32U
    #define CPMUIRCTRIMH_TCTRIM2_MASK   64U
    #define CPMUIRCTRIMH_TCTRIM3_MASK   128U
    #define CPMUIRCTRIMH_IRCTRIM_8_MASK 3U
    #define CPMUIRCTRIMH_IRCTRIM_8_BITNUM 0U
    #define CPMUIRCTRIMH_TCTRIM_MASK    240U
    #define CPMUIRCTRIMH_TCTRIM_BITNUM  4U
    

    /*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000001F9 ***/
    union {
      byte Byte;
      struct {
        byte IRCTRIM0    :1;                                       /* IRC1M Frequency Trim Bit 0 */
        byte IRCTRIM1    :1;                                       /* IRC1M Frequency Trim Bit 1 */
        byte IRCTRIM2    :1;                                       /* IRC1M Frequency Trim Bit 2 */
        byte IRCTRIM3    :1;                                       /* IRC1M Frequency Trim Bit 3 */
        byte IRCTRIM4    :1;                                       /* IRC1M Frequency Trim Bit 4 */
        byte IRCTRIM5    :1;                                       /* IRC1M Frequency Trim Bit 5 */
        byte IRCTRIM6    :1;                                       /* IRC1M Frequency Trim Bit 6 */
        byte IRCTRIM7    :1;                                       /* IRC1M Frequency Trim Bit 7 */
      } Bits;
    } CPMUIRCTRIMLSTR;
    #define CPMUIRCTRIML                _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Byte
    #define CPMUIRCTRIML_IRCTRIM0       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM0
    #define CPMUIRCTRIML_IRCTRIM1       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM1
    #define CPMUIRCTRIML_IRCTRIM2       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM2
    #define CPMUIRCTRIML_IRCTRIM3       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM3
    #define CPMUIRCTRIML_IRCTRIM4       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM4
    #define CPMUIRCTRIML_IRCTRIM5       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM5
    #define CPMUIRCTRIML_IRCTRIM6       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM6
    #define CPMUIRCTRIML_IRCTRIM7       _CPMUIRCTRIM.Overlap_STR.CPMUIRCTRIMLSTR.Bits.IRCTRIM7
    
    #define CPMUIRCTRIML_IRCTRIM0_MASK  1U
    #define CPMUIRCTRIML_IRCTRIM1_MASK  2U
    #define CPMUIRCTRIML_IRCTRIM2_MASK  4U
    #define CPMUIRCTRIML_IRCTRIM3_MASK  8U
    #define CPMUIRCTRIML_IRCTRIM4_MASK  16U
    #define CPMUIRCTRIML_IRCTRIM5_MASK  32U
    #define CPMUIRCTRIML_IRCTRIM6_MASK  64U
    #define CPMUIRCTRIML_IRCTRIM7_MASK  128U
    
  } Overlap_STR;

  struct {
    word IRCTRIM0    :1;                                       /* IRC1M Frequency Trim Bit 0 */
    word IRCTRIM1    :1;                                       /* IRC1M Frequency Trim Bit 1 */
    word IRCTRIM2    :1;                                       /* IRC1M Frequency Trim Bit 2 */
    word IRCTRIM3    :1;                                       /* IRC1M Frequency Trim Bit 3 */
    word IRCTRIM4    :1;                                       /* IRC1M Frequency Trim Bit 4 */
    word IRCTRIM5    :1;                                       /* IRC1M Frequency Trim Bit 5 */
    word IRCTRIM6    :1;                                       /* IRC1M Frequency Trim Bit 6 */
    word IRCTRIM7    :1;                                       /* IRC1M Frequency Trim Bit 7 */
    word IRCTRIM8    :1;                                       /* IRC1M Frequency Trim Bit 8 */
    word IRCTRIM9    :1;                                       /* IRC1M Frequency Trim Bit 9 */
    word             :1; 
    word             :1; 
    word TCTRIM0     :1;                                       /* IRC1M temperature coeficient Trim Bit 0 */
    word TCTRIM1     :1;                                       /* IRC1M temperature coeficient Trim Bit 1 */
    word TCTRIM2     :1;                                       /* IRC1M temperature coeficient Trim Bit 2 */
    word TCTRIM3     :1;                                       /* IRC1M temperature coeficient Trim Bit 3 */
  } Bits;
  struct {
    word grpIRCTRIM :10;
    word         :1;
    word         :1;
    word grpTCTRIM :4;
  } MergedBits;
} CPMUIRCTRIMSTR;
extern volatile CPMUIRCTRIMSTR _CPMUIRCTRIM @(REG_BASE + 0x000001F8UL);
#define CPMUIRCTRIM                     _CPMUIRCTRIM.Word
#define CPMUIRCTRIM_IRCTRIM0            _CPMUIRCTRIM.Bits.IRCTRIM0
#define CPMUIRCTRIM_IRCTRIM1            _CPMUIRCTRIM.Bits.IRCTRIM1
#define CPMUIRCTRIM_IRCTRIM2            _CPMUIRCTRIM.Bits.IRCTRIM2
#define CPMUIRCTRIM_IRCTRIM3            _CPMUIRCTRIM.Bits.IRCTRIM3
#define CPMUIRCTRIM_IRCTRIM4            _CPMUIRCTRIM.Bits.IRCTRIM4
#define CPMUIRCTRIM_IRCTRIM5            _CPMUIRCTRIM.Bits.IRCTRIM5
#define CPMUIRCTRIM_IRCTRIM6            _CPMUIRCTRIM.Bits.IRCTRIM6
#define CPMUIRCTRIM_IRCTRIM7            _CPMUIRCTRIM.Bits.IRCTRIM7
#define CPMUIRCTRIM_IRCTRIM8            _CPMUIRCTRIM.Bits.IRCTRIM8
#define CPMUIRCTRIM_IRCTRIM9            _CPMUIRCTRIM.Bits.IRCTRIM9
#define CPMUIRCTRIM_TCTRIM0             _CPMUIRCTRIM.Bits.TCTRIM0
#define CPMUIRCTRIM_TCTRIM1             _CPMUIRCTRIM.Bits.TCTRIM1
#define CPMUIRCTRIM_TCTRIM2             _CPMUIRCTRIM.Bits.TCTRIM2
#define CPMUIRCTRIM_TCTRIM3             _CPMUIRCTRIM.Bits.TCTRIM3
#define CPMUIRCTRIM_IRCTRIM             _CPMUIRCTRIM.MergedBits.grpIRCTRIM
#define CPMUIRCTRIM_TCTRIM              _CPMUIRCTRIM.MergedBits.grpTCTRIM

#define CPMUIRCTRIM_IRCTRIM0_MASK       1U
#define CPMUIRCTRIM_IRCTRIM1_MASK       2U
#define CPMUIRCTRIM_IRCTRIM2_MASK       4U
#define CPMUIRCTRIM_IRCTRIM3_MASK       8U
#define CPMUIRCTRIM_IRCTRIM4_MASK       16U
#define CPMUIRCTRIM_IRCTRIM5_MASK       32U
#define CPMUIRCTRIM_IRCTRIM6_MASK       64U
#define CPMUIRCTRIM_IRCTRIM7_MASK       128U
#define CPMUIRCTRIM_IRCTRIM8_MASK       256U
#define CPMUIRCTRIM_IRCTRIM9_MASK       512U
#define CPMUIRCTRIM_TCTRIM0_MASK        4096U
#define CPMUIRCTRIM_TCTRIM1_MASK        8192U
#define CPMUIRCTRIM_TCTRIM2_MASK        16384U
#define CPMUIRCTRIM_TCTRIM3_MASK        32768U
#define CPMUIRCTRIM_IRCTRIM_MASK        1023U
#define CPMUIRCTRIM_IRCTRIM_BITNUM      0U
#define CPMUIRCTRIM_TCTRIM_MASK         61440U
#define CPMUIRCTRIM_TCTRIM_BITNUM       12U


/*** CPMUOSC - S12CPMU Oscillator Register; 0x000001FA ***/
typedef union {
  byte Byte;
  struct {
    byte OSCFILT0    :1;                                       /* Oscillator Filter Bits, bit 0 */
    byte OSCFILT1    :1;                                       /* Oscillator Filter Bits, bit 1 */
    byte OSCFILT2    :1;                                       /* Oscillator Filter Bits, bit 2 */
    byte OSCFILT3    :1;                                       /* Oscillator Filter Bits, bit 3 */
    byte OSCFILT4    :1;                                       /* Oscillator Filter Bits, bit 4 */
    byte OSCPINS_EN  :1;                                       /* Oscillator Pins EXTAL and XTAL Enable Bit */
    byte OSCBW       :1;                                       /* Oscillator Filter Bandwidth Bit */
    byte OSCE        :1;                                       /* Oscillator Enable Bit */
  } Bits;
  struct {
    byte grpOSCFILT :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CPMUOSCSTR;
extern volatile CPMUOSCSTR _CPMUOSC @(REG_BASE + 0x000001FAUL);
#define CPMUOSC                         _CPMUOSC.Byte
#define CPMUOSC_OSCFILT0                _CPMUOSC.Bits.OSCFILT0
#define CPMUOSC_OSCFILT1                _CPMUOSC.Bits.OSCFILT1
#define CPMUOSC_OSCFILT2                _CPMUOSC.Bits.OSCFILT2
#define CPMUOSC_OSCFILT3                _CPMUOSC.Bits.OSCFILT3
#define CPMUOSC_OSCFILT4                _CPMUOSC.Bits.OSCFILT4
#define CPMUOSC_OSCPINS_EN              _CPMUOSC.Bits.OSCPINS_EN
#define CPMUOSC_OSCBW                   _CPMUOSC.Bits.OSCBW
#define CPMUOSC_OSCE                    _CPMUOSC.Bits.OSCE
#define CPMUOSC_OSCFILT                 _CPMUOSC.MergedBits.grpOSCFILT

#define CPMUOSC_OSCFILT0_MASK           1U
#define CPMUOSC_OSCFILT1_MASK           2U
#define CPMUOSC_OSCFILT2_MASK           4U
#define CPMUOSC_OSCFILT3_MASK           8U
#define CPMUOSC_OSCFILT4_MASK           16U
#define CPMUOSC_OSCPINS_EN_MASK         32U
#define CPMUOSC_OSCBW_MASK              64U
#define CPMUOSC_OSCE_MASK               128U
#define CPMUOSC_OSCFILT_MASK            31U
#define CPMUOSC_OSCFILT_BITNUM          0U


/*** CPMUPROT - S12CPMUV1 Protection Register; 0x000001FB ***/
typedef union {
  byte Byte;
  struct {
    byte PROT        :1;                                       /* Clock Configuration Registers Protection Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CPMUPROTSTR;
extern volatile CPMUPROTSTR _CPMUPROT @(REG_BASE + 0x000001FBUL);
#define CPMUPROT                        _CPMUPROT.Byte
#define CPMUPROT_PROT                   _CPMUPROT.Bits.PROT

#define CPMUPROT_PROT_MASK              1U


/*** B_ISR - Interrupt Source Register; 0x00000200 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ISRhi - Interrupt Source Register High; 0x00000200 ***/
    union {
      byte Byte;
      struct {
        byte RX          :1;                                       /* SCI Receive Interrupt */
        byte SCI         :1;                                       /* ADC Sequence Complete Interrupt */
        byte LINOT       :1;                                       /* LIN Driver Over-temperature Interrupt */
        byte HSOT        :1;                                       /* High Side Over-temperature Interrupt */
        byte LSOT        :1;                                       /* Low Side Over-temperature Interrupt */
        byte HOT         :1;                                       /* HSUP Over-temperature Interrupt */
        byte             :1; 
        byte             :1; 
      } Bits;
    } B_ISRhiSTR;
    #define B_ISRhi                     _B_ISR.Overlap_STR.B_ISRhiSTR.Byte
    #define B_ISRhi_RX                  _B_ISR.Overlap_STR.B_ISRhiSTR.Bits.RX
    #define B_ISRhi_SCI                 _B_ISR.Overlap_STR.B_ISRhiSTR.Bits.SCI
    #define B_ISRhi_LINOT               _B_ISR.Overlap_STR.B_ISRhiSTR.Bits.LINOT
    #define B_ISRhi_HSOT                _B_ISR.Overlap_STR.B_ISRhiSTR.Bits.HSOT
    #define B_ISRhi_LSOT                _B_ISR.Overlap_STR.B_ISRhiSTR.Bits.LSOT
    #define B_ISRhi_HOT                 _B_ISR.Overlap_STR.B_ISRhiSTR.Bits.HOT
    
    #define B_ISRhi_RX_MASK             1U
    #define B_ISRhi_SCI_MASK            2U
    #define B_ISRhi_LINOT_MASK          4U
    #define B_ISRhi_HSOT_MASK           8U
    #define B_ISRhi_LSOT_MASK           16U
    #define B_ISRhi_HOT_MASK            32U
    

    /*** B_ISRlo - Interrupt Source Register Low; 0x00000201 ***/
    union {
      byte Byte;
      struct {
        byte VSI         :1;                                       /* Voltage Status Interrupt */
        byte CH0         :1;                                       /* TIM Channel 0 Interrupt */
        byte CH1         :1;                                       /* TIM Channel 1 Interrupt */
        byte CH2         :1;                                       /* TIM Channel 2 Interrupt */
        byte CH3         :1;                                       /* TIM Channel 3 Interrupt */
        byte TOV         :1;                                       /* Timer Overflow Interrupt */
        byte ERR         :1;                                       /* SCI Error Interrupt */
        byte TX          :1;                                       /* SCI Transmit Interrupt */
      } Bits;
      struct {
        byte     :1;
        byte grpCH :4;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } B_ISRloSTR;
    #define B_ISRlo                     _B_ISR.Overlap_STR.B_ISRloSTR.Byte
    #define B_ISRlo_VSI                 _B_ISR.Overlap_STR.B_ISRloSTR.Bits.VSI
    #define B_ISRlo_CH0                 _B_ISR.Overlap_STR.B_ISRloSTR.Bits.CH0
    #define B_ISRlo_CH1                 _B_ISR.Overlap_STR.B_ISRloSTR.Bits.CH1
    #define B_ISRlo_CH2                 _B_ISR.Overlap_STR.B_ISRloSTR.Bits.CH2
    #define B_ISRlo_CH3                 _B_ISR.Overlap_STR.B_ISRloSTR.Bits.CH3
    #define B_ISRlo_TOV                 _B_ISR.Overlap_STR.B_ISRloSTR.Bits.TOV
    #define B_ISRlo_ERR                 _B_ISR.Overlap_STR.B_ISRloSTR.Bits.ERR
    #define B_ISRlo_TX                  _B_ISR.Overlap_STR.B_ISRloSTR.Bits.TX
    #define B_ISRlo_CH                  _B_ISR.Overlap_STR.B_ISRloSTR.MergedBits.grpCH
    
    #define B_ISRlo_VSI_MASK            1U
    #define B_ISRlo_CH0_MASK            2U
    #define B_ISRlo_CH1_MASK            4U
    #define B_ISRlo_CH2_MASK            8U
    #define B_ISRlo_CH3_MASK            16U
    #define B_ISRlo_TOV_MASK            32U
    #define B_ISRlo_ERR_MASK            64U
    #define B_ISRlo_TX_MASK             128U
    #define B_ISRlo_CH_MASK             30U
    #define B_ISRlo_CH_BITNUM           1U
    
  } Overlap_STR;

  struct {
    word VSI         :1;                                       /* Voltage Status Interrupt */
    word CH0         :1;                                       /* TIM Channel 0 Interrupt */
    word CH1         :1;                                       /* TIM Channel 1 Interrupt */
    word CH2         :1;                                       /* TIM Channel 2 Interrupt */
    word CH3         :1;                                       /* TIM Channel 3 Interrupt */
    word TOV         :1;                                       /* Timer Overflow Interrupt */
    word ERR         :1;                                       /* SCI Error Interrupt */
    word TX          :1;                                       /* SCI Transmit Interrupt */
    word RX          :1;                                       /* SCI Receive Interrupt */
    word SCI         :1;                                       /* ADC Sequence Complete Interrupt */
    word LINOT       :1;                                       /* LIN Driver Over-temperature Interrupt */
    word HSOT        :1;                                       /* High Side Over-temperature Interrupt */
    word LSOT        :1;                                       /* Low Side Over-temperature Interrupt */
    word HOT         :1;                                       /* HSUP Over-temperature Interrupt */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word         :1;
    word grpCH   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} B_ISRSTR;
extern volatile B_ISRSTR _B_ISR @(REG_BASE + 0x00000200UL);
#define B_ISR                           _B_ISR.Word
#define B_ISR_VSI                       _B_ISR.Bits.VSI
#define B_ISR_CH0                       _B_ISR.Bits.CH0
#define B_ISR_CH1                       _B_ISR.Bits.CH1
#define B_ISR_CH2                       _B_ISR.Bits.CH2
#define B_ISR_CH3                       _B_ISR.Bits.CH3
#define B_ISR_TOV                       _B_ISR.Bits.TOV
#define B_ISR_ERR                       _B_ISR.Bits.ERR
#define B_ISR_TX                        _B_ISR.Bits.TX
#define B_ISR_RX                        _B_ISR.Bits.RX
#define B_ISR_SCI                       _B_ISR.Bits.SCI
#define B_ISR_LINOT                     _B_ISR.Bits.LINOT
#define B_ISR_HSOT                      _B_ISR.Bits.HSOT
#define B_ISR_LSOT                      _B_ISR.Bits.LSOT
#define B_ISR_HOT                       _B_ISR.Bits.HOT
#define B_ISR_CH                        _B_ISR.MergedBits.grpCH

#define B_ISR_VSI_MASK                  1U
#define B_ISR_CH0_MASK                  2U
#define B_ISR_CH1_MASK                  4U
#define B_ISR_CH2_MASK                  8U
#define B_ISR_CH3_MASK                  16U
#define B_ISR_TOV_MASK                  32U
#define B_ISR_ERR_MASK                  64U
#define B_ISR_TX_MASK                   128U
#define B_ISR_RX_MASK                   256U
#define B_ISR_SCI_MASK                  512U
#define B_ISR_LINOT_MASK                1024U
#define B_ISR_HSOT_MASK                 2048U
#define B_ISR_LSOT_MASK                 4096U
#define B_ISR_HOT_MASK                  8192U
#define B_ISR_CH_MASK                   30U
#define B_ISR_CH_BITNUM                 1U


/*** B_IVR - Interrupt Vector Register; 0x00000202 ***/
typedef union {
  byte Byte;
  struct {
    byte IRQ         :6;                                       /* Represents the highest prioritized interrupt pending */
    byte             :1; 
    byte             :1; 
  } Bits;
} B_IVRSTR;
extern volatile B_IVRSTR _B_IVR @(REG_BASE + 0x00000202UL);
#define B_IVR                           _B_IVR.Byte
#define B_IVR_IRQ                       _B_IVR.Bits.IRQ

#define B_IVR_IRQ_MASK                  63U
#define B_IVR_IRQ_BITNUM                0U


/*** B_VCR - Voltage Control Register; 0x00000204 ***/
typedef union {
  byte Byte;
  struct {
    byte LBIE        :1;                                       /* Low Battery Interrupt Enable */
    byte LVIE        :1;                                       /* Low Voltage Interrupt Enable */
    byte HVIE        :1;                                       /* High Voltage Interrupt Enable */
    byte HTIE        :1;                                       /* High Temperature Interrupt Enable */
    byte VROVIE      :1;                                       /* Voltage Regulator Over-voltage Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_VCRSTR;
extern volatile B_VCRSTR _B_VCR @(REG_BASE + 0x00000204UL);
#define B_VCR                           _B_VCR.Byte
#define B_VCR_LBIE                      _B_VCR.Bits.LBIE
#define B_VCR_LVIE                      _B_VCR.Bits.LVIE
#define B_VCR_HVIE                      _B_VCR.Bits.HVIE
#define B_VCR_HTIE                      _B_VCR.Bits.HTIE
#define B_VCR_VROVIE                    _B_VCR.Bits.VROVIE

#define B_VCR_LBIE_MASK                 1U
#define B_VCR_LVIE_MASK                 2U
#define B_VCR_HVIE_MASK                 4U
#define B_VCR_HTIE_MASK                 8U
#define B_VCR_VROVIE_MASK               16U


/*** B_VSR - Voltage Status Register; 0x00000205 ***/
typedef union {
  byte Byte;
  struct {
    byte LBC         :1;                                       /* Low Battery Condition */
    byte LVC         :1;                                       /* Low Voltage Condition */
    byte HVC         :1;                                       /* High Voltage Condition */
    byte HTC         :1;                                       /* High Temperature Condition */
    byte VROVC       :1;                                       /* Voltage Regulator Over-voltage Condition */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_VSRSTR;
extern volatile B_VSRSTR _B_VSR @(REG_BASE + 0x00000205UL);
#define B_VSR                           _B_VSR.Byte
#define B_VSR_LBC                       _B_VSR.Bits.LBC
#define B_VSR_LVC                       _B_VSR.Bits.LVC
#define B_VSR_HVC                       _B_VSR.Bits.HVC
#define B_VSR_HTC                       _B_VSR.Bits.HTC
#define B_VSR_VROVC                     _B_VSR.Bits.VROVC

#define B_VSR_LBC_MASK                  1U
#define B_VSR_LVC_MASK                  2U
#define B_VSR_HVC_MASK                  4U
#define B_VSR_HTC_MASK                  8U
#define B_VSR_VROVC_MASK                16U


/*** B_LXR - Lx Status Register; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte L0          :1;                                       /* Current Digital State of the L0 Input */
    byte L1          :1;                                       /* Current Digital State of the L1 Input */
    byte L2          :1;                                       /* Current Digital State of the L2 Input */
    byte L3          :1;                                       /* Current Digital State of the L3 Input */
    byte L4          :1;                                       /* Current Digital State of the L4 Input */
    byte L5          :1;                                       /* Current Digital State of the L5 Input */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpL    :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_LXRSTR;
extern volatile B_LXRSTR _B_LXR @(REG_BASE + 0x00000208UL);
#define B_LXR                           _B_LXR.Byte
#define B_LXR_L0                        _B_LXR.Bits.L0
#define B_LXR_L1                        _B_LXR.Bits.L1
#define B_LXR_L2                        _B_LXR.Bits.L2
#define B_LXR_L3                        _B_LXR.Bits.L3
#define B_LXR_L4                        _B_LXR.Bits.L4
#define B_LXR_L5                        _B_LXR.Bits.L5
#define B_LXR_L                         _B_LXR.MergedBits.grpL

#define B_LXR_L0_MASK                   1U
#define B_LXR_L1_MASK                   2U
#define B_LXR_L2_MASK                   4U
#define B_LXR_L3_MASK                   8U
#define B_LXR_L4_MASK                   16U
#define B_LXR_L5_MASK                   32U
#define B_LXR_L_MASK                    63U
#define B_LXR_L_BITNUM                  0U


/*** B_LXCR - Lx Control Register; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte L0DS        :1;                                       /* Analog Input Divider Ratio Selection - L0 */
    byte L1DS        :1;                                       /* Analog Input Divider Ratio Selection - L1 */
    byte L2DS        :1;                                       /* Analog Input Divider Ratio Selection - L2 */
    byte L3DS        :1;                                       /* Analog Input Divider Ratio Selection - L3 */
    byte L4DS        :1;                                       /* Analog Input Divider Ratio Selection - L4 */
    byte L5DS        :1;                                       /* Analog Input Divider Ratio Selection - L5 */
    byte             :1; 
    byte             :1; 
  } Bits;
} B_LXCRSTR;
extern volatile B_LXCRSTR _B_LXCR @(REG_BASE + 0x00000209UL);
#define B_LXCR                          _B_LXCR.Byte
#define B_LXCR_L0DS                     _B_LXCR.Bits.L0DS
#define B_LXCR_L1DS                     _B_LXCR.Bits.L1DS
#define B_LXCR_L2DS                     _B_LXCR.Bits.L2DS
#define B_LXCR_L3DS                     _B_LXCR.Bits.L3DS
#define B_LXCR_L4DS                     _B_LXCR.Bits.L4DS
#define B_LXCR_L5DS                     _B_LXCR.Bits.L5DS

#define B_LXCR_L0DS_MASK                1U
#define B_LXCR_L1DS_MASK                2U
#define B_LXCR_L2DS_MASK                4U
#define B_LXCR_L3DS_MASK                8U
#define B_LXCR_L4DS_MASK                16U
#define B_LXCR_L5DS_MASK                32U


/*** B_WDR - Watchdog Register; 0x00000210 ***/
typedef union {
  byte Byte;
  struct {
    byte WDTO        :3;                                       /* Watchdog Timeout Configuration Bit 0 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte WDWO        :1;                                       /* Watchdog Window Open */
    byte WDOFF       :1;                                       /* Watchdog Off */
  } Bits;
} B_WDRSTR;
extern volatile B_WDRSTR _B_WDR @(REG_BASE + 0x00000210UL);
#define B_WDR                           _B_WDR.Byte
#define B_WDR_WDTO                      _B_WDR.Bits.WDTO
#define B_WDR_WDWO                      _B_WDR.Bits.WDWO
#define B_WDR_WDOFF                     _B_WDR.Bits.WDOFF

#define B_WDR_WDTO_MASK                 7U
#define B_WDR_WDTO_BITNUM               0U
#define B_WDR_WDWO_MASK                 64U
#define B_WDR_WDOFF_MASK                128U


/*** B_WDSR - Watchdog Service Register; 0x00000211 ***/
typedef union {
  byte Byte;
} B_WDSRSTR;
extern volatile B_WDSRSTR _B_WDSR @(REG_BASE + 0x00000211UL);
#define B_WDSR                          _B_WDSR.Byte


/*** B_WCR - Wake-up Control Register; 0x00000212 ***/
typedef union {
  byte Byte;
  struct {
    byte L0WE        :1;                                       /* Wake-up Input 0 Enabled */
    byte L1WE        :1;                                       /* Wake-up Input 1 Enabled */
    byte L2WE        :1;                                       /* Wake-up Input 2 Enabled */
    byte L3WE        :1;                                       /* Wake-up Input 3 Enabled */
    byte L4WE        :1;                                       /* Wake-up Input 4 Enabled */
    byte L5WE        :1;                                       /* Wake-up Input 5 Enabled */
    byte CSSEL       :2;                                       /* Cyclic Sense Select Bit 0 */
  } Bits;
} B_WCRSTR;
extern volatile B_WCRSTR _B_WCR @(REG_BASE + 0x00000212UL);
#define B_WCR                           _B_WCR.Byte
#define B_WCR_L0WE                      _B_WCR.Bits.L0WE
#define B_WCR_L1WE                      _B_WCR.Bits.L1WE
#define B_WCR_L2WE                      _B_WCR.Bits.L2WE
#define B_WCR_L3WE                      _B_WCR.Bits.L3WE
#define B_WCR_L4WE                      _B_WCR.Bits.L4WE
#define B_WCR_L5WE                      _B_WCR.Bits.L5WE
#define B_WCR_CSSEL                     _B_WCR.Bits.CSSEL

#define B_WCR_L0WE_MASK                 1U
#define B_WCR_L1WE_MASK                 2U
#define B_WCR_L2WE_MASK                 4U
#define B_WCR_L3WE_MASK                 8U
#define B_WCR_L4WE_MASK                 16U
#define B_WCR_L5WE_MASK                 32U
#define B_WCR_CSSEL_MASK                192U
#define B_WCR_CSSEL_BITNUM              6U


/*** B_TCR - Timing Control Register; 0x00000213 ***/
typedef union {
  byte Byte;
  struct {
    byte CST         :4;                                       /* Cyclic Sense Timing Bit 0 */
    byte FWM         :4;                                       /* Forced Wake-up Multiplicator Bit 0 */
  } Bits;
} B_TCRSTR;
extern volatile B_TCRSTR _B_TCR @(REG_BASE + 0x00000213UL);
#define B_TCR                           _B_TCR.Byte
#define B_TCR_CST                       _B_TCR.Bits.CST
#define B_TCR_FWM                       _B_TCR.Bits.FWM

#define B_TCR_CST_MASK                  15U
#define B_TCR_CST_BITNUM                0U
#define B_TCR_FWM_MASK                  240U
#define B_TCR_FWM_BITNUM                4U


/*** B_WSR - Wake-up Source Register; 0x00000214 ***/
typedef union {
  byte Byte;
  struct {
    byte L0WU        :1;                                       /* L0 Wake-upe-up */
    byte L1WU        :1;                                       /* L1 Wake-upp */
    byte L2WU        :1;                                       /* L2 Wake-up */
    byte L3WU        :1;                                       /* L3 Wake-up */
    byte L4WU        :1;                                       /* L4 Wake-up */
    byte L5WU        :1;                                       /* L5 Wake-up */
    byte LINWU       :1;                                       /* LIN Wake-up */
    byte FWU         :1;                                       /* Forced Wake-up */
  } Bits;
} B_WSRSTR;
extern volatile B_WSRSTR _B_WSR @(REG_BASE + 0x00000214UL);
#define B_WSR                           _B_WSR.Byte
#define B_WSR_L0WU                      _B_WSR.Bits.L0WU
#define B_WSR_L1WU                      _B_WSR.Bits.L1WU
#define B_WSR_L2WU                      _B_WSR.Bits.L2WU
#define B_WSR_L3WU                      _B_WSR.Bits.L3WU
#define B_WSR_L4WU                      _B_WSR.Bits.L4WU
#define B_WSR_L5WU                      _B_WSR.Bits.L5WU
#define B_WSR_LINWU                     _B_WSR.Bits.LINWU
#define B_WSR_FWU                       _B_WSR.Bits.FWU

#define B_WSR_L0WU_MASK                 1U
#define B_WSR_L1WU_MASK                 2U
#define B_WSR_L2WU_MASK                 4U
#define B_WSR_L3WU_MASK                 8U
#define B_WSR_L4WU_MASK                 16U
#define B_WSR_L5WU_MASK                 32U
#define B_WSR_LINWU_MASK                64U
#define B_WSR_FWU_MASK                  128U


/*** B_RSR - Reset Status Register; 0x00000215 ***/
typedef union {
  byte Byte;
  struct {
    byte POR         :1;                                       /* Power On Reset */
    byte LVR         :1;                                       /* Low Voltage Reset VDD */
    byte LVRX        :1;                                       /* Low Voltage Reset VDDX */
    byte WUR         :1;                                       /* Wake-up Reset */
    byte EXR         :1;                                       /* External Reset */
    byte WDR         :1;                                       /* Watchdog Reset */
    byte             :1; 
    byte             :1; 
  } Bits;
} B_RSRSTR;
extern volatile B_RSRSTR _B_RSR @(REG_BASE + 0x00000215UL);
#define B_RSR                           _B_RSR.Byte
#define B_RSR_POR                       _B_RSR.Bits.POR
#define B_RSR_LVR                       _B_RSR.Bits.LVR
#define B_RSR_LVRX                      _B_RSR.Bits.LVRX
#define B_RSR_WUR                       _B_RSR.Bits.WUR
#define B_RSR_EXR                       _B_RSR.Bits.EXR
#define B_RSR_WDR                       _B_RSR.Bits.WDR

#define B_RSR_POR_MASK                  1U
#define B_RSR_LVR_MASK                  2U
#define B_RSR_LVRX_MASK                 4U
#define B_RSR_WUR_MASK                  8U
#define B_RSR_EXR_MASK                  16U
#define B_RSR_WDR_MASK                  32U


/*** B_MCR - Mode Control Register; 0x00000216 ***/
typedef union {
  byte Byte;
  struct {
    byte MODE_grp    :2;                                       /* Mode Select bit 0 */ /*Warning: group name is duplicated with register name*/
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_MCRSTR;
extern volatile B_MCRSTR _B_MCR @(REG_BASE + 0x00000216UL);
#define B_MCR                           _B_MCR.Byte
#define B_MCR_MODE                      _B_MCR.Bits.MODE_grp

#define B_MCR_MODE_MASK                 3U
#define B_MCR_MODE_BITNUM               0U


/*** B_LINR - LIN Register; 0x00000218 ***/
typedef union {
  byte Byte;
  struct {
    byte LINSR       :2;                                       /* LIN - Slew Rate Select 0 */
    byte LINEN       :1;                                       /* LIN Module Enable */
    byte LVSD        :1;                                       /* LIN - Low Voltage Shutdown Disable (J2602 Compliance Control) */
    byte TX          :1;                                       /* LIN - Direct Transmitter Control */
    byte RX          :1;                                       /* LIN - Receiver (Rx) Status */
    byte LINOTC      :1;                                       /* LIN - Over-temperature condition present */
    byte LINOTIE     :1;                                       /* LIN - Over-temperature Interrupt Enable */
  } Bits;
} B_LINRSTR;
extern volatile B_LINRSTR _B_LINR @(REG_BASE + 0x00000218UL);
#define B_LINR                          _B_LINR.Byte
#define B_LINR_LINSR                    _B_LINR.Bits.LINSR
#define B_LINR_LINEN                    _B_LINR.Bits.LINEN
#define B_LINR_LVSD                     _B_LINR.Bits.LVSD
#define B_LINR_TX                       _B_LINR.Bits.TX
#define B_LINR_RX                       _B_LINR.Bits.RX
#define B_LINR_LINOTC                   _B_LINR.Bits.LINOTC
#define B_LINR_LINOTIE                  _B_LINR.Bits.LINOTIE

#define B_LINR_LINSR_MASK               3U
#define B_LINR_LINSR_BITNUM             0U
#define B_LINR_LINEN_MASK               4U
#define B_LINR_LVSD_MASK                8U
#define B_LINR_TX_MASK                  16U
#define B_LINR_RX_MASK                  32U
#define B_LINR_LINOTC_MASK              64U
#define B_LINR_LINOTIE_MASK             128U


/*** B_PTBC1 - Port B Configuration Register 1; 0x00000220 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRB0       :1;                                       /* Data Direction Port B 0 */
    byte DDRB1       :1;                                       /* Data Direction Port B 0 */
    byte DDRB2       :1;                                       /* Data Direction Port B 0 */
    byte             :1; 
    byte PUEB0       :1;                                       /* Pull-up Enable Port B 0 */
    byte PUEB1       :1;                                       /* Pull-up Enable Port B 0 */
    byte PUEB2       :1;                                       /* Pull-up Enable Port B 0 */
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRB :3;
    byte         :1;
    byte grpPUEB :3;
    byte         :1;
  } MergedBits;
} B_PTBC1STR;
extern volatile B_PTBC1STR _B_PTBC1 @(REG_BASE + 0x00000220UL);
#define B_PTBC1                         _B_PTBC1.Byte
#define B_PTBC1_DDRB0                   _B_PTBC1.Bits.DDRB0
#define B_PTBC1_DDRB1                   _B_PTBC1.Bits.DDRB1
#define B_PTBC1_DDRB2                   _B_PTBC1.Bits.DDRB2
#define B_PTBC1_PUEB0                   _B_PTBC1.Bits.PUEB0
#define B_PTBC1_PUEB1                   _B_PTBC1.Bits.PUEB1
#define B_PTBC1_PUEB2                   _B_PTBC1.Bits.PUEB2
#define B_PTBC1_DDRB                    _B_PTBC1.MergedBits.grpDDRB
#define B_PTBC1_PUEB                    _B_PTBC1.MergedBits.grpPUEB

#define B_PTBC1_DDRB0_MASK              1U
#define B_PTBC1_DDRB1_MASK              2U
#define B_PTBC1_DDRB2_MASK              4U
#define B_PTBC1_PUEB0_MASK              16U
#define B_PTBC1_PUEB1_MASK              32U
#define B_PTBC1_PUEB2_MASK              64U
#define B_PTBC1_DDRB_MASK               7U
#define B_PTBC1_DDRB_BITNUM             0U
#define B_PTBC1_PUEB_MASK               112U
#define B_PTBC1_PUEB_BITNUM             4U


/*** B_PTBC2 - Port B Configuration Register 2; 0x00000221 ***/
typedef union {
  byte Byte;
  struct {
    byte SERMOD      :2;                                       /* Serial Mode Select for PTB 0 */
    byte PWMEN       :1;                                       /* PWM Enable for PTB2 */
    byte PWMCS       :1;                                       /* PWM Channel Select PTB2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_PTBC2STR;
extern volatile B_PTBC2STR _B_PTBC2 @(REG_BASE + 0x00000221UL);
#define B_PTBC2                         _B_PTBC2.Byte
#define B_PTBC2_SERMOD                  _B_PTBC2.Bits.SERMOD
#define B_PTBC2_PWMEN                   _B_PTBC2.Bits.PWMEN
#define B_PTBC2_PWMCS                   _B_PTBC2.Bits.PWMCS

#define B_PTBC2_SERMOD_MASK             3U
#define B_PTBC2_SERMOD_BITNUM           0U
#define B_PTBC2_PWMEN_MASK              4U
#define B_PTBC2_PWMCS_MASK              8U


/*** B_PTB - Port B Data Register; 0x00000222 ***/
typedef union {
  byte Byte;
  struct {
    byte PTB0        :1;                                       /* Port B general purpose input/output data 0 */
    byte PTB1        :1;                                       /* Port B general purpose input/output data 1 */
    byte PTB2        :1;                                       /* Port B general purpose input/output data 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTB  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_PTBSTR;
extern volatile B_PTBSTR _B_PTB @(REG_BASE + 0x00000222UL);
#define B_PTB                           _B_PTB.Byte
#define B_PTB_PTB0                      _B_PTB.Bits.PTB0
#define B_PTB_PTB1                      _B_PTB.Bits.PTB1
#define B_PTB_PTB2                      _B_PTB.Bits.PTB2
#define B_PTB_PTB                       _B_PTB.MergedBits.grpPTB

#define B_PTB_PTB0_MASK                 1U
#define B_PTB_PTB1_MASK                 2U
#define B_PTB_PTB2_MASK                 4U
#define B_PTB_PTB_MASK                  7U
#define B_PTB_PTB_BITNUM                0U


/*** B_HSCR - High Side Control Register; 0x00000228 ***/
typedef union {
  byte Byte;
  struct {
    byte HS1         :1;                                       /* HS2 Control */
    byte HS2         :1;                                       /* HS2 Control */
    byte PWMHS1      :1;                                       /* PWM Enable for HS1 */
    byte PWMHS2      :1;                                       /* PWM Enable for HS2 */
    byte PWMCS1      :1;                                       /* PWM Channel Select HS1 */
    byte PWMCS2      :1;                                       /* PWM Channel Select HS2 */
    byte HSHVSDE     :1;                                       /* High Side High Voltage Shutdown */
    byte HSOTIE      :1;                                       /* High Side Over-temperature Interrupt Enable */
  } Bits;
  struct {
    byte grpHS_1 :2;
    byte grpPWMHS_1 :2;
    byte grpPWMCS_1 :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_HSCRSTR;
extern volatile B_HSCRSTR _B_HSCR @(REG_BASE + 0x00000228UL);
#define B_HSCR                          _B_HSCR.Byte
#define B_HSCR_HS1                      _B_HSCR.Bits.HS1
#define B_HSCR_HS2                      _B_HSCR.Bits.HS2
#define B_HSCR_PWMHS1                   _B_HSCR.Bits.PWMHS1
#define B_HSCR_PWMHS2                   _B_HSCR.Bits.PWMHS2
#define B_HSCR_PWMCS1                   _B_HSCR.Bits.PWMCS1
#define B_HSCR_PWMCS2                   _B_HSCR.Bits.PWMCS2
#define B_HSCR_HSHVSDE                  _B_HSCR.Bits.HSHVSDE
#define B_HSCR_HSOTIE                   _B_HSCR.Bits.HSOTIE
#define B_HSCR_HS_1                     _B_HSCR.MergedBits.grpHS_1
#define B_HSCR_PWMHS_1                  _B_HSCR.MergedBits.grpPWMHS_1
#define B_HSCR_PWMCS_1                  _B_HSCR.MergedBits.grpPWMCS_1
#define B_HSCR_HS                       B_HSCR_HS_1
#define B_HSCR_PWMHS                    B_HSCR_PWMHS_1
#define B_HSCR_PWMCS                    B_HSCR_PWMCS_1

#define B_HSCR_HS1_MASK                 1U
#define B_HSCR_HS2_MASK                 2U
#define B_HSCR_PWMHS1_MASK              4U
#define B_HSCR_PWMHS2_MASK              8U
#define B_HSCR_PWMCS1_MASK              16U
#define B_HSCR_PWMCS2_MASK              32U
#define B_HSCR_HSHVSDE_MASK             64U
#define B_HSCR_HSOTIE_MASK              128U
#define B_HSCR_HS_1_MASK                3U
#define B_HSCR_HS_1_BITNUM              0U
#define B_HSCR_PWMHS_1_MASK             12U
#define B_HSCR_PWMHS_1_BITNUM           2U
#define B_HSCR_PWMCS_1_MASK             48U
#define B_HSCR_PWMCS_1_BITNUM           4U


/*** B_HSSR - High Side Status Register; 0x00000229 ***/
typedef union {
  byte Byte;
  struct {
    byte HS1OL       :1;                                       /* High Side 1Open Load */
    byte HS2OL       :1;                                       /* High Side 2 Open Load */
    byte HS1CL       :1;                                       /* High Side 1 Current Limitation */
    byte HS2CL       :1;                                       /* High Side 2 Current Limitation */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte HSOTC       :1;                                       /* High Side Over-temperature Condition */
  } Bits;
} B_HSSRSTR;
extern volatile B_HSSRSTR _B_HSSR @(REG_BASE + 0x00000229UL);
#define B_HSSR                          _B_HSSR.Byte
#define B_HSSR_HS1OL                    _B_HSSR.Bits.HS1OL
#define B_HSSR_HS2OL                    _B_HSSR.Bits.HS2OL
#define B_HSSR_HS1CL                    _B_HSSR.Bits.HS1CL
#define B_HSSR_HS2CL                    _B_HSSR.Bits.HS2CL
#define B_HSSR_HSOTC                    _B_HSSR.Bits.HSOTC

#define B_HSSR_HS1OL_MASK               1U
#define B_HSSR_HS2OL_MASK               2U
#define B_HSSR_HS1CL_MASK               4U
#define B_HSSR_HS2CL_MASK               8U
#define B_HSSR_HSOTC_MASK               128U


/*** B_LSCR - Low Side Control Register; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte LS1         :1;                                       /* LS1 Enable */
    byte LS2         :1;                                       /* LS2 Enable */
    byte PWMLS1      :1;                                       /* PWM Enable for LS1 */
    byte PWMLS2      :1;                                       /* PWM Enable for LS2 */
    byte PWMCS1      :1;                                       /* PWM Channel Select LS1 */
    byte PWMCS2      :1;                                       /* PWM Channel Select LS2 */
    byte             :1; 
    byte LSOTIE      :1;                                       /* Low Side Over-temperature Interrupt Enable */
  } Bits;
  struct {
    byte grpLS_1 :2;
    byte grpPWMLS_1 :2;
    byte grpPWMCS_1 :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_LSCRSTR;
extern volatile B_LSCRSTR _B_LSCR @(REG_BASE + 0x00000230UL);
#define B_LSCR                          _B_LSCR.Byte
#define B_LSCR_LS1                      _B_LSCR.Bits.LS1
#define B_LSCR_LS2                      _B_LSCR.Bits.LS2
#define B_LSCR_PWMLS1                   _B_LSCR.Bits.PWMLS1
#define B_LSCR_PWMLS2                   _B_LSCR.Bits.PWMLS2
#define B_LSCR_PWMCS1                   _B_LSCR.Bits.PWMCS1
#define B_LSCR_PWMCS2                   _B_LSCR.Bits.PWMCS2
#define B_LSCR_LSOTIE                   _B_LSCR.Bits.LSOTIE
#define B_LSCR_LS_1                     _B_LSCR.MergedBits.grpLS_1
#define B_LSCR_PWMLS_1                  _B_LSCR.MergedBits.grpPWMLS_1
#define B_LSCR_PWMCS_1                  _B_LSCR.MergedBits.grpPWMCS_1
#define B_LSCR_LS                       B_LSCR_LS_1
#define B_LSCR_PWMLS                    B_LSCR_PWMLS_1
#define B_LSCR_PWMCS                    B_LSCR_PWMCS_1

#define B_LSCR_LS1_MASK                 1U
#define B_LSCR_LS2_MASK                 2U
#define B_LSCR_PWMLS1_MASK              4U
#define B_LSCR_PWMLS2_MASK              8U
#define B_LSCR_PWMCS1_MASK              16U
#define B_LSCR_PWMCS2_MASK              32U
#define B_LSCR_LSOTIE_MASK              128U
#define B_LSCR_LS_1_MASK                3U
#define B_LSCR_LS_1_BITNUM              0U
#define B_LSCR_PWMLS_1_MASK             12U
#define B_LSCR_PWMLS_1_BITNUM           2U
#define B_LSCR_PWMCS_1_MASK             48U
#define B_LSCR_PWMCS_1_BITNUM           4U


/*** B_LSSR - Low Side Status Register; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte LS1OL       :1;                                       /* Low Side 1 Open Load */
    byte LS2OL       :1;                                       /* Low Side 2 Open Load */
    byte LS1CL       :1;                                       /* Low Side 1 Current Limitation */
    byte LS2CL       :1;                                       /* Low Side 2 Current Limitation */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LSOTC       :1;                                       /* Low Side Over-temperature condition present */
  } Bits;
} B_LSSRSTR;
extern volatile B_LSSRSTR _B_LSSR @(REG_BASE + 0x00000231UL);
#define B_LSSR                          _B_LSSR.Byte
#define B_LSSR_LS1OL                    _B_LSSR.Bits.LS1OL
#define B_LSSR_LS2OL                    _B_LSSR.Bits.LS2OL
#define B_LSSR_LS1CL                    _B_LSSR.Bits.LS1CL
#define B_LSSR_LS2CL                    _B_LSSR.Bits.LS2CL
#define B_LSSR_LSOTC                    _B_LSSR.Bits.LSOTC

#define B_LSSR_LS1OL_MASK               1U
#define B_LSSR_LS2OL_MASK               2U
#define B_LSSR_LS1CL_MASK               4U
#define B_LSSR_LS2CL_MASK               8U
#define B_LSSR_LSOTC_MASK               128U


/*** B_LSCEN - Low Side Control Enable Register; 0x00000232 ***/
typedef union {
  byte Byte;
  struct {
    byte LSCEN       :4;                                       /* Low Side Control Enable Bit 0 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_LSCENSTR;
extern volatile B_LSCENSTR _B_LSCEN @(REG_BASE + 0x00000232UL);
#define B_LSCEN                         _B_LSCEN.Byte
#define B_LSCEN_LSCEN                   _B_LSCEN.Bits.LSCEN

#define B_LSCEN_LSCEN_MASK              15U
#define B_LSCEN_LSCEN_BITNUM            0U


/*** B_HSR - Hall Supply Register; 0x00000238 ***/
typedef union {
  byte Byte;
  struct {
    byte HSUPON      :1;                                       /* Hall Supply On */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte HOTC        :1;                                       /* Hall Supply Over-temperature Condition */
    byte HOTIE       :1;                                       /* Hall Supply Over-temperature Interrupt Enable */
  } Bits;
} B_HSRSTR;
extern volatile B_HSRSTR _B_HSR @(REG_BASE + 0x00000238UL);
#define B_HSR                           _B_HSR.Byte
#define B_HSR_HSUPON                    _B_HSR.Bits.HSUPON
#define B_HSR_HOTC                      _B_HSR.Bits.HOTC
#define B_HSR_HOTIE                     _B_HSR.Bits.HOTIE

#define B_HSR_HSUPON_MASK               1U
#define B_HSR_HOTC_MASK                 64U
#define B_HSR_HOTIE_MASK                128U


/*** B_CSR - Current Sense Register; 0x0000023C ***/
typedef union {
  byte Byte;
  struct {
    byte CSGS        :3;                                       /* Current Sense Gain Select 0 */
    byte CCD         :1;                                       /* Input Filter Charge Compensation Disable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte CSE         :1;                                       /* Current Sense Enable Bit */
  } Bits;
} B_CSRSTR;
extern volatile B_CSRSTR _B_CSR @(REG_BASE + 0x0000023CUL);
#define B_CSR                           _B_CSR.Byte
#define B_CSR_CSGS                      _B_CSR.Bits.CSGS
#define B_CSR_CCD                       _B_CSR.Bits.CCD
#define B_CSR_CSE                       _B_CSR.Bits.CSE

#define B_CSR_CSGS_MASK                 7U
#define B_CSR_CSGS_BITNUM               0U
#define B_CSR_CCD_MASK                  8U
#define B_CSR_CSE_MASK                  128U


/*** B_SCIBD - SCI Baud Rate Register; 0x00000240 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_SCIBDH - SCI Baud Rate Register High; 0x00000240 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
        byte SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
        byte SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
        byte SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
        byte SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
        byte             :1; 
        byte RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
        byte LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } B_SCIBDHSTR;
    #define B_SCIBDH                    _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Byte
    #define B_SCIBDH_SBR8               _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR8
    #define B_SCIBDH_SBR9               _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR9
    #define B_SCIBDH_SBR10              _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR10
    #define B_SCIBDH_SBR11              _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR11
    #define B_SCIBDH_SBR12              _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.SBR12
    #define B_SCIBDH_RXEDGIE            _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.RXEDGIE
    #define B_SCIBDH_LBKDIE             _B_SCIBD.Overlap_STR.B_SCIBDHSTR.Bits.LBKDIE
    #define B_SCIBDH_SBR_8              _B_SCIBD.Overlap_STR.B_SCIBDHSTR.MergedBits.grpSBR_8
    #define B_SCIBDH_SBR                B_SCIBDH_SBR_8
    
    #define B_SCIBDH_SBR8_MASK          1U
    #define B_SCIBDH_SBR9_MASK          2U
    #define B_SCIBDH_SBR10_MASK         4U
    #define B_SCIBDH_SBR11_MASK         8U
    #define B_SCIBDH_SBR12_MASK         16U
    #define B_SCIBDH_RXEDGIE_MASK       64U
    #define B_SCIBDH_LBKDIE_MASK        128U
    #define B_SCIBDH_SBR_8_MASK         31U
    #define B_SCIBDH_SBR_8_BITNUM       0U
    

    /*** B_SCIBDL - SCI Baud Rate Register Low; 0x00000241 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
        byte SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
        byte SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
        byte SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
        byte SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
        byte SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
        byte SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
        byte SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
      } Bits;
    } B_SCIBDLSTR;
    #define B_SCIBDL                    _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Byte
    #define B_SCIBDL_SBR0               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR0
    #define B_SCIBDL_SBR1               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR1
    #define B_SCIBDL_SBR2               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR2
    #define B_SCIBDL_SBR3               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR3
    #define B_SCIBDL_SBR4               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR4
    #define B_SCIBDL_SBR5               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR5
    #define B_SCIBDL_SBR6               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR6
    #define B_SCIBDL_SBR7               _B_SCIBD.Overlap_STR.B_SCIBDLSTR.Bits.SBR7
    
    #define B_SCIBDL_SBR0_MASK          1U
    #define B_SCIBDL_SBR1_MASK          2U
    #define B_SCIBDL_SBR2_MASK          4U
    #define B_SCIBDL_SBR3_MASK          8U
    #define B_SCIBDL_SBR4_MASK          16U
    #define B_SCIBDL_SBR5_MASK          32U
    #define B_SCIBDL_SBR6_MASK          64U
    #define B_SCIBDL_SBR7_MASK          128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
    word SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
    word SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
    word SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
    word SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
    word SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
    word SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
    word SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
    word SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
    word SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
    word SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
    word SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
    word SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
    word             :1; 
    word RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
    word LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
  } Bits;
  struct {
    word grpSBR  :13;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} B_SCIBDSTR;
extern volatile B_SCIBDSTR _B_SCIBD @(REG_BASE + 0x00000240UL);
#define B_SCIBD                         _B_SCIBD.Word
#define B_SCIBD_SBR0                    _B_SCIBD.Bits.SBR0
#define B_SCIBD_SBR1                    _B_SCIBD.Bits.SBR1
#define B_SCIBD_SBR2                    _B_SCIBD.Bits.SBR2
#define B_SCIBD_SBR3                    _B_SCIBD.Bits.SBR3
#define B_SCIBD_SBR4                    _B_SCIBD.Bits.SBR4
#define B_SCIBD_SBR5                    _B_SCIBD.Bits.SBR5
#define B_SCIBD_SBR6                    _B_SCIBD.Bits.SBR6
#define B_SCIBD_SBR7                    _B_SCIBD.Bits.SBR7
#define B_SCIBD_SBR8                    _B_SCIBD.Bits.SBR8
#define B_SCIBD_SBR9                    _B_SCIBD.Bits.SBR9
#define B_SCIBD_SBR10                   _B_SCIBD.Bits.SBR10
#define B_SCIBD_SBR11                   _B_SCIBD.Bits.SBR11
#define B_SCIBD_SBR12                   _B_SCIBD.Bits.SBR12
#define B_SCIBD_RXEDGIE                 _B_SCIBD.Bits.RXEDGIE
#define B_SCIBD_LBKDIE                  _B_SCIBD.Bits.LBKDIE
#define B_SCIBD_SBR                     _B_SCIBD.MergedBits.grpSBR

#define B_SCIBD_SBR0_MASK               1U
#define B_SCIBD_SBR1_MASK               2U
#define B_SCIBD_SBR2_MASK               4U
#define B_SCIBD_SBR3_MASK               8U
#define B_SCIBD_SBR4_MASK               16U
#define B_SCIBD_SBR5_MASK               32U
#define B_SCIBD_SBR6_MASK               64U
#define B_SCIBD_SBR7_MASK               128U
#define B_SCIBD_SBR8_MASK               256U
#define B_SCIBD_SBR9_MASK               512U
#define B_SCIBD_SBR10_MASK              1024U
#define B_SCIBD_SBR11_MASK              2048U
#define B_SCIBD_SBR12_MASK              4096U
#define B_SCIBD_RXEDGIE_MASK            16384U
#define B_SCIBD_LBKDIE_MASK             32768U
#define B_SCIBD_SBR_MASK                8191U
#define B_SCIBD_SBR_BITNUM              0U


/*** B_SCIC1 - SCI Control Register 1; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type */
    byte PE          :1;                                       /* Parity Enable */
    byte ILT         :1;                                       /* Idle Line Type Select */
    byte             :1; 
    byte M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    byte RSRC        :1;                                       /* Receiver Source Select */
    byte             :1; 
    byte LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} B_SCIC1STR;
extern volatile B_SCIC1STR _B_SCIC1 @(REG_BASE + 0x00000242UL);
#define B_SCIC1                         _B_SCIC1.Byte
#define B_SCIC1_PT                      _B_SCIC1.Bits.PT
#define B_SCIC1_PE                      _B_SCIC1.Bits.PE
#define B_SCIC1_ILT                     _B_SCIC1.Bits.ILT
#define B_SCIC1_M                       _B_SCIC1.Bits.M
#define B_SCIC1_RSRC                    _B_SCIC1.Bits.RSRC
#define B_SCIC1_LOOPS                   _B_SCIC1.Bits.LOOPS

#define B_SCIC1_PT_MASK                 1U
#define B_SCIC1_PE_MASK                 2U
#define B_SCIC1_ILT_MASK                4U
#define B_SCIC1_M_MASK                  16U
#define B_SCIC1_RSRC_MASK               32U
#define B_SCIC1_LOOPS_MASK              128U


/*** B_SCIC2 - SCI Control Register 2; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break */
    byte RWU         :1;                                       /* Receiver Wakeup Control */
    byte RE          :1;                                       /* Receiver Enable */
    byte TE          :1;                                       /* Transmitter Enable */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    byte RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    byte TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} B_SCIC2STR;
extern volatile B_SCIC2STR _B_SCIC2 @(REG_BASE + 0x00000243UL);
#define B_SCIC2                         _B_SCIC2.Byte
#define B_SCIC2_SBK                     _B_SCIC2.Bits.SBK
#define B_SCIC2_RWU                     _B_SCIC2.Bits.RWU
#define B_SCIC2_RE                      _B_SCIC2.Bits.RE
#define B_SCIC2_TE                      _B_SCIC2.Bits.TE
#define B_SCIC2_ILIE                    _B_SCIC2.Bits.ILIE
#define B_SCIC2_RIE                     _B_SCIC2.Bits.RIE
#define B_SCIC2_TCIE                    _B_SCIC2.Bits.TCIE
#define B_SCIC2_TIE                     _B_SCIC2.Bits.TIE

#define B_SCIC2_SBK_MASK                1U
#define B_SCIC2_RWU_MASK                2U
#define B_SCIC2_RE_MASK                 4U
#define B_SCIC2_TE_MASK                 8U
#define B_SCIC2_ILIE_MASK               16U
#define B_SCIC2_RIE_MASK                32U
#define B_SCIC2_TCIE_MASK               64U
#define B_SCIC2_TIE_MASK                128U


/*** B_SCIS1 - SCI Status Register 1; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Receiver Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmission Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} B_SCIS1STR;
extern volatile B_SCIS1STR _B_SCIS1 @(REG_BASE + 0x00000244UL);
#define B_SCIS1                         _B_SCIS1.Byte
#define B_SCIS1_PF                      _B_SCIS1.Bits.PF
#define B_SCIS1_FE                      _B_SCIS1.Bits.FE
#define B_SCIS1_NF                      _B_SCIS1.Bits.NF
#define B_SCIS1_OR                      _B_SCIS1.Bits.OR
#define B_SCIS1_IDLE                    _B_SCIS1.Bits.IDLE
#define B_SCIS1_RDRF                    _B_SCIS1.Bits.RDRF
#define B_SCIS1_TC                      _B_SCIS1.Bits.TC
#define B_SCIS1_TDRE                    _B_SCIS1.Bits.TDRE

#define B_SCIS1_PF_MASK                 1U
#define B_SCIS1_FE_MASK                 2U
#define B_SCIS1_NF_MASK                 4U
#define B_SCIS1_OR_MASK                 8U
#define B_SCIS1_IDLE_MASK               16U
#define B_SCIS1_RDRF_MASK               32U
#define B_SCIS1_TC_MASK                 64U
#define B_SCIS1_TDRE_MASK               128U


/*** B_SCIS2 - SCI Status Register 2; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte LBKDE       :1;                                       /* LIN Break Detection Enable */
    byte BRK13       :1;                                       /* Break Character Generation Length */
    byte RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    byte RXINV       :1;                                       /* Receive Data Inversion */
    byte             :1; 
    byte RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    byte LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} B_SCIS2STR;
extern volatile B_SCIS2STR _B_SCIS2 @(REG_BASE + 0x00000245UL);
#define B_SCIS2                         _B_SCIS2.Byte
#define B_SCIS2_RAF                     _B_SCIS2.Bits.RAF
#define B_SCIS2_LBKDE                   _B_SCIS2.Bits.LBKDE
#define B_SCIS2_BRK13                   _B_SCIS2.Bits.BRK13
#define B_SCIS2_RWUID                   _B_SCIS2.Bits.RWUID
#define B_SCIS2_RXINV                   _B_SCIS2.Bits.RXINV
#define B_SCIS2_RXEDGIF                 _B_SCIS2.Bits.RXEDGIF
#define B_SCIS2_LBKDIF                  _B_SCIS2.Bits.LBKDIF

#define B_SCIS2_RAF_MASK                1U
#define B_SCIS2_LBKDE_MASK              2U
#define B_SCIS2_BRK13_MASK              4U
#define B_SCIS2_RWUID_MASK              8U
#define B_SCIS2_RXINV_MASK              16U
#define B_SCIS2_RXEDGIF_MASK            64U
#define B_SCIS2_LBKDIF_MASK             128U


/*** B_SCIC3 - SCI Control Register 3; 0x00000246 ***/
typedef union {
  byte Byte;
  struct {
    byte PEIE        :1;                                       /* Parity Error Interrupt Enable */
    byte FEIE        :1;                                       /* Framing Error Interrupt Enable */
    byte NEIE        :1;                                       /* Noise Error Interrupt Enable */
    byte ORIE        :1;                                       /* Overrun Interrupt Enable */
    byte TXINV       :1;                                       /* Transmit Data Inversion */
    byte TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    byte T8          :1;                                       /* Ninth Data Bit for Transmitter */
    byte R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} B_SCIC3STR;
extern volatile B_SCIC3STR _B_SCIC3 @(REG_BASE + 0x00000246UL);
#define B_SCIC3                         _B_SCIC3.Byte
#define B_SCIC3_PEIE                    _B_SCIC3.Bits.PEIE
#define B_SCIC3_FEIE                    _B_SCIC3.Bits.FEIE
#define B_SCIC3_NEIE                    _B_SCIC3.Bits.NEIE
#define B_SCIC3_ORIE                    _B_SCIC3.Bits.ORIE
#define B_SCIC3_TXINV                   _B_SCIC3.Bits.TXINV
#define B_SCIC3_TXDIR                   _B_SCIC3.Bits.TXDIR
#define B_SCIC3_T8                      _B_SCIC3.Bits.T8
#define B_SCIC3_R8                      _B_SCIC3.Bits.R8

#define B_SCIC3_PEIE_MASK               1U
#define B_SCIC3_FEIE_MASK               2U
#define B_SCIC3_NEIE_MASK               4U
#define B_SCIC3_ORIE_MASK               8U
#define B_SCIC3_TXINV_MASK              16U
#define B_SCIC3_TXDIR_MASK              32U
#define B_SCIC3_T8_MASK                 64U
#define B_SCIC3_R8_MASK                 128U


/*** B_SCID - SCI Data Register; 0x00000247 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    byte R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    byte R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    byte R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    byte R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    byte R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    byte R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    byte R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} B_SCIDSTR;
extern volatile B_SCIDSTR _B_SCID @(REG_BASE + 0x00000247UL);
#define B_SCID                          _B_SCID.Byte
#define B_SCID_R0_T0                    _B_SCID.Bits.R0_T0
#define B_SCID_R1_T1                    _B_SCID.Bits.R1_T1
#define B_SCID_R2_T2                    _B_SCID.Bits.R2_T2
#define B_SCID_R3_T3                    _B_SCID.Bits.R3_T3
#define B_SCID_R4_T4                    _B_SCID.Bits.R4_T4
#define B_SCID_R5_T5                    _B_SCID.Bits.R5_T5
#define B_SCID_R6_T6                    _B_SCID.Bits.R6_T6
#define B_SCID_R7_T7                    _B_SCID.Bits.R7_T7

#define B_SCID_R0_T0_MASK               1U
#define B_SCID_R1_T1_MASK               2U
#define B_SCID_R2_T2_MASK               4U
#define B_SCID_R3_T3_MASK               8U
#define B_SCID_R4_T4_MASK               16U
#define B_SCID_R5_T5_MASK               32U
#define B_SCID_R6_T6_MASK               64U
#define B_SCID_R7_T7_MASK               128U


/*** B_PWMCTL - PWM Control Register; 0x00000260 ***/
typedef union {
  byte Byte;
  struct {
    byte PWME0       :1;                                       /* Pulse Width Channel 0 Enable */
    byte PWME1       :1;                                       /* Pulse Width Channel 1 Enable */
    byte PPOL0       :1;                                       /* Pulse Width Channel 0 Polarity */
    byte PPOL1       :1;                                       /* Pulse Width Channel 1 Polarity */
    byte PCLK0       :1;                                       /* Pulse Width Channel 0 Clock Select */
    byte PCLK1       :1;                                       /* Pulse Width Channel 1 Clock Select */
    byte CAE0        :1;                                       /* Center Aligned Output Modes on Channel 0 */
    byte CAE1        :1;                                       /* Center Aligned Output Modes on Channel 1 */
  } Bits;
  struct {
    byte grpPWME :2;
    byte grpPPOL :2;
    byte grpPCLK :2;
    byte grpCAE  :2;
  } MergedBits;
} B_PWMCTLSTR;
extern volatile B_PWMCTLSTR _B_PWMCTL @(REG_BASE + 0x00000260UL);
#define B_PWMCTL                        _B_PWMCTL.Byte
#define B_PWMCTL_PWME0                  _B_PWMCTL.Bits.PWME0
#define B_PWMCTL_PWME1                  _B_PWMCTL.Bits.PWME1
#define B_PWMCTL_PPOL0                  _B_PWMCTL.Bits.PPOL0
#define B_PWMCTL_PPOL1                  _B_PWMCTL.Bits.PPOL1
#define B_PWMCTL_PCLK0                  _B_PWMCTL.Bits.PCLK0
#define B_PWMCTL_PCLK1                  _B_PWMCTL.Bits.PCLK1
#define B_PWMCTL_CAE0                   _B_PWMCTL.Bits.CAE0
#define B_PWMCTL_CAE1                   _B_PWMCTL.Bits.CAE1
#define B_PWMCTL_PWME                   _B_PWMCTL.MergedBits.grpPWME
#define B_PWMCTL_PPOL                   _B_PWMCTL.MergedBits.grpPPOL
#define B_PWMCTL_PCLK                   _B_PWMCTL.MergedBits.grpPCLK
#define B_PWMCTL_CAE                    _B_PWMCTL.MergedBits.grpCAE

#define B_PWMCTL_PWME0_MASK             1U
#define B_PWMCTL_PWME1_MASK             2U
#define B_PWMCTL_PPOL0_MASK             4U
#define B_PWMCTL_PPOL1_MASK             8U
#define B_PWMCTL_PCLK0_MASK             16U
#define B_PWMCTL_PCLK1_MASK             32U
#define B_PWMCTL_CAE0_MASK              64U
#define B_PWMCTL_CAE1_MASK              128U
#define B_PWMCTL_PWME_MASK              3U
#define B_PWMCTL_PWME_BITNUM            0U
#define B_PWMCTL_PPOL_MASK              12U
#define B_PWMCTL_PPOL_BITNUM            2U
#define B_PWMCTL_PCLK_MASK              48U
#define B_PWMCTL_PCLK_BITNUM            4U
#define B_PWMCTL_CAE_MASK               192U
#define B_PWMCTL_CAE_BITNUM             6U


/*** B_PWMPRCLK - PWM Prescale Clock Select Register; 0x00000261 ***/
typedef union {
  byte Byte;
  struct {
    byte PCKA0       :1;                                       /* Prescaler Select for Clock A Bit 0 */
    byte PCKA1       :1;                                       /* Prescaler Select for Clock A Bit 1 */
    byte PCKA2       :1;                                       /* Prescaler Select for Clock A Bit 2 */
    byte             :1; 
    byte PCKB0       :1;                                       /* Prescaler Select for Clock B Bit 0 */
    byte PCKB1       :1;                                       /* Prescaler Select for Clock B Bit 1 */
    byte PCKB2       :1;                                       /* Prescaler Select for Clock B Bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPCKA :3;
    byte         :1;
    byte grpPCKB :3;
    byte         :1;
  } MergedBits;
} B_PWMPRCLKSTR;
extern volatile B_PWMPRCLKSTR _B_PWMPRCLK @(REG_BASE + 0x00000261UL);
#define B_PWMPRCLK                      _B_PWMPRCLK.Byte
#define B_PWMPRCLK_PCKA0                _B_PWMPRCLK.Bits.PCKA0
#define B_PWMPRCLK_PCKA1                _B_PWMPRCLK.Bits.PCKA1
#define B_PWMPRCLK_PCKA2                _B_PWMPRCLK.Bits.PCKA2
#define B_PWMPRCLK_PCKB0                _B_PWMPRCLK.Bits.PCKB0
#define B_PWMPRCLK_PCKB1                _B_PWMPRCLK.Bits.PCKB1
#define B_PWMPRCLK_PCKB2                _B_PWMPRCLK.Bits.PCKB2
#define B_PWMPRCLK_PCKA                 _B_PWMPRCLK.MergedBits.grpPCKA
#define B_PWMPRCLK_PCKB                 _B_PWMPRCLK.MergedBits.grpPCKB

#define B_PWMPRCLK_PCKA0_MASK           1U
#define B_PWMPRCLK_PCKA1_MASK           2U
#define B_PWMPRCLK_PCKA2_MASK           4U
#define B_PWMPRCLK_PCKB0_MASK           16U
#define B_PWMPRCLK_PCKB1_MASK           32U
#define B_PWMPRCLK_PCKB2_MASK           64U
#define B_PWMPRCLK_PCKA_MASK            7U
#define B_PWMPRCLK_PCKA_BITNUM          0U
#define B_PWMPRCLK_PCKB_MASK            112U
#define B_PWMPRCLK_PCKB_BITNUM          4U


/*** B_PWMSCLA - PWM Scale A Register; 0x00000262 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale A Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale A Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale A Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale A Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale A Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale A Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale A Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale A Bit 7 */
  } Bits;
} B_PWMSCLASTR;
extern volatile B_PWMSCLASTR _B_PWMSCLA @(REG_BASE + 0x00000262UL);
#define B_PWMSCLA                       _B_PWMSCLA.Byte
#define B_PWMSCLA_BIT0                  _B_PWMSCLA.Bits.BIT0
#define B_PWMSCLA_BIT1                  _B_PWMSCLA.Bits.BIT1
#define B_PWMSCLA_BIT2                  _B_PWMSCLA.Bits.BIT2
#define B_PWMSCLA_BIT3                  _B_PWMSCLA.Bits.BIT3
#define B_PWMSCLA_BIT4                  _B_PWMSCLA.Bits.BIT4
#define B_PWMSCLA_BIT5                  _B_PWMSCLA.Bits.BIT5
#define B_PWMSCLA_BIT6                  _B_PWMSCLA.Bits.BIT6
#define B_PWMSCLA_BIT7                  _B_PWMSCLA.Bits.BIT7

#define B_PWMSCLA_BIT0_MASK             1U
#define B_PWMSCLA_BIT1_MASK             2U
#define B_PWMSCLA_BIT2_MASK             4U
#define B_PWMSCLA_BIT3_MASK             8U
#define B_PWMSCLA_BIT4_MASK             16U
#define B_PWMSCLA_BIT5_MASK             32U
#define B_PWMSCLA_BIT6_MASK             64U
#define B_PWMSCLA_BIT7_MASK             128U


/*** B_PWMSCLB - PWM Scale B Register; 0x00000263 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale B Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale B Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale B Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale B Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale B Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale B Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale B Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale B Bit 7 */
  } Bits;
} B_PWMSCLBSTR;
extern volatile B_PWMSCLBSTR _B_PWMSCLB @(REG_BASE + 0x00000263UL);
#define B_PWMSCLB                       _B_PWMSCLB.Byte
#define B_PWMSCLB_BIT0                  _B_PWMSCLB.Bits.BIT0
#define B_PWMSCLB_BIT1                  _B_PWMSCLB.Bits.BIT1
#define B_PWMSCLB_BIT2                  _B_PWMSCLB.Bits.BIT2
#define B_PWMSCLB_BIT3                  _B_PWMSCLB.Bits.BIT3
#define B_PWMSCLB_BIT4                  _B_PWMSCLB.Bits.BIT4
#define B_PWMSCLB_BIT5                  _B_PWMSCLB.Bits.BIT5
#define B_PWMSCLB_BIT6                  _B_PWMSCLB.Bits.BIT6
#define B_PWMSCLB_BIT7                  _B_PWMSCLB.Bits.BIT7

#define B_PWMSCLB_BIT0_MASK             1U
#define B_PWMSCLB_BIT1_MASK             2U
#define B_PWMSCLB_BIT2_MASK             4U
#define B_PWMSCLB_BIT3_MASK             8U
#define B_PWMSCLB_BIT4_MASK             16U
#define B_PWMSCLB_BIT5_MASK             32U
#define B_PWMSCLB_BIT6_MASK             64U
#define B_PWMSCLB_BIT7_MASK             128U


/*** B_PWMCNT0 - PWM Channel Counter 0 Register; 0x00000264 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMCNT00    :1;                                       /* PWM Channel Counter Bits, bit 0 */
    byte PWMCNT01    :1;                                       /* PWM Channel Counter Bits, bit 1 */
    byte PWMCNT02    :1;                                       /* PWM Channel Counter Bits, bit 2 */
    byte PWMCNT03    :1;                                       /* PWM Channel Counter Bits, bit 3 */
    byte PWMCNT04    :1;                                       /* PWM Channel Counter Bits, bit 4 */
    byte PWMCNT05    :1;                                       /* PWM Channel Counter Bits, bit 5 */
    byte PWMCNT06    :1;                                       /* PWM Channel Counter Bits, bit 6 */
    byte PWMCNT07    :1;                                       /* PWM Channel Counter Bits, bit 7 */
  } Bits;
} B_PWMCNT0STR;
extern volatile B_PWMCNT0STR _B_PWMCNT0 @(REG_BASE + 0x00000264UL);
#define B_PWMCNT0                       _B_PWMCNT0.Byte
#define B_PWMCNT0_PWMCNT00              _B_PWMCNT0.Bits.PWMCNT00
#define B_PWMCNT0_PWMCNT01              _B_PWMCNT0.Bits.PWMCNT01
#define B_PWMCNT0_PWMCNT02              _B_PWMCNT0.Bits.PWMCNT02
#define B_PWMCNT0_PWMCNT03              _B_PWMCNT0.Bits.PWMCNT03
#define B_PWMCNT0_PWMCNT04              _B_PWMCNT0.Bits.PWMCNT04
#define B_PWMCNT0_PWMCNT05              _B_PWMCNT0.Bits.PWMCNT05
#define B_PWMCNT0_PWMCNT06              _B_PWMCNT0.Bits.PWMCNT06
#define B_PWMCNT0_PWMCNT07              _B_PWMCNT0.Bits.PWMCNT07
/* B_PWMCNT_ARR: Access 2 B_PWMCNTx registers in an array */
#define B_PWMCNT_ARR                    ((volatile byte *) &B_PWMCNT0)

#define B_PWMCNT0_PWMCNT00_MASK         1U
#define B_PWMCNT0_PWMCNT01_MASK         2U
#define B_PWMCNT0_PWMCNT02_MASK         4U
#define B_PWMCNT0_PWMCNT03_MASK         8U
#define B_PWMCNT0_PWMCNT04_MASK         16U
#define B_PWMCNT0_PWMCNT05_MASK         32U
#define B_PWMCNT0_PWMCNT06_MASK         64U
#define B_PWMCNT0_PWMCNT07_MASK         128U


/*** B_PWMCNT1 - PWM Channel Counter 1 Register; 0x00000265 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMCNT10    :1;                                       /* PWM Channel Counter Bits, bit 0 */
    byte PWMCNT11    :1;                                       /* PWM Channel Counter Bits, bit 1 */
    byte PWMCNT12    :1;                                       /* PWM Channel Counter Bits, bit 2 */
    byte PWMCNT13    :1;                                       /* PWM Channel Counter Bits, bit 3 */
    byte PWMCNT14    :1;                                       /* PWM Channel Counter Bits, bit 4 */
    byte PWMCNT15    :1;                                       /* PWM Channel Counter Bits, bit 5 */
    byte PWMCNT16    :1;                                       /* PWM Channel Counter Bits, bit 6 */
    byte PWMCNT17    :1;                                       /* PWM Channel Counter Bits, bit 7 */
  } Bits;
} B_PWMCNT1STR;
extern volatile B_PWMCNT1STR _B_PWMCNT1 @(REG_BASE + 0x00000265UL);
#define B_PWMCNT1                       _B_PWMCNT1.Byte
#define B_PWMCNT1_PWMCNT10              _B_PWMCNT1.Bits.PWMCNT10
#define B_PWMCNT1_PWMCNT11              _B_PWMCNT1.Bits.PWMCNT11
#define B_PWMCNT1_PWMCNT12              _B_PWMCNT1.Bits.PWMCNT12
#define B_PWMCNT1_PWMCNT13              _B_PWMCNT1.Bits.PWMCNT13
#define B_PWMCNT1_PWMCNT14              _B_PWMCNT1.Bits.PWMCNT14
#define B_PWMCNT1_PWMCNT15              _B_PWMCNT1.Bits.PWMCNT15
#define B_PWMCNT1_PWMCNT16              _B_PWMCNT1.Bits.PWMCNT16
#define B_PWMCNT1_PWMCNT17              _B_PWMCNT1.Bits.PWMCNT17

#define B_PWMCNT1_PWMCNT10_MASK         1U
#define B_PWMCNT1_PWMCNT11_MASK         2U
#define B_PWMCNT1_PWMCNT12_MASK         4U
#define B_PWMCNT1_PWMCNT13_MASK         8U
#define B_PWMCNT1_PWMCNT14_MASK         16U
#define B_PWMCNT1_PWMCNT15_MASK         32U
#define B_PWMCNT1_PWMCNT16_MASK         64U
#define B_PWMCNT1_PWMCNT17_MASK         128U


/*** B_PWMPER0 - PWM Channel Period 0 Register; 0x00000266 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMPER00    :1;                                       /* PWM Channel Period Bits, bit 0 */
    byte PWMPER01    :1;                                       /* PWM Channel Period Bits, bit 1 */
    byte PWMPER02    :1;                                       /* PWM Channel Period Bits, bit 2 */
    byte PWMPER03    :1;                                       /* PWM Channel Period Bits, bit 3 */
    byte PWMPER04    :1;                                       /* PWM Channel Period Bits, bit 4 */
    byte PWMPER05    :1;                                       /* PWM Channel Period Bits, bit 5 */
    byte PWMPER06    :1;                                       /* PWM Channel Period Bits, bit 6 */
    byte PWMPER07    :1;                                       /* PWM Channel Period Bits, bit 7 */
  } Bits;
} B_PWMPER0STR;
extern volatile B_PWMPER0STR _B_PWMPER0 @(REG_BASE + 0x00000266UL);
#define B_PWMPER0                       _B_PWMPER0.Byte
#define B_PWMPER0_PWMPER00              _B_PWMPER0.Bits.PWMPER00
#define B_PWMPER0_PWMPER01              _B_PWMPER0.Bits.PWMPER01
#define B_PWMPER0_PWMPER02              _B_PWMPER0.Bits.PWMPER02
#define B_PWMPER0_PWMPER03              _B_PWMPER0.Bits.PWMPER03
#define B_PWMPER0_PWMPER04              _B_PWMPER0.Bits.PWMPER04
#define B_PWMPER0_PWMPER05              _B_PWMPER0.Bits.PWMPER05
#define B_PWMPER0_PWMPER06              _B_PWMPER0.Bits.PWMPER06
#define B_PWMPER0_PWMPER07              _B_PWMPER0.Bits.PWMPER07
/* B_PWMPER_ARR: Access 2 B_PWMPERx registers in an array */
#define B_PWMPER_ARR                    ((volatile byte *) &B_PWMPER0)

#define B_PWMPER0_PWMPER00_MASK         1U
#define B_PWMPER0_PWMPER01_MASK         2U
#define B_PWMPER0_PWMPER02_MASK         4U
#define B_PWMPER0_PWMPER03_MASK         8U
#define B_PWMPER0_PWMPER04_MASK         16U
#define B_PWMPER0_PWMPER05_MASK         32U
#define B_PWMPER0_PWMPER06_MASK         64U
#define B_PWMPER0_PWMPER07_MASK         128U


/*** B_PWMPER1 - PWM Channel Period 1 Register; 0x00000267 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMPER10    :1;                                       /* PWM Channel Period Bits, bit 0 */
    byte PWMPER11    :1;                                       /* PWM Channel Period Bits, bit 1 */
    byte PWMPER12    :1;                                       /* PWM Channel Period Bits, bit 2 */
    byte PWMPER13    :1;                                       /* PWM Channel Period Bits, bit 3 */
    byte PWMPER14    :1;                                       /* PWM Channel Period Bits, bit 4 */
    byte PWMPER15    :1;                                       /* PWM Channel Period Bits, bit 5 */
    byte PWMPER16    :1;                                       /* PWM Channel Period Bits, bit 6 */
    byte PWMPER17    :1;                                       /* PWM Channel Period Bits, bit 7 */
  } Bits;
} B_PWMPER1STR;
extern volatile B_PWMPER1STR _B_PWMPER1 @(REG_BASE + 0x00000267UL);
#define B_PWMPER1                       _B_PWMPER1.Byte
#define B_PWMPER1_PWMPER10              _B_PWMPER1.Bits.PWMPER10
#define B_PWMPER1_PWMPER11              _B_PWMPER1.Bits.PWMPER11
#define B_PWMPER1_PWMPER12              _B_PWMPER1.Bits.PWMPER12
#define B_PWMPER1_PWMPER13              _B_PWMPER1.Bits.PWMPER13
#define B_PWMPER1_PWMPER14              _B_PWMPER1.Bits.PWMPER14
#define B_PWMPER1_PWMPER15              _B_PWMPER1.Bits.PWMPER15
#define B_PWMPER1_PWMPER16              _B_PWMPER1.Bits.PWMPER16
#define B_PWMPER1_PWMPER17              _B_PWMPER1.Bits.PWMPER17

#define B_PWMPER1_PWMPER10_MASK         1U
#define B_PWMPER1_PWMPER11_MASK         2U
#define B_PWMPER1_PWMPER12_MASK         4U
#define B_PWMPER1_PWMPER13_MASK         8U
#define B_PWMPER1_PWMPER14_MASK         16U
#define B_PWMPER1_PWMPER15_MASK         32U
#define B_PWMPER1_PWMPER16_MASK         64U
#define B_PWMPER1_PWMPER17_MASK         128U


/*** B_PWMDTY0 - PWM Channel Duty 0 Register; 0x00000268 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMDTY00    :1;                                       /* PWM Channel Duty Bits, bit 0 */
    byte PWMDTY01    :1;                                       /* PWM Channel Duty Bits, bit 1 */
    byte PWMDTY02    :1;                                       /* PWM Channel Duty Bits, bit 2 */
    byte PWMDTY03    :1;                                       /* PWM Channel Duty Bits, bit 3 */
    byte PWMDTY04    :1;                                       /* PWM Channel Duty Bits, bit 4 */
    byte PWMDTY05    :1;                                       /* PWM Channel Duty Bits, bit 5 */
    byte PWMDTY06    :1;                                       /* PWM Channel Duty Bits, bit 6 */
    byte PWMDTY07    :1;                                       /* PWM Channel Duty Bits, bit 7 */
  } Bits;
} B_PWMDTY0STR;
extern volatile B_PWMDTY0STR _B_PWMDTY0 @(REG_BASE + 0x00000268UL);
#define B_PWMDTY0                       _B_PWMDTY0.Byte
#define B_PWMDTY0_PWMDTY00              _B_PWMDTY0.Bits.PWMDTY00
#define B_PWMDTY0_PWMDTY01              _B_PWMDTY0.Bits.PWMDTY01
#define B_PWMDTY0_PWMDTY02              _B_PWMDTY0.Bits.PWMDTY02
#define B_PWMDTY0_PWMDTY03              _B_PWMDTY0.Bits.PWMDTY03
#define B_PWMDTY0_PWMDTY04              _B_PWMDTY0.Bits.PWMDTY04
#define B_PWMDTY0_PWMDTY05              _B_PWMDTY0.Bits.PWMDTY05
#define B_PWMDTY0_PWMDTY06              _B_PWMDTY0.Bits.PWMDTY06
#define B_PWMDTY0_PWMDTY07              _B_PWMDTY0.Bits.PWMDTY07
/* B_PWMDTY_ARR: Access 2 B_PWMDTYx registers in an array */
#define B_PWMDTY_ARR                    ((volatile byte *) &B_PWMDTY0)

#define B_PWMDTY0_PWMDTY00_MASK         1U
#define B_PWMDTY0_PWMDTY01_MASK         2U
#define B_PWMDTY0_PWMDTY02_MASK         4U
#define B_PWMDTY0_PWMDTY03_MASK         8U
#define B_PWMDTY0_PWMDTY04_MASK         16U
#define B_PWMDTY0_PWMDTY05_MASK         32U
#define B_PWMDTY0_PWMDTY06_MASK         64U
#define B_PWMDTY0_PWMDTY07_MASK         128U


/*** B_PWMDTY1 - PWM Channel Duty 1 Register; 0x00000269 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMDTY10    :1;                                       /* PWM Channel Duty Bits, bit 0 */
    byte PWMDTY11    :1;                                       /* PWM Channel Duty Bits, bit 1 */
    byte PWMDTY12    :1;                                       /* PWM Channel Duty Bits, bit 2 */
    byte PWMDTY13    :1;                                       /* PWM Channel Duty Bits, bit 3 */
    byte PWMDTY14    :1;                                       /* PWM Channel Duty Bits, bit 4 */
    byte PWMDTY15    :1;                                       /* PWM Channel Duty Bits, bit 5 */
    byte PWMDTY16    :1;                                       /* PWM Channel Duty Bits, bit 6 */
    byte PWMDTY17    :1;                                       /* PWM Channel Duty Bits, bit 7 */
  } Bits;
} B_PWMDTY1STR;
extern volatile B_PWMDTY1STR _B_PWMDTY1 @(REG_BASE + 0x00000269UL);
#define B_PWMDTY1                       _B_PWMDTY1.Byte
#define B_PWMDTY1_PWMDTY10              _B_PWMDTY1.Bits.PWMDTY10
#define B_PWMDTY1_PWMDTY11              _B_PWMDTY1.Bits.PWMDTY11
#define B_PWMDTY1_PWMDTY12              _B_PWMDTY1.Bits.PWMDTY12
#define B_PWMDTY1_PWMDTY13              _B_PWMDTY1.Bits.PWMDTY13
#define B_PWMDTY1_PWMDTY14              _B_PWMDTY1.Bits.PWMDTY14
#define B_PWMDTY1_PWMDTY15              _B_PWMDTY1.Bits.PWMDTY15
#define B_PWMDTY1_PWMDTY16              _B_PWMDTY1.Bits.PWMDTY16
#define B_PWMDTY1_PWMDTY17              _B_PWMDTY1.Bits.PWMDTY17

#define B_PWMDTY1_PWMDTY10_MASK         1U
#define B_PWMDTY1_PWMDTY11_MASK         2U
#define B_PWMDTY1_PWMDTY12_MASK         4U
#define B_PWMDTY1_PWMDTY13_MASK         8U
#define B_PWMDTY1_PWMDTY14_MASK         16U
#define B_PWMDTY1_PWMDTY15_MASK         32U
#define B_PWMDTY1_PWMDTY16_MASK         64U
#define B_PWMDTY1_PWMDTY17_MASK         128U


/*** B_ACR - ADC Config Register; 0x00000280 ***/
typedef union {
  byte Byte;
  struct {
    byte PS          :3;                                       /* ADC Clock Prescaler Select 0 */
    byte             :1; 
    byte ADCRST      :1;                                       /* Analog Digital Converter RESET */
    byte OCE         :1;                                       /* Offset Compensation Enable */
    byte CCE         :1;                                       /* Continuous Conversion Enable */
    byte SCIE        :1;                                       /* Sequence Complete Interrupt Enable */
  } Bits;
} B_ACRSTR;
extern volatile B_ACRSTR _B_ACR @(REG_BASE + 0x00000280UL);
#define B_ACR                           _B_ACR.Byte
#define B_ACR_PS                        _B_ACR.Bits.PS
#define B_ACR_ADCRST                    _B_ACR.Bits.ADCRST
#define B_ACR_OCE                       _B_ACR.Bits.OCE
#define B_ACR_CCE                       _B_ACR.Bits.CCE
#define B_ACR_SCIE                      _B_ACR.Bits.SCIE

#define B_ACR_PS_MASK                   7U
#define B_ACR_PS_BITNUM                 0U
#define B_ACR_ADCRST_MASK               16U
#define B_ACR_OCE_MASK                  32U
#define B_ACR_CCE_MASK                  64U
#define B_ACR_SCIE_MASK                 128U


/*** B_ASR - ADC Status Register; 0x00000281 ***/
typedef union {
  byte Byte;
  struct {
    byte CCNT        :4;                                       /* Conversion Counter Status 0 */
    byte             :1; 
    byte             :1; 
    byte _2p5CLF     :1;                                       /* ADC Reference Voltage Current Limitation Flag */
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
} B_ASRSTR;
extern volatile B_ASRSTR _B_ASR @(REG_BASE + 0x00000281UL);
#define B_ASR                           _B_ASR.Byte
#define B_ASR_CCNT                      _B_ASR.Bits.CCNT
#define B_ASR_2p5CLF                    _B_ASR.Bits._2p5CLF
#define B_ASR_SCF                       _B_ASR.Bits.SCF

#define B_ASR_CCNT_MASK                 15U
#define B_ASR_CCNT_BITNUM               0U
#define B_ASR_2p5CLF_MASK               64U
#define B_ASR_SCF_MASK                  128U


/*** B_ACCR - ADC Conversion Control Register; 0x00000282 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ACCRhi - ADC Conversion Control Register High; 0x00000282 ***/
    union {
      byte Byte;
      struct {
        byte CH8         :1;                                       /* Channel Select 8 */
        byte CH9         :1;                                       /* Channel Select 9 */
        byte CH10        :1;                                       /* Channel Select 10 */
        byte CH11        :1;                                       /* Channel Select 11 */
        byte CH12        :1;                                       /* Channel Select 12 */
        byte             :1; 
        byte CH14        :1;                                       /* Channel Select 14 */
        byte CH15        :1;                                       /* Channel Select 15 */
      } Bits;
      struct {
        byte grpCH_8 :5;
        byte     :1;
        byte grpCH_14 :2;
      } MergedBits;
    } B_ACCRhiSTR;
    #define B_ACCRhi                    _B_ACCR.Overlap_STR.B_ACCRhiSTR.Byte
    #define B_ACCRhi_CH8                _B_ACCR.Overlap_STR.B_ACCRhiSTR.Bits.CH8
    #define B_ACCRhi_CH9                _B_ACCR.Overlap_STR.B_ACCRhiSTR.Bits.CH9
    #define B_ACCRhi_CH10               _B_ACCR.Overlap_STR.B_ACCRhiSTR.Bits.CH10
    #define B_ACCRhi_CH11               _B_ACCR.Overlap_STR.B_ACCRhiSTR.Bits.CH11
    #define B_ACCRhi_CH12               _B_ACCR.Overlap_STR.B_ACCRhiSTR.Bits.CH12
    #define B_ACCRhi_CH14               _B_ACCR.Overlap_STR.B_ACCRhiSTR.Bits.CH14
    #define B_ACCRhi_CH15               _B_ACCR.Overlap_STR.B_ACCRhiSTR.Bits.CH15
    #define B_ACCRhi_CH_8               _B_ACCR.Overlap_STR.B_ACCRhiSTR.MergedBits.grpCH_8
    #define B_ACCRhi_CH_14              _B_ACCR.Overlap_STR.B_ACCRhiSTR.MergedBits.grpCH_14
    #define B_ACCRhi_CH                 B_ACCRhi_CH_8
    
    #define B_ACCRhi_CH8_MASK           1U
    #define B_ACCRhi_CH9_MASK           2U
    #define B_ACCRhi_CH10_MASK          4U
    #define B_ACCRhi_CH11_MASK          8U
    #define B_ACCRhi_CH12_MASK          16U
    #define B_ACCRhi_CH14_MASK          64U
    #define B_ACCRhi_CH15_MASK          128U
    #define B_ACCRhi_CH_8_MASK          31U
    #define B_ACCRhi_CH_8_BITNUM        0U
    #define B_ACCRhi_CH_14_MASK         192U
    #define B_ACCRhi_CH_14_BITNUM       6U
    

    /*** B_ACCRlo - ADC Conversion Control Register Low; 0x00000283 ***/
    union {
      byte Byte;
      struct {
        byte CH0         :1;                                       /* Channel Select 0 */
        byte CH1         :1;                                       /* Channel Select 1 */
        byte CH2         :1;                                       /* Channel Select 2 */
        byte CH3         :1;                                       /* Channel Select 3 */
        byte CH4         :1;                                       /* Channel Select 4 */
        byte CH5         :1;                                       /* Channel Select 5 */
        byte CH6         :1;                                       /* Channel Select 6 */
        byte CH7         :1;                                       /* Channel Select 7 */
      } Bits;
    } B_ACCRloSTR;
    #define B_ACCRlo                    _B_ACCR.Overlap_STR.B_ACCRloSTR.Byte
    #define B_ACCRlo_CH0                _B_ACCR.Overlap_STR.B_ACCRloSTR.Bits.CH0
    #define B_ACCRlo_CH1                _B_ACCR.Overlap_STR.B_ACCRloSTR.Bits.CH1
    #define B_ACCRlo_CH2                _B_ACCR.Overlap_STR.B_ACCRloSTR.Bits.CH2
    #define B_ACCRlo_CH3                _B_ACCR.Overlap_STR.B_ACCRloSTR.Bits.CH3
    #define B_ACCRlo_CH4                _B_ACCR.Overlap_STR.B_ACCRloSTR.Bits.CH4
    #define B_ACCRlo_CH5                _B_ACCR.Overlap_STR.B_ACCRloSTR.Bits.CH5
    #define B_ACCRlo_CH6                _B_ACCR.Overlap_STR.B_ACCRloSTR.Bits.CH6
    #define B_ACCRlo_CH7                _B_ACCR.Overlap_STR.B_ACCRloSTR.Bits.CH7
    
    #define B_ACCRlo_CH0_MASK           1U
    #define B_ACCRlo_CH1_MASK           2U
    #define B_ACCRlo_CH2_MASK           4U
    #define B_ACCRlo_CH3_MASK           8U
    #define B_ACCRlo_CH4_MASK           16U
    #define B_ACCRlo_CH5_MASK           32U
    #define B_ACCRlo_CH6_MASK           64U
    #define B_ACCRlo_CH7_MASK           128U
    
  } Overlap_STR;

  struct {
    word CH0         :1;                                       /* Channel Select 0 */
    word CH1         :1;                                       /* Channel Select 1 */
    word CH2         :1;                                       /* Channel Select 2 */
    word CH3         :1;                                       /* Channel Select 3 */
    word CH4         :1;                                       /* Channel Select 4 */
    word CH5         :1;                                       /* Channel Select 5 */
    word CH6         :1;                                       /* Channel Select 6 */
    word CH7         :1;                                       /* Channel Select 7 */
    word CH8         :1;                                       /* Channel Select 8 */
    word CH9         :1;                                       /* Channel Select 9 */
    word CH10        :1;                                       /* Channel Select 10 */
    word CH11        :1;                                       /* Channel Select 11 */
    word CH12        :1;                                       /* Channel Select 12 */
    word             :1; 
    word CH14        :1;                                       /* Channel Select 14 */
    word CH15        :1;                                       /* Channel Select 15 */
  } Bits;
  struct {
    word grpCH   :13;
    word         :1;
    word grpCH_14 :2;
  } MergedBits;
} B_ACCRSTR;
extern volatile B_ACCRSTR _B_ACCR @(REG_BASE + 0x00000282UL);
#define B_ACCR                          _B_ACCR.Word
#define B_ACCR_CH0                      _B_ACCR.Bits.CH0
#define B_ACCR_CH1                      _B_ACCR.Bits.CH1
#define B_ACCR_CH2                      _B_ACCR.Bits.CH2
#define B_ACCR_CH3                      _B_ACCR.Bits.CH3
#define B_ACCR_CH4                      _B_ACCR.Bits.CH4
#define B_ACCR_CH5                      _B_ACCR.Bits.CH5
#define B_ACCR_CH6                      _B_ACCR.Bits.CH6
#define B_ACCR_CH7                      _B_ACCR.Bits.CH7
#define B_ACCR_CH8                      _B_ACCR.Bits.CH8
#define B_ACCR_CH9                      _B_ACCR.Bits.CH9
#define B_ACCR_CH10                     _B_ACCR.Bits.CH10
#define B_ACCR_CH11                     _B_ACCR.Bits.CH11
#define B_ACCR_CH12                     _B_ACCR.Bits.CH12
#define B_ACCR_CH14                     _B_ACCR.Bits.CH14
#define B_ACCR_CH15                     _B_ACCR.Bits.CH15
#define B_ACCR_CH                       _B_ACCR.MergedBits.grpCH
#define B_ACCR_CH_14                    _B_ACCR.MergedBits.grpCH_14

#define B_ACCR_CH0_MASK                 1U
#define B_ACCR_CH1_MASK                 2U
#define B_ACCR_CH2_MASK                 4U
#define B_ACCR_CH3_MASK                 8U
#define B_ACCR_CH4_MASK                 16U
#define B_ACCR_CH5_MASK                 32U
#define B_ACCR_CH6_MASK                 64U
#define B_ACCR_CH7_MASK                 128U
#define B_ACCR_CH8_MASK                 256U
#define B_ACCR_CH9_MASK                 512U
#define B_ACCR_CH10_MASK                1024U
#define B_ACCR_CH11_MASK                2048U
#define B_ACCR_CH12_MASK                4096U
#define B_ACCR_CH14_MASK                16384U
#define B_ACCR_CH15_MASK                32768U
#define B_ACCR_CH_MASK                  8191U
#define B_ACCR_CH_BITNUM                0U
#define B_ACCR_CH_14_MASK               49152U
#define B_ACCR_CH_14_BITNUM             14U


/*** B_ACCSR - ADC Conversion Complete Status Register; 0x00000284 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ACCSRhi - ADC Conversion Complete Status Register High; 0x00000284 ***/
    union {
      byte Byte;
      struct {
        byte CC8         :1;                                       /* Conversion Complete Flag 8 */
        byte CC9         :1;                                       /* Conversion Complete Flag 9 */
        byte CC10        :1;                                       /* Conversion Complete Flag 10 */
        byte CC11        :1;                                       /* Conversion Complete Flag 11 */
        byte CC12        :1;                                       /* Conversion Complete Flag 12 */
        byte             :1; 
        byte CC14        :1;                                       /* Conversion Complete Flag 14 */
        byte CC15        :1;                                       /* Conversion Complete Flag 15 */
      } Bits;
      struct {
        byte grpCC_8 :5;
        byte     :1;
        byte grpCC_14 :2;
      } MergedBits;
    } B_ACCSRhiSTR;
    #define B_ACCSRhi                   _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.Byte
    #define B_ACCSRhi_CC8               _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.Bits.CC8
    #define B_ACCSRhi_CC9               _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.Bits.CC9
    #define B_ACCSRhi_CC10              _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.Bits.CC10
    #define B_ACCSRhi_CC11              _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.Bits.CC11
    #define B_ACCSRhi_CC12              _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.Bits.CC12
    #define B_ACCSRhi_CC14              _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.Bits.CC14
    #define B_ACCSRhi_CC15              _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.Bits.CC15
    #define B_ACCSRhi_CC_8              _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.MergedBits.grpCC_8
    #define B_ACCSRhi_CC_14             _B_ACCSR.Overlap_STR.B_ACCSRhiSTR.MergedBits.grpCC_14
    #define B_ACCSRhi_CC                B_ACCSRhi_CC_8
    
    #define B_ACCSRhi_CC8_MASK          1U
    #define B_ACCSRhi_CC9_MASK          2U
    #define B_ACCSRhi_CC10_MASK         4U
    #define B_ACCSRhi_CC11_MASK         8U
    #define B_ACCSRhi_CC12_MASK         16U
    #define B_ACCSRhi_CC14_MASK         64U
    #define B_ACCSRhi_CC15_MASK         128U
    #define B_ACCSRhi_CC_8_MASK         31U
    #define B_ACCSRhi_CC_8_BITNUM       0U
    #define B_ACCSRhi_CC_14_MASK        192U
    #define B_ACCSRhi_CC_14_BITNUM      6U
    

    /*** B_ACCSRlo - ADC Conversion Complete Status Register Low; 0x00000285 ***/
    union {
      byte Byte;
      struct {
        byte CC0         :1;                                       /* Conversion Complete Flag 0 */
        byte CC1         :1;                                       /* Conversion Complete Flag 1 */
        byte CC2         :1;                                       /* Conversion Complete Flag 2 */
        byte CC3         :1;                                       /* Conversion Complete Flag 3 */
        byte CC4         :1;                                       /* Conversion Complete Flag 4 */
        byte CC5         :1;                                       /* Conversion Complete Flag 5 */
        byte CC6         :1;                                       /* Conversion Complete Flag 6 */
        byte CC7         :1;                                       /* Conversion Complete Flag 7 */
      } Bits;
    } B_ACCSRloSTR;
    #define B_ACCSRlo                   _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Byte
    #define B_ACCSRlo_CC0               _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Bits.CC0
    #define B_ACCSRlo_CC1               _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Bits.CC1
    #define B_ACCSRlo_CC2               _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Bits.CC2
    #define B_ACCSRlo_CC3               _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Bits.CC3
    #define B_ACCSRlo_CC4               _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Bits.CC4
    #define B_ACCSRlo_CC5               _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Bits.CC5
    #define B_ACCSRlo_CC6               _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Bits.CC6
    #define B_ACCSRlo_CC7               _B_ACCSR.Overlap_STR.B_ACCSRloSTR.Bits.CC7
    
    #define B_ACCSRlo_CC0_MASK          1U
    #define B_ACCSRlo_CC1_MASK          2U
    #define B_ACCSRlo_CC2_MASK          4U
    #define B_ACCSRlo_CC3_MASK          8U
    #define B_ACCSRlo_CC4_MASK          16U
    #define B_ACCSRlo_CC5_MASK          32U
    #define B_ACCSRlo_CC6_MASK          64U
    #define B_ACCSRlo_CC7_MASK          128U
    
  } Overlap_STR;

  struct {
    word CC0         :1;                                       /* Conversion Complete Flag 0 */
    word CC1         :1;                                       /* Conversion Complete Flag 1 */
    word CC2         :1;                                       /* Conversion Complete Flag 2 */
    word CC3         :1;                                       /* Conversion Complete Flag 3 */
    word CC4         :1;                                       /* Conversion Complete Flag 4 */
    word CC5         :1;                                       /* Conversion Complete Flag 5 */
    word CC6         :1;                                       /* Conversion Complete Flag 6 */
    word CC7         :1;                                       /* Conversion Complete Flag 7 */
    word CC8         :1;                                       /* Conversion Complete Flag 8 */
    word CC9         :1;                                       /* Conversion Complete Flag 9 */
    word CC10        :1;                                       /* Conversion Complete Flag 10 */
    word CC11        :1;                                       /* Conversion Complete Flag 11 */
    word CC12        :1;                                       /* Conversion Complete Flag 12 */
    word             :1; 
    word CC14        :1;                                       /* Conversion Complete Flag 14 */
    word CC15        :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
  struct {
    word grpCC   :13;
    word         :1;
    word grpCC_14 :2;
  } MergedBits;
} B_ACCSRSTR;
extern volatile B_ACCSRSTR _B_ACCSR @(REG_BASE + 0x00000284UL);
#define B_ACCSR                         _B_ACCSR.Word
#define B_ACCSR_CC0                     _B_ACCSR.Bits.CC0
#define B_ACCSR_CC1                     _B_ACCSR.Bits.CC1
#define B_ACCSR_CC2                     _B_ACCSR.Bits.CC2
#define B_ACCSR_CC3                     _B_ACCSR.Bits.CC3
#define B_ACCSR_CC4                     _B_ACCSR.Bits.CC4
#define B_ACCSR_CC5                     _B_ACCSR.Bits.CC5
#define B_ACCSR_CC6                     _B_ACCSR.Bits.CC6
#define B_ACCSR_CC7                     _B_ACCSR.Bits.CC7
#define B_ACCSR_CC8                     _B_ACCSR.Bits.CC8
#define B_ACCSR_CC9                     _B_ACCSR.Bits.CC9
#define B_ACCSR_CC10                    _B_ACCSR.Bits.CC10
#define B_ACCSR_CC11                    _B_ACCSR.Bits.CC11
#define B_ACCSR_CC12                    _B_ACCSR.Bits.CC12
#define B_ACCSR_CC14                    _B_ACCSR.Bits.CC14
#define B_ACCSR_CC15                    _B_ACCSR.Bits.CC15
#define B_ACCSR_CC                      _B_ACCSR.MergedBits.grpCC
#define B_ACCSR_CC_14                   _B_ACCSR.MergedBits.grpCC_14

#define B_ACCSR_CC0_MASK                1U
#define B_ACCSR_CC1_MASK                2U
#define B_ACCSR_CC2_MASK                4U
#define B_ACCSR_CC3_MASK                8U
#define B_ACCSR_CC4_MASK                16U
#define B_ACCSR_CC5_MASK                32U
#define B_ACCSR_CC6_MASK                64U
#define B_ACCSR_CC7_MASK                128U
#define B_ACCSR_CC8_MASK                256U
#define B_ACCSR_CC9_MASK                512U
#define B_ACCSR_CC10_MASK               1024U
#define B_ACCSR_CC11_MASK               2048U
#define B_ACCSR_CC12_MASK               4096U
#define B_ACCSR_CC14_MASK               16384U
#define B_ACCSR_CC15_MASK               32768U
#define B_ACCSR_CC_MASK                 8191U
#define B_ACCSR_CC_BITNUM               0U
#define B_ACCSR_CC_14_MASK              49152U
#define B_ACCSR_CC_14_BITNUM            14U


/*** B_ADR0 - ADC Data Result Register 0; 0x00000286 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR0hi - ADC Data Result Register 0 High; 0x00000286 ***/
    union {
      byte Byte;
    } B_ADR0hiSTR;
    #define B_ADR0hi                    _B_ADR0.Overlap_STR.B_ADR0hiSTR.Byte
    

    /*** B_ADR0lo - ADC Data Result Register 0 Low; 0x00000287 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR0        :2;                                       /* ADC Channel 0 Result Bit 0 */
      } Bits;
    } B_ADR0loSTR;
    #define B_ADR0lo                    _B_ADR0.Overlap_STR.B_ADR0loSTR.Byte
    #define B_ADR0lo_ADR0               _B_ADR0.Overlap_STR.B_ADR0loSTR.Bits.ADR0
    
    #define B_ADR0lo_ADR0_MASK          192U
    #define B_ADR0lo_ADR0_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR0        :10;                                      /* ADC Channel 0 Result Bit 0 */
  } Bits;
} B_ADR0STR;
extern volatile B_ADR0STR _B_ADR0 @(REG_BASE + 0x00000286UL);
#define B_ADR0                          _B_ADR0.Word
#define B_ADR0_ADR0                     _B_ADR0.Bits.ADR0
/* B_ADR_ARR: Access 16 B_ADRx registers in an array */
#define B_ADR_ARR                       ((volatile word *) &B_ADR0)

#define B_ADR0_ADR0_MASK                65472U
#define B_ADR0_ADR0_BITNUM              6U


/*** B_ADR1 - ADC Data Result Register 1; 0x00000288 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR1hi - ADC Data Result Register 1 High; 0x00000288 ***/
    union {
      byte Byte;
    } B_ADR1hiSTR;
    #define B_ADR1hi                    _B_ADR1.Overlap_STR.B_ADR1hiSTR.Byte
    

    /*** B_ADR1lo - ADC Data Result Register 1 Low; 0x00000289 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR1        :2;                                       /* ADC Channel 1 Result Bit 0 */
      } Bits;
    } B_ADR1loSTR;
    #define B_ADR1lo                    _B_ADR1.Overlap_STR.B_ADR1loSTR.Byte
    #define B_ADR1lo_ADR1               _B_ADR1.Overlap_STR.B_ADR1loSTR.Bits.ADR1
    
    #define B_ADR1lo_ADR1_MASK          192U
    #define B_ADR1lo_ADR1_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR1        :10;                                      /* ADC Channel 1 Result Bit 0 */
  } Bits;
} B_ADR1STR;
extern volatile B_ADR1STR _B_ADR1 @(REG_BASE + 0x00000288UL);
#define B_ADR1                          _B_ADR1.Word
#define B_ADR1_ADR1                     _B_ADR1.Bits.ADR1

#define B_ADR1_ADR1_MASK                65472U
#define B_ADR1_ADR1_BITNUM              6U


/*** B_ADR2 - ADC Data Result Register 2; 0x0000028A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR2hi - ADC Data Result Register 2 High; 0x0000028A ***/
    union {
      byte Byte;
    } B_ADR2hiSTR;
    #define B_ADR2hi                    _B_ADR2.Overlap_STR.B_ADR2hiSTR.Byte
    

    /*** B_ADR2lo - ADC Data Result Register 2 Low; 0x0000028B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR2        :2;                                       /* ADC Channel 2 Result Bit 0 */
      } Bits;
    } B_ADR2loSTR;
    #define B_ADR2lo                    _B_ADR2.Overlap_STR.B_ADR2loSTR.Byte
    #define B_ADR2lo_ADR2               _B_ADR2.Overlap_STR.B_ADR2loSTR.Bits.ADR2
    
    #define B_ADR2lo_ADR2_MASK          192U
    #define B_ADR2lo_ADR2_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR2        :10;                                      /* ADC Channel 2 Result Bit 0 */
  } Bits;
} B_ADR2STR;
extern volatile B_ADR2STR _B_ADR2 @(REG_BASE + 0x0000028AUL);
#define B_ADR2                          _B_ADR2.Word
#define B_ADR2_ADR2                     _B_ADR2.Bits.ADR2

#define B_ADR2_ADR2_MASK                65472U
#define B_ADR2_ADR2_BITNUM              6U


/*** B_ADR3 - ADC Data Result Register 3; 0x0000028C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR3hi - ADC Data Result Register 3 High; 0x0000028C ***/
    union {
      byte Byte;
    } B_ADR3hiSTR;
    #define B_ADR3hi                    _B_ADR3.Overlap_STR.B_ADR3hiSTR.Byte
    

    /*** B_ADR3lo - ADC Data Result Register 3 Low; 0x0000028D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR3        :2;                                       /* ADC Channel 3 Result Bit 0 */
      } Bits;
    } B_ADR3loSTR;
    #define B_ADR3lo                    _B_ADR3.Overlap_STR.B_ADR3loSTR.Byte
    #define B_ADR3lo_ADR3               _B_ADR3.Overlap_STR.B_ADR3loSTR.Bits.ADR3
    
    #define B_ADR3lo_ADR3_MASK          192U
    #define B_ADR3lo_ADR3_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR3        :10;                                      /* ADC Channel 3 Result Bit 0 */
  } Bits;
} B_ADR3STR;
extern volatile B_ADR3STR _B_ADR3 @(REG_BASE + 0x0000028CUL);
#define B_ADR3                          _B_ADR3.Word
#define B_ADR3_ADR3                     _B_ADR3.Bits.ADR3

#define B_ADR3_ADR3_MASK                65472U
#define B_ADR3_ADR3_BITNUM              6U


/*** B_ADR4 - ADC Data Result Register 4; 0x0000028E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR4hi - ADC Data Result Register 4 High; 0x0000028E ***/
    union {
      byte Byte;
    } B_ADR4hiSTR;
    #define B_ADR4hi                    _B_ADR4.Overlap_STR.B_ADR4hiSTR.Byte
    

    /*** B_ADR4lo - ADC Data Result Register 4 Low; 0x0000028F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR4        :2;                                       /* ADC Channel 4 Result Bit 0 */
      } Bits;
    } B_ADR4loSTR;
    #define B_ADR4lo                    _B_ADR4.Overlap_STR.B_ADR4loSTR.Byte
    #define B_ADR4lo_ADR4               _B_ADR4.Overlap_STR.B_ADR4loSTR.Bits.ADR4
    
    #define B_ADR4lo_ADR4_MASK          192U
    #define B_ADR4lo_ADR4_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR4        :10;                                      /* ADC Channel 4 Result Bit 0 */
  } Bits;
} B_ADR4STR;
extern volatile B_ADR4STR _B_ADR4 @(REG_BASE + 0x0000028EUL);
#define B_ADR4                          _B_ADR4.Word
#define B_ADR4_ADR4                     _B_ADR4.Bits.ADR4

#define B_ADR4_ADR4_MASK                65472U
#define B_ADR4_ADR4_BITNUM              6U


/*** B_ADR5 - ADC Data Result Register 5; 0x00000290 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR5hi - ADC Data Result Register 5 High; 0x00000290 ***/
    union {
      byte Byte;
    } B_ADR5hiSTR;
    #define B_ADR5hi                    _B_ADR5.Overlap_STR.B_ADR5hiSTR.Byte
    

    /*** B_ADR5lo - ADC Data Result Register 5 Low; 0x00000291 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR5        :2;                                       /* ADC Channel 5 Result Bit 0 */
      } Bits;
    } B_ADR5loSTR;
    #define B_ADR5lo                    _B_ADR5.Overlap_STR.B_ADR5loSTR.Byte
    #define B_ADR5lo_ADR5               _B_ADR5.Overlap_STR.B_ADR5loSTR.Bits.ADR5
    
    #define B_ADR5lo_ADR5_MASK          192U
    #define B_ADR5lo_ADR5_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR5        :10;                                      /* ADC Channel 5 Result Bit 0 */
  } Bits;
} B_ADR5STR;
extern volatile B_ADR5STR _B_ADR5 @(REG_BASE + 0x00000290UL);
#define B_ADR5                          _B_ADR5.Word
#define B_ADR5_ADR5                     _B_ADR5.Bits.ADR5

#define B_ADR5_ADR5_MASK                65472U
#define B_ADR5_ADR5_BITNUM              6U


/*** B_ADR6 - ADC Data Result Register 6; 0x00000292 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR6hi - ADC Data Result Register 6 High; 0x00000292 ***/
    union {
      byte Byte;
    } B_ADR6hiSTR;
    #define B_ADR6hi                    _B_ADR6.Overlap_STR.B_ADR6hiSTR.Byte
    

    /*** B_ADR6lo - ADC Data Result Register 6 Low; 0x00000293 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR6        :2;                                       /* ADC Channel 6 Result Bit 0 */
      } Bits;
    } B_ADR6loSTR;
    #define B_ADR6lo                    _B_ADR6.Overlap_STR.B_ADR6loSTR.Byte
    #define B_ADR6lo_ADR6               _B_ADR6.Overlap_STR.B_ADR6loSTR.Bits.ADR6
    
    #define B_ADR6lo_ADR6_MASK          192U
    #define B_ADR6lo_ADR6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR6        :10;                                      /* ADC Channel 6 Result Bit 0 */
  } Bits;
} B_ADR6STR;
extern volatile B_ADR6STR _B_ADR6 @(REG_BASE + 0x00000292UL);
#define B_ADR6                          _B_ADR6.Word
#define B_ADR6_ADR6                     _B_ADR6.Bits.ADR6

#define B_ADR6_ADR6_MASK                65472U
#define B_ADR6_ADR6_BITNUM              6U


/*** B_ADR7 - ADC Data Result Register 7; 0x00000294 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR7hi - ADC Data Result Register 7 High; 0x00000294 ***/
    union {
      byte Byte;
    } B_ADR7hiSTR;
    #define B_ADR7hi                    _B_ADR7.Overlap_STR.B_ADR7hiSTR.Byte
    

    /*** B_ADR7lo - ADC Data Result Register 7 Low; 0x00000295 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR7        :2;                                       /* ADC Channel 7 Result Bit 0 */
      } Bits;
    } B_ADR7loSTR;
    #define B_ADR7lo                    _B_ADR7.Overlap_STR.B_ADR7loSTR.Byte
    #define B_ADR7lo_ADR7               _B_ADR7.Overlap_STR.B_ADR7loSTR.Bits.ADR7
    
    #define B_ADR7lo_ADR7_MASK          192U
    #define B_ADR7lo_ADR7_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR7        :10;                                      /* ADC Channel 7 Result Bit 0 */
  } Bits;
} B_ADR7STR;
extern volatile B_ADR7STR _B_ADR7 @(REG_BASE + 0x00000294UL);
#define B_ADR7                          _B_ADR7.Word
#define B_ADR7_ADR7                     _B_ADR7.Bits.ADR7

#define B_ADR7_ADR7_MASK                65472U
#define B_ADR7_ADR7_BITNUM              6U


/*** B_ADR8 - ADC Data Result Register 8; 0x00000296 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR8hi - ADC Data Result Register 8 High; 0x00000296 ***/
    union {
      byte Byte;
    } B_ADR8hiSTR;
    #define B_ADR8hi                    _B_ADR8.Overlap_STR.B_ADR8hiSTR.Byte
    

    /*** B_ADR8lo - ADC Data Result Register 8 Low; 0x00000297 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR8        :2;                                       /* ADC Channel 8 Result Bit 0 */
      } Bits;
    } B_ADR8loSTR;
    #define B_ADR8lo                    _B_ADR8.Overlap_STR.B_ADR8loSTR.Byte
    #define B_ADR8lo_ADR8               _B_ADR8.Overlap_STR.B_ADR8loSTR.Bits.ADR8
    
    #define B_ADR8lo_ADR8_MASK          192U
    #define B_ADR8lo_ADR8_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR8        :10;                                      /* ADC Channel 8 Result Bit 0 */
  } Bits;
} B_ADR8STR;
extern volatile B_ADR8STR _B_ADR8 @(REG_BASE + 0x00000296UL);
#define B_ADR8                          _B_ADR8.Word
#define B_ADR8_ADR8                     _B_ADR8.Bits.ADR8

#define B_ADR8_ADR8_MASK                65472U
#define B_ADR8_ADR8_BITNUM              6U


/*** B_ADR9 - ADC Data Result Register 9; 0x00000298 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR9hi - ADC Data Result Register 9 High; 0x00000298 ***/
    union {
      byte Byte;
    } B_ADR9hiSTR;
    #define B_ADR9hi                    _B_ADR9.Overlap_STR.B_ADR9hiSTR.Byte
    

    /*** B_ADR9lo - ADC Data Result Register 9 Low; 0x00000299 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR9        :2;                                       /* ADC Channel 9 Result Bit 0 */
      } Bits;
    } B_ADR9loSTR;
    #define B_ADR9lo                    _B_ADR9.Overlap_STR.B_ADR9loSTR.Byte
    #define B_ADR9lo_ADR9               _B_ADR9.Overlap_STR.B_ADR9loSTR.Bits.ADR9
    
    #define B_ADR9lo_ADR9_MASK          192U
    #define B_ADR9lo_ADR9_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR9        :10;                                      /* ADC Channel 9 Result Bit 0 */
  } Bits;
} B_ADR9STR;
extern volatile B_ADR9STR _B_ADR9 @(REG_BASE + 0x00000298UL);
#define B_ADR9                          _B_ADR9.Word
#define B_ADR9_ADR9                     _B_ADR9.Bits.ADR9

#define B_ADR9_ADR9_MASK                65472U
#define B_ADR9_ADR9_BITNUM              6U


/*** B_ADR10 - ADC Data Result Register 10; 0x0000029A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR10hi - ADC Data Result Register 10 High; 0x0000029A ***/
    union {
      byte Byte;
    } B_ADR10hiSTR;
    #define B_ADR10hi                   _B_ADR10.Overlap_STR.B_ADR10hiSTR.Byte
    

    /*** B_ADR10lo - ADC Data Result Register 10 Low; 0x0000029B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR10       :2;                                       /* ADC Channel 10 Result Bit 0 */
      } Bits;
    } B_ADR10loSTR;
    #define B_ADR10lo                   _B_ADR10.Overlap_STR.B_ADR10loSTR.Byte
    #define B_ADR10lo_ADR10             _B_ADR10.Overlap_STR.B_ADR10loSTR.Bits.ADR10
    
    #define B_ADR10lo_ADR10_MASK        192U
    #define B_ADR10lo_ADR10_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR10       :10;                                      /* ADC Channel 10 Result Bit 0 */
  } Bits;
} B_ADR10STR;
extern volatile B_ADR10STR _B_ADR10 @(REG_BASE + 0x0000029AUL);
#define B_ADR10                         _B_ADR10.Word
#define B_ADR10_ADR10                   _B_ADR10.Bits.ADR10

#define B_ADR10_ADR10_MASK              65472U
#define B_ADR10_ADR10_BITNUM            6U


/*** B_ADR11 - ADC Data Result Register 11; 0x0000029C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR11hi - ADC Data Result Register 11 High; 0x0000029C ***/
    union {
      byte Byte;
    } B_ADR11hiSTR;
    #define B_ADR11hi                   _B_ADR11.Overlap_STR.B_ADR11hiSTR.Byte
    

    /*** B_ADR11lo - ADC Data Result Register 11 Low; 0x0000029D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR11       :2;                                       /* ADC Channel 11 Result Bit 0 */
      } Bits;
    } B_ADR11loSTR;
    #define B_ADR11lo                   _B_ADR11.Overlap_STR.B_ADR11loSTR.Byte
    #define B_ADR11lo_ADR11             _B_ADR11.Overlap_STR.B_ADR11loSTR.Bits.ADR11
    
    #define B_ADR11lo_ADR11_MASK        192U
    #define B_ADR11lo_ADR11_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR11       :10;                                      /* ADC Channel 11 Result Bit 0 */
  } Bits;
} B_ADR11STR;
extern volatile B_ADR11STR _B_ADR11 @(REG_BASE + 0x0000029CUL);
#define B_ADR11                         _B_ADR11.Word
#define B_ADR11_ADR11                   _B_ADR11.Bits.ADR11

#define B_ADR11_ADR11_MASK              65472U
#define B_ADR11_ADR11_BITNUM            6U


/*** B_ADR12 - ADC Data Result Register 12; 0x0000029E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR12hi - ADC Data Result Register 12 High; 0x0000029E ***/
    union {
      byte Byte;
    } B_ADR12hiSTR;
    #define B_ADR12hi                   _B_ADR12.Overlap_STR.B_ADR12hiSTR.Byte
    

    /*** B_ADR12lo - ADC Data Result Register 12 Low; 0x0000029F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR12       :2;                                       /* ADC Channel 12 Result Bit 0 */
      } Bits;
    } B_ADR12loSTR;
    #define B_ADR12lo                   _B_ADR12.Overlap_STR.B_ADR12loSTR.Byte
    #define B_ADR12lo_ADR12             _B_ADR12.Overlap_STR.B_ADR12loSTR.Bits.ADR12
    
    #define B_ADR12lo_ADR12_MASK        192U
    #define B_ADR12lo_ADR12_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR12       :10;                                      /* ADC Channel 12 Result Bit 0 */
  } Bits;
} B_ADR12STR;
extern volatile B_ADR12STR _B_ADR12 @(REG_BASE + 0x0000029EUL);
#define B_ADR12                         _B_ADR12.Word
#define B_ADR12_ADR12                   _B_ADR12.Bits.ADR12

#define B_ADR12_ADR12_MASK              65472U
#define B_ADR12_ADR12_BITNUM            6U


/*** B_ADR13 - ADC Data Result Register 13; 0x000002A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR13hi - ADC Data Result Register 13 High; 0x000002A0 ***/
    union {
      byte Byte;
    } B_ADR13hiSTR;
    #define B_ADR13hi                   _B_ADR13.Overlap_STR.B_ADR13hiSTR.Byte
    

    /*** B_ADR13lo - ADC Data Result Register 13 Low; 0x000002A1 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR13       :2;                                       /* ADC Channel 13 Result Bit 0 */
      } Bits;
    } B_ADR13loSTR;
    #define B_ADR13lo                   _B_ADR13.Overlap_STR.B_ADR13loSTR.Byte
    #define B_ADR13lo_ADR13             _B_ADR13.Overlap_STR.B_ADR13loSTR.Bits.ADR13
    
    #define B_ADR13lo_ADR13_MASK        192U
    #define B_ADR13lo_ADR13_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR13       :10;                                      /* ADC Channel 13 Result Bit 0 */
  } Bits;
} B_ADR13STR;
extern volatile B_ADR13STR _B_ADR13 @(REG_BASE + 0x000002A0UL);
#define B_ADR13                         _B_ADR13.Word
#define B_ADR13_ADR13                   _B_ADR13.Bits.ADR13

#define B_ADR13_ADR13_MASK              65472U
#define B_ADR13_ADR13_BITNUM            6U


/*** B_ADR14 - ADC Data Result Register 14; 0x000002A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR14hi - ADC Data Result Register 14 High; 0x000002A2 ***/
    union {
      byte Byte;
    } B_ADR14hiSTR;
    #define B_ADR14hi                   _B_ADR14.Overlap_STR.B_ADR14hiSTR.Byte
    

    /*** B_ADR14lo - ADC Data Result Register 14 Low; 0x000002A3 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR14       :2;                                       /* ADC Channel 14 Result Bit 0 */
      } Bits;
    } B_ADR14loSTR;
    #define B_ADR14lo                   _B_ADR14.Overlap_STR.B_ADR14loSTR.Byte
    #define B_ADR14lo_ADR14             _B_ADR14.Overlap_STR.B_ADR14loSTR.Bits.ADR14
    
    #define B_ADR14lo_ADR14_MASK        192U
    #define B_ADR14lo_ADR14_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR14       :10;                                      /* ADC Channel 14 Result Bit 0 */
  } Bits;
} B_ADR14STR;
extern volatile B_ADR14STR _B_ADR14 @(REG_BASE + 0x000002A2UL);
#define B_ADR14                         _B_ADR14.Word
#define B_ADR14_ADR14                   _B_ADR14.Bits.ADR14

#define B_ADR14_ADR14_MASK              65472U
#define B_ADR14_ADR14_BITNUM            6U


/*** B_ADR15 - ADC Data Result Register 15; 0x000002A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_ADR15hi - ADC Data Result Register 15 High; 0x000002A4 ***/
    union {
      byte Byte;
    } B_ADR15hiSTR;
    #define B_ADR15hi                   _B_ADR15.Overlap_STR.B_ADR15hiSTR.Byte
    

    /*** B_ADR15lo - ADC Data Result Register 15 Low; 0x000002A5 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR15       :2;                                       /* ADC Channel 15 Result Bit 0 */
      } Bits;
    } B_ADR15loSTR;
    #define B_ADR15lo                   _B_ADR15.Overlap_STR.B_ADR15loSTR.Byte
    #define B_ADR15lo_ADR15             _B_ADR15.Overlap_STR.B_ADR15loSTR.Bits.ADR15
    
    #define B_ADR15lo_ADR15_MASK        192U
    #define B_ADR15lo_ADR15_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR15       :10;                                      /* ADC Channel 15 Result Bit 0 */
  } Bits;
} B_ADR15STR;
extern volatile B_ADR15STR _B_ADR15 @(REG_BASE + 0x000002A4UL);
#define B_ADR15                         _B_ADR15.Word
#define B_ADR15_ADR15                   _B_ADR15.Bits.ADR15

#define B_ADR15_ADR15_MASK              65472U
#define B_ADR15_ADR15_BITNUM            6U


/*** B_TIOS - Timer Input Capture/Output Compare Select; 0x000002C0 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIOS  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_TIOSSTR;
extern volatile B_TIOSSTR _B_TIOS @(REG_BASE + 0x000002C0UL);
#define B_TIOS                          _B_TIOS.Byte
#define B_TIOS_IOS0                     _B_TIOS.Bits.IOS0
#define B_TIOS_IOS1                     _B_TIOS.Bits.IOS1
#define B_TIOS_IOS2                     _B_TIOS.Bits.IOS2
#define B_TIOS_IOS3                     _B_TIOS.Bits.IOS3
#define B_TIOS_IOS                      _B_TIOS.MergedBits.grpIOS

#define B_TIOS_IOS0_MASK                1U
#define B_TIOS_IOS1_MASK                2U
#define B_TIOS_IOS2_MASK                4U
#define B_TIOS_IOS3_MASK                8U
#define B_TIOS_IOS_MASK                 15U
#define B_TIOS_IOS_BITNUM               0U


/*** B_CFORC - Timer Compare Force Register; 0x000002C1 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpFOC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_CFORCSTR;
extern volatile B_CFORCSTR _B_CFORC @(REG_BASE + 0x000002C1UL);
#define B_CFORC                         _B_CFORC.Byte
#define B_CFORC_FOC0                    _B_CFORC.Bits.FOC0
#define B_CFORC_FOC1                    _B_CFORC.Bits.FOC1
#define B_CFORC_FOC2                    _B_CFORC.Bits.FOC2
#define B_CFORC_FOC3                    _B_CFORC.Bits.FOC3
#define B_CFORC_FOC                     _B_CFORC.MergedBits.grpFOC

#define B_CFORC_FOC0_MASK               1U
#define B_CFORC_FOC1_MASK               2U
#define B_CFORC_FOC2_MASK               4U
#define B_CFORC_FOC3_MASK               8U
#define B_CFORC_FOC_MASK                15U
#define B_CFORC_FOC_BITNUM              0U


/*** B_OC3M - Output Compare 3 Mask Register; 0x000002C2 ***/
typedef union {
  byte Byte;
  struct {
    byte OC3M0       :1;                                       /* Output Compare 3 Mask Bit 0 */
    byte OC3M1       :1;                                       /* Output Compare 3 Mask Bit 1 */
    byte OC3M2       :1;                                       /* Output Compare 3 Mask Bit 2 */
    byte OC3M3       :1;                                       /* Output Compare 3 Mask Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOC3M :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_OC3MSTR;
extern volatile B_OC3MSTR _B_OC3M @(REG_BASE + 0x000002C2UL);
#define B_OC3M                          _B_OC3M.Byte
#define B_OC3M_OC3M0                    _B_OC3M.Bits.OC3M0
#define B_OC3M_OC3M1                    _B_OC3M.Bits.OC3M1
#define B_OC3M_OC3M2                    _B_OC3M.Bits.OC3M2
#define B_OC3M_OC3M3                    _B_OC3M.Bits.OC3M3
#define B_OC3M_OC3M                     _B_OC3M.MergedBits.grpOC3M

#define B_OC3M_OC3M0_MASK               1U
#define B_OC3M_OC3M1_MASK               2U
#define B_OC3M_OC3M2_MASK               4U
#define B_OC3M_OC3M3_MASK               8U
#define B_OC3M_OC3M_MASK                15U
#define B_OC3M_OC3M_BITNUM              0U


/*** B_OC3D - Output Compare 3 Data Register; 0x000002C3 ***/
typedef union {
  byte Byte;
  struct {
    byte OC3D0       :1;                                       /* Output Compare 3 Bit 0 */
    byte OC3D1       :1;                                       /* Output Compare 3 Bit 1 */
    byte OC3D2       :1;                                       /* Output Compare 3 Bit 2 */
    byte OC3D3       :1;                                       /* Output Compare 3 Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOC3D :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_OC3DSTR;
extern volatile B_OC3DSTR _B_OC3D @(REG_BASE + 0x000002C3UL);
#define B_OC3D                          _B_OC3D.Byte
#define B_OC3D_OC3D0                    _B_OC3D.Bits.OC3D0
#define B_OC3D_OC3D1                    _B_OC3D.Bits.OC3D1
#define B_OC3D_OC3D2                    _B_OC3D.Bits.OC3D2
#define B_OC3D_OC3D3                    _B_OC3D.Bits.OC3D3
#define B_OC3D_OC3D                     _B_OC3D.MergedBits.grpOC3D

#define B_OC3D_OC3D0_MASK               1U
#define B_OC3D_OC3D1_MASK               2U
#define B_OC3D_OC3D2_MASK               4U
#define B_OC3D_OC3D3_MASK               8U
#define B_OC3D_OC3D_MASK                15U
#define B_OC3D_OC3D_BITNUM              0U


/*** B_TCNT - Timer Count Register; 0x000002C4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TCNTHi - Timer Count Register High; 0x000002C4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Count Register Bit 8 */
        byte BIT9        :1;                                       /* Timer Count Register Bit 9 */
        byte BIT10       :1;                                       /* Timer Count Register Bit 10 */
        byte BIT11       :1;                                       /* Timer Count Register Bit 11 */
        byte BIT12       :1;                                       /* Timer Count Register Bit 12 */
        byte BIT13       :1;                                       /* Timer Count Register Bit 13 */
        byte BIT14       :1;                                       /* Timer Count Register Bit 14 */
        byte BIT15       :1;                                       /* Timer Count Register Bit 15 */
      } Bits;
    } B_TCNTHiSTR;
    #define B_TCNTHi                    _B_TCNT.Overlap_STR.B_TCNTHiSTR.Byte
    #define B_TCNTHi_BIT8               _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT8
    #define B_TCNTHi_BIT9               _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT9
    #define B_TCNTHi_BIT10              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT10
    #define B_TCNTHi_BIT11              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT11
    #define B_TCNTHi_BIT12              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT12
    #define B_TCNTHi_BIT13              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT13
    #define B_TCNTHi_BIT14              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT14
    #define B_TCNTHi_BIT15              _B_TCNT.Overlap_STR.B_TCNTHiSTR.Bits.BIT15
    
    #define B_TCNTHi_BIT8_MASK          1U
    #define B_TCNTHi_BIT9_MASK          2U
    #define B_TCNTHi_BIT10_MASK         4U
    #define B_TCNTHi_BIT11_MASK         8U
    #define B_TCNTHi_BIT12_MASK         16U
    #define B_TCNTHi_BIT13_MASK         32U
    #define B_TCNTHi_BIT14_MASK         64U
    #define B_TCNTHi_BIT15_MASK         128U
    

    /*** B_TCNTLo - Timer Count Register Low; 0x000002C5 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Count Register Bit 0 */
        byte BIT1        :1;                                       /* Timer Count Register Bit 1 */
        byte BIT2        :1;                                       /* Timer Count Register Bit 2 */
        byte BIT3        :1;                                       /* Timer Count Register Bit 3 */
        byte BIT4        :1;                                       /* Timer Count Register Bit 4 */
        byte BIT5        :1;                                       /* Timer Count Register Bit 5 */
        byte BIT6        :1;                                       /* Timer Count Register Bit 6 */
        byte BIT7        :1;                                       /* Timer Count Register Bit 7 */
      } Bits;
    } B_TCNTLoSTR;
    #define B_TCNTLo                    _B_TCNT.Overlap_STR.B_TCNTLoSTR.Byte
    #define B_TCNTLo_BIT0               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT0
    #define B_TCNTLo_BIT1               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT1
    #define B_TCNTLo_BIT2               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT2
    #define B_TCNTLo_BIT3               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT3
    #define B_TCNTLo_BIT4               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT4
    #define B_TCNTLo_BIT5               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT5
    #define B_TCNTLo_BIT6               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT6
    #define B_TCNTLo_BIT7               _B_TCNT.Overlap_STR.B_TCNTLoSTR.Bits.BIT7
    
    #define B_TCNTLo_BIT0_MASK          1U
    #define B_TCNTLo_BIT1_MASK          2U
    #define B_TCNTLo_BIT2_MASK          4U
    #define B_TCNTLo_BIT3_MASK          8U
    #define B_TCNTLo_BIT4_MASK          16U
    #define B_TCNTLo_BIT5_MASK          32U
    #define B_TCNTLo_BIT6_MASK          64U
    #define B_TCNTLo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Count Register Bit 0 */
    word BIT1        :1;                                       /* Timer Count Register Bit 1 */
    word BIT2        :1;                                       /* Timer Count Register Bit 2 */
    word BIT3        :1;                                       /* Timer Count Register Bit 3 */
    word BIT4        :1;                                       /* Timer Count Register Bit 4 */
    word BIT5        :1;                                       /* Timer Count Register Bit 5 */
    word BIT6        :1;                                       /* Timer Count Register Bit 6 */
    word BIT7        :1;                                       /* Timer Count Register Bit 7 */
    word BIT8        :1;                                       /* Timer Count Register Bit 8 */
    word BIT9        :1;                                       /* Timer Count Register Bit 9 */
    word BIT10       :1;                                       /* Timer Count Register Bit 10 */
    word BIT11       :1;                                       /* Timer Count Register Bit 11 */
    word BIT12       :1;                                       /* Timer Count Register Bit 12 */
    word BIT13       :1;                                       /* Timer Count Register Bit 13 */
    word BIT14       :1;                                       /* Timer Count Register Bit 14 */
    word BIT15       :1;                                       /* Timer Count Register Bit 15 */
  } Bits;
} B_TCNTSTR;
extern volatile B_TCNTSTR _B_TCNT @(REG_BASE + 0x000002C4UL);
#define B_TCNT                          _B_TCNT.Word
#define B_TCNT_BIT0                     _B_TCNT.Bits.BIT0
#define B_TCNT_BIT1                     _B_TCNT.Bits.BIT1
#define B_TCNT_BIT2                     _B_TCNT.Bits.BIT2
#define B_TCNT_BIT3                     _B_TCNT.Bits.BIT3
#define B_TCNT_BIT4                     _B_TCNT.Bits.BIT4
#define B_TCNT_BIT5                     _B_TCNT.Bits.BIT5
#define B_TCNT_BIT6                     _B_TCNT.Bits.BIT6
#define B_TCNT_BIT7                     _B_TCNT.Bits.BIT7
#define B_TCNT_BIT8                     _B_TCNT.Bits.BIT8
#define B_TCNT_BIT9                     _B_TCNT.Bits.BIT9
#define B_TCNT_BIT10                    _B_TCNT.Bits.BIT10
#define B_TCNT_BIT11                    _B_TCNT.Bits.BIT11
#define B_TCNT_BIT12                    _B_TCNT.Bits.BIT12
#define B_TCNT_BIT13                    _B_TCNT.Bits.BIT13
#define B_TCNT_BIT14                    _B_TCNT.Bits.BIT14
#define B_TCNT_BIT15                    _B_TCNT.Bits.BIT15

#define B_TCNT_BIT0_MASK                1U
#define B_TCNT_BIT1_MASK                2U
#define B_TCNT_BIT2_MASK                4U
#define B_TCNT_BIT3_MASK                8U
#define B_TCNT_BIT4_MASK                16U
#define B_TCNT_BIT5_MASK                32U
#define B_TCNT_BIT6_MASK                64U
#define B_TCNT_BIT7_MASK                128U
#define B_TCNT_BIT8_MASK                256U
#define B_TCNT_BIT9_MASK                512U
#define B_TCNT_BIT10_MASK               1024U
#define B_TCNT_BIT11_MASK               2048U
#define B_TCNT_BIT12_MASK               4096U
#define B_TCNT_BIT13_MASK               8192U
#define B_TCNT_BIT14_MASK               16384U
#define B_TCNT_BIT15_MASK               32768U


/*** B_TSCR1 - Timer System Control Register1; 0x000002C6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte             :1; 
    byte             :1; 
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} B_TSCR1STR;
extern volatile B_TSCR1STR _B_TSCR1 @(REG_BASE + 0x000002C6UL);
#define B_TSCR1                         _B_TSCR1.Byte
#define B_TSCR1_TFFCA                   _B_TSCR1.Bits.TFFCA
#define B_TSCR1_TEN                     _B_TSCR1.Bits.TEN

#define B_TSCR1_TFFCA_MASK              16U
#define B_TSCR1_TEN_MASK                128U


/*** B_TTOV - Timer Toggle On Overflow Register; 0x000002C7 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTOV  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_TTOVSTR;
extern volatile B_TTOVSTR _B_TTOV @(REG_BASE + 0x000002C7UL);
#define B_TTOV                          _B_TTOV.Byte
#define B_TTOV_TOV0                     _B_TTOV.Bits.TOV0
#define B_TTOV_TOV1                     _B_TTOV.Bits.TOV1
#define B_TTOV_TOV2                     _B_TTOV.Bits.TOV2
#define B_TTOV_TOV3                     _B_TTOV.Bits.TOV3
#define B_TTOV_TOV                      _B_TTOV.MergedBits.grpTOV

#define B_TTOV_TOV0_MASK                1U
#define B_TTOV_TOV1_MASK                2U
#define B_TTOV_TOV2_MASK                4U
#define B_TTOV_TOV3_MASK                8U
#define B_TTOV_TOV_MASK                 15U
#define B_TTOV_TOV_BITNUM               0U


/*** B_TCTL1 - Timer Control Register 1; 0x000002C8 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Lecel Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} B_TCTL1STR;
extern volatile B_TCTL1STR _B_TCTL1 @(REG_BASE + 0x000002C8UL);
#define B_TCTL1                         _B_TCTL1.Byte
#define B_TCTL1_OL0                     _B_TCTL1.Bits.OL0
#define B_TCTL1_OM0                     _B_TCTL1.Bits.OM0
#define B_TCTL1_OL1                     _B_TCTL1.Bits.OL1
#define B_TCTL1_OM1                     _B_TCTL1.Bits.OM1
#define B_TCTL1_OL2                     _B_TCTL1.Bits.OL2
#define B_TCTL1_OM2                     _B_TCTL1.Bits.OM2
#define B_TCTL1_OL3                     _B_TCTL1.Bits.OL3
#define B_TCTL1_OM3                     _B_TCTL1.Bits.OM3

#define B_TCTL1_OL0_MASK                1U
#define B_TCTL1_OM0_MASK                2U
#define B_TCTL1_OL1_MASK                4U
#define B_TCTL1_OM1_MASK                8U
#define B_TCTL1_OL2_MASK                16U
#define B_TCTL1_OM2_MASK                32U
#define B_TCTL1_OL3_MASK                64U
#define B_TCTL1_OM3_MASK                128U


/*** B_TCTL2 - Timer Control Register 2; 0x000002C9 ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge 0 Control A */
    byte EDG0B       :1;                                       /* Input Capture Edge 0 Control B */
    byte EDG1A       :1;                                       /* Input Capture Edge 1 Control A */
    byte EDG1B       :1;                                       /* Input Capture Edge 1 Control B */
    byte EDG2A       :1;                                       /* Input Capture Edge 2 Control A */
    byte EDG2B       :1;                                       /* Input Capture Edge 2 Control B */
    byte EDG3A       :1;                                       /* Input Capture Edge 3 Control A */
    byte EDG3B       :1;                                       /* Input Capture Edge 3 Control B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} B_TCTL2STR;
extern volatile B_TCTL2STR _B_TCTL2 @(REG_BASE + 0x000002C9UL);
#define B_TCTL2                         _B_TCTL2.Byte
#define B_TCTL2_EDG0A                   _B_TCTL2.Bits.EDG0A
#define B_TCTL2_EDG0B                   _B_TCTL2.Bits.EDG0B
#define B_TCTL2_EDG1A                   _B_TCTL2.Bits.EDG1A
#define B_TCTL2_EDG1B                   _B_TCTL2.Bits.EDG1B
#define B_TCTL2_EDG2A                   _B_TCTL2.Bits.EDG2A
#define B_TCTL2_EDG2B                   _B_TCTL2.Bits.EDG2B
#define B_TCTL2_EDG3A                   _B_TCTL2.Bits.EDG3A
#define B_TCTL2_EDG3B                   _B_TCTL2.Bits.EDG3B
#define B_TCTL2_EDG0x                   _B_TCTL2.MergedBits.grpEDG0x
#define B_TCTL2_EDG1x                   _B_TCTL2.MergedBits.grpEDG1x
#define B_TCTL2_EDG2x                   _B_TCTL2.MergedBits.grpEDG2x
#define B_TCTL2_EDG3x                   _B_TCTL2.MergedBits.grpEDG3x

#define B_TCTL2_EDG0A_MASK              1U
#define B_TCTL2_EDG0B_MASK              2U
#define B_TCTL2_EDG1A_MASK              4U
#define B_TCTL2_EDG1B_MASK              8U
#define B_TCTL2_EDG2A_MASK              16U
#define B_TCTL2_EDG2B_MASK              32U
#define B_TCTL2_EDG3A_MASK              64U
#define B_TCTL2_EDG3B_MASK              128U
#define B_TCTL2_EDG0x_MASK              3U
#define B_TCTL2_EDG0x_BITNUM            0U
#define B_TCTL2_EDG1x_MASK              12U
#define B_TCTL2_EDG1x_BITNUM            2U
#define B_TCTL2_EDG2x_MASK              48U
#define B_TCTL2_EDG2x_BITNUM            4U
#define B_TCTL2_EDG3x_MASK              192U
#define B_TCTL2_EDG3x_BITNUM            6U


/*** B_TIE - Timer Interrupt Enable Register; 0x000002CA ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_TIESTR;
extern volatile B_TIESTR _B_TIE @(REG_BASE + 0x000002CAUL);
#define B_TIE                           _B_TIE.Byte
#define B_TIE_C0I                       _B_TIE.Bits.C0I
#define B_TIE_C1I                       _B_TIE.Bits.C1I
#define B_TIE_C2I                       _B_TIE.Bits.C2I
#define B_TIE_C3I                       _B_TIE.Bits.C3I

#define B_TIE_C0I_MASK                  1U
#define B_TIE_C1I_MASK                  2U
#define B_TIE_C2I_MASK                  4U
#define B_TIE_C3I_MASK                  8U


/*** B_TSCR2 - Timer System Control Register 2; 0x000002CB ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_TSCR2STR;
extern volatile B_TSCR2STR _B_TSCR2 @(REG_BASE + 0x000002CBUL);
#define B_TSCR2                         _B_TSCR2.Byte
#define B_TSCR2_PR0                     _B_TSCR2.Bits.PR0
#define B_TSCR2_PR1                     _B_TSCR2.Bits.PR1
#define B_TSCR2_PR2                     _B_TSCR2.Bits.PR2
#define B_TSCR2_TCRE                    _B_TSCR2.Bits.TCRE
#define B_TSCR2_TOI                     _B_TSCR2.Bits.TOI
#define B_TSCR2_PR                      _B_TSCR2.MergedBits.grpPR

#define B_TSCR2_PR0_MASK                1U
#define B_TSCR2_PR1_MASK                2U
#define B_TSCR2_PR2_MASK                4U
#define B_TSCR2_TCRE_MASK               8U
#define B_TSCR2_TOI_MASK                128U
#define B_TSCR2_PR_MASK                 7U
#define B_TSCR2_PR_BITNUM               0U


/*** B_TFLG1 - Main Timer Interrupt Flag 1; 0x000002CC ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_TFLG1STR;
extern volatile B_TFLG1STR _B_TFLG1 @(REG_BASE + 0x000002CCUL);
#define B_TFLG1                         _B_TFLG1.Byte
#define B_TFLG1_C0F                     _B_TFLG1.Bits.C0F
#define B_TFLG1_C1F                     _B_TFLG1.Bits.C1F
#define B_TFLG1_C2F                     _B_TFLG1.Bits.C2F
#define B_TFLG1_C3F                     _B_TFLG1.Bits.C3F

#define B_TFLG1_C0F_MASK                1U
#define B_TFLG1_C1F_MASK                2U
#define B_TFLG1_C2F_MASK                4U
#define B_TFLG1_C3F_MASK                8U


/*** B_TFLG2 - Main Timer Interrupt Flag 2; 0x000002CD ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} B_TFLG2STR;
extern volatile B_TFLG2STR _B_TFLG2 @(REG_BASE + 0x000002CDUL);
#define B_TFLG2                         _B_TFLG2.Byte
#define B_TFLG2_TOF                     _B_TFLG2.Bits.TOF

#define B_TFLG2_TOF_MASK                128U


/*** B_TC0 - Timer Input Capture/Output Compare Register 0; 0x000002CE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000002CE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 15 */
      } Bits;
    } B_TC0HiSTR;
    #define B_TC0Hi                     _B_TC0.Overlap_STR.B_TC0HiSTR.Byte
    #define B_TC0Hi_BIT8                _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT8
    #define B_TC0Hi_BIT9                _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT9
    #define B_TC0Hi_BIT10               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT10
    #define B_TC0Hi_BIT11               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT11
    #define B_TC0Hi_BIT12               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT12
    #define B_TC0Hi_BIT13               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT13
    #define B_TC0Hi_BIT14               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT14
    #define B_TC0Hi_BIT15               _B_TC0.Overlap_STR.B_TC0HiSTR.Bits.BIT15
    
    #define B_TC0Hi_BIT8_MASK           1U
    #define B_TC0Hi_BIT9_MASK           2U
    #define B_TC0Hi_BIT10_MASK          4U
    #define B_TC0Hi_BIT11_MASK          8U
    #define B_TC0Hi_BIT12_MASK          16U
    #define B_TC0Hi_BIT13_MASK          32U
    #define B_TC0Hi_BIT14_MASK          64U
    #define B_TC0Hi_BIT15_MASK          128U
    

    /*** B_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000002CF ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 7 */
      } Bits;
    } B_TC0LoSTR;
    #define B_TC0Lo                     _B_TC0.Overlap_STR.B_TC0LoSTR.Byte
    #define B_TC0Lo_BIT0                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT0
    #define B_TC0Lo_BIT1                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT1
    #define B_TC0Lo_BIT2                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT2
    #define B_TC0Lo_BIT3                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT3
    #define B_TC0Lo_BIT4                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT4
    #define B_TC0Lo_BIT5                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT5
    #define B_TC0Lo_BIT6                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT6
    #define B_TC0Lo_BIT7                _B_TC0.Overlap_STR.B_TC0LoSTR.Bits.BIT7
    
    #define B_TC0Lo_BIT0_MASK           1U
    #define B_TC0Lo_BIT1_MASK           2U
    #define B_TC0Lo_BIT2_MASK           4U
    #define B_TC0Lo_BIT3_MASK           8U
    #define B_TC0Lo_BIT4_MASK           16U
    #define B_TC0Lo_BIT5_MASK           32U
    #define B_TC0Lo_BIT6_MASK           64U
    #define B_TC0Lo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 15 */
  } Bits;
} B_TC0STR;
extern volatile B_TC0STR _B_TC0 @(REG_BASE + 0x000002CEUL);
#define B_TC0                           _B_TC0.Word
#define B_TC0_BIT0                      _B_TC0.Bits.BIT0
#define B_TC0_BIT1                      _B_TC0.Bits.BIT1
#define B_TC0_BIT2                      _B_TC0.Bits.BIT2
#define B_TC0_BIT3                      _B_TC0.Bits.BIT3
#define B_TC0_BIT4                      _B_TC0.Bits.BIT4
#define B_TC0_BIT5                      _B_TC0.Bits.BIT5
#define B_TC0_BIT6                      _B_TC0.Bits.BIT6
#define B_TC0_BIT7                      _B_TC0.Bits.BIT7
#define B_TC0_BIT8                      _B_TC0.Bits.BIT8
#define B_TC0_BIT9                      _B_TC0.Bits.BIT9
#define B_TC0_BIT10                     _B_TC0.Bits.BIT10
#define B_TC0_BIT11                     _B_TC0.Bits.BIT11
#define B_TC0_BIT12                     _B_TC0.Bits.BIT12
#define B_TC0_BIT13                     _B_TC0.Bits.BIT13
#define B_TC0_BIT14                     _B_TC0.Bits.BIT14
#define B_TC0_BIT15                     _B_TC0.Bits.BIT15
/* B_TC_ARR: Access 4 B_TCx registers in an array */
#define B_TC_ARR                        ((volatile word *) &B_TC0)

#define B_TC0_BIT0_MASK                 1U
#define B_TC0_BIT1_MASK                 2U
#define B_TC0_BIT2_MASK                 4U
#define B_TC0_BIT3_MASK                 8U
#define B_TC0_BIT4_MASK                 16U
#define B_TC0_BIT5_MASK                 32U
#define B_TC0_BIT6_MASK                 64U
#define B_TC0_BIT7_MASK                 128U
#define B_TC0_BIT8_MASK                 256U
#define B_TC0_BIT9_MASK                 512U
#define B_TC0_BIT10_MASK                1024U
#define B_TC0_BIT11_MASK                2048U
#define B_TC0_BIT12_MASK                4096U
#define B_TC0_BIT13_MASK                8192U
#define B_TC0_BIT14_MASK                16384U
#define B_TC0_BIT15_MASK                32768U


/*** B_TC1 - Timer Input Capture/Output Compare Register 1; 0x000002D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000002D0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 15 */
      } Bits;
    } B_TC1HiSTR;
    #define B_TC1Hi                     _B_TC1.Overlap_STR.B_TC1HiSTR.Byte
    #define B_TC1Hi_BIT8                _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT8
    #define B_TC1Hi_BIT9                _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT9
    #define B_TC1Hi_BIT10               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT10
    #define B_TC1Hi_BIT11               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT11
    #define B_TC1Hi_BIT12               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT12
    #define B_TC1Hi_BIT13               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT13
    #define B_TC1Hi_BIT14               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT14
    #define B_TC1Hi_BIT15               _B_TC1.Overlap_STR.B_TC1HiSTR.Bits.BIT15
    
    #define B_TC1Hi_BIT8_MASK           1U
    #define B_TC1Hi_BIT9_MASK           2U
    #define B_TC1Hi_BIT10_MASK          4U
    #define B_TC1Hi_BIT11_MASK          8U
    #define B_TC1Hi_BIT12_MASK          16U
    #define B_TC1Hi_BIT13_MASK          32U
    #define B_TC1Hi_BIT14_MASK          64U
    #define B_TC1Hi_BIT15_MASK          128U
    

    /*** B_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000002D1 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 7 */
      } Bits;
    } B_TC1LoSTR;
    #define B_TC1Lo                     _B_TC1.Overlap_STR.B_TC1LoSTR.Byte
    #define B_TC1Lo_BIT0                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT0
    #define B_TC1Lo_BIT1                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT1
    #define B_TC1Lo_BIT2                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT2
    #define B_TC1Lo_BIT3                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT3
    #define B_TC1Lo_BIT4                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT4
    #define B_TC1Lo_BIT5                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT5
    #define B_TC1Lo_BIT6                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT6
    #define B_TC1Lo_BIT7                _B_TC1.Overlap_STR.B_TC1LoSTR.Bits.BIT7
    
    #define B_TC1Lo_BIT0_MASK           1U
    #define B_TC1Lo_BIT1_MASK           2U
    #define B_TC1Lo_BIT2_MASK           4U
    #define B_TC1Lo_BIT3_MASK           8U
    #define B_TC1Lo_BIT4_MASK           16U
    #define B_TC1Lo_BIT5_MASK           32U
    #define B_TC1Lo_BIT6_MASK           64U
    #define B_TC1Lo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 15 */
  } Bits;
} B_TC1STR;
extern volatile B_TC1STR _B_TC1 @(REG_BASE + 0x000002D0UL);
#define B_TC1                           _B_TC1.Word
#define B_TC1_BIT0                      _B_TC1.Bits.BIT0
#define B_TC1_BIT1                      _B_TC1.Bits.BIT1
#define B_TC1_BIT2                      _B_TC1.Bits.BIT2
#define B_TC1_BIT3                      _B_TC1.Bits.BIT3
#define B_TC1_BIT4                      _B_TC1.Bits.BIT4
#define B_TC1_BIT5                      _B_TC1.Bits.BIT5
#define B_TC1_BIT6                      _B_TC1.Bits.BIT6
#define B_TC1_BIT7                      _B_TC1.Bits.BIT7
#define B_TC1_BIT8                      _B_TC1.Bits.BIT8
#define B_TC1_BIT9                      _B_TC1.Bits.BIT9
#define B_TC1_BIT10                     _B_TC1.Bits.BIT10
#define B_TC1_BIT11                     _B_TC1.Bits.BIT11
#define B_TC1_BIT12                     _B_TC1.Bits.BIT12
#define B_TC1_BIT13                     _B_TC1.Bits.BIT13
#define B_TC1_BIT14                     _B_TC1.Bits.BIT14
#define B_TC1_BIT15                     _B_TC1.Bits.BIT15

#define B_TC1_BIT0_MASK                 1U
#define B_TC1_BIT1_MASK                 2U
#define B_TC1_BIT2_MASK                 4U
#define B_TC1_BIT3_MASK                 8U
#define B_TC1_BIT4_MASK                 16U
#define B_TC1_BIT5_MASK                 32U
#define B_TC1_BIT6_MASK                 64U
#define B_TC1_BIT7_MASK                 128U
#define B_TC1_BIT8_MASK                 256U
#define B_TC1_BIT9_MASK                 512U
#define B_TC1_BIT10_MASK                1024U
#define B_TC1_BIT11_MASK                2048U
#define B_TC1_BIT12_MASK                4096U
#define B_TC1_BIT13_MASK                8192U
#define B_TC1_BIT14_MASK                16384U
#define B_TC1_BIT15_MASK                32768U


/*** B_TC2 - Timer Input Capture/Output Compare Register 2; 0x000002D2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000002D2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 15 */
      } Bits;
    } B_TC2HiSTR;
    #define B_TC2Hi                     _B_TC2.Overlap_STR.B_TC2HiSTR.Byte
    #define B_TC2Hi_BIT8                _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT8
    #define B_TC2Hi_BIT9                _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT9
    #define B_TC2Hi_BIT10               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT10
    #define B_TC2Hi_BIT11               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT11
    #define B_TC2Hi_BIT12               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT12
    #define B_TC2Hi_BIT13               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT13
    #define B_TC2Hi_BIT14               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT14
    #define B_TC2Hi_BIT15               _B_TC2.Overlap_STR.B_TC2HiSTR.Bits.BIT15
    
    #define B_TC2Hi_BIT8_MASK           1U
    #define B_TC2Hi_BIT9_MASK           2U
    #define B_TC2Hi_BIT10_MASK          4U
    #define B_TC2Hi_BIT11_MASK          8U
    #define B_TC2Hi_BIT12_MASK          16U
    #define B_TC2Hi_BIT13_MASK          32U
    #define B_TC2Hi_BIT14_MASK          64U
    #define B_TC2Hi_BIT15_MASK          128U
    

    /*** B_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000002D3 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 7 */
      } Bits;
    } B_TC2LoSTR;
    #define B_TC2Lo                     _B_TC2.Overlap_STR.B_TC2LoSTR.Byte
    #define B_TC2Lo_BIT0                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT0
    #define B_TC2Lo_BIT1                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT1
    #define B_TC2Lo_BIT2                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT2
    #define B_TC2Lo_BIT3                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT3
    #define B_TC2Lo_BIT4                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT4
    #define B_TC2Lo_BIT5                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT5
    #define B_TC2Lo_BIT6                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT6
    #define B_TC2Lo_BIT7                _B_TC2.Overlap_STR.B_TC2LoSTR.Bits.BIT7
    
    #define B_TC2Lo_BIT0_MASK           1U
    #define B_TC2Lo_BIT1_MASK           2U
    #define B_TC2Lo_BIT2_MASK           4U
    #define B_TC2Lo_BIT3_MASK           8U
    #define B_TC2Lo_BIT4_MASK           16U
    #define B_TC2Lo_BIT5_MASK           32U
    #define B_TC2Lo_BIT6_MASK           64U
    #define B_TC2Lo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 15 */
  } Bits;
} B_TC2STR;
extern volatile B_TC2STR _B_TC2 @(REG_BASE + 0x000002D2UL);
#define B_TC2                           _B_TC2.Word
#define B_TC2_BIT0                      _B_TC2.Bits.BIT0
#define B_TC2_BIT1                      _B_TC2.Bits.BIT1
#define B_TC2_BIT2                      _B_TC2.Bits.BIT2
#define B_TC2_BIT3                      _B_TC2.Bits.BIT3
#define B_TC2_BIT4                      _B_TC2.Bits.BIT4
#define B_TC2_BIT5                      _B_TC2.Bits.BIT5
#define B_TC2_BIT6                      _B_TC2.Bits.BIT6
#define B_TC2_BIT7                      _B_TC2.Bits.BIT7
#define B_TC2_BIT8                      _B_TC2.Bits.BIT8
#define B_TC2_BIT9                      _B_TC2.Bits.BIT9
#define B_TC2_BIT10                     _B_TC2.Bits.BIT10
#define B_TC2_BIT11                     _B_TC2.Bits.BIT11
#define B_TC2_BIT12                     _B_TC2.Bits.BIT12
#define B_TC2_BIT13                     _B_TC2.Bits.BIT13
#define B_TC2_BIT14                     _B_TC2.Bits.BIT14
#define B_TC2_BIT15                     _B_TC2.Bits.BIT15

#define B_TC2_BIT0_MASK                 1U
#define B_TC2_BIT1_MASK                 2U
#define B_TC2_BIT2_MASK                 4U
#define B_TC2_BIT3_MASK                 8U
#define B_TC2_BIT4_MASK                 16U
#define B_TC2_BIT5_MASK                 32U
#define B_TC2_BIT6_MASK                 64U
#define B_TC2_BIT7_MASK                 128U
#define B_TC2_BIT8_MASK                 256U
#define B_TC2_BIT9_MASK                 512U
#define B_TC2_BIT10_MASK                1024U
#define B_TC2_BIT11_MASK                2048U
#define B_TC2_BIT12_MASK                4096U
#define B_TC2_BIT13_MASK                8192U
#define B_TC2_BIT14_MASK                16384U
#define B_TC2_BIT15_MASK                32768U


/*** B_TC3 - Timer Input Capture/Output Compare Register 3; 0x000002D4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** B_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000002D4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 15 */
      } Bits;
    } B_TC3HiSTR;
    #define B_TC3Hi                     _B_TC3.Overlap_STR.B_TC3HiSTR.Byte
    #define B_TC3Hi_BIT8                _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT8
    #define B_TC3Hi_BIT9                _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT9
    #define B_TC3Hi_BIT10               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT10
    #define B_TC3Hi_BIT11               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT11
    #define B_TC3Hi_BIT12               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT12
    #define B_TC3Hi_BIT13               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT13
    #define B_TC3Hi_BIT14               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT14
    #define B_TC3Hi_BIT15               _B_TC3.Overlap_STR.B_TC3HiSTR.Bits.BIT15
    
    #define B_TC3Hi_BIT8_MASK           1U
    #define B_TC3Hi_BIT9_MASK           2U
    #define B_TC3Hi_BIT10_MASK          4U
    #define B_TC3Hi_BIT11_MASK          8U
    #define B_TC3Hi_BIT12_MASK          16U
    #define B_TC3Hi_BIT13_MASK          32U
    #define B_TC3Hi_BIT14_MASK          64U
    #define B_TC3Hi_BIT15_MASK          128U
    

    /*** B_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000002D5 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 7 */
      } Bits;
    } B_TC3LoSTR;
    #define B_TC3Lo                     _B_TC3.Overlap_STR.B_TC3LoSTR.Byte
    #define B_TC3Lo_BIT0                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT0
    #define B_TC3Lo_BIT1                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT1
    #define B_TC3Lo_BIT2                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT2
    #define B_TC3Lo_BIT3                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT3
    #define B_TC3Lo_BIT4                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT4
    #define B_TC3Lo_BIT5                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT5
    #define B_TC3Lo_BIT6                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT6
    #define B_TC3Lo_BIT7                _B_TC3.Overlap_STR.B_TC3LoSTR.Bits.BIT7
    
    #define B_TC3Lo_BIT0_MASK           1U
    #define B_TC3Lo_BIT1_MASK           2U
    #define B_TC3Lo_BIT2_MASK           4U
    #define B_TC3Lo_BIT3_MASK           8U
    #define B_TC3Lo_BIT4_MASK           16U
    #define B_TC3Lo_BIT5_MASK           32U
    #define B_TC3Lo_BIT6_MASK           64U
    #define B_TC3Lo_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 15 */
  } Bits;
} B_TC3STR;
extern volatile B_TC3STR _B_TC3 @(REG_BASE + 0x000002D4UL);
#define B_TC3                           _B_TC3.Word
#define B_TC3_BIT0                      _B_TC3.Bits.BIT0
#define B_TC3_BIT1                      _B_TC3.Bits.BIT1
#define B_TC3_BIT2                      _B_TC3.Bits.BIT2
#define B_TC3_BIT3                      _B_TC3.Bits.BIT3
#define B_TC3_BIT4                      _B_TC3.Bits.BIT4
#define B_TC3_BIT5                      _B_TC3.Bits.BIT5
#define B_TC3_BIT6                      _B_TC3.Bits.BIT6
#define B_TC3_BIT7                      _B_TC3.Bits.BIT7
#define B_TC3_BIT8                      _B_TC3.Bits.BIT8
#define B_TC3_BIT9                      _B_TC3.Bits.BIT9
#define B_TC3_BIT10                     _B_TC3.Bits.BIT10
#define B_TC3_BIT11                     _B_TC3.Bits.BIT11
#define B_TC3_BIT12                     _B_TC3.Bits.BIT12
#define B_TC3_BIT13                     _B_TC3.Bits.BIT13
#define B_TC3_BIT14                     _B_TC3.Bits.BIT14
#define B_TC3_BIT15                     _B_TC3.Bits.BIT15

#define B_TC3_BIT0_MASK                 1U
#define B_TC3_BIT1_MASK                 2U
#define B_TC3_BIT2_MASK                 4U
#define B_TC3_BIT3_MASK                 8U
#define B_TC3_BIT4_MASK                 16U
#define B_TC3_BIT5_MASK                 32U
#define B_TC3_BIT6_MASK                 64U
#define B_TC3_BIT7_MASK                 128U
#define B_TC3_BIT8_MASK                 256U
#define B_TC3_BIT9_MASK                 512U
#define B_TC3_BIT10_MASK                1024U
#define B_TC3_BIT11_MASK                2048U
#define B_TC3_BIT12_MASK                4096U
#define B_TC3_BIT13_MASK                8192U
#define B_TC3_BIT14_MASK                16384U
#define B_TC3_BIT15_MASK                32768U


/*** B_CTR0 - Trimming Register 0; 0x000002F0 ***/
typedef union {
  byte Byte;
  struct {
    byte WDCTR       :3;                                       /* Watchdog clock trim 0 */
    byte CTR0_3      :1;                                       /* Spare Trim bit 3 */
    byte CTR0_4      :1;                                       /* Spare Trim bit 4 */
    byte WDCTRE      :1;                                       /* Watchdog trim enable */
    byte LINTR       :1;                                       /* LIN trim bit */
    byte LINTRE      :1;                                       /* LIN trim enable */
  } Bits;
  struct {
    byte         :3;
    byte grpCTR0__3 :2;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} B_CTR0STR;
extern volatile B_CTR0STR _B_CTR0 @(REG_BASE + 0x000002F0UL);
#define B_CTR0                          _B_CTR0.Byte
#define B_CTR0_WDCTR                    _B_CTR0.Bits.WDCTR
#define B_CTR0_CTR0_3                   _B_CTR0.Bits.CTR0_3
#define B_CTR0_CTR0_4                   _B_CTR0.Bits.CTR0_4
#define B_CTR0_WDCTRE                   _B_CTR0.Bits.WDCTRE
#define B_CTR0_LINTR                    _B_CTR0.Bits.LINTR
#define B_CTR0_LINTRE                   _B_CTR0.Bits.LINTRE
/* B_CTR_ARR: Access 4 B_CTRx registers in an array */
#define B_CTR_ARR                       ((volatile byte *) &B_CTR0)
#define B_CTR0_CTR0__3                  _B_CTR0.MergedBits.grpCTR0__3
#define B_CTR0_CTR0_                    B_CTR0_CTR0__3

#define B_CTR0_WDCTR_MASK               7U
#define B_CTR0_WDCTR_BITNUM             0U
#define B_CTR0_CTR0_3_MASK              8U
#define B_CTR0_CTR0_4_MASK              16U
#define B_CTR0_WDCTRE_MASK              32U
#define B_CTR0_LINTR_MASK               64U
#define B_CTR0_LINTRE_MASK              128U
#define B_CTR0_CTR0__3_MASK             24U
#define B_CTR0_CTR0__3_BITNUM           3U


/*** B_CTR1 - Trimming Register 1; 0x000002F1 ***/
typedef union {
  byte Byte;
  struct {
    byte IREFTR      :3;                                       /* Iref trim 0 */
    byte IREFTRE     :1;                                       /* Iref trim enable bit */
    byte BGTRIMDN    :1;                                       /* Bandgap trim down bit */
    byte BGTRIMUP    :1;                                       /* Bandgap trim up bit */
    byte CTR1_6      :1;                                       /* Spare Trim Bit */
    byte BGTRE       :1;                                       /* Bandgap trim enable */
  } Bits;
} B_CTR1STR;
extern volatile B_CTR1STR _B_CTR1 @(REG_BASE + 0x000002F1UL);
#define B_CTR1                          _B_CTR1.Byte
#define B_CTR1_IREFTR                   _B_CTR1.Bits.IREFTR
#define B_CTR1_IREFTRE                  _B_CTR1.Bits.IREFTRE
#define B_CTR1_BGTRIMDN                 _B_CTR1.Bits.BGTRIMDN
#define B_CTR1_BGTRIMUP                 _B_CTR1.Bits.BGTRIMUP
#define B_CTR1_CTR1_6                   _B_CTR1.Bits.CTR1_6
#define B_CTR1_BGTRE                    _B_CTR1.Bits.BGTRE

#define B_CTR1_IREFTR_MASK              7U
#define B_CTR1_IREFTR_BITNUM            0U
#define B_CTR1_IREFTRE_MASK             8U
#define B_CTR1_BGTRIMDN_MASK            16U
#define B_CTR1_BGTRIMUP_MASK            32U
#define B_CTR1_CTR1_6_MASK              64U
#define B_CTR1_BGTRE_MASK               128U


/*** B_CTR2 - Trimming Register 2; 0x000002F2 ***/
typedef union {
  byte Byte;
  struct {
    byte SLPBGTR     :3;                                       /* bg1p25sleep trim 0 */
    byte SLPBG_LOCK  :1;                                       /* bg1p25sleep trim lock bit */
    byte SLPBGTRE    :1;                                       /* Sleep Bandgap trim enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_CTR2STR;
extern volatile B_CTR2STR _B_CTR2 @(REG_BASE + 0x000002F2UL);
#define B_CTR2                          _B_CTR2.Byte
#define B_CTR2_SLPBGTR                  _B_CTR2.Bits.SLPBGTR
#define B_CTR2_SLPBG_LOCK               _B_CTR2.Bits.SLPBG_LOCK
#define B_CTR2_SLPBGTRE                 _B_CTR2.Bits.SLPBGTRE

#define B_CTR2_SLPBGTR_MASK             7U
#define B_CTR2_SLPBGTR_BITNUM           0U
#define B_CTR2_SLPBG_LOCK_MASK          8U
#define B_CTR2_SLPBGTRE_MASK            16U


/*** B_CTR3 - Trimming Register 3; 0x000002F3 ***/
typedef union {
  byte Byte;
  struct {
    byte CTR3_0      :1;                                       /* Spare Trim bit 0 */
    byte CTR3_1      :1;                                       /* Spare Trim bit 1 */
    byte CTR3_2      :1;                                       /* Spare Trim bit 2 */
    byte CTR3_E      :1;                                       /* Spare Trim enable bit */
    byte OFFCTR      :3;                                       /* ADCOFFC trim 0 */
    byte OFFCTRE     :1;                                       /* ADC offset compensation voltage trim enable bit */
  } Bits;
  struct {
    byte grpCTR3 :3;
    byte         :1;
    byte         :3;
    byte         :1;
  } MergedBits;
} B_CTR3STR;
extern volatile B_CTR3STR _B_CTR3 @(REG_BASE + 0x000002F3UL);
#define B_CTR3                          _B_CTR3.Byte
#define B_CTR3_CTR3_0                   _B_CTR3.Bits.CTR3_0
#define B_CTR3_CTR3_1                   _B_CTR3.Bits.CTR3_1
#define B_CTR3_CTR3_2                   _B_CTR3.Bits.CTR3_2
#define B_CTR3_CTR3_E                   _B_CTR3.Bits.CTR3_E
#define B_CTR3_OFFCTR                   _B_CTR3.Bits.OFFCTR
#define B_CTR3_OFFCTRE                  _B_CTR3.Bits.OFFCTRE
#define B_CTR3_CTR3                     _B_CTR3.MergedBits.grpCTR3

#define B_CTR3_CTR3_0_MASK              1U
#define B_CTR3_CTR3_1_MASK              2U
#define B_CTR3_CTR3_2_MASK              4U
#define B_CTR3_CTR3_E_MASK              8U
#define B_CTR3_OFFCTR_MASK              112U
#define B_CTR3_OFFCTR_BITNUM            4U
#define B_CTR3_OFFCTRE_MASK             128U
#define B_CTR3_CTR3_MASK                7U
#define B_CTR3_CTR3_BITNUM              0U


/*** B_SRR - Silicon Revision Register; 0x000002F4 ***/
typedef union {
  byte Byte;
  struct {
    byte MMREV       :2;                                       /* MM912F634 analog die Silicon Revision Register Metal Tweak Revision */
    byte FMREV       :2;                                       /* MM912F634 analog die Silicon Revision Register Full Mask Revision */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} B_SRRSTR;
extern volatile B_SRRSTR _B_SRR @(REG_BASE + 0x000002F4UL);
#define B_SRR                           _B_SRR.Byte
#define B_SRR_MMREV                     _B_SRR.Bits.MMREV
#define B_SRR_FMREV                     _B_SRR.Bits.FMREV

#define B_SRR_MMREV_MASK                3U
#define B_SRR_MMREV_BITNUM              0U
#define B_SRR_FMREV_MASK                12U
#define B_SRR_FMREV_BITNUM              2U


/*** NB_ISR - Interrupt Source Register; 0x00000300 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ISRhi - Interrupt Source Register High; 0x00000300 ***/
    union {
      byte Byte;
      struct {
        byte RX          :1;                                       /* SCI Receive Interrupt */
        byte SCI         :1;                                       /* ADC Sequence Complete Interrupt */
        byte LINOT       :1;                                       /* LIN Driver Over-temperature Interrupt */
        byte HSOT        :1;                                       /* High Side Over-temperature Interrupt */
        byte LSOT        :1;                                       /* Low Side Over-temperature Interrupt */
        byte HOT         :1;                                       /* HSUP Over-temperature Interrupt */
        byte             :1; 
        byte             :1; 
      } Bits;
    } NB_ISRhiSTR;
    #define NB_ISRhi                    _NB_ISR.Overlap_STR.NB_ISRhiSTR.Byte
    #define NB_ISRhi_RX                 _NB_ISR.Overlap_STR.NB_ISRhiSTR.Bits.RX
    #define NB_ISRhi_SCI                _NB_ISR.Overlap_STR.NB_ISRhiSTR.Bits.SCI
    #define NB_ISRhi_LINOT              _NB_ISR.Overlap_STR.NB_ISRhiSTR.Bits.LINOT
    #define NB_ISRhi_HSOT               _NB_ISR.Overlap_STR.NB_ISRhiSTR.Bits.HSOT
    #define NB_ISRhi_LSOT               _NB_ISR.Overlap_STR.NB_ISRhiSTR.Bits.LSOT
    #define NB_ISRhi_HOT                _NB_ISR.Overlap_STR.NB_ISRhiSTR.Bits.HOT
    
    #define NB_ISRhi_RX_MASK            1U
    #define NB_ISRhi_SCI_MASK           2U
    #define NB_ISRhi_LINOT_MASK         4U
    #define NB_ISRhi_HSOT_MASK          8U
    #define NB_ISRhi_LSOT_MASK          16U
    #define NB_ISRhi_HOT_MASK           32U
    

    /*** NB_ISRlo - Interrupt Source Register Low; 0x00000301 ***/
    union {
      byte Byte;
      struct {
        byte VSI         :1;                                       /* Voltage Status Interrupt */
        byte CH0         :1;                                       /* TIM Channel 0 Interrupt */
        byte CH1         :1;                                       /* TIM Channel 1 Interrupt */
        byte CH2         :1;                                       /* TIM Channel 2 Interrupt */
        byte CH3         :1;                                       /* TIM Channel 3 Interrupt */
        byte TOV         :1;                                       /* Timer Overflow Interrupt */
        byte ERR         :1;                                       /* SCI Error Interrupt */
        byte TX          :1;                                       /* SCI Transmit Interrupt */
      } Bits;
      struct {
        byte     :1;
        byte grpCH :4;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } NB_ISRloSTR;
    #define NB_ISRlo                    _NB_ISR.Overlap_STR.NB_ISRloSTR.Byte
    #define NB_ISRlo_VSI                _NB_ISR.Overlap_STR.NB_ISRloSTR.Bits.VSI
    #define NB_ISRlo_CH0                _NB_ISR.Overlap_STR.NB_ISRloSTR.Bits.CH0
    #define NB_ISRlo_CH1                _NB_ISR.Overlap_STR.NB_ISRloSTR.Bits.CH1
    #define NB_ISRlo_CH2                _NB_ISR.Overlap_STR.NB_ISRloSTR.Bits.CH2
    #define NB_ISRlo_CH3                _NB_ISR.Overlap_STR.NB_ISRloSTR.Bits.CH3
    #define NB_ISRlo_TOV                _NB_ISR.Overlap_STR.NB_ISRloSTR.Bits.TOV
    #define NB_ISRlo_ERR                _NB_ISR.Overlap_STR.NB_ISRloSTR.Bits.ERR
    #define NB_ISRlo_TX                 _NB_ISR.Overlap_STR.NB_ISRloSTR.Bits.TX
    #define NB_ISRlo_CH                 _NB_ISR.Overlap_STR.NB_ISRloSTR.MergedBits.grpCH
    
    #define NB_ISRlo_VSI_MASK           1U
    #define NB_ISRlo_CH0_MASK           2U
    #define NB_ISRlo_CH1_MASK           4U
    #define NB_ISRlo_CH2_MASK           8U
    #define NB_ISRlo_CH3_MASK           16U
    #define NB_ISRlo_TOV_MASK           32U
    #define NB_ISRlo_ERR_MASK           64U
    #define NB_ISRlo_TX_MASK            128U
    #define NB_ISRlo_CH_MASK            30U
    #define NB_ISRlo_CH_BITNUM          1U
    
  } Overlap_STR;

  struct {
    word VSI         :1;                                       /* Voltage Status Interrupt */
    word CH0         :1;                                       /* TIM Channel 0 Interrupt */
    word CH1         :1;                                       /* TIM Channel 1 Interrupt */
    word CH2         :1;                                       /* TIM Channel 2 Interrupt */
    word CH3         :1;                                       /* TIM Channel 3 Interrupt */
    word TOV         :1;                                       /* Timer Overflow Interrupt */
    word ERR         :1;                                       /* SCI Error Interrupt */
    word TX          :1;                                       /* SCI Transmit Interrupt */
    word RX          :1;                                       /* SCI Receive Interrupt */
    word SCI         :1;                                       /* ADC Sequence Complete Interrupt */
    word LINOT       :1;                                       /* LIN Driver Over-temperature Interrupt */
    word HSOT        :1;                                       /* High Side Over-temperature Interrupt */
    word LSOT        :1;                                       /* Low Side Over-temperature Interrupt */
    word HOT         :1;                                       /* HSUP Over-temperature Interrupt */
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word         :1;
    word grpCH   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} NB_ISRSTR;
extern volatile NB_ISRSTR _NB_ISR @(REG_BASE + 0x00000300UL);
#define NB_ISR                          _NB_ISR.Word
#define NB_ISR_VSI                      _NB_ISR.Bits.VSI
#define NB_ISR_CH0                      _NB_ISR.Bits.CH0
#define NB_ISR_CH1                      _NB_ISR.Bits.CH1
#define NB_ISR_CH2                      _NB_ISR.Bits.CH2
#define NB_ISR_CH3                      _NB_ISR.Bits.CH3
#define NB_ISR_TOV                      _NB_ISR.Bits.TOV
#define NB_ISR_ERR                      _NB_ISR.Bits.ERR
#define NB_ISR_TX                       _NB_ISR.Bits.TX
#define NB_ISR_RX                       _NB_ISR.Bits.RX
#define NB_ISR_SCI                      _NB_ISR.Bits.SCI
#define NB_ISR_LINOT                    _NB_ISR.Bits.LINOT
#define NB_ISR_HSOT                     _NB_ISR.Bits.HSOT
#define NB_ISR_LSOT                     _NB_ISR.Bits.LSOT
#define NB_ISR_HOT                      _NB_ISR.Bits.HOT
#define NB_ISR_CH                       _NB_ISR.MergedBits.grpCH

#define NB_ISR_VSI_MASK                 1U
#define NB_ISR_CH0_MASK                 2U
#define NB_ISR_CH1_MASK                 4U
#define NB_ISR_CH2_MASK                 8U
#define NB_ISR_CH3_MASK                 16U
#define NB_ISR_TOV_MASK                 32U
#define NB_ISR_ERR_MASK                 64U
#define NB_ISR_TX_MASK                  128U
#define NB_ISR_RX_MASK                  256U
#define NB_ISR_SCI_MASK                 512U
#define NB_ISR_LINOT_MASK               1024U
#define NB_ISR_HSOT_MASK                2048U
#define NB_ISR_LSOT_MASK                4096U
#define NB_ISR_HOT_MASK                 8192U
#define NB_ISR_CH_MASK                  30U
#define NB_ISR_CH_BITNUM                1U


/*** NB_IVR - Interrupt Vector Register; 0x00000302 ***/
typedef union {
  byte Byte;
  struct {
    byte IRQ         :6;                                       /* Represents the highest prioritized interrupt pending */
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_IVRSTR;
extern volatile NB_IVRSTR _NB_IVR @(REG_BASE + 0x00000302UL);
#define NB_IVR                          _NB_IVR.Byte
#define NB_IVR_IRQ                      _NB_IVR.Bits.IRQ

#define NB_IVR_IRQ_MASK                 63U
#define NB_IVR_IRQ_BITNUM               0U


/*** NB_VCR - Voltage Control Register; 0x00000304 ***/
typedef union {
  byte Byte;
  struct {
    byte LBIE        :1;                                       /* Low Battery Interrupt Enable */
    byte LVIE        :1;                                       /* Low Voltage Interrupt Enable */
    byte HVIE        :1;                                       /* High Voltage Interrupt Enable */
    byte HTIE        :1;                                       /* High Temperature Interrupt Enable */
    byte VROVIE      :1;                                       /* Voltage Regulator Over-voltage Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_VCRSTR;
extern volatile NB_VCRSTR _NB_VCR @(REG_BASE + 0x00000304UL);
#define NB_VCR                          _NB_VCR.Byte
#define NB_VCR_LBIE                     _NB_VCR.Bits.LBIE
#define NB_VCR_LVIE                     _NB_VCR.Bits.LVIE
#define NB_VCR_HVIE                     _NB_VCR.Bits.HVIE
#define NB_VCR_HTIE                     _NB_VCR.Bits.HTIE
#define NB_VCR_VROVIE                   _NB_VCR.Bits.VROVIE

#define NB_VCR_LBIE_MASK                1U
#define NB_VCR_LVIE_MASK                2U
#define NB_VCR_HVIE_MASK                4U
#define NB_VCR_HTIE_MASK                8U
#define NB_VCR_VROVIE_MASK              16U


/*** NB_VSR - Voltage Status Register; 0x00000305 ***/
typedef union {
  byte Byte;
  struct {
    byte LBC         :1;                                       /* Low Battery Condition */
    byte LVC         :1;                                       /* Low Voltage Condition */
    byte HVC         :1;                                       /* High Voltage Condition */
    byte HTC         :1;                                       /* High Temperature Condition */
    byte VROVC       :1;                                       /* Voltage Regulator Over-voltage Condition */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_VSRSTR;
extern volatile NB_VSRSTR _NB_VSR @(REG_BASE + 0x00000305UL);
#define NB_VSR                          _NB_VSR.Byte
#define NB_VSR_LBC                      _NB_VSR.Bits.LBC
#define NB_VSR_LVC                      _NB_VSR.Bits.LVC
#define NB_VSR_HVC                      _NB_VSR.Bits.HVC
#define NB_VSR_HTC                      _NB_VSR.Bits.HTC
#define NB_VSR_VROVC                    _NB_VSR.Bits.VROVC

#define NB_VSR_LBC_MASK                 1U
#define NB_VSR_LVC_MASK                 2U
#define NB_VSR_HVC_MASK                 4U
#define NB_VSR_HTC_MASK                 8U
#define NB_VSR_VROVC_MASK               16U


/*** NB_LXR - Lx Status Register; 0x00000308 ***/
typedef union {
  byte Byte;
  struct {
    byte L0          :1;                                       /* Current Digital State of the L0 Input */
    byte L1          :1;                                       /* Current Digital State of the L1 Input */
    byte L2          :1;                                       /* Current Digital State of the L2 Input */
    byte L3          :1;                                       /* Current Digital State of the L3 Input */
    byte L4          :1;                                       /* Current Digital State of the L4 Input */
    byte L5          :1;                                       /* Current Digital State of the L5 Input */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpL    :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_LXRSTR;
extern volatile NB_LXRSTR _NB_LXR @(REG_BASE + 0x00000308UL);
#define NB_LXR                          _NB_LXR.Byte
#define NB_LXR_L0                       _NB_LXR.Bits.L0
#define NB_LXR_L1                       _NB_LXR.Bits.L1
#define NB_LXR_L2                       _NB_LXR.Bits.L2
#define NB_LXR_L3                       _NB_LXR.Bits.L3
#define NB_LXR_L4                       _NB_LXR.Bits.L4
#define NB_LXR_L5                       _NB_LXR.Bits.L5
#define NB_LXR_L                        _NB_LXR.MergedBits.grpL

#define NB_LXR_L0_MASK                  1U
#define NB_LXR_L1_MASK                  2U
#define NB_LXR_L2_MASK                  4U
#define NB_LXR_L3_MASK                  8U
#define NB_LXR_L4_MASK                  16U
#define NB_LXR_L5_MASK                  32U
#define NB_LXR_L_MASK                   63U
#define NB_LXR_L_BITNUM                 0U


/*** NB_LXCR - Lx Control Register; 0x00000309 ***/
typedef union {
  byte Byte;
  struct {
    byte L0DS        :1;                                       /* Analog Input Divider Ratio Selection - L0 */
    byte L1DS        :1;                                       /* Analog Input Divider Ratio Selection - L1 */
    byte L2DS        :1;                                       /* Analog Input Divider Ratio Selection - L2 */
    byte L3DS        :1;                                       /* Analog Input Divider Ratio Selection - L3 */
    byte L4DS        :1;                                       /* Analog Input Divider Ratio Selection - L4 */
    byte L5DS        :1;                                       /* Analog Input Divider Ratio Selection - L5 */
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_LXCRSTR;
extern volatile NB_LXCRSTR _NB_LXCR @(REG_BASE + 0x00000309UL);
#define NB_LXCR                         _NB_LXCR.Byte
#define NB_LXCR_L0DS                    _NB_LXCR.Bits.L0DS
#define NB_LXCR_L1DS                    _NB_LXCR.Bits.L1DS
#define NB_LXCR_L2DS                    _NB_LXCR.Bits.L2DS
#define NB_LXCR_L3DS                    _NB_LXCR.Bits.L3DS
#define NB_LXCR_L4DS                    _NB_LXCR.Bits.L4DS
#define NB_LXCR_L5DS                    _NB_LXCR.Bits.L5DS

#define NB_LXCR_L0DS_MASK               1U
#define NB_LXCR_L1DS_MASK               2U
#define NB_LXCR_L2DS_MASK               4U
#define NB_LXCR_L3DS_MASK               8U
#define NB_LXCR_L4DS_MASK               16U
#define NB_LXCR_L5DS_MASK               32U


/*** NB_WDR - Watchdog Register; 0x00000310 ***/
typedef union {
  byte Byte;
  struct {
    byte WDTO        :3;                                       /* Watchdog Timeout Configuration Bit 0 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte WDWO        :1;                                       /* Watchdog Window Open */
    byte WDOFF       :1;                                       /* Watchdog Off */
  } Bits;
} NB_WDRSTR;
extern volatile NB_WDRSTR _NB_WDR @(REG_BASE + 0x00000310UL);
#define NB_WDR                          _NB_WDR.Byte
#define NB_WDR_WDTO                     _NB_WDR.Bits.WDTO
#define NB_WDR_WDWO                     _NB_WDR.Bits.WDWO
#define NB_WDR_WDOFF                    _NB_WDR.Bits.WDOFF

#define NB_WDR_WDTO_MASK                7U
#define NB_WDR_WDTO_BITNUM              0U
#define NB_WDR_WDWO_MASK                64U
#define NB_WDR_WDOFF_MASK               128U


/*** NB_WDSR - Watchdog Service Register; 0x00000311 ***/
typedef union {
  byte Byte;
} NB_WDSRSTR;
extern volatile NB_WDSRSTR _NB_WDSR @(REG_BASE + 0x00000311UL);
#define NB_WDSR                         _NB_WDSR.Byte


/*** NB_WCR - Wake-up Control Register; 0x00000312 ***/
typedef union {
  byte Byte;
  struct {
    byte L0WE        :1;                                       /* Wake-up Input 0 Enabled */
    byte L1WE        :1;                                       /* Wake-up Input 1 Enabled */
    byte L2WE        :1;                                       /* Wake-up Input 2 Enabled */
    byte L3WE        :1;                                       /* Wake-up Input 3 Enabled */
    byte L4WE        :1;                                       /* Wake-up Input 4 Enabled */
    byte L5WE        :1;                                       /* Wake-up Input 5 Enabled */
    byte CSSEL       :2;                                       /* Cyclic Sense Select Bit 0 */
  } Bits;
} NB_WCRSTR;
extern volatile NB_WCRSTR _NB_WCR @(REG_BASE + 0x00000312UL);
#define NB_WCR                          _NB_WCR.Byte
#define NB_WCR_L0WE                     _NB_WCR.Bits.L0WE
#define NB_WCR_L1WE                     _NB_WCR.Bits.L1WE
#define NB_WCR_L2WE                     _NB_WCR.Bits.L2WE
#define NB_WCR_L3WE                     _NB_WCR.Bits.L3WE
#define NB_WCR_L4WE                     _NB_WCR.Bits.L4WE
#define NB_WCR_L5WE                     _NB_WCR.Bits.L5WE
#define NB_WCR_CSSEL                    _NB_WCR.Bits.CSSEL

#define NB_WCR_L0WE_MASK                1U
#define NB_WCR_L1WE_MASK                2U
#define NB_WCR_L2WE_MASK                4U
#define NB_WCR_L3WE_MASK                8U
#define NB_WCR_L4WE_MASK                16U
#define NB_WCR_L5WE_MASK                32U
#define NB_WCR_CSSEL_MASK               192U
#define NB_WCR_CSSEL_BITNUM             6U


/*** NB_TCR - Timing Control Register; 0x00000313 ***/
typedef union {
  byte Byte;
  struct {
    byte CST         :4;                                       /* Cyclic Sense Timing Bit 0 */
    byte FWM         :4;                                       /* Forced Wake-up Multiplicator Bit 0 */
  } Bits;
} NB_TCRSTR;
extern volatile NB_TCRSTR _NB_TCR @(REG_BASE + 0x00000313UL);
#define NB_TCR                          _NB_TCR.Byte
#define NB_TCR_CST                      _NB_TCR.Bits.CST
#define NB_TCR_FWM                      _NB_TCR.Bits.FWM

#define NB_TCR_CST_MASK                 15U
#define NB_TCR_CST_BITNUM               0U
#define NB_TCR_FWM_MASK                 240U
#define NB_TCR_FWM_BITNUM               4U


/*** NB_WSR - Wake-up Source Register; 0x00000314 ***/
typedef union {
  byte Byte;
  struct {
    byte L0WU        :1;                                       /* L0 Wake-upe-up */
    byte L1WU        :1;                                       /* L1 Wake-upp */
    byte L2WU        :1;                                       /* L2 Wake-up */
    byte L3WU        :1;                                       /* L3 Wake-up */
    byte L4WU        :1;                                       /* L4 Wake-up */
    byte L5WU        :1;                                       /* L5 Wake-up */
    byte LINWU       :1;                                       /* LIN Wake-up */
    byte FWU         :1;                                       /* Forced Wake-up */
  } Bits;
} NB_WSRSTR;
extern volatile NB_WSRSTR _NB_WSR @(REG_BASE + 0x00000314UL);
#define NB_WSR                          _NB_WSR.Byte
#define NB_WSR_L0WU                     _NB_WSR.Bits.L0WU
#define NB_WSR_L1WU                     _NB_WSR.Bits.L1WU
#define NB_WSR_L2WU                     _NB_WSR.Bits.L2WU
#define NB_WSR_L3WU                     _NB_WSR.Bits.L3WU
#define NB_WSR_L4WU                     _NB_WSR.Bits.L4WU
#define NB_WSR_L5WU                     _NB_WSR.Bits.L5WU
#define NB_WSR_LINWU                    _NB_WSR.Bits.LINWU
#define NB_WSR_FWU                      _NB_WSR.Bits.FWU

#define NB_WSR_L0WU_MASK                1U
#define NB_WSR_L1WU_MASK                2U
#define NB_WSR_L2WU_MASK                4U
#define NB_WSR_L3WU_MASK                8U
#define NB_WSR_L4WU_MASK                16U
#define NB_WSR_L5WU_MASK                32U
#define NB_WSR_LINWU_MASK               64U
#define NB_WSR_FWU_MASK                 128U


/*** NB_RSR - Reset Status Register; 0x00000315 ***/
typedef union {
  byte Byte;
  struct {
    byte POR         :1;                                       /* Power On Reset */
    byte LVR         :1;                                       /* Low Voltage Reset VDD */
    byte LVRX        :1;                                       /* Low Voltage Reset VDDX */
    byte WUR         :1;                                       /* Wake-up Reset */
    byte EXR         :1;                                       /* External Reset */
    byte WDR         :1;                                       /* Watchdog Reset */
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_RSRSTR;
extern volatile NB_RSRSTR _NB_RSR @(REG_BASE + 0x00000315UL);
#define NB_RSR                          _NB_RSR.Byte
#define NB_RSR_POR                      _NB_RSR.Bits.POR
#define NB_RSR_LVR                      _NB_RSR.Bits.LVR
#define NB_RSR_LVRX                     _NB_RSR.Bits.LVRX
#define NB_RSR_WUR                      _NB_RSR.Bits.WUR
#define NB_RSR_EXR                      _NB_RSR.Bits.EXR
#define NB_RSR_WDR                      _NB_RSR.Bits.WDR

#define NB_RSR_POR_MASK                 1U
#define NB_RSR_LVR_MASK                 2U
#define NB_RSR_LVRX_MASK                4U
#define NB_RSR_WUR_MASK                 8U
#define NB_RSR_EXR_MASK                 16U
#define NB_RSR_WDR_MASK                 32U


/*** NB_MCR - Mode Control Register; 0x00000316 ***/
typedef union {
  byte Byte;
  struct {
    byte MODE_grp    :2;                                       /* Mode Select bit 0 */ /*Warning: group name is duplicated with register name*/
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_MCRSTR;
extern volatile NB_MCRSTR _NB_MCR @(REG_BASE + 0x00000316UL);
#define NB_MCR                          _NB_MCR.Byte
#define NB_MCR_MODE                     _NB_MCR.Bits.MODE_grp

#define NB_MCR_MODE_MASK                3U
#define NB_MCR_MODE_BITNUM              0U


/*** NB_LINR - LIN Register; 0x00000318 ***/
typedef union {
  byte Byte;
  struct {
    byte LINSR       :2;                                       /* LIN - Slew Rate Select 0 */
    byte LINEN       :1;                                       /* LIN Module Enable */
    byte LVSD        :1;                                       /* LIN - Low Voltage Shutdown Disable (J2602 Compliance Control) */
    byte TX          :1;                                       /* LIN - Direct Transmitter Control */
    byte RX          :1;                                       /* LIN - Receiver (Rx) Status */
    byte LINOTC      :1;                                       /* LIN - Over-temperature condition present */
    byte LINOTIE     :1;                                       /* LIN - Over-temperature Interrupt Enable */
  } Bits;
} NB_LINRSTR;
extern volatile NB_LINRSTR _NB_LINR @(REG_BASE + 0x00000318UL);
#define NB_LINR                         _NB_LINR.Byte
#define NB_LINR_LINSR                   _NB_LINR.Bits.LINSR
#define NB_LINR_LINEN                   _NB_LINR.Bits.LINEN
#define NB_LINR_LVSD                    _NB_LINR.Bits.LVSD
#define NB_LINR_TX                      _NB_LINR.Bits.TX
#define NB_LINR_RX                      _NB_LINR.Bits.RX
#define NB_LINR_LINOTC                  _NB_LINR.Bits.LINOTC
#define NB_LINR_LINOTIE                 _NB_LINR.Bits.LINOTIE

#define NB_LINR_LINSR_MASK              3U
#define NB_LINR_LINSR_BITNUM            0U
#define NB_LINR_LINEN_MASK              4U
#define NB_LINR_LVSD_MASK               8U
#define NB_LINR_TX_MASK                 16U
#define NB_LINR_RX_MASK                 32U
#define NB_LINR_LINOTC_MASK             64U
#define NB_LINR_LINOTIE_MASK            128U


/*** NB_PTBC1 - Port B Configuration Register 1; 0x00000320 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRB0       :1;                                       /* Data Direction Port B 0 */
    byte DDRB1       :1;                                       /* Data Direction Port B 0 */
    byte DDRB2       :1;                                       /* Data Direction Port B 0 */
    byte             :1; 
    byte PUEB0       :1;                                       /* Pull-up Enable Port B 0 */
    byte PUEB1       :1;                                       /* Pull-up Enable Port B 0 */
    byte PUEB2       :1;                                       /* Pull-up Enable Port B 0 */
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRB :3;
    byte         :1;
    byte grpPUEB :3;
    byte         :1;
  } MergedBits;
} NB_PTBC1STR;
extern volatile NB_PTBC1STR _NB_PTBC1 @(REG_BASE + 0x00000320UL);
#define NB_PTBC1                        _NB_PTBC1.Byte
#define NB_PTBC1_DDRB0                  _NB_PTBC1.Bits.DDRB0
#define NB_PTBC1_DDRB1                  _NB_PTBC1.Bits.DDRB1
#define NB_PTBC1_DDRB2                  _NB_PTBC1.Bits.DDRB2
#define NB_PTBC1_PUEB0                  _NB_PTBC1.Bits.PUEB0
#define NB_PTBC1_PUEB1                  _NB_PTBC1.Bits.PUEB1
#define NB_PTBC1_PUEB2                  _NB_PTBC1.Bits.PUEB2
#define NB_PTBC1_DDRB                   _NB_PTBC1.MergedBits.grpDDRB
#define NB_PTBC1_PUEB                   _NB_PTBC1.MergedBits.grpPUEB

#define NB_PTBC1_DDRB0_MASK             1U
#define NB_PTBC1_DDRB1_MASK             2U
#define NB_PTBC1_DDRB2_MASK             4U
#define NB_PTBC1_PUEB0_MASK             16U
#define NB_PTBC1_PUEB1_MASK             32U
#define NB_PTBC1_PUEB2_MASK             64U
#define NB_PTBC1_DDRB_MASK              7U
#define NB_PTBC1_DDRB_BITNUM            0U
#define NB_PTBC1_PUEB_MASK              112U
#define NB_PTBC1_PUEB_BITNUM            4U


/*** NB_PTBC2 - Port B Configuration Register 2; 0x00000321 ***/
typedef union {
  byte Byte;
  struct {
    byte SERMOD      :2;                                       /* Serial Mode Select for PTB 0 */
    byte PWMEN       :1;                                       /* PWM Enable for PTB2 */
    byte PWMCS       :1;                                       /* PWM Channel Select PTB2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_PTBC2STR;
extern volatile NB_PTBC2STR _NB_PTBC2 @(REG_BASE + 0x00000321UL);
#define NB_PTBC2                        _NB_PTBC2.Byte
#define NB_PTBC2_SERMOD                 _NB_PTBC2.Bits.SERMOD
#define NB_PTBC2_PWMEN                  _NB_PTBC2.Bits.PWMEN
#define NB_PTBC2_PWMCS                  _NB_PTBC2.Bits.PWMCS

#define NB_PTBC2_SERMOD_MASK            3U
#define NB_PTBC2_SERMOD_BITNUM          0U
#define NB_PTBC2_PWMEN_MASK             4U
#define NB_PTBC2_PWMCS_MASK             8U


/*** NB_PTB - Port B Data Register; 0x00000322 ***/
typedef union {
  byte Byte;
  struct {
    byte PTB0        :1;                                       /* Port B general purpose input/output data 0 */
    byte PTB1        :1;                                       /* Port B general purpose input/output data 1 */
    byte PTB2        :1;                                       /* Port B general purpose input/output data 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTB  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_PTBSTR;
extern volatile NB_PTBSTR _NB_PTB @(REG_BASE + 0x00000322UL);
#define NB_PTB                          _NB_PTB.Byte
#define NB_PTB_PTB0                     _NB_PTB.Bits.PTB0
#define NB_PTB_PTB1                     _NB_PTB.Bits.PTB1
#define NB_PTB_PTB2                     _NB_PTB.Bits.PTB2
#define NB_PTB_PTB                      _NB_PTB.MergedBits.grpPTB

#define NB_PTB_PTB0_MASK                1U
#define NB_PTB_PTB1_MASK                2U
#define NB_PTB_PTB2_MASK                4U
#define NB_PTB_PTB_MASK                 7U
#define NB_PTB_PTB_BITNUM               0U


/*** NB_HSCR - High Side Control Register; 0x00000328 ***/
typedef union {
  byte Byte;
  struct {
    byte HS1         :1;                                       /* HS2 Control */
    byte HS2         :1;                                       /* HS2 Control */
    byte PWMHS1      :1;                                       /* PWM Enable for HS1 */
    byte PWMHS2      :1;                                       /* PWM Enable for HS2 */
    byte PWMCS1      :1;                                       /* PWM Channel Select HS1 */
    byte PWMCS2      :1;                                       /* PWM Channel Select HS2 */
    byte HSHVSDE     :1;                                       /* High Side High Voltage Shutdown */
    byte HSOTIE      :1;                                       /* High Side Over-temperature Interrupt Enable */
  } Bits;
  struct {
    byte grpHS_1 :2;
    byte grpPWMHS_1 :2;
    byte grpPWMCS_1 :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_HSCRSTR;
extern volatile NB_HSCRSTR _NB_HSCR @(REG_BASE + 0x00000328UL);
#define NB_HSCR                         _NB_HSCR.Byte
#define NB_HSCR_HS1                     _NB_HSCR.Bits.HS1
#define NB_HSCR_HS2                     _NB_HSCR.Bits.HS2
#define NB_HSCR_PWMHS1                  _NB_HSCR.Bits.PWMHS1
#define NB_HSCR_PWMHS2                  _NB_HSCR.Bits.PWMHS2
#define NB_HSCR_PWMCS1                  _NB_HSCR.Bits.PWMCS1
#define NB_HSCR_PWMCS2                  _NB_HSCR.Bits.PWMCS2
#define NB_HSCR_HSHVSDE                 _NB_HSCR.Bits.HSHVSDE
#define NB_HSCR_HSOTIE                  _NB_HSCR.Bits.HSOTIE
#define NB_HSCR_HS_1                    _NB_HSCR.MergedBits.grpHS_1
#define NB_HSCR_PWMHS_1                 _NB_HSCR.MergedBits.grpPWMHS_1
#define NB_HSCR_PWMCS_1                 _NB_HSCR.MergedBits.grpPWMCS_1
#define NB_HSCR_HS                      NB_HSCR_HS_1
#define NB_HSCR_PWMHS                   NB_HSCR_PWMHS_1
#define NB_HSCR_PWMCS                   NB_HSCR_PWMCS_1

#define NB_HSCR_HS1_MASK                1U
#define NB_HSCR_HS2_MASK                2U
#define NB_HSCR_PWMHS1_MASK             4U
#define NB_HSCR_PWMHS2_MASK             8U
#define NB_HSCR_PWMCS1_MASK             16U
#define NB_HSCR_PWMCS2_MASK             32U
#define NB_HSCR_HSHVSDE_MASK            64U
#define NB_HSCR_HSOTIE_MASK             128U
#define NB_HSCR_HS_1_MASK               3U
#define NB_HSCR_HS_1_BITNUM             0U
#define NB_HSCR_PWMHS_1_MASK            12U
#define NB_HSCR_PWMHS_1_BITNUM          2U
#define NB_HSCR_PWMCS_1_MASK            48U
#define NB_HSCR_PWMCS_1_BITNUM          4U


/*** NB_HSSR - High Side Status Register; 0x00000329 ***/
typedef union {
  byte Byte;
  struct {
    byte HS1OL       :1;                                       /* High Side 1Open Load */
    byte HS2OL       :1;                                       /* High Side 2 Open Load */
    byte HS1CL       :1;                                       /* High Side 1 Current Limitation */
    byte HS2CL       :1;                                       /* High Side 2 Current Limitation */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte HSOTC       :1;                                       /* High Side Over-temperature Condition */
  } Bits;
} NB_HSSRSTR;
extern volatile NB_HSSRSTR _NB_HSSR @(REG_BASE + 0x00000329UL);
#define NB_HSSR                         _NB_HSSR.Byte
#define NB_HSSR_HS1OL                   _NB_HSSR.Bits.HS1OL
#define NB_HSSR_HS2OL                   _NB_HSSR.Bits.HS2OL
#define NB_HSSR_HS1CL                   _NB_HSSR.Bits.HS1CL
#define NB_HSSR_HS2CL                   _NB_HSSR.Bits.HS2CL
#define NB_HSSR_HSOTC                   _NB_HSSR.Bits.HSOTC

#define NB_HSSR_HS1OL_MASK              1U
#define NB_HSSR_HS2OL_MASK              2U
#define NB_HSSR_HS1CL_MASK              4U
#define NB_HSSR_HS2CL_MASK              8U
#define NB_HSSR_HSOTC_MASK              128U


/*** NB_LSCR - Low Side Control Register; 0x00000330 ***/
typedef union {
  byte Byte;
  struct {
    byte LS1         :1;                                       /* LS1 Enable */
    byte LS2         :1;                                       /* LS2 Enable */
    byte PWMLS1      :1;                                       /* PWM Enable for LS1 */
    byte PWMLS2      :1;                                       /* PWM Enable for LS2 */
    byte PWMCS1      :1;                                       /* PWM Channel Select LS1 */
    byte PWMCS2      :1;                                       /* PWM Channel Select LS2 */
    byte             :1; 
    byte LSOTIE      :1;                                       /* Low Side Over-temperature Interrupt Enable */
  } Bits;
  struct {
    byte grpLS_1 :2;
    byte grpPWMLS_1 :2;
    byte grpPWMCS_1 :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_LSCRSTR;
extern volatile NB_LSCRSTR _NB_LSCR @(REG_BASE + 0x00000330UL);
#define NB_LSCR                         _NB_LSCR.Byte
#define NB_LSCR_LS1                     _NB_LSCR.Bits.LS1
#define NB_LSCR_LS2                     _NB_LSCR.Bits.LS2
#define NB_LSCR_PWMLS1                  _NB_LSCR.Bits.PWMLS1
#define NB_LSCR_PWMLS2                  _NB_LSCR.Bits.PWMLS2
#define NB_LSCR_PWMCS1                  _NB_LSCR.Bits.PWMCS1
#define NB_LSCR_PWMCS2                  _NB_LSCR.Bits.PWMCS2
#define NB_LSCR_LSOTIE                  _NB_LSCR.Bits.LSOTIE
#define NB_LSCR_LS_1                    _NB_LSCR.MergedBits.grpLS_1
#define NB_LSCR_PWMLS_1                 _NB_LSCR.MergedBits.grpPWMLS_1
#define NB_LSCR_PWMCS_1                 _NB_LSCR.MergedBits.grpPWMCS_1
#define NB_LSCR_LS                      NB_LSCR_LS_1
#define NB_LSCR_PWMLS                   NB_LSCR_PWMLS_1
#define NB_LSCR_PWMCS                   NB_LSCR_PWMCS_1

#define NB_LSCR_LS1_MASK                1U
#define NB_LSCR_LS2_MASK                2U
#define NB_LSCR_PWMLS1_MASK             4U
#define NB_LSCR_PWMLS2_MASK             8U
#define NB_LSCR_PWMCS1_MASK             16U
#define NB_LSCR_PWMCS2_MASK             32U
#define NB_LSCR_LSOTIE_MASK             128U
#define NB_LSCR_LS_1_MASK               3U
#define NB_LSCR_LS_1_BITNUM             0U
#define NB_LSCR_PWMLS_1_MASK            12U
#define NB_LSCR_PWMLS_1_BITNUM          2U
#define NB_LSCR_PWMCS_1_MASK            48U
#define NB_LSCR_PWMCS_1_BITNUM          4U


/*** NB_LSSR - Low Side Status Register; 0x00000331 ***/
typedef union {
  byte Byte;
  struct {
    byte LS1OL       :1;                                       /* Low Side 1 Open Load */
    byte LS2OL       :1;                                       /* Low Side 2 Open Load */
    byte LS1CL       :1;                                       /* Low Side 1 Current Limitation */
    byte LS2CL       :1;                                       /* Low Side 2 Current Limitation */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LSOTC       :1;                                       /* Low Side Over-temperature condition present */
  } Bits;
} NB_LSSRSTR;
extern volatile NB_LSSRSTR _NB_LSSR @(REG_BASE + 0x00000331UL);
#define NB_LSSR                         _NB_LSSR.Byte
#define NB_LSSR_LS1OL                   _NB_LSSR.Bits.LS1OL
#define NB_LSSR_LS2OL                   _NB_LSSR.Bits.LS2OL
#define NB_LSSR_LS1CL                   _NB_LSSR.Bits.LS1CL
#define NB_LSSR_LS2CL                   _NB_LSSR.Bits.LS2CL
#define NB_LSSR_LSOTC                   _NB_LSSR.Bits.LSOTC

#define NB_LSSR_LS1OL_MASK              1U
#define NB_LSSR_LS2OL_MASK              2U
#define NB_LSSR_LS1CL_MASK              4U
#define NB_LSSR_LS2CL_MASK              8U
#define NB_LSSR_LSOTC_MASK              128U


/*** NB_LSCEN - Low Side Control Enable Register; 0x00000332 ***/
typedef union {
  byte Byte;
  struct {
    byte LSCEN       :4;                                       /* Low Side Control Enable Bit 0 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_LSCENSTR;
extern volatile NB_LSCENSTR _NB_LSCEN @(REG_BASE + 0x00000332UL);
#define NB_LSCEN                        _NB_LSCEN.Byte
#define NB_LSCEN_LSCEN                  _NB_LSCEN.Bits.LSCEN

#define NB_LSCEN_LSCEN_MASK             15U
#define NB_LSCEN_LSCEN_BITNUM           0U


/*** NB_HSR - Hall Supply Register; 0x00000338 ***/
typedef union {
  byte Byte;
  struct {
    byte HSUPON      :1;                                       /* Hall Supply On */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte HOTC        :1;                                       /* Hall Supply Over-temperature Condition */
    byte HOTIE       :1;                                       /* Hall Supply Over-temperature Interrupt Enable */
  } Bits;
} NB_HSRSTR;
extern volatile NB_HSRSTR _NB_HSR @(REG_BASE + 0x00000338UL);
#define NB_HSR                          _NB_HSR.Byte
#define NB_HSR_HSUPON                   _NB_HSR.Bits.HSUPON
#define NB_HSR_HOTC                     _NB_HSR.Bits.HOTC
#define NB_HSR_HOTIE                    _NB_HSR.Bits.HOTIE

#define NB_HSR_HSUPON_MASK              1U
#define NB_HSR_HOTC_MASK                64U
#define NB_HSR_HOTIE_MASK               128U


/*** NB_CSR - Current Sense Register; 0x0000033C ***/
typedef union {
  byte Byte;
  struct {
    byte CSGS        :3;                                       /* Current Sense Gain Select 0 */
    byte CCD         :1;                                       /* Input Filter Charge Compensation Disable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte CSE         :1;                                       /* Current Sense Enable Bit */
  } Bits;
} NB_CSRSTR;
extern volatile NB_CSRSTR _NB_CSR @(REG_BASE + 0x0000033CUL);
#define NB_CSR                          _NB_CSR.Byte
#define NB_CSR_CSGS                     _NB_CSR.Bits.CSGS
#define NB_CSR_CCD                      _NB_CSR.Bits.CCD
#define NB_CSR_CSE                      _NB_CSR.Bits.CSE

#define NB_CSR_CSGS_MASK                7U
#define NB_CSR_CSGS_BITNUM              0U
#define NB_CSR_CCD_MASK                 8U
#define NB_CSR_CSE_MASK                 128U


/*** NB_SCIBD - SCI Baud Rate Register; 0x00000340 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_SCIBDH - SCI Baud Rate Register High; 0x00000340 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
        byte SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
        byte SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
        byte SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
        byte SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
        byte             :1; 
        byte RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
        byte LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } NB_SCIBDHSTR;
    #define NB_SCIBDH                   _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Byte
    #define NB_SCIBDH_SBR8              _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR8
    #define NB_SCIBDH_SBR9              _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR9
    #define NB_SCIBDH_SBR10             _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR10
    #define NB_SCIBDH_SBR11             _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR11
    #define NB_SCIBDH_SBR12             _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.SBR12
    #define NB_SCIBDH_RXEDGIE           _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.RXEDGIE
    #define NB_SCIBDH_LBKDIE            _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.Bits.LBKDIE
    #define NB_SCIBDH_SBR_8             _NB_SCIBD.Overlap_STR.NB_SCIBDHSTR.MergedBits.grpSBR_8
    #define NB_SCIBDH_SBR               NB_SCIBDH_SBR_8
    
    #define NB_SCIBDH_SBR8_MASK         1U
    #define NB_SCIBDH_SBR9_MASK         2U
    #define NB_SCIBDH_SBR10_MASK        4U
    #define NB_SCIBDH_SBR11_MASK        8U
    #define NB_SCIBDH_SBR12_MASK        16U
    #define NB_SCIBDH_RXEDGIE_MASK      64U
    #define NB_SCIBDH_LBKDIE_MASK       128U
    #define NB_SCIBDH_SBR_8_MASK        31U
    #define NB_SCIBDH_SBR_8_BITNUM      0U
    

    /*** NB_SCIBDL - SCI Baud Rate Register Low; 0x00000341 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
        byte SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
        byte SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
        byte SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
        byte SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
        byte SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
        byte SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
        byte SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
      } Bits;
    } NB_SCIBDLSTR;
    #define NB_SCIBDL                   _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Byte
    #define NB_SCIBDL_SBR0              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR0
    #define NB_SCIBDL_SBR1              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR1
    #define NB_SCIBDL_SBR2              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR2
    #define NB_SCIBDL_SBR3              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR3
    #define NB_SCIBDL_SBR4              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR4
    #define NB_SCIBDL_SBR5              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR5
    #define NB_SCIBDL_SBR6              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR6
    #define NB_SCIBDL_SBR7              _NB_SCIBD.Overlap_STR.NB_SCIBDLSTR.Bits.SBR7
    
    #define NB_SCIBDL_SBR0_MASK         1U
    #define NB_SCIBDL_SBR1_MASK         2U
    #define NB_SCIBDL_SBR2_MASK         4U
    #define NB_SCIBDL_SBR3_MASK         8U
    #define NB_SCIBDL_SBR4_MASK         16U
    #define NB_SCIBDL_SBR5_MASK         32U
    #define NB_SCIBDL_SBR6_MASK         64U
    #define NB_SCIBDL_SBR7_MASK         128U
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
    word SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
    word SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
    word SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
    word SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
    word SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
    word SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
    word SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
    word SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
    word SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
    word SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
    word SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
    word SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
    word             :1; 
    word RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
    word LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
  } Bits;
  struct {
    word grpSBR  :13;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} NB_SCIBDSTR;
extern volatile NB_SCIBDSTR _NB_SCIBD @(REG_BASE + 0x00000340UL);
#define NB_SCIBD                        _NB_SCIBD.Word
#define NB_SCIBD_SBR0                   _NB_SCIBD.Bits.SBR0
#define NB_SCIBD_SBR1                   _NB_SCIBD.Bits.SBR1
#define NB_SCIBD_SBR2                   _NB_SCIBD.Bits.SBR2
#define NB_SCIBD_SBR3                   _NB_SCIBD.Bits.SBR3
#define NB_SCIBD_SBR4                   _NB_SCIBD.Bits.SBR4
#define NB_SCIBD_SBR5                   _NB_SCIBD.Bits.SBR5
#define NB_SCIBD_SBR6                   _NB_SCIBD.Bits.SBR6
#define NB_SCIBD_SBR7                   _NB_SCIBD.Bits.SBR7
#define NB_SCIBD_SBR8                   _NB_SCIBD.Bits.SBR8
#define NB_SCIBD_SBR9                   _NB_SCIBD.Bits.SBR9
#define NB_SCIBD_SBR10                  _NB_SCIBD.Bits.SBR10
#define NB_SCIBD_SBR11                  _NB_SCIBD.Bits.SBR11
#define NB_SCIBD_SBR12                  _NB_SCIBD.Bits.SBR12
#define NB_SCIBD_RXEDGIE                _NB_SCIBD.Bits.RXEDGIE
#define NB_SCIBD_LBKDIE                 _NB_SCIBD.Bits.LBKDIE
#define NB_SCIBD_SBR                    _NB_SCIBD.MergedBits.grpSBR

#define NB_SCIBD_SBR0_MASK              1U
#define NB_SCIBD_SBR1_MASK              2U
#define NB_SCIBD_SBR2_MASK              4U
#define NB_SCIBD_SBR3_MASK              8U
#define NB_SCIBD_SBR4_MASK              16U
#define NB_SCIBD_SBR5_MASK              32U
#define NB_SCIBD_SBR6_MASK              64U
#define NB_SCIBD_SBR7_MASK              128U
#define NB_SCIBD_SBR8_MASK              256U
#define NB_SCIBD_SBR9_MASK              512U
#define NB_SCIBD_SBR10_MASK             1024U
#define NB_SCIBD_SBR11_MASK             2048U
#define NB_SCIBD_SBR12_MASK             4096U
#define NB_SCIBD_RXEDGIE_MASK           16384U
#define NB_SCIBD_LBKDIE_MASK            32768U
#define NB_SCIBD_SBR_MASK               8191U
#define NB_SCIBD_SBR_BITNUM             0U


/*** NB_SCIC1 - SCI Control Register 1; 0x00000342 ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type */
    byte PE          :1;                                       /* Parity Enable */
    byte ILT         :1;                                       /* Idle Line Type Select */
    byte             :1; 
    byte M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    byte RSRC        :1;                                       /* Receiver Source Select */
    byte             :1; 
    byte LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} NB_SCIC1STR;
extern volatile NB_SCIC1STR _NB_SCIC1 @(REG_BASE + 0x00000342UL);
#define NB_SCIC1                        _NB_SCIC1.Byte
#define NB_SCIC1_PT                     _NB_SCIC1.Bits.PT
#define NB_SCIC1_PE                     _NB_SCIC1.Bits.PE
#define NB_SCIC1_ILT                    _NB_SCIC1.Bits.ILT
#define NB_SCIC1_M                      _NB_SCIC1.Bits.M
#define NB_SCIC1_RSRC                   _NB_SCIC1.Bits.RSRC
#define NB_SCIC1_LOOPS                  _NB_SCIC1.Bits.LOOPS

#define NB_SCIC1_PT_MASK                1U
#define NB_SCIC1_PE_MASK                2U
#define NB_SCIC1_ILT_MASK               4U
#define NB_SCIC1_M_MASK                 16U
#define NB_SCIC1_RSRC_MASK              32U
#define NB_SCIC1_LOOPS_MASK             128U


/*** NB_SCIC2 - SCI Control Register 2; 0x00000343 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break */
    byte RWU         :1;                                       /* Receiver Wakeup Control */
    byte RE          :1;                                       /* Receiver Enable */
    byte TE          :1;                                       /* Transmitter Enable */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    byte RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    byte TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} NB_SCIC2STR;
extern volatile NB_SCIC2STR _NB_SCIC2 @(REG_BASE + 0x00000343UL);
#define NB_SCIC2                        _NB_SCIC2.Byte
#define NB_SCIC2_SBK                    _NB_SCIC2.Bits.SBK
#define NB_SCIC2_RWU                    _NB_SCIC2.Bits.RWU
#define NB_SCIC2_RE                     _NB_SCIC2.Bits.RE
#define NB_SCIC2_TE                     _NB_SCIC2.Bits.TE
#define NB_SCIC2_ILIE                   _NB_SCIC2.Bits.ILIE
#define NB_SCIC2_RIE                    _NB_SCIC2.Bits.RIE
#define NB_SCIC2_TCIE                   _NB_SCIC2.Bits.TCIE
#define NB_SCIC2_TIE                    _NB_SCIC2.Bits.TIE

#define NB_SCIC2_SBK_MASK               1U
#define NB_SCIC2_RWU_MASK               2U
#define NB_SCIC2_RE_MASK                4U
#define NB_SCIC2_TE_MASK                8U
#define NB_SCIC2_ILIE_MASK              16U
#define NB_SCIC2_RIE_MASK               32U
#define NB_SCIC2_TCIE_MASK              64U
#define NB_SCIC2_TIE_MASK               128U


/*** NB_SCIS1 - SCI Status Register 1; 0x00000344 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Receiver Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmission Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} NB_SCIS1STR;
extern volatile NB_SCIS1STR _NB_SCIS1 @(REG_BASE + 0x00000344UL);
#define NB_SCIS1                        _NB_SCIS1.Byte
#define NB_SCIS1_PF                     _NB_SCIS1.Bits.PF
#define NB_SCIS1_FE                     _NB_SCIS1.Bits.FE
#define NB_SCIS1_NF                     _NB_SCIS1.Bits.NF
#define NB_SCIS1_OR                     _NB_SCIS1.Bits.OR
#define NB_SCIS1_IDLE                   _NB_SCIS1.Bits.IDLE
#define NB_SCIS1_RDRF                   _NB_SCIS1.Bits.RDRF
#define NB_SCIS1_TC                     _NB_SCIS1.Bits.TC
#define NB_SCIS1_TDRE                   _NB_SCIS1.Bits.TDRE

#define NB_SCIS1_PF_MASK                1U
#define NB_SCIS1_FE_MASK                2U
#define NB_SCIS1_NF_MASK                4U
#define NB_SCIS1_OR_MASK                8U
#define NB_SCIS1_IDLE_MASK              16U
#define NB_SCIS1_RDRF_MASK              32U
#define NB_SCIS1_TC_MASK                64U
#define NB_SCIS1_TDRE_MASK              128U


/*** NB_SCIS2 - SCI Status Register 2; 0x00000345 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte LBKDE       :1;                                       /* LIN Break Detection Enable */
    byte BRK13       :1;                                       /* Break Character Generation Length */
    byte RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    byte RXINV       :1;                                       /* Receive Data Inversion */
    byte             :1; 
    byte RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    byte LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} NB_SCIS2STR;
extern volatile NB_SCIS2STR _NB_SCIS2 @(REG_BASE + 0x00000345UL);
#define NB_SCIS2                        _NB_SCIS2.Byte
#define NB_SCIS2_RAF                    _NB_SCIS2.Bits.RAF
#define NB_SCIS2_LBKDE                  _NB_SCIS2.Bits.LBKDE
#define NB_SCIS2_BRK13                  _NB_SCIS2.Bits.BRK13
#define NB_SCIS2_RWUID                  _NB_SCIS2.Bits.RWUID
#define NB_SCIS2_RXINV                  _NB_SCIS2.Bits.RXINV
#define NB_SCIS2_RXEDGIF                _NB_SCIS2.Bits.RXEDGIF
#define NB_SCIS2_LBKDIF                 _NB_SCIS2.Bits.LBKDIF

#define NB_SCIS2_RAF_MASK               1U
#define NB_SCIS2_LBKDE_MASK             2U
#define NB_SCIS2_BRK13_MASK             4U
#define NB_SCIS2_RWUID_MASK             8U
#define NB_SCIS2_RXINV_MASK             16U
#define NB_SCIS2_RXEDGIF_MASK           64U
#define NB_SCIS2_LBKDIF_MASK            128U


/*** NB_SCIC3 - SCI Control Register 3; 0x00000346 ***/
typedef union {
  byte Byte;
  struct {
    byte PEIE        :1;                                       /* Parity Error Interrupt Enable */
    byte FEIE        :1;                                       /* Framing Error Interrupt Enable */
    byte NEIE        :1;                                       /* Noise Error Interrupt Enable */
    byte ORIE        :1;                                       /* Overrun Interrupt Enable */
    byte TXINV       :1;                                       /* Transmit Data Inversion */
    byte TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    byte T8          :1;                                       /* Ninth Data Bit for Transmitter */
    byte R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} NB_SCIC3STR;
extern volatile NB_SCIC3STR _NB_SCIC3 @(REG_BASE + 0x00000346UL);
#define NB_SCIC3                        _NB_SCIC3.Byte
#define NB_SCIC3_PEIE                   _NB_SCIC3.Bits.PEIE
#define NB_SCIC3_FEIE                   _NB_SCIC3.Bits.FEIE
#define NB_SCIC3_NEIE                   _NB_SCIC3.Bits.NEIE
#define NB_SCIC3_ORIE                   _NB_SCIC3.Bits.ORIE
#define NB_SCIC3_TXINV                  _NB_SCIC3.Bits.TXINV
#define NB_SCIC3_TXDIR                  _NB_SCIC3.Bits.TXDIR
#define NB_SCIC3_T8                     _NB_SCIC3.Bits.T8
#define NB_SCIC3_R8                     _NB_SCIC3.Bits.R8

#define NB_SCIC3_PEIE_MASK              1U
#define NB_SCIC3_FEIE_MASK              2U
#define NB_SCIC3_NEIE_MASK              4U
#define NB_SCIC3_ORIE_MASK              8U
#define NB_SCIC3_TXINV_MASK             16U
#define NB_SCIC3_TXDIR_MASK             32U
#define NB_SCIC3_T8_MASK                64U
#define NB_SCIC3_R8_MASK                128U


/*** NB_SCID - SCI Data Register; 0x00000347 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    byte R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    byte R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    byte R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    byte R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    byte R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    byte R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    byte R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} NB_SCIDSTR;
extern volatile NB_SCIDSTR _NB_SCID @(REG_BASE + 0x00000347UL);
#define NB_SCID                         _NB_SCID.Byte
#define NB_SCID_R0_T0                   _NB_SCID.Bits.R0_T0
#define NB_SCID_R1_T1                   _NB_SCID.Bits.R1_T1
#define NB_SCID_R2_T2                   _NB_SCID.Bits.R2_T2
#define NB_SCID_R3_T3                   _NB_SCID.Bits.R3_T3
#define NB_SCID_R4_T4                   _NB_SCID.Bits.R4_T4
#define NB_SCID_R5_T5                   _NB_SCID.Bits.R5_T5
#define NB_SCID_R6_T6                   _NB_SCID.Bits.R6_T6
#define NB_SCID_R7_T7                   _NB_SCID.Bits.R7_T7

#define NB_SCID_R0_T0_MASK              1U
#define NB_SCID_R1_T1_MASK              2U
#define NB_SCID_R2_T2_MASK              4U
#define NB_SCID_R3_T3_MASK              8U
#define NB_SCID_R4_T4_MASK              16U
#define NB_SCID_R5_T5_MASK              32U
#define NB_SCID_R6_T6_MASK              64U
#define NB_SCID_R7_T7_MASK              128U


/*** NB_PWMCTL - PWM Control Register; 0x00000360 ***/
typedef union {
  byte Byte;
  struct {
    byte PWME0       :1;                                       /* Pulse Width Channel 0 Enable */
    byte PWME1       :1;                                       /* Pulse Width Channel 1 Enable */
    byte PPOL0       :1;                                       /* Pulse Width Channel 0 Polarity */
    byte PPOL1       :1;                                       /* Pulse Width Channel 1 Polarity */
    byte PCLK0       :1;                                       /* Pulse Width Channel 0 Clock Select */
    byte PCLK1       :1;                                       /* Pulse Width Channel 1 Clock Select */
    byte CAE0        :1;                                       /* Center Aligned Output Modes on Channel 0 */
    byte CAE1        :1;                                       /* Center Aligned Output Modes on Channel 1 */
  } Bits;
  struct {
    byte grpPWME :2;
    byte grpPPOL :2;
    byte grpPCLK :2;
    byte grpCAE  :2;
  } MergedBits;
} NB_PWMCTLSTR;
extern volatile NB_PWMCTLSTR _NB_PWMCTL @(REG_BASE + 0x00000360UL);
#define NB_PWMCTL                       _NB_PWMCTL.Byte
#define NB_PWMCTL_PWME0                 _NB_PWMCTL.Bits.PWME0
#define NB_PWMCTL_PWME1                 _NB_PWMCTL.Bits.PWME1
#define NB_PWMCTL_PPOL0                 _NB_PWMCTL.Bits.PPOL0
#define NB_PWMCTL_PPOL1                 _NB_PWMCTL.Bits.PPOL1
#define NB_PWMCTL_PCLK0                 _NB_PWMCTL.Bits.PCLK0
#define NB_PWMCTL_PCLK1                 _NB_PWMCTL.Bits.PCLK1
#define NB_PWMCTL_CAE0                  _NB_PWMCTL.Bits.CAE0
#define NB_PWMCTL_CAE1                  _NB_PWMCTL.Bits.CAE1
#define NB_PWMCTL_PWME                  _NB_PWMCTL.MergedBits.grpPWME
#define NB_PWMCTL_PPOL                  _NB_PWMCTL.MergedBits.grpPPOL
#define NB_PWMCTL_PCLK                  _NB_PWMCTL.MergedBits.grpPCLK
#define NB_PWMCTL_CAE                   _NB_PWMCTL.MergedBits.grpCAE

#define NB_PWMCTL_PWME0_MASK            1U
#define NB_PWMCTL_PWME1_MASK            2U
#define NB_PWMCTL_PPOL0_MASK            4U
#define NB_PWMCTL_PPOL1_MASK            8U
#define NB_PWMCTL_PCLK0_MASK            16U
#define NB_PWMCTL_PCLK1_MASK            32U
#define NB_PWMCTL_CAE0_MASK             64U
#define NB_PWMCTL_CAE1_MASK             128U
#define NB_PWMCTL_PWME_MASK             3U
#define NB_PWMCTL_PWME_BITNUM           0U
#define NB_PWMCTL_PPOL_MASK             12U
#define NB_PWMCTL_PPOL_BITNUM           2U
#define NB_PWMCTL_PCLK_MASK             48U
#define NB_PWMCTL_PCLK_BITNUM           4U
#define NB_PWMCTL_CAE_MASK              192U
#define NB_PWMCTL_CAE_BITNUM            6U


/*** NB_PWMPRCLK - PWM Prescale Clock Select Register; 0x00000361 ***/
typedef union {
  byte Byte;
  struct {
    byte PCKA0       :1;                                       /* Prescaler Select for Clock A Bit 0 */
    byte PCKA1       :1;                                       /* Prescaler Select for Clock A Bit 1 */
    byte PCKA2       :1;                                       /* Prescaler Select for Clock A Bit 2 */
    byte             :1; 
    byte PCKB0       :1;                                       /* Prescaler Select for Clock B Bit 0 */
    byte PCKB1       :1;                                       /* Prescaler Select for Clock B Bit 1 */
    byte PCKB2       :1;                                       /* Prescaler Select for Clock B Bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPCKA :3;
    byte         :1;
    byte grpPCKB :3;
    byte         :1;
  } MergedBits;
} NB_PWMPRCLKSTR;
extern volatile NB_PWMPRCLKSTR _NB_PWMPRCLK @(REG_BASE + 0x00000361UL);
#define NB_PWMPRCLK                     _NB_PWMPRCLK.Byte
#define NB_PWMPRCLK_PCKA0               _NB_PWMPRCLK.Bits.PCKA0
#define NB_PWMPRCLK_PCKA1               _NB_PWMPRCLK.Bits.PCKA1
#define NB_PWMPRCLK_PCKA2               _NB_PWMPRCLK.Bits.PCKA2
#define NB_PWMPRCLK_PCKB0               _NB_PWMPRCLK.Bits.PCKB0
#define NB_PWMPRCLK_PCKB1               _NB_PWMPRCLK.Bits.PCKB1
#define NB_PWMPRCLK_PCKB2               _NB_PWMPRCLK.Bits.PCKB2
#define NB_PWMPRCLK_PCKA                _NB_PWMPRCLK.MergedBits.grpPCKA
#define NB_PWMPRCLK_PCKB                _NB_PWMPRCLK.MergedBits.grpPCKB

#define NB_PWMPRCLK_PCKA0_MASK          1U
#define NB_PWMPRCLK_PCKA1_MASK          2U
#define NB_PWMPRCLK_PCKA2_MASK          4U
#define NB_PWMPRCLK_PCKB0_MASK          16U
#define NB_PWMPRCLK_PCKB1_MASK          32U
#define NB_PWMPRCLK_PCKB2_MASK          64U
#define NB_PWMPRCLK_PCKA_MASK           7U
#define NB_PWMPRCLK_PCKA_BITNUM         0U
#define NB_PWMPRCLK_PCKB_MASK           112U
#define NB_PWMPRCLK_PCKB_BITNUM         4U


/*** NB_PWMSCLA - PWM Scale A Register; 0x00000362 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale A Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale A Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale A Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale A Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale A Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale A Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale A Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale A Bit 7 */
  } Bits;
} NB_PWMSCLASTR;
extern volatile NB_PWMSCLASTR _NB_PWMSCLA @(REG_BASE + 0x00000362UL);
#define NB_PWMSCLA                      _NB_PWMSCLA.Byte
#define NB_PWMSCLA_BIT0                 _NB_PWMSCLA.Bits.BIT0
#define NB_PWMSCLA_BIT1                 _NB_PWMSCLA.Bits.BIT1
#define NB_PWMSCLA_BIT2                 _NB_PWMSCLA.Bits.BIT2
#define NB_PWMSCLA_BIT3                 _NB_PWMSCLA.Bits.BIT3
#define NB_PWMSCLA_BIT4                 _NB_PWMSCLA.Bits.BIT4
#define NB_PWMSCLA_BIT5                 _NB_PWMSCLA.Bits.BIT5
#define NB_PWMSCLA_BIT6                 _NB_PWMSCLA.Bits.BIT6
#define NB_PWMSCLA_BIT7                 _NB_PWMSCLA.Bits.BIT7

#define NB_PWMSCLA_BIT0_MASK            1U
#define NB_PWMSCLA_BIT1_MASK            2U
#define NB_PWMSCLA_BIT2_MASK            4U
#define NB_PWMSCLA_BIT3_MASK            8U
#define NB_PWMSCLA_BIT4_MASK            16U
#define NB_PWMSCLA_BIT5_MASK            32U
#define NB_PWMSCLA_BIT6_MASK            64U
#define NB_PWMSCLA_BIT7_MASK            128U


/*** NB_PWMSCLB - PWM Scale B Register; 0x00000363 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale B Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale B Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale B Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale B Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale B Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale B Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale B Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale B Bit 7 */
  } Bits;
} NB_PWMSCLBSTR;
extern volatile NB_PWMSCLBSTR _NB_PWMSCLB @(REG_BASE + 0x00000363UL);
#define NB_PWMSCLB                      _NB_PWMSCLB.Byte
#define NB_PWMSCLB_BIT0                 _NB_PWMSCLB.Bits.BIT0
#define NB_PWMSCLB_BIT1                 _NB_PWMSCLB.Bits.BIT1
#define NB_PWMSCLB_BIT2                 _NB_PWMSCLB.Bits.BIT2
#define NB_PWMSCLB_BIT3                 _NB_PWMSCLB.Bits.BIT3
#define NB_PWMSCLB_BIT4                 _NB_PWMSCLB.Bits.BIT4
#define NB_PWMSCLB_BIT5                 _NB_PWMSCLB.Bits.BIT5
#define NB_PWMSCLB_BIT6                 _NB_PWMSCLB.Bits.BIT6
#define NB_PWMSCLB_BIT7                 _NB_PWMSCLB.Bits.BIT7

#define NB_PWMSCLB_BIT0_MASK            1U
#define NB_PWMSCLB_BIT1_MASK            2U
#define NB_PWMSCLB_BIT2_MASK            4U
#define NB_PWMSCLB_BIT3_MASK            8U
#define NB_PWMSCLB_BIT4_MASK            16U
#define NB_PWMSCLB_BIT5_MASK            32U
#define NB_PWMSCLB_BIT6_MASK            64U
#define NB_PWMSCLB_BIT7_MASK            128U


/*** NB_PWMCNT0 - PWM Channel Counter 0 Register; 0x00000364 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMCNT00    :1;                                       /* PWM Channel Counter Bits, bit 0 */
    byte PWMCNT01    :1;                                       /* PWM Channel Counter Bits, bit 1 */
    byte PWMCNT02    :1;                                       /* PWM Channel Counter Bits, bit 2 */
    byte PWMCNT03    :1;                                       /* PWM Channel Counter Bits, bit 3 */
    byte PWMCNT04    :1;                                       /* PWM Channel Counter Bits, bit 4 */
    byte PWMCNT05    :1;                                       /* PWM Channel Counter Bits, bit 5 */
    byte PWMCNT06    :1;                                       /* PWM Channel Counter Bits, bit 6 */
    byte PWMCNT07    :1;                                       /* PWM Channel Counter Bits, bit 7 */
  } Bits;
} NB_PWMCNT0STR;
extern volatile NB_PWMCNT0STR _NB_PWMCNT0 @(REG_BASE + 0x00000364UL);
#define NB_PWMCNT0                      _NB_PWMCNT0.Byte
#define NB_PWMCNT0_PWMCNT00             _NB_PWMCNT0.Bits.PWMCNT00
#define NB_PWMCNT0_PWMCNT01             _NB_PWMCNT0.Bits.PWMCNT01
#define NB_PWMCNT0_PWMCNT02             _NB_PWMCNT0.Bits.PWMCNT02
#define NB_PWMCNT0_PWMCNT03             _NB_PWMCNT0.Bits.PWMCNT03
#define NB_PWMCNT0_PWMCNT04             _NB_PWMCNT0.Bits.PWMCNT04
#define NB_PWMCNT0_PWMCNT05             _NB_PWMCNT0.Bits.PWMCNT05
#define NB_PWMCNT0_PWMCNT06             _NB_PWMCNT0.Bits.PWMCNT06
#define NB_PWMCNT0_PWMCNT07             _NB_PWMCNT0.Bits.PWMCNT07
/* NB_PWMCNT_ARR: Access 2 NB_PWMCNTx registers in an array */
#define NB_PWMCNT_ARR                   ((volatile byte *) &NB_PWMCNT0)

#define NB_PWMCNT0_PWMCNT00_MASK        1U
#define NB_PWMCNT0_PWMCNT01_MASK        2U
#define NB_PWMCNT0_PWMCNT02_MASK        4U
#define NB_PWMCNT0_PWMCNT03_MASK        8U
#define NB_PWMCNT0_PWMCNT04_MASK        16U
#define NB_PWMCNT0_PWMCNT05_MASK        32U
#define NB_PWMCNT0_PWMCNT06_MASK        64U
#define NB_PWMCNT0_PWMCNT07_MASK        128U


/*** NB_PWMCNT1 - PWM Channel Counter 1 Register; 0x00000365 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMCNT10    :1;                                       /* PWM Channel Counter Bits, bit 0 */
    byte PWMCNT11    :1;                                       /* PWM Channel Counter Bits, bit 1 */
    byte PWMCNT12    :1;                                       /* PWM Channel Counter Bits, bit 2 */
    byte PWMCNT13    :1;                                       /* PWM Channel Counter Bits, bit 3 */
    byte PWMCNT14    :1;                                       /* PWM Channel Counter Bits, bit 4 */
    byte PWMCNT15    :1;                                       /* PWM Channel Counter Bits, bit 5 */
    byte PWMCNT16    :1;                                       /* PWM Channel Counter Bits, bit 6 */
    byte PWMCNT17    :1;                                       /* PWM Channel Counter Bits, bit 7 */
  } Bits;
} NB_PWMCNT1STR;
extern volatile NB_PWMCNT1STR _NB_PWMCNT1 @(REG_BASE + 0x00000365UL);
#define NB_PWMCNT1                      _NB_PWMCNT1.Byte
#define NB_PWMCNT1_PWMCNT10             _NB_PWMCNT1.Bits.PWMCNT10
#define NB_PWMCNT1_PWMCNT11             _NB_PWMCNT1.Bits.PWMCNT11
#define NB_PWMCNT1_PWMCNT12             _NB_PWMCNT1.Bits.PWMCNT12
#define NB_PWMCNT1_PWMCNT13             _NB_PWMCNT1.Bits.PWMCNT13
#define NB_PWMCNT1_PWMCNT14             _NB_PWMCNT1.Bits.PWMCNT14
#define NB_PWMCNT1_PWMCNT15             _NB_PWMCNT1.Bits.PWMCNT15
#define NB_PWMCNT1_PWMCNT16             _NB_PWMCNT1.Bits.PWMCNT16
#define NB_PWMCNT1_PWMCNT17             _NB_PWMCNT1.Bits.PWMCNT17

#define NB_PWMCNT1_PWMCNT10_MASK        1U
#define NB_PWMCNT1_PWMCNT11_MASK        2U
#define NB_PWMCNT1_PWMCNT12_MASK        4U
#define NB_PWMCNT1_PWMCNT13_MASK        8U
#define NB_PWMCNT1_PWMCNT14_MASK        16U
#define NB_PWMCNT1_PWMCNT15_MASK        32U
#define NB_PWMCNT1_PWMCNT16_MASK        64U
#define NB_PWMCNT1_PWMCNT17_MASK        128U


/*** NB_PWMPER0 - PWM Channel Period 0 Register; 0x00000366 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMPER00    :1;                                       /* PWM Channel Period Bits, bit 0 */
    byte PWMPER01    :1;                                       /* PWM Channel Period Bits, bit 1 */
    byte PWMPER02    :1;                                       /* PWM Channel Period Bits, bit 2 */
    byte PWMPER03    :1;                                       /* PWM Channel Period Bits, bit 3 */
    byte PWMPER04    :1;                                       /* PWM Channel Period Bits, bit 4 */
    byte PWMPER05    :1;                                       /* PWM Channel Period Bits, bit 5 */
    byte PWMPER06    :1;                                       /* PWM Channel Period Bits, bit 6 */
    byte PWMPER07    :1;                                       /* PWM Channel Period Bits, bit 7 */
  } Bits;
} NB_PWMPER0STR;
extern volatile NB_PWMPER0STR _NB_PWMPER0 @(REG_BASE + 0x00000366UL);
#define NB_PWMPER0                      _NB_PWMPER0.Byte
#define NB_PWMPER0_PWMPER00             _NB_PWMPER0.Bits.PWMPER00
#define NB_PWMPER0_PWMPER01             _NB_PWMPER0.Bits.PWMPER01
#define NB_PWMPER0_PWMPER02             _NB_PWMPER0.Bits.PWMPER02
#define NB_PWMPER0_PWMPER03             _NB_PWMPER0.Bits.PWMPER03
#define NB_PWMPER0_PWMPER04             _NB_PWMPER0.Bits.PWMPER04
#define NB_PWMPER0_PWMPER05             _NB_PWMPER0.Bits.PWMPER05
#define NB_PWMPER0_PWMPER06             _NB_PWMPER0.Bits.PWMPER06
#define NB_PWMPER0_PWMPER07             _NB_PWMPER0.Bits.PWMPER07
/* NB_PWMPER_ARR: Access 2 NB_PWMPERx registers in an array */
#define NB_PWMPER_ARR                   ((volatile byte *) &NB_PWMPER0)

#define NB_PWMPER0_PWMPER00_MASK        1U
#define NB_PWMPER0_PWMPER01_MASK        2U
#define NB_PWMPER0_PWMPER02_MASK        4U
#define NB_PWMPER0_PWMPER03_MASK        8U
#define NB_PWMPER0_PWMPER04_MASK        16U
#define NB_PWMPER0_PWMPER05_MASK        32U
#define NB_PWMPER0_PWMPER06_MASK        64U
#define NB_PWMPER0_PWMPER07_MASK        128U


/*** NB_PWMPER1 - PWM Channel Period 1 Register; 0x00000367 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMPER10    :1;                                       /* PWM Channel Period Bits, bit 0 */
    byte PWMPER11    :1;                                       /* PWM Channel Period Bits, bit 1 */
    byte PWMPER12    :1;                                       /* PWM Channel Period Bits, bit 2 */
    byte PWMPER13    :1;                                       /* PWM Channel Period Bits, bit 3 */
    byte PWMPER14    :1;                                       /* PWM Channel Period Bits, bit 4 */
    byte PWMPER15    :1;                                       /* PWM Channel Period Bits, bit 5 */
    byte PWMPER16    :1;                                       /* PWM Channel Period Bits, bit 6 */
    byte PWMPER17    :1;                                       /* PWM Channel Period Bits, bit 7 */
  } Bits;
} NB_PWMPER1STR;
extern volatile NB_PWMPER1STR _NB_PWMPER1 @(REG_BASE + 0x00000367UL);
#define NB_PWMPER1                      _NB_PWMPER1.Byte
#define NB_PWMPER1_PWMPER10             _NB_PWMPER1.Bits.PWMPER10
#define NB_PWMPER1_PWMPER11             _NB_PWMPER1.Bits.PWMPER11
#define NB_PWMPER1_PWMPER12             _NB_PWMPER1.Bits.PWMPER12
#define NB_PWMPER1_PWMPER13             _NB_PWMPER1.Bits.PWMPER13
#define NB_PWMPER1_PWMPER14             _NB_PWMPER1.Bits.PWMPER14
#define NB_PWMPER1_PWMPER15             _NB_PWMPER1.Bits.PWMPER15
#define NB_PWMPER1_PWMPER16             _NB_PWMPER1.Bits.PWMPER16
#define NB_PWMPER1_PWMPER17             _NB_PWMPER1.Bits.PWMPER17

#define NB_PWMPER1_PWMPER10_MASK        1U
#define NB_PWMPER1_PWMPER11_MASK        2U
#define NB_PWMPER1_PWMPER12_MASK        4U
#define NB_PWMPER1_PWMPER13_MASK        8U
#define NB_PWMPER1_PWMPER14_MASK        16U
#define NB_PWMPER1_PWMPER15_MASK        32U
#define NB_PWMPER1_PWMPER16_MASK        64U
#define NB_PWMPER1_PWMPER17_MASK        128U


/*** NB_PWMDTY0 - PWM Channel Duty 0 Register; 0x00000368 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMDTY00    :1;                                       /* PWM Channel Duty Bits, bit 0 */
    byte PWMDTY01    :1;                                       /* PWM Channel Duty Bits, bit 1 */
    byte PWMDTY02    :1;                                       /* PWM Channel Duty Bits, bit 2 */
    byte PWMDTY03    :1;                                       /* PWM Channel Duty Bits, bit 3 */
    byte PWMDTY04    :1;                                       /* PWM Channel Duty Bits, bit 4 */
    byte PWMDTY05    :1;                                       /* PWM Channel Duty Bits, bit 5 */
    byte PWMDTY06    :1;                                       /* PWM Channel Duty Bits, bit 6 */
    byte PWMDTY07    :1;                                       /* PWM Channel Duty Bits, bit 7 */
  } Bits;
} NB_PWMDTY0STR;
extern volatile NB_PWMDTY0STR _NB_PWMDTY0 @(REG_BASE + 0x00000368UL);
#define NB_PWMDTY0                      _NB_PWMDTY0.Byte
#define NB_PWMDTY0_PWMDTY00             _NB_PWMDTY0.Bits.PWMDTY00
#define NB_PWMDTY0_PWMDTY01             _NB_PWMDTY0.Bits.PWMDTY01
#define NB_PWMDTY0_PWMDTY02             _NB_PWMDTY0.Bits.PWMDTY02
#define NB_PWMDTY0_PWMDTY03             _NB_PWMDTY0.Bits.PWMDTY03
#define NB_PWMDTY0_PWMDTY04             _NB_PWMDTY0.Bits.PWMDTY04
#define NB_PWMDTY0_PWMDTY05             _NB_PWMDTY0.Bits.PWMDTY05
#define NB_PWMDTY0_PWMDTY06             _NB_PWMDTY0.Bits.PWMDTY06
#define NB_PWMDTY0_PWMDTY07             _NB_PWMDTY0.Bits.PWMDTY07
/* NB_PWMDTY_ARR: Access 2 NB_PWMDTYx registers in an array */
#define NB_PWMDTY_ARR                   ((volatile byte *) &NB_PWMDTY0)

#define NB_PWMDTY0_PWMDTY00_MASK        1U
#define NB_PWMDTY0_PWMDTY01_MASK        2U
#define NB_PWMDTY0_PWMDTY02_MASK        4U
#define NB_PWMDTY0_PWMDTY03_MASK        8U
#define NB_PWMDTY0_PWMDTY04_MASK        16U
#define NB_PWMDTY0_PWMDTY05_MASK        32U
#define NB_PWMDTY0_PWMDTY06_MASK        64U
#define NB_PWMDTY0_PWMDTY07_MASK        128U


/*** NB_PWMDTY1 - PWM Channel Duty 1 Register; 0x00000369 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMDTY10    :1;                                       /* PWM Channel Duty Bits, bit 0 */
    byte PWMDTY11    :1;                                       /* PWM Channel Duty Bits, bit 1 */
    byte PWMDTY12    :1;                                       /* PWM Channel Duty Bits, bit 2 */
    byte PWMDTY13    :1;                                       /* PWM Channel Duty Bits, bit 3 */
    byte PWMDTY14    :1;                                       /* PWM Channel Duty Bits, bit 4 */
    byte PWMDTY15    :1;                                       /* PWM Channel Duty Bits, bit 5 */
    byte PWMDTY16    :1;                                       /* PWM Channel Duty Bits, bit 6 */
    byte PWMDTY17    :1;                                       /* PWM Channel Duty Bits, bit 7 */
  } Bits;
} NB_PWMDTY1STR;
extern volatile NB_PWMDTY1STR _NB_PWMDTY1 @(REG_BASE + 0x00000369UL);
#define NB_PWMDTY1                      _NB_PWMDTY1.Byte
#define NB_PWMDTY1_PWMDTY10             _NB_PWMDTY1.Bits.PWMDTY10
#define NB_PWMDTY1_PWMDTY11             _NB_PWMDTY1.Bits.PWMDTY11
#define NB_PWMDTY1_PWMDTY12             _NB_PWMDTY1.Bits.PWMDTY12
#define NB_PWMDTY1_PWMDTY13             _NB_PWMDTY1.Bits.PWMDTY13
#define NB_PWMDTY1_PWMDTY14             _NB_PWMDTY1.Bits.PWMDTY14
#define NB_PWMDTY1_PWMDTY15             _NB_PWMDTY1.Bits.PWMDTY15
#define NB_PWMDTY1_PWMDTY16             _NB_PWMDTY1.Bits.PWMDTY16
#define NB_PWMDTY1_PWMDTY17             _NB_PWMDTY1.Bits.PWMDTY17

#define NB_PWMDTY1_PWMDTY10_MASK        1U
#define NB_PWMDTY1_PWMDTY11_MASK        2U
#define NB_PWMDTY1_PWMDTY12_MASK        4U
#define NB_PWMDTY1_PWMDTY13_MASK        8U
#define NB_PWMDTY1_PWMDTY14_MASK        16U
#define NB_PWMDTY1_PWMDTY15_MASK        32U
#define NB_PWMDTY1_PWMDTY16_MASK        64U
#define NB_PWMDTY1_PWMDTY17_MASK        128U


/*** NB_ACR - ADC Config Register; 0x00000380 ***/
typedef union {
  byte Byte;
  struct {
    byte PS          :3;                                       /* ADC Clock Prescaler Select 0 */
    byte             :1; 
    byte ADCRST      :1;                                       /* Analog Digital Converter RESET */
    byte OCE         :1;                                       /* Offset Compensation Enable */
    byte CCE         :1;                                       /* Continuous Conversion Enable */
    byte SCIE        :1;                                       /* Sequence Complete Interrupt Enable */
  } Bits;
} NB_ACRSTR;
extern volatile NB_ACRSTR _NB_ACR @(REG_BASE + 0x00000380UL);
#define NB_ACR                          _NB_ACR.Byte
#define NB_ACR_PS                       _NB_ACR.Bits.PS
#define NB_ACR_ADCRST                   _NB_ACR.Bits.ADCRST
#define NB_ACR_OCE                      _NB_ACR.Bits.OCE
#define NB_ACR_CCE                      _NB_ACR.Bits.CCE
#define NB_ACR_SCIE                     _NB_ACR.Bits.SCIE

#define NB_ACR_PS_MASK                  7U
#define NB_ACR_PS_BITNUM                0U
#define NB_ACR_ADCRST_MASK              16U
#define NB_ACR_OCE_MASK                 32U
#define NB_ACR_CCE_MASK                 64U
#define NB_ACR_SCIE_MASK                128U


/*** NB_ASR - ADC Status Register; 0x00000381 ***/
typedef union {
  byte Byte;
  struct {
    byte CCNT        :4;                                       /* Conversion Counter Status 0 */
    byte             :1; 
    byte             :1; 
    byte _2p5CLF     :1;                                       /* ADC Reference Voltage Current Limitation Flag */
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
} NB_ASRSTR;
extern volatile NB_ASRSTR _NB_ASR @(REG_BASE + 0x00000381UL);
#define NB_ASR                          _NB_ASR.Byte
#define NB_ASR_CCNT                     _NB_ASR.Bits.CCNT
#define NB_ASR_2p5CLF                   _NB_ASR.Bits._2p5CLF
#define NB_ASR_SCF                      _NB_ASR.Bits.SCF

#define NB_ASR_CCNT_MASK                15U
#define NB_ASR_CCNT_BITNUM              0U
#define NB_ASR_2p5CLF_MASK              64U
#define NB_ASR_SCF_MASK                 128U


/*** NB_ACCR - ADC Conversion Control Register; 0x00000382 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ACCRhi - ADC Conversion Control Register High; 0x00000382 ***/
    union {
      byte Byte;
      struct {
        byte CH8         :1;                                       /* Channel Select 8 */
        byte CH9         :1;                                       /* Channel Select 9 */
        byte CH10        :1;                                       /* Channel Select 10 */
        byte CH11        :1;                                       /* Channel Select 11 */
        byte CH12        :1;                                       /* Channel Select 12 */
        byte             :1; 
        byte CH14        :1;                                       /* Channel Select 14 */
        byte CH15        :1;                                       /* Channel Select 15 */
      } Bits;
      struct {
        byte grpCH_8 :5;
        byte     :1;
        byte grpCH_14 :2;
      } MergedBits;
    } NB_ACCRhiSTR;
    #define NB_ACCRhi                   _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.Byte
    #define NB_ACCRhi_CH8               _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.Bits.CH8
    #define NB_ACCRhi_CH9               _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.Bits.CH9
    #define NB_ACCRhi_CH10              _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.Bits.CH10
    #define NB_ACCRhi_CH11              _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.Bits.CH11
    #define NB_ACCRhi_CH12              _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.Bits.CH12
    #define NB_ACCRhi_CH14              _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.Bits.CH14
    #define NB_ACCRhi_CH15              _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.Bits.CH15
    #define NB_ACCRhi_CH_8              _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.MergedBits.grpCH_8
    #define NB_ACCRhi_CH_14             _NB_ACCR.Overlap_STR.NB_ACCRhiSTR.MergedBits.grpCH_14
    #define NB_ACCRhi_CH                NB_ACCRhi_CH_8
    
    #define NB_ACCRhi_CH8_MASK          1U
    #define NB_ACCRhi_CH9_MASK          2U
    #define NB_ACCRhi_CH10_MASK         4U
    #define NB_ACCRhi_CH11_MASK         8U
    #define NB_ACCRhi_CH12_MASK         16U
    #define NB_ACCRhi_CH14_MASK         64U
    #define NB_ACCRhi_CH15_MASK         128U
    #define NB_ACCRhi_CH_8_MASK         31U
    #define NB_ACCRhi_CH_8_BITNUM       0U
    #define NB_ACCRhi_CH_14_MASK        192U
    #define NB_ACCRhi_CH_14_BITNUM      6U
    

    /*** NB_ACCRlo - ADC Conversion Control Register Low; 0x00000383 ***/
    union {
      byte Byte;
      struct {
        byte CH0         :1;                                       /* Channel Select 0 */
        byte CH1         :1;                                       /* Channel Select 1 */
        byte CH2         :1;                                       /* Channel Select 2 */
        byte CH3         :1;                                       /* Channel Select 3 */
        byte CH4         :1;                                       /* Channel Select 4 */
        byte CH5         :1;                                       /* Channel Select 5 */
        byte CH6         :1;                                       /* Channel Select 6 */
        byte CH7         :1;                                       /* Channel Select 7 */
      } Bits;
    } NB_ACCRloSTR;
    #define NB_ACCRlo                   _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Byte
    #define NB_ACCRlo_CH0               _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Bits.CH0
    #define NB_ACCRlo_CH1               _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Bits.CH1
    #define NB_ACCRlo_CH2               _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Bits.CH2
    #define NB_ACCRlo_CH3               _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Bits.CH3
    #define NB_ACCRlo_CH4               _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Bits.CH4
    #define NB_ACCRlo_CH5               _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Bits.CH5
    #define NB_ACCRlo_CH6               _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Bits.CH6
    #define NB_ACCRlo_CH7               _NB_ACCR.Overlap_STR.NB_ACCRloSTR.Bits.CH7
    
    #define NB_ACCRlo_CH0_MASK          1U
    #define NB_ACCRlo_CH1_MASK          2U
    #define NB_ACCRlo_CH2_MASK          4U
    #define NB_ACCRlo_CH3_MASK          8U
    #define NB_ACCRlo_CH4_MASK          16U
    #define NB_ACCRlo_CH5_MASK          32U
    #define NB_ACCRlo_CH6_MASK          64U
    #define NB_ACCRlo_CH7_MASK          128U
    
  } Overlap_STR;

  struct {
    word CH0         :1;                                       /* Channel Select 0 */
    word CH1         :1;                                       /* Channel Select 1 */
    word CH2         :1;                                       /* Channel Select 2 */
    word CH3         :1;                                       /* Channel Select 3 */
    word CH4         :1;                                       /* Channel Select 4 */
    word CH5         :1;                                       /* Channel Select 5 */
    word CH6         :1;                                       /* Channel Select 6 */
    word CH7         :1;                                       /* Channel Select 7 */
    word CH8         :1;                                       /* Channel Select 8 */
    word CH9         :1;                                       /* Channel Select 9 */
    word CH10        :1;                                       /* Channel Select 10 */
    word CH11        :1;                                       /* Channel Select 11 */
    word CH12        :1;                                       /* Channel Select 12 */
    word             :1; 
    word CH14        :1;                                       /* Channel Select 14 */
    word CH15        :1;                                       /* Channel Select 15 */
  } Bits;
  struct {
    word grpCH   :13;
    word         :1;
    word grpCH_14 :2;
  } MergedBits;
} NB_ACCRSTR;
extern volatile NB_ACCRSTR _NB_ACCR @(REG_BASE + 0x00000382UL);
#define NB_ACCR                         _NB_ACCR.Word
#define NB_ACCR_CH0                     _NB_ACCR.Bits.CH0
#define NB_ACCR_CH1                     _NB_ACCR.Bits.CH1
#define NB_ACCR_CH2                     _NB_ACCR.Bits.CH2
#define NB_ACCR_CH3                     _NB_ACCR.Bits.CH3
#define NB_ACCR_CH4                     _NB_ACCR.Bits.CH4
#define NB_ACCR_CH5                     _NB_ACCR.Bits.CH5
#define NB_ACCR_CH6                     _NB_ACCR.Bits.CH6
#define NB_ACCR_CH7                     _NB_ACCR.Bits.CH7
#define NB_ACCR_CH8                     _NB_ACCR.Bits.CH8
#define NB_ACCR_CH9                     _NB_ACCR.Bits.CH9
#define NB_ACCR_CH10                    _NB_ACCR.Bits.CH10
#define NB_ACCR_CH11                    _NB_ACCR.Bits.CH11
#define NB_ACCR_CH12                    _NB_ACCR.Bits.CH12
#define NB_ACCR_CH14                    _NB_ACCR.Bits.CH14
#define NB_ACCR_CH15                    _NB_ACCR.Bits.CH15
#define NB_ACCR_CH                      _NB_ACCR.MergedBits.grpCH
#define NB_ACCR_CH_14                   _NB_ACCR.MergedBits.grpCH_14

#define NB_ACCR_CH0_MASK                1U
#define NB_ACCR_CH1_MASK                2U
#define NB_ACCR_CH2_MASK                4U
#define NB_ACCR_CH3_MASK                8U
#define NB_ACCR_CH4_MASK                16U
#define NB_ACCR_CH5_MASK                32U
#define NB_ACCR_CH6_MASK                64U
#define NB_ACCR_CH7_MASK                128U
#define NB_ACCR_CH8_MASK                256U
#define NB_ACCR_CH9_MASK                512U
#define NB_ACCR_CH10_MASK               1024U
#define NB_ACCR_CH11_MASK               2048U
#define NB_ACCR_CH12_MASK               4096U
#define NB_ACCR_CH14_MASK               16384U
#define NB_ACCR_CH15_MASK               32768U
#define NB_ACCR_CH_MASK                 8191U
#define NB_ACCR_CH_BITNUM               0U
#define NB_ACCR_CH_14_MASK              49152U
#define NB_ACCR_CH_14_BITNUM            14U


/*** NB_ACCSR - ADC Conversion Complete Status Register; 0x00000384 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ACCSRhi - ADC Conversion Complete Status Register High; 0x00000384 ***/
    union {
      byte Byte;
      struct {
        byte CC8         :1;                                       /* Conversion Complete Flag 8 */
        byte CC9         :1;                                       /* Conversion Complete Flag 9 */
        byte CC10        :1;                                       /* Conversion Complete Flag 10 */
        byte CC11        :1;                                       /* Conversion Complete Flag 11 */
        byte CC12        :1;                                       /* Conversion Complete Flag 12 */
        byte             :1; 
        byte CC14        :1;                                       /* Conversion Complete Flag 14 */
        byte CC15        :1;                                       /* Conversion Complete Flag 15 */
      } Bits;
      struct {
        byte grpCC_8 :5;
        byte     :1;
        byte grpCC_14 :2;
      } MergedBits;
    } NB_ACCSRhiSTR;
    #define NB_ACCSRhi                  _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.Byte
    #define NB_ACCSRhi_CC8              _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.Bits.CC8
    #define NB_ACCSRhi_CC9              _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.Bits.CC9
    #define NB_ACCSRhi_CC10             _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.Bits.CC10
    #define NB_ACCSRhi_CC11             _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.Bits.CC11
    #define NB_ACCSRhi_CC12             _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.Bits.CC12
    #define NB_ACCSRhi_CC14             _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.Bits.CC14
    #define NB_ACCSRhi_CC15             _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.Bits.CC15
    #define NB_ACCSRhi_CC_8             _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.MergedBits.grpCC_8
    #define NB_ACCSRhi_CC_14            _NB_ACCSR.Overlap_STR.NB_ACCSRhiSTR.MergedBits.grpCC_14
    #define NB_ACCSRhi_CC               NB_ACCSRhi_CC_8
    
    #define NB_ACCSRhi_CC8_MASK         1U
    #define NB_ACCSRhi_CC9_MASK         2U
    #define NB_ACCSRhi_CC10_MASK        4U
    #define NB_ACCSRhi_CC11_MASK        8U
    #define NB_ACCSRhi_CC12_MASK        16U
    #define NB_ACCSRhi_CC14_MASK        64U
    #define NB_ACCSRhi_CC15_MASK        128U
    #define NB_ACCSRhi_CC_8_MASK        31U
    #define NB_ACCSRhi_CC_8_BITNUM      0U
    #define NB_ACCSRhi_CC_14_MASK       192U
    #define NB_ACCSRhi_CC_14_BITNUM     6U
    

    /*** NB_ACCSRlo - ADC Conversion Complete Status Register Low; 0x00000385 ***/
    union {
      byte Byte;
      struct {
        byte CC0         :1;                                       /* Conversion Complete Flag 0 */
        byte CC1         :1;                                       /* Conversion Complete Flag 1 */
        byte CC2         :1;                                       /* Conversion Complete Flag 2 */
        byte CC3         :1;                                       /* Conversion Complete Flag 3 */
        byte CC4         :1;                                       /* Conversion Complete Flag 4 */
        byte CC5         :1;                                       /* Conversion Complete Flag 5 */
        byte CC6         :1;                                       /* Conversion Complete Flag 6 */
        byte CC7         :1;                                       /* Conversion Complete Flag 7 */
      } Bits;
    } NB_ACCSRloSTR;
    #define NB_ACCSRlo                  _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Byte
    #define NB_ACCSRlo_CC0              _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Bits.CC0
    #define NB_ACCSRlo_CC1              _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Bits.CC1
    #define NB_ACCSRlo_CC2              _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Bits.CC2
    #define NB_ACCSRlo_CC3              _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Bits.CC3
    #define NB_ACCSRlo_CC4              _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Bits.CC4
    #define NB_ACCSRlo_CC5              _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Bits.CC5
    #define NB_ACCSRlo_CC6              _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Bits.CC6
    #define NB_ACCSRlo_CC7              _NB_ACCSR.Overlap_STR.NB_ACCSRloSTR.Bits.CC7
    
    #define NB_ACCSRlo_CC0_MASK         1U
    #define NB_ACCSRlo_CC1_MASK         2U
    #define NB_ACCSRlo_CC2_MASK         4U
    #define NB_ACCSRlo_CC3_MASK         8U
    #define NB_ACCSRlo_CC4_MASK         16U
    #define NB_ACCSRlo_CC5_MASK         32U
    #define NB_ACCSRlo_CC6_MASK         64U
    #define NB_ACCSRlo_CC7_MASK         128U
    
  } Overlap_STR;

  struct {
    word CC0         :1;                                       /* Conversion Complete Flag 0 */
    word CC1         :1;                                       /* Conversion Complete Flag 1 */
    word CC2         :1;                                       /* Conversion Complete Flag 2 */
    word CC3         :1;                                       /* Conversion Complete Flag 3 */
    word CC4         :1;                                       /* Conversion Complete Flag 4 */
    word CC5         :1;                                       /* Conversion Complete Flag 5 */
    word CC6         :1;                                       /* Conversion Complete Flag 6 */
    word CC7         :1;                                       /* Conversion Complete Flag 7 */
    word CC8         :1;                                       /* Conversion Complete Flag 8 */
    word CC9         :1;                                       /* Conversion Complete Flag 9 */
    word CC10        :1;                                       /* Conversion Complete Flag 10 */
    word CC11        :1;                                       /* Conversion Complete Flag 11 */
    word CC12        :1;                                       /* Conversion Complete Flag 12 */
    word             :1; 
    word CC14        :1;                                       /* Conversion Complete Flag 14 */
    word CC15        :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
  struct {
    word grpCC   :13;
    word         :1;
    word grpCC_14 :2;
  } MergedBits;
} NB_ACCSRSTR;
extern volatile NB_ACCSRSTR _NB_ACCSR @(REG_BASE + 0x00000384UL);
#define NB_ACCSR                        _NB_ACCSR.Word
#define NB_ACCSR_CC0                    _NB_ACCSR.Bits.CC0
#define NB_ACCSR_CC1                    _NB_ACCSR.Bits.CC1
#define NB_ACCSR_CC2                    _NB_ACCSR.Bits.CC2
#define NB_ACCSR_CC3                    _NB_ACCSR.Bits.CC3
#define NB_ACCSR_CC4                    _NB_ACCSR.Bits.CC4
#define NB_ACCSR_CC5                    _NB_ACCSR.Bits.CC5
#define NB_ACCSR_CC6                    _NB_ACCSR.Bits.CC6
#define NB_ACCSR_CC7                    _NB_ACCSR.Bits.CC7
#define NB_ACCSR_CC8                    _NB_ACCSR.Bits.CC8
#define NB_ACCSR_CC9                    _NB_ACCSR.Bits.CC9
#define NB_ACCSR_CC10                   _NB_ACCSR.Bits.CC10
#define NB_ACCSR_CC11                   _NB_ACCSR.Bits.CC11
#define NB_ACCSR_CC12                   _NB_ACCSR.Bits.CC12
#define NB_ACCSR_CC14                   _NB_ACCSR.Bits.CC14
#define NB_ACCSR_CC15                   _NB_ACCSR.Bits.CC15
#define NB_ACCSR_CC                     _NB_ACCSR.MergedBits.grpCC
#define NB_ACCSR_CC_14                  _NB_ACCSR.MergedBits.grpCC_14

#define NB_ACCSR_CC0_MASK               1U
#define NB_ACCSR_CC1_MASK               2U
#define NB_ACCSR_CC2_MASK               4U
#define NB_ACCSR_CC3_MASK               8U
#define NB_ACCSR_CC4_MASK               16U
#define NB_ACCSR_CC5_MASK               32U
#define NB_ACCSR_CC6_MASK               64U
#define NB_ACCSR_CC7_MASK               128U
#define NB_ACCSR_CC8_MASK               256U
#define NB_ACCSR_CC9_MASK               512U
#define NB_ACCSR_CC10_MASK              1024U
#define NB_ACCSR_CC11_MASK              2048U
#define NB_ACCSR_CC12_MASK              4096U
#define NB_ACCSR_CC14_MASK              16384U
#define NB_ACCSR_CC15_MASK              32768U
#define NB_ACCSR_CC_MASK                8191U
#define NB_ACCSR_CC_BITNUM              0U
#define NB_ACCSR_CC_14_MASK             49152U
#define NB_ACCSR_CC_14_BITNUM           14U


/*** NB_ADR0 - ADC Data Result Register 0; 0x00000386 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR0hi - ADC Data Result Register 0 High; 0x00000386 ***/
    union {
      byte Byte;
    } NB_ADR0hiSTR;
    #define NB_ADR0hi                   _NB_ADR0.Overlap_STR.NB_ADR0hiSTR.Byte
    

    /*** NB_ADR0lo - ADC Data Result Register 0 Low; 0x00000387 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR0        :2;                                       /* ADC Channel 0 Result Bit 0 */
      } Bits;
    } NB_ADR0loSTR;
    #define NB_ADR0lo                   _NB_ADR0.Overlap_STR.NB_ADR0loSTR.Byte
    #define NB_ADR0lo_ADR0              _NB_ADR0.Overlap_STR.NB_ADR0loSTR.Bits.ADR0
    
    #define NB_ADR0lo_ADR0_MASK         192U
    #define NB_ADR0lo_ADR0_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR0        :10;                                      /* ADC Channel 0 Result Bit 0 */
  } Bits;
} NB_ADR0STR;
extern volatile NB_ADR0STR _NB_ADR0 @(REG_BASE + 0x00000386UL);
#define NB_ADR0                         _NB_ADR0.Word
#define NB_ADR0_ADR0                    _NB_ADR0.Bits.ADR0
/* NB_ADR_ARR: Access 16 NB_ADRx registers in an array */
#define NB_ADR_ARR                      ((volatile word *) &NB_ADR0)

#define NB_ADR0_ADR0_MASK               65472U
#define NB_ADR0_ADR0_BITNUM             6U


/*** NB_ADR1 - ADC Data Result Register 1; 0x00000388 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR1hi - ADC Data Result Register 1 High; 0x00000388 ***/
    union {
      byte Byte;
    } NB_ADR1hiSTR;
    #define NB_ADR1hi                   _NB_ADR1.Overlap_STR.NB_ADR1hiSTR.Byte
    

    /*** NB_ADR1lo - ADC Data Result Register 1 Low; 0x00000389 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR1        :2;                                       /* ADC Channel 1 Result Bit 0 */
      } Bits;
    } NB_ADR1loSTR;
    #define NB_ADR1lo                   _NB_ADR1.Overlap_STR.NB_ADR1loSTR.Byte
    #define NB_ADR1lo_ADR1              _NB_ADR1.Overlap_STR.NB_ADR1loSTR.Bits.ADR1
    
    #define NB_ADR1lo_ADR1_MASK         192U
    #define NB_ADR1lo_ADR1_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR1        :10;                                      /* ADC Channel 1 Result Bit 0 */
  } Bits;
} NB_ADR1STR;
extern volatile NB_ADR1STR _NB_ADR1 @(REG_BASE + 0x00000388UL);
#define NB_ADR1                         _NB_ADR1.Word
#define NB_ADR1_ADR1                    _NB_ADR1.Bits.ADR1

#define NB_ADR1_ADR1_MASK               65472U
#define NB_ADR1_ADR1_BITNUM             6U


/*** NB_ADR2 - ADC Data Result Register 2; 0x0000038A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR2hi - ADC Data Result Register 2 High; 0x0000038A ***/
    union {
      byte Byte;
    } NB_ADR2hiSTR;
    #define NB_ADR2hi                   _NB_ADR2.Overlap_STR.NB_ADR2hiSTR.Byte
    

    /*** NB_ADR2lo - ADC Data Result Register 2 Low; 0x0000038B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR2        :2;                                       /* ADC Channel 2 Result Bit 0 */
      } Bits;
    } NB_ADR2loSTR;
    #define NB_ADR2lo                   _NB_ADR2.Overlap_STR.NB_ADR2loSTR.Byte
    #define NB_ADR2lo_ADR2              _NB_ADR2.Overlap_STR.NB_ADR2loSTR.Bits.ADR2
    
    #define NB_ADR2lo_ADR2_MASK         192U
    #define NB_ADR2lo_ADR2_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR2        :10;                                      /* ADC Channel 2 Result Bit 0 */
  } Bits;
} NB_ADR2STR;
extern volatile NB_ADR2STR _NB_ADR2 @(REG_BASE + 0x0000038AUL);
#define NB_ADR2                         _NB_ADR2.Word
#define NB_ADR2_ADR2                    _NB_ADR2.Bits.ADR2

#define NB_ADR2_ADR2_MASK               65472U
#define NB_ADR2_ADR2_BITNUM             6U


/*** NB_ADR3 - ADC Data Result Register 3; 0x0000038C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR3hi - ADC Data Result Register 3 High; 0x0000038C ***/
    union {
      byte Byte;
    } NB_ADR3hiSTR;
    #define NB_ADR3hi                   _NB_ADR3.Overlap_STR.NB_ADR3hiSTR.Byte
    

    /*** NB_ADR3lo - ADC Data Result Register 3 Low; 0x0000038D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR3        :2;                                       /* ADC Channel 3 Result Bit 0 */
      } Bits;
    } NB_ADR3loSTR;
    #define NB_ADR3lo                   _NB_ADR3.Overlap_STR.NB_ADR3loSTR.Byte
    #define NB_ADR3lo_ADR3              _NB_ADR3.Overlap_STR.NB_ADR3loSTR.Bits.ADR3
    
    #define NB_ADR3lo_ADR3_MASK         192U
    #define NB_ADR3lo_ADR3_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR3        :10;                                      /* ADC Channel 3 Result Bit 0 */
  } Bits;
} NB_ADR3STR;
extern volatile NB_ADR3STR _NB_ADR3 @(REG_BASE + 0x0000038CUL);
#define NB_ADR3                         _NB_ADR3.Word
#define NB_ADR3_ADR3                    _NB_ADR3.Bits.ADR3

#define NB_ADR3_ADR3_MASK               65472U
#define NB_ADR3_ADR3_BITNUM             6U


/*** NB_ADR4 - ADC Data Result Register 4; 0x0000038E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR4hi - ADC Data Result Register 4 High; 0x0000038E ***/
    union {
      byte Byte;
    } NB_ADR4hiSTR;
    #define NB_ADR4hi                   _NB_ADR4.Overlap_STR.NB_ADR4hiSTR.Byte
    

    /*** NB_ADR4lo - ADC Data Result Register 4 Low; 0x0000038F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR4        :2;                                       /* ADC Channel 4 Result Bit 0 */
      } Bits;
    } NB_ADR4loSTR;
    #define NB_ADR4lo                   _NB_ADR4.Overlap_STR.NB_ADR4loSTR.Byte
    #define NB_ADR4lo_ADR4              _NB_ADR4.Overlap_STR.NB_ADR4loSTR.Bits.ADR4
    
    #define NB_ADR4lo_ADR4_MASK         192U
    #define NB_ADR4lo_ADR4_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR4        :10;                                      /* ADC Channel 4 Result Bit 0 */
  } Bits;
} NB_ADR4STR;
extern volatile NB_ADR4STR _NB_ADR4 @(REG_BASE + 0x0000038EUL);
#define NB_ADR4                         _NB_ADR4.Word
#define NB_ADR4_ADR4                    _NB_ADR4.Bits.ADR4

#define NB_ADR4_ADR4_MASK               65472U
#define NB_ADR4_ADR4_BITNUM             6U


/*** NB_ADR5 - ADC Data Result Register 5; 0x00000390 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR5hi - ADC Data Result Register 5 High; 0x00000390 ***/
    union {
      byte Byte;
    } NB_ADR5hiSTR;
    #define NB_ADR5hi                   _NB_ADR5.Overlap_STR.NB_ADR5hiSTR.Byte
    

    /*** NB_ADR5lo - ADC Data Result Register 5 Low; 0x00000391 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR5        :2;                                       /* ADC Channel 5 Result Bit 0 */
      } Bits;
    } NB_ADR5loSTR;
    #define NB_ADR5lo                   _NB_ADR5.Overlap_STR.NB_ADR5loSTR.Byte
    #define NB_ADR5lo_ADR5              _NB_ADR5.Overlap_STR.NB_ADR5loSTR.Bits.ADR5
    
    #define NB_ADR5lo_ADR5_MASK         192U
    #define NB_ADR5lo_ADR5_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR5        :10;                                      /* ADC Channel 5 Result Bit 0 */
  } Bits;
} NB_ADR5STR;
extern volatile NB_ADR5STR _NB_ADR5 @(REG_BASE + 0x00000390UL);
#define NB_ADR5                         _NB_ADR5.Word
#define NB_ADR5_ADR5                    _NB_ADR5.Bits.ADR5

#define NB_ADR5_ADR5_MASK               65472U
#define NB_ADR5_ADR5_BITNUM             6U


/*** NB_ADR6 - ADC Data Result Register 6; 0x00000392 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR6hi - ADC Data Result Register 6 High; 0x00000392 ***/
    union {
      byte Byte;
    } NB_ADR6hiSTR;
    #define NB_ADR6hi                   _NB_ADR6.Overlap_STR.NB_ADR6hiSTR.Byte
    

    /*** NB_ADR6lo - ADC Data Result Register 6 Low; 0x00000393 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR6        :2;                                       /* ADC Channel 6 Result Bit 0 */
      } Bits;
    } NB_ADR6loSTR;
    #define NB_ADR6lo                   _NB_ADR6.Overlap_STR.NB_ADR6loSTR.Byte
    #define NB_ADR6lo_ADR6              _NB_ADR6.Overlap_STR.NB_ADR6loSTR.Bits.ADR6
    
    #define NB_ADR6lo_ADR6_MASK         192U
    #define NB_ADR6lo_ADR6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR6        :10;                                      /* ADC Channel 6 Result Bit 0 */
  } Bits;
} NB_ADR6STR;
extern volatile NB_ADR6STR _NB_ADR6 @(REG_BASE + 0x00000392UL);
#define NB_ADR6                         _NB_ADR6.Word
#define NB_ADR6_ADR6                    _NB_ADR6.Bits.ADR6

#define NB_ADR6_ADR6_MASK               65472U
#define NB_ADR6_ADR6_BITNUM             6U


/*** NB_ADR7 - ADC Data Result Register 7; 0x00000394 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR7hi - ADC Data Result Register 7 High; 0x00000394 ***/
    union {
      byte Byte;
    } NB_ADR7hiSTR;
    #define NB_ADR7hi                   _NB_ADR7.Overlap_STR.NB_ADR7hiSTR.Byte
    

    /*** NB_ADR7lo - ADC Data Result Register 7 Low; 0x00000395 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR7        :2;                                       /* ADC Channel 7 Result Bit 0 */
      } Bits;
    } NB_ADR7loSTR;
    #define NB_ADR7lo                   _NB_ADR7.Overlap_STR.NB_ADR7loSTR.Byte
    #define NB_ADR7lo_ADR7              _NB_ADR7.Overlap_STR.NB_ADR7loSTR.Bits.ADR7
    
    #define NB_ADR7lo_ADR7_MASK         192U
    #define NB_ADR7lo_ADR7_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR7        :10;                                      /* ADC Channel 7 Result Bit 0 */
  } Bits;
} NB_ADR7STR;
extern volatile NB_ADR7STR _NB_ADR7 @(REG_BASE + 0x00000394UL);
#define NB_ADR7                         _NB_ADR7.Word
#define NB_ADR7_ADR7                    _NB_ADR7.Bits.ADR7

#define NB_ADR7_ADR7_MASK               65472U
#define NB_ADR7_ADR7_BITNUM             6U


/*** NB_ADR8 - ADC Data Result Register 8; 0x00000396 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR8hi - ADC Data Result Register 8 High; 0x00000396 ***/
    union {
      byte Byte;
    } NB_ADR8hiSTR;
    #define NB_ADR8hi                   _NB_ADR8.Overlap_STR.NB_ADR8hiSTR.Byte
    

    /*** NB_ADR8lo - ADC Data Result Register 8 Low; 0x00000397 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR8        :2;                                       /* ADC Channel 8 Result Bit 0 */
      } Bits;
    } NB_ADR8loSTR;
    #define NB_ADR8lo                   _NB_ADR8.Overlap_STR.NB_ADR8loSTR.Byte
    #define NB_ADR8lo_ADR8              _NB_ADR8.Overlap_STR.NB_ADR8loSTR.Bits.ADR8
    
    #define NB_ADR8lo_ADR8_MASK         192U
    #define NB_ADR8lo_ADR8_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR8        :10;                                      /* ADC Channel 8 Result Bit 0 */
  } Bits;
} NB_ADR8STR;
extern volatile NB_ADR8STR _NB_ADR8 @(REG_BASE + 0x00000396UL);
#define NB_ADR8                         _NB_ADR8.Word
#define NB_ADR8_ADR8                    _NB_ADR8.Bits.ADR8

#define NB_ADR8_ADR8_MASK               65472U
#define NB_ADR8_ADR8_BITNUM             6U


/*** NB_ADR9 - ADC Data Result Register 9; 0x00000398 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR9hi - ADC Data Result Register 9 High; 0x00000398 ***/
    union {
      byte Byte;
    } NB_ADR9hiSTR;
    #define NB_ADR9hi                   _NB_ADR9.Overlap_STR.NB_ADR9hiSTR.Byte
    

    /*** NB_ADR9lo - ADC Data Result Register 9 Low; 0x00000399 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR9        :2;                                       /* ADC Channel 9 Result Bit 0 */
      } Bits;
    } NB_ADR9loSTR;
    #define NB_ADR9lo                   _NB_ADR9.Overlap_STR.NB_ADR9loSTR.Byte
    #define NB_ADR9lo_ADR9              _NB_ADR9.Overlap_STR.NB_ADR9loSTR.Bits.ADR9
    
    #define NB_ADR9lo_ADR9_MASK         192U
    #define NB_ADR9lo_ADR9_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR9        :10;                                      /* ADC Channel 9 Result Bit 0 */
  } Bits;
} NB_ADR9STR;
extern volatile NB_ADR9STR _NB_ADR9 @(REG_BASE + 0x00000398UL);
#define NB_ADR9                         _NB_ADR9.Word
#define NB_ADR9_ADR9                    _NB_ADR9.Bits.ADR9

#define NB_ADR9_ADR9_MASK               65472U
#define NB_ADR9_ADR9_BITNUM             6U


/*** NB_ADR10 - ADC Data Result Register 10; 0x0000039A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR10hi - ADC Data Result Register 10 High; 0x0000039A ***/
    union {
      byte Byte;
    } NB_ADR10hiSTR;
    #define NB_ADR10hi                  _NB_ADR10.Overlap_STR.NB_ADR10hiSTR.Byte
    

    /*** NB_ADR10lo - ADC Data Result Register 10 Low; 0x0000039B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR10       :2;                                       /* ADC Channel 10 Result Bit 0 */
      } Bits;
    } NB_ADR10loSTR;
    #define NB_ADR10lo                  _NB_ADR10.Overlap_STR.NB_ADR10loSTR.Byte
    #define NB_ADR10lo_ADR10            _NB_ADR10.Overlap_STR.NB_ADR10loSTR.Bits.ADR10
    
    #define NB_ADR10lo_ADR10_MASK       192U
    #define NB_ADR10lo_ADR10_BITNUM     6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR10       :10;                                      /* ADC Channel 10 Result Bit 0 */
  } Bits;
} NB_ADR10STR;
extern volatile NB_ADR10STR _NB_ADR10 @(REG_BASE + 0x0000039AUL);
#define NB_ADR10                        _NB_ADR10.Word
#define NB_ADR10_ADR10                  _NB_ADR10.Bits.ADR10

#define NB_ADR10_ADR10_MASK             65472U
#define NB_ADR10_ADR10_BITNUM           6U


/*** NB_ADR11 - ADC Data Result Register 11; 0x0000039C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR11hi - ADC Data Result Register 11 High; 0x0000039C ***/
    union {
      byte Byte;
    } NB_ADR11hiSTR;
    #define NB_ADR11hi                  _NB_ADR11.Overlap_STR.NB_ADR11hiSTR.Byte
    

    /*** NB_ADR11lo - ADC Data Result Register 11 Low; 0x0000039D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR11       :2;                                       /* ADC Channel 11 Result Bit 0 */
      } Bits;
    } NB_ADR11loSTR;
    #define NB_ADR11lo                  _NB_ADR11.Overlap_STR.NB_ADR11loSTR.Byte
    #define NB_ADR11lo_ADR11            _NB_ADR11.Overlap_STR.NB_ADR11loSTR.Bits.ADR11
    
    #define NB_ADR11lo_ADR11_MASK       192U
    #define NB_ADR11lo_ADR11_BITNUM     6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR11       :10;                                      /* ADC Channel 11 Result Bit 0 */
  } Bits;
} NB_ADR11STR;
extern volatile NB_ADR11STR _NB_ADR11 @(REG_BASE + 0x0000039CUL);
#define NB_ADR11                        _NB_ADR11.Word
#define NB_ADR11_ADR11                  _NB_ADR11.Bits.ADR11

#define NB_ADR11_ADR11_MASK             65472U
#define NB_ADR11_ADR11_BITNUM           6U


/*** NB_ADR12 - ADC Data Result Register 12; 0x0000039E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR12hi - ADC Data Result Register 12 High; 0x0000039E ***/
    union {
      byte Byte;
    } NB_ADR12hiSTR;
    #define NB_ADR12hi                  _NB_ADR12.Overlap_STR.NB_ADR12hiSTR.Byte
    

    /*** NB_ADR12lo - ADC Data Result Register 12 Low; 0x0000039F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR12       :2;                                       /* ADC Channel 12 Result Bit 0 */
      } Bits;
    } NB_ADR12loSTR;
    #define NB_ADR12lo                  _NB_ADR12.Overlap_STR.NB_ADR12loSTR.Byte
    #define NB_ADR12lo_ADR12            _NB_ADR12.Overlap_STR.NB_ADR12loSTR.Bits.ADR12
    
    #define NB_ADR12lo_ADR12_MASK       192U
    #define NB_ADR12lo_ADR12_BITNUM     6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR12       :10;                                      /* ADC Channel 12 Result Bit 0 */
  } Bits;
} NB_ADR12STR;
extern volatile NB_ADR12STR _NB_ADR12 @(REG_BASE + 0x0000039EUL);
#define NB_ADR12                        _NB_ADR12.Word
#define NB_ADR12_ADR12                  _NB_ADR12.Bits.ADR12

#define NB_ADR12_ADR12_MASK             65472U
#define NB_ADR12_ADR12_BITNUM           6U


/*** NB_ADR13 - ADC Data Result Register 13; 0x000003A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR13hi - ADC Data Result Register 13 High; 0x000003A0 ***/
    union {
      byte Byte;
    } NB_ADR13hiSTR;
    #define NB_ADR13hi                  _NB_ADR13.Overlap_STR.NB_ADR13hiSTR.Byte
    

    /*** NB_ADR13lo - ADC Data Result Register 13 Low; 0x000003A1 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR13       :2;                                       /* ADC Channel 13 Result Bit 0 */
      } Bits;
    } NB_ADR13loSTR;
    #define NB_ADR13lo                  _NB_ADR13.Overlap_STR.NB_ADR13loSTR.Byte
    #define NB_ADR13lo_ADR13            _NB_ADR13.Overlap_STR.NB_ADR13loSTR.Bits.ADR13
    
    #define NB_ADR13lo_ADR13_MASK       192U
    #define NB_ADR13lo_ADR13_BITNUM     6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR13       :10;                                      /* ADC Channel 13 Result Bit 0 */
  } Bits;
} NB_ADR13STR;
extern volatile NB_ADR13STR _NB_ADR13 @(REG_BASE + 0x000003A0UL);
#define NB_ADR13                        _NB_ADR13.Word
#define NB_ADR13_ADR13                  _NB_ADR13.Bits.ADR13

#define NB_ADR13_ADR13_MASK             65472U
#define NB_ADR13_ADR13_BITNUM           6U


/*** NB_ADR14 - ADC Data Result Register 14; 0x000003A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR14hi - ADC Data Result Register 14 High; 0x000003A2 ***/
    union {
      byte Byte;
    } NB_ADR14hiSTR;
    #define NB_ADR14hi                  _NB_ADR14.Overlap_STR.NB_ADR14hiSTR.Byte
    

    /*** NB_ADR14lo - ADC Data Result Register 14 Low; 0x000003A3 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR14       :2;                                       /* ADC Channel 14 Result Bit 0 */
      } Bits;
    } NB_ADR14loSTR;
    #define NB_ADR14lo                  _NB_ADR14.Overlap_STR.NB_ADR14loSTR.Byte
    #define NB_ADR14lo_ADR14            _NB_ADR14.Overlap_STR.NB_ADR14loSTR.Bits.ADR14
    
    #define NB_ADR14lo_ADR14_MASK       192U
    #define NB_ADR14lo_ADR14_BITNUM     6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR14       :10;                                      /* ADC Channel 14 Result Bit 0 */
  } Bits;
} NB_ADR14STR;
extern volatile NB_ADR14STR _NB_ADR14 @(REG_BASE + 0x000003A2UL);
#define NB_ADR14                        _NB_ADR14.Word
#define NB_ADR14_ADR14                  _NB_ADR14.Bits.ADR14

#define NB_ADR14_ADR14_MASK             65472U
#define NB_ADR14_ADR14_BITNUM           6U


/*** NB_ADR15 - ADC Data Result Register 15; 0x000003A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_ADR15hi - ADC Data Result Register 15 High; 0x000003A4 ***/
    union {
      byte Byte;
    } NB_ADR15hiSTR;
    #define NB_ADR15hi                  _NB_ADR15.Overlap_STR.NB_ADR15hiSTR.Byte
    

    /*** NB_ADR15lo - ADC Data Result Register 15 Low; 0x000003A5 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ADR15       :2;                                       /* ADC Channel 15 Result Bit 0 */
      } Bits;
    } NB_ADR15loSTR;
    #define NB_ADR15lo                  _NB_ADR15.Overlap_STR.NB_ADR15loSTR.Byte
    #define NB_ADR15lo_ADR15            _NB_ADR15.Overlap_STR.NB_ADR15loSTR.Bits.ADR15
    
    #define NB_ADR15lo_ADR15_MASK       192U
    #define NB_ADR15lo_ADR15_BITNUM     6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ADR15       :10;                                      /* ADC Channel 15 Result Bit 0 */
  } Bits;
} NB_ADR15STR;
extern volatile NB_ADR15STR _NB_ADR15 @(REG_BASE + 0x000003A4UL);
#define NB_ADR15                        _NB_ADR15.Word
#define NB_ADR15_ADR15                  _NB_ADR15.Bits.ADR15

#define NB_ADR15_ADR15_MASK             65472U
#define NB_ADR15_ADR15_BITNUM           6U


/*** NB_TIOS - Timer Input Capture/Output Compare Select; 0x000003C0 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIOS  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_TIOSSTR;
extern volatile NB_TIOSSTR _NB_TIOS @(REG_BASE + 0x000003C0UL);
#define NB_TIOS                         _NB_TIOS.Byte
#define NB_TIOS_IOS0                    _NB_TIOS.Bits.IOS0
#define NB_TIOS_IOS1                    _NB_TIOS.Bits.IOS1
#define NB_TIOS_IOS2                    _NB_TIOS.Bits.IOS2
#define NB_TIOS_IOS3                    _NB_TIOS.Bits.IOS3
#define NB_TIOS_IOS                     _NB_TIOS.MergedBits.grpIOS

#define NB_TIOS_IOS0_MASK               1U
#define NB_TIOS_IOS1_MASK               2U
#define NB_TIOS_IOS2_MASK               4U
#define NB_TIOS_IOS3_MASK               8U
#define NB_TIOS_IOS_MASK                15U
#define NB_TIOS_IOS_BITNUM              0U


/*** NB_CFORC - Timer Compare Force Register; 0x000003C1 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpFOC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_CFORCSTR;
extern volatile NB_CFORCSTR _NB_CFORC @(REG_BASE + 0x000003C1UL);
#define NB_CFORC                        _NB_CFORC.Byte
#define NB_CFORC_FOC0                   _NB_CFORC.Bits.FOC0
#define NB_CFORC_FOC1                   _NB_CFORC.Bits.FOC1
#define NB_CFORC_FOC2                   _NB_CFORC.Bits.FOC2
#define NB_CFORC_FOC3                   _NB_CFORC.Bits.FOC3
#define NB_CFORC_FOC                    _NB_CFORC.MergedBits.grpFOC

#define NB_CFORC_FOC0_MASK              1U
#define NB_CFORC_FOC1_MASK              2U
#define NB_CFORC_FOC2_MASK              4U
#define NB_CFORC_FOC3_MASK              8U
#define NB_CFORC_FOC_MASK               15U
#define NB_CFORC_FOC_BITNUM             0U


/*** NB_OC3M - Output Compare 3 Mask Register; 0x000003C2 ***/
typedef union {
  byte Byte;
  struct {
    byte OC3M0       :1;                                       /* Output Compare 3 Mask Bit 0 */
    byte OC3M1       :1;                                       /* Output Compare 3 Mask Bit 1 */
    byte OC3M2       :1;                                       /* Output Compare 3 Mask Bit 2 */
    byte OC3M3       :1;                                       /* Output Compare 3 Mask Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOC3M :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_OC3MSTR;
extern volatile NB_OC3MSTR _NB_OC3M @(REG_BASE + 0x000003C2UL);
#define NB_OC3M                         _NB_OC3M.Byte
#define NB_OC3M_OC3M0                   _NB_OC3M.Bits.OC3M0
#define NB_OC3M_OC3M1                   _NB_OC3M.Bits.OC3M1
#define NB_OC3M_OC3M2                   _NB_OC3M.Bits.OC3M2
#define NB_OC3M_OC3M3                   _NB_OC3M.Bits.OC3M3
#define NB_OC3M_OC3M                    _NB_OC3M.MergedBits.grpOC3M

#define NB_OC3M_OC3M0_MASK              1U
#define NB_OC3M_OC3M1_MASK              2U
#define NB_OC3M_OC3M2_MASK              4U
#define NB_OC3M_OC3M3_MASK              8U
#define NB_OC3M_OC3M_MASK               15U
#define NB_OC3M_OC3M_BITNUM             0U


/*** NB_OC3D - Output Compare 3 Data Register; 0x000003C3 ***/
typedef union {
  byte Byte;
  struct {
    byte OC3D0       :1;                                       /* Output Compare 3 Bit 0 */
    byte OC3D1       :1;                                       /* Output Compare 3 Bit 1 */
    byte OC3D2       :1;                                       /* Output Compare 3 Bit 2 */
    byte OC3D3       :1;                                       /* Output Compare 3 Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOC3D :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_OC3DSTR;
extern volatile NB_OC3DSTR _NB_OC3D @(REG_BASE + 0x000003C3UL);
#define NB_OC3D                         _NB_OC3D.Byte
#define NB_OC3D_OC3D0                   _NB_OC3D.Bits.OC3D0
#define NB_OC3D_OC3D1                   _NB_OC3D.Bits.OC3D1
#define NB_OC3D_OC3D2                   _NB_OC3D.Bits.OC3D2
#define NB_OC3D_OC3D3                   _NB_OC3D.Bits.OC3D3
#define NB_OC3D_OC3D                    _NB_OC3D.MergedBits.grpOC3D

#define NB_OC3D_OC3D0_MASK              1U
#define NB_OC3D_OC3D1_MASK              2U
#define NB_OC3D_OC3D2_MASK              4U
#define NB_OC3D_OC3D3_MASK              8U
#define NB_OC3D_OC3D_MASK               15U
#define NB_OC3D_OC3D_BITNUM             0U


/*** NB_TCNT - Timer Count Register; 0x000003C4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TCNTHi - Timer Count Register High; 0x000003C4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Count Register Bit 8 */
        byte BIT9        :1;                                       /* Timer Count Register Bit 9 */
        byte BIT10       :1;                                       /* Timer Count Register Bit 10 */
        byte BIT11       :1;                                       /* Timer Count Register Bit 11 */
        byte BIT12       :1;                                       /* Timer Count Register Bit 12 */
        byte BIT13       :1;                                       /* Timer Count Register Bit 13 */
        byte BIT14       :1;                                       /* Timer Count Register Bit 14 */
        byte BIT15       :1;                                       /* Timer Count Register Bit 15 */
      } Bits;
    } NB_TCNTHiSTR;
    #define NB_TCNTHi                   _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Byte
    #define NB_TCNTHi_BIT8              _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT8
    #define NB_TCNTHi_BIT9              _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT9
    #define NB_TCNTHi_BIT10             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT10
    #define NB_TCNTHi_BIT11             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT11
    #define NB_TCNTHi_BIT12             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT12
    #define NB_TCNTHi_BIT13             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT13
    #define NB_TCNTHi_BIT14             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT14
    #define NB_TCNTHi_BIT15             _NB_TCNT.Overlap_STR.NB_TCNTHiSTR.Bits.BIT15
    
    #define NB_TCNTHi_BIT8_MASK         1U
    #define NB_TCNTHi_BIT9_MASK         2U
    #define NB_TCNTHi_BIT10_MASK        4U
    #define NB_TCNTHi_BIT11_MASK        8U
    #define NB_TCNTHi_BIT12_MASK        16U
    #define NB_TCNTHi_BIT13_MASK        32U
    #define NB_TCNTHi_BIT14_MASK        64U
    #define NB_TCNTHi_BIT15_MASK        128U
    

    /*** NB_TCNTLo - Timer Count Register Low; 0x000003C5 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Count Register Bit 0 */
        byte BIT1        :1;                                       /* Timer Count Register Bit 1 */
        byte BIT2        :1;                                       /* Timer Count Register Bit 2 */
        byte BIT3        :1;                                       /* Timer Count Register Bit 3 */
        byte BIT4        :1;                                       /* Timer Count Register Bit 4 */
        byte BIT5        :1;                                       /* Timer Count Register Bit 5 */
        byte BIT6        :1;                                       /* Timer Count Register Bit 6 */
        byte BIT7        :1;                                       /* Timer Count Register Bit 7 */
      } Bits;
    } NB_TCNTLoSTR;
    #define NB_TCNTLo                   _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Byte
    #define NB_TCNTLo_BIT0              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT0
    #define NB_TCNTLo_BIT1              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT1
    #define NB_TCNTLo_BIT2              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT2
    #define NB_TCNTLo_BIT3              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT3
    #define NB_TCNTLo_BIT4              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT4
    #define NB_TCNTLo_BIT5              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT5
    #define NB_TCNTLo_BIT6              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT6
    #define NB_TCNTLo_BIT7              _NB_TCNT.Overlap_STR.NB_TCNTLoSTR.Bits.BIT7
    
    #define NB_TCNTLo_BIT0_MASK         1U
    #define NB_TCNTLo_BIT1_MASK         2U
    #define NB_TCNTLo_BIT2_MASK         4U
    #define NB_TCNTLo_BIT3_MASK         8U
    #define NB_TCNTLo_BIT4_MASK         16U
    #define NB_TCNTLo_BIT5_MASK         32U
    #define NB_TCNTLo_BIT6_MASK         64U
    #define NB_TCNTLo_BIT7_MASK         128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Count Register Bit 0 */
    word BIT1        :1;                                       /* Timer Count Register Bit 1 */
    word BIT2        :1;                                       /* Timer Count Register Bit 2 */
    word BIT3        :1;                                       /* Timer Count Register Bit 3 */
    word BIT4        :1;                                       /* Timer Count Register Bit 4 */
    word BIT5        :1;                                       /* Timer Count Register Bit 5 */
    word BIT6        :1;                                       /* Timer Count Register Bit 6 */
    word BIT7        :1;                                       /* Timer Count Register Bit 7 */
    word BIT8        :1;                                       /* Timer Count Register Bit 8 */
    word BIT9        :1;                                       /* Timer Count Register Bit 9 */
    word BIT10       :1;                                       /* Timer Count Register Bit 10 */
    word BIT11       :1;                                       /* Timer Count Register Bit 11 */
    word BIT12       :1;                                       /* Timer Count Register Bit 12 */
    word BIT13       :1;                                       /* Timer Count Register Bit 13 */
    word BIT14       :1;                                       /* Timer Count Register Bit 14 */
    word BIT15       :1;                                       /* Timer Count Register Bit 15 */
  } Bits;
} NB_TCNTSTR;
extern volatile NB_TCNTSTR _NB_TCNT @(REG_BASE + 0x000003C4UL);
#define NB_TCNT                         _NB_TCNT.Word
#define NB_TCNT_BIT0                    _NB_TCNT.Bits.BIT0
#define NB_TCNT_BIT1                    _NB_TCNT.Bits.BIT1
#define NB_TCNT_BIT2                    _NB_TCNT.Bits.BIT2
#define NB_TCNT_BIT3                    _NB_TCNT.Bits.BIT3
#define NB_TCNT_BIT4                    _NB_TCNT.Bits.BIT4
#define NB_TCNT_BIT5                    _NB_TCNT.Bits.BIT5
#define NB_TCNT_BIT6                    _NB_TCNT.Bits.BIT6
#define NB_TCNT_BIT7                    _NB_TCNT.Bits.BIT7
#define NB_TCNT_BIT8                    _NB_TCNT.Bits.BIT8
#define NB_TCNT_BIT9                    _NB_TCNT.Bits.BIT9
#define NB_TCNT_BIT10                   _NB_TCNT.Bits.BIT10
#define NB_TCNT_BIT11                   _NB_TCNT.Bits.BIT11
#define NB_TCNT_BIT12                   _NB_TCNT.Bits.BIT12
#define NB_TCNT_BIT13                   _NB_TCNT.Bits.BIT13
#define NB_TCNT_BIT14                   _NB_TCNT.Bits.BIT14
#define NB_TCNT_BIT15                   _NB_TCNT.Bits.BIT15

#define NB_TCNT_BIT0_MASK               1U
#define NB_TCNT_BIT1_MASK               2U
#define NB_TCNT_BIT2_MASK               4U
#define NB_TCNT_BIT3_MASK               8U
#define NB_TCNT_BIT4_MASK               16U
#define NB_TCNT_BIT5_MASK               32U
#define NB_TCNT_BIT6_MASK               64U
#define NB_TCNT_BIT7_MASK               128U
#define NB_TCNT_BIT8_MASK               256U
#define NB_TCNT_BIT9_MASK               512U
#define NB_TCNT_BIT10_MASK              1024U
#define NB_TCNT_BIT11_MASK              2048U
#define NB_TCNT_BIT12_MASK              4096U
#define NB_TCNT_BIT13_MASK              8192U
#define NB_TCNT_BIT14_MASK              16384U
#define NB_TCNT_BIT15_MASK              32768U


/*** NB_TSCR1 - Timer System Control Register1; 0x000003C6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte             :1; 
    byte             :1; 
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} NB_TSCR1STR;
extern volatile NB_TSCR1STR _NB_TSCR1 @(REG_BASE + 0x000003C6UL);
#define NB_TSCR1                        _NB_TSCR1.Byte
#define NB_TSCR1_TFFCA                  _NB_TSCR1.Bits.TFFCA
#define NB_TSCR1_TEN                    _NB_TSCR1.Bits.TEN

#define NB_TSCR1_TFFCA_MASK             16U
#define NB_TSCR1_TEN_MASK               128U


/*** NB_TTOV - Timer Toggle On Overflow Register; 0x000003C7 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTOV  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_TTOVSTR;
extern volatile NB_TTOVSTR _NB_TTOV @(REG_BASE + 0x000003C7UL);
#define NB_TTOV                         _NB_TTOV.Byte
#define NB_TTOV_TOV0                    _NB_TTOV.Bits.TOV0
#define NB_TTOV_TOV1                    _NB_TTOV.Bits.TOV1
#define NB_TTOV_TOV2                    _NB_TTOV.Bits.TOV2
#define NB_TTOV_TOV3                    _NB_TTOV.Bits.TOV3
#define NB_TTOV_TOV                     _NB_TTOV.MergedBits.grpTOV

#define NB_TTOV_TOV0_MASK               1U
#define NB_TTOV_TOV1_MASK               2U
#define NB_TTOV_TOV2_MASK               4U
#define NB_TTOV_TOV3_MASK               8U
#define NB_TTOV_TOV_MASK                15U
#define NB_TTOV_TOV_BITNUM              0U


/*** NB_TCTL1 - Timer Control Register 1; 0x000003C8 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Lecel Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} NB_TCTL1STR;
extern volatile NB_TCTL1STR _NB_TCTL1 @(REG_BASE + 0x000003C8UL);
#define NB_TCTL1                        _NB_TCTL1.Byte
#define NB_TCTL1_OL0                    _NB_TCTL1.Bits.OL0
#define NB_TCTL1_OM0                    _NB_TCTL1.Bits.OM0
#define NB_TCTL1_OL1                    _NB_TCTL1.Bits.OL1
#define NB_TCTL1_OM1                    _NB_TCTL1.Bits.OM1
#define NB_TCTL1_OL2                    _NB_TCTL1.Bits.OL2
#define NB_TCTL1_OM2                    _NB_TCTL1.Bits.OM2
#define NB_TCTL1_OL3                    _NB_TCTL1.Bits.OL3
#define NB_TCTL1_OM3                    _NB_TCTL1.Bits.OM3

#define NB_TCTL1_OL0_MASK               1U
#define NB_TCTL1_OM0_MASK               2U
#define NB_TCTL1_OL1_MASK               4U
#define NB_TCTL1_OM1_MASK               8U
#define NB_TCTL1_OL2_MASK               16U
#define NB_TCTL1_OM2_MASK               32U
#define NB_TCTL1_OL3_MASK               64U
#define NB_TCTL1_OM3_MASK               128U


/*** NB_TCTL2 - Timer Control Register 2; 0x000003C9 ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge 0 Control A */
    byte EDG0B       :1;                                       /* Input Capture Edge 0 Control B */
    byte EDG1A       :1;                                       /* Input Capture Edge 1 Control A */
    byte EDG1B       :1;                                       /* Input Capture Edge 1 Control B */
    byte EDG2A       :1;                                       /* Input Capture Edge 2 Control A */
    byte EDG2B       :1;                                       /* Input Capture Edge 2 Control B */
    byte EDG3A       :1;                                       /* Input Capture Edge 3 Control A */
    byte EDG3B       :1;                                       /* Input Capture Edge 3 Control B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} NB_TCTL2STR;
extern volatile NB_TCTL2STR _NB_TCTL2 @(REG_BASE + 0x000003C9UL);
#define NB_TCTL2                        _NB_TCTL2.Byte
#define NB_TCTL2_EDG0A                  _NB_TCTL2.Bits.EDG0A
#define NB_TCTL2_EDG0B                  _NB_TCTL2.Bits.EDG0B
#define NB_TCTL2_EDG1A                  _NB_TCTL2.Bits.EDG1A
#define NB_TCTL2_EDG1B                  _NB_TCTL2.Bits.EDG1B
#define NB_TCTL2_EDG2A                  _NB_TCTL2.Bits.EDG2A
#define NB_TCTL2_EDG2B                  _NB_TCTL2.Bits.EDG2B
#define NB_TCTL2_EDG3A                  _NB_TCTL2.Bits.EDG3A
#define NB_TCTL2_EDG3B                  _NB_TCTL2.Bits.EDG3B
#define NB_TCTL2_EDG0x                  _NB_TCTL2.MergedBits.grpEDG0x
#define NB_TCTL2_EDG1x                  _NB_TCTL2.MergedBits.grpEDG1x
#define NB_TCTL2_EDG2x                  _NB_TCTL2.MergedBits.grpEDG2x
#define NB_TCTL2_EDG3x                  _NB_TCTL2.MergedBits.grpEDG3x

#define NB_TCTL2_EDG0A_MASK             1U
#define NB_TCTL2_EDG0B_MASK             2U
#define NB_TCTL2_EDG1A_MASK             4U
#define NB_TCTL2_EDG1B_MASK             8U
#define NB_TCTL2_EDG2A_MASK             16U
#define NB_TCTL2_EDG2B_MASK             32U
#define NB_TCTL2_EDG3A_MASK             64U
#define NB_TCTL2_EDG3B_MASK             128U
#define NB_TCTL2_EDG0x_MASK             3U
#define NB_TCTL2_EDG0x_BITNUM           0U
#define NB_TCTL2_EDG1x_MASK             12U
#define NB_TCTL2_EDG1x_BITNUM           2U
#define NB_TCTL2_EDG2x_MASK             48U
#define NB_TCTL2_EDG2x_BITNUM           4U
#define NB_TCTL2_EDG3x_MASK             192U
#define NB_TCTL2_EDG3x_BITNUM           6U


/*** NB_TIE - Timer Interrupt Enable Register; 0x000003CA ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_TIESTR;
extern volatile NB_TIESTR _NB_TIE @(REG_BASE + 0x000003CAUL);
#define NB_TIE                          _NB_TIE.Byte
#define NB_TIE_C0I                      _NB_TIE.Bits.C0I
#define NB_TIE_C1I                      _NB_TIE.Bits.C1I
#define NB_TIE_C2I                      _NB_TIE.Bits.C2I
#define NB_TIE_C3I                      _NB_TIE.Bits.C3I

#define NB_TIE_C0I_MASK                 1U
#define NB_TIE_C1I_MASK                 2U
#define NB_TIE_C2I_MASK                 4U
#define NB_TIE_C3I_MASK                 8U


/*** NB_TSCR2 - Timer System Control Register 2; 0x000003CB ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_TSCR2STR;
extern volatile NB_TSCR2STR _NB_TSCR2 @(REG_BASE + 0x000003CBUL);
#define NB_TSCR2                        _NB_TSCR2.Byte
#define NB_TSCR2_PR0                    _NB_TSCR2.Bits.PR0
#define NB_TSCR2_PR1                    _NB_TSCR2.Bits.PR1
#define NB_TSCR2_PR2                    _NB_TSCR2.Bits.PR2
#define NB_TSCR2_TCRE                   _NB_TSCR2.Bits.TCRE
#define NB_TSCR2_TOI                    _NB_TSCR2.Bits.TOI
#define NB_TSCR2_PR                     _NB_TSCR2.MergedBits.grpPR

#define NB_TSCR2_PR0_MASK               1U
#define NB_TSCR2_PR1_MASK               2U
#define NB_TSCR2_PR2_MASK               4U
#define NB_TSCR2_TCRE_MASK              8U
#define NB_TSCR2_TOI_MASK               128U
#define NB_TSCR2_PR_MASK                7U
#define NB_TSCR2_PR_BITNUM              0U


/*** NB_TFLG1 - Main Timer Interrupt Flag 1; 0x000003CC ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_TFLG1STR;
extern volatile NB_TFLG1STR _NB_TFLG1 @(REG_BASE + 0x000003CCUL);
#define NB_TFLG1                        _NB_TFLG1.Byte
#define NB_TFLG1_C0F                    _NB_TFLG1.Bits.C0F
#define NB_TFLG1_C1F                    _NB_TFLG1.Bits.C1F
#define NB_TFLG1_C2F                    _NB_TFLG1.Bits.C2F
#define NB_TFLG1_C3F                    _NB_TFLG1.Bits.C3F

#define NB_TFLG1_C0F_MASK               1U
#define NB_TFLG1_C1F_MASK               2U
#define NB_TFLG1_C2F_MASK               4U
#define NB_TFLG1_C3F_MASK               8U


/*** NB_TFLG2 - Main Timer Interrupt Flag 2; 0x000003CD ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} NB_TFLG2STR;
extern volatile NB_TFLG2STR _NB_TFLG2 @(REG_BASE + 0x000003CDUL);
#define NB_TFLG2                        _NB_TFLG2.Byte
#define NB_TFLG2_TOF                    _NB_TFLG2.Bits.TOF

#define NB_TFLG2_TOF_MASK               128U


/*** NB_TC0 - Timer Input Capture/Output Compare Register 0; 0x000003CE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000003CE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 15 */
      } Bits;
    } NB_TC0HiSTR;
    #define NB_TC0Hi                    _NB_TC0.Overlap_STR.NB_TC0HiSTR.Byte
    #define NB_TC0Hi_BIT8               _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT8
    #define NB_TC0Hi_BIT9               _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT9
    #define NB_TC0Hi_BIT10              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT10
    #define NB_TC0Hi_BIT11              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT11
    #define NB_TC0Hi_BIT12              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT12
    #define NB_TC0Hi_BIT13              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT13
    #define NB_TC0Hi_BIT14              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT14
    #define NB_TC0Hi_BIT15              _NB_TC0.Overlap_STR.NB_TC0HiSTR.Bits.BIT15
    
    #define NB_TC0Hi_BIT8_MASK          1U
    #define NB_TC0Hi_BIT9_MASK          2U
    #define NB_TC0Hi_BIT10_MASK         4U
    #define NB_TC0Hi_BIT11_MASK         8U
    #define NB_TC0Hi_BIT12_MASK         16U
    #define NB_TC0Hi_BIT13_MASK         32U
    #define NB_TC0Hi_BIT14_MASK         64U
    #define NB_TC0Hi_BIT15_MASK         128U
    

    /*** NB_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000003CF ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 7 */
      } Bits;
    } NB_TC0LoSTR;
    #define NB_TC0Lo                    _NB_TC0.Overlap_STR.NB_TC0LoSTR.Byte
    #define NB_TC0Lo_BIT0               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT0
    #define NB_TC0Lo_BIT1               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT1
    #define NB_TC0Lo_BIT2               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT2
    #define NB_TC0Lo_BIT3               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT3
    #define NB_TC0Lo_BIT4               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT4
    #define NB_TC0Lo_BIT5               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT5
    #define NB_TC0Lo_BIT6               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT6
    #define NB_TC0Lo_BIT7               _NB_TC0.Overlap_STR.NB_TC0LoSTR.Bits.BIT7
    
    #define NB_TC0Lo_BIT0_MASK          1U
    #define NB_TC0Lo_BIT1_MASK          2U
    #define NB_TC0Lo_BIT2_MASK          4U
    #define NB_TC0Lo_BIT3_MASK          8U
    #define NB_TC0Lo_BIT4_MASK          16U
    #define NB_TC0Lo_BIT5_MASK          32U
    #define NB_TC0Lo_BIT6_MASK          64U
    #define NB_TC0Lo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 0 Bit 15 */
  } Bits;
} NB_TC0STR;
extern volatile NB_TC0STR _NB_TC0 @(REG_BASE + 0x000003CEUL);
#define NB_TC0                          _NB_TC0.Word
#define NB_TC0_BIT0                     _NB_TC0.Bits.BIT0
#define NB_TC0_BIT1                     _NB_TC0.Bits.BIT1
#define NB_TC0_BIT2                     _NB_TC0.Bits.BIT2
#define NB_TC0_BIT3                     _NB_TC0.Bits.BIT3
#define NB_TC0_BIT4                     _NB_TC0.Bits.BIT4
#define NB_TC0_BIT5                     _NB_TC0.Bits.BIT5
#define NB_TC0_BIT6                     _NB_TC0.Bits.BIT6
#define NB_TC0_BIT7                     _NB_TC0.Bits.BIT7
#define NB_TC0_BIT8                     _NB_TC0.Bits.BIT8
#define NB_TC0_BIT9                     _NB_TC0.Bits.BIT9
#define NB_TC0_BIT10                    _NB_TC0.Bits.BIT10
#define NB_TC0_BIT11                    _NB_TC0.Bits.BIT11
#define NB_TC0_BIT12                    _NB_TC0.Bits.BIT12
#define NB_TC0_BIT13                    _NB_TC0.Bits.BIT13
#define NB_TC0_BIT14                    _NB_TC0.Bits.BIT14
#define NB_TC0_BIT15                    _NB_TC0.Bits.BIT15
/* NB_TC_ARR: Access 4 NB_TCx registers in an array */
#define NB_TC_ARR                       ((volatile word *) &NB_TC0)

#define NB_TC0_BIT0_MASK                1U
#define NB_TC0_BIT1_MASK                2U
#define NB_TC0_BIT2_MASK                4U
#define NB_TC0_BIT3_MASK                8U
#define NB_TC0_BIT4_MASK                16U
#define NB_TC0_BIT5_MASK                32U
#define NB_TC0_BIT6_MASK                64U
#define NB_TC0_BIT7_MASK                128U
#define NB_TC0_BIT8_MASK                256U
#define NB_TC0_BIT9_MASK                512U
#define NB_TC0_BIT10_MASK               1024U
#define NB_TC0_BIT11_MASK               2048U
#define NB_TC0_BIT12_MASK               4096U
#define NB_TC0_BIT13_MASK               8192U
#define NB_TC0_BIT14_MASK               16384U
#define NB_TC0_BIT15_MASK               32768U


/*** NB_TC1 - Timer Input Capture/Output Compare Register 1; 0x000003D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000003D0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 15 */
      } Bits;
    } NB_TC1HiSTR;
    #define NB_TC1Hi                    _NB_TC1.Overlap_STR.NB_TC1HiSTR.Byte
    #define NB_TC1Hi_BIT8               _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT8
    #define NB_TC1Hi_BIT9               _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT9
    #define NB_TC1Hi_BIT10              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT10
    #define NB_TC1Hi_BIT11              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT11
    #define NB_TC1Hi_BIT12              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT12
    #define NB_TC1Hi_BIT13              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT13
    #define NB_TC1Hi_BIT14              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT14
    #define NB_TC1Hi_BIT15              _NB_TC1.Overlap_STR.NB_TC1HiSTR.Bits.BIT15
    
    #define NB_TC1Hi_BIT8_MASK          1U
    #define NB_TC1Hi_BIT9_MASK          2U
    #define NB_TC1Hi_BIT10_MASK         4U
    #define NB_TC1Hi_BIT11_MASK         8U
    #define NB_TC1Hi_BIT12_MASK         16U
    #define NB_TC1Hi_BIT13_MASK         32U
    #define NB_TC1Hi_BIT14_MASK         64U
    #define NB_TC1Hi_BIT15_MASK         128U
    

    /*** NB_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000003D1 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 7 */
      } Bits;
    } NB_TC1LoSTR;
    #define NB_TC1Lo                    _NB_TC1.Overlap_STR.NB_TC1LoSTR.Byte
    #define NB_TC1Lo_BIT0               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT0
    #define NB_TC1Lo_BIT1               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT1
    #define NB_TC1Lo_BIT2               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT2
    #define NB_TC1Lo_BIT3               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT3
    #define NB_TC1Lo_BIT4               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT4
    #define NB_TC1Lo_BIT5               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT5
    #define NB_TC1Lo_BIT6               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT6
    #define NB_TC1Lo_BIT7               _NB_TC1.Overlap_STR.NB_TC1LoSTR.Bits.BIT7
    
    #define NB_TC1Lo_BIT0_MASK          1U
    #define NB_TC1Lo_BIT1_MASK          2U
    #define NB_TC1Lo_BIT2_MASK          4U
    #define NB_TC1Lo_BIT3_MASK          8U
    #define NB_TC1Lo_BIT4_MASK          16U
    #define NB_TC1Lo_BIT5_MASK          32U
    #define NB_TC1Lo_BIT6_MASK          64U
    #define NB_TC1Lo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 1 Bit 15 */
  } Bits;
} NB_TC1STR;
extern volatile NB_TC1STR _NB_TC1 @(REG_BASE + 0x000003D0UL);
#define NB_TC1                          _NB_TC1.Word
#define NB_TC1_BIT0                     _NB_TC1.Bits.BIT0
#define NB_TC1_BIT1                     _NB_TC1.Bits.BIT1
#define NB_TC1_BIT2                     _NB_TC1.Bits.BIT2
#define NB_TC1_BIT3                     _NB_TC1.Bits.BIT3
#define NB_TC1_BIT4                     _NB_TC1.Bits.BIT4
#define NB_TC1_BIT5                     _NB_TC1.Bits.BIT5
#define NB_TC1_BIT6                     _NB_TC1.Bits.BIT6
#define NB_TC1_BIT7                     _NB_TC1.Bits.BIT7
#define NB_TC1_BIT8                     _NB_TC1.Bits.BIT8
#define NB_TC1_BIT9                     _NB_TC1.Bits.BIT9
#define NB_TC1_BIT10                    _NB_TC1.Bits.BIT10
#define NB_TC1_BIT11                    _NB_TC1.Bits.BIT11
#define NB_TC1_BIT12                    _NB_TC1.Bits.BIT12
#define NB_TC1_BIT13                    _NB_TC1.Bits.BIT13
#define NB_TC1_BIT14                    _NB_TC1.Bits.BIT14
#define NB_TC1_BIT15                    _NB_TC1.Bits.BIT15

#define NB_TC1_BIT0_MASK                1U
#define NB_TC1_BIT1_MASK                2U
#define NB_TC1_BIT2_MASK                4U
#define NB_TC1_BIT3_MASK                8U
#define NB_TC1_BIT4_MASK                16U
#define NB_TC1_BIT5_MASK                32U
#define NB_TC1_BIT6_MASK                64U
#define NB_TC1_BIT7_MASK                128U
#define NB_TC1_BIT8_MASK                256U
#define NB_TC1_BIT9_MASK                512U
#define NB_TC1_BIT10_MASK               1024U
#define NB_TC1_BIT11_MASK               2048U
#define NB_TC1_BIT12_MASK               4096U
#define NB_TC1_BIT13_MASK               8192U
#define NB_TC1_BIT14_MASK               16384U
#define NB_TC1_BIT15_MASK               32768U


/*** NB_TC2 - Timer Input Capture/Output Compare Register 2; 0x000003D2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000003D2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 15 */
      } Bits;
    } NB_TC2HiSTR;
    #define NB_TC2Hi                    _NB_TC2.Overlap_STR.NB_TC2HiSTR.Byte
    #define NB_TC2Hi_BIT8               _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT8
    #define NB_TC2Hi_BIT9               _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT9
    #define NB_TC2Hi_BIT10              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT10
    #define NB_TC2Hi_BIT11              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT11
    #define NB_TC2Hi_BIT12              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT12
    #define NB_TC2Hi_BIT13              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT13
    #define NB_TC2Hi_BIT14              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT14
    #define NB_TC2Hi_BIT15              _NB_TC2.Overlap_STR.NB_TC2HiSTR.Bits.BIT15
    
    #define NB_TC2Hi_BIT8_MASK          1U
    #define NB_TC2Hi_BIT9_MASK          2U
    #define NB_TC2Hi_BIT10_MASK         4U
    #define NB_TC2Hi_BIT11_MASK         8U
    #define NB_TC2Hi_BIT12_MASK         16U
    #define NB_TC2Hi_BIT13_MASK         32U
    #define NB_TC2Hi_BIT14_MASK         64U
    #define NB_TC2Hi_BIT15_MASK         128U
    

    /*** NB_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000003D3 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 7 */
      } Bits;
    } NB_TC2LoSTR;
    #define NB_TC2Lo                    _NB_TC2.Overlap_STR.NB_TC2LoSTR.Byte
    #define NB_TC2Lo_BIT0               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT0
    #define NB_TC2Lo_BIT1               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT1
    #define NB_TC2Lo_BIT2               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT2
    #define NB_TC2Lo_BIT3               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT3
    #define NB_TC2Lo_BIT4               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT4
    #define NB_TC2Lo_BIT5               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT5
    #define NB_TC2Lo_BIT6               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT6
    #define NB_TC2Lo_BIT7               _NB_TC2.Overlap_STR.NB_TC2LoSTR.Bits.BIT7
    
    #define NB_TC2Lo_BIT0_MASK          1U
    #define NB_TC2Lo_BIT1_MASK          2U
    #define NB_TC2Lo_BIT2_MASK          4U
    #define NB_TC2Lo_BIT3_MASK          8U
    #define NB_TC2Lo_BIT4_MASK          16U
    #define NB_TC2Lo_BIT5_MASK          32U
    #define NB_TC2Lo_BIT6_MASK          64U
    #define NB_TC2Lo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 2 Bit 15 */
  } Bits;
} NB_TC2STR;
extern volatile NB_TC2STR _NB_TC2 @(REG_BASE + 0x000003D2UL);
#define NB_TC2                          _NB_TC2.Word
#define NB_TC2_BIT0                     _NB_TC2.Bits.BIT0
#define NB_TC2_BIT1                     _NB_TC2.Bits.BIT1
#define NB_TC2_BIT2                     _NB_TC2.Bits.BIT2
#define NB_TC2_BIT3                     _NB_TC2.Bits.BIT3
#define NB_TC2_BIT4                     _NB_TC2.Bits.BIT4
#define NB_TC2_BIT5                     _NB_TC2.Bits.BIT5
#define NB_TC2_BIT6                     _NB_TC2.Bits.BIT6
#define NB_TC2_BIT7                     _NB_TC2.Bits.BIT7
#define NB_TC2_BIT8                     _NB_TC2.Bits.BIT8
#define NB_TC2_BIT9                     _NB_TC2.Bits.BIT9
#define NB_TC2_BIT10                    _NB_TC2.Bits.BIT10
#define NB_TC2_BIT11                    _NB_TC2.Bits.BIT11
#define NB_TC2_BIT12                    _NB_TC2.Bits.BIT12
#define NB_TC2_BIT13                    _NB_TC2.Bits.BIT13
#define NB_TC2_BIT14                    _NB_TC2.Bits.BIT14
#define NB_TC2_BIT15                    _NB_TC2.Bits.BIT15

#define NB_TC2_BIT0_MASK                1U
#define NB_TC2_BIT1_MASK                2U
#define NB_TC2_BIT2_MASK                4U
#define NB_TC2_BIT3_MASK                8U
#define NB_TC2_BIT4_MASK                16U
#define NB_TC2_BIT5_MASK                32U
#define NB_TC2_BIT6_MASK                64U
#define NB_TC2_BIT7_MASK                128U
#define NB_TC2_BIT8_MASK                256U
#define NB_TC2_BIT9_MASK                512U
#define NB_TC2_BIT10_MASK               1024U
#define NB_TC2_BIT11_MASK               2048U
#define NB_TC2_BIT12_MASK               4096U
#define NB_TC2_BIT13_MASK               8192U
#define NB_TC2_BIT14_MASK               16384U
#define NB_TC2_BIT15_MASK               32768U


/*** NB_TC3 - Timer Input Capture/Output Compare Register 3; 0x000003D4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** NB_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000003D4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 8 */
        byte BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 9 */
        byte BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 10 */
        byte BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 11 */
        byte BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 12 */
        byte BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 13 */
        byte BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 14 */
        byte BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 15 */
      } Bits;
    } NB_TC3HiSTR;
    #define NB_TC3Hi                    _NB_TC3.Overlap_STR.NB_TC3HiSTR.Byte
    #define NB_TC3Hi_BIT8               _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT8
    #define NB_TC3Hi_BIT9               _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT9
    #define NB_TC3Hi_BIT10              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT10
    #define NB_TC3Hi_BIT11              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT11
    #define NB_TC3Hi_BIT12              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT12
    #define NB_TC3Hi_BIT13              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT13
    #define NB_TC3Hi_BIT14              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT14
    #define NB_TC3Hi_BIT15              _NB_TC3.Overlap_STR.NB_TC3HiSTR.Bits.BIT15
    
    #define NB_TC3Hi_BIT8_MASK          1U
    #define NB_TC3Hi_BIT9_MASK          2U
    #define NB_TC3Hi_BIT10_MASK         4U
    #define NB_TC3Hi_BIT11_MASK         8U
    #define NB_TC3Hi_BIT12_MASK         16U
    #define NB_TC3Hi_BIT13_MASK         32U
    #define NB_TC3Hi_BIT14_MASK         64U
    #define NB_TC3Hi_BIT15_MASK         128U
    

    /*** NB_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000003D5 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 0 */
        byte BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 1 */
        byte BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 2 */
        byte BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 3 */
        byte BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 4 */
        byte BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 5 */
        byte BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 6 */
        byte BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 7 */
      } Bits;
    } NB_TC3LoSTR;
    #define NB_TC3Lo                    _NB_TC3.Overlap_STR.NB_TC3LoSTR.Byte
    #define NB_TC3Lo_BIT0               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT0
    #define NB_TC3Lo_BIT1               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT1
    #define NB_TC3Lo_BIT2               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT2
    #define NB_TC3Lo_BIT3               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT3
    #define NB_TC3Lo_BIT4               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT4
    #define NB_TC3Lo_BIT5               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT5
    #define NB_TC3Lo_BIT6               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT6
    #define NB_TC3Lo_BIT7               _NB_TC3.Overlap_STR.NB_TC3LoSTR.Bits.BIT7
    
    #define NB_TC3Lo_BIT0_MASK          1U
    #define NB_TC3Lo_BIT1_MASK          2U
    #define NB_TC3Lo_BIT2_MASK          4U
    #define NB_TC3Lo_BIT3_MASK          8U
    #define NB_TC3Lo_BIT4_MASK          16U
    #define NB_TC3Lo_BIT5_MASK          32U
    #define NB_TC3Lo_BIT6_MASK          64U
    #define NB_TC3Lo_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 0 */
    word BIT1        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 1 */
    word BIT2        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 2 */
    word BIT3        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 3 */
    word BIT4        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 4 */
    word BIT5        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 5 */
    word BIT6        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 6 */
    word BIT7        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 7 */
    word BIT8        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 8 */
    word BIT9        :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 9 */
    word BIT10       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 10 */
    word BIT11       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 11 */
    word BIT12       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 12 */
    word BIT13       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 13 */
    word BIT14       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 14 */
    word BIT15       :1;                                       /* Timer Input Capture/Output Compare Register 3 Bit 15 */
  } Bits;
} NB_TC3STR;
extern volatile NB_TC3STR _NB_TC3 @(REG_BASE + 0x000003D4UL);
#define NB_TC3                          _NB_TC3.Word
#define NB_TC3_BIT0                     _NB_TC3.Bits.BIT0
#define NB_TC3_BIT1                     _NB_TC3.Bits.BIT1
#define NB_TC3_BIT2                     _NB_TC3.Bits.BIT2
#define NB_TC3_BIT3                     _NB_TC3.Bits.BIT3
#define NB_TC3_BIT4                     _NB_TC3.Bits.BIT4
#define NB_TC3_BIT5                     _NB_TC3.Bits.BIT5
#define NB_TC3_BIT6                     _NB_TC3.Bits.BIT6
#define NB_TC3_BIT7                     _NB_TC3.Bits.BIT7
#define NB_TC3_BIT8                     _NB_TC3.Bits.BIT8
#define NB_TC3_BIT9                     _NB_TC3.Bits.BIT9
#define NB_TC3_BIT10                    _NB_TC3.Bits.BIT10
#define NB_TC3_BIT11                    _NB_TC3.Bits.BIT11
#define NB_TC3_BIT12                    _NB_TC3.Bits.BIT12
#define NB_TC3_BIT13                    _NB_TC3.Bits.BIT13
#define NB_TC3_BIT14                    _NB_TC3.Bits.BIT14
#define NB_TC3_BIT15                    _NB_TC3.Bits.BIT15

#define NB_TC3_BIT0_MASK                1U
#define NB_TC3_BIT1_MASK                2U
#define NB_TC3_BIT2_MASK                4U
#define NB_TC3_BIT3_MASK                8U
#define NB_TC3_BIT4_MASK                16U
#define NB_TC3_BIT5_MASK                32U
#define NB_TC3_BIT6_MASK                64U
#define NB_TC3_BIT7_MASK                128U
#define NB_TC3_BIT8_MASK                256U
#define NB_TC3_BIT9_MASK                512U
#define NB_TC3_BIT10_MASK               1024U
#define NB_TC3_BIT11_MASK               2048U
#define NB_TC3_BIT12_MASK               4096U
#define NB_TC3_BIT13_MASK               8192U
#define NB_TC3_BIT14_MASK               16384U
#define NB_TC3_BIT15_MASK               32768U


/*** NB_CTR0 - Trimming Register 0; 0x000003F0 ***/
typedef union {
  byte Byte;
  struct {
    byte WDCTR       :3;                                       /* Watchdog clock trim 0 */
    byte CTR0_3      :1;                                       /* Spare Trim bit 3 */
    byte CTR0_4      :1;                                       /* Spare Trim bit 4 */
    byte WDCTRE      :1;                                       /* Watchdog trim enable */
    byte LINTR       :1;                                       /* LIN trim bit */
    byte LINTRE      :1;                                       /* LIN trim enable */
  } Bits;
  struct {
    byte         :3;
    byte grpCTR0__3 :2;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NB_CTR0STR;
extern volatile NB_CTR0STR _NB_CTR0 @(REG_BASE + 0x000003F0UL);
#define NB_CTR0                         _NB_CTR0.Byte
#define NB_CTR0_WDCTR                   _NB_CTR0.Bits.WDCTR
#define NB_CTR0_CTR0_3                  _NB_CTR0.Bits.CTR0_3
#define NB_CTR0_CTR0_4                  _NB_CTR0.Bits.CTR0_4
#define NB_CTR0_WDCTRE                  _NB_CTR0.Bits.WDCTRE
#define NB_CTR0_LINTR                   _NB_CTR0.Bits.LINTR
#define NB_CTR0_LINTRE                  _NB_CTR0.Bits.LINTRE
/* NB_CTR_ARR: Access 4 NB_CTRx registers in an array */
#define NB_CTR_ARR                      ((volatile byte *) &NB_CTR0)
#define NB_CTR0_CTR0__3                 _NB_CTR0.MergedBits.grpCTR0__3
#define NB_CTR0_CTR0_                   NB_CTR0_CTR0__3

#define NB_CTR0_WDCTR_MASK              7U
#define NB_CTR0_WDCTR_BITNUM            0U
#define NB_CTR0_CTR0_3_MASK             8U
#define NB_CTR0_CTR0_4_MASK             16U
#define NB_CTR0_WDCTRE_MASK             32U
#define NB_CTR0_LINTR_MASK              64U
#define NB_CTR0_LINTRE_MASK             128U
#define NB_CTR0_CTR0__3_MASK            24U
#define NB_CTR0_CTR0__3_BITNUM          3U


/*** NB_CTR1 - Trimming Register 1; 0x000003F1 ***/
typedef union {
  byte Byte;
  struct {
    byte IREFTR      :3;                                       /* Iref trim 0 */
    byte IREFTRE     :1;                                       /* Iref trim enable bit */
    byte BGTRIMDN    :1;                                       /* Bandgap trim down bit */
    byte BGTRIMUP    :1;                                       /* Bandgap trim up bit */
    byte CTR1_6      :1;                                       /* Spare Trim Bit */
    byte BGTRE       :1;                                       /* Bandgap trim enable */
  } Bits;
} NB_CTR1STR;
extern volatile NB_CTR1STR _NB_CTR1 @(REG_BASE + 0x000003F1UL);
#define NB_CTR1                         _NB_CTR1.Byte
#define NB_CTR1_IREFTR                  _NB_CTR1.Bits.IREFTR
#define NB_CTR1_IREFTRE                 _NB_CTR1.Bits.IREFTRE
#define NB_CTR1_BGTRIMDN                _NB_CTR1.Bits.BGTRIMDN
#define NB_CTR1_BGTRIMUP                _NB_CTR1.Bits.BGTRIMUP
#define NB_CTR1_CTR1_6                  _NB_CTR1.Bits.CTR1_6
#define NB_CTR1_BGTRE                   _NB_CTR1.Bits.BGTRE

#define NB_CTR1_IREFTR_MASK             7U
#define NB_CTR1_IREFTR_BITNUM           0U
#define NB_CTR1_IREFTRE_MASK            8U
#define NB_CTR1_BGTRIMDN_MASK           16U
#define NB_CTR1_BGTRIMUP_MASK           32U
#define NB_CTR1_CTR1_6_MASK             64U
#define NB_CTR1_BGTRE_MASK              128U


/*** NB_CTR2 - Trimming Register 2; 0x000003F2 ***/
typedef union {
  byte Byte;
  struct {
    byte SLPBGTR     :3;                                       /* bg1p25sleep trim 0 */
    byte SLPBG_LOCK  :1;                                       /* bg1p25sleep trim lock bit */
    byte SLPBGTRE    :1;                                       /* Sleep Bandgap trim enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_CTR2STR;
extern volatile NB_CTR2STR _NB_CTR2 @(REG_BASE + 0x000003F2UL);
#define NB_CTR2                         _NB_CTR2.Byte
#define NB_CTR2_SLPBGTR                 _NB_CTR2.Bits.SLPBGTR
#define NB_CTR2_SLPBG_LOCK              _NB_CTR2.Bits.SLPBG_LOCK
#define NB_CTR2_SLPBGTRE                _NB_CTR2.Bits.SLPBGTRE

#define NB_CTR2_SLPBGTR_MASK            7U
#define NB_CTR2_SLPBGTR_BITNUM          0U
#define NB_CTR2_SLPBG_LOCK_MASK         8U
#define NB_CTR2_SLPBGTRE_MASK           16U


/*** NB_CTR3 - Trimming Register 3; 0x000003F3 ***/
typedef union {
  byte Byte;
  struct {
    byte CTR3_0      :1;                                       /* Spare Trim bit 0 */
    byte CTR3_1      :1;                                       /* Spare Trim bit 1 */
    byte CTR3_2      :1;                                       /* Spare Trim bit 2 */
    byte CTR3_E      :1;                                       /* Spare Trim enable bit */
    byte OFFCTR      :3;                                       /* ADCOFFC trim 0 */
    byte OFFCTRE     :1;                                       /* ADC offset compensation voltage trim enable bit */
  } Bits;
  struct {
    byte grpCTR3 :3;
    byte         :1;
    byte         :3;
    byte         :1;
  } MergedBits;
} NB_CTR3STR;
extern volatile NB_CTR3STR _NB_CTR3 @(REG_BASE + 0x000003F3UL);
#define NB_CTR3                         _NB_CTR3.Byte
#define NB_CTR3_CTR3_0                  _NB_CTR3.Bits.CTR3_0
#define NB_CTR3_CTR3_1                  _NB_CTR3.Bits.CTR3_1
#define NB_CTR3_CTR3_2                  _NB_CTR3.Bits.CTR3_2
#define NB_CTR3_CTR3_E                  _NB_CTR3.Bits.CTR3_E
#define NB_CTR3_OFFCTR                  _NB_CTR3.Bits.OFFCTR
#define NB_CTR3_OFFCTRE                 _NB_CTR3.Bits.OFFCTRE
#define NB_CTR3_CTR3                    _NB_CTR3.MergedBits.grpCTR3

#define NB_CTR3_CTR3_0_MASK             1U
#define NB_CTR3_CTR3_1_MASK             2U
#define NB_CTR3_CTR3_2_MASK             4U
#define NB_CTR3_CTR3_E_MASK             8U
#define NB_CTR3_OFFCTR_MASK             112U
#define NB_CTR3_OFFCTR_BITNUM           4U
#define NB_CTR3_OFFCTRE_MASK            128U
#define NB_CTR3_CTR3_MASK               7U
#define NB_CTR3_CTR3_BITNUM             0U


/*** NB_SRR - Silicon Revision Register; 0x000003F4 ***/
typedef union {
  byte Byte;
  struct {
    byte MMREV       :2;                                       /* MM912F634 analog die Silicon Revision Register Metal Tweak Revision */
    byte FMREV       :2;                                       /* MM912F634 analog die Silicon Revision Register Full Mask Revision */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NB_SRRSTR;
extern volatile NB_SRRSTR _NB_SRR @(REG_BASE + 0x000003F4UL);
#define NB_SRR                          _NB_SRR.Byte
#define NB_SRR_MMREV                    _NB_SRR.Bits.MMREV
#define NB_SRR_FMREV                    _NB_SRR.Bits.FMREV

#define NB_SRR_MMREV_MASK               3U
#define NB_SRR_MMREV_BITNUM             0U
#define NB_SRR_FMREV_MASK               12U
#define NB_SRR_FMREV_BITNUM             2U


/*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Comparison Key Bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Comparison Key Bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Comparison Key Bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Comparison Key Bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Comparison Key Bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Comparison Key Bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Comparison Key Bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Comparison Key Bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Comparison Key Bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Comparison Key Bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Comparison Key Bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Comparison Key Bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Comparison Key Bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Comparison Key Bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Comparison Key Bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Comparison Key Bits, bit 15 */
  } Bits;
} BAKEY0STR;
/* Tip for register initialization in the user code:  const word BAKEY0_INIT @0x0000FF00 = <BAKEY0_INITVAL>; */
#define _BAKEY0 (*(const BAKEY0STR *)0x0000FF00)
#define BAKEY0                          _BAKEY0.Word
#define BAKEY0_KEY0                     _BAKEY0.Bits.KEY0
#define BAKEY0_KEY1                     _BAKEY0.Bits.KEY1
#define BAKEY0_KEY2                     _BAKEY0.Bits.KEY2
#define BAKEY0_KEY3                     _BAKEY0.Bits.KEY3
#define BAKEY0_KEY4                     _BAKEY0.Bits.KEY4
#define BAKEY0_KEY5                     _BAKEY0.Bits.KEY5
#define BAKEY0_KEY6                     _BAKEY0.Bits.KEY6
#define BAKEY0_KEY7                     _BAKEY0.Bits.KEY7
#define BAKEY0_KEY8                     _BAKEY0.Bits.KEY8
#define BAKEY0_KEY9                     _BAKEY0.Bits.KEY9
#define BAKEY0_KEY10                    _BAKEY0.Bits.KEY10
#define BAKEY0_KEY11                    _BAKEY0.Bits.KEY11
#define BAKEY0_KEY12                    _BAKEY0.Bits.KEY12
#define BAKEY0_KEY13                    _BAKEY0.Bits.KEY13
#define BAKEY0_KEY14                    _BAKEY0.Bits.KEY14
#define BAKEY0_KEY15                    _BAKEY0.Bits.KEY15
/* BAKEY_ARR: Access 4 BAKEYx registers in an array */
#define BAKEY_ARR                       ((volatile word *) &BAKEY0)

#define BAKEY0_KEY0_MASK                1U
#define BAKEY0_KEY1_MASK                2U
#define BAKEY0_KEY2_MASK                4U
#define BAKEY0_KEY3_MASK                8U
#define BAKEY0_KEY4_MASK                16U
#define BAKEY0_KEY5_MASK                32U
#define BAKEY0_KEY6_MASK                64U
#define BAKEY0_KEY7_MASK                128U
#define BAKEY0_KEY8_MASK                256U
#define BAKEY0_KEY9_MASK                512U
#define BAKEY0_KEY10_MASK               1024U
#define BAKEY0_KEY11_MASK               2048U
#define BAKEY0_KEY12_MASK               4096U
#define BAKEY0_KEY13_MASK               8192U
#define BAKEY0_KEY14_MASK               16384U
#define BAKEY0_KEY15_MASK               32768U


/*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Comparison Key Bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Comparison Key Bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Comparison Key Bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Comparison Key Bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Comparison Key Bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Comparison Key Bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Comparison Key Bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Comparison Key Bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Comparison Key Bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Comparison Key Bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Comparison Key Bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Comparison Key Bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Comparison Key Bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Comparison Key Bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Comparison Key Bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Comparison Key Bits, bit 15 */
  } Bits;
} BAKEY1STR;
/* Tip for register initialization in the user code:  const word BAKEY1_INIT @0x0000FF02 = <BAKEY1_INITVAL>; */
#define _BAKEY1 (*(const BAKEY1STR *)0x0000FF02)
#define BAKEY1                          _BAKEY1.Word
#define BAKEY1_KEY0                     _BAKEY1.Bits.KEY0
#define BAKEY1_KEY1                     _BAKEY1.Bits.KEY1
#define BAKEY1_KEY2                     _BAKEY1.Bits.KEY2
#define BAKEY1_KEY3                     _BAKEY1.Bits.KEY3
#define BAKEY1_KEY4                     _BAKEY1.Bits.KEY4
#define BAKEY1_KEY5                     _BAKEY1.Bits.KEY5
#define BAKEY1_KEY6                     _BAKEY1.Bits.KEY6
#define BAKEY1_KEY7                     _BAKEY1.Bits.KEY7
#define BAKEY1_KEY8                     _BAKEY1.Bits.KEY8
#define BAKEY1_KEY9                     _BAKEY1.Bits.KEY9
#define BAKEY1_KEY10                    _BAKEY1.Bits.KEY10
#define BAKEY1_KEY11                    _BAKEY1.Bits.KEY11
#define BAKEY1_KEY12                    _BAKEY1.Bits.KEY12
#define BAKEY1_KEY13                    _BAKEY1.Bits.KEY13
#define BAKEY1_KEY14                    _BAKEY1.Bits.KEY14
#define BAKEY1_KEY15                    _BAKEY1.Bits.KEY15

#define BAKEY1_KEY0_MASK                1U
#define BAKEY1_KEY1_MASK                2U
#define BAKEY1_KEY2_MASK                4U
#define BAKEY1_KEY3_MASK                8U
#define BAKEY1_KEY4_MASK                16U
#define BAKEY1_KEY5_MASK                32U
#define BAKEY1_KEY6_MASK                64U
#define BAKEY1_KEY7_MASK                128U
#define BAKEY1_KEY8_MASK                256U
#define BAKEY1_KEY9_MASK                512U
#define BAKEY1_KEY10_MASK               1024U
#define BAKEY1_KEY11_MASK               2048U
#define BAKEY1_KEY12_MASK               4096U
#define BAKEY1_KEY13_MASK               8192U
#define BAKEY1_KEY14_MASK               16384U
#define BAKEY1_KEY15_MASK               32768U


/*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Comparison Key Bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Comparison Key Bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Comparison Key Bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Comparison Key Bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Comparison Key Bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Comparison Key Bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Comparison Key Bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Comparison Key Bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Comparison Key Bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Comparison Key Bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Comparison Key Bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Comparison Key Bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Comparison Key Bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Comparison Key Bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Comparison Key Bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Comparison Key Bits, bit 15 */
  } Bits;
} BAKEY2STR;
/* Tip for register initialization in the user code:  const word BAKEY2_INIT @0x0000FF04 = <BAKEY2_INITVAL>; */
#define _BAKEY2 (*(const BAKEY2STR *)0x0000FF04)
#define BAKEY2                          _BAKEY2.Word
#define BAKEY2_KEY0                     _BAKEY2.Bits.KEY0
#define BAKEY2_KEY1                     _BAKEY2.Bits.KEY1
#define BAKEY2_KEY2                     _BAKEY2.Bits.KEY2
#define BAKEY2_KEY3                     _BAKEY2.Bits.KEY3
#define BAKEY2_KEY4                     _BAKEY2.Bits.KEY4
#define BAKEY2_KEY5                     _BAKEY2.Bits.KEY5
#define BAKEY2_KEY6                     _BAKEY2.Bits.KEY6
#define BAKEY2_KEY7                     _BAKEY2.Bits.KEY7
#define BAKEY2_KEY8                     _BAKEY2.Bits.KEY8
#define BAKEY2_KEY9                     _BAKEY2.Bits.KEY9
#define BAKEY2_KEY10                    _BAKEY2.Bits.KEY10
#define BAKEY2_KEY11                    _BAKEY2.Bits.KEY11
#define BAKEY2_KEY12                    _BAKEY2.Bits.KEY12
#define BAKEY2_KEY13                    _BAKEY2.Bits.KEY13
#define BAKEY2_KEY14                    _BAKEY2.Bits.KEY14
#define BAKEY2_KEY15                    _BAKEY2.Bits.KEY15

#define BAKEY2_KEY0_MASK                1U
#define BAKEY2_KEY1_MASK                2U
#define BAKEY2_KEY2_MASK                4U
#define BAKEY2_KEY3_MASK                8U
#define BAKEY2_KEY4_MASK                16U
#define BAKEY2_KEY5_MASK                32U
#define BAKEY2_KEY6_MASK                64U
#define BAKEY2_KEY7_MASK                128U
#define BAKEY2_KEY8_MASK                256U
#define BAKEY2_KEY9_MASK                512U
#define BAKEY2_KEY10_MASK               1024U
#define BAKEY2_KEY11_MASK               2048U
#define BAKEY2_KEY12_MASK               4096U
#define BAKEY2_KEY13_MASK               8192U
#define BAKEY2_KEY14_MASK               16384U
#define BAKEY2_KEY15_MASK               32768U


/*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***/
typedef union {
  word Word;
  struct {
    word KEY0        :1;                                       /* Backdoor Comparison Key Bits, bit 0 */
    word KEY1        :1;                                       /* Backdoor Comparison Key Bits, bit 1 */
    word KEY2        :1;                                       /* Backdoor Comparison Key Bits, bit 2 */
    word KEY3        :1;                                       /* Backdoor Comparison Key Bits, bit 3 */
    word KEY4        :1;                                       /* Backdoor Comparison Key Bits, bit 4 */
    word KEY5        :1;                                       /* Backdoor Comparison Key Bits, bit 5 */
    word KEY6        :1;                                       /* Backdoor Comparison Key Bits, bit 6 */
    word KEY7        :1;                                       /* Backdoor Comparison Key Bits, bit 7 */
    word KEY8        :1;                                       /* Backdoor Comparison Key Bits, bit 8 */
    word KEY9        :1;                                       /* Backdoor Comparison Key Bits, bit 9 */
    word KEY10       :1;                                       /* Backdoor Comparison Key Bits, bit 10 */
    word KEY11       :1;                                       /* Backdoor Comparison Key Bits, bit 11 */
    word KEY12       :1;                                       /* Backdoor Comparison Key Bits, bit 12 */
    word KEY13       :1;                                       /* Backdoor Comparison Key Bits, bit 13 */
    word KEY14       :1;                                       /* Backdoor Comparison Key Bits, bit 14 */
    word KEY15       :1;                                       /* Backdoor Comparison Key Bits, bit 15 */
  } Bits;
} BAKEY3STR;
/* Tip for register initialization in the user code:  const word BAKEY3_INIT @0x0000FF06 = <BAKEY3_INITVAL>; */
#define _BAKEY3 (*(const BAKEY3STR *)0x0000FF06)
#define BAKEY3                          _BAKEY3.Word
#define BAKEY3_KEY0                     _BAKEY3.Bits.KEY0
#define BAKEY3_KEY1                     _BAKEY3.Bits.KEY1
#define BAKEY3_KEY2                     _BAKEY3.Bits.KEY2
#define BAKEY3_KEY3                     _BAKEY3.Bits.KEY3
#define BAKEY3_KEY4                     _BAKEY3.Bits.KEY4
#define BAKEY3_KEY5                     _BAKEY3.Bits.KEY5
#define BAKEY3_KEY6                     _BAKEY3.Bits.KEY6
#define BAKEY3_KEY7                     _BAKEY3.Bits.KEY7
#define BAKEY3_KEY8                     _BAKEY3.Bits.KEY8
#define BAKEY3_KEY9                     _BAKEY3.Bits.KEY9
#define BAKEY3_KEY10                    _BAKEY3.Bits.KEY10
#define BAKEY3_KEY11                    _BAKEY3.Bits.KEY11
#define BAKEY3_KEY12                    _BAKEY3.Bits.KEY12
#define BAKEY3_KEY13                    _BAKEY3.Bits.KEY13
#define BAKEY3_KEY14                    _BAKEY3.Bits.KEY14
#define BAKEY3_KEY15                    _BAKEY3.Bits.KEY15

#define BAKEY3_KEY0_MASK                1U
#define BAKEY3_KEY1_MASK                2U
#define BAKEY3_KEY2_MASK                4U
#define BAKEY3_KEY3_MASK                8U
#define BAKEY3_KEY4_MASK                16U
#define BAKEY3_KEY5_MASK                32U
#define BAKEY3_KEY6_MASK                64U
#define BAKEY3_KEY7_MASK                128U
#define BAKEY3_KEY8_MASK                256U
#define BAKEY3_KEY9_MASK                512U
#define BAKEY3_KEY10_MASK               1024U
#define BAKEY3_KEY11_MASK               2048U
#define BAKEY3_KEY12_MASK               4096U
#define BAKEY3_KEY13_MASK               8192U
#define BAKEY3_KEY14_MASK               16384U
#define BAKEY3_KEY15_MASK               32768U


/*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address Size Bit 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address Size Bit 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower Address Range Disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher Address Size Bit 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher Address Size Bit 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher Address Range Disable */
    byte RNV6        :1;                                       /* Reserved Nonvolatile Bit */
    byte FPOPEN      :1;                                       /* Flash Protection Operation Enable */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} NVFPROTSTR;
/* Tip for register initialization in the user code:  const byte NVFPROT_INIT @0x0000FF0C = <NVFPROT_INITVAL>; */
#define _NVFPROT (*(const NVFPROTSTR *)0x0000FF0C)
#define NVFPROT                         _NVFPROT.Byte
#define NVFPROT_FPLS0                   _NVFPROT.Bits.FPLS0
#define NVFPROT_FPLS1                   _NVFPROT.Bits.FPLS1
#define NVFPROT_FPLDIS                  _NVFPROT.Bits.FPLDIS
#define NVFPROT_FPHS0                   _NVFPROT.Bits.FPHS0
#define NVFPROT_FPHS1                   _NVFPROT.Bits.FPHS1
#define NVFPROT_FPHDIS                  _NVFPROT.Bits.FPHDIS
#define NVFPROT_RNV6                    _NVFPROT.Bits.RNV6
#define NVFPROT_FPOPEN                  _NVFPROT.Bits.FPOPEN
#define NVFPROT_FPLS                    _NVFPROT.MergedBits.grpFPLS
#define NVFPROT_FPHS                    _NVFPROT.MergedBits.grpFPHS

#define NVFPROT_FPLS0_MASK              1U
#define NVFPROT_FPLS1_MASK              2U
#define NVFPROT_FPLDIS_MASK             4U
#define NVFPROT_FPHS0_MASK              8U
#define NVFPROT_FPHS1_MASK              16U
#define NVFPROT_FPHDIS_MASK             32U
#define NVFPROT_RNV6_MASK               64U
#define NVFPROT_FPOPEN_MASK             128U
#define NVFPROT_FPLS_MASK               3U
#define NVFPROT_FPLS_BITNUM             0U
#define NVFPROT_FPHS_MASK               24U
#define NVFPROT_FPHS_BITNUM             3U


/*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***/
typedef union {
  byte Byte;
  struct {
    byte DPS0        :1;                                       /* D-Flash Protection Size Bit 0 */
    byte DPS1        :1;                                       /* D-Flash Protection Size Bit 1 */
    byte DPS2        :1;                                       /* D-Flash Protection Size Bit 2 */
    byte DPS3        :1;                                       /* D-Flash Protection Size Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte DPOPEN      :1;                                       /* D-Flash Protection Control */
  } Bits;
  struct {
    byte grpDPS  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NVDFPROTSTR;
/* Tip for register initialization in the user code:  const byte NVDFPROT_INIT @0x0000FF0D = <NVDFPROT_INITVAL>; */
#define _NVDFPROT (*(const NVDFPROTSTR *)0x0000FF0D)
#define NVDFPROT                        _NVDFPROT.Byte
#define NVDFPROT_DPS0                   _NVDFPROT.Bits.DPS0
#define NVDFPROT_DPS1                   _NVDFPROT.Bits.DPS1
#define NVDFPROT_DPS2                   _NVDFPROT.Bits.DPS2
#define NVDFPROT_DPS3                   _NVDFPROT.Bits.DPS3
#define NVDFPROT_DPOPEN                 _NVDFPROT.Bits.DPOPEN
#define NVDFPROT_DPS                    _NVDFPROT.MergedBits.grpDPS

#define NVDFPROT_DPS0_MASK              1U
#define NVDFPROT_DPS1_MASK              2U
#define NVDFPROT_DPS2_MASK              4U
#define NVDFPROT_DPS3_MASK              8U
#define NVDFPROT_DPOPEN_MASK            128U
#define NVDFPROT_DPS_MASK               15U
#define NVDFPROT_DPS_BITNUM             0U


/*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Nonvolatile Bit 0 */
    byte NV1         :1;                                       /* Nonvolatile Bit 1 */
    byte NV2         :1;                                       /* Nonvolatile Bit 2 */
    byte NV3         :1;                                       /* Nonvolatile Bit 3 */
    byte NV4         :1;                                       /* Nonvolatile Bit 4 */
    byte NV5         :1;                                       /* Nonvolatile Bit 5 */
    byte NV6         :1;                                       /* Nonvolatile Bit 6 */
    byte NV7         :1;                                       /* Nonvolatile Bit 7 */
  } Bits;
} NVFOPTSTR;
/* Tip for register initialization in the user code:  const byte NVFOPT_INIT @0x0000FF0E = <NVFOPT_INITVAL>; */
#define _NVFOPT (*(const NVFOPTSTR *)0x0000FF0E)
#define NVFOPT                          _NVFOPT.Byte
#define NVFOPT_NV0                      _NVFOPT.Bits.NV0
#define NVFOPT_NV1                      _NVFOPT.Bits.NV1
#define NVFOPT_NV2                      _NVFOPT.Bits.NV2
#define NVFOPT_NV3                      _NVFOPT.Bits.NV3
#define NVFOPT_NV4                      _NVFOPT.Bits.NV4
#define NVFOPT_NV5                      _NVFOPT.Bits.NV5
#define NVFOPT_NV6                      _NVFOPT.Bits.NV6
#define NVFOPT_NV7                      _NVFOPT.Bits.NV7

#define NVFOPT_NV0_MASK                 1U
#define NVFOPT_NV1_MASK                 2U
#define NVFOPT_NV2_MASK                 4U
#define NVFOPT_NV3_MASK                 8U
#define NVFOPT_NV4_MASK                 16U
#define NVFOPT_NV5_MASK                 32U
#define NVFOPT_NV6_MASK                 64U
#define NVFOPT_NV7_MASK                 128U


/*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte RNV2        :1;                                       /* Reserved Nonvolatile Bit 2 */
    byte RNV3        :1;                                       /* Reserved Nonvolatile Bit 3 */
    byte RNV4        :1;                                       /* Reserved Nonvolatile Bit 4 */
    byte RNV5        :1;                                       /* Reserved Nonvolatile Bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} NVFSECSTR;
/* Tip for register initialization in the user code:  const byte NVFSEC_INIT @0x0000FF0F = <NVFSEC_INITVAL>; */
#define _NVFSEC (*(const NVFSECSTR *)0x0000FF0F)
#define NVFSEC                          _NVFSEC.Byte
#define NVFSEC_SEC0                     _NVFSEC.Bits.SEC0
#define NVFSEC_SEC1                     _NVFSEC.Bits.SEC1
#define NVFSEC_RNV2                     _NVFSEC.Bits.RNV2
#define NVFSEC_RNV3                     _NVFSEC.Bits.RNV3
#define NVFSEC_RNV4                     _NVFSEC.Bits.RNV4
#define NVFSEC_RNV5                     _NVFSEC.Bits.RNV5
#define NVFSEC_KEYEN0                   _NVFSEC.Bits.KEYEN0
#define NVFSEC_KEYEN1                   _NVFSEC.Bits.KEYEN1
#define NVFSEC_SEC                      _NVFSEC.MergedBits.grpSEC
#define NVFSEC_RNV_2                    _NVFSEC.MergedBits.grpRNV_2
#define NVFSEC_KEYEN                    _NVFSEC.MergedBits.grpKEYEN
#define NVFSEC_RNV                      NVFSEC_RNV_2

#define NVFSEC_SEC0_MASK                1U
#define NVFSEC_SEC1_MASK                2U
#define NVFSEC_RNV2_MASK                4U
#define NVFSEC_RNV3_MASK                8U
#define NVFSEC_RNV4_MASK                16U
#define NVFSEC_RNV5_MASK                32U
#define NVFSEC_KEYEN0_MASK              64U
#define NVFSEC_KEYEN1_MASK              128U
#define NVFSEC_SEC_MASK                 3U
#define NVFSEC_SEC_BITNUM               0U
#define NVFSEC_RNV_2_MASK               60U
#define NVFSEC_RNV_2_BITNUM             2U
#define NVFSEC_KEYEN_MASK               192U
#define NVFSEC_KEYEN_BITNUM             6U


  /* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() (void)(CPMUARMCOP = 0x55U, CPMUARMCOP = 0xAAU)
#endif
#endif /* __RESET_WATCHDOG */


/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/
/* --------------------------------------------------------------------------- */
/* The following symbols were removed, because they were invalid or irrelevant */
/* --------------------------------------------------------------------------- */



/* **** 29.5.2012 15:41:29 */

#define PORTB_PB0                        PORTB_PE0
#define PORTB_PB1                        PORTB_PE1
#define PORTB_PB                         PORTB_PE
#define PORTB_PB0_MASK                   PORTB_PE0_MASK
#define PORTB_PB1_MASK                   PORTB_PE1_MASK
#define PORTB_PB_MASK                    PORTB_PE_MASK
#define PORTB_PB_BITNUM                  PORTB_PE_BITNUM
#define DDRB_DDRB0                       DDRB_DDRE0
#define DDRB_DDRB1                       DDRB_DDRE1
#define DDRB_DDRB                        DDRB_DDRE
#define DDRB_DDRB0_MASK                  DDRB_DDRE0_MASK
#define DDRB_DDRB1_MASK                  DDRB_DDRE1_MASK
#define DDRB_DDRB_MASK                   DDRB_DDRE_MASK
#define DDRB_DDRB_BITNUM                 DDRB_DDRE_BITNUM

#ifndef __V30COMPATIBLE__
#pragma OPTION DEL V30toV31Compatible
#endif
/*lint -restore  +esym(960,18.4) +esym(961,19.7) Enable MISRA rule (1.1,18.4,6.4,19.7) checking. */
#endif
