; Based on CPU DB MM912G634_A1_48, version 3.00.000 (RegistersPrg V2.33)

; ###################################################################
;     Filename  : mm912g634xx1xx.inc
;     Processor : MM912G634xx1xx
;     FileFormat: V2.33
;     DataSheet : MM912x634D1 Rev. 7.0, 03/2012
;     Compiler  : CodeWarrior compiler
;     Date/Time : 29.5.2012, 14:50
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;               - none
;
;     File-Format-Revisions:
;      - 15.09.2010, V2.33 :
;               - Empty union is not generated for data overlapping registers, cause there is no bit access
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
RAMStart:           equ   $00003800
RAMEnd:             equ   $00003FFF
DFLASHStart:        equ   $00000400
DFLASHEnd:          equ   $00000BFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
PAGE_0EStart:       equ   $00038000
PAGE_0EEnd:         equ   $0003BFFF
;
Vsi:                equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
Vlvi:               equ   $0000FF8A
VReserved57:        equ   $0000FF8C
VReserved56:        equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
VReserved52:        equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
VReserved47:        equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
VReserved43:        equ   $0000FFA8
VReserved42:        equ   $0000FFAA
VReserved41:        equ   $0000FFAC
VReserved40:        equ   $0000FFAE
VReserved39:        equ   $0000FFB0
VReserved38:        equ   $0000FFB2
VReserved37:        equ   $0000FFB4
VReserved36:        equ   $0000FFB6
Vflash:             equ   $0000FFB8
Vflashfd:           equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
VReserved31:        equ   $0000FFC0
VReserved30:        equ   $0000FFC2
VReserved29:        equ   $0000FFC4
Vcpmuplllck:        equ   $0000FFC6
Vcpmuocsns:         equ   $0000FFC8
VReserved26:        equ   $0000FFCA
VReserved25:        equ   $0000FFCC
VReserved24:        equ   $0000FFCE
VReserved23:        equ   $0000FFD0
VReserved22:        equ   $0000FFD2
VReserved21:        equ   $0000FFD4
VReserved20:        equ   $0000FFD6
Vspi:               equ   $0000FFD8
VReserved18:        equ   $0000FFDA
VReserved17:        equ   $0000FFDC
VReserved16:        equ   $0000FFDE
VReserved15:        equ   $0000FFE0
VReserved14:        equ   $0000FFE2
VReserved13:        equ   $0000FFE4
VReserved12:        equ   $0000FFE6
VReserved11:        equ   $0000FFE8
VReserved10:        equ   $0000FFEA
VReserved9:         equ   $0000FFEC
VReserved8:         equ   $0000FFEE
Vrti:               equ   $0000FFF0
Vd2di_ext:          equ   $0000FFF2
Vd2di_err:          equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTA - Port A Data Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_PA0:          equ    0                                         ; Port A Bit 0
PORTA_PA1:          equ    1                                         ; Port A Bit 1
PORTA_PA2:          equ    2                                         ; Port A Bit 2
PORTA_PA3:          equ    3                                         ; Port A Bit 3
PORTA_PA4:          equ    4                                         ; Port A Bit 4
PORTA_PA5:          equ    5                                         ; Port A Bit 5
PORTA_PA6:          equ    6                                         ; Port A Bit 6
PORTA_PA7:          equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_PA0:         equ    %00000001
mPORTA_PA1:         equ    %00000010
mPORTA_PA2:         equ    %00000100
mPORTA_PA3:         equ    %00001000
mPORTA_PA4:         equ    %00010000
mPORTA_PA5:         equ    %00100000
mPORTA_PA6:         equ    %01000000
mPORTA_PA7:         equ    %10000000


;*** PORTB - Port A Data Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port A Data Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_PE0:          equ    0                                         ; Port B Bit 0
PORTB_PE1:          equ    1                                         ; Port B Bit 1
; bit position masks
mPORTB_PE0:         equ    %00000001
mPORTB_PE1:         equ    %00000010


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Port A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Port A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Port A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Port A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Port A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Port A Bit 5
DDRA_DDRA6:         equ    6                                         ; Data Direction Port A Bit 6
DDRA_DDRA7:         equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000
mDDRA_DDRA6:        equ    %01000000
mDDRA_DDRA7:        equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_DDRE0:         equ    0                                         ; Data Direction Port B Bit 0
DDRB_DDRE1:         equ    1                                         ; Data Direction Port B Bit 1
; bit position masks
mDDRB_DDRE0:        equ    %00000001
mDDRB_DDRE1:        equ    %00000010


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODC:          equ    7                                         ; Mode Select Bit
; bit position masks
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PDPBE:         equ    1                                         ; Pull-down Port B Enable
PUCR_BKPUE:         equ    6                                         ; BKGD and VREGEN Pin Pull-up Enable
; bit position masks
mPUCR_PDPBE:        equ    %00000010
mPUCR_BKPUE:        equ    %01000000


;*** RDRIV - Reduced Drive Register; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPC:         equ    2                                         ; Reduced Drive of Port C
RDRIV_RDPD:         equ    3                                         ; Reduced Drive of Port D
; bit position masks
mRDRIV_RDPC:        equ    %00000100
mRDRIV_RDPD:        equ    %00001000


;*** DIRECT - Direct Page Register; 0x00000011 ***
DIRECT:             equ    $00000011                                ;*** DIRECT - Direct Page Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Index Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Index Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Index Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Index Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Index Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Index Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Index Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Index Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
MMCCTL1:            equ    $00000013                                ;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL1_IFRON:      equ    0                                         ; IFR visible in the memory map
; bit position masks
mMMCCTL1_IFRON:     equ    %00000001


;*** PPAGE - Program Page Index Register; 0x00000015 ***
PPAGE:              equ    $00000015                                ;*** PPAGE - Program Page Index Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** IVBR - Interrupt Vector Base Register; 0x0000001F ***
IVBR:               equ    $0000001F                                ;*** IVBR - Interrupt Vector Base Register; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR0:     equ    0                                         ; Interrupt Vector Base Address Bits, bit 0
IVBR_IVB_ADDR1:     equ    1                                         ; Interrupt Vector Base Address Bits, bit 1
IVBR_IVB_ADDR2:     equ    2                                         ; Interrupt Vector Base Address Bits, bit 2
IVBR_IVB_ADDR3:     equ    3                                         ; Interrupt Vector Base Address Bits, bit 3
IVBR_IVB_ADDR4:     equ    4                                         ; Interrupt Vector Base Address Bits, bit 4
IVBR_IVB_ADDR5:     equ    5                                         ; Interrupt Vector Base Address Bits, bit 5
IVBR_IVB_ADDR6:     equ    6                                         ; Interrupt Vector Base Address Bits, bit 6
IVBR_IVB_ADDR7:     equ    7                                         ; Interrupt Vector Base Address Bits, bit 7
; bit position masks
mIVBR_IVB_ADDR0:    equ    %00000001
mIVBR_IVB_ADDR1:    equ    %00000010
mIVBR_IVB_ADDR2:    equ    %00000100
mIVBR_IVB_ADDR3:    equ    %00001000
mIVBR_IVB_ADDR4:    equ    %00010000
mIVBR_IVB_ADDR5:    equ    %00100000
mIVBR_IVB_ADDR6:    equ    %01000000
mIVBR_IVB_ADDR7:    equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV0:       equ    0                                         ; Comparator Register Visibility Bits, bit 0
DBGC1_COMRV1:       equ    1                                         ; Comparator Register Visibility Bits, bit 1
DBGC1_DBGBRK:       equ    3                                         ; S12XDBG Breakpoint Enable Bit 1
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV0:      equ    %00000001
mDBGC1_COMRV1:      equ    %00000010
mDBGC1_DBGBRK:      equ    %00001000
mDBGC1_BDM:         equ    %00010000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bits
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bit
DBGTCR_TRCMOD0:     equ    2                                         ; Trace Mode Bits, bit 0
DBGTCR_TRCMOD1:     equ    3                                         ; Trace Mode Bits, bit 1
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bits
; bit position masks
mDBGTCR_TALIGN:     equ    %00000001
mDBGTCR_TRCMOD0:    equ    %00000100
mDBGTCR_TRCMOD1:    equ    %00001000
mDBGTCR_TSOURCE:    equ    %01000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM0:        equ    0                                         ; A and B Comparator Match Control, bit 0
DBGC2_ABCM1:        equ    1                                         ; A and B Comparator Match Control, bit 1
; bit position masks
mDBGC2_ABCM0:       equ    %00000001
mDBGC2_ABCM1:       equ    %00000010


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bits
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bits
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bits
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; Count Value, bit 0
DBGCNT_CNT1:        equ    1                                         ; Count Value, bit 1
DBGCNT_CNT2:        equ    2                                         ; Count Value, bit 2
DBGCNT_CNT3:        equ    3                                         ; Count Value, bit 3
DBGCNT_CNT4:        equ    4                                         ; Count Value, bit 4
DBGCNT_CNT5:        equ    5                                         ; Count Value, bit 5
DBGCNT_TBF:         equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000
mDBGCNT_CNT4:       equ    %00010000
mDBGCNT_CNT5:       equ    %00100000
mDBGCNT_TBF:        equ    %10000000


;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; State X Sequencer Next State Selection Bit 0
DBGSCRX_SC1:        equ    1                                         ; State X Sequencer Next State Selection Bit 1
DBGSCRX_SC2:        equ    2                                         ; State X Sequencer Next State Selection Bit 2
DBGSCRX_SC3:        equ    3                                         ; State X Sequencer Next State Selection Bit 3
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100
mDBGSCRX_SC3:       equ    %00001000


;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; Debug Match Flag Bit 0
DBGMFR_MC1:         equ    1                                         ; Debug Match Flag Bit 1
DBGMFR_MC2:         equ    2                                         ; Debug Match Flag Bit 2
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_NDB:        equ    1                                         ; Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D)
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_BRK:        equ    4                                         ; Break
DBGXCTL_TAG:        equ    5                                         ; Tag Select
DBGXCTL_SZ:         equ    6                                         ; Size Comparator Value Bit
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_NDB:       equ    %00000010
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_BRK:       equ    %00010000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_SZ:        equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bits
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bits
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bits
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
DBGADH:             equ    $0000002C                                ;*** DBGADH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADH_BIT8:        equ    0                                         ; Comparator Data High Compare Bit 8
DBGADH_BIT9:        equ    1                                         ; Comparator Data High Compare Bit 9
DBGADH_BIT10:       equ    2                                         ; Comparator Data High Compare Bit 10
DBGADH_BIT11:       equ    3                                         ; Comparator Data High Compare Bit 11
DBGADH_BIT12:       equ    4                                         ; Comparator Data High Compare Bit 12
DBGADH_BIT13:       equ    5                                         ; Comparator Data High Compare Bit 13
DBGADH_BIT14:       equ    6                                         ; Comparator Data High Compare Bit 14
DBGADH_BIT15:       equ    7                                         ; Comparator Data High Compare Bit 15
; bit position masks
mDBGADH_BIT8:       equ    %00000001
mDBGADH_BIT9:       equ    %00000010
mDBGADH_BIT10:      equ    %00000100
mDBGADH_BIT11:      equ    %00001000
mDBGADH_BIT12:      equ    %00010000
mDBGADH_BIT13:      equ    %00100000
mDBGADH_BIT14:      equ    %01000000
mDBGADH_BIT15:      equ    %10000000


;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
DBGADL:             equ    $0000002D                                ;*** DBGADL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADL_BIT0:        equ    0                                         ; Comparator Data Low Compare Bit 0
DBGADL_BIT1:        equ    1                                         ; Comparator Data Low Compare Bit 1
DBGADL_BIT2:        equ    2                                         ; Comparator Data Low Compare Bit 2
DBGADL_BIT3:        equ    3                                         ; Comparator Data Low Compare Bit 3
DBGADL_BIT4:        equ    4                                         ; Comparator Data Low Compare Bit 4
DBGADL_BIT5:        equ    5                                         ; Comparator Data Low Compare Bit 5
DBGADL_BIT6:        equ    6                                         ; Comparator Data Low Compare Bit 6
DBGADL_BIT7:        equ    7                                         ; Comparator Data Low Compare Bit 7
; bit position masks
mDBGADL_BIT0:       equ    %00000001
mDBGADL_BIT1:       equ    %00000010
mDBGADL_BIT2:       equ    %00000100
mDBGADL_BIT3:       equ    %00001000
mDBGADL_BIT4:       equ    %00010000
mDBGADL_BIT5:       equ    %00100000
mDBGADL_BIT6:       equ    %01000000
mDBGADL_BIT7:       equ    %10000000


;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGADHM:            equ    $0000002E                                ;*** DBGADHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGADHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGADHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGADHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGADHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGADHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGADHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGADHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGADHM_BIT8:      equ    %00000001
mDBGADHM_BIT9:      equ    %00000010
mDBGADHM_BIT10:     equ    %00000100
mDBGADHM_BIT11:     equ    %00001000
mDBGADHM_BIT12:     equ    %00010000
mDBGADHM_BIT13:     equ    %00100000
mDBGADHM_BIT14:     equ    %01000000
mDBGADHM_BIT15:     equ    %10000000


;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGADLM:            equ    $0000002F                                ;*** DBGADLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGADLM_BIT0:       equ    0                                         ; Comparator Data Low Mask Bit 0
DBGADLM_BIT1:       equ    1                                         ; Comparator Data Low Mask Bit 1
DBGADLM_BIT2:       equ    2                                         ; Comparator Data Low Mask Bit 2
DBGADLM_BIT3:       equ    3                                         ; Comparator Data Low Mask Bit 3
DBGADLM_BIT4:       equ    4                                         ; Comparator Data Low Mask Bit 4
DBGADLM_BIT5:       equ    5                                         ; Comparator Data Low Mask Bit 5
DBGADLM_BIT6:       equ    6                                         ; Comparator Data Low Mask Bit 6
DBGADLM_BIT7:       equ    7                                         ; Comparator Data Low Mask Bit 7
; bit position masks
mDBGADLM_BIT0:      equ    %00000001
mDBGADLM_BIT1:      equ    %00000010
mDBGADLM_BIT2:      equ    %00000100
mDBGADLM_BIT3:      equ    %00001000
mDBGADLM_BIT4:      equ    %00010000
mDBGADLM_BIT5:      equ    %00100000
mDBGADLM_BIT6:      equ    %01000000
mDBGADLM_BIT7:      equ    %10000000


;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
CPMUSYNR:           equ    $00000034                                ;*** CPMUSYNR - S12CPMU Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUSYNR_SYNDIV0:   equ    0                                         ; Multiplication factor of the IPLL bit 0
CPMUSYNR_SYNDIV1:   equ    1                                         ; Multiplication factor of the IPLL bit 1
CPMUSYNR_SYNDIV2:   equ    2                                         ; Multiplication factor of the IPLL bit 2
CPMUSYNR_SYNDIV3:   equ    3                                         ; Multiplication factor of the IPLL bit 3
CPMUSYNR_SYNDIV4:   equ    4                                         ; Multiplication factor of the IPLL bit 4
CPMUSYNR_SYNDIV5:   equ    5                                         ; Multiplication factor of the IPLL bit 5
CPMUSYNR_VCOFRQ0:   equ    6                                         ; VCO frequency range bit 0
CPMUSYNR_VCOFRQ1:   equ    7                                         ; VCO frequency range bit 1
; bit position masks
mCPMUSYNR_SYNDIV0:  equ    %00000001
mCPMUSYNR_SYNDIV1:  equ    %00000010
mCPMUSYNR_SYNDIV2:  equ    %00000100
mCPMUSYNR_SYNDIV3:  equ    %00001000
mCPMUSYNR_SYNDIV4:  equ    %00010000
mCPMUSYNR_SYNDIV5:  equ    %00100000
mCPMUSYNR_VCOFRQ0:  equ    %01000000
mCPMUSYNR_VCOFRQ1:  equ    %10000000


;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
CPMUREFDIV:         equ    $00000035                                ;*** CPMUREFDIV - S12CPMU Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUREFDIV_REFDIV0: equ    0                                         ; Finer granularity for the IPLL multiplier steps bit 0
CPMUREFDIV_REFDIV1: equ    1                                         ; Finer granularity for the IPLL multiplier steps bit 1
CPMUREFDIV_REFDIV2: equ    2                                         ; Finer granularity for the IPLL multiplier steps bit 2
CPMUREFDIV_REFDIV3: equ    3                                         ; Finer granularity for the IPLL multiplier steps bit 3
CPMUREFDIV_REFFRQ0: equ    6                                         ; IPLL optimal stability and lock time configuration bit 0
CPMUREFDIV_REFFRQ1: equ    7                                         ; IPLL optimal stability and lock time configuration bit 1
; bit position masks
mCPMUREFDIV_REFDIV0: equ    %00000001
mCPMUREFDIV_REFDIV1: equ    %00000010
mCPMUREFDIV_REFDIV2: equ    %00000100
mCPMUREFDIV_REFDIV3: equ    %00001000
mCPMUREFDIV_REFFRQ0: equ    %01000000
mCPMUREFDIV_REFFRQ1: equ    %10000000


;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
CPMUPOSTDIV:        equ    $00000036                                ;*** CPMUPOSTDIV - S12CPMU Post Divider Register; 0x00000036 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPOSTDIV_POSTDIV0: equ    0                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 0
CPMUPOSTDIV_POSTDIV1: equ    1                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 1
CPMUPOSTDIV_POSTDIV2: equ    2                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 2
CPMUPOSTDIV_POSTDIV3: equ    3                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 3
CPMUPOSTDIV_POSTDIV4: equ    4                                       ; Frequency ratio between the VCOCLK and PLLCLK control bit 4
; bit position masks
mCPMUPOSTDIV_POSTDIV0: equ    %00000001
mCPMUPOSTDIV_POSTDIV1: equ    %00000010
mCPMUPOSTDIV_POSTDIV2: equ    %00000100
mCPMUPOSTDIV_POSTDIV3: equ    %00001000
mCPMUPOSTDIV_POSTDIV4: equ    %00010000


;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
CPMUFLG:            equ    $00000037                                ;*** CPMUFLG - S12CPMU Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUFLG_UPOSC:      equ    0                                         ; Oscillator Status Bit
CPMUFLG_OSCIF:      equ    1                                         ; Oscillator Interrupt Flag
CPMUFLG_ILAF:       equ    2                                         ; Illegal Address Reset Flag
CPMUFLG_LOCK:       equ    3                                         ; Lock Status Bit
CPMUFLG_LOCKIF:     equ    4                                         ; IPLL Lock Interrupt Flag
CPMUFLG_LVRF:       equ    5                                         ; Low Voltage Reset Flag
CPMUFLG_PORF:       equ    6                                         ; Power on Reset Flag
CPMUFLG_RTIF:       equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCPMUFLG_UPOSC:     equ    %00000001
mCPMUFLG_OSCIF:     equ    %00000010
mCPMUFLG_ILAF:      equ    %00000100
mCPMUFLG_LOCK:      equ    %00001000
mCPMUFLG_LOCKIF:    equ    %00010000
mCPMUFLG_LVRF:      equ    %00100000
mCPMUFLG_PORF:      equ    %01000000
mCPMUFLG_RTIF:      equ    %10000000


;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
CPMUINT:            equ    $00000038                                ;*** CPMUINT - S12CPMU Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUINT_OSCIE:      equ    1                                         ; Oscillator Corrupt Interrupt Enable Bit
CPMUINT_LOCKIE:     equ    4                                         ; Lock Interrupt Enable Bit
CPMUINT_RTIE:       equ    7                                         ; Real Time Interrupt Enable Bit
; bit position masks
mCPMUINT_OSCIE:     equ    %00000010
mCPMUINT_LOCKIE:    equ    %00010000
mCPMUINT_RTIE:      equ    %10000000


;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
CPMUCLKS:           equ    $00000039                                ;*** CPMUCLKS - S12CPMU Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCLKS_COPOSCSEL: equ    0                                         ; COP Clock Select
CPMUCLKS_RTIOSCSEL: equ    1                                         ; RTI Clock Select
CPMUCLKS_PCE:       equ    2                                         ; COP Enable During Pseudo Stop Bit
CPMUCLKS_PRE:       equ    3                                         ; RTI Enable During Pseudo Stop Bit
CPMUCLKS_PSTP:      equ    6                                         ; Pseudo Stop Bit
CPMUCLKS_PLLSEL:    equ    7                                         ; PLL Select Bit
; bit position masks
mCPMUCLKS_COPOSCSEL: equ    %00000001
mCPMUCLKS_RTIOSCSEL: equ    %00000010
mCPMUCLKS_PCE:      equ    %00000100
mCPMUCLKS_PRE:      equ    %00001000
mCPMUCLKS_PSTP:     equ    %01000000
mCPMUCLKS_PLLSEL:   equ    %10000000


;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
CPMUPLL:            equ    $0000003A                                ;*** CPMUPLL - S12CPMU PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPLL_FM0:        equ    4                                         ; PLL Frequency Modulation Enable Bit 0
CPMUPLL_FM1:        equ    5                                         ; PLL Frequency Modulation Enable Bit 1
; bit position masks
mCPMUPLL_FM0:       equ    %00010000
mCPMUPLL_FM1:       equ    %00100000


;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
CPMURTI:            equ    $0000003B                                ;*** CPMURTI - CPMU RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMURTI_RTR0:       equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
CPMURTI_RTR1:       equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
CPMURTI_RTR2:       equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
CPMURTI_RTR3:       equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
CPMURTI_RTR4:       equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
CPMURTI_RTR5:       equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
CPMURTI_RTR6:       equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
CPMURTI_RTDEC:      equ    7                                         ; Decimal or Binary Divider Select Bit
; bit position masks
mCPMURTI_RTR0:      equ    %00000001
mCPMURTI_RTR1:      equ    %00000010
mCPMURTI_RTR2:      equ    %00000100
mCPMURTI_RTR3:      equ    %00001000
mCPMURTI_RTR4:      equ    %00010000
mCPMURTI_RTR5:      equ    %00100000
mCPMURTI_RTR6:      equ    %01000000
mCPMURTI_RTDEC:     equ    %10000000


;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
CPMUCOP:            equ    $0000003C                                ;*** CPMUCOP - CPMU COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUCOP_CR0:        equ    0                                         ; COP Watchdog Timer Rate select Bit 0
CPMUCOP_CR1:        equ    1                                         ; COP Watchdog Timer Rate select Bit 1
CPMUCOP_CR2:        equ    2                                         ; COP Watchdog Timer Rate select Bit 2
CPMUCOP_WRTMASK:    equ    5                                         ; Write Mask for WCOP
CPMUCOP_RSBCK:      equ    6                                         ; COP and RTI stop in Active BDM mode Bit
CPMUCOP_WCOP:       equ    7                                         ; Window COP mode
; bit position masks
mCPMUCOP_CR0:       equ    %00000001
mCPMUCOP_CR1:       equ    %00000010
mCPMUCOP_CR2:       equ    %00000100
mCPMUCOP_WRTMASK:   equ    %00100000
mCPMUCOP_RSBCK:     equ    %01000000
mCPMUCOP_WCOP:      equ    %10000000


;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
CPMUARMCOP:         equ    $0000003F                                ;*** CPMUARMCOP - CPMU COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUARMCOP_BIT0:    equ    0                                         ; CPMU COP Timer Arm/Reset Bit 0
CPMUARMCOP_BIT1:    equ    1                                         ; CPMU COP Timer Arm/Reset Bit 1
CPMUARMCOP_BIT2:    equ    2                                         ; CPMU COP Timer Arm/Reset Bit 2
CPMUARMCOP_BIT3:    equ    3                                         ; CPMU COP Timer Arm/Reset Bit 3
CPMUARMCOP_BIT4:    equ    4                                         ; CPMU COP Timer Arm/Reset Bit 4
CPMUARMCOP_BIT5:    equ    5                                         ; CPMU COP Timer Arm/Reset Bit 5
CPMUARMCOP_BIT6:    equ    6                                         ; CPMU COP Timer Arm/Reset Bit 6
CPMUARMCOP_BIT7:    equ    7                                         ; CPMU COP Timer Arm/Reset Bit 7
; bit position masks
mCPMUARMCOP_BIT0:   equ    %00000001
mCPMUARMCOP_BIT1:   equ    %00000010
mCPMUARMCOP_BIT2:   equ    %00000100
mCPMUARMCOP_BIT3:   equ    %00001000
mCPMUARMCOP_BIT4:   equ    %00010000
mCPMUARMCOP_BIT5:   equ    %00100000
mCPMUARMCOP_BIT6:   equ    %01000000
mCPMUARMCOP_BIT7:   equ    %10000000


;*** D2DCTL0 - D2D Control Register 0; 0x000000D8 ***
D2DCTL0:            equ    $000000D8                                ;*** D2DCTL0 - D2D Control Register 0; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DCTL0_D2DCLKDIV0: equ    0                                         ; InterfaceClockDivider, bit 0
D2DCTL0_D2DCLKDIV1: equ    1                                         ; InterfaceClockDivider, bit 1
D2DCTL0_D2DSWAI:    equ    5                                         ; D2D Stop In Wait
D2DCTL0_D2DCW:      equ    6                                         ; D2D Connection Width
D2DCTL0_D2DEN:      equ    7                                         ; D2D Enable
; bit position masks
mD2DCTL0_D2DCLKDIV0: equ    %00000001
mD2DCTL0_D2DCLKDIV1: equ    %00000010
mD2DCTL0_D2DSWAI:   equ    %00100000
mD2DCTL0_D2DCW:     equ    %01000000
mD2DCTL0_D2DEN:     equ    %10000000


;*** D2DCTL1 - D2D Control Register 1; 0x000000D9 ***
D2DCTL1:            equ    $000000D9                                ;*** D2DCTL1 - D2D Control Register 1; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DCTL1_TIMOUT0:    equ    0                                         ; Time-out Setting, bit 0
D2DCTL1_TIMOUT1:    equ    1                                         ; Time-out Setting, bit 1
D2DCTL1_TIMOUT2:    equ    2                                         ; Time-out Setting, bit 2
D2DCTL1_TIMOUT3:    equ    3                                         ; Time-out Setting, bit 3
D2DCTL1_D2DIE:      equ    7                                         ; D2D Interrupt Enable
; bit position masks
mD2DCTL1_TIMOUT0:   equ    %00000001
mD2DCTL1_TIMOUT1:   equ    %00000010
mD2DCTL1_TIMOUT2:   equ    %00000100
mD2DCTL1_TIMOUT3:   equ    %00001000
mD2DCTL1_D2DIE:     equ    %10000000


;*** D2DSTAT0 - D2D Status Register 0; 0x000000DA ***
D2DSTAT0:           equ    $000000DA                                ;*** D2DSTAT0 - D2D Status Register 0; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DSTAT0_PAR0:      equ    0                                         ; Parity Bit
D2DSTAT0_PAR1:      equ    1                                         ; Parity Bit
D2DSTAT0_PARF:      equ    2                                         ; Parity Error Flag
D2DSTAT0_TERRF:     equ    3                                         ; Transaction Error Flag
D2DSTAT0_TIMEF:     equ    4                                         ; TimeOutErrorFlag
D2DSTAT0_CNCLF:     equ    5                                         ; CNCLF
D2DSTAT0_ACKERF:    equ    6                                         ; Acknowledge Error Flag
D2DSTAT0_ERRIF:     equ    7                                         ; D2D error interrupt flag
; bit position masks
mD2DSTAT0_PAR0:     equ    %00000001
mD2DSTAT0_PAR1:     equ    %00000010
mD2DSTAT0_PARF:     equ    %00000100
mD2DSTAT0_TERRF:    equ    %00001000
mD2DSTAT0_TIMEF:    equ    %00010000
mD2DSTAT0_CNCLF:    equ    %00100000
mD2DSTAT0_ACKERF:   equ    %01000000
mD2DSTAT0_ERRIF:    equ    %10000000


;*** D2DSTAT1 - D2D Status Register 1; 0x000000DB ***
D2DSTAT1:           equ    $000000DB                                ;*** D2DSTAT1 - D2D Status Register 1; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DSTAT1_D2DBSY:    equ    6                                         ; D2D Initiator Busy
D2DSTAT1_D2DIF:     equ    7                                         ; D2D InterruptFlag
; bit position masks
mD2DSTAT1_D2DBSY:   equ    %01000000
mD2DSTAT1_D2DIF:    equ    %10000000


;*** D2DADR - D2D Address Buffer Register; 0x000000DC ***
D2DADR:             equ    $000000DC                                ;*** D2DADR - D2D Address Buffer Register; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADR_ADR0:        equ    0                                         ; Transaction Address, bit 0
D2DADR_ADR1:        equ    1                                         ; Transaction Address, bit 1
D2DADR_ADR2:        equ    2                                         ; Transaction Address, bit 2
D2DADR_ADR3:        equ    3                                         ; Transaction Address, bit 3
D2DADR_ADR4:        equ    4                                         ; Transaction Address, bit 4
D2DADR_ADR5:        equ    5                                         ; Transaction Address, bit 5
D2DADR_ADR6:        equ    6                                         ; Transaction Address, bit 6
D2DADR_ADR7:        equ    7                                         ; Transaction Address, bit 7
D2DADR_NBLK:        equ    12                                        ; Transaction Mode
D2DADR_SZ8:         equ    14                                        ; Transaction Size
D2DADR_RWB:         equ    15                                        ; Transaction Read-Write Direction
; bit position masks
mD2DADR_ADR0:       equ    %00000001
mD2DADR_ADR1:       equ    %00000010
mD2DADR_ADR2:       equ    %00000100
mD2DADR_ADR3:       equ    %00001000
mD2DADR_ADR4:       equ    %00010000
mD2DADR_ADR5:       equ    %00100000
mD2DADR_ADR6:       equ    %01000000
mD2DADR_ADR7:       equ    %10000000
mD2DADR_NBLK:       equ    %1000000000000
mD2DADR_SZ8:        equ    %100000000000000
mD2DADR_RWB:        equ    %1000000000000000


;*** D2DADRHI - D2D Address Buffer Register High; 0x000000DC ***
D2DADRHI:           equ    $000000DC                                ;*** D2DADRHI - D2D Address Buffer Register High; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADRHI_NBLK:      equ    4                                         ; Transaction Mode
D2DADRHI_SZ8:       equ    6                                         ; Transaction Size
D2DADRHI_RWB:       equ    7                                         ; Transaction Read-Write Direction
; bit position masks
mD2DADRHI_NBLK:     equ    %00010000
mD2DADRHI_SZ8:      equ    %01000000
mD2DADRHI_RWB:      equ    %10000000


;*** D2DADRLO - D2D Address Buffer Register Low; 0x000000DD ***
D2DADRLO:           equ    $000000DD                                ;*** D2DADRLO - D2D Address Buffer Register Low; 0x000000DD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DADRLO_ADR0:      equ    0                                         ; Transaction Address, bit 0
D2DADRLO_ADR1:      equ    1                                         ; Transaction Address, bit 1
D2DADRLO_ADR2:      equ    2                                         ; Transaction Address, bit 2
D2DADRLO_ADR3:      equ    3                                         ; Transaction Address, bit 3
D2DADRLO_ADR4:      equ    4                                         ; Transaction Address, bit 4
D2DADRLO_ADR5:      equ    5                                         ; Transaction Address, bit 5
D2DADRLO_ADR6:      equ    6                                         ; Transaction Address, bit 6
D2DADRLO_ADR7:      equ    7                                         ; Transaction Address, bit 7
; bit position masks
mD2DADRLO_ADR0:     equ    %00000001
mD2DADRLO_ADR1:     equ    %00000010
mD2DADRLO_ADR2:     equ    %00000100
mD2DADRLO_ADR3:     equ    %00001000
mD2DADRLO_ADR4:     equ    %00010000
mD2DADRLO_ADR5:     equ    %00100000
mD2DADRLO_ADR6:     equ    %01000000
mD2DADRLO_ADR7:     equ    %10000000


;*** D2DDATA - D2D Data Buffer Register; 0x000000DE ***
D2DDATA:            equ    $000000DE                                ;*** D2DDATA - D2D Data Buffer Register; 0x000000DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATA_DATA0:      equ    0                                         ; Transaction Data, bit 0
D2DDATA_DATA1:      equ    1                                         ; Transaction Data, bit 1
D2DDATA_DATA2:      equ    2                                         ; Transaction Data, bit 2
D2DDATA_DATA3:      equ    3                                         ; Transaction Data, bit 3
D2DDATA_DATA4:      equ    4                                         ; Transaction Data, bit 4
D2DDATA_DATA5:      equ    5                                         ; Transaction Data, bit 5
D2DDATA_DATA6:      equ    6                                         ; Transaction Data, bit 6
D2DDATA_DATA7:      equ    7                                         ; Transaction Data, bit 7
D2DDATA_DATA8:      equ    8                                         ; Transaction Data, bit 8
D2DDATA_DATA9:      equ    9                                         ; Transaction Data, bit 9
D2DDATA_DATA10:     equ    10                                        ; Transaction Data, bit 10
D2DDATA_DATA11:     equ    11                                        ; Transaction Data, bit 11
D2DDATA_DATA12:     equ    12                                        ; Transaction Data, bit 12
D2DDATA_DATA13:     equ    13                                        ; Transaction Data, bit 13
D2DDATA_DATA14:     equ    14                                        ; Transaction Data, bit 14
D2DDATA_DATA15:     equ    15                                        ; Transaction Data, bit 15
; bit position masks
mD2DDATA_DATA0:     equ    %00000001
mD2DDATA_DATA1:     equ    %00000010
mD2DDATA_DATA2:     equ    %00000100
mD2DDATA_DATA3:     equ    %00001000
mD2DDATA_DATA4:     equ    %00010000
mD2DDATA_DATA5:     equ    %00100000
mD2DDATA_DATA6:     equ    %01000000
mD2DDATA_DATA7:     equ    %10000000
mD2DDATA_DATA8:     equ    %100000000
mD2DDATA_DATA9:     equ    %1000000000
mD2DDATA_DATA10:    equ    %10000000000
mD2DDATA_DATA11:    equ    %100000000000
mD2DDATA_DATA12:    equ    %1000000000000
mD2DDATA_DATA13:    equ    %10000000000000
mD2DDATA_DATA14:    equ    %100000000000000
mD2DDATA_DATA15:    equ    %1000000000000000


;*** D2DDATAHI - D2D Data Buffer Register High; 0x000000DE ***
D2DDATAHI:          equ    $000000DE                                ;*** D2DDATAHI - D2D Data Buffer Register High; 0x000000DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATAHI_DATA8:    equ    0                                         ; Transaction Data, bit 8
D2DDATAHI_DATA9:    equ    1                                         ; Transaction Data, bit 9
D2DDATAHI_DATA10:   equ    2                                         ; Transaction Data, bit 10
D2DDATAHI_DATA11:   equ    3                                         ; Transaction Data, bit 11
D2DDATAHI_DATA12:   equ    4                                         ; Transaction Data, bit 12
D2DDATAHI_DATA13:   equ    5                                         ; Transaction Data, bit 13
D2DDATAHI_DATA14:   equ    6                                         ; Transaction Data, bit 14
D2DDATAHI_DATA15:   equ    7                                         ; Transaction Data, bit 15
; bit position masks
mD2DDATAHI_DATA8:   equ    %00000001
mD2DDATAHI_DATA9:   equ    %00000010
mD2DDATAHI_DATA10:  equ    %00000100
mD2DDATAHI_DATA11:  equ    %00001000
mD2DDATAHI_DATA12:  equ    %00010000
mD2DDATAHI_DATA13:  equ    %00100000
mD2DDATAHI_DATA14:  equ    %01000000
mD2DDATAHI_DATA15:  equ    %10000000


;*** D2DDATALO - D2D Data Buffer Register Low; 0x000000DF ***
D2DDATALO:          equ    $000000DF                                ;*** D2DDATALO - D2D Data Buffer Register Low; 0x000000DF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
D2DDATALO_DATA0:    equ    0                                         ; Transaction Data, bit 0
D2DDATALO_DATA1:    equ    1                                         ; Transaction Data, bit 1
D2DDATALO_DATA2:    equ    2                                         ; Transaction Data, bit 2
D2DDATALO_DATA3:    equ    3                                         ; Transaction Data, bit 3
D2DDATALO_DATA4:    equ    4                                         ; Transaction Data, bit 4
D2DDATALO_DATA5:    equ    5                                         ; Transaction Data, bit 5
D2DDATALO_DATA6:    equ    6                                         ; Transaction Data, bit 6
D2DDATALO_DATA7:    equ    7                                         ; Transaction Data, bit 7
; bit position masks
mD2DDATALO_DATA0:   equ    %00000001
mD2DDATALO_DATA1:   equ    %00000010
mD2DDATALO_DATA2:   equ    %00000100
mD2DDATALO_DATA3:   equ    %00001000
mD2DDATALO_DATA4:   equ    %00010000
mD2DDATALO_DATA5:   equ    %00100000
mD2DDATALO_DATA6:   equ    %01000000
mD2DDATALO_DATA7:   equ    %10000000


;*** SPICR1 - SPI  Control Register 1; 0x000000E8 ***
SPICR1:             equ    $000000E8                                ;*** SPICR1 - SPI  Control Register 1; 0x000000E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI  Control Register 2; 0x000000E9 ***
SPICR2:             equ    $000000E9                                ;*** SPICR2 - SPI  Control Register 2; 0x000000E9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
SPICR2_XFRW:        equ    6                                         ; Transfer Width
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000
mSPICR2_XFRW:       equ    %01000000


;*** SPIBR - SPI  Baud Rate Register; 0x000000EA ***
SPIBR:              equ    $000000EA                                ;*** SPIBR - SPI  Baud Rate Register; 0x000000EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI  Status Register; 0x000000EB ***
SPISR:              equ    $000000EB                                ;*** SPISR - SPI  Status Register; 0x000000EB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI  Data Register; 0x000000EC ***
SPIDR:              equ    $000000EC                                ;*** SPIDR - SPI  Data Register; 0x000000EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDR_R0_T0:        equ    0                                         ; SPI  Data Bit 0
SPIDR_R1_T1:        equ    1                                         ; SPI  Data Bit 1
SPIDR_R2_T2:        equ    2                                         ; SPI  Data Bit 2
SPIDR_R3_T3:        equ    3                                         ; SPI  Data Bit 3
SPIDR_R4_T4:        equ    4                                         ; SPI  Data Bit 4
SPIDR_R5_T5:        equ    5                                         ; SPI  Data Bit 5
SPIDR_R6_T6:        equ    6                                         ; SPI  Data Bit 6
SPIDR_R7_T7:        equ    7                                         ; SPI  Data Bit 7
SPIDR_R8_T8:        equ    8                                         ; SPI  Data Bit 8
SPIDR_R9_T9:        equ    9                                         ; SPI  Data Bit 9
SPIDR_R10_T10:      equ    10                                        ; SPI  Data Bit 10
SPIDR_R11_T11:      equ    11                                        ; SPI  Data Bit 11
SPIDR_R12_T12:      equ    12                                        ; SPI  Data Bit 12
SPIDR_R13_T13:      equ    13                                        ; SPI  Data Bit 13
SPIDR_R14_T14:      equ    14                                        ; SPI  Data Bit 14
SPIDR_R15_T15:      equ    15                                        ; SPI  Data Bit 15
; bit position masks
mSPIDR_R0_T0:       equ    %00000001
mSPIDR_R1_T1:       equ    %00000010
mSPIDR_R2_T2:       equ    %00000100
mSPIDR_R3_T3:       equ    %00001000
mSPIDR_R4_T4:       equ    %00010000
mSPIDR_R5_T5:       equ    %00100000
mSPIDR_R6_T6:       equ    %01000000
mSPIDR_R7_T7:       equ    %10000000
mSPIDR_R8_T8:       equ    %100000000
mSPIDR_R9_T9:       equ    %1000000000
mSPIDR_R10_T10:     equ    %10000000000
mSPIDR_R11_T11:     equ    %100000000000
mSPIDR_R12_T12:     equ    %1000000000000
mSPIDR_R13_T13:     equ    %10000000000000
mSPIDR_R14_T14:     equ    %100000000000000
mSPIDR_R15_T15:     equ    %1000000000000000


;*** SPIDRH - SPI  Data Register High; 0x000000EC ***
SPIDRH:             equ    $000000EC                                ;*** SPIDRH - SPI  Data Register High; 0x000000EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDRH_R8_T8:       equ    0                                         ; SPI  Data Bit 8
SPIDRH_R9_T9:       equ    1                                         ; SPI  Data Bit 9
SPIDRH_R10_T10:     equ    2                                         ; SPI  Data Bit 10
SPIDRH_R11_T11:     equ    3                                         ; SPI  Data Bit 11
SPIDRH_R12_T12:     equ    4                                         ; SPI  Data Bit 12
SPIDRH_R13_T13:     equ    5                                         ; SPI  Data Bit 13
SPIDRH_R14_T14:     equ    6                                         ; SPI  Data Bit 14
SPIDRH_R15_T15:     equ    7                                         ; SPI  Data Bit 15
; bit position masks
mSPIDRH_R8_T8:      equ    %00000001
mSPIDRH_R9_T9:      equ    %00000010
mSPIDRH_R10_T10:    equ    %00000100
mSPIDRH_R11_T11:    equ    %00001000
mSPIDRH_R12_T12:    equ    %00010000
mSPIDRH_R13_T13:    equ    %00100000
mSPIDRH_R14_T14:    equ    %01000000
mSPIDRH_R15_T15:    equ    %10000000


;*** SPIDRL - SPI  Data Register Low; 0x000000ED ***
SPIDRL:             equ    $000000ED                                ;*** SPIDRL - SPI  Data Register Low; 0x000000ED ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIDRL_R0_T0:       equ    0                                         ; SPI  Data Bit 0
SPIDRL_R1_T1:       equ    1                                         ; SPI  Data Bit 1
SPIDRL_R2_T2:       equ    2                                         ; SPI  Data Bit 2
SPIDRL_R3_T3:       equ    3                                         ; SPI  Data Bit 3
SPIDRL_R4_T4:       equ    4                                         ; SPI  Data Bit 4
SPIDRL_R5_T5:       equ    5                                         ; SPI  Data Bit 5
SPIDRL_R6_T6:       equ    6                                         ; SPI  Data Bit 6
SPIDRL_R7_T7:       equ    7                                         ; SPI  Data Bit 7
; bit position masks
mSPIDRL_R0_T0:      equ    %00000001
mSPIDRL_R1_T1:      equ    %00000010
mSPIDRL_R2_T2:      equ    %00000100
mSPIDRL_R3_T3:      equ    %00001000
mSPIDRL_R4_T4:      equ    %00010000
mSPIDRL_R5_T5:      equ    %00100000
mSPIDRL_R6_T6:      equ    %01000000
mSPIDRL_R7_T7:      equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Clock Divider Bit 5
FCLKDIV_FDIVLCK:    equ    6                                         ; Clock divider locked
FCLKDIV_FDIVLD:     equ    7                                         ; Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_FDIVLCK:   equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Flash Security Bit 0
FSEC_SEC1:          equ    1                                         ; Flash Security Bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Nonvolatile Bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Nonvolatile Bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Nonvolatile Bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Nonvolatile Bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
FCCOBIX:            equ    $00000102                                ;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBIX_CCOBIX0:    equ    0                                         ; Common Command Register Index Bit 0
FCCOBIX_CCOBIX1:    equ    1                                         ; Common Command Register Index Bit 1
FCCOBIX_CCOBIX2:    equ    2                                         ; Common Command Register Index Bit 2
; bit position masks
mFCCOBIX_CCOBIX0:   equ    %00000001
mFCCOBIX_CCOBIX1:   equ    %00000010
mFCCOBIX_CCOBIX2:   equ    %00000100


;*** FCNFG - Flash Configuration Register; 0x00000104 ***
FCNFG:              equ    $00000104                                ;*** FCNFG - Flash Configuration Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_FSFD:         equ    0                                         ; Force Single Bit Fault Detect
FCNFG_FDFD:         equ    1                                         ; Force Double Bit Fault Detect
FCNFG_IGNSF:        equ    4                                         ; Ignore Single Bit Fault
FCNFG_CCIE:         equ    7                                         ; Command Complete Interrupt Enable
; bit position masks
mFCNFG_FSFD:        equ    %00000001
mFCNFG_FDFD:        equ    %00000010
mFCNFG_IGNSF:       equ    %00010000
mFCNFG_CCIE:        equ    %10000000


;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
FERCNFG:            equ    $00000105                                ;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERCNFG_SFDIE:      equ    0                                         ; Single Bit Fault Detect Interrupt Enable
FERCNFG_DFDIE:      equ    1                                         ; Double Bit Fault Detect Interrupt Enable
; bit position masks
mFERCNFG_SFDIE:     equ    %00000001
mFERCNFG_DFDIE:     equ    %00000010


;*** FSTAT - Flash Status Register; 0x00000106 ***
FSTAT:              equ    $00000106                                ;*** FSTAT - Flash Status Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_MGSTAT0:      equ    0                                         ; Memory Controller Command Completion Status Flag 0
FSTAT_MGSTAT1:      equ    1                                         ; Memory Controller Command Completion Status Flag 1
FSTAT_MGBUSY:       equ    3                                         ; Memory Controller Busy Flag
FSTAT_FPVIOL:       equ    4                                         ; Flash Protection Violation Flag
FSTAT_ACCERR:       equ    5                                         ; Flash Access Error Flag
FSTAT_CCIF:         equ    7                                         ; Command Complete Interrupt Flag
; bit position masks
mFSTAT_MGSTAT0:     equ    %00000001
mFSTAT_MGSTAT1:     equ    %00000010
mFSTAT_MGBUSY:      equ    %00001000
mFSTAT_FPVIOL:      equ    %00010000
mFSTAT_ACCERR:      equ    %00100000
mFSTAT_CCIF:        equ    %10000000


;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
FERSTAT:            equ    $00000107                                ;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERSTAT_SFDIF:      equ    0                                         ; Single Bit Fault Detect Interrupt Flag
FERSTAT_DFDIF:      equ    1                                         ; Double Bit Fault Detect Interrupt Flag
; bit position masks
mFERSTAT_SFDIF:     equ    %00000001
mFERSTAT_DFDIF:     equ    %00000010


;*** FPROT - P-Flash Protection Register; 0x00000108 ***
FPROT:              equ    $00000108                                ;*** FPROT - P-Flash Protection Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address Size Bit 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address Size Bit 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower Address Range Disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher Address Size Bit 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher Address Size Bit 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher Address Range Disable
FPROT_RNV6:         equ    6                                         ; Reserved Nonvolatile Bit
FPROT_FPOPEN:       equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
DFPROT:             equ    $00000109                                ;*** DFPROT - D-Flash Protection Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DFPROT_DPS0:        equ    0                                         ; D-Flash Protection Size Bit 0
DFPROT_DPS1:        equ    1                                         ; D-Flash Protection Size Bit 1
DFPROT_DPS2:        equ    2                                         ; D-Flash Protection Size Bit 2
DFPROT_DPS3:        equ    3                                         ; D-Flash Protection Size Bit 3
DFPROT_DPOPEN:      equ    7                                         ; D-Flash Protection Control
; bit position masks
mDFPROT_DPS0:       equ    %00000001
mDFPROT_DPS1:       equ    %00000010
mDFPROT_DPS2:       equ    %00000100
mDFPROT_DPS3:       equ    %00001000
mDFPROT_DPOPEN:     equ    %10000000


;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
FCCOB:              equ    $0000010A                                ;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOB_CCOB0:        equ    0                                         ; Flash Common Command Object Bit 0
FCCOB_CCOB1:        equ    1                                         ; Flash Common Command Object Bit 1
FCCOB_CCOB2:        equ    2                                         ; Flash Common Command Object Bit 2
FCCOB_CCOB3:        equ    3                                         ; Flash Common Command Object Bit 3
FCCOB_CCOB4:        equ    4                                         ; Flash Common Command Object Bit 4
FCCOB_CCOB5:        equ    5                                         ; Flash Common Command Object Bit 5
FCCOB_CCOB6:        equ    6                                         ; Flash Common Command Object Bit 6
FCCOB_CCOB7:        equ    7                                         ; Flash Common Command Object Bit 7
FCCOB_CCOB8:        equ    8                                         ; Flash Common Command Object Bit 8
FCCOB_CCOB9:        equ    9                                         ; Flash Common Command Object Bit 9
FCCOB_CCOB10:       equ    10                                        ; Flash Common Command Object Bit 10
FCCOB_CCOB11:       equ    11                                        ; Flash Common Command Object Bit 11
FCCOB_CCOB12:       equ    12                                        ; Flash Common Command Object Bit 12
FCCOB_CCOB13:       equ    13                                        ; Flash Common Command Object Bit 13
FCCOB_CCOB14:       equ    14                                        ; Flash Common Command Object Bit 14
FCCOB_CCOB15:       equ    15                                        ; Flash Common Command Object Bit 15
; bit position masks
mFCCOB_CCOB0:       equ    %00000001
mFCCOB_CCOB1:       equ    %00000010
mFCCOB_CCOB2:       equ    %00000100
mFCCOB_CCOB3:       equ    %00001000
mFCCOB_CCOB4:       equ    %00010000
mFCCOB_CCOB5:       equ    %00100000
mFCCOB_CCOB6:       equ    %01000000
mFCCOB_CCOB7:       equ    %10000000
mFCCOB_CCOB8:       equ    %100000000
mFCCOB_CCOB9:       equ    %1000000000
mFCCOB_CCOB10:      equ    %10000000000
mFCCOB_CCOB11:      equ    %100000000000
mFCCOB_CCOB12:      equ    %1000000000000
mFCCOB_CCOB13:      equ    %10000000000000
mFCCOB_CCOB14:      equ    %100000000000000
mFCCOB_CCOB15:      equ    %1000000000000000


;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
FCCOBHI:            equ    $0000010A                                ;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBHI_CCOB8:      equ    0                                         ; Flash Common Command Object Bit 8
FCCOBHI_CCOB9:      equ    1                                         ; Flash Common Command Object Bit 9
FCCOBHI_CCOB10:     equ    2                                         ; Flash Common Command Object Bit 10
FCCOBHI_CCOB11:     equ    3                                         ; Flash Common Command Object Bit 11
FCCOBHI_CCOB12:     equ    4                                         ; Flash Common Command Object Bit 12
FCCOBHI_CCOB13:     equ    5                                         ; Flash Common Command Object Bit 13
FCCOBHI_CCOB14:     equ    6                                         ; Flash Common Command Object Bit 14
FCCOBHI_CCOB15:     equ    7                                         ; Flash Common Command Object Bit 15
; bit position masks
mFCCOBHI_CCOB8:     equ    %00000001
mFCCOBHI_CCOB9:     equ    %00000010
mFCCOBHI_CCOB10:    equ    %00000100
mFCCOBHI_CCOB11:    equ    %00001000
mFCCOBHI_CCOB12:    equ    %00010000
mFCCOBHI_CCOB13:    equ    %00100000
mFCCOBHI_CCOB14:    equ    %01000000
mFCCOBHI_CCOB15:    equ    %10000000


;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
FCCOBLO:            equ    $0000010B                                ;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBLO_CCOB0:      equ    0                                         ; Flash Common Command Object Bit 0
FCCOBLO_CCOB1:      equ    1                                         ; Flash Common Command Object Bit 1
FCCOBLO_CCOB2:      equ    2                                         ; Flash Common Command Object Bit 2
FCCOBLO_CCOB3:      equ    3                                         ; Flash Common Command Object Bit 3
FCCOBLO_CCOB4:      equ    4                                         ; Flash Common Command Object Bit 4
FCCOBLO_CCOB5:      equ    5                                         ; Flash Common Command Object Bit 5
FCCOBLO_CCOB6:      equ    6                                         ; Flash Common Command Object Bit 6
FCCOBLO_CCOB7:      equ    7                                         ; Flash Common Command Object Bit 7
; bit position masks
mFCCOBLO_CCOB0:     equ    %00000001
mFCCOBLO_CCOB1:     equ    %00000010
mFCCOBLO_CCOB2:     equ    %00000100
mFCCOBLO_CCOB3:     equ    %00001000
mFCCOBLO_CCOB4:     equ    %00010000
mFCCOBLO_CCOB5:     equ    %00100000
mFCCOBLO_CCOB6:     equ    %01000000
mFCCOBLO_CCOB7:     equ    %10000000


;*** FOPT - Flash Option Register; 0x00000110 ***
FOPT:               equ    $00000110                                ;*** FOPT - Flash Option Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_NV0:           equ    0                                         ; Nonvolatile Bit 0
FOPT_NV1:           equ    1                                         ; Nonvolatile Bit 1
FOPT_NV2:           equ    2                                         ; Nonvolatile Bit 2
FOPT_NV3:           equ    3                                         ; Nonvolatile Bit 3
FOPT_NV4:           equ    4                                         ; Nonvolatile Bit 4
FOPT_NV5:           equ    5                                         ; Nonvolatile Bit 5
FOPT_NV6:           equ    6                                         ; Nonvolatile Bit 6
FOPT_NV7:           equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mFOPT_NV0:          equ    %00000001
mFOPT_NV1:          equ    %00000010
mFOPT_NV2:          equ    %00000100
mFOPT_NV3:          equ    %00001000
mFOPT_NV4:          equ    %00010000
mFOPT_NV5:          equ    %00100000
mFOPT_NV6:          equ    %01000000
mFOPT_NV7:          equ    %10000000


;*** PTIA - Port A Input Register; 0x00000120 ***
PTIA:               equ    $00000120                                ;*** PTIA - Port A Input Register; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIA_PTIA0:         equ    0                                         ; Port A input data bit 0
PTIA_PTIA1:         equ    1                                         ; Port A input data bit 1
PTIA_PTIA2:         equ    2                                         ; Port A input data bit 2
PTIA_PTIA3:         equ    3                                         ; Port A input data bit 3
PTIA_PTIA4:         equ    4                                         ; Port A input data bit 4
PTIA_PTIA5:         equ    5                                         ; Port A input data bit 5
PTIA_PTIA6:         equ    6                                         ; Port A input data bit 6
PTIA_PTIA7:         equ    7                                         ; Port A input data bit 7
; bit position masks
mPTIA_PTIA0:        equ    %00000001
mPTIA_PTIA1:        equ    %00000010
mPTIA_PTIA2:        equ    %00000100
mPTIA_PTIA3:        equ    %00001000
mPTIA_PTIA4:        equ    %00010000
mPTIA_PTIA5:        equ    %00100000
mPTIA_PTIA6:        equ    %01000000
mPTIA_PTIA7:        equ    %10000000


;*** PTIB - Port B Input Register; 0x00000121 ***
PTIB:               equ    $00000121                                ;*** PTIB - Port B Input Register; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIB_PTIB0:         equ    0                                         ; Port B input data bit 0
PTIB_PTIB1:         equ    1                                         ; Port B input data bit 1
; bit position masks
mPTIB_PTIB0:        equ    %00000001
mPTIB_PTIB1:        equ    %00000010


;*** CPMULVCTL - Low Voltage Control Register; 0x000001F1 ***
CPMULVCTL:          equ    $000001F1                                ;*** CPMULVCTL - Low Voltage Control Register; 0x000001F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMULVCTL_LVIF:     equ    0                                         ; Low-Voltage Interrupt Flag
CPMULVCTL_LVIE:     equ    1                                         ; Low-Voltage Interrupt Enable Bit
CPMULVCTL_LVDS:     equ    2                                         ; Low-Voltage Detect Status Bit
; bit position masks
mCPMULVCTL_LVIF:    equ    %00000001
mCPMULVCTL_LVIE:    equ    %00000010
mCPMULVCTL_LVDS:    equ    %00000100


;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000001F8 ***
CPMUIRCTRIM:        equ    $000001F8                                ;*** CPMUIRCTRIM - S12CPMU IRC1M Trim Registers; 0x000001F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIM_IRCTRIM0: equ    0                                       ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIM_IRCTRIM1: equ    1                                       ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIM_IRCTRIM2: equ    2                                       ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIM_IRCTRIM3: equ    3                                       ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIM_IRCTRIM4: equ    4                                       ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIM_IRCTRIM5: equ    5                                       ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIM_IRCTRIM6: equ    6                                       ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIM_IRCTRIM7: equ    7                                       ; IRC1M Frequency Trim Bit 7
CPMUIRCTRIM_IRCTRIM8: equ    8                                       ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIM_IRCTRIM9: equ    9                                       ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIM_TCTRIM0: equ    12                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIM_TCTRIM1: equ    13                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIM_TCTRIM2: equ    14                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIM_TCTRIM3: equ    15                                       ; IRC1M temperature coeficient Trim Bit 3
; bit position masks
mCPMUIRCTRIM_IRCTRIM0: equ    %00000001
mCPMUIRCTRIM_IRCTRIM1: equ    %00000010
mCPMUIRCTRIM_IRCTRIM2: equ    %00000100
mCPMUIRCTRIM_IRCTRIM3: equ    %00001000
mCPMUIRCTRIM_IRCTRIM4: equ    %00010000
mCPMUIRCTRIM_IRCTRIM5: equ    %00100000
mCPMUIRCTRIM_IRCTRIM6: equ    %01000000
mCPMUIRCTRIM_IRCTRIM7: equ    %10000000
mCPMUIRCTRIM_IRCTRIM8: equ    %100000000
mCPMUIRCTRIM_IRCTRIM9: equ    %1000000000
mCPMUIRCTRIM_TCTRIM0: equ    %1000000000000
mCPMUIRCTRIM_TCTRIM1: equ    %10000000000000
mCPMUIRCTRIM_TCTRIM2: equ    %100000000000000
mCPMUIRCTRIM_TCTRIM3: equ    %1000000000000000


;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000001F8 ***
CPMUIRCTRIMH:       equ    $000001F8                                ;*** CPMUIRCTRIMH - S12CPMU IRC1M Trim Registers High; 0x000001F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIMH_IRCTRIM8: equ    0                                      ; IRC1M Frequency Trim Bit 8
CPMUIRCTRIMH_IRCTRIM9: equ    1                                      ; IRC1M Frequency Trim Bit 9
CPMUIRCTRIMH_TCTRIM0: equ    4                                       ; IRC1M temperature coeficient Trim Bit 0
CPMUIRCTRIMH_TCTRIM1: equ    5                                       ; IRC1M temperature coeficient Trim Bit 1
CPMUIRCTRIMH_TCTRIM2: equ    6                                       ; IRC1M temperature coeficient Trim Bit 2
CPMUIRCTRIMH_TCTRIM3: equ    7                                       ; IRC1M temperature coeficient Trim Bit 3
; bit position masks
mCPMUIRCTRIMH_IRCTRIM8: equ    %00000001
mCPMUIRCTRIMH_IRCTRIM9: equ    %00000010
mCPMUIRCTRIMH_TCTRIM0: equ    %00010000
mCPMUIRCTRIMH_TCTRIM1: equ    %00100000
mCPMUIRCTRIMH_TCTRIM2: equ    %01000000
mCPMUIRCTRIMH_TCTRIM3: equ    %10000000


;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000001F9 ***
CPMUIRCTRIML:       equ    $000001F9                                ;*** CPMUIRCTRIML - S12CPMU IRC1M Trim Registers Low; 0x000001F9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUIRCTRIML_IRCTRIM0: equ    0                                      ; IRC1M Frequency Trim Bit 0
CPMUIRCTRIML_IRCTRIM1: equ    1                                      ; IRC1M Frequency Trim Bit 1
CPMUIRCTRIML_IRCTRIM2: equ    2                                      ; IRC1M Frequency Trim Bit 2
CPMUIRCTRIML_IRCTRIM3: equ    3                                      ; IRC1M Frequency Trim Bit 3
CPMUIRCTRIML_IRCTRIM4: equ    4                                      ; IRC1M Frequency Trim Bit 4
CPMUIRCTRIML_IRCTRIM5: equ    5                                      ; IRC1M Frequency Trim Bit 5
CPMUIRCTRIML_IRCTRIM6: equ    6                                      ; IRC1M Frequency Trim Bit 6
CPMUIRCTRIML_IRCTRIM7: equ    7                                      ; IRC1M Frequency Trim Bit 7
; bit position masks
mCPMUIRCTRIML_IRCTRIM0: equ    %00000001
mCPMUIRCTRIML_IRCTRIM1: equ    %00000010
mCPMUIRCTRIML_IRCTRIM2: equ    %00000100
mCPMUIRCTRIML_IRCTRIM3: equ    %00001000
mCPMUIRCTRIML_IRCTRIM4: equ    %00010000
mCPMUIRCTRIML_IRCTRIM5: equ    %00100000
mCPMUIRCTRIML_IRCTRIM6: equ    %01000000
mCPMUIRCTRIML_IRCTRIM7: equ    %10000000


;*** CPMUOSC - S12CPMU Oscillator Register; 0x000001FA ***
CPMUOSC:            equ    $000001FA                                ;*** CPMUOSC - S12CPMU Oscillator Register; 0x000001FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUOSC_OSCFILT0:   equ    0                                         ; Oscillator Filter Bits, bit 0
CPMUOSC_OSCFILT1:   equ    1                                         ; Oscillator Filter Bits, bit 1
CPMUOSC_OSCFILT2:   equ    2                                         ; Oscillator Filter Bits, bit 2
CPMUOSC_OSCFILT3:   equ    3                                         ; Oscillator Filter Bits, bit 3
CPMUOSC_OSCFILT4:   equ    4                                         ; Oscillator Filter Bits, bit 4
CPMUOSC_OSCPINS_EN: equ    5                                         ; Oscillator Pins EXTAL and XTAL Enable Bit
CPMUOSC_OSCBW:      equ    6                                         ; Oscillator Filter Bandwidth Bit
CPMUOSC_OSCE:       equ    7                                         ; Oscillator Enable Bit
; bit position masks
mCPMUOSC_OSCFILT0:  equ    %00000001
mCPMUOSC_OSCFILT1:  equ    %00000010
mCPMUOSC_OSCFILT2:  equ    %00000100
mCPMUOSC_OSCFILT3:  equ    %00001000
mCPMUOSC_OSCFILT4:  equ    %00010000
mCPMUOSC_OSCPINS_EN: equ    %00100000
mCPMUOSC_OSCBW:     equ    %01000000
mCPMUOSC_OSCE:      equ    %10000000


;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000001FB ***
CPMUPROT:           equ    $000001FB                                ;*** CPMUPROT - S12CPMUV1 Protection Register; 0x000001FB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CPMUPROT_PROT:      equ    0                                         ; Clock Configuration Registers Protection Bit
; bit position masks
mCPMUPROT_PROT:     equ    %00000001


;*** B_ISR - Interrupt Source Register; 0x00000200 ***
B_ISR:              equ    $00000200                                ;*** B_ISR - Interrupt Source Register; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ISR_VSI:          equ    0                                         ; Voltage Status Interrupt
B_ISR_CH0:          equ    1                                         ; TIM Channel 0 Interrupt
B_ISR_CH1:          equ    2                                         ; TIM Channel 1 Interrupt
B_ISR_CH2:          equ    3                                         ; TIM Channel 2 Interrupt
B_ISR_CH3:          equ    4                                         ; TIM Channel 3 Interrupt
B_ISR_TOV:          equ    5                                         ; Timer Overflow Interrupt
B_ISR_ERR:          equ    6                                         ; SCI Error Interrupt
B_ISR_TX:           equ    7                                         ; SCI Transmit Interrupt
B_ISR_RX:           equ    8                                         ; SCI Receive Interrupt
B_ISR_SCI:          equ    9                                         ; ADC Sequence Complete Interrupt
B_ISR_LINOT:        equ    10                                        ; LIN Driver Over-temperature Interrupt
B_ISR_HSOT:         equ    11                                        ; High Side Over-temperature Interrupt
B_ISR_LSOT:         equ    12                                        ; Low Side Over-temperature Interrupt
B_ISR_HOT:          equ    13                                        ; HSUP Over-temperature Interrupt
; bit position masks
mB_ISR_VSI:         equ    %00000001
mB_ISR_CH0:         equ    %00000010
mB_ISR_CH1:         equ    %00000100
mB_ISR_CH2:         equ    %00001000
mB_ISR_CH3:         equ    %00010000
mB_ISR_TOV:         equ    %00100000
mB_ISR_ERR:         equ    %01000000
mB_ISR_TX:          equ    %10000000
mB_ISR_RX:          equ    %100000000
mB_ISR_SCI:         equ    %1000000000
mB_ISR_LINOT:       equ    %10000000000
mB_ISR_HSOT:        equ    %100000000000
mB_ISR_LSOT:        equ    %1000000000000
mB_ISR_HOT:         equ    %10000000000000


;*** B_ISRhi - Interrupt Source Register High; 0x00000200 ***
B_ISRhi:            equ    $00000200                                ;*** B_ISRhi - Interrupt Source Register High; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ISRhi_RX:         equ    0                                         ; SCI Receive Interrupt
B_ISRhi_SCI:        equ    1                                         ; ADC Sequence Complete Interrupt
B_ISRhi_LINOT:      equ    2                                         ; LIN Driver Over-temperature Interrupt
B_ISRhi_HSOT:       equ    3                                         ; High Side Over-temperature Interrupt
B_ISRhi_LSOT:       equ    4                                         ; Low Side Over-temperature Interrupt
B_ISRhi_HOT:        equ    5                                         ; HSUP Over-temperature Interrupt
; bit position masks
mB_ISRhi_RX:        equ    %00000001
mB_ISRhi_SCI:       equ    %00000010
mB_ISRhi_LINOT:     equ    %00000100
mB_ISRhi_HSOT:      equ    %00001000
mB_ISRhi_LSOT:      equ    %00010000
mB_ISRhi_HOT:       equ    %00100000


;*** B_ISRlo - Interrupt Source Register Low; 0x00000201 ***
B_ISRlo:            equ    $00000201                                ;*** B_ISRlo - Interrupt Source Register Low; 0x00000201 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ISRlo_VSI:        equ    0                                         ; Voltage Status Interrupt
B_ISRlo_CH0:        equ    1                                         ; TIM Channel 0 Interrupt
B_ISRlo_CH1:        equ    2                                         ; TIM Channel 1 Interrupt
B_ISRlo_CH2:        equ    3                                         ; TIM Channel 2 Interrupt
B_ISRlo_CH3:        equ    4                                         ; TIM Channel 3 Interrupt
B_ISRlo_TOV:        equ    5                                         ; Timer Overflow Interrupt
B_ISRlo_ERR:        equ    6                                         ; SCI Error Interrupt
B_ISRlo_TX:         equ    7                                         ; SCI Transmit Interrupt
; bit position masks
mB_ISRlo_VSI:       equ    %00000001
mB_ISRlo_CH0:       equ    %00000010
mB_ISRlo_CH1:       equ    %00000100
mB_ISRlo_CH2:       equ    %00001000
mB_ISRlo_CH3:       equ    %00010000
mB_ISRlo_TOV:       equ    %00100000
mB_ISRlo_ERR:       equ    %01000000
mB_ISRlo_TX:        equ    %10000000


;*** B_IVR - Interrupt Vector Register; 0x00000202 ***
B_IVR:              equ    $00000202                                ;*** B_IVR - Interrupt Vector Register; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_IVR_IRQ:          equ    0                                         ; Represents the highest prioritized interrupt pending
; bit position masks
mB_IVR_IRQ:         equ    %00111111


;*** B_VCR - Voltage Control Register; 0x00000204 ***
B_VCR:              equ    $00000204                                ;*** B_VCR - Voltage Control Register; 0x00000204 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_VCR_LBIE:         equ    0                                         ; Low Battery Interrupt Enable
B_VCR_LVIE:         equ    1                                         ; Low Voltage Interrupt Enable
B_VCR_HVIE:         equ    2                                         ; High Voltage Interrupt Enable
B_VCR_HTIE:         equ    3                                         ; High Temperature Interrupt Enable
B_VCR_VROVIE:       equ    4                                         ; Voltage Regulator Over-voltage Interrupt Enable
; bit position masks
mB_VCR_LBIE:        equ    %00000001
mB_VCR_LVIE:        equ    %00000010
mB_VCR_HVIE:        equ    %00000100
mB_VCR_HTIE:        equ    %00001000
mB_VCR_VROVIE:      equ    %00010000


;*** B_VSR - Voltage Status Register; 0x00000205 ***
B_VSR:              equ    $00000205                                ;*** B_VSR - Voltage Status Register; 0x00000205 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_VSR_LBC:          equ    0                                         ; Low Battery Condition
B_VSR_LVC:          equ    1                                         ; Low Voltage Condition
B_VSR_HVC:          equ    2                                         ; High Voltage Condition
B_VSR_HTC:          equ    3                                         ; High Temperature Condition
B_VSR_VROVC:        equ    4                                         ; Voltage Regulator Over-voltage Condition
; bit position masks
mB_VSR_LBC:         equ    %00000001
mB_VSR_LVC:         equ    %00000010
mB_VSR_HVC:         equ    %00000100
mB_VSR_HTC:         equ    %00001000
mB_VSR_VROVC:       equ    %00010000


;*** B_LXR - Lx Status Register; 0x00000208 ***
B_LXR:              equ    $00000208                                ;*** B_LXR - Lx Status Register; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LXR_L0:           equ    0                                         ; Current Digital State of the L0 Input
B_LXR_L1:           equ    1                                         ; Current Digital State of the L1 Input
B_LXR_L2:           equ    2                                         ; Current Digital State of the L2 Input
B_LXR_L3:           equ    3                                         ; Current Digital State of the L3 Input
B_LXR_L4:           equ    4                                         ; Current Digital State of the L4 Input
B_LXR_L5:           equ    5                                         ; Current Digital State of the L5 Input
; bit position masks
mB_LXR_L0:          equ    %00000001
mB_LXR_L1:          equ    %00000010
mB_LXR_L2:          equ    %00000100
mB_LXR_L3:          equ    %00001000
mB_LXR_L4:          equ    %00010000
mB_LXR_L5:          equ    %00100000


;*** B_LXCR - Lx Control Register; 0x00000209 ***
B_LXCR:             equ    $00000209                                ;*** B_LXCR - Lx Control Register; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LXCR_L0DS:        equ    0                                         ; Analog Input Divider Ratio Selection - L0
B_LXCR_L1DS:        equ    1                                         ; Analog Input Divider Ratio Selection - L1
B_LXCR_L2DS:        equ    2                                         ; Analog Input Divider Ratio Selection - L2
B_LXCR_L3DS:        equ    3                                         ; Analog Input Divider Ratio Selection - L3
B_LXCR_L4DS:        equ    4                                         ; Analog Input Divider Ratio Selection - L4
B_LXCR_L5DS:        equ    5                                         ; Analog Input Divider Ratio Selection - L5
; bit position masks
mB_LXCR_L0DS:       equ    %00000001
mB_LXCR_L1DS:       equ    %00000010
mB_LXCR_L2DS:       equ    %00000100
mB_LXCR_L3DS:       equ    %00001000
mB_LXCR_L4DS:       equ    %00010000
mB_LXCR_L5DS:       equ    %00100000


;*** B_WDR - Watchdog Register; 0x00000210 ***
B_WDR:              equ    $00000210                                ;*** B_WDR - Watchdog Register; 0x00000210 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_WDR_WDTO:         equ    0                                         ; Watchdog Timeout Configuration Bit 0
B_WDR_WDWO:         equ    6                                         ; Watchdog Window Open
B_WDR_WDOFF:        equ    7                                         ; Watchdog Off
; bit position masks
mB_WDR_WDTO:        equ    %00000111
mB_WDR_WDWO:        equ    %01000000
mB_WDR_WDOFF:       equ    %10000000


;*** B_WDSR - Watchdog Service Register; 0x00000211 ***
B_WDSR:             equ    $00000211                                ;*** B_WDSR - Watchdog Service Register; 0x00000211 ***


;*** B_WCR - Wake-up Control Register; 0x00000212 ***
B_WCR:              equ    $00000212                                ;*** B_WCR - Wake-up Control Register; 0x00000212 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_WCR_L0WE:         equ    0                                         ; Wake-up Input 0 Enabled
B_WCR_L1WE:         equ    1                                         ; Wake-up Input 1 Enabled
B_WCR_L2WE:         equ    2                                         ; Wake-up Input 2 Enabled
B_WCR_L3WE:         equ    3                                         ; Wake-up Input 3 Enabled
B_WCR_L4WE:         equ    4                                         ; Wake-up Input 4 Enabled
B_WCR_L5WE:         equ    5                                         ; Wake-up Input 5 Enabled
B_WCR_CSSEL:        equ    6                                         ; Cyclic Sense Select Bit 0
; bit position masks
mB_WCR_L0WE:        equ    %00000001
mB_WCR_L1WE:        equ    %00000010
mB_WCR_L2WE:        equ    %00000100
mB_WCR_L3WE:        equ    %00001000
mB_WCR_L4WE:        equ    %00010000
mB_WCR_L5WE:        equ    %00100000
mB_WCR_CSSEL:       equ    %11000000


;*** B_TCR - Timing Control Register; 0x00000213 ***
B_TCR:              equ    $00000213                                ;*** B_TCR - Timing Control Register; 0x00000213 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCR_CST:          equ    0                                         ; Cyclic Sense Timing Bit 0
B_TCR_FWM:          equ    4                                         ; Forced Wake-up Multiplicator Bit 0
; bit position masks
mB_TCR_CST:         equ    %00001111
mB_TCR_FWM:         equ    %11110000


;*** B_WSR - Wake-up Source Register; 0x00000214 ***
B_WSR:              equ    $00000214                                ;*** B_WSR - Wake-up Source Register; 0x00000214 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_WSR_L0WU:         equ    0                                         ; L0 Wake-upe-up
B_WSR_L1WU:         equ    1                                         ; L1 Wake-upp
B_WSR_L2WU:         equ    2                                         ; L2 Wake-up
B_WSR_L3WU:         equ    3                                         ; L3 Wake-up
B_WSR_L4WU:         equ    4                                         ; L4 Wake-up
B_WSR_L5WU:         equ    5                                         ; L5 Wake-up
B_WSR_LINWU:        equ    6                                         ; LIN Wake-up
B_WSR_FWU:          equ    7                                         ; Forced Wake-up
; bit position masks
mB_WSR_L0WU:        equ    %00000001
mB_WSR_L1WU:        equ    %00000010
mB_WSR_L2WU:        equ    %00000100
mB_WSR_L3WU:        equ    %00001000
mB_WSR_L4WU:        equ    %00010000
mB_WSR_L5WU:        equ    %00100000
mB_WSR_LINWU:       equ    %01000000
mB_WSR_FWU:         equ    %10000000


;*** B_RSR - Reset Status Register; 0x00000215 ***
B_RSR:              equ    $00000215                                ;*** B_RSR - Reset Status Register; 0x00000215 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_RSR_POR:          equ    0                                         ; Power On Reset
B_RSR_LVR:          equ    1                                         ; Low Voltage Reset VDD
B_RSR_LVRX:         equ    2                                         ; Low Voltage Reset VDDX
B_RSR_WUR:          equ    3                                         ; Wake-up Reset
B_RSR_EXR:          equ    4                                         ; External Reset
B_RSR_WDR:          equ    5                                         ; Watchdog Reset
; bit position masks
mB_RSR_POR:         equ    %00000001
mB_RSR_LVR:         equ    %00000010
mB_RSR_LVRX:        equ    %00000100
mB_RSR_WUR:         equ    %00001000
mB_RSR_EXR:         equ    %00010000
mB_RSR_WDR:         equ    %00100000


;*** B_MCR - Mode Control Register; 0x00000216 ***
B_MCR:              equ    $00000216                                ;*** B_MCR - Mode Control Register; 0x00000216 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_MCR_MODE:         equ    0                                         ; Mode Select bit 0
; bit position masks
mB_MCR_MODE:        equ    %00000011


;*** B_LINR - LIN Register; 0x00000218 ***
B_LINR:             equ    $00000218                                ;*** B_LINR - LIN Register; 0x00000218 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LINR_LINSR:       equ    0                                         ; LIN - Slew Rate Select 0
B_LINR_LINEN:       equ    2                                         ; LIN Module Enable
B_LINR_LVSD:        equ    3                                         ; LIN - Low Voltage Shutdown Disable (J2602 Compliance Control)
B_LINR_TX:          equ    4                                         ; LIN - Direct Transmitter Control
B_LINR_RX:          equ    5                                         ; LIN - Receiver (Rx) Status
B_LINR_LINOTC:      equ    6                                         ; LIN - Over-temperature condition present
B_LINR_LINOTIE:     equ    7                                         ; LIN - Over-temperature Interrupt Enable
; bit position masks
mB_LINR_LINSR:      equ    %00000011
mB_LINR_LINEN:      equ    %00000100
mB_LINR_LVSD:       equ    %00001000
mB_LINR_TX:         equ    %00010000
mB_LINR_RX:         equ    %00100000
mB_LINR_LINOTC:     equ    %01000000
mB_LINR_LINOTIE:    equ    %10000000


;*** B_PTBC1 - Port B Configuration Register 1; 0x00000220 ***
B_PTBC1:            equ    $00000220                                ;*** B_PTBC1 - Port B Configuration Register 1; 0x00000220 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PTBC1_DDRB0:      equ    0                                         ; Data Direction Port B 0
B_PTBC1_DDRB1:      equ    1                                         ; Data Direction Port B 0
B_PTBC1_DDRB2:      equ    2                                         ; Data Direction Port B 0
B_PTBC1_PUEB0:      equ    4                                         ; Pull-up Enable Port B 0
B_PTBC1_PUEB1:      equ    5                                         ; Pull-up Enable Port B 0
B_PTBC1_PUEB2:      equ    6                                         ; Pull-up Enable Port B 0
; bit position masks
mB_PTBC1_DDRB0:     equ    %00000001
mB_PTBC1_DDRB1:     equ    %00000010
mB_PTBC1_DDRB2:     equ    %00000100
mB_PTBC1_PUEB0:     equ    %00010000
mB_PTBC1_PUEB1:     equ    %00100000
mB_PTBC1_PUEB2:     equ    %01000000


;*** B_PTBC2 - Port B Configuration Register 2; 0x00000221 ***
B_PTBC2:            equ    $00000221                                ;*** B_PTBC2 - Port B Configuration Register 2; 0x00000221 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PTBC2_SERMOD:     equ    0                                         ; Serial Mode Select for PTB 0
B_PTBC2_PWMEN:      equ    2                                         ; PWM Enable for PTB2
B_PTBC2_PWMCS:      equ    3                                         ; PWM Channel Select PTB2
; bit position masks
mB_PTBC2_SERMOD:    equ    %00000011
mB_PTBC2_PWMEN:     equ    %00000100
mB_PTBC2_PWMCS:     equ    %00001000


;*** B_PTB - Port B Data Register; 0x00000222 ***
B_PTB:              equ    $00000222                                ;*** B_PTB - Port B Data Register; 0x00000222 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PTB_PTB0:         equ    0                                         ; Port B general purpose input/output data 0
B_PTB_PTB1:         equ    1                                         ; Port B general purpose input/output data 1
B_PTB_PTB2:         equ    2                                         ; Port B general purpose input/output data 2
; bit position masks
mB_PTB_PTB0:        equ    %00000001
mB_PTB_PTB1:        equ    %00000010
mB_PTB_PTB2:        equ    %00000100


;*** B_HSCR - High Side Control Register; 0x00000228 ***
B_HSCR:             equ    $00000228                                ;*** B_HSCR - High Side Control Register; 0x00000228 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_HSCR_HS1:         equ    0                                         ; HS2 Control
B_HSCR_HS2:         equ    1                                         ; HS2 Control
B_HSCR_PWMHS1:      equ    2                                         ; PWM Enable for HS1
B_HSCR_PWMHS2:      equ    3                                         ; PWM Enable for HS2
B_HSCR_PWMCS1:      equ    4                                         ; PWM Channel Select HS1
B_HSCR_PWMCS2:      equ    5                                         ; PWM Channel Select HS2
B_HSCR_HSHVSDE:     equ    6                                         ; High Side High Voltage Shutdown
B_HSCR_HSOTIE:      equ    7                                         ; High Side Over-temperature Interrupt Enable
; bit position masks
mB_HSCR_HS1:        equ    %00000001
mB_HSCR_HS2:        equ    %00000010
mB_HSCR_PWMHS1:     equ    %00000100
mB_HSCR_PWMHS2:     equ    %00001000
mB_HSCR_PWMCS1:     equ    %00010000
mB_HSCR_PWMCS2:     equ    %00100000
mB_HSCR_HSHVSDE:    equ    %01000000
mB_HSCR_HSOTIE:     equ    %10000000


;*** B_HSSR - High Side Status Register; 0x00000229 ***
B_HSSR:             equ    $00000229                                ;*** B_HSSR - High Side Status Register; 0x00000229 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_HSSR_HS1OL:       equ    0                                         ; High Side 1Open Load
B_HSSR_HS2OL:       equ    1                                         ; High Side 2 Open Load
B_HSSR_HS1CL:       equ    2                                         ; High Side 1 Current Limitation
B_HSSR_HS2CL:       equ    3                                         ; High Side 2 Current Limitation
B_HSSR_HSOTC:       equ    7                                         ; High Side Over-temperature Condition
; bit position masks
mB_HSSR_HS1OL:      equ    %00000001
mB_HSSR_HS2OL:      equ    %00000010
mB_HSSR_HS1CL:      equ    %00000100
mB_HSSR_HS2CL:      equ    %00001000
mB_HSSR_HSOTC:      equ    %10000000


;*** B_LSCR - Low Side Control Register; 0x00000230 ***
B_LSCR:             equ    $00000230                                ;*** B_LSCR - Low Side Control Register; 0x00000230 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LSCR_LS1:         equ    0                                         ; LS1 Enable
B_LSCR_LS2:         equ    1                                         ; LS2 Enable
B_LSCR_PWMLS1:      equ    2                                         ; PWM Enable for LS1
B_LSCR_PWMLS2:      equ    3                                         ; PWM Enable for LS2
B_LSCR_PWMCS1:      equ    4                                         ; PWM Channel Select LS1
B_LSCR_PWMCS2:      equ    5                                         ; PWM Channel Select LS2
B_LSCR_LSOTIE:      equ    7                                         ; Low Side Over-temperature Interrupt Enable
; bit position masks
mB_LSCR_LS1:        equ    %00000001
mB_LSCR_LS2:        equ    %00000010
mB_LSCR_PWMLS1:     equ    %00000100
mB_LSCR_PWMLS2:     equ    %00001000
mB_LSCR_PWMCS1:     equ    %00010000
mB_LSCR_PWMCS2:     equ    %00100000
mB_LSCR_LSOTIE:     equ    %10000000


;*** B_LSSR - Low Side Status Register; 0x00000231 ***
B_LSSR:             equ    $00000231                                ;*** B_LSSR - Low Side Status Register; 0x00000231 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LSSR_LS1OL:       equ    0                                         ; Low Side 1 Open Load
B_LSSR_LS2OL:       equ    1                                         ; Low Side 2 Open Load
B_LSSR_LS1CL:       equ    2                                         ; Low Side 1 Current Limitation
B_LSSR_LS2CL:       equ    3                                         ; Low Side 2 Current Limitation
B_LSSR_LSOTC:       equ    7                                         ; Low Side Over-temperature condition present
; bit position masks
mB_LSSR_LS1OL:      equ    %00000001
mB_LSSR_LS2OL:      equ    %00000010
mB_LSSR_LS1CL:      equ    %00000100
mB_LSSR_LS2CL:      equ    %00001000
mB_LSSR_LSOTC:      equ    %10000000


;*** B_LSCEN - Low Side Control Enable Register; 0x00000232 ***
B_LSCEN:            equ    $00000232                                ;*** B_LSCEN - Low Side Control Enable Register; 0x00000232 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_LSCEN_LSCEN:      equ    0                                         ; Low Side Control Enable Bit 0
; bit position masks
mB_LSCEN_LSCEN:     equ    %00001111


;*** B_HSR - Hall Supply Register; 0x00000238 ***
B_HSR:              equ    $00000238                                ;*** B_HSR - Hall Supply Register; 0x00000238 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_HSR_HSUPON:       equ    0                                         ; Hall Supply On
B_HSR_HOTC:         equ    6                                         ; Hall Supply Over-temperature Condition
B_HSR_HOTIE:        equ    7                                         ; Hall Supply Over-temperature Interrupt Enable
; bit position masks
mB_HSR_HSUPON:      equ    %00000001
mB_HSR_HOTC:        equ    %01000000
mB_HSR_HOTIE:       equ    %10000000


;*** B_CSR - Current Sense Register; 0x0000023C ***
B_CSR:              equ    $0000023C                                ;*** B_CSR - Current Sense Register; 0x0000023C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_CSR_CSGS:         equ    0                                         ; Current Sense Gain Select 0
B_CSR_CCD:          equ    3                                         ; Input Filter Charge Compensation Disable Bit
B_CSR_CSE:          equ    7                                         ; Current Sense Enable Bit
; bit position masks
mB_CSR_CSGS:        equ    %00000111
mB_CSR_CCD:         equ    %00001000
mB_CSR_CSE:         equ    %10000000


;*** B_SCIBD - SCI Baud Rate Register; 0x00000240 ***
B_SCIBD:            equ    $00000240                                ;*** B_SCIBD - SCI Baud Rate Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIBD_SBR0:       equ    0                                         ; Baud Rate Modulo Divisor Bit 0
B_SCIBD_SBR1:       equ    1                                         ; Baud Rate Modulo Divisor Bit 1
B_SCIBD_SBR2:       equ    2                                         ; Baud Rate Modulo Divisor Bit 2
B_SCIBD_SBR3:       equ    3                                         ; Baud Rate Modulo Divisor Bit 3
B_SCIBD_SBR4:       equ    4                                         ; Baud Rate Modulo Divisor Bit 4
B_SCIBD_SBR5:       equ    5                                         ; Baud Rate Modulo Divisor Bit 5
B_SCIBD_SBR6:       equ    6                                         ; Baud Rate Modulo Divisor Bit 6
B_SCIBD_SBR7:       equ    7                                         ; Baud Rate Modulo Divisor Bit 7
B_SCIBD_SBR8:       equ    8                                         ; Baud Rate Modulo Divisor Bit 8
B_SCIBD_SBR9:       equ    9                                         ; Baud Rate Modulo Divisor Bit 9
B_SCIBD_SBR10:      equ    10                                        ; Baud Rate Modulo Divisor Bit 10
B_SCIBD_SBR11:      equ    11                                        ; Baud Rate Modulo Divisor Bit 11
B_SCIBD_SBR12:      equ    12                                        ; Baud Rate Modulo Divisor Bit 12
B_SCIBD_RXEDGIE:    equ    14                                        ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
B_SCIBD_LBKDIE:     equ    15                                        ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mB_SCIBD_SBR0:      equ    %00000001
mB_SCIBD_SBR1:      equ    %00000010
mB_SCIBD_SBR2:      equ    %00000100
mB_SCIBD_SBR3:      equ    %00001000
mB_SCIBD_SBR4:      equ    %00010000
mB_SCIBD_SBR5:      equ    %00100000
mB_SCIBD_SBR6:      equ    %01000000
mB_SCIBD_SBR7:      equ    %10000000
mB_SCIBD_SBR8:      equ    %100000000
mB_SCIBD_SBR9:      equ    %1000000000
mB_SCIBD_SBR10:     equ    %10000000000
mB_SCIBD_SBR11:     equ    %100000000000
mB_SCIBD_SBR12:     equ    %1000000000000
mB_SCIBD_RXEDGIE:   equ    %100000000000000
mB_SCIBD_LBKDIE:    equ    %1000000000000000


;*** B_SCIBDH - SCI Baud Rate Register High; 0x00000240 ***
B_SCIBDH:           equ    $00000240                                ;*** B_SCIBDH - SCI Baud Rate Register High; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIBDH_SBR8:      equ    0                                         ; Baud Rate Modulo Divisor Bit 8
B_SCIBDH_SBR9:      equ    1                                         ; Baud Rate Modulo Divisor Bit 9
B_SCIBDH_SBR10:     equ    2                                         ; Baud Rate Modulo Divisor Bit 10
B_SCIBDH_SBR11:     equ    3                                         ; Baud Rate Modulo Divisor Bit 11
B_SCIBDH_SBR12:     equ    4                                         ; Baud Rate Modulo Divisor Bit 12
B_SCIBDH_RXEDGIE:   equ    6                                         ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
B_SCIBDH_LBKDIE:    equ    7                                         ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mB_SCIBDH_SBR8:     equ    %00000001
mB_SCIBDH_SBR9:     equ    %00000010
mB_SCIBDH_SBR10:    equ    %00000100
mB_SCIBDH_SBR11:    equ    %00001000
mB_SCIBDH_SBR12:    equ    %00010000
mB_SCIBDH_RXEDGIE:  equ    %01000000
mB_SCIBDH_LBKDIE:   equ    %10000000


;*** B_SCIBDL - SCI Baud Rate Register Low; 0x00000241 ***
B_SCIBDL:           equ    $00000241                                ;*** B_SCIBDL - SCI Baud Rate Register Low; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIBDL_SBR0:      equ    0                                         ; Baud Rate Modulo Divisor Bit 0
B_SCIBDL_SBR1:      equ    1                                         ; Baud Rate Modulo Divisor Bit 1
B_SCIBDL_SBR2:      equ    2                                         ; Baud Rate Modulo Divisor Bit 2
B_SCIBDL_SBR3:      equ    3                                         ; Baud Rate Modulo Divisor Bit 3
B_SCIBDL_SBR4:      equ    4                                         ; Baud Rate Modulo Divisor Bit 4
B_SCIBDL_SBR5:      equ    5                                         ; Baud Rate Modulo Divisor Bit 5
B_SCIBDL_SBR6:      equ    6                                         ; Baud Rate Modulo Divisor Bit 6
B_SCIBDL_SBR7:      equ    7                                         ; Baud Rate Modulo Divisor Bit 7
; bit position masks
mB_SCIBDL_SBR0:     equ    %00000001
mB_SCIBDL_SBR1:     equ    %00000010
mB_SCIBDL_SBR2:     equ    %00000100
mB_SCIBDL_SBR3:     equ    %00001000
mB_SCIBDL_SBR4:     equ    %00010000
mB_SCIBDL_SBR5:     equ    %00100000
mB_SCIBDL_SBR6:     equ    %01000000
mB_SCIBDL_SBR7:     equ    %10000000


;*** B_SCIC1 - SCI Control Register 1; 0x00000242 ***
B_SCIC1:            equ    $00000242                                ;*** B_SCIC1 - SCI Control Register 1; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIC1_PT:         equ    0                                         ; Parity Type
B_SCIC1_PE:         equ    1                                         ; Parity Enable
B_SCIC1_ILT:        equ    2                                         ; Idle Line Type Select
B_SCIC1_M:          equ    4                                         ; 9-Bit or 8-Bit Mode Select
B_SCIC1_RSRC:       equ    5                                         ; Receiver Source Select
B_SCIC1_LOOPS:      equ    7                                         ; Loop Mode Select
; bit position masks
mB_SCIC1_PT:        equ    %00000001
mB_SCIC1_PE:        equ    %00000010
mB_SCIC1_ILT:       equ    %00000100
mB_SCIC1_M:         equ    %00010000
mB_SCIC1_RSRC:      equ    %00100000
mB_SCIC1_LOOPS:     equ    %10000000


;*** B_SCIC2 - SCI Control Register 2; 0x00000243 ***
B_SCIC2:            equ    $00000243                                ;*** B_SCIC2 - SCI Control Register 2; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIC2_SBK:        equ    0                                         ; Send Break
B_SCIC2_RWU:        equ    1                                         ; Receiver Wakeup Control
B_SCIC2_RE:         equ    2                                         ; Receiver Enable
B_SCIC2_TE:         equ    3                                         ; Transmitter Enable
B_SCIC2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable (for IDLE)
B_SCIC2_RIE:        equ    5                                         ; Receiver Interrupt Enable (for RDRF)
B_SCIC2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable (for TC)
B_SCIC2_TIE:        equ    7                                         ; Transmit Interrupt Enable (for TDRE)
; bit position masks
mB_SCIC2_SBK:       equ    %00000001
mB_SCIC2_RWU:       equ    %00000010
mB_SCIC2_RE:        equ    %00000100
mB_SCIC2_TE:        equ    %00001000
mB_SCIC2_ILIE:      equ    %00010000
mB_SCIC2_RIE:       equ    %00100000
mB_SCIC2_TCIE:      equ    %01000000
mB_SCIC2_TIE:       equ    %10000000


;*** B_SCIS1 - SCI Status Register 1; 0x00000244 ***
B_SCIS1:            equ    $00000244                                ;*** B_SCIS1 - SCI Status Register 1; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIS1_PF:         equ    0                                         ; Parity Error Flag
B_SCIS1_FE:         equ    1                                         ; Framing Error Flag
B_SCIS1_NF:         equ    2                                         ; Noise Flag
B_SCIS1_OR:         equ    3                                         ; Receiver Overrun Flag
B_SCIS1_IDLE:       equ    4                                         ; Idle Line Flag
B_SCIS1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
B_SCIS1_TC:         equ    6                                         ; Transmission Complete Flag
B_SCIS1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mB_SCIS1_PF:        equ    %00000001
mB_SCIS1_FE:        equ    %00000010
mB_SCIS1_NF:        equ    %00000100
mB_SCIS1_OR:        equ    %00001000
mB_SCIS1_IDLE:      equ    %00010000
mB_SCIS1_RDRF:      equ    %00100000
mB_SCIS1_TC:        equ    %01000000
mB_SCIS1_TDRE:      equ    %10000000


;*** B_SCIS2 - SCI Status Register 2; 0x00000245 ***
B_SCIS2:            equ    $00000245                                ;*** B_SCIS2 - SCI Status Register 2; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIS2_RAF:        equ    0                                         ; Receiver Active Flag
B_SCIS2_LBKDE:      equ    1                                         ; LIN Break Detection Enable
B_SCIS2_BRK13:      equ    2                                         ; Break Character Generation Length
B_SCIS2_RWUID:      equ    3                                         ; Receive Wake Up Idle Detect
B_SCIS2_RXINV:      equ    4                                         ; Receive Data Inversion
B_SCIS2_RXEDGIF:    equ    6                                         ; RxD Pin Active Edge Interrupt Flag
B_SCIS2_LBKDIF:     equ    7                                         ; LIN Break Detect Interrupt Flag
; bit position masks
mB_SCIS2_RAF:       equ    %00000001
mB_SCIS2_LBKDE:     equ    %00000010
mB_SCIS2_BRK13:     equ    %00000100
mB_SCIS2_RWUID:     equ    %00001000
mB_SCIS2_RXINV:     equ    %00010000
mB_SCIS2_RXEDGIF:   equ    %01000000
mB_SCIS2_LBKDIF:    equ    %10000000


;*** B_SCIC3 - SCI Control Register 3; 0x00000246 ***
B_SCIC3:            equ    $00000246                                ;*** B_SCIC3 - SCI Control Register 3; 0x00000246 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCIC3_PEIE:       equ    0                                         ; Parity Error Interrupt Enable
B_SCIC3_FEIE:       equ    1                                         ; Framing Error Interrupt Enable
B_SCIC3_NEIE:       equ    2                                         ; Noise Error Interrupt Enable
B_SCIC3_ORIE:       equ    3                                         ; Overrun Interrupt Enable
B_SCIC3_TXINV:      equ    4                                         ; Transmit Data Inversion
B_SCIC3_TXDIR:      equ    5                                         ; TxD Pin Direction in Single-Wire Mode
B_SCIC3_T8:         equ    6                                         ; Ninth Data Bit for Transmitter
B_SCIC3_R8:         equ    7                                         ; Ninth Data Bit for Receiver
; bit position masks
mB_SCIC3_PEIE:      equ    %00000001
mB_SCIC3_FEIE:      equ    %00000010
mB_SCIC3_NEIE:      equ    %00000100
mB_SCIC3_ORIE:      equ    %00001000
mB_SCIC3_TXINV:     equ    %00010000
mB_SCIC3_TXDIR:     equ    %00100000
mB_SCIC3_T8:        equ    %01000000
mB_SCIC3_R8:        equ    %10000000


;*** B_SCID - SCI Data Register; 0x00000247 ***
B_SCID:             equ    $00000247                                ;*** B_SCID - SCI Data Register; 0x00000247 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SCID_R0_T0:       equ    0                                         ; Receive/Transmit Data Bit 0
B_SCID_R1_T1:       equ    1                                         ; Receive/Transmit Data Bit 1
B_SCID_R2_T2:       equ    2                                         ; Receive/Transmit Data Bit 2
B_SCID_R3_T3:       equ    3                                         ; Receive/Transmit Data Bit 3
B_SCID_R4_T4:       equ    4                                         ; Receive/Transmit Data Bit 4
B_SCID_R5_T5:       equ    5                                         ; Receive/Transmit Data Bit 5
B_SCID_R6_T6:       equ    6                                         ; Receive/Transmit Data Bit 6
B_SCID_R7_T7:       equ    7                                         ; Receive/Transmit Data Bit 7
; bit position masks
mB_SCID_R0_T0:      equ    %00000001
mB_SCID_R1_T1:      equ    %00000010
mB_SCID_R2_T2:      equ    %00000100
mB_SCID_R3_T3:      equ    %00001000
mB_SCID_R4_T4:      equ    %00010000
mB_SCID_R5_T5:      equ    %00100000
mB_SCID_R6_T6:      equ    %01000000
mB_SCID_R7_T7:      equ    %10000000


;*** B_PWMCTL - PWM Control Register; 0x00000260 ***
B_PWMCTL:           equ    $00000260                                ;*** B_PWMCTL - PWM Control Register; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMCTL_PWME0:     equ    0                                         ; Pulse Width Channel 0 Enable
B_PWMCTL_PWME1:     equ    1                                         ; Pulse Width Channel 1 Enable
B_PWMCTL_PPOL0:     equ    2                                         ; Pulse Width Channel 0 Polarity
B_PWMCTL_PPOL1:     equ    3                                         ; Pulse Width Channel 1 Polarity
B_PWMCTL_PCLK0:     equ    4                                         ; Pulse Width Channel 0 Clock Select
B_PWMCTL_PCLK1:     equ    5                                         ; Pulse Width Channel 1 Clock Select
B_PWMCTL_CAE0:      equ    6                                         ; Center Aligned Output Modes on Channel 0
B_PWMCTL_CAE1:      equ    7                                         ; Center Aligned Output Modes on Channel 1
; bit position masks
mB_PWMCTL_PWME0:    equ    %00000001
mB_PWMCTL_PWME1:    equ    %00000010
mB_PWMCTL_PPOL0:    equ    %00000100
mB_PWMCTL_PPOL1:    equ    %00001000
mB_PWMCTL_PCLK0:    equ    %00010000
mB_PWMCTL_PCLK1:    equ    %00100000
mB_PWMCTL_CAE0:     equ    %01000000
mB_PWMCTL_CAE1:     equ    %10000000


;*** B_PWMPRCLK - PWM Prescale Clock Select Register; 0x00000261 ***
B_PWMPRCLK:         equ    $00000261                                ;*** B_PWMPRCLK - PWM Prescale Clock Select Register; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMPRCLK_PCKA0:   equ    0                                         ; Prescaler Select for Clock A Bit 0
B_PWMPRCLK_PCKA1:   equ    1                                         ; Prescaler Select for Clock A Bit 1
B_PWMPRCLK_PCKA2:   equ    2                                         ; Prescaler Select for Clock A Bit 2
B_PWMPRCLK_PCKB0:   equ    4                                         ; Prescaler Select for Clock B Bit 0
B_PWMPRCLK_PCKB1:   equ    5                                         ; Prescaler Select for Clock B Bit 1
B_PWMPRCLK_PCKB2:   equ    6                                         ; Prescaler Select for Clock B Bit 2
; bit position masks
mB_PWMPRCLK_PCKA0:  equ    %00000001
mB_PWMPRCLK_PCKA1:  equ    %00000010
mB_PWMPRCLK_PCKA2:  equ    %00000100
mB_PWMPRCLK_PCKB0:  equ    %00010000
mB_PWMPRCLK_PCKB1:  equ    %00100000
mB_PWMPRCLK_PCKB2:  equ    %01000000


;*** B_PWMSCLA - PWM Scale A Register; 0x00000262 ***
B_PWMSCLA:          equ    $00000262                                ;*** B_PWMSCLA - PWM Scale A Register; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMSCLA_BIT0:     equ    0                                         ; PWM Scale A Bit 0
B_PWMSCLA_BIT1:     equ    1                                         ; PWM Scale A Bit 1
B_PWMSCLA_BIT2:     equ    2                                         ; PWM Scale A Bit 2
B_PWMSCLA_BIT3:     equ    3                                         ; PWM Scale A Bit 3
B_PWMSCLA_BIT4:     equ    4                                         ; PWM Scale A Bit 4
B_PWMSCLA_BIT5:     equ    5                                         ; PWM Scale A Bit 5
B_PWMSCLA_BIT6:     equ    6                                         ; PWM Scale A Bit 6
B_PWMSCLA_BIT7:     equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mB_PWMSCLA_BIT0:    equ    %00000001
mB_PWMSCLA_BIT1:    equ    %00000010
mB_PWMSCLA_BIT2:    equ    %00000100
mB_PWMSCLA_BIT3:    equ    %00001000
mB_PWMSCLA_BIT4:    equ    %00010000
mB_PWMSCLA_BIT5:    equ    %00100000
mB_PWMSCLA_BIT6:    equ    %01000000
mB_PWMSCLA_BIT7:    equ    %10000000


;*** B_PWMSCLB - PWM Scale B Register; 0x00000263 ***
B_PWMSCLB:          equ    $00000263                                ;*** B_PWMSCLB - PWM Scale B Register; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMSCLB_BIT0:     equ    0                                         ; PWM Scale B Bit 0
B_PWMSCLB_BIT1:     equ    1                                         ; PWM Scale B Bit 1
B_PWMSCLB_BIT2:     equ    2                                         ; PWM Scale B Bit 2
B_PWMSCLB_BIT3:     equ    3                                         ; PWM Scale B Bit 3
B_PWMSCLB_BIT4:     equ    4                                         ; PWM Scale B Bit 4
B_PWMSCLB_BIT5:     equ    5                                         ; PWM Scale B Bit 5
B_PWMSCLB_BIT6:     equ    6                                         ; PWM Scale B Bit 6
B_PWMSCLB_BIT7:     equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mB_PWMSCLB_BIT0:    equ    %00000001
mB_PWMSCLB_BIT1:    equ    %00000010
mB_PWMSCLB_BIT2:    equ    %00000100
mB_PWMSCLB_BIT3:    equ    %00001000
mB_PWMSCLB_BIT4:    equ    %00010000
mB_PWMSCLB_BIT5:    equ    %00100000
mB_PWMSCLB_BIT6:    equ    %01000000
mB_PWMSCLB_BIT7:    equ    %10000000


;*** B_PWMCNT0 - PWM Channel Counter 0 Register; 0x00000264 ***
B_PWMCNT0:          equ    $00000264                                ;*** B_PWMCNT0 - PWM Channel Counter 0 Register; 0x00000264 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMCNT0_PWMCNT00: equ    0                                         ; PWM Channel Counter Bits, bit 0
B_PWMCNT0_PWMCNT01: equ    1                                         ; PWM Channel Counter Bits, bit 1
B_PWMCNT0_PWMCNT02: equ    2                                         ; PWM Channel Counter Bits, bit 2
B_PWMCNT0_PWMCNT03: equ    3                                         ; PWM Channel Counter Bits, bit 3
B_PWMCNT0_PWMCNT04: equ    4                                         ; PWM Channel Counter Bits, bit 4
B_PWMCNT0_PWMCNT05: equ    5                                         ; PWM Channel Counter Bits, bit 5
B_PWMCNT0_PWMCNT06: equ    6                                         ; PWM Channel Counter Bits, bit 6
B_PWMCNT0_PWMCNT07: equ    7                                         ; PWM Channel Counter Bits, bit 7
; bit position masks
mB_PWMCNT0_PWMCNT00: equ    %00000001
mB_PWMCNT0_PWMCNT01: equ    %00000010
mB_PWMCNT0_PWMCNT02: equ    %00000100
mB_PWMCNT0_PWMCNT03: equ    %00001000
mB_PWMCNT0_PWMCNT04: equ    %00010000
mB_PWMCNT0_PWMCNT05: equ    %00100000
mB_PWMCNT0_PWMCNT06: equ    %01000000
mB_PWMCNT0_PWMCNT07: equ    %10000000


;*** B_PWMCNT1 - PWM Channel Counter 1 Register; 0x00000265 ***
B_PWMCNT1:          equ    $00000265                                ;*** B_PWMCNT1 - PWM Channel Counter 1 Register; 0x00000265 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMCNT1_PWMCNT10: equ    0                                         ; PWM Channel Counter Bits, bit 0
B_PWMCNT1_PWMCNT11: equ    1                                         ; PWM Channel Counter Bits, bit 1
B_PWMCNT1_PWMCNT12: equ    2                                         ; PWM Channel Counter Bits, bit 2
B_PWMCNT1_PWMCNT13: equ    3                                         ; PWM Channel Counter Bits, bit 3
B_PWMCNT1_PWMCNT14: equ    4                                         ; PWM Channel Counter Bits, bit 4
B_PWMCNT1_PWMCNT15: equ    5                                         ; PWM Channel Counter Bits, bit 5
B_PWMCNT1_PWMCNT16: equ    6                                         ; PWM Channel Counter Bits, bit 6
B_PWMCNT1_PWMCNT17: equ    7                                         ; PWM Channel Counter Bits, bit 7
; bit position masks
mB_PWMCNT1_PWMCNT10: equ    %00000001
mB_PWMCNT1_PWMCNT11: equ    %00000010
mB_PWMCNT1_PWMCNT12: equ    %00000100
mB_PWMCNT1_PWMCNT13: equ    %00001000
mB_PWMCNT1_PWMCNT14: equ    %00010000
mB_PWMCNT1_PWMCNT15: equ    %00100000
mB_PWMCNT1_PWMCNT16: equ    %01000000
mB_PWMCNT1_PWMCNT17: equ    %10000000


;*** B_PWMPER0 - PWM Channel Period 0 Register; 0x00000266 ***
B_PWMPER0:          equ    $00000266                                ;*** B_PWMPER0 - PWM Channel Period 0 Register; 0x00000266 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMPER0_PWMPER00: equ    0                                         ; PWM Channel Period Bits, bit 0
B_PWMPER0_PWMPER01: equ    1                                         ; PWM Channel Period Bits, bit 1
B_PWMPER0_PWMPER02: equ    2                                         ; PWM Channel Period Bits, bit 2
B_PWMPER0_PWMPER03: equ    3                                         ; PWM Channel Period Bits, bit 3
B_PWMPER0_PWMPER04: equ    4                                         ; PWM Channel Period Bits, bit 4
B_PWMPER0_PWMPER05: equ    5                                         ; PWM Channel Period Bits, bit 5
B_PWMPER0_PWMPER06: equ    6                                         ; PWM Channel Period Bits, bit 6
B_PWMPER0_PWMPER07: equ    7                                         ; PWM Channel Period Bits, bit 7
; bit position masks
mB_PWMPER0_PWMPER00: equ    %00000001
mB_PWMPER0_PWMPER01: equ    %00000010
mB_PWMPER0_PWMPER02: equ    %00000100
mB_PWMPER0_PWMPER03: equ    %00001000
mB_PWMPER0_PWMPER04: equ    %00010000
mB_PWMPER0_PWMPER05: equ    %00100000
mB_PWMPER0_PWMPER06: equ    %01000000
mB_PWMPER0_PWMPER07: equ    %10000000


;*** B_PWMPER1 - PWM Channel Period 1 Register; 0x00000267 ***
B_PWMPER1:          equ    $00000267                                ;*** B_PWMPER1 - PWM Channel Period 1 Register; 0x00000267 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMPER1_PWMPER10: equ    0                                         ; PWM Channel Period Bits, bit 0
B_PWMPER1_PWMPER11: equ    1                                         ; PWM Channel Period Bits, bit 1
B_PWMPER1_PWMPER12: equ    2                                         ; PWM Channel Period Bits, bit 2
B_PWMPER1_PWMPER13: equ    3                                         ; PWM Channel Period Bits, bit 3
B_PWMPER1_PWMPER14: equ    4                                         ; PWM Channel Period Bits, bit 4
B_PWMPER1_PWMPER15: equ    5                                         ; PWM Channel Period Bits, bit 5
B_PWMPER1_PWMPER16: equ    6                                         ; PWM Channel Period Bits, bit 6
B_PWMPER1_PWMPER17: equ    7                                         ; PWM Channel Period Bits, bit 7
; bit position masks
mB_PWMPER1_PWMPER10: equ    %00000001
mB_PWMPER1_PWMPER11: equ    %00000010
mB_PWMPER1_PWMPER12: equ    %00000100
mB_PWMPER1_PWMPER13: equ    %00001000
mB_PWMPER1_PWMPER14: equ    %00010000
mB_PWMPER1_PWMPER15: equ    %00100000
mB_PWMPER1_PWMPER16: equ    %01000000
mB_PWMPER1_PWMPER17: equ    %10000000


;*** B_PWMDTY0 - PWM Channel Duty 0 Register; 0x00000268 ***
B_PWMDTY0:          equ    $00000268                                ;*** B_PWMDTY0 - PWM Channel Duty 0 Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMDTY0_PWMDTY00: equ    0                                         ; PWM Channel Duty Bits, bit 0
B_PWMDTY0_PWMDTY01: equ    1                                         ; PWM Channel Duty Bits, bit 1
B_PWMDTY0_PWMDTY02: equ    2                                         ; PWM Channel Duty Bits, bit 2
B_PWMDTY0_PWMDTY03: equ    3                                         ; PWM Channel Duty Bits, bit 3
B_PWMDTY0_PWMDTY04: equ    4                                         ; PWM Channel Duty Bits, bit 4
B_PWMDTY0_PWMDTY05: equ    5                                         ; PWM Channel Duty Bits, bit 5
B_PWMDTY0_PWMDTY06: equ    6                                         ; PWM Channel Duty Bits, bit 6
B_PWMDTY0_PWMDTY07: equ    7                                         ; PWM Channel Duty Bits, bit 7
; bit position masks
mB_PWMDTY0_PWMDTY00: equ    %00000001
mB_PWMDTY0_PWMDTY01: equ    %00000010
mB_PWMDTY0_PWMDTY02: equ    %00000100
mB_PWMDTY0_PWMDTY03: equ    %00001000
mB_PWMDTY0_PWMDTY04: equ    %00010000
mB_PWMDTY0_PWMDTY05: equ    %00100000
mB_PWMDTY0_PWMDTY06: equ    %01000000
mB_PWMDTY0_PWMDTY07: equ    %10000000


;*** B_PWMDTY1 - PWM Channel Duty 1 Register; 0x00000269 ***
B_PWMDTY1:          equ    $00000269                                ;*** B_PWMDTY1 - PWM Channel Duty 1 Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_PWMDTY1_PWMDTY10: equ    0                                         ; PWM Channel Duty Bits, bit 0
B_PWMDTY1_PWMDTY11: equ    1                                         ; PWM Channel Duty Bits, bit 1
B_PWMDTY1_PWMDTY12: equ    2                                         ; PWM Channel Duty Bits, bit 2
B_PWMDTY1_PWMDTY13: equ    3                                         ; PWM Channel Duty Bits, bit 3
B_PWMDTY1_PWMDTY14: equ    4                                         ; PWM Channel Duty Bits, bit 4
B_PWMDTY1_PWMDTY15: equ    5                                         ; PWM Channel Duty Bits, bit 5
B_PWMDTY1_PWMDTY16: equ    6                                         ; PWM Channel Duty Bits, bit 6
B_PWMDTY1_PWMDTY17: equ    7                                         ; PWM Channel Duty Bits, bit 7
; bit position masks
mB_PWMDTY1_PWMDTY10: equ    %00000001
mB_PWMDTY1_PWMDTY11: equ    %00000010
mB_PWMDTY1_PWMDTY12: equ    %00000100
mB_PWMDTY1_PWMDTY13: equ    %00001000
mB_PWMDTY1_PWMDTY14: equ    %00010000
mB_PWMDTY1_PWMDTY15: equ    %00100000
mB_PWMDTY1_PWMDTY16: equ    %01000000
mB_PWMDTY1_PWMDTY17: equ    %10000000


;*** B_ACR - ADC Config Register; 0x00000280 ***
B_ACR:              equ    $00000280                                ;*** B_ACR - ADC Config Register; 0x00000280 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACR_PS:           equ    0                                         ; ADC Clock Prescaler Select 0
B_ACR_ADCRST:       equ    4                                         ; Analog Digital Converter RESET
B_ACR_OCE:          equ    5                                         ; Offset Compensation Enable
B_ACR_CCE:          equ    6                                         ; Continuous Conversion Enable
B_ACR_SCIE:         equ    7                                         ; Sequence Complete Interrupt Enable
; bit position masks
mB_ACR_PS:          equ    %00000111
mB_ACR_ADCRST:      equ    %00010000
mB_ACR_OCE:         equ    %00100000
mB_ACR_CCE:         equ    %01000000
mB_ACR_SCIE:        equ    %10000000


;*** B_ASR - ADC Status Register; 0x00000281 ***
B_ASR:              equ    $00000281                                ;*** B_ASR - ADC Status Register; 0x00000281 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ASR_CCNT:         equ    0                                         ; Conversion Counter Status 0
B_ASR_2p5CLF:       equ    6                                         ; ADC Reference Voltage Current Limitation Flag
B_ASR_SCF:          equ    7                                         ; Sequence Complete Flag
; bit position masks
mB_ASR_CCNT:        equ    %00001111
mB_ASR_2p5CLF:      equ    %01000000
mB_ASR_SCF:         equ    %10000000


;*** B_ACCR - ADC Conversion Control Register; 0x00000282 ***
B_ACCR:             equ    $00000282                                ;*** B_ACCR - ADC Conversion Control Register; 0x00000282 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACCR_CH0:         equ    0                                         ; Channel Select 0
B_ACCR_CH1:         equ    1                                         ; Channel Select 1
B_ACCR_CH2:         equ    2                                         ; Channel Select 2
B_ACCR_CH3:         equ    3                                         ; Channel Select 3
B_ACCR_CH4:         equ    4                                         ; Channel Select 4
B_ACCR_CH5:         equ    5                                         ; Channel Select 5
B_ACCR_CH6:         equ    6                                         ; Channel Select 6
B_ACCR_CH7:         equ    7                                         ; Channel Select 7
B_ACCR_CH8:         equ    8                                         ; Channel Select 8
B_ACCR_CH9:         equ    9                                         ; Channel Select 9
B_ACCR_CH10:        equ    10                                        ; Channel Select 10
B_ACCR_CH11:        equ    11                                        ; Channel Select 11
B_ACCR_CH12:        equ    12                                        ; Channel Select 12
B_ACCR_CH14:        equ    14                                        ; Channel Select 14
B_ACCR_CH15:        equ    15                                        ; Channel Select 15
; bit position masks
mB_ACCR_CH0:        equ    %00000001
mB_ACCR_CH1:        equ    %00000010
mB_ACCR_CH2:        equ    %00000100
mB_ACCR_CH3:        equ    %00001000
mB_ACCR_CH4:        equ    %00010000
mB_ACCR_CH5:        equ    %00100000
mB_ACCR_CH6:        equ    %01000000
mB_ACCR_CH7:        equ    %10000000
mB_ACCR_CH8:        equ    %100000000
mB_ACCR_CH9:        equ    %1000000000
mB_ACCR_CH10:       equ    %10000000000
mB_ACCR_CH11:       equ    %100000000000
mB_ACCR_CH12:       equ    %1000000000000
mB_ACCR_CH14:       equ    %100000000000000
mB_ACCR_CH15:       equ    %1000000000000000


;*** B_ACCRhi - ADC Conversion Control Register High; 0x00000282 ***
B_ACCRhi:           equ    $00000282                                ;*** B_ACCRhi - ADC Conversion Control Register High; 0x00000282 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACCRhi_CH8:       equ    0                                         ; Channel Select 8
B_ACCRhi_CH9:       equ    1                                         ; Channel Select 9
B_ACCRhi_CH10:      equ    2                                         ; Channel Select 10
B_ACCRhi_CH11:      equ    3                                         ; Channel Select 11
B_ACCRhi_CH12:      equ    4                                         ; Channel Select 12
B_ACCRhi_CH14:      equ    6                                         ; Channel Select 14
B_ACCRhi_CH15:      equ    7                                         ; Channel Select 15
; bit position masks
mB_ACCRhi_CH8:      equ    %00000001
mB_ACCRhi_CH9:      equ    %00000010
mB_ACCRhi_CH10:     equ    %00000100
mB_ACCRhi_CH11:     equ    %00001000
mB_ACCRhi_CH12:     equ    %00010000
mB_ACCRhi_CH14:     equ    %01000000
mB_ACCRhi_CH15:     equ    %10000000


;*** B_ACCRlo - ADC Conversion Control Register Low; 0x00000283 ***
B_ACCRlo:           equ    $00000283                                ;*** B_ACCRlo - ADC Conversion Control Register Low; 0x00000283 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACCRlo_CH0:       equ    0                                         ; Channel Select 0
B_ACCRlo_CH1:       equ    1                                         ; Channel Select 1
B_ACCRlo_CH2:       equ    2                                         ; Channel Select 2
B_ACCRlo_CH3:       equ    3                                         ; Channel Select 3
B_ACCRlo_CH4:       equ    4                                         ; Channel Select 4
B_ACCRlo_CH5:       equ    5                                         ; Channel Select 5
B_ACCRlo_CH6:       equ    6                                         ; Channel Select 6
B_ACCRlo_CH7:       equ    7                                         ; Channel Select 7
; bit position masks
mB_ACCRlo_CH0:      equ    %00000001
mB_ACCRlo_CH1:      equ    %00000010
mB_ACCRlo_CH2:      equ    %00000100
mB_ACCRlo_CH3:      equ    %00001000
mB_ACCRlo_CH4:      equ    %00010000
mB_ACCRlo_CH5:      equ    %00100000
mB_ACCRlo_CH6:      equ    %01000000
mB_ACCRlo_CH7:      equ    %10000000


;*** B_ACCSR - ADC Conversion Complete Status Register; 0x00000284 ***
B_ACCSR:            equ    $00000284                                ;*** B_ACCSR - ADC Conversion Complete Status Register; 0x00000284 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACCSR_CC0:        equ    0                                         ; Conversion Complete Flag 0
B_ACCSR_CC1:        equ    1                                         ; Conversion Complete Flag 1
B_ACCSR_CC2:        equ    2                                         ; Conversion Complete Flag 2
B_ACCSR_CC3:        equ    3                                         ; Conversion Complete Flag 3
B_ACCSR_CC4:        equ    4                                         ; Conversion Complete Flag 4
B_ACCSR_CC5:        equ    5                                         ; Conversion Complete Flag 5
B_ACCSR_CC6:        equ    6                                         ; Conversion Complete Flag 6
B_ACCSR_CC7:        equ    7                                         ; Conversion Complete Flag 7
B_ACCSR_CC8:        equ    8                                         ; Conversion Complete Flag 8
B_ACCSR_CC9:        equ    9                                         ; Conversion Complete Flag 9
B_ACCSR_CC10:       equ    10                                        ; Conversion Complete Flag 10
B_ACCSR_CC11:       equ    11                                        ; Conversion Complete Flag 11
B_ACCSR_CC12:       equ    12                                        ; Conversion Complete Flag 12
B_ACCSR_CC14:       equ    14                                        ; Conversion Complete Flag 14
B_ACCSR_CC15:       equ    15                                        ; Conversion Complete Flag 15
; bit position masks
mB_ACCSR_CC0:       equ    %00000001
mB_ACCSR_CC1:       equ    %00000010
mB_ACCSR_CC2:       equ    %00000100
mB_ACCSR_CC3:       equ    %00001000
mB_ACCSR_CC4:       equ    %00010000
mB_ACCSR_CC5:       equ    %00100000
mB_ACCSR_CC6:       equ    %01000000
mB_ACCSR_CC7:       equ    %10000000
mB_ACCSR_CC8:       equ    %100000000
mB_ACCSR_CC9:       equ    %1000000000
mB_ACCSR_CC10:      equ    %10000000000
mB_ACCSR_CC11:      equ    %100000000000
mB_ACCSR_CC12:      equ    %1000000000000
mB_ACCSR_CC14:      equ    %100000000000000
mB_ACCSR_CC15:      equ    %1000000000000000


;*** B_ACCSRhi - ADC Conversion Complete Status Register High; 0x00000284 ***
B_ACCSRhi:          equ    $00000284                                ;*** B_ACCSRhi - ADC Conversion Complete Status Register High; 0x00000284 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACCSRhi_CC8:      equ    0                                         ; Conversion Complete Flag 8
B_ACCSRhi_CC9:      equ    1                                         ; Conversion Complete Flag 9
B_ACCSRhi_CC10:     equ    2                                         ; Conversion Complete Flag 10
B_ACCSRhi_CC11:     equ    3                                         ; Conversion Complete Flag 11
B_ACCSRhi_CC12:     equ    4                                         ; Conversion Complete Flag 12
B_ACCSRhi_CC14:     equ    6                                         ; Conversion Complete Flag 14
B_ACCSRhi_CC15:     equ    7                                         ; Conversion Complete Flag 15
; bit position masks
mB_ACCSRhi_CC8:     equ    %00000001
mB_ACCSRhi_CC9:     equ    %00000010
mB_ACCSRhi_CC10:    equ    %00000100
mB_ACCSRhi_CC11:    equ    %00001000
mB_ACCSRhi_CC12:    equ    %00010000
mB_ACCSRhi_CC14:    equ    %01000000
mB_ACCSRhi_CC15:    equ    %10000000


;*** B_ACCSRlo - ADC Conversion Complete Status Register Low; 0x00000285 ***
B_ACCSRlo:          equ    $00000285                                ;*** B_ACCSRlo - ADC Conversion Complete Status Register Low; 0x00000285 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ACCSRlo_CC0:      equ    0                                         ; Conversion Complete Flag 0
B_ACCSRlo_CC1:      equ    1                                         ; Conversion Complete Flag 1
B_ACCSRlo_CC2:      equ    2                                         ; Conversion Complete Flag 2
B_ACCSRlo_CC3:      equ    3                                         ; Conversion Complete Flag 3
B_ACCSRlo_CC4:      equ    4                                         ; Conversion Complete Flag 4
B_ACCSRlo_CC5:      equ    5                                         ; Conversion Complete Flag 5
B_ACCSRlo_CC6:      equ    6                                         ; Conversion Complete Flag 6
B_ACCSRlo_CC7:      equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mB_ACCSRlo_CC0:     equ    %00000001
mB_ACCSRlo_CC1:     equ    %00000010
mB_ACCSRlo_CC2:     equ    %00000100
mB_ACCSRlo_CC3:     equ    %00001000
mB_ACCSRlo_CC4:     equ    %00010000
mB_ACCSRlo_CC5:     equ    %00100000
mB_ACCSRlo_CC6:     equ    %01000000
mB_ACCSRlo_CC7:     equ    %10000000


;*** B_ADR0 - ADC Data Result Register 0; 0x00000286 ***
B_ADR0:             equ    $00000286                                ;*** B_ADR0 - ADC Data Result Register 0; 0x00000286 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR0_ADR0:        equ    6                                         ; ADC Channel 0 Result Bit 0
; bit position masks
mB_ADR0_ADR0:       equ    %1111111111000000


;*** B_ADR0hi - ADC Data Result Register 0 High; 0x00000286 ***
B_ADR0hi:           equ    $00000286                                ;*** B_ADR0hi - ADC Data Result Register 0 High; 0x00000286 ***


;*** B_ADR0lo - ADC Data Result Register 0 Low; 0x00000287 ***
B_ADR0lo:           equ    $00000287                                ;*** B_ADR0lo - ADC Data Result Register 0 Low; 0x00000287 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR0lo_ADR0:      equ    6                                         ; ADC Channel 0 Result Bit 0
; bit position masks
mB_ADR0lo_ADR0:     equ    %11000000


;*** B_ADR1 - ADC Data Result Register 1; 0x00000288 ***
B_ADR1:             equ    $00000288                                ;*** B_ADR1 - ADC Data Result Register 1; 0x00000288 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR1_ADR1:        equ    6                                         ; ADC Channel 1 Result Bit 0
; bit position masks
mB_ADR1_ADR1:       equ    %1111111111000000


;*** B_ADR1hi - ADC Data Result Register 1 High; 0x00000288 ***
B_ADR1hi:           equ    $00000288                                ;*** B_ADR1hi - ADC Data Result Register 1 High; 0x00000288 ***


;*** B_ADR1lo - ADC Data Result Register 1 Low; 0x00000289 ***
B_ADR1lo:           equ    $00000289                                ;*** B_ADR1lo - ADC Data Result Register 1 Low; 0x00000289 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR1lo_ADR1:      equ    6                                         ; ADC Channel 1 Result Bit 0
; bit position masks
mB_ADR1lo_ADR1:     equ    %11000000


;*** B_ADR2 - ADC Data Result Register 2; 0x0000028A ***
B_ADR2:             equ    $0000028A                                ;*** B_ADR2 - ADC Data Result Register 2; 0x0000028A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR2_ADR2:        equ    6                                         ; ADC Channel 2 Result Bit 0
; bit position masks
mB_ADR2_ADR2:       equ    %1111111111000000


;*** B_ADR2hi - ADC Data Result Register 2 High; 0x0000028A ***
B_ADR2hi:           equ    $0000028A                                ;*** B_ADR2hi - ADC Data Result Register 2 High; 0x0000028A ***


;*** B_ADR2lo - ADC Data Result Register 2 Low; 0x0000028B ***
B_ADR2lo:           equ    $0000028B                                ;*** B_ADR2lo - ADC Data Result Register 2 Low; 0x0000028B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR2lo_ADR2:      equ    6                                         ; ADC Channel 2 Result Bit 0
; bit position masks
mB_ADR2lo_ADR2:     equ    %11000000


;*** B_ADR3 - ADC Data Result Register 3; 0x0000028C ***
B_ADR3:             equ    $0000028C                                ;*** B_ADR3 - ADC Data Result Register 3; 0x0000028C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR3_ADR3:        equ    6                                         ; ADC Channel 3 Result Bit 0
; bit position masks
mB_ADR3_ADR3:       equ    %1111111111000000


;*** B_ADR3hi - ADC Data Result Register 3 High; 0x0000028C ***
B_ADR3hi:           equ    $0000028C                                ;*** B_ADR3hi - ADC Data Result Register 3 High; 0x0000028C ***


;*** B_ADR3lo - ADC Data Result Register 3 Low; 0x0000028D ***
B_ADR3lo:           equ    $0000028D                                ;*** B_ADR3lo - ADC Data Result Register 3 Low; 0x0000028D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR3lo_ADR3:      equ    6                                         ; ADC Channel 3 Result Bit 0
; bit position masks
mB_ADR3lo_ADR3:     equ    %11000000


;*** B_ADR4 - ADC Data Result Register 4; 0x0000028E ***
B_ADR4:             equ    $0000028E                                ;*** B_ADR4 - ADC Data Result Register 4; 0x0000028E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR4_ADR4:        equ    6                                         ; ADC Channel 4 Result Bit 0
; bit position masks
mB_ADR4_ADR4:       equ    %1111111111000000


;*** B_ADR4hi - ADC Data Result Register 4 High; 0x0000028E ***
B_ADR4hi:           equ    $0000028E                                ;*** B_ADR4hi - ADC Data Result Register 4 High; 0x0000028E ***


;*** B_ADR4lo - ADC Data Result Register 4 Low; 0x0000028F ***
B_ADR4lo:           equ    $0000028F                                ;*** B_ADR4lo - ADC Data Result Register 4 Low; 0x0000028F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR4lo_ADR4:      equ    6                                         ; ADC Channel 4 Result Bit 0
; bit position masks
mB_ADR4lo_ADR4:     equ    %11000000


;*** B_ADR5 - ADC Data Result Register 5; 0x00000290 ***
B_ADR5:             equ    $00000290                                ;*** B_ADR5 - ADC Data Result Register 5; 0x00000290 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR5_ADR5:        equ    6                                         ; ADC Channel 5 Result Bit 0
; bit position masks
mB_ADR5_ADR5:       equ    %1111111111000000


;*** B_ADR5hi - ADC Data Result Register 5 High; 0x00000290 ***
B_ADR5hi:           equ    $00000290                                ;*** B_ADR5hi - ADC Data Result Register 5 High; 0x00000290 ***


;*** B_ADR5lo - ADC Data Result Register 5 Low; 0x00000291 ***
B_ADR5lo:           equ    $00000291                                ;*** B_ADR5lo - ADC Data Result Register 5 Low; 0x00000291 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR5lo_ADR5:      equ    6                                         ; ADC Channel 5 Result Bit 0
; bit position masks
mB_ADR5lo_ADR5:     equ    %11000000


;*** B_ADR6 - ADC Data Result Register 6; 0x00000292 ***
B_ADR6:             equ    $00000292                                ;*** B_ADR6 - ADC Data Result Register 6; 0x00000292 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR6_ADR6:        equ    6                                         ; ADC Channel 6 Result Bit 0
; bit position masks
mB_ADR6_ADR6:       equ    %1111111111000000


;*** B_ADR6hi - ADC Data Result Register 6 High; 0x00000292 ***
B_ADR6hi:           equ    $00000292                                ;*** B_ADR6hi - ADC Data Result Register 6 High; 0x00000292 ***


;*** B_ADR6lo - ADC Data Result Register 6 Low; 0x00000293 ***
B_ADR6lo:           equ    $00000293                                ;*** B_ADR6lo - ADC Data Result Register 6 Low; 0x00000293 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR6lo_ADR6:      equ    6                                         ; ADC Channel 6 Result Bit 0
; bit position masks
mB_ADR6lo_ADR6:     equ    %11000000


;*** B_ADR7 - ADC Data Result Register 7; 0x00000294 ***
B_ADR7:             equ    $00000294                                ;*** B_ADR7 - ADC Data Result Register 7; 0x00000294 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR7_ADR7:        equ    6                                         ; ADC Channel 7 Result Bit 0
; bit position masks
mB_ADR7_ADR7:       equ    %1111111111000000


;*** B_ADR7hi - ADC Data Result Register 7 High; 0x00000294 ***
B_ADR7hi:           equ    $00000294                                ;*** B_ADR7hi - ADC Data Result Register 7 High; 0x00000294 ***


;*** B_ADR7lo - ADC Data Result Register 7 Low; 0x00000295 ***
B_ADR7lo:           equ    $00000295                                ;*** B_ADR7lo - ADC Data Result Register 7 Low; 0x00000295 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR7lo_ADR7:      equ    6                                         ; ADC Channel 7 Result Bit 0
; bit position masks
mB_ADR7lo_ADR7:     equ    %11000000


;*** B_ADR8 - ADC Data Result Register 8; 0x00000296 ***
B_ADR8:             equ    $00000296                                ;*** B_ADR8 - ADC Data Result Register 8; 0x00000296 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR8_ADR8:        equ    6                                         ; ADC Channel 8 Result Bit 0
; bit position masks
mB_ADR8_ADR8:       equ    %1111111111000000


;*** B_ADR8hi - ADC Data Result Register 8 High; 0x00000296 ***
B_ADR8hi:           equ    $00000296                                ;*** B_ADR8hi - ADC Data Result Register 8 High; 0x00000296 ***


;*** B_ADR8lo - ADC Data Result Register 8 Low; 0x00000297 ***
B_ADR8lo:           equ    $00000297                                ;*** B_ADR8lo - ADC Data Result Register 8 Low; 0x00000297 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR8lo_ADR8:      equ    6                                         ; ADC Channel 8 Result Bit 0
; bit position masks
mB_ADR8lo_ADR8:     equ    %11000000


;*** B_ADR9 - ADC Data Result Register 9; 0x00000298 ***
B_ADR9:             equ    $00000298                                ;*** B_ADR9 - ADC Data Result Register 9; 0x00000298 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR9_ADR9:        equ    6                                         ; ADC Channel 9 Result Bit 0
; bit position masks
mB_ADR9_ADR9:       equ    %1111111111000000


;*** B_ADR9hi - ADC Data Result Register 9 High; 0x00000298 ***
B_ADR9hi:           equ    $00000298                                ;*** B_ADR9hi - ADC Data Result Register 9 High; 0x00000298 ***


;*** B_ADR9lo - ADC Data Result Register 9 Low; 0x00000299 ***
B_ADR9lo:           equ    $00000299                                ;*** B_ADR9lo - ADC Data Result Register 9 Low; 0x00000299 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR9lo_ADR9:      equ    6                                         ; ADC Channel 9 Result Bit 0
; bit position masks
mB_ADR9lo_ADR9:     equ    %11000000


;*** B_ADR10 - ADC Data Result Register 10; 0x0000029A ***
B_ADR10:            equ    $0000029A                                ;*** B_ADR10 - ADC Data Result Register 10; 0x0000029A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR10_ADR10:      equ    6                                         ; ADC Channel 10 Result Bit 0
; bit position masks
mB_ADR10_ADR10:     equ    %1111111111000000


;*** B_ADR10hi - ADC Data Result Register 10 High; 0x0000029A ***
B_ADR10hi:          equ    $0000029A                                ;*** B_ADR10hi - ADC Data Result Register 10 High; 0x0000029A ***


;*** B_ADR10lo - ADC Data Result Register 10 Low; 0x0000029B ***
B_ADR10lo:          equ    $0000029B                                ;*** B_ADR10lo - ADC Data Result Register 10 Low; 0x0000029B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR10lo_ADR10:    equ    6                                         ; ADC Channel 10 Result Bit 0
; bit position masks
mB_ADR10lo_ADR10:   equ    %11000000


;*** B_ADR11 - ADC Data Result Register 11; 0x0000029C ***
B_ADR11:            equ    $0000029C                                ;*** B_ADR11 - ADC Data Result Register 11; 0x0000029C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR11_ADR11:      equ    6                                         ; ADC Channel 11 Result Bit 0
; bit position masks
mB_ADR11_ADR11:     equ    %1111111111000000


;*** B_ADR11hi - ADC Data Result Register 11 High; 0x0000029C ***
B_ADR11hi:          equ    $0000029C                                ;*** B_ADR11hi - ADC Data Result Register 11 High; 0x0000029C ***


;*** B_ADR11lo - ADC Data Result Register 11 Low; 0x0000029D ***
B_ADR11lo:          equ    $0000029D                                ;*** B_ADR11lo - ADC Data Result Register 11 Low; 0x0000029D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR11lo_ADR11:    equ    6                                         ; ADC Channel 11 Result Bit 0
; bit position masks
mB_ADR11lo_ADR11:   equ    %11000000


;*** B_ADR12 - ADC Data Result Register 12; 0x0000029E ***
B_ADR12:            equ    $0000029E                                ;*** B_ADR12 - ADC Data Result Register 12; 0x0000029E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR12_ADR12:      equ    6                                         ; ADC Channel 12 Result Bit 0
; bit position masks
mB_ADR12_ADR12:     equ    %1111111111000000


;*** B_ADR12hi - ADC Data Result Register 12 High; 0x0000029E ***
B_ADR12hi:          equ    $0000029E                                ;*** B_ADR12hi - ADC Data Result Register 12 High; 0x0000029E ***


;*** B_ADR12lo - ADC Data Result Register 12 Low; 0x0000029F ***
B_ADR12lo:          equ    $0000029F                                ;*** B_ADR12lo - ADC Data Result Register 12 Low; 0x0000029F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR12lo_ADR12:    equ    6                                         ; ADC Channel 12 Result Bit 0
; bit position masks
mB_ADR12lo_ADR12:   equ    %11000000


;*** B_ADR13 - ADC Data Result Register 13; 0x000002A0 ***
B_ADR13:            equ    $000002A0                                ;*** B_ADR13 - ADC Data Result Register 13; 0x000002A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR13_ADR13:      equ    6                                         ; ADC Channel 13 Result Bit 0
; bit position masks
mB_ADR13_ADR13:     equ    %1111111111000000


;*** B_ADR13hi - ADC Data Result Register 13 High; 0x000002A0 ***
B_ADR13hi:          equ    $000002A0                                ;*** B_ADR13hi - ADC Data Result Register 13 High; 0x000002A0 ***


;*** B_ADR13lo - ADC Data Result Register 13 Low; 0x000002A1 ***
B_ADR13lo:          equ    $000002A1                                ;*** B_ADR13lo - ADC Data Result Register 13 Low; 0x000002A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR13lo_ADR13:    equ    6                                         ; ADC Channel 13 Result Bit 0
; bit position masks
mB_ADR13lo_ADR13:   equ    %11000000


;*** B_ADR14 - ADC Data Result Register 14; 0x000002A2 ***
B_ADR14:            equ    $000002A2                                ;*** B_ADR14 - ADC Data Result Register 14; 0x000002A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR14_ADR14:      equ    6                                         ; ADC Channel 14 Result Bit 0
; bit position masks
mB_ADR14_ADR14:     equ    %1111111111000000


;*** B_ADR14hi - ADC Data Result Register 14 High; 0x000002A2 ***
B_ADR14hi:          equ    $000002A2                                ;*** B_ADR14hi - ADC Data Result Register 14 High; 0x000002A2 ***


;*** B_ADR14lo - ADC Data Result Register 14 Low; 0x000002A3 ***
B_ADR14lo:          equ    $000002A3                                ;*** B_ADR14lo - ADC Data Result Register 14 Low; 0x000002A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR14lo_ADR14:    equ    6                                         ; ADC Channel 14 Result Bit 0
; bit position masks
mB_ADR14lo_ADR14:   equ    %11000000


;*** B_ADR15 - ADC Data Result Register 15; 0x000002A4 ***
B_ADR15:            equ    $000002A4                                ;*** B_ADR15 - ADC Data Result Register 15; 0x000002A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR15_ADR15:      equ    6                                         ; ADC Channel 15 Result Bit 0
; bit position masks
mB_ADR15_ADR15:     equ    %1111111111000000


;*** B_ADR15hi - ADC Data Result Register 15 High; 0x000002A4 ***
B_ADR15hi:          equ    $000002A4                                ;*** B_ADR15hi - ADC Data Result Register 15 High; 0x000002A4 ***


;*** B_ADR15lo - ADC Data Result Register 15 Low; 0x000002A5 ***
B_ADR15lo:          equ    $000002A5                                ;*** B_ADR15lo - ADC Data Result Register 15 Low; 0x000002A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_ADR15lo_ADR15:    equ    6                                         ; ADC Channel 15 Result Bit 0
; bit position masks
mB_ADR15lo_ADR15:   equ    %11000000


;*** B_TIOS - Timer Input Capture/Output Compare Select; 0x000002C0 ***
B_TIOS:             equ    $000002C0                                ;*** B_TIOS - Timer Input Capture/Output Compare Select; 0x000002C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TIOS_IOS0:        equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
B_TIOS_IOS1:        equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
B_TIOS_IOS2:        equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
B_TIOS_IOS3:        equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
; bit position masks
mB_TIOS_IOS0:       equ    %00000001
mB_TIOS_IOS1:       equ    %00000010
mB_TIOS_IOS2:       equ    %00000100
mB_TIOS_IOS3:       equ    %00001000


;*** B_CFORC - Timer Compare Force Register; 0x000002C1 ***
B_CFORC:            equ    $000002C1                                ;*** B_CFORC - Timer Compare Force Register; 0x000002C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_CFORC_FOC0:       equ    0                                         ; Force Output Compare Action for Channel 0
B_CFORC_FOC1:       equ    1                                         ; Force Output Compare Action for Channel 1
B_CFORC_FOC2:       equ    2                                         ; Force Output Compare Action for Channel 2
B_CFORC_FOC3:       equ    3                                         ; Force Output Compare Action for Channel 3
; bit position masks
mB_CFORC_FOC0:      equ    %00000001
mB_CFORC_FOC1:      equ    %00000010
mB_CFORC_FOC2:      equ    %00000100
mB_CFORC_FOC3:      equ    %00001000


;*** B_OC3M - Output Compare 3 Mask Register; 0x000002C2 ***
B_OC3M:             equ    $000002C2                                ;*** B_OC3M - Output Compare 3 Mask Register; 0x000002C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_OC3M_OC3M0:       equ    0                                         ; Output Compare 3 Mask Bit 0
B_OC3M_OC3M1:       equ    1                                         ; Output Compare 3 Mask Bit 1
B_OC3M_OC3M2:       equ    2                                         ; Output Compare 3 Mask Bit 2
B_OC3M_OC3M3:       equ    3                                         ; Output Compare 3 Mask Bit 3
; bit position masks
mB_OC3M_OC3M0:      equ    %00000001
mB_OC3M_OC3M1:      equ    %00000010
mB_OC3M_OC3M2:      equ    %00000100
mB_OC3M_OC3M3:      equ    %00001000


;*** B_OC3D - Output Compare 3 Data Register; 0x000002C3 ***
B_OC3D:             equ    $000002C3                                ;*** B_OC3D - Output Compare 3 Data Register; 0x000002C3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_OC3D_OC3D0:       equ    0                                         ; Output Compare 3 Bit 0
B_OC3D_OC3D1:       equ    1                                         ; Output Compare 3 Bit 1
B_OC3D_OC3D2:       equ    2                                         ; Output Compare 3 Bit 2
B_OC3D_OC3D3:       equ    3                                         ; Output Compare 3 Bit 3
; bit position masks
mB_OC3D_OC3D0:      equ    %00000001
mB_OC3D_OC3D1:      equ    %00000010
mB_OC3D_OC3D2:      equ    %00000100
mB_OC3D_OC3D3:      equ    %00001000


;*** B_TCNT - Timer Count Register; 0x000002C4 ***
B_TCNT:             equ    $000002C4                                ;*** B_TCNT - Timer Count Register; 0x000002C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCNT_BIT0:        equ    0                                         ; Timer Count Register Bit 0
B_TCNT_BIT1:        equ    1                                         ; Timer Count Register Bit 1
B_TCNT_BIT2:        equ    2                                         ; Timer Count Register Bit 2
B_TCNT_BIT3:        equ    3                                         ; Timer Count Register Bit 3
B_TCNT_BIT4:        equ    4                                         ; Timer Count Register Bit 4
B_TCNT_BIT5:        equ    5                                         ; Timer Count Register Bit 5
B_TCNT_BIT6:        equ    6                                         ; Timer Count Register Bit 6
B_TCNT_BIT7:        equ    7                                         ; Timer Count Register Bit 7
B_TCNT_BIT8:        equ    8                                         ; Timer Count Register Bit 8
B_TCNT_BIT9:        equ    9                                         ; Timer Count Register Bit 9
B_TCNT_BIT10:       equ    10                                        ; Timer Count Register Bit 10
B_TCNT_BIT11:       equ    11                                        ; Timer Count Register Bit 11
B_TCNT_BIT12:       equ    12                                        ; Timer Count Register Bit 12
B_TCNT_BIT13:       equ    13                                        ; Timer Count Register Bit 13
B_TCNT_BIT14:       equ    14                                        ; Timer Count Register Bit 14
B_TCNT_BIT15:       equ    15                                        ; Timer Count Register Bit 15
; bit position masks
mB_TCNT_BIT0:       equ    %00000001
mB_TCNT_BIT1:       equ    %00000010
mB_TCNT_BIT2:       equ    %00000100
mB_TCNT_BIT3:       equ    %00001000
mB_TCNT_BIT4:       equ    %00010000
mB_TCNT_BIT5:       equ    %00100000
mB_TCNT_BIT6:       equ    %01000000
mB_TCNT_BIT7:       equ    %10000000
mB_TCNT_BIT8:       equ    %100000000
mB_TCNT_BIT9:       equ    %1000000000
mB_TCNT_BIT10:      equ    %10000000000
mB_TCNT_BIT11:      equ    %100000000000
mB_TCNT_BIT12:      equ    %1000000000000
mB_TCNT_BIT13:      equ    %10000000000000
mB_TCNT_BIT14:      equ    %100000000000000
mB_TCNT_BIT15:      equ    %1000000000000000


;*** B_TCNTHi - Timer Count Register High; 0x000002C4 ***
B_TCNTHi:           equ    $000002C4                                ;*** B_TCNTHi - Timer Count Register High; 0x000002C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCNTHi_BIT8:      equ    0                                         ; Timer Count Register Bit 8
B_TCNTHi_BIT9:      equ    1                                         ; Timer Count Register Bit 9
B_TCNTHi_BIT10:     equ    2                                         ; Timer Count Register Bit 10
B_TCNTHi_BIT11:     equ    3                                         ; Timer Count Register Bit 11
B_TCNTHi_BIT12:     equ    4                                         ; Timer Count Register Bit 12
B_TCNTHi_BIT13:     equ    5                                         ; Timer Count Register Bit 13
B_TCNTHi_BIT14:     equ    6                                         ; Timer Count Register Bit 14
B_TCNTHi_BIT15:     equ    7                                         ; Timer Count Register Bit 15
; bit position masks
mB_TCNTHi_BIT8:     equ    %00000001
mB_TCNTHi_BIT9:     equ    %00000010
mB_TCNTHi_BIT10:    equ    %00000100
mB_TCNTHi_BIT11:    equ    %00001000
mB_TCNTHi_BIT12:    equ    %00010000
mB_TCNTHi_BIT13:    equ    %00100000
mB_TCNTHi_BIT14:    equ    %01000000
mB_TCNTHi_BIT15:    equ    %10000000


;*** B_TCNTLo - Timer Count Register Low; 0x000002C5 ***
B_TCNTLo:           equ    $000002C5                                ;*** B_TCNTLo - Timer Count Register Low; 0x000002C5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCNTLo_BIT0:      equ    0                                         ; Timer Count Register Bit 0
B_TCNTLo_BIT1:      equ    1                                         ; Timer Count Register Bit 1
B_TCNTLo_BIT2:      equ    2                                         ; Timer Count Register Bit 2
B_TCNTLo_BIT3:      equ    3                                         ; Timer Count Register Bit 3
B_TCNTLo_BIT4:      equ    4                                         ; Timer Count Register Bit 4
B_TCNTLo_BIT5:      equ    5                                         ; Timer Count Register Bit 5
B_TCNTLo_BIT6:      equ    6                                         ; Timer Count Register Bit 6
B_TCNTLo_BIT7:      equ    7                                         ; Timer Count Register Bit 7
; bit position masks
mB_TCNTLo_BIT0:     equ    %00000001
mB_TCNTLo_BIT1:     equ    %00000010
mB_TCNTLo_BIT2:     equ    %00000100
mB_TCNTLo_BIT3:     equ    %00001000
mB_TCNTLo_BIT4:     equ    %00010000
mB_TCNTLo_BIT5:     equ    %00100000
mB_TCNTLo_BIT6:     equ    %01000000
mB_TCNTLo_BIT7:     equ    %10000000


;*** B_TSCR1 - Timer System Control Register1; 0x000002C6 ***
B_TSCR1:            equ    $000002C6                                ;*** B_TSCR1 - Timer System Control Register1; 0x000002C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TSCR1_TFFCA:      equ    4                                         ; Timer Fast Flag Clear All
B_TSCR1_TEN:        equ    7                                         ; Timer Enable
; bit position masks
mB_TSCR1_TFFCA:     equ    %00010000
mB_TSCR1_TEN:       equ    %10000000


;*** B_TTOV - Timer Toggle On Overflow Register; 0x000002C7 ***
B_TTOV:             equ    $000002C7                                ;*** B_TTOV - Timer Toggle On Overflow Register; 0x000002C7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TTOV_TOV0:        equ    0                                         ; Toggle On Overflow Bit 0
B_TTOV_TOV1:        equ    1                                         ; Toggle On Overflow Bit 1
B_TTOV_TOV2:        equ    2                                         ; Toggle On Overflow Bit 2
B_TTOV_TOV3:        equ    3                                         ; Toggle On Overflow Bit 3
; bit position masks
mB_TTOV_TOV0:       equ    %00000001
mB_TTOV_TOV1:       equ    %00000010
mB_TTOV_TOV2:       equ    %00000100
mB_TTOV_TOV3:       equ    %00001000


;*** B_TCTL1 - Timer Control Register 1; 0x000002C8 ***
B_TCTL1:            equ    $000002C8                                ;*** B_TCTL1 - Timer Control Register 1; 0x000002C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCTL1_OL0:        equ    0                                         ; Output Level Bit 0
B_TCTL1_OM0:        equ    1                                         ; Output Mode Bit 0
B_TCTL1_OL1:        equ    2                                         ; Output Lecel Bit 1
B_TCTL1_OM1:        equ    3                                         ; Output Mode Bit 1
B_TCTL1_OL2:        equ    4                                         ; Output Level Bit 2
B_TCTL1_OM2:        equ    5                                         ; Output Mode Bit 2
B_TCTL1_OL3:        equ    6                                         ; Output Level Bit 3
B_TCTL1_OM3:        equ    7                                         ; Output Mode Bit 3
; bit position masks
mB_TCTL1_OL0:       equ    %00000001
mB_TCTL1_OM0:       equ    %00000010
mB_TCTL1_OL1:       equ    %00000100
mB_TCTL1_OM1:       equ    %00001000
mB_TCTL1_OL2:       equ    %00010000
mB_TCTL1_OM2:       equ    %00100000
mB_TCTL1_OL3:       equ    %01000000
mB_TCTL1_OM3:       equ    %10000000


;*** B_TCTL2 - Timer Control Register 2; 0x000002C9 ***
B_TCTL2:            equ    $000002C9                                ;*** B_TCTL2 - Timer Control Register 2; 0x000002C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TCTL2_EDG0A:      equ    0                                         ; Input Capture Edge 0 Control A
B_TCTL2_EDG0B:      equ    1                                         ; Input Capture Edge 0 Control B
B_TCTL2_EDG1A:      equ    2                                         ; Input Capture Edge 1 Control A
B_TCTL2_EDG1B:      equ    3                                         ; Input Capture Edge 1 Control B
B_TCTL2_EDG2A:      equ    4                                         ; Input Capture Edge 2 Control A
B_TCTL2_EDG2B:      equ    5                                         ; Input Capture Edge 2 Control B
B_TCTL2_EDG3A:      equ    6                                         ; Input Capture Edge 3 Control A
B_TCTL2_EDG3B:      equ    7                                         ; Input Capture Edge 3 Control B
; bit position masks
mB_TCTL2_EDG0A:     equ    %00000001
mB_TCTL2_EDG0B:     equ    %00000010
mB_TCTL2_EDG1A:     equ    %00000100
mB_TCTL2_EDG1B:     equ    %00001000
mB_TCTL2_EDG2A:     equ    %00010000
mB_TCTL2_EDG2B:     equ    %00100000
mB_TCTL2_EDG3A:     equ    %01000000
mB_TCTL2_EDG3B:     equ    %10000000


;*** B_TIE - Timer Interrupt Enable Register; 0x000002CA ***
B_TIE:              equ    $000002CA                                ;*** B_TIE - Timer Interrupt Enable Register; 0x000002CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TIE_C0I:          equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
B_TIE_C1I:          equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
B_TIE_C2I:          equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
B_TIE_C3I:          equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
; bit position masks
mB_TIE_C0I:         equ    %00000001
mB_TIE_C1I:         equ    %00000010
mB_TIE_C2I:         equ    %00000100
mB_TIE_C3I:         equ    %00001000


;*** B_TSCR2 - Timer System Control Register 2; 0x000002CB ***
B_TSCR2:            equ    $000002CB                                ;*** B_TSCR2 - Timer System Control Register 2; 0x000002CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TSCR2_PR0:        equ    0                                         ; Timer Prescaler Select Bit 0
B_TSCR2_PR1:        equ    1                                         ; Timer Prescaler Select Bit 1
B_TSCR2_PR2:        equ    2                                         ; Timer Prescaler Select Bit 2
B_TSCR2_TCRE:       equ    3                                         ; Timer Counter Reset Enable
B_TSCR2_TOI:        equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mB_TSCR2_PR0:       equ    %00000001
mB_TSCR2_PR1:       equ    %00000010
mB_TSCR2_PR2:       equ    %00000100
mB_TSCR2_TCRE:      equ    %00001000
mB_TSCR2_TOI:       equ    %10000000


;*** B_TFLG1 - Main Timer Interrupt Flag 1; 0x000002CC ***
B_TFLG1:            equ    $000002CC                                ;*** B_TFLG1 - Main Timer Interrupt Flag 1; 0x000002CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TFLG1_C0F:        equ    0                                         ; Input Capture/Output Compare Channel Flag 0
B_TFLG1_C1F:        equ    1                                         ; Input Capture/Output Compare Channel Flag 1
B_TFLG1_C2F:        equ    2                                         ; Input Capture/Output Compare Channel Flag 2
B_TFLG1_C3F:        equ    3                                         ; Input Capture/Output Compare Channel Flag 3
; bit position masks
mB_TFLG1_C0F:       equ    %00000001
mB_TFLG1_C1F:       equ    %00000010
mB_TFLG1_C2F:       equ    %00000100
mB_TFLG1_C3F:       equ    %00001000


;*** B_TFLG2 - Main Timer Interrupt Flag 2; 0x000002CD ***
B_TFLG2:            equ    $000002CD                                ;*** B_TFLG2 - Main Timer Interrupt Flag 2; 0x000002CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TFLG2_TOF:        equ    7                                         ; Timer Overflow Flag
; bit position masks
mB_TFLG2_TOF:       equ    %10000000


;*** B_TC0 - Timer Input Capture/Output Compare Register 0; 0x000002CE ***
B_TC0:              equ    $000002CE                                ;*** B_TC0 - Timer Input Capture/Output Compare Register 0; 0x000002CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC0_BIT0:         equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 0
B_TC0_BIT1:         equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 1
B_TC0_BIT2:         equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 2
B_TC0_BIT3:         equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 3
B_TC0_BIT4:         equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 4
B_TC0_BIT5:         equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 5
B_TC0_BIT6:         equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 6
B_TC0_BIT7:         equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 7
B_TC0_BIT8:         equ    8                                         ; Timer Input Capture/Output Compare Register 0 Bit 8
B_TC0_BIT9:         equ    9                                         ; Timer Input Capture/Output Compare Register 0 Bit 9
B_TC0_BIT10:        equ    10                                        ; Timer Input Capture/Output Compare Register 0 Bit 10
B_TC0_BIT11:        equ    11                                        ; Timer Input Capture/Output Compare Register 0 Bit 11
B_TC0_BIT12:        equ    12                                        ; Timer Input Capture/Output Compare Register 0 Bit 12
B_TC0_BIT13:        equ    13                                        ; Timer Input Capture/Output Compare Register 0 Bit 13
B_TC0_BIT14:        equ    14                                        ; Timer Input Capture/Output Compare Register 0 Bit 14
B_TC0_BIT15:        equ    15                                        ; Timer Input Capture/Output Compare Register 0 Bit 15
; bit position masks
mB_TC0_BIT0:        equ    %00000001
mB_TC0_BIT1:        equ    %00000010
mB_TC0_BIT2:        equ    %00000100
mB_TC0_BIT3:        equ    %00001000
mB_TC0_BIT4:        equ    %00010000
mB_TC0_BIT5:        equ    %00100000
mB_TC0_BIT6:        equ    %01000000
mB_TC0_BIT7:        equ    %10000000
mB_TC0_BIT8:        equ    %100000000
mB_TC0_BIT9:        equ    %1000000000
mB_TC0_BIT10:       equ    %10000000000
mB_TC0_BIT11:       equ    %100000000000
mB_TC0_BIT12:       equ    %1000000000000
mB_TC0_BIT13:       equ    %10000000000000
mB_TC0_BIT14:       equ    %100000000000000
mB_TC0_BIT15:       equ    %1000000000000000


;*** B_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000002CE ***
B_TC0Hi:            equ    $000002CE                                ;*** B_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000002CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC0Hi_BIT8:       equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 8
B_TC0Hi_BIT9:       equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 9
B_TC0Hi_BIT10:      equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 10
B_TC0Hi_BIT11:      equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 11
B_TC0Hi_BIT12:      equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 12
B_TC0Hi_BIT13:      equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 13
B_TC0Hi_BIT14:      equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 14
B_TC0Hi_BIT15:      equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 15
; bit position masks
mB_TC0Hi_BIT8:      equ    %00000001
mB_TC0Hi_BIT9:      equ    %00000010
mB_TC0Hi_BIT10:     equ    %00000100
mB_TC0Hi_BIT11:     equ    %00001000
mB_TC0Hi_BIT12:     equ    %00010000
mB_TC0Hi_BIT13:     equ    %00100000
mB_TC0Hi_BIT14:     equ    %01000000
mB_TC0Hi_BIT15:     equ    %10000000


;*** B_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000002CF ***
B_TC0Lo:            equ    $000002CF                                ;*** B_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000002CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC0Lo_BIT0:       equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 0
B_TC0Lo_BIT1:       equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 1
B_TC0Lo_BIT2:       equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 2
B_TC0Lo_BIT3:       equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 3
B_TC0Lo_BIT4:       equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 4
B_TC0Lo_BIT5:       equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 5
B_TC0Lo_BIT6:       equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 6
B_TC0Lo_BIT7:       equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 7
; bit position masks
mB_TC0Lo_BIT0:      equ    %00000001
mB_TC0Lo_BIT1:      equ    %00000010
mB_TC0Lo_BIT2:      equ    %00000100
mB_TC0Lo_BIT3:      equ    %00001000
mB_TC0Lo_BIT4:      equ    %00010000
mB_TC0Lo_BIT5:      equ    %00100000
mB_TC0Lo_BIT6:      equ    %01000000
mB_TC0Lo_BIT7:      equ    %10000000


;*** B_TC1 - Timer Input Capture/Output Compare Register 1; 0x000002D0 ***
B_TC1:              equ    $000002D0                                ;*** B_TC1 - Timer Input Capture/Output Compare Register 1; 0x000002D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC1_BIT0:         equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 0
B_TC1_BIT1:         equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 1
B_TC1_BIT2:         equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 2
B_TC1_BIT3:         equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 3
B_TC1_BIT4:         equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 4
B_TC1_BIT5:         equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 5
B_TC1_BIT6:         equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 6
B_TC1_BIT7:         equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 7
B_TC1_BIT8:         equ    8                                         ; Timer Input Capture/Output Compare Register 1 Bit 8
B_TC1_BIT9:         equ    9                                         ; Timer Input Capture/Output Compare Register 1 Bit 9
B_TC1_BIT10:        equ    10                                        ; Timer Input Capture/Output Compare Register 1 Bit 10
B_TC1_BIT11:        equ    11                                        ; Timer Input Capture/Output Compare Register 1 Bit 11
B_TC1_BIT12:        equ    12                                        ; Timer Input Capture/Output Compare Register 1 Bit 12
B_TC1_BIT13:        equ    13                                        ; Timer Input Capture/Output Compare Register 1 Bit 13
B_TC1_BIT14:        equ    14                                        ; Timer Input Capture/Output Compare Register 1 Bit 14
B_TC1_BIT15:        equ    15                                        ; Timer Input Capture/Output Compare Register 1 Bit 15
; bit position masks
mB_TC1_BIT0:        equ    %00000001
mB_TC1_BIT1:        equ    %00000010
mB_TC1_BIT2:        equ    %00000100
mB_TC1_BIT3:        equ    %00001000
mB_TC1_BIT4:        equ    %00010000
mB_TC1_BIT5:        equ    %00100000
mB_TC1_BIT6:        equ    %01000000
mB_TC1_BIT7:        equ    %10000000
mB_TC1_BIT8:        equ    %100000000
mB_TC1_BIT9:        equ    %1000000000
mB_TC1_BIT10:       equ    %10000000000
mB_TC1_BIT11:       equ    %100000000000
mB_TC1_BIT12:       equ    %1000000000000
mB_TC1_BIT13:       equ    %10000000000000
mB_TC1_BIT14:       equ    %100000000000000
mB_TC1_BIT15:       equ    %1000000000000000


;*** B_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000002D0 ***
B_TC1Hi:            equ    $000002D0                                ;*** B_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000002D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC1Hi_BIT8:       equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 8
B_TC1Hi_BIT9:       equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 9
B_TC1Hi_BIT10:      equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 10
B_TC1Hi_BIT11:      equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 11
B_TC1Hi_BIT12:      equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 12
B_TC1Hi_BIT13:      equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 13
B_TC1Hi_BIT14:      equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 14
B_TC1Hi_BIT15:      equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 15
; bit position masks
mB_TC1Hi_BIT8:      equ    %00000001
mB_TC1Hi_BIT9:      equ    %00000010
mB_TC1Hi_BIT10:     equ    %00000100
mB_TC1Hi_BIT11:     equ    %00001000
mB_TC1Hi_BIT12:     equ    %00010000
mB_TC1Hi_BIT13:     equ    %00100000
mB_TC1Hi_BIT14:     equ    %01000000
mB_TC1Hi_BIT15:     equ    %10000000


;*** B_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000002D1 ***
B_TC1Lo:            equ    $000002D1                                ;*** B_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000002D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC1Lo_BIT0:       equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 0
B_TC1Lo_BIT1:       equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 1
B_TC1Lo_BIT2:       equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 2
B_TC1Lo_BIT3:       equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 3
B_TC1Lo_BIT4:       equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 4
B_TC1Lo_BIT5:       equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 5
B_TC1Lo_BIT6:       equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 6
B_TC1Lo_BIT7:       equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 7
; bit position masks
mB_TC1Lo_BIT0:      equ    %00000001
mB_TC1Lo_BIT1:      equ    %00000010
mB_TC1Lo_BIT2:      equ    %00000100
mB_TC1Lo_BIT3:      equ    %00001000
mB_TC1Lo_BIT4:      equ    %00010000
mB_TC1Lo_BIT5:      equ    %00100000
mB_TC1Lo_BIT6:      equ    %01000000
mB_TC1Lo_BIT7:      equ    %10000000


;*** B_TC2 - Timer Input Capture/Output Compare Register 2; 0x000002D2 ***
B_TC2:              equ    $000002D2                                ;*** B_TC2 - Timer Input Capture/Output Compare Register 2; 0x000002D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC2_BIT0:         equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 0
B_TC2_BIT1:         equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 1
B_TC2_BIT2:         equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 2
B_TC2_BIT3:         equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 3
B_TC2_BIT4:         equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 4
B_TC2_BIT5:         equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 5
B_TC2_BIT6:         equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 6
B_TC2_BIT7:         equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 7
B_TC2_BIT8:         equ    8                                         ; Timer Input Capture/Output Compare Register 2 Bit 8
B_TC2_BIT9:         equ    9                                         ; Timer Input Capture/Output Compare Register 2 Bit 9
B_TC2_BIT10:        equ    10                                        ; Timer Input Capture/Output Compare Register 2 Bit 10
B_TC2_BIT11:        equ    11                                        ; Timer Input Capture/Output Compare Register 2 Bit 11
B_TC2_BIT12:        equ    12                                        ; Timer Input Capture/Output Compare Register 2 Bit 12
B_TC2_BIT13:        equ    13                                        ; Timer Input Capture/Output Compare Register 2 Bit 13
B_TC2_BIT14:        equ    14                                        ; Timer Input Capture/Output Compare Register 2 Bit 14
B_TC2_BIT15:        equ    15                                        ; Timer Input Capture/Output Compare Register 2 Bit 15
; bit position masks
mB_TC2_BIT0:        equ    %00000001
mB_TC2_BIT1:        equ    %00000010
mB_TC2_BIT2:        equ    %00000100
mB_TC2_BIT3:        equ    %00001000
mB_TC2_BIT4:        equ    %00010000
mB_TC2_BIT5:        equ    %00100000
mB_TC2_BIT6:        equ    %01000000
mB_TC2_BIT7:        equ    %10000000
mB_TC2_BIT8:        equ    %100000000
mB_TC2_BIT9:        equ    %1000000000
mB_TC2_BIT10:       equ    %10000000000
mB_TC2_BIT11:       equ    %100000000000
mB_TC2_BIT12:       equ    %1000000000000
mB_TC2_BIT13:       equ    %10000000000000
mB_TC2_BIT14:       equ    %100000000000000
mB_TC2_BIT15:       equ    %1000000000000000


;*** B_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000002D2 ***
B_TC2Hi:            equ    $000002D2                                ;*** B_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000002D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC2Hi_BIT8:       equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 8
B_TC2Hi_BIT9:       equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 9
B_TC2Hi_BIT10:      equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 10
B_TC2Hi_BIT11:      equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 11
B_TC2Hi_BIT12:      equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 12
B_TC2Hi_BIT13:      equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 13
B_TC2Hi_BIT14:      equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 14
B_TC2Hi_BIT15:      equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 15
; bit position masks
mB_TC2Hi_BIT8:      equ    %00000001
mB_TC2Hi_BIT9:      equ    %00000010
mB_TC2Hi_BIT10:     equ    %00000100
mB_TC2Hi_BIT11:     equ    %00001000
mB_TC2Hi_BIT12:     equ    %00010000
mB_TC2Hi_BIT13:     equ    %00100000
mB_TC2Hi_BIT14:     equ    %01000000
mB_TC2Hi_BIT15:     equ    %10000000


;*** B_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000002D3 ***
B_TC2Lo:            equ    $000002D3                                ;*** B_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000002D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC2Lo_BIT0:       equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 0
B_TC2Lo_BIT1:       equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 1
B_TC2Lo_BIT2:       equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 2
B_TC2Lo_BIT3:       equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 3
B_TC2Lo_BIT4:       equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 4
B_TC2Lo_BIT5:       equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 5
B_TC2Lo_BIT6:       equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 6
B_TC2Lo_BIT7:       equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 7
; bit position masks
mB_TC2Lo_BIT0:      equ    %00000001
mB_TC2Lo_BIT1:      equ    %00000010
mB_TC2Lo_BIT2:      equ    %00000100
mB_TC2Lo_BIT3:      equ    %00001000
mB_TC2Lo_BIT4:      equ    %00010000
mB_TC2Lo_BIT5:      equ    %00100000
mB_TC2Lo_BIT6:      equ    %01000000
mB_TC2Lo_BIT7:      equ    %10000000


;*** B_TC3 - Timer Input Capture/Output Compare Register 3; 0x000002D4 ***
B_TC3:              equ    $000002D4                                ;*** B_TC3 - Timer Input Capture/Output Compare Register 3; 0x000002D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC3_BIT0:         equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 0
B_TC3_BIT1:         equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 1
B_TC3_BIT2:         equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 2
B_TC3_BIT3:         equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 3
B_TC3_BIT4:         equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 4
B_TC3_BIT5:         equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 5
B_TC3_BIT6:         equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 6
B_TC3_BIT7:         equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 7
B_TC3_BIT8:         equ    8                                         ; Timer Input Capture/Output Compare Register 3 Bit 8
B_TC3_BIT9:         equ    9                                         ; Timer Input Capture/Output Compare Register 3 Bit 9
B_TC3_BIT10:        equ    10                                        ; Timer Input Capture/Output Compare Register 3 Bit 10
B_TC3_BIT11:        equ    11                                        ; Timer Input Capture/Output Compare Register 3 Bit 11
B_TC3_BIT12:        equ    12                                        ; Timer Input Capture/Output Compare Register 3 Bit 12
B_TC3_BIT13:        equ    13                                        ; Timer Input Capture/Output Compare Register 3 Bit 13
B_TC3_BIT14:        equ    14                                        ; Timer Input Capture/Output Compare Register 3 Bit 14
B_TC3_BIT15:        equ    15                                        ; Timer Input Capture/Output Compare Register 3 Bit 15
; bit position masks
mB_TC3_BIT0:        equ    %00000001
mB_TC3_BIT1:        equ    %00000010
mB_TC3_BIT2:        equ    %00000100
mB_TC3_BIT3:        equ    %00001000
mB_TC3_BIT4:        equ    %00010000
mB_TC3_BIT5:        equ    %00100000
mB_TC3_BIT6:        equ    %01000000
mB_TC3_BIT7:        equ    %10000000
mB_TC3_BIT8:        equ    %100000000
mB_TC3_BIT9:        equ    %1000000000
mB_TC3_BIT10:       equ    %10000000000
mB_TC3_BIT11:       equ    %100000000000
mB_TC3_BIT12:       equ    %1000000000000
mB_TC3_BIT13:       equ    %10000000000000
mB_TC3_BIT14:       equ    %100000000000000
mB_TC3_BIT15:       equ    %1000000000000000


;*** B_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000002D4 ***
B_TC3Hi:            equ    $000002D4                                ;*** B_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000002D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC3Hi_BIT8:       equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 8
B_TC3Hi_BIT9:       equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 9
B_TC3Hi_BIT10:      equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 10
B_TC3Hi_BIT11:      equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 11
B_TC3Hi_BIT12:      equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 12
B_TC3Hi_BIT13:      equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 13
B_TC3Hi_BIT14:      equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 14
B_TC3Hi_BIT15:      equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 15
; bit position masks
mB_TC3Hi_BIT8:      equ    %00000001
mB_TC3Hi_BIT9:      equ    %00000010
mB_TC3Hi_BIT10:     equ    %00000100
mB_TC3Hi_BIT11:     equ    %00001000
mB_TC3Hi_BIT12:     equ    %00010000
mB_TC3Hi_BIT13:     equ    %00100000
mB_TC3Hi_BIT14:     equ    %01000000
mB_TC3Hi_BIT15:     equ    %10000000


;*** B_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000002D5 ***
B_TC3Lo:            equ    $000002D5                                ;*** B_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000002D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_TC3Lo_BIT0:       equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 0
B_TC3Lo_BIT1:       equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 1
B_TC3Lo_BIT2:       equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 2
B_TC3Lo_BIT3:       equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 3
B_TC3Lo_BIT4:       equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 4
B_TC3Lo_BIT5:       equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 5
B_TC3Lo_BIT6:       equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 6
B_TC3Lo_BIT7:       equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 7
; bit position masks
mB_TC3Lo_BIT0:      equ    %00000001
mB_TC3Lo_BIT1:      equ    %00000010
mB_TC3Lo_BIT2:      equ    %00000100
mB_TC3Lo_BIT3:      equ    %00001000
mB_TC3Lo_BIT4:      equ    %00010000
mB_TC3Lo_BIT5:      equ    %00100000
mB_TC3Lo_BIT6:      equ    %01000000
mB_TC3Lo_BIT7:      equ    %10000000


;*** B_CTR0 - Trimming Register 0; 0x000002F0 ***
B_CTR0:             equ    $000002F0                                ;*** B_CTR0 - Trimming Register 0; 0x000002F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_CTR0_WDCTR:       equ    0                                         ; Watchdog clock trim 0
B_CTR0_CTR0_3:      equ    3                                         ; Spare Trim bit 3
B_CTR0_CTR0_4:      equ    4                                         ; Spare Trim bit 4
B_CTR0_WDCTRE:      equ    5                                         ; Watchdog trim enable
B_CTR0_LINTR:       equ    6                                         ; LIN trim bit
B_CTR0_LINTRE:      equ    7                                         ; LIN trim enable
; bit position masks
mB_CTR0_WDCTR:      equ    %00000111
mB_CTR0_CTR0_3:     equ    %00001000
mB_CTR0_CTR0_4:     equ    %00010000
mB_CTR0_WDCTRE:     equ    %00100000
mB_CTR0_LINTR:      equ    %01000000
mB_CTR0_LINTRE:     equ    %10000000


;*** B_CTR1 - Trimming Register 1; 0x000002F1 ***
B_CTR1:             equ    $000002F1                                ;*** B_CTR1 - Trimming Register 1; 0x000002F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_CTR1_IREFTR:      equ    0                                         ; Iref trim 0
B_CTR1_IREFTRE:     equ    3                                         ; Iref trim enable bit
B_CTR1_BGTRIMDN:    equ    4                                         ; Bandgap trim down bit
B_CTR1_BGTRIMUP:    equ    5                                         ; Bandgap trim up bit
B_CTR1_CTR1_6:      equ    6                                         ; Spare Trim Bit
B_CTR1_BGTRE:       equ    7                                         ; Bandgap trim enable
; bit position masks
mB_CTR1_IREFTR:     equ    %00000111
mB_CTR1_IREFTRE:    equ    %00001000
mB_CTR1_BGTRIMDN:   equ    %00010000
mB_CTR1_BGTRIMUP:   equ    %00100000
mB_CTR1_CTR1_6:     equ    %01000000
mB_CTR1_BGTRE:      equ    %10000000


;*** B_CTR2 - Trimming Register 2; 0x000002F2 ***
B_CTR2:             equ    $000002F2                                ;*** B_CTR2 - Trimming Register 2; 0x000002F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_CTR2_SLPBGTR:     equ    0                                         ; bg1p25sleep trim 0
B_CTR2_SLPBG_LOCK:  equ    3                                         ; bg1p25sleep trim lock bit
B_CTR2_SLPBGTRE:    equ    4                                         ; Sleep Bandgap trim enable
; bit position masks
mB_CTR2_SLPBGTR:    equ    %00000111
mB_CTR2_SLPBG_LOCK: equ    %00001000
mB_CTR2_SLPBGTRE:   equ    %00010000


;*** B_CTR3 - Trimming Register 3; 0x000002F3 ***
B_CTR3:             equ    $000002F3                                ;*** B_CTR3 - Trimming Register 3; 0x000002F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_CTR3_CTR3_0:      equ    0                                         ; Spare Trim bit 0
B_CTR3_CTR3_1:      equ    1                                         ; Spare Trim bit 1
B_CTR3_CTR3_2:      equ    2                                         ; Spare Trim bit 2
B_CTR3_CTR3_E:      equ    3                                         ; Spare Trim enable bit
B_CTR3_OFFCTR:      equ    4                                         ; ADCOFFC trim 0
B_CTR3_OFFCTRE:     equ    7                                         ; ADC offset compensation voltage trim enable bit
; bit position masks
mB_CTR3_CTR3_0:     equ    %00000001
mB_CTR3_CTR3_1:     equ    %00000010
mB_CTR3_CTR3_2:     equ    %00000100
mB_CTR3_CTR3_E:     equ    %00001000
mB_CTR3_OFFCTR:     equ    %01110000
mB_CTR3_OFFCTRE:    equ    %10000000


;*** B_SRR - Silicon Revision Register; 0x000002F4 ***
B_SRR:              equ    $000002F4                                ;*** B_SRR - Silicon Revision Register; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
B_SRR_MMREV:        equ    0                                         ; MM912F634 analog die Silicon Revision Register Metal Tweak Revision
B_SRR_FMREV:        equ    2                                         ; MM912F634 analog die Silicon Revision Register Full Mask Revision
; bit position masks
mB_SRR_MMREV:       equ    %00000011
mB_SRR_FMREV:       equ    %00001100


;*** NB_ISR - Interrupt Source Register; 0x00000300 ***
NB_ISR:             equ    $00000300                                ;*** NB_ISR - Interrupt Source Register; 0x00000300 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ISR_VSI:         equ    0                                         ; Voltage Status Interrupt
NB_ISR_CH0:         equ    1                                         ; TIM Channel 0 Interrupt
NB_ISR_CH1:         equ    2                                         ; TIM Channel 1 Interrupt
NB_ISR_CH2:         equ    3                                         ; TIM Channel 2 Interrupt
NB_ISR_CH3:         equ    4                                         ; TIM Channel 3 Interrupt
NB_ISR_TOV:         equ    5                                         ; Timer Overflow Interrupt
NB_ISR_ERR:         equ    6                                         ; SCI Error Interrupt
NB_ISR_TX:          equ    7                                         ; SCI Transmit Interrupt
NB_ISR_RX:          equ    8                                         ; SCI Receive Interrupt
NB_ISR_SCI:         equ    9                                         ; ADC Sequence Complete Interrupt
NB_ISR_LINOT:       equ    10                                        ; LIN Driver Over-temperature Interrupt
NB_ISR_HSOT:        equ    11                                        ; High Side Over-temperature Interrupt
NB_ISR_LSOT:        equ    12                                        ; Low Side Over-temperature Interrupt
NB_ISR_HOT:         equ    13                                        ; HSUP Over-temperature Interrupt
; bit position masks
mNB_ISR_VSI:        equ    %00000001
mNB_ISR_CH0:        equ    %00000010
mNB_ISR_CH1:        equ    %00000100
mNB_ISR_CH2:        equ    %00001000
mNB_ISR_CH3:        equ    %00010000
mNB_ISR_TOV:        equ    %00100000
mNB_ISR_ERR:        equ    %01000000
mNB_ISR_TX:         equ    %10000000
mNB_ISR_RX:         equ    %100000000
mNB_ISR_SCI:        equ    %1000000000
mNB_ISR_LINOT:      equ    %10000000000
mNB_ISR_HSOT:       equ    %100000000000
mNB_ISR_LSOT:       equ    %1000000000000
mNB_ISR_HOT:        equ    %10000000000000


;*** NB_ISRhi - Interrupt Source Register High; 0x00000300 ***
NB_ISRhi:           equ    $00000300                                ;*** NB_ISRhi - Interrupt Source Register High; 0x00000300 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ISRhi_RX:        equ    0                                         ; SCI Receive Interrupt
NB_ISRhi_SCI:       equ    1                                         ; ADC Sequence Complete Interrupt
NB_ISRhi_LINOT:     equ    2                                         ; LIN Driver Over-temperature Interrupt
NB_ISRhi_HSOT:      equ    3                                         ; High Side Over-temperature Interrupt
NB_ISRhi_LSOT:      equ    4                                         ; Low Side Over-temperature Interrupt
NB_ISRhi_HOT:       equ    5                                         ; HSUP Over-temperature Interrupt
; bit position masks
mNB_ISRhi_RX:       equ    %00000001
mNB_ISRhi_SCI:      equ    %00000010
mNB_ISRhi_LINOT:    equ    %00000100
mNB_ISRhi_HSOT:     equ    %00001000
mNB_ISRhi_LSOT:     equ    %00010000
mNB_ISRhi_HOT:      equ    %00100000


;*** NB_ISRlo - Interrupt Source Register Low; 0x00000301 ***
NB_ISRlo:           equ    $00000301                                ;*** NB_ISRlo - Interrupt Source Register Low; 0x00000301 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ISRlo_VSI:       equ    0                                         ; Voltage Status Interrupt
NB_ISRlo_CH0:       equ    1                                         ; TIM Channel 0 Interrupt
NB_ISRlo_CH1:       equ    2                                         ; TIM Channel 1 Interrupt
NB_ISRlo_CH2:       equ    3                                         ; TIM Channel 2 Interrupt
NB_ISRlo_CH3:       equ    4                                         ; TIM Channel 3 Interrupt
NB_ISRlo_TOV:       equ    5                                         ; Timer Overflow Interrupt
NB_ISRlo_ERR:       equ    6                                         ; SCI Error Interrupt
NB_ISRlo_TX:        equ    7                                         ; SCI Transmit Interrupt
; bit position masks
mNB_ISRlo_VSI:      equ    %00000001
mNB_ISRlo_CH0:      equ    %00000010
mNB_ISRlo_CH1:      equ    %00000100
mNB_ISRlo_CH2:      equ    %00001000
mNB_ISRlo_CH3:      equ    %00010000
mNB_ISRlo_TOV:      equ    %00100000
mNB_ISRlo_ERR:      equ    %01000000
mNB_ISRlo_TX:       equ    %10000000


;*** NB_IVR - Interrupt Vector Register; 0x00000302 ***
NB_IVR:             equ    $00000302                                ;*** NB_IVR - Interrupt Vector Register; 0x00000302 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_IVR_IRQ:         equ    0                                         ; Represents the highest prioritized interrupt pending
; bit position masks
mNB_IVR_IRQ:        equ    %00111111


;*** NB_VCR - Voltage Control Register; 0x00000304 ***
NB_VCR:             equ    $00000304                                ;*** NB_VCR - Voltage Control Register; 0x00000304 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_VCR_LBIE:        equ    0                                         ; Low Battery Interrupt Enable
NB_VCR_LVIE:        equ    1                                         ; Low Voltage Interrupt Enable
NB_VCR_HVIE:        equ    2                                         ; High Voltage Interrupt Enable
NB_VCR_HTIE:        equ    3                                         ; High Temperature Interrupt Enable
NB_VCR_VROVIE:      equ    4                                         ; Voltage Regulator Over-voltage Interrupt Enable
; bit position masks
mNB_VCR_LBIE:       equ    %00000001
mNB_VCR_LVIE:       equ    %00000010
mNB_VCR_HVIE:       equ    %00000100
mNB_VCR_HTIE:       equ    %00001000
mNB_VCR_VROVIE:     equ    %00010000


;*** NB_VSR - Voltage Status Register; 0x00000305 ***
NB_VSR:             equ    $00000305                                ;*** NB_VSR - Voltage Status Register; 0x00000305 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_VSR_LBC:         equ    0                                         ; Low Battery Condition
NB_VSR_LVC:         equ    1                                         ; Low Voltage Condition
NB_VSR_HVC:         equ    2                                         ; High Voltage Condition
NB_VSR_HTC:         equ    3                                         ; High Temperature Condition
NB_VSR_VROVC:       equ    4                                         ; Voltage Regulator Over-voltage Condition
; bit position masks
mNB_VSR_LBC:        equ    %00000001
mNB_VSR_LVC:        equ    %00000010
mNB_VSR_HVC:        equ    %00000100
mNB_VSR_HTC:        equ    %00001000
mNB_VSR_VROVC:      equ    %00010000


;*** NB_LXR - Lx Status Register; 0x00000308 ***
NB_LXR:             equ    $00000308                                ;*** NB_LXR - Lx Status Register; 0x00000308 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LXR_L0:          equ    0                                         ; Current Digital State of the L0 Input
NB_LXR_L1:          equ    1                                         ; Current Digital State of the L1 Input
NB_LXR_L2:          equ    2                                         ; Current Digital State of the L2 Input
NB_LXR_L3:          equ    3                                         ; Current Digital State of the L3 Input
NB_LXR_L4:          equ    4                                         ; Current Digital State of the L4 Input
NB_LXR_L5:          equ    5                                         ; Current Digital State of the L5 Input
; bit position masks
mNB_LXR_L0:         equ    %00000001
mNB_LXR_L1:         equ    %00000010
mNB_LXR_L2:         equ    %00000100
mNB_LXR_L3:         equ    %00001000
mNB_LXR_L4:         equ    %00010000
mNB_LXR_L5:         equ    %00100000


;*** NB_LXCR - Lx Control Register; 0x00000309 ***
NB_LXCR:            equ    $00000309                                ;*** NB_LXCR - Lx Control Register; 0x00000309 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LXCR_L0DS:       equ    0                                         ; Analog Input Divider Ratio Selection - L0
NB_LXCR_L1DS:       equ    1                                         ; Analog Input Divider Ratio Selection - L1
NB_LXCR_L2DS:       equ    2                                         ; Analog Input Divider Ratio Selection - L2
NB_LXCR_L3DS:       equ    3                                         ; Analog Input Divider Ratio Selection - L3
NB_LXCR_L4DS:       equ    4                                         ; Analog Input Divider Ratio Selection - L4
NB_LXCR_L5DS:       equ    5                                         ; Analog Input Divider Ratio Selection - L5
; bit position masks
mNB_LXCR_L0DS:      equ    %00000001
mNB_LXCR_L1DS:      equ    %00000010
mNB_LXCR_L2DS:      equ    %00000100
mNB_LXCR_L3DS:      equ    %00001000
mNB_LXCR_L4DS:      equ    %00010000
mNB_LXCR_L5DS:      equ    %00100000


;*** NB_WDR - Watchdog Register; 0x00000310 ***
NB_WDR:             equ    $00000310                                ;*** NB_WDR - Watchdog Register; 0x00000310 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_WDR_WDTO:        equ    0                                         ; Watchdog Timeout Configuration Bit 0
NB_WDR_WDWO:        equ    6                                         ; Watchdog Window Open
NB_WDR_WDOFF:       equ    7                                         ; Watchdog Off
; bit position masks
mNB_WDR_WDTO:       equ    %00000111
mNB_WDR_WDWO:       equ    %01000000
mNB_WDR_WDOFF:      equ    %10000000


;*** NB_WDSR - Watchdog Service Register; 0x00000311 ***
NB_WDSR:            equ    $00000311                                ;*** NB_WDSR - Watchdog Service Register; 0x00000311 ***


;*** NB_WCR - Wake-up Control Register; 0x00000312 ***
NB_WCR:             equ    $00000312                                ;*** NB_WCR - Wake-up Control Register; 0x00000312 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_WCR_L0WE:        equ    0                                         ; Wake-up Input 0 Enabled
NB_WCR_L1WE:        equ    1                                         ; Wake-up Input 1 Enabled
NB_WCR_L2WE:        equ    2                                         ; Wake-up Input 2 Enabled
NB_WCR_L3WE:        equ    3                                         ; Wake-up Input 3 Enabled
NB_WCR_L4WE:        equ    4                                         ; Wake-up Input 4 Enabled
NB_WCR_L5WE:        equ    5                                         ; Wake-up Input 5 Enabled
NB_WCR_CSSEL:       equ    6                                         ; Cyclic Sense Select Bit 0
; bit position masks
mNB_WCR_L0WE:       equ    %00000001
mNB_WCR_L1WE:       equ    %00000010
mNB_WCR_L2WE:       equ    %00000100
mNB_WCR_L3WE:       equ    %00001000
mNB_WCR_L4WE:       equ    %00010000
mNB_WCR_L5WE:       equ    %00100000
mNB_WCR_CSSEL:      equ    %11000000


;*** NB_TCR - Timing Control Register; 0x00000313 ***
NB_TCR:             equ    $00000313                                ;*** NB_TCR - Timing Control Register; 0x00000313 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCR_CST:         equ    0                                         ; Cyclic Sense Timing Bit 0
NB_TCR_FWM:         equ    4                                         ; Forced Wake-up Multiplicator Bit 0
; bit position masks
mNB_TCR_CST:        equ    %00001111
mNB_TCR_FWM:        equ    %11110000


;*** NB_WSR - Wake-up Source Register; 0x00000314 ***
NB_WSR:             equ    $00000314                                ;*** NB_WSR - Wake-up Source Register; 0x00000314 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_WSR_L0WU:        equ    0                                         ; L0 Wake-upe-up
NB_WSR_L1WU:        equ    1                                         ; L1 Wake-upp
NB_WSR_L2WU:        equ    2                                         ; L2 Wake-up
NB_WSR_L3WU:        equ    3                                         ; L3 Wake-up
NB_WSR_L4WU:        equ    4                                         ; L4 Wake-up
NB_WSR_L5WU:        equ    5                                         ; L5 Wake-up
NB_WSR_LINWU:       equ    6                                         ; LIN Wake-up
NB_WSR_FWU:         equ    7                                         ; Forced Wake-up
; bit position masks
mNB_WSR_L0WU:       equ    %00000001
mNB_WSR_L1WU:       equ    %00000010
mNB_WSR_L2WU:       equ    %00000100
mNB_WSR_L3WU:       equ    %00001000
mNB_WSR_L4WU:       equ    %00010000
mNB_WSR_L5WU:       equ    %00100000
mNB_WSR_LINWU:      equ    %01000000
mNB_WSR_FWU:        equ    %10000000


;*** NB_RSR - Reset Status Register; 0x00000315 ***
NB_RSR:             equ    $00000315                                ;*** NB_RSR - Reset Status Register; 0x00000315 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_RSR_POR:         equ    0                                         ; Power On Reset
NB_RSR_LVR:         equ    1                                         ; Low Voltage Reset VDD
NB_RSR_LVRX:        equ    2                                         ; Low Voltage Reset VDDX
NB_RSR_WUR:         equ    3                                         ; Wake-up Reset
NB_RSR_EXR:         equ    4                                         ; External Reset
NB_RSR_WDR:         equ    5                                         ; Watchdog Reset
; bit position masks
mNB_RSR_POR:        equ    %00000001
mNB_RSR_LVR:        equ    %00000010
mNB_RSR_LVRX:       equ    %00000100
mNB_RSR_WUR:        equ    %00001000
mNB_RSR_EXR:        equ    %00010000
mNB_RSR_WDR:        equ    %00100000


;*** NB_MCR - Mode Control Register; 0x00000316 ***
NB_MCR:             equ    $00000316                                ;*** NB_MCR - Mode Control Register; 0x00000316 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_MCR_MODE:        equ    0                                         ; Mode Select bit 0
; bit position masks
mNB_MCR_MODE:       equ    %00000011


;*** NB_LINR - LIN Register; 0x00000318 ***
NB_LINR:            equ    $00000318                                ;*** NB_LINR - LIN Register; 0x00000318 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LINR_LINSR:      equ    0                                         ; LIN - Slew Rate Select 0
NB_LINR_LINEN:      equ    2                                         ; LIN Module Enable
NB_LINR_LVSD:       equ    3                                         ; LIN - Low Voltage Shutdown Disable (J2602 Compliance Control)
NB_LINR_TX:         equ    4                                         ; LIN - Direct Transmitter Control
NB_LINR_RX:         equ    5                                         ; LIN - Receiver (Rx) Status
NB_LINR_LINOTC:     equ    6                                         ; LIN - Over-temperature condition present
NB_LINR_LINOTIE:    equ    7                                         ; LIN - Over-temperature Interrupt Enable
; bit position masks
mNB_LINR_LINSR:     equ    %00000011
mNB_LINR_LINEN:     equ    %00000100
mNB_LINR_LVSD:      equ    %00001000
mNB_LINR_TX:        equ    %00010000
mNB_LINR_RX:        equ    %00100000
mNB_LINR_LINOTC:    equ    %01000000
mNB_LINR_LINOTIE:   equ    %10000000


;*** NB_PTBC1 - Port B Configuration Register 1; 0x00000320 ***
NB_PTBC1:           equ    $00000320                                ;*** NB_PTBC1 - Port B Configuration Register 1; 0x00000320 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PTBC1_DDRB0:     equ    0                                         ; Data Direction Port B 0
NB_PTBC1_DDRB1:     equ    1                                         ; Data Direction Port B 0
NB_PTBC1_DDRB2:     equ    2                                         ; Data Direction Port B 0
NB_PTBC1_PUEB0:     equ    4                                         ; Pull-up Enable Port B 0
NB_PTBC1_PUEB1:     equ    5                                         ; Pull-up Enable Port B 0
NB_PTBC1_PUEB2:     equ    6                                         ; Pull-up Enable Port B 0
; bit position masks
mNB_PTBC1_DDRB0:    equ    %00000001
mNB_PTBC1_DDRB1:    equ    %00000010
mNB_PTBC1_DDRB2:    equ    %00000100
mNB_PTBC1_PUEB0:    equ    %00010000
mNB_PTBC1_PUEB1:    equ    %00100000
mNB_PTBC1_PUEB2:    equ    %01000000


;*** NB_PTBC2 - Port B Configuration Register 2; 0x00000321 ***
NB_PTBC2:           equ    $00000321                                ;*** NB_PTBC2 - Port B Configuration Register 2; 0x00000321 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PTBC2_SERMOD:    equ    0                                         ; Serial Mode Select for PTB 0
NB_PTBC2_PWMEN:     equ    2                                         ; PWM Enable for PTB2
NB_PTBC2_PWMCS:     equ    3                                         ; PWM Channel Select PTB2
; bit position masks
mNB_PTBC2_SERMOD:   equ    %00000011
mNB_PTBC2_PWMEN:    equ    %00000100
mNB_PTBC2_PWMCS:    equ    %00001000


;*** NB_PTB - Port B Data Register; 0x00000322 ***
NB_PTB:             equ    $00000322                                ;*** NB_PTB - Port B Data Register; 0x00000322 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PTB_PTB0:        equ    0                                         ; Port B general purpose input/output data 0
NB_PTB_PTB1:        equ    1                                         ; Port B general purpose input/output data 1
NB_PTB_PTB2:        equ    2                                         ; Port B general purpose input/output data 2
; bit position masks
mNB_PTB_PTB0:       equ    %00000001
mNB_PTB_PTB1:       equ    %00000010
mNB_PTB_PTB2:       equ    %00000100


;*** NB_HSCR - High Side Control Register; 0x00000328 ***
NB_HSCR:            equ    $00000328                                ;*** NB_HSCR - High Side Control Register; 0x00000328 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_HSCR_HS1:        equ    0                                         ; HS2 Control
NB_HSCR_HS2:        equ    1                                         ; HS2 Control
NB_HSCR_PWMHS1:     equ    2                                         ; PWM Enable for HS1
NB_HSCR_PWMHS2:     equ    3                                         ; PWM Enable for HS2
NB_HSCR_PWMCS1:     equ    4                                         ; PWM Channel Select HS1
NB_HSCR_PWMCS2:     equ    5                                         ; PWM Channel Select HS2
NB_HSCR_HSHVSDE:    equ    6                                         ; High Side High Voltage Shutdown
NB_HSCR_HSOTIE:     equ    7                                         ; High Side Over-temperature Interrupt Enable
; bit position masks
mNB_HSCR_HS1:       equ    %00000001
mNB_HSCR_HS2:       equ    %00000010
mNB_HSCR_PWMHS1:    equ    %00000100
mNB_HSCR_PWMHS2:    equ    %00001000
mNB_HSCR_PWMCS1:    equ    %00010000
mNB_HSCR_PWMCS2:    equ    %00100000
mNB_HSCR_HSHVSDE:   equ    %01000000
mNB_HSCR_HSOTIE:    equ    %10000000


;*** NB_HSSR - High Side Status Register; 0x00000329 ***
NB_HSSR:            equ    $00000329                                ;*** NB_HSSR - High Side Status Register; 0x00000329 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_HSSR_HS1OL:      equ    0                                         ; High Side 1Open Load
NB_HSSR_HS2OL:      equ    1                                         ; High Side 2 Open Load
NB_HSSR_HS1CL:      equ    2                                         ; High Side 1 Current Limitation
NB_HSSR_HS2CL:      equ    3                                         ; High Side 2 Current Limitation
NB_HSSR_HSOTC:      equ    7                                         ; High Side Over-temperature Condition
; bit position masks
mNB_HSSR_HS1OL:     equ    %00000001
mNB_HSSR_HS2OL:     equ    %00000010
mNB_HSSR_HS1CL:     equ    %00000100
mNB_HSSR_HS2CL:     equ    %00001000
mNB_HSSR_HSOTC:     equ    %10000000


;*** NB_LSCR - Low Side Control Register; 0x00000330 ***
NB_LSCR:            equ    $00000330                                ;*** NB_LSCR - Low Side Control Register; 0x00000330 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LSCR_LS1:        equ    0                                         ; LS1 Enable
NB_LSCR_LS2:        equ    1                                         ; LS2 Enable
NB_LSCR_PWMLS1:     equ    2                                         ; PWM Enable for LS1
NB_LSCR_PWMLS2:     equ    3                                         ; PWM Enable for LS2
NB_LSCR_PWMCS1:     equ    4                                         ; PWM Channel Select LS1
NB_LSCR_PWMCS2:     equ    5                                         ; PWM Channel Select LS2
NB_LSCR_LSOTIE:     equ    7                                         ; Low Side Over-temperature Interrupt Enable
; bit position masks
mNB_LSCR_LS1:       equ    %00000001
mNB_LSCR_LS2:       equ    %00000010
mNB_LSCR_PWMLS1:    equ    %00000100
mNB_LSCR_PWMLS2:    equ    %00001000
mNB_LSCR_PWMCS1:    equ    %00010000
mNB_LSCR_PWMCS2:    equ    %00100000
mNB_LSCR_LSOTIE:    equ    %10000000


;*** NB_LSSR - Low Side Status Register; 0x00000331 ***
NB_LSSR:            equ    $00000331                                ;*** NB_LSSR - Low Side Status Register; 0x00000331 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LSSR_LS1OL:      equ    0                                         ; Low Side 1 Open Load
NB_LSSR_LS2OL:      equ    1                                         ; Low Side 2 Open Load
NB_LSSR_LS1CL:      equ    2                                         ; Low Side 1 Current Limitation
NB_LSSR_LS2CL:      equ    3                                         ; Low Side 2 Current Limitation
NB_LSSR_LSOTC:      equ    7                                         ; Low Side Over-temperature condition present
; bit position masks
mNB_LSSR_LS1OL:     equ    %00000001
mNB_LSSR_LS2OL:     equ    %00000010
mNB_LSSR_LS1CL:     equ    %00000100
mNB_LSSR_LS2CL:     equ    %00001000
mNB_LSSR_LSOTC:     equ    %10000000


;*** NB_LSCEN - Low Side Control Enable Register; 0x00000332 ***
NB_LSCEN:           equ    $00000332                                ;*** NB_LSCEN - Low Side Control Enable Register; 0x00000332 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_LSCEN_LSCEN:     equ    0                                         ; Low Side Control Enable Bit 0
; bit position masks
mNB_LSCEN_LSCEN:    equ    %00001111


;*** NB_HSR - Hall Supply Register; 0x00000338 ***
NB_HSR:             equ    $00000338                                ;*** NB_HSR - Hall Supply Register; 0x00000338 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_HSR_HSUPON:      equ    0                                         ; Hall Supply On
NB_HSR_HOTC:        equ    6                                         ; Hall Supply Over-temperature Condition
NB_HSR_HOTIE:       equ    7                                         ; Hall Supply Over-temperature Interrupt Enable
; bit position masks
mNB_HSR_HSUPON:     equ    %00000001
mNB_HSR_HOTC:       equ    %01000000
mNB_HSR_HOTIE:      equ    %10000000


;*** NB_CSR - Current Sense Register; 0x0000033C ***
NB_CSR:             equ    $0000033C                                ;*** NB_CSR - Current Sense Register; 0x0000033C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_CSR_CSGS:        equ    0                                         ; Current Sense Gain Select 0
NB_CSR_CCD:         equ    3                                         ; Input Filter Charge Compensation Disable Bit
NB_CSR_CSE:         equ    7                                         ; Current Sense Enable Bit
; bit position masks
mNB_CSR_CSGS:       equ    %00000111
mNB_CSR_CCD:        equ    %00001000
mNB_CSR_CSE:        equ    %10000000


;*** NB_SCIBD - SCI Baud Rate Register; 0x00000340 ***
NB_SCIBD:           equ    $00000340                                ;*** NB_SCIBD - SCI Baud Rate Register; 0x00000340 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIBD_SBR0:      equ    0                                         ; Baud Rate Modulo Divisor Bit 0
NB_SCIBD_SBR1:      equ    1                                         ; Baud Rate Modulo Divisor Bit 1
NB_SCIBD_SBR2:      equ    2                                         ; Baud Rate Modulo Divisor Bit 2
NB_SCIBD_SBR3:      equ    3                                         ; Baud Rate Modulo Divisor Bit 3
NB_SCIBD_SBR4:      equ    4                                         ; Baud Rate Modulo Divisor Bit 4
NB_SCIBD_SBR5:      equ    5                                         ; Baud Rate Modulo Divisor Bit 5
NB_SCIBD_SBR6:      equ    6                                         ; Baud Rate Modulo Divisor Bit 6
NB_SCIBD_SBR7:      equ    7                                         ; Baud Rate Modulo Divisor Bit 7
NB_SCIBD_SBR8:      equ    8                                         ; Baud Rate Modulo Divisor Bit 8
NB_SCIBD_SBR9:      equ    9                                         ; Baud Rate Modulo Divisor Bit 9
NB_SCIBD_SBR10:     equ    10                                        ; Baud Rate Modulo Divisor Bit 10
NB_SCIBD_SBR11:     equ    11                                        ; Baud Rate Modulo Divisor Bit 11
NB_SCIBD_SBR12:     equ    12                                        ; Baud Rate Modulo Divisor Bit 12
NB_SCIBD_RXEDGIE:   equ    14                                        ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
NB_SCIBD_LBKDIE:    equ    15                                        ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mNB_SCIBD_SBR0:     equ    %00000001
mNB_SCIBD_SBR1:     equ    %00000010
mNB_SCIBD_SBR2:     equ    %00000100
mNB_SCIBD_SBR3:     equ    %00001000
mNB_SCIBD_SBR4:     equ    %00010000
mNB_SCIBD_SBR5:     equ    %00100000
mNB_SCIBD_SBR6:     equ    %01000000
mNB_SCIBD_SBR7:     equ    %10000000
mNB_SCIBD_SBR8:     equ    %100000000
mNB_SCIBD_SBR9:     equ    %1000000000
mNB_SCIBD_SBR10:    equ    %10000000000
mNB_SCIBD_SBR11:    equ    %100000000000
mNB_SCIBD_SBR12:    equ    %1000000000000
mNB_SCIBD_RXEDGIE:  equ    %100000000000000
mNB_SCIBD_LBKDIE:   equ    %1000000000000000


;*** NB_SCIBDH - SCI Baud Rate Register High; 0x00000340 ***
NB_SCIBDH:          equ    $00000340                                ;*** NB_SCIBDH - SCI Baud Rate Register High; 0x00000340 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIBDH_SBR8:     equ    0                                         ; Baud Rate Modulo Divisor Bit 8
NB_SCIBDH_SBR9:     equ    1                                         ; Baud Rate Modulo Divisor Bit 9
NB_SCIBDH_SBR10:    equ    2                                         ; Baud Rate Modulo Divisor Bit 10
NB_SCIBDH_SBR11:    equ    3                                         ; Baud Rate Modulo Divisor Bit 11
NB_SCIBDH_SBR12:    equ    4                                         ; Baud Rate Modulo Divisor Bit 12
NB_SCIBDH_RXEDGIE:  equ    6                                         ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
NB_SCIBDH_LBKDIE:   equ    7                                         ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mNB_SCIBDH_SBR8:    equ    %00000001
mNB_SCIBDH_SBR9:    equ    %00000010
mNB_SCIBDH_SBR10:   equ    %00000100
mNB_SCIBDH_SBR11:   equ    %00001000
mNB_SCIBDH_SBR12:   equ    %00010000
mNB_SCIBDH_RXEDGIE: equ    %01000000
mNB_SCIBDH_LBKDIE:  equ    %10000000


;*** NB_SCIBDL - SCI Baud Rate Register Low; 0x00000341 ***
NB_SCIBDL:          equ    $00000341                                ;*** NB_SCIBDL - SCI Baud Rate Register Low; 0x00000341 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIBDL_SBR0:     equ    0                                         ; Baud Rate Modulo Divisor Bit 0
NB_SCIBDL_SBR1:     equ    1                                         ; Baud Rate Modulo Divisor Bit 1
NB_SCIBDL_SBR2:     equ    2                                         ; Baud Rate Modulo Divisor Bit 2
NB_SCIBDL_SBR3:     equ    3                                         ; Baud Rate Modulo Divisor Bit 3
NB_SCIBDL_SBR4:     equ    4                                         ; Baud Rate Modulo Divisor Bit 4
NB_SCIBDL_SBR5:     equ    5                                         ; Baud Rate Modulo Divisor Bit 5
NB_SCIBDL_SBR6:     equ    6                                         ; Baud Rate Modulo Divisor Bit 6
NB_SCIBDL_SBR7:     equ    7                                         ; Baud Rate Modulo Divisor Bit 7
; bit position masks
mNB_SCIBDL_SBR0:    equ    %00000001
mNB_SCIBDL_SBR1:    equ    %00000010
mNB_SCIBDL_SBR2:    equ    %00000100
mNB_SCIBDL_SBR3:    equ    %00001000
mNB_SCIBDL_SBR4:    equ    %00010000
mNB_SCIBDL_SBR5:    equ    %00100000
mNB_SCIBDL_SBR6:    equ    %01000000
mNB_SCIBDL_SBR7:    equ    %10000000


;*** NB_SCIC1 - SCI Control Register 1; 0x00000342 ***
NB_SCIC1:           equ    $00000342                                ;*** NB_SCIC1 - SCI Control Register 1; 0x00000342 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIC1_PT:        equ    0                                         ; Parity Type
NB_SCIC1_PE:        equ    1                                         ; Parity Enable
NB_SCIC1_ILT:       equ    2                                         ; Idle Line Type Select
NB_SCIC1_M:         equ    4                                         ; 9-Bit or 8-Bit Mode Select
NB_SCIC1_RSRC:      equ    5                                         ; Receiver Source Select
NB_SCIC1_LOOPS:     equ    7                                         ; Loop Mode Select
; bit position masks
mNB_SCIC1_PT:       equ    %00000001
mNB_SCIC1_PE:       equ    %00000010
mNB_SCIC1_ILT:      equ    %00000100
mNB_SCIC1_M:        equ    %00010000
mNB_SCIC1_RSRC:     equ    %00100000
mNB_SCIC1_LOOPS:    equ    %10000000


;*** NB_SCIC2 - SCI Control Register 2; 0x00000343 ***
NB_SCIC2:           equ    $00000343                                ;*** NB_SCIC2 - SCI Control Register 2; 0x00000343 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIC2_SBK:       equ    0                                         ; Send Break
NB_SCIC2_RWU:       equ    1                                         ; Receiver Wakeup Control
NB_SCIC2_RE:        equ    2                                         ; Receiver Enable
NB_SCIC2_TE:        equ    3                                         ; Transmitter Enable
NB_SCIC2_ILIE:      equ    4                                         ; Idle Line Interrupt Enable (for IDLE)
NB_SCIC2_RIE:       equ    5                                         ; Receiver Interrupt Enable (for RDRF)
NB_SCIC2_TCIE:      equ    6                                         ; Transmission Complete Interrupt Enable (for TC)
NB_SCIC2_TIE:       equ    7                                         ; Transmit Interrupt Enable (for TDRE)
; bit position masks
mNB_SCIC2_SBK:      equ    %00000001
mNB_SCIC2_RWU:      equ    %00000010
mNB_SCIC2_RE:       equ    %00000100
mNB_SCIC2_TE:       equ    %00001000
mNB_SCIC2_ILIE:     equ    %00010000
mNB_SCIC2_RIE:      equ    %00100000
mNB_SCIC2_TCIE:     equ    %01000000
mNB_SCIC2_TIE:      equ    %10000000


;*** NB_SCIS1 - SCI Status Register 1; 0x00000344 ***
NB_SCIS1:           equ    $00000344                                ;*** NB_SCIS1 - SCI Status Register 1; 0x00000344 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIS1_PF:        equ    0                                         ; Parity Error Flag
NB_SCIS1_FE:        equ    1                                         ; Framing Error Flag
NB_SCIS1_NF:        equ    2                                         ; Noise Flag
NB_SCIS1_OR:        equ    3                                         ; Receiver Overrun Flag
NB_SCIS1_IDLE:      equ    4                                         ; Idle Line Flag
NB_SCIS1_RDRF:      equ    5                                         ; Receive Data Register Full Flag
NB_SCIS1_TC:        equ    6                                         ; Transmission Complete Flag
NB_SCIS1_TDRE:      equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mNB_SCIS1_PF:       equ    %00000001
mNB_SCIS1_FE:       equ    %00000010
mNB_SCIS1_NF:       equ    %00000100
mNB_SCIS1_OR:       equ    %00001000
mNB_SCIS1_IDLE:     equ    %00010000
mNB_SCIS1_RDRF:     equ    %00100000
mNB_SCIS1_TC:       equ    %01000000
mNB_SCIS1_TDRE:     equ    %10000000


;*** NB_SCIS2 - SCI Status Register 2; 0x00000345 ***
NB_SCIS2:           equ    $00000345                                ;*** NB_SCIS2 - SCI Status Register 2; 0x00000345 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIS2_RAF:       equ    0                                         ; Receiver Active Flag
NB_SCIS2_LBKDE:     equ    1                                         ; LIN Break Detection Enable
NB_SCIS2_BRK13:     equ    2                                         ; Break Character Generation Length
NB_SCIS2_RWUID:     equ    3                                         ; Receive Wake Up Idle Detect
NB_SCIS2_RXINV:     equ    4                                         ; Receive Data Inversion
NB_SCIS2_RXEDGIF:   equ    6                                         ; RxD Pin Active Edge Interrupt Flag
NB_SCIS2_LBKDIF:    equ    7                                         ; LIN Break Detect Interrupt Flag
; bit position masks
mNB_SCIS2_RAF:      equ    %00000001
mNB_SCIS2_LBKDE:    equ    %00000010
mNB_SCIS2_BRK13:    equ    %00000100
mNB_SCIS2_RWUID:    equ    %00001000
mNB_SCIS2_RXINV:    equ    %00010000
mNB_SCIS2_RXEDGIF:  equ    %01000000
mNB_SCIS2_LBKDIF:   equ    %10000000


;*** NB_SCIC3 - SCI Control Register 3; 0x00000346 ***
NB_SCIC3:           equ    $00000346                                ;*** NB_SCIC3 - SCI Control Register 3; 0x00000346 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCIC3_PEIE:      equ    0                                         ; Parity Error Interrupt Enable
NB_SCIC3_FEIE:      equ    1                                         ; Framing Error Interrupt Enable
NB_SCIC3_NEIE:      equ    2                                         ; Noise Error Interrupt Enable
NB_SCIC3_ORIE:      equ    3                                         ; Overrun Interrupt Enable
NB_SCIC3_TXINV:     equ    4                                         ; Transmit Data Inversion
NB_SCIC3_TXDIR:     equ    5                                         ; TxD Pin Direction in Single-Wire Mode
NB_SCIC3_T8:        equ    6                                         ; Ninth Data Bit for Transmitter
NB_SCIC3_R8:        equ    7                                         ; Ninth Data Bit for Receiver
; bit position masks
mNB_SCIC3_PEIE:     equ    %00000001
mNB_SCIC3_FEIE:     equ    %00000010
mNB_SCIC3_NEIE:     equ    %00000100
mNB_SCIC3_ORIE:     equ    %00001000
mNB_SCIC3_TXINV:    equ    %00010000
mNB_SCIC3_TXDIR:    equ    %00100000
mNB_SCIC3_T8:       equ    %01000000
mNB_SCIC3_R8:       equ    %10000000


;*** NB_SCID - SCI Data Register; 0x00000347 ***
NB_SCID:            equ    $00000347                                ;*** NB_SCID - SCI Data Register; 0x00000347 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SCID_R0_T0:      equ    0                                         ; Receive/Transmit Data Bit 0
NB_SCID_R1_T1:      equ    1                                         ; Receive/Transmit Data Bit 1
NB_SCID_R2_T2:      equ    2                                         ; Receive/Transmit Data Bit 2
NB_SCID_R3_T3:      equ    3                                         ; Receive/Transmit Data Bit 3
NB_SCID_R4_T4:      equ    4                                         ; Receive/Transmit Data Bit 4
NB_SCID_R5_T5:      equ    5                                         ; Receive/Transmit Data Bit 5
NB_SCID_R6_T6:      equ    6                                         ; Receive/Transmit Data Bit 6
NB_SCID_R7_T7:      equ    7                                         ; Receive/Transmit Data Bit 7
; bit position masks
mNB_SCID_R0_T0:     equ    %00000001
mNB_SCID_R1_T1:     equ    %00000010
mNB_SCID_R2_T2:     equ    %00000100
mNB_SCID_R3_T3:     equ    %00001000
mNB_SCID_R4_T4:     equ    %00010000
mNB_SCID_R5_T5:     equ    %00100000
mNB_SCID_R6_T6:     equ    %01000000
mNB_SCID_R7_T7:     equ    %10000000


;*** NB_PWMCTL - PWM Control Register; 0x00000360 ***
NB_PWMCTL:          equ    $00000360                                ;*** NB_PWMCTL - PWM Control Register; 0x00000360 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMCTL_PWME0:    equ    0                                         ; Pulse Width Channel 0 Enable
NB_PWMCTL_PWME1:    equ    1                                         ; Pulse Width Channel 1 Enable
NB_PWMCTL_PPOL0:    equ    2                                         ; Pulse Width Channel 0 Polarity
NB_PWMCTL_PPOL1:    equ    3                                         ; Pulse Width Channel 1 Polarity
NB_PWMCTL_PCLK0:    equ    4                                         ; Pulse Width Channel 0 Clock Select
NB_PWMCTL_PCLK1:    equ    5                                         ; Pulse Width Channel 1 Clock Select
NB_PWMCTL_CAE0:     equ    6                                         ; Center Aligned Output Modes on Channel 0
NB_PWMCTL_CAE1:     equ    7                                         ; Center Aligned Output Modes on Channel 1
; bit position masks
mNB_PWMCTL_PWME0:   equ    %00000001
mNB_PWMCTL_PWME1:   equ    %00000010
mNB_PWMCTL_PPOL0:   equ    %00000100
mNB_PWMCTL_PPOL1:   equ    %00001000
mNB_PWMCTL_PCLK0:   equ    %00010000
mNB_PWMCTL_PCLK1:   equ    %00100000
mNB_PWMCTL_CAE0:    equ    %01000000
mNB_PWMCTL_CAE1:    equ    %10000000


;*** NB_PWMPRCLK - PWM Prescale Clock Select Register; 0x00000361 ***
NB_PWMPRCLK:        equ    $00000361                                ;*** NB_PWMPRCLK - PWM Prescale Clock Select Register; 0x00000361 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMPRCLK_PCKA0:  equ    0                                         ; Prescaler Select for Clock A Bit 0
NB_PWMPRCLK_PCKA1:  equ    1                                         ; Prescaler Select for Clock A Bit 1
NB_PWMPRCLK_PCKA2:  equ    2                                         ; Prescaler Select for Clock A Bit 2
NB_PWMPRCLK_PCKB0:  equ    4                                         ; Prescaler Select for Clock B Bit 0
NB_PWMPRCLK_PCKB1:  equ    5                                         ; Prescaler Select for Clock B Bit 1
NB_PWMPRCLK_PCKB2:  equ    6                                         ; Prescaler Select for Clock B Bit 2
; bit position masks
mNB_PWMPRCLK_PCKA0: equ    %00000001
mNB_PWMPRCLK_PCKA1: equ    %00000010
mNB_PWMPRCLK_PCKA2: equ    %00000100
mNB_PWMPRCLK_PCKB0: equ    %00010000
mNB_PWMPRCLK_PCKB1: equ    %00100000
mNB_PWMPRCLK_PCKB2: equ    %01000000


;*** NB_PWMSCLA - PWM Scale A Register; 0x00000362 ***
NB_PWMSCLA:         equ    $00000362                                ;*** NB_PWMSCLA - PWM Scale A Register; 0x00000362 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMSCLA_BIT0:    equ    0                                         ; PWM Scale A Bit 0
NB_PWMSCLA_BIT1:    equ    1                                         ; PWM Scale A Bit 1
NB_PWMSCLA_BIT2:    equ    2                                         ; PWM Scale A Bit 2
NB_PWMSCLA_BIT3:    equ    3                                         ; PWM Scale A Bit 3
NB_PWMSCLA_BIT4:    equ    4                                         ; PWM Scale A Bit 4
NB_PWMSCLA_BIT5:    equ    5                                         ; PWM Scale A Bit 5
NB_PWMSCLA_BIT6:    equ    6                                         ; PWM Scale A Bit 6
NB_PWMSCLA_BIT7:    equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mNB_PWMSCLA_BIT0:   equ    %00000001
mNB_PWMSCLA_BIT1:   equ    %00000010
mNB_PWMSCLA_BIT2:   equ    %00000100
mNB_PWMSCLA_BIT3:   equ    %00001000
mNB_PWMSCLA_BIT4:   equ    %00010000
mNB_PWMSCLA_BIT5:   equ    %00100000
mNB_PWMSCLA_BIT6:   equ    %01000000
mNB_PWMSCLA_BIT7:   equ    %10000000


;*** NB_PWMSCLB - PWM Scale B Register; 0x00000363 ***
NB_PWMSCLB:         equ    $00000363                                ;*** NB_PWMSCLB - PWM Scale B Register; 0x00000363 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMSCLB_BIT0:    equ    0                                         ; PWM Scale B Bit 0
NB_PWMSCLB_BIT1:    equ    1                                         ; PWM Scale B Bit 1
NB_PWMSCLB_BIT2:    equ    2                                         ; PWM Scale B Bit 2
NB_PWMSCLB_BIT3:    equ    3                                         ; PWM Scale B Bit 3
NB_PWMSCLB_BIT4:    equ    4                                         ; PWM Scale B Bit 4
NB_PWMSCLB_BIT5:    equ    5                                         ; PWM Scale B Bit 5
NB_PWMSCLB_BIT6:    equ    6                                         ; PWM Scale B Bit 6
NB_PWMSCLB_BIT7:    equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mNB_PWMSCLB_BIT0:   equ    %00000001
mNB_PWMSCLB_BIT1:   equ    %00000010
mNB_PWMSCLB_BIT2:   equ    %00000100
mNB_PWMSCLB_BIT3:   equ    %00001000
mNB_PWMSCLB_BIT4:   equ    %00010000
mNB_PWMSCLB_BIT5:   equ    %00100000
mNB_PWMSCLB_BIT6:   equ    %01000000
mNB_PWMSCLB_BIT7:   equ    %10000000


;*** NB_PWMCNT0 - PWM Channel Counter 0 Register; 0x00000364 ***
NB_PWMCNT0:         equ    $00000364                                ;*** NB_PWMCNT0 - PWM Channel Counter 0 Register; 0x00000364 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMCNT0_PWMCNT00: equ    0                                        ; PWM Channel Counter Bits, bit 0
NB_PWMCNT0_PWMCNT01: equ    1                                        ; PWM Channel Counter Bits, bit 1
NB_PWMCNT0_PWMCNT02: equ    2                                        ; PWM Channel Counter Bits, bit 2
NB_PWMCNT0_PWMCNT03: equ    3                                        ; PWM Channel Counter Bits, bit 3
NB_PWMCNT0_PWMCNT04: equ    4                                        ; PWM Channel Counter Bits, bit 4
NB_PWMCNT0_PWMCNT05: equ    5                                        ; PWM Channel Counter Bits, bit 5
NB_PWMCNT0_PWMCNT06: equ    6                                        ; PWM Channel Counter Bits, bit 6
NB_PWMCNT0_PWMCNT07: equ    7                                        ; PWM Channel Counter Bits, bit 7
; bit position masks
mNB_PWMCNT0_PWMCNT00: equ    %00000001
mNB_PWMCNT0_PWMCNT01: equ    %00000010
mNB_PWMCNT0_PWMCNT02: equ    %00000100
mNB_PWMCNT0_PWMCNT03: equ    %00001000
mNB_PWMCNT0_PWMCNT04: equ    %00010000
mNB_PWMCNT0_PWMCNT05: equ    %00100000
mNB_PWMCNT0_PWMCNT06: equ    %01000000
mNB_PWMCNT0_PWMCNT07: equ    %10000000


;*** NB_PWMCNT1 - PWM Channel Counter 1 Register; 0x00000365 ***
NB_PWMCNT1:         equ    $00000365                                ;*** NB_PWMCNT1 - PWM Channel Counter 1 Register; 0x00000365 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMCNT1_PWMCNT10: equ    0                                        ; PWM Channel Counter Bits, bit 0
NB_PWMCNT1_PWMCNT11: equ    1                                        ; PWM Channel Counter Bits, bit 1
NB_PWMCNT1_PWMCNT12: equ    2                                        ; PWM Channel Counter Bits, bit 2
NB_PWMCNT1_PWMCNT13: equ    3                                        ; PWM Channel Counter Bits, bit 3
NB_PWMCNT1_PWMCNT14: equ    4                                        ; PWM Channel Counter Bits, bit 4
NB_PWMCNT1_PWMCNT15: equ    5                                        ; PWM Channel Counter Bits, bit 5
NB_PWMCNT1_PWMCNT16: equ    6                                        ; PWM Channel Counter Bits, bit 6
NB_PWMCNT1_PWMCNT17: equ    7                                        ; PWM Channel Counter Bits, bit 7
; bit position masks
mNB_PWMCNT1_PWMCNT10: equ    %00000001
mNB_PWMCNT1_PWMCNT11: equ    %00000010
mNB_PWMCNT1_PWMCNT12: equ    %00000100
mNB_PWMCNT1_PWMCNT13: equ    %00001000
mNB_PWMCNT1_PWMCNT14: equ    %00010000
mNB_PWMCNT1_PWMCNT15: equ    %00100000
mNB_PWMCNT1_PWMCNT16: equ    %01000000
mNB_PWMCNT1_PWMCNT17: equ    %10000000


;*** NB_PWMPER0 - PWM Channel Period 0 Register; 0x00000366 ***
NB_PWMPER0:         equ    $00000366                                ;*** NB_PWMPER0 - PWM Channel Period 0 Register; 0x00000366 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMPER0_PWMPER00: equ    0                                        ; PWM Channel Period Bits, bit 0
NB_PWMPER0_PWMPER01: equ    1                                        ; PWM Channel Period Bits, bit 1
NB_PWMPER0_PWMPER02: equ    2                                        ; PWM Channel Period Bits, bit 2
NB_PWMPER0_PWMPER03: equ    3                                        ; PWM Channel Period Bits, bit 3
NB_PWMPER0_PWMPER04: equ    4                                        ; PWM Channel Period Bits, bit 4
NB_PWMPER0_PWMPER05: equ    5                                        ; PWM Channel Period Bits, bit 5
NB_PWMPER0_PWMPER06: equ    6                                        ; PWM Channel Period Bits, bit 6
NB_PWMPER0_PWMPER07: equ    7                                        ; PWM Channel Period Bits, bit 7
; bit position masks
mNB_PWMPER0_PWMPER00: equ    %00000001
mNB_PWMPER0_PWMPER01: equ    %00000010
mNB_PWMPER0_PWMPER02: equ    %00000100
mNB_PWMPER0_PWMPER03: equ    %00001000
mNB_PWMPER0_PWMPER04: equ    %00010000
mNB_PWMPER0_PWMPER05: equ    %00100000
mNB_PWMPER0_PWMPER06: equ    %01000000
mNB_PWMPER0_PWMPER07: equ    %10000000


;*** NB_PWMPER1 - PWM Channel Period 1 Register; 0x00000367 ***
NB_PWMPER1:         equ    $00000367                                ;*** NB_PWMPER1 - PWM Channel Period 1 Register; 0x00000367 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMPER1_PWMPER10: equ    0                                        ; PWM Channel Period Bits, bit 0
NB_PWMPER1_PWMPER11: equ    1                                        ; PWM Channel Period Bits, bit 1
NB_PWMPER1_PWMPER12: equ    2                                        ; PWM Channel Period Bits, bit 2
NB_PWMPER1_PWMPER13: equ    3                                        ; PWM Channel Period Bits, bit 3
NB_PWMPER1_PWMPER14: equ    4                                        ; PWM Channel Period Bits, bit 4
NB_PWMPER1_PWMPER15: equ    5                                        ; PWM Channel Period Bits, bit 5
NB_PWMPER1_PWMPER16: equ    6                                        ; PWM Channel Period Bits, bit 6
NB_PWMPER1_PWMPER17: equ    7                                        ; PWM Channel Period Bits, bit 7
; bit position masks
mNB_PWMPER1_PWMPER10: equ    %00000001
mNB_PWMPER1_PWMPER11: equ    %00000010
mNB_PWMPER1_PWMPER12: equ    %00000100
mNB_PWMPER1_PWMPER13: equ    %00001000
mNB_PWMPER1_PWMPER14: equ    %00010000
mNB_PWMPER1_PWMPER15: equ    %00100000
mNB_PWMPER1_PWMPER16: equ    %01000000
mNB_PWMPER1_PWMPER17: equ    %10000000


;*** NB_PWMDTY0 - PWM Channel Duty 0 Register; 0x00000368 ***
NB_PWMDTY0:         equ    $00000368                                ;*** NB_PWMDTY0 - PWM Channel Duty 0 Register; 0x00000368 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMDTY0_PWMDTY00: equ    0                                        ; PWM Channel Duty Bits, bit 0
NB_PWMDTY0_PWMDTY01: equ    1                                        ; PWM Channel Duty Bits, bit 1
NB_PWMDTY0_PWMDTY02: equ    2                                        ; PWM Channel Duty Bits, bit 2
NB_PWMDTY0_PWMDTY03: equ    3                                        ; PWM Channel Duty Bits, bit 3
NB_PWMDTY0_PWMDTY04: equ    4                                        ; PWM Channel Duty Bits, bit 4
NB_PWMDTY0_PWMDTY05: equ    5                                        ; PWM Channel Duty Bits, bit 5
NB_PWMDTY0_PWMDTY06: equ    6                                        ; PWM Channel Duty Bits, bit 6
NB_PWMDTY0_PWMDTY07: equ    7                                        ; PWM Channel Duty Bits, bit 7
; bit position masks
mNB_PWMDTY0_PWMDTY00: equ    %00000001
mNB_PWMDTY0_PWMDTY01: equ    %00000010
mNB_PWMDTY0_PWMDTY02: equ    %00000100
mNB_PWMDTY0_PWMDTY03: equ    %00001000
mNB_PWMDTY0_PWMDTY04: equ    %00010000
mNB_PWMDTY0_PWMDTY05: equ    %00100000
mNB_PWMDTY0_PWMDTY06: equ    %01000000
mNB_PWMDTY0_PWMDTY07: equ    %10000000


;*** NB_PWMDTY1 - PWM Channel Duty 1 Register; 0x00000369 ***
NB_PWMDTY1:         equ    $00000369                                ;*** NB_PWMDTY1 - PWM Channel Duty 1 Register; 0x00000369 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_PWMDTY1_PWMDTY10: equ    0                                        ; PWM Channel Duty Bits, bit 0
NB_PWMDTY1_PWMDTY11: equ    1                                        ; PWM Channel Duty Bits, bit 1
NB_PWMDTY1_PWMDTY12: equ    2                                        ; PWM Channel Duty Bits, bit 2
NB_PWMDTY1_PWMDTY13: equ    3                                        ; PWM Channel Duty Bits, bit 3
NB_PWMDTY1_PWMDTY14: equ    4                                        ; PWM Channel Duty Bits, bit 4
NB_PWMDTY1_PWMDTY15: equ    5                                        ; PWM Channel Duty Bits, bit 5
NB_PWMDTY1_PWMDTY16: equ    6                                        ; PWM Channel Duty Bits, bit 6
NB_PWMDTY1_PWMDTY17: equ    7                                        ; PWM Channel Duty Bits, bit 7
; bit position masks
mNB_PWMDTY1_PWMDTY10: equ    %00000001
mNB_PWMDTY1_PWMDTY11: equ    %00000010
mNB_PWMDTY1_PWMDTY12: equ    %00000100
mNB_PWMDTY1_PWMDTY13: equ    %00001000
mNB_PWMDTY1_PWMDTY14: equ    %00010000
mNB_PWMDTY1_PWMDTY15: equ    %00100000
mNB_PWMDTY1_PWMDTY16: equ    %01000000
mNB_PWMDTY1_PWMDTY17: equ    %10000000


;*** NB_ACR - ADC Config Register; 0x00000380 ***
NB_ACR:             equ    $00000380                                ;*** NB_ACR - ADC Config Register; 0x00000380 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACR_PS:          equ    0                                         ; ADC Clock Prescaler Select 0
NB_ACR_ADCRST:      equ    4                                         ; Analog Digital Converter RESET
NB_ACR_OCE:         equ    5                                         ; Offset Compensation Enable
NB_ACR_CCE:         equ    6                                         ; Continuous Conversion Enable
NB_ACR_SCIE:        equ    7                                         ; Sequence Complete Interrupt Enable
; bit position masks
mNB_ACR_PS:         equ    %00000111
mNB_ACR_ADCRST:     equ    %00010000
mNB_ACR_OCE:        equ    %00100000
mNB_ACR_CCE:        equ    %01000000
mNB_ACR_SCIE:       equ    %10000000


;*** NB_ASR - ADC Status Register; 0x00000381 ***
NB_ASR:             equ    $00000381                                ;*** NB_ASR - ADC Status Register; 0x00000381 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ASR_CCNT:        equ    0                                         ; Conversion Counter Status 0
NB_ASR_2p5CLF:      equ    6                                         ; ADC Reference Voltage Current Limitation Flag
NB_ASR_SCF:         equ    7                                         ; Sequence Complete Flag
; bit position masks
mNB_ASR_CCNT:       equ    %00001111
mNB_ASR_2p5CLF:     equ    %01000000
mNB_ASR_SCF:        equ    %10000000


;*** NB_ACCR - ADC Conversion Control Register; 0x00000382 ***
NB_ACCR:            equ    $00000382                                ;*** NB_ACCR - ADC Conversion Control Register; 0x00000382 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACCR_CH0:        equ    0                                         ; Channel Select 0
NB_ACCR_CH1:        equ    1                                         ; Channel Select 1
NB_ACCR_CH2:        equ    2                                         ; Channel Select 2
NB_ACCR_CH3:        equ    3                                         ; Channel Select 3
NB_ACCR_CH4:        equ    4                                         ; Channel Select 4
NB_ACCR_CH5:        equ    5                                         ; Channel Select 5
NB_ACCR_CH6:        equ    6                                         ; Channel Select 6
NB_ACCR_CH7:        equ    7                                         ; Channel Select 7
NB_ACCR_CH8:        equ    8                                         ; Channel Select 8
NB_ACCR_CH9:        equ    9                                         ; Channel Select 9
NB_ACCR_CH10:       equ    10                                        ; Channel Select 10
NB_ACCR_CH11:       equ    11                                        ; Channel Select 11
NB_ACCR_CH12:       equ    12                                        ; Channel Select 12
NB_ACCR_CH14:       equ    14                                        ; Channel Select 14
NB_ACCR_CH15:       equ    15                                        ; Channel Select 15
; bit position masks
mNB_ACCR_CH0:       equ    %00000001
mNB_ACCR_CH1:       equ    %00000010
mNB_ACCR_CH2:       equ    %00000100
mNB_ACCR_CH3:       equ    %00001000
mNB_ACCR_CH4:       equ    %00010000
mNB_ACCR_CH5:       equ    %00100000
mNB_ACCR_CH6:       equ    %01000000
mNB_ACCR_CH7:       equ    %10000000
mNB_ACCR_CH8:       equ    %100000000
mNB_ACCR_CH9:       equ    %1000000000
mNB_ACCR_CH10:      equ    %10000000000
mNB_ACCR_CH11:      equ    %100000000000
mNB_ACCR_CH12:      equ    %1000000000000
mNB_ACCR_CH14:      equ    %100000000000000
mNB_ACCR_CH15:      equ    %1000000000000000


;*** NB_ACCRhi - ADC Conversion Control Register High; 0x00000382 ***
NB_ACCRhi:          equ    $00000382                                ;*** NB_ACCRhi - ADC Conversion Control Register High; 0x00000382 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACCRhi_CH8:      equ    0                                         ; Channel Select 8
NB_ACCRhi_CH9:      equ    1                                         ; Channel Select 9
NB_ACCRhi_CH10:     equ    2                                         ; Channel Select 10
NB_ACCRhi_CH11:     equ    3                                         ; Channel Select 11
NB_ACCRhi_CH12:     equ    4                                         ; Channel Select 12
NB_ACCRhi_CH14:     equ    6                                         ; Channel Select 14
NB_ACCRhi_CH15:     equ    7                                         ; Channel Select 15
; bit position masks
mNB_ACCRhi_CH8:     equ    %00000001
mNB_ACCRhi_CH9:     equ    %00000010
mNB_ACCRhi_CH10:    equ    %00000100
mNB_ACCRhi_CH11:    equ    %00001000
mNB_ACCRhi_CH12:    equ    %00010000
mNB_ACCRhi_CH14:    equ    %01000000
mNB_ACCRhi_CH15:    equ    %10000000


;*** NB_ACCRlo - ADC Conversion Control Register Low; 0x00000383 ***
NB_ACCRlo:          equ    $00000383                                ;*** NB_ACCRlo - ADC Conversion Control Register Low; 0x00000383 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACCRlo_CH0:      equ    0                                         ; Channel Select 0
NB_ACCRlo_CH1:      equ    1                                         ; Channel Select 1
NB_ACCRlo_CH2:      equ    2                                         ; Channel Select 2
NB_ACCRlo_CH3:      equ    3                                         ; Channel Select 3
NB_ACCRlo_CH4:      equ    4                                         ; Channel Select 4
NB_ACCRlo_CH5:      equ    5                                         ; Channel Select 5
NB_ACCRlo_CH6:      equ    6                                         ; Channel Select 6
NB_ACCRlo_CH7:      equ    7                                         ; Channel Select 7
; bit position masks
mNB_ACCRlo_CH0:     equ    %00000001
mNB_ACCRlo_CH1:     equ    %00000010
mNB_ACCRlo_CH2:     equ    %00000100
mNB_ACCRlo_CH3:     equ    %00001000
mNB_ACCRlo_CH4:     equ    %00010000
mNB_ACCRlo_CH5:     equ    %00100000
mNB_ACCRlo_CH6:     equ    %01000000
mNB_ACCRlo_CH7:     equ    %10000000


;*** NB_ACCSR - ADC Conversion Complete Status Register; 0x00000384 ***
NB_ACCSR:           equ    $00000384                                ;*** NB_ACCSR - ADC Conversion Complete Status Register; 0x00000384 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACCSR_CC0:       equ    0                                         ; Conversion Complete Flag 0
NB_ACCSR_CC1:       equ    1                                         ; Conversion Complete Flag 1
NB_ACCSR_CC2:       equ    2                                         ; Conversion Complete Flag 2
NB_ACCSR_CC3:       equ    3                                         ; Conversion Complete Flag 3
NB_ACCSR_CC4:       equ    4                                         ; Conversion Complete Flag 4
NB_ACCSR_CC5:       equ    5                                         ; Conversion Complete Flag 5
NB_ACCSR_CC6:       equ    6                                         ; Conversion Complete Flag 6
NB_ACCSR_CC7:       equ    7                                         ; Conversion Complete Flag 7
NB_ACCSR_CC8:       equ    8                                         ; Conversion Complete Flag 8
NB_ACCSR_CC9:       equ    9                                         ; Conversion Complete Flag 9
NB_ACCSR_CC10:      equ    10                                        ; Conversion Complete Flag 10
NB_ACCSR_CC11:      equ    11                                        ; Conversion Complete Flag 11
NB_ACCSR_CC12:      equ    12                                        ; Conversion Complete Flag 12
NB_ACCSR_CC14:      equ    14                                        ; Conversion Complete Flag 14
NB_ACCSR_CC15:      equ    15                                        ; Conversion Complete Flag 15
; bit position masks
mNB_ACCSR_CC0:      equ    %00000001
mNB_ACCSR_CC1:      equ    %00000010
mNB_ACCSR_CC2:      equ    %00000100
mNB_ACCSR_CC3:      equ    %00001000
mNB_ACCSR_CC4:      equ    %00010000
mNB_ACCSR_CC5:      equ    %00100000
mNB_ACCSR_CC6:      equ    %01000000
mNB_ACCSR_CC7:      equ    %10000000
mNB_ACCSR_CC8:      equ    %100000000
mNB_ACCSR_CC9:      equ    %1000000000
mNB_ACCSR_CC10:     equ    %10000000000
mNB_ACCSR_CC11:     equ    %100000000000
mNB_ACCSR_CC12:     equ    %1000000000000
mNB_ACCSR_CC14:     equ    %100000000000000
mNB_ACCSR_CC15:     equ    %1000000000000000


;*** NB_ACCSRhi - ADC Conversion Complete Status Register High; 0x00000384 ***
NB_ACCSRhi:         equ    $00000384                                ;*** NB_ACCSRhi - ADC Conversion Complete Status Register High; 0x00000384 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACCSRhi_CC8:     equ    0                                         ; Conversion Complete Flag 8
NB_ACCSRhi_CC9:     equ    1                                         ; Conversion Complete Flag 9
NB_ACCSRhi_CC10:    equ    2                                         ; Conversion Complete Flag 10
NB_ACCSRhi_CC11:    equ    3                                         ; Conversion Complete Flag 11
NB_ACCSRhi_CC12:    equ    4                                         ; Conversion Complete Flag 12
NB_ACCSRhi_CC14:    equ    6                                         ; Conversion Complete Flag 14
NB_ACCSRhi_CC15:    equ    7                                         ; Conversion Complete Flag 15
; bit position masks
mNB_ACCSRhi_CC8:    equ    %00000001
mNB_ACCSRhi_CC9:    equ    %00000010
mNB_ACCSRhi_CC10:   equ    %00000100
mNB_ACCSRhi_CC11:   equ    %00001000
mNB_ACCSRhi_CC12:   equ    %00010000
mNB_ACCSRhi_CC14:   equ    %01000000
mNB_ACCSRhi_CC15:   equ    %10000000


;*** NB_ACCSRlo - ADC Conversion Complete Status Register Low; 0x00000385 ***
NB_ACCSRlo:         equ    $00000385                                ;*** NB_ACCSRlo - ADC Conversion Complete Status Register Low; 0x00000385 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ACCSRlo_CC0:     equ    0                                         ; Conversion Complete Flag 0
NB_ACCSRlo_CC1:     equ    1                                         ; Conversion Complete Flag 1
NB_ACCSRlo_CC2:     equ    2                                         ; Conversion Complete Flag 2
NB_ACCSRlo_CC3:     equ    3                                         ; Conversion Complete Flag 3
NB_ACCSRlo_CC4:     equ    4                                         ; Conversion Complete Flag 4
NB_ACCSRlo_CC5:     equ    5                                         ; Conversion Complete Flag 5
NB_ACCSRlo_CC6:     equ    6                                         ; Conversion Complete Flag 6
NB_ACCSRlo_CC7:     equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mNB_ACCSRlo_CC0:    equ    %00000001
mNB_ACCSRlo_CC1:    equ    %00000010
mNB_ACCSRlo_CC2:    equ    %00000100
mNB_ACCSRlo_CC3:    equ    %00001000
mNB_ACCSRlo_CC4:    equ    %00010000
mNB_ACCSRlo_CC5:    equ    %00100000
mNB_ACCSRlo_CC6:    equ    %01000000
mNB_ACCSRlo_CC7:    equ    %10000000


;*** NB_ADR0 - ADC Data Result Register 0; 0x00000386 ***
NB_ADR0:            equ    $00000386                                ;*** NB_ADR0 - ADC Data Result Register 0; 0x00000386 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR0_ADR0:       equ    6                                         ; ADC Channel 0 Result Bit 0
; bit position masks
mNB_ADR0_ADR0:      equ    %1111111111000000


;*** NB_ADR0hi - ADC Data Result Register 0 High; 0x00000386 ***
NB_ADR0hi:          equ    $00000386                                ;*** NB_ADR0hi - ADC Data Result Register 0 High; 0x00000386 ***


;*** NB_ADR0lo - ADC Data Result Register 0 Low; 0x00000387 ***
NB_ADR0lo:          equ    $00000387                                ;*** NB_ADR0lo - ADC Data Result Register 0 Low; 0x00000387 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR0lo_ADR0:     equ    6                                         ; ADC Channel 0 Result Bit 0
; bit position masks
mNB_ADR0lo_ADR0:    equ    %11000000


;*** NB_ADR1 - ADC Data Result Register 1; 0x00000388 ***
NB_ADR1:            equ    $00000388                                ;*** NB_ADR1 - ADC Data Result Register 1; 0x00000388 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR1_ADR1:       equ    6                                         ; ADC Channel 1 Result Bit 0
; bit position masks
mNB_ADR1_ADR1:      equ    %1111111111000000


;*** NB_ADR1hi - ADC Data Result Register 1 High; 0x00000388 ***
NB_ADR1hi:          equ    $00000388                                ;*** NB_ADR1hi - ADC Data Result Register 1 High; 0x00000388 ***


;*** NB_ADR1lo - ADC Data Result Register 1 Low; 0x00000389 ***
NB_ADR1lo:          equ    $00000389                                ;*** NB_ADR1lo - ADC Data Result Register 1 Low; 0x00000389 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR1lo_ADR1:     equ    6                                         ; ADC Channel 1 Result Bit 0
; bit position masks
mNB_ADR1lo_ADR1:    equ    %11000000


;*** NB_ADR2 - ADC Data Result Register 2; 0x0000038A ***
NB_ADR2:            equ    $0000038A                                ;*** NB_ADR2 - ADC Data Result Register 2; 0x0000038A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR2_ADR2:       equ    6                                         ; ADC Channel 2 Result Bit 0
; bit position masks
mNB_ADR2_ADR2:      equ    %1111111111000000


;*** NB_ADR2hi - ADC Data Result Register 2 High; 0x0000038A ***
NB_ADR2hi:          equ    $0000038A                                ;*** NB_ADR2hi - ADC Data Result Register 2 High; 0x0000038A ***


;*** NB_ADR2lo - ADC Data Result Register 2 Low; 0x0000038B ***
NB_ADR2lo:          equ    $0000038B                                ;*** NB_ADR2lo - ADC Data Result Register 2 Low; 0x0000038B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR2lo_ADR2:     equ    6                                         ; ADC Channel 2 Result Bit 0
; bit position masks
mNB_ADR2lo_ADR2:    equ    %11000000


;*** NB_ADR3 - ADC Data Result Register 3; 0x0000038C ***
NB_ADR3:            equ    $0000038C                                ;*** NB_ADR3 - ADC Data Result Register 3; 0x0000038C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR3_ADR3:       equ    6                                         ; ADC Channel 3 Result Bit 0
; bit position masks
mNB_ADR3_ADR3:      equ    %1111111111000000


;*** NB_ADR3hi - ADC Data Result Register 3 High; 0x0000038C ***
NB_ADR3hi:          equ    $0000038C                                ;*** NB_ADR3hi - ADC Data Result Register 3 High; 0x0000038C ***


;*** NB_ADR3lo - ADC Data Result Register 3 Low; 0x0000038D ***
NB_ADR3lo:          equ    $0000038D                                ;*** NB_ADR3lo - ADC Data Result Register 3 Low; 0x0000038D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR3lo_ADR3:     equ    6                                         ; ADC Channel 3 Result Bit 0
; bit position masks
mNB_ADR3lo_ADR3:    equ    %11000000


;*** NB_ADR4 - ADC Data Result Register 4; 0x0000038E ***
NB_ADR4:            equ    $0000038E                                ;*** NB_ADR4 - ADC Data Result Register 4; 0x0000038E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR4_ADR4:       equ    6                                         ; ADC Channel 4 Result Bit 0
; bit position masks
mNB_ADR4_ADR4:      equ    %1111111111000000


;*** NB_ADR4hi - ADC Data Result Register 4 High; 0x0000038E ***
NB_ADR4hi:          equ    $0000038E                                ;*** NB_ADR4hi - ADC Data Result Register 4 High; 0x0000038E ***


;*** NB_ADR4lo - ADC Data Result Register 4 Low; 0x0000038F ***
NB_ADR4lo:          equ    $0000038F                                ;*** NB_ADR4lo - ADC Data Result Register 4 Low; 0x0000038F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR4lo_ADR4:     equ    6                                         ; ADC Channel 4 Result Bit 0
; bit position masks
mNB_ADR4lo_ADR4:    equ    %11000000


;*** NB_ADR5 - ADC Data Result Register 5; 0x00000390 ***
NB_ADR5:            equ    $00000390                                ;*** NB_ADR5 - ADC Data Result Register 5; 0x00000390 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR5_ADR5:       equ    6                                         ; ADC Channel 5 Result Bit 0
; bit position masks
mNB_ADR5_ADR5:      equ    %1111111111000000


;*** NB_ADR5hi - ADC Data Result Register 5 High; 0x00000390 ***
NB_ADR5hi:          equ    $00000390                                ;*** NB_ADR5hi - ADC Data Result Register 5 High; 0x00000390 ***


;*** NB_ADR5lo - ADC Data Result Register 5 Low; 0x00000391 ***
NB_ADR5lo:          equ    $00000391                                ;*** NB_ADR5lo - ADC Data Result Register 5 Low; 0x00000391 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR5lo_ADR5:     equ    6                                         ; ADC Channel 5 Result Bit 0
; bit position masks
mNB_ADR5lo_ADR5:    equ    %11000000


;*** NB_ADR6 - ADC Data Result Register 6; 0x00000392 ***
NB_ADR6:            equ    $00000392                                ;*** NB_ADR6 - ADC Data Result Register 6; 0x00000392 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR6_ADR6:       equ    6                                         ; ADC Channel 6 Result Bit 0
; bit position masks
mNB_ADR6_ADR6:      equ    %1111111111000000


;*** NB_ADR6hi - ADC Data Result Register 6 High; 0x00000392 ***
NB_ADR6hi:          equ    $00000392                                ;*** NB_ADR6hi - ADC Data Result Register 6 High; 0x00000392 ***


;*** NB_ADR6lo - ADC Data Result Register 6 Low; 0x00000393 ***
NB_ADR6lo:          equ    $00000393                                ;*** NB_ADR6lo - ADC Data Result Register 6 Low; 0x00000393 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR6lo_ADR6:     equ    6                                         ; ADC Channel 6 Result Bit 0
; bit position masks
mNB_ADR6lo_ADR6:    equ    %11000000


;*** NB_ADR7 - ADC Data Result Register 7; 0x00000394 ***
NB_ADR7:            equ    $00000394                                ;*** NB_ADR7 - ADC Data Result Register 7; 0x00000394 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR7_ADR7:       equ    6                                         ; ADC Channel 7 Result Bit 0
; bit position masks
mNB_ADR7_ADR7:      equ    %1111111111000000


;*** NB_ADR7hi - ADC Data Result Register 7 High; 0x00000394 ***
NB_ADR7hi:          equ    $00000394                                ;*** NB_ADR7hi - ADC Data Result Register 7 High; 0x00000394 ***


;*** NB_ADR7lo - ADC Data Result Register 7 Low; 0x00000395 ***
NB_ADR7lo:          equ    $00000395                                ;*** NB_ADR7lo - ADC Data Result Register 7 Low; 0x00000395 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR7lo_ADR7:     equ    6                                         ; ADC Channel 7 Result Bit 0
; bit position masks
mNB_ADR7lo_ADR7:    equ    %11000000


;*** NB_ADR8 - ADC Data Result Register 8; 0x00000396 ***
NB_ADR8:            equ    $00000396                                ;*** NB_ADR8 - ADC Data Result Register 8; 0x00000396 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR8_ADR8:       equ    6                                         ; ADC Channel 8 Result Bit 0
; bit position masks
mNB_ADR8_ADR8:      equ    %1111111111000000


;*** NB_ADR8hi - ADC Data Result Register 8 High; 0x00000396 ***
NB_ADR8hi:          equ    $00000396                                ;*** NB_ADR8hi - ADC Data Result Register 8 High; 0x00000396 ***


;*** NB_ADR8lo - ADC Data Result Register 8 Low; 0x00000397 ***
NB_ADR8lo:          equ    $00000397                                ;*** NB_ADR8lo - ADC Data Result Register 8 Low; 0x00000397 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR8lo_ADR8:     equ    6                                         ; ADC Channel 8 Result Bit 0
; bit position masks
mNB_ADR8lo_ADR8:    equ    %11000000


;*** NB_ADR9 - ADC Data Result Register 9; 0x00000398 ***
NB_ADR9:            equ    $00000398                                ;*** NB_ADR9 - ADC Data Result Register 9; 0x00000398 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR9_ADR9:       equ    6                                         ; ADC Channel 9 Result Bit 0
; bit position masks
mNB_ADR9_ADR9:      equ    %1111111111000000


;*** NB_ADR9hi - ADC Data Result Register 9 High; 0x00000398 ***
NB_ADR9hi:          equ    $00000398                                ;*** NB_ADR9hi - ADC Data Result Register 9 High; 0x00000398 ***


;*** NB_ADR9lo - ADC Data Result Register 9 Low; 0x00000399 ***
NB_ADR9lo:          equ    $00000399                                ;*** NB_ADR9lo - ADC Data Result Register 9 Low; 0x00000399 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR9lo_ADR9:     equ    6                                         ; ADC Channel 9 Result Bit 0
; bit position masks
mNB_ADR9lo_ADR9:    equ    %11000000


;*** NB_ADR10 - ADC Data Result Register 10; 0x0000039A ***
NB_ADR10:           equ    $0000039A                                ;*** NB_ADR10 - ADC Data Result Register 10; 0x0000039A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR10_ADR10:     equ    6                                         ; ADC Channel 10 Result Bit 0
; bit position masks
mNB_ADR10_ADR10:    equ    %1111111111000000


;*** NB_ADR10hi - ADC Data Result Register 10 High; 0x0000039A ***
NB_ADR10hi:         equ    $0000039A                                ;*** NB_ADR10hi - ADC Data Result Register 10 High; 0x0000039A ***


;*** NB_ADR10lo - ADC Data Result Register 10 Low; 0x0000039B ***
NB_ADR10lo:         equ    $0000039B                                ;*** NB_ADR10lo - ADC Data Result Register 10 Low; 0x0000039B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR10lo_ADR10:   equ    6                                         ; ADC Channel 10 Result Bit 0
; bit position masks
mNB_ADR10lo_ADR10:  equ    %11000000


;*** NB_ADR11 - ADC Data Result Register 11; 0x0000039C ***
NB_ADR11:           equ    $0000039C                                ;*** NB_ADR11 - ADC Data Result Register 11; 0x0000039C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR11_ADR11:     equ    6                                         ; ADC Channel 11 Result Bit 0
; bit position masks
mNB_ADR11_ADR11:    equ    %1111111111000000


;*** NB_ADR11hi - ADC Data Result Register 11 High; 0x0000039C ***
NB_ADR11hi:         equ    $0000039C                                ;*** NB_ADR11hi - ADC Data Result Register 11 High; 0x0000039C ***


;*** NB_ADR11lo - ADC Data Result Register 11 Low; 0x0000039D ***
NB_ADR11lo:         equ    $0000039D                                ;*** NB_ADR11lo - ADC Data Result Register 11 Low; 0x0000039D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR11lo_ADR11:   equ    6                                         ; ADC Channel 11 Result Bit 0
; bit position masks
mNB_ADR11lo_ADR11:  equ    %11000000


;*** NB_ADR12 - ADC Data Result Register 12; 0x0000039E ***
NB_ADR12:           equ    $0000039E                                ;*** NB_ADR12 - ADC Data Result Register 12; 0x0000039E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR12_ADR12:     equ    6                                         ; ADC Channel 12 Result Bit 0
; bit position masks
mNB_ADR12_ADR12:    equ    %1111111111000000


;*** NB_ADR12hi - ADC Data Result Register 12 High; 0x0000039E ***
NB_ADR12hi:         equ    $0000039E                                ;*** NB_ADR12hi - ADC Data Result Register 12 High; 0x0000039E ***


;*** NB_ADR12lo - ADC Data Result Register 12 Low; 0x0000039F ***
NB_ADR12lo:         equ    $0000039F                                ;*** NB_ADR12lo - ADC Data Result Register 12 Low; 0x0000039F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR12lo_ADR12:   equ    6                                         ; ADC Channel 12 Result Bit 0
; bit position masks
mNB_ADR12lo_ADR12:  equ    %11000000


;*** NB_ADR13 - ADC Data Result Register 13; 0x000003A0 ***
NB_ADR13:           equ    $000003A0                                ;*** NB_ADR13 - ADC Data Result Register 13; 0x000003A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR13_ADR13:     equ    6                                         ; ADC Channel 13 Result Bit 0
; bit position masks
mNB_ADR13_ADR13:    equ    %1111111111000000


;*** NB_ADR13hi - ADC Data Result Register 13 High; 0x000003A0 ***
NB_ADR13hi:         equ    $000003A0                                ;*** NB_ADR13hi - ADC Data Result Register 13 High; 0x000003A0 ***


;*** NB_ADR13lo - ADC Data Result Register 13 Low; 0x000003A1 ***
NB_ADR13lo:         equ    $000003A1                                ;*** NB_ADR13lo - ADC Data Result Register 13 Low; 0x000003A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR13lo_ADR13:   equ    6                                         ; ADC Channel 13 Result Bit 0
; bit position masks
mNB_ADR13lo_ADR13:  equ    %11000000


;*** NB_ADR14 - ADC Data Result Register 14; 0x000003A2 ***
NB_ADR14:           equ    $000003A2                                ;*** NB_ADR14 - ADC Data Result Register 14; 0x000003A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR14_ADR14:     equ    6                                         ; ADC Channel 14 Result Bit 0
; bit position masks
mNB_ADR14_ADR14:    equ    %1111111111000000


;*** NB_ADR14hi - ADC Data Result Register 14 High; 0x000003A2 ***
NB_ADR14hi:         equ    $000003A2                                ;*** NB_ADR14hi - ADC Data Result Register 14 High; 0x000003A2 ***


;*** NB_ADR14lo - ADC Data Result Register 14 Low; 0x000003A3 ***
NB_ADR14lo:         equ    $000003A3                                ;*** NB_ADR14lo - ADC Data Result Register 14 Low; 0x000003A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR14lo_ADR14:   equ    6                                         ; ADC Channel 14 Result Bit 0
; bit position masks
mNB_ADR14lo_ADR14:  equ    %11000000


;*** NB_ADR15 - ADC Data Result Register 15; 0x000003A4 ***
NB_ADR15:           equ    $000003A4                                ;*** NB_ADR15 - ADC Data Result Register 15; 0x000003A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR15_ADR15:     equ    6                                         ; ADC Channel 15 Result Bit 0
; bit position masks
mNB_ADR15_ADR15:    equ    %1111111111000000


;*** NB_ADR15hi - ADC Data Result Register 15 High; 0x000003A4 ***
NB_ADR15hi:         equ    $000003A4                                ;*** NB_ADR15hi - ADC Data Result Register 15 High; 0x000003A4 ***


;*** NB_ADR15lo - ADC Data Result Register 15 Low; 0x000003A5 ***
NB_ADR15lo:         equ    $000003A5                                ;*** NB_ADR15lo - ADC Data Result Register 15 Low; 0x000003A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_ADR15lo_ADR15:   equ    6                                         ; ADC Channel 15 Result Bit 0
; bit position masks
mNB_ADR15lo_ADR15:  equ    %11000000


;*** NB_TIOS - Timer Input Capture/Output Compare Select; 0x000003C0 ***
NB_TIOS:            equ    $000003C0                                ;*** NB_TIOS - Timer Input Capture/Output Compare Select; 0x000003C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TIOS_IOS0:       equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
NB_TIOS_IOS1:       equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
NB_TIOS_IOS2:       equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
NB_TIOS_IOS3:       equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
; bit position masks
mNB_TIOS_IOS0:      equ    %00000001
mNB_TIOS_IOS1:      equ    %00000010
mNB_TIOS_IOS2:      equ    %00000100
mNB_TIOS_IOS3:      equ    %00001000


;*** NB_CFORC - Timer Compare Force Register; 0x000003C1 ***
NB_CFORC:           equ    $000003C1                                ;*** NB_CFORC - Timer Compare Force Register; 0x000003C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_CFORC_FOC0:      equ    0                                         ; Force Output Compare Action for Channel 0
NB_CFORC_FOC1:      equ    1                                         ; Force Output Compare Action for Channel 1
NB_CFORC_FOC2:      equ    2                                         ; Force Output Compare Action for Channel 2
NB_CFORC_FOC3:      equ    3                                         ; Force Output Compare Action for Channel 3
; bit position masks
mNB_CFORC_FOC0:     equ    %00000001
mNB_CFORC_FOC1:     equ    %00000010
mNB_CFORC_FOC2:     equ    %00000100
mNB_CFORC_FOC3:     equ    %00001000


;*** NB_OC3M - Output Compare 3 Mask Register; 0x000003C2 ***
NB_OC3M:            equ    $000003C2                                ;*** NB_OC3M - Output Compare 3 Mask Register; 0x000003C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_OC3M_OC3M0:      equ    0                                         ; Output Compare 3 Mask Bit 0
NB_OC3M_OC3M1:      equ    1                                         ; Output Compare 3 Mask Bit 1
NB_OC3M_OC3M2:      equ    2                                         ; Output Compare 3 Mask Bit 2
NB_OC3M_OC3M3:      equ    3                                         ; Output Compare 3 Mask Bit 3
; bit position masks
mNB_OC3M_OC3M0:     equ    %00000001
mNB_OC3M_OC3M1:     equ    %00000010
mNB_OC3M_OC3M2:     equ    %00000100
mNB_OC3M_OC3M3:     equ    %00001000


;*** NB_OC3D - Output Compare 3 Data Register; 0x000003C3 ***
NB_OC3D:            equ    $000003C3                                ;*** NB_OC3D - Output Compare 3 Data Register; 0x000003C3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_OC3D_OC3D0:      equ    0                                         ; Output Compare 3 Bit 0
NB_OC3D_OC3D1:      equ    1                                         ; Output Compare 3 Bit 1
NB_OC3D_OC3D2:      equ    2                                         ; Output Compare 3 Bit 2
NB_OC3D_OC3D3:      equ    3                                         ; Output Compare 3 Bit 3
; bit position masks
mNB_OC3D_OC3D0:     equ    %00000001
mNB_OC3D_OC3D1:     equ    %00000010
mNB_OC3D_OC3D2:     equ    %00000100
mNB_OC3D_OC3D3:     equ    %00001000


;*** NB_TCNT - Timer Count Register; 0x000003C4 ***
NB_TCNT:            equ    $000003C4                                ;*** NB_TCNT - Timer Count Register; 0x000003C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCNT_BIT0:       equ    0                                         ; Timer Count Register Bit 0
NB_TCNT_BIT1:       equ    1                                         ; Timer Count Register Bit 1
NB_TCNT_BIT2:       equ    2                                         ; Timer Count Register Bit 2
NB_TCNT_BIT3:       equ    3                                         ; Timer Count Register Bit 3
NB_TCNT_BIT4:       equ    4                                         ; Timer Count Register Bit 4
NB_TCNT_BIT5:       equ    5                                         ; Timer Count Register Bit 5
NB_TCNT_BIT6:       equ    6                                         ; Timer Count Register Bit 6
NB_TCNT_BIT7:       equ    7                                         ; Timer Count Register Bit 7
NB_TCNT_BIT8:       equ    8                                         ; Timer Count Register Bit 8
NB_TCNT_BIT9:       equ    9                                         ; Timer Count Register Bit 9
NB_TCNT_BIT10:      equ    10                                        ; Timer Count Register Bit 10
NB_TCNT_BIT11:      equ    11                                        ; Timer Count Register Bit 11
NB_TCNT_BIT12:      equ    12                                        ; Timer Count Register Bit 12
NB_TCNT_BIT13:      equ    13                                        ; Timer Count Register Bit 13
NB_TCNT_BIT14:      equ    14                                        ; Timer Count Register Bit 14
NB_TCNT_BIT15:      equ    15                                        ; Timer Count Register Bit 15
; bit position masks
mNB_TCNT_BIT0:      equ    %00000001
mNB_TCNT_BIT1:      equ    %00000010
mNB_TCNT_BIT2:      equ    %00000100
mNB_TCNT_BIT3:      equ    %00001000
mNB_TCNT_BIT4:      equ    %00010000
mNB_TCNT_BIT5:      equ    %00100000
mNB_TCNT_BIT6:      equ    %01000000
mNB_TCNT_BIT7:      equ    %10000000
mNB_TCNT_BIT8:      equ    %100000000
mNB_TCNT_BIT9:      equ    %1000000000
mNB_TCNT_BIT10:     equ    %10000000000
mNB_TCNT_BIT11:     equ    %100000000000
mNB_TCNT_BIT12:     equ    %1000000000000
mNB_TCNT_BIT13:     equ    %10000000000000
mNB_TCNT_BIT14:     equ    %100000000000000
mNB_TCNT_BIT15:     equ    %1000000000000000


;*** NB_TCNTHi - Timer Count Register High; 0x000003C4 ***
NB_TCNTHi:          equ    $000003C4                                ;*** NB_TCNTHi - Timer Count Register High; 0x000003C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCNTHi_BIT8:     equ    0                                         ; Timer Count Register Bit 8
NB_TCNTHi_BIT9:     equ    1                                         ; Timer Count Register Bit 9
NB_TCNTHi_BIT10:    equ    2                                         ; Timer Count Register Bit 10
NB_TCNTHi_BIT11:    equ    3                                         ; Timer Count Register Bit 11
NB_TCNTHi_BIT12:    equ    4                                         ; Timer Count Register Bit 12
NB_TCNTHi_BIT13:    equ    5                                         ; Timer Count Register Bit 13
NB_TCNTHi_BIT14:    equ    6                                         ; Timer Count Register Bit 14
NB_TCNTHi_BIT15:    equ    7                                         ; Timer Count Register Bit 15
; bit position masks
mNB_TCNTHi_BIT8:    equ    %00000001
mNB_TCNTHi_BIT9:    equ    %00000010
mNB_TCNTHi_BIT10:   equ    %00000100
mNB_TCNTHi_BIT11:   equ    %00001000
mNB_TCNTHi_BIT12:   equ    %00010000
mNB_TCNTHi_BIT13:   equ    %00100000
mNB_TCNTHi_BIT14:   equ    %01000000
mNB_TCNTHi_BIT15:   equ    %10000000


;*** NB_TCNTLo - Timer Count Register Low; 0x000003C5 ***
NB_TCNTLo:          equ    $000003C5                                ;*** NB_TCNTLo - Timer Count Register Low; 0x000003C5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCNTLo_BIT0:     equ    0                                         ; Timer Count Register Bit 0
NB_TCNTLo_BIT1:     equ    1                                         ; Timer Count Register Bit 1
NB_TCNTLo_BIT2:     equ    2                                         ; Timer Count Register Bit 2
NB_TCNTLo_BIT3:     equ    3                                         ; Timer Count Register Bit 3
NB_TCNTLo_BIT4:     equ    4                                         ; Timer Count Register Bit 4
NB_TCNTLo_BIT5:     equ    5                                         ; Timer Count Register Bit 5
NB_TCNTLo_BIT6:     equ    6                                         ; Timer Count Register Bit 6
NB_TCNTLo_BIT7:     equ    7                                         ; Timer Count Register Bit 7
; bit position masks
mNB_TCNTLo_BIT0:    equ    %00000001
mNB_TCNTLo_BIT1:    equ    %00000010
mNB_TCNTLo_BIT2:    equ    %00000100
mNB_TCNTLo_BIT3:    equ    %00001000
mNB_TCNTLo_BIT4:    equ    %00010000
mNB_TCNTLo_BIT5:    equ    %00100000
mNB_TCNTLo_BIT6:    equ    %01000000
mNB_TCNTLo_BIT7:    equ    %10000000


;*** NB_TSCR1 - Timer System Control Register1; 0x000003C6 ***
NB_TSCR1:           equ    $000003C6                                ;*** NB_TSCR1 - Timer System Control Register1; 0x000003C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TSCR1_TFFCA:     equ    4                                         ; Timer Fast Flag Clear All
NB_TSCR1_TEN:       equ    7                                         ; Timer Enable
; bit position masks
mNB_TSCR1_TFFCA:    equ    %00010000
mNB_TSCR1_TEN:      equ    %10000000


;*** NB_TTOV - Timer Toggle On Overflow Register; 0x000003C7 ***
NB_TTOV:            equ    $000003C7                                ;*** NB_TTOV - Timer Toggle On Overflow Register; 0x000003C7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TTOV_TOV0:       equ    0                                         ; Toggle On Overflow Bit 0
NB_TTOV_TOV1:       equ    1                                         ; Toggle On Overflow Bit 1
NB_TTOV_TOV2:       equ    2                                         ; Toggle On Overflow Bit 2
NB_TTOV_TOV3:       equ    3                                         ; Toggle On Overflow Bit 3
; bit position masks
mNB_TTOV_TOV0:      equ    %00000001
mNB_TTOV_TOV1:      equ    %00000010
mNB_TTOV_TOV2:      equ    %00000100
mNB_TTOV_TOV3:      equ    %00001000


;*** NB_TCTL1 - Timer Control Register 1; 0x000003C8 ***
NB_TCTL1:           equ    $000003C8                                ;*** NB_TCTL1 - Timer Control Register 1; 0x000003C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCTL1_OL0:       equ    0                                         ; Output Level Bit 0
NB_TCTL1_OM0:       equ    1                                         ; Output Mode Bit 0
NB_TCTL1_OL1:       equ    2                                         ; Output Lecel Bit 1
NB_TCTL1_OM1:       equ    3                                         ; Output Mode Bit 1
NB_TCTL1_OL2:       equ    4                                         ; Output Level Bit 2
NB_TCTL1_OM2:       equ    5                                         ; Output Mode Bit 2
NB_TCTL1_OL3:       equ    6                                         ; Output Level Bit 3
NB_TCTL1_OM3:       equ    7                                         ; Output Mode Bit 3
; bit position masks
mNB_TCTL1_OL0:      equ    %00000001
mNB_TCTL1_OM0:      equ    %00000010
mNB_TCTL1_OL1:      equ    %00000100
mNB_TCTL1_OM1:      equ    %00001000
mNB_TCTL1_OL2:      equ    %00010000
mNB_TCTL1_OM2:      equ    %00100000
mNB_TCTL1_OL3:      equ    %01000000
mNB_TCTL1_OM3:      equ    %10000000


;*** NB_TCTL2 - Timer Control Register 2; 0x000003C9 ***
NB_TCTL2:           equ    $000003C9                                ;*** NB_TCTL2 - Timer Control Register 2; 0x000003C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TCTL2_EDG0A:     equ    0                                         ; Input Capture Edge 0 Control A
NB_TCTL2_EDG0B:     equ    1                                         ; Input Capture Edge 0 Control B
NB_TCTL2_EDG1A:     equ    2                                         ; Input Capture Edge 1 Control A
NB_TCTL2_EDG1B:     equ    3                                         ; Input Capture Edge 1 Control B
NB_TCTL2_EDG2A:     equ    4                                         ; Input Capture Edge 2 Control A
NB_TCTL2_EDG2B:     equ    5                                         ; Input Capture Edge 2 Control B
NB_TCTL2_EDG3A:     equ    6                                         ; Input Capture Edge 3 Control A
NB_TCTL2_EDG3B:     equ    7                                         ; Input Capture Edge 3 Control B
; bit position masks
mNB_TCTL2_EDG0A:    equ    %00000001
mNB_TCTL2_EDG0B:    equ    %00000010
mNB_TCTL2_EDG1A:    equ    %00000100
mNB_TCTL2_EDG1B:    equ    %00001000
mNB_TCTL2_EDG2A:    equ    %00010000
mNB_TCTL2_EDG2B:    equ    %00100000
mNB_TCTL2_EDG3A:    equ    %01000000
mNB_TCTL2_EDG3B:    equ    %10000000


;*** NB_TIE - Timer Interrupt Enable Register; 0x000003CA ***
NB_TIE:             equ    $000003CA                                ;*** NB_TIE - Timer Interrupt Enable Register; 0x000003CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TIE_C0I:         equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
NB_TIE_C1I:         equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
NB_TIE_C2I:         equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
NB_TIE_C3I:         equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
; bit position masks
mNB_TIE_C0I:        equ    %00000001
mNB_TIE_C1I:        equ    %00000010
mNB_TIE_C2I:        equ    %00000100
mNB_TIE_C3I:        equ    %00001000


;*** NB_TSCR2 - Timer System Control Register 2; 0x000003CB ***
NB_TSCR2:           equ    $000003CB                                ;*** NB_TSCR2 - Timer System Control Register 2; 0x000003CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TSCR2_PR0:       equ    0                                         ; Timer Prescaler Select Bit 0
NB_TSCR2_PR1:       equ    1                                         ; Timer Prescaler Select Bit 1
NB_TSCR2_PR2:       equ    2                                         ; Timer Prescaler Select Bit 2
NB_TSCR2_TCRE:      equ    3                                         ; Timer Counter Reset Enable
NB_TSCR2_TOI:       equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mNB_TSCR2_PR0:      equ    %00000001
mNB_TSCR2_PR1:      equ    %00000010
mNB_TSCR2_PR2:      equ    %00000100
mNB_TSCR2_TCRE:     equ    %00001000
mNB_TSCR2_TOI:      equ    %10000000


;*** NB_TFLG1 - Main Timer Interrupt Flag 1; 0x000003CC ***
NB_TFLG1:           equ    $000003CC                                ;*** NB_TFLG1 - Main Timer Interrupt Flag 1; 0x000003CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TFLG1_C0F:       equ    0                                         ; Input Capture/Output Compare Channel Flag 0
NB_TFLG1_C1F:       equ    1                                         ; Input Capture/Output Compare Channel Flag 1
NB_TFLG1_C2F:       equ    2                                         ; Input Capture/Output Compare Channel Flag 2
NB_TFLG1_C3F:       equ    3                                         ; Input Capture/Output Compare Channel Flag 3
; bit position masks
mNB_TFLG1_C0F:      equ    %00000001
mNB_TFLG1_C1F:      equ    %00000010
mNB_TFLG1_C2F:      equ    %00000100
mNB_TFLG1_C3F:      equ    %00001000


;*** NB_TFLG2 - Main Timer Interrupt Flag 2; 0x000003CD ***
NB_TFLG2:           equ    $000003CD                                ;*** NB_TFLG2 - Main Timer Interrupt Flag 2; 0x000003CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TFLG2_TOF:       equ    7                                         ; Timer Overflow Flag
; bit position masks
mNB_TFLG2_TOF:      equ    %10000000


;*** NB_TC0 - Timer Input Capture/Output Compare Register 0; 0x000003CE ***
NB_TC0:             equ    $000003CE                                ;*** NB_TC0 - Timer Input Capture/Output Compare Register 0; 0x000003CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC0_BIT0:        equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 0
NB_TC0_BIT1:        equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 1
NB_TC0_BIT2:        equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 2
NB_TC0_BIT3:        equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 3
NB_TC0_BIT4:        equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 4
NB_TC0_BIT5:        equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 5
NB_TC0_BIT6:        equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 6
NB_TC0_BIT7:        equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 7
NB_TC0_BIT8:        equ    8                                         ; Timer Input Capture/Output Compare Register 0 Bit 8
NB_TC0_BIT9:        equ    9                                         ; Timer Input Capture/Output Compare Register 0 Bit 9
NB_TC0_BIT10:       equ    10                                        ; Timer Input Capture/Output Compare Register 0 Bit 10
NB_TC0_BIT11:       equ    11                                        ; Timer Input Capture/Output Compare Register 0 Bit 11
NB_TC0_BIT12:       equ    12                                        ; Timer Input Capture/Output Compare Register 0 Bit 12
NB_TC0_BIT13:       equ    13                                        ; Timer Input Capture/Output Compare Register 0 Bit 13
NB_TC0_BIT14:       equ    14                                        ; Timer Input Capture/Output Compare Register 0 Bit 14
NB_TC0_BIT15:       equ    15                                        ; Timer Input Capture/Output Compare Register 0 Bit 15
; bit position masks
mNB_TC0_BIT0:       equ    %00000001
mNB_TC0_BIT1:       equ    %00000010
mNB_TC0_BIT2:       equ    %00000100
mNB_TC0_BIT3:       equ    %00001000
mNB_TC0_BIT4:       equ    %00010000
mNB_TC0_BIT5:       equ    %00100000
mNB_TC0_BIT6:       equ    %01000000
mNB_TC0_BIT7:       equ    %10000000
mNB_TC0_BIT8:       equ    %100000000
mNB_TC0_BIT9:       equ    %1000000000
mNB_TC0_BIT10:      equ    %10000000000
mNB_TC0_BIT11:      equ    %100000000000
mNB_TC0_BIT12:      equ    %1000000000000
mNB_TC0_BIT13:      equ    %10000000000000
mNB_TC0_BIT14:      equ    %100000000000000
mNB_TC0_BIT15:      equ    %1000000000000000


;*** NB_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000003CE ***
NB_TC0Hi:           equ    $000003CE                                ;*** NB_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000003CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC0Hi_BIT8:      equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 8
NB_TC0Hi_BIT9:      equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 9
NB_TC0Hi_BIT10:     equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 10
NB_TC0Hi_BIT11:     equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 11
NB_TC0Hi_BIT12:     equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 12
NB_TC0Hi_BIT13:     equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 13
NB_TC0Hi_BIT14:     equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 14
NB_TC0Hi_BIT15:     equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 15
; bit position masks
mNB_TC0Hi_BIT8:     equ    %00000001
mNB_TC0Hi_BIT9:     equ    %00000010
mNB_TC0Hi_BIT10:    equ    %00000100
mNB_TC0Hi_BIT11:    equ    %00001000
mNB_TC0Hi_BIT12:    equ    %00010000
mNB_TC0Hi_BIT13:    equ    %00100000
mNB_TC0Hi_BIT14:    equ    %01000000
mNB_TC0Hi_BIT15:    equ    %10000000


;*** NB_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000003CF ***
NB_TC0Lo:           equ    $000003CF                                ;*** NB_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000003CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC0Lo_BIT0:      equ    0                                         ; Timer Input Capture/Output Compare Register 0 Bit 0
NB_TC0Lo_BIT1:      equ    1                                         ; Timer Input Capture/Output Compare Register 0 Bit 1
NB_TC0Lo_BIT2:      equ    2                                         ; Timer Input Capture/Output Compare Register 0 Bit 2
NB_TC0Lo_BIT3:      equ    3                                         ; Timer Input Capture/Output Compare Register 0 Bit 3
NB_TC0Lo_BIT4:      equ    4                                         ; Timer Input Capture/Output Compare Register 0 Bit 4
NB_TC0Lo_BIT5:      equ    5                                         ; Timer Input Capture/Output Compare Register 0 Bit 5
NB_TC0Lo_BIT6:      equ    6                                         ; Timer Input Capture/Output Compare Register 0 Bit 6
NB_TC0Lo_BIT7:      equ    7                                         ; Timer Input Capture/Output Compare Register 0 Bit 7
; bit position masks
mNB_TC0Lo_BIT0:     equ    %00000001
mNB_TC0Lo_BIT1:     equ    %00000010
mNB_TC0Lo_BIT2:     equ    %00000100
mNB_TC0Lo_BIT3:     equ    %00001000
mNB_TC0Lo_BIT4:     equ    %00010000
mNB_TC0Lo_BIT5:     equ    %00100000
mNB_TC0Lo_BIT6:     equ    %01000000
mNB_TC0Lo_BIT7:     equ    %10000000


;*** NB_TC1 - Timer Input Capture/Output Compare Register 1; 0x000003D0 ***
NB_TC1:             equ    $000003D0                                ;*** NB_TC1 - Timer Input Capture/Output Compare Register 1; 0x000003D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC1_BIT0:        equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 0
NB_TC1_BIT1:        equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 1
NB_TC1_BIT2:        equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 2
NB_TC1_BIT3:        equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 3
NB_TC1_BIT4:        equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 4
NB_TC1_BIT5:        equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 5
NB_TC1_BIT6:        equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 6
NB_TC1_BIT7:        equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 7
NB_TC1_BIT8:        equ    8                                         ; Timer Input Capture/Output Compare Register 1 Bit 8
NB_TC1_BIT9:        equ    9                                         ; Timer Input Capture/Output Compare Register 1 Bit 9
NB_TC1_BIT10:       equ    10                                        ; Timer Input Capture/Output Compare Register 1 Bit 10
NB_TC1_BIT11:       equ    11                                        ; Timer Input Capture/Output Compare Register 1 Bit 11
NB_TC1_BIT12:       equ    12                                        ; Timer Input Capture/Output Compare Register 1 Bit 12
NB_TC1_BIT13:       equ    13                                        ; Timer Input Capture/Output Compare Register 1 Bit 13
NB_TC1_BIT14:       equ    14                                        ; Timer Input Capture/Output Compare Register 1 Bit 14
NB_TC1_BIT15:       equ    15                                        ; Timer Input Capture/Output Compare Register 1 Bit 15
; bit position masks
mNB_TC1_BIT0:       equ    %00000001
mNB_TC1_BIT1:       equ    %00000010
mNB_TC1_BIT2:       equ    %00000100
mNB_TC1_BIT3:       equ    %00001000
mNB_TC1_BIT4:       equ    %00010000
mNB_TC1_BIT5:       equ    %00100000
mNB_TC1_BIT6:       equ    %01000000
mNB_TC1_BIT7:       equ    %10000000
mNB_TC1_BIT8:       equ    %100000000
mNB_TC1_BIT9:       equ    %1000000000
mNB_TC1_BIT10:      equ    %10000000000
mNB_TC1_BIT11:      equ    %100000000000
mNB_TC1_BIT12:      equ    %1000000000000
mNB_TC1_BIT13:      equ    %10000000000000
mNB_TC1_BIT14:      equ    %100000000000000
mNB_TC1_BIT15:      equ    %1000000000000000


;*** NB_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000003D0 ***
NB_TC1Hi:           equ    $000003D0                                ;*** NB_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000003D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC1Hi_BIT8:      equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 8
NB_TC1Hi_BIT9:      equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 9
NB_TC1Hi_BIT10:     equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 10
NB_TC1Hi_BIT11:     equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 11
NB_TC1Hi_BIT12:     equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 12
NB_TC1Hi_BIT13:     equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 13
NB_TC1Hi_BIT14:     equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 14
NB_TC1Hi_BIT15:     equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 15
; bit position masks
mNB_TC1Hi_BIT8:     equ    %00000001
mNB_TC1Hi_BIT9:     equ    %00000010
mNB_TC1Hi_BIT10:    equ    %00000100
mNB_TC1Hi_BIT11:    equ    %00001000
mNB_TC1Hi_BIT12:    equ    %00010000
mNB_TC1Hi_BIT13:    equ    %00100000
mNB_TC1Hi_BIT14:    equ    %01000000
mNB_TC1Hi_BIT15:    equ    %10000000


;*** NB_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000003D1 ***
NB_TC1Lo:           equ    $000003D1                                ;*** NB_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000003D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC1Lo_BIT0:      equ    0                                         ; Timer Input Capture/Output Compare Register 1 Bit 0
NB_TC1Lo_BIT1:      equ    1                                         ; Timer Input Capture/Output Compare Register 1 Bit 1
NB_TC1Lo_BIT2:      equ    2                                         ; Timer Input Capture/Output Compare Register 1 Bit 2
NB_TC1Lo_BIT3:      equ    3                                         ; Timer Input Capture/Output Compare Register 1 Bit 3
NB_TC1Lo_BIT4:      equ    4                                         ; Timer Input Capture/Output Compare Register 1 Bit 4
NB_TC1Lo_BIT5:      equ    5                                         ; Timer Input Capture/Output Compare Register 1 Bit 5
NB_TC1Lo_BIT6:      equ    6                                         ; Timer Input Capture/Output Compare Register 1 Bit 6
NB_TC1Lo_BIT7:      equ    7                                         ; Timer Input Capture/Output Compare Register 1 Bit 7
; bit position masks
mNB_TC1Lo_BIT0:     equ    %00000001
mNB_TC1Lo_BIT1:     equ    %00000010
mNB_TC1Lo_BIT2:     equ    %00000100
mNB_TC1Lo_BIT3:     equ    %00001000
mNB_TC1Lo_BIT4:     equ    %00010000
mNB_TC1Lo_BIT5:     equ    %00100000
mNB_TC1Lo_BIT6:     equ    %01000000
mNB_TC1Lo_BIT7:     equ    %10000000


;*** NB_TC2 - Timer Input Capture/Output Compare Register 2; 0x000003D2 ***
NB_TC2:             equ    $000003D2                                ;*** NB_TC2 - Timer Input Capture/Output Compare Register 2; 0x000003D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC2_BIT0:        equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 0
NB_TC2_BIT1:        equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 1
NB_TC2_BIT2:        equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 2
NB_TC2_BIT3:        equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 3
NB_TC2_BIT4:        equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 4
NB_TC2_BIT5:        equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 5
NB_TC2_BIT6:        equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 6
NB_TC2_BIT7:        equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 7
NB_TC2_BIT8:        equ    8                                         ; Timer Input Capture/Output Compare Register 2 Bit 8
NB_TC2_BIT9:        equ    9                                         ; Timer Input Capture/Output Compare Register 2 Bit 9
NB_TC2_BIT10:       equ    10                                        ; Timer Input Capture/Output Compare Register 2 Bit 10
NB_TC2_BIT11:       equ    11                                        ; Timer Input Capture/Output Compare Register 2 Bit 11
NB_TC2_BIT12:       equ    12                                        ; Timer Input Capture/Output Compare Register 2 Bit 12
NB_TC2_BIT13:       equ    13                                        ; Timer Input Capture/Output Compare Register 2 Bit 13
NB_TC2_BIT14:       equ    14                                        ; Timer Input Capture/Output Compare Register 2 Bit 14
NB_TC2_BIT15:       equ    15                                        ; Timer Input Capture/Output Compare Register 2 Bit 15
; bit position masks
mNB_TC2_BIT0:       equ    %00000001
mNB_TC2_BIT1:       equ    %00000010
mNB_TC2_BIT2:       equ    %00000100
mNB_TC2_BIT3:       equ    %00001000
mNB_TC2_BIT4:       equ    %00010000
mNB_TC2_BIT5:       equ    %00100000
mNB_TC2_BIT6:       equ    %01000000
mNB_TC2_BIT7:       equ    %10000000
mNB_TC2_BIT8:       equ    %100000000
mNB_TC2_BIT9:       equ    %1000000000
mNB_TC2_BIT10:      equ    %10000000000
mNB_TC2_BIT11:      equ    %100000000000
mNB_TC2_BIT12:      equ    %1000000000000
mNB_TC2_BIT13:      equ    %10000000000000
mNB_TC2_BIT14:      equ    %100000000000000
mNB_TC2_BIT15:      equ    %1000000000000000


;*** NB_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000003D2 ***
NB_TC2Hi:           equ    $000003D2                                ;*** NB_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000003D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC2Hi_BIT8:      equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 8
NB_TC2Hi_BIT9:      equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 9
NB_TC2Hi_BIT10:     equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 10
NB_TC2Hi_BIT11:     equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 11
NB_TC2Hi_BIT12:     equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 12
NB_TC2Hi_BIT13:     equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 13
NB_TC2Hi_BIT14:     equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 14
NB_TC2Hi_BIT15:     equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 15
; bit position masks
mNB_TC2Hi_BIT8:     equ    %00000001
mNB_TC2Hi_BIT9:     equ    %00000010
mNB_TC2Hi_BIT10:    equ    %00000100
mNB_TC2Hi_BIT11:    equ    %00001000
mNB_TC2Hi_BIT12:    equ    %00010000
mNB_TC2Hi_BIT13:    equ    %00100000
mNB_TC2Hi_BIT14:    equ    %01000000
mNB_TC2Hi_BIT15:    equ    %10000000


;*** NB_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000003D3 ***
NB_TC2Lo:           equ    $000003D3                                ;*** NB_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000003D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC2Lo_BIT0:      equ    0                                         ; Timer Input Capture/Output Compare Register 2 Bit 0
NB_TC2Lo_BIT1:      equ    1                                         ; Timer Input Capture/Output Compare Register 2 Bit 1
NB_TC2Lo_BIT2:      equ    2                                         ; Timer Input Capture/Output Compare Register 2 Bit 2
NB_TC2Lo_BIT3:      equ    3                                         ; Timer Input Capture/Output Compare Register 2 Bit 3
NB_TC2Lo_BIT4:      equ    4                                         ; Timer Input Capture/Output Compare Register 2 Bit 4
NB_TC2Lo_BIT5:      equ    5                                         ; Timer Input Capture/Output Compare Register 2 Bit 5
NB_TC2Lo_BIT6:      equ    6                                         ; Timer Input Capture/Output Compare Register 2 Bit 6
NB_TC2Lo_BIT7:      equ    7                                         ; Timer Input Capture/Output Compare Register 2 Bit 7
; bit position masks
mNB_TC2Lo_BIT0:     equ    %00000001
mNB_TC2Lo_BIT1:     equ    %00000010
mNB_TC2Lo_BIT2:     equ    %00000100
mNB_TC2Lo_BIT3:     equ    %00001000
mNB_TC2Lo_BIT4:     equ    %00010000
mNB_TC2Lo_BIT5:     equ    %00100000
mNB_TC2Lo_BIT6:     equ    %01000000
mNB_TC2Lo_BIT7:     equ    %10000000


;*** NB_TC3 - Timer Input Capture/Output Compare Register 3; 0x000003D4 ***
NB_TC3:             equ    $000003D4                                ;*** NB_TC3 - Timer Input Capture/Output Compare Register 3; 0x000003D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC3_BIT0:        equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 0
NB_TC3_BIT1:        equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 1
NB_TC3_BIT2:        equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 2
NB_TC3_BIT3:        equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 3
NB_TC3_BIT4:        equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 4
NB_TC3_BIT5:        equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 5
NB_TC3_BIT6:        equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 6
NB_TC3_BIT7:        equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 7
NB_TC3_BIT8:        equ    8                                         ; Timer Input Capture/Output Compare Register 3 Bit 8
NB_TC3_BIT9:        equ    9                                         ; Timer Input Capture/Output Compare Register 3 Bit 9
NB_TC3_BIT10:       equ    10                                        ; Timer Input Capture/Output Compare Register 3 Bit 10
NB_TC3_BIT11:       equ    11                                        ; Timer Input Capture/Output Compare Register 3 Bit 11
NB_TC3_BIT12:       equ    12                                        ; Timer Input Capture/Output Compare Register 3 Bit 12
NB_TC3_BIT13:       equ    13                                        ; Timer Input Capture/Output Compare Register 3 Bit 13
NB_TC3_BIT14:       equ    14                                        ; Timer Input Capture/Output Compare Register 3 Bit 14
NB_TC3_BIT15:       equ    15                                        ; Timer Input Capture/Output Compare Register 3 Bit 15
; bit position masks
mNB_TC3_BIT0:       equ    %00000001
mNB_TC3_BIT1:       equ    %00000010
mNB_TC3_BIT2:       equ    %00000100
mNB_TC3_BIT3:       equ    %00001000
mNB_TC3_BIT4:       equ    %00010000
mNB_TC3_BIT5:       equ    %00100000
mNB_TC3_BIT6:       equ    %01000000
mNB_TC3_BIT7:       equ    %10000000
mNB_TC3_BIT8:       equ    %100000000
mNB_TC3_BIT9:       equ    %1000000000
mNB_TC3_BIT10:      equ    %10000000000
mNB_TC3_BIT11:      equ    %100000000000
mNB_TC3_BIT12:      equ    %1000000000000
mNB_TC3_BIT13:      equ    %10000000000000
mNB_TC3_BIT14:      equ    %100000000000000
mNB_TC3_BIT15:      equ    %1000000000000000


;*** NB_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000003D4 ***
NB_TC3Hi:           equ    $000003D4                                ;*** NB_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000003D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC3Hi_BIT8:      equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 8
NB_TC3Hi_BIT9:      equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 9
NB_TC3Hi_BIT10:     equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 10
NB_TC3Hi_BIT11:     equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 11
NB_TC3Hi_BIT12:     equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 12
NB_TC3Hi_BIT13:     equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 13
NB_TC3Hi_BIT14:     equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 14
NB_TC3Hi_BIT15:     equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 15
; bit position masks
mNB_TC3Hi_BIT8:     equ    %00000001
mNB_TC3Hi_BIT9:     equ    %00000010
mNB_TC3Hi_BIT10:    equ    %00000100
mNB_TC3Hi_BIT11:    equ    %00001000
mNB_TC3Hi_BIT12:    equ    %00010000
mNB_TC3Hi_BIT13:    equ    %00100000
mNB_TC3Hi_BIT14:    equ    %01000000
mNB_TC3Hi_BIT15:    equ    %10000000


;*** NB_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000003D5 ***
NB_TC3Lo:           equ    $000003D5                                ;*** NB_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000003D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_TC3Lo_BIT0:      equ    0                                         ; Timer Input Capture/Output Compare Register 3 Bit 0
NB_TC3Lo_BIT1:      equ    1                                         ; Timer Input Capture/Output Compare Register 3 Bit 1
NB_TC3Lo_BIT2:      equ    2                                         ; Timer Input Capture/Output Compare Register 3 Bit 2
NB_TC3Lo_BIT3:      equ    3                                         ; Timer Input Capture/Output Compare Register 3 Bit 3
NB_TC3Lo_BIT4:      equ    4                                         ; Timer Input Capture/Output Compare Register 3 Bit 4
NB_TC3Lo_BIT5:      equ    5                                         ; Timer Input Capture/Output Compare Register 3 Bit 5
NB_TC3Lo_BIT6:      equ    6                                         ; Timer Input Capture/Output Compare Register 3 Bit 6
NB_TC3Lo_BIT7:      equ    7                                         ; Timer Input Capture/Output Compare Register 3 Bit 7
; bit position masks
mNB_TC3Lo_BIT0:     equ    %00000001
mNB_TC3Lo_BIT1:     equ    %00000010
mNB_TC3Lo_BIT2:     equ    %00000100
mNB_TC3Lo_BIT3:     equ    %00001000
mNB_TC3Lo_BIT4:     equ    %00010000
mNB_TC3Lo_BIT5:     equ    %00100000
mNB_TC3Lo_BIT6:     equ    %01000000
mNB_TC3Lo_BIT7:     equ    %10000000


;*** NB_CTR0 - Trimming Register 0; 0x000003F0 ***
NB_CTR0:            equ    $000003F0                                ;*** NB_CTR0 - Trimming Register 0; 0x000003F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_CTR0_WDCTR:      equ    0                                         ; Watchdog clock trim 0
NB_CTR0_CTR0_3:     equ    3                                         ; Spare Trim bit 3
NB_CTR0_CTR0_4:     equ    4                                         ; Spare Trim bit 4
NB_CTR0_WDCTRE:     equ    5                                         ; Watchdog trim enable
NB_CTR0_LINTR:      equ    6                                         ; LIN trim bit
NB_CTR0_LINTRE:     equ    7                                         ; LIN trim enable
; bit position masks
mNB_CTR0_WDCTR:     equ    %00000111
mNB_CTR0_CTR0_3:    equ    %00001000
mNB_CTR0_CTR0_4:    equ    %00010000
mNB_CTR0_WDCTRE:    equ    %00100000
mNB_CTR0_LINTR:     equ    %01000000
mNB_CTR0_LINTRE:    equ    %10000000


;*** NB_CTR1 - Trimming Register 1; 0x000003F1 ***
NB_CTR1:            equ    $000003F1                                ;*** NB_CTR1 - Trimming Register 1; 0x000003F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_CTR1_IREFTR:     equ    0                                         ; Iref trim 0
NB_CTR1_IREFTRE:    equ    3                                         ; Iref trim enable bit
NB_CTR1_BGTRIMDN:   equ    4                                         ; Bandgap trim down bit
NB_CTR1_BGTRIMUP:   equ    5                                         ; Bandgap trim up bit
NB_CTR1_CTR1_6:     equ    6                                         ; Spare Trim Bit
NB_CTR1_BGTRE:      equ    7                                         ; Bandgap trim enable
; bit position masks
mNB_CTR1_IREFTR:    equ    %00000111
mNB_CTR1_IREFTRE:   equ    %00001000
mNB_CTR1_BGTRIMDN:  equ    %00010000
mNB_CTR1_BGTRIMUP:  equ    %00100000
mNB_CTR1_CTR1_6:    equ    %01000000
mNB_CTR1_BGTRE:     equ    %10000000


;*** NB_CTR2 - Trimming Register 2; 0x000003F2 ***
NB_CTR2:            equ    $000003F2                                ;*** NB_CTR2 - Trimming Register 2; 0x000003F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_CTR2_SLPBGTR:    equ    0                                         ; bg1p25sleep trim 0
NB_CTR2_SLPBG_LOCK: equ    3                                         ; bg1p25sleep trim lock bit
NB_CTR2_SLPBGTRE:   equ    4                                         ; Sleep Bandgap trim enable
; bit position masks
mNB_CTR2_SLPBGTR:   equ    %00000111
mNB_CTR2_SLPBG_LOCK: equ    %00001000
mNB_CTR2_SLPBGTRE:  equ    %00010000


;*** NB_CTR3 - Trimming Register 3; 0x000003F3 ***
NB_CTR3:            equ    $000003F3                                ;*** NB_CTR3 - Trimming Register 3; 0x000003F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_CTR3_CTR3_0:     equ    0                                         ; Spare Trim bit 0
NB_CTR3_CTR3_1:     equ    1                                         ; Spare Trim bit 1
NB_CTR3_CTR3_2:     equ    2                                         ; Spare Trim bit 2
NB_CTR3_CTR3_E:     equ    3                                         ; Spare Trim enable bit
NB_CTR3_OFFCTR:     equ    4                                         ; ADCOFFC trim 0
NB_CTR3_OFFCTRE:    equ    7                                         ; ADC offset compensation voltage trim enable bit
; bit position masks
mNB_CTR3_CTR3_0:    equ    %00000001
mNB_CTR3_CTR3_1:    equ    %00000010
mNB_CTR3_CTR3_2:    equ    %00000100
mNB_CTR3_CTR3_E:    equ    %00001000
mNB_CTR3_OFFCTR:    equ    %01110000
mNB_CTR3_OFFCTRE:   equ    %10000000


;*** NB_SRR - Silicon Revision Register; 0x000003F4 ***
NB_SRR:             equ    $000003F4                                ;*** NB_SRR - Silicon Revision Register; 0x000003F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NB_SRR_MMREV:       equ    0                                         ; MM912F634 analog die Silicon Revision Register Metal Tweak Revision
NB_SRR_FMREV:       equ    2                                         ; MM912F634 analog die Silicon Revision Register Full Mask Revision
; bit position masks
mNB_SRR_MMREV:      equ    %00000011
mNB_SRR_FMREV:      equ    %00001100


;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY0_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY0_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY0_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY0_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY0_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY0_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY0_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY0_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY0_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY0_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY0_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY0_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY0_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY0_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY0_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY0_KEY0:       equ    %00000001
mBAKEY0_KEY1:       equ    %00000010
mBAKEY0_KEY2:       equ    %00000100
mBAKEY0_KEY3:       equ    %00001000
mBAKEY0_KEY4:       equ    %00010000
mBAKEY0_KEY5:       equ    %00100000
mBAKEY0_KEY6:       equ    %01000000
mBAKEY0_KEY7:       equ    %10000000
mBAKEY0_KEY8:       equ    %100000000
mBAKEY0_KEY9:       equ    %1000000000
mBAKEY0_KEY10:      equ    %10000000000
mBAKEY0_KEY11:      equ    %100000000000
mBAKEY0_KEY12:      equ    %1000000000000
mBAKEY0_KEY13:      equ    %10000000000000
mBAKEY0_KEY14:      equ    %100000000000000
mBAKEY0_KEY15:      equ    %1000000000000000


;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY1_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY1_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY1_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY1_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY1_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY1_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY1_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY1_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY1_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY1_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY1_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY1_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY1_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY1_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY1_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY1_KEY0:       equ    %00000001
mBAKEY1_KEY1:       equ    %00000010
mBAKEY1_KEY2:       equ    %00000100
mBAKEY1_KEY3:       equ    %00001000
mBAKEY1_KEY4:       equ    %00010000
mBAKEY1_KEY5:       equ    %00100000
mBAKEY1_KEY6:       equ    %01000000
mBAKEY1_KEY7:       equ    %10000000
mBAKEY1_KEY8:       equ    %100000000
mBAKEY1_KEY9:       equ    %1000000000
mBAKEY1_KEY10:      equ    %10000000000
mBAKEY1_KEY11:      equ    %100000000000
mBAKEY1_KEY12:      equ    %1000000000000
mBAKEY1_KEY13:      equ    %10000000000000
mBAKEY1_KEY14:      equ    %100000000000000
mBAKEY1_KEY15:      equ    %1000000000000000


;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY2_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY2_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY2_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY2_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY2_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY2_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY2_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY2_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY2_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY2_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY2_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY2_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY2_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY2_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY2_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY2_KEY0:       equ    %00000001
mBAKEY2_KEY1:       equ    %00000010
mBAKEY2_KEY2:       equ    %00000100
mBAKEY2_KEY3:       equ    %00001000
mBAKEY2_KEY4:       equ    %00010000
mBAKEY2_KEY5:       equ    %00100000
mBAKEY2_KEY6:       equ    %01000000
mBAKEY2_KEY7:       equ    %10000000
mBAKEY2_KEY8:       equ    %100000000
mBAKEY2_KEY9:       equ    %1000000000
mBAKEY2_KEY10:      equ    %10000000000
mBAKEY2_KEY11:      equ    %100000000000
mBAKEY2_KEY12:      equ    %1000000000000
mBAKEY2_KEY13:      equ    %10000000000000
mBAKEY2_KEY14:      equ    %100000000000000
mBAKEY2_KEY15:      equ    %1000000000000000


;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY0:        equ    0                                         ; Backdoor Comparison Key Bits, bit 0
BAKEY3_KEY1:        equ    1                                         ; Backdoor Comparison Key Bits, bit 1
BAKEY3_KEY2:        equ    2                                         ; Backdoor Comparison Key Bits, bit 2
BAKEY3_KEY3:        equ    3                                         ; Backdoor Comparison Key Bits, bit 3
BAKEY3_KEY4:        equ    4                                         ; Backdoor Comparison Key Bits, bit 4
BAKEY3_KEY5:        equ    5                                         ; Backdoor Comparison Key Bits, bit 5
BAKEY3_KEY6:        equ    6                                         ; Backdoor Comparison Key Bits, bit 6
BAKEY3_KEY7:        equ    7                                         ; Backdoor Comparison Key Bits, bit 7
BAKEY3_KEY8:        equ    8                                         ; Backdoor Comparison Key Bits, bit 8
BAKEY3_KEY9:        equ    9                                         ; Backdoor Comparison Key Bits, bit 9
BAKEY3_KEY10:       equ    10                                        ; Backdoor Comparison Key Bits, bit 10
BAKEY3_KEY11:       equ    11                                        ; Backdoor Comparison Key Bits, bit 11
BAKEY3_KEY12:       equ    12                                        ; Backdoor Comparison Key Bits, bit 12
BAKEY3_KEY13:       equ    13                                        ; Backdoor Comparison Key Bits, bit 13
BAKEY3_KEY14:       equ    14                                        ; Backdoor Comparison Key Bits, bit 14
BAKEY3_KEY15:       equ    15                                        ; Backdoor Comparison Key Bits, bit 15
; bit position masks
mBAKEY3_KEY0:       equ    %00000001
mBAKEY3_KEY1:       equ    %00000010
mBAKEY3_KEY2:       equ    %00000100
mBAKEY3_KEY3:       equ    %00001000
mBAKEY3_KEY4:       equ    %00010000
mBAKEY3_KEY5:       equ    %00100000
mBAKEY3_KEY6:       equ    %01000000
mBAKEY3_KEY7:       equ    %10000000
mBAKEY3_KEY8:       equ    %100000000
mBAKEY3_KEY9:       equ    %1000000000
mBAKEY3_KEY10:      equ    %10000000000
mBAKEY3_KEY11:      equ    %100000000000
mBAKEY3_KEY12:      equ    %1000000000000
mBAKEY3_KEY13:      equ    %10000000000000
mBAKEY3_KEY14:      equ    %100000000000000
mBAKEY3_KEY15:      equ    %1000000000000000


;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
NVFPROT:            equ    $0000FF0C                                ;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT_FPLS0:      equ    0                                         ; Flash Protection Lower Address Size Bit 0
NVFPROT_FPLS1:      equ    1                                         ; Flash Protection Lower Address Size Bit 1
NVFPROT_FPLDIS:     equ    2                                         ; Flash Protection Lower Address Range Disable
NVFPROT_FPHS0:      equ    3                                         ; Flash Protection Higher Address Size Bit 0
NVFPROT_FPHS1:      equ    4                                         ; Flash Protection Higher Address Size Bit 1
NVFPROT_FPHDIS:     equ    5                                         ; Flash Protection Higher Address Range Disable
NVFPROT_RNV6:       equ    6                                         ; Reserved Nonvolatile Bit
NVFPROT_FPOPEN:     equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mNVFPROT_FPLS0:     equ    %00000001
mNVFPROT_FPLS1:     equ    %00000010
mNVFPROT_FPLDIS:    equ    %00000100
mNVFPROT_FPHS0:     equ    %00001000
mNVFPROT_FPHS1:     equ    %00010000
mNVFPROT_FPHDIS:    equ    %00100000
mNVFPROT_RNV6:      equ    %01000000
mNVFPROT_FPOPEN:    equ    %10000000


;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
NVDFPROT:           equ    $0000FF0D                                ;*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVDFPROT_DPS0:      equ    0                                         ; D-Flash Protection Size Bit 0
NVDFPROT_DPS1:      equ    1                                         ; D-Flash Protection Size Bit 1
NVDFPROT_DPS2:      equ    2                                         ; D-Flash Protection Size Bit 2
NVDFPROT_DPS3:      equ    3                                         ; D-Flash Protection Size Bit 3
NVDFPROT_DPOPEN:    equ    7                                         ; D-Flash Protection Control
; bit position masks
mNVDFPROT_DPS0:     equ    %00000001
mNVDFPROT_DPS1:     equ    %00000010
mNVDFPROT_DPS2:     equ    %00000100
mNVDFPROT_DPS3:     equ    %00001000
mNVDFPROT_DPOPEN:   equ    %10000000


;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
NVFOPT:             equ    $0000FF0E                                ;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFOPT_NV0:         equ    0                                         ; Nonvolatile Bit 0
NVFOPT_NV1:         equ    1                                         ; Nonvolatile Bit 1
NVFOPT_NV2:         equ    2                                         ; Nonvolatile Bit 2
NVFOPT_NV3:         equ    3                                         ; Nonvolatile Bit 3
NVFOPT_NV4:         equ    4                                         ; Nonvolatile Bit 4
NVFOPT_NV5:         equ    5                                         ; Nonvolatile Bit 5
NVFOPT_NV6:         equ    6                                         ; Nonvolatile Bit 6
NVFOPT_NV7:         equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mNVFOPT_NV0:        equ    %00000001
mNVFOPT_NV1:        equ    %00000010
mNVFOPT_NV2:        equ    %00000100
mNVFOPT_NV3:        equ    %00001000
mNVFOPT_NV4:        equ    %00010000
mNVFOPT_NV5:        equ    %00100000
mNVFOPT_NV6:        equ    %01000000
mNVFOPT_NV7:        equ    %10000000


;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Flash Security Bit 0
NVFSEC_SEC1:        equ    1                                         ; Flash Security Bit 1
NVFSEC_RNV2:        equ    2                                         ; Reserved Nonvolatile Bit 2
NVFSEC_RNV3:        equ    3                                         ; Reserved Nonvolatile Bit 3
NVFSEC_RNV4:        equ    4                                         ; Reserved Nonvolatile Bit 4
NVFSEC_RNV5:        equ    5                                         ; Reserved Nonvolatile Bit 5
NVFSEC_KEYEN0:      equ    6                                         ; Backdoor Key Security Enable Bit 0
NVFSEC_KEYEN1:      equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_RNV2:       equ    %00000100
mNVFSEC_RNV3:       equ    %00001000
mNVFSEC_RNV4:       equ    %00010000
mNVFSEC_RNV5:       equ    %00100000
mNVFSEC_KEYEN0:     equ    %01000000
mNVFSEC_KEYEN1:     equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF

; EOF
