; Based on CPU DB MC9S12XHZ512_144, version 3.00.022 (RegistersPrg V2.28)

; ###################################################################
;     Filename  : mc9s12xhz384.inc
;     Processor : MC9S12XHZ384CAG
;     FileFormat: V2.28
;     DataSheet : MC9S12XHZ512 Rev. 1.05 11/2008
;     Compiler  : CodeWarrior compiler
;     Date/Time : 2.7.2009, 9:25
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 03.04.2007, VV2.87.211:
;              - Added registers OCPD, MCCC8-11, MCDC8-11, DBGMFR.
;              - Renamed registers XGIF<0-7> ==> XGIF_<0-7>F_<0-7>0.
;              - Renamed bits DBGXDH[BIT0:7] ==> DBGXDH[BIT8:15], IBxCR[IBxEN,IBxIE,IBxSWAI] ==> IBxCR[IBEN,IBIE,IBSWAI],
;              - IBxSR[IBxB,IBxAL,IBxIF] ==> IBxSR[IBB,IBAL,IBIF], IBxFD[IBxCy] ==> IBxFD[IBCy], SCIxCR2[SCTIE] ==> SCIxCR2[TIE].
;              - Renamed CAN buffers (*RX/TX* ==> *R/T* (for example CAN1TXIDR1 ==> CAN1TIDR1)).
;              - Renamed bit groups INT_CFADDRGrp, XGCHIDGrp, XGVBRGrp, XGSWTGrp, XGSEMGrp ==> INT_CFADDR, XGCHID, XGVBR, XGSWT, XGSEM.
;              - Copied bits from FSEC to NVFSEC.
;              - Renamed bits TCxH[BITy] ==> TCxH[TCy], PAxH[BITy] ==> PAxH[PAxHy].
;              -   REASON: Bug-fix (#4382 in Issue Manager). 
;              - Added bits MMCCTL0[CS3E], COPCTL[WRTMASK], FCNFG[BKSEL0:1], FSTAT[FAIL], ESTAT[FAIL], RTZxCTL[SMS], SSDxCTL[FTST].     
;              - Added registers FADDR, FDATA, EADDR, EDATA, MCDC<0-11>_FAST.
;              - Removed bits PAxH[PAxH0:7], TCxH[TCx].
;              - Renamed CAN buffers (*R/T* ==> *RX/TX* (for example CAN1TIDR1 ==> CAN1TXIDR1)).
;              - Renamed registers ATDDIEN01 -> ATDDIEN, PORTAD0/1 ==> ATDPTAD0/1,
;              - IBxAD ==> IICx_IBAD, IBxFD ==> IICx_IBFD, IBxCR ==> IICx_IBCR, IBxSR ==> IICx_IBSR, IBxDR ==> IICx_IBDR, IBxCR2 ==> IICx_IBCR2.
;              - Renamed interrupt vectors ReservedX ==> VReservedX.
;              -   REASON: Bug-fix (#5381 in Issue Manager). 
;      - 14.11.2008, V3.00.0:
;              - Corrected definition of depreciated symbols.
;              -   REASON: Bug-fix(#6592 in Issue Manager).
;      - 14.11.2008, V3.00.1:
;              - Renamed bits IBCR2[ADR2:0] -> IBCR2[ADR10:8].
;              -   REASON: Bug-fix(#6799 in Issue Manager).
;
;     File-Format-Revisions:
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
EEPROMStart:        equ   $00000C00
EEPROMEnd:          equ   $00000FFB
RAMStart:           equ   $00002000
RAMEnd:             equ   $00003FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
EEPROM_FCStart:     equ   $0013F000
EEPROM_FCEnd:       equ   $0013F3FF
EEPROM_FDStart:     equ   $0013F400
EEPROM_FDEnd:       equ   $0013F7FF
EEPROM_FEStart:     equ   $0013F800
EEPROM_FEEnd:       equ   $0013FBFF
RAM_F9Start:        equ   $000F9000
RAM_F9End:          equ   $000F9FFF
RAM_FAStart:        equ   $000FA000
RAM_FAEnd:          equ   $000FAFFF
RAM_FBStart:        equ   $000FB000
RAM_FBEnd:          equ   $000FBFFF
RAM_FCStart:        equ   $000FC000
RAM_FCEnd:          equ   $000FCFFF
RAM_FDStart:        equ   $000FD000
RAM_FDEnd:          equ   $000FDFFF
PAGE_E0Start:       equ   $00780000
PAGE_E0End:         equ   $00783FFF
PAGE_E1Start:       equ   $00784000
PAGE_E1End:         equ   $00787FFF
PAGE_E2Start:       equ   $00788000
PAGE_E2End:         equ   $0078BFFF
PAGE_E3Start:       equ   $0078C000
PAGE_E3End:         equ   $0078FFFF
PAGE_E4Start:       equ   $00790000
PAGE_E4End:         equ   $00793FFF
PAGE_E5Start:       equ   $00794000
PAGE_E5End:         equ   $00797FFF
PAGE_E6Start:       equ   $00798000
PAGE_E6End:         equ   $0079BFFF
PAGE_E7Start:       equ   $0079C000
PAGE_E7End:         equ   $0079FFFF
PAGE_F0Start:       equ   $007C0000
PAGE_F0End:         equ   $007C3FFF
PAGE_F1Start:       equ   $007C4000
PAGE_F1End:         equ   $007C7FFF
PAGE_F2Start:       equ   $007C8000
PAGE_F2End:         equ   $007CBFFF
PAGE_F3Start:       equ   $007CC000
PAGE_F3End:         equ   $007CFFFF
PAGE_F4Start:       equ   $007D0000
PAGE_F4End:         equ   $007D3FFF
PAGE_F5Start:       equ   $007D4000
PAGE_F5End:         equ   $007D7FFF
PAGE_F6Start:       equ   $007D8000
PAGE_F6End:         equ   $007DBFFF
PAGE_F7Start:       equ   $007DC000
PAGE_F7End:         equ   $007DFFFF
PAGE_F8Start:       equ   $007E0000
PAGE_F8End:         equ   $007E3FFF
PAGE_F9Start:       equ   $007E4000
PAGE_F9End:         equ   $007E7FFF
PAGE_FAStart:       equ   $007E8000
PAGE_FAEnd:         equ   $007EBFFF
PAGE_FBStart:       equ   $007EC000
PAGE_FBEnd:         equ   $007EFFFF
PAGE_FCStart:       equ   $007F0000
PAGE_FCEnd:         equ   $007F3FFF
PAGE_FEStart:       equ   $007F8000
PAGE_FEEnd:         equ   $007FBFFF
;
Vsi:                equ   $0000FF10
VReserved118:       equ   $0000FF12
VReserved117:       equ   $0000FF14
VReserved116:       equ   $0000FF16
VReserved115:       equ   $0000FF18
VReserved114:       equ   $0000FF1A
VReserved113:       equ   $0000FF1C
VReserved112:       equ   $0000FF1E
VReserved111:       equ   $0000FF20
VReserved110:       equ   $0000FF22
VReserved109:       equ   $0000FF24
VReserved108:       equ   $0000FF26
VReserved107:       equ   $0000FF28
VReserved106:       equ   $0000FF2A
VReserved105:       equ   $0000FF2C
VReserved104:       equ   $0000FF2E
VReserved103:       equ   $0000FF30
VReserved102:       equ   $0000FF32
VReserved101:       equ   $0000FF34
VReserved100:       equ   $0000FF36
VReserved99:        equ   $0000FF38
VReserved98:        equ   $0000FF3A
VReserved97:        equ   $0000FF3C
VReserved96:        equ   $0000FF3E
VReserved95:        equ   $0000FF40
VReserved94:        equ   $0000FF42
VReserved93:        equ   $0000FF44
VReserved92:        equ   $0000FF46
VReserved91:        equ   $0000FF48
VReserved90:        equ   $0000FF4A
VReserved89:        equ   $0000FF4C
VReserved88:        equ   $0000FF4E
VReserved87:        equ   $0000FF50
VReserved86:        equ   $0000FF52
VReserved85:        equ   $0000FF54
VReserved84:        equ   $0000FF56
VReserved83:        equ   $0000FF58
VReserved82:        equ   $0000FF5A
VReserved81:        equ   $0000FF5C
VReserved80:        equ   $0000FF5E
Vxsramav:           equ   $0000FF60
Vxsei:              equ   $0000FF62
Vxst7:              equ   $0000FF64
Vxst6:              equ   $0000FF66
Vxst5:              equ   $0000FF68
Vxst4:              equ   $0000FF6A
Vxst3:              equ   $0000FF6C
Vxst2:              equ   $0000FF6E
Vxst1:              equ   $0000FF70
Vxst0:              equ   $0000FF72
Vpit3:              equ   $0000FF74
Vpit2:              equ   $0000FF76
Vpit1:              equ   $0000FF78
Vpit0:              equ   $0000FF7A
VReserved65:        equ   $0000FF7C
Vapi:               equ   $0000FF7E
Vlvi:               equ   $0000FF80
Viic1:              equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
VReserved58:        equ   $0000FF8A
Vpwmesdn:           equ   $0000FF8C
VReserved56:        equ   $0000FF8E
VReserved55:        equ   $0000FF90
VReserved54:        equ   $0000FF92
VReserved53:        equ   $0000FF94
Vmctimovf:          equ   $0000FF96
Vssd5:              equ   $0000FF98
Vssd3:              equ   $0000FF9A
Vssd2:              equ   $0000FF9C
Vssd1:              equ   $0000FF9E
Vssd0:              equ   $0000FFA0
Vssd4:              equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
Vcan1tx:            equ   $0000FFA8
Vcan1rx:            equ   $0000FFAA
Vcan1err:           equ   $0000FFAC
Vcan1wkup:          equ   $0000FFAE
Vcan0tx:            equ   $0000FFB0
Vcan0rx:            equ   $0000FFB2
Vcan0err:           equ   $0000FFB4
Vcan0wkup:          equ   $0000FFB6
Vflash:             equ   $0000FFB8
Veeprom:            equ   $0000FFBA
VReserved33:        equ   $0000FFBC
VReserved32:        equ   $0000FFBE
Viic0:              equ   $0000FFC0
VReserved30:        equ   $0000FFC2
Vcrgscm:            equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
Vtimpabovf:         equ   $0000FFC8
Vtimmdcu:           equ   $0000FFCA
VReserved25:        equ   $0000FFCC
Vportad:            equ   $0000FFCE
VReserved23:        equ   $0000FFD0
Vatd:               equ   $0000FFD2
Vsci1:              equ   $0000FFD4
Vsci0:              equ   $0000FFD6
Vspi:               equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaaovf:         equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
Vtimch3:            equ   $0000FFE8
Vtimch2:            equ   $0000FFEA
Vtimch1:            equ   $0000FFEC
Vtimch0:            equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Data Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_PB0:         equ    0                                         ; Port B Bit 0
PORTAB_PB1:         equ    1                                         ; Port B Bit 1
PORTAB_PB2:         equ    2                                         ; Port B Bit 2
PORTAB_PB3:         equ    3                                         ; Port B Bit 3
PORTAB_PB4:         equ    4                                         ; Port B Bit 4
PORTAB_PB5:         equ    5                                         ; Port B Bit 5
PORTAB_PB6:         equ    6                                         ; Port B Bit 6
PORTAB_PB7:         equ    7                                         ; Port B Bit 7
PORTAB_PA0:         equ    8                                         ; Port A Bit 0
PORTAB_PA1:         equ    9                                         ; Port A Bit 1
PORTAB_PA2:         equ    10                                        ; Port A Bit 2
PORTAB_PA3:         equ    11                                        ; Port A Bit 3
PORTAB_PA4:         equ    12                                        ; Port A Bit 4
PORTAB_PA5:         equ    13                                        ; Port A Bit 5
PORTAB_PA6:         equ    14                                        ; Port A Bit 6
PORTAB_PA7:         equ    15                                        ; Port A Bit 7
; bit position masks
mPORTAB_PB0:        equ    %00000001
mPORTAB_PB1:        equ    %00000010
mPORTAB_PB2:        equ    %00000100
mPORTAB_PB3:        equ    %00001000
mPORTAB_PB4:        equ    %00010000
mPORTAB_PB5:        equ    %00100000
mPORTAB_PB6:        equ    %01000000
mPORTAB_PB7:        equ    %10000000
mPORTAB_PA0:        equ    %100000000
mPORTAB_PA1:        equ    %1000000000
mPORTAB_PA2:        equ    %10000000000
mPORTAB_PA3:        equ    %100000000000
mPORTAB_PA4:        equ    %1000000000000
mPORTAB_PA5:        equ    %10000000000000
mPORTAB_PA6:        equ    %100000000000000
mPORTAB_PA7:        equ    %1000000000000000


;*** PORTA - Port A Data Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_PA0:          equ    0                                         ; Port A Bit 0
PORTA_PA1:          equ    1                                         ; Port A Bit 1
PORTA_PA2:          equ    2                                         ; Port A Bit 2
PORTA_PA3:          equ    3                                         ; Port A Bit 3
PORTA_PA4:          equ    4                                         ; Port A Bit 4
PORTA_PA5:          equ    5                                         ; Port A Bit 5
PORTA_PA6:          equ    6                                         ; Port A Bit 6
PORTA_PA7:          equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_PA0:         equ    %00000001
mPORTA_PA1:         equ    %00000010
mPORTA_PA2:         equ    %00000100
mPORTA_PA3:         equ    %00001000
mPORTA_PA4:         equ    %00010000
mPORTA_PA5:         equ    %00100000
mPORTA_PA6:         equ    %01000000
mPORTA_PA7:         equ    %10000000


;*** PORTB - Port B Data Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Data Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_PB0:          equ    0                                         ; Port B Bit 0
PORTB_PB1:          equ    1                                         ; Port B Bit 1
PORTB_PB2:          equ    2                                         ; Port B Bit 2
PORTB_PB3:          equ    3                                         ; Port B Bit 3
PORTB_PB4:          equ    4                                         ; Port B Bit 4
PORTB_PB5:          equ    5                                         ; Port B Bit 5
PORTB_PB6:          equ    6                                         ; Port B Bit 6
PORTB_PB7:          equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_PB0:         equ    %00000001
mPORTB_PB1:         equ    %00000010
mPORTB_PB2:         equ    %00000100
mPORTB_PB3:         equ    %00001000
mPORTB_PB4:         equ    %00010000
mPORTB_PB5:         equ    %00100000
mPORTB_PB6:         equ    %01000000
mPORTB_PB7:         equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_DDRB0:        equ    0                                         ; Data Direction Port B Bit 0
DDRAB_DDRB1:        equ    1                                         ; Data Direction Port B Bit 1
DDRAB_DDRB2:        equ    2                                         ; Data Direction Port B Bit 2
DDRAB_DDRB3:        equ    3                                         ; Data Direction Port B Bit 3
DDRAB_DDRB4:        equ    4                                         ; Data Direction Port B Bit 4
DDRAB_DDRB5:        equ    5                                         ; Data Direction Port B Bit 5
DDRAB_DDRB6:        equ    6                                         ; Data Direction Port B Bit 6
DDRAB_DDRB7:        equ    7                                         ; Data Direction Port B Bit 7
DDRAB_DDRA0:        equ    8                                         ; Data Direction Port A Bit 0
DDRAB_DDRA1:        equ    9                                         ; Data Direction Port A Bit 1
DDRAB_DDRA2:        equ    10                                        ; Data Direction Port A Bit 2
DDRAB_DDRA3:        equ    11                                        ; Data Direction Port A Bit 3
DDRAB_DDRA4:        equ    12                                        ; Data Direction Port A Bit 4
DDRAB_DDRA5:        equ    13                                        ; Data Direction Port A Bit 5
DDRAB_DDRA6:        equ    14                                        ; Data Direction Port A Bit 6
DDRAB_DDRA7:        equ    15                                        ; Data Direction Port A Bit 7
; bit position masks
mDDRAB_DDRB0:       equ    %00000001
mDDRAB_DDRB1:       equ    %00000010
mDDRAB_DDRB2:       equ    %00000100
mDDRAB_DDRB3:       equ    %00001000
mDDRAB_DDRB4:       equ    %00010000
mDDRAB_DDRB5:       equ    %00100000
mDDRAB_DDRB6:       equ    %01000000
mDDRAB_DDRB7:       equ    %10000000
mDDRAB_DDRA0:       equ    %100000000
mDDRAB_DDRA1:       equ    %1000000000
mDDRAB_DDRA2:       equ    %10000000000
mDDRAB_DDRA3:       equ    %100000000000
mDDRAB_DDRA4:       equ    %1000000000000
mDDRAB_DDRA5:       equ    %10000000000000
mDDRAB_DDRA6:       equ    %100000000000000
mDDRAB_DDRA7:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Port A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Port A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Port A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Port A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Port A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Port A Bit 5
DDRA_DDRA6:         equ    6                                         ; Data Direction Port A Bit 6
DDRA_DDRA7:         equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000
mDDRA_DDRA6:        equ    %01000000
mDDRA_DDRA7:        equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_DDRB0:         equ    0                                         ; Data Direction Port B Bit 0
DDRB_DDRB1:         equ    1                                         ; Data Direction Port B Bit 1
DDRB_DDRB2:         equ    2                                         ; Data Direction Port B Bit 2
DDRB_DDRB3:         equ    3                                         ; Data Direction Port B Bit 3
DDRB_DDRB4:         equ    4                                         ; Data Direction Port B Bit 4
DDRB_DDRB5:         equ    5                                         ; Data Direction Port B Bit 5
DDRB_DDRB6:         equ    6                                         ; Data Direction Port B Bit 6
DDRB_DDRB7:         equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_DDRB0:        equ    %00000001
mDDRB_DDRB1:        equ    %00000010
mDDRB_DDRB2:        equ    %00000100
mDDRB_DDRB3:        equ    %00001000
mDDRB_DDRB4:        equ    %00010000
mDDRB_DDRB5:        equ    %00100000
mDDRB_DDRB6:        equ    %01000000
mDDRB_DDRB7:        equ    %10000000


;*** PORTCD - Port CD Data Register; 0x00000004 ***
PORTCD:             equ    $00000004                                ;*** PORTCD - Port CD Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTCD_PD0:         equ    0                                         ; Port D Bit 0
PORTCD_PD1:         equ    1                                         ; Port D Bit 1
PORTCD_PD2:         equ    2                                         ; Port D Bit 2
PORTCD_PD3:         equ    3                                         ; Port D Bit 3
PORTCD_PD4:         equ    4                                         ; Port D Bit 4
PORTCD_PD5:         equ    5                                         ; Port D Bit 5
PORTCD_PD6:         equ    6                                         ; Port D Bit 6
PORTCD_PD7:         equ    7                                         ; Port D Bit 7
PORTCD_PC0:         equ    8                                         ; Port C Bit 0
PORTCD_PC1:         equ    9                                         ; Port C Bit 1
PORTCD_PC2:         equ    10                                        ; Port C Bit 2
PORTCD_PC3:         equ    11                                        ; Port C Bit 3
PORTCD_PC4:         equ    12                                        ; Port C Bit 4
PORTCD_PC5:         equ    13                                        ; Port C Bit 5
PORTCD_PC6:         equ    14                                        ; Port C Bit 6
PORTCD_PC7:         equ    15                                        ; Port C Bit 7
; bit position masks
mPORTCD_PD0:        equ    %00000001
mPORTCD_PD1:        equ    %00000010
mPORTCD_PD2:        equ    %00000100
mPORTCD_PD3:        equ    %00001000
mPORTCD_PD4:        equ    %00010000
mPORTCD_PD5:        equ    %00100000
mPORTCD_PD6:        equ    %01000000
mPORTCD_PD7:        equ    %10000000
mPORTCD_PC0:        equ    %100000000
mPORTCD_PC1:        equ    %1000000000
mPORTCD_PC2:        equ    %10000000000
mPORTCD_PC3:        equ    %100000000000
mPORTCD_PC4:        equ    %1000000000000
mPORTCD_PC5:        equ    %10000000000000
mPORTCD_PC6:        equ    %100000000000000
mPORTCD_PC7:        equ    %1000000000000000


;*** PORTC - Port C Data Register; 0x00000004 ***
PORTC:              equ    $00000004                                ;*** PORTC - Port C Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTC_PC0:          equ    0                                         ; Port C Bit 0
PORTC_PC1:          equ    1                                         ; Port C Bit 1
PORTC_PC2:          equ    2                                         ; Port C Bit 2
PORTC_PC3:          equ    3                                         ; Port C Bit 3
PORTC_PC4:          equ    4                                         ; Port C Bit 4
PORTC_PC5:          equ    5                                         ; Port C Bit 5
PORTC_PC6:          equ    6                                         ; Port C Bit 6
PORTC_PC7:          equ    7                                         ; Port C Bit 7
; bit position masks
mPORTC_PC0:         equ    %00000001
mPORTC_PC1:         equ    %00000010
mPORTC_PC2:         equ    %00000100
mPORTC_PC3:         equ    %00001000
mPORTC_PC4:         equ    %00010000
mPORTC_PC5:         equ    %00100000
mPORTC_PC6:         equ    %01000000
mPORTC_PC7:         equ    %10000000


;*** PORTD - Port D Data Register; 0x00000005 ***
PORTD:              equ    $00000005                                ;*** PORTD - Port D Data Register; 0x00000005 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTD_PD0:          equ    0                                         ; Port D Bit 0
PORTD_PD1:          equ    1                                         ; Port D Bit 1
PORTD_PD2:          equ    2                                         ; Port D Bit 2
PORTD_PD3:          equ    3                                         ; Port D Bit 3
PORTD_PD4:          equ    4                                         ; Port D Bit 4
PORTD_PD5:          equ    5                                         ; Port D Bit 5
PORTD_PD6:          equ    6                                         ; Port D Bit 6
PORTD_PD7:          equ    7                                         ; Port D Bit 7
; bit position masks
mPORTD_PD0:         equ    %00000001
mPORTD_PD1:         equ    %00000010
mPORTD_PD2:         equ    %00000100
mPORTD_PD3:         equ    %00001000
mPORTD_PD4:         equ    %00010000
mPORTD_PD5:         equ    %00100000
mPORTD_PD6:         equ    %01000000
mPORTD_PD7:         equ    %10000000


;*** DDRCD - Port CD Data Direction Register; 0x00000006 ***
DDRCD:              equ    $00000006                                ;*** DDRCD - Port CD Data Direction Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRCD_DDRD0:        equ    0                                         ; Data Direction Port D Bit 0
DDRCD_DDRD1:        equ    1                                         ; Data Direction Port D Bit 1
DDRCD_DDRD2:        equ    2                                         ; Data Direction Port D Bit 2
DDRCD_DDRD3:        equ    3                                         ; Data Direction Port D Bit 3
DDRCD_DDRD4:        equ    4                                         ; Data Direction Port D Bit 4
DDRCD_DDRD5:        equ    5                                         ; Data Direction Port D Bit 5
DDRCD_DDRD6:        equ    6                                         ; Data Direction Port D Bit 6
DDRCD_DDRD7:        equ    7                                         ; Data Direction Port D Bit 7
DDRCD_DDRC0:        equ    8                                         ; Data Direction Port C Bit 0
DDRCD_DDRC1:        equ    9                                         ; Data Direction Port C Bit 1
DDRCD_DDRC2:        equ    10                                        ; Data Direction Port C Bit 2
DDRCD_DDRC3:        equ    11                                        ; Data Direction Port C Bit 3
DDRCD_DDRC4:        equ    12                                        ; Data Direction Port C Bit 4
DDRCD_DDRC5:        equ    13                                        ; Data Direction Port C Bit 5
DDRCD_DDRC6:        equ    14                                        ; Data Direction Port C Bit 6
DDRCD_DDRC7:        equ    15                                        ; Data Direction Port C Bit 7
; bit position masks
mDDRCD_DDRD0:       equ    %00000001
mDDRCD_DDRD1:       equ    %00000010
mDDRCD_DDRD2:       equ    %00000100
mDDRCD_DDRD3:       equ    %00001000
mDDRCD_DDRD4:       equ    %00010000
mDDRCD_DDRD5:       equ    %00100000
mDDRCD_DDRD6:       equ    %01000000
mDDRCD_DDRD7:       equ    %10000000
mDDRCD_DDRC0:       equ    %100000000
mDDRCD_DDRC1:       equ    %1000000000
mDDRCD_DDRC2:       equ    %10000000000
mDDRCD_DDRC3:       equ    %100000000000
mDDRCD_DDRC4:       equ    %1000000000000
mDDRCD_DDRC5:       equ    %10000000000000
mDDRCD_DDRC6:       equ    %100000000000000
mDDRCD_DDRC7:       equ    %1000000000000000


;*** DDRC - Port C Data Direction Register; 0x00000006 ***
DDRC:               equ    $00000006                                ;*** DDRC - Port C Data Direction Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRC_DDRC0:         equ    0                                         ; Data Direction Port C Bit 0
DDRC_DDRC1:         equ    1                                         ; Data Direction Port C Bit 1
DDRC_DDRC2:         equ    2                                         ; Data Direction Port C Bit 2
DDRC_DDRC3:         equ    3                                         ; Data Direction Port C Bit 3
DDRC_DDRC4:         equ    4                                         ; Data Direction Port C Bit 4
DDRC_DDRC5:         equ    5                                         ; Data Direction Port C Bit 5
DDRC_DDRC6:         equ    6                                         ; Data Direction Port C Bit 6
DDRC_DDRC7:         equ    7                                         ; Data Direction Port C Bit 7
; bit position masks
mDDRC_DDRC0:        equ    %00000001
mDDRC_DDRC1:        equ    %00000010
mDDRC_DDRC2:        equ    %00000100
mDDRC_DDRC3:        equ    %00001000
mDDRC_DDRC4:        equ    %00010000
mDDRC_DDRC5:        equ    %00100000
mDDRC_DDRC6:        equ    %01000000
mDDRC_DDRC7:        equ    %10000000


;*** DDRD - Port D Data Direction Register; 0x00000007 ***
DDRD:               equ    $00000007                                ;*** DDRD - Port D Data Direction Register; 0x00000007 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRD_DDRD0:         equ    0                                         ; Data Direction Port D Bit 0
DDRD_DDRD1:         equ    1                                         ; Data Direction Port D Bit 1
DDRD_DDRD2:         equ    2                                         ; Data Direction Port D Bit 2
DDRD_DDRD3:         equ    3                                         ; Data Direction Port D Bit 3
DDRD_DDRD4:         equ    4                                         ; Data Direction Port D Bit 4
DDRD_DDRD5:         equ    5                                         ; Data Direction Port D Bit 5
DDRD_DDRD6:         equ    6                                         ; Data Direction Port D Bit 6
DDRD_DDRD7:         equ    7                                         ; Data Direction Port D Bit 7
; bit position masks
mDDRD_DDRD0:        equ    %00000001
mDDRD_DDRD1:        equ    %00000010
mDDRD_DDRD2:        equ    %00000100
mDDRD_DDRD3:        equ    %00001000
mDDRD_DDRD4:        equ    %00010000
mDDRD_DDRD5:        equ    %00100000
mDDRD_DDRD6:        equ    %01000000
mDDRD_DDRD7:        equ    %10000000


;*** PORTE - Port E Data Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Data Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_PE0:          equ    0                                         ; Port E Bit 0
PORTE_PE1:          equ    1                                         ; Port E Bit 1
PORTE_PE2:          equ    2                                         ; Port E Bit 2
PORTE_PE3:          equ    3                                         ; Port E Bit 3
PORTE_PE4:          equ    4                                         ; Port E Bit 4
PORTE_PE5:          equ    5                                         ; Port E Bit 5
PORTE_PE6:          equ    6                                         ; Port E Bit 6
PORTE_PE7:          equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_PE0:         equ    %00000001
mPORTE_PE1:         equ    %00000010
mPORTE_PE2:         equ    %00000100
mPORTE_PE3:         equ    %00001000
mPORTE_PE4:         equ    %00010000
mPORTE_PE5:         equ    %00100000
mPORTE_PE6:         equ    %01000000
mPORTE_PE7:         equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_DDRE2:         equ    2                                         ; Data Direction Port E Bit 2
DDRE_DDRE3:         equ    3                                         ; Data Direction Port E Bit 3
DDRE_DDRE4:         equ    4                                         ; Data Direction Port E Bit 4
DDRE_DDRE5:         equ    5                                         ; Data Direction Port E Bit 5
DDRE_DDRE6:         equ    6                                         ; Data Direction Port E Bit 6
DDRE_DDRE7:         equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_DDRE2:        equ    %00000100
mDDRE_DDRE3:        equ    %00001000
mDDRE_DDRE4:        equ    %00010000
mDDRE_DDRE5:        equ    %00100000
mDDRE_DDRE6:        equ    %01000000
mDDRE_DDRE7:        equ    %10000000


;*** MMCCTL0 - MMC Control Register; 0x0000000A ***
MMCCTL0:            equ    $0000000A                                ;*** MMCCTL0 - MMC Control Register; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL0_CS0E:       equ    0                                         ; Chip Select 0 Enables
MMCCTL0_CS1E:       equ    1                                         ; Chip Select 1 Enables
MMCCTL0_CS2E:       equ    2                                         ; Chip Select 2 Enables
MMCCTL0_CS3E:       equ    3                                         ; Chip Select 3 Enables
; bit position masks
mMMCCTL0_CS0E:      equ    %00000001
mMMCCTL0_CS1E:      equ    %00000010
mMMCCTL0_CS2E:      equ    %00000100
mMMCCTL0_CS3E:      equ    %00001000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODA:          equ    5                                         ; Mode Select Bit
MODE_MODB:          equ    6                                         ; Mode Select Bit
MODE_MODC:          equ    7                                         ; Mode Select Bit
; bit position masks
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-up Port B Enable
PUCR_PUPCE:         equ    2                                         ; Pull-up Port C Enable
PUCR_PUPDE:         equ    3                                         ; Pull-up Port D Enable
PUCR_PUPEE:         equ    4                                         ; Pull-up Port E Enable
PUCR_BKPUE:         equ    6                                         ; BKGD and VREGEN Pin Pull-up Enable
PUCR_PUPKE:         equ    7                                         ; Pull-up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPCE:        equ    %00000100
mPUCR_PUPDE:        equ    %00001000
mPUCR_PUPEE:        equ    %00010000
mPUCR_BKPUE:        equ    %01000000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive Register; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPC:         equ    2                                         ; Reduced Drive of Port C
RDRIV_RDPD:         equ    3                                         ; Reduced Drive of Port D
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPC:        equ    %00000100
mRDRIV_RDPD:        equ    %00001000
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***
EBICTL0:            equ    $0000000E                                ;*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL0_ASIZ0:      equ    0                                         ; External Address Bus Size Bit 0
EBICTL0_ASIZ1:      equ    1                                         ; External Address Bus Size Bit 1
EBICTL0_ASIZ2:      equ    2                                         ; External Address Bus Size Bit 2
EBICTL0_ASIZ3:      equ    3                                         ; External Address Bus Size Bit 3
EBICTL0_ASIZ4:      equ    4                                         ; External Address Bus Size Bit 4
EBICTL0_HDBE:       equ    5                                         ; High Data Byte Enable
EBICTL0_ITHRS:      equ    7                                         ; Reduced Input Threshold
; bit position masks
mEBICTL0_ASIZ0:     equ    %00000001
mEBICTL0_ASIZ1:     equ    %00000010
mEBICTL0_ASIZ2:     equ    %00000100
mEBICTL0_ASIZ3:     equ    %00001000
mEBICTL0_ASIZ4:     equ    %00010000
mEBICTL0_HDBE:      equ    %00100000
mEBICTL0_ITHRS:     equ    %10000000


;*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***
EBICTL1:            equ    $0000000F                                ;*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL1_EXSTR0:     equ    0                                         ; External Access Stretch Bit 0
EBICTL1_EXSTR1:     equ    1                                         ; External Access Stretch Bit 1
EBICTL1_EXSTR2:     equ    2                                         ; External Access Stretch Bit 2
EBICTL1_EWAITE:     equ    7                                         ; External Wait Enable
; bit position masks
mEBICTL1_EXSTR0:    equ    %00000001
mEBICTL1_EXSTR1:    equ    %00000010
mEBICTL1_EXSTR2:    equ    %00000100
mEBICTL1_EWAITE:    equ    %10000000


;*** GPAGE - Global Page Index Register; 0x00000010 ***
GPAGE:              equ    $00000010                                ;*** GPAGE - Global Page Index Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
GPAGE_GP0:          equ    0                                         ; Global Page Index Bit 0
GPAGE_GP1:          equ    1                                         ; Global Page Index Bit 1
GPAGE_GP2:          equ    2                                         ; Global Page Index Bit 2
GPAGE_GP3:          equ    3                                         ; Global Page Index Bit 3
GPAGE_GP4:          equ    4                                         ; Global Page Index Bit 4
GPAGE_GP5:          equ    5                                         ; Global Page Index Bit 5
GPAGE_GP6:          equ    6                                         ; Global Page Index Bit 6
; bit position masks
mGPAGE_GP0:         equ    %00000001
mGPAGE_GP1:         equ    %00000010
mGPAGE_GP2:         equ    %00000100
mGPAGE_GP3:         equ    %00001000
mGPAGE_GP4:         equ    %00010000
mGPAGE_GP5:         equ    %00100000
mGPAGE_GP6:         equ    %01000000


;*** DIRECT - Direct Page Register; 0x00000011 ***
DIRECT:             equ    $00000011                                ;*** DIRECT - Direct Page Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Index Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Index Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Index Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Index Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Index Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Index Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Index Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Index Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
MMCCTL1:            equ    $00000013                                ;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL1_ROMON:      equ    0                                         ; Enable FLASH or ROM in the memory map
MMCCTL1_ROMHM:      equ    1                                         ; FLASH or ROM only in higher Half of Memory Map
MMCCTL1_EROMON:     equ    2                                         ; Enables emulated Flash or ROM memory in the memory map
; bit position masks
mMMCCTL1_ROMON:     equ    %00000001
mMMCCTL1_ROMHM:     equ    %00000010
mMMCCTL1_EROMON:    equ    %00000100


;*** RPAGE - RAM Page Index Register; 0x00000016 ***
RPAGE:              equ    $00000016                                ;*** RPAGE - RAM Page Index Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RPAGE_RP0:          equ    0                                         ; RAM Page Index Bit 0
RPAGE_RP1:          equ    1                                         ; RAM Page Index Bit 1
RPAGE_RP2:          equ    2                                         ; RAM Page Index Bit 2
RPAGE_RP3:          equ    3                                         ; RAM Page Index Bit 3
RPAGE_RP4:          equ    4                                         ; RAM Page Index Bit 4
RPAGE_RP5:          equ    5                                         ; RAM Page Index Bit 5
RPAGE_RP6:          equ    6                                         ; RAM Page Index Bit 6
RPAGE_RP7:          equ    7                                         ; RAM Page Index Bit 7
; bit position masks
mRPAGE_RP0:         equ    %00000001
mRPAGE_RP1:         equ    %00000010
mRPAGE_RP2:         equ    %00000100
mRPAGE_RP3:         equ    %00001000
mRPAGE_RP4:         equ    %00010000
mRPAGE_RP5:         equ    %00100000
mRPAGE_RP6:         equ    %01000000
mRPAGE_RP7:         equ    %10000000


;*** EPAGE - Data FLASH Page Index Register; 0x00000017 ***
EPAGE:              equ    $00000017                                ;*** EPAGE - Data FLASH Page Index Register; 0x00000017 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPAGE_EP0:          equ    0                                         ; Data FLASH Page Index Bit 0
EPAGE_EP1:          equ    1                                         ; Data FLASH Page Index Bit 1
EPAGE_EP2:          equ    2                                         ; Data FLASH Page Index Bit 2
EPAGE_EP3:          equ    3                                         ; Data FLASH Page Index Bit 3
EPAGE_EP4:          equ    4                                         ; Data FLASH Page Index Bit 4
EPAGE_EP5:          equ    5                                         ; Data FLASH Page Index Bit 5
EPAGE_EP6:          equ    6                                         ; Data FLASH Page Index Bit 6
EPAGE_EP7:          equ    7                                         ; Data FLASH Page Index Bit 7
; bit position masks
mEPAGE_EP0:         equ    %00000001
mEPAGE_EP1:         equ    %00000010
mEPAGE_EP2:         equ    %00000100
mEPAGE_EP3:         equ    %00001000
mEPAGE_EP4:         equ    %00010000
mEPAGE_EP5:         equ    %00100000
mEPAGE_EP6:         equ    %01000000
mEPAGE_EP7:         equ    %10000000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
ECLKCTL:            equ    $0000001C                                ;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKCTL_EDIV0:      equ    0                                         ; Free-running ECLK Divider, bit 0
ECLKCTL_EDIV1:      equ    1                                         ; Free-running ECLK Divider, bit 1
ECLKCTL_NCLKX2:     equ    6                                         ; No ECLKX2
ECLKCTL_NECLK:      equ    7                                         ; No ECLK
; bit position masks
mECLKCTL_EDIV0:     equ    %00000001
mECLKCTL_EDIV1:     equ    %00000010
mECLKCTL_NCLKX2:    equ    %01000000
mECLKCTL_NECLK:     equ    %10000000


;*** IRQCR - Interrupt Control Register; 0x0000001E ***
IRQCR:              equ    $0000001E                                ;*** IRQCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQCR_IRQEN:        equ    6                                         ; External IRQ Enable
IRQCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mIRQCR_IRQEN:       equ    %01000000
mIRQCR_IRQE:        equ    %10000000


;*** SRCR - Reduced Drive Register; 0x0000001F ***
SRCR:               equ    $0000001F                                ;*** SRCR - Reduced Drive Register; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRCR_SRRA:          equ    0                                         ; Reduced Drive of Port A
SRCR_SRRB:          equ    1                                         ; Reduced Drive of Port B
SRCR_SRRC:          equ    2                                         ; Reduced Drive of Port C
SRCR_SRRD:          equ    3                                         ; Reduced Drive of Port D
SRCR_SRRE:          equ    4                                         ; Reduced Drive of Port E
SRCR_SRRK:          equ    7                                         ; Reduced Drive of Port K
; bit position masks
mSRCR_SRRA:         equ    %00000001
mSRCR_SRRB:         equ    %00000010
mSRCR_SRRC:         equ    %00000100
mSRCR_SRRD:         equ    %00001000
mSRCR_SRRE:         equ    %00010000
mSRCR_SRRK:         equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV:        equ    0                                         ; Comparator Register Visibility Bits
DBGC1_DBGBRK:       equ    2                                         ; S12XDBG Breakpoint Enable Bits
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_XGSBPE:       equ    5                                         ; XGATE S/W Breakpoint Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV:       equ    %00000011
mDBGC1_DBGBRK:      equ    %00001100
mDBGC1_BDM:         equ    %00010000
mDBGC1_XGSBPE:      equ    %00100000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bits
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_EXTF:         equ    6                                         ; External Tag Hit Flag
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_EXTF:        equ    %01000000
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bits
DBGTCR_TRCMOD:      equ    2                                         ; Trace Mode Bits
DBGTCR_TRANGE:      equ    4                                         ; Trace Range Bits
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bits
; bit position masks
mDBGTCR_TALIGN:     equ    %00000011
mDBGTCR_TRCMOD:     equ    %00001100
mDBGTCR_TRANGE:     equ    %00110000
mDBGTCR_TSOURCE:    equ    %11000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM:         equ    0                                         ; A and B Comparator Match Control
DBGC2_CDCM:         equ    2                                         ; C and D Comparator Match Control
; bit position masks
mDBGC2_ABCM:        equ    %00000011
mDBGC2_CDCM:        equ    %00001100


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bits
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bits
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bits
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT:         equ    0                                         ; Count Value
; bit position masks
mDBGCNT_CNT:        equ    %01111111


;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; State X Sequencer Next State Selection Bit 0
DBGSCRX_SC1:        equ    1                                         ; State X Sequencer Next State Selection Bit 1
DBGSCRX_SC2:        equ    2                                         ; State X Sequencer Next State Selection Bit 2
DBGSCRX_SC3:        equ    3                                         ; State X Sequencer Next State Selection Bit 3
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100
mDBGSCRX_SC3:       equ    %00001000


;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; Debug Match Flag Bit 0
DBGMFR_MC1:         equ    1                                         ; Debug Match Flag Bit 1
DBGMFR_MC2:         equ    2                                         ; Debug Match Flag Bit 2
DBGMFR_MC3:         equ    3                                         ; Debug Match Flag Bit 3
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100
mDBGMFR_MC3:        equ    %00001000


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_SRC:        equ    1                                         ; Determines mapping of comparator to CPU or XGATE
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_BRK:        equ    4                                         ; Break
DBGXCTL_TAG:        equ    5                                         ; Tag Select
DBGXCTL_NDB_SZ:     equ    6                                         ; Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D)
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_SRC:       equ    %00000010
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_BRK:       equ    %00010000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_NDB_SZ:    equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bits
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
DBGXAH_BIT18:       equ    2                                         ; Comparator Address High Compare Bit 18
DBGXAH_BIT19:       equ    3                                         ; Comparator Address High Compare Bit 19
DBGXAH_BIT20:       equ    4                                         ; Comparator Address High Compare Bit 20
DBGXAH_BIT21:       equ    5                                         ; Comparator Address High Compare Bit 21
DBGXAH_BIT22:       equ    6                                         ; Comparator Address High Compare Bit 22
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010
mDBGXAH_BIT18:      equ    %00000100
mDBGXAH_BIT19:      equ    %00001000
mDBGXAH_BIT20:      equ    %00010000
mDBGXAH_BIT21:      equ    %00100000
mDBGXAH_BIT22:      equ    %01000000


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bits
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bits
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***
DBGXDH:             equ    $0000002C                                ;*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDH_BIT8:        equ    0                                         ; Comparator Data High Compare Bit 8
DBGXDH_BIT9:        equ    1                                         ; Comparator Data High Compare Bit 9
DBGXDH_BIT10:       equ    2                                         ; Comparator Data High Compare Bit 10
DBGXDH_BIT11:       equ    3                                         ; Comparator Data High Compare Bit 11
DBGXDH_BIT12:       equ    4                                         ; Comparator Data High Compare Bit 12
DBGXDH_BIT13:       equ    5                                         ; Comparator Data High Compare Bit 13
DBGXDH_BIT14:       equ    6                                         ; Comparator Data High Compare Bit 14
DBGXDH_BIT15:       equ    7                                         ; Comparator Data High Compare Bit 15
; bit position masks
mDBGXDH_BIT8:       equ    %00000001
mDBGXDH_BIT9:       equ    %00000010
mDBGXDH_BIT10:      equ    %00000100
mDBGXDH_BIT11:      equ    %00001000
mDBGXDH_BIT12:      equ    %00010000
mDBGXDH_BIT13:      equ    %00100000
mDBGXDH_BIT14:      equ    %01000000
mDBGXDH_BIT15:      equ    %10000000


;*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***
DBGXDL:             equ    $0000002D                                ;*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDL_BIT0:        equ    0                                         ; Comparator Data Low Compare Bit 0
DBGXDL_BIT1:        equ    1                                         ; Comparator Data Low Compare Bit 1
DBGXDL_BIT2:        equ    2                                         ; Comparator Data Low Compare Bit 2
DBGXDL_BIT3:        equ    3                                         ; Comparator Data Low Compare Bit 3
DBGXDL_BIT4:        equ    4                                         ; Comparator Data Low Compare Bit 4
DBGXDL_BIT5:        equ    5                                         ; Comparator Data Low Compare Bit 5
DBGXDL_BIT6:        equ    6                                         ; Comparator Data Low Compare Bit 6
DBGXDL_BIT7:        equ    7                                         ; Comparator Data Low Compare Bit 7
; bit position masks
mDBGXDL_BIT0:       equ    %00000001
mDBGXDL_BIT1:       equ    %00000010
mDBGXDL_BIT2:       equ    %00000100
mDBGXDL_BIT3:       equ    %00001000
mDBGXDL_BIT4:       equ    %00010000
mDBGXDL_BIT5:       equ    %00100000
mDBGXDL_BIT6:       equ    %01000000
mDBGXDL_BIT7:       equ    %10000000


;*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGXDHM:            equ    $0000002E                                ;*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGXDHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGXDHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGXDHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGXDHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGXDHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGXDHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGXDHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGXDHM_BIT8:      equ    %00000001
mDBGXDHM_BIT9:      equ    %00000010
mDBGXDHM_BIT10:     equ    %00000100
mDBGXDHM_BIT11:     equ    %00001000
mDBGXDHM_BIT12:     equ    %00010000
mDBGXDHM_BIT13:     equ    %00100000
mDBGXDHM_BIT14:     equ    %01000000
mDBGXDHM_BIT15:     equ    %10000000


;*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGXDLM:            equ    $0000002F                                ;*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDLM_BIT0:       equ    0                                         ; Comparator Data Low Mask Bit 0
DBGXDLM_BIT1:       equ    1                                         ; Comparator Data Low Mask Bit 1
DBGXDLM_BIT2:       equ    2                                         ; Comparator Data Low Mask Bit 2
DBGXDLM_BIT3:       equ    3                                         ; Comparator Data Low Mask Bit 3
DBGXDLM_BIT4:       equ    4                                         ; Comparator Data Low Mask Bit 4
DBGXDLM_BIT5:       equ    5                                         ; Comparator Data Low Mask Bit 5
DBGXDLM_BIT6:       equ    6                                         ; Comparator Data Low Mask Bit 6
DBGXDLM_BIT7:       equ    7                                         ; Comparator Data Low Mask Bit 7
; bit position masks
mDBGXDLM_BIT0:      equ    %00000001
mDBGXDLM_BIT1:      equ    %00000010
mDBGXDLM_BIT2:      equ    %00000100
mDBGXDLM_BIT3:      equ    %00001000
mDBGXDLM_BIT4:      equ    %00010000
mDBGXDLM_BIT5:      equ    %00100000
mDBGXDLM_BIT6:      equ    %01000000
mDBGXDLM_BIT7:      equ    %10000000


;*** PPAGE - Program Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Program Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
PPAGE_PIX4:         equ    4                                         ; Program Page Index Bit 4
PPAGE_PIX5:         equ    5                                         ; Program Page Index Bit 5
PPAGE_PIX6:         equ    6                                         ; Program Page Index Bit 6
PPAGE_PIX7:         equ    7                                         ; Program Page Index Bit 7
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000
mPPAGE_PIX6:        equ    %01000000
mPPAGE_PIX7:        equ    %10000000


;*** PORTK - Port K Data Register; 0x00000032 ***
PORTK:              equ    $00000032                                ;*** PORTK - Port K Data Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTK_PK0:          equ    0                                         ; Port K Bit 0
PORTK_PK1:          equ    1                                         ; Port K Bit 1
PORTK_PK2:          equ    2                                         ; Port K Bit 2
PORTK_PK3:          equ    3                                         ; Port K Bit 3
PORTK_PK4:          equ    4                                         ; Port K Bit 4
PORTK_PK5:          equ    5                                         ; Port K Bit 5
PORTK_PK6:          equ    6                                         ; Port K Bit 6
PORTK_PK7:          equ    7                                         ; Port K Bit 7
; bit position masks
mPORTK_PK0:         equ    %00000001
mPORTK_PK1:         equ    %00000010
mPORTK_PK2:         equ    %00000100
mPORTK_PK3:         equ    %00001000
mPORTK_PK4:         equ    %00010000
mPORTK_PK5:         equ    %00100000
mPORTK_PK6:         equ    %01000000
mPORTK_PK7:         equ    %10000000


;*** DDRK - Port K Data Direction Register; 0x00000033 ***
DDRK:               equ    $00000033                                ;*** DDRK - Port K Data Direction Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRK_DDRK0:         equ    0                                         ; Data Direction Port K Bit 0
DDRK_DDRK1:         equ    1                                         ; Data Direction Port K Bit 1
DDRK_DDRK2:         equ    2                                         ; Data Direction Port K Bit 2
DDRK_DDRK3:         equ    3                                         ; Data Direction Port K Bit 3
DDRK_DDRK4:         equ    4                                         ; Data Direction Port K Bit 4
DDRK_DDRK5:         equ    5                                         ; Data Direction Port K Bit 5
DDRK_DDRK6:         equ    6                                         ; Data Direction Port K Bit 6
DDRK_DDRK7:         equ    7                                         ; Data Direction Port K Bit 7
; bit position masks
mDDRK_DDRK0:        equ    %00000001
mDDRK_DDRK1:        equ    %00000010
mDDRK_DDRK2:        equ    %00000100
mDDRK_DDRK3:        equ    %00001000
mDDRK_DDRK4:        equ    %00010000
mDDRK_DDRK5:        equ    %00100000
mDDRK_DDRK6:        equ    %01000000
mDDRK_DDRK7:        equ    %10000000


;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
SYNR:               equ    $00000034                                ;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYNR_SYN0:          equ    0                                         ; CRG Synthesizer Bit 0
SYNR_SYN1:          equ    1                                         ; CRG Synthesizer Bit 1
SYNR_SYN2:          equ    2                                         ; CRG Synthesizer Bit 2
SYNR_SYN3:          equ    3                                         ; CRG Synthesizer Bit 3
SYNR_SYN4:          equ    4                                         ; CRG Synthesizer Bit 4
SYNR_SYN5:          equ    5                                         ; CRG Synthesizer Bit 5
; bit position masks
mSYNR_SYN0:         equ    %00000001
mSYNR_SYN1:         equ    %00000010
mSYNR_SYN2:         equ    %00000100
mSYNR_SYN3:         equ    %00001000
mSYNR_SYN4:         equ    %00010000
mSYNR_SYN5:         equ    %00100000


;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDV0:       equ    0                                         ; CRG Reference Divider Bit 0
REFDV_REFDV1:       equ    1                                         ; CRG Reference Divider Bit 1
REFDV_REFDV2:       equ    2                                         ; CRG Reference Divider Bit 2
REFDV_REFDV3:       equ    3                                         ; CRG Reference Divider Bit 3
REFDV_REFDV4:       equ    4                                         ; CRG Reference Divider Bit 4
REFDV_REFDV5:       equ    5                                         ; CRG Reference Divider Bit 5
; bit position masks
mREFDV_REFDV0:      equ    %00000001
mREFDV_REFDV1:      equ    %00000010
mREFDV_REFDV2:      equ    %00000100
mREFDV_REFDV3:      equ    %00001000
mREFDV_REFDV4:      equ    %00010000
mREFDV_REFDV5:      equ    %00100000


;*** CRGFLG - CRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - CRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_SCM:         equ    0                                         ; Self-clock mode Status
CRGFLG_SCMIF:       equ    1                                         ; Self-clock mode Interrupt Flag
CRGFLG_TRACK:       equ    2                                         ; Track Status
CRGFLG_LOCK:        equ    3                                         ; Lock Status
CRGFLG_LOCKIF:      equ    4                                         ; PLL Lock Interrupt Flag
CRGFLG_LVRF:        equ    5                                         ; Low Voltage Reset Flag
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_SCM:        equ    %00000001
mCRGFLG_SCMIF:      equ    %00000010
mCRGFLG_TRACK:      equ    %00000100
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_LVRF:       equ    %00100000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_SCMIE:       equ    1                                         ; Self-clock mode Interrupt Enable
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable
CRGINT_ILAF:        equ    6                                         ; Illegal Address Reset Flag
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable
; bit position masks
mCRGINT_SCMIE:      equ    %00000010
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_ILAF:       equ    %01000000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP stops in WAIT mode
CLKSEL_RTIWAI:      equ    1                                         ; RTI stops in WAIT mode
CLKSEL_PLLWAI:      equ    3                                         ; PLL stops in WAIT mode
CLKSEL_PSTP:        equ    6                                         ; Pseudo Stop
CLKSEL_PLLSEL:      equ    7                                         ; PLL selected for system clock
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_PLLWAI:     equ    %00001000
mCLKSEL_PSTP:       equ    %01000000
mCLKSEL_PLLSEL:     equ    %10000000


;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
PLLCTL:             equ    $0000003A                                ;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PLLCTL_SCME:        equ    0                                         ; Self-clock mode enable
PLLCTL_PCE:         equ    1                                         ; COP Enable during Pseudo Stop Bit
PLLCTL_PRE:         equ    2                                         ; RTI Enable during Pseudo Stop Bit
PLLCTL_FSTWKP:      equ    3                                         ; Fast Wake-up from Full Stop Bit
PLLCTL_ACQ:         equ    4                                         ; Acquisition
PLLCTL_AUTO:        equ    5                                         ; Automatic Bandwidth Control
PLLCTL_PLLON:       equ    6                                         ; Phase Lock Loop On
PLLCTL_CME:         equ    7                                         ; Clock Monitor Enable
; bit position masks
mPLLCTL_SCME:       equ    %00000001
mPLLCTL_PCE:        equ    %00000010
mPLLCTL_PRE:        equ    %00000100
mPLLCTL_FSTWKP:     equ    %00001000
mPLLCTL_ACQ:        equ    %00010000
mPLLCTL_AUTO:       equ    %00100000
mPLLCTL_PLLON:      equ    %01000000
mPLLCTL_CME:        equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
RTICTL_RTDEC:       equ    7                                         ; Decimal or Binary Divider Select Bit
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000
mRTICTL_RTDEC:      equ    %10000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_WRTMASK:     equ    5                                         ; Write Mask for WCOP
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_WRTMASK:    equ    %00100000
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS0:          equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIOS_IOS1:          equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIOS_IOS2:          equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIOS_IOS3:          equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS0:         equ    %00000001
mTIOS_IOS1:         equ    %00000010
mTIOS_IOS2:         equ    %00000100
mTIOS_IOS3:         equ    %00001000
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC0:         equ    0                                         ; Force Output Compare Action for Channel 0
CFORC_FOC1:         equ    1                                         ; Force Output Compare Action for Channel 1
CFORC_FOC2:         equ    2                                         ; Force Output Compare Action for Channel 2
CFORC_FOC3:         equ    3                                         ; Force Output Compare Action for Channel 3
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC0:        equ    %00000001
mCFORC_FOC1:        equ    %00000010
mCFORC_FOC2:        equ    %00000100
mCFORC_FOC3:        equ    %00001000
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M0:         equ    0                                         ; Output Compare 7 Mask Bit 0
OC7M_OC7M1:         equ    1                                         ; Output Compare 7 Mask Bit 1
OC7M_OC7M2:         equ    2                                         ; Output Compare 7 Mask Bit 2
OC7M_OC7M3:         equ    3                                         ; Output Compare 7 Mask Bit 3
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M0:        equ    %00000001
mOC7M_OC7M1:        equ    %00000010
mOC7M_OC7M2:        equ    %00000100
mOC7M_OC7M3:        equ    %00001000
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_PRNT:         equ    3                                         ; Precision Timer
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_PRNT:        equ    %00001000
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV0:          equ    0                                         ; Toggle On Overflow Bit 0
TTOV_TOV1:          equ    1                                         ; Toggle On Overflow Bit 1
TTOV_TOV2:          equ    2                                         ; Toggle On Overflow Bit 2
TTOV_TOV3:          equ    3                                         ; Toggle On Overflow Bit 3
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV0:         equ    %00000001
mTTOV_TOV1:         equ    %00000010
mTTOV_TOV2:         equ    %00000100
mTTOV_TOV3:         equ    %00001000
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
TCTL2:              equ    $00000049                                ;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL2_OL0:          equ    0                                         ; Output Level Bit 0
TCTL2_OM0:          equ    1                                         ; Output Mode Bit 0
TCTL2_OL1:          equ    2                                         ; Output Lecel Bit 1
TCTL2_OM1:          equ    3                                         ; Output Mode Bit 1
TCTL2_OL2:          equ    4                                         ; Output Level Bit 2
TCTL2_OM2:          equ    5                                         ; Output Mode Bit 2
TCTL2_OL3:          equ    6                                         ; Output Level Bit 3
TCTL2_OM3:          equ    7                                         ; Output Mode Bit 3
; bit position masks
mTCTL2_OL0:         equ    %00000001
mTCTL2_OM0:         equ    %00000010
mTCTL2_OL1:         equ    %00000100
mTCTL2_OM1:         equ    %00001000
mTCTL2_OL2:         equ    %00010000
mTCTL2_OM2:         equ    %00100000
mTCTL2_OL3:         equ    %01000000
mTCTL2_OM3:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
TCTL4:              equ    $0000004B                                ;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL4_EDG0A:        equ    0                                         ; Input Capture Edge Control 0A
TCTL4_EDG0B:        equ    1                                         ; Input Capture Edge Control 0B
TCTL4_EDG1A:        equ    2                                         ; Input Capture Edge Control 1A
TCTL4_EDG1B:        equ    3                                         ; Input Capture Edge Control 1B
TCTL4_EDG2A:        equ    4                                         ; Input Capture Edge Control 2A
TCTL4_EDG2B:        equ    5                                         ; Input Capture Edge Control 2B
TCTL4_EDG3A:        equ    6                                         ; Input Capture Edge Control 3A
TCTL4_EDG3B:        equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTCTL4_EDG0A:       equ    %00000001
mTCTL4_EDG0B:       equ    %00000010
mTCTL4_EDG1A:       equ    %00000100
mTCTL4_EDG1B:       equ    %00001000
mTCTL4_EDG2A:       equ    %00010000
mTCTL4_EDG2B:       equ    %00100000
mTCTL4_EDG3A:       equ    %01000000
mTCTL4_EDG3B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C0I:            equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIE_C1I:            equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIE_C2I:            equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIE_C3I:            equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C0I:           equ    %00000001
mTIE_C1I:           equ    %00000010
mTIE_C2I:           equ    %00000100
mTIE_C3I:           equ    %00001000
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C0F:          equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TFLG1_C1F:          equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TFLG1_C2F:          equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TFLG1_C3F:          equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C0F:         equ    %00000001
mTFLG1_C1F:         equ    %00000010
mTFLG1_C2F:         equ    %00000100
mTFLG1_C3F:         equ    %00001000
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***
TC0:                equ    $00000050                                ;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***


;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***
TC0Hi:              equ    $00000050                                ;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***


;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***
TC0Lo:              equ    $00000051                                ;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***


;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***
TC1:                equ    $00000052                                ;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***


;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***
TC1Hi:              equ    $00000052                                ;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***


;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***
TC1Lo:              equ    $00000053                                ;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***


;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TC2:                equ    $00000054                                ;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TC2Hi:              equ    $00000054                                ;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TC2Lo:              equ    $00000055                                ;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TC3:                equ    $00000056                                ;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TC3Hi:              equ    $00000056                                ;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TC3Lo:              equ    $00000057                                ;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***
PACN32:             equ    $00000062                                ;*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***


;*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***
PACN3:              equ    $00000062                                ;*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***


;*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***
PACN2:              equ    $00000063                                ;*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***


;*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***
PACN10:             equ    $00000064                                ;*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***


;*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***
PACN1:              equ    $00000064                                ;*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***


;*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***
PACN0:              equ    $00000065                                ;*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***


;*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***
MCCTL:              equ    $00000066                                ;*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL_MCPR0:        equ    0                                         ; Modulus Counter Prescaler select 0
MCCTL_MCPR1:        equ    1                                         ; Modulus Counter Prescaler select 1
MCCTL_MCEN:         equ    2                                         ; Modulus Down-Counter Enable
MCCTL_FLMC:         equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MCCTL_ICLAT:        equ    4                                         ; Input Capture Force Latch Action
MCCTL_RDMCL:        equ    5                                         ; Read Modulus Down-Counter Load
MCCTL_MODMC:        equ    6                                         ; Modulus Mode Enable
MCCTL_MCZI:         equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMCCTL_MCPR0:       equ    %00000001
mMCCTL_MCPR1:       equ    %00000010
mMCCTL_MCEN:        equ    %00000100
mMCCTL_FLMC:        equ    %00001000
mMCCTL_ICLAT:       equ    %00010000
mMCCTL_RDMCL:       equ    %00100000
mMCCTL_MODMC:       equ    %01000000
mMCCTL_MCZI:        equ    %10000000


;*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***
MCFLG:              equ    $00000067                                ;*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCFLG_POLF0:        equ    0                                         ; First Input Capture Polarity Status 0
MCFLG_POLF1:        equ    1                                         ; First Input Capture Polarity Status 1
MCFLG_POLF2:        equ    2                                         ; First Input Capture Polarity Status 2
MCFLG_POLF3:        equ    3                                         ; First Input Capture Polarity Status 3
MCFLG_MCZF:         equ    7                                         ; Modulus Counter Underflow Flag
; bit position masks
mMCFLG_POLF0:       equ    %00000001
mMCFLG_POLF1:       equ    %00000010
mMCFLG_POLF2:       equ    %00000100
mMCFLG_POLF3:       equ    %00001000
mMCFLG_MCZF:        equ    %10000000


;*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***
ICPAR:              equ    $00000068                                ;*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICPAR_PA0EN:        equ    0                                         ; 8-Bit Pulse Accumulator 0 Enable
ICPAR_PA1EN:        equ    1                                         ; 8-Bit Pulse Accumulator 1 Enable
ICPAR_PA2EN:        equ    2                                         ; 8-Bit Pulse Accumulator 2 Enable
ICPAR_PA3EN:        equ    3                                         ; 8-Bit Pulse Accumulator 3 Enable
; bit position masks
mICPAR_PA0EN:       equ    %00000001
mICPAR_PA1EN:       equ    %00000010
mICPAR_PA2EN:       equ    %00000100
mICPAR_PA3EN:       equ    %00001000


;*** DLYCT - Delay Counter Control Register; 0x00000069 ***
DLYCT:              equ    $00000069                                ;*** DLYCT - Delay Counter Control Register; 0x00000069 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DLYCT_DLY0:         equ    0                                         ; Delay Counter Select 0
DLYCT_DLY1:         equ    1                                         ; Delay Counter Select 1
DLYCT_DLY2:         equ    2                                         ; Delay Counter Select 2
DLYCT_DLY3:         equ    3                                         ; Delay Counter Select 3
DLYCT_DLY4:         equ    4                                         ; Delay Counter Select 4
DLYCT_DLY5:         equ    5                                         ; Delay Counter Select 5
DLYCT_DLY6:         equ    6                                         ; Delay Counter Select 6
DLYCT_DLY7:         equ    7                                         ; Delay Counter Select 7
; bit position masks
mDLYCT_DLY0:        equ    %00000001
mDLYCT_DLY1:        equ    %00000010
mDLYCT_DLY2:        equ    %00000100
mDLYCT_DLY3:        equ    %00001000
mDLYCT_DLY4:        equ    %00010000
mDLYCT_DLY5:        equ    %00100000
mDLYCT_DLY6:        equ    %01000000
mDLYCT_DLY7:        equ    %10000000


;*** ICOVW - Input Control Overwrite Register; 0x0000006A ***
ICOVW:              equ    $0000006A                                ;*** ICOVW - Input Control Overwrite Register; 0x0000006A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICOVW_NOVW0:        equ    0                                         ; No Input Capture Overwrite 0
ICOVW_NOVW1:        equ    1                                         ; No Input Capture Overwrite 1
ICOVW_NOVW2:        equ    2                                         ; No Input Capture Overwrite 2
ICOVW_NOVW3:        equ    3                                         ; No Input Capture Overwrite 3
ICOVW_NOVW4:        equ    4                                         ; No Input Capture Overwrite 4
ICOVW_NOVW5:        equ    5                                         ; No Input Capture Overwrite 5
ICOVW_NOVW6:        equ    6                                         ; No Input Capture Overwrite 6
ICOVW_NOVW7:        equ    7                                         ; No Input Capture Overwrite 7
; bit position masks
mICOVW_NOVW0:       equ    %00000001
mICOVW_NOVW1:       equ    %00000010
mICOVW_NOVW2:       equ    %00000100
mICOVW_NOVW3:       equ    %00001000
mICOVW_NOVW4:       equ    %00010000
mICOVW_NOVW5:       equ    %00100000
mICOVW_NOVW6:       equ    %01000000
mICOVW_NOVW7:       equ    %10000000


;*** ICSYS - Input Control System Control Register; 0x0000006B ***
ICSYS:              equ    $0000006B                                ;*** ICSYS - Input Control System Control Register; 0x0000006B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSYS_LATQ:         equ    0                                         ; Input Control Latch or Queue Mode Enable
ICSYS_BUFEN:        equ    1                                         ; IC Buffer Enable
ICSYS_PACMX:        equ    2                                         ; 8-Bit Pulse Accumulators Maximum Count
ICSYS_TFMOD:        equ    3                                         ; Timer Flag-setting Mode
ICSYS_SH04:         equ    4                                         ; Share Input action of Input Capture Channels 0 and 4
ICSYS_SH15:         equ    5                                         ; Share Input action of Input Capture Channels 1 and 5
ICSYS_SH26:         equ    6                                         ; Share Input action of Input Capture Channels 2 and 6
ICSYS_SH37:         equ    7                                         ; Share Input action of Input Capture Channels 3 and 7
; bit position masks
mICSYS_LATQ:        equ    %00000001
mICSYS_BUFEN:       equ    %00000010
mICSYS_PACMX:       equ    %00000100
mICSYS_TFMOD:       equ    %00001000
mICSYS_SH04:        equ    %00010000
mICSYS_SH15:        equ    %00100000
mICSYS_SH26:        equ    %01000000
mICSYS_SH37:        equ    %10000000


;*** OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***
OCPD:               equ    $0000006C                                ;*** OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OCPD_OCPD0:         equ    0                                         ; Output Compare Pin Disconnect Bit 0
OCPD_OCPD1:         equ    1                                         ; Output Compare Pin Disconnect Bit 1
OCPD_OCPD2:         equ    2                                         ; Output Compare Pin Disconnect Bit 2
OCPD_OCPD3:         equ    3                                         ; Output Compare Pin Disconnect Bit 3
OCPD_OCPD4:         equ    4                                         ; Output Compare Pin Disconnect Bit 4
OCPD_OCPD5:         equ    5                                         ; Output Compare Pin Disconnect Bit 5
OCPD_OCPD6:         equ    6                                         ; Output Compare Pin Disconnect Bit 6
OCPD_OCPD7:         equ    7                                         ; Output Compare Pin Disconnect Bit 7
; bit position masks
mOCPD_OCPD0:        equ    %00000001
mOCPD_OCPD1:        equ    %00000010
mOCPD_OCPD2:        equ    %00000100
mOCPD_OCPD3:        equ    %00001000
mOCPD_OCPD4:        equ    %00010000
mOCPD_OCPD5:        equ    %00100000
mOCPD_OCPD6:        equ    %01000000
mOCPD_OCPD7:        equ    %10000000


;*** PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***
PTPSR:              equ    $0000006E                                ;*** PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTPSR_PTPS0:        equ    0                                         ; Precision Timer Prescaler Select, bit 0
PTPSR_PTPS1:        equ    1                                         ; Precision Timer Prescaler Select, bit 1
PTPSR_PTPS2:        equ    2                                         ; Precision Timer Prescaler Select, bit 2
PTPSR_PTPS3:        equ    3                                         ; Precision Timer Prescaler Select, bit 3
PTPSR_PTPS4:        equ    4                                         ; Precision Timer Prescaler Select, bit 4
PTPSR_PTPS5:        equ    5                                         ; Precision Timer Prescaler Select, bit 5
PTPSR_PTPS6:        equ    6                                         ; Precision Timer Prescaler Select, bit 6
PTPSR_PTPS7:        equ    7                                         ; Precision Timer Prescaler Select, bit 7
; bit position masks
mPTPSR_PTPS0:       equ    %00000001
mPTPSR_PTPS1:       equ    %00000010
mPTPSR_PTPS2:       equ    %00000100
mPTPSR_PTPS3:       equ    %00001000
mPTPSR_PTPS4:       equ    %00010000
mPTPSR_PTPS5:       equ    %00100000
mPTPSR_PTPS6:       equ    %01000000
mPTPSR_PTPS7:       equ    %10000000


;*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***
PTMCPSR:            equ    $0000006F                                ;*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTMCPSR_PTMPS0:     equ    0                                         ; Precision Timer Modulus Counter Prescaler Select, bit 0
PTMCPSR_PTMPS1:     equ    1                                         ; Precision Timer Modulus Counter Prescaler Select, bit 1
PTMCPSR_PTMPS2:     equ    2                                         ; Precision Timer Modulus Counter Prescaler Select, bit 2
PTMCPSR_PTMPS3:     equ    3                                         ; Precision Timer Modulus Counter Prescaler Select, bit 3
PTMCPSR_PTMPS4:     equ    4                                         ; Precision Timer Modulus Counter Prescaler Select, bit 4
PTMCPSR_PTMPS5:     equ    5                                         ; Precision Timer Modulus Counter Prescaler Select, bit 5
PTMCPSR_PTMPS6:     equ    6                                         ; Precision Timer Modulus Counter Prescaler Select, bit 6
PTMCPSR_PTMPS7:     equ    7                                         ; Precision Timer Modulus Counter Prescaler Select, bit 7
; bit position masks
mPTMCPSR_PTMPS0:    equ    %00000001
mPTMCPSR_PTMPS1:    equ    %00000010
mPTMCPSR_PTMPS2:    equ    %00000100
mPTMCPSR_PTMPS3:    equ    %00001000
mPTMCPSR_PTMPS4:    equ    %00010000
mPTMCPSR_PTMPS5:    equ    %00100000
mPTMCPSR_PTMPS6:    equ    %01000000
mPTMCPSR_PTMPS7:    equ    %10000000


;*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***
PBCTL:              equ    $00000070                                ;*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PBCTL_PBOVI:        equ    1                                         ; Pulse Accumulator B Overflow Interrupt enable
PBCTL_PBEN:         equ    6                                         ; Pulse Accumulator B System Enable
; bit position masks
mPBCTL_PBOVI:       equ    %00000010
mPBCTL_PBEN:        equ    %01000000


;*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***
PBFLG:              equ    $00000071                                ;*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PBFLG_PBOVF:        equ    1                                         ; Pulse Accumulator B Overflow Flag
; bit position masks
mPBFLG_PBOVF:       equ    %00000010


;*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***
PA32H:              equ    $00000072                                ;*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***


;*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***
PA3H:               equ    $00000072                                ;*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***


;*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***
PA2H:               equ    $00000073                                ;*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***


;*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***
PA10H:              equ    $00000074                                ;*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***


;*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***
PA1H:               equ    $00000074                                ;*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***


;*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***
PA0H:               equ    $00000075                                ;*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***


;*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***
MCCNT:              equ    $00000076                                ;*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***


;*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***
MCCNThi:            equ    $00000076                                ;*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***


;*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***
MCCNTlo:            equ    $00000077                                ;*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***


;*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***
TC0H:               equ    $00000078                                ;*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***


;*** TC0Hhi - Timer Input Capture Holding Registers High; 0x00000078 ***
TC0Hhi:             equ    $00000078                                ;*** TC0Hhi - Timer Input Capture Holding Registers High; 0x00000078 ***


;*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***
TC0Hlo:             equ    $00000079                                ;*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***


;*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***
TC1H:               equ    $0000007A                                ;*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***


;*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***
TC1Hhi:             equ    $0000007A                                ;*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***


;*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***
TC1Hlo:             equ    $0000007B                                ;*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***


;*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***
TC2H:               equ    $0000007C                                ;*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***


;*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***
TC2Hhi:             equ    $0000007C                                ;*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***


;*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***
TC2Hlo:             equ    $0000007D                                ;*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***


;*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***
TC3H:               equ    $0000007E                                ;*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***


;*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***
TC3Hhi:             equ    $0000007E                                ;*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***


;*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***
TC3Hlo:             equ    $0000007F                                ;*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***


;*** ATDCTL01 - ATD  Control Register 01; 0x00000080 ***
ATDCTL01:           equ    $00000080                                ;*** ATDCTL01 - ATD  Control Register 01; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL01_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL01_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL01_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL01_ETRIGCH3:  equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL01_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
ATDCTL01_WRAP0:     equ    8                                         ; Wrap Around Channel Select Bit 0
ATDCTL01_WRAP1:     equ    9                                         ; Wrap Around Channel Select Bit 1
ATDCTL01_WRAP2:     equ    10                                        ; Wrap Around Channel Select Bit 2
ATDCTL01_WRAP3:     equ    11                                        ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL01_ETRIGCH0: equ    %00000001
mATDCTL01_ETRIGCH1: equ    %00000010
mATDCTL01_ETRIGCH2: equ    %00000100
mATDCTL01_ETRIGCH3: equ    %00001000
mATDCTL01_ETRIGSEL: equ    %10000000
mATDCTL01_WRAP0:    equ    %100000000
mATDCTL01_WRAP1:    equ    %1000000000
mATDCTL01_WRAP2:    equ    %10000000000
mATDCTL01_WRAP3:    equ    %100000000000


;*** ATDCTL0 - ATD  Control Register 0; 0x00000080 ***
ATDCTL0:            equ    $00000080                                ;*** ATDCTL0 - ATD  Control Register 0; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL0_WRAP0:      equ    0                                         ; Wrap Around Channel Select Bit 0
ATDCTL0_WRAP1:      equ    1                                         ; Wrap Around Channel Select Bit 1
ATDCTL0_WRAP2:      equ    2                                         ; Wrap Around Channel Select Bit 2
ATDCTL0_WRAP3:      equ    3                                         ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL0_WRAP0:     equ    %00000001
mATDCTL0_WRAP1:     equ    %00000010
mATDCTL0_WRAP2:     equ    %00000100
mATDCTL0_WRAP3:     equ    %00001000


;*** ATDCTL1 - ATD  Control Register 1; 0x00000081 ***
ATDCTL1:            equ    $00000081                                ;*** ATDCTL1 - ATD  Control Register 1; 0x00000081 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL1_ETRIGCH0:   equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL1_ETRIGCH1:   equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL1_ETRIGCH2:   equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL1_ETRIGCH3:   equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL1_ETRIGSEL:   equ    7                                         ; External Trigger Source Select
; bit position masks
mATDCTL1_ETRIGCH0:  equ    %00000001
mATDCTL1_ETRIGCH1:  equ    %00000010
mATDCTL1_ETRIGCH2:  equ    %00000100
mATDCTL1_ETRIGCH3:  equ    %00001000
mATDCTL1_ETRIGSEL:  equ    %10000000


;*** ATDCTL23 - ATD  Control Register 23; 0x00000082 ***
ATDCTL23:           equ    $00000082                                ;*** ATDCTL23 - ATD  Control Register 23; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL23_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL23_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL23_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATDCTL23_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATDCTL23_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATDCTL23_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATDCTL23_S8C:       equ    6                                         ; Conversion Sequence Length 8
ATDCTL23_ASCIF:     equ    8                                         ; ATD  Sequence Complete Interrupt Flag
ATDCTL23_ASCIE:     equ    9                                         ; ATD  Sequence Complete Interrupt Enable
ATDCTL23_ETRIGE:    equ    10                                        ; External Trigger Mode enable
ATDCTL23_ETRIGP:    equ    11                                        ; External Trigger Polarity
ATDCTL23_ETRIGLE:   equ    12                                        ; External Trigger Level/Edge control
ATDCTL23_AWAI:      equ    13                                        ; ATD Power Down in Wait Mode
ATDCTL23_AFFC:      equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATDCTL23_ADPU:      equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATDCTL23_FRZ0:     equ    %00000001
mATDCTL23_FRZ1:     equ    %00000010
mATDCTL23_FIFO:     equ    %00000100
mATDCTL23_S1C:      equ    %00001000
mATDCTL23_S2C:      equ    %00010000
mATDCTL23_S4C:      equ    %00100000
mATDCTL23_S8C:      equ    %01000000
mATDCTL23_ASCIF:    equ    %100000000
mATDCTL23_ASCIE:    equ    %1000000000
mATDCTL23_ETRIGE:   equ    %10000000000
mATDCTL23_ETRIGP:   equ    %100000000000
mATDCTL23_ETRIGLE:  equ    %1000000000000
mATDCTL23_AWAI:     equ    %10000000000000
mATDCTL23_AFFC:     equ    %100000000000000
mATDCTL23_ADPU:     equ    %1000000000000000


;*** ATDCTL2 - ATD  Control Register 2; 0x00000082 ***
ATDCTL2:            equ    $00000082                                ;*** ATDCTL2 - ATD  Control Register 2; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL2_ASCIF:      equ    0                                         ; ATD  Sequence Complete Interrupt Flag
ATDCTL2_ASCIE:      equ    1                                         ; ATD  Sequence Complete Interrupt Enable
ATDCTL2_ETRIGE:     equ    2                                         ; External Trigger Mode enable
ATDCTL2_ETRIGP:     equ    3                                         ; External Trigger Polarity
ATDCTL2_ETRIGLE:    equ    4                                         ; External Trigger Level/Edge control
ATDCTL2_AWAI:       equ    5                                         ; ATD Power Down in Wait Mode
ATDCTL2_AFFC:       equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATDCTL2_ADPU:       equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATDCTL2_ASCIF:     equ    %00000001
mATDCTL2_ASCIE:     equ    %00000010
mATDCTL2_ETRIGE:    equ    %00000100
mATDCTL2_ETRIGP:    equ    %00001000
mATDCTL2_ETRIGLE:   equ    %00010000
mATDCTL2_AWAI:      equ    %00100000
mATDCTL2_AFFC:      equ    %01000000
mATDCTL2_ADPU:      equ    %10000000


;*** ATDCTL3 - ATD  Control Register 3; 0x00000083 ***
ATDCTL3:            equ    $00000083                                ;*** ATDCTL3 - ATD  Control Register 3; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL3_FRZ0:       equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL3_FRZ1:       equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL3_FIFO:       equ    2                                         ; Result Register FIFO Mode
ATDCTL3_S1C:        equ    3                                         ; Conversion Sequence Length 1
ATDCTL3_S2C:        equ    4                                         ; Conversion Sequence Length 2
ATDCTL3_S4C:        equ    5                                         ; Conversion Sequence Length 4
ATDCTL3_S8C:        equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATDCTL3_FRZ0:      equ    %00000001
mATDCTL3_FRZ1:      equ    %00000010
mATDCTL3_FIFO:      equ    %00000100
mATDCTL3_S1C:       equ    %00001000
mATDCTL3_S2C:       equ    %00010000
mATDCTL3_S4C:       equ    %00100000
mATDCTL3_S8C:       equ    %01000000


;*** ATDCTL45 - ATD  Control Register 45; 0x00000084 ***
ATDCTL45:           equ    $00000084                                ;*** ATDCTL45 - ATD  Control Register 45; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL45_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATDCTL45_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATDCTL45_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATDCTL45_CD:        equ    3                                         ; Analog Input Channel Select Code D
ATDCTL45_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATDCTL45_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL45_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL45_DJM:       equ    7                                         ; Result Register Data Justification Mode
ATDCTL45_PRS0:      equ    8                                         ; ATD Clock Prescaler 0
ATDCTL45_PRS1:      equ    9                                         ; ATD Clock Prescaler 1
ATDCTL45_PRS2:      equ    10                                        ; ATD Clock Prescaler 2
ATDCTL45_PRS3:      equ    11                                        ; ATD Clock Prescaler 3
ATDCTL45_PRS4:      equ    12                                        ; ATD Clock Prescaler 4
ATDCTL45_SMP0:      equ    13                                        ; Sample Time Select 0
ATDCTL45_SMP1:      equ    14                                        ; Sample Time Select 1
ATDCTL45_SRES8:     equ    15                                        ; ATD Resolution Select
; bit position masks
mATDCTL45_CA:       equ    %00000001
mATDCTL45_CB:       equ    %00000010
mATDCTL45_CC:       equ    %00000100
mATDCTL45_CD:       equ    %00001000
mATDCTL45_MULT:     equ    %00010000
mATDCTL45_SCAN:     equ    %00100000
mATDCTL45_DSGN:     equ    %01000000
mATDCTL45_DJM:      equ    %10000000
mATDCTL45_PRS0:     equ    %100000000
mATDCTL45_PRS1:     equ    %1000000000
mATDCTL45_PRS2:     equ    %10000000000
mATDCTL45_PRS3:     equ    %100000000000
mATDCTL45_PRS4:     equ    %1000000000000
mATDCTL45_SMP0:     equ    %10000000000000
mATDCTL45_SMP1:     equ    %100000000000000
mATDCTL45_SRES8:    equ    %1000000000000000


;*** ATDCTL4 - ATD  Control Register 4; 0x00000084 ***
ATDCTL4:            equ    $00000084                                ;*** ATDCTL4 - ATD  Control Register 4; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL4_PRS0:       equ    0                                         ; ATD Clock Prescaler 0
ATDCTL4_PRS1:       equ    1                                         ; ATD Clock Prescaler 1
ATDCTL4_PRS2:       equ    2                                         ; ATD Clock Prescaler 2
ATDCTL4_PRS3:       equ    3                                         ; ATD Clock Prescaler 3
ATDCTL4_PRS4:       equ    4                                         ; ATD Clock Prescaler 4
ATDCTL4_SMP0:       equ    5                                         ; Sample Time Select 0
ATDCTL4_SMP1:       equ    6                                         ; Sample Time Select 1
ATDCTL4_SRES8:      equ    7                                         ; ATD Resolution Select
; bit position masks
mATDCTL4_PRS0:      equ    %00000001
mATDCTL4_PRS1:      equ    %00000010
mATDCTL4_PRS2:      equ    %00000100
mATDCTL4_PRS3:      equ    %00001000
mATDCTL4_PRS4:      equ    %00010000
mATDCTL4_SMP0:      equ    %00100000
mATDCTL4_SMP1:      equ    %01000000
mATDCTL4_SRES8:     equ    %10000000


;*** ATDCTL5 - ATD  Control Register 5; 0x00000085 ***
ATDCTL5:            equ    $00000085                                ;*** ATDCTL5 - ATD  Control Register 5; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL5_CA:         equ    0                                         ; Analog Input Channel Select Code A
ATDCTL5_CB:         equ    1                                         ; Analog Input Channel Select Code B
ATDCTL5_CC:         equ    2                                         ; Analog Input Channel Select Code C
ATDCTL5_CD:         equ    3                                         ; Analog Input Channel Select Code D
ATDCTL5_MULT:       equ    4                                         ; Multi-Channel Sample Mode
ATDCTL5_SCAN:       equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL5_DSGN:       equ    6                                         ; Signed/Unsigned Result Data Mode
ATDCTL5_DJM:        equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATDCTL5_CA:        equ    %00000001
mATDCTL5_CB:        equ    %00000010
mATDCTL5_CC:        equ    %00000100
mATDCTL5_CD:        equ    %00001000
mATDCTL5_MULT:      equ    %00010000
mATDCTL5_SCAN:      equ    %00100000
mATDCTL5_DSGN:      equ    %01000000
mATDCTL5_DJM:       equ    %10000000


;*** ATDSTAT0 - ATD  Status Register 0; 0x00000086 ***
ATDSTAT0:           equ    $00000086                                ;*** ATDSTAT0 - ATD  Status Register 0; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT0_CC0:       equ    0                                         ; Conversion Counter 0
ATDSTAT0_CC1:       equ    1                                         ; Conversion Counter 1
ATDSTAT0_CC2:       equ    2                                         ; Conversion Counter 2
ATDSTAT0_CC3:       equ    3                                         ; Conversion Counter 3
ATDSTAT0_FIFOR:     equ    4                                         ; FIFO Over Run Flag
ATDSTAT0_ETORF:     equ    5                                         ; External Trigger Overrun Flag
ATDSTAT0_SCF:       equ    7                                         ; Sequence Complete Flag
; bit position masks
mATDSTAT0_CC0:      equ    %00000001
mATDSTAT0_CC1:      equ    %00000010
mATDSTAT0_CC2:      equ    %00000100
mATDSTAT0_CC3:      equ    %00001000
mATDSTAT0_FIFOR:    equ    %00010000
mATDSTAT0_ETORF:    equ    %00100000
mATDSTAT0_SCF:      equ    %10000000


;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
ATDTEST1:           equ    $00000089                                ;*** ATDTEST1 - ATD Test Register; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDTEST1_SC:        equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATDTEST1_SC:       equ    %00000001


;*** ATDSTAT2 - ATD  Status Register 2; 0x0000008A ***
ATDSTAT2:           equ    $0000008A                                ;*** ATDSTAT2 - ATD  Status Register 2; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2_CCF8:      equ    0                                         ; Conversion Complete Flag 8
ATDSTAT2_CCF9:      equ    1                                         ; Conversion Complete Flag 9
ATDSTAT2_CCF10:     equ    2                                         ; Conversion Complete Flag 10
ATDSTAT2_CCF11:     equ    3                                         ; Conversion Complete Flag 11
ATDSTAT2_CCF12:     equ    4                                         ; Conversion Complete Flag 12
ATDSTAT2_CCF13:     equ    5                                         ; Conversion Complete Flag 13
ATDSTAT2_CCF14:     equ    6                                         ; Conversion Complete Flag 14
ATDSTAT2_CCF15:     equ    7                                         ; Conversion Complete Flag 15
; bit position masks
mATDSTAT2_CCF8:     equ    %00000001
mATDSTAT2_CCF9:     equ    %00000010
mATDSTAT2_CCF10:    equ    %00000100
mATDSTAT2_CCF11:    equ    %00001000
mATDSTAT2_CCF12:    equ    %00010000
mATDSTAT2_CCF13:    equ    %00100000
mATDSTAT2_CCF14:    equ    %01000000
mATDSTAT2_CCF15:    equ    %10000000


;*** ATDSTAT1 - ATD  Status Register 1; 0x0000008B ***
ATDSTAT1:           equ    $0000008B                                ;*** ATDSTAT1 - ATD  Status Register 1; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT1_CCF0:      equ    0                                         ; Conversion Complete Flag 0
ATDSTAT1_CCF1:      equ    1                                         ; Conversion Complete Flag 1
ATDSTAT1_CCF2:      equ    2                                         ; Conversion Complete Flag 2
ATDSTAT1_CCF3:      equ    3                                         ; Conversion Complete Flag 3
ATDSTAT1_CCF4:      equ    4                                         ; Conversion Complete Flag 4
ATDSTAT1_CCF5:      equ    5                                         ; Conversion Complete Flag 5
ATDSTAT1_CCF6:      equ    6                                         ; Conversion Complete Flag 6
ATDSTAT1_CCF7:      equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT1_CCF0:     equ    %00000001
mATDSTAT1_CCF1:     equ    %00000010
mATDSTAT1_CCF2:     equ    %00000100
mATDSTAT1_CCF3:     equ    %00001000
mATDSTAT1_CCF4:     equ    %00010000
mATDSTAT1_CCF5:     equ    %00100000
mATDSTAT1_CCF6:     equ    %01000000
mATDSTAT1_CCF7:     equ    %10000000


;*** ATDDIEN - ATD  Input Enable Register; 0x0000008C ***
ATDDIEN:            equ    $0000008C                                ;*** ATDDIEN - ATD  Input Enable Register; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN_IEN0:       equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN_IEN1:       equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN_IEN2:       equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN_IEN3:       equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN_IEN4:       equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN_IEN5:       equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN_IEN6:       equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN_IEN7:       equ    7                                         ; ATD Digital Input Enable on channel 7
ATDDIEN_IEN8:       equ    8                                         ; ATD Digital Input Enable on channel 8
ATDDIEN_IEN9:       equ    9                                         ; ATD Digital Input Enable on channel 9
ATDDIEN_IEN10:      equ    10                                        ; ATD Digital Input Enable on channel 10
ATDDIEN_IEN11:      equ    11                                        ; ATD Digital Input Enable on channel 11
ATDDIEN_IEN12:      equ    12                                        ; ATD Digital Input Enable on channel 12
ATDDIEN_IEN13:      equ    13                                        ; ATD Digital Input Enable on channel 13
ATDDIEN_IEN14:      equ    14                                        ; ATD Digital Input Enable on channel 14
ATDDIEN_IEN15:      equ    15                                        ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIEN_IEN0:      equ    %00000001
mATDDIEN_IEN1:      equ    %00000010
mATDDIEN_IEN2:      equ    %00000100
mATDDIEN_IEN3:      equ    %00001000
mATDDIEN_IEN4:      equ    %00010000
mATDDIEN_IEN5:      equ    %00100000
mATDDIEN_IEN6:      equ    %01000000
mATDDIEN_IEN7:      equ    %10000000
mATDDIEN_IEN8:      equ    %100000000
mATDDIEN_IEN9:      equ    %1000000000
mATDDIEN_IEN10:     equ    %10000000000
mATDDIEN_IEN11:     equ    %100000000000
mATDDIEN_IEN12:     equ    %1000000000000
mATDDIEN_IEN13:     equ    %10000000000000
mATDDIEN_IEN14:     equ    %100000000000000
mATDDIEN_IEN15:     equ    %1000000000000000


;*** ATDDIEN0 - ATD  Input Enable Register 0; 0x0000008C ***
ATDDIEN0:           equ    $0000008C                                ;*** ATDDIEN0 - ATD  Input Enable Register 0; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN0_IEN8:      equ    0                                         ; ATD Digital Input Enable on channel 8
ATDDIEN0_IEN9:      equ    1                                         ; ATD Digital Input Enable on channel 9
ATDDIEN0_IEN10:     equ    2                                         ; ATD Digital Input Enable on channel 10
ATDDIEN0_IEN11:     equ    3                                         ; ATD Digital Input Enable on channel 11
ATDDIEN0_IEN12:     equ    4                                         ; ATD Digital Input Enable on channel 12
ATDDIEN0_IEN13:     equ    5                                         ; ATD Digital Input Enable on channel 13
ATDDIEN0_IEN14:     equ    6                                         ; ATD Digital Input Enable on channel 14
ATDDIEN0_IEN15:     equ    7                                         ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIEN0_IEN8:     equ    %00000001
mATDDIEN0_IEN9:     equ    %00000010
mATDDIEN0_IEN10:    equ    %00000100
mATDDIEN0_IEN11:    equ    %00001000
mATDDIEN0_IEN12:    equ    %00010000
mATDDIEN0_IEN13:    equ    %00100000
mATDDIEN0_IEN14:    equ    %01000000
mATDDIEN0_IEN15:    equ    %10000000


;*** ATDDIEN1 - ATD  Input Enable Register 1; 0x0000008D ***
ATDDIEN1:           equ    $0000008D                                ;*** ATDDIEN1 - ATD  Input Enable Register 1; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN1_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN1_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN1_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN1_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN1_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN1_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN1_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN1_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIEN1_IEN0:     equ    %00000001
mATDDIEN1_IEN1:     equ    %00000010
mATDDIEN1_IEN2:     equ    %00000100
mATDDIEN1_IEN3:     equ    %00001000
mATDDIEN1_IEN4:     equ    %00010000
mATDDIEN1_IEN5:     equ    %00100000
mATDDIEN1_IEN6:     equ    %01000000
mATDDIEN1_IEN7:     equ    %10000000


;*** ATDPTAD - ATD  Port AD Register; 0x0000008E ***
ATDPTAD:            equ    $0000008E                                ;*** ATDPTAD - ATD  Port AD Register; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDPTAD_PTAD0:      equ    0                                         ; A/D Channel 0 (AN0) Digital Input
ATDPTAD_PTAD1:      equ    1                                         ; A/D Channel 1 (AN1) Digital Input
ATDPTAD_PTAD2:      equ    2                                         ; A/D Channel 2 (AN2) Digital Input
ATDPTAD_PTAD3:      equ    3                                         ; A/D Channel 3 (AN3) Digital Input
ATDPTAD_PTAD4:      equ    4                                         ; A/D Channel 4 (AN4) Digital Input
ATDPTAD_PTAD5:      equ    5                                         ; A/D Channel 5 (AN5) Digital Input
ATDPTAD_PTAD6:      equ    6                                         ; A/D Channel 6 (AN6) Digital Input
ATDPTAD_PTAD7:      equ    7                                         ; A/D Channel 7 (AN7) Digital Input
ATDPTAD_PTAD8:      equ    8                                         ; A/D Channel 8 (AN8) Digital Input
ATDPTAD_PTAD9:      equ    9                                         ; A/D Channel 9 (AN9) Digital Input
ATDPTAD_PTAD10:     equ    10                                        ; A/D Channel 10 (AN10) Digital Input
ATDPTAD_PTAD11:     equ    11                                        ; A/D Channel 11 (AN11) Digital Input
ATDPTAD_PTAD12:     equ    12                                        ; A/D Channel 12 (AN12) Digital Input
ATDPTAD_PTAD13:     equ    13                                        ; A/D Channel 13 (AN13) Digital Input
ATDPTAD_PTAD14:     equ    14                                        ; A/D Channel 14 (AN14) Digital Input
ATDPTAD_PTAD15:     equ    15                                        ; A/D Channel 15 (AN15) Digital Input
; bit position masks
mATDPTAD_PTAD0:     equ    %00000001
mATDPTAD_PTAD1:     equ    %00000010
mATDPTAD_PTAD2:     equ    %00000100
mATDPTAD_PTAD3:     equ    %00001000
mATDPTAD_PTAD4:     equ    %00010000
mATDPTAD_PTAD5:     equ    %00100000
mATDPTAD_PTAD6:     equ    %01000000
mATDPTAD_PTAD7:     equ    %10000000
mATDPTAD_PTAD8:     equ    %100000000
mATDPTAD_PTAD9:     equ    %1000000000
mATDPTAD_PTAD10:    equ    %10000000000
mATDPTAD_PTAD11:    equ    %100000000000
mATDPTAD_PTAD12:    equ    %1000000000000
mATDPTAD_PTAD13:    equ    %10000000000000
mATDPTAD_PTAD14:    equ    %100000000000000
mATDPTAD_PTAD15:    equ    %1000000000000000


;*** ATDPTAD0 - ATD  Port AD0 Register; 0x0000008E ***
ATDPTAD0:           equ    $0000008E                                ;*** ATDPTAD0 - ATD  Port AD0 Register; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDPTAD0_PTAD8:     equ    0                                         ; A/D Channel 8 (AN8) Digital Input
ATDPTAD0_PTAD9:     equ    1                                         ; A/D Channel 9 (AN9) Digital Input
ATDPTAD0_PTAD10:    equ    2                                         ; A/D Channel 10 (AN10) Digital Input
ATDPTAD0_PTAD11:    equ    3                                         ; A/D Channel 11 (AN11) Digital Input
ATDPTAD0_PTAD12:    equ    4                                         ; A/D Channel 12 (AN12) Digital Input
ATDPTAD0_PTAD13:    equ    5                                         ; A/D Channel 13 (AN13) Digital Input
ATDPTAD0_PTAD14:    equ    6                                         ; A/D Channel 14 (AN14) Digital Input
ATDPTAD0_PTAD15:    equ    7                                         ; A/D Channel 15 (AN15) Digital Input
; bit position masks
mATDPTAD0_PTAD8:    equ    %00000001
mATDPTAD0_PTAD9:    equ    %00000010
mATDPTAD0_PTAD10:   equ    %00000100
mATDPTAD0_PTAD11:   equ    %00001000
mATDPTAD0_PTAD12:   equ    %00010000
mATDPTAD0_PTAD13:   equ    %00100000
mATDPTAD0_PTAD14:   equ    %01000000
mATDPTAD0_PTAD15:   equ    %10000000


;*** ATDPTAD1 - ATD  Port AD1 Register; 0x0000008F ***
ATDPTAD1:           equ    $0000008F                                ;*** ATDPTAD1 - ATD  Port AD1 Register; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDPTAD1_PTAD0:     equ    0                                         ; A/D Channel 0 (AN0) Digital Input
ATDPTAD1_PTAD1:     equ    1                                         ; A/D Channel 1 (AN1) Digital Input
ATDPTAD1_PTAD2:     equ    2                                         ; A/D Channel 2 (AN2) Digital Input
ATDPTAD1_PTAD3:     equ    3                                         ; A/D Channel 3 (AN3) Digital Input
ATDPTAD1_PTAD4:     equ    4                                         ; A/D Channel 4 (AN4) Digital Input
ATDPTAD1_PTAD5:     equ    5                                         ; A/D Channel 5 (AN5) Digital Input
ATDPTAD1_PTAD6:     equ    6                                         ; A/D Channel 6 (AN6) Digital Input
ATDPTAD1_PTAD7:     equ    7                                         ; A/D Channel 7 (AN7) Digital Input
; bit position masks
mATDPTAD1_PTAD0:    equ    %00000001
mATDPTAD1_PTAD1:    equ    %00000010
mATDPTAD1_PTAD2:    equ    %00000100
mATDPTAD1_PTAD3:    equ    %00001000
mATDPTAD1_PTAD4:    equ    %00010000
mATDPTAD1_PTAD5:    equ    %00100000
mATDPTAD1_PTAD6:    equ    %01000000
mATDPTAD1_PTAD7:    equ    %10000000


;*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000090 ***
ATDDR0:             equ    $00000090                                ;*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0_BIT6:        equ    6                                         ; Bit 6
ATDDR0_BIT7:        equ    7                                         ; Bit 7
ATDDR0_BIT8:        equ    8                                         ; Bit 8
ATDDR0_BIT9:        equ    9                                         ; Bit 9
ATDDR0_BIT10:       equ    10                                        ; Bit 10
ATDDR0_BIT11:       equ    11                                        ; Bit 11
ATDDR0_BIT12:       equ    12                                        ; Bit 12
ATDDR0_BIT13:       equ    13                                        ; Bit 13
ATDDR0_BIT14:       equ    14                                        ; Bit 14
ATDDR0_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR0_BIT6:       equ    %01000000
mATDDR0_BIT7:       equ    %10000000
mATDDR0_BIT8:       equ    %100000000
mATDDR0_BIT9:       equ    %1000000000
mATDDR0_BIT10:      equ    %10000000000
mATDDR0_BIT11:      equ    %100000000000
mATDDR0_BIT12:      equ    %1000000000000
mATDDR0_BIT13:      equ    %10000000000000
mATDDR0_BIT14:      equ    %100000000000000
mATDDR0_BIT15:      equ    %1000000000000000


;*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000090 ***
ATDDR0H:            equ    $00000090                                ;*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0H_BIT8:       equ    0                                         ; Bit 8
ATDDR0H_BIT9:       equ    1                                         ; Bit 9
ATDDR0H_BIT10:      equ    2                                         ; Bit 10
ATDDR0H_BIT11:      equ    3                                         ; Bit 11
ATDDR0H_BIT12:      equ    4                                         ; Bit 12
ATDDR0H_BIT13:      equ    5                                         ; Bit 13
ATDDR0H_BIT14:      equ    6                                         ; Bit 14
ATDDR0H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR0H_BIT8:      equ    %00000001
mATDDR0H_BIT9:      equ    %00000010
mATDDR0H_BIT10:     equ    %00000100
mATDDR0H_BIT11:     equ    %00001000
mATDDR0H_BIT12:     equ    %00010000
mATDDR0H_BIT13:     equ    %00100000
mATDDR0H_BIT14:     equ    %01000000
mATDDR0H_BIT15:     equ    %10000000


;*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000091 ***
ATDDR0L:            equ    $00000091                                ;*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0L_BIT6:       equ    6                                         ; Bit 6
ATDDR0L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR0L_BIT6:      equ    %01000000
mATDDR0L_BIT7:      equ    %10000000


;*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000092 ***
ATDDR1:             equ    $00000092                                ;*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1_BIT6:        equ    6                                         ; Bit 6
ATDDR1_BIT7:        equ    7                                         ; Bit 7
ATDDR1_BIT8:        equ    8                                         ; Bit 8
ATDDR1_BIT9:        equ    9                                         ; Bit 9
ATDDR1_BIT10:       equ    10                                        ; Bit 10
ATDDR1_BIT11:       equ    11                                        ; Bit 11
ATDDR1_BIT12:       equ    12                                        ; Bit 12
ATDDR1_BIT13:       equ    13                                        ; Bit 13
ATDDR1_BIT14:       equ    14                                        ; Bit 14
ATDDR1_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR1_BIT6:       equ    %01000000
mATDDR1_BIT7:       equ    %10000000
mATDDR1_BIT8:       equ    %100000000
mATDDR1_BIT9:       equ    %1000000000
mATDDR1_BIT10:      equ    %10000000000
mATDDR1_BIT11:      equ    %100000000000
mATDDR1_BIT12:      equ    %1000000000000
mATDDR1_BIT13:      equ    %10000000000000
mATDDR1_BIT14:      equ    %100000000000000
mATDDR1_BIT15:      equ    %1000000000000000


;*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000092 ***
ATDDR1H:            equ    $00000092                                ;*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1H_BIT8:       equ    0                                         ; Bit 8
ATDDR1H_BIT9:       equ    1                                         ; Bit 9
ATDDR1H_BIT10:      equ    2                                         ; Bit 10
ATDDR1H_BIT11:      equ    3                                         ; Bit 11
ATDDR1H_BIT12:      equ    4                                         ; Bit 12
ATDDR1H_BIT13:      equ    5                                         ; Bit 13
ATDDR1H_BIT14:      equ    6                                         ; Bit 14
ATDDR1H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR1H_BIT8:      equ    %00000001
mATDDR1H_BIT9:      equ    %00000010
mATDDR1H_BIT10:     equ    %00000100
mATDDR1H_BIT11:     equ    %00001000
mATDDR1H_BIT12:     equ    %00010000
mATDDR1H_BIT13:     equ    %00100000
mATDDR1H_BIT14:     equ    %01000000
mATDDR1H_BIT15:     equ    %10000000


;*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000093 ***
ATDDR1L:            equ    $00000093                                ;*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1L_BIT6:       equ    6                                         ; Bit 6
ATDDR1L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR1L_BIT6:      equ    %01000000
mATDDR1L_BIT7:      equ    %10000000


;*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000094 ***
ATDDR2:             equ    $00000094                                ;*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2_BIT6:        equ    6                                         ; Bit 6
ATDDR2_BIT7:        equ    7                                         ; Bit 7
ATDDR2_BIT8:        equ    8                                         ; Bit 8
ATDDR2_BIT9:        equ    9                                         ; Bit 9
ATDDR2_BIT10:       equ    10                                        ; Bit 10
ATDDR2_BIT11:       equ    11                                        ; Bit 11
ATDDR2_BIT12:       equ    12                                        ; Bit 12
ATDDR2_BIT13:       equ    13                                        ; Bit 13
ATDDR2_BIT14:       equ    14                                        ; Bit 14
ATDDR2_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR2_BIT6:       equ    %01000000
mATDDR2_BIT7:       equ    %10000000
mATDDR2_BIT8:       equ    %100000000
mATDDR2_BIT9:       equ    %1000000000
mATDDR2_BIT10:      equ    %10000000000
mATDDR2_BIT11:      equ    %100000000000
mATDDR2_BIT12:      equ    %1000000000000
mATDDR2_BIT13:      equ    %10000000000000
mATDDR2_BIT14:      equ    %100000000000000
mATDDR2_BIT15:      equ    %1000000000000000


;*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000094 ***
ATDDR2H:            equ    $00000094                                ;*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2H_BIT8:       equ    0                                         ; Bit 8
ATDDR2H_BIT9:       equ    1                                         ; Bit 9
ATDDR2H_BIT10:      equ    2                                         ; Bit 10
ATDDR2H_BIT11:      equ    3                                         ; Bit 11
ATDDR2H_BIT12:      equ    4                                         ; Bit 12
ATDDR2H_BIT13:      equ    5                                         ; Bit 13
ATDDR2H_BIT14:      equ    6                                         ; Bit 14
ATDDR2H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR2H_BIT8:      equ    %00000001
mATDDR2H_BIT9:      equ    %00000010
mATDDR2H_BIT10:     equ    %00000100
mATDDR2H_BIT11:     equ    %00001000
mATDDR2H_BIT12:     equ    %00010000
mATDDR2H_BIT13:     equ    %00100000
mATDDR2H_BIT14:     equ    %01000000
mATDDR2H_BIT15:     equ    %10000000


;*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000095 ***
ATDDR2L:            equ    $00000095                                ;*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2L_BIT6:       equ    6                                         ; Bit 6
ATDDR2L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR2L_BIT6:      equ    %01000000
mATDDR2L_BIT7:      equ    %10000000


;*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000096 ***
ATDDR3:             equ    $00000096                                ;*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3_BIT6:        equ    6                                         ; Bit 6
ATDDR3_BIT7:        equ    7                                         ; Bit 7
ATDDR3_BIT8:        equ    8                                         ; Bit 8
ATDDR3_BIT9:        equ    9                                         ; Bit 9
ATDDR3_BIT10:       equ    10                                        ; Bit 10
ATDDR3_BIT11:       equ    11                                        ; Bit 11
ATDDR3_BIT12:       equ    12                                        ; Bit 12
ATDDR3_BIT13:       equ    13                                        ; Bit 13
ATDDR3_BIT14:       equ    14                                        ; Bit 14
ATDDR3_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR3_BIT6:       equ    %01000000
mATDDR3_BIT7:       equ    %10000000
mATDDR3_BIT8:       equ    %100000000
mATDDR3_BIT9:       equ    %1000000000
mATDDR3_BIT10:      equ    %10000000000
mATDDR3_BIT11:      equ    %100000000000
mATDDR3_BIT12:      equ    %1000000000000
mATDDR3_BIT13:      equ    %10000000000000
mATDDR3_BIT14:      equ    %100000000000000
mATDDR3_BIT15:      equ    %1000000000000000


;*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000096 ***
ATDDR3H:            equ    $00000096                                ;*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3H_BIT8:       equ    0                                         ; Bit 8
ATDDR3H_BIT9:       equ    1                                         ; Bit 9
ATDDR3H_BIT10:      equ    2                                         ; Bit 10
ATDDR3H_BIT11:      equ    3                                         ; Bit 11
ATDDR3H_BIT12:      equ    4                                         ; Bit 12
ATDDR3H_BIT13:      equ    5                                         ; Bit 13
ATDDR3H_BIT14:      equ    6                                         ; Bit 14
ATDDR3H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR3H_BIT8:      equ    %00000001
mATDDR3H_BIT9:      equ    %00000010
mATDDR3H_BIT10:     equ    %00000100
mATDDR3H_BIT11:     equ    %00001000
mATDDR3H_BIT12:     equ    %00010000
mATDDR3H_BIT13:     equ    %00100000
mATDDR3H_BIT14:     equ    %01000000
mATDDR3H_BIT15:     equ    %10000000


;*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000097 ***
ATDDR3L:            equ    $00000097                                ;*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3L_BIT6:       equ    6                                         ; Bit 6
ATDDR3L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR3L_BIT6:      equ    %01000000
mATDDR3L_BIT7:      equ    %10000000


;*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000098 ***
ATDDR4:             equ    $00000098                                ;*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4_BIT6:        equ    6                                         ; Bit 6
ATDDR4_BIT7:        equ    7                                         ; Bit 7
ATDDR4_BIT8:        equ    8                                         ; Bit 8
ATDDR4_BIT9:        equ    9                                         ; Bit 9
ATDDR4_BIT10:       equ    10                                        ; Bit 10
ATDDR4_BIT11:       equ    11                                        ; Bit 11
ATDDR4_BIT12:       equ    12                                        ; Bit 12
ATDDR4_BIT13:       equ    13                                        ; Bit 13
ATDDR4_BIT14:       equ    14                                        ; Bit 14
ATDDR4_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR4_BIT6:       equ    %01000000
mATDDR4_BIT7:       equ    %10000000
mATDDR4_BIT8:       equ    %100000000
mATDDR4_BIT9:       equ    %1000000000
mATDDR4_BIT10:      equ    %10000000000
mATDDR4_BIT11:      equ    %100000000000
mATDDR4_BIT12:      equ    %1000000000000
mATDDR4_BIT13:      equ    %10000000000000
mATDDR4_BIT14:      equ    %100000000000000
mATDDR4_BIT15:      equ    %1000000000000000


;*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000098 ***
ATDDR4H:            equ    $00000098                                ;*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4H_BIT8:       equ    0                                         ; Bit 8
ATDDR4H_BIT9:       equ    1                                         ; Bit 9
ATDDR4H_BIT10:      equ    2                                         ; Bit 10
ATDDR4H_BIT11:      equ    3                                         ; Bit 11
ATDDR4H_BIT12:      equ    4                                         ; Bit 12
ATDDR4H_BIT13:      equ    5                                         ; Bit 13
ATDDR4H_BIT14:      equ    6                                         ; Bit 14
ATDDR4H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR4H_BIT8:      equ    %00000001
mATDDR4H_BIT9:      equ    %00000010
mATDDR4H_BIT10:     equ    %00000100
mATDDR4H_BIT11:     equ    %00001000
mATDDR4H_BIT12:     equ    %00010000
mATDDR4H_BIT13:     equ    %00100000
mATDDR4H_BIT14:     equ    %01000000
mATDDR4H_BIT15:     equ    %10000000


;*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000099 ***
ATDDR4L:            equ    $00000099                                ;*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4L_BIT6:       equ    6                                         ; Bit 6
ATDDR4L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR4L_BIT6:      equ    %01000000
mATDDR4L_BIT7:      equ    %10000000


;*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000009A ***
ATDDR5:             equ    $0000009A                                ;*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5_BIT6:        equ    6                                         ; Bit 6
ATDDR5_BIT7:        equ    7                                         ; Bit 7
ATDDR5_BIT8:        equ    8                                         ; Bit 8
ATDDR5_BIT9:        equ    9                                         ; Bit 9
ATDDR5_BIT10:       equ    10                                        ; Bit 10
ATDDR5_BIT11:       equ    11                                        ; Bit 11
ATDDR5_BIT12:       equ    12                                        ; Bit 12
ATDDR5_BIT13:       equ    13                                        ; Bit 13
ATDDR5_BIT14:       equ    14                                        ; Bit 14
ATDDR5_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR5_BIT6:       equ    %01000000
mATDDR5_BIT7:       equ    %10000000
mATDDR5_BIT8:       equ    %100000000
mATDDR5_BIT9:       equ    %1000000000
mATDDR5_BIT10:      equ    %10000000000
mATDDR5_BIT11:      equ    %100000000000
mATDDR5_BIT12:      equ    %1000000000000
mATDDR5_BIT13:      equ    %10000000000000
mATDDR5_BIT14:      equ    %100000000000000
mATDDR5_BIT15:      equ    %1000000000000000


;*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000009A ***
ATDDR5H:            equ    $0000009A                                ;*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5H_BIT8:       equ    0                                         ; Bit 8
ATDDR5H_BIT9:       equ    1                                         ; Bit 9
ATDDR5H_BIT10:      equ    2                                         ; Bit 10
ATDDR5H_BIT11:      equ    3                                         ; Bit 11
ATDDR5H_BIT12:      equ    4                                         ; Bit 12
ATDDR5H_BIT13:      equ    5                                         ; Bit 13
ATDDR5H_BIT14:      equ    6                                         ; Bit 14
ATDDR5H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR5H_BIT8:      equ    %00000001
mATDDR5H_BIT9:      equ    %00000010
mATDDR5H_BIT10:     equ    %00000100
mATDDR5H_BIT11:     equ    %00001000
mATDDR5H_BIT12:     equ    %00010000
mATDDR5H_BIT13:     equ    %00100000
mATDDR5H_BIT14:     equ    %01000000
mATDDR5H_BIT15:     equ    %10000000


;*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000009B ***
ATDDR5L:            equ    $0000009B                                ;*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5L_BIT6:       equ    6                                         ; Bit 6
ATDDR5L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR5L_BIT6:      equ    %01000000
mATDDR5L_BIT7:      equ    %10000000


;*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000009C ***
ATDDR6:             equ    $0000009C                                ;*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6_BIT6:        equ    6                                         ; Bit 6
ATDDR6_BIT7:        equ    7                                         ; Bit 7
ATDDR6_BIT8:        equ    8                                         ; Bit 8
ATDDR6_BIT9:        equ    9                                         ; Bit 9
ATDDR6_BIT10:       equ    10                                        ; Bit 10
ATDDR6_BIT11:       equ    11                                        ; Bit 11
ATDDR6_BIT12:       equ    12                                        ; Bit 12
ATDDR6_BIT13:       equ    13                                        ; Bit 13
ATDDR6_BIT14:       equ    14                                        ; Bit 14
ATDDR6_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR6_BIT6:       equ    %01000000
mATDDR6_BIT7:       equ    %10000000
mATDDR6_BIT8:       equ    %100000000
mATDDR6_BIT9:       equ    %1000000000
mATDDR6_BIT10:      equ    %10000000000
mATDDR6_BIT11:      equ    %100000000000
mATDDR6_BIT12:      equ    %1000000000000
mATDDR6_BIT13:      equ    %10000000000000
mATDDR6_BIT14:      equ    %100000000000000
mATDDR6_BIT15:      equ    %1000000000000000


;*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000009C ***
ATDDR6H:            equ    $0000009C                                ;*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6H_BIT8:       equ    0                                         ; Bit 8
ATDDR6H_BIT9:       equ    1                                         ; Bit 9
ATDDR6H_BIT10:      equ    2                                         ; Bit 10
ATDDR6H_BIT11:      equ    3                                         ; Bit 11
ATDDR6H_BIT12:      equ    4                                         ; Bit 12
ATDDR6H_BIT13:      equ    5                                         ; Bit 13
ATDDR6H_BIT14:      equ    6                                         ; Bit 14
ATDDR6H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR6H_BIT8:      equ    %00000001
mATDDR6H_BIT9:      equ    %00000010
mATDDR6H_BIT10:     equ    %00000100
mATDDR6H_BIT11:     equ    %00001000
mATDDR6H_BIT12:     equ    %00010000
mATDDR6H_BIT13:     equ    %00100000
mATDDR6H_BIT14:     equ    %01000000
mATDDR6H_BIT15:     equ    %10000000


;*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000009D ***
ATDDR6L:            equ    $0000009D                                ;*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6L_BIT6:       equ    6                                         ; Bit 6
ATDDR6L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR6L_BIT6:      equ    %01000000
mATDDR6L_BIT7:      equ    %10000000


;*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000009E ***
ATDDR7:             equ    $0000009E                                ;*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7_BIT6:        equ    6                                         ; Bit 6
ATDDR7_BIT7:        equ    7                                         ; Bit 7
ATDDR7_BIT8:        equ    8                                         ; Bit 8
ATDDR7_BIT9:        equ    9                                         ; Bit 9
ATDDR7_BIT10:       equ    10                                        ; Bit 10
ATDDR7_BIT11:       equ    11                                        ; Bit 11
ATDDR7_BIT12:       equ    12                                        ; Bit 12
ATDDR7_BIT13:       equ    13                                        ; Bit 13
ATDDR7_BIT14:       equ    14                                        ; Bit 14
ATDDR7_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR7_BIT6:       equ    %01000000
mATDDR7_BIT7:       equ    %10000000
mATDDR7_BIT8:       equ    %100000000
mATDDR7_BIT9:       equ    %1000000000
mATDDR7_BIT10:      equ    %10000000000
mATDDR7_BIT11:      equ    %100000000000
mATDDR7_BIT12:      equ    %1000000000000
mATDDR7_BIT13:      equ    %10000000000000
mATDDR7_BIT14:      equ    %100000000000000
mATDDR7_BIT15:      equ    %1000000000000000


;*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000009E ***
ATDDR7H:            equ    $0000009E                                ;*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7H_BIT8:       equ    0                                         ; Bit 8
ATDDR7H_BIT9:       equ    1                                         ; Bit 9
ATDDR7H_BIT10:      equ    2                                         ; Bit 10
ATDDR7H_BIT11:      equ    3                                         ; Bit 11
ATDDR7H_BIT12:      equ    4                                         ; Bit 12
ATDDR7H_BIT13:      equ    5                                         ; Bit 13
ATDDR7H_BIT14:      equ    6                                         ; Bit 14
ATDDR7H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR7H_BIT8:      equ    %00000001
mATDDR7H_BIT9:      equ    %00000010
mATDDR7H_BIT10:     equ    %00000100
mATDDR7H_BIT11:     equ    %00001000
mATDDR7H_BIT12:     equ    %00010000
mATDDR7H_BIT13:     equ    %00100000
mATDDR7H_BIT14:     equ    %01000000
mATDDR7H_BIT15:     equ    %10000000


;*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000009F ***
ATDDR7L:            equ    $0000009F                                ;*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7L_BIT6:       equ    6                                         ; Bit 6
ATDDR7L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR7L_BIT6:      equ    %01000000
mATDDR7L_BIT7:      equ    %10000000


;*** ATDDR8 - ATD  Conversion Result Register 8; 0x000000A0 ***
ATDDR8:             equ    $000000A0                                ;*** ATDDR8 - ATD  Conversion Result Register 8; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8_BIT6:        equ    6                                         ; Bit 6
ATDDR8_BIT7:        equ    7                                         ; Bit 7
ATDDR8_BIT8:        equ    8                                         ; Bit 8
ATDDR8_BIT9:        equ    9                                         ; Bit 9
ATDDR8_BIT10:       equ    10                                        ; Bit 10
ATDDR8_BIT11:       equ    11                                        ; Bit 11
ATDDR8_BIT12:       equ    12                                        ; Bit 12
ATDDR8_BIT13:       equ    13                                        ; Bit 13
ATDDR8_BIT14:       equ    14                                        ; Bit 14
ATDDR8_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR8_BIT6:       equ    %01000000
mATDDR8_BIT7:       equ    %10000000
mATDDR8_BIT8:       equ    %100000000
mATDDR8_BIT9:       equ    %1000000000
mATDDR8_BIT10:      equ    %10000000000
mATDDR8_BIT11:      equ    %100000000000
mATDDR8_BIT12:      equ    %1000000000000
mATDDR8_BIT13:      equ    %10000000000000
mATDDR8_BIT14:      equ    %100000000000000
mATDDR8_BIT15:      equ    %1000000000000000


;*** ATDDR8H - ATD  Conversion Result Register 8 High; 0x000000A0 ***
ATDDR8H:            equ    $000000A0                                ;*** ATDDR8H - ATD  Conversion Result Register 8 High; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8H_BIT8:       equ    0                                         ; Bit 8
ATDDR8H_BIT9:       equ    1                                         ; Bit 9
ATDDR8H_BIT10:      equ    2                                         ; Bit 10
ATDDR8H_BIT11:      equ    3                                         ; Bit 11
ATDDR8H_BIT12:      equ    4                                         ; Bit 12
ATDDR8H_BIT13:      equ    5                                         ; Bit 13
ATDDR8H_BIT14:      equ    6                                         ; Bit 14
ATDDR8H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR8H_BIT8:      equ    %00000001
mATDDR8H_BIT9:      equ    %00000010
mATDDR8H_BIT10:     equ    %00000100
mATDDR8H_BIT11:     equ    %00001000
mATDDR8H_BIT12:     equ    %00010000
mATDDR8H_BIT13:     equ    %00100000
mATDDR8H_BIT14:     equ    %01000000
mATDDR8H_BIT15:     equ    %10000000


;*** ATDDR8L - ATD  Conversion Result Register 8 Low; 0x000000A1 ***
ATDDR8L:            equ    $000000A1                                ;*** ATDDR8L - ATD  Conversion Result Register 8 Low; 0x000000A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8L_BIT6:       equ    6                                         ; Bit 6
ATDDR8L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR8L_BIT6:      equ    %01000000
mATDDR8L_BIT7:      equ    %10000000


;*** ATDDR9 - ATD  Conversion Result Register 9; 0x000000A2 ***
ATDDR9:             equ    $000000A2                                ;*** ATDDR9 - ATD  Conversion Result Register 9; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9_BIT6:        equ    6                                         ; Bit 6
ATDDR9_BIT7:        equ    7                                         ; Bit 7
ATDDR9_BIT8:        equ    8                                         ; Bit 8
ATDDR9_BIT9:        equ    9                                         ; Bit 9
ATDDR9_BIT10:       equ    10                                        ; Bit 10
ATDDR9_BIT11:       equ    11                                        ; Bit 11
ATDDR9_BIT12:       equ    12                                        ; Bit 12
ATDDR9_BIT13:       equ    13                                        ; Bit 13
ATDDR9_BIT14:       equ    14                                        ; Bit 14
ATDDR9_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR9_BIT6:       equ    %01000000
mATDDR9_BIT7:       equ    %10000000
mATDDR9_BIT8:       equ    %100000000
mATDDR9_BIT9:       equ    %1000000000
mATDDR9_BIT10:      equ    %10000000000
mATDDR9_BIT11:      equ    %100000000000
mATDDR9_BIT12:      equ    %1000000000000
mATDDR9_BIT13:      equ    %10000000000000
mATDDR9_BIT14:      equ    %100000000000000
mATDDR9_BIT15:      equ    %1000000000000000


;*** ATDDR9H - ATD  Conversion Result Register 9 High; 0x000000A2 ***
ATDDR9H:            equ    $000000A2                                ;*** ATDDR9H - ATD  Conversion Result Register 9 High; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9H_BIT8:       equ    0                                         ; Bit 8
ATDDR9H_BIT9:       equ    1                                         ; Bit 9
ATDDR9H_BIT10:      equ    2                                         ; Bit 10
ATDDR9H_BIT11:      equ    3                                         ; Bit 11
ATDDR9H_BIT12:      equ    4                                         ; Bit 12
ATDDR9H_BIT13:      equ    5                                         ; Bit 13
ATDDR9H_BIT14:      equ    6                                         ; Bit 14
ATDDR9H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR9H_BIT8:      equ    %00000001
mATDDR9H_BIT9:      equ    %00000010
mATDDR9H_BIT10:     equ    %00000100
mATDDR9H_BIT11:     equ    %00001000
mATDDR9H_BIT12:     equ    %00010000
mATDDR9H_BIT13:     equ    %00100000
mATDDR9H_BIT14:     equ    %01000000
mATDDR9H_BIT15:     equ    %10000000


;*** ATDDR9L - ATD  Conversion Result Register 9 Low; 0x000000A3 ***
ATDDR9L:            equ    $000000A3                                ;*** ATDDR9L - ATD  Conversion Result Register 9 Low; 0x000000A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9L_BIT6:       equ    6                                         ; Bit 6
ATDDR9L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR9L_BIT6:      equ    %01000000
mATDDR9L_BIT7:      equ    %10000000


;*** ATDDR10 - ATD  Conversion Result Register 10; 0x000000A4 ***
ATDDR10:            equ    $000000A4                                ;*** ATDDR10 - ATD  Conversion Result Register 10; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10_BIT6:       equ    6                                         ; Bit 6
ATDDR10_BIT7:       equ    7                                         ; Bit 7
ATDDR10_BIT8:       equ    8                                         ; Bit 8
ATDDR10_BIT9:       equ    9                                         ; Bit 9
ATDDR10_BIT10:      equ    10                                        ; Bit 10
ATDDR10_BIT11:      equ    11                                        ; Bit 11
ATDDR10_BIT12:      equ    12                                        ; Bit 12
ATDDR10_BIT13:      equ    13                                        ; Bit 13
ATDDR10_BIT14:      equ    14                                        ; Bit 14
ATDDR10_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR10_BIT6:      equ    %01000000
mATDDR10_BIT7:      equ    %10000000
mATDDR10_BIT8:      equ    %100000000
mATDDR10_BIT9:      equ    %1000000000
mATDDR10_BIT10:     equ    %10000000000
mATDDR10_BIT11:     equ    %100000000000
mATDDR10_BIT12:     equ    %1000000000000
mATDDR10_BIT13:     equ    %10000000000000
mATDDR10_BIT14:     equ    %100000000000000
mATDDR10_BIT15:     equ    %1000000000000000


;*** ATDDR10H - ATD  Conversion Result Register 10 High; 0x000000A4 ***
ATDDR10H:           equ    $000000A4                                ;*** ATDDR10H - ATD  Conversion Result Register 10 High; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10H_BIT8:      equ    0                                         ; Bit 8
ATDDR10H_BIT9:      equ    1                                         ; Bit 9
ATDDR10H_BIT10:     equ    2                                         ; Bit 10
ATDDR10H_BIT11:     equ    3                                         ; Bit 11
ATDDR10H_BIT12:     equ    4                                         ; Bit 12
ATDDR10H_BIT13:     equ    5                                         ; Bit 13
ATDDR10H_BIT14:     equ    6                                         ; Bit 14
ATDDR10H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR10H_BIT8:     equ    %00000001
mATDDR10H_BIT9:     equ    %00000010
mATDDR10H_BIT10:    equ    %00000100
mATDDR10H_BIT11:    equ    %00001000
mATDDR10H_BIT12:    equ    %00010000
mATDDR10H_BIT13:    equ    %00100000
mATDDR10H_BIT14:    equ    %01000000
mATDDR10H_BIT15:    equ    %10000000


;*** ATDDR10L - ATD  Conversion Result Register 10 Low; 0x000000A5 ***
ATDDR10L:           equ    $000000A5                                ;*** ATDDR10L - ATD  Conversion Result Register 10 Low; 0x000000A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10L_BIT6:      equ    6                                         ; Bit 6
ATDDR10L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR10L_BIT6:     equ    %01000000
mATDDR10L_BIT7:     equ    %10000000


;*** ATDDR11 - ATD  Conversion Result Register 11; 0x000000A6 ***
ATDDR11:            equ    $000000A6                                ;*** ATDDR11 - ATD  Conversion Result Register 11; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11_BIT6:       equ    6                                         ; Bit 6
ATDDR11_BIT7:       equ    7                                         ; Bit 7
ATDDR11_BIT8:       equ    8                                         ; Bit 8
ATDDR11_BIT9:       equ    9                                         ; Bit 9
ATDDR11_BIT10:      equ    10                                        ; Bit 10
ATDDR11_BIT11:      equ    11                                        ; Bit 11
ATDDR11_BIT12:      equ    12                                        ; Bit 12
ATDDR11_BIT13:      equ    13                                        ; Bit 13
ATDDR11_BIT14:      equ    14                                        ; Bit 14
ATDDR11_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR11_BIT6:      equ    %01000000
mATDDR11_BIT7:      equ    %10000000
mATDDR11_BIT8:      equ    %100000000
mATDDR11_BIT9:      equ    %1000000000
mATDDR11_BIT10:     equ    %10000000000
mATDDR11_BIT11:     equ    %100000000000
mATDDR11_BIT12:     equ    %1000000000000
mATDDR11_BIT13:     equ    %10000000000000
mATDDR11_BIT14:     equ    %100000000000000
mATDDR11_BIT15:     equ    %1000000000000000


;*** ATDDR11H - ATD  Conversion Result Register 11 High; 0x000000A6 ***
ATDDR11H:           equ    $000000A6                                ;*** ATDDR11H - ATD  Conversion Result Register 11 High; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11H_BIT8:      equ    0                                         ; Bit 8
ATDDR11H_BIT9:      equ    1                                         ; Bit 9
ATDDR11H_BIT10:     equ    2                                         ; Bit 10
ATDDR11H_BIT11:     equ    3                                         ; Bit 11
ATDDR11H_BIT12:     equ    4                                         ; Bit 12
ATDDR11H_BIT13:     equ    5                                         ; Bit 13
ATDDR11H_BIT14:     equ    6                                         ; Bit 14
ATDDR11H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR11H_BIT8:     equ    %00000001
mATDDR11H_BIT9:     equ    %00000010
mATDDR11H_BIT10:    equ    %00000100
mATDDR11H_BIT11:    equ    %00001000
mATDDR11H_BIT12:    equ    %00010000
mATDDR11H_BIT13:    equ    %00100000
mATDDR11H_BIT14:    equ    %01000000
mATDDR11H_BIT15:    equ    %10000000


;*** ATDDR11L - ATD  Conversion Result Register 11 Low; 0x000000A7 ***
ATDDR11L:           equ    $000000A7                                ;*** ATDDR11L - ATD  Conversion Result Register 11 Low; 0x000000A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11L_BIT6:      equ    6                                         ; Bit 6
ATDDR11L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR11L_BIT6:     equ    %01000000
mATDDR11L_BIT7:     equ    %10000000


;*** ATDDR12 - ATD  Conversion Result Register 12; 0x000000A8 ***
ATDDR12:            equ    $000000A8                                ;*** ATDDR12 - ATD  Conversion Result Register 12; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12_BIT6:       equ    6                                         ; Bit 6
ATDDR12_BIT7:       equ    7                                         ; Bit 7
ATDDR12_BIT8:       equ    8                                         ; Bit 8
ATDDR12_BIT9:       equ    9                                         ; Bit 9
ATDDR12_BIT10:      equ    10                                        ; Bit 10
ATDDR12_BIT11:      equ    11                                        ; Bit 11
ATDDR12_BIT12:      equ    12                                        ; Bit 12
ATDDR12_BIT13:      equ    13                                        ; Bit 13
ATDDR12_BIT14:      equ    14                                        ; Bit 14
ATDDR12_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR12_BIT6:      equ    %01000000
mATDDR12_BIT7:      equ    %10000000
mATDDR12_BIT8:      equ    %100000000
mATDDR12_BIT9:      equ    %1000000000
mATDDR12_BIT10:     equ    %10000000000
mATDDR12_BIT11:     equ    %100000000000
mATDDR12_BIT12:     equ    %1000000000000
mATDDR12_BIT13:     equ    %10000000000000
mATDDR12_BIT14:     equ    %100000000000000
mATDDR12_BIT15:     equ    %1000000000000000


;*** ATDDR12H - ATD  Conversion Result Register 12 High; 0x000000A8 ***
ATDDR12H:           equ    $000000A8                                ;*** ATDDR12H - ATD  Conversion Result Register 12 High; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12H_BIT8:      equ    0                                         ; Bit 8
ATDDR12H_BIT9:      equ    1                                         ; Bit 9
ATDDR12H_BIT10:     equ    2                                         ; Bit 10
ATDDR12H_BIT11:     equ    3                                         ; Bit 11
ATDDR12H_BIT12:     equ    4                                         ; Bit 12
ATDDR12H_BIT13:     equ    5                                         ; Bit 13
ATDDR12H_BIT14:     equ    6                                         ; Bit 14
ATDDR12H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR12H_BIT8:     equ    %00000001
mATDDR12H_BIT9:     equ    %00000010
mATDDR12H_BIT10:    equ    %00000100
mATDDR12H_BIT11:    equ    %00001000
mATDDR12H_BIT12:    equ    %00010000
mATDDR12H_BIT13:    equ    %00100000
mATDDR12H_BIT14:    equ    %01000000
mATDDR12H_BIT15:    equ    %10000000


;*** ATDDR12L - ATD  Conversion Result Register 12 Low; 0x000000A9 ***
ATDDR12L:           equ    $000000A9                                ;*** ATDDR12L - ATD  Conversion Result Register 12 Low; 0x000000A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12L_BIT6:      equ    6                                         ; Bit 6
ATDDR12L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR12L_BIT6:     equ    %01000000
mATDDR12L_BIT7:     equ    %10000000


;*** ATDDR13 - ATD  Conversion Result Register 13; 0x000000AA ***
ATDDR13:            equ    $000000AA                                ;*** ATDDR13 - ATD  Conversion Result Register 13; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13_BIT6:       equ    6                                         ; Bit 6
ATDDR13_BIT7:       equ    7                                         ; Bit 7
ATDDR13_BIT8:       equ    8                                         ; Bit 8
ATDDR13_BIT9:       equ    9                                         ; Bit 9
ATDDR13_BIT10:      equ    10                                        ; Bit 10
ATDDR13_BIT11:      equ    11                                        ; Bit 11
ATDDR13_BIT12:      equ    12                                        ; Bit 12
ATDDR13_BIT13:      equ    13                                        ; Bit 13
ATDDR13_BIT14:      equ    14                                        ; Bit 14
ATDDR13_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR13_BIT6:      equ    %01000000
mATDDR13_BIT7:      equ    %10000000
mATDDR13_BIT8:      equ    %100000000
mATDDR13_BIT9:      equ    %1000000000
mATDDR13_BIT10:     equ    %10000000000
mATDDR13_BIT11:     equ    %100000000000
mATDDR13_BIT12:     equ    %1000000000000
mATDDR13_BIT13:     equ    %10000000000000
mATDDR13_BIT14:     equ    %100000000000000
mATDDR13_BIT15:     equ    %1000000000000000


;*** ATDDR13H - ATD  Conversion Result Register 13 High; 0x000000AA ***
ATDDR13H:           equ    $000000AA                                ;*** ATDDR13H - ATD  Conversion Result Register 13 High; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13H_BIT8:      equ    0                                         ; Bit 8
ATDDR13H_BIT9:      equ    1                                         ; Bit 9
ATDDR13H_BIT10:     equ    2                                         ; Bit 10
ATDDR13H_BIT11:     equ    3                                         ; Bit 11
ATDDR13H_BIT12:     equ    4                                         ; Bit 12
ATDDR13H_BIT13:     equ    5                                         ; Bit 13
ATDDR13H_BIT14:     equ    6                                         ; Bit 14
ATDDR13H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR13H_BIT8:     equ    %00000001
mATDDR13H_BIT9:     equ    %00000010
mATDDR13H_BIT10:    equ    %00000100
mATDDR13H_BIT11:    equ    %00001000
mATDDR13H_BIT12:    equ    %00010000
mATDDR13H_BIT13:    equ    %00100000
mATDDR13H_BIT14:    equ    %01000000
mATDDR13H_BIT15:    equ    %10000000


;*** ATDDR13L - ATD  Conversion Result Register 13 Low; 0x000000AB ***
ATDDR13L:           equ    $000000AB                                ;*** ATDDR13L - ATD  Conversion Result Register 13 Low; 0x000000AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13L_BIT6:      equ    6                                         ; Bit 6
ATDDR13L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR13L_BIT6:     equ    %01000000
mATDDR13L_BIT7:     equ    %10000000


;*** ATDDR14 - ATD  Conversion Result Register 14; 0x000000AC ***
ATDDR14:            equ    $000000AC                                ;*** ATDDR14 - ATD  Conversion Result Register 14; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14_BIT6:       equ    6                                         ; Bit 6
ATDDR14_BIT7:       equ    7                                         ; Bit 7
ATDDR14_BIT8:       equ    8                                         ; Bit 8
ATDDR14_BIT9:       equ    9                                         ; Bit 9
ATDDR14_BIT10:      equ    10                                        ; Bit 10
ATDDR14_BIT11:      equ    11                                        ; Bit 11
ATDDR14_BIT12:      equ    12                                        ; Bit 12
ATDDR14_BIT13:      equ    13                                        ; Bit 13
ATDDR14_BIT14:      equ    14                                        ; Bit 14
ATDDR14_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR14_BIT6:      equ    %01000000
mATDDR14_BIT7:      equ    %10000000
mATDDR14_BIT8:      equ    %100000000
mATDDR14_BIT9:      equ    %1000000000
mATDDR14_BIT10:     equ    %10000000000
mATDDR14_BIT11:     equ    %100000000000
mATDDR14_BIT12:     equ    %1000000000000
mATDDR14_BIT13:     equ    %10000000000000
mATDDR14_BIT14:     equ    %100000000000000
mATDDR14_BIT15:     equ    %1000000000000000


;*** ATDDR14H - ATD  Conversion Result Register 14 High; 0x000000AC ***
ATDDR14H:           equ    $000000AC                                ;*** ATDDR14H - ATD  Conversion Result Register 14 High; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14H_BIT8:      equ    0                                         ; Bit 8
ATDDR14H_BIT9:      equ    1                                         ; Bit 9
ATDDR14H_BIT10:     equ    2                                         ; Bit 10
ATDDR14H_BIT11:     equ    3                                         ; Bit 11
ATDDR14H_BIT12:     equ    4                                         ; Bit 12
ATDDR14H_BIT13:     equ    5                                         ; Bit 13
ATDDR14H_BIT14:     equ    6                                         ; Bit 14
ATDDR14H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR14H_BIT8:     equ    %00000001
mATDDR14H_BIT9:     equ    %00000010
mATDDR14H_BIT10:    equ    %00000100
mATDDR14H_BIT11:    equ    %00001000
mATDDR14H_BIT12:    equ    %00010000
mATDDR14H_BIT13:    equ    %00100000
mATDDR14H_BIT14:    equ    %01000000
mATDDR14H_BIT15:    equ    %10000000


;*** ATDDR14L - ATD  Conversion Result Register 14 Low; 0x000000AD ***
ATDDR14L:           equ    $000000AD                                ;*** ATDDR14L - ATD  Conversion Result Register 14 Low; 0x000000AD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14L_BIT6:      equ    6                                         ; Bit 6
ATDDR14L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR14L_BIT6:     equ    %01000000
mATDDR14L_BIT7:     equ    %10000000


;*** ATDDR15 - ATD  Conversion Result Register 15; 0x000000AE ***
ATDDR15:            equ    $000000AE                                ;*** ATDDR15 - ATD  Conversion Result Register 15; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15_BIT6:       equ    6                                         ; Bit 6
ATDDR15_BIT7:       equ    7                                         ; Bit 7
ATDDR15_BIT8:       equ    8                                         ; Bit 8
ATDDR15_BIT9:       equ    9                                         ; Bit 9
ATDDR15_BIT10:      equ    10                                        ; Bit 10
ATDDR15_BIT11:      equ    11                                        ; Bit 11
ATDDR15_BIT12:      equ    12                                        ; Bit 12
ATDDR15_BIT13:      equ    13                                        ; Bit 13
ATDDR15_BIT14:      equ    14                                        ; Bit 14
ATDDR15_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR15_BIT6:      equ    %01000000
mATDDR15_BIT7:      equ    %10000000
mATDDR15_BIT8:      equ    %100000000
mATDDR15_BIT9:      equ    %1000000000
mATDDR15_BIT10:     equ    %10000000000
mATDDR15_BIT11:     equ    %100000000000
mATDDR15_BIT12:     equ    %1000000000000
mATDDR15_BIT13:     equ    %10000000000000
mATDDR15_BIT14:     equ    %100000000000000
mATDDR15_BIT15:     equ    %1000000000000000


;*** ATDDR15H - ATD  Conversion Result Register 15 High; 0x000000AE ***
ATDDR15H:           equ    $000000AE                                ;*** ATDDR15H - ATD  Conversion Result Register 15 High; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15H_BIT8:      equ    0                                         ; Bit 8
ATDDR15H_BIT9:      equ    1                                         ; Bit 9
ATDDR15H_BIT10:     equ    2                                         ; Bit 10
ATDDR15H_BIT11:     equ    3                                         ; Bit 11
ATDDR15H_BIT12:     equ    4                                         ; Bit 12
ATDDR15H_BIT13:     equ    5                                         ; Bit 13
ATDDR15H_BIT14:     equ    6                                         ; Bit 14
ATDDR15H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR15H_BIT8:     equ    %00000001
mATDDR15H_BIT9:     equ    %00000010
mATDDR15H_BIT10:    equ    %00000100
mATDDR15H_BIT11:    equ    %00001000
mATDDR15H_BIT12:    equ    %00010000
mATDDR15H_BIT13:    equ    %00100000
mATDDR15H_BIT14:    equ    %01000000
mATDDR15H_BIT15:    equ    %10000000


;*** ATDDR15L - ATD  Conversion Result Register 15 Low; 0x000000AF ***
ATDDR15L:           equ    $000000AF                                ;*** ATDDR15L - ATD  Conversion Result Register 15 Low; 0x000000AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15L_BIT6:      equ    6                                         ; Bit 6
ATDDR15L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR15L_BIT6:     equ    %01000000
mATDDR15L_BIT7:     equ    %10000000


;*** IVBR - Interrupt Vector Base Register; 0x000000B1 ***
IVBR:               equ    $000000B1                                ;*** IVBR - Interrupt Vector Base Register; 0x000000B1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR:      equ    0                                         ; Interrupt Vector Base Address Bits
; bit position masks
mIVBR_IVB_ADDR:     equ    %11111111


;*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x000000B6 ***
INT_XGPRIO:         equ    $000000B6                                ;*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x000000B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_XGPRIO_XILVL:   equ    0                                         ; XGATE Interrupt Priority Level
; bit position masks
mINT_XGPRIO_XILVL:  equ    %00000111


;*** INT_CFADDR - Interrupt Request Configuration Address Register; 0x000000B7 ***
INT_CFADDR:         equ    $000000B7                                ;*** INT_CFADDR - Interrupt Request Configuration Address Register; 0x000000B7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFADDR_INT_CFADDR: equ    4                                      ; Interrupt Request Configuration Data Register Select Bits
; bit position masks
mINT_CFADDR_INT_CFADDR: equ    %11110000


;*** INT_CFDATA0 - Interrupt Request Configuration Data Register 0; 0x000000B8 ***
INT_CFDATA0:        equ    $000000B8                                ;*** INT_CFDATA0 - Interrupt Request Configuration Data Register 0; 0x000000B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA0_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA0_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA0_PRIOLVL: equ    %00000111
mINT_CFDATA0_RQST:  equ    %10000000


;*** INT_CFDATA1 - Interrupt Request Configuration Data Register 1; 0x000000B9 ***
INT_CFDATA1:        equ    $000000B9                                ;*** INT_CFDATA1 - Interrupt Request Configuration Data Register 1; 0x000000B9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA1_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA1_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA1_PRIOLVL: equ    %00000111
mINT_CFDATA1_RQST:  equ    %10000000


;*** INT_CFDATA2 - Interrupt Request Configuration Data Register 2; 0x000000BA ***
INT_CFDATA2:        equ    $000000BA                                ;*** INT_CFDATA2 - Interrupt Request Configuration Data Register 2; 0x000000BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA2_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA2_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA2_PRIOLVL: equ    %00000111
mINT_CFDATA2_RQST:  equ    %10000000


;*** INT_CFDATA3 - Interrupt Request Configuration Data Register 3; 0x000000BB ***
INT_CFDATA3:        equ    $000000BB                                ;*** INT_CFDATA3 - Interrupt Request Configuration Data Register 3; 0x000000BB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA3_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA3_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA3_PRIOLVL: equ    %00000111
mINT_CFDATA3_RQST:  equ    %10000000


;*** INT_CFDATA4 - Interrupt Request Configuration Data Register 4; 0x000000BC ***
INT_CFDATA4:        equ    $000000BC                                ;*** INT_CFDATA4 - Interrupt Request Configuration Data Register 4; 0x000000BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA4_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA4_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA4_PRIOLVL: equ    %00000111
mINT_CFDATA4_RQST:  equ    %10000000


;*** INT_CFDATA5 - Interrupt Request Configuration Data Register 5; 0x000000BD ***
INT_CFDATA5:        equ    $000000BD                                ;*** INT_CFDATA5 - Interrupt Request Configuration Data Register 5; 0x000000BD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA5_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA5_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA5_PRIOLVL: equ    %00000111
mINT_CFDATA5_RQST:  equ    %10000000


;*** INT_CFDATA6 - Interrupt Request Configuration Data Register 6; 0x000000BE ***
INT_CFDATA6:        equ    $000000BE                                ;*** INT_CFDATA6 - Interrupt Request Configuration Data Register 6; 0x000000BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA6_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA6_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA6_PRIOLVL: equ    %00000111
mINT_CFDATA6_RQST:  equ    %10000000


;*** INT_CFDATA7 - Interrupt Request Configuration Data Register 7; 0x000000BF ***
INT_CFDATA7:        equ    $000000BF                                ;*** INT_CFDATA7 - Interrupt Request Configuration Data Register 7; 0x000000BF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA7_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA7_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA7_PRIOLVL: equ    %00000111
mINT_CFDATA7_RQST:  equ    %10000000


;*** IIC0_IBAD - IIC Address Register; 0x000000C0 ***
IIC0_IBAD:          equ    $000000C0                                ;*** IIC0_IBAD - IIC Address Register; 0x000000C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBAD_ADR1:     equ    1                                         ; Slave Address Bit 1
IIC0_IBAD_ADR2:     equ    2                                         ; Slave Address Bit 2
IIC0_IBAD_ADR3:     equ    3                                         ; Slave Address Bit 3
IIC0_IBAD_ADR4:     equ    4                                         ; Slave Address Bit 4
IIC0_IBAD_ADR5:     equ    5                                         ; Slave Address Bit 5
IIC0_IBAD_ADR6:     equ    6                                         ; Slave Address Bit 6
IIC0_IBAD_ADR7:     equ    7                                         ; Slave Address Bit 7
; bit position masks
mIIC0_IBAD_ADR1:    equ    %00000010
mIIC0_IBAD_ADR2:    equ    %00000100
mIIC0_IBAD_ADR3:    equ    %00001000
mIIC0_IBAD_ADR4:    equ    %00010000
mIIC0_IBAD_ADR5:    equ    %00100000
mIIC0_IBAD_ADR6:    equ    %01000000
mIIC0_IBAD_ADR7:    equ    %10000000


;*** IIC0_IBFD - IIC Frequency Divider Register; 0x000000C1 ***
IIC0_IBFD:          equ    $000000C1                                ;*** IIC0_IBFD - IIC Frequency Divider Register; 0x000000C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBFD_IBC0:     equ    0                                         ; I-Bus Clock Rate 0
IIC0_IBFD_IBC1:     equ    1                                         ; I-Bus Clock Rate 1
IIC0_IBFD_IBC2:     equ    2                                         ; I-Bus Clock Rate 2
IIC0_IBFD_IBC3:     equ    3                                         ; I-Bus Clock Rate 3
IIC0_IBFD_IBC4:     equ    4                                         ; I-Bus Clock Rate 4
IIC0_IBFD_IBC5:     equ    5                                         ; I-Bus Clock Rate 5
IIC0_IBFD_IBC6:     equ    6                                         ; I-Bus Clock Rate 6
IIC0_IBFD_IBC7:     equ    7                                         ; I-Bus Clock Rate 7
; bit position masks
mIIC0_IBFD_IBC0:    equ    %00000001
mIIC0_IBFD_IBC1:    equ    %00000010
mIIC0_IBFD_IBC2:    equ    %00000100
mIIC0_IBFD_IBC3:    equ    %00001000
mIIC0_IBFD_IBC4:    equ    %00010000
mIIC0_IBFD_IBC5:    equ    %00100000
mIIC0_IBFD_IBC6:    equ    %01000000
mIIC0_IBFD_IBC7:    equ    %10000000


;*** IIC0_IBCR - IIC Control Register; 0x000000C2 ***
IIC0_IBCR:          equ    $000000C2                                ;*** IIC0_IBCR - IIC Control Register; 0x000000C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBCR_IBSWAI:   equ    0                                         ; I-Bus Interface Stop in WAIT mode
IIC0_IBCR_RSTA:     equ    2                                         ; Repeat Start
IIC0_IBCR_TXAK:     equ    3                                         ; Transmit Acknowledge enable
IIC0_IBCR_TX_RX:    equ    4                                         ; Transmit/Receive mode select bit
IIC0_IBCR_MS_SL:    equ    5                                         ; Master/Slave mode select bit
IIC0_IBCR_IBIE:     equ    6                                         ; I-Bus Interrupt Enable
IIC0_IBCR_IBEN:     equ    7                                         ; I-Bus Enable
; bit position masks
mIIC0_IBCR_IBSWAI:  equ    %00000001
mIIC0_IBCR_RSTA:    equ    %00000100
mIIC0_IBCR_TXAK:    equ    %00001000
mIIC0_IBCR_TX_RX:   equ    %00010000
mIIC0_IBCR_MS_SL:   equ    %00100000
mIIC0_IBCR_IBIE:    equ    %01000000
mIIC0_IBCR_IBEN:    equ    %10000000


;*** IIC0_IBSR - IIC Status Register; 0x000000C3 ***
IIC0_IBSR:          equ    $000000C3                                ;*** IIC0_IBSR - IIC Status Register; 0x000000C3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBSR_RXAK:     equ    0                                         ; Received Acknowledge
IIC0_IBSR_IBIF:     equ    1                                         ; I-Bus Interrupt
IIC0_IBSR_SRW:      equ    2                                         ; Slave Read/Write
IIC0_IBSR_IBAL:     equ    4                                         ; Arbitration Lost
IIC0_IBSR_IBB:      equ    5                                         ; Bus busy bit
IIC0_IBSR_IAAS:     equ    6                                         ; Addressed as a slave bit
IIC0_IBSR_TCF:      equ    7                                         ; Data transferring bit
; bit position masks
mIIC0_IBSR_RXAK:    equ    %00000001
mIIC0_IBSR_IBIF:    equ    %00000010
mIIC0_IBSR_SRW:     equ    %00000100
mIIC0_IBSR_IBAL:    equ    %00010000
mIIC0_IBSR_IBB:     equ    %00100000
mIIC0_IBSR_IAAS:    equ    %01000000
mIIC0_IBSR_TCF:     equ    %10000000


;*** IIC0_IBDR - IIC Data I/O Register; 0x000000C4 ***
IIC0_IBDR:          equ    $000000C4                                ;*** IIC0_IBDR - IIC Data I/O Register; 0x000000C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBDR_D0:       equ    0                                         ; IIC Data Bit 0
IIC0_IBDR_D1:       equ    1                                         ; IIC Data Bit 1
IIC0_IBDR_D2:       equ    2                                         ; IIC Data Bit 2
IIC0_IBDR_D3:       equ    3                                         ; IIC Data Bit 3
IIC0_IBDR_D4:       equ    4                                         ; IIC Data Bit 4
IIC0_IBDR_D5:       equ    5                                         ; IIC Data Bit 5
IIC0_IBDR_D6:       equ    6                                         ; IIC Data Bit 6
IIC0_IBDR_D7:       equ    7                                         ; IIC Data Bit 7
; bit position masks
mIIC0_IBDR_D0:      equ    %00000001
mIIC0_IBDR_D1:      equ    %00000010
mIIC0_IBDR_D2:      equ    %00000100
mIIC0_IBDR_D3:      equ    %00001000
mIIC0_IBDR_D4:      equ    %00010000
mIIC0_IBDR_D5:      equ    %00100000
mIIC0_IBDR_D6:      equ    %01000000
mIIC0_IBDR_D7:      equ    %10000000


;*** IIC0_IBCR2 - IIC Control Register 2; 0x000000C5 ***
IIC0_IBCR2:         equ    $000000C5                                ;*** IIC0_IBCR2 - IIC Control Register 2; 0x000000C5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBCR2_ADR8:    equ    0                                         ; Slave Address Bit 8
IIC0_IBCR2_ADR9:    equ    1                                         ; Slave Address Bit 9
IIC0_IBCR2_ADR10:   equ    2                                         ; Slave Address Bit 10
IIC0_IBCR2_ADTYPE:  equ    6                                         ; Address Type
IIC0_IBCR2_GCEN:    equ    7                                         ; General Call Enable
; bit position masks
mIIC0_IBCR2_ADR8:   equ    %00000001
mIIC0_IBCR2_ADR9:   equ    %00000010
mIIC0_IBCR2_ADR10:  equ    %00000100
mIIC0_IBCR2_ADTYPE: equ    %01000000
mIIC0_IBCR2_GCEN:   equ    %10000000


;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
SCI0BD:             equ    $000000C8                                ;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI0BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI0BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI0BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI0BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI0BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI0BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI0BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI0BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI0BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI0BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI0BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI0BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI0BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI0BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI0BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI0BD_SBR0:       equ    %00000001
mSCI0BD_SBR1:       equ    %00000010
mSCI0BD_SBR2:       equ    %00000100
mSCI0BD_SBR3:       equ    %00001000
mSCI0BD_SBR4:       equ    %00010000
mSCI0BD_SBR5:       equ    %00100000
mSCI0BD_SBR6:       equ    %01000000
mSCI0BD_SBR7:       equ    %10000000
mSCI0BD_SBR8:       equ    %100000000
mSCI0BD_SBR9:       equ    %1000000000
mSCI0BD_SBR10:      equ    %10000000000
mSCI0BD_SBR11:      equ    %100000000000
mSCI0BD_SBR12:      equ    %1000000000000
mSCI0BD_TNP0:       equ    %10000000000000
mSCI0BD_TNP1:       equ    %100000000000000
mSCI0BD_IREN:       equ    %1000000000000000


;*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***
SCI0ASR1:           equ    $000000C8                                ;*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI0ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI0ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI0ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI0ASR1_BKDIF:    equ    %00000001
mSCI0ASR1_BERRIF:   equ    %00000010
mSCI0ASR1_BERRV:    equ    %00000100
mSCI0ASR1_RXEDGIF:  equ    %10000000


;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
SCI0BDH:            equ    $000000C8                                ;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI0BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI0BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI0BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI0BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI0BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI0BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI0BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI0BDH_SBR8:      equ    %00000001
mSCI0BDH_SBR9:      equ    %00000010
mSCI0BDH_SBR10:     equ    %00000100
mSCI0BDH_SBR11:     equ    %00001000
mSCI0BDH_SBR12:     equ    %00010000
mSCI0BDH_TNP0:      equ    %00100000
mSCI0BDH_TNP1:      equ    %01000000
mSCI0BDH_IREN:      equ    %10000000


;*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***
SCI0ACR1:           equ    $000000C9                                ;*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI0ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI0ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI0ACR1_BKDIE:    equ    %00000001
mSCI0ACR1_BERRIE:   equ    %00000010
mSCI0ACR1_RXEDGIE:  equ    %10000000


;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
SCI0BDL:            equ    $000000C9                                ;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI0BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI0BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI0BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI0BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI0BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI0BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI0BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI0BDL_SBR0:      equ    %00000001
mSCI0BDL_SBR1:      equ    %00000010
mSCI0BDL_SBR2:      equ    %00000100
mSCI0BDL_SBR3:      equ    %00001000
mSCI0BDL_SBR4:      equ    %00010000
mSCI0BDL_SBR5:      equ    %00100000
mSCI0BDL_SBR6:      equ    %01000000
mSCI0BDL_SBR7:      equ    %10000000


;*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***
SCI0ACR2:           equ    $000000CA                                ;*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI0ACR2_BERRM0:    equ    1                                         ; Bit Error Mode 0
SCI0ACR2_BERRM1:    equ    2                                         ; Bit Error Mode 1
; bit position masks
mSCI0ACR2_BKDFE:    equ    %00000001
mSCI0ACR2_BERRM0:   equ    %00000010
mSCI0ACR2_BERRM1:   equ    %00000100


;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
SCI0CR1:            equ    $000000CA                                ;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR1_PT:         equ    0                                         ; Parity Type Bit
SCI0CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI0CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI0CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI0CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI0CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI0CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI0CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI0CR1_PT:        equ    %00000001
mSCI0CR1_PE:        equ    %00000010
mSCI0CR1_ILT:       equ    %00000100
mSCI0CR1_WAKE:      equ    %00001000
mSCI0CR1_M:         equ    %00010000
mSCI0CR1_RSRC:      equ    %00100000
mSCI0CR1_SCISWAI:   equ    %01000000
mSCI0CR1_LOOPS:     equ    %10000000


;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
SCI0CR2:            equ    $000000CB                                ;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR2_SBK:        equ    0                                         ; Send Break Bit
SCI0CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI0CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI0CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI0CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI0CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI0CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI0CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI0CR2_SBK:       equ    %00000001
mSCI0CR2_RWU:       equ    %00000010
mSCI0CR2_RE:        equ    %00000100
mSCI0CR2_TE:        equ    %00001000
mSCI0CR2_ILIE:      equ    %00010000
mSCI0CR2_RIE:       equ    %00100000
mSCI0CR2_TCIE:      equ    %01000000
mSCI0CR2_TIE:       equ    %10000000


;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
SCI0SR1:            equ    $000000CC                                ;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR1_PF:         equ    0                                         ; Parity Error Flag
SCI0SR1_FE:         equ    1                                         ; Framing Error Flag
SCI0SR1_NF:         equ    2                                         ; Noise Flag
SCI0SR1_OR:         equ    3                                         ; Overrun Flag
SCI0SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI0SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI0SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI0SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI0SR1_PF:        equ    %00000001
mSCI0SR1_FE:        equ    %00000010
mSCI0SR1_NF:        equ    %00000100
mSCI0SR1_OR:        equ    %00001000
mSCI0SR1_IDLE:      equ    %00010000
mSCI0SR1_RDRF:      equ    %00100000
mSCI0SR1_TC:        equ    %01000000
mSCI0SR1_TDRE:      equ    %10000000


;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
SCI0SR2:            equ    $000000CD                                ;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI0SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI0SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI0SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI0SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI0SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI0SR2_RAF:       equ    %00000001
mSCI0SR2_TXDIR:     equ    %00000010
mSCI0SR2_BRK13:     equ    %00000100
mSCI0SR2_RXPOL:     equ    %00001000
mSCI0SR2_TXPOL:     equ    %00010000
mSCI0SR2_AMAP:      equ    %10000000


;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
SCI0DRH:            equ    $000000CE                                ;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI0DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI0DRH_T8:        equ    %01000000
mSCI0DRH_R8:        equ    %10000000


;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
SCI0DRL:            equ    $000000CF                                ;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI0DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI0DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI0DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI0DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI0DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI0DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI0DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI0DRL_R0_T0:     equ    %00000001
mSCI0DRL_R1_T1:     equ    %00000010
mSCI0DRL_R2_T2:     equ    %00000100
mSCI0DRL_R3_T3:     equ    %00001000
mSCI0DRL_R4_T4:     equ    %00010000
mSCI0DRL_R5_T5:     equ    %00100000
mSCI0DRL_R6_T6:     equ    %01000000
mSCI0DRL_R7_T7:     equ    %10000000


;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
SCI1BD:             equ    $000000D0                                ;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI1BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI1BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI1BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI1BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI1BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI1BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI1BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI1BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI1BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI1BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI1BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI1BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI1BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI1BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI1BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI1BD_SBR0:       equ    %00000001
mSCI1BD_SBR1:       equ    %00000010
mSCI1BD_SBR2:       equ    %00000100
mSCI1BD_SBR3:       equ    %00001000
mSCI1BD_SBR4:       equ    %00010000
mSCI1BD_SBR5:       equ    %00100000
mSCI1BD_SBR6:       equ    %01000000
mSCI1BD_SBR7:       equ    %10000000
mSCI1BD_SBR8:       equ    %100000000
mSCI1BD_SBR9:       equ    %1000000000
mSCI1BD_SBR10:      equ    %10000000000
mSCI1BD_SBR11:      equ    %100000000000
mSCI1BD_SBR12:      equ    %1000000000000
mSCI1BD_TNP0:       equ    %10000000000000
mSCI1BD_TNP1:       equ    %100000000000000
mSCI1BD_IREN:       equ    %1000000000000000


;*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***
SCI1ASR1:           equ    $000000D0                                ;*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI1ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI1ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI1ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI1ASR1_BKDIF:    equ    %00000001
mSCI1ASR1_BERRIF:   equ    %00000010
mSCI1ASR1_BERRV:    equ    %00000100
mSCI1ASR1_RXEDGIF:  equ    %10000000


;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
SCI1BDH:            equ    $000000D0                                ;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI1BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI1BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI1BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI1BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI1BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI1BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI1BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI1BDH_SBR8:      equ    %00000001
mSCI1BDH_SBR9:      equ    %00000010
mSCI1BDH_SBR10:     equ    %00000100
mSCI1BDH_SBR11:     equ    %00001000
mSCI1BDH_SBR12:     equ    %00010000
mSCI1BDH_TNP0:      equ    %00100000
mSCI1BDH_TNP1:      equ    %01000000
mSCI1BDH_IREN:      equ    %10000000


;*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***
SCI1ACR1:           equ    $000000D1                                ;*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI1ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI1ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI1ACR1_BKDIE:    equ    %00000001
mSCI1ACR1_BERRIE:   equ    %00000010
mSCI1ACR1_RXEDGIE:  equ    %10000000


;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
SCI1BDL:            equ    $000000D1                                ;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI1BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI1BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI1BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI1BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI1BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI1BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI1BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI1BDL_SBR0:      equ    %00000001
mSCI1BDL_SBR1:      equ    %00000010
mSCI1BDL_SBR2:      equ    %00000100
mSCI1BDL_SBR3:      equ    %00001000
mSCI1BDL_SBR4:      equ    %00010000
mSCI1BDL_SBR5:      equ    %00100000
mSCI1BDL_SBR6:      equ    %01000000
mSCI1BDL_SBR7:      equ    %10000000


;*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***
SCI1ACR2:           equ    $000000D2                                ;*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI1ACR2_BERRM0:    equ    1                                         ; Bit Error Mode 0
SCI1ACR2_BERRM1:    equ    2                                         ; Bit Error Mode 1
; bit position masks
mSCI1ACR2_BKDFE:    equ    %00000001
mSCI1ACR2_BERRM0:   equ    %00000010
mSCI1ACR2_BERRM1:   equ    %00000100


;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
SCI1CR1:            equ    $000000D2                                ;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR1_PT:         equ    0                                         ; Parity Type Bit
SCI1CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI1CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI1CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI1CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI1CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI1CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI1CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI1CR1_PT:        equ    %00000001
mSCI1CR1_PE:        equ    %00000010
mSCI1CR1_ILT:       equ    %00000100
mSCI1CR1_WAKE:      equ    %00001000
mSCI1CR1_M:         equ    %00010000
mSCI1CR1_RSRC:      equ    %00100000
mSCI1CR1_SCISWAI:   equ    %01000000
mSCI1CR1_LOOPS:     equ    %10000000


;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
SCI1CR2:            equ    $000000D3                                ;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR2_SBK:        equ    0                                         ; Send Break Bit
SCI1CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI1CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI1CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI1CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI1CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI1CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI1CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI1CR2_SBK:       equ    %00000001
mSCI1CR2_RWU:       equ    %00000010
mSCI1CR2_RE:        equ    %00000100
mSCI1CR2_TE:        equ    %00001000
mSCI1CR2_ILIE:      equ    %00010000
mSCI1CR2_RIE:       equ    %00100000
mSCI1CR2_TCIE:      equ    %01000000
mSCI1CR2_TIE:       equ    %10000000


;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
SCI1SR1:            equ    $000000D4                                ;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR1_PF:         equ    0                                         ; Parity Error Flag
SCI1SR1_FE:         equ    1                                         ; Framing Error Flag
SCI1SR1_NF:         equ    2                                         ; Noise Flag
SCI1SR1_OR:         equ    3                                         ; Overrun Flag
SCI1SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI1SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI1SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI1SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI1SR1_PF:        equ    %00000001
mSCI1SR1_FE:        equ    %00000010
mSCI1SR1_NF:        equ    %00000100
mSCI1SR1_OR:        equ    %00001000
mSCI1SR1_IDLE:      equ    %00010000
mSCI1SR1_RDRF:      equ    %00100000
mSCI1SR1_TC:        equ    %01000000
mSCI1SR1_TDRE:      equ    %10000000


;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
SCI1SR2:            equ    $000000D5                                ;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI1SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI1SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI1SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI1SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI1SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI1SR2_RAF:       equ    %00000001
mSCI1SR2_TXDIR:     equ    %00000010
mSCI1SR2_BRK13:     equ    %00000100
mSCI1SR2_RXPOL:     equ    %00001000
mSCI1SR2_TXPOL:     equ    %00010000
mSCI1SR2_AMAP:      equ    %10000000


;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
SCI1DRH:            equ    $000000D6                                ;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI1DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI1DRH_T8:        equ    %01000000
mSCI1DRH_R8:        equ    %10000000


;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
SCI1DRL:            equ    $000000D7                                ;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI1DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI1DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI1DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI1DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI1DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI1DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI1DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI1DRL_R0_T0:     equ    %00000001
mSCI1DRL_R1_T1:     equ    %00000010
mSCI1DRL_R2_T2:     equ    %00000100
mSCI1DRL_R3_T3:     equ    %00001000
mSCI1DRL_R4_T4:     equ    %00010000
mSCI1DRL_R5_T5:     equ    %00100000
mSCI1DRL_R6_T6:     equ    %01000000
mSCI1DRL_R7_T7:     equ    %10000000


;*** SPICR1 - SPI  Control Register 1; 0x000000D8 ***
SPICR1:             equ    $000000D8                                ;*** SPICR1 - SPI  Control Register 1; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR1_LSBFE:       equ    0                                         ; SPI LSB-First Enable
SPICR1_SSOE:        equ    1                                         ; Slave Select Output Enable
SPICR1_CPHA:        equ    2                                         ; SPI Clock Phase Bit
SPICR1_CPOL:        equ    3                                         ; SPI Clock Polarity Bit
SPICR1_MSTR:        equ    4                                         ; SPI Master/Slave Mode Select Bit
SPICR1_SPTIE:       equ    5                                         ; SPI Transmit Interrupt Enable
SPICR1_SPE:         equ    6                                         ; SPI System Enable Bit
SPICR1_SPIE:        equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPICR1_LSBFE:      equ    %00000001
mSPICR1_SSOE:       equ    %00000010
mSPICR1_CPHA:       equ    %00000100
mSPICR1_CPOL:       equ    %00001000
mSPICR1_MSTR:       equ    %00010000
mSPICR1_SPTIE:      equ    %00100000
mSPICR1_SPE:        equ    %01000000
mSPICR1_SPIE:       equ    %10000000


;*** SPICR2 - SPI  Control Register 2; 0x000000D9 ***
SPICR2:             equ    $000000D9                                ;*** SPICR2 - SPI  Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPICR2_SPC0:        equ    0                                         ; Serial Pin Control Bit 0
SPICR2_SPISWAI:     equ    1                                         ; SPI Stop in Wait Mode Bit
SPICR2_BIDIROE:     equ    3                                         ; Output enable in the Bidirectional mode of operation
SPICR2_MODFEN:      equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPICR2_SPC0:       equ    %00000001
mSPICR2_SPISWAI:    equ    %00000010
mSPICR2_BIDIROE:    equ    %00001000
mSPICR2_MODFEN:     equ    %00010000


;*** SPIBR - SPI  Baud Rate Register; 0x000000DA ***
SPIBR:              equ    $000000DA                                ;*** SPIBR - SPI  Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Selection Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Selection Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Selection Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPISR - SPI  Status Register; 0x000000DB ***
SPISR:              equ    $000000DB                                ;*** SPISR - SPI  Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPISR_MODF:         equ    4                                         ; Mode Fault Flag
SPISR_SPTEF:        equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPISR_SPIF:         equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPISR_MODF:        equ    %00010000
mSPISR_SPTEF:       equ    %00100000
mSPISR_SPIF:        equ    %10000000


;*** SPIDR - SPI  Data Register; 0x000000DD ***
SPIDR:              equ    $000000DD                                ;*** SPIDR - SPI  Data Register; 0x000000DD ***


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Flash Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Flash Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Flash Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Flash Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Flash Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Flash Clock Divider Bit 5
FCLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
FCLKDIV_FDIVLD:     equ    7                                         ; Flash Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_PRDIV8:    equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Memory security bit 0
FSEC_SEC1:          equ    1                                         ; Memory security bit 1
FSEC_RNV2:          equ    2                                         ; Non Volatile flag bit 2
FSEC_RNV3:          equ    3                                         ; Non Volatile flag bit 3
FSEC_RNV4:          equ    4                                         ; Non Volatile flag bit 4
FSEC_RNV5:          equ    5                                         ; Non Volatile flag bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable, bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable, bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***
FTSTMOD:            equ    $00000102                                ;*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FTSTMOD_WRALL:      equ    4                                         ; Write To All Register Banks (Special mode only)
FTSTMOD_MRDS:       equ    5                                         ; Margin Read Setting
; bit position masks
mFTSTMOD_WRALL:     equ    %00010000
mFTSTMOD_MRDS:      equ    %01100000


;*** FCNFG - Flash Configuration Register; 0x00000103 ***
FCNFG:              equ    $00000103                                ;*** FCNFG - Flash Configuration Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_BKSEL0:       equ    0                                         ; Register bank select
FCNFG_BKSEL1:       equ    1                                         ; Register bank select 1 (Special mode only)
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
FCNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
FCNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mFCNFG_BKSEL0:      equ    %00000001
mFCNFG_BKSEL1:      equ    %00000010
mFCNFG_KEYACC:      equ    %00100000
mFCNFG_CCIE:        equ    %01000000
mFCNFG_CBEIE:       equ    %10000000


;*** FPROT - Flash Protection Register; 0x00000104 ***
FPROT:              equ    $00000104                                ;*** FPROT - Flash Protection Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address size 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address size 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower address range disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher address size 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher address size 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher address range disable
FPROT_RNV6:         equ    6                                         ; Non Volatile Flag Bit
FPROT_FPOPEN:       equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000105 ***
FSTAT:              equ    $00000105                                ;*** FSTAT - Flash Status Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_FAIL:         equ    1                                         ; Failed Flash Operation Flag (Special mode only)
FSTAT_BLANK:        equ    2                                         ; Blank Verify Flag
FSTAT_ACCERR:       equ    4                                         ; Access error
FSTAT_PVIOL:        equ    5                                         ; Protection violation
FSTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
FSTAT_CBEIF:        equ    7                                         ; Command Buffers Empty Interrupt Flag
; bit position masks
mFSTAT_FAIL:        equ    %00000010
mFSTAT_BLANK:       equ    %00000100
mFSTAT_ACCERR:      equ    %00010000
mFSTAT_PVIOL:       equ    %00100000
mFSTAT_CCIF:        equ    %01000000
mFSTAT_CBEIF:       equ    %10000000


;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
FCMD:               equ    $00000106                                ;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_CMDB0:         equ    0                                         ; Flash Command, bit 0
FCMD_CMDB1:         equ    1                                         ; Flash Command, bit 1
FCMD_CMDB2:         equ    2                                         ; Flash Command, bit 2
FCMD_CMDB3:         equ    3                                         ; Flash Command, bit 3
FCMD_CMDB4:         equ    4                                         ; Flash Command, bit 4
FCMD_CMDB5:         equ    5                                         ; Flash Command, bit 5
FCMD_CMDB6:         equ    6                                         ; Flash Command, bit 6
; bit position masks
mFCMD_CMDB0:        equ    %00000001
mFCMD_CMDB1:        equ    %00000010
mFCMD_CMDB2:        equ    %00000100
mFCMD_CMDB3:        equ    %00001000
mFCMD_CMDB4:        equ    %00010000
mFCMD_CMDB5:        equ    %00100000
mFCMD_CMDB6:        equ    %01000000


;*** FCTL - Flash Control Register; 0x00000107 ***
FCTL:               equ    $00000107                                ;*** FCTL - Flash Control Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCTL_NV0:           equ    0                                         ; Non-volatile bits
FCTL_NV1:           equ    1                                         ; Non-volatile bit 1
FCTL_NV2:           equ    2                                         ; Non-volatile bit 2
FCTL_NV3:           equ    3                                         ; Non-volatile bit 3
FCTL_NV4:           equ    4                                         ; Non-volatile bit 4
FCTL_NV5:           equ    5                                         ; Non-volatile bit 5
FCTL_NV6:           equ    6                                         ; Non-volatile bit 6
FCTL_NV7:           equ    7                                         ; Non-volatile bit 7
; bit position masks
mFCTL_NV0:          equ    %00000001
mFCTL_NV1:          equ    %00000010
mFCTL_NV2:          equ    %00000100
mFCTL_NV3:          equ    %00001000
mFCTL_NV4:          equ    %00010000
mFCTL_NV5:          equ    %00100000
mFCTL_NV6:          equ    %01000000
mFCTL_NV7:          equ    %10000000


;*** FADDR - Flash Address Register; 0x00000108 ***
FADDR:              equ    $00000108                                ;*** FADDR - Flash Address Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDR_FADDRLO:      equ    0                                         ; Flash Address
FADDR_FADDRHI:      equ    8                                         ; Flash Address Bit 8
; bit position masks
mFADDR_FADDRLO:     equ    %11111111
mFADDR_FADDRHI:     equ    %1111111100000000


;*** FADDRHI - Flash Address High Register; 0x00000108 ***
FADDRHI:            equ    $00000108                                ;*** FADDRHI - Flash Address High Register; 0x00000108 ***


;*** FADDRLO - Flash Address Low Register; 0x00000109 ***
FADDRLO:            equ    $00000109                                ;*** FADDRLO - Flash Address Low Register; 0x00000109 ***


;*** FDATA - Flash Data Register; 0x0000010A ***
FDATA:              equ    $0000010A                                ;*** FDATA - Flash Data Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATA_FDATALO:      equ    0                                         ; Flash Data Bits
FDATA_FDATAHI:      equ    8                                         ; Flash Data Bit8
; bit position masks
mFDATA_FDATALO:     equ    %11111111
mFDATA_FDATAHI:     equ    %1111111100000000


;*** FDATAHI - Flash Data High Register; 0x0000010A ***
FDATAHI:            equ    $0000010A                                ;*** FDATAHI - Flash Data High Register; 0x0000010A ***


;*** FDATALO - Flash Data Low Register; 0x0000010B ***
FDATALO:            equ    $0000010B                                ;*** FDATALO - Flash Data Low Register; 0x0000010B ***


;*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***
ECLKDIV:            equ    $00000110                                ;*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKDIV_EDIV0:      equ    0                                         ; EEPROM Clock Divider 0
ECLKDIV_EDIV1:      equ    1                                         ; EEPROM Clock Divider 1
ECLKDIV_EDIV2:      equ    2                                         ; EEPROM Clock Divider 2
ECLKDIV_EDIV3:      equ    3                                         ; EEPROM Clock Divider 3
ECLKDIV_EDIV4:      equ    4                                         ; EEPROM Clock Divider 4
ECLKDIV_EDIV5:      equ    5                                         ; EEPROM Clock Divider 5
ECLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
ECLKDIV_EDIVLD:     equ    7                                         ; EEPROM Clock Divider Loaded
; bit position masks
mECLKDIV_EDIV0:     equ    %00000001
mECLKDIV_EDIV1:     equ    %00000010
mECLKDIV_EDIV2:     equ    %00000100
mECLKDIV_EDIV3:     equ    %00001000
mECLKDIV_EDIV4:     equ    %00010000
mECLKDIV_EDIV5:     equ    %00100000
mECLKDIV_PRDIV8:    equ    %01000000
mECLKDIV_EDIVLD:    equ    %10000000


;*** ECNFG - EEPROM Configuration Register; 0x00000113 ***
ECNFG:              equ    $00000113                                ;*** ECNFG - EEPROM Configuration Register; 0x00000113 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
ECNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mECNFG_CCIE:        equ    %01000000
mECNFG_CBEIE:       equ    %10000000


;*** EPROT - EEPROM Protection Register; 0x00000114 ***
EPROT:              equ    $00000114                                ;*** EPROT - EEPROM Protection Register; 0x00000114 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPROT_EPS0:         equ    0                                         ; EEPROM Protection address size 0
EPROT_EPS1:         equ    1                                         ; EEPROM Protection address size 1
EPROT_EPS2:         equ    2                                         ; EEPROM Protection address size 2
EPROT_EPDIS:        equ    3                                         ; EEPROM Protection disable
EPROT_RNV4:         equ    4                                         ; Non Volatile Flag Bits
EPROT_RNV5:         equ    5                                         ; Non Volatile Flag Bit 5
EPROT_RNV6:         equ    6                                         ; Non Volatile Flag Bit 6
EPROT_EPOPEN:       equ    7                                         ; Opens the EEPROM block or a subsection of it for program or erase
; bit position masks
mEPROT_EPS0:        equ    %00000001
mEPROT_EPS1:        equ    %00000010
mEPROT_EPS2:        equ    %00000100
mEPROT_EPDIS:       equ    %00001000
mEPROT_RNV4:        equ    %00010000
mEPROT_RNV5:        equ    %00100000
mEPROT_RNV6:        equ    %01000000
mEPROT_EPOPEN:      equ    %10000000


;*** ESTAT - EEPROM Status Register; 0x00000115 ***
ESTAT:              equ    $00000115                                ;*** ESTAT - EEPROM Status Register; 0x00000115 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ESTAT_FAIL:         equ    1                                         ; Failed EEPROM Operation Flag (Special mode only)
ESTAT_BLANK:        equ    2                                         ; Blank Verify Flag
ESTAT_ACCERR:       equ    4                                         ; Access error
ESTAT_PVIOL:        equ    5                                         ; Protection violation
ESTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
ESTAT_CBEIF:        equ    7                                         ; Command Buffer Empty Interrupt Flag
; bit position masks
mESTAT_FAIL:        equ    %00000010
mESTAT_BLANK:       equ    %00000100
mESTAT_ACCERR:      equ    %00010000
mESTAT_PVIOL:       equ    %00100000
mESTAT_CCIF:        equ    %01000000
mESTAT_CBEIF:       equ    %10000000


;*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***
ECMD:               equ    $00000116                                ;*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECMD_CMDB:          equ    0                                         ; EEPROM Command Bits
; bit position masks
mECMD_CMDB:         equ    %01111111


;*** EADDR - EEPROM Addres register; 0x00000118 ***
EADDR:              equ    $00000118                                ;*** EADDR - EEPROM Addres register; 0x00000118 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EADDR_EABLO:        equ    0                                         ; Address bits low
EADDR_EABHI:        equ    8                                         ; Address Bit 8
; bit position masks
mEADDR_EABLO:       equ    %11111111
mEADDR_EABHI:       equ    %11100000000


;*** EADDRHI - EEPROM Addres High Register; 0x00000118 ***
EADDRHI:            equ    $00000118                                ;*** EADDRHI - EEPROM Addres High Register; 0x00000118 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EADDRHI_EABHI:      equ    0                                         ; Address bits
; bit position masks
mEADDRHI_EABHI:     equ    %00000111


;*** EADDRLO - EEPROM Addres Low Register; 0x00000119 ***
EADDRLO:            equ    $00000119                                ;*** EADDRLO - EEPROM Addres Low Register; 0x00000119 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EADDRLO_EABLO:      equ    0                                         ; Address bits
; bit position masks
mEADDRLO_EABLO:     equ    %11111111


;*** EDATA - EEPROM Data Register; 0x0000011A ***
EDATA:              equ    $0000011A                                ;*** EDATA - EEPROM Data Register; 0x0000011A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EDATA_EDLO:         equ    0                                         ; Data bits low
EDATA_EDHI:         equ    8                                         ; Data bits high
; bit position masks
mEDATA_EDLO:        equ    %11111111
mEDATA_EDHI:        equ    %1111111100000000


;*** EDATAHI - EEPROM Data High Register; 0x0000011A ***
EDATAHI:            equ    $0000011A                                ;*** EDATAHI - EEPROM Data High Register; 0x0000011A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EDATAHI_EDHI:       equ    0                                         ; Data bits
; bit position masks
mEDATAHI_EDHI:      equ    %11111111


;*** EDATALO - EEPROM Data Low Register; 0x0000011B ***
EDATALO:            equ    $0000011B                                ;*** EDATALO - EEPROM Data Low Register; 0x0000011B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EDATALO_EDLO:       equ    0                                         ; Data bits
; bit position masks
mEDATALO_EDLO:      equ    %11111111


;*** RAMWPC - RAM Write Protection Control Register; 0x0000011C ***
RAMWPC:             equ    $0000011C                                ;*** RAMWPC - RAM Write Protection Control Register; 0x0000011C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RAMWPC_AVIF:        equ    0                                         ; CPUAccessViolationInterruptFlag
RAMWPC_AVIE:        equ    1                                         ; CPU Access Violation Interrupt Enable
RAMWPC_RWPE:        equ    7                                         ; RAM Write Protection Enable
; bit position masks
mRAMWPC_AVIF:       equ    %00000001
mRAMWPC_AVIE:       equ    %00000010
mRAMWPC_RWPE:       equ    %10000000


;*** RAMXGU - RAM XGATE Upper Boundary Register; 0x0000011D ***
RAMXGU:             equ    $0000011D                                ;*** RAMXGU - RAM XGATE Upper Boundary Register; 0x0000011D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RAMXGU_XGU0:        equ    0                                         ; XGATE Region Upper Boundary Bit 0
RAMXGU_XGU1:        equ    1                                         ; XGATE Region Upper Boundary Bit 1
RAMXGU_XGU2:        equ    2                                         ; XGATE Region Upper Boundary Bit 2
RAMXGU_XGU3:        equ    3                                         ; XGATE Region Upper Boundary Bit 3
RAMXGU_XGU4:        equ    4                                         ; XGATE Region Upper Boundary Bit 4
RAMXGU_XGU5:        equ    5                                         ; XGATE Region Upper Boundary Bit 5
RAMXGU_XGU6:        equ    6                                         ; XGATE Region Upper Boundary Bit 6
; bit position masks
mRAMXGU_XGU0:       equ    %00000001
mRAMXGU_XGU1:       equ    %00000010
mRAMXGU_XGU2:       equ    %00000100
mRAMXGU_XGU3:       equ    %00001000
mRAMXGU_XGU4:       equ    %00010000
mRAMXGU_XGU5:       equ    %00100000
mRAMXGU_XGU6:       equ    %01000000


;*** RAMSHL - RAM Shared Region Lower Boundary Register; 0x0000011E ***
RAMSHL:             equ    $0000011E                                ;*** RAMSHL - RAM Shared Region Lower Boundary Register; 0x0000011E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RAMSHL_SHL0:        equ    0                                         ; RAM Shared Region Lower Boundary Bit 0
RAMSHL_SHL1:        equ    1                                         ; RAM Shared Region Lower Boundary Bit 1
RAMSHL_SHL2:        equ    2                                         ; RAM Shared Region Lower Boundary Bit 2
RAMSHL_SHL3:        equ    3                                         ; RAM Shared Region Lower Boundary Bit 3
RAMSHL_SHL4:        equ    4                                         ; RAM Shared Region Lower Boundary Bit 4
RAMSHL_SHL5:        equ    5                                         ; RAM Shared Region Lower Boundary Bit 5
RAMSHL_SHL6:        equ    6                                         ; RAM Shared Region Lower Boundary Bit 6
; bit position masks
mRAMSHL_SHL0:       equ    %00000001
mRAMSHL_SHL1:       equ    %00000010
mRAMSHL_SHL2:       equ    %00000100
mRAMSHL_SHL3:       equ    %00001000
mRAMSHL_SHL4:       equ    %00010000
mRAMSHL_SHL5:       equ    %00100000
mRAMSHL_SHL6:       equ    %01000000


;*** RAMSHU - RAM Shared Region Upper Boundary Register; 0x0000011F ***
RAMSHU:             equ    $0000011F                                ;*** RAMSHU - RAM Shared Region Upper Boundary Register; 0x0000011F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RAMSHU_SHU0:        equ    0                                         ; RAM Shared Region Upper Boundary Bit 0
RAMSHU_SHU1:        equ    1                                         ; RAM Shared Region Upper Boundary Bit 1
RAMSHU_SHU2:        equ    2                                         ; RAM Shared Region Upper Boundary Bit 2
RAMSHU_SHU3:        equ    3                                         ; RAM Shared Region Upper Boundary Bit 3
RAMSHU_SHU4:        equ    4                                         ; RAM Shared Region Upper Boundary Bit 4
RAMSHU_SHU5:        equ    5                                         ; RAM Shared Region Upper Boundary Bit 5
RAMSHU_SHU6:        equ    6                                         ; RAM Shared Region Upper Boundary Bit 6
; bit position masks
mRAMSHU_SHU0:       equ    %00000001
mRAMSHU_SHU1:       equ    %00000010
mRAMSHU_SHU2:       equ    %00000100
mRAMSHU_SHU3:       equ    %00001000
mRAMSHU_SHU4:       equ    %00010000
mRAMSHU_SHU5:       equ    %00100000
mRAMSHU_SHU6:       equ    %01000000


;*** LCDCR0 - LCD Control Register 0; 0x00000120 ***
LCDCR0:             equ    $00000120                                ;*** LCDCR0 - LCD Control Register 0; 0x00000120 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDCR0_DUTY0:       equ    0                                         ; LCD Duty Select Bit 0
LCDCR0_DUTY1:       equ    1                                         ; LCD Duty Select Bit 1
LCDCR0_BIAS:        equ    2                                         ; BIAS Voltage Level Select
LCDCR0_LCLK0:       equ    3                                         ; LCD Clock Prescaler Bit 0
LCDCR0_LCLK1:       equ    4                                         ; LCD Clock Prescaler Bit 1
LCDCR0_LCLK2:       equ    5                                         ; LCD Clock Prescaler Bit 2
LCDCR0_LCDEN:       equ    7                                         ; LCD32F4BV1 Driver System Enable
; bit position masks
mLCDCR0_DUTY0:      equ    %00000001
mLCDCR0_DUTY1:      equ    %00000010
mLCDCR0_BIAS:       equ    %00000100
mLCDCR0_LCLK0:      equ    %00001000
mLCDCR0_LCLK1:      equ    %00010000
mLCDCR0_LCLK2:      equ    %00100000
mLCDCR0_LCDEN:      equ    %10000000


;*** LCDCR1 - LCD Control Register 1; 0x00000121 ***
LCDCR1:             equ    $00000121                                ;*** LCDCR1 - LCD Control Register 1; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDCR1_LCDRPSTP:    equ    0                                         ; LCD Run in Pseudo Stop Mode
LCDCR1_LCDSWAI:     equ    1                                         ; LCD Stop in Wait Mode
; bit position masks
mLCDCR1_LCDRPSTP:   equ    %00000001
mLCDCR1_LCDSWAI:    equ    %00000010


;*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000122 ***
FPENR0:             equ    $00000122                                ;*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000122 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR0_FP0EN:       equ    0                                         ; Frontplane Output Enable Bit 0
FPENR0_FP1EN:       equ    1                                         ; Frontplane Output Enable Bit 1
FPENR0_FP2EN:       equ    2                                         ; Frontplane Output Enable Bit 2
FPENR0_FP3EN:       equ    3                                         ; Frontplane Output Enable Bit 3
FPENR0_FP4EN:       equ    4                                         ; Frontplane Output Enable Bit 4
FPENR0_FP5EN:       equ    5                                         ; Frontplane Output Enable Bit 5
FPENR0_FP6EN:       equ    6                                         ; Frontplane Output Enable Bit 6
FPENR0_FP7EN:       equ    7                                         ; Frontplane Output Enable Bit 7
; bit position masks
mFPENR0_FP0EN:      equ    %00000001
mFPENR0_FP1EN:      equ    %00000010
mFPENR0_FP2EN:      equ    %00000100
mFPENR0_FP3EN:      equ    %00001000
mFPENR0_FP4EN:      equ    %00010000
mFPENR0_FP5EN:      equ    %00100000
mFPENR0_FP6EN:      equ    %01000000
mFPENR0_FP7EN:      equ    %10000000


;*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000123 ***
FPENR1:             equ    $00000123                                ;*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000123 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR1_FP8EN:       equ    0                                         ; Frontplane Output Enable Bit 8
FPENR1_FP9EN:       equ    1                                         ; Frontplane Output Enable Bit 9
FPENR1_FP10EN:      equ    2                                         ; Frontplane Output Enable Bit 10
FPENR1_FP11EN:      equ    3                                         ; Frontplane Output Enable Bit 11
FPENR1_FP12EN:      equ    4                                         ; Frontplane Output Enable Bit 12
FPENR1_FP13EN:      equ    5                                         ; Frontplane Output Enable Bit 13
FPENR1_FP14EN:      equ    6                                         ; Frontplane Output Enable Bit 14
FPENR1_FP15EN:      equ    7                                         ; Frontplane Output Enable Bit 15
; bit position masks
mFPENR1_FP8EN:      equ    %00000001
mFPENR1_FP9EN:      equ    %00000010
mFPENR1_FP10EN:     equ    %00000100
mFPENR1_FP11EN:     equ    %00001000
mFPENR1_FP12EN:     equ    %00010000
mFPENR1_FP13EN:     equ    %00100000
mFPENR1_FP14EN:     equ    %01000000
mFPENR1_FP15EN:     equ    %10000000


;*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000124 ***
FPENR2:             equ    $00000124                                ;*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000124 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR2_FP16EN:      equ    0                                         ; Frontplane Output Enable Bit 16
FPENR2_FP17EN:      equ    1                                         ; Frontplane Output Enable Bit 17
FPENR2_FP18EN:      equ    2                                         ; Frontplane Output Enable Bit 18
FPENR2_FP19EN:      equ    3                                         ; Frontplane Output Enable Bit 19
FPENR2_FP20EN:      equ    4                                         ; Frontplane Output Enable Bit 20
FPENR2_FP21EN:      equ    5                                         ; Frontplane Output Enable Bit 21
FPENR2_FP22EN:      equ    6                                         ; Frontplane Output Enable Bit 22
FPENR2_FP23EN:      equ    7                                         ; Frontplane Output Enable Bit 23
; bit position masks
mFPENR2_FP16EN:     equ    %00000001
mFPENR2_FP17EN:     equ    %00000010
mFPENR2_FP18EN:     equ    %00000100
mFPENR2_FP19EN:     equ    %00001000
mFPENR2_FP20EN:     equ    %00010000
mFPENR2_FP21EN:     equ    %00100000
mFPENR2_FP22EN:     equ    %01000000
mFPENR2_FP23EN:     equ    %10000000


;*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000125 ***
FPENR3:             equ    $00000125                                ;*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000125 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPENR3_FP24EN:      equ    0                                         ; Frontplane Output Enable Bit 24
FPENR3_FP25EN:      equ    1                                         ; Frontplane Output Enable Bit 25
FPENR3_FP26EN:      equ    2                                         ; Frontplane Output Enable Bit 26
FPENR3_FP27EN:      equ    3                                         ; Frontplane Output Enable Bit 27
FPENR3_FP28EN:      equ    4                                         ; Frontplane Output Enable Bit 28
FPENR3_FP29EN:      equ    5                                         ; Frontplane Output Enable Bit 29
FPENR3_FP30EN:      equ    6                                         ; Frontplane Output Enable Bit 30
FPENR3_FP31EN:      equ    7                                         ; Frontplane Output Enable Bit 31
; bit position masks
mFPENR3_FP24EN:     equ    %00000001
mFPENR3_FP25EN:     equ    %00000010
mFPENR3_FP26EN:     equ    %00000100
mFPENR3_FP27EN:     equ    %00001000
mFPENR3_FP28EN:     equ    %00010000
mFPENR3_FP29EN:     equ    %00100000
mFPENR3_FP30EN:     equ    %01000000
mFPENR3_FP31EN:     equ    %10000000


;*** LCDRAM0 - LCD RAM 0; 0x00000128 ***
LCDRAM0:            equ    $00000128                                ;*** LCDRAM0 - LCD RAM 0; 0x00000128 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM0_FP0BP0:     equ    0                                         ; LCD Segment FP0, BP0 ON
LCDRAM0_FP0BP1:     equ    1                                         ; LCD Segment FP0, BP1 ON
LCDRAM0_FP0BP2:     equ    2                                         ; LCD Segment FP0, BP2 ON
LCDRAM0_FP0BP3:     equ    3                                         ; LCD Segment FP0, BP3 ON
LCDRAM0_FP1BP0:     equ    4                                         ; LCD Segment FP1, BP0 ON
LCDRAM0_FP1BP1:     equ    5                                         ; LCD Segment FP1, BP1 ON
LCDRAM0_FP1BP2:     equ    6                                         ; LCD Segment FP1, BP2 ON
LCDRAM0_FP1BP3:     equ    7                                         ; LCD Segment FP1, BP3 ON
; bit position masks
mLCDRAM0_FP0BP0:    equ    %00000001
mLCDRAM0_FP0BP1:    equ    %00000010
mLCDRAM0_FP0BP2:    equ    %00000100
mLCDRAM0_FP0BP3:    equ    %00001000
mLCDRAM0_FP1BP0:    equ    %00010000
mLCDRAM0_FP1BP1:    equ    %00100000
mLCDRAM0_FP1BP2:    equ    %01000000
mLCDRAM0_FP1BP3:    equ    %10000000


;*** LCDRAM1 - LCD RAM 1; 0x00000129 ***
LCDRAM1:            equ    $00000129                                ;*** LCDRAM1 - LCD RAM 1; 0x00000129 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM1_FP2BP0:     equ    0                                         ; LCD Segment FP2, BP0 ON
LCDRAM1_FP2BP1:     equ    1                                         ; LCD Segment FP2, BP1 ON
LCDRAM1_FP2BP2:     equ    2                                         ; LCD Segment FP2, BP2 ON
LCDRAM1_FP2BP3:     equ    3                                         ; LCD Segment FP2, BP3 ON
LCDRAM1_FP3BP0:     equ    4                                         ; LCD Segment FP3, BP0 ON
LCDRAM1_FP3BP1:     equ    5                                         ; LCD Segment FP3, BP1 ON
LCDRAM1_FP3BP2:     equ    6                                         ; LCD Segment FP3, BP2 ON
LCDRAM1_FP3BP3:     equ    7                                         ; LCD Segment FP3, BP3 ON
; bit position masks
mLCDRAM1_FP2BP0:    equ    %00000001
mLCDRAM1_FP2BP1:    equ    %00000010
mLCDRAM1_FP2BP2:    equ    %00000100
mLCDRAM1_FP2BP3:    equ    %00001000
mLCDRAM1_FP3BP0:    equ    %00010000
mLCDRAM1_FP3BP1:    equ    %00100000
mLCDRAM1_FP3BP2:    equ    %01000000
mLCDRAM1_FP3BP3:    equ    %10000000


;*** LCDRAM2 - LCD RAM 2; 0x0000012A ***
LCDRAM2:            equ    $0000012A                                ;*** LCDRAM2 - LCD RAM 2; 0x0000012A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM2_FP4BP0:     equ    0                                         ; LCD Segment FP4, BP0 ON
LCDRAM2_FP4BP1:     equ    1                                         ; LCD Segment FP4, BP1 ON
LCDRAM2_FP4BP2:     equ    2                                         ; LCD Segment FP4, BP2 ON
LCDRAM2_FP4BP3:     equ    3                                         ; LCD Segment FP4, BP3 ON
LCDRAM2_FP5BP0:     equ    4                                         ; LCD Segment FP5, BP0 ON
LCDRAM2_FP5BP1:     equ    5                                         ; LCD Segment FP5, BP1 ON
LCDRAM2_FP5BP2:     equ    6                                         ; LCD Segment FP5, BP2 ON
LCDRAM2_FP5BP3:     equ    7                                         ; LCD Segment FP5, BP3 ON
; bit position masks
mLCDRAM2_FP4BP0:    equ    %00000001
mLCDRAM2_FP4BP1:    equ    %00000010
mLCDRAM2_FP4BP2:    equ    %00000100
mLCDRAM2_FP4BP3:    equ    %00001000
mLCDRAM2_FP5BP0:    equ    %00010000
mLCDRAM2_FP5BP1:    equ    %00100000
mLCDRAM2_FP5BP2:    equ    %01000000
mLCDRAM2_FP5BP3:    equ    %10000000


;*** LCDRAM3 - LCD RAM 3; 0x0000012B ***
LCDRAM3:            equ    $0000012B                                ;*** LCDRAM3 - LCD RAM 3; 0x0000012B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM3_FP6BP0:     equ    0                                         ; LCD Segment FP6, BP0 ON
LCDRAM3_FP6BP1:     equ    1                                         ; LCD Segment FP6, BP1 ON
LCDRAM3_FP6BP2:     equ    2                                         ; LCD Segment FP6, BP2 ON
LCDRAM3_FP6BP3:     equ    3                                         ; LCD Segment FP6, BP3 ON
LCDRAM3_FP7BP0:     equ    4                                         ; LCD Segment FP7, BP0 ON
LCDRAM3_FP7BP1:     equ    5                                         ; LCD Segment FP7, BP1 ON
LCDRAM3_FP7BP2:     equ    6                                         ; LCD Segment FP7, BP2 ON
LCDRAM3_FP7BP3:     equ    7                                         ; LCD Segment FP7, BP3 ON
; bit position masks
mLCDRAM3_FP6BP0:    equ    %00000001
mLCDRAM3_FP6BP1:    equ    %00000010
mLCDRAM3_FP6BP2:    equ    %00000100
mLCDRAM3_FP6BP3:    equ    %00001000
mLCDRAM3_FP7BP0:    equ    %00010000
mLCDRAM3_FP7BP1:    equ    %00100000
mLCDRAM3_FP7BP2:    equ    %01000000
mLCDRAM3_FP7BP3:    equ    %10000000


;*** LCDRAM4 - LCD RAM 4; 0x0000012C ***
LCDRAM4:            equ    $0000012C                                ;*** LCDRAM4 - LCD RAM 4; 0x0000012C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM4_FP8BP0:     equ    0                                         ; LCD Segment FP8, BP0 ON
LCDRAM4_FP8BP1:     equ    1                                         ; LCD Segment FP8, BP1 ON
LCDRAM4_FP8BP2:     equ    2                                         ; LCD Segment FP8, BP2 ON
LCDRAM4_FP8BP3:     equ    3                                         ; LCD Segment FP8, BP3 ON
LCDRAM4_FP9BP0:     equ    4                                         ; LCD Segment FP9, BP0 ON
LCDRAM4_FP9BP1:     equ    5                                         ; LCD Segment FP9, BP1 ON
LCDRAM4_FP9BP2:     equ    6                                         ; LCD Segment FP9, BP2 ON
LCDRAM4_FP9BP3:     equ    7                                         ; LCD Segment FP9, BP3 ON
; bit position masks
mLCDRAM4_FP8BP0:    equ    %00000001
mLCDRAM4_FP8BP1:    equ    %00000010
mLCDRAM4_FP8BP2:    equ    %00000100
mLCDRAM4_FP8BP3:    equ    %00001000
mLCDRAM4_FP9BP0:    equ    %00010000
mLCDRAM4_FP9BP1:    equ    %00100000
mLCDRAM4_FP9BP2:    equ    %01000000
mLCDRAM4_FP9BP3:    equ    %10000000


;*** LCDRAM5 - LCD RAM 5; 0x0000012D ***
LCDRAM5:            equ    $0000012D                                ;*** LCDRAM5 - LCD RAM 5; 0x0000012D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM5_FP10BP0:    equ    0                                         ; LCD Segment FP10, BP0 ON
LCDRAM5_FP10BP1:    equ    1                                         ; LCD Segment FP10, BP1 ON
LCDRAM5_FP10BP2:    equ    2                                         ; LCD Segment FP10, BP2 ON
LCDRAM5_FP10BP3:    equ    3                                         ; LCD Segment FP10, BP3 ON
LCDRAM5_FP11BP0:    equ    4                                         ; LCD Segment FP11, BP0 ON
LCDRAM5_FP11BP1:    equ    5                                         ; LCD Segment FP11, BP1 ON
LCDRAM5_FP11BP2:    equ    6                                         ; LCD Segment FP11, BP2 ON
LCDRAM5_FP11BP3:    equ    7                                         ; LCD Segment FP11, BP3 ON
; bit position masks
mLCDRAM5_FP10BP0:   equ    %00000001
mLCDRAM5_FP10BP1:   equ    %00000010
mLCDRAM5_FP10BP2:   equ    %00000100
mLCDRAM5_FP10BP3:   equ    %00001000
mLCDRAM5_FP11BP0:   equ    %00010000
mLCDRAM5_FP11BP1:   equ    %00100000
mLCDRAM5_FP11BP2:   equ    %01000000
mLCDRAM5_FP11BP3:   equ    %10000000


;*** LCDRAM6 - LCD RAM 6; 0x0000012E ***
LCDRAM6:            equ    $0000012E                                ;*** LCDRAM6 - LCD RAM 6; 0x0000012E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM6_FP12BP0:    equ    0                                         ; LCD Segment FP12, BP0 ON
LCDRAM6_FP12BP1:    equ    1                                         ; LCD Segment FP12, BP1 ON
LCDRAM6_FP12BP2:    equ    2                                         ; LCD Segment FP12, BP2 ON
LCDRAM6_FP12BP3:    equ    3                                         ; LCD Segment FP12, BP3 ON
LCDRAM6_FP13BP0:    equ    4                                         ; LCD Segment FP13, BP0 ON
LCDRAM6_FP13BP1:    equ    5                                         ; LCD Segment FP13, BP1 ON
LCDRAM6_FP13BP2:    equ    6                                         ; LCD Segment FP13, BP2 ON
LCDRAM6_FP13BP3:    equ    7                                         ; LCD Segment FP13, BP3 ON
; bit position masks
mLCDRAM6_FP12BP0:   equ    %00000001
mLCDRAM6_FP12BP1:   equ    %00000010
mLCDRAM6_FP12BP2:   equ    %00000100
mLCDRAM6_FP12BP3:   equ    %00001000
mLCDRAM6_FP13BP0:   equ    %00010000
mLCDRAM6_FP13BP1:   equ    %00100000
mLCDRAM6_FP13BP2:   equ    %01000000
mLCDRAM6_FP13BP3:   equ    %10000000


;*** LCDRAM7 - LCD RAM 7; 0x0000012F ***
LCDRAM7:            equ    $0000012F                                ;*** LCDRAM7 - LCD RAM 7; 0x0000012F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM7_FP14BP0:    equ    0                                         ; LCD Segment FP14, BP0 ON
LCDRAM7_FP14BP1:    equ    1                                         ; LCD Segment FP14, BP1 ON
LCDRAM7_FP14BP2:    equ    2                                         ; LCD Segment FP14, BP2 ON
LCDRAM7_FP14BP3:    equ    3                                         ; LCD Segment FP14, BP3 ON
LCDRAM7_FP15BP0:    equ    4                                         ; LCD Segment FP15, BP0 ON
LCDRAM7_FP15BP1:    equ    5                                         ; LCD Segment FP15, BP1 ON
LCDRAM7_FP15BP2:    equ    6                                         ; LCD Segment FP15, BP2 ON
LCDRAM7_FP15BP3:    equ    7                                         ; LCD Segment FP15, BP3 ON
; bit position masks
mLCDRAM7_FP14BP0:   equ    %00000001
mLCDRAM7_FP14BP1:   equ    %00000010
mLCDRAM7_FP14BP2:   equ    %00000100
mLCDRAM7_FP14BP3:   equ    %00001000
mLCDRAM7_FP15BP0:   equ    %00010000
mLCDRAM7_FP15BP1:   equ    %00100000
mLCDRAM7_FP15BP2:   equ    %01000000
mLCDRAM7_FP15BP3:   equ    %10000000


;*** LCDRAM8 - LCD RAM 8; 0x00000130 ***
LCDRAM8:            equ    $00000130                                ;*** LCDRAM8 - LCD RAM 8; 0x00000130 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM8_FP16BP0:    equ    0                                         ; LCD Segment FP16, BP0 ON
LCDRAM8_FP16BP1:    equ    1                                         ; LCD Segment FP16, BP1 ON
LCDRAM8_FP16BP2:    equ    2                                         ; LCD Segment FP16, BP2 ON
LCDRAM8_FP16BP3:    equ    3                                         ; LCD Segment FP16, BP3 ON
LCDRAM8_FP17BP0:    equ    4                                         ; LCD Segment FP17, BP0 ON
LCDRAM8_FP17BP1:    equ    5                                         ; LCD Segment FP17, BP1 ON
LCDRAM8_FP17BP2:    equ    6                                         ; LCD Segment FP17, BP2 ON
LCDRAM8_FP17BP3:    equ    7                                         ; LCD Segment FP17, BP3 ON
; bit position masks
mLCDRAM8_FP16BP0:   equ    %00000001
mLCDRAM8_FP16BP1:   equ    %00000010
mLCDRAM8_FP16BP2:   equ    %00000100
mLCDRAM8_FP16BP3:   equ    %00001000
mLCDRAM8_FP17BP0:   equ    %00010000
mLCDRAM8_FP17BP1:   equ    %00100000
mLCDRAM8_FP17BP2:   equ    %01000000
mLCDRAM8_FP17BP3:   equ    %10000000


;*** LCDRAM9 - LCD RAM 9; 0x00000131 ***
LCDRAM9:            equ    $00000131                                ;*** LCDRAM9 - LCD RAM 9; 0x00000131 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM9_FP18BP0:    equ    0                                         ; LCD Segment FP18, BP0 ON
LCDRAM9_FP18BP1:    equ    1                                         ; LCD Segment FP18, BP1 ON
LCDRAM9_FP18BP2:    equ    2                                         ; LCD Segment FP18, BP2 ON
LCDRAM9_FP18BP3:    equ    3                                         ; LCD Segment FP18, BP3 ON
LCDRAM9_FP19BP0:    equ    4                                         ; LCD Segment FP19, BP0 ON
LCDRAM9_FP19BP1:    equ    5                                         ; LCD Segment FP19, BP1 ON
LCDRAM9_FP19BP2:    equ    6                                         ; LCD Segment FP19, BP2 ON
LCDRAM9_FP19BP3:    equ    7                                         ; LCD Segment FP19, BP3 ON
; bit position masks
mLCDRAM9_FP18BP0:   equ    %00000001
mLCDRAM9_FP18BP1:   equ    %00000010
mLCDRAM9_FP18BP2:   equ    %00000100
mLCDRAM9_FP18BP3:   equ    %00001000
mLCDRAM9_FP19BP0:   equ    %00010000
mLCDRAM9_FP19BP1:   equ    %00100000
mLCDRAM9_FP19BP2:   equ    %01000000
mLCDRAM9_FP19BP3:   equ    %10000000


;*** LCDRAM10 - LCD RAM 10; 0x00000132 ***
LCDRAM10:           equ    $00000132                                ;*** LCDRAM10 - LCD RAM 10; 0x00000132 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM10_FP20BP0:   equ    0                                         ; LCD Segment FP20, BP0 ON
LCDRAM10_FP20BP1:   equ    1                                         ; LCD Segment FP20, BP1 ON
LCDRAM10_FP20BP2:   equ    2                                         ; LCD Segment FP20, BP2 ON
LCDRAM10_FP20BP3:   equ    3                                         ; LCD Segment FP20, BP3 ON
LCDRAM10_FP21BP0:   equ    4                                         ; LCD Segment FP21, BP0 ON
LCDRAM10_FP21BP1:   equ    5                                         ; LCD Segment FP21, BP1 ON
LCDRAM10_FP21BP2:   equ    6                                         ; LCD Segment FP21, BP2 ON
LCDRAM10_FP21BP3:   equ    7                                         ; LCD Segment FP21, BP3 ON
; bit position masks
mLCDRAM10_FP20BP0:  equ    %00000001
mLCDRAM10_FP20BP1:  equ    %00000010
mLCDRAM10_FP20BP2:  equ    %00000100
mLCDRAM10_FP20BP3:  equ    %00001000
mLCDRAM10_FP21BP0:  equ    %00010000
mLCDRAM10_FP21BP1:  equ    %00100000
mLCDRAM10_FP21BP2:  equ    %01000000
mLCDRAM10_FP21BP3:  equ    %10000000


;*** LCDRAM11 - LCD RAM 11; 0x00000133 ***
LCDRAM11:           equ    $00000133                                ;*** LCDRAM11 - LCD RAM 11; 0x00000133 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM11_FP22BP0:   equ    0                                         ; LCD Segment FP22, BP0 ON
LCDRAM11_FP22BP1:   equ    1                                         ; LCD Segment FP22, BP1 ON
LCDRAM11_FP22BP2:   equ    2                                         ; LCD Segment FP22, BP2 ON
LCDRAM11_FP22BP3:   equ    3                                         ; LCD Segment FP22, BP3 ON
LCDRAM11_FP23BP0:   equ    4                                         ; LCD Segment FP23, BP0 ON
LCDRAM11_FP23BP1:   equ    5                                         ; LCD Segment FP23, BP1 ON
LCDRAM11_FP23BP2:   equ    6                                         ; LCD Segment FP23, BP2 ON
LCDRAM11_FP23BP3:   equ    7                                         ; LCD Segment FP23, BP3 ON
; bit position masks
mLCDRAM11_FP22BP0:  equ    %00000001
mLCDRAM11_FP22BP1:  equ    %00000010
mLCDRAM11_FP22BP2:  equ    %00000100
mLCDRAM11_FP22BP3:  equ    %00001000
mLCDRAM11_FP23BP0:  equ    %00010000
mLCDRAM11_FP23BP1:  equ    %00100000
mLCDRAM11_FP23BP2:  equ    %01000000
mLCDRAM11_FP23BP3:  equ    %10000000


;*** LCDRAM12 - LCD RAM 12; 0x00000134 ***
LCDRAM12:           equ    $00000134                                ;*** LCDRAM12 - LCD RAM 12; 0x00000134 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM12_FP24BP0:   equ    0                                         ; LCD Segment FP24, BP0 ON
LCDRAM12_FP24BP1:   equ    1                                         ; LCD Segment FP24, BP1 ON
LCDRAM12_FP24BP2:   equ    2                                         ; LCD Segment FP24, BP2 ON
LCDRAM12_FP24BP3:   equ    3                                         ; LCD Segment FP24, BP3 ON
LCDRAM12_FP25BP0:   equ    4                                         ; LCD Segment FP25, BP0 ON
LCDRAM12_FP25BP1:   equ    5                                         ; LCD Segment FP25, BP1 ON
LCDRAM12_FP25BP2:   equ    6                                         ; LCD Segment FP25, BP2 ON
LCDRAM12_FP25BP3:   equ    7                                         ; LCD Segment FP25, BP3 ON
; bit position masks
mLCDRAM12_FP24BP0:  equ    %00000001
mLCDRAM12_FP24BP1:  equ    %00000010
mLCDRAM12_FP24BP2:  equ    %00000100
mLCDRAM12_FP24BP3:  equ    %00001000
mLCDRAM12_FP25BP0:  equ    %00010000
mLCDRAM12_FP25BP1:  equ    %00100000
mLCDRAM12_FP25BP2:  equ    %01000000
mLCDRAM12_FP25BP3:  equ    %10000000


;*** LCDRAM13 - LCD RAM 13; 0x00000135 ***
LCDRAM13:           equ    $00000135                                ;*** LCDRAM13 - LCD RAM 13; 0x00000135 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM13_FP26BP0:   equ    0                                         ; LCD Segment FP26, BP0 ON
LCDRAM13_FP26BP1:   equ    1                                         ; LCD Segment FP26, BP1 ON
LCDRAM13_FP26BP2:   equ    2                                         ; LCD Segment FP26, BP2 ON
LCDRAM13_FP26BP3:   equ    3                                         ; LCD Segment FP26, BP3 ON
LCDRAM13_FP27BP0:   equ    4                                         ; LCD Segment FP27, BP0 ON
LCDRAM13_FP27BP1:   equ    5                                         ; LCD Segment FP27, BP1 ON
LCDRAM13_FP27BP2:   equ    6                                         ; LCD Segment FP27, BP2 ON
LCDRAM13_FP27BP3:   equ    7                                         ; LCD Segment FP27, BP3 ON
; bit position masks
mLCDRAM13_FP26BP0:  equ    %00000001
mLCDRAM13_FP26BP1:  equ    %00000010
mLCDRAM13_FP26BP2:  equ    %00000100
mLCDRAM13_FP26BP3:  equ    %00001000
mLCDRAM13_FP27BP0:  equ    %00010000
mLCDRAM13_FP27BP1:  equ    %00100000
mLCDRAM13_FP27BP2:  equ    %01000000
mLCDRAM13_FP27BP3:  equ    %10000000


;*** LCDRAM14 - LCD RAM 14; 0x00000136 ***
LCDRAM14:           equ    $00000136                                ;*** LCDRAM14 - LCD RAM 14; 0x00000136 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM14_FP28BP0:   equ    0                                         ; LCD Segment FP28, BP0 ON
LCDRAM14_FP28BP1:   equ    1                                         ; LCD Segment FP28, BP1 ON
LCDRAM14_FP28BP2:   equ    2                                         ; LCD Segment FP28, BP2 ON
LCDRAM14_FP28BP3:   equ    3                                         ; LCD Segment FP28, BP3 ON
LCDRAM14_FP29BP0:   equ    4                                         ; LCD Segment FP29, BP0 ON
LCDRAM14_FP29BP1:   equ    5                                         ; LCD Segment FP29, BP1 ON
LCDRAM14_FP29BP2:   equ    6                                         ; LCD Segment FP29, BP2 ON
LCDRAM14_FP29BP3:   equ    7                                         ; LCD Segment FP29, BP3 ON
; bit position masks
mLCDRAM14_FP28BP0:  equ    %00000001
mLCDRAM14_FP28BP1:  equ    %00000010
mLCDRAM14_FP28BP2:  equ    %00000100
mLCDRAM14_FP28BP3:  equ    %00001000
mLCDRAM14_FP29BP0:  equ    %00010000
mLCDRAM14_FP29BP1:  equ    %00100000
mLCDRAM14_FP29BP2:  equ    %01000000
mLCDRAM14_FP29BP3:  equ    %10000000


;*** LCDRAM15 - LCD RAM 15; 0x00000137 ***
LCDRAM15:           equ    $00000137                                ;*** LCDRAM15 - LCD RAM 15; 0x00000137 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRAM15_FP30BP0:   equ    0                                         ; LCD Segment FP30, BP0 ON
LCDRAM15_FP30BP1:   equ    1                                         ; LCD Segment FP30, BP1 ON
LCDRAM15_FP30BP2:   equ    2                                         ; LCD Segment FP30, BP2 ON
LCDRAM15_FP30BP3:   equ    3                                         ; LCD Segment FP30, BP3 ON
LCDRAM15_FP31BP0:   equ    4                                         ; LCD Segment FP31, BP0 ON
LCDRAM15_FP31BP1:   equ    5                                         ; LCD Segment FP31, BP1 ON
LCDRAM15_FP31BP2:   equ    6                                         ; LCD Segment FP31, BP2 ON
LCDRAM15_FP31BP3:   equ    7                                         ; LCD Segment FP31, BP3 ON
; bit position masks
mLCDRAM15_FP30BP0:  equ    %00000001
mLCDRAM15_FP30BP1:  equ    %00000010
mLCDRAM15_FP30BP2:  equ    %00000100
mLCDRAM15_FP30BP3:  equ    %00001000
mLCDRAM15_FP31BP0:  equ    %00010000
mLCDRAM15_FP31BP1:  equ    %00100000
mLCDRAM15_FP31BP2:  equ    %01000000
mLCDRAM15_FP31BP3:  equ    %10000000


;*** IIC1_IBAD - IIC Address Register; 0x00000138 ***
IIC1_IBAD:          equ    $00000138                                ;*** IIC1_IBAD - IIC Address Register; 0x00000138 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC1_IBAD_ADR1:     equ    1                                         ; Slave Address Bit 1
IIC1_IBAD_ADR2:     equ    2                                         ; Slave Address Bit 2
IIC1_IBAD_ADR3:     equ    3                                         ; Slave Address Bit 3
IIC1_IBAD_ADR4:     equ    4                                         ; Slave Address Bit 4
IIC1_IBAD_ADR5:     equ    5                                         ; Slave Address Bit 5
IIC1_IBAD_ADR6:     equ    6                                         ; Slave Address Bit 6
IIC1_IBAD_ADR7:     equ    7                                         ; Slave Address Bit 7
; bit position masks
mIIC1_IBAD_ADR1:    equ    %00000010
mIIC1_IBAD_ADR2:    equ    %00000100
mIIC1_IBAD_ADR3:    equ    %00001000
mIIC1_IBAD_ADR4:    equ    %00010000
mIIC1_IBAD_ADR5:    equ    %00100000
mIIC1_IBAD_ADR6:    equ    %01000000
mIIC1_IBAD_ADR7:    equ    %10000000


;*** IIC1_IBFD - IIC Frequency Divider Register; 0x00000139 ***
IIC1_IBFD:          equ    $00000139                                ;*** IIC1_IBFD - IIC Frequency Divider Register; 0x00000139 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC1_IBFD_IBC0:     equ    0                                         ; I-Bus Clock Rate 0
IIC1_IBFD_IBC1:     equ    1                                         ; I-Bus Clock Rate 1
IIC1_IBFD_IBC2:     equ    2                                         ; I-Bus Clock Rate 2
IIC1_IBFD_IBC3:     equ    3                                         ; I-Bus Clock Rate 3
IIC1_IBFD_IBC4:     equ    4                                         ; I-Bus Clock Rate 4
IIC1_IBFD_IBC5:     equ    5                                         ; I-Bus Clock Rate 5
IIC1_IBFD_IBC6:     equ    6                                         ; I-Bus Clock Rate 6
IIC1_IBFD_IBC7:     equ    7                                         ; I-Bus Clock Rate 7
; bit position masks
mIIC1_IBFD_IBC0:    equ    %00000001
mIIC1_IBFD_IBC1:    equ    %00000010
mIIC1_IBFD_IBC2:    equ    %00000100
mIIC1_IBFD_IBC3:    equ    %00001000
mIIC1_IBFD_IBC4:    equ    %00010000
mIIC1_IBFD_IBC5:    equ    %00100000
mIIC1_IBFD_IBC6:    equ    %01000000
mIIC1_IBFD_IBC7:    equ    %10000000


;*** IIC1_IBCR - IIC Control Register; 0x0000013A ***
IIC1_IBCR:          equ    $0000013A                                ;*** IIC1_IBCR - IIC Control Register; 0x0000013A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC1_IBCR_IBSWAI:   equ    0                                         ; I-Bus Interface Stop in WAIT mode
IIC1_IBCR_RSTA:     equ    2                                         ; Repeat Start
IIC1_IBCR_TXAK:     equ    3                                         ; Transmit Acknowledge enable
IIC1_IBCR_TX_RX:    equ    4                                         ; Transmit/Receive mode select bit
IIC1_IBCR_MS_SL:    equ    5                                         ; Master/Slave mode select bit
IIC1_IBCR_IBIE:     equ    6                                         ; I-Bus Interrupt Enable
IIC1_IBCR_IBEN:     equ    7                                         ; I-Bus Enable
; bit position masks
mIIC1_IBCR_IBSWAI:  equ    %00000001
mIIC1_IBCR_RSTA:    equ    %00000100
mIIC1_IBCR_TXAK:    equ    %00001000
mIIC1_IBCR_TX_RX:   equ    %00010000
mIIC1_IBCR_MS_SL:   equ    %00100000
mIIC1_IBCR_IBIE:    equ    %01000000
mIIC1_IBCR_IBEN:    equ    %10000000


;*** IIC1_IBSR - IIC Status Register; 0x0000013B ***
IIC1_IBSR:          equ    $0000013B                                ;*** IIC1_IBSR - IIC Status Register; 0x0000013B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC1_IBSR_RXAK:     equ    0                                         ; Received Acknowledge
IIC1_IBSR_IBIF:     equ    1                                         ; I-Bus Interrupt
IIC1_IBSR_SRW:      equ    2                                         ; Slave Read/Write
IIC1_IBSR_IBAL:     equ    4                                         ; Arbitration Lost
IIC1_IBSR_IBB:      equ    5                                         ; Bus busy bit
IIC1_IBSR_IAAS:     equ    6                                         ; Addressed as a slave bit
IIC1_IBSR_TCF:      equ    7                                         ; Data transferring bit
; bit position masks
mIIC1_IBSR_RXAK:    equ    %00000001
mIIC1_IBSR_IBIF:    equ    %00000010
mIIC1_IBSR_SRW:     equ    %00000100
mIIC1_IBSR_IBAL:    equ    %00010000
mIIC1_IBSR_IBB:     equ    %00100000
mIIC1_IBSR_IAAS:    equ    %01000000
mIIC1_IBSR_TCF:     equ    %10000000


;*** IIC1_IBDR - IIC Data I/O Register; 0x0000013C ***
IIC1_IBDR:          equ    $0000013C                                ;*** IIC1_IBDR - IIC Data I/O Register; 0x0000013C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC1_IBDR_D0:       equ    0                                         ; IIC Data Bit 0
IIC1_IBDR_D1:       equ    1                                         ; IIC Data Bit 1
IIC1_IBDR_D2:       equ    2                                         ; IIC Data Bit 2
IIC1_IBDR_D3:       equ    3                                         ; IIC Data Bit 3
IIC1_IBDR_D4:       equ    4                                         ; IIC Data Bit 4
IIC1_IBDR_D5:       equ    5                                         ; IIC Data Bit 5
IIC1_IBDR_D6:       equ    6                                         ; IIC Data Bit 6
IIC1_IBDR_D7:       equ    7                                         ; IIC Data Bit 7
; bit position masks
mIIC1_IBDR_D0:      equ    %00000001
mIIC1_IBDR_D1:      equ    %00000010
mIIC1_IBDR_D2:      equ    %00000100
mIIC1_IBDR_D3:      equ    %00001000
mIIC1_IBDR_D4:      equ    %00010000
mIIC1_IBDR_D5:      equ    %00100000
mIIC1_IBDR_D6:      equ    %01000000
mIIC1_IBDR_D7:      equ    %10000000


;*** IIC1_IBCR2 - IIC Control Register 2; 0x0000013D ***
IIC1_IBCR2:         equ    $0000013D                                ;*** IIC1_IBCR2 - IIC Control Register 2; 0x0000013D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC1_IBCR2_ADR8:    equ    0                                         ; Slave Address Bit 8
IIC1_IBCR2_ADR9:    equ    1                                         ; Slave Address Bit 9
IIC1_IBCR2_ADR10:   equ    2                                         ; Slave Address Bit 10
IIC1_IBCR2_ADTYPE:  equ    6                                         ; Address Type
IIC1_IBCR2_GCEN:    equ    7                                         ; General Call Enable
; bit position masks
mIIC1_IBCR2_ADR8:   equ    %00000001
mIIC1_IBCR2_ADR9:   equ    %00000010
mIIC1_IBCR2_ADR10:  equ    %00000100
mIIC1_IBCR2_ADTYPE: equ    %01000000
mIIC1_IBCR2_GCEN:   equ    %10000000


;*** CAN0CTL0 - MSCAN0 Control 0 Register; 0x00000140 ***
CAN0CTL0:           equ    $00000140                                ;*** CAN0CTL0 - MSCAN0 Control 0 Register; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN0CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN0CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN0CTL0_TIME:      equ    3                                         ; Timer Enable
CAN0CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN0CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN0CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN0CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN0CTL0_INITRQ:   equ    %00000001
mCAN0CTL0_SLPRQ:    equ    %00000010
mCAN0CTL0_WUPE:     equ    %00000100
mCAN0CTL0_TIME:     equ    %00001000
mCAN0CTL0_SYNCH:    equ    %00010000
mCAN0CTL0_CSWAI:    equ    %00100000
mCAN0CTL0_RXACT:    equ    %01000000
mCAN0CTL0_RXFRM:    equ    %10000000


;*** CAN0CTL1 - MSCAN0 Control 1 Register; 0x00000141 ***
CAN0CTL1:           equ    $00000141                                ;*** CAN0CTL1 - MSCAN0 Control 1 Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN0CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN0CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN0CTL1_BORM:      equ    3                                         ; Bus-Off Recovery Mode
CAN0CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN0CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN0CTL1_CLKSRC:    equ    6                                         ; MSCAN Clock Source
CAN0CTL1_CANE:      equ    7                                         ; MSCAN Enable
; bit position masks
mCAN0CTL1_INITAK:   equ    %00000001
mCAN0CTL1_SLPAK:    equ    %00000010
mCAN0CTL1_WUPM:     equ    %00000100
mCAN0CTL1_BORM:     equ    %00001000
mCAN0CTL1_LISTEN:   equ    %00010000
mCAN0CTL1_LOOPB:    equ    %00100000
mCAN0CTL1_CLKSRC:   equ    %01000000
mCAN0CTL1_CANE:     equ    %10000000


;*** CAN0BTR0 - MSCAN0 Bus Timing Register 0; 0x00000142 ***
CAN0BTR0:           equ    $00000142                                ;*** CAN0BTR0 - MSCAN0 Bus Timing Register 0; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN0BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN0BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN0BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN0BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN0BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN0BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN0BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN0BTR0_BRP0:     equ    %00000001
mCAN0BTR0_BRP1:     equ    %00000010
mCAN0BTR0_BRP2:     equ    %00000100
mCAN0BTR0_BRP3:     equ    %00001000
mCAN0BTR0_BRP4:     equ    %00010000
mCAN0BTR0_BRP5:     equ    %00100000
mCAN0BTR0_SJW0:     equ    %01000000
mCAN0BTR0_SJW1:     equ    %10000000


;*** CAN0BTR1 - MSCAN0 Bus Timing Register 1; 0x00000143 ***
CAN0BTR1:           equ    $00000143                                ;*** CAN0BTR1 - MSCAN0 Bus Timing Register 1; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN0BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN0BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN0BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN0BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN0BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN0BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN0BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN0BTR1_TSEG10:   equ    %00000001
mCAN0BTR1_TSEG11:   equ    %00000010
mCAN0BTR1_TSEG12:   equ    %00000100
mCAN0BTR1_TSEG13:   equ    %00001000
mCAN0BTR1_TSEG20:   equ    %00010000
mCAN0BTR1_TSEG21:   equ    %00100000
mCAN0BTR1_TSEG22:   equ    %01000000
mCAN0BTR1_SAMP:     equ    %10000000


;*** CAN0RFLG - MSCAN0 Receiver Flag Register; 0x00000144 ***
CAN0RFLG:           equ    $00000144                                ;*** CAN0RFLG - MSCAN0 Receiver Flag Register; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN0RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN0RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN0RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN0RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN0RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN0RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN0RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN0RFLG_RXF:      equ    %00000001
mCAN0RFLG_OVRIF:    equ    %00000010
mCAN0RFLG_TSTAT0:   equ    %00000100
mCAN0RFLG_TSTAT1:   equ    %00001000
mCAN0RFLG_RSTAT0:   equ    %00010000
mCAN0RFLG_RSTAT1:   equ    %00100000
mCAN0RFLG_CSCIF:    equ    %01000000
mCAN0RFLG_WUPIF:    equ    %10000000


;*** CAN0RIER - MSCAN0 Receiver Interrupt Enable Register; 0x00000145 ***
CAN0RIER:           equ    $00000145                                ;*** CAN0RIER - MSCAN0 Receiver Interrupt Enable Register; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN0RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN0RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN0RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN0RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN0RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN0RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN0RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN0RIER_RXFIE:    equ    %00000001
mCAN0RIER_OVRIE:    equ    %00000010
mCAN0RIER_TSTATE0:  equ    %00000100
mCAN0RIER_TSTATE1:  equ    %00001000
mCAN0RIER_RSTATE0:  equ    %00010000
mCAN0RIER_RSTATE1:  equ    %00100000
mCAN0RIER_CSCIE:    equ    %01000000
mCAN0RIER_WUPIE:    equ    %10000000


;*** CAN0TFLG - MSCAN0 Transmitter Flag Register; 0x00000146 ***
CAN0TFLG:           equ    $00000146                                ;*** CAN0TFLG - MSCAN0 Transmitter Flag Register; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN0TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN0TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN0TFLG_TXE0:     equ    %00000001
mCAN0TFLG_TXE1:     equ    %00000010
mCAN0TFLG_TXE2:     equ    %00000100


;*** CAN0TIER - MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 ***
CAN0TIER:           equ    $00000147                                ;*** CAN0TIER - MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN0TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN0TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN0TIER_TXEIE0:   equ    %00000001
mCAN0TIER_TXEIE1:   equ    %00000010
mCAN0TIER_TXEIE2:   equ    %00000100


;*** CAN0TARQ - MSCAN0 Transmitter Message Abort Request; 0x00000148 ***
CAN0TARQ:           equ    $00000148                                ;*** CAN0TARQ - MSCAN0 Transmitter Message Abort Request; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN0TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN0TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN0TARQ_ABTRQ0:   equ    %00000001
mCAN0TARQ_ABTRQ1:   equ    %00000010
mCAN0TARQ_ABTRQ2:   equ    %00000100


;*** CAN0TAAK - MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 ***
CAN0TAAK:           equ    $00000149                                ;*** CAN0TAAK - MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN0TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN0TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN0TAAK_ABTAK0:   equ    %00000001
mCAN0TAAK_ABTAK1:   equ    %00000010
mCAN0TAAK_ABTAK2:   equ    %00000100


;*** CAN0TBSEL - MSCAN0 Transmit Buffer Selection; 0x0000014A ***
CAN0TBSEL:          equ    $0000014A                                ;*** CAN0TBSEL - MSCAN0 Transmit Buffer Selection; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN0TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN0TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN0TBSEL_TX0:     equ    %00000001
mCAN0TBSEL_TX1:     equ    %00000010
mCAN0TBSEL_TX2:     equ    %00000100


;*** CAN0IDAC - MSCAN0 Identifier Acceptance Control Register; 0x0000014B ***
CAN0IDAC:           equ    $0000014B                                ;*** CAN0IDAC - MSCAN0 Identifier Acceptance Control Register; 0x0000014B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN0IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN0IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN0IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN0IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN0IDAC_IDHIT0:   equ    %00000001
mCAN0IDAC_IDHIT1:   equ    %00000010
mCAN0IDAC_IDHIT2:   equ    %00000100
mCAN0IDAC_IDAM0:    equ    %00010000
mCAN0IDAC_IDAM1:    equ    %00100000


;*** CAN0MISC - MSCAN0 Miscellaneous Register; 0x0000014D ***
CAN0MISC:           equ    $0000014D                                ;*** CAN0MISC - MSCAN0 Miscellaneous Register; 0x0000014D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0MISC_BOHOLD:    equ    0                                         ; Bus-off State Hold Until User Request
; bit position masks
mCAN0MISC_BOHOLD:   equ    %00000001


;*** CAN0RXERR - MSCAN0 Receive Error Counter Register; 0x0000014E ***
CAN0RXERR:          equ    $0000014E                                ;*** CAN0RXERR - MSCAN0 Receive Error Counter Register; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN0RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN0RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN0RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN0RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN0RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN0RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN0RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0RXERR_RXERR0:  equ    %00000001
mCAN0RXERR_RXERR1:  equ    %00000010
mCAN0RXERR_RXERR2:  equ    %00000100
mCAN0RXERR_RXERR3:  equ    %00001000
mCAN0RXERR_RXERR4:  equ    %00010000
mCAN0RXERR_RXERR5:  equ    %00100000
mCAN0RXERR_RXERR6:  equ    %01000000
mCAN0RXERR_RXERR7:  equ    %10000000


;*** CAN0TXERR - MSCAN0 Transmit Error Counter Register; 0x0000014F ***
CAN0TXERR:          equ    $0000014F                                ;*** CAN0TXERR - MSCAN0 Transmit Error Counter Register; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN0TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN0TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN0TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN0TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN0TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN0TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN0TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0TXERR_TXERR0:  equ    %00000001
mCAN0TXERR_TXERR1:  equ    %00000010
mCAN0TXERR_TXERR2:  equ    %00000100
mCAN0TXERR_TXERR3:  equ    %00001000
mCAN0TXERR_TXERR4:  equ    %00010000
mCAN0TXERR_TXERR5:  equ    %00100000
mCAN0TXERR_TXERR6:  equ    %01000000
mCAN0TXERR_TXERR7:  equ    %10000000


;*** CAN0IDAR0 - MSCAN0 Identifier Acceptance Register 0; 0x00000150 ***
CAN0IDAR0:          equ    $00000150                                ;*** CAN0IDAR0 - MSCAN0 Identifier Acceptance Register 0; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR0_AC0:     equ    %00000001
mCAN0IDAR0_AC1:     equ    %00000010
mCAN0IDAR0_AC2:     equ    %00000100
mCAN0IDAR0_AC3:     equ    %00001000
mCAN0IDAR0_AC4:     equ    %00010000
mCAN0IDAR0_AC5:     equ    %00100000
mCAN0IDAR0_AC6:     equ    %01000000
mCAN0IDAR0_AC7:     equ    %10000000


;*** CAN0IDAR1 - MSCAN0 Identifier Acceptance Register 1; 0x00000151 ***
CAN0IDAR1:          equ    $00000151                                ;*** CAN0IDAR1 - MSCAN0 Identifier Acceptance Register 1; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR1_AC0:     equ    %00000001
mCAN0IDAR1_AC1:     equ    %00000010
mCAN0IDAR1_AC2:     equ    %00000100
mCAN0IDAR1_AC3:     equ    %00001000
mCAN0IDAR1_AC4:     equ    %00010000
mCAN0IDAR1_AC5:     equ    %00100000
mCAN0IDAR1_AC6:     equ    %01000000
mCAN0IDAR1_AC7:     equ    %10000000


;*** CAN0IDAR2 - MSCAN0 Identifier Acceptance Register 2; 0x00000152 ***
CAN0IDAR2:          equ    $00000152                                ;*** CAN0IDAR2 - MSCAN0 Identifier Acceptance Register 2; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR2_AC0:     equ    %00000001
mCAN0IDAR2_AC1:     equ    %00000010
mCAN0IDAR2_AC2:     equ    %00000100
mCAN0IDAR2_AC3:     equ    %00001000
mCAN0IDAR2_AC4:     equ    %00010000
mCAN0IDAR2_AC5:     equ    %00100000
mCAN0IDAR2_AC6:     equ    %01000000
mCAN0IDAR2_AC7:     equ    %10000000


;*** CAN0IDAR3 - MSCAN0 Identifier Acceptance Register 3; 0x00000153 ***
CAN0IDAR3:          equ    $00000153                                ;*** CAN0IDAR3 - MSCAN0 Identifier Acceptance Register 3; 0x00000153 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR3_AC0:     equ    %00000001
mCAN0IDAR3_AC1:     equ    %00000010
mCAN0IDAR3_AC2:     equ    %00000100
mCAN0IDAR3_AC3:     equ    %00001000
mCAN0IDAR3_AC4:     equ    %00010000
mCAN0IDAR3_AC5:     equ    %00100000
mCAN0IDAR3_AC6:     equ    %01000000
mCAN0IDAR3_AC7:     equ    %10000000


;*** CAN0IDMR0 - MSCAN0 Identifier Mask Register 0; 0x00000154 ***
CAN0IDMR0:          equ    $00000154                                ;*** CAN0IDMR0 - MSCAN0 Identifier Mask Register 0; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR0_AM0:     equ    %00000001
mCAN0IDMR0_AM1:     equ    %00000010
mCAN0IDMR0_AM2:     equ    %00000100
mCAN0IDMR0_AM3:     equ    %00001000
mCAN0IDMR0_AM4:     equ    %00010000
mCAN0IDMR0_AM5:     equ    %00100000
mCAN0IDMR0_AM6:     equ    %01000000
mCAN0IDMR0_AM7:     equ    %10000000


;*** CAN0IDMR1 - MSCAN0 Identifier Mask Register 1; 0x00000155 ***
CAN0IDMR1:          equ    $00000155                                ;*** CAN0IDMR1 - MSCAN0 Identifier Mask Register 1; 0x00000155 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR1_AM0:     equ    %00000001
mCAN0IDMR1_AM1:     equ    %00000010
mCAN0IDMR1_AM2:     equ    %00000100
mCAN0IDMR1_AM3:     equ    %00001000
mCAN0IDMR1_AM4:     equ    %00010000
mCAN0IDMR1_AM5:     equ    %00100000
mCAN0IDMR1_AM6:     equ    %01000000
mCAN0IDMR1_AM7:     equ    %10000000


;*** CAN0IDMR2 - MSCAN0 Identifier Mask Register 2; 0x00000156 ***
CAN0IDMR2:          equ    $00000156                                ;*** CAN0IDMR2 - MSCAN0 Identifier Mask Register 2; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR2_AM0:     equ    %00000001
mCAN0IDMR2_AM1:     equ    %00000010
mCAN0IDMR2_AM2:     equ    %00000100
mCAN0IDMR2_AM3:     equ    %00001000
mCAN0IDMR2_AM4:     equ    %00010000
mCAN0IDMR2_AM5:     equ    %00100000
mCAN0IDMR2_AM6:     equ    %01000000
mCAN0IDMR2_AM7:     equ    %10000000


;*** CAN0IDMR3 - MSCAN0 Identifier Mask Register 3; 0x00000157 ***
CAN0IDMR3:          equ    $00000157                                ;*** CAN0IDMR3 - MSCAN0 Identifier Mask Register 3; 0x00000157 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR3_AM0:     equ    %00000001
mCAN0IDMR3_AM1:     equ    %00000010
mCAN0IDMR3_AM2:     equ    %00000100
mCAN0IDMR3_AM3:     equ    %00001000
mCAN0IDMR3_AM4:     equ    %00010000
mCAN0IDMR3_AM5:     equ    %00100000
mCAN0IDMR3_AM6:     equ    %01000000
mCAN0IDMR3_AM7:     equ    %10000000


;*** CAN0IDAR4 - MSCAN0 Identifier Acceptance Register 4; 0x00000158 ***
CAN0IDAR4:          equ    $00000158                                ;*** CAN0IDAR4 - MSCAN0 Identifier Acceptance Register 4; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR4_AC0:     equ    %00000001
mCAN0IDAR4_AC1:     equ    %00000010
mCAN0IDAR4_AC2:     equ    %00000100
mCAN0IDAR4_AC3:     equ    %00001000
mCAN0IDAR4_AC4:     equ    %00010000
mCAN0IDAR4_AC5:     equ    %00100000
mCAN0IDAR4_AC6:     equ    %01000000
mCAN0IDAR4_AC7:     equ    %10000000


;*** CAN0IDAR5 - MSCAN0 Identifier Acceptance Register 5; 0x00000159 ***
CAN0IDAR5:          equ    $00000159                                ;*** CAN0IDAR5 - MSCAN0 Identifier Acceptance Register 5; 0x00000159 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR5_AC0:     equ    %00000001
mCAN0IDAR5_AC1:     equ    %00000010
mCAN0IDAR5_AC2:     equ    %00000100
mCAN0IDAR5_AC3:     equ    %00001000
mCAN0IDAR5_AC4:     equ    %00010000
mCAN0IDAR5_AC5:     equ    %00100000
mCAN0IDAR5_AC6:     equ    %01000000
mCAN0IDAR5_AC7:     equ    %10000000


;*** CAN0IDAR6 - MSCAN0 Identifier Acceptance Register 6; 0x0000015A ***
CAN0IDAR6:          equ    $0000015A                                ;*** CAN0IDAR6 - MSCAN0 Identifier Acceptance Register 6; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR6_AC0:     equ    %00000001
mCAN0IDAR6_AC1:     equ    %00000010
mCAN0IDAR6_AC2:     equ    %00000100
mCAN0IDAR6_AC3:     equ    %00001000
mCAN0IDAR6_AC4:     equ    %00010000
mCAN0IDAR6_AC5:     equ    %00100000
mCAN0IDAR6_AC6:     equ    %01000000
mCAN0IDAR6_AC7:     equ    %10000000


;*** CAN0IDAR7 - MSCAN0 Identifier Acceptance Register 7; 0x0000015B ***
CAN0IDAR7:          equ    $0000015B                                ;*** CAN0IDAR7 - MSCAN0 Identifier Acceptance Register 7; 0x0000015B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR7_AC0:     equ    %00000001
mCAN0IDAR7_AC1:     equ    %00000010
mCAN0IDAR7_AC2:     equ    %00000100
mCAN0IDAR7_AC3:     equ    %00001000
mCAN0IDAR7_AC4:     equ    %00010000
mCAN0IDAR7_AC5:     equ    %00100000
mCAN0IDAR7_AC6:     equ    %01000000
mCAN0IDAR7_AC7:     equ    %10000000


;*** CAN0IDMR4 - MSCAN0 Identifier Mask Register 4; 0x0000015C ***
CAN0IDMR4:          equ    $0000015C                                ;*** CAN0IDMR4 - MSCAN0 Identifier Mask Register 4; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR4_AM0:     equ    %00000001
mCAN0IDMR4_AM1:     equ    %00000010
mCAN0IDMR4_AM2:     equ    %00000100
mCAN0IDMR4_AM3:     equ    %00001000
mCAN0IDMR4_AM4:     equ    %00010000
mCAN0IDMR4_AM5:     equ    %00100000
mCAN0IDMR4_AM6:     equ    %01000000
mCAN0IDMR4_AM7:     equ    %10000000


;*** CAN0IDMR5 - MSCAN0 Identifier Mask Register 5; 0x0000015D ***
CAN0IDMR5:          equ    $0000015D                                ;*** CAN0IDMR5 - MSCAN0 Identifier Mask Register 5; 0x0000015D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR5_AM0:     equ    %00000001
mCAN0IDMR5_AM1:     equ    %00000010
mCAN0IDMR5_AM2:     equ    %00000100
mCAN0IDMR5_AM3:     equ    %00001000
mCAN0IDMR5_AM4:     equ    %00010000
mCAN0IDMR5_AM5:     equ    %00100000
mCAN0IDMR5_AM6:     equ    %01000000
mCAN0IDMR5_AM7:     equ    %10000000


;*** CAN0IDMR6 - MSCAN0 Identifier Mask Register 6; 0x0000015E ***
CAN0IDMR6:          equ    $0000015E                                ;*** CAN0IDMR6 - MSCAN0 Identifier Mask Register 6; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR6_AM0:     equ    %00000001
mCAN0IDMR6_AM1:     equ    %00000010
mCAN0IDMR6_AM2:     equ    %00000100
mCAN0IDMR6_AM3:     equ    %00001000
mCAN0IDMR6_AM4:     equ    %00010000
mCAN0IDMR6_AM5:     equ    %00100000
mCAN0IDMR6_AM6:     equ    %01000000
mCAN0IDMR6_AM7:     equ    %10000000


;*** CAN0IDMR7 - MSCAN0 Identifier Mask Register 7; 0x0000015F ***
CAN0IDMR7:          equ    $0000015F                                ;*** CAN0IDMR7 - MSCAN0 Identifier Mask Register 7; 0x0000015F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR7_AM0:     equ    %00000001
mCAN0IDMR7_AM1:     equ    %00000010
mCAN0IDMR7_AM2:     equ    %00000100
mCAN0IDMR7_AM3:     equ    %00001000
mCAN0IDMR7_AM4:     equ    %00010000
mCAN0IDMR7_AM5:     equ    %00100000
mCAN0IDMR7_AM6:     equ    %01000000
mCAN0IDMR7_AM7:     equ    %10000000


;*** CAN0RXIDR0 - MSCAN0 Receive Identifier Register 0; 0x00000160 ***
CAN0RXIDR0:         equ    $00000160                                ;*** CAN0RXIDR0 - MSCAN0 Receive Identifier Register 0; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0RXIDR0_ID21:   equ    %00000001
mCAN0RXIDR0_ID22:   equ    %00000010
mCAN0RXIDR0_ID23:   equ    %00000100
mCAN0RXIDR0_ID24:   equ    %00001000
mCAN0RXIDR0_ID25:   equ    %00010000
mCAN0RXIDR0_ID26:   equ    %00100000
mCAN0RXIDR0_ID27:   equ    %01000000
mCAN0RXIDR0_ID28:   equ    %10000000


;*** CAN0RXIDR1 - MSCAN0 Receive Identifier Register 1; 0x00000161 ***
CAN0RXIDR1:         equ    $00000161                                ;*** CAN0RXIDR1 - MSCAN0 Receive Identifier Register 1; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0RXIDR1_ID15:   equ    %00000001
mCAN0RXIDR1_ID16:   equ    %00000010
mCAN0RXIDR1_ID17:   equ    %00000100
mCAN0RXIDR1_IDE:    equ    %00001000
mCAN0RXIDR1_SRR:    equ    %00010000
mCAN0RXIDR1_ID18:   equ    %00100000
mCAN0RXIDR1_ID19:   equ    %01000000
mCAN0RXIDR1_ID20:   equ    %10000000


;*** CAN0RXIDR2 - MSCAN0 Receive Identifier Register 2; 0x00000162 ***
CAN0RXIDR2:         equ    $00000162                                ;*** CAN0RXIDR2 - MSCAN0 Receive Identifier Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0RXIDR2_ID7:    equ    %00000001
mCAN0RXIDR2_ID8:    equ    %00000010
mCAN0RXIDR2_ID9:    equ    %00000100
mCAN0RXIDR2_ID10:   equ    %00001000
mCAN0RXIDR2_ID11:   equ    %00010000
mCAN0RXIDR2_ID12:   equ    %00100000
mCAN0RXIDR2_ID13:   equ    %01000000
mCAN0RXIDR2_ID14:   equ    %10000000


;*** CAN0RXIDR3 - MSCAN0 Receive Identifier Register 3; 0x00000163 ***
CAN0RXIDR3:         equ    $00000163                                ;*** CAN0RXIDR3 - MSCAN0 Receive Identifier Register 3; 0x00000163 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0RXIDR3_RTR:    equ    %00000001
mCAN0RXIDR3_ID0:    equ    %00000010
mCAN0RXIDR3_ID1:    equ    %00000100
mCAN0RXIDR3_ID2:    equ    %00001000
mCAN0RXIDR3_ID3:    equ    %00010000
mCAN0RXIDR3_ID4:    equ    %00100000
mCAN0RXIDR3_ID5:    equ    %01000000
mCAN0RXIDR3_ID6:    equ    %10000000


;*** CAN0RXDSR0 - MSCAN0 Receive Data Segment Register 0; 0x00000164 ***
CAN0RXDSR0:         equ    $00000164                                ;*** CAN0RXDSR0 - MSCAN0 Receive Data Segment Register 0; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR0_DB0:    equ    %00000001
mCAN0RXDSR0_DB1:    equ    %00000010
mCAN0RXDSR0_DB2:    equ    %00000100
mCAN0RXDSR0_DB3:    equ    %00001000
mCAN0RXDSR0_DB4:    equ    %00010000
mCAN0RXDSR0_DB5:    equ    %00100000
mCAN0RXDSR0_DB6:    equ    %01000000
mCAN0RXDSR0_DB7:    equ    %10000000


;*** CAN0RXDSR1 - MSCAN0 Receive Data Segment Register 1; 0x00000165 ***
CAN0RXDSR1:         equ    $00000165                                ;*** CAN0RXDSR1 - MSCAN0 Receive Data Segment Register 1; 0x00000165 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR1_DB0:    equ    %00000001
mCAN0RXDSR1_DB1:    equ    %00000010
mCAN0RXDSR1_DB2:    equ    %00000100
mCAN0RXDSR1_DB3:    equ    %00001000
mCAN0RXDSR1_DB4:    equ    %00010000
mCAN0RXDSR1_DB5:    equ    %00100000
mCAN0RXDSR1_DB6:    equ    %01000000
mCAN0RXDSR1_DB7:    equ    %10000000


;*** CAN0RXDSR2 - MSCAN0 Receive Data Segment Register 2; 0x00000166 ***
CAN0RXDSR2:         equ    $00000166                                ;*** CAN0RXDSR2 - MSCAN0 Receive Data Segment Register 2; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR2_DB0:    equ    %00000001
mCAN0RXDSR2_DB1:    equ    %00000010
mCAN0RXDSR2_DB2:    equ    %00000100
mCAN0RXDSR2_DB3:    equ    %00001000
mCAN0RXDSR2_DB4:    equ    %00010000
mCAN0RXDSR2_DB5:    equ    %00100000
mCAN0RXDSR2_DB6:    equ    %01000000
mCAN0RXDSR2_DB7:    equ    %10000000


;*** CAN0RXDSR3 - MSCAN0 Receive Data Segment Register 3; 0x00000167 ***
CAN0RXDSR3:         equ    $00000167                                ;*** CAN0RXDSR3 - MSCAN0 Receive Data Segment Register 3; 0x00000167 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR3_DB0:    equ    %00000001
mCAN0RXDSR3_DB1:    equ    %00000010
mCAN0RXDSR3_DB2:    equ    %00000100
mCAN0RXDSR3_DB3:    equ    %00001000
mCAN0RXDSR3_DB4:    equ    %00010000
mCAN0RXDSR3_DB5:    equ    %00100000
mCAN0RXDSR3_DB6:    equ    %01000000
mCAN0RXDSR3_DB7:    equ    %10000000


;*** CAN0RXDSR4 - MSCAN0 Receive Data Segment Register 4; 0x00000168 ***
CAN0RXDSR4:         equ    $00000168                                ;*** CAN0RXDSR4 - MSCAN0 Receive Data Segment Register 4; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR4_DB0:    equ    %00000001
mCAN0RXDSR4_DB1:    equ    %00000010
mCAN0RXDSR4_DB2:    equ    %00000100
mCAN0RXDSR4_DB3:    equ    %00001000
mCAN0RXDSR4_DB4:    equ    %00010000
mCAN0RXDSR4_DB5:    equ    %00100000
mCAN0RXDSR4_DB6:    equ    %01000000
mCAN0RXDSR4_DB7:    equ    %10000000


;*** CAN0RXDSR5 - MSCAN0 Receive Data Segment Register 5; 0x00000169 ***
CAN0RXDSR5:         equ    $00000169                                ;*** CAN0RXDSR5 - MSCAN0 Receive Data Segment Register 5; 0x00000169 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR5_DB0:    equ    %00000001
mCAN0RXDSR5_DB1:    equ    %00000010
mCAN0RXDSR5_DB2:    equ    %00000100
mCAN0RXDSR5_DB3:    equ    %00001000
mCAN0RXDSR5_DB4:    equ    %00010000
mCAN0RXDSR5_DB5:    equ    %00100000
mCAN0RXDSR5_DB6:    equ    %01000000
mCAN0RXDSR5_DB7:    equ    %10000000


;*** CAN0RXDSR6 - MSCAN0 Receive Data Segment Register 6; 0x0000016A ***
CAN0RXDSR6:         equ    $0000016A                                ;*** CAN0RXDSR6 - MSCAN0 Receive Data Segment Register 6; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR6_DB0:    equ    %00000001
mCAN0RXDSR6_DB1:    equ    %00000010
mCAN0RXDSR6_DB2:    equ    %00000100
mCAN0RXDSR6_DB3:    equ    %00001000
mCAN0RXDSR6_DB4:    equ    %00010000
mCAN0RXDSR6_DB5:    equ    %00100000
mCAN0RXDSR6_DB6:    equ    %01000000
mCAN0RXDSR6_DB7:    equ    %10000000


;*** CAN0RXDSR7 - MSCAN0 Receive Data Segment Register 7; 0x0000016B ***
CAN0RXDSR7:         equ    $0000016B                                ;*** CAN0RXDSR7 - MSCAN0 Receive Data Segment Register 7; 0x0000016B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR7_DB0:    equ    %00000001
mCAN0RXDSR7_DB1:    equ    %00000010
mCAN0RXDSR7_DB2:    equ    %00000100
mCAN0RXDSR7_DB3:    equ    %00001000
mCAN0RXDSR7_DB4:    equ    %00010000
mCAN0RXDSR7_DB5:    equ    %00100000
mCAN0RXDSR7_DB6:    equ    %01000000
mCAN0RXDSR7_DB7:    equ    %10000000


;*** CAN0RXDLR - MSCAN0 Receive Data Length Register; 0x0000016C ***
CAN0RXDLR:          equ    $0000016C                                ;*** CAN0RXDLR - MSCAN0 Receive Data Length Register; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0RXDLR_DLC0:    equ    %00000001
mCAN0RXDLR_DLC1:    equ    %00000010
mCAN0RXDLR_DLC2:    equ    %00000100
mCAN0RXDLR_DLC3:    equ    %00001000


;*** CAN0RXTSR - MSCAN0 Receive Time Stamp Register; 0x0000016E ***
CAN0RXTSR:          equ    $0000016E                                ;*** CAN0RXTSR - MSCAN0 Receive Time Stamp Register; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSR_TSR0:    equ    %00000001
mCAN0RXTSR_TSR1:    equ    %00000010
mCAN0RXTSR_TSR2:    equ    %00000100
mCAN0RXTSR_TSR3:    equ    %00001000
mCAN0RXTSR_TSR4:    equ    %00010000
mCAN0RXTSR_TSR5:    equ    %00100000
mCAN0RXTSR_TSR6:    equ    %01000000
mCAN0RXTSR_TSR7:    equ    %10000000
mCAN0RXTSR_TSR8:    equ    %100000000
mCAN0RXTSR_TSR9:    equ    %1000000000
mCAN0RXTSR_TSR10:   equ    %10000000000
mCAN0RXTSR_TSR11:   equ    %100000000000
mCAN0RXTSR_TSR12:   equ    %1000000000000
mCAN0RXTSR_TSR13:   equ    %10000000000000
mCAN0RXTSR_TSR14:   equ    %100000000000000
mCAN0RXTSR_TSR15:   equ    %1000000000000000


;*** CAN0RXTSRH - MSCAN0 Receive Time Stamp Register High; 0x0000016E ***
CAN0RXTSRH:         equ    $0000016E                                ;*** CAN0RXTSRH - MSCAN0 Receive Time Stamp Register High; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSRH_TSR8:   equ    %00000001
mCAN0RXTSRH_TSR9:   equ    %00000010
mCAN0RXTSRH_TSR10:  equ    %00000100
mCAN0RXTSRH_TSR11:  equ    %00001000
mCAN0RXTSRH_TSR12:  equ    %00010000
mCAN0RXTSRH_TSR13:  equ    %00100000
mCAN0RXTSRH_TSR14:  equ    %01000000
mCAN0RXTSRH_TSR15:  equ    %10000000


;*** CAN0RXTSRL - MSCAN0 Receive Time Stamp Register Low; 0x0000016F ***
CAN0RXTSRL:         equ    $0000016F                                ;*** CAN0RXTSRL - MSCAN0 Receive Time Stamp Register Low; 0x0000016F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0RXTSRL_TSR0:   equ    %00000001
mCAN0RXTSRL_TSR1:   equ    %00000010
mCAN0RXTSRL_TSR2:   equ    %00000100
mCAN0RXTSRL_TSR3:   equ    %00001000
mCAN0RXTSRL_TSR4:   equ    %00010000
mCAN0RXTSRL_TSR5:   equ    %00100000
mCAN0RXTSRL_TSR6:   equ    %01000000
mCAN0RXTSRL_TSR7:   equ    %10000000


;*** CAN0TXIDR0 - MSCAN0 Transmit Identifier Register 0; 0x00000170 ***
CAN0TXIDR0:         equ    $00000170                                ;*** CAN0TXIDR0 - MSCAN0 Transmit Identifier Register 0; 0x00000170 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0TXIDR0_ID21:   equ    %00000001
mCAN0TXIDR0_ID22:   equ    %00000010
mCAN0TXIDR0_ID23:   equ    %00000100
mCAN0TXIDR0_ID24:   equ    %00001000
mCAN0TXIDR0_ID25:   equ    %00010000
mCAN0TXIDR0_ID26:   equ    %00100000
mCAN0TXIDR0_ID27:   equ    %01000000
mCAN0TXIDR0_ID28:   equ    %10000000


;*** CAN0TXIDR1 - MSCAN0 Transmit Identifier Register 1; 0x00000171 ***
CAN0TXIDR1:         equ    $00000171                                ;*** CAN0TXIDR1 - MSCAN0 Transmit Identifier Register 1; 0x00000171 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0TXIDR1_ID15:   equ    %00000001
mCAN0TXIDR1_ID16:   equ    %00000010
mCAN0TXIDR1_ID17:   equ    %00000100
mCAN0TXIDR1_IDE:    equ    %00001000
mCAN0TXIDR1_SRR:    equ    %00010000
mCAN0TXIDR1_ID18:   equ    %00100000
mCAN0TXIDR1_ID19:   equ    %01000000
mCAN0TXIDR1_ID20:   equ    %10000000


;*** CAN0TXIDR2 - MSCAN0 Transmit Identifier Register 2; 0x00000172 ***
CAN0TXIDR2:         equ    $00000172                                ;*** CAN0TXIDR2 - MSCAN0 Transmit Identifier Register 2; 0x00000172 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0TXIDR2_ID7:    equ    %00000001
mCAN0TXIDR2_ID8:    equ    %00000010
mCAN0TXIDR2_ID9:    equ    %00000100
mCAN0TXIDR2_ID10:   equ    %00001000
mCAN0TXIDR2_ID11:   equ    %00010000
mCAN0TXIDR2_ID12:   equ    %00100000
mCAN0TXIDR2_ID13:   equ    %01000000
mCAN0TXIDR2_ID14:   equ    %10000000


;*** CAN0TXIDR3 - MSCAN0 Transmit Identifier Register 3; 0x00000173 ***
CAN0TXIDR3:         equ    $00000173                                ;*** CAN0TXIDR3 - MSCAN0 Transmit Identifier Register 3; 0x00000173 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0TXIDR3_RTR:    equ    %00000001
mCAN0TXIDR3_ID0:    equ    %00000010
mCAN0TXIDR3_ID1:    equ    %00000100
mCAN0TXIDR3_ID2:    equ    %00001000
mCAN0TXIDR3_ID3:    equ    %00010000
mCAN0TXIDR3_ID4:    equ    %00100000
mCAN0TXIDR3_ID5:    equ    %01000000
mCAN0TXIDR3_ID6:    equ    %10000000


;*** CAN0TXDSR0 - MSCAN0 Transmit Data Segment Register 0; 0x00000174 ***
CAN0TXDSR0:         equ    $00000174                                ;*** CAN0TXDSR0 - MSCAN0 Transmit Data Segment Register 0; 0x00000174 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR0_DB0:    equ    %00000001
mCAN0TXDSR0_DB1:    equ    %00000010
mCAN0TXDSR0_DB2:    equ    %00000100
mCAN0TXDSR0_DB3:    equ    %00001000
mCAN0TXDSR0_DB4:    equ    %00010000
mCAN0TXDSR0_DB5:    equ    %00100000
mCAN0TXDSR0_DB6:    equ    %01000000
mCAN0TXDSR0_DB7:    equ    %10000000


;*** CAN0TXDSR1 - MSCAN0 Transmit Data Segment Register 1; 0x00000175 ***
CAN0TXDSR1:         equ    $00000175                                ;*** CAN0TXDSR1 - MSCAN0 Transmit Data Segment Register 1; 0x00000175 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR1_DB0:    equ    %00000001
mCAN0TXDSR1_DB1:    equ    %00000010
mCAN0TXDSR1_DB2:    equ    %00000100
mCAN0TXDSR1_DB3:    equ    %00001000
mCAN0TXDSR1_DB4:    equ    %00010000
mCAN0TXDSR1_DB5:    equ    %00100000
mCAN0TXDSR1_DB6:    equ    %01000000
mCAN0TXDSR1_DB7:    equ    %10000000


;*** CAN0TXDSR2 - MSCAN0 Transmit Data Segment Register 2; 0x00000176 ***
CAN0TXDSR2:         equ    $00000176                                ;*** CAN0TXDSR2 - MSCAN0 Transmit Data Segment Register 2; 0x00000176 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR2_DB0:    equ    %00000001
mCAN0TXDSR2_DB1:    equ    %00000010
mCAN0TXDSR2_DB2:    equ    %00000100
mCAN0TXDSR2_DB3:    equ    %00001000
mCAN0TXDSR2_DB4:    equ    %00010000
mCAN0TXDSR2_DB5:    equ    %00100000
mCAN0TXDSR2_DB6:    equ    %01000000
mCAN0TXDSR2_DB7:    equ    %10000000


;*** CAN0TXDSR3 - MSCAN0 Transmit Data Segment Register 3; 0x00000177 ***
CAN0TXDSR3:         equ    $00000177                                ;*** CAN0TXDSR3 - MSCAN0 Transmit Data Segment Register 3; 0x00000177 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR3_DB0:    equ    %00000001
mCAN0TXDSR3_DB1:    equ    %00000010
mCAN0TXDSR3_DB2:    equ    %00000100
mCAN0TXDSR3_DB3:    equ    %00001000
mCAN0TXDSR3_DB4:    equ    %00010000
mCAN0TXDSR3_DB5:    equ    %00100000
mCAN0TXDSR3_DB6:    equ    %01000000
mCAN0TXDSR3_DB7:    equ    %10000000


;*** CAN0TXDSR4 - MSCAN0 Transmit Data Segment Register 4; 0x00000178 ***
CAN0TXDSR4:         equ    $00000178                                ;*** CAN0TXDSR4 - MSCAN0 Transmit Data Segment Register 4; 0x00000178 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR4_DB0:    equ    %00000001
mCAN0TXDSR4_DB1:    equ    %00000010
mCAN0TXDSR4_DB2:    equ    %00000100
mCAN0TXDSR4_DB3:    equ    %00001000
mCAN0TXDSR4_DB4:    equ    %00010000
mCAN0TXDSR4_DB5:    equ    %00100000
mCAN0TXDSR4_DB6:    equ    %01000000
mCAN0TXDSR4_DB7:    equ    %10000000


;*** CAN0TXDSR5 - MSCAN0 Transmit Data Segment Register 5; 0x00000179 ***
CAN0TXDSR5:         equ    $00000179                                ;*** CAN0TXDSR5 - MSCAN0 Transmit Data Segment Register 5; 0x00000179 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR5_DB0:    equ    %00000001
mCAN0TXDSR5_DB1:    equ    %00000010
mCAN0TXDSR5_DB2:    equ    %00000100
mCAN0TXDSR5_DB3:    equ    %00001000
mCAN0TXDSR5_DB4:    equ    %00010000
mCAN0TXDSR5_DB5:    equ    %00100000
mCAN0TXDSR5_DB6:    equ    %01000000
mCAN0TXDSR5_DB7:    equ    %10000000


;*** CAN0TXDSR6 - MSCAN0 Transmit Data Segment Register 6; 0x0000017A ***
CAN0TXDSR6:         equ    $0000017A                                ;*** CAN0TXDSR6 - MSCAN0 Transmit Data Segment Register 6; 0x0000017A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR6_DB0:    equ    %00000001
mCAN0TXDSR6_DB1:    equ    %00000010
mCAN0TXDSR6_DB2:    equ    %00000100
mCAN0TXDSR6_DB3:    equ    %00001000
mCAN0TXDSR6_DB4:    equ    %00010000
mCAN0TXDSR6_DB5:    equ    %00100000
mCAN0TXDSR6_DB6:    equ    %01000000
mCAN0TXDSR6_DB7:    equ    %10000000


;*** CAN0TXDSR7 - MSCAN0 Transmit Data Segment Register 7; 0x0000017B ***
CAN0TXDSR7:         equ    $0000017B                                ;*** CAN0TXDSR7 - MSCAN0 Transmit Data Segment Register 7; 0x0000017B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR7_DB0:    equ    %00000001
mCAN0TXDSR7_DB1:    equ    %00000010
mCAN0TXDSR7_DB2:    equ    %00000100
mCAN0TXDSR7_DB3:    equ    %00001000
mCAN0TXDSR7_DB4:    equ    %00010000
mCAN0TXDSR7_DB5:    equ    %00100000
mCAN0TXDSR7_DB6:    equ    %01000000
mCAN0TXDSR7_DB7:    equ    %10000000


;*** CAN0TXDLR - MSCAN0 Transmit Data Length Register; 0x0000017C ***
CAN0TXDLR:          equ    $0000017C                                ;*** CAN0TXDLR - MSCAN0 Transmit Data Length Register; 0x0000017C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0TXDLR_DLC0:    equ    %00000001
mCAN0TXDLR_DLC1:    equ    %00000010
mCAN0TXDLR_DLC2:    equ    %00000100
mCAN0TXDLR_DLC3:    equ    %00001000


;*** CAN0TXTBPR - MSCAN0 Transmit Buffer Priority; 0x0000017D ***
CAN0TXTBPR:         equ    $0000017D                                ;*** CAN0TXTBPR - MSCAN0 Transmit Buffer Priority; 0x0000017D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN0TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN0TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN0TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN0TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN0TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN0TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN0TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN0TXTBPR_PRIO0:  equ    %00000001
mCAN0TXTBPR_PRIO1:  equ    %00000010
mCAN0TXTBPR_PRIO2:  equ    %00000100
mCAN0TXTBPR_PRIO3:  equ    %00001000
mCAN0TXTBPR_PRIO4:  equ    %00010000
mCAN0TXTBPR_PRIO5:  equ    %00100000
mCAN0TXTBPR_PRIO6:  equ    %01000000
mCAN0TXTBPR_PRIO7:  equ    %10000000


;*** CAN0TXTSR - MSCAN0 Transmit Time Stamp Register; 0x0000017E ***
CAN0TXTSR:          equ    $0000017E                                ;*** CAN0TXTSR - MSCAN0 Transmit Time Stamp Register; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSR_TSR0:    equ    %00000001
mCAN0TXTSR_TSR1:    equ    %00000010
mCAN0TXTSR_TSR2:    equ    %00000100
mCAN0TXTSR_TSR3:    equ    %00001000
mCAN0TXTSR_TSR4:    equ    %00010000
mCAN0TXTSR_TSR5:    equ    %00100000
mCAN0TXTSR_TSR6:    equ    %01000000
mCAN0TXTSR_TSR7:    equ    %10000000
mCAN0TXTSR_TSR8:    equ    %100000000
mCAN0TXTSR_TSR9:    equ    %1000000000
mCAN0TXTSR_TSR10:   equ    %10000000000
mCAN0TXTSR_TSR11:   equ    %100000000000
mCAN0TXTSR_TSR12:   equ    %1000000000000
mCAN0TXTSR_TSR13:   equ    %10000000000000
mCAN0TXTSR_TSR14:   equ    %100000000000000
mCAN0TXTSR_TSR15:   equ    %1000000000000000


;*** CAN0TXTSRH - MSCAN0 Transmit Time Stamp Register High; 0x0000017E ***
CAN0TXTSRH:         equ    $0000017E                                ;*** CAN0TXTSRH - MSCAN0 Transmit Time Stamp Register High; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSRH_TSR8:   equ    %00000001
mCAN0TXTSRH_TSR9:   equ    %00000010
mCAN0TXTSRH_TSR10:  equ    %00000100
mCAN0TXTSRH_TSR11:  equ    %00001000
mCAN0TXTSRH_TSR12:  equ    %00010000
mCAN0TXTSRH_TSR13:  equ    %00100000
mCAN0TXTSRH_TSR14:  equ    %01000000
mCAN0TXTSRH_TSR15:  equ    %10000000


;*** CAN0TXTSRL - MSCAN0 Transmit Time Stamp Register Low; 0x0000017F ***
CAN0TXTSRL:         equ    $0000017F                                ;*** CAN0TXTSRL - MSCAN0 Transmit Time Stamp Register Low; 0x0000017F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0TXTSRL_TSR0:   equ    %00000001
mCAN0TXTSRL_TSR1:   equ    %00000010
mCAN0TXTSRL_TSR2:   equ    %00000100
mCAN0TXTSRL_TSR3:   equ    %00001000
mCAN0TXTSRL_TSR4:   equ    %00010000
mCAN0TXTSRL_TSR5:   equ    %00100000
mCAN0TXTSRL_TSR6:   equ    %01000000
mCAN0TXTSRL_TSR7:   equ    %10000000


;*** CAN1CTL0 - MSCAN1 Control 0 Register; 0x00000180 ***
CAN1CTL0:           equ    $00000180                                ;*** CAN1CTL0 - MSCAN1 Control 0 Register; 0x00000180 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN1CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN1CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN1CTL0_TIME:      equ    3                                         ; Timer Enable
CAN1CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN1CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN1CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN1CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN1CTL0_INITRQ:   equ    %00000001
mCAN1CTL0_SLPRQ:    equ    %00000010
mCAN1CTL0_WUPE:     equ    %00000100
mCAN1CTL0_TIME:     equ    %00001000
mCAN1CTL0_SYNCH:    equ    %00010000
mCAN1CTL0_CSWAI:    equ    %00100000
mCAN1CTL0_RXACT:    equ    %01000000
mCAN1CTL0_RXFRM:    equ    %10000000


;*** CAN1CTL1 - MSCAN1 Control 1 Register; 0x00000181 ***
CAN1CTL1:           equ    $00000181                                ;*** CAN1CTL1 - MSCAN1 Control 1 Register; 0x00000181 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN1CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN1CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN1CTL1_BORM:      equ    3                                         ; Bus-Off Recovery Mode
CAN1CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN1CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN1CTL1_CLKSRC:    equ    6                                         ; MSCAN Clock Source
CAN1CTL1_CANE:      equ    7                                         ; MSCAN Enable
; bit position masks
mCAN1CTL1_INITAK:   equ    %00000001
mCAN1CTL1_SLPAK:    equ    %00000010
mCAN1CTL1_WUPM:     equ    %00000100
mCAN1CTL1_BORM:     equ    %00001000
mCAN1CTL1_LISTEN:   equ    %00010000
mCAN1CTL1_LOOPB:    equ    %00100000
mCAN1CTL1_CLKSRC:   equ    %01000000
mCAN1CTL1_CANE:     equ    %10000000


;*** CAN1BTR0 - MSCAN1 Bus Timing Register 0; 0x00000182 ***
CAN1BTR0:           equ    $00000182                                ;*** CAN1BTR0 - MSCAN1 Bus Timing Register 0; 0x00000182 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN1BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN1BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN1BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN1BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN1BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN1BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN1BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN1BTR0_BRP0:     equ    %00000001
mCAN1BTR0_BRP1:     equ    %00000010
mCAN1BTR0_BRP2:     equ    %00000100
mCAN1BTR0_BRP3:     equ    %00001000
mCAN1BTR0_BRP4:     equ    %00010000
mCAN1BTR0_BRP5:     equ    %00100000
mCAN1BTR0_SJW0:     equ    %01000000
mCAN1BTR0_SJW1:     equ    %10000000


;*** CAN1BTR1 - MSCAN1 Bus Timing Register 1; 0x00000183 ***
CAN1BTR1:           equ    $00000183                                ;*** CAN1BTR1 - MSCAN1 Bus Timing Register 1; 0x00000183 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN1BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN1BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN1BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN1BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN1BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN1BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN1BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN1BTR1_TSEG10:   equ    %00000001
mCAN1BTR1_TSEG11:   equ    %00000010
mCAN1BTR1_TSEG12:   equ    %00000100
mCAN1BTR1_TSEG13:   equ    %00001000
mCAN1BTR1_TSEG20:   equ    %00010000
mCAN1BTR1_TSEG21:   equ    %00100000
mCAN1BTR1_TSEG22:   equ    %01000000
mCAN1BTR1_SAMP:     equ    %10000000


;*** CAN1RFLG - MSCAN1 Receiver Flag Register; 0x00000184 ***
CAN1RFLG:           equ    $00000184                                ;*** CAN1RFLG - MSCAN1 Receiver Flag Register; 0x00000184 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN1RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN1RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN1RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN1RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN1RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN1RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN1RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN1RFLG_RXF:      equ    %00000001
mCAN1RFLG_OVRIF:    equ    %00000010
mCAN1RFLG_TSTAT0:   equ    %00000100
mCAN1RFLG_TSTAT1:   equ    %00001000
mCAN1RFLG_RSTAT0:   equ    %00010000
mCAN1RFLG_RSTAT1:   equ    %00100000
mCAN1RFLG_CSCIF:    equ    %01000000
mCAN1RFLG_WUPIF:    equ    %10000000


;*** CAN1RIER - MSCAN1 Receiver Interrupt Enable Register; 0x00000185 ***
CAN1RIER:           equ    $00000185                                ;*** CAN1RIER - MSCAN1 Receiver Interrupt Enable Register; 0x00000185 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN1RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN1RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN1RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN1RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN1RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN1RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN1RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN1RIER_RXFIE:    equ    %00000001
mCAN1RIER_OVRIE:    equ    %00000010
mCAN1RIER_TSTATE0:  equ    %00000100
mCAN1RIER_TSTATE1:  equ    %00001000
mCAN1RIER_RSTATE0:  equ    %00010000
mCAN1RIER_RSTATE1:  equ    %00100000
mCAN1RIER_CSCIE:    equ    %01000000
mCAN1RIER_WUPIE:    equ    %10000000


;*** CAN1TFLG - MSCAN1 Transmitter Flag Register; 0x00000186 ***
CAN1TFLG:           equ    $00000186                                ;*** CAN1TFLG - MSCAN1 Transmitter Flag Register; 0x00000186 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN1TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN1TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN1TFLG_TXE0:     equ    %00000001
mCAN1TFLG_TXE1:     equ    %00000010
mCAN1TFLG_TXE2:     equ    %00000100


;*** CAN1TIER - MSCAN1 Transmitter Interrupt Enable Register; 0x00000187 ***
CAN1TIER:           equ    $00000187                                ;*** CAN1TIER - MSCAN1 Transmitter Interrupt Enable Register; 0x00000187 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN1TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN1TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN1TIER_TXEIE0:   equ    %00000001
mCAN1TIER_TXEIE1:   equ    %00000010
mCAN1TIER_TXEIE2:   equ    %00000100


;*** CAN1TARQ - MSCAN1 Transmitter Message Abort Request; 0x00000188 ***
CAN1TARQ:           equ    $00000188                                ;*** CAN1TARQ - MSCAN1 Transmitter Message Abort Request; 0x00000188 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN1TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN1TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN1TARQ_ABTRQ0:   equ    %00000001
mCAN1TARQ_ABTRQ1:   equ    %00000010
mCAN1TARQ_ABTRQ2:   equ    %00000100


;*** CAN1TAAK - MSCAN1 Transmitter Message Abort Acknowledge; 0x00000189 ***
CAN1TAAK:           equ    $00000189                                ;*** CAN1TAAK - MSCAN1 Transmitter Message Abort Acknowledge; 0x00000189 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN1TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN1TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN1TAAK_ABTAK0:   equ    %00000001
mCAN1TAAK_ABTAK1:   equ    %00000010
mCAN1TAAK_ABTAK2:   equ    %00000100


;*** CAN1TBSEL - MSCAN1 Transmit Buffer Selection; 0x0000018A ***
CAN1TBSEL:          equ    $0000018A                                ;*** CAN1TBSEL - MSCAN1 Transmit Buffer Selection; 0x0000018A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN1TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN1TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN1TBSEL_TX0:     equ    %00000001
mCAN1TBSEL_TX1:     equ    %00000010
mCAN1TBSEL_TX2:     equ    %00000100


;*** CAN1IDAC - MSCAN1 Identifier Acceptance Control Register; 0x0000018B ***
CAN1IDAC:           equ    $0000018B                                ;*** CAN1IDAC - MSCAN1 Identifier Acceptance Control Register; 0x0000018B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN1IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN1IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN1IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN1IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN1IDAC_IDHIT0:   equ    %00000001
mCAN1IDAC_IDHIT1:   equ    %00000010
mCAN1IDAC_IDHIT2:   equ    %00000100
mCAN1IDAC_IDAM0:    equ    %00010000
mCAN1IDAC_IDAM1:    equ    %00100000


;*** CAN1MISC - MSCAN1 Miscellaneous Register; 0x0000018D ***
CAN1MISC:           equ    $0000018D                                ;*** CAN1MISC - MSCAN1 Miscellaneous Register; 0x0000018D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1MISC_BOHOLD:    equ    0                                         ; Bus-off State Hold Until User Request
; bit position masks
mCAN1MISC_BOHOLD:   equ    %00000001


;*** CAN1RXERR - MSCAN1 Receive Error Counter Register; 0x0000018E ***
CAN1RXERR:          equ    $0000018E                                ;*** CAN1RXERR - MSCAN1 Receive Error Counter Register; 0x0000018E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN1RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN1RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN1RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN1RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN1RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN1RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN1RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN1RXERR_RXERR0:  equ    %00000001
mCAN1RXERR_RXERR1:  equ    %00000010
mCAN1RXERR_RXERR2:  equ    %00000100
mCAN1RXERR_RXERR3:  equ    %00001000
mCAN1RXERR_RXERR4:  equ    %00010000
mCAN1RXERR_RXERR5:  equ    %00100000
mCAN1RXERR_RXERR6:  equ    %01000000
mCAN1RXERR_RXERR7:  equ    %10000000


;*** CAN1TXERR - MSCAN1 Transmit Error Counter Register; 0x0000018F ***
CAN1TXERR:          equ    $0000018F                                ;*** CAN1TXERR - MSCAN1 Transmit Error Counter Register; 0x0000018F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN1TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN1TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN1TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN1TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN1TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN1TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN1TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN1TXERR_TXERR0:  equ    %00000001
mCAN1TXERR_TXERR1:  equ    %00000010
mCAN1TXERR_TXERR2:  equ    %00000100
mCAN1TXERR_TXERR3:  equ    %00001000
mCAN1TXERR_TXERR4:  equ    %00010000
mCAN1TXERR_TXERR5:  equ    %00100000
mCAN1TXERR_TXERR6:  equ    %01000000
mCAN1TXERR_TXERR7:  equ    %10000000


;*** CAN1IDAR0 - MSCAN1 Identifier Acceptance Register 0; 0x00000190 ***
CAN1IDAR0:          equ    $00000190                                ;*** CAN1IDAR0 - MSCAN1 Identifier Acceptance Register 0; 0x00000190 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR0_AC0:     equ    %00000001
mCAN1IDAR0_AC1:     equ    %00000010
mCAN1IDAR0_AC2:     equ    %00000100
mCAN1IDAR0_AC3:     equ    %00001000
mCAN1IDAR0_AC4:     equ    %00010000
mCAN1IDAR0_AC5:     equ    %00100000
mCAN1IDAR0_AC6:     equ    %01000000
mCAN1IDAR0_AC7:     equ    %10000000


;*** CAN1IDAR1 - MSCAN1 Identifier Acceptance Register 1; 0x00000191 ***
CAN1IDAR1:          equ    $00000191                                ;*** CAN1IDAR1 - MSCAN1 Identifier Acceptance Register 1; 0x00000191 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR1_AC0:     equ    %00000001
mCAN1IDAR1_AC1:     equ    %00000010
mCAN1IDAR1_AC2:     equ    %00000100
mCAN1IDAR1_AC3:     equ    %00001000
mCAN1IDAR1_AC4:     equ    %00010000
mCAN1IDAR1_AC5:     equ    %00100000
mCAN1IDAR1_AC6:     equ    %01000000
mCAN1IDAR1_AC7:     equ    %10000000


;*** CAN1IDAR2 - MSCAN1 Identifier Acceptance Register 2; 0x00000192 ***
CAN1IDAR2:          equ    $00000192                                ;*** CAN1IDAR2 - MSCAN1 Identifier Acceptance Register 2; 0x00000192 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR2_AC0:     equ    %00000001
mCAN1IDAR2_AC1:     equ    %00000010
mCAN1IDAR2_AC2:     equ    %00000100
mCAN1IDAR2_AC3:     equ    %00001000
mCAN1IDAR2_AC4:     equ    %00010000
mCAN1IDAR2_AC5:     equ    %00100000
mCAN1IDAR2_AC6:     equ    %01000000
mCAN1IDAR2_AC7:     equ    %10000000


;*** CAN1IDAR3 - MSCAN1 Identifier Acceptance Register 3; 0x00000193 ***
CAN1IDAR3:          equ    $00000193                                ;*** CAN1IDAR3 - MSCAN1 Identifier Acceptance Register 3; 0x00000193 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR3_AC0:     equ    %00000001
mCAN1IDAR3_AC1:     equ    %00000010
mCAN1IDAR3_AC2:     equ    %00000100
mCAN1IDAR3_AC3:     equ    %00001000
mCAN1IDAR3_AC4:     equ    %00010000
mCAN1IDAR3_AC5:     equ    %00100000
mCAN1IDAR3_AC6:     equ    %01000000
mCAN1IDAR3_AC7:     equ    %10000000


;*** CAN1IDMR0 - MSCAN1 Identifier Mask Register 0; 0x00000194 ***
CAN1IDMR0:          equ    $00000194                                ;*** CAN1IDMR0 - MSCAN1 Identifier Mask Register 0; 0x00000194 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR0_AM0:     equ    %00000001
mCAN1IDMR0_AM1:     equ    %00000010
mCAN1IDMR0_AM2:     equ    %00000100
mCAN1IDMR0_AM3:     equ    %00001000
mCAN1IDMR0_AM4:     equ    %00010000
mCAN1IDMR0_AM5:     equ    %00100000
mCAN1IDMR0_AM6:     equ    %01000000
mCAN1IDMR0_AM7:     equ    %10000000


;*** CAN1IDMR1 - MSCAN1 Identifier Mask Register 1; 0x00000195 ***
CAN1IDMR1:          equ    $00000195                                ;*** CAN1IDMR1 - MSCAN1 Identifier Mask Register 1; 0x00000195 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR1_AM0:     equ    %00000001
mCAN1IDMR1_AM1:     equ    %00000010
mCAN1IDMR1_AM2:     equ    %00000100
mCAN1IDMR1_AM3:     equ    %00001000
mCAN1IDMR1_AM4:     equ    %00010000
mCAN1IDMR1_AM5:     equ    %00100000
mCAN1IDMR1_AM6:     equ    %01000000
mCAN1IDMR1_AM7:     equ    %10000000


;*** CAN1IDMR2 - MSCAN1 Identifier Mask Register 2; 0x00000196 ***
CAN1IDMR2:          equ    $00000196                                ;*** CAN1IDMR2 - MSCAN1 Identifier Mask Register 2; 0x00000196 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR2_AM0:     equ    %00000001
mCAN1IDMR2_AM1:     equ    %00000010
mCAN1IDMR2_AM2:     equ    %00000100
mCAN1IDMR2_AM3:     equ    %00001000
mCAN1IDMR2_AM4:     equ    %00010000
mCAN1IDMR2_AM5:     equ    %00100000
mCAN1IDMR2_AM6:     equ    %01000000
mCAN1IDMR2_AM7:     equ    %10000000


;*** CAN1IDMR3 - MSCAN1 Identifier Mask Register 3; 0x00000197 ***
CAN1IDMR3:          equ    $00000197                                ;*** CAN1IDMR3 - MSCAN1 Identifier Mask Register 3; 0x00000197 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR3_AM0:     equ    %00000001
mCAN1IDMR3_AM1:     equ    %00000010
mCAN1IDMR3_AM2:     equ    %00000100
mCAN1IDMR3_AM3:     equ    %00001000
mCAN1IDMR3_AM4:     equ    %00010000
mCAN1IDMR3_AM5:     equ    %00100000
mCAN1IDMR3_AM6:     equ    %01000000
mCAN1IDMR3_AM7:     equ    %10000000


;*** CAN1IDAR4 - MSCAN1 Identifier Acceptance Register 4; 0x00000198 ***
CAN1IDAR4:          equ    $00000198                                ;*** CAN1IDAR4 - MSCAN1 Identifier Acceptance Register 4; 0x00000198 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR4_AC0:     equ    %00000001
mCAN1IDAR4_AC1:     equ    %00000010
mCAN1IDAR4_AC2:     equ    %00000100
mCAN1IDAR4_AC3:     equ    %00001000
mCAN1IDAR4_AC4:     equ    %00010000
mCAN1IDAR4_AC5:     equ    %00100000
mCAN1IDAR4_AC6:     equ    %01000000
mCAN1IDAR4_AC7:     equ    %10000000


;*** CAN1IDAR5 - MSCAN1 Identifier Acceptance Register 5; 0x00000199 ***
CAN1IDAR5:          equ    $00000199                                ;*** CAN1IDAR5 - MSCAN1 Identifier Acceptance Register 5; 0x00000199 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR5_AC0:     equ    %00000001
mCAN1IDAR5_AC1:     equ    %00000010
mCAN1IDAR5_AC2:     equ    %00000100
mCAN1IDAR5_AC3:     equ    %00001000
mCAN1IDAR5_AC4:     equ    %00010000
mCAN1IDAR5_AC5:     equ    %00100000
mCAN1IDAR5_AC6:     equ    %01000000
mCAN1IDAR5_AC7:     equ    %10000000


;*** CAN1IDAR6 - MSCAN1 Identifier Acceptance Register 6; 0x0000019A ***
CAN1IDAR6:          equ    $0000019A                                ;*** CAN1IDAR6 - MSCAN1 Identifier Acceptance Register 6; 0x0000019A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR6_AC0:     equ    %00000001
mCAN1IDAR6_AC1:     equ    %00000010
mCAN1IDAR6_AC2:     equ    %00000100
mCAN1IDAR6_AC3:     equ    %00001000
mCAN1IDAR6_AC4:     equ    %00010000
mCAN1IDAR6_AC5:     equ    %00100000
mCAN1IDAR6_AC6:     equ    %01000000
mCAN1IDAR6_AC7:     equ    %10000000


;*** CAN1IDAR7 - MSCAN1 Identifier Acceptance Register 7; 0x0000019B ***
CAN1IDAR7:          equ    $0000019B                                ;*** CAN1IDAR7 - MSCAN1 Identifier Acceptance Register 7; 0x0000019B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR7_AC0:     equ    %00000001
mCAN1IDAR7_AC1:     equ    %00000010
mCAN1IDAR7_AC2:     equ    %00000100
mCAN1IDAR7_AC3:     equ    %00001000
mCAN1IDAR7_AC4:     equ    %00010000
mCAN1IDAR7_AC5:     equ    %00100000
mCAN1IDAR7_AC6:     equ    %01000000
mCAN1IDAR7_AC7:     equ    %10000000


;*** CAN1IDMR4 - MSCAN1 Identifier Mask Register 4; 0x0000019C ***
CAN1IDMR4:          equ    $0000019C                                ;*** CAN1IDMR4 - MSCAN1 Identifier Mask Register 4; 0x0000019C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR4_AM0:     equ    %00000001
mCAN1IDMR4_AM1:     equ    %00000010
mCAN1IDMR4_AM2:     equ    %00000100
mCAN1IDMR4_AM3:     equ    %00001000
mCAN1IDMR4_AM4:     equ    %00010000
mCAN1IDMR4_AM5:     equ    %00100000
mCAN1IDMR4_AM6:     equ    %01000000
mCAN1IDMR4_AM7:     equ    %10000000


;*** CAN1IDMR5 - MSCAN1 Identifier Mask Register 5; 0x0000019D ***
CAN1IDMR5:          equ    $0000019D                                ;*** CAN1IDMR5 - MSCAN1 Identifier Mask Register 5; 0x0000019D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR5_AM0:     equ    %00000001
mCAN1IDMR5_AM1:     equ    %00000010
mCAN1IDMR5_AM2:     equ    %00000100
mCAN1IDMR5_AM3:     equ    %00001000
mCAN1IDMR5_AM4:     equ    %00010000
mCAN1IDMR5_AM5:     equ    %00100000
mCAN1IDMR5_AM6:     equ    %01000000
mCAN1IDMR5_AM7:     equ    %10000000


;*** CAN1IDMR6 - MSCAN1 Identifier Mask Register 6; 0x0000019E ***
CAN1IDMR6:          equ    $0000019E                                ;*** CAN1IDMR6 - MSCAN1 Identifier Mask Register 6; 0x0000019E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR6_AM0:     equ    %00000001
mCAN1IDMR6_AM1:     equ    %00000010
mCAN1IDMR6_AM2:     equ    %00000100
mCAN1IDMR6_AM3:     equ    %00001000
mCAN1IDMR6_AM4:     equ    %00010000
mCAN1IDMR6_AM5:     equ    %00100000
mCAN1IDMR6_AM6:     equ    %01000000
mCAN1IDMR6_AM7:     equ    %10000000


;*** CAN1IDMR7 - MSCAN1 Identifier Mask Register 7; 0x0000019F ***
CAN1IDMR7:          equ    $0000019F                                ;*** CAN1IDMR7 - MSCAN1 Identifier Mask Register 7; 0x0000019F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR7_AM0:     equ    %00000001
mCAN1IDMR7_AM1:     equ    %00000010
mCAN1IDMR7_AM2:     equ    %00000100
mCAN1IDMR7_AM3:     equ    %00001000
mCAN1IDMR7_AM4:     equ    %00010000
mCAN1IDMR7_AM5:     equ    %00100000
mCAN1IDMR7_AM6:     equ    %01000000
mCAN1IDMR7_AM7:     equ    %10000000


;*** CAN1RXIDR0 - MSCAN1 Receive Identifier Register 0; 0x000001A0 ***
CAN1RXIDR0:         equ    $000001A0                                ;*** CAN1RXIDR0 - MSCAN1 Receive Identifier Register 0; 0x000001A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN1RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN1RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN1RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN1RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN1RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN1RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN1RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN1RXIDR0_ID21:   equ    %00000001
mCAN1RXIDR0_ID22:   equ    %00000010
mCAN1RXIDR0_ID23:   equ    %00000100
mCAN1RXIDR0_ID24:   equ    %00001000
mCAN1RXIDR0_ID25:   equ    %00010000
mCAN1RXIDR0_ID26:   equ    %00100000
mCAN1RXIDR0_ID27:   equ    %01000000
mCAN1RXIDR0_ID28:   equ    %10000000


;*** CAN1RXIDR1 - MSCAN1 Receive Identifier Register 1; 0x000001A1 ***
CAN1RXIDR1:         equ    $000001A1                                ;*** CAN1RXIDR1 - MSCAN1 Receive Identifier Register 1; 0x000001A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN1RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN1RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN1RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN1RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN1RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN1RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN1RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN1RXIDR1_ID15:   equ    %00000001
mCAN1RXIDR1_ID16:   equ    %00000010
mCAN1RXIDR1_ID17:   equ    %00000100
mCAN1RXIDR1_IDE:    equ    %00001000
mCAN1RXIDR1_SRR:    equ    %00010000
mCAN1RXIDR1_ID18:   equ    %00100000
mCAN1RXIDR1_ID19:   equ    %01000000
mCAN1RXIDR1_ID20:   equ    %10000000


;*** CAN1RXIDR2 - MSCAN1 Receive Identifier Register 2; 0x000001A2 ***
CAN1RXIDR2:         equ    $000001A2                                ;*** CAN1RXIDR2 - MSCAN1 Receive Identifier Register 2; 0x000001A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN1RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN1RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN1RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN1RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN1RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN1RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN1RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN1RXIDR2_ID7:    equ    %00000001
mCAN1RXIDR2_ID8:    equ    %00000010
mCAN1RXIDR2_ID9:    equ    %00000100
mCAN1RXIDR2_ID10:   equ    %00001000
mCAN1RXIDR2_ID11:   equ    %00010000
mCAN1RXIDR2_ID12:   equ    %00100000
mCAN1RXIDR2_ID13:   equ    %01000000
mCAN1RXIDR2_ID14:   equ    %10000000


;*** CAN1RXIDR3 - MSCAN1 Receive Identifier Register 3; 0x000001A3 ***
CAN1RXIDR3:         equ    $000001A3                                ;*** CAN1RXIDR3 - MSCAN1 Receive Identifier Register 3; 0x000001A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN1RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN1RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN1RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN1RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN1RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN1RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN1RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN1RXIDR3_RTR:    equ    %00000001
mCAN1RXIDR3_ID0:    equ    %00000010
mCAN1RXIDR3_ID1:    equ    %00000100
mCAN1RXIDR3_ID2:    equ    %00001000
mCAN1RXIDR3_ID3:    equ    %00010000
mCAN1RXIDR3_ID4:    equ    %00100000
mCAN1RXIDR3_ID5:    equ    %01000000
mCAN1RXIDR3_ID6:    equ    %10000000


;*** CAN1RXDSR0 - MSCAN1 Receive Data Segment Register 0; 0x000001A4 ***
CAN1RXDSR0:         equ    $000001A4                                ;*** CAN1RXDSR0 - MSCAN1 Receive Data Segment Register 0; 0x000001A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR0_DB0:    equ    %00000001
mCAN1RXDSR0_DB1:    equ    %00000010
mCAN1RXDSR0_DB2:    equ    %00000100
mCAN1RXDSR0_DB3:    equ    %00001000
mCAN1RXDSR0_DB4:    equ    %00010000
mCAN1RXDSR0_DB5:    equ    %00100000
mCAN1RXDSR0_DB6:    equ    %01000000
mCAN1RXDSR0_DB7:    equ    %10000000


;*** CAN1RXDSR1 - MSCAN1 Receive Data Segment Register 1; 0x000001A5 ***
CAN1RXDSR1:         equ    $000001A5                                ;*** CAN1RXDSR1 - MSCAN1 Receive Data Segment Register 1; 0x000001A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR1_DB0:    equ    %00000001
mCAN1RXDSR1_DB1:    equ    %00000010
mCAN1RXDSR1_DB2:    equ    %00000100
mCAN1RXDSR1_DB3:    equ    %00001000
mCAN1RXDSR1_DB4:    equ    %00010000
mCAN1RXDSR1_DB5:    equ    %00100000
mCAN1RXDSR1_DB6:    equ    %01000000
mCAN1RXDSR1_DB7:    equ    %10000000


;*** CAN1RXDSR2 - MSCAN1 Receive Data Segment Register 2; 0x000001A6 ***
CAN1RXDSR2:         equ    $000001A6                                ;*** CAN1RXDSR2 - MSCAN1 Receive Data Segment Register 2; 0x000001A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR2_DB0:    equ    %00000001
mCAN1RXDSR2_DB1:    equ    %00000010
mCAN1RXDSR2_DB2:    equ    %00000100
mCAN1RXDSR2_DB3:    equ    %00001000
mCAN1RXDSR2_DB4:    equ    %00010000
mCAN1RXDSR2_DB5:    equ    %00100000
mCAN1RXDSR2_DB6:    equ    %01000000
mCAN1RXDSR2_DB7:    equ    %10000000


;*** CAN1RXDSR3 - MSCAN1 Receive Data Segment Register 3; 0x000001A7 ***
CAN1RXDSR3:         equ    $000001A7                                ;*** CAN1RXDSR3 - MSCAN1 Receive Data Segment Register 3; 0x000001A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR3_DB0:    equ    %00000001
mCAN1RXDSR3_DB1:    equ    %00000010
mCAN1RXDSR3_DB2:    equ    %00000100
mCAN1RXDSR3_DB3:    equ    %00001000
mCAN1RXDSR3_DB4:    equ    %00010000
mCAN1RXDSR3_DB5:    equ    %00100000
mCAN1RXDSR3_DB6:    equ    %01000000
mCAN1RXDSR3_DB7:    equ    %10000000


;*** CAN1RXDSR4 - MSCAN1 Receive Data Segment Register 4; 0x000001A8 ***
CAN1RXDSR4:         equ    $000001A8                                ;*** CAN1RXDSR4 - MSCAN1 Receive Data Segment Register 4; 0x000001A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR4_DB0:    equ    %00000001
mCAN1RXDSR4_DB1:    equ    %00000010
mCAN1RXDSR4_DB2:    equ    %00000100
mCAN1RXDSR4_DB3:    equ    %00001000
mCAN1RXDSR4_DB4:    equ    %00010000
mCAN1RXDSR4_DB5:    equ    %00100000
mCAN1RXDSR4_DB6:    equ    %01000000
mCAN1RXDSR4_DB7:    equ    %10000000


;*** CAN1RXDSR5 - MSCAN1 Receive Data Segment Register 5; 0x000001A9 ***
CAN1RXDSR5:         equ    $000001A9                                ;*** CAN1RXDSR5 - MSCAN1 Receive Data Segment Register 5; 0x000001A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR5_DB0:    equ    %00000001
mCAN1RXDSR5_DB1:    equ    %00000010
mCAN1RXDSR5_DB2:    equ    %00000100
mCAN1RXDSR5_DB3:    equ    %00001000
mCAN1RXDSR5_DB4:    equ    %00010000
mCAN1RXDSR5_DB5:    equ    %00100000
mCAN1RXDSR5_DB6:    equ    %01000000
mCAN1RXDSR5_DB7:    equ    %10000000


;*** CAN1RXDSR6 - MSCAN1 Receive Data Segment Register 6; 0x000001AA ***
CAN1RXDSR6:         equ    $000001AA                                ;*** CAN1RXDSR6 - MSCAN1 Receive Data Segment Register 6; 0x000001AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR6_DB0:    equ    %00000001
mCAN1RXDSR6_DB1:    equ    %00000010
mCAN1RXDSR6_DB2:    equ    %00000100
mCAN1RXDSR6_DB3:    equ    %00001000
mCAN1RXDSR6_DB4:    equ    %00010000
mCAN1RXDSR6_DB5:    equ    %00100000
mCAN1RXDSR6_DB6:    equ    %01000000
mCAN1RXDSR6_DB7:    equ    %10000000


;*** CAN1RXDSR7 - MSCAN1 Receive Data Segment Register 7; 0x000001AB ***
CAN1RXDSR7:         equ    $000001AB                                ;*** CAN1RXDSR7 - MSCAN1 Receive Data Segment Register 7; 0x000001AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR7_DB0:    equ    %00000001
mCAN1RXDSR7_DB1:    equ    %00000010
mCAN1RXDSR7_DB2:    equ    %00000100
mCAN1RXDSR7_DB3:    equ    %00001000
mCAN1RXDSR7_DB4:    equ    %00010000
mCAN1RXDSR7_DB5:    equ    %00100000
mCAN1RXDSR7_DB6:    equ    %01000000
mCAN1RXDSR7_DB7:    equ    %10000000


;*** CAN1RXDLR - MSCAN1 Receive Data Length Register; 0x000001AC ***
CAN1RXDLR:          equ    $000001AC                                ;*** CAN1RXDLR - MSCAN1 Receive Data Length Register; 0x000001AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN1RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN1RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN1RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN1RXDLR_DLC0:    equ    %00000001
mCAN1RXDLR_DLC1:    equ    %00000010
mCAN1RXDLR_DLC2:    equ    %00000100
mCAN1RXDLR_DLC3:    equ    %00001000


;*** CAN1RXTSR - MSCAN1 Receive Time Stamp Register; 0x000001AE ***
CAN1RXTSR:          equ    $000001AE                                ;*** CAN1RXTSR - MSCAN1 Receive Time Stamp Register; 0x000001AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN1RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN1RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN1RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN1RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN1RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN1RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN1RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN1RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN1RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN1RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN1RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN1RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN1RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN1RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN1RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN1RXTSR_TSR0:    equ    %00000001
mCAN1RXTSR_TSR1:    equ    %00000010
mCAN1RXTSR_TSR2:    equ    %00000100
mCAN1RXTSR_TSR3:    equ    %00001000
mCAN1RXTSR_TSR4:    equ    %00010000
mCAN1RXTSR_TSR5:    equ    %00100000
mCAN1RXTSR_TSR6:    equ    %01000000
mCAN1RXTSR_TSR7:    equ    %10000000
mCAN1RXTSR_TSR8:    equ    %100000000
mCAN1RXTSR_TSR9:    equ    %1000000000
mCAN1RXTSR_TSR10:   equ    %10000000000
mCAN1RXTSR_TSR11:   equ    %100000000000
mCAN1RXTSR_TSR12:   equ    %1000000000000
mCAN1RXTSR_TSR13:   equ    %10000000000000
mCAN1RXTSR_TSR14:   equ    %100000000000000
mCAN1RXTSR_TSR15:   equ    %1000000000000000


;*** CAN1RXTSRH - MSCAN1 Receive Time Stamp Register High; 0x000001AE ***
CAN1RXTSRH:         equ    $000001AE                                ;*** CAN1RXTSRH - MSCAN1 Receive Time Stamp Register High; 0x000001AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN1RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN1RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN1RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN1RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN1RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN1RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN1RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN1RXTSRH_TSR8:   equ    %00000001
mCAN1RXTSRH_TSR9:   equ    %00000010
mCAN1RXTSRH_TSR10:  equ    %00000100
mCAN1RXTSRH_TSR11:  equ    %00001000
mCAN1RXTSRH_TSR12:  equ    %00010000
mCAN1RXTSRH_TSR13:  equ    %00100000
mCAN1RXTSRH_TSR14:  equ    %01000000
mCAN1RXTSRH_TSR15:  equ    %10000000


;*** CAN1RXTSRL - MSCAN1 Receive Time Stamp Register Low; 0x000001AF ***
CAN1RXTSRL:         equ    $000001AF                                ;*** CAN1RXTSRL - MSCAN1 Receive Time Stamp Register Low; 0x000001AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN1RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN1RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN1RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN1RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN1RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN1RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN1RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN1RXTSRL_TSR0:   equ    %00000001
mCAN1RXTSRL_TSR1:   equ    %00000010
mCAN1RXTSRL_TSR2:   equ    %00000100
mCAN1RXTSRL_TSR3:   equ    %00001000
mCAN1RXTSRL_TSR4:   equ    %00010000
mCAN1RXTSRL_TSR5:   equ    %00100000
mCAN1RXTSRL_TSR6:   equ    %01000000
mCAN1RXTSRL_TSR7:   equ    %10000000


;*** CAN1TXIDR0 - MSCAN1 Transmit Identifier Register 0; 0x000001B0 ***
CAN1TXIDR0:         equ    $000001B0                                ;*** CAN1TXIDR0 - MSCAN1 Transmit Identifier Register 0; 0x000001B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN1TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN1TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN1TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN1TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN1TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN1TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN1TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN1TXIDR0_ID21:   equ    %00000001
mCAN1TXIDR0_ID22:   equ    %00000010
mCAN1TXIDR0_ID23:   equ    %00000100
mCAN1TXIDR0_ID24:   equ    %00001000
mCAN1TXIDR0_ID25:   equ    %00010000
mCAN1TXIDR0_ID26:   equ    %00100000
mCAN1TXIDR0_ID27:   equ    %01000000
mCAN1TXIDR0_ID28:   equ    %10000000


;*** CAN1TXIDR1 - MSCAN1 Transmit Identifier Register 1; 0x000001B1 ***
CAN1TXIDR1:         equ    $000001B1                                ;*** CAN1TXIDR1 - MSCAN1 Transmit Identifier Register 1; 0x000001B1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN1TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN1TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN1TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN1TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN1TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN1TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN1TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN1TXIDR1_ID15:   equ    %00000001
mCAN1TXIDR1_ID16:   equ    %00000010
mCAN1TXIDR1_ID17:   equ    %00000100
mCAN1TXIDR1_IDE:    equ    %00001000
mCAN1TXIDR1_SRR:    equ    %00010000
mCAN1TXIDR1_ID18:   equ    %00100000
mCAN1TXIDR1_ID19:   equ    %01000000
mCAN1TXIDR1_ID20:   equ    %10000000


;*** CAN1TXIDR2 - MSCAN1 Transmit Identifier Register 2; 0x000001B2 ***
CAN1TXIDR2:         equ    $000001B2                                ;*** CAN1TXIDR2 - MSCAN1 Transmit Identifier Register 2; 0x000001B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN1TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN1TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN1TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN1TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN1TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN1TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN1TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN1TXIDR2_ID7:    equ    %00000001
mCAN1TXIDR2_ID8:    equ    %00000010
mCAN1TXIDR2_ID9:    equ    %00000100
mCAN1TXIDR2_ID10:   equ    %00001000
mCAN1TXIDR2_ID11:   equ    %00010000
mCAN1TXIDR2_ID12:   equ    %00100000
mCAN1TXIDR2_ID13:   equ    %01000000
mCAN1TXIDR2_ID14:   equ    %10000000


;*** CAN1TXIDR3 - MSCAN1 Transmit Identifier Register 3; 0x000001B3 ***
CAN1TXIDR3:         equ    $000001B3                                ;*** CAN1TXIDR3 - MSCAN1 Transmit Identifier Register 3; 0x000001B3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN1TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN1TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN1TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN1TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN1TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN1TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN1TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN1TXIDR3_RTR:    equ    %00000001
mCAN1TXIDR3_ID0:    equ    %00000010
mCAN1TXIDR3_ID1:    equ    %00000100
mCAN1TXIDR3_ID2:    equ    %00001000
mCAN1TXIDR3_ID3:    equ    %00010000
mCAN1TXIDR3_ID4:    equ    %00100000
mCAN1TXIDR3_ID5:    equ    %01000000
mCAN1TXIDR3_ID6:    equ    %10000000


;*** CAN1TXDSR0 - MSCAN1 Transmit Data Segment Register 0; 0x000001B4 ***
CAN1TXDSR0:         equ    $000001B4                                ;*** CAN1TXDSR0 - MSCAN1 Transmit Data Segment Register 0; 0x000001B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR0_DB0:    equ    %00000001
mCAN1TXDSR0_DB1:    equ    %00000010
mCAN1TXDSR0_DB2:    equ    %00000100
mCAN1TXDSR0_DB3:    equ    %00001000
mCAN1TXDSR0_DB4:    equ    %00010000
mCAN1TXDSR0_DB5:    equ    %00100000
mCAN1TXDSR0_DB6:    equ    %01000000
mCAN1TXDSR0_DB7:    equ    %10000000


;*** CAN1TXDSR1 - MSCAN1 Transmit Data Segment Register 1; 0x000001B5 ***
CAN1TXDSR1:         equ    $000001B5                                ;*** CAN1TXDSR1 - MSCAN1 Transmit Data Segment Register 1; 0x000001B5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR1_DB0:    equ    %00000001
mCAN1TXDSR1_DB1:    equ    %00000010
mCAN1TXDSR1_DB2:    equ    %00000100
mCAN1TXDSR1_DB3:    equ    %00001000
mCAN1TXDSR1_DB4:    equ    %00010000
mCAN1TXDSR1_DB5:    equ    %00100000
mCAN1TXDSR1_DB6:    equ    %01000000
mCAN1TXDSR1_DB7:    equ    %10000000


;*** CAN1TXDSR2 - MSCAN1 Transmit Data Segment Register 2; 0x000001B6 ***
CAN1TXDSR2:         equ    $000001B6                                ;*** CAN1TXDSR2 - MSCAN1 Transmit Data Segment Register 2; 0x000001B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR2_DB0:    equ    %00000001
mCAN1TXDSR2_DB1:    equ    %00000010
mCAN1TXDSR2_DB2:    equ    %00000100
mCAN1TXDSR2_DB3:    equ    %00001000
mCAN1TXDSR2_DB4:    equ    %00010000
mCAN1TXDSR2_DB5:    equ    %00100000
mCAN1TXDSR2_DB6:    equ    %01000000
mCAN1TXDSR2_DB7:    equ    %10000000


;*** CAN1TXDSR3 - MSCAN1 Transmit Data Segment Register 3; 0x000001B7 ***
CAN1TXDSR3:         equ    $000001B7                                ;*** CAN1TXDSR3 - MSCAN1 Transmit Data Segment Register 3; 0x000001B7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR3_DB0:    equ    %00000001
mCAN1TXDSR3_DB1:    equ    %00000010
mCAN1TXDSR3_DB2:    equ    %00000100
mCAN1TXDSR3_DB3:    equ    %00001000
mCAN1TXDSR3_DB4:    equ    %00010000
mCAN1TXDSR3_DB5:    equ    %00100000
mCAN1TXDSR3_DB6:    equ    %01000000
mCAN1TXDSR3_DB7:    equ    %10000000


;*** CAN1TXDSR4 - MSCAN1 Transmit Data Segment Register 4; 0x000001B8 ***
CAN1TXDSR4:         equ    $000001B8                                ;*** CAN1TXDSR4 - MSCAN1 Transmit Data Segment Register 4; 0x000001B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR4_DB0:    equ    %00000001
mCAN1TXDSR4_DB1:    equ    %00000010
mCAN1TXDSR4_DB2:    equ    %00000100
mCAN1TXDSR4_DB3:    equ    %00001000
mCAN1TXDSR4_DB4:    equ    %00010000
mCAN1TXDSR4_DB5:    equ    %00100000
mCAN1TXDSR4_DB6:    equ    %01000000
mCAN1TXDSR4_DB7:    equ    %10000000


;*** CAN1TXDSR5 - MSCAN1 Transmit Data Segment Register 5; 0x000001B9 ***
CAN1TXDSR5:         equ    $000001B9                                ;*** CAN1TXDSR5 - MSCAN1 Transmit Data Segment Register 5; 0x000001B9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR5_DB0:    equ    %00000001
mCAN1TXDSR5_DB1:    equ    %00000010
mCAN1TXDSR5_DB2:    equ    %00000100
mCAN1TXDSR5_DB3:    equ    %00001000
mCAN1TXDSR5_DB4:    equ    %00010000
mCAN1TXDSR5_DB5:    equ    %00100000
mCAN1TXDSR5_DB6:    equ    %01000000
mCAN1TXDSR5_DB7:    equ    %10000000


;*** CAN1TXDSR6 - MSCAN1 Transmit Data Segment Register 6; 0x000001BA ***
CAN1TXDSR6:         equ    $000001BA                                ;*** CAN1TXDSR6 - MSCAN1 Transmit Data Segment Register 6; 0x000001BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR6_DB0:    equ    %00000001
mCAN1TXDSR6_DB1:    equ    %00000010
mCAN1TXDSR6_DB2:    equ    %00000100
mCAN1TXDSR6_DB3:    equ    %00001000
mCAN1TXDSR6_DB4:    equ    %00010000
mCAN1TXDSR6_DB5:    equ    %00100000
mCAN1TXDSR6_DB6:    equ    %01000000
mCAN1TXDSR6_DB7:    equ    %10000000


;*** CAN1TXDSR7 - MSCAN1 Transmit Data Segment Register 7; 0x000001BB ***
CAN1TXDSR7:         equ    $000001BB                                ;*** CAN1TXDSR7 - MSCAN1 Transmit Data Segment Register 7; 0x000001BB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR7_DB0:    equ    %00000001
mCAN1TXDSR7_DB1:    equ    %00000010
mCAN1TXDSR7_DB2:    equ    %00000100
mCAN1TXDSR7_DB3:    equ    %00001000
mCAN1TXDSR7_DB4:    equ    %00010000
mCAN1TXDSR7_DB5:    equ    %00100000
mCAN1TXDSR7_DB6:    equ    %01000000
mCAN1TXDSR7_DB7:    equ    %10000000


;*** CAN1TXDLR - MSCAN1 Transmit Data Length Register; 0x000001BC ***
CAN1TXDLR:          equ    $000001BC                                ;*** CAN1TXDLR - MSCAN1 Transmit Data Length Register; 0x000001BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN1TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN1TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN1TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN1TXDLR_DLC0:    equ    %00000001
mCAN1TXDLR_DLC1:    equ    %00000010
mCAN1TXDLR_DLC2:    equ    %00000100
mCAN1TXDLR_DLC3:    equ    %00001000


;*** CAN1TXTBPR - MSCAN1 Transmit Buffer Priority; 0x000001BD ***
CAN1TXTBPR:         equ    $000001BD                                ;*** CAN1TXTBPR - MSCAN1 Transmit Buffer Priority; 0x000001BD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN1TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN1TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN1TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN1TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN1TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN1TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN1TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN1TXTBPR_PRIO0:  equ    %00000001
mCAN1TXTBPR_PRIO1:  equ    %00000010
mCAN1TXTBPR_PRIO2:  equ    %00000100
mCAN1TXTBPR_PRIO3:  equ    %00001000
mCAN1TXTBPR_PRIO4:  equ    %00010000
mCAN1TXTBPR_PRIO5:  equ    %00100000
mCAN1TXTBPR_PRIO6:  equ    %01000000
mCAN1TXTBPR_PRIO7:  equ    %10000000


;*** CAN1TXTSR - MSCAN1 Transmit Time Stamp Register; 0x000001BE ***
CAN1TXTSR:          equ    $000001BE                                ;*** CAN1TXTSR - MSCAN1 Transmit Time Stamp Register; 0x000001BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN1TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN1TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN1TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN1TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN1TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN1TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN1TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN1TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN1TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN1TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN1TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN1TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN1TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN1TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN1TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN1TXTSR_TSR0:    equ    %00000001
mCAN1TXTSR_TSR1:    equ    %00000010
mCAN1TXTSR_TSR2:    equ    %00000100
mCAN1TXTSR_TSR3:    equ    %00001000
mCAN1TXTSR_TSR4:    equ    %00010000
mCAN1TXTSR_TSR5:    equ    %00100000
mCAN1TXTSR_TSR6:    equ    %01000000
mCAN1TXTSR_TSR7:    equ    %10000000
mCAN1TXTSR_TSR8:    equ    %100000000
mCAN1TXTSR_TSR9:    equ    %1000000000
mCAN1TXTSR_TSR10:   equ    %10000000000
mCAN1TXTSR_TSR11:   equ    %100000000000
mCAN1TXTSR_TSR12:   equ    %1000000000000
mCAN1TXTSR_TSR13:   equ    %10000000000000
mCAN1TXTSR_TSR14:   equ    %100000000000000
mCAN1TXTSR_TSR15:   equ    %1000000000000000


;*** CAN1TXTSRH - MSCAN1 Transmit Time Stamp Register High; 0x000001BE ***
CAN1TXTSRH:         equ    $000001BE                                ;*** CAN1TXTSRH - MSCAN1 Transmit Time Stamp Register High; 0x000001BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN1TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN1TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN1TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN1TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN1TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN1TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN1TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN1TXTSRH_TSR8:   equ    %00000001
mCAN1TXTSRH_TSR9:   equ    %00000010
mCAN1TXTSRH_TSR10:  equ    %00000100
mCAN1TXTSRH_TSR11:  equ    %00001000
mCAN1TXTSRH_TSR12:  equ    %00010000
mCAN1TXTSRH_TSR13:  equ    %00100000
mCAN1TXTSRH_TSR14:  equ    %01000000
mCAN1TXTSRH_TSR15:  equ    %10000000


;*** CAN1TXTSRL - MSCAN1 Transmit Time Stamp Register Low; 0x000001BF ***
CAN1TXTSRL:         equ    $000001BF                                ;*** CAN1TXTSRL - MSCAN1 Transmit Time Stamp Register Low; 0x000001BF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN1TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN1TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN1TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN1TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN1TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN1TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN1TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN1TXTSRL_TSR0:   equ    %00000001
mCAN1TXTSRL_TSR1:   equ    %00000010
mCAN1TXTSRL_TSR2:   equ    %00000100
mCAN1TXTSRL_TSR3:   equ    %00001000
mCAN1TXTSRL_TSR4:   equ    %00010000
mCAN1TXTSRL_TSR5:   equ    %00100000
mCAN1TXTSRL_TSR6:   equ    %01000000
mCAN1TXTSRL_TSR7:   equ    %10000000


;*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***
MCCTL0:             equ    $000001C0                                ;*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL0_MCTOIF:      equ    0                                         ; Motor Controller Timer Counter Overflow Interrupt Flag
MCCTL0_DITH:        equ    2                                         ; Motor Control/Driver Dither Feature Enable
MCCTL0_FAST:        equ    3                                         ; Motor Controller PWM Resolution Mode
MCCTL0_MCSWAI:      equ    4                                         ; Motor Controller Module Stop in Wait Mode
MCCTL0_MCPRE0:      equ    5                                         ; Motor Controller Prescaler Select, bit 0
MCCTL0_MCPRE1:      equ    6                                         ; Motor Controller Prescaler Select, bit 1
; bit position masks
mMCCTL0_MCTOIF:     equ    %00000001
mMCCTL0_DITH:       equ    %00000100
mMCCTL0_FAST:       equ    %00001000
mMCCTL0_MCSWAI:     equ    %00010000
mMCCTL0_MCPRE0:     equ    %00100000
mMCCTL0_MCPRE1:     equ    %01000000


;*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***
MCCTL1:             equ    $000001C1                                ;*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL1_MCTOIE:      equ    0                                         ; Motor Controller Timer Counter Overflow Interrupt Enable
MCCTL1_RECIRC:      equ    7                                         ; Recirculation in (Dual) Full H-Bridge Mode
; bit position masks
mMCCTL1_MCTOIE:     equ    %00000001
mMCCTL1_RECIRC:     equ    %10000000


;*** MCPER - Motor Controller Period Register; 0x000001C2 ***
MCPER:              equ    $000001C2                                ;*** MCPER - Motor Controller Period Register; 0x000001C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCPER_P0:           equ    0                                         ; Motor Controller Period Bit 1
MCPER_P1:           equ    1                                         ; Motor Controller Period, bit 1
MCPER_P2:           equ    2                                         ; Motor Controller Period, bit 2
MCPER_P3:           equ    3                                         ; Motor Controller Period, bit 3
MCPER_P4:           equ    4                                         ; Motor Controller Period, bit 4
MCPER_P5:           equ    5                                         ; Motor Controller Period, bit 5
MCPER_P6:           equ    6                                         ; Motor Controller Period, bit 6
MCPER_P7:           equ    7                                         ; Motor Controller Period, bit 7
MCPER_P8:           equ    8                                         ; Motor Controller Period, bit 8
MCPER_P9:           equ    9                                         ; Motor Controller Period, bit 9
MCPER_P10:          equ    10                                        ; Motor Controller Period, bit 10
; bit position masks
mMCPER_P0:          equ    %00000001
mMCPER_P1:          equ    %00000010
mMCPER_P2:          equ    %00000100
mMCPER_P3:          equ    %00001000
mMCPER_P4:          equ    %00010000
mMCPER_P5:          equ    %00100000
mMCPER_P6:          equ    %01000000
mMCPER_P7:          equ    %10000000
mMCPER_P8:          equ    %100000000
mMCPER_P9:          equ    %1000000000
mMCPER_P10:         equ    %10000000000


;*** MCCC0 - Motor Controller Control Register 0; 0x000001D0 ***
MCCC0:              equ    $000001D0                                ;*** MCCC0 - Motor Controller Control Register 0; 0x000001D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC0_CD0:          equ    0                                         ; PWM Channel Delay
MCCC0_CD1:          equ    1                                         ; PWM Channel Delay
MCCC0_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC0_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC0_MCOM0:        equ    6                                         ; Output Mode
MCCC0_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC0_CD0:         equ    %00000001
mMCCC0_CD1:         equ    %00000010
mMCCC0_MCAM0:       equ    %00010000
mMCCC0_MCAM1:       equ    %00100000
mMCCC0_MCOM0:       equ    %01000000
mMCCC0_MCOM1:       equ    %10000000


;*** MCCC1 - Motor Controller Control Register 1; 0x000001D1 ***
MCCC1:              equ    $000001D1                                ;*** MCCC1 - Motor Controller Control Register 1; 0x000001D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC1_CD0:          equ    0                                         ; PWM Channel Delay
MCCC1_CD1:          equ    1                                         ; PWM Channel Delay
MCCC1_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC1_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC1_MCOM0:        equ    6                                         ; Output Mode
MCCC1_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC1_CD0:         equ    %00000001
mMCCC1_CD1:         equ    %00000010
mMCCC1_MCAM0:       equ    %00010000
mMCCC1_MCAM1:       equ    %00100000
mMCCC1_MCOM0:       equ    %01000000
mMCCC1_MCOM1:       equ    %10000000


;*** MCCC2 - Motor Controller Control Register 2; 0x000001D2 ***
MCCC2:              equ    $000001D2                                ;*** MCCC2 - Motor Controller Control Register 2; 0x000001D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC2_CD0:          equ    0                                         ; PWM Channel Delay
MCCC2_CD1:          equ    1                                         ; PWM Channel Delay
MCCC2_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC2_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC2_MCOM0:        equ    6                                         ; Output Mode
MCCC2_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC2_CD0:         equ    %00000001
mMCCC2_CD1:         equ    %00000010
mMCCC2_MCAM0:       equ    %00010000
mMCCC2_MCAM1:       equ    %00100000
mMCCC2_MCOM0:       equ    %01000000
mMCCC2_MCOM1:       equ    %10000000


;*** MCCC3 - Motor Controller Control Register 3; 0x000001D3 ***
MCCC3:              equ    $000001D3                                ;*** MCCC3 - Motor Controller Control Register 3; 0x000001D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC3_CD0:          equ    0                                         ; PWM Channel Delay
MCCC3_CD1:          equ    1                                         ; PWM Channel Delay
MCCC3_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC3_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC3_MCOM0:        equ    6                                         ; Output Mode
MCCC3_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC3_CD0:         equ    %00000001
mMCCC3_CD1:         equ    %00000010
mMCCC3_MCAM0:       equ    %00010000
mMCCC3_MCAM1:       equ    %00100000
mMCCC3_MCOM0:       equ    %01000000
mMCCC3_MCOM1:       equ    %10000000


;*** MCCC4 - Motor Controller Control Register 4; 0x000001D4 ***
MCCC4:              equ    $000001D4                                ;*** MCCC4 - Motor Controller Control Register 4; 0x000001D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC4_CD0:          equ    0                                         ; PWM Channel Delay
MCCC4_CD1:          equ    1                                         ; PWM Channel Delay
MCCC4_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC4_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC4_MCOM0:        equ    6                                         ; Output Mode
MCCC4_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC4_CD0:         equ    %00000001
mMCCC4_CD1:         equ    %00000010
mMCCC4_MCAM0:       equ    %00010000
mMCCC4_MCAM1:       equ    %00100000
mMCCC4_MCOM0:       equ    %01000000
mMCCC4_MCOM1:       equ    %10000000


;*** MCCC5 - Motor Controller Control Register 5; 0x000001D5 ***
MCCC5:              equ    $000001D5                                ;*** MCCC5 - Motor Controller Control Register 5; 0x000001D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC5_CD0:          equ    0                                         ; PWM Channel Delay
MCCC5_CD1:          equ    1                                         ; PWM Channel Delay
MCCC5_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC5_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC5_MCOM0:        equ    6                                         ; Output Mode
MCCC5_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC5_CD0:         equ    %00000001
mMCCC5_CD1:         equ    %00000010
mMCCC5_MCAM0:       equ    %00010000
mMCCC5_MCAM1:       equ    %00100000
mMCCC5_MCOM0:       equ    %01000000
mMCCC5_MCOM1:       equ    %10000000


;*** MCCC6 - Motor Controller Control Register 6; 0x000001D6 ***
MCCC6:              equ    $000001D6                                ;*** MCCC6 - Motor Controller Control Register 6; 0x000001D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC6_CD0:          equ    0                                         ; PWM Channel Delay
MCCC6_CD1:          equ    1                                         ; PWM Channel Delay
MCCC6_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC6_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC6_MCOM0:        equ    6                                         ; Output Mode
MCCC6_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC6_CD0:         equ    %00000001
mMCCC6_CD1:         equ    %00000010
mMCCC6_MCAM0:       equ    %00010000
mMCCC6_MCAM1:       equ    %00100000
mMCCC6_MCOM0:       equ    %01000000
mMCCC6_MCOM1:       equ    %10000000


;*** MCCC7 - Motor Controller Control Register 7; 0x000001D7 ***
MCCC7:              equ    $000001D7                                ;*** MCCC7 - Motor Controller Control Register 7; 0x000001D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC7_CD0:          equ    0                                         ; PWM Channel Delay
MCCC7_CD1:          equ    1                                         ; PWM Channel Delay
MCCC7_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC7_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC7_MCOM0:        equ    6                                         ; Output Mode
MCCC7_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC7_CD0:         equ    %00000001
mMCCC7_CD1:         equ    %00000010
mMCCC7_MCAM0:       equ    %00010000
mMCCC7_MCAM1:       equ    %00100000
mMCCC7_MCOM0:       equ    %01000000
mMCCC7_MCOM1:       equ    %10000000


;*** MCCC8 - Motor Controller Control Register 8; 0x000001D8 ***
MCCC8:              equ    $000001D8                                ;*** MCCC8 - Motor Controller Control Register 8; 0x000001D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC8_CD0:          equ    0                                         ; PWM Channel Delay
MCCC8_CD1:          equ    1                                         ; PWM Channel Delay
MCCC8_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC8_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC8_MCOM0:        equ    6                                         ; Output Mode
MCCC8_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC8_CD0:         equ    %00000001
mMCCC8_CD1:         equ    %00000010
mMCCC8_MCAM0:       equ    %00010000
mMCCC8_MCAM1:       equ    %00100000
mMCCC8_MCOM0:       equ    %01000000
mMCCC8_MCOM1:       equ    %10000000


;*** MCCC9 - Motor Controller Control Register 9; 0x000001D9 ***
MCCC9:              equ    $000001D9                                ;*** MCCC9 - Motor Controller Control Register 9; 0x000001D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC9_CD0:          equ    0                                         ; PWM Channel Delay
MCCC9_CD1:          equ    1                                         ; PWM Channel Delay
MCCC9_MCAM0:        equ    4                                         ; PWM Channel Alignment Mode
MCCC9_MCAM1:        equ    5                                         ; PWM Channel Alignment Mode
MCCC9_MCOM0:        equ    6                                         ; Output Mode
MCCC9_MCOM1:        equ    7                                         ; Output Mode
; bit position masks
mMCCC9_CD0:         equ    %00000001
mMCCC9_CD1:         equ    %00000010
mMCCC9_MCAM0:       equ    %00010000
mMCCC9_MCAM1:       equ    %00100000
mMCCC9_MCOM0:       equ    %01000000
mMCCC9_MCOM1:       equ    %10000000


;*** MCCC10 - Motor Controller Control Register 10; 0x000001DA ***
MCCC10:             equ    $000001DA                                ;*** MCCC10 - Motor Controller Control Register 10; 0x000001DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC10_CD0:         equ    0                                         ; PWM Channel Delay
MCCC10_CD1:         equ    1                                         ; PWM Channel Delay
MCCC10_MCAM0:       equ    4                                         ; PWM Channel Alignment Mode
MCCC10_MCAM1:       equ    5                                         ; PWM Channel Alignment Mode
MCCC10_MCOM0:       equ    6                                         ; Output Mode
MCCC10_MCOM1:       equ    7                                         ; Output Mode
; bit position masks
mMCCC10_CD0:        equ    %00000001
mMCCC10_CD1:        equ    %00000010
mMCCC10_MCAM0:      equ    %00010000
mMCCC10_MCAM1:      equ    %00100000
mMCCC10_MCOM0:      equ    %01000000
mMCCC10_MCOM1:      equ    %10000000


;*** MCCC11 - Motor Controller Control Register 11; 0x000001DB ***
MCCC11:             equ    $000001DB                                ;*** MCCC11 - Motor Controller Control Register 11; 0x000001DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCC11_CD0:         equ    0                                         ; PWM Channel Delay
MCCC11_CD1:         equ    1                                         ; PWM Channel Delay
MCCC11_MCAM0:       equ    4                                         ; PWM Channel Alignment Mode
MCCC11_MCAM1:       equ    5                                         ; PWM Channel Alignment Mode
MCCC11_MCOM0:       equ    6                                         ; Output Mode
MCCC11_MCOM1:       equ    7                                         ; Output Mode
; bit position masks
mMCCC11_CD0:        equ    %00000001
mMCCC11_CD1:        equ    %00000010
mMCCC11_MCAM0:      equ    %00010000
mMCCC11_MCAM1:      equ    %00100000
mMCCC11_MCOM0:      equ    %01000000
mMCCC11_MCOM1:      equ    %10000000


;*** MCDC0 - Motor Controller Period Register 0; 0x000001E0 ***
MCDC0:              equ    $000001E0                                ;*** MCDC0 - Motor Controller Period Register 0; 0x000001E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC0_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC0_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC0_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC0_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC0_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC0_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC0_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC0_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC0_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC0_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC0_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC0_S:            equ    15                                        ; Sign
; bit position masks
mMCDC0_D0:          equ    %00000001
mMCDC0_D1:          equ    %00000010
mMCDC0_D2:          equ    %00000100
mMCDC0_D3:          equ    %00001000
mMCDC0_D4:          equ    %00010000
mMCDC0_D5:          equ    %00100000
mMCDC0_D6:          equ    %01000000
mMCDC0_D7:          equ    %10000000
mMCDC0_D8:          equ    %100000000
mMCDC0_D9:          equ    %1000000000
mMCDC0_D10:         equ    %10000000000
mMCDC0_S:           equ    %1000000000000000


;*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***
MCDC0_FAST:         equ    $000001E0                                ;*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC0_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC0_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC0_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC0_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC0_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC0_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC0_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC0_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC0_FAST_D2:     equ    %00000001
mMCDC0_FAST_D3:     equ    %00000010
mMCDC0_FAST_D4:     equ    %00000100
mMCDC0_FAST_D5:     equ    %00001000
mMCDC0_FAST_D6:     equ    %00010000
mMCDC0_FAST_D7:     equ    %00100000
mMCDC0_FAST_D8:     equ    %01000000
mMCDC0_FAST_S:      equ    %10000000


;*** MCDC1 - Motor Controller Period Register 1; 0x000001E2 ***
MCDC1:              equ    $000001E2                                ;*** MCDC1 - Motor Controller Period Register 1; 0x000001E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC1_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC1_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC1_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC1_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC1_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC1_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC1_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC1_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC1_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC1_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC1_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC1_S:            equ    15                                        ; Sign
; bit position masks
mMCDC1_D0:          equ    %00000001
mMCDC1_D1:          equ    %00000010
mMCDC1_D2:          equ    %00000100
mMCDC1_D3:          equ    %00001000
mMCDC1_D4:          equ    %00010000
mMCDC1_D5:          equ    %00100000
mMCDC1_D6:          equ    %01000000
mMCDC1_D7:          equ    %10000000
mMCDC1_D8:          equ    %100000000
mMCDC1_D9:          equ    %1000000000
mMCDC1_D10:         equ    %10000000000
mMCDC1_S:           equ    %1000000000000000


;*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***
MCDC1_FAST:         equ    $000001E2                                ;*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC1_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC1_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC1_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC1_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC1_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC1_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC1_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC1_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC1_FAST_D2:     equ    %00000001
mMCDC1_FAST_D3:     equ    %00000010
mMCDC1_FAST_D4:     equ    %00000100
mMCDC1_FAST_D5:     equ    %00001000
mMCDC1_FAST_D6:     equ    %00010000
mMCDC1_FAST_D7:     equ    %00100000
mMCDC1_FAST_D8:     equ    %01000000
mMCDC1_FAST_S:      equ    %10000000


;*** MCDC2 - Motor Controller Period Register 2; 0x000001E4 ***
MCDC2:              equ    $000001E4                                ;*** MCDC2 - Motor Controller Period Register 2; 0x000001E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC2_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC2_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC2_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC2_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC2_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC2_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC2_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC2_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC2_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC2_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC2_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC2_S:            equ    15                                        ; Sign
; bit position masks
mMCDC2_D0:          equ    %00000001
mMCDC2_D1:          equ    %00000010
mMCDC2_D2:          equ    %00000100
mMCDC2_D3:          equ    %00001000
mMCDC2_D4:          equ    %00010000
mMCDC2_D5:          equ    %00100000
mMCDC2_D6:          equ    %01000000
mMCDC2_D7:          equ    %10000000
mMCDC2_D8:          equ    %100000000
mMCDC2_D9:          equ    %1000000000
mMCDC2_D10:         equ    %10000000000
mMCDC2_S:           equ    %1000000000000000


;*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***
MCDC2_FAST:         equ    $000001E4                                ;*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC2_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC2_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC2_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC2_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC2_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC2_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC2_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC2_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC2_FAST_D2:     equ    %00000001
mMCDC2_FAST_D3:     equ    %00000010
mMCDC2_FAST_D4:     equ    %00000100
mMCDC2_FAST_D5:     equ    %00001000
mMCDC2_FAST_D6:     equ    %00010000
mMCDC2_FAST_D7:     equ    %00100000
mMCDC2_FAST_D8:     equ    %01000000
mMCDC2_FAST_S:      equ    %10000000


;*** MCDC3 - Motor Controller Period Register 3; 0x000001E6 ***
MCDC3:              equ    $000001E6                                ;*** MCDC3 - Motor Controller Period Register 3; 0x000001E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC3_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC3_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC3_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC3_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC3_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC3_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC3_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC3_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC3_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC3_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC3_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC3_S:            equ    15                                        ; Sign
; bit position masks
mMCDC3_D0:          equ    %00000001
mMCDC3_D1:          equ    %00000010
mMCDC3_D2:          equ    %00000100
mMCDC3_D3:          equ    %00001000
mMCDC3_D4:          equ    %00010000
mMCDC3_D5:          equ    %00100000
mMCDC3_D6:          equ    %01000000
mMCDC3_D7:          equ    %10000000
mMCDC3_D8:          equ    %100000000
mMCDC3_D9:          equ    %1000000000
mMCDC3_D10:         equ    %10000000000
mMCDC3_S:           equ    %1000000000000000


;*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***
MCDC3_FAST:         equ    $000001E6                                ;*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC3_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC3_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC3_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC3_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC3_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC3_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC3_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC3_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC3_FAST_D2:     equ    %00000001
mMCDC3_FAST_D3:     equ    %00000010
mMCDC3_FAST_D4:     equ    %00000100
mMCDC3_FAST_D5:     equ    %00001000
mMCDC3_FAST_D6:     equ    %00010000
mMCDC3_FAST_D7:     equ    %00100000
mMCDC3_FAST_D8:     equ    %01000000
mMCDC3_FAST_S:      equ    %10000000


;*** MCDC4 - Motor Controller Period Register 4; 0x000001E8 ***
MCDC4:              equ    $000001E8                                ;*** MCDC4 - Motor Controller Period Register 4; 0x000001E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC4_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC4_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC4_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC4_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC4_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC4_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC4_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC4_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC4_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC4_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC4_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC4_S:            equ    15                                        ; Sign
; bit position masks
mMCDC4_D0:          equ    %00000001
mMCDC4_D1:          equ    %00000010
mMCDC4_D2:          equ    %00000100
mMCDC4_D3:          equ    %00001000
mMCDC4_D4:          equ    %00010000
mMCDC4_D5:          equ    %00100000
mMCDC4_D6:          equ    %01000000
mMCDC4_D7:          equ    %10000000
mMCDC4_D8:          equ    %100000000
mMCDC4_D9:          equ    %1000000000
mMCDC4_D10:         equ    %10000000000
mMCDC4_S:           equ    %1000000000000000


;*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***
MCDC4_FAST:         equ    $000001E8                                ;*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC4_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC4_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC4_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC4_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC4_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC4_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC4_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC4_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC4_FAST_D2:     equ    %00000001
mMCDC4_FAST_D3:     equ    %00000010
mMCDC4_FAST_D4:     equ    %00000100
mMCDC4_FAST_D5:     equ    %00001000
mMCDC4_FAST_D6:     equ    %00010000
mMCDC4_FAST_D7:     equ    %00100000
mMCDC4_FAST_D8:     equ    %01000000
mMCDC4_FAST_S:      equ    %10000000


;*** MCDC5 - Motor Controller Period Register 5; 0x000001EA ***
MCDC5:              equ    $000001EA                                ;*** MCDC5 - Motor Controller Period Register 5; 0x000001EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC5_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC5_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC5_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC5_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC5_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC5_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC5_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC5_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC5_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC5_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC5_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC5_S:            equ    15                                        ; Sign
; bit position masks
mMCDC5_D0:          equ    %00000001
mMCDC5_D1:          equ    %00000010
mMCDC5_D2:          equ    %00000100
mMCDC5_D3:          equ    %00001000
mMCDC5_D4:          equ    %00010000
mMCDC5_D5:          equ    %00100000
mMCDC5_D6:          equ    %01000000
mMCDC5_D7:          equ    %10000000
mMCDC5_D8:          equ    %100000000
mMCDC5_D9:          equ    %1000000000
mMCDC5_D10:         equ    %10000000000
mMCDC5_S:           equ    %1000000000000000


;*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***
MCDC5_FAST:         equ    $000001EA                                ;*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC5_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC5_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC5_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC5_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC5_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC5_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC5_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC5_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC5_FAST_D2:     equ    %00000001
mMCDC5_FAST_D3:     equ    %00000010
mMCDC5_FAST_D4:     equ    %00000100
mMCDC5_FAST_D5:     equ    %00001000
mMCDC5_FAST_D6:     equ    %00010000
mMCDC5_FAST_D7:     equ    %00100000
mMCDC5_FAST_D8:     equ    %01000000
mMCDC5_FAST_S:      equ    %10000000


;*** MCDC6 - Motor Controller Period Register 6; 0x000001EC ***
MCDC6:              equ    $000001EC                                ;*** MCDC6 - Motor Controller Period Register 6; 0x000001EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC6_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC6_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC6_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC6_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC6_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC6_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC6_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC6_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC6_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC6_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC6_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC6_S:            equ    15                                        ; Sign
; bit position masks
mMCDC6_D0:          equ    %00000001
mMCDC6_D1:          equ    %00000010
mMCDC6_D2:          equ    %00000100
mMCDC6_D3:          equ    %00001000
mMCDC6_D4:          equ    %00010000
mMCDC6_D5:          equ    %00100000
mMCDC6_D6:          equ    %01000000
mMCDC6_D7:          equ    %10000000
mMCDC6_D8:          equ    %100000000
mMCDC6_D9:          equ    %1000000000
mMCDC6_D10:         equ    %10000000000
mMCDC6_S:           equ    %1000000000000000


;*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***
MCDC6_FAST:         equ    $000001EC                                ;*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC6_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC6_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC6_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC6_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC6_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC6_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC6_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC6_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC6_FAST_D2:     equ    %00000001
mMCDC6_FAST_D3:     equ    %00000010
mMCDC6_FAST_D4:     equ    %00000100
mMCDC6_FAST_D5:     equ    %00001000
mMCDC6_FAST_D6:     equ    %00010000
mMCDC6_FAST_D7:     equ    %00100000
mMCDC6_FAST_D8:     equ    %01000000
mMCDC6_FAST_S:      equ    %10000000


;*** MCDC7 - Motor Controller Period Register 7; 0x000001EE ***
MCDC7:              equ    $000001EE                                ;*** MCDC7 - Motor Controller Period Register 7; 0x000001EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC7_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC7_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC7_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC7_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC7_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC7_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC7_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC7_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC7_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC7_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC7_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC7_S:            equ    15                                        ; Sign
; bit position masks
mMCDC7_D0:          equ    %00000001
mMCDC7_D1:          equ    %00000010
mMCDC7_D2:          equ    %00000100
mMCDC7_D3:          equ    %00001000
mMCDC7_D4:          equ    %00010000
mMCDC7_D5:          equ    %00100000
mMCDC7_D6:          equ    %01000000
mMCDC7_D7:          equ    %10000000
mMCDC7_D8:          equ    %100000000
mMCDC7_D9:          equ    %1000000000
mMCDC7_D10:         equ    %10000000000
mMCDC7_S:           equ    %1000000000000000


;*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***
MCDC7_FAST:         equ    $000001EE                                ;*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC7_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC7_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC7_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC7_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC7_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC7_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC7_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC7_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC7_FAST_D2:     equ    %00000001
mMCDC7_FAST_D3:     equ    %00000010
mMCDC7_FAST_D4:     equ    %00000100
mMCDC7_FAST_D5:     equ    %00001000
mMCDC7_FAST_D6:     equ    %00010000
mMCDC7_FAST_D7:     equ    %00100000
mMCDC7_FAST_D8:     equ    %01000000
mMCDC7_FAST_S:      equ    %10000000


;*** MCDC8 - Motor Controller Period Register 8; 0x000001F0 ***
MCDC8:              equ    $000001F0                                ;*** MCDC8 - Motor Controller Period Register 8; 0x000001F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC8_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC8_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC8_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC8_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC8_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC8_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC8_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC8_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC8_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC8_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC8_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC8_S:            equ    15                                        ; Sign
; bit position masks
mMCDC8_D0:          equ    %00000001
mMCDC8_D1:          equ    %00000010
mMCDC8_D2:          equ    %00000100
mMCDC8_D3:          equ    %00001000
mMCDC8_D4:          equ    %00010000
mMCDC8_D5:          equ    %00100000
mMCDC8_D6:          equ    %01000000
mMCDC8_D7:          equ    %10000000
mMCDC8_D8:          equ    %100000000
mMCDC8_D9:          equ    %1000000000
mMCDC8_D10:         equ    %10000000000
mMCDC8_S:           equ    %1000000000000000


;*** MCDC8_FAST - Motor Controller Period Register 8 access with FAST bit = 1; 0x000001F0 ***
MCDC8_FAST:         equ    $000001F0                                ;*** MCDC8_FAST - Motor Controller Period Register 8 access with FAST bit = 1; 0x000001F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC8_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC8_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC8_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC8_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC8_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC8_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC8_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC8_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC8_FAST_D2:     equ    %00000001
mMCDC8_FAST_D3:     equ    %00000010
mMCDC8_FAST_D4:     equ    %00000100
mMCDC8_FAST_D5:     equ    %00001000
mMCDC8_FAST_D6:     equ    %00010000
mMCDC8_FAST_D7:     equ    %00100000
mMCDC8_FAST_D8:     equ    %01000000
mMCDC8_FAST_S:      equ    %10000000


;*** MCDC9 - Motor Controller Period Register 9; 0x000001F2 ***
MCDC9:              equ    $000001F2                                ;*** MCDC9 - Motor Controller Period Register 9; 0x000001F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC9_D0:           equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC9_D1:           equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC9_D2:           equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC9_D3:           equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC9_D4:           equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC9_D5:           equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC9_D6:           equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC9_D7:           equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC9_D8:           equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC9_D9:           equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC9_D10:          equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC9_S:            equ    15                                        ; Sign
; bit position masks
mMCDC9_D0:          equ    %00000001
mMCDC9_D1:          equ    %00000010
mMCDC9_D2:          equ    %00000100
mMCDC9_D3:          equ    %00001000
mMCDC9_D4:          equ    %00010000
mMCDC9_D5:          equ    %00100000
mMCDC9_D6:          equ    %01000000
mMCDC9_D7:          equ    %10000000
mMCDC9_D8:          equ    %100000000
mMCDC9_D9:          equ    %1000000000
mMCDC9_D10:         equ    %10000000000
mMCDC9_S:           equ    %1000000000000000


;*** MCDC9_FAST - Motor Controller Period Register 9 access with FAST bit = 1; 0x000001F2 ***
MCDC9_FAST:         equ    $000001F2                                ;*** MCDC9_FAST - Motor Controller Period Register 9 access with FAST bit = 1; 0x000001F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC9_FAST_D2:      equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC9_FAST_D3:      equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC9_FAST_D4:      equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC9_FAST_D5:      equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC9_FAST_D6:      equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC9_FAST_D7:      equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC9_FAST_D8:      equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC9_FAST_S:       equ    7                                         ; Sign
; bit position masks
mMCDC9_FAST_D2:     equ    %00000001
mMCDC9_FAST_D3:     equ    %00000010
mMCDC9_FAST_D4:     equ    %00000100
mMCDC9_FAST_D5:     equ    %00001000
mMCDC9_FAST_D6:     equ    %00010000
mMCDC9_FAST_D7:     equ    %00100000
mMCDC9_FAST_D8:     equ    %01000000
mMCDC9_FAST_S:      equ    %10000000


;*** MCDC10 - Motor Controller Period Register 10; 0x000001F4 ***
MCDC10:             equ    $000001F4                                ;*** MCDC10 - Motor Controller Period Register 10; 0x000001F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC10_D0:          equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC10_D1:          equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC10_D2:          equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC10_D3:          equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC10_D4:          equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC10_D5:          equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC10_D6:          equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC10_D7:          equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC10_D8:          equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC10_D9:          equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC10_D10:         equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC10_S:           equ    15                                        ; Sign
; bit position masks
mMCDC10_D0:         equ    %00000001
mMCDC10_D1:         equ    %00000010
mMCDC10_D2:         equ    %00000100
mMCDC10_D3:         equ    %00001000
mMCDC10_D4:         equ    %00010000
mMCDC10_D5:         equ    %00100000
mMCDC10_D6:         equ    %01000000
mMCDC10_D7:         equ    %10000000
mMCDC10_D8:         equ    %100000000
mMCDC10_D9:         equ    %1000000000
mMCDC10_D10:        equ    %10000000000
mMCDC10_S:          equ    %1000000000000000


;*** MCDC10_FAST - Motor Controller Period Register 10 access with FAST bit = 1; 0x000001F4 ***
MCDC10_FAST:        equ    $000001F4                                ;*** MCDC10_FAST - Motor Controller Period Register 10 access with FAST bit = 1; 0x000001F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC10_FAST_D2:     equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC10_FAST_D3:     equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC10_FAST_D4:     equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC10_FAST_D5:     equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC10_FAST_D6:     equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC10_FAST_D7:     equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC10_FAST_D8:     equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC10_FAST_S:      equ    7                                         ; Sign
; bit position masks
mMCDC10_FAST_D2:    equ    %00000001
mMCDC10_FAST_D3:    equ    %00000010
mMCDC10_FAST_D4:    equ    %00000100
mMCDC10_FAST_D5:    equ    %00001000
mMCDC10_FAST_D6:    equ    %00010000
mMCDC10_FAST_D7:    equ    %00100000
mMCDC10_FAST_D8:    equ    %01000000
mMCDC10_FAST_S:     equ    %10000000


;*** MCDC11 - Motor Controller Period Register 11; 0x000001F6 ***
MCDC11:             equ    $000001F6                                ;*** MCDC11 - Motor Controller Period Register 11; 0x000001F6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC11_D0:          equ    0                                         ; Motor Controller Duty Cycle, bit 0
MCDC11_D1:          equ    1                                         ; Motor Controller Duty Cycle, bit 1
MCDC11_D2:          equ    2                                         ; Motor Controller Duty Cycle, bit 2
MCDC11_D3:          equ    3                                         ; Motor Controller Duty Cycle, bit 3
MCDC11_D4:          equ    4                                         ; Motor Controller Duty Cycle, bit 4
MCDC11_D5:          equ    5                                         ; Motor Controller Duty Cycle, bit 5
MCDC11_D6:          equ    6                                         ; Motor Controller Duty Cycle, bit 6
MCDC11_D7:          equ    7                                         ; Motor Controller Duty Cycle, bit 7
MCDC11_D8:          equ    8                                         ; Motor Controller Duty Cycle, bit 8
MCDC11_D9:          equ    9                                         ; Motor Controller Duty Cycle, bit 9
MCDC11_D10:         equ    10                                        ; Motor Controller Duty Cycle, bit 10
MCDC11_S:           equ    15                                        ; Sign
; bit position masks
mMCDC11_D0:         equ    %00000001
mMCDC11_D1:         equ    %00000010
mMCDC11_D2:         equ    %00000100
mMCDC11_D3:         equ    %00001000
mMCDC11_D4:         equ    %00010000
mMCDC11_D5:         equ    %00100000
mMCDC11_D6:         equ    %01000000
mMCDC11_D7:         equ    %10000000
mMCDC11_D8:         equ    %100000000
mMCDC11_D9:         equ    %1000000000
mMCDC11_D10:        equ    %10000000000
mMCDC11_S:          equ    %1000000000000000


;*** MCDC11_FAST - Motor Controller Period Register 11 access with FAST bit = 1; 0x000001F6 ***
MCDC11_FAST:        equ    $000001F6                                ;*** MCDC11_FAST - Motor Controller Period Register 11 access with FAST bit = 1; 0x000001F6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCDC11_FAST_D2:     equ    0                                         ; Motor Controller Duty Cycle, bit 2
MCDC11_FAST_D3:     equ    1                                         ; Motor Controller Duty Cycle, bit 3
MCDC11_FAST_D4:     equ    2                                         ; Motor Controller Duty Cycle, bit 4
MCDC11_FAST_D5:     equ    3                                         ; Motor Controller Duty Cycle, bit 5
MCDC11_FAST_D6:     equ    4                                         ; Motor Controller Duty Cycle, bit 6
MCDC11_FAST_D7:     equ    5                                         ; Motor Controller Duty Cycle, bit 7
MCDC11_FAST_D8:     equ    6                                         ; Motor Controller Duty Cycle, bit 8
MCDC11_FAST_S:      equ    7                                         ; Sign
; bit position masks
mMCDC11_FAST_D2:    equ    %00000001
mMCDC11_FAST_D3:    equ    %00000010
mMCDC11_FAST_D4:    equ    %00000100
mMCDC11_FAST_D5:    equ    %00001000
mMCDC11_FAST_D6:    equ    %00010000
mMCDC11_FAST_D7:    equ    %00100000
mMCDC11_FAST_D8:    equ    %01000000
mMCDC11_FAST_S:     equ    %10000000


;*** PTT - Port T Data Register; 0x00000200 ***
PTT:                equ    $00000200                                ;*** PTT - Port T Data Register; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T general purpose input/output data bit 0
PTT_PTT1:           equ    1                                         ; Port T general purpose input/output data bit 1
PTT_PTT2:           equ    2                                         ; Port T general purpose input/output data bit 2
PTT_PTT3:           equ    3                                         ; Port T general purpose input/output data bit 3
PTT_PTT4:           equ    4                                         ; Port T general purpose input/output data bit 4
PTT_PTT5:           equ    5                                         ; Port T general purpose input/output data bit 5
PTT_PTT6:           equ    6                                         ; Port T general purpose input/output data bit 6
PTT_PTT7:           equ    7                                         ; Port T general purpose input/output data bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000201 ***
PTIT:               equ    $00000201                                ;*** PTIT - Port T Input Register; 0x00000201 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T input data bit 0
PTIT_PTIT1:         equ    1                                         ; Port T input data bit 1
PTIT_PTIT2:         equ    2                                         ; Port T input data bit 2
PTIT_PTIT3:         equ    3                                         ; Port T input data bit 3
PTIT_PTIT4:         equ    4                                         ; Port T input data bit 4
PTIT_PTIT5:         equ    5                                         ; Port T input data bit 5
PTIT_PTIT6:         equ    6                                         ; Port T input data bit 6
PTIT_PTIT7:         equ    7                                         ; Port T input data bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000202 ***
DDRT:               equ    $00000202                                ;*** DDRT - Port T Data Direction Register; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Port T data direction bit 0
DDRT_DDRT1:         equ    1                                         ; Port T data direction bit 1
DDRT_DDRT2:         equ    2                                         ; Port T data direction bit 2
DDRT_DDRT3:         equ    3                                         ; Port T data direction bit 3
DDRT_DDRT4:         equ    4                                         ; Port T data direction bit 4
DDRT_DDRT5:         equ    5                                         ; Port T data direction bit 5
DDRT_DDRT6:         equ    6                                         ; Port T data direction bit 6
DDRT_DDRT7:         equ    7                                         ; Port T data direction bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000203 ***
RDRT:               equ    $00000203                                ;*** RDRT - Port T Reduced Drive Register; 0x00000203 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Port T reduced drive bit 0
RDRT_RDRT1:         equ    1                                         ; Port T reduced drive bit 1
RDRT_RDRT2:         equ    2                                         ; Port T reduced drive bit 2
RDRT_RDRT3:         equ    3                                         ; Port T reduced drive bit 3
RDRT_RDRT4:         equ    4                                         ; Port T reduced drive bit 4
RDRT_RDRT5:         equ    5                                         ; Port T reduced drive bit 5
RDRT_RDRT6:         equ    6                                         ; Port T reduced drive bit 6
RDRT_RDRT7:         equ    7                                         ; Port T reduced drive bit 7
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000204 ***
PERT:               equ    $00000204                                ;*** PERT - Port T Pull Device Enable Register; 0x00000204 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Port T pull device enable bit 0
PERT_PERT1:         equ    1                                         ; Port T pull device enable bit 1
PERT_PERT2:         equ    2                                         ; Port T pull device enable bit 2
PERT_PERT3:         equ    3                                         ; Port T pull device enable bit 3
PERT_PERT4:         equ    4                                         ; Port T pull device enable bit 4
PERT_PERT5:         equ    5                                         ; Port T pull device enable bit 5
PERT_PERT6:         equ    6                                         ; Port T pull device enable bit 6
PERT_PERT7:         equ    7                                         ; Port T pull device enable bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000205 ***
PPST:               equ    $00000205                                ;*** PPST - Port T Polarity Select Register; 0x00000205 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Port T pull device select bit 0
PPST_PPST1:         equ    1                                         ; Port T pull device select bit 1
PPST_PPST2:         equ    2                                         ; Port T pull device select bit 2
PPST_PPST3:         equ    3                                         ; Port T pull device select bit 3
PPST_PPST4:         equ    4                                         ; Port T pull device select bit 4
PPST_PPST5:         equ    5                                         ; Port T pull device select bit 5
PPST_PPST6:         equ    6                                         ; Port T pull device select bit 6
PPST_PPST7:         equ    7                                         ; Port T pull device select bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** WOMT - Port T Wired-Or Mode Register; 0x00000206 ***
WOMT:               equ    $00000206                                ;*** WOMT - Port T Wired-Or Mode Register; 0x00000206 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMT_MODRR0:        equ    0                                         ; Module Routing bit 0
WOMT_MODRR1:        equ    1                                         ; Module Routing bit 1
WOMT_MODRR2:        equ    2                                         ; Module Routing bit 2
WOMT_WOMT4:         equ    4                                         ; Port T wired-or mode bit 4
WOMT_WOMT5:         equ    5                                         ; Port T wired-or mode bit 5
WOMT_WOMT6:         equ    6                                         ; Port T wired-or mode bit 6
WOMT_WOMT7:         equ    7                                         ; Port T wired-or mode bit 7
; bit position masks
mWOMT_MODRR0:       equ    %00000001
mWOMT_MODRR1:       equ    %00000010
mWOMT_MODRR2:       equ    %00000100
mWOMT_WOMT4:        equ    %00010000
mWOMT_WOMT5:        equ    %00100000
mWOMT_WOMT6:        equ    %01000000
mWOMT_WOMT7:        equ    %10000000


;*** SRRT - Port T Slew Rate Register; 0x00000207 ***
SRRT:               equ    $00000207                                ;*** SRRT - Port T Slew Rate Register; 0x00000207 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRT_SRRT0:         equ    0                                         ; Slew rate port T bit 0
SRRT_SRRT1:         equ    1                                         ; Slew rate port T bit 1
SRRT_SRRT2:         equ    2                                         ; Slew rate port T bit 2
SRRT_SRRT3:         equ    3                                         ; Slew rate port T bit 3
SRRT_SRRT4:         equ    4                                         ; Slew rate port T bit 4
SRRT_SRRT5:         equ    5                                         ; Slew rate port T bit 5
SRRT_SRRT6:         equ    6                                         ; Slew rate port T bit 6
SRRT_SRRT7:         equ    7                                         ; Slew rate port T bit 7
; bit position masks
mSRRT_SRRT0:        equ    %00000001
mSRRT_SRRT1:        equ    %00000010
mSRRT_SRRT2:        equ    %00000100
mSRRT_SRRT3:        equ    %00001000
mSRRT_SRRT4:        equ    %00010000
mSRRT_SRRT5:        equ    %00100000
mSRRT_SRRT6:        equ    %01000000
mSRRT_SRRT7:        equ    %10000000


;*** PTS - Port S Data Register; 0x00000208 ***
PTS:                equ    $00000208                                ;*** PTS - Port S Data Register; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S general purpose input/output data bit 0
PTS_PTS1:           equ    1                                         ; Port S general purpose input/output data bit 1
PTS_PTS2:           equ    2                                         ; Port S general purpose input/output data bit 2
PTS_PTS3:           equ    3                                         ; Port S general purpose input/output data bit 3
PTS_PTS4:           equ    4                                         ; Port S general purpose input/output data bit 4
PTS_PTS5:           equ    5                                         ; Port S general purpose input/output data bit 5
PTS_PTS6:           equ    6                                         ; Port S general purpose input/output data bit 6
PTS_PTS7:           equ    7                                         ; Port S general purpose input/output data bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000209 ***
PTIS:               equ    $00000209                                ;*** PTIS - Port S Input Register; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S input data bit 0
PTIS_PTIS1:         equ    1                                         ; Port S input data bit 1
PTIS_PTIS2:         equ    2                                         ; Port S input data bit 2
PTIS_PTIS3:         equ    3                                         ; Port S input data bit 3
PTIS_PTIS4:         equ    4                                         ; Port S input data bit 4
PTIS_PTIS5:         equ    5                                         ; Port S input data bit 5
PTIS_PTIS6:         equ    6                                         ; Port S input data bit 6
PTIS_PTIS7:         equ    7                                         ; Port S input data bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000020A ***
DDRS:               equ    $0000020A                                ;*** DDRS - Port S Data Direction Register; 0x0000020A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Port S data direction bit 0
DDRS_DDRS1:         equ    1                                         ; Port S data direction bit 1
DDRS_DDRS2:         equ    2                                         ; Port S data direction bit 2
DDRS_DDRS3:         equ    3                                         ; Port S data direction bit 3
DDRS_DDRS4:         equ    4                                         ; Port S data direction bit 4
DDRS_DDRS5:         equ    5                                         ; Port S data direction bit 5
DDRS_DDRS6:         equ    6                                         ; Port S data direction bit 6
DDRS_DDRS7:         equ    7                                         ; Port S data direction bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x0000020B ***
RDRS:               equ    $0000020B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000020B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Port S reduced drive bit 0
RDRS_RDRS1:         equ    1                                         ; Port S reduced drive bit 1
RDRS_RDRS2:         equ    2                                         ; Port S reduced drive bit 2
RDRS_RDRS3:         equ    3                                         ; Port S reduced drive bit 3
RDRS_RDRS4:         equ    4                                         ; Port S reduced drive bit 4
RDRS_RDRS5:         equ    5                                         ; Port S reduced drive bit 5
RDRS_RDRS6:         equ    6                                         ; Port S reduced drive bit 6
RDRS_RDRS7:         equ    7                                         ; Port S reduced drive bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000020C ***
PERS:               equ    $0000020C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000020C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Port S pull device enable bit 0
PERS_PERS1:         equ    1                                         ; Port S pull device enable bit 1
PERS_PERS2:         equ    2                                         ; Port S pull device enable bit 2
PERS_PERS3:         equ    3                                         ; Port S pull device enable bit 3
PERS_PERS4:         equ    4                                         ; Port S pull device enable bit 4
PERS_PERS5:         equ    5                                         ; Port S pull device enable bit 5
PERS_PERS6:         equ    6                                         ; Port S pull device enable bit 6
PERS_PERS7:         equ    7                                         ; Port S pull device enable bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000020D ***
PPSS:               equ    $0000020D                                ;*** PPSS - Port S Polarity Select Register; 0x0000020D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Port S pull device select bit 0
PPSS_PPSS1:         equ    1                                         ; Port S pull device select bit 1
PPSS_PPSS2:         equ    2                                         ; Port S pull device select bit 2
PPSS_PPSS3:         equ    3                                         ; Port S pull device select bit 3
PPSS_PPSS4:         equ    4                                         ; Port S pull device select bit 4
PPSS_PPSS5:         equ    5                                         ; Port S pull device select bit 5
PPSS_PPSS6:         equ    6                                         ; Port S pull device select bit 6
PPSS_PPSS7:         equ    7                                         ; Port S pull device select bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000020E ***
WOMS:               equ    $0000020E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000020E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Port S wired-or mode bit 0
WOMS_WOMS1:         equ    1                                         ; Port S wired-or mode bit 1
WOMS_WOMS2:         equ    2                                         ; Port S wired-or mode bit 2
WOMS_WOMS3:         equ    3                                         ; Port S wired-or mode bit 3
WOMS_WOMS4:         equ    4                                         ; Port S wired-or mode bit 4
WOMS_WOMS5:         equ    5                                         ; Port S wired-or mode bit 5
WOMS_WOMS6:         equ    6                                         ; Port S wired-or mode bit 6
WOMS_WOMS7:         equ    7                                         ; Port S wired-or mode bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** SRRS - Port S Slew Rate Register; 0x0000020F ***
SRRS:               equ    $0000020F                                ;*** SRRS - Port S Slew Rate Register; 0x0000020F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRS_SRRS0:         equ    0                                         ; Slew rate port S bit 0
SRRS_SRRS1:         equ    1                                         ; Slew rate port S bit 1
SRRS_SRRS2:         equ    2                                         ; Slew rate port S bit 2
SRRS_SRRS3:         equ    3                                         ; Slew rate port S bit 3
SRRS_SRRS4:         equ    4                                         ; Slew rate port S bit 4
SRRS_SRRS5:         equ    5                                         ; Slew rate port S bit 5
SRRS_SRRS6:         equ    6                                         ; Slew rate port S bit 6
SRRS_SRRS7:         equ    7                                         ; Slew rate port S bit 7
; bit position masks
mSRRS_SRRS0:        equ    %00000001
mSRRS_SRRS1:        equ    %00000010
mSRRS_SRRS2:        equ    %00000100
mSRRS_SRRS3:        equ    %00001000
mSRRS_SRRS4:        equ    %00010000
mSRRS_SRRS5:        equ    %00100000
mSRRS_SRRS6:        equ    %01000000
mSRRS_SRRS7:        equ    %10000000


;*** PTM - Port M Data Register; 0x00000210 ***
PTM:                equ    $00000210                                ;*** PTM - Port M Data Register; 0x00000210 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM1:           equ    1                                         ; Port M general purpose input/output data bit 1
PTM_PTM2:           equ    2                                         ; Port M general purpose input/output data bit 2
PTM_PTM3:           equ    3                                         ; Port M general purpose input/output data bit 3
PTM_PTM4:           equ    4                                         ; Port M general purpose input/output data bit 4
PTM_PTM5:           equ    5                                         ; Port M general purpose input/output data bit 5
; bit position masks
mPTM_PTM1:          equ    %00000010
mPTM_PTM2:          equ    %00000100
mPTM_PTM3:          equ    %00001000
mPTM_PTM4:          equ    %00010000
mPTM_PTM5:          equ    %00100000


;*** PTIM - Port M Input Register; 0x00000211 ***
PTIM:               equ    $00000211                                ;*** PTIM - Port M Input Register; 0x00000211 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM1:         equ    1                                         ; Port M input data bit 1
PTIM_PTIM2:         equ    2                                         ; Port M input data bit 2
PTIM_PTIM3:         equ    3                                         ; Port M input data bit 3
PTIM_PTIM4:         equ    4                                         ; Port M input data bit 4
PTIM_PTIM5:         equ    5                                         ; Port M input data bit 5
; bit position masks
mPTIM_PTIM1:        equ    %00000010
mPTIM_PTIM2:        equ    %00000100
mPTIM_PTIM3:        equ    %00001000
mPTIM_PTIM4:        equ    %00010000
mPTIM_PTIM5:        equ    %00100000


;*** DDRM - Port M Data Direction Register; 0x00000212 ***
DDRM:               equ    $00000212                                ;*** DDRM - Port M Data Direction Register; 0x00000212 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM1:         equ    1                                         ; Port M data direction bit 1
DDRM_DDRM2:         equ    2                                         ; Port M data direction bit 2
DDRM_DDRM3:         equ    3                                         ; Port M data direction bit 3
DDRM_DDRM4:         equ    4                                         ; Port M data direction bit 4
DDRM_DDRM5:         equ    5                                         ; Port M data direction bit 5
; bit position masks
mDDRM_DDRM1:        equ    %00000010
mDDRM_DDRM2:        equ    %00000100
mDDRM_DDRM3:        equ    %00001000
mDDRM_DDRM4:        equ    %00010000
mDDRM_DDRM5:        equ    %00100000


;*** RDRM - Port M Reduced Drive Register; 0x00000213 ***
RDRM:               equ    $00000213                                ;*** RDRM - Port M Reduced Drive Register; 0x00000213 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRM_RDRM1:         equ    1                                         ; Port M reduced drive bit 1
RDRM_RDRM2:         equ    2                                         ; Port M reduced drive bit 2
RDRM_RDRM3:         equ    3                                         ; Port M reduced drive bit 3
RDRM_RDRM4:         equ    4                                         ; Port M reduced drive bit 4
RDRM_RDRM5:         equ    5                                         ; Port M reduced drive bit 5
; bit position masks
mRDRM_RDRM1:        equ    %00000010
mRDRM_RDRM2:        equ    %00000100
mRDRM_RDRM3:        equ    %00001000
mRDRM_RDRM4:        equ    %00010000
mRDRM_RDRM5:        equ    %00100000


;*** PERM - Port M Pull Device Enable Register; 0x00000214 ***
PERM:               equ    $00000214                                ;*** PERM - Port M Pull Device Enable Register; 0x00000214 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM1:         equ    1                                         ; Port M pull device enable bit 1
PERM_PERM2:         equ    2                                         ; Port M pull device enable bit 2
PERM_PERM3:         equ    3                                         ; Port M pull device enable bit 3
PERM_PERM4:         equ    4                                         ; Port M pull device enable bit 4
PERM_PERM5:         equ    5                                         ; Port M pull device enable bit 5
; bit position masks
mPERM_PERM1:        equ    %00000010
mPERM_PERM2:        equ    %00000100
mPERM_PERM3:        equ    %00001000
mPERM_PERM4:        equ    %00010000
mPERM_PERM5:        equ    %00100000


;*** PPSM - Port M Polarity Select Register; 0x00000215 ***
PPSM:               equ    $00000215                                ;*** PPSM - Port M Polarity Select Register; 0x00000215 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM1:         equ    1                                         ; Port M pull device select bit 1
PPSM_PPSM2:         equ    2                                         ; Port M pull device select bit 2
PPSM_PPSM3:         equ    3                                         ; Port M pull device select bit 3
PPSM_PPSM4:         equ    4                                         ; Port M pull device select bit 4
PPSM_PPSM5:         equ    5                                         ; Port M pull device select bit 5
; bit position masks
mPPSM_PPSM1:        equ    %00000010
mPPSM_PPSM2:        equ    %00000100
mPPSM_PPSM3:        equ    %00001000
mPPSM_PPSM4:        equ    %00010000
mPPSM_PPSM5:        equ    %00100000


;*** WOMM - Port M Wired-Or Mode Register; 0x00000216 ***
WOMM:               equ    $00000216                                ;*** WOMM - Port M Wired-Or Mode Register; 0x00000216 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMM_WOMM1:         equ    1                                         ; Port M wired-or mode bit 1
WOMM_WOMM2:         equ    2                                         ; Port M wired-or mode bit 2
WOMM_WOMM3:         equ    3                                         ; Port M wired-or mode bit 3
WOMM_WOMM4:         equ    4                                         ; Port M wired-or mode bit 4
WOMM_WOMM5:         equ    5                                         ; Port M wired-or mode bit 5
; bit position masks
mWOMM_WOMM1:        equ    %00000010
mWOMM_WOMM2:        equ    %00000100
mWOMM_WOMM3:        equ    %00001000
mWOMM_WOMM4:        equ    %00010000
mWOMM_WOMM5:        equ    %00100000


;*** SRRM - Port M Slew Rate Register; 0x00000217 ***
SRRM:               equ    $00000217                                ;*** SRRM - Port M Slew Rate Register; 0x00000217 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRM_SRRM1:         equ    1                                         ; Slew rate port M bit 1
SRRM_SRRM2:         equ    2                                         ; Slew rate port M bit 2
SRRM_SRRM3:         equ    3                                         ; Slew rate port M bit 3
SRRM_SRRM4:         equ    4                                         ; Slew rate port M bit 4
SRRM_SRRM5:         equ    5                                         ; Slew rate port M bit 5
; bit position masks
mSRRM_SRRM1:        equ    %00000010
mSRRM_SRRM2:        equ    %00000100
mSRRM_SRRM3:        equ    %00001000
mSRRM_SRRM4:        equ    %00010000
mSRRM_SRRM5:        equ    %00100000


;*** PTP - Port P Data Register; 0x00000218 ***
PTP:                equ    $00000218                                ;*** PTP - Port P Data Register; 0x00000218 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P general purpose input/output data bit 0
PTP_PTP1:           equ    1                                         ; Port P general purpose input/output data bit 1
PTP_PTP2:           equ    2                                         ; Port P general purpose input/output data bit 2
PTP_PTP3:           equ    3                                         ; Port P general purpose input/output data bit 3
PTP_PTP4:           equ    4                                         ; Port P general purpose input/output data bit 4
PTP_PTP5:           equ    5                                         ; Port P general purpose input/output data bit 5
PTP_PTP6:           equ    6                                         ; Port P general purpose input/output data bit 6
PTP_PTP7:           equ    7                                         ; Port P general purpose input/output data bit 7
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000
mPTP_PTP6:          equ    %01000000
mPTP_PTP7:          equ    %10000000


;*** PTIP - Port P Input Register; 0x00000219 ***
PTIP:               equ    $00000219                                ;*** PTIP - Port P Input Register; 0x00000219 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P input data bit 0
PTIP_PTIP1:         equ    1                                         ; Port P input data bit 1
PTIP_PTIP2:         equ    2                                         ; Port P input data bit 2
PTIP_PTIP3:         equ    3                                         ; Port P input data bit 3
PTIP_PTIP4:         equ    4                                         ; Port P input data bit 4
PTIP_PTIP5:         equ    5                                         ; Port P input data bit 5
PTIP_PTIP6:         equ    6                                         ; Port P input data bit 6
PTIP_PTIP7:         equ    7                                         ; Port P input data bit 7
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000
mPTIP_PTIP6:        equ    %01000000
mPTIP_PTIP7:        equ    %10000000


;*** DDRP - Port P Data Direction Register; 0x0000021A ***
DDRP:               equ    $0000021A                                ;*** DDRP - Port P Data Direction Register; 0x0000021A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Port P data direction bit 0
DDRP_DDRP1:         equ    1                                         ; Port P data direction bit 1
DDRP_DDRP2:         equ    2                                         ; Port P data direction bit 2
DDRP_DDRP3:         equ    3                                         ; Port P data direction bit 3
DDRP_DDRP4:         equ    4                                         ; Port P data direction bit 4
DDRP_DDRP5:         equ    5                                         ; Port P data direction bit 5
DDRP_DDRP6:         equ    6                                         ; Port P data direction bit 6
DDRP_DDRP7:         equ    7                                         ; Port P data direction bit 7
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000
mDDRP_DDRP6:        equ    %01000000
mDDRP_DDRP7:        equ    %10000000


;*** RDRP - Port P Reduced Drive Register; 0x0000021B ***
RDRP:               equ    $0000021B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000021B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Port P reduced drive bit 0
RDRP_RDRP1:         equ    1                                         ; Port P reduced drive bit 1
RDRP_RDRP2:         equ    2                                         ; Port P reduced drive bit 2
RDRP_RDRP3:         equ    3                                         ; Port P reduced drive bit 3
RDRP_RDRP4:         equ    4                                         ; Port P reduced drive bit 4
RDRP_RDRP5:         equ    5                                         ; Port P reduced drive bit 5
RDRP_RDRP6:         equ    6                                         ; Port P reduced drive bit 6
RDRP_RDRP7:         equ    7                                         ; Port P reduced drive bit 7
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000
mRDRP_RDRP6:        equ    %01000000
mRDRP_RDRP7:        equ    %10000000


;*** PERP - Port P Pull Device Enable Register; 0x0000021C ***
PERP:               equ    $0000021C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000021C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Port P pull device enable bit 0
PERP_PERP1:         equ    1                                         ; Port P pull device enable bit 1
PERP_PERP2:         equ    2                                         ; Port P pull device enable bit 2
PERP_PERP3:         equ    3                                         ; Port P pull device enable bit 3
PERP_PERP4:         equ    4                                         ; Port P pull device enable bit 4
PERP_PERP5:         equ    5                                         ; Port P pull device enable bit 5
PERP_PERP6:         equ    6                                         ; Port P pull device enable bit 6
PERP_PERP7:         equ    7                                         ; Port P pull device enable bit 7
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000
mPERP_PERP6:        equ    %01000000
mPERP_PERP7:        equ    %10000000


;*** PPSP - Port P Polarity Select Register; 0x0000021D ***
PPSP:               equ    $0000021D                                ;*** PPSP - Port P Polarity Select Register; 0x0000021D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Port P pull device select bit 0
PPSP_PPSP1:         equ    1                                         ; Port P pull device select bit 1
PPSP_PPSP2:         equ    2                                         ; Port P pull device select bit 2
PPSP_PPSP3:         equ    3                                         ; Port P pull device select bit 3
PPSP_PPSP4:         equ    4                                         ; Port P pull device select bit 4
PPSP_PPSP5:         equ    5                                         ; Port P pull device select bit 5
PPSP_PPSP6:         equ    6                                         ; Port P pull device select bit 6
PPSP_PPSP7:         equ    7                                         ; Port P pull device select bit 7
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000
mPPSP_PPSP6:        equ    %01000000
mPPSP_PPSP7:        equ    %10000000


;*** WOMP - Port P Wired-Or Mode Register; 0x0000021E ***
WOMP:               equ    $0000021E                                ;*** WOMP - Port P Wired-Or Mode Register; 0x0000021E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMP_WOMP0:         equ    0                                         ; Port P wired-or mode bit 0
WOMP_WOMP2:         equ    2                                         ; Port P wired-or mode bit 2
WOMP_WOMP4:         equ    4                                         ; Port P wired-or mode bit 4
WOMP_WOMP5:         equ    5                                         ; Port P wired-or mode bit 5
WOMP_WOMP6:         equ    6                                         ; Port P wired-or mode bit 6
WOMP_WOMP7:         equ    7                                         ; Port P wired-or mode bit 7
; bit position masks
mWOMP_WOMP0:        equ    %00000001
mWOMP_WOMP2:        equ    %00000100
mWOMP_WOMP4:        equ    %00010000
mWOMP_WOMP5:        equ    %00100000
mWOMP_WOMP6:        equ    %01000000
mWOMP_WOMP7:        equ    %10000000


;*** SRRP - Port P Slew Rate Register; 0x0000021F ***
SRRP:               equ    $0000021F                                ;*** SRRP - Port P Slew Rate Register; 0x0000021F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRP_SRRP0:         equ    0                                         ; Slew rate port P bit 0
SRRP_SRRP1:         equ    1                                         ; Slew rate port P bit 1
SRRP_SRRP2:         equ    2                                         ; Slew rate port P bit 2
SRRP_SRRP3:         equ    3                                         ; Slew rate port P bit 3
SRRP_SRRP4:         equ    4                                         ; Slew rate port P bit 4
SRRP_SRRP5:         equ    5                                         ; Slew rate port P bit 5
SRRP_SRRP6:         equ    6                                         ; Slew rate port P bit 6
SRRP_SRRP7:         equ    7                                         ; Slew rate port P bit 7
; bit position masks
mSRRP_SRRP0:        equ    %00000001
mSRRP_SRRP1:        equ    %00000010
mSRRP_SRRP2:        equ    %00000100
mSRRP_SRRP3:        equ    %00001000
mSRRP_SRRP4:        equ    %00010000
mSRRP_SRRP5:        equ    %00100000
mSRRP_SRRP6:        equ    %01000000
mSRRP_SRRP7:        equ    %10000000


;*** PTL - Port L Data Register; 0x00000230 ***
PTL:                equ    $00000230                                ;*** PTL - Port L Data Register; 0x00000230 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTL_PTL0:           equ    0                                         ; Port L general purpose input/output data bit 0
PTL_PTL1:           equ    1                                         ; Port L general purpose input/output data bit 1
PTL_PTL2:           equ    2                                         ; Port L general purpose input/output data bit 2
PTL_PTL3:           equ    3                                         ; Port L general purpose input/output data bit 3
PTL_PTL4:           equ    4                                         ; Port L general purpose input/output data bit 4
PTL_PTL5:           equ    5                                         ; Port L general purpose input/output data bit 5
PTL_PTL6:           equ    6                                         ; Port L general purpose input/output data bit 6
PTL_PTL7:           equ    7                                         ; Port L general purpose input/output data bit 7
; bit position masks
mPTL_PTL0:          equ    %00000001
mPTL_PTL1:          equ    %00000010
mPTL_PTL2:          equ    %00000100
mPTL_PTL3:          equ    %00001000
mPTL_PTL4:          equ    %00010000
mPTL_PTL5:          equ    %00100000
mPTL_PTL6:          equ    %01000000
mPTL_PTL7:          equ    %10000000


;*** PTIL - Port L Input Register; 0x00000231 ***
PTIL:               equ    $00000231                                ;*** PTIL - Port L Input Register; 0x00000231 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIL_PTIL0:         equ    0                                         ; Port L input data bit 0
PTIL_PTIL1:         equ    1                                         ; Port L input data bit 1
PTIL_PTIL2:         equ    2                                         ; Port L input data bit 2
PTIL_PTIL3:         equ    3                                         ; Port L input data bit 3
PTIL_PTIL4:         equ    4                                         ; Port L input data bit 4
PTIL_PTIL5:         equ    5                                         ; Port L input data bit 5
PTIL_PTIL6:         equ    6                                         ; Port L input data bit 6
PTIL_PTIL7:         equ    7                                         ; Port L input data bit 7
; bit position masks
mPTIL_PTIL0:        equ    %00000001
mPTIL_PTIL1:        equ    %00000010
mPTIL_PTIL2:        equ    %00000100
mPTIL_PTIL3:        equ    %00001000
mPTIL_PTIL4:        equ    %00010000
mPTIL_PTIL5:        equ    %00100000
mPTIL_PTIL6:        equ    %01000000
mPTIL_PTIL7:        equ    %10000000


;*** DDRL - Port L Data Direction Register; 0x00000232 ***
DDRL:               equ    $00000232                                ;*** DDRL - Port L Data Direction Register; 0x00000232 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRL_DDRL0:         equ    0                                         ; Port L data direction bit 0
DDRL_DDRL1:         equ    1                                         ; Port L data direction bit 1
DDRL_DDRL2:         equ    2                                         ; Port L data direction bit 2
DDRL_DDRL3:         equ    3                                         ; Port L data direction bit 3
DDRL_DDRL4:         equ    4                                         ; Port L data direction bit 4
DDRL_DDRL5:         equ    5                                         ; Port L data direction bit 5
DDRL_DDRL6:         equ    6                                         ; Port L data direction bit 6
DDRL_DDRL7:         equ    7                                         ; Port L data direction bit 7
; bit position masks
mDDRL_DDRL0:        equ    %00000001
mDDRL_DDRL1:        equ    %00000010
mDDRL_DDRL2:        equ    %00000100
mDDRL_DDRL3:        equ    %00001000
mDDRL_DDRL4:        equ    %00010000
mDDRL_DDRL5:        equ    %00100000
mDDRL_DDRL6:        equ    %01000000
mDDRL_DDRL7:        equ    %10000000


;*** RDRL - Port L Reduced Drive Register; 0x00000233 ***
RDRL:               equ    $00000233                                ;*** RDRL - Port L Reduced Drive Register; 0x00000233 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRL_RDRL0:         equ    0                                         ; Port L reduced drive bit 0
RDRL_RDRL1:         equ    1                                         ; Port L reduced drive bit 1
RDRL_RDRL2:         equ    2                                         ; Port L reduced drive bit 2
RDRL_RDRL3:         equ    3                                         ; Port L reduced drive bit 3
RDRL_RDRL4:         equ    4                                         ; Port L reduced drive bit 4
RDRL_RDRL5:         equ    5                                         ; Port L reduced drive bit 5
RDRL_RDRL6:         equ    6                                         ; Port L reduced drive bit 6
RDRL_RDRL7:         equ    7                                         ; Port L reduced drive bit 7
; bit position masks
mRDRL_RDRL0:        equ    %00000001
mRDRL_RDRL1:        equ    %00000010
mRDRL_RDRL2:        equ    %00000100
mRDRL_RDRL3:        equ    %00001000
mRDRL_RDRL4:        equ    %00010000
mRDRL_RDRL5:        equ    %00100000
mRDRL_RDRL6:        equ    %01000000
mRDRL_RDRL7:        equ    %10000000


;*** PERL - Port L Pull Device Enable Register; 0x00000234 ***
PERL:               equ    $00000234                                ;*** PERL - Port L Pull Device Enable Register; 0x00000234 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERL_PERL0:         equ    0                                         ; Port L pull device enable bit 0
PERL_PERL1:         equ    1                                         ; Port L pull device enable bit 1
PERL_PERL2:         equ    2                                         ; Port L pull device enable bit 2
PERL_PERL3:         equ    3                                         ; Port L pull device enable bit 3
PERL_PERL4:         equ    4                                         ; Port L pull device enable bit 4
PERL_PERL5:         equ    5                                         ; Port L pull device enable bit 5
PERL_PERL6:         equ    6                                         ; Port L pull device enable bit 6
PERL_PERL7:         equ    7                                         ; Port L pull device enable bit 7
; bit position masks
mPERL_PERL0:        equ    %00000001
mPERL_PERL1:        equ    %00000010
mPERL_PERL2:        equ    %00000100
mPERL_PERL3:        equ    %00001000
mPERL_PERL4:        equ    %00010000
mPERL_PERL5:        equ    %00100000
mPERL_PERL6:        equ    %01000000
mPERL_PERL7:        equ    %10000000


;*** PPSL - Port L Polarity Select Register; 0x00000235 ***
PPSL:               equ    $00000235                                ;*** PPSL - Port L Polarity Select Register; 0x00000235 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSL_PPSL0:         equ    0                                         ; Port L pull device select bit 0
PPSL_PPSL1:         equ    1                                         ; Port L pull device select bit 1
PPSL_PPSL2:         equ    2                                         ; Port L pull device select bit 2
PPSL_PPSL3:         equ    3                                         ; Port L pull device select bit 3
PPSL_PPSL4:         equ    4                                         ; Port L pull device select bit 4
PPSL_PPSL5:         equ    5                                         ; Port L pull device select bit 5
PPSL_PPSL6:         equ    6                                         ; Port L pull device select bit 6
PPSL_PPSL7:         equ    7                                         ; Port L pull device select bit 7
; bit position masks
mPPSL_PPSL0:        equ    %00000001
mPPSL_PPSL1:        equ    %00000010
mPPSL_PPSL2:        equ    %00000100
mPPSL_PPSL3:        equ    %00001000
mPPSL_PPSL4:        equ    %00010000
mPPSL_PPSL5:        equ    %00100000
mPPSL_PPSL6:        equ    %01000000
mPPSL_PPSL7:        equ    %10000000


;*** SRRL - Port L Slew Rate Register; 0x00000237 ***
SRRL:               equ    $00000237                                ;*** SRRL - Port L Slew Rate Register; 0x00000237 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRL_SRRL0:         equ    0                                         ; Slew rate port L bit 0
SRRL_SRRL1:         equ    1                                         ; Slew rate port L bit 1
SRRL_SRRL2:         equ    2                                         ; Slew rate port L bit 2
SRRL_SRRL3:         equ    3                                         ; Slew rate port L bit 3
SRRL_SRRL4:         equ    4                                         ; Slew rate port L bit 4
SRRL_SRRL5:         equ    5                                         ; Slew rate port L bit 5
SRRL_SRRL6:         equ    6                                         ; Slew rate port L bit 6
SRRL_SRRL7:         equ    7                                         ; Slew rate port L bit 7
; bit position masks
mSRRL_SRRL0:        equ    %00000001
mSRRL_SRRL1:        equ    %00000010
mSRRL_SRRL2:        equ    %00000100
mSRRL_SRRL3:        equ    %00001000
mSRRL_SRRL4:        equ    %00010000
mSRRL_SRRL5:        equ    %00100000
mSRRL_SRRL6:        equ    %01000000
mSRRL_SRRL7:        equ    %10000000


;*** PTU - Port U Data Register; 0x00000238 ***
PTU:                equ    $00000238                                ;*** PTU - Port U Data Register; 0x00000238 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTU_PTU0:           equ    0                                         ; Port U general purpose input/output data bit 0
PTU_PTU1:           equ    1                                         ; Port U general purpose input/output data bit 1
PTU_PTU2:           equ    2                                         ; Port U general purpose input/output data bit 2
PTU_PTU3:           equ    3                                         ; Port U general purpose input/output data bit 3
PTU_PTU4:           equ    4                                         ; Port U general purpose input/output data bit 4
PTU_PTU5:           equ    5                                         ; Port U general purpose input/output data bit 5
PTU_PTU6:           equ    6                                         ; Port U general purpose input/output data bit 6
PTU_PTU7:           equ    7                                         ; Port U general purpose input/output data bit 7
; bit position masks
mPTU_PTU0:          equ    %00000001
mPTU_PTU1:          equ    %00000010
mPTU_PTU2:          equ    %00000100
mPTU_PTU3:          equ    %00001000
mPTU_PTU4:          equ    %00010000
mPTU_PTU5:          equ    %00100000
mPTU_PTU6:          equ    %01000000
mPTU_PTU7:          equ    %10000000


;*** PTIU - Port U Input Register; 0x00000239 ***
PTIU:               equ    $00000239                                ;*** PTIU - Port U Input Register; 0x00000239 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIU_PTIU0:         equ    0                                         ; Port U input data bit 0
PTIU_PTIU1:         equ    1                                         ; Port U input data bit 1
PTIU_PTIU2:         equ    2                                         ; Port U input data bit 2
PTIU_PTIU3:         equ    3                                         ; Port U input data bit 3
PTIU_PTIU4:         equ    4                                         ; Port U input data bit 4
PTIU_PTIU5:         equ    5                                         ; Port U input data bit 5
PTIU_PTIU6:         equ    6                                         ; Port U input data bit 6
PTIU_PTIU7:         equ    7                                         ; Port U input data bit 7
; bit position masks
mPTIU_PTIU0:        equ    %00000001
mPTIU_PTIU1:        equ    %00000010
mPTIU_PTIU2:        equ    %00000100
mPTIU_PTIU3:        equ    %00001000
mPTIU_PTIU4:        equ    %00010000
mPTIU_PTIU5:        equ    %00100000
mPTIU_PTIU6:        equ    %01000000
mPTIU_PTIU7:        equ    %10000000


;*** DDRU - Port U Data Direction Register; 0x0000023A ***
DDRU:               equ    $0000023A                                ;*** DDRU - Port U Data Direction Register; 0x0000023A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRU_DDRU0:         equ    0                                         ; Port U data direction bit 0
DDRU_DDRU1:         equ    1                                         ; Port U data direction bit 1
DDRU_DDRU2:         equ    2                                         ; Port U data direction bit 2
DDRU_DDRU3:         equ    3                                         ; Port U data direction bit 3
DDRU_DDRU4:         equ    4                                         ; Port U data direction bit 4
DDRU_DDRU5:         equ    5                                         ; Port U data direction bit 5
DDRU_DDRU6:         equ    6                                         ; Port U data direction bit 6
DDRU_DDRU7:         equ    7                                         ; Port U data direction bit 7
; bit position masks
mDDRU_DDRU0:        equ    %00000001
mDDRU_DDRU1:        equ    %00000010
mDDRU_DDRU2:        equ    %00000100
mDDRU_DDRU3:        equ    %00001000
mDDRU_DDRU4:        equ    %00010000
mDDRU_DDRU5:        equ    %00100000
mDDRU_DDRU6:        equ    %01000000
mDDRU_DDRU7:        equ    %10000000


;*** SRRU - Port U Slew Rate Register; 0x0000023B ***
SRRU:               equ    $0000023B                                ;*** SRRU - Port U Slew Rate Register; 0x0000023B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRU_SRRU0:         equ    0                                         ; Slew rate port U bit 0
SRRU_SRRU1:         equ    1                                         ; Slew rate port U bit 1
SRRU_SRRU2:         equ    2                                         ; Slew rate port U bit 2
SRRU_SRRU3:         equ    3                                         ; Slew rate port U bit 3
SRRU_SRRU4:         equ    4                                         ; Slew rate port U bit 4
SRRU_SRRU5:         equ    5                                         ; Slew rate port U bit 5
SRRU_SRRU6:         equ    6                                         ; Slew rate port U bit 6
SRRU_SRRU7:         equ    7                                         ; Slew rate port U bit 7
; bit position masks
mSRRU_SRRU0:        equ    %00000001
mSRRU_SRRU1:        equ    %00000010
mSRRU_SRRU2:        equ    %00000100
mSRRU_SRRU3:        equ    %00001000
mSRRU_SRRU4:        equ    %00010000
mSRRU_SRRU5:        equ    %00100000
mSRRU_SRRU6:        equ    %01000000
mSRRU_SRRU7:        equ    %10000000


;*** PERU - Port U Pull Device Enable Register; 0x0000023C ***
PERU:               equ    $0000023C                                ;*** PERU - Port U Pull Device Enable Register; 0x0000023C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERU_PERU0:         equ    0                                         ; Port U pull device enable bit 0
PERU_PERU1:         equ    1                                         ; Port U pull device enable bit 1
PERU_PERU2:         equ    2                                         ; Port U pull device enable bit 2
PERU_PERU3:         equ    3                                         ; Port U pull device enable bit 3
PERU_PERU4:         equ    4                                         ; Port U pull device enable bit 4
PERU_PERU5:         equ    5                                         ; Port U pull device enable bit 5
PERU_PERU6:         equ    6                                         ; Port U pull device enable bit 6
PERU_PERU7:         equ    7                                         ; Port U pull device enable bit 7
; bit position masks
mPERU_PERU0:        equ    %00000001
mPERU_PERU1:        equ    %00000010
mPERU_PERU2:        equ    %00000100
mPERU_PERU3:        equ    %00001000
mPERU_PERU4:        equ    %00010000
mPERU_PERU5:        equ    %00100000
mPERU_PERU6:        equ    %01000000
mPERU_PERU7:        equ    %10000000


;*** PPSU - Port U Polarity Select Register; 0x0000023D ***
PPSU:               equ    $0000023D                                ;*** PPSU - Port U Polarity Select Register; 0x0000023D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSU_PPSU0:         equ    0                                         ; Port U pull device select bit 0
PPSU_PPSU1:         equ    1                                         ; Port U pull device select bit 1
PPSU_PPSU2:         equ    2                                         ; Port U pull device select bit 2
PPSU_PPSU3:         equ    3                                         ; Port U pull device select bit 3
PPSU_PPSU4:         equ    4                                         ; Port U pull device select bit 4
PPSU_PPSU5:         equ    5                                         ; Port U pull device select bit 5
PPSU_PPSU6:         equ    6                                         ; Port U pull device select bit 6
PPSU_PPSU7:         equ    7                                         ; Port U pull device select bit 7
; bit position masks
mPPSU_PPSU0:        equ    %00000001
mPPSU_PPSU1:        equ    %00000010
mPPSU_PPSU2:        equ    %00000100
mPPSU_PPSU3:        equ    %00001000
mPPSU_PPSU4:        equ    %00010000
mPPSU_PPSU5:        equ    %00100000
mPPSU_PPSU6:        equ    %01000000
mPPSU_PPSU7:        equ    %10000000


;*** PTV - Port V Data Register; 0x00000240 ***
PTV:                equ    $00000240                                ;*** PTV - Port V Data Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTV_PTV0:           equ    0                                         ; Port V general purpose input/output data bit 0
PTV_PTV1:           equ    1                                         ; Port V general purpose input/output data bit 1
PTV_PTV2:           equ    2                                         ; Port V general purpose input/output data bit 2
PTV_PTV3:           equ    3                                         ; Port V general purpose input/output data bit 3
PTV_PTV4:           equ    4                                         ; Port V general purpose input/output data bit 4
PTV_PTV5:           equ    5                                         ; Port V general purpose input/output data bit 5
PTV_PTV6:           equ    6                                         ; Port V general purpose input/output data bit 6
PTV_PTV7:           equ    7                                         ; Port V general purpose input/output data bit 7
; bit position masks
mPTV_PTV0:          equ    %00000001
mPTV_PTV1:          equ    %00000010
mPTV_PTV2:          equ    %00000100
mPTV_PTV3:          equ    %00001000
mPTV_PTV4:          equ    %00010000
mPTV_PTV5:          equ    %00100000
mPTV_PTV6:          equ    %01000000
mPTV_PTV7:          equ    %10000000


;*** PTIV - Port V Input Register; 0x00000241 ***
PTIV:               equ    $00000241                                ;*** PTIV - Port V Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIV_PTIV0:         equ    0                                         ; Port V input data bit 0
PTIV_PTIV1:         equ    1                                         ; Port V input data bit 1
PTIV_PTIV2:         equ    2                                         ; Port V input data bit 2
PTIV_PTIV3:         equ    3                                         ; Port V input data bit 3
PTIV_PTIV4:         equ    4                                         ; Port V input data bit 4
PTIV_PTIV5:         equ    5                                         ; Port V input data bit 5
PTIV_PTIV6:         equ    6                                         ; Port V input data bit 6
PTIV_PTIV7:         equ    7                                         ; Port V input data bit 7
; bit position masks
mPTIV_PTIV0:        equ    %00000001
mPTIV_PTIV1:        equ    %00000010
mPTIV_PTIV2:        equ    %00000100
mPTIV_PTIV3:        equ    %00001000
mPTIV_PTIV4:        equ    %00010000
mPTIV_PTIV5:        equ    %00100000
mPTIV_PTIV6:        equ    %01000000
mPTIV_PTIV7:        equ    %10000000


;*** DDRV - Port V Data Direction Register; 0x00000242 ***
DDRV:               equ    $00000242                                ;*** DDRV - Port V Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRV_DDRV0:         equ    0                                         ; Port V data direction bit 0
DDRV_DDRV1:         equ    1                                         ; Port V data direction bit 1
DDRV_DDRV2:         equ    2                                         ; Port V data direction bit 2
DDRV_DDRV3:         equ    3                                         ; Port V data direction bit 3
DDRV_DDRV4:         equ    4                                         ; Port V data direction bit 4
DDRV_DDRV5:         equ    5                                         ; Port V data direction bit 5
DDRV_DDRV6:         equ    6                                         ; Port V data direction bit 6
DDRV_DDRV7:         equ    7                                         ; Port V data direction bit 7
; bit position masks
mDDRV_DDRV0:        equ    %00000001
mDDRV_DDRV1:        equ    %00000010
mDDRV_DDRV2:        equ    %00000100
mDDRV_DDRV3:        equ    %00001000
mDDRV_DDRV4:        equ    %00010000
mDDRV_DDRV5:        equ    %00100000
mDDRV_DDRV6:        equ    %01000000
mDDRV_DDRV7:        equ    %10000000


;*** SRRV - Port V Slew Rate Register; 0x00000243 ***
SRRV:               equ    $00000243                                ;*** SRRV - Port V Slew Rate Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRV_SRRV0:         equ    0                                         ; Slew rate port V bit 0
SRRV_SRRV1:         equ    1                                         ; Slew rate port V bit 1
SRRV_SRRV2:         equ    2                                         ; Slew rate port V bit 2
SRRV_SRRV3:         equ    3                                         ; Slew rate port V bit 3
SRRV_SRRV4:         equ    4                                         ; Slew rate port V bit 4
SRRV_SRRV5:         equ    5                                         ; Slew rate port V bit 5
SRRV_SRRV6:         equ    6                                         ; Slew rate port V bit 6
SRRV_SRRV7:         equ    7                                         ; Slew rate port V bit 7
; bit position masks
mSRRV_SRRV0:        equ    %00000001
mSRRV_SRRV1:        equ    %00000010
mSRRV_SRRV2:        equ    %00000100
mSRRV_SRRV3:        equ    %00001000
mSRRV_SRRV4:        equ    %00010000
mSRRV_SRRV5:        equ    %00100000
mSRRV_SRRV6:        equ    %01000000
mSRRV_SRRV7:        equ    %10000000


;*** PERV - Port V Pull Device Enable Register; 0x00000244 ***
PERV:               equ    $00000244                                ;*** PERV - Port V Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERV_PERV0:         equ    0                                         ; Port V pull device enable bit 0
PERV_PERV1:         equ    1                                         ; Port V pull device enable bit 1
PERV_PERV2:         equ    2                                         ; Port V pull device enable bit 2
PERV_PERV3:         equ    3                                         ; Port V pull device enable bit 3
PERV_PERV4:         equ    4                                         ; Port V pull device enable bit 4
PERV_PERV5:         equ    5                                         ; Port V pull device enable bit 5
PERV_PERV6:         equ    6                                         ; Port V pull device enable bit 6
PERV_PERV7:         equ    7                                         ; Port V pull device enable bit 7
; bit position masks
mPERV_PERV0:        equ    %00000001
mPERV_PERV1:        equ    %00000010
mPERV_PERV2:        equ    %00000100
mPERV_PERV3:        equ    %00001000
mPERV_PERV4:        equ    %00010000
mPERV_PERV5:        equ    %00100000
mPERV_PERV6:        equ    %01000000
mPERV_PERV7:        equ    %10000000


;*** PPSV - Port V Polarity Select Register; 0x00000245 ***
PPSV:               equ    $00000245                                ;*** PPSV - Port V Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSV_PPSV0:         equ    0                                         ; Port V pull device select bit 0
PPSV_PPSV1:         equ    1                                         ; Port V pull device select bit 1
PPSV_PPSV2:         equ    2                                         ; Port V pull device select bit 2
PPSV_PPSV3:         equ    3                                         ; Port V pull device select bit 3
PPSV_PPSV4:         equ    4                                         ; Port V pull device select bit 4
PPSV_PPSV5:         equ    5                                         ; Port V pull device select bit 5
PPSV_PPSV6:         equ    6                                         ; Port V pull device select bit 6
PPSV_PPSV7:         equ    7                                         ; Port V pull device select bit 7
; bit position masks
mPPSV_PPSV0:        equ    %00000001
mPPSV_PPSV1:        equ    %00000010
mPPSV_PPSV2:        equ    %00000100
mPPSV_PPSV3:        equ    %00001000
mPPSV_PPSV4:        equ    %00010000
mPPSV_PPSV5:        equ    %00100000
mPPSV_PPSV6:        equ    %01000000
mPPSV_PPSV7:        equ    %10000000


;*** PTW - Port W Data Register; 0x00000248 ***
PTW:                equ    $00000248                                ;*** PTW - Port W Data Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTW_PTW0:           equ    0                                         ; Port W general purpose input/output data bit 0
PTW_PTW1:           equ    1                                         ; Port W general purpose input/output data bit 1
PTW_PTW2:           equ    2                                         ; Port W general purpose input/output data bit 2
PTW_PTW3:           equ    3                                         ; Port W general purpose input/output data bit 3
PTW_PTW4:           equ    4                                         ; Port W general purpose input/output data bit 4
PTW_PTW5:           equ    5                                         ; Port W general purpose input/output data bit 5
PTW_PTW6:           equ    6                                         ; Port W general purpose input/output data bit 6
PTW_PTW7:           equ    7                                         ; Port W general purpose input/output data bit 7
; bit position masks
mPTW_PTW0:          equ    %00000001
mPTW_PTW1:          equ    %00000010
mPTW_PTW2:          equ    %00000100
mPTW_PTW3:          equ    %00001000
mPTW_PTW4:          equ    %00010000
mPTW_PTW5:          equ    %00100000
mPTW_PTW6:          equ    %01000000
mPTW_PTW7:          equ    %10000000


;*** PTIW - Port W Input Register; 0x00000249 ***
PTIW:               equ    $00000249                                ;*** PTIW - Port W Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIW_PTIW0:         equ    0                                         ; Port W input data bit 0
PTIW_PTIW1:         equ    1                                         ; Port W input data bit 1
PTIW_PTIW2:         equ    2                                         ; Port W input data bit 2
PTIW_PTIW3:         equ    3                                         ; Port W input data bit 3
PTIW_PTIW4:         equ    4                                         ; Port W input data bit 4
PTIW_PTIW5:         equ    5                                         ; Port W input data bit 5
PTIW_PTIW6:         equ    6                                         ; Port W input data bit 6
PTIW_PTIW7:         equ    7                                         ; Port W input data bit 7
; bit position masks
mPTIW_PTIW0:        equ    %00000001
mPTIW_PTIW1:        equ    %00000010
mPTIW_PTIW2:        equ    %00000100
mPTIW_PTIW3:        equ    %00001000
mPTIW_PTIW4:        equ    %00010000
mPTIW_PTIW5:        equ    %00100000
mPTIW_PTIW6:        equ    %01000000
mPTIW_PTIW7:        equ    %10000000


;*** DDRW - Port W Data Direction Register; 0x0000024A ***
DDRW:               equ    $0000024A                                ;*** DDRW - Port W Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRW_DDRW0:         equ    0                                         ; Port W data direction bit 0
DDRW_DDRW1:         equ    1                                         ; Port W data direction bit 1
DDRW_DDRW2:         equ    2                                         ; Port W data direction bit 2
DDRW_DDRW3:         equ    3                                         ; Port W data direction bit 3
DDRW_DDRW4:         equ    4                                         ; Port W data direction bit 4
DDRW_DDRW5:         equ    5                                         ; Port W data direction bit 5
DDRW_DDRW6:         equ    6                                         ; Port W data direction bit 6
DDRW_DDRW7:         equ    7                                         ; Port W data direction bit 7
; bit position masks
mDDRW_DDRW0:        equ    %00000001
mDDRW_DDRW1:        equ    %00000010
mDDRW_DDRW2:        equ    %00000100
mDDRW_DDRW3:        equ    %00001000
mDDRW_DDRW4:        equ    %00010000
mDDRW_DDRW5:        equ    %00100000
mDDRW_DDRW6:        equ    %01000000
mDDRW_DDRW7:        equ    %10000000


;*** SRRW - Port W Slew Rate Register; 0x0000024B ***
SRRW:               equ    $0000024B                                ;*** SRRW - Port W Slew Rate Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRRW_SRRW0:         equ    0                                         ; Slew rate port W bit 0
SRRW_SRRW1:         equ    1                                         ; Slew rate port W bit 1
SRRW_SRRW2:         equ    2                                         ; Slew rate port W bit 2
SRRW_SRRW3:         equ    3                                         ; Slew rate port W bit 3
SRRW_SRRW4:         equ    4                                         ; Slew rate port W bit 4
SRRW_SRRW5:         equ    5                                         ; Slew rate port W bit 5
SRRW_SRRW6:         equ    6                                         ; Slew rate port W bit 6
SRRW_SRRW7:         equ    7                                         ; Slew rate port W bit 7
; bit position masks
mSRRW_SRRW0:        equ    %00000001
mSRRW_SRRW1:        equ    %00000010
mSRRW_SRRW2:        equ    %00000100
mSRRW_SRRW3:        equ    %00001000
mSRRW_SRRW4:        equ    %00010000
mSRRW_SRRW5:        equ    %00100000
mSRRW_SRRW6:        equ    %01000000
mSRRW_SRRW7:        equ    %10000000


;*** PERW - Port W Pull Device Enable Register; 0x0000024C ***
PERW:               equ    $0000024C                                ;*** PERW - Port W Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERW_PERW0:         equ    0                                         ; Port W pull device enable bit 0
PERW_PERW1:         equ    1                                         ; Port W pull device enable bit 1
PERW_PERW2:         equ    2                                         ; Port W pull device enable bit 2
PERW_PERW3:         equ    3                                         ; Port W pull device enable bit 3
PERW_PERW4:         equ    4                                         ; Port W pull device enable bit 4
PERW_PERW5:         equ    5                                         ; Port W pull device enable bit 5
PERW_PERW6:         equ    6                                         ; Port W pull device enable bit 6
PERW_PERW7:         equ    7                                         ; Port W pull device enable bit 7
; bit position masks
mPERW_PERW0:        equ    %00000001
mPERW_PERW1:        equ    %00000010
mPERW_PERW2:        equ    %00000100
mPERW_PERW3:        equ    %00001000
mPERW_PERW4:        equ    %00010000
mPERW_PERW5:        equ    %00100000
mPERW_PERW6:        equ    %01000000
mPERW_PERW7:        equ    %10000000


;*** PPSW - Port W Polarity Select Register; 0x0000024D ***
PPSW:               equ    $0000024D                                ;*** PPSW - Port W Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSW_PPSW0:         equ    0                                         ; Port W pull device select bit 0
PPSW_PPSW1:         equ    1                                         ; Port W pull device select bit 1
PPSW_PPSW2:         equ    2                                         ; Port W pull device select bit 2
PPSW_PPSW3:         equ    3                                         ; Port W pull device select bit 3
PPSW_PPSW4:         equ    4                                         ; Port W pull device select bit 4
PPSW_PPSW5:         equ    5                                         ; Port W pull device select bit 5
PPSW_PPSW6:         equ    6                                         ; Port W pull device select bit 6
PPSW_PPSW7:         equ    7                                         ; Port W pull device select bit 7
; bit position masks
mPPSW_PPSW0:        equ    %00000001
mPPSW_PPSW1:        equ    %00000010
mPPSW_PPSW2:        equ    %00000100
mPPSW_PPSW3:        equ    %00001000
mPPSW_PPSW4:        equ    %00010000
mPPSW_PPSW5:        equ    %00100000
mPPSW_PPSW6:        equ    %01000000
mPPSW_PPSW7:        equ    %10000000


;*** PTAD - Port AD Data Register; 0x00000251 ***
PTAD:               equ    $00000251                                ;*** PTAD - Port AD Data Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port AD data bit 0
PTAD_PTAD1:         equ    1                                         ; Port AD data bit 1
PTAD_PTAD2:         equ    2                                         ; Port AD data bit 2
PTAD_PTAD3:         equ    3                                         ; Port AD data bit 3
PTAD_PTAD4:         equ    4                                         ; Port AD data bit 4
PTAD_PTAD5:         equ    5                                         ; Port AD data bit 5
PTAD_PTAD6:         equ    6                                         ; Port AD data bit 6
PTAD_PTAD7:         equ    7                                         ; Port AD data bit 7
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000
mPTAD_PTAD6:        equ    %01000000
mPTAD_PTAD7:        equ    %10000000


;*** PTIAD - Port AD Input Register; 0x00000253 ***
PTIAD:              equ    $00000253                                ;*** PTIAD - Port AD Input Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIAD_PTIAD0:       equ    0                                         ; Port AD Bit 0
PTIAD_PTIAD1:       equ    1                                         ; Port AD Bit 1
PTIAD_PTIAD2:       equ    2                                         ; Port AD Bit 2
PTIAD_PTIAD3:       equ    3                                         ; Port AD Bit 3
PTIAD_PTIAD4:       equ    4                                         ; Port AD Bit 4
PTIAD_PTIAD5:       equ    5                                         ; Port AD Bit 5
PTIAD_PTIAD6:       equ    6                                         ; Port AD Bit 6
PTIAD_PTIAD7:       equ    7                                         ; Port AD Bit 7
; bit position masks
mPTIAD_PTIAD0:      equ    %00000001
mPTIAD_PTIAD1:      equ    %00000010
mPTIAD_PTIAD2:      equ    %00000100
mPTIAD_PTIAD3:      equ    %00001000
mPTIAD_PTIAD4:      equ    %00010000
mPTIAD_PTIAD5:      equ    %00100000
mPTIAD_PTIAD6:      equ    %01000000
mPTIAD_PTIAD7:      equ    %10000000


;*** DDRAD - Port AD Data Direction Register; 0x00000255 ***
DDRAD:              equ    $00000255                                ;*** DDRAD - Port AD Data Direction Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAD_DDRAD0:       equ    0                                         ; Port AD data direction bit 0
DDRAD_DDRAD1:       equ    1                                         ; Port AD data direction bit 1
DDRAD_DDRAD2:       equ    2                                         ; Port AD data direction bit 2
DDRAD_DDRAD3:       equ    3                                         ; Port AD data direction bit 3
DDRAD_DDRAD4:       equ    4                                         ; Port AD data direction bit 4
DDRAD_DDRAD5:       equ    5                                         ; Port AD data direction bit 5
DDRAD_DDRAD6:       equ    6                                         ; Port AD data direction bit 6
DDRAD_DDRAD7:       equ    7                                         ; Port AD data direction bit 7
; bit position masks
mDDRAD_DDRAD0:      equ    %00000001
mDDRAD_DDRAD1:      equ    %00000010
mDDRAD_DDRAD2:      equ    %00000100
mDDRAD_DDRAD3:      equ    %00001000
mDDRAD_DDRAD4:      equ    %00010000
mDDRAD_DDRAD5:      equ    %00100000
mDDRAD_DDRAD6:      equ    %01000000
mDDRAD_DDRAD7:      equ    %10000000


;*** RDRAD - Port AD Reduced Drive Register; 0x00000257 ***
RDRAD:              equ    $00000257                                ;*** RDRAD - Port AD Reduced Drive Register; 0x00000257 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRAD_RDRAD0:       equ    0                                         ; Port AD reduced drive bit 0
RDRAD_RDRAD1:       equ    1                                         ; Port AD reduced drive bit 1
RDRAD_RDRAD2:       equ    2                                         ; Port AD reduced drive bit 2
RDRAD_RDRAD3:       equ    3                                         ; Port AD reduced drive bit 3
RDRAD_RDRAD4:       equ    4                                         ; Port AD reduced drive bit 4
RDRAD_RDRAD5:       equ    5                                         ; Port AD reduced drive bit 5
RDRAD_RDRAD6:       equ    6                                         ; Port AD reduced drive bit 6
RDRAD_RDRAD7:       equ    7                                         ; Port AD reduced drive bit 7
; bit position masks
mRDRAD_RDRAD0:      equ    %00000001
mRDRAD_RDRAD1:      equ    %00000010
mRDRAD_RDRAD2:      equ    %00000100
mRDRAD_RDRAD3:      equ    %00001000
mRDRAD_RDRAD4:      equ    %00010000
mRDRAD_RDRAD5:      equ    %00100000
mRDRAD_RDRAD6:      equ    %01000000
mRDRAD_RDRAD7:      equ    %10000000


;*** PERAD - Port AD Pull Up Enable Register; 0x00000259 ***
PERAD:              equ    $00000259                                ;*** PERAD - Port AD Pull Up Enable Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERAD_PERAD0:       equ    0                                         ; Port AD pull up enable bit 0
PERAD_PERAD1:       equ    1                                         ; Port AD pull up enable bit 1
PERAD_PERAD2:       equ    2                                         ; Port AD pull up enable bit 2
PERAD_PERAD3:       equ    3                                         ; Port AD pull up enable bit 3
PERAD_PERAD4:       equ    4                                         ; Port AD pull up enable bit 4
PERAD_PERAD5:       equ    5                                         ; Port AD pull up enable bit 5
PERAD_PERAD6:       equ    6                                         ; Port AD pull up enable bit 6
PERAD_PERAD7:       equ    7                                         ; Port AD pull up enable bit 7
; bit position masks
mPERAD_PERAD0:      equ    %00000001
mPERAD_PERAD1:      equ    %00000010
mPERAD_PERAD2:      equ    %00000100
mPERAD_PERAD3:      equ    %00001000
mPERAD_PERAD4:      equ    %00010000
mPERAD_PERAD5:      equ    %00100000
mPERAD_PERAD6:      equ    %01000000
mPERAD_PERAD7:      equ    %10000000


;*** PPSAD - Port AD Polarity Select Register; 0x0000025B ***
PPSAD:              equ    $0000025B                                ;*** PPSAD - Port AD Polarity Select Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSAD_PPSAD0:       equ    0                                         ; Port AD Polarity Select Bit 0
PPSAD_PPSAD1:       equ    1                                         ; Port AD Polarity Select Bit 1
PPSAD_PPSAD2:       equ    2                                         ; Port AD Polarity Select Bit 2
PPSAD_PPSAD3:       equ    3                                         ; Port AD Polarity Select Bit 3
PPSAD_PPSAD4:       equ    4                                         ; Port AD Polarity Select Bit 4
PPSAD_PPSAD5:       equ    5                                         ; Port AD Polarity Select Bit 5
PPSAD_PPSAD6:       equ    6                                         ; Port AD Polarity Select Bit 6
PPSAD_PPSAD7:       equ    7                                         ; Port AD Polarity Select Bit 7
; bit position masks
mPPSAD_PPSAD0:      equ    %00000001
mPPSAD_PPSAD1:      equ    %00000010
mPPSAD_PPSAD2:      equ    %00000100
mPPSAD_PPSAD3:      equ    %00001000
mPPSAD_PPSAD4:      equ    %00010000
mPPSAD_PPSAD5:      equ    %00100000
mPPSAD_PPSAD6:      equ    %01000000
mPPSAD_PPSAD7:      equ    %10000000


;*** PIEAD - Port AD Interrupt Enable Register; 0x0000025D ***
PIEAD:              equ    $0000025D                                ;*** PIEAD - Port AD Interrupt Enable Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEAD_PIEAD0:       equ    0                                         ; Port AD Interrupt Enable Bit 0
PIEAD_PIEAD1:       equ    1                                         ; Port AD Interrupt Enable Bit 1
PIEAD_PIEAD2:       equ    2                                         ; Port AD Interrupt Enable Bit 2
PIEAD_PIEAD3:       equ    3                                         ; Port AD Interrupt Enable Bit 3
PIEAD_PIEAD4:       equ    4                                         ; Port AD Interrupt Enable Bit 4
PIEAD_PIEAD5:       equ    5                                         ; Port AD Interrupt Enable Bit 5
PIEAD_PIEAD6:       equ    6                                         ; Port AD Interrupt Enable Bit 6
PIEAD_PIEAD7:       equ    7                                         ; Port AD Interrupt Enable Bit 7
; bit position masks
mPIEAD_PIEAD0:      equ    %00000001
mPIEAD_PIEAD1:      equ    %00000010
mPIEAD_PIEAD2:      equ    %00000100
mPIEAD_PIEAD3:      equ    %00001000
mPIEAD_PIEAD4:      equ    %00010000
mPIEAD_PIEAD5:      equ    %00100000
mPIEAD_PIEAD6:      equ    %01000000
mPIEAD_PIEAD7:      equ    %10000000


;*** PIFAD - Port AD Interrupt Flag Register; 0x0000025F ***
PIFAD:              equ    $0000025F                                ;*** PIFAD - Port AD Interrupt Flag Register; 0x0000025F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFAD_PIFAD0:       equ    0                                         ; Port AD Bit 0
PIFAD_PIFAD1:       equ    1                                         ; Port AD Bit 1
PIFAD_PIFAD2:       equ    2                                         ; Port AD Bit 2
PIFAD_PIFAD3:       equ    3                                         ; Port AD Bit 3
PIFAD_PIFAD4:       equ    4                                         ; Port AD Bit 4
PIFAD_PIFAD5:       equ    5                                         ; Port AD Bit 5
PIFAD_PIFAD6:       equ    6                                         ; Port AD Bit 6
PIFAD_PIFAD7:       equ    7                                         ; Port AD Bit 7
; bit position masks
mPIFAD_PIFAD0:      equ    %00000001
mPIFAD_PIFAD1:      equ    %00000010
mPIFAD_PIFAD2:      equ    %00000100
mPIFAD_PIFAD3:      equ    %00001000
mPIFAD_PIFAD4:      equ    %00010000
mPIFAD_PIFAD5:      equ    %00100000
mPIFAD_PIFAD6:      equ    %01000000
mPIFAD_PIFAD7:      equ    %10000000


;*** RTZ4CTL - SSD4 Return-to-Zero Control Register; 0x00000280 ***
RTZ4CTL:            equ    $00000280                                ;*** RTZ4CTL - SSD4 Return-to-Zero Control Register; 0x00000280 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ4CTL_STEP:       equ    0                                         ; Full Step State
RTZ4CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ4CTL_POL:        equ    4                                         ; Polarity
RTZ4CTL_RCIR:       equ    5                                         ; Recirculation in Blanking Mode
RTZ4CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ4CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ4CTL_STEP:      equ    %00000011
mRTZ4CTL_SMS:       equ    %00000100
mRTZ4CTL_POL:       equ    %00010000
mRTZ4CTL_RCIR:      equ    %00100000
mRTZ4CTL_DCOIL:     equ    %01000000
mRTZ4CTL_ITG:       equ    %10000000


;*** MDC4CTL - SSD4 Modulus Down Counter Control Register; 0x00000281 ***
MDC4CTL:            equ    $00000281                                ;*** MDC4CTL - SSD4 Modulus Down Counter Control Register; 0x00000281 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC4CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC4CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC4CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC4CTL_PRE:        equ    4                                         ; Prescaler
MDC4CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC4CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC4CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC4CTL_AOVIE:     equ    %00000001
mMDC4CTL_MCEN:      equ    %00000100
mMDC4CTL_FLMC:      equ    %00001000
mMDC4CTL_PRE:       equ    %00010000
mMDC4CTL_RDMCL:     equ    %00100000
mMDC4CTL_MODMC:     equ    %01000000
mMDC4CTL_MCZIE:     equ    %10000000


;*** SSD4CTL - SSD4 Stepper Stall Detector Control Register; 0x00000282 ***
SSD4CTL:            equ    $00000282                                ;*** SSD4CTL - SSD4 Stepper Stall Detector Control Register; 0x00000282 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD4CTL_ACLKS:      equ    0                                         ; Accumulator Sample Frequency Select
SSD4CTL_FTST:       equ    4                                         ; Factory Test
SSD4CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD4CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD4CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD4CTL_ACLKS:     equ    %00000011
mSSD4CTL_FTST:      equ    %00010000
mSSD4CTL_SSDWAI:    equ    %00100000
mSSD4CTL_SDCPU:     equ    %01000000
mSSD4CTL_RTZE:      equ    %10000000


;*** SSD4FLG - SSD4 Stepper Stall Detector Flag Register; 0x00000283 ***
SSD4FLG:            equ    $00000283                                ;*** SSD4FLG - SSD4 Stepper Stall Detector Flag Register; 0x00000283 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD4FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD4FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD4FLG_AOVIF:     equ    %00000001
mSSD4FLG_MCZIF:     equ    %10000000


;*** MDC4CNT - SSD4 Modulus Down-Counter Count Register; 0x00000284 ***
MDC4CNT:            equ    $00000284                                ;*** MDC4CNT - SSD4 Modulus Down-Counter Count Register; 0x00000284 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC4CNT_MDCCNT:     equ    0                                         ; Modulus Down Counter
; bit position masks
mMDC4CNT_MDCCNT:    equ    %1111111111111111


;*** ITG4ACC - SSD4 Integration Accumulator Register; 0x00000286 ***
ITG4ACC:            equ    $00000286                                ;*** ITG4ACC - SSD4 Integration Accumulator Register; 0x00000286 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG4ACC_ITGACC:     equ    0                                         ; Integration Accumulator
; bit position masks
mITG4ACC_ITGACC:    equ    %1111111111111111


;*** RTZ0CTL - SSD0 Return-to-Zero Control Register; 0x00000288 ***
RTZ0CTL:            equ    $00000288                                ;*** RTZ0CTL - SSD0 Return-to-Zero Control Register; 0x00000288 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ0CTL_STEP:       equ    0                                         ; Full Step State
RTZ0CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ0CTL_POL:        equ    4                                         ; Polarity
RTZ0CTL_RCIR:       equ    5                                         ; Recirculation in Blanking Mode
RTZ0CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ0CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ0CTL_STEP:      equ    %00000011
mRTZ0CTL_SMS:       equ    %00000100
mRTZ0CTL_POL:       equ    %00010000
mRTZ0CTL_RCIR:      equ    %00100000
mRTZ0CTL_DCOIL:     equ    %01000000
mRTZ0CTL_ITG:       equ    %10000000


;*** MDC0CTL - SSD0 Modulus Down Counter Control Register; 0x00000289 ***
MDC0CTL:            equ    $00000289                                ;*** MDC0CTL - SSD0 Modulus Down Counter Control Register; 0x00000289 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC0CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC0CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC0CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC0CTL_PRE:        equ    4                                         ; Prescaler
MDC0CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC0CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC0CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC0CTL_AOVIE:     equ    %00000001
mMDC0CTL_MCEN:      equ    %00000100
mMDC0CTL_FLMC:      equ    %00001000
mMDC0CTL_PRE:       equ    %00010000
mMDC0CTL_RDMCL:     equ    %00100000
mMDC0CTL_MODMC:     equ    %01000000
mMDC0CTL_MCZIE:     equ    %10000000


;*** SSD0CTL - SSD0 Stepper Stall Detector Control Register; 0x0000028A ***
SSD0CTL:            equ    $0000028A                                ;*** SSD0CTL - SSD0 Stepper Stall Detector Control Register; 0x0000028A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD0CTL_ACLKS:      equ    0                                         ; Accumulator Sample Frequency Select
SSD0CTL_FTST:       equ    4                                         ; Factory Test
SSD0CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD0CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD0CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD0CTL_ACLKS:     equ    %00000011
mSSD0CTL_FTST:      equ    %00010000
mSSD0CTL_SSDWAI:    equ    %00100000
mSSD0CTL_SDCPU:     equ    %01000000
mSSD0CTL_RTZE:      equ    %10000000


;*** SSD0FLG - SSD0 Stepper Stall Detector Flag Register; 0x0000028B ***
SSD0FLG:            equ    $0000028B                                ;*** SSD0FLG - SSD0 Stepper Stall Detector Flag Register; 0x0000028B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD0FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD0FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD0FLG_AOVIF:     equ    %00000001
mSSD0FLG_MCZIF:     equ    %10000000


;*** MDC0CNT - SSD0 Modulus Down-Counter Count Register; 0x0000028C ***
MDC0CNT:            equ    $0000028C                                ;*** MDC0CNT - SSD0 Modulus Down-Counter Count Register; 0x0000028C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC0CNT_MDCCNT:     equ    0                                         ; Modulus Down Counter
; bit position masks
mMDC0CNT_MDCCNT:    equ    %1111111111111111


;*** ITG0ACC - SSD0 Integration Accumulator Register; 0x0000028E ***
ITG0ACC:            equ    $0000028E                                ;*** ITG0ACC - SSD0 Integration Accumulator Register; 0x0000028E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG0ACC_ITGACC:     equ    0                                         ; Integration Accumulator
; bit position masks
mITG0ACC_ITGACC:    equ    %1111111111111111


;*** RTZ1CTL - SSD1 Return-to-Zero Control Register; 0x00000290 ***
RTZ1CTL:            equ    $00000290                                ;*** RTZ1CTL - SSD1 Return-to-Zero Control Register; 0x00000290 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ1CTL_STEP:       equ    0                                         ; Full Step State
RTZ1CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ1CTL_POL:        equ    4                                         ; Polarity
RTZ1CTL_RCIR:       equ    5                                         ; Recirculation in Blanking Mode
RTZ1CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ1CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ1CTL_STEP:      equ    %00000011
mRTZ1CTL_SMS:       equ    %00000100
mRTZ1CTL_POL:       equ    %00010000
mRTZ1CTL_RCIR:      equ    %00100000
mRTZ1CTL_DCOIL:     equ    %01000000
mRTZ1CTL_ITG:       equ    %10000000


;*** MDC1CTL - SSD1 Modulus Down Counter Control Register; 0x00000291 ***
MDC1CTL:            equ    $00000291                                ;*** MDC1CTL - SSD1 Modulus Down Counter Control Register; 0x00000291 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC1CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC1CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC1CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC1CTL_PRE:        equ    4                                         ; Prescaler
MDC1CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC1CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC1CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC1CTL_AOVIE:     equ    %00000001
mMDC1CTL_MCEN:      equ    %00000100
mMDC1CTL_FLMC:      equ    %00001000
mMDC1CTL_PRE:       equ    %00010000
mMDC1CTL_RDMCL:     equ    %00100000
mMDC1CTL_MODMC:     equ    %01000000
mMDC1CTL_MCZIE:     equ    %10000000


;*** SSD1CTL - SSD1 Stepper Stall Detector Control Register; 0x00000292 ***
SSD1CTL:            equ    $00000292                                ;*** SSD1CTL - SSD1 Stepper Stall Detector Control Register; 0x00000292 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD1CTL_ACLKS:      equ    0                                         ; Accumulator Sample Frequency Select
SSD1CTL_FTST:       equ    4                                         ; Factory Test
SSD1CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD1CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD1CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD1CTL_ACLKS:     equ    %00000011
mSSD1CTL_FTST:      equ    %00010000
mSSD1CTL_SSDWAI:    equ    %00100000
mSSD1CTL_SDCPU:     equ    %01000000
mSSD1CTL_RTZE:      equ    %10000000


;*** SSD1FLG - SSD1 Stepper Stall Detector Flag Register; 0x00000293 ***
SSD1FLG:            equ    $00000293                                ;*** SSD1FLG - SSD1 Stepper Stall Detector Flag Register; 0x00000293 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD1FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD1FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD1FLG_AOVIF:     equ    %00000001
mSSD1FLG_MCZIF:     equ    %10000000


;*** MDC1CNT - SSD1 Modulus Down-Counter Count Register; 0x00000294 ***
MDC1CNT:            equ    $00000294                                ;*** MDC1CNT - SSD1 Modulus Down-Counter Count Register; 0x00000294 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC1CNT_MDCCNT:     equ    0                                         ; Modulus Down Counter
; bit position masks
mMDC1CNT_MDCCNT:    equ    %1111111111111111


;*** ITG1ACC - SSD1 Integration Accumulator Register; 0x00000296 ***
ITG1ACC:            equ    $00000296                                ;*** ITG1ACC - SSD1 Integration Accumulator Register; 0x00000296 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG1ACC_ITGACC:     equ    0                                         ; Integration Accumulator
; bit position masks
mITG1ACC_ITGACC:    equ    %1111111111111111


;*** RTZ2CTL - SSD2 Return-to-Zero Control Register; 0x00000298 ***
RTZ2CTL:            equ    $00000298                                ;*** RTZ2CTL - SSD2 Return-to-Zero Control Register; 0x00000298 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ2CTL_STEP:       equ    0                                         ; Full Step State
RTZ2CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ2CTL_POL:        equ    4                                         ; Polarity
RTZ2CTL_RCIR:       equ    5                                         ; Recirculation in Blanking Mode
RTZ2CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ2CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ2CTL_STEP:      equ    %00000011
mRTZ2CTL_SMS:       equ    %00000100
mRTZ2CTL_POL:       equ    %00010000
mRTZ2CTL_RCIR:      equ    %00100000
mRTZ2CTL_DCOIL:     equ    %01000000
mRTZ2CTL_ITG:       equ    %10000000


;*** MDC2CTL - SSD2 Modulus Down Counter Control Register; 0x00000299 ***
MDC2CTL:            equ    $00000299                                ;*** MDC2CTL - SSD2 Modulus Down Counter Control Register; 0x00000299 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC2CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC2CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC2CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC2CTL_PRE:        equ    4                                         ; Prescaler
MDC2CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC2CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC2CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC2CTL_AOVIE:     equ    %00000001
mMDC2CTL_MCEN:      equ    %00000100
mMDC2CTL_FLMC:      equ    %00001000
mMDC2CTL_PRE:       equ    %00010000
mMDC2CTL_RDMCL:     equ    %00100000
mMDC2CTL_MODMC:     equ    %01000000
mMDC2CTL_MCZIE:     equ    %10000000


;*** SSD2CTL - SSD2 Stepper Stall Detector Control Register; 0x0000029A ***
SSD2CTL:            equ    $0000029A                                ;*** SSD2CTL - SSD2 Stepper Stall Detector Control Register; 0x0000029A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD2CTL_ACLKS:      equ    0                                         ; Accumulator Sample Frequency Select
SSD2CTL_FTST:       equ    4                                         ; Factory Test
SSD2CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD2CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD2CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD2CTL_ACLKS:     equ    %00000011
mSSD2CTL_FTST:      equ    %00010000
mSSD2CTL_SSDWAI:    equ    %00100000
mSSD2CTL_SDCPU:     equ    %01000000
mSSD2CTL_RTZE:      equ    %10000000


;*** SSD2FLG - SSD2 Stepper Stall Detector Flag Register; 0x0000029B ***
SSD2FLG:            equ    $0000029B                                ;*** SSD2FLG - SSD2 Stepper Stall Detector Flag Register; 0x0000029B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD2FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD2FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD2FLG_AOVIF:     equ    %00000001
mSSD2FLG_MCZIF:     equ    %10000000


;*** MDC2CNT - SSD2 Modulus Down-Counter Count Register; 0x0000029C ***
MDC2CNT:            equ    $0000029C                                ;*** MDC2CNT - SSD2 Modulus Down-Counter Count Register; 0x0000029C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC2CNT_MDCCNT:     equ    0                                         ; Modulus Down Counter
; bit position masks
mMDC2CNT_MDCCNT:    equ    %1111111111111111


;*** ITG2ACC - SSD2 Integration Accumulator Register; 0x0000029E ***
ITG2ACC:            equ    $0000029E                                ;*** ITG2ACC - SSD2 Integration Accumulator Register; 0x0000029E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG2ACC_ITGACC:     equ    0                                         ; Integration Accumulator
; bit position masks
mITG2ACC_ITGACC:    equ    %1111111111111111


;*** RTZ3CTL - SSD3 Return-to-Zero Control Register; 0x000002A0 ***
RTZ3CTL:            equ    $000002A0                                ;*** RTZ3CTL - SSD3 Return-to-Zero Control Register; 0x000002A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ3CTL_STEP:       equ    0                                         ; Full Step State
RTZ3CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ3CTL_POL:        equ    4                                         ; Polarity
RTZ3CTL_RCIR:       equ    5                                         ; Recirculation in Blanking Mode
RTZ3CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ3CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ3CTL_STEP:      equ    %00000011
mRTZ3CTL_SMS:       equ    %00000100
mRTZ3CTL_POL:       equ    %00010000
mRTZ3CTL_RCIR:      equ    %00100000
mRTZ3CTL_DCOIL:     equ    %01000000
mRTZ3CTL_ITG:       equ    %10000000


;*** MDC3CTL - SSD3 Modulus Down Counter Control Register; 0x000002A1 ***
MDC3CTL:            equ    $000002A1                                ;*** MDC3CTL - SSD3 Modulus Down Counter Control Register; 0x000002A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC3CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC3CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC3CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC3CTL_PRE:        equ    4                                         ; Prescaler
MDC3CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC3CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC3CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC3CTL_AOVIE:     equ    %00000001
mMDC3CTL_MCEN:      equ    %00000100
mMDC3CTL_FLMC:      equ    %00001000
mMDC3CTL_PRE:       equ    %00010000
mMDC3CTL_RDMCL:     equ    %00100000
mMDC3CTL_MODMC:     equ    %01000000
mMDC3CTL_MCZIE:     equ    %10000000


;*** SSD3CTL - SSD3 Stepper Stall Detector Control Register; 0x000002A2 ***
SSD3CTL:            equ    $000002A2                                ;*** SSD3CTL - SSD3 Stepper Stall Detector Control Register; 0x000002A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD3CTL_ACLKS:      equ    0                                         ; Accumulator Sample Frequency Select
SSD3CTL_FTST:       equ    4                                         ; Factory Test
SSD3CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD3CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD3CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD3CTL_ACLKS:     equ    %00000011
mSSD3CTL_FTST:      equ    %00010000
mSSD3CTL_SSDWAI:    equ    %00100000
mSSD3CTL_SDCPU:     equ    %01000000
mSSD3CTL_RTZE:      equ    %10000000


;*** SSD3FLG - SSD3 Stepper Stall Detector Flag Register; 0x000002A3 ***
SSD3FLG:            equ    $000002A3                                ;*** SSD3FLG - SSD3 Stepper Stall Detector Flag Register; 0x000002A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD3FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD3FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD3FLG_AOVIF:     equ    %00000001
mSSD3FLG_MCZIF:     equ    %10000000


;*** MDC3CNT - SSD3 Modulus Down-Counter Count Register; 0x000002A4 ***
MDC3CNT:            equ    $000002A4                                ;*** MDC3CNT - SSD3 Modulus Down-Counter Count Register; 0x000002A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC3CNT_MDCCNT:     equ    0                                         ; Modulus Down Counter
; bit position masks
mMDC3CNT_MDCCNT:    equ    %1111111111111111


;*** ITG3ACC - SSD3 Integration Accumulator Register; 0x000002A6 ***
ITG3ACC:            equ    $000002A6                                ;*** ITG3ACC - SSD3 Integration Accumulator Register; 0x000002A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG3ACC_ITGACC:     equ    0                                         ; Integration Accumulator
; bit position masks
mITG3ACC_ITGACC:    equ    %1111111111111111


;*** RTZ5CTL - SSD5 Return-to-Zero Control Register; 0x000002A8 ***
RTZ5CTL:            equ    $000002A8                                ;*** RTZ5CTL - SSD5 Return-to-Zero Control Register; 0x000002A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTZ5CTL_STEP:       equ    0                                         ; Full Step State
RTZ5CTL_SMS:        equ    2                                         ; Stepper Motor Select
RTZ5CTL_POL:        equ    4                                         ; Polarity
RTZ5CTL_RCIR:       equ    5                                         ; Recirculation in Blanking Mode
RTZ5CTL_DCOIL:      equ    6                                         ; Drive Coil
RTZ5CTL_ITG:        equ    7                                         ; Integration
; bit position masks
mRTZ5CTL_STEP:      equ    %00000011
mRTZ5CTL_SMS:       equ    %00000100
mRTZ5CTL_POL:       equ    %00010000
mRTZ5CTL_RCIR:      equ    %00100000
mRTZ5CTL_DCOIL:     equ    %01000000
mRTZ5CTL_ITG:       equ    %10000000


;*** MDC5CTL - SSD5 Modulus Down Counter Control Register; 0x000002A9 ***
MDC5CTL:            equ    $000002A9                                ;*** MDC5CTL - SSD5 Modulus Down Counter Control Register; 0x000002A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC5CTL_AOVIE:      equ    0                                         ; Accumulator Overflow Interrupt Enable
MDC5CTL_MCEN:       equ    2                                         ; Modulus Down-Counter Enable
MDC5CTL_FLMC:       equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MDC5CTL_PRE:        equ    4                                         ; Prescaler
MDC5CTL_RDMCL:      equ    5                                         ; Read Modulus Down-Counter Load
MDC5CTL_MODMC:      equ    6                                         ; Modulus Mode Enable
MDC5CTL_MCZIE:      equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMDC5CTL_AOVIE:     equ    %00000001
mMDC5CTL_MCEN:      equ    %00000100
mMDC5CTL_FLMC:      equ    %00001000
mMDC5CTL_PRE:       equ    %00010000
mMDC5CTL_RDMCL:     equ    %00100000
mMDC5CTL_MODMC:     equ    %01000000
mMDC5CTL_MCZIE:     equ    %10000000


;*** SSD5CTL - SSD5 Stepper Stall Detector Control Register; 0x000002AA ***
SSD5CTL:            equ    $000002AA                                ;*** SSD5CTL - SSD5 Stepper Stall Detector Control Register; 0x000002AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD5CTL_ACLKS:      equ    0                                         ; Accumulator Sample Frequency Select
SSD5CTL_FTST:       equ    4                                         ; Factory Test
SSD5CTL_SSDWAI:     equ    5                                         ; SSD Disabled during Wait Mode
SSD5CTL_SDCPU:      equ    6                                         ; Sigma-Delta Converter Power Up
SSD5CTL_RTZE:       equ    7                                         ; Return to Zero Enable
; bit position masks
mSSD5CTL_ACLKS:     equ    %00000011
mSSD5CTL_FTST:      equ    %00010000
mSSD5CTL_SSDWAI:    equ    %00100000
mSSD5CTL_SDCPU:     equ    %01000000
mSSD5CTL_RTZE:      equ    %10000000


;*** SSD5FLG - SSD5 Stepper Stall Detector Flag Register; 0x000002AB ***
SSD5FLG:            equ    $000002AB                                ;*** SSD5FLG - SSD5 Stepper Stall Detector Flag Register; 0x000002AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSD5FLG_AOVIF:      equ    0                                         ; Accumulator Overflow Interrupt Flag
SSD5FLG_MCZIF:      equ    7                                         ; Modulus Counter Underflow Interrupt Flag
; bit position masks
mSSD5FLG_AOVIF:     equ    %00000001
mSSD5FLG_MCZIF:     equ    %10000000


;*** MDC5CNT - SSD5 Modulus Down-Counter Count Register; 0x000002AC ***
MDC5CNT:            equ    $000002AC                                ;*** MDC5CNT - SSD5 Modulus Down-Counter Count Register; 0x000002AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MDC5CNT_MDCCNT:     equ    0                                         ; Modulus Down Counter
; bit position masks
mMDC5CNT_MDCCNT:    equ    %1111111111111111


;*** ITG5ACC - SSD5 Integration Accumulator Register; 0x000002AE ***
ITG5ACC:            equ    $000002AE                                ;*** ITG5ACC - SSD5 Integration Accumulator Register; 0x000002AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ITG5ACC_ITGACC:     equ    0                                         ; Integration Accumulator
; bit position masks
mITG5ACC_ITGACC:    equ    %1111111111111111


;*** VREGCTRL - Control Register; 0x000002F1 ***
VREGCTRL:           equ    $000002F1                                ;*** VREGCTRL - Control Register; 0x000002F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGCTRL_LVIF:      equ    0                                         ; Low-Voltage Interrupt Flag
VREGCTRL_LVIE:      equ    1                                         ; Low-Voltage Interrupt Enable Bit
VREGCTRL_LVDS:      equ    2                                         ; Low-Voltage Detect Status Bit
; bit position masks
mVREGCTRL_LVIF:     equ    %00000001
mVREGCTRL_LVIE:     equ    %00000010
mVREGCTRL_LVDS:     equ    %00000100


;*** VREGAPICL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
VREGAPICL:          equ    $000002F2                                ;*** VREGAPICL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPICL_APIF:     equ    0                                         ; Autonomous Periodical Interrupt Flag
VREGAPICL_APIE:     equ    1                                         ; Autonomous Periodical Interrupt Enable Bit
VREGAPICL_APIFE:    equ    2                                         ; Autonomous Periodical Interrupt Feature Enable Bit
VREGAPICL_APICLK:   equ    7                                         ; Autonomous Periodical Interrupt Clock Select Bit
; bit position masks
mVREGAPICL_APIF:    equ    %00000001
mVREGAPICL_APIE:    equ    %00000010
mVREGAPICL_APIFE:   equ    %00000100
mVREGAPICL_APICLK:  equ    %10000000


;*** VREGAPITR - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***
VREGAPITR:          equ    $000002F3                                ;*** VREGAPITR - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPITR_APITR0:   equ    2                                         ; Autonomous Periodical Interrupt Period Trimming Bit 0
VREGAPITR_APITR1:   equ    3                                         ; Autonomous Periodical Interrupt Period Trimming Bit 1
VREGAPITR_APITR2:   equ    4                                         ; Autonomous Periodical Interrupt Period Trimming Bit 2
VREGAPITR_APITR3:   equ    5                                         ; Autonomous Periodical Interrupt Period Trimming Bit 3
VREGAPITR_APITR4:   equ    6                                         ; Autonomous Periodical Interrupt Period Trimming Bit 4
VREGAPITR_APITR5:   equ    7                                         ; Autonomous Periodical Interrupt Period Trimming Bit 5
; bit position masks
mVREGAPITR_APITR0:  equ    %00000100
mVREGAPITR_APITR1:  equ    %00001000
mVREGAPITR_APITR2:  equ    %00010000
mVREGAPITR_APITR3:  equ    %00100000
mVREGAPITR_APITR4:  equ    %01000000
mVREGAPITR_APITR5:  equ    %10000000


;*** VREGAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
VREGAPIR:           equ    $000002F4                                ;*** VREGAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIR_APIR0:     equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
VREGAPIR_APIR1:     equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
VREGAPIR_APIR2:     equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
VREGAPIR_APIR3:     equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
VREGAPIR_APIR4:     equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
VREGAPIR_APIR5:     equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
VREGAPIR_APIR6:     equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
VREGAPIR_APIR7:     equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
VREGAPIR_APIR8:     equ    8                                         ; Autonomous Periodical Interrupt Rate Bit 8
VREGAPIR_APIR9:     equ    9                                         ; Autonomous Periodical Interrupt Rate Bit 9
VREGAPIR_APIR10:    equ    10                                        ; Autonomous Periodical Interrupt Rate Bit 10
VREGAPIR_APIR11:    equ    11                                        ; Autonomous Periodical Interrupt Rate Bit 11
; bit position masks
mVREGAPIR_APIR0:    equ    %00000001
mVREGAPIR_APIR1:    equ    %00000010
mVREGAPIR_APIR2:    equ    %00000100
mVREGAPIR_APIR3:    equ    %00001000
mVREGAPIR_APIR4:    equ    %00010000
mVREGAPIR_APIR5:    equ    %00100000
mVREGAPIR_APIR6:    equ    %01000000
mVREGAPIR_APIR7:    equ    %10000000
mVREGAPIR_APIR8:    equ    %100000000
mVREGAPIR_APIR9:    equ    %1000000000
mVREGAPIR_APIR10:   equ    %10000000000
mVREGAPIR_APIR11:   equ    %100000000000


;*** VREGAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
VREGAPIRH:          equ    $000002F4                                ;*** VREGAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIRH_APIR8:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 8
VREGAPIRH_APIR9:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 9
VREGAPIRH_APIR10:   equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 10
VREGAPIRH_APIR11:   equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 11
; bit position masks
mVREGAPIRH_APIR8:   equ    %00000001
mVREGAPIRH_APIR9:   equ    %00000010
mVREGAPIRH_APIR10:  equ    %00000100
mVREGAPIRH_APIR11:  equ    %00001000


;*** VREGAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
VREGAPIRL:          equ    $000002F5                                ;*** VREGAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIRL_APIR0:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
VREGAPIRL_APIR1:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
VREGAPIRL_APIR2:    equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
VREGAPIRL_APIR3:    equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
VREGAPIRL_APIR4:    equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
VREGAPIRL_APIR5:    equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
VREGAPIRL_APIR6:    equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
VREGAPIRL_APIR7:    equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
; bit position masks
mVREGAPIRL_APIR0:   equ    %00000001
mVREGAPIRL_APIR1:   equ    %00000010
mVREGAPIRL_APIR2:   equ    %00000100
mVREGAPIRL_APIR3:   equ    %00001000
mVREGAPIRL_APIR4:   equ    %00010000
mVREGAPIRL_APIR5:   equ    %00100000
mVREGAPIRL_APIR6:   equ    %01000000
mVREGAPIRL_APIR7:   equ    %10000000


;*** PWME - PWM Enable Register; 0x00000300 ***
PWME:               equ    $00000300                                ;*** PWME - PWM Enable Register; 0x00000300 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWME_PWME0:         equ    0                                         ; Pulse Width Channel 0 Enable
PWME_PWME1:         equ    1                                         ; Pulse Width Channel 1 Enable
PWME_PWME2:         equ    2                                         ; Pulse Width Channel 2 Enable
PWME_PWME3:         equ    3                                         ; Pulse Width Channel 3 Enable
PWME_PWME4:         equ    4                                         ; Pulse Width Channel 4 Enable
PWME_PWME5:         equ    5                                         ; Pulse Width Channel 5 Enable
PWME_PWME6:         equ    6                                         ; Pulse Width Channel 6 Enable
PWME_PWME7:         equ    7                                         ; Pulse Width Channel 7 Enable
; bit position masks
mPWME_PWME0:        equ    %00000001
mPWME_PWME1:        equ    %00000010
mPWME_PWME2:        equ    %00000100
mPWME_PWME3:        equ    %00001000
mPWME_PWME4:        equ    %00010000
mPWME_PWME5:        equ    %00100000
mPWME_PWME6:        equ    %01000000
mPWME_PWME7:        equ    %10000000


;*** PWMPOL - PWM Polarity Register; 0x00000301 ***
PWMPOL:             equ    $00000301                                ;*** PWMPOL - PWM Polarity Register; 0x00000301 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPOL_PPOL0:       equ    0                                         ; Pulse Width Channel 0 Polarity
PWMPOL_PPOL1:       equ    1                                         ; Pulse Width Channel 1 Polarity
PWMPOL_PPOL2:       equ    2                                         ; Pulse Width Channel 2 Polarity
PWMPOL_PPOL3:       equ    3                                         ; Pulse Width Channel 3 Polarity
PWMPOL_PPOL4:       equ    4                                         ; Pulse Width Channel 4 Polarity
PWMPOL_PPOL5:       equ    5                                         ; Pulse Width Channel 5 Polarity
PWMPOL_PPOL6:       equ    6                                         ; Pulse Width Channel 6 Polarity
PWMPOL_PPOL7:       equ    7                                         ; Pulse Width Channel 7 Polarity
; bit position masks
mPWMPOL_PPOL0:      equ    %00000001
mPWMPOL_PPOL1:      equ    %00000010
mPWMPOL_PPOL2:      equ    %00000100
mPWMPOL_PPOL3:      equ    %00001000
mPWMPOL_PPOL4:      equ    %00010000
mPWMPOL_PPOL5:      equ    %00100000
mPWMPOL_PPOL6:      equ    %01000000
mPWMPOL_PPOL7:      equ    %10000000


;*** PWMCLK - PWM Clock Select Register; 0x00000302 ***
PWMCLK:             equ    $00000302                                ;*** PWMCLK - PWM Clock Select Register; 0x00000302 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCLK_PCLK0:       equ    0                                         ; Pulse Width Channel 0 Clock Select
PWMCLK_PCLK1:       equ    1                                         ; Pulse Width Channel 1 Clock Select
PWMCLK_PCLK2:       equ    2                                         ; Pulse Width Channel 2 Clock Select
PWMCLK_PCLK3:       equ    3                                         ; Pulse Width Channel 3 Clock Select
PWMCLK_PCLK4:       equ    4                                         ; Pulse Width Channel 4 Clock Select
PWMCLK_PCLK5:       equ    5                                         ; Pulse Width Channel 5 Clock Select
PWMCLK_PCLK6:       equ    6                                         ; Pulse Width Channel 6 Clock Select
PWMCLK_PCLK7:       equ    7                                         ; Pulse Width Channel 7 Clock Select
; bit position masks
mPWMCLK_PCLK0:      equ    %00000001
mPWMCLK_PCLK1:      equ    %00000010
mPWMCLK_PCLK2:      equ    %00000100
mPWMCLK_PCLK3:      equ    %00001000
mPWMCLK_PCLK4:      equ    %00010000
mPWMCLK_PCLK5:      equ    %00100000
mPWMCLK_PCLK6:      equ    %01000000
mPWMCLK_PCLK7:      equ    %10000000


;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x00000303 ***
PWMPRCLK:           equ    $00000303                                ;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x00000303 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPRCLK_PCKA0:     equ    0                                         ; Prescaler Select for Clock A 0
PWMPRCLK_PCKA1:     equ    1                                         ; Prescaler Select for Clock A 1
PWMPRCLK_PCKA2:     equ    2                                         ; Prescaler Select for Clock A 2
PWMPRCLK_PCKB0:     equ    4                                         ; Prescaler Select for Clock B 0
PWMPRCLK_PCKB1:     equ    5                                         ; Prescaler Select for Clock B 1
PWMPRCLK_PCKB2:     equ    6                                         ; Prescaler Select for Clock B 2
; bit position masks
mPWMPRCLK_PCKA0:    equ    %00000001
mPWMPRCLK_PCKA1:    equ    %00000010
mPWMPRCLK_PCKA2:    equ    %00000100
mPWMPRCLK_PCKB0:    equ    %00010000
mPWMPRCLK_PCKB1:    equ    %00100000
mPWMPRCLK_PCKB2:    equ    %01000000


;*** PWMCAE - PWM Center Align Enable Register; 0x00000304 ***
PWMCAE:             equ    $00000304                                ;*** PWMCAE - PWM Center Align Enable Register; 0x00000304 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCAE_CAE0:        equ    0                                         ; Center Aligned Output Mode on channel 0
PWMCAE_CAE1:        equ    1                                         ; Center Aligned Output Mode on channel 1
PWMCAE_CAE2:        equ    2                                         ; Center Aligned Output Mode on channel 2
PWMCAE_CAE3:        equ    3                                         ; Center Aligned Output Mode on channel 3
PWMCAE_CAE4:        equ    4                                         ; Center Aligned Output Mode on channel 4
PWMCAE_CAE5:        equ    5                                         ; Center Aligned Output Mode on channel 5
PWMCAE_CAE6:        equ    6                                         ; Center Aligned Output Mode on channel 6
PWMCAE_CAE7:        equ    7                                         ; Center Aligned Output Mode on channel 7
; bit position masks
mPWMCAE_CAE0:       equ    %00000001
mPWMCAE_CAE1:       equ    %00000010
mPWMCAE_CAE2:       equ    %00000100
mPWMCAE_CAE3:       equ    %00001000
mPWMCAE_CAE4:       equ    %00010000
mPWMCAE_CAE5:       equ    %00100000
mPWMCAE_CAE6:       equ    %01000000
mPWMCAE_CAE7:       equ    %10000000


;*** PWMCTL - PWM Control Register; 0x00000305 ***
PWMCTL:             equ    $00000305                                ;*** PWMCTL - PWM Control Register; 0x00000305 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCTL_PFRZ:        equ    2                                         ; PWM Counters Stop in Freeze Mode
PWMCTL_PSWAI:       equ    3                                         ; PWM Stops in Wait Mode
PWMCTL_CON01:       equ    4                                         ; Concatenate channels 0 and 1
PWMCTL_CON23:       equ    5                                         ; Concatenate channels 2 and 3
PWMCTL_CON45:       equ    6                                         ; Concatenate channels 4 and 5
PWMCTL_CON67:       equ    7                                         ; Concatenate channels 6 and 7
; bit position masks
mPWMCTL_PFRZ:       equ    %00000100
mPWMCTL_PSWAI:      equ    %00001000
mPWMCTL_CON01:      equ    %00010000
mPWMCTL_CON23:      equ    %00100000
mPWMCTL_CON45:      equ    %01000000
mPWMCTL_CON67:      equ    %10000000


;*** PWMSCLA - PWM Scale A Register; 0x00000308 ***
PWMSCLA:            equ    $00000308                                ;*** PWMSCLA - PWM Scale A Register; 0x00000308 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLA_BIT0:       equ    0                                         ; PWM Scale A Bit 0
PWMSCLA_BIT1:       equ    1                                         ; PWM Scale A Bit 1
PWMSCLA_BIT2:       equ    2                                         ; PWM Scale A Bit 2
PWMSCLA_BIT3:       equ    3                                         ; PWM Scale A Bit 3
PWMSCLA_BIT4:       equ    4                                         ; PWM Scale A Bit 4
PWMSCLA_BIT5:       equ    5                                         ; PWM Scale A Bit 5
PWMSCLA_BIT6:       equ    6                                         ; PWM Scale A Bit 6
PWMSCLA_BIT7:       equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mPWMSCLA_BIT0:      equ    %00000001
mPWMSCLA_BIT1:      equ    %00000010
mPWMSCLA_BIT2:      equ    %00000100
mPWMSCLA_BIT3:      equ    %00001000
mPWMSCLA_BIT4:      equ    %00010000
mPWMSCLA_BIT5:      equ    %00100000
mPWMSCLA_BIT6:      equ    %01000000
mPWMSCLA_BIT7:      equ    %10000000


;*** PWMSCLB - PWM Scale B Register; 0x00000309 ***
PWMSCLB:            equ    $00000309                                ;*** PWMSCLB - PWM Scale B Register; 0x00000309 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLB_BIT0:       equ    0                                         ; PWM Scale B Bit 0
PWMSCLB_BIT1:       equ    1                                         ; PWM Scale B Bit 1
PWMSCLB_BIT2:       equ    2                                         ; PWM Scale B Bit 2
PWMSCLB_BIT3:       equ    3                                         ; PWM Scale B Bit 3
PWMSCLB_BIT4:       equ    4                                         ; PWM Scale B Bit 4
PWMSCLB_BIT5:       equ    5                                         ; PWM Scale B Bit 5
PWMSCLB_BIT6:       equ    6                                         ; PWM Scale B Bit 6
PWMSCLB_BIT7:       equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mPWMSCLB_BIT0:      equ    %00000001
mPWMSCLB_BIT1:      equ    %00000010
mPWMSCLB_BIT2:      equ    %00000100
mPWMSCLB_BIT3:      equ    %00001000
mPWMSCLB_BIT4:      equ    %00010000
mPWMSCLB_BIT5:      equ    %00100000
mPWMSCLB_BIT6:      equ    %01000000
mPWMSCLB_BIT7:      equ    %10000000


;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x0000030C ***
PWMCNT01:           equ    $0000030C                                ;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x0000030C ***


;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x0000030C ***
PWMCNT0:            equ    $0000030C                                ;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x0000030C ***


;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x0000030D ***
PWMCNT1:            equ    $0000030D                                ;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x0000030D ***


;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x0000030E ***
PWMCNT23:           equ    $0000030E                                ;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x0000030E ***


;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x0000030E ***
PWMCNT2:            equ    $0000030E                                ;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x0000030E ***


;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x0000030F ***
PWMCNT3:            equ    $0000030F                                ;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x0000030F ***


;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x00000310 ***
PWMCNT45:           equ    $00000310                                ;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x00000310 ***


;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x00000310 ***
PWMCNT4:            equ    $00000310                                ;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x00000310 ***


;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x00000311 ***
PWMCNT5:            equ    $00000311                                ;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x00000311 ***


;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x00000312 ***
PWMCNT67:           equ    $00000312                                ;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x00000312 ***


;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x00000312 ***
PWMCNT6:            equ    $00000312                                ;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x00000312 ***


;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x00000313 ***
PWMCNT7:            equ    $00000313                                ;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x00000313 ***


;*** PWMPER01 - PWM Channel Period 01 Register; 0x00000314 ***
PWMPER01:           equ    $00000314                                ;*** PWMPER01 - PWM Channel Period 01 Register; 0x00000314 ***


;*** PWMPER0 - PWM Channel Period 0 Register; 0x00000314 ***
PWMPER0:            equ    $00000314                                ;*** PWMPER0 - PWM Channel Period 0 Register; 0x00000314 ***


;*** PWMPER1 - PWM Channel Period 1 Register; 0x00000315 ***
PWMPER1:            equ    $00000315                                ;*** PWMPER1 - PWM Channel Period 1 Register; 0x00000315 ***


;*** PWMPER23 - PWM Channel Period 23 Register; 0x00000316 ***
PWMPER23:           equ    $00000316                                ;*** PWMPER23 - PWM Channel Period 23 Register; 0x00000316 ***


;*** PWMPER2 - PWM Channel Period 2 Register; 0x00000316 ***
PWMPER2:            equ    $00000316                                ;*** PWMPER2 - PWM Channel Period 2 Register; 0x00000316 ***


;*** PWMPER3 - PWM Channel Period 3 Register; 0x00000317 ***
PWMPER3:            equ    $00000317                                ;*** PWMPER3 - PWM Channel Period 3 Register; 0x00000317 ***


;*** PWMPER45 - PWM Channel Period 45 Register; 0x00000318 ***
PWMPER45:           equ    $00000318                                ;*** PWMPER45 - PWM Channel Period 45 Register; 0x00000318 ***


;*** PWMPER4 - PWM Channel Period 4 Register; 0x00000318 ***
PWMPER4:            equ    $00000318                                ;*** PWMPER4 - PWM Channel Period 4 Register; 0x00000318 ***


;*** PWMPER5 - PWM Channel Period 5 Register; 0x00000319 ***
PWMPER5:            equ    $00000319                                ;*** PWMPER5 - PWM Channel Period 5 Register; 0x00000319 ***


;*** PWMPER67 - PWM Channel Period 67 Register; 0x0000031A ***
PWMPER67:           equ    $0000031A                                ;*** PWMPER67 - PWM Channel Period 67 Register; 0x0000031A ***


;*** PWMPER6 - PWM Channel Period 6 Register; 0x0000031A ***
PWMPER6:            equ    $0000031A                                ;*** PWMPER6 - PWM Channel Period 6 Register; 0x0000031A ***


;*** PWMPER7 - PWM Channel Period 7 Register; 0x0000031B ***
PWMPER7:            equ    $0000031B                                ;*** PWMPER7 - PWM Channel Period 7 Register; 0x0000031B ***


;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x0000031C ***
PWMDTY01:           equ    $0000031C                                ;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x0000031C ***


;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x0000031C ***
PWMDTY0:            equ    $0000031C                                ;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x0000031C ***


;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x0000031D ***
PWMDTY1:            equ    $0000031D                                ;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x0000031D ***


;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x0000031E ***
PWMDTY23:           equ    $0000031E                                ;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x0000031E ***


;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x0000031E ***
PWMDTY2:            equ    $0000031E                                ;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x0000031E ***


;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x0000031F ***
PWMDTY3:            equ    $0000031F                                ;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x0000031F ***


;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x00000320 ***
PWMDTY45:           equ    $00000320                                ;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x00000320 ***


;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x00000320 ***
PWMDTY4:            equ    $00000320                                ;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x00000320 ***


;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x00000321 ***
PWMDTY5:            equ    $00000321                                ;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x00000321 ***


;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x00000322 ***
PWMDTY67:           equ    $00000322                                ;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x00000322 ***


;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x00000322 ***
PWMDTY6:            equ    $00000322                                ;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x00000322 ***


;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x00000323 ***
PWMDTY7:            equ    $00000323                                ;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x00000323 ***


;*** PWMSDN - PWM Shutdown Register; 0x00000324 ***
PWMSDN:             equ    $00000324                                ;*** PWMSDN - PWM Shutdown Register; 0x00000324 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSDN_PWM7ENA:     equ    0                                         ; PWM emergency shutdown Enable
PWMSDN_PWM7INL:     equ    1                                         ; PWM shutdown active input level for ch. 7
PWMSDN_PWM7IN:      equ    2                                         ; PWM channel 7 input status
PWMSDN_PWMLVL:      equ    4                                         ; PWM shutdown output Level
PWMSDN_PWMRSTRT:    equ    5                                         ; PWM Restart
PWMSDN_PWMIE:       equ    6                                         ; PWM Interrupt Enable
PWMSDN_PWMIF:       equ    7                                         ; PWM Interrupt Flag
; bit position masks
mPWMSDN_PWM7ENA:    equ    %00000001
mPWMSDN_PWM7INL:    equ    %00000010
mPWMSDN_PWM7IN:     equ    %00000100
mPWMSDN_PWMLVL:     equ    %00010000
mPWMSDN_PWMRSTRT:   equ    %00100000
mPWMSDN_PWMIE:      equ    %01000000
mPWMSDN_PWMIF:      equ    %10000000


;*** PITCFLMT - PIT Control and Force Load Micro Timer Register; 0x00000340 ***
PITCFLMT:           equ    $00000340                                ;*** PITCFLMT - PIT Control and Force Load Micro Timer Register; 0x00000340 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITCFLMT_PFLMT0:    equ    0                                         ; PIT Force Load Bits for Micro Timer 0
PITCFLMT_PFLMT1:    equ    1                                         ; PIT Force Load Bits for Micro Timer 1
PITCFLMT_PITFRZ:    equ    5                                         ; PIT Counter Freeze while in Freeze Mode Bit
PITCFLMT_PITSWAI:   equ    6                                         ; PIT Stop in Wait Mode Bit
PITCFLMT_PITE:      equ    7                                         ; PIT Module Enable Bit
; bit position masks
mPITCFLMT_PFLMT0:   equ    %00000001
mPITCFLMT_PFLMT1:   equ    %00000010
mPITCFLMT_PITFRZ:   equ    %00100000
mPITCFLMT_PITSWAI:  equ    %01000000
mPITCFLMT_PITE:     equ    %10000000


;*** PITFLT - PIT Force Load Timer Register; 0x00000341 ***
PITFLT:             equ    $00000341                                ;*** PITFLT - PIT Force Load Timer Register; 0x00000341 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITFLT_PFLT0:       equ    0                                         ; PIT Force Load Bits for Timer 0
PITFLT_PFLT1:       equ    1                                         ; PIT Force Load Bits for Timer 1
PITFLT_PFLT2:       equ    2                                         ; PIT Force Load Bits for Timer 2
PITFLT_PFLT3:       equ    3                                         ; PIT Force Load Bits for Timer 3
; bit position masks
mPITFLT_PFLT0:      equ    %00000001
mPITFLT_PFLT1:      equ    %00000010
mPITFLT_PFLT2:      equ    %00000100
mPITFLT_PFLT3:      equ    %00001000


;*** PITCE - PIT Channel Enable Register; 0x00000342 ***
PITCE:              equ    $00000342                                ;*** PITCE - PIT Channel Enable Register; 0x00000342 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITCE_PCE0:         equ    0                                         ; PIT Enable Bits for Timer Channel 0
PITCE_PCE1:         equ    1                                         ; PIT Enable Bits for Timer Channel 1
PITCE_PCE2:         equ    2                                         ; PIT Enable Bits for Timer Channel 2
PITCE_PCE3:         equ    3                                         ; PIT Enable Bits for Timer Channel 3
; bit position masks
mPITCE_PCE0:        equ    %00000001
mPITCE_PCE1:        equ    %00000010
mPITCE_PCE2:        equ    %00000100
mPITCE_PCE3:        equ    %00001000


;*** PITMUX - PIT Multiplex Register; 0x00000343 ***
PITMUX:             equ    $00000343                                ;*** PITMUX - PIT Multiplex Register; 0x00000343 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMUX_PMUX0:       equ    0                                         ; PIT Multiplex Bits for Timer Channel 0
PITMUX_PMUX1:       equ    1                                         ; PIT Multiplex Bits for Timer Channel 1
PITMUX_PMUX2:       equ    2                                         ; PIT Multiplex Bits for Timer Channel 2
PITMUX_PMUX3:       equ    3                                         ; PIT Multiplex Bits for Timer Channel 3
; bit position masks
mPITMUX_PMUX0:      equ    %00000001
mPITMUX_PMUX1:      equ    %00000010
mPITMUX_PMUX2:      equ    %00000100
mPITMUX_PMUX3:      equ    %00001000


;*** PITINTE - PIT Interrupt Enable Register; 0x00000344 ***
PITINTE:            equ    $00000344                                ;*** PITINTE - PIT Interrupt Enable Register; 0x00000344 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITINTE_PINTE0:     equ    0                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 0
PITINTE_PINTE1:     equ    1                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 1
PITINTE_PINTE2:     equ    2                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 2
PITINTE_PINTE3:     equ    3                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 3
; bit position masks
mPITINTE_PINTE0:    equ    %00000001
mPITINTE_PINTE1:    equ    %00000010
mPITINTE_PINTE2:    equ    %00000100
mPITINTE_PINTE3:    equ    %00001000


;*** PITTF - PIT Time-out Flag Register; 0x00000345 ***
PITTF:              equ    $00000345                                ;*** PITTF - PIT Time-out Flag Register; 0x00000345 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITTF_PTF0:         equ    0                                         ; PIT Time-out Flag Bits for Timer Channel 0
PITTF_PTF1:         equ    1                                         ; PIT Time-out Flag Bits for Timer Channel 1
PITTF_PTF2:         equ    2                                         ; PIT Time-out Flag Bits for Timer Channel 2
PITTF_PTF3:         equ    3                                         ; PIT Time-out Flag Bits for Timer Channel 3
; bit position masks
mPITTF_PTF0:        equ    %00000001
mPITTF_PTF1:        equ    %00000010
mPITTF_PTF2:        equ    %00000100
mPITTF_PTF3:        equ    %00001000


;*** PITMTLD0 - PIT Micro Timer Load Register 0; 0x00000346 ***
PITMTLD0:           equ    $00000346                                ;*** PITMTLD0 - PIT Micro Timer Load Register 0; 0x00000346 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMTLD0_PMTLD0:    equ    0                                         ; PIT Micro Timer Load Bit 0
PITMTLD0_PMTLD1:    equ    1                                         ; PIT Micro Timer Load Bit 1
PITMTLD0_PMTLD2:    equ    2                                         ; PIT Micro Timer Load Bit 2
PITMTLD0_PMTLD3:    equ    3                                         ; PIT Micro Timer Load Bit 3
PITMTLD0_PMTLD4:    equ    4                                         ; PIT Micro Timer Load Bit 4
PITMTLD0_PMTLD5:    equ    5                                         ; PIT Micro Timer Load Bit 5
PITMTLD0_PMTLD6:    equ    6                                         ; PIT Micro Timer Load Bit 6
PITMTLD0_PMTLD7:    equ    7                                         ; PIT Micro Timer Load Bit 7
; bit position masks
mPITMTLD0_PMTLD0:   equ    %00000001
mPITMTLD0_PMTLD1:   equ    %00000010
mPITMTLD0_PMTLD2:   equ    %00000100
mPITMTLD0_PMTLD3:   equ    %00001000
mPITMTLD0_PMTLD4:   equ    %00010000
mPITMTLD0_PMTLD5:   equ    %00100000
mPITMTLD0_PMTLD6:   equ    %01000000
mPITMTLD0_PMTLD7:   equ    %10000000


;*** PITMTLD1 - PIT Micro Timer Load Register 1; 0x00000347 ***
PITMTLD1:           equ    $00000347                                ;*** PITMTLD1 - PIT Micro Timer Load Register 1; 0x00000347 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMTLD1_PMTLD0:    equ    0                                         ; PIT Micro Timer Load Bit 0
PITMTLD1_PMTLD1:    equ    1                                         ; PIT Micro Timer Load Bit 1
PITMTLD1_PMTLD2:    equ    2                                         ; PIT Micro Timer Load Bit 2
PITMTLD1_PMTLD3:    equ    3                                         ; PIT Micro Timer Load Bit 3
PITMTLD1_PMTLD4:    equ    4                                         ; PIT Micro Timer Load Bit 4
PITMTLD1_PMTLD5:    equ    5                                         ; PIT Micro Timer Load Bit 5
PITMTLD1_PMTLD6:    equ    6                                         ; PIT Micro Timer Load Bit 6
PITMTLD1_PMTLD7:    equ    7                                         ; PIT Micro Timer Load Bit 7
; bit position masks
mPITMTLD1_PMTLD0:   equ    %00000001
mPITMTLD1_PMTLD1:   equ    %00000010
mPITMTLD1_PMTLD2:   equ    %00000100
mPITMTLD1_PMTLD3:   equ    %00001000
mPITMTLD1_PMTLD4:   equ    %00010000
mPITMTLD1_PMTLD5:   equ    %00100000
mPITMTLD1_PMTLD6:   equ    %01000000
mPITMTLD1_PMTLD7:   equ    %10000000


;*** PITLD0 - PIT Load Register 0; 0x00000348 ***
PITLD0:             equ    $00000348                                ;*** PITLD0 - PIT Load Register 0; 0x00000348 ***


;*** PITCNT0 - PIT Count Register 0; 0x0000034A ***
PITCNT0:            equ    $0000034A                                ;*** PITCNT0 - PIT Count Register 0; 0x0000034A ***


;*** PITLD1 - PIT Load Register 1; 0x0000034C ***
PITLD1:             equ    $0000034C                                ;*** PITLD1 - PIT Load Register 1; 0x0000034C ***


;*** PITCNT1 - PIT Count Register 1; 0x0000034E ***
PITCNT1:            equ    $0000034E                                ;*** PITCNT1 - PIT Count Register 1; 0x0000034E ***


;*** PITLD2 - PIT Load Register 2; 0x00000350 ***
PITLD2:             equ    $00000350                                ;*** PITLD2 - PIT Load Register 2; 0x00000350 ***


;*** PITCNT2 - PIT Count Register 2; 0x00000352 ***
PITCNT2:            equ    $00000352                                ;*** PITCNT2 - PIT Count Register 2; 0x00000352 ***


;*** PITLD3 - PIT Load Register 3; 0x00000354 ***
PITLD3:             equ    $00000354                                ;*** PITLD3 - PIT Load Register 3; 0x00000354 ***


;*** PITCNT3 - PIT Count Register 3; 0x00000356 ***
PITCNT3:            equ    $00000356                                ;*** PITCNT3 - PIT Count Register 3; 0x00000356 ***


;*** XGMCTL - XGATE Control Register; 0x00000380 ***
XGMCTL:             equ    $00000380                                ;*** XGMCTL - XGATE Control Register; 0x00000380 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGMCTL_XGIE:        equ    0                                         ; XGATE Interrupt Enable
XGMCTL_XGSWEIF:     equ    1                                         ; XGATE Software Error Interrupt Flag
XGMCTL_XGFACT:      equ    3                                         ; Fake XGATE Activity
XGMCTL_XGSS:        equ    4                                         ; XGATE Single Step
XGMCTL_XGDBG:       equ    5                                         ; XGATE Debug Mode
XGMCTL_XGFRZ:       equ    6                                         ; Halt XGATE in Freeze Mode
XGMCTL_XGE:         equ    7                                         ; XGATE Module Enable
XGMCTL_XGIEM:       equ    8                                         ; XGIE Mask
XGMCTL_XGSWEIFM:    equ    9                                         ; XGSWEIF Mask
XGMCTL_XGFACTM:     equ    11                                        ; XGFACT Mask
XGMCTL_XGSSM:       equ    12                                        ; XGSS Mask
XGMCTL_XGDBGM:      equ    13                                        ; XGDBG Mask
XGMCTL_XGFRZM:      equ    14                                        ; XGFRZ Mask
XGMCTL_XGEM:        equ    15                                        ; XGE Mask
; bit position masks
mXGMCTL_XGIE:       equ    %00000001
mXGMCTL_XGSWEIF:    equ    %00000010
mXGMCTL_XGFACT:     equ    %00001000
mXGMCTL_XGSS:       equ    %00010000
mXGMCTL_XGDBG:      equ    %00100000
mXGMCTL_XGFRZ:      equ    %01000000
mXGMCTL_XGE:        equ    %10000000
mXGMCTL_XGIEM:      equ    %100000000
mXGMCTL_XGSWEIFM:   equ    %1000000000
mXGMCTL_XGFACTM:    equ    %100000000000
mXGMCTL_XGSSM:      equ    %1000000000000
mXGMCTL_XGDBGM:     equ    %10000000000000
mXGMCTL_XGFRZM:     equ    %100000000000000
mXGMCTL_XGEM:       equ    %1000000000000000


;*** XGCHID - XGATE Channel ID Register; 0x00000382 ***
XGCHID:             equ    $00000382                                ;*** XGCHID - XGATE Channel ID Register; 0x00000382 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGCHID_XGCHID:      equ    0                                         ; Request Identifier
; bit position masks
mXGCHID_XGCHID:     equ    %01111111


;*** XGVBR - XGATE Control Register; 0x00000386 ***
XGVBR:              equ    $00000386                                ;*** XGVBR - XGATE Control Register; 0x00000386 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGVBR_XGVBR:        equ    1                                         ; Vector Base Address
; bit position masks
mXGVBR_XGVBR:       equ    %1111111111111110


;*** XGIF_7F_70 - XGATE Channel Interrupt Flag Vector; 0x00000388 ***
XGIF_7F_70:         equ    $00000388                                ;*** XGIF_7F_70 - XGATE Channel Interrupt Flag Vector; 0x00000388 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_7F_70_XGIF_70: equ    0                                         ; Channel Interrupt Flags, bit 112
XGIF_7F_70_XGIF_71: equ    1                                         ; Channel Interrupt Flags, bit 113
XGIF_7F_70_XGIF_72: equ    2                                         ; Channel Interrupt Flags, bit 114
XGIF_7F_70_XGIF_73: equ    3                                         ; Channel Interrupt Flags, bit 115
XGIF_7F_70_XGIF_74: equ    4                                         ; Channel Interrupt Flags, bit 116
XGIF_7F_70_XGIF_75: equ    5                                         ; Channel Interrupt Flags, bit 117
XGIF_7F_70_XGIF_76: equ    6                                         ; Channel Interrupt Flags, bit 118
XGIF_7F_70_XGIF_77: equ    7                                         ; Channel Interrupt Flags, bit 119
XGIF_7F_70_XGIF_78: equ    8                                         ; Channel Interrupt Flags, bit 120
; bit position masks
mXGIF_7F_70_XGIF_70: equ    %00000001
mXGIF_7F_70_XGIF_71: equ    %00000010
mXGIF_7F_70_XGIF_72: equ    %00000100
mXGIF_7F_70_XGIF_73: equ    %00001000
mXGIF_7F_70_XGIF_74: equ    %00010000
mXGIF_7F_70_XGIF_75: equ    %00100000
mXGIF_7F_70_XGIF_76: equ    %01000000
mXGIF_7F_70_XGIF_77: equ    %10000000
mXGIF_7F_70_XGIF_78: equ    %100000000


;*** XGIF_6F_60 - XGATE Channel Interrupt Flag Vector; 0x0000038A ***
XGIF_6F_60:         equ    $0000038A                                ;*** XGIF_6F_60 - XGATE Channel Interrupt Flag Vector; 0x0000038A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_6F_60_XGIF_60: equ    0                                         ; Channel Interrupt Flags, bit 96
XGIF_6F_60_XGIF_61: equ    1                                         ; Channel Interrupt Flags, bit 97
XGIF_6F_60_XGIF_62: equ    2                                         ; Channel Interrupt Flags, bit 98
XGIF_6F_60_XGIF_63: equ    3                                         ; Channel Interrupt Flags, bit 99
XGIF_6F_60_XGIF_64: equ    4                                         ; Channel Interrupt Flags, bit 100
XGIF_6F_60_XGIF_65: equ    5                                         ; Channel Interrupt Flags, bit 101
XGIF_6F_60_XGIF_66: equ    6                                         ; Channel Interrupt Flags, bit 102
XGIF_6F_60_XGIF_67: equ    7                                         ; Channel Interrupt Flags, bit 103
XGIF_6F_60_XGIF_68: equ    8                                         ; Channel Interrupt Flags, bit 104
XGIF_6F_60_XGIF_69: equ    9                                         ; Channel Interrupt Flags, bit 105
XGIF_6F_60_XGIF_6A: equ    10                                        ; Channel Interrupt Flags, bit 106
XGIF_6F_60_XGIF_6B: equ    11                                        ; Channel Interrupt Flags, bit 107
XGIF_6F_60_XGIF_6C: equ    12                                        ; Channel Interrupt Flags, bit 108
XGIF_6F_60_XGIF_6D: equ    13                                        ; Channel Interrupt Flags, bit 109
XGIF_6F_60_XGIF_6E: equ    14                                        ; Channel Interrupt Flags, bit 110
XGIF_6F_60_XGIF_6F: equ    15                                        ; Channel Interrupt Flags, bit 111
; bit position masks
mXGIF_6F_60_XGIF_60: equ    %00000001
mXGIF_6F_60_XGIF_61: equ    %00000010
mXGIF_6F_60_XGIF_62: equ    %00000100
mXGIF_6F_60_XGIF_63: equ    %00001000
mXGIF_6F_60_XGIF_64: equ    %00010000
mXGIF_6F_60_XGIF_65: equ    %00100000
mXGIF_6F_60_XGIF_66: equ    %01000000
mXGIF_6F_60_XGIF_67: equ    %10000000
mXGIF_6F_60_XGIF_68: equ    %100000000
mXGIF_6F_60_XGIF_69: equ    %1000000000
mXGIF_6F_60_XGIF_6A: equ    %10000000000
mXGIF_6F_60_XGIF_6B: equ    %100000000000
mXGIF_6F_60_XGIF_6C: equ    %1000000000000
mXGIF_6F_60_XGIF_6D: equ    %10000000000000
mXGIF_6F_60_XGIF_6E: equ    %100000000000000
mXGIF_6F_60_XGIF_6F: equ    %1000000000000000


;*** XGIF_5F_50 - XGATE Channel Interrupt Flag Vector; 0x0000038C ***
XGIF_5F_50:         equ    $0000038C                                ;*** XGIF_5F_50 - XGATE Channel Interrupt Flag Vector; 0x0000038C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_5F_50_XGIF_50: equ    0                                         ; Channel Interrupt Flags, bit 80
XGIF_5F_50_XGIF_51: equ    1                                         ; Channel Interrupt Flags, bit 81
XGIF_5F_50_XGIF_52: equ    2                                         ; Channel Interrupt Flags, bit 82
XGIF_5F_50_XGIF_53: equ    3                                         ; Channel Interrupt Flags, bit 83
XGIF_5F_50_XGIF_54: equ    4                                         ; Channel Interrupt Flags, bit 84
XGIF_5F_50_XGIF_55: equ    5                                         ; Channel Interrupt Flags, bit 85
XGIF_5F_50_XGIF_56: equ    6                                         ; Channel Interrupt Flags, bit 86
XGIF_5F_50_XGIF_57: equ    7                                         ; Channel Interrupt Flags, bit 87
XGIF_5F_50_XGIF_58: equ    8                                         ; Channel Interrupt Flags, bit 88
XGIF_5F_50_XGIF_59: equ    9                                         ; Channel Interrupt Flags, bit 89
XGIF_5F_50_XGIF_5A: equ    10                                        ; Channel Interrupt Flags, bit 90
XGIF_5F_50_XGIF_5B: equ    11                                        ; Channel Interrupt Flags, bit 91
XGIF_5F_50_XGIF_5C: equ    12                                        ; Channel Interrupt Flags, bit 92
XGIF_5F_50_XGIF_5D: equ    13                                        ; Channel Interrupt Flags, bit 93
XGIF_5F_50_XGIF_5E: equ    14                                        ; Channel Interrupt Flags, bit 94
XGIF_5F_50_XGIF_5F: equ    15                                        ; Channel Interrupt Flags, bit 95
; bit position masks
mXGIF_5F_50_XGIF_50: equ    %00000001
mXGIF_5F_50_XGIF_51: equ    %00000010
mXGIF_5F_50_XGIF_52: equ    %00000100
mXGIF_5F_50_XGIF_53: equ    %00001000
mXGIF_5F_50_XGIF_54: equ    %00010000
mXGIF_5F_50_XGIF_55: equ    %00100000
mXGIF_5F_50_XGIF_56: equ    %01000000
mXGIF_5F_50_XGIF_57: equ    %10000000
mXGIF_5F_50_XGIF_58: equ    %100000000
mXGIF_5F_50_XGIF_59: equ    %1000000000
mXGIF_5F_50_XGIF_5A: equ    %10000000000
mXGIF_5F_50_XGIF_5B: equ    %100000000000
mXGIF_5F_50_XGIF_5C: equ    %1000000000000
mXGIF_5F_50_XGIF_5D: equ    %10000000000000
mXGIF_5F_50_XGIF_5E: equ    %100000000000000
mXGIF_5F_50_XGIF_5F: equ    %1000000000000000


;*** XGIF_4F_40 - XGATE Channel Interrupt Flag Vector; 0x0000038E ***
XGIF_4F_40:         equ    $0000038E                                ;*** XGIF_4F_40 - XGATE Channel Interrupt Flag Vector; 0x0000038E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_4F_40_XGIF_40: equ    0                                         ; Channel Interrupt Flags, bit 64
XGIF_4F_40_XGIF_41: equ    1                                         ; Channel Interrupt Flags, bit 65
XGIF_4F_40_XGIF_42: equ    2                                         ; Channel Interrupt Flags, bit 66
XGIF_4F_40_XGIF_43: equ    3                                         ; Channel Interrupt Flags, bit 67
XGIF_4F_40_XGIF_44: equ    4                                         ; Channel Interrupt Flags, bit 68
XGIF_4F_40_XGIF_45: equ    5                                         ; Channel Interrupt Flags, bit 69
XGIF_4F_40_XGIF_46: equ    6                                         ; Channel Interrupt Flags, bit 70
XGIF_4F_40_XGIF_47: equ    7                                         ; Channel Interrupt Flags, bit 71
XGIF_4F_40_XGIF_48: equ    8                                         ; Channel Interrupt Flags, bit 72
XGIF_4F_40_XGIF_49: equ    9                                         ; Channel Interrupt Flags, bit 73
XGIF_4F_40_XGIF_4A: equ    10                                        ; Channel Interrupt Flags, bit 74
XGIF_4F_40_XGIF_4B: equ    11                                        ; Channel Interrupt Flags, bit 75
XGIF_4F_40_XGIF_4C: equ    12                                        ; Channel Interrupt Flags, bit 76
XGIF_4F_40_XGIF_4D: equ    13                                        ; Channel Interrupt Flags, bit 77
XGIF_4F_40_XGIF_4E: equ    14                                        ; Channel Interrupt Flags, bit 78
XGIF_4F_40_XGIF_4F: equ    15                                        ; Channel Interrupt Flags, bit 79
; bit position masks
mXGIF_4F_40_XGIF_40: equ    %00000001
mXGIF_4F_40_XGIF_41: equ    %00000010
mXGIF_4F_40_XGIF_42: equ    %00000100
mXGIF_4F_40_XGIF_43: equ    %00001000
mXGIF_4F_40_XGIF_44: equ    %00010000
mXGIF_4F_40_XGIF_45: equ    %00100000
mXGIF_4F_40_XGIF_46: equ    %01000000
mXGIF_4F_40_XGIF_47: equ    %10000000
mXGIF_4F_40_XGIF_48: equ    %100000000
mXGIF_4F_40_XGIF_49: equ    %1000000000
mXGIF_4F_40_XGIF_4A: equ    %10000000000
mXGIF_4F_40_XGIF_4B: equ    %100000000000
mXGIF_4F_40_XGIF_4C: equ    %1000000000000
mXGIF_4F_40_XGIF_4D: equ    %10000000000000
mXGIF_4F_40_XGIF_4E: equ    %100000000000000
mXGIF_4F_40_XGIF_4F: equ    %1000000000000000


;*** XGIF_3F_30 - XGATE Channel Interrupt Flag Vector; 0x00000390 ***
XGIF_3F_30:         equ    $00000390                                ;*** XGIF_3F_30 - XGATE Channel Interrupt Flag Vector; 0x00000390 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_3F_30_XGIF_30: equ    0                                         ; Channel Interrupt Flags, bit 48
XGIF_3F_30_XGIF_31: equ    1                                         ; Channel Interrupt Flags, bit 49
XGIF_3F_30_XGIF_32: equ    2                                         ; Channel Interrupt Flags, bit 50
XGIF_3F_30_XGIF_33: equ    3                                         ; Channel Interrupt Flags, bit 51
XGIF_3F_30_XGIF_34: equ    4                                         ; Channel Interrupt Flags, bit 52
XGIF_3F_30_XGIF_35: equ    5                                         ; Channel Interrupt Flags, bit 53
XGIF_3F_30_XGIF_36: equ    6                                         ; Channel Interrupt Flags, bit 54
XGIF_3F_30_XGIF_37: equ    7                                         ; Channel Interrupt Flags, bit 55
XGIF_3F_30_XGIF_38: equ    8                                         ; Channel Interrupt Flags, bit 56
XGIF_3F_30_XGIF_39: equ    9                                         ; Channel Interrupt Flags, bit 57
XGIF_3F_30_XGIF_3A: equ    10                                        ; Channel Interrupt Flags, bit 58
XGIF_3F_30_XGIF_3B: equ    11                                        ; Channel Interrupt Flags, bit 59
XGIF_3F_30_XGIF_3C: equ    12                                        ; Channel Interrupt Flags, bit 60
XGIF_3F_30_XGIF_3D: equ    13                                        ; Channel Interrupt Flags, bit 61
XGIF_3F_30_XGIF_3E: equ    14                                        ; Channel Interrupt Flags, bit 62
XGIF_3F_30_XGIF_3F: equ    15                                        ; Channel Interrupt Flags, bit 63
; bit position masks
mXGIF_3F_30_XGIF_30: equ    %00000001
mXGIF_3F_30_XGIF_31: equ    %00000010
mXGIF_3F_30_XGIF_32: equ    %00000100
mXGIF_3F_30_XGIF_33: equ    %00001000
mXGIF_3F_30_XGIF_34: equ    %00010000
mXGIF_3F_30_XGIF_35: equ    %00100000
mXGIF_3F_30_XGIF_36: equ    %01000000
mXGIF_3F_30_XGIF_37: equ    %10000000
mXGIF_3F_30_XGIF_38: equ    %100000000
mXGIF_3F_30_XGIF_39: equ    %1000000000
mXGIF_3F_30_XGIF_3A: equ    %10000000000
mXGIF_3F_30_XGIF_3B: equ    %100000000000
mXGIF_3F_30_XGIF_3C: equ    %1000000000000
mXGIF_3F_30_XGIF_3D: equ    %10000000000000
mXGIF_3F_30_XGIF_3E: equ    %100000000000000
mXGIF_3F_30_XGIF_3F: equ    %1000000000000000


;*** XGIF_2F_20 - XGATE Channel Interrupt Flag Vector; 0x00000392 ***
XGIF_2F_20:         equ    $00000392                                ;*** XGIF_2F_20 - XGATE Channel Interrupt Flag Vector; 0x00000392 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_2F_20_XGIF_20: equ    0                                         ; Channel Interrupt Flags, bit 32
XGIF_2F_20_XGIF_21: equ    1                                         ; Channel Interrupt Flags, bit 33
XGIF_2F_20_XGIF_22: equ    2                                         ; Channel Interrupt Flags, bit 34
XGIF_2F_20_XGIF_23: equ    3                                         ; Channel Interrupt Flags, bit 35
XGIF_2F_20_XGIF_24: equ    4                                         ; Channel Interrupt Flags, bit 36
XGIF_2F_20_XGIF_25: equ    5                                         ; Channel Interrupt Flags, bit 37
XGIF_2F_20_XGIF_26: equ    6                                         ; Channel Interrupt Flags, bit 38
XGIF_2F_20_XGIF_27: equ    7                                         ; Channel Interrupt Flags, bit 39
XGIF_2F_20_XGIF_28: equ    8                                         ; Channel Interrupt Flags, bit 40
XGIF_2F_20_XGIF_29: equ    9                                         ; Channel Interrupt Flags, bit 41
XGIF_2F_20_XGIF_2A: equ    10                                        ; Channel Interrupt Flags, bit 42
XGIF_2F_20_XGIF_2B: equ    11                                        ; Channel Interrupt Flags, bit 43
XGIF_2F_20_XGIF_2C: equ    12                                        ; Channel Interrupt Flags, bit 44
XGIF_2F_20_XGIF_2D: equ    13                                        ; Channel Interrupt Flags, bit 45
XGIF_2F_20_XGIF_2E: equ    14                                        ; Channel Interrupt Flags, bit 46
XGIF_2F_20_XGIF_2F: equ    15                                        ; Channel Interrupt Flags, bit 47
; bit position masks
mXGIF_2F_20_XGIF_20: equ    %00000001
mXGIF_2F_20_XGIF_21: equ    %00000010
mXGIF_2F_20_XGIF_22: equ    %00000100
mXGIF_2F_20_XGIF_23: equ    %00001000
mXGIF_2F_20_XGIF_24: equ    %00010000
mXGIF_2F_20_XGIF_25: equ    %00100000
mXGIF_2F_20_XGIF_26: equ    %01000000
mXGIF_2F_20_XGIF_27: equ    %10000000
mXGIF_2F_20_XGIF_28: equ    %100000000
mXGIF_2F_20_XGIF_29: equ    %1000000000
mXGIF_2F_20_XGIF_2A: equ    %10000000000
mXGIF_2F_20_XGIF_2B: equ    %100000000000
mXGIF_2F_20_XGIF_2C: equ    %1000000000000
mXGIF_2F_20_XGIF_2D: equ    %10000000000000
mXGIF_2F_20_XGIF_2E: equ    %100000000000000
mXGIF_2F_20_XGIF_2F: equ    %1000000000000000


;*** XGIF_1F_10 - XGATE Channel Interrupt Flag Vector; 0x00000394 ***
XGIF_1F_10:         equ    $00000394                                ;*** XGIF_1F_10 - XGATE Channel Interrupt Flag Vector; 0x00000394 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_1F_10_XGIF_10: equ    0                                         ; Channel Interrupt Flags, bit 16
XGIF_1F_10_XGIF_11: equ    1                                         ; Channel Interrupt Flags, bit 17
XGIF_1F_10_XGIF_12: equ    2                                         ; Channel Interrupt Flags, bit 18
XGIF_1F_10_XGIF_13: equ    3                                         ; Channel Interrupt Flags, bit 19
XGIF_1F_10_XGIF_14: equ    4                                         ; Channel Interrupt Flags, bit 20
XGIF_1F_10_XGIF_15: equ    5                                         ; Channel Interrupt Flags, bit 21
XGIF_1F_10_XGIF_16: equ    6                                         ; Channel Interrupt Flags, bit 22
XGIF_1F_10_XGIF_17: equ    7                                         ; Channel Interrupt Flags, bit 23
XGIF_1F_10_XGIF_18: equ    8                                         ; Channel Interrupt Flags, bit 24
XGIF_1F_10_XGIF_19: equ    9                                         ; Channel Interrupt Flags, bit 25
XGIF_1F_10_XGIF_1A: equ    10                                        ; Channel Interrupt Flags, bit 26
XGIF_1F_10_XGIF_1B: equ    11                                        ; Channel Interrupt Flags, bit 27
XGIF_1F_10_XGIF_1C: equ    12                                        ; Channel Interrupt Flags, bit 28
XGIF_1F_10_XGIF_1D: equ    13                                        ; Channel Interrupt Flags, bit 29
XGIF_1F_10_XGIF_1E: equ    14                                        ; Channel Interrupt Flags, bit 30
XGIF_1F_10_XGIF_1F: equ    15                                        ; Channel Interrupt Flags, bit 31
; bit position masks
mXGIF_1F_10_XGIF_10: equ    %00000001
mXGIF_1F_10_XGIF_11: equ    %00000010
mXGIF_1F_10_XGIF_12: equ    %00000100
mXGIF_1F_10_XGIF_13: equ    %00001000
mXGIF_1F_10_XGIF_14: equ    %00010000
mXGIF_1F_10_XGIF_15: equ    %00100000
mXGIF_1F_10_XGIF_16: equ    %01000000
mXGIF_1F_10_XGIF_17: equ    %10000000
mXGIF_1F_10_XGIF_18: equ    %100000000
mXGIF_1F_10_XGIF_19: equ    %1000000000
mXGIF_1F_10_XGIF_1A: equ    %10000000000
mXGIF_1F_10_XGIF_1B: equ    %100000000000
mXGIF_1F_10_XGIF_1C: equ    %1000000000000
mXGIF_1F_10_XGIF_1D: equ    %10000000000000
mXGIF_1F_10_XGIF_1E: equ    %100000000000000
mXGIF_1F_10_XGIF_1F: equ    %1000000000000000


;*** XGIF_0F_00 - XGATE Channel Interrupt Flag Vector; 0x00000396 ***
XGIF_0F_00:         equ    $00000396                                ;*** XGIF_0F_00 - XGATE Channel Interrupt Flag Vector; 0x00000396 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_0F_00_XGIF_09: equ    9                                         ; Channel Interrupt Flags, bit 9
XGIF_0F_00_XGIF_0A: equ    10                                        ; Channel Interrupt Flags, bit 10
XGIF_0F_00_XGIF_0B: equ    11                                        ; Channel Interrupt Flags, bit 11
XGIF_0F_00_XGIF_0C: equ    12                                        ; Channel Interrupt Flags, bit 12
XGIF_0F_00_XGIF_0D: equ    13                                        ; Channel Interrupt Flags, bit 13
XGIF_0F_00_XGIF_0E: equ    14                                        ; Channel Interrupt Flags, bit 14
XGIF_0F_00_XGIF_0F: equ    15                                        ; Channel Interrupt Flags, bit 15
; bit position masks
mXGIF_0F_00_XGIF_09: equ    %1000000000
mXGIF_0F_00_XGIF_0A: equ    %10000000000
mXGIF_0F_00_XGIF_0B: equ    %100000000000
mXGIF_0F_00_XGIF_0C: equ    %1000000000000
mXGIF_0F_00_XGIF_0D: equ    %10000000000000
mXGIF_0F_00_XGIF_0E: equ    %100000000000000
mXGIF_0F_00_XGIF_0F: equ    %1000000000000000


;*** XGSWT - XGATE Control Register; 0x00000398 ***
XGSWT:              equ    $00000398                                ;*** XGSWT - XGATE Control Register; 0x00000398 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGSWT_XGSWT:        equ    0                                         ; Software Trigger Bits
XGSWT_XGSWTM:       equ    8                                         ; Software Trigger Mask
; bit position masks
mXGSWT_XGSWT:       equ    %11111111
mXGSWT_XGSWTM:      equ    %1111111100000000


;*** XGSEM - XGATE Semaphore Register; 0x0000039A ***
XGSEM:              equ    $0000039A                                ;*** XGSEM - XGATE Semaphore Register; 0x0000039A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGSEM_XGSEM:        equ    0                                         ; Semaphore Bits
XGSEM_XGSEMM:       equ    8                                         ; Semaphore Mask
; bit position masks
mXGSEM_XGSEM:       equ    %11111111
mXGSEM_XGSEMM:      equ    %1111111100000000


;*** XGCCR - XGATE Condition Code Register; 0x0000039D ***
XGCCR:              equ    $0000039D                                ;*** XGCCR - XGATE Condition Code Register; 0x0000039D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGCCR_XGC:          equ    0                                         ; Carry Flag
XGCCR_XGV:          equ    1                                         ; Overflow Flag
XGCCR_XGZ:          equ    2                                         ; Zero Flag
XGCCR_XGN:          equ    3                                         ; Sign Flag
; bit position masks
mXGCCR_XGC:         equ    %00000001
mXGCCR_XGV:         equ    %00000010
mXGCCR_XGZ:         equ    %00000100
mXGCCR_XGN:         equ    %00001000


;*** XGPC - XGATE Program Counter Register; 0x0000039E ***
XGPC:               equ    $0000039E                                ;*** XGPC - XGATE Program Counter Register; 0x0000039E ***


;*** XGR1 - XGATE Register 1; 0x000003A2 ***
XGR1:               equ    $000003A2                                ;*** XGR1 - XGATE Register 1; 0x000003A2 ***


;*** XGR2 - XGATE Register 2; 0x000003A4 ***
XGR2:               equ    $000003A4                                ;*** XGR2 - XGATE Register 2; 0x000003A4 ***


;*** XGR3 - XGATE Register 3; 0x000003A6 ***
XGR3:               equ    $000003A6                                ;*** XGR3 - XGATE Register 3; 0x000003A6 ***


;*** XGR4 - XGATE Register 4; 0x000003A8 ***
XGR4:               equ    $000003A8                                ;*** XGR4 - XGATE Register 4; 0x000003A8 ***


;*** XGR5 - XGATE Register 5; 0x000003AA ***
XGR5:               equ    $000003AA                                ;*** XGR5 - XGATE Register 5; 0x000003AA ***


;*** XGR6 - XGATE Register 6; 0x000003AC ***
XGR6:               equ    $000003AC                                ;*** XGR6 - XGATE Register 6; 0x000003AC ***


;*** XGR7 - XGATE Register 7; 0x000003AE ***
XGR7:               equ    $000003AE                                ;*** XGR7 - XGATE Register 7; 0x000003AE ***


;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY:         equ    0                                         ; Backdoor Comparison Key Bits
; bit position masks
mBAKEY0_KEY:        equ    %1111111111111111


;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY:         equ    0                                         ; Backdoor Comparison Key Bits
; bit position masks
mBAKEY1_KEY:        equ    %1111111111111111


;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY:         equ    0                                         ; Backdoor Comparison Key Bits
; bit position masks
mBAKEY2_KEY:        equ    %1111111111111111


;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY:         equ    0                                         ; Backdoor Comparison Key Bits
; bit position masks
mBAKEY3_KEY:        equ    %1111111111111111


;*** NVFPROT - Non Volatile Flash Protection Register; 0x0000FF0D ***
NVFPROT:            equ    $0000FF0D                                ;*** NVFPROT - Non Volatile Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT_FPLS0:      equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT_FPLS1:      equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT_FPLDIS:     equ    2                                         ; Flash Protection Lower address range disable
NVFPROT_FPHS0:      equ    3                                         ; Flash Protection Higher address size 0
NVFPROT_FPHS1:      equ    4                                         ; Flash Protection Higher address size 1
NVFPROT_FPHDIS:     equ    5                                         ; Flash Protection Higher address range disable
NVFPROT_RNV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT_FPOPEN:     equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT_FPLS0:     equ    %00000001
mNVFPROT_FPLS1:     equ    %00000010
mNVFPROT_FPLDIS:    equ    %00000100
mNVFPROT_FPHS0:     equ    %00001000
mNVFPROT_FPHS1:     equ    %00010000
mNVFPROT_FPHDIS:    equ    %00100000
mNVFPROT_RNV6:      equ    %01000000
mNVFPROT_FPOPEN:    equ    %10000000


;*** NVFCTL - Non Volatile Flash Control Register; 0x0000FF0E ***
NVFCTL:             equ    $0000FF0E                                ;*** NVFCTL - Non Volatile Flash Control Register; 0x0000FF0E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFCTL_NV0:         equ    0                                         ; Non-volatile bits
NVFCTL_NV1:         equ    1                                         ; Non-volatile bit 1
NVFCTL_NV2:         equ    2                                         ; Non-volatile bit 2
NVFCTL_NV3:         equ    3                                         ; Non-volatile bit 3
NVFCTL_NV4:         equ    4                                         ; Non-volatile bit 4
NVFCTL_NV5:         equ    5                                         ; Non-volatile bit 5
NVFCTL_NV6:         equ    6                                         ; Non-volatile bit 6
NVFCTL_NV7:         equ    7                                         ; Non-volatile bit 7
; bit position masks
mNVFCTL_NV0:        equ    %00000001
mNVFCTL_NV1:        equ    %00000010
mNVFCTL_NV2:        equ    %00000100
mNVFCTL_NV3:        equ    %00001000
mNVFCTL_NV4:        equ    %00010000
mNVFCTL_NV5:        equ    %00100000
mNVFCTL_NV6:        equ    %01000000
mNVFCTL_NV7:        equ    %10000000


;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Memory security bit 0
NVFSEC_SEC1:        equ    1                                         ; Memory security bit 1
NVFSEC_RNV2:        equ    2                                         ; Non Volatile flag bit 2
NVFSEC_RNV3:        equ    3                                         ; Non Volatile flag bit 3
NVFSEC_RNV4:        equ    4                                         ; Non Volatile flag bit 4
NVFSEC_RNV5:        equ    5                                         ; Non Volatile flag bit 5
NVFSEC_KEYEN0:      equ    6                                         ; Backdoor Key Security Enable, bit 0
NVFSEC_KEYEN1:      equ    7                                         ; Backdoor Key Security Enable, bit 1
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_RNV2:       equ    %00000100
mNVFSEC_RNV3:       equ    %00001000
mNVFSEC_RNV4:       equ    %00010000
mNVFSEC_RNV5:       equ    %00100000
mNVFSEC_KEYEN0:     equ    %01000000
mNVFSEC_KEYEN1:     equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------
;

IIC0_IBCR2_ADR0:                         equ        IIC0_IBCR2_ADR8
IIC0_IBCR2_ADR1:                         equ        IIC0_IBCR2_ADR9
IIC0_IBCR2_ADR2:                         equ        IIC0_IBCR2_ADR10
mIIC0_IBCR2_ADR0:                        equ        mIIC0_IBCR2_ADR8
mIIC0_IBCR2_ADR1:                        equ        mIIC0_IBCR2_ADR9
mIIC0_IBCR2_ADR2:                        equ        mIIC0_IBCR2_ADR10
IIC1_IBCR2_ADR0:                         equ        IIC1_IBCR2_ADR8
IIC1_IBCR2_ADR1:                         equ        IIC1_IBCR2_ADR9
IIC1_IBCR2_ADR2:                         equ        IIC1_IBCR2_ADR10
mIIC1_IBCR2_ADR0:                        equ        mIIC1_IBCR2_ADR8
mIIC1_IBCR2_ADR1:                        equ        mIIC1_IBCR2_ADR9
mIIC1_IBCR2_ADR2:                        equ        mIIC1_IBCR2_ADR10

IB0AD:                                   equ        IIC0_IBAD
IB0AD_ADR1:                              equ        IIC0_IBAD_ADR1
IB0AD_ADR2:                              equ        IIC0_IBAD_ADR2
IB0AD_ADR3:                              equ        IIC0_IBAD_ADR3
IB0AD_ADR4:                              equ        IIC0_IBAD_ADR4
IB0AD_ADR5:                              equ        IIC0_IBAD_ADR5
IB0AD_ADR6:                              equ        IIC0_IBAD_ADR6
IB0AD_ADR7:                              equ        IIC0_IBAD_ADR7
mIB0AD_ADR1:                             equ        mIIC0_IBAD_ADR1
mIB0AD_ADR2:                             equ        mIIC0_IBAD_ADR2
mIB0AD_ADR3:                             equ        mIIC0_IBAD_ADR3
mIB0AD_ADR4:                             equ        mIIC0_IBAD_ADR4
mIB0AD_ADR5:                             equ        mIIC0_IBAD_ADR5
mIB0AD_ADR6:                             equ        mIIC0_IBAD_ADR6
mIB0AD_ADR7:                             equ        mIIC0_IBAD_ADR7
IB0FD:                                   equ        IIC0_IBFD
IB0FD_IBC0:                              equ        IIC0_IBFD_IBC0
IB0FD_IBC1:                              equ        IIC0_IBFD_IBC1
IB0FD_IBC2:                              equ        IIC0_IBFD_IBC2
IB0FD_IBC3:                              equ        IIC0_IBFD_IBC3
IB0FD_IBC4:                              equ        IIC0_IBFD_IBC4
IB0FD_IBC5:                              equ        IIC0_IBFD_IBC5
IB0FD_IBC6:                              equ        IIC0_IBFD_IBC6
IB0FD_IBC7:                              equ        IIC0_IBFD_IBC7
mIB0FD_IBC0:                             equ        mIIC0_IBFD_IBC0
mIB0FD_IBC1:                             equ        mIIC0_IBFD_IBC1
mIB0FD_IBC2:                             equ        mIIC0_IBFD_IBC2
mIB0FD_IBC3:                             equ        mIIC0_IBFD_IBC3
mIB0FD_IBC4:                             equ        mIIC0_IBFD_IBC4
mIB0FD_IBC5:                             equ        mIIC0_IBFD_IBC5
mIB0FD_IBC6:                             equ        mIIC0_IBFD_IBC6
mIB0FD_IBC7:                             equ        mIIC0_IBFD_IBC7
IB0CR:                                   equ        IIC0_IBCR
IB0CR_IBSWAI:                            equ        IIC0_IBCR_IBSWAI
IB0CR_RSTA:                              equ        IIC0_IBCR_RSTA
IB0CR_TXAK:                              equ        IIC0_IBCR_TXAK
IB0CR_TX_RX:                             equ        IIC0_IBCR_TX_RX
IB0CR_MS_SL:                             equ        IIC0_IBCR_MS_SL
IB0CR_IBIE:                              equ        IIC0_IBCR_IBIE
IB0CR_IBEN:                              equ        IIC0_IBCR_IBEN
mIB0CR_IBSWAI:                           equ        mIIC0_IBCR_IBSWAI
mIB0CR_RSTA:                             equ        mIIC0_IBCR_RSTA
mIB0CR_TXAK:                             equ        mIIC0_IBCR_TXAK
mIB0CR_TX_RX:                            equ        mIIC0_IBCR_TX_RX
mIB0CR_MS_SL:                            equ        mIIC0_IBCR_MS_SL
mIB0CR_IBIE:                             equ        mIIC0_IBCR_IBIE
mIB0CR_IBEN:                             equ        mIIC0_IBCR_IBEN
IB0SR:                                   equ        IIC0_IBSR
IB0SR_RXAK:                              equ        IIC0_IBSR_RXAK
IB0SR_IBIF:                              equ        IIC0_IBSR_IBIF
IB0SR_SRW:                               equ        IIC0_IBSR_SRW
IB0SR_IBAL:                              equ        IIC0_IBSR_IBAL
IB0SR_IBB:                               equ        IIC0_IBSR_IBB
IB0SR_IAAS:                              equ        IIC0_IBSR_IAAS
IB0SR_TCF:                               equ        IIC0_IBSR_TCF
mIB0SR_RXAK:                             equ        mIIC0_IBSR_RXAK
mIB0SR_IBIF:                             equ        mIIC0_IBSR_IBIF
mIB0SR_SRW:                              equ        mIIC0_IBSR_SRW
mIB0SR_IBAL:                             equ        mIIC0_IBSR_IBAL
mIB0SR_IBB:                              equ        mIIC0_IBSR_IBB
mIB0SR_IAAS:                             equ        mIIC0_IBSR_IAAS
mIB0SR_TCF:                              equ        mIIC0_IBSR_TCF
IB0DR:                                   equ        IIC0_IBDR
IB0DR_D0:                                equ        IIC0_IBDR_D0
IB0DR_D1:                                equ        IIC0_IBDR_D1
IB0DR_D2:                                equ        IIC0_IBDR_D2
IB0DR_D3:                                equ        IIC0_IBDR_D3
IB0DR_D4:                                equ        IIC0_IBDR_D4
IB0DR_D5:                                equ        IIC0_IBDR_D5
IB0DR_D6:                                equ        IIC0_IBDR_D6
IB0DR_D7:                                equ        IIC0_IBDR_D7
mIB0DR_D0:                               equ        mIIC0_IBDR_D0
mIB0DR_D1:                               equ        mIIC0_IBDR_D1
mIB0DR_D2:                               equ        mIIC0_IBDR_D2
mIB0DR_D3:                               equ        mIIC0_IBDR_D3
mIB0DR_D4:                               equ        mIIC0_IBDR_D4
mIB0DR_D5:                               equ        mIIC0_IBDR_D5
mIB0DR_D6:                               equ        mIIC0_IBDR_D6
mIB0DR_D7:                               equ        mIIC0_IBDR_D7
IB0CR2:                                  equ        IIC0_IBCR2
IB0CR2_ADR8:                             equ        IIC0_IBCR2_ADR0
IB0CR2_ADR9:                             equ        IIC0_IBCR2_ADR1
IB0CR2_ADR10:                            equ        IIC0_IBCR2_ADR2
IB0CR2_ADTYPE:                           equ        IIC0_IBCR2_ADTYPE
IB0CR2_GCEN:                             equ        IIC0_IBCR2_GCEN
mIB0CR2_ADR8:                            equ        mIIC0_IBCR2_ADR0
mIB0CR2_ADR9:                            equ        mIIC0_IBCR2_ADR1
mIB0CR2_ADR10:                           equ        mIIC0_IBCR2_ADR2
mIB0CR2_ADTYPE:                          equ        mIIC0_IBCR2_ADTYPE
mIB0CR2_GCEN:                            equ        mIIC0_IBCR2_GCEN
IB1AD:                                   equ        IIC1_IBAD
IB1AD_ADR1:                              equ        IIC1_IBAD_ADR1
IB1AD_ADR2:                              equ        IIC1_IBAD_ADR2
IB1AD_ADR3:                              equ        IIC1_IBAD_ADR3
IB1AD_ADR4:                              equ        IIC1_IBAD_ADR4
IB1AD_ADR5:                              equ        IIC1_IBAD_ADR5
IB1AD_ADR6:                              equ        IIC1_IBAD_ADR6
IB1AD_ADR7:                              equ        IIC1_IBAD_ADR7
mIB1AD_ADR1:                             equ        mIIC1_IBAD_ADR1
mIB1AD_ADR2:                             equ        mIIC1_IBAD_ADR2
mIB1AD_ADR3:                             equ        mIIC1_IBAD_ADR3
mIB1AD_ADR4:                             equ        mIIC1_IBAD_ADR4
mIB1AD_ADR5:                             equ        mIIC1_IBAD_ADR5
mIB1AD_ADR6:                             equ        mIIC1_IBAD_ADR6
mIB1AD_ADR7:                             equ        mIIC1_IBAD_ADR7
IB1FD:                                   equ        IIC1_IBFD
IB1FD_IBC0:                              equ        IIC1_IBFD_IBC0
IB1FD_IBC1:                              equ        IIC1_IBFD_IBC1
IB1FD_IBC2:                              equ        IIC1_IBFD_IBC2
IB1FD_IBC3:                              equ        IIC1_IBFD_IBC3
IB1FD_IBC4:                              equ        IIC1_IBFD_IBC4
IB1FD_IBC5:                              equ        IIC1_IBFD_IBC5
IB1FD_IBC6:                              equ        IIC1_IBFD_IBC6
IB1FD_IBC7:                              equ        IIC1_IBFD_IBC7
mIB1FD_IBC0:                             equ        mIIC1_IBFD_IBC0
mIB1FD_IBC1:                             equ        mIIC1_IBFD_IBC1
mIB1FD_IBC2:                             equ        mIIC1_IBFD_IBC2
mIB1FD_IBC3:                             equ        mIIC1_IBFD_IBC3
mIB1FD_IBC4:                             equ        mIIC1_IBFD_IBC4
mIB1FD_IBC5:                             equ        mIIC1_IBFD_IBC5
mIB1FD_IBC6:                             equ        mIIC1_IBFD_IBC6
mIB1FD_IBC7:                             equ        mIIC1_IBFD_IBC7
IB1CR:                                   equ        IIC1_IBCR
IB1CR_IBSWAI:                            equ        IIC1_IBCR_IBSWAI
IB1CR_RSTA:                              equ        IIC1_IBCR_RSTA
IB1CR_TXAK:                              equ        IIC1_IBCR_TXAK
IB1CR_TX_RX:                             equ        IIC1_IBCR_TX_RX
IB1CR_MS_SL:                             equ        IIC1_IBCR_MS_SL
IB1CR_IBIE:                              equ        IIC1_IBCR_IBIE
IB1CR_IBEN:                              equ        IIC1_IBCR_IBEN
mIB1CR_IBSWAI:                           equ        mIIC1_IBCR_IBSWAI
mIB1CR_RSTA:                             equ        mIIC1_IBCR_RSTA
mIB1CR_TXAK:                             equ        mIIC1_IBCR_TXAK
mIB1CR_TX_RX:                            equ        mIIC1_IBCR_TX_RX
mIB1CR_MS_SL:                            equ        mIIC1_IBCR_MS_SL
mIB1CR_IBIE:                             equ        mIIC1_IBCR_IBIE
mIB1CR_IBEN:                             equ        mIIC1_IBCR_IBEN
IB1SR:                                   equ        IIC1_IBSR
IB1SR_RXAK:                              equ        IIC1_IBSR_RXAK
IB1SR_IBIF:                              equ        IIC1_IBSR_IBIF
IB1SR_SRW:                               equ        IIC1_IBSR_SRW
IB1SR_IBAL:                              equ        IIC1_IBSR_IBAL
IB1SR_IBB:                               equ        IIC1_IBSR_IBB
IB1SR_IAAS:                              equ        IIC1_IBSR_IAAS
IB1SR_TCF:                               equ        IIC1_IBSR_TCF
mIB1SR_RXAK:                             equ        mIIC1_IBSR_RXAK
mIB1SR_IBIF:                             equ        mIIC1_IBSR_IBIF
mIB1SR_SRW:                              equ        mIIC1_IBSR_SRW
mIB1SR_IBAL:                             equ        mIIC1_IBSR_IBAL
mIB1SR_IBB:                              equ        mIIC1_IBSR_IBB
mIB1SR_IAAS:                             equ        mIIC1_IBSR_IAAS
mIB1SR_TCF:                              equ        mIIC1_IBSR_TCF
IB1DR:                                   equ        IIC1_IBDR
IB1DR_D0:                                equ        IIC1_IBDR_D0
IB1DR_D1:                                equ        IIC1_IBDR_D1
IB1DR_D2:                                equ        IIC1_IBDR_D2
IB1DR_D3:                                equ        IIC1_IBDR_D3
IB1DR_D4:                                equ        IIC1_IBDR_D4
IB1DR_D5:                                equ        IIC1_IBDR_D5
IB1DR_D6:                                equ        IIC1_IBDR_D6
IB1DR_D7:                                equ        IIC1_IBDR_D7
mIB1DR_D0:                               equ        mIIC1_IBDR_D0
mIB1DR_D1:                               equ        mIIC1_IBDR_D1
mIB1DR_D2:                               equ        mIIC1_IBDR_D2
mIB1DR_D3:                               equ        mIIC1_IBDR_D3
mIB1DR_D4:                               equ        mIIC1_IBDR_D4
mIB1DR_D5:                               equ        mIIC1_IBDR_D5
mIB1DR_D6:                               equ        mIIC1_IBDR_D6
mIB1DR_D7:                               equ        mIIC1_IBDR_D7
IB1CR2:                                  equ        IIC1_IBCR2
IB1CR2_ADR8:                             equ        IIC1_IBCR2_ADR0
IB1CR2_ADR9:                             equ        IIC1_IBCR2_ADR1
IB1CR2_ADR10:                            equ        IIC1_IBCR2_ADR2
IB1CR2_ADTYPE:                           equ        IIC1_IBCR2_ADTYPE
IB1CR2_GCEN:                             equ        IIC1_IBCR2_GCEN
mIB1CR2_ADR8:                            equ        mIIC1_IBCR2_ADR0
mIB1CR2_ADR9:                            equ        mIIC1_IBCR2_ADR1
mIB1CR2_ADR10:                           equ        mIIC1_IBCR2_ADR2
mIB1CR2_ADTYPE:                          equ        mIIC1_IBCR2_ADTYPE
mIB1CR2_GCEN:                            equ        mIIC1_IBCR2_GCEN
        IFNDEF __GENERATE_APPLICATION__
PA32H_PA2H0:                             equ        This_symb_has_been_depreciated
PA32H_PA2H1:                             equ        This_symb_has_been_depreciated
PA32H_PA2H2:                             equ        This_symb_has_been_depreciated
PA32H_PA2H3:                             equ        This_symb_has_been_depreciated
PA32H_PA2H4:                             equ        This_symb_has_been_depreciated
PA32H_PA2H5:                             equ        This_symb_has_been_depreciated
PA32H_PA2H6:                             equ        This_symb_has_been_depreciated
PA32H_PA2H7:                             equ        This_symb_has_been_depreciated
PA32H_PA3H0:                             equ        This_symb_has_been_depreciated
PA32H_PA3H1:                             equ        This_symb_has_been_depreciated
PA32H_PA3H2:                             equ        This_symb_has_been_depreciated
PA32H_PA3H3:                             equ        This_symb_has_been_depreciated
PA32H_PA3H4:                             equ        This_symb_has_been_depreciated
PA32H_PA3H5:                             equ        This_symb_has_been_depreciated
PA32H_PA3H6:                             equ        This_symb_has_been_depreciated
PA32H_PA3H7:                             equ        This_symb_has_been_depreciated
mPA32H_PA2H0:                            equ        This_symb_has_been_depreciated
mPA32H_PA2H1:                            equ        This_symb_has_been_depreciated
mPA32H_PA2H2:                            equ        This_symb_has_been_depreciated
mPA32H_PA2H3:                            equ        This_symb_has_been_depreciated
mPA32H_PA2H4:                            equ        This_symb_has_been_depreciated
mPA32H_PA2H5:                            equ        This_symb_has_been_depreciated
mPA32H_PA2H6:                            equ        This_symb_has_been_depreciated
mPA32H_PA2H7:                            equ        This_symb_has_been_depreciated
mPA32H_PA3H0:                            equ        This_symb_has_been_depreciated
mPA32H_PA3H1:                            equ        This_symb_has_been_depreciated
mPA32H_PA3H2:                            equ        This_symb_has_been_depreciated
mPA32H_PA3H3:                            equ        This_symb_has_been_depreciated
mPA32H_PA3H4:                            equ        This_symb_has_been_depreciated
mPA32H_PA3H5:                            equ        This_symb_has_been_depreciated
mPA32H_PA3H6:                            equ        This_symb_has_been_depreciated
mPA32H_PA3H7:                            equ        This_symb_has_been_depreciated
PA3H_PA3H0:                              equ        This_symb_has_been_depreciated
PA3H_PA3H1:                              equ        This_symb_has_been_depreciated
PA3H_PA3H2:                              equ        This_symb_has_been_depreciated
PA3H_PA3H3:                              equ        This_symb_has_been_depreciated
PA3H_PA3H4:                              equ        This_symb_has_been_depreciated
PA3H_PA3H5:                              equ        This_symb_has_been_depreciated
PA3H_PA3H6:                              equ        This_symb_has_been_depreciated
PA3H_PA3H7:                              equ        This_symb_has_been_depreciated
mPA3H_PA3H0:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H1:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H2:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H3:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H4:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H5:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H6:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H7:                             equ        This_symb_has_been_depreciated
PA2H_PA2H0:                              equ        This_symb_has_been_depreciated
PA2H_PA2H1:                              equ        This_symb_has_been_depreciated
PA2H_PA2H2:                              equ        This_symb_has_been_depreciated
PA2H_PA2H3:                              equ        This_symb_has_been_depreciated
PA2H_PA2H4:                              equ        This_symb_has_been_depreciated
PA2H_PA2H5:                              equ        This_symb_has_been_depreciated
PA2H_PA2H6:                              equ        This_symb_has_been_depreciated
PA2H_PA2H7:                              equ        This_symb_has_been_depreciated
mPA2H_PA2H0:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H1:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H2:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H3:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H4:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H5:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H6:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H7:                             equ        This_symb_has_been_depreciated
PA10H_PA0H0:                             equ        This_symb_has_been_depreciated
PA10H_PA0H1:                             equ        This_symb_has_been_depreciated
PA10H_PA0H2:                             equ        This_symb_has_been_depreciated
PA10H_PA0H3:                             equ        This_symb_has_been_depreciated
PA10H_PA0H4:                             equ        This_symb_has_been_depreciated
PA10H_PA0H5:                             equ        This_symb_has_been_depreciated
PA10H_PA0H6:                             equ        This_symb_has_been_depreciated
PA10H_PA0H7:                             equ        This_symb_has_been_depreciated
PA10H_PA1H0:                             equ        This_symb_has_been_depreciated
PA10H_PA1H1:                             equ        This_symb_has_been_depreciated
PA10H_PA1H2:                             equ        This_symb_has_been_depreciated
PA10H_PA1H3:                             equ        This_symb_has_been_depreciated
PA10H_PA1H4:                             equ        This_symb_has_been_depreciated
PA10H_PA1H5:                             equ        This_symb_has_been_depreciated
PA10H_PA1H6:                             equ        This_symb_has_been_depreciated
PA10H_PA1H7:                             equ        This_symb_has_been_depreciated
mPA10H_PA0H0:                            equ        This_symb_has_been_depreciated
mPA10H_PA0H1:                            equ        This_symb_has_been_depreciated
mPA10H_PA0H2:                            equ        This_symb_has_been_depreciated
mPA10H_PA0H3:                            equ        This_symb_has_been_depreciated
mPA10H_PA0H4:                            equ        This_symb_has_been_depreciated
mPA10H_PA0H5:                            equ        This_symb_has_been_depreciated
mPA10H_PA0H6:                            equ        This_symb_has_been_depreciated
mPA10H_PA0H7:                            equ        This_symb_has_been_depreciated
mPA10H_PA1H0:                            equ        This_symb_has_been_depreciated
mPA10H_PA1H1:                            equ        This_symb_has_been_depreciated
mPA10H_PA1H2:                            equ        This_symb_has_been_depreciated
mPA10H_PA1H3:                            equ        This_symb_has_been_depreciated
mPA10H_PA1H4:                            equ        This_symb_has_been_depreciated
mPA10H_PA1H5:                            equ        This_symb_has_been_depreciated
mPA10H_PA1H6:                            equ        This_symb_has_been_depreciated
mPA10H_PA1H7:                            equ        This_symb_has_been_depreciated
PA1H_PA1H0:                              equ        This_symb_has_been_depreciated
PA1H_PA1H1:                              equ        This_symb_has_been_depreciated
PA1H_PA1H2:                              equ        This_symb_has_been_depreciated
PA1H_PA1H3:                              equ        This_symb_has_been_depreciated
PA1H_PA1H4:                              equ        This_symb_has_been_depreciated
PA1H_PA1H5:                              equ        This_symb_has_been_depreciated
PA1H_PA1H6:                              equ        This_symb_has_been_depreciated
PA1H_PA1H7:                              equ        This_symb_has_been_depreciated
mPA1H_PA1H0:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H1:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H2:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H3:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H4:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H5:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H6:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H7:                             equ        This_symb_has_been_depreciated
PA0H_PA0H0:                              equ        This_symb_has_been_depreciated
PA0H_PA0H1:                              equ        This_symb_has_been_depreciated
PA0H_PA0H2:                              equ        This_symb_has_been_depreciated
PA0H_PA0H3:                              equ        This_symb_has_been_depreciated
PA0H_PA0H4:                              equ        This_symb_has_been_depreciated
PA0H_PA0H5:                              equ        This_symb_has_been_depreciated
PA0H_PA0H6:                              equ        This_symb_has_been_depreciated
PA0H_PA0H7:                              equ        This_symb_has_been_depreciated
mPA0H_PA0H0:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H1:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H2:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H3:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H4:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H5:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H6:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H7:                             equ        This_symb_has_been_depreciated
TC0H_TC0:                                equ        This_symb_has_been_depreciated
TC0H_TC1:                                equ        This_symb_has_been_depreciated
TC0H_TC2:                                equ        This_symb_has_been_depreciated
TC0H_TC3:                                equ        This_symb_has_been_depreciated
TC0H_TC4:                                equ        This_symb_has_been_depreciated
TC0H_TC5:                                equ        This_symb_has_been_depreciated
TC0H_TC6:                                equ        This_symb_has_been_depreciated
TC0H_TC7:                                equ        This_symb_has_been_depreciated
TC0H_TC8:                                equ        This_symb_has_been_depreciated
TC0H_TC9:                                equ        This_symb_has_been_depreciated
TC0H_TC10:                               equ        This_symb_has_been_depreciated
TC0H_TC11:                               equ        This_symb_has_been_depreciated
TC0H_TC12:                               equ        This_symb_has_been_depreciated
TC0H_TC13:                               equ        This_symb_has_been_depreciated
TC0H_TC14:                               equ        This_symb_has_been_depreciated
TC0H_TC15:                               equ        This_symb_has_been_depreciated
mTC0H_TC0:                               equ        This_symb_has_been_depreciated
mTC0H_TC1:                               equ        This_symb_has_been_depreciated
mTC0H_TC2:                               equ        This_symb_has_been_depreciated
mTC0H_TC3:                               equ        This_symb_has_been_depreciated
mTC0H_TC4:                               equ        This_symb_has_been_depreciated
mTC0H_TC5:                               equ        This_symb_has_been_depreciated
mTC0H_TC6:                               equ        This_symb_has_been_depreciated
mTC0H_TC7:                               equ        This_symb_has_been_depreciated
mTC0H_TC8:                               equ        This_symb_has_been_depreciated
mTC0H_TC9:                               equ        This_symb_has_been_depreciated
mTC0H_TC10:                              equ        This_symb_has_been_depreciated
mTC0H_TC11:                              equ        This_symb_has_been_depreciated
mTC0H_TC12:                              equ        This_symb_has_been_depreciated
mTC0H_TC13:                              equ        This_symb_has_been_depreciated
mTC0H_TC14:                              equ        This_symb_has_been_depreciated
mTC0H_TC15:                              equ        This_symb_has_been_depreciated
TC0Hhi_TC8:                              equ        This_symb_has_been_depreciated
TC0Hhi_TC9:                              equ        This_symb_has_been_depreciated
TC0Hhi_TC10:                             equ        This_symb_has_been_depreciated
TC0Hhi_TC11:                             equ        This_symb_has_been_depreciated
TC0Hhi_TC12:                             equ        This_symb_has_been_depreciated
TC0Hhi_TC13:                             equ        This_symb_has_been_depreciated
TC0Hhi_TC14:                             equ        This_symb_has_been_depreciated
TC0Hhi_TC15:                             equ        This_symb_has_been_depreciated
mTC0Hhi_TC8:                             equ        This_symb_has_been_depreciated
mTC0Hhi_TC9:                             equ        This_symb_has_been_depreciated
mTC0Hhi_TC10:                            equ        This_symb_has_been_depreciated
mTC0Hhi_TC11:                            equ        This_symb_has_been_depreciated
mTC0Hhi_TC12:                            equ        This_symb_has_been_depreciated
mTC0Hhi_TC13:                            equ        This_symb_has_been_depreciated
mTC0Hhi_TC14:                            equ        This_symb_has_been_depreciated
mTC0Hhi_TC15:                            equ        This_symb_has_been_depreciated
TC0Hlo_TC0:                              equ        This_symb_has_been_depreciated
TC0Hlo_TC1:                              equ        This_symb_has_been_depreciated
TC0Hlo_TC2:                              equ        This_symb_has_been_depreciated
TC0Hlo_TC3:                              equ        This_symb_has_been_depreciated
TC0Hlo_TC4:                              equ        This_symb_has_been_depreciated
TC0Hlo_TC5:                              equ        This_symb_has_been_depreciated
TC0Hlo_TC6:                              equ        This_symb_has_been_depreciated
TC0Hlo_TC7:                              equ        This_symb_has_been_depreciated
mTC0Hlo_TC0:                             equ        This_symb_has_been_depreciated
mTC0Hlo_TC1:                             equ        This_symb_has_been_depreciated
mTC0Hlo_TC2:                             equ        This_symb_has_been_depreciated
mTC0Hlo_TC3:                             equ        This_symb_has_been_depreciated
mTC0Hlo_TC4:                             equ        This_symb_has_been_depreciated
mTC0Hlo_TC5:                             equ        This_symb_has_been_depreciated
mTC0Hlo_TC6:                             equ        This_symb_has_been_depreciated
mTC0Hlo_TC7:                             equ        This_symb_has_been_depreciated
TC1H_TC0:                                equ        This_symb_has_been_depreciated
TC1H_TC1:                                equ        This_symb_has_been_depreciated
TC1H_TC2:                                equ        This_symb_has_been_depreciated
TC1H_TC3:                                equ        This_symb_has_been_depreciated
TC1H_TC4:                                equ        This_symb_has_been_depreciated
TC1H_TC5:                                equ        This_symb_has_been_depreciated
TC1H_TC6:                                equ        This_symb_has_been_depreciated
TC1H_TC7:                                equ        This_symb_has_been_depreciated
TC1H_TC8:                                equ        This_symb_has_been_depreciated
TC1H_TC9:                                equ        This_symb_has_been_depreciated
TC1H_TC10:                               equ        This_symb_has_been_depreciated
TC1H_TC11:                               equ        This_symb_has_been_depreciated
TC1H_TC12:                               equ        This_symb_has_been_depreciated
TC1H_TC13:                               equ        This_symb_has_been_depreciated
TC1H_TC14:                               equ        This_symb_has_been_depreciated
TC1H_TC15:                               equ        This_symb_has_been_depreciated
mTC1H_TC0:                               equ        This_symb_has_been_depreciated
mTC1H_TC1:                               equ        This_symb_has_been_depreciated
mTC1H_TC2:                               equ        This_symb_has_been_depreciated
mTC1H_TC3:                               equ        This_symb_has_been_depreciated
mTC1H_TC4:                               equ        This_symb_has_been_depreciated
mTC1H_TC5:                               equ        This_symb_has_been_depreciated
mTC1H_TC6:                               equ        This_symb_has_been_depreciated
mTC1H_TC7:                               equ        This_symb_has_been_depreciated
mTC1H_TC8:                               equ        This_symb_has_been_depreciated
mTC1H_TC9:                               equ        This_symb_has_been_depreciated
mTC1H_TC10:                              equ        This_symb_has_been_depreciated
mTC1H_TC11:                              equ        This_symb_has_been_depreciated
mTC1H_TC12:                              equ        This_symb_has_been_depreciated
mTC1H_TC13:                              equ        This_symb_has_been_depreciated
mTC1H_TC14:                              equ        This_symb_has_been_depreciated
mTC1H_TC15:                              equ        This_symb_has_been_depreciated
TC1Hhi_TC8:                              equ        This_symb_has_been_depreciated
TC1Hhi_TC9:                              equ        This_symb_has_been_depreciated
TC1Hhi_TC10:                             equ        This_symb_has_been_depreciated
TC1Hhi_TC11:                             equ        This_symb_has_been_depreciated
TC1Hhi_TC12:                             equ        This_symb_has_been_depreciated
TC1Hhi_TC13:                             equ        This_symb_has_been_depreciated
TC1Hhi_TC14:                             equ        This_symb_has_been_depreciated
TC1Hhi_TC15:                             equ        This_symb_has_been_depreciated
mTC1Hhi_TC8:                             equ        This_symb_has_been_depreciated
mTC1Hhi_TC9:                             equ        This_symb_has_been_depreciated
mTC1Hhi_TC10:                            equ        This_symb_has_been_depreciated
mTC1Hhi_TC11:                            equ        This_symb_has_been_depreciated
mTC1Hhi_TC12:                            equ        This_symb_has_been_depreciated
mTC1Hhi_TC13:                            equ        This_symb_has_been_depreciated
mTC1Hhi_TC14:                            equ        This_symb_has_been_depreciated
mTC1Hhi_TC15:                            equ        This_symb_has_been_depreciated
TC1Hlo_TC0:                              equ        This_symb_has_been_depreciated
TC1Hlo_TC1:                              equ        This_symb_has_been_depreciated
TC1Hlo_TC2:                              equ        This_symb_has_been_depreciated
TC1Hlo_TC3:                              equ        This_symb_has_been_depreciated
TC1Hlo_TC4:                              equ        This_symb_has_been_depreciated
TC1Hlo_TC5:                              equ        This_symb_has_been_depreciated
TC1Hlo_TC6:                              equ        This_symb_has_been_depreciated
TC1Hlo_TC7:                              equ        This_symb_has_been_depreciated
mTC1Hlo_TC0:                             equ        This_symb_has_been_depreciated
mTC1Hlo_TC1:                             equ        This_symb_has_been_depreciated
mTC1Hlo_TC2:                             equ        This_symb_has_been_depreciated
mTC1Hlo_TC3:                             equ        This_symb_has_been_depreciated
mTC1Hlo_TC4:                             equ        This_symb_has_been_depreciated
mTC1Hlo_TC5:                             equ        This_symb_has_been_depreciated
mTC1Hlo_TC6:                             equ        This_symb_has_been_depreciated
mTC1Hlo_TC7:                             equ        This_symb_has_been_depreciated
TC2H_TC0:                                equ        This_symb_has_been_depreciated
TC2H_TC1:                                equ        This_symb_has_been_depreciated
TC2H_TC2:                                equ        This_symb_has_been_depreciated
TC2H_TC3:                                equ        This_symb_has_been_depreciated
TC2H_TC4:                                equ        This_symb_has_been_depreciated
TC2H_TC5:                                equ        This_symb_has_been_depreciated
TC2H_TC6:                                equ        This_symb_has_been_depreciated
TC2H_TC7:                                equ        This_symb_has_been_depreciated
TC2H_TC8:                                equ        This_symb_has_been_depreciated
TC2H_TC9:                                equ        This_symb_has_been_depreciated
TC2H_TC10:                               equ        This_symb_has_been_depreciated
TC2H_TC11:                               equ        This_symb_has_been_depreciated
TC2H_TC12:                               equ        This_symb_has_been_depreciated
TC2H_TC13:                               equ        This_symb_has_been_depreciated
TC2H_TC14:                               equ        This_symb_has_been_depreciated
TC2H_TC15:                               equ        This_symb_has_been_depreciated
mTC2H_TC0:                               equ        This_symb_has_been_depreciated
mTC2H_TC1:                               equ        This_symb_has_been_depreciated
mTC2H_TC2:                               equ        This_symb_has_been_depreciated
mTC2H_TC3:                               equ        This_symb_has_been_depreciated
mTC2H_TC4:                               equ        This_symb_has_been_depreciated
mTC2H_TC5:                               equ        This_symb_has_been_depreciated
mTC2H_TC6:                               equ        This_symb_has_been_depreciated
mTC2H_TC7:                               equ        This_symb_has_been_depreciated
mTC2H_TC8:                               equ        This_symb_has_been_depreciated
mTC2H_TC9:                               equ        This_symb_has_been_depreciated
mTC2H_TC10:                              equ        This_symb_has_been_depreciated
mTC2H_TC11:                              equ        This_symb_has_been_depreciated
mTC2H_TC12:                              equ        This_symb_has_been_depreciated
mTC2H_TC13:                              equ        This_symb_has_been_depreciated
mTC2H_TC14:                              equ        This_symb_has_been_depreciated
mTC2H_TC15:                              equ        This_symb_has_been_depreciated
TC2Hhi_TC8:                              equ        This_symb_has_been_depreciated
TC2Hhi_TC9:                              equ        This_symb_has_been_depreciated
TC2Hhi_TC10:                             equ        This_symb_has_been_depreciated
TC2Hhi_TC11:                             equ        This_symb_has_been_depreciated
TC2Hhi_TC12:                             equ        This_symb_has_been_depreciated
TC2Hhi_TC13:                             equ        This_symb_has_been_depreciated
TC2Hhi_TC14:                             equ        This_symb_has_been_depreciated
TC2Hhi_TC15:                             equ        This_symb_has_been_depreciated
mTC2Hhi_TC8:                             equ        This_symb_has_been_depreciated
mTC2Hhi_TC9:                             equ        This_symb_has_been_depreciated
mTC2Hhi_TC10:                            equ        This_symb_has_been_depreciated
mTC2Hhi_TC11:                            equ        This_symb_has_been_depreciated
mTC2Hhi_TC12:                            equ        This_symb_has_been_depreciated
mTC2Hhi_TC13:                            equ        This_symb_has_been_depreciated
mTC2Hhi_TC14:                            equ        This_symb_has_been_depreciated
mTC2Hhi_TC15:                            equ        This_symb_has_been_depreciated
TC2Hlo_TC0:                              equ        This_symb_has_been_depreciated
TC2Hlo_TC1:                              equ        This_symb_has_been_depreciated
TC2Hlo_TC2:                              equ        This_symb_has_been_depreciated
TC2Hlo_TC3:                              equ        This_symb_has_been_depreciated
TC2Hlo_TC4:                              equ        This_symb_has_been_depreciated
TC2Hlo_TC5:                              equ        This_symb_has_been_depreciated
TC2Hlo_TC6:                              equ        This_symb_has_been_depreciated
TC2Hlo_TC7:                              equ        This_symb_has_been_depreciated
mTC2Hlo_TC0:                             equ        This_symb_has_been_depreciated
mTC2Hlo_TC1:                             equ        This_symb_has_been_depreciated
mTC2Hlo_TC2:                             equ        This_symb_has_been_depreciated
mTC2Hlo_TC3:                             equ        This_symb_has_been_depreciated
mTC2Hlo_TC4:                             equ        This_symb_has_been_depreciated
mTC2Hlo_TC5:                             equ        This_symb_has_been_depreciated
mTC2Hlo_TC6:                             equ        This_symb_has_been_depreciated
mTC2Hlo_TC7:                             equ        This_symb_has_been_depreciated
TC3H_TC0:                                equ        This_symb_has_been_depreciated
TC3H_TC1:                                equ        This_symb_has_been_depreciated
TC3H_TC2:                                equ        This_symb_has_been_depreciated
TC3H_TC3:                                equ        This_symb_has_been_depreciated
TC3H_TC4:                                equ        This_symb_has_been_depreciated
TC3H_TC5:                                equ        This_symb_has_been_depreciated
TC3H_TC6:                                equ        This_symb_has_been_depreciated
TC3H_TC7:                                equ        This_symb_has_been_depreciated
TC3H_TC8:                                equ        This_symb_has_been_depreciated
TC3H_TC9:                                equ        This_symb_has_been_depreciated
TC3H_TC10:                               equ        This_symb_has_been_depreciated
TC3H_TC11:                               equ        This_symb_has_been_depreciated
TC3H_TC12:                               equ        This_symb_has_been_depreciated
TC3H_TC13:                               equ        This_symb_has_been_depreciated
TC3H_TC14:                               equ        This_symb_has_been_depreciated
TC3H_TC15:                               equ        This_symb_has_been_depreciated
mTC3H_TC0:                               equ        This_symb_has_been_depreciated
mTC3H_TC1:                               equ        This_symb_has_been_depreciated
mTC3H_TC2:                               equ        This_symb_has_been_depreciated
mTC3H_TC3:                               equ        This_symb_has_been_depreciated
mTC3H_TC4:                               equ        This_symb_has_been_depreciated
mTC3H_TC5:                               equ        This_symb_has_been_depreciated
mTC3H_TC6:                               equ        This_symb_has_been_depreciated
mTC3H_TC7:                               equ        This_symb_has_been_depreciated
mTC3H_TC8:                               equ        This_symb_has_been_depreciated
mTC3H_TC9:                               equ        This_symb_has_been_depreciated
mTC3H_TC10:                              equ        This_symb_has_been_depreciated
mTC3H_TC11:                              equ        This_symb_has_been_depreciated
mTC3H_TC12:                              equ        This_symb_has_been_depreciated
mTC3H_TC13:                              equ        This_symb_has_been_depreciated
mTC3H_TC14:                              equ        This_symb_has_been_depreciated
mTC3H_TC15:                              equ        This_symb_has_been_depreciated
TC3Hhi_TC8:                              equ        This_symb_has_been_depreciated
TC3Hhi_TC9:                              equ        This_symb_has_been_depreciated
TC3Hhi_TC10:                             equ        This_symb_has_been_depreciated
TC3Hhi_TC11:                             equ        This_symb_has_been_depreciated
TC3Hhi_TC12:                             equ        This_symb_has_been_depreciated
TC3Hhi_TC13:                             equ        This_symb_has_been_depreciated
TC3Hhi_TC14:                             equ        This_symb_has_been_depreciated
TC3Hhi_TC15:                             equ        This_symb_has_been_depreciated
mTC3Hhi_TC8:                             equ        This_symb_has_been_depreciated
mTC3Hhi_TC9:                             equ        This_symb_has_been_depreciated
mTC3Hhi_TC10:                            equ        This_symb_has_been_depreciated
mTC3Hhi_TC11:                            equ        This_symb_has_been_depreciated
mTC3Hhi_TC12:                            equ        This_symb_has_been_depreciated
mTC3Hhi_TC13:                            equ        This_symb_has_been_depreciated
mTC3Hhi_TC14:                            equ        This_symb_has_been_depreciated
mTC3Hhi_TC15:                            equ        This_symb_has_been_depreciated
TC3Hlo_TC0:                              equ        This_symb_has_been_depreciated
TC3Hlo_TC1:                              equ        This_symb_has_been_depreciated
TC3Hlo_TC2:                              equ        This_symb_has_been_depreciated
TC3Hlo_TC3:                              equ        This_symb_has_been_depreciated
TC3Hlo_TC4:                              equ        This_symb_has_been_depreciated
TC3Hlo_TC5:                              equ        This_symb_has_been_depreciated
TC3Hlo_TC6:                              equ        This_symb_has_been_depreciated
TC3Hlo_TC7:                              equ        This_symb_has_been_depreciated
mTC3Hlo_TC0:                             equ        This_symb_has_been_depreciated
mTC3Hlo_TC1:                             equ        This_symb_has_been_depreciated
mTC3Hlo_TC2:                             equ        This_symb_has_been_depreciated
mTC3Hlo_TC3:                             equ        This_symb_has_been_depreciated
mTC3Hlo_TC4:                             equ        This_symb_has_been_depreciated
mTC3Hlo_TC5:                             equ        This_symb_has_been_depreciated
mTC3Hlo_TC6:                             equ        This_symb_has_been_depreciated
mTC3Hlo_TC7:                             equ        This_symb_has_been_depreciated
        ENDIF
PORTAD01:                                equ        ATDPTAD
PORTAD01_PTAD0:                          equ        ATDPTAD_PTAD0
PORTAD01_PTAD1:                          equ        ATDPTAD_PTAD1
PORTAD01_PTAD2:                          equ        ATDPTAD_PTAD2
PORTAD01_PTAD3:                          equ        ATDPTAD_PTAD3
PORTAD01_PTAD4:                          equ        ATDPTAD_PTAD4
PORTAD01_PTAD5:                          equ        ATDPTAD_PTAD5
PORTAD01_PTAD6:                          equ        ATDPTAD_PTAD6
PORTAD01_PTAD7:                          equ        ATDPTAD_PTAD7
PORTAD01_PTAD8:                          equ        ATDPTAD_PTAD8
PORTAD01_PTAD9:                          equ        ATDPTAD_PTAD9
PORTAD01_PTAD10:                         equ        ATDPTAD_PTAD10
PORTAD01_PTAD11:                         equ        ATDPTAD_PTAD11
PORTAD01_PTAD12:                         equ        ATDPTAD_PTAD12
PORTAD01_PTAD13:                         equ        ATDPTAD_PTAD13
PORTAD01_PTAD14:                         equ        ATDPTAD_PTAD14
PORTAD01_PTAD15:                         equ        ATDPTAD_PTAD15
mPORTAD01_PTAD0:                         equ        mATDPTAD_PTAD0
mPORTAD01_PTAD1:                         equ        mATDPTAD_PTAD1
mPORTAD01_PTAD2:                         equ        mATDPTAD_PTAD2
mPORTAD01_PTAD3:                         equ        mATDPTAD_PTAD3
mPORTAD01_PTAD4:                         equ        mATDPTAD_PTAD4
mPORTAD01_PTAD5:                         equ        mATDPTAD_PTAD5
mPORTAD01_PTAD6:                         equ        mATDPTAD_PTAD6
mPORTAD01_PTAD7:                         equ        mATDPTAD_PTAD7
mPORTAD01_PTAD8:                         equ        mATDPTAD_PTAD8
mPORTAD01_PTAD9:                         equ        mATDPTAD_PTAD9
mPORTAD01_PTAD10:                        equ        mATDPTAD_PTAD10
mPORTAD01_PTAD11:                        equ        mATDPTAD_PTAD11
mPORTAD01_PTAD12:                        equ        mATDPTAD_PTAD12
mPORTAD01_PTAD13:                        equ        mATDPTAD_PTAD13
mPORTAD01_PTAD14:                        equ        mATDPTAD_PTAD14
mPORTAD01_PTAD15:                        equ        mATDPTAD_PTAD15
PORTAD0:                                 equ        ATDPTAD0
PORTAD0_PTAD8:                           equ        ATDPTAD0_PTAD8
PORTAD0_PTAD9:                           equ        ATDPTAD0_PTAD9
PORTAD0_PTAD10:                          equ        ATDPTAD0_PTAD10
PORTAD0_PTAD11:                          equ        ATDPTAD0_PTAD11
PORTAD0_PTAD12:                          equ        ATDPTAD0_PTAD12
PORTAD0_PTAD13:                          equ        ATDPTAD0_PTAD13
PORTAD0_PTAD14:                          equ        ATDPTAD0_PTAD14
PORTAD0_PTAD15:                          equ        ATDPTAD0_PTAD15
mPORTAD0_PTAD8:                          equ        mATDPTAD0_PTAD8
mPORTAD0_PTAD9:                          equ        mATDPTAD0_PTAD9
mPORTAD0_PTAD10:                         equ        mATDPTAD0_PTAD10
mPORTAD0_PTAD11:                         equ        mATDPTAD0_PTAD11
mPORTAD0_PTAD12:                         equ        mATDPTAD0_PTAD12
mPORTAD0_PTAD13:                         equ        mATDPTAD0_PTAD13
mPORTAD0_PTAD14:                         equ        mATDPTAD0_PTAD14
mPORTAD0_PTAD15:                         equ        mATDPTAD0_PTAD15
PORTAD1:                                 equ        ATDPTAD1
PORTAD1_PTAD0:                           equ        ATDPTAD1_PTAD0
PORTAD1_PTAD1:                           equ        ATDPTAD1_PTAD1
PORTAD1_PTAD2:                           equ        ATDPTAD1_PTAD2
PORTAD1_PTAD3:                           equ        ATDPTAD1_PTAD3
PORTAD1_PTAD4:                           equ        ATDPTAD1_PTAD4
PORTAD1_PTAD5:                           equ        ATDPTAD1_PTAD5
PORTAD1_PTAD6:                           equ        ATDPTAD1_PTAD6
PORTAD1_PTAD7:                           equ        ATDPTAD1_PTAD7
mPORTAD1_PTAD0:                          equ        mATDPTAD1_PTAD0
mPORTAD1_PTAD1:                          equ        mATDPTAD1_PTAD1
mPORTAD1_PTAD2:                          equ        mATDPTAD1_PTAD2
mPORTAD1_PTAD3:                          equ        mATDPTAD1_PTAD3
mPORTAD1_PTAD4:                          equ        mATDPTAD1_PTAD4
mPORTAD1_PTAD5:                          equ        mATDPTAD1_PTAD5
mPORTAD1_PTAD6:                          equ        mATDPTAD1_PTAD6
mPORTAD1_PTAD7:                          equ        mATDPTAD1_PTAD7

        IFNDEF __GENERATE_APPLICATION__

PA3H_BIT0                                EQU        PA3H_PA3H0
mPA3H_BIT0                               EQU        mPA3H_PA3H0
PA3H_BIT1                                EQU        PA3H_PA3H1
mPA3H_BIT1                               EQU        mPA3H_PA3H1
PA3H_BIT2                                EQU        PA3H_PA3H2
mPA3H_BIT2                               EQU        mPA3H_PA3H2
PA3H_BIT3                                EQU        PA3H_PA3H3
mPA3H_BIT3                               EQU        mPA3H_PA3H3
PA3H_BIT4                                EQU        PA3H_PA3H4
mPA3H_BIT4                               EQU        mPA3H_PA3H4
PA3H_BIT5                                EQU        PA3H_PA3H5
mPA3H_BIT5                               EQU        mPA3H_PA3H5
PA3H_BIT6                                EQU        PA3H_PA3H6
mPA3H_BIT6                               EQU        mPA3H_PA3H6
PA3H_BIT7                                EQU        PA3H_PA3H7
mPA3H_BIT7                               EQU        mPA3H_PA3H7
PA2H_BIT0                                EQU        PA2H_PA2H0
mPA2H_BIT0                               EQU        mPA2H_PA2H0
PA2H_BIT1                                EQU        PA2H_PA2H1
mPA2H_BIT1                               EQU        mPA2H_PA2H1
PA2H_BIT2                                EQU        PA2H_PA2H2
mPA2H_BIT2                               EQU        mPA2H_PA2H2
PA2H_BIT3                                EQU        PA2H_PA2H3
mPA2H_BIT3                               EQU        mPA2H_PA2H3
PA2H_BIT4                                EQU        PA2H_PA2H4
mPA2H_BIT4                               EQU        mPA2H_PA2H4
PA2H_BIT5                                EQU        PA2H_PA2H5
mPA2H_BIT5                               EQU        mPA2H_PA2H5
PA2H_BIT6                                EQU        PA2H_PA2H6
mPA2H_BIT6                               EQU        mPA2H_PA2H6
PA2H_BIT7                                EQU        PA2H_PA2H7
mPA2H_BIT7                               EQU        mPA2H_PA2H7
PA1H_BIT0                                EQU        PA1H_PA1H0
mPA1H_BIT0                               EQU        mPA1H_PA1H0
PA1H_BIT1                                EQU        PA1H_PA1H1
mPA1H_BIT1                               EQU        mPA1H_PA1H1
PA1H_BIT2                                EQU        PA1H_PA1H2
mPA1H_BIT2                               EQU        mPA1H_PA1H2
PA1H_BIT3                                EQU        PA1H_PA1H3
mPA1H_BIT3                               EQU        mPA1H_PA1H3
PA1H_BIT4                                EQU        PA1H_PA1H4
mPA1H_BIT4                               EQU        mPA1H_PA1H4
PA1H_BIT5                                EQU        PA1H_PA1H5
mPA1H_BIT5                               EQU        mPA1H_PA1H5
PA1H_BIT6                                EQU        PA1H_PA1H6
mPA1H_BIT6                               EQU        mPA1H_PA1H6
PA1H_BIT7                                EQU        PA1H_PA1H7
mPA1H_BIT7                               EQU        mPA1H_PA1H7
PA0H_BIT0                                EQU        PA0H_PA0H0
mPA0H_BIT0                               EQU        mPA0H_PA0H0
PA0H_BIT1                                EQU        PA0H_PA0H1
mPA0H_BIT1                               EQU        mPA0H_PA0H1
PA0H_BIT2                                EQU        PA0H_PA0H2
mPA0H_BIT2                               EQU        mPA0H_PA0H2
PA0H_BIT3                                EQU        PA0H_PA0H3
mPA0H_BIT3                               EQU        mPA0H_PA0H3
PA0H_BIT4                                EQU        PA0H_PA0H4
mPA0H_BIT4                               EQU        mPA0H_PA0H4
PA0H_BIT5                                EQU        PA0H_PA0H5
mPA0H_BIT5                               EQU        mPA0H_PA0H5
PA0H_BIT6                                EQU        PA0H_PA0H6
mPA0H_BIT6                               EQU        mPA0H_PA0H6
PA0H_BIT7                                EQU        PA0H_PA0H7
mPA0H_BIT7                               EQU        mPA0H_PA0H7
        ENDIF
ATDPTAD01                                EQU        PORTAD01
ATDPTAD01_PTAD0                          EQU        PORTAD01_PTAD0
mATDPTAD01_PTAD0                         EQU        mPORTAD01_PTAD0
ATDPTAD01_PTAD1                          EQU        PORTAD01_PTAD1
mATDPTAD01_PTAD1                         EQU        mPORTAD01_PTAD1
ATDPTAD01_PTAD2                          EQU        PORTAD01_PTAD2
mATDPTAD01_PTAD2                         EQU        mPORTAD01_PTAD2
ATDPTAD01_PTAD3                          EQU        PORTAD01_PTAD3
mATDPTAD01_PTAD3                         EQU        mPORTAD01_PTAD3
ATDPTAD01_PTAD4                          EQU        PORTAD01_PTAD4
mATDPTAD01_PTAD4                         EQU        mPORTAD01_PTAD4
ATDPTAD01_PTAD5                          EQU        PORTAD01_PTAD5
mATDPTAD01_PTAD5                         EQU        mPORTAD01_PTAD5
ATDPTAD01_PTAD6                          EQU        PORTAD01_PTAD6
mATDPTAD01_PTAD6                         EQU        mPORTAD01_PTAD6
ATDPTAD01_PTAD7                          EQU        PORTAD01_PTAD7
mATDPTAD01_PTAD7                         EQU        mPORTAD01_PTAD7
ATDPTAD01_PTAD8                          EQU        PORTAD01_PTAD8
mATDPTAD01_PTAD8                         EQU        mPORTAD01_PTAD8
ATDPTAD01_PTAD9                          EQU        PORTAD01_PTAD9
mATDPTAD01_PTAD9                         EQU        mPORTAD01_PTAD9
ATDPTAD01_PTAD10                         EQU        PORTAD01_PTAD10
mATDPTAD01_PTAD10                        EQU        mPORTAD01_PTAD10
ATDPTAD01_PTAD11                         EQU        PORTAD01_PTAD11
mATDPTAD01_PTAD11                        EQU        mPORTAD01_PTAD11
ATDPTAD01_PTAD12                         EQU        PORTAD01_PTAD12
mATDPTAD01_PTAD12                        EQU        mPORTAD01_PTAD12
ATDPTAD01_PTAD13                         EQU        PORTAD01_PTAD13
mATDPTAD01_PTAD13                        EQU        mPORTAD01_PTAD13
ATDPTAD01_PTAD14                         EQU        PORTAD01_PTAD14
mATDPTAD01_PTAD14                        EQU        mPORTAD01_PTAD14
ATDPTAD01_PTAD15                         EQU        PORTAD01_PTAD15
mATDPTAD01_PTAD15                        EQU        mPORTAD01_PTAD15

XGIF0                                    EQU        XGIF_7F_70
XGIF0_XGIF_70                            EQU        XGIF_7F_70_XGIF_70
mXGIF0_XGIF_70                           EQU        mXGIF_7F_70_XGIF_70
XGIF0_XGIF_71                            EQU        XGIF_7F_70_XGIF_71
mXGIF0_XGIF_71                           EQU        mXGIF_7F_70_XGIF_71
XGIF0_XGIF_72                            EQU        XGIF_7F_70_XGIF_72
mXGIF0_XGIF_72                           EQU        mXGIF_7F_70_XGIF_72
XGIF0_XGIF_73                            EQU        XGIF_7F_70_XGIF_73
mXGIF0_XGIF_73                           EQU        mXGIF_7F_70_XGIF_73
XGIF0_XGIF_74                            EQU        XGIF_7F_70_XGIF_74
mXGIF0_XGIF_74                           EQU        mXGIF_7F_70_XGIF_74
XGIF0_XGIF_75                            EQU        XGIF_7F_70_XGIF_75
mXGIF0_XGIF_75                           EQU        mXGIF_7F_70_XGIF_75
XGIF0_XGIF_76                            EQU        XGIF_7F_70_XGIF_76
mXGIF0_XGIF_76                           EQU        mXGIF_7F_70_XGIF_76
XGIF0_XGIF_77                            EQU        XGIF_7F_70_XGIF_77
mXGIF0_XGIF_77                           EQU        mXGIF_7F_70_XGIF_77
XGIF0_XGIF_78                            EQU        XGIF_7F_70_XGIF_78
mXGIF0_XGIF_78                           EQU        mXGIF_7F_70_XGIF_78

XGIF1                                    EQU        XGIF_6F_60
XGIF1_XGIF_60                            EQU        XGIF_6F_60_XGIF_60
mXGIF1_XGIF_60                           EQU        mXGIF_6F_60_XGIF_60
XGIF1_XGIF_61                            EQU        XGIF_6F_60_XGIF_61
mXGIF1_XGIF_61                           EQU        mXGIF_6F_60_XGIF_61
XGIF1_XGIF_62                            EQU        XGIF_6F_60_XGIF_62
mXGIF1_XGIF_62                           EQU        mXGIF_6F_60_XGIF_62
XGIF1_XGIF_63                            EQU        XGIF_6F_60_XGIF_63
mXGIF1_XGIF_63                           EQU        mXGIF_6F_60_XGIF_63
XGIF1_XGIF_64                            EQU        XGIF_6F_60_XGIF_64
mXGIF1_XGIF_64                           EQU        mXGIF_6F_60_XGIF_64
XGIF1_XGIF_65                            EQU        XGIF_6F_60_XGIF_65
mXGIF1_XGIF_65                           EQU        mXGIF_6F_60_XGIF_65
XGIF1_XGIF_66                            EQU        XGIF_6F_60_XGIF_66
mXGIF1_XGIF_66                           EQU        mXGIF_6F_60_XGIF_66
XGIF1_XGIF_67                            EQU        XGIF_6F_60_XGIF_67
mXGIF1_XGIF_67                           EQU        mXGIF_6F_60_XGIF_67
XGIF1_XGIF_68                            EQU        XGIF_6F_60_XGIF_68
mXGIF1_XGIF_68                           EQU        mXGIF_6F_60_XGIF_68
XGIF1_XGIF_69                            EQU        XGIF_6F_60_XGIF_69
mXGIF1_XGIF_69                           EQU        mXGIF_6F_60_XGIF_69
XGIF1_XGIF_6A                            EQU        XGIF_6F_60_XGIF_6A
mXGIF1_XGIF_6A                           EQU        mXGIF_6F_60_XGIF_6A
XGIF1_XGIF_6B                            EQU        XGIF_6F_60_XGIF_6B
mXGIF1_XGIF_6B                           EQU        mXGIF_6F_60_XGIF_6B
XGIF1_XGIF_6C                            EQU        XGIF_6F_60_XGIF_6C
mXGIF1_XGIF_6C                           EQU        mXGIF_6F_60_XGIF_6C
XGIF1_XGIF_6D                            EQU        XGIF_6F_60_XGIF_6D
mXGIF1_XGIF_6D                           EQU        mXGIF_6F_60_XGIF_6D
XGIF1_XGIF_6E                            EQU        XGIF_6F_60_XGIF_6E
mXGIF1_XGIF_6E                           EQU        mXGIF_6F_60_XGIF_6E
XGIF1_XGIF_6F                            EQU        XGIF_6F_60_XGIF_6F
mXGIF1_XGIF_6F                           EQU        mXGIF_6F_60_XGIF_6F

XGIF2                                    EQU        XGIF_5F_50
XGIF2_XGIF_50                            EQU        XGIF_5F_50_XGIF_50
mXGIF2_XGIF_50                           EQU        mXGIF_5F_50_XGIF_50
XGIF2_XGIF_51                            EQU        XGIF_5F_50_XGIF_51
mXGIF2_XGIF_51                           EQU        mXGIF_5F_50_XGIF_51
XGIF2_XGIF_52                            EQU        XGIF_5F_50_XGIF_52
mXGIF2_XGIF_52                           EQU        mXGIF_5F_50_XGIF_52
XGIF2_XGIF_53                            EQU        XGIF_5F_50_XGIF_53
mXGIF2_XGIF_53                           EQU        mXGIF_5F_50_XGIF_53
XGIF2_XGIF_54                            EQU        XGIF_5F_50_XGIF_54
mXGIF2_XGIF_54                           EQU        mXGIF_5F_50_XGIF_54
XGIF2_XGIF_55                            EQU        XGIF_5F_50_XGIF_55
mXGIF2_XGIF_55                           EQU        mXGIF_5F_50_XGIF_55
XGIF2_XGIF_56                            EQU        XGIF_5F_50_XGIF_56
mXGIF2_XGIF_56                           EQU        mXGIF_5F_50_XGIF_56
XGIF2_XGIF_57                            EQU        XGIF_5F_50_XGIF_57
mXGIF2_XGIF_57                           EQU        mXGIF_5F_50_XGIF_57
XGIF2_XGIF_58                            EQU        XGIF_5F_50_XGIF_58
mXGIF2_XGIF_58                           EQU        mXGIF_5F_50_XGIF_58
XGIF2_XGIF_59                            EQU        XGIF_5F_50_XGIF_59
mXGIF2_XGIF_59                           EQU        mXGIF_5F_50_XGIF_59
XGIF2_XGIF_5A                            EQU        XGIF_5F_50_XGIF_5A
mXGIF2_XGIF_5A                           EQU        mXGIF_5F_50_XGIF_5A
XGIF2_XGIF_5B                            EQU        XGIF_5F_50_XGIF_5B
mXGIF2_XGIF_5B                           EQU        mXGIF_5F_50_XGIF_5B
XGIF2_XGIF_5C                            EQU        XGIF_5F_50_XGIF_5C
mXGIF2_XGIF_5C                           EQU        mXGIF_5F_50_XGIF_5C
XGIF2_XGIF_5D                            EQU        XGIF_5F_50_XGIF_5D
mXGIF2_XGIF_5D                           EQU        mXGIF_5F_50_XGIF_5D
XGIF2_XGIF_5E                            EQU        XGIF_5F_50_XGIF_5E
mXGIF2_XGIF_5E                           EQU        mXGIF_5F_50_XGIF_5E
XGIF2_XGIF_5F                            EQU        XGIF_5F_50_XGIF_5F
mXGIF2_XGIF_5F                           EQU        mXGIF_5F_50_XGIF_5F

XGIF3                                    EQU        XGIF_4F_40
XGIF3_XGIF_40                            EQU        XGIF_4F_40_XGIF_40
mXGIF3_XGIF_40                           EQU        mXGIF_4F_40_XGIF_40
XGIF3_XGIF_41                            EQU        XGIF_4F_40_XGIF_41
mXGIF3_XGIF_41                           EQU        mXGIF_4F_40_XGIF_41
XGIF3_XGIF_42                            EQU        XGIF_4F_40_XGIF_42
mXGIF3_XGIF_42                           EQU        mXGIF_4F_40_XGIF_42
XGIF3_XGIF_43                            EQU        XGIF_4F_40_XGIF_43
mXGIF3_XGIF_43                           EQU        mXGIF_4F_40_XGIF_43
XGIF3_XGIF_44                            EQU        XGIF_4F_40_XGIF_44
mXGIF3_XGIF_44                           EQU        mXGIF_4F_40_XGIF_44
XGIF3_XGIF_45                            EQU        XGIF_4F_40_XGIF_45
mXGIF3_XGIF_45                           EQU        mXGIF_4F_40_XGIF_45
XGIF3_XGIF_46                            EQU        XGIF_4F_40_XGIF_46
mXGIF3_XGIF_46                           EQU        mXGIF_4F_40_XGIF_46
XGIF3_XGIF_47                            EQU        XGIF_4F_40_XGIF_47
mXGIF3_XGIF_47                           EQU        mXGIF_4F_40_XGIF_47
XGIF3_XGIF_48                            EQU        XGIF_4F_40_XGIF_48
mXGIF3_XGIF_48                           EQU        mXGIF_4F_40_XGIF_48
XGIF3_XGIF_49                            EQU        XGIF_4F_40_XGIF_49
mXGIF3_XGIF_49                           EQU        mXGIF_4F_40_XGIF_49
XGIF3_XGIF_4A                            EQU        XGIF_4F_40_XGIF_4A
mXGIF3_XGIF_4A                           EQU        mXGIF_4F_40_XGIF_4A
XGIF3_XGIF_4B                            EQU        XGIF_4F_40_XGIF_4B
mXGIF3_XGIF_4B                           EQU        mXGIF_4F_40_XGIF_4B
XGIF3_XGIF_4C                            EQU        XGIF_4F_40_XGIF_4C
mXGIF3_XGIF_4C                           EQU        mXGIF_4F_40_XGIF_4C
XGIF3_XGIF_4D                            EQU        XGIF_4F_40_XGIF_4D
mXGIF3_XGIF_4D                           EQU        mXGIF_4F_40_XGIF_4D
XGIF3_XGIF_4E                            EQU        XGIF_4F_40_XGIF_4E
mXGIF3_XGIF_4E                           EQU        mXGIF_4F_40_XGIF_4E
XGIF3_XGIF_4F                            EQU        XGIF_4F_40_XGIF_4F
mXGIF3_XGIF_4F                           EQU        mXGIF_4F_40_XGIF_4F

XGIF4                                    EQU        XGIF_3F_30
XGIF4_XGIF_30                            EQU        XGIF_3F_30_XGIF_30
mXGIF4_XGIF_30                           EQU        mXGIF_3F_30_XGIF_30
XGIF4_XGIF_31                            EQU        XGIF_3F_30_XGIF_31
mXGIF4_XGIF_31                           EQU        mXGIF_3F_30_XGIF_31
XGIF4_XGIF_32                            EQU        XGIF_3F_30_XGIF_32
mXGIF4_XGIF_32                           EQU        mXGIF_3F_30_XGIF_32
XGIF4_XGIF_33                            EQU        XGIF_3F_30_XGIF_33
mXGIF4_XGIF_33                           EQU        mXGIF_3F_30_XGIF_33
XGIF4_XGIF_34                            EQU        XGIF_3F_30_XGIF_34
mXGIF4_XGIF_34                           EQU        mXGIF_3F_30_XGIF_34
XGIF4_XGIF_35                            EQU        XGIF_3F_30_XGIF_35
mXGIF4_XGIF_35                           EQU        mXGIF_3F_30_XGIF_35
XGIF4_XGIF_36                            EQU        XGIF_3F_30_XGIF_36
mXGIF4_XGIF_36                           EQU        mXGIF_3F_30_XGIF_36
XGIF4_XGIF_37                            EQU        XGIF_3F_30_XGIF_37
mXGIF4_XGIF_37                           EQU        mXGIF_3F_30_XGIF_37
XGIF4_XGIF_38                            EQU        XGIF_3F_30_XGIF_38
mXGIF4_XGIF_38                           EQU        mXGIF_3F_30_XGIF_38
XGIF4_XGIF_39                            EQU        XGIF_3F_30_XGIF_39
mXGIF4_XGIF_39                           EQU        mXGIF_3F_30_XGIF_39
XGIF4_XGIF_3A                            EQU        XGIF_3F_30_XGIF_3A
mXGIF4_XGIF_3A                           EQU        mXGIF_3F_30_XGIF_3A
XGIF4_XGIF_3B                            EQU        XGIF_3F_30_XGIF_3B
mXGIF4_XGIF_3B                           EQU        mXGIF_3F_30_XGIF_3B
XGIF4_XGIF_3C                            EQU        XGIF_3F_30_XGIF_3C
mXGIF4_XGIF_3C                           EQU        mXGIF_3F_30_XGIF_3C
XGIF4_XGIF_3D                            EQU        XGIF_3F_30_XGIF_3D
mXGIF4_XGIF_3D                           EQU        mXGIF_3F_30_XGIF_3D
XGIF4_XGIF_3E                            EQU        XGIF_3F_30_XGIF_3E
mXGIF4_XGIF_3E                           EQU        mXGIF_3F_30_XGIF_3E
XGIF4_XGIF_3F                            EQU        XGIF_3F_30_XGIF_3F
mXGIF4_XGIF_3F                           EQU        mXGIF_3F_30_XGIF_3F

XGIF5                                    EQU        XGIF_2F_20
XGIF5_XGIF_20                            EQU        XGIF_2F_20_XGIF_20
mXGIF5_XGIF_20                           EQU        mXGIF_2F_20_XGIF_20
XGIF5_XGIF_21                            EQU        XGIF_2F_20_XGIF_21
mXGIF5_XGIF_21                           EQU        mXGIF_2F_20_XGIF_21
XGIF5_XGIF_22                            EQU        XGIF_2F_20_XGIF_22
mXGIF5_XGIF_22                           EQU        mXGIF_2F_20_XGIF_22
XGIF5_XGIF_23                            EQU        XGIF_2F_20_XGIF_23
mXGIF5_XGIF_23                           EQU        mXGIF_2F_20_XGIF_23
XGIF5_XGIF_24                            EQU        XGIF_2F_20_XGIF_24
mXGIF5_XGIF_24                           EQU        mXGIF_2F_20_XGIF_24
XGIF5_XGIF_25                            EQU        XGIF_2F_20_XGIF_25
mXGIF5_XGIF_25                           EQU        mXGIF_2F_20_XGIF_25
XGIF5_XGIF_26                            EQU        XGIF_2F_20_XGIF_26
mXGIF5_XGIF_26                           EQU        mXGIF_2F_20_XGIF_26
XGIF5_XGIF_27                            EQU        XGIF_2F_20_XGIF_27
mXGIF5_XGIF_27                           EQU        mXGIF_2F_20_XGIF_27
XGIF5_XGIF_28                            EQU        XGIF_2F_20_XGIF_28
mXGIF5_XGIF_28                           EQU        mXGIF_2F_20_XGIF_28
XGIF5_XGIF_29                            EQU        XGIF_2F_20_XGIF_29
mXGIF5_XGIF_29                           EQU        mXGIF_2F_20_XGIF_29
XGIF5_XGIF_2A                            EQU        XGIF_2F_20_XGIF_2A
mXGIF5_XGIF_2A                           EQU        mXGIF_2F_20_XGIF_2A
XGIF5_XGIF_2B                            EQU        XGIF_2F_20_XGIF_2B
mXGIF5_XGIF_2B                           EQU        mXGIF_2F_20_XGIF_2B
XGIF5_XGIF_2C                            EQU        XGIF_2F_20_XGIF_2C
mXGIF5_XGIF_2C                           EQU        mXGIF_2F_20_XGIF_2C
XGIF5_XGIF_2D                            EQU        XGIF_2F_20_XGIF_2D
mXGIF5_XGIF_2D                           EQU        mXGIF_2F_20_XGIF_2D
XGIF5_XGIF_2E                            EQU        XGIF_2F_20_XGIF_2E
mXGIF5_XGIF_2E                           EQU        mXGIF_2F_20_XGIF_2E
XGIF5_XGIF_2F                            EQU        XGIF_2F_20_XGIF_2F
mXGIF5_XGIF_2F                           EQU        mXGIF_2F_20_XGIF_2F

XGIF6                                    EQU        XGIF_1F_10
XGIF6_XGIF_10                            EQU        XGIF_1F_10_XGIF_10
mXGIF6_XGIF_10                           EQU        mXGIF_1F_10_XGIF_10
XGIF6_XGIF_11                            EQU        XGIF_1F_10_XGIF_11
mXGIF6_XGIF_11                           EQU        mXGIF_1F_10_XGIF_11
XGIF6_XGIF_12                            EQU        XGIF_1F_10_XGIF_12
mXGIF6_XGIF_12                           EQU        mXGIF_1F_10_XGIF_12
XGIF6_XGIF_13                            EQU        XGIF_1F_10_XGIF_13
mXGIF6_XGIF_13                           EQU        mXGIF_1F_10_XGIF_13
XGIF6_XGIF_14                            EQU        XGIF_1F_10_XGIF_14
mXGIF6_XGIF_14                           EQU        mXGIF_1F_10_XGIF_14
XGIF6_XGIF_15                            EQU        XGIF_1F_10_XGIF_15
mXGIF6_XGIF_15                           EQU        mXGIF_1F_10_XGIF_15
XGIF6_XGIF_16                            EQU        XGIF_1F_10_XGIF_16
mXGIF6_XGIF_16                           EQU        mXGIF_1F_10_XGIF_16
XGIF6_XGIF_17                            EQU        XGIF_1F_10_XGIF_17
mXGIF6_XGIF_17                           EQU        mXGIF_1F_10_XGIF_17
XGIF6_XGIF_18                            EQU        XGIF_1F_10_XGIF_18
mXGIF6_XGIF_18                           EQU        mXGIF_1F_10_XGIF_18
XGIF6_XGIF_19                            EQU        XGIF_1F_10_XGIF_19
mXGIF6_XGIF_19                           EQU        mXGIF_1F_10_XGIF_19
XGIF6_XGIF_1A                            EQU        XGIF_1F_10_XGIF_1A
mXGIF6_XGIF_1A                           EQU        mXGIF_1F_10_XGIF_1A
XGIF6_XGIF_1B                            EQU        XGIF_1F_10_XGIF_1B
mXGIF6_XGIF_1B                           EQU        mXGIF_1F_10_XGIF_1B
XGIF6_XGIF_1C                            EQU        XGIF_1F_10_XGIF_1C
mXGIF6_XGIF_1C                           EQU        mXGIF_1F_10_XGIF_1C
XGIF6_XGIF_1D                            EQU        XGIF_1F_10_XGIF_1D
mXGIF6_XGIF_1D                           EQU        mXGIF_1F_10_XGIF_1D
XGIF6_XGIF_1E                            EQU        XGIF_1F_10_XGIF_1E
mXGIF6_XGIF_1E                           EQU        mXGIF_1F_10_XGIF_1E
XGIF6_XGIF_1F                            EQU        XGIF_1F_10_XGIF_1F
mXGIF6_XGIF_1F                           EQU        mXGIF_1F_10_XGIF_1F

XGIF7                                    EQU        XGIF_0F_00
XGIF7_XGIF_09                            EQU        XGIF_0F_00_XGIF_09
mXGIF7_XGIF_09                           EQU        mXGIF_0F_00_XGIF_09
XGIF7_XGIF_0A                            EQU        XGIF_0F_00_XGIF_0A
mXGIF7_XGIF_0A                           EQU        mXGIF_0F_00_XGIF_0A
XGIF7_XGIF_0B                            EQU        XGIF_0F_00_XGIF_0B
mXGIF7_XGIF_0B                           EQU        mXGIF_0F_00_XGIF_0B
XGIF7_XGIF_0C                            EQU        XGIF_0F_00_XGIF_0C
mXGIF7_XGIF_0C                           EQU        mXGIF_0F_00_XGIF_0C
XGIF7_XGIF_0D                            EQU        XGIF_0F_00_XGIF_0D
mXGIF7_XGIF_0D                           EQU        mXGIF_0F_00_XGIF_0D
XGIF7_XGIF_0E                            EQU        XGIF_0F_00_XGIF_0E
mXGIF7_XGIF_0E                           EQU        mXGIF_0F_00_XGIF_0E
XGIF7_XGIF_0F                            EQU        XGIF_0F_00_XGIF_0F
mXGIF7_XGIF_0F                           EQU        mXGIF_0F_00_XGIF_0F
        IFNDEF __GENERATE_APPLICATION__
XGIF0_XGIF_                              EQU        This_symb_has_been_depreciated
XGIF1_XGIF_                              EQU        This_symb_has_been_depreciated
XGIF2_XGIF_                              EQU        This_symb_has_been_depreciated
XGIF3_XGIF_                              EQU        This_symb_has_been_depreciated
XGIF4_XGIF_                              EQU        This_symb_has_been_depreciated
XGIF5_XGIF_                              EQU        This_symb_has_been_depreciated
XGIF6_XGIF_                              EQU        This_symb_has_been_depreciated
XGIF7_XGIF_                              EQU        This_symb_has_been_depreciated
PA32H_BIT0                               EQU        PA32H_PA2H0
mPA32H_BIT0                              EQU        mPA32H_PA2H0
PA32H_BIT1                               EQU        PA32H_PA2H1
mPA32H_BIT1                              EQU        mPA32H_PA2H1
PA32H_BIT2                               EQU        PA32H_PA2H2
mPA32H_BIT2                              EQU        mPA32H_PA2H2
PA32H_BIT3                               EQU        PA32H_PA2H3
mPA32H_BIT3                              EQU        mPA32H_PA2H3
PA32H_BIT4                               EQU        PA32H_PA2H4
mPA32H_BIT4                              EQU        mPA32H_PA2H4
PA32H_BIT5                               EQU        PA32H_PA2H5
mPA32H_BIT5                              EQU        mPA32H_PA2H5
PA32H_BIT6                               EQU        PA32H_PA2H6
mPA32H_BIT6                              EQU        mPA32H_PA2H6
PA32H_BIT7                               EQU        PA32H_PA2H7
mPA32H_BIT7                              EQU        mPA32H_PA2H7
PA32H_BIT8                               EQU        PA32H_PA3H0
mPA32H_BIT8                              EQU        mPA32H_PA3H0
PA32H_BIT9                               EQU        PA32H_PA3H1
mPA32H_BIT9                              EQU        mPA32H_PA3H1
PA32H_BIT10                              EQU        PA32H_PA3H2
mPA32H_BIT10                             EQU        mPA32H_PA3H2
PA32H_BIT11                              EQU        PA32H_PA3H3
mPA32H_BIT11                             EQU        mPA32H_PA3H3
PA32H_BIT12                              EQU        PA32H_PA3H4
mPA32H_BIT12                             EQU        mPA32H_PA3H4
PA32H_BIT13                              EQU        PA32H_PA3H5
mPA32H_BIT13                             EQU        mPA32H_PA3H5
PA32H_BIT14                              EQU        PA32H_PA3H6
mPA32H_BIT14                             EQU        mPA32H_PA3H6
PA32H_BIT15                              EQU        PA32H_PA3H7
mPA32H_BIT15                             EQU        mPA32H_PA3H7
PA10H_BIT0                               EQU        PA10H_PA0H0
mPA10H_BIT0                              EQU        mPA10H_PA0H0
PA10H_BIT1                               EQU        PA10H_PA0H1
mPA10H_BIT1                              EQU        mPA10H_PA0H1
PA10H_BIT2                               EQU        PA10H_PA0H2
mPA10H_BIT2                              EQU        mPA10H_PA0H2
PA10H_BIT3                               EQU        PA10H_PA0H3
mPA10H_BIT3                              EQU        mPA10H_PA0H3
PA10H_BIT4                               EQU        PA10H_PA0H4
mPA10H_BIT4                              EQU        mPA10H_PA0H4
PA10H_BIT5                               EQU        PA10H_PA0H5
mPA10H_BIT5                              EQU        mPA10H_PA0H5
PA10H_BIT6                               EQU        PA10H_PA0H6
mPA10H_BIT6                              EQU        mPA10H_PA0H6
PA10H_BIT7                               EQU        PA10H_PA0H7
mPA10H_BIT7                              EQU        mPA10H_PA0H7
PA10H_BIT8                               EQU        PA10H_PA1H0
mPA10H_BIT8                              EQU        mPA10H_PA1H0
PA10H_BIT9                               EQU        PA10H_PA1H1
mPA10H_BIT9                              EQU        mPA10H_PA1H1
PA10H_BIT10                              EQU        PA10H_PA1H2
mPA10H_BIT10                             EQU        mPA10H_PA1H2
PA10H_BIT11                              EQU        PA10H_PA1H3
mPA10H_BIT11                             EQU        mPA10H_PA1H3
PA10H_BIT12                              EQU        PA10H_PA1H4
mPA10H_BIT12                             EQU        mPA10H_PA1H4
PA10H_BIT13                              EQU        PA10H_PA1H5
mPA10H_BIT13                             EQU        mPA10H_PA1H5
PA10H_BIT14                              EQU        PA10H_PA1H6
mPA10H_BIT14                             EQU        mPA10H_PA1H6
PA10H_BIT15                              EQU        PA10H_PA1H7
mPA10H_BIT15                             EQU        mPA10H_PA1H7
        ENDIF
DBGXDH_BIT0                              EQU        DBGXDH_BIT8
mDBGXDH_BIT0                             EQU        mDBGXDH_BIT8
DBGXDH_BIT1                              EQU        DBGXDH_BIT9
mDBGXDH_BIT1                             EQU        mDBGXDH_BIT9
DBGXDH_BIT2                              EQU        DBGXDH_BIT10
mDBGXDH_BIT2                             EQU        mDBGXDH_BIT10
DBGXDH_BIT3                              EQU        DBGXDH_BIT11
mDBGXDH_BIT3                             EQU        mDBGXDH_BIT11
DBGXDH_BIT4                              EQU        DBGXDH_BIT12
mDBGXDH_BIT4                             EQU        mDBGXDH_BIT12
DBGXDH_BIT5                              EQU        DBGXDH_BIT13
mDBGXDH_BIT5                             EQU        mDBGXDH_BIT13
DBGXDH_BIT6                              EQU        DBGXDH_BIT14
mDBGXDH_BIT6                             EQU        mDBGXDH_BIT14
DBGXDH_BIT7                              EQU        DBGXDH_BIT15
mDBGXDH_BIT7                             EQU        mDBGXDH_BIT15
INT_CFADDR_INT_CFADDRGrp                 EQU        INT_CFADDR_INT_CFADDR

mINT_CFADDR_INT_CFADDRGrp                EQU        mINT_CFADDR_INT_CFADDR
XGCHID_XGCHIDGrp                         EQU        XGCHID_XGCHID

mXGCHID_XGCHIDGrp                        EQU        mXGCHID_XGCHID
XGVBR_XGVBRGrp                           EQU        XGVBR_XGVBR

mXGVBR_XGVBRGrp                          EQU        mXGVBR_XGVBR
XGSWT_XGSWTGrp                           EQU        XGSWT_XGSWT

mXGSWT_XGSWTGrp                          EQU        mXGSWT_XGSWT
XGSEM_XGSEMGrp                           EQU        XGSEM_XGSEM

mXGSEM_XGSEMGrp                          EQU        mXGSEM_XGSEM
SCI0CR2_SCTIE                            EQU        SCI0CR2_TIE
mSCI0CR2_SCTIE                           EQU        mSCI0CR2_TIE
SCI1CR2_SCTIE                            EQU        SCI1CR2_TIE
mSCI1CR2_SCTIE                           EQU        mSCI1CR2_TIE
IB0FD_IB0C0                              EQU        IB0FD_IBC0
mIB0FD_IB0C0                             EQU        mIB0FD_IBC0
IB0FD_IB0C1                              EQU        IB0FD_IBC1
mIB0FD_IB0C1                             EQU        mIB0FD_IBC1
IB0FD_IB0C2                              EQU        IB0FD_IBC2
mIB0FD_IB0C2                             EQU        mIB0FD_IBC2
IB0FD_IB0C3                              EQU        IB0FD_IBC3
mIB0FD_IB0C3                             EQU        mIB0FD_IBC3
IB0FD_IB0C4                              EQU        IB0FD_IBC4
mIB0FD_IB0C4                             EQU        mIB0FD_IBC4
IB0FD_IB0C5                              EQU        IB0FD_IBC5
mIB0FD_IB0C5                             EQU        mIB0FD_IBC5
IB0FD_IB0C6                              EQU        IB0FD_IBC6
mIB0FD_IB0C6                             EQU        mIB0FD_IBC6
IB0FD_IB0C7                              EQU        IB0FD_IBC7
mIB0FD_IB0C7                             EQU        mIB0FD_IBC7
IB0CR_IB0SWAI                            EQU        IB0CR_IBSWAI
mIB0CR_IB0SWAI                           EQU        mIB0CR_IBSWAI
IB0CR_IB0IE                              EQU        IB0CR_IBIE
mIB0CR_IB0IE                             EQU        mIB0CR_IBIE
IB0CR_IB0EN                              EQU        IB0CR_IBEN
mIB0CR_IB0EN                             EQU        mIB0CR_IBEN
IB0SR_IB0IF                              EQU        IB0SR_IBIF
mIB0SR_IB0IF                             EQU        mIB0SR_IBIF
IB0SR_IB0AL                              EQU        IB0SR_IBAL
mIB0SR_IB0AL                             EQU        mIB0SR_IBAL
IB0SR_IB0B                               EQU        IB0SR_IBB
mIB0SR_IB0B                              EQU        mIB0SR_IBB
IB1FD_IB1C0                              EQU        IB1FD_IBC0
mIB1FD_IB1C0                             EQU        mIB1FD_IBC0
IB1FD_IB1C1                              EQU        IB1FD_IBC1
mIB1FD_IB1C1                             EQU        mIB1FD_IBC1
IB1FD_IB1C2                              EQU        IB1FD_IBC2
mIB1FD_IB1C2                             EQU        mIB1FD_IBC2
IB1FD_IB1C3                              EQU        IB1FD_IBC3
mIB1FD_IB1C3                             EQU        mIB1FD_IBC3
IB1FD_IB1C4                              EQU        IB1FD_IBC4
mIB1FD_IB1C4                             EQU        mIB1FD_IBC4
IB1FD_IB1C5                              EQU        IB1FD_IBC5
mIB1FD_IB1C5                             EQU        mIB1FD_IBC5
IB1FD_IB1C6                              EQU        IB1FD_IBC6
mIB1FD_IB1C6                             EQU        mIB1FD_IBC6
IB1FD_IB1C7                              EQU        IB1FD_IBC7
mIB1FD_IB1C7                             EQU        mIB1FD_IBC7
IB1CR_IB1SWAI                            EQU        IB1CR_IBSWAI
mIB1CR_IB1SWAI                           EQU        mIB1CR_IBSWAI
IB1CR_IB1IE                              EQU        IB1CR_IBIE
mIB1CR_IB1IE                             EQU        mIB1CR_IBIE
IB1CR_IB1EN                              EQU        IB1CR_IBEN
mIB1CR_IB1EN                             EQU        mIB1CR_IBEN
IB1SR_IB1IF                              EQU        IB1SR_IBIF
mIB1SR_IB1IF                             EQU        mIB1SR_IBIF
IB1SR_IB1AL                              EQU        IB1SR_IBAL
mIB1SR_IB1AL                             EQU        mIB1SR_IBAL
IB1SR_IB1B                               EQU        IB1SR_IBB
mIB1SR_IB1B                              EQU        mIB1SR_IBB

        IFNDEF __GENERATE_APPLICATION__

TC0H_BIT0                                EQU        TC0H_TC0
mTC0H_BIT0                               EQU        mTC0H_TC0
TC0H_BIT1                                EQU        TC0H_TC1
mTC0H_BIT1                               EQU        mTC0H_TC1
TC0H_BIT2                                EQU        TC0H_TC2
mTC0H_BIT2                               EQU        mTC0H_TC2
TC0H_BIT3                                EQU        TC0H_TC3
mTC0H_BIT3                               EQU        mTC0H_TC3
TC0H_BIT4                                EQU        TC0H_TC4
mTC0H_BIT4                               EQU        mTC0H_TC4
TC0H_BIT5                                EQU        TC0H_TC5
mTC0H_BIT5                               EQU        mTC0H_TC5
TC0H_BIT6                                EQU        TC0H_TC6
mTC0H_BIT6                               EQU        mTC0H_TC6
TC0H_BIT7                                EQU        TC0H_TC7
mTC0H_BIT7                               EQU        mTC0H_TC7
TC0H_BIT8                                EQU        TC0H_TC8
mTC0H_BIT8                               EQU        mTC0H_TC8
TC0H_BIT9                                EQU        TC0H_TC9
mTC0H_BIT9                               EQU        mTC0H_TC9
TC0H_BIT10                               EQU        TC0H_TC10
mTC0H_BIT10                              EQU        mTC0H_TC10
TC0H_BIT11                               EQU        TC0H_TC11
mTC0H_BIT11                              EQU        mTC0H_TC11
TC0H_BIT12                               EQU        TC0H_TC12
mTC0H_BIT12                              EQU        mTC0H_TC12
TC0H_BIT13                               EQU        TC0H_TC13
mTC0H_BIT13                              EQU        mTC0H_TC13
TC0H_BIT14                               EQU        TC0H_TC14
mTC0H_BIT14                              EQU        mTC0H_TC14
TC0H_BIT15                               EQU        TC0H_TC15
mTC0H_BIT15                              EQU        mTC0H_TC15
TC0Hhi_BIT8                              EQU        TC0Hhi_TC8
mTC0Hhi_BIT8                             EQU        mTC0Hhi_TC8
TC0Hhi_BIT9                              EQU        TC0Hhi_TC9
mTC0Hhi_BIT9                             EQU        mTC0Hhi_TC9
TC0Hhi_BIT10                             EQU        TC0Hhi_TC10
mTC0Hhi_BIT10                            EQU        mTC0Hhi_TC10
TC0Hhi_BIT11                             EQU        TC0Hhi_TC11
mTC0Hhi_BIT11                            EQU        mTC0Hhi_TC11
TC0Hhi_BIT12                             EQU        TC0Hhi_TC12
mTC0Hhi_BIT12                            EQU        mTC0Hhi_TC12
TC0Hhi_BIT13                             EQU        TC0Hhi_TC13
mTC0Hhi_BIT13                            EQU        mTC0Hhi_TC13
TC0Hhi_BIT14                             EQU        TC0Hhi_TC14
mTC0Hhi_BIT14                            EQU        mTC0Hhi_TC14
TC0Hhi_BIT15                             EQU        TC0Hhi_TC15
mTC0Hhi_BIT15                            EQU        mTC0Hhi_TC15
TC0Hlo_BIT0                              EQU        TC0Hlo_TC0
mTC0Hlo_BIT0                             EQU        mTC0Hlo_TC0
TC0Hlo_BIT1                              EQU        TC0Hlo_TC1
mTC0Hlo_BIT1                             EQU        mTC0Hlo_TC1
TC0Hlo_BIT2                              EQU        TC0Hlo_TC2
mTC0Hlo_BIT2                             EQU        mTC0Hlo_TC2
TC0Hlo_BIT3                              EQU        TC0Hlo_TC3
mTC0Hlo_BIT3                             EQU        mTC0Hlo_TC3
TC0Hlo_BIT4                              EQU        TC0Hlo_TC4
mTC0Hlo_BIT4                             EQU        mTC0Hlo_TC4
TC0Hlo_BIT5                              EQU        TC0Hlo_TC5
mTC0Hlo_BIT5                             EQU        mTC0Hlo_TC5
TC0Hlo_BIT6                              EQU        TC0Hlo_TC6
mTC0Hlo_BIT6                             EQU        mTC0Hlo_TC6
TC0Hlo_BIT7                              EQU        TC0Hlo_TC7
mTC0Hlo_BIT7                             EQU        mTC0Hlo_TC7
TC1H_BIT0                                EQU        TC1H_TC0
mTC1H_BIT0                               EQU        mTC1H_TC0
TC1H_BIT1                                EQU        TC1H_TC1
mTC1H_BIT1                               EQU        mTC1H_TC1
TC1H_BIT2                                EQU        TC1H_TC2
mTC1H_BIT2                               EQU        mTC1H_TC2
TC1H_BIT3                                EQU        TC1H_TC3
mTC1H_BIT3                               EQU        mTC1H_TC3
TC1H_BIT4                                EQU        TC1H_TC4
mTC1H_BIT4                               EQU        mTC1H_TC4
TC1H_BIT5                                EQU        TC1H_TC5
mTC1H_BIT5                               EQU        mTC1H_TC5
TC1H_BIT6                                EQU        TC1H_TC6
mTC1H_BIT6                               EQU        mTC1H_TC6
TC1H_BIT7                                EQU        TC1H_TC7
mTC1H_BIT7                               EQU        mTC1H_TC7
TC1H_BIT8                                EQU        TC1H_TC8
mTC1H_BIT8                               EQU        mTC1H_TC8
TC1H_BIT9                                EQU        TC1H_TC9
mTC1H_BIT9                               EQU        mTC1H_TC9
TC1H_BIT10                               EQU        TC1H_TC10
mTC1H_BIT10                              EQU        mTC1H_TC10
TC1H_BIT11                               EQU        TC1H_TC11
mTC1H_BIT11                              EQU        mTC1H_TC11
TC1H_BIT12                               EQU        TC1H_TC12
mTC1H_BIT12                              EQU        mTC1H_TC12
TC1H_BIT13                               EQU        TC1H_TC13
mTC1H_BIT13                              EQU        mTC1H_TC13
TC1H_BIT14                               EQU        TC1H_TC14
mTC1H_BIT14                              EQU        mTC1H_TC14
TC1H_BIT15                               EQU        TC1H_TC15
mTC1H_BIT15                              EQU        mTC1H_TC15
TC1Hhi_BIT8                              EQU        TC1Hhi_TC8
mTC1Hhi_BIT8                             EQU        mTC1Hhi_TC8
TC1Hhi_BIT9                              EQU        TC1Hhi_TC9
mTC1Hhi_BIT9                             EQU        mTC1Hhi_TC9
TC1Hhi_BIT10                             EQU        TC1Hhi_TC10
mTC1Hhi_BIT10                            EQU        mTC1Hhi_TC10
TC1Hhi_BIT11                             EQU        TC1Hhi_TC11
mTC1Hhi_BIT11                            EQU        mTC1Hhi_TC11
TC1Hhi_BIT12                             EQU        TC1Hhi_TC12
mTC1Hhi_BIT12                            EQU        mTC1Hhi_TC12
TC1Hhi_BIT13                             EQU        TC1Hhi_TC13
mTC1Hhi_BIT13                            EQU        mTC1Hhi_TC13
TC1Hhi_BIT14                             EQU        TC1Hhi_TC14
mTC1Hhi_BIT14                            EQU        mTC1Hhi_TC14
TC1Hhi_BIT15                             EQU        TC1Hhi_TC15
mTC1Hhi_BIT15                            EQU        mTC1Hhi_TC15
TC1Hlo_BIT0                              EQU        TC1Hlo_TC0
mTC1Hlo_BIT0                             EQU        mTC1Hlo_TC0
TC1Hlo_BIT1                              EQU        TC1Hlo_TC1
mTC1Hlo_BIT1                             EQU        mTC1Hlo_TC1
TC1Hlo_BIT2                              EQU        TC1Hlo_TC2
mTC1Hlo_BIT2                             EQU        mTC1Hlo_TC2
TC1Hlo_BIT3                              EQU        TC1Hlo_TC3
mTC1Hlo_BIT3                             EQU        mTC1Hlo_TC3
TC1Hlo_BIT4                              EQU        TC1Hlo_TC4
mTC1Hlo_BIT4                             EQU        mTC1Hlo_TC4
TC1Hlo_BIT5                              EQU        TC1Hlo_TC5
mTC1Hlo_BIT5                             EQU        mTC1Hlo_TC5
TC1Hlo_BIT6                              EQU        TC1Hlo_TC6
mTC1Hlo_BIT6                             EQU        mTC1Hlo_TC6
TC1Hlo_BIT7                              EQU        TC1Hlo_TC7
mTC1Hlo_BIT7                             EQU        mTC1Hlo_TC7
TC2H_BIT0                                EQU        TC2H_TC0
mTC2H_BIT0                               EQU        mTC2H_TC0
TC2H_BIT1                                EQU        TC2H_TC1
mTC2H_BIT1                               EQU        mTC2H_TC1
TC2H_BIT2                                EQU        TC2H_TC2
mTC2H_BIT2                               EQU        mTC2H_TC2
TC2H_BIT3                                EQU        TC2H_TC3
mTC2H_BIT3                               EQU        mTC2H_TC3
TC2H_BIT4                                EQU        TC2H_TC4
mTC2H_BIT4                               EQU        mTC2H_TC4
TC2H_BIT5                                EQU        TC2H_TC5
mTC2H_BIT5                               EQU        mTC2H_TC5
TC2H_BIT6                                EQU        TC2H_TC6
mTC2H_BIT6                               EQU        mTC2H_TC6
TC2H_BIT7                                EQU        TC2H_TC7
mTC2H_BIT7                               EQU        mTC2H_TC7
TC2H_BIT8                                EQU        TC2H_TC8
mTC2H_BIT8                               EQU        mTC2H_TC8
TC2H_BIT9                                EQU        TC2H_TC9
mTC2H_BIT9                               EQU        mTC2H_TC9
TC2H_BIT10                               EQU        TC2H_TC10
mTC2H_BIT10                              EQU        mTC2H_TC10
TC2H_BIT11                               EQU        TC2H_TC11
mTC2H_BIT11                              EQU        mTC2H_TC11
TC2H_BIT12                               EQU        TC2H_TC12
mTC2H_BIT12                              EQU        mTC2H_TC12
TC2H_BIT13                               EQU        TC2H_TC13
mTC2H_BIT13                              EQU        mTC2H_TC13
TC2H_BIT14                               EQU        TC2H_TC14
mTC2H_BIT14                              EQU        mTC2H_TC14
TC2H_BIT15                               EQU        TC2H_TC15
mTC2H_BIT15                              EQU        mTC2H_TC15
TC2Hhi_BIT8                              EQU        TC2Hhi_TC8
mTC2Hhi_BIT8                             EQU        mTC2Hhi_TC8
TC2Hhi_BIT9                              EQU        TC2Hhi_TC9
mTC2Hhi_BIT9                             EQU        mTC2Hhi_TC9
TC2Hhi_BIT10                             EQU        TC2Hhi_TC10
mTC2Hhi_BIT10                            EQU        mTC2Hhi_TC10
TC2Hhi_BIT11                             EQU        TC2Hhi_TC11
mTC2Hhi_BIT11                            EQU        mTC2Hhi_TC11
TC2Hhi_BIT12                             EQU        TC2Hhi_TC12
mTC2Hhi_BIT12                            EQU        mTC2Hhi_TC12
TC2Hhi_BIT13                             EQU        TC2Hhi_TC13
mTC2Hhi_BIT13                            EQU        mTC2Hhi_TC13
TC2Hhi_BIT14                             EQU        TC2Hhi_TC14
mTC2Hhi_BIT14                            EQU        mTC2Hhi_TC14
TC2Hhi_BIT15                             EQU        TC2Hhi_TC15
mTC2Hhi_BIT15                            EQU        mTC2Hhi_TC15
TC2Hlo_BIT0                              EQU        TC2Hlo_TC0
mTC2Hlo_BIT0                             EQU        mTC2Hlo_TC0
TC2Hlo_BIT1                              EQU        TC2Hlo_TC1
mTC2Hlo_BIT1                             EQU        mTC2Hlo_TC1
TC2Hlo_BIT2                              EQU        TC2Hlo_TC2
mTC2Hlo_BIT2                             EQU        mTC2Hlo_TC2
TC2Hlo_BIT3                              EQU        TC2Hlo_TC3
mTC2Hlo_BIT3                             EQU        mTC2Hlo_TC3
TC2Hlo_BIT4                              EQU        TC2Hlo_TC4
mTC2Hlo_BIT4                             EQU        mTC2Hlo_TC4
TC2Hlo_BIT5                              EQU        TC2Hlo_TC5
mTC2Hlo_BIT5                             EQU        mTC2Hlo_TC5
TC2Hlo_BIT6                              EQU        TC2Hlo_TC6
mTC2Hlo_BIT6                             EQU        mTC2Hlo_TC6
TC2Hlo_BIT7                              EQU        TC2Hlo_TC7
mTC2Hlo_BIT7                             EQU        mTC2Hlo_TC7
TC3H_BIT0                                EQU        TC3H_TC0
mTC3H_BIT0                               EQU        mTC3H_TC0
TC3H_BIT1                                EQU        TC3H_TC1
mTC3H_BIT1                               EQU        mTC3H_TC1
TC3H_BIT2                                EQU        TC3H_TC2
mTC3H_BIT2                               EQU        mTC3H_TC2
TC3H_BIT3                                EQU        TC3H_TC3
mTC3H_BIT3                               EQU        mTC3H_TC3
TC3H_BIT4                                EQU        TC3H_TC4
mTC3H_BIT4                               EQU        mTC3H_TC4
TC3H_BIT5                                EQU        TC3H_TC5
mTC3H_BIT5                               EQU        mTC3H_TC5
TC3H_BIT6                                EQU        TC3H_TC6
mTC3H_BIT6                               EQU        mTC3H_TC6
TC3H_BIT7                                EQU        TC3H_TC7
mTC3H_BIT7                               EQU        mTC3H_TC7
TC3H_BIT8                                EQU        TC3H_TC8
mTC3H_BIT8                               EQU        mTC3H_TC8
TC3H_BIT9                                EQU        TC3H_TC9
mTC3H_BIT9                               EQU        mTC3H_TC9
TC3H_BIT10                               EQU        TC3H_TC10
mTC3H_BIT10                              EQU        mTC3H_TC10
TC3H_BIT11                               EQU        TC3H_TC11
mTC3H_BIT11                              EQU        mTC3H_TC11
TC3H_BIT12                               EQU        TC3H_TC12
mTC3H_BIT12                              EQU        mTC3H_TC12
TC3H_BIT13                               EQU        TC3H_TC13
mTC3H_BIT13                              EQU        mTC3H_TC13
TC3H_BIT14                               EQU        TC3H_TC14
mTC3H_BIT14                              EQU        mTC3H_TC14
TC3H_BIT15                               EQU        TC3H_TC15
mTC3H_BIT15                              EQU        mTC3H_TC15
TC3Hhi_BIT8                              EQU        TC3Hhi_TC8
mTC3Hhi_BIT8                             EQU        mTC3Hhi_TC8
TC3Hhi_BIT9                              EQU        TC3Hhi_TC9
mTC3Hhi_BIT9                             EQU        mTC3Hhi_TC9
TC3Hhi_BIT10                             EQU        TC3Hhi_TC10
mTC3Hhi_BIT10                            EQU        mTC3Hhi_TC10
TC3Hhi_BIT11                             EQU        TC3Hhi_TC11
mTC3Hhi_BIT11                            EQU        mTC3Hhi_TC11
TC3Hhi_BIT12                             EQU        TC3Hhi_TC12
mTC3Hhi_BIT12                            EQU        mTC3Hhi_TC12
TC3Hhi_BIT13                             EQU        TC3Hhi_TC13
mTC3Hhi_BIT13                            EQU        mTC3Hhi_TC13
TC3Hhi_BIT14                             EQU        TC3Hhi_TC14
mTC3Hhi_BIT14                            EQU        mTC3Hhi_TC14
TC3Hhi_BIT15                             EQU        TC3Hhi_TC15
mTC3Hhi_BIT15                            EQU        mTC3Hhi_TC15
TC3Hlo_BIT0                              EQU        TC3Hlo_TC0
mTC3Hlo_BIT0                             EQU        mTC3Hlo_TC0
TC3Hlo_BIT1                              EQU        TC3Hlo_TC1
mTC3Hlo_BIT1                             EQU        mTC3Hlo_TC1
TC3Hlo_BIT2                              EQU        TC3Hlo_TC2
mTC3Hlo_BIT2                             EQU        mTC3Hlo_TC2
TC3Hlo_BIT3                              EQU        TC3Hlo_TC3
mTC3Hlo_BIT3                             EQU        mTC3Hlo_TC3
TC3Hlo_BIT4                              EQU        TC3Hlo_TC4
mTC3Hlo_BIT4                             EQU        mTC3Hlo_TC4
TC3Hlo_BIT5                              EQU        TC3Hlo_TC5
mTC3Hlo_BIT5                             EQU        mTC3Hlo_TC5
TC3Hlo_BIT6                              EQU        TC3Hlo_TC6
mTC3Hlo_BIT6                             EQU        mTC3Hlo_TC6
TC3Hlo_BIT7                              EQU        TC3Hlo_TC7
mTC3Hlo_BIT7                             EQU        mTC3Hlo_TC7

        ENDIF

; **** 16.10.2007 12:24:23

Reserved119:                             equ        VReserved118
Reserved118:                             equ        VReserved117
Reserved117:                             equ        VReserved116
Reserved116:                             equ        VReserved115
Reserved115:                             equ        VReserved114
Reserved114:                             equ        VReserved113
Reserved113:                             equ        VReserved112
Reserved112:                             equ        VReserved111
Reserved111:                             equ        VReserved110
Reserved110:                             equ        VReserved109
Reserved109:                             equ        VReserved108
Reserved108:                             equ        VReserved107
Reserved107:                             equ        VReserved106
Reserved106:                             equ        VReserved105
Reserved105:                             equ        VReserved104
Reserved104:                             equ        VReserved103
Reserved103:                             equ        VReserved102
Reserved102:                             equ        VReserved101
Reserved101:                             equ        VReserved100
Reserved100:                             equ        VReserved99 
Reserved99:                              equ        VReserved98 
Reserved98:                              equ        VReserved97 
Reserved97:                              equ        VReserved96 
Reserved96:                              equ        VReserved95 
Reserved95:                              equ        VReserved94 
Reserved94:                              equ        VReserved93 
Reserved93:                              equ        VReserved92 
Reserved92:                              equ        VReserved91 
Reserved91:                              equ        VReserved90 
Reserved90:                              equ        VReserved89 
Reserved89:                              equ        VReserved88 
Reserved88:                              equ        VReserved87 
Reserved87:                              equ        VReserved86 
Reserved86:                              equ        VReserved85 
Reserved85:                              equ        VReserved84 
Reserved84:                              equ        VReserved83 
Reserved83:                              equ        VReserved82 
Reserved82:                              equ        VReserved81 
Reserved81:                              equ        VReserved80 
Reserved58:                              equ        VReserved61 
Reserved59:                              equ        VReserved60 
Reserved60:                              equ        VReserved59 
Reserved61:                              equ        VReserved58 
Reserved63:                              equ        VReserved56 
Reserved64:                              equ        VReserved55 
Reserved65:                              equ        VReserved54 
Reserved66:                              equ        VReserved53 
Reserved74:                              equ        VReserved45 
Reserved75:                              equ        VReserved44 
Reserved120:                             equ        VReserved33 
Reserved121:                             equ        VReserved32 
Reserved122:                             equ        VReserved25 
Reserved123:                             equ        VReserved23 
ATDDIEN01:                               equ        ATDDIEN
ATDDIEN01_IEN0:                          equ        ATDDIEN_IEN0
ATDDIEN01_IEN1:                          equ        ATDDIEN_IEN1
ATDDIEN01_IEN2:                          equ        ATDDIEN_IEN2
ATDDIEN01_IEN3:                          equ        ATDDIEN_IEN3
ATDDIEN01_IEN4:                          equ        ATDDIEN_IEN4
ATDDIEN01_IEN5:                          equ        ATDDIEN_IEN5
ATDDIEN01_IEN6:                          equ        ATDDIEN_IEN6
ATDDIEN01_IEN7:                          equ        ATDDIEN_IEN7
ATDDIEN01_IEN8:                          equ        ATDDIEN_IEN8
ATDDIEN01_IEN9:                          equ        ATDDIEN_IEN9
ATDDIEN01_IEN10:                         equ        ATDDIEN_IEN10
ATDDIEN01_IEN11:                         equ        ATDDIEN_IEN11
ATDDIEN01_IEN12:                         equ        ATDDIEN_IEN12
ATDDIEN01_IEN13:                         equ        ATDDIEN_IEN13
ATDDIEN01_IEN14:                         equ        ATDDIEN_IEN14
ATDDIEN01_IEN15:                         equ        ATDDIEN_IEN15
mATDDIEN01_IEN0:                         equ        mATDDIEN_IEN0
mATDDIEN01_IEN1:                         equ        mATDDIEN_IEN1
mATDDIEN01_IEN2:                         equ        mATDDIEN_IEN2
mATDDIEN01_IEN3:                         equ        mATDDIEN_IEN3
mATDDIEN01_IEN4:                         equ        mATDDIEN_IEN4
mATDDIEN01_IEN5:                         equ        mATDDIEN_IEN5
mATDDIEN01_IEN6:                         equ        mATDDIEN_IEN6
mATDDIEN01_IEN7:                         equ        mATDDIEN_IEN7
mATDDIEN01_IEN8:                         equ        mATDDIEN_IEN8
mATDDIEN01_IEN9:                         equ        mATDDIEN_IEN9
mATDDIEN01_IEN10:                        equ        mATDDIEN_IEN10
mATDDIEN01_IEN11:                        equ        mATDDIEN_IEN11
mATDDIEN01_IEN12:                        equ        mATDDIEN_IEN12
mATDDIEN01_IEN13:                        equ        mATDDIEN_IEN13
mATDDIEN01_IEN14:                        equ        mATDDIEN_IEN14
mATDDIEN01_IEN15:                        equ        mATDDIEN_IEN15
CAN0RIDR0:                               equ        CAN0RXIDR0
CAN0RIDR0_ID21:                          equ        CAN0RXIDR0_ID21
CAN0RIDR0_ID22:                          equ        CAN0RXIDR0_ID22
CAN0RIDR0_ID23:                          equ        CAN0RXIDR0_ID23
CAN0RIDR0_ID24:                          equ        CAN0RXIDR0_ID24
CAN0RIDR0_ID25:                          equ        CAN0RXIDR0_ID25
CAN0RIDR0_ID26:                          equ        CAN0RXIDR0_ID26
CAN0RIDR0_ID27:                          equ        CAN0RXIDR0_ID27
CAN0RIDR0_ID28:                          equ        CAN0RXIDR0_ID28
mCAN0RIDR0_ID21:                         equ        mCAN0RXIDR0_ID21
mCAN0RIDR0_ID22:                         equ        mCAN0RXIDR0_ID22
mCAN0RIDR0_ID23:                         equ        mCAN0RXIDR0_ID23
mCAN0RIDR0_ID24:                         equ        mCAN0RXIDR0_ID24
mCAN0RIDR0_ID25:                         equ        mCAN0RXIDR0_ID25
mCAN0RIDR0_ID26:                         equ        mCAN0RXIDR0_ID26
mCAN0RIDR0_ID27:                         equ        mCAN0RXIDR0_ID27
mCAN0RIDR0_ID28:                         equ        mCAN0RXIDR0_ID28
CAN0RIDR1:                               equ        CAN0RXIDR1
CAN0RIDR1_ID15:                          equ        CAN0RXIDR1_ID15
CAN0RIDR1_ID16:                          equ        CAN0RXIDR1_ID16
CAN0RIDR1_ID17:                          equ        CAN0RXIDR1_ID17
CAN0RIDR1_IDE:                           equ        CAN0RXIDR1_IDE
CAN0RIDR1_SRR:                           equ        CAN0RXIDR1_SRR
CAN0RIDR1_ID18:                          equ        CAN0RXIDR1_ID18
CAN0RIDR1_ID19:                          equ        CAN0RXIDR1_ID19
CAN0RIDR1_ID20:                          equ        CAN0RXIDR1_ID20
mCAN0RIDR1_ID15:                         equ        mCAN0RXIDR1_ID15
mCAN0RIDR1_ID16:                         equ        mCAN0RXIDR1_ID16
mCAN0RIDR1_ID17:                         equ        mCAN0RXIDR1_ID17
mCAN0RIDR1_IDE:                          equ        mCAN0RXIDR1_IDE
mCAN0RIDR1_SRR:                          equ        mCAN0RXIDR1_SRR
mCAN0RIDR1_ID18:                         equ        mCAN0RXIDR1_ID18
mCAN0RIDR1_ID19:                         equ        mCAN0RXIDR1_ID19
mCAN0RIDR1_ID20:                         equ        mCAN0RXIDR1_ID20
CAN0RIDR2:                               equ        CAN0RXIDR2
CAN0RIDR2_ID7:                           equ        CAN0RXIDR2_ID7
CAN0RIDR2_ID8:                           equ        CAN0RXIDR2_ID8
CAN0RIDR2_ID9:                           equ        CAN0RXIDR2_ID9
CAN0RIDR2_ID10:                          equ        CAN0RXIDR2_ID10
CAN0RIDR2_ID11:                          equ        CAN0RXIDR2_ID11
CAN0RIDR2_ID12:                          equ        CAN0RXIDR2_ID12
CAN0RIDR2_ID13:                          equ        CAN0RXIDR2_ID13
CAN0RIDR2_ID14:                          equ        CAN0RXIDR2_ID14
mCAN0RIDR2_ID7:                          equ        mCAN0RXIDR2_ID7
mCAN0RIDR2_ID8:                          equ        mCAN0RXIDR2_ID8
mCAN0RIDR2_ID9:                          equ        mCAN0RXIDR2_ID9
mCAN0RIDR2_ID10:                         equ        mCAN0RXIDR2_ID10
mCAN0RIDR2_ID11:                         equ        mCAN0RXIDR2_ID11
mCAN0RIDR2_ID12:                         equ        mCAN0RXIDR2_ID12
mCAN0RIDR2_ID13:                         equ        mCAN0RXIDR2_ID13
mCAN0RIDR2_ID14:                         equ        mCAN0RXIDR2_ID14
CAN0RIDR3:                               equ        CAN0RXIDR3
CAN0RIDR3_RTR:                           equ        CAN0RXIDR3_RTR
CAN0RIDR3_ID0:                           equ        CAN0RXIDR3_ID0
CAN0RIDR3_ID1:                           equ        CAN0RXIDR3_ID1
CAN0RIDR3_ID2:                           equ        CAN0RXIDR3_ID2
CAN0RIDR3_ID3:                           equ        CAN0RXIDR3_ID3
CAN0RIDR3_ID4:                           equ        CAN0RXIDR3_ID4
CAN0RIDR3_ID5:                           equ        CAN0RXIDR3_ID5
CAN0RIDR3_ID6:                           equ        CAN0RXIDR3_ID6
mCAN0RIDR3_RTR:                          equ        mCAN0RXIDR3_RTR
mCAN0RIDR3_ID0:                          equ        mCAN0RXIDR3_ID0
mCAN0RIDR3_ID1:                          equ        mCAN0RXIDR3_ID1
mCAN0RIDR3_ID2:                          equ        mCAN0RXIDR3_ID2
mCAN0RIDR3_ID3:                          equ        mCAN0RXIDR3_ID3
mCAN0RIDR3_ID4:                          equ        mCAN0RXIDR3_ID4
mCAN0RIDR3_ID5:                          equ        mCAN0RXIDR3_ID5
mCAN0RIDR3_ID6:                          equ        mCAN0RXIDR3_ID6
CAN0RDSR0:                               equ        CAN0RXDSR0
CAN0RDSR0_DB0:                           equ        CAN0RXDSR0_DB0
CAN0RDSR0_DB1:                           equ        CAN0RXDSR0_DB1
CAN0RDSR0_DB2:                           equ        CAN0RXDSR0_DB2
CAN0RDSR0_DB3:                           equ        CAN0RXDSR0_DB3
CAN0RDSR0_DB4:                           equ        CAN0RXDSR0_DB4
CAN0RDSR0_DB5:                           equ        CAN0RXDSR0_DB5
CAN0RDSR0_DB6:                           equ        CAN0RXDSR0_DB6
CAN0RDSR0_DB7:                           equ        CAN0RXDSR0_DB7
mCAN0RDSR0_DB0:                          equ        mCAN0RXDSR0_DB0
mCAN0RDSR0_DB1:                          equ        mCAN0RXDSR0_DB1
mCAN0RDSR0_DB2:                          equ        mCAN0RXDSR0_DB2
mCAN0RDSR0_DB3:                          equ        mCAN0RXDSR0_DB3
mCAN0RDSR0_DB4:                          equ        mCAN0RXDSR0_DB4
mCAN0RDSR0_DB5:                          equ        mCAN0RXDSR0_DB5
mCAN0RDSR0_DB6:                          equ        mCAN0RXDSR0_DB6
mCAN0RDSR0_DB7:                          equ        mCAN0RXDSR0_DB7
CAN0RDSR1:                               equ        CAN0RXDSR1
CAN0RDSR1_DB0:                           equ        CAN0RXDSR1_DB0
CAN0RDSR1_DB1:                           equ        CAN0RXDSR1_DB1
CAN0RDSR1_DB2:                           equ        CAN0RXDSR1_DB2
CAN0RDSR1_DB3:                           equ        CAN0RXDSR1_DB3
CAN0RDSR1_DB4:                           equ        CAN0RXDSR1_DB4
CAN0RDSR1_DB5:                           equ        CAN0RXDSR1_DB5
CAN0RDSR1_DB6:                           equ        CAN0RXDSR1_DB6
CAN0RDSR1_DB7:                           equ        CAN0RXDSR1_DB7
mCAN0RDSR1_DB0:                          equ        mCAN0RXDSR1_DB0
mCAN0RDSR1_DB1:                          equ        mCAN0RXDSR1_DB1
mCAN0RDSR1_DB2:                          equ        mCAN0RXDSR1_DB2
mCAN0RDSR1_DB3:                          equ        mCAN0RXDSR1_DB3
mCAN0RDSR1_DB4:                          equ        mCAN0RXDSR1_DB4
mCAN0RDSR1_DB5:                          equ        mCAN0RXDSR1_DB5
mCAN0RDSR1_DB6:                          equ        mCAN0RXDSR1_DB6
mCAN0RDSR1_DB7:                          equ        mCAN0RXDSR1_DB7
CAN0RDSR2:                               equ        CAN0RXDSR2
CAN0RDSR2_DB0:                           equ        CAN0RXDSR2_DB0
CAN0RDSR2_DB1:                           equ        CAN0RXDSR2_DB1
CAN0RDSR2_DB2:                           equ        CAN0RXDSR2_DB2
CAN0RDSR2_DB3:                           equ        CAN0RXDSR2_DB3
CAN0RDSR2_DB4:                           equ        CAN0RXDSR2_DB4
CAN0RDSR2_DB5:                           equ        CAN0RXDSR2_DB5
CAN0RDSR2_DB6:                           equ        CAN0RXDSR2_DB6
CAN0RDSR2_DB7:                           equ        CAN0RXDSR2_DB7
mCAN0RDSR2_DB0:                          equ        mCAN0RXDSR2_DB0
mCAN0RDSR2_DB1:                          equ        mCAN0RXDSR2_DB1
mCAN0RDSR2_DB2:                          equ        mCAN0RXDSR2_DB2
mCAN0RDSR2_DB3:                          equ        mCAN0RXDSR2_DB3
mCAN0RDSR2_DB4:                          equ        mCAN0RXDSR2_DB4
mCAN0RDSR2_DB5:                          equ        mCAN0RXDSR2_DB5
mCAN0RDSR2_DB6:                          equ        mCAN0RXDSR2_DB6
mCAN0RDSR2_DB7:                          equ        mCAN0RXDSR2_DB7
CAN0RDSR3:                               equ        CAN0RXDSR3
CAN0RDSR3_DB0:                           equ        CAN0RXDSR3_DB0
CAN0RDSR3_DB1:                           equ        CAN0RXDSR3_DB1
CAN0RDSR3_DB2:                           equ        CAN0RXDSR3_DB2
CAN0RDSR3_DB3:                           equ        CAN0RXDSR3_DB3
CAN0RDSR3_DB4:                           equ        CAN0RXDSR3_DB4
CAN0RDSR3_DB5:                           equ        CAN0RXDSR3_DB5
CAN0RDSR3_DB6:                           equ        CAN0RXDSR3_DB6
CAN0RDSR3_DB7:                           equ        CAN0RXDSR3_DB7
mCAN0RDSR3_DB0:                          equ        mCAN0RXDSR3_DB0
mCAN0RDSR3_DB1:                          equ        mCAN0RXDSR3_DB1
mCAN0RDSR3_DB2:                          equ        mCAN0RXDSR3_DB2
mCAN0RDSR3_DB3:                          equ        mCAN0RXDSR3_DB3
mCAN0RDSR3_DB4:                          equ        mCAN0RXDSR3_DB4
mCAN0RDSR3_DB5:                          equ        mCAN0RXDSR3_DB5
mCAN0RDSR3_DB6:                          equ        mCAN0RXDSR3_DB6
mCAN0RDSR3_DB7:                          equ        mCAN0RXDSR3_DB7
CAN0RDSR4:                               equ        CAN0RXDSR4
CAN0RDSR4_DB0:                           equ        CAN0RXDSR4_DB0
CAN0RDSR4_DB1:                           equ        CAN0RXDSR4_DB1
CAN0RDSR4_DB2:                           equ        CAN0RXDSR4_DB2
CAN0RDSR4_DB3:                           equ        CAN0RXDSR4_DB3
CAN0RDSR4_DB4:                           equ        CAN0RXDSR4_DB4
CAN0RDSR4_DB5:                           equ        CAN0RXDSR4_DB5
CAN0RDSR4_DB6:                           equ        CAN0RXDSR4_DB6
CAN0RDSR4_DB7:                           equ        CAN0RXDSR4_DB7
mCAN0RDSR4_DB0:                          equ        mCAN0RXDSR4_DB0
mCAN0RDSR4_DB1:                          equ        mCAN0RXDSR4_DB1
mCAN0RDSR4_DB2:                          equ        mCAN0RXDSR4_DB2
mCAN0RDSR4_DB3:                          equ        mCAN0RXDSR4_DB3
mCAN0RDSR4_DB4:                          equ        mCAN0RXDSR4_DB4
mCAN0RDSR4_DB5:                          equ        mCAN0RXDSR4_DB5
mCAN0RDSR4_DB6:                          equ        mCAN0RXDSR4_DB6
mCAN0RDSR4_DB7:                          equ        mCAN0RXDSR4_DB7
CAN0RDSR5:                               equ        CAN0RXDSR5
CAN0RDSR5_DB0:                           equ        CAN0RXDSR5_DB0
CAN0RDSR5_DB1:                           equ        CAN0RXDSR5_DB1
CAN0RDSR5_DB2:                           equ        CAN0RXDSR5_DB2
CAN0RDSR5_DB3:                           equ        CAN0RXDSR5_DB3
CAN0RDSR5_DB4:                           equ        CAN0RXDSR5_DB4
CAN0RDSR5_DB5:                           equ        CAN0RXDSR5_DB5
CAN0RDSR5_DB6:                           equ        CAN0RXDSR5_DB6
CAN0RDSR5_DB7:                           equ        CAN0RXDSR5_DB7
mCAN0RDSR5_DB0:                          equ        mCAN0RXDSR5_DB0
mCAN0RDSR5_DB1:                          equ        mCAN0RXDSR5_DB1
mCAN0RDSR5_DB2:                          equ        mCAN0RXDSR5_DB2
mCAN0RDSR5_DB3:                          equ        mCAN0RXDSR5_DB3
mCAN0RDSR5_DB4:                          equ        mCAN0RXDSR5_DB4
mCAN0RDSR5_DB5:                          equ        mCAN0RXDSR5_DB5
mCAN0RDSR5_DB6:                          equ        mCAN0RXDSR5_DB6
mCAN0RDSR5_DB7:                          equ        mCAN0RXDSR5_DB7
CAN0RDSR6:                               equ        CAN0RXDSR6
CAN0RDSR6_DB0:                           equ        CAN0RXDSR6_DB0
CAN0RDSR6_DB1:                           equ        CAN0RXDSR6_DB1
CAN0RDSR6_DB2:                           equ        CAN0RXDSR6_DB2
CAN0RDSR6_DB3:                           equ        CAN0RXDSR6_DB3
CAN0RDSR6_DB4:                           equ        CAN0RXDSR6_DB4
CAN0RDSR6_DB5:                           equ        CAN0RXDSR6_DB5
CAN0RDSR6_DB6:                           equ        CAN0RXDSR6_DB6
CAN0RDSR6_DB7:                           equ        CAN0RXDSR6_DB7
mCAN0RDSR6_DB0:                          equ        mCAN0RXDSR6_DB0
mCAN0RDSR6_DB1:                          equ        mCAN0RXDSR6_DB1
mCAN0RDSR6_DB2:                          equ        mCAN0RXDSR6_DB2
mCAN0RDSR6_DB3:                          equ        mCAN0RXDSR6_DB3
mCAN0RDSR6_DB4:                          equ        mCAN0RXDSR6_DB4
mCAN0RDSR6_DB5:                          equ        mCAN0RXDSR6_DB5
mCAN0RDSR6_DB6:                          equ        mCAN0RXDSR6_DB6
mCAN0RDSR6_DB7:                          equ        mCAN0RXDSR6_DB7
CAN0RDSR7:                               equ        CAN0RXDSR7
CAN0RDSR7_DB0:                           equ        CAN0RXDSR7_DB0
CAN0RDSR7_DB1:                           equ        CAN0RXDSR7_DB1
CAN0RDSR7_DB2:                           equ        CAN0RXDSR7_DB2
CAN0RDSR7_DB3:                           equ        CAN0RXDSR7_DB3
CAN0RDSR7_DB4:                           equ        CAN0RXDSR7_DB4
CAN0RDSR7_DB5:                           equ        CAN0RXDSR7_DB5
CAN0RDSR7_DB6:                           equ        CAN0RXDSR7_DB6
CAN0RDSR7_DB7:                           equ        CAN0RXDSR7_DB7
mCAN0RDSR7_DB0:                          equ        mCAN0RXDSR7_DB0
mCAN0RDSR7_DB1:                          equ        mCAN0RXDSR7_DB1
mCAN0RDSR7_DB2:                          equ        mCAN0RXDSR7_DB2
mCAN0RDSR7_DB3:                          equ        mCAN0RXDSR7_DB3
mCAN0RDSR7_DB4:                          equ        mCAN0RXDSR7_DB4
mCAN0RDSR7_DB5:                          equ        mCAN0RXDSR7_DB5
mCAN0RDSR7_DB6:                          equ        mCAN0RXDSR7_DB6
mCAN0RDSR7_DB7:                          equ        mCAN0RXDSR7_DB7
CAN0RDLR:                                equ        CAN0RXDLR
CAN0RDLR_DLC0:                           equ        CAN0RXDLR_DLC0
CAN0RDLR_DLC1:                           equ        CAN0RXDLR_DLC1
CAN0RDLR_DLC2:                           equ        CAN0RXDLR_DLC2
CAN0RDLR_DLC3:                           equ        CAN0RXDLR_DLC3
mCAN0RDLR_DLC0:                          equ        mCAN0RXDLR_DLC0
mCAN0RDLR_DLC1:                          equ        mCAN0RXDLR_DLC1
mCAN0RDLR_DLC2:                          equ        mCAN0RXDLR_DLC2
mCAN0RDLR_DLC3:                          equ        mCAN0RXDLR_DLC3
CAN0RTSR:                                equ        CAN0RXTSR
CAN0RTSR_TSR0:                           equ        CAN0RXTSR_TSR0
CAN0RTSR_TSR1:                           equ        CAN0RXTSR_TSR1
CAN0RTSR_TSR2:                           equ        CAN0RXTSR_TSR2
CAN0RTSR_TSR3:                           equ        CAN0RXTSR_TSR3
CAN0RTSR_TSR4:                           equ        CAN0RXTSR_TSR4
CAN0RTSR_TSR5:                           equ        CAN0RXTSR_TSR5
CAN0RTSR_TSR6:                           equ        CAN0RXTSR_TSR6
CAN0RTSR_TSR7:                           equ        CAN0RXTSR_TSR7
CAN0RTSR_TSR8:                           equ        CAN0RXTSR_TSR8
CAN0RTSR_TSR9:                           equ        CAN0RXTSR_TSR9
CAN0RTSR_TSR10:                          equ        CAN0RXTSR_TSR10
CAN0RTSR_TSR11:                          equ        CAN0RXTSR_TSR11
CAN0RTSR_TSR12:                          equ        CAN0RXTSR_TSR12
CAN0RTSR_TSR13:                          equ        CAN0RXTSR_TSR13
CAN0RTSR_TSR14:                          equ        CAN0RXTSR_TSR14
CAN0RTSR_TSR15:                          equ        CAN0RXTSR_TSR15
mCAN0RTSR_TSR0:                          equ        mCAN0RXTSR_TSR0
mCAN0RTSR_TSR1:                          equ        mCAN0RXTSR_TSR1
mCAN0RTSR_TSR2:                          equ        mCAN0RXTSR_TSR2
mCAN0RTSR_TSR3:                          equ        mCAN0RXTSR_TSR3
mCAN0RTSR_TSR4:                          equ        mCAN0RXTSR_TSR4
mCAN0RTSR_TSR5:                          equ        mCAN0RXTSR_TSR5
mCAN0RTSR_TSR6:                          equ        mCAN0RXTSR_TSR6
mCAN0RTSR_TSR7:                          equ        mCAN0RXTSR_TSR7
mCAN0RTSR_TSR8:                          equ        mCAN0RXTSR_TSR8
mCAN0RTSR_TSR9:                          equ        mCAN0RXTSR_TSR9
mCAN0RTSR_TSR10:                         equ        mCAN0RXTSR_TSR10
mCAN0RTSR_TSR11:                         equ        mCAN0RXTSR_TSR11
mCAN0RTSR_TSR12:                         equ        mCAN0RXTSR_TSR12
mCAN0RTSR_TSR13:                         equ        mCAN0RXTSR_TSR13
mCAN0RTSR_TSR14:                         equ        mCAN0RXTSR_TSR14
mCAN0RTSR_TSR15:                         equ        mCAN0RXTSR_TSR15
CAN0RTSRH:                               equ        CAN0RXTSRH
CAN0RTSRH_TSR8:                          equ        CAN0RXTSRH_TSR8
CAN0RTSRH_TSR9:                          equ        CAN0RXTSRH_TSR9
CAN0RTSRH_TSR10:                         equ        CAN0RXTSRH_TSR10
CAN0RTSRH_TSR11:                         equ        CAN0RXTSRH_TSR11
CAN0RTSRH_TSR12:                         equ        CAN0RXTSRH_TSR12
CAN0RTSRH_TSR13:                         equ        CAN0RXTSRH_TSR13
CAN0RTSRH_TSR14:                         equ        CAN0RXTSRH_TSR14
CAN0RTSRH_TSR15:                         equ        CAN0RXTSRH_TSR15
mCAN0RTSRH_TSR8:                         equ        mCAN0RXTSRH_TSR8
mCAN0RTSRH_TSR9:                         equ        mCAN0RXTSRH_TSR9
mCAN0RTSRH_TSR10:                        equ        mCAN0RXTSRH_TSR10
mCAN0RTSRH_TSR11:                        equ        mCAN0RXTSRH_TSR11
mCAN0RTSRH_TSR12:                        equ        mCAN0RXTSRH_TSR12
mCAN0RTSRH_TSR13:                        equ        mCAN0RXTSRH_TSR13
mCAN0RTSRH_TSR14:                        equ        mCAN0RXTSRH_TSR14
mCAN0RTSRH_TSR15:                        equ        mCAN0RXTSRH_TSR15
CAN0RTSRL:                               equ        CAN0RXTSRL
CAN0RTSRL_TSR0:                          equ        CAN0RXTSRL_TSR0
CAN0RTSRL_TSR1:                          equ        CAN0RXTSRL_TSR1
CAN0RTSRL_TSR2:                          equ        CAN0RXTSRL_TSR2
CAN0RTSRL_TSR3:                          equ        CAN0RXTSRL_TSR3
CAN0RTSRL_TSR4:                          equ        CAN0RXTSRL_TSR4
CAN0RTSRL_TSR5:                          equ        CAN0RXTSRL_TSR5
CAN0RTSRL_TSR6:                          equ        CAN0RXTSRL_TSR6
CAN0RTSRL_TSR7:                          equ        CAN0RXTSRL_TSR7
mCAN0RTSRL_TSR0:                         equ        mCAN0RXTSRL_TSR0
mCAN0RTSRL_TSR1:                         equ        mCAN0RXTSRL_TSR1
mCAN0RTSRL_TSR2:                         equ        mCAN0RXTSRL_TSR2
mCAN0RTSRL_TSR3:                         equ        mCAN0RXTSRL_TSR3
mCAN0RTSRL_TSR4:                         equ        mCAN0RXTSRL_TSR4
mCAN0RTSRL_TSR5:                         equ        mCAN0RXTSRL_TSR5
mCAN0RTSRL_TSR6:                         equ        mCAN0RXTSRL_TSR6
mCAN0RTSRL_TSR7:                         equ        mCAN0RXTSRL_TSR7
CAN0TIDR0:                               equ        CAN0TXIDR0
CAN0TIDR0_ID21:                          equ        CAN0TXIDR0_ID21
CAN0TIDR0_ID22:                          equ        CAN0TXIDR0_ID22
CAN0TIDR0_ID23:                          equ        CAN0TXIDR0_ID23
CAN0TIDR0_ID24:                          equ        CAN0TXIDR0_ID24
CAN0TIDR0_ID25:                          equ        CAN0TXIDR0_ID25
CAN0TIDR0_ID26:                          equ        CAN0TXIDR0_ID26
CAN0TIDR0_ID27:                          equ        CAN0TXIDR0_ID27
CAN0TIDR0_ID28:                          equ        CAN0TXIDR0_ID28
mCAN0TIDR0_ID21:                         equ        mCAN0TXIDR0_ID21
mCAN0TIDR0_ID22:                         equ        mCAN0TXIDR0_ID22
mCAN0TIDR0_ID23:                         equ        mCAN0TXIDR0_ID23
mCAN0TIDR0_ID24:                         equ        mCAN0TXIDR0_ID24
mCAN0TIDR0_ID25:                         equ        mCAN0TXIDR0_ID25
mCAN0TIDR0_ID26:                         equ        mCAN0TXIDR0_ID26
mCAN0TIDR0_ID27:                         equ        mCAN0TXIDR0_ID27
mCAN0TIDR0_ID28:                         equ        mCAN0TXIDR0_ID28
CAN0TIDR1:                               equ        CAN0TXIDR1
CAN0TIDR1_ID15:                          equ        CAN0TXIDR1_ID15
CAN0TIDR1_ID16:                          equ        CAN0TXIDR1_ID16
CAN0TIDR1_ID17:                          equ        CAN0TXIDR1_ID17
CAN0TIDR1_IDE:                           equ        CAN0TXIDR1_IDE
CAN0TIDR1_SRR:                           equ        CAN0TXIDR1_SRR
CAN0TIDR1_ID18:                          equ        CAN0TXIDR1_ID18
CAN0TIDR1_ID19:                          equ        CAN0TXIDR1_ID19
CAN0TIDR1_ID20:                          equ        CAN0TXIDR1_ID20
mCAN0TIDR1_ID15:                         equ        mCAN0TXIDR1_ID15
mCAN0TIDR1_ID16:                         equ        mCAN0TXIDR1_ID16
mCAN0TIDR1_ID17:                         equ        mCAN0TXIDR1_ID17
mCAN0TIDR1_IDE:                          equ        mCAN0TXIDR1_IDE
mCAN0TIDR1_SRR:                          equ        mCAN0TXIDR1_SRR
mCAN0TIDR1_ID18:                         equ        mCAN0TXIDR1_ID18
mCAN0TIDR1_ID19:                         equ        mCAN0TXIDR1_ID19
mCAN0TIDR1_ID20:                         equ        mCAN0TXIDR1_ID20
CAN0TIDR2:                               equ        CAN0TXIDR2
CAN0TIDR2_ID7:                           equ        CAN0TXIDR2_ID7
CAN0TIDR2_ID8:                           equ        CAN0TXIDR2_ID8
CAN0TIDR2_ID9:                           equ        CAN0TXIDR2_ID9
CAN0TIDR2_ID10:                          equ        CAN0TXIDR2_ID10
CAN0TIDR2_ID11:                          equ        CAN0TXIDR2_ID11
CAN0TIDR2_ID12:                          equ        CAN0TXIDR2_ID12
CAN0TIDR2_ID13:                          equ        CAN0TXIDR2_ID13
CAN0TIDR2_ID14:                          equ        CAN0TXIDR2_ID14
mCAN0TIDR2_ID7:                          equ        mCAN0TXIDR2_ID7
mCAN0TIDR2_ID8:                          equ        mCAN0TXIDR2_ID8
mCAN0TIDR2_ID9:                          equ        mCAN0TXIDR2_ID9
mCAN0TIDR2_ID10:                         equ        mCAN0TXIDR2_ID10
mCAN0TIDR2_ID11:                         equ        mCAN0TXIDR2_ID11
mCAN0TIDR2_ID12:                         equ        mCAN0TXIDR2_ID12
mCAN0TIDR2_ID13:                         equ        mCAN0TXIDR2_ID13
mCAN0TIDR2_ID14:                         equ        mCAN0TXIDR2_ID14
CAN0TIDR3:                               equ        CAN0TXIDR3
CAN0TIDR3_RTR:                           equ        CAN0TXIDR3_RTR
CAN0TIDR3_ID0:                           equ        CAN0TXIDR3_ID0
CAN0TIDR3_ID1:                           equ        CAN0TXIDR3_ID1
CAN0TIDR3_ID2:                           equ        CAN0TXIDR3_ID2
CAN0TIDR3_ID3:                           equ        CAN0TXIDR3_ID3
CAN0TIDR3_ID4:                           equ        CAN0TXIDR3_ID4
CAN0TIDR3_ID5:                           equ        CAN0TXIDR3_ID5
CAN0TIDR3_ID6:                           equ        CAN0TXIDR3_ID6
mCAN0TIDR3_RTR:                          equ        mCAN0TXIDR3_RTR
mCAN0TIDR3_ID0:                          equ        mCAN0TXIDR3_ID0
mCAN0TIDR3_ID1:                          equ        mCAN0TXIDR3_ID1
mCAN0TIDR3_ID2:                          equ        mCAN0TXIDR3_ID2
mCAN0TIDR3_ID3:                          equ        mCAN0TXIDR3_ID3
mCAN0TIDR3_ID4:                          equ        mCAN0TXIDR3_ID4
mCAN0TIDR3_ID5:                          equ        mCAN0TXIDR3_ID5
mCAN0TIDR3_ID6:                          equ        mCAN0TXIDR3_ID6
CAN0TDSR0:                               equ        CAN0TXDSR0
CAN0TDSR0_DB0:                           equ        CAN0TXDSR0_DB0
CAN0TDSR0_DB1:                           equ        CAN0TXDSR0_DB1
CAN0TDSR0_DB2:                           equ        CAN0TXDSR0_DB2
CAN0TDSR0_DB3:                           equ        CAN0TXDSR0_DB3
CAN0TDSR0_DB4:                           equ        CAN0TXDSR0_DB4
CAN0TDSR0_DB5:                           equ        CAN0TXDSR0_DB5
CAN0TDSR0_DB6:                           equ        CAN0TXDSR0_DB6
CAN0TDSR0_DB7:                           equ        CAN0TXDSR0_DB7
mCAN0TDSR0_DB0:                          equ        mCAN0TXDSR0_DB0
mCAN0TDSR0_DB1:                          equ        mCAN0TXDSR0_DB1
mCAN0TDSR0_DB2:                          equ        mCAN0TXDSR0_DB2
mCAN0TDSR0_DB3:                          equ        mCAN0TXDSR0_DB3
mCAN0TDSR0_DB4:                          equ        mCAN0TXDSR0_DB4
mCAN0TDSR0_DB5:                          equ        mCAN0TXDSR0_DB5
mCAN0TDSR0_DB6:                          equ        mCAN0TXDSR0_DB6
mCAN0TDSR0_DB7:                          equ        mCAN0TXDSR0_DB7
CAN0TDSR1:                               equ        CAN0TXDSR1
CAN0TDSR1_DB0:                           equ        CAN0TXDSR1_DB0
CAN0TDSR1_DB1:                           equ        CAN0TXDSR1_DB1
CAN0TDSR1_DB2:                           equ        CAN0TXDSR1_DB2
CAN0TDSR1_DB3:                           equ        CAN0TXDSR1_DB3
CAN0TDSR1_DB4:                           equ        CAN0TXDSR1_DB4
CAN0TDSR1_DB5:                           equ        CAN0TXDSR1_DB5
CAN0TDSR1_DB6:                           equ        CAN0TXDSR1_DB6
CAN0TDSR1_DB7:                           equ        CAN0TXDSR1_DB7
mCAN0TDSR1_DB0:                          equ        mCAN0TXDSR1_DB0
mCAN0TDSR1_DB1:                          equ        mCAN0TXDSR1_DB1
mCAN0TDSR1_DB2:                          equ        mCAN0TXDSR1_DB2
mCAN0TDSR1_DB3:                          equ        mCAN0TXDSR1_DB3
mCAN0TDSR1_DB4:                          equ        mCAN0TXDSR1_DB4
mCAN0TDSR1_DB5:                          equ        mCAN0TXDSR1_DB5
mCAN0TDSR1_DB6:                          equ        mCAN0TXDSR1_DB6
mCAN0TDSR1_DB7:                          equ        mCAN0TXDSR1_DB7
CAN0TDSR2:                               equ        CAN0TXDSR2
CAN0TDSR2_DB0:                           equ        CAN0TXDSR2_DB0
CAN0TDSR2_DB1:                           equ        CAN0TXDSR2_DB1
CAN0TDSR2_DB2:                           equ        CAN0TXDSR2_DB2
CAN0TDSR2_DB3:                           equ        CAN0TXDSR2_DB3
CAN0TDSR2_DB4:                           equ        CAN0TXDSR2_DB4
CAN0TDSR2_DB5:                           equ        CAN0TXDSR2_DB5
CAN0TDSR2_DB6:                           equ        CAN0TXDSR2_DB6
CAN0TDSR2_DB7:                           equ        CAN0TXDSR2_DB7
mCAN0TDSR2_DB0:                          equ        mCAN0TXDSR2_DB0
mCAN0TDSR2_DB1:                          equ        mCAN0TXDSR2_DB1
mCAN0TDSR2_DB2:                          equ        mCAN0TXDSR2_DB2
mCAN0TDSR2_DB3:                          equ        mCAN0TXDSR2_DB3
mCAN0TDSR2_DB4:                          equ        mCAN0TXDSR2_DB4
mCAN0TDSR2_DB5:                          equ        mCAN0TXDSR2_DB5
mCAN0TDSR2_DB6:                          equ        mCAN0TXDSR2_DB6
mCAN0TDSR2_DB7:                          equ        mCAN0TXDSR2_DB7
CAN0TDSR3:                               equ        CAN0TXDSR3
CAN0TDSR3_DB0:                           equ        CAN0TXDSR3_DB0
CAN0TDSR3_DB1:                           equ        CAN0TXDSR3_DB1
CAN0TDSR3_DB2:                           equ        CAN0TXDSR3_DB2
CAN0TDSR3_DB3:                           equ        CAN0TXDSR3_DB3
CAN0TDSR3_DB4:                           equ        CAN0TXDSR3_DB4
CAN0TDSR3_DB5:                           equ        CAN0TXDSR3_DB5
CAN0TDSR3_DB6:                           equ        CAN0TXDSR3_DB6
CAN0TDSR3_DB7:                           equ        CAN0TXDSR3_DB7
mCAN0TDSR3_DB0:                          equ        mCAN0TXDSR3_DB0
mCAN0TDSR3_DB1:                          equ        mCAN0TXDSR3_DB1
mCAN0TDSR3_DB2:                          equ        mCAN0TXDSR3_DB2
mCAN0TDSR3_DB3:                          equ        mCAN0TXDSR3_DB3
mCAN0TDSR3_DB4:                          equ        mCAN0TXDSR3_DB4
mCAN0TDSR3_DB5:                          equ        mCAN0TXDSR3_DB5
mCAN0TDSR3_DB6:                          equ        mCAN0TXDSR3_DB6
mCAN0TDSR3_DB7:                          equ        mCAN0TXDSR3_DB7
CAN0TDSR4:                               equ        CAN0TXDSR4
CAN0TDSR4_DB0:                           equ        CAN0TXDSR4_DB0
CAN0TDSR4_DB1:                           equ        CAN0TXDSR4_DB1
CAN0TDSR4_DB2:                           equ        CAN0TXDSR4_DB2
CAN0TDSR4_DB3:                           equ        CAN0TXDSR4_DB3
CAN0TDSR4_DB4:                           equ        CAN0TXDSR4_DB4
CAN0TDSR4_DB5:                           equ        CAN0TXDSR4_DB5
CAN0TDSR4_DB6:                           equ        CAN0TXDSR4_DB6
CAN0TDSR4_DB7:                           equ        CAN0TXDSR4_DB7
mCAN0TDSR4_DB0:                          equ        mCAN0TXDSR4_DB0
mCAN0TDSR4_DB1:                          equ        mCAN0TXDSR4_DB1
mCAN0TDSR4_DB2:                          equ        mCAN0TXDSR4_DB2
mCAN0TDSR4_DB3:                          equ        mCAN0TXDSR4_DB3
mCAN0TDSR4_DB4:                          equ        mCAN0TXDSR4_DB4
mCAN0TDSR4_DB5:                          equ        mCAN0TXDSR4_DB5
mCAN0TDSR4_DB6:                          equ        mCAN0TXDSR4_DB6
mCAN0TDSR4_DB7:                          equ        mCAN0TXDSR4_DB7
CAN0TDSR5:                               equ        CAN0TXDSR5
CAN0TDSR5_DB0:                           equ        CAN0TXDSR5_DB0
CAN0TDSR5_DB1:                           equ        CAN0TXDSR5_DB1
CAN0TDSR5_DB2:                           equ        CAN0TXDSR5_DB2
CAN0TDSR5_DB3:                           equ        CAN0TXDSR5_DB3
CAN0TDSR5_DB4:                           equ        CAN0TXDSR5_DB4
CAN0TDSR5_DB5:                           equ        CAN0TXDSR5_DB5
CAN0TDSR5_DB6:                           equ        CAN0TXDSR5_DB6
CAN0TDSR5_DB7:                           equ        CAN0TXDSR5_DB7
mCAN0TDSR5_DB0:                          equ        mCAN0TXDSR5_DB0
mCAN0TDSR5_DB1:                          equ        mCAN0TXDSR5_DB1
mCAN0TDSR5_DB2:                          equ        mCAN0TXDSR5_DB2
mCAN0TDSR5_DB3:                          equ        mCAN0TXDSR5_DB3
mCAN0TDSR5_DB4:                          equ        mCAN0TXDSR5_DB4
mCAN0TDSR5_DB5:                          equ        mCAN0TXDSR5_DB5
mCAN0TDSR5_DB6:                          equ        mCAN0TXDSR5_DB6
mCAN0TDSR5_DB7:                          equ        mCAN0TXDSR5_DB7
CAN0TDSR6:                               equ        CAN0TXDSR6
CAN0TDSR6_DB0:                           equ        CAN0TXDSR6_DB0
CAN0TDSR6_DB1:                           equ        CAN0TXDSR6_DB1
CAN0TDSR6_DB2:                           equ        CAN0TXDSR6_DB2
CAN0TDSR6_DB3:                           equ        CAN0TXDSR6_DB3
CAN0TDSR6_DB4:                           equ        CAN0TXDSR6_DB4
CAN0TDSR6_DB5:                           equ        CAN0TXDSR6_DB5
CAN0TDSR6_DB6:                           equ        CAN0TXDSR6_DB6
CAN0TDSR6_DB7:                           equ        CAN0TXDSR6_DB7
mCAN0TDSR6_DB0:                          equ        mCAN0TXDSR6_DB0
mCAN0TDSR6_DB1:                          equ        mCAN0TXDSR6_DB1
mCAN0TDSR6_DB2:                          equ        mCAN0TXDSR6_DB2
mCAN0TDSR6_DB3:                          equ        mCAN0TXDSR6_DB3
mCAN0TDSR6_DB4:                          equ        mCAN0TXDSR6_DB4
mCAN0TDSR6_DB5:                          equ        mCAN0TXDSR6_DB5
mCAN0TDSR6_DB6:                          equ        mCAN0TXDSR6_DB6
mCAN0TDSR6_DB7:                          equ        mCAN0TXDSR6_DB7
CAN0TDSR7:                               equ        CAN0TXDSR7
CAN0TDSR7_DB0:                           equ        CAN0TXDSR7_DB0
CAN0TDSR7_DB1:                           equ        CAN0TXDSR7_DB1
CAN0TDSR7_DB2:                           equ        CAN0TXDSR7_DB2
CAN0TDSR7_DB3:                           equ        CAN0TXDSR7_DB3
CAN0TDSR7_DB4:                           equ        CAN0TXDSR7_DB4
CAN0TDSR7_DB5:                           equ        CAN0TXDSR7_DB5
CAN0TDSR7_DB6:                           equ        CAN0TXDSR7_DB6
CAN0TDSR7_DB7:                           equ        CAN0TXDSR7_DB7
mCAN0TDSR7_DB0:                          equ        mCAN0TXDSR7_DB0
mCAN0TDSR7_DB1:                          equ        mCAN0TXDSR7_DB1
mCAN0TDSR7_DB2:                          equ        mCAN0TXDSR7_DB2
mCAN0TDSR7_DB3:                          equ        mCAN0TXDSR7_DB3
mCAN0TDSR7_DB4:                          equ        mCAN0TXDSR7_DB4
mCAN0TDSR7_DB5:                          equ        mCAN0TXDSR7_DB5
mCAN0TDSR7_DB6:                          equ        mCAN0TXDSR7_DB6
mCAN0TDSR7_DB7:                          equ        mCAN0TXDSR7_DB7
CAN0TDLR:                                equ        CAN0TXDLR
CAN0TDLR_DLC0:                           equ        CAN0TXDLR_DLC0
CAN0TDLR_DLC1:                           equ        CAN0TXDLR_DLC1
CAN0TDLR_DLC2:                           equ        CAN0TXDLR_DLC2
CAN0TDLR_DLC3:                           equ        CAN0TXDLR_DLC3
mCAN0TDLR_DLC0:                          equ        mCAN0TXDLR_DLC0
mCAN0TDLR_DLC1:                          equ        mCAN0TXDLR_DLC1
mCAN0TDLR_DLC2:                          equ        mCAN0TXDLR_DLC2
mCAN0TDLR_DLC3:                          equ        mCAN0TXDLR_DLC3
CAN0TTBPR:                               equ        CAN0TXTBPR
CAN0TTBPR_PRIO0:                         equ        CAN0TXTBPR_PRIO0
CAN0TTBPR_PRIO1:                         equ        CAN0TXTBPR_PRIO1
CAN0TTBPR_PRIO2:                         equ        CAN0TXTBPR_PRIO2
CAN0TTBPR_PRIO3:                         equ        CAN0TXTBPR_PRIO3
CAN0TTBPR_PRIO4:                         equ        CAN0TXTBPR_PRIO4
CAN0TTBPR_PRIO5:                         equ        CAN0TXTBPR_PRIO5
CAN0TTBPR_PRIO6:                         equ        CAN0TXTBPR_PRIO6
CAN0TTBPR_PRIO7:                         equ        CAN0TXTBPR_PRIO7
mCAN0TTBPR_PRIO0:                        equ        mCAN0TXTBPR_PRIO0
mCAN0TTBPR_PRIO1:                        equ        mCAN0TXTBPR_PRIO1
mCAN0TTBPR_PRIO2:                        equ        mCAN0TXTBPR_PRIO2
mCAN0TTBPR_PRIO3:                        equ        mCAN0TXTBPR_PRIO3
mCAN0TTBPR_PRIO4:                        equ        mCAN0TXTBPR_PRIO4
mCAN0TTBPR_PRIO5:                        equ        mCAN0TXTBPR_PRIO5
mCAN0TTBPR_PRIO6:                        equ        mCAN0TXTBPR_PRIO6
mCAN0TTBPR_PRIO7:                        equ        mCAN0TXTBPR_PRIO7
CAN0TTSR:                                equ        CAN0TXTSR
CAN0TTSR_TSR0:                           equ        CAN0TXTSR_TSR0
CAN0TTSR_TSR1:                           equ        CAN0TXTSR_TSR1
CAN0TTSR_TSR2:                           equ        CAN0TXTSR_TSR2
CAN0TTSR_TSR3:                           equ        CAN0TXTSR_TSR3
CAN0TTSR_TSR4:                           equ        CAN0TXTSR_TSR4
CAN0TTSR_TSR5:                           equ        CAN0TXTSR_TSR5
CAN0TTSR_TSR6:                           equ        CAN0TXTSR_TSR6
CAN0TTSR_TSR7:                           equ        CAN0TXTSR_TSR7
CAN0TTSR_TSR8:                           equ        CAN0TXTSR_TSR8
CAN0TTSR_TSR9:                           equ        CAN0TXTSR_TSR9
CAN0TTSR_TSR10:                          equ        CAN0TXTSR_TSR10
CAN0TTSR_TSR11:                          equ        CAN0TXTSR_TSR11
CAN0TTSR_TSR12:                          equ        CAN0TXTSR_TSR12
CAN0TTSR_TSR13:                          equ        CAN0TXTSR_TSR13
CAN0TTSR_TSR14:                          equ        CAN0TXTSR_TSR14
CAN0TTSR_TSR15:                          equ        CAN0TXTSR_TSR15
mCAN0TTSR_TSR0:                          equ        mCAN0TXTSR_TSR0
mCAN0TTSR_TSR1:                          equ        mCAN0TXTSR_TSR1
mCAN0TTSR_TSR2:                          equ        mCAN0TXTSR_TSR2
mCAN0TTSR_TSR3:                          equ        mCAN0TXTSR_TSR3
mCAN0TTSR_TSR4:                          equ        mCAN0TXTSR_TSR4
mCAN0TTSR_TSR5:                          equ        mCAN0TXTSR_TSR5
mCAN0TTSR_TSR6:                          equ        mCAN0TXTSR_TSR6
mCAN0TTSR_TSR7:                          equ        mCAN0TXTSR_TSR7
mCAN0TTSR_TSR8:                          equ        mCAN0TXTSR_TSR8
mCAN0TTSR_TSR9:                          equ        mCAN0TXTSR_TSR9
mCAN0TTSR_TSR10:                         equ        mCAN0TXTSR_TSR10
mCAN0TTSR_TSR11:                         equ        mCAN0TXTSR_TSR11
mCAN0TTSR_TSR12:                         equ        mCAN0TXTSR_TSR12
mCAN0TTSR_TSR13:                         equ        mCAN0TXTSR_TSR13
mCAN0TTSR_TSR14:                         equ        mCAN0TXTSR_TSR14
mCAN0TTSR_TSR15:                         equ        mCAN0TXTSR_TSR15
CAN0TTSRH:                               equ        CAN0TXTSRH
CAN0TTSRH_TSR8:                          equ        CAN0TXTSRH_TSR8
CAN0TTSRH_TSR9:                          equ        CAN0TXTSRH_TSR9
CAN0TTSRH_TSR10:                         equ        CAN0TXTSRH_TSR10
CAN0TTSRH_TSR11:                         equ        CAN0TXTSRH_TSR11
CAN0TTSRH_TSR12:                         equ        CAN0TXTSRH_TSR12
CAN0TTSRH_TSR13:                         equ        CAN0TXTSRH_TSR13
CAN0TTSRH_TSR14:                         equ        CAN0TXTSRH_TSR14
CAN0TTSRH_TSR15:                         equ        CAN0TXTSRH_TSR15
mCAN0TTSRH_TSR8:                         equ        mCAN0TXTSRH_TSR8
mCAN0TTSRH_TSR9:                         equ        mCAN0TXTSRH_TSR9
mCAN0TTSRH_TSR10:                        equ        mCAN0TXTSRH_TSR10
mCAN0TTSRH_TSR11:                        equ        mCAN0TXTSRH_TSR11
mCAN0TTSRH_TSR12:                        equ        mCAN0TXTSRH_TSR12
mCAN0TTSRH_TSR13:                        equ        mCAN0TXTSRH_TSR13
mCAN0TTSRH_TSR14:                        equ        mCAN0TXTSRH_TSR14
mCAN0TTSRH_TSR15:                        equ        mCAN0TXTSRH_TSR15
CAN0TTSRL:                               equ        CAN0TXTSRL
CAN0TTSRL_TSR0:                          equ        CAN0TXTSRL_TSR0
CAN0TTSRL_TSR1:                          equ        CAN0TXTSRL_TSR1
CAN0TTSRL_TSR2:                          equ        CAN0TXTSRL_TSR2
CAN0TTSRL_TSR3:                          equ        CAN0TXTSRL_TSR3
CAN0TTSRL_TSR4:                          equ        CAN0TXTSRL_TSR4
CAN0TTSRL_TSR5:                          equ        CAN0TXTSRL_TSR5
CAN0TTSRL_TSR6:                          equ        CAN0TXTSRL_TSR6
CAN0TTSRL_TSR7:                          equ        CAN0TXTSRL_TSR7
mCAN0TTSRL_TSR0:                         equ        mCAN0TXTSRL_TSR0
mCAN0TTSRL_TSR1:                         equ        mCAN0TXTSRL_TSR1
mCAN0TTSRL_TSR2:                         equ        mCAN0TXTSRL_TSR2
mCAN0TTSRL_TSR3:                         equ        mCAN0TXTSRL_TSR3
mCAN0TTSRL_TSR4:                         equ        mCAN0TXTSRL_TSR4
mCAN0TTSRL_TSR5:                         equ        mCAN0TXTSRL_TSR5
mCAN0TTSRL_TSR6:                         equ        mCAN0TXTSRL_TSR6
mCAN0TTSRL_TSR7:                         equ        mCAN0TXTSRL_TSR7
CAN1RIDR0:                               equ        CAN1RXIDR0
CAN1RIDR0_ID21:                          equ        CAN1RXIDR0_ID21
CAN1RIDR0_ID22:                          equ        CAN1RXIDR0_ID22
CAN1RIDR0_ID23:                          equ        CAN1RXIDR0_ID23
CAN1RIDR0_ID24:                          equ        CAN1RXIDR0_ID24
CAN1RIDR0_ID25:                          equ        CAN1RXIDR0_ID25
CAN1RIDR0_ID26:                          equ        CAN1RXIDR0_ID26
CAN1RIDR0_ID27:                          equ        CAN1RXIDR0_ID27
CAN1RIDR0_ID28:                          equ        CAN1RXIDR0_ID28
mCAN1RIDR0_ID21:                         equ        mCAN1RXIDR0_ID21
mCAN1RIDR0_ID22:                         equ        mCAN1RXIDR0_ID22
mCAN1RIDR0_ID23:                         equ        mCAN1RXIDR0_ID23
mCAN1RIDR0_ID24:                         equ        mCAN1RXIDR0_ID24
mCAN1RIDR0_ID25:                         equ        mCAN1RXIDR0_ID25
mCAN1RIDR0_ID26:                         equ        mCAN1RXIDR0_ID26
mCAN1RIDR0_ID27:                         equ        mCAN1RXIDR0_ID27
mCAN1RIDR0_ID28:                         equ        mCAN1RXIDR0_ID28
CAN1RIDR1:                               equ        CAN1RXIDR1
CAN1RIDR1_ID15:                          equ        CAN1RXIDR1_ID15
CAN1RIDR1_ID16:                          equ        CAN1RXIDR1_ID16
CAN1RIDR1_ID17:                          equ        CAN1RXIDR1_ID17
CAN1RIDR1_IDE:                           equ        CAN1RXIDR1_IDE
CAN1RIDR1_SRR:                           equ        CAN1RXIDR1_SRR
CAN1RIDR1_ID18:                          equ        CAN1RXIDR1_ID18
CAN1RIDR1_ID19:                          equ        CAN1RXIDR1_ID19
CAN1RIDR1_ID20:                          equ        CAN1RXIDR1_ID20
mCAN1RIDR1_ID15:                         equ        mCAN1RXIDR1_ID15
mCAN1RIDR1_ID16:                         equ        mCAN1RXIDR1_ID16
mCAN1RIDR1_ID17:                         equ        mCAN1RXIDR1_ID17
mCAN1RIDR1_IDE:                          equ        mCAN1RXIDR1_IDE
mCAN1RIDR1_SRR:                          equ        mCAN1RXIDR1_SRR
mCAN1RIDR1_ID18:                         equ        mCAN1RXIDR1_ID18
mCAN1RIDR1_ID19:                         equ        mCAN1RXIDR1_ID19
mCAN1RIDR1_ID20:                         equ        mCAN1RXIDR1_ID20
CAN1RIDR2:                               equ        CAN1RXIDR2
CAN1RIDR2_ID7:                           equ        CAN1RXIDR2_ID7
CAN1RIDR2_ID8:                           equ        CAN1RXIDR2_ID8
CAN1RIDR2_ID9:                           equ        CAN1RXIDR2_ID9
CAN1RIDR2_ID10:                          equ        CAN1RXIDR2_ID10
CAN1RIDR2_ID11:                          equ        CAN1RXIDR2_ID11
CAN1RIDR2_ID12:                          equ        CAN1RXIDR2_ID12
CAN1RIDR2_ID13:                          equ        CAN1RXIDR2_ID13
CAN1RIDR2_ID14:                          equ        CAN1RXIDR2_ID14
mCAN1RIDR2_ID7:                          equ        mCAN1RXIDR2_ID7
mCAN1RIDR2_ID8:                          equ        mCAN1RXIDR2_ID8
mCAN1RIDR2_ID9:                          equ        mCAN1RXIDR2_ID9
mCAN1RIDR2_ID10:                         equ        mCAN1RXIDR2_ID10
mCAN1RIDR2_ID11:                         equ        mCAN1RXIDR2_ID11
mCAN1RIDR2_ID12:                         equ        mCAN1RXIDR2_ID12
mCAN1RIDR2_ID13:                         equ        mCAN1RXIDR2_ID13
mCAN1RIDR2_ID14:                         equ        mCAN1RXIDR2_ID14
CAN1RIDR3:                               equ        CAN1RXIDR3
CAN1RIDR3_RTR:                           equ        CAN1RXIDR3_RTR
CAN1RIDR3_ID0:                           equ        CAN1RXIDR3_ID0
CAN1RIDR3_ID1:                           equ        CAN1RXIDR3_ID1
CAN1RIDR3_ID2:                           equ        CAN1RXIDR3_ID2
CAN1RIDR3_ID3:                           equ        CAN1RXIDR3_ID3
CAN1RIDR3_ID4:                           equ        CAN1RXIDR3_ID4
CAN1RIDR3_ID5:                           equ        CAN1RXIDR3_ID5
CAN1RIDR3_ID6:                           equ        CAN1RXIDR3_ID6
mCAN1RIDR3_RTR:                          equ        mCAN1RXIDR3_RTR
mCAN1RIDR3_ID0:                          equ        mCAN1RXIDR3_ID0
mCAN1RIDR3_ID1:                          equ        mCAN1RXIDR3_ID1
mCAN1RIDR3_ID2:                          equ        mCAN1RXIDR3_ID2
mCAN1RIDR3_ID3:                          equ        mCAN1RXIDR3_ID3
mCAN1RIDR3_ID4:                          equ        mCAN1RXIDR3_ID4
mCAN1RIDR3_ID5:                          equ        mCAN1RXIDR3_ID5
mCAN1RIDR3_ID6:                          equ        mCAN1RXIDR3_ID6
CAN1RDSR0:                               equ        CAN1RXDSR0
CAN1RDSR0_DB0:                           equ        CAN1RXDSR0_DB0
CAN1RDSR0_DB1:                           equ        CAN1RXDSR0_DB1
CAN1RDSR0_DB2:                           equ        CAN1RXDSR0_DB2
CAN1RDSR0_DB3:                           equ        CAN1RXDSR0_DB3
CAN1RDSR0_DB4:                           equ        CAN1RXDSR0_DB4
CAN1RDSR0_DB5:                           equ        CAN1RXDSR0_DB5
CAN1RDSR0_DB6:                           equ        CAN1RXDSR0_DB6
CAN1RDSR0_DB7:                           equ        CAN1RXDSR0_DB7
mCAN1RDSR0_DB0:                          equ        mCAN1RXDSR0_DB0
mCAN1RDSR0_DB1:                          equ        mCAN1RXDSR0_DB1
mCAN1RDSR0_DB2:                          equ        mCAN1RXDSR0_DB2
mCAN1RDSR0_DB3:                          equ        mCAN1RXDSR0_DB3
mCAN1RDSR0_DB4:                          equ        mCAN1RXDSR0_DB4
mCAN1RDSR0_DB5:                          equ        mCAN1RXDSR0_DB5
mCAN1RDSR0_DB6:                          equ        mCAN1RXDSR0_DB6
mCAN1RDSR0_DB7:                          equ        mCAN1RXDSR0_DB7
CAN1RDSR1:                               equ        CAN1RXDSR1
CAN1RDSR1_DB0:                           equ        CAN1RXDSR1_DB0
CAN1RDSR1_DB1:                           equ        CAN1RXDSR1_DB1
CAN1RDSR1_DB2:                           equ        CAN1RXDSR1_DB2
CAN1RDSR1_DB3:                           equ        CAN1RXDSR1_DB3
CAN1RDSR1_DB4:                           equ        CAN1RXDSR1_DB4
CAN1RDSR1_DB5:                           equ        CAN1RXDSR1_DB5
CAN1RDSR1_DB6:                           equ        CAN1RXDSR1_DB6
CAN1RDSR1_DB7:                           equ        CAN1RXDSR1_DB7
mCAN1RDSR1_DB0:                          equ        mCAN1RXDSR1_DB0
mCAN1RDSR1_DB1:                          equ        mCAN1RXDSR1_DB1
mCAN1RDSR1_DB2:                          equ        mCAN1RXDSR1_DB2
mCAN1RDSR1_DB3:                          equ        mCAN1RXDSR1_DB3
mCAN1RDSR1_DB4:                          equ        mCAN1RXDSR1_DB4
mCAN1RDSR1_DB5:                          equ        mCAN1RXDSR1_DB5
mCAN1RDSR1_DB6:                          equ        mCAN1RXDSR1_DB6
mCAN1RDSR1_DB7:                          equ        mCAN1RXDSR1_DB7
CAN1RDSR2:                               equ        CAN1RXDSR2
CAN1RDSR2_DB0:                           equ        CAN1RXDSR2_DB0
CAN1RDSR2_DB1:                           equ        CAN1RXDSR2_DB1
CAN1RDSR2_DB2:                           equ        CAN1RXDSR2_DB2
CAN1RDSR2_DB3:                           equ        CAN1RXDSR2_DB3
CAN1RDSR2_DB4:                           equ        CAN1RXDSR2_DB4
CAN1RDSR2_DB5:                           equ        CAN1RXDSR2_DB5
CAN1RDSR2_DB6:                           equ        CAN1RXDSR2_DB6
CAN1RDSR2_DB7:                           equ        CAN1RXDSR2_DB7
mCAN1RDSR2_DB0:                          equ        mCAN1RXDSR2_DB0
mCAN1RDSR2_DB1:                          equ        mCAN1RXDSR2_DB1
mCAN1RDSR2_DB2:                          equ        mCAN1RXDSR2_DB2
mCAN1RDSR2_DB3:                          equ        mCAN1RXDSR2_DB3
mCAN1RDSR2_DB4:                          equ        mCAN1RXDSR2_DB4
mCAN1RDSR2_DB5:                          equ        mCAN1RXDSR2_DB5
mCAN1RDSR2_DB6:                          equ        mCAN1RXDSR2_DB6
mCAN1RDSR2_DB7:                          equ        mCAN1RXDSR2_DB7
CAN1RDSR3:                               equ        CAN1RXDSR3
CAN1RDSR3_DB0:                           equ        CAN1RXDSR3_DB0
CAN1RDSR3_DB1:                           equ        CAN1RXDSR3_DB1
CAN1RDSR3_DB2:                           equ        CAN1RXDSR3_DB2
CAN1RDSR3_DB3:                           equ        CAN1RXDSR3_DB3
CAN1RDSR3_DB4:                           equ        CAN1RXDSR3_DB4
CAN1RDSR3_DB5:                           equ        CAN1RXDSR3_DB5
CAN1RDSR3_DB6:                           equ        CAN1RXDSR3_DB6
CAN1RDSR3_DB7:                           equ        CAN1RXDSR3_DB7
mCAN1RDSR3_DB0:                          equ        mCAN1RXDSR3_DB0
mCAN1RDSR3_DB1:                          equ        mCAN1RXDSR3_DB1
mCAN1RDSR3_DB2:                          equ        mCAN1RXDSR3_DB2
mCAN1RDSR3_DB3:                          equ        mCAN1RXDSR3_DB3
mCAN1RDSR3_DB4:                          equ        mCAN1RXDSR3_DB4
mCAN1RDSR3_DB5:                          equ        mCAN1RXDSR3_DB5
mCAN1RDSR3_DB6:                          equ        mCAN1RXDSR3_DB6
mCAN1RDSR3_DB7:                          equ        mCAN1RXDSR3_DB7
CAN1RDSR4:                               equ        CAN1RXDSR4
CAN1RDSR4_DB0:                           equ        CAN1RXDSR4_DB0
CAN1RDSR4_DB1:                           equ        CAN1RXDSR4_DB1
CAN1RDSR4_DB2:                           equ        CAN1RXDSR4_DB2
CAN1RDSR4_DB3:                           equ        CAN1RXDSR4_DB3
CAN1RDSR4_DB4:                           equ        CAN1RXDSR4_DB4
CAN1RDSR4_DB5:                           equ        CAN1RXDSR4_DB5
CAN1RDSR4_DB6:                           equ        CAN1RXDSR4_DB6
CAN1RDSR4_DB7:                           equ        CAN1RXDSR4_DB7
mCAN1RDSR4_DB0:                          equ        mCAN1RXDSR4_DB0
mCAN1RDSR4_DB1:                          equ        mCAN1RXDSR4_DB1
mCAN1RDSR4_DB2:                          equ        mCAN1RXDSR4_DB2
mCAN1RDSR4_DB3:                          equ        mCAN1RXDSR4_DB3
mCAN1RDSR4_DB4:                          equ        mCAN1RXDSR4_DB4
mCAN1RDSR4_DB5:                          equ        mCAN1RXDSR4_DB5
mCAN1RDSR4_DB6:                          equ        mCAN1RXDSR4_DB6
mCAN1RDSR4_DB7:                          equ        mCAN1RXDSR4_DB7
CAN1RDSR5:                               equ        CAN1RXDSR5
CAN1RDSR5_DB0:                           equ        CAN1RXDSR5_DB0
CAN1RDSR5_DB1:                           equ        CAN1RXDSR5_DB1
CAN1RDSR5_DB2:                           equ        CAN1RXDSR5_DB2
CAN1RDSR5_DB3:                           equ        CAN1RXDSR5_DB3
CAN1RDSR5_DB4:                           equ        CAN1RXDSR5_DB4
CAN1RDSR5_DB5:                           equ        CAN1RXDSR5_DB5
CAN1RDSR5_DB6:                           equ        CAN1RXDSR5_DB6
CAN1RDSR5_DB7:                           equ        CAN1RXDSR5_DB7
mCAN1RDSR5_DB0:                          equ        mCAN1RXDSR5_DB0
mCAN1RDSR5_DB1:                          equ        mCAN1RXDSR5_DB1
mCAN1RDSR5_DB2:                          equ        mCAN1RXDSR5_DB2
mCAN1RDSR5_DB3:                          equ        mCAN1RXDSR5_DB3
mCAN1RDSR5_DB4:                          equ        mCAN1RXDSR5_DB4
mCAN1RDSR5_DB5:                          equ        mCAN1RXDSR5_DB5
mCAN1RDSR5_DB6:                          equ        mCAN1RXDSR5_DB6
mCAN1RDSR5_DB7:                          equ        mCAN1RXDSR5_DB7
CAN1RDSR6:                               equ        CAN1RXDSR6
CAN1RDSR6_DB0:                           equ        CAN1RXDSR6_DB0
CAN1RDSR6_DB1:                           equ        CAN1RXDSR6_DB1
CAN1RDSR6_DB2:                           equ        CAN1RXDSR6_DB2
CAN1RDSR6_DB3:                           equ        CAN1RXDSR6_DB3
CAN1RDSR6_DB4:                           equ        CAN1RXDSR6_DB4
CAN1RDSR6_DB5:                           equ        CAN1RXDSR6_DB5
CAN1RDSR6_DB6:                           equ        CAN1RXDSR6_DB6
CAN1RDSR6_DB7:                           equ        CAN1RXDSR6_DB7
mCAN1RDSR6_DB0:                          equ        mCAN1RXDSR6_DB0
mCAN1RDSR6_DB1:                          equ        mCAN1RXDSR6_DB1
mCAN1RDSR6_DB2:                          equ        mCAN1RXDSR6_DB2
mCAN1RDSR6_DB3:                          equ        mCAN1RXDSR6_DB3
mCAN1RDSR6_DB4:                          equ        mCAN1RXDSR6_DB4
mCAN1RDSR6_DB5:                          equ        mCAN1RXDSR6_DB5
mCAN1RDSR6_DB6:                          equ        mCAN1RXDSR6_DB6
mCAN1RDSR6_DB7:                          equ        mCAN1RXDSR6_DB7
CAN1RDSR7:                               equ        CAN1RXDSR7
CAN1RDSR7_DB0:                           equ        CAN1RXDSR7_DB0
CAN1RDSR7_DB1:                           equ        CAN1RXDSR7_DB1
CAN1RDSR7_DB2:                           equ        CAN1RXDSR7_DB2
CAN1RDSR7_DB3:                           equ        CAN1RXDSR7_DB3
CAN1RDSR7_DB4:                           equ        CAN1RXDSR7_DB4
CAN1RDSR7_DB5:                           equ        CAN1RXDSR7_DB5
CAN1RDSR7_DB6:                           equ        CAN1RXDSR7_DB6
CAN1RDSR7_DB7:                           equ        CAN1RXDSR7_DB7
mCAN1RDSR7_DB0:                          equ        mCAN1RXDSR7_DB0
mCAN1RDSR7_DB1:                          equ        mCAN1RXDSR7_DB1
mCAN1RDSR7_DB2:                          equ        mCAN1RXDSR7_DB2
mCAN1RDSR7_DB3:                          equ        mCAN1RXDSR7_DB3
mCAN1RDSR7_DB4:                          equ        mCAN1RXDSR7_DB4
mCAN1RDSR7_DB5:                          equ        mCAN1RXDSR7_DB5
mCAN1RDSR7_DB6:                          equ        mCAN1RXDSR7_DB6
mCAN1RDSR7_DB7:                          equ        mCAN1RXDSR7_DB7
CAN1RDLR:                                equ        CAN1RXDLR
CAN1RDLR_DLC0:                           equ        CAN1RXDLR_DLC0
CAN1RDLR_DLC1:                           equ        CAN1RXDLR_DLC1
CAN1RDLR_DLC2:                           equ        CAN1RXDLR_DLC2
CAN1RDLR_DLC3:                           equ        CAN1RXDLR_DLC3
mCAN1RDLR_DLC0:                          equ        mCAN1RXDLR_DLC0
mCAN1RDLR_DLC1:                          equ        mCAN1RXDLR_DLC1
mCAN1RDLR_DLC2:                          equ        mCAN1RXDLR_DLC2
mCAN1RDLR_DLC3:                          equ        mCAN1RXDLR_DLC3
CAN1RTSR:                                equ        CAN1RXTSR
CAN1RTSR_TSR0:                           equ        CAN1RXTSR_TSR0
CAN1RTSR_TSR1:                           equ        CAN1RXTSR_TSR1
CAN1RTSR_TSR2:                           equ        CAN1RXTSR_TSR2
CAN1RTSR_TSR3:                           equ        CAN1RXTSR_TSR3
CAN1RTSR_TSR4:                           equ        CAN1RXTSR_TSR4
CAN1RTSR_TSR5:                           equ        CAN1RXTSR_TSR5
CAN1RTSR_TSR6:                           equ        CAN1RXTSR_TSR6
CAN1RTSR_TSR7:                           equ        CAN1RXTSR_TSR7
CAN1RTSR_TSR8:                           equ        CAN1RXTSR_TSR8
CAN1RTSR_TSR9:                           equ        CAN1RXTSR_TSR9
CAN1RTSR_TSR10:                          equ        CAN1RXTSR_TSR10
CAN1RTSR_TSR11:                          equ        CAN1RXTSR_TSR11
CAN1RTSR_TSR12:                          equ        CAN1RXTSR_TSR12
CAN1RTSR_TSR13:                          equ        CAN1RXTSR_TSR13
CAN1RTSR_TSR14:                          equ        CAN1RXTSR_TSR14
CAN1RTSR_TSR15:                          equ        CAN1RXTSR_TSR15
mCAN1RTSR_TSR0:                          equ        mCAN1RXTSR_TSR0
mCAN1RTSR_TSR1:                          equ        mCAN1RXTSR_TSR1
mCAN1RTSR_TSR2:                          equ        mCAN1RXTSR_TSR2
mCAN1RTSR_TSR3:                          equ        mCAN1RXTSR_TSR3
mCAN1RTSR_TSR4:                          equ        mCAN1RXTSR_TSR4
mCAN1RTSR_TSR5:                          equ        mCAN1RXTSR_TSR5
mCAN1RTSR_TSR6:                          equ        mCAN1RXTSR_TSR6
mCAN1RTSR_TSR7:                          equ        mCAN1RXTSR_TSR7
mCAN1RTSR_TSR8:                          equ        mCAN1RXTSR_TSR8
mCAN1RTSR_TSR9:                          equ        mCAN1RXTSR_TSR9
mCAN1RTSR_TSR10:                         equ        mCAN1RXTSR_TSR10
mCAN1RTSR_TSR11:                         equ        mCAN1RXTSR_TSR11
mCAN1RTSR_TSR12:                         equ        mCAN1RXTSR_TSR12
mCAN1RTSR_TSR13:                         equ        mCAN1RXTSR_TSR13
mCAN1RTSR_TSR14:                         equ        mCAN1RXTSR_TSR14
mCAN1RTSR_TSR15:                         equ        mCAN1RXTSR_TSR15
CAN1RTSRH:                               equ        CAN1RXTSRH
CAN1RTSRH_TSR8:                          equ        CAN1RXTSRH_TSR8
CAN1RTSRH_TSR9:                          equ        CAN1RXTSRH_TSR9
CAN1RTSRH_TSR10:                         equ        CAN1RXTSRH_TSR10
CAN1RTSRH_TSR11:                         equ        CAN1RXTSRH_TSR11
CAN1RTSRH_TSR12:                         equ        CAN1RXTSRH_TSR12
CAN1RTSRH_TSR13:                         equ        CAN1RXTSRH_TSR13
CAN1RTSRH_TSR14:                         equ        CAN1RXTSRH_TSR14
CAN1RTSRH_TSR15:                         equ        CAN1RXTSRH_TSR15
mCAN1RTSRH_TSR8:                         equ        mCAN1RXTSRH_TSR8
mCAN1RTSRH_TSR9:                         equ        mCAN1RXTSRH_TSR9
mCAN1RTSRH_TSR10:                        equ        mCAN1RXTSRH_TSR10
mCAN1RTSRH_TSR11:                        equ        mCAN1RXTSRH_TSR11
mCAN1RTSRH_TSR12:                        equ        mCAN1RXTSRH_TSR12
mCAN1RTSRH_TSR13:                        equ        mCAN1RXTSRH_TSR13
mCAN1RTSRH_TSR14:                        equ        mCAN1RXTSRH_TSR14
mCAN1RTSRH_TSR15:                        equ        mCAN1RXTSRH_TSR15
CAN1RTSRL:                               equ        CAN1RXTSRL
CAN1RTSRL_TSR0:                          equ        CAN1RXTSRL_TSR0
CAN1RTSRL_TSR1:                          equ        CAN1RXTSRL_TSR1
CAN1RTSRL_TSR2:                          equ        CAN1RXTSRL_TSR2
CAN1RTSRL_TSR3:                          equ        CAN1RXTSRL_TSR3
CAN1RTSRL_TSR4:                          equ        CAN1RXTSRL_TSR4
CAN1RTSRL_TSR5:                          equ        CAN1RXTSRL_TSR5
CAN1RTSRL_TSR6:                          equ        CAN1RXTSRL_TSR6
CAN1RTSRL_TSR7:                          equ        CAN1RXTSRL_TSR7
mCAN1RTSRL_TSR0:                         equ        mCAN1RXTSRL_TSR0
mCAN1RTSRL_TSR1:                         equ        mCAN1RXTSRL_TSR1
mCAN1RTSRL_TSR2:                         equ        mCAN1RXTSRL_TSR2
mCAN1RTSRL_TSR3:                         equ        mCAN1RXTSRL_TSR3
mCAN1RTSRL_TSR4:                         equ        mCAN1RXTSRL_TSR4
mCAN1RTSRL_TSR5:                         equ        mCAN1RXTSRL_TSR5
mCAN1RTSRL_TSR6:                         equ        mCAN1RXTSRL_TSR6
mCAN1RTSRL_TSR7:                         equ        mCAN1RXTSRL_TSR7
CAN1TIDR0:                               equ        CAN1TXIDR0
CAN1TIDR0_ID21:                          equ        CAN1TXIDR0_ID21
CAN1TIDR0_ID22:                          equ        CAN1TXIDR0_ID22
CAN1TIDR0_ID23:                          equ        CAN1TXIDR0_ID23
CAN1TIDR0_ID24:                          equ        CAN1TXIDR0_ID24
CAN1TIDR0_ID25:                          equ        CAN1TXIDR0_ID25
CAN1TIDR0_ID26:                          equ        CAN1TXIDR0_ID26
CAN1TIDR0_ID27:                          equ        CAN1TXIDR0_ID27
CAN1TIDR0_ID28:                          equ        CAN1TXIDR0_ID28
mCAN1TIDR0_ID21:                         equ        mCAN1TXIDR0_ID21
mCAN1TIDR0_ID22:                         equ        mCAN1TXIDR0_ID22
mCAN1TIDR0_ID23:                         equ        mCAN1TXIDR0_ID23
mCAN1TIDR0_ID24:                         equ        mCAN1TXIDR0_ID24
mCAN1TIDR0_ID25:                         equ        mCAN1TXIDR0_ID25
mCAN1TIDR0_ID26:                         equ        mCAN1TXIDR0_ID26
mCAN1TIDR0_ID27:                         equ        mCAN1TXIDR0_ID27
mCAN1TIDR0_ID28:                         equ        mCAN1TXIDR0_ID28
CAN1TIDR1:                               equ        CAN1TXIDR1
CAN1TIDR1_ID15:                          equ        CAN1TXIDR1_ID15
CAN1TIDR1_ID16:                          equ        CAN1TXIDR1_ID16
CAN1TIDR1_ID17:                          equ        CAN1TXIDR1_ID17
CAN1TIDR1_IDE:                           equ        CAN1TXIDR1_IDE
CAN1TIDR1_SRR:                           equ        CAN1TXIDR1_SRR
CAN1TIDR1_ID18:                          equ        CAN1TXIDR1_ID18
CAN1TIDR1_ID19:                          equ        CAN1TXIDR1_ID19
CAN1TIDR1_ID20:                          equ        CAN1TXIDR1_ID20
mCAN1TIDR1_ID15:                         equ        mCAN1TXIDR1_ID15
mCAN1TIDR1_ID16:                         equ        mCAN1TXIDR1_ID16
mCAN1TIDR1_ID17:                         equ        mCAN1TXIDR1_ID17
mCAN1TIDR1_IDE:                          equ        mCAN1TXIDR1_IDE
mCAN1TIDR1_SRR:                          equ        mCAN1TXIDR1_SRR
mCAN1TIDR1_ID18:                         equ        mCAN1TXIDR1_ID18
mCAN1TIDR1_ID19:                         equ        mCAN1TXIDR1_ID19
mCAN1TIDR1_ID20:                         equ        mCAN1TXIDR1_ID20
CAN1TIDR2:                               equ        CAN1TXIDR2
CAN1TIDR2_ID7:                           equ        CAN1TXIDR2_ID7
CAN1TIDR2_ID8:                           equ        CAN1TXIDR2_ID8
CAN1TIDR2_ID9:                           equ        CAN1TXIDR2_ID9
CAN1TIDR2_ID10:                          equ        CAN1TXIDR2_ID10
CAN1TIDR2_ID11:                          equ        CAN1TXIDR2_ID11
CAN1TIDR2_ID12:                          equ        CAN1TXIDR2_ID12
CAN1TIDR2_ID13:                          equ        CAN1TXIDR2_ID13
CAN1TIDR2_ID14:                          equ        CAN1TXIDR2_ID14
mCAN1TIDR2_ID7:                          equ        mCAN1TXIDR2_ID7
mCAN1TIDR2_ID8:                          equ        mCAN1TXIDR2_ID8
mCAN1TIDR2_ID9:                          equ        mCAN1TXIDR2_ID9
mCAN1TIDR2_ID10:                         equ        mCAN1TXIDR2_ID10
mCAN1TIDR2_ID11:                         equ        mCAN1TXIDR2_ID11
mCAN1TIDR2_ID12:                         equ        mCAN1TXIDR2_ID12
mCAN1TIDR2_ID13:                         equ        mCAN1TXIDR2_ID13
mCAN1TIDR2_ID14:                         equ        mCAN1TXIDR2_ID14
CAN1TIDR3:                               equ        CAN1TXIDR3
CAN1TIDR3_RTR:                           equ        CAN1TXIDR3_RTR
CAN1TIDR3_ID0:                           equ        CAN1TXIDR3_ID0
CAN1TIDR3_ID1:                           equ        CAN1TXIDR3_ID1
CAN1TIDR3_ID2:                           equ        CAN1TXIDR3_ID2
CAN1TIDR3_ID3:                           equ        CAN1TXIDR3_ID3
CAN1TIDR3_ID4:                           equ        CAN1TXIDR3_ID4
CAN1TIDR3_ID5:                           equ        CAN1TXIDR3_ID5
CAN1TIDR3_ID6:                           equ        CAN1TXIDR3_ID6
mCAN1TIDR3_RTR:                          equ        mCAN1TXIDR3_RTR
mCAN1TIDR3_ID0:                          equ        mCAN1TXIDR3_ID0
mCAN1TIDR3_ID1:                          equ        mCAN1TXIDR3_ID1
mCAN1TIDR3_ID2:                          equ        mCAN1TXIDR3_ID2
mCAN1TIDR3_ID3:                          equ        mCAN1TXIDR3_ID3
mCAN1TIDR3_ID4:                          equ        mCAN1TXIDR3_ID4
mCAN1TIDR3_ID5:                          equ        mCAN1TXIDR3_ID5
mCAN1TIDR3_ID6:                          equ        mCAN1TXIDR3_ID6
CAN1TDSR0:                               equ        CAN1TXDSR0
CAN1TDSR0_DB0:                           equ        CAN1TXDSR0_DB0
CAN1TDSR0_DB1:                           equ        CAN1TXDSR0_DB1
CAN1TDSR0_DB2:                           equ        CAN1TXDSR0_DB2
CAN1TDSR0_DB3:                           equ        CAN1TXDSR0_DB3
CAN1TDSR0_DB4:                           equ        CAN1TXDSR0_DB4
CAN1TDSR0_DB5:                           equ        CAN1TXDSR0_DB5
CAN1TDSR0_DB6:                           equ        CAN1TXDSR0_DB6
CAN1TDSR0_DB7:                           equ        CAN1TXDSR0_DB7
mCAN1TDSR0_DB0:                          equ        mCAN1TXDSR0_DB0
mCAN1TDSR0_DB1:                          equ        mCAN1TXDSR0_DB1
mCAN1TDSR0_DB2:                          equ        mCAN1TXDSR0_DB2
mCAN1TDSR0_DB3:                          equ        mCAN1TXDSR0_DB3
mCAN1TDSR0_DB4:                          equ        mCAN1TXDSR0_DB4
mCAN1TDSR0_DB5:                          equ        mCAN1TXDSR0_DB5
mCAN1TDSR0_DB6:                          equ        mCAN1TXDSR0_DB6
mCAN1TDSR0_DB7:                          equ        mCAN1TXDSR0_DB7
CAN1TDSR1:                               equ        CAN1TXDSR1
CAN1TDSR1_DB0:                           equ        CAN1TXDSR1_DB0
CAN1TDSR1_DB1:                           equ        CAN1TXDSR1_DB1
CAN1TDSR1_DB2:                           equ        CAN1TXDSR1_DB2
CAN1TDSR1_DB3:                           equ        CAN1TXDSR1_DB3
CAN1TDSR1_DB4:                           equ        CAN1TXDSR1_DB4
CAN1TDSR1_DB5:                           equ        CAN1TXDSR1_DB5
CAN1TDSR1_DB6:                           equ        CAN1TXDSR1_DB6
CAN1TDSR1_DB7:                           equ        CAN1TXDSR1_DB7
mCAN1TDSR1_DB0:                          equ        mCAN1TXDSR1_DB0
mCAN1TDSR1_DB1:                          equ        mCAN1TXDSR1_DB1
mCAN1TDSR1_DB2:                          equ        mCAN1TXDSR1_DB2
mCAN1TDSR1_DB3:                          equ        mCAN1TXDSR1_DB3
mCAN1TDSR1_DB4:                          equ        mCAN1TXDSR1_DB4
mCAN1TDSR1_DB5:                          equ        mCAN1TXDSR1_DB5
mCAN1TDSR1_DB6:                          equ        mCAN1TXDSR1_DB6
mCAN1TDSR1_DB7:                          equ        mCAN1TXDSR1_DB7
CAN1TDSR2:                               equ        CAN1TXDSR2
CAN1TDSR2_DB0:                           equ        CAN1TXDSR2_DB0
CAN1TDSR2_DB1:                           equ        CAN1TXDSR2_DB1
CAN1TDSR2_DB2:                           equ        CAN1TXDSR2_DB2
CAN1TDSR2_DB3:                           equ        CAN1TXDSR2_DB3
CAN1TDSR2_DB4:                           equ        CAN1TXDSR2_DB4
CAN1TDSR2_DB5:                           equ        CAN1TXDSR2_DB5
CAN1TDSR2_DB6:                           equ        CAN1TXDSR2_DB6
CAN1TDSR2_DB7:                           equ        CAN1TXDSR2_DB7
mCAN1TDSR2_DB0:                          equ        mCAN1TXDSR2_DB0
mCAN1TDSR2_DB1:                          equ        mCAN1TXDSR2_DB1
mCAN1TDSR2_DB2:                          equ        mCAN1TXDSR2_DB2
mCAN1TDSR2_DB3:                          equ        mCAN1TXDSR2_DB3
mCAN1TDSR2_DB4:                          equ        mCAN1TXDSR2_DB4
mCAN1TDSR2_DB5:                          equ        mCAN1TXDSR2_DB5
mCAN1TDSR2_DB6:                          equ        mCAN1TXDSR2_DB6
mCAN1TDSR2_DB7:                          equ        mCAN1TXDSR2_DB7
CAN1TDSR3:                               equ        CAN1TXDSR3
CAN1TDSR3_DB0:                           equ        CAN1TXDSR3_DB0
CAN1TDSR3_DB1:                           equ        CAN1TXDSR3_DB1
CAN1TDSR3_DB2:                           equ        CAN1TXDSR3_DB2
CAN1TDSR3_DB3:                           equ        CAN1TXDSR3_DB3
CAN1TDSR3_DB4:                           equ        CAN1TXDSR3_DB4
CAN1TDSR3_DB5:                           equ        CAN1TXDSR3_DB5
CAN1TDSR3_DB6:                           equ        CAN1TXDSR3_DB6
CAN1TDSR3_DB7:                           equ        CAN1TXDSR3_DB7
mCAN1TDSR3_DB0:                          equ        mCAN1TXDSR3_DB0
mCAN1TDSR3_DB1:                          equ        mCAN1TXDSR3_DB1
mCAN1TDSR3_DB2:                          equ        mCAN1TXDSR3_DB2
mCAN1TDSR3_DB3:                          equ        mCAN1TXDSR3_DB3
mCAN1TDSR3_DB4:                          equ        mCAN1TXDSR3_DB4
mCAN1TDSR3_DB5:                          equ        mCAN1TXDSR3_DB5
mCAN1TDSR3_DB6:                          equ        mCAN1TXDSR3_DB6
mCAN1TDSR3_DB7:                          equ        mCAN1TXDSR3_DB7
CAN1TDSR4:                               equ        CAN1TXDSR4
CAN1TDSR4_DB0:                           equ        CAN1TXDSR4_DB0
CAN1TDSR4_DB1:                           equ        CAN1TXDSR4_DB1
CAN1TDSR4_DB2:                           equ        CAN1TXDSR4_DB2
CAN1TDSR4_DB3:                           equ        CAN1TXDSR4_DB3
CAN1TDSR4_DB4:                           equ        CAN1TXDSR4_DB4
CAN1TDSR4_DB5:                           equ        CAN1TXDSR4_DB5
CAN1TDSR4_DB6:                           equ        CAN1TXDSR4_DB6
CAN1TDSR4_DB7:                           equ        CAN1TXDSR4_DB7
mCAN1TDSR4_DB0:                          equ        mCAN1TXDSR4_DB0
mCAN1TDSR4_DB1:                          equ        mCAN1TXDSR4_DB1
mCAN1TDSR4_DB2:                          equ        mCAN1TXDSR4_DB2
mCAN1TDSR4_DB3:                          equ        mCAN1TXDSR4_DB3
mCAN1TDSR4_DB4:                          equ        mCAN1TXDSR4_DB4
mCAN1TDSR4_DB5:                          equ        mCAN1TXDSR4_DB5
mCAN1TDSR4_DB6:                          equ        mCAN1TXDSR4_DB6
mCAN1TDSR4_DB7:                          equ        mCAN1TXDSR4_DB7
CAN1TDSR5:                               equ        CAN1TXDSR5
CAN1TDSR5_DB0:                           equ        CAN1TXDSR5_DB0
CAN1TDSR5_DB1:                           equ        CAN1TXDSR5_DB1
CAN1TDSR5_DB2:                           equ        CAN1TXDSR5_DB2
CAN1TDSR5_DB3:                           equ        CAN1TXDSR5_DB3
CAN1TDSR5_DB4:                           equ        CAN1TXDSR5_DB4
CAN1TDSR5_DB5:                           equ        CAN1TXDSR5_DB5
CAN1TDSR5_DB6:                           equ        CAN1TXDSR5_DB6
CAN1TDSR5_DB7:                           equ        CAN1TXDSR5_DB7
mCAN1TDSR5_DB0:                          equ        mCAN1TXDSR5_DB0
mCAN1TDSR5_DB1:                          equ        mCAN1TXDSR5_DB1
mCAN1TDSR5_DB2:                          equ        mCAN1TXDSR5_DB2
mCAN1TDSR5_DB3:                          equ        mCAN1TXDSR5_DB3
mCAN1TDSR5_DB4:                          equ        mCAN1TXDSR5_DB4
mCAN1TDSR5_DB5:                          equ        mCAN1TXDSR5_DB5
mCAN1TDSR5_DB6:                          equ        mCAN1TXDSR5_DB6
mCAN1TDSR5_DB7:                          equ        mCAN1TXDSR5_DB7
CAN1TDSR6:                               equ        CAN1TXDSR6
CAN1TDSR6_DB0:                           equ        CAN1TXDSR6_DB0
CAN1TDSR6_DB1:                           equ        CAN1TXDSR6_DB1
CAN1TDSR6_DB2:                           equ        CAN1TXDSR6_DB2
CAN1TDSR6_DB3:                           equ        CAN1TXDSR6_DB3
CAN1TDSR6_DB4:                           equ        CAN1TXDSR6_DB4
CAN1TDSR6_DB5:                           equ        CAN1TXDSR6_DB5
CAN1TDSR6_DB6:                           equ        CAN1TXDSR6_DB6
CAN1TDSR6_DB7:                           equ        CAN1TXDSR6_DB7
mCAN1TDSR6_DB0:                          equ        mCAN1TXDSR6_DB0
mCAN1TDSR6_DB1:                          equ        mCAN1TXDSR6_DB1
mCAN1TDSR6_DB2:                          equ        mCAN1TXDSR6_DB2
mCAN1TDSR6_DB3:                          equ        mCAN1TXDSR6_DB3
mCAN1TDSR6_DB4:                          equ        mCAN1TXDSR6_DB4
mCAN1TDSR6_DB5:                          equ        mCAN1TXDSR6_DB5
mCAN1TDSR6_DB6:                          equ        mCAN1TXDSR6_DB6
mCAN1TDSR6_DB7:                          equ        mCAN1TXDSR6_DB7
CAN1TDSR7:                               equ        CAN1TXDSR7
CAN1TDSR7_DB0:                           equ        CAN1TXDSR7_DB0
CAN1TDSR7_DB1:                           equ        CAN1TXDSR7_DB1
CAN1TDSR7_DB2:                           equ        CAN1TXDSR7_DB2
CAN1TDSR7_DB3:                           equ        CAN1TXDSR7_DB3
CAN1TDSR7_DB4:                           equ        CAN1TXDSR7_DB4
CAN1TDSR7_DB5:                           equ        CAN1TXDSR7_DB5
CAN1TDSR7_DB6:                           equ        CAN1TXDSR7_DB6
CAN1TDSR7_DB7:                           equ        CAN1TXDSR7_DB7
mCAN1TDSR7_DB0:                          equ        mCAN1TXDSR7_DB0
mCAN1TDSR7_DB1:                          equ        mCAN1TXDSR7_DB1
mCAN1TDSR7_DB2:                          equ        mCAN1TXDSR7_DB2
mCAN1TDSR7_DB3:                          equ        mCAN1TXDSR7_DB3
mCAN1TDSR7_DB4:                          equ        mCAN1TXDSR7_DB4
mCAN1TDSR7_DB5:                          equ        mCAN1TXDSR7_DB5
mCAN1TDSR7_DB6:                          equ        mCAN1TXDSR7_DB6
mCAN1TDSR7_DB7:                          equ        mCAN1TXDSR7_DB7
CAN1TDLR:                                equ        CAN1TXDLR
CAN1TDLR_DLC0:                           equ        CAN1TXDLR_DLC0
CAN1TDLR_DLC1:                           equ        CAN1TXDLR_DLC1
CAN1TDLR_DLC2:                           equ        CAN1TXDLR_DLC2
CAN1TDLR_DLC3:                           equ        CAN1TXDLR_DLC3
mCAN1TDLR_DLC0:                          equ        mCAN1TXDLR_DLC0
mCAN1TDLR_DLC1:                          equ        mCAN1TXDLR_DLC1
mCAN1TDLR_DLC2:                          equ        mCAN1TXDLR_DLC2
mCAN1TDLR_DLC3:                          equ        mCAN1TXDLR_DLC3
CAN1TTBPR:                               equ        CAN1TXTBPR
CAN1TTBPR_PRIO0:                         equ        CAN1TXTBPR_PRIO0
CAN1TTBPR_PRIO1:                         equ        CAN1TXTBPR_PRIO1
CAN1TTBPR_PRIO2:                         equ        CAN1TXTBPR_PRIO2
CAN1TTBPR_PRIO3:                         equ        CAN1TXTBPR_PRIO3
CAN1TTBPR_PRIO4:                         equ        CAN1TXTBPR_PRIO4
CAN1TTBPR_PRIO5:                         equ        CAN1TXTBPR_PRIO5
CAN1TTBPR_PRIO6:                         equ        CAN1TXTBPR_PRIO6
CAN1TTBPR_PRIO7:                         equ        CAN1TXTBPR_PRIO7
mCAN1TTBPR_PRIO0:                        equ        mCAN1TXTBPR_PRIO0
mCAN1TTBPR_PRIO1:                        equ        mCAN1TXTBPR_PRIO1
mCAN1TTBPR_PRIO2:                        equ        mCAN1TXTBPR_PRIO2
mCAN1TTBPR_PRIO3:                        equ        mCAN1TXTBPR_PRIO3
mCAN1TTBPR_PRIO4:                        equ        mCAN1TXTBPR_PRIO4
mCAN1TTBPR_PRIO5:                        equ        mCAN1TXTBPR_PRIO5
mCAN1TTBPR_PRIO6:                        equ        mCAN1TXTBPR_PRIO6
mCAN1TTBPR_PRIO7:                        equ        mCAN1TXTBPR_PRIO7
CAN1TTSR:                                equ        CAN1TXTSR
CAN1TTSR_TSR0:                           equ        CAN1TXTSR_TSR0
CAN1TTSR_TSR1:                           equ        CAN1TXTSR_TSR1
CAN1TTSR_TSR2:                           equ        CAN1TXTSR_TSR2
CAN1TTSR_TSR3:                           equ        CAN1TXTSR_TSR3
CAN1TTSR_TSR4:                           equ        CAN1TXTSR_TSR4
CAN1TTSR_TSR5:                           equ        CAN1TXTSR_TSR5
CAN1TTSR_TSR6:                           equ        CAN1TXTSR_TSR6
CAN1TTSR_TSR7:                           equ        CAN1TXTSR_TSR7
CAN1TTSR_TSR8:                           equ        CAN1TXTSR_TSR8
CAN1TTSR_TSR9:                           equ        CAN1TXTSR_TSR9
CAN1TTSR_TSR10:                          equ        CAN1TXTSR_TSR10
CAN1TTSR_TSR11:                          equ        CAN1TXTSR_TSR11
CAN1TTSR_TSR12:                          equ        CAN1TXTSR_TSR12
CAN1TTSR_TSR13:                          equ        CAN1TXTSR_TSR13
CAN1TTSR_TSR14:                          equ        CAN1TXTSR_TSR14
CAN1TTSR_TSR15:                          equ        CAN1TXTSR_TSR15
mCAN1TTSR_TSR0:                          equ        mCAN1TXTSR_TSR0
mCAN1TTSR_TSR1:                          equ        mCAN1TXTSR_TSR1
mCAN1TTSR_TSR2:                          equ        mCAN1TXTSR_TSR2
mCAN1TTSR_TSR3:                          equ        mCAN1TXTSR_TSR3
mCAN1TTSR_TSR4:                          equ        mCAN1TXTSR_TSR4
mCAN1TTSR_TSR5:                          equ        mCAN1TXTSR_TSR5
mCAN1TTSR_TSR6:                          equ        mCAN1TXTSR_TSR6
mCAN1TTSR_TSR7:                          equ        mCAN1TXTSR_TSR7
mCAN1TTSR_TSR8:                          equ        mCAN1TXTSR_TSR8
mCAN1TTSR_TSR9:                          equ        mCAN1TXTSR_TSR9
mCAN1TTSR_TSR10:                         equ        mCAN1TXTSR_TSR10
mCAN1TTSR_TSR11:                         equ        mCAN1TXTSR_TSR11
mCAN1TTSR_TSR12:                         equ        mCAN1TXTSR_TSR12
mCAN1TTSR_TSR13:                         equ        mCAN1TXTSR_TSR13
mCAN1TTSR_TSR14:                         equ        mCAN1TXTSR_TSR14
mCAN1TTSR_TSR15:                         equ        mCAN1TXTSR_TSR15
CAN1TTSRH:                               equ        CAN1TXTSRH
CAN1TTSRH_TSR8:                          equ        CAN1TXTSRH_TSR8
CAN1TTSRH_TSR9:                          equ        CAN1TXTSRH_TSR9
CAN1TTSRH_TSR10:                         equ        CAN1TXTSRH_TSR10
CAN1TTSRH_TSR11:                         equ        CAN1TXTSRH_TSR11
CAN1TTSRH_TSR12:                         equ        CAN1TXTSRH_TSR12
CAN1TTSRH_TSR13:                         equ        CAN1TXTSRH_TSR13
CAN1TTSRH_TSR14:                         equ        CAN1TXTSRH_TSR14
CAN1TTSRH_TSR15:                         equ        CAN1TXTSRH_TSR15
mCAN1TTSRH_TSR8:                         equ        mCAN1TXTSRH_TSR8
mCAN1TTSRH_TSR9:                         equ        mCAN1TXTSRH_TSR9
mCAN1TTSRH_TSR10:                        equ        mCAN1TXTSRH_TSR10
mCAN1TTSRH_TSR11:                        equ        mCAN1TXTSRH_TSR11
mCAN1TTSRH_TSR12:                        equ        mCAN1TXTSRH_TSR12
mCAN1TTSRH_TSR13:                        equ        mCAN1TXTSRH_TSR13
mCAN1TTSRH_TSR14:                        equ        mCAN1TXTSRH_TSR14
mCAN1TTSRH_TSR15:                        equ        mCAN1TXTSRH_TSR15
CAN1TTSRL:                               equ        CAN1TXTSRL
CAN1TTSRL_TSR0:                          equ        CAN1TXTSRL_TSR0
CAN1TTSRL_TSR1:                          equ        CAN1TXTSRL_TSR1
CAN1TTSRL_TSR2:                          equ        CAN1TXTSRL_TSR2
CAN1TTSRL_TSR3:                          equ        CAN1TXTSRL_TSR3
CAN1TTSRL_TSR4:                          equ        CAN1TXTSRL_TSR4
CAN1TTSRL_TSR5:                          equ        CAN1TXTSRL_TSR5
CAN1TTSRL_TSR6:                          equ        CAN1TXTSRL_TSR6
CAN1TTSRL_TSR7:                          equ        CAN1TXTSRL_TSR7
mCAN1TTSRL_TSR0:                         equ        mCAN1TXTSRL_TSR0
mCAN1TTSRL_TSR1:                         equ        mCAN1TXTSRL_TSR1
mCAN1TTSRL_TSR2:                         equ        mCAN1TXTSRL_TSR2
mCAN1TTSRL_TSR3:                         equ        mCAN1TXTSRL_TSR3
mCAN1TTSRL_TSR4:                         equ        mCAN1TXTSRL_TSR4
mCAN1TTSRL_TSR5:                         equ        mCAN1TXTSRL_TSR5
mCAN1TTSRL_TSR6:                         equ        mCAN1TXTSRL_TSR6
mCAN1TTSRL_TSR7:                         equ        mCAN1TXTSRL_TSR7
        IFNDEF __GENERATE_APPLICATION__
NVFPROT_NV6:                             equ        This_symb_has_been_depreciated
mNVFPROT_NV6:                            equ        This_symb_has_been_depreciated
NVFSEC_NV2:                              equ        This_symb_has_been_depreciated
mNVFSEC_NV2:                             equ        This_symb_has_been_depreciated
NVFSEC_NV3:                              equ        This_symb_has_been_depreciated
mNVFSEC_NV3:                             equ        This_symb_has_been_depreciated
NVFSEC_NV4:                              equ        This_symb_has_been_depreciated
mNVFSEC_NV4:                             equ        This_symb_has_been_depreciated
NVFSEC_NV5:                              equ        This_symb_has_been_depreciated
mNVFSEC_NV5:                             equ        This_symb_has_been_depreciated
NVFSEC_NV6:                              equ        This_symb_has_been_depreciated
mNVFSEC_NV6:                             equ        This_symb_has_been_depreciated
NVFSEC_KEYEN:                            equ        This_symb_has_been_depreciated
mNVFSEC_KEYEN:                           equ        This_symb_has_been_depreciated
        ENDIF

; EOF
