/* Based on CPU DB MC9S12XHZ512_144, version 3.00.028 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12xhz384.h
**     Processor : MC9S12XHZ384CAG
**     FileFormat: V2.32
**     DataSheet : MC9S12XHZ512 Rev. 1.05 11/2008
**     Compiler  : CodeWarrior compiler
**     Date/Time : 7.6.2010, 15:34
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 03.04.2007, VV2.87.211:
**              - Added registers OCPD, MCCC8-11, MCDC8-11, DBGMFR.
**              - Renamed registers XGIF<0-7> ==> XGIF_<0-7>F_<0-7>0.
**              - Renamed bits DBGXDH[BIT0:7] ==> DBGXDH[BIT8:15], IBxCR[IBxEN,IBxIE,IBxSWAI] ==> IBxCR[IBEN,IBIE,IBSWAI],
**              - IBxSR[IBxB,IBxAL,IBxIF] ==> IBxSR[IBB,IBAL,IBIF], IBxFD[IBxCy] ==> IBxFD[IBCy], SCIxCR2[SCTIE] ==> SCIxCR2[TIE].
**              - Renamed CAN buffers (*RX/TX* ==> *R/T* (for example CAN1TXIDR1 ==> CAN1TIDR1)).
**              - Renamed bit groups INT_CFADDRGrp, XGCHIDGrp, XGVBRGrp, XGSWTGrp, XGSEMGrp ==> INT_CFADDR, XGCHID, XGVBR, XGSWT, XGSEM.
**              - Copied bits from FSEC to NVFSEC.
**              - Renamed bits TCxH[BITy] ==> TCxH[TCy], PAxH[BITy] ==> PAxH[PAxHy].
**              -   REASON: Bug-fix (#4382 in Issue Manager). 
**              - Added bits MMCCTL0[CS3E], COPCTL[WRTMASK], FCNFG[BKSEL0:1], FSTAT[FAIL], ESTAT[FAIL], RTZxCTL[SMS], SSDxCTL[FTST].     
**              - Added registers FADDR, FDATA, EADDR, EDATA, MCDC<0-11>_FAST.
**              - Removed bits PAxH[PAxH0:7], TCxH[TCx].
**              - Renamed CAN buffers (*R/T* ==> *RX/TX* (for example CAN1TIDR1 ==> CAN1TXIDR1)).
**              - Renamed registers ATDDIEN01 -> ATDDIEN, PORTAD0/1 ==> ATDPTAD0/1,
**              - IBxAD ==> IICx_IBAD, IBxFD ==> IICx_IBFD, IBxCR ==> IICx_IBCR, IBxSR ==> IICx_IBSR, IBxDR ==> IICx_IBDR, IBxCR2 ==> IICx_IBCR2.
**              - Renamed interrupt vectors ReservedX ==> VReservedX.
**              -   REASON: Bug-fix (#5381 in Issue Manager). 
**      - 14.11.2008, V3.00.0:
**              - Corrected definition of depreciated symbols.
**              -   REASON: Bug-fix(#6592 in Issue Manager).
**      - 14.11.2008, V3.00.1:
**              - Renamed bits IBCR2[ADR2:0] -> IBCR2[ADR10:8].
**              -   REASON: Bug-fix(#6799 in Issue Manager).
**
**     File-Format-Revisions:
**      - 10.05.2007, V2.16 :
**               - Changes have not affected this file (because they are related to another family)
**      - 05.06.2007, V2.17 :
**               - Changes have not affected this file (because they are related to another family)
**      - 19.07.2007, V2.18 :
**               - Improved number of blanked lines inside register structures
**      - 06.08.2007, V2.19 :
**               - CPUDB revisions generated ahead of the file-format revisions.
**      - 11.09.2007, V2.20 :
**               - Added comment about initialization of unbonded pins.
**      - 02.01.2008, V2.21 :
**               - Changes have not affected this file (because they are related to another family)
**      - 13.02.2008, V2.22 :
**               - Changes have not affected this file (because they are related to another family)
**      - 20.02.2008, V2.23 :
**               - Termination of pragma V30toV31Compatible added, #5708
**      - 03.07.2008, V2.24 :
**               - Added support for bits with name starting with number (like "1HZ")
**      - 28.11.2008, V2.25 :
**               - StandBy RAM array declaration for ANSI-C added
**      - 1.12.2008, V2.26 :
**               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
**      - 17.3.2009, V2.27 :
**               - Merged bit-group is not generated, if the name matches with another bit name in the register
**      - 6.4.2009, V2.28 :
**               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
**      - 3.8.2009, V2.29 :
**               - If there is just one bits group matching register name, single bits are not generated
**      - 10.9.2009, V2.30 :
**               - Fixed generation of registers arrays.
**      - 15.10.2009, V2.31 :
**               - Changes have not affected this file (because they are related to another family)
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12XHZ384_H
#define _MC9S12XHZ384_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vsi                119U
#define VectorNumber_VReserved118       118U
#define VectorNumber_VReserved117       117U
#define VectorNumber_VReserved116       116U
#define VectorNumber_VReserved115       115U
#define VectorNumber_VReserved114       114U
#define VectorNumber_VReserved113       113U
#define VectorNumber_VReserved112       112U
#define VectorNumber_VReserved111       111U
#define VectorNumber_VReserved110       110U
#define VectorNumber_VReserved109       109U
#define VectorNumber_VReserved108       108U
#define VectorNumber_VReserved107       107U
#define VectorNumber_VReserved106       106U
#define VectorNumber_VReserved105       105U
#define VectorNumber_VReserved104       104U
#define VectorNumber_VReserved103       103U
#define VectorNumber_VReserved102       102U
#define VectorNumber_VReserved101       101U
#define VectorNumber_VReserved100       100U
#define VectorNumber_VReserved99        99U
#define VectorNumber_VReserved98        98U
#define VectorNumber_VReserved97        97U
#define VectorNumber_VReserved96        96U
#define VectorNumber_VReserved95        95U
#define VectorNumber_VReserved94        94U
#define VectorNumber_VReserved93        93U
#define VectorNumber_VReserved92        92U
#define VectorNumber_VReserved91        91U
#define VectorNumber_VReserved90        90U
#define VectorNumber_VReserved89        89U
#define VectorNumber_VReserved88        88U
#define VectorNumber_VReserved87        87U
#define VectorNumber_VReserved86        86U
#define VectorNumber_VReserved85        85U
#define VectorNumber_VReserved84        84U
#define VectorNumber_VReserved83        83U
#define VectorNumber_VReserved82        82U
#define VectorNumber_VReserved81        81U
#define VectorNumber_VReserved80        80U
#define VectorNumber_Vxsramav           79U
#define VectorNumber_Vxsei              78U
#define VectorNumber_Vxst7              77U
#define VectorNumber_Vxst6              76U
#define VectorNumber_Vxst5              75U
#define VectorNumber_Vxst4              74U
#define VectorNumber_Vxst3              73U
#define VectorNumber_Vxst2              72U
#define VectorNumber_Vxst1              71U
#define VectorNumber_Vxst0              70U
#define VectorNumber_Vpit3              69U
#define VectorNumber_Vpit2              68U
#define VectorNumber_Vpit1              67U
#define VectorNumber_Vpit0              66U
#define VectorNumber_VReserved65        65U
#define VectorNumber_Vapi               64U
#define VectorNumber_Vlvi               63U
#define VectorNumber_Viic1              62U
#define VectorNumber_VReserved61        61U
#define VectorNumber_VReserved60        60U
#define VectorNumber_VReserved59        59U
#define VectorNumber_VReserved58        58U
#define VectorNumber_Vpwmesdn           57U
#define VectorNumber_VReserved56        56U
#define VectorNumber_VReserved55        55U
#define VectorNumber_VReserved54        54U
#define VectorNumber_VReserved53        53U
#define VectorNumber_Vmctimovf          52U
#define VectorNumber_Vssd5              51U
#define VectorNumber_Vssd3              50U
#define VectorNumber_Vssd2              49U
#define VectorNumber_Vssd1              48U
#define VectorNumber_Vssd0              47U
#define VectorNumber_Vssd4              46U
#define VectorNumber_VReserved45        45U
#define VectorNumber_VReserved44        44U
#define VectorNumber_Vcan1tx            43U
#define VectorNumber_Vcan1rx            42U
#define VectorNumber_Vcan1err           41U
#define VectorNumber_Vcan1wkup          40U
#define VectorNumber_Vcan0tx            39U
#define VectorNumber_Vcan0rx            38U
#define VectorNumber_Vcan0err           37U
#define VectorNumber_Vcan0wkup          36U
#define VectorNumber_Vflash             35U
#define VectorNumber_Veeprom            34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_VReserved32        32U
#define VectorNumber_Viic0              31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_Vcrgscm            29U
#define VectorNumber_Vcrgplllck         28U
#define VectorNumber_Vtimpabovf         27U
#define VectorNumber_Vtimmdcu           26U
#define VectorNumber_VReserved25        25U
#define VectorNumber_Vportad            24U
#define VectorNumber_VReserved23        23U
#define VectorNumber_Vatd               22U
#define VectorNumber_Vsci1              21U
#define VectorNumber_Vsci0              20U
#define VectorNumber_Vspi               19U
#define VectorNumber_Vtimpaie           18U
#define VectorNumber_Vtimpaaovf         17U
#define VectorNumber_Vtimovf            16U
#define VectorNumber_Vtimch7            15U
#define VectorNumber_Vtimch6            14U
#define VectorNumber_Vtimch5            13U
#define VectorNumber_Vtimch4            12U
#define VectorNumber_Vtimch3            11U
#define VectorNumber_Vtimch2            10U
#define VectorNumber_Vtimch1            9U
#define VectorNumber_Vtimch0            8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Virq               6U
#define VectorNumber_Vxirq              5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define Vsi                             0xFF10U
#define VReserved118                    0xFF12U
#define VReserved117                    0xFF14U
#define VReserved116                    0xFF16U
#define VReserved115                    0xFF18U
#define VReserved114                    0xFF1AU
#define VReserved113                    0xFF1CU
#define VReserved112                    0xFF1EU
#define VReserved111                    0xFF20U
#define VReserved110                    0xFF22U
#define VReserved109                    0xFF24U
#define VReserved108                    0xFF26U
#define VReserved107                    0xFF28U
#define VReserved106                    0xFF2AU
#define VReserved105                    0xFF2CU
#define VReserved104                    0xFF2EU
#define VReserved103                    0xFF30U
#define VReserved102                    0xFF32U
#define VReserved101                    0xFF34U
#define VReserved100                    0xFF36U
#define VReserved99                     0xFF38U
#define VReserved98                     0xFF3AU
#define VReserved97                     0xFF3CU
#define VReserved96                     0xFF3EU
#define VReserved95                     0xFF40U
#define VReserved94                     0xFF42U
#define VReserved93                     0xFF44U
#define VReserved92                     0xFF46U
#define VReserved91                     0xFF48U
#define VReserved90                     0xFF4AU
#define VReserved89                     0xFF4CU
#define VReserved88                     0xFF4EU
#define VReserved87                     0xFF50U
#define VReserved86                     0xFF52U
#define VReserved85                     0xFF54U
#define VReserved84                     0xFF56U
#define VReserved83                     0xFF58U
#define VReserved82                     0xFF5AU
#define VReserved81                     0xFF5CU
#define VReserved80                     0xFF5EU
#define Vxsramav                        0xFF60U
#define Vxsei                           0xFF62U
#define Vxst7                           0xFF64U
#define Vxst6                           0xFF66U
#define Vxst5                           0xFF68U
#define Vxst4                           0xFF6AU
#define Vxst3                           0xFF6CU
#define Vxst2                           0xFF6EU
#define Vxst1                           0xFF70U
#define Vxst0                           0xFF72U
#define Vpit3                           0xFF74U
#define Vpit2                           0xFF76U
#define Vpit1                           0xFF78U
#define Vpit0                           0xFF7AU
#define VReserved65                     0xFF7CU
#define Vapi                            0xFF7EU
#define Vlvi                            0xFF80U
#define Viic1                           0xFF82U
#define VReserved61                     0xFF84U
#define VReserved60                     0xFF86U
#define VReserved59                     0xFF88U
#define VReserved58                     0xFF8AU
#define Vpwmesdn                        0xFF8CU
#define VReserved56                     0xFF8EU
#define VReserved55                     0xFF90U
#define VReserved54                     0xFF92U
#define VReserved53                     0xFF94U
#define Vmctimovf                       0xFF96U
#define Vssd5                           0xFF98U
#define Vssd3                           0xFF9AU
#define Vssd2                           0xFF9CU
#define Vssd1                           0xFF9EU
#define Vssd0                           0xFFA0U
#define Vssd4                           0xFFA2U
#define VReserved45                     0xFFA4U
#define VReserved44                     0xFFA6U
#define Vcan1tx                         0xFFA8U
#define Vcan1rx                         0xFFAAU
#define Vcan1err                        0xFFACU
#define Vcan1wkup                       0xFFAEU
#define Vcan0tx                         0xFFB0U
#define Vcan0rx                         0xFFB2U
#define Vcan0err                        0xFFB4U
#define Vcan0wkup                       0xFFB6U
#define Vflash                          0xFFB8U
#define Veeprom                         0xFFBAU
#define VReserved33                     0xFFBCU
#define VReserved32                     0xFFBEU
#define Viic0                           0xFFC0U
#define VReserved30                     0xFFC2U
#define Vcrgscm                         0xFFC4U
#define Vcrgplllck                      0xFFC6U
#define Vtimpabovf                      0xFFC8U
#define Vtimmdcu                        0xFFCAU
#define VReserved25                     0xFFCCU
#define Vportad                         0xFFCEU
#define VReserved23                     0xFFD0U
#define Vatd                            0xFFD2U
#define Vsci1                           0xFFD4U
#define Vsci0                           0xFFD6U
#define Vspi                            0xFFD8U
#define Vtimpaie                        0xFFDAU
#define Vtimpaaovf                      0xFFDCU
#define Vtimovf                         0xFFDEU
#define Vtimch7                         0xFFE0U
#define Vtimch6                         0xFFE2U
#define Vtimch5                         0xFFE4U
#define Vtimch4                         0xFFE6U
#define Vtimch3                         0xFFE8U
#define Vtimch2                         0xFFEAU
#define Vtimch1                         0xFFECU
#define Vtimch0                         0xFFEEU
#define Vrti                            0xFFF0U
#define Virq                            0xFFF2U
#define Vxirq                           0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTAB - Port AB Data Register; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Data Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte PA0         :1;                                       /* Port A Bit 0 */
        byte PA1         :1;                                       /* Port A Bit 1 */
        byte PA2         :1;                                       /* Port A Bit 2 */
        byte PA3         :1;                                       /* Port A Bit 3 */
        byte PA4         :1;                                       /* Port A Bit 4 */
        byte PA5         :1;                                       /* Port A Bit 5 */
        byte PA6         :1;                                       /* Port A Bit 6 */
        byte PA7         :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_PA0                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA0
    #define PORTA_PA1                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA1
    #define PORTA_PA2                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA2
    #define PORTA_PA3                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA3
    #define PORTA_PA4                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA4
    #define PORTA_PA5                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA5
    #define PORTA_PA6                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA6
    #define PORTA_PA7                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA7
    
    #define PORTA_PA0_MASK              1U
    #define PORTA_PA1_MASK              2U
    #define PORTA_PA2_MASK              4U
    #define PORTA_PA3_MASK              8U
    #define PORTA_PA4_MASK              16U
    #define PORTA_PA5_MASK              32U
    #define PORTA_PA6_MASK              64U
    #define PORTA_PA7_MASK              128U
    

    /*** PORTB - Port B Data Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte PB0         :1;                                       /* Port B Bit 0 */
        byte PB1         :1;                                       /* Port B Bit 1 */
        byte PB2         :1;                                       /* Port B Bit 2 */
        byte PB3         :1;                                       /* Port B Bit 3 */
        byte PB4         :1;                                       /* Port B Bit 4 */
        byte PB5         :1;                                       /* Port B Bit 5 */
        byte PB6         :1;                                       /* Port B Bit 6 */
        byte PB7         :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_PB0                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB0
    #define PORTB_PB1                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB1
    #define PORTB_PB2                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB2
    #define PORTB_PB3                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB3
    #define PORTB_PB4                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB4
    #define PORTB_PB5                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB5
    #define PORTB_PB6                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB6
    #define PORTB_PB7                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB7
    
    #define PORTB_PB0_MASK              1U
    #define PORTB_PB1_MASK              2U
    #define PORTB_PB2_MASK              4U
    #define PORTB_PB3_MASK              8U
    #define PORTB_PB4_MASK              16U
    #define PORTB_PB5_MASK              32U
    #define PORTB_PB6_MASK              64U
    #define PORTB_PB7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PB0         :1;                                       /* Port B Bit 0 */
    word PB1         :1;                                       /* Port B Bit 1 */
    word PB2         :1;                                       /* Port B Bit 2 */
    word PB3         :1;                                       /* Port B Bit 3 */
    word PB4         :1;                                       /* Port B Bit 4 */
    word PB5         :1;                                       /* Port B Bit 5 */
    word PB6         :1;                                       /* Port B Bit 6 */
    word PB7         :1;                                       /* Port B Bit 7 */
    word PA0         :1;                                       /* Port A Bit 0 */
    word PA1         :1;                                       /* Port A Bit 1 */
    word PA2         :1;                                       /* Port A Bit 2 */
    word PA3         :1;                                       /* Port A Bit 3 */
    word PA4         :1;                                       /* Port A Bit 4 */
    word PA5         :1;                                       /* Port A Bit 5 */
    word PA6         :1;                                       /* Port A Bit 6 */
    word PA7         :1;                                       /* Port A Bit 7 */
  } Bits;
  struct {
    word grpPB   :8;
    word grpPA   :8;
  } MergedBits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000UL);
#define PORTAB                          _PORTAB.Word
#define PORTAB_PB0                      _PORTAB.Bits.PB0
#define PORTAB_PB1                      _PORTAB.Bits.PB1
#define PORTAB_PB2                      _PORTAB.Bits.PB2
#define PORTAB_PB3                      _PORTAB.Bits.PB3
#define PORTAB_PB4                      _PORTAB.Bits.PB4
#define PORTAB_PB5                      _PORTAB.Bits.PB5
#define PORTAB_PB6                      _PORTAB.Bits.PB6
#define PORTAB_PB7                      _PORTAB.Bits.PB7
#define PORTAB_PA0                      _PORTAB.Bits.PA0
#define PORTAB_PA1                      _PORTAB.Bits.PA1
#define PORTAB_PA2                      _PORTAB.Bits.PA2
#define PORTAB_PA3                      _PORTAB.Bits.PA3
#define PORTAB_PA4                      _PORTAB.Bits.PA4
#define PORTAB_PA5                      _PORTAB.Bits.PA5
#define PORTAB_PA6                      _PORTAB.Bits.PA6
#define PORTAB_PA7                      _PORTAB.Bits.PA7
#define PORTAB_PB                       _PORTAB.MergedBits.grpPB
#define PORTAB_PA                       _PORTAB.MergedBits.grpPA

#define PORTAB_PB0_MASK                 1U
#define PORTAB_PB1_MASK                 2U
#define PORTAB_PB2_MASK                 4U
#define PORTAB_PB3_MASK                 8U
#define PORTAB_PB4_MASK                 16U
#define PORTAB_PB5_MASK                 32U
#define PORTAB_PB6_MASK                 64U
#define PORTAB_PB7_MASK                 128U
#define PORTAB_PA0_MASK                 256U
#define PORTAB_PA1_MASK                 512U
#define PORTAB_PA2_MASK                 1024U
#define PORTAB_PA3_MASK                 2048U
#define PORTAB_PA4_MASK                 4096U
#define PORTAB_PA5_MASK                 8192U
#define PORTAB_PA6_MASK                 16384U
#define PORTAB_PA7_MASK                 32768U
#define PORTAB_PB_MASK                  255U
#define PORTAB_PB_BITNUM                0U
#define PORTAB_PA_MASK                  65280U
#define PORTAB_PA_BITNUM                8U


/*** DDRAB - Port AB Data Direction Register; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
        byte DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
        byte DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
        byte DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
        byte DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
        byte DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
        byte DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
        byte DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_DDRA0                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA0
    #define DDRA_DDRA1                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA1
    #define DDRA_DDRA2                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA2
    #define DDRA_DDRA3                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA3
    #define DDRA_DDRA4                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA4
    #define DDRA_DDRA5                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA5
    #define DDRA_DDRA6                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA6
    #define DDRA_DDRA7                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA7
    
    #define DDRA_DDRA0_MASK             1U
    #define DDRA_DDRA1_MASK             2U
    #define DDRA_DDRA2_MASK             4U
    #define DDRA_DDRA3_MASK             8U
    #define DDRA_DDRA4_MASK             16U
    #define DDRA_DDRA5_MASK             32U
    #define DDRA_DDRA6_MASK             64U
    #define DDRA_DDRA7_MASK             128U
    

    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
        byte DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
        byte DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
        byte DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
        byte DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
        byte DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
        byte DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
        byte DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_DDRB0                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB0
    #define DDRB_DDRB1                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB1
    #define DDRB_DDRB2                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB2
    #define DDRB_DDRB3                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB3
    #define DDRB_DDRB4                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB4
    #define DDRB_DDRB5                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB5
    #define DDRB_DDRB6                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB6
    #define DDRB_DDRB7                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB7
    
    #define DDRB_DDRB0_MASK             1U
    #define DDRB_DDRB1_MASK             2U
    #define DDRB_DDRB2_MASK             4U
    #define DDRB_DDRB3_MASK             8U
    #define DDRB_DDRB4_MASK             16U
    #define DDRB_DDRB5_MASK             32U
    #define DDRB_DDRB6_MASK             64U
    #define DDRB_DDRB7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
    word DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
    word DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
    word DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
    word DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
    word DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
    word DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
    word DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
    word DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
    word DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
    word DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
    word DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
    word DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
    word DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
    word DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
    word DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
  struct {
    word grpDDRB :8;
    word grpDDRA :8;
  } MergedBits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002UL);
#define DDRAB                           _DDRAB.Word
#define DDRAB_DDRB0                     _DDRAB.Bits.DDRB0
#define DDRAB_DDRB1                     _DDRAB.Bits.DDRB1
#define DDRAB_DDRB2                     _DDRAB.Bits.DDRB2
#define DDRAB_DDRB3                     _DDRAB.Bits.DDRB3
#define DDRAB_DDRB4                     _DDRAB.Bits.DDRB4
#define DDRAB_DDRB5                     _DDRAB.Bits.DDRB5
#define DDRAB_DDRB6                     _DDRAB.Bits.DDRB6
#define DDRAB_DDRB7                     _DDRAB.Bits.DDRB7
#define DDRAB_DDRA0                     _DDRAB.Bits.DDRA0
#define DDRAB_DDRA1                     _DDRAB.Bits.DDRA1
#define DDRAB_DDRA2                     _DDRAB.Bits.DDRA2
#define DDRAB_DDRA3                     _DDRAB.Bits.DDRA3
#define DDRAB_DDRA4                     _DDRAB.Bits.DDRA4
#define DDRAB_DDRA5                     _DDRAB.Bits.DDRA5
#define DDRAB_DDRA6                     _DDRAB.Bits.DDRA6
#define DDRAB_DDRA7                     _DDRAB.Bits.DDRA7
#define DDRAB_DDRB                      _DDRAB.MergedBits.grpDDRB
#define DDRAB_DDRA                      _DDRAB.MergedBits.grpDDRA

#define DDRAB_DDRB0_MASK                1U
#define DDRAB_DDRB1_MASK                2U
#define DDRAB_DDRB2_MASK                4U
#define DDRAB_DDRB3_MASK                8U
#define DDRAB_DDRB4_MASK                16U
#define DDRAB_DDRB5_MASK                32U
#define DDRAB_DDRB6_MASK                64U
#define DDRAB_DDRB7_MASK                128U
#define DDRAB_DDRA0_MASK                256U
#define DDRAB_DDRA1_MASK                512U
#define DDRAB_DDRA2_MASK                1024U
#define DDRAB_DDRA3_MASK                2048U
#define DDRAB_DDRA4_MASK                4096U
#define DDRAB_DDRA5_MASK                8192U
#define DDRAB_DDRA6_MASK                16384U
#define DDRAB_DDRA7_MASK                32768U
#define DDRAB_DDRB_MASK                 255U
#define DDRAB_DDRB_BITNUM               0U
#define DDRAB_DDRA_MASK                 65280U
#define DDRAB_DDRA_BITNUM               8U


/*** PORTCD - Port CD Data Register; 0x00000004 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTC - Port C Data Register; 0x00000004 ***/
    union {
      byte Byte;
      struct {
        byte PC0         :1;                                       /* Port C Bit 0 */
        byte PC1         :1;                                       /* Port C Bit 1 */
        byte PC2         :1;                                       /* Port C Bit 2 */
        byte PC3         :1;                                       /* Port C Bit 3 */
        byte PC4         :1;                                       /* Port C Bit 4 */
        byte PC5         :1;                                       /* Port C Bit 5 */
        byte PC6         :1;                                       /* Port C Bit 6 */
        byte PC7         :1;                                       /* Port C Bit 7 */
      } Bits;
    } PORTCSTR;
    #define PORTC                       _PORTCD.Overlap_STR.PORTCSTR.Byte
    #define PORTC_PC0                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC0
    #define PORTC_PC1                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC1
    #define PORTC_PC2                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC2
    #define PORTC_PC3                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC3
    #define PORTC_PC4                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC4
    #define PORTC_PC5                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC5
    #define PORTC_PC6                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC6
    #define PORTC_PC7                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC7
    
    #define PORTC_PC0_MASK              1U
    #define PORTC_PC1_MASK              2U
    #define PORTC_PC2_MASK              4U
    #define PORTC_PC3_MASK              8U
    #define PORTC_PC4_MASK              16U
    #define PORTC_PC5_MASK              32U
    #define PORTC_PC6_MASK              64U
    #define PORTC_PC7_MASK              128U
    

    /*** PORTD - Port D Data Register; 0x00000005 ***/
    union {
      byte Byte;
      struct {
        byte PD0         :1;                                       /* Port D Bit 0 */
        byte PD1         :1;                                       /* Port D Bit 1 */
        byte PD2         :1;                                       /* Port D Bit 2 */
        byte PD3         :1;                                       /* Port D Bit 3 */
        byte PD4         :1;                                       /* Port D Bit 4 */
        byte PD5         :1;                                       /* Port D Bit 5 */
        byte PD6         :1;                                       /* Port D Bit 6 */
        byte PD7         :1;                                       /* Port D Bit 7 */
      } Bits;
    } PORTDSTR;
    #define PORTD                       _PORTCD.Overlap_STR.PORTDSTR.Byte
    #define PORTD_PD0                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD0
    #define PORTD_PD1                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD1
    #define PORTD_PD2                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD2
    #define PORTD_PD3                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD3
    #define PORTD_PD4                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD4
    #define PORTD_PD5                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD5
    #define PORTD_PD6                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD6
    #define PORTD_PD7                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD7
    
    #define PORTD_PD0_MASK              1U
    #define PORTD_PD1_MASK              2U
    #define PORTD_PD2_MASK              4U
    #define PORTD_PD3_MASK              8U
    #define PORTD_PD4_MASK              16U
    #define PORTD_PD5_MASK              32U
    #define PORTD_PD6_MASK              64U
    #define PORTD_PD7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PD0         :1;                                       /* Port D Bit 0 */
    word PD1         :1;                                       /* Port D Bit 1 */
    word PD2         :1;                                       /* Port D Bit 2 */
    word PD3         :1;                                       /* Port D Bit 3 */
    word PD4         :1;                                       /* Port D Bit 4 */
    word PD5         :1;                                       /* Port D Bit 5 */
    word PD6         :1;                                       /* Port D Bit 6 */
    word PD7         :1;                                       /* Port D Bit 7 */
    word PC0         :1;                                       /* Port C Bit 0 */
    word PC1         :1;                                       /* Port C Bit 1 */
    word PC2         :1;                                       /* Port C Bit 2 */
    word PC3         :1;                                       /* Port C Bit 3 */
    word PC4         :1;                                       /* Port C Bit 4 */
    word PC5         :1;                                       /* Port C Bit 5 */
    word PC6         :1;                                       /* Port C Bit 6 */
    word PC7         :1;                                       /* Port C Bit 7 */
  } Bits;
  struct {
    word grpPD   :8;
    word grpPC   :8;
  } MergedBits;
} PORTCDSTR;
extern volatile PORTCDSTR _PORTCD @(REG_BASE + 0x00000004UL);
#define PORTCD                          _PORTCD.Word
#define PORTCD_PD0                      _PORTCD.Bits.PD0
#define PORTCD_PD1                      _PORTCD.Bits.PD1
#define PORTCD_PD2                      _PORTCD.Bits.PD2
#define PORTCD_PD3                      _PORTCD.Bits.PD3
#define PORTCD_PD4                      _PORTCD.Bits.PD4
#define PORTCD_PD5                      _PORTCD.Bits.PD5
#define PORTCD_PD6                      _PORTCD.Bits.PD6
#define PORTCD_PD7                      _PORTCD.Bits.PD7
#define PORTCD_PC0                      _PORTCD.Bits.PC0
#define PORTCD_PC1                      _PORTCD.Bits.PC1
#define PORTCD_PC2                      _PORTCD.Bits.PC2
#define PORTCD_PC3                      _PORTCD.Bits.PC3
#define PORTCD_PC4                      _PORTCD.Bits.PC4
#define PORTCD_PC5                      _PORTCD.Bits.PC5
#define PORTCD_PC6                      _PORTCD.Bits.PC6
#define PORTCD_PC7                      _PORTCD.Bits.PC7
#define PORTCD_PD                       _PORTCD.MergedBits.grpPD
#define PORTCD_PC                       _PORTCD.MergedBits.grpPC

#define PORTCD_PD0_MASK                 1U
#define PORTCD_PD1_MASK                 2U
#define PORTCD_PD2_MASK                 4U
#define PORTCD_PD3_MASK                 8U
#define PORTCD_PD4_MASK                 16U
#define PORTCD_PD5_MASK                 32U
#define PORTCD_PD6_MASK                 64U
#define PORTCD_PD7_MASK                 128U
#define PORTCD_PC0_MASK                 256U
#define PORTCD_PC1_MASK                 512U
#define PORTCD_PC2_MASK                 1024U
#define PORTCD_PC3_MASK                 2048U
#define PORTCD_PC4_MASK                 4096U
#define PORTCD_PC5_MASK                 8192U
#define PORTCD_PC6_MASK                 16384U
#define PORTCD_PC7_MASK                 32768U
#define PORTCD_PD_MASK                  255U
#define PORTCD_PD_BITNUM                0U
#define PORTCD_PC_MASK                  65280U
#define PORTCD_PC_BITNUM                8U


/*** DDRCD - Port CD Data Direction Register; 0x00000006 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRC - Port C Data Direction Register; 0x00000006 ***/
    union {
      byte Byte;
      struct {
        byte DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
        byte DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
        byte DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
        byte DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
        byte DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
        byte DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
        byte DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
        byte DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
      } Bits;
    } DDRCSTR;
    #define DDRC                        _DDRCD.Overlap_STR.DDRCSTR.Byte
    #define DDRC_DDRC0                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC0
    #define DDRC_DDRC1                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC1
    #define DDRC_DDRC2                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC2
    #define DDRC_DDRC3                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC3
    #define DDRC_DDRC4                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC4
    #define DDRC_DDRC5                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC5
    #define DDRC_DDRC6                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC6
    #define DDRC_DDRC7                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC7
    
    #define DDRC_DDRC0_MASK             1U
    #define DDRC_DDRC1_MASK             2U
    #define DDRC_DDRC2_MASK             4U
    #define DDRC_DDRC3_MASK             8U
    #define DDRC_DDRC4_MASK             16U
    #define DDRC_DDRC5_MASK             32U
    #define DDRC_DDRC6_MASK             64U
    #define DDRC_DDRC7_MASK             128U
    

    /*** DDRD - Port D Data Direction Register; 0x00000007 ***/
    union {
      byte Byte;
      struct {
        byte DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
        byte DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
        byte DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
        byte DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
        byte DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
        byte DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
        byte DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
        byte DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
      } Bits;
    } DDRDSTR;
    #define DDRD                        _DDRCD.Overlap_STR.DDRDSTR.Byte
    #define DDRD_DDRD0                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD0
    #define DDRD_DDRD1                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD1
    #define DDRD_DDRD2                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD2
    #define DDRD_DDRD3                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD3
    #define DDRD_DDRD4                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD4
    #define DDRD_DDRD5                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD5
    #define DDRD_DDRD6                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD6
    #define DDRD_DDRD7                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD7
    
    #define DDRD_DDRD0_MASK             1U
    #define DDRD_DDRD1_MASK             2U
    #define DDRD_DDRD2_MASK             4U
    #define DDRD_DDRD3_MASK             8U
    #define DDRD_DDRD4_MASK             16U
    #define DDRD_DDRD5_MASK             32U
    #define DDRD_DDRD6_MASK             64U
    #define DDRD_DDRD7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
    word DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
    word DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
    word DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
    word DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
    word DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
    word DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
    word DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
    word DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
    word DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
    word DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
    word DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
    word DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
    word DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
    word DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
    word DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
  } Bits;
  struct {
    word grpDDRD :8;
    word grpDDRC :8;
  } MergedBits;
} DDRCDSTR;
extern volatile DDRCDSTR _DDRCD @(REG_BASE + 0x00000006UL);
#define DDRCD                           _DDRCD.Word
#define DDRCD_DDRD0                     _DDRCD.Bits.DDRD0
#define DDRCD_DDRD1                     _DDRCD.Bits.DDRD1
#define DDRCD_DDRD2                     _DDRCD.Bits.DDRD2
#define DDRCD_DDRD3                     _DDRCD.Bits.DDRD3
#define DDRCD_DDRD4                     _DDRCD.Bits.DDRD4
#define DDRCD_DDRD5                     _DDRCD.Bits.DDRD5
#define DDRCD_DDRD6                     _DDRCD.Bits.DDRD6
#define DDRCD_DDRD7                     _DDRCD.Bits.DDRD7
#define DDRCD_DDRC0                     _DDRCD.Bits.DDRC0
#define DDRCD_DDRC1                     _DDRCD.Bits.DDRC1
#define DDRCD_DDRC2                     _DDRCD.Bits.DDRC2
#define DDRCD_DDRC3                     _DDRCD.Bits.DDRC3
#define DDRCD_DDRC4                     _DDRCD.Bits.DDRC4
#define DDRCD_DDRC5                     _DDRCD.Bits.DDRC5
#define DDRCD_DDRC6                     _DDRCD.Bits.DDRC6
#define DDRCD_DDRC7                     _DDRCD.Bits.DDRC7
#define DDRCD_DDRD                      _DDRCD.MergedBits.grpDDRD
#define DDRCD_DDRC                      _DDRCD.MergedBits.grpDDRC

#define DDRCD_DDRD0_MASK                1U
#define DDRCD_DDRD1_MASK                2U
#define DDRCD_DDRD2_MASK                4U
#define DDRCD_DDRD3_MASK                8U
#define DDRCD_DDRD4_MASK                16U
#define DDRCD_DDRD5_MASK                32U
#define DDRCD_DDRD6_MASK                64U
#define DDRCD_DDRD7_MASK                128U
#define DDRCD_DDRC0_MASK                256U
#define DDRCD_DDRC1_MASK                512U
#define DDRCD_DDRC2_MASK                1024U
#define DDRCD_DDRC3_MASK                2048U
#define DDRCD_DDRC4_MASK                4096U
#define DDRCD_DDRC5_MASK                8192U
#define DDRCD_DDRC6_MASK                16384U
#define DDRCD_DDRC7_MASK                32768U
#define DDRCD_DDRD_MASK                 255U
#define DDRCD_DDRD_BITNUM               0U
#define DDRCD_DDRC_MASK                 65280U
#define DDRCD_DDRC_BITNUM               8U


/*** PORTE - Port E Data Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Port E Bit 0 */
    byte PE1         :1;                                       /* Port E Bit 1 */
    byte PE2         :1;                                       /* Port E Bit 2 */
    byte PE3         :1;                                       /* Port E Bit 3 */
    byte PE4         :1;                                       /* Port E Bit 4 */
    byte PE5         :1;                                       /* Port E Bit 5 */
    byte PE6         :1;                                       /* Port E Bit 6 */
    byte PE7         :1;                                       /* Port E Bit 7 */
  } Bits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008UL);
#define PORTE                           _PORTE.Byte
#define PORTE_PE0                       _PORTE.Bits.PE0
#define PORTE_PE1                       _PORTE.Bits.PE1
#define PORTE_PE2                       _PORTE.Bits.PE2
#define PORTE_PE3                       _PORTE.Bits.PE3
#define PORTE_PE4                       _PORTE.Bits.PE4
#define PORTE_PE5                       _PORTE.Bits.PE5
#define PORTE_PE6                       _PORTE.Bits.PE6
#define PORTE_PE7                       _PORTE.Bits.PE7

#define PORTE_PE0_MASK                  1U
#define PORTE_PE1_MASK                  2U
#define PORTE_PE2_MASK                  4U
#define PORTE_PE3_MASK                  8U
#define PORTE_PE4_MASK                  16U
#define PORTE_PE5_MASK                  32U
#define PORTE_PE6_MASK                  64U
#define PORTE_PE7_MASK                  128U


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte DDRE2       :1;                                       /* Data Direction Port E Bit 2 */
    byte DDRE3       :1;                                       /* Data Direction Port E Bit 3 */
    byte DDRE4       :1;                                       /* Data Direction Port E Bit 4 */
    byte DDRE5       :1;                                       /* Data Direction Port E Bit 5 */
    byte DDRE6       :1;                                       /* Data Direction Port E Bit 6 */
    byte DDRE7       :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpDDRE_2 :6;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009UL);
#define DDRE                            _DDRE.Byte
#define DDRE_DDRE2                      _DDRE.Bits.DDRE2
#define DDRE_DDRE3                      _DDRE.Bits.DDRE3
#define DDRE_DDRE4                      _DDRE.Bits.DDRE4
#define DDRE_DDRE5                      _DDRE.Bits.DDRE5
#define DDRE_DDRE6                      _DDRE.Bits.DDRE6
#define DDRE_DDRE7                      _DDRE.Bits.DDRE7
#define DDRE_DDRE_2                     _DDRE.MergedBits.grpDDRE_2

#define DDRE_DDRE2_MASK                 4U
#define DDRE_DDRE3_MASK                 8U
#define DDRE_DDRE4_MASK                 16U
#define DDRE_DDRE5_MASK                 32U
#define DDRE_DDRE6_MASK                 64U
#define DDRE_DDRE7_MASK                 128U
#define DDRE_DDRE_2_MASK                252U
#define DDRE_DDRE_2_BITNUM              2U


/*** MMCCTL0 - MMC Control Register; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte CS0E        :1;                                       /* Chip Select 0 Enables */
    byte CS1E        :1;                                       /* Chip Select 1 Enables */
    byte CS2E        :1;                                       /* Chip Select 2 Enables */
    byte CS3E        :1;                                       /* Chip Select 3 Enables */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MMCCTL0STR;
extern volatile MMCCTL0STR _MMCCTL0 @(REG_BASE + 0x0000000AUL);
#define MMCCTL0                         _MMCCTL0.Byte
#define MMCCTL0_CS0E                    _MMCCTL0.Bits.CS0E
#define MMCCTL0_CS1E                    _MMCCTL0.Bits.CS1E
#define MMCCTL0_CS2E                    _MMCCTL0.Bits.CS2E
#define MMCCTL0_CS3E                    _MMCCTL0.Bits.CS3E

#define MMCCTL0_CS0E_MASK               1U
#define MMCCTL0_CS1E_MASK               2U
#define MMCCTL0_CS2E_MASK               4U
#define MMCCTL0_CS3E_MASK               8U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit */
    byte MODB        :1;                                       /* Mode Select Bit */
    byte MODC        :1;                                       /* Mode Select Bit */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_MODA_MASK                  32U
#define MODE_MODB_MASK                  64U
#define MODE_MODC_MASK                  128U
#define MODE_MODx_MASK                  224U
#define MODE_MODx_BITNUM                5U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-up Port B Enable */
    byte PUPCE       :1;                                       /* Pull-up Port C Enable */
    byte PUPDE       :1;                                       /* Pull-up Port D Enable */
    byte PUPEE       :1;                                       /* Pull-up Port E Enable */
    byte             :1; 
    byte BKPUE       :1;                                       /* BKGD and VREGEN Pin Pull-up Enable */
    byte PUPKE       :1;                                       /* Pull-up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPCE                      _PUCR.Bits.PUPCE
#define PUCR_PUPDE                      _PUCR.Bits.PUPDE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_BKPUE                      _PUCR.Bits.BKPUE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1U
#define PUCR_PUPBE_MASK                 2U
#define PUCR_PUPCE_MASK                 4U
#define PUCR_PUPDE_MASK                 8U
#define PUCR_PUPEE_MASK                 16U
#define PUCR_BKPUE_MASK                 64U
#define PUCR_PUPKE_MASK                 128U


/*** RDRIV - Reduced Drive Register; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte RDPC        :1;                                       /* Reduced Drive of Port C */
    byte RDPD        :1;                                       /* Reduced Drive of Port D */
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPC                      _RDRIV.Bits.RDPC
#define RDRIV_RDPD                      _RDRIV.Bits.RDPD
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1U
#define RDRIV_RDPB_MASK                 2U
#define RDRIV_RDPC_MASK                 4U
#define RDRIV_RDPD_MASK                 8U
#define RDRIV_RDPE_MASK                 16U
#define RDRIV_RDPK_MASK                 128U
#define RDRIV_RDPx_MASK                 31U
#define RDRIV_RDPx_BITNUM               0U


/*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte ASIZ0       :1;                                       /* External Address Bus Size Bit 0 */
    byte ASIZ1       :1;                                       /* External Address Bus Size Bit 1 */
    byte ASIZ2       :1;                                       /* External Address Bus Size Bit 2 */
    byte ASIZ3       :1;                                       /* External Address Bus Size Bit 3 */
    byte ASIZ4       :1;                                       /* External Address Bus Size Bit 4 */
    byte HDBE        :1;                                       /* High Data Byte Enable */
    byte             :1; 
    byte ITHRS       :1;                                       /* Reduced Input Threshold */
  } Bits;
  struct {
    byte grpASIZ :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} EBICTL0STR;
extern volatile EBICTL0STR _EBICTL0 @(REG_BASE + 0x0000000EUL);
#define EBICTL0                         _EBICTL0.Byte
#define EBICTL0_ASIZ0                   _EBICTL0.Bits.ASIZ0
#define EBICTL0_ASIZ1                   _EBICTL0.Bits.ASIZ1
#define EBICTL0_ASIZ2                   _EBICTL0.Bits.ASIZ2
#define EBICTL0_ASIZ3                   _EBICTL0.Bits.ASIZ3
#define EBICTL0_ASIZ4                   _EBICTL0.Bits.ASIZ4
#define EBICTL0_HDBE                    _EBICTL0.Bits.HDBE
#define EBICTL0_ITHRS                   _EBICTL0.Bits.ITHRS
/* EBICTL_ARR: Access 2 EBICTLx registers in an array */
#define EBICTL_ARR                      ((volatile byte *) &EBICTL0)
#define EBICTL0_ASIZ                    _EBICTL0.MergedBits.grpASIZ

#define EBICTL0_ASIZ0_MASK              1U
#define EBICTL0_ASIZ1_MASK              2U
#define EBICTL0_ASIZ2_MASK              4U
#define EBICTL0_ASIZ3_MASK              8U
#define EBICTL0_ASIZ4_MASK              16U
#define EBICTL0_HDBE_MASK               32U
#define EBICTL0_ITHRS_MASK              128U
#define EBICTL0_ASIZ_MASK               31U
#define EBICTL0_ASIZ_BITNUM             0U


/*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***/
typedef union {
  byte Byte;
  struct {
    byte EXSTR0      :1;                                       /* External Access Stretch Bit 0 */
    byte EXSTR1      :1;                                       /* External Access Stretch Bit 1 */
    byte EXSTR2      :1;                                       /* External Access Stretch Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte EWAITE      :1;                                       /* External Wait Enable */
  } Bits;
  struct {
    byte grpEXSTR :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} EBICTL1STR;
extern volatile EBICTL1STR _EBICTL1 @(REG_BASE + 0x0000000FUL);
#define EBICTL1                         _EBICTL1.Byte
#define EBICTL1_EXSTR0                  _EBICTL1.Bits.EXSTR0
#define EBICTL1_EXSTR1                  _EBICTL1.Bits.EXSTR1
#define EBICTL1_EXSTR2                  _EBICTL1.Bits.EXSTR2
#define EBICTL1_EWAITE                  _EBICTL1.Bits.EWAITE
#define EBICTL1_EXSTR                   _EBICTL1.MergedBits.grpEXSTR

#define EBICTL1_EXSTR0_MASK             1U
#define EBICTL1_EXSTR1_MASK             2U
#define EBICTL1_EXSTR2_MASK             4U
#define EBICTL1_EWAITE_MASK             128U
#define EBICTL1_EXSTR_MASK              7U
#define EBICTL1_EXSTR_BITNUM            0U


/*** GPAGE - Global Page Index Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte GP0         :1;                                       /* Global Page Index Bit 0 */
    byte GP1         :1;                                       /* Global Page Index Bit 1 */
    byte GP2         :1;                                       /* Global Page Index Bit 2 */
    byte GP3         :1;                                       /* Global Page Index Bit 3 */
    byte GP4         :1;                                       /* Global Page Index Bit 4 */
    byte GP5         :1;                                       /* Global Page Index Bit 5 */
    byte GP6         :1;                                       /* Global Page Index Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpGP   :7;
    byte         :1;
  } MergedBits;
} GPAGESTR;
extern volatile GPAGESTR _GPAGE @(REG_BASE + 0x00000010UL);
#define GPAGE                           _GPAGE.Byte
#define GPAGE_GP0                       _GPAGE.Bits.GP0
#define GPAGE_GP1                       _GPAGE.Bits.GP1
#define GPAGE_GP2                       _GPAGE.Bits.GP2
#define GPAGE_GP3                       _GPAGE.Bits.GP3
#define GPAGE_GP4                       _GPAGE.Bits.GP4
#define GPAGE_GP5                       _GPAGE.Bits.GP5
#define GPAGE_GP6                       _GPAGE.Bits.GP6
#define GPAGE_GP                        _GPAGE.MergedBits.grpGP

#define GPAGE_GP0_MASK                  1U
#define GPAGE_GP1_MASK                  2U
#define GPAGE_GP2_MASK                  4U
#define GPAGE_GP3_MASK                  8U
#define GPAGE_GP4_MASK                  16U
#define GPAGE_GP5_MASK                  32U
#define GPAGE_GP6_MASK                  64U
#define GPAGE_GP_MASK                   127U
#define GPAGE_GP_BITNUM                 0U


/*** DIRECT - Direct Page Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Index Bit 8 */
    byte DP9         :1;                                       /* Direct Page Index Bit 9 */
    byte DP10        :1;                                       /* Direct Page Index Bit 10 */
    byte DP11        :1;                                       /* Direct Page Index Bit 11 */
    byte DP12        :1;                                       /* Direct Page Index Bit 12 */
    byte DP13        :1;                                       /* Direct Page Index Bit 13 */
    byte DP14        :1;                                       /* Direct Page Index Bit 14 */
    byte DP15        :1;                                       /* Direct Page Index Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000011UL);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1U
#define DIRECT_DP9_MASK                 2U
#define DIRECT_DP10_MASK                4U
#define DIRECT_DP11_MASK                8U
#define DIRECT_DP12_MASK                16U
#define DIRECT_DP13_MASK                32U
#define DIRECT_DP14_MASK                64U
#define DIRECT_DP15_MASK                128U


/*** MMCCTL1 - MMC Control Register; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable FLASH or ROM in the memory map */
    byte ROMHM       :1;                                       /* FLASH or ROM only in higher Half of Memory Map */
    byte EROMON      :1;                                       /* Enables emulated Flash or ROM memory in the memory map */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MMCCTL1STR;
extern volatile MMCCTL1STR _MMCCTL1 @(REG_BASE + 0x00000013UL);
#define MMCCTL1                         _MMCCTL1.Byte
#define MMCCTL1_ROMON                   _MMCCTL1.Bits.ROMON
#define MMCCTL1_ROMHM                   _MMCCTL1.Bits.ROMHM
#define MMCCTL1_EROMON                  _MMCCTL1.Bits.EROMON

#define MMCCTL1_ROMON_MASK              1U
#define MMCCTL1_ROMHM_MASK              2U
#define MMCCTL1_EROMON_MASK             4U


/*** RPAGE - RAM Page Index Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte RP0         :1;                                       /* RAM Page Index Bit 0 */
    byte RP1         :1;                                       /* RAM Page Index Bit 1 */
    byte RP2         :1;                                       /* RAM Page Index Bit 2 */
    byte RP3         :1;                                       /* RAM Page Index Bit 3 */
    byte RP4         :1;                                       /* RAM Page Index Bit 4 */
    byte RP5         :1;                                       /* RAM Page Index Bit 5 */
    byte RP6         :1;                                       /* RAM Page Index Bit 6 */
    byte RP7         :1;                                       /* RAM Page Index Bit 7 */
  } Bits;
} RPAGESTR;
extern volatile RPAGESTR _RPAGE @(REG_BASE + 0x00000016UL);
#define RPAGE                           _RPAGE.Byte
#define RPAGE_RP0                       _RPAGE.Bits.RP0
#define RPAGE_RP1                       _RPAGE.Bits.RP1
#define RPAGE_RP2                       _RPAGE.Bits.RP2
#define RPAGE_RP3                       _RPAGE.Bits.RP3
#define RPAGE_RP4                       _RPAGE.Bits.RP4
#define RPAGE_RP5                       _RPAGE.Bits.RP5
#define RPAGE_RP6                       _RPAGE.Bits.RP6
#define RPAGE_RP7                       _RPAGE.Bits.RP7

#define RPAGE_RP0_MASK                  1U
#define RPAGE_RP1_MASK                  2U
#define RPAGE_RP2_MASK                  4U
#define RPAGE_RP3_MASK                  8U
#define RPAGE_RP4_MASK                  16U
#define RPAGE_RP5_MASK                  32U
#define RPAGE_RP6_MASK                  64U
#define RPAGE_RP7_MASK                  128U


/*** EPAGE - Data FLASH Page Index Register; 0x00000017 ***/
typedef union {
  byte Byte;
  struct {
    byte EP0         :1;                                       /* Data FLASH Page Index Bit 0 */
    byte EP1         :1;                                       /* Data FLASH Page Index Bit 1 */
    byte EP2         :1;                                       /* Data FLASH Page Index Bit 2 */
    byte EP3         :1;                                       /* Data FLASH Page Index Bit 3 */
    byte EP4         :1;                                       /* Data FLASH Page Index Bit 4 */
    byte EP5         :1;                                       /* Data FLASH Page Index Bit 5 */
    byte EP6         :1;                                       /* Data FLASH Page Index Bit 6 */
    byte EP7         :1;                                       /* Data FLASH Page Index Bit 7 */
  } Bits;
} EPAGESTR;
extern volatile EPAGESTR _EPAGE @(REG_BASE + 0x00000017UL);
#define EPAGE                           _EPAGE.Byte
#define EPAGE_EP0                       _EPAGE.Bits.EP0
#define EPAGE_EP1                       _EPAGE.Bits.EP1
#define EPAGE_EP2                       _EPAGE.Bits.EP2
#define EPAGE_EP3                       _EPAGE.Bits.EP3
#define EPAGE_EP4                       _EPAGE.Bits.EP4
#define EPAGE_EP5                       _EPAGE.Bits.EP5
#define EPAGE_EP6                       _EPAGE.Bits.EP6
#define EPAGE_EP7                       _EPAGE.Bits.EP7

#define EPAGE_EP0_MASK                  1U
#define EPAGE_EP1_MASK                  2U
#define EPAGE_EP2_MASK                  4U
#define EPAGE_EP3_MASK                  8U
#define EPAGE_EP4_MASK                  16U
#define EPAGE_EP5_MASK                  32U
#define EPAGE_EP6_MASK                  64U
#define EPAGE_EP7_MASK                  128U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** ECLKCTL - ECLK Control Register; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* Free-running ECLK Divider, bit 0 */
    byte EDIV1       :1;                                       /* Free-running ECLK Divider, bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte NCLKX2      :1;                                       /* No ECLKX2 */
    byte NECLK       :1;                                       /* No ECLK */
  } Bits;
  struct {
    byte grpEDIV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpNCLKX_2 :1;
    byte         :1;
  } MergedBits;
} ECLKCTLSTR;
extern volatile ECLKCTLSTR _ECLKCTL @(REG_BASE + 0x0000001CUL);
#define ECLKCTL                         _ECLKCTL.Byte
#define ECLKCTL_EDIV0                   _ECLKCTL.Bits.EDIV0
#define ECLKCTL_EDIV1                   _ECLKCTL.Bits.EDIV1
#define ECLKCTL_NCLKX2                  _ECLKCTL.Bits.NCLKX2
#define ECLKCTL_NECLK                   _ECLKCTL.Bits.NECLK
#define ECLKCTL_EDIV                    _ECLKCTL.MergedBits.grpEDIV

#define ECLKCTL_EDIV0_MASK              1U
#define ECLKCTL_EDIV1_MASK              2U
#define ECLKCTL_NCLKX2_MASK             64U
#define ECLKCTL_NECLK_MASK              128U
#define ECLKCTL_EDIV_MASK               3U
#define ECLKCTL_EDIV_BITNUM             0U


/*** IRQCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} IRQCRSTR;
extern volatile IRQCRSTR _IRQCR @(REG_BASE + 0x0000001EUL);
#define IRQCR                           _IRQCR.Byte
#define IRQCR_IRQEN                     _IRQCR.Bits.IRQEN
#define IRQCR_IRQE                      _IRQCR.Bits.IRQE

#define IRQCR_IRQEN_MASK                64U
#define IRQCR_IRQE_MASK                 128U


/*** SRCR - Reduced Drive Register; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte SRRA        :1;                                       /* Reduced Drive of Port A */
    byte SRRB        :1;                                       /* Reduced Drive of Port B */
    byte SRRC        :1;                                       /* Reduced Drive of Port C */
    byte SRRD        :1;                                       /* Reduced Drive of Port D */
    byte SRRE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte SRRK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpSRRx :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SRCRSTR;
extern volatile SRCRSTR _SRCR @(REG_BASE + 0x0000001FUL);
#define SRCR                            _SRCR.Byte
#define SRCR_SRRA                       _SRCR.Bits.SRRA
#define SRCR_SRRB                       _SRCR.Bits.SRRB
#define SRCR_SRRC                       _SRCR.Bits.SRRC
#define SRCR_SRRD                       _SRCR.Bits.SRRD
#define SRCR_SRRE                       _SRCR.Bits.SRRE
#define SRCR_SRRK                       _SRCR.Bits.SRRK
#define SRCR_SRRx                       _SRCR.MergedBits.grpSRRx

#define SRCR_SRRA_MASK                  1U
#define SRCR_SRRB_MASK                  2U
#define SRCR_SRRC_MASK                  4U
#define SRCR_SRRD_MASK                  8U
#define SRCR_SRRE_MASK                  16U
#define SRCR_SRRK_MASK                  128U
#define SRCR_SRRx_MASK                  31U
#define SRCR_SRRx_BITNUM                0U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte COMRV       :2;                                       /* Comparator Register Visibility Bits */
    byte DBGBRK      :2;                                       /* S12XDBG Breakpoint Enable Bits */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte XGSBPE      :1;                                       /* XGATE S/W Breakpoint Enable */
    byte TRIG        :1;                                       /* Immediate Trigger Request Bit */
    byte ARM         :1;                                       /* Arm Bit */
  } Bits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_COMRV                     _DBGC1.Bits.COMRV
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BDM                       _DBGC1.Bits.BDM
#define DBGC1_XGSBPE                    _DBGC1.Bits.XGSBPE
#define DBGC1_TRIG                      _DBGC1.Bits.TRIG
#define DBGC1_ARM                       _DBGC1.Bits.ARM

#define DBGC1_COMRV_MASK                3U
#define DBGC1_COMRV_BITNUM              0U
#define DBGC1_DBGBRK_MASK               12U
#define DBGC1_DBGBRK_BITNUM             2U
#define DBGC1_BDM_MASK                  16U
#define DBGC1_XGSBPE_MASK               32U
#define DBGC1_TRIG_MASK                 64U
#define DBGC1_ARM_MASK                  128U


/*** DBGSR - Debug Status Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSF0        :1;                                       /* State Sequencer Flag Bits */
    byte SSF1        :1;                                       /* State Sequencer Flag Bit 1 */
    byte SSF2        :1;                                       /* State Sequencer Flag Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte EXTF        :1;                                       /* External Tag Hit Flag */
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpSSF  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSRSTR;
extern volatile DBGSRSTR _DBGSR @(REG_BASE + 0x00000021UL);
#define DBGSR                           _DBGSR.Byte
#define DBGSR_SSF0                      _DBGSR.Bits.SSF0
#define DBGSR_SSF1                      _DBGSR.Bits.SSF1
#define DBGSR_SSF2                      _DBGSR.Bits.SSF2
#define DBGSR_EXTF                      _DBGSR.Bits.EXTF
#define DBGSR_TBF                       _DBGSR.Bits.TBF
#define DBGSR_SSF                       _DBGSR.MergedBits.grpSSF

#define DBGSR_SSF0_MASK                 1U
#define DBGSR_SSF1_MASK                 2U
#define DBGSR_SSF2_MASK                 4U
#define DBGSR_EXTF_MASK                 64U
#define DBGSR_TBF_MASK                  128U
#define DBGSR_SSF_MASK                  7U
#define DBGSR_SSF_BITNUM                0U


/*** DBGTCR - Debug Trace Control Register; 0x00000022 ***/
typedef union {
  byte Byte;
  struct {
    byte TALIGN      :2;                                       /* Trigger Align Bits */
    byte TRCMOD      :2;                                       /* Trace Mode Bits */
    byte TRANGE      :2;                                       /* Trace Range Bits */
    byte TSOURCE     :2;                                       /* Trace Source Control Bits */
  } Bits;
} DBGTCRSTR;
extern volatile DBGTCRSTR _DBGTCR @(REG_BASE + 0x00000022UL);
#define DBGTCR                          _DBGTCR.Byte
#define DBGTCR_TALIGN                   _DBGTCR.Bits.TALIGN
#define DBGTCR_TRCMOD                   _DBGTCR.Bits.TRCMOD
#define DBGTCR_TRANGE                   _DBGTCR.Bits.TRANGE
#define DBGTCR_TSOURCE                  _DBGTCR.Bits.TSOURCE

#define DBGTCR_TALIGN_MASK              3U
#define DBGTCR_TALIGN_BITNUM            0U
#define DBGTCR_TRCMOD_MASK              12U
#define DBGTCR_TRCMOD_BITNUM            2U
#define DBGTCR_TRANGE_MASK              48U
#define DBGTCR_TRANGE_BITNUM            4U
#define DBGTCR_TSOURCE_MASK             192U
#define DBGTCR_TSOURCE_BITNUM           6U


/*** DBGC2 - Debug Control Register 2; 0x00000023 ***/
typedef union {
  byte Byte;
  struct {
    byte ABCM        :2;                                       /* A and B Comparator Match Control */
    byte CDCM        :2;                                       /* C and D Comparator Match Control */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000023UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_ABCM                      _DBGC2.Bits.ABCM
#define DBGC2_CDCM                      _DBGC2.Bits.CDCM

#define DBGC2_ABCM_MASK                 3U
#define DBGC2_ABCM_BITNUM               0U
#define DBGC2_CDCM_MASK                 12U
#define DBGC2_CDCM_BITNUM               2U


/*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Trace Buffer Data Bits */
        byte BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
        byte BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
        byte BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
        byte BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
        byte BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
        byte BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
        byte BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Trace Buffer Data Bits */
        byte BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
        byte BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
        byte BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
        byte BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
        byte BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
        byte BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
        byte BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Trace Buffer Data Bits */
    word BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
    word BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
    word BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
    word BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
    word BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
    word BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
    word BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
    word BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
    word BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
    word BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
    word BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
    word BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
    word BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
    word BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
    word BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000024UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000026 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT         :7;                                       /* Count Value */
    byte             :1; 
  } Bits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000026UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT                      _DBGCNT.Bits.CNT

#define DBGCNT_CNT_MASK                 127U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGSCRX - Debug State Control Register; 0x00000027 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** DBGSCRX - Debug State Control Register; Several registers at the same address ***/
    union {
      struct {
        byte SC0         :1;                                       /* State X Sequencer Next State Selection Bit 0 */
        byte SC1         :1;                                       /* State X Sequencer Next State Selection Bit 1 */
        byte SC2         :1;                                       /* State X Sequencer Next State Selection Bit 2 */
        byte SC3         :1;                                       /* State X Sequencer Next State Selection Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGSCRXSTR;
    #define DBGSCRX                     _DBGSCRX.Byte
    #define DBGSCRX_SC0                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC0
    #define DBGSCRX_SC1                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC1
    #define DBGSCRX_SC2                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC2
    #define DBGSCRX_SC3                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC3
    #define DBGSCRX_SC                  _DBGSCRX.SameAddr_STR.DBGSCRXSTR.MergedBits.grpSC
    
    #define DBGSCRX_SC0_MASK            1U
    #define DBGSCRX_SC1_MASK            2U
    #define DBGSCRX_SC2_MASK            4U
    #define DBGSCRX_SC3_MASK            8U
    #define DBGSCRX_SC_MASK             15U
    #define DBGSCRX_SC_BITNUM           0U
    
    /*** DBGMFR - Debug Match Flag Register; Several registers at the same address ***/
    union {
      struct {
        byte MC0         :1;                                       /* Debug Match Flag Bit 0 */
        byte MC1         :1;                                       /* Debug Match Flag Bit 1 */
        byte MC2         :1;                                       /* Debug Match Flag Bit 2 */
        byte MC3         :1;                                       /* Debug Match Flag Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpMC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGMFRSTR;
    #define DBGMFR                      _DBGSCRX.Byte
    #define DBGMFR_MC0                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC0
    #define DBGMFR_MC1                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC1
    #define DBGMFR_MC2                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC2
    #define DBGMFR_MC3                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC3
    #define DBGMFR_MC                   _DBGSCRX.SameAddr_STR.DBGMFRSTR.MergedBits.grpMC
    
    #define DBGMFR_MC0_MASK             1U
    #define DBGMFR_MC1_MASK             2U
    #define DBGMFR_MC2_MASK             4U
    #define DBGMFR_MC3_MASK             8U
    #define DBGMFR_MC_MASK              15U
    #define DBGMFR_MC_BITNUM            0U
    
  } SameAddr_STR; /*Several registers at the same address */

} DBGSCRXSTR;
extern volatile DBGSCRXSTR _DBGSCRX @(REG_BASE + 0x00000027UL);


/*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte COMPE       :1;                                       /* Determines if comparator is enabled */
    byte SRC         :1;                                       /* Determines mapping of comparator to CPU or XGATE */
    byte RWE         :1;                                       /* Read/Write Enable Bit */
    byte RW          :1;                                       /* Read/Write Comparator Value Bit */
    byte BRK         :1;                                       /* Break */
    byte TAG         :1;                                       /* Tag Select */
    byte NDB_SZ      :1;                                       /* Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D) */
    byte SZE         :1;                                       /* Size Comparator Enable Bit */
  } Bits;
} DBGXCTLSTR;
extern volatile DBGXCTLSTR _DBGXCTL @(REG_BASE + 0x00000028UL);
#define DBGXCTL                         _DBGXCTL.Byte
#define DBGXCTL_COMPE                   _DBGXCTL.Bits.COMPE
#define DBGXCTL_SRC                     _DBGXCTL.Bits.SRC
#define DBGXCTL_RWE                     _DBGXCTL.Bits.RWE
#define DBGXCTL_RW                      _DBGXCTL.Bits.RW
#define DBGXCTL_BRK                     _DBGXCTL.Bits.BRK
#define DBGXCTL_TAG                     _DBGXCTL.Bits.TAG
#define DBGXCTL_NDB_SZ                  _DBGXCTL.Bits.NDB_SZ
#define DBGXCTL_SZE                     _DBGXCTL.Bits.SZE

#define DBGXCTL_COMPE_MASK              1U
#define DBGXCTL_SRC_MASK                2U
#define DBGXCTL_RWE_MASK                4U
#define DBGXCTL_RW_MASK                 8U
#define DBGXCTL_BRK_MASK                16U
#define DBGXCTL_TAG_MASK                32U
#define DBGXCTL_NDB_SZ_MASK             64U
#define DBGXCTL_SZE_MASK                128U


/*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT16       :1;                                       /* Comparator Address High Compare Bits */
    byte BIT17       :1;                                       /* Comparator Address High Compare Bit 17 */
    byte BIT18       :1;                                       /* Comparator Address High Compare Bit 18 */
    byte BIT19       :1;                                       /* Comparator Address High Compare Bit 19 */
    byte BIT20       :1;                                       /* Comparator Address High Compare Bit 20 */
    byte BIT21       :1;                                       /* Comparator Address High Compare Bit 21 */
    byte BIT22       :1;                                       /* Comparator Address High Compare Bit 22 */
    byte             :1; 
  } Bits;
  struct {
    byte grpBIT_16 :7;
    byte         :1;
  } MergedBits;
} DBGXAHSTR;
extern volatile DBGXAHSTR _DBGXAH @(REG_BASE + 0x00000029UL);
#define DBGXAH                          _DBGXAH.Byte
#define DBGXAH_BIT16                    _DBGXAH.Bits.BIT16
#define DBGXAH_BIT17                    _DBGXAH.Bits.BIT17
#define DBGXAH_BIT18                    _DBGXAH.Bits.BIT18
#define DBGXAH_BIT19                    _DBGXAH.Bits.BIT19
#define DBGXAH_BIT20                    _DBGXAH.Bits.BIT20
#define DBGXAH_BIT21                    _DBGXAH.Bits.BIT21
#define DBGXAH_BIT22                    _DBGXAH.Bits.BIT22
#define DBGXAH_BIT_16                   _DBGXAH.MergedBits.grpBIT_16
#define DBGXAH_BIT                      DBGXAH_BIT_16

#define DBGXAH_BIT16_MASK               1U
#define DBGXAH_BIT17_MASK               2U
#define DBGXAH_BIT18_MASK               4U
#define DBGXAH_BIT19_MASK               8U
#define DBGXAH_BIT20_MASK               16U
#define DBGXAH_BIT21_MASK               32U
#define DBGXAH_BIT22_MASK               64U
#define DBGXAH_BIT_16_MASK              127U
#define DBGXAH_BIT_16_BITNUM            0U


/*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Address Mid Compare Bits */
    byte BIT9        :1;                                       /* Comparator Address Mid Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Address Mid Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Address Mid Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Address Mid Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Address Mid Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Address Mid Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Address Mid Compare Bit 15 */
  } Bits;
} DBGXAMSTR;
extern volatile DBGXAMSTR _DBGXAM @(REG_BASE + 0x0000002AUL);
#define DBGXAM                          _DBGXAM.Byte
#define DBGXAM_BIT8                     _DBGXAM.Bits.BIT8
#define DBGXAM_BIT9                     _DBGXAM.Bits.BIT9
#define DBGXAM_BIT10                    _DBGXAM.Bits.BIT10
#define DBGXAM_BIT11                    _DBGXAM.Bits.BIT11
#define DBGXAM_BIT12                    _DBGXAM.Bits.BIT12
#define DBGXAM_BIT13                    _DBGXAM.Bits.BIT13
#define DBGXAM_BIT14                    _DBGXAM.Bits.BIT14
#define DBGXAM_BIT15                    _DBGXAM.Bits.BIT15

#define DBGXAM_BIT8_MASK                1U
#define DBGXAM_BIT9_MASK                2U
#define DBGXAM_BIT10_MASK               4U
#define DBGXAM_BIT11_MASK               8U
#define DBGXAM_BIT12_MASK               16U
#define DBGXAM_BIT13_MASK               32U
#define DBGXAM_BIT14_MASK               64U
#define DBGXAM_BIT15_MASK               128U


/*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bits */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXALSTR;
extern volatile DBGXALSTR _DBGXAL @(REG_BASE + 0x0000002BUL);
#define DBGXAL                          _DBGXAL.Byte
#define DBGXAL_BIT0                     _DBGXAL.Bits.BIT0
#define DBGXAL_BIT1                     _DBGXAL.Bits.BIT1
#define DBGXAL_BIT2                     _DBGXAL.Bits.BIT2
#define DBGXAL_BIT3                     _DBGXAL.Bits.BIT3
#define DBGXAL_BIT4                     _DBGXAL.Bits.BIT4
#define DBGXAL_BIT5                     _DBGXAL.Bits.BIT5
#define DBGXAL_BIT6                     _DBGXAL.Bits.BIT6
#define DBGXAL_BIT7                     _DBGXAL.Bits.BIT7

#define DBGXAL_BIT0_MASK                1U
#define DBGXAL_BIT1_MASK                2U
#define DBGXAL_BIT2_MASK                4U
#define DBGXAL_BIT3_MASK                8U
#define DBGXAL_BIT4_MASK                16U
#define DBGXAL_BIT5_MASK                32U
#define DBGXAL_BIT6_MASK                64U
#define DBGXAL_BIT7_MASK                128U


/*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Compare Bit 15 */
  } Bits;
} DBGXDHSTR;
extern volatile DBGXDHSTR _DBGXDH @(REG_BASE + 0x0000002CUL);
#define DBGXDH                          _DBGXDH.Byte
#define DBGXDH_BIT8                     _DBGXDH.Bits.BIT8
#define DBGXDH_BIT9                     _DBGXDH.Bits.BIT9
#define DBGXDH_BIT10                    _DBGXDH.Bits.BIT10
#define DBGXDH_BIT11                    _DBGXDH.Bits.BIT11
#define DBGXDH_BIT12                    _DBGXDH.Bits.BIT12
#define DBGXDH_BIT13                    _DBGXDH.Bits.BIT13
#define DBGXDH_BIT14                    _DBGXDH.Bits.BIT14
#define DBGXDH_BIT15                    _DBGXDH.Bits.BIT15

#define DBGXDH_BIT8_MASK                1U
#define DBGXDH_BIT9_MASK                2U
#define DBGXDH_BIT10_MASK               4U
#define DBGXDH_BIT11_MASK               8U
#define DBGXDH_BIT12_MASK               16U
#define DBGXDH_BIT13_MASK               32U
#define DBGXDH_BIT14_MASK               64U
#define DBGXDH_BIT15_MASK               128U


/*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Compare Bit 7 */
  } Bits;
} DBGXDLSTR;
extern volatile DBGXDLSTR _DBGXDL @(REG_BASE + 0x0000002DUL);
#define DBGXDL                          _DBGXDL.Byte
#define DBGXDL_BIT0                     _DBGXDL.Bits.BIT0
#define DBGXDL_BIT1                     _DBGXDL.Bits.BIT1
#define DBGXDL_BIT2                     _DBGXDL.Bits.BIT2
#define DBGXDL_BIT3                     _DBGXDL.Bits.BIT3
#define DBGXDL_BIT4                     _DBGXDL.Bits.BIT4
#define DBGXDL_BIT5                     _DBGXDL.Bits.BIT5
#define DBGXDL_BIT6                     _DBGXDL.Bits.BIT6
#define DBGXDL_BIT7                     _DBGXDL.Bits.BIT7

#define DBGXDL_BIT0_MASK                1U
#define DBGXDL_BIT1_MASK                2U
#define DBGXDL_BIT2_MASK                4U
#define DBGXDL_BIT3_MASK                8U
#define DBGXDL_BIT4_MASK                16U
#define DBGXDL_BIT5_MASK                32U
#define DBGXDL_BIT6_MASK                64U
#define DBGXDL_BIT7_MASK                128U


/*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Mask Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Mask Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Mask Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Mask Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Mask Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Mask Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Mask Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Mask Bit 15 */
  } Bits;
} DBGXDHMSTR;
extern volatile DBGXDHMSTR _DBGXDHM @(REG_BASE + 0x0000002EUL);
#define DBGXDHM                         _DBGXDHM.Byte
#define DBGXDHM_BIT8                    _DBGXDHM.Bits.BIT8
#define DBGXDHM_BIT9                    _DBGXDHM.Bits.BIT9
#define DBGXDHM_BIT10                   _DBGXDHM.Bits.BIT10
#define DBGXDHM_BIT11                   _DBGXDHM.Bits.BIT11
#define DBGXDHM_BIT12                   _DBGXDHM.Bits.BIT12
#define DBGXDHM_BIT13                   _DBGXDHM.Bits.BIT13
#define DBGXDHM_BIT14                   _DBGXDHM.Bits.BIT14
#define DBGXDHM_BIT15                   _DBGXDHM.Bits.BIT15

#define DBGXDHM_BIT8_MASK               1U
#define DBGXDHM_BIT9_MASK               2U
#define DBGXDHM_BIT10_MASK              4U
#define DBGXDHM_BIT11_MASK              8U
#define DBGXDHM_BIT12_MASK              16U
#define DBGXDHM_BIT13_MASK              32U
#define DBGXDHM_BIT14_MASK              64U
#define DBGXDHM_BIT15_MASK              128U


/*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Mask Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Mask Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Mask Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Mask Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Mask Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Mask Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Mask Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Mask Bit 7 */
  } Bits;
} DBGXDLMSTR;
extern volatile DBGXDLMSTR _DBGXDLM @(REG_BASE + 0x0000002FUL);
#define DBGXDLM                         _DBGXDLM.Byte
#define DBGXDLM_BIT0                    _DBGXDLM.Bits.BIT0
#define DBGXDLM_BIT1                    _DBGXDLM.Bits.BIT1
#define DBGXDLM_BIT2                    _DBGXDLM.Bits.BIT2
#define DBGXDLM_BIT3                    _DBGXDLM.Bits.BIT3
#define DBGXDLM_BIT4                    _DBGXDLM.Bits.BIT4
#define DBGXDLM_BIT5                    _DBGXDLM.Bits.BIT5
#define DBGXDLM_BIT6                    _DBGXDLM.Bits.BIT6
#define DBGXDLM_BIT7                    _DBGXDLM.Bits.BIT7

#define DBGXDLM_BIT0_MASK               1U
#define DBGXDLM_BIT1_MASK               2U
#define DBGXDLM_BIT2_MASK               4U
#define DBGXDLM_BIT3_MASK               8U
#define DBGXDLM_BIT4_MASK               16U
#define DBGXDLM_BIT5_MASK               32U
#define DBGXDLM_BIT6_MASK               64U
#define DBGXDLM_BIT7_MASK               128U


/*** PPAGE - Program Page Index Register; 0x00000030 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte PIX4        :1;                                       /* Program Page Index Bit 4 */
    byte PIX5        :1;                                       /* Program Page Index Bit 5 */
    byte PIX6        :1;                                       /* Program Page Index Bit 6 */
    byte PIX7        :1;                                       /* Program Page Index Bit 7 */
  } Bits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000030UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX6                      _PPAGE.Bits.PIX6
#define PPAGE_PIX7                      _PPAGE.Bits.PIX7

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX4_MASK                 16U
#define PPAGE_PIX5_MASK                 32U
#define PPAGE_PIX6_MASK                 64U
#define PPAGE_PIX7_MASK                 128U


/*** PORTK - Port K Data Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte PK0         :1;                                       /* Port K Bit 0 */
    byte PK1         :1;                                       /* Port K Bit 1 */
    byte PK2         :1;                                       /* Port K Bit 2 */
    byte PK3         :1;                                       /* Port K Bit 3 */
    byte PK4         :1;                                       /* Port K Bit 4 */
    byte PK5         :1;                                       /* Port K Bit 5 */
    byte PK6         :1;                                       /* Port K Bit 6 */
    byte PK7         :1;                                       /* Port K Bit 7 */
  } Bits;
} PORTKSTR;
extern volatile PORTKSTR _PORTK @(REG_BASE + 0x00000032UL);
#define PORTK                           _PORTK.Byte
#define PORTK_PK0                       _PORTK.Bits.PK0
#define PORTK_PK1                       _PORTK.Bits.PK1
#define PORTK_PK2                       _PORTK.Bits.PK2
#define PORTK_PK3                       _PORTK.Bits.PK3
#define PORTK_PK4                       _PORTK.Bits.PK4
#define PORTK_PK5                       _PORTK.Bits.PK5
#define PORTK_PK6                       _PORTK.Bits.PK6
#define PORTK_PK7                       _PORTK.Bits.PK7

#define PORTK_PK0_MASK                  1U
#define PORTK_PK1_MASK                  2U
#define PORTK_PK2_MASK                  4U
#define PORTK_PK3_MASK                  8U
#define PORTK_PK4_MASK                  16U
#define PORTK_PK5_MASK                  32U
#define PORTK_PK6_MASK                  64U
#define PORTK_PK7_MASK                  128U


/*** DDRK - Port K Data Direction Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRK0       :1;                                       /* Data Direction Port K Bit 0 */
    byte DDRK1       :1;                                       /* Data Direction Port K Bit 1 */
    byte DDRK2       :1;                                       /* Data Direction Port K Bit 2 */
    byte DDRK3       :1;                                       /* Data Direction Port K Bit 3 */
    byte DDRK4       :1;                                       /* Data Direction Port K Bit 4 */
    byte DDRK5       :1;                                       /* Data Direction Port K Bit 5 */
    byte DDRK6       :1;                                       /* Data Direction Port K Bit 6 */
    byte DDRK7       :1;                                       /* Data Direction Port K Bit 7 */
  } Bits;
} DDRKSTR;
extern volatile DDRKSTR _DDRK @(REG_BASE + 0x00000033UL);
#define DDRK                            _DDRK.Byte
#define DDRK_DDRK0                      _DDRK.Bits.DDRK0
#define DDRK_DDRK1                      _DDRK.Bits.DDRK1
#define DDRK_DDRK2                      _DDRK.Bits.DDRK2
#define DDRK_DDRK3                      _DDRK.Bits.DDRK3
#define DDRK_DDRK4                      _DDRK.Bits.DDRK4
#define DDRK_DDRK5                      _DDRK.Bits.DDRK5
#define DDRK_DDRK6                      _DDRK.Bits.DDRK6
#define DDRK_DDRK7                      _DDRK.Bits.DDRK7

#define DDRK_DDRK0_MASK                 1U
#define DDRK_DDRK1_MASK                 2U
#define DDRK_DDRK2_MASK                 4U
#define DDRK_DDRK3_MASK                 8U
#define DDRK_DDRK4_MASK                 16U
#define DDRK_DDRK5_MASK                 32U
#define DDRK_DDRK6_MASK                 64U
#define DDRK_DDRK7_MASK                 128U


/*** SYNR - CRG Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYN0        :1;                                       /* CRG Synthesizer Bit 0 */
    byte SYN1        :1;                                       /* CRG Synthesizer Bit 1 */
    byte SYN2        :1;                                       /* CRG Synthesizer Bit 2 */
    byte SYN3        :1;                                       /* CRG Synthesizer Bit 3 */
    byte SYN4        :1;                                       /* CRG Synthesizer Bit 4 */
    byte SYN5        :1;                                       /* CRG Synthesizer Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSYN  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} SYNRSTR;
extern volatile SYNRSTR _SYNR @(REG_BASE + 0x00000034UL);
#define SYNR                            _SYNR.Byte
#define SYNR_SYN0                       _SYNR.Bits.SYN0
#define SYNR_SYN1                       _SYNR.Bits.SYN1
#define SYNR_SYN2                       _SYNR.Bits.SYN2
#define SYNR_SYN3                       _SYNR.Bits.SYN3
#define SYNR_SYN4                       _SYNR.Bits.SYN4
#define SYNR_SYN5                       _SYNR.Bits.SYN5
#define SYNR_SYN                        _SYNR.MergedBits.grpSYN

#define SYNR_SYN0_MASK                  1U
#define SYNR_SYN1_MASK                  2U
#define SYNR_SYN2_MASK                  4U
#define SYNR_SYN3_MASK                  8U
#define SYNR_SYN4_MASK                  16U
#define SYNR_SYN5_MASK                  32U
#define SYNR_SYN_MASK                   63U
#define SYNR_SYN_BITNUM                 0U


/*** REFDV - CRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDV0      :1;                                       /* CRG Reference Divider Bit 0 */
    byte REFDV1      :1;                                       /* CRG Reference Divider Bit 1 */
    byte REFDV2      :1;                                       /* CRG Reference Divider Bit 2 */
    byte REFDV3      :1;                                       /* CRG Reference Divider Bit 3 */
    byte REFDV4      :1;                                       /* CRG Reference Divider Bit 4 */
    byte REFDV5      :1;                                       /* CRG Reference Divider Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREFDV :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035UL);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDV0                    _REFDV.Bits.REFDV0
#define REFDV_REFDV1                    _REFDV.Bits.REFDV1
#define REFDV_REFDV2                    _REFDV.Bits.REFDV2
#define REFDV_REFDV3                    _REFDV.Bits.REFDV3
#define REFDV_REFDV4                    _REFDV.Bits.REFDV4
#define REFDV_REFDV5                    _REFDV.Bits.REFDV5
#define REFDV_REFDV                     _REFDV.MergedBits.grpREFDV

#define REFDV_REFDV0_MASK               1U
#define REFDV_REFDV1_MASK               2U
#define REFDV_REFDV2_MASK               4U
#define REFDV_REFDV3_MASK               8U
#define REFDV_REFDV4_MASK               16U
#define REFDV_REFDV5_MASK               32U
#define REFDV_REFDV_MASK                63U
#define REFDV_REFDV_BITNUM              0U


/*** CRGFLG - CRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte SCM         :1;                                       /* Self-clock mode Status */
    byte SCMIF       :1;                                       /* Self-clock mode Interrupt Flag */
    byte TRACK       :1;                                       /* Track Status */
    byte LOCK        :1;                                       /* Lock Status */
    byte LOCKIF      :1;                                       /* PLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_SCM                      _CRGFLG.Bits.SCM
#define CRGFLG_SCMIF                    _CRGFLG.Bits.SCMIF
#define CRGFLG_TRACK                    _CRGFLG.Bits.TRACK
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_LVRF                     _CRGFLG.Bits.LVRF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_SCM_MASK                 1U
#define CRGFLG_SCMIF_MASK               2U
#define CRGFLG_TRACK_MASK               4U
#define CRGFLG_LOCK_MASK                8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_LVRF_MASK                32U
#define CRGFLG_PORF_MASK                64U
#define CRGFLG_RTIF_MASK                128U


/*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SCMIE       :1;                                       /* Self-clock mode Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable */
    byte             :1; 
    byte ILAF        :1;                                       /* Illegal Address Reset Flag */
    byte RTIE        :1;                                       /* Real Time Interrupt Enable */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038UL);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_SCMIE                    _CRGINT.Bits.SCMIE
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_ILAF                     _CRGINT.Bits.ILAF
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_SCMIE_MASK               2U
#define CRGINT_LOCKIE_MASK              16U
#define CRGINT_ILAF_MASK                64U
#define CRGINT_RTIE_MASK                128U


/*** CLKSEL - CRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP stops in WAIT mode */
    byte RTIWAI      :1;                                       /* RTI stops in WAIT mode */
    byte             :1; 
    byte PLLWAI      :1;                                       /* PLL stops in WAIT mode */
    byte             :1; 
    byte             :1; 
    byte PSTP        :1;                                       /* Pseudo Stop */
    byte PLLSEL      :1;                                       /* PLL selected for system clock */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039UL);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_PLLWAI                   _CLKSEL.Bits.PLLWAI
#define CLKSEL_PSTP                     _CLKSEL.Bits.PSTP
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1U
#define CLKSEL_RTIWAI_MASK              2U
#define CLKSEL_PLLWAI_MASK              8U
#define CLKSEL_PSTP_MASK                64U
#define CLKSEL_PLLSEL_MASK              128U


/*** PLLCTL - CRG PLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte SCME        :1;                                       /* Self-clock mode enable */
    byte PCE         :1;                                       /* COP Enable during Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable during Pseudo Stop Bit */
    byte FSTWKP      :1;                                       /* Fast Wake-up from Full Stop Bit */
    byte ACQ         :1;                                       /* Acquisition */
    byte AUTO        :1;                                       /* Automatic Bandwidth Control */
    byte PLLON       :1;                                       /* Phase Lock Loop On */
    byte CME         :1;                                       /* Clock Monitor Enable */
  } Bits;
} PLLCTLSTR;
extern volatile PLLCTLSTR _PLLCTL @(REG_BASE + 0x0000003AUL);
#define PLLCTL                          _PLLCTL.Byte
#define PLLCTL_SCME                     _PLLCTL.Bits.SCME
#define PLLCTL_PCE                      _PLLCTL.Bits.PCE
#define PLLCTL_PRE                      _PLLCTL.Bits.PRE
#define PLLCTL_FSTWKP                   _PLLCTL.Bits.FSTWKP
#define PLLCTL_ACQ                      _PLLCTL.Bits.ACQ
#define PLLCTL_AUTO                     _PLLCTL.Bits.AUTO
#define PLLCTL_PLLON                    _PLLCTL.Bits.PLLON
#define PLLCTL_CME                      _PLLCTL.Bits.CME

#define PLLCTL_SCME_MASK                1U
#define PLLCTL_PCE_MASK                 2U
#define PLLCTL_PRE_MASK                 4U
#define PLLCTL_FSTWKP_MASK              8U
#define PLLCTL_ACQ_MASK                 16U
#define PLLCTL_AUTO_MASK                32U
#define PLLCTL_PLLON_MASK               64U
#define PLLCTL_CME_MASK                 128U


/*** RTICTL - CRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte RTDEC       :1;                                       /* Decimal or Binary Divider Select Bit */
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003BUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTDEC                    _RTICTL.Bits.RTDEC
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTR2_MASK                4U
#define RTICTL_RTR3_MASK                8U
#define RTICTL_RTR4_MASK                16U
#define RTICTL_RTR5_MASK                32U
#define RTICTL_RTR6_MASK                64U
#define RTICTL_RTDEC_MASK               128U
#define RTICTL_RTR_MASK                 127U
#define RTICTL_RTR_BITNUM               0U


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte WRTMASK     :1;                                       /* Write Mask for WCOP */
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003CUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_WRTMASK                  _COPCTL.Bits.WRTMASK
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_WRTMASK_MASK             32U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1U
#define ARMCOP_BIT1_MASK                2U
#define ARMCOP_BIT2_MASK                4U
#define ARMCOP_BIT3_MASK                8U
#define ARMCOP_BIT4_MASK                16U
#define ARMCOP_BIT5_MASK                32U
#define ARMCOP_BIT6_MASK                64U
#define ARMCOP_BIT7_MASK                128U


/*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} TIOSSTR;
extern volatile TIOSSTR _TIOS @(REG_BASE + 0x00000040UL);
#define TIOS                            _TIOS.Byte
#define TIOS_IOS0                       _TIOS.Bits.IOS0
#define TIOS_IOS1                       _TIOS.Bits.IOS1
#define TIOS_IOS2                       _TIOS.Bits.IOS2
#define TIOS_IOS3                       _TIOS.Bits.IOS3
#define TIOS_IOS4                       _TIOS.Bits.IOS4
#define TIOS_IOS5                       _TIOS.Bits.IOS5
#define TIOS_IOS6                       _TIOS.Bits.IOS6
#define TIOS_IOS7                       _TIOS.Bits.IOS7

#define TIOS_IOS0_MASK                  1U
#define TIOS_IOS1_MASK                  2U
#define TIOS_IOS2_MASK                  4U
#define TIOS_IOS3_MASK                  8U
#define TIOS_IOS4_MASK                  16U
#define TIOS_IOS5_MASK                  32U
#define TIOS_IOS6_MASK                  64U
#define TIOS_IOS7_MASK                  128U


/*** CFORC - Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} CFORCSTR;
extern volatile CFORCSTR _CFORC @(REG_BASE + 0x00000041UL);
#define CFORC                           _CFORC.Byte
#define CFORC_FOC0                      _CFORC.Bits.FOC0
#define CFORC_FOC1                      _CFORC.Bits.FOC1
#define CFORC_FOC2                      _CFORC.Bits.FOC2
#define CFORC_FOC3                      _CFORC.Bits.FOC3
#define CFORC_FOC4                      _CFORC.Bits.FOC4
#define CFORC_FOC5                      _CFORC.Bits.FOC5
#define CFORC_FOC6                      _CFORC.Bits.FOC6
#define CFORC_FOC7                      _CFORC.Bits.FOC7

#define CFORC_FOC0_MASK                 1U
#define CFORC_FOC1_MASK                 2U
#define CFORC_FOC2_MASK                 4U
#define CFORC_FOC3_MASK                 8U
#define CFORC_FOC4_MASK                 16U
#define CFORC_FOC5_MASK                 32U
#define CFORC_FOC6_MASK                 64U
#define CFORC_FOC7_MASK                 128U


/*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} OC7MSTR;
extern volatile OC7MSTR _OC7M @(REG_BASE + 0x00000042UL);
#define OC7M                            _OC7M.Byte
#define OC7M_OC7M0                      _OC7M.Bits.OC7M0
#define OC7M_OC7M1                      _OC7M.Bits.OC7M1
#define OC7M_OC7M2                      _OC7M.Bits.OC7M2
#define OC7M_OC7M3                      _OC7M.Bits.OC7M3
#define OC7M_OC7M4                      _OC7M.Bits.OC7M4
#define OC7M_OC7M5                      _OC7M.Bits.OC7M5
#define OC7M_OC7M6                      _OC7M.Bits.OC7M6
#define OC7M_OC7M7                      _OC7M.Bits.OC7M7

#define OC7M_OC7M0_MASK                 1U
#define OC7M_OC7M1_MASK                 2U
#define OC7M_OC7M2_MASK                 4U
#define OC7M_OC7M3_MASK                 8U
#define OC7M_OC7M4_MASK                 16U
#define OC7M_OC7M5_MASK                 32U
#define OC7M_OC7M6_MASK                 64U
#define OC7M_OC7M7_MASK                 128U


/*** OC7D - Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
} OC7DSTR;
extern volatile OC7DSTR _OC7D @(REG_BASE + 0x00000043UL);
#define OC7D                            _OC7D.Byte


/*** TCNT - Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCNTHi - Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } TCNTHiSTR;
    #define TCNTHi                      _TCNT.Overlap_STR.TCNTHiSTR.Byte
    

    /*** TCNTLo - Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } TCNTLoSTR;
    #define TCNTLo                      _TCNT.Overlap_STR.TCNTLoSTR.Byte
    
  } Overlap_STR;

} TCNTSTR;
extern volatile TCNTSTR _TCNT @(REG_BASE + 0x00000044UL);
#define TCNT                            _TCNT.Word


/*** TSCR1 - Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PRNT        :1;                                       /* Precision Timer */
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TSCR1STR;
extern volatile TSCR1STR _TSCR1 @(REG_BASE + 0x00000046UL);
#define TSCR1                           _TSCR1.Byte
#define TSCR1_PRNT                      _TSCR1.Bits.PRNT
#define TSCR1_TFFCA                     _TSCR1.Bits.TFFCA
#define TSCR1_TSFRZ                     _TSCR1.Bits.TSFRZ
#define TSCR1_TSWAI                     _TSCR1.Bits.TSWAI
#define TSCR1_TEN                       _TSCR1.Bits.TEN

#define TSCR1_PRNT_MASK                 8U
#define TSCR1_TFFCA_MASK                16U
#define TSCR1_TSFRZ_MASK                32U
#define TSCR1_TSWAI_MASK                64U
#define TSCR1_TEN_MASK                  128U


/*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} TTOVSTR;
extern volatile TTOVSTR _TTOV @(REG_BASE + 0x00000047UL);
#define TTOV                            _TTOV.Byte
#define TTOV_TOV0                       _TTOV.Bits.TOV0
#define TTOV_TOV1                       _TTOV.Bits.TOV1
#define TTOV_TOV2                       _TTOV.Bits.TOV2
#define TTOV_TOV3                       _TTOV.Bits.TOV3
#define TTOV_TOV4                       _TTOV.Bits.TOV4
#define TTOV_TOV5                       _TTOV.Bits.TOV5
#define TTOV_TOV6                       _TTOV.Bits.TOV6
#define TTOV_TOV7                       _TTOV.Bits.TOV7

#define TTOV_TOV0_MASK                  1U
#define TTOV_TOV1_MASK                  2U
#define TTOV_TOV2_MASK                  4U
#define TTOV_TOV3_MASK                  8U
#define TTOV_TOV4_MASK                  16U
#define TTOV_TOV5_MASK                  32U
#define TTOV_TOV6_MASK                  64U
#define TTOV_TOV7_MASK                  128U


/*** TCTL1 - Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TCTL1STR;
extern volatile TCTL1STR _TCTL1 @(REG_BASE + 0x00000048UL);
#define TCTL1                           _TCTL1.Byte
#define TCTL1_OL4                       _TCTL1.Bits.OL4
#define TCTL1_OM4                       _TCTL1.Bits.OM4
#define TCTL1_OL5                       _TCTL1.Bits.OL5
#define TCTL1_OM5                       _TCTL1.Bits.OM5
#define TCTL1_OL6                       _TCTL1.Bits.OL6
#define TCTL1_OM6                       _TCTL1.Bits.OM6
#define TCTL1_OL7                       _TCTL1.Bits.OL7
#define TCTL1_OM7                       _TCTL1.Bits.OM7

#define TCTL1_OL4_MASK                  1U
#define TCTL1_OM4_MASK                  2U
#define TCTL1_OL5_MASK                  4U
#define TCTL1_OM5_MASK                  8U
#define TCTL1_OL6_MASK                  16U
#define TCTL1_OM6_MASK                  32U
#define TCTL1_OL7_MASK                  64U
#define TCTL1_OM7_MASK                  128U


/*** TCTL2 - Timer Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Lecel Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} TCTL2STR;
extern volatile TCTL2STR _TCTL2 @(REG_BASE + 0x00000049UL);
#define TCTL2                           _TCTL2.Byte
#define TCTL2_OL0                       _TCTL2.Bits.OL0
#define TCTL2_OM0                       _TCTL2.Bits.OM0
#define TCTL2_OL1                       _TCTL2.Bits.OL1
#define TCTL2_OM1                       _TCTL2.Bits.OM1
#define TCTL2_OL2                       _TCTL2.Bits.OL2
#define TCTL2_OM2                       _TCTL2.Bits.OM2
#define TCTL2_OL3                       _TCTL2.Bits.OL3
#define TCTL2_OM3                       _TCTL2.Bits.OM3

#define TCTL2_OL0_MASK                  1U
#define TCTL2_OM0_MASK                  2U
#define TCTL2_OL1_MASK                  4U
#define TCTL2_OM1_MASK                  8U
#define TCTL2_OL2_MASK                  16U
#define TCTL2_OM2_MASK                  32U
#define TCTL2_OL3_MASK                  64U
#define TCTL2_OM3_MASK                  128U


/*** TCTL3 - Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TCTL3STR;
extern volatile TCTL3STR _TCTL3 @(REG_BASE + 0x0000004AUL);
#define TCTL3                           _TCTL3.Byte
#define TCTL3_EDG4A                     _TCTL3.Bits.EDG4A
#define TCTL3_EDG4B                     _TCTL3.Bits.EDG4B
#define TCTL3_EDG5A                     _TCTL3.Bits.EDG5A
#define TCTL3_EDG5B                     _TCTL3.Bits.EDG5B
#define TCTL3_EDG6A                     _TCTL3.Bits.EDG6A
#define TCTL3_EDG6B                     _TCTL3.Bits.EDG6B
#define TCTL3_EDG7A                     _TCTL3.Bits.EDG7A
#define TCTL3_EDG7B                     _TCTL3.Bits.EDG7B
#define TCTL3_EDG4x                     _TCTL3.MergedBits.grpEDG4x
#define TCTL3_EDG5x                     _TCTL3.MergedBits.grpEDG5x
#define TCTL3_EDG6x                     _TCTL3.MergedBits.grpEDG6x
#define TCTL3_EDG7x                     _TCTL3.MergedBits.grpEDG7x

#define TCTL3_EDG4A_MASK                1U
#define TCTL3_EDG4B_MASK                2U
#define TCTL3_EDG5A_MASK                4U
#define TCTL3_EDG5B_MASK                8U
#define TCTL3_EDG6A_MASK                16U
#define TCTL3_EDG6B_MASK                32U
#define TCTL3_EDG7A_MASK                64U
#define TCTL3_EDG7B_MASK                128U
#define TCTL3_EDG4x_MASK                3U
#define TCTL3_EDG4x_BITNUM              0U
#define TCTL3_EDG5x_MASK                12U
#define TCTL3_EDG5x_BITNUM              2U
#define TCTL3_EDG6x_MASK                48U
#define TCTL3_EDG6x_BITNUM              4U
#define TCTL3_EDG7x_MASK                192U
#define TCTL3_EDG7x_BITNUM              6U


/*** TCTL4 - Timer Control Register 4; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} TCTL4STR;
extern volatile TCTL4STR _TCTL4 @(REG_BASE + 0x0000004BUL);
#define TCTL4                           _TCTL4.Byte
#define TCTL4_EDG0A                     _TCTL4.Bits.EDG0A
#define TCTL4_EDG0B                     _TCTL4.Bits.EDG0B
#define TCTL4_EDG1A                     _TCTL4.Bits.EDG1A
#define TCTL4_EDG1B                     _TCTL4.Bits.EDG1B
#define TCTL4_EDG2A                     _TCTL4.Bits.EDG2A
#define TCTL4_EDG2B                     _TCTL4.Bits.EDG2B
#define TCTL4_EDG3A                     _TCTL4.Bits.EDG3A
#define TCTL4_EDG3B                     _TCTL4.Bits.EDG3B
#define TCTL4_EDG0x                     _TCTL4.MergedBits.grpEDG0x
#define TCTL4_EDG1x                     _TCTL4.MergedBits.grpEDG1x
#define TCTL4_EDG2x                     _TCTL4.MergedBits.grpEDG2x
#define TCTL4_EDG3x                     _TCTL4.MergedBits.grpEDG3x

#define TCTL4_EDG0A_MASK                1U
#define TCTL4_EDG0B_MASK                2U
#define TCTL4_EDG1A_MASK                4U
#define TCTL4_EDG1B_MASK                8U
#define TCTL4_EDG2A_MASK                16U
#define TCTL4_EDG2B_MASK                32U
#define TCTL4_EDG3A_MASK                64U
#define TCTL4_EDG3B_MASK                128U
#define TCTL4_EDG0x_MASK                3U
#define TCTL4_EDG0x_BITNUM              0U
#define TCTL4_EDG1x_MASK                12U
#define TCTL4_EDG1x_BITNUM              2U
#define TCTL4_EDG2x_MASK                48U
#define TCTL4_EDG2x_BITNUM              4U
#define TCTL4_EDG3x_MASK                192U
#define TCTL4_EDG3x_BITNUM              6U


/*** TIE - Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIESTR;
extern volatile TIESTR _TIE @(REG_BASE + 0x0000004CUL);
#define TIE                             _TIE.Byte
#define TIE_C0I                         _TIE.Bits.C0I
#define TIE_C1I                         _TIE.Bits.C1I
#define TIE_C2I                         _TIE.Bits.C2I
#define TIE_C3I                         _TIE.Bits.C3I
#define TIE_C4I                         _TIE.Bits.C4I
#define TIE_C5I                         _TIE.Bits.C5I
#define TIE_C6I                         _TIE.Bits.C6I
#define TIE_C7I                         _TIE.Bits.C7I

#define TIE_C0I_MASK                    1U
#define TIE_C1I_MASK                    2U
#define TIE_C2I_MASK                    4U
#define TIE_C3I_MASK                    8U
#define TIE_C4I_MASK                    16U
#define TIE_C5I_MASK                    32U
#define TIE_C6I_MASK                    64U
#define TIE_C7I_MASK                    128U


/*** TSCR2 - Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSCR2STR;
extern volatile TSCR2STR _TSCR2 @(REG_BASE + 0x0000004DUL);
#define TSCR2                           _TSCR2.Byte
#define TSCR2_PR0                       _TSCR2.Bits.PR0
#define TSCR2_PR1                       _TSCR2.Bits.PR1
#define TSCR2_PR2                       _TSCR2.Bits.PR2
#define TSCR2_TCRE                      _TSCR2.Bits.TCRE
#define TSCR2_TOI                       _TSCR2.Bits.TOI
#define TSCR2_PR                        _TSCR2.MergedBits.grpPR

#define TSCR2_PR0_MASK                  1U
#define TSCR2_PR1_MASK                  2U
#define TSCR2_PR2_MASK                  4U
#define TSCR2_TCRE_MASK                 8U
#define TSCR2_TOI_MASK                  128U
#define TSCR2_PR_MASK                   7U
#define TSCR2_PR_BITNUM                 0U


/*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TFLG1STR;
extern volatile TFLG1STR _TFLG1 @(REG_BASE + 0x0000004EUL);
#define TFLG1                           _TFLG1.Byte
#define TFLG1_C0F                       _TFLG1.Bits.C0F
#define TFLG1_C1F                       _TFLG1.Bits.C1F
#define TFLG1_C2F                       _TFLG1.Bits.C2F
#define TFLG1_C3F                       _TFLG1.Bits.C3F
#define TFLG1_C4F                       _TFLG1.Bits.C4F
#define TFLG1_C5F                       _TFLG1.Bits.C5F
#define TFLG1_C6F                       _TFLG1.Bits.C6F
#define TFLG1_C7F                       _TFLG1.Bits.C7F

#define TFLG1_C0F_MASK                  1U
#define TFLG1_C1F_MASK                  2U
#define TFLG1_C2F_MASK                  4U
#define TFLG1_C3F_MASK                  8U
#define TFLG1_C4F_MASK                  16U
#define TFLG1_C5F_MASK                  32U
#define TFLG1_C6F_MASK                  64U
#define TFLG1_C7F_MASK                  128U


/*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TFLG2STR;
extern volatile TFLG2STR _TFLG2 @(REG_BASE + 0x0000004FUL);
#define TFLG2                           _TFLG2.Byte
#define TFLG2_TOF                       _TFLG2.Bits.TOF

#define TFLG2_TOF_MASK                  128U


/*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***/
    union {
      byte Byte;
    } TC0HiSTR;
    #define TC0Hi                       _TC0.Overlap_STR.TC0HiSTR.Byte
    

    /*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***/
    union {
      byte Byte;
    } TC0LoSTR;
    #define TC0Lo                       _TC0.Overlap_STR.TC0LoSTR.Byte
    
  } Overlap_STR;

} TC0STR;
extern volatile TC0STR _TC0 @(REG_BASE + 0x00000050UL);
#define TC0                             _TC0.Word
/* TC_ARR: Access 8 TCx registers in an array */
#define TC_ARR                          ((volatile word *) &TC0)


/*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***/
    union {
      byte Byte;
    } TC1HiSTR;
    #define TC1Hi                       _TC1.Overlap_STR.TC1HiSTR.Byte
    

    /*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***/
    union {
      byte Byte;
    } TC1LoSTR;
    #define TC1Lo                       _TC1.Overlap_STR.TC1LoSTR.Byte
    
  } Overlap_STR;

} TC1STR;
extern volatile TC1STR _TC1 @(REG_BASE + 0x00000052UL);
#define TC1                             _TC1.Word


/*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***/
    union {
      byte Byte;
    } TC2HiSTR;
    #define TC2Hi                       _TC2.Overlap_STR.TC2HiSTR.Byte
    

    /*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***/
    union {
      byte Byte;
    } TC2LoSTR;
    #define TC2Lo                       _TC2.Overlap_STR.TC2LoSTR.Byte
    
  } Overlap_STR;

} TC2STR;
extern volatile TC2STR _TC2 @(REG_BASE + 0x00000054UL);
#define TC2                             _TC2.Word


/*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***/
    union {
      byte Byte;
    } TC3HiSTR;
    #define TC3Hi                       _TC3.Overlap_STR.TC3HiSTR.Byte
    

    /*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***/
    union {
      byte Byte;
    } TC3LoSTR;
    #define TC3Lo                       _TC3.Overlap_STR.TC3LoSTR.Byte
    
  } Overlap_STR;

} TC3STR;
extern volatile TC3STR _TC3 @(REG_BASE + 0x00000056UL);
#define TC3                             _TC3.Word


/*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } TC4HiSTR;
    #define TC4Hi                       _TC4.Overlap_STR.TC4HiSTR.Byte
    

    /*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } TC4LoSTR;
    #define TC4Lo                       _TC4.Overlap_STR.TC4LoSTR.Byte
    
  } Overlap_STR;

} TC4STR;
extern volatile TC4STR _TC4 @(REG_BASE + 0x00000058UL);
#define TC4                             _TC4.Word


/*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } TC5HiSTR;
    #define TC5Hi                       _TC5.Overlap_STR.TC5HiSTR.Byte
    

    /*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } TC5LoSTR;
    #define TC5Lo                       _TC5.Overlap_STR.TC5LoSTR.Byte
    
  } Overlap_STR;

} TC5STR;
extern volatile TC5STR _TC5 @(REG_BASE + 0x0000005AUL);
#define TC5                             _TC5.Word


/*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } TC6HiSTR;
    #define TC6Hi                       _TC6.Overlap_STR.TC6HiSTR.Byte
    

    /*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } TC6LoSTR;
    #define TC6Lo                       _TC6.Overlap_STR.TC6LoSTR.Byte
    
  } Overlap_STR;

} TC6STR;
extern volatile TC6STR _TC6 @(REG_BASE + 0x0000005CUL);
#define TC6                             _TC6.Word


/*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } TC7HiSTR;
    #define TC7Hi                       _TC7.Overlap_STR.TC7HiSTR.Byte
    

    /*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } TC7LoSTR;
    #define TC7Lo                       _TC7.Overlap_STR.TC7LoSTR.Byte
    
  } Overlap_STR;

} TC7STR;
extern volatile TC7STR _TC7 @(REG_BASE + 0x0000005EUL);
#define TC7                             _TC7.Word


/*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PACTLSTR;
extern volatile PACTLSTR _PACTL @(REG_BASE + 0x00000060UL);
#define PACTL                           _PACTL.Byte
#define PACTL_PAI                       _PACTL.Bits.PAI
#define PACTL_PAOVI                     _PACTL.Bits.PAOVI
#define PACTL_CLK0                      _PACTL.Bits.CLK0
#define PACTL_CLK1                      _PACTL.Bits.CLK1
#define PACTL_PEDGE                     _PACTL.Bits.PEDGE
#define PACTL_PAMOD                     _PACTL.Bits.PAMOD
#define PACTL_PAEN                      _PACTL.Bits.PAEN
#define PACTL_CLK                       _PACTL.MergedBits.grpCLK

#define PACTL_PAI_MASK                  1U
#define PACTL_PAOVI_MASK                2U
#define PACTL_CLK0_MASK                 4U
#define PACTL_CLK1_MASK                 8U
#define PACTL_PEDGE_MASK                16U
#define PACTL_PAMOD_MASK                32U
#define PACTL_PAEN_MASK                 64U
#define PACTL_CLK_MASK                  12U
#define PACTL_CLK_BITNUM                2U


/*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PAFLGSTR;
extern volatile PAFLGSTR _PAFLG @(REG_BASE + 0x00000061UL);
#define PAFLG                           _PAFLG.Byte
#define PAFLG_PAIF                      _PAFLG.Bits.PAIF
#define PAFLG_PAOVF                     _PAFLG.Bits.PAOVF

#define PAFLG_PAIF_MASK                 1U
#define PAFLG_PAOVF_MASK                2U


/*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***/
    union {
      byte Byte;
    } PACN3STR;
    #define PACN3                       _PACN32.Overlap_STR.PACN3STR.Byte
    

    /*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***/
    union {
      byte Byte;
    } PACN2STR;
    #define PACN2                       _PACN32.Overlap_STR.PACN2STR.Byte
    
  } Overlap_STR;

} PACN32STR;
extern volatile PACN32STR _PACN32 @(REG_BASE + 0x00000062UL);
#define PACN32                          _PACN32.Word


/*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***/
    union {
      byte Byte;
    } PACN1STR;
    #define PACN1                       _PACN10.Overlap_STR.PACN1STR.Byte
    

    /*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***/
    union {
      byte Byte;
    } PACN0STR;
    #define PACN0                       _PACN10.Overlap_STR.PACN0STR.Byte
    
  } Overlap_STR;

} PACN10STR;
extern volatile PACN10STR _PACN10 @(REG_BASE + 0x00000064UL);
#define PACN10                          _PACN10.Word


/*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***/
typedef union {
  byte Byte;
  struct {
    byte MCPR0       :1;                                       /* Modulus Counter Prescaler select 0 */
    byte MCPR1       :1;                                       /* Modulus Counter Prescaler select 1 */
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte ICLAT       :1;                                       /* Input Capture Force Latch Action */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZI        :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
  struct {
    byte grpMCPR :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MCCTLSTR;
extern volatile MCCTLSTR _MCCTL @(REG_BASE + 0x00000066UL);
#define MCCTL                           _MCCTL.Byte
#define MCCTL_MCPR0                     _MCCTL.Bits.MCPR0
#define MCCTL_MCPR1                     _MCCTL.Bits.MCPR1
#define MCCTL_MCEN                      _MCCTL.Bits.MCEN
#define MCCTL_FLMC                      _MCCTL.Bits.FLMC
#define MCCTL_ICLAT                     _MCCTL.Bits.ICLAT
#define MCCTL_RDMCL                     _MCCTL.Bits.RDMCL
#define MCCTL_MODMC                     _MCCTL.Bits.MODMC
#define MCCTL_MCZI                      _MCCTL.Bits.MCZI
#define MCCTL_MCPR                      _MCCTL.MergedBits.grpMCPR

#define MCCTL_MCPR0_MASK                1U
#define MCCTL_MCPR1_MASK                2U
#define MCCTL_MCEN_MASK                 4U
#define MCCTL_FLMC_MASK                 8U
#define MCCTL_ICLAT_MASK                16U
#define MCCTL_RDMCL_MASK                32U
#define MCCTL_MODMC_MASK                64U
#define MCCTL_MCZI_MASK                 128U
#define MCCTL_MCPR_MASK                 3U
#define MCCTL_MCPR_BITNUM               0U


/*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***/
typedef union {
  byte Byte;
  struct {
    byte POLF0       :1;                                       /* First Input Capture Polarity Status 0 */
    byte POLF1       :1;                                       /* First Input Capture Polarity Status 1 */
    byte POLF2       :1;                                       /* First Input Capture Polarity Status 2 */
    byte POLF3       :1;                                       /* First Input Capture Polarity Status 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZF        :1;                                       /* Modulus Counter Underflow Flag */
  } Bits;
  struct {
    byte grpPOLF :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MCFLGSTR;
extern volatile MCFLGSTR _MCFLG @(REG_BASE + 0x00000067UL);
#define MCFLG                           _MCFLG.Byte
#define MCFLG_POLF0                     _MCFLG.Bits.POLF0
#define MCFLG_POLF1                     _MCFLG.Bits.POLF1
#define MCFLG_POLF2                     _MCFLG.Bits.POLF2
#define MCFLG_POLF3                     _MCFLG.Bits.POLF3
#define MCFLG_MCZF                      _MCFLG.Bits.MCZF
#define MCFLG_POLF                      _MCFLG.MergedBits.grpPOLF

#define MCFLG_POLF0_MASK                1U
#define MCFLG_POLF1_MASK                2U
#define MCFLG_POLF2_MASK                4U
#define MCFLG_POLF3_MASK                8U
#define MCFLG_MCZF_MASK                 128U
#define MCFLG_POLF_MASK                 15U
#define MCFLG_POLF_BITNUM               0U


/*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***/
typedef union {
  byte Byte;
  struct {
    byte PA0EN       :1;                                       /* 8-Bit Pulse Accumulator 0 Enable */
    byte PA1EN       :1;                                       /* 8-Bit Pulse Accumulator 1 Enable */
    byte PA2EN       :1;                                       /* 8-Bit Pulse Accumulator 2 Enable */
    byte PA3EN       :1;                                       /* 8-Bit Pulse Accumulator 3 Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ICPARSTR;
extern volatile ICPARSTR _ICPAR @(REG_BASE + 0x00000068UL);
#define ICPAR                           _ICPAR.Byte
#define ICPAR_PA0EN                     _ICPAR.Bits.PA0EN
#define ICPAR_PA1EN                     _ICPAR.Bits.PA1EN
#define ICPAR_PA2EN                     _ICPAR.Bits.PA2EN
#define ICPAR_PA3EN                     _ICPAR.Bits.PA3EN

#define ICPAR_PA0EN_MASK                1U
#define ICPAR_PA1EN_MASK                2U
#define ICPAR_PA2EN_MASK                4U
#define ICPAR_PA3EN_MASK                8U


/*** DLYCT - Delay Counter Control Register; 0x00000069 ***/
typedef union {
  byte Byte;
  struct {
    byte DLY0        :1;                                       /* Delay Counter Select 0 */
    byte DLY1        :1;                                       /* Delay Counter Select 1 */
    byte DLY2        :1;                                       /* Delay Counter Select 2 */
    byte DLY3        :1;                                       /* Delay Counter Select 3 */
    byte DLY4        :1;                                       /* Delay Counter Select 4 */
    byte DLY5        :1;                                       /* Delay Counter Select 5 */
    byte DLY6        :1;                                       /* Delay Counter Select 6 */
    byte DLY7        :1;                                       /* Delay Counter Select 7 */
  } Bits;
} DLYCTSTR;
extern volatile DLYCTSTR _DLYCT @(REG_BASE + 0x00000069UL);
#define DLYCT                           _DLYCT.Byte
#define DLYCT_DLY0                      _DLYCT.Bits.DLY0
#define DLYCT_DLY1                      _DLYCT.Bits.DLY1
#define DLYCT_DLY2                      _DLYCT.Bits.DLY2
#define DLYCT_DLY3                      _DLYCT.Bits.DLY3
#define DLYCT_DLY4                      _DLYCT.Bits.DLY4
#define DLYCT_DLY5                      _DLYCT.Bits.DLY5
#define DLYCT_DLY6                      _DLYCT.Bits.DLY6
#define DLYCT_DLY7                      _DLYCT.Bits.DLY7

#define DLYCT_DLY0_MASK                 1U
#define DLYCT_DLY1_MASK                 2U
#define DLYCT_DLY2_MASK                 4U
#define DLYCT_DLY3_MASK                 8U
#define DLYCT_DLY4_MASK                 16U
#define DLYCT_DLY5_MASK                 32U
#define DLYCT_DLY6_MASK                 64U
#define DLYCT_DLY7_MASK                 128U


/*** ICOVW - Input Control Overwrite Register; 0x0000006A ***/
typedef union {
  byte Byte;
  struct {
    byte NOVW0       :1;                                       /* No Input Capture Overwrite 0 */
    byte NOVW1       :1;                                       /* No Input Capture Overwrite 1 */
    byte NOVW2       :1;                                       /* No Input Capture Overwrite 2 */
    byte NOVW3       :1;                                       /* No Input Capture Overwrite 3 */
    byte NOVW4       :1;                                       /* No Input Capture Overwrite 4 */
    byte NOVW5       :1;                                       /* No Input Capture Overwrite 5 */
    byte NOVW6       :1;                                       /* No Input Capture Overwrite 6 */
    byte NOVW7       :1;                                       /* No Input Capture Overwrite 7 */
  } Bits;
} ICOVWSTR;
extern volatile ICOVWSTR _ICOVW @(REG_BASE + 0x0000006AUL);
#define ICOVW                           _ICOVW.Byte
#define ICOVW_NOVW0                     _ICOVW.Bits.NOVW0
#define ICOVW_NOVW1                     _ICOVW.Bits.NOVW1
#define ICOVW_NOVW2                     _ICOVW.Bits.NOVW2
#define ICOVW_NOVW3                     _ICOVW.Bits.NOVW3
#define ICOVW_NOVW4                     _ICOVW.Bits.NOVW4
#define ICOVW_NOVW5                     _ICOVW.Bits.NOVW5
#define ICOVW_NOVW6                     _ICOVW.Bits.NOVW6
#define ICOVW_NOVW7                     _ICOVW.Bits.NOVW7

#define ICOVW_NOVW0_MASK                1U
#define ICOVW_NOVW1_MASK                2U
#define ICOVW_NOVW2_MASK                4U
#define ICOVW_NOVW3_MASK                8U
#define ICOVW_NOVW4_MASK                16U
#define ICOVW_NOVW5_MASK                32U
#define ICOVW_NOVW6_MASK                64U
#define ICOVW_NOVW7_MASK                128U


/*** ICSYS - Input Control System Control Register; 0x0000006B ***/
typedef union {
  byte Byte;
  struct {
    byte LATQ        :1;                                       /* Input Control Latch or Queue Mode Enable */
    byte BUFEN       :1;                                       /* IC Buffer Enable */
    byte PACMX       :1;                                       /* 8-Bit Pulse Accumulators Maximum Count */
    byte TFMOD       :1;                                       /* Timer Flag-setting Mode */
    byte SH04        :1;                                       /* Share Input action of Input Capture Channels 0 and 4 */
    byte SH15        :1;                                       /* Share Input action of Input Capture Channels 1 and 5 */
    byte SH26        :1;                                       /* Share Input action of Input Capture Channels 2 and 6 */
    byte SH37        :1;                                       /* Share Input action of Input Capture Channels 3 and 7 */
  } Bits;
} ICSYSSTR;
extern volatile ICSYSSTR _ICSYS @(REG_BASE + 0x0000006BUL);
#define ICSYS                           _ICSYS.Byte
#define ICSYS_LATQ                      _ICSYS.Bits.LATQ
#define ICSYS_BUFEN                     _ICSYS.Bits.BUFEN
#define ICSYS_PACMX                     _ICSYS.Bits.PACMX
#define ICSYS_TFMOD                     _ICSYS.Bits.TFMOD
#define ICSYS_SH04                      _ICSYS.Bits.SH04
#define ICSYS_SH15                      _ICSYS.Bits.SH15
#define ICSYS_SH26                      _ICSYS.Bits.SH26
#define ICSYS_SH37                      _ICSYS.Bits.SH37

#define ICSYS_LATQ_MASK                 1U
#define ICSYS_BUFEN_MASK                2U
#define ICSYS_PACMX_MASK                4U
#define ICSYS_TFMOD_MASK                8U
#define ICSYS_SH04_MASK                 16U
#define ICSYS_SH15_MASK                 32U
#define ICSYS_SH26_MASK                 64U
#define ICSYS_SH37_MASK                 128U


/*** OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***/
typedef union {
  byte Byte;
  struct {
    byte OCPD0       :1;                                       /* Output Compare Pin Disconnect Bit 0 */
    byte OCPD1       :1;                                       /* Output Compare Pin Disconnect Bit 1 */
    byte OCPD2       :1;                                       /* Output Compare Pin Disconnect Bit 2 */
    byte OCPD3       :1;                                       /* Output Compare Pin Disconnect Bit 3 */
    byte OCPD4       :1;                                       /* Output Compare Pin Disconnect Bit 4 */
    byte OCPD5       :1;                                       /* Output Compare Pin Disconnect Bit 5 */
    byte OCPD6       :1;                                       /* Output Compare Pin Disconnect Bit 6 */
    byte OCPD7       :1;                                       /* Output Compare Pin Disconnect Bit 7 */
  } Bits;
} OCPDSTR;
extern volatile OCPDSTR _OCPD @(REG_BASE + 0x0000006CUL);
#define OCPD                            _OCPD.Byte
#define OCPD_OCPD0                      _OCPD.Bits.OCPD0
#define OCPD_OCPD1                      _OCPD.Bits.OCPD1
#define OCPD_OCPD2                      _OCPD.Bits.OCPD2
#define OCPD_OCPD3                      _OCPD.Bits.OCPD3
#define OCPD_OCPD4                      _OCPD.Bits.OCPD4
#define OCPD_OCPD5                      _OCPD.Bits.OCPD5
#define OCPD_OCPD6                      _OCPD.Bits.OCPD6
#define OCPD_OCPD7                      _OCPD.Bits.OCPD7

#define OCPD_OCPD0_MASK                 1U
#define OCPD_OCPD1_MASK                 2U
#define OCPD_OCPD2_MASK                 4U
#define OCPD_OCPD3_MASK                 8U
#define OCPD_OCPD4_MASK                 16U
#define OCPD_OCPD5_MASK                 32U
#define OCPD_OCPD6_MASK                 64U
#define OCPD_OCPD7_MASK                 128U


/*** PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***/
typedef union {
  byte Byte;
  struct {
    byte PTPS0       :1;                                       /* Precision Timer Prescaler Select, bit 0 */
    byte PTPS1       :1;                                       /* Precision Timer Prescaler Select, bit 1 */
    byte PTPS2       :1;                                       /* Precision Timer Prescaler Select, bit 2 */
    byte PTPS3       :1;                                       /* Precision Timer Prescaler Select, bit 3 */
    byte PTPS4       :1;                                       /* Precision Timer Prescaler Select, bit 4 */
    byte PTPS5       :1;                                       /* Precision Timer Prescaler Select, bit 5 */
    byte PTPS6       :1;                                       /* Precision Timer Prescaler Select, bit 6 */
    byte PTPS7       :1;                                       /* Precision Timer Prescaler Select, bit 7 */
  } Bits;
} PTPSRSTR;
extern volatile PTPSRSTR _PTPSR @(REG_BASE + 0x0000006EUL);
#define PTPSR                           _PTPSR.Byte
#define PTPSR_PTPS0                     _PTPSR.Bits.PTPS0
#define PTPSR_PTPS1                     _PTPSR.Bits.PTPS1
#define PTPSR_PTPS2                     _PTPSR.Bits.PTPS2
#define PTPSR_PTPS3                     _PTPSR.Bits.PTPS3
#define PTPSR_PTPS4                     _PTPSR.Bits.PTPS4
#define PTPSR_PTPS5                     _PTPSR.Bits.PTPS5
#define PTPSR_PTPS6                     _PTPSR.Bits.PTPS6
#define PTPSR_PTPS7                     _PTPSR.Bits.PTPS7

#define PTPSR_PTPS0_MASK                1U
#define PTPSR_PTPS1_MASK                2U
#define PTPSR_PTPS2_MASK                4U
#define PTPSR_PTPS3_MASK                8U
#define PTPSR_PTPS4_MASK                16U
#define PTPSR_PTPS5_MASK                32U
#define PTPSR_PTPS6_MASK                64U
#define PTPSR_PTPS7_MASK                128U


/*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***/
typedef union {
  byte Byte;
  struct {
    byte PTMPS0      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 0 */
    byte PTMPS1      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 1 */
    byte PTMPS2      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 2 */
    byte PTMPS3      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 3 */
    byte PTMPS4      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 4 */
    byte PTMPS5      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 5 */
    byte PTMPS6      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 6 */
    byte PTMPS7      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 7 */
  } Bits;
} PTMCPSRSTR;
extern volatile PTMCPSRSTR _PTMCPSR @(REG_BASE + 0x0000006FUL);
#define PTMCPSR                         _PTMCPSR.Byte
#define PTMCPSR_PTMPS0                  _PTMCPSR.Bits.PTMPS0
#define PTMCPSR_PTMPS1                  _PTMCPSR.Bits.PTMPS1
#define PTMCPSR_PTMPS2                  _PTMCPSR.Bits.PTMPS2
#define PTMCPSR_PTMPS3                  _PTMCPSR.Bits.PTMPS3
#define PTMCPSR_PTMPS4                  _PTMCPSR.Bits.PTMPS4
#define PTMCPSR_PTMPS5                  _PTMCPSR.Bits.PTMPS5
#define PTMCPSR_PTMPS6                  _PTMCPSR.Bits.PTMPS6
#define PTMCPSR_PTMPS7                  _PTMCPSR.Bits.PTMPS7

#define PTMCPSR_PTMPS0_MASK             1U
#define PTMCPSR_PTMPS1_MASK             2U
#define PTMCPSR_PTMPS2_MASK             4U
#define PTMCPSR_PTMPS3_MASK             8U
#define PTMCPSR_PTMPS4_MASK             16U
#define PTMCPSR_PTMPS5_MASK             32U
#define PTMCPSR_PTMPS6_MASK             64U
#define PTMCPSR_PTMPS7_MASK             128U


/*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PBOVI       :1;                                       /* Pulse Accumulator B Overflow Interrupt enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PBEN        :1;                                       /* Pulse Accumulator B System Enable */
    byte             :1; 
  } Bits;
} PBCTLSTR;
extern volatile PBCTLSTR _PBCTL @(REG_BASE + 0x00000070UL);
#define PBCTL                           _PBCTL.Byte
#define PBCTL_PBOVI                     _PBCTL.Bits.PBOVI
#define PBCTL_PBEN                      _PBCTL.Bits.PBEN

#define PBCTL_PBOVI_MASK                2U
#define PBCTL_PBEN_MASK                 64U


/*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PBOVF       :1;                                       /* Pulse Accumulator B Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PBFLGSTR;
extern volatile PBFLGSTR _PBFLG @(REG_BASE + 0x00000071UL);
#define PBFLG                           _PBFLG.Byte
#define PBFLG_PBOVF                     _PBFLG.Bits.PBOVF

#define PBFLG_PBOVF_MASK                2U


/*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***/
    union {
      byte Byte;
    } PA3HSTR;
    #define PA3H                        _PA32H.Overlap_STR.PA3HSTR.Byte
    

    /*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***/
    union {
      byte Byte;
    } PA2HSTR;
    #define PA2H                        _PA32H.Overlap_STR.PA2HSTR.Byte
    
  } Overlap_STR;

} PA32HSTR;
extern volatile PA32HSTR _PA32H @(REG_BASE + 0x00000072UL);
#define PA32H                           _PA32H.Word


/*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***/
    union {
      byte Byte;
    } PA1HSTR;
    #define PA1H                        _PA10H.Overlap_STR.PA1HSTR.Byte
    

    /*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***/
    union {
      byte Byte;
    } PA0HSTR;
    #define PA0H                        _PA10H.Overlap_STR.PA0HSTR.Byte
    
  } Overlap_STR;

} PA10HSTR;
extern volatile PA10HSTR _PA10H @(REG_BASE + 0x00000074UL);
#define PA10H                           _PA10H.Word


/*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***/
    union {
      byte Byte;
    } MCCNThiSTR;
    #define MCCNThi                     _MCCNT.Overlap_STR.MCCNThiSTR.Byte
    

    /*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***/
    union {
      byte Byte;
    } MCCNTloSTR;
    #define MCCNTlo                     _MCCNT.Overlap_STR.MCCNTloSTR.Byte
    
  } Overlap_STR;

} MCCNTSTR;
extern volatile MCCNTSTR _MCCNT @(REG_BASE + 0x00000076UL);
#define MCCNT                           _MCCNT.Word


/*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hhi - Timer Input Capture Holding Registers High; 0x00000078 ***/
    union {
      byte Byte;
    } TC0HhiSTR;
    #define TC0Hhi                      _TC0H.Overlap_STR.TC0HhiSTR.Byte
    

    /*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***/
    union {
      byte Byte;
    } TC0HloSTR;
    #define TC0Hlo                      _TC0H.Overlap_STR.TC0HloSTR.Byte
    
  } Overlap_STR;

} TC0HSTR;
extern volatile TC0HSTR _TC0H @(REG_BASE + 0x00000078UL);
#define TC0H                            _TC0H.Word


/*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***/
    union {
      byte Byte;
    } TC1HhiSTR;
    #define TC1Hhi                      _TC1H.Overlap_STR.TC1HhiSTR.Byte
    

    /*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***/
    union {
      byte Byte;
    } TC1HloSTR;
    #define TC1Hlo                      _TC1H.Overlap_STR.TC1HloSTR.Byte
    
  } Overlap_STR;

} TC1HSTR;
extern volatile TC1HSTR _TC1H @(REG_BASE + 0x0000007AUL);
#define TC1H                            _TC1H.Word


/*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***/
    union {
      byte Byte;
    } TC2HhiSTR;
    #define TC2Hhi                      _TC2H.Overlap_STR.TC2HhiSTR.Byte
    

    /*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***/
    union {
      byte Byte;
    } TC2HloSTR;
    #define TC2Hlo                      _TC2H.Overlap_STR.TC2HloSTR.Byte
    
  } Overlap_STR;

} TC2HSTR;
extern volatile TC2HSTR _TC2H @(REG_BASE + 0x0000007CUL);
#define TC2H                            _TC2H.Word


/*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***/
    union {
      byte Byte;
    } TC3HhiSTR;
    #define TC3Hhi                      _TC3H.Overlap_STR.TC3HhiSTR.Byte
    

    /*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***/
    union {
      byte Byte;
    } TC3HloSTR;
    #define TC3Hlo                      _TC3H.Overlap_STR.TC3HloSTR.Byte
    
  } Overlap_STR;

} TC3HSTR;
extern volatile TC3HSTR _TC3H @(REG_BASE + 0x0000007EUL);
#define TC3H                            _TC3H.Word


/*** ATDCTL01 - ATD  Control Register 01; 0x00000080 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL0 - ATD  Control Register 0; 0x00000080 ***/
    union {
      byte Byte;
      struct {
        byte WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
        byte WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
        byte WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
        byte WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpWRAP :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL0STR;
    #define ATDCTL0                     _ATDCTL01.Overlap_STR.ATDCTL0STR.Byte
    #define ATDCTL0_WRAP0               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP0
    #define ATDCTL0_WRAP1               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP1
    #define ATDCTL0_WRAP2               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP2
    #define ATDCTL0_WRAP3               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP3
    /* ATDCTL_ARR: Access 6 ATDCTLx registers in an array */
    #define ATDCTL_ARR                  ((volatile byte *) &ATDCTL0)
    #define ATDCTL0_WRAP                _ATDCTL01.Overlap_STR.ATDCTL0STR.MergedBits.grpWRAP
    
    #define ATDCTL0_WRAP0_MASK          1U
    #define ATDCTL0_WRAP1_MASK          2U
    #define ATDCTL0_WRAP2_MASK          4U
    #define ATDCTL0_WRAP3_MASK          8U
    #define ATDCTL0_WRAP_MASK           15U
    #define ATDCTL0_WRAP_BITNUM         0U
    

    /*** ATDCTL1 - ATD  Control Register 1; 0x00000081 ***/
    union {
      byte Byte;
      struct {
        byte ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
        byte ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
        byte ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
        byte ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ETRIGSEL    :1;                                       /* External Trigger Source Select */
      } Bits;
      struct {
        byte grpETRIGCH :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL1STR;
    #define ATDCTL1                     _ATDCTL01.Overlap_STR.ATDCTL1STR.Byte
    #define ATDCTL1_ETRIGCH0            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH0
    #define ATDCTL1_ETRIGCH1            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH1
    #define ATDCTL1_ETRIGCH2            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH2
    #define ATDCTL1_ETRIGCH3            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH3
    #define ATDCTL1_ETRIGSEL            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGSEL
    #define ATDCTL1_ETRIGCH             _ATDCTL01.Overlap_STR.ATDCTL1STR.MergedBits.grpETRIGCH
    
    #define ATDCTL1_ETRIGCH0_MASK       1U
    #define ATDCTL1_ETRIGCH1_MASK       2U
    #define ATDCTL1_ETRIGCH2_MASK       4U
    #define ATDCTL1_ETRIGCH3_MASK       8U
    #define ATDCTL1_ETRIGSEL_MASK       128U
    #define ATDCTL1_ETRIGCH_MASK        15U
    #define ATDCTL1_ETRIGCH_BITNUM      0U
    
  } Overlap_STR;

  struct {
    word ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
    word ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
    word ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
    word ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word ETRIGSEL    :1;                                       /* External Trigger Source Select */
    word WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
    word WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
    word WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
    word WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpETRIGCH :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpWRAP :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCTL01STR;
extern volatile ATDCTL01STR _ATDCTL01 @(REG_BASE + 0x00000080UL);
#define ATDCTL01                        _ATDCTL01.Word
#define ATDCTL01_ETRIGCH0               _ATDCTL01.Bits.ETRIGCH0
#define ATDCTL01_ETRIGCH1               _ATDCTL01.Bits.ETRIGCH1
#define ATDCTL01_ETRIGCH2               _ATDCTL01.Bits.ETRIGCH2
#define ATDCTL01_ETRIGCH3               _ATDCTL01.Bits.ETRIGCH3
#define ATDCTL01_ETRIGSEL               _ATDCTL01.Bits.ETRIGSEL
#define ATDCTL01_WRAP0                  _ATDCTL01.Bits.WRAP0
#define ATDCTL01_WRAP1                  _ATDCTL01.Bits.WRAP1
#define ATDCTL01_WRAP2                  _ATDCTL01.Bits.WRAP2
#define ATDCTL01_WRAP3                  _ATDCTL01.Bits.WRAP3
#define ATDCTL01_ETRIGCH                _ATDCTL01.MergedBits.grpETRIGCH
#define ATDCTL01_WRAP                   _ATDCTL01.MergedBits.grpWRAP

#define ATDCTL01_ETRIGCH0_MASK          1U
#define ATDCTL01_ETRIGCH1_MASK          2U
#define ATDCTL01_ETRIGCH2_MASK          4U
#define ATDCTL01_ETRIGCH3_MASK          8U
#define ATDCTL01_ETRIGSEL_MASK          128U
#define ATDCTL01_WRAP0_MASK             256U
#define ATDCTL01_WRAP1_MASK             512U
#define ATDCTL01_WRAP2_MASK             1024U
#define ATDCTL01_WRAP3_MASK             2048U
#define ATDCTL01_ETRIGCH_MASK           15U
#define ATDCTL01_ETRIGCH_BITNUM         0U
#define ATDCTL01_WRAP_MASK              3840U
#define ATDCTL01_WRAP_BITNUM            8U


/*** ATDCTL23 - ATD  Control Register 23; 0x00000082 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL2 - ATD  Control Register 2; 0x00000082 ***/
    union {
      byte Byte;
      struct {
        byte ASCIF       :1;                                       /* ATD  Sequence Complete Interrupt Flag */
        byte ASCIE       :1;                                       /* ATD  Sequence Complete Interrupt Enable */
        byte ETRIGE      :1;                                       /* External Trigger Mode enable */
        byte ETRIGP      :1;                                       /* External Trigger Polarity */
        byte ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
        byte AWAI        :1;                                       /* ATD Power Down in Wait Mode */
        byte AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
        byte ADPU        :1;                                       /* ATD Disable / Power Down */
      } Bits;
    } ATDCTL2STR;
    #define ATDCTL2                     _ATDCTL23.Overlap_STR.ATDCTL2STR.Byte
    #define ATDCTL2_ASCIF               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIF
    #define ATDCTL2_ASCIE               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIE
    #define ATDCTL2_ETRIGE              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGE
    #define ATDCTL2_ETRIGP              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGP
    #define ATDCTL2_ETRIGLE             _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGLE
    #define ATDCTL2_AWAI                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AWAI
    #define ATDCTL2_AFFC                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AFFC
    #define ATDCTL2_ADPU                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ADPU
    
    #define ATDCTL2_ASCIF_MASK          1U
    #define ATDCTL2_ASCIE_MASK          2U
    #define ATDCTL2_ETRIGE_MASK         4U
    #define ATDCTL2_ETRIGP_MASK         8U
    #define ATDCTL2_ETRIGLE_MASK        16U
    #define ATDCTL2_AWAI_MASK           32U
    #define ATDCTL2_AFFC_MASK           64U
    #define ATDCTL2_ADPU_MASK           128U
    

    /*** ATDCTL3 - ATD  Control Register 3; 0x00000083 ***/
    union {
      byte Byte;
      struct {
        byte FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
        byte FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
        byte FIFO        :1;                                       /* Result Register FIFO Mode */
        byte S1C         :1;                                       /* Conversion Sequence Length 1 */
        byte S2C         :1;                                       /* Conversion Sequence Length 2 */
        byte S4C         :1;                                       /* Conversion Sequence Length 4 */
        byte S8C         :1;                                       /* Conversion Sequence Length 8 */
        byte             :1; 
      } Bits;
      struct {
        byte grpFRZ :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL3STR;
    #define ATDCTL3                     _ATDCTL23.Overlap_STR.ATDCTL3STR.Byte
    #define ATDCTL3_FRZ0                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ0
    #define ATDCTL3_FRZ1                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ1
    #define ATDCTL3_FIFO                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FIFO
    #define ATDCTL3_S1C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S1C
    #define ATDCTL3_S2C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S2C
    #define ATDCTL3_S4C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S4C
    #define ATDCTL3_S8C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S8C
    #define ATDCTL3_FRZ                 _ATDCTL23.Overlap_STR.ATDCTL3STR.MergedBits.grpFRZ
    
    #define ATDCTL3_FRZ0_MASK           1U
    #define ATDCTL3_FRZ1_MASK           2U
    #define ATDCTL3_FIFO_MASK           4U
    #define ATDCTL3_S1C_MASK            8U
    #define ATDCTL3_S2C_MASK            16U
    #define ATDCTL3_S4C_MASK            32U
    #define ATDCTL3_S8C_MASK            64U
    #define ATDCTL3_FRZ_MASK            3U
    #define ATDCTL3_FRZ_BITNUM          0U
    
  } Overlap_STR;

  struct {
    word FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
    word FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
    word FIFO        :1;                                       /* Result Register FIFO Mode */
    word S1C         :1;                                       /* Conversion Sequence Length 1 */
    word S2C         :1;                                       /* Conversion Sequence Length 2 */
    word S4C         :1;                                       /* Conversion Sequence Length 4 */
    word S8C         :1;                                       /* Conversion Sequence Length 8 */
    word             :1; 
    word ASCIF       :1;                                       /* ATD  Sequence Complete Interrupt Flag */
    word ASCIE       :1;                                       /* ATD  Sequence Complete Interrupt Enable */
    word ETRIGE      :1;                                       /* External Trigger Mode enable */
    word ETRIGP      :1;                                       /* External Trigger Polarity */
    word ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
    word AWAI        :1;                                       /* ATD Power Down in Wait Mode */
    word AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
    word ADPU        :1;                                       /* ATD Disable / Power Down */
  } Bits;
  struct {
    word grpFRZ  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCTL23STR;
extern volatile ATDCTL23STR _ATDCTL23 @(REG_BASE + 0x00000082UL);
#define ATDCTL23                        _ATDCTL23.Word
#define ATDCTL23_FRZ0                   _ATDCTL23.Bits.FRZ0
#define ATDCTL23_FRZ1                   _ATDCTL23.Bits.FRZ1
#define ATDCTL23_FIFO                   _ATDCTL23.Bits.FIFO
#define ATDCTL23_S1C                    _ATDCTL23.Bits.S1C
#define ATDCTL23_S2C                    _ATDCTL23.Bits.S2C
#define ATDCTL23_S4C                    _ATDCTL23.Bits.S4C
#define ATDCTL23_S8C                    _ATDCTL23.Bits.S8C
#define ATDCTL23_ASCIF                  _ATDCTL23.Bits.ASCIF
#define ATDCTL23_ASCIE                  _ATDCTL23.Bits.ASCIE
#define ATDCTL23_ETRIGE                 _ATDCTL23.Bits.ETRIGE
#define ATDCTL23_ETRIGP                 _ATDCTL23.Bits.ETRIGP
#define ATDCTL23_ETRIGLE                _ATDCTL23.Bits.ETRIGLE
#define ATDCTL23_AWAI                   _ATDCTL23.Bits.AWAI
#define ATDCTL23_AFFC                   _ATDCTL23.Bits.AFFC
#define ATDCTL23_ADPU                   _ATDCTL23.Bits.ADPU
#define ATDCTL23_FRZ                    _ATDCTL23.MergedBits.grpFRZ

#define ATDCTL23_FRZ0_MASK              1U
#define ATDCTL23_FRZ1_MASK              2U
#define ATDCTL23_FIFO_MASK              4U
#define ATDCTL23_S1C_MASK               8U
#define ATDCTL23_S2C_MASK               16U
#define ATDCTL23_S4C_MASK               32U
#define ATDCTL23_S8C_MASK               64U
#define ATDCTL23_ASCIF_MASK             256U
#define ATDCTL23_ASCIE_MASK             512U
#define ATDCTL23_ETRIGE_MASK            1024U
#define ATDCTL23_ETRIGP_MASK            2048U
#define ATDCTL23_ETRIGLE_MASK           4096U
#define ATDCTL23_AWAI_MASK              8192U
#define ATDCTL23_AFFC_MASK              16384U
#define ATDCTL23_ADPU_MASK              32768U
#define ATDCTL23_FRZ_MASK               3U
#define ATDCTL23_FRZ_BITNUM             0U


/*** ATDCTL45 - ATD  Control Register 45; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL4 - ATD  Control Register 4; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte PRS0        :1;                                       /* ATD Clock Prescaler 0 */
        byte PRS1        :1;                                       /* ATD Clock Prescaler 1 */
        byte PRS2        :1;                                       /* ATD Clock Prescaler 2 */
        byte PRS3        :1;                                       /* ATD Clock Prescaler 3 */
        byte PRS4        :1;                                       /* ATD Clock Prescaler 4 */
        byte SMP0        :1;                                       /* Sample Time Select 0 */
        byte SMP1        :1;                                       /* Sample Time Select 1 */
        byte SRES8       :1;                                       /* ATD Resolution Select */
      } Bits;
      struct {
        byte grpPRS :5;
        byte grpSMP :2;
        byte grpSRES_8 :1;
      } MergedBits;
    } ATDCTL4STR;
    #define ATDCTL4                     _ATDCTL45.Overlap_STR.ATDCTL4STR.Byte
    #define ATDCTL4_PRS0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS0
    #define ATDCTL4_PRS1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS1
    #define ATDCTL4_PRS2                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS2
    #define ATDCTL4_PRS3                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS3
    #define ATDCTL4_PRS4                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS4
    #define ATDCTL4_SMP0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP0
    #define ATDCTL4_SMP1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP1
    #define ATDCTL4_SRES8               _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SRES8
    #define ATDCTL4_PRS                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpPRS
    #define ATDCTL4_SMP                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpSMP
    
    #define ATDCTL4_PRS0_MASK           1U
    #define ATDCTL4_PRS1_MASK           2U
    #define ATDCTL4_PRS2_MASK           4U
    #define ATDCTL4_PRS3_MASK           8U
    #define ATDCTL4_PRS4_MASK           16U
    #define ATDCTL4_SMP0_MASK           32U
    #define ATDCTL4_SMP1_MASK           64U
    #define ATDCTL4_SRES8_MASK          128U
    #define ATDCTL4_PRS_MASK            31U
    #define ATDCTL4_PRS_BITNUM          0U
    #define ATDCTL4_SMP_MASK            96U
    #define ATDCTL4_SMP_BITNUM          5U
    

    /*** ATDCTL5 - ATD  Control Register 5; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte CA          :1;                                       /* Analog Input Channel Select Code A */
        byte CB          :1;                                       /* Analog Input Channel Select Code B */
        byte CC          :1;                                       /* Analog Input Channel Select Code C */
        byte CD          :1;                                       /* Analog Input Channel Select Code D */
        byte MULT        :1;                                       /* Multi-Channel Sample Mode */
        byte SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
        byte DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
        byte DJM         :1;                                       /* Result Register Data Justification Mode */
      } Bits;
      struct {
        byte grpCx :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL5STR;
    #define ATDCTL5                     _ATDCTL45.Overlap_STR.ATDCTL5STR.Byte
    #define ATDCTL5_CA                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CA
    #define ATDCTL5_CB                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CB
    #define ATDCTL5_CC                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CC
    #define ATDCTL5_CD                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CD
    #define ATDCTL5_MULT                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.MULT
    #define ATDCTL5_SCAN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.SCAN
    #define ATDCTL5_DSGN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.DSGN
    #define ATDCTL5_DJM                 _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.DJM
    #define ATDCTL5_Cx                  _ATDCTL45.Overlap_STR.ATDCTL5STR.MergedBits.grpCx
    
    #define ATDCTL5_CA_MASK             1U
    #define ATDCTL5_CB_MASK             2U
    #define ATDCTL5_CC_MASK             4U
    #define ATDCTL5_CD_MASK             8U
    #define ATDCTL5_MULT_MASK           16U
    #define ATDCTL5_SCAN_MASK           32U
    #define ATDCTL5_DSGN_MASK           64U
    #define ATDCTL5_DJM_MASK            128U
    #define ATDCTL5_Cx_MASK             15U
    #define ATDCTL5_Cx_BITNUM           0U
    
  } Overlap_STR;

  struct {
    word CA          :1;                                       /* Analog Input Channel Select Code A */
    word CB          :1;                                       /* Analog Input Channel Select Code B */
    word CC          :1;                                       /* Analog Input Channel Select Code C */
    word CD          :1;                                       /* Analog Input Channel Select Code D */
    word MULT        :1;                                       /* Multi-Channel Sample Mode */
    word SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
    word DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
    word DJM         :1;                                       /* Result Register Data Justification Mode */
    word PRS0        :1;                                       /* ATD Clock Prescaler 0 */
    word PRS1        :1;                                       /* ATD Clock Prescaler 1 */
    word PRS2        :1;                                       /* ATD Clock Prescaler 2 */
    word PRS3        :1;                                       /* ATD Clock Prescaler 3 */
    word PRS4        :1;                                       /* ATD Clock Prescaler 4 */
    word SMP0        :1;                                       /* Sample Time Select 0 */
    word SMP1        :1;                                       /* Sample Time Select 1 */
    word SRES8       :1;                                       /* ATD Resolution Select */
  } Bits;
  struct {
    word grpCx   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRS  :5;
    word grpSMP  :2;
    word grpSRES_8 :1;
  } MergedBits;
} ATDCTL45STR;
extern volatile ATDCTL45STR _ATDCTL45 @(REG_BASE + 0x00000084UL);
#define ATDCTL45                        _ATDCTL45.Word
#define ATDCTL45_CA                     _ATDCTL45.Bits.CA
#define ATDCTL45_CB                     _ATDCTL45.Bits.CB
#define ATDCTL45_CC                     _ATDCTL45.Bits.CC
#define ATDCTL45_CD                     _ATDCTL45.Bits.CD
#define ATDCTL45_MULT                   _ATDCTL45.Bits.MULT
#define ATDCTL45_SCAN                   _ATDCTL45.Bits.SCAN
#define ATDCTL45_DSGN                   _ATDCTL45.Bits.DSGN
#define ATDCTL45_DJM                    _ATDCTL45.Bits.DJM
#define ATDCTL45_PRS0                   _ATDCTL45.Bits.PRS0
#define ATDCTL45_PRS1                   _ATDCTL45.Bits.PRS1
#define ATDCTL45_PRS2                   _ATDCTL45.Bits.PRS2
#define ATDCTL45_PRS3                   _ATDCTL45.Bits.PRS3
#define ATDCTL45_PRS4                   _ATDCTL45.Bits.PRS4
#define ATDCTL45_SMP0                   _ATDCTL45.Bits.SMP0
#define ATDCTL45_SMP1                   _ATDCTL45.Bits.SMP1
#define ATDCTL45_SRES8                  _ATDCTL45.Bits.SRES8
#define ATDCTL45_Cx                     _ATDCTL45.MergedBits.grpCx
#define ATDCTL45_PRS                    _ATDCTL45.MergedBits.grpPRS
#define ATDCTL45_SMP                    _ATDCTL45.MergedBits.grpSMP

#define ATDCTL45_CA_MASK                1U
#define ATDCTL45_CB_MASK                2U
#define ATDCTL45_CC_MASK                4U
#define ATDCTL45_CD_MASK                8U
#define ATDCTL45_MULT_MASK              16U
#define ATDCTL45_SCAN_MASK              32U
#define ATDCTL45_DSGN_MASK              64U
#define ATDCTL45_DJM_MASK               128U
#define ATDCTL45_PRS0_MASK              256U
#define ATDCTL45_PRS1_MASK              512U
#define ATDCTL45_PRS2_MASK              1024U
#define ATDCTL45_PRS3_MASK              2048U
#define ATDCTL45_PRS4_MASK              4096U
#define ATDCTL45_SMP0_MASK              8192U
#define ATDCTL45_SMP1_MASK              16384U
#define ATDCTL45_SRES8_MASK             32768U
#define ATDCTL45_Cx_MASK                15U
#define ATDCTL45_Cx_BITNUM              0U
#define ATDCTL45_PRS_MASK               7936U
#define ATDCTL45_PRS_BITNUM             8U
#define ATDCTL45_SMP_MASK               24576U
#define ATDCTL45_SMP_BITNUM             13U


/*** ATDSTAT0 - ATD  Status Register 0; 0x00000086 ***/
typedef union {
  byte Byte;
  struct {
    byte CC0         :1;                                       /* Conversion Counter 0 */
    byte CC1         :1;                                       /* Conversion Counter 1 */
    byte CC2         :1;                                       /* Conversion Counter 2 */
    byte CC3         :1;                                       /* Conversion Counter 3 */
    byte FIFOR       :1;                                       /* FIFO Over Run Flag */
    byte ETORF       :1;                                       /* External Trigger Overrun Flag */
    byte             :1; 
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
  struct {
    byte grpCC   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ATDSTAT0STR;
extern volatile ATDSTAT0STR _ATDSTAT0 @(REG_BASE + 0x00000086UL);
#define ATDSTAT0                        _ATDSTAT0.Byte
#define ATDSTAT0_CC0                    _ATDSTAT0.Bits.CC0
#define ATDSTAT0_CC1                    _ATDSTAT0.Bits.CC1
#define ATDSTAT0_CC2                    _ATDSTAT0.Bits.CC2
#define ATDSTAT0_CC3                    _ATDSTAT0.Bits.CC3
#define ATDSTAT0_FIFOR                  _ATDSTAT0.Bits.FIFOR
#define ATDSTAT0_ETORF                  _ATDSTAT0.Bits.ETORF
#define ATDSTAT0_SCF                    _ATDSTAT0.Bits.SCF
#define ATDSTAT0_CC                     _ATDSTAT0.MergedBits.grpCC

#define ATDSTAT0_CC0_MASK               1U
#define ATDSTAT0_CC1_MASK               2U
#define ATDSTAT0_CC2_MASK               4U
#define ATDSTAT0_CC3_MASK               8U
#define ATDSTAT0_FIFOR_MASK             16U
#define ATDSTAT0_ETORF_MASK             32U
#define ATDSTAT0_SCF_MASK               128U
#define ATDSTAT0_CC_MASK                15U
#define ATDSTAT0_CC_BITNUM              0U


/*** ATDTEST1 - ATD Test Register; 0x00000089 ***/
typedef union {
  byte Byte;
  struct {
    byte SC          :1;                                       /* Special Channel Conversion Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ATDTEST1STR;
extern volatile ATDTEST1STR _ATDTEST1 @(REG_BASE + 0x00000089UL);
#define ATDTEST1                        _ATDTEST1.Byte
#define ATDTEST1_SC                     _ATDTEST1.Bits.SC

#define ATDTEST1_SC_MASK                1U


/*** ATDSTAT2 - ATD  Status Register 2; 0x0000008A ***/
typedef union {
  byte Byte;
  struct {
    byte CCF8        :1;                                       /* Conversion Complete Flag 8 */
    byte CCF9        :1;                                       /* Conversion Complete Flag 9 */
    byte CCF10       :1;                                       /* Conversion Complete Flag 10 */
    byte CCF11       :1;                                       /* Conversion Complete Flag 11 */
    byte CCF12       :1;                                       /* Conversion Complete Flag 12 */
    byte CCF13       :1;                                       /* Conversion Complete Flag 13 */
    byte CCF14       :1;                                       /* Conversion Complete Flag 14 */
    byte CCF15       :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
} ATDSTAT2STR;
extern volatile ATDSTAT2STR _ATDSTAT2 @(REG_BASE + 0x0000008AUL);
#define ATDSTAT2                        _ATDSTAT2.Byte
#define ATDSTAT2_CCF8                   _ATDSTAT2.Bits.CCF8
#define ATDSTAT2_CCF9                   _ATDSTAT2.Bits.CCF9
#define ATDSTAT2_CCF10                  _ATDSTAT2.Bits.CCF10
#define ATDSTAT2_CCF11                  _ATDSTAT2.Bits.CCF11
#define ATDSTAT2_CCF12                  _ATDSTAT2.Bits.CCF12
#define ATDSTAT2_CCF13                  _ATDSTAT2.Bits.CCF13
#define ATDSTAT2_CCF14                  _ATDSTAT2.Bits.CCF14
#define ATDSTAT2_CCF15                  _ATDSTAT2.Bits.CCF15

#define ATDSTAT2_CCF8_MASK              1U
#define ATDSTAT2_CCF9_MASK              2U
#define ATDSTAT2_CCF10_MASK             4U
#define ATDSTAT2_CCF11_MASK             8U
#define ATDSTAT2_CCF12_MASK             16U
#define ATDSTAT2_CCF13_MASK             32U
#define ATDSTAT2_CCF14_MASK             64U
#define ATDSTAT2_CCF15_MASK             128U


/*** ATDSTAT1 - ATD  Status Register 1; 0x0000008B ***/
typedef union {
  byte Byte;
  struct {
    byte CCF0        :1;                                       /* Conversion Complete Flag 0 */
    byte CCF1        :1;                                       /* Conversion Complete Flag 1 */
    byte CCF2        :1;                                       /* Conversion Complete Flag 2 */
    byte CCF3        :1;                                       /* Conversion Complete Flag 3 */
    byte CCF4        :1;                                       /* Conversion Complete Flag 4 */
    byte CCF5        :1;                                       /* Conversion Complete Flag 5 */
    byte CCF6        :1;                                       /* Conversion Complete Flag 6 */
    byte CCF7        :1;                                       /* Conversion Complete Flag 7 */
  } Bits;
} ATDSTAT1STR;
extern volatile ATDSTAT1STR _ATDSTAT1 @(REG_BASE + 0x0000008BUL);
#define ATDSTAT1                        _ATDSTAT1.Byte
#define ATDSTAT1_CCF0                   _ATDSTAT1.Bits.CCF0
#define ATDSTAT1_CCF1                   _ATDSTAT1.Bits.CCF1
#define ATDSTAT1_CCF2                   _ATDSTAT1.Bits.CCF2
#define ATDSTAT1_CCF3                   _ATDSTAT1.Bits.CCF3
#define ATDSTAT1_CCF4                   _ATDSTAT1.Bits.CCF4
#define ATDSTAT1_CCF5                   _ATDSTAT1.Bits.CCF5
#define ATDSTAT1_CCF6                   _ATDSTAT1.Bits.CCF6
#define ATDSTAT1_CCF7                   _ATDSTAT1.Bits.CCF7

#define ATDSTAT1_CCF0_MASK              1U
#define ATDSTAT1_CCF1_MASK              2U
#define ATDSTAT1_CCF2_MASK              4U
#define ATDSTAT1_CCF3_MASK              8U
#define ATDSTAT1_CCF4_MASK              16U
#define ATDSTAT1_CCF5_MASK              32U
#define ATDSTAT1_CCF6_MASK              64U
#define ATDSTAT1_CCF7_MASK              128U


/*** ATDDIEN - ATD  Input Enable Register; 0x0000008C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDIEN0 - ATD  Input Enable Register 0; 0x0000008C ***/
    union {
      byte Byte;
      struct {
        byte IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
        byte IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
        byte IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
        byte IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
        byte IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
        byte IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
        byte IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
        byte IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
      } Bits;
    } ATDDIEN0STR;
    #define ATDDIEN0                    _ATDDIEN.Overlap_STR.ATDDIEN0STR.Byte
    #define ATDDIEN0_IEN8               _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN8
    #define ATDDIEN0_IEN9               _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN9
    #define ATDDIEN0_IEN10              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN10
    #define ATDDIEN0_IEN11              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN11
    #define ATDDIEN0_IEN12              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN12
    #define ATDDIEN0_IEN13              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN13
    #define ATDDIEN0_IEN14              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN14
    #define ATDDIEN0_IEN15              _ATDDIEN.Overlap_STR.ATDDIEN0STR.Bits.IEN15
    /* ATDDIEN_ARR: Access 2 ATDDIENx registers in an array */
    #define ATDDIEN_ARR                 ((volatile byte *) &ATDDIEN0)
    
    #define ATDDIEN0_IEN8_MASK          1U
    #define ATDDIEN0_IEN9_MASK          2U
    #define ATDDIEN0_IEN10_MASK         4U
    #define ATDDIEN0_IEN11_MASK         8U
    #define ATDDIEN0_IEN12_MASK         16U
    #define ATDDIEN0_IEN13_MASK         32U
    #define ATDDIEN0_IEN14_MASK         64U
    #define ATDDIEN0_IEN15_MASK         128U
    

    /*** ATDDIEN1 - ATD  Input Enable Register 1; 0x0000008D ***/
    union {
      byte Byte;
      struct {
        byte IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
        byte IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
        byte IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
        byte IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
        byte IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
        byte IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
        byte IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
        byte IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
      } Bits;
    } ATDDIEN1STR;
    #define ATDDIEN1                    _ATDDIEN.Overlap_STR.ATDDIEN1STR.Byte
    #define ATDDIEN1_IEN0               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN0
    #define ATDDIEN1_IEN1               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN1
    #define ATDDIEN1_IEN2               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN2
    #define ATDDIEN1_IEN3               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN3
    #define ATDDIEN1_IEN4               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN4
    #define ATDDIEN1_IEN5               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN5
    #define ATDDIEN1_IEN6               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN6
    #define ATDDIEN1_IEN7               _ATDDIEN.Overlap_STR.ATDDIEN1STR.Bits.IEN7
    
    #define ATDDIEN1_IEN0_MASK          1U
    #define ATDDIEN1_IEN1_MASK          2U
    #define ATDDIEN1_IEN2_MASK          4U
    #define ATDDIEN1_IEN3_MASK          8U
    #define ATDDIEN1_IEN4_MASK          16U
    #define ATDDIEN1_IEN5_MASK          32U
    #define ATDDIEN1_IEN6_MASK          64U
    #define ATDDIEN1_IEN7_MASK          128U
    
  } Overlap_STR;

  struct {
    word IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
    word IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
    word IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
    word IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
    word IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
    word IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
    word IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
    word IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
    word IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
    word IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
    word IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
    word IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
    word IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
    word IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
    word IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
    word IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
  } Bits;
} ATDDIENSTR;
extern volatile ATDDIENSTR _ATDDIEN @(REG_BASE + 0x0000008CUL);
#define ATDDIEN                         _ATDDIEN.Word
#define ATDDIEN_IEN0                    _ATDDIEN.Bits.IEN0
#define ATDDIEN_IEN1                    _ATDDIEN.Bits.IEN1
#define ATDDIEN_IEN2                    _ATDDIEN.Bits.IEN2
#define ATDDIEN_IEN3                    _ATDDIEN.Bits.IEN3
#define ATDDIEN_IEN4                    _ATDDIEN.Bits.IEN4
#define ATDDIEN_IEN5                    _ATDDIEN.Bits.IEN5
#define ATDDIEN_IEN6                    _ATDDIEN.Bits.IEN6
#define ATDDIEN_IEN7                    _ATDDIEN.Bits.IEN7
#define ATDDIEN_IEN8                    _ATDDIEN.Bits.IEN8
#define ATDDIEN_IEN9                    _ATDDIEN.Bits.IEN9
#define ATDDIEN_IEN10                   _ATDDIEN.Bits.IEN10
#define ATDDIEN_IEN11                   _ATDDIEN.Bits.IEN11
#define ATDDIEN_IEN12                   _ATDDIEN.Bits.IEN12
#define ATDDIEN_IEN13                   _ATDDIEN.Bits.IEN13
#define ATDDIEN_IEN14                   _ATDDIEN.Bits.IEN14
#define ATDDIEN_IEN15                   _ATDDIEN.Bits.IEN15

#define ATDDIEN_IEN0_MASK               1U
#define ATDDIEN_IEN1_MASK               2U
#define ATDDIEN_IEN2_MASK               4U
#define ATDDIEN_IEN3_MASK               8U
#define ATDDIEN_IEN4_MASK               16U
#define ATDDIEN_IEN5_MASK               32U
#define ATDDIEN_IEN6_MASK               64U
#define ATDDIEN_IEN7_MASK               128U
#define ATDDIEN_IEN8_MASK               256U
#define ATDDIEN_IEN9_MASK               512U
#define ATDDIEN_IEN10_MASK              1024U
#define ATDDIEN_IEN11_MASK              2048U
#define ATDDIEN_IEN12_MASK              4096U
#define ATDDIEN_IEN13_MASK              8192U
#define ATDDIEN_IEN14_MASK              16384U
#define ATDDIEN_IEN15_MASK              32768U


/*** ATDPTAD - ATD  Port AD Register; 0x0000008E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDPTAD0 - ATD  Port AD0 Register; 0x0000008E ***/
    union {
      byte Byte;
      struct {
        byte PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
        byte PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
        byte PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
        byte PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
        byte PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
        byte PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
        byte PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
        byte PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
      } Bits;
    } ATDPTAD0STR;
    #define ATDPTAD0                    _ATDPTAD.Overlap_STR.ATDPTAD0STR.Byte
    #define ATDPTAD0_PTAD8              _ATDPTAD.Overlap_STR.ATDPTAD0STR.Bits.PTAD8
    #define ATDPTAD0_PTAD9              _ATDPTAD.Overlap_STR.ATDPTAD0STR.Bits.PTAD9
    #define ATDPTAD0_PTAD10             _ATDPTAD.Overlap_STR.ATDPTAD0STR.Bits.PTAD10
    #define ATDPTAD0_PTAD11             _ATDPTAD.Overlap_STR.ATDPTAD0STR.Bits.PTAD11
    #define ATDPTAD0_PTAD12             _ATDPTAD.Overlap_STR.ATDPTAD0STR.Bits.PTAD12
    #define ATDPTAD0_PTAD13             _ATDPTAD.Overlap_STR.ATDPTAD0STR.Bits.PTAD13
    #define ATDPTAD0_PTAD14             _ATDPTAD.Overlap_STR.ATDPTAD0STR.Bits.PTAD14
    #define ATDPTAD0_PTAD15             _ATDPTAD.Overlap_STR.ATDPTAD0STR.Bits.PTAD15
    /* ATDPTAD_ARR: Access 2 ATDPTADx registers in an array */
    #define ATDPTAD_ARR                 ((volatile byte *) &ATDPTAD0)
    
    #define ATDPTAD0_PTAD8_MASK         1U
    #define ATDPTAD0_PTAD9_MASK         2U
    #define ATDPTAD0_PTAD10_MASK        4U
    #define ATDPTAD0_PTAD11_MASK        8U
    #define ATDPTAD0_PTAD12_MASK        16U
    #define ATDPTAD0_PTAD13_MASK        32U
    #define ATDPTAD0_PTAD14_MASK        64U
    #define ATDPTAD0_PTAD15_MASK        128U
    

    /*** ATDPTAD1 - ATD  Port AD1 Register; 0x0000008F ***/
    union {
      byte Byte;
      struct {
        byte PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
        byte PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
        byte PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
        byte PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
        byte PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
        byte PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
        byte PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
        byte PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
      } Bits;
    } ATDPTAD1STR;
    #define ATDPTAD1                    _ATDPTAD.Overlap_STR.ATDPTAD1STR.Byte
    #define ATDPTAD1_PTAD0              _ATDPTAD.Overlap_STR.ATDPTAD1STR.Bits.PTAD0
    #define ATDPTAD1_PTAD1              _ATDPTAD.Overlap_STR.ATDPTAD1STR.Bits.PTAD1
    #define ATDPTAD1_PTAD2              _ATDPTAD.Overlap_STR.ATDPTAD1STR.Bits.PTAD2
    #define ATDPTAD1_PTAD3              _ATDPTAD.Overlap_STR.ATDPTAD1STR.Bits.PTAD3
    #define ATDPTAD1_PTAD4              _ATDPTAD.Overlap_STR.ATDPTAD1STR.Bits.PTAD4
    #define ATDPTAD1_PTAD5              _ATDPTAD.Overlap_STR.ATDPTAD1STR.Bits.PTAD5
    #define ATDPTAD1_PTAD6              _ATDPTAD.Overlap_STR.ATDPTAD1STR.Bits.PTAD6
    #define ATDPTAD1_PTAD7              _ATDPTAD.Overlap_STR.ATDPTAD1STR.Bits.PTAD7
    
    #define ATDPTAD1_PTAD0_MASK         1U
    #define ATDPTAD1_PTAD1_MASK         2U
    #define ATDPTAD1_PTAD2_MASK         4U
    #define ATDPTAD1_PTAD3_MASK         8U
    #define ATDPTAD1_PTAD4_MASK         16U
    #define ATDPTAD1_PTAD5_MASK         32U
    #define ATDPTAD1_PTAD6_MASK         64U
    #define ATDPTAD1_PTAD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
    word PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
    word PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
    word PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
    word PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
    word PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
    word PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
    word PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
    word PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
    word PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
    word PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
    word PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
    word PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
    word PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
    word PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
    word PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
  } Bits;
} ATDPTADSTR;
extern volatile ATDPTADSTR _ATDPTAD @(REG_BASE + 0x0000008EUL);
#define ATDPTAD                         _ATDPTAD.Word
#define ATDPTAD_PTAD0                   _ATDPTAD.Bits.PTAD0
#define ATDPTAD_PTAD1                   _ATDPTAD.Bits.PTAD1
#define ATDPTAD_PTAD2                   _ATDPTAD.Bits.PTAD2
#define ATDPTAD_PTAD3                   _ATDPTAD.Bits.PTAD3
#define ATDPTAD_PTAD4                   _ATDPTAD.Bits.PTAD4
#define ATDPTAD_PTAD5                   _ATDPTAD.Bits.PTAD5
#define ATDPTAD_PTAD6                   _ATDPTAD.Bits.PTAD6
#define ATDPTAD_PTAD7                   _ATDPTAD.Bits.PTAD7
#define ATDPTAD_PTAD8                   _ATDPTAD.Bits.PTAD8
#define ATDPTAD_PTAD9                   _ATDPTAD.Bits.PTAD9
#define ATDPTAD_PTAD10                  _ATDPTAD.Bits.PTAD10
#define ATDPTAD_PTAD11                  _ATDPTAD.Bits.PTAD11
#define ATDPTAD_PTAD12                  _ATDPTAD.Bits.PTAD12
#define ATDPTAD_PTAD13                  _ATDPTAD.Bits.PTAD13
#define ATDPTAD_PTAD14                  _ATDPTAD.Bits.PTAD14
#define ATDPTAD_PTAD15                  _ATDPTAD.Bits.PTAD15

#define ATDPTAD_PTAD0_MASK              1U
#define ATDPTAD_PTAD1_MASK              2U
#define ATDPTAD_PTAD2_MASK              4U
#define ATDPTAD_PTAD3_MASK              8U
#define ATDPTAD_PTAD4_MASK              16U
#define ATDPTAD_PTAD5_MASK              32U
#define ATDPTAD_PTAD6_MASK              64U
#define ATDPTAD_PTAD7_MASK              128U
#define ATDPTAD_PTAD8_MASK              256U
#define ATDPTAD_PTAD9_MASK              512U
#define ATDPTAD_PTAD10_MASK             1024U
#define ATDPTAD_PTAD11_MASK             2048U
#define ATDPTAD_PTAD12_MASK             4096U
#define ATDPTAD_PTAD13_MASK             8192U
#define ATDPTAD_PTAD14_MASK             16384U
#define ATDPTAD_PTAD15_MASK             32768U


/*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000090 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000090 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR0HSTR;
    #define ATDDR0H                     _ATDDR0.Overlap_STR.ATDDR0HSTR.Byte
    #define ATDDR0H_BIT8                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT8
    #define ATDDR0H_BIT9                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT9
    #define ATDDR0H_BIT10               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT10
    #define ATDDR0H_BIT11               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT11
    #define ATDDR0H_BIT12               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT12
    #define ATDDR0H_BIT13               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT13
    #define ATDDR0H_BIT14               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT14
    #define ATDDR0H_BIT15               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT15
    
    #define ATDDR0H_BIT8_MASK           1U
    #define ATDDR0H_BIT9_MASK           2U
    #define ATDDR0H_BIT10_MASK          4U
    #define ATDDR0H_BIT11_MASK          8U
    #define ATDDR0H_BIT12_MASK          16U
    #define ATDDR0H_BIT13_MASK          32U
    #define ATDDR0H_BIT14_MASK          64U
    #define ATDDR0H_BIT15_MASK          128U
    

    /*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000091 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR0LSTR;
    #define ATDDR0L                     _ATDDR0.Overlap_STR.ATDDR0LSTR.Byte
    #define ATDDR0L_BIT6                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT6
    #define ATDDR0L_BIT7                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT7
    #define ATDDR0L_BIT_6               _ATDDR0.Overlap_STR.ATDDR0LSTR.MergedBits.grpBIT_6
    #define ATDDR0L_BIT                 ATDDR0L_BIT_6
    
    #define ATDDR0L_BIT6_MASK           64U
    #define ATDDR0L_BIT7_MASK           128U
    #define ATDDR0L_BIT_6_MASK          192U
    #define ATDDR0L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR0STR;
extern volatile ATDDR0STR _ATDDR0 @(REG_BASE + 0x00000090UL);
#define ATDDR0                          _ATDDR0.Word
#define ATDDR0_BIT6                     _ATDDR0.Bits.BIT6
#define ATDDR0_BIT7                     _ATDDR0.Bits.BIT7
#define ATDDR0_BIT8                     _ATDDR0.Bits.BIT8
#define ATDDR0_BIT9                     _ATDDR0.Bits.BIT9
#define ATDDR0_BIT10                    _ATDDR0.Bits.BIT10
#define ATDDR0_BIT11                    _ATDDR0.Bits.BIT11
#define ATDDR0_BIT12                    _ATDDR0.Bits.BIT12
#define ATDDR0_BIT13                    _ATDDR0.Bits.BIT13
#define ATDDR0_BIT14                    _ATDDR0.Bits.BIT14
#define ATDDR0_BIT15                    _ATDDR0.Bits.BIT15
/* ATDDR_ARR: Access 16 ATDDRx registers in an array */
#define ATDDR_ARR                       ((volatile word *) &ATDDR0)
#define ATDDR0_BIT_6                    _ATDDR0.MergedBits.grpBIT_6
#define ATDDR0_BIT                      ATDDR0_BIT_6

#define ATDDR0_BIT6_MASK                64U
#define ATDDR0_BIT7_MASK                128U
#define ATDDR0_BIT8_MASK                256U
#define ATDDR0_BIT9_MASK                512U
#define ATDDR0_BIT10_MASK               1024U
#define ATDDR0_BIT11_MASK               2048U
#define ATDDR0_BIT12_MASK               4096U
#define ATDDR0_BIT13_MASK               8192U
#define ATDDR0_BIT14_MASK               16384U
#define ATDDR0_BIT15_MASK               32768U
#define ATDDR0_BIT_6_MASK               65472U
#define ATDDR0_BIT_6_BITNUM             6U


/*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000092 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000092 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR1HSTR;
    #define ATDDR1H                     _ATDDR1.Overlap_STR.ATDDR1HSTR.Byte
    #define ATDDR1H_BIT8                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT8
    #define ATDDR1H_BIT9                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT9
    #define ATDDR1H_BIT10               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT10
    #define ATDDR1H_BIT11               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT11
    #define ATDDR1H_BIT12               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT12
    #define ATDDR1H_BIT13               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT13
    #define ATDDR1H_BIT14               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT14
    #define ATDDR1H_BIT15               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT15
    
    #define ATDDR1H_BIT8_MASK           1U
    #define ATDDR1H_BIT9_MASK           2U
    #define ATDDR1H_BIT10_MASK          4U
    #define ATDDR1H_BIT11_MASK          8U
    #define ATDDR1H_BIT12_MASK          16U
    #define ATDDR1H_BIT13_MASK          32U
    #define ATDDR1H_BIT14_MASK          64U
    #define ATDDR1H_BIT15_MASK          128U
    

    /*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000093 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR1LSTR;
    #define ATDDR1L                     _ATDDR1.Overlap_STR.ATDDR1LSTR.Byte
    #define ATDDR1L_BIT6                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT6
    #define ATDDR1L_BIT7                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT7
    #define ATDDR1L_BIT_6               _ATDDR1.Overlap_STR.ATDDR1LSTR.MergedBits.grpBIT_6
    #define ATDDR1L_BIT                 ATDDR1L_BIT_6
    
    #define ATDDR1L_BIT6_MASK           64U
    #define ATDDR1L_BIT7_MASK           128U
    #define ATDDR1L_BIT_6_MASK          192U
    #define ATDDR1L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR1STR;
extern volatile ATDDR1STR _ATDDR1 @(REG_BASE + 0x00000092UL);
#define ATDDR1                          _ATDDR1.Word
#define ATDDR1_BIT6                     _ATDDR1.Bits.BIT6
#define ATDDR1_BIT7                     _ATDDR1.Bits.BIT7
#define ATDDR1_BIT8                     _ATDDR1.Bits.BIT8
#define ATDDR1_BIT9                     _ATDDR1.Bits.BIT9
#define ATDDR1_BIT10                    _ATDDR1.Bits.BIT10
#define ATDDR1_BIT11                    _ATDDR1.Bits.BIT11
#define ATDDR1_BIT12                    _ATDDR1.Bits.BIT12
#define ATDDR1_BIT13                    _ATDDR1.Bits.BIT13
#define ATDDR1_BIT14                    _ATDDR1.Bits.BIT14
#define ATDDR1_BIT15                    _ATDDR1.Bits.BIT15
#define ATDDR1_BIT_6                    _ATDDR1.MergedBits.grpBIT_6
#define ATDDR1_BIT                      ATDDR1_BIT_6

#define ATDDR1_BIT6_MASK                64U
#define ATDDR1_BIT7_MASK                128U
#define ATDDR1_BIT8_MASK                256U
#define ATDDR1_BIT9_MASK                512U
#define ATDDR1_BIT10_MASK               1024U
#define ATDDR1_BIT11_MASK               2048U
#define ATDDR1_BIT12_MASK               4096U
#define ATDDR1_BIT13_MASK               8192U
#define ATDDR1_BIT14_MASK               16384U
#define ATDDR1_BIT15_MASK               32768U
#define ATDDR1_BIT_6_MASK               65472U
#define ATDDR1_BIT_6_BITNUM             6U


/*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000094 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000094 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR2HSTR;
    #define ATDDR2H                     _ATDDR2.Overlap_STR.ATDDR2HSTR.Byte
    #define ATDDR2H_BIT8                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT8
    #define ATDDR2H_BIT9                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT9
    #define ATDDR2H_BIT10               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT10
    #define ATDDR2H_BIT11               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT11
    #define ATDDR2H_BIT12               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT12
    #define ATDDR2H_BIT13               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT13
    #define ATDDR2H_BIT14               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT14
    #define ATDDR2H_BIT15               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT15
    
    #define ATDDR2H_BIT8_MASK           1U
    #define ATDDR2H_BIT9_MASK           2U
    #define ATDDR2H_BIT10_MASK          4U
    #define ATDDR2H_BIT11_MASK          8U
    #define ATDDR2H_BIT12_MASK          16U
    #define ATDDR2H_BIT13_MASK          32U
    #define ATDDR2H_BIT14_MASK          64U
    #define ATDDR2H_BIT15_MASK          128U
    

    /*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000095 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR2LSTR;
    #define ATDDR2L                     _ATDDR2.Overlap_STR.ATDDR2LSTR.Byte
    #define ATDDR2L_BIT6                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT6
    #define ATDDR2L_BIT7                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT7
    #define ATDDR2L_BIT_6               _ATDDR2.Overlap_STR.ATDDR2LSTR.MergedBits.grpBIT_6
    #define ATDDR2L_BIT                 ATDDR2L_BIT_6
    
    #define ATDDR2L_BIT6_MASK           64U
    #define ATDDR2L_BIT7_MASK           128U
    #define ATDDR2L_BIT_6_MASK          192U
    #define ATDDR2L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR2STR;
extern volatile ATDDR2STR _ATDDR2 @(REG_BASE + 0x00000094UL);
#define ATDDR2                          _ATDDR2.Word
#define ATDDR2_BIT6                     _ATDDR2.Bits.BIT6
#define ATDDR2_BIT7                     _ATDDR2.Bits.BIT7
#define ATDDR2_BIT8                     _ATDDR2.Bits.BIT8
#define ATDDR2_BIT9                     _ATDDR2.Bits.BIT9
#define ATDDR2_BIT10                    _ATDDR2.Bits.BIT10
#define ATDDR2_BIT11                    _ATDDR2.Bits.BIT11
#define ATDDR2_BIT12                    _ATDDR2.Bits.BIT12
#define ATDDR2_BIT13                    _ATDDR2.Bits.BIT13
#define ATDDR2_BIT14                    _ATDDR2.Bits.BIT14
#define ATDDR2_BIT15                    _ATDDR2.Bits.BIT15
#define ATDDR2_BIT_6                    _ATDDR2.MergedBits.grpBIT_6
#define ATDDR2_BIT                      ATDDR2_BIT_6

#define ATDDR2_BIT6_MASK                64U
#define ATDDR2_BIT7_MASK                128U
#define ATDDR2_BIT8_MASK                256U
#define ATDDR2_BIT9_MASK                512U
#define ATDDR2_BIT10_MASK               1024U
#define ATDDR2_BIT11_MASK               2048U
#define ATDDR2_BIT12_MASK               4096U
#define ATDDR2_BIT13_MASK               8192U
#define ATDDR2_BIT14_MASK               16384U
#define ATDDR2_BIT15_MASK               32768U
#define ATDDR2_BIT_6_MASK               65472U
#define ATDDR2_BIT_6_BITNUM             6U


/*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000096 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000096 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR3HSTR;
    #define ATDDR3H                     _ATDDR3.Overlap_STR.ATDDR3HSTR.Byte
    #define ATDDR3H_BIT8                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT8
    #define ATDDR3H_BIT9                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT9
    #define ATDDR3H_BIT10               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT10
    #define ATDDR3H_BIT11               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT11
    #define ATDDR3H_BIT12               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT12
    #define ATDDR3H_BIT13               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT13
    #define ATDDR3H_BIT14               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT14
    #define ATDDR3H_BIT15               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT15
    
    #define ATDDR3H_BIT8_MASK           1U
    #define ATDDR3H_BIT9_MASK           2U
    #define ATDDR3H_BIT10_MASK          4U
    #define ATDDR3H_BIT11_MASK          8U
    #define ATDDR3H_BIT12_MASK          16U
    #define ATDDR3H_BIT13_MASK          32U
    #define ATDDR3H_BIT14_MASK          64U
    #define ATDDR3H_BIT15_MASK          128U
    

    /*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000097 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR3LSTR;
    #define ATDDR3L                     _ATDDR3.Overlap_STR.ATDDR3LSTR.Byte
    #define ATDDR3L_BIT6                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT6
    #define ATDDR3L_BIT7                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT7
    #define ATDDR3L_BIT_6               _ATDDR3.Overlap_STR.ATDDR3LSTR.MergedBits.grpBIT_6
    #define ATDDR3L_BIT                 ATDDR3L_BIT_6
    
    #define ATDDR3L_BIT6_MASK           64U
    #define ATDDR3L_BIT7_MASK           128U
    #define ATDDR3L_BIT_6_MASK          192U
    #define ATDDR3L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR3STR;
extern volatile ATDDR3STR _ATDDR3 @(REG_BASE + 0x00000096UL);
#define ATDDR3                          _ATDDR3.Word
#define ATDDR3_BIT6                     _ATDDR3.Bits.BIT6
#define ATDDR3_BIT7                     _ATDDR3.Bits.BIT7
#define ATDDR3_BIT8                     _ATDDR3.Bits.BIT8
#define ATDDR3_BIT9                     _ATDDR3.Bits.BIT9
#define ATDDR3_BIT10                    _ATDDR3.Bits.BIT10
#define ATDDR3_BIT11                    _ATDDR3.Bits.BIT11
#define ATDDR3_BIT12                    _ATDDR3.Bits.BIT12
#define ATDDR3_BIT13                    _ATDDR3.Bits.BIT13
#define ATDDR3_BIT14                    _ATDDR3.Bits.BIT14
#define ATDDR3_BIT15                    _ATDDR3.Bits.BIT15
#define ATDDR3_BIT_6                    _ATDDR3.MergedBits.grpBIT_6
#define ATDDR3_BIT                      ATDDR3_BIT_6

#define ATDDR3_BIT6_MASK                64U
#define ATDDR3_BIT7_MASK                128U
#define ATDDR3_BIT8_MASK                256U
#define ATDDR3_BIT9_MASK                512U
#define ATDDR3_BIT10_MASK               1024U
#define ATDDR3_BIT11_MASK               2048U
#define ATDDR3_BIT12_MASK               4096U
#define ATDDR3_BIT13_MASK               8192U
#define ATDDR3_BIT14_MASK               16384U
#define ATDDR3_BIT15_MASK               32768U
#define ATDDR3_BIT_6_MASK               65472U
#define ATDDR3_BIT_6_BITNUM             6U


/*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000098 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000098 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR4HSTR;
    #define ATDDR4H                     _ATDDR4.Overlap_STR.ATDDR4HSTR.Byte
    #define ATDDR4H_BIT8                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT8
    #define ATDDR4H_BIT9                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT9
    #define ATDDR4H_BIT10               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT10
    #define ATDDR4H_BIT11               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT11
    #define ATDDR4H_BIT12               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT12
    #define ATDDR4H_BIT13               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT13
    #define ATDDR4H_BIT14               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT14
    #define ATDDR4H_BIT15               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT15
    
    #define ATDDR4H_BIT8_MASK           1U
    #define ATDDR4H_BIT9_MASK           2U
    #define ATDDR4H_BIT10_MASK          4U
    #define ATDDR4H_BIT11_MASK          8U
    #define ATDDR4H_BIT12_MASK          16U
    #define ATDDR4H_BIT13_MASK          32U
    #define ATDDR4H_BIT14_MASK          64U
    #define ATDDR4H_BIT15_MASK          128U
    

    /*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000099 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR4LSTR;
    #define ATDDR4L                     _ATDDR4.Overlap_STR.ATDDR4LSTR.Byte
    #define ATDDR4L_BIT6                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT6
    #define ATDDR4L_BIT7                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT7
    #define ATDDR4L_BIT_6               _ATDDR4.Overlap_STR.ATDDR4LSTR.MergedBits.grpBIT_6
    #define ATDDR4L_BIT                 ATDDR4L_BIT_6
    
    #define ATDDR4L_BIT6_MASK           64U
    #define ATDDR4L_BIT7_MASK           128U
    #define ATDDR4L_BIT_6_MASK          192U
    #define ATDDR4L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR4STR;
extern volatile ATDDR4STR _ATDDR4 @(REG_BASE + 0x00000098UL);
#define ATDDR4                          _ATDDR4.Word
#define ATDDR4_BIT6                     _ATDDR4.Bits.BIT6
#define ATDDR4_BIT7                     _ATDDR4.Bits.BIT7
#define ATDDR4_BIT8                     _ATDDR4.Bits.BIT8
#define ATDDR4_BIT9                     _ATDDR4.Bits.BIT9
#define ATDDR4_BIT10                    _ATDDR4.Bits.BIT10
#define ATDDR4_BIT11                    _ATDDR4.Bits.BIT11
#define ATDDR4_BIT12                    _ATDDR4.Bits.BIT12
#define ATDDR4_BIT13                    _ATDDR4.Bits.BIT13
#define ATDDR4_BIT14                    _ATDDR4.Bits.BIT14
#define ATDDR4_BIT15                    _ATDDR4.Bits.BIT15
#define ATDDR4_BIT_6                    _ATDDR4.MergedBits.grpBIT_6
#define ATDDR4_BIT                      ATDDR4_BIT_6

#define ATDDR4_BIT6_MASK                64U
#define ATDDR4_BIT7_MASK                128U
#define ATDDR4_BIT8_MASK                256U
#define ATDDR4_BIT9_MASK                512U
#define ATDDR4_BIT10_MASK               1024U
#define ATDDR4_BIT11_MASK               2048U
#define ATDDR4_BIT12_MASK               4096U
#define ATDDR4_BIT13_MASK               8192U
#define ATDDR4_BIT14_MASK               16384U
#define ATDDR4_BIT15_MASK               32768U
#define ATDDR4_BIT_6_MASK               65472U
#define ATDDR4_BIT_6_BITNUM             6U


/*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000009A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000009A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR5HSTR;
    #define ATDDR5H                     _ATDDR5.Overlap_STR.ATDDR5HSTR.Byte
    #define ATDDR5H_BIT8                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT8
    #define ATDDR5H_BIT9                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT9
    #define ATDDR5H_BIT10               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT10
    #define ATDDR5H_BIT11               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT11
    #define ATDDR5H_BIT12               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT12
    #define ATDDR5H_BIT13               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT13
    #define ATDDR5H_BIT14               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT14
    #define ATDDR5H_BIT15               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT15
    
    #define ATDDR5H_BIT8_MASK           1U
    #define ATDDR5H_BIT9_MASK           2U
    #define ATDDR5H_BIT10_MASK          4U
    #define ATDDR5H_BIT11_MASK          8U
    #define ATDDR5H_BIT12_MASK          16U
    #define ATDDR5H_BIT13_MASK          32U
    #define ATDDR5H_BIT14_MASK          64U
    #define ATDDR5H_BIT15_MASK          128U
    

    /*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000009B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR5LSTR;
    #define ATDDR5L                     _ATDDR5.Overlap_STR.ATDDR5LSTR.Byte
    #define ATDDR5L_BIT6                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT6
    #define ATDDR5L_BIT7                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT7
    #define ATDDR5L_BIT_6               _ATDDR5.Overlap_STR.ATDDR5LSTR.MergedBits.grpBIT_6
    #define ATDDR5L_BIT                 ATDDR5L_BIT_6
    
    #define ATDDR5L_BIT6_MASK           64U
    #define ATDDR5L_BIT7_MASK           128U
    #define ATDDR5L_BIT_6_MASK          192U
    #define ATDDR5L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR5STR;
extern volatile ATDDR5STR _ATDDR5 @(REG_BASE + 0x0000009AUL);
#define ATDDR5                          _ATDDR5.Word
#define ATDDR5_BIT6                     _ATDDR5.Bits.BIT6
#define ATDDR5_BIT7                     _ATDDR5.Bits.BIT7
#define ATDDR5_BIT8                     _ATDDR5.Bits.BIT8
#define ATDDR5_BIT9                     _ATDDR5.Bits.BIT9
#define ATDDR5_BIT10                    _ATDDR5.Bits.BIT10
#define ATDDR5_BIT11                    _ATDDR5.Bits.BIT11
#define ATDDR5_BIT12                    _ATDDR5.Bits.BIT12
#define ATDDR5_BIT13                    _ATDDR5.Bits.BIT13
#define ATDDR5_BIT14                    _ATDDR5.Bits.BIT14
#define ATDDR5_BIT15                    _ATDDR5.Bits.BIT15
#define ATDDR5_BIT_6                    _ATDDR5.MergedBits.grpBIT_6
#define ATDDR5_BIT                      ATDDR5_BIT_6

#define ATDDR5_BIT6_MASK                64U
#define ATDDR5_BIT7_MASK                128U
#define ATDDR5_BIT8_MASK                256U
#define ATDDR5_BIT9_MASK                512U
#define ATDDR5_BIT10_MASK               1024U
#define ATDDR5_BIT11_MASK               2048U
#define ATDDR5_BIT12_MASK               4096U
#define ATDDR5_BIT13_MASK               8192U
#define ATDDR5_BIT14_MASK               16384U
#define ATDDR5_BIT15_MASK               32768U
#define ATDDR5_BIT_6_MASK               65472U
#define ATDDR5_BIT_6_BITNUM             6U


/*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000009C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000009C ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR6HSTR;
    #define ATDDR6H                     _ATDDR6.Overlap_STR.ATDDR6HSTR.Byte
    #define ATDDR6H_BIT8                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT8
    #define ATDDR6H_BIT9                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT9
    #define ATDDR6H_BIT10               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT10
    #define ATDDR6H_BIT11               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT11
    #define ATDDR6H_BIT12               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT12
    #define ATDDR6H_BIT13               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT13
    #define ATDDR6H_BIT14               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT14
    #define ATDDR6H_BIT15               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT15
    
    #define ATDDR6H_BIT8_MASK           1U
    #define ATDDR6H_BIT9_MASK           2U
    #define ATDDR6H_BIT10_MASK          4U
    #define ATDDR6H_BIT11_MASK          8U
    #define ATDDR6H_BIT12_MASK          16U
    #define ATDDR6H_BIT13_MASK          32U
    #define ATDDR6H_BIT14_MASK          64U
    #define ATDDR6H_BIT15_MASK          128U
    

    /*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000009D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR6LSTR;
    #define ATDDR6L                     _ATDDR6.Overlap_STR.ATDDR6LSTR.Byte
    #define ATDDR6L_BIT6                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT6
    #define ATDDR6L_BIT7                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT7
    #define ATDDR6L_BIT_6               _ATDDR6.Overlap_STR.ATDDR6LSTR.MergedBits.grpBIT_6
    #define ATDDR6L_BIT                 ATDDR6L_BIT_6
    
    #define ATDDR6L_BIT6_MASK           64U
    #define ATDDR6L_BIT7_MASK           128U
    #define ATDDR6L_BIT_6_MASK          192U
    #define ATDDR6L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR6STR;
extern volatile ATDDR6STR _ATDDR6 @(REG_BASE + 0x0000009CUL);
#define ATDDR6                          _ATDDR6.Word
#define ATDDR6_BIT6                     _ATDDR6.Bits.BIT6
#define ATDDR6_BIT7                     _ATDDR6.Bits.BIT7
#define ATDDR6_BIT8                     _ATDDR6.Bits.BIT8
#define ATDDR6_BIT9                     _ATDDR6.Bits.BIT9
#define ATDDR6_BIT10                    _ATDDR6.Bits.BIT10
#define ATDDR6_BIT11                    _ATDDR6.Bits.BIT11
#define ATDDR6_BIT12                    _ATDDR6.Bits.BIT12
#define ATDDR6_BIT13                    _ATDDR6.Bits.BIT13
#define ATDDR6_BIT14                    _ATDDR6.Bits.BIT14
#define ATDDR6_BIT15                    _ATDDR6.Bits.BIT15
#define ATDDR6_BIT_6                    _ATDDR6.MergedBits.grpBIT_6
#define ATDDR6_BIT                      ATDDR6_BIT_6

#define ATDDR6_BIT6_MASK                64U
#define ATDDR6_BIT7_MASK                128U
#define ATDDR6_BIT8_MASK                256U
#define ATDDR6_BIT9_MASK                512U
#define ATDDR6_BIT10_MASK               1024U
#define ATDDR6_BIT11_MASK               2048U
#define ATDDR6_BIT12_MASK               4096U
#define ATDDR6_BIT13_MASK               8192U
#define ATDDR6_BIT14_MASK               16384U
#define ATDDR6_BIT15_MASK               32768U
#define ATDDR6_BIT_6_MASK               65472U
#define ATDDR6_BIT_6_BITNUM             6U


/*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000009E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000009E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR7HSTR;
    #define ATDDR7H                     _ATDDR7.Overlap_STR.ATDDR7HSTR.Byte
    #define ATDDR7H_BIT8                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT8
    #define ATDDR7H_BIT9                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT9
    #define ATDDR7H_BIT10               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT10
    #define ATDDR7H_BIT11               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT11
    #define ATDDR7H_BIT12               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT12
    #define ATDDR7H_BIT13               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT13
    #define ATDDR7H_BIT14               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT14
    #define ATDDR7H_BIT15               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT15
    
    #define ATDDR7H_BIT8_MASK           1U
    #define ATDDR7H_BIT9_MASK           2U
    #define ATDDR7H_BIT10_MASK          4U
    #define ATDDR7H_BIT11_MASK          8U
    #define ATDDR7H_BIT12_MASK          16U
    #define ATDDR7H_BIT13_MASK          32U
    #define ATDDR7H_BIT14_MASK          64U
    #define ATDDR7H_BIT15_MASK          128U
    

    /*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000009F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR7LSTR;
    #define ATDDR7L                     _ATDDR7.Overlap_STR.ATDDR7LSTR.Byte
    #define ATDDR7L_BIT6                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT6
    #define ATDDR7L_BIT7                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT7
    #define ATDDR7L_BIT_6               _ATDDR7.Overlap_STR.ATDDR7LSTR.MergedBits.grpBIT_6
    #define ATDDR7L_BIT                 ATDDR7L_BIT_6
    
    #define ATDDR7L_BIT6_MASK           64U
    #define ATDDR7L_BIT7_MASK           128U
    #define ATDDR7L_BIT_6_MASK          192U
    #define ATDDR7L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR7STR;
extern volatile ATDDR7STR _ATDDR7 @(REG_BASE + 0x0000009EUL);
#define ATDDR7                          _ATDDR7.Word
#define ATDDR7_BIT6                     _ATDDR7.Bits.BIT6
#define ATDDR7_BIT7                     _ATDDR7.Bits.BIT7
#define ATDDR7_BIT8                     _ATDDR7.Bits.BIT8
#define ATDDR7_BIT9                     _ATDDR7.Bits.BIT9
#define ATDDR7_BIT10                    _ATDDR7.Bits.BIT10
#define ATDDR7_BIT11                    _ATDDR7.Bits.BIT11
#define ATDDR7_BIT12                    _ATDDR7.Bits.BIT12
#define ATDDR7_BIT13                    _ATDDR7.Bits.BIT13
#define ATDDR7_BIT14                    _ATDDR7.Bits.BIT14
#define ATDDR7_BIT15                    _ATDDR7.Bits.BIT15
#define ATDDR7_BIT_6                    _ATDDR7.MergedBits.grpBIT_6
#define ATDDR7_BIT                      ATDDR7_BIT_6

#define ATDDR7_BIT6_MASK                64U
#define ATDDR7_BIT7_MASK                128U
#define ATDDR7_BIT8_MASK                256U
#define ATDDR7_BIT9_MASK                512U
#define ATDDR7_BIT10_MASK               1024U
#define ATDDR7_BIT11_MASK               2048U
#define ATDDR7_BIT12_MASK               4096U
#define ATDDR7_BIT13_MASK               8192U
#define ATDDR7_BIT14_MASK               16384U
#define ATDDR7_BIT15_MASK               32768U
#define ATDDR7_BIT_6_MASK               65472U
#define ATDDR7_BIT_6_BITNUM             6U


/*** ATDDR8 - ATD  Conversion Result Register 8; 0x000000A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR8H - ATD  Conversion Result Register 8 High; 0x000000A0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR8HSTR;
    #define ATDDR8H                     _ATDDR8.Overlap_STR.ATDDR8HSTR.Byte
    #define ATDDR8H_BIT8                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT8
    #define ATDDR8H_BIT9                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT9
    #define ATDDR8H_BIT10               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT10
    #define ATDDR8H_BIT11               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT11
    #define ATDDR8H_BIT12               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT12
    #define ATDDR8H_BIT13               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT13
    #define ATDDR8H_BIT14               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT14
    #define ATDDR8H_BIT15               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT15
    
    #define ATDDR8H_BIT8_MASK           1U
    #define ATDDR8H_BIT9_MASK           2U
    #define ATDDR8H_BIT10_MASK          4U
    #define ATDDR8H_BIT11_MASK          8U
    #define ATDDR8H_BIT12_MASK          16U
    #define ATDDR8H_BIT13_MASK          32U
    #define ATDDR8H_BIT14_MASK          64U
    #define ATDDR8H_BIT15_MASK          128U
    

    /*** ATDDR8L - ATD  Conversion Result Register 8 Low; 0x000000A1 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR8LSTR;
    #define ATDDR8L                     _ATDDR8.Overlap_STR.ATDDR8LSTR.Byte
    #define ATDDR8L_BIT6                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT6
    #define ATDDR8L_BIT7                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT7
    #define ATDDR8L_BIT_6               _ATDDR8.Overlap_STR.ATDDR8LSTR.MergedBits.grpBIT_6
    #define ATDDR8L_BIT                 ATDDR8L_BIT_6
    
    #define ATDDR8L_BIT6_MASK           64U
    #define ATDDR8L_BIT7_MASK           128U
    #define ATDDR8L_BIT_6_MASK          192U
    #define ATDDR8L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR8STR;
extern volatile ATDDR8STR _ATDDR8 @(REG_BASE + 0x000000A0UL);
#define ATDDR8                          _ATDDR8.Word
#define ATDDR8_BIT6                     _ATDDR8.Bits.BIT6
#define ATDDR8_BIT7                     _ATDDR8.Bits.BIT7
#define ATDDR8_BIT8                     _ATDDR8.Bits.BIT8
#define ATDDR8_BIT9                     _ATDDR8.Bits.BIT9
#define ATDDR8_BIT10                    _ATDDR8.Bits.BIT10
#define ATDDR8_BIT11                    _ATDDR8.Bits.BIT11
#define ATDDR8_BIT12                    _ATDDR8.Bits.BIT12
#define ATDDR8_BIT13                    _ATDDR8.Bits.BIT13
#define ATDDR8_BIT14                    _ATDDR8.Bits.BIT14
#define ATDDR8_BIT15                    _ATDDR8.Bits.BIT15
#define ATDDR8_BIT_6                    _ATDDR8.MergedBits.grpBIT_6
#define ATDDR8_BIT                      ATDDR8_BIT_6

#define ATDDR8_BIT6_MASK                64U
#define ATDDR8_BIT7_MASK                128U
#define ATDDR8_BIT8_MASK                256U
#define ATDDR8_BIT9_MASK                512U
#define ATDDR8_BIT10_MASK               1024U
#define ATDDR8_BIT11_MASK               2048U
#define ATDDR8_BIT12_MASK               4096U
#define ATDDR8_BIT13_MASK               8192U
#define ATDDR8_BIT14_MASK               16384U
#define ATDDR8_BIT15_MASK               32768U
#define ATDDR8_BIT_6_MASK               65472U
#define ATDDR8_BIT_6_BITNUM             6U


/*** ATDDR9 - ATD  Conversion Result Register 9; 0x000000A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR9H - ATD  Conversion Result Register 9 High; 0x000000A2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR9HSTR;
    #define ATDDR9H                     _ATDDR9.Overlap_STR.ATDDR9HSTR.Byte
    #define ATDDR9H_BIT8                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT8
    #define ATDDR9H_BIT9                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT9
    #define ATDDR9H_BIT10               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT10
    #define ATDDR9H_BIT11               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT11
    #define ATDDR9H_BIT12               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT12
    #define ATDDR9H_BIT13               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT13
    #define ATDDR9H_BIT14               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT14
    #define ATDDR9H_BIT15               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT15
    
    #define ATDDR9H_BIT8_MASK           1U
    #define ATDDR9H_BIT9_MASK           2U
    #define ATDDR9H_BIT10_MASK          4U
    #define ATDDR9H_BIT11_MASK          8U
    #define ATDDR9H_BIT12_MASK          16U
    #define ATDDR9H_BIT13_MASK          32U
    #define ATDDR9H_BIT14_MASK          64U
    #define ATDDR9H_BIT15_MASK          128U
    

    /*** ATDDR9L - ATD  Conversion Result Register 9 Low; 0x000000A3 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR9LSTR;
    #define ATDDR9L                     _ATDDR9.Overlap_STR.ATDDR9LSTR.Byte
    #define ATDDR9L_BIT6                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT6
    #define ATDDR9L_BIT7                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT7
    #define ATDDR9L_BIT_6               _ATDDR9.Overlap_STR.ATDDR9LSTR.MergedBits.grpBIT_6
    #define ATDDR9L_BIT                 ATDDR9L_BIT_6
    
    #define ATDDR9L_BIT6_MASK           64U
    #define ATDDR9L_BIT7_MASK           128U
    #define ATDDR9L_BIT_6_MASK          192U
    #define ATDDR9L_BIT_6_BITNUM        6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR9STR;
extern volatile ATDDR9STR _ATDDR9 @(REG_BASE + 0x000000A2UL);
#define ATDDR9                          _ATDDR9.Word
#define ATDDR9_BIT6                     _ATDDR9.Bits.BIT6
#define ATDDR9_BIT7                     _ATDDR9.Bits.BIT7
#define ATDDR9_BIT8                     _ATDDR9.Bits.BIT8
#define ATDDR9_BIT9                     _ATDDR9.Bits.BIT9
#define ATDDR9_BIT10                    _ATDDR9.Bits.BIT10
#define ATDDR9_BIT11                    _ATDDR9.Bits.BIT11
#define ATDDR9_BIT12                    _ATDDR9.Bits.BIT12
#define ATDDR9_BIT13                    _ATDDR9.Bits.BIT13
#define ATDDR9_BIT14                    _ATDDR9.Bits.BIT14
#define ATDDR9_BIT15                    _ATDDR9.Bits.BIT15
#define ATDDR9_BIT_6                    _ATDDR9.MergedBits.grpBIT_6
#define ATDDR9_BIT                      ATDDR9_BIT_6

#define ATDDR9_BIT6_MASK                64U
#define ATDDR9_BIT7_MASK                128U
#define ATDDR9_BIT8_MASK                256U
#define ATDDR9_BIT9_MASK                512U
#define ATDDR9_BIT10_MASK               1024U
#define ATDDR9_BIT11_MASK               2048U
#define ATDDR9_BIT12_MASK               4096U
#define ATDDR9_BIT13_MASK               8192U
#define ATDDR9_BIT14_MASK               16384U
#define ATDDR9_BIT15_MASK               32768U
#define ATDDR9_BIT_6_MASK               65472U
#define ATDDR9_BIT_6_BITNUM             6U


/*** ATDDR10 - ATD  Conversion Result Register 10; 0x000000A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR10H - ATD  Conversion Result Register 10 High; 0x000000A4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR10HSTR;
    #define ATDDR10H                    _ATDDR10.Overlap_STR.ATDDR10HSTR.Byte
    #define ATDDR10H_BIT8               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT8
    #define ATDDR10H_BIT9               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT9
    #define ATDDR10H_BIT10              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT10
    #define ATDDR10H_BIT11              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT11
    #define ATDDR10H_BIT12              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT12
    #define ATDDR10H_BIT13              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT13
    #define ATDDR10H_BIT14              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT14
    #define ATDDR10H_BIT15              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT15
    
    #define ATDDR10H_BIT8_MASK          1U
    #define ATDDR10H_BIT9_MASK          2U
    #define ATDDR10H_BIT10_MASK         4U
    #define ATDDR10H_BIT11_MASK         8U
    #define ATDDR10H_BIT12_MASK         16U
    #define ATDDR10H_BIT13_MASK         32U
    #define ATDDR10H_BIT14_MASK         64U
    #define ATDDR10H_BIT15_MASK         128U
    

    /*** ATDDR10L - ATD  Conversion Result Register 10 Low; 0x000000A5 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR10LSTR;
    #define ATDDR10L                    _ATDDR10.Overlap_STR.ATDDR10LSTR.Byte
    #define ATDDR10L_BIT6               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT6
    #define ATDDR10L_BIT7               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT7
    #define ATDDR10L_BIT_6              _ATDDR10.Overlap_STR.ATDDR10LSTR.MergedBits.grpBIT_6
    #define ATDDR10L_BIT                ATDDR10L_BIT_6
    
    #define ATDDR10L_BIT6_MASK          64U
    #define ATDDR10L_BIT7_MASK          128U
    #define ATDDR10L_BIT_6_MASK         192U
    #define ATDDR10L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR10STR;
extern volatile ATDDR10STR _ATDDR10 @(REG_BASE + 0x000000A4UL);
#define ATDDR10                         _ATDDR10.Word
#define ATDDR10_BIT6                    _ATDDR10.Bits.BIT6
#define ATDDR10_BIT7                    _ATDDR10.Bits.BIT7
#define ATDDR10_BIT8                    _ATDDR10.Bits.BIT8
#define ATDDR10_BIT9                    _ATDDR10.Bits.BIT9
#define ATDDR10_BIT10                   _ATDDR10.Bits.BIT10
#define ATDDR10_BIT11                   _ATDDR10.Bits.BIT11
#define ATDDR10_BIT12                   _ATDDR10.Bits.BIT12
#define ATDDR10_BIT13                   _ATDDR10.Bits.BIT13
#define ATDDR10_BIT14                   _ATDDR10.Bits.BIT14
#define ATDDR10_BIT15                   _ATDDR10.Bits.BIT15
#define ATDDR10_BIT_6                   _ATDDR10.MergedBits.grpBIT_6
#define ATDDR10_BIT                     ATDDR10_BIT_6

#define ATDDR10_BIT6_MASK               64U
#define ATDDR10_BIT7_MASK               128U
#define ATDDR10_BIT8_MASK               256U
#define ATDDR10_BIT9_MASK               512U
#define ATDDR10_BIT10_MASK              1024U
#define ATDDR10_BIT11_MASK              2048U
#define ATDDR10_BIT12_MASK              4096U
#define ATDDR10_BIT13_MASK              8192U
#define ATDDR10_BIT14_MASK              16384U
#define ATDDR10_BIT15_MASK              32768U
#define ATDDR10_BIT_6_MASK              65472U
#define ATDDR10_BIT_6_BITNUM            6U


/*** ATDDR11 - ATD  Conversion Result Register 11; 0x000000A6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR11H - ATD  Conversion Result Register 11 High; 0x000000A6 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR11HSTR;
    #define ATDDR11H                    _ATDDR11.Overlap_STR.ATDDR11HSTR.Byte
    #define ATDDR11H_BIT8               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT8
    #define ATDDR11H_BIT9               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT9
    #define ATDDR11H_BIT10              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT10
    #define ATDDR11H_BIT11              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT11
    #define ATDDR11H_BIT12              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT12
    #define ATDDR11H_BIT13              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT13
    #define ATDDR11H_BIT14              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT14
    #define ATDDR11H_BIT15              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT15
    
    #define ATDDR11H_BIT8_MASK          1U
    #define ATDDR11H_BIT9_MASK          2U
    #define ATDDR11H_BIT10_MASK         4U
    #define ATDDR11H_BIT11_MASK         8U
    #define ATDDR11H_BIT12_MASK         16U
    #define ATDDR11H_BIT13_MASK         32U
    #define ATDDR11H_BIT14_MASK         64U
    #define ATDDR11H_BIT15_MASK         128U
    

    /*** ATDDR11L - ATD  Conversion Result Register 11 Low; 0x000000A7 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR11LSTR;
    #define ATDDR11L                    _ATDDR11.Overlap_STR.ATDDR11LSTR.Byte
    #define ATDDR11L_BIT6               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT6
    #define ATDDR11L_BIT7               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT7
    #define ATDDR11L_BIT_6              _ATDDR11.Overlap_STR.ATDDR11LSTR.MergedBits.grpBIT_6
    #define ATDDR11L_BIT                ATDDR11L_BIT_6
    
    #define ATDDR11L_BIT6_MASK          64U
    #define ATDDR11L_BIT7_MASK          128U
    #define ATDDR11L_BIT_6_MASK         192U
    #define ATDDR11L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR11STR;
extern volatile ATDDR11STR _ATDDR11 @(REG_BASE + 0x000000A6UL);
#define ATDDR11                         _ATDDR11.Word
#define ATDDR11_BIT6                    _ATDDR11.Bits.BIT6
#define ATDDR11_BIT7                    _ATDDR11.Bits.BIT7
#define ATDDR11_BIT8                    _ATDDR11.Bits.BIT8
#define ATDDR11_BIT9                    _ATDDR11.Bits.BIT9
#define ATDDR11_BIT10                   _ATDDR11.Bits.BIT10
#define ATDDR11_BIT11                   _ATDDR11.Bits.BIT11
#define ATDDR11_BIT12                   _ATDDR11.Bits.BIT12
#define ATDDR11_BIT13                   _ATDDR11.Bits.BIT13
#define ATDDR11_BIT14                   _ATDDR11.Bits.BIT14
#define ATDDR11_BIT15                   _ATDDR11.Bits.BIT15
#define ATDDR11_BIT_6                   _ATDDR11.MergedBits.grpBIT_6
#define ATDDR11_BIT                     ATDDR11_BIT_6

#define ATDDR11_BIT6_MASK               64U
#define ATDDR11_BIT7_MASK               128U
#define ATDDR11_BIT8_MASK               256U
#define ATDDR11_BIT9_MASK               512U
#define ATDDR11_BIT10_MASK              1024U
#define ATDDR11_BIT11_MASK              2048U
#define ATDDR11_BIT12_MASK              4096U
#define ATDDR11_BIT13_MASK              8192U
#define ATDDR11_BIT14_MASK              16384U
#define ATDDR11_BIT15_MASK              32768U
#define ATDDR11_BIT_6_MASK              65472U
#define ATDDR11_BIT_6_BITNUM            6U


/*** ATDDR12 - ATD  Conversion Result Register 12; 0x000000A8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR12H - ATD  Conversion Result Register 12 High; 0x000000A8 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR12HSTR;
    #define ATDDR12H                    _ATDDR12.Overlap_STR.ATDDR12HSTR.Byte
    #define ATDDR12H_BIT8               _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT8
    #define ATDDR12H_BIT9               _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT9
    #define ATDDR12H_BIT10              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT10
    #define ATDDR12H_BIT11              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT11
    #define ATDDR12H_BIT12              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT12
    #define ATDDR12H_BIT13              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT13
    #define ATDDR12H_BIT14              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT14
    #define ATDDR12H_BIT15              _ATDDR12.Overlap_STR.ATDDR12HSTR.Bits.BIT15
    
    #define ATDDR12H_BIT8_MASK          1U
    #define ATDDR12H_BIT9_MASK          2U
    #define ATDDR12H_BIT10_MASK         4U
    #define ATDDR12H_BIT11_MASK         8U
    #define ATDDR12H_BIT12_MASK         16U
    #define ATDDR12H_BIT13_MASK         32U
    #define ATDDR12H_BIT14_MASK         64U
    #define ATDDR12H_BIT15_MASK         128U
    

    /*** ATDDR12L - ATD  Conversion Result Register 12 Low; 0x000000A9 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR12LSTR;
    #define ATDDR12L                    _ATDDR12.Overlap_STR.ATDDR12LSTR.Byte
    #define ATDDR12L_BIT6               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT6
    #define ATDDR12L_BIT7               _ATDDR12.Overlap_STR.ATDDR12LSTR.Bits.BIT7
    #define ATDDR12L_BIT_6              _ATDDR12.Overlap_STR.ATDDR12LSTR.MergedBits.grpBIT_6
    #define ATDDR12L_BIT                ATDDR12L_BIT_6
    
    #define ATDDR12L_BIT6_MASK          64U
    #define ATDDR12L_BIT7_MASK          128U
    #define ATDDR12L_BIT_6_MASK         192U
    #define ATDDR12L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR12STR;
extern volatile ATDDR12STR _ATDDR12 @(REG_BASE + 0x000000A8UL);
#define ATDDR12                         _ATDDR12.Word
#define ATDDR12_BIT6                    _ATDDR12.Bits.BIT6
#define ATDDR12_BIT7                    _ATDDR12.Bits.BIT7
#define ATDDR12_BIT8                    _ATDDR12.Bits.BIT8
#define ATDDR12_BIT9                    _ATDDR12.Bits.BIT9
#define ATDDR12_BIT10                   _ATDDR12.Bits.BIT10
#define ATDDR12_BIT11                   _ATDDR12.Bits.BIT11
#define ATDDR12_BIT12                   _ATDDR12.Bits.BIT12
#define ATDDR12_BIT13                   _ATDDR12.Bits.BIT13
#define ATDDR12_BIT14                   _ATDDR12.Bits.BIT14
#define ATDDR12_BIT15                   _ATDDR12.Bits.BIT15
#define ATDDR12_BIT_6                   _ATDDR12.MergedBits.grpBIT_6
#define ATDDR12_BIT                     ATDDR12_BIT_6

#define ATDDR12_BIT6_MASK               64U
#define ATDDR12_BIT7_MASK               128U
#define ATDDR12_BIT8_MASK               256U
#define ATDDR12_BIT9_MASK               512U
#define ATDDR12_BIT10_MASK              1024U
#define ATDDR12_BIT11_MASK              2048U
#define ATDDR12_BIT12_MASK              4096U
#define ATDDR12_BIT13_MASK              8192U
#define ATDDR12_BIT14_MASK              16384U
#define ATDDR12_BIT15_MASK              32768U
#define ATDDR12_BIT_6_MASK              65472U
#define ATDDR12_BIT_6_BITNUM            6U


/*** ATDDR13 - ATD  Conversion Result Register 13; 0x000000AA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR13H - ATD  Conversion Result Register 13 High; 0x000000AA ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR13HSTR;
    #define ATDDR13H                    _ATDDR13.Overlap_STR.ATDDR13HSTR.Byte
    #define ATDDR13H_BIT8               _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT8
    #define ATDDR13H_BIT9               _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT9
    #define ATDDR13H_BIT10              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT10
    #define ATDDR13H_BIT11              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT11
    #define ATDDR13H_BIT12              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT12
    #define ATDDR13H_BIT13              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT13
    #define ATDDR13H_BIT14              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT14
    #define ATDDR13H_BIT15              _ATDDR13.Overlap_STR.ATDDR13HSTR.Bits.BIT15
    
    #define ATDDR13H_BIT8_MASK          1U
    #define ATDDR13H_BIT9_MASK          2U
    #define ATDDR13H_BIT10_MASK         4U
    #define ATDDR13H_BIT11_MASK         8U
    #define ATDDR13H_BIT12_MASK         16U
    #define ATDDR13H_BIT13_MASK         32U
    #define ATDDR13H_BIT14_MASK         64U
    #define ATDDR13H_BIT15_MASK         128U
    

    /*** ATDDR13L - ATD  Conversion Result Register 13 Low; 0x000000AB ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR13LSTR;
    #define ATDDR13L                    _ATDDR13.Overlap_STR.ATDDR13LSTR.Byte
    #define ATDDR13L_BIT6               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT6
    #define ATDDR13L_BIT7               _ATDDR13.Overlap_STR.ATDDR13LSTR.Bits.BIT7
    #define ATDDR13L_BIT_6              _ATDDR13.Overlap_STR.ATDDR13LSTR.MergedBits.grpBIT_6
    #define ATDDR13L_BIT                ATDDR13L_BIT_6
    
    #define ATDDR13L_BIT6_MASK          64U
    #define ATDDR13L_BIT7_MASK          128U
    #define ATDDR13L_BIT_6_MASK         192U
    #define ATDDR13L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR13STR;
extern volatile ATDDR13STR _ATDDR13 @(REG_BASE + 0x000000AAUL);
#define ATDDR13                         _ATDDR13.Word
#define ATDDR13_BIT6                    _ATDDR13.Bits.BIT6
#define ATDDR13_BIT7                    _ATDDR13.Bits.BIT7
#define ATDDR13_BIT8                    _ATDDR13.Bits.BIT8
#define ATDDR13_BIT9                    _ATDDR13.Bits.BIT9
#define ATDDR13_BIT10                   _ATDDR13.Bits.BIT10
#define ATDDR13_BIT11                   _ATDDR13.Bits.BIT11
#define ATDDR13_BIT12                   _ATDDR13.Bits.BIT12
#define ATDDR13_BIT13                   _ATDDR13.Bits.BIT13
#define ATDDR13_BIT14                   _ATDDR13.Bits.BIT14
#define ATDDR13_BIT15                   _ATDDR13.Bits.BIT15
#define ATDDR13_BIT_6                   _ATDDR13.MergedBits.grpBIT_6
#define ATDDR13_BIT                     ATDDR13_BIT_6

#define ATDDR13_BIT6_MASK               64U
#define ATDDR13_BIT7_MASK               128U
#define ATDDR13_BIT8_MASK               256U
#define ATDDR13_BIT9_MASK               512U
#define ATDDR13_BIT10_MASK              1024U
#define ATDDR13_BIT11_MASK              2048U
#define ATDDR13_BIT12_MASK              4096U
#define ATDDR13_BIT13_MASK              8192U
#define ATDDR13_BIT14_MASK              16384U
#define ATDDR13_BIT15_MASK              32768U
#define ATDDR13_BIT_6_MASK              65472U
#define ATDDR13_BIT_6_BITNUM            6U


/*** ATDDR14 - ATD  Conversion Result Register 14; 0x000000AC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR14H - ATD  Conversion Result Register 14 High; 0x000000AC ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR14HSTR;
    #define ATDDR14H                    _ATDDR14.Overlap_STR.ATDDR14HSTR.Byte
    #define ATDDR14H_BIT8               _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT8
    #define ATDDR14H_BIT9               _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT9
    #define ATDDR14H_BIT10              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT10
    #define ATDDR14H_BIT11              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT11
    #define ATDDR14H_BIT12              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT12
    #define ATDDR14H_BIT13              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT13
    #define ATDDR14H_BIT14              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT14
    #define ATDDR14H_BIT15              _ATDDR14.Overlap_STR.ATDDR14HSTR.Bits.BIT15
    
    #define ATDDR14H_BIT8_MASK          1U
    #define ATDDR14H_BIT9_MASK          2U
    #define ATDDR14H_BIT10_MASK         4U
    #define ATDDR14H_BIT11_MASK         8U
    #define ATDDR14H_BIT12_MASK         16U
    #define ATDDR14H_BIT13_MASK         32U
    #define ATDDR14H_BIT14_MASK         64U
    #define ATDDR14H_BIT15_MASK         128U
    

    /*** ATDDR14L - ATD  Conversion Result Register 14 Low; 0x000000AD ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR14LSTR;
    #define ATDDR14L                    _ATDDR14.Overlap_STR.ATDDR14LSTR.Byte
    #define ATDDR14L_BIT6               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT6
    #define ATDDR14L_BIT7               _ATDDR14.Overlap_STR.ATDDR14LSTR.Bits.BIT7
    #define ATDDR14L_BIT_6              _ATDDR14.Overlap_STR.ATDDR14LSTR.MergedBits.grpBIT_6
    #define ATDDR14L_BIT                ATDDR14L_BIT_6
    
    #define ATDDR14L_BIT6_MASK          64U
    #define ATDDR14L_BIT7_MASK          128U
    #define ATDDR14L_BIT_6_MASK         192U
    #define ATDDR14L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR14STR;
extern volatile ATDDR14STR _ATDDR14 @(REG_BASE + 0x000000ACUL);
#define ATDDR14                         _ATDDR14.Word
#define ATDDR14_BIT6                    _ATDDR14.Bits.BIT6
#define ATDDR14_BIT7                    _ATDDR14.Bits.BIT7
#define ATDDR14_BIT8                    _ATDDR14.Bits.BIT8
#define ATDDR14_BIT9                    _ATDDR14.Bits.BIT9
#define ATDDR14_BIT10                   _ATDDR14.Bits.BIT10
#define ATDDR14_BIT11                   _ATDDR14.Bits.BIT11
#define ATDDR14_BIT12                   _ATDDR14.Bits.BIT12
#define ATDDR14_BIT13                   _ATDDR14.Bits.BIT13
#define ATDDR14_BIT14                   _ATDDR14.Bits.BIT14
#define ATDDR14_BIT15                   _ATDDR14.Bits.BIT15
#define ATDDR14_BIT_6                   _ATDDR14.MergedBits.grpBIT_6
#define ATDDR14_BIT                     ATDDR14_BIT_6

#define ATDDR14_BIT6_MASK               64U
#define ATDDR14_BIT7_MASK               128U
#define ATDDR14_BIT8_MASK               256U
#define ATDDR14_BIT9_MASK               512U
#define ATDDR14_BIT10_MASK              1024U
#define ATDDR14_BIT11_MASK              2048U
#define ATDDR14_BIT12_MASK              4096U
#define ATDDR14_BIT13_MASK              8192U
#define ATDDR14_BIT14_MASK              16384U
#define ATDDR14_BIT15_MASK              32768U
#define ATDDR14_BIT_6_MASK              65472U
#define ATDDR14_BIT_6_BITNUM            6U


/*** ATDDR15 - ATD  Conversion Result Register 15; 0x000000AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR15H - ATD  Conversion Result Register 15 High; 0x000000AE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR15HSTR;
    #define ATDDR15H                    _ATDDR15.Overlap_STR.ATDDR15HSTR.Byte
    #define ATDDR15H_BIT8               _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT8
    #define ATDDR15H_BIT9               _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT9
    #define ATDDR15H_BIT10              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT10
    #define ATDDR15H_BIT11              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT11
    #define ATDDR15H_BIT12              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT12
    #define ATDDR15H_BIT13              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT13
    #define ATDDR15H_BIT14              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT14
    #define ATDDR15H_BIT15              _ATDDR15.Overlap_STR.ATDDR15HSTR.Bits.BIT15
    
    #define ATDDR15H_BIT8_MASK          1U
    #define ATDDR15H_BIT9_MASK          2U
    #define ATDDR15H_BIT10_MASK         4U
    #define ATDDR15H_BIT11_MASK         8U
    #define ATDDR15H_BIT12_MASK         16U
    #define ATDDR15H_BIT13_MASK         32U
    #define ATDDR15H_BIT14_MASK         64U
    #define ATDDR15H_BIT15_MASK         128U
    

    /*** ATDDR15L - ATD  Conversion Result Register 15 Low; 0x000000AF ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATDDR15LSTR;
    #define ATDDR15L                    _ATDDR15.Overlap_STR.ATDDR15LSTR.Byte
    #define ATDDR15L_BIT6               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT6
    #define ATDDR15L_BIT7               _ATDDR15.Overlap_STR.ATDDR15LSTR.Bits.BIT7
    #define ATDDR15L_BIT_6              _ATDDR15.Overlap_STR.ATDDR15LSTR.MergedBits.grpBIT_6
    #define ATDDR15L_BIT                ATDDR15L_BIT_6
    
    #define ATDDR15L_BIT6_MASK          64U
    #define ATDDR15L_BIT7_MASK          128U
    #define ATDDR15L_BIT_6_MASK         192U
    #define ATDDR15L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATDDR15STR;
extern volatile ATDDR15STR _ATDDR15 @(REG_BASE + 0x000000AEUL);
#define ATDDR15                         _ATDDR15.Word
#define ATDDR15_BIT6                    _ATDDR15.Bits.BIT6
#define ATDDR15_BIT7                    _ATDDR15.Bits.BIT7
#define ATDDR15_BIT8                    _ATDDR15.Bits.BIT8
#define ATDDR15_BIT9                    _ATDDR15.Bits.BIT9
#define ATDDR15_BIT10                   _ATDDR15.Bits.BIT10
#define ATDDR15_BIT11                   _ATDDR15.Bits.BIT11
#define ATDDR15_BIT12                   _ATDDR15.Bits.BIT12
#define ATDDR15_BIT13                   _ATDDR15.Bits.BIT13
#define ATDDR15_BIT14                   _ATDDR15.Bits.BIT14
#define ATDDR15_BIT15                   _ATDDR15.Bits.BIT15
#define ATDDR15_BIT_6                   _ATDDR15.MergedBits.grpBIT_6
#define ATDDR15_BIT                     ATDDR15_BIT_6

#define ATDDR15_BIT6_MASK               64U
#define ATDDR15_BIT7_MASK               128U
#define ATDDR15_BIT8_MASK               256U
#define ATDDR15_BIT9_MASK               512U
#define ATDDR15_BIT10_MASK              1024U
#define ATDDR15_BIT11_MASK              2048U
#define ATDDR15_BIT12_MASK              4096U
#define ATDDR15_BIT13_MASK              8192U
#define ATDDR15_BIT14_MASK              16384U
#define ATDDR15_BIT15_MASK              32768U
#define ATDDR15_BIT_6_MASK              65472U
#define ATDDR15_BIT_6_BITNUM            6U


/*** IVBR - Interrupt Vector Base Register; 0x000000B1 ***/
typedef union {
  byte Byte;
  struct {
    byte IVB_ADDR    :8;                                       /* Interrupt Vector Base Address Bits */
  } Bits;
} IVBRSTR;
extern volatile IVBRSTR _IVBR @(REG_BASE + 0x000000B1UL);
#define IVBR                            _IVBR.Byte
#define IVBR_IVB_ADDR                   _IVBR.Bits.IVB_ADDR

#define IVBR_IVB_ADDR_MASK              255U
#define IVBR_IVB_ADDR_BITNUM            0U


/*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x000000B6 ***/
typedef union {
  byte Byte;
  struct {
    byte XILVL       :3;                                       /* XGATE Interrupt Priority Level */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} INT_XGPRIOSTR;
extern volatile INT_XGPRIOSTR _INT_XGPRIO @(REG_BASE + 0x000000B6UL);
#define INT_XGPRIO                      _INT_XGPRIO.Byte
#define INT_XGPRIO_XILVL                _INT_XGPRIO.Bits.XILVL

#define INT_XGPRIO_XILVL_MASK           7U
#define INT_XGPRIO_XILVL_BITNUM         0U


/*** INT_CFADDR - Interrupt Request Configuration Address Register; 0x000000B7 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte INT_CFADDR_grp :4;                                    /* Interrupt Request Configuration Data Register Select Bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} INT_CFADDRSTR;
extern volatile INT_CFADDRSTR _INT_CFADDR @(REG_BASE + 0x000000B7UL);
#define INT_CFADDR                      _INT_CFADDR.Byte
#define INT_CFADDR_INT_CFADDR           _INT_CFADDR.Bits.INT_CFADDR_grp

#define INT_CFADDR_INT_CFADDR_MASK      240U
#define INT_CFADDR_INT_CFADDR_BITNUM    4U


/*** INT_CFDATA0 - Interrupt Request Configuration Data Register 0; 0x000000B8 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA0STR;
extern volatile INT_CFDATA0STR _INT_CFDATA0 @(REG_BASE + 0x000000B8UL);
#define INT_CFDATA0                     _INT_CFDATA0.Byte
#define INT_CFDATA0_PRIOLVL             _INT_CFDATA0.Bits.PRIOLVL
#define INT_CFDATA0_RQST                _INT_CFDATA0.Bits.RQST
/* INT_CFDATA_ARR: Access 8 INT_CFDATAx registers in an array */
#define INT_CFDATA_ARR                  ((volatile byte *) &INT_CFDATA0)

#define INT_CFDATA0_PRIOLVL_MASK        7U
#define INT_CFDATA0_PRIOLVL_BITNUM      0U
#define INT_CFDATA0_RQST_MASK           128U


/*** INT_CFDATA1 - Interrupt Request Configuration Data Register 1; 0x000000B9 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA1STR;
extern volatile INT_CFDATA1STR _INT_CFDATA1 @(REG_BASE + 0x000000B9UL);
#define INT_CFDATA1                     _INT_CFDATA1.Byte
#define INT_CFDATA1_PRIOLVL             _INT_CFDATA1.Bits.PRIOLVL
#define INT_CFDATA1_RQST                _INT_CFDATA1.Bits.RQST

#define INT_CFDATA1_PRIOLVL_MASK        7U
#define INT_CFDATA1_PRIOLVL_BITNUM      0U
#define INT_CFDATA1_RQST_MASK           128U


/*** INT_CFDATA2 - Interrupt Request Configuration Data Register 2; 0x000000BA ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA2STR;
extern volatile INT_CFDATA2STR _INT_CFDATA2 @(REG_BASE + 0x000000BAUL);
#define INT_CFDATA2                     _INT_CFDATA2.Byte
#define INT_CFDATA2_PRIOLVL             _INT_CFDATA2.Bits.PRIOLVL
#define INT_CFDATA2_RQST                _INT_CFDATA2.Bits.RQST

#define INT_CFDATA2_PRIOLVL_MASK        7U
#define INT_CFDATA2_PRIOLVL_BITNUM      0U
#define INT_CFDATA2_RQST_MASK           128U


/*** INT_CFDATA3 - Interrupt Request Configuration Data Register 3; 0x000000BB ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA3STR;
extern volatile INT_CFDATA3STR _INT_CFDATA3 @(REG_BASE + 0x000000BBUL);
#define INT_CFDATA3                     _INT_CFDATA3.Byte
#define INT_CFDATA3_PRIOLVL             _INT_CFDATA3.Bits.PRIOLVL
#define INT_CFDATA3_RQST                _INT_CFDATA3.Bits.RQST

#define INT_CFDATA3_PRIOLVL_MASK        7U
#define INT_CFDATA3_PRIOLVL_BITNUM      0U
#define INT_CFDATA3_RQST_MASK           128U


/*** INT_CFDATA4 - Interrupt Request Configuration Data Register 4; 0x000000BC ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA4STR;
extern volatile INT_CFDATA4STR _INT_CFDATA4 @(REG_BASE + 0x000000BCUL);
#define INT_CFDATA4                     _INT_CFDATA4.Byte
#define INT_CFDATA4_PRIOLVL             _INT_CFDATA4.Bits.PRIOLVL
#define INT_CFDATA4_RQST                _INT_CFDATA4.Bits.RQST

#define INT_CFDATA4_PRIOLVL_MASK        7U
#define INT_CFDATA4_PRIOLVL_BITNUM      0U
#define INT_CFDATA4_RQST_MASK           128U


/*** INT_CFDATA5 - Interrupt Request Configuration Data Register 5; 0x000000BD ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA5STR;
extern volatile INT_CFDATA5STR _INT_CFDATA5 @(REG_BASE + 0x000000BDUL);
#define INT_CFDATA5                     _INT_CFDATA5.Byte
#define INT_CFDATA5_PRIOLVL             _INT_CFDATA5.Bits.PRIOLVL
#define INT_CFDATA5_RQST                _INT_CFDATA5.Bits.RQST

#define INT_CFDATA5_PRIOLVL_MASK        7U
#define INT_CFDATA5_PRIOLVL_BITNUM      0U
#define INT_CFDATA5_RQST_MASK           128U


/*** INT_CFDATA6 - Interrupt Request Configuration Data Register 6; 0x000000BE ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA6STR;
extern volatile INT_CFDATA6STR _INT_CFDATA6 @(REG_BASE + 0x000000BEUL);
#define INT_CFDATA6                     _INT_CFDATA6.Byte
#define INT_CFDATA6_PRIOLVL             _INT_CFDATA6.Bits.PRIOLVL
#define INT_CFDATA6_RQST                _INT_CFDATA6.Bits.RQST

#define INT_CFDATA6_PRIOLVL_MASK        7U
#define INT_CFDATA6_PRIOLVL_BITNUM      0U
#define INT_CFDATA6_RQST_MASK           128U


/*** INT_CFDATA7 - Interrupt Request Configuration Data Register 7; 0x000000BF ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA7STR;
extern volatile INT_CFDATA7STR _INT_CFDATA7 @(REG_BASE + 0x000000BFUL);
#define INT_CFDATA7                     _INT_CFDATA7.Byte
#define INT_CFDATA7_PRIOLVL             _INT_CFDATA7.Bits.PRIOLVL
#define INT_CFDATA7_RQST                _INT_CFDATA7.Bits.RQST

#define INT_CFDATA7_PRIOLVL_MASK        7U
#define INT_CFDATA7_PRIOLVL_BITNUM      0U
#define INT_CFDATA7_RQST_MASK           128U


/*** IIC0_IBAD - IIC Address Register; 0x000000C0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IIC0_IBADSTR;
extern volatile IIC0_IBADSTR _IIC0_IBAD @(REG_BASE + 0x000000C0UL);
#define IIC0_IBAD                       _IIC0_IBAD.Byte
#define IIC0_IBAD_ADR1                  _IIC0_IBAD.Bits.ADR1
#define IIC0_IBAD_ADR2                  _IIC0_IBAD.Bits.ADR2
#define IIC0_IBAD_ADR3                  _IIC0_IBAD.Bits.ADR3
#define IIC0_IBAD_ADR4                  _IIC0_IBAD.Bits.ADR4
#define IIC0_IBAD_ADR5                  _IIC0_IBAD.Bits.ADR5
#define IIC0_IBAD_ADR6                  _IIC0_IBAD.Bits.ADR6
#define IIC0_IBAD_ADR7                  _IIC0_IBAD.Bits.ADR7
#define IIC0_IBAD_ADR_1                 _IIC0_IBAD.MergedBits.grpADR_1
#define IIC0_IBAD_ADR                   IIC0_IBAD_ADR_1

#define IIC0_IBAD_ADR1_MASK             2U
#define IIC0_IBAD_ADR2_MASK             4U
#define IIC0_IBAD_ADR3_MASK             8U
#define IIC0_IBAD_ADR4_MASK             16U
#define IIC0_IBAD_ADR5_MASK             32U
#define IIC0_IBAD_ADR6_MASK             64U
#define IIC0_IBAD_ADR7_MASK             128U
#define IIC0_IBAD_ADR_1_MASK            254U
#define IIC0_IBAD_ADR_1_BITNUM          1U


/*** IIC0_IBFD - IIC Frequency Divider Register; 0x000000C1 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IIC0_IBFDSTR;
extern volatile IIC0_IBFDSTR _IIC0_IBFD @(REG_BASE + 0x000000C1UL);
#define IIC0_IBFD                       _IIC0_IBFD.Byte
#define IIC0_IBFD_IBC0                  _IIC0_IBFD.Bits.IBC0
#define IIC0_IBFD_IBC1                  _IIC0_IBFD.Bits.IBC1
#define IIC0_IBFD_IBC2                  _IIC0_IBFD.Bits.IBC2
#define IIC0_IBFD_IBC3                  _IIC0_IBFD.Bits.IBC3
#define IIC0_IBFD_IBC4                  _IIC0_IBFD.Bits.IBC4
#define IIC0_IBFD_IBC5                  _IIC0_IBFD.Bits.IBC5
#define IIC0_IBFD_IBC6                  _IIC0_IBFD.Bits.IBC6
#define IIC0_IBFD_IBC7                  _IIC0_IBFD.Bits.IBC7

#define IIC0_IBFD_IBC0_MASK             1U
#define IIC0_IBFD_IBC1_MASK             2U
#define IIC0_IBFD_IBC2_MASK             4U
#define IIC0_IBFD_IBC3_MASK             8U
#define IIC0_IBFD_IBC4_MASK             16U
#define IIC0_IBFD_IBC5_MASK             32U
#define IIC0_IBFD_IBC6_MASK             64U
#define IIC0_IBFD_IBC7_MASK             128U


/*** IIC0_IBCR - IIC Control Register; 0x000000C2 ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IIC0_IBCRSTR;
extern volatile IIC0_IBCRSTR _IIC0_IBCR @(REG_BASE + 0x000000C2UL);
#define IIC0_IBCR                       _IIC0_IBCR.Byte
#define IIC0_IBCR_IBSWAI                _IIC0_IBCR.Bits.IBSWAI
#define IIC0_IBCR_RSTA                  _IIC0_IBCR.Bits.RSTA
#define IIC0_IBCR_TXAK                  _IIC0_IBCR.Bits.TXAK
#define IIC0_IBCR_TX_RX                 _IIC0_IBCR.Bits.TX_RX
#define IIC0_IBCR_MS_SL                 _IIC0_IBCR.Bits.MS_SL
#define IIC0_IBCR_IBIE                  _IIC0_IBCR.Bits.IBIE
#define IIC0_IBCR_IBEN                  _IIC0_IBCR.Bits.IBEN

#define IIC0_IBCR_IBSWAI_MASK           1U
#define IIC0_IBCR_RSTA_MASK             4U
#define IIC0_IBCR_TXAK_MASK             8U
#define IIC0_IBCR_TX_RX_MASK            16U
#define IIC0_IBCR_MS_SL_MASK            32U
#define IIC0_IBCR_IBIE_MASK             64U
#define IIC0_IBCR_IBEN_MASK             128U


/*** IIC0_IBSR - IIC Status Register; 0x000000C3 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IIC0_IBSRSTR;
extern volatile IIC0_IBSRSTR _IIC0_IBSR @(REG_BASE + 0x000000C3UL);
#define IIC0_IBSR                       _IIC0_IBSR.Byte
#define IIC0_IBSR_RXAK                  _IIC0_IBSR.Bits.RXAK
#define IIC0_IBSR_IBIF                  _IIC0_IBSR.Bits.IBIF
#define IIC0_IBSR_SRW                   _IIC0_IBSR.Bits.SRW
#define IIC0_IBSR_IBAL                  _IIC0_IBSR.Bits.IBAL
#define IIC0_IBSR_IBB                   _IIC0_IBSR.Bits.IBB
#define IIC0_IBSR_IAAS                  _IIC0_IBSR.Bits.IAAS
#define IIC0_IBSR_TCF                   _IIC0_IBSR.Bits.TCF

#define IIC0_IBSR_RXAK_MASK             1U
#define IIC0_IBSR_IBIF_MASK             2U
#define IIC0_IBSR_SRW_MASK              4U
#define IIC0_IBSR_IBAL_MASK             16U
#define IIC0_IBSR_IBB_MASK              32U
#define IIC0_IBSR_IAAS_MASK             64U
#define IIC0_IBSR_TCF_MASK              128U


/*** IIC0_IBDR - IIC Data I/O Register; 0x000000C4 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IIC0_IBDRSTR;
extern volatile IIC0_IBDRSTR _IIC0_IBDR @(REG_BASE + 0x000000C4UL);
#define IIC0_IBDR                       _IIC0_IBDR.Byte
#define IIC0_IBDR_D0                    _IIC0_IBDR.Bits.D0
#define IIC0_IBDR_D1                    _IIC0_IBDR.Bits.D1
#define IIC0_IBDR_D2                    _IIC0_IBDR.Bits.D2
#define IIC0_IBDR_D3                    _IIC0_IBDR.Bits.D3
#define IIC0_IBDR_D4                    _IIC0_IBDR.Bits.D4
#define IIC0_IBDR_D5                    _IIC0_IBDR.Bits.D5
#define IIC0_IBDR_D6                    _IIC0_IBDR.Bits.D6
#define IIC0_IBDR_D7                    _IIC0_IBDR.Bits.D7

#define IIC0_IBDR_D0_MASK               1U
#define IIC0_IBDR_D1_MASK               2U
#define IIC0_IBDR_D2_MASK               4U
#define IIC0_IBDR_D3_MASK               8U
#define IIC0_IBDR_D4_MASK               16U
#define IIC0_IBDR_D5_MASK               32U
#define IIC0_IBDR_D6_MASK               64U
#define IIC0_IBDR_D7_MASK               128U


/*** IIC0_IBCR2 - IIC Control Register 2; 0x000000C5 ***/
typedef union {
  byte Byte;
  struct {
    byte ADR8        :1;                                       /* Slave Address Bit 8 */
    byte ADR9        :1;                                       /* Slave Address Bit 9 */
    byte ADR10       :1;                                       /* Slave Address Bit 10 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte ADTYPE      :1;                                       /* Address Type */
    byte GCEN        :1;                                       /* General Call Enable */
  } Bits;
  struct {
    byte grpADR_8 :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IIC0_IBCR2STR;
extern volatile IIC0_IBCR2STR _IIC0_IBCR2 @(REG_BASE + 0x000000C5UL);
#define IIC0_IBCR2                      _IIC0_IBCR2.Byte
#define IIC0_IBCR2_ADR8                 _IIC0_IBCR2.Bits.ADR8
#define IIC0_IBCR2_ADR9                 _IIC0_IBCR2.Bits.ADR9
#define IIC0_IBCR2_ADR10                _IIC0_IBCR2.Bits.ADR10
#define IIC0_IBCR2_ADTYPE               _IIC0_IBCR2.Bits.ADTYPE
#define IIC0_IBCR2_GCEN                 _IIC0_IBCR2.Bits.GCEN
#define IIC0_IBCR2_ADR_8                _IIC0_IBCR2.MergedBits.grpADR_8
#define IIC0_IBCR2_ADR                  IIC0_IBCR2_ADR_8

#define IIC0_IBCR2_ADR8_MASK            1U
#define IIC0_IBCR2_ADR9_MASK            2U
#define IIC0_IBCR2_ADR10_MASK           4U
#define IIC0_IBCR2_ADTYPE_MASK          64U
#define IIC0_IBCR2_GCEN_MASK            128U
#define IIC0_IBCR2_ADR_8_MASK           7U
#define IIC0_IBCR2_ADR_8_BITNUM         0U


/*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI0ASR1STR;
        #define SCI0ASR1                _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0ASR1_BKDIF          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BKDIF
        #define SCI0ASR1_BERRIF         _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRIF
        #define SCI0ASR1_BERRV          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRV
        #define SCI0ASR1_RXEDGIF        _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.RXEDGIF
        
        #define SCI0ASR1_BKDIF_MASK     1U
        #define SCI0ASR1_BERRIF_MASK    2U
        #define SCI0ASR1_BERRV_MASK     4U
        #define SCI0ASR1_RXEDGIF_MASK   128U
        
        /*** SCI0BDH - SCI 0 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI0BDHSTR;
        #define SCI0BDH                 _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0BDH_SBR8            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR8
        #define SCI0BDH_SBR9            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR9
        #define SCI0BDH_SBR10           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR10
        #define SCI0BDH_SBR11           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR11
        #define SCI0BDH_SBR12           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR12
        #define SCI0BDH_TNP0            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP0
        #define SCI0BDH_TNP1            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP1
        #define SCI0BDH_IREN            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.IREN
        #define SCI0BDH_SBR_8           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpSBR_8
        #define SCI0BDH_TNP             _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpTNP
        #define SCI0BDH_SBR             SCI0BDH_SBR_8
        
        #define SCI0BDH_SBR8_MASK       1U
        #define SCI0BDH_SBR9_MASK       2U
        #define SCI0BDH_SBR10_MASK      4U
        #define SCI0BDH_SBR11_MASK      8U
        #define SCI0BDH_SBR12_MASK      16U
        #define SCI0BDH_TNP0_MASK       32U
        #define SCI0BDH_TNP1_MASK       64U
        #define SCI0BDH_IREN_MASK       128U
        #define SCI0BDH_SBR_8_MASK      31U
        #define SCI0BDH_SBR_8_BITNUM    0U
        #define SCI0BDH_TNP_MASK        96U
        #define SCI0BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ASR1STR;
    

    /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI0ACR1STR;
        #define SCI0ACR1                _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0ACR1_BKDIE          _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BKDIE
        #define SCI0ACR1_BERRIE         _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BERRIE
        #define SCI0ACR1_RXEDGIE        _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.RXEDGIE
        
        #define SCI0ACR1_BKDIE_MASK     1U
        #define SCI0ACR1_BERRIE_MASK    2U
        #define SCI0ACR1_RXEDGIE_MASK   128U
        
        /*** SCI0BDL - SCI 0 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI0BDLSTR;
        #define SCI0BDL                 _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0BDL_SBR0            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR0
        #define SCI0BDL_SBR1            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR1
        #define SCI0BDL_SBR2            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR2
        #define SCI0BDL_SBR3            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR3
        #define SCI0BDL_SBR4            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR4
        #define SCI0BDL_SBR5            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR5
        #define SCI0BDL_SBR6            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR6
        #define SCI0BDL_SBR7            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR7
        
        #define SCI0BDL_SBR0_MASK       1U
        #define SCI0BDL_SBR1_MASK       2U
        #define SCI0BDL_SBR2_MASK       4U
        #define SCI0BDL_SBR3_MASK       8U
        #define SCI0BDL_SBR4_MASK       16U
        #define SCI0BDL_SBR5_MASK       32U
        #define SCI0BDL_SBR6_MASK       64U
        #define SCI0BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @(REG_BASE + 0x000000C8UL);
#define SCI0BD                          _SCI0BD.Word
#define SCI0BD_SBR0                     _SCI0BD.Bits.SBR0
#define SCI0BD_SBR1                     _SCI0BD.Bits.SBR1
#define SCI0BD_SBR2                     _SCI0BD.Bits.SBR2
#define SCI0BD_SBR3                     _SCI0BD.Bits.SBR3
#define SCI0BD_SBR4                     _SCI0BD.Bits.SBR4
#define SCI0BD_SBR5                     _SCI0BD.Bits.SBR5
#define SCI0BD_SBR6                     _SCI0BD.Bits.SBR6
#define SCI0BD_SBR7                     _SCI0BD.Bits.SBR7
#define SCI0BD_SBR8                     _SCI0BD.Bits.SBR8
#define SCI0BD_SBR9                     _SCI0BD.Bits.SBR9
#define SCI0BD_SBR10                    _SCI0BD.Bits.SBR10
#define SCI0BD_SBR11                    _SCI0BD.Bits.SBR11
#define SCI0BD_SBR12                    _SCI0BD.Bits.SBR12
#define SCI0BD_TNP0                     _SCI0BD.Bits.TNP0
#define SCI0BD_TNP1                     _SCI0BD.Bits.TNP1
#define SCI0BD_IREN                     _SCI0BD.Bits.IREN
#define SCI0BD_SBR                      _SCI0BD.MergedBits.grpSBR
#define SCI0BD_TNP                      _SCI0BD.MergedBits.grpTNP

#define SCI0BD_SBR0_MASK                1U
#define SCI0BD_SBR1_MASK                2U
#define SCI0BD_SBR2_MASK                4U
#define SCI0BD_SBR3_MASK                8U
#define SCI0BD_SBR4_MASK                16U
#define SCI0BD_SBR5_MASK                32U
#define SCI0BD_SBR6_MASK                64U
#define SCI0BD_SBR7_MASK                128U
#define SCI0BD_SBR8_MASK                256U
#define SCI0BD_SBR9_MASK                512U
#define SCI0BD_SBR10_MASK               1024U
#define SCI0BD_SBR11_MASK               2048U
#define SCI0BD_SBR12_MASK               4096U
#define SCI0BD_TNP0_MASK                8192U
#define SCI0BD_TNP1_MASK                16384U
#define SCI0BD_IREN_MASK                32768U
#define SCI0BD_SBR_MASK                 8191U
#define SCI0BD_SBR_BITNUM               0U
#define SCI0BD_TNP_MASK                 24576U
#define SCI0BD_TNP_BITNUM               13U


/*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI0ACR2 - SCI 0 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI0ACR2STR;
    #define SCI0ACR2                    _SCI0ACR2.Byte
    #define SCI0ACR2_BKDFE              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BKDFE
    #define SCI0ACR2_BERRM0             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM0
    #define SCI0ACR2_BERRM1             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM1
    #define SCI0ACR2_BERRM              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.MergedBits.grpBERRM
    
    #define SCI0ACR2_BKDFE_MASK         1U
    #define SCI0ACR2_BERRM0_MASK        2U
    #define SCI0ACR2_BERRM1_MASK        4U
    #define SCI0ACR2_BERRM_MASK         6U
    #define SCI0ACR2_BERRM_BITNUM       1U
    
    /*** SCI0CR1 - SCI 0 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI0CR1STR;
    #define SCI0CR1                     _SCI0ACR2.Byte
    #define SCI0CR1_PT                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PT
    #define SCI0CR1_PE                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PE
    #define SCI0CR1_ILT                 _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.ILT
    #define SCI0CR1_WAKE                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.WAKE
    #define SCI0CR1_M                   _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.M
    #define SCI0CR1_RSRC                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.RSRC
    #define SCI0CR1_SCISWAI             _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.SCISWAI
    #define SCI0CR1_LOOPS               _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.LOOPS
    
    #define SCI0CR1_PT_MASK             1U
    #define SCI0CR1_PE_MASK             2U
    #define SCI0CR1_ILT_MASK            4U
    #define SCI0CR1_WAKE_MASK           8U
    #define SCI0CR1_M_MASK              16U
    #define SCI0CR1_RSRC_MASK           32U
    #define SCI0CR1_SCISWAI_MASK        64U
    #define SCI0CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI0ACR2STR;
extern volatile SCI0ACR2STR _SCI0ACR2 @(REG_BASE + 0x000000CAUL);


/*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI0CR2STR;
extern volatile SCI0CR2STR _SCI0CR2 @(REG_BASE + 0x000000CBUL);
#define SCI0CR2                         _SCI0CR2.Byte
#define SCI0CR2_SBK                     _SCI0CR2.Bits.SBK
#define SCI0CR2_RWU                     _SCI0CR2.Bits.RWU
#define SCI0CR2_RE                      _SCI0CR2.Bits.RE
#define SCI0CR2_TE                      _SCI0CR2.Bits.TE
#define SCI0CR2_ILIE                    _SCI0CR2.Bits.ILIE
#define SCI0CR2_RIE                     _SCI0CR2.Bits.RIE
#define SCI0CR2_TCIE                    _SCI0CR2.Bits.TCIE
#define SCI0CR2_TIE                     _SCI0CR2.Bits.TIE_bit

#define SCI0CR2_SBK_MASK                1U
#define SCI0CR2_RWU_MASK                2U
#define SCI0CR2_RE_MASK                 4U
#define SCI0CR2_TE_MASK                 8U
#define SCI0CR2_ILIE_MASK               16U
#define SCI0CR2_RIE_MASK                32U
#define SCI0CR2_TCIE_MASK               64U
#define SCI0CR2_TIE_MASK                128U


/*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0SR1STR;
extern volatile SCI0SR1STR _SCI0SR1 @(REG_BASE + 0x000000CCUL);
#define SCI0SR1                         _SCI0SR1.Byte
#define SCI0SR1_PF                      _SCI0SR1.Bits.PF
#define SCI0SR1_FE                      _SCI0SR1.Bits.FE
#define SCI0SR1_NF                      _SCI0SR1.Bits.NF
#define SCI0SR1_OR                      _SCI0SR1.Bits.OR
#define SCI0SR1_IDLE                    _SCI0SR1.Bits.IDLE
#define SCI0SR1_RDRF                    _SCI0SR1.Bits.RDRF
#define SCI0SR1_TC                      _SCI0SR1.Bits.TC
#define SCI0SR1_TDRE                    _SCI0SR1.Bits.TDRE

#define SCI0SR1_PF_MASK                 1U
#define SCI0SR1_FE_MASK                 2U
#define SCI0SR1_NF_MASK                 4U
#define SCI0SR1_OR_MASK                 8U
#define SCI0SR1_IDLE_MASK               16U
#define SCI0SR1_RDRF_MASK               32U
#define SCI0SR1_TC_MASK                 64U
#define SCI0SR1_TDRE_MASK               128U


/*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI0SR2STR;
extern volatile SCI0SR2STR _SCI0SR2 @(REG_BASE + 0x000000CDUL);
#define SCI0SR2                         _SCI0SR2.Byte
#define SCI0SR2_RAF                     _SCI0SR2.Bits.RAF
#define SCI0SR2_TXDIR                   _SCI0SR2.Bits.TXDIR
#define SCI0SR2_BRK13                   _SCI0SR2.Bits.BRK13
#define SCI0SR2_RXPOL                   _SCI0SR2.Bits.RXPOL
#define SCI0SR2_TXPOL                   _SCI0SR2.Bits.TXPOL
#define SCI0SR2_AMAP                    _SCI0SR2.Bits.AMAP

#define SCI0SR2_RAF_MASK                1U
#define SCI0SR2_TXDIR_MASK              2U
#define SCI0SR2_BRK13_MASK              4U
#define SCI0SR2_RXPOL_MASK              8U
#define SCI0SR2_TXPOL_MASK              16U
#define SCI0SR2_AMAP_MASK               128U


/*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI0DRHSTR;
extern volatile SCI0DRHSTR _SCI0DRH @(REG_BASE + 0x000000CEUL);
#define SCI0DRH                         _SCI0DRH.Byte
#define SCI0DRH_T8                      _SCI0DRH.Bits.T8
#define SCI0DRH_R8                      _SCI0DRH.Bits.R8

#define SCI0DRH_T8_MASK                 64U
#define SCI0DRH_R8_MASK                 128U


/*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI0DRLSTR;
extern volatile SCI0DRLSTR _SCI0DRL @(REG_BASE + 0x000000CFUL);
#define SCI0DRL                         _SCI0DRL.Byte
#define SCI0DRL_R0_T0                   _SCI0DRL.Bits.R0_T0
#define SCI0DRL_R1_T1                   _SCI0DRL.Bits.R1_T1
#define SCI0DRL_R2_T2                   _SCI0DRL.Bits.R2_T2
#define SCI0DRL_R3_T3                   _SCI0DRL.Bits.R3_T3
#define SCI0DRL_R4_T4                   _SCI0DRL.Bits.R4_T4
#define SCI0DRL_R5_T5                   _SCI0DRL.Bits.R5_T5
#define SCI0DRL_R6_T6                   _SCI0DRL.Bits.R6_T6
#define SCI0DRL_R7_T7                   _SCI0DRL.Bits.R7_T7

#define SCI0DRL_R0_T0_MASK              1U
#define SCI0DRL_R1_T1_MASK              2U
#define SCI0DRL_R2_T2_MASK              4U
#define SCI0DRL_R3_T3_MASK              8U
#define SCI0DRL_R4_T4_MASK              16U
#define SCI0DRL_R5_T5_MASK              32U
#define SCI0DRL_R6_T6_MASK              64U
#define SCI0DRL_R7_T7_MASK              128U


/*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI1ASR1STR;
        #define SCI1ASR1                _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1ASR1_BKDIF          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BKDIF
        #define SCI1ASR1_BERRIF         _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRIF
        #define SCI1ASR1_BERRV          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRV
        #define SCI1ASR1_RXEDGIF        _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.RXEDGIF
        
        #define SCI1ASR1_BKDIF_MASK     1U
        #define SCI1ASR1_BERRIF_MASK    2U
        #define SCI1ASR1_BERRV_MASK     4U
        #define SCI1ASR1_RXEDGIF_MASK   128U
        
        /*** SCI1BDH - SCI 1 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI1BDHSTR;
        #define SCI1BDH                 _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1BDH_SBR8            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR8
        #define SCI1BDH_SBR9            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR9
        #define SCI1BDH_SBR10           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR10
        #define SCI1BDH_SBR11           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR11
        #define SCI1BDH_SBR12           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR12
        #define SCI1BDH_TNP0            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP0
        #define SCI1BDH_TNP1            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP1
        #define SCI1BDH_IREN            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.IREN
        #define SCI1BDH_SBR_8           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpSBR_8
        #define SCI1BDH_TNP             _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpTNP
        #define SCI1BDH_SBR             SCI1BDH_SBR_8
        
        #define SCI1BDH_SBR8_MASK       1U
        #define SCI1BDH_SBR9_MASK       2U
        #define SCI1BDH_SBR10_MASK      4U
        #define SCI1BDH_SBR11_MASK      8U
        #define SCI1BDH_SBR12_MASK      16U
        #define SCI1BDH_TNP0_MASK       32U
        #define SCI1BDH_TNP1_MASK       64U
        #define SCI1BDH_IREN_MASK       128U
        #define SCI1BDH_SBR_8_MASK      31U
        #define SCI1BDH_SBR_8_BITNUM    0U
        #define SCI1BDH_TNP_MASK        96U
        #define SCI1BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ASR1STR;
    

    /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI1ACR1STR;
        #define SCI1ACR1                _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1ACR1_BKDIE          _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BKDIE
        #define SCI1ACR1_BERRIE         _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BERRIE
        #define SCI1ACR1_RXEDGIE        _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.RXEDGIE
        
        #define SCI1ACR1_BKDIE_MASK     1U
        #define SCI1ACR1_BERRIE_MASK    2U
        #define SCI1ACR1_RXEDGIE_MASK   128U
        
        /*** SCI1BDL - SCI 1 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI1BDLSTR;
        #define SCI1BDL                 _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1BDL_SBR0            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR0
        #define SCI1BDL_SBR1            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR1
        #define SCI1BDL_SBR2            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR2
        #define SCI1BDL_SBR3            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR3
        #define SCI1BDL_SBR4            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR4
        #define SCI1BDL_SBR5            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR5
        #define SCI1BDL_SBR6            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR6
        #define SCI1BDL_SBR7            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR7
        
        #define SCI1BDL_SBR0_MASK       1U
        #define SCI1BDL_SBR1_MASK       2U
        #define SCI1BDL_SBR2_MASK       4U
        #define SCI1BDL_SBR3_MASK       8U
        #define SCI1BDL_SBR4_MASK       16U
        #define SCI1BDL_SBR5_MASK       32U
        #define SCI1BDL_SBR6_MASK       64U
        #define SCI1BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI1BDSTR;
extern volatile SCI1BDSTR _SCI1BD @(REG_BASE + 0x000000D0UL);
#define SCI1BD                          _SCI1BD.Word
#define SCI1BD_SBR0                     _SCI1BD.Bits.SBR0
#define SCI1BD_SBR1                     _SCI1BD.Bits.SBR1
#define SCI1BD_SBR2                     _SCI1BD.Bits.SBR2
#define SCI1BD_SBR3                     _SCI1BD.Bits.SBR3
#define SCI1BD_SBR4                     _SCI1BD.Bits.SBR4
#define SCI1BD_SBR5                     _SCI1BD.Bits.SBR5
#define SCI1BD_SBR6                     _SCI1BD.Bits.SBR6
#define SCI1BD_SBR7                     _SCI1BD.Bits.SBR7
#define SCI1BD_SBR8                     _SCI1BD.Bits.SBR8
#define SCI1BD_SBR9                     _SCI1BD.Bits.SBR9
#define SCI1BD_SBR10                    _SCI1BD.Bits.SBR10
#define SCI1BD_SBR11                    _SCI1BD.Bits.SBR11
#define SCI1BD_SBR12                    _SCI1BD.Bits.SBR12
#define SCI1BD_TNP0                     _SCI1BD.Bits.TNP0
#define SCI1BD_TNP1                     _SCI1BD.Bits.TNP1
#define SCI1BD_IREN                     _SCI1BD.Bits.IREN
#define SCI1BD_SBR                      _SCI1BD.MergedBits.grpSBR
#define SCI1BD_TNP                      _SCI1BD.MergedBits.grpTNP

#define SCI1BD_SBR0_MASK                1U
#define SCI1BD_SBR1_MASK                2U
#define SCI1BD_SBR2_MASK                4U
#define SCI1BD_SBR3_MASK                8U
#define SCI1BD_SBR4_MASK                16U
#define SCI1BD_SBR5_MASK                32U
#define SCI1BD_SBR6_MASK                64U
#define SCI1BD_SBR7_MASK                128U
#define SCI1BD_SBR8_MASK                256U
#define SCI1BD_SBR9_MASK                512U
#define SCI1BD_SBR10_MASK               1024U
#define SCI1BD_SBR11_MASK               2048U
#define SCI1BD_SBR12_MASK               4096U
#define SCI1BD_TNP0_MASK                8192U
#define SCI1BD_TNP1_MASK                16384U
#define SCI1BD_IREN_MASK                32768U
#define SCI1BD_SBR_MASK                 8191U
#define SCI1BD_SBR_BITNUM               0U
#define SCI1BD_TNP_MASK                 24576U
#define SCI1BD_TNP_BITNUM               13U


/*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI1ACR2 - SCI 1 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI1ACR2STR;
    #define SCI1ACR2                    _SCI1ACR2.Byte
    #define SCI1ACR2_BKDFE              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BKDFE
    #define SCI1ACR2_BERRM0             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM0
    #define SCI1ACR2_BERRM1             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM1
    #define SCI1ACR2_BERRM              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.MergedBits.grpBERRM
    
    #define SCI1ACR2_BKDFE_MASK         1U
    #define SCI1ACR2_BERRM0_MASK        2U
    #define SCI1ACR2_BERRM1_MASK        4U
    #define SCI1ACR2_BERRM_MASK         6U
    #define SCI1ACR2_BERRM_BITNUM       1U
    
    /*** SCI1CR1 - SCI 1 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI1CR1STR;
    #define SCI1CR1                     _SCI1ACR2.Byte
    #define SCI1CR1_PT                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PT
    #define SCI1CR1_PE                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PE
    #define SCI1CR1_ILT                 _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.ILT
    #define SCI1CR1_WAKE                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.WAKE
    #define SCI1CR1_M                   _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.M
    #define SCI1CR1_RSRC                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.RSRC
    #define SCI1CR1_SCISWAI             _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.SCISWAI
    #define SCI1CR1_LOOPS               _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.LOOPS
    
    #define SCI1CR1_PT_MASK             1U
    #define SCI1CR1_PE_MASK             2U
    #define SCI1CR1_ILT_MASK            4U
    #define SCI1CR1_WAKE_MASK           8U
    #define SCI1CR1_M_MASK              16U
    #define SCI1CR1_RSRC_MASK           32U
    #define SCI1CR1_SCISWAI_MASK        64U
    #define SCI1CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI1ACR2STR;
extern volatile SCI1ACR2STR _SCI1ACR2 @(REG_BASE + 0x000000D2UL);


/*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI1CR2STR;
extern volatile SCI1CR2STR _SCI1CR2 @(REG_BASE + 0x000000D3UL);
#define SCI1CR2                         _SCI1CR2.Byte
#define SCI1CR2_SBK                     _SCI1CR2.Bits.SBK
#define SCI1CR2_RWU                     _SCI1CR2.Bits.RWU
#define SCI1CR2_RE                      _SCI1CR2.Bits.RE
#define SCI1CR2_TE                      _SCI1CR2.Bits.TE
#define SCI1CR2_ILIE                    _SCI1CR2.Bits.ILIE
#define SCI1CR2_RIE                     _SCI1CR2.Bits.RIE
#define SCI1CR2_TCIE                    _SCI1CR2.Bits.TCIE
#define SCI1CR2_TIE                     _SCI1CR2.Bits.TIE_bit

#define SCI1CR2_SBK_MASK                1U
#define SCI1CR2_RWU_MASK                2U
#define SCI1CR2_RE_MASK                 4U
#define SCI1CR2_TE_MASK                 8U
#define SCI1CR2_ILIE_MASK               16U
#define SCI1CR2_RIE_MASK                32U
#define SCI1CR2_TCIE_MASK               64U
#define SCI1CR2_TIE_MASK                128U


/*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI1SR1STR;
extern volatile SCI1SR1STR _SCI1SR1 @(REG_BASE + 0x000000D4UL);
#define SCI1SR1                         _SCI1SR1.Byte
#define SCI1SR1_PF                      _SCI1SR1.Bits.PF
#define SCI1SR1_FE                      _SCI1SR1.Bits.FE
#define SCI1SR1_NF                      _SCI1SR1.Bits.NF
#define SCI1SR1_OR                      _SCI1SR1.Bits.OR
#define SCI1SR1_IDLE                    _SCI1SR1.Bits.IDLE
#define SCI1SR1_RDRF                    _SCI1SR1.Bits.RDRF
#define SCI1SR1_TC                      _SCI1SR1.Bits.TC
#define SCI1SR1_TDRE                    _SCI1SR1.Bits.TDRE

#define SCI1SR1_PF_MASK                 1U
#define SCI1SR1_FE_MASK                 2U
#define SCI1SR1_NF_MASK                 4U
#define SCI1SR1_OR_MASK                 8U
#define SCI1SR1_IDLE_MASK               16U
#define SCI1SR1_RDRF_MASK               32U
#define SCI1SR1_TC_MASK                 64U
#define SCI1SR1_TDRE_MASK               128U


/*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI1SR2STR;
extern volatile SCI1SR2STR _SCI1SR2 @(REG_BASE + 0x000000D5UL);
#define SCI1SR2                         _SCI1SR2.Byte
#define SCI1SR2_RAF                     _SCI1SR2.Bits.RAF
#define SCI1SR2_TXDIR                   _SCI1SR2.Bits.TXDIR
#define SCI1SR2_BRK13                   _SCI1SR2.Bits.BRK13
#define SCI1SR2_RXPOL                   _SCI1SR2.Bits.RXPOL
#define SCI1SR2_TXPOL                   _SCI1SR2.Bits.TXPOL
#define SCI1SR2_AMAP                    _SCI1SR2.Bits.AMAP

#define SCI1SR2_RAF_MASK                1U
#define SCI1SR2_TXDIR_MASK              2U
#define SCI1SR2_BRK13_MASK              4U
#define SCI1SR2_RXPOL_MASK              8U
#define SCI1SR2_TXPOL_MASK              16U
#define SCI1SR2_AMAP_MASK               128U


/*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI1DRHSTR;
extern volatile SCI1DRHSTR _SCI1DRH @(REG_BASE + 0x000000D6UL);
#define SCI1DRH                         _SCI1DRH.Byte
#define SCI1DRH_T8                      _SCI1DRH.Bits.T8
#define SCI1DRH_R8                      _SCI1DRH.Bits.R8

#define SCI1DRH_T8_MASK                 64U
#define SCI1DRH_R8_MASK                 128U


/*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI1DRLSTR;
extern volatile SCI1DRLSTR _SCI1DRL @(REG_BASE + 0x000000D7UL);
#define SCI1DRL                         _SCI1DRL.Byte
#define SCI1DRL_R0_T0                   _SCI1DRL.Bits.R0_T0
#define SCI1DRL_R1_T1                   _SCI1DRL.Bits.R1_T1
#define SCI1DRL_R2_T2                   _SCI1DRL.Bits.R2_T2
#define SCI1DRL_R3_T3                   _SCI1DRL.Bits.R3_T3
#define SCI1DRL_R4_T4                   _SCI1DRL.Bits.R4_T4
#define SCI1DRL_R5_T5                   _SCI1DRL.Bits.R5_T5
#define SCI1DRL_R6_T6                   _SCI1DRL.Bits.R6_T6
#define SCI1DRL_R7_T7                   _SCI1DRL.Bits.R7_T7

#define SCI1DRL_R0_T0_MASK              1U
#define SCI1DRL_R1_T1_MASK              2U
#define SCI1DRL_R2_T2_MASK              4U
#define SCI1DRL_R3_T3_MASK              8U
#define SCI1DRL_R4_T4_MASK              16U
#define SCI1DRL_R5_T5_MASK              32U
#define SCI1DRL_R6_T6_MASK              64U
#define SCI1DRL_R7_T7_MASK              128U


/*** SPICR1 - SPI  Control Register 1; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPICR1STR;
extern volatile SPICR1STR _SPICR1 @(REG_BASE + 0x000000D8UL);
#define SPICR1                          _SPICR1.Byte
#define SPICR1_LSBFE                    _SPICR1.Bits.LSBFE
#define SPICR1_SSOE                     _SPICR1.Bits.SSOE
#define SPICR1_CPHA                     _SPICR1.Bits.CPHA
#define SPICR1_CPOL                     _SPICR1.Bits.CPOL
#define SPICR1_MSTR                     _SPICR1.Bits.MSTR
#define SPICR1_SPTIE                    _SPICR1.Bits.SPTIE
#define SPICR1_SPE                      _SPICR1.Bits.SPE
#define SPICR1_SPIE                     _SPICR1.Bits.SPIE

#define SPICR1_LSBFE_MASK               1U
#define SPICR1_SSOE_MASK                2U
#define SPICR1_CPHA_MASK                4U
#define SPICR1_CPOL_MASK                8U
#define SPICR1_MSTR_MASK                16U
#define SPICR1_SPTIE_MASK               32U
#define SPICR1_SPE_MASK                 64U
#define SPICR1_SPIE_MASK                128U


/*** SPICR2 - SPI  Control Register 2; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPICR2STR;
extern volatile SPICR2STR _SPICR2 @(REG_BASE + 0x000000D9UL);
#define SPICR2                          _SPICR2.Byte
#define SPICR2_SPC0                     _SPICR2.Bits.SPC0
#define SPICR2_SPISWAI                  _SPICR2.Bits.SPISWAI
#define SPICR2_BIDIROE                  _SPICR2.Bits.BIDIROE
#define SPICR2_MODFEN                   _SPICR2.Bits.MODFEN

#define SPICR2_SPC0_MASK                1U
#define SPICR2_SPISWAI_MASK             2U
#define SPICR2_BIDIROE_MASK             8U
#define SPICR2_MODFEN_MASK              16U


/*** SPIBR - SPI  Baud Rate Register; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPIBRSTR;
extern volatile SPIBRSTR _SPIBR @(REG_BASE + 0x000000DAUL);
#define SPIBR                           _SPIBR.Byte
#define SPIBR_SPR0                      _SPIBR.Bits.SPR0
#define SPIBR_SPR1                      _SPIBR.Bits.SPR1
#define SPIBR_SPR2                      _SPIBR.Bits.SPR2
#define SPIBR_SPPR0                     _SPIBR.Bits.SPPR0
#define SPIBR_SPPR1                     _SPIBR.Bits.SPPR1
#define SPIBR_SPPR2                     _SPIBR.Bits.SPPR2
#define SPIBR_SPR                       _SPIBR.MergedBits.grpSPR
#define SPIBR_SPPR                      _SPIBR.MergedBits.grpSPPR

#define SPIBR_SPR0_MASK                 1U
#define SPIBR_SPR1_MASK                 2U
#define SPIBR_SPR2_MASK                 4U
#define SPIBR_SPPR0_MASK                16U
#define SPIBR_SPPR1_MASK                32U
#define SPIBR_SPPR2_MASK                64U
#define SPIBR_SPR_MASK                  7U
#define SPIBR_SPR_BITNUM                0U
#define SPIBR_SPPR_MASK                 112U
#define SPIBR_SPPR_BITNUM               4U


/*** SPISR - SPI  Status Register; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPISRSTR;
extern volatile SPISRSTR _SPISR @(REG_BASE + 0x000000DBUL);
#define SPISR                           _SPISR.Byte
#define SPISR_MODF                      _SPISR.Bits.MODF
#define SPISR_SPTEF                     _SPISR.Bits.SPTEF
#define SPISR_SPIF                      _SPISR.Bits.SPIF

#define SPISR_MODF_MASK                 16U
#define SPISR_SPTEF_MASK                32U
#define SPISR_SPIF_MASK                 128U


/*** SPIDR - SPI  Data Register; 0x000000DD ***/
typedef union {
  byte Byte;
} SPIDRSTR;
extern volatile SPIDRSTR _SPIDR @(REG_BASE + 0x000000DDUL);
#define SPIDR                           _SPIDR.Byte


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Flash Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Flash Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Flash Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Flash Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Flash Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Flash Clock Divider Bit 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte FDIVLD      :1;                                       /* Flash Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_PRDIV8                  _FCLKDIV.Bits.PRDIV8
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_PRDIV8_MASK             64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               63U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte RNV2        :1;                                       /* Non Volatile flag bit 2 */
    byte RNV3        :1;                                       /* Non Volatile flag bit 3 */
    byte RNV4        :1;                                       /* Non Volatile flag bit 4 */
    byte RNV5        :1;                                       /* Non Volatile flag bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable, bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable, bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_RNV2                       _FSEC.Bits.RNV2
#define FSEC_RNV3                       _FSEC.Bits.RNV3
#define FSEC_RNV4                       _FSEC.Bits.RNV4
#define FSEC_RNV5                       _FSEC.Bits.RNV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_RNV_2                      _FSEC.MergedBits.grpRNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_RNV                        FSEC_RNV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_RNV2_MASK                  4U
#define FSEC_RNV3_MASK                  8U
#define FSEC_RNV4_MASK                  16U
#define FSEC_RNV5_MASK                  32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_RNV_2_MASK                 60U
#define FSEC_RNV_2_BITNUM               2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte WRALL       :1;                                       /* Write To All Register Banks (Special mode only) */
    byte MRDS        :2;                                       /* Margin Read Setting */
    byte             :1; 
  } Bits;
} FTSTMODSTR;
extern volatile FTSTMODSTR _FTSTMOD @(REG_BASE + 0x00000102UL);
#define FTSTMOD                         _FTSTMOD.Byte
#define FTSTMOD_WRALL                   _FTSTMOD.Bits.WRALL
#define FTSTMOD_MRDS                    _FTSTMOD.Bits.MRDS

#define FTSTMOD_WRALL_MASK              16U
#define FTSTMOD_MRDS_MASK               96U
#define FTSTMOD_MRDS_BITNUM             5U


/*** FCNFG - Flash Configuration Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte BKSEL0      :1;                                       /* Register bank select */
    byte BKSEL1      :1;                                       /* Register bank select 1 (Special mode only) */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte KEYACC      :1;                                       /* Enable Security Key Writing */
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
  struct {
    byte grpBKSEL :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000103UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_BKSEL0                    _FCNFG.Bits.BKSEL0
#define FCNFG_BKSEL1                    _FCNFG.Bits.BKSEL1
#define FCNFG_KEYACC                    _FCNFG.Bits.KEYACC
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE
#define FCNFG_CBEIE                     _FCNFG.Bits.CBEIE
#define FCNFG_BKSEL                     _FCNFG.MergedBits.grpBKSEL

#define FCNFG_BKSEL0_MASK               1U
#define FCNFG_BKSEL1_MASK               2U
#define FCNFG_KEYACC_MASK               32U
#define FCNFG_CCIE_MASK                 64U
#define FCNFG_CBEIE_MASK                128U
#define FCNFG_BKSEL_MASK                3U
#define FCNFG_BKSEL_BITNUM              0U


/*** FPROT - Flash Protection Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte RNV6        :1;                                       /* Non Volatile Flag Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000104UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_RNV6                      _FPROT.Bits.RNV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_RNV6_MASK                 64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** FSTAT - Flash Status Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte FAIL        :1;                                       /* Failed Flash Operation Flag (Special mode only) */
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffers Empty Interrupt Flag */
  } Bits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000105UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_FAIL                      _FSTAT.Bits.FAIL
#define FSTAT_BLANK                     _FSTAT.Bits.BLANK
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_PVIOL                     _FSTAT.Bits.PVIOL
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_CBEIF                     _FSTAT.Bits.CBEIF

#define FSTAT_FAIL_MASK                 2U
#define FSTAT_BLANK_MASK                4U
#define FSTAT_ACCERR_MASK               16U
#define FSTAT_PVIOL_MASK                32U
#define FSTAT_CCIF_MASK                 64U
#define FSTAT_CBEIF_MASK                128U


/*** FCMD - Flash Command Buffer and Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* Flash Command, bit 0 */
    byte CMDB1       :1;                                       /* Flash Command, bit 1 */
    byte CMDB2       :1;                                       /* Flash Command, bit 2 */
    byte CMDB3       :1;                                       /* Flash Command, bit 3 */
    byte CMDB4       :1;                                       /* Flash Command, bit 4 */
    byte CMDB5       :1;                                       /* Flash Command, bit 5 */
    byte CMDB6       :1;                                       /* Flash Command, bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :7;
    byte         :1;
  } MergedBits;
} FCMDSTR;
extern volatile FCMDSTR _FCMD @(REG_BASE + 0x00000106UL);
#define FCMD                            _FCMD.Byte
#define FCMD_CMDB0                      _FCMD.Bits.CMDB0
#define FCMD_CMDB1                      _FCMD.Bits.CMDB1
#define FCMD_CMDB2                      _FCMD.Bits.CMDB2
#define FCMD_CMDB3                      _FCMD.Bits.CMDB3
#define FCMD_CMDB4                      _FCMD.Bits.CMDB4
#define FCMD_CMDB5                      _FCMD.Bits.CMDB5
#define FCMD_CMDB6                      _FCMD.Bits.CMDB6
#define FCMD_CMDB                       _FCMD.MergedBits.grpCMDB

#define FCMD_CMDB0_MASK                 1U
#define FCMD_CMDB1_MASK                 2U
#define FCMD_CMDB2_MASK                 4U
#define FCMD_CMDB3_MASK                 8U
#define FCMD_CMDB4_MASK                 16U
#define FCMD_CMDB5_MASK                 32U
#define FCMD_CMDB6_MASK                 64U
#define FCMD_CMDB_MASK                  127U
#define FCMD_CMDB_BITNUM                0U


/*** FCTL - Flash Control Register; 0x00000107 ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Non-volatile bits */
    byte NV1         :1;                                       /* Non-volatile bit 1 */
    byte NV2         :1;                                       /* Non-volatile bit 2 */
    byte NV3         :1;                                       /* Non-volatile bit 3 */
    byte NV4         :1;                                       /* Non-volatile bit 4 */
    byte NV5         :1;                                       /* Non-volatile bit 5 */
    byte NV6         :1;                                       /* Non-volatile bit 6 */
    byte NV7         :1;                                       /* Non-volatile bit 7 */
  } Bits;
} FCTLSTR;
extern volatile FCTLSTR _FCTL @(REG_BASE + 0x00000107UL);
#define FCTL                            _FCTL.Byte
#define FCTL_NV0                        _FCTL.Bits.NV0
#define FCTL_NV1                        _FCTL.Bits.NV1
#define FCTL_NV2                        _FCTL.Bits.NV2
#define FCTL_NV3                        _FCTL.Bits.NV3
#define FCTL_NV4                        _FCTL.Bits.NV4
#define FCTL_NV5                        _FCTL.Bits.NV5
#define FCTL_NV6                        _FCTL.Bits.NV6
#define FCTL_NV7                        _FCTL.Bits.NV7

#define FCTL_NV0_MASK                   1U
#define FCTL_NV1_MASK                   2U
#define FCTL_NV2_MASK                   4U
#define FCTL_NV3_MASK                   8U
#define FCTL_NV4_MASK                   16U
#define FCTL_NV5_MASK                   32U
#define FCTL_NV6_MASK                   64U
#define FCTL_NV7_MASK                   128U


/*** FADDR - Flash Address Register; 0x00000108 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FADDRHI - Flash Address High Register; 0x00000108 ***/
    union {
      byte Byte;
    } FADDRHISTR;
    #define FADDRHI                     _FADDR.Overlap_STR.FADDRHISTR.Byte
    

    /*** FADDRLO - Flash Address Low Register; 0x00000109 ***/
    union {
      byte Byte;
    } FADDRLOSTR;
    #define FADDRLO                     _FADDR.Overlap_STR.FADDRLOSTR.Byte
    
  } Overlap_STR;

  struct {
    word FADDRLO_grp :8;                                       /* Flash Address */ /*Warning: group name is duplicated with register name*/
    word FADDRHI_grp :8;                                       /* Flash Address Bit 8 */ /*Warning: group name is duplicated with register name*/
  } Bits;
} FADDRSTR;
extern volatile FADDRSTR _FADDR @(REG_BASE + 0x00000108UL);
#define FADDR                           _FADDR.Word
#define FADDR_FADDRLO                   _FADDR.Bits.FADDRLO_grp
#define FADDR_FADDRHI                   _FADDR.Bits.FADDRHI_grp

#define FADDR_FADDRLO_MASK              255U
#define FADDR_FADDRLO_BITNUM            0U
#define FADDR_FADDRHI_MASK              65280U
#define FADDR_FADDRHI_BITNUM            8U


/*** FDATA - Flash Data Register; 0x0000010A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FDATAHI - Flash Data High Register; 0x0000010A ***/
    union {
      byte Byte;
    } FDATAHISTR;
    #define FDATAHI                     _FDATA.Overlap_STR.FDATAHISTR.Byte
    

    /*** FDATALO - Flash Data Low Register; 0x0000010B ***/
    union {
      byte Byte;
    } FDATALOSTR;
    #define FDATALO                     _FDATA.Overlap_STR.FDATALOSTR.Byte
    
  } Overlap_STR;

  struct {
    word FDATALO_grp :8;                                       /* Flash Data Bits */ /*Warning: group name is duplicated with register name*/
    word FDATAHI_grp :8;                                       /* Flash Data Bit8 */ /*Warning: group name is duplicated with register name*/
  } Bits;
} FDATASTR;
extern volatile FDATASTR _FDATA @(REG_BASE + 0x0000010AUL);
#define FDATA                           _FDATA.Word
#define FDATA_FDATALO                   _FDATA.Bits.FDATALO_grp
#define FDATA_FDATAHI                   _FDATA.Bits.FDATAHI_grp

#define FDATA_FDATALO_MASK              255U
#define FDATA_FDATALO_BITNUM            0U
#define FDATA_FDATAHI_MASK              65280U
#define FDATA_FDATAHI_BITNUM            8U


/*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* EEPROM Clock Divider 0 */
    byte EDIV1       :1;                                       /* EEPROM Clock Divider 1 */
    byte EDIV2       :1;                                       /* EEPROM Clock Divider 2 */
    byte EDIV3       :1;                                       /* EEPROM Clock Divider 3 */
    byte EDIV4       :1;                                       /* EEPROM Clock Divider 4 */
    byte EDIV5       :1;                                       /* EEPROM Clock Divider 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte EDIVLD      :1;                                       /* EEPROM Clock Divider Loaded */
  } Bits;
  struct {
    byte grpEDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} ECLKDIVSTR;
extern volatile ECLKDIVSTR _ECLKDIV @(REG_BASE + 0x00000110UL);
#define ECLKDIV                         _ECLKDIV.Byte
#define ECLKDIV_EDIV0                   _ECLKDIV.Bits.EDIV0
#define ECLKDIV_EDIV1                   _ECLKDIV.Bits.EDIV1
#define ECLKDIV_EDIV2                   _ECLKDIV.Bits.EDIV2
#define ECLKDIV_EDIV3                   _ECLKDIV.Bits.EDIV3
#define ECLKDIV_EDIV4                   _ECLKDIV.Bits.EDIV4
#define ECLKDIV_EDIV5                   _ECLKDIV.Bits.EDIV5
#define ECLKDIV_PRDIV8                  _ECLKDIV.Bits.PRDIV8
#define ECLKDIV_EDIVLD                  _ECLKDIV.Bits.EDIVLD
#define ECLKDIV_EDIV                    _ECLKDIV.MergedBits.grpEDIV

#define ECLKDIV_EDIV0_MASK              1U
#define ECLKDIV_EDIV1_MASK              2U
#define ECLKDIV_EDIV2_MASK              4U
#define ECLKDIV_EDIV3_MASK              8U
#define ECLKDIV_EDIV4_MASK              16U
#define ECLKDIV_EDIV5_MASK              32U
#define ECLKDIV_PRDIV8_MASK             64U
#define ECLKDIV_EDIVLD_MASK             128U
#define ECLKDIV_EDIV_MASK               63U
#define ECLKDIV_EDIV_BITNUM             0U


/*** ECNFG - EEPROM Configuration Register; 0x00000113 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} ECNFGSTR;
extern volatile ECNFGSTR _ECNFG @(REG_BASE + 0x00000113UL);
#define ECNFG                           _ECNFG.Byte
#define ECNFG_CCIE                      _ECNFG.Bits.CCIE
#define ECNFG_CBEIE                     _ECNFG.Bits.CBEIE

#define ECNFG_CCIE_MASK                 64U
#define ECNFG_CBEIE_MASK                128U


/*** EPROT - EEPROM Protection Register; 0x00000114 ***/
typedef union {
  byte Byte;
  struct {
    byte EPS0        :1;                                       /* EEPROM Protection address size 0 */
    byte EPS1        :1;                                       /* EEPROM Protection address size 1 */
    byte EPS2        :1;                                       /* EEPROM Protection address size 2 */
    byte EPDIS       :1;                                       /* EEPROM Protection disable */
    byte RNV4        :1;                                       /* Non Volatile Flag Bits */
    byte RNV5        :1;                                       /* Non Volatile Flag Bit 5 */
    byte RNV6        :1;                                       /* Non Volatile Flag Bit 6 */
    byte EPOPEN      :1;                                       /* Opens the EEPROM block or a subsection of it for program or erase */
  } Bits;
  struct {
    byte grpEPS  :3;
    byte         :1;
    byte grpRNV_4 :3;
    byte         :1;
  } MergedBits;
} EPROTSTR;
extern volatile EPROTSTR _EPROT @(REG_BASE + 0x00000114UL);
#define EPROT                           _EPROT.Byte
#define EPROT_EPS0                      _EPROT.Bits.EPS0
#define EPROT_EPS1                      _EPROT.Bits.EPS1
#define EPROT_EPS2                      _EPROT.Bits.EPS2
#define EPROT_EPDIS                     _EPROT.Bits.EPDIS
#define EPROT_RNV4                      _EPROT.Bits.RNV4
#define EPROT_RNV5                      _EPROT.Bits.RNV5
#define EPROT_RNV6                      _EPROT.Bits.RNV6
#define EPROT_EPOPEN                    _EPROT.Bits.EPOPEN
#define EPROT_EPS                       _EPROT.MergedBits.grpEPS
#define EPROT_RNV_4                     _EPROT.MergedBits.grpRNV_4
#define EPROT_RNV                       EPROT_RNV_4

#define EPROT_EPS0_MASK                 1U
#define EPROT_EPS1_MASK                 2U
#define EPROT_EPS2_MASK                 4U
#define EPROT_EPDIS_MASK                8U
#define EPROT_RNV4_MASK                 16U
#define EPROT_RNV5_MASK                 32U
#define EPROT_RNV6_MASK                 64U
#define EPROT_EPOPEN_MASK               128U
#define EPROT_EPS_MASK                  7U
#define EPROT_EPS_BITNUM                0U
#define EPROT_RNV_4_MASK                112U
#define EPROT_RNV_4_BITNUM              4U


/*** ESTAT - EEPROM Status Register; 0x00000115 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte FAIL        :1;                                       /* Failed EEPROM Operation Flag (Special mode only) */
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffer Empty Interrupt Flag */
  } Bits;
} ESTATSTR;
extern volatile ESTATSTR _ESTAT @(REG_BASE + 0x00000115UL);
#define ESTAT                           _ESTAT.Byte
#define ESTAT_FAIL                      _ESTAT.Bits.FAIL
#define ESTAT_BLANK                     _ESTAT.Bits.BLANK
#define ESTAT_ACCERR                    _ESTAT.Bits.ACCERR
#define ESTAT_PVIOL                     _ESTAT.Bits.PVIOL
#define ESTAT_CCIF                      _ESTAT.Bits.CCIF
#define ESTAT_CBEIF                     _ESTAT.Bits.CBEIF

#define ESTAT_FAIL_MASK                 2U
#define ESTAT_BLANK_MASK                4U
#define ESTAT_ACCERR_MASK               16U
#define ESTAT_PVIOL_MASK                32U
#define ESTAT_CCIF_MASK                 64U
#define ESTAT_CBEIF_MASK                128U


/*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB        :7;                                       /* EEPROM Command Bits */
    byte             :1; 
  } Bits;
} ECMDSTR;
extern volatile ECMDSTR _ECMD @(REG_BASE + 0x00000116UL);
#define ECMD                            _ECMD.Byte
#define ECMD_CMDB                       _ECMD.Bits.CMDB

#define ECMD_CMDB_MASK                  127U
#define ECMD_CMDB_BITNUM                0U


/*** EADDR - EEPROM Addres register; 0x00000118 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** EADDRHI - EEPROM Addres High Register; 0x00000118 ***/
    union {
      byte Byte;
      struct {
        byte EABHI       :3;                                       /* Address bits */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } EADDRHISTR;
    #define EADDRHI                     _EADDR.Overlap_STR.EADDRHISTR.Byte
    #define EADDRHI_EABHI               _EADDR.Overlap_STR.EADDRHISTR.Bits.EABHI
    
    #define EADDRHI_EABHI_MASK          7U
    #define EADDRHI_EABHI_BITNUM        0U
    

    /*** EADDRLO - EEPROM Addres Low Register; 0x00000119 ***/
    union {
      byte Byte;
      struct {
        byte EABLO       :8;                                       /* Address bits */
      } Bits;
    } EADDRLOSTR;
    #define EADDRLO                     _EADDR.Overlap_STR.EADDRLOSTR.Byte
    #define EADDRLO_EABLO               _EADDR.Overlap_STR.EADDRLOSTR.Bits.EABLO
    
    #define EADDRLO_EABLO_MASK          255U
    #define EADDRLO_EABLO_BITNUM        0U
    
  } Overlap_STR;

  struct {
    word EABLO       :8;                                       /* Address bits low */
    word EABHI       :3;                                       /* Address Bit 8 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} EADDRSTR;
extern volatile EADDRSTR _EADDR @(REG_BASE + 0x00000118UL);
#define EADDR                           _EADDR.Word
#define EADDR_EABLO                     _EADDR.Bits.EABLO
#define EADDR_EABHI                     _EADDR.Bits.EABHI

#define EADDR_EABLO_MASK                255U
#define EADDR_EABLO_BITNUM              0U
#define EADDR_EABHI_MASK                1792U
#define EADDR_EABHI_BITNUM              8U


/*** EDATA - EEPROM Data Register; 0x0000011A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** EDATAHI - EEPROM Data High Register; 0x0000011A ***/
    union {
      byte Byte;
      struct {
        byte EDHI        :8;                                       /* Data bits */
      } Bits;
    } EDATAHISTR;
    #define EDATAHI                     _EDATA.Overlap_STR.EDATAHISTR.Byte
    #define EDATAHI_EDHI                _EDATA.Overlap_STR.EDATAHISTR.Bits.EDHI
    
    #define EDATAHI_EDHI_MASK           255U
    #define EDATAHI_EDHI_BITNUM         0U
    

    /*** EDATALO - EEPROM Data Low Register; 0x0000011B ***/
    union {
      byte Byte;
      struct {
        byte EDLO        :8;                                       /* Data bits */
      } Bits;
    } EDATALOSTR;
    #define EDATALO                     _EDATA.Overlap_STR.EDATALOSTR.Byte
    #define EDATALO_EDLO                _EDATA.Overlap_STR.EDATALOSTR.Bits.EDLO
    
    #define EDATALO_EDLO_MASK           255U
    #define EDATALO_EDLO_BITNUM         0U
    
  } Overlap_STR;

  struct {
    word EDLO        :8;                                       /* Data bits low */
    word EDHI        :8;                                       /* Data bits high */
  } Bits;
} EDATASTR;
extern volatile EDATASTR _EDATA @(REG_BASE + 0x0000011AUL);
#define EDATA                           _EDATA.Word
#define EDATA_EDLO                      _EDATA.Bits.EDLO
#define EDATA_EDHI                      _EDATA.Bits.EDHI

#define EDATA_EDLO_MASK                 255U
#define EDATA_EDLO_BITNUM               0U
#define EDATA_EDHI_MASK                 65280U
#define EDATA_EDHI_BITNUM               8U


/*** RAMWPC - RAM Write Protection Control Register; 0x0000011C ***/
typedef union {
  byte Byte;
  struct {
    byte AVIF        :1;                                       /* CPUAccessViolationInterruptFlag */
    byte AVIE        :1;                                       /* CPU Access Violation Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RWPE        :1;                                       /* RAM Write Protection Enable */
  } Bits;
} RAMWPCSTR;
extern volatile RAMWPCSTR _RAMWPC @(REG_BASE + 0x0000011CUL);
#define RAMWPC                          _RAMWPC.Byte
#define RAMWPC_AVIF                     _RAMWPC.Bits.AVIF
#define RAMWPC_AVIE                     _RAMWPC.Bits.AVIE
#define RAMWPC_RWPE                     _RAMWPC.Bits.RWPE

#define RAMWPC_AVIF_MASK                1U
#define RAMWPC_AVIE_MASK                2U
#define RAMWPC_RWPE_MASK                128U


/*** RAMXGU - RAM XGATE Upper Boundary Register; 0x0000011D ***/
typedef union {
  byte Byte;
  struct {
    byte XGU0        :1;                                       /* XGATE Region Upper Boundary Bit 0 */
    byte XGU1        :1;                                       /* XGATE Region Upper Boundary Bit 1 */
    byte XGU2        :1;                                       /* XGATE Region Upper Boundary Bit 2 */
    byte XGU3        :1;                                       /* XGATE Region Upper Boundary Bit 3 */
    byte XGU4        :1;                                       /* XGATE Region Upper Boundary Bit 4 */
    byte XGU5        :1;                                       /* XGATE Region Upper Boundary Bit 5 */
    byte XGU6        :1;                                       /* XGATE Region Upper Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpXGU  :7;
    byte         :1;
  } MergedBits;
} RAMXGUSTR;
extern volatile RAMXGUSTR _RAMXGU @(REG_BASE + 0x0000011DUL);
#define RAMXGU                          _RAMXGU.Byte
#define RAMXGU_XGU0                     _RAMXGU.Bits.XGU0
#define RAMXGU_XGU1                     _RAMXGU.Bits.XGU1
#define RAMXGU_XGU2                     _RAMXGU.Bits.XGU2
#define RAMXGU_XGU3                     _RAMXGU.Bits.XGU3
#define RAMXGU_XGU4                     _RAMXGU.Bits.XGU4
#define RAMXGU_XGU5                     _RAMXGU.Bits.XGU5
#define RAMXGU_XGU6                     _RAMXGU.Bits.XGU6
#define RAMXGU_XGU                      _RAMXGU.MergedBits.grpXGU

#define RAMXGU_XGU0_MASK                1U
#define RAMXGU_XGU1_MASK                2U
#define RAMXGU_XGU2_MASK                4U
#define RAMXGU_XGU3_MASK                8U
#define RAMXGU_XGU4_MASK                16U
#define RAMXGU_XGU5_MASK                32U
#define RAMXGU_XGU6_MASK                64U
#define RAMXGU_XGU_MASK                 127U
#define RAMXGU_XGU_BITNUM               0U


/*** RAMSHL - RAM Shared Region Lower Boundary Register; 0x0000011E ***/
typedef union {
  byte Byte;
  struct {
    byte SHL0        :1;                                       /* RAM Shared Region Lower Boundary Bit 0 */
    byte SHL1        :1;                                       /* RAM Shared Region Lower Boundary Bit 1 */
    byte SHL2        :1;                                       /* RAM Shared Region Lower Boundary Bit 2 */
    byte SHL3        :1;                                       /* RAM Shared Region Lower Boundary Bit 3 */
    byte SHL4        :1;                                       /* RAM Shared Region Lower Boundary Bit 4 */
    byte SHL5        :1;                                       /* RAM Shared Region Lower Boundary Bit 5 */
    byte SHL6        :1;                                       /* RAM Shared Region Lower Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSHL  :7;
    byte         :1;
  } MergedBits;
} RAMSHLSTR;
extern volatile RAMSHLSTR _RAMSHL @(REG_BASE + 0x0000011EUL);
#define RAMSHL                          _RAMSHL.Byte
#define RAMSHL_SHL0                     _RAMSHL.Bits.SHL0
#define RAMSHL_SHL1                     _RAMSHL.Bits.SHL1
#define RAMSHL_SHL2                     _RAMSHL.Bits.SHL2
#define RAMSHL_SHL3                     _RAMSHL.Bits.SHL3
#define RAMSHL_SHL4                     _RAMSHL.Bits.SHL4
#define RAMSHL_SHL5                     _RAMSHL.Bits.SHL5
#define RAMSHL_SHL6                     _RAMSHL.Bits.SHL6
#define RAMSHL_SHL                      _RAMSHL.MergedBits.grpSHL

#define RAMSHL_SHL0_MASK                1U
#define RAMSHL_SHL1_MASK                2U
#define RAMSHL_SHL2_MASK                4U
#define RAMSHL_SHL3_MASK                8U
#define RAMSHL_SHL4_MASK                16U
#define RAMSHL_SHL5_MASK                32U
#define RAMSHL_SHL6_MASK                64U
#define RAMSHL_SHL_MASK                 127U
#define RAMSHL_SHL_BITNUM               0U


/*** RAMSHU - RAM Shared Region Upper Boundary Register; 0x0000011F ***/
typedef union {
  byte Byte;
  struct {
    byte SHU0        :1;                                       /* RAM Shared Region Upper Boundary Bit 0 */
    byte SHU1        :1;                                       /* RAM Shared Region Upper Boundary Bit 1 */
    byte SHU2        :1;                                       /* RAM Shared Region Upper Boundary Bit 2 */
    byte SHU3        :1;                                       /* RAM Shared Region Upper Boundary Bit 3 */
    byte SHU4        :1;                                       /* RAM Shared Region Upper Boundary Bit 4 */
    byte SHU5        :1;                                       /* RAM Shared Region Upper Boundary Bit 5 */
    byte SHU6        :1;                                       /* RAM Shared Region Upper Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSHU  :7;
    byte         :1;
  } MergedBits;
} RAMSHUSTR;
extern volatile RAMSHUSTR _RAMSHU @(REG_BASE + 0x0000011FUL);
#define RAMSHU                          _RAMSHU.Byte
#define RAMSHU_SHU0                     _RAMSHU.Bits.SHU0
#define RAMSHU_SHU1                     _RAMSHU.Bits.SHU1
#define RAMSHU_SHU2                     _RAMSHU.Bits.SHU2
#define RAMSHU_SHU3                     _RAMSHU.Bits.SHU3
#define RAMSHU_SHU4                     _RAMSHU.Bits.SHU4
#define RAMSHU_SHU5                     _RAMSHU.Bits.SHU5
#define RAMSHU_SHU6                     _RAMSHU.Bits.SHU6
#define RAMSHU_SHU                      _RAMSHU.MergedBits.grpSHU

#define RAMSHU_SHU0_MASK                1U
#define RAMSHU_SHU1_MASK                2U
#define RAMSHU_SHU2_MASK                4U
#define RAMSHU_SHU3_MASK                8U
#define RAMSHU_SHU4_MASK                16U
#define RAMSHU_SHU5_MASK                32U
#define RAMSHU_SHU6_MASK                64U
#define RAMSHU_SHU_MASK                 127U
#define RAMSHU_SHU_BITNUM               0U


/*** LCDCR0 - LCD Control Register 0; 0x00000120 ***/
typedef union {
  byte Byte;
  struct {
    byte DUTY0       :1;                                       /* LCD Duty Select Bit 0 */
    byte DUTY1       :1;                                       /* LCD Duty Select Bit 1 */
    byte BIAS        :1;                                       /* BIAS Voltage Level Select */
    byte LCLK0       :1;                                       /* LCD Clock Prescaler Bit 0 */
    byte LCLK1       :1;                                       /* LCD Clock Prescaler Bit 1 */
    byte LCLK2       :1;                                       /* LCD Clock Prescaler Bit 2 */
    byte             :1; 
    byte LCDEN       :1;                                       /* LCD32F4BV1 Driver System Enable */
  } Bits;
  struct {
    byte grpDUTY :2;
    byte         :1;
    byte grpLCLK :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDCR0STR;
extern volatile LCDCR0STR _LCDCR0 @(REG_BASE + 0x00000120UL);
#define LCDCR0                          _LCDCR0.Byte
#define LCDCR0_DUTY0                    _LCDCR0.Bits.DUTY0
#define LCDCR0_DUTY1                    _LCDCR0.Bits.DUTY1
#define LCDCR0_BIAS                     _LCDCR0.Bits.BIAS
#define LCDCR0_LCLK0                    _LCDCR0.Bits.LCLK0
#define LCDCR0_LCLK1                    _LCDCR0.Bits.LCLK1
#define LCDCR0_LCLK2                    _LCDCR0.Bits.LCLK2
#define LCDCR0_LCDEN                    _LCDCR0.Bits.LCDEN
/* LCDCR_ARR: Access 2 LCDCRx registers in an array */
#define LCDCR_ARR                       ((volatile byte *) &LCDCR0)
#define LCDCR0_DUTY                     _LCDCR0.MergedBits.grpDUTY
#define LCDCR0_LCLK                     _LCDCR0.MergedBits.grpLCLK

#define LCDCR0_DUTY0_MASK               1U
#define LCDCR0_DUTY1_MASK               2U
#define LCDCR0_BIAS_MASK                4U
#define LCDCR0_LCLK0_MASK               8U
#define LCDCR0_LCLK1_MASK               16U
#define LCDCR0_LCLK2_MASK               32U
#define LCDCR0_LCDEN_MASK               128U
#define LCDCR0_DUTY_MASK                3U
#define LCDCR0_DUTY_BITNUM              0U
#define LCDCR0_LCLK_MASK                56U
#define LCDCR0_LCLK_BITNUM              3U


/*** LCDCR1 - LCD Control Register 1; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte LCDRPSTP    :1;                                       /* LCD Run in Pseudo Stop Mode */
    byte LCDSWAI     :1;                                       /* LCD Stop in Wait Mode */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} LCDCR1STR;
extern volatile LCDCR1STR _LCDCR1 @(REG_BASE + 0x00000121UL);
#define LCDCR1                          _LCDCR1.Byte
#define LCDCR1_LCDRPSTP                 _LCDCR1.Bits.LCDRPSTP
#define LCDCR1_LCDSWAI                  _LCDCR1.Bits.LCDSWAI

#define LCDCR1_LCDRPSTP_MASK            1U
#define LCDCR1_LCDSWAI_MASK             2U


/*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000122 ***/
typedef union {
  byte Byte;
  struct {
    byte FP0EN       :1;                                       /* Frontplane Output Enable Bit 0 */
    byte FP1EN       :1;                                       /* Frontplane Output Enable Bit 1 */
    byte FP2EN       :1;                                       /* Frontplane Output Enable Bit 2 */
    byte FP3EN       :1;                                       /* Frontplane Output Enable Bit 3 */
    byte FP4EN       :1;                                       /* Frontplane Output Enable Bit 4 */
    byte FP5EN       :1;                                       /* Frontplane Output Enable Bit 5 */
    byte FP6EN       :1;                                       /* Frontplane Output Enable Bit 6 */
    byte FP7EN       :1;                                       /* Frontplane Output Enable Bit 7 */
  } Bits;
} FPENR0STR;
extern volatile FPENR0STR _FPENR0 @(REG_BASE + 0x00000122UL);
#define FPENR0                          _FPENR0.Byte
#define FPENR0_FP0EN                    _FPENR0.Bits.FP0EN
#define FPENR0_FP1EN                    _FPENR0.Bits.FP1EN
#define FPENR0_FP2EN                    _FPENR0.Bits.FP2EN
#define FPENR0_FP3EN                    _FPENR0.Bits.FP3EN
#define FPENR0_FP4EN                    _FPENR0.Bits.FP4EN
#define FPENR0_FP5EN                    _FPENR0.Bits.FP5EN
#define FPENR0_FP6EN                    _FPENR0.Bits.FP6EN
#define FPENR0_FP7EN                    _FPENR0.Bits.FP7EN
/* FPENR_ARR: Access 4 FPENRx registers in an array */
#define FPENR_ARR                       ((volatile byte *) &FPENR0)

#define FPENR0_FP0EN_MASK               1U
#define FPENR0_FP1EN_MASK               2U
#define FPENR0_FP2EN_MASK               4U
#define FPENR0_FP3EN_MASK               8U
#define FPENR0_FP4EN_MASK               16U
#define FPENR0_FP5EN_MASK               32U
#define FPENR0_FP6EN_MASK               64U
#define FPENR0_FP7EN_MASK               128U


/*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000123 ***/
typedef union {
  byte Byte;
  struct {
    byte FP8EN       :1;                                       /* Frontplane Output Enable Bit 8 */
    byte FP9EN       :1;                                       /* Frontplane Output Enable Bit 9 */
    byte FP10EN      :1;                                       /* Frontplane Output Enable Bit 10 */
    byte FP11EN      :1;                                       /* Frontplane Output Enable Bit 11 */
    byte FP12EN      :1;                                       /* Frontplane Output Enable Bit 12 */
    byte FP13EN      :1;                                       /* Frontplane Output Enable Bit 13 */
    byte FP14EN      :1;                                       /* Frontplane Output Enable Bit 14 */
    byte FP15EN      :1;                                       /* Frontplane Output Enable Bit 15 */
  } Bits;
} FPENR1STR;
extern volatile FPENR1STR _FPENR1 @(REG_BASE + 0x00000123UL);
#define FPENR1                          _FPENR1.Byte
#define FPENR1_FP8EN                    _FPENR1.Bits.FP8EN
#define FPENR1_FP9EN                    _FPENR1.Bits.FP9EN
#define FPENR1_FP10EN                   _FPENR1.Bits.FP10EN
#define FPENR1_FP11EN                   _FPENR1.Bits.FP11EN
#define FPENR1_FP12EN                   _FPENR1.Bits.FP12EN
#define FPENR1_FP13EN                   _FPENR1.Bits.FP13EN
#define FPENR1_FP14EN                   _FPENR1.Bits.FP14EN
#define FPENR1_FP15EN                   _FPENR1.Bits.FP15EN

#define FPENR1_FP8EN_MASK               1U
#define FPENR1_FP9EN_MASK               2U
#define FPENR1_FP10EN_MASK              4U
#define FPENR1_FP11EN_MASK              8U
#define FPENR1_FP12EN_MASK              16U
#define FPENR1_FP13EN_MASK              32U
#define FPENR1_FP14EN_MASK              64U
#define FPENR1_FP15EN_MASK              128U


/*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000124 ***/
typedef union {
  byte Byte;
  struct {
    byte FP16EN      :1;                                       /* Frontplane Output Enable Bit 16 */
    byte FP17EN      :1;                                       /* Frontplane Output Enable Bit 17 */
    byte FP18EN      :1;                                       /* Frontplane Output Enable Bit 18 */
    byte FP19EN      :1;                                       /* Frontplane Output Enable Bit 19 */
    byte FP20EN      :1;                                       /* Frontplane Output Enable Bit 20 */
    byte FP21EN      :1;                                       /* Frontplane Output Enable Bit 21 */
    byte FP22EN      :1;                                       /* Frontplane Output Enable Bit 22 */
    byte FP23EN      :1;                                       /* Frontplane Output Enable Bit 23 */
  } Bits;
} FPENR2STR;
extern volatile FPENR2STR _FPENR2 @(REG_BASE + 0x00000124UL);
#define FPENR2                          _FPENR2.Byte
#define FPENR2_FP16EN                   _FPENR2.Bits.FP16EN
#define FPENR2_FP17EN                   _FPENR2.Bits.FP17EN
#define FPENR2_FP18EN                   _FPENR2.Bits.FP18EN
#define FPENR2_FP19EN                   _FPENR2.Bits.FP19EN
#define FPENR2_FP20EN                   _FPENR2.Bits.FP20EN
#define FPENR2_FP21EN                   _FPENR2.Bits.FP21EN
#define FPENR2_FP22EN                   _FPENR2.Bits.FP22EN
#define FPENR2_FP23EN                   _FPENR2.Bits.FP23EN

#define FPENR2_FP16EN_MASK              1U
#define FPENR2_FP17EN_MASK              2U
#define FPENR2_FP18EN_MASK              4U
#define FPENR2_FP19EN_MASK              8U
#define FPENR2_FP20EN_MASK              16U
#define FPENR2_FP21EN_MASK              32U
#define FPENR2_FP22EN_MASK              64U
#define FPENR2_FP23EN_MASK              128U


/*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000125 ***/
typedef union {
  byte Byte;
  struct {
    byte FP24EN      :1;                                       /* Frontplane Output Enable Bit 24 */
    byte FP25EN      :1;                                       /* Frontplane Output Enable Bit 25 */
    byte FP26EN      :1;                                       /* Frontplane Output Enable Bit 26 */
    byte FP27EN      :1;                                       /* Frontplane Output Enable Bit 27 */
    byte FP28EN      :1;                                       /* Frontplane Output Enable Bit 28 */
    byte FP29EN      :1;                                       /* Frontplane Output Enable Bit 29 */
    byte FP30EN      :1;                                       /* Frontplane Output Enable Bit 30 */
    byte FP31EN      :1;                                       /* Frontplane Output Enable Bit 31 */
  } Bits;
} FPENR3STR;
extern volatile FPENR3STR _FPENR3 @(REG_BASE + 0x00000125UL);
#define FPENR3                          _FPENR3.Byte
#define FPENR3_FP24EN                   _FPENR3.Bits.FP24EN
#define FPENR3_FP25EN                   _FPENR3.Bits.FP25EN
#define FPENR3_FP26EN                   _FPENR3.Bits.FP26EN
#define FPENR3_FP27EN                   _FPENR3.Bits.FP27EN
#define FPENR3_FP28EN                   _FPENR3.Bits.FP28EN
#define FPENR3_FP29EN                   _FPENR3.Bits.FP29EN
#define FPENR3_FP30EN                   _FPENR3.Bits.FP30EN
#define FPENR3_FP31EN                   _FPENR3.Bits.FP31EN

#define FPENR3_FP24EN_MASK              1U
#define FPENR3_FP25EN_MASK              2U
#define FPENR3_FP26EN_MASK              4U
#define FPENR3_FP27EN_MASK              8U
#define FPENR3_FP28EN_MASK              16U
#define FPENR3_FP29EN_MASK              32U
#define FPENR3_FP30EN_MASK              64U
#define FPENR3_FP31EN_MASK              128U


/*** LCDRAM0 - LCD RAM 0; 0x00000128 ***/
typedef union {
  byte Byte;
  struct {
    byte FP0BP0      :1;                                       /* LCD Segment FP0, BP0 ON */
    byte FP0BP1      :1;                                       /* LCD Segment FP0, BP1 ON */
    byte FP0BP2      :1;                                       /* LCD Segment FP0, BP2 ON */
    byte FP0BP3      :1;                                       /* LCD Segment FP0, BP3 ON */
    byte FP1BP0      :1;                                       /* LCD Segment FP1, BP0 ON */
    byte FP1BP1      :1;                                       /* LCD Segment FP1, BP1 ON */
    byte FP1BP2      :1;                                       /* LCD Segment FP1, BP2 ON */
    byte FP1BP3      :1;                                       /* LCD Segment FP1, BP3 ON */
  } Bits;
  struct {
    byte grpFP0BP :4;
    byte grpFP1BP :4;
  } MergedBits;
} LCDRAM0STR;
extern volatile LCDRAM0STR _LCDRAM0 @(REG_BASE + 0x00000128UL);
#define LCDRAM0                         _LCDRAM0.Byte
#define LCDRAM0_FP0BP0                  _LCDRAM0.Bits.FP0BP0
#define LCDRAM0_FP0BP1                  _LCDRAM0.Bits.FP0BP1
#define LCDRAM0_FP0BP2                  _LCDRAM0.Bits.FP0BP2
#define LCDRAM0_FP0BP3                  _LCDRAM0.Bits.FP0BP3
#define LCDRAM0_FP1BP0                  _LCDRAM0.Bits.FP1BP0
#define LCDRAM0_FP1BP1                  _LCDRAM0.Bits.FP1BP1
#define LCDRAM0_FP1BP2                  _LCDRAM0.Bits.FP1BP2
#define LCDRAM0_FP1BP3                  _LCDRAM0.Bits.FP1BP3
/* LCDRAM_ARR: Access 16 LCDRAMx registers in an array */
#define LCDRAM_ARR                      ((volatile byte *) &LCDRAM0)
#define LCDRAM0_FP0BP                   _LCDRAM0.MergedBits.grpFP0BP
#define LCDRAM0_FP1BP                   _LCDRAM0.MergedBits.grpFP1BP

#define LCDRAM0_FP0BP0_MASK             1U
#define LCDRAM0_FP0BP1_MASK             2U
#define LCDRAM0_FP0BP2_MASK             4U
#define LCDRAM0_FP0BP3_MASK             8U
#define LCDRAM0_FP1BP0_MASK             16U
#define LCDRAM0_FP1BP1_MASK             32U
#define LCDRAM0_FP1BP2_MASK             64U
#define LCDRAM0_FP1BP3_MASK             128U
#define LCDRAM0_FP0BP_MASK              15U
#define LCDRAM0_FP0BP_BITNUM            0U
#define LCDRAM0_FP1BP_MASK              240U
#define LCDRAM0_FP1BP_BITNUM            4U


/*** LCDRAM1 - LCD RAM 1; 0x00000129 ***/
typedef union {
  byte Byte;
  struct {
    byte FP2BP0      :1;                                       /* LCD Segment FP2, BP0 ON */
    byte FP2BP1      :1;                                       /* LCD Segment FP2, BP1 ON */
    byte FP2BP2      :1;                                       /* LCD Segment FP2, BP2 ON */
    byte FP2BP3      :1;                                       /* LCD Segment FP2, BP3 ON */
    byte FP3BP0      :1;                                       /* LCD Segment FP3, BP0 ON */
    byte FP3BP1      :1;                                       /* LCD Segment FP3, BP1 ON */
    byte FP3BP2      :1;                                       /* LCD Segment FP3, BP2 ON */
    byte FP3BP3      :1;                                       /* LCD Segment FP3, BP3 ON */
  } Bits;
  struct {
    byte grpFP2BP :4;
    byte grpFP3BP :4;
  } MergedBits;
} LCDRAM1STR;
extern volatile LCDRAM1STR _LCDRAM1 @(REG_BASE + 0x00000129UL);
#define LCDRAM1                         _LCDRAM1.Byte
#define LCDRAM1_FP2BP0                  _LCDRAM1.Bits.FP2BP0
#define LCDRAM1_FP2BP1                  _LCDRAM1.Bits.FP2BP1
#define LCDRAM1_FP2BP2                  _LCDRAM1.Bits.FP2BP2
#define LCDRAM1_FP2BP3                  _LCDRAM1.Bits.FP2BP3
#define LCDRAM1_FP3BP0                  _LCDRAM1.Bits.FP3BP0
#define LCDRAM1_FP3BP1                  _LCDRAM1.Bits.FP3BP1
#define LCDRAM1_FP3BP2                  _LCDRAM1.Bits.FP3BP2
#define LCDRAM1_FP3BP3                  _LCDRAM1.Bits.FP3BP3
#define LCDRAM1_FP2BP                   _LCDRAM1.MergedBits.grpFP2BP
#define LCDRAM1_FP3BP                   _LCDRAM1.MergedBits.grpFP3BP

#define LCDRAM1_FP2BP0_MASK             1U
#define LCDRAM1_FP2BP1_MASK             2U
#define LCDRAM1_FP2BP2_MASK             4U
#define LCDRAM1_FP2BP3_MASK             8U
#define LCDRAM1_FP3BP0_MASK             16U
#define LCDRAM1_FP3BP1_MASK             32U
#define LCDRAM1_FP3BP2_MASK             64U
#define LCDRAM1_FP3BP3_MASK             128U
#define LCDRAM1_FP2BP_MASK              15U
#define LCDRAM1_FP2BP_BITNUM            0U
#define LCDRAM1_FP3BP_MASK              240U
#define LCDRAM1_FP3BP_BITNUM            4U


/*** LCDRAM2 - LCD RAM 2; 0x0000012A ***/
typedef union {
  byte Byte;
  struct {
    byte FP4BP0      :1;                                       /* LCD Segment FP4, BP0 ON */
    byte FP4BP1      :1;                                       /* LCD Segment FP4, BP1 ON */
    byte FP4BP2      :1;                                       /* LCD Segment FP4, BP2 ON */
    byte FP4BP3      :1;                                       /* LCD Segment FP4, BP3 ON */
    byte FP5BP0      :1;                                       /* LCD Segment FP5, BP0 ON */
    byte FP5BP1      :1;                                       /* LCD Segment FP5, BP1 ON */
    byte FP5BP2      :1;                                       /* LCD Segment FP5, BP2 ON */
    byte FP5BP3      :1;                                       /* LCD Segment FP5, BP3 ON */
  } Bits;
  struct {
    byte grpFP4BP :4;
    byte grpFP5BP :4;
  } MergedBits;
} LCDRAM2STR;
extern volatile LCDRAM2STR _LCDRAM2 @(REG_BASE + 0x0000012AUL);
#define LCDRAM2                         _LCDRAM2.Byte
#define LCDRAM2_FP4BP0                  _LCDRAM2.Bits.FP4BP0
#define LCDRAM2_FP4BP1                  _LCDRAM2.Bits.FP4BP1
#define LCDRAM2_FP4BP2                  _LCDRAM2.Bits.FP4BP2
#define LCDRAM2_FP4BP3                  _LCDRAM2.Bits.FP4BP3
#define LCDRAM2_FP5BP0                  _LCDRAM2.Bits.FP5BP0
#define LCDRAM2_FP5BP1                  _LCDRAM2.Bits.FP5BP1
#define LCDRAM2_FP5BP2                  _LCDRAM2.Bits.FP5BP2
#define LCDRAM2_FP5BP3                  _LCDRAM2.Bits.FP5BP3
#define LCDRAM2_FP4BP                   _LCDRAM2.MergedBits.grpFP4BP
#define LCDRAM2_FP5BP                   _LCDRAM2.MergedBits.grpFP5BP

#define LCDRAM2_FP4BP0_MASK             1U
#define LCDRAM2_FP4BP1_MASK             2U
#define LCDRAM2_FP4BP2_MASK             4U
#define LCDRAM2_FP4BP3_MASK             8U
#define LCDRAM2_FP5BP0_MASK             16U
#define LCDRAM2_FP5BP1_MASK             32U
#define LCDRAM2_FP5BP2_MASK             64U
#define LCDRAM2_FP5BP3_MASK             128U
#define LCDRAM2_FP4BP_MASK              15U
#define LCDRAM2_FP4BP_BITNUM            0U
#define LCDRAM2_FP5BP_MASK              240U
#define LCDRAM2_FP5BP_BITNUM            4U


/*** LCDRAM3 - LCD RAM 3; 0x0000012B ***/
typedef union {
  byte Byte;
  struct {
    byte FP6BP0      :1;                                       /* LCD Segment FP6, BP0 ON */
    byte FP6BP1      :1;                                       /* LCD Segment FP6, BP1 ON */
    byte FP6BP2      :1;                                       /* LCD Segment FP6, BP2 ON */
    byte FP6BP3      :1;                                       /* LCD Segment FP6, BP3 ON */
    byte FP7BP0      :1;                                       /* LCD Segment FP7, BP0 ON */
    byte FP7BP1      :1;                                       /* LCD Segment FP7, BP1 ON */
    byte FP7BP2      :1;                                       /* LCD Segment FP7, BP2 ON */
    byte FP7BP3      :1;                                       /* LCD Segment FP7, BP3 ON */
  } Bits;
  struct {
    byte grpFP6BP :4;
    byte grpFP7BP :4;
  } MergedBits;
} LCDRAM3STR;
extern volatile LCDRAM3STR _LCDRAM3 @(REG_BASE + 0x0000012BUL);
#define LCDRAM3                         _LCDRAM3.Byte
#define LCDRAM3_FP6BP0                  _LCDRAM3.Bits.FP6BP0
#define LCDRAM3_FP6BP1                  _LCDRAM3.Bits.FP6BP1
#define LCDRAM3_FP6BP2                  _LCDRAM3.Bits.FP6BP2
#define LCDRAM3_FP6BP3                  _LCDRAM3.Bits.FP6BP3
#define LCDRAM3_FP7BP0                  _LCDRAM3.Bits.FP7BP0
#define LCDRAM3_FP7BP1                  _LCDRAM3.Bits.FP7BP1
#define LCDRAM3_FP7BP2                  _LCDRAM3.Bits.FP7BP2
#define LCDRAM3_FP7BP3                  _LCDRAM3.Bits.FP7BP3
#define LCDRAM3_FP6BP                   _LCDRAM3.MergedBits.grpFP6BP
#define LCDRAM3_FP7BP                   _LCDRAM3.MergedBits.grpFP7BP

#define LCDRAM3_FP6BP0_MASK             1U
#define LCDRAM3_FP6BP1_MASK             2U
#define LCDRAM3_FP6BP2_MASK             4U
#define LCDRAM3_FP6BP3_MASK             8U
#define LCDRAM3_FP7BP0_MASK             16U
#define LCDRAM3_FP7BP1_MASK             32U
#define LCDRAM3_FP7BP2_MASK             64U
#define LCDRAM3_FP7BP3_MASK             128U
#define LCDRAM3_FP6BP_MASK              15U
#define LCDRAM3_FP6BP_BITNUM            0U
#define LCDRAM3_FP7BP_MASK              240U
#define LCDRAM3_FP7BP_BITNUM            4U


/*** LCDRAM4 - LCD RAM 4; 0x0000012C ***/
typedef union {
  byte Byte;
  struct {
    byte FP8BP0      :1;                                       /* LCD Segment FP8, BP0 ON */
    byte FP8BP1      :1;                                       /* LCD Segment FP8, BP1 ON */
    byte FP8BP2      :1;                                       /* LCD Segment FP8, BP2 ON */
    byte FP8BP3      :1;                                       /* LCD Segment FP8, BP3 ON */
    byte FP9BP0      :1;                                       /* LCD Segment FP9, BP0 ON */
    byte FP9BP1      :1;                                       /* LCD Segment FP9, BP1 ON */
    byte FP9BP2      :1;                                       /* LCD Segment FP9, BP2 ON */
    byte FP9BP3      :1;                                       /* LCD Segment FP9, BP3 ON */
  } Bits;
  struct {
    byte grpFP8BP :4;
    byte grpFP9BP :4;
  } MergedBits;
} LCDRAM4STR;
extern volatile LCDRAM4STR _LCDRAM4 @(REG_BASE + 0x0000012CUL);
#define LCDRAM4                         _LCDRAM4.Byte
#define LCDRAM4_FP8BP0                  _LCDRAM4.Bits.FP8BP0
#define LCDRAM4_FP8BP1                  _LCDRAM4.Bits.FP8BP1
#define LCDRAM4_FP8BP2                  _LCDRAM4.Bits.FP8BP2
#define LCDRAM4_FP8BP3                  _LCDRAM4.Bits.FP8BP3
#define LCDRAM4_FP9BP0                  _LCDRAM4.Bits.FP9BP0
#define LCDRAM4_FP9BP1                  _LCDRAM4.Bits.FP9BP1
#define LCDRAM4_FP9BP2                  _LCDRAM4.Bits.FP9BP2
#define LCDRAM4_FP9BP3                  _LCDRAM4.Bits.FP9BP3
#define LCDRAM4_FP8BP                   _LCDRAM4.MergedBits.grpFP8BP
#define LCDRAM4_FP9BP                   _LCDRAM4.MergedBits.grpFP9BP

#define LCDRAM4_FP8BP0_MASK             1U
#define LCDRAM4_FP8BP1_MASK             2U
#define LCDRAM4_FP8BP2_MASK             4U
#define LCDRAM4_FP8BP3_MASK             8U
#define LCDRAM4_FP9BP0_MASK             16U
#define LCDRAM4_FP9BP1_MASK             32U
#define LCDRAM4_FP9BP2_MASK             64U
#define LCDRAM4_FP9BP3_MASK             128U
#define LCDRAM4_FP8BP_MASK              15U
#define LCDRAM4_FP8BP_BITNUM            0U
#define LCDRAM4_FP9BP_MASK              240U
#define LCDRAM4_FP9BP_BITNUM            4U


/*** LCDRAM5 - LCD RAM 5; 0x0000012D ***/
typedef union {
  byte Byte;
  struct {
    byte FP10BP0     :1;                                       /* LCD Segment FP10, BP0 ON */
    byte FP10BP1     :1;                                       /* LCD Segment FP10, BP1 ON */
    byte FP10BP2     :1;                                       /* LCD Segment FP10, BP2 ON */
    byte FP10BP3     :1;                                       /* LCD Segment FP10, BP3 ON */
    byte FP11BP0     :1;                                       /* LCD Segment FP11, BP0 ON */
    byte FP11BP1     :1;                                       /* LCD Segment FP11, BP1 ON */
    byte FP11BP2     :1;                                       /* LCD Segment FP11, BP2 ON */
    byte FP11BP3     :1;                                       /* LCD Segment FP11, BP3 ON */
  } Bits;
  struct {
    byte grpFP10BP :4;
    byte grpFP11BP :4;
  } MergedBits;
} LCDRAM5STR;
extern volatile LCDRAM5STR _LCDRAM5 @(REG_BASE + 0x0000012DUL);
#define LCDRAM5                         _LCDRAM5.Byte
#define LCDRAM5_FP10BP0                 _LCDRAM5.Bits.FP10BP0
#define LCDRAM5_FP10BP1                 _LCDRAM5.Bits.FP10BP1
#define LCDRAM5_FP10BP2                 _LCDRAM5.Bits.FP10BP2
#define LCDRAM5_FP10BP3                 _LCDRAM5.Bits.FP10BP3
#define LCDRAM5_FP11BP0                 _LCDRAM5.Bits.FP11BP0
#define LCDRAM5_FP11BP1                 _LCDRAM5.Bits.FP11BP1
#define LCDRAM5_FP11BP2                 _LCDRAM5.Bits.FP11BP2
#define LCDRAM5_FP11BP3                 _LCDRAM5.Bits.FP11BP3
#define LCDRAM5_FP10BP                  _LCDRAM5.MergedBits.grpFP10BP
#define LCDRAM5_FP11BP                  _LCDRAM5.MergedBits.grpFP11BP

#define LCDRAM5_FP10BP0_MASK            1U
#define LCDRAM5_FP10BP1_MASK            2U
#define LCDRAM5_FP10BP2_MASK            4U
#define LCDRAM5_FP10BP3_MASK            8U
#define LCDRAM5_FP11BP0_MASK            16U
#define LCDRAM5_FP11BP1_MASK            32U
#define LCDRAM5_FP11BP2_MASK            64U
#define LCDRAM5_FP11BP3_MASK            128U
#define LCDRAM5_FP10BP_MASK             15U
#define LCDRAM5_FP10BP_BITNUM           0U
#define LCDRAM5_FP11BP_MASK             240U
#define LCDRAM5_FP11BP_BITNUM           4U


/*** LCDRAM6 - LCD RAM 6; 0x0000012E ***/
typedef union {
  byte Byte;
  struct {
    byte FP12BP0     :1;                                       /* LCD Segment FP12, BP0 ON */
    byte FP12BP1     :1;                                       /* LCD Segment FP12, BP1 ON */
    byte FP12BP2     :1;                                       /* LCD Segment FP12, BP2 ON */
    byte FP12BP3     :1;                                       /* LCD Segment FP12, BP3 ON */
    byte FP13BP0     :1;                                       /* LCD Segment FP13, BP0 ON */
    byte FP13BP1     :1;                                       /* LCD Segment FP13, BP1 ON */
    byte FP13BP2     :1;                                       /* LCD Segment FP13, BP2 ON */
    byte FP13BP3     :1;                                       /* LCD Segment FP13, BP3 ON */
  } Bits;
  struct {
    byte grpFP12BP :4;
    byte grpFP13BP :4;
  } MergedBits;
} LCDRAM6STR;
extern volatile LCDRAM6STR _LCDRAM6 @(REG_BASE + 0x0000012EUL);
#define LCDRAM6                         _LCDRAM6.Byte
#define LCDRAM6_FP12BP0                 _LCDRAM6.Bits.FP12BP0
#define LCDRAM6_FP12BP1                 _LCDRAM6.Bits.FP12BP1
#define LCDRAM6_FP12BP2                 _LCDRAM6.Bits.FP12BP2
#define LCDRAM6_FP12BP3                 _LCDRAM6.Bits.FP12BP3
#define LCDRAM6_FP13BP0                 _LCDRAM6.Bits.FP13BP0
#define LCDRAM6_FP13BP1                 _LCDRAM6.Bits.FP13BP1
#define LCDRAM6_FP13BP2                 _LCDRAM6.Bits.FP13BP2
#define LCDRAM6_FP13BP3                 _LCDRAM6.Bits.FP13BP3
#define LCDRAM6_FP12BP                  _LCDRAM6.MergedBits.grpFP12BP
#define LCDRAM6_FP13BP                  _LCDRAM6.MergedBits.grpFP13BP

#define LCDRAM6_FP12BP0_MASK            1U
#define LCDRAM6_FP12BP1_MASK            2U
#define LCDRAM6_FP12BP2_MASK            4U
#define LCDRAM6_FP12BP3_MASK            8U
#define LCDRAM6_FP13BP0_MASK            16U
#define LCDRAM6_FP13BP1_MASK            32U
#define LCDRAM6_FP13BP2_MASK            64U
#define LCDRAM6_FP13BP3_MASK            128U
#define LCDRAM6_FP12BP_MASK             15U
#define LCDRAM6_FP12BP_BITNUM           0U
#define LCDRAM6_FP13BP_MASK             240U
#define LCDRAM6_FP13BP_BITNUM           4U


/*** LCDRAM7 - LCD RAM 7; 0x0000012F ***/
typedef union {
  byte Byte;
  struct {
    byte FP14BP0     :1;                                       /* LCD Segment FP14, BP0 ON */
    byte FP14BP1     :1;                                       /* LCD Segment FP14, BP1 ON */
    byte FP14BP2     :1;                                       /* LCD Segment FP14, BP2 ON */
    byte FP14BP3     :1;                                       /* LCD Segment FP14, BP3 ON */
    byte FP15BP0     :1;                                       /* LCD Segment FP15, BP0 ON */
    byte FP15BP1     :1;                                       /* LCD Segment FP15, BP1 ON */
    byte FP15BP2     :1;                                       /* LCD Segment FP15, BP2 ON */
    byte FP15BP3     :1;                                       /* LCD Segment FP15, BP3 ON */
  } Bits;
  struct {
    byte grpFP14BP :4;
    byte grpFP15BP :4;
  } MergedBits;
} LCDRAM7STR;
extern volatile LCDRAM7STR _LCDRAM7 @(REG_BASE + 0x0000012FUL);
#define LCDRAM7                         _LCDRAM7.Byte
#define LCDRAM7_FP14BP0                 _LCDRAM7.Bits.FP14BP0
#define LCDRAM7_FP14BP1                 _LCDRAM7.Bits.FP14BP1
#define LCDRAM7_FP14BP2                 _LCDRAM7.Bits.FP14BP2
#define LCDRAM7_FP14BP3                 _LCDRAM7.Bits.FP14BP3
#define LCDRAM7_FP15BP0                 _LCDRAM7.Bits.FP15BP0
#define LCDRAM7_FP15BP1                 _LCDRAM7.Bits.FP15BP1
#define LCDRAM7_FP15BP2                 _LCDRAM7.Bits.FP15BP2
#define LCDRAM7_FP15BP3                 _LCDRAM7.Bits.FP15BP3
#define LCDRAM7_FP14BP                  _LCDRAM7.MergedBits.grpFP14BP
#define LCDRAM7_FP15BP                  _LCDRAM7.MergedBits.grpFP15BP

#define LCDRAM7_FP14BP0_MASK            1U
#define LCDRAM7_FP14BP1_MASK            2U
#define LCDRAM7_FP14BP2_MASK            4U
#define LCDRAM7_FP14BP3_MASK            8U
#define LCDRAM7_FP15BP0_MASK            16U
#define LCDRAM7_FP15BP1_MASK            32U
#define LCDRAM7_FP15BP2_MASK            64U
#define LCDRAM7_FP15BP3_MASK            128U
#define LCDRAM7_FP14BP_MASK             15U
#define LCDRAM7_FP14BP_BITNUM           0U
#define LCDRAM7_FP15BP_MASK             240U
#define LCDRAM7_FP15BP_BITNUM           4U


/*** LCDRAM8 - LCD RAM 8; 0x00000130 ***/
typedef union {
  byte Byte;
  struct {
    byte FP16BP0     :1;                                       /* LCD Segment FP16, BP0 ON */
    byte FP16BP1     :1;                                       /* LCD Segment FP16, BP1 ON */
    byte FP16BP2     :1;                                       /* LCD Segment FP16, BP2 ON */
    byte FP16BP3     :1;                                       /* LCD Segment FP16, BP3 ON */
    byte FP17BP0     :1;                                       /* LCD Segment FP17, BP0 ON */
    byte FP17BP1     :1;                                       /* LCD Segment FP17, BP1 ON */
    byte FP17BP2     :1;                                       /* LCD Segment FP17, BP2 ON */
    byte FP17BP3     :1;                                       /* LCD Segment FP17, BP3 ON */
  } Bits;
  struct {
    byte grpFP16BP :4;
    byte grpFP17BP :4;
  } MergedBits;
} LCDRAM8STR;
extern volatile LCDRAM8STR _LCDRAM8 @(REG_BASE + 0x00000130UL);
#define LCDRAM8                         _LCDRAM8.Byte
#define LCDRAM8_FP16BP0                 _LCDRAM8.Bits.FP16BP0
#define LCDRAM8_FP16BP1                 _LCDRAM8.Bits.FP16BP1
#define LCDRAM8_FP16BP2                 _LCDRAM8.Bits.FP16BP2
#define LCDRAM8_FP16BP3                 _LCDRAM8.Bits.FP16BP3
#define LCDRAM8_FP17BP0                 _LCDRAM8.Bits.FP17BP0
#define LCDRAM8_FP17BP1                 _LCDRAM8.Bits.FP17BP1
#define LCDRAM8_FP17BP2                 _LCDRAM8.Bits.FP17BP2
#define LCDRAM8_FP17BP3                 _LCDRAM8.Bits.FP17BP3
#define LCDRAM8_FP16BP                  _LCDRAM8.MergedBits.grpFP16BP
#define LCDRAM8_FP17BP                  _LCDRAM8.MergedBits.grpFP17BP

#define LCDRAM8_FP16BP0_MASK            1U
#define LCDRAM8_FP16BP1_MASK            2U
#define LCDRAM8_FP16BP2_MASK            4U
#define LCDRAM8_FP16BP3_MASK            8U
#define LCDRAM8_FP17BP0_MASK            16U
#define LCDRAM8_FP17BP1_MASK            32U
#define LCDRAM8_FP17BP2_MASK            64U
#define LCDRAM8_FP17BP3_MASK            128U
#define LCDRAM8_FP16BP_MASK             15U
#define LCDRAM8_FP16BP_BITNUM           0U
#define LCDRAM8_FP17BP_MASK             240U
#define LCDRAM8_FP17BP_BITNUM           4U


/*** LCDRAM9 - LCD RAM 9; 0x00000131 ***/
typedef union {
  byte Byte;
  struct {
    byte FP18BP0     :1;                                       /* LCD Segment FP18, BP0 ON */
    byte FP18BP1     :1;                                       /* LCD Segment FP18, BP1 ON */
    byte FP18BP2     :1;                                       /* LCD Segment FP18, BP2 ON */
    byte FP18BP3     :1;                                       /* LCD Segment FP18, BP3 ON */
    byte FP19BP0     :1;                                       /* LCD Segment FP19, BP0 ON */
    byte FP19BP1     :1;                                       /* LCD Segment FP19, BP1 ON */
    byte FP19BP2     :1;                                       /* LCD Segment FP19, BP2 ON */
    byte FP19BP3     :1;                                       /* LCD Segment FP19, BP3 ON */
  } Bits;
  struct {
    byte grpFP18BP :4;
    byte grpFP19BP :4;
  } MergedBits;
} LCDRAM9STR;
extern volatile LCDRAM9STR _LCDRAM9 @(REG_BASE + 0x00000131UL);
#define LCDRAM9                         _LCDRAM9.Byte
#define LCDRAM9_FP18BP0                 _LCDRAM9.Bits.FP18BP0
#define LCDRAM9_FP18BP1                 _LCDRAM9.Bits.FP18BP1
#define LCDRAM9_FP18BP2                 _LCDRAM9.Bits.FP18BP2
#define LCDRAM9_FP18BP3                 _LCDRAM9.Bits.FP18BP3
#define LCDRAM9_FP19BP0                 _LCDRAM9.Bits.FP19BP0
#define LCDRAM9_FP19BP1                 _LCDRAM9.Bits.FP19BP1
#define LCDRAM9_FP19BP2                 _LCDRAM9.Bits.FP19BP2
#define LCDRAM9_FP19BP3                 _LCDRAM9.Bits.FP19BP3
#define LCDRAM9_FP18BP                  _LCDRAM9.MergedBits.grpFP18BP
#define LCDRAM9_FP19BP                  _LCDRAM9.MergedBits.grpFP19BP

#define LCDRAM9_FP18BP0_MASK            1U
#define LCDRAM9_FP18BP1_MASK            2U
#define LCDRAM9_FP18BP2_MASK            4U
#define LCDRAM9_FP18BP3_MASK            8U
#define LCDRAM9_FP19BP0_MASK            16U
#define LCDRAM9_FP19BP1_MASK            32U
#define LCDRAM9_FP19BP2_MASK            64U
#define LCDRAM9_FP19BP3_MASK            128U
#define LCDRAM9_FP18BP_MASK             15U
#define LCDRAM9_FP18BP_BITNUM           0U
#define LCDRAM9_FP19BP_MASK             240U
#define LCDRAM9_FP19BP_BITNUM           4U


/*** LCDRAM10 - LCD RAM 10; 0x00000132 ***/
typedef union {
  byte Byte;
  struct {
    byte FP20BP0     :1;                                       /* LCD Segment FP20, BP0 ON */
    byte FP20BP1     :1;                                       /* LCD Segment FP20, BP1 ON */
    byte FP20BP2     :1;                                       /* LCD Segment FP20, BP2 ON */
    byte FP20BP3     :1;                                       /* LCD Segment FP20, BP3 ON */
    byte FP21BP0     :1;                                       /* LCD Segment FP21, BP0 ON */
    byte FP21BP1     :1;                                       /* LCD Segment FP21, BP1 ON */
    byte FP21BP2     :1;                                       /* LCD Segment FP21, BP2 ON */
    byte FP21BP3     :1;                                       /* LCD Segment FP21, BP3 ON */
  } Bits;
  struct {
    byte grpFP20BP :4;
    byte grpFP21BP :4;
  } MergedBits;
} LCDRAM10STR;
extern volatile LCDRAM10STR _LCDRAM10 @(REG_BASE + 0x00000132UL);
#define LCDRAM10                        _LCDRAM10.Byte
#define LCDRAM10_FP20BP0                _LCDRAM10.Bits.FP20BP0
#define LCDRAM10_FP20BP1                _LCDRAM10.Bits.FP20BP1
#define LCDRAM10_FP20BP2                _LCDRAM10.Bits.FP20BP2
#define LCDRAM10_FP20BP3                _LCDRAM10.Bits.FP20BP3
#define LCDRAM10_FP21BP0                _LCDRAM10.Bits.FP21BP0
#define LCDRAM10_FP21BP1                _LCDRAM10.Bits.FP21BP1
#define LCDRAM10_FP21BP2                _LCDRAM10.Bits.FP21BP2
#define LCDRAM10_FP21BP3                _LCDRAM10.Bits.FP21BP3
#define LCDRAM10_FP20BP                 _LCDRAM10.MergedBits.grpFP20BP
#define LCDRAM10_FP21BP                 _LCDRAM10.MergedBits.grpFP21BP

#define LCDRAM10_FP20BP0_MASK           1U
#define LCDRAM10_FP20BP1_MASK           2U
#define LCDRAM10_FP20BP2_MASK           4U
#define LCDRAM10_FP20BP3_MASK           8U
#define LCDRAM10_FP21BP0_MASK           16U
#define LCDRAM10_FP21BP1_MASK           32U
#define LCDRAM10_FP21BP2_MASK           64U
#define LCDRAM10_FP21BP3_MASK           128U
#define LCDRAM10_FP20BP_MASK            15U
#define LCDRAM10_FP20BP_BITNUM          0U
#define LCDRAM10_FP21BP_MASK            240U
#define LCDRAM10_FP21BP_BITNUM          4U


/*** LCDRAM11 - LCD RAM 11; 0x00000133 ***/
typedef union {
  byte Byte;
  struct {
    byte FP22BP0     :1;                                       /* LCD Segment FP22, BP0 ON */
    byte FP22BP1     :1;                                       /* LCD Segment FP22, BP1 ON */
    byte FP22BP2     :1;                                       /* LCD Segment FP22, BP2 ON */
    byte FP22BP3     :1;                                       /* LCD Segment FP22, BP3 ON */
    byte FP23BP0     :1;                                       /* LCD Segment FP23, BP0 ON */
    byte FP23BP1     :1;                                       /* LCD Segment FP23, BP1 ON */
    byte FP23BP2     :1;                                       /* LCD Segment FP23, BP2 ON */
    byte FP23BP3     :1;                                       /* LCD Segment FP23, BP3 ON */
  } Bits;
  struct {
    byte grpFP22BP :4;
    byte grpFP23BP :4;
  } MergedBits;
} LCDRAM11STR;
extern volatile LCDRAM11STR _LCDRAM11 @(REG_BASE + 0x00000133UL);
#define LCDRAM11                        _LCDRAM11.Byte
#define LCDRAM11_FP22BP0                _LCDRAM11.Bits.FP22BP0
#define LCDRAM11_FP22BP1                _LCDRAM11.Bits.FP22BP1
#define LCDRAM11_FP22BP2                _LCDRAM11.Bits.FP22BP2
#define LCDRAM11_FP22BP3                _LCDRAM11.Bits.FP22BP3
#define LCDRAM11_FP23BP0                _LCDRAM11.Bits.FP23BP0
#define LCDRAM11_FP23BP1                _LCDRAM11.Bits.FP23BP1
#define LCDRAM11_FP23BP2                _LCDRAM11.Bits.FP23BP2
#define LCDRAM11_FP23BP3                _LCDRAM11.Bits.FP23BP3
#define LCDRAM11_FP22BP                 _LCDRAM11.MergedBits.grpFP22BP
#define LCDRAM11_FP23BP                 _LCDRAM11.MergedBits.grpFP23BP

#define LCDRAM11_FP22BP0_MASK           1U
#define LCDRAM11_FP22BP1_MASK           2U
#define LCDRAM11_FP22BP2_MASK           4U
#define LCDRAM11_FP22BP3_MASK           8U
#define LCDRAM11_FP23BP0_MASK           16U
#define LCDRAM11_FP23BP1_MASK           32U
#define LCDRAM11_FP23BP2_MASK           64U
#define LCDRAM11_FP23BP3_MASK           128U
#define LCDRAM11_FP22BP_MASK            15U
#define LCDRAM11_FP22BP_BITNUM          0U
#define LCDRAM11_FP23BP_MASK            240U
#define LCDRAM11_FP23BP_BITNUM          4U


/*** LCDRAM12 - LCD RAM 12; 0x00000134 ***/
typedef union {
  byte Byte;
  struct {
    byte FP24BP0     :1;                                       /* LCD Segment FP24, BP0 ON */
    byte FP24BP1     :1;                                       /* LCD Segment FP24, BP1 ON */
    byte FP24BP2     :1;                                       /* LCD Segment FP24, BP2 ON */
    byte FP24BP3     :1;                                       /* LCD Segment FP24, BP3 ON */
    byte FP25BP0     :1;                                       /* LCD Segment FP25, BP0 ON */
    byte FP25BP1     :1;                                       /* LCD Segment FP25, BP1 ON */
    byte FP25BP2     :1;                                       /* LCD Segment FP25, BP2 ON */
    byte FP25BP3     :1;                                       /* LCD Segment FP25, BP3 ON */
  } Bits;
  struct {
    byte grpFP24BP :4;
    byte grpFP25BP :4;
  } MergedBits;
} LCDRAM12STR;
extern volatile LCDRAM12STR _LCDRAM12 @(REG_BASE + 0x00000134UL);
#define LCDRAM12                        _LCDRAM12.Byte
#define LCDRAM12_FP24BP0                _LCDRAM12.Bits.FP24BP0
#define LCDRAM12_FP24BP1                _LCDRAM12.Bits.FP24BP1
#define LCDRAM12_FP24BP2                _LCDRAM12.Bits.FP24BP2
#define LCDRAM12_FP24BP3                _LCDRAM12.Bits.FP24BP3
#define LCDRAM12_FP25BP0                _LCDRAM12.Bits.FP25BP0
#define LCDRAM12_FP25BP1                _LCDRAM12.Bits.FP25BP1
#define LCDRAM12_FP25BP2                _LCDRAM12.Bits.FP25BP2
#define LCDRAM12_FP25BP3                _LCDRAM12.Bits.FP25BP3
#define LCDRAM12_FP24BP                 _LCDRAM12.MergedBits.grpFP24BP
#define LCDRAM12_FP25BP                 _LCDRAM12.MergedBits.grpFP25BP

#define LCDRAM12_FP24BP0_MASK           1U
#define LCDRAM12_FP24BP1_MASK           2U
#define LCDRAM12_FP24BP2_MASK           4U
#define LCDRAM12_FP24BP3_MASK           8U
#define LCDRAM12_FP25BP0_MASK           16U
#define LCDRAM12_FP25BP1_MASK           32U
#define LCDRAM12_FP25BP2_MASK           64U
#define LCDRAM12_FP25BP3_MASK           128U
#define LCDRAM12_FP24BP_MASK            15U
#define LCDRAM12_FP24BP_BITNUM          0U
#define LCDRAM12_FP25BP_MASK            240U
#define LCDRAM12_FP25BP_BITNUM          4U


/*** LCDRAM13 - LCD RAM 13; 0x00000135 ***/
typedef union {
  byte Byte;
  struct {
    byte FP26BP0     :1;                                       /* LCD Segment FP26, BP0 ON */
    byte FP26BP1     :1;                                       /* LCD Segment FP26, BP1 ON */
    byte FP26BP2     :1;                                       /* LCD Segment FP26, BP2 ON */
    byte FP26BP3     :1;                                       /* LCD Segment FP26, BP3 ON */
    byte FP27BP0     :1;                                       /* LCD Segment FP27, BP0 ON */
    byte FP27BP1     :1;                                       /* LCD Segment FP27, BP1 ON */
    byte FP27BP2     :1;                                       /* LCD Segment FP27, BP2 ON */
    byte FP27BP3     :1;                                       /* LCD Segment FP27, BP3 ON */
  } Bits;
  struct {
    byte grpFP26BP :4;
    byte grpFP27BP :4;
  } MergedBits;
} LCDRAM13STR;
extern volatile LCDRAM13STR _LCDRAM13 @(REG_BASE + 0x00000135UL);
#define LCDRAM13                        _LCDRAM13.Byte
#define LCDRAM13_FP26BP0                _LCDRAM13.Bits.FP26BP0
#define LCDRAM13_FP26BP1                _LCDRAM13.Bits.FP26BP1
#define LCDRAM13_FP26BP2                _LCDRAM13.Bits.FP26BP2
#define LCDRAM13_FP26BP3                _LCDRAM13.Bits.FP26BP3
#define LCDRAM13_FP27BP0                _LCDRAM13.Bits.FP27BP0
#define LCDRAM13_FP27BP1                _LCDRAM13.Bits.FP27BP1
#define LCDRAM13_FP27BP2                _LCDRAM13.Bits.FP27BP2
#define LCDRAM13_FP27BP3                _LCDRAM13.Bits.FP27BP3
#define LCDRAM13_FP26BP                 _LCDRAM13.MergedBits.grpFP26BP
#define LCDRAM13_FP27BP                 _LCDRAM13.MergedBits.grpFP27BP

#define LCDRAM13_FP26BP0_MASK           1U
#define LCDRAM13_FP26BP1_MASK           2U
#define LCDRAM13_FP26BP2_MASK           4U
#define LCDRAM13_FP26BP3_MASK           8U
#define LCDRAM13_FP27BP0_MASK           16U
#define LCDRAM13_FP27BP1_MASK           32U
#define LCDRAM13_FP27BP2_MASK           64U
#define LCDRAM13_FP27BP3_MASK           128U
#define LCDRAM13_FP26BP_MASK            15U
#define LCDRAM13_FP26BP_BITNUM          0U
#define LCDRAM13_FP27BP_MASK            240U
#define LCDRAM13_FP27BP_BITNUM          4U


/*** LCDRAM14 - LCD RAM 14; 0x00000136 ***/
typedef union {
  byte Byte;
  struct {
    byte FP28BP0     :1;                                       /* LCD Segment FP28, BP0 ON */
    byte FP28BP1     :1;                                       /* LCD Segment FP28, BP1 ON */
    byte FP28BP2     :1;                                       /* LCD Segment FP28, BP2 ON */
    byte FP28BP3     :1;                                       /* LCD Segment FP28, BP3 ON */
    byte FP29BP0     :1;                                       /* LCD Segment FP29, BP0 ON */
    byte FP29BP1     :1;                                       /* LCD Segment FP29, BP1 ON */
    byte FP29BP2     :1;                                       /* LCD Segment FP29, BP2 ON */
    byte FP29BP3     :1;                                       /* LCD Segment FP29, BP3 ON */
  } Bits;
  struct {
    byte grpFP28BP :4;
    byte grpFP29BP :4;
  } MergedBits;
} LCDRAM14STR;
extern volatile LCDRAM14STR _LCDRAM14 @(REG_BASE + 0x00000136UL);
#define LCDRAM14                        _LCDRAM14.Byte
#define LCDRAM14_FP28BP0                _LCDRAM14.Bits.FP28BP0
#define LCDRAM14_FP28BP1                _LCDRAM14.Bits.FP28BP1
#define LCDRAM14_FP28BP2                _LCDRAM14.Bits.FP28BP2
#define LCDRAM14_FP28BP3                _LCDRAM14.Bits.FP28BP3
#define LCDRAM14_FP29BP0                _LCDRAM14.Bits.FP29BP0
#define LCDRAM14_FP29BP1                _LCDRAM14.Bits.FP29BP1
#define LCDRAM14_FP29BP2                _LCDRAM14.Bits.FP29BP2
#define LCDRAM14_FP29BP3                _LCDRAM14.Bits.FP29BP3
#define LCDRAM14_FP28BP                 _LCDRAM14.MergedBits.grpFP28BP
#define LCDRAM14_FP29BP                 _LCDRAM14.MergedBits.grpFP29BP

#define LCDRAM14_FP28BP0_MASK           1U
#define LCDRAM14_FP28BP1_MASK           2U
#define LCDRAM14_FP28BP2_MASK           4U
#define LCDRAM14_FP28BP3_MASK           8U
#define LCDRAM14_FP29BP0_MASK           16U
#define LCDRAM14_FP29BP1_MASK           32U
#define LCDRAM14_FP29BP2_MASK           64U
#define LCDRAM14_FP29BP3_MASK           128U
#define LCDRAM14_FP28BP_MASK            15U
#define LCDRAM14_FP28BP_BITNUM          0U
#define LCDRAM14_FP29BP_MASK            240U
#define LCDRAM14_FP29BP_BITNUM          4U


/*** LCDRAM15 - LCD RAM 15; 0x00000137 ***/
typedef union {
  byte Byte;
  struct {
    byte FP30BP0     :1;                                       /* LCD Segment FP30, BP0 ON */
    byte FP30BP1     :1;                                       /* LCD Segment FP30, BP1 ON */
    byte FP30BP2     :1;                                       /* LCD Segment FP30, BP2 ON */
    byte FP30BP3     :1;                                       /* LCD Segment FP30, BP3 ON */
    byte FP31BP0     :1;                                       /* LCD Segment FP31, BP0 ON */
    byte FP31BP1     :1;                                       /* LCD Segment FP31, BP1 ON */
    byte FP31BP2     :1;                                       /* LCD Segment FP31, BP2 ON */
    byte FP31BP3     :1;                                       /* LCD Segment FP31, BP3 ON */
  } Bits;
  struct {
    byte grpFP30BP :4;
    byte grpFP31BP :4;
  } MergedBits;
} LCDRAM15STR;
extern volatile LCDRAM15STR _LCDRAM15 @(REG_BASE + 0x00000137UL);
#define LCDRAM15                        _LCDRAM15.Byte
#define LCDRAM15_FP30BP0                _LCDRAM15.Bits.FP30BP0
#define LCDRAM15_FP30BP1                _LCDRAM15.Bits.FP30BP1
#define LCDRAM15_FP30BP2                _LCDRAM15.Bits.FP30BP2
#define LCDRAM15_FP30BP3                _LCDRAM15.Bits.FP30BP3
#define LCDRAM15_FP31BP0                _LCDRAM15.Bits.FP31BP0
#define LCDRAM15_FP31BP1                _LCDRAM15.Bits.FP31BP1
#define LCDRAM15_FP31BP2                _LCDRAM15.Bits.FP31BP2
#define LCDRAM15_FP31BP3                _LCDRAM15.Bits.FP31BP3
#define LCDRAM15_FP30BP                 _LCDRAM15.MergedBits.grpFP30BP
#define LCDRAM15_FP31BP                 _LCDRAM15.MergedBits.grpFP31BP

#define LCDRAM15_FP30BP0_MASK           1U
#define LCDRAM15_FP30BP1_MASK           2U
#define LCDRAM15_FP30BP2_MASK           4U
#define LCDRAM15_FP30BP3_MASK           8U
#define LCDRAM15_FP31BP0_MASK           16U
#define LCDRAM15_FP31BP1_MASK           32U
#define LCDRAM15_FP31BP2_MASK           64U
#define LCDRAM15_FP31BP3_MASK           128U
#define LCDRAM15_FP30BP_MASK            15U
#define LCDRAM15_FP30BP_BITNUM          0U
#define LCDRAM15_FP31BP_MASK            240U
#define LCDRAM15_FP31BP_BITNUM          4U


/*** IIC1_IBAD - IIC Address Register; 0x00000138 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IIC1_IBADSTR;
extern volatile IIC1_IBADSTR _IIC1_IBAD @(REG_BASE + 0x00000138UL);
#define IIC1_IBAD                       _IIC1_IBAD.Byte
#define IIC1_IBAD_ADR1                  _IIC1_IBAD.Bits.ADR1
#define IIC1_IBAD_ADR2                  _IIC1_IBAD.Bits.ADR2
#define IIC1_IBAD_ADR3                  _IIC1_IBAD.Bits.ADR3
#define IIC1_IBAD_ADR4                  _IIC1_IBAD.Bits.ADR4
#define IIC1_IBAD_ADR5                  _IIC1_IBAD.Bits.ADR5
#define IIC1_IBAD_ADR6                  _IIC1_IBAD.Bits.ADR6
#define IIC1_IBAD_ADR7                  _IIC1_IBAD.Bits.ADR7
#define IIC1_IBAD_ADR_1                 _IIC1_IBAD.MergedBits.grpADR_1
#define IIC1_IBAD_ADR                   IIC1_IBAD_ADR_1

#define IIC1_IBAD_ADR1_MASK             2U
#define IIC1_IBAD_ADR2_MASK             4U
#define IIC1_IBAD_ADR3_MASK             8U
#define IIC1_IBAD_ADR4_MASK             16U
#define IIC1_IBAD_ADR5_MASK             32U
#define IIC1_IBAD_ADR6_MASK             64U
#define IIC1_IBAD_ADR7_MASK             128U
#define IIC1_IBAD_ADR_1_MASK            254U
#define IIC1_IBAD_ADR_1_BITNUM          1U


/*** IIC1_IBFD - IIC Frequency Divider Register; 0x00000139 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IIC1_IBFDSTR;
extern volatile IIC1_IBFDSTR _IIC1_IBFD @(REG_BASE + 0x00000139UL);
#define IIC1_IBFD                       _IIC1_IBFD.Byte
#define IIC1_IBFD_IBC0                  _IIC1_IBFD.Bits.IBC0
#define IIC1_IBFD_IBC1                  _IIC1_IBFD.Bits.IBC1
#define IIC1_IBFD_IBC2                  _IIC1_IBFD.Bits.IBC2
#define IIC1_IBFD_IBC3                  _IIC1_IBFD.Bits.IBC3
#define IIC1_IBFD_IBC4                  _IIC1_IBFD.Bits.IBC4
#define IIC1_IBFD_IBC5                  _IIC1_IBFD.Bits.IBC5
#define IIC1_IBFD_IBC6                  _IIC1_IBFD.Bits.IBC6
#define IIC1_IBFD_IBC7                  _IIC1_IBFD.Bits.IBC7

#define IIC1_IBFD_IBC0_MASK             1U
#define IIC1_IBFD_IBC1_MASK             2U
#define IIC1_IBFD_IBC2_MASK             4U
#define IIC1_IBFD_IBC3_MASK             8U
#define IIC1_IBFD_IBC4_MASK             16U
#define IIC1_IBFD_IBC5_MASK             32U
#define IIC1_IBFD_IBC6_MASK             64U
#define IIC1_IBFD_IBC7_MASK             128U


/*** IIC1_IBCR - IIC Control Register; 0x0000013A ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IIC1_IBCRSTR;
extern volatile IIC1_IBCRSTR _IIC1_IBCR @(REG_BASE + 0x0000013AUL);
#define IIC1_IBCR                       _IIC1_IBCR.Byte
#define IIC1_IBCR_IBSWAI                _IIC1_IBCR.Bits.IBSWAI
#define IIC1_IBCR_RSTA                  _IIC1_IBCR.Bits.RSTA
#define IIC1_IBCR_TXAK                  _IIC1_IBCR.Bits.TXAK
#define IIC1_IBCR_TX_RX                 _IIC1_IBCR.Bits.TX_RX
#define IIC1_IBCR_MS_SL                 _IIC1_IBCR.Bits.MS_SL
#define IIC1_IBCR_IBIE                  _IIC1_IBCR.Bits.IBIE
#define IIC1_IBCR_IBEN                  _IIC1_IBCR.Bits.IBEN

#define IIC1_IBCR_IBSWAI_MASK           1U
#define IIC1_IBCR_RSTA_MASK             4U
#define IIC1_IBCR_TXAK_MASK             8U
#define IIC1_IBCR_TX_RX_MASK            16U
#define IIC1_IBCR_MS_SL_MASK            32U
#define IIC1_IBCR_IBIE_MASK             64U
#define IIC1_IBCR_IBEN_MASK             128U


/*** IIC1_IBSR - IIC Status Register; 0x0000013B ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IIC1_IBSRSTR;
extern volatile IIC1_IBSRSTR _IIC1_IBSR @(REG_BASE + 0x0000013BUL);
#define IIC1_IBSR                       _IIC1_IBSR.Byte
#define IIC1_IBSR_RXAK                  _IIC1_IBSR.Bits.RXAK
#define IIC1_IBSR_IBIF                  _IIC1_IBSR.Bits.IBIF
#define IIC1_IBSR_SRW                   _IIC1_IBSR.Bits.SRW
#define IIC1_IBSR_IBAL                  _IIC1_IBSR.Bits.IBAL
#define IIC1_IBSR_IBB                   _IIC1_IBSR.Bits.IBB
#define IIC1_IBSR_IAAS                  _IIC1_IBSR.Bits.IAAS
#define IIC1_IBSR_TCF                   _IIC1_IBSR.Bits.TCF

#define IIC1_IBSR_RXAK_MASK             1U
#define IIC1_IBSR_IBIF_MASK             2U
#define IIC1_IBSR_SRW_MASK              4U
#define IIC1_IBSR_IBAL_MASK             16U
#define IIC1_IBSR_IBB_MASK              32U
#define IIC1_IBSR_IAAS_MASK             64U
#define IIC1_IBSR_TCF_MASK              128U


/*** IIC1_IBDR - IIC Data I/O Register; 0x0000013C ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IIC1_IBDRSTR;
extern volatile IIC1_IBDRSTR _IIC1_IBDR @(REG_BASE + 0x0000013CUL);
#define IIC1_IBDR                       _IIC1_IBDR.Byte
#define IIC1_IBDR_D0                    _IIC1_IBDR.Bits.D0
#define IIC1_IBDR_D1                    _IIC1_IBDR.Bits.D1
#define IIC1_IBDR_D2                    _IIC1_IBDR.Bits.D2
#define IIC1_IBDR_D3                    _IIC1_IBDR.Bits.D3
#define IIC1_IBDR_D4                    _IIC1_IBDR.Bits.D4
#define IIC1_IBDR_D5                    _IIC1_IBDR.Bits.D5
#define IIC1_IBDR_D6                    _IIC1_IBDR.Bits.D6
#define IIC1_IBDR_D7                    _IIC1_IBDR.Bits.D7

#define IIC1_IBDR_D0_MASK               1U
#define IIC1_IBDR_D1_MASK               2U
#define IIC1_IBDR_D2_MASK               4U
#define IIC1_IBDR_D3_MASK               8U
#define IIC1_IBDR_D4_MASK               16U
#define IIC1_IBDR_D5_MASK               32U
#define IIC1_IBDR_D6_MASK               64U
#define IIC1_IBDR_D7_MASK               128U


/*** IIC1_IBCR2 - IIC Control Register 2; 0x0000013D ***/
typedef union {
  byte Byte;
  struct {
    byte ADR8        :1;                                       /* Slave Address Bit 8 */
    byte ADR9        :1;                                       /* Slave Address Bit 9 */
    byte ADR10       :1;                                       /* Slave Address Bit 10 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte ADTYPE      :1;                                       /* Address Type */
    byte GCEN        :1;                                       /* General Call Enable */
  } Bits;
  struct {
    byte grpADR_8 :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IIC1_IBCR2STR;
extern volatile IIC1_IBCR2STR _IIC1_IBCR2 @(REG_BASE + 0x0000013DUL);
#define IIC1_IBCR2                      _IIC1_IBCR2.Byte
#define IIC1_IBCR2_ADR8                 _IIC1_IBCR2.Bits.ADR8
#define IIC1_IBCR2_ADR9                 _IIC1_IBCR2.Bits.ADR9
#define IIC1_IBCR2_ADR10                _IIC1_IBCR2.Bits.ADR10
#define IIC1_IBCR2_ADTYPE               _IIC1_IBCR2.Bits.ADTYPE
#define IIC1_IBCR2_GCEN                 _IIC1_IBCR2.Bits.GCEN
#define IIC1_IBCR2_ADR_8                _IIC1_IBCR2.MergedBits.grpADR_8
#define IIC1_IBCR2_ADR                  IIC1_IBCR2_ADR_8

#define IIC1_IBCR2_ADR8_MASK            1U
#define IIC1_IBCR2_ADR9_MASK            2U
#define IIC1_IBCR2_ADR10_MASK           4U
#define IIC1_IBCR2_ADTYPE_MASK          64U
#define IIC1_IBCR2_GCEN_MASK            128U
#define IIC1_IBCR2_ADR_8_MASK           7U
#define IIC1_IBCR2_ADR_8_BITNUM         0U


/*** CAN0CTL0 - MSCAN0 Control 0 Register; 0x00000140 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN0CTL0STR;
extern volatile CAN0CTL0STR _CAN0CTL0 @(REG_BASE + 0x00000140UL);
#define CAN0CTL0                        _CAN0CTL0.Byte
#define CAN0CTL0_INITRQ                 _CAN0CTL0.Bits.INITRQ
#define CAN0CTL0_SLPRQ                  _CAN0CTL0.Bits.SLPRQ
#define CAN0CTL0_WUPE                   _CAN0CTL0.Bits.WUPE
#define CAN0CTL0_TIME                   _CAN0CTL0.Bits.TIME
#define CAN0CTL0_SYNCH                  _CAN0CTL0.Bits.SYNCH
#define CAN0CTL0_CSWAI                  _CAN0CTL0.Bits.CSWAI
#define CAN0CTL0_RXACT                  _CAN0CTL0.Bits.RXACT
#define CAN0CTL0_RXFRM                  _CAN0CTL0.Bits.RXFRM
/* CAN0CTL_ARR: Access 2 CAN0CTLx registers in an array */
#define CAN0CTL_ARR                     ((volatile byte *) &CAN0CTL0)

#define CAN0CTL0_INITRQ_MASK            1U
#define CAN0CTL0_SLPRQ_MASK             2U
#define CAN0CTL0_WUPE_MASK              4U
#define CAN0CTL0_TIME_MASK              8U
#define CAN0CTL0_SYNCH_MASK             16U
#define CAN0CTL0_CSWAI_MASK             32U
#define CAN0CTL0_RXACT_MASK             64U
#define CAN0CTL0_RXFRM_MASK             128U


/*** CAN0CTL1 - MSCAN0 Control 1 Register; 0x00000141 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN Clock Source */
    byte CANE        :1;                                       /* MSCAN Enable */
  } Bits;
} CAN0CTL1STR;
extern volatile CAN0CTL1STR _CAN0CTL1 @(REG_BASE + 0x00000141UL);
#define CAN0CTL1                        _CAN0CTL1.Byte
#define CAN0CTL1_INITAK                 _CAN0CTL1.Bits.INITAK
#define CAN0CTL1_SLPAK                  _CAN0CTL1.Bits.SLPAK
#define CAN0CTL1_WUPM                   _CAN0CTL1.Bits.WUPM
#define CAN0CTL1_BORM                   _CAN0CTL1.Bits.BORM
#define CAN0CTL1_LISTEN                 _CAN0CTL1.Bits.LISTEN
#define CAN0CTL1_LOOPB                  _CAN0CTL1.Bits.LOOPB
#define CAN0CTL1_CLKSRC                 _CAN0CTL1.Bits.CLKSRC
#define CAN0CTL1_CANE                   _CAN0CTL1.Bits.CANE

#define CAN0CTL1_INITAK_MASK            1U
#define CAN0CTL1_SLPAK_MASK             2U
#define CAN0CTL1_WUPM_MASK              4U
#define CAN0CTL1_BORM_MASK              8U
#define CAN0CTL1_LISTEN_MASK            16U
#define CAN0CTL1_LOOPB_MASK             32U
#define CAN0CTL1_CLKSRC_MASK            64U
#define CAN0CTL1_CANE_MASK              128U


/*** CAN0BTR0 - MSCAN0 Bus Timing Register 0; 0x00000142 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN0BTR0STR;
extern volatile CAN0BTR0STR _CAN0BTR0 @(REG_BASE + 0x00000142UL);
#define CAN0BTR0                        _CAN0BTR0.Byte
#define CAN0BTR0_BRP0                   _CAN0BTR0.Bits.BRP0
#define CAN0BTR0_BRP1                   _CAN0BTR0.Bits.BRP1
#define CAN0BTR0_BRP2                   _CAN0BTR0.Bits.BRP2
#define CAN0BTR0_BRP3                   _CAN0BTR0.Bits.BRP3
#define CAN0BTR0_BRP4                   _CAN0BTR0.Bits.BRP4
#define CAN0BTR0_BRP5                   _CAN0BTR0.Bits.BRP5
#define CAN0BTR0_SJW0                   _CAN0BTR0.Bits.SJW0
#define CAN0BTR0_SJW1                   _CAN0BTR0.Bits.SJW1
/* CAN0BTR_ARR: Access 2 CAN0BTRx registers in an array */
#define CAN0BTR_ARR                     ((volatile byte *) &CAN0BTR0)
#define CAN0BTR0_BRP                    _CAN0BTR0.MergedBits.grpBRP
#define CAN0BTR0_SJW                    _CAN0BTR0.MergedBits.grpSJW

#define CAN0BTR0_BRP0_MASK              1U
#define CAN0BTR0_BRP1_MASK              2U
#define CAN0BTR0_BRP2_MASK              4U
#define CAN0BTR0_BRP3_MASK              8U
#define CAN0BTR0_BRP4_MASK              16U
#define CAN0BTR0_BRP5_MASK              32U
#define CAN0BTR0_SJW0_MASK              64U
#define CAN0BTR0_SJW1_MASK              128U
#define CAN0BTR0_BRP_MASK               63U
#define CAN0BTR0_BRP_BITNUM             0U
#define CAN0BTR0_SJW_MASK               192U
#define CAN0BTR0_SJW_BITNUM             6U


/*** CAN0BTR1 - MSCAN0 Bus Timing Register 1; 0x00000143 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN0BTR1STR;
extern volatile CAN0BTR1STR _CAN0BTR1 @(REG_BASE + 0x00000143UL);
#define CAN0BTR1                        _CAN0BTR1.Byte
#define CAN0BTR1_TSEG10                 _CAN0BTR1.Bits.TSEG10
#define CAN0BTR1_TSEG11                 _CAN0BTR1.Bits.TSEG11
#define CAN0BTR1_TSEG12                 _CAN0BTR1.Bits.TSEG12
#define CAN0BTR1_TSEG13                 _CAN0BTR1.Bits.TSEG13
#define CAN0BTR1_TSEG20                 _CAN0BTR1.Bits.TSEG20
#define CAN0BTR1_TSEG21                 _CAN0BTR1.Bits.TSEG21
#define CAN0BTR1_TSEG22                 _CAN0BTR1.Bits.TSEG22
#define CAN0BTR1_SAMP                   _CAN0BTR1.Bits.SAMP
#define CAN0BTR1_TSEG_10                _CAN0BTR1.MergedBits.grpTSEG_10
#define CAN0BTR1_TSEG_20                _CAN0BTR1.MergedBits.grpTSEG_20
#define CAN0BTR1_TSEG                   CAN0BTR1_TSEG_10

#define CAN0BTR1_TSEG10_MASK            1U
#define CAN0BTR1_TSEG11_MASK            2U
#define CAN0BTR1_TSEG12_MASK            4U
#define CAN0BTR1_TSEG13_MASK            8U
#define CAN0BTR1_TSEG20_MASK            16U
#define CAN0BTR1_TSEG21_MASK            32U
#define CAN0BTR1_TSEG22_MASK            64U
#define CAN0BTR1_SAMP_MASK              128U
#define CAN0BTR1_TSEG_10_MASK           15U
#define CAN0BTR1_TSEG_10_BITNUM         0U
#define CAN0BTR1_TSEG_20_MASK           112U
#define CAN0BTR1_TSEG_20_BITNUM         4U


/*** CAN0RFLG - MSCAN0 Receiver Flag Register; 0x00000144 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RFLGSTR;
extern volatile CAN0RFLGSTR _CAN0RFLG @(REG_BASE + 0x00000144UL);
#define CAN0RFLG                        _CAN0RFLG.Byte
#define CAN0RFLG_RXF                    _CAN0RFLG.Bits.RXF
#define CAN0RFLG_OVRIF                  _CAN0RFLG.Bits.OVRIF
#define CAN0RFLG_TSTAT0                 _CAN0RFLG.Bits.TSTAT0
#define CAN0RFLG_TSTAT1                 _CAN0RFLG.Bits.TSTAT1
#define CAN0RFLG_RSTAT0                 _CAN0RFLG.Bits.RSTAT0
#define CAN0RFLG_RSTAT1                 _CAN0RFLG.Bits.RSTAT1
#define CAN0RFLG_CSCIF                  _CAN0RFLG.Bits.CSCIF
#define CAN0RFLG_WUPIF                  _CAN0RFLG.Bits.WUPIF
#define CAN0RFLG_TSTAT                  _CAN0RFLG.MergedBits.grpTSTAT
#define CAN0RFLG_RSTAT                  _CAN0RFLG.MergedBits.grpRSTAT

#define CAN0RFLG_RXF_MASK               1U
#define CAN0RFLG_OVRIF_MASK             2U
#define CAN0RFLG_TSTAT0_MASK            4U
#define CAN0RFLG_TSTAT1_MASK            8U
#define CAN0RFLG_RSTAT0_MASK            16U
#define CAN0RFLG_RSTAT1_MASK            32U
#define CAN0RFLG_CSCIF_MASK             64U
#define CAN0RFLG_WUPIF_MASK             128U
#define CAN0RFLG_TSTAT_MASK             12U
#define CAN0RFLG_TSTAT_BITNUM           2U
#define CAN0RFLG_RSTAT_MASK             48U
#define CAN0RFLG_RSTAT_BITNUM           4U


/*** CAN0RIER - MSCAN0 Receiver Interrupt Enable Register; 0x00000145 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RIERSTR;
extern volatile CAN0RIERSTR _CAN0RIER @(REG_BASE + 0x00000145UL);
#define CAN0RIER                        _CAN0RIER.Byte
#define CAN0RIER_RXFIE                  _CAN0RIER.Bits.RXFIE
#define CAN0RIER_OVRIE                  _CAN0RIER.Bits.OVRIE
#define CAN0RIER_TSTATE0                _CAN0RIER.Bits.TSTATE0
#define CAN0RIER_TSTATE1                _CAN0RIER.Bits.TSTATE1
#define CAN0RIER_RSTATE0                _CAN0RIER.Bits.RSTATE0
#define CAN0RIER_RSTATE1                _CAN0RIER.Bits.RSTATE1
#define CAN0RIER_CSCIE                  _CAN0RIER.Bits.CSCIE
#define CAN0RIER_WUPIE                  _CAN0RIER.Bits.WUPIE
#define CAN0RIER_TSTATE                 _CAN0RIER.MergedBits.grpTSTATE
#define CAN0RIER_RSTATE                 _CAN0RIER.MergedBits.grpRSTATE

#define CAN0RIER_RXFIE_MASK             1U
#define CAN0RIER_OVRIE_MASK             2U
#define CAN0RIER_TSTATE0_MASK           4U
#define CAN0RIER_TSTATE1_MASK           8U
#define CAN0RIER_RSTATE0_MASK           16U
#define CAN0RIER_RSTATE1_MASK           32U
#define CAN0RIER_CSCIE_MASK             64U
#define CAN0RIER_WUPIE_MASK             128U
#define CAN0RIER_TSTATE_MASK            12U
#define CAN0RIER_TSTATE_BITNUM          2U
#define CAN0RIER_RSTATE_MASK            48U
#define CAN0RIER_RSTATE_BITNUM          4U


/*** CAN0TFLG - MSCAN0 Transmitter Flag Register; 0x00000146 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TFLGSTR;
extern volatile CAN0TFLGSTR _CAN0TFLG @(REG_BASE + 0x00000146UL);
#define CAN0TFLG                        _CAN0TFLG.Byte
#define CAN0TFLG_TXE0                   _CAN0TFLG.Bits.TXE0
#define CAN0TFLG_TXE1                   _CAN0TFLG.Bits.TXE1
#define CAN0TFLG_TXE2                   _CAN0TFLG.Bits.TXE2
#define CAN0TFLG_TXE                    _CAN0TFLG.MergedBits.grpTXE

#define CAN0TFLG_TXE0_MASK              1U
#define CAN0TFLG_TXE1_MASK              2U
#define CAN0TFLG_TXE2_MASK              4U
#define CAN0TFLG_TXE_MASK               7U
#define CAN0TFLG_TXE_BITNUM             0U


/*** CAN0TIER - MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TIERSTR;
extern volatile CAN0TIERSTR _CAN0TIER @(REG_BASE + 0x00000147UL);
#define CAN0TIER                        _CAN0TIER.Byte
#define CAN0TIER_TXEIE0                 _CAN0TIER.Bits.TXEIE0
#define CAN0TIER_TXEIE1                 _CAN0TIER.Bits.TXEIE1
#define CAN0TIER_TXEIE2                 _CAN0TIER.Bits.TXEIE2
#define CAN0TIER_TXEIE                  _CAN0TIER.MergedBits.grpTXEIE

#define CAN0TIER_TXEIE0_MASK            1U
#define CAN0TIER_TXEIE1_MASK            2U
#define CAN0TIER_TXEIE2_MASK            4U
#define CAN0TIER_TXEIE_MASK             7U
#define CAN0TIER_TXEIE_BITNUM           0U


/*** CAN0TARQ - MSCAN0 Transmitter Message Abort Request; 0x00000148 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TARQSTR;
extern volatile CAN0TARQSTR _CAN0TARQ @(REG_BASE + 0x00000148UL);
#define CAN0TARQ                        _CAN0TARQ.Byte
#define CAN0TARQ_ABTRQ0                 _CAN0TARQ.Bits.ABTRQ0
#define CAN0TARQ_ABTRQ1                 _CAN0TARQ.Bits.ABTRQ1
#define CAN0TARQ_ABTRQ2                 _CAN0TARQ.Bits.ABTRQ2
#define CAN0TARQ_ABTRQ                  _CAN0TARQ.MergedBits.grpABTRQ

#define CAN0TARQ_ABTRQ0_MASK            1U
#define CAN0TARQ_ABTRQ1_MASK            2U
#define CAN0TARQ_ABTRQ2_MASK            4U
#define CAN0TARQ_ABTRQ_MASK             7U
#define CAN0TARQ_ABTRQ_BITNUM           0U


/*** CAN0TAAK - MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TAAKSTR;
extern volatile CAN0TAAKSTR _CAN0TAAK @(REG_BASE + 0x00000149UL);
#define CAN0TAAK                        _CAN0TAAK.Byte
#define CAN0TAAK_ABTAK0                 _CAN0TAAK.Bits.ABTAK0
#define CAN0TAAK_ABTAK1                 _CAN0TAAK.Bits.ABTAK1
#define CAN0TAAK_ABTAK2                 _CAN0TAAK.Bits.ABTAK2
#define CAN0TAAK_ABTAK                  _CAN0TAAK.MergedBits.grpABTAK

#define CAN0TAAK_ABTAK0_MASK            1U
#define CAN0TAAK_ABTAK1_MASK            2U
#define CAN0TAAK_ABTAK2_MASK            4U
#define CAN0TAAK_ABTAK_MASK             7U
#define CAN0TAAK_ABTAK_BITNUM           0U


/*** CAN0TBSEL - MSCAN0 Transmit Buffer Selection; 0x0000014A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TBSELSTR;
extern volatile CAN0TBSELSTR _CAN0TBSEL @(REG_BASE + 0x0000014AUL);
#define CAN0TBSEL                       _CAN0TBSEL.Byte
#define CAN0TBSEL_TX0                   _CAN0TBSEL.Bits.TX0
#define CAN0TBSEL_TX1                   _CAN0TBSEL.Bits.TX1
#define CAN0TBSEL_TX2                   _CAN0TBSEL.Bits.TX2
#define CAN0TBSEL_TX                    _CAN0TBSEL.MergedBits.grpTX

#define CAN0TBSEL_TX0_MASK              1U
#define CAN0TBSEL_TX1_MASK              2U
#define CAN0TBSEL_TX2_MASK              4U
#define CAN0TBSEL_TX_MASK               7U
#define CAN0TBSEL_TX_BITNUM             0U


/*** CAN0IDAC - MSCAN0 Identifier Acceptance Control Register; 0x0000014B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0IDACSTR;
extern volatile CAN0IDACSTR _CAN0IDAC @(REG_BASE + 0x0000014BUL);
#define CAN0IDAC                        _CAN0IDAC.Byte
#define CAN0IDAC_IDHIT0                 _CAN0IDAC.Bits.IDHIT0
#define CAN0IDAC_IDHIT1                 _CAN0IDAC.Bits.IDHIT1
#define CAN0IDAC_IDHIT2                 _CAN0IDAC.Bits.IDHIT2
#define CAN0IDAC_IDAM0                  _CAN0IDAC.Bits.IDAM0
#define CAN0IDAC_IDAM1                  _CAN0IDAC.Bits.IDAM1
#define CAN0IDAC_IDHIT                  _CAN0IDAC.MergedBits.grpIDHIT
#define CAN0IDAC_IDAM                   _CAN0IDAC.MergedBits.grpIDAM

#define CAN0IDAC_IDHIT0_MASK            1U
#define CAN0IDAC_IDHIT1_MASK            2U
#define CAN0IDAC_IDHIT2_MASK            4U
#define CAN0IDAC_IDAM0_MASK             16U
#define CAN0IDAC_IDAM1_MASK             32U
#define CAN0IDAC_IDHIT_MASK             7U
#define CAN0IDAC_IDHIT_BITNUM           0U
#define CAN0IDAC_IDAM_MASK              48U
#define CAN0IDAC_IDAM_BITNUM            4U


/*** CAN0MISC - MSCAN0 Miscellaneous Register; 0x0000014D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-off State Hold Until User Request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN0MISCSTR;
extern volatile CAN0MISCSTR _CAN0MISC @(REG_BASE + 0x0000014DUL);
#define CAN0MISC                        _CAN0MISC.Byte
#define CAN0MISC_BOHOLD                 _CAN0MISC.Bits.BOHOLD

#define CAN0MISC_BOHOLD_MASK            1U


/*** CAN0RXERR - MSCAN0 Receive Error Counter Register; 0x0000014E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0RXERRSTR;
extern volatile CAN0RXERRSTR _CAN0RXERR @(REG_BASE + 0x0000014EUL);
#define CAN0RXERR                       _CAN0RXERR.Byte
#define CAN0RXERR_RXERR0                _CAN0RXERR.Bits.RXERR0
#define CAN0RXERR_RXERR1                _CAN0RXERR.Bits.RXERR1
#define CAN0RXERR_RXERR2                _CAN0RXERR.Bits.RXERR2
#define CAN0RXERR_RXERR3                _CAN0RXERR.Bits.RXERR3
#define CAN0RXERR_RXERR4                _CAN0RXERR.Bits.RXERR4
#define CAN0RXERR_RXERR5                _CAN0RXERR.Bits.RXERR5
#define CAN0RXERR_RXERR6                _CAN0RXERR.Bits.RXERR6
#define CAN0RXERR_RXERR7                _CAN0RXERR.Bits.RXERR7

#define CAN0RXERR_RXERR0_MASK           1U
#define CAN0RXERR_RXERR1_MASK           2U
#define CAN0RXERR_RXERR2_MASK           4U
#define CAN0RXERR_RXERR3_MASK           8U
#define CAN0RXERR_RXERR4_MASK           16U
#define CAN0RXERR_RXERR5_MASK           32U
#define CAN0RXERR_RXERR6_MASK           64U
#define CAN0RXERR_RXERR7_MASK           128U


/*** CAN0TXERR - MSCAN0 Transmit Error Counter Register; 0x0000014F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0TXERRSTR;
extern volatile CAN0TXERRSTR _CAN0TXERR @(REG_BASE + 0x0000014FUL);
#define CAN0TXERR                       _CAN0TXERR.Byte
#define CAN0TXERR_TXERR0                _CAN0TXERR.Bits.TXERR0
#define CAN0TXERR_TXERR1                _CAN0TXERR.Bits.TXERR1
#define CAN0TXERR_TXERR2                _CAN0TXERR.Bits.TXERR2
#define CAN0TXERR_TXERR3                _CAN0TXERR.Bits.TXERR3
#define CAN0TXERR_TXERR4                _CAN0TXERR.Bits.TXERR4
#define CAN0TXERR_TXERR5                _CAN0TXERR.Bits.TXERR5
#define CAN0TXERR_TXERR6                _CAN0TXERR.Bits.TXERR6
#define CAN0TXERR_TXERR7                _CAN0TXERR.Bits.TXERR7

#define CAN0TXERR_TXERR0_MASK           1U
#define CAN0TXERR_TXERR1_MASK           2U
#define CAN0TXERR_TXERR2_MASK           4U
#define CAN0TXERR_TXERR3_MASK           8U
#define CAN0TXERR_TXERR4_MASK           16U
#define CAN0TXERR_TXERR5_MASK           32U
#define CAN0TXERR_TXERR6_MASK           64U
#define CAN0TXERR_TXERR7_MASK           128U


/*** CAN0IDAR0 - MSCAN0 Identifier Acceptance Register 0; 0x00000150 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR0STR;
extern volatile CAN0IDAR0STR _CAN0IDAR0 @(REG_BASE + 0x00000150UL);
#define CAN0IDAR0                       _CAN0IDAR0.Byte
#define CAN0IDAR0_AC0                   _CAN0IDAR0.Bits.AC0
#define CAN0IDAR0_AC1                   _CAN0IDAR0.Bits.AC1
#define CAN0IDAR0_AC2                   _CAN0IDAR0.Bits.AC2
#define CAN0IDAR0_AC3                   _CAN0IDAR0.Bits.AC3
#define CAN0IDAR0_AC4                   _CAN0IDAR0.Bits.AC4
#define CAN0IDAR0_AC5                   _CAN0IDAR0.Bits.AC5
#define CAN0IDAR0_AC6                   _CAN0IDAR0.Bits.AC6
#define CAN0IDAR0_AC7                   _CAN0IDAR0.Bits.AC7
/* CAN0IDAR_ARR: Access 4 CAN0IDARx registers in an array */
#define CAN0IDAR_ARR                    ((volatile byte *) &CAN0IDAR0)

#define CAN0IDAR0_AC0_MASK              1U
#define CAN0IDAR0_AC1_MASK              2U
#define CAN0IDAR0_AC2_MASK              4U
#define CAN0IDAR0_AC3_MASK              8U
#define CAN0IDAR0_AC4_MASK              16U
#define CAN0IDAR0_AC5_MASK              32U
#define CAN0IDAR0_AC6_MASK              64U
#define CAN0IDAR0_AC7_MASK              128U


/*** CAN0IDAR1 - MSCAN0 Identifier Acceptance Register 1; 0x00000151 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR1STR;
extern volatile CAN0IDAR1STR _CAN0IDAR1 @(REG_BASE + 0x00000151UL);
#define CAN0IDAR1                       _CAN0IDAR1.Byte
#define CAN0IDAR1_AC0                   _CAN0IDAR1.Bits.AC0
#define CAN0IDAR1_AC1                   _CAN0IDAR1.Bits.AC1
#define CAN0IDAR1_AC2                   _CAN0IDAR1.Bits.AC2
#define CAN0IDAR1_AC3                   _CAN0IDAR1.Bits.AC3
#define CAN0IDAR1_AC4                   _CAN0IDAR1.Bits.AC4
#define CAN0IDAR1_AC5                   _CAN0IDAR1.Bits.AC5
#define CAN0IDAR1_AC6                   _CAN0IDAR1.Bits.AC6
#define CAN0IDAR1_AC7                   _CAN0IDAR1.Bits.AC7

#define CAN0IDAR1_AC0_MASK              1U
#define CAN0IDAR1_AC1_MASK              2U
#define CAN0IDAR1_AC2_MASK              4U
#define CAN0IDAR1_AC3_MASK              8U
#define CAN0IDAR1_AC4_MASK              16U
#define CAN0IDAR1_AC5_MASK              32U
#define CAN0IDAR1_AC6_MASK              64U
#define CAN0IDAR1_AC7_MASK              128U


/*** CAN0IDAR2 - MSCAN0 Identifier Acceptance Register 2; 0x00000152 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR2STR;
extern volatile CAN0IDAR2STR _CAN0IDAR2 @(REG_BASE + 0x00000152UL);
#define CAN0IDAR2                       _CAN0IDAR2.Byte
#define CAN0IDAR2_AC0                   _CAN0IDAR2.Bits.AC0
#define CAN0IDAR2_AC1                   _CAN0IDAR2.Bits.AC1
#define CAN0IDAR2_AC2                   _CAN0IDAR2.Bits.AC2
#define CAN0IDAR2_AC3                   _CAN0IDAR2.Bits.AC3
#define CAN0IDAR2_AC4                   _CAN0IDAR2.Bits.AC4
#define CAN0IDAR2_AC5                   _CAN0IDAR2.Bits.AC5
#define CAN0IDAR2_AC6                   _CAN0IDAR2.Bits.AC6
#define CAN0IDAR2_AC7                   _CAN0IDAR2.Bits.AC7

#define CAN0IDAR2_AC0_MASK              1U
#define CAN0IDAR2_AC1_MASK              2U
#define CAN0IDAR2_AC2_MASK              4U
#define CAN0IDAR2_AC3_MASK              8U
#define CAN0IDAR2_AC4_MASK              16U
#define CAN0IDAR2_AC5_MASK              32U
#define CAN0IDAR2_AC6_MASK              64U
#define CAN0IDAR2_AC7_MASK              128U


/*** CAN0IDAR3 - MSCAN0 Identifier Acceptance Register 3; 0x00000153 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR3STR;
extern volatile CAN0IDAR3STR _CAN0IDAR3 @(REG_BASE + 0x00000153UL);
#define CAN0IDAR3                       _CAN0IDAR3.Byte
#define CAN0IDAR3_AC0                   _CAN0IDAR3.Bits.AC0
#define CAN0IDAR3_AC1                   _CAN0IDAR3.Bits.AC1
#define CAN0IDAR3_AC2                   _CAN0IDAR3.Bits.AC2
#define CAN0IDAR3_AC3                   _CAN0IDAR3.Bits.AC3
#define CAN0IDAR3_AC4                   _CAN0IDAR3.Bits.AC4
#define CAN0IDAR3_AC5                   _CAN0IDAR3.Bits.AC5
#define CAN0IDAR3_AC6                   _CAN0IDAR3.Bits.AC6
#define CAN0IDAR3_AC7                   _CAN0IDAR3.Bits.AC7

#define CAN0IDAR3_AC0_MASK              1U
#define CAN0IDAR3_AC1_MASK              2U
#define CAN0IDAR3_AC2_MASK              4U
#define CAN0IDAR3_AC3_MASK              8U
#define CAN0IDAR3_AC4_MASK              16U
#define CAN0IDAR3_AC5_MASK              32U
#define CAN0IDAR3_AC6_MASK              64U
#define CAN0IDAR3_AC7_MASK              128U


/*** CAN0IDMR0 - MSCAN0 Identifier Mask Register 0; 0x00000154 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR0STR;
extern volatile CAN0IDMR0STR _CAN0IDMR0 @(REG_BASE + 0x00000154UL);
#define CAN0IDMR0                       _CAN0IDMR0.Byte
#define CAN0IDMR0_AM0                   _CAN0IDMR0.Bits.AM0
#define CAN0IDMR0_AM1                   _CAN0IDMR0.Bits.AM1
#define CAN0IDMR0_AM2                   _CAN0IDMR0.Bits.AM2
#define CAN0IDMR0_AM3                   _CAN0IDMR0.Bits.AM3
#define CAN0IDMR0_AM4                   _CAN0IDMR0.Bits.AM4
#define CAN0IDMR0_AM5                   _CAN0IDMR0.Bits.AM5
#define CAN0IDMR0_AM6                   _CAN0IDMR0.Bits.AM6
#define CAN0IDMR0_AM7                   _CAN0IDMR0.Bits.AM7
/* CAN0IDMR_ARR: Access 4 CAN0IDMRx registers in an array */
#define CAN0IDMR_ARR                    ((volatile byte *) &CAN0IDMR0)

#define CAN0IDMR0_AM0_MASK              1U
#define CAN0IDMR0_AM1_MASK              2U
#define CAN0IDMR0_AM2_MASK              4U
#define CAN0IDMR0_AM3_MASK              8U
#define CAN0IDMR0_AM4_MASK              16U
#define CAN0IDMR0_AM5_MASK              32U
#define CAN0IDMR0_AM6_MASK              64U
#define CAN0IDMR0_AM7_MASK              128U


/*** CAN0IDMR1 - MSCAN0 Identifier Mask Register 1; 0x00000155 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR1STR;
extern volatile CAN0IDMR1STR _CAN0IDMR1 @(REG_BASE + 0x00000155UL);
#define CAN0IDMR1                       _CAN0IDMR1.Byte
#define CAN0IDMR1_AM0                   _CAN0IDMR1.Bits.AM0
#define CAN0IDMR1_AM1                   _CAN0IDMR1.Bits.AM1
#define CAN0IDMR1_AM2                   _CAN0IDMR1.Bits.AM2
#define CAN0IDMR1_AM3                   _CAN0IDMR1.Bits.AM3
#define CAN0IDMR1_AM4                   _CAN0IDMR1.Bits.AM4
#define CAN0IDMR1_AM5                   _CAN0IDMR1.Bits.AM5
#define CAN0IDMR1_AM6                   _CAN0IDMR1.Bits.AM6
#define CAN0IDMR1_AM7                   _CAN0IDMR1.Bits.AM7

#define CAN0IDMR1_AM0_MASK              1U
#define CAN0IDMR1_AM1_MASK              2U
#define CAN0IDMR1_AM2_MASK              4U
#define CAN0IDMR1_AM3_MASK              8U
#define CAN0IDMR1_AM4_MASK              16U
#define CAN0IDMR1_AM5_MASK              32U
#define CAN0IDMR1_AM6_MASK              64U
#define CAN0IDMR1_AM7_MASK              128U


/*** CAN0IDMR2 - MSCAN0 Identifier Mask Register 2; 0x00000156 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR2STR;
extern volatile CAN0IDMR2STR _CAN0IDMR2 @(REG_BASE + 0x00000156UL);
#define CAN0IDMR2                       _CAN0IDMR2.Byte
#define CAN0IDMR2_AM0                   _CAN0IDMR2.Bits.AM0
#define CAN0IDMR2_AM1                   _CAN0IDMR2.Bits.AM1
#define CAN0IDMR2_AM2                   _CAN0IDMR2.Bits.AM2
#define CAN0IDMR2_AM3                   _CAN0IDMR2.Bits.AM3
#define CAN0IDMR2_AM4                   _CAN0IDMR2.Bits.AM4
#define CAN0IDMR2_AM5                   _CAN0IDMR2.Bits.AM5
#define CAN0IDMR2_AM6                   _CAN0IDMR2.Bits.AM6
#define CAN0IDMR2_AM7                   _CAN0IDMR2.Bits.AM7

#define CAN0IDMR2_AM0_MASK              1U
#define CAN0IDMR2_AM1_MASK              2U
#define CAN0IDMR2_AM2_MASK              4U
#define CAN0IDMR2_AM3_MASK              8U
#define CAN0IDMR2_AM4_MASK              16U
#define CAN0IDMR2_AM5_MASK              32U
#define CAN0IDMR2_AM6_MASK              64U
#define CAN0IDMR2_AM7_MASK              128U


/*** CAN0IDMR3 - MSCAN0 Identifier Mask Register 3; 0x00000157 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR3STR;
extern volatile CAN0IDMR3STR _CAN0IDMR3 @(REG_BASE + 0x00000157UL);
#define CAN0IDMR3                       _CAN0IDMR3.Byte
#define CAN0IDMR3_AM0                   _CAN0IDMR3.Bits.AM0
#define CAN0IDMR3_AM1                   _CAN0IDMR3.Bits.AM1
#define CAN0IDMR3_AM2                   _CAN0IDMR3.Bits.AM2
#define CAN0IDMR3_AM3                   _CAN0IDMR3.Bits.AM3
#define CAN0IDMR3_AM4                   _CAN0IDMR3.Bits.AM4
#define CAN0IDMR3_AM5                   _CAN0IDMR3.Bits.AM5
#define CAN0IDMR3_AM6                   _CAN0IDMR3.Bits.AM6
#define CAN0IDMR3_AM7                   _CAN0IDMR3.Bits.AM7

#define CAN0IDMR3_AM0_MASK              1U
#define CAN0IDMR3_AM1_MASK              2U
#define CAN0IDMR3_AM2_MASK              4U
#define CAN0IDMR3_AM3_MASK              8U
#define CAN0IDMR3_AM4_MASK              16U
#define CAN0IDMR3_AM5_MASK              32U
#define CAN0IDMR3_AM6_MASK              64U
#define CAN0IDMR3_AM7_MASK              128U


/*** CAN0IDAR4 - MSCAN0 Identifier Acceptance Register 4; 0x00000158 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR4STR;
extern volatile CAN0IDAR4STR _CAN0IDAR4 @(REG_BASE + 0x00000158UL);
#define CAN0IDAR4                       _CAN0IDAR4.Byte
#define CAN0IDAR4_AC0                   _CAN0IDAR4.Bits.AC0
#define CAN0IDAR4_AC1                   _CAN0IDAR4.Bits.AC1
#define CAN0IDAR4_AC2                   _CAN0IDAR4.Bits.AC2
#define CAN0IDAR4_AC3                   _CAN0IDAR4.Bits.AC3
#define CAN0IDAR4_AC4                   _CAN0IDAR4.Bits.AC4
#define CAN0IDAR4_AC5                   _CAN0IDAR4.Bits.AC5
#define CAN0IDAR4_AC6                   _CAN0IDAR4.Bits.AC6
#define CAN0IDAR4_AC7                   _CAN0IDAR4.Bits.AC7

#define CAN0IDAR4_AC0_MASK              1U
#define CAN0IDAR4_AC1_MASK              2U
#define CAN0IDAR4_AC2_MASK              4U
#define CAN0IDAR4_AC3_MASK              8U
#define CAN0IDAR4_AC4_MASK              16U
#define CAN0IDAR4_AC5_MASK              32U
#define CAN0IDAR4_AC6_MASK              64U
#define CAN0IDAR4_AC7_MASK              128U


/*** CAN0IDAR5 - MSCAN0 Identifier Acceptance Register 5; 0x00000159 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR5STR;
extern volatile CAN0IDAR5STR _CAN0IDAR5 @(REG_BASE + 0x00000159UL);
#define CAN0IDAR5                       _CAN0IDAR5.Byte
#define CAN0IDAR5_AC0                   _CAN0IDAR5.Bits.AC0
#define CAN0IDAR5_AC1                   _CAN0IDAR5.Bits.AC1
#define CAN0IDAR5_AC2                   _CAN0IDAR5.Bits.AC2
#define CAN0IDAR5_AC3                   _CAN0IDAR5.Bits.AC3
#define CAN0IDAR5_AC4                   _CAN0IDAR5.Bits.AC4
#define CAN0IDAR5_AC5                   _CAN0IDAR5.Bits.AC5
#define CAN0IDAR5_AC6                   _CAN0IDAR5.Bits.AC6
#define CAN0IDAR5_AC7                   _CAN0IDAR5.Bits.AC7

#define CAN0IDAR5_AC0_MASK              1U
#define CAN0IDAR5_AC1_MASK              2U
#define CAN0IDAR5_AC2_MASK              4U
#define CAN0IDAR5_AC3_MASK              8U
#define CAN0IDAR5_AC4_MASK              16U
#define CAN0IDAR5_AC5_MASK              32U
#define CAN0IDAR5_AC6_MASK              64U
#define CAN0IDAR5_AC7_MASK              128U


/*** CAN0IDAR6 - MSCAN0 Identifier Acceptance Register 6; 0x0000015A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR6STR;
extern volatile CAN0IDAR6STR _CAN0IDAR6 @(REG_BASE + 0x0000015AUL);
#define CAN0IDAR6                       _CAN0IDAR6.Byte
#define CAN0IDAR6_AC0                   _CAN0IDAR6.Bits.AC0
#define CAN0IDAR6_AC1                   _CAN0IDAR6.Bits.AC1
#define CAN0IDAR6_AC2                   _CAN0IDAR6.Bits.AC2
#define CAN0IDAR6_AC3                   _CAN0IDAR6.Bits.AC3
#define CAN0IDAR6_AC4                   _CAN0IDAR6.Bits.AC4
#define CAN0IDAR6_AC5                   _CAN0IDAR6.Bits.AC5
#define CAN0IDAR6_AC6                   _CAN0IDAR6.Bits.AC6
#define CAN0IDAR6_AC7                   _CAN0IDAR6.Bits.AC7

#define CAN0IDAR6_AC0_MASK              1U
#define CAN0IDAR6_AC1_MASK              2U
#define CAN0IDAR6_AC2_MASK              4U
#define CAN0IDAR6_AC3_MASK              8U
#define CAN0IDAR6_AC4_MASK              16U
#define CAN0IDAR6_AC5_MASK              32U
#define CAN0IDAR6_AC6_MASK              64U
#define CAN0IDAR6_AC7_MASK              128U


/*** CAN0IDAR7 - MSCAN0 Identifier Acceptance Register 7; 0x0000015B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR7STR;
extern volatile CAN0IDAR7STR _CAN0IDAR7 @(REG_BASE + 0x0000015BUL);
#define CAN0IDAR7                       _CAN0IDAR7.Byte
#define CAN0IDAR7_AC0                   _CAN0IDAR7.Bits.AC0
#define CAN0IDAR7_AC1                   _CAN0IDAR7.Bits.AC1
#define CAN0IDAR7_AC2                   _CAN0IDAR7.Bits.AC2
#define CAN0IDAR7_AC3                   _CAN0IDAR7.Bits.AC3
#define CAN0IDAR7_AC4                   _CAN0IDAR7.Bits.AC4
#define CAN0IDAR7_AC5                   _CAN0IDAR7.Bits.AC5
#define CAN0IDAR7_AC6                   _CAN0IDAR7.Bits.AC6
#define CAN0IDAR7_AC7                   _CAN0IDAR7.Bits.AC7

#define CAN0IDAR7_AC0_MASK              1U
#define CAN0IDAR7_AC1_MASK              2U
#define CAN0IDAR7_AC2_MASK              4U
#define CAN0IDAR7_AC3_MASK              8U
#define CAN0IDAR7_AC4_MASK              16U
#define CAN0IDAR7_AC5_MASK              32U
#define CAN0IDAR7_AC6_MASK              64U
#define CAN0IDAR7_AC7_MASK              128U


/*** CAN0IDMR4 - MSCAN0 Identifier Mask Register 4; 0x0000015C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR4STR;
extern volatile CAN0IDMR4STR _CAN0IDMR4 @(REG_BASE + 0x0000015CUL);
#define CAN0IDMR4                       _CAN0IDMR4.Byte
#define CAN0IDMR4_AM0                   _CAN0IDMR4.Bits.AM0
#define CAN0IDMR4_AM1                   _CAN0IDMR4.Bits.AM1
#define CAN0IDMR4_AM2                   _CAN0IDMR4.Bits.AM2
#define CAN0IDMR4_AM3                   _CAN0IDMR4.Bits.AM3
#define CAN0IDMR4_AM4                   _CAN0IDMR4.Bits.AM4
#define CAN0IDMR4_AM5                   _CAN0IDMR4.Bits.AM5
#define CAN0IDMR4_AM6                   _CAN0IDMR4.Bits.AM6
#define CAN0IDMR4_AM7                   _CAN0IDMR4.Bits.AM7

#define CAN0IDMR4_AM0_MASK              1U
#define CAN0IDMR4_AM1_MASK              2U
#define CAN0IDMR4_AM2_MASK              4U
#define CAN0IDMR4_AM3_MASK              8U
#define CAN0IDMR4_AM4_MASK              16U
#define CAN0IDMR4_AM5_MASK              32U
#define CAN0IDMR4_AM6_MASK              64U
#define CAN0IDMR4_AM7_MASK              128U


/*** CAN0IDMR5 - MSCAN0 Identifier Mask Register 5; 0x0000015D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR5STR;
extern volatile CAN0IDMR5STR _CAN0IDMR5 @(REG_BASE + 0x0000015DUL);
#define CAN0IDMR5                       _CAN0IDMR5.Byte
#define CAN0IDMR5_AM0                   _CAN0IDMR5.Bits.AM0
#define CAN0IDMR5_AM1                   _CAN0IDMR5.Bits.AM1
#define CAN0IDMR5_AM2                   _CAN0IDMR5.Bits.AM2
#define CAN0IDMR5_AM3                   _CAN0IDMR5.Bits.AM3
#define CAN0IDMR5_AM4                   _CAN0IDMR5.Bits.AM4
#define CAN0IDMR5_AM5                   _CAN0IDMR5.Bits.AM5
#define CAN0IDMR5_AM6                   _CAN0IDMR5.Bits.AM6
#define CAN0IDMR5_AM7                   _CAN0IDMR5.Bits.AM7

#define CAN0IDMR5_AM0_MASK              1U
#define CAN0IDMR5_AM1_MASK              2U
#define CAN0IDMR5_AM2_MASK              4U
#define CAN0IDMR5_AM3_MASK              8U
#define CAN0IDMR5_AM4_MASK              16U
#define CAN0IDMR5_AM5_MASK              32U
#define CAN0IDMR5_AM6_MASK              64U
#define CAN0IDMR5_AM7_MASK              128U


/*** CAN0IDMR6 - MSCAN0 Identifier Mask Register 6; 0x0000015E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR6STR;
extern volatile CAN0IDMR6STR _CAN0IDMR6 @(REG_BASE + 0x0000015EUL);
#define CAN0IDMR6                       _CAN0IDMR6.Byte
#define CAN0IDMR6_AM0                   _CAN0IDMR6.Bits.AM0
#define CAN0IDMR6_AM1                   _CAN0IDMR6.Bits.AM1
#define CAN0IDMR6_AM2                   _CAN0IDMR6.Bits.AM2
#define CAN0IDMR6_AM3                   _CAN0IDMR6.Bits.AM3
#define CAN0IDMR6_AM4                   _CAN0IDMR6.Bits.AM4
#define CAN0IDMR6_AM5                   _CAN0IDMR6.Bits.AM5
#define CAN0IDMR6_AM6                   _CAN0IDMR6.Bits.AM6
#define CAN0IDMR6_AM7                   _CAN0IDMR6.Bits.AM7

#define CAN0IDMR6_AM0_MASK              1U
#define CAN0IDMR6_AM1_MASK              2U
#define CAN0IDMR6_AM2_MASK              4U
#define CAN0IDMR6_AM3_MASK              8U
#define CAN0IDMR6_AM4_MASK              16U
#define CAN0IDMR6_AM5_MASK              32U
#define CAN0IDMR6_AM6_MASK              64U
#define CAN0IDMR6_AM7_MASK              128U


/*** CAN0IDMR7 - MSCAN0 Identifier Mask Register 7; 0x0000015F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR7STR;
extern volatile CAN0IDMR7STR _CAN0IDMR7 @(REG_BASE + 0x0000015FUL);
#define CAN0IDMR7                       _CAN0IDMR7.Byte
#define CAN0IDMR7_AM0                   _CAN0IDMR7.Bits.AM0
#define CAN0IDMR7_AM1                   _CAN0IDMR7.Bits.AM1
#define CAN0IDMR7_AM2                   _CAN0IDMR7.Bits.AM2
#define CAN0IDMR7_AM3                   _CAN0IDMR7.Bits.AM3
#define CAN0IDMR7_AM4                   _CAN0IDMR7.Bits.AM4
#define CAN0IDMR7_AM5                   _CAN0IDMR7.Bits.AM5
#define CAN0IDMR7_AM6                   _CAN0IDMR7.Bits.AM6
#define CAN0IDMR7_AM7                   _CAN0IDMR7.Bits.AM7

#define CAN0IDMR7_AM0_MASK              1U
#define CAN0IDMR7_AM1_MASK              2U
#define CAN0IDMR7_AM2_MASK              4U
#define CAN0IDMR7_AM3_MASK              8U
#define CAN0IDMR7_AM4_MASK              16U
#define CAN0IDMR7_AM5_MASK              32U
#define CAN0IDMR7_AM6_MASK              64U
#define CAN0IDMR7_AM7_MASK              128U


/*** CAN0RXIDR0 - MSCAN0 Receive Identifier Register 0; 0x00000160 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0RXIDR0STR;
extern volatile CAN0RXIDR0STR _CAN0RXIDR0 @(REG_BASE + 0x00000160UL);
#define CAN0RXIDR0                      _CAN0RXIDR0.Byte
#define CAN0RXIDR0_ID21                 _CAN0RXIDR0.Bits.ID21
#define CAN0RXIDR0_ID22                 _CAN0RXIDR0.Bits.ID22
#define CAN0RXIDR0_ID23                 _CAN0RXIDR0.Bits.ID23
#define CAN0RXIDR0_ID24                 _CAN0RXIDR0.Bits.ID24
#define CAN0RXIDR0_ID25                 _CAN0RXIDR0.Bits.ID25
#define CAN0RXIDR0_ID26                 _CAN0RXIDR0.Bits.ID26
#define CAN0RXIDR0_ID27                 _CAN0RXIDR0.Bits.ID27
#define CAN0RXIDR0_ID28                 _CAN0RXIDR0.Bits.ID28
/* CAN0RXIDR_ARR: Access 4 CAN0RXIDRx registers in an array */
#define CAN0RXIDR_ARR                   ((volatile byte *) &CAN0RXIDR0)

#define CAN0RXIDR0_ID21_MASK            1U
#define CAN0RXIDR0_ID22_MASK            2U
#define CAN0RXIDR0_ID23_MASK            4U
#define CAN0RXIDR0_ID24_MASK            8U
#define CAN0RXIDR0_ID25_MASK            16U
#define CAN0RXIDR0_ID26_MASK            32U
#define CAN0RXIDR0_ID27_MASK            64U
#define CAN0RXIDR0_ID28_MASK            128U


/*** CAN0RXIDR1 - MSCAN0 Receive Identifier Register 1; 0x00000161 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0RXIDR1STR;
extern volatile CAN0RXIDR1STR _CAN0RXIDR1 @(REG_BASE + 0x00000161UL);
#define CAN0RXIDR1                      _CAN0RXIDR1.Byte
#define CAN0RXIDR1_ID15                 _CAN0RXIDR1.Bits.ID15
#define CAN0RXIDR1_ID16                 _CAN0RXIDR1.Bits.ID16
#define CAN0RXIDR1_ID17                 _CAN0RXIDR1.Bits.ID17
#define CAN0RXIDR1_IDE                  _CAN0RXIDR1.Bits.IDE
#define CAN0RXIDR1_SRR                  _CAN0RXIDR1.Bits.SRR
#define CAN0RXIDR1_ID18                 _CAN0RXIDR1.Bits.ID18
#define CAN0RXIDR1_ID19                 _CAN0RXIDR1.Bits.ID19
#define CAN0RXIDR1_ID20                 _CAN0RXIDR1.Bits.ID20
#define CAN0RXIDR1_ID_15                _CAN0RXIDR1.MergedBits.grpID_15
#define CAN0RXIDR1_ID_18                _CAN0RXIDR1.MergedBits.grpID_18
#define CAN0RXIDR1_ID                   CAN0RXIDR1_ID_15

#define CAN0RXIDR1_ID15_MASK            1U
#define CAN0RXIDR1_ID16_MASK            2U
#define CAN0RXIDR1_ID17_MASK            4U
#define CAN0RXIDR1_IDE_MASK             8U
#define CAN0RXIDR1_SRR_MASK             16U
#define CAN0RXIDR1_ID18_MASK            32U
#define CAN0RXIDR1_ID19_MASK            64U
#define CAN0RXIDR1_ID20_MASK            128U
#define CAN0RXIDR1_ID_15_MASK           7U
#define CAN0RXIDR1_ID_15_BITNUM         0U
#define CAN0RXIDR1_ID_18_MASK           224U
#define CAN0RXIDR1_ID_18_BITNUM         5U


/*** CAN0RXIDR2 - MSCAN0 Receive Identifier Register 2; 0x00000162 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0RXIDR2STR;
extern volatile CAN0RXIDR2STR _CAN0RXIDR2 @(REG_BASE + 0x00000162UL);
#define CAN0RXIDR2                      _CAN0RXIDR2.Byte
#define CAN0RXIDR2_ID7                  _CAN0RXIDR2.Bits.ID7
#define CAN0RXIDR2_ID8                  _CAN0RXIDR2.Bits.ID8
#define CAN0RXIDR2_ID9                  _CAN0RXIDR2.Bits.ID9
#define CAN0RXIDR2_ID10                 _CAN0RXIDR2.Bits.ID10
#define CAN0RXIDR2_ID11                 _CAN0RXIDR2.Bits.ID11
#define CAN0RXIDR2_ID12                 _CAN0RXIDR2.Bits.ID12
#define CAN0RXIDR2_ID13                 _CAN0RXIDR2.Bits.ID13
#define CAN0RXIDR2_ID14                 _CAN0RXIDR2.Bits.ID14

#define CAN0RXIDR2_ID7_MASK             1U
#define CAN0RXIDR2_ID8_MASK             2U
#define CAN0RXIDR2_ID9_MASK             4U
#define CAN0RXIDR2_ID10_MASK            8U
#define CAN0RXIDR2_ID11_MASK            16U
#define CAN0RXIDR2_ID12_MASK            32U
#define CAN0RXIDR2_ID13_MASK            64U
#define CAN0RXIDR2_ID14_MASK            128U


/*** CAN0RXIDR3 - MSCAN0 Receive Identifier Register 3; 0x00000163 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0RXIDR3STR;
extern volatile CAN0RXIDR3STR _CAN0RXIDR3 @(REG_BASE + 0x00000163UL);
#define CAN0RXIDR3                      _CAN0RXIDR3.Byte
#define CAN0RXIDR3_RTR                  _CAN0RXIDR3.Bits.RTR
#define CAN0RXIDR3_ID0                  _CAN0RXIDR3.Bits.ID0
#define CAN0RXIDR3_ID1                  _CAN0RXIDR3.Bits.ID1
#define CAN0RXIDR3_ID2                  _CAN0RXIDR3.Bits.ID2
#define CAN0RXIDR3_ID3                  _CAN0RXIDR3.Bits.ID3
#define CAN0RXIDR3_ID4                  _CAN0RXIDR3.Bits.ID4
#define CAN0RXIDR3_ID5                  _CAN0RXIDR3.Bits.ID5
#define CAN0RXIDR3_ID6                  _CAN0RXIDR3.Bits.ID6
#define CAN0RXIDR3_ID                   _CAN0RXIDR3.MergedBits.grpID

#define CAN0RXIDR3_RTR_MASK             1U
#define CAN0RXIDR3_ID0_MASK             2U
#define CAN0RXIDR3_ID1_MASK             4U
#define CAN0RXIDR3_ID2_MASK             8U
#define CAN0RXIDR3_ID3_MASK             16U
#define CAN0RXIDR3_ID4_MASK             32U
#define CAN0RXIDR3_ID5_MASK             64U
#define CAN0RXIDR3_ID6_MASK             128U
#define CAN0RXIDR3_ID_MASK              254U
#define CAN0RXIDR3_ID_BITNUM            1U


/*** CAN0RXDSR0 - MSCAN0 Receive Data Segment Register 0; 0x00000164 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR0STR;
extern volatile CAN0RXDSR0STR _CAN0RXDSR0 @(REG_BASE + 0x00000164UL);
#define CAN0RXDSR0                      _CAN0RXDSR0.Byte
#define CAN0RXDSR0_DB0                  _CAN0RXDSR0.Bits.DB0
#define CAN0RXDSR0_DB1                  _CAN0RXDSR0.Bits.DB1
#define CAN0RXDSR0_DB2                  _CAN0RXDSR0.Bits.DB2
#define CAN0RXDSR0_DB3                  _CAN0RXDSR0.Bits.DB3
#define CAN0RXDSR0_DB4                  _CAN0RXDSR0.Bits.DB4
#define CAN0RXDSR0_DB5                  _CAN0RXDSR0.Bits.DB5
#define CAN0RXDSR0_DB6                  _CAN0RXDSR0.Bits.DB6
#define CAN0RXDSR0_DB7                  _CAN0RXDSR0.Bits.DB7
/* CAN0RXDSR_ARR: Access 8 CAN0RXDSRx registers in an array */
#define CAN0RXDSR_ARR                   ((volatile byte *) &CAN0RXDSR0)

#define CAN0RXDSR0_DB0_MASK             1U
#define CAN0RXDSR0_DB1_MASK             2U
#define CAN0RXDSR0_DB2_MASK             4U
#define CAN0RXDSR0_DB3_MASK             8U
#define CAN0RXDSR0_DB4_MASK             16U
#define CAN0RXDSR0_DB5_MASK             32U
#define CAN0RXDSR0_DB6_MASK             64U
#define CAN0RXDSR0_DB7_MASK             128U


/*** CAN0RXDSR1 - MSCAN0 Receive Data Segment Register 1; 0x00000165 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR1STR;
extern volatile CAN0RXDSR1STR _CAN0RXDSR1 @(REG_BASE + 0x00000165UL);
#define CAN0RXDSR1                      _CAN0RXDSR1.Byte
#define CAN0RXDSR1_DB0                  _CAN0RXDSR1.Bits.DB0
#define CAN0RXDSR1_DB1                  _CAN0RXDSR1.Bits.DB1
#define CAN0RXDSR1_DB2                  _CAN0RXDSR1.Bits.DB2
#define CAN0RXDSR1_DB3                  _CAN0RXDSR1.Bits.DB3
#define CAN0RXDSR1_DB4                  _CAN0RXDSR1.Bits.DB4
#define CAN0RXDSR1_DB5                  _CAN0RXDSR1.Bits.DB5
#define CAN0RXDSR1_DB6                  _CAN0RXDSR1.Bits.DB6
#define CAN0RXDSR1_DB7                  _CAN0RXDSR1.Bits.DB7

#define CAN0RXDSR1_DB0_MASK             1U
#define CAN0RXDSR1_DB1_MASK             2U
#define CAN0RXDSR1_DB2_MASK             4U
#define CAN0RXDSR1_DB3_MASK             8U
#define CAN0RXDSR1_DB4_MASK             16U
#define CAN0RXDSR1_DB5_MASK             32U
#define CAN0RXDSR1_DB6_MASK             64U
#define CAN0RXDSR1_DB7_MASK             128U


/*** CAN0RXDSR2 - MSCAN0 Receive Data Segment Register 2; 0x00000166 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR2STR;
extern volatile CAN0RXDSR2STR _CAN0RXDSR2 @(REG_BASE + 0x00000166UL);
#define CAN0RXDSR2                      _CAN0RXDSR2.Byte
#define CAN0RXDSR2_DB0                  _CAN0RXDSR2.Bits.DB0
#define CAN0RXDSR2_DB1                  _CAN0RXDSR2.Bits.DB1
#define CAN0RXDSR2_DB2                  _CAN0RXDSR2.Bits.DB2
#define CAN0RXDSR2_DB3                  _CAN0RXDSR2.Bits.DB3
#define CAN0RXDSR2_DB4                  _CAN0RXDSR2.Bits.DB4
#define CAN0RXDSR2_DB5                  _CAN0RXDSR2.Bits.DB5
#define CAN0RXDSR2_DB6                  _CAN0RXDSR2.Bits.DB6
#define CAN0RXDSR2_DB7                  _CAN0RXDSR2.Bits.DB7

#define CAN0RXDSR2_DB0_MASK             1U
#define CAN0RXDSR2_DB1_MASK             2U
#define CAN0RXDSR2_DB2_MASK             4U
#define CAN0RXDSR2_DB3_MASK             8U
#define CAN0RXDSR2_DB4_MASK             16U
#define CAN0RXDSR2_DB5_MASK             32U
#define CAN0RXDSR2_DB6_MASK             64U
#define CAN0RXDSR2_DB7_MASK             128U


/*** CAN0RXDSR3 - MSCAN0 Receive Data Segment Register 3; 0x00000167 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR3STR;
extern volatile CAN0RXDSR3STR _CAN0RXDSR3 @(REG_BASE + 0x00000167UL);
#define CAN0RXDSR3                      _CAN0RXDSR3.Byte
#define CAN0RXDSR3_DB0                  _CAN0RXDSR3.Bits.DB0
#define CAN0RXDSR3_DB1                  _CAN0RXDSR3.Bits.DB1
#define CAN0RXDSR3_DB2                  _CAN0RXDSR3.Bits.DB2
#define CAN0RXDSR3_DB3                  _CAN0RXDSR3.Bits.DB3
#define CAN0RXDSR3_DB4                  _CAN0RXDSR3.Bits.DB4
#define CAN0RXDSR3_DB5                  _CAN0RXDSR3.Bits.DB5
#define CAN0RXDSR3_DB6                  _CAN0RXDSR3.Bits.DB6
#define CAN0RXDSR3_DB7                  _CAN0RXDSR3.Bits.DB7

#define CAN0RXDSR3_DB0_MASK             1U
#define CAN0RXDSR3_DB1_MASK             2U
#define CAN0RXDSR3_DB2_MASK             4U
#define CAN0RXDSR3_DB3_MASK             8U
#define CAN0RXDSR3_DB4_MASK             16U
#define CAN0RXDSR3_DB5_MASK             32U
#define CAN0RXDSR3_DB6_MASK             64U
#define CAN0RXDSR3_DB7_MASK             128U


/*** CAN0RXDSR4 - MSCAN0 Receive Data Segment Register 4; 0x00000168 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR4STR;
extern volatile CAN0RXDSR4STR _CAN0RXDSR4 @(REG_BASE + 0x00000168UL);
#define CAN0RXDSR4                      _CAN0RXDSR4.Byte
#define CAN0RXDSR4_DB0                  _CAN0RXDSR4.Bits.DB0
#define CAN0RXDSR4_DB1                  _CAN0RXDSR4.Bits.DB1
#define CAN0RXDSR4_DB2                  _CAN0RXDSR4.Bits.DB2
#define CAN0RXDSR4_DB3                  _CAN0RXDSR4.Bits.DB3
#define CAN0RXDSR4_DB4                  _CAN0RXDSR4.Bits.DB4
#define CAN0RXDSR4_DB5                  _CAN0RXDSR4.Bits.DB5
#define CAN0RXDSR4_DB6                  _CAN0RXDSR4.Bits.DB6
#define CAN0RXDSR4_DB7                  _CAN0RXDSR4.Bits.DB7

#define CAN0RXDSR4_DB0_MASK             1U
#define CAN0RXDSR4_DB1_MASK             2U
#define CAN0RXDSR4_DB2_MASK             4U
#define CAN0RXDSR4_DB3_MASK             8U
#define CAN0RXDSR4_DB4_MASK             16U
#define CAN0RXDSR4_DB5_MASK             32U
#define CAN0RXDSR4_DB6_MASK             64U
#define CAN0RXDSR4_DB7_MASK             128U


/*** CAN0RXDSR5 - MSCAN0 Receive Data Segment Register 5; 0x00000169 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR5STR;
extern volatile CAN0RXDSR5STR _CAN0RXDSR5 @(REG_BASE + 0x00000169UL);
#define CAN0RXDSR5                      _CAN0RXDSR5.Byte
#define CAN0RXDSR5_DB0                  _CAN0RXDSR5.Bits.DB0
#define CAN0RXDSR5_DB1                  _CAN0RXDSR5.Bits.DB1
#define CAN0RXDSR5_DB2                  _CAN0RXDSR5.Bits.DB2
#define CAN0RXDSR5_DB3                  _CAN0RXDSR5.Bits.DB3
#define CAN0RXDSR5_DB4                  _CAN0RXDSR5.Bits.DB4
#define CAN0RXDSR5_DB5                  _CAN0RXDSR5.Bits.DB5
#define CAN0RXDSR5_DB6                  _CAN0RXDSR5.Bits.DB6
#define CAN0RXDSR5_DB7                  _CAN0RXDSR5.Bits.DB7

#define CAN0RXDSR5_DB0_MASK             1U
#define CAN0RXDSR5_DB1_MASK             2U
#define CAN0RXDSR5_DB2_MASK             4U
#define CAN0RXDSR5_DB3_MASK             8U
#define CAN0RXDSR5_DB4_MASK             16U
#define CAN0RXDSR5_DB5_MASK             32U
#define CAN0RXDSR5_DB6_MASK             64U
#define CAN0RXDSR5_DB7_MASK             128U


/*** CAN0RXDSR6 - MSCAN0 Receive Data Segment Register 6; 0x0000016A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR6STR;
extern volatile CAN0RXDSR6STR _CAN0RXDSR6 @(REG_BASE + 0x0000016AUL);
#define CAN0RXDSR6                      _CAN0RXDSR6.Byte
#define CAN0RXDSR6_DB0                  _CAN0RXDSR6.Bits.DB0
#define CAN0RXDSR6_DB1                  _CAN0RXDSR6.Bits.DB1
#define CAN0RXDSR6_DB2                  _CAN0RXDSR6.Bits.DB2
#define CAN0RXDSR6_DB3                  _CAN0RXDSR6.Bits.DB3
#define CAN0RXDSR6_DB4                  _CAN0RXDSR6.Bits.DB4
#define CAN0RXDSR6_DB5                  _CAN0RXDSR6.Bits.DB5
#define CAN0RXDSR6_DB6                  _CAN0RXDSR6.Bits.DB6
#define CAN0RXDSR6_DB7                  _CAN0RXDSR6.Bits.DB7

#define CAN0RXDSR6_DB0_MASK             1U
#define CAN0RXDSR6_DB1_MASK             2U
#define CAN0RXDSR6_DB2_MASK             4U
#define CAN0RXDSR6_DB3_MASK             8U
#define CAN0RXDSR6_DB4_MASK             16U
#define CAN0RXDSR6_DB5_MASK             32U
#define CAN0RXDSR6_DB6_MASK             64U
#define CAN0RXDSR6_DB7_MASK             128U


/*** CAN0RXDSR7 - MSCAN0 Receive Data Segment Register 7; 0x0000016B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR7STR;
extern volatile CAN0RXDSR7STR _CAN0RXDSR7 @(REG_BASE + 0x0000016BUL);
#define CAN0RXDSR7                      _CAN0RXDSR7.Byte
#define CAN0RXDSR7_DB0                  _CAN0RXDSR7.Bits.DB0
#define CAN0RXDSR7_DB1                  _CAN0RXDSR7.Bits.DB1
#define CAN0RXDSR7_DB2                  _CAN0RXDSR7.Bits.DB2
#define CAN0RXDSR7_DB3                  _CAN0RXDSR7.Bits.DB3
#define CAN0RXDSR7_DB4                  _CAN0RXDSR7.Bits.DB4
#define CAN0RXDSR7_DB5                  _CAN0RXDSR7.Bits.DB5
#define CAN0RXDSR7_DB6                  _CAN0RXDSR7.Bits.DB6
#define CAN0RXDSR7_DB7                  _CAN0RXDSR7.Bits.DB7

#define CAN0RXDSR7_DB0_MASK             1U
#define CAN0RXDSR7_DB1_MASK             2U
#define CAN0RXDSR7_DB2_MASK             4U
#define CAN0RXDSR7_DB3_MASK             8U
#define CAN0RXDSR7_DB4_MASK             16U
#define CAN0RXDSR7_DB5_MASK             32U
#define CAN0RXDSR7_DB6_MASK             64U
#define CAN0RXDSR7_DB7_MASK             128U


/*** CAN0RXDLR - MSCAN0 Receive Data Length Register; 0x0000016C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RXDLRSTR;
extern volatile CAN0RXDLRSTR _CAN0RXDLR @(REG_BASE + 0x0000016CUL);
#define CAN0RXDLR                       _CAN0RXDLR.Byte
#define CAN0RXDLR_DLC0                  _CAN0RXDLR.Bits.DLC0
#define CAN0RXDLR_DLC1                  _CAN0RXDLR.Bits.DLC1
#define CAN0RXDLR_DLC2                  _CAN0RXDLR.Bits.DLC2
#define CAN0RXDLR_DLC3                  _CAN0RXDLR.Bits.DLC3
#define CAN0RXDLR_DLC                   _CAN0RXDLR.MergedBits.grpDLC

#define CAN0RXDLR_DLC0_MASK             1U
#define CAN0RXDLR_DLC1_MASK             2U
#define CAN0RXDLR_DLC2_MASK             4U
#define CAN0RXDLR_DLC3_MASK             8U
#define CAN0RXDLR_DLC_MASK              15U
#define CAN0RXDLR_DLC_BITNUM            0U


/*** CAN0RXTSR - MSCAN0 Receive Time Stamp Register; 0x0000016E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0RXTSRH - MSCAN0 Receive Time Stamp Register High; 0x0000016E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0RXTSRHSTR;
    #define CAN0RXTSRH                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Byte
    #define CAN0RXTSRH_TSR8             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR8
    #define CAN0RXTSRH_TSR9             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR9
    #define CAN0RXTSRH_TSR10            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR10
    #define CAN0RXTSRH_TSR11            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR11
    #define CAN0RXTSRH_TSR12            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR12
    #define CAN0RXTSRH_TSR13            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR13
    #define CAN0RXTSRH_TSR14            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR14
    #define CAN0RXTSRH_TSR15            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR15
    
    #define CAN0RXTSRH_TSR8_MASK        1U
    #define CAN0RXTSRH_TSR9_MASK        2U
    #define CAN0RXTSRH_TSR10_MASK       4U
    #define CAN0RXTSRH_TSR11_MASK       8U
    #define CAN0RXTSRH_TSR12_MASK       16U
    #define CAN0RXTSRH_TSR13_MASK       32U
    #define CAN0RXTSRH_TSR14_MASK       64U
    #define CAN0RXTSRH_TSR15_MASK       128U
    

    /*** CAN0RXTSRL - MSCAN0 Receive Time Stamp Register Low; 0x0000016F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0RXTSRLSTR;
    #define CAN0RXTSRL                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Byte
    #define CAN0RXTSRL_TSR0             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR0
    #define CAN0RXTSRL_TSR1             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR1
    #define CAN0RXTSRL_TSR2             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR2
    #define CAN0RXTSRL_TSR3             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR3
    #define CAN0RXTSRL_TSR4             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR4
    #define CAN0RXTSRL_TSR5             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR5
    #define CAN0RXTSRL_TSR6             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR6
    #define CAN0RXTSRL_TSR7             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR7
    
    #define CAN0RXTSRL_TSR0_MASK        1U
    #define CAN0RXTSRL_TSR1_MASK        2U
    #define CAN0RXTSRL_TSR2_MASK        4U
    #define CAN0RXTSRL_TSR3_MASK        8U
    #define CAN0RXTSRL_TSR4_MASK        16U
    #define CAN0RXTSRL_TSR5_MASK        32U
    #define CAN0RXTSRL_TSR6_MASK        64U
    #define CAN0RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0RXTSRSTR;
extern volatile CAN0RXTSRSTR _CAN0RXTSR @(REG_BASE + 0x0000016EUL);
#define CAN0RXTSR                       _CAN0RXTSR.Word
#define CAN0RXTSR_TSR0                  _CAN0RXTSR.Bits.TSR0
#define CAN0RXTSR_TSR1                  _CAN0RXTSR.Bits.TSR1
#define CAN0RXTSR_TSR2                  _CAN0RXTSR.Bits.TSR2
#define CAN0RXTSR_TSR3                  _CAN0RXTSR.Bits.TSR3
#define CAN0RXTSR_TSR4                  _CAN0RXTSR.Bits.TSR4
#define CAN0RXTSR_TSR5                  _CAN0RXTSR.Bits.TSR5
#define CAN0RXTSR_TSR6                  _CAN0RXTSR.Bits.TSR6
#define CAN0RXTSR_TSR7                  _CAN0RXTSR.Bits.TSR7
#define CAN0RXTSR_TSR8                  _CAN0RXTSR.Bits.TSR8
#define CAN0RXTSR_TSR9                  _CAN0RXTSR.Bits.TSR9
#define CAN0RXTSR_TSR10                 _CAN0RXTSR.Bits.TSR10
#define CAN0RXTSR_TSR11                 _CAN0RXTSR.Bits.TSR11
#define CAN0RXTSR_TSR12                 _CAN0RXTSR.Bits.TSR12
#define CAN0RXTSR_TSR13                 _CAN0RXTSR.Bits.TSR13
#define CAN0RXTSR_TSR14                 _CAN0RXTSR.Bits.TSR14
#define CAN0RXTSR_TSR15                 _CAN0RXTSR.Bits.TSR15

#define CAN0RXTSR_TSR0_MASK             1U
#define CAN0RXTSR_TSR1_MASK             2U
#define CAN0RXTSR_TSR2_MASK             4U
#define CAN0RXTSR_TSR3_MASK             8U
#define CAN0RXTSR_TSR4_MASK             16U
#define CAN0RXTSR_TSR5_MASK             32U
#define CAN0RXTSR_TSR6_MASK             64U
#define CAN0RXTSR_TSR7_MASK             128U
#define CAN0RXTSR_TSR8_MASK             256U
#define CAN0RXTSR_TSR9_MASK             512U
#define CAN0RXTSR_TSR10_MASK            1024U
#define CAN0RXTSR_TSR11_MASK            2048U
#define CAN0RXTSR_TSR12_MASK            4096U
#define CAN0RXTSR_TSR13_MASK            8192U
#define CAN0RXTSR_TSR14_MASK            16384U
#define CAN0RXTSR_TSR15_MASK            32768U


/*** CAN0TXIDR0 - MSCAN0 Transmit Identifier Register 0; 0x00000170 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0TXIDR0STR;
extern volatile CAN0TXIDR0STR _CAN0TXIDR0 @(REG_BASE + 0x00000170UL);
#define CAN0TXIDR0                      _CAN0TXIDR0.Byte
#define CAN0TXIDR0_ID21                 _CAN0TXIDR0.Bits.ID21
#define CAN0TXIDR0_ID22                 _CAN0TXIDR0.Bits.ID22
#define CAN0TXIDR0_ID23                 _CAN0TXIDR0.Bits.ID23
#define CAN0TXIDR0_ID24                 _CAN0TXIDR0.Bits.ID24
#define CAN0TXIDR0_ID25                 _CAN0TXIDR0.Bits.ID25
#define CAN0TXIDR0_ID26                 _CAN0TXIDR0.Bits.ID26
#define CAN0TXIDR0_ID27                 _CAN0TXIDR0.Bits.ID27
#define CAN0TXIDR0_ID28                 _CAN0TXIDR0.Bits.ID28
/* CAN0TXIDR_ARR: Access 4 CAN0TXIDRx registers in an array */
#define CAN0TXIDR_ARR                   ((volatile byte *) &CAN0TXIDR0)

#define CAN0TXIDR0_ID21_MASK            1U
#define CAN0TXIDR0_ID22_MASK            2U
#define CAN0TXIDR0_ID23_MASK            4U
#define CAN0TXIDR0_ID24_MASK            8U
#define CAN0TXIDR0_ID25_MASK            16U
#define CAN0TXIDR0_ID26_MASK            32U
#define CAN0TXIDR0_ID27_MASK            64U
#define CAN0TXIDR0_ID28_MASK            128U


/*** CAN0TXIDR1 - MSCAN0 Transmit Identifier Register 1; 0x00000171 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0TXIDR1STR;
extern volatile CAN0TXIDR1STR _CAN0TXIDR1 @(REG_BASE + 0x00000171UL);
#define CAN0TXIDR1                      _CAN0TXIDR1.Byte
#define CAN0TXIDR1_ID15                 _CAN0TXIDR1.Bits.ID15
#define CAN0TXIDR1_ID16                 _CAN0TXIDR1.Bits.ID16
#define CAN0TXIDR1_ID17                 _CAN0TXIDR1.Bits.ID17
#define CAN0TXIDR1_IDE                  _CAN0TXIDR1.Bits.IDE
#define CAN0TXIDR1_SRR                  _CAN0TXIDR1.Bits.SRR
#define CAN0TXIDR1_ID18                 _CAN0TXIDR1.Bits.ID18
#define CAN0TXIDR1_ID19                 _CAN0TXIDR1.Bits.ID19
#define CAN0TXIDR1_ID20                 _CAN0TXIDR1.Bits.ID20
#define CAN0TXIDR1_ID_15                _CAN0TXIDR1.MergedBits.grpID_15
#define CAN0TXIDR1_ID_18                _CAN0TXIDR1.MergedBits.grpID_18
#define CAN0TXIDR1_ID                   CAN0TXIDR1_ID_15

#define CAN0TXIDR1_ID15_MASK            1U
#define CAN0TXIDR1_ID16_MASK            2U
#define CAN0TXIDR1_ID17_MASK            4U
#define CAN0TXIDR1_IDE_MASK             8U
#define CAN0TXIDR1_SRR_MASK             16U
#define CAN0TXIDR1_ID18_MASK            32U
#define CAN0TXIDR1_ID19_MASK            64U
#define CAN0TXIDR1_ID20_MASK            128U
#define CAN0TXIDR1_ID_15_MASK           7U
#define CAN0TXIDR1_ID_15_BITNUM         0U
#define CAN0TXIDR1_ID_18_MASK           224U
#define CAN0TXIDR1_ID_18_BITNUM         5U


/*** CAN0TXIDR2 - MSCAN0 Transmit Identifier Register 2; 0x00000172 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0TXIDR2STR;
extern volatile CAN0TXIDR2STR _CAN0TXIDR2 @(REG_BASE + 0x00000172UL);
#define CAN0TXIDR2                      _CAN0TXIDR2.Byte
#define CAN0TXIDR2_ID7                  _CAN0TXIDR2.Bits.ID7
#define CAN0TXIDR2_ID8                  _CAN0TXIDR2.Bits.ID8
#define CAN0TXIDR2_ID9                  _CAN0TXIDR2.Bits.ID9
#define CAN0TXIDR2_ID10                 _CAN0TXIDR2.Bits.ID10
#define CAN0TXIDR2_ID11                 _CAN0TXIDR2.Bits.ID11
#define CAN0TXIDR2_ID12                 _CAN0TXIDR2.Bits.ID12
#define CAN0TXIDR2_ID13                 _CAN0TXIDR2.Bits.ID13
#define CAN0TXIDR2_ID14                 _CAN0TXIDR2.Bits.ID14

#define CAN0TXIDR2_ID7_MASK             1U
#define CAN0TXIDR2_ID8_MASK             2U
#define CAN0TXIDR2_ID9_MASK             4U
#define CAN0TXIDR2_ID10_MASK            8U
#define CAN0TXIDR2_ID11_MASK            16U
#define CAN0TXIDR2_ID12_MASK            32U
#define CAN0TXIDR2_ID13_MASK            64U
#define CAN0TXIDR2_ID14_MASK            128U


/*** CAN0TXIDR3 - MSCAN0 Transmit Identifier Register 3; 0x00000173 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0TXIDR3STR;
extern volatile CAN0TXIDR3STR _CAN0TXIDR3 @(REG_BASE + 0x00000173UL);
#define CAN0TXIDR3                      _CAN0TXIDR3.Byte
#define CAN0TXIDR3_RTR                  _CAN0TXIDR3.Bits.RTR
#define CAN0TXIDR3_ID0                  _CAN0TXIDR3.Bits.ID0
#define CAN0TXIDR3_ID1                  _CAN0TXIDR3.Bits.ID1
#define CAN0TXIDR3_ID2                  _CAN0TXIDR3.Bits.ID2
#define CAN0TXIDR3_ID3                  _CAN0TXIDR3.Bits.ID3
#define CAN0TXIDR3_ID4                  _CAN0TXIDR3.Bits.ID4
#define CAN0TXIDR3_ID5                  _CAN0TXIDR3.Bits.ID5
#define CAN0TXIDR3_ID6                  _CAN0TXIDR3.Bits.ID6
#define CAN0TXIDR3_ID                   _CAN0TXIDR3.MergedBits.grpID

#define CAN0TXIDR3_RTR_MASK             1U
#define CAN0TXIDR3_ID0_MASK             2U
#define CAN0TXIDR3_ID1_MASK             4U
#define CAN0TXIDR3_ID2_MASK             8U
#define CAN0TXIDR3_ID3_MASK             16U
#define CAN0TXIDR3_ID4_MASK             32U
#define CAN0TXIDR3_ID5_MASK             64U
#define CAN0TXIDR3_ID6_MASK             128U
#define CAN0TXIDR3_ID_MASK              254U
#define CAN0TXIDR3_ID_BITNUM            1U


/*** CAN0TXDSR0 - MSCAN0 Transmit Data Segment Register 0; 0x00000174 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR0STR;
extern volatile CAN0TXDSR0STR _CAN0TXDSR0 @(REG_BASE + 0x00000174UL);
#define CAN0TXDSR0                      _CAN0TXDSR0.Byte
#define CAN0TXDSR0_DB0                  _CAN0TXDSR0.Bits.DB0
#define CAN0TXDSR0_DB1                  _CAN0TXDSR0.Bits.DB1
#define CAN0TXDSR0_DB2                  _CAN0TXDSR0.Bits.DB2
#define CAN0TXDSR0_DB3                  _CAN0TXDSR0.Bits.DB3
#define CAN0TXDSR0_DB4                  _CAN0TXDSR0.Bits.DB4
#define CAN0TXDSR0_DB5                  _CAN0TXDSR0.Bits.DB5
#define CAN0TXDSR0_DB6                  _CAN0TXDSR0.Bits.DB6
#define CAN0TXDSR0_DB7                  _CAN0TXDSR0.Bits.DB7
/* CAN0TXDSR_ARR: Access 8 CAN0TXDSRx registers in an array */
#define CAN0TXDSR_ARR                   ((volatile byte *) &CAN0TXDSR0)

#define CAN0TXDSR0_DB0_MASK             1U
#define CAN0TXDSR0_DB1_MASK             2U
#define CAN0TXDSR0_DB2_MASK             4U
#define CAN0TXDSR0_DB3_MASK             8U
#define CAN0TXDSR0_DB4_MASK             16U
#define CAN0TXDSR0_DB5_MASK             32U
#define CAN0TXDSR0_DB6_MASK             64U
#define CAN0TXDSR0_DB7_MASK             128U


/*** CAN0TXDSR1 - MSCAN0 Transmit Data Segment Register 1; 0x00000175 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR1STR;
extern volatile CAN0TXDSR1STR _CAN0TXDSR1 @(REG_BASE + 0x00000175UL);
#define CAN0TXDSR1                      _CAN0TXDSR1.Byte
#define CAN0TXDSR1_DB0                  _CAN0TXDSR1.Bits.DB0
#define CAN0TXDSR1_DB1                  _CAN0TXDSR1.Bits.DB1
#define CAN0TXDSR1_DB2                  _CAN0TXDSR1.Bits.DB2
#define CAN0TXDSR1_DB3                  _CAN0TXDSR1.Bits.DB3
#define CAN0TXDSR1_DB4                  _CAN0TXDSR1.Bits.DB4
#define CAN0TXDSR1_DB5                  _CAN0TXDSR1.Bits.DB5
#define CAN0TXDSR1_DB6                  _CAN0TXDSR1.Bits.DB6
#define CAN0TXDSR1_DB7                  _CAN0TXDSR1.Bits.DB7

#define CAN0TXDSR1_DB0_MASK             1U
#define CAN0TXDSR1_DB1_MASK             2U
#define CAN0TXDSR1_DB2_MASK             4U
#define CAN0TXDSR1_DB3_MASK             8U
#define CAN0TXDSR1_DB4_MASK             16U
#define CAN0TXDSR1_DB5_MASK             32U
#define CAN0TXDSR1_DB6_MASK             64U
#define CAN0TXDSR1_DB7_MASK             128U


/*** CAN0TXDSR2 - MSCAN0 Transmit Data Segment Register 2; 0x00000176 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR2STR;
extern volatile CAN0TXDSR2STR _CAN0TXDSR2 @(REG_BASE + 0x00000176UL);
#define CAN0TXDSR2                      _CAN0TXDSR2.Byte
#define CAN0TXDSR2_DB0                  _CAN0TXDSR2.Bits.DB0
#define CAN0TXDSR2_DB1                  _CAN0TXDSR2.Bits.DB1
#define CAN0TXDSR2_DB2                  _CAN0TXDSR2.Bits.DB2
#define CAN0TXDSR2_DB3                  _CAN0TXDSR2.Bits.DB3
#define CAN0TXDSR2_DB4                  _CAN0TXDSR2.Bits.DB4
#define CAN0TXDSR2_DB5                  _CAN0TXDSR2.Bits.DB5
#define CAN0TXDSR2_DB6                  _CAN0TXDSR2.Bits.DB6
#define CAN0TXDSR2_DB7                  _CAN0TXDSR2.Bits.DB7

#define CAN0TXDSR2_DB0_MASK             1U
#define CAN0TXDSR2_DB1_MASK             2U
#define CAN0TXDSR2_DB2_MASK             4U
#define CAN0TXDSR2_DB3_MASK             8U
#define CAN0TXDSR2_DB4_MASK             16U
#define CAN0TXDSR2_DB5_MASK             32U
#define CAN0TXDSR2_DB6_MASK             64U
#define CAN0TXDSR2_DB7_MASK             128U


/*** CAN0TXDSR3 - MSCAN0 Transmit Data Segment Register 3; 0x00000177 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR3STR;
extern volatile CAN0TXDSR3STR _CAN0TXDSR3 @(REG_BASE + 0x00000177UL);
#define CAN0TXDSR3                      _CAN0TXDSR3.Byte
#define CAN0TXDSR3_DB0                  _CAN0TXDSR3.Bits.DB0
#define CAN0TXDSR3_DB1                  _CAN0TXDSR3.Bits.DB1
#define CAN0TXDSR3_DB2                  _CAN0TXDSR3.Bits.DB2
#define CAN0TXDSR3_DB3                  _CAN0TXDSR3.Bits.DB3
#define CAN0TXDSR3_DB4                  _CAN0TXDSR3.Bits.DB4
#define CAN0TXDSR3_DB5                  _CAN0TXDSR3.Bits.DB5
#define CAN0TXDSR3_DB6                  _CAN0TXDSR3.Bits.DB6
#define CAN0TXDSR3_DB7                  _CAN0TXDSR3.Bits.DB7

#define CAN0TXDSR3_DB0_MASK             1U
#define CAN0TXDSR3_DB1_MASK             2U
#define CAN0TXDSR3_DB2_MASK             4U
#define CAN0TXDSR3_DB3_MASK             8U
#define CAN0TXDSR3_DB4_MASK             16U
#define CAN0TXDSR3_DB5_MASK             32U
#define CAN0TXDSR3_DB6_MASK             64U
#define CAN0TXDSR3_DB7_MASK             128U


/*** CAN0TXDSR4 - MSCAN0 Transmit Data Segment Register 4; 0x00000178 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR4STR;
extern volatile CAN0TXDSR4STR _CAN0TXDSR4 @(REG_BASE + 0x00000178UL);
#define CAN0TXDSR4                      _CAN0TXDSR4.Byte
#define CAN0TXDSR4_DB0                  _CAN0TXDSR4.Bits.DB0
#define CAN0TXDSR4_DB1                  _CAN0TXDSR4.Bits.DB1
#define CAN0TXDSR4_DB2                  _CAN0TXDSR4.Bits.DB2
#define CAN0TXDSR4_DB3                  _CAN0TXDSR4.Bits.DB3
#define CAN0TXDSR4_DB4                  _CAN0TXDSR4.Bits.DB4
#define CAN0TXDSR4_DB5                  _CAN0TXDSR4.Bits.DB5
#define CAN0TXDSR4_DB6                  _CAN0TXDSR4.Bits.DB6
#define CAN0TXDSR4_DB7                  _CAN0TXDSR4.Bits.DB7

#define CAN0TXDSR4_DB0_MASK             1U
#define CAN0TXDSR4_DB1_MASK             2U
#define CAN0TXDSR4_DB2_MASK             4U
#define CAN0TXDSR4_DB3_MASK             8U
#define CAN0TXDSR4_DB4_MASK             16U
#define CAN0TXDSR4_DB5_MASK             32U
#define CAN0TXDSR4_DB6_MASK             64U
#define CAN0TXDSR4_DB7_MASK             128U


/*** CAN0TXDSR5 - MSCAN0 Transmit Data Segment Register 5; 0x00000179 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR5STR;
extern volatile CAN0TXDSR5STR _CAN0TXDSR5 @(REG_BASE + 0x00000179UL);
#define CAN0TXDSR5                      _CAN0TXDSR5.Byte
#define CAN0TXDSR5_DB0                  _CAN0TXDSR5.Bits.DB0
#define CAN0TXDSR5_DB1                  _CAN0TXDSR5.Bits.DB1
#define CAN0TXDSR5_DB2                  _CAN0TXDSR5.Bits.DB2
#define CAN0TXDSR5_DB3                  _CAN0TXDSR5.Bits.DB3
#define CAN0TXDSR5_DB4                  _CAN0TXDSR5.Bits.DB4
#define CAN0TXDSR5_DB5                  _CAN0TXDSR5.Bits.DB5
#define CAN0TXDSR5_DB6                  _CAN0TXDSR5.Bits.DB6
#define CAN0TXDSR5_DB7                  _CAN0TXDSR5.Bits.DB7

#define CAN0TXDSR5_DB0_MASK             1U
#define CAN0TXDSR5_DB1_MASK             2U
#define CAN0TXDSR5_DB2_MASK             4U
#define CAN0TXDSR5_DB3_MASK             8U
#define CAN0TXDSR5_DB4_MASK             16U
#define CAN0TXDSR5_DB5_MASK             32U
#define CAN0TXDSR5_DB6_MASK             64U
#define CAN0TXDSR5_DB7_MASK             128U


/*** CAN0TXDSR6 - MSCAN0 Transmit Data Segment Register 6; 0x0000017A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR6STR;
extern volatile CAN0TXDSR6STR _CAN0TXDSR6 @(REG_BASE + 0x0000017AUL);
#define CAN0TXDSR6                      _CAN0TXDSR6.Byte
#define CAN0TXDSR6_DB0                  _CAN0TXDSR6.Bits.DB0
#define CAN0TXDSR6_DB1                  _CAN0TXDSR6.Bits.DB1
#define CAN0TXDSR6_DB2                  _CAN0TXDSR6.Bits.DB2
#define CAN0TXDSR6_DB3                  _CAN0TXDSR6.Bits.DB3
#define CAN0TXDSR6_DB4                  _CAN0TXDSR6.Bits.DB4
#define CAN0TXDSR6_DB5                  _CAN0TXDSR6.Bits.DB5
#define CAN0TXDSR6_DB6                  _CAN0TXDSR6.Bits.DB6
#define CAN0TXDSR6_DB7                  _CAN0TXDSR6.Bits.DB7

#define CAN0TXDSR6_DB0_MASK             1U
#define CAN0TXDSR6_DB1_MASK             2U
#define CAN0TXDSR6_DB2_MASK             4U
#define CAN0TXDSR6_DB3_MASK             8U
#define CAN0TXDSR6_DB4_MASK             16U
#define CAN0TXDSR6_DB5_MASK             32U
#define CAN0TXDSR6_DB6_MASK             64U
#define CAN0TXDSR6_DB7_MASK             128U


/*** CAN0TXDSR7 - MSCAN0 Transmit Data Segment Register 7; 0x0000017B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR7STR;
extern volatile CAN0TXDSR7STR _CAN0TXDSR7 @(REG_BASE + 0x0000017BUL);
#define CAN0TXDSR7                      _CAN0TXDSR7.Byte
#define CAN0TXDSR7_DB0                  _CAN0TXDSR7.Bits.DB0
#define CAN0TXDSR7_DB1                  _CAN0TXDSR7.Bits.DB1
#define CAN0TXDSR7_DB2                  _CAN0TXDSR7.Bits.DB2
#define CAN0TXDSR7_DB3                  _CAN0TXDSR7.Bits.DB3
#define CAN0TXDSR7_DB4                  _CAN0TXDSR7.Bits.DB4
#define CAN0TXDSR7_DB5                  _CAN0TXDSR7.Bits.DB5
#define CAN0TXDSR7_DB6                  _CAN0TXDSR7.Bits.DB6
#define CAN0TXDSR7_DB7                  _CAN0TXDSR7.Bits.DB7

#define CAN0TXDSR7_DB0_MASK             1U
#define CAN0TXDSR7_DB1_MASK             2U
#define CAN0TXDSR7_DB2_MASK             4U
#define CAN0TXDSR7_DB3_MASK             8U
#define CAN0TXDSR7_DB4_MASK             16U
#define CAN0TXDSR7_DB5_MASK             32U
#define CAN0TXDSR7_DB6_MASK             64U
#define CAN0TXDSR7_DB7_MASK             128U


/*** CAN0TXDLR - MSCAN0 Transmit Data Length Register; 0x0000017C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TXDLRSTR;
extern volatile CAN0TXDLRSTR _CAN0TXDLR @(REG_BASE + 0x0000017CUL);
#define CAN0TXDLR                       _CAN0TXDLR.Byte
#define CAN0TXDLR_DLC0                  _CAN0TXDLR.Bits.DLC0
#define CAN0TXDLR_DLC1                  _CAN0TXDLR.Bits.DLC1
#define CAN0TXDLR_DLC2                  _CAN0TXDLR.Bits.DLC2
#define CAN0TXDLR_DLC3                  _CAN0TXDLR.Bits.DLC3
#define CAN0TXDLR_DLC                   _CAN0TXDLR.MergedBits.grpDLC

#define CAN0TXDLR_DLC0_MASK             1U
#define CAN0TXDLR_DLC1_MASK             2U
#define CAN0TXDLR_DLC2_MASK             4U
#define CAN0TXDLR_DLC3_MASK             8U
#define CAN0TXDLR_DLC_MASK              15U
#define CAN0TXDLR_DLC_BITNUM            0U


/*** CAN0TXTBPR - MSCAN0 Transmit Buffer Priority; 0x0000017D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN0TXTBPRSTR;
extern volatile CAN0TXTBPRSTR _CAN0TXTBPR @(REG_BASE + 0x0000017DUL);
#define CAN0TXTBPR                      _CAN0TXTBPR.Byte
#define CAN0TXTBPR_PRIO0                _CAN0TXTBPR.Bits.PRIO0
#define CAN0TXTBPR_PRIO1                _CAN0TXTBPR.Bits.PRIO1
#define CAN0TXTBPR_PRIO2                _CAN0TXTBPR.Bits.PRIO2
#define CAN0TXTBPR_PRIO3                _CAN0TXTBPR.Bits.PRIO3
#define CAN0TXTBPR_PRIO4                _CAN0TXTBPR.Bits.PRIO4
#define CAN0TXTBPR_PRIO5                _CAN0TXTBPR.Bits.PRIO5
#define CAN0TXTBPR_PRIO6                _CAN0TXTBPR.Bits.PRIO6
#define CAN0TXTBPR_PRIO7                _CAN0TXTBPR.Bits.PRIO7

#define CAN0TXTBPR_PRIO0_MASK           1U
#define CAN0TXTBPR_PRIO1_MASK           2U
#define CAN0TXTBPR_PRIO2_MASK           4U
#define CAN0TXTBPR_PRIO3_MASK           8U
#define CAN0TXTBPR_PRIO4_MASK           16U
#define CAN0TXTBPR_PRIO5_MASK           32U
#define CAN0TXTBPR_PRIO6_MASK           64U
#define CAN0TXTBPR_PRIO7_MASK           128U


/*** CAN0TXTSR - MSCAN0 Transmit Time Stamp Register; 0x0000017E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0TXTSRH - MSCAN0 Transmit Time Stamp Register High; 0x0000017E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0TXTSRHSTR;
    #define CAN0TXTSRH                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Byte
    #define CAN0TXTSRH_TSR8             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR8
    #define CAN0TXTSRH_TSR9             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR9
    #define CAN0TXTSRH_TSR10            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR10
    #define CAN0TXTSRH_TSR11            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR11
    #define CAN0TXTSRH_TSR12            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR12
    #define CAN0TXTSRH_TSR13            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR13
    #define CAN0TXTSRH_TSR14            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR14
    #define CAN0TXTSRH_TSR15            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR15
    
    #define CAN0TXTSRH_TSR8_MASK        1U
    #define CAN0TXTSRH_TSR9_MASK        2U
    #define CAN0TXTSRH_TSR10_MASK       4U
    #define CAN0TXTSRH_TSR11_MASK       8U
    #define CAN0TXTSRH_TSR12_MASK       16U
    #define CAN0TXTSRH_TSR13_MASK       32U
    #define CAN0TXTSRH_TSR14_MASK       64U
    #define CAN0TXTSRH_TSR15_MASK       128U
    

    /*** CAN0TXTSRL - MSCAN0 Transmit Time Stamp Register Low; 0x0000017F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0TXTSRLSTR;
    #define CAN0TXTSRL                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Byte
    #define CAN0TXTSRL_TSR0             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR0
    #define CAN0TXTSRL_TSR1             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR1
    #define CAN0TXTSRL_TSR2             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR2
    #define CAN0TXTSRL_TSR3             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR3
    #define CAN0TXTSRL_TSR4             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR4
    #define CAN0TXTSRL_TSR5             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR5
    #define CAN0TXTSRL_TSR6             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR6
    #define CAN0TXTSRL_TSR7             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR7
    
    #define CAN0TXTSRL_TSR0_MASK        1U
    #define CAN0TXTSRL_TSR1_MASK        2U
    #define CAN0TXTSRL_TSR2_MASK        4U
    #define CAN0TXTSRL_TSR3_MASK        8U
    #define CAN0TXTSRL_TSR4_MASK        16U
    #define CAN0TXTSRL_TSR5_MASK        32U
    #define CAN0TXTSRL_TSR6_MASK        64U
    #define CAN0TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0TXTSRSTR;
extern volatile CAN0TXTSRSTR _CAN0TXTSR @(REG_BASE + 0x0000017EUL);
#define CAN0TXTSR                       _CAN0TXTSR.Word
#define CAN0TXTSR_TSR0                  _CAN0TXTSR.Bits.TSR0
#define CAN0TXTSR_TSR1                  _CAN0TXTSR.Bits.TSR1
#define CAN0TXTSR_TSR2                  _CAN0TXTSR.Bits.TSR2
#define CAN0TXTSR_TSR3                  _CAN0TXTSR.Bits.TSR3
#define CAN0TXTSR_TSR4                  _CAN0TXTSR.Bits.TSR4
#define CAN0TXTSR_TSR5                  _CAN0TXTSR.Bits.TSR5
#define CAN0TXTSR_TSR6                  _CAN0TXTSR.Bits.TSR6
#define CAN0TXTSR_TSR7                  _CAN0TXTSR.Bits.TSR7
#define CAN0TXTSR_TSR8                  _CAN0TXTSR.Bits.TSR8
#define CAN0TXTSR_TSR9                  _CAN0TXTSR.Bits.TSR9
#define CAN0TXTSR_TSR10                 _CAN0TXTSR.Bits.TSR10
#define CAN0TXTSR_TSR11                 _CAN0TXTSR.Bits.TSR11
#define CAN0TXTSR_TSR12                 _CAN0TXTSR.Bits.TSR12
#define CAN0TXTSR_TSR13                 _CAN0TXTSR.Bits.TSR13
#define CAN0TXTSR_TSR14                 _CAN0TXTSR.Bits.TSR14
#define CAN0TXTSR_TSR15                 _CAN0TXTSR.Bits.TSR15

#define CAN0TXTSR_TSR0_MASK             1U
#define CAN0TXTSR_TSR1_MASK             2U
#define CAN0TXTSR_TSR2_MASK             4U
#define CAN0TXTSR_TSR3_MASK             8U
#define CAN0TXTSR_TSR4_MASK             16U
#define CAN0TXTSR_TSR5_MASK             32U
#define CAN0TXTSR_TSR6_MASK             64U
#define CAN0TXTSR_TSR7_MASK             128U
#define CAN0TXTSR_TSR8_MASK             256U
#define CAN0TXTSR_TSR9_MASK             512U
#define CAN0TXTSR_TSR10_MASK            1024U
#define CAN0TXTSR_TSR11_MASK            2048U
#define CAN0TXTSR_TSR12_MASK            4096U
#define CAN0TXTSR_TSR13_MASK            8192U
#define CAN0TXTSR_TSR14_MASK            16384U
#define CAN0TXTSR_TSR15_MASK            32768U


/*** CAN1CTL0 - MSCAN1 Control 0 Register; 0x00000180 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN1CTL0STR;
extern volatile CAN1CTL0STR _CAN1CTL0 @(REG_BASE + 0x00000180UL);
#define CAN1CTL0                        _CAN1CTL0.Byte
#define CAN1CTL0_INITRQ                 _CAN1CTL0.Bits.INITRQ
#define CAN1CTL0_SLPRQ                  _CAN1CTL0.Bits.SLPRQ
#define CAN1CTL0_WUPE                   _CAN1CTL0.Bits.WUPE
#define CAN1CTL0_TIME                   _CAN1CTL0.Bits.TIME
#define CAN1CTL0_SYNCH                  _CAN1CTL0.Bits.SYNCH
#define CAN1CTL0_CSWAI                  _CAN1CTL0.Bits.CSWAI
#define CAN1CTL0_RXACT                  _CAN1CTL0.Bits.RXACT
#define CAN1CTL0_RXFRM                  _CAN1CTL0.Bits.RXFRM
/* CAN1CTL_ARR: Access 2 CAN1CTLx registers in an array */
#define CAN1CTL_ARR                     ((volatile byte *) &CAN1CTL0)

#define CAN1CTL0_INITRQ_MASK            1U
#define CAN1CTL0_SLPRQ_MASK             2U
#define CAN1CTL0_WUPE_MASK              4U
#define CAN1CTL0_TIME_MASK              8U
#define CAN1CTL0_SYNCH_MASK             16U
#define CAN1CTL0_CSWAI_MASK             32U
#define CAN1CTL0_RXACT_MASK             64U
#define CAN1CTL0_RXFRM_MASK             128U


/*** CAN1CTL1 - MSCAN1 Control 1 Register; 0x00000181 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN Clock Source */
    byte CANE        :1;                                       /* MSCAN Enable */
  } Bits;
} CAN1CTL1STR;
extern volatile CAN1CTL1STR _CAN1CTL1 @(REG_BASE + 0x00000181UL);
#define CAN1CTL1                        _CAN1CTL1.Byte
#define CAN1CTL1_INITAK                 _CAN1CTL1.Bits.INITAK
#define CAN1CTL1_SLPAK                  _CAN1CTL1.Bits.SLPAK
#define CAN1CTL1_WUPM                   _CAN1CTL1.Bits.WUPM
#define CAN1CTL1_BORM                   _CAN1CTL1.Bits.BORM
#define CAN1CTL1_LISTEN                 _CAN1CTL1.Bits.LISTEN
#define CAN1CTL1_LOOPB                  _CAN1CTL1.Bits.LOOPB
#define CAN1CTL1_CLKSRC                 _CAN1CTL1.Bits.CLKSRC
#define CAN1CTL1_CANE                   _CAN1CTL1.Bits.CANE

#define CAN1CTL1_INITAK_MASK            1U
#define CAN1CTL1_SLPAK_MASK             2U
#define CAN1CTL1_WUPM_MASK              4U
#define CAN1CTL1_BORM_MASK              8U
#define CAN1CTL1_LISTEN_MASK            16U
#define CAN1CTL1_LOOPB_MASK             32U
#define CAN1CTL1_CLKSRC_MASK            64U
#define CAN1CTL1_CANE_MASK              128U


/*** CAN1BTR0 - MSCAN1 Bus Timing Register 0; 0x00000182 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN1BTR0STR;
extern volatile CAN1BTR0STR _CAN1BTR0 @(REG_BASE + 0x00000182UL);
#define CAN1BTR0                        _CAN1BTR0.Byte
#define CAN1BTR0_BRP0                   _CAN1BTR0.Bits.BRP0
#define CAN1BTR0_BRP1                   _CAN1BTR0.Bits.BRP1
#define CAN1BTR0_BRP2                   _CAN1BTR0.Bits.BRP2
#define CAN1BTR0_BRP3                   _CAN1BTR0.Bits.BRP3
#define CAN1BTR0_BRP4                   _CAN1BTR0.Bits.BRP4
#define CAN1BTR0_BRP5                   _CAN1BTR0.Bits.BRP5
#define CAN1BTR0_SJW0                   _CAN1BTR0.Bits.SJW0
#define CAN1BTR0_SJW1                   _CAN1BTR0.Bits.SJW1
/* CAN1BTR_ARR: Access 2 CAN1BTRx registers in an array */
#define CAN1BTR_ARR                     ((volatile byte *) &CAN1BTR0)
#define CAN1BTR0_BRP                    _CAN1BTR0.MergedBits.grpBRP
#define CAN1BTR0_SJW                    _CAN1BTR0.MergedBits.grpSJW

#define CAN1BTR0_BRP0_MASK              1U
#define CAN1BTR0_BRP1_MASK              2U
#define CAN1BTR0_BRP2_MASK              4U
#define CAN1BTR0_BRP3_MASK              8U
#define CAN1BTR0_BRP4_MASK              16U
#define CAN1BTR0_BRP5_MASK              32U
#define CAN1BTR0_SJW0_MASK              64U
#define CAN1BTR0_SJW1_MASK              128U
#define CAN1BTR0_BRP_MASK               63U
#define CAN1BTR0_BRP_BITNUM             0U
#define CAN1BTR0_SJW_MASK               192U
#define CAN1BTR0_SJW_BITNUM             6U


/*** CAN1BTR1 - MSCAN1 Bus Timing Register 1; 0x00000183 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN1BTR1STR;
extern volatile CAN1BTR1STR _CAN1BTR1 @(REG_BASE + 0x00000183UL);
#define CAN1BTR1                        _CAN1BTR1.Byte
#define CAN1BTR1_TSEG10                 _CAN1BTR1.Bits.TSEG10
#define CAN1BTR1_TSEG11                 _CAN1BTR1.Bits.TSEG11
#define CAN1BTR1_TSEG12                 _CAN1BTR1.Bits.TSEG12
#define CAN1BTR1_TSEG13                 _CAN1BTR1.Bits.TSEG13
#define CAN1BTR1_TSEG20                 _CAN1BTR1.Bits.TSEG20
#define CAN1BTR1_TSEG21                 _CAN1BTR1.Bits.TSEG21
#define CAN1BTR1_TSEG22                 _CAN1BTR1.Bits.TSEG22
#define CAN1BTR1_SAMP                   _CAN1BTR1.Bits.SAMP
#define CAN1BTR1_TSEG_10                _CAN1BTR1.MergedBits.grpTSEG_10
#define CAN1BTR1_TSEG_20                _CAN1BTR1.MergedBits.grpTSEG_20
#define CAN1BTR1_TSEG                   CAN1BTR1_TSEG_10

#define CAN1BTR1_TSEG10_MASK            1U
#define CAN1BTR1_TSEG11_MASK            2U
#define CAN1BTR1_TSEG12_MASK            4U
#define CAN1BTR1_TSEG13_MASK            8U
#define CAN1BTR1_TSEG20_MASK            16U
#define CAN1BTR1_TSEG21_MASK            32U
#define CAN1BTR1_TSEG22_MASK            64U
#define CAN1BTR1_SAMP_MASK              128U
#define CAN1BTR1_TSEG_10_MASK           15U
#define CAN1BTR1_TSEG_10_BITNUM         0U
#define CAN1BTR1_TSEG_20_MASK           112U
#define CAN1BTR1_TSEG_20_BITNUM         4U


/*** CAN1RFLG - MSCAN1 Receiver Flag Register; 0x00000184 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RFLGSTR;
extern volatile CAN1RFLGSTR _CAN1RFLG @(REG_BASE + 0x00000184UL);
#define CAN1RFLG                        _CAN1RFLG.Byte
#define CAN1RFLG_RXF                    _CAN1RFLG.Bits.RXF
#define CAN1RFLG_OVRIF                  _CAN1RFLG.Bits.OVRIF
#define CAN1RFLG_TSTAT0                 _CAN1RFLG.Bits.TSTAT0
#define CAN1RFLG_TSTAT1                 _CAN1RFLG.Bits.TSTAT1
#define CAN1RFLG_RSTAT0                 _CAN1RFLG.Bits.RSTAT0
#define CAN1RFLG_RSTAT1                 _CAN1RFLG.Bits.RSTAT1
#define CAN1RFLG_CSCIF                  _CAN1RFLG.Bits.CSCIF
#define CAN1RFLG_WUPIF                  _CAN1RFLG.Bits.WUPIF
#define CAN1RFLG_TSTAT                  _CAN1RFLG.MergedBits.grpTSTAT
#define CAN1RFLG_RSTAT                  _CAN1RFLG.MergedBits.grpRSTAT

#define CAN1RFLG_RXF_MASK               1U
#define CAN1RFLG_OVRIF_MASK             2U
#define CAN1RFLG_TSTAT0_MASK            4U
#define CAN1RFLG_TSTAT1_MASK            8U
#define CAN1RFLG_RSTAT0_MASK            16U
#define CAN1RFLG_RSTAT1_MASK            32U
#define CAN1RFLG_CSCIF_MASK             64U
#define CAN1RFLG_WUPIF_MASK             128U
#define CAN1RFLG_TSTAT_MASK             12U
#define CAN1RFLG_TSTAT_BITNUM           2U
#define CAN1RFLG_RSTAT_MASK             48U
#define CAN1RFLG_RSTAT_BITNUM           4U


/*** CAN1RIER - MSCAN1 Receiver Interrupt Enable Register; 0x00000185 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RIERSTR;
extern volatile CAN1RIERSTR _CAN1RIER @(REG_BASE + 0x00000185UL);
#define CAN1RIER                        _CAN1RIER.Byte
#define CAN1RIER_RXFIE                  _CAN1RIER.Bits.RXFIE
#define CAN1RIER_OVRIE                  _CAN1RIER.Bits.OVRIE
#define CAN1RIER_TSTATE0                _CAN1RIER.Bits.TSTATE0
#define CAN1RIER_TSTATE1                _CAN1RIER.Bits.TSTATE1
#define CAN1RIER_RSTATE0                _CAN1RIER.Bits.RSTATE0
#define CAN1RIER_RSTATE1                _CAN1RIER.Bits.RSTATE1
#define CAN1RIER_CSCIE                  _CAN1RIER.Bits.CSCIE
#define CAN1RIER_WUPIE                  _CAN1RIER.Bits.WUPIE
#define CAN1RIER_TSTATE                 _CAN1RIER.MergedBits.grpTSTATE
#define CAN1RIER_RSTATE                 _CAN1RIER.MergedBits.grpRSTATE

#define CAN1RIER_RXFIE_MASK             1U
#define CAN1RIER_OVRIE_MASK             2U
#define CAN1RIER_TSTATE0_MASK           4U
#define CAN1RIER_TSTATE1_MASK           8U
#define CAN1RIER_RSTATE0_MASK           16U
#define CAN1RIER_RSTATE1_MASK           32U
#define CAN1RIER_CSCIE_MASK             64U
#define CAN1RIER_WUPIE_MASK             128U
#define CAN1RIER_TSTATE_MASK            12U
#define CAN1RIER_TSTATE_BITNUM          2U
#define CAN1RIER_RSTATE_MASK            48U
#define CAN1RIER_RSTATE_BITNUM          4U


/*** CAN1TFLG - MSCAN1 Transmitter Flag Register; 0x00000186 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TFLGSTR;
extern volatile CAN1TFLGSTR _CAN1TFLG @(REG_BASE + 0x00000186UL);
#define CAN1TFLG                        _CAN1TFLG.Byte
#define CAN1TFLG_TXE0                   _CAN1TFLG.Bits.TXE0
#define CAN1TFLG_TXE1                   _CAN1TFLG.Bits.TXE1
#define CAN1TFLG_TXE2                   _CAN1TFLG.Bits.TXE2
#define CAN1TFLG_TXE                    _CAN1TFLG.MergedBits.grpTXE

#define CAN1TFLG_TXE0_MASK              1U
#define CAN1TFLG_TXE1_MASK              2U
#define CAN1TFLG_TXE2_MASK              4U
#define CAN1TFLG_TXE_MASK               7U
#define CAN1TFLG_TXE_BITNUM             0U


/*** CAN1TIER - MSCAN1 Transmitter Interrupt Enable Register; 0x00000187 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TIERSTR;
extern volatile CAN1TIERSTR _CAN1TIER @(REG_BASE + 0x00000187UL);
#define CAN1TIER                        _CAN1TIER.Byte
#define CAN1TIER_TXEIE0                 _CAN1TIER.Bits.TXEIE0
#define CAN1TIER_TXEIE1                 _CAN1TIER.Bits.TXEIE1
#define CAN1TIER_TXEIE2                 _CAN1TIER.Bits.TXEIE2
#define CAN1TIER_TXEIE                  _CAN1TIER.MergedBits.grpTXEIE

#define CAN1TIER_TXEIE0_MASK            1U
#define CAN1TIER_TXEIE1_MASK            2U
#define CAN1TIER_TXEIE2_MASK            4U
#define CAN1TIER_TXEIE_MASK             7U
#define CAN1TIER_TXEIE_BITNUM           0U


/*** CAN1TARQ - MSCAN1 Transmitter Message Abort Request; 0x00000188 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TARQSTR;
extern volatile CAN1TARQSTR _CAN1TARQ @(REG_BASE + 0x00000188UL);
#define CAN1TARQ                        _CAN1TARQ.Byte
#define CAN1TARQ_ABTRQ0                 _CAN1TARQ.Bits.ABTRQ0
#define CAN1TARQ_ABTRQ1                 _CAN1TARQ.Bits.ABTRQ1
#define CAN1TARQ_ABTRQ2                 _CAN1TARQ.Bits.ABTRQ2
#define CAN1TARQ_ABTRQ                  _CAN1TARQ.MergedBits.grpABTRQ

#define CAN1TARQ_ABTRQ0_MASK            1U
#define CAN1TARQ_ABTRQ1_MASK            2U
#define CAN1TARQ_ABTRQ2_MASK            4U
#define CAN1TARQ_ABTRQ_MASK             7U
#define CAN1TARQ_ABTRQ_BITNUM           0U


/*** CAN1TAAK - MSCAN1 Transmitter Message Abort Acknowledge; 0x00000189 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TAAKSTR;
extern volatile CAN1TAAKSTR _CAN1TAAK @(REG_BASE + 0x00000189UL);
#define CAN1TAAK                        _CAN1TAAK.Byte
#define CAN1TAAK_ABTAK0                 _CAN1TAAK.Bits.ABTAK0
#define CAN1TAAK_ABTAK1                 _CAN1TAAK.Bits.ABTAK1
#define CAN1TAAK_ABTAK2                 _CAN1TAAK.Bits.ABTAK2
#define CAN1TAAK_ABTAK                  _CAN1TAAK.MergedBits.grpABTAK

#define CAN1TAAK_ABTAK0_MASK            1U
#define CAN1TAAK_ABTAK1_MASK            2U
#define CAN1TAAK_ABTAK2_MASK            4U
#define CAN1TAAK_ABTAK_MASK             7U
#define CAN1TAAK_ABTAK_BITNUM           0U


/*** CAN1TBSEL - MSCAN1 Transmit Buffer Selection; 0x0000018A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TBSELSTR;
extern volatile CAN1TBSELSTR _CAN1TBSEL @(REG_BASE + 0x0000018AUL);
#define CAN1TBSEL                       _CAN1TBSEL.Byte
#define CAN1TBSEL_TX0                   _CAN1TBSEL.Bits.TX0
#define CAN1TBSEL_TX1                   _CAN1TBSEL.Bits.TX1
#define CAN1TBSEL_TX2                   _CAN1TBSEL.Bits.TX2
#define CAN1TBSEL_TX                    _CAN1TBSEL.MergedBits.grpTX

#define CAN1TBSEL_TX0_MASK              1U
#define CAN1TBSEL_TX1_MASK              2U
#define CAN1TBSEL_TX2_MASK              4U
#define CAN1TBSEL_TX_MASK               7U
#define CAN1TBSEL_TX_BITNUM             0U


/*** CAN1IDAC - MSCAN1 Identifier Acceptance Control Register; 0x0000018B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1IDACSTR;
extern volatile CAN1IDACSTR _CAN1IDAC @(REG_BASE + 0x0000018BUL);
#define CAN1IDAC                        _CAN1IDAC.Byte
#define CAN1IDAC_IDHIT0                 _CAN1IDAC.Bits.IDHIT0
#define CAN1IDAC_IDHIT1                 _CAN1IDAC.Bits.IDHIT1
#define CAN1IDAC_IDHIT2                 _CAN1IDAC.Bits.IDHIT2
#define CAN1IDAC_IDAM0                  _CAN1IDAC.Bits.IDAM0
#define CAN1IDAC_IDAM1                  _CAN1IDAC.Bits.IDAM1
#define CAN1IDAC_IDHIT                  _CAN1IDAC.MergedBits.grpIDHIT
#define CAN1IDAC_IDAM                   _CAN1IDAC.MergedBits.grpIDAM

#define CAN1IDAC_IDHIT0_MASK            1U
#define CAN1IDAC_IDHIT1_MASK            2U
#define CAN1IDAC_IDHIT2_MASK            4U
#define CAN1IDAC_IDAM0_MASK             16U
#define CAN1IDAC_IDAM1_MASK             32U
#define CAN1IDAC_IDHIT_MASK             7U
#define CAN1IDAC_IDHIT_BITNUM           0U
#define CAN1IDAC_IDAM_MASK              48U
#define CAN1IDAC_IDAM_BITNUM            4U


/*** CAN1MISC - MSCAN1 Miscellaneous Register; 0x0000018D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-off State Hold Until User Request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN1MISCSTR;
extern volatile CAN1MISCSTR _CAN1MISC @(REG_BASE + 0x0000018DUL);
#define CAN1MISC                        _CAN1MISC.Byte
#define CAN1MISC_BOHOLD                 _CAN1MISC.Bits.BOHOLD

#define CAN1MISC_BOHOLD_MASK            1U


/*** CAN1RXERR - MSCAN1 Receive Error Counter Register; 0x0000018E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN1RXERRSTR;
extern volatile CAN1RXERRSTR _CAN1RXERR @(REG_BASE + 0x0000018EUL);
#define CAN1RXERR                       _CAN1RXERR.Byte
#define CAN1RXERR_RXERR0                _CAN1RXERR.Bits.RXERR0
#define CAN1RXERR_RXERR1                _CAN1RXERR.Bits.RXERR1
#define CAN1RXERR_RXERR2                _CAN1RXERR.Bits.RXERR2
#define CAN1RXERR_RXERR3                _CAN1RXERR.Bits.RXERR3
#define CAN1RXERR_RXERR4                _CAN1RXERR.Bits.RXERR4
#define CAN1RXERR_RXERR5                _CAN1RXERR.Bits.RXERR5
#define CAN1RXERR_RXERR6                _CAN1RXERR.Bits.RXERR6
#define CAN1RXERR_RXERR7                _CAN1RXERR.Bits.RXERR7

#define CAN1RXERR_RXERR0_MASK           1U
#define CAN1RXERR_RXERR1_MASK           2U
#define CAN1RXERR_RXERR2_MASK           4U
#define CAN1RXERR_RXERR3_MASK           8U
#define CAN1RXERR_RXERR4_MASK           16U
#define CAN1RXERR_RXERR5_MASK           32U
#define CAN1RXERR_RXERR6_MASK           64U
#define CAN1RXERR_RXERR7_MASK           128U


/*** CAN1TXERR - MSCAN1 Transmit Error Counter Register; 0x0000018F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN1TXERRSTR;
extern volatile CAN1TXERRSTR _CAN1TXERR @(REG_BASE + 0x0000018FUL);
#define CAN1TXERR                       _CAN1TXERR.Byte
#define CAN1TXERR_TXERR0                _CAN1TXERR.Bits.TXERR0
#define CAN1TXERR_TXERR1                _CAN1TXERR.Bits.TXERR1
#define CAN1TXERR_TXERR2                _CAN1TXERR.Bits.TXERR2
#define CAN1TXERR_TXERR3                _CAN1TXERR.Bits.TXERR3
#define CAN1TXERR_TXERR4                _CAN1TXERR.Bits.TXERR4
#define CAN1TXERR_TXERR5                _CAN1TXERR.Bits.TXERR5
#define CAN1TXERR_TXERR6                _CAN1TXERR.Bits.TXERR6
#define CAN1TXERR_TXERR7                _CAN1TXERR.Bits.TXERR7

#define CAN1TXERR_TXERR0_MASK           1U
#define CAN1TXERR_TXERR1_MASK           2U
#define CAN1TXERR_TXERR2_MASK           4U
#define CAN1TXERR_TXERR3_MASK           8U
#define CAN1TXERR_TXERR4_MASK           16U
#define CAN1TXERR_TXERR5_MASK           32U
#define CAN1TXERR_TXERR6_MASK           64U
#define CAN1TXERR_TXERR7_MASK           128U


/*** CAN1IDAR0 - MSCAN1 Identifier Acceptance Register 0; 0x00000190 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR0STR;
extern volatile CAN1IDAR0STR _CAN1IDAR0 @(REG_BASE + 0x00000190UL);
#define CAN1IDAR0                       _CAN1IDAR0.Byte
#define CAN1IDAR0_AC0                   _CAN1IDAR0.Bits.AC0
#define CAN1IDAR0_AC1                   _CAN1IDAR0.Bits.AC1
#define CAN1IDAR0_AC2                   _CAN1IDAR0.Bits.AC2
#define CAN1IDAR0_AC3                   _CAN1IDAR0.Bits.AC3
#define CAN1IDAR0_AC4                   _CAN1IDAR0.Bits.AC4
#define CAN1IDAR0_AC5                   _CAN1IDAR0.Bits.AC5
#define CAN1IDAR0_AC6                   _CAN1IDAR0.Bits.AC6
#define CAN1IDAR0_AC7                   _CAN1IDAR0.Bits.AC7
/* CAN1IDAR_ARR: Access 4 CAN1IDARx registers in an array */
#define CAN1IDAR_ARR                    ((volatile byte *) &CAN1IDAR0)

#define CAN1IDAR0_AC0_MASK              1U
#define CAN1IDAR0_AC1_MASK              2U
#define CAN1IDAR0_AC2_MASK              4U
#define CAN1IDAR0_AC3_MASK              8U
#define CAN1IDAR0_AC4_MASK              16U
#define CAN1IDAR0_AC5_MASK              32U
#define CAN1IDAR0_AC6_MASK              64U
#define CAN1IDAR0_AC7_MASK              128U


/*** CAN1IDAR1 - MSCAN1 Identifier Acceptance Register 1; 0x00000191 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR1STR;
extern volatile CAN1IDAR1STR _CAN1IDAR1 @(REG_BASE + 0x00000191UL);
#define CAN1IDAR1                       _CAN1IDAR1.Byte
#define CAN1IDAR1_AC0                   _CAN1IDAR1.Bits.AC0
#define CAN1IDAR1_AC1                   _CAN1IDAR1.Bits.AC1
#define CAN1IDAR1_AC2                   _CAN1IDAR1.Bits.AC2
#define CAN1IDAR1_AC3                   _CAN1IDAR1.Bits.AC3
#define CAN1IDAR1_AC4                   _CAN1IDAR1.Bits.AC4
#define CAN1IDAR1_AC5                   _CAN1IDAR1.Bits.AC5
#define CAN1IDAR1_AC6                   _CAN1IDAR1.Bits.AC6
#define CAN1IDAR1_AC7                   _CAN1IDAR1.Bits.AC7

#define CAN1IDAR1_AC0_MASK              1U
#define CAN1IDAR1_AC1_MASK              2U
#define CAN1IDAR1_AC2_MASK              4U
#define CAN1IDAR1_AC3_MASK              8U
#define CAN1IDAR1_AC4_MASK              16U
#define CAN1IDAR1_AC5_MASK              32U
#define CAN1IDAR1_AC6_MASK              64U
#define CAN1IDAR1_AC7_MASK              128U


/*** CAN1IDAR2 - MSCAN1 Identifier Acceptance Register 2; 0x00000192 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR2STR;
extern volatile CAN1IDAR2STR _CAN1IDAR2 @(REG_BASE + 0x00000192UL);
#define CAN1IDAR2                       _CAN1IDAR2.Byte
#define CAN1IDAR2_AC0                   _CAN1IDAR2.Bits.AC0
#define CAN1IDAR2_AC1                   _CAN1IDAR2.Bits.AC1
#define CAN1IDAR2_AC2                   _CAN1IDAR2.Bits.AC2
#define CAN1IDAR2_AC3                   _CAN1IDAR2.Bits.AC3
#define CAN1IDAR2_AC4                   _CAN1IDAR2.Bits.AC4
#define CAN1IDAR2_AC5                   _CAN1IDAR2.Bits.AC5
#define CAN1IDAR2_AC6                   _CAN1IDAR2.Bits.AC6
#define CAN1IDAR2_AC7                   _CAN1IDAR2.Bits.AC7

#define CAN1IDAR2_AC0_MASK              1U
#define CAN1IDAR2_AC1_MASK              2U
#define CAN1IDAR2_AC2_MASK              4U
#define CAN1IDAR2_AC3_MASK              8U
#define CAN1IDAR2_AC4_MASK              16U
#define CAN1IDAR2_AC5_MASK              32U
#define CAN1IDAR2_AC6_MASK              64U
#define CAN1IDAR2_AC7_MASK              128U


/*** CAN1IDAR3 - MSCAN1 Identifier Acceptance Register 3; 0x00000193 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR3STR;
extern volatile CAN1IDAR3STR _CAN1IDAR3 @(REG_BASE + 0x00000193UL);
#define CAN1IDAR3                       _CAN1IDAR3.Byte
#define CAN1IDAR3_AC0                   _CAN1IDAR3.Bits.AC0
#define CAN1IDAR3_AC1                   _CAN1IDAR3.Bits.AC1
#define CAN1IDAR3_AC2                   _CAN1IDAR3.Bits.AC2
#define CAN1IDAR3_AC3                   _CAN1IDAR3.Bits.AC3
#define CAN1IDAR3_AC4                   _CAN1IDAR3.Bits.AC4
#define CAN1IDAR3_AC5                   _CAN1IDAR3.Bits.AC5
#define CAN1IDAR3_AC6                   _CAN1IDAR3.Bits.AC6
#define CAN1IDAR3_AC7                   _CAN1IDAR3.Bits.AC7

#define CAN1IDAR3_AC0_MASK              1U
#define CAN1IDAR3_AC1_MASK              2U
#define CAN1IDAR3_AC2_MASK              4U
#define CAN1IDAR3_AC3_MASK              8U
#define CAN1IDAR3_AC4_MASK              16U
#define CAN1IDAR3_AC5_MASK              32U
#define CAN1IDAR3_AC6_MASK              64U
#define CAN1IDAR3_AC7_MASK              128U


/*** CAN1IDMR0 - MSCAN1 Identifier Mask Register 0; 0x00000194 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR0STR;
extern volatile CAN1IDMR0STR _CAN1IDMR0 @(REG_BASE + 0x00000194UL);
#define CAN1IDMR0                       _CAN1IDMR0.Byte
#define CAN1IDMR0_AM0                   _CAN1IDMR0.Bits.AM0
#define CAN1IDMR0_AM1                   _CAN1IDMR0.Bits.AM1
#define CAN1IDMR0_AM2                   _CAN1IDMR0.Bits.AM2
#define CAN1IDMR0_AM3                   _CAN1IDMR0.Bits.AM3
#define CAN1IDMR0_AM4                   _CAN1IDMR0.Bits.AM4
#define CAN1IDMR0_AM5                   _CAN1IDMR0.Bits.AM5
#define CAN1IDMR0_AM6                   _CAN1IDMR0.Bits.AM6
#define CAN1IDMR0_AM7                   _CAN1IDMR0.Bits.AM7
/* CAN1IDMR_ARR: Access 4 CAN1IDMRx registers in an array */
#define CAN1IDMR_ARR                    ((volatile byte *) &CAN1IDMR0)

#define CAN1IDMR0_AM0_MASK              1U
#define CAN1IDMR0_AM1_MASK              2U
#define CAN1IDMR0_AM2_MASK              4U
#define CAN1IDMR0_AM3_MASK              8U
#define CAN1IDMR0_AM4_MASK              16U
#define CAN1IDMR0_AM5_MASK              32U
#define CAN1IDMR0_AM6_MASK              64U
#define CAN1IDMR0_AM7_MASK              128U


/*** CAN1IDMR1 - MSCAN1 Identifier Mask Register 1; 0x00000195 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR1STR;
extern volatile CAN1IDMR1STR _CAN1IDMR1 @(REG_BASE + 0x00000195UL);
#define CAN1IDMR1                       _CAN1IDMR1.Byte
#define CAN1IDMR1_AM0                   _CAN1IDMR1.Bits.AM0
#define CAN1IDMR1_AM1                   _CAN1IDMR1.Bits.AM1
#define CAN1IDMR1_AM2                   _CAN1IDMR1.Bits.AM2
#define CAN1IDMR1_AM3                   _CAN1IDMR1.Bits.AM3
#define CAN1IDMR1_AM4                   _CAN1IDMR1.Bits.AM4
#define CAN1IDMR1_AM5                   _CAN1IDMR1.Bits.AM5
#define CAN1IDMR1_AM6                   _CAN1IDMR1.Bits.AM6
#define CAN1IDMR1_AM7                   _CAN1IDMR1.Bits.AM7

#define CAN1IDMR1_AM0_MASK              1U
#define CAN1IDMR1_AM1_MASK              2U
#define CAN1IDMR1_AM2_MASK              4U
#define CAN1IDMR1_AM3_MASK              8U
#define CAN1IDMR1_AM4_MASK              16U
#define CAN1IDMR1_AM5_MASK              32U
#define CAN1IDMR1_AM6_MASK              64U
#define CAN1IDMR1_AM7_MASK              128U


/*** CAN1IDMR2 - MSCAN1 Identifier Mask Register 2; 0x00000196 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR2STR;
extern volatile CAN1IDMR2STR _CAN1IDMR2 @(REG_BASE + 0x00000196UL);
#define CAN1IDMR2                       _CAN1IDMR2.Byte
#define CAN1IDMR2_AM0                   _CAN1IDMR2.Bits.AM0
#define CAN1IDMR2_AM1                   _CAN1IDMR2.Bits.AM1
#define CAN1IDMR2_AM2                   _CAN1IDMR2.Bits.AM2
#define CAN1IDMR2_AM3                   _CAN1IDMR2.Bits.AM3
#define CAN1IDMR2_AM4                   _CAN1IDMR2.Bits.AM4
#define CAN1IDMR2_AM5                   _CAN1IDMR2.Bits.AM5
#define CAN1IDMR2_AM6                   _CAN1IDMR2.Bits.AM6
#define CAN1IDMR2_AM7                   _CAN1IDMR2.Bits.AM7

#define CAN1IDMR2_AM0_MASK              1U
#define CAN1IDMR2_AM1_MASK              2U
#define CAN1IDMR2_AM2_MASK              4U
#define CAN1IDMR2_AM3_MASK              8U
#define CAN1IDMR2_AM4_MASK              16U
#define CAN1IDMR2_AM5_MASK              32U
#define CAN1IDMR2_AM6_MASK              64U
#define CAN1IDMR2_AM7_MASK              128U


/*** CAN1IDMR3 - MSCAN1 Identifier Mask Register 3; 0x00000197 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR3STR;
extern volatile CAN1IDMR3STR _CAN1IDMR3 @(REG_BASE + 0x00000197UL);
#define CAN1IDMR3                       _CAN1IDMR3.Byte
#define CAN1IDMR3_AM0                   _CAN1IDMR3.Bits.AM0
#define CAN1IDMR3_AM1                   _CAN1IDMR3.Bits.AM1
#define CAN1IDMR3_AM2                   _CAN1IDMR3.Bits.AM2
#define CAN1IDMR3_AM3                   _CAN1IDMR3.Bits.AM3
#define CAN1IDMR3_AM4                   _CAN1IDMR3.Bits.AM4
#define CAN1IDMR3_AM5                   _CAN1IDMR3.Bits.AM5
#define CAN1IDMR3_AM6                   _CAN1IDMR3.Bits.AM6
#define CAN1IDMR3_AM7                   _CAN1IDMR3.Bits.AM7

#define CAN1IDMR3_AM0_MASK              1U
#define CAN1IDMR3_AM1_MASK              2U
#define CAN1IDMR3_AM2_MASK              4U
#define CAN1IDMR3_AM3_MASK              8U
#define CAN1IDMR3_AM4_MASK              16U
#define CAN1IDMR3_AM5_MASK              32U
#define CAN1IDMR3_AM6_MASK              64U
#define CAN1IDMR3_AM7_MASK              128U


/*** CAN1IDAR4 - MSCAN1 Identifier Acceptance Register 4; 0x00000198 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR4STR;
extern volatile CAN1IDAR4STR _CAN1IDAR4 @(REG_BASE + 0x00000198UL);
#define CAN1IDAR4                       _CAN1IDAR4.Byte
#define CAN1IDAR4_AC0                   _CAN1IDAR4.Bits.AC0
#define CAN1IDAR4_AC1                   _CAN1IDAR4.Bits.AC1
#define CAN1IDAR4_AC2                   _CAN1IDAR4.Bits.AC2
#define CAN1IDAR4_AC3                   _CAN1IDAR4.Bits.AC3
#define CAN1IDAR4_AC4                   _CAN1IDAR4.Bits.AC4
#define CAN1IDAR4_AC5                   _CAN1IDAR4.Bits.AC5
#define CAN1IDAR4_AC6                   _CAN1IDAR4.Bits.AC6
#define CAN1IDAR4_AC7                   _CAN1IDAR4.Bits.AC7

#define CAN1IDAR4_AC0_MASK              1U
#define CAN1IDAR4_AC1_MASK              2U
#define CAN1IDAR4_AC2_MASK              4U
#define CAN1IDAR4_AC3_MASK              8U
#define CAN1IDAR4_AC4_MASK              16U
#define CAN1IDAR4_AC5_MASK              32U
#define CAN1IDAR4_AC6_MASK              64U
#define CAN1IDAR4_AC7_MASK              128U


/*** CAN1IDAR5 - MSCAN1 Identifier Acceptance Register 5; 0x00000199 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR5STR;
extern volatile CAN1IDAR5STR _CAN1IDAR5 @(REG_BASE + 0x00000199UL);
#define CAN1IDAR5                       _CAN1IDAR5.Byte
#define CAN1IDAR5_AC0                   _CAN1IDAR5.Bits.AC0
#define CAN1IDAR5_AC1                   _CAN1IDAR5.Bits.AC1
#define CAN1IDAR5_AC2                   _CAN1IDAR5.Bits.AC2
#define CAN1IDAR5_AC3                   _CAN1IDAR5.Bits.AC3
#define CAN1IDAR5_AC4                   _CAN1IDAR5.Bits.AC4
#define CAN1IDAR5_AC5                   _CAN1IDAR5.Bits.AC5
#define CAN1IDAR5_AC6                   _CAN1IDAR5.Bits.AC6
#define CAN1IDAR5_AC7                   _CAN1IDAR5.Bits.AC7

#define CAN1IDAR5_AC0_MASK              1U
#define CAN1IDAR5_AC1_MASK              2U
#define CAN1IDAR5_AC2_MASK              4U
#define CAN1IDAR5_AC3_MASK              8U
#define CAN1IDAR5_AC4_MASK              16U
#define CAN1IDAR5_AC5_MASK              32U
#define CAN1IDAR5_AC6_MASK              64U
#define CAN1IDAR5_AC7_MASK              128U


/*** CAN1IDAR6 - MSCAN1 Identifier Acceptance Register 6; 0x0000019A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR6STR;
extern volatile CAN1IDAR6STR _CAN1IDAR6 @(REG_BASE + 0x0000019AUL);
#define CAN1IDAR6                       _CAN1IDAR6.Byte
#define CAN1IDAR6_AC0                   _CAN1IDAR6.Bits.AC0
#define CAN1IDAR6_AC1                   _CAN1IDAR6.Bits.AC1
#define CAN1IDAR6_AC2                   _CAN1IDAR6.Bits.AC2
#define CAN1IDAR6_AC3                   _CAN1IDAR6.Bits.AC3
#define CAN1IDAR6_AC4                   _CAN1IDAR6.Bits.AC4
#define CAN1IDAR6_AC5                   _CAN1IDAR6.Bits.AC5
#define CAN1IDAR6_AC6                   _CAN1IDAR6.Bits.AC6
#define CAN1IDAR6_AC7                   _CAN1IDAR6.Bits.AC7

#define CAN1IDAR6_AC0_MASK              1U
#define CAN1IDAR6_AC1_MASK              2U
#define CAN1IDAR6_AC2_MASK              4U
#define CAN1IDAR6_AC3_MASK              8U
#define CAN1IDAR6_AC4_MASK              16U
#define CAN1IDAR6_AC5_MASK              32U
#define CAN1IDAR6_AC6_MASK              64U
#define CAN1IDAR6_AC7_MASK              128U


/*** CAN1IDAR7 - MSCAN1 Identifier Acceptance Register 7; 0x0000019B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR7STR;
extern volatile CAN1IDAR7STR _CAN1IDAR7 @(REG_BASE + 0x0000019BUL);
#define CAN1IDAR7                       _CAN1IDAR7.Byte
#define CAN1IDAR7_AC0                   _CAN1IDAR7.Bits.AC0
#define CAN1IDAR7_AC1                   _CAN1IDAR7.Bits.AC1
#define CAN1IDAR7_AC2                   _CAN1IDAR7.Bits.AC2
#define CAN1IDAR7_AC3                   _CAN1IDAR7.Bits.AC3
#define CAN1IDAR7_AC4                   _CAN1IDAR7.Bits.AC4
#define CAN1IDAR7_AC5                   _CAN1IDAR7.Bits.AC5
#define CAN1IDAR7_AC6                   _CAN1IDAR7.Bits.AC6
#define CAN1IDAR7_AC7                   _CAN1IDAR7.Bits.AC7

#define CAN1IDAR7_AC0_MASK              1U
#define CAN1IDAR7_AC1_MASK              2U
#define CAN1IDAR7_AC2_MASK              4U
#define CAN1IDAR7_AC3_MASK              8U
#define CAN1IDAR7_AC4_MASK              16U
#define CAN1IDAR7_AC5_MASK              32U
#define CAN1IDAR7_AC6_MASK              64U
#define CAN1IDAR7_AC7_MASK              128U


/*** CAN1IDMR4 - MSCAN1 Identifier Mask Register 4; 0x0000019C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR4STR;
extern volatile CAN1IDMR4STR _CAN1IDMR4 @(REG_BASE + 0x0000019CUL);
#define CAN1IDMR4                       _CAN1IDMR4.Byte
#define CAN1IDMR4_AM0                   _CAN1IDMR4.Bits.AM0
#define CAN1IDMR4_AM1                   _CAN1IDMR4.Bits.AM1
#define CAN1IDMR4_AM2                   _CAN1IDMR4.Bits.AM2
#define CAN1IDMR4_AM3                   _CAN1IDMR4.Bits.AM3
#define CAN1IDMR4_AM4                   _CAN1IDMR4.Bits.AM4
#define CAN1IDMR4_AM5                   _CAN1IDMR4.Bits.AM5
#define CAN1IDMR4_AM6                   _CAN1IDMR4.Bits.AM6
#define CAN1IDMR4_AM7                   _CAN1IDMR4.Bits.AM7

#define CAN1IDMR4_AM0_MASK              1U
#define CAN1IDMR4_AM1_MASK              2U
#define CAN1IDMR4_AM2_MASK              4U
#define CAN1IDMR4_AM3_MASK              8U
#define CAN1IDMR4_AM4_MASK              16U
#define CAN1IDMR4_AM5_MASK              32U
#define CAN1IDMR4_AM6_MASK              64U
#define CAN1IDMR4_AM7_MASK              128U


/*** CAN1IDMR5 - MSCAN1 Identifier Mask Register 5; 0x0000019D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR5STR;
extern volatile CAN1IDMR5STR _CAN1IDMR5 @(REG_BASE + 0x0000019DUL);
#define CAN1IDMR5                       _CAN1IDMR5.Byte
#define CAN1IDMR5_AM0                   _CAN1IDMR5.Bits.AM0
#define CAN1IDMR5_AM1                   _CAN1IDMR5.Bits.AM1
#define CAN1IDMR5_AM2                   _CAN1IDMR5.Bits.AM2
#define CAN1IDMR5_AM3                   _CAN1IDMR5.Bits.AM3
#define CAN1IDMR5_AM4                   _CAN1IDMR5.Bits.AM4
#define CAN1IDMR5_AM5                   _CAN1IDMR5.Bits.AM5
#define CAN1IDMR5_AM6                   _CAN1IDMR5.Bits.AM6
#define CAN1IDMR5_AM7                   _CAN1IDMR5.Bits.AM7

#define CAN1IDMR5_AM0_MASK              1U
#define CAN1IDMR5_AM1_MASK              2U
#define CAN1IDMR5_AM2_MASK              4U
#define CAN1IDMR5_AM3_MASK              8U
#define CAN1IDMR5_AM4_MASK              16U
#define CAN1IDMR5_AM5_MASK              32U
#define CAN1IDMR5_AM6_MASK              64U
#define CAN1IDMR5_AM7_MASK              128U


/*** CAN1IDMR6 - MSCAN1 Identifier Mask Register 6; 0x0000019E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR6STR;
extern volatile CAN1IDMR6STR _CAN1IDMR6 @(REG_BASE + 0x0000019EUL);
#define CAN1IDMR6                       _CAN1IDMR6.Byte
#define CAN1IDMR6_AM0                   _CAN1IDMR6.Bits.AM0
#define CAN1IDMR6_AM1                   _CAN1IDMR6.Bits.AM1
#define CAN1IDMR6_AM2                   _CAN1IDMR6.Bits.AM2
#define CAN1IDMR6_AM3                   _CAN1IDMR6.Bits.AM3
#define CAN1IDMR6_AM4                   _CAN1IDMR6.Bits.AM4
#define CAN1IDMR6_AM5                   _CAN1IDMR6.Bits.AM5
#define CAN1IDMR6_AM6                   _CAN1IDMR6.Bits.AM6
#define CAN1IDMR6_AM7                   _CAN1IDMR6.Bits.AM7

#define CAN1IDMR6_AM0_MASK              1U
#define CAN1IDMR6_AM1_MASK              2U
#define CAN1IDMR6_AM2_MASK              4U
#define CAN1IDMR6_AM3_MASK              8U
#define CAN1IDMR6_AM4_MASK              16U
#define CAN1IDMR6_AM5_MASK              32U
#define CAN1IDMR6_AM6_MASK              64U
#define CAN1IDMR6_AM7_MASK              128U


/*** CAN1IDMR7 - MSCAN1 Identifier Mask Register 7; 0x0000019F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR7STR;
extern volatile CAN1IDMR7STR _CAN1IDMR7 @(REG_BASE + 0x0000019FUL);
#define CAN1IDMR7                       _CAN1IDMR7.Byte
#define CAN1IDMR7_AM0                   _CAN1IDMR7.Bits.AM0
#define CAN1IDMR7_AM1                   _CAN1IDMR7.Bits.AM1
#define CAN1IDMR7_AM2                   _CAN1IDMR7.Bits.AM2
#define CAN1IDMR7_AM3                   _CAN1IDMR7.Bits.AM3
#define CAN1IDMR7_AM4                   _CAN1IDMR7.Bits.AM4
#define CAN1IDMR7_AM5                   _CAN1IDMR7.Bits.AM5
#define CAN1IDMR7_AM6                   _CAN1IDMR7.Bits.AM6
#define CAN1IDMR7_AM7                   _CAN1IDMR7.Bits.AM7

#define CAN1IDMR7_AM0_MASK              1U
#define CAN1IDMR7_AM1_MASK              2U
#define CAN1IDMR7_AM2_MASK              4U
#define CAN1IDMR7_AM3_MASK              8U
#define CAN1IDMR7_AM4_MASK              16U
#define CAN1IDMR7_AM5_MASK              32U
#define CAN1IDMR7_AM6_MASK              64U
#define CAN1IDMR7_AM7_MASK              128U


/*** CAN1RXIDR0 - MSCAN1 Receive Identifier Register 0; 0x000001A0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN1RXIDR0STR;
extern volatile CAN1RXIDR0STR _CAN1RXIDR0 @(REG_BASE + 0x000001A0UL);
#define CAN1RXIDR0                      _CAN1RXIDR0.Byte
#define CAN1RXIDR0_ID21                 _CAN1RXIDR0.Bits.ID21
#define CAN1RXIDR0_ID22                 _CAN1RXIDR0.Bits.ID22
#define CAN1RXIDR0_ID23                 _CAN1RXIDR0.Bits.ID23
#define CAN1RXIDR0_ID24                 _CAN1RXIDR0.Bits.ID24
#define CAN1RXIDR0_ID25                 _CAN1RXIDR0.Bits.ID25
#define CAN1RXIDR0_ID26                 _CAN1RXIDR0.Bits.ID26
#define CAN1RXIDR0_ID27                 _CAN1RXIDR0.Bits.ID27
#define CAN1RXIDR0_ID28                 _CAN1RXIDR0.Bits.ID28
/* CAN1RXIDR_ARR: Access 4 CAN1RXIDRx registers in an array */
#define CAN1RXIDR_ARR                   ((volatile byte *) &CAN1RXIDR0)

#define CAN1RXIDR0_ID21_MASK            1U
#define CAN1RXIDR0_ID22_MASK            2U
#define CAN1RXIDR0_ID23_MASK            4U
#define CAN1RXIDR0_ID24_MASK            8U
#define CAN1RXIDR0_ID25_MASK            16U
#define CAN1RXIDR0_ID26_MASK            32U
#define CAN1RXIDR0_ID27_MASK            64U
#define CAN1RXIDR0_ID28_MASK            128U


/*** CAN1RXIDR1 - MSCAN1 Receive Identifier Register 1; 0x000001A1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN1RXIDR1STR;
extern volatile CAN1RXIDR1STR _CAN1RXIDR1 @(REG_BASE + 0x000001A1UL);
#define CAN1RXIDR1                      _CAN1RXIDR1.Byte
#define CAN1RXIDR1_ID15                 _CAN1RXIDR1.Bits.ID15
#define CAN1RXIDR1_ID16                 _CAN1RXIDR1.Bits.ID16
#define CAN1RXIDR1_ID17                 _CAN1RXIDR1.Bits.ID17
#define CAN1RXIDR1_IDE                  _CAN1RXIDR1.Bits.IDE
#define CAN1RXIDR1_SRR                  _CAN1RXIDR1.Bits.SRR
#define CAN1RXIDR1_ID18                 _CAN1RXIDR1.Bits.ID18
#define CAN1RXIDR1_ID19                 _CAN1RXIDR1.Bits.ID19
#define CAN1RXIDR1_ID20                 _CAN1RXIDR1.Bits.ID20
#define CAN1RXIDR1_ID_15                _CAN1RXIDR1.MergedBits.grpID_15
#define CAN1RXIDR1_ID_18                _CAN1RXIDR1.MergedBits.grpID_18
#define CAN1RXIDR1_ID                   CAN1RXIDR1_ID_15

#define CAN1RXIDR1_ID15_MASK            1U
#define CAN1RXIDR1_ID16_MASK            2U
#define CAN1RXIDR1_ID17_MASK            4U
#define CAN1RXIDR1_IDE_MASK             8U
#define CAN1RXIDR1_SRR_MASK             16U
#define CAN1RXIDR1_ID18_MASK            32U
#define CAN1RXIDR1_ID19_MASK            64U
#define CAN1RXIDR1_ID20_MASK            128U
#define CAN1RXIDR1_ID_15_MASK           7U
#define CAN1RXIDR1_ID_15_BITNUM         0U
#define CAN1RXIDR1_ID_18_MASK           224U
#define CAN1RXIDR1_ID_18_BITNUM         5U


/*** CAN1RXIDR2 - MSCAN1 Receive Identifier Register 2; 0x000001A2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN1RXIDR2STR;
extern volatile CAN1RXIDR2STR _CAN1RXIDR2 @(REG_BASE + 0x000001A2UL);
#define CAN1RXIDR2                      _CAN1RXIDR2.Byte
#define CAN1RXIDR2_ID7                  _CAN1RXIDR2.Bits.ID7
#define CAN1RXIDR2_ID8                  _CAN1RXIDR2.Bits.ID8
#define CAN1RXIDR2_ID9                  _CAN1RXIDR2.Bits.ID9
#define CAN1RXIDR2_ID10                 _CAN1RXIDR2.Bits.ID10
#define CAN1RXIDR2_ID11                 _CAN1RXIDR2.Bits.ID11
#define CAN1RXIDR2_ID12                 _CAN1RXIDR2.Bits.ID12
#define CAN1RXIDR2_ID13                 _CAN1RXIDR2.Bits.ID13
#define CAN1RXIDR2_ID14                 _CAN1RXIDR2.Bits.ID14

#define CAN1RXIDR2_ID7_MASK             1U
#define CAN1RXIDR2_ID8_MASK             2U
#define CAN1RXIDR2_ID9_MASK             4U
#define CAN1RXIDR2_ID10_MASK            8U
#define CAN1RXIDR2_ID11_MASK            16U
#define CAN1RXIDR2_ID12_MASK            32U
#define CAN1RXIDR2_ID13_MASK            64U
#define CAN1RXIDR2_ID14_MASK            128U


/*** CAN1RXIDR3 - MSCAN1 Receive Identifier Register 3; 0x000001A3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN1RXIDR3STR;
extern volatile CAN1RXIDR3STR _CAN1RXIDR3 @(REG_BASE + 0x000001A3UL);
#define CAN1RXIDR3                      _CAN1RXIDR3.Byte
#define CAN1RXIDR3_RTR                  _CAN1RXIDR3.Bits.RTR
#define CAN1RXIDR3_ID0                  _CAN1RXIDR3.Bits.ID0
#define CAN1RXIDR3_ID1                  _CAN1RXIDR3.Bits.ID1
#define CAN1RXIDR3_ID2                  _CAN1RXIDR3.Bits.ID2
#define CAN1RXIDR3_ID3                  _CAN1RXIDR3.Bits.ID3
#define CAN1RXIDR3_ID4                  _CAN1RXIDR3.Bits.ID4
#define CAN1RXIDR3_ID5                  _CAN1RXIDR3.Bits.ID5
#define CAN1RXIDR3_ID6                  _CAN1RXIDR3.Bits.ID6
#define CAN1RXIDR3_ID                   _CAN1RXIDR3.MergedBits.grpID

#define CAN1RXIDR3_RTR_MASK             1U
#define CAN1RXIDR3_ID0_MASK             2U
#define CAN1RXIDR3_ID1_MASK             4U
#define CAN1RXIDR3_ID2_MASK             8U
#define CAN1RXIDR3_ID3_MASK             16U
#define CAN1RXIDR3_ID4_MASK             32U
#define CAN1RXIDR3_ID5_MASK             64U
#define CAN1RXIDR3_ID6_MASK             128U
#define CAN1RXIDR3_ID_MASK              254U
#define CAN1RXIDR3_ID_BITNUM            1U


/*** CAN1RXDSR0 - MSCAN1 Receive Data Segment Register 0; 0x000001A4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR0STR;
extern volatile CAN1RXDSR0STR _CAN1RXDSR0 @(REG_BASE + 0x000001A4UL);
#define CAN1RXDSR0                      _CAN1RXDSR0.Byte
#define CAN1RXDSR0_DB0                  _CAN1RXDSR0.Bits.DB0
#define CAN1RXDSR0_DB1                  _CAN1RXDSR0.Bits.DB1
#define CAN1RXDSR0_DB2                  _CAN1RXDSR0.Bits.DB2
#define CAN1RXDSR0_DB3                  _CAN1RXDSR0.Bits.DB3
#define CAN1RXDSR0_DB4                  _CAN1RXDSR0.Bits.DB4
#define CAN1RXDSR0_DB5                  _CAN1RXDSR0.Bits.DB5
#define CAN1RXDSR0_DB6                  _CAN1RXDSR0.Bits.DB6
#define CAN1RXDSR0_DB7                  _CAN1RXDSR0.Bits.DB7
/* CAN1RXDSR_ARR: Access 8 CAN1RXDSRx registers in an array */
#define CAN1RXDSR_ARR                   ((volatile byte *) &CAN1RXDSR0)

#define CAN1RXDSR0_DB0_MASK             1U
#define CAN1RXDSR0_DB1_MASK             2U
#define CAN1RXDSR0_DB2_MASK             4U
#define CAN1RXDSR0_DB3_MASK             8U
#define CAN1RXDSR0_DB4_MASK             16U
#define CAN1RXDSR0_DB5_MASK             32U
#define CAN1RXDSR0_DB6_MASK             64U
#define CAN1RXDSR0_DB7_MASK             128U


/*** CAN1RXDSR1 - MSCAN1 Receive Data Segment Register 1; 0x000001A5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR1STR;
extern volatile CAN1RXDSR1STR _CAN1RXDSR1 @(REG_BASE + 0x000001A5UL);
#define CAN1RXDSR1                      _CAN1RXDSR1.Byte
#define CAN1RXDSR1_DB0                  _CAN1RXDSR1.Bits.DB0
#define CAN1RXDSR1_DB1                  _CAN1RXDSR1.Bits.DB1
#define CAN1RXDSR1_DB2                  _CAN1RXDSR1.Bits.DB2
#define CAN1RXDSR1_DB3                  _CAN1RXDSR1.Bits.DB3
#define CAN1RXDSR1_DB4                  _CAN1RXDSR1.Bits.DB4
#define CAN1RXDSR1_DB5                  _CAN1RXDSR1.Bits.DB5
#define CAN1RXDSR1_DB6                  _CAN1RXDSR1.Bits.DB6
#define CAN1RXDSR1_DB7                  _CAN1RXDSR1.Bits.DB7

#define CAN1RXDSR1_DB0_MASK             1U
#define CAN1RXDSR1_DB1_MASK             2U
#define CAN1RXDSR1_DB2_MASK             4U
#define CAN1RXDSR1_DB3_MASK             8U
#define CAN1RXDSR1_DB4_MASK             16U
#define CAN1RXDSR1_DB5_MASK             32U
#define CAN1RXDSR1_DB6_MASK             64U
#define CAN1RXDSR1_DB7_MASK             128U


/*** CAN1RXDSR2 - MSCAN1 Receive Data Segment Register 2; 0x000001A6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR2STR;
extern volatile CAN1RXDSR2STR _CAN1RXDSR2 @(REG_BASE + 0x000001A6UL);
#define CAN1RXDSR2                      _CAN1RXDSR2.Byte
#define CAN1RXDSR2_DB0                  _CAN1RXDSR2.Bits.DB0
#define CAN1RXDSR2_DB1                  _CAN1RXDSR2.Bits.DB1
#define CAN1RXDSR2_DB2                  _CAN1RXDSR2.Bits.DB2
#define CAN1RXDSR2_DB3                  _CAN1RXDSR2.Bits.DB3
#define CAN1RXDSR2_DB4                  _CAN1RXDSR2.Bits.DB4
#define CAN1RXDSR2_DB5                  _CAN1RXDSR2.Bits.DB5
#define CAN1RXDSR2_DB6                  _CAN1RXDSR2.Bits.DB6
#define CAN1RXDSR2_DB7                  _CAN1RXDSR2.Bits.DB7

#define CAN1RXDSR2_DB0_MASK             1U
#define CAN1RXDSR2_DB1_MASK             2U
#define CAN1RXDSR2_DB2_MASK             4U
#define CAN1RXDSR2_DB3_MASK             8U
#define CAN1RXDSR2_DB4_MASK             16U
#define CAN1RXDSR2_DB5_MASK             32U
#define CAN1RXDSR2_DB6_MASK             64U
#define CAN1RXDSR2_DB7_MASK             128U


/*** CAN1RXDSR3 - MSCAN1 Receive Data Segment Register 3; 0x000001A7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR3STR;
extern volatile CAN1RXDSR3STR _CAN1RXDSR3 @(REG_BASE + 0x000001A7UL);
#define CAN1RXDSR3                      _CAN1RXDSR3.Byte
#define CAN1RXDSR3_DB0                  _CAN1RXDSR3.Bits.DB0
#define CAN1RXDSR3_DB1                  _CAN1RXDSR3.Bits.DB1
#define CAN1RXDSR3_DB2                  _CAN1RXDSR3.Bits.DB2
#define CAN1RXDSR3_DB3                  _CAN1RXDSR3.Bits.DB3
#define CAN1RXDSR3_DB4                  _CAN1RXDSR3.Bits.DB4
#define CAN1RXDSR3_DB5                  _CAN1RXDSR3.Bits.DB5
#define CAN1RXDSR3_DB6                  _CAN1RXDSR3.Bits.DB6
#define CAN1RXDSR3_DB7                  _CAN1RXDSR3.Bits.DB7

#define CAN1RXDSR3_DB0_MASK             1U
#define CAN1RXDSR3_DB1_MASK             2U
#define CAN1RXDSR3_DB2_MASK             4U
#define CAN1RXDSR3_DB3_MASK             8U
#define CAN1RXDSR3_DB4_MASK             16U
#define CAN1RXDSR3_DB5_MASK             32U
#define CAN1RXDSR3_DB6_MASK             64U
#define CAN1RXDSR3_DB7_MASK             128U


/*** CAN1RXDSR4 - MSCAN1 Receive Data Segment Register 4; 0x000001A8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR4STR;
extern volatile CAN1RXDSR4STR _CAN1RXDSR4 @(REG_BASE + 0x000001A8UL);
#define CAN1RXDSR4                      _CAN1RXDSR4.Byte
#define CAN1RXDSR4_DB0                  _CAN1RXDSR4.Bits.DB0
#define CAN1RXDSR4_DB1                  _CAN1RXDSR4.Bits.DB1
#define CAN1RXDSR4_DB2                  _CAN1RXDSR4.Bits.DB2
#define CAN1RXDSR4_DB3                  _CAN1RXDSR4.Bits.DB3
#define CAN1RXDSR4_DB4                  _CAN1RXDSR4.Bits.DB4
#define CAN1RXDSR4_DB5                  _CAN1RXDSR4.Bits.DB5
#define CAN1RXDSR4_DB6                  _CAN1RXDSR4.Bits.DB6
#define CAN1RXDSR4_DB7                  _CAN1RXDSR4.Bits.DB7

#define CAN1RXDSR4_DB0_MASK             1U
#define CAN1RXDSR4_DB1_MASK             2U
#define CAN1RXDSR4_DB2_MASK             4U
#define CAN1RXDSR4_DB3_MASK             8U
#define CAN1RXDSR4_DB4_MASK             16U
#define CAN1RXDSR4_DB5_MASK             32U
#define CAN1RXDSR4_DB6_MASK             64U
#define CAN1RXDSR4_DB7_MASK             128U


/*** CAN1RXDSR5 - MSCAN1 Receive Data Segment Register 5; 0x000001A9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR5STR;
extern volatile CAN1RXDSR5STR _CAN1RXDSR5 @(REG_BASE + 0x000001A9UL);
#define CAN1RXDSR5                      _CAN1RXDSR5.Byte
#define CAN1RXDSR5_DB0                  _CAN1RXDSR5.Bits.DB0
#define CAN1RXDSR5_DB1                  _CAN1RXDSR5.Bits.DB1
#define CAN1RXDSR5_DB2                  _CAN1RXDSR5.Bits.DB2
#define CAN1RXDSR5_DB3                  _CAN1RXDSR5.Bits.DB3
#define CAN1RXDSR5_DB4                  _CAN1RXDSR5.Bits.DB4
#define CAN1RXDSR5_DB5                  _CAN1RXDSR5.Bits.DB5
#define CAN1RXDSR5_DB6                  _CAN1RXDSR5.Bits.DB6
#define CAN1RXDSR5_DB7                  _CAN1RXDSR5.Bits.DB7

#define CAN1RXDSR5_DB0_MASK             1U
#define CAN1RXDSR5_DB1_MASK             2U
#define CAN1RXDSR5_DB2_MASK             4U
#define CAN1RXDSR5_DB3_MASK             8U
#define CAN1RXDSR5_DB4_MASK             16U
#define CAN1RXDSR5_DB5_MASK             32U
#define CAN1RXDSR5_DB6_MASK             64U
#define CAN1RXDSR5_DB7_MASK             128U


/*** CAN1RXDSR6 - MSCAN1 Receive Data Segment Register 6; 0x000001AA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR6STR;
extern volatile CAN1RXDSR6STR _CAN1RXDSR6 @(REG_BASE + 0x000001AAUL);
#define CAN1RXDSR6                      _CAN1RXDSR6.Byte
#define CAN1RXDSR6_DB0                  _CAN1RXDSR6.Bits.DB0
#define CAN1RXDSR6_DB1                  _CAN1RXDSR6.Bits.DB1
#define CAN1RXDSR6_DB2                  _CAN1RXDSR6.Bits.DB2
#define CAN1RXDSR6_DB3                  _CAN1RXDSR6.Bits.DB3
#define CAN1RXDSR6_DB4                  _CAN1RXDSR6.Bits.DB4
#define CAN1RXDSR6_DB5                  _CAN1RXDSR6.Bits.DB5
#define CAN1RXDSR6_DB6                  _CAN1RXDSR6.Bits.DB6
#define CAN1RXDSR6_DB7                  _CAN1RXDSR6.Bits.DB7

#define CAN1RXDSR6_DB0_MASK             1U
#define CAN1RXDSR6_DB1_MASK             2U
#define CAN1RXDSR6_DB2_MASK             4U
#define CAN1RXDSR6_DB3_MASK             8U
#define CAN1RXDSR6_DB4_MASK             16U
#define CAN1RXDSR6_DB5_MASK             32U
#define CAN1RXDSR6_DB6_MASK             64U
#define CAN1RXDSR6_DB7_MASK             128U


/*** CAN1RXDSR7 - MSCAN1 Receive Data Segment Register 7; 0x000001AB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR7STR;
extern volatile CAN1RXDSR7STR _CAN1RXDSR7 @(REG_BASE + 0x000001ABUL);
#define CAN1RXDSR7                      _CAN1RXDSR7.Byte
#define CAN1RXDSR7_DB0                  _CAN1RXDSR7.Bits.DB0
#define CAN1RXDSR7_DB1                  _CAN1RXDSR7.Bits.DB1
#define CAN1RXDSR7_DB2                  _CAN1RXDSR7.Bits.DB2
#define CAN1RXDSR7_DB3                  _CAN1RXDSR7.Bits.DB3
#define CAN1RXDSR7_DB4                  _CAN1RXDSR7.Bits.DB4
#define CAN1RXDSR7_DB5                  _CAN1RXDSR7.Bits.DB5
#define CAN1RXDSR7_DB6                  _CAN1RXDSR7.Bits.DB6
#define CAN1RXDSR7_DB7                  _CAN1RXDSR7.Bits.DB7

#define CAN1RXDSR7_DB0_MASK             1U
#define CAN1RXDSR7_DB1_MASK             2U
#define CAN1RXDSR7_DB2_MASK             4U
#define CAN1RXDSR7_DB3_MASK             8U
#define CAN1RXDSR7_DB4_MASK             16U
#define CAN1RXDSR7_DB5_MASK             32U
#define CAN1RXDSR7_DB6_MASK             64U
#define CAN1RXDSR7_DB7_MASK             128U


/*** CAN1RXDLR - MSCAN1 Receive Data Length Register; 0x000001AC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RXDLRSTR;
extern volatile CAN1RXDLRSTR _CAN1RXDLR @(REG_BASE + 0x000001ACUL);
#define CAN1RXDLR                       _CAN1RXDLR.Byte
#define CAN1RXDLR_DLC0                  _CAN1RXDLR.Bits.DLC0
#define CAN1RXDLR_DLC1                  _CAN1RXDLR.Bits.DLC1
#define CAN1RXDLR_DLC2                  _CAN1RXDLR.Bits.DLC2
#define CAN1RXDLR_DLC3                  _CAN1RXDLR.Bits.DLC3
#define CAN1RXDLR_DLC                   _CAN1RXDLR.MergedBits.grpDLC

#define CAN1RXDLR_DLC0_MASK             1U
#define CAN1RXDLR_DLC1_MASK             2U
#define CAN1RXDLR_DLC2_MASK             4U
#define CAN1RXDLR_DLC3_MASK             8U
#define CAN1RXDLR_DLC_MASK              15U
#define CAN1RXDLR_DLC_BITNUM            0U


/*** CAN1RXTSR - MSCAN1 Receive Time Stamp Register; 0x000001AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN1RXTSRH - MSCAN1 Receive Time Stamp Register High; 0x000001AE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN1RXTSRHSTR;
    #define CAN1RXTSRH                  _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Byte
    #define CAN1RXTSRH_TSR8             _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR8
    #define CAN1RXTSRH_TSR9             _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR9
    #define CAN1RXTSRH_TSR10            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR10
    #define CAN1RXTSRH_TSR11            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR11
    #define CAN1RXTSRH_TSR12            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR12
    #define CAN1RXTSRH_TSR13            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR13
    #define CAN1RXTSRH_TSR14            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR14
    #define CAN1RXTSRH_TSR15            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR15
    
    #define CAN1RXTSRH_TSR8_MASK        1U
    #define CAN1RXTSRH_TSR9_MASK        2U
    #define CAN1RXTSRH_TSR10_MASK       4U
    #define CAN1RXTSRH_TSR11_MASK       8U
    #define CAN1RXTSRH_TSR12_MASK       16U
    #define CAN1RXTSRH_TSR13_MASK       32U
    #define CAN1RXTSRH_TSR14_MASK       64U
    #define CAN1RXTSRH_TSR15_MASK       128U
    

    /*** CAN1RXTSRL - MSCAN1 Receive Time Stamp Register Low; 0x000001AF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN1RXTSRLSTR;
    #define CAN1RXTSRL                  _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Byte
    #define CAN1RXTSRL_TSR0             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR0
    #define CAN1RXTSRL_TSR1             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR1
    #define CAN1RXTSRL_TSR2             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR2
    #define CAN1RXTSRL_TSR3             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR3
    #define CAN1RXTSRL_TSR4             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR4
    #define CAN1RXTSRL_TSR5             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR5
    #define CAN1RXTSRL_TSR6             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR6
    #define CAN1RXTSRL_TSR7             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR7
    
    #define CAN1RXTSRL_TSR0_MASK        1U
    #define CAN1RXTSRL_TSR1_MASK        2U
    #define CAN1RXTSRL_TSR2_MASK        4U
    #define CAN1RXTSRL_TSR3_MASK        8U
    #define CAN1RXTSRL_TSR4_MASK        16U
    #define CAN1RXTSRL_TSR5_MASK        32U
    #define CAN1RXTSRL_TSR6_MASK        64U
    #define CAN1RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN1RXTSRSTR;
extern volatile CAN1RXTSRSTR _CAN1RXTSR @(REG_BASE + 0x000001AEUL);
#define CAN1RXTSR                       _CAN1RXTSR.Word
#define CAN1RXTSR_TSR0                  _CAN1RXTSR.Bits.TSR0
#define CAN1RXTSR_TSR1                  _CAN1RXTSR.Bits.TSR1
#define CAN1RXTSR_TSR2                  _CAN1RXTSR.Bits.TSR2
#define CAN1RXTSR_TSR3                  _CAN1RXTSR.Bits.TSR3
#define CAN1RXTSR_TSR4                  _CAN1RXTSR.Bits.TSR4
#define CAN1RXTSR_TSR5                  _CAN1RXTSR.Bits.TSR5
#define CAN1RXTSR_TSR6                  _CAN1RXTSR.Bits.TSR6
#define CAN1RXTSR_TSR7                  _CAN1RXTSR.Bits.TSR7
#define CAN1RXTSR_TSR8                  _CAN1RXTSR.Bits.TSR8
#define CAN1RXTSR_TSR9                  _CAN1RXTSR.Bits.TSR9
#define CAN1RXTSR_TSR10                 _CAN1RXTSR.Bits.TSR10
#define CAN1RXTSR_TSR11                 _CAN1RXTSR.Bits.TSR11
#define CAN1RXTSR_TSR12                 _CAN1RXTSR.Bits.TSR12
#define CAN1RXTSR_TSR13                 _CAN1RXTSR.Bits.TSR13
#define CAN1RXTSR_TSR14                 _CAN1RXTSR.Bits.TSR14
#define CAN1RXTSR_TSR15                 _CAN1RXTSR.Bits.TSR15

#define CAN1RXTSR_TSR0_MASK             1U
#define CAN1RXTSR_TSR1_MASK             2U
#define CAN1RXTSR_TSR2_MASK             4U
#define CAN1RXTSR_TSR3_MASK             8U
#define CAN1RXTSR_TSR4_MASK             16U
#define CAN1RXTSR_TSR5_MASK             32U
#define CAN1RXTSR_TSR6_MASK             64U
#define CAN1RXTSR_TSR7_MASK             128U
#define CAN1RXTSR_TSR8_MASK             256U
#define CAN1RXTSR_TSR9_MASK             512U
#define CAN1RXTSR_TSR10_MASK            1024U
#define CAN1RXTSR_TSR11_MASK            2048U
#define CAN1RXTSR_TSR12_MASK            4096U
#define CAN1RXTSR_TSR13_MASK            8192U
#define CAN1RXTSR_TSR14_MASK            16384U
#define CAN1RXTSR_TSR15_MASK            32768U


/*** CAN1TXIDR0 - MSCAN1 Transmit Identifier Register 0; 0x000001B0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN1TXIDR0STR;
extern volatile CAN1TXIDR0STR _CAN1TXIDR0 @(REG_BASE + 0x000001B0UL);
#define CAN1TXIDR0                      _CAN1TXIDR0.Byte
#define CAN1TXIDR0_ID21                 _CAN1TXIDR0.Bits.ID21
#define CAN1TXIDR0_ID22                 _CAN1TXIDR0.Bits.ID22
#define CAN1TXIDR0_ID23                 _CAN1TXIDR0.Bits.ID23
#define CAN1TXIDR0_ID24                 _CAN1TXIDR0.Bits.ID24
#define CAN1TXIDR0_ID25                 _CAN1TXIDR0.Bits.ID25
#define CAN1TXIDR0_ID26                 _CAN1TXIDR0.Bits.ID26
#define CAN1TXIDR0_ID27                 _CAN1TXIDR0.Bits.ID27
#define CAN1TXIDR0_ID28                 _CAN1TXIDR0.Bits.ID28
/* CAN1TXIDR_ARR: Access 4 CAN1TXIDRx registers in an array */
#define CAN1TXIDR_ARR                   ((volatile byte *) &CAN1TXIDR0)

#define CAN1TXIDR0_ID21_MASK            1U
#define CAN1TXIDR0_ID22_MASK            2U
#define CAN1TXIDR0_ID23_MASK            4U
#define CAN1TXIDR0_ID24_MASK            8U
#define CAN1TXIDR0_ID25_MASK            16U
#define CAN1TXIDR0_ID26_MASK            32U
#define CAN1TXIDR0_ID27_MASK            64U
#define CAN1TXIDR0_ID28_MASK            128U


/*** CAN1TXIDR1 - MSCAN1 Transmit Identifier Register 1; 0x000001B1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN1TXIDR1STR;
extern volatile CAN1TXIDR1STR _CAN1TXIDR1 @(REG_BASE + 0x000001B1UL);
#define CAN1TXIDR1                      _CAN1TXIDR1.Byte
#define CAN1TXIDR1_ID15                 _CAN1TXIDR1.Bits.ID15
#define CAN1TXIDR1_ID16                 _CAN1TXIDR1.Bits.ID16
#define CAN1TXIDR1_ID17                 _CAN1TXIDR1.Bits.ID17
#define CAN1TXIDR1_IDE                  _CAN1TXIDR1.Bits.IDE
#define CAN1TXIDR1_SRR                  _CAN1TXIDR1.Bits.SRR
#define CAN1TXIDR1_ID18                 _CAN1TXIDR1.Bits.ID18
#define CAN1TXIDR1_ID19                 _CAN1TXIDR1.Bits.ID19
#define CAN1TXIDR1_ID20                 _CAN1TXIDR1.Bits.ID20
#define CAN1TXIDR1_ID_15                _CAN1TXIDR1.MergedBits.grpID_15
#define CAN1TXIDR1_ID_18                _CAN1TXIDR1.MergedBits.grpID_18
#define CAN1TXIDR1_ID                   CAN1TXIDR1_ID_15

#define CAN1TXIDR1_ID15_MASK            1U
#define CAN1TXIDR1_ID16_MASK            2U
#define CAN1TXIDR1_ID17_MASK            4U
#define CAN1TXIDR1_IDE_MASK             8U
#define CAN1TXIDR1_SRR_MASK             16U
#define CAN1TXIDR1_ID18_MASK            32U
#define CAN1TXIDR1_ID19_MASK            64U
#define CAN1TXIDR1_ID20_MASK            128U
#define CAN1TXIDR1_ID_15_MASK           7U
#define CAN1TXIDR1_ID_15_BITNUM         0U
#define CAN1TXIDR1_ID_18_MASK           224U
#define CAN1TXIDR1_ID_18_BITNUM         5U


/*** CAN1TXIDR2 - MSCAN1 Transmit Identifier Register 2; 0x000001B2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN1TXIDR2STR;
extern volatile CAN1TXIDR2STR _CAN1TXIDR2 @(REG_BASE + 0x000001B2UL);
#define CAN1TXIDR2                      _CAN1TXIDR2.Byte
#define CAN1TXIDR2_ID7                  _CAN1TXIDR2.Bits.ID7
#define CAN1TXIDR2_ID8                  _CAN1TXIDR2.Bits.ID8
#define CAN1TXIDR2_ID9                  _CAN1TXIDR2.Bits.ID9
#define CAN1TXIDR2_ID10                 _CAN1TXIDR2.Bits.ID10
#define CAN1TXIDR2_ID11                 _CAN1TXIDR2.Bits.ID11
#define CAN1TXIDR2_ID12                 _CAN1TXIDR2.Bits.ID12
#define CAN1TXIDR2_ID13                 _CAN1TXIDR2.Bits.ID13
#define CAN1TXIDR2_ID14                 _CAN1TXIDR2.Bits.ID14

#define CAN1TXIDR2_ID7_MASK             1U
#define CAN1TXIDR2_ID8_MASK             2U
#define CAN1TXIDR2_ID9_MASK             4U
#define CAN1TXIDR2_ID10_MASK            8U
#define CAN1TXIDR2_ID11_MASK            16U
#define CAN1TXIDR2_ID12_MASK            32U
#define CAN1TXIDR2_ID13_MASK            64U
#define CAN1TXIDR2_ID14_MASK            128U


/*** CAN1TXIDR3 - MSCAN1 Transmit Identifier Register 3; 0x000001B3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN1TXIDR3STR;
extern volatile CAN1TXIDR3STR _CAN1TXIDR3 @(REG_BASE + 0x000001B3UL);
#define CAN1TXIDR3                      _CAN1TXIDR3.Byte
#define CAN1TXIDR3_RTR                  _CAN1TXIDR3.Bits.RTR
#define CAN1TXIDR3_ID0                  _CAN1TXIDR3.Bits.ID0
#define CAN1TXIDR3_ID1                  _CAN1TXIDR3.Bits.ID1
#define CAN1TXIDR3_ID2                  _CAN1TXIDR3.Bits.ID2
#define CAN1TXIDR3_ID3                  _CAN1TXIDR3.Bits.ID3
#define CAN1TXIDR3_ID4                  _CAN1TXIDR3.Bits.ID4
#define CAN1TXIDR3_ID5                  _CAN1TXIDR3.Bits.ID5
#define CAN1TXIDR3_ID6                  _CAN1TXIDR3.Bits.ID6
#define CAN1TXIDR3_ID                   _CAN1TXIDR3.MergedBits.grpID

#define CAN1TXIDR3_RTR_MASK             1U
#define CAN1TXIDR3_ID0_MASK             2U
#define CAN1TXIDR3_ID1_MASK             4U
#define CAN1TXIDR3_ID2_MASK             8U
#define CAN1TXIDR3_ID3_MASK             16U
#define CAN1TXIDR3_ID4_MASK             32U
#define CAN1TXIDR3_ID5_MASK             64U
#define CAN1TXIDR3_ID6_MASK             128U
#define CAN1TXIDR3_ID_MASK              254U
#define CAN1TXIDR3_ID_BITNUM            1U


/*** CAN1TXDSR0 - MSCAN1 Transmit Data Segment Register 0; 0x000001B4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR0STR;
extern volatile CAN1TXDSR0STR _CAN1TXDSR0 @(REG_BASE + 0x000001B4UL);
#define CAN1TXDSR0                      _CAN1TXDSR0.Byte
#define CAN1TXDSR0_DB0                  _CAN1TXDSR0.Bits.DB0
#define CAN1TXDSR0_DB1                  _CAN1TXDSR0.Bits.DB1
#define CAN1TXDSR0_DB2                  _CAN1TXDSR0.Bits.DB2
#define CAN1TXDSR0_DB3                  _CAN1TXDSR0.Bits.DB3
#define CAN1TXDSR0_DB4                  _CAN1TXDSR0.Bits.DB4
#define CAN1TXDSR0_DB5                  _CAN1TXDSR0.Bits.DB5
#define CAN1TXDSR0_DB6                  _CAN1TXDSR0.Bits.DB6
#define CAN1TXDSR0_DB7                  _CAN1TXDSR0.Bits.DB7
/* CAN1TXDSR_ARR: Access 8 CAN1TXDSRx registers in an array */
#define CAN1TXDSR_ARR                   ((volatile byte *) &CAN1TXDSR0)

#define CAN1TXDSR0_DB0_MASK             1U
#define CAN1TXDSR0_DB1_MASK             2U
#define CAN1TXDSR0_DB2_MASK             4U
#define CAN1TXDSR0_DB3_MASK             8U
#define CAN1TXDSR0_DB4_MASK             16U
#define CAN1TXDSR0_DB5_MASK             32U
#define CAN1TXDSR0_DB6_MASK             64U
#define CAN1TXDSR0_DB7_MASK             128U


/*** CAN1TXDSR1 - MSCAN1 Transmit Data Segment Register 1; 0x000001B5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR1STR;
extern volatile CAN1TXDSR1STR _CAN1TXDSR1 @(REG_BASE + 0x000001B5UL);
#define CAN1TXDSR1                      _CAN1TXDSR1.Byte
#define CAN1TXDSR1_DB0                  _CAN1TXDSR1.Bits.DB0
#define CAN1TXDSR1_DB1                  _CAN1TXDSR1.Bits.DB1
#define CAN1TXDSR1_DB2                  _CAN1TXDSR1.Bits.DB2
#define CAN1TXDSR1_DB3                  _CAN1TXDSR1.Bits.DB3
#define CAN1TXDSR1_DB4                  _CAN1TXDSR1.Bits.DB4
#define CAN1TXDSR1_DB5                  _CAN1TXDSR1.Bits.DB5
#define CAN1TXDSR1_DB6                  _CAN1TXDSR1.Bits.DB6
#define CAN1TXDSR1_DB7                  _CAN1TXDSR1.Bits.DB7

#define CAN1TXDSR1_DB0_MASK             1U
#define CAN1TXDSR1_DB1_MASK             2U
#define CAN1TXDSR1_DB2_MASK             4U
#define CAN1TXDSR1_DB3_MASK             8U
#define CAN1TXDSR1_DB4_MASK             16U
#define CAN1TXDSR1_DB5_MASK             32U
#define CAN1TXDSR1_DB6_MASK             64U
#define CAN1TXDSR1_DB7_MASK             128U


/*** CAN1TXDSR2 - MSCAN1 Transmit Data Segment Register 2; 0x000001B6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR2STR;
extern volatile CAN1TXDSR2STR _CAN1TXDSR2 @(REG_BASE + 0x000001B6UL);
#define CAN1TXDSR2                      _CAN1TXDSR2.Byte
#define CAN1TXDSR2_DB0                  _CAN1TXDSR2.Bits.DB0
#define CAN1TXDSR2_DB1                  _CAN1TXDSR2.Bits.DB1
#define CAN1TXDSR2_DB2                  _CAN1TXDSR2.Bits.DB2
#define CAN1TXDSR2_DB3                  _CAN1TXDSR2.Bits.DB3
#define CAN1TXDSR2_DB4                  _CAN1TXDSR2.Bits.DB4
#define CAN1TXDSR2_DB5                  _CAN1TXDSR2.Bits.DB5
#define CAN1TXDSR2_DB6                  _CAN1TXDSR2.Bits.DB6
#define CAN1TXDSR2_DB7                  _CAN1TXDSR2.Bits.DB7

#define CAN1TXDSR2_DB0_MASK             1U
#define CAN1TXDSR2_DB1_MASK             2U
#define CAN1TXDSR2_DB2_MASK             4U
#define CAN1TXDSR2_DB3_MASK             8U
#define CAN1TXDSR2_DB4_MASK             16U
#define CAN1TXDSR2_DB5_MASK             32U
#define CAN1TXDSR2_DB6_MASK             64U
#define CAN1TXDSR2_DB7_MASK             128U


/*** CAN1TXDSR3 - MSCAN1 Transmit Data Segment Register 3; 0x000001B7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR3STR;
extern volatile CAN1TXDSR3STR _CAN1TXDSR3 @(REG_BASE + 0x000001B7UL);
#define CAN1TXDSR3                      _CAN1TXDSR3.Byte
#define CAN1TXDSR3_DB0                  _CAN1TXDSR3.Bits.DB0
#define CAN1TXDSR3_DB1                  _CAN1TXDSR3.Bits.DB1
#define CAN1TXDSR3_DB2                  _CAN1TXDSR3.Bits.DB2
#define CAN1TXDSR3_DB3                  _CAN1TXDSR3.Bits.DB3
#define CAN1TXDSR3_DB4                  _CAN1TXDSR3.Bits.DB4
#define CAN1TXDSR3_DB5                  _CAN1TXDSR3.Bits.DB5
#define CAN1TXDSR3_DB6                  _CAN1TXDSR3.Bits.DB6
#define CAN1TXDSR3_DB7                  _CAN1TXDSR3.Bits.DB7

#define CAN1TXDSR3_DB0_MASK             1U
#define CAN1TXDSR3_DB1_MASK             2U
#define CAN1TXDSR3_DB2_MASK             4U
#define CAN1TXDSR3_DB3_MASK             8U
#define CAN1TXDSR3_DB4_MASK             16U
#define CAN1TXDSR3_DB5_MASK             32U
#define CAN1TXDSR3_DB6_MASK             64U
#define CAN1TXDSR3_DB7_MASK             128U


/*** CAN1TXDSR4 - MSCAN1 Transmit Data Segment Register 4; 0x000001B8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR4STR;
extern volatile CAN1TXDSR4STR _CAN1TXDSR4 @(REG_BASE + 0x000001B8UL);
#define CAN1TXDSR4                      _CAN1TXDSR4.Byte
#define CAN1TXDSR4_DB0                  _CAN1TXDSR4.Bits.DB0
#define CAN1TXDSR4_DB1                  _CAN1TXDSR4.Bits.DB1
#define CAN1TXDSR4_DB2                  _CAN1TXDSR4.Bits.DB2
#define CAN1TXDSR4_DB3                  _CAN1TXDSR4.Bits.DB3
#define CAN1TXDSR4_DB4                  _CAN1TXDSR4.Bits.DB4
#define CAN1TXDSR4_DB5                  _CAN1TXDSR4.Bits.DB5
#define CAN1TXDSR4_DB6                  _CAN1TXDSR4.Bits.DB6
#define CAN1TXDSR4_DB7                  _CAN1TXDSR4.Bits.DB7

#define CAN1TXDSR4_DB0_MASK             1U
#define CAN1TXDSR4_DB1_MASK             2U
#define CAN1TXDSR4_DB2_MASK             4U
#define CAN1TXDSR4_DB3_MASK             8U
#define CAN1TXDSR4_DB4_MASK             16U
#define CAN1TXDSR4_DB5_MASK             32U
#define CAN1TXDSR4_DB6_MASK             64U
#define CAN1TXDSR4_DB7_MASK             128U


/*** CAN1TXDSR5 - MSCAN1 Transmit Data Segment Register 5; 0x000001B9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR5STR;
extern volatile CAN1TXDSR5STR _CAN1TXDSR5 @(REG_BASE + 0x000001B9UL);
#define CAN1TXDSR5                      _CAN1TXDSR5.Byte
#define CAN1TXDSR5_DB0                  _CAN1TXDSR5.Bits.DB0
#define CAN1TXDSR5_DB1                  _CAN1TXDSR5.Bits.DB1
#define CAN1TXDSR5_DB2                  _CAN1TXDSR5.Bits.DB2
#define CAN1TXDSR5_DB3                  _CAN1TXDSR5.Bits.DB3
#define CAN1TXDSR5_DB4                  _CAN1TXDSR5.Bits.DB4
#define CAN1TXDSR5_DB5                  _CAN1TXDSR5.Bits.DB5
#define CAN1TXDSR5_DB6                  _CAN1TXDSR5.Bits.DB6
#define CAN1TXDSR5_DB7                  _CAN1TXDSR5.Bits.DB7

#define CAN1TXDSR5_DB0_MASK             1U
#define CAN1TXDSR5_DB1_MASK             2U
#define CAN1TXDSR5_DB2_MASK             4U
#define CAN1TXDSR5_DB3_MASK             8U
#define CAN1TXDSR5_DB4_MASK             16U
#define CAN1TXDSR5_DB5_MASK             32U
#define CAN1TXDSR5_DB6_MASK             64U
#define CAN1TXDSR5_DB7_MASK             128U


/*** CAN1TXDSR6 - MSCAN1 Transmit Data Segment Register 6; 0x000001BA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR6STR;
extern volatile CAN1TXDSR6STR _CAN1TXDSR6 @(REG_BASE + 0x000001BAUL);
#define CAN1TXDSR6                      _CAN1TXDSR6.Byte
#define CAN1TXDSR6_DB0                  _CAN1TXDSR6.Bits.DB0
#define CAN1TXDSR6_DB1                  _CAN1TXDSR6.Bits.DB1
#define CAN1TXDSR6_DB2                  _CAN1TXDSR6.Bits.DB2
#define CAN1TXDSR6_DB3                  _CAN1TXDSR6.Bits.DB3
#define CAN1TXDSR6_DB4                  _CAN1TXDSR6.Bits.DB4
#define CAN1TXDSR6_DB5                  _CAN1TXDSR6.Bits.DB5
#define CAN1TXDSR6_DB6                  _CAN1TXDSR6.Bits.DB6
#define CAN1TXDSR6_DB7                  _CAN1TXDSR6.Bits.DB7

#define CAN1TXDSR6_DB0_MASK             1U
#define CAN1TXDSR6_DB1_MASK             2U
#define CAN1TXDSR6_DB2_MASK             4U
#define CAN1TXDSR6_DB3_MASK             8U
#define CAN1TXDSR6_DB4_MASK             16U
#define CAN1TXDSR6_DB5_MASK             32U
#define CAN1TXDSR6_DB6_MASK             64U
#define CAN1TXDSR6_DB7_MASK             128U


/*** CAN1TXDSR7 - MSCAN1 Transmit Data Segment Register 7; 0x000001BB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR7STR;
extern volatile CAN1TXDSR7STR _CAN1TXDSR7 @(REG_BASE + 0x000001BBUL);
#define CAN1TXDSR7                      _CAN1TXDSR7.Byte
#define CAN1TXDSR7_DB0                  _CAN1TXDSR7.Bits.DB0
#define CAN1TXDSR7_DB1                  _CAN1TXDSR7.Bits.DB1
#define CAN1TXDSR7_DB2                  _CAN1TXDSR7.Bits.DB2
#define CAN1TXDSR7_DB3                  _CAN1TXDSR7.Bits.DB3
#define CAN1TXDSR7_DB4                  _CAN1TXDSR7.Bits.DB4
#define CAN1TXDSR7_DB5                  _CAN1TXDSR7.Bits.DB5
#define CAN1TXDSR7_DB6                  _CAN1TXDSR7.Bits.DB6
#define CAN1TXDSR7_DB7                  _CAN1TXDSR7.Bits.DB7

#define CAN1TXDSR7_DB0_MASK             1U
#define CAN1TXDSR7_DB1_MASK             2U
#define CAN1TXDSR7_DB2_MASK             4U
#define CAN1TXDSR7_DB3_MASK             8U
#define CAN1TXDSR7_DB4_MASK             16U
#define CAN1TXDSR7_DB5_MASK             32U
#define CAN1TXDSR7_DB6_MASK             64U
#define CAN1TXDSR7_DB7_MASK             128U


/*** CAN1TXDLR - MSCAN1 Transmit Data Length Register; 0x000001BC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TXDLRSTR;
extern volatile CAN1TXDLRSTR _CAN1TXDLR @(REG_BASE + 0x000001BCUL);
#define CAN1TXDLR                       _CAN1TXDLR.Byte
#define CAN1TXDLR_DLC0                  _CAN1TXDLR.Bits.DLC0
#define CAN1TXDLR_DLC1                  _CAN1TXDLR.Bits.DLC1
#define CAN1TXDLR_DLC2                  _CAN1TXDLR.Bits.DLC2
#define CAN1TXDLR_DLC3                  _CAN1TXDLR.Bits.DLC3
#define CAN1TXDLR_DLC                   _CAN1TXDLR.MergedBits.grpDLC

#define CAN1TXDLR_DLC0_MASK             1U
#define CAN1TXDLR_DLC1_MASK             2U
#define CAN1TXDLR_DLC2_MASK             4U
#define CAN1TXDLR_DLC3_MASK             8U
#define CAN1TXDLR_DLC_MASK              15U
#define CAN1TXDLR_DLC_BITNUM            0U


/*** CAN1TXTBPR - MSCAN1 Transmit Buffer Priority; 0x000001BD ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN1TXTBPRSTR;
extern volatile CAN1TXTBPRSTR _CAN1TXTBPR @(REG_BASE + 0x000001BDUL);
#define CAN1TXTBPR                      _CAN1TXTBPR.Byte
#define CAN1TXTBPR_PRIO0                _CAN1TXTBPR.Bits.PRIO0
#define CAN1TXTBPR_PRIO1                _CAN1TXTBPR.Bits.PRIO1
#define CAN1TXTBPR_PRIO2                _CAN1TXTBPR.Bits.PRIO2
#define CAN1TXTBPR_PRIO3                _CAN1TXTBPR.Bits.PRIO3
#define CAN1TXTBPR_PRIO4                _CAN1TXTBPR.Bits.PRIO4
#define CAN1TXTBPR_PRIO5                _CAN1TXTBPR.Bits.PRIO5
#define CAN1TXTBPR_PRIO6                _CAN1TXTBPR.Bits.PRIO6
#define CAN1TXTBPR_PRIO7                _CAN1TXTBPR.Bits.PRIO7

#define CAN1TXTBPR_PRIO0_MASK           1U
#define CAN1TXTBPR_PRIO1_MASK           2U
#define CAN1TXTBPR_PRIO2_MASK           4U
#define CAN1TXTBPR_PRIO3_MASK           8U
#define CAN1TXTBPR_PRIO4_MASK           16U
#define CAN1TXTBPR_PRIO5_MASK           32U
#define CAN1TXTBPR_PRIO6_MASK           64U
#define CAN1TXTBPR_PRIO7_MASK           128U


/*** CAN1TXTSR - MSCAN1 Transmit Time Stamp Register; 0x000001BE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN1TXTSRH - MSCAN1 Transmit Time Stamp Register High; 0x000001BE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN1TXTSRHSTR;
    #define CAN1TXTSRH                  _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Byte
    #define CAN1TXTSRH_TSR8             _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR8
    #define CAN1TXTSRH_TSR9             _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR9
    #define CAN1TXTSRH_TSR10            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR10
    #define CAN1TXTSRH_TSR11            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR11
    #define CAN1TXTSRH_TSR12            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR12
    #define CAN1TXTSRH_TSR13            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR13
    #define CAN1TXTSRH_TSR14            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR14
    #define CAN1TXTSRH_TSR15            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR15
    
    #define CAN1TXTSRH_TSR8_MASK        1U
    #define CAN1TXTSRH_TSR9_MASK        2U
    #define CAN1TXTSRH_TSR10_MASK       4U
    #define CAN1TXTSRH_TSR11_MASK       8U
    #define CAN1TXTSRH_TSR12_MASK       16U
    #define CAN1TXTSRH_TSR13_MASK       32U
    #define CAN1TXTSRH_TSR14_MASK       64U
    #define CAN1TXTSRH_TSR15_MASK       128U
    

    /*** CAN1TXTSRL - MSCAN1 Transmit Time Stamp Register Low; 0x000001BF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN1TXTSRLSTR;
    #define CAN1TXTSRL                  _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Byte
    #define CAN1TXTSRL_TSR0             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR0
    #define CAN1TXTSRL_TSR1             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR1
    #define CAN1TXTSRL_TSR2             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR2
    #define CAN1TXTSRL_TSR3             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR3
    #define CAN1TXTSRL_TSR4             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR4
    #define CAN1TXTSRL_TSR5             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR5
    #define CAN1TXTSRL_TSR6             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR6
    #define CAN1TXTSRL_TSR7             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR7
    
    #define CAN1TXTSRL_TSR0_MASK        1U
    #define CAN1TXTSRL_TSR1_MASK        2U
    #define CAN1TXTSRL_TSR2_MASK        4U
    #define CAN1TXTSRL_TSR3_MASK        8U
    #define CAN1TXTSRL_TSR4_MASK        16U
    #define CAN1TXTSRL_TSR5_MASK        32U
    #define CAN1TXTSRL_TSR6_MASK        64U
    #define CAN1TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN1TXTSRSTR;
extern volatile CAN1TXTSRSTR _CAN1TXTSR @(REG_BASE + 0x000001BEUL);
#define CAN1TXTSR                       _CAN1TXTSR.Word
#define CAN1TXTSR_TSR0                  _CAN1TXTSR.Bits.TSR0
#define CAN1TXTSR_TSR1                  _CAN1TXTSR.Bits.TSR1
#define CAN1TXTSR_TSR2                  _CAN1TXTSR.Bits.TSR2
#define CAN1TXTSR_TSR3                  _CAN1TXTSR.Bits.TSR3
#define CAN1TXTSR_TSR4                  _CAN1TXTSR.Bits.TSR4
#define CAN1TXTSR_TSR5                  _CAN1TXTSR.Bits.TSR5
#define CAN1TXTSR_TSR6                  _CAN1TXTSR.Bits.TSR6
#define CAN1TXTSR_TSR7                  _CAN1TXTSR.Bits.TSR7
#define CAN1TXTSR_TSR8                  _CAN1TXTSR.Bits.TSR8
#define CAN1TXTSR_TSR9                  _CAN1TXTSR.Bits.TSR9
#define CAN1TXTSR_TSR10                 _CAN1TXTSR.Bits.TSR10
#define CAN1TXTSR_TSR11                 _CAN1TXTSR.Bits.TSR11
#define CAN1TXTSR_TSR12                 _CAN1TXTSR.Bits.TSR12
#define CAN1TXTSR_TSR13                 _CAN1TXTSR.Bits.TSR13
#define CAN1TXTSR_TSR14                 _CAN1TXTSR.Bits.TSR14
#define CAN1TXTSR_TSR15                 _CAN1TXTSR.Bits.TSR15

#define CAN1TXTSR_TSR0_MASK             1U
#define CAN1TXTSR_TSR1_MASK             2U
#define CAN1TXTSR_TSR2_MASK             4U
#define CAN1TXTSR_TSR3_MASK             8U
#define CAN1TXTSR_TSR4_MASK             16U
#define CAN1TXTSR_TSR5_MASK             32U
#define CAN1TXTSR_TSR6_MASK             64U
#define CAN1TXTSR_TSR7_MASK             128U
#define CAN1TXTSR_TSR8_MASK             256U
#define CAN1TXTSR_TSR9_MASK             512U
#define CAN1TXTSR_TSR10_MASK            1024U
#define CAN1TXTSR_TSR11_MASK            2048U
#define CAN1TXTSR_TSR12_MASK            4096U
#define CAN1TXTSR_TSR13_MASK            8192U
#define CAN1TXTSR_TSR14_MASK            16384U
#define CAN1TXTSR_TSR15_MASK            32768U


/*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***/
typedef union {
  byte Byte;
  struct {
    byte MCTOIF      :1;                                       /* Motor Controller Timer Counter Overflow Interrupt Flag */
    byte             :1; 
    byte DITH        :1;                                       /* Motor Control/Driver Dither Feature Enable */
    byte FAST        :1;                                       /* Motor Controller PWM Resolution Mode */
    byte MCSWAI      :1;                                       /* Motor Controller Module Stop in Wait Mode */
    byte MCPRE0      :1;                                       /* Motor Controller Prescaler Select, bit 0 */
    byte MCPRE1      :1;                                       /* Motor Controller Prescaler Select, bit 1 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMCPRE :2;
    byte         :1;
  } MergedBits;
} MCCTL0STR;
extern volatile MCCTL0STR _MCCTL0 @(REG_BASE + 0x000001C0UL);
#define MCCTL0                          _MCCTL0.Byte
#define MCCTL0_MCTOIF                   _MCCTL0.Bits.MCTOIF
#define MCCTL0_DITH                     _MCCTL0.Bits.DITH
#define MCCTL0_FAST                     _MCCTL0.Bits.FAST
#define MCCTL0_MCSWAI                   _MCCTL0.Bits.MCSWAI
#define MCCTL0_MCPRE0                   _MCCTL0.Bits.MCPRE0
#define MCCTL0_MCPRE1                   _MCCTL0.Bits.MCPRE1
/* MCCTL_ARR: Access 2 MCCTLx registers in an array */
#define MCCTL_ARR                       ((volatile byte *) &MCCTL0)
#define MCCTL0_MCPRE                    _MCCTL0.MergedBits.grpMCPRE

#define MCCTL0_MCTOIF_MASK              1U
#define MCCTL0_DITH_MASK                4U
#define MCCTL0_FAST_MASK                8U
#define MCCTL0_MCSWAI_MASK              16U
#define MCCTL0_MCPRE0_MASK              32U
#define MCCTL0_MCPRE1_MASK              64U
#define MCCTL0_MCPRE_MASK               96U
#define MCCTL0_MCPRE_BITNUM             5U


/*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***/
typedef union {
  byte Byte;
  struct {
    byte MCTOIE      :1;                                       /* Motor Controller Timer Counter Overflow Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RECIRC      :1;                                       /* Recirculation in (Dual) Full H-Bridge Mode */
  } Bits;
} MCCTL1STR;
extern volatile MCCTL1STR _MCCTL1 @(REG_BASE + 0x000001C1UL);
#define MCCTL1                          _MCCTL1.Byte
#define MCCTL1_MCTOIE                   _MCCTL1.Bits.MCTOIE
#define MCCTL1_RECIRC                   _MCCTL1.Bits.RECIRC

#define MCCTL1_MCTOIE_MASK              1U
#define MCCTL1_RECIRC_MASK              128U


/*** MCPER - Motor Controller Period Register; 0x000001C2 ***/
typedef union {
  word Word;
  struct {
    word P0          :1;                                       /* Motor Controller Period Bit 1 */
    word P1          :1;                                       /* Motor Controller Period, bit 1 */
    word P2          :1;                                       /* Motor Controller Period, bit 2 */
    word P3          :1;                                       /* Motor Controller Period, bit 3 */
    word P4          :1;                                       /* Motor Controller Period, bit 4 */
    word P5          :1;                                       /* Motor Controller Period, bit 5 */
    word P6          :1;                                       /* Motor Controller Period, bit 6 */
    word P7          :1;                                       /* Motor Controller Period, bit 7 */
    word P8          :1;                                       /* Motor Controller Period, bit 8 */
    word P9          :1;                                       /* Motor Controller Period, bit 9 */
    word P10         :1;                                       /* Motor Controller Period, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpP    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCPERSTR;
extern volatile MCPERSTR _MCPER @(REG_BASE + 0x000001C2UL);
#define MCPER                           _MCPER.Word
#define MCPER_P0                        _MCPER.Bits.P0
#define MCPER_P1                        _MCPER.Bits.P1
#define MCPER_P2                        _MCPER.Bits.P2
#define MCPER_P3                        _MCPER.Bits.P3
#define MCPER_P4                        _MCPER.Bits.P4
#define MCPER_P5                        _MCPER.Bits.P5
#define MCPER_P6                        _MCPER.Bits.P6
#define MCPER_P7                        _MCPER.Bits.P7
#define MCPER_P8                        _MCPER.Bits.P8
#define MCPER_P9                        _MCPER.Bits.P9
#define MCPER_P10                       _MCPER.Bits.P10
#define MCPER_P                         _MCPER.MergedBits.grpP

#define MCPER_P0_MASK                   1U
#define MCPER_P1_MASK                   2U
#define MCPER_P2_MASK                   4U
#define MCPER_P3_MASK                   8U
#define MCPER_P4_MASK                   16U
#define MCPER_P5_MASK                   32U
#define MCPER_P6_MASK                   64U
#define MCPER_P7_MASK                   128U
#define MCPER_P8_MASK                   256U
#define MCPER_P9_MASK                   512U
#define MCPER_P10_MASK                  1024U
#define MCPER_P_MASK                    2047U
#define MCPER_P_BITNUM                  0U


/*** MCCC0 - Motor Controller Control Register 0; 0x000001D0 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC0STR;
extern volatile MCCC0STR _MCCC0 @(REG_BASE + 0x000001D0UL);
#define MCCC0                           _MCCC0.Byte
#define MCCC0_CD0                       _MCCC0.Bits.CD0
#define MCCC0_CD1                       _MCCC0.Bits.CD1
#define MCCC0_MCAM0                     _MCCC0.Bits.MCAM0
#define MCCC0_MCAM1                     _MCCC0.Bits.MCAM1
#define MCCC0_MCOM0                     _MCCC0.Bits.MCOM0
#define MCCC0_MCOM1                     _MCCC0.Bits.MCOM1
/* MCCC_ARR: Access 12 MCCCx registers in an array */
#define MCCC_ARR                        ((volatile byte *) &MCCC0)
#define MCCC0_CD                        _MCCC0.MergedBits.grpCD
#define MCCC0_MCAM                      _MCCC0.MergedBits.grpMCAM
#define MCCC0_MCOM                      _MCCC0.MergedBits.grpMCOM

#define MCCC0_CD0_MASK                  1U
#define MCCC0_CD1_MASK                  2U
#define MCCC0_MCAM0_MASK                16U
#define MCCC0_MCAM1_MASK                32U
#define MCCC0_MCOM0_MASK                64U
#define MCCC0_MCOM1_MASK                128U
#define MCCC0_CD_MASK                   3U
#define MCCC0_CD_BITNUM                 0U
#define MCCC0_MCAM_MASK                 48U
#define MCCC0_MCAM_BITNUM               4U
#define MCCC0_MCOM_MASK                 192U
#define MCCC0_MCOM_BITNUM               6U


/*** MCCC1 - Motor Controller Control Register 1; 0x000001D1 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC1STR;
extern volatile MCCC1STR _MCCC1 @(REG_BASE + 0x000001D1UL);
#define MCCC1                           _MCCC1.Byte
#define MCCC1_CD0                       _MCCC1.Bits.CD0
#define MCCC1_CD1                       _MCCC1.Bits.CD1
#define MCCC1_MCAM0                     _MCCC1.Bits.MCAM0
#define MCCC1_MCAM1                     _MCCC1.Bits.MCAM1
#define MCCC1_MCOM0                     _MCCC1.Bits.MCOM0
#define MCCC1_MCOM1                     _MCCC1.Bits.MCOM1
#define MCCC1_CD                        _MCCC1.MergedBits.grpCD
#define MCCC1_MCAM                      _MCCC1.MergedBits.grpMCAM
#define MCCC1_MCOM                      _MCCC1.MergedBits.grpMCOM

#define MCCC1_CD0_MASK                  1U
#define MCCC1_CD1_MASK                  2U
#define MCCC1_MCAM0_MASK                16U
#define MCCC1_MCAM1_MASK                32U
#define MCCC1_MCOM0_MASK                64U
#define MCCC1_MCOM1_MASK                128U
#define MCCC1_CD_MASK                   3U
#define MCCC1_CD_BITNUM                 0U
#define MCCC1_MCAM_MASK                 48U
#define MCCC1_MCAM_BITNUM               4U
#define MCCC1_MCOM_MASK                 192U
#define MCCC1_MCOM_BITNUM               6U


/*** MCCC2 - Motor Controller Control Register 2; 0x000001D2 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC2STR;
extern volatile MCCC2STR _MCCC2 @(REG_BASE + 0x000001D2UL);
#define MCCC2                           _MCCC2.Byte
#define MCCC2_CD0                       _MCCC2.Bits.CD0
#define MCCC2_CD1                       _MCCC2.Bits.CD1
#define MCCC2_MCAM0                     _MCCC2.Bits.MCAM0
#define MCCC2_MCAM1                     _MCCC2.Bits.MCAM1
#define MCCC2_MCOM0                     _MCCC2.Bits.MCOM0
#define MCCC2_MCOM1                     _MCCC2.Bits.MCOM1
#define MCCC2_CD                        _MCCC2.MergedBits.grpCD
#define MCCC2_MCAM                      _MCCC2.MergedBits.grpMCAM
#define MCCC2_MCOM                      _MCCC2.MergedBits.grpMCOM

#define MCCC2_CD0_MASK                  1U
#define MCCC2_CD1_MASK                  2U
#define MCCC2_MCAM0_MASK                16U
#define MCCC2_MCAM1_MASK                32U
#define MCCC2_MCOM0_MASK                64U
#define MCCC2_MCOM1_MASK                128U
#define MCCC2_CD_MASK                   3U
#define MCCC2_CD_BITNUM                 0U
#define MCCC2_MCAM_MASK                 48U
#define MCCC2_MCAM_BITNUM               4U
#define MCCC2_MCOM_MASK                 192U
#define MCCC2_MCOM_BITNUM               6U


/*** MCCC3 - Motor Controller Control Register 3; 0x000001D3 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC3STR;
extern volatile MCCC3STR _MCCC3 @(REG_BASE + 0x000001D3UL);
#define MCCC3                           _MCCC3.Byte
#define MCCC3_CD0                       _MCCC3.Bits.CD0
#define MCCC3_CD1                       _MCCC3.Bits.CD1
#define MCCC3_MCAM0                     _MCCC3.Bits.MCAM0
#define MCCC3_MCAM1                     _MCCC3.Bits.MCAM1
#define MCCC3_MCOM0                     _MCCC3.Bits.MCOM0
#define MCCC3_MCOM1                     _MCCC3.Bits.MCOM1
#define MCCC3_CD                        _MCCC3.MergedBits.grpCD
#define MCCC3_MCAM                      _MCCC3.MergedBits.grpMCAM
#define MCCC3_MCOM                      _MCCC3.MergedBits.grpMCOM

#define MCCC3_CD0_MASK                  1U
#define MCCC3_CD1_MASK                  2U
#define MCCC3_MCAM0_MASK                16U
#define MCCC3_MCAM1_MASK                32U
#define MCCC3_MCOM0_MASK                64U
#define MCCC3_MCOM1_MASK                128U
#define MCCC3_CD_MASK                   3U
#define MCCC3_CD_BITNUM                 0U
#define MCCC3_MCAM_MASK                 48U
#define MCCC3_MCAM_BITNUM               4U
#define MCCC3_MCOM_MASK                 192U
#define MCCC3_MCOM_BITNUM               6U


/*** MCCC4 - Motor Controller Control Register 4; 0x000001D4 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC4STR;
extern volatile MCCC4STR _MCCC4 @(REG_BASE + 0x000001D4UL);
#define MCCC4                           _MCCC4.Byte
#define MCCC4_CD0                       _MCCC4.Bits.CD0
#define MCCC4_CD1                       _MCCC4.Bits.CD1
#define MCCC4_MCAM0                     _MCCC4.Bits.MCAM0
#define MCCC4_MCAM1                     _MCCC4.Bits.MCAM1
#define MCCC4_MCOM0                     _MCCC4.Bits.MCOM0
#define MCCC4_MCOM1                     _MCCC4.Bits.MCOM1
#define MCCC4_CD                        _MCCC4.MergedBits.grpCD
#define MCCC4_MCAM                      _MCCC4.MergedBits.grpMCAM
#define MCCC4_MCOM                      _MCCC4.MergedBits.grpMCOM

#define MCCC4_CD0_MASK                  1U
#define MCCC4_CD1_MASK                  2U
#define MCCC4_MCAM0_MASK                16U
#define MCCC4_MCAM1_MASK                32U
#define MCCC4_MCOM0_MASK                64U
#define MCCC4_MCOM1_MASK                128U
#define MCCC4_CD_MASK                   3U
#define MCCC4_CD_BITNUM                 0U
#define MCCC4_MCAM_MASK                 48U
#define MCCC4_MCAM_BITNUM               4U
#define MCCC4_MCOM_MASK                 192U
#define MCCC4_MCOM_BITNUM               6U


/*** MCCC5 - Motor Controller Control Register 5; 0x000001D5 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC5STR;
extern volatile MCCC5STR _MCCC5 @(REG_BASE + 0x000001D5UL);
#define MCCC5                           _MCCC5.Byte
#define MCCC5_CD0                       _MCCC5.Bits.CD0
#define MCCC5_CD1                       _MCCC5.Bits.CD1
#define MCCC5_MCAM0                     _MCCC5.Bits.MCAM0
#define MCCC5_MCAM1                     _MCCC5.Bits.MCAM1
#define MCCC5_MCOM0                     _MCCC5.Bits.MCOM0
#define MCCC5_MCOM1                     _MCCC5.Bits.MCOM1
#define MCCC5_CD                        _MCCC5.MergedBits.grpCD
#define MCCC5_MCAM                      _MCCC5.MergedBits.grpMCAM
#define MCCC5_MCOM                      _MCCC5.MergedBits.grpMCOM

#define MCCC5_CD0_MASK                  1U
#define MCCC5_CD1_MASK                  2U
#define MCCC5_MCAM0_MASK                16U
#define MCCC5_MCAM1_MASK                32U
#define MCCC5_MCOM0_MASK                64U
#define MCCC5_MCOM1_MASK                128U
#define MCCC5_CD_MASK                   3U
#define MCCC5_CD_BITNUM                 0U
#define MCCC5_MCAM_MASK                 48U
#define MCCC5_MCAM_BITNUM               4U
#define MCCC5_MCOM_MASK                 192U
#define MCCC5_MCOM_BITNUM               6U


/*** MCCC6 - Motor Controller Control Register 6; 0x000001D6 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC6STR;
extern volatile MCCC6STR _MCCC6 @(REG_BASE + 0x000001D6UL);
#define MCCC6                           _MCCC6.Byte
#define MCCC6_CD0                       _MCCC6.Bits.CD0
#define MCCC6_CD1                       _MCCC6.Bits.CD1
#define MCCC6_MCAM0                     _MCCC6.Bits.MCAM0
#define MCCC6_MCAM1                     _MCCC6.Bits.MCAM1
#define MCCC6_MCOM0                     _MCCC6.Bits.MCOM0
#define MCCC6_MCOM1                     _MCCC6.Bits.MCOM1
#define MCCC6_CD                        _MCCC6.MergedBits.grpCD
#define MCCC6_MCAM                      _MCCC6.MergedBits.grpMCAM
#define MCCC6_MCOM                      _MCCC6.MergedBits.grpMCOM

#define MCCC6_CD0_MASK                  1U
#define MCCC6_CD1_MASK                  2U
#define MCCC6_MCAM0_MASK                16U
#define MCCC6_MCAM1_MASK                32U
#define MCCC6_MCOM0_MASK                64U
#define MCCC6_MCOM1_MASK                128U
#define MCCC6_CD_MASK                   3U
#define MCCC6_CD_BITNUM                 0U
#define MCCC6_MCAM_MASK                 48U
#define MCCC6_MCAM_BITNUM               4U
#define MCCC6_MCOM_MASK                 192U
#define MCCC6_MCOM_BITNUM               6U


/*** MCCC7 - Motor Controller Control Register 7; 0x000001D7 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC7STR;
extern volatile MCCC7STR _MCCC7 @(REG_BASE + 0x000001D7UL);
#define MCCC7                           _MCCC7.Byte
#define MCCC7_CD0                       _MCCC7.Bits.CD0
#define MCCC7_CD1                       _MCCC7.Bits.CD1
#define MCCC7_MCAM0                     _MCCC7.Bits.MCAM0
#define MCCC7_MCAM1                     _MCCC7.Bits.MCAM1
#define MCCC7_MCOM0                     _MCCC7.Bits.MCOM0
#define MCCC7_MCOM1                     _MCCC7.Bits.MCOM1
#define MCCC7_CD                        _MCCC7.MergedBits.grpCD
#define MCCC7_MCAM                      _MCCC7.MergedBits.grpMCAM
#define MCCC7_MCOM                      _MCCC7.MergedBits.grpMCOM

#define MCCC7_CD0_MASK                  1U
#define MCCC7_CD1_MASK                  2U
#define MCCC7_MCAM0_MASK                16U
#define MCCC7_MCAM1_MASK                32U
#define MCCC7_MCOM0_MASK                64U
#define MCCC7_MCOM1_MASK                128U
#define MCCC7_CD_MASK                   3U
#define MCCC7_CD_BITNUM                 0U
#define MCCC7_MCAM_MASK                 48U
#define MCCC7_MCAM_BITNUM               4U
#define MCCC7_MCOM_MASK                 192U
#define MCCC7_MCOM_BITNUM               6U


/*** MCCC8 - Motor Controller Control Register 8; 0x000001D8 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC8STR;
extern volatile MCCC8STR _MCCC8 @(REG_BASE + 0x000001D8UL);
#define MCCC8                           _MCCC8.Byte
#define MCCC8_CD0                       _MCCC8.Bits.CD0
#define MCCC8_CD1                       _MCCC8.Bits.CD1
#define MCCC8_MCAM0                     _MCCC8.Bits.MCAM0
#define MCCC8_MCAM1                     _MCCC8.Bits.MCAM1
#define MCCC8_MCOM0                     _MCCC8.Bits.MCOM0
#define MCCC8_MCOM1                     _MCCC8.Bits.MCOM1
#define MCCC8_CD                        _MCCC8.MergedBits.grpCD
#define MCCC8_MCAM                      _MCCC8.MergedBits.grpMCAM
#define MCCC8_MCOM                      _MCCC8.MergedBits.grpMCOM

#define MCCC8_CD0_MASK                  1U
#define MCCC8_CD1_MASK                  2U
#define MCCC8_MCAM0_MASK                16U
#define MCCC8_MCAM1_MASK                32U
#define MCCC8_MCOM0_MASK                64U
#define MCCC8_MCOM1_MASK                128U
#define MCCC8_CD_MASK                   3U
#define MCCC8_CD_BITNUM                 0U
#define MCCC8_MCAM_MASK                 48U
#define MCCC8_MCAM_BITNUM               4U
#define MCCC8_MCOM_MASK                 192U
#define MCCC8_MCOM_BITNUM               6U


/*** MCCC9 - Motor Controller Control Register 9; 0x000001D9 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC9STR;
extern volatile MCCC9STR _MCCC9 @(REG_BASE + 0x000001D9UL);
#define MCCC9                           _MCCC9.Byte
#define MCCC9_CD0                       _MCCC9.Bits.CD0
#define MCCC9_CD1                       _MCCC9.Bits.CD1
#define MCCC9_MCAM0                     _MCCC9.Bits.MCAM0
#define MCCC9_MCAM1                     _MCCC9.Bits.MCAM1
#define MCCC9_MCOM0                     _MCCC9.Bits.MCOM0
#define MCCC9_MCOM1                     _MCCC9.Bits.MCOM1
#define MCCC9_CD                        _MCCC9.MergedBits.grpCD
#define MCCC9_MCAM                      _MCCC9.MergedBits.grpMCAM
#define MCCC9_MCOM                      _MCCC9.MergedBits.grpMCOM

#define MCCC9_CD0_MASK                  1U
#define MCCC9_CD1_MASK                  2U
#define MCCC9_MCAM0_MASK                16U
#define MCCC9_MCAM1_MASK                32U
#define MCCC9_MCOM0_MASK                64U
#define MCCC9_MCOM1_MASK                128U
#define MCCC9_CD_MASK                   3U
#define MCCC9_CD_BITNUM                 0U
#define MCCC9_MCAM_MASK                 48U
#define MCCC9_MCAM_BITNUM               4U
#define MCCC9_MCOM_MASK                 192U
#define MCCC9_MCOM_BITNUM               6U


/*** MCCC10 - Motor Controller Control Register 10; 0x000001DA ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC10STR;
extern volatile MCCC10STR _MCCC10 @(REG_BASE + 0x000001DAUL);
#define MCCC10                          _MCCC10.Byte
#define MCCC10_CD0                      _MCCC10.Bits.CD0
#define MCCC10_CD1                      _MCCC10.Bits.CD1
#define MCCC10_MCAM0                    _MCCC10.Bits.MCAM0
#define MCCC10_MCAM1                    _MCCC10.Bits.MCAM1
#define MCCC10_MCOM0                    _MCCC10.Bits.MCOM0
#define MCCC10_MCOM1                    _MCCC10.Bits.MCOM1
#define MCCC10_CD                       _MCCC10.MergedBits.grpCD
#define MCCC10_MCAM                     _MCCC10.MergedBits.grpMCAM
#define MCCC10_MCOM                     _MCCC10.MergedBits.grpMCOM

#define MCCC10_CD0_MASK                 1U
#define MCCC10_CD1_MASK                 2U
#define MCCC10_MCAM0_MASK               16U
#define MCCC10_MCAM1_MASK               32U
#define MCCC10_MCOM0_MASK               64U
#define MCCC10_MCOM1_MASK               128U
#define MCCC10_CD_MASK                  3U
#define MCCC10_CD_BITNUM                0U
#define MCCC10_MCAM_MASK                48U
#define MCCC10_MCAM_BITNUM              4U
#define MCCC10_MCOM_MASK                192U
#define MCCC10_MCOM_BITNUM              6U


/*** MCCC11 - Motor Controller Control Register 11; 0x000001DB ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC11STR;
extern volatile MCCC11STR _MCCC11 @(REG_BASE + 0x000001DBUL);
#define MCCC11                          _MCCC11.Byte
#define MCCC11_CD0                      _MCCC11.Bits.CD0
#define MCCC11_CD1                      _MCCC11.Bits.CD1
#define MCCC11_MCAM0                    _MCCC11.Bits.MCAM0
#define MCCC11_MCAM1                    _MCCC11.Bits.MCAM1
#define MCCC11_MCOM0                    _MCCC11.Bits.MCOM0
#define MCCC11_MCOM1                    _MCCC11.Bits.MCOM1
#define MCCC11_CD                       _MCCC11.MergedBits.grpCD
#define MCCC11_MCAM                     _MCCC11.MergedBits.grpMCAM
#define MCCC11_MCOM                     _MCCC11.MergedBits.grpMCOM

#define MCCC11_CD0_MASK                 1U
#define MCCC11_CD1_MASK                 2U
#define MCCC11_MCAM0_MASK               16U
#define MCCC11_MCAM1_MASK               32U
#define MCCC11_MCOM0_MASK               64U
#define MCCC11_MCOM1_MASK               128U
#define MCCC11_CD_MASK                  3U
#define MCCC11_CD_BITNUM                0U
#define MCCC11_MCAM_MASK                48U
#define MCCC11_MCAM_BITNUM              4U
#define MCCC11_MCOM_MASK                192U
#define MCCC11_MCOM_BITNUM              6U


/*** MCDC0 - Motor Controller Period Register 0; 0x000001E0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC0_FASTSTR;
    #define MCDC0_FAST                  _MCDC0.Overlap_STR.MCDC0_FASTSTR.Byte
    #define MCDC0_FAST_D2               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D2
    #define MCDC0_FAST_D3               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D3
    #define MCDC0_FAST_D4               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D4
    #define MCDC0_FAST_D5               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D5
    #define MCDC0_FAST_D6               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D6
    #define MCDC0_FAST_D7               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D7
    #define MCDC0_FAST_D8               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D8
    #define MCDC0_FAST_S                _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.S
    #define MCDC0_FAST_D_2              _MCDC0.Overlap_STR.MCDC0_FASTSTR.MergedBits.grpD_2
    #define MCDC0_FAST_D                MCDC0_FAST_D_2
    
    #define MCDC0_FAST_D2_MASK          1U
    #define MCDC0_FAST_D3_MASK          2U
    #define MCDC0_FAST_D4_MASK          4U
    #define MCDC0_FAST_D5_MASK          8U
    #define MCDC0_FAST_D6_MASK          16U
    #define MCDC0_FAST_D7_MASK          32U
    #define MCDC0_FAST_D8_MASK          64U
    #define MCDC0_FAST_S_MASK           128U
    #define MCDC0_FAST_D_2_MASK         127U
    #define MCDC0_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC0STR;
extern volatile MCDC0STR _MCDC0 @(REG_BASE + 0x000001E0UL);
#define MCDC0                           _MCDC0.Word
#define MCDC0_D0                        _MCDC0.Bits.D0
#define MCDC0_D1                        _MCDC0.Bits.D1
#define MCDC0_D2                        _MCDC0.Bits.D2
#define MCDC0_D3                        _MCDC0.Bits.D3
#define MCDC0_D4                        _MCDC0.Bits.D4
#define MCDC0_D5                        _MCDC0.Bits.D5
#define MCDC0_D6                        _MCDC0.Bits.D6
#define MCDC0_D7                        _MCDC0.Bits.D7
#define MCDC0_D8                        _MCDC0.Bits.D8
#define MCDC0_D9                        _MCDC0.Bits.D9
#define MCDC0_D10                       _MCDC0.Bits.D10
#define MCDC0_S                         _MCDC0.Bits.S
/* MCDC_ARR: Access 12 MCDCx registers in an array */
#define MCDC_ARR                        ((volatile word *) &MCDC0)
#define MCDC0_D                         _MCDC0.MergedBits.grpD

#define MCDC0_D0_MASK                   1U
#define MCDC0_D1_MASK                   2U
#define MCDC0_D2_MASK                   4U
#define MCDC0_D3_MASK                   8U
#define MCDC0_D4_MASK                   16U
#define MCDC0_D5_MASK                   32U
#define MCDC0_D6_MASK                   64U
#define MCDC0_D7_MASK                   128U
#define MCDC0_D8_MASK                   256U
#define MCDC0_D9_MASK                   512U
#define MCDC0_D10_MASK                  1024U
#define MCDC0_S_MASK                    32768U
#define MCDC0_D_MASK                    2047U
#define MCDC0_D_BITNUM                  0U


/*** MCDC1 - Motor Controller Period Register 1; 0x000001E2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC1_FASTSTR;
    #define MCDC1_FAST                  _MCDC1.Overlap_STR.MCDC1_FASTSTR.Byte
    #define MCDC1_FAST_D2               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D2
    #define MCDC1_FAST_D3               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D3
    #define MCDC1_FAST_D4               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D4
    #define MCDC1_FAST_D5               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D5
    #define MCDC1_FAST_D6               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D6
    #define MCDC1_FAST_D7               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D7
    #define MCDC1_FAST_D8               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D8
    #define MCDC1_FAST_S                _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.S
    #define MCDC1_FAST_D_2              _MCDC1.Overlap_STR.MCDC1_FASTSTR.MergedBits.grpD_2
    #define MCDC1_FAST_D                MCDC1_FAST_D_2
    
    #define MCDC1_FAST_D2_MASK          1U
    #define MCDC1_FAST_D3_MASK          2U
    #define MCDC1_FAST_D4_MASK          4U
    #define MCDC1_FAST_D5_MASK          8U
    #define MCDC1_FAST_D6_MASK          16U
    #define MCDC1_FAST_D7_MASK          32U
    #define MCDC1_FAST_D8_MASK          64U
    #define MCDC1_FAST_S_MASK           128U
    #define MCDC1_FAST_D_2_MASK         127U
    #define MCDC1_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC1STR;
extern volatile MCDC1STR _MCDC1 @(REG_BASE + 0x000001E2UL);
#define MCDC1                           _MCDC1.Word
#define MCDC1_D0                        _MCDC1.Bits.D0
#define MCDC1_D1                        _MCDC1.Bits.D1
#define MCDC1_D2                        _MCDC1.Bits.D2
#define MCDC1_D3                        _MCDC1.Bits.D3
#define MCDC1_D4                        _MCDC1.Bits.D4
#define MCDC1_D5                        _MCDC1.Bits.D5
#define MCDC1_D6                        _MCDC1.Bits.D6
#define MCDC1_D7                        _MCDC1.Bits.D7
#define MCDC1_D8                        _MCDC1.Bits.D8
#define MCDC1_D9                        _MCDC1.Bits.D9
#define MCDC1_D10                       _MCDC1.Bits.D10
#define MCDC1_S                         _MCDC1.Bits.S
#define MCDC1_D                         _MCDC1.MergedBits.grpD

#define MCDC1_D0_MASK                   1U
#define MCDC1_D1_MASK                   2U
#define MCDC1_D2_MASK                   4U
#define MCDC1_D3_MASK                   8U
#define MCDC1_D4_MASK                   16U
#define MCDC1_D5_MASK                   32U
#define MCDC1_D6_MASK                   64U
#define MCDC1_D7_MASK                   128U
#define MCDC1_D8_MASK                   256U
#define MCDC1_D9_MASK                   512U
#define MCDC1_D10_MASK                  1024U
#define MCDC1_S_MASK                    32768U
#define MCDC1_D_MASK                    2047U
#define MCDC1_D_BITNUM                  0U


/*** MCDC2 - Motor Controller Period Register 2; 0x000001E4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC2_FASTSTR;
    #define MCDC2_FAST                  _MCDC2.Overlap_STR.MCDC2_FASTSTR.Byte
    #define MCDC2_FAST_D2               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D2
    #define MCDC2_FAST_D3               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D3
    #define MCDC2_FAST_D4               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D4
    #define MCDC2_FAST_D5               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D5
    #define MCDC2_FAST_D6               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D6
    #define MCDC2_FAST_D7               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D7
    #define MCDC2_FAST_D8               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D8
    #define MCDC2_FAST_S                _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.S
    #define MCDC2_FAST_D_2              _MCDC2.Overlap_STR.MCDC2_FASTSTR.MergedBits.grpD_2
    #define MCDC2_FAST_D                MCDC2_FAST_D_2
    
    #define MCDC2_FAST_D2_MASK          1U
    #define MCDC2_FAST_D3_MASK          2U
    #define MCDC2_FAST_D4_MASK          4U
    #define MCDC2_FAST_D5_MASK          8U
    #define MCDC2_FAST_D6_MASK          16U
    #define MCDC2_FAST_D7_MASK          32U
    #define MCDC2_FAST_D8_MASK          64U
    #define MCDC2_FAST_S_MASK           128U
    #define MCDC2_FAST_D_2_MASK         127U
    #define MCDC2_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC2STR;
extern volatile MCDC2STR _MCDC2 @(REG_BASE + 0x000001E4UL);
#define MCDC2                           _MCDC2.Word
#define MCDC2_D0                        _MCDC2.Bits.D0
#define MCDC2_D1                        _MCDC2.Bits.D1
#define MCDC2_D2                        _MCDC2.Bits.D2
#define MCDC2_D3                        _MCDC2.Bits.D3
#define MCDC2_D4                        _MCDC2.Bits.D4
#define MCDC2_D5                        _MCDC2.Bits.D5
#define MCDC2_D6                        _MCDC2.Bits.D6
#define MCDC2_D7                        _MCDC2.Bits.D7
#define MCDC2_D8                        _MCDC2.Bits.D8
#define MCDC2_D9                        _MCDC2.Bits.D9
#define MCDC2_D10                       _MCDC2.Bits.D10
#define MCDC2_S                         _MCDC2.Bits.S
#define MCDC2_D                         _MCDC2.MergedBits.grpD

#define MCDC2_D0_MASK                   1U
#define MCDC2_D1_MASK                   2U
#define MCDC2_D2_MASK                   4U
#define MCDC2_D3_MASK                   8U
#define MCDC2_D4_MASK                   16U
#define MCDC2_D5_MASK                   32U
#define MCDC2_D6_MASK                   64U
#define MCDC2_D7_MASK                   128U
#define MCDC2_D8_MASK                   256U
#define MCDC2_D9_MASK                   512U
#define MCDC2_D10_MASK                  1024U
#define MCDC2_S_MASK                    32768U
#define MCDC2_D_MASK                    2047U
#define MCDC2_D_BITNUM                  0U


/*** MCDC3 - Motor Controller Period Register 3; 0x000001E6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC3_FASTSTR;
    #define MCDC3_FAST                  _MCDC3.Overlap_STR.MCDC3_FASTSTR.Byte
    #define MCDC3_FAST_D2               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D2
    #define MCDC3_FAST_D3               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D3
    #define MCDC3_FAST_D4               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D4
    #define MCDC3_FAST_D5               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D5
    #define MCDC3_FAST_D6               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D6
    #define MCDC3_FAST_D7               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D7
    #define MCDC3_FAST_D8               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D8
    #define MCDC3_FAST_S                _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.S
    #define MCDC3_FAST_D_2              _MCDC3.Overlap_STR.MCDC3_FASTSTR.MergedBits.grpD_2
    #define MCDC3_FAST_D                MCDC3_FAST_D_2
    
    #define MCDC3_FAST_D2_MASK          1U
    #define MCDC3_FAST_D3_MASK          2U
    #define MCDC3_FAST_D4_MASK          4U
    #define MCDC3_FAST_D5_MASK          8U
    #define MCDC3_FAST_D6_MASK          16U
    #define MCDC3_FAST_D7_MASK          32U
    #define MCDC3_FAST_D8_MASK          64U
    #define MCDC3_FAST_S_MASK           128U
    #define MCDC3_FAST_D_2_MASK         127U
    #define MCDC3_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC3STR;
extern volatile MCDC3STR _MCDC3 @(REG_BASE + 0x000001E6UL);
#define MCDC3                           _MCDC3.Word
#define MCDC3_D0                        _MCDC3.Bits.D0
#define MCDC3_D1                        _MCDC3.Bits.D1
#define MCDC3_D2                        _MCDC3.Bits.D2
#define MCDC3_D3                        _MCDC3.Bits.D3
#define MCDC3_D4                        _MCDC3.Bits.D4
#define MCDC3_D5                        _MCDC3.Bits.D5
#define MCDC3_D6                        _MCDC3.Bits.D6
#define MCDC3_D7                        _MCDC3.Bits.D7
#define MCDC3_D8                        _MCDC3.Bits.D8
#define MCDC3_D9                        _MCDC3.Bits.D9
#define MCDC3_D10                       _MCDC3.Bits.D10
#define MCDC3_S                         _MCDC3.Bits.S
#define MCDC3_D                         _MCDC3.MergedBits.grpD

#define MCDC3_D0_MASK                   1U
#define MCDC3_D1_MASK                   2U
#define MCDC3_D2_MASK                   4U
#define MCDC3_D3_MASK                   8U
#define MCDC3_D4_MASK                   16U
#define MCDC3_D5_MASK                   32U
#define MCDC3_D6_MASK                   64U
#define MCDC3_D7_MASK                   128U
#define MCDC3_D8_MASK                   256U
#define MCDC3_D9_MASK                   512U
#define MCDC3_D10_MASK                  1024U
#define MCDC3_S_MASK                    32768U
#define MCDC3_D_MASK                    2047U
#define MCDC3_D_BITNUM                  0U


/*** MCDC4 - Motor Controller Period Register 4; 0x000001E8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC4_FASTSTR;
    #define MCDC4_FAST                  _MCDC4.Overlap_STR.MCDC4_FASTSTR.Byte
    #define MCDC4_FAST_D2               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D2
    #define MCDC4_FAST_D3               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D3
    #define MCDC4_FAST_D4               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D4
    #define MCDC4_FAST_D5               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D5
    #define MCDC4_FAST_D6               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D6
    #define MCDC4_FAST_D7               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D7
    #define MCDC4_FAST_D8               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D8
    #define MCDC4_FAST_S                _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.S
    #define MCDC4_FAST_D_2              _MCDC4.Overlap_STR.MCDC4_FASTSTR.MergedBits.grpD_2
    #define MCDC4_FAST_D                MCDC4_FAST_D_2
    
    #define MCDC4_FAST_D2_MASK          1U
    #define MCDC4_FAST_D3_MASK          2U
    #define MCDC4_FAST_D4_MASK          4U
    #define MCDC4_FAST_D5_MASK          8U
    #define MCDC4_FAST_D6_MASK          16U
    #define MCDC4_FAST_D7_MASK          32U
    #define MCDC4_FAST_D8_MASK          64U
    #define MCDC4_FAST_S_MASK           128U
    #define MCDC4_FAST_D_2_MASK         127U
    #define MCDC4_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC4STR;
extern volatile MCDC4STR _MCDC4 @(REG_BASE + 0x000001E8UL);
#define MCDC4                           _MCDC4.Word
#define MCDC4_D0                        _MCDC4.Bits.D0
#define MCDC4_D1                        _MCDC4.Bits.D1
#define MCDC4_D2                        _MCDC4.Bits.D2
#define MCDC4_D3                        _MCDC4.Bits.D3
#define MCDC4_D4                        _MCDC4.Bits.D4
#define MCDC4_D5                        _MCDC4.Bits.D5
#define MCDC4_D6                        _MCDC4.Bits.D6
#define MCDC4_D7                        _MCDC4.Bits.D7
#define MCDC4_D8                        _MCDC4.Bits.D8
#define MCDC4_D9                        _MCDC4.Bits.D9
#define MCDC4_D10                       _MCDC4.Bits.D10
#define MCDC4_S                         _MCDC4.Bits.S
#define MCDC4_D                         _MCDC4.MergedBits.grpD

#define MCDC4_D0_MASK                   1U
#define MCDC4_D1_MASK                   2U
#define MCDC4_D2_MASK                   4U
#define MCDC4_D3_MASK                   8U
#define MCDC4_D4_MASK                   16U
#define MCDC4_D5_MASK                   32U
#define MCDC4_D6_MASK                   64U
#define MCDC4_D7_MASK                   128U
#define MCDC4_D8_MASK                   256U
#define MCDC4_D9_MASK                   512U
#define MCDC4_D10_MASK                  1024U
#define MCDC4_S_MASK                    32768U
#define MCDC4_D_MASK                    2047U
#define MCDC4_D_BITNUM                  0U


/*** MCDC5 - Motor Controller Period Register 5; 0x000001EA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC5_FASTSTR;
    #define MCDC5_FAST                  _MCDC5.Overlap_STR.MCDC5_FASTSTR.Byte
    #define MCDC5_FAST_D2               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D2
    #define MCDC5_FAST_D3               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D3
    #define MCDC5_FAST_D4               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D4
    #define MCDC5_FAST_D5               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D5
    #define MCDC5_FAST_D6               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D6
    #define MCDC5_FAST_D7               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D7
    #define MCDC5_FAST_D8               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D8
    #define MCDC5_FAST_S                _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.S
    #define MCDC5_FAST_D_2              _MCDC5.Overlap_STR.MCDC5_FASTSTR.MergedBits.grpD_2
    #define MCDC5_FAST_D                MCDC5_FAST_D_2
    
    #define MCDC5_FAST_D2_MASK          1U
    #define MCDC5_FAST_D3_MASK          2U
    #define MCDC5_FAST_D4_MASK          4U
    #define MCDC5_FAST_D5_MASK          8U
    #define MCDC5_FAST_D6_MASK          16U
    #define MCDC5_FAST_D7_MASK          32U
    #define MCDC5_FAST_D8_MASK          64U
    #define MCDC5_FAST_S_MASK           128U
    #define MCDC5_FAST_D_2_MASK         127U
    #define MCDC5_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC5STR;
extern volatile MCDC5STR _MCDC5 @(REG_BASE + 0x000001EAUL);
#define MCDC5                           _MCDC5.Word
#define MCDC5_D0                        _MCDC5.Bits.D0
#define MCDC5_D1                        _MCDC5.Bits.D1
#define MCDC5_D2                        _MCDC5.Bits.D2
#define MCDC5_D3                        _MCDC5.Bits.D3
#define MCDC5_D4                        _MCDC5.Bits.D4
#define MCDC5_D5                        _MCDC5.Bits.D5
#define MCDC5_D6                        _MCDC5.Bits.D6
#define MCDC5_D7                        _MCDC5.Bits.D7
#define MCDC5_D8                        _MCDC5.Bits.D8
#define MCDC5_D9                        _MCDC5.Bits.D9
#define MCDC5_D10                       _MCDC5.Bits.D10
#define MCDC5_S                         _MCDC5.Bits.S
#define MCDC5_D                         _MCDC5.MergedBits.grpD

#define MCDC5_D0_MASK                   1U
#define MCDC5_D1_MASK                   2U
#define MCDC5_D2_MASK                   4U
#define MCDC5_D3_MASK                   8U
#define MCDC5_D4_MASK                   16U
#define MCDC5_D5_MASK                   32U
#define MCDC5_D6_MASK                   64U
#define MCDC5_D7_MASK                   128U
#define MCDC5_D8_MASK                   256U
#define MCDC5_D9_MASK                   512U
#define MCDC5_D10_MASK                  1024U
#define MCDC5_S_MASK                    32768U
#define MCDC5_D_MASK                    2047U
#define MCDC5_D_BITNUM                  0U


/*** MCDC6 - Motor Controller Period Register 6; 0x000001EC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC6_FASTSTR;
    #define MCDC6_FAST                  _MCDC6.Overlap_STR.MCDC6_FASTSTR.Byte
    #define MCDC6_FAST_D2               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D2
    #define MCDC6_FAST_D3               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D3
    #define MCDC6_FAST_D4               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D4
    #define MCDC6_FAST_D5               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D5
    #define MCDC6_FAST_D6               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D6
    #define MCDC6_FAST_D7               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D7
    #define MCDC6_FAST_D8               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D8
    #define MCDC6_FAST_S                _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.S
    #define MCDC6_FAST_D_2              _MCDC6.Overlap_STR.MCDC6_FASTSTR.MergedBits.grpD_2
    #define MCDC6_FAST_D                MCDC6_FAST_D_2
    
    #define MCDC6_FAST_D2_MASK          1U
    #define MCDC6_FAST_D3_MASK          2U
    #define MCDC6_FAST_D4_MASK          4U
    #define MCDC6_FAST_D5_MASK          8U
    #define MCDC6_FAST_D6_MASK          16U
    #define MCDC6_FAST_D7_MASK          32U
    #define MCDC6_FAST_D8_MASK          64U
    #define MCDC6_FAST_S_MASK           128U
    #define MCDC6_FAST_D_2_MASK         127U
    #define MCDC6_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC6STR;
extern volatile MCDC6STR _MCDC6 @(REG_BASE + 0x000001ECUL);
#define MCDC6                           _MCDC6.Word
#define MCDC6_D0                        _MCDC6.Bits.D0
#define MCDC6_D1                        _MCDC6.Bits.D1
#define MCDC6_D2                        _MCDC6.Bits.D2
#define MCDC6_D3                        _MCDC6.Bits.D3
#define MCDC6_D4                        _MCDC6.Bits.D4
#define MCDC6_D5                        _MCDC6.Bits.D5
#define MCDC6_D6                        _MCDC6.Bits.D6
#define MCDC6_D7                        _MCDC6.Bits.D7
#define MCDC6_D8                        _MCDC6.Bits.D8
#define MCDC6_D9                        _MCDC6.Bits.D9
#define MCDC6_D10                       _MCDC6.Bits.D10
#define MCDC6_S                         _MCDC6.Bits.S
#define MCDC6_D                         _MCDC6.MergedBits.grpD

#define MCDC6_D0_MASK                   1U
#define MCDC6_D1_MASK                   2U
#define MCDC6_D2_MASK                   4U
#define MCDC6_D3_MASK                   8U
#define MCDC6_D4_MASK                   16U
#define MCDC6_D5_MASK                   32U
#define MCDC6_D6_MASK                   64U
#define MCDC6_D7_MASK                   128U
#define MCDC6_D8_MASK                   256U
#define MCDC6_D9_MASK                   512U
#define MCDC6_D10_MASK                  1024U
#define MCDC6_S_MASK                    32768U
#define MCDC6_D_MASK                    2047U
#define MCDC6_D_BITNUM                  0U


/*** MCDC7 - Motor Controller Period Register 7; 0x000001EE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC7_FASTSTR;
    #define MCDC7_FAST                  _MCDC7.Overlap_STR.MCDC7_FASTSTR.Byte
    #define MCDC7_FAST_D2               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D2
    #define MCDC7_FAST_D3               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D3
    #define MCDC7_FAST_D4               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D4
    #define MCDC7_FAST_D5               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D5
    #define MCDC7_FAST_D6               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D6
    #define MCDC7_FAST_D7               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D7
    #define MCDC7_FAST_D8               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D8
    #define MCDC7_FAST_S                _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.S
    #define MCDC7_FAST_D_2              _MCDC7.Overlap_STR.MCDC7_FASTSTR.MergedBits.grpD_2
    #define MCDC7_FAST_D                MCDC7_FAST_D_2
    
    #define MCDC7_FAST_D2_MASK          1U
    #define MCDC7_FAST_D3_MASK          2U
    #define MCDC7_FAST_D4_MASK          4U
    #define MCDC7_FAST_D5_MASK          8U
    #define MCDC7_FAST_D6_MASK          16U
    #define MCDC7_FAST_D7_MASK          32U
    #define MCDC7_FAST_D8_MASK          64U
    #define MCDC7_FAST_S_MASK           128U
    #define MCDC7_FAST_D_2_MASK         127U
    #define MCDC7_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC7STR;
extern volatile MCDC7STR _MCDC7 @(REG_BASE + 0x000001EEUL);
#define MCDC7                           _MCDC7.Word
#define MCDC7_D0                        _MCDC7.Bits.D0
#define MCDC7_D1                        _MCDC7.Bits.D1
#define MCDC7_D2                        _MCDC7.Bits.D2
#define MCDC7_D3                        _MCDC7.Bits.D3
#define MCDC7_D4                        _MCDC7.Bits.D4
#define MCDC7_D5                        _MCDC7.Bits.D5
#define MCDC7_D6                        _MCDC7.Bits.D6
#define MCDC7_D7                        _MCDC7.Bits.D7
#define MCDC7_D8                        _MCDC7.Bits.D8
#define MCDC7_D9                        _MCDC7.Bits.D9
#define MCDC7_D10                       _MCDC7.Bits.D10
#define MCDC7_S                         _MCDC7.Bits.S
#define MCDC7_D                         _MCDC7.MergedBits.grpD

#define MCDC7_D0_MASK                   1U
#define MCDC7_D1_MASK                   2U
#define MCDC7_D2_MASK                   4U
#define MCDC7_D3_MASK                   8U
#define MCDC7_D4_MASK                   16U
#define MCDC7_D5_MASK                   32U
#define MCDC7_D6_MASK                   64U
#define MCDC7_D7_MASK                   128U
#define MCDC7_D8_MASK                   256U
#define MCDC7_D9_MASK                   512U
#define MCDC7_D10_MASK                  1024U
#define MCDC7_S_MASK                    32768U
#define MCDC7_D_MASK                    2047U
#define MCDC7_D_BITNUM                  0U


/*** MCDC8 - Motor Controller Period Register 8; 0x000001F0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC8_FAST - Motor Controller Period Register 8 access with FAST bit = 1; 0x000001F0 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC8_FASTSTR;
    #define MCDC8_FAST                  _MCDC8.Overlap_STR.MCDC8_FASTSTR.Byte
    #define MCDC8_FAST_D2               _MCDC8.Overlap_STR.MCDC8_FASTSTR.Bits.D2
    #define MCDC8_FAST_D3               _MCDC8.Overlap_STR.MCDC8_FASTSTR.Bits.D3
    #define MCDC8_FAST_D4               _MCDC8.Overlap_STR.MCDC8_FASTSTR.Bits.D4
    #define MCDC8_FAST_D5               _MCDC8.Overlap_STR.MCDC8_FASTSTR.Bits.D5
    #define MCDC8_FAST_D6               _MCDC8.Overlap_STR.MCDC8_FASTSTR.Bits.D6
    #define MCDC8_FAST_D7               _MCDC8.Overlap_STR.MCDC8_FASTSTR.Bits.D7
    #define MCDC8_FAST_D8               _MCDC8.Overlap_STR.MCDC8_FASTSTR.Bits.D8
    #define MCDC8_FAST_S                _MCDC8.Overlap_STR.MCDC8_FASTSTR.Bits.S
    #define MCDC8_FAST_D_2              _MCDC8.Overlap_STR.MCDC8_FASTSTR.MergedBits.grpD_2
    #define MCDC8_FAST_D                MCDC8_FAST_D_2
    
    #define MCDC8_FAST_D2_MASK          1U
    #define MCDC8_FAST_D3_MASK          2U
    #define MCDC8_FAST_D4_MASK          4U
    #define MCDC8_FAST_D5_MASK          8U
    #define MCDC8_FAST_D6_MASK          16U
    #define MCDC8_FAST_D7_MASK          32U
    #define MCDC8_FAST_D8_MASK          64U
    #define MCDC8_FAST_S_MASK           128U
    #define MCDC8_FAST_D_2_MASK         127U
    #define MCDC8_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC8STR;
extern volatile MCDC8STR _MCDC8 @(REG_BASE + 0x000001F0UL);
#define MCDC8                           _MCDC8.Word
#define MCDC8_D0                        _MCDC8.Bits.D0
#define MCDC8_D1                        _MCDC8.Bits.D1
#define MCDC8_D2                        _MCDC8.Bits.D2
#define MCDC8_D3                        _MCDC8.Bits.D3
#define MCDC8_D4                        _MCDC8.Bits.D4
#define MCDC8_D5                        _MCDC8.Bits.D5
#define MCDC8_D6                        _MCDC8.Bits.D6
#define MCDC8_D7                        _MCDC8.Bits.D7
#define MCDC8_D8                        _MCDC8.Bits.D8
#define MCDC8_D9                        _MCDC8.Bits.D9
#define MCDC8_D10                       _MCDC8.Bits.D10
#define MCDC8_S                         _MCDC8.Bits.S
#define MCDC8_D                         _MCDC8.MergedBits.grpD

#define MCDC8_D0_MASK                   1U
#define MCDC8_D1_MASK                   2U
#define MCDC8_D2_MASK                   4U
#define MCDC8_D3_MASK                   8U
#define MCDC8_D4_MASK                   16U
#define MCDC8_D5_MASK                   32U
#define MCDC8_D6_MASK                   64U
#define MCDC8_D7_MASK                   128U
#define MCDC8_D8_MASK                   256U
#define MCDC8_D9_MASK                   512U
#define MCDC8_D10_MASK                  1024U
#define MCDC8_S_MASK                    32768U
#define MCDC8_D_MASK                    2047U
#define MCDC8_D_BITNUM                  0U


/*** MCDC9 - Motor Controller Period Register 9; 0x000001F2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC9_FAST - Motor Controller Period Register 9 access with FAST bit = 1; 0x000001F2 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC9_FASTSTR;
    #define MCDC9_FAST                  _MCDC9.Overlap_STR.MCDC9_FASTSTR.Byte
    #define MCDC9_FAST_D2               _MCDC9.Overlap_STR.MCDC9_FASTSTR.Bits.D2
    #define MCDC9_FAST_D3               _MCDC9.Overlap_STR.MCDC9_FASTSTR.Bits.D3
    #define MCDC9_FAST_D4               _MCDC9.Overlap_STR.MCDC9_FASTSTR.Bits.D4
    #define MCDC9_FAST_D5               _MCDC9.Overlap_STR.MCDC9_FASTSTR.Bits.D5
    #define MCDC9_FAST_D6               _MCDC9.Overlap_STR.MCDC9_FASTSTR.Bits.D6
    #define MCDC9_FAST_D7               _MCDC9.Overlap_STR.MCDC9_FASTSTR.Bits.D7
    #define MCDC9_FAST_D8               _MCDC9.Overlap_STR.MCDC9_FASTSTR.Bits.D8
    #define MCDC9_FAST_S                _MCDC9.Overlap_STR.MCDC9_FASTSTR.Bits.S
    #define MCDC9_FAST_D_2              _MCDC9.Overlap_STR.MCDC9_FASTSTR.MergedBits.grpD_2
    #define MCDC9_FAST_D                MCDC9_FAST_D_2
    
    #define MCDC9_FAST_D2_MASK          1U
    #define MCDC9_FAST_D3_MASK          2U
    #define MCDC9_FAST_D4_MASK          4U
    #define MCDC9_FAST_D5_MASK          8U
    #define MCDC9_FAST_D6_MASK          16U
    #define MCDC9_FAST_D7_MASK          32U
    #define MCDC9_FAST_D8_MASK          64U
    #define MCDC9_FAST_S_MASK           128U
    #define MCDC9_FAST_D_2_MASK         127U
    #define MCDC9_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC9STR;
extern volatile MCDC9STR _MCDC9 @(REG_BASE + 0x000001F2UL);
#define MCDC9                           _MCDC9.Word
#define MCDC9_D0                        _MCDC9.Bits.D0
#define MCDC9_D1                        _MCDC9.Bits.D1
#define MCDC9_D2                        _MCDC9.Bits.D2
#define MCDC9_D3                        _MCDC9.Bits.D3
#define MCDC9_D4                        _MCDC9.Bits.D4
#define MCDC9_D5                        _MCDC9.Bits.D5
#define MCDC9_D6                        _MCDC9.Bits.D6
#define MCDC9_D7                        _MCDC9.Bits.D7
#define MCDC9_D8                        _MCDC9.Bits.D8
#define MCDC9_D9                        _MCDC9.Bits.D9
#define MCDC9_D10                       _MCDC9.Bits.D10
#define MCDC9_S                         _MCDC9.Bits.S
#define MCDC9_D                         _MCDC9.MergedBits.grpD

#define MCDC9_D0_MASK                   1U
#define MCDC9_D1_MASK                   2U
#define MCDC9_D2_MASK                   4U
#define MCDC9_D3_MASK                   8U
#define MCDC9_D4_MASK                   16U
#define MCDC9_D5_MASK                   32U
#define MCDC9_D6_MASK                   64U
#define MCDC9_D7_MASK                   128U
#define MCDC9_D8_MASK                   256U
#define MCDC9_D9_MASK                   512U
#define MCDC9_D10_MASK                  1024U
#define MCDC9_S_MASK                    32768U
#define MCDC9_D_MASK                    2047U
#define MCDC9_D_BITNUM                  0U


/*** MCDC10 - Motor Controller Period Register 10; 0x000001F4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC10_FAST - Motor Controller Period Register 10 access with FAST bit = 1; 0x000001F4 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC10_FASTSTR;
    #define MCDC10_FAST                 _MCDC10.Overlap_STR.MCDC10_FASTSTR.Byte
    #define MCDC10_FAST_D2              _MCDC10.Overlap_STR.MCDC10_FASTSTR.Bits.D2
    #define MCDC10_FAST_D3              _MCDC10.Overlap_STR.MCDC10_FASTSTR.Bits.D3
    #define MCDC10_FAST_D4              _MCDC10.Overlap_STR.MCDC10_FASTSTR.Bits.D4
    #define MCDC10_FAST_D5              _MCDC10.Overlap_STR.MCDC10_FASTSTR.Bits.D5
    #define MCDC10_FAST_D6              _MCDC10.Overlap_STR.MCDC10_FASTSTR.Bits.D6
    #define MCDC10_FAST_D7              _MCDC10.Overlap_STR.MCDC10_FASTSTR.Bits.D7
    #define MCDC10_FAST_D8              _MCDC10.Overlap_STR.MCDC10_FASTSTR.Bits.D8
    #define MCDC10_FAST_S               _MCDC10.Overlap_STR.MCDC10_FASTSTR.Bits.S
    #define MCDC10_FAST_D_2             _MCDC10.Overlap_STR.MCDC10_FASTSTR.MergedBits.grpD_2
    #define MCDC10_FAST_D               MCDC10_FAST_D_2
    
    #define MCDC10_FAST_D2_MASK         1U
    #define MCDC10_FAST_D3_MASK         2U
    #define MCDC10_FAST_D4_MASK         4U
    #define MCDC10_FAST_D5_MASK         8U
    #define MCDC10_FAST_D6_MASK         16U
    #define MCDC10_FAST_D7_MASK         32U
    #define MCDC10_FAST_D8_MASK         64U
    #define MCDC10_FAST_S_MASK          128U
    #define MCDC10_FAST_D_2_MASK        127U
    #define MCDC10_FAST_D_2_BITNUM      0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC10STR;
extern volatile MCDC10STR _MCDC10 @(REG_BASE + 0x000001F4UL);
#define MCDC10                          _MCDC10.Word
#define MCDC10_D0                       _MCDC10.Bits.D0
#define MCDC10_D1                       _MCDC10.Bits.D1
#define MCDC10_D2                       _MCDC10.Bits.D2
#define MCDC10_D3                       _MCDC10.Bits.D3
#define MCDC10_D4                       _MCDC10.Bits.D4
#define MCDC10_D5                       _MCDC10.Bits.D5
#define MCDC10_D6                       _MCDC10.Bits.D6
#define MCDC10_D7                       _MCDC10.Bits.D7
#define MCDC10_D8                       _MCDC10.Bits.D8
#define MCDC10_D9                       _MCDC10.Bits.D9
#define MCDC10_D10                      _MCDC10.Bits.D10
#define MCDC10_S                        _MCDC10.Bits.S
#define MCDC10_D                        _MCDC10.MergedBits.grpD

#define MCDC10_D0_MASK                  1U
#define MCDC10_D1_MASK                  2U
#define MCDC10_D2_MASK                  4U
#define MCDC10_D3_MASK                  8U
#define MCDC10_D4_MASK                  16U
#define MCDC10_D5_MASK                  32U
#define MCDC10_D6_MASK                  64U
#define MCDC10_D7_MASK                  128U
#define MCDC10_D8_MASK                  256U
#define MCDC10_D9_MASK                  512U
#define MCDC10_D10_MASK                 1024U
#define MCDC10_S_MASK                   32768U
#define MCDC10_D_MASK                   2047U
#define MCDC10_D_BITNUM                 0U


/*** MCDC11 - Motor Controller Period Register 11; 0x000001F6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC11_FAST - Motor Controller Period Register 11 access with FAST bit = 1; 0x000001F6 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC11_FASTSTR;
    #define MCDC11_FAST                 _MCDC11.Overlap_STR.MCDC11_FASTSTR.Byte
    #define MCDC11_FAST_D2              _MCDC11.Overlap_STR.MCDC11_FASTSTR.Bits.D2
    #define MCDC11_FAST_D3              _MCDC11.Overlap_STR.MCDC11_FASTSTR.Bits.D3
    #define MCDC11_FAST_D4              _MCDC11.Overlap_STR.MCDC11_FASTSTR.Bits.D4
    #define MCDC11_FAST_D5              _MCDC11.Overlap_STR.MCDC11_FASTSTR.Bits.D5
    #define MCDC11_FAST_D6              _MCDC11.Overlap_STR.MCDC11_FASTSTR.Bits.D6
    #define MCDC11_FAST_D7              _MCDC11.Overlap_STR.MCDC11_FASTSTR.Bits.D7
    #define MCDC11_FAST_D8              _MCDC11.Overlap_STR.MCDC11_FASTSTR.Bits.D8
    #define MCDC11_FAST_S               _MCDC11.Overlap_STR.MCDC11_FASTSTR.Bits.S
    #define MCDC11_FAST_D_2             _MCDC11.Overlap_STR.MCDC11_FASTSTR.MergedBits.grpD_2
    #define MCDC11_FAST_D               MCDC11_FAST_D_2
    
    #define MCDC11_FAST_D2_MASK         1U
    #define MCDC11_FAST_D3_MASK         2U
    #define MCDC11_FAST_D4_MASK         4U
    #define MCDC11_FAST_D5_MASK         8U
    #define MCDC11_FAST_D6_MASK         16U
    #define MCDC11_FAST_D7_MASK         32U
    #define MCDC11_FAST_D8_MASK         64U
    #define MCDC11_FAST_S_MASK          128U
    #define MCDC11_FAST_D_2_MASK        127U
    #define MCDC11_FAST_D_2_BITNUM      0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC11STR;
extern volatile MCDC11STR _MCDC11 @(REG_BASE + 0x000001F6UL);
#define MCDC11                          _MCDC11.Word
#define MCDC11_D0                       _MCDC11.Bits.D0
#define MCDC11_D1                       _MCDC11.Bits.D1
#define MCDC11_D2                       _MCDC11.Bits.D2
#define MCDC11_D3                       _MCDC11.Bits.D3
#define MCDC11_D4                       _MCDC11.Bits.D4
#define MCDC11_D5                       _MCDC11.Bits.D5
#define MCDC11_D6                       _MCDC11.Bits.D6
#define MCDC11_D7                       _MCDC11.Bits.D7
#define MCDC11_D8                       _MCDC11.Bits.D8
#define MCDC11_D9                       _MCDC11.Bits.D9
#define MCDC11_D10                      _MCDC11.Bits.D10
#define MCDC11_S                        _MCDC11.Bits.S
#define MCDC11_D                        _MCDC11.MergedBits.grpD

#define MCDC11_D0_MASK                  1U
#define MCDC11_D1_MASK                  2U
#define MCDC11_D2_MASK                  4U
#define MCDC11_D3_MASK                  8U
#define MCDC11_D4_MASK                  16U
#define MCDC11_D5_MASK                  32U
#define MCDC11_D6_MASK                  64U
#define MCDC11_D7_MASK                  128U
#define MCDC11_D8_MASK                  256U
#define MCDC11_D9_MASK                  512U
#define MCDC11_D10_MASK                 1024U
#define MCDC11_S_MASK                   32768U
#define MCDC11_D_MASK                   2047U
#define MCDC11_D_BITNUM                 0U


/*** PTT - Port T Data Register; 0x00000200 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T general purpose input/output data bit 0 */
    byte PTT1        :1;                                       /* Port T general purpose input/output data bit 1 */
    byte PTT2        :1;                                       /* Port T general purpose input/output data bit 2 */
    byte PTT3        :1;                                       /* Port T general purpose input/output data bit 3 */
    byte PTT4        :1;                                       /* Port T general purpose input/output data bit 4 */
    byte PTT5        :1;                                       /* Port T general purpose input/output data bit 5 */
    byte PTT6        :1;                                       /* Port T general purpose input/output data bit 6 */
    byte PTT7        :1;                                       /* Port T general purpose input/output data bit 7 */
  } Bits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000200UL);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT4                        _PTT.Bits.PTT4
#define PTT_PTT5                        _PTT.Bits.PTT5
#define PTT_PTT6                        _PTT.Bits.PTT6
#define PTT_PTT7                        _PTT.Bits.PTT7

#define PTT_PTT0_MASK                   1U
#define PTT_PTT1_MASK                   2U
#define PTT_PTT2_MASK                   4U
#define PTT_PTT3_MASK                   8U
#define PTT_PTT4_MASK                   16U
#define PTT_PTT5_MASK                   32U
#define PTT_PTT6_MASK                   64U
#define PTT_PTT7_MASK                   128U


/*** PTIT - Port T Input Register; 0x00000201 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T input data bit 0 */
    byte PTIT1       :1;                                       /* Port T input data bit 1 */
    byte PTIT2       :1;                                       /* Port T input data bit 2 */
    byte PTIT3       :1;                                       /* Port T input data bit 3 */
    byte PTIT4       :1;                                       /* Port T input data bit 4 */
    byte PTIT5       :1;                                       /* Port T input data bit 5 */
    byte PTIT6       :1;                                       /* Port T input data bit 6 */
    byte PTIT7       :1;                                       /* Port T input data bit 7 */
  } Bits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000201UL);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT4                      _PTIT.Bits.PTIT4
#define PTIT_PTIT5                      _PTIT.Bits.PTIT5
#define PTIT_PTIT6                      _PTIT.Bits.PTIT6
#define PTIT_PTIT7                      _PTIT.Bits.PTIT7

#define PTIT_PTIT0_MASK                 1U
#define PTIT_PTIT1_MASK                 2U
#define PTIT_PTIT2_MASK                 4U
#define PTIT_PTIT3_MASK                 8U
#define PTIT_PTIT4_MASK                 16U
#define PTIT_PTIT5_MASK                 32U
#define PTIT_PTIT6_MASK                 64U
#define PTIT_PTIT7_MASK                 128U


/*** DDRT - Port T Data Direction Register; 0x00000202 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Port T data direction bit 0 */
    byte DDRT1       :1;                                       /* Port T data direction bit 1 */
    byte DDRT2       :1;                                       /* Port T data direction bit 2 */
    byte DDRT3       :1;                                       /* Port T data direction bit 3 */
    byte DDRT4       :1;                                       /* Port T data direction bit 4 */
    byte DDRT5       :1;                                       /* Port T data direction bit 5 */
    byte DDRT6       :1;                                       /* Port T data direction bit 6 */
    byte DDRT7       :1;                                       /* Port T data direction bit 7 */
  } Bits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000202UL);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT4                      _DDRT.Bits.DDRT4
#define DDRT_DDRT5                      _DDRT.Bits.DDRT5
#define DDRT_DDRT6                      _DDRT.Bits.DDRT6
#define DDRT_DDRT7                      _DDRT.Bits.DDRT7

#define DDRT_DDRT0_MASK                 1U
#define DDRT_DDRT1_MASK                 2U
#define DDRT_DDRT2_MASK                 4U
#define DDRT_DDRT3_MASK                 8U
#define DDRT_DDRT4_MASK                 16U
#define DDRT_DDRT5_MASK                 32U
#define DDRT_DDRT6_MASK                 64U
#define DDRT_DDRT7_MASK                 128U


/*** RDRT - Port T Reduced Drive Register; 0x00000203 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRT0       :1;                                       /* Port T reduced drive bit 0 */
    byte RDRT1       :1;                                       /* Port T reduced drive bit 1 */
    byte RDRT2       :1;                                       /* Port T reduced drive bit 2 */
    byte RDRT3       :1;                                       /* Port T reduced drive bit 3 */
    byte RDRT4       :1;                                       /* Port T reduced drive bit 4 */
    byte RDRT5       :1;                                       /* Port T reduced drive bit 5 */
    byte RDRT6       :1;                                       /* Port T reduced drive bit 6 */
    byte RDRT7       :1;                                       /* Port T reduced drive bit 7 */
  } Bits;
} RDRTSTR;
extern volatile RDRTSTR _RDRT @(REG_BASE + 0x00000203UL);
#define RDRT                            _RDRT.Byte
#define RDRT_RDRT0                      _RDRT.Bits.RDRT0
#define RDRT_RDRT1                      _RDRT.Bits.RDRT1
#define RDRT_RDRT2                      _RDRT.Bits.RDRT2
#define RDRT_RDRT3                      _RDRT.Bits.RDRT3
#define RDRT_RDRT4                      _RDRT.Bits.RDRT4
#define RDRT_RDRT5                      _RDRT.Bits.RDRT5
#define RDRT_RDRT6                      _RDRT.Bits.RDRT6
#define RDRT_RDRT7                      _RDRT.Bits.RDRT7

#define RDRT_RDRT0_MASK                 1U
#define RDRT_RDRT1_MASK                 2U
#define RDRT_RDRT2_MASK                 4U
#define RDRT_RDRT3_MASK                 8U
#define RDRT_RDRT4_MASK                 16U
#define RDRT_RDRT5_MASK                 32U
#define RDRT_RDRT6_MASK                 64U
#define RDRT_RDRT7_MASK                 128U


/*** PERT - Port T Pull Device Enable Register; 0x00000204 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Port T pull device enable bit 0 */
    byte PERT1       :1;                                       /* Port T pull device enable bit 1 */
    byte PERT2       :1;                                       /* Port T pull device enable bit 2 */
    byte PERT3       :1;                                       /* Port T pull device enable bit 3 */
    byte PERT4       :1;                                       /* Port T pull device enable bit 4 */
    byte PERT5       :1;                                       /* Port T pull device enable bit 5 */
    byte PERT6       :1;                                       /* Port T pull device enable bit 6 */
    byte PERT7       :1;                                       /* Port T pull device enable bit 7 */
  } Bits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000204UL);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT4                      _PERT.Bits.PERT4
#define PERT_PERT5                      _PERT.Bits.PERT5
#define PERT_PERT6                      _PERT.Bits.PERT6
#define PERT_PERT7                      _PERT.Bits.PERT7

#define PERT_PERT0_MASK                 1U
#define PERT_PERT1_MASK                 2U
#define PERT_PERT2_MASK                 4U
#define PERT_PERT3_MASK                 8U
#define PERT_PERT4_MASK                 16U
#define PERT_PERT5_MASK                 32U
#define PERT_PERT6_MASK                 64U
#define PERT_PERT7_MASK                 128U


/*** PPST - Port T Polarity Select Register; 0x00000205 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Port T pull device select bit 0 */
    byte PPST1       :1;                                       /* Port T pull device select bit 1 */
    byte PPST2       :1;                                       /* Port T pull device select bit 2 */
    byte PPST3       :1;                                       /* Port T pull device select bit 3 */
    byte PPST4       :1;                                       /* Port T pull device select bit 4 */
    byte PPST5       :1;                                       /* Port T pull device select bit 5 */
    byte PPST6       :1;                                       /* Port T pull device select bit 6 */
    byte PPST7       :1;                                       /* Port T pull device select bit 7 */
  } Bits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000205UL);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST4                      _PPST.Bits.PPST4
#define PPST_PPST5                      _PPST.Bits.PPST5
#define PPST_PPST6                      _PPST.Bits.PPST6
#define PPST_PPST7                      _PPST.Bits.PPST7

#define PPST_PPST0_MASK                 1U
#define PPST_PPST1_MASK                 2U
#define PPST_PPST2_MASK                 4U
#define PPST_PPST3_MASK                 8U
#define PPST_PPST4_MASK                 16U
#define PPST_PPST5_MASK                 32U
#define PPST_PPST6_MASK                 64U
#define PPST_PPST7_MASK                 128U


/*** WOMT - Port T Wired-Or Mode Register; 0x00000206 ***/
typedef union {
  byte Byte;
  struct {
    byte MODRR0      :1;                                       /* Module Routing bit 0 */
    byte MODRR1      :1;                                       /* Module Routing bit 1 */
    byte MODRR2      :1;                                       /* Module Routing bit 2 */
    byte             :1; 
    byte WOMT4       :1;                                       /* Port T wired-or mode bit 4 */
    byte WOMT5       :1;                                       /* Port T wired-or mode bit 5 */
    byte WOMT6       :1;                                       /* Port T wired-or mode bit 6 */
    byte WOMT7       :1;                                       /* Port T wired-or mode bit 7 */
  } Bits;
  struct {
    byte grpMODRR :3;
    byte         :1;
    byte grpWOMT_4 :4;
  } MergedBits;
} WOMTSTR;
extern volatile WOMTSTR _WOMT @(REG_BASE + 0x00000206UL);
#define WOMT                            _WOMT.Byte
#define WOMT_MODRR0                     _WOMT.Bits.MODRR0
#define WOMT_MODRR1                     _WOMT.Bits.MODRR1
#define WOMT_MODRR2                     _WOMT.Bits.MODRR2
#define WOMT_WOMT4                      _WOMT.Bits.WOMT4
#define WOMT_WOMT5                      _WOMT.Bits.WOMT5
#define WOMT_WOMT6                      _WOMT.Bits.WOMT6
#define WOMT_WOMT7                      _WOMT.Bits.WOMT7
#define WOMT_MODRR                      _WOMT.MergedBits.grpMODRR
#define WOMT_WOMT_4                     _WOMT.MergedBits.grpWOMT_4

#define WOMT_MODRR0_MASK                1U
#define WOMT_MODRR1_MASK                2U
#define WOMT_MODRR2_MASK                4U
#define WOMT_WOMT4_MASK                 16U
#define WOMT_WOMT5_MASK                 32U
#define WOMT_WOMT6_MASK                 64U
#define WOMT_WOMT7_MASK                 128U
#define WOMT_MODRR_MASK                 7U
#define WOMT_MODRR_BITNUM               0U
#define WOMT_WOMT_4_MASK                240U
#define WOMT_WOMT_4_BITNUM              4U


/*** SRRT - Port T Slew Rate Register; 0x00000207 ***/
typedef union {
  byte Byte;
  struct {
    byte SRRT0       :1;                                       /* Slew rate port T bit 0 */
    byte SRRT1       :1;                                       /* Slew rate port T bit 1 */
    byte SRRT2       :1;                                       /* Slew rate port T bit 2 */
    byte SRRT3       :1;                                       /* Slew rate port T bit 3 */
    byte SRRT4       :1;                                       /* Slew rate port T bit 4 */
    byte SRRT5       :1;                                       /* Slew rate port T bit 5 */
    byte SRRT6       :1;                                       /* Slew rate port T bit 6 */
    byte SRRT7       :1;                                       /* Slew rate port T bit 7 */
  } Bits;
} SRRTSTR;
extern volatile SRRTSTR _SRRT @(REG_BASE + 0x00000207UL);
#define SRRT                            _SRRT.Byte
#define SRRT_SRRT0                      _SRRT.Bits.SRRT0
#define SRRT_SRRT1                      _SRRT.Bits.SRRT1
#define SRRT_SRRT2                      _SRRT.Bits.SRRT2
#define SRRT_SRRT3                      _SRRT.Bits.SRRT3
#define SRRT_SRRT4                      _SRRT.Bits.SRRT4
#define SRRT_SRRT5                      _SRRT.Bits.SRRT5
#define SRRT_SRRT6                      _SRRT.Bits.SRRT6
#define SRRT_SRRT7                      _SRRT.Bits.SRRT7

#define SRRT_SRRT0_MASK                 1U
#define SRRT_SRRT1_MASK                 2U
#define SRRT_SRRT2_MASK                 4U
#define SRRT_SRRT3_MASK                 8U
#define SRRT_SRRT4_MASK                 16U
#define SRRT_SRRT5_MASK                 32U
#define SRRT_SRRT6_MASK                 64U
#define SRRT_SRRT7_MASK                 128U


/*** PTS - Port S Data Register; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S general purpose input/output data bit 0 */
    byte PTS1        :1;                                       /* Port S general purpose input/output data bit 1 */
    byte PTS2        :1;                                       /* Port S general purpose input/output data bit 2 */
    byte PTS3        :1;                                       /* Port S general purpose input/output data bit 3 */
    byte PTS4        :1;                                       /* Port S general purpose input/output data bit 4 */
    byte PTS5        :1;                                       /* Port S general purpose input/output data bit 5 */
    byte PTS6        :1;                                       /* Port S general purpose input/output data bit 6 */
    byte PTS7        :1;                                       /* Port S general purpose input/output data bit 7 */
  } Bits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000208UL);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS2                        _PTS.Bits.PTS2
#define PTS_PTS3                        _PTS.Bits.PTS3
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS7                        _PTS.Bits.PTS7

#define PTS_PTS0_MASK                   1U
#define PTS_PTS1_MASK                   2U
#define PTS_PTS2_MASK                   4U
#define PTS_PTS3_MASK                   8U
#define PTS_PTS4_MASK                   16U
#define PTS_PTS5_MASK                   32U
#define PTS_PTS6_MASK                   64U
#define PTS_PTS7_MASK                   128U


/*** PTIS - Port S Input Register; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S input data bit 0 */
    byte PTIS1       :1;                                       /* Port S input data bit 1 */
    byte PTIS2       :1;                                       /* Port S input data bit 2 */
    byte PTIS3       :1;                                       /* Port S input data bit 3 */
    byte PTIS4       :1;                                       /* Port S input data bit 4 */
    byte PTIS5       :1;                                       /* Port S input data bit 5 */
    byte PTIS6       :1;                                       /* Port S input data bit 6 */
    byte PTIS7       :1;                                       /* Port S input data bit 7 */
  } Bits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000209UL);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS2                      _PTIS.Bits.PTIS2
#define PTIS_PTIS3                      _PTIS.Bits.PTIS3
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS7                      _PTIS.Bits.PTIS7

#define PTIS_PTIS0_MASK                 1U
#define PTIS_PTIS1_MASK                 2U
#define PTIS_PTIS2_MASK                 4U
#define PTIS_PTIS3_MASK                 8U
#define PTIS_PTIS4_MASK                 16U
#define PTIS_PTIS5_MASK                 32U
#define PTIS_PTIS6_MASK                 64U
#define PTIS_PTIS7_MASK                 128U


/*** DDRS - Port S Data Direction Register; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Port S data direction bit 0 */
    byte DDRS1       :1;                                       /* Port S data direction bit 1 */
    byte DDRS2       :1;                                       /* Port S data direction bit 2 */
    byte DDRS3       :1;                                       /* Port S data direction bit 3 */
    byte DDRS4       :1;                                       /* Port S data direction bit 4 */
    byte DDRS5       :1;                                       /* Port S data direction bit 5 */
    byte DDRS6       :1;                                       /* Port S data direction bit 6 */
    byte DDRS7       :1;                                       /* Port S data direction bit 7 */
  } Bits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x0000020AUL);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS2                      _DDRS.Bits.DDRS2
#define DDRS_DDRS3                      _DDRS.Bits.DDRS3
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS7                      _DDRS.Bits.DDRS7

#define DDRS_DDRS0_MASK                 1U
#define DDRS_DDRS1_MASK                 2U
#define DDRS_DDRS2_MASK                 4U
#define DDRS_DDRS3_MASK                 8U
#define DDRS_DDRS4_MASK                 16U
#define DDRS_DDRS5_MASK                 32U
#define DDRS_DDRS6_MASK                 64U
#define DDRS_DDRS7_MASK                 128U


/*** RDRS - Port S Reduced Drive Register; 0x0000020B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRS0       :1;                                       /* Port S reduced drive bit 0 */
    byte RDRS1       :1;                                       /* Port S reduced drive bit 1 */
    byte RDRS2       :1;                                       /* Port S reduced drive bit 2 */
    byte RDRS3       :1;                                       /* Port S reduced drive bit 3 */
    byte RDRS4       :1;                                       /* Port S reduced drive bit 4 */
    byte RDRS5       :1;                                       /* Port S reduced drive bit 5 */
    byte RDRS6       :1;                                       /* Port S reduced drive bit 6 */
    byte RDRS7       :1;                                       /* Port S reduced drive bit 7 */
  } Bits;
} RDRSSTR;
extern volatile RDRSSTR _RDRS @(REG_BASE + 0x0000020BUL);
#define RDRS                            _RDRS.Byte
#define RDRS_RDRS0                      _RDRS.Bits.RDRS0
#define RDRS_RDRS1                      _RDRS.Bits.RDRS1
#define RDRS_RDRS2                      _RDRS.Bits.RDRS2
#define RDRS_RDRS3                      _RDRS.Bits.RDRS3
#define RDRS_RDRS4                      _RDRS.Bits.RDRS4
#define RDRS_RDRS5                      _RDRS.Bits.RDRS5
#define RDRS_RDRS6                      _RDRS.Bits.RDRS6
#define RDRS_RDRS7                      _RDRS.Bits.RDRS7

#define RDRS_RDRS0_MASK                 1U
#define RDRS_RDRS1_MASK                 2U
#define RDRS_RDRS2_MASK                 4U
#define RDRS_RDRS3_MASK                 8U
#define RDRS_RDRS4_MASK                 16U
#define RDRS_RDRS5_MASK                 32U
#define RDRS_RDRS6_MASK                 64U
#define RDRS_RDRS7_MASK                 128U


/*** PERS - Port S Pull Device Enable Register; 0x0000020C ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Port S pull device enable bit 0 */
    byte PERS1       :1;                                       /* Port S pull device enable bit 1 */
    byte PERS2       :1;                                       /* Port S pull device enable bit 2 */
    byte PERS3       :1;                                       /* Port S pull device enable bit 3 */
    byte PERS4       :1;                                       /* Port S pull device enable bit 4 */
    byte PERS5       :1;                                       /* Port S pull device enable bit 5 */
    byte PERS6       :1;                                       /* Port S pull device enable bit 6 */
    byte PERS7       :1;                                       /* Port S pull device enable bit 7 */
  } Bits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x0000020CUL);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS2                      _PERS.Bits.PERS2
#define PERS_PERS3                      _PERS.Bits.PERS3
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS7                      _PERS.Bits.PERS7

#define PERS_PERS0_MASK                 1U
#define PERS_PERS1_MASK                 2U
#define PERS_PERS2_MASK                 4U
#define PERS_PERS3_MASK                 8U
#define PERS_PERS4_MASK                 16U
#define PERS_PERS5_MASK                 32U
#define PERS_PERS6_MASK                 64U
#define PERS_PERS7_MASK                 128U


/*** PPSS - Port S Polarity Select Register; 0x0000020D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Port S pull device select bit 0 */
    byte PPSS1       :1;                                       /* Port S pull device select bit 1 */
    byte PPSS2       :1;                                       /* Port S pull device select bit 2 */
    byte PPSS3       :1;                                       /* Port S pull device select bit 3 */
    byte PPSS4       :1;                                       /* Port S pull device select bit 4 */
    byte PPSS5       :1;                                       /* Port S pull device select bit 5 */
    byte PPSS6       :1;                                       /* Port S pull device select bit 6 */
    byte PPSS7       :1;                                       /* Port S pull device select bit 7 */
  } Bits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x0000020DUL);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS2                      _PPSS.Bits.PPSS2
#define PPSS_PPSS3                      _PPSS.Bits.PPSS3
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS7                      _PPSS.Bits.PPSS7

#define PPSS_PPSS0_MASK                 1U
#define PPSS_PPSS1_MASK                 2U
#define PPSS_PPSS2_MASK                 4U
#define PPSS_PPSS3_MASK                 8U
#define PPSS_PPSS4_MASK                 16U
#define PPSS_PPSS5_MASK                 32U
#define PPSS_PPSS6_MASK                 64U
#define PPSS_PPSS7_MASK                 128U


/*** WOMS - Port S Wired-Or Mode Register; 0x0000020E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMS0       :1;                                       /* Port S wired-or mode bit 0 */
    byte WOMS1       :1;                                       /* Port S wired-or mode bit 1 */
    byte WOMS2       :1;                                       /* Port S wired-or mode bit 2 */
    byte WOMS3       :1;                                       /* Port S wired-or mode bit 3 */
    byte WOMS4       :1;                                       /* Port S wired-or mode bit 4 */
    byte WOMS5       :1;                                       /* Port S wired-or mode bit 5 */
    byte WOMS6       :1;                                       /* Port S wired-or mode bit 6 */
    byte WOMS7       :1;                                       /* Port S wired-or mode bit 7 */
  } Bits;
} WOMSSTR;
extern volatile WOMSSTR _WOMS @(REG_BASE + 0x0000020EUL);
#define WOMS                            _WOMS.Byte
#define WOMS_WOMS0                      _WOMS.Bits.WOMS0
#define WOMS_WOMS1                      _WOMS.Bits.WOMS1
#define WOMS_WOMS2                      _WOMS.Bits.WOMS2
#define WOMS_WOMS3                      _WOMS.Bits.WOMS3
#define WOMS_WOMS4                      _WOMS.Bits.WOMS4
#define WOMS_WOMS5                      _WOMS.Bits.WOMS5
#define WOMS_WOMS6                      _WOMS.Bits.WOMS6
#define WOMS_WOMS7                      _WOMS.Bits.WOMS7

#define WOMS_WOMS0_MASK                 1U
#define WOMS_WOMS1_MASK                 2U
#define WOMS_WOMS2_MASK                 4U
#define WOMS_WOMS3_MASK                 8U
#define WOMS_WOMS4_MASK                 16U
#define WOMS_WOMS5_MASK                 32U
#define WOMS_WOMS6_MASK                 64U
#define WOMS_WOMS7_MASK                 128U


/*** SRRS - Port S Slew Rate Register; 0x0000020F ***/
typedef union {
  byte Byte;
  struct {
    byte SRRS0       :1;                                       /* Slew rate port S bit 0 */
    byte SRRS1       :1;                                       /* Slew rate port S bit 1 */
    byte SRRS2       :1;                                       /* Slew rate port S bit 2 */
    byte SRRS3       :1;                                       /* Slew rate port S bit 3 */
    byte SRRS4       :1;                                       /* Slew rate port S bit 4 */
    byte SRRS5       :1;                                       /* Slew rate port S bit 5 */
    byte SRRS6       :1;                                       /* Slew rate port S bit 6 */
    byte SRRS7       :1;                                       /* Slew rate port S bit 7 */
  } Bits;
} SRRSSTR;
extern volatile SRRSSTR _SRRS @(REG_BASE + 0x0000020FUL);
#define SRRS                            _SRRS.Byte
#define SRRS_SRRS0                      _SRRS.Bits.SRRS0
#define SRRS_SRRS1                      _SRRS.Bits.SRRS1
#define SRRS_SRRS2                      _SRRS.Bits.SRRS2
#define SRRS_SRRS3                      _SRRS.Bits.SRRS3
#define SRRS_SRRS4                      _SRRS.Bits.SRRS4
#define SRRS_SRRS5                      _SRRS.Bits.SRRS5
#define SRRS_SRRS6                      _SRRS.Bits.SRRS6
#define SRRS_SRRS7                      _SRRS.Bits.SRRS7

#define SRRS_SRRS0_MASK                 1U
#define SRRS_SRRS1_MASK                 2U
#define SRRS_SRRS2_MASK                 4U
#define SRRS_SRRS3_MASK                 8U
#define SRRS_SRRS4_MASK                 16U
#define SRRS_SRRS5_MASK                 32U
#define SRRS_SRRS6_MASK                 64U
#define SRRS_SRRS7_MASK                 128U


/*** PTM - Port M Data Register; 0x00000210 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PTM1        :1;                                       /* Port M general purpose input/output data bit 1 */
    byte PTM2        :1;                                       /* Port M general purpose input/output data bit 2 */
    byte PTM3        :1;                                       /* Port M general purpose input/output data bit 3 */
    byte PTM4        :1;                                       /* Port M general purpose input/output data bit 4 */
    byte PTM5        :1;                                       /* Port M general purpose input/output data bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpPTM_1 :5;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000210UL);
#define PTM                             _PTM.Byte
#define PTM_PTM1                        _PTM.Bits.PTM1
#define PTM_PTM2                        _PTM.Bits.PTM2
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM4                        _PTM.Bits.PTM4
#define PTM_PTM5                        _PTM.Bits.PTM5
#define PTM_PTM_1                       _PTM.MergedBits.grpPTM_1

#define PTM_PTM1_MASK                   2U
#define PTM_PTM2_MASK                   4U
#define PTM_PTM3_MASK                   8U
#define PTM_PTM4_MASK                   16U
#define PTM_PTM5_MASK                   32U
#define PTM_PTM_1_MASK                  62U
#define PTM_PTM_1_BITNUM                1U


/*** PTIM - Port M Input Register; 0x00000211 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PTIM1       :1;                                       /* Port M input data bit 1 */
    byte PTIM2       :1;                                       /* Port M input data bit 2 */
    byte PTIM3       :1;                                       /* Port M input data bit 3 */
    byte PTIM4       :1;                                       /* Port M input data bit 4 */
    byte PTIM5       :1;                                       /* Port M input data bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpPTIM_1 :5;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000211UL);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM1                      _PTIM.Bits.PTIM1
#define PTIM_PTIM2                      _PTIM.Bits.PTIM2
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM4                      _PTIM.Bits.PTIM4
#define PTIM_PTIM5                      _PTIM.Bits.PTIM5
#define PTIM_PTIM_1                     _PTIM.MergedBits.grpPTIM_1

#define PTIM_PTIM1_MASK                 2U
#define PTIM_PTIM2_MASK                 4U
#define PTIM_PTIM3_MASK                 8U
#define PTIM_PTIM4_MASK                 16U
#define PTIM_PTIM5_MASK                 32U
#define PTIM_PTIM_1_MASK                62U
#define PTIM_PTIM_1_BITNUM              1U


/*** DDRM - Port M Data Direction Register; 0x00000212 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte DDRM1       :1;                                       /* Port M data direction bit 1 */
    byte DDRM2       :1;                                       /* Port M data direction bit 2 */
    byte DDRM3       :1;                                       /* Port M data direction bit 3 */
    byte DDRM4       :1;                                       /* Port M data direction bit 4 */
    byte DDRM5       :1;                                       /* Port M data direction bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpDDRM_1 :5;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x00000212UL);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM1                      _DDRM.Bits.DDRM1
#define DDRM_DDRM2                      _DDRM.Bits.DDRM2
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM4                      _DDRM.Bits.DDRM4
#define DDRM_DDRM5                      _DDRM.Bits.DDRM5
#define DDRM_DDRM_1                     _DDRM.MergedBits.grpDDRM_1

#define DDRM_DDRM1_MASK                 2U
#define DDRM_DDRM2_MASK                 4U
#define DDRM_DDRM3_MASK                 8U
#define DDRM_DDRM4_MASK                 16U
#define DDRM_DDRM5_MASK                 32U
#define DDRM_DDRM_1_MASK                62U
#define DDRM_DDRM_1_BITNUM              1U


/*** RDRM - Port M Reduced Drive Register; 0x00000213 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte RDRM1       :1;                                       /* Port M reduced drive bit 1 */
    byte RDRM2       :1;                                       /* Port M reduced drive bit 2 */
    byte RDRM3       :1;                                       /* Port M reduced drive bit 3 */
    byte RDRM4       :1;                                       /* Port M reduced drive bit 4 */
    byte RDRM5       :1;                                       /* Port M reduced drive bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpRDRM_1 :5;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRMSTR;
extern volatile RDRMSTR _RDRM @(REG_BASE + 0x00000213UL);
#define RDRM                            _RDRM.Byte
#define RDRM_RDRM1                      _RDRM.Bits.RDRM1
#define RDRM_RDRM2                      _RDRM.Bits.RDRM2
#define RDRM_RDRM3                      _RDRM.Bits.RDRM3
#define RDRM_RDRM4                      _RDRM.Bits.RDRM4
#define RDRM_RDRM5                      _RDRM.Bits.RDRM5
#define RDRM_RDRM_1                     _RDRM.MergedBits.grpRDRM_1

#define RDRM_RDRM1_MASK                 2U
#define RDRM_RDRM2_MASK                 4U
#define RDRM_RDRM3_MASK                 8U
#define RDRM_RDRM4_MASK                 16U
#define RDRM_RDRM5_MASK                 32U
#define RDRM_RDRM_1_MASK                62U
#define RDRM_RDRM_1_BITNUM              1U


/*** PERM - Port M Pull Device Enable Register; 0x00000214 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PERM1       :1;                                       /* Port M pull device enable bit 1 */
    byte PERM2       :1;                                       /* Port M pull device enable bit 2 */
    byte PERM3       :1;                                       /* Port M pull device enable bit 3 */
    byte PERM4       :1;                                       /* Port M pull device enable bit 4 */
    byte PERM5       :1;                                       /* Port M pull device enable bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpPERM_1 :5;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x00000214UL);
#define PERM                            _PERM.Byte
#define PERM_PERM1                      _PERM.Bits.PERM1
#define PERM_PERM2                      _PERM.Bits.PERM2
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM4                      _PERM.Bits.PERM4
#define PERM_PERM5                      _PERM.Bits.PERM5
#define PERM_PERM_1                     _PERM.MergedBits.grpPERM_1

#define PERM_PERM1_MASK                 2U
#define PERM_PERM2_MASK                 4U
#define PERM_PERM3_MASK                 8U
#define PERM_PERM4_MASK                 16U
#define PERM_PERM5_MASK                 32U
#define PERM_PERM_1_MASK                62U
#define PERM_PERM_1_BITNUM              1U


/*** PPSM - Port M Polarity Select Register; 0x00000215 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PPSM1       :1;                                       /* Port M pull device select bit 1 */
    byte PPSM2       :1;                                       /* Port M pull device select bit 2 */
    byte PPSM3       :1;                                       /* Port M pull device select bit 3 */
    byte PPSM4       :1;                                       /* Port M pull device select bit 4 */
    byte PPSM5       :1;                                       /* Port M pull device select bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpPPSM_1 :5;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x00000215UL);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM1                      _PPSM.Bits.PPSM1
#define PPSM_PPSM2                      _PPSM.Bits.PPSM2
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM4                      _PPSM.Bits.PPSM4
#define PPSM_PPSM5                      _PPSM.Bits.PPSM5
#define PPSM_PPSM_1                     _PPSM.MergedBits.grpPPSM_1

#define PPSM_PPSM1_MASK                 2U
#define PPSM_PPSM2_MASK                 4U
#define PPSM_PPSM3_MASK                 8U
#define PPSM_PPSM4_MASK                 16U
#define PPSM_PPSM5_MASK                 32U
#define PPSM_PPSM_1_MASK                62U
#define PPSM_PPSM_1_BITNUM              1U


/*** WOMM - Port M Wired-Or Mode Register; 0x00000216 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte WOMM1       :1;                                       /* Port M wired-or mode bit 1 */
    byte WOMM2       :1;                                       /* Port M wired-or mode bit 2 */
    byte WOMM3       :1;                                       /* Port M wired-or mode bit 3 */
    byte WOMM4       :1;                                       /* Port M wired-or mode bit 4 */
    byte WOMM5       :1;                                       /* Port M wired-or mode bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpWOMM_1 :5;
    byte         :1;
    byte         :1;
  } MergedBits;
} WOMMSTR;
extern volatile WOMMSTR _WOMM @(REG_BASE + 0x00000216UL);
#define WOMM                            _WOMM.Byte
#define WOMM_WOMM1                      _WOMM.Bits.WOMM1
#define WOMM_WOMM2                      _WOMM.Bits.WOMM2
#define WOMM_WOMM3                      _WOMM.Bits.WOMM3
#define WOMM_WOMM4                      _WOMM.Bits.WOMM4
#define WOMM_WOMM5                      _WOMM.Bits.WOMM5
#define WOMM_WOMM_1                     _WOMM.MergedBits.grpWOMM_1

#define WOMM_WOMM1_MASK                 2U
#define WOMM_WOMM2_MASK                 4U
#define WOMM_WOMM3_MASK                 8U
#define WOMM_WOMM4_MASK                 16U
#define WOMM_WOMM5_MASK                 32U
#define WOMM_WOMM_1_MASK                62U
#define WOMM_WOMM_1_BITNUM              1U


/*** SRRM - Port M Slew Rate Register; 0x00000217 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SRRM1       :1;                                       /* Slew rate port M bit 1 */
    byte SRRM2       :1;                                       /* Slew rate port M bit 2 */
    byte SRRM3       :1;                                       /* Slew rate port M bit 3 */
    byte SRRM4       :1;                                       /* Slew rate port M bit 4 */
    byte SRRM5       :1;                                       /* Slew rate port M bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte grpSRRM_1 :5;
    byte         :1;
    byte         :1;
  } MergedBits;
} SRRMSTR;
extern volatile SRRMSTR _SRRM @(REG_BASE + 0x00000217UL);
#define SRRM                            _SRRM.Byte
#define SRRM_SRRM1                      _SRRM.Bits.SRRM1
#define SRRM_SRRM2                      _SRRM.Bits.SRRM2
#define SRRM_SRRM3                      _SRRM.Bits.SRRM3
#define SRRM_SRRM4                      _SRRM.Bits.SRRM4
#define SRRM_SRRM5                      _SRRM.Bits.SRRM5
#define SRRM_SRRM_1                     _SRRM.MergedBits.grpSRRM_1

#define SRRM_SRRM1_MASK                 2U
#define SRRM_SRRM2_MASK                 4U
#define SRRM_SRRM3_MASK                 8U
#define SRRM_SRRM4_MASK                 16U
#define SRRM_SRRM5_MASK                 32U
#define SRRM_SRRM_1_MASK                62U
#define SRRM_SRRM_1_BITNUM              1U


/*** PTP - Port P Data Register; 0x00000218 ***/
typedef union {
  byte Byte;
  struct {
    byte PTP0        :1;                                       /* Port P general purpose input/output data bit 0 */
    byte PTP1        :1;                                       /* Port P general purpose input/output data bit 1 */
    byte PTP2        :1;                                       /* Port P general purpose input/output data bit 2 */
    byte PTP3        :1;                                       /* Port P general purpose input/output data bit 3 */
    byte PTP4        :1;                                       /* Port P general purpose input/output data bit 4 */
    byte PTP5        :1;                                       /* Port P general purpose input/output data bit 5 */
    byte PTP6        :1;                                       /* Port P general purpose input/output data bit 6 */
    byte PTP7        :1;                                       /* Port P general purpose input/output data bit 7 */
  } Bits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000218UL);
#define PTP                             _PTP.Byte
#define PTP_PTP0                        _PTP.Bits.PTP0
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP2                        _PTP.Bits.PTP2
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP6                        _PTP.Bits.PTP6
#define PTP_PTP7                        _PTP.Bits.PTP7

#define PTP_PTP0_MASK                   1U
#define PTP_PTP1_MASK                   2U
#define PTP_PTP2_MASK                   4U
#define PTP_PTP3_MASK                   8U
#define PTP_PTP4_MASK                   16U
#define PTP_PTP5_MASK                   32U
#define PTP_PTP6_MASK                   64U
#define PTP_PTP7_MASK                   128U


/*** PTIP - Port P Input Register; 0x00000219 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIP0       :1;                                       /* Port P input data bit 0 */
    byte PTIP1       :1;                                       /* Port P input data bit 1 */
    byte PTIP2       :1;                                       /* Port P input data bit 2 */
    byte PTIP3       :1;                                       /* Port P input data bit 3 */
    byte PTIP4       :1;                                       /* Port P input data bit 4 */
    byte PTIP5       :1;                                       /* Port P input data bit 5 */
    byte PTIP6       :1;                                       /* Port P input data bit 6 */
    byte PTIP7       :1;                                       /* Port P input data bit 7 */
  } Bits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000219UL);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP0                      _PTIP.Bits.PTIP0
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP2                      _PTIP.Bits.PTIP2
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP6                      _PTIP.Bits.PTIP6
#define PTIP_PTIP7                      _PTIP.Bits.PTIP7

#define PTIP_PTIP0_MASK                 1U
#define PTIP_PTIP1_MASK                 2U
#define PTIP_PTIP2_MASK                 4U
#define PTIP_PTIP3_MASK                 8U
#define PTIP_PTIP4_MASK                 16U
#define PTIP_PTIP5_MASK                 32U
#define PTIP_PTIP6_MASK                 64U
#define PTIP_PTIP7_MASK                 128U


/*** DDRP - Port P Data Direction Register; 0x0000021A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRP0       :1;                                       /* Port P data direction bit 0 */
    byte DDRP1       :1;                                       /* Port P data direction bit 1 */
    byte DDRP2       :1;                                       /* Port P data direction bit 2 */
    byte DDRP3       :1;                                       /* Port P data direction bit 3 */
    byte DDRP4       :1;                                       /* Port P data direction bit 4 */
    byte DDRP5       :1;                                       /* Port P data direction bit 5 */
    byte DDRP6       :1;                                       /* Port P data direction bit 6 */
    byte DDRP7       :1;                                       /* Port P data direction bit 7 */
  } Bits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000021AUL);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP0                      _DDRP.Bits.DDRP0
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP2                      _DDRP.Bits.DDRP2
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP6                      _DDRP.Bits.DDRP6
#define DDRP_DDRP7                      _DDRP.Bits.DDRP7

#define DDRP_DDRP0_MASK                 1U
#define DDRP_DDRP1_MASK                 2U
#define DDRP_DDRP2_MASK                 4U
#define DDRP_DDRP3_MASK                 8U
#define DDRP_DDRP4_MASK                 16U
#define DDRP_DDRP5_MASK                 32U
#define DDRP_DDRP6_MASK                 64U
#define DDRP_DDRP7_MASK                 128U


/*** RDRP - Port P Reduced Drive Register; 0x0000021B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRP0       :1;                                       /* Port P reduced drive bit 0 */
    byte RDRP1       :1;                                       /* Port P reduced drive bit 1 */
    byte RDRP2       :1;                                       /* Port P reduced drive bit 2 */
    byte RDRP3       :1;                                       /* Port P reduced drive bit 3 */
    byte RDRP4       :1;                                       /* Port P reduced drive bit 4 */
    byte RDRP5       :1;                                       /* Port P reduced drive bit 5 */
    byte RDRP6       :1;                                       /* Port P reduced drive bit 6 */
    byte RDRP7       :1;                                       /* Port P reduced drive bit 7 */
  } Bits;
} RDRPSTR;
extern volatile RDRPSTR _RDRP @(REG_BASE + 0x0000021BUL);
#define RDRP                            _RDRP.Byte
#define RDRP_RDRP0                      _RDRP.Bits.RDRP0
#define RDRP_RDRP1                      _RDRP.Bits.RDRP1
#define RDRP_RDRP2                      _RDRP.Bits.RDRP2
#define RDRP_RDRP3                      _RDRP.Bits.RDRP3
#define RDRP_RDRP4                      _RDRP.Bits.RDRP4
#define RDRP_RDRP5                      _RDRP.Bits.RDRP5
#define RDRP_RDRP6                      _RDRP.Bits.RDRP6
#define RDRP_RDRP7                      _RDRP.Bits.RDRP7

#define RDRP_RDRP0_MASK                 1U
#define RDRP_RDRP1_MASK                 2U
#define RDRP_RDRP2_MASK                 4U
#define RDRP_RDRP3_MASK                 8U
#define RDRP_RDRP4_MASK                 16U
#define RDRP_RDRP5_MASK                 32U
#define RDRP_RDRP6_MASK                 64U
#define RDRP_RDRP7_MASK                 128U


/*** PERP - Port P Pull Device Enable Register; 0x0000021C ***/
typedef union {
  byte Byte;
  struct {
    byte PERP0       :1;                                       /* Port P pull device enable bit 0 */
    byte PERP1       :1;                                       /* Port P pull device enable bit 1 */
    byte PERP2       :1;                                       /* Port P pull device enable bit 2 */
    byte PERP3       :1;                                       /* Port P pull device enable bit 3 */
    byte PERP4       :1;                                       /* Port P pull device enable bit 4 */
    byte PERP5       :1;                                       /* Port P pull device enable bit 5 */
    byte PERP6       :1;                                       /* Port P pull device enable bit 6 */
    byte PERP7       :1;                                       /* Port P pull device enable bit 7 */
  } Bits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000021CUL);
#define PERP                            _PERP.Byte
#define PERP_PERP0                      _PERP.Bits.PERP0
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP2                      _PERP.Bits.PERP2
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP6                      _PERP.Bits.PERP6
#define PERP_PERP7                      _PERP.Bits.PERP7

#define PERP_PERP0_MASK                 1U
#define PERP_PERP1_MASK                 2U
#define PERP_PERP2_MASK                 4U
#define PERP_PERP3_MASK                 8U
#define PERP_PERP4_MASK                 16U
#define PERP_PERP5_MASK                 32U
#define PERP_PERP6_MASK                 64U
#define PERP_PERP7_MASK                 128U


/*** PPSP - Port P Polarity Select Register; 0x0000021D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSP0       :1;                                       /* Port P pull device select bit 0 */
    byte PPSP1       :1;                                       /* Port P pull device select bit 1 */
    byte PPSP2       :1;                                       /* Port P pull device select bit 2 */
    byte PPSP3       :1;                                       /* Port P pull device select bit 3 */
    byte PPSP4       :1;                                       /* Port P pull device select bit 4 */
    byte PPSP5       :1;                                       /* Port P pull device select bit 5 */
    byte PPSP6       :1;                                       /* Port P pull device select bit 6 */
    byte PPSP7       :1;                                       /* Port P pull device select bit 7 */
  } Bits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000021DUL);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP0                      _PPSP.Bits.PPSP0
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP2                      _PPSP.Bits.PPSP2
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP6                      _PPSP.Bits.PPSP6
#define PPSP_PPSP7                      _PPSP.Bits.PPSP7

#define PPSP_PPSP0_MASK                 1U
#define PPSP_PPSP1_MASK                 2U
#define PPSP_PPSP2_MASK                 4U
#define PPSP_PPSP3_MASK                 8U
#define PPSP_PPSP4_MASK                 16U
#define PPSP_PPSP5_MASK                 32U
#define PPSP_PPSP6_MASK                 64U
#define PPSP_PPSP7_MASK                 128U


/*** WOMP - Port P Wired-Or Mode Register; 0x0000021E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMP0       :1;                                       /* Port P wired-or mode bit 0 */
    byte             :1; 
    byte WOMP2       :1;                                       /* Port P wired-or mode bit 2 */
    byte             :1; 
    byte WOMP4       :1;                                       /* Port P wired-or mode bit 4 */
    byte WOMP5       :1;                                       /* Port P wired-or mode bit 5 */
    byte WOMP6       :1;                                       /* Port P wired-or mode bit 6 */
    byte WOMP7       :1;                                       /* Port P wired-or mode bit 7 */
  } Bits;
  struct {
    byte grpWOMP :1;
    byte         :1;
    byte grpWOMP_2 :1;
    byte         :1;
    byte grpWOMP_4 :4;
  } MergedBits;
} WOMPSTR;
extern volatile WOMPSTR _WOMP @(REG_BASE + 0x0000021EUL);
#define WOMP                            _WOMP.Byte
#define WOMP_WOMP0                      _WOMP.Bits.WOMP0
#define WOMP_WOMP2                      _WOMP.Bits.WOMP2
#define WOMP_WOMP4                      _WOMP.Bits.WOMP4
#define WOMP_WOMP5                      _WOMP.Bits.WOMP5
#define WOMP_WOMP6                      _WOMP.Bits.WOMP6
#define WOMP_WOMP7                      _WOMP.Bits.WOMP7
#define WOMP_WOMP_4                     _WOMP.MergedBits.grpWOMP_4

#define WOMP_WOMP0_MASK                 1U
#define WOMP_WOMP2_MASK                 4U
#define WOMP_WOMP4_MASK                 16U
#define WOMP_WOMP5_MASK                 32U
#define WOMP_WOMP6_MASK                 64U
#define WOMP_WOMP7_MASK                 128U
#define WOMP_WOMP_4_MASK                240U
#define WOMP_WOMP_4_BITNUM              4U


/*** SRRP - Port P Slew Rate Register; 0x0000021F ***/
typedef union {
  byte Byte;
  struct {
    byte SRRP0       :1;                                       /* Slew rate port P bit 0 */
    byte SRRP1       :1;                                       /* Slew rate port P bit 1 */
    byte SRRP2       :1;                                       /* Slew rate port P bit 2 */
    byte SRRP3       :1;                                       /* Slew rate port P bit 3 */
    byte SRRP4       :1;                                       /* Slew rate port P bit 4 */
    byte SRRP5       :1;                                       /* Slew rate port P bit 5 */
    byte SRRP6       :1;                                       /* Slew rate port P bit 6 */
    byte SRRP7       :1;                                       /* Slew rate port P bit 7 */
  } Bits;
} SRRPSTR;
extern volatile SRRPSTR _SRRP @(REG_BASE + 0x0000021FUL);
#define SRRP                            _SRRP.Byte
#define SRRP_SRRP0                      _SRRP.Bits.SRRP0
#define SRRP_SRRP1                      _SRRP.Bits.SRRP1
#define SRRP_SRRP2                      _SRRP.Bits.SRRP2
#define SRRP_SRRP3                      _SRRP.Bits.SRRP3
#define SRRP_SRRP4                      _SRRP.Bits.SRRP4
#define SRRP_SRRP5                      _SRRP.Bits.SRRP5
#define SRRP_SRRP6                      _SRRP.Bits.SRRP6
#define SRRP_SRRP7                      _SRRP.Bits.SRRP7

#define SRRP_SRRP0_MASK                 1U
#define SRRP_SRRP1_MASK                 2U
#define SRRP_SRRP2_MASK                 4U
#define SRRP_SRRP3_MASK                 8U
#define SRRP_SRRP4_MASK                 16U
#define SRRP_SRRP5_MASK                 32U
#define SRRP_SRRP6_MASK                 64U
#define SRRP_SRRP7_MASK                 128U


/*** PTL - Port L Data Register; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte PTL0        :1;                                       /* Port L general purpose input/output data bit 0 */
    byte PTL1        :1;                                       /* Port L general purpose input/output data bit 1 */
    byte PTL2        :1;                                       /* Port L general purpose input/output data bit 2 */
    byte PTL3        :1;                                       /* Port L general purpose input/output data bit 3 */
    byte PTL4        :1;                                       /* Port L general purpose input/output data bit 4 */
    byte PTL5        :1;                                       /* Port L general purpose input/output data bit 5 */
    byte PTL6        :1;                                       /* Port L general purpose input/output data bit 6 */
    byte PTL7        :1;                                       /* Port L general purpose input/output data bit 7 */
  } Bits;
} PTLSTR;
extern volatile PTLSTR _PTL @(REG_BASE + 0x00000230UL);
#define PTL                             _PTL.Byte
#define PTL_PTL0                        _PTL.Bits.PTL0
#define PTL_PTL1                        _PTL.Bits.PTL1
#define PTL_PTL2                        _PTL.Bits.PTL2
#define PTL_PTL3                        _PTL.Bits.PTL3
#define PTL_PTL4                        _PTL.Bits.PTL4
#define PTL_PTL5                        _PTL.Bits.PTL5
#define PTL_PTL6                        _PTL.Bits.PTL6
#define PTL_PTL7                        _PTL.Bits.PTL7

#define PTL_PTL0_MASK                   1U
#define PTL_PTL1_MASK                   2U
#define PTL_PTL2_MASK                   4U
#define PTL_PTL3_MASK                   8U
#define PTL_PTL4_MASK                   16U
#define PTL_PTL5_MASK                   32U
#define PTL_PTL6_MASK                   64U
#define PTL_PTL7_MASK                   128U


/*** PTIL - Port L Input Register; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIL0       :1;                                       /* Port L input data bit 0 */
    byte PTIL1       :1;                                       /* Port L input data bit 1 */
    byte PTIL2       :1;                                       /* Port L input data bit 2 */
    byte PTIL3       :1;                                       /* Port L input data bit 3 */
    byte PTIL4       :1;                                       /* Port L input data bit 4 */
    byte PTIL5       :1;                                       /* Port L input data bit 5 */
    byte PTIL6       :1;                                       /* Port L input data bit 6 */
    byte PTIL7       :1;                                       /* Port L input data bit 7 */
  } Bits;
} PTILSTR;
extern volatile PTILSTR _PTIL @(REG_BASE + 0x00000231UL);
#define PTIL                            _PTIL.Byte
#define PTIL_PTIL0                      _PTIL.Bits.PTIL0
#define PTIL_PTIL1                      _PTIL.Bits.PTIL1
#define PTIL_PTIL2                      _PTIL.Bits.PTIL2
#define PTIL_PTIL3                      _PTIL.Bits.PTIL3
#define PTIL_PTIL4                      _PTIL.Bits.PTIL4
#define PTIL_PTIL5                      _PTIL.Bits.PTIL5
#define PTIL_PTIL6                      _PTIL.Bits.PTIL6
#define PTIL_PTIL7                      _PTIL.Bits.PTIL7

#define PTIL_PTIL0_MASK                 1U
#define PTIL_PTIL1_MASK                 2U
#define PTIL_PTIL2_MASK                 4U
#define PTIL_PTIL3_MASK                 8U
#define PTIL_PTIL4_MASK                 16U
#define PTIL_PTIL5_MASK                 32U
#define PTIL_PTIL6_MASK                 64U
#define PTIL_PTIL7_MASK                 128U


/*** DDRL - Port L Data Direction Register; 0x00000232 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRL0       :1;                                       /* Port L data direction bit 0 */
    byte DDRL1       :1;                                       /* Port L data direction bit 1 */
    byte DDRL2       :1;                                       /* Port L data direction bit 2 */
    byte DDRL3       :1;                                       /* Port L data direction bit 3 */
    byte DDRL4       :1;                                       /* Port L data direction bit 4 */
    byte DDRL5       :1;                                       /* Port L data direction bit 5 */
    byte DDRL6       :1;                                       /* Port L data direction bit 6 */
    byte DDRL7       :1;                                       /* Port L data direction bit 7 */
  } Bits;
} DDRLSTR;
extern volatile DDRLSTR _DDRL @(REG_BASE + 0x00000232UL);
#define DDRL                            _DDRL.Byte
#define DDRL_DDRL0                      _DDRL.Bits.DDRL0
#define DDRL_DDRL1                      _DDRL.Bits.DDRL1
#define DDRL_DDRL2                      _DDRL.Bits.DDRL2
#define DDRL_DDRL3                      _DDRL.Bits.DDRL3
#define DDRL_DDRL4                      _DDRL.Bits.DDRL4
#define DDRL_DDRL5                      _DDRL.Bits.DDRL5
#define DDRL_DDRL6                      _DDRL.Bits.DDRL6
#define DDRL_DDRL7                      _DDRL.Bits.DDRL7

#define DDRL_DDRL0_MASK                 1U
#define DDRL_DDRL1_MASK                 2U
#define DDRL_DDRL2_MASK                 4U
#define DDRL_DDRL3_MASK                 8U
#define DDRL_DDRL4_MASK                 16U
#define DDRL_DDRL5_MASK                 32U
#define DDRL_DDRL6_MASK                 64U
#define DDRL_DDRL7_MASK                 128U


/*** RDRL - Port L Reduced Drive Register; 0x00000233 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRL0       :1;                                       /* Port L reduced drive bit 0 */
    byte RDRL1       :1;                                       /* Port L reduced drive bit 1 */
    byte RDRL2       :1;                                       /* Port L reduced drive bit 2 */
    byte RDRL3       :1;                                       /* Port L reduced drive bit 3 */
    byte RDRL4       :1;                                       /* Port L reduced drive bit 4 */
    byte RDRL5       :1;                                       /* Port L reduced drive bit 5 */
    byte RDRL6       :1;                                       /* Port L reduced drive bit 6 */
    byte RDRL7       :1;                                       /* Port L reduced drive bit 7 */
  } Bits;
} RDRLSTR;
extern volatile RDRLSTR _RDRL @(REG_BASE + 0x00000233UL);
#define RDRL                            _RDRL.Byte
#define RDRL_RDRL0                      _RDRL.Bits.RDRL0
#define RDRL_RDRL1                      _RDRL.Bits.RDRL1
#define RDRL_RDRL2                      _RDRL.Bits.RDRL2
#define RDRL_RDRL3                      _RDRL.Bits.RDRL3
#define RDRL_RDRL4                      _RDRL.Bits.RDRL4
#define RDRL_RDRL5                      _RDRL.Bits.RDRL5
#define RDRL_RDRL6                      _RDRL.Bits.RDRL6
#define RDRL_RDRL7                      _RDRL.Bits.RDRL7

#define RDRL_RDRL0_MASK                 1U
#define RDRL_RDRL1_MASK                 2U
#define RDRL_RDRL2_MASK                 4U
#define RDRL_RDRL3_MASK                 8U
#define RDRL_RDRL4_MASK                 16U
#define RDRL_RDRL5_MASK                 32U
#define RDRL_RDRL6_MASK                 64U
#define RDRL_RDRL7_MASK                 128U


/*** PERL - Port L Pull Device Enable Register; 0x00000234 ***/
typedef union {
  byte Byte;
  struct {
    byte PERL0       :1;                                       /* Port L pull device enable bit 0 */
    byte PERL1       :1;                                       /* Port L pull device enable bit 1 */
    byte PERL2       :1;                                       /* Port L pull device enable bit 2 */
    byte PERL3       :1;                                       /* Port L pull device enable bit 3 */
    byte PERL4       :1;                                       /* Port L pull device enable bit 4 */
    byte PERL5       :1;                                       /* Port L pull device enable bit 5 */
    byte PERL6       :1;                                       /* Port L pull device enable bit 6 */
    byte PERL7       :1;                                       /* Port L pull device enable bit 7 */
  } Bits;
} PERLSTR;
extern volatile PERLSTR _PERL @(REG_BASE + 0x00000234UL);
#define PERL                            _PERL.Byte
#define PERL_PERL0                      _PERL.Bits.PERL0
#define PERL_PERL1                      _PERL.Bits.PERL1
#define PERL_PERL2                      _PERL.Bits.PERL2
#define PERL_PERL3                      _PERL.Bits.PERL3
#define PERL_PERL4                      _PERL.Bits.PERL4
#define PERL_PERL5                      _PERL.Bits.PERL5
#define PERL_PERL6                      _PERL.Bits.PERL6
#define PERL_PERL7                      _PERL.Bits.PERL7

#define PERL_PERL0_MASK                 1U
#define PERL_PERL1_MASK                 2U
#define PERL_PERL2_MASK                 4U
#define PERL_PERL3_MASK                 8U
#define PERL_PERL4_MASK                 16U
#define PERL_PERL5_MASK                 32U
#define PERL_PERL6_MASK                 64U
#define PERL_PERL7_MASK                 128U


/*** PPSL - Port L Polarity Select Register; 0x00000235 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSL0       :1;                                       /* Port L pull device select bit 0 */
    byte PPSL1       :1;                                       /* Port L pull device select bit 1 */
    byte PPSL2       :1;                                       /* Port L pull device select bit 2 */
    byte PPSL3       :1;                                       /* Port L pull device select bit 3 */
    byte PPSL4       :1;                                       /* Port L pull device select bit 4 */
    byte PPSL5       :1;                                       /* Port L pull device select bit 5 */
    byte PPSL6       :1;                                       /* Port L pull device select bit 6 */
    byte PPSL7       :1;                                       /* Port L pull device select bit 7 */
  } Bits;
} PPSLSTR;
extern volatile PPSLSTR _PPSL @(REG_BASE + 0x00000235UL);
#define PPSL                            _PPSL.Byte
#define PPSL_PPSL0                      _PPSL.Bits.PPSL0
#define PPSL_PPSL1                      _PPSL.Bits.PPSL1
#define PPSL_PPSL2                      _PPSL.Bits.PPSL2
#define PPSL_PPSL3                      _PPSL.Bits.PPSL3
#define PPSL_PPSL4                      _PPSL.Bits.PPSL4
#define PPSL_PPSL5                      _PPSL.Bits.PPSL5
#define PPSL_PPSL6                      _PPSL.Bits.PPSL6
#define PPSL_PPSL7                      _PPSL.Bits.PPSL7

#define PPSL_PPSL0_MASK                 1U
#define PPSL_PPSL1_MASK                 2U
#define PPSL_PPSL2_MASK                 4U
#define PPSL_PPSL3_MASK                 8U
#define PPSL_PPSL4_MASK                 16U
#define PPSL_PPSL5_MASK                 32U
#define PPSL_PPSL6_MASK                 64U
#define PPSL_PPSL7_MASK                 128U


/*** SRRL - Port L Slew Rate Register; 0x00000237 ***/
typedef union {
  byte Byte;
  struct {
    byte SRRL0       :1;                                       /* Slew rate port L bit 0 */
    byte SRRL1       :1;                                       /* Slew rate port L bit 1 */
    byte SRRL2       :1;                                       /* Slew rate port L bit 2 */
    byte SRRL3       :1;                                       /* Slew rate port L bit 3 */
    byte SRRL4       :1;                                       /* Slew rate port L bit 4 */
    byte SRRL5       :1;                                       /* Slew rate port L bit 5 */
    byte SRRL6       :1;                                       /* Slew rate port L bit 6 */
    byte SRRL7       :1;                                       /* Slew rate port L bit 7 */
  } Bits;
} SRRLSTR;
extern volatile SRRLSTR _SRRL @(REG_BASE + 0x00000237UL);
#define SRRL                            _SRRL.Byte
#define SRRL_SRRL0                      _SRRL.Bits.SRRL0
#define SRRL_SRRL1                      _SRRL.Bits.SRRL1
#define SRRL_SRRL2                      _SRRL.Bits.SRRL2
#define SRRL_SRRL3                      _SRRL.Bits.SRRL3
#define SRRL_SRRL4                      _SRRL.Bits.SRRL4
#define SRRL_SRRL5                      _SRRL.Bits.SRRL5
#define SRRL_SRRL6                      _SRRL.Bits.SRRL6
#define SRRL_SRRL7                      _SRRL.Bits.SRRL7

#define SRRL_SRRL0_MASK                 1U
#define SRRL_SRRL1_MASK                 2U
#define SRRL_SRRL2_MASK                 4U
#define SRRL_SRRL3_MASK                 8U
#define SRRL_SRRL4_MASK                 16U
#define SRRL_SRRL5_MASK                 32U
#define SRRL_SRRL6_MASK                 64U
#define SRRL_SRRL7_MASK                 128U


/*** PTU - Port U Data Register; 0x00000238 ***/
typedef union {
  byte Byte;
  struct {
    byte PTU0        :1;                                       /* Port U general purpose input/output data bit 0 */
    byte PTU1        :1;                                       /* Port U general purpose input/output data bit 1 */
    byte PTU2        :1;                                       /* Port U general purpose input/output data bit 2 */
    byte PTU3        :1;                                       /* Port U general purpose input/output data bit 3 */
    byte PTU4        :1;                                       /* Port U general purpose input/output data bit 4 */
    byte PTU5        :1;                                       /* Port U general purpose input/output data bit 5 */
    byte PTU6        :1;                                       /* Port U general purpose input/output data bit 6 */
    byte PTU7        :1;                                       /* Port U general purpose input/output data bit 7 */
  } Bits;
} PTUSTR;
extern volatile PTUSTR _PTU @(REG_BASE + 0x00000238UL);
#define PTU                             _PTU.Byte
#define PTU_PTU0                        _PTU.Bits.PTU0
#define PTU_PTU1                        _PTU.Bits.PTU1
#define PTU_PTU2                        _PTU.Bits.PTU2
#define PTU_PTU3                        _PTU.Bits.PTU3
#define PTU_PTU4                        _PTU.Bits.PTU4
#define PTU_PTU5                        _PTU.Bits.PTU5
#define PTU_PTU6                        _PTU.Bits.PTU6
#define PTU_PTU7                        _PTU.Bits.PTU7

#define PTU_PTU0_MASK                   1U
#define PTU_PTU1_MASK                   2U
#define PTU_PTU2_MASK                   4U
#define PTU_PTU3_MASK                   8U
#define PTU_PTU4_MASK                   16U
#define PTU_PTU5_MASK                   32U
#define PTU_PTU6_MASK                   64U
#define PTU_PTU7_MASK                   128U


/*** PTIU - Port U Input Register; 0x00000239 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIU0       :1;                                       /* Port U input data bit 0 */
    byte PTIU1       :1;                                       /* Port U input data bit 1 */
    byte PTIU2       :1;                                       /* Port U input data bit 2 */
    byte PTIU3       :1;                                       /* Port U input data bit 3 */
    byte PTIU4       :1;                                       /* Port U input data bit 4 */
    byte PTIU5       :1;                                       /* Port U input data bit 5 */
    byte PTIU6       :1;                                       /* Port U input data bit 6 */
    byte PTIU7       :1;                                       /* Port U input data bit 7 */
  } Bits;
} PTIUSTR;
extern volatile PTIUSTR _PTIU @(REG_BASE + 0x00000239UL);
#define PTIU                            _PTIU.Byte
#define PTIU_PTIU0                      _PTIU.Bits.PTIU0
#define PTIU_PTIU1                      _PTIU.Bits.PTIU1
#define PTIU_PTIU2                      _PTIU.Bits.PTIU2
#define PTIU_PTIU3                      _PTIU.Bits.PTIU3
#define PTIU_PTIU4                      _PTIU.Bits.PTIU4
#define PTIU_PTIU5                      _PTIU.Bits.PTIU5
#define PTIU_PTIU6                      _PTIU.Bits.PTIU6
#define PTIU_PTIU7                      _PTIU.Bits.PTIU7

#define PTIU_PTIU0_MASK                 1U
#define PTIU_PTIU1_MASK                 2U
#define PTIU_PTIU2_MASK                 4U
#define PTIU_PTIU3_MASK                 8U
#define PTIU_PTIU4_MASK                 16U
#define PTIU_PTIU5_MASK                 32U
#define PTIU_PTIU6_MASK                 64U
#define PTIU_PTIU7_MASK                 128U


/*** DDRU - Port U Data Direction Register; 0x0000023A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRU0       :1;                                       /* Port U data direction bit 0 */
    byte DDRU1       :1;                                       /* Port U data direction bit 1 */
    byte DDRU2       :1;                                       /* Port U data direction bit 2 */
    byte DDRU3       :1;                                       /* Port U data direction bit 3 */
    byte DDRU4       :1;                                       /* Port U data direction bit 4 */
    byte DDRU5       :1;                                       /* Port U data direction bit 5 */
    byte DDRU6       :1;                                       /* Port U data direction bit 6 */
    byte DDRU7       :1;                                       /* Port U data direction bit 7 */
  } Bits;
} DDRUSTR;
extern volatile DDRUSTR _DDRU @(REG_BASE + 0x0000023AUL);
#define DDRU                            _DDRU.Byte
#define DDRU_DDRU0                      _DDRU.Bits.DDRU0
#define DDRU_DDRU1                      _DDRU.Bits.DDRU1
#define DDRU_DDRU2                      _DDRU.Bits.DDRU2
#define DDRU_DDRU3                      _DDRU.Bits.DDRU3
#define DDRU_DDRU4                      _DDRU.Bits.DDRU4
#define DDRU_DDRU5                      _DDRU.Bits.DDRU5
#define DDRU_DDRU6                      _DDRU.Bits.DDRU6
#define DDRU_DDRU7                      _DDRU.Bits.DDRU7

#define DDRU_DDRU0_MASK                 1U
#define DDRU_DDRU1_MASK                 2U
#define DDRU_DDRU2_MASK                 4U
#define DDRU_DDRU3_MASK                 8U
#define DDRU_DDRU4_MASK                 16U
#define DDRU_DDRU5_MASK                 32U
#define DDRU_DDRU6_MASK                 64U
#define DDRU_DDRU7_MASK                 128U


/*** SRRU - Port U Slew Rate Register; 0x0000023B ***/
typedef union {
  byte Byte;
  struct {
    byte SRRU0       :1;                                       /* Slew rate port U bit 0 */
    byte SRRU1       :1;                                       /* Slew rate port U bit 1 */
    byte SRRU2       :1;                                       /* Slew rate port U bit 2 */
    byte SRRU3       :1;                                       /* Slew rate port U bit 3 */
    byte SRRU4       :1;                                       /* Slew rate port U bit 4 */
    byte SRRU5       :1;                                       /* Slew rate port U bit 5 */
    byte SRRU6       :1;                                       /* Slew rate port U bit 6 */
    byte SRRU7       :1;                                       /* Slew rate port U bit 7 */
  } Bits;
} SRRUSTR;
extern volatile SRRUSTR _SRRU @(REG_BASE + 0x0000023BUL);
#define SRRU                            _SRRU.Byte
#define SRRU_SRRU0                      _SRRU.Bits.SRRU0
#define SRRU_SRRU1                      _SRRU.Bits.SRRU1
#define SRRU_SRRU2                      _SRRU.Bits.SRRU2
#define SRRU_SRRU3                      _SRRU.Bits.SRRU3
#define SRRU_SRRU4                      _SRRU.Bits.SRRU4
#define SRRU_SRRU5                      _SRRU.Bits.SRRU5
#define SRRU_SRRU6                      _SRRU.Bits.SRRU6
#define SRRU_SRRU7                      _SRRU.Bits.SRRU7

#define SRRU_SRRU0_MASK                 1U
#define SRRU_SRRU1_MASK                 2U
#define SRRU_SRRU2_MASK                 4U
#define SRRU_SRRU3_MASK                 8U
#define SRRU_SRRU4_MASK                 16U
#define SRRU_SRRU5_MASK                 32U
#define SRRU_SRRU6_MASK                 64U
#define SRRU_SRRU7_MASK                 128U


/*** PERU - Port U Pull Device Enable Register; 0x0000023C ***/
typedef union {
  byte Byte;
  struct {
    byte PERU0       :1;                                       /* Port U pull device enable bit 0 */
    byte PERU1       :1;                                       /* Port U pull device enable bit 1 */
    byte PERU2       :1;                                       /* Port U pull device enable bit 2 */
    byte PERU3       :1;                                       /* Port U pull device enable bit 3 */
    byte PERU4       :1;                                       /* Port U pull device enable bit 4 */
    byte PERU5       :1;                                       /* Port U pull device enable bit 5 */
    byte PERU6       :1;                                       /* Port U pull device enable bit 6 */
    byte PERU7       :1;                                       /* Port U pull device enable bit 7 */
  } Bits;
} PERUSTR;
extern volatile PERUSTR _PERU @(REG_BASE + 0x0000023CUL);
#define PERU                            _PERU.Byte
#define PERU_PERU0                      _PERU.Bits.PERU0
#define PERU_PERU1                      _PERU.Bits.PERU1
#define PERU_PERU2                      _PERU.Bits.PERU2
#define PERU_PERU3                      _PERU.Bits.PERU3
#define PERU_PERU4                      _PERU.Bits.PERU4
#define PERU_PERU5                      _PERU.Bits.PERU5
#define PERU_PERU6                      _PERU.Bits.PERU6
#define PERU_PERU7                      _PERU.Bits.PERU7

#define PERU_PERU0_MASK                 1U
#define PERU_PERU1_MASK                 2U
#define PERU_PERU2_MASK                 4U
#define PERU_PERU3_MASK                 8U
#define PERU_PERU4_MASK                 16U
#define PERU_PERU5_MASK                 32U
#define PERU_PERU6_MASK                 64U
#define PERU_PERU7_MASK                 128U


/*** PPSU - Port U Polarity Select Register; 0x0000023D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSU0       :1;                                       /* Port U pull device select bit 0 */
    byte PPSU1       :1;                                       /* Port U pull device select bit 1 */
    byte PPSU2       :1;                                       /* Port U pull device select bit 2 */
    byte PPSU3       :1;                                       /* Port U pull device select bit 3 */
    byte PPSU4       :1;                                       /* Port U pull device select bit 4 */
    byte PPSU5       :1;                                       /* Port U pull device select bit 5 */
    byte PPSU6       :1;                                       /* Port U pull device select bit 6 */
    byte PPSU7       :1;                                       /* Port U pull device select bit 7 */
  } Bits;
} PPSUSTR;
extern volatile PPSUSTR _PPSU @(REG_BASE + 0x0000023DUL);
#define PPSU                            _PPSU.Byte
#define PPSU_PPSU0                      _PPSU.Bits.PPSU0
#define PPSU_PPSU1                      _PPSU.Bits.PPSU1
#define PPSU_PPSU2                      _PPSU.Bits.PPSU2
#define PPSU_PPSU3                      _PPSU.Bits.PPSU3
#define PPSU_PPSU4                      _PPSU.Bits.PPSU4
#define PPSU_PPSU5                      _PPSU.Bits.PPSU5
#define PPSU_PPSU6                      _PPSU.Bits.PPSU6
#define PPSU_PPSU7                      _PPSU.Bits.PPSU7

#define PPSU_PPSU0_MASK                 1U
#define PPSU_PPSU1_MASK                 2U
#define PPSU_PPSU2_MASK                 4U
#define PPSU_PPSU3_MASK                 8U
#define PPSU_PPSU4_MASK                 16U
#define PPSU_PPSU5_MASK                 32U
#define PPSU_PPSU6_MASK                 64U
#define PPSU_PPSU7_MASK                 128U


/*** PTV - Port V Data Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTV0        :1;                                       /* Port V general purpose input/output data bit 0 */
    byte PTV1        :1;                                       /* Port V general purpose input/output data bit 1 */
    byte PTV2        :1;                                       /* Port V general purpose input/output data bit 2 */
    byte PTV3        :1;                                       /* Port V general purpose input/output data bit 3 */
    byte PTV4        :1;                                       /* Port V general purpose input/output data bit 4 */
    byte PTV5        :1;                                       /* Port V general purpose input/output data bit 5 */
    byte PTV6        :1;                                       /* Port V general purpose input/output data bit 6 */
    byte PTV7        :1;                                       /* Port V general purpose input/output data bit 7 */
  } Bits;
} PTVSTR;
extern volatile PTVSTR _PTV @(REG_BASE + 0x00000240UL);
#define PTV                             _PTV.Byte
#define PTV_PTV0                        _PTV.Bits.PTV0
#define PTV_PTV1                        _PTV.Bits.PTV1
#define PTV_PTV2                        _PTV.Bits.PTV2
#define PTV_PTV3                        _PTV.Bits.PTV3
#define PTV_PTV4                        _PTV.Bits.PTV4
#define PTV_PTV5                        _PTV.Bits.PTV5
#define PTV_PTV6                        _PTV.Bits.PTV6
#define PTV_PTV7                        _PTV.Bits.PTV7

#define PTV_PTV0_MASK                   1U
#define PTV_PTV1_MASK                   2U
#define PTV_PTV2_MASK                   4U
#define PTV_PTV3_MASK                   8U
#define PTV_PTV4_MASK                   16U
#define PTV_PTV5_MASK                   32U
#define PTV_PTV6_MASK                   64U
#define PTV_PTV7_MASK                   128U


/*** PTIV - Port V Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIV0       :1;                                       /* Port V input data bit 0 */
    byte PTIV1       :1;                                       /* Port V input data bit 1 */
    byte PTIV2       :1;                                       /* Port V input data bit 2 */
    byte PTIV3       :1;                                       /* Port V input data bit 3 */
    byte PTIV4       :1;                                       /* Port V input data bit 4 */
    byte PTIV5       :1;                                       /* Port V input data bit 5 */
    byte PTIV6       :1;                                       /* Port V input data bit 6 */
    byte PTIV7       :1;                                       /* Port V input data bit 7 */
  } Bits;
} PTIVSTR;
extern volatile PTIVSTR _PTIV @(REG_BASE + 0x00000241UL);
#define PTIV                            _PTIV.Byte
#define PTIV_PTIV0                      _PTIV.Bits.PTIV0
#define PTIV_PTIV1                      _PTIV.Bits.PTIV1
#define PTIV_PTIV2                      _PTIV.Bits.PTIV2
#define PTIV_PTIV3                      _PTIV.Bits.PTIV3
#define PTIV_PTIV4                      _PTIV.Bits.PTIV4
#define PTIV_PTIV5                      _PTIV.Bits.PTIV5
#define PTIV_PTIV6                      _PTIV.Bits.PTIV6
#define PTIV_PTIV7                      _PTIV.Bits.PTIV7

#define PTIV_PTIV0_MASK                 1U
#define PTIV_PTIV1_MASK                 2U
#define PTIV_PTIV2_MASK                 4U
#define PTIV_PTIV3_MASK                 8U
#define PTIV_PTIV4_MASK                 16U
#define PTIV_PTIV5_MASK                 32U
#define PTIV_PTIV6_MASK                 64U
#define PTIV_PTIV7_MASK                 128U


/*** DDRV - Port V Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRV0       :1;                                       /* Port V data direction bit 0 */
    byte DDRV1       :1;                                       /* Port V data direction bit 1 */
    byte DDRV2       :1;                                       /* Port V data direction bit 2 */
    byte DDRV3       :1;                                       /* Port V data direction bit 3 */
    byte DDRV4       :1;                                       /* Port V data direction bit 4 */
    byte DDRV5       :1;                                       /* Port V data direction bit 5 */
    byte DDRV6       :1;                                       /* Port V data direction bit 6 */
    byte DDRV7       :1;                                       /* Port V data direction bit 7 */
  } Bits;
} DDRVSTR;
extern volatile DDRVSTR _DDRV @(REG_BASE + 0x00000242UL);
#define DDRV                            _DDRV.Byte
#define DDRV_DDRV0                      _DDRV.Bits.DDRV0
#define DDRV_DDRV1                      _DDRV.Bits.DDRV1
#define DDRV_DDRV2                      _DDRV.Bits.DDRV2
#define DDRV_DDRV3                      _DDRV.Bits.DDRV3
#define DDRV_DDRV4                      _DDRV.Bits.DDRV4
#define DDRV_DDRV5                      _DDRV.Bits.DDRV5
#define DDRV_DDRV6                      _DDRV.Bits.DDRV6
#define DDRV_DDRV7                      _DDRV.Bits.DDRV7

#define DDRV_DDRV0_MASK                 1U
#define DDRV_DDRV1_MASK                 2U
#define DDRV_DDRV2_MASK                 4U
#define DDRV_DDRV3_MASK                 8U
#define DDRV_DDRV4_MASK                 16U
#define DDRV_DDRV5_MASK                 32U
#define DDRV_DDRV6_MASK                 64U
#define DDRV_DDRV7_MASK                 128U


/*** SRRV - Port V Slew Rate Register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte SRRV0       :1;                                       /* Slew rate port V bit 0 */
    byte SRRV1       :1;                                       /* Slew rate port V bit 1 */
    byte SRRV2       :1;                                       /* Slew rate port V bit 2 */
    byte SRRV3       :1;                                       /* Slew rate port V bit 3 */
    byte SRRV4       :1;                                       /* Slew rate port V bit 4 */
    byte SRRV5       :1;                                       /* Slew rate port V bit 5 */
    byte SRRV6       :1;                                       /* Slew rate port V bit 6 */
    byte SRRV7       :1;                                       /* Slew rate port V bit 7 */
  } Bits;
} SRRVSTR;
extern volatile SRRVSTR _SRRV @(REG_BASE + 0x00000243UL);
#define SRRV                            _SRRV.Byte
#define SRRV_SRRV0                      _SRRV.Bits.SRRV0
#define SRRV_SRRV1                      _SRRV.Bits.SRRV1
#define SRRV_SRRV2                      _SRRV.Bits.SRRV2
#define SRRV_SRRV3                      _SRRV.Bits.SRRV3
#define SRRV_SRRV4                      _SRRV.Bits.SRRV4
#define SRRV_SRRV5                      _SRRV.Bits.SRRV5
#define SRRV_SRRV6                      _SRRV.Bits.SRRV6
#define SRRV_SRRV7                      _SRRV.Bits.SRRV7

#define SRRV_SRRV0_MASK                 1U
#define SRRV_SRRV1_MASK                 2U
#define SRRV_SRRV2_MASK                 4U
#define SRRV_SRRV3_MASK                 8U
#define SRRV_SRRV4_MASK                 16U
#define SRRV_SRRV5_MASK                 32U
#define SRRV_SRRV6_MASK                 64U
#define SRRV_SRRV7_MASK                 128U


/*** PERV - Port V Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERV0       :1;                                       /* Port V pull device enable bit 0 */
    byte PERV1       :1;                                       /* Port V pull device enable bit 1 */
    byte PERV2       :1;                                       /* Port V pull device enable bit 2 */
    byte PERV3       :1;                                       /* Port V pull device enable bit 3 */
    byte PERV4       :1;                                       /* Port V pull device enable bit 4 */
    byte PERV5       :1;                                       /* Port V pull device enable bit 5 */
    byte PERV6       :1;                                       /* Port V pull device enable bit 6 */
    byte PERV7       :1;                                       /* Port V pull device enable bit 7 */
  } Bits;
} PERVSTR;
extern volatile PERVSTR _PERV @(REG_BASE + 0x00000244UL);
#define PERV                            _PERV.Byte
#define PERV_PERV0                      _PERV.Bits.PERV0
#define PERV_PERV1                      _PERV.Bits.PERV1
#define PERV_PERV2                      _PERV.Bits.PERV2
#define PERV_PERV3                      _PERV.Bits.PERV3
#define PERV_PERV4                      _PERV.Bits.PERV4
#define PERV_PERV5                      _PERV.Bits.PERV5
#define PERV_PERV6                      _PERV.Bits.PERV6
#define PERV_PERV7                      _PERV.Bits.PERV7

#define PERV_PERV0_MASK                 1U
#define PERV_PERV1_MASK                 2U
#define PERV_PERV2_MASK                 4U
#define PERV_PERV3_MASK                 8U
#define PERV_PERV4_MASK                 16U
#define PERV_PERV5_MASK                 32U
#define PERV_PERV6_MASK                 64U
#define PERV_PERV7_MASK                 128U


/*** PPSV - Port V Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSV0       :1;                                       /* Port V pull device select bit 0 */
    byte PPSV1       :1;                                       /* Port V pull device select bit 1 */
    byte PPSV2       :1;                                       /* Port V pull device select bit 2 */
    byte PPSV3       :1;                                       /* Port V pull device select bit 3 */
    byte PPSV4       :1;                                       /* Port V pull device select bit 4 */
    byte PPSV5       :1;                                       /* Port V pull device select bit 5 */
    byte PPSV6       :1;                                       /* Port V pull device select bit 6 */
    byte PPSV7       :1;                                       /* Port V pull device select bit 7 */
  } Bits;
} PPSVSTR;
extern volatile PPSVSTR _PPSV @(REG_BASE + 0x00000245UL);
#define PPSV                            _PPSV.Byte
#define PPSV_PPSV0                      _PPSV.Bits.PPSV0
#define PPSV_PPSV1                      _PPSV.Bits.PPSV1
#define PPSV_PPSV2                      _PPSV.Bits.PPSV2
#define PPSV_PPSV3                      _PPSV.Bits.PPSV3
#define PPSV_PPSV4                      _PPSV.Bits.PPSV4
#define PPSV_PPSV5                      _PPSV.Bits.PPSV5
#define PPSV_PPSV6                      _PPSV.Bits.PPSV6
#define PPSV_PPSV7                      _PPSV.Bits.PPSV7

#define PPSV_PPSV0_MASK                 1U
#define PPSV_PPSV1_MASK                 2U
#define PPSV_PPSV2_MASK                 4U
#define PPSV_PPSV3_MASK                 8U
#define PPSV_PPSV4_MASK                 16U
#define PPSV_PPSV5_MASK                 32U
#define PPSV_PPSV6_MASK                 64U
#define PPSV_PPSV7_MASK                 128U


/*** PTW - Port W Data Register; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte PTW0        :1;                                       /* Port W general purpose input/output data bit 0 */
    byte PTW1        :1;                                       /* Port W general purpose input/output data bit 1 */
    byte PTW2        :1;                                       /* Port W general purpose input/output data bit 2 */
    byte PTW3        :1;                                       /* Port W general purpose input/output data bit 3 */
    byte PTW4        :1;                                       /* Port W general purpose input/output data bit 4 */
    byte PTW5        :1;                                       /* Port W general purpose input/output data bit 5 */
    byte PTW6        :1;                                       /* Port W general purpose input/output data bit 6 */
    byte PTW7        :1;                                       /* Port W general purpose input/output data bit 7 */
  } Bits;
} PTWSTR;
extern volatile PTWSTR _PTW @(REG_BASE + 0x00000248UL);
#define PTW                             _PTW.Byte
#define PTW_PTW0                        _PTW.Bits.PTW0
#define PTW_PTW1                        _PTW.Bits.PTW1
#define PTW_PTW2                        _PTW.Bits.PTW2
#define PTW_PTW3                        _PTW.Bits.PTW3
#define PTW_PTW4                        _PTW.Bits.PTW4
#define PTW_PTW5                        _PTW.Bits.PTW5
#define PTW_PTW6                        _PTW.Bits.PTW6
#define PTW_PTW7                        _PTW.Bits.PTW7

#define PTW_PTW0_MASK                   1U
#define PTW_PTW1_MASK                   2U
#define PTW_PTW2_MASK                   4U
#define PTW_PTW3_MASK                   8U
#define PTW_PTW4_MASK                   16U
#define PTW_PTW5_MASK                   32U
#define PTW_PTW6_MASK                   64U
#define PTW_PTW7_MASK                   128U


/*** PTIW - Port W Input Register; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIW0       :1;                                       /* Port W input data bit 0 */
    byte PTIW1       :1;                                       /* Port W input data bit 1 */
    byte PTIW2       :1;                                       /* Port W input data bit 2 */
    byte PTIW3       :1;                                       /* Port W input data bit 3 */
    byte PTIW4       :1;                                       /* Port W input data bit 4 */
    byte PTIW5       :1;                                       /* Port W input data bit 5 */
    byte PTIW6       :1;                                       /* Port W input data bit 6 */
    byte PTIW7       :1;                                       /* Port W input data bit 7 */
  } Bits;
} PTIWSTR;
extern volatile PTIWSTR _PTIW @(REG_BASE + 0x00000249UL);
#define PTIW                            _PTIW.Byte
#define PTIW_PTIW0                      _PTIW.Bits.PTIW0
#define PTIW_PTIW1                      _PTIW.Bits.PTIW1
#define PTIW_PTIW2                      _PTIW.Bits.PTIW2
#define PTIW_PTIW3                      _PTIW.Bits.PTIW3
#define PTIW_PTIW4                      _PTIW.Bits.PTIW4
#define PTIW_PTIW5                      _PTIW.Bits.PTIW5
#define PTIW_PTIW6                      _PTIW.Bits.PTIW6
#define PTIW_PTIW7                      _PTIW.Bits.PTIW7

#define PTIW_PTIW0_MASK                 1U
#define PTIW_PTIW1_MASK                 2U
#define PTIW_PTIW2_MASK                 4U
#define PTIW_PTIW3_MASK                 8U
#define PTIW_PTIW4_MASK                 16U
#define PTIW_PTIW5_MASK                 32U
#define PTIW_PTIW6_MASK                 64U
#define PTIW_PTIW7_MASK                 128U


/*** DDRW - Port W Data Direction Register; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRW0       :1;                                       /* Port W data direction bit 0 */
    byte DDRW1       :1;                                       /* Port W data direction bit 1 */
    byte DDRW2       :1;                                       /* Port W data direction bit 2 */
    byte DDRW3       :1;                                       /* Port W data direction bit 3 */
    byte DDRW4       :1;                                       /* Port W data direction bit 4 */
    byte DDRW5       :1;                                       /* Port W data direction bit 5 */
    byte DDRW6       :1;                                       /* Port W data direction bit 6 */
    byte DDRW7       :1;                                       /* Port W data direction bit 7 */
  } Bits;
} DDRWSTR;
extern volatile DDRWSTR _DDRW @(REG_BASE + 0x0000024AUL);
#define DDRW                            _DDRW.Byte
#define DDRW_DDRW0                      _DDRW.Bits.DDRW0
#define DDRW_DDRW1                      _DDRW.Bits.DDRW1
#define DDRW_DDRW2                      _DDRW.Bits.DDRW2
#define DDRW_DDRW3                      _DDRW.Bits.DDRW3
#define DDRW_DDRW4                      _DDRW.Bits.DDRW4
#define DDRW_DDRW5                      _DDRW.Bits.DDRW5
#define DDRW_DDRW6                      _DDRW.Bits.DDRW6
#define DDRW_DDRW7                      _DDRW.Bits.DDRW7

#define DDRW_DDRW0_MASK                 1U
#define DDRW_DDRW1_MASK                 2U
#define DDRW_DDRW2_MASK                 4U
#define DDRW_DDRW3_MASK                 8U
#define DDRW_DDRW4_MASK                 16U
#define DDRW_DDRW5_MASK                 32U
#define DDRW_DDRW6_MASK                 64U
#define DDRW_DDRW7_MASK                 128U


/*** SRRW - Port W Slew Rate Register; 0x0000024B ***/
typedef union {
  byte Byte;
  struct {
    byte SRRW0       :1;                                       /* Slew rate port W bit 0 */
    byte SRRW1       :1;                                       /* Slew rate port W bit 1 */
    byte SRRW2       :1;                                       /* Slew rate port W bit 2 */
    byte SRRW3       :1;                                       /* Slew rate port W bit 3 */
    byte SRRW4       :1;                                       /* Slew rate port W bit 4 */
    byte SRRW5       :1;                                       /* Slew rate port W bit 5 */
    byte SRRW6       :1;                                       /* Slew rate port W bit 6 */
    byte SRRW7       :1;                                       /* Slew rate port W bit 7 */
  } Bits;
} SRRWSTR;
extern volatile SRRWSTR _SRRW @(REG_BASE + 0x0000024BUL);
#define SRRW                            _SRRW.Byte
#define SRRW_SRRW0                      _SRRW.Bits.SRRW0
#define SRRW_SRRW1                      _SRRW.Bits.SRRW1
#define SRRW_SRRW2                      _SRRW.Bits.SRRW2
#define SRRW_SRRW3                      _SRRW.Bits.SRRW3
#define SRRW_SRRW4                      _SRRW.Bits.SRRW4
#define SRRW_SRRW5                      _SRRW.Bits.SRRW5
#define SRRW_SRRW6                      _SRRW.Bits.SRRW6
#define SRRW_SRRW7                      _SRRW.Bits.SRRW7

#define SRRW_SRRW0_MASK                 1U
#define SRRW_SRRW1_MASK                 2U
#define SRRW_SRRW2_MASK                 4U
#define SRRW_SRRW3_MASK                 8U
#define SRRW_SRRW4_MASK                 16U
#define SRRW_SRRW5_MASK                 32U
#define SRRW_SRRW6_MASK                 64U
#define SRRW_SRRW7_MASK                 128U


/*** PERW - Port W Pull Device Enable Register; 0x0000024C ***/
typedef union {
  byte Byte;
  struct {
    byte PERW0       :1;                                       /* Port W pull device enable bit 0 */
    byte PERW1       :1;                                       /* Port W pull device enable bit 1 */
    byte PERW2       :1;                                       /* Port W pull device enable bit 2 */
    byte PERW3       :1;                                       /* Port W pull device enable bit 3 */
    byte PERW4       :1;                                       /* Port W pull device enable bit 4 */
    byte PERW5       :1;                                       /* Port W pull device enable bit 5 */
    byte PERW6       :1;                                       /* Port W pull device enable bit 6 */
    byte PERW7       :1;                                       /* Port W pull device enable bit 7 */
  } Bits;
} PERWSTR;
extern volatile PERWSTR _PERW @(REG_BASE + 0x0000024CUL);
#define PERW                            _PERW.Byte
#define PERW_PERW0                      _PERW.Bits.PERW0
#define PERW_PERW1                      _PERW.Bits.PERW1
#define PERW_PERW2                      _PERW.Bits.PERW2
#define PERW_PERW3                      _PERW.Bits.PERW3
#define PERW_PERW4                      _PERW.Bits.PERW4
#define PERW_PERW5                      _PERW.Bits.PERW5
#define PERW_PERW6                      _PERW.Bits.PERW6
#define PERW_PERW7                      _PERW.Bits.PERW7

#define PERW_PERW0_MASK                 1U
#define PERW_PERW1_MASK                 2U
#define PERW_PERW2_MASK                 4U
#define PERW_PERW3_MASK                 8U
#define PERW_PERW4_MASK                 16U
#define PERW_PERW5_MASK                 32U
#define PERW_PERW6_MASK                 64U
#define PERW_PERW7_MASK                 128U


/*** PPSW - Port W Polarity Select Register; 0x0000024D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSW0       :1;                                       /* Port W pull device select bit 0 */
    byte PPSW1       :1;                                       /* Port W pull device select bit 1 */
    byte PPSW2       :1;                                       /* Port W pull device select bit 2 */
    byte PPSW3       :1;                                       /* Port W pull device select bit 3 */
    byte PPSW4       :1;                                       /* Port W pull device select bit 4 */
    byte PPSW5       :1;                                       /* Port W pull device select bit 5 */
    byte PPSW6       :1;                                       /* Port W pull device select bit 6 */
    byte PPSW7       :1;                                       /* Port W pull device select bit 7 */
  } Bits;
} PPSWSTR;
extern volatile PPSWSTR _PPSW @(REG_BASE + 0x0000024DUL);
#define PPSW                            _PPSW.Byte
#define PPSW_PPSW0                      _PPSW.Bits.PPSW0
#define PPSW_PPSW1                      _PPSW.Bits.PPSW1
#define PPSW_PPSW2                      _PPSW.Bits.PPSW2
#define PPSW_PPSW3                      _PPSW.Bits.PPSW3
#define PPSW_PPSW4                      _PPSW.Bits.PPSW4
#define PPSW_PPSW5                      _PPSW.Bits.PPSW5
#define PPSW_PPSW6                      _PPSW.Bits.PPSW6
#define PPSW_PPSW7                      _PPSW.Bits.PPSW7

#define PPSW_PPSW0_MASK                 1U
#define PPSW_PPSW1_MASK                 2U
#define PPSW_PPSW2_MASK                 4U
#define PPSW_PPSW3_MASK                 8U
#define PPSW_PPSW4_MASK                 16U
#define PPSW_PPSW5_MASK                 32U
#define PPSW_PPSW6_MASK                 64U
#define PPSW_PPSW7_MASK                 128U


/*** PTAD - Port AD Data Register; 0x00000251 ***/
typedef union {
  byte Byte;
  struct {
    byte PTAD0       :1;                                       /* Port AD data bit 0 */
    byte PTAD1       :1;                                       /* Port AD data bit 1 */
    byte PTAD2       :1;                                       /* Port AD data bit 2 */
    byte PTAD3       :1;                                       /* Port AD data bit 3 */
    byte PTAD4       :1;                                       /* Port AD data bit 4 */
    byte PTAD5       :1;                                       /* Port AD data bit 5 */
    byte PTAD6       :1;                                       /* Port AD data bit 6 */
    byte PTAD7       :1;                                       /* Port AD data bit 7 */
  } Bits;
} PTADSTR;
extern volatile PTADSTR _PTAD @(REG_BASE + 0x00000251UL);
#define PTAD                            _PTAD.Byte
#define PTAD_PTAD0                      _PTAD.Bits.PTAD0
#define PTAD_PTAD1                      _PTAD.Bits.PTAD1
#define PTAD_PTAD2                      _PTAD.Bits.PTAD2
#define PTAD_PTAD3                      _PTAD.Bits.PTAD3
#define PTAD_PTAD4                      _PTAD.Bits.PTAD4
#define PTAD_PTAD5                      _PTAD.Bits.PTAD5
#define PTAD_PTAD6                      _PTAD.Bits.PTAD6
#define PTAD_PTAD7                      _PTAD.Bits.PTAD7

#define PTAD_PTAD0_MASK                 1U
#define PTAD_PTAD1_MASK                 2U
#define PTAD_PTAD2_MASK                 4U
#define PTAD_PTAD3_MASK                 8U
#define PTAD_PTAD4_MASK                 16U
#define PTAD_PTAD5_MASK                 32U
#define PTAD_PTAD6_MASK                 64U
#define PTAD_PTAD7_MASK                 128U


/*** PTIAD - Port AD Input Register; 0x00000253 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIAD0      :1;                                       /* Port AD Bit 0 */
    byte PTIAD1      :1;                                       /* Port AD Bit 1 */
    byte PTIAD2      :1;                                       /* Port AD Bit 2 */
    byte PTIAD3      :1;                                       /* Port AD Bit 3 */
    byte PTIAD4      :1;                                       /* Port AD Bit 4 */
    byte PTIAD5      :1;                                       /* Port AD Bit 5 */
    byte PTIAD6      :1;                                       /* Port AD Bit 6 */
    byte PTIAD7      :1;                                       /* Port AD Bit 7 */
  } Bits;
} PTIADSTR;
extern volatile PTIADSTR _PTIAD @(REG_BASE + 0x00000253UL);
#define PTIAD                           _PTIAD.Byte
#define PTIAD_PTIAD0                    _PTIAD.Bits.PTIAD0
#define PTIAD_PTIAD1                    _PTIAD.Bits.PTIAD1
#define PTIAD_PTIAD2                    _PTIAD.Bits.PTIAD2
#define PTIAD_PTIAD3                    _PTIAD.Bits.PTIAD3
#define PTIAD_PTIAD4                    _PTIAD.Bits.PTIAD4
#define PTIAD_PTIAD5                    _PTIAD.Bits.PTIAD5
#define PTIAD_PTIAD6                    _PTIAD.Bits.PTIAD6
#define PTIAD_PTIAD7                    _PTIAD.Bits.PTIAD7

#define PTIAD_PTIAD0_MASK               1U
#define PTIAD_PTIAD1_MASK               2U
#define PTIAD_PTIAD2_MASK               4U
#define PTIAD_PTIAD3_MASK               8U
#define PTIAD_PTIAD4_MASK               16U
#define PTIAD_PTIAD5_MASK               32U
#define PTIAD_PTIAD6_MASK               64U
#define PTIAD_PTIAD7_MASK               128U


/*** DDRAD - Port AD Data Direction Register; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRAD0      :1;                                       /* Port AD data direction bit 0 */
    byte DDRAD1      :1;                                       /* Port AD data direction bit 1 */
    byte DDRAD2      :1;                                       /* Port AD data direction bit 2 */
    byte DDRAD3      :1;                                       /* Port AD data direction bit 3 */
    byte DDRAD4      :1;                                       /* Port AD data direction bit 4 */
    byte DDRAD5      :1;                                       /* Port AD data direction bit 5 */
    byte DDRAD6      :1;                                       /* Port AD data direction bit 6 */
    byte DDRAD7      :1;                                       /* Port AD data direction bit 7 */
  } Bits;
} DDRADSTR;
extern volatile DDRADSTR _DDRAD @(REG_BASE + 0x00000255UL);
#define DDRAD                           _DDRAD.Byte
#define DDRAD_DDRAD0                    _DDRAD.Bits.DDRAD0
#define DDRAD_DDRAD1                    _DDRAD.Bits.DDRAD1
#define DDRAD_DDRAD2                    _DDRAD.Bits.DDRAD2
#define DDRAD_DDRAD3                    _DDRAD.Bits.DDRAD3
#define DDRAD_DDRAD4                    _DDRAD.Bits.DDRAD4
#define DDRAD_DDRAD5                    _DDRAD.Bits.DDRAD5
#define DDRAD_DDRAD6                    _DDRAD.Bits.DDRAD6
#define DDRAD_DDRAD7                    _DDRAD.Bits.DDRAD7

#define DDRAD_DDRAD0_MASK               1U
#define DDRAD_DDRAD1_MASK               2U
#define DDRAD_DDRAD2_MASK               4U
#define DDRAD_DDRAD3_MASK               8U
#define DDRAD_DDRAD4_MASK               16U
#define DDRAD_DDRAD5_MASK               32U
#define DDRAD_DDRAD6_MASK               64U
#define DDRAD_DDRAD7_MASK               128U


/*** RDRAD - Port AD Reduced Drive Register; 0x00000257 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRAD0      :1;                                       /* Port AD reduced drive bit 0 */
    byte RDRAD1      :1;                                       /* Port AD reduced drive bit 1 */
    byte RDRAD2      :1;                                       /* Port AD reduced drive bit 2 */
    byte RDRAD3      :1;                                       /* Port AD reduced drive bit 3 */
    byte RDRAD4      :1;                                       /* Port AD reduced drive bit 4 */
    byte RDRAD5      :1;                                       /* Port AD reduced drive bit 5 */
    byte RDRAD6      :1;                                       /* Port AD reduced drive bit 6 */
    byte RDRAD7      :1;                                       /* Port AD reduced drive bit 7 */
  } Bits;
} RDRADSTR;
extern volatile RDRADSTR _RDRAD @(REG_BASE + 0x00000257UL);
#define RDRAD                           _RDRAD.Byte
#define RDRAD_RDRAD0                    _RDRAD.Bits.RDRAD0
#define RDRAD_RDRAD1                    _RDRAD.Bits.RDRAD1
#define RDRAD_RDRAD2                    _RDRAD.Bits.RDRAD2
#define RDRAD_RDRAD3                    _RDRAD.Bits.RDRAD3
#define RDRAD_RDRAD4                    _RDRAD.Bits.RDRAD4
#define RDRAD_RDRAD5                    _RDRAD.Bits.RDRAD5
#define RDRAD_RDRAD6                    _RDRAD.Bits.RDRAD6
#define RDRAD_RDRAD7                    _RDRAD.Bits.RDRAD7

#define RDRAD_RDRAD0_MASK               1U
#define RDRAD_RDRAD1_MASK               2U
#define RDRAD_RDRAD2_MASK               4U
#define RDRAD_RDRAD3_MASK               8U
#define RDRAD_RDRAD4_MASK               16U
#define RDRAD_RDRAD5_MASK               32U
#define RDRAD_RDRAD6_MASK               64U
#define RDRAD_RDRAD7_MASK               128U


/*** PERAD - Port AD Pull Up Enable Register; 0x00000259 ***/
typedef union {
  byte Byte;
  struct {
    byte PERAD0      :1;                                       /* Port AD pull up enable bit 0 */
    byte PERAD1      :1;                                       /* Port AD pull up enable bit 1 */
    byte PERAD2      :1;                                       /* Port AD pull up enable bit 2 */
    byte PERAD3      :1;                                       /* Port AD pull up enable bit 3 */
    byte PERAD4      :1;                                       /* Port AD pull up enable bit 4 */
    byte PERAD5      :1;                                       /* Port AD pull up enable bit 5 */
    byte PERAD6      :1;                                       /* Port AD pull up enable bit 6 */
    byte PERAD7      :1;                                       /* Port AD pull up enable bit 7 */
  } Bits;
} PERADSTR;
extern volatile PERADSTR _PERAD @(REG_BASE + 0x00000259UL);
#define PERAD                           _PERAD.Byte
#define PERAD_PERAD0                    _PERAD.Bits.PERAD0
#define PERAD_PERAD1                    _PERAD.Bits.PERAD1
#define PERAD_PERAD2                    _PERAD.Bits.PERAD2
#define PERAD_PERAD3                    _PERAD.Bits.PERAD3
#define PERAD_PERAD4                    _PERAD.Bits.PERAD4
#define PERAD_PERAD5                    _PERAD.Bits.PERAD5
#define PERAD_PERAD6                    _PERAD.Bits.PERAD6
#define PERAD_PERAD7                    _PERAD.Bits.PERAD7

#define PERAD_PERAD0_MASK               1U
#define PERAD_PERAD1_MASK               2U
#define PERAD_PERAD2_MASK               4U
#define PERAD_PERAD3_MASK               8U
#define PERAD_PERAD4_MASK               16U
#define PERAD_PERAD5_MASK               32U
#define PERAD_PERAD6_MASK               64U
#define PERAD_PERAD7_MASK               128U


/*** PPSAD - Port AD Polarity Select Register; 0x0000025B ***/
typedef union {
  byte Byte;
  struct {
    byte PPSAD0      :1;                                       /* Port AD Polarity Select Bit 0 */
    byte PPSAD1      :1;                                       /* Port AD Polarity Select Bit 1 */
    byte PPSAD2      :1;                                       /* Port AD Polarity Select Bit 2 */
    byte PPSAD3      :1;                                       /* Port AD Polarity Select Bit 3 */
    byte PPSAD4      :1;                                       /* Port AD Polarity Select Bit 4 */
    byte PPSAD5      :1;                                       /* Port AD Polarity Select Bit 5 */
    byte PPSAD6      :1;                                       /* Port AD Polarity Select Bit 6 */
    byte PPSAD7      :1;                                       /* Port AD Polarity Select Bit 7 */
  } Bits;
} PPSADSTR;
extern volatile PPSADSTR _PPSAD @(REG_BASE + 0x0000025BUL);
#define PPSAD                           _PPSAD.Byte
#define PPSAD_PPSAD0                    _PPSAD.Bits.PPSAD0
#define PPSAD_PPSAD1                    _PPSAD.Bits.PPSAD1
#define PPSAD_PPSAD2                    _PPSAD.Bits.PPSAD2
#define PPSAD_PPSAD3                    _PPSAD.Bits.PPSAD3
#define PPSAD_PPSAD4                    _PPSAD.Bits.PPSAD4
#define PPSAD_PPSAD5                    _PPSAD.Bits.PPSAD5
#define PPSAD_PPSAD6                    _PPSAD.Bits.PPSAD6
#define PPSAD_PPSAD7                    _PPSAD.Bits.PPSAD7

#define PPSAD_PPSAD0_MASK               1U
#define PPSAD_PPSAD1_MASK               2U
#define PPSAD_PPSAD2_MASK               4U
#define PPSAD_PPSAD3_MASK               8U
#define PPSAD_PPSAD4_MASK               16U
#define PPSAD_PPSAD5_MASK               32U
#define PPSAD_PPSAD6_MASK               64U
#define PPSAD_PPSAD7_MASK               128U


/*** PIEAD - Port AD Interrupt Enable Register; 0x0000025D ***/
typedef union {
  byte Byte;
  struct {
    byte PIEAD0      :1;                                       /* Port AD Interrupt Enable Bit 0 */
    byte PIEAD1      :1;                                       /* Port AD Interrupt Enable Bit 1 */
    byte PIEAD2      :1;                                       /* Port AD Interrupt Enable Bit 2 */
    byte PIEAD3      :1;                                       /* Port AD Interrupt Enable Bit 3 */
    byte PIEAD4      :1;                                       /* Port AD Interrupt Enable Bit 4 */
    byte PIEAD5      :1;                                       /* Port AD Interrupt Enable Bit 5 */
    byte PIEAD6      :1;                                       /* Port AD Interrupt Enable Bit 6 */
    byte PIEAD7      :1;                                       /* Port AD Interrupt Enable Bit 7 */
  } Bits;
} PIEADSTR;
extern volatile PIEADSTR _PIEAD @(REG_BASE + 0x0000025DUL);
#define PIEAD                           _PIEAD.Byte
#define PIEAD_PIEAD0                    _PIEAD.Bits.PIEAD0
#define PIEAD_PIEAD1                    _PIEAD.Bits.PIEAD1
#define PIEAD_PIEAD2                    _PIEAD.Bits.PIEAD2
#define PIEAD_PIEAD3                    _PIEAD.Bits.PIEAD3
#define PIEAD_PIEAD4                    _PIEAD.Bits.PIEAD4
#define PIEAD_PIEAD5                    _PIEAD.Bits.PIEAD5
#define PIEAD_PIEAD6                    _PIEAD.Bits.PIEAD6
#define PIEAD_PIEAD7                    _PIEAD.Bits.PIEAD7

#define PIEAD_PIEAD0_MASK               1U
#define PIEAD_PIEAD1_MASK               2U
#define PIEAD_PIEAD2_MASK               4U
#define PIEAD_PIEAD3_MASK               8U
#define PIEAD_PIEAD4_MASK               16U
#define PIEAD_PIEAD5_MASK               32U
#define PIEAD_PIEAD6_MASK               64U
#define PIEAD_PIEAD7_MASK               128U


/*** PIFAD - Port AD Interrupt Flag Register; 0x0000025F ***/
typedef union {
  byte Byte;
  struct {
    byte PIFAD0      :1;                                       /* Port AD Bit 0 */
    byte PIFAD1      :1;                                       /* Port AD Bit 1 */
    byte PIFAD2      :1;                                       /* Port AD Bit 2 */
    byte PIFAD3      :1;                                       /* Port AD Bit 3 */
    byte PIFAD4      :1;                                       /* Port AD Bit 4 */
    byte PIFAD5      :1;                                       /* Port AD Bit 5 */
    byte PIFAD6      :1;                                       /* Port AD Bit 6 */
    byte PIFAD7      :1;                                       /* Port AD Bit 7 */
  } Bits;
} PIFADSTR;
extern volatile PIFADSTR _PIFAD @(REG_BASE + 0x0000025FUL);
#define PIFAD                           _PIFAD.Byte
#define PIFAD_PIFAD0                    _PIFAD.Bits.PIFAD0
#define PIFAD_PIFAD1                    _PIFAD.Bits.PIFAD1
#define PIFAD_PIFAD2                    _PIFAD.Bits.PIFAD2
#define PIFAD_PIFAD3                    _PIFAD.Bits.PIFAD3
#define PIFAD_PIFAD4                    _PIFAD.Bits.PIFAD4
#define PIFAD_PIFAD5                    _PIFAD.Bits.PIFAD5
#define PIFAD_PIFAD6                    _PIFAD.Bits.PIFAD6
#define PIFAD_PIFAD7                    _PIFAD.Bits.PIFAD7

#define PIFAD_PIFAD0_MASK               1U
#define PIFAD_PIFAD1_MASK               2U
#define PIFAD_PIFAD2_MASK               4U
#define PIFAD_PIFAD3_MASK               8U
#define PIFAD_PIFAD4_MASK               16U
#define PIFAD_PIFAD5_MASK               32U
#define PIFAD_PIFAD6_MASK               64U
#define PIFAD_PIFAD7_MASK               128U


/*** RTZ4CTL - SSD4 Return-to-Zero Control Register; 0x00000280 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ4CTLSTR;
extern volatile RTZ4CTLSTR _RTZ4CTL @(REG_BASE + 0x00000280UL);
#define RTZ4CTL                         _RTZ4CTL.Byte
#define RTZ4CTL_STEP                    _RTZ4CTL.Bits.STEP
#define RTZ4CTL_SMS                     _RTZ4CTL.Bits.SMS
#define RTZ4CTL_POL                     _RTZ4CTL.Bits.POL
#define RTZ4CTL_RCIR                    _RTZ4CTL.Bits.RCIR
#define RTZ4CTL_DCOIL                   _RTZ4CTL.Bits.DCOIL
#define RTZ4CTL_ITG                     _RTZ4CTL.Bits.ITG

#define RTZ4CTL_STEP_MASK               3U
#define RTZ4CTL_STEP_BITNUM             0U
#define RTZ4CTL_SMS_MASK                4U
#define RTZ4CTL_POL_MASK                16U
#define RTZ4CTL_RCIR_MASK               32U
#define RTZ4CTL_DCOIL_MASK              64U
#define RTZ4CTL_ITG_MASK                128U


/*** MDC4CTL - SSD4 Modulus Down Counter Control Register; 0x00000281 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC4CTLSTR;
extern volatile MDC4CTLSTR _MDC4CTL @(REG_BASE + 0x00000281UL);
#define MDC4CTL                         _MDC4CTL.Byte
#define MDC4CTL_AOVIE                   _MDC4CTL.Bits.AOVIE
#define MDC4CTL_MCEN                    _MDC4CTL.Bits.MCEN
#define MDC4CTL_FLMC                    _MDC4CTL.Bits.FLMC
#define MDC4CTL_PRE                     _MDC4CTL.Bits.PRE
#define MDC4CTL_RDMCL                   _MDC4CTL.Bits.RDMCL
#define MDC4CTL_MODMC                   _MDC4CTL.Bits.MODMC
#define MDC4CTL_MCZIE                   _MDC4CTL.Bits.MCZIE

#define MDC4CTL_AOVIE_MASK              1U
#define MDC4CTL_MCEN_MASK               4U
#define MDC4CTL_FLMC_MASK               8U
#define MDC4CTL_PRE_MASK                16U
#define MDC4CTL_RDMCL_MASK              32U
#define MDC4CTL_MODMC_MASK              64U
#define MDC4CTL_MCZIE_MASK              128U


/*** SSD4CTL - SSD4 Stepper Stall Detector Control Register; 0x00000282 ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD4CTLSTR;
extern volatile SSD4CTLSTR _SSD4CTL @(REG_BASE + 0x00000282UL);
#define SSD4CTL                         _SSD4CTL.Byte
#define SSD4CTL_ACLKS                   _SSD4CTL.Bits.ACLKS
#define SSD4CTL_FTST                    _SSD4CTL.Bits.FTST
#define SSD4CTL_SSDWAI                  _SSD4CTL.Bits.SSDWAI
#define SSD4CTL_SDCPU                   _SSD4CTL.Bits.SDCPU
#define SSD4CTL_RTZE                    _SSD4CTL.Bits.RTZE

#define SSD4CTL_ACLKS_MASK              3U
#define SSD4CTL_ACLKS_BITNUM            0U
#define SSD4CTL_FTST_MASK               16U
#define SSD4CTL_SSDWAI_MASK             32U
#define SSD4CTL_SDCPU_MASK              64U
#define SSD4CTL_RTZE_MASK               128U


/*** SSD4FLG - SSD4 Stepper Stall Detector Flag Register; 0x00000283 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD4FLGSTR;
extern volatile SSD4FLGSTR _SSD4FLG @(REG_BASE + 0x00000283UL);
#define SSD4FLG                         _SSD4FLG.Byte
#define SSD4FLG_AOVIF                   _SSD4FLG.Bits.AOVIF
#define SSD4FLG_MCZIF                   _SSD4FLG.Bits.MCZIF

#define SSD4FLG_AOVIF_MASK              1U
#define SSD4FLG_MCZIF_MASK              128U


/*** MDC4CNT - SSD4 Modulus Down-Counter Count Register; 0x00000284 ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC4CNTSTR;
extern volatile MDC4CNTSTR _MDC4CNT @(REG_BASE + 0x00000284UL);
#define MDC4CNT                         _MDC4CNT.Word
#define MDC4CNT_MDCCNT                  _MDC4CNT.Bits.MDCCNT

#define MDC4CNT_MDCCNT_MASK             65535U
#define MDC4CNT_MDCCNT_BITNUM           0U


/*** ITG4ACC - SSD4 Integration Accumulator Register; 0x00000286 ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG4ACCSTR;
extern volatile ITG4ACCSTR _ITG4ACC @(REG_BASE + 0x00000286UL);
#define ITG4ACC                         _ITG4ACC.Word
#define ITG4ACC_ITGACC                  _ITG4ACC.Bits.ITGACC

#define ITG4ACC_ITGACC_MASK             65535U
#define ITG4ACC_ITGACC_BITNUM           0U


/*** RTZ0CTL - SSD0 Return-to-Zero Control Register; 0x00000288 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ0CTLSTR;
extern volatile RTZ0CTLSTR _RTZ0CTL @(REG_BASE + 0x00000288UL);
#define RTZ0CTL                         _RTZ0CTL.Byte
#define RTZ0CTL_STEP                    _RTZ0CTL.Bits.STEP
#define RTZ0CTL_SMS                     _RTZ0CTL.Bits.SMS
#define RTZ0CTL_POL                     _RTZ0CTL.Bits.POL
#define RTZ0CTL_RCIR                    _RTZ0CTL.Bits.RCIR
#define RTZ0CTL_DCOIL                   _RTZ0CTL.Bits.DCOIL
#define RTZ0CTL_ITG                     _RTZ0CTL.Bits.ITG

#define RTZ0CTL_STEP_MASK               3U
#define RTZ0CTL_STEP_BITNUM             0U
#define RTZ0CTL_SMS_MASK                4U
#define RTZ0CTL_POL_MASK                16U
#define RTZ0CTL_RCIR_MASK               32U
#define RTZ0CTL_DCOIL_MASK              64U
#define RTZ0CTL_ITG_MASK                128U


/*** MDC0CTL - SSD0 Modulus Down Counter Control Register; 0x00000289 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC0CTLSTR;
extern volatile MDC0CTLSTR _MDC0CTL @(REG_BASE + 0x00000289UL);
#define MDC0CTL                         _MDC0CTL.Byte
#define MDC0CTL_AOVIE                   _MDC0CTL.Bits.AOVIE
#define MDC0CTL_MCEN                    _MDC0CTL.Bits.MCEN
#define MDC0CTL_FLMC                    _MDC0CTL.Bits.FLMC
#define MDC0CTL_PRE                     _MDC0CTL.Bits.PRE
#define MDC0CTL_RDMCL                   _MDC0CTL.Bits.RDMCL
#define MDC0CTL_MODMC                   _MDC0CTL.Bits.MODMC
#define MDC0CTL_MCZIE                   _MDC0CTL.Bits.MCZIE

#define MDC0CTL_AOVIE_MASK              1U
#define MDC0CTL_MCEN_MASK               4U
#define MDC0CTL_FLMC_MASK               8U
#define MDC0CTL_PRE_MASK                16U
#define MDC0CTL_RDMCL_MASK              32U
#define MDC0CTL_MODMC_MASK              64U
#define MDC0CTL_MCZIE_MASK              128U


/*** SSD0CTL - SSD0 Stepper Stall Detector Control Register; 0x0000028A ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD0CTLSTR;
extern volatile SSD0CTLSTR _SSD0CTL @(REG_BASE + 0x0000028AUL);
#define SSD0CTL                         _SSD0CTL.Byte
#define SSD0CTL_ACLKS                   _SSD0CTL.Bits.ACLKS
#define SSD0CTL_FTST                    _SSD0CTL.Bits.FTST
#define SSD0CTL_SSDWAI                  _SSD0CTL.Bits.SSDWAI
#define SSD0CTL_SDCPU                   _SSD0CTL.Bits.SDCPU
#define SSD0CTL_RTZE                    _SSD0CTL.Bits.RTZE

#define SSD0CTL_ACLKS_MASK              3U
#define SSD0CTL_ACLKS_BITNUM            0U
#define SSD0CTL_FTST_MASK               16U
#define SSD0CTL_SSDWAI_MASK             32U
#define SSD0CTL_SDCPU_MASK              64U
#define SSD0CTL_RTZE_MASK               128U


/*** SSD0FLG - SSD0 Stepper Stall Detector Flag Register; 0x0000028B ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD0FLGSTR;
extern volatile SSD0FLGSTR _SSD0FLG @(REG_BASE + 0x0000028BUL);
#define SSD0FLG                         _SSD0FLG.Byte
#define SSD0FLG_AOVIF                   _SSD0FLG.Bits.AOVIF
#define SSD0FLG_MCZIF                   _SSD0FLG.Bits.MCZIF

#define SSD0FLG_AOVIF_MASK              1U
#define SSD0FLG_MCZIF_MASK              128U


/*** MDC0CNT - SSD0 Modulus Down-Counter Count Register; 0x0000028C ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC0CNTSTR;
extern volatile MDC0CNTSTR _MDC0CNT @(REG_BASE + 0x0000028CUL);
#define MDC0CNT                         _MDC0CNT.Word
#define MDC0CNT_MDCCNT                  _MDC0CNT.Bits.MDCCNT

#define MDC0CNT_MDCCNT_MASK             65535U
#define MDC0CNT_MDCCNT_BITNUM           0U


/*** ITG0ACC - SSD0 Integration Accumulator Register; 0x0000028E ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG0ACCSTR;
extern volatile ITG0ACCSTR _ITG0ACC @(REG_BASE + 0x0000028EUL);
#define ITG0ACC                         _ITG0ACC.Word
#define ITG0ACC_ITGACC                  _ITG0ACC.Bits.ITGACC

#define ITG0ACC_ITGACC_MASK             65535U
#define ITG0ACC_ITGACC_BITNUM           0U


/*** RTZ1CTL - SSD1 Return-to-Zero Control Register; 0x00000290 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ1CTLSTR;
extern volatile RTZ1CTLSTR _RTZ1CTL @(REG_BASE + 0x00000290UL);
#define RTZ1CTL                         _RTZ1CTL.Byte
#define RTZ1CTL_STEP                    _RTZ1CTL.Bits.STEP
#define RTZ1CTL_SMS                     _RTZ1CTL.Bits.SMS
#define RTZ1CTL_POL                     _RTZ1CTL.Bits.POL
#define RTZ1CTL_RCIR                    _RTZ1CTL.Bits.RCIR
#define RTZ1CTL_DCOIL                   _RTZ1CTL.Bits.DCOIL
#define RTZ1CTL_ITG                     _RTZ1CTL.Bits.ITG

#define RTZ1CTL_STEP_MASK               3U
#define RTZ1CTL_STEP_BITNUM             0U
#define RTZ1CTL_SMS_MASK                4U
#define RTZ1CTL_POL_MASK                16U
#define RTZ1CTL_RCIR_MASK               32U
#define RTZ1CTL_DCOIL_MASK              64U
#define RTZ1CTL_ITG_MASK                128U


/*** MDC1CTL - SSD1 Modulus Down Counter Control Register; 0x00000291 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC1CTLSTR;
extern volatile MDC1CTLSTR _MDC1CTL @(REG_BASE + 0x00000291UL);
#define MDC1CTL                         _MDC1CTL.Byte
#define MDC1CTL_AOVIE                   _MDC1CTL.Bits.AOVIE
#define MDC1CTL_MCEN                    _MDC1CTL.Bits.MCEN
#define MDC1CTL_FLMC                    _MDC1CTL.Bits.FLMC
#define MDC1CTL_PRE                     _MDC1CTL.Bits.PRE
#define MDC1CTL_RDMCL                   _MDC1CTL.Bits.RDMCL
#define MDC1CTL_MODMC                   _MDC1CTL.Bits.MODMC
#define MDC1CTL_MCZIE                   _MDC1CTL.Bits.MCZIE

#define MDC1CTL_AOVIE_MASK              1U
#define MDC1CTL_MCEN_MASK               4U
#define MDC1CTL_FLMC_MASK               8U
#define MDC1CTL_PRE_MASK                16U
#define MDC1CTL_RDMCL_MASK              32U
#define MDC1CTL_MODMC_MASK              64U
#define MDC1CTL_MCZIE_MASK              128U


/*** SSD1CTL - SSD1 Stepper Stall Detector Control Register; 0x00000292 ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD1CTLSTR;
extern volatile SSD1CTLSTR _SSD1CTL @(REG_BASE + 0x00000292UL);
#define SSD1CTL                         _SSD1CTL.Byte
#define SSD1CTL_ACLKS                   _SSD1CTL.Bits.ACLKS
#define SSD1CTL_FTST                    _SSD1CTL.Bits.FTST
#define SSD1CTL_SSDWAI                  _SSD1CTL.Bits.SSDWAI
#define SSD1CTL_SDCPU                   _SSD1CTL.Bits.SDCPU
#define SSD1CTL_RTZE                    _SSD1CTL.Bits.RTZE

#define SSD1CTL_ACLKS_MASK              3U
#define SSD1CTL_ACLKS_BITNUM            0U
#define SSD1CTL_FTST_MASK               16U
#define SSD1CTL_SSDWAI_MASK             32U
#define SSD1CTL_SDCPU_MASK              64U
#define SSD1CTL_RTZE_MASK               128U


/*** SSD1FLG - SSD1 Stepper Stall Detector Flag Register; 0x00000293 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD1FLGSTR;
extern volatile SSD1FLGSTR _SSD1FLG @(REG_BASE + 0x00000293UL);
#define SSD1FLG                         _SSD1FLG.Byte
#define SSD1FLG_AOVIF                   _SSD1FLG.Bits.AOVIF
#define SSD1FLG_MCZIF                   _SSD1FLG.Bits.MCZIF

#define SSD1FLG_AOVIF_MASK              1U
#define SSD1FLG_MCZIF_MASK              128U


/*** MDC1CNT - SSD1 Modulus Down-Counter Count Register; 0x00000294 ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC1CNTSTR;
extern volatile MDC1CNTSTR _MDC1CNT @(REG_BASE + 0x00000294UL);
#define MDC1CNT                         _MDC1CNT.Word
#define MDC1CNT_MDCCNT                  _MDC1CNT.Bits.MDCCNT

#define MDC1CNT_MDCCNT_MASK             65535U
#define MDC1CNT_MDCCNT_BITNUM           0U


/*** ITG1ACC - SSD1 Integration Accumulator Register; 0x00000296 ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG1ACCSTR;
extern volatile ITG1ACCSTR _ITG1ACC @(REG_BASE + 0x00000296UL);
#define ITG1ACC                         _ITG1ACC.Word
#define ITG1ACC_ITGACC                  _ITG1ACC.Bits.ITGACC

#define ITG1ACC_ITGACC_MASK             65535U
#define ITG1ACC_ITGACC_BITNUM           0U


/*** RTZ2CTL - SSD2 Return-to-Zero Control Register; 0x00000298 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ2CTLSTR;
extern volatile RTZ2CTLSTR _RTZ2CTL @(REG_BASE + 0x00000298UL);
#define RTZ2CTL                         _RTZ2CTL.Byte
#define RTZ2CTL_STEP                    _RTZ2CTL.Bits.STEP
#define RTZ2CTL_SMS                     _RTZ2CTL.Bits.SMS
#define RTZ2CTL_POL                     _RTZ2CTL.Bits.POL
#define RTZ2CTL_RCIR                    _RTZ2CTL.Bits.RCIR
#define RTZ2CTL_DCOIL                   _RTZ2CTL.Bits.DCOIL
#define RTZ2CTL_ITG                     _RTZ2CTL.Bits.ITG

#define RTZ2CTL_STEP_MASK               3U
#define RTZ2CTL_STEP_BITNUM             0U
#define RTZ2CTL_SMS_MASK                4U
#define RTZ2CTL_POL_MASK                16U
#define RTZ2CTL_RCIR_MASK               32U
#define RTZ2CTL_DCOIL_MASK              64U
#define RTZ2CTL_ITG_MASK                128U


/*** MDC2CTL - SSD2 Modulus Down Counter Control Register; 0x00000299 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC2CTLSTR;
extern volatile MDC2CTLSTR _MDC2CTL @(REG_BASE + 0x00000299UL);
#define MDC2CTL                         _MDC2CTL.Byte
#define MDC2CTL_AOVIE                   _MDC2CTL.Bits.AOVIE
#define MDC2CTL_MCEN                    _MDC2CTL.Bits.MCEN
#define MDC2CTL_FLMC                    _MDC2CTL.Bits.FLMC
#define MDC2CTL_PRE                     _MDC2CTL.Bits.PRE
#define MDC2CTL_RDMCL                   _MDC2CTL.Bits.RDMCL
#define MDC2CTL_MODMC                   _MDC2CTL.Bits.MODMC
#define MDC2CTL_MCZIE                   _MDC2CTL.Bits.MCZIE

#define MDC2CTL_AOVIE_MASK              1U
#define MDC2CTL_MCEN_MASK               4U
#define MDC2CTL_FLMC_MASK               8U
#define MDC2CTL_PRE_MASK                16U
#define MDC2CTL_RDMCL_MASK              32U
#define MDC2CTL_MODMC_MASK              64U
#define MDC2CTL_MCZIE_MASK              128U


/*** SSD2CTL - SSD2 Stepper Stall Detector Control Register; 0x0000029A ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD2CTLSTR;
extern volatile SSD2CTLSTR _SSD2CTL @(REG_BASE + 0x0000029AUL);
#define SSD2CTL                         _SSD2CTL.Byte
#define SSD2CTL_ACLKS                   _SSD2CTL.Bits.ACLKS
#define SSD2CTL_FTST                    _SSD2CTL.Bits.FTST
#define SSD2CTL_SSDWAI                  _SSD2CTL.Bits.SSDWAI
#define SSD2CTL_SDCPU                   _SSD2CTL.Bits.SDCPU
#define SSD2CTL_RTZE                    _SSD2CTL.Bits.RTZE

#define SSD2CTL_ACLKS_MASK              3U
#define SSD2CTL_ACLKS_BITNUM            0U
#define SSD2CTL_FTST_MASK               16U
#define SSD2CTL_SSDWAI_MASK             32U
#define SSD2CTL_SDCPU_MASK              64U
#define SSD2CTL_RTZE_MASK               128U


/*** SSD2FLG - SSD2 Stepper Stall Detector Flag Register; 0x0000029B ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD2FLGSTR;
extern volatile SSD2FLGSTR _SSD2FLG @(REG_BASE + 0x0000029BUL);
#define SSD2FLG                         _SSD2FLG.Byte
#define SSD2FLG_AOVIF                   _SSD2FLG.Bits.AOVIF
#define SSD2FLG_MCZIF                   _SSD2FLG.Bits.MCZIF

#define SSD2FLG_AOVIF_MASK              1U
#define SSD2FLG_MCZIF_MASK              128U


/*** MDC2CNT - SSD2 Modulus Down-Counter Count Register; 0x0000029C ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC2CNTSTR;
extern volatile MDC2CNTSTR _MDC2CNT @(REG_BASE + 0x0000029CUL);
#define MDC2CNT                         _MDC2CNT.Word
#define MDC2CNT_MDCCNT                  _MDC2CNT.Bits.MDCCNT

#define MDC2CNT_MDCCNT_MASK             65535U
#define MDC2CNT_MDCCNT_BITNUM           0U


/*** ITG2ACC - SSD2 Integration Accumulator Register; 0x0000029E ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG2ACCSTR;
extern volatile ITG2ACCSTR _ITG2ACC @(REG_BASE + 0x0000029EUL);
#define ITG2ACC                         _ITG2ACC.Word
#define ITG2ACC_ITGACC                  _ITG2ACC.Bits.ITGACC

#define ITG2ACC_ITGACC_MASK             65535U
#define ITG2ACC_ITGACC_BITNUM           0U


/*** RTZ3CTL - SSD3 Return-to-Zero Control Register; 0x000002A0 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ3CTLSTR;
extern volatile RTZ3CTLSTR _RTZ3CTL @(REG_BASE + 0x000002A0UL);
#define RTZ3CTL                         _RTZ3CTL.Byte
#define RTZ3CTL_STEP                    _RTZ3CTL.Bits.STEP
#define RTZ3CTL_SMS                     _RTZ3CTL.Bits.SMS
#define RTZ3CTL_POL                     _RTZ3CTL.Bits.POL
#define RTZ3CTL_RCIR                    _RTZ3CTL.Bits.RCIR
#define RTZ3CTL_DCOIL                   _RTZ3CTL.Bits.DCOIL
#define RTZ3CTL_ITG                     _RTZ3CTL.Bits.ITG

#define RTZ3CTL_STEP_MASK               3U
#define RTZ3CTL_STEP_BITNUM             0U
#define RTZ3CTL_SMS_MASK                4U
#define RTZ3CTL_POL_MASK                16U
#define RTZ3CTL_RCIR_MASK               32U
#define RTZ3CTL_DCOIL_MASK              64U
#define RTZ3CTL_ITG_MASK                128U


/*** MDC3CTL - SSD3 Modulus Down Counter Control Register; 0x000002A1 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC3CTLSTR;
extern volatile MDC3CTLSTR _MDC3CTL @(REG_BASE + 0x000002A1UL);
#define MDC3CTL                         _MDC3CTL.Byte
#define MDC3CTL_AOVIE                   _MDC3CTL.Bits.AOVIE
#define MDC3CTL_MCEN                    _MDC3CTL.Bits.MCEN
#define MDC3CTL_FLMC                    _MDC3CTL.Bits.FLMC
#define MDC3CTL_PRE                     _MDC3CTL.Bits.PRE
#define MDC3CTL_RDMCL                   _MDC3CTL.Bits.RDMCL
#define MDC3CTL_MODMC                   _MDC3CTL.Bits.MODMC
#define MDC3CTL_MCZIE                   _MDC3CTL.Bits.MCZIE

#define MDC3CTL_AOVIE_MASK              1U
#define MDC3CTL_MCEN_MASK               4U
#define MDC3CTL_FLMC_MASK               8U
#define MDC3CTL_PRE_MASK                16U
#define MDC3CTL_RDMCL_MASK              32U
#define MDC3CTL_MODMC_MASK              64U
#define MDC3CTL_MCZIE_MASK              128U


/*** SSD3CTL - SSD3 Stepper Stall Detector Control Register; 0x000002A2 ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD3CTLSTR;
extern volatile SSD3CTLSTR _SSD3CTL @(REG_BASE + 0x000002A2UL);
#define SSD3CTL                         _SSD3CTL.Byte
#define SSD3CTL_ACLKS                   _SSD3CTL.Bits.ACLKS
#define SSD3CTL_FTST                    _SSD3CTL.Bits.FTST
#define SSD3CTL_SSDWAI                  _SSD3CTL.Bits.SSDWAI
#define SSD3CTL_SDCPU                   _SSD3CTL.Bits.SDCPU
#define SSD3CTL_RTZE                    _SSD3CTL.Bits.RTZE

#define SSD3CTL_ACLKS_MASK              3U
#define SSD3CTL_ACLKS_BITNUM            0U
#define SSD3CTL_FTST_MASK               16U
#define SSD3CTL_SSDWAI_MASK             32U
#define SSD3CTL_SDCPU_MASK              64U
#define SSD3CTL_RTZE_MASK               128U


/*** SSD3FLG - SSD3 Stepper Stall Detector Flag Register; 0x000002A3 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD3FLGSTR;
extern volatile SSD3FLGSTR _SSD3FLG @(REG_BASE + 0x000002A3UL);
#define SSD3FLG                         _SSD3FLG.Byte
#define SSD3FLG_AOVIF                   _SSD3FLG.Bits.AOVIF
#define SSD3FLG_MCZIF                   _SSD3FLG.Bits.MCZIF

#define SSD3FLG_AOVIF_MASK              1U
#define SSD3FLG_MCZIF_MASK              128U


/*** MDC3CNT - SSD3 Modulus Down-Counter Count Register; 0x000002A4 ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC3CNTSTR;
extern volatile MDC3CNTSTR _MDC3CNT @(REG_BASE + 0x000002A4UL);
#define MDC3CNT                         _MDC3CNT.Word
#define MDC3CNT_MDCCNT                  _MDC3CNT.Bits.MDCCNT

#define MDC3CNT_MDCCNT_MASK             65535U
#define MDC3CNT_MDCCNT_BITNUM           0U


/*** ITG3ACC - SSD3 Integration Accumulator Register; 0x000002A6 ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG3ACCSTR;
extern volatile ITG3ACCSTR _ITG3ACC @(REG_BASE + 0x000002A6UL);
#define ITG3ACC                         _ITG3ACC.Word
#define ITG3ACC_ITGACC                  _ITG3ACC.Bits.ITGACC

#define ITG3ACC_ITGACC_MASK             65535U
#define ITG3ACC_ITGACC_BITNUM           0U


/*** RTZ5CTL - SSD5 Return-to-Zero Control Register; 0x000002A8 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ5CTLSTR;
extern volatile RTZ5CTLSTR _RTZ5CTL @(REG_BASE + 0x000002A8UL);
#define RTZ5CTL                         _RTZ5CTL.Byte
#define RTZ5CTL_STEP                    _RTZ5CTL.Bits.STEP
#define RTZ5CTL_SMS                     _RTZ5CTL.Bits.SMS
#define RTZ5CTL_POL                     _RTZ5CTL.Bits.POL
#define RTZ5CTL_RCIR                    _RTZ5CTL.Bits.RCIR
#define RTZ5CTL_DCOIL                   _RTZ5CTL.Bits.DCOIL
#define RTZ5CTL_ITG                     _RTZ5CTL.Bits.ITG

#define RTZ5CTL_STEP_MASK               3U
#define RTZ5CTL_STEP_BITNUM             0U
#define RTZ5CTL_SMS_MASK                4U
#define RTZ5CTL_POL_MASK                16U
#define RTZ5CTL_RCIR_MASK               32U
#define RTZ5CTL_DCOIL_MASK              64U
#define RTZ5CTL_ITG_MASK                128U


/*** MDC5CTL - SSD5 Modulus Down Counter Control Register; 0x000002A9 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC5CTLSTR;
extern volatile MDC5CTLSTR _MDC5CTL @(REG_BASE + 0x000002A9UL);
#define MDC5CTL                         _MDC5CTL.Byte
#define MDC5CTL_AOVIE                   _MDC5CTL.Bits.AOVIE
#define MDC5CTL_MCEN                    _MDC5CTL.Bits.MCEN
#define MDC5CTL_FLMC                    _MDC5CTL.Bits.FLMC
#define MDC5CTL_PRE                     _MDC5CTL.Bits.PRE
#define MDC5CTL_RDMCL                   _MDC5CTL.Bits.RDMCL
#define MDC5CTL_MODMC                   _MDC5CTL.Bits.MODMC
#define MDC5CTL_MCZIE                   _MDC5CTL.Bits.MCZIE

#define MDC5CTL_AOVIE_MASK              1U
#define MDC5CTL_MCEN_MASK               4U
#define MDC5CTL_FLMC_MASK               8U
#define MDC5CTL_PRE_MASK                16U
#define MDC5CTL_RDMCL_MASK              32U
#define MDC5CTL_MODMC_MASK              64U
#define MDC5CTL_MCZIE_MASK              128U


/*** SSD5CTL - SSD5 Stepper Stall Detector Control Register; 0x000002AA ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD5CTLSTR;
extern volatile SSD5CTLSTR _SSD5CTL @(REG_BASE + 0x000002AAUL);
#define SSD5CTL                         _SSD5CTL.Byte
#define SSD5CTL_ACLKS                   _SSD5CTL.Bits.ACLKS
#define SSD5CTL_FTST                    _SSD5CTL.Bits.FTST
#define SSD5CTL_SSDWAI                  _SSD5CTL.Bits.SSDWAI
#define SSD5CTL_SDCPU                   _SSD5CTL.Bits.SDCPU
#define SSD5CTL_RTZE                    _SSD5CTL.Bits.RTZE

#define SSD5CTL_ACLKS_MASK              3U
#define SSD5CTL_ACLKS_BITNUM            0U
#define SSD5CTL_FTST_MASK               16U
#define SSD5CTL_SSDWAI_MASK             32U
#define SSD5CTL_SDCPU_MASK              64U
#define SSD5CTL_RTZE_MASK               128U


/*** SSD5FLG - SSD5 Stepper Stall Detector Flag Register; 0x000002AB ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD5FLGSTR;
extern volatile SSD5FLGSTR _SSD5FLG @(REG_BASE + 0x000002ABUL);
#define SSD5FLG                         _SSD5FLG.Byte
#define SSD5FLG_AOVIF                   _SSD5FLG.Bits.AOVIF
#define SSD5FLG_MCZIF                   _SSD5FLG.Bits.MCZIF

#define SSD5FLG_AOVIF_MASK              1U
#define SSD5FLG_MCZIF_MASK              128U


/*** MDC5CNT - SSD5 Modulus Down-Counter Count Register; 0x000002AC ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC5CNTSTR;
extern volatile MDC5CNTSTR _MDC5CNT @(REG_BASE + 0x000002ACUL);
#define MDC5CNT                         _MDC5CNT.Word
#define MDC5CNT_MDCCNT                  _MDC5CNT.Bits.MDCCNT

#define MDC5CNT_MDCCNT_MASK             65535U
#define MDC5CNT_MDCCNT_BITNUM           0U


/*** ITG5ACC - SSD5 Integration Accumulator Register; 0x000002AE ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG5ACCSTR;
extern volatile ITG5ACCSTR _ITG5ACC @(REG_BASE + 0x000002AEUL);
#define ITG5ACC                         _ITG5ACC.Word
#define ITG5ACC_ITGACC                  _ITG5ACC.Bits.ITGACC

#define ITG5ACC_ITGACC_MASK             65535U
#define ITG5ACC_ITGACC_BITNUM           0U


/*** VREGCTRL - Control Register; 0x000002F1 ***/
typedef union {
  byte Byte;
  struct {
    byte LVIF        :1;                                       /* Low-Voltage Interrupt Flag */
    byte LVIE        :1;                                       /* Low-Voltage Interrupt Enable Bit */
    byte LVDS        :1;                                       /* Low-Voltage Detect Status Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} VREGCTRLSTR;
extern volatile VREGCTRLSTR _VREGCTRL @(REG_BASE + 0x000002F1UL);
#define VREGCTRL                        _VREGCTRL.Byte
#define VREGCTRL_LVIF                   _VREGCTRL.Bits.LVIF
#define VREGCTRL_LVIE                   _VREGCTRL.Bits.LVIE
#define VREGCTRL_LVDS                   _VREGCTRL.Bits.LVDS

#define VREGCTRL_LVIF_MASK              1U
#define VREGCTRL_LVIE_MASK              2U
#define VREGCTRL_LVDS_MASK              4U


/*** VREGAPICL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***/
typedef union {
  byte Byte;
  struct {
    byte APIF        :1;                                       /* Autonomous Periodical Interrupt Flag */
    byte APIE        :1;                                       /* Autonomous Periodical Interrupt Enable Bit */
    byte APIFE       :1;                                       /* Autonomous Periodical Interrupt Feature Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte APICLK      :1;                                       /* Autonomous Periodical Interrupt Clock Select Bit */
  } Bits;
} VREGAPICLSTR;
extern volatile VREGAPICLSTR _VREGAPICL @(REG_BASE + 0x000002F2UL);
#define VREGAPICL                       _VREGAPICL.Byte
#define VREGAPICL_APIF                  _VREGAPICL.Bits.APIF
#define VREGAPICL_APIE                  _VREGAPICL.Bits.APIE
#define VREGAPICL_APIFE                 _VREGAPICL.Bits.APIFE
#define VREGAPICL_APICLK                _VREGAPICL.Bits.APICLK

#define VREGAPICL_APIF_MASK             1U
#define VREGAPICL_APIE_MASK             2U
#define VREGAPICL_APIFE_MASK            4U
#define VREGAPICL_APICLK_MASK           128U


/*** VREGAPITR - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte APITR0      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 0 */
    byte APITR1      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 1 */
    byte APITR2      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 2 */
    byte APITR3      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 3 */
    byte APITR4      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 4 */
    byte APITR5      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 5 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpAPITR :6;
  } MergedBits;
} VREGAPITRSTR;
extern volatile VREGAPITRSTR _VREGAPITR @(REG_BASE + 0x000002F3UL);
#define VREGAPITR                       _VREGAPITR.Byte
#define VREGAPITR_APITR0                _VREGAPITR.Bits.APITR0
#define VREGAPITR_APITR1                _VREGAPITR.Bits.APITR1
#define VREGAPITR_APITR2                _VREGAPITR.Bits.APITR2
#define VREGAPITR_APITR3                _VREGAPITR.Bits.APITR3
#define VREGAPITR_APITR4                _VREGAPITR.Bits.APITR4
#define VREGAPITR_APITR5                _VREGAPITR.Bits.APITR5
#define VREGAPITR_APITR                 _VREGAPITR.MergedBits.grpAPITR

#define VREGAPITR_APITR0_MASK           4U
#define VREGAPITR_APITR1_MASK           8U
#define VREGAPITR_APITR2_MASK           16U
#define VREGAPITR_APITR3_MASK           32U
#define VREGAPITR_APITR4_MASK           64U
#define VREGAPITR_APITR5_MASK           128U
#define VREGAPITR_APITR_MASK            252U
#define VREGAPITR_APITR_BITNUM          2U


/*** VREGAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** VREGAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***/
    union {
      byte Byte;
      struct {
        byte APIR8       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 8 */
        byte APIR9       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 9 */
        byte APIR10      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 10 */
        byte APIR11      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 11 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpAPIR_8 :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } VREGAPIRHSTR;
    #define VREGAPIRH                   _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Byte
    #define VREGAPIRH_APIR8             _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR8
    #define VREGAPIRH_APIR9             _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR9
    #define VREGAPIRH_APIR10            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR10
    #define VREGAPIRH_APIR11            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR11
    #define VREGAPIRH_APIR_8            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.MergedBits.grpAPIR_8
    #define VREGAPIRH_APIR              VREGAPIRH_APIR_8
    
    #define VREGAPIRH_APIR8_MASK        1U
    #define VREGAPIRH_APIR9_MASK        2U
    #define VREGAPIRH_APIR10_MASK       4U
    #define VREGAPIRH_APIR11_MASK       8U
    #define VREGAPIRH_APIR_8_MASK       15U
    #define VREGAPIRH_APIR_8_BITNUM     0U
    

    /*** VREGAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***/
    union {
      byte Byte;
      struct {
        byte APIR0       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 0 */
        byte APIR1       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 1 */
        byte APIR2       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 2 */
        byte APIR3       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 3 */
        byte APIR4       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 4 */
        byte APIR5       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 5 */
        byte APIR6       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 6 */
        byte APIR7       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 7 */
      } Bits;
    } VREGAPIRLSTR;
    #define VREGAPIRL                   _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Byte
    #define VREGAPIRL_APIR0             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR0
    #define VREGAPIRL_APIR1             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR1
    #define VREGAPIRL_APIR2             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR2
    #define VREGAPIRL_APIR3             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR3
    #define VREGAPIRL_APIR4             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR4
    #define VREGAPIRL_APIR5             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR5
    #define VREGAPIRL_APIR6             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR6
    #define VREGAPIRL_APIR7             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR7
    
    #define VREGAPIRL_APIR0_MASK        1U
    #define VREGAPIRL_APIR1_MASK        2U
    #define VREGAPIRL_APIR2_MASK        4U
    #define VREGAPIRL_APIR3_MASK        8U
    #define VREGAPIRL_APIR4_MASK        16U
    #define VREGAPIRL_APIR5_MASK        32U
    #define VREGAPIRL_APIR6_MASK        64U
    #define VREGAPIRL_APIR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word APIR0       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 0 */
    word APIR1       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 1 */
    word APIR2       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 2 */
    word APIR3       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 3 */
    word APIR4       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 4 */
    word APIR5       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 5 */
    word APIR6       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 6 */
    word APIR7       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 7 */
    word APIR8       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 8 */
    word APIR9       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 9 */
    word APIR10      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 10 */
    word APIR11      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpAPIR :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} VREGAPIRSTR;
extern volatile VREGAPIRSTR _VREGAPIR @(REG_BASE + 0x000002F4UL);
#define VREGAPIR                        _VREGAPIR.Word
#define VREGAPIR_APIR0                  _VREGAPIR.Bits.APIR0
#define VREGAPIR_APIR1                  _VREGAPIR.Bits.APIR1
#define VREGAPIR_APIR2                  _VREGAPIR.Bits.APIR2
#define VREGAPIR_APIR3                  _VREGAPIR.Bits.APIR3
#define VREGAPIR_APIR4                  _VREGAPIR.Bits.APIR4
#define VREGAPIR_APIR5                  _VREGAPIR.Bits.APIR5
#define VREGAPIR_APIR6                  _VREGAPIR.Bits.APIR6
#define VREGAPIR_APIR7                  _VREGAPIR.Bits.APIR7
#define VREGAPIR_APIR8                  _VREGAPIR.Bits.APIR8
#define VREGAPIR_APIR9                  _VREGAPIR.Bits.APIR9
#define VREGAPIR_APIR10                 _VREGAPIR.Bits.APIR10
#define VREGAPIR_APIR11                 _VREGAPIR.Bits.APIR11
#define VREGAPIR_APIR                   _VREGAPIR.MergedBits.grpAPIR

#define VREGAPIR_APIR0_MASK             1U
#define VREGAPIR_APIR1_MASK             2U
#define VREGAPIR_APIR2_MASK             4U
#define VREGAPIR_APIR3_MASK             8U
#define VREGAPIR_APIR4_MASK             16U
#define VREGAPIR_APIR5_MASK             32U
#define VREGAPIR_APIR6_MASK             64U
#define VREGAPIR_APIR7_MASK             128U
#define VREGAPIR_APIR8_MASK             256U
#define VREGAPIR_APIR9_MASK             512U
#define VREGAPIR_APIR10_MASK            1024U
#define VREGAPIR_APIR11_MASK            2048U
#define VREGAPIR_APIR_MASK              4095U
#define VREGAPIR_APIR_BITNUM            0U


/*** PWME - PWM Enable Register; 0x00000300 ***/
typedef union {
  byte Byte;
  struct {
    byte PWME0       :1;                                       /* Pulse Width Channel 0 Enable */
    byte PWME1       :1;                                       /* Pulse Width Channel 1 Enable */
    byte PWME2       :1;                                       /* Pulse Width Channel 2 Enable */
    byte PWME3       :1;                                       /* Pulse Width Channel 3 Enable */
    byte PWME4       :1;                                       /* Pulse Width Channel 4 Enable */
    byte PWME5       :1;                                       /* Pulse Width Channel 5 Enable */
    byte PWME6       :1;                                       /* Pulse Width Channel 6 Enable */
    byte PWME7       :1;                                       /* Pulse Width Channel 7 Enable */
  } Bits;
} PWMESTR;
extern volatile PWMESTR _PWME @(REG_BASE + 0x00000300UL);
#define PWME                            _PWME.Byte
#define PWME_PWME0                      _PWME.Bits.PWME0
#define PWME_PWME1                      _PWME.Bits.PWME1
#define PWME_PWME2                      _PWME.Bits.PWME2
#define PWME_PWME3                      _PWME.Bits.PWME3
#define PWME_PWME4                      _PWME.Bits.PWME4
#define PWME_PWME5                      _PWME.Bits.PWME5
#define PWME_PWME6                      _PWME.Bits.PWME6
#define PWME_PWME7                      _PWME.Bits.PWME7

#define PWME_PWME0_MASK                 1U
#define PWME_PWME1_MASK                 2U
#define PWME_PWME2_MASK                 4U
#define PWME_PWME3_MASK                 8U
#define PWME_PWME4_MASK                 16U
#define PWME_PWME5_MASK                 32U
#define PWME_PWME6_MASK                 64U
#define PWME_PWME7_MASK                 128U


/*** PWMPOL - PWM Polarity Register; 0x00000301 ***/
typedef union {
  byte Byte;
  struct {
    byte PPOL0       :1;                                       /* Pulse Width Channel 0 Polarity */
    byte PPOL1       :1;                                       /* Pulse Width Channel 1 Polarity */
    byte PPOL2       :1;                                       /* Pulse Width Channel 2 Polarity */
    byte PPOL3       :1;                                       /* Pulse Width Channel 3 Polarity */
    byte PPOL4       :1;                                       /* Pulse Width Channel 4 Polarity */
    byte PPOL5       :1;                                       /* Pulse Width Channel 5 Polarity */
    byte PPOL6       :1;                                       /* Pulse Width Channel 6 Polarity */
    byte PPOL7       :1;                                       /* Pulse Width Channel 7 Polarity */
  } Bits;
} PWMPOLSTR;
extern volatile PWMPOLSTR _PWMPOL @(REG_BASE + 0x00000301UL);
#define PWMPOL                          _PWMPOL.Byte
#define PWMPOL_PPOL0                    _PWMPOL.Bits.PPOL0
#define PWMPOL_PPOL1                    _PWMPOL.Bits.PPOL1
#define PWMPOL_PPOL2                    _PWMPOL.Bits.PPOL2
#define PWMPOL_PPOL3                    _PWMPOL.Bits.PPOL3
#define PWMPOL_PPOL4                    _PWMPOL.Bits.PPOL4
#define PWMPOL_PPOL5                    _PWMPOL.Bits.PPOL5
#define PWMPOL_PPOL6                    _PWMPOL.Bits.PPOL6
#define PWMPOL_PPOL7                    _PWMPOL.Bits.PPOL7

#define PWMPOL_PPOL0_MASK               1U
#define PWMPOL_PPOL1_MASK               2U
#define PWMPOL_PPOL2_MASK               4U
#define PWMPOL_PPOL3_MASK               8U
#define PWMPOL_PPOL4_MASK               16U
#define PWMPOL_PPOL5_MASK               32U
#define PWMPOL_PPOL6_MASK               64U
#define PWMPOL_PPOL7_MASK               128U


/*** PWMCLK - PWM Clock Select Register; 0x00000302 ***/
typedef union {
  byte Byte;
  struct {
    byte PCLK0       :1;                                       /* Pulse Width Channel 0 Clock Select */
    byte PCLK1       :1;                                       /* Pulse Width Channel 1 Clock Select */
    byte PCLK2       :1;                                       /* Pulse Width Channel 2 Clock Select */
    byte PCLK3       :1;                                       /* Pulse Width Channel 3 Clock Select */
    byte PCLK4       :1;                                       /* Pulse Width Channel 4 Clock Select */
    byte PCLK5       :1;                                       /* Pulse Width Channel 5 Clock Select */
    byte PCLK6       :1;                                       /* Pulse Width Channel 6 Clock Select */
    byte PCLK7       :1;                                       /* Pulse Width Channel 7 Clock Select */
  } Bits;
} PWMCLKSTR;
extern volatile PWMCLKSTR _PWMCLK @(REG_BASE + 0x00000302UL);
#define PWMCLK                          _PWMCLK.Byte
#define PWMCLK_PCLK0                    _PWMCLK.Bits.PCLK0
#define PWMCLK_PCLK1                    _PWMCLK.Bits.PCLK1
#define PWMCLK_PCLK2                    _PWMCLK.Bits.PCLK2
#define PWMCLK_PCLK3                    _PWMCLK.Bits.PCLK3
#define PWMCLK_PCLK4                    _PWMCLK.Bits.PCLK4
#define PWMCLK_PCLK5                    _PWMCLK.Bits.PCLK5
#define PWMCLK_PCLK6                    _PWMCLK.Bits.PCLK6
#define PWMCLK_PCLK7                    _PWMCLK.Bits.PCLK7

#define PWMCLK_PCLK0_MASK               1U
#define PWMCLK_PCLK1_MASK               2U
#define PWMCLK_PCLK2_MASK               4U
#define PWMCLK_PCLK3_MASK               8U
#define PWMCLK_PCLK4_MASK               16U
#define PWMCLK_PCLK5_MASK               32U
#define PWMCLK_PCLK6_MASK               64U
#define PWMCLK_PCLK7_MASK               128U


/*** PWMPRCLK - PWM Prescale Clock Select Register; 0x00000303 ***/
typedef union {
  byte Byte;
  struct {
    byte PCKA0       :1;                                       /* Prescaler Select for Clock A 0 */
    byte PCKA1       :1;                                       /* Prescaler Select for Clock A 1 */
    byte PCKA2       :1;                                       /* Prescaler Select for Clock A 2 */
    byte             :1; 
    byte PCKB0       :1;    