/* Based on CPU DB MC9S12XHY256_112, version 3.00.000 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12xhy128.h
**     Processor : MC9S12XHY128CLM
**     FileFormat: V2.32
**     DataSheet : MC9S12XHY256RMV1 Rev. 0.11 06/2010
**     Compiler  : CodeWarrior compiler
**     Date/Time : 19.7.2010, 20:04
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 13.4.2010, V3.00.0:
**              - Corrected addresses of PIE1AD, PIF1AD registers.
**
**     File-Format-Revisions:
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12XHY128_H
#define _MC9S12XHY128_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vsi                119U
#define VectorNumber_Vsyscall           118U
#define VectorNumber_VReserved118       117U
#define VectorNumber_VReserved117       116U
#define VectorNumber_VReserved116       115U
#define VectorNumber_VReserved115       114U
#define VectorNumber_VReserved114       113U
#define VectorNumber_VReserved113       112U
#define VectorNumber_VReserved112       111U
#define VectorNumber_VReserved111       110U
#define VectorNumber_VReserved110       109U
#define VectorNumber_VReserved109       108U
#define VectorNumber_VReserved108       107U
#define VectorNumber_VReserved107       106U
#define VectorNumber_VReserved106       105U
#define VectorNumber_VReserved105       104U
#define VectorNumber_VReserved104       103U
#define VectorNumber_VReserved103       102U
#define VectorNumber_VReserved102       101U
#define VectorNumber_VReserved101       100U
#define VectorNumber_VReserved100       99U
#define VectorNumber_VReserved99        98U
#define VectorNumber_VReserved98        97U
#define VectorNumber_Vatdcompare        96U
#define VectorNumber_VReserved96        95U
#define VectorNumber_VReserved95        94U
#define VectorNumber_VReserved94        93U
#define VectorNumber_VReserved93        92U
#define VectorNumber_VReserved92        91U
#define VectorNumber_VReserved91        90U
#define VectorNumber_VReserved90        89U
#define VectorNumber_VReserved89        88U
#define VectorNumber_VReserved88        87U
#define VectorNumber_VReserved87        86U
#define VectorNumber_VReserved86        85U
#define VectorNumber_VReserved85        84U
#define VectorNumber_VReserved84        83U
#define VectorNumber_VReserved83        82U
#define VectorNumber_VReserved82        81U
#define VectorNumber_VReserved81        80U
#define VectorNumber_VReserved79        79U
#define VectorNumber_VReserved78        78U
#define VectorNumber_VReserved77        77U
#define VectorNumber_VReserved76        76U
#define VectorNumber_VReserved75        75U
#define VectorNumber_VReserved74        74U
#define VectorNumber_VReserved73        73U
#define VectorNumber_VReserved72        72U
#define VectorNumber_VReserved71        71U
#define VectorNumber_VReserved70        70U
#define VectorNumber_Vcan1tx            69U
#define VectorNumber_Vcan1rx            68U
#define VectorNumber_Vcan1err           67U
#define VectorNumber_Vcan1wkup          66U
#define VectorNumber_Vhti               65U
#define VectorNumber_Vapi               64U
#define VectorNumber_Vlvi               63U
#define VectorNumber_VReserved62        62U
#define VectorNumber_Vssd3              61U
#define VectorNumber_Vssd2              60U
#define VectorNumber_Vssd1              59U
#define VectorNumber_Vssd0              58U
#define VectorNumber_Vpwmesdn           57U
#define VectorNumber_Vportt             56U
#define VectorNumber_VReserved55        55U
#define VectorNumber_VReserved54        54U
#define VectorNumber_VReserved53        53U
#define VectorNumber_Vmctimovf          52U
#define VectorNumber_VReserved51        51U
#define VectorNumber_Vtim1paie          50U
#define VectorNumber_Vtim1paaovf        49U
#define VectorNumber_Vtim1ovf           48U
#define VectorNumber_Vtim1ch7           47U
#define VectorNumber_Vtim1ch6           46U
#define VectorNumber_Vtim1ch5           45U
#define VectorNumber_Vtim1ch4           44U
#define VectorNumber_Vtim1ch3           43U
#define VectorNumber_Vtim1ch2           42U
#define VectorNumber_Vtim1ch1           41U
#define VectorNumber_Vtim1ch0           40U
#define VectorNumber_Vcan0tx            39U
#define VectorNumber_Vcan0rx            38U
#define VectorNumber_Vcan0err           37U
#define VectorNumber_Vcan0wkup          36U
#define VectorNumber_Vflash             35U
#define VectorNumber_Vflashfd           34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_VReserved32        32U
#define VectorNumber_Viic               31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_Vcrgscm            29U
#define VectorNumber_Vcrgplllck         28U
#define VectorNumber_VReserved27        27U
#define VectorNumber_Vports             26U
#define VectorNumber_Vportr             25U
#define VectorNumber_Vportad            24U
#define VectorNumber_VReserved23        23U
#define VectorNumber_Vatd               22U
#define VectorNumber_Vsci1              21U
#define VectorNumber_Vsci0              20U
#define VectorNumber_Vspi               19U
#define VectorNumber_Vtim0paie          18U
#define VectorNumber_Vtim0paaovf        17U
#define VectorNumber_Vtim0ovf           16U
#define VectorNumber_Vtim0ch7           15U
#define VectorNumber_Vtim0ch6           14U
#define VectorNumber_Vtim0ch5           13U
#define VectorNumber_Vtim0ch4           12U
#define VectorNumber_Vtim0ch3           11U
#define VectorNumber_Vtim0ch2           10U
#define VectorNumber_Vtim0ch1           9U
#define VectorNumber_Vtim0ch0           8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Virq               6U
#define VectorNumber_Vxirq              5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define Vsi                             0xFF10U
#define Vsyscall                        0xFF12U
#define VReserved118                    0xFF14U
#define VReserved117                    0xFF16U
#define VReserved116                    0xFF18U
#define VReserved115                    0xFF1AU
#define VReserved114                    0xFF1CU
#define VReserved113                    0xFF1EU
#define VReserved112                    0xFF20U
#define VReserved111                    0xFF22U
#define VReserved110                    0xFF24U
#define VReserved109                    0xFF26U
#define VReserved108                    0xFF28U
#define VReserved107                    0xFF2AU
#define VReserved106                    0xFF2CU
#define VReserved105                    0xFF2EU
#define VReserved104                    0xFF30U
#define VReserved103                    0xFF32U
#define VReserved102                    0xFF34U
#define VReserved101                    0xFF36U
#define VReserved100                    0xFF38U
#define VReserved99                     0xFF3AU
#define VReserved98                     0xFF3CU
#define Vatdcompare                     0xFF3EU
#define VReserved96                     0xFF40U
#define VReserved95                     0xFF42U
#define VReserved94                     0xFF44U
#define VReserved93                     0xFF46U
#define VReserved92                     0xFF48U
#define VReserved91                     0xFF4AU
#define VReserved90                     0xFF4CU
#define VReserved89                     0xFF4EU
#define VReserved88                     0xFF50U
#define VReserved87                     0xFF52U
#define VReserved86                     0xFF54U
#define VReserved85                     0xFF56U
#define VReserved84                     0xFF58U
#define VReserved83                     0xFF5AU
#define VReserved82                     0xFF5CU
#define VReserved81                     0xFF5EU
#define VReserved79                     0xFF60U
#define VReserved78                     0xFF62U
#define VReserved77                     0xFF64U
#define VReserved76                     0xFF66U
#define VReserved75                     0xFF68U
#define VReserved74                     0xFF6AU
#define VReserved73                     0xFF6CU
#define VReserved72                     0xFF6EU
#define VReserved71                     0xFF70U
#define VReserved70                     0xFF72U
#define Vcan1tx                         0xFF74U
#define Vcan1rx                         0xFF76U
#define Vcan1err                        0xFF78U
#define Vcan1wkup                       0xFF7AU
#define Vhti                            0xFF7CU
#define Vapi                            0xFF7EU
#define Vlvi                            0xFF80U
#define VReserved62                     0xFF82U
#define Vssd3                           0xFF84U
#define Vssd2                           0xFF86U
#define Vssd1                           0xFF88U
#define Vssd0                           0xFF8AU
#define Vpwmesdn                        0xFF8CU
#define Vportt                          0xFF8EU
#define VReserved55                     0xFF90U
#define VReserved54                     0xFF92U
#define VReserved53                     0xFF94U
#define Vmctimovf                       0xFF96U
#define VReserved51                     0xFF98U
#define Vtim1paie                       0xFF9AU
#define Vtim1paaovf                     0xFF9CU
#define Vtim1ovf                        0xFF9EU
#define Vtim1ch7                        0xFFA0U
#define Vtim1ch6                        0xFFA2U
#define Vtim1ch5                        0xFFA4U
#define Vtim1ch4                        0xFFA6U
#define Vtim1ch3                        0xFFA8U
#define Vtim1ch2                        0xFFAAU
#define Vtim1ch1                        0xFFACU
#define Vtim1ch0                        0xFFAEU
#define Vcan0tx                         0xFFB0U
#define Vcan0rx                         0xFFB2U
#define Vcan0err                        0xFFB4U
#define Vcan0wkup                       0xFFB6U
#define Vflash                          0xFFB8U
#define Vflashfd                        0xFFBAU
#define VReserved33                     0xFFBCU
#define VReserved32                     0xFFBEU
#define Viic                            0xFFC0U
#define VReserved30                     0xFFC2U
#define Vcrgscm                         0xFFC4U
#define Vcrgplllck                      0xFFC6U
#define VReserved27                     0xFFC8U
#define Vports                          0xFFCAU
#define Vportr                          0xFFCCU
#define Vportad                         0xFFCEU
#define VReserved23                     0xFFD0U
#define Vatd                            0xFFD2U
#define Vsci1                           0xFFD4U
#define Vsci0                           0xFFD6U
#define Vspi                            0xFFD8U
#define Vtim0paie                       0xFFDAU
#define Vtim0paaovf                     0xFFDCU
#define Vtim0ovf                        0xFFDEU
#define Vtim0ch7                        0xFFE0U
#define Vtim0ch6                        0xFFE2U
#define Vtim0ch5                        0xFFE4U
#define Vtim0ch4                        0xFFE6U
#define Vtim0ch3                        0xFFE8U
#define Vtim0ch2                        0xFFEAU
#define Vtim0ch1                        0xFFECU
#define Vtim0ch0                        0xFFEEU
#define Vrti                            0xFFF0U
#define Virq                            0xFFF2U
#define Vxirq                           0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTAB - Port AB Data Register; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Data Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte PA0         :1;                                       /* Port A Bit 0 */
        byte PA1         :1;                                       /* Port A Bit 1 */
        byte PA2         :1;                                       /* Port A Bit 2 */
        byte PA3         :1;                                       /* Port A Bit 3 */
        byte PA4         :1;                                       /* Port A Bit 4 */
        byte PA5         :1;                                       /* Port A Bit 5 */
        byte PA6         :1;                                       /* Port A Bit 6 */
        byte PA7         :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_PA0                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA0
    #define PORTA_PA1                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA1
    #define PORTA_PA2                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA2
    #define PORTA_PA3                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA3
    #define PORTA_PA4                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA4
    #define PORTA_PA5                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA5
    #define PORTA_PA6                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA6
    #define PORTA_PA7                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA7
    
    #define PORTA_PA0_MASK              1U
    #define PORTA_PA1_MASK              2U
    #define PORTA_PA2_MASK              4U
    #define PORTA_PA3_MASK              8U
    #define PORTA_PA4_MASK              16U
    #define PORTA_PA5_MASK              32U
    #define PORTA_PA6_MASK              64U
    #define PORTA_PA7_MASK              128U
    

    /*** PORTB - Port B Data Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte PB0         :1;                                       /* Port B Bit 0 */
        byte PB1         :1;                                       /* Port B Bit 1 */
        byte PB2         :1;                                       /* Port B Bit 2 */
        byte PB3         :1;                                       /* Port B Bit 3 */
        byte PB4         :1;                                       /* Port B Bit 4 */
        byte PB5         :1;                                       /* Port B Bit 5 */
        byte PB6         :1;                                       /* Port B Bit 6 */
        byte PB7         :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_PB0                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB0
    #define PORTB_PB1                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB1
    #define PORTB_PB2                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB2
    #define PORTB_PB3                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB3
    #define PORTB_PB4                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB4
    #define PORTB_PB5                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB5
    #define PORTB_PB6                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB6
    #define PORTB_PB7                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB7
    
    #define PORTB_PB0_MASK              1U
    #define PORTB_PB1_MASK              2U
    #define PORTB_PB2_MASK              4U
    #define PORTB_PB3_MASK              8U
    #define PORTB_PB4_MASK              16U
    #define PORTB_PB5_MASK              32U
    #define PORTB_PB6_MASK              64U
    #define PORTB_PB7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PB0         :1;                                       /* Port B Bit 0 */
    word PB1         :1;                                       /* Port B Bit 1 */
    word PB2         :1;                                       /* Port B Bit 2 */
    word PB3         :1;                                       /* Port B Bit 3 */
    word PB4         :1;                                       /* Port B Bit 4 */
    word PB5         :1;                                       /* Port B Bit 5 */
    word PB6         :1;                                       /* Port B Bit 6 */
    word PB7         :1;                                       /* Port B Bit 7 */
    word PA0         :1;                                       /* Port A Bit 0 */
    word PA1         :1;                                       /* Port A Bit 1 */
    word PA2         :1;                                       /* Port A Bit 2 */
    word PA3         :1;                                       /* Port A Bit 3 */
    word PA4         :1;                                       /* Port A Bit 4 */
    word PA5         :1;                                       /* Port A Bit 5 */
    word PA6         :1;                                       /* Port A Bit 6 */
    word PA7         :1;                                       /* Port A Bit 7 */
  } Bits;
  struct {
    word grpPB   :8;
    word grpPA   :8;
  } MergedBits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000UL);
#define PORTAB                          _PORTAB.Word
#define PORTAB_PB0                      _PORTAB.Bits.PB0
#define PORTAB_PB1                      _PORTAB.Bits.PB1
#define PORTAB_PB2                      _PORTAB.Bits.PB2
#define PORTAB_PB3                      _PORTAB.Bits.PB3
#define PORTAB_PB4                      _PORTAB.Bits.PB4
#define PORTAB_PB5                      _PORTAB.Bits.PB5
#define PORTAB_PB6                      _PORTAB.Bits.PB6
#define PORTAB_PB7                      _PORTAB.Bits.PB7
#define PORTAB_PA0                      _PORTAB.Bits.PA0
#define PORTAB_PA1                      _PORTAB.Bits.PA1
#define PORTAB_PA2                      _PORTAB.Bits.PA2
#define PORTAB_PA3                      _PORTAB.Bits.PA3
#define PORTAB_PA4                      _PORTAB.Bits.PA4
#define PORTAB_PA5                      _PORTAB.Bits.PA5
#define PORTAB_PA6                      _PORTAB.Bits.PA6
#define PORTAB_PA7                      _PORTAB.Bits.PA7
#define PORTAB_PB                       _PORTAB.MergedBits.grpPB
#define PORTAB_PA                       _PORTAB.MergedBits.grpPA

#define PORTAB_PB0_MASK                 1U
#define PORTAB_PB1_MASK                 2U
#define PORTAB_PB2_MASK                 4U
#define PORTAB_PB3_MASK                 8U
#define PORTAB_PB4_MASK                 16U
#define PORTAB_PB5_MASK                 32U
#define PORTAB_PB6_MASK                 64U
#define PORTAB_PB7_MASK                 128U
#define PORTAB_PA0_MASK                 256U
#define PORTAB_PA1_MASK                 512U
#define PORTAB_PA2_MASK                 1024U
#define PORTAB_PA3_MASK                 2048U
#define PORTAB_PA4_MASK                 4096U
#define PORTAB_PA5_MASK                 8192U
#define PORTAB_PA6_MASK                 16384U
#define PORTAB_PA7_MASK                 32768U
#define PORTAB_PB_MASK                  255U
#define PORTAB_PB_BITNUM                0U
#define PORTAB_PA_MASK                  65280U
#define PORTAB_PA_BITNUM                8U


/*** DDRAB - Port AB Data Direction Register; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
        byte DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
        byte DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
        byte DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
        byte DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
        byte DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
        byte DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
        byte DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_DDRA0                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA0
    #define DDRA_DDRA1                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA1
    #define DDRA_DDRA2                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA2
    #define DDRA_DDRA3                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA3
    #define DDRA_DDRA4                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA4
    #define DDRA_DDRA5                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA5
    #define DDRA_DDRA6                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA6
    #define DDRA_DDRA7                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA7
    
    #define DDRA_DDRA0_MASK             1U
    #define DDRA_DDRA1_MASK             2U
    #define DDRA_DDRA2_MASK             4U
    #define DDRA_DDRA3_MASK             8U
    #define DDRA_DDRA4_MASK             16U
    #define DDRA_DDRA5_MASK             32U
    #define DDRA_DDRA6_MASK             64U
    #define DDRA_DDRA7_MASK             128U
    

    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
        byte DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
        byte DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
        byte DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
        byte DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
        byte DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
        byte DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
        byte DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_DDRB0                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB0
    #define DDRB_DDRB1                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB1
    #define DDRB_DDRB2                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB2
    #define DDRB_DDRB3                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB3
    #define DDRB_DDRB4                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB4
    #define DDRB_DDRB5                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB5
    #define DDRB_DDRB6                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB6
    #define DDRB_DDRB7                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB7
    
    #define DDRB_DDRB0_MASK             1U
    #define DDRB_DDRB1_MASK             2U
    #define DDRB_DDRB2_MASK             4U
    #define DDRB_DDRB3_MASK             8U
    #define DDRB_DDRB4_MASK             16U
    #define DDRB_DDRB5_MASK             32U
    #define DDRB_DDRB6_MASK             64U
    #define DDRB_DDRB7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
    word DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
    word DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
    word DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
    word DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
    word DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
    word DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
    word DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
    word DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
    word DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
    word DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
    word DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
    word DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
    word DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
    word DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
    word DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
  struct {
    word grpDDRB :8;
    word grpDDRA :8;
  } MergedBits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002UL);
#define DDRAB                           _DDRAB.Word
#define DDRAB_DDRB0                     _DDRAB.Bits.DDRB0
#define DDRAB_DDRB1                     _DDRAB.Bits.DDRB1
#define DDRAB_DDRB2                     _DDRAB.Bits.DDRB2
#define DDRAB_DDRB3                     _DDRAB.Bits.DDRB3
#define DDRAB_DDRB4                     _DDRAB.Bits.DDRB4
#define DDRAB_DDRB5                     _DDRAB.Bits.DDRB5
#define DDRAB_DDRB6                     _DDRAB.Bits.DDRB6
#define DDRAB_DDRB7                     _DDRAB.Bits.DDRB7
#define DDRAB_DDRA0                     _DDRAB.Bits.DDRA0
#define DDRAB_DDRA1                     _DDRAB.Bits.DDRA1
#define DDRAB_DDRA2                     _DDRAB.Bits.DDRA2
#define DDRAB_DDRA3                     _DDRAB.Bits.DDRA3
#define DDRAB_DDRA4                     _DDRAB.Bits.DDRA4
#define DDRAB_DDRA5                     _DDRAB.Bits.DDRA5
#define DDRAB_DDRA6                     _DDRAB.Bits.DDRA6
#define DDRAB_DDRA7                     _DDRAB.Bits.DDRA7
#define DDRAB_DDRB                      _DDRAB.MergedBits.grpDDRB
#define DDRAB_DDRA                      _DDRAB.MergedBits.grpDDRA

#define DDRAB_DDRB0_MASK                1U
#define DDRAB_DDRB1_MASK                2U
#define DDRAB_DDRB2_MASK                4U
#define DDRAB_DDRB3_MASK                8U
#define DDRAB_DDRB4_MASK                16U
#define DDRAB_DDRB5_MASK                32U
#define DDRAB_DDRB6_MASK                64U
#define DDRAB_DDRB7_MASK                128U
#define DDRAB_DDRA0_MASK                256U
#define DDRAB_DDRA1_MASK                512U
#define DDRAB_DDRA2_MASK                1024U
#define DDRAB_DDRA3_MASK                2048U
#define DDRAB_DDRA4_MASK                4096U
#define DDRAB_DDRA5_MASK                8192U
#define DDRAB_DDRA6_MASK                16384U
#define DDRAB_DDRA7_MASK                32768U
#define DDRAB_DDRB_MASK                 255U
#define DDRAB_DDRB_BITNUM               0U
#define DDRAB_DDRA_MASK                 65280U
#define DDRAB_DDRA_BITNUM               8U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODC        :1;                                       /* Mode Select Bit */
  } Bits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_MODC                       _MODE.Bits.MODC

#define MODE_MODC_MASK                  128U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-up Port B Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BKPUE       :1;                                       /* BKGD and VREGEN Pin Pull-up Enable */
    byte             :1; 
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_BKPUE                      _PUCR.Bits.BKPUE

#define PUCR_PUPAE_MASK                 1U
#define PUCR_PUPBE_MASK                 2U
#define PUCR_BKPUE_MASK                 64U


/*** GPAGE - Global Page Index Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte GP0         :1;                                       /* Global Page Index Bit 0 */
    byte GP1         :1;                                       /* Global Page Index Bit 1 */
    byte GP2         :1;                                       /* Global Page Index Bit 2 */
    byte GP3         :1;                                       /* Global Page Index Bit 3 */
    byte GP4         :1;                                       /* Global Page Index Bit 4 */
    byte GP5         :1;                                       /* Global Page Index Bit 5 */
    byte GP6         :1;                                       /* Global Page Index Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpGP   :7;
    byte         :1;
  } MergedBits;
} GPAGESTR;
extern volatile GPAGESTR _GPAGE @(REG_BASE + 0x00000010UL);
#define GPAGE                           _GPAGE.Byte
#define GPAGE_GP0                       _GPAGE.Bits.GP0
#define GPAGE_GP1                       _GPAGE.Bits.GP1
#define GPAGE_GP2                       _GPAGE.Bits.GP2
#define GPAGE_GP3                       _GPAGE.Bits.GP3
#define GPAGE_GP4                       _GPAGE.Bits.GP4
#define GPAGE_GP5                       _GPAGE.Bits.GP5
#define GPAGE_GP6                       _GPAGE.Bits.GP6
#define GPAGE_GP                        _GPAGE.MergedBits.grpGP

#define GPAGE_GP0_MASK                  1U
#define GPAGE_GP1_MASK                  2U
#define GPAGE_GP2_MASK                  4U
#define GPAGE_GP3_MASK                  8U
#define GPAGE_GP4_MASK                  16U
#define GPAGE_GP5_MASK                  32U
#define GPAGE_GP6_MASK                  64U
#define GPAGE_GP_MASK                   127U
#define GPAGE_GP_BITNUM                 0U


/*** DIRECT - Direct Page Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Index Bit 8 */
    byte DP9         :1;                                       /* Direct Page Index Bit 9 */
    byte DP10        :1;                                       /* Direct Page Index Bit 10 */
    byte DP11        :1;                                       /* Direct Page Index Bit 11 */
    byte DP12        :1;                                       /* Direct Page Index Bit 12 */
    byte DP13        :1;                                       /* Direct Page Index Bit 13 */
    byte DP14        :1;                                       /* Direct Page Index Bit 14 */
    byte DP15        :1;                                       /* Direct Page Index Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000011UL);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1U
#define DIRECT_DP9_MASK                 2U
#define DIRECT_DP10_MASK                4U
#define DIRECT_DP11_MASK                8U
#define DIRECT_DP12_MASK                16U
#define DIRECT_DP13_MASK                32U
#define DIRECT_DP14_MASK                64U
#define DIRECT_DP15_MASK                128U


/*** MMCCTL1 - MMC Control Register; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PGMIFRON    :1;                                       /* Program Flash Information Row (IFR) visible in the global memory map */
    byte DFIFRON     :1;                                       /* Data Flash Information Row (IFR) visible in the global memory map */
    byte             :1; 
    byte MGRAMON     :1;                                       /* Flash Memory Controller SCRATCH RAM visible in the global memory map */
  } Bits;
} MMCCTL1STR;
extern volatile MMCCTL1STR _MMCCTL1 @(REG_BASE + 0x00000013UL);
#define MMCCTL1                         _MMCCTL1.Byte
#define MMCCTL1_PGMIFRON                _MMCCTL1.Bits.PGMIFRON
#define MMCCTL1_DFIFRON                 _MMCCTL1.Bits.DFIFRON
#define MMCCTL1_MGRAMON                 _MMCCTL1.Bits.MGRAMON

#define MMCCTL1_PGMIFRON_MASK           16U
#define MMCCTL1_DFIFRON_MASK            32U
#define MMCCTL1_MGRAMON_MASK            128U


/*** PPAGE - Program Page Index Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte PIX4        :1;                                       /* Program Page Index Bit 4 */
    byte PIX5        :1;                                       /* Program Page Index Bit 5 */
    byte PIX6        :1;                                       /* Program Page Index Bit 6 */
    byte PIX7        :1;                                       /* Program Page Index Bit 7 */
  } Bits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000015UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX6                      _PPAGE.Bits.PIX6
#define PPAGE_PIX7                      _PPAGE.Bits.PIX7

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX4_MASK                 16U
#define PPAGE_PIX5_MASK                 32U
#define PPAGE_PIX6_MASK                 64U
#define PPAGE_PIX7_MASK                 128U


/*** RPAGE - RAM Page Index Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte RP0         :1;                                       /* RAM Page Index Bit 0 */
    byte RP1         :1;                                       /* RAM Page Index Bit 1 */
    byte RP2         :1;                                       /* RAM Page Index Bit 2 */
    byte RP3         :1;                                       /* RAM Page Index Bit 3 */
    byte RP4         :1;                                       /* RAM Page Index Bit 4 */
    byte RP5         :1;                                       /* RAM Page Index Bit 5 */
    byte RP6         :1;                                       /* RAM Page Index Bit 6 */
    byte RP7         :1;                                       /* RAM Page Index Bit 7 */
  } Bits;
} RPAGESTR;
extern volatile RPAGESTR _RPAGE @(REG_BASE + 0x00000016UL);
#define RPAGE                           _RPAGE.Byte
#define RPAGE_RP0                       _RPAGE.Bits.RP0
#define RPAGE_RP1                       _RPAGE.Bits.RP1
#define RPAGE_RP2                       _RPAGE.Bits.RP2
#define RPAGE_RP3                       _RPAGE.Bits.RP3
#define RPAGE_RP4                       _RPAGE.Bits.RP4
#define RPAGE_RP5                       _RPAGE.Bits.RP5
#define RPAGE_RP6                       _RPAGE.Bits.RP6
#define RPAGE_RP7                       _RPAGE.Bits.RP7

#define RPAGE_RP0_MASK                  1U
#define RPAGE_RP1_MASK                  2U
#define RPAGE_RP2_MASK                  4U
#define RPAGE_RP3_MASK                  8U
#define RPAGE_RP4_MASK                  16U
#define RPAGE_RP5_MASK                  32U
#define RPAGE_RP6_MASK                  64U
#define RPAGE_RP7_MASK                  128U


/*** EPAGE - Data FLASH Page Index Register; 0x00000017 ***/
typedef union {
  byte Byte;
  struct {
    byte EP0         :1;                                       /* Data FLASH Page Index Bit 0 */
    byte EP1         :1;                                       /* Data FLASH Page Index Bit 1 */
    byte EP2         :1;                                       /* Data FLASH Page Index Bit 2 */
    byte EP3         :1;                                       /* Data FLASH Page Index Bit 3 */
    byte EP4         :1;                                       /* Data FLASH Page Index Bit 4 */
    byte EP5         :1;                                       /* Data FLASH Page Index Bit 5 */
    byte EP6         :1;                                       /* Data FLASH Page Index Bit 6 */
    byte EP7         :1;                                       /* Data FLASH Page Index Bit 7 */
  } Bits;
} EPAGESTR;
extern volatile EPAGESTR _EPAGE @(REG_BASE + 0x00000017UL);
#define EPAGE                           _EPAGE.Byte
#define EPAGE_EP0                       _EPAGE.Bits.EP0
#define EPAGE_EP1                       _EPAGE.Bits.EP1
#define EPAGE_EP2                       _EPAGE.Bits.EP2
#define EPAGE_EP3                       _EPAGE.Bits.EP3
#define EPAGE_EP4                       _EPAGE.Bits.EP4
#define EPAGE_EP5                       _EPAGE.Bits.EP5
#define EPAGE_EP6                       _EPAGE.Bits.EP6
#define EPAGE_EP7                       _EPAGE.Bits.EP7

#define EPAGE_EP0_MASK                  1U
#define EPAGE_EP1_MASK                  2U
#define EPAGE_EP2_MASK                  4U
#define EPAGE_EP3_MASK                  8U
#define EPAGE_EP4_MASK                  16U
#define EPAGE_EP5_MASK                  32U
#define EPAGE_EP6_MASK                  64U
#define EPAGE_EP7_MASK                  128U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** ECLKCTL - ECLK Control Register; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* Free-running ECLK Divider, bit 0 */
    byte EDIV1       :1;                                       /* Free-running ECLK Divider, bit 1 */
    byte EDIV2       :1;                                       /* Free-running ECLK Divider, bit 2 */
    byte EDIV3       :1;                                       /* Free-running ECLK Divider, bit 3 */
    byte EDIV4       :1;                                       /* Free-running ECLK Divider, bit 4 */
    byte DIV16       :1;                                       /* Free-running ECLK predivider */
    byte             :1; 
    byte NECLK       :1;                                       /* No ECLK */
  } Bits;
  struct {
    byte grpEDIV :5;
    byte grpDIV_16 :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ECLKCTLSTR;
extern volatile ECLKCTLSTR _ECLKCTL @(REG_BASE + 0x0000001CUL);
#define ECLKCTL                         _ECLKCTL.Byte
#define ECLKCTL_EDIV0                   _ECLKCTL.Bits.EDIV0
#define ECLKCTL_EDIV1                   _ECLKCTL.Bits.EDIV1
#define ECLKCTL_EDIV2                   _ECLKCTL.Bits.EDIV2
#define ECLKCTL_EDIV3                   _ECLKCTL.Bits.EDIV3
#define ECLKCTL_EDIV4                   _ECLKCTL.Bits.EDIV4
#define ECLKCTL_DIV16                   _ECLKCTL.Bits.DIV16
#define ECLKCTL_NECLK                   _ECLKCTL.Bits.NECLK
#define ECLKCTL_EDIV                    _ECLKCTL.MergedBits.grpEDIV

#define ECLKCTL_EDIV0_MASK              1U
#define ECLKCTL_EDIV1_MASK              2U
#define ECLKCTL_EDIV2_MASK              4U
#define ECLKCTL_EDIV3_MASK              8U
#define ECLKCTL_EDIV4_MASK              16U
#define ECLKCTL_DIV16_MASK              32U
#define ECLKCTL_NECLK_MASK              128U
#define ECLKCTL_EDIV_MASK               31U
#define ECLKCTL_EDIV_BITNUM             0U


/*** IRQCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte XIRQEN      :1;                                       /* XIRQ Enable */
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} IRQCRSTR;
extern volatile IRQCRSTR _IRQCR @(REG_BASE + 0x0000001EUL);
#define IRQCR                           _IRQCR.Byte
#define IRQCR_XIRQEN                    _IRQCR.Bits.XIRQEN
#define IRQCR_IRQEN                     _IRQCR.Bits.IRQEN
#define IRQCR_IRQE                      _IRQCR.Bits.IRQE

#define IRQCR_XIRQEN_MASK               32U
#define IRQCR_IRQEN_MASK                64U
#define IRQCR_IRQE_MASK                 128U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte COMRV       :2;                                       /* Comparator Register Visibility Bits */
    byte             :1; 
    byte DBGBRK      :1;                                       /* S12XDBG Breakpoint Enable Bit 1 */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte             :1; 
    byte TRIG        :1;                                       /* Immediate Trigger Request Bit */
    byte ARM         :1;                                       /* Arm Bit */
  } Bits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_COMRV                     _DBGC1.Bits.COMRV
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BDM                       _DBGC1.Bits.BDM
#define DBGC1_TRIG                      _DBGC1.Bits.TRIG
#define DBGC1_ARM                       _DBGC1.Bits.ARM

#define DBGC1_COMRV_MASK                3U
#define DBGC1_COMRV_BITNUM              0U
#define DBGC1_DBGBRK_MASK               8U
#define DBGC1_BDM_MASK                  16U
#define DBGC1_TRIG_MASK                 64U
#define DBGC1_ARM_MASK                  128U


/*** DBGSR - Debug Status Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSF0        :1;                                       /* State Sequencer Flag Bits */
    byte SSF1        :1;                                       /* State Sequencer Flag Bit 1 */
    byte SSF2        :1;                                       /* State Sequencer Flag Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpSSF  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSRSTR;
extern volatile DBGSRSTR _DBGSR @(REG_BASE + 0x00000021UL);
#define DBGSR                           _DBGSR.Byte
#define DBGSR_SSF0                      _DBGSR.Bits.SSF0
#define DBGSR_SSF1                      _DBGSR.Bits.SSF1
#define DBGSR_SSF2                      _DBGSR.Bits.SSF2
#define DBGSR_TBF                       _DBGSR.Bits.TBF
#define DBGSR_SSF                       _DBGSR.MergedBits.grpSSF

#define DBGSR_SSF0_MASK                 1U
#define DBGSR_SSF1_MASK                 2U
#define DBGSR_SSF2_MASK                 4U
#define DBGSR_TBF_MASK                  128U
#define DBGSR_SSF_MASK                  7U
#define DBGSR_SSF_BITNUM                0U


/*** DBGTCR - Debug Trace Control Register; 0x00000022 ***/
typedef union {
  byte Byte;
  struct {
    byte TALIGN      :2;                                       /* Trigger Align Bits */
    byte TRCMOD      :2;                                       /* Trace Mode Bits */
    byte TRANGE      :2;                                       /* Trace Range Bits */
    byte TSOURCE     :1;                                       /* Trace Source Control Bits */
    byte             :1; 
  } Bits;
} DBGTCRSTR;
extern volatile DBGTCRSTR _DBGTCR @(REG_BASE + 0x00000022UL);
#define DBGTCR                          _DBGTCR.Byte
#define DBGTCR_TALIGN                   _DBGTCR.Bits.TALIGN
#define DBGTCR_TRCMOD                   _DBGTCR.Bits.TRCMOD
#define DBGTCR_TRANGE                   _DBGTCR.Bits.TRANGE
#define DBGTCR_TSOURCE                  _DBGTCR.Bits.TSOURCE

#define DBGTCR_TALIGN_MASK              3U
#define DBGTCR_TALIGN_BITNUM            0U
#define DBGTCR_TRCMOD_MASK              12U
#define DBGTCR_TRCMOD_BITNUM            2U
#define DBGTCR_TRANGE_MASK              48U
#define DBGTCR_TRANGE_BITNUM            4U
#define DBGTCR_TSOURCE_MASK             64U


/*** DBGC2 - Debug Control Register 2; 0x00000023 ***/
typedef union {
  byte Byte;
  struct {
    byte ABCM        :2;                                       /* A and B Comparator Match Control */
    byte CDCM        :2;                                       /* C and D Comparator Match Control */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000023UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_ABCM                      _DBGC2.Bits.ABCM
#define DBGC2_CDCM                      _DBGC2.Bits.CDCM

#define DBGC2_ABCM_MASK                 3U
#define DBGC2_ABCM_BITNUM               0U
#define DBGC2_CDCM_MASK                 12U
#define DBGC2_CDCM_BITNUM               2U


/*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Trace Buffer Data Bits */
        byte BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
        byte BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
        byte BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
        byte BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
        byte BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
        byte BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
        byte BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Trace Buffer Data Bits */
        byte BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
        byte BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
        byte BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
        byte BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
        byte BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
        byte BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
        byte BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Trace Buffer Data Bits */
    word BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
    word BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
    word BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
    word BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
    word BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
    word BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
    word BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
    word BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
    word BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
    word BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
    word BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
    word BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
    word BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
    word BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
    word BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000024UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000026 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT         :7;                                       /* Count Value */
    byte             :1; 
  } Bits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000026UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT                      _DBGCNT.Bits.CNT

#define DBGCNT_CNT_MASK                 127U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGSCRX - Debug State Control Register; 0x00000027 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** DBGSCRX - Debug State Control Register; Several registers at the same address ***/
    union {
      struct {
        byte SC0         :1;                                       /* State X Sequencer Next State Selection Bit 0 */
        byte SC1         :1;                                       /* State X Sequencer Next State Selection Bit 1 */
        byte SC2         :1;                                       /* State X Sequencer Next State Selection Bit 2 */
        byte SC3         :1;                                       /* State X Sequencer Next State Selection Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGSCRXSTR;
    #define DBGSCRX                     _DBGSCRX.Byte
    #define DBGSCRX_SC0                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC0
    #define DBGSCRX_SC1                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC1
    #define DBGSCRX_SC2                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC2
    #define DBGSCRX_SC3                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC3
    #define DBGSCRX_SC                  _DBGSCRX.SameAddr_STR.DBGSCRXSTR.MergedBits.grpSC
    
    #define DBGSCRX_SC0_MASK            1U
    #define DBGSCRX_SC1_MASK            2U
    #define DBGSCRX_SC2_MASK            4U
    #define DBGSCRX_SC3_MASK            8U
    #define DBGSCRX_SC_MASK             15U
    #define DBGSCRX_SC_BITNUM           0U
    
    /*** DBGMFR - Debug Match Flag Register; Several registers at the same address ***/
    union {
      struct {
        byte MC0         :1;                                       /* Debug Match Flag Bit 0 */
        byte MC1         :1;                                       /* Debug Match Flag Bit 1 */
        byte MC2         :1;                                       /* Debug Match Flag Bit 2 */
        byte MC3         :1;                                       /* Debug Match Flag Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpMC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGMFRSTR;
    #define DBGMFR                      _DBGSCRX.Byte
    #define DBGMFR_MC0                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC0
    #define DBGMFR_MC1                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC1
    #define DBGMFR_MC2                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC2
    #define DBGMFR_MC3                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC3
    #define DBGMFR_MC                   _DBGSCRX.SameAddr_STR.DBGMFRSTR.MergedBits.grpMC
    
    #define DBGMFR_MC0_MASK             1U
    #define DBGMFR_MC1_MASK             2U
    #define DBGMFR_MC2_MASK             4U
    #define DBGMFR_MC3_MASK             8U
    #define DBGMFR_MC_MASK              15U
    #define DBGMFR_MC_BITNUM            0U
    
  } SameAddr_STR; /*Several registers at the same address */

} DBGSCRXSTR;
extern volatile DBGSCRXSTR _DBGSCRX @(REG_BASE + 0x00000027UL);


/*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte COMPE       :1;                                       /* Determines if comparator is enabled */
    byte             :1; 
    byte RWE         :1;                                       /* Read/Write Enable Bit */
    byte RW          :1;                                       /* Read/Write Comparator Value Bit */
    byte BRK         :1;                                       /* Break */
    byte TAG         :1;                                       /* Tag Select */
    byte NDB_SZ      :1;                                       /* Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D) */
    byte SZE         :1;                                       /* Size Comparator Enable Bit */
  } Bits;
} DBGXCTLSTR;
extern volatile DBGXCTLSTR _DBGXCTL @(REG_BASE + 0x00000028UL);
#define DBGXCTL                         _DBGXCTL.Byte
#define DBGXCTL_COMPE                   _DBGXCTL.Bits.COMPE
#define DBGXCTL_RWE                     _DBGXCTL.Bits.RWE
#define DBGXCTL_RW                      _DBGXCTL.Bits.RW
#define DBGXCTL_BRK                     _DBGXCTL.Bits.BRK
#define DBGXCTL_TAG                     _DBGXCTL.Bits.TAG
#define DBGXCTL_NDB_SZ                  _DBGXCTL.Bits.NDB_SZ
#define DBGXCTL_SZE                     _DBGXCTL.Bits.SZE

#define DBGXCTL_COMPE_MASK              1U
#define DBGXCTL_RWE_MASK                4U
#define DBGXCTL_RW_MASK                 8U
#define DBGXCTL_BRK_MASK                16U
#define DBGXCTL_TAG_MASK                32U
#define DBGXCTL_NDB_SZ_MASK             64U
#define DBGXCTL_SZE_MASK                128U


/*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT16       :1;                                       /* Comparator Address High Compare Bits */
    byte BIT17       :1;                                       /* Comparator Address High Compare Bit 17 */
    byte BIT18       :1;                                       /* Comparator Address High Compare Bit 18 */
    byte BIT19       :1;                                       /* Comparator Address High Compare Bit 19 */
    byte BIT20       :1;                                       /* Comparator Address High Compare Bit 20 */
    byte BIT21       :1;                                       /* Comparator Address High Compare Bit 21 */
    byte BIT22       :1;                                       /* Comparator Address High Compare Bit 22 */
    byte             :1; 
  } Bits;
  struct {
    byte grpBIT_16 :7;
    byte         :1;
  } MergedBits;
} DBGXAHSTR;
extern volatile DBGXAHSTR _DBGXAH @(REG_BASE + 0x00000029UL);
#define DBGXAH                          _DBGXAH.Byte
#define DBGXAH_BIT16                    _DBGXAH.Bits.BIT16
#define DBGXAH_BIT17                    _DBGXAH.Bits.BIT17
#define DBGXAH_BIT18                    _DBGXAH.Bits.BIT18
#define DBGXAH_BIT19                    _DBGXAH.Bits.BIT19
#define DBGXAH_BIT20                    _DBGXAH.Bits.BIT20
#define DBGXAH_BIT21                    _DBGXAH.Bits.BIT21
#define DBGXAH_BIT22                    _DBGXAH.Bits.BIT22
#define DBGXAH_BIT_16                   _DBGXAH.MergedBits.grpBIT_16
#define DBGXAH_BIT                      DBGXAH_BIT_16

#define DBGXAH_BIT16_MASK               1U
#define DBGXAH_BIT17_MASK               2U
#define DBGXAH_BIT18_MASK               4U
#define DBGXAH_BIT19_MASK               8U
#define DBGXAH_BIT20_MASK               16U
#define DBGXAH_BIT21_MASK               32U
#define DBGXAH_BIT22_MASK               64U
#define DBGXAH_BIT_16_MASK              127U
#define DBGXAH_BIT_16_BITNUM            0U


/*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Address Mid Compare Bits */
    byte BIT9        :1;                                       /* Comparator Address Mid Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Address Mid Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Address Mid Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Address Mid Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Address Mid Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Address Mid Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Address Mid Compare Bit 15 */
  } Bits;
} DBGXAMSTR;
extern volatile DBGXAMSTR _DBGXAM @(REG_BASE + 0x0000002AUL);
#define DBGXAM                          _DBGXAM.Byte
#define DBGXAM_BIT8                     _DBGXAM.Bits.BIT8
#define DBGXAM_BIT9                     _DBGXAM.Bits.BIT9
#define DBGXAM_BIT10                    _DBGXAM.Bits.BIT10
#define DBGXAM_BIT11                    _DBGXAM.Bits.BIT11
#define DBGXAM_BIT12                    _DBGXAM.Bits.BIT12
#define DBGXAM_BIT13                    _DBGXAM.Bits.BIT13
#define DBGXAM_BIT14                    _DBGXAM.Bits.BIT14
#define DBGXAM_BIT15                    _DBGXAM.Bits.BIT15

#define DBGXAM_BIT8_MASK                1U
#define DBGXAM_BIT9_MASK                2U
#define DBGXAM_BIT10_MASK               4U
#define DBGXAM_BIT11_MASK               8U
#define DBGXAM_BIT12_MASK               16U
#define DBGXAM_BIT13_MASK               32U
#define DBGXAM_BIT14_MASK               64U
#define DBGXAM_BIT15_MASK               128U


/*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bits */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXALSTR;
extern volatile DBGXALSTR _DBGXAL @(REG_BASE + 0x0000002BUL);
#define DBGXAL                          _DBGXAL.Byte
#define DBGXAL_BIT0                     _DBGXAL.Bits.BIT0
#define DBGXAL_BIT1                     _DBGXAL.Bits.BIT1
#define DBGXAL_BIT2                     _DBGXAL.Bits.BIT2
#define DBGXAL_BIT3                     _DBGXAL.Bits.BIT3
#define DBGXAL_BIT4                     _DBGXAL.Bits.BIT4
#define DBGXAL_BIT5                     _DBGXAL.Bits.BIT5
#define DBGXAL_BIT6                     _DBGXAL.Bits.BIT6
#define DBGXAL_BIT7                     _DBGXAL.Bits.BIT7

#define DBGXAL_BIT0_MASK                1U
#define DBGXAL_BIT1_MASK                2U
#define DBGXAL_BIT2_MASK                4U
#define DBGXAL_BIT3_MASK                8U
#define DBGXAL_BIT4_MASK                16U
#define DBGXAL_BIT5_MASK                32U
#define DBGXAL_BIT6_MASK                64U
#define DBGXAL_BIT7_MASK                128U


/*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Compare Bit 15 */
  } Bits;
} DBGXDHSTR;
extern volatile DBGXDHSTR _DBGXDH @(REG_BASE + 0x0000002CUL);
#define DBGXDH                          _DBGXDH.Byte
#define DBGXDH_BIT8                     _DBGXDH.Bits.BIT8
#define DBGXDH_BIT9                     _DBGXDH.Bits.BIT9
#define DBGXDH_BIT10                    _DBGXDH.Bits.BIT10
#define DBGXDH_BIT11                    _DBGXDH.Bits.BIT11
#define DBGXDH_BIT12                    _DBGXDH.Bits.BIT12
#define DBGXDH_BIT13                    _DBGXDH.Bits.BIT13
#define DBGXDH_BIT14                    _DBGXDH.Bits.BIT14
#define DBGXDH_BIT15                    _DBGXDH.Bits.BIT15

#define DBGXDH_BIT8_MASK                1U
#define DBGXDH_BIT9_MASK                2U
#define DBGXDH_BIT10_MASK               4U
#define DBGXDH_BIT11_MASK               8U
#define DBGXDH_BIT12_MASK               16U
#define DBGXDH_BIT13_MASK               32U
#define DBGXDH_BIT14_MASK               64U
#define DBGXDH_BIT15_MASK               128U


/*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Compare Bit 7 */
  } Bits;
} DBGXDLSTR;
extern volatile DBGXDLSTR _DBGXDL @(REG_BASE + 0x0000002DUL);
#define DBGXDL                          _DBGXDL.Byte
#define DBGXDL_BIT0                     _DBGXDL.Bits.BIT0
#define DBGXDL_BIT1                     _DBGXDL.Bits.BIT1
#define DBGXDL_BIT2                     _DBGXDL.Bits.BIT2
#define DBGXDL_BIT3                     _DBGXDL.Bits.BIT3
#define DBGXDL_BIT4                     _DBGXDL.Bits.BIT4
#define DBGXDL_BIT5                     _DBGXDL.Bits.BIT5
#define DBGXDL_BIT6                     _DBGXDL.Bits.BIT6
#define DBGXDL_BIT7                     _DBGXDL.Bits.BIT7

#define DBGXDL_BIT0_MASK                1U
#define DBGXDL_BIT1_MASK                2U
#define DBGXDL_BIT2_MASK                4U
#define DBGXDL_BIT3_MASK                8U
#define DBGXDL_BIT4_MASK                16U
#define DBGXDL_BIT5_MASK                32U
#define DBGXDL_BIT6_MASK                64U
#define DBGXDL_BIT7_MASK                128U


/*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Mask Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Mask Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Mask Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Mask Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Mask Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Mask Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Mask Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Mask Bit 15 */
  } Bits;
} DBGXDHMSTR;
extern volatile DBGXDHMSTR _DBGXDHM @(REG_BASE + 0x0000002EUL);
#define DBGXDHM                         _DBGXDHM.Byte
#define DBGXDHM_BIT8                    _DBGXDHM.Bits.BIT8
#define DBGXDHM_BIT9                    _DBGXDHM.Bits.BIT9
#define DBGXDHM_BIT10                   _DBGXDHM.Bits.BIT10
#define DBGXDHM_BIT11                   _DBGXDHM.Bits.BIT11
#define DBGXDHM_BIT12                   _DBGXDHM.Bits.BIT12
#define DBGXDHM_BIT13                   _DBGXDHM.Bits.BIT13
#define DBGXDHM_BIT14                   _DBGXDHM.Bits.BIT14
#define DBGXDHM_BIT15                   _DBGXDHM.Bits.BIT15

#define DBGXDHM_BIT8_MASK               1U
#define DBGXDHM_BIT9_MASK               2U
#define DBGXDHM_BIT10_MASK              4U
#define DBGXDHM_BIT11_MASK              8U
#define DBGXDHM_BIT12_MASK              16U
#define DBGXDHM_BIT13_MASK              32U
#define DBGXDHM_BIT14_MASK              64U
#define DBGXDHM_BIT15_MASK              128U


/*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Mask Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Mask Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Mask Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Mask Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Mask Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Mask Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Mask Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Mask Bit 7 */
  } Bits;
} DBGXDLMSTR;
extern volatile DBGXDLMSTR _DBGXDLM @(REG_BASE + 0x0000002FUL);
#define DBGXDLM                         _DBGXDLM.Byte
#define DBGXDLM_BIT0                    _DBGXDLM.Bits.BIT0
#define DBGXDLM_BIT1                    _DBGXDLM.Bits.BIT1
#define DBGXDLM_BIT2                    _DBGXDLM.Bits.BIT2
#define DBGXDLM_BIT3                    _DBGXDLM.Bits.BIT3
#define DBGXDLM_BIT4                    _DBGXDLM.Bits.BIT4
#define DBGXDLM_BIT5                    _DBGXDLM.Bits.BIT5
#define DBGXDLM_BIT6                    _DBGXDLM.Bits.BIT6
#define DBGXDLM_BIT7                    _DBGXDLM.Bits.BIT7

#define DBGXDLM_BIT0_MASK               1U
#define DBGXDLM_BIT1_MASK               2U
#define DBGXDLM_BIT2_MASK               4U
#define DBGXDLM_BIT3_MASK               8U
#define DBGXDLM_BIT4_MASK               16U
#define DBGXDLM_BIT5_MASK               32U
#define DBGXDLM_BIT6_MASK               64U
#define DBGXDLM_BIT7_MASK               128U


/*** SYNR - S12XECRG Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYNDIV0     :1;                                       /* Multiplication factor of the IPLL bit 0 */
    byte SYNDIV1     :1;                                       /* Multiplication factor of the IPLL bit 1 */
    byte SYNDIV2     :1;                                       /* Multiplication factor of the IPLL bit 2 */
    byte SYNDIV3     :1;                                       /* Multiplication factor of the IPLL bit 3 */
    byte SYNDIV4     :1;                                       /* Multiplication factor of the IPLL bit 4 */
    byte SYNDIV5     :1;                                       /* Multiplication factor of the IPLL bit 5 */
    byte VCOFRQ0     :1;                                       /* VCO frequency range bit 0 */
    byte VCOFRQ1     :1;                                       /* VCO frequency range bit 1 */
  } Bits;
  struct {
    byte grpSYNDIV :6;
    byte grpVCOFRQ :2;
  } MergedBits;
} SYNRSTR;
extern volatile SYNRSTR _SYNR @(REG_BASE + 0x00000034UL);
#define SYNR                            _SYNR.Byte
#define SYNR_SYNDIV0                    _SYNR.Bits.SYNDIV0
#define SYNR_SYNDIV1                    _SYNR.Bits.SYNDIV1
#define SYNR_SYNDIV2                    _SYNR.Bits.SYNDIV2
#define SYNR_SYNDIV3                    _SYNR.Bits.SYNDIV3
#define SYNR_SYNDIV4                    _SYNR.Bits.SYNDIV4
#define SYNR_SYNDIV5                    _SYNR.Bits.SYNDIV5
#define SYNR_VCOFRQ0                    _SYNR.Bits.VCOFRQ0
#define SYNR_VCOFRQ1                    _SYNR.Bits.VCOFRQ1
#define SYNR_SYNDIV                     _SYNR.MergedBits.grpSYNDIV
#define SYNR_VCOFRQ                     _SYNR.MergedBits.grpVCOFRQ

#define SYNR_SYNDIV0_MASK               1U
#define SYNR_SYNDIV1_MASK               2U
#define SYNR_SYNDIV2_MASK               4U
#define SYNR_SYNDIV3_MASK               8U
#define SYNR_SYNDIV4_MASK               16U
#define SYNR_SYNDIV5_MASK               32U
#define SYNR_VCOFRQ0_MASK               64U
#define SYNR_VCOFRQ1_MASK               128U
#define SYNR_SYNDIV_MASK                63U
#define SYNR_SYNDIV_BITNUM              0U
#define SYNR_VCOFRQ_MASK                192U
#define SYNR_VCOFRQ_BITNUM              6U


/*** REFDV - S12XECRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDIV0     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 0 */
    byte REFDIV1     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 1 */
    byte REFDIV2     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 2 */
    byte REFDIV3     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 3 */
    byte REFDIV4     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 4 */
    byte REFDIV5     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 5 */
    byte REFFRQ0     :1;                                       /* IPLL optimal stability and lock time configuration bit 0 */
    byte REFFRQ1     :1;                                       /* IPLL optimal stability and lock time configuration bit 1 */
  } Bits;
  struct {
    byte grpREFDIV :6;
    byte grpREFFRQ :2;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035UL);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDIV0                   _REFDV.Bits.REFDIV0
#define REFDV_REFDIV1                   _REFDV.Bits.REFDIV1
#define REFDV_REFDIV2                   _REFDV.Bits.REFDIV2
#define REFDV_REFDIV3                   _REFDV.Bits.REFDIV3
#define REFDV_REFDIV4                   _REFDV.Bits.REFDIV4
#define REFDV_REFDIV5                   _REFDV.Bits.REFDIV5
#define REFDV_REFFRQ0                   _REFDV.Bits.REFFRQ0
#define REFDV_REFFRQ1                   _REFDV.Bits.REFFRQ1
#define REFDV_REFDIV                    _REFDV.MergedBits.grpREFDIV
#define REFDV_REFFRQ                    _REFDV.MergedBits.grpREFFRQ

#define REFDV_REFDIV0_MASK              1U
#define REFDV_REFDIV1_MASK              2U
#define REFDV_REFDIV2_MASK              4U
#define REFDV_REFDIV3_MASK              8U
#define REFDV_REFDIV4_MASK              16U
#define REFDV_REFDIV5_MASK              32U
#define REFDV_REFFRQ0_MASK              64U
#define REFDV_REFFRQ1_MASK              128U
#define REFDV_REFDIV_MASK               63U
#define REFDV_REFDIV_BITNUM             0U
#define REFDV_REFFRQ_MASK               192U
#define REFDV_REFFRQ_BITNUM             6U


/*** POSTDIV - S12XECRG Post Divider Register; 0x00000036 ***/
typedef union {
  byte Byte;
  struct {
    byte POSTDIV0    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 0 */
    byte POSTDIV1    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 1 */
    byte POSTDIV2    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 2 */
    byte POSTDIV3    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 3 */
    byte POSTDIV4    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 4 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPOSTDIV :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} POSTDIVSTR;
extern volatile POSTDIVSTR _POSTDIV @(REG_BASE + 0x00000036UL);
#define POSTDIV                         _POSTDIV.Byte
#define POSTDIV_POSTDIV0                _POSTDIV.Bits.POSTDIV0
#define POSTDIV_POSTDIV1                _POSTDIV.Bits.POSTDIV1
#define POSTDIV_POSTDIV2                _POSTDIV.Bits.POSTDIV2
#define POSTDIV_POSTDIV3                _POSTDIV.Bits.POSTDIV3
#define POSTDIV_POSTDIV4                _POSTDIV.Bits.POSTDIV4
#define POSTDIV_POSTDIV                 _POSTDIV.MergedBits.grpPOSTDIV

#define POSTDIV_POSTDIV0_MASK           1U
#define POSTDIV_POSTDIV1_MASK           2U
#define POSTDIV_POSTDIV2_MASK           4U
#define POSTDIV_POSTDIV3_MASK           8U
#define POSTDIV_POSTDIV4_MASK           16U
#define POSTDIV_POSTDIV_MASK            31U
#define POSTDIV_POSTDIV_BITNUM          0U


/*** CRGFLG - S12XECRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte SCM         :1;                                       /* Self Clock Mode Status Bit */
    byte SCMIF       :1;                                       /* Self Clock Mode Interrupt Flag */
    byte ILAF        :1;                                       /* Illegal Address Reset Flag */
    byte LOCK        :1;                                       /* Lock Status Bit */
    byte LOCKIF      :1;                                       /* IPLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_SCM                      _CRGFLG.Bits.SCM
#define CRGFLG_SCMIF                    _CRGFLG.Bits.SCMIF
#define CRGFLG_ILAF                     _CRGFLG.Bits.ILAF
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_LVRF                     _CRGFLG.Bits.LVRF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_SCM_MASK                 1U
#define CRGFLG_SCMIF_MASK               2U
#define CRGFLG_ILAF_MASK                4U
#define CRGFLG_LOCK_MASK                8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_LVRF_MASK                32U
#define CRGFLG_PORF_MASK                64U
#define CRGFLG_RTIF_MASK                128U


/*** CRGINT - S12XECRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SCMIE       :1;                                       /* Self Clock Mode Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte RTIE        :1;                                       /* Real Time Interrupt Enable Bit */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038UL);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_SCMIE                    _CRGINT.Bits.SCMIE
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_SCMIE_MASK               2U
#define CRGINT_LOCKIE_MASK              16U
#define CRGINT_RTIE_MASK                128U


/*** CLKSEL - S12XECRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP Stops in Wait Mode Bit */
    byte RTIWAI      :1;                                       /* RTI Stops in Wait Mode Bit */
    byte             :1; 
    byte PLLWAI      :1;                                       /* PLL Stops in Wait Mode Bit */
    byte             :1; 
    byte XCLKS       :1;                                       /* Oscillator Configuration Status Bit */
    byte PSTP        :1;                                       /* Pseudo Stop Bit */
    byte PLLSEL      :1;                                       /* PLL Select Bit */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039UL);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_PLLWAI                   _CLKSEL.Bits.PLLWAI
#define CLKSEL_XCLKS                    _CLKSEL.Bits.XCLKS
#define CLKSEL_PSTP                     _CLKSEL.Bits.PSTP
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1U
#define CLKSEL_RTIWAI_MASK              2U
#define CLKSEL_PLLWAI_MASK              8U
#define CLKSEL_XCLKS_MASK               32U
#define CLKSEL_PSTP_MASK                64U
#define CLKSEL_PLLSEL_MASK              128U


/*** PLLCTL - S12XECRG IPLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte SCME        :1;                                       /* Self Clock Mode Enable Bit */
    byte PCE         :1;                                       /* COP Enable During Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable During Pseudo Stop Bit */
    byte FSTWKP      :1;                                       /* Fast Wake-up from Full Stop Bit */
    byte FM0         :1;                                       /* IPLL Frequency Modulation Enable Bit 0 */
    byte FM1         :1;                                       /* IPLL Frequency Modulation Enable Bit 1 */
    byte PLLON       :1;                                       /* Phase Lock Loop On Bit */
    byte CME         :1;                                       /* Clock Monitor Enable Bit */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpFM   :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} PLLCTLSTR;
extern volatile PLLCTLSTR _PLLCTL @(REG_BASE + 0x0000003AUL);
#define PLLCTL                          _PLLCTL.Byte
#define PLLCTL_SCME                     _PLLCTL.Bits.SCME
#define PLLCTL_PCE                      _PLLCTL.Bits.PCE
#define PLLCTL_PRE                      _PLLCTL.Bits.PRE
#define PLLCTL_FSTWKP                   _PLLCTL.Bits.FSTWKP
#define PLLCTL_FM0                      _PLLCTL.Bits.FM0
#define PLLCTL_FM1                      _PLLCTL.Bits.FM1
#define PLLCTL_PLLON                    _PLLCTL.Bits.PLLON
#define PLLCTL_CME                      _PLLCTL.Bits.CME
#define PLLCTL_FM                       _PLLCTL.MergedBits.grpFM

#define PLLCTL_SCME_MASK                1U
#define PLLCTL_PCE_MASK                 2U
#define PLLCTL_PRE_MASK                 4U
#define PLLCTL_FSTWKP_MASK              8U
#define PLLCTL_FM0_MASK                 16U
#define PLLCTL_FM1_MASK                 32U
#define PLLCTL_PLLON_MASK               64U
#define PLLCTL_CME_MASK                 128U
#define PLLCTL_FM_MASK                  48U
#define PLLCTL_FM_BITNUM                4U


/*** RTICTL - ECRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte RTDEC       :1;                                       /* Decimal or Binary Divider Select Bit */
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003BUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTDEC                    _RTICTL.Bits.RTDEC
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTR2_MASK                4U
#define RTICTL_RTR3_MASK                8U
#define RTICTL_RTR4_MASK                16U
#define RTICTL_RTR5_MASK                32U
#define RTICTL_RTR6_MASK                64U
#define RTICTL_RTDEC_MASK               128U
#define RTICTL_RTR_MASK                 127U
#define RTICTL_RTR_BITNUM               0U


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte WRTMASK     :1;                                       /* Write Mask for WCOP */
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003CUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_WRTMASK                  _COPCTL.Bits.WRTMASK
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_WRTMASK_MASK             32U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1U
#define ARMCOP_BIT1_MASK                2U
#define ARMCOP_BIT2_MASK                4U
#define ARMCOP_BIT3_MASK                8U
#define ARMCOP_BIT4_MASK                16U
#define ARMCOP_BIT5_MASK                32U
#define ARMCOP_BIT6_MASK                64U
#define ARMCOP_BIT7_MASK                128U


/*** TIM0_TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} TIM0_TIOSSTR;
extern volatile TIM0_TIOSSTR _TIM0_TIOS @(REG_BASE + 0x00000040UL);
#define TIM0_TIOS                       _TIM0_TIOS.Byte
#define TIM0_TIOS_IOS0                  _TIM0_TIOS.Bits.IOS0
#define TIM0_TIOS_IOS1                  _TIM0_TIOS.Bits.IOS1
#define TIM0_TIOS_IOS2                  _TIM0_TIOS.Bits.IOS2
#define TIM0_TIOS_IOS3                  _TIM0_TIOS.Bits.IOS3
#define TIM0_TIOS_IOS4                  _TIM0_TIOS.Bits.IOS4
#define TIM0_TIOS_IOS5                  _TIM0_TIOS.Bits.IOS5
#define TIM0_TIOS_IOS6                  _TIM0_TIOS.Bits.IOS6
#define TIM0_TIOS_IOS7                  _TIM0_TIOS.Bits.IOS7

#define TIM0_TIOS_IOS0_MASK             1U
#define TIM0_TIOS_IOS1_MASK             2U
#define TIM0_TIOS_IOS2_MASK             4U
#define TIM0_TIOS_IOS3_MASK             8U
#define TIM0_TIOS_IOS4_MASK             16U
#define TIM0_TIOS_IOS5_MASK             32U
#define TIM0_TIOS_IOS6_MASK             64U
#define TIM0_TIOS_IOS7_MASK             128U


/*** TIM0_CFORC - Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} TIM0_CFORCSTR;
extern volatile TIM0_CFORCSTR _TIM0_CFORC @(REG_BASE + 0x00000041UL);
#define TIM0_CFORC                      _TIM0_CFORC.Byte
#define TIM0_CFORC_FOC0                 _TIM0_CFORC.Bits.FOC0
#define TIM0_CFORC_FOC1                 _TIM0_CFORC.Bits.FOC1
#define TIM0_CFORC_FOC2                 _TIM0_CFORC.Bits.FOC2
#define TIM0_CFORC_FOC3                 _TIM0_CFORC.Bits.FOC3
#define TIM0_CFORC_FOC4                 _TIM0_CFORC.Bits.FOC4
#define TIM0_CFORC_FOC5                 _TIM0_CFORC.Bits.FOC5
#define TIM0_CFORC_FOC6                 _TIM0_CFORC.Bits.FOC6
#define TIM0_CFORC_FOC7                 _TIM0_CFORC.Bits.FOC7

#define TIM0_CFORC_FOC0_MASK            1U
#define TIM0_CFORC_FOC1_MASK            2U
#define TIM0_CFORC_FOC2_MASK            4U
#define TIM0_CFORC_FOC3_MASK            8U
#define TIM0_CFORC_FOC4_MASK            16U
#define TIM0_CFORC_FOC5_MASK            32U
#define TIM0_CFORC_FOC6_MASK            64U
#define TIM0_CFORC_FOC7_MASK            128U


/*** TIM0_OC7M - Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} TIM0_OC7MSTR;
extern volatile TIM0_OC7MSTR _TIM0_OC7M @(REG_BASE + 0x00000042UL);
#define TIM0_OC7M                       _TIM0_OC7M.Byte
#define TIM0_OC7M_OC7M0                 _TIM0_OC7M.Bits.OC7M0
#define TIM0_OC7M_OC7M1                 _TIM0_OC7M.Bits.OC7M1
#define TIM0_OC7M_OC7M2                 _TIM0_OC7M.Bits.OC7M2
#define TIM0_OC7M_OC7M3                 _TIM0_OC7M.Bits.OC7M3
#define TIM0_OC7M_OC7M4                 _TIM0_OC7M.Bits.OC7M4
#define TIM0_OC7M_OC7M5                 _TIM0_OC7M.Bits.OC7M5
#define TIM0_OC7M_OC7M6                 _TIM0_OC7M.Bits.OC7M6
#define TIM0_OC7M_OC7M7                 _TIM0_OC7M.Bits.OC7M7

#define TIM0_OC7M_OC7M0_MASK            1U
#define TIM0_OC7M_OC7M1_MASK            2U
#define TIM0_OC7M_OC7M2_MASK            4U
#define TIM0_OC7M_OC7M3_MASK            8U
#define TIM0_OC7M_OC7M4_MASK            16U
#define TIM0_OC7M_OC7M5_MASK            32U
#define TIM0_OC7M_OC7M6_MASK            64U
#define TIM0_OC7M_OC7M7_MASK            128U


/*** TIM0_OC7D - Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7D0       :1;                                       /* Output Compare 7 Bit 0 */
    byte OC7D1       :1;                                       /* Output Compare 7 Bit 1 */
    byte OC7D2       :1;                                       /* Output Compare 7 Bit 2 */
    byte OC7D3       :1;                                       /* Output Compare 7 Bit 3 */
    byte OC7D4       :1;                                       /* Output Compare 7 Bit 4 */
    byte OC7D5       :1;                                       /* Output Compare 7 Bit 5 */
    byte OC7D6       :1;                                       /* Output Compare 7 Bit 6 */
    byte OC7D7       :1;                                       /* Output Compare 7 Bit 7 */
  } Bits;
} TIM0_OC7DSTR;
extern volatile TIM0_OC7DSTR _TIM0_OC7D @(REG_BASE + 0x00000043UL);
#define TIM0_OC7D                       _TIM0_OC7D.Byte
#define TIM0_OC7D_OC7D0                 _TIM0_OC7D.Bits.OC7D0
#define TIM0_OC7D_OC7D1                 _TIM0_OC7D.Bits.OC7D1
#define TIM0_OC7D_OC7D2                 _TIM0_OC7D.Bits.OC7D2
#define TIM0_OC7D_OC7D3                 _TIM0_OC7D.Bits.OC7D3
#define TIM0_OC7D_OC7D4                 _TIM0_OC7D.Bits.OC7D4
#define TIM0_OC7D_OC7D5                 _TIM0_OC7D.Bits.OC7D5
#define TIM0_OC7D_OC7D6                 _TIM0_OC7D.Bits.OC7D6
#define TIM0_OC7D_OC7D7                 _TIM0_OC7D.Bits.OC7D7

#define TIM0_OC7D_OC7D0_MASK            1U
#define TIM0_OC7D_OC7D1_MASK            2U
#define TIM0_OC7D_OC7D2_MASK            4U
#define TIM0_OC7D_OC7D3_MASK            8U
#define TIM0_OC7D_OC7D4_MASK            16U
#define TIM0_OC7D_OC7D5_MASK            32U
#define TIM0_OC7D_OC7D6_MASK            64U
#define TIM0_OC7D_OC7D7_MASK            128U


/*** TIM0_TCNT - Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TCNTHi - Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } TIM0_TCNTHiSTR;
    #define TIM0_TCNTHi                 _TIM0_TCNT.Overlap_STR.TIM0_TCNTHiSTR.Byte
    

    /*** TIM0_TCNTLo - Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } TIM0_TCNTLoSTR;
    #define TIM0_TCNTLo                 _TIM0_TCNT.Overlap_STR.TIM0_TCNTLoSTR.Byte
    
  } Overlap_STR;

} TIM0_TCNTSTR;
extern volatile TIM0_TCNTSTR _TIM0_TCNT @(REG_BASE + 0x00000044UL);
#define TIM0_TCNT                       _TIM0_TCNT.Word


/*** TIM0_TSCR1 - Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PRNT        :1;                                       /* Precision Timer */
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TIM0_TSCR1STR;
extern volatile TIM0_TSCR1STR _TIM0_TSCR1 @(REG_BASE + 0x00000046UL);
#define TIM0_TSCR1                      _TIM0_TSCR1.Byte
#define TIM0_TSCR1_PRNT                 _TIM0_TSCR1.Bits.PRNT
#define TIM0_TSCR1_TFFCA                _TIM0_TSCR1.Bits.TFFCA
#define TIM0_TSCR1_TSFRZ                _TIM0_TSCR1.Bits.TSFRZ
#define TIM0_TSCR1_TSWAI                _TIM0_TSCR1.Bits.TSWAI
#define TIM0_TSCR1_TEN                  _TIM0_TSCR1.Bits.TEN

#define TIM0_TSCR1_PRNT_MASK            8U
#define TIM0_TSCR1_TFFCA_MASK           16U
#define TIM0_TSCR1_TSFRZ_MASK           32U
#define TIM0_TSCR1_TSWAI_MASK           64U
#define TIM0_TSCR1_TEN_MASK             128U


/*** TIM0_TTOV - Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} TIM0_TTOVSTR;
extern volatile TIM0_TTOVSTR _TIM0_TTOV @(REG_BASE + 0x00000047UL);
#define TIM0_TTOV                       _TIM0_TTOV.Byte
#define TIM0_TTOV_TOV0                  _TIM0_TTOV.Bits.TOV0
#define TIM0_TTOV_TOV1                  _TIM0_TTOV.Bits.TOV1
#define TIM0_TTOV_TOV2                  _TIM0_TTOV.Bits.TOV2
#define TIM0_TTOV_TOV3                  _TIM0_TTOV.Bits.TOV3
#define TIM0_TTOV_TOV4                  _TIM0_TTOV.Bits.TOV4
#define TIM0_TTOV_TOV5                  _TIM0_TTOV.Bits.TOV5
#define TIM0_TTOV_TOV6                  _TIM0_TTOV.Bits.TOV6
#define TIM0_TTOV_TOV7                  _TIM0_TTOV.Bits.TOV7

#define TIM0_TTOV_TOV0_MASK             1U
#define TIM0_TTOV_TOV1_MASK             2U
#define TIM0_TTOV_TOV2_MASK             4U
#define TIM0_TTOV_TOV3_MASK             8U
#define TIM0_TTOV_TOV4_MASK             16U
#define TIM0_TTOV_TOV5_MASK             32U
#define TIM0_TTOV_TOV6_MASK             64U
#define TIM0_TTOV_TOV7_MASK             128U


/*** TIM0_TCTL1 - Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TIM0_TCTL1STR;
extern volatile TIM0_TCTL1STR _TIM0_TCTL1 @(REG_BASE + 0x00000048UL);
#define TIM0_TCTL1                      _TIM0_TCTL1.Byte
#define TIM0_TCTL1_OL4                  _TIM0_TCTL1.Bits.OL4
#define TIM0_TCTL1_OM4                  _TIM0_TCTL1.Bits.OM4
#define TIM0_TCTL1_OL5                  _TIM0_TCTL1.Bits.OL5
#define TIM0_TCTL1_OM5                  _TIM0_TCTL1.Bits.OM5
#define TIM0_TCTL1_OL6                  _TIM0_TCTL1.Bits.OL6
#define TIM0_TCTL1_OM6                  _TIM0_TCTL1.Bits.OM6
#define TIM0_TCTL1_OL7                  _TIM0_TCTL1.Bits.OL7
#define TIM0_TCTL1_OM7                  _TIM0_TCTL1.Bits.OM7

#define TIM0_TCTL1_OL4_MASK             1U
#define TIM0_TCTL1_OM4_MASK             2U
#define TIM0_TCTL1_OL5_MASK             4U
#define TIM0_TCTL1_OM5_MASK             8U
#define TIM0_TCTL1_OL6_MASK             16U
#define TIM0_TCTL1_OM6_MASK             32U
#define TIM0_TCTL1_OL7_MASK             64U
#define TIM0_TCTL1_OM7_MASK             128U


/*** TIM0_TCTL2 - Timer Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Lecel Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} TIM0_TCTL2STR;
extern volatile TIM0_TCTL2STR _TIM0_TCTL2 @(REG_BASE + 0x00000049UL);
#define TIM0_TCTL2                      _TIM0_TCTL2.Byte
#define TIM0_TCTL2_OL0                  _TIM0_TCTL2.Bits.OL0
#define TIM0_TCTL2_OM0                  _TIM0_TCTL2.Bits.OM0
#define TIM0_TCTL2_OL1                  _TIM0_TCTL2.Bits.OL1
#define TIM0_TCTL2_OM1                  _TIM0_TCTL2.Bits.OM1
#define TIM0_TCTL2_OL2                  _TIM0_TCTL2.Bits.OL2
#define TIM0_TCTL2_OM2                  _TIM0_TCTL2.Bits.OM2
#define TIM0_TCTL2_OL3                  _TIM0_TCTL2.Bits.OL3
#define TIM0_TCTL2_OM3                  _TIM0_TCTL2.Bits.OM3

#define TIM0_TCTL2_OL0_MASK             1U
#define TIM0_TCTL2_OM0_MASK             2U
#define TIM0_TCTL2_OL1_MASK             4U
#define TIM0_TCTL2_OM1_MASK             8U
#define TIM0_TCTL2_OL2_MASK             16U
#define TIM0_TCTL2_OM2_MASK             32U
#define TIM0_TCTL2_OL3_MASK             64U
#define TIM0_TCTL2_OM3_MASK             128U


/*** TIM0_TCTL3 - Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TIM0_TCTL3STR;
extern volatile TIM0_TCTL3STR _TIM0_TCTL3 @(REG_BASE + 0x0000004AUL);
#define TIM0_TCTL3                      _TIM0_TCTL3.Byte
#define TIM0_TCTL3_EDG4A                _TIM0_TCTL3.Bits.EDG4A
#define TIM0_TCTL3_EDG4B                _TIM0_TCTL3.Bits.EDG4B
#define TIM0_TCTL3_EDG5A                _TIM0_TCTL3.Bits.EDG5A
#define TIM0_TCTL3_EDG5B                _TIM0_TCTL3.Bits.EDG5B
#define TIM0_TCTL3_EDG6A                _TIM0_TCTL3.Bits.EDG6A
#define TIM0_TCTL3_EDG6B                _TIM0_TCTL3.Bits.EDG6B
#define TIM0_TCTL3_EDG7A                _TIM0_TCTL3.Bits.EDG7A
#define TIM0_TCTL3_EDG7B                _TIM0_TCTL3.Bits.EDG7B
#define TIM0_TCTL3_EDG4x                _TIM0_TCTL3.MergedBits.grpEDG4x
#define TIM0_TCTL3_EDG5x                _TIM0_TCTL3.MergedBits.grpEDG5x
#define TIM0_TCTL3_EDG6x                _TIM0_TCTL3.MergedBits.grpEDG6x
#define TIM0_TCTL3_EDG7x                _TIM0_TCTL3.MergedBits.grpEDG7x

#define TIM0_TCTL3_EDG4A_MASK           1U
#define TIM0_TCTL3_EDG4B_MASK           2U
#define TIM0_TCTL3_EDG5A_MASK           4U
#define TIM0_TCTL3_EDG5B_MASK           8U
#define TIM0_TCTL3_EDG6A_MASK           16U
#define TIM0_TCTL3_EDG6B_MASK           32U
#define TIM0_TCTL3_EDG7A_MASK           64U
#define TIM0_TCTL3_EDG7B_MASK           128U
#define TIM0_TCTL3_EDG4x_MASK           3U
#define TIM0_TCTL3_EDG4x_BITNUM         0U
#define TIM0_TCTL3_EDG5x_MASK           12U
#define TIM0_TCTL3_EDG5x_BITNUM         2U
#define TIM0_TCTL3_EDG6x_MASK           48U
#define TIM0_TCTL3_EDG6x_BITNUM         4U
#define TIM0_TCTL3_EDG7x_MASK           192U
#define TIM0_TCTL3_EDG7x_BITNUM         6U


/*** TIM0_TCTL4 - Timer Control Register 4; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} TIM0_TCTL4STR;
extern volatile TIM0_TCTL4STR _TIM0_TCTL4 @(REG_BASE + 0x0000004BUL);
#define TIM0_TCTL4                      _TIM0_TCTL4.Byte
#define TIM0_TCTL4_EDG0A                _TIM0_TCTL4.Bits.EDG0A
#define TIM0_TCTL4_EDG0B                _TIM0_TCTL4.Bits.EDG0B
#define TIM0_TCTL4_EDG1A                _TIM0_TCTL4.Bits.EDG1A
#define TIM0_TCTL4_EDG1B                _TIM0_TCTL4.Bits.EDG1B
#define TIM0_TCTL4_EDG2A                _TIM0_TCTL4.Bits.EDG2A
#define TIM0_TCTL4_EDG2B                _TIM0_TCTL4.Bits.EDG2B
#define TIM0_TCTL4_EDG3A                _TIM0_TCTL4.Bits.EDG3A
#define TIM0_TCTL4_EDG3B                _TIM0_TCTL4.Bits.EDG3B
#define TIM0_TCTL4_EDG0x                _TIM0_TCTL4.MergedBits.grpEDG0x
#define TIM0_TCTL4_EDG1x                _TIM0_TCTL4.MergedBits.grpEDG1x
#define TIM0_TCTL4_EDG2x                _TIM0_TCTL4.MergedBits.grpEDG2x
#define TIM0_TCTL4_EDG3x                _TIM0_TCTL4.MergedBits.grpEDG3x

#define TIM0_TCTL4_EDG0A_MASK           1U
#define TIM0_TCTL4_EDG0B_MASK           2U
#define TIM0_TCTL4_EDG1A_MASK           4U
#define TIM0_TCTL4_EDG1B_MASK           8U
#define TIM0_TCTL4_EDG2A_MASK           16U
#define TIM0_TCTL4_EDG2B_MASK           32U
#define TIM0_TCTL4_EDG3A_MASK           64U
#define TIM0_TCTL4_EDG3B_MASK           128U
#define TIM0_TCTL4_EDG0x_MASK           3U
#define TIM0_TCTL4_EDG0x_BITNUM         0U
#define TIM0_TCTL4_EDG1x_MASK           12U
#define TIM0_TCTL4_EDG1x_BITNUM         2U
#define TIM0_TCTL4_EDG2x_MASK           48U
#define TIM0_TCTL4_EDG2x_BITNUM         4U
#define TIM0_TCTL4_EDG3x_MASK           192U
#define TIM0_TCTL4_EDG3x_BITNUM         6U


/*** TIM0_TIE - Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIM0_TIESTR;
extern volatile TIM0_TIESTR _TIM0_TIE @(REG_BASE + 0x0000004CUL);
#define TIM0_TIE                        _TIM0_TIE.Byte
#define TIM0_TIE_C0I                    _TIM0_TIE.Bits.C0I
#define TIM0_TIE_C1I                    _TIM0_TIE.Bits.C1I
#define TIM0_TIE_C2I                    _TIM0_TIE.Bits.C2I
#define TIM0_TIE_C3I                    _TIM0_TIE.Bits.C3I
#define TIM0_TIE_C4I                    _TIM0_TIE.Bits.C4I
#define TIM0_TIE_C5I                    _TIM0_TIE.Bits.C5I
#define TIM0_TIE_C6I                    _TIM0_TIE.Bits.C6I
#define TIM0_TIE_C7I                    _TIM0_TIE.Bits.C7I

#define TIM0_TIE_C0I_MASK               1U
#define TIM0_TIE_C1I_MASK               2U
#define TIM0_TIE_C2I_MASK               4U
#define TIM0_TIE_C3I_MASK               8U
#define TIM0_TIE_C4I_MASK               16U
#define TIM0_TIE_C5I_MASK               32U
#define TIM0_TIE_C6I_MASK               64U
#define TIM0_TIE_C7I_MASK               128U


/*** TIM0_TSCR2 - Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM0_TSCR2STR;
extern volatile TIM0_TSCR2STR _TIM0_TSCR2 @(REG_BASE + 0x0000004DUL);
#define TIM0_TSCR2                      _TIM0_TSCR2.Byte
#define TIM0_TSCR2_PR0                  _TIM0_TSCR2.Bits.PR0
#define TIM0_TSCR2_PR1                  _TIM0_TSCR2.Bits.PR1
#define TIM0_TSCR2_PR2                  _TIM0_TSCR2.Bits.PR2
#define TIM0_TSCR2_TCRE                 _TIM0_TSCR2.Bits.TCRE
#define TIM0_TSCR2_TOI                  _TIM0_TSCR2.Bits.TOI
#define TIM0_TSCR2_PR                   _TIM0_TSCR2.MergedBits.grpPR

#define TIM0_TSCR2_PR0_MASK             1U
#define TIM0_TSCR2_PR1_MASK             2U
#define TIM0_TSCR2_PR2_MASK             4U
#define TIM0_TSCR2_TCRE_MASK            8U
#define TIM0_TSCR2_TOI_MASK             128U
#define TIM0_TSCR2_PR_MASK              7U
#define TIM0_TSCR2_PR_BITNUM            0U


/*** TIM0_TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TIM0_TFLG1STR;
extern volatile TIM0_TFLG1STR _TIM0_TFLG1 @(REG_BASE + 0x0000004EUL);
#define TIM0_TFLG1                      _TIM0_TFLG1.Byte
#define TIM0_TFLG1_C0F                  _TIM0_TFLG1.Bits.C0F
#define TIM0_TFLG1_C1F                  _TIM0_TFLG1.Bits.C1F
#define TIM0_TFLG1_C2F                  _TIM0_TFLG1.Bits.C2F
#define TIM0_TFLG1_C3F                  _TIM0_TFLG1.Bits.C3F
#define TIM0_TFLG1_C4F                  _TIM0_TFLG1.Bits.C4F
#define TIM0_TFLG1_C5F                  _TIM0_TFLG1.Bits.C5F
#define TIM0_TFLG1_C6F                  _TIM0_TFLG1.Bits.C6F
#define TIM0_TFLG1_C7F                  _TIM0_TFLG1.Bits.C7F

#define TIM0_TFLG1_C0F_MASK             1U
#define TIM0_TFLG1_C1F_MASK             2U
#define TIM0_TFLG1_C2F_MASK             4U
#define TIM0_TFLG1_C3F_MASK             8U
#define TIM0_TFLG1_C4F_MASK             16U
#define TIM0_TFLG1_C5F_MASK             32U
#define TIM0_TFLG1_C6F_MASK             64U
#define TIM0_TFLG1_C7F_MASK             128U


/*** TIM0_TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TIM0_TFLG2STR;
extern volatile TIM0_TFLG2STR _TIM0_TFLG2 @(REG_BASE + 0x0000004FUL);
#define TIM0_TFLG2                      _TIM0_TFLG2.Byte
#define TIM0_TFLG2_TOF                  _TIM0_TFLG2.Bits.TOF

#define TIM0_TFLG2_TOF_MASK             128U


/*** TIM0_TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***/
    union {
      byte Byte;
    } TIM0_TC0HiSTR;
    #define TIM0_TC0Hi                  _TIM0_TC0.Overlap_STR.TIM0_TC0HiSTR.Byte
    

    /*** TIM0_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***/
    union {
      byte Byte;
    } TIM0_TC0LoSTR;
    #define TIM0_TC0Lo                  _TIM0_TC0.Overlap_STR.TIM0_TC0LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC0STR;
extern volatile TIM0_TC0STR _TIM0_TC0 @(REG_BASE + 0x00000050UL);
#define TIM0_TC0                        _TIM0_TC0.Word
/* TIM0_TC_ARR: Access 8 TIM0_TCx registers in an array */
#define TIM0_TC_ARR                     ((volatile word *) &TIM0_TC0)


/*** TIM0_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***/
    union {
      byte Byte;
    } TIM0_TC1HiSTR;
    #define TIM0_TC1Hi                  _TIM0_TC1.Overlap_STR.TIM0_TC1HiSTR.Byte
    

    /*** TIM0_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***/
    union {
      byte Byte;
    } TIM0_TC1LoSTR;
    #define TIM0_TC1Lo                  _TIM0_TC1.Overlap_STR.TIM0_TC1LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC1STR;
extern volatile TIM0_TC1STR _TIM0_TC1 @(REG_BASE + 0x00000052UL);
#define TIM0_TC1                        _TIM0_TC1.Word


/*** TIM0_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***/
    union {
      byte Byte;
    } TIM0_TC2HiSTR;
    #define TIM0_TC2Hi                  _TIM0_TC2.Overlap_STR.TIM0_TC2HiSTR.Byte
    

    /*** TIM0_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***/
    union {
      byte Byte;
    } TIM0_TC2LoSTR;
    #define TIM0_TC2Lo                  _TIM0_TC2.Overlap_STR.TIM0_TC2LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC2STR;
extern volatile TIM0_TC2STR _TIM0_TC2 @(REG_BASE + 0x00000054UL);
#define TIM0_TC2                        _TIM0_TC2.Word


/*** TIM0_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***/
    union {
      byte Byte;
    } TIM0_TC3HiSTR;
    #define TIM0_TC3Hi                  _TIM0_TC3.Overlap_STR.TIM0_TC3HiSTR.Byte
    

    /*** TIM0_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***/
    union {
      byte Byte;
    } TIM0_TC3LoSTR;
    #define TIM0_TC3Lo                  _TIM0_TC3.Overlap_STR.TIM0_TC3LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC3STR;
extern volatile TIM0_TC3STR _TIM0_TC3 @(REG_BASE + 0x00000056UL);
#define TIM0_TC3                        _TIM0_TC3.Word


/*** TIM0_TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } TIM0_TC4HiSTR;
    #define TIM0_TC4Hi                  _TIM0_TC4.Overlap_STR.TIM0_TC4HiSTR.Byte
    

    /*** TIM0_TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } TIM0_TC4LoSTR;
    #define TIM0_TC4Lo                  _TIM0_TC4.Overlap_STR.TIM0_TC4LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC4STR;
extern volatile TIM0_TC4STR _TIM0_TC4 @(REG_BASE + 0x00000058UL);
#define TIM0_TC4                        _TIM0_TC4.Word


/*** TIM0_TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } TIM0_TC5HiSTR;
    #define TIM0_TC5Hi                  _TIM0_TC5.Overlap_STR.TIM0_TC5HiSTR.Byte
    

    /*** TIM0_TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } TIM0_TC5LoSTR;
    #define TIM0_TC5Lo                  _TIM0_TC5.Overlap_STR.TIM0_TC5LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC5STR;
extern volatile TIM0_TC5STR _TIM0_TC5 @(REG_BASE + 0x0000005AUL);
#define TIM0_TC5                        _TIM0_TC5.Word


/*** TIM0_TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } TIM0_TC6HiSTR;
    #define TIM0_TC6Hi                  _TIM0_TC6.Overlap_STR.TIM0_TC6HiSTR.Byte
    

    /*** TIM0_TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } TIM0_TC6LoSTR;
    #define TIM0_TC6Lo                  _TIM0_TC6.Overlap_STR.TIM0_TC6LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC6STR;
extern volatile TIM0_TC6STR _TIM0_TC6 @(REG_BASE + 0x0000005CUL);
#define TIM0_TC6                        _TIM0_TC6.Word


/*** TIM0_TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } TIM0_TC7HiSTR;
    #define TIM0_TC7Hi                  _TIM0_TC7.Overlap_STR.TIM0_TC7HiSTR.Byte
    

    /*** TIM0_TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } TIM0_TC7LoSTR;
    #define TIM0_TC7Lo                  _TIM0_TC7.Overlap_STR.TIM0_TC7LoSTR.Byte
    
  } Overlap_STR;

} TIM0_TC7STR;
extern volatile TIM0_TC7STR _TIM0_TC7 @(REG_BASE + 0x0000005EUL);
#define TIM0_TC7                        _TIM0_TC7.Word


/*** TIM0_PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM0_PACTLSTR;
extern volatile TIM0_PACTLSTR _TIM0_PACTL @(REG_BASE + 0x00000060UL);
#define TIM0_PACTL                      _TIM0_PACTL.Byte
#define TIM0_PACTL_PAI                  _TIM0_PACTL.Bits.PAI
#define TIM0_PACTL_PAOVI                _TIM0_PACTL.Bits.PAOVI
#define TIM0_PACTL_CLK0                 _TIM0_PACTL.Bits.CLK0
#define TIM0_PACTL_CLK1                 _TIM0_PACTL.Bits.CLK1
#define TIM0_PACTL_PEDGE                _TIM0_PACTL.Bits.PEDGE
#define TIM0_PACTL_PAMOD                _TIM0_PACTL.Bits.PAMOD
#define TIM0_PACTL_PAEN                 _TIM0_PACTL.Bits.PAEN
#define TIM0_PACTL_CLK                  _TIM0_PACTL.MergedBits.grpCLK

#define TIM0_PACTL_PAI_MASK             1U
#define TIM0_PACTL_PAOVI_MASK           2U
#define TIM0_PACTL_CLK0_MASK            4U
#define TIM0_PACTL_CLK1_MASK            8U
#define TIM0_PACTL_PEDGE_MASK           16U
#define TIM0_PACTL_PAMOD_MASK           32U
#define TIM0_PACTL_PAEN_MASK            64U
#define TIM0_PACTL_CLK_MASK             12U
#define TIM0_PACTL_CLK_BITNUM           2U


/*** TIM0_PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} TIM0_PAFLGSTR;
extern volatile TIM0_PAFLGSTR _TIM0_PAFLG @(REG_BASE + 0x00000061UL);
#define TIM0_PAFLG                      _TIM0_PAFLG.Byte
#define TIM0_PAFLG_PAIF                 _TIM0_PAFLG.Bits.PAIF
#define TIM0_PAFLG_PAOVF                _TIM0_PAFLG.Bits.PAOVF

#define TIM0_PAFLG_PAIF_MASK            1U
#define TIM0_PAFLG_PAOVF_MASK           2U


/*** TIM0_PACNT - Pulse Accumulators Count Register; 0x00000062 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM0_PACNTH - Pulse Accumulators Count Register High; 0x00000062 ***/
    union {
      byte Byte;
    } TIM0_PACNTHSTR;
    #define TIM0_PACNTH                 _TIM0_PACNT.Overlap_STR.TIM0_PACNTHSTR.Byte
    

    /*** TIM0_PACNTL - Pulse Accumulators Count Register Low; 0x00000063 ***/
    union {
      byte Byte;
    } TIM0_PACNTLSTR;
    #define TIM0_PACNTL                 _TIM0_PACNT.Overlap_STR.TIM0_PACNTLSTR.Byte
    
  } Overlap_STR;

} TIM0_PACNTSTR;
extern volatile TIM0_PACNTSTR _TIM0_PACNT @(REG_BASE + 0x00000062UL);
#define TIM0_PACNT                      _TIM0_PACNT.Word


/*** TIM0_OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***/
typedef union {
  byte Byte;
  struct {
    byte OCPD0       :1;                                       /* Output Compare Pin Disconnect Bit 0 */
    byte OCPD1       :1;                                       /* Output Compare Pin Disconnect Bit 1 */
    byte OCPD2       :1;                                       /* Output Compare Pin Disconnect Bit 2 */
    byte OCPD3       :1;                                       /* Output Compare Pin Disconnect Bit 3 */
    byte OCPD4       :1;                                       /* Output Compare Pin Disconnect Bit 4 */
    byte OCPD5       :1;                                       /* Output Compare Pin Disconnect Bit 5 */
    byte OCPD6       :1;                                       /* Output Compare Pin Disconnect Bit 6 */
    byte OCPD7       :1;                                       /* Output Compare Pin Disconnect Bit 7 */
  } Bits;
} TIM0_OCPDSTR;
extern volatile TIM0_OCPDSTR _TIM0_OCPD @(REG_BASE + 0x0000006CUL);
#define TIM0_OCPD                       _TIM0_OCPD.Byte
#define TIM0_OCPD_OCPD0                 _TIM0_OCPD.Bits.OCPD0
#define TIM0_OCPD_OCPD1                 _TIM0_OCPD.Bits.OCPD1
#define TIM0_OCPD_OCPD2                 _TIM0_OCPD.Bits.OCPD2
#define TIM0_OCPD_OCPD3                 _TIM0_OCPD.Bits.OCPD3
#define TIM0_OCPD_OCPD4                 _TIM0_OCPD.Bits.OCPD4
#define TIM0_OCPD_OCPD5                 _TIM0_OCPD.Bits.OCPD5
#define TIM0_OCPD_OCPD6                 _TIM0_OCPD.Bits.OCPD6
#define TIM0_OCPD_OCPD7                 _TIM0_OCPD.Bits.OCPD7

#define TIM0_OCPD_OCPD0_MASK            1U
#define TIM0_OCPD_OCPD1_MASK            2U
#define TIM0_OCPD_OCPD2_MASK            4U
#define TIM0_OCPD_OCPD3_MASK            8U
#define TIM0_OCPD_OCPD4_MASK            16U
#define TIM0_OCPD_OCPD5_MASK            32U
#define TIM0_OCPD_OCPD6_MASK            64U
#define TIM0_OCPD_OCPD7_MASK            128U


/*** TIM0_PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***/
typedef union {
  byte Byte;
  struct {
    byte PTPS0       :1;                                       /* Precision Timer Prescaler Select Bit 0 */
    byte PTPS1       :1;                                       /* Precision Timer Prescaler Select Bit 1 */
    byte PTPS2       :1;                                       /* Precision Timer Prescaler Select Bit 2 */
    byte PTPS3       :1;                                       /* Precision Timer Prescaler Select Bit 3 */
    byte PTPS4       :1;                                       /* Precision Timer Prescaler Select Bit 4 */
    byte PTPS5       :1;                                       /* Precision Timer Prescaler Select Bit 5 */
    byte PTPS6       :1;                                       /* Precision Timer Prescaler Select Bit 6 */
    byte PTPS7       :1;                                       /* Precision Timer Prescaler Select Bit 7 */
  } Bits;
} TIM0_PTPSRSTR;
extern volatile TIM0_PTPSRSTR _TIM0_PTPSR @(REG_BASE + 0x0000006EUL);
#define TIM0_PTPSR                      _TIM0_PTPSR.Byte
#define TIM0_PTPSR_PTPS0                _TIM0_PTPSR.Bits.PTPS0
#define TIM0_PTPSR_PTPS1                _TIM0_PTPSR.Bits.PTPS1
#define TIM0_PTPSR_PTPS2                _TIM0_PTPSR.Bits.PTPS2
#define TIM0_PTPSR_PTPS3                _TIM0_PTPSR.Bits.PTPS3
#define TIM0_PTPSR_PTPS4                _TIM0_PTPSR.Bits.PTPS4
#define TIM0_PTPSR_PTPS5                _TIM0_PTPSR.Bits.PTPS5
#define TIM0_PTPSR_PTPS6                _TIM0_PTPSR.Bits.PTPS6
#define TIM0_PTPSR_PTPS7                _TIM0_PTPSR.Bits.PTPS7

#define TIM0_PTPSR_PTPS0_MASK           1U
#define TIM0_PTPSR_PTPS1_MASK           2U
#define TIM0_PTPSR_PTPS2_MASK           4U
#define TIM0_PTPSR_PTPS3_MASK           8U
#define TIM0_PTPSR_PTPS4_MASK           16U
#define TIM0_PTPSR_PTPS5_MASK           32U
#define TIM0_PTPSR_PTPS6_MASK           64U
#define TIM0_PTPSR_PTPS7_MASK           128U


/*** ATDCTL01 - ATD  Control Register 01; 0x00000070 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL0 - ATD  Control Register 0; 0x00000070 ***/
    union {
      byte Byte;
      struct {
        byte WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
        byte WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
        byte WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
        byte WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpWRAP :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL0STR;
    #define ATDCTL0                     _ATDCTL01.Overlap_STR.ATDCTL0STR.Byte
    #define ATDCTL0_WRAP0               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP0
    #define ATDCTL0_WRAP1               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP1
    #define ATDCTL0_WRAP2               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP2
    #define ATDCTL0_WRAP3               _ATDCTL01.Overlap_STR.ATDCTL0STR.Bits.WRAP3
    /* ATDCTL_ARR: Access 6 ATDCTLx registers in an array */
    #define ATDCTL_ARR                  ((volatile byte *) &ATDCTL0)
    #define ATDCTL0_WRAP                _ATDCTL01.Overlap_STR.ATDCTL0STR.MergedBits.grpWRAP
    
    #define ATDCTL0_WRAP0_MASK          1U
    #define ATDCTL0_WRAP1_MASK          2U
    #define ATDCTL0_WRAP2_MASK          4U
    #define ATDCTL0_WRAP3_MASK          8U
    #define ATDCTL0_WRAP_MASK           15U
    #define ATDCTL0_WRAP_BITNUM         0U
    

    /*** ATDCTL1 - ATD  Control Register 1; 0x00000071 ***/
    union {
      byte Byte;
      struct {
        byte ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
        byte ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
        byte ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
        byte ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
        byte SMP_DIS     :1;                                       /* Discharge Before Sampling Bit */
        byte SRES0       :1;                                       /* A/D Resolution Select Bit 0 */
        byte SRES1       :1;                                       /* A/D Resolution Select Bit 1 */
        byte ETRIGSEL    :1;                                       /* External Trigger Source Select */
      } Bits;
      struct {
        byte grpETRIGCH :4;
        byte     :1;
        byte grpSRES :2;
        byte     :1;
      } MergedBits;
    } ATDCTL1STR;
    #define ATDCTL1                     _ATDCTL01.Overlap_STR.ATDCTL1STR.Byte
    #define ATDCTL1_ETRIGCH0            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH0
    #define ATDCTL1_ETRIGCH1            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH1
    #define ATDCTL1_ETRIGCH2            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH2
    #define ATDCTL1_ETRIGCH3            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGCH3
    #define ATDCTL1_SMP_DIS             _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.SMP_DIS
    #define ATDCTL1_SRES0               _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.SRES0
    #define ATDCTL1_SRES1               _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.SRES1
    #define ATDCTL1_ETRIGSEL            _ATDCTL01.Overlap_STR.ATDCTL1STR.Bits.ETRIGSEL
    #define ATDCTL1_ETRIGCH             _ATDCTL01.Overlap_STR.ATDCTL1STR.MergedBits.grpETRIGCH
    #define ATDCTL1_SRES                _ATDCTL01.Overlap_STR.ATDCTL1STR.MergedBits.grpSRES
    
    #define ATDCTL1_ETRIGCH0_MASK       1U
    #define ATDCTL1_ETRIGCH1_MASK       2U
    #define ATDCTL1_ETRIGCH2_MASK       4U
    #define ATDCTL1_ETRIGCH3_MASK       8U
    #define ATDCTL1_SMP_DIS_MASK        16U
    #define ATDCTL1_SRES0_MASK          32U
    #define ATDCTL1_SRES1_MASK          64U
    #define ATDCTL1_ETRIGSEL_MASK       128U
    #define ATDCTL1_ETRIGCH_MASK        15U
    #define ATDCTL1_ETRIGCH_BITNUM      0U
    #define ATDCTL1_SRES_MASK           96U
    #define ATDCTL1_SRES_BITNUM         5U
    
  } Overlap_STR;

  struct {
    word ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
    word ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
    word ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
    word ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
    word SMP_DIS     :1;                                       /* Discharge Before Sampling Bit */
    word SRES0       :1;                                       /* A/D Resolution Select Bit 0 */
    word SRES1       :1;                                       /* A/D Resolution Select Bit 1 */
    word ETRIGSEL    :1;                                       /* External Trigger Source Select */
    word WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
    word WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
    word WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
    word WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpETRIGCH :4;
    word         :1;
    word grpSRES :2;
    word         :1;
    word grpWRAP :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCTL01STR;
extern volatile ATDCTL01STR _ATDCTL01 @(REG_BASE + 0x00000070UL);
#define ATDCTL01                        _ATDCTL01.Word
#define ATDCTL01_ETRIGCH0               _ATDCTL01.Bits.ETRIGCH0
#define ATDCTL01_ETRIGCH1               _ATDCTL01.Bits.ETRIGCH1
#define ATDCTL01_ETRIGCH2               _ATDCTL01.Bits.ETRIGCH2
#define ATDCTL01_ETRIGCH3               _ATDCTL01.Bits.ETRIGCH3
#define ATDCTL01_SMP_DIS                _ATDCTL01.Bits.SMP_DIS
#define ATDCTL01_SRES0                  _ATDCTL01.Bits.SRES0
#define ATDCTL01_SRES1                  _ATDCTL01.Bits.SRES1
#define ATDCTL01_ETRIGSEL               _ATDCTL01.Bits.ETRIGSEL
#define ATDCTL01_WRAP0                  _ATDCTL01.Bits.WRAP0
#define ATDCTL01_WRAP1                  _ATDCTL01.Bits.WRAP1
#define ATDCTL01_WRAP2                  _ATDCTL01.Bits.WRAP2
#define ATDCTL01_WRAP3                  _ATDCTL01.Bits.WRAP3
#define ATDCTL01_ETRIGCH                _ATDCTL01.MergedBits.grpETRIGCH
#define ATDCTL01_SRES                   _ATDCTL01.MergedBits.grpSRES
#define ATDCTL01_WRAP                   _ATDCTL01.MergedBits.grpWRAP

#define ATDCTL01_ETRIGCH0_MASK          1U
#define ATDCTL01_ETRIGCH1_MASK          2U
#define ATDCTL01_ETRIGCH2_MASK          4U
#define ATDCTL01_ETRIGCH3_MASK          8U
#define ATDCTL01_SMP_DIS_MASK           16U
#define ATDCTL01_SRES0_MASK             32U
#define ATDCTL01_SRES1_MASK             64U
#define ATDCTL01_ETRIGSEL_MASK          128U
#define ATDCTL01_WRAP0_MASK             256U
#define ATDCTL01_WRAP1_MASK             512U
#define ATDCTL01_WRAP2_MASK             1024U
#define ATDCTL01_WRAP3_MASK             2048U
#define ATDCTL01_ETRIGCH_MASK           15U
#define ATDCTL01_ETRIGCH_BITNUM         0U
#define ATDCTL01_SRES_MASK              96U
#define ATDCTL01_SRES_BITNUM            5U
#define ATDCTL01_WRAP_MASK              3840U
#define ATDCTL01_WRAP_BITNUM            8U


/*** ATDCTL23 - ATD  Control Register 23; 0x00000072 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL2 - ATD  Control Register 2; 0x00000072 ***/
    union {
      byte Byte;
      struct {
        byte ACMPIE      :1;                                       /* ATD Compare Interrupt Enable */
        byte ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
        byte ETRIGE      :1;                                       /* External Trigger Mode enable */
        byte ETRIGP      :1;                                       /* External Trigger Polarity */
        byte ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
        byte ICLKSTP     :1;                                       /* Internal Clock in Stop Mode Bit */
        byte AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
        byte             :1; 
      } Bits;
    } ATDCTL2STR;
    #define ATDCTL2                     _ATDCTL23.Overlap_STR.ATDCTL2STR.Byte
    #define ATDCTL2_ACMPIE              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ACMPIE
    #define ATDCTL2_ASCIE               _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ASCIE
    #define ATDCTL2_ETRIGE              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGE
    #define ATDCTL2_ETRIGP              _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGP
    #define ATDCTL2_ETRIGLE             _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ETRIGLE
    #define ATDCTL2_ICLKSTP             _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.ICLKSTP
    #define ATDCTL2_AFFC                _ATDCTL23.Overlap_STR.ATDCTL2STR.Bits.AFFC
    
    #define ATDCTL2_ACMPIE_MASK         1U
    #define ATDCTL2_ASCIE_MASK          2U
    #define ATDCTL2_ETRIGE_MASK         4U
    #define ATDCTL2_ETRIGP_MASK         8U
    #define ATDCTL2_ETRIGLE_MASK        16U
    #define ATDCTL2_ICLKSTP_MASK        32U
    #define ATDCTL2_AFFC_MASK           64U
    

    /*** ATDCTL3 - ATD  Control Register 3; 0x00000073 ***/
    union {
      byte Byte;
      struct {
        byte FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
        byte FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
        byte FIFO        :1;                                       /* Result Register FIFO Mode */
        byte S1C         :1;                                       /* Conversion Sequence Length 1 */
        byte S2C         :1;                                       /* Conversion Sequence Length 2 */
        byte S4C         :1;                                       /* Conversion Sequence Length 4 */
        byte S8C         :1;                                       /* Conversion Sequence Length 8 */
        byte DJM         :1;                                       /* Result Register Data Justification */
      } Bits;
      struct {
        byte grpFRZ :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL3STR;
    #define ATDCTL3                     _ATDCTL23.Overlap_STR.ATDCTL3STR.Byte
    #define ATDCTL3_FRZ0                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ0
    #define ATDCTL3_FRZ1                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FRZ1
    #define ATDCTL3_FIFO                _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.FIFO
    #define ATDCTL3_S1C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S1C
    #define ATDCTL3_S2C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S2C
    #define ATDCTL3_S4C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S4C
    #define ATDCTL3_S8C                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.S8C
    #define ATDCTL3_DJM                 _ATDCTL23.Overlap_STR.ATDCTL3STR.Bits.DJM
    #define ATDCTL3_FRZ                 _ATDCTL23.Overlap_STR.ATDCTL3STR.MergedBits.grpFRZ
    
    #define ATDCTL3_FRZ0_MASK           1U
    #define ATDCTL3_FRZ1_MASK           2U
    #define ATDCTL3_FIFO_MASK           4U
    #define ATDCTL3_S1C_MASK            8U
    #define ATDCTL3_S2C_MASK            16U
    #define ATDCTL3_S4C_MASK            32U
    #define ATDCTL3_S8C_MASK            64U
    #define ATDCTL3_DJM_MASK            128U
    #define ATDCTL3_FRZ_MASK            3U
    #define ATDCTL3_FRZ_BITNUM          0U
    
  } Overlap_STR;

  struct {
    word FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
    word FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
    word FIFO        :1;                                       /* Result Register FIFO Mode */
    word S1C         :1;                                       /* Conversion Sequence Length 1 */
    word S2C         :1;                                       /* Conversion Sequence Length 2 */
    word S4C         :1;                                       /* Conversion Sequence Length 4 */
    word S8C         :1;                                       /* Conversion Sequence Length 8 */
    word DJM         :1;                                       /* Result Register Data Justification */
    word ACMPIE      :1;                                       /* ATD Compare Interrupt Enable */
    word ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
    word ETRIGE      :1;                                       /* External Trigger Mode enable */
    word ETRIGP      :1;                                       /* External Trigger Polarity */
    word ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
    word ICLKSTP     :1;                                       /* Internal Clock in Stop Mode Bit */
    word AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
    word             :1; 
  } Bits;
  struct {
    word grpFRZ  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCTL23STR;
extern volatile ATDCTL23STR _ATDCTL23 @(REG_BASE + 0x00000072UL);
#define ATDCTL23                        _ATDCTL23.Word
#define ATDCTL23_FRZ0                   _ATDCTL23.Bits.FRZ0
#define ATDCTL23_FRZ1                   _ATDCTL23.Bits.FRZ1
#define ATDCTL23_FIFO                   _ATDCTL23.Bits.FIFO
#define ATDCTL23_S1C                    _ATDCTL23.Bits.S1C
#define ATDCTL23_S2C                    _ATDCTL23.Bits.S2C
#define ATDCTL23_S4C                    _ATDCTL23.Bits.S4C
#define ATDCTL23_S8C                    _ATDCTL23.Bits.S8C
#define ATDCTL23_DJM                    _ATDCTL23.Bits.DJM
#define ATDCTL23_ACMPIE                 _ATDCTL23.Bits.ACMPIE
#define ATDCTL23_ASCIE                  _ATDCTL23.Bits.ASCIE
#define ATDCTL23_ETRIGE                 _ATDCTL23.Bits.ETRIGE
#define ATDCTL23_ETRIGP                 _ATDCTL23.Bits.ETRIGP
#define ATDCTL23_ETRIGLE                _ATDCTL23.Bits.ETRIGLE
#define ATDCTL23_ICLKSTP                _ATDCTL23.Bits.ICLKSTP
#define ATDCTL23_AFFC                   _ATDCTL23.Bits.AFFC
#define ATDCTL23_FRZ                    _ATDCTL23.MergedBits.grpFRZ

#define ATDCTL23_FRZ0_MASK              1U
#define ATDCTL23_FRZ1_MASK              2U
#define ATDCTL23_FIFO_MASK              4U
#define ATDCTL23_S1C_MASK               8U
#define ATDCTL23_S2C_MASK               16U
#define ATDCTL23_S4C_MASK               32U
#define ATDCTL23_S8C_MASK               64U
#define ATDCTL23_DJM_MASK               128U
#define ATDCTL23_ACMPIE_MASK            256U
#define ATDCTL23_ASCIE_MASK             512U
#define ATDCTL23_ETRIGE_MASK            1024U
#define ATDCTL23_ETRIGP_MASK            2048U
#define ATDCTL23_ETRIGLE_MASK           4096U
#define ATDCTL23_ICLKSTP_MASK           8192U
#define ATDCTL23_AFFC_MASK              16384U
#define ATDCTL23_FRZ_MASK               3U
#define ATDCTL23_FRZ_BITNUM             0U


/*** ATDCTL45 - ATD  Control Register 45; 0x00000074 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCTL4 - ATD  Control Register 4; 0x00000074 ***/
    union {
      byte Byte;
      struct {
        byte PRS0        :1;                                       /* ATD Clock Prescaler 0 */
        byte PRS1        :1;                                       /* ATD Clock Prescaler 1 */
        byte PRS2        :1;                                       /* ATD Clock Prescaler 2 */
        byte PRS3        :1;                                       /* ATD Clock Prescaler 3 */
        byte PRS4        :1;                                       /* ATD Clock Prescaler 4 */
        byte SMP0        :1;                                       /* Sample Time Select 0 */
        byte SMP1        :1;                                       /* Sample Time Select 1 */
        byte SMP2        :1;                                       /* Sample Time Select 2 */
      } Bits;
      struct {
        byte grpPRS :5;
        byte grpSMP :3;
      } MergedBits;
    } ATDCTL4STR;
    #define ATDCTL4                     _ATDCTL45.Overlap_STR.ATDCTL4STR.Byte
    #define ATDCTL4_PRS0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS0
    #define ATDCTL4_PRS1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS1
    #define ATDCTL4_PRS2                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS2
    #define ATDCTL4_PRS3                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS3
    #define ATDCTL4_PRS4                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.PRS4
    #define ATDCTL4_SMP0                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP0
    #define ATDCTL4_SMP1                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP1
    #define ATDCTL4_SMP2                _ATDCTL45.Overlap_STR.ATDCTL4STR.Bits.SMP2
    #define ATDCTL4_PRS                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpPRS
    #define ATDCTL4_SMP                 _ATDCTL45.Overlap_STR.ATDCTL4STR.MergedBits.grpSMP
    
    #define ATDCTL4_PRS0_MASK           1U
    #define ATDCTL4_PRS1_MASK           2U
    #define ATDCTL4_PRS2_MASK           4U
    #define ATDCTL4_PRS3_MASK           8U
    #define ATDCTL4_PRS4_MASK           16U
    #define ATDCTL4_SMP0_MASK           32U
    #define ATDCTL4_SMP1_MASK           64U
    #define ATDCTL4_SMP2_MASK           128U
    #define ATDCTL4_PRS_MASK            31U
    #define ATDCTL4_PRS_BITNUM          0U
    #define ATDCTL4_SMP_MASK            224U
    #define ATDCTL4_SMP_BITNUM          5U
    

    /*** ATDCTL5 - ATD  Control Register 5; 0x00000075 ***/
    union {
      byte Byte;
      struct {
        byte CA          :1;                                       /* Analog Input Channel Select Code A */
        byte CB          :1;                                       /* Analog Input Channel Select Code B */
        byte CC          :1;                                       /* Analog Input Channel Select Code C */
        byte CD          :1;                                       /* Analog Input Channel Select Code D */
        byte MULT        :1;                                       /* Multi-Channel Sample Mode */
        byte SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
        byte SC          :1;                                       /* Special Channel Conversion Bit */
        byte             :1; 
      } Bits;
      struct {
        byte grpCx :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCTL5STR;
    #define ATDCTL5                     _ATDCTL45.Overlap_STR.ATDCTL5STR.Byte
    #define ATDCTL5_CA                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CA
    #define ATDCTL5_CB                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CB
    #define ATDCTL5_CC                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CC
    #define ATDCTL5_CD                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.CD
    #define ATDCTL5_MULT                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.MULT
    #define ATDCTL5_SCAN                _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.SCAN
    #define ATDCTL5_SC                  _ATDCTL45.Overlap_STR.ATDCTL5STR.Bits.SC
    #define ATDCTL5_Cx                  _ATDCTL45.Overlap_STR.ATDCTL5STR.MergedBits.grpCx
    
    #define ATDCTL5_CA_MASK             1U
    #define ATDCTL5_CB_MASK             2U
    #define ATDCTL5_CC_MASK             4U
    #define ATDCTL5_CD_MASK             8U
    #define ATDCTL5_MULT_MASK           16U
    #define ATDCTL5_SCAN_MASK           32U
    #define ATDCTL5_SC_MASK             64U
    #define ATDCTL5_Cx_MASK             15U
    #define ATDCTL5_Cx_BITNUM           0U
    
  } Overlap_STR;

  struct {
    word CA          :1;                                       /* Analog Input Channel Select Code A */
    word CB          :1;                                       /* Analog Input Channel Select Code B */
    word CC          :1;                                       /* Analog Input Channel Select Code C */
    word CD          :1;                                       /* Analog Input Channel Select Code D */
    word MULT        :1;                                       /* Multi-Channel Sample Mode */
    word SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
    word SC          :1;                                       /* Special Channel Conversion Bit */
    word             :1; 
    word PRS0        :1;                                       /* ATD Clock Prescaler 0 */
    word PRS1        :1;                                       /* ATD Clock Prescaler 1 */
    word PRS2        :1;                                       /* ATD Clock Prescaler 2 */
    word PRS3        :1;                                       /* ATD Clock Prescaler 3 */
    word PRS4        :1;                                       /* ATD Clock Prescaler 4 */
    word SMP0        :1;                                       /* Sample Time Select 0 */
    word SMP1        :1;                                       /* Sample Time Select 1 */
    word SMP2        :1;                                       /* Sample Time Select 2 */
  } Bits;
  struct {
    word grpCx   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRS  :5;
    word grpSMP  :3;
  } MergedBits;
} ATDCTL45STR;
extern volatile ATDCTL45STR _ATDCTL45 @(REG_BASE + 0x00000074UL);
#define ATDCTL45                        _ATDCTL45.Word
#define ATDCTL45_CA                     _ATDCTL45.Bits.CA
#define ATDCTL45_CB                     _ATDCTL45.Bits.CB
#define ATDCTL45_CC                     _ATDCTL45.Bits.CC
#define ATDCTL45_CD                     _ATDCTL45.Bits.CD
#define ATDCTL45_MULT                   _ATDCTL45.Bits.MULT
#define ATDCTL45_SCAN                   _ATDCTL45.Bits.SCAN
#define ATDCTL45_SC                     _ATDCTL45.Bits.SC
#define ATDCTL45_PRS0                   _ATDCTL45.Bits.PRS0
#define ATDCTL45_PRS1                   _ATDCTL45.Bits.PRS1
#define ATDCTL45_PRS2                   _ATDCTL45.Bits.PRS2
#define ATDCTL45_PRS3                   _ATDCTL45.Bits.PRS3
#define ATDCTL45_PRS4                   _ATDCTL45.Bits.PRS4
#define ATDCTL45_SMP0                   _ATDCTL45.Bits.SMP0
#define ATDCTL45_SMP1                   _ATDCTL45.Bits.SMP1
#define ATDCTL45_SMP2                   _ATDCTL45.Bits.SMP2
#define ATDCTL45_Cx                     _ATDCTL45.MergedBits.grpCx
#define ATDCTL45_PRS                    _ATDCTL45.MergedBits.grpPRS
#define ATDCTL45_SMP                    _ATDCTL45.MergedBits.grpSMP

#define ATDCTL45_CA_MASK                1U
#define ATDCTL45_CB_MASK                2U
#define ATDCTL45_CC_MASK                4U
#define ATDCTL45_CD_MASK                8U
#define ATDCTL45_MULT_MASK              16U
#define ATDCTL45_SCAN_MASK              32U
#define ATDCTL45_SC_MASK                64U
#define ATDCTL45_PRS0_MASK              256U
#define ATDCTL45_PRS1_MASK              512U
#define ATDCTL45_PRS2_MASK              1024U
#define ATDCTL45_PRS3_MASK              2048U
#define ATDCTL45_PRS4_MASK              4096U
#define ATDCTL45_SMP0_MASK              8192U
#define ATDCTL45_SMP1_MASK              16384U
#define ATDCTL45_SMP2_MASK              32768U
#define ATDCTL45_Cx_MASK                15U
#define ATDCTL45_Cx_BITNUM              0U
#define ATDCTL45_PRS_MASK               7936U
#define ATDCTL45_PRS_BITNUM             8U
#define ATDCTL45_SMP_MASK               57344U
#define ATDCTL45_SMP_BITNUM             13U


/*** ATDSTAT0 - ATD  Status Register 0; 0x00000076 ***/
typedef union {
  byte Byte;
  struct {
    byte CC0         :1;                                       /* Conversion Counter 0 */
    byte CC1         :1;                                       /* Conversion Counter 1 */
    byte CC2         :1;                                       /* Conversion Counter 2 */
    byte CC3         :1;                                       /* Conversion Counter 3 */
    byte FIFOR       :1;                                       /* FIFO Over Run Flag */
    byte ETORF       :1;                                       /* External Trigger Overrun Flag */
    byte             :1; 
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
  struct {
    byte grpCC   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ATDSTAT0STR;
extern volatile ATDSTAT0STR _ATDSTAT0 @(REG_BASE + 0x00000076UL);
#define ATDSTAT0                        _ATDSTAT0.Byte
#define ATDSTAT0_CC0                    _ATDSTAT0.Bits.CC0
#define ATDSTAT0_CC1                    _ATDSTAT0.Bits.CC1
#define ATDSTAT0_CC2                    _ATDSTAT0.Bits.CC2
#define ATDSTAT0_CC3                    _ATDSTAT0.Bits.CC3
#define ATDSTAT0_FIFOR                  _ATDSTAT0.Bits.FIFOR
#define ATDSTAT0_ETORF                  _ATDSTAT0.Bits.ETORF
#define ATDSTAT0_SCF                    _ATDSTAT0.Bits.SCF
#define ATDSTAT0_CC                     _ATDSTAT0.MergedBits.grpCC

#define ATDSTAT0_CC0_MASK               1U
#define ATDSTAT0_CC1_MASK               2U
#define ATDSTAT0_CC2_MASK               4U
#define ATDSTAT0_CC3_MASK               8U
#define ATDSTAT0_FIFOR_MASK             16U
#define ATDSTAT0_ETORF_MASK             32U
#define ATDSTAT0_SCF_MASK               128U
#define ATDSTAT0_CC_MASK                15U
#define ATDSTAT0_CC_BITNUM              0U


/*** ATDCMPE - ATD  Compare Enable Register; 0x00000078 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCMPEH - ATD  Compare Enable Register High; 0x00000078 ***/
    union {
      byte Byte;
      struct {
        byte CMPE8       :1;                                       /* Compare Enable for Conversion Number 8 of a Sequence */
        byte CMPE9       :1;                                       /* Compare Enable for Conversion Number 9 of a Sequence */
        byte CMPE10      :1;                                       /* Compare Enable for Conversion Number 10 of a Sequence */
        byte CMPE11      :1;                                       /* Compare Enable for Conversion Number 11 of a Sequence */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpCMPE_8 :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCMPEHSTR;
    #define ATDCMPEH                    _ATDCMPE.Overlap_STR.ATDCMPEHSTR.Byte
    #define ATDCMPEH_CMPE8              _ATDCMPE.Overlap_STR.ATDCMPEHSTR.Bits.CMPE8
    #define ATDCMPEH_CMPE9              _ATDCMPE.Overlap_STR.ATDCMPEHSTR.Bits.CMPE9
    #define ATDCMPEH_CMPE10             _ATDCMPE.Overlap_STR.ATDCMPEHSTR.Bits.CMPE10
    #define ATDCMPEH_CMPE11             _ATDCMPE.Overlap_STR.ATDCMPEHSTR.Bits.CMPE11
    #define ATDCMPEH_CMPE_8             _ATDCMPE.Overlap_STR.ATDCMPEHSTR.MergedBits.grpCMPE_8
    #define ATDCMPEH_CMPE               ATDCMPEH_CMPE_8
    
    #define ATDCMPEH_CMPE8_MASK         1U
    #define ATDCMPEH_CMPE9_MASK         2U
    #define ATDCMPEH_CMPE10_MASK        4U
    #define ATDCMPEH_CMPE11_MASK        8U
    #define ATDCMPEH_CMPE_8_MASK        15U
    #define ATDCMPEH_CMPE_8_BITNUM      0U
    

    /*** ATDCMPEL - ATD  Compare Enable Register Low; 0x00000079 ***/
    union {
      byte Byte;
      struct {
        byte CMPE0       :1;                                       /* Compare Enable for Conversion Number 0 of a Sequence */
        byte CMPE1       :1;                                       /* Compare Enable for Conversion Number 1 of a Sequence */
        byte CMPE2       :1;                                       /* Compare Enable for Conversion Number 2 of a Sequence */
        byte CMPE3       :1;                                       /* Compare Enable for Conversion Number 3 of a Sequence */
        byte CMPE4       :1;                                       /* Compare Enable for Conversion Number 4 of a Sequence */
        byte CMPE5       :1;                                       /* Compare Enable for Conversion Number 5 of a Sequence */
        byte CMPE6       :1;                                       /* Compare Enable for Conversion Number 6 of a Sequence */
        byte CMPE7       :1;                                       /* Compare Enable for Conversion Number 7 of a Sequence */
      } Bits;
    } ATDCMPELSTR;
    #define ATDCMPEL                    _ATDCMPE.Overlap_STR.ATDCMPELSTR.Byte
    #define ATDCMPEL_CMPE0              _ATDCMPE.Overlap_STR.ATDCMPELSTR.Bits.CMPE0
    #define ATDCMPEL_CMPE1              _ATDCMPE.Overlap_STR.ATDCMPELSTR.Bits.CMPE1
    #define ATDCMPEL_CMPE2              _ATDCMPE.Overlap_STR.ATDCMPELSTR.Bits.CMPE2
    #define ATDCMPEL_CMPE3              _ATDCMPE.Overlap_STR.ATDCMPELSTR.Bits.CMPE3
    #define ATDCMPEL_CMPE4              _ATDCMPE.Overlap_STR.ATDCMPELSTR.Bits.CMPE4
    #define ATDCMPEL_CMPE5              _ATDCMPE.Overlap_STR.ATDCMPELSTR.Bits.CMPE5
    #define ATDCMPEL_CMPE6              _ATDCMPE.Overlap_STR.ATDCMPELSTR.Bits.CMPE6
    #define ATDCMPEL_CMPE7              _ATDCMPE.Overlap_STR.ATDCMPELSTR.Bits.CMPE7
    
    #define ATDCMPEL_CMPE0_MASK         1U
    #define ATDCMPEL_CMPE1_MASK         2U
    #define ATDCMPEL_CMPE2_MASK         4U
    #define ATDCMPEL_CMPE3_MASK         8U
    #define ATDCMPEL_CMPE4_MASK         16U
    #define ATDCMPEL_CMPE5_MASK         32U
    #define ATDCMPEL_CMPE6_MASK         64U
    #define ATDCMPEL_CMPE7_MASK         128U
    
  } Overlap_STR;

  struct {
    word CMPE0       :1;                                       /* Compare Enable for Conversion Number 0 of a Sequence */
    word CMPE1       :1;                                       /* Compare Enable for Conversion Number 1 of a Sequence */
    word CMPE2       :1;                                       /* Compare Enable for Conversion Number 2 of a Sequence */
    word CMPE3       :1;                                       /* Compare Enable for Conversion Number 3 of a Sequence */
    word CMPE4       :1;                                       /* Compare Enable for Conversion Number 4 of a Sequence */
    word CMPE5       :1;                                       /* Compare Enable for Conversion Number 5 of a Sequence */
    word CMPE6       :1;                                       /* Compare Enable for Conversion Number 6 of a Sequence */
    word CMPE7       :1;                                       /* Compare Enable for Conversion Number 7 of a Sequence */
    word CMPE8       :1;                                       /* Compare Enable for Conversion Number 8 of a Sequence */
    word CMPE9       :1;                                       /* Compare Enable for Conversion Number 9 of a Sequence */
    word CMPE10      :1;                                       /* Compare Enable for Conversion Number 10 of a Sequence */
    word CMPE11      :1;                                       /* Compare Enable for Conversion Number 11 of a Sequence */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpCMPE :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCMPESTR;
extern volatile ATDCMPESTR _ATDCMPE @(REG_BASE + 0x00000078UL);
#define ATDCMPE                         _ATDCMPE.Word
#define ATDCMPE_CMPE0                   _ATDCMPE.Bits.CMPE0
#define ATDCMPE_CMPE1                   _ATDCMPE.Bits.CMPE1
#define ATDCMPE_CMPE2                   _ATDCMPE.Bits.CMPE2
#define ATDCMPE_CMPE3                   _ATDCMPE.Bits.CMPE3
#define ATDCMPE_CMPE4                   _ATDCMPE.Bits.CMPE4
#define ATDCMPE_CMPE5                   _ATDCMPE.Bits.CMPE5
#define ATDCMPE_CMPE6                   _ATDCMPE.Bits.CMPE6
#define ATDCMPE_CMPE7                   _ATDCMPE.Bits.CMPE7
#define ATDCMPE_CMPE8                   _ATDCMPE.Bits.CMPE8
#define ATDCMPE_CMPE9                   _ATDCMPE.Bits.CMPE9
#define ATDCMPE_CMPE10                  _ATDCMPE.Bits.CMPE10
#define ATDCMPE_CMPE11                  _ATDCMPE.Bits.CMPE11
#define ATDCMPE_CMPE                    _ATDCMPE.MergedBits.grpCMPE

#define ATDCMPE_CMPE0_MASK              1U
#define ATDCMPE_CMPE1_MASK              2U
#define ATDCMPE_CMPE2_MASK              4U
#define ATDCMPE_CMPE3_MASK              8U
#define ATDCMPE_CMPE4_MASK              16U
#define ATDCMPE_CMPE5_MASK              32U
#define ATDCMPE_CMPE6_MASK              64U
#define ATDCMPE_CMPE7_MASK              128U
#define ATDCMPE_CMPE8_MASK              256U
#define ATDCMPE_CMPE9_MASK              512U
#define ATDCMPE_CMPE10_MASK             1024U
#define ATDCMPE_CMPE11_MASK             2048U
#define ATDCMPE_CMPE_MASK               4095U
#define ATDCMPE_CMPE_BITNUM             0U


/*** ATDSTAT2 - ATD  Status Register 2; 0x0000007A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDSTAT2H - ATD  Status Register 2 High; 0x0000007A ***/
    union {
      byte Byte;
      struct {
        byte CCF8        :1;                                       /* Conversion Complete Flag 8 */
        byte CCF9        :1;                                       /* Conversion Complete Flag 9 */
        byte CCF10       :1;                                       /* Conversion Complete Flag 10 */
        byte CCF11       :1;                                       /* Conversion Complete Flag 11 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpCCF_8 :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDSTAT2HSTR;
    #define ATDSTAT2H                   _ATDSTAT2.Overlap_STR.ATDSTAT2HSTR.Byte
    #define ATDSTAT2H_CCF8              _ATDSTAT2.Overlap_STR.ATDSTAT2HSTR.Bits.CCF8
    #define ATDSTAT2H_CCF9              _ATDSTAT2.Overlap_STR.ATDSTAT2HSTR.Bits.CCF9
    #define ATDSTAT2H_CCF10             _ATDSTAT2.Overlap_STR.ATDSTAT2HSTR.Bits.CCF10
    #define ATDSTAT2H_CCF11             _ATDSTAT2.Overlap_STR.ATDSTAT2HSTR.Bits.CCF11
    #define ATDSTAT2H_CCF_8             _ATDSTAT2.Overlap_STR.ATDSTAT2HSTR.MergedBits.grpCCF_8
    #define ATDSTAT2H_CCF               ATDSTAT2H_CCF_8
    
    #define ATDSTAT2H_CCF8_MASK         1U
    #define ATDSTAT2H_CCF9_MASK         2U
    #define ATDSTAT2H_CCF10_MASK        4U
    #define ATDSTAT2H_CCF11_MASK        8U
    #define ATDSTAT2H_CCF_8_MASK        15U
    #define ATDSTAT2H_CCF_8_BITNUM      0U
    

    /*** ATDSTAT2L - ATD  Status Register 2 Low; 0x0000007B ***/
    union {
      byte Byte;
      struct {
        byte CCF0        :1;                                       /* Conversion Complete Flag 0 */
        byte CCF1        :1;                                       /* Conversion Complete Flag 1 */
        byte CCF2        :1;                                       /* Conversion Complete Flag 2 */
        byte CCF3        :1;                                       /* Conversion Complete Flag 3 */
        byte CCF4        :1;                                       /* Conversion Complete Flag 4 */
        byte CCF5        :1;                                       /* Conversion Complete Flag 5 */
        byte CCF6        :1;                                       /* Conversion Complete Flag 6 */
        byte CCF7        :1;                                       /* Conversion Complete Flag 7 */
      } Bits;
    } ATDSTAT2LSTR;
    #define ATDSTAT2L                   _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Byte
    #define ATDSTAT2L_CCF0              _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Bits.CCF0
    #define ATDSTAT2L_CCF1              _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Bits.CCF1
    #define ATDSTAT2L_CCF2              _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Bits.CCF2
    #define ATDSTAT2L_CCF3              _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Bits.CCF3
    #define ATDSTAT2L_CCF4              _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Bits.CCF4
    #define ATDSTAT2L_CCF5              _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Bits.CCF5
    #define ATDSTAT2L_CCF6              _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Bits.CCF6
    #define ATDSTAT2L_CCF7              _ATDSTAT2.Overlap_STR.ATDSTAT2LSTR.Bits.CCF7
    
    #define ATDSTAT2L_CCF0_MASK         1U
    #define ATDSTAT2L_CCF1_MASK         2U
    #define ATDSTAT2L_CCF2_MASK         4U
    #define ATDSTAT2L_CCF3_MASK         8U
    #define ATDSTAT2L_CCF4_MASK         16U
    #define ATDSTAT2L_CCF5_MASK         32U
    #define ATDSTAT2L_CCF6_MASK         64U
    #define ATDSTAT2L_CCF7_MASK         128U
    
  } Overlap_STR;

  struct {
    word CCF0        :1;                                       /* Conversion Complete Flag 0 */
    word CCF1        :1;                                       /* Conversion Complete Flag 1 */
    word CCF2        :1;                                       /* Conversion Complete Flag 2 */
    word CCF3        :1;                                       /* Conversion Complete Flag 3 */
    word CCF4        :1;                                       /* Conversion Complete Flag 4 */
    word CCF5        :1;                                       /* Conversion Complete Flag 5 */
    word CCF6        :1;                                       /* Conversion Complete Flag 6 */
    word CCF7        :1;                                       /* Conversion Complete Flag 7 */
    word CCF8        :1;                                       /* Conversion Complete Flag 8 */
    word CCF9        :1;                                       /* Conversion Complete Flag 9 */
    word CCF10       :1;                                       /* Conversion Complete Flag 10 */
    word CCF11       :1;                                       /* Conversion Complete Flag 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpCCF  :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDSTAT2STR;
extern volatile ATDSTAT2STR _ATDSTAT2 @(REG_BASE + 0x0000007AUL);
#define ATDSTAT2                        _ATDSTAT2.Word
#define ATDSTAT2_CCF0                   _ATDSTAT2.Bits.CCF0
#define ATDSTAT2_CCF1                   _ATDSTAT2.Bits.CCF1
#define ATDSTAT2_CCF2                   _ATDSTAT2.Bits.CCF2
#define ATDSTAT2_CCF3                   _ATDSTAT2.Bits.CCF3
#define ATDSTAT2_CCF4                   _ATDSTAT2.Bits.CCF4
#define ATDSTAT2_CCF5                   _ATDSTAT2.Bits.CCF5
#define ATDSTAT2_CCF6                   _ATDSTAT2.Bits.CCF6
#define ATDSTAT2_CCF7                   _ATDSTAT2.Bits.CCF7
#define ATDSTAT2_CCF8                   _ATDSTAT2.Bits.CCF8
#define ATDSTAT2_CCF9                   _ATDSTAT2.Bits.CCF9
#define ATDSTAT2_CCF10                  _ATDSTAT2.Bits.CCF10
#define ATDSTAT2_CCF11                  _ATDSTAT2.Bits.CCF11
#define ATDSTAT2_CCF                    _ATDSTAT2.MergedBits.grpCCF

#define ATDSTAT2_CCF0_MASK              1U
#define ATDSTAT2_CCF1_MASK              2U
#define ATDSTAT2_CCF2_MASK              4U
#define ATDSTAT2_CCF3_MASK              8U
#define ATDSTAT2_CCF4_MASK              16U
#define ATDSTAT2_CCF5_MASK              32U
#define ATDSTAT2_CCF6_MASK              64U
#define ATDSTAT2_CCF7_MASK              128U
#define ATDSTAT2_CCF8_MASK              256U
#define ATDSTAT2_CCF9_MASK              512U
#define ATDSTAT2_CCF10_MASK             1024U
#define ATDSTAT2_CCF11_MASK             2048U
#define ATDSTAT2_CCF_MASK               4095U
#define ATDSTAT2_CCF_BITNUM             0U


/*** ATDDIEN - ATD  Input Enable Register; 0x0000007C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDIENH - ATD  Input Enable Register High; 0x0000007C ***/
    union {
      byte Byte;
      struct {
        byte IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
        byte IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
        byte IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
        byte IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpIEN_8 :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDDIENHSTR;
    #define ATDDIENH                    _ATDDIEN.Overlap_STR.ATDDIENHSTR.Byte
    #define ATDDIENH_IEN8               _ATDDIEN.Overlap_STR.ATDDIENHSTR.Bits.IEN8
    #define ATDDIENH_IEN9               _ATDDIEN.Overlap_STR.ATDDIENHSTR.Bits.IEN9
    #define ATDDIENH_IEN10              _ATDDIEN.Overlap_STR.ATDDIENHSTR.Bits.IEN10
    #define ATDDIENH_IEN11              _ATDDIEN.Overlap_STR.ATDDIENHSTR.Bits.IEN11
    #define ATDDIENH_IEN_8              _ATDDIEN.Overlap_STR.ATDDIENHSTR.MergedBits.grpIEN_8
    #define ATDDIENH_IEN                ATDDIENH_IEN_8
    
    #define ATDDIENH_IEN8_MASK          1U
    #define ATDDIENH_IEN9_MASK          2U
    #define ATDDIENH_IEN10_MASK         4U
    #define ATDDIENH_IEN11_MASK         8U
    #define ATDDIENH_IEN_8_MASK         15U
    #define ATDDIENH_IEN_8_BITNUM       0U
    

    /*** ATDDIENL - ATD  Input Enable Register Low; 0x0000007D ***/
    union {
      byte Byte;
      struct {
        byte IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
        byte IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
        byte IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
        byte IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
        byte IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
        byte IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
        byte IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
        byte IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
      } Bits;
    } ATDDIENLSTR;
    #define ATDDIENL                    _ATDDIEN.Overlap_STR.ATDDIENLSTR.Byte
    #define ATDDIENL_IEN0               _ATDDIEN.Overlap_STR.ATDDIENLSTR.Bits.IEN0
    #define ATDDIENL_IEN1               _ATDDIEN.Overlap_STR.ATDDIENLSTR.Bits.IEN1
    #define ATDDIENL_IEN2               _ATDDIEN.Overlap_STR.ATDDIENLSTR.Bits.IEN2
    #define ATDDIENL_IEN3               _ATDDIEN.Overlap_STR.ATDDIENLSTR.Bits.IEN3
    #define ATDDIENL_IEN4               _ATDDIEN.Overlap_STR.ATDDIENLSTR.Bits.IEN4
    #define ATDDIENL_IEN5               _ATDDIEN.Overlap_STR.ATDDIENLSTR.Bits.IEN5
    #define ATDDIENL_IEN6               _ATDDIEN.Overlap_STR.ATDDIENLSTR.Bits.IEN6
    #define ATDDIENL_IEN7               _ATDDIEN.Overlap_STR.ATDDIENLSTR.Bits.IEN7
    
    #define ATDDIENL_IEN0_MASK          1U
    #define ATDDIENL_IEN1_MASK          2U
    #define ATDDIENL_IEN2_MASK          4U
    #define ATDDIENL_IEN3_MASK          8U
    #define ATDDIENL_IEN4_MASK          16U
    #define ATDDIENL_IEN5_MASK          32U
    #define ATDDIENL_IEN6_MASK          64U
    #define ATDDIENL_IEN7_MASK          128U
    
  } Overlap_STR;

  struct {
    word IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
    word IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
    word IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
    word IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
    word IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
    word IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
    word IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
    word IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
    word IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
    word IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
    word IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
    word IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpIEN  :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDDIENSTR;
extern volatile ATDDIENSTR _ATDDIEN @(REG_BASE + 0x0000007CUL);
#define ATDDIEN                         _ATDDIEN.Word
#define ATDDIEN_IEN0                    _ATDDIEN.Bits.IEN0
#define ATDDIEN_IEN1                    _ATDDIEN.Bits.IEN1
#define ATDDIEN_IEN2                    _ATDDIEN.Bits.IEN2
#define ATDDIEN_IEN3                    _ATDDIEN.Bits.IEN3
#define ATDDIEN_IEN4                    _ATDDIEN.Bits.IEN4
#define ATDDIEN_IEN5                    _ATDDIEN.Bits.IEN5
#define ATDDIEN_IEN6                    _ATDDIEN.Bits.IEN6
#define ATDDIEN_IEN7                    _ATDDIEN.Bits.IEN7
#define ATDDIEN_IEN8                    _ATDDIEN.Bits.IEN8
#define ATDDIEN_IEN9                    _ATDDIEN.Bits.IEN9
#define ATDDIEN_IEN10                   _ATDDIEN.Bits.IEN10
#define ATDDIEN_IEN11                   _ATDDIEN.Bits.IEN11
#define ATDDIEN_IEN                     _ATDDIEN.MergedBits.grpIEN

#define ATDDIEN_IEN0_MASK               1U
#define ATDDIEN_IEN1_MASK               2U
#define ATDDIEN_IEN2_MASK               4U
#define ATDDIEN_IEN3_MASK               8U
#define ATDDIEN_IEN4_MASK               16U
#define ATDDIEN_IEN5_MASK               32U
#define ATDDIEN_IEN6_MASK               64U
#define ATDDIEN_IEN7_MASK               128U
#define ATDDIEN_IEN8_MASK               256U
#define ATDDIEN_IEN9_MASK               512U
#define ATDDIEN_IEN10_MASK              1024U
#define ATDDIEN_IEN11_MASK              2048U
#define ATDDIEN_IEN_MASK                4095U
#define ATDDIEN_IEN_BITNUM              0U


/*** ATDCMPHT - ATD  Compare Higher Than Register; 0x0000007E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDCMPHTH - ATD  Compare Higher Than Register High; 0x0000007E ***/
    union {
      byte Byte;
      struct {
        byte CMPHT8      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 8 of a Sequence */
        byte CMPHT9      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 9 of a Sequence */
        byte CMPHT10     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 10 of a Sequence */
        byte CMPHT11     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 11 of a Sequence */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpCMPHT_8 :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATDCMPHTHSTR;
    #define ATDCMPHTH                   _ATDCMPHT.Overlap_STR.ATDCMPHTHSTR.Byte
    #define ATDCMPHTH_CMPHT8            _ATDCMPHT.Overlap_STR.ATDCMPHTHSTR.Bits.CMPHT8
    #define ATDCMPHTH_CMPHT9            _ATDCMPHT.Overlap_STR.ATDCMPHTHSTR.Bits.CMPHT9
    #define ATDCMPHTH_CMPHT10           _ATDCMPHT.Overlap_STR.ATDCMPHTHSTR.Bits.CMPHT10
    #define ATDCMPHTH_CMPHT11           _ATDCMPHT.Overlap_STR.ATDCMPHTHSTR.Bits.CMPHT11
    #define ATDCMPHTH_CMPHT_8           _ATDCMPHT.Overlap_STR.ATDCMPHTHSTR.MergedBits.grpCMPHT_8
    #define ATDCMPHTH_CMPHT             ATDCMPHTH_CMPHT_8
    
    #define ATDCMPHTH_CMPHT8_MASK       1U
    #define ATDCMPHTH_CMPHT9_MASK       2U
    #define ATDCMPHTH_CMPHT10_MASK      4U
    #define ATDCMPHTH_CMPHT11_MASK      8U
    #define ATDCMPHTH_CMPHT_8_MASK      15U
    #define ATDCMPHTH_CMPHT_8_BITNUM    0U
    

    /*** ATDCMPHTL - ATD  Compare Higher Than Register Low; 0x0000007F ***/
    union {
      byte Byte;
      struct {
        byte CMPHT0      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence */
        byte CMPHT1      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence */
        byte CMPHT2      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence */
        byte CMPHT3      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence */
        byte CMPHT4      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence */
        byte CMPHT5      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence */
        byte CMPHT6      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence */
        byte CMPHT7      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence */
      } Bits;
    } ATDCMPHTLSTR;
    #define ATDCMPHTL                   _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Byte
    #define ATDCMPHTL_CMPHT0            _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Bits.CMPHT0
    #define ATDCMPHTL_CMPHT1            _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Bits.CMPHT1
    #define ATDCMPHTL_CMPHT2            _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Bits.CMPHT2
    #define ATDCMPHTL_CMPHT3            _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Bits.CMPHT3
    #define ATDCMPHTL_CMPHT4            _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Bits.CMPHT4
    #define ATDCMPHTL_CMPHT5            _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Bits.CMPHT5
    #define ATDCMPHTL_CMPHT6            _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Bits.CMPHT6
    #define ATDCMPHTL_CMPHT7            _ATDCMPHT.Overlap_STR.ATDCMPHTLSTR.Bits.CMPHT7
    
    #define ATDCMPHTL_CMPHT0_MASK       1U
    #define ATDCMPHTL_CMPHT1_MASK       2U
    #define ATDCMPHTL_CMPHT2_MASK       4U
    #define ATDCMPHTL_CMPHT3_MASK       8U
    #define ATDCMPHTL_CMPHT4_MASK       16U
    #define ATDCMPHTL_CMPHT5_MASK       32U
    #define ATDCMPHTL_CMPHT6_MASK       64U
    #define ATDCMPHTL_CMPHT7_MASK       128U
    
  } Overlap_STR;

  struct {
    word CMPHT0      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence */
    word CMPHT1      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence */
    word CMPHT2      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence */
    word CMPHT3      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence */
    word CMPHT4      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence */
    word CMPHT5      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence */
    word CMPHT6      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence */
    word CMPHT7      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence */
    word CMPHT8      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 8 of a Sequence */
    word CMPHT9      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 9 of a Sequence */
    word CMPHT10     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 10 of a Sequence */
    word CMPHT11     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 11 of a Sequence */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpCMPHT :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATDCMPHTSTR;
extern volatile ATDCMPHTSTR _ATDCMPHT @(REG_BASE + 0x0000007EUL);
#define ATDCMPHT                        _ATDCMPHT.Word
#define ATDCMPHT_CMPHT0                 _ATDCMPHT.Bits.CMPHT0
#define ATDCMPHT_CMPHT1                 _ATDCMPHT.Bits.CMPHT1
#define ATDCMPHT_CMPHT2                 _ATDCMPHT.Bits.CMPHT2
#define ATDCMPHT_CMPHT3                 _ATDCMPHT.Bits.CMPHT3
#define ATDCMPHT_CMPHT4                 _ATDCMPHT.Bits.CMPHT4
#define ATDCMPHT_CMPHT5                 _ATDCMPHT.Bits.CMPHT5
#define ATDCMPHT_CMPHT6                 _ATDCMPHT.Bits.CMPHT6
#define ATDCMPHT_CMPHT7                 _ATDCMPHT.Bits.CMPHT7
#define ATDCMPHT_CMPHT8                 _ATDCMPHT.Bits.CMPHT8
#define ATDCMPHT_CMPHT9                 _ATDCMPHT.Bits.CMPHT9
#define ATDCMPHT_CMPHT10                _ATDCMPHT.Bits.CMPHT10
#define ATDCMPHT_CMPHT11                _ATDCMPHT.Bits.CMPHT11
#define ATDCMPHT_CMPHT                  _ATDCMPHT.MergedBits.grpCMPHT

#define ATDCMPHT_CMPHT0_MASK            1U
#define ATDCMPHT_CMPHT1_MASK            2U
#define ATDCMPHT_CMPHT2_MASK            4U
#define ATDCMPHT_CMPHT3_MASK            8U
#define ATDCMPHT_CMPHT4_MASK            16U
#define ATDCMPHT_CMPHT5_MASK            32U
#define ATDCMPHT_CMPHT6_MASK            64U
#define ATDCMPHT_CMPHT7_MASK            128U
#define ATDCMPHT_CMPHT8_MASK            256U
#define ATDCMPHT_CMPHT9_MASK            512U
#define ATDCMPHT_CMPHT10_MASK           1024U
#define ATDCMPHT_CMPHT11_MASK           2048U
#define ATDCMPHT_CMPHT_MASK             4095U
#define ATDCMPHT_CMPHT_BITNUM           0U


/*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000080 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000080 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR0HSTR;
    #define ATDDR0H                     _ATDDR0.Overlap_STR.ATDDR0HSTR.Byte
    #define ATDDR0H_BIT8                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT8
    #define ATDDR0H_BIT9                _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT9
    #define ATDDR0H_BIT10               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT10
    #define ATDDR0H_BIT11               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT11
    #define ATDDR0H_BIT12               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT12
    #define ATDDR0H_BIT13               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT13
    #define ATDDR0H_BIT14               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT14
    #define ATDDR0H_BIT15               _ATDDR0.Overlap_STR.ATDDR0HSTR.Bits.BIT15
    
    #define ATDDR0H_BIT8_MASK           1U
    #define ATDDR0H_BIT9_MASK           2U
    #define ATDDR0H_BIT10_MASK          4U
    #define ATDDR0H_BIT11_MASK          8U
    #define ATDDR0H_BIT12_MASK          16U
    #define ATDDR0H_BIT13_MASK          32U
    #define ATDDR0H_BIT14_MASK          64U
    #define ATDDR0H_BIT15_MASK          128U
    

    /*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000081 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR0LSTR;
    #define ATDDR0L                     _ATDDR0.Overlap_STR.ATDDR0LSTR.Byte
    #define ATDDR0L_BIT0                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT0
    #define ATDDR0L_BIT1                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT1
    #define ATDDR0L_BIT2                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT2
    #define ATDDR0L_BIT3                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT3
    #define ATDDR0L_BIT4                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT4
    #define ATDDR0L_BIT5                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT5
    #define ATDDR0L_BIT6                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT6
    #define ATDDR0L_BIT7                _ATDDR0.Overlap_STR.ATDDR0LSTR.Bits.BIT7
    
    #define ATDDR0L_BIT0_MASK           1U
    #define ATDDR0L_BIT1_MASK           2U
    #define ATDDR0L_BIT2_MASK           4U
    #define ATDDR0L_BIT3_MASK           8U
    #define ATDDR0L_BIT4_MASK           16U
    #define ATDDR0L_BIT5_MASK           32U
    #define ATDDR0L_BIT6_MASK           64U
    #define ATDDR0L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR0STR;
extern volatile ATDDR0STR _ATDDR0 @(REG_BASE + 0x00000080UL);
#define ATDDR0                          _ATDDR0.Word
#define ATDDR0_BIT0                     _ATDDR0.Bits.BIT0
#define ATDDR0_BIT1                     _ATDDR0.Bits.BIT1
#define ATDDR0_BIT2                     _ATDDR0.Bits.BIT2
#define ATDDR0_BIT3                     _ATDDR0.Bits.BIT3
#define ATDDR0_BIT4                     _ATDDR0.Bits.BIT4
#define ATDDR0_BIT5                     _ATDDR0.Bits.BIT5
#define ATDDR0_BIT6                     _ATDDR0.Bits.BIT6
#define ATDDR0_BIT7                     _ATDDR0.Bits.BIT7
#define ATDDR0_BIT8                     _ATDDR0.Bits.BIT8
#define ATDDR0_BIT9                     _ATDDR0.Bits.BIT9
#define ATDDR0_BIT10                    _ATDDR0.Bits.BIT10
#define ATDDR0_BIT11                    _ATDDR0.Bits.BIT11
#define ATDDR0_BIT12                    _ATDDR0.Bits.BIT12
#define ATDDR0_BIT13                    _ATDDR0.Bits.BIT13
#define ATDDR0_BIT14                    _ATDDR0.Bits.BIT14
#define ATDDR0_BIT15                    _ATDDR0.Bits.BIT15
/* ATDDR_ARR: Access 12 ATDDRx registers in an array */
#define ATDDR_ARR                       ((volatile word *) &ATDDR0)

#define ATDDR0_BIT0_MASK                1U
#define ATDDR0_BIT1_MASK                2U
#define ATDDR0_BIT2_MASK                4U
#define ATDDR0_BIT3_MASK                8U
#define ATDDR0_BIT4_MASK                16U
#define ATDDR0_BIT5_MASK                32U
#define ATDDR0_BIT6_MASK                64U
#define ATDDR0_BIT7_MASK                128U
#define ATDDR0_BIT8_MASK                256U
#define ATDDR0_BIT9_MASK                512U
#define ATDDR0_BIT10_MASK               1024U
#define ATDDR0_BIT11_MASK               2048U
#define ATDDR0_BIT12_MASK               4096U
#define ATDDR0_BIT13_MASK               8192U
#define ATDDR0_BIT14_MASK               16384U
#define ATDDR0_BIT15_MASK               32768U


/*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000082 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000082 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR1HSTR;
    #define ATDDR1H                     _ATDDR1.Overlap_STR.ATDDR1HSTR.Byte
    #define ATDDR1H_BIT8                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT8
    #define ATDDR1H_BIT9                _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT9
    #define ATDDR1H_BIT10               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT10
    #define ATDDR1H_BIT11               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT11
    #define ATDDR1H_BIT12               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT12
    #define ATDDR1H_BIT13               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT13
    #define ATDDR1H_BIT14               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT14
    #define ATDDR1H_BIT15               _ATDDR1.Overlap_STR.ATDDR1HSTR.Bits.BIT15
    
    #define ATDDR1H_BIT8_MASK           1U
    #define ATDDR1H_BIT9_MASK           2U
    #define ATDDR1H_BIT10_MASK          4U
    #define ATDDR1H_BIT11_MASK          8U
    #define ATDDR1H_BIT12_MASK          16U
    #define ATDDR1H_BIT13_MASK          32U
    #define ATDDR1H_BIT14_MASK          64U
    #define ATDDR1H_BIT15_MASK          128U
    

    /*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000083 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR1LSTR;
    #define ATDDR1L                     _ATDDR1.Overlap_STR.ATDDR1LSTR.Byte
    #define ATDDR1L_BIT0                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT0
    #define ATDDR1L_BIT1                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT1
    #define ATDDR1L_BIT2                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT2
    #define ATDDR1L_BIT3                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT3
    #define ATDDR1L_BIT4                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT4
    #define ATDDR1L_BIT5                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT5
    #define ATDDR1L_BIT6                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT6
    #define ATDDR1L_BIT7                _ATDDR1.Overlap_STR.ATDDR1LSTR.Bits.BIT7
    
    #define ATDDR1L_BIT0_MASK           1U
    #define ATDDR1L_BIT1_MASK           2U
    #define ATDDR1L_BIT2_MASK           4U
    #define ATDDR1L_BIT3_MASK           8U
    #define ATDDR1L_BIT4_MASK           16U
    #define ATDDR1L_BIT5_MASK           32U
    #define ATDDR1L_BIT6_MASK           64U
    #define ATDDR1L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR1STR;
extern volatile ATDDR1STR _ATDDR1 @(REG_BASE + 0x00000082UL);
#define ATDDR1                          _ATDDR1.Word
#define ATDDR1_BIT0                     _ATDDR1.Bits.BIT0
#define ATDDR1_BIT1                     _ATDDR1.Bits.BIT1
#define ATDDR1_BIT2                     _ATDDR1.Bits.BIT2
#define ATDDR1_BIT3                     _ATDDR1.Bits.BIT3
#define ATDDR1_BIT4                     _ATDDR1.Bits.BIT4
#define ATDDR1_BIT5                     _ATDDR1.Bits.BIT5
#define ATDDR1_BIT6                     _ATDDR1.Bits.BIT6
#define ATDDR1_BIT7                     _ATDDR1.Bits.BIT7
#define ATDDR1_BIT8                     _ATDDR1.Bits.BIT8
#define ATDDR1_BIT9                     _ATDDR1.Bits.BIT9
#define ATDDR1_BIT10                    _ATDDR1.Bits.BIT10
#define ATDDR1_BIT11                    _ATDDR1.Bits.BIT11
#define ATDDR1_BIT12                    _ATDDR1.Bits.BIT12
#define ATDDR1_BIT13                    _ATDDR1.Bits.BIT13
#define ATDDR1_BIT14                    _ATDDR1.Bits.BIT14
#define ATDDR1_BIT15                    _ATDDR1.Bits.BIT15

#define ATDDR1_BIT0_MASK                1U
#define ATDDR1_BIT1_MASK                2U
#define ATDDR1_BIT2_MASK                4U
#define ATDDR1_BIT3_MASK                8U
#define ATDDR1_BIT4_MASK                16U
#define ATDDR1_BIT5_MASK                32U
#define ATDDR1_BIT6_MASK                64U
#define ATDDR1_BIT7_MASK                128U
#define ATDDR1_BIT8_MASK                256U
#define ATDDR1_BIT9_MASK                512U
#define ATDDR1_BIT10_MASK               1024U
#define ATDDR1_BIT11_MASK               2048U
#define ATDDR1_BIT12_MASK               4096U
#define ATDDR1_BIT13_MASK               8192U
#define ATDDR1_BIT14_MASK               16384U
#define ATDDR1_BIT15_MASK               32768U


/*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR2HSTR;
    #define ATDDR2H                     _ATDDR2.Overlap_STR.ATDDR2HSTR.Byte
    #define ATDDR2H_BIT8                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT8
    #define ATDDR2H_BIT9                _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT9
    #define ATDDR2H_BIT10               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT10
    #define ATDDR2H_BIT11               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT11
    #define ATDDR2H_BIT12               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT12
    #define ATDDR2H_BIT13               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT13
    #define ATDDR2H_BIT14               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT14
    #define ATDDR2H_BIT15               _ATDDR2.Overlap_STR.ATDDR2HSTR.Bits.BIT15
    
    #define ATDDR2H_BIT8_MASK           1U
    #define ATDDR2H_BIT9_MASK           2U
    #define ATDDR2H_BIT10_MASK          4U
    #define ATDDR2H_BIT11_MASK          8U
    #define ATDDR2H_BIT12_MASK          16U
    #define ATDDR2H_BIT13_MASK          32U
    #define ATDDR2H_BIT14_MASK          64U
    #define ATDDR2H_BIT15_MASK          128U
    

    /*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR2LSTR;
    #define ATDDR2L                     _ATDDR2.Overlap_STR.ATDDR2LSTR.Byte
    #define ATDDR2L_BIT0                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT0
    #define ATDDR2L_BIT1                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT1
    #define ATDDR2L_BIT2                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT2
    #define ATDDR2L_BIT3                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT3
    #define ATDDR2L_BIT4                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT4
    #define ATDDR2L_BIT5                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT5
    #define ATDDR2L_BIT6                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT6
    #define ATDDR2L_BIT7                _ATDDR2.Overlap_STR.ATDDR2LSTR.Bits.BIT7
    
    #define ATDDR2L_BIT0_MASK           1U
    #define ATDDR2L_BIT1_MASK           2U
    #define ATDDR2L_BIT2_MASK           4U
    #define ATDDR2L_BIT3_MASK           8U
    #define ATDDR2L_BIT4_MASK           16U
    #define ATDDR2L_BIT5_MASK           32U
    #define ATDDR2L_BIT6_MASK           64U
    #define ATDDR2L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR2STR;
extern volatile ATDDR2STR _ATDDR2 @(REG_BASE + 0x00000084UL);
#define ATDDR2                          _ATDDR2.Word
#define ATDDR2_BIT0                     _ATDDR2.Bits.BIT0
#define ATDDR2_BIT1                     _ATDDR2.Bits.BIT1
#define ATDDR2_BIT2                     _ATDDR2.Bits.BIT2
#define ATDDR2_BIT3                     _ATDDR2.Bits.BIT3
#define ATDDR2_BIT4                     _ATDDR2.Bits.BIT4
#define ATDDR2_BIT5                     _ATDDR2.Bits.BIT5
#define ATDDR2_BIT6                     _ATDDR2.Bits.BIT6
#define ATDDR2_BIT7                     _ATDDR2.Bits.BIT7
#define ATDDR2_BIT8                     _ATDDR2.Bits.BIT8
#define ATDDR2_BIT9                     _ATDDR2.Bits.BIT9
#define ATDDR2_BIT10                    _ATDDR2.Bits.BIT10
#define ATDDR2_BIT11                    _ATDDR2.Bits.BIT11
#define ATDDR2_BIT12                    _ATDDR2.Bits.BIT12
#define ATDDR2_BIT13                    _ATDDR2.Bits.BIT13
#define ATDDR2_BIT14                    _ATDDR2.Bits.BIT14
#define ATDDR2_BIT15                    _ATDDR2.Bits.BIT15

#define ATDDR2_BIT0_MASK                1U
#define ATDDR2_BIT1_MASK                2U
#define ATDDR2_BIT2_MASK                4U
#define ATDDR2_BIT3_MASK                8U
#define ATDDR2_BIT4_MASK                16U
#define ATDDR2_BIT5_MASK                32U
#define ATDDR2_BIT6_MASK                64U
#define ATDDR2_BIT7_MASK                128U
#define ATDDR2_BIT8_MASK                256U
#define ATDDR2_BIT9_MASK                512U
#define ATDDR2_BIT10_MASK               1024U
#define ATDDR2_BIT11_MASK               2048U
#define ATDDR2_BIT12_MASK               4096U
#define ATDDR2_BIT13_MASK               8192U
#define ATDDR2_BIT14_MASK               16384U
#define ATDDR2_BIT15_MASK               32768U


/*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000086 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000086 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR3HSTR;
    #define ATDDR3H                     _ATDDR3.Overlap_STR.ATDDR3HSTR.Byte
    #define ATDDR3H_BIT8                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT8
    #define ATDDR3H_BIT9                _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT9
    #define ATDDR3H_BIT10               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT10
    #define ATDDR3H_BIT11               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT11
    #define ATDDR3H_BIT12               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT12
    #define ATDDR3H_BIT13               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT13
    #define ATDDR3H_BIT14               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT14
    #define ATDDR3H_BIT15               _ATDDR3.Overlap_STR.ATDDR3HSTR.Bits.BIT15
    
    #define ATDDR3H_BIT8_MASK           1U
    #define ATDDR3H_BIT9_MASK           2U
    #define ATDDR3H_BIT10_MASK          4U
    #define ATDDR3H_BIT11_MASK          8U
    #define ATDDR3H_BIT12_MASK          16U
    #define ATDDR3H_BIT13_MASK          32U
    #define ATDDR3H_BIT14_MASK          64U
    #define ATDDR3H_BIT15_MASK          128U
    

    /*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000087 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR3LSTR;
    #define ATDDR3L                     _ATDDR3.Overlap_STR.ATDDR3LSTR.Byte
    #define ATDDR3L_BIT0                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT0
    #define ATDDR3L_BIT1                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT1
    #define ATDDR3L_BIT2                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT2
    #define ATDDR3L_BIT3                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT3
    #define ATDDR3L_BIT4                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT4
    #define ATDDR3L_BIT5                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT5
    #define ATDDR3L_BIT6                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT6
    #define ATDDR3L_BIT7                _ATDDR3.Overlap_STR.ATDDR3LSTR.Bits.BIT7
    
    #define ATDDR3L_BIT0_MASK           1U
    #define ATDDR3L_BIT1_MASK           2U
    #define ATDDR3L_BIT2_MASK           4U
    #define ATDDR3L_BIT3_MASK           8U
    #define ATDDR3L_BIT4_MASK           16U
    #define ATDDR3L_BIT5_MASK           32U
    #define ATDDR3L_BIT6_MASK           64U
    #define ATDDR3L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR3STR;
extern volatile ATDDR3STR _ATDDR3 @(REG_BASE + 0x00000086UL);
#define ATDDR3                          _ATDDR3.Word
#define ATDDR3_BIT0                     _ATDDR3.Bits.BIT0
#define ATDDR3_BIT1                     _ATDDR3.Bits.BIT1
#define ATDDR3_BIT2                     _ATDDR3.Bits.BIT2
#define ATDDR3_BIT3                     _ATDDR3.Bits.BIT3
#define ATDDR3_BIT4                     _ATDDR3.Bits.BIT4
#define ATDDR3_BIT5                     _ATDDR3.Bits.BIT5
#define ATDDR3_BIT6                     _ATDDR3.Bits.BIT6
#define ATDDR3_BIT7                     _ATDDR3.Bits.BIT7
#define ATDDR3_BIT8                     _ATDDR3.Bits.BIT8
#define ATDDR3_BIT9                     _ATDDR3.Bits.BIT9
#define ATDDR3_BIT10                    _ATDDR3.Bits.BIT10
#define ATDDR3_BIT11                    _ATDDR3.Bits.BIT11
#define ATDDR3_BIT12                    _ATDDR3.Bits.BIT12
#define ATDDR3_BIT13                    _ATDDR3.Bits.BIT13
#define ATDDR3_BIT14                    _ATDDR3.Bits.BIT14
#define ATDDR3_BIT15                    _ATDDR3.Bits.BIT15

#define ATDDR3_BIT0_MASK                1U
#define ATDDR3_BIT1_MASK                2U
#define ATDDR3_BIT2_MASK                4U
#define ATDDR3_BIT3_MASK                8U
#define ATDDR3_BIT4_MASK                16U
#define ATDDR3_BIT5_MASK                32U
#define ATDDR3_BIT6_MASK                64U
#define ATDDR3_BIT7_MASK                128U
#define ATDDR3_BIT8_MASK                256U
#define ATDDR3_BIT9_MASK                512U
#define ATDDR3_BIT10_MASK               1024U
#define ATDDR3_BIT11_MASK               2048U
#define ATDDR3_BIT12_MASK               4096U
#define ATDDR3_BIT13_MASK               8192U
#define ATDDR3_BIT14_MASK               16384U
#define ATDDR3_BIT15_MASK               32768U


/*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000088 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000088 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR4HSTR;
    #define ATDDR4H                     _ATDDR4.Overlap_STR.ATDDR4HSTR.Byte
    #define ATDDR4H_BIT8                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT8
    #define ATDDR4H_BIT9                _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT9
    #define ATDDR4H_BIT10               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT10
    #define ATDDR4H_BIT11               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT11
    #define ATDDR4H_BIT12               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT12
    #define ATDDR4H_BIT13               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT13
    #define ATDDR4H_BIT14               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT14
    #define ATDDR4H_BIT15               _ATDDR4.Overlap_STR.ATDDR4HSTR.Bits.BIT15
    
    #define ATDDR4H_BIT8_MASK           1U
    #define ATDDR4H_BIT9_MASK           2U
    #define ATDDR4H_BIT10_MASK          4U
    #define ATDDR4H_BIT11_MASK          8U
    #define ATDDR4H_BIT12_MASK          16U
    #define ATDDR4H_BIT13_MASK          32U
    #define ATDDR4H_BIT14_MASK          64U
    #define ATDDR4H_BIT15_MASK          128U
    

    /*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000089 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR4LSTR;
    #define ATDDR4L                     _ATDDR4.Overlap_STR.ATDDR4LSTR.Byte
    #define ATDDR4L_BIT0                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT0
    #define ATDDR4L_BIT1                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT1
    #define ATDDR4L_BIT2                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT2
    #define ATDDR4L_BIT3                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT3
    #define ATDDR4L_BIT4                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT4
    #define ATDDR4L_BIT5                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT5
    #define ATDDR4L_BIT6                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT6
    #define ATDDR4L_BIT7                _ATDDR4.Overlap_STR.ATDDR4LSTR.Bits.BIT7
    
    #define ATDDR4L_BIT0_MASK           1U
    #define ATDDR4L_BIT1_MASK           2U
    #define ATDDR4L_BIT2_MASK           4U
    #define ATDDR4L_BIT3_MASK           8U
    #define ATDDR4L_BIT4_MASK           16U
    #define ATDDR4L_BIT5_MASK           32U
    #define ATDDR4L_BIT6_MASK           64U
    #define ATDDR4L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR4STR;
extern volatile ATDDR4STR _ATDDR4 @(REG_BASE + 0x00000088UL);
#define ATDDR4                          _ATDDR4.Word
#define ATDDR4_BIT0                     _ATDDR4.Bits.BIT0
#define ATDDR4_BIT1                     _ATDDR4.Bits.BIT1
#define ATDDR4_BIT2                     _ATDDR4.Bits.BIT2
#define ATDDR4_BIT3                     _ATDDR4.Bits.BIT3
#define ATDDR4_BIT4                     _ATDDR4.Bits.BIT4
#define ATDDR4_BIT5                     _ATDDR4.Bits.BIT5
#define ATDDR4_BIT6                     _ATDDR4.Bits.BIT6
#define ATDDR4_BIT7                     _ATDDR4.Bits.BIT7
#define ATDDR4_BIT8                     _ATDDR4.Bits.BIT8
#define ATDDR4_BIT9                     _ATDDR4.Bits.BIT9
#define ATDDR4_BIT10                    _ATDDR4.Bits.BIT10
#define ATDDR4_BIT11                    _ATDDR4.Bits.BIT11
#define ATDDR4_BIT12                    _ATDDR4.Bits.BIT12
#define ATDDR4_BIT13                    _ATDDR4.Bits.BIT13
#define ATDDR4_BIT14                    _ATDDR4.Bits.BIT14
#define ATDDR4_BIT15                    _ATDDR4.Bits.BIT15

#define ATDDR4_BIT0_MASK                1U
#define ATDDR4_BIT1_MASK                2U
#define ATDDR4_BIT2_MASK                4U
#define ATDDR4_BIT3_MASK                8U
#define ATDDR4_BIT4_MASK                16U
#define ATDDR4_BIT5_MASK                32U
#define ATDDR4_BIT6_MASK                64U
#define ATDDR4_BIT7_MASK                128U
#define ATDDR4_BIT8_MASK                256U
#define ATDDR4_BIT9_MASK                512U
#define ATDDR4_BIT10_MASK               1024U
#define ATDDR4_BIT11_MASK               2048U
#define ATDDR4_BIT12_MASK               4096U
#define ATDDR4_BIT13_MASK               8192U
#define ATDDR4_BIT14_MASK               16384U
#define ATDDR4_BIT15_MASK               32768U


/*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000008A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000008A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR5HSTR;
    #define ATDDR5H                     _ATDDR5.Overlap_STR.ATDDR5HSTR.Byte
    #define ATDDR5H_BIT8                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT8
    #define ATDDR5H_BIT9                _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT9
    #define ATDDR5H_BIT10               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT10
    #define ATDDR5H_BIT11               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT11
    #define ATDDR5H_BIT12               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT12
    #define ATDDR5H_BIT13               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT13
    #define ATDDR5H_BIT14               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT14
    #define ATDDR5H_BIT15               _ATDDR5.Overlap_STR.ATDDR5HSTR.Bits.BIT15
    
    #define ATDDR5H_BIT8_MASK           1U
    #define ATDDR5H_BIT9_MASK           2U
    #define ATDDR5H_BIT10_MASK          4U
    #define ATDDR5H_BIT11_MASK          8U
    #define ATDDR5H_BIT12_MASK          16U
    #define ATDDR5H_BIT13_MASK          32U
    #define ATDDR5H_BIT14_MASK          64U
    #define ATDDR5H_BIT15_MASK          128U
    

    /*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000008B ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR5LSTR;
    #define ATDDR5L                     _ATDDR5.Overlap_STR.ATDDR5LSTR.Byte
    #define ATDDR5L_BIT0                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT0
    #define ATDDR5L_BIT1                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT1
    #define ATDDR5L_BIT2                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT2
    #define ATDDR5L_BIT3                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT3
    #define ATDDR5L_BIT4                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT4
    #define ATDDR5L_BIT5                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT5
    #define ATDDR5L_BIT6                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT6
    #define ATDDR5L_BIT7                _ATDDR5.Overlap_STR.ATDDR5LSTR.Bits.BIT7
    
    #define ATDDR5L_BIT0_MASK           1U
    #define ATDDR5L_BIT1_MASK           2U
    #define ATDDR5L_BIT2_MASK           4U
    #define ATDDR5L_BIT3_MASK           8U
    #define ATDDR5L_BIT4_MASK           16U
    #define ATDDR5L_BIT5_MASK           32U
    #define ATDDR5L_BIT6_MASK           64U
    #define ATDDR5L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR5STR;
extern volatile ATDDR5STR _ATDDR5 @(REG_BASE + 0x0000008AUL);
#define ATDDR5                          _ATDDR5.Word
#define ATDDR5_BIT0                     _ATDDR5.Bits.BIT0
#define ATDDR5_BIT1                     _ATDDR5.Bits.BIT1
#define ATDDR5_BIT2                     _ATDDR5.Bits.BIT2
#define ATDDR5_BIT3                     _ATDDR5.Bits.BIT3
#define ATDDR5_BIT4                     _ATDDR5.Bits.BIT4
#define ATDDR5_BIT5                     _ATDDR5.Bits.BIT5
#define ATDDR5_BIT6                     _ATDDR5.Bits.BIT6
#define ATDDR5_BIT7                     _ATDDR5.Bits.BIT7
#define ATDDR5_BIT8                     _ATDDR5.Bits.BIT8
#define ATDDR5_BIT9                     _ATDDR5.Bits.BIT9
#define ATDDR5_BIT10                    _ATDDR5.Bits.BIT10
#define ATDDR5_BIT11                    _ATDDR5.Bits.BIT11
#define ATDDR5_BIT12                    _ATDDR5.Bits.BIT12
#define ATDDR5_BIT13                    _ATDDR5.Bits.BIT13
#define ATDDR5_BIT14                    _ATDDR5.Bits.BIT14
#define ATDDR5_BIT15                    _ATDDR5.Bits.BIT15

#define ATDDR5_BIT0_MASK                1U
#define ATDDR5_BIT1_MASK                2U
#define ATDDR5_BIT2_MASK                4U
#define ATDDR5_BIT3_MASK                8U
#define ATDDR5_BIT4_MASK                16U
#define ATDDR5_BIT5_MASK                32U
#define ATDDR5_BIT6_MASK                64U
#define ATDDR5_BIT7_MASK                128U
#define ATDDR5_BIT8_MASK                256U
#define ATDDR5_BIT9_MASK                512U
#define ATDDR5_BIT10_MASK               1024U
#define ATDDR5_BIT11_MASK               2048U
#define ATDDR5_BIT12_MASK               4096U
#define ATDDR5_BIT13_MASK               8192U
#define ATDDR5_BIT14_MASK               16384U
#define ATDDR5_BIT15_MASK               32768U


/*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000008C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000008C ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR6HSTR;
    #define ATDDR6H                     _ATDDR6.Overlap_STR.ATDDR6HSTR.Byte
    #define ATDDR6H_BIT8                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT8
    #define ATDDR6H_BIT9                _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT9
    #define ATDDR6H_BIT10               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT10
    #define ATDDR6H_BIT11               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT11
    #define ATDDR6H_BIT12               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT12
    #define ATDDR6H_BIT13               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT13
    #define ATDDR6H_BIT14               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT14
    #define ATDDR6H_BIT15               _ATDDR6.Overlap_STR.ATDDR6HSTR.Bits.BIT15
    
    #define ATDDR6H_BIT8_MASK           1U
    #define ATDDR6H_BIT9_MASK           2U
    #define ATDDR6H_BIT10_MASK          4U
    #define ATDDR6H_BIT11_MASK          8U
    #define ATDDR6H_BIT12_MASK          16U
    #define ATDDR6H_BIT13_MASK          32U
    #define ATDDR6H_BIT14_MASK          64U
    #define ATDDR6H_BIT15_MASK          128U
    

    /*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000008D ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR6LSTR;
    #define ATDDR6L                     _ATDDR6.Overlap_STR.ATDDR6LSTR.Byte
    #define ATDDR6L_BIT0                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT0
    #define ATDDR6L_BIT1                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT1
    #define ATDDR6L_BIT2                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT2
    #define ATDDR6L_BIT3                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT3
    #define ATDDR6L_BIT4                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT4
    #define ATDDR6L_BIT5                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT5
    #define ATDDR6L_BIT6                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT6
    #define ATDDR6L_BIT7                _ATDDR6.Overlap_STR.ATDDR6LSTR.Bits.BIT7
    
    #define ATDDR6L_BIT0_MASK           1U
    #define ATDDR6L_BIT1_MASK           2U
    #define ATDDR6L_BIT2_MASK           4U
    #define ATDDR6L_BIT3_MASK           8U
    #define ATDDR6L_BIT4_MASK           16U
    #define ATDDR6L_BIT5_MASK           32U
    #define ATDDR6L_BIT6_MASK           64U
    #define ATDDR6L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR6STR;
extern volatile ATDDR6STR _ATDDR6 @(REG_BASE + 0x0000008CUL);
#define ATDDR6                          _ATDDR6.Word
#define ATDDR6_BIT0                     _ATDDR6.Bits.BIT0
#define ATDDR6_BIT1                     _ATDDR6.Bits.BIT1
#define ATDDR6_BIT2                     _ATDDR6.Bits.BIT2
#define ATDDR6_BIT3                     _ATDDR6.Bits.BIT3
#define ATDDR6_BIT4                     _ATDDR6.Bits.BIT4
#define ATDDR6_BIT5                     _ATDDR6.Bits.BIT5
#define ATDDR6_BIT6                     _ATDDR6.Bits.BIT6
#define ATDDR6_BIT7                     _ATDDR6.Bits.BIT7
#define ATDDR6_BIT8                     _ATDDR6.Bits.BIT8
#define ATDDR6_BIT9                     _ATDDR6.Bits.BIT9
#define ATDDR6_BIT10                    _ATDDR6.Bits.BIT10
#define ATDDR6_BIT11                    _ATDDR6.Bits.BIT11
#define ATDDR6_BIT12                    _ATDDR6.Bits.BIT12
#define ATDDR6_BIT13                    _ATDDR6.Bits.BIT13
#define ATDDR6_BIT14                    _ATDDR6.Bits.BIT14
#define ATDDR6_BIT15                    _ATDDR6.Bits.BIT15

#define ATDDR6_BIT0_MASK                1U
#define ATDDR6_BIT1_MASK                2U
#define ATDDR6_BIT2_MASK                4U
#define ATDDR6_BIT3_MASK                8U
#define ATDDR6_BIT4_MASK                16U
#define ATDDR6_BIT5_MASK                32U
#define ATDDR6_BIT6_MASK                64U
#define ATDDR6_BIT7_MASK                128U
#define ATDDR6_BIT8_MASK                256U
#define ATDDR6_BIT9_MASK                512U
#define ATDDR6_BIT10_MASK               1024U
#define ATDDR6_BIT11_MASK               2048U
#define ATDDR6_BIT12_MASK               4096U
#define ATDDR6_BIT13_MASK               8192U
#define ATDDR6_BIT14_MASK               16384U
#define ATDDR6_BIT15_MASK               32768U


/*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000008E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000008E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR7HSTR;
    #define ATDDR7H                     _ATDDR7.Overlap_STR.ATDDR7HSTR.Byte
    #define ATDDR7H_BIT8                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT8
    #define ATDDR7H_BIT9                _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT9
    #define ATDDR7H_BIT10               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT10
    #define ATDDR7H_BIT11               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT11
    #define ATDDR7H_BIT12               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT12
    #define ATDDR7H_BIT13               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT13
    #define ATDDR7H_BIT14               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT14
    #define ATDDR7H_BIT15               _ATDDR7.Overlap_STR.ATDDR7HSTR.Bits.BIT15
    
    #define ATDDR7H_BIT8_MASK           1U
    #define ATDDR7H_BIT9_MASK           2U
    #define ATDDR7H_BIT10_MASK          4U
    #define ATDDR7H_BIT11_MASK          8U
    #define ATDDR7H_BIT12_MASK          16U
    #define ATDDR7H_BIT13_MASK          32U
    #define ATDDR7H_BIT14_MASK          64U
    #define ATDDR7H_BIT15_MASK          128U
    

    /*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000008F ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR7LSTR;
    #define ATDDR7L                     _ATDDR7.Overlap_STR.ATDDR7LSTR.Byte
    #define ATDDR7L_BIT0                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT0
    #define ATDDR7L_BIT1                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT1
    #define ATDDR7L_BIT2                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT2
    #define ATDDR7L_BIT3                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT3
    #define ATDDR7L_BIT4                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT4
    #define ATDDR7L_BIT5                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT5
    #define ATDDR7L_BIT6                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT6
    #define ATDDR7L_BIT7                _ATDDR7.Overlap_STR.ATDDR7LSTR.Bits.BIT7
    
    #define ATDDR7L_BIT0_MASK           1U
    #define ATDDR7L_BIT1_MASK           2U
    #define ATDDR7L_BIT2_MASK           4U
    #define ATDDR7L_BIT3_MASK           8U
    #define ATDDR7L_BIT4_MASK           16U
    #define ATDDR7L_BIT5_MASK           32U
    #define ATDDR7L_BIT6_MASK           64U
    #define ATDDR7L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR7STR;
extern volatile ATDDR7STR _ATDDR7 @(REG_BASE + 0x0000008EUL);
#define ATDDR7                          _ATDDR7.Word
#define ATDDR7_BIT0                     _ATDDR7.Bits.BIT0
#define ATDDR7_BIT1                     _ATDDR7.Bits.BIT1
#define ATDDR7_BIT2                     _ATDDR7.Bits.BIT2
#define ATDDR7_BIT3                     _ATDDR7.Bits.BIT3
#define ATDDR7_BIT4                     _ATDDR7.Bits.BIT4
#define ATDDR7_BIT5                     _ATDDR7.Bits.BIT5
#define ATDDR7_BIT6                     _ATDDR7.Bits.BIT6
#define ATDDR7_BIT7                     _ATDDR7.Bits.BIT7
#define ATDDR7_BIT8                     _ATDDR7.Bits.BIT8
#define ATDDR7_BIT9                     _ATDDR7.Bits.BIT9
#define ATDDR7_BIT10                    _ATDDR7.Bits.BIT10
#define ATDDR7_BIT11                    _ATDDR7.Bits.BIT11
#define ATDDR7_BIT12                    _ATDDR7.Bits.BIT12
#define ATDDR7_BIT13                    _ATDDR7.Bits.BIT13
#define ATDDR7_BIT14                    _ATDDR7.Bits.BIT14
#define ATDDR7_BIT15                    _ATDDR7.Bits.BIT15

#define ATDDR7_BIT0_MASK                1U
#define ATDDR7_BIT1_MASK                2U
#define ATDDR7_BIT2_MASK                4U
#define ATDDR7_BIT3_MASK                8U
#define ATDDR7_BIT4_MASK                16U
#define ATDDR7_BIT5_MASK                32U
#define ATDDR7_BIT6_MASK                64U
#define ATDDR7_BIT7_MASK                128U
#define ATDDR7_BIT8_MASK                256U
#define ATDDR7_BIT9_MASK                512U
#define ATDDR7_BIT10_MASK               1024U
#define ATDDR7_BIT11_MASK               2048U
#define ATDDR7_BIT12_MASK               4096U
#define ATDDR7_BIT13_MASK               8192U
#define ATDDR7_BIT14_MASK               16384U
#define ATDDR7_BIT15_MASK               32768U


/*** ATDDR8 - ATD  Conversion Result Register 8; 0x00000090 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR8H - ATD  Conversion Result Register 8 High; 0x00000090 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR8HSTR;
    #define ATDDR8H                     _ATDDR8.Overlap_STR.ATDDR8HSTR.Byte
    #define ATDDR8H_BIT8                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT8
    #define ATDDR8H_BIT9                _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT9
    #define ATDDR8H_BIT10               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT10
    #define ATDDR8H_BIT11               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT11
    #define ATDDR8H_BIT12               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT12
    #define ATDDR8H_BIT13               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT13
    #define ATDDR8H_BIT14               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT14
    #define ATDDR8H_BIT15               _ATDDR8.Overlap_STR.ATDDR8HSTR.Bits.BIT15
    
    #define ATDDR8H_BIT8_MASK           1U
    #define ATDDR8H_BIT9_MASK           2U
    #define ATDDR8H_BIT10_MASK          4U
    #define ATDDR8H_BIT11_MASK          8U
    #define ATDDR8H_BIT12_MASK          16U
    #define ATDDR8H_BIT13_MASK          32U
    #define ATDDR8H_BIT14_MASK          64U
    #define ATDDR8H_BIT15_MASK          128U
    

    /*** ATDDR8L - ATD  Conversion Result Register 8 Low; 0x00000091 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR8LSTR;
    #define ATDDR8L                     _ATDDR8.Overlap_STR.ATDDR8LSTR.Byte
    #define ATDDR8L_BIT0                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT0
    #define ATDDR8L_BIT1                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT1
    #define ATDDR8L_BIT2                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT2
    #define ATDDR8L_BIT3                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT3
    #define ATDDR8L_BIT4                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT4
    #define ATDDR8L_BIT5                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT5
    #define ATDDR8L_BIT6                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT6
    #define ATDDR8L_BIT7                _ATDDR8.Overlap_STR.ATDDR8LSTR.Bits.BIT7
    
    #define ATDDR8L_BIT0_MASK           1U
    #define ATDDR8L_BIT1_MASK           2U
    #define ATDDR8L_BIT2_MASK           4U
    #define ATDDR8L_BIT3_MASK           8U
    #define ATDDR8L_BIT4_MASK           16U
    #define ATDDR8L_BIT5_MASK           32U
    #define ATDDR8L_BIT6_MASK           64U
    #define ATDDR8L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR8STR;
extern volatile ATDDR8STR _ATDDR8 @(REG_BASE + 0x00000090UL);
#define ATDDR8                          _ATDDR8.Word
#define ATDDR8_BIT0                     _ATDDR8.Bits.BIT0
#define ATDDR8_BIT1                     _ATDDR8.Bits.BIT1
#define ATDDR8_BIT2                     _ATDDR8.Bits.BIT2
#define ATDDR8_BIT3                     _ATDDR8.Bits.BIT3
#define ATDDR8_BIT4                     _ATDDR8.Bits.BIT4
#define ATDDR8_BIT5                     _ATDDR8.Bits.BIT5
#define ATDDR8_BIT6                     _ATDDR8.Bits.BIT6
#define ATDDR8_BIT7                     _ATDDR8.Bits.BIT7
#define ATDDR8_BIT8                     _ATDDR8.Bits.BIT8
#define ATDDR8_BIT9                     _ATDDR8.Bits.BIT9
#define ATDDR8_BIT10                    _ATDDR8.Bits.BIT10
#define ATDDR8_BIT11                    _ATDDR8.Bits.BIT11
#define ATDDR8_BIT12                    _ATDDR8.Bits.BIT12
#define ATDDR8_BIT13                    _ATDDR8.Bits.BIT13
#define ATDDR8_BIT14                    _ATDDR8.Bits.BIT14
#define ATDDR8_BIT15                    _ATDDR8.Bits.BIT15

#define ATDDR8_BIT0_MASK                1U
#define ATDDR8_BIT1_MASK                2U
#define ATDDR8_BIT2_MASK                4U
#define ATDDR8_BIT3_MASK                8U
#define ATDDR8_BIT4_MASK                16U
#define ATDDR8_BIT5_MASK                32U
#define ATDDR8_BIT6_MASK                64U
#define ATDDR8_BIT7_MASK                128U
#define ATDDR8_BIT8_MASK                256U
#define ATDDR8_BIT9_MASK                512U
#define ATDDR8_BIT10_MASK               1024U
#define ATDDR8_BIT11_MASK               2048U
#define ATDDR8_BIT12_MASK               4096U
#define ATDDR8_BIT13_MASK               8192U
#define ATDDR8_BIT14_MASK               16384U
#define ATDDR8_BIT15_MASK               32768U


/*** ATDDR9 - ATD  Conversion Result Register 9; 0x00000092 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR9H - ATD  Conversion Result Register 9 High; 0x00000092 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR9HSTR;
    #define ATDDR9H                     _ATDDR9.Overlap_STR.ATDDR9HSTR.Byte
    #define ATDDR9H_BIT8                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT8
    #define ATDDR9H_BIT9                _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT9
    #define ATDDR9H_BIT10               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT10
    #define ATDDR9H_BIT11               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT11
    #define ATDDR9H_BIT12               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT12
    #define ATDDR9H_BIT13               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT13
    #define ATDDR9H_BIT14               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT14
    #define ATDDR9H_BIT15               _ATDDR9.Overlap_STR.ATDDR9HSTR.Bits.BIT15
    
    #define ATDDR9H_BIT8_MASK           1U
    #define ATDDR9H_BIT9_MASK           2U
    #define ATDDR9H_BIT10_MASK          4U
    #define ATDDR9H_BIT11_MASK          8U
    #define ATDDR9H_BIT12_MASK          16U
    #define ATDDR9H_BIT13_MASK          32U
    #define ATDDR9H_BIT14_MASK          64U
    #define ATDDR9H_BIT15_MASK          128U
    

    /*** ATDDR9L - ATD  Conversion Result Register 9 Low; 0x00000093 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR9LSTR;
    #define ATDDR9L                     _ATDDR9.Overlap_STR.ATDDR9LSTR.Byte
    #define ATDDR9L_BIT0                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT0
    #define ATDDR9L_BIT1                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT1
    #define ATDDR9L_BIT2                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT2
    #define ATDDR9L_BIT3                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT3
    #define ATDDR9L_BIT4                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT4
    #define ATDDR9L_BIT5                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT5
    #define ATDDR9L_BIT6                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT6
    #define ATDDR9L_BIT7                _ATDDR9.Overlap_STR.ATDDR9LSTR.Bits.BIT7
    
    #define ATDDR9L_BIT0_MASK           1U
    #define ATDDR9L_BIT1_MASK           2U
    #define ATDDR9L_BIT2_MASK           4U
    #define ATDDR9L_BIT3_MASK           8U
    #define ATDDR9L_BIT4_MASK           16U
    #define ATDDR9L_BIT5_MASK           32U
    #define ATDDR9L_BIT6_MASK           64U
    #define ATDDR9L_BIT7_MASK           128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR9STR;
extern volatile ATDDR9STR _ATDDR9 @(REG_BASE + 0x00000092UL);
#define ATDDR9                          _ATDDR9.Word
#define ATDDR9_BIT0                     _ATDDR9.Bits.BIT0
#define ATDDR9_BIT1                     _ATDDR9.Bits.BIT1
#define ATDDR9_BIT2                     _ATDDR9.Bits.BIT2
#define ATDDR9_BIT3                     _ATDDR9.Bits.BIT3
#define ATDDR9_BIT4                     _ATDDR9.Bits.BIT4
#define ATDDR9_BIT5                     _ATDDR9.Bits.BIT5
#define ATDDR9_BIT6                     _ATDDR9.Bits.BIT6
#define ATDDR9_BIT7                     _ATDDR9.Bits.BIT7
#define ATDDR9_BIT8                     _ATDDR9.Bits.BIT8
#define ATDDR9_BIT9                     _ATDDR9.Bits.BIT9
#define ATDDR9_BIT10                    _ATDDR9.Bits.BIT10
#define ATDDR9_BIT11                    _ATDDR9.Bits.BIT11
#define ATDDR9_BIT12                    _ATDDR9.Bits.BIT12
#define ATDDR9_BIT13                    _ATDDR9.Bits.BIT13
#define ATDDR9_BIT14                    _ATDDR9.Bits.BIT14
#define ATDDR9_BIT15                    _ATDDR9.Bits.BIT15

#define ATDDR9_BIT0_MASK                1U
#define ATDDR9_BIT1_MASK                2U
#define ATDDR9_BIT2_MASK                4U
#define ATDDR9_BIT3_MASK                8U
#define ATDDR9_BIT4_MASK                16U
#define ATDDR9_BIT5_MASK                32U
#define ATDDR9_BIT6_MASK                64U
#define ATDDR9_BIT7_MASK                128U
#define ATDDR9_BIT8_MASK                256U
#define ATDDR9_BIT9_MASK                512U
#define ATDDR9_BIT10_MASK               1024U
#define ATDDR9_BIT11_MASK               2048U
#define ATDDR9_BIT12_MASK               4096U
#define ATDDR9_BIT13_MASK               8192U
#define ATDDR9_BIT14_MASK               16384U
#define ATDDR9_BIT15_MASK               32768U


/*** ATDDR10 - ATD  Conversion Result Register 10; 0x00000094 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR10H - ATD  Conversion Result Register 10 High; 0x00000094 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR10HSTR;
    #define ATDDR10H                    _ATDDR10.Overlap_STR.ATDDR10HSTR.Byte
    #define ATDDR10H_BIT8               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT8
    #define ATDDR10H_BIT9               _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT9
    #define ATDDR10H_BIT10              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT10
    #define ATDDR10H_BIT11              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT11
    #define ATDDR10H_BIT12              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT12
    #define ATDDR10H_BIT13              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT13
    #define ATDDR10H_BIT14              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT14
    #define ATDDR10H_BIT15              _ATDDR10.Overlap_STR.ATDDR10HSTR.Bits.BIT15
    
    #define ATDDR10H_BIT8_MASK          1U
    #define ATDDR10H_BIT9_MASK          2U
    #define ATDDR10H_BIT10_MASK         4U
    #define ATDDR10H_BIT11_MASK         8U
    #define ATDDR10H_BIT12_MASK         16U
    #define ATDDR10H_BIT13_MASK         32U
    #define ATDDR10H_BIT14_MASK         64U
    #define ATDDR10H_BIT15_MASK         128U
    

    /*** ATDDR10L - ATD  Conversion Result Register 10 Low; 0x00000095 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR10LSTR;
    #define ATDDR10L                    _ATDDR10.Overlap_STR.ATDDR10LSTR.Byte
    #define ATDDR10L_BIT0               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT0
    #define ATDDR10L_BIT1               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT1
    #define ATDDR10L_BIT2               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT2
    #define ATDDR10L_BIT3               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT3
    #define ATDDR10L_BIT4               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT4
    #define ATDDR10L_BIT5               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT5
    #define ATDDR10L_BIT6               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT6
    #define ATDDR10L_BIT7               _ATDDR10.Overlap_STR.ATDDR10LSTR.Bits.BIT7
    
    #define ATDDR10L_BIT0_MASK          1U
    #define ATDDR10L_BIT1_MASK          2U
    #define ATDDR10L_BIT2_MASK          4U
    #define ATDDR10L_BIT3_MASK          8U
    #define ATDDR10L_BIT4_MASK          16U
    #define ATDDR10L_BIT5_MASK          32U
    #define ATDDR10L_BIT6_MASK          64U
    #define ATDDR10L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR10STR;
extern volatile ATDDR10STR _ATDDR10 @(REG_BASE + 0x00000094UL);
#define ATDDR10                         _ATDDR10.Word
#define ATDDR10_BIT0                    _ATDDR10.Bits.BIT0
#define ATDDR10_BIT1                    _ATDDR10.Bits.BIT1
#define ATDDR10_BIT2                    _ATDDR10.Bits.BIT2
#define ATDDR10_BIT3                    _ATDDR10.Bits.BIT3
#define ATDDR10_BIT4                    _ATDDR10.Bits.BIT4
#define ATDDR10_BIT5                    _ATDDR10.Bits.BIT5
#define ATDDR10_BIT6                    _ATDDR10.Bits.BIT6
#define ATDDR10_BIT7                    _ATDDR10.Bits.BIT7
#define ATDDR10_BIT8                    _ATDDR10.Bits.BIT8
#define ATDDR10_BIT9                    _ATDDR10.Bits.BIT9
#define ATDDR10_BIT10                   _ATDDR10.Bits.BIT10
#define ATDDR10_BIT11                   _ATDDR10.Bits.BIT11
#define ATDDR10_BIT12                   _ATDDR10.Bits.BIT12
#define ATDDR10_BIT13                   _ATDDR10.Bits.BIT13
#define ATDDR10_BIT14                   _ATDDR10.Bits.BIT14
#define ATDDR10_BIT15                   _ATDDR10.Bits.BIT15

#define ATDDR10_BIT0_MASK               1U
#define ATDDR10_BIT1_MASK               2U
#define ATDDR10_BIT2_MASK               4U
#define ATDDR10_BIT3_MASK               8U
#define ATDDR10_BIT4_MASK               16U
#define ATDDR10_BIT5_MASK               32U
#define ATDDR10_BIT6_MASK               64U
#define ATDDR10_BIT7_MASK               128U
#define ATDDR10_BIT8_MASK               256U
#define ATDDR10_BIT9_MASK               512U
#define ATDDR10_BIT10_MASK              1024U
#define ATDDR10_BIT11_MASK              2048U
#define ATDDR10_BIT12_MASK              4096U
#define ATDDR10_BIT13_MASK              8192U
#define ATDDR10_BIT14_MASK              16384U
#define ATDDR10_BIT15_MASK              32768U


/*** ATDDR11 - ATD  Conversion Result Register 11; 0x00000096 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATDDR11H - ATD  Conversion Result Register 11 High; 0x00000096 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATDDR11HSTR;
    #define ATDDR11H                    _ATDDR11.Overlap_STR.ATDDR11HSTR.Byte
    #define ATDDR11H_BIT8               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT8
    #define ATDDR11H_BIT9               _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT9
    #define ATDDR11H_BIT10              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT10
    #define ATDDR11H_BIT11              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT11
    #define ATDDR11H_BIT12              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT12
    #define ATDDR11H_BIT13              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT13
    #define ATDDR11H_BIT14              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT14
    #define ATDDR11H_BIT15              _ATDDR11.Overlap_STR.ATDDR11HSTR.Bits.BIT15
    
    #define ATDDR11H_BIT8_MASK          1U
    #define ATDDR11H_BIT9_MASK          2U
    #define ATDDR11H_BIT10_MASK         4U
    #define ATDDR11H_BIT11_MASK         8U
    #define ATDDR11H_BIT12_MASK         16U
    #define ATDDR11H_BIT13_MASK         32U
    #define ATDDR11H_BIT14_MASK         64U
    #define ATDDR11H_BIT15_MASK         128U
    

    /*** ATDDR11L - ATD  Conversion Result Register 11 Low; 0x00000097 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATDDR11LSTR;
    #define ATDDR11L                    _ATDDR11.Overlap_STR.ATDDR11LSTR.Byte
    #define ATDDR11L_BIT0               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT0
    #define ATDDR11L_BIT1               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT1
    #define ATDDR11L_BIT2               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT2
    #define ATDDR11L_BIT3               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT3
    #define ATDDR11L_BIT4               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT4
    #define ATDDR11L_BIT5               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT5
    #define ATDDR11L_BIT6               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT6
    #define ATDDR11L_BIT7               _ATDDR11.Overlap_STR.ATDDR11LSTR.Bits.BIT7
    
    #define ATDDR11L_BIT0_MASK          1U
    #define ATDDR11L_BIT1_MASK          2U
    #define ATDDR11L_BIT2_MASK          4U
    #define ATDDR11L_BIT3_MASK          8U
    #define ATDDR11L_BIT4_MASK          16U
    #define ATDDR11L_BIT5_MASK          32U
    #define ATDDR11L_BIT6_MASK          64U
    #define ATDDR11L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATDDR11STR;
extern volatile ATDDR11STR _ATDDR11 @(REG_BASE + 0x00000096UL);
#define ATDDR11                         _ATDDR11.Word
#define ATDDR11_BIT0                    _ATDDR11.Bits.BIT0
#define ATDDR11_BIT1                    _ATDDR11.Bits.BIT1
#define ATDDR11_BIT2                    _ATDDR11.Bits.BIT2
#define ATDDR11_BIT3                    _ATDDR11.Bits.BIT3
#define ATDDR11_BIT4                    _ATDDR11.Bits.BIT4
#define ATDDR11_BIT5                    _ATDDR11.Bits.BIT5
#define ATDDR11_BIT6                    _ATDDR11.Bits.BIT6
#define ATDDR11_BIT7                    _ATDDR11.Bits.BIT7
#define ATDDR11_BIT8                    _ATDDR11.Bits.BIT8
#define ATDDR11_BIT9                    _ATDDR11.Bits.BIT9
#define ATDDR11_BIT10                   _ATDDR11.Bits.BIT10
#define ATDDR11_BIT11                   _ATDDR11.Bits.BIT11
#define ATDDR11_BIT12                   _ATDDR11.Bits.BIT12
#define ATDDR11_BIT13                   _ATDDR11.Bits.BIT13
#define ATDDR11_BIT14                   _ATDDR11.Bits.BIT14
#define ATDDR11_BIT15                   _ATDDR11.Bits.BIT15

#define ATDDR11_BIT0_MASK               1U
#define ATDDR11_BIT1_MASK               2U
#define ATDDR11_BIT2_MASK               4U
#define ATDDR11_BIT3_MASK               8U
#define ATDDR11_BIT4_MASK               16U
#define ATDDR11_BIT5_MASK               32U
#define ATDDR11_BIT6_MASK               64U
#define ATDDR11_BIT7_MASK               128U
#define ATDDR11_BIT8_MASK               256U
#define ATDDR11_BIT9_MASK               512U
#define ATDDR11_BIT10_MASK              1024U
#define ATDDR11_BIT11_MASK              2048U
#define ATDDR11_BIT12_MASK              4096U
#define ATDDR11_BIT13_MASK              8192U
#define ATDDR11_BIT14_MASK              16384U
#define ATDDR11_BIT15_MASK              32768U


/*** PWME - PWM Enable Register; 0x000000A0 ***/
typedef union {
  byte Byte;
  struct {
    byte PWME0       :1;                                       /* Pulse Width Channel 0 Enable */
    byte PWME1       :1;                                       /* Pulse Width Channel 1 Enable */
    byte PWME2       :1;                                       /* Pulse Width Channel 2 Enable */
    byte PWME3       :1;                                       /* Pulse Width Channel 3 Enable */
    byte PWME4       :1;                                       /* Pulse Width Channel 4 Enable */
    byte PWME5       :1;                                       /* Pulse Width Channel 5 Enable */
    byte PWME6       :1;                                       /* Pulse Width Channel 6 Enable */
    byte PWME7       :1;                                       /* Pulse Width Channel 7 Enable */
  } Bits;
} PWMESTR;
extern volatile PWMESTR _PWME @(REG_BASE + 0x000000A0UL);
#define PWME                            _PWME.Byte
#define PWME_PWME0                      _PWME.Bits.PWME0
#define PWME_PWME1                      _PWME.Bits.PWME1
#define PWME_PWME2                      _PWME.Bits.PWME2
#define PWME_PWME3                      _PWME.Bits.PWME3
#define PWME_PWME4                      _PWME.Bits.PWME4
#define PWME_PWME5                      _PWME.Bits.PWME5
#define PWME_PWME6                      _PWME.Bits.PWME6
#define PWME_PWME7                      _PWME.Bits.PWME7

#define PWME_PWME0_MASK                 1U
#define PWME_PWME1_MASK                 2U
#define PWME_PWME2_MASK                 4U
#define PWME_PWME3_MASK                 8U
#define PWME_PWME4_MASK                 16U
#define PWME_PWME5_MASK                 32U
#define PWME_PWME6_MASK                 64U
#define PWME_PWME7_MASK                 128U


/*** PWMPOL - PWM Polarity Register; 0x000000A1 ***/
typedef union {
  byte Byte;
  struct {
    byte PPOL0       :1;                                       /* Pulse Width Channel 0 Polarity */
    byte PPOL1       :1;                                       /* Pulse Width Channel 1 Polarity */
    byte PPOL2       :1;                                       /* Pulse Width Channel 2 Polarity */
    byte PPOL3       :1;                                       /* Pulse Width Channel 3 Polarity */
    byte PPOL4       :1;                                       /* Pulse Width Channel 4 Polarity */
    byte PPOL5       :1;                                       /* Pulse Width Channel 5 Polarity */
    byte PPOL6       :1;                                       /* Pulse Width Channel 6 Polarity */
    byte PPOL7       :1;                                       /* Pulse Width Channel 7 Polarity */
  } Bits;
} PWMPOLSTR;
extern volatile PWMPOLSTR _PWMPOL @(REG_BASE + 0x000000A1UL);
#define PWMPOL                          _PWMPOL.Byte
#define PWMPOL_PPOL0                    _PWMPOL.Bits.PPOL0
#define PWMPOL_PPOL1                    _PWMPOL.Bits.PPOL1
#define PWMPOL_PPOL2                    _PWMPOL.Bits.PPOL2
#define PWMPOL_PPOL3                    _PWMPOL.Bits.PPOL3
#define PWMPOL_PPOL4                    _PWMPOL.Bits.PPOL4
#define PWMPOL_PPOL5                    _PWMPOL.Bits.PPOL5
#define PWMPOL_PPOL6                    _PWMPOL.Bits.PPOL6
#define PWMPOL_PPOL7                    _PWMPOL.Bits.PPOL7

#define PWMPOL_PPOL0_MASK               1U
#define PWMPOL_PPOL1_MASK               2U
#define PWMPOL_PPOL2_MASK               4U
#define PWMPOL_PPOL3_MASK               8U
#define PWMPOL_PPOL4_MASK               16U
#define PWMPOL_PPOL5_MASK               32U
#define PWMPOL_PPOL6_MASK               64U
#define PWMPOL_PPOL7_MASK               128U


/*** PWMCLK - PWM Clock Select Register; 0x000000A2 ***/
typedef union {
  byte Byte;
  struct {
    byte PCLK0       :1;                                       /* Pulse Width Channel 0 Clock Select */
    byte PCLK1       :1;                                       /* Pulse Width Channel 1 Clock Select */
    byte PCLK2       :1;                                       /* Pulse Width Channel 2 Clock Select */
    byte PCLK3       :1;                                       /* Pulse Width Channel 3 Clock Select */
    byte PCLK4       :1;                                       /* Pulse Width Channel 4 Clock Select */
    byte PCLK5       :1;                                       /* Pulse Width Channel 5 Clock Select */
    byte PCLK6       :1;                                       /* Pulse Width Channel 6 Clock Select */
    byte PCLK7       :1;                                       /* Pulse Width Channel 7 Clock Select */
  } Bits;
} PWMCLKSTR;
extern volatile PWMCLKSTR _PWMCLK @(REG_BASE + 0x000000A2UL);
#define PWMCLK                          _PWMCLK.Byte
#define PWMCLK_PCLK0                    _PWMCLK.Bits.PCLK0
#define PWMCLK_PCLK1                    _PWMCLK.Bits.PCLK1
#define PWMCLK_PCLK2                    _PWMCLK.Bits.PCLK2
#define PWMCLK_PCLK3                    _PWMCLK.Bits.PCLK3
#define PWMCLK_PCLK4                    _PWMCLK.Bits.PCLK4
#define PWMCLK_PCLK5                    _PWMCLK.Bits.PCLK5
#define PWMCLK_PCLK6                    _PWMCLK.Bits.PCLK6
#define PWMCLK_PCLK7                    _PWMCLK.Bits.PCLK7

#define PWMCLK_PCLK0_MASK               1U
#define PWMCLK_PCLK1_MASK               2U
#define PWMCLK_PCLK2_MASK               4U
#define PWMCLK_PCLK3_MASK               8U
#define PWMCLK_PCLK4_MASK               16U
#define PWMCLK_PCLK5_MASK               32U
#define PWMCLK_PCLK6_MASK               64U
#define PWMCLK_PCLK7_MASK               128U


/*** PWMPRCLK - PWM Prescale Clock Select Register; 0x000000A3 ***/
typedef union {
  byte Byte;
  struct {
    byte PCKA0       :1;                                       /* Prescaler Select for Clock A 0 */
    byte PCKA1       :1;                                       /* Prescaler Select for Clock A 1 */
    byte PCKA2       :1;                                       /* Prescaler Select for Clock A 2 */
    byte             :1; 
    byte PCKB0       :1;                                       /* Prescaler Select for Clock B 0 */
    byte PCKB1       :1;                                       /* Prescaler Select for Clock B 1 */
    byte PCKB2       :1;                                       /* Prescaler Select for Clock B 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPCKA :3;
    byte         :1;
    byte grpPCKB :3;
    byte         :1;
  } MergedBits;
} PWMPRCLKSTR;
extern volatile PWMPRCLKSTR _PWMPRCLK @(REG_BASE + 0x000000A3UL);
#define PWMPRCLK                        _PWMPRCLK.Byte
#define PWMPRCLK_PCKA0                  _PWMPRCLK.Bits.PCKA0
#define PWMPRCLK_PCKA1                  _PWMPRCLK.Bits.PCKA1
#define PWMPRCLK_PCKA2                  _PWMPRCLK.Bits.PCKA2
#define PWMPRCLK_PCKB0                  _PWMPRCLK.Bits.PCKB0
#define PWMPRCLK_PCKB1                  _PWMPRCLK.Bits.PCKB1
#define PWMPRCLK_PCKB2                  _PWMPRCLK.Bits.PCKB2
#define PWMPRCLK_PCKA                   _PWMPRCLK.MergedBits.grpPCKA
#define PWMPRCLK_PCKB                   _PWMPRCLK.MergedBits.grpPCKB

#define PWMPRCLK_PCKA0_MASK             1U
#define PWMPRCLK_PCKA1_MASK             2U
#define PWMPRCLK_PCKA2_MASK             4U
#define PWMPRCLK_PCKB0_MASK             16U
#define PWMPRCLK_PCKB1_MASK             32U
#define PWMPRCLK_PCKB2_MASK             64U
#define PWMPRCLK_PCKA_MASK              7U
#define PWMPRCLK_PCKA_BITNUM            0U
#define PWMPRCLK_PCKB_MASK              112U
#define PWMPRCLK_PCKB_BITNUM            4U


/*** PWMCAE - PWM Center Align Enable Register; 0x000000A4 ***/
typedef union {
  byte Byte;
  struct {
    byte CAE0        :1;                                       /* Center Aligned Output Mode on channel 0 */
    byte CAE1        :1;                                       /* Center Aligned Output Mode on channel 1 */
    byte CAE2        :1;                                       /* Center Aligned Output Mode on channel 2 */
    byte CAE3        :1;                                       /* Center Aligned Output Mode on channel 3 */
    byte CAE4        :1;                                       /* Center Aligned Output Mode on channel 4 */
    byte CAE5        :1;                                       /* Center Aligned Output Mode on channel 5 */
    byte CAE6        :1;                                       /* Center Aligned Output Mode on channel 6 */
    byte CAE7        :1;                                       /* Center Aligned Output Mode on channel 7 */
  } Bits;
} PWMCAESTR;
extern volatile PWMCAESTR _PWMCAE @(REG_BASE + 0x000000A4UL);
#define PWMCAE                          _PWMCAE.Byte
#define PWMCAE_CAE0                     _PWMCAE.Bits.CAE0
#define PWMCAE_CAE1                     _PWMCAE.Bits.CAE1
#define PWMCAE_CAE2                     _PWMCAE.Bits.CAE2
#define PWMCAE_CAE3                     _PWMCAE.Bits.CAE3
#define PWMCAE_CAE4                     _PWMCAE.Bits.CAE4
#define PWMCAE_CAE5                     _PWMCAE.Bits.CAE5
#define PWMCAE_CAE6                     _PWMCAE.Bits.CAE6
#define PWMCAE_CAE7                     _PWMCAE.Bits.CAE7

#define PWMCAE_CAE0_MASK                1U
#define PWMCAE_CAE1_MASK                2U
#define PWMCAE_CAE2_MASK                4U
#define PWMCAE_CAE3_MASK                8U
#define PWMCAE_CAE4_MASK                16U
#define PWMCAE_CAE5_MASK                32U
#define PWMCAE_CAE6_MASK                64U
#define PWMCAE_CAE7_MASK                128U


/*** PWMCTL - PWM Control Register; 0x000000A5 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PFRZ        :1;                                       /* PWM Counters Stop in Freeze Mode */
    byte PSWAI       :1;                                       /* PWM Stops in Wait Mode */
    byte CON01       :1;                                       /* Concatenate channels 0 and 1 */
    byte CON23       :1;                                       /* Concatenate channels 2 and 3 */
    byte CON45       :1;                                       /* Concatenate channels 4 and 5 */
    byte CON67       :1;                                       /* Concatenate channels 6 and 7 */
  } Bits;
} PWMCTLSTR;
extern volatile PWMCTLSTR _PWMCTL @(REG_BASE + 0x000000A5UL);
#define PWMCTL                          _PWMCTL.Byte
#define PWMCTL_PFRZ                     _PWMCTL.Bits.PFRZ
#define PWMCTL_PSWAI                    _PWMCTL.Bits.PSWAI
#define PWMCTL_CON01                    _PWMCTL.Bits.CON01
#define PWMCTL_CON23                    _PWMCTL.Bits.CON23
#define PWMCTL_CON45                    _PWMCTL.Bits.CON45
#define PWMCTL_CON67                    _PWMCTL.Bits.CON67

#define PWMCTL_PFRZ_MASK                4U
#define PWMCTL_PSWAI_MASK               8U
#define PWMCTL_CON01_MASK               16U
#define PWMCTL_CON23_MASK               32U
#define PWMCTL_CON45_MASK               64U
#define PWMCTL_CON67_MASK               128U


/*** PWMSCLA - PWM Scale A Register; 0x000000A8 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale A Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale A Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale A Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale A Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale A Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale A Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale A Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale A Bit 7 */
  } Bits;
} PWMSCLASTR;
extern volatile PWMSCLASTR _PWMSCLA @(REG_BASE + 0x000000A8UL);
#define PWMSCLA                         _PWMSCLA.Byte
#define PWMSCLA_BIT0                    _PWMSCLA.Bits.BIT0
#define PWMSCLA_BIT1                    _PWMSCLA.Bits.BIT1
#define PWMSCLA_BIT2                    _PWMSCLA.Bits.BIT2
#define PWMSCLA_BIT3                    _PWMSCLA.Bits.BIT3
#define PWMSCLA_BIT4                    _PWMSCLA.Bits.BIT4
#define PWMSCLA_BIT5                    _PWMSCLA.Bits.BIT5
#define PWMSCLA_BIT6                    _PWMSCLA.Bits.BIT6
#define PWMSCLA_BIT7                    _PWMSCLA.Bits.BIT7

#define PWMSCLA_BIT0_MASK               1U
#define PWMSCLA_BIT1_MASK               2U
#define PWMSCLA_BIT2_MASK               4U
#define PWMSCLA_BIT3_MASK               8U
#define PWMSCLA_BIT4_MASK               16U
#define PWMSCLA_BIT5_MASK               32U
#define PWMSCLA_BIT6_MASK               64U
#define PWMSCLA_BIT7_MASK               128U


/*** PWMSCLB - PWM Scale B Register; 0x000000A9 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* PWM Scale B Bit 0 */
    byte BIT1        :1;                                       /* PWM Scale B Bit 1 */
    byte BIT2        :1;                                       /* PWM Scale B Bit 2 */
    byte BIT3        :1;                                       /* PWM Scale B Bit 3 */
    byte BIT4        :1;                                       /* PWM Scale B Bit 4 */
    byte BIT5        :1;                                       /* PWM Scale B Bit 5 */
    byte BIT6        :1;                                       /* PWM Scale B Bit 6 */
    byte BIT7        :1;                                       /* PWM Scale B Bit 7 */
  } Bits;
} PWMSCLBSTR;
extern volatile PWMSCLBSTR _PWMSCLB @(REG_BASE + 0x000000A9UL);
#define PWMSCLB                         _PWMSCLB.Byte
#define PWMSCLB_BIT0                    _PWMSCLB.Bits.BIT0
#define PWMSCLB_BIT1                    _PWMSCLB.Bits.BIT1
#define PWMSCLB_BIT2                    _PWMSCLB.Bits.BIT2
#define PWMSCLB_BIT3                    _PWMSCLB.Bits.BIT3
#define PWMSCLB_BIT4                    _PWMSCLB.Bits.BIT4
#define PWMSCLB_BIT5                    _PWMSCLB.Bits.BIT5
#define PWMSCLB_BIT6                    _PWMSCLB.Bits.BIT6
#define PWMSCLB_BIT7                    _PWMSCLB.Bits.BIT7

#define PWMSCLB_BIT0_MASK               1U
#define PWMSCLB_BIT1_MASK               2U
#define PWMSCLB_BIT2_MASK               4U
#define PWMSCLB_BIT3_MASK               8U
#define PWMSCLB_BIT4_MASK               16U
#define PWMSCLB_BIT5_MASK               32U
#define PWMSCLB_BIT6_MASK               64U
#define PWMSCLB_BIT7_MASK               128U


/*** PWMCNT01 - PWM Channel Counter 01 Register; 0x000000AC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT0 - PWM Channel Counter 0 Register; 0x000000AC ***/
    union {
      byte Byte;
    } PWMCNT0STR;
    #define PWMCNT0                     _PWMCNT01.Overlap_STR.PWMCNT0STR.Byte
    /* PWMCNT_ARR: Access 8 PWMCNTx registers in an array */
    #define PWMCNT_ARR                  ((volatile byte *) &PWMCNT0)
    

    /*** PWMCNT1 - PWM Channel Counter 1 Register; 0x000000AD ***/
    union {
      byte Byte;
    } PWMCNT1STR;
    #define PWMCNT1                     _PWMCNT01.Overlap_STR.PWMCNT1STR.Byte
    
  } Overlap_STR;

} PWMCNT01STR;
extern volatile PWMCNT01STR _PWMCNT01 @(REG_BASE + 0x000000ACUL);
#define PWMCNT01                        _PWMCNT01.Word


/*** PWMCNT23 - PWM Channel Counter 23 Register; 0x000000AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT2 - PWM Channel Counter 2 Register; 0x000000AE ***/
    union {
      byte Byte;
    } PWMCNT2STR;
    #define PWMCNT2                     _PWMCNT23.Overlap_STR.PWMCNT2STR.Byte
    

    /*** PWMCNT3 - PWM Channel Counter 3 Register; 0x000000AF ***/
    union {
      byte Byte;
    } PWMCNT3STR;
    #define PWMCNT3                     _PWMCNT23.Overlap_STR.PWMCNT3STR.Byte
    
  } Overlap_STR;

} PWMCNT23STR;
extern volatile PWMCNT23STR _PWMCNT23 @(REG_BASE + 0x000000AEUL);
#define PWMCNT23                        _PWMCNT23.Word


/*** PWMCNT45 - PWM Channel Counter 45 Register; 0x000000B0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT4 - PWM Channel Counter 4 Register; 0x000000B0 ***/
    union {
      byte Byte;
    } PWMCNT4STR;
    #define PWMCNT4                     _PWMCNT45.Overlap_STR.PWMCNT4STR.Byte
    

    /*** PWMCNT5 - PWM Channel Counter 5 Register; 0x000000B1 ***/
    union {
      byte Byte;
    } PWMCNT5STR;
    #define PWMCNT5                     _PWMCNT45.Overlap_STR.PWMCNT5STR.Byte
    
  } Overlap_STR;

} PWMCNT45STR;
extern volatile PWMCNT45STR _PWMCNT45 @(REG_BASE + 0x000000B0UL);
#define PWMCNT45                        _PWMCNT45.Word


/*** PWMCNT67 - PWM Channel Counter 67 Register; 0x000000B2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMCNT6 - PWM Channel Counter 6 Register; 0x000000B2 ***/
    union {
      byte Byte;
    } PWMCNT6STR;
    #define PWMCNT6                     _PWMCNT67.Overlap_STR.PWMCNT6STR.Byte
    

    /*** PWMCNT7 - PWM Channel Counter 7 Register; 0x000000B3 ***/
    union {
      byte Byte;
    } PWMCNT7STR;
    #define PWMCNT7                     _PWMCNT67.Overlap_STR.PWMCNT7STR.Byte
    
  } Overlap_STR;

} PWMCNT67STR;
extern volatile PWMCNT67STR _PWMCNT67 @(REG_BASE + 0x000000B2UL);
#define PWMCNT67                        _PWMCNT67.Word


/*** PWMPER01 - PWM Channel Period 01 Register; 0x000000B4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER0 - PWM Channel Period 0 Register; 0x000000B4 ***/
    union {
      byte Byte;
    } PWMPER0STR;
    #define PWMPER0                     _PWMPER01.Overlap_STR.PWMPER0STR.Byte
    /* PWMPER_ARR: Access 8 PWMPERx registers in an array */
    #define PWMPER_ARR                  ((volatile byte *) &PWMPER0)
    

    /*** PWMPER1 - PWM Channel Period 1 Register; 0x000000B5 ***/
    union {
      byte Byte;
    } PWMPER1STR;
    #define PWMPER1                     _PWMPER01.Overlap_STR.PWMPER1STR.Byte
    
  } Overlap_STR;

} PWMPER01STR;
extern volatile PWMPER01STR _PWMPER01 @(REG_BASE + 0x000000B4UL);
#define PWMPER01                        _PWMPER01.Word


/*** PWMPER23 - PWM Channel Period 23 Register; 0x000000B6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER2 - PWM Channel Period 2 Register; 0x000000B6 ***/
    union {
      byte Byte;
    } PWMPER2STR;
    #define PWMPER2                     _PWMPER23.Overlap_STR.PWMPER2STR.Byte
    

    /*** PWMPER3 - PWM Channel Period 3 Register; 0x000000B7 ***/
    union {
      byte Byte;
    } PWMPER3STR;
    #define PWMPER3                     _PWMPER23.Overlap_STR.PWMPER3STR.Byte
    
  } Overlap_STR;

} PWMPER23STR;
extern volatile PWMPER23STR _PWMPER23 @(REG_BASE + 0x000000B6UL);
#define PWMPER23                        _PWMPER23.Word


/*** PWMPER45 - PWM Channel Period 45 Register; 0x000000B8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER4 - PWM Channel Period 4 Register; 0x000000B8 ***/
    union {
      byte Byte;
    } PWMPER4STR;
    #define PWMPER4                     _PWMPER45.Overlap_STR.PWMPER4STR.Byte
    

    /*** PWMPER5 - PWM Channel Period 5 Register; 0x000000B9 ***/
    union {
      byte Byte;
    } PWMPER5STR;
    #define PWMPER5                     _PWMPER45.Overlap_STR.PWMPER5STR.Byte
    
  } Overlap_STR;

} PWMPER45STR;
extern volatile PWMPER45STR _PWMPER45 @(REG_BASE + 0x000000B8UL);
#define PWMPER45                        _PWMPER45.Word


/*** PWMPER67 - PWM Channel Period 67 Register; 0x000000BA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMPER6 - PWM Channel Period 6 Register; 0x000000BA ***/
    union {
      byte Byte;
    } PWMPER6STR;
    #define PWMPER6                     _PWMPER67.Overlap_STR.PWMPER6STR.Byte
    

    /*** PWMPER7 - PWM Channel Period 7 Register; 0x000000BB ***/
    union {
      byte Byte;
    } PWMPER7STR;
    #define PWMPER7                     _PWMPER67.Overlap_STR.PWMPER7STR.Byte
    
  } Overlap_STR;

} PWMPER67STR;
extern volatile PWMPER67STR _PWMPER67 @(REG_BASE + 0x000000BAUL);
#define PWMPER67                        _PWMPER67.Word


/*** PWMDTY01 - PWM Channel Duty 01 Register; 0x000000BC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY0 - PWM Channel Duty 0 Register; 0x000000BC ***/
    union {
      byte Byte;
    } PWMDTY0STR;
    #define PWMDTY0                     _PWMDTY01.Overlap_STR.PWMDTY0STR.Byte
    /* PWMDTY_ARR: Access 8 PWMDTYx registers in an array */
    #define PWMDTY_ARR                  ((volatile byte *) &PWMDTY0)
    

    /*** PWMDTY1 - PWM Channel Duty 1 Register; 0x000000BD ***/
    union {
      byte Byte;
    } PWMDTY1STR;
    #define PWMDTY1                     _PWMDTY01.Overlap_STR.PWMDTY1STR.Byte
    
  } Overlap_STR;

} PWMDTY01STR;
extern volatile PWMDTY01STR _PWMDTY01 @(REG_BASE + 0x000000BCUL);
#define PWMDTY01                        _PWMDTY01.Word


/*** PWMDTY23 - PWM Channel Duty 23 Register; 0x000000BE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY2 - PWM Channel Duty 2 Register; 0x000000BE ***/
    union {
      byte Byte;
    } PWMDTY2STR;
    #define PWMDTY2                     _PWMDTY23.Overlap_STR.PWMDTY2STR.Byte
    

    /*** PWMDTY3 - PWM Channel Duty 3 Register; 0x000000BF ***/
    union {
      byte Byte;
    } PWMDTY3STR;
    #define PWMDTY3                     _PWMDTY23.Overlap_STR.PWMDTY3STR.Byte
    
  } Overlap_STR;

} PWMDTY23STR;
extern volatile PWMDTY23STR _PWMDTY23 @(REG_BASE + 0x000000BEUL);
#define PWMDTY23                        _PWMDTY23.Word


/*** PWMDTY45 - PWM Channel Duty 45 Register; 0x000000C0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY4 - PWM Channel Duty 4 Register; 0x000000C0 ***/
    union {
      byte Byte;
    } PWMDTY4STR;
    #define PWMDTY4                     _PWMDTY45.Overlap_STR.PWMDTY4STR.Byte
    

    /*** PWMDTY5 - PWM Channel Duty 5 Register; 0x000000C1 ***/
    union {
      byte Byte;
    } PWMDTY5STR;
    #define PWMDTY5                     _PWMDTY45.Overlap_STR.PWMDTY5STR.Byte
    
  } Overlap_STR;

} PWMDTY45STR;
extern volatile PWMDTY45STR _PWMDTY45 @(REG_BASE + 0x000000C0UL);
#define PWMDTY45                        _PWMDTY45.Word


/*** PWMDTY67 - PWM Channel Duty 67 Register; 0x000000C2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PWMDTY6 - PWM Channel Duty 6 Register; 0x000000C2 ***/
    union {
      byte Byte;
    } PWMDTY6STR;
    #define PWMDTY6                     _PWMDTY67.Overlap_STR.PWMDTY6STR.Byte
    

    /*** PWMDTY7 - PWM Channel Duty 7 Register; 0x000000C3 ***/
    union {
      byte Byte;
    } PWMDTY7STR;
    #define PWMDTY7                     _PWMDTY67.Overlap_STR.PWMDTY7STR.Byte
    
  } Overlap_STR;

} PWMDTY67STR;
extern volatile PWMDTY67STR _PWMDTY67 @(REG_BASE + 0x000000C2UL);
#define PWMDTY67                        _PWMDTY67.Word


/*** PWMSDN - PWM Shutdown Register; 0x000000C4 ***/
typedef union {
  byte Byte;
  struct {
    byte PWM7ENA     :1;                                       /* PWM emergency shutdown Enable */
    byte PWM7INL     :1;                                       /* PWM shutdown active input level for ch. 7 */
    byte PWM7IN      :1;                                       /* PWM channel 7 input status */
    byte             :1; 
    byte PWMLVL      :1;                                       /* PWM shutdown output Level */
    byte PWMRSTRT    :1;                                       /* PWM Restart */
    byte PWMIE       :1;                                       /* PWM Interrupt Enable */
    byte PWMIF       :1;                                       /* PWM Interrupt Flag */
  } Bits;
} PWMSDNSTR;
extern volatile PWMSDNSTR _PWMSDN @(REG_BASE + 0x000000C4UL);
#define PWMSDN                          _PWMSDN.Byte
#define PWMSDN_PWM7ENA                  _PWMSDN.Bits.PWM7ENA
#define PWMSDN_PWM7INL                  _PWMSDN.Bits.PWM7INL
#define PWMSDN_PWM7IN                   _PWMSDN.Bits.PWM7IN
#define PWMSDN_PWMLVL                   _PWMSDN.Bits.PWMLVL
#define PWMSDN_PWMRSTRT                 _PWMSDN.Bits.PWMRSTRT
#define PWMSDN_PWMIE                    _PWMSDN.Bits.PWMIE
#define PWMSDN_PWMIF                    _PWMSDN.Bits.PWMIF

#define PWMSDN_PWM7ENA_MASK             1U
#define PWMSDN_PWM7INL_MASK             2U
#define PWMSDN_PWM7IN_MASK              4U
#define PWMSDN_PWMLVL_MASK              16U
#define PWMSDN_PWMRSTRT_MASK            32U
#define PWMSDN_PWMIE_MASK               64U
#define PWMSDN_PWMIF_MASK               128U


/*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI0ASR1STR;
        #define SCI0ASR1                _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0ASR1_BKDIF          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BKDIF
        #define SCI0ASR1_BERRIF         _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRIF
        #define SCI0ASR1_BERRV          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRV
        #define SCI0ASR1_RXEDGIF        _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.RXEDGIF
        
        #define SCI0ASR1_BKDIF_MASK     1U
        #define SCI0ASR1_BERRIF_MASK    2U
        #define SCI0ASR1_BERRV_MASK     4U
        #define SCI0ASR1_RXEDGIF_MASK   128U
        
        /*** SCI0BDH - SCI 0 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI0BDHSTR;
        #define SCI0BDH                 _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0BDH_SBR8            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR8
        #define SCI0BDH_SBR9            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR9
        #define SCI0BDH_SBR10           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR10
        #define SCI0BDH_SBR11           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR11
        #define SCI0BDH_SBR12           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR12
        #define SCI0BDH_TNP0            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP0
        #define SCI0BDH_TNP1            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP1
        #define SCI0BDH_IREN            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.IREN
        #define SCI0BDH_SBR_8           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpSBR_8
        #define SCI0BDH_TNP             _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpTNP
        #define SCI0BDH_SBR             SCI0BDH_SBR_8
        
        #define SCI0BDH_SBR8_MASK       1U
        #define SCI0BDH_SBR9_MASK       2U
        #define SCI0BDH_SBR10_MASK      4U
        #define SCI0BDH_SBR11_MASK      8U
        #define SCI0BDH_SBR12_MASK      16U
        #define SCI0BDH_TNP0_MASK       32U
        #define SCI0BDH_TNP1_MASK       64U
        #define SCI0BDH_IREN_MASK       128U
        #define SCI0BDH_SBR_8_MASK      31U
        #define SCI0BDH_SBR_8_BITNUM    0U
        #define SCI0BDH_TNP_MASK        96U
        #define SCI0BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ASR1STR;
    

    /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI0ACR1STR;
        #define SCI0ACR1                _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0ACR1_BKDIE          _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BKDIE
        #define SCI0ACR1_BERRIE         _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BERRIE
        #define SCI0ACR1_RXEDGIE        _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.RXEDGIE
        
        #define SCI0ACR1_BKDIE_MASK     1U
        #define SCI0ACR1_BERRIE_MASK    2U
        #define SCI0ACR1_RXEDGIE_MASK   128U
        
        /*** SCI0BDL - SCI 0 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI0BDLSTR;
        #define SCI0BDL                 _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0BDL_SBR0            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR0
        #define SCI0BDL_SBR1            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR1
        #define SCI0BDL_SBR2            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR2
        #define SCI0BDL_SBR3            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR3
        #define SCI0BDL_SBR4            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR4
        #define SCI0BDL_SBR5            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR5
        #define SCI0BDL_SBR6            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR6
        #define SCI0BDL_SBR7            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR7
        
        #define SCI0BDL_SBR0_MASK       1U
        #define SCI0BDL_SBR1_MASK       2U
        #define SCI0BDL_SBR2_MASK       4U
        #define SCI0BDL_SBR3_MASK       8U
        #define SCI0BDL_SBR4_MASK       16U
        #define SCI0BDL_SBR5_MASK       32U
        #define SCI0BDL_SBR6_MASK       64U
        #define SCI0BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @(REG_BASE + 0x000000C8UL);
#define SCI0BD                          _SCI0BD.Word
#define SCI0BD_SBR0                     _SCI0BD.Bits.SBR0
#define SCI0BD_SBR1                     _SCI0BD.Bits.SBR1
#define SCI0BD_SBR2                     _SCI0BD.Bits.SBR2
#define SCI0BD_SBR3                     _SCI0BD.Bits.SBR3
#define SCI0BD_SBR4                     _SCI0BD.Bits.SBR4
#define SCI0BD_SBR5                     _SCI0BD.Bits.SBR5
#define SCI0BD_SBR6                     _SCI0BD.Bits.SBR6
#define SCI0BD_SBR7                     _SCI0BD.Bits.SBR7
#define SCI0BD_SBR8                     _SCI0BD.Bits.SBR8
#define SCI0BD_SBR9                     _SCI0BD.Bits.SBR9
#define SCI0BD_SBR10                    _SCI0BD.Bits.SBR10
#define SCI0BD_SBR11                    _SCI0BD.Bits.SBR11
#define SCI0BD_SBR12                    _SCI0BD.Bits.SBR12
#define SCI0BD_TNP0                     _SCI0BD.Bits.TNP0
#define SCI0BD_TNP1                     _SCI0BD.Bits.TNP1
#define SCI0BD_IREN                     _SCI0BD.Bits.IREN
#define SCI0BD_SBR                      _SCI0BD.MergedBits.grpSBR
#define SCI0BD_TNP                      _SCI0BD.MergedBits.grpTNP

#define SCI0BD_SBR0_MASK                1U
#define SCI0BD_SBR1_MASK                2U
#define SCI0BD_SBR2_MASK                4U
#define SCI0BD_SBR3_MASK                8U
#define SCI0BD_SBR4_MASK                16U
#define SCI0BD_SBR5_MASK                32U
#define SCI0BD_SBR6_MASK                64U
#define SCI0BD_SBR7_MASK                128U
#define SCI0BD_SBR8_MASK                256U
#define SCI0BD_SBR9_MASK                512U
#define SCI0BD_SBR10_MASK               1024U
#define SCI0BD_SBR11_MASK               2048U
#define SCI0BD_SBR12_MASK               4096U
#define SCI0BD_TNP0_MASK                8192U
#define SCI0BD_TNP1_MASK                16384U
#define SCI0BD_IREN_MASK                32768U
#define SCI0BD_SBR_MASK                 8191U
#define SCI0BD_SBR_BITNUM               0U
#define SCI0BD_TNP_MASK                 24576U
#define SCI0BD_TNP_BITNUM               13U


/*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI0ACR2 - SCI 0 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI0ACR2STR;
    #define SCI0ACR2                    _SCI0ACR2.Byte
    #define SCI0ACR2_BKDFE              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BKDFE
    #define SCI0ACR2_BERRM0             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM0
    #define SCI0ACR2_BERRM1             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM1
    #define SCI0ACR2_BERRM              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.MergedBits.grpBERRM
    
    #define SCI0ACR2_BKDFE_MASK         1U
    #define SCI0ACR2_BERRM0_MASK        2U
    #define SCI0ACR2_BERRM1_MASK        4U
    #define SCI0ACR2_BERRM_MASK         6U
    #define SCI0ACR2_BERRM_BITNUM       1U
    
    /*** SCI0CR1 - SCI 0 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI0CR1STR;
    #define SCI0CR1                     _SCI0ACR2.Byte
    #define SCI0CR1_PT                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PT
    #define SCI0CR1_PE                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PE
    #define SCI0CR1_ILT                 _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.ILT
    #define SCI0CR1_WAKE                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.WAKE
    #define SCI0CR1_M                   _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.M
    #define SCI0CR1_RSRC                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.RSRC
    #define SCI0CR1_SCISWAI             _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.SCISWAI
    #define SCI0CR1_LOOPS               _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.LOOPS
    
    #define SCI0CR1_PT_MASK             1U
    #define SCI0CR1_PE_MASK             2U
    #define SCI0CR1_ILT_MASK            4U
    #define SCI0CR1_WAKE_MASK           8U
    #define SCI0CR1_M_MASK              16U
    #define SCI0CR1_RSRC_MASK           32U
    #define SCI0CR1_SCISWAI_MASK        64U
    #define SCI0CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI0ACR2STR;
extern volatile SCI0ACR2STR _SCI0ACR2 @(REG_BASE + 0x000000CAUL);


/*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE         :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI0CR2STR;
extern volatile SCI0CR2STR _SCI0CR2 @(REG_BASE + 0x000000CBUL);
#define SCI0CR2                         _SCI0CR2.Byte
#define SCI0CR2_SBK                     _SCI0CR2.Bits.SBK
#define SCI0CR2_RWU                     _SCI0CR2.Bits.RWU
#define SCI0CR2_RE                      _SCI0CR2.Bits.RE
#define SCI0CR2_TE                      _SCI0CR2.Bits.TE
#define SCI0CR2_ILIE                    _SCI0CR2.Bits.ILIE
#define SCI0CR2_RIE                     _SCI0CR2.Bits.RIE
#define SCI0CR2_TCIE                    _SCI0CR2.Bits.TCIE
#define SCI0CR2_TIE                     _SCI0CR2.Bits.TIE

#define SCI0CR2_SBK_MASK                1U
#define SCI0CR2_RWU_MASK                2U
#define SCI0CR2_RE_MASK                 4U
#define SCI0CR2_TE_MASK                 8U
#define SCI0CR2_ILIE_MASK               16U
#define SCI0CR2_RIE_MASK                32U
#define SCI0CR2_TCIE_MASK               64U
#define SCI0CR2_TIE_MASK                128U


/*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0SR1STR;
extern volatile SCI0SR1STR _SCI0SR1 @(REG_BASE + 0x000000CCUL);
#define SCI0SR1                         _SCI0SR1.Byte
#define SCI0SR1_PF                      _SCI0SR1.Bits.PF
#define SCI0SR1_FE                      _SCI0SR1.Bits.FE
#define SCI0SR1_NF                      _SCI0SR1.Bits.NF
#define SCI0SR1_OR                      _SCI0SR1.Bits.OR
#define SCI0SR1_IDLE                    _SCI0SR1.Bits.IDLE
#define SCI0SR1_RDRF                    _SCI0SR1.Bits.RDRF
#define SCI0SR1_TC                      _SCI0SR1.Bits.TC
#define SCI0SR1_TDRE                    _SCI0SR1.Bits.TDRE

#define SCI0SR1_PF_MASK                 1U
#define SCI0SR1_FE_MASK                 2U
#define SCI0SR1_NF_MASK                 4U
#define SCI0SR1_OR_MASK                 8U
#define SCI0SR1_IDLE_MASK               16U
#define SCI0SR1_RDRF_MASK               32U
#define SCI0SR1_TC_MASK                 64U
#define SCI0SR1_TDRE_MASK               128U


/*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI0SR2STR;
extern volatile SCI0SR2STR _SCI0SR2 @(REG_BASE + 0x000000CDUL);
#define SCI0SR2                         _SCI0SR2.Byte
#define SCI0SR2_RAF                     _SCI0SR2.Bits.RAF
#define SCI0SR2_TXDIR                   _SCI0SR2.Bits.TXDIR
#define SCI0SR2_BRK13                   _SCI0SR2.Bits.BRK13
#define SCI0SR2_RXPOL                   _SCI0SR2.Bits.RXPOL
#define SCI0SR2_TXPOL                   _SCI0SR2.Bits.TXPOL
#define SCI0SR2_AMAP                    _SCI0SR2.Bits.AMAP

#define SCI0SR2_RAF_MASK                1U
#define SCI0SR2_TXDIR_MASK              2U
#define SCI0SR2_BRK13_MASK              4U
#define SCI0SR2_RXPOL_MASK              8U
#define SCI0SR2_TXPOL_MASK              16U
#define SCI0SR2_AMAP_MASK               128U


/*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI0DRHSTR;
extern volatile SCI0DRHSTR _SCI0DRH @(REG_BASE + 0x000000CEUL);
#define SCI0DRH                         _SCI0DRH.Byte
#define SCI0DRH_T8                      _SCI0DRH.Bits.T8
#define SCI0DRH_R8                      _SCI0DRH.Bits.R8

#define SCI0DRH_T8_MASK                 64U
#define SCI0DRH_R8_MASK                 128U


/*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI0DRLSTR;
extern volatile SCI0DRLSTR _SCI0DRL @(REG_BASE + 0x000000CFUL);
#define SCI0DRL                         _SCI0DRL.Byte
#define SCI0DRL_R0_T0                   _SCI0DRL.Bits.R0_T0
#define SCI0DRL_R1_T1                   _SCI0DRL.Bits.R1_T1
#define SCI0DRL_R2_T2                   _SCI0DRL.Bits.R2_T2
#define SCI0DRL_R3_T3                   _SCI0DRL.Bits.R3_T3
#define SCI0DRL_R4_T4                   _SCI0DRL.Bits.R4_T4
#define SCI0DRL_R5_T5                   _SCI0DRL.Bits.R5_T5
#define SCI0DRL_R6_T6                   _SCI0DRL.Bits.R6_T6
#define SCI0DRL_R7_T7                   _SCI0DRL.Bits.R7_T7

#define SCI0DRL_R0_T0_MASK              1U
#define SCI0DRL_R1_T1_MASK              2U
#define SCI0DRL_R2_T2_MASK              4U
#define SCI0DRL_R3_T3_MASK              8U
#define SCI0DRL_R4_T4_MASK              16U
#define SCI0DRL_R5_T5_MASK              32U
#define SCI0DRL_R6_T6_MASK              64U
#define SCI0DRL_R7_T7_MASK              128U


/*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI1ASR1STR;
        #define SCI1ASR1                _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1ASR1_BKDIF          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BKDIF
        #define SCI1ASR1_BERRIF         _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRIF
        #define SCI1ASR1_BERRV          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRV
        #define SCI1ASR1_RXEDGIF        _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.RXEDGIF
        
        #define SCI1ASR1_BKDIF_MASK     1U
        #define SCI1ASR1_BERRIF_MASK    2U
        #define SCI1ASR1_BERRV_MASK     4U
        #define SCI1ASR1_RXEDGIF_MASK   128U
        
        /*** SCI1BDH - SCI 1 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI1BDHSTR;
        #define SCI1BDH                 _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1BDH_SBR8            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR8
        #define SCI1BDH_SBR9            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR9
        #define SCI1BDH_SBR10           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR10
        #define SCI1BDH_SBR11           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR11
        #define SCI1BDH_SBR12           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR12
        #define SCI1BDH_TNP0            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP0
        #define SCI1BDH_TNP1            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP1
        #define SCI1BDH_IREN            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.IREN
        #define SCI1BDH_SBR_8           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpSBR_8
        #define SCI1BDH_TNP             _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpTNP
        #define SCI1BDH_SBR             SCI1BDH_SBR_8
        
        #define SCI1BDH_SBR8_MASK       1U
        #define SCI1BDH_SBR9_MASK       2U
        #define SCI1BDH_SBR10_MASK      4U
        #define SCI1BDH_SBR11_MASK      8U
        #define SCI1BDH_SBR12_MASK      16U
        #define SCI1BDH_TNP0_MASK       32U
        #define SCI1BDH_TNP1_MASK       64U
        #define SCI1BDH_IREN_MASK       128U
        #define SCI1BDH_SBR_8_MASK      31U
        #define SCI1BDH_SBR_8_BITNUM    0U
        #define SCI1BDH_TNP_MASK        96U
        #define SCI1BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ASR1STR;
    

    /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI1ACR1STR;
        #define SCI1ACR1                _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1ACR1_BKDIE          _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BKDIE
        #define SCI1ACR1_BERRIE         _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BERRIE
        #define SCI1ACR1_RXEDGIE        _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.RXEDGIE
        
        #define SCI1ACR1_BKDIE_MASK     1U
        #define SCI1ACR1_BERRIE_MASK    2U
        #define SCI1ACR1_RXEDGIE_MASK   128U
        
        /*** SCI1BDL - SCI 1 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI1BDLSTR;
        #define SCI1BDL                 _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1BDL_SBR0            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR0
        #define SCI1BDL_SBR1            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR1
        #define SCI1BDL_SBR2            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR2
        #define SCI1BDL_SBR3            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR3
        #define SCI1BDL_SBR4            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR4
        #define SCI1BDL_SBR5            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR5
        #define SCI1BDL_SBR6            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR6
        #define SCI1BDL_SBR7            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR7
        
        #define SCI1BDL_SBR0_MASK       1U
        #define SCI1BDL_SBR1_MASK       2U
        #define SCI1BDL_SBR2_MASK       4U
        #define SCI1BDL_SBR3_MASK       8U
        #define SCI1BDL_SBR4_MASK       16U
        #define SCI1BDL_SBR5_MASK       32U
        #define SCI1BDL_SBR6_MASK       64U
        #define SCI1BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI1BDSTR;
extern volatile SCI1BDSTR _SCI1BD @(REG_BASE + 0x000000D0UL);
#define SCI1BD                          _SCI1BD.Word
#define SCI1BD_SBR0                     _SCI1BD.Bits.SBR0
#define SCI1BD_SBR1                     _SCI1BD.Bits.SBR1
#define SCI1BD_SBR2                     _SCI1BD.Bits.SBR2
#define SCI1BD_SBR3                     _SCI1BD.Bits.SBR3
#define SCI1BD_SBR4                     _SCI1BD.Bits.SBR4
#define SCI1BD_SBR5                     _SCI1BD.Bits.SBR5
#define SCI1BD_SBR6                     _SCI1BD.Bits.SBR6
#define SCI1BD_SBR7                     _SCI1BD.Bits.SBR7
#define SCI1BD_SBR8                     _SCI1BD.Bits.SBR8
#define SCI1BD_SBR9                     _SCI1BD.Bits.SBR9
#define SCI1BD_SBR10                    _SCI1BD.Bits.SBR10
#define SCI1BD_SBR11                    _SCI1BD.Bits.SBR11
#define SCI1BD_SBR12                    _SCI1BD.Bits.SBR12
#define SCI1BD_TNP0                     _SCI1BD.Bits.TNP0
#define SCI1BD_TNP1                     _SCI1BD.Bits.TNP1
#define SCI1BD_IREN                     _SCI1BD.Bits.IREN
#define SCI1BD_SBR                      _SCI1BD.MergedBits.grpSBR
#define SCI1BD_TNP                      _SCI1BD.MergedBits.grpTNP

#define SCI1BD_SBR0_MASK                1U
#define SCI1BD_SBR1_MASK                2U
#define SCI1BD_SBR2_MASK                4U
#define SCI1BD_SBR3_MASK                8U
#define SCI1BD_SBR4_MASK                16U
#define SCI1BD_SBR5_MASK                32U
#define SCI1BD_SBR6_MASK                64U
#define SCI1BD_SBR7_MASK                128U
#define SCI1BD_SBR8_MASK                256U
#define SCI1BD_SBR9_MASK                512U
#define SCI1BD_SBR10_MASK               1024U
#define SCI1BD_SBR11_MASK               2048U
#define SCI1BD_SBR12_MASK               4096U
#define SCI1BD_TNP0_MASK                8192U
#define SCI1BD_TNP1_MASK                16384U
#define SCI1BD_IREN_MASK                32768U
#define SCI1BD_SBR_MASK                 8191U
#define SCI1BD_SBR_BITNUM               0U
#define SCI1BD_TNP_MASK                 24576U
#define SCI1BD_TNP_BITNUM               13U


/*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI1ACR2 - SCI 1 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI1ACR2STR;
    #define SCI1ACR2                    _SCI1ACR2.Byte
    #define SCI1ACR2_BKDFE              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BKDFE
    #define SCI1ACR2_BERRM0             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM0
    #define SCI1ACR2_BERRM1             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM1
    #define SCI1ACR2_BERRM              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.MergedBits.grpBERRM
    
    #define SCI1ACR2_BKDFE_MASK         1U
    #define SCI1ACR2_BERRM0_MASK        2U
    #define SCI1ACR2_BERRM1_MASK        4U
    #define SCI1ACR2_BERRM_MASK         6U
    #define SCI1ACR2_BERRM_BITNUM       1U
    
    /*** SCI1CR1 - SCI 1 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI1CR1STR;
    #define SCI1CR1                     _SCI1ACR2.Byte
    #define SCI1CR1_PT                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PT
    #define SCI1CR1_PE                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PE
    #define SCI1CR1_ILT                 _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.ILT
    #define SCI1CR1_WAKE                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.WAKE
    #define SCI1CR1_M                   _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.M
    #define SCI1CR1_RSRC                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.RSRC
    #define SCI1CR1_SCISWAI             _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.SCISWAI
    #define SCI1CR1_LOOPS               _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.LOOPS
    
    #define SCI1CR1_PT_MASK             1U
    #define SCI1CR1_PE_MASK             2U
    #define SCI1CR1_ILT_MASK            4U
    #define SCI1CR1_WAKE_MASK           8U
    #define SCI1CR1_M_MASK              16U
    #define SCI1CR1_RSRC_MASK           32U
    #define SCI1CR1_SCISWAI_MASK        64U
    #define SCI1CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI1ACR2STR;
extern volatile SCI1ACR2STR _SCI1ACR2 @(REG_BASE + 0x000000D2UL);


/*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE         :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI1CR2STR;
extern volatile SCI1CR2STR _SCI1CR2 @(REG_BASE + 0x000000D3UL);
#define SCI1CR2                         _SCI1CR2.Byte
#define SCI1CR2_SBK                     _SCI1CR2.Bits.SBK
#define SCI1CR2_RWU                     _SCI1CR2.Bits.RWU
#define SCI1CR2_RE                      _SCI1CR2.Bits.RE
#define SCI1CR2_TE                      _SCI1CR2.Bits.TE
#define SCI1CR2_ILIE                    _SCI1CR2.Bits.ILIE
#define SCI1CR2_RIE                     _SCI1CR2.Bits.RIE
#define SCI1CR2_TCIE                    _SCI1CR2.Bits.TCIE
#define SCI1CR2_TIE                     _SCI1CR2.Bits.TIE

#define SCI1CR2_SBK_MASK                1U
#define SCI1CR2_RWU_MASK                2U
#define SCI1CR2_RE_MASK                 4U
#define SCI1CR2_TE_MASK                 8U
#define SCI1CR2_ILIE_MASK               16U
#define SCI1CR2_RIE_MASK                32U
#define SCI1CR2_TCIE_MASK               64U
#define SCI1CR2_TIE_MASK                128U


/*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI1SR1STR;
extern volatile SCI1SR1STR _SCI1SR1 @(REG_BASE + 0x000000D4UL);
#define SCI1SR1                         _SCI1SR1.Byte
#define SCI1SR1_PF                      _SCI1SR1.Bits.PF
#define SCI1SR1_FE                      _SCI1SR1.Bits.FE
#define SCI1SR1_NF                      _SCI1SR1.Bits.NF
#define SCI1SR1_OR                      _SCI1SR1.Bits.OR
#define SCI1SR1_IDLE                    _SCI1SR1.Bits.IDLE
#define SCI1SR1_RDRF                    _SCI1SR1.Bits.RDRF
#define SCI1SR1_TC                      _SCI1SR1.Bits.TC
#define SCI1SR1_TDRE                    _SCI1SR1.Bits.TDRE

#define SCI1SR1_PF_MASK                 1U
#define SCI1SR1_FE_MASK                 2U
#define SCI1SR1_NF_MASK                 4U
#define SCI1SR1_OR_MASK                 8U
#define SCI1SR1_IDLE_MASK               16U
#define SCI1SR1_RDRF_MASK               32U
#define SCI1SR1_TC_MASK                 64U
#define SCI1SR1_TDRE_MASK               128U


/*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI1SR2STR;
extern volatile SCI1SR2STR _SCI1SR2 @(REG_BASE + 0x000000D5UL);
#define SCI1SR2                         _SCI1SR2.Byte
#define SCI1SR2_RAF                     _SCI1SR2.Bits.RAF
#define SCI1SR2_TXDIR                   _SCI1SR2.Bits.TXDIR
#define SCI1SR2_BRK13                   _SCI1SR2.Bits.BRK13
#define SCI1SR2_RXPOL                   _SCI1SR2.Bits.RXPOL
#define SCI1SR2_TXPOL                   _SCI1SR2.Bits.TXPOL
#define SCI1SR2_AMAP                    _SCI1SR2.Bits.AMAP

#define SCI1SR2_RAF_MASK                1U
#define SCI1SR2_TXDIR_MASK              2U
#define SCI1SR2_BRK13_MASK              4U
#define SCI1SR2_RXPOL_MASK              8U
#define SCI1SR2_TXPOL_MASK              16U
#define SCI1SR2_AMAP_MASK               128U


/*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI1DRHSTR;
extern volatile SCI1DRHSTR _SCI1DRH @(REG_BASE + 0x000000D6UL);
#define SCI1DRH                         _SCI1DRH.Byte
#define SCI1DRH_T8                      _SCI1DRH.Bits.T8
#define SCI1DRH_R8                      _SCI1DRH.Bits.R8

#define SCI1DRH_T8_MASK                 64U
#define SCI1DRH_R8_MASK                 128U


/*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI1DRLSTR;
extern volatile SCI1DRLSTR _SCI1DRL @(REG_BASE + 0x000000D7UL);
#define SCI1DRL                         _SCI1DRL.Byte
#define SCI1DRL_R0_T0                   _SCI1DRL.Bits.R0_T0
#define SCI1DRL_R1_T1                   _SCI1DRL.Bits.R1_T1
#define SCI1DRL_R2_T2                   _SCI1DRL.Bits.R2_T2
#define SCI1DRL_R3_T3                   _SCI1DRL.Bits.R3_T3
#define SCI1DRL_R4_T4                   _SCI1DRL.Bits.R4_T4
#define SCI1DRL_R5_T5                   _SCI1DRL.Bits.R5_T5
#define SCI1DRL_R6_T6                   _SCI1DRL.Bits.R6_T6
#define SCI1DRL_R7_T7                   _SCI1DRL.Bits.R7_T7

#define SCI1DRL_R0_T0_MASK              1U
#define SCI1DRL_R1_T1_MASK              2U
#define SCI1DRL_R2_T2_MASK              4U
#define SCI1DRL_R3_T3_MASK              8U
#define SCI1DRL_R4_T4_MASK              16U
#define SCI1DRL_R5_T5_MASK              32U
#define SCI1DRL_R6_T6_MASK              64U
#define SCI1DRL_R7_T7_MASK              128U


/*** SPICR1 - SPI  Control Register 1; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPICR1STR;
extern volatile SPICR1STR _SPICR1 @(REG_BASE + 0x000000D8UL);
#define SPICR1                          _SPICR1.Byte
#define SPICR1_LSBFE                    _SPICR1.Bits.LSBFE
#define SPICR1_SSOE                     _SPICR1.Bits.SSOE
#define SPICR1_CPHA                     _SPICR1.Bits.CPHA
#define SPICR1_CPOL                     _SPICR1.Bits.CPOL
#define SPICR1_MSTR                     _SPICR1.Bits.MSTR
#define SPICR1_SPTIE                    _SPICR1.Bits.SPTIE
#define SPICR1_SPE                      _SPICR1.Bits.SPE
#define SPICR1_SPIE                     _SPICR1.Bits.SPIE

#define SPICR1_LSBFE_MASK               1U
#define SPICR1_SSOE_MASK                2U
#define SPICR1_CPHA_MASK                4U
#define SPICR1_CPOL_MASK                8U
#define SPICR1_MSTR_MASK                16U
#define SPICR1_SPTIE_MASK               32U
#define SPICR1_SPE_MASK                 64U
#define SPICR1_SPIE_MASK                128U


/*** SPICR2 - SPI  Control Register 2; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte XFRW        :1;                                       /* Transfer Width */
    byte             :1; 
  } Bits;
} SPICR2STR;
extern volatile SPICR2STR _SPICR2 @(REG_BASE + 0x000000D9UL);
#define SPICR2                          _SPICR2.Byte
#define SPICR2_SPC0                     _SPICR2.Bits.SPC0
#define SPICR2_SPISWAI                  _SPICR2.Bits.SPISWAI
#define SPICR2_BIDIROE                  _SPICR2.Bits.BIDIROE
#define SPICR2_MODFEN                   _SPICR2.Bits.MODFEN
#define SPICR2_XFRW                     _SPICR2.Bits.XFRW

#define SPICR2_SPC0_MASK                1U
#define SPICR2_SPISWAI_MASK             2U
#define SPICR2_BIDIROE_MASK             8U
#define SPICR2_MODFEN_MASK              16U
#define SPICR2_XFRW_MASK                64U


/*** SPIBR - SPI  Baud Rate Register; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPIBRSTR;
extern volatile SPIBRSTR _SPIBR @(REG_BASE + 0x000000DAUL);
#define SPIBR                           _SPIBR.Byte
#define SPIBR_SPR0                      _SPIBR.Bits.SPR0
#define SPIBR_SPR1                      _SPIBR.Bits.SPR1
#define SPIBR_SPR2                      _SPIBR.Bits.SPR2
#define SPIBR_SPPR0                     _SPIBR.Bits.SPPR0
#define SPIBR_SPPR1                     _SPIBR.Bits.SPPR1
#define SPIBR_SPPR2                     _SPIBR.Bits.SPPR2
#define SPIBR_SPR                       _SPIBR.MergedBits.grpSPR
#define SPIBR_SPPR                      _SPIBR.MergedBits.grpSPPR

#define SPIBR_SPR0_MASK                 1U
#define SPIBR_SPR1_MASK                 2U
#define SPIBR_SPR2_MASK                 4U
#define SPIBR_SPPR0_MASK                16U
#define SPIBR_SPPR1_MASK                32U
#define SPIBR_SPPR2_MASK                64U
#define SPIBR_SPR_MASK                  7U
#define SPIBR_SPR_BITNUM                0U
#define SPIBR_SPPR_MASK                 112U
#define SPIBR_SPPR_BITNUM               4U


/*** SPISR - SPI  Status Register; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPISRSTR;
extern volatile SPISRSTR _SPISR @(REG_BASE + 0x000000DBUL);
#define SPISR                           _SPISR.Byte
#define SPISR_MODF                      _SPISR.Bits.MODF
#define SPISR_SPTEF                     _SPISR.Bits.SPTEF
#define SPISR_SPIF                      _SPISR.Bits.SPIF

#define SPISR_MODF_MASK                 16U
#define SPISR_SPTEF_MASK                32U
#define SPISR_SPIF_MASK                 128U


/*** SPIDR - SPI  Data Register; 0x000000DC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SPIDRH - SPI  Data Register High; 0x000000DC ***/
    union {
      byte Byte;
      struct {
        byte R8_T8       :1;                                       /* SPI  Data Bit 8 */
        byte R9_T9       :1;                                       /* SPI  Data Bit 9 */
        byte R10_T10     :1;                                       /* SPI  Data Bit 10 */
        byte R11_T11     :1;                                       /* SPI  Data Bit 11 */
        byte R12_T12     :1;                                       /* SPI  Data Bit 12 */
        byte R13_T13     :1;                                       /* SPI  Data Bit 13 */
        byte R14_T14     :1;                                       /* SPI  Data Bit 14 */
        byte R15_T15     :1;                                       /* SPI  Data Bit 15 */
      } Bits;
    } SPIDRHSTR;
    #define SPIDRH                      _SPIDR.Overlap_STR.SPIDRHSTR.Byte
    #define SPIDRH_R8_T8                _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R8_T8
    #define SPIDRH_R9_T9                _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R9_T9
    #define SPIDRH_R10_T10              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R10_T10
    #define SPIDRH_R11_T11              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R11_T11
    #define SPIDRH_R12_T12              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R12_T12
    #define SPIDRH_R13_T13              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R13_T13
    #define SPIDRH_R14_T14              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R14_T14
    #define SPIDRH_R15_T15              _SPIDR.Overlap_STR.SPIDRHSTR.Bits.R15_T15
    
    #define SPIDRH_R8_T8_MASK           1U
    #define SPIDRH_R9_T9_MASK           2U
    #define SPIDRH_R10_T10_MASK         4U
    #define SPIDRH_R11_T11_MASK         8U
    #define SPIDRH_R12_T12_MASK         16U
    #define SPIDRH_R13_T13_MASK         32U
    #define SPIDRH_R14_T14_MASK         64U
    #define SPIDRH_R15_T15_MASK         128U
    

    /*** SPIDRL - SPI  Data Register Low; 0x000000DD ***/
    union {
      byte Byte;
      struct {
        byte R0_T0       :1;                                       /* SPI  Data Bit 0 */
        byte R1_T1       :1;                                       /* SPI  Data Bit 1 */
        byte R2_T2       :1;                                       /* SPI  Data Bit 2 */
        byte R3_T3       :1;                                       /* SPI  Data Bit 3 */
        byte R4_T4       :1;                                       /* SPI  Data Bit 4 */
        byte R5_T5       :1;                                       /* SPI  Data Bit 5 */
        byte R6_T6       :1;                                       /* SPI  Data Bit 6 */
        byte R7_T7       :1;                                       /* SPI  Data Bit 7 */
      } Bits;
    } SPIDRLSTR;
    #define SPIDRL                      _SPIDR.Overlap_STR.SPIDRLSTR.Byte
    #define SPIDRL_R0_T0                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R0_T0
    #define SPIDRL_R1_T1                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R1_T1
    #define SPIDRL_R2_T2                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R2_T2
    #define SPIDRL_R3_T3                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R3_T3
    #define SPIDRL_R4_T4                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R4_T4
    #define SPIDRL_R5_T5                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R5_T5
    #define SPIDRL_R6_T6                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R6_T6
    #define SPIDRL_R7_T7                _SPIDR.Overlap_STR.SPIDRLSTR.Bits.R7_T7
    
    #define SPIDRL_R0_T0_MASK           1U
    #define SPIDRL_R1_T1_MASK           2U
    #define SPIDRL_R2_T2_MASK           4U
    #define SPIDRL_R3_T3_MASK           8U
    #define SPIDRL_R4_T4_MASK           16U
    #define SPIDRL_R5_T5_MASK           32U
    #define SPIDRL_R6_T6_MASK           64U
    #define SPIDRL_R7_T7_MASK           128U
    
  } Overlap_STR;

  struct {
    word R0_T0       :1;                                       /* SPI  Data Bit 0 */
    word R1_T1       :1;                                       /* SPI  Data Bit 1 */
    word R2_T2       :1;                                       /* SPI  Data Bit 2 */
    word R3_T3       :1;                                       /* SPI  Data Bit 3 */
    word R4_T4       :1;                                       /* SPI  Data Bit 4 */
    word R5_T5       :1;                                       /* SPI  Data Bit 5 */
    word R6_T6       :1;                                       /* SPI  Data Bit 6 */
    word R7_T7       :1;                                       /* SPI  Data Bit 7 */
    word R8_T8       :1;                                       /* SPI  Data Bit 8 */
    word R9_T9       :1;                                       /* SPI  Data Bit 9 */
    word R10_T10     :1;                                       /* SPI  Data Bit 10 */
    word R11_T11     :1;                                       /* SPI  Data Bit 11 */
    word R12_T12     :1;                                       /* SPI  Data Bit 12 */
    word R13_T13     :1;                                       /* SPI  Data Bit 13 */
    word R14_T14     :1;                                       /* SPI  Data Bit 14 */
    word R15_T15     :1;                                       /* SPI  Data Bit 15 */
  } Bits;
} SPIDRSTR;
extern volatile SPIDRSTR _SPIDR @(REG_BASE + 0x000000DCUL);
#define SPIDR                           _SPIDR.Word
#define SPIDR_R0_T0                     _SPIDR.Bits.R0_T0
#define SPIDR_R1_T1                     _SPIDR.Bits.R1_T1
#define SPIDR_R2_T2                     _SPIDR.Bits.R2_T2
#define SPIDR_R3_T3                     _SPIDR.Bits.R3_T3
#define SPIDR_R4_T4                     _SPIDR.Bits.R4_T4
#define SPIDR_R5_T5                     _SPIDR.Bits.R5_T5
#define SPIDR_R6_T6                     _SPIDR.Bits.R6_T6
#define SPIDR_R7_T7                     _SPIDR.Bits.R7_T7
#define SPIDR_R8_T8                     _SPIDR.Bits.R8_T8
#define SPIDR_R9_T9                     _SPIDR.Bits.R9_T9
#define SPIDR_R10_T10                   _SPIDR.Bits.R10_T10
#define SPIDR_R11_T11                   _SPIDR.Bits.R11_T11
#define SPIDR_R12_T12                   _SPIDR.Bits.R12_T12
#define SPIDR_R13_T13                   _SPIDR.Bits.R13_T13
#define SPIDR_R14_T14                   _SPIDR.Bits.R14_T14
#define SPIDR_R15_T15                   _SPIDR.Bits.R15_T15

#define SPIDR_R0_T0_MASK                1U
#define SPIDR_R1_T1_MASK                2U
#define SPIDR_R2_T2_MASK                4U
#define SPIDR_R3_T3_MASK                8U
#define SPIDR_R4_T4_MASK                16U
#define SPIDR_R5_T5_MASK                32U
#define SPIDR_R6_T6_MASK                64U
#define SPIDR_R7_T7_MASK                128U
#define SPIDR_R8_T8_MASK                256U
#define SPIDR_R9_T9_MASK                512U
#define SPIDR_R10_T10_MASK              1024U
#define SPIDR_R11_T11_MASK              2048U
#define SPIDR_R12_T12_MASK              4096U
#define SPIDR_R13_T13_MASK              8192U
#define SPIDR_R14_T14_MASK              16384U
#define SPIDR_R15_T15_MASK              32768U


/*** IIC_IBAD - IIC Address Register; 0x000000E0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IIC_IBADSTR;
extern volatile IIC_IBADSTR _IIC_IBAD @(REG_BASE + 0x000000E0UL);
#define IIC_IBAD                        _IIC_IBAD.Byte
#define IIC_IBAD_ADR1                   _IIC_IBAD.Bits.ADR1
#define IIC_IBAD_ADR2                   _IIC_IBAD.Bits.ADR2
#define IIC_IBAD_ADR3                   _IIC_IBAD.Bits.ADR3
#define IIC_IBAD_ADR4                   _IIC_IBAD.Bits.ADR4
#define IIC_IBAD_ADR5                   _IIC_IBAD.Bits.ADR5
#define IIC_IBAD_ADR6                   _IIC_IBAD.Bits.ADR6
#define IIC_IBAD_ADR7                   _IIC_IBAD.Bits.ADR7
#define IIC_IBAD_ADR_1                  _IIC_IBAD.MergedBits.grpADR_1
#define IIC_IBAD_ADR                    IIC_IBAD_ADR_1

#define IIC_IBAD_ADR1_MASK              2U
#define IIC_IBAD_ADR2_MASK              4U
#define IIC_IBAD_ADR3_MASK              8U
#define IIC_IBAD_ADR4_MASK              16U
#define IIC_IBAD_ADR5_MASK              32U
#define IIC_IBAD_ADR6_MASK              64U
#define IIC_IBAD_ADR7_MASK              128U
#define IIC_IBAD_ADR_1_MASK             254U
#define IIC_IBAD_ADR_1_BITNUM           1U


/*** IIC_IBFD - IIC Frequency Divider Register; 0x000000E1 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IIC_IBFDSTR;
extern volatile IIC_IBFDSTR _IIC_IBFD @(REG_BASE + 0x000000E1UL);
#define IIC_IBFD                        _IIC_IBFD.Byte
#define IIC_IBFD_IBC0                   _IIC_IBFD.Bits.IBC0
#define IIC_IBFD_IBC1                   _IIC_IBFD.Bits.IBC1
#define IIC_IBFD_IBC2                   _IIC_IBFD.Bits.IBC2
#define IIC_IBFD_IBC3                   _IIC_IBFD.Bits.IBC3
#define IIC_IBFD_IBC4                   _IIC_IBFD.Bits.IBC4
#define IIC_IBFD_IBC5                   _IIC_IBFD.Bits.IBC5
#define IIC_IBFD_IBC6                   _IIC_IBFD.Bits.IBC6
#define IIC_IBFD_IBC7                   _IIC_IBFD.Bits.IBC7

#define IIC_IBFD_IBC0_MASK              1U
#define IIC_IBFD_IBC1_MASK              2U
#define IIC_IBFD_IBC2_MASK              4U
#define IIC_IBFD_IBC3_MASK              8U
#define IIC_IBFD_IBC4_MASK              16U
#define IIC_IBFD_IBC5_MASK              32U
#define IIC_IBFD_IBC6_MASK              64U
#define IIC_IBFD_IBC7_MASK              128U


/*** IIC_IBCR - IIC Control Register; 0x000000E2 ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IIC_IBCRSTR;
extern volatile IIC_IBCRSTR _IIC_IBCR @(REG_BASE + 0x000000E2UL);
#define IIC_IBCR                        _IIC_IBCR.Byte
#define IIC_IBCR_IBSWAI                 _IIC_IBCR.Bits.IBSWAI
#define IIC_IBCR_RSTA                   _IIC_IBCR.Bits.RSTA
#define IIC_IBCR_TXAK                   _IIC_IBCR.Bits.TXAK
#define IIC_IBCR_TX_RX                  _IIC_IBCR.Bits.TX_RX
#define IIC_IBCR_MS_SL                  _IIC_IBCR.Bits.MS_SL
#define IIC_IBCR_IBIE                   _IIC_IBCR.Bits.IBIE
#define IIC_IBCR_IBEN                   _IIC_IBCR.Bits.IBEN

#define IIC_IBCR_IBSWAI_MASK            1U
#define IIC_IBCR_RSTA_MASK              4U
#define IIC_IBCR_TXAK_MASK              8U
#define IIC_IBCR_TX_RX_MASK             16U
#define IIC_IBCR_MS_SL_MASK             32U
#define IIC_IBCR_IBIE_MASK              64U
#define IIC_IBCR_IBEN_MASK              128U


/*** IIC_IBSR - IIC Status Register; 0x000000E3 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IIC_IBSRSTR;
extern volatile IIC_IBSRSTR _IIC_IBSR @(REG_BASE + 0x000000E3UL);
#define IIC_IBSR                        _IIC_IBSR.Byte
#define IIC_IBSR_RXAK                   _IIC_IBSR.Bits.RXAK
#define IIC_IBSR_IBIF                   _IIC_IBSR.Bits.IBIF
#define IIC_IBSR_SRW                    _IIC_IBSR.Bits.SRW
#define IIC_IBSR_IBAL                   _IIC_IBSR.Bits.IBAL
#define IIC_IBSR_IBB                    _IIC_IBSR.Bits.IBB
#define IIC_IBSR_IAAS                   _IIC_IBSR.Bits.IAAS
#define IIC_IBSR_TCF                    _IIC_IBSR.Bits.TCF

#define IIC_IBSR_RXAK_MASK              1U
#define IIC_IBSR_IBIF_MASK              2U
#define IIC_IBSR_SRW_MASK               4U
#define IIC_IBSR_IBAL_MASK              16U
#define IIC_IBSR_IBB_MASK               32U
#define IIC_IBSR_IAAS_MASK              64U
#define IIC_IBSR_TCF_MASK               128U


/*** IIC_IBDR - IIC Data I/O Register; 0x000000E4 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IIC_IBDRSTR;
extern volatile IIC_IBDRSTR _IIC_IBDR @(REG_BASE + 0x000000E4UL);
#define IIC_IBDR                        _IIC_IBDR.Byte
#define IIC_IBDR_D0                     _IIC_IBDR.Bits.D0
#define IIC_IBDR_D1                     _IIC_IBDR.Bits.D1
#define IIC_IBDR_D2                     _IIC_IBDR.Bits.D2
#define IIC_IBDR_D3                     _IIC_IBDR.Bits.D3
#define IIC_IBDR_D4                     _IIC_IBDR.Bits.D4
#define IIC_IBDR_D5                     _IIC_IBDR.Bits.D5
#define IIC_IBDR_D6                     _IIC_IBDR.Bits.D6
#define IIC_IBDR_D7                     _IIC_IBDR.Bits.D7

#define IIC_IBDR_D0_MASK                1U
#define IIC_IBDR_D1_MASK                2U
#define IIC_IBDR_D2_MASK                4U
#define IIC_IBDR_D3_MASK                8U
#define IIC_IBDR_D4_MASK                16U
#define IIC_IBDR_D5_MASK                32U
#define IIC_IBDR_D6_MASK                64U
#define IIC_IBDR_D7_MASK                128U


/*** IIC_IBCR2 - IIC Control Register 2; 0x000000E5 ***/
typedef union {
  byte Byte;
  struct {
    byte ADR8        :1;                                       /* Slave Address Bit 8 */
    byte ADR9        :1;                                       /* Slave Address Bit 9 */
    byte ADR10       :1;                                       /* Slave Address Bit 10 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte ADTYPE      :1;                                       /* Address Type */
    byte GCEN        :1;                                       /* General Call Enable */
  } Bits;
  struct {
    byte grpADR_8 :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IIC_IBCR2STR;
extern volatile IIC_IBCR2STR _IIC_IBCR2 @(REG_BASE + 0x000000E5UL);
#define IIC_IBCR2                       _IIC_IBCR2.Byte
#define IIC_IBCR2_ADR8                  _IIC_IBCR2.Bits.ADR8
#define IIC_IBCR2_ADR9                  _IIC_IBCR2.Bits.ADR9
#define IIC_IBCR2_ADR10                 _IIC_IBCR2.Bits.ADR10
#define IIC_IBCR2_ADTYPE                _IIC_IBCR2.Bits.ADTYPE
#define IIC_IBCR2_GCEN                  _IIC_IBCR2.Bits.GCEN
#define IIC_IBCR2_ADR_8                 _IIC_IBCR2.MergedBits.grpADR_8
#define IIC_IBCR2_ADR                   IIC_IBCR2_ADR_8

#define IIC_IBCR2_ADR8_MASK             1U
#define IIC_IBCR2_ADR9_MASK             2U
#define IIC_IBCR2_ADR10_MASK            4U
#define IIC_IBCR2_ADTYPE_MASK           64U
#define IIC_IBCR2_GCEN_MASK             128U
#define IIC_IBCR2_ADR_8_MASK            7U
#define IIC_IBCR2_ADR_8_BITNUM          0U


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Clock Divider Bit 5 */
    byte FDIV6       :1;                                       /* Clock Divider Bit 6 */
    byte FDIVLD      :1;                                       /* Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :7;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_FDIV6                   _FCLKDIV.Bits.FDIV6
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_FDIV6_MASK              64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               127U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte RNV2        :1;                                       /* Reserved Nonvolatile Bit 2 */
    byte RNV3        :1;                                       /* Reserved Nonvolatile Bit 3 */
    byte RNV4        :1;                                       /* Reserved Nonvolatile Bit 4 */
    byte RNV5        :1;                                       /* Reserved Nonvolatile Bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_RNV2                       _FSEC.Bits.RNV2
#define FSEC_RNV3                       _FSEC.Bits.RNV3
#define FSEC_RNV4                       _FSEC.Bits.RNV4
#define FSEC_RNV5                       _FSEC.Bits.RNV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_RNV_2                      _FSEC.MergedBits.grpRNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_RNV                        FSEC_RNV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_RNV2_MASK                  4U
#define FSEC_RNV3_MASK                  8U
#define FSEC_RNV4_MASK                  16U
#define FSEC_RNV5_MASK                  32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_RNV_2_MASK                 60U
#define FSEC_RNV_2_BITNUM               2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***/
typedef union {
  byte Byte;
  struct {
    byte CCOBIX0     :1;                                       /* Common Command Register Index Bit 0 */
    byte CCOBIX1     :1;                                       /* Common Command Register Index Bit 1 */
    byte CCOBIX2     :1;                                       /* Common Command Register Index Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCCOBIX :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCCOBIXSTR;
extern volatile FCCOBIXSTR _FCCOBIX @(REG_BASE + 0x00000102UL);
#define FCCOBIX                         _FCCOBIX.Byte
#define FCCOBIX_CCOBIX0                 _FCCOBIX.Bits.CCOBIX0
#define FCCOBIX_CCOBIX1                 _FCCOBIX.Bits.CCOBIX1
#define FCCOBIX_CCOBIX2                 _FCCOBIX.Bits.CCOBIX2
#define FCCOBIX_CCOBIX                  _FCCOBIX.MergedBits.grpCCOBIX

#define FCCOBIX_CCOBIX0_MASK            1U
#define FCCOBIX_CCOBIX1_MASK            2U
#define FCCOBIX_CCOBIX2_MASK            4U
#define FCCOBIX_CCOBIX_MASK             7U
#define FCCOBIX_CCOBIX_BITNUM           0U


/*** FECCRIX - Flash ECCR Index Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte ECCRIX0     :1;                                       /* ECC Error Register Index Bit 0 */
    byte ECCRIX1     :1;                                       /* ECC Error Register Index Bit 1 */
    byte ECCRIX2     :1;                                       /* ECC Error Register Index Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpECCRIX :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FECCRIXSTR;
extern volatile FECCRIXSTR _FECCRIX @(REG_BASE + 0x00000103UL);
#define FECCRIX                         _FECCRIX.Byte
#define FECCRIX_ECCRIX0                 _FECCRIX.Bits.ECCRIX0
#define FECCRIX_ECCRIX1                 _FECCRIX.Bits.ECCRIX1
#define FECCRIX_ECCRIX2                 _FECCRIX.Bits.ECCRIX2
#define FECCRIX_ECCRIX                  _FECCRIX.MergedBits.grpECCRIX

#define FECCRIX_ECCRIX0_MASK            1U
#define FECCRIX_ECCRIX1_MASK            2U
#define FECCRIX_ECCRIX2_MASK            4U
#define FECCRIX_ECCRIX_MASK             7U
#define FECCRIX_ECCRIX_BITNUM           0U


/*** FCNFG - Flash Configuration Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FSFD        :1;                                       /* Force Single Bit Fault Detect */
    byte FDFD        :1;                                       /* Force Double Bit Fault Detect */
    byte             :1; 
    byte             :1; 
    byte IGNSF       :1;                                       /* Ignore Single Bit Fault */
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000104UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_FSFD                      _FCNFG.Bits.FSFD
#define FCNFG_FDFD                      _FCNFG.Bits.FDFD
#define FCNFG_IGNSF                     _FCNFG.Bits.IGNSF
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE

#define FCNFG_FSFD_MASK                 1U
#define FCNFG_FDFD_MASK                 2U
#define FCNFG_IGNSF_MASK                16U
#define FCNFG_CCIE_MASK                 128U


/*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte SFDIE       :1;                                       /* Single Bit Fault Detect Interrupt Enable */
    byte DFDIE       :1;                                       /* Double Bit Fault Detect Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} FERCNFGSTR;
extern volatile FERCNFGSTR _FERCNFG @(REG_BASE + 0x00000105UL);
#define FERCNFG                         _FERCNFG.Byte
#define FERCNFG_SFDIE                   _FERCNFG.Bits.SFDIE
#define FERCNFG_DFDIE                   _FERCNFG.Bits.DFDIE

#define FERCNFG_SFDIE_MASK              1U
#define FERCNFG_DFDIE_MASK              2U


/*** FSTAT - Flash Status Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte MGSTAT0     :1;                                       /* Memory Controller Command Completion Status Flag 0 */
    byte MGSTAT1     :1;                                       /* Memory Controller Command Completion Status Flag 1 */
    byte             :1; 
    byte MGBUSY      :1;                                       /* Memory Controller Busy Flag */
    byte FPVIOL      :1;                                       /* Flash Protection Violation Flag */
    byte ACCERR      :1;                                       /* Flash Access Error Flag */
    byte             :1; 
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
  } Bits;
  struct {
    byte grpMGSTAT :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000106UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_MGSTAT0                   _FSTAT.Bits.MGSTAT0
#define FSTAT_MGSTAT1                   _FSTAT.Bits.MGSTAT1
#define FSTAT_MGBUSY                    _FSTAT.Bits.MGBUSY
#define FSTAT_FPVIOL                    _FSTAT.Bits.FPVIOL
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_MGSTAT                    _FSTAT.MergedBits.grpMGSTAT

#define FSTAT_MGSTAT0_MASK              1U
#define FSTAT_MGSTAT1_MASK              2U
#define FSTAT_MGBUSY_MASK               8U
#define FSTAT_FPVIOL_MASK               16U
#define FSTAT_ACCERR_MASK               32U
#define FSTAT_CCIF_MASK                 128U
#define FSTAT_MGSTAT_MASK               3U
#define FSTAT_MGSTAT_BITNUM             0U


/*** FERSTAT - Flash Error Status Register; 0x00000107 ***/
typedef union {
  byte Byte;
  struct {
    byte SFDIF       :1;                                       /* Single Bit Fault Detect Interrupt Flag */
    byte DFDIF       :1;                                       /* Double Bit Fault Detect Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} FERSTATSTR;
extern volatile FERSTATSTR _FERSTAT @(REG_BASE + 0x00000107UL);
#define FERSTAT                         _FERSTAT.Byte
#define FERSTAT_SFDIF                   _FERSTAT.Bits.SFDIF
#define FERSTAT_DFDIF                   _FERSTAT.Bits.DFDIF

#define FERSTAT_SFDIF_MASK              1U
#define FERSTAT_DFDIF_MASK              2U


/*** FPROT - P-Flash Protection Register; 0x00000108 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address Size Bit 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address Size Bit 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower Address Range Disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher Address Size Bit 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher Address Size Bit 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher Address Range Disable */
    byte RNV6        :1;                                       /* Reserved Nonvolatile Bit */
    byte FPOPEN      :1;                                       /* Flash Protection Operation Enable */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000108UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_RNV6                      _FPROT.Bits.RNV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_RNV6_MASK                 64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** DFPROT - D-Flash Protection Register; 0x00000109 ***/
typedef union {
  byte Byte;
  struct {
    byte DPS0        :1;                                       /* D-Flash Protection Size Bit 0 */
    byte DPS1        :1;                                       /* D-Flash Protection Size Bit 1 */
    byte DPS2        :1;                                       /* D-Flash Protection Size Bit 2 */
    byte DPS3        :1;                                       /* D-Flash Protection Size Bit 3 */
    byte DPS4        :1;                                       /* D-Flash Protection Size Bit 4 */
    byte             :1; 
    byte             :1; 
    byte DPOPEN      :1;                                       /* D-Flash Protection Control */
  } Bits;
  struct {
    byte grpDPS  :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DFPROTSTR;
extern volatile DFPROTSTR _DFPROT @(REG_BASE + 0x00000109UL);
#define DFPROT                          _DFPROT.Byte
#define DFPROT_DPS0                     _DFPROT.Bits.DPS0
#define DFPROT_DPS1                     _DFPROT.Bits.DPS1
#define DFPROT_DPS2                     _DFPROT.Bits.DPS2
#define DFPROT_DPS3                     _DFPROT.Bits.DPS3
#define DFPROT_DPS4                     _DFPROT.Bits.DPS4
#define DFPROT_DPOPEN                   _DFPROT.Bits.DPOPEN
#define DFPROT_DPS                      _DFPROT.MergedBits.grpDPS

#define DFPROT_DPS0_MASK                1U
#define DFPROT_DPS1_MASK                2U
#define DFPROT_DPS2_MASK                4U
#define DFPROT_DPS3_MASK                8U
#define DFPROT_DPS4_MASK                16U
#define DFPROT_DPOPEN_MASK              128U
#define DFPROT_DPS_MASK                 31U
#define DFPROT_DPS_BITNUM               0U


/*** FCCOB - Flash Common Command Object Register; 0x0000010A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***/
    union {
      byte Byte;
      struct {
        byte CCOB8       :1;                                       /* Flash Common Command Object Bit 8 */
        byte CCOB9       :1;                                       /* Flash Common Command Object Bit 9 */
        byte CCOB10      :1;                                       /* Flash Common Command Object Bit 10 */
        byte CCOB11      :1;                                       /* Flash Common Command Object Bit 11 */
        byte CCOB12      :1;                                       /* Flash Common Command Object Bit 12 */
        byte CCOB13      :1;                                       /* Flash Common Command Object Bit 13 */
        byte CCOB14      :1;                                       /* Flash Common Command Object Bit 14 */
        byte CCOB15      :1;                                       /* Flash Common Command Object Bit 15 */
      } Bits;
    } FCCOBHISTR;
    #define FCCOBHI                     _FCCOB.Overlap_STR.FCCOBHISTR.Byte
    #define FCCOBHI_CCOB8               _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB8
    #define FCCOBHI_CCOB9               _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB9
    #define FCCOBHI_CCOB10              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB10
    #define FCCOBHI_CCOB11              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB11
    #define FCCOBHI_CCOB12              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB12
    #define FCCOBHI_CCOB13              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB13
    #define FCCOBHI_CCOB14              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB14
    #define FCCOBHI_CCOB15              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB15
    
    #define FCCOBHI_CCOB8_MASK          1U
    #define FCCOBHI_CCOB9_MASK          2U
    #define FCCOBHI_CCOB10_MASK         4U
    #define FCCOBHI_CCOB11_MASK         8U
    #define FCCOBHI_CCOB12_MASK         16U
    #define FCCOBHI_CCOB13_MASK         32U
    #define FCCOBHI_CCOB14_MASK         64U
    #define FCCOBHI_CCOB15_MASK         128U
    

    /*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***/
    union {
      byte Byte;
      struct {
        byte CCOB0       :1;                                       /* Flash Common Command Object Bit 0 */
        byte CCOB1       :1;                                       /* Flash Common Command Object Bit 1 */
        byte CCOB2       :1;                                       /* Flash Common Command Object Bit 2 */
        byte CCOB3       :1;                                       /* Flash Common Command Object Bit 3 */
        byte CCOB4       :1;                                       /* Flash Common Command Object Bit 4 */
        byte CCOB5       :1;                                       /* Flash Common Command Object Bit 5 */
        byte CCOB6       :1;                                       /* Flash Common Command Object Bit 6 */
        byte CCOB7       :1;                                       /* Flash Common Command Object Bit 7 */
      } Bits;
    } FCCOBLOSTR;
    #define FCCOBLO                     _FCCOB.Overlap_STR.FCCOBLOSTR.Byte
    #define FCCOBLO_CCOB0               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB0
    #define FCCOBLO_CCOB1               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB1
    #define FCCOBLO_CCOB2               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB2
    #define FCCOBLO_CCOB3               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB3
    #define FCCOBLO_CCOB4               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB4
    #define FCCOBLO_CCOB5               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB5
    #define FCCOBLO_CCOB6               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB6
    #define FCCOBLO_CCOB7               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB7
    
    #define FCCOBLO_CCOB0_MASK          1U
    #define FCCOBLO_CCOB1_MASK          2U
    #define FCCOBLO_CCOB2_MASK          4U
    #define FCCOBLO_CCOB3_MASK          8U
    #define FCCOBLO_CCOB4_MASK          16U
    #define FCCOBLO_CCOB5_MASK          32U
    #define FCCOBLO_CCOB6_MASK          64U
    #define FCCOBLO_CCOB7_MASK          128U
    
  } Overlap_STR;

  struct {
    word CCOB0       :1;                                       /* Flash Common Command Object Bit 0 */
    word CCOB1       :1;                                       /* Flash Common Command Object Bit 1 */
    word CCOB2       :1;                                       /* Flash Common Command Object Bit 2 */
    word CCOB3       :1;                                       /* Flash Common Command Object Bit 3 */
    word CCOB4       :1;                                       /* Flash Common Command Object Bit 4 */
    word CCOB5       :1;                                       /* Flash Common Command Object Bit 5 */
    word CCOB6       :1;                                       /* Flash Common Command Object Bit 6 */
    word CCOB7       :1;                                       /* Flash Common Command Object Bit 7 */
    word CCOB8       :1;                                       /* Flash Common Command Object Bit 8 */
    word CCOB9       :1;                                       /* Flash Common Command Object Bit 9 */
    word CCOB10      :1;                                       /* Flash Common Command Object Bit 10 */
    word CCOB11      :1;                                       /* Flash Common Command Object Bit 11 */
    word CCOB12      :1;                                       /* Flash Common Command Object Bit 12 */
    word CCOB13      :1;                                       /* Flash Common Command Object Bit 13 */
    word CCOB14      :1;                                       /* Flash Common Command Object Bit 14 */
    word CCOB15      :1;                                       /* Flash Common Command Object Bit 15 */
  } Bits;
} FCCOBSTR;
extern volatile FCCOBSTR _FCCOB @(REG_BASE + 0x0000010AUL);
#define FCCOB                           _FCCOB.Word
#define FCCOB_CCOB0                     _FCCOB.Bits.CCOB0
#define FCCOB_CCOB1                     _FCCOB.Bits.CCOB1
#define FCCOB_CCOB2                     _FCCOB.Bits.CCOB2
#define FCCOB_CCOB3                     _FCCOB.Bits.CCOB3
#define FCCOB_CCOB4                     _FCCOB.Bits.CCOB4
#define FCCOB_CCOB5                     _FCCOB.Bits.CCOB5
#define FCCOB_CCOB6                     _FCCOB.Bits.CCOB6
#define FCCOB_CCOB7                     _FCCOB.Bits.CCOB7
#define FCCOB_CCOB8                     _FCCOB.Bits.CCOB8
#define FCCOB_CCOB9                     _FCCOB.Bits.CCOB9
#define FCCOB_CCOB10                    _FCCOB.Bits.CCOB10
#define FCCOB_CCOB11                    _FCCOB.Bits.CCOB11
#define FCCOB_CCOB12                    _FCCOB.Bits.CCOB12
#define FCCOB_CCOB13                    _FCCOB.Bits.CCOB13
#define FCCOB_CCOB14                    _FCCOB.Bits.CCOB14
#define FCCOB_CCOB15                    _FCCOB.Bits.CCOB15

#define FCCOB_CCOB0_MASK                1U
#define FCCOB_CCOB1_MASK                2U
#define FCCOB_CCOB2_MASK                4U
#define FCCOB_CCOB3_MASK                8U
#define FCCOB_CCOB4_MASK                16U
#define FCCOB_CCOB5_MASK                32U
#define FCCOB_CCOB6_MASK                64U
#define FCCOB_CCOB7_MASK                128U
#define FCCOB_CCOB8_MASK                256U
#define FCCOB_CCOB9_MASK                512U
#define FCCOB_CCOB10_MASK               1024U
#define FCCOB_CCOB11_MASK               2048U
#define FCCOB_CCOB12_MASK               4096U
#define FCCOB_CCOB13_MASK               8192U
#define FCCOB_CCOB14_MASK               16384U
#define FCCOB_CCOB15_MASK               32768U


/*** FECCR - Flash ECC Error Results Register; 0x0000010E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FECCRHI - Flash ECC Error Results Register High; 0x0000010E ***/
    union {
      byte Byte;
      struct {
        byte ECCR8       :1;                                       /* Flash ECC Error Result Bit 8 */
        byte ECCR9       :1;                                       /* Flash ECC Error Result Bit 9 */
        byte ECCR10      :1;                                       /* Flash ECC Error Result Bit 10 */
        byte ECCR11      :1;                                       /* Flash ECC Error Result Bit 11 */
        byte ECCR12      :1;                                       /* Flash ECC Error Result Bit 12 */
        byte ECCR13      :1;                                       /* Flash ECC Error Result Bit 13 */
        byte ECCR14      :1;                                       /* Flash ECC Error Result Bit 14 */
        byte ECCR15      :1;                                       /* Flash ECC Error Result Bit 15 */
      } Bits;
    } FECCRHISTR;
    #define FECCRHI                     _FECCR.Overlap_STR.FECCRHISTR.Byte
    #define FECCRHI_ECCR8               _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR8
    #define FECCRHI_ECCR9               _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR9
    #define FECCRHI_ECCR10              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR10
    #define FECCRHI_ECCR11              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR11
    #define FECCRHI_ECCR12              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR12
    #define FECCRHI_ECCR13              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR13
    #define FECCRHI_ECCR14              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR14
    #define FECCRHI_ECCR15              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR15
    
    #define FECCRHI_ECCR8_MASK          1U
    #define FECCRHI_ECCR9_MASK          2U
    #define FECCRHI_ECCR10_MASK         4U
    #define FECCRHI_ECCR11_MASK         8U
    #define FECCRHI_ECCR12_MASK         16U
    #define FECCRHI_ECCR13_MASK         32U
    #define FECCRHI_ECCR14_MASK         64U
    #define FECCRHI_ECCR15_MASK         128U
    

    /*** FECCRLO - Flash ECC Error Results Register Low; 0x0000010F ***/
    union {
      byte Byte;
      struct {
        byte ECCR0       :1;                                       /* Flash ECC Error Result Bit 0 */
        byte ECCR1       :1;                                       /* Flash ECC Error Result Bit 1 */
        byte ECCR2       :1;                                       /* Flash ECC Error Result Bit 2 */
        byte ECCR3       :1;                                       /* Flash ECC Error Result Bit 3 */
        byte ECCR4       :1;                                       /* Flash ECC Error Result Bit 4 */
        byte ECCR5       :1;                                       /* Flash ECC Error Result Bit 5 */
        byte ECCR6       :1;                                       /* Flash ECC Error Result Bit 6 */
        byte ECCR7       :1;                                       /* Flash ECC Error Result Bit 7 */
      } Bits;
    } FECCRLOSTR;
    #define FECCRLO                     _FECCR.Overlap_STR.FECCRLOSTR.Byte
    #define FECCRLO_ECCR0               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR0
    #define FECCRLO_ECCR1               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR1
    #define FECCRLO_ECCR2               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR2
    #define FECCRLO_ECCR3               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR3
    #define FECCRLO_ECCR4               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR4
    #define FECCRLO_ECCR5               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR5
    #define FECCRLO_ECCR6               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR6
    #define FECCRLO_ECCR7               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR7
    
    #define FECCRLO_ECCR0_MASK          1U
    #define FECCRLO_ECCR1_MASK          2U
    #define FECCRLO_ECCR2_MASK          4U
    #define FECCRLO_ECCR3_MASK          8U
    #define FECCRLO_ECCR4_MASK          16U
    #define FECCRLO_ECCR5_MASK          32U
    #define FECCRLO_ECCR6_MASK          64U
    #define FECCRLO_ECCR7_MASK          128U
    
  } Overlap_STR;

  struct {
    word ECCR0       :1;                                       /* Flash ECC Error Result Bit 0 */
    word ECCR1       :1;                                       /* Flash ECC Error Result Bit 1 */
    word ECCR2       :1;                                       /* Flash ECC Error Result Bit 2 */
    word ECCR3       :1;                                       /* Flash ECC Error Result Bit 3 */
    word ECCR4       :1;                                       /* Flash ECC Error Result Bit 4 */
    word ECCR5       :1;                                       /* Flash ECC Error Result Bit 5 */
    word ECCR6       :1;                                       /* Flash ECC Error Result Bit 6 */
    word ECCR7       :1;                                       /* Flash ECC Error Result Bit 7 */
    word ECCR8       :1;                                       /* Flash ECC Error Result Bit 8 */
    word ECCR9       :1;                                       /* Flash ECC Error Result Bit 9 */
    word ECCR10      :1;                                       /* Flash ECC Error Result Bit 10 */
    word ECCR11      :1;                                       /* Flash ECC Error Result Bit 11 */
    word ECCR12      :1;                                       /* Flash ECC Error Result Bit 12 */
    word ECCR13      :1;                                       /* Flash ECC Error Result Bit 13 */
    word ECCR14      :1;                                       /* Flash ECC Error Result Bit 14 */
    word ECCR15      :1;                                       /* Flash ECC Error Result Bit 15 */
  } Bits;
} FECCRSTR;
extern volatile FECCRSTR _FECCR @(REG_BASE + 0x0000010EUL);
#define FECCR                           _FECCR.Word
#define FECCR_ECCR0                     _FECCR.Bits.ECCR0
#define FECCR_ECCR1                     _FECCR.Bits.ECCR1
#define FECCR_ECCR2                     _FECCR.Bits.ECCR2
#define FECCR_ECCR3                     _FECCR.Bits.ECCR3
#define FECCR_ECCR4                     _FECCR.Bits.ECCR4
#define FECCR_ECCR5                     _FECCR.Bits.ECCR5
#define FECCR_ECCR6                     _FECCR.Bits.ECCR6
#define FECCR_ECCR7                     _FECCR.Bits.ECCR7
#define FECCR_ECCR8                     _FECCR.Bits.ECCR8
#define FECCR_ECCR9                     _FECCR.Bits.ECCR9
#define FECCR_ECCR10                    _FECCR.Bits.ECCR10
#define FECCR_ECCR11                    _FECCR.Bits.ECCR11
#define FECCR_ECCR12                    _FECCR.Bits.ECCR12
#define FECCR_ECCR13                    _FECCR.Bits.ECCR13
#define FECCR_ECCR14                    _FECCR.Bits.ECCR14
#define FECCR_ECCR15                    _FECCR.Bits.ECCR15

#define FECCR_ECCR0_MASK                1U
#define FECCR_ECCR1_MASK                2U
#define FECCR_ECCR2_MASK                4U
#define FECCR_ECCR3_MASK                8U
#define FECCR_ECCR4_MASK                16U
#define FECCR_ECCR5_MASK                32U
#define FECCR_ECCR6_MASK                64U
#define FECCR_ECCR7_MASK                128U
#define FECCR_ECCR8_MASK                256U
#define FECCR_ECCR9_MASK                512U
#define FECCR_ECCR10_MASK               1024U
#define FECCR_ECCR11_MASK               2048U
#define FECCR_ECCR12_MASK               4096U
#define FECCR_ECCR13_MASK               8192U
#define FECCR_ECCR14_MASK               16384U
#define FECCR_ECCR15_MASK               32768U


/*** FOPT - Flash Option Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Nonvolatile Bit 0 */
    byte NV1         :1;                                       /* Nonvolatile Bit 1 */
    byte NV2         :1;                                       /* Nonvolatile Bit 2 */
    byte NV3         :1;                                       /* Nonvolatile Bit 3 */
    byte NV4         :1;                                       /* Nonvolatile Bit 4 */
    byte NV5         :1;                                       /* Nonvolatile Bit 5 */
    byte NV6         :1;                                       /* Nonvolatile Bit 6 */
    byte NV7         :1;                                       /* Nonvolatile Bit 7 */
  } Bits;
} FOPTSTR;
extern volatile FOPTSTR _FOPT @(REG_BASE + 0x00000110UL);
#define FOPT                            _FOPT.Byte
#define FOPT_NV0                        _FOPT.Bits.NV0
#define FOPT_NV1                        _FOPT.Bits.NV1
#define FOPT_NV2                        _FOPT.Bits.NV2
#define FOPT_NV3                        _FOPT.Bits.NV3
#define FOPT_NV4                        _FOPT.Bits.NV4
#define FOPT_NV5                        _FOPT.Bits.NV5
#define FOPT_NV6                        _FOPT.Bits.NV6
#define FOPT_NV7                        _FOPT.Bits.NV7

#define FOPT_NV0_MASK                   1U
#define FOPT_NV1_MASK                   2U
#define FOPT_NV2_MASK                   4U
#define FOPT_NV3_MASK                   8U
#define FOPT_NV4_MASK                   16U
#define FOPT_NV5_MASK                   32U
#define FOPT_NV6_MASK                   64U
#define FOPT_NV7_MASK                   128U


/*** IVBR - Interrupt Vector Base Register; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte IVB_ADDR    :8;                                       /* Interrupt Vector Base Address Bits */
  } Bits;
} IVBRSTR;
extern volatile IVBRSTR _IVBR @(REG_BASE + 0x00000121UL);
#define IVBR                            _IVBR.Byte
#define IVBR_IVB_ADDR                   _IVBR.Bits.IVB_ADDR

#define IVBR_IVB_ADDR_MASK              255U
#define IVBR_IVB_ADDR_BITNUM            0U


/*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x00000126 ***/
typedef union {
  byte Byte;
  struct {
    byte XILVL       :3;                                       /* XGATE Interrupt Priority Level */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} INT_XGPRIOSTR;
extern volatile INT_XGPRIOSTR _INT_XGPRIO @(REG_BASE + 0x00000126UL);
#define INT_XGPRIO                      _INT_XGPRIO.Byte
#define INT_XGPRIO_XILVL                _INT_XGPRIO.Bits.XILVL

#define INT_XGPRIO_XILVL_MASK           7U
#define INT_XGPRIO_XILVL_BITNUM         0U


/*** INT_CFADDR - Interrupt Request Configuration Address Register; 0x00000127 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte INT_CFADDR_grp :4;                                    /* Interrupt Request Configuration Data Register Select Bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} INT_CFADDRSTR;
extern volatile INT_CFADDRSTR _INT_CFADDR @(REG_BASE + 0x00000127UL);
#define INT_CFADDR                      _INT_CFADDR.Byte
#define INT_CFADDR_INT_CFADDR           _INT_CFADDR.Bits.INT_CFADDR_grp

#define INT_CFADDR_INT_CFADDR_MASK      240U
#define INT_CFADDR_INT_CFADDR_BITNUM    4U


/*** INT_CFDATA0 - Interrupt Request Configuration Data Register 0; 0x00000128 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA0STR;
extern volatile INT_CFDATA0STR _INT_CFDATA0 @(REG_BASE + 0x00000128UL);
#define INT_CFDATA0                     _INT_CFDATA0.Byte
#define INT_CFDATA0_PRIOLVL             _INT_CFDATA0.Bits.PRIOLVL
#define INT_CFDATA0_RQST                _INT_CFDATA0.Bits.RQST
/* INT_CFDATA_ARR: Access 8 INT_CFDATAx registers in an array */
#define INT_CFDATA_ARR                  ((volatile byte *) &INT_CFDATA0)

#define INT_CFDATA0_PRIOLVL_MASK        7U
#define INT_CFDATA0_PRIOLVL_BITNUM      0U
#define INT_CFDATA0_RQST_MASK           128U


/*** INT_CFDATA1 - Interrupt Request Configuration Data Register 1; 0x00000129 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA1STR;
extern volatile INT_CFDATA1STR _INT_CFDATA1 @(REG_BASE + 0x00000129UL);
#define INT_CFDATA1                     _INT_CFDATA1.Byte
#define INT_CFDATA1_PRIOLVL             _INT_CFDATA1.Bits.PRIOLVL
#define INT_CFDATA1_RQST                _INT_CFDATA1.Bits.RQST

#define INT_CFDATA1_PRIOLVL_MASK        7U
#define INT_CFDATA1_PRIOLVL_BITNUM      0U
#define INT_CFDATA1_RQST_MASK           128U


/*** INT_CFDATA2 - Interrupt Request Configuration Data Register 2; 0x0000012A ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA2STR;
extern volatile INT_CFDATA2STR _INT_CFDATA2 @(REG_BASE + 0x0000012AUL);
#define INT_CFDATA2                     _INT_CFDATA2.Byte
#define INT_CFDATA2_PRIOLVL             _INT_CFDATA2.Bits.PRIOLVL
#define INT_CFDATA2_RQST                _INT_CFDATA2.Bits.RQST

#define INT_CFDATA2_PRIOLVL_MASK        7U
#define INT_CFDATA2_PRIOLVL_BITNUM      0U
#define INT_CFDATA2_RQST_MASK           128U


/*** INT_CFDATA3 - Interrupt Request Configuration Data Register 3; 0x0000012B ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA3STR;
extern volatile INT_CFDATA3STR _INT_CFDATA3 @(REG_BASE + 0x0000012BUL);
#define INT_CFDATA3                     _INT_CFDATA3.Byte
#define INT_CFDATA3_PRIOLVL             _INT_CFDATA3.Bits.PRIOLVL
#define INT_CFDATA3_RQST                _INT_CFDATA3.Bits.RQST

#define INT_CFDATA3_PRIOLVL_MASK        7U
#define INT_CFDATA3_PRIOLVL_BITNUM      0U
#define INT_CFDATA3_RQST_MASK           128U


/*** INT_CFDATA4 - Interrupt Request Configuration Data Register 4; 0x0000012C ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA4STR;
extern volatile INT_CFDATA4STR _INT_CFDATA4 @(REG_BASE + 0x0000012CUL);
#define INT_CFDATA4                     _INT_CFDATA4.Byte
#define INT_CFDATA4_PRIOLVL             _INT_CFDATA4.Bits.PRIOLVL
#define INT_CFDATA4_RQST                _INT_CFDATA4.Bits.RQST

#define INT_CFDATA4_PRIOLVL_MASK        7U
#define INT_CFDATA4_PRIOLVL_BITNUM      0U
#define INT_CFDATA4_RQST_MASK           128U


/*** INT_CFDATA5 - Interrupt Request Configuration Data Register 5; 0x0000012D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA5STR;
extern volatile INT_CFDATA5STR _INT_CFDATA5 @(REG_BASE + 0x0000012DUL);
#define INT_CFDATA5                     _INT_CFDATA5.Byte
#define INT_CFDATA5_PRIOLVL             _INT_CFDATA5.Bits.PRIOLVL
#define INT_CFDATA5_RQST                _INT_CFDATA5.Bits.RQST

#define INT_CFDATA5_PRIOLVL_MASK        7U
#define INT_CFDATA5_PRIOLVL_BITNUM      0U
#define INT_CFDATA5_RQST_MASK           128U


/*** INT_CFDATA6 - Interrupt Request Configuration Data Register 6; 0x0000012E ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA6STR;
extern volatile INT_CFDATA6STR _INT_CFDATA6 @(REG_BASE + 0x0000012EUL);
#define INT_CFDATA6                     _INT_CFDATA6.Byte
#define INT_CFDATA6_PRIOLVL             _INT_CFDATA6.Bits.PRIOLVL
#define INT_CFDATA6_RQST                _INT_CFDATA6.Bits.RQST

#define INT_CFDATA6_PRIOLVL_MASK        7U
#define INT_CFDATA6_PRIOLVL_BITNUM      0U
#define INT_CFDATA6_RQST_MASK           128U


/*** INT_CFDATA7 - Interrupt Request Configuration Data Register 7; 0x0000012F ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA7STR;
extern volatile INT_CFDATA7STR _INT_CFDATA7 @(REG_BASE + 0x0000012FUL);
#define INT_CFDATA7                     _INT_CFDATA7.Byte
#define INT_CFDATA7_PRIOLVL             _INT_CFDATA7.Bits.PRIOLVL
#define INT_CFDATA7_RQST                _INT_CFDATA7.Bits.RQST

#define INT_CFDATA7_PRIOLVL_MASK        7U
#define INT_CFDATA7_PRIOLVL_BITNUM      0U
#define INT_CFDATA7_RQST_MASK           128U


/*** CAN0CTL0 - MSCAN0 Control 0 Register; 0x00000140 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN0CTL0STR;
extern volatile CAN0CTL0STR _CAN0CTL0 @(REG_BASE + 0x00000140UL);
#define CAN0CTL0                        _CAN0CTL0.Byte
#define CAN0CTL0_INITRQ                 _CAN0CTL0.Bits.INITRQ
#define CAN0CTL0_SLPRQ                  _CAN0CTL0.Bits.SLPRQ
#define CAN0CTL0_WUPE                   _CAN0CTL0.Bits.WUPE
#define CAN0CTL0_TIME                   _CAN0CTL0.Bits.TIME
#define CAN0CTL0_SYNCH                  _CAN0CTL0.Bits.SYNCH
#define CAN0CTL0_CSWAI                  _CAN0CTL0.Bits.CSWAI
#define CAN0CTL0_RXACT                  _CAN0CTL0.Bits.RXACT
#define CAN0CTL0_RXFRM                  _CAN0CTL0.Bits.RXFRM
/* CAN0CTL_ARR: Access 2 CAN0CTLx registers in an array */
#define CAN0CTL_ARR                     ((volatile byte *) &CAN0CTL0)

#define CAN0CTL0_INITRQ_MASK            1U
#define CAN0CTL0_SLPRQ_MASK             2U
#define CAN0CTL0_WUPE_MASK              4U
#define CAN0CTL0_TIME_MASK              8U
#define CAN0CTL0_SYNCH_MASK             16U
#define CAN0CTL0_CSWAI_MASK             32U
#define CAN0CTL0_RXACT_MASK             64U
#define CAN0CTL0_RXFRM_MASK             128U


/*** CAN0CTL1 - MSCAN0 Control 1 Register; 0x00000141 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN Clock Source */
    byte CANE        :1;                                       /* MSCAN Enable */
  } Bits;
} CAN0CTL1STR;
extern volatile CAN0CTL1STR _CAN0CTL1 @(REG_BASE + 0x00000141UL);
#define CAN0CTL1                        _CAN0CTL1.Byte
#define CAN0CTL1_INITAK                 _CAN0CTL1.Bits.INITAK
#define CAN0CTL1_SLPAK                  _CAN0CTL1.Bits.SLPAK
#define CAN0CTL1_WUPM                   _CAN0CTL1.Bits.WUPM
#define CAN0CTL1_BORM                   _CAN0CTL1.Bits.BORM
#define CAN0CTL1_LISTEN                 _CAN0CTL1.Bits.LISTEN
#define CAN0CTL1_LOOPB                  _CAN0CTL1.Bits.LOOPB
#define CAN0CTL1_CLKSRC                 _CAN0CTL1.Bits.CLKSRC
#define CAN0CTL1_CANE                   _CAN0CTL1.Bits.CANE

#define CAN0CTL1_INITAK_MASK            1U
#define CAN0CTL1_SLPAK_MASK             2U
#define CAN0CTL1_WUPM_MASK              4U
#define CAN0CTL1_BORM_MASK              8U
#define CAN0CTL1_LISTEN_MASK            16U
#define CAN0CTL1_LOOPB_MASK             32U
#define CAN0CTL1_CLKSRC_MASK            64U
#define CAN0CTL1_CANE_MASK              128U


/*** CAN0BTR0 - MSCAN0 Bus Timing Register 0; 0x00000142 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN0BTR0STR;
extern volatile CAN0BTR0STR _CAN0BTR0 @(REG_BASE + 0x00000142UL);
#define CAN0BTR0                        _CAN0BTR0.Byte
#define CAN0BTR0_BRP0                   _CAN0BTR0.Bits.BRP0
#define CAN0BTR0_BRP1                   _CAN0BTR0.Bits.BRP1
#define CAN0BTR0_BRP2                   _CAN0BTR0.Bits.BRP2
#define CAN0BTR0_BRP3                   _CAN0BTR0.Bits.BRP3
#define CAN0BTR0_BRP4                   _CAN0BTR0.Bits.BRP4
#define CAN0BTR0_BRP5                   _CAN0BTR0.Bits.BRP5
#define CAN0BTR0_SJW0                   _CAN0BTR0.Bits.SJW0
#define CAN0BTR0_SJW1                   _CAN0BTR0.Bits.SJW1
/* CAN0BTR_ARR: Access 2 CAN0BTRx registers in an array */
#define CAN0BTR_ARR                     ((volatile byte *) &CAN0BTR0)
#define CAN0BTR0_BRP                    _CAN0BTR0.MergedBits.grpBRP
#define CAN0BTR0_SJW                    _CAN0BTR0.MergedBits.grpSJW

#define CAN0BTR0_BRP0_MASK              1U
#define CAN0BTR0_BRP1_MASK              2U
#define CAN0BTR0_BRP2_MASK              4U
#define CAN0BTR0_BRP3_MASK              8U
#define CAN0BTR0_BRP4_MASK              16U
#define CAN0BTR0_BRP5_MASK              32U
#define CAN0BTR0_SJW0_MASK              64U
#define CAN0BTR0_SJW1_MASK              128U
#define CAN0BTR0_BRP_MASK               63U
#define CAN0BTR0_BRP_BITNUM             0U
#define CAN0BTR0_SJW_MASK               192U
#define CAN0BTR0_SJW_BITNUM             6U


/*** CAN0BTR1 - MSCAN0 Bus Timing Register 1; 0x00000143 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN0BTR1STR;
extern volatile CAN0BTR1STR _CAN0BTR1 @(REG_BASE + 0x00000143UL);
#define CAN0BTR1                        _CAN0BTR1.Byte
#define CAN0BTR1_TSEG10                 _CAN0BTR1.Bits.TSEG10
#define CAN0BTR1_TSEG11                 _CAN0BTR1.Bits.TSEG11
#define CAN0BTR1_TSEG12                 _CAN0BTR1.Bits.TSEG12
#define CAN0BTR1_TSEG13                 _CAN0BTR1.Bits.TSEG13
#define CAN0BTR1_TSEG20                 _CAN0BTR1.Bits.TSEG20
#define CAN0BTR1_TSEG21                 _CAN0BTR1.Bits.TSEG21
#define CAN0BTR1_TSEG22                 _CAN0BTR1.Bits.TSEG22
#define CAN0BTR1_SAMP                   _CAN0BTR1.Bits.SAMP
#define CAN0BTR1_TSEG_10                _CAN0BTR1.MergedBits.grpTSEG_10
#define CAN0BTR1_TSEG_20                _CAN0BTR1.MergedBits.grpTSEG_20
#define CAN0BTR1_TSEG                   CAN0BTR1_TSEG_10

#define CAN0BTR1_TSEG10_MASK            1U
#define CAN0BTR1_TSEG11_MASK            2U
#define CAN0BTR1_TSEG12_MASK            4U
#define CAN0BTR1_TSEG13_MASK            8U
#define CAN0BTR1_TSEG20_MASK            16U
#define CAN0BTR1_TSEG21_MASK            32U
#define CAN0BTR1_TSEG22_MASK            64U
#define CAN0BTR1_SAMP_MASK              128U
#define CAN0BTR1_TSEG_10_MASK           15U
#define CAN0BTR1_TSEG_10_BITNUM         0U
#define CAN0BTR1_TSEG_20_MASK           112U
#define CAN0BTR1_TSEG_20_BITNUM         4U


/*** CAN0RFLG - MSCAN0 Receiver Flag Register; 0x00000144 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RFLGSTR;
extern volatile CAN0RFLGSTR _CAN0RFLG @(REG_BASE + 0x00000144UL);
#define CAN0RFLG                        _CAN0RFLG.Byte
#define CAN0RFLG_RXF                    _CAN0RFLG.Bits.RXF
#define CAN0RFLG_OVRIF                  _CAN0RFLG.Bits.OVRIF
#define CAN0RFLG_TSTAT0                 _CAN0RFLG.Bits.TSTAT0
#define CAN0RFLG_TSTAT1                 _CAN0RFLG.Bits.TSTAT1
#define CAN0RFLG_RSTAT0                 _CAN0RFLG.Bits.RSTAT0
#define CAN0RFLG_RSTAT1                 _CAN0RFLG.Bits.RSTAT1
#define CAN0RFLG_CSCIF                  _CAN0RFLG.Bits.CSCIF
#define CAN0RFLG_WUPIF                  _CAN0RFLG.Bits.WUPIF
#define CAN0RFLG_TSTAT                  _CAN0RFLG.MergedBits.grpTSTAT
#define CAN0RFLG_RSTAT                  _CAN0RFLG.MergedBits.grpRSTAT

#define CAN0RFLG_RXF_MASK               1U
#define CAN0RFLG_OVRIF_MASK             2U
#define CAN0RFLG_TSTAT0_MASK            4U
#define CAN0RFLG_TSTAT1_MASK            8U
#define CAN0RFLG_RSTAT0_MASK            16U
#define CAN0RFLG_RSTAT1_MASK            32U
#define CAN0RFLG_CSCIF_MASK             64U
#define CAN0RFLG_WUPIF_MASK             128U
#define CAN0RFLG_TSTAT_MASK             12U
#define CAN0RFLG_TSTAT_BITNUM           2U
#define CAN0RFLG_RSTAT_MASK             48U
#define CAN0RFLG_RSTAT_BITNUM           4U


/*** CAN0RIER - MSCAN0 Receiver Interrupt Enable Register; 0x00000145 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RIERSTR;
extern volatile CAN0RIERSTR _CAN0RIER @(REG_BASE + 0x00000145UL);
#define CAN0RIER                        _CAN0RIER.Byte
#define CAN0RIER_RXFIE                  _CAN0RIER.Bits.RXFIE
#define CAN0RIER_OVRIE                  _CAN0RIER.Bits.OVRIE
#define CAN0RIER_TSTATE0                _CAN0RIER.Bits.TSTATE0
#define CAN0RIER_TSTATE1                _CAN0RIER.Bits.TSTATE1
#define CAN0RIER_RSTATE0                _CAN0RIER.Bits.RSTATE0
#define CAN0RIER_RSTATE1                _CAN0RIER.Bits.RSTATE1
#define CAN0RIER_CSCIE                  _CAN0RIER.Bits.CSCIE
#define CAN0RIER_WUPIE                  _CAN0RIER.Bits.WUPIE
#define CAN0RIER_TSTATE                 _CAN0RIER.MergedBits.grpTSTATE
#define CAN0RIER_RSTATE                 _CAN0RIER.MergedBits.grpRSTATE

#define CAN0RIER_RXFIE_MASK             1U
#define CAN0RIER_OVRIE_MASK             2U
#define CAN0RIER_TSTATE0_MASK           4U
#define CAN0RIER_TSTATE1_MASK           8U
#define CAN0RIER_RSTATE0_MASK           16U
#define CAN0RIER_RSTATE1_MASK           32U
#define CAN0RIER_CSCIE_MASK             64U
#define CAN0RIER_WUPIE_MASK             128U
#define CAN0RIER_TSTATE_MASK            12U
#define CAN0RIER_TSTATE_BITNUM          2U
#define CAN0RIER_RSTATE_MASK            48U
#define CAN0RIER_RSTATE_BITNUM          4U


/*** CAN0TFLG - MSCAN0 Transmitter Flag Register; 0x00000146 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TFLGSTR;
extern volatile CAN0TFLGSTR _CAN0TFLG @(REG_BASE + 0x00000146UL);
#define CAN0TFLG                        _CAN0TFLG.Byte
#define CAN0TFLG_TXE0                   _CAN0TFLG.Bits.TXE0
#define CAN0TFLG_TXE1                   _CAN0TFLG.Bits.TXE1
#define CAN0TFLG_TXE2                   _CAN0TFLG.Bits.TXE2
#define CAN0TFLG_TXE                    _CAN0TFLG.MergedBits.grpTXE

#define CAN0TFLG_TXE0_MASK              1U
#define CAN0TFLG_TXE1_MASK              2U
#define CAN0TFLG_TXE2_MASK              4U
#define CAN0TFLG_TXE_MASK               7U
#define CAN0TFLG_TXE_BITNUM             0U


/*** CAN0TIER - MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TIERSTR;
extern volatile CAN0TIERSTR _CAN0TIER @(REG_BASE + 0x00000147UL);
#define CAN0TIER                        _CAN0TIER.Byte
#define CAN0TIER_TXEIE0                 _CAN0TIER.Bits.TXEIE0
#define CAN0TIER_TXEIE1                 _CAN0TIER.Bits.TXEIE1
#define CAN0TIER_TXEIE2                 _CAN0TIER.Bits.TXEIE2
#define CAN0TIER_TXEIE                  _CAN0TIER.MergedBits.grpTXEIE

#define CAN0TIER_TXEIE0_MASK            1U
#define CAN0TIER_TXEIE1_MASK            2U
#define CAN0TIER_TXEIE2_MASK            4U
#define CAN0TIER_TXEIE_MASK             7U
#define CAN0TIER_TXEIE_BITNUM           0U


/*** CAN0TARQ - MSCAN0 Transmitter Message Abort Request; 0x00000148 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TARQSTR;
extern volatile CAN0TARQSTR _CAN0TARQ @(REG_BASE + 0x00000148UL);
#define CAN0TARQ                        _CAN0TARQ.Byte
#define CAN0TARQ_ABTRQ0                 _CAN0TARQ.Bits.ABTRQ0
#define CAN0TARQ_ABTRQ1                 _CAN0TARQ.Bits.ABTRQ1
#define CAN0TARQ_ABTRQ2                 _CAN0TARQ.Bits.ABTRQ2
#define CAN0TARQ_ABTRQ                  _CAN0TARQ.MergedBits.grpABTRQ

#define CAN0TARQ_ABTRQ0_MASK            1U
#define CAN0TARQ_ABTRQ1_MASK            2U
#define CAN0TARQ_ABTRQ2_MASK            4U
#define CAN0TARQ_ABTRQ_MASK             7U
#define CAN0TARQ_ABTRQ_BITNUM           0U


/*** CAN0TAAK - MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TAAKSTR;
extern volatile CAN0TAAKSTR _CAN0TAAK @(REG_BASE + 0x00000149UL);
#define CAN0TAAK                        _CAN0TAAK.Byte
#define CAN0TAAK_ABTAK0                 _CAN0TAAK.Bits.ABTAK0
#define CAN0TAAK_ABTAK1                 _CAN0TAAK.Bits.ABTAK1
#define CAN0TAAK_ABTAK2                 _CAN0TAAK.Bits.ABTAK2
#define CAN0TAAK_ABTAK                  _CAN0TAAK.MergedBits.grpABTAK

#define CAN0TAAK_ABTAK0_MASK            1U
#define CAN0TAAK_ABTAK1_MASK            2U
#define CAN0TAAK_ABTAK2_MASK            4U
#define CAN0TAAK_ABTAK_MASK             7U
#define CAN0TAAK_ABTAK_BITNUM           0U


/*** CAN0TBSEL - MSCAN0 Transmit Buffer Selection; 0x0000014A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TBSELSTR;
extern volatile CAN0TBSELSTR _CAN0TBSEL @(REG_BASE + 0x0000014AUL);
#define CAN0TBSEL                       _CAN0TBSEL.Byte
#define CAN0TBSEL_TX0                   _CAN0TBSEL.Bits.TX0
#define CAN0TBSEL_TX1                   _CAN0TBSEL.Bits.TX1
#define CAN0TBSEL_TX2                   _CAN0TBSEL.Bits.TX2
#define CAN0TBSEL_TX                    _CAN0TBSEL.MergedBits.grpTX

#define CAN0TBSEL_TX0_MASK              1U
#define CAN0TBSEL_TX1_MASK              2U
#define CAN0TBSEL_TX2_MASK              4U
#define CAN0TBSEL_TX_MASK               7U
#define CAN0TBSEL_TX_BITNUM             0U


/*** CAN0IDAC - MSCAN0 Identifier Acceptance Control Register; 0x0000014B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0IDACSTR;
extern volatile CAN0IDACSTR _CAN0IDAC @(REG_BASE + 0x0000014BUL);
#define CAN0IDAC                        _CAN0IDAC.Byte
#define CAN0IDAC_IDHIT0                 _CAN0IDAC.Bits.IDHIT0
#define CAN0IDAC_IDHIT1                 _CAN0IDAC.Bits.IDHIT1
#define CAN0IDAC_IDHIT2                 _CAN0IDAC.Bits.IDHIT2
#define CAN0IDAC_IDAM0                  _CAN0IDAC.Bits.IDAM0
#define CAN0IDAC_IDAM1                  _CAN0IDAC.Bits.IDAM1
#define CAN0IDAC_IDHIT                  _CAN0IDAC.MergedBits.grpIDHIT
#define CAN0IDAC_IDAM                   _CAN0IDAC.MergedBits.grpIDAM

#define CAN0IDAC_IDHIT0_MASK            1U
#define CAN0IDAC_IDHIT1_MASK            2U
#define CAN0IDAC_IDHIT2_MASK            4U
#define CAN0IDAC_IDAM0_MASK             16U
#define CAN0IDAC_IDAM1_MASK             32U
#define CAN0IDAC_IDHIT_MASK             7U
#define CAN0IDAC_IDHIT_BITNUM           0U
#define CAN0IDAC_IDAM_MASK              48U
#define CAN0IDAC_IDAM_BITNUM            4U


/*** CAN0MISC - MSCAN0 Miscellaneous Register; 0x0000014D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-off State Hold Until User Request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN0MISCSTR;
extern volatile CAN0MISCSTR _CAN0MISC @(REG_BASE + 0x0000014DUL);
#define CAN0MISC                        _CAN0MISC.Byte
#define CAN0MISC_BOHOLD                 _CAN0MISC.Bits.BOHOLD

#define CAN0MISC_BOHOLD_MASK            1U


/*** CAN0RXERR - MSCAN0 Receive Error Counter Register; 0x0000014E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0RXERRSTR;
extern volatile CAN0RXERRSTR _CAN0RXERR @(REG_BASE + 0x0000014EUL);
#define CAN0RXERR                       _CAN0RXERR.Byte
#define CAN0RXERR_RXERR0                _CAN0RXERR.Bits.RXERR0
#define CAN0RXERR_RXERR1                _CAN0RXERR.Bits.RXERR1
#define CAN0RXERR_RXERR2                _CAN0RXERR.Bits.RXERR2
#define CAN0RXERR_RXERR3                _CAN0RXERR.Bits.RXERR3
#define CAN0RXERR_RXERR4                _CAN0RXERR.Bits.RXERR4
#define CAN0RXERR_RXERR5                _CAN0RXERR.Bits.RXERR5
#define CAN0RXERR_RXERR6                _CAN0RXERR.Bits.RXERR6
#define CAN0RXERR_RXERR7                _CAN0RXERR.Bits.RXERR7

#define CAN0RXERR_RXERR0_MASK           1U
#define CAN0RXERR_RXERR1_MASK           2U
#define CAN0RXERR_RXERR2_MASK           4U
#define CAN0RXERR_RXERR3_MASK           8U
#define CAN0RXERR_RXERR4_MASK           16U
#define CAN0RXERR_RXERR5_MASK           32U
#define CAN0RXERR_RXERR6_MASK           64U
#define CAN0RXERR_RXERR7_MASK           128U


/*** CAN0TXERR - MSCAN0 Transmit Error Counter Register; 0x0000014F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0TXERRSTR;
extern volatile CAN0TXERRSTR _CAN0TXERR @(REG_BASE + 0x0000014FUL);
#define CAN0TXERR                       _CAN0TXERR.Byte
#define CAN0TXERR_TXERR0                _CAN0TXERR.Bits.TXERR0
#define CAN0TXERR_TXERR1                _CAN0TXERR.Bits.TXERR1
#define CAN0TXERR_TXERR2                _CAN0TXERR.Bits.TXERR2
#define CAN0TXERR_TXERR3                _CAN0TXERR.Bits.TXERR3
#define CAN0TXERR_TXERR4                _CAN0TXERR.Bits.TXERR4
#define CAN0TXERR_TXERR5                _CAN0TXERR.Bits.TXERR5
#define CAN0TXERR_TXERR6                _CAN0TXERR.Bits.TXERR6
#define CAN0TXERR_TXERR7                _CAN0TXERR.Bits.TXERR7

#define CAN0TXERR_TXERR0_MASK           1U
#define CAN0TXERR_TXERR1_MASK           2U
#define CAN0TXERR_TXERR2_MASK           4U
#define CAN0TXERR_TXERR3_MASK           8U
#define CAN0TXERR_TXERR4_MASK           16U
#define CAN0TXERR_TXERR5_MASK           32U
#define CAN0TXERR_TXERR6_MASK           64U
#define CAN0TXERR_TXERR7_MASK           128U


/*** CAN0IDAR0 - MSCAN0 Identifier Acceptance Register 0; 0x00000150 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR0STR;
extern volatile CAN0IDAR0STR _CAN0IDAR0 @(REG_BASE + 0x00000150UL);
#define CAN0IDAR0                       _CAN0IDAR0.Byte
#define CAN0IDAR0_AC0                   _CAN0IDAR0.Bits.AC0
#define CAN0IDAR0_AC1                   _CAN0IDAR0.Bits.AC1
#define CAN0IDAR0_AC2                   _CAN0IDAR0.Bits.AC2
#define CAN0IDAR0_AC3                   _CAN0IDAR0.Bits.AC3
#define CAN0IDAR0_AC4                   _CAN0IDAR0.Bits.AC4
#define CAN0IDAR0_AC5                   _CAN0IDAR0.Bits.AC5
#define CAN0IDAR0_AC6                   _CAN0IDAR0.Bits.AC6
#define CAN0IDAR0_AC7                   _CAN0IDAR0.Bits.AC7
/* CAN0IDAR_ARR: Access 4 CAN0IDARx registers in an array */
#define CAN0IDAR_ARR                    ((volatile byte *) &CAN0IDAR0)

#define CAN0IDAR0_AC0_MASK              1U
#define CAN0IDAR0_AC1_MASK              2U
#define CAN0IDAR0_AC2_MASK              4U
#define CAN0IDAR0_AC3_MASK              8U
#define CAN0IDAR0_AC4_MASK              16U
#define CAN0IDAR0_AC5_MASK              32U
#define CAN0IDAR0_AC6_MASK              64U
#define CAN0IDAR0_AC7_MASK              128U


/*** CAN0IDAR1 - MSCAN0 Identifier Acceptance Register 1; 0x00000151 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR1STR;
extern volatile CAN0IDAR1STR _CAN0IDAR1 @(REG_BASE + 0x00000151UL);
#define CAN0IDAR1                       _CAN0IDAR1.Byte
#define CAN0IDAR1_AC0                   _CAN0IDAR1.Bits.AC0
#define CAN0IDAR1_AC1                   _CAN0IDAR1.Bits.AC1
#define CAN0IDAR1_AC2                   _CAN0IDAR1.Bits.AC2
#define CAN0IDAR1_AC3                   _CAN0IDAR1.Bits.AC3
#define CAN0IDAR1_AC4                   _CAN0IDAR1.Bits.AC4
#define CAN0IDAR1_AC5                   _CAN0IDAR1.Bits.AC5
#define CAN0IDAR1_AC6                   _CAN0IDAR1.Bits.AC6
#define CAN0IDAR1_AC7                   _CAN0IDAR1.Bits.AC7

#define CAN0IDAR1_AC0_MASK              1U
#define CAN0IDAR1_AC1_MASK              2U
#define CAN0IDAR1_AC2_MASK              4U
#define CAN0IDAR1_AC3_MASK              8U
#define CAN0IDAR1_AC4_MASK              16U
#define CAN0IDAR1_AC5_MASK              32U
#define CAN0IDAR1_AC6_MASK              64U
#define CAN0IDAR1_AC7_MASK              128U


/*** CAN0IDAR2 - MSCAN0 Identifier Acceptance Register 2; 0x00000152 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR2STR;
extern volatile CAN0IDAR2STR _CAN0IDAR2 @(REG_BASE + 0x00000152UL);
#define CAN0IDAR2                       _CAN0IDAR2.Byte
#define CAN0IDAR2_AC0                   _CAN0IDAR2.Bits.AC0
#define CAN0IDAR2_AC1                   _CAN0IDAR2.Bits.AC1
#define CAN0IDAR2_AC2                   _CAN0IDAR2.Bits.AC2
#define CAN0IDAR2_AC3                   _CAN0IDAR2.Bits.AC3
#define CAN0IDAR2_AC4                   _CAN0IDAR2.Bits.AC4
#define CAN0IDAR2_AC5                   _CAN0IDAR2.Bits.AC5
#define CAN0IDAR2_AC6                   _CAN0IDAR2.Bits.AC6
#define CAN0IDAR2_AC7                   _CAN0IDAR2.Bits.AC7

#define CAN0IDAR2_AC0_MASK              1U
#define CAN0IDAR2_AC1_MASK              2U
#define CAN0IDAR2_AC2_MASK              4U
#define CAN0IDAR2_AC3_MASK              8U
#define CAN0IDAR2_AC4_MASK              16U
#define CAN0IDAR2_AC5_MASK              32U
#define CAN0IDAR2_AC6_MASK              64U
#define CAN0IDAR2_AC7_MASK              128U


/*** CAN0IDAR3 - MSCAN0 Identifier Acceptance Register 3; 0x00000153 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR3STR;
extern volatile CAN0IDAR3STR _CAN0IDAR3 @(REG_BASE + 0x00000153UL);
#define CAN0IDAR3                       _CAN0IDAR3.Byte
#define CAN0IDAR3_AC0                   _CAN0IDAR3.Bits.AC0
#define CAN0IDAR3_AC1                   _CAN0IDAR3.Bits.AC1
#define CAN0IDAR3_AC2                   _CAN0IDAR3.Bits.AC2
#define CAN0IDAR3_AC3                   _CAN0IDAR3.Bits.AC3
#define CAN0IDAR3_AC4                   _CAN0IDAR3.Bits.AC4
#define CAN0IDAR3_AC5                   _CAN0IDAR3.Bits.AC5
#define CAN0IDAR3_AC6                   _CAN0IDAR3.Bits.AC6
#define CAN0IDAR3_AC7                   _CAN0IDAR3.Bits.AC7

#define CAN0IDAR3_AC0_MASK              1U
#define CAN0IDAR3_AC1_MASK              2U
#define CAN0IDAR3_AC2_MASK              4U
#define CAN0IDAR3_AC3_MASK              8U
#define CAN0IDAR3_AC4_MASK              16U
#define CAN0IDAR3_AC5_MASK              32U
#define CAN0IDAR3_AC6_MASK              64U
#define CAN0IDAR3_AC7_MASK              128U


/*** CAN0IDMR0 - MSCAN0 Identifier Mask Register 0; 0x00000154 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR0STR;
extern volatile CAN0IDMR0STR _CAN0IDMR0 @(REG_BASE + 0x00000154UL);
#define CAN0IDMR0                       _CAN0IDMR0.Byte
#define CAN0IDMR0_AM0                   _CAN0IDMR0.Bits.AM0
#define CAN0IDMR0_AM1                   _CAN0IDMR0.Bits.AM1
#define CAN0IDMR0_AM2                   _CAN0IDMR0.Bits.AM2
#define CAN0IDMR0_AM3                   _CAN0IDMR0.Bits.AM3
#define CAN0IDMR0_AM4                   _CAN0IDMR0.Bits.AM4
#define CAN0IDMR0_AM5                   _CAN0IDMR0.Bits.AM5
#define CAN0IDMR0_AM6                   _CAN0IDMR0.Bits.AM6
#define CAN0IDMR0_AM7                   _CAN0IDMR0.Bits.AM7
/* CAN0IDMR_ARR: Access 4 CAN0IDMRx registers in an array */
#define CAN0IDMR_ARR                    ((volatile byte *) &CAN0IDMR0)

#define CAN0IDMR0_AM0_MASK              1U
#define CAN0IDMR0_AM1_MASK              2U
#define CAN0IDMR0_AM2_MASK              4U
#define CAN0IDMR0_AM3_MASK              8U
#define CAN0IDMR0_AM4_MASK              16U
#define CAN0IDMR0_AM5_MASK              32U
#define CAN0IDMR0_AM6_MASK              64U
#define CAN0IDMR0_AM7_MASK              128U


/*** CAN0IDMR1 - MSCAN0 Identifier Mask Register 1; 0x00000155 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR1STR;
extern volatile CAN0IDMR1STR _CAN0IDMR1 @(REG_BASE + 0x00000155UL);
#define CAN0IDMR1                       _CAN0IDMR1.Byte
#define CAN0IDMR1_AM0                   _CAN0IDMR1.Bits.AM0
#define CAN0IDMR1_AM1                   _CAN0IDMR1.Bits.AM1
#define CAN0IDMR1_AM2                   _CAN0IDMR1.Bits.AM2
#define CAN0IDMR1_AM3                   _CAN0IDMR1.Bits.AM3
#define CAN0IDMR1_AM4                   _CAN0IDMR1.Bits.AM4
#define CAN0IDMR1_AM5                   _CAN0IDMR1.Bits.AM5
#define CAN0IDMR1_AM6                   _CAN0IDMR1.Bits.AM6
#define CAN0IDMR1_AM7                   _CAN0IDMR1.Bits.AM7

#define CAN0IDMR1_AM0_MASK              1U
#define CAN0IDMR1_AM1_MASK              2U
#define CAN0IDMR1_AM2_MASK              4U
#define CAN0IDMR1_AM3_MASK              8U
#define CAN0IDMR1_AM4_MASK              16U
#define CAN0IDMR1_AM5_MASK              32U
#define CAN0IDMR1_AM6_MASK              64U
#define CAN0IDMR1_AM7_MASK              128U


/*** CAN0IDMR2 - MSCAN0 Identifier Mask Register 2; 0x00000156 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR2STR;
extern volatile CAN0IDMR2STR _CAN0IDMR2 @(REG_BASE + 0x00000156UL);
#define CAN0IDMR2                       _CAN0IDMR2.Byte
#define CAN0IDMR2_AM0                   _CAN0IDMR2.Bits.AM0
#define CAN0IDMR2_AM1                   _CAN0IDMR2.Bits.AM1
#define CAN0IDMR2_AM2                   _CAN0IDMR2.Bits.AM2
#define CAN0IDMR2_AM3                   _CAN0IDMR2.Bits.AM3
#define CAN0IDMR2_AM4                   _CAN0IDMR2.Bits.AM4
#define CAN0IDMR2_AM5                   _CAN0IDMR2.Bits.AM5
#define CAN0IDMR2_AM6                   _CAN0IDMR2.Bits.AM6
#define CAN0IDMR2_AM7                   _CAN0IDMR2.Bits.AM7

#define CAN0IDMR2_AM0_MASK              1U
#define CAN0IDMR2_AM1_MASK              2U
#define CAN0IDMR2_AM2_MASK              4U
#define CAN0IDMR2_AM3_MASK              8U
#define CAN0IDMR2_AM4_MASK              16U
#define CAN0IDMR2_AM5_MASK              32U
#define CAN0IDMR2_AM6_MASK              64U
#define CAN0IDMR2_AM7_MASK              128U


/*** CAN0IDMR3 - MSCAN0 Identifier Mask Register 3; 0x00000157 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR3STR;
extern volatile CAN0IDMR3STR _CAN0IDMR3 @(REG_BASE + 0x00000157UL);
#define CAN0IDMR3                       _CAN0IDMR3.Byte
#define CAN0IDMR3_AM0                   _CAN0IDMR3.Bits.AM0
#define CAN0IDMR3_AM1                   _CAN0IDMR3.Bits.AM1
#define CAN0IDMR3_AM2                   _CAN0IDMR3.Bits.AM2
#define CAN0IDMR3_AM3                   _CAN0IDMR3.Bits.AM3
#define CAN0IDMR3_AM4                   _CAN0IDMR3.Bits.AM4
#define CAN0IDMR3_AM5                   _CAN0IDMR3.Bits.AM5
#define CAN0IDMR3_AM6                   _CAN0IDMR3.Bits.AM6
#define CAN0IDMR3_AM7                   _CAN0IDMR3.Bits.AM7

#define CAN0IDMR3_AM0_MASK              1U
#define CAN0IDMR3_AM1_MASK              2U
#define CAN0IDMR3_AM2_MASK              4U
#define CAN0IDMR3_AM3_MASK              8U
#define CAN0IDMR3_AM4_MASK              16U
#define CAN0IDMR3_AM5_MASK              32U
#define CAN0IDMR3_AM6_MASK              64U
#define CAN0IDMR3_AM7_MASK              128U


/*** CAN0IDAR4 - MSCAN0 Identifier Acceptance Register 4; 0x00000158 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR4STR;
extern volatile CAN0IDAR4STR _CAN0IDAR4 @(REG_BASE + 0x00000158UL);
#define CAN0IDAR4                       _CAN0IDAR4.Byte
#define CAN0IDAR4_AC0                   _CAN0IDAR4.Bits.AC0
#define CAN0IDAR4_AC1                   _CAN0IDAR4.Bits.AC1
#define CAN0IDAR4_AC2                   _CAN0IDAR4.Bits.AC2
#define CAN0IDAR4_AC3                   _CAN0IDAR4.Bits.AC3
#define CAN0IDAR4_AC4                   _CAN0IDAR4.Bits.AC4
#define CAN0IDAR4_AC5                   _CAN0IDAR4.Bits.AC5
#define CAN0IDAR4_AC6                   _CAN0IDAR4.Bits.AC6
#define CAN0IDAR4_AC7                   _CAN0IDAR4.Bits.AC7

#define CAN0IDAR4_AC0_MASK              1U
#define CAN0IDAR4_AC1_MASK              2U
#define CAN0IDAR4_AC2_MASK              4U
#define CAN0IDAR4_AC3_MASK              8U
#define CAN0IDAR4_AC4_MASK              16U
#define CAN0IDAR4_AC5_MASK              32U
#define CAN0IDAR4_AC6_MASK              64U
#define CAN0IDAR4_AC7_MASK              128U


/*** CAN0IDAR5 - MSCAN0 Identifier Acceptance Register 5; 0x00000159 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR5STR;
extern volatile CAN0IDAR5STR _CAN0IDAR5 @(REG_BASE + 0x00000159UL);
#define CAN0IDAR5                       _CAN0IDAR5.Byte
#define CAN0IDAR5_AC0                   _CAN0IDAR5.Bits.AC0
#define CAN0IDAR5_AC1                   _CAN0IDAR5.Bits.AC1
#define CAN0IDAR5_AC2                   _CAN0IDAR5.Bits.AC2
#define CAN0IDAR5_AC3                   _CAN0IDAR5.Bits.AC3
#define CAN0IDAR5_AC4                   _CAN0IDAR5.Bits.AC4
#define CAN0IDAR5_AC5                   _CAN0IDAR5.Bits.AC5
#define CAN0IDAR5_AC6                   _CAN0IDAR5.Bits.AC6
#define CAN0IDAR5_AC7                   _CAN0IDAR5.Bits.AC7

#define CAN0IDAR5_AC0_MASK              1U
#define CAN0IDAR5_AC1_MASK              2U
#define CAN0IDAR5_AC2_MASK              4U
#define CAN0IDAR5_AC3_MASK              8U
#define CAN0IDAR5_AC4_MASK              16U
#define CAN0IDAR5_AC5_MASK              32U
#define CAN0IDAR5_AC6_MASK              64U
#define CAN0IDAR5_AC7_MASK              128U


/*** CAN0IDAR6 - MSCAN0 Identifier Acceptance Register 6; 0x0000015A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR6STR;
extern volatile CAN0IDAR6STR _CAN0IDAR6 @(REG_BASE + 0x0000015AUL);
#define CAN0IDAR6                       _CAN0IDAR6.Byte
#define CAN0IDAR6_AC0                   _CAN0IDAR6.Bits.AC0
#define CAN0IDAR6_AC1                   _CAN0IDAR6.Bits.AC1
#define CAN0IDAR6_AC2                   _CAN0IDAR6.Bits.AC2
#define CAN0IDAR6_AC3                   _CAN0IDAR6.Bits.AC3
#define CAN0IDAR6_AC4                   _CAN0IDAR6.Bits.AC4
#define CAN0IDAR6_AC5                   _CAN0IDAR6.Bits.AC5
#define CAN0IDAR6_AC6                   _CAN0IDAR6.Bits.AC6
#define CAN0IDAR6_AC7                   _CAN0IDAR6.Bits.AC7

#define CAN0IDAR6_AC0_MASK              1U
#define CAN0IDAR6_AC1_MASK              2U
#define CAN0IDAR6_AC2_MASK              4U
#define CAN0IDAR6_AC3_MASK              8U
#define CAN0IDAR6_AC4_MASK              16U
#define CAN0IDAR6_AC5_MASK              32U
#define CAN0IDAR6_AC6_MASK              64U
#define CAN0IDAR6_AC7_MASK              128U


/*** CAN0IDAR7 - MSCAN0 Identifier Acceptance Register 7; 0x0000015B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR7STR;
extern volatile CAN0IDAR7STR _CAN0IDAR7 @(REG_BASE + 0x0000015BUL);
#define CAN0IDAR7                       _CAN0IDAR7.Byte
#define CAN0IDAR7_AC0                   _CAN0IDAR7.Bits.AC0
#define CAN0IDAR7_AC1                   _CAN0IDAR7.Bits.AC1
#define CAN0IDAR7_AC2                   _CAN0IDAR7.Bits.AC2
#define CAN0IDAR7_AC3                   _CAN0IDAR7.Bits.AC3
#define CAN0IDAR7_AC4                   _CAN0IDAR7.Bits.AC4
#define CAN0IDAR7_AC5                   _CAN0IDAR7.Bits.AC5
#define CAN0IDAR7_AC6                   _CAN0IDAR7.Bits.AC6
#define CAN0IDAR7_AC7                   _CAN0IDAR7.Bits.AC7

#define CAN0IDAR7_AC0_MASK              1U
#define CAN0IDAR7_AC1_MASK              2U
#define CAN0IDAR7_AC2_MASK              4U
#define CAN0IDAR7_AC3_MASK              8U
#define CAN0IDAR7_AC4_MASK              16U
#define CAN0IDAR7_AC5_MASK              32U
#define CAN0IDAR7_AC6_MASK              64U
#define CAN0IDAR7_AC7_MASK              128U


/*** CAN0IDMR4 - MSCAN0 Identifier Mask Register 4; 0x0000015C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR4STR;
extern volatile CAN0IDMR4STR _CAN0IDMR4 @(REG_BASE + 0x0000015CUL);
#define CAN0IDMR4                       _CAN0IDMR4.Byte
#define CAN0IDMR4_AM0                   _CAN0IDMR4.Bits.AM0
#define CAN0IDMR4_AM1                   _CAN0IDMR4.Bits.AM1
#define CAN0IDMR4_AM2                   _CAN0IDMR4.Bits.AM2
#define CAN0IDMR4_AM3                   _CAN0IDMR4.Bits.AM3
#define CAN0IDMR4_AM4                   _CAN0IDMR4.Bits.AM4
#define CAN0IDMR4_AM5                   _CAN0IDMR4.Bits.AM5
#define CAN0IDMR4_AM6                   _CAN0IDMR4.Bits.AM6
#define CAN0IDMR4_AM7                   _CAN0IDMR4.Bits.AM7

#define CAN0IDMR4_AM0_MASK              1U
#define CAN0IDMR4_AM1_MASK              2U
#define CAN0IDMR4_AM2_MASK              4U
#define CAN0IDMR4_AM3_MASK              8U
#define CAN0IDMR4_AM4_MASK              16U
#define CAN0IDMR4_AM5_MASK              32U
#define CAN0IDMR4_AM6_MASK              64U
#define CAN0IDMR4_AM7_MASK              128U


/*** CAN0IDMR5 - MSCAN0 Identifier Mask Register 5; 0x0000015D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR5STR;
extern volatile CAN0IDMR5STR _CAN0IDMR5 @(REG_BASE + 0x0000015DUL);
#define CAN0IDMR5                       _CAN0IDMR5.Byte
#define CAN0IDMR5_AM0                   _CAN0IDMR5.Bits.AM0
#define CAN0IDMR5_AM1                   _CAN0IDMR5.Bits.AM1
#define CAN0IDMR5_AM2                   _CAN0IDMR5.Bits.AM2
#define CAN0IDMR5_AM3                   _CAN0IDMR5.Bits.AM3
#define CAN0IDMR5_AM4                   _CAN0IDMR5.Bits.AM4
#define CAN0IDMR5_AM5                   _CAN0IDMR5.Bits.AM5
#define CAN0IDMR5_AM6                   _CAN0IDMR5.Bits.AM6
#define CAN0IDMR5_AM7                   _CAN0IDMR5.Bits.AM7

#define CAN0IDMR5_AM0_MASK              1U
#define CAN0IDMR5_AM1_MASK              2U
#define CAN0IDMR5_AM2_MASK              4U
#define CAN0IDMR5_AM3_MASK              8U
#define CAN0IDMR5_AM4_MASK              16U
#define CAN0IDMR5_AM5_MASK              32U
#define CAN0IDMR5_AM6_MASK              64U
#define CAN0IDMR5_AM7_MASK              128U


/*** CAN0IDMR6 - MSCAN0 Identifier Mask Register 6; 0x0000015E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR6STR;
extern volatile CAN0IDMR6STR _CAN0IDMR6 @(REG_BASE + 0x0000015EUL);
#define CAN0IDMR6                       _CAN0IDMR6.Byte
#define CAN0IDMR6_AM0                   _CAN0IDMR6.Bits.AM0
#define CAN0IDMR6_AM1                   _CAN0IDMR6.Bits.AM1
#define CAN0IDMR6_AM2                   _CAN0IDMR6.Bits.AM2
#define CAN0IDMR6_AM3                   _CAN0IDMR6.Bits.AM3
#define CAN0IDMR6_AM4                   _CAN0IDMR6.Bits.AM4
#define CAN0IDMR6_AM5                   _CAN0IDMR6.Bits.AM5
#define CAN0IDMR6_AM6                   _CAN0IDMR6.Bits.AM6
#define CAN0IDMR6_AM7                   _CAN0IDMR6.Bits.AM7

#define CAN0IDMR6_AM0_MASK              1U
#define CAN0IDMR6_AM1_MASK              2U
#define CAN0IDMR6_AM2_MASK              4U
#define CAN0IDMR6_AM3_MASK              8U
#define CAN0IDMR6_AM4_MASK              16U
#define CAN0IDMR6_AM5_MASK              32U
#define CAN0IDMR6_AM6_MASK              64U
#define CAN0IDMR6_AM7_MASK              128U


/*** CAN0IDMR7 - MSCAN0 Identifier Mask Register 7; 0x0000015F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR7STR;
extern volatile CAN0IDMR7STR _CAN0IDMR7 @(REG_BASE + 0x0000015FUL);
#define CAN0IDMR7                       _CAN0IDMR7.Byte
#define CAN0IDMR7_AM0                   _CAN0IDMR7.Bits.AM0
#define CAN0IDMR7_AM1                   _CAN0IDMR7.Bits.AM1
#define CAN0IDMR7_AM2                   _CAN0IDMR7.Bits.AM2
#define CAN0IDMR7_AM3                   _CAN0IDMR7.Bits.AM3
#define CAN0IDMR7_AM4                   _CAN0IDMR7.Bits.AM4
#define CAN0IDMR7_AM5                   _CAN0IDMR7.Bits.AM5
#define CAN0IDMR7_AM6                   _CAN0IDMR7.Bits.AM6
#define CAN0IDMR7_AM7                   _CAN0IDMR7.Bits.AM7

#define CAN0IDMR7_AM0_MASK              1U
#define CAN0IDMR7_AM1_MASK              2U
#define CAN0IDMR7_AM2_MASK              4U
#define CAN0IDMR7_AM3_MASK              8U
#define CAN0IDMR7_AM4_MASK              16U
#define CAN0IDMR7_AM5_MASK              32U
#define CAN0IDMR7_AM6_MASK              64U
#define CAN0IDMR7_AM7_MASK              128U


/*** CAN0RXIDR0 - MSCAN0 Receive Identifier Register 0; 0x00000160 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0RXIDR0STR;
extern volatile CAN0RXIDR0STR _CAN0RXIDR0 @(REG_BASE + 0x00000160UL);
#define CAN0RXIDR0                      _CAN0RXIDR0.Byte
#define CAN0RXIDR0_ID21                 _CAN0RXIDR0.Bits.ID21
#define CAN0RXIDR0_ID22                 _CAN0RXIDR0.Bits.ID22
#define CAN0RXIDR0_ID23                 _CAN0RXIDR0.Bits.ID23
#define CAN0RXIDR0_ID24                 _CAN0RXIDR0.Bits.ID24
#define CAN0RXIDR0_ID25                 _CAN0RXIDR0.Bits.ID25
#define CAN0RXIDR0_ID26                 _CAN0RXIDR0.Bits.ID26
#define CAN0RXIDR0_ID27                 _CAN0RXIDR0.Bits.ID27
#define CAN0RXIDR0_ID28                 _CAN0RXIDR0.Bits.ID28
/* CAN0RXIDR_ARR: Access 4 CAN0RXIDRx registers in an array */
#define CAN0RXIDR_ARR                   ((volatile byte *) &CAN0RXIDR0)

#define CAN0RXIDR0_ID21_MASK            1U
#define CAN0RXIDR0_ID22_MASK            2U
#define CAN0RXIDR0_ID23_MASK            4U
#define CAN0RXIDR0_ID24_MASK            8U
#define CAN0RXIDR0_ID25_MASK            16U
#define CAN0RXIDR0_ID26_MASK            32U
#define CAN0RXIDR0_ID27_MASK            64U
#define CAN0RXIDR0_ID28_MASK            128U


/*** CAN0RXIDR1 - MSCAN0 Receive Identifier Register 1; 0x00000161 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0RXIDR1STR;
extern volatile CAN0RXIDR1STR _CAN0RXIDR1 @(REG_BASE + 0x00000161UL);
#define CAN0RXIDR1                      _CAN0RXIDR1.Byte
#define CAN0RXIDR1_ID15                 _CAN0RXIDR1.Bits.ID15
#define CAN0RXIDR1_ID16                 _CAN0RXIDR1.Bits.ID16
#define CAN0RXIDR1_ID17                 _CAN0RXIDR1.Bits.ID17
#define CAN0RXIDR1_IDE                  _CAN0RXIDR1.Bits.IDE
#define CAN0RXIDR1_SRR                  _CAN0RXIDR1.Bits.SRR
#define CAN0RXIDR1_ID18                 _CAN0RXIDR1.Bits.ID18
#define CAN0RXIDR1_ID19                 _CAN0RXIDR1.Bits.ID19
#define CAN0RXIDR1_ID20                 _CAN0RXIDR1.Bits.ID20
#define CAN0RXIDR1_ID_15                _CAN0RXIDR1.MergedBits.grpID_15
#define CAN0RXIDR1_ID_18                _CAN0RXIDR1.MergedBits.grpID_18
#define CAN0RXIDR1_ID                   CAN0RXIDR1_ID_15

#define CAN0RXIDR1_ID15_MASK            1U
#define CAN0RXIDR1_ID16_MASK            2U
#define CAN0RXIDR1_ID17_MASK            4U
#define CAN0RXIDR1_IDE_MASK             8U
#define CAN0RXIDR1_SRR_MASK             16U
#define CAN0RXIDR1_ID18_MASK            32U
#define CAN0RXIDR1_ID19_MASK            64U
#define CAN0RXIDR1_ID20_MASK            128U
#define CAN0RXIDR1_ID_15_MASK           7U
#define CAN0RXIDR1_ID_15_BITNUM         0U
#define CAN0RXIDR1_ID_18_MASK           224U
#define CAN0RXIDR1_ID_18_BITNUM         5U


/*** CAN0RXIDR2 - MSCAN0 Receive Identifier Register 2; 0x00000162 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0RXIDR2STR;
extern volatile CAN0RXIDR2STR _CAN0RXIDR2 @(REG_BASE + 0x00000162UL);
#define CAN0RXIDR2                      _CAN0RXIDR2.Byte
#define CAN0RXIDR2_ID7                  _CAN0RXIDR2.Bits.ID7
#define CAN0RXIDR2_ID8                  _CAN0RXIDR2.Bits.ID8
#define CAN0RXIDR2_ID9                  _CAN0RXIDR2.Bits.ID9
#define CAN0RXIDR2_ID10                 _CAN0RXIDR2.Bits.ID10
#define CAN0RXIDR2_ID11                 _CAN0RXIDR2.Bits.ID11
#define CAN0RXIDR2_ID12                 _CAN0RXIDR2.Bits.ID12
#define CAN0RXIDR2_ID13                 _CAN0RXIDR2.Bits.ID13
#define CAN0RXIDR2_ID14                 _CAN0RXIDR2.Bits.ID14

#define CAN0RXIDR2_ID7_MASK             1U
#define CAN0RXIDR2_ID8_MASK             2U
#define CAN0RXIDR2_ID9_MASK             4U
#define CAN0RXIDR2_ID10_MASK            8U
#define CAN0RXIDR2_ID11_MASK            16U
#define CAN0RXIDR2_ID12_MASK            32U
#define CAN0RXIDR2_ID13_MASK            64U
#define CAN0RXIDR2_ID14_MASK            128U


/*** CAN0RXIDR3 - MSCAN0 Receive Identifier Register 3; 0x00000163 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0RXIDR3STR;
extern volatile CAN0RXIDR3STR _CAN0RXIDR3 @(REG_BASE + 0x00000163UL);
#define CAN0RXIDR3                      _CAN0RXIDR3.Byte
#define CAN0RXIDR3_RTR                  _CAN0RXIDR3.Bits.RTR
#define CAN0RXIDR3_ID0                  _CAN0RXIDR3.Bits.ID0
#define CAN0RXIDR3_ID1                  _CAN0RXIDR3.Bits.ID1
#define CAN0RXIDR3_ID2                  _CAN0RXIDR3.Bits.ID2
#define CAN0RXIDR3_ID3                  _CAN0RXIDR3.Bits.ID3
#define CAN0RXIDR3_ID4                  _CAN0RXIDR3.Bits.ID4
#define CAN0RXIDR3_ID5                  _CAN0RXIDR3.Bits.ID5
#define CAN0RXIDR3_ID6                  _CAN0RXIDR3.Bits.ID6
#define CAN0RXIDR3_ID                   _CAN0RXIDR3.MergedBits.grpID

#define CAN0RXIDR3_RTR_MASK             1U
#define CAN0RXIDR3_ID0_MASK             2U
#define CAN0RXIDR3_ID1_MASK             4U
#define CAN0RXIDR3_ID2_MASK             8U
#define CAN0RXIDR3_ID3_MASK             16U
#define CAN0RXIDR3_ID4_MASK             32U
#define CAN0RXIDR3_ID5_MASK             64U
#define CAN0RXIDR3_ID6_MASK             128U
#define CAN0RXIDR3_ID_MASK              254U
#define CAN0RXIDR3_ID_BITNUM            1U


/*** CAN0RXDSR0 - MSCAN0 Receive Data Segment Register 0; 0x00000164 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR0STR;
extern volatile CAN0RXDSR0STR _CAN0RXDSR0 @(REG_BASE + 0x00000164UL);
#define CAN0RXDSR0                      _CAN0RXDSR0.Byte
#define CAN0RXDSR0_DB0                  _CAN0RXDSR0.Bits.DB0
#define CAN0RXDSR0_DB1                  _CAN0RXDSR0.Bits.DB1
#define CAN0RXDSR0_DB2                  _CAN0RXDSR0.Bits.DB2
#define CAN0RXDSR0_DB3                  _CAN0RXDSR0.Bits.DB3
#define CAN0RXDSR0_DB4                  _CAN0RXDSR0.Bits.DB4
#define CAN0RXDSR0_DB5                  _CAN0RXDSR0.Bits.DB5
#define CAN0RXDSR0_DB6                  _CAN0RXDSR0.Bits.DB6
#define CAN0RXDSR0_DB7                  _CAN0RXDSR0.Bits.DB7
/* CAN0RXDSR_ARR: Access 8 CAN0RXDSRx registers in an array */
#define CAN0RXDSR_ARR                   ((volatile byte *) &CAN0RXDSR0)

#define CAN0RXDSR0_DB0_MASK             1U
#define CAN0RXDSR0_DB1_MASK             2U
#define CAN0RXDSR0_DB2_MASK             4U
#define CAN0RXDSR0_DB3_MASK             8U
#define CAN0RXDSR0_DB4_MASK             16U
#define CAN0RXDSR0_DB5_MASK             32U
#define CAN0RXDSR0_DB6_MASK             64U
#define CAN0RXDSR0_DB7_MASK             128U


/*** CAN0RXDSR1 - MSCAN0 Receive Data Segment Register 1; 0x00000165 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR1STR;
extern volatile CAN0RXDSR1STR _CAN0RXDSR1 @(REG_BASE + 0x00000165UL);
#define CAN0RXDSR1                      _CAN0RXDSR1.Byte
#define CAN0RXDSR1_DB0                  _CAN0RXDSR1.Bits.DB0
#define CAN0RXDSR1_DB1                  _CAN0RXDSR1.Bits.DB1
#define CAN0RXDSR1_DB2                  _CAN0RXDSR1.Bits.DB2
#define CAN0RXDSR1_DB3                  _CAN0RXDSR1.Bits.DB3
#define CAN0RXDSR1_DB4                  _CAN0RXDSR1.Bits.DB4
#define CAN0RXDSR1_DB5                  _CAN0RXDSR1.Bits.DB5
#define CAN0RXDSR1_DB6                  _CAN0RXDSR1.Bits.DB6
#define CAN0RXDSR1_DB7                  _CAN0RXDSR1.Bits.DB7

#define CAN0RXDSR1_DB0_MASK             1U
#define CAN0RXDSR1_DB1_MASK             2U
#define CAN0RXDSR1_DB2_MASK             4U
#define CAN0RXDSR1_DB3_MASK             8U
#define CAN0RXDSR1_DB4_MASK             16U
#define CAN0RXDSR1_DB5_MASK             32U
#define CAN0RXDSR1_DB6_MASK             64U
#define CAN0RXDSR1_DB7_MASK             128U


/*** CAN0RXDSR2 - MSCAN0 Receive Data Segment Register 2; 0x00000166 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR2STR;
extern volatile CAN0RXDSR2STR _CAN0RXDSR2 @(REG_BASE + 0x00000166UL);
#define CAN0RXDSR2                      _CAN0RXDSR2.Byte
#define CAN0RXDSR2_DB0                  _CAN0RXDSR2.Bits.DB0
#define CAN0RXDSR2_DB1                  _CAN0RXDSR2.Bits.DB1
#define CAN0RXDSR2_DB2                  _CAN0RXDSR2.Bits.DB2
#define CAN0RXDSR2_DB3                  _CAN0RXDSR2.Bits.DB3
#define CAN0RXDSR2_DB4                  _CAN0RXDSR2.Bits.DB4
#define CAN0RXDSR2_DB5                  _CAN0RXDSR2.Bits.DB5
#define CAN0RXDSR2_DB6                  _CAN0RXDSR2.Bits.DB6
#define CAN0RXDSR2_DB7                  _CAN0RXDSR2.Bits.DB7

#define CAN0RXDSR2_DB0_MASK             1U
#define CAN0RXDSR2_DB1_MASK             2U
#define CAN0RXDSR2_DB2_MASK             4U
#define CAN0RXDSR2_DB3_MASK             8U
#define CAN0RXDSR2_DB4_MASK             16U
#define CAN0RXDSR2_DB5_MASK             32U
#define CAN0RXDSR2_DB6_MASK             64U
#define CAN0RXDSR2_DB7_MASK             128U


/*** CAN0RXDSR3 - MSCAN0 Receive Data Segment Register 3; 0x00000167 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR3STR;
extern volatile CAN0RXDSR3STR _CAN0RXDSR3 @(REG_BASE + 0x00000167UL);
#define CAN0RXDSR3                      _CAN0RXDSR3.Byte
#define CAN0RXDSR3_DB0                  _CAN0RXDSR3.Bits.DB0
#define CAN0RXDSR3_DB1                  _CAN0RXDSR3.Bits.DB1
#define CAN0RXDSR3_DB2                  _CAN0RXDSR3.Bits.DB2
#define CAN0RXDSR3_DB3                  _CAN0RXDSR3.Bits.DB3
#define CAN0RXDSR3_DB4                  _CAN0RXDSR3.Bits.DB4
#define CAN0RXDSR3_DB5                  _CAN0RXDSR3.Bits.DB5
#define CAN0RXDSR3_DB6                  _CAN0RXDSR3.Bits.DB6
#define CAN0RXDSR3_DB7                  _CAN0RXDSR3.Bits.DB7

#define CAN0RXDSR3_DB0_MASK             1U
#define CAN0RXDSR3_DB1_MASK             2U
#define CAN0RXDSR3_DB2_MASK             4U
#define CAN0RXDSR3_DB3_MASK             8U
#define CAN0RXDSR3_DB4_MASK             16U
#define CAN0RXDSR3_DB5_MASK             32U
#define CAN0RXDSR3_DB6_MASK             64U
#define CAN0RXDSR3_DB7_MASK             128U


/*** CAN0RXDSR4 - MSCAN0 Receive Data Segment Register 4; 0x00000168 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR4STR;
extern volatile CAN0RXDSR4STR _CAN0RXDSR4 @(REG_BASE + 0x00000168UL);
#define CAN0RXDSR4                      _CAN0RXDSR4.Byte
#define CAN0RXDSR4_DB0                  _CAN0RXDSR4.Bits.DB0
#define CAN0RXDSR4_DB1                  _CAN0RXDSR4.Bits.DB1
#define CAN0RXDSR4_DB2                  _CAN0RXDSR4.Bits.DB2
#define CAN0RXDSR4_DB3                  _CAN0RXDSR4.Bits.DB3
#define CAN0RXDSR4_DB4                  _CAN0RXDSR4.Bits.DB4
#define CAN0RXDSR4_DB5                  _CAN0RXDSR4.Bits.DB5
#define CAN0RXDSR4_DB6                  _CAN0RXDSR4.Bits.DB6
#define CAN0RXDSR4_DB7                  _CAN0RXDSR4.Bits.DB7

#define CAN0RXDSR4_DB0_MASK             1U
#define CAN0RXDSR4_DB1_MASK             2U
#define CAN0RXDSR4_DB2_MASK             4U
#define CAN0RXDSR4_DB3_MASK             8U
#define CAN0RXDSR4_DB4_MASK             16U
#define CAN0RXDSR4_DB5_MASK             32U
#define CAN0RXDSR4_DB6_MASK             64U
#define CAN0RXDSR4_DB7_MASK             128U


/*** CAN0RXDSR5 - MSCAN0 Receive Data Segment Register 5; 0x00000169 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR5STR;
extern volatile CAN0RXDSR5STR _CAN0RXDSR5 @(REG_BASE + 0x00000169UL);
#define CAN0RXDSR5                      _CAN0RXDSR5.Byte
#define CAN0RXDSR5_DB0                  _CAN0RXDSR5.Bits.DB0
#define CAN0RXDSR5_DB1                  _CAN0RXDSR5.Bits.DB1
#define CAN0RXDSR5_DB2                  _CAN0RXDSR5.Bits.DB2
#define CAN0RXDSR5_DB3                  _CAN0RXDSR5.Bits.DB3
#define CAN0RXDSR5_DB4                  _CAN0RXDSR5.Bits.DB4
#define CAN0RXDSR5_DB5                  _CAN0RXDSR5.Bits.DB5
#define CAN0RXDSR5_DB6                  _CAN0RXDSR5.Bits.DB6
#define CAN0RXDSR5_DB7                  _CAN0RXDSR5.Bits.DB7

#define CAN0RXDSR5_DB0_MASK             1U
#define CAN0RXDSR5_DB1_MASK             2U
#define CAN0RXDSR5_DB2_MASK             4U
#define CAN0RXDSR5_DB3_MASK             8U
#define CAN0RXDSR5_DB4_MASK             16U
#define CAN0RXDSR5_DB5_MASK             32U
#define CAN0RXDSR5_DB6_MASK             64U
#define CAN0RXDSR5_DB7_MASK             128U


/*** CAN0RXDSR6 - MSCAN0 Receive Data Segment Register 6; 0x0000016A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR6STR;
extern volatile CAN0RXDSR6STR _CAN0RXDSR6 @(REG_BASE + 0x0000016AUL);
#define CAN0RXDSR6                      _CAN0RXDSR6.Byte
#define CAN0RXDSR6_DB0                  _CAN0RXDSR6.Bits.DB0
#define CAN0RXDSR6_DB1                  _CAN0RXDSR6.Bits.DB1
#define CAN0RXDSR6_DB2                  _CAN0RXDSR6.Bits.DB2
#define CAN0RXDSR6_DB3                  _CAN0RXDSR6.Bits.DB3
#define CAN0RXDSR6_DB4                  _CAN0RXDSR6.Bits.DB4
#define CAN0RXDSR6_DB5                  _CAN0RXDSR6.Bits.DB5
#define CAN0RXDSR6_DB6                  _CAN0RXDSR6.Bits.DB6
#define CAN0RXDSR6_DB7                  _CAN0RXDSR6.Bits.DB7

#define CAN0RXDSR6_DB0_MASK             1U
#define CAN0RXDSR6_DB1_MASK             2U
#define CAN0RXDSR6_DB2_MASK             4U
#define CAN0RXDSR6_DB3_MASK             8U
#define CAN0RXDSR6_DB4_MASK             16U
#define CAN0RXDSR6_DB5_MASK             32U
#define CAN0RXDSR6_DB6_MASK             64U
#define CAN0RXDSR6_DB7_MASK             128U


/*** CAN0RXDSR7 - MSCAN0 Receive Data Segment Register 7; 0x0000016B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR7STR;
extern volatile CAN0RXDSR7STR _CAN0RXDSR7 @(REG_BASE + 0x0000016BUL);
#define CAN0RXDSR7                      _CAN0RXDSR7.Byte
#define CAN0RXDSR7_DB0                  _CAN0RXDSR7.Bits.DB0
#define CAN0RXDSR7_DB1                  _CAN0RXDSR7.Bits.DB1
#define CAN0RXDSR7_DB2                  _CAN0RXDSR7.Bits.DB2
#define CAN0RXDSR7_DB3                  _CAN0RXDSR7.Bits.DB3
#define CAN0RXDSR7_DB4                  _CAN0RXDSR7.Bits.DB4
#define CAN0RXDSR7_DB5                  _CAN0RXDSR7.Bits.DB5
#define CAN0RXDSR7_DB6                  _CAN0RXDSR7.Bits.DB6
#define CAN0RXDSR7_DB7                  _CAN0RXDSR7.Bits.DB7

#define CAN0RXDSR7_DB0_MASK             1U
#define CAN0RXDSR7_DB1_MASK             2U
#define CAN0RXDSR7_DB2_MASK             4U
#define CAN0RXDSR7_DB3_MASK             8U
#define CAN0RXDSR7_DB4_MASK             16U
#define CAN0RXDSR7_DB5_MASK             32U
#define CAN0RXDSR7_DB6_MASK             64U
#define CAN0RXDSR7_DB7_MASK             128U


/*** CAN0RXDLR - MSCAN0 Receive Data Length Register; 0x0000016C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RXDLRSTR;
extern volatile CAN0RXDLRSTR _CAN0RXDLR @(REG_BASE + 0x0000016CUL);
#define CAN0RXDLR                       _CAN0RXDLR.Byte
#define CAN0RXDLR_DLC0                  _CAN0RXDLR.Bits.DLC0
#define CAN0RXDLR_DLC1                  _CAN0RXDLR.Bits.DLC1
#define CAN0RXDLR_DLC2                  _CAN0RXDLR.Bits.DLC2
#define CAN0RXDLR_DLC3                  _CAN0RXDLR.Bits.DLC3
#define CAN0RXDLR_DLC                   _CAN0RXDLR.MergedBits.grpDLC

#define CAN0RXDLR_DLC0_MASK             1U
#define CAN0RXDLR_DLC1_MASK             2U
#define CAN0RXDLR_DLC2_MASK             4U
#define CAN0RXDLR_DLC3_MASK             8U
#define CAN0RXDLR_DLC_MASK              15U
#define CAN0RXDLR_DLC_BITNUM            0U


/*** CAN0RXTSR - MSCAN0 Receive Time Stamp Register; 0x0000016E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0RXTSRH - MSCAN0 Receive Time Stamp Register High; 0x0000016E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0RXTSRHSTR;
    #define CAN0RXTSRH                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Byte
    #define CAN0RXTSRH_TSR8             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR8
    #define CAN0RXTSRH_TSR9             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR9
    #define CAN0RXTSRH_TSR10            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR10
    #define CAN0RXTSRH_TSR11            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR11
    #define CAN0RXTSRH_TSR12            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR12
    #define CAN0RXTSRH_TSR13            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR13
    #define CAN0RXTSRH_TSR14            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR14
    #define CAN0RXTSRH_TSR15            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR15
    
    #define CAN0RXTSRH_TSR8_MASK        1U
    #define CAN0RXTSRH_TSR9_MASK        2U
    #define CAN0RXTSRH_TSR10_MASK       4U
    #define CAN0RXTSRH_TSR11_MASK       8U
    #define CAN0RXTSRH_TSR12_MASK       16U
    #define CAN0RXTSRH_TSR13_MASK       32U
    #define CAN0RXTSRH_TSR14_MASK       64U
    #define CAN0RXTSRH_TSR15_MASK       128U
    

    /*** CAN0RXTSRL - MSCAN0 Receive Time Stamp Register Low; 0x0000016F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0RXTSRLSTR;
    #define CAN0RXTSRL                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Byte
    #define CAN0RXTSRL_TSR0             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR0
    #define CAN0RXTSRL_TSR1             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR1
    #define CAN0RXTSRL_TSR2             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR2
    #define CAN0RXTSRL_TSR3             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR3
    #define CAN0RXTSRL_TSR4             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR4
    #define CAN0RXTSRL_TSR5             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR5
    #define CAN0RXTSRL_TSR6             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR6
    #define CAN0RXTSRL_TSR7             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR7
    
    #define CAN0RXTSRL_TSR0_MASK        1U
    #define CAN0RXTSRL_TSR1_MASK        2U
    #define CAN0RXTSRL_TSR2_MASK        4U
    #define CAN0RXTSRL_TSR3_MASK        8U
    #define CAN0RXTSRL_TSR4_MASK        16U
    #define CAN0RXTSRL_TSR5_MASK        32U
    #define CAN0RXTSRL_TSR6_MASK        64U
    #define CAN0RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0RXTSRSTR;
extern volatile CAN0RXTSRSTR _CAN0RXTSR @(REG_BASE + 0x0000016EUL);
#define CAN0RXTSR                       _CAN0RXTSR.Word
#define CAN0RXTSR_TSR0                  _CAN0RXTSR.Bits.TSR0
#define CAN0RXTSR_TSR1                  _CAN0RXTSR.Bits.TSR1
#define CAN0RXTSR_TSR2                  _CAN0RXTSR.Bits.TSR2
#define CAN0RXTSR_TSR3                  _CAN0RXTSR.Bits.TSR3
#define CAN0RXTSR_TSR4                  _CAN0RXTSR.Bits.TSR4
#define CAN0RXTSR_TSR5                  _CAN0RXTSR.Bits.TSR5
#define CAN0RXTSR_TSR6                  _CAN0RXTSR.Bits.TSR6
#define CAN0RXTSR_TSR7                  _CAN0RXTSR.Bits.TSR7
#define CAN0RXTSR_TSR8                  _CAN0RXTSR.Bits.TSR8
#define CAN0RXTSR_TSR9                  _CAN0RXTSR.Bits.TSR9
#define CAN0RXTSR_TSR10                 _CAN0RXTSR.Bits.TSR10
#define CAN0RXTSR_TSR11                 _CAN0RXTSR.Bits.TSR11
#define CAN0RXTSR_TSR12                 _CAN0RXTSR.Bits.TSR12
#define CAN0RXTSR_TSR13                 _CAN0RXTSR.Bits.TSR13
#define CAN0RXTSR_TSR14                 _CAN0RXTSR.Bits.TSR14
#define CAN0RXTSR_TSR15                 _CAN0RXTSR.Bits.TSR15

#define CAN0RXTSR_TSR0_MASK             1U
#define CAN0RXTSR_TSR1_MASK             2U
#define CAN0RXTSR_TSR2_MASK             4U
#define CAN0RXTSR_TSR3_MASK             8U
#define CAN0RXTSR_TSR4_MASK             16U
#define CAN0RXTSR_TSR5_MASK             32U
#define CAN0RXTSR_TSR6_MASK             64U
#define CAN0RXTSR_TSR7_MASK             128U
#define CAN0RXTSR_TSR8_MASK             256U
#define CAN0RXTSR_TSR9_MASK             512U
#define CAN0RXTSR_TSR10_MASK            1024U
#define CAN0RXTSR_TSR11_MASK            2048U
#define CAN0RXTSR_TSR12_MASK            4096U
#define CAN0RXTSR_TSR13_MASK            8192U
#define CAN0RXTSR_TSR14_MASK            16384U
#define CAN0RXTSR_TSR15_MASK            32768U


/*** CAN0TXIDR0 - MSCAN0 Transmit Identifier Register 0; 0x00000170 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0TXIDR0STR;
extern volatile CAN0TXIDR0STR _CAN0TXIDR0 @(REG_BASE + 0x00000170UL);
#define CAN0TXIDR0                      _CAN0TXIDR0.Byte
#define CAN0TXIDR0_ID21                 _CAN0TXIDR0.Bits.ID21
#define CAN0TXIDR0_ID22                 _CAN0TXIDR0.Bits.ID22
#define CAN0TXIDR0_ID23                 _CAN0TXIDR0.Bits.ID23
#define CAN0TXIDR0_ID24                 _CAN0TXIDR0.Bits.ID24
#define CAN0TXIDR0_ID25                 _CAN0TXIDR0.Bits.ID25
#define CAN0TXIDR0_ID26                 _CAN0TXIDR0.Bits.ID26
#define CAN0TXIDR0_ID27                 _CAN0TXIDR0.Bits.ID27
#define CAN0TXIDR0_ID28                 _CAN0TXIDR0.Bits.ID28
/* CAN0TXIDR_ARR: Access 4 CAN0TXIDRx registers in an array */
#define CAN0TXIDR_ARR                   ((volatile byte *) &CAN0TXIDR0)

#define CAN0TXIDR0_ID21_MASK            1U
#define CAN0TXIDR0_ID22_MASK            2U
#define CAN0TXIDR0_ID23_MASK            4U
#define CAN0TXIDR0_ID24_MASK            8U
#define CAN0TXIDR0_ID25_MASK            16U
#define CAN0TXIDR0_ID26_MASK            32U
#define CAN0TXIDR0_ID27_MASK            64U
#define CAN0TXIDR0_ID28_MASK            128U


/*** CAN0TXIDR1 - MSCAN0 Transmit Identifier Register 1; 0x00000171 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0TXIDR1STR;
extern volatile CAN0TXIDR1STR _CAN0TXIDR1 @(REG_BASE + 0x00000171UL);
#define CAN0TXIDR1                      _CAN0TXIDR1.Byte
#define CAN0TXIDR1_ID15                 _CAN0TXIDR1.Bits.ID15
#define CAN0TXIDR1_ID16                 _CAN0TXIDR1.Bits.ID16
#define CAN0TXIDR1_ID17                 _CAN0TXIDR1.Bits.ID17
#define CAN0TXIDR1_IDE                  _CAN0TXIDR1.Bits.IDE
#define CAN0TXIDR1_SRR                  _CAN0TXIDR1.Bits.SRR
#define CAN0TXIDR1_ID18                 _CAN0TXIDR1.Bits.ID18
#define CAN0TXIDR1_ID19                 _CAN0TXIDR1.Bits.ID19
#define CAN0TXIDR1_ID20                 _CAN0TXIDR1.Bits.ID20
#define CAN0TXIDR1_ID_15                _CAN0TXIDR1.MergedBits.grpID_15
#define CAN0TXIDR1_ID_18                _CAN0TXIDR1.MergedBits.grpID_18
#define CAN0TXIDR1_ID                   CAN0TXIDR1_ID_15

#define CAN0TXIDR1_ID15_MASK            1U
#define CAN0TXIDR1_ID16_MASK            2U
#define CAN0TXIDR1_ID17_MASK            4U
#define CAN0TXIDR1_IDE_MASK             8U
#define CAN0TXIDR1_SRR_MASK             16U
#define CAN0TXIDR1_ID18_MASK            32U
#define CAN0TXIDR1_ID19_MASK            64U
#define CAN0TXIDR1_ID20_MASK            128U
#define CAN0TXIDR1_ID_15_MASK           7U
#define CAN0TXIDR1_ID_15_BITNUM         0U
#define CAN0TXIDR1_ID_18_MASK           224U
#define CAN0TXIDR1_ID_18_BITNUM         5U


/*** CAN0TXIDR2 - MSCAN0 Transmit Identifier Register 2; 0x00000172 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0TXIDR2STR;
extern volatile CAN0TXIDR2STR _CAN0TXIDR2 @(REG_BASE + 0x00000172UL);
#define CAN0TXIDR2                      _CAN0TXIDR2.Byte
#define CAN0TXIDR2_ID7                  _CAN0TXIDR2.Bits.ID7
#define CAN0TXIDR2_ID8                  _CAN0TXIDR2.Bits.ID8
#define CAN0TXIDR2_ID9                  _CAN0TXIDR2.Bits.ID9
#define CAN0TXIDR2_ID10                 _CAN0TXIDR2.Bits.ID10
#define CAN0TXIDR2_ID11                 _CAN0TXIDR2.Bits.ID11
#define CAN0TXIDR2_ID12                 _CAN0TXIDR2.Bits.ID12
#define CAN0TXIDR2_ID13                 _CAN0TXIDR2.Bits.ID13
#define CAN0TXIDR2_ID14                 _CAN0TXIDR2.Bits.ID14

#define CAN0TXIDR2_ID7_MASK             1U
#define CAN0TXIDR2_ID8_MASK             2U
#define CAN0TXIDR2_ID9_MASK             4U
#define CAN0TXIDR2_ID10_MASK            8U
#define CAN0TXIDR2_ID11_MASK            16U
#define CAN0TXIDR2_ID12_MASK            32U
#define CAN0TXIDR2_ID13_MASK            64U
#define CAN0TXIDR2_ID14_MASK            128U


/*** CAN0TXIDR3 - MSCAN0 Transmit Identifier Register 3; 0x00000173 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0TXIDR3STR;
extern volatile CAN0TXIDR3STR _CAN0TXIDR3 @(REG_BASE + 0x00000173UL);
#define CAN0TXIDR3                      _CAN0TXIDR3.Byte
#define CAN0TXIDR3_RTR                  _CAN0TXIDR3.Bits.RTR
#define CAN0TXIDR3_ID0                  _CAN0TXIDR3.Bits.ID0
#define CAN0TXIDR3_ID1                  _CAN0TXIDR3.Bits.ID1
#define CAN0TXIDR3_ID2                  _CAN0TXIDR3.Bits.ID2
#define CAN0TXIDR3_ID3                  _CAN0TXIDR3.Bits.ID3
#define CAN0TXIDR3_ID4                  _CAN0TXIDR3.Bits.ID4
#define CAN0TXIDR3_ID5                  _CAN0TXIDR3.Bits.ID5
#define CAN0TXIDR3_ID6                  _CAN0TXIDR3.Bits.ID6
#define CAN0TXIDR3_ID                   _CAN0TXIDR3.MergedBits.grpID

#define CAN0TXIDR3_RTR_MASK             1U
#define CAN0TXIDR3_ID0_MASK             2U
#define CAN0TXIDR3_ID1_MASK             4U
#define CAN0TXIDR3_ID2_MASK             8U
#define CAN0TXIDR3_ID3_MASK             16U
#define CAN0TXIDR3_ID4_MASK             32U
#define CAN0TXIDR3_ID5_MASK             64U
#define CAN0TXIDR3_ID6_MASK             128U
#define CAN0TXIDR3_ID_MASK              254U
#define CAN0TXIDR3_ID_BITNUM            1U


/*** CAN0TXDSR0 - MSCAN0 Transmit Data Segment Register 0; 0x00000174 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR0STR;
extern volatile CAN0TXDSR0STR _CAN0TXDSR0 @(REG_BASE + 0x00000174UL);
#define CAN0TXDSR0                      _CAN0TXDSR0.Byte
#define CAN0TXDSR0_DB0                  _CAN0TXDSR0.Bits.DB0
#define CAN0TXDSR0_DB1                  _CAN0TXDSR0.Bits.DB1
#define CAN0TXDSR0_DB2                  _CAN0TXDSR0.Bits.DB2
#define CAN0TXDSR0_DB3                  _CAN0TXDSR0.Bits.DB3
#define CAN0TXDSR0_DB4                  _CAN0TXDSR0.Bits.DB4
#define CAN0TXDSR0_DB5                  _CAN0TXDSR0.Bits.DB5
#define CAN0TXDSR0_DB6                  _CAN0TXDSR0.Bits.DB6
#define CAN0TXDSR0_DB7                  _CAN0TXDSR0.Bits.DB7
/* CAN0TXDSR_ARR: Access 8 CAN0TXDSRx registers in an array */
#define CAN0TXDSR_ARR                   ((volatile byte *) &CAN0TXDSR0)

#define CAN0TXDSR0_DB0_MASK             1U
#define CAN0TXDSR0_DB1_MASK             2U
#define CAN0TXDSR0_DB2_MASK             4U
#define CAN0TXDSR0_DB3_MASK             8U
#define CAN0TXDSR0_DB4_MASK             16U
#define CAN0TXDSR0_DB5_MASK             32U
#define CAN0TXDSR0_DB6_MASK             64U
#define CAN0TXDSR0_DB7_MASK             128U


/*** CAN0TXDSR1 - MSCAN0 Transmit Data Segment Register 1; 0x00000175 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR1STR;
extern volatile CAN0TXDSR1STR _CAN0TXDSR1 @(REG_BASE + 0x00000175UL);
#define CAN0TXDSR1                      _CAN0TXDSR1.Byte
#define CAN0TXDSR1_DB0                  _CAN0TXDSR1.Bits.DB0
#define CAN0TXDSR1_DB1                  _CAN0TXDSR1.Bits.DB1
#define CAN0TXDSR1_DB2                  _CAN0TXDSR1.Bits.DB2
#define CAN0TXDSR1_DB3                  _CAN0TXDSR1.Bits.DB3
#define CAN0TXDSR1_DB4                  _CAN0TXDSR1.Bits.DB4
#define CAN0TXDSR1_DB5                  _CAN0TXDSR1.Bits.DB5
#define CAN0TXDSR1_DB6                  _CAN0TXDSR1.Bits.DB6
#define CAN0TXDSR1_DB7                  _CAN0TXDSR1.Bits.DB7

#define CAN0TXDSR1_DB0_MASK             1U
#define CAN0TXDSR1_DB1_MASK             2U
#define CAN0TXDSR1_DB2_MASK             4U
#define CAN0TXDSR1_DB3_MASK             8U
#define CAN0TXDSR1_DB4_MASK             16U
#define CAN0TXDSR1_DB5_MASK             32U
#define CAN0TXDSR1_DB6_MASK             64U
#define CAN0TXDSR1_DB7_MASK             128U


/*** CAN0TXDSR2 - MSCAN0 Transmit Data Segment Register 2; 0x00000176 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR2STR;
extern volatile CAN0TXDSR2STR _CAN0TXDSR2 @(REG_BASE + 0x00000176UL);
#define CAN0TXDSR2                      _CAN0TXDSR2.Byte
#define CAN0TXDSR2_DB0                  _CAN0TXDSR2.Bits.DB0
#define CAN0TXDSR2_DB1                  _CAN0TXDSR2.Bits.DB1
#define CAN0TXDSR2_DB2                  _CAN0TXDSR2.Bits.DB2
#define CAN0TXDSR2_DB3                  _CAN0TXDSR2.Bits.DB3
#define CAN0TXDSR2_DB4                  _CAN0TXDSR2.Bits.DB4
#define CAN0TXDSR2_DB5                  _CAN0TXDSR2.Bits.DB5
#define CAN0TXDSR2_DB6                  _CAN0TXDSR2.Bits.DB6
#define CAN0TXDSR2_DB7                  _CAN0TXDSR2.Bits.DB7

#define CAN0TXDSR2_DB0_MASK             1U
#define CAN0TXDSR2_DB1_MASK             2U
#define CAN0TXDSR2_DB2_MASK             4U
#define CAN0TXDSR2_DB3_MASK             8U
#define CAN0TXDSR2_DB4_MASK             16U
#define CAN0TXDSR2_DB5_MASK             32U
#define CAN0TXDSR2_DB6_MASK             64U
#define CAN0TXDSR2_DB7_MASK             128U


/*** CAN0TXDSR3 - MSCAN0 Transmit Data Segment Register 3; 0x00000177 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR3STR;
extern volatile CAN0TXDSR3STR _CAN0TXDSR3 @(REG_BASE + 0x00000177UL);
#define CAN0TXDSR3                      _CAN0TXDSR3.Byte
#define CAN0TXDSR3_DB0                  _CAN0TXDSR3.Bits.DB0
#define CAN0TXDSR3_DB1                  _CAN0TXDSR3.Bits.DB1
#define CAN0TXDSR3_DB2                  _CAN0TXDSR3.Bits.DB2
#define CAN0TXDSR3_DB3                  _CAN0TXDSR3.Bits.DB3
#define CAN0TXDSR3_DB4                  _CAN0TXDSR3.Bits.DB4
#define CAN0TXDSR3_DB5                  _CAN0TXDSR3.Bits.DB5
#define CAN0TXDSR3_DB6                  _CAN0TXDSR3.Bits.DB6
#define CAN0TXDSR3_DB7                  _CAN0TXDSR3.Bits.DB7

#define CAN0TXDSR3_DB0_MASK             1U
#define CAN0TXDSR3_DB1_MASK             2U
#define CAN0TXDSR3_DB2_MASK             4U
#define CAN0TXDSR3_DB3_MASK             8U
#define CAN0TXDSR3_DB4_MASK             16U
#define CAN0TXDSR3_DB5_MASK             32U
#define CAN0TXDSR3_DB6_MASK             64U
#define CAN0TXDSR3_DB7_MASK             128U


/*** CAN0TXDSR4 - MSCAN0 Transmit Data Segment Register 4; 0x00000178 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR4STR;
extern volatile CAN0TXDSR4STR _CAN0TXDSR4 @(REG_BASE + 0x00000178UL);
#define CAN0TXDSR4                      _CAN0TXDSR4.Byte
#define CAN0TXDSR4_DB0                  _CAN0TXDSR4.Bits.DB0
#define CAN0TXDSR4_DB1                  _CAN0TXDSR4.Bits.DB1
#define CAN0TXDSR4_DB2                  _CAN0TXDSR4.Bits.DB2
#define CAN0TXDSR4_DB3                  _CAN0TXDSR4.Bits.DB3
#define CAN0TXDSR4_DB4                  _CAN0TXDSR4.Bits.DB4
#define CAN0TXDSR4_DB5                  _CAN0TXDSR4.Bits.DB5
#define CAN0TXDSR4_DB6                  _CAN0TXDSR4.Bits.DB6
#define CAN0TXDSR4_DB7                  _CAN0TXDSR4.Bits.DB7

#define CAN0TXDSR4_DB0_MASK             1U
#define CAN0TXDSR4_DB1_MASK             2U
#define CAN0TXDSR4_DB2_MASK             4U
#define CAN0TXDSR4_DB3_MASK             8U
#define CAN0TXDSR4_DB4_MASK             16U
#define CAN0TXDSR4_DB5_MASK             32U
#define CAN0TXDSR4_DB6_MASK             64U
#define CAN0TXDSR4_DB7_MASK             128U


/*** CAN0TXDSR5 - MSCAN0 Transmit Data Segment Register 5; 0x00000179 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR5STR;
extern volatile CAN0TXDSR5STR _CAN0TXDSR5 @(REG_BASE + 0x00000179UL);
#define CAN0TXDSR5                      _CAN0TXDSR5.Byte
#define CAN0TXDSR5_DB0                  _CAN0TXDSR5.Bits.DB0
#define CAN0TXDSR5_DB1                  _CAN0TXDSR5.Bits.DB1
#define CAN0TXDSR5_DB2                  _CAN0TXDSR5.Bits.DB2
#define CAN0TXDSR5_DB3                  _CAN0TXDSR5.Bits.DB3
#define CAN0TXDSR5_DB4                  _CAN0TXDSR5.Bits.DB4
#define CAN0TXDSR5_DB5                  _CAN0TXDSR5.Bits.DB5
#define CAN0TXDSR5_DB6                  _CAN0TXDSR5.Bits.DB6
#define CAN0TXDSR5_DB7                  _CAN0TXDSR5.Bits.DB7

#define CAN0TXDSR5_DB0_MASK             1U
#define CAN0TXDSR5_DB1_MASK             2U
#define CAN0TXDSR5_DB2_MASK             4U
#define CAN0TXDSR5_DB3_MASK             8U
#define CAN0TXDSR5_DB4_MASK             16U
#define CAN0TXDSR5_DB5_MASK             32U
#define CAN0TXDSR5_DB6_MASK             64U
#define CAN0TXDSR5_DB7_MASK             128U


/*** CAN0TXDSR6 - MSCAN0 Transmit Data Segment Register 6; 0x0000017A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR6STR;
extern volatile CAN0TXDSR6STR _CAN0TXDSR6 @(REG_BASE + 0x0000017AUL);
#define CAN0TXDSR6                      _CAN0TXDSR6.Byte
#define CAN0TXDSR6_DB0                  _CAN0TXDSR6.Bits.DB0
#define CAN0TXDSR6_DB1                  _CAN0TXDSR6.Bits.DB1
#define CAN0TXDSR6_DB2                  _CAN0TXDSR6.Bits.DB2
#define CAN0TXDSR6_DB3                  _CAN0TXDSR6.Bits.DB3
#define CAN0TXDSR6_DB4                  _CAN0TXDSR6.Bits.DB4
#define CAN0TXDSR6_DB5                  _CAN0TXDSR6.Bits.DB5
#define CAN0TXDSR6_DB6                  _CAN0TXDSR6.Bits.DB6
#define CAN0TXDSR6_DB7                  _CAN0TXDSR6.Bits.DB7

#define CAN0TXDSR6_DB0_MASK             1U
#define CAN0TXDSR6_DB1_MASK             2U
#define CAN0TXDSR6_DB2_MASK             4U
#define CAN0TXDSR6_DB3_MASK             8U
#define CAN0TXDSR6_DB4_MASK             16U
#define CAN0TXDSR6_DB5_MASK             32U
#define CAN0TXDSR6_DB6_MASK             64U
#define CAN0TXDSR6_DB7_MASK             128U


/*** CAN0TXDSR7 - MSCAN0 Transmit Data Segment Register 7; 0x0000017B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR7STR;
extern volatile CAN0TXDSR7STR _CAN0TXDSR7 @(REG_BASE + 0x0000017BUL);
#define CAN0TXDSR7                      _CAN0TXDSR7.Byte
#define CAN0TXDSR7_DB0                  _CAN0TXDSR7.Bits.DB0
#define CAN0TXDSR7_DB1                  _CAN0TXDSR7.Bits.DB1
#define CAN0TXDSR7_DB2                  _CAN0TXDSR7.Bits.DB2
#define CAN0TXDSR7_DB3                  _CAN0TXDSR7.Bits.DB3
#define CAN0TXDSR7_DB4                  _CAN0TXDSR7.Bits.DB4
#define CAN0TXDSR7_DB5                  _CAN0TXDSR7.Bits.DB5
#define CAN0TXDSR7_DB6                  _CAN0TXDSR7.Bits.DB6
#define CAN0TXDSR7_DB7                  _CAN0TXDSR7.Bits.DB7

#define CAN0TXDSR7_DB0_MASK             1U
#define CAN0TXDSR7_DB1_MASK             2U
#define CAN0TXDSR7_DB2_MASK             4U
#define CAN0TXDSR7_DB3_MASK             8U
#define CAN0TXDSR7_DB4_MASK             16U
#define CAN0TXDSR7_DB5_MASK             32U
#define CAN0TXDSR7_DB6_MASK             64U
#define CAN0TXDSR7_DB7_MASK             128U


/*** CAN0TXDLR - MSCAN0 Transmit Data Length Register; 0x0000017C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TXDLRSTR;
extern volatile CAN0TXDLRSTR _CAN0TXDLR @(REG_BASE + 0x0000017CUL);
#define CAN0TXDLR                       _CAN0TXDLR.Byte
#define CAN0TXDLR_DLC0                  _CAN0TXDLR.Bits.DLC0
#define CAN0TXDLR_DLC1                  _CAN0TXDLR.Bits.DLC1
#define CAN0TXDLR_DLC2                  _CAN0TXDLR.Bits.DLC2
#define CAN0TXDLR_DLC3                  _CAN0TXDLR.Bits.DLC3
#define CAN0TXDLR_DLC                   _CAN0TXDLR.MergedBits.grpDLC

#define CAN0TXDLR_DLC0_MASK             1U
#define CAN0TXDLR_DLC1_MASK             2U
#define CAN0TXDLR_DLC2_MASK             4U
#define CAN0TXDLR_DLC3_MASK             8U
#define CAN0TXDLR_DLC_MASK              15U
#define CAN0TXDLR_DLC_BITNUM            0U


/*** CAN0TXTBPR - MSCAN0 Transmit Buffer Priority; 0x0000017D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN0TXTBPRSTR;
extern volatile CAN0TXTBPRSTR _CAN0TXTBPR @(REG_BASE + 0x0000017DUL);
#define CAN0TXTBPR                      _CAN0TXTBPR.Byte
#define CAN0TXTBPR_PRIO0                _CAN0TXTBPR.Bits.PRIO0
#define CAN0TXTBPR_PRIO1                _CAN0TXTBPR.Bits.PRIO1
#define CAN0TXTBPR_PRIO2                _CAN0TXTBPR.Bits.PRIO2
#define CAN0TXTBPR_PRIO3                _CAN0TXTBPR.Bits.PRIO3
#define CAN0TXTBPR_PRIO4                _CAN0TXTBPR.Bits.PRIO4
#define CAN0TXTBPR_PRIO5                _CAN0TXTBPR.Bits.PRIO5
#define CAN0TXTBPR_PRIO6                _CAN0TXTBPR.Bits.PRIO6
#define CAN0TXTBPR_PRIO7                _CAN0TXTBPR.Bits.PRIO7

#define CAN0TXTBPR_PRIO0_MASK           1U
#define CAN0TXTBPR_PRIO1_MASK           2U
#define CAN0TXTBPR_PRIO2_MASK           4U
#define CAN0TXTBPR_PRIO3_MASK           8U
#define CAN0TXTBPR_PRIO4_MASK           16U
#define CAN0TXTBPR_PRIO5_MASK           32U
#define CAN0TXTBPR_PRIO6_MASK           64U
#define CAN0TXTBPR_PRIO7_MASK           128U


/*** CAN0TXTSR - MSCAN0 Transmit Time Stamp Register; 0x0000017E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0TXTSRH - MSCAN0 Transmit Time Stamp Register High; 0x0000017E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0TXTSRHSTR;
    #define CAN0TXTSRH                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Byte
    #define CAN0TXTSRH_TSR8             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR8
    #define CAN0TXTSRH_TSR9             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR9
    #define CAN0TXTSRH_TSR10            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR10
    #define CAN0TXTSRH_TSR11            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR11
    #define CAN0TXTSRH_TSR12            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR12
    #define CAN0TXTSRH_TSR13            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR13
    #define CAN0TXTSRH_TSR14            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR14
    #define CAN0TXTSRH_TSR15            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR15
    
    #define CAN0TXTSRH_TSR8_MASK        1U
    #define CAN0TXTSRH_TSR9_MASK        2U
    #define CAN0TXTSRH_TSR10_MASK       4U
    #define CAN0TXTSRH_TSR11_MASK       8U
    #define CAN0TXTSRH_TSR12_MASK       16U
    #define CAN0TXTSRH_TSR13_MASK       32U
    #define CAN0TXTSRH_TSR14_MASK       64U
    #define CAN0TXTSRH_TSR15_MASK       128U
    

    /*** CAN0TXTSRL - MSCAN0 Transmit Time Stamp Register Low; 0x0000017F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0TXTSRLSTR;
    #define CAN0TXTSRL                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Byte
    #define CAN0TXTSRL_TSR0             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR0
    #define CAN0TXTSRL_TSR1             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR1
    #define CAN0TXTSRL_TSR2             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR2
    #define CAN0TXTSRL_TSR3             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR3
    #define CAN0TXTSRL_TSR4             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR4
    #define CAN0TXTSRL_TSR5             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR5
    #define CAN0TXTSRL_TSR6             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR6
    #define CAN0TXTSRL_TSR7             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR7
    
    #define CAN0TXTSRL_TSR0_MASK        1U
    #define CAN0TXTSRL_TSR1_MASK        2U
    #define CAN0TXTSRL_TSR2_MASK        4U
    #define CAN0TXTSRL_TSR3_MASK        8U
    #define CAN0TXTSRL_TSR4_MASK        16U
    #define CAN0TXTSRL_TSR5_MASK        32U
    #define CAN0TXTSRL_TSR6_MASK        64U
    #define CAN0TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0TXTSRSTR;
extern volatile CAN0TXTSRSTR _CAN0TXTSR @(REG_BASE + 0x0000017EUL);
#define CAN0TXTSR                       _CAN0TXTSR.Word
#define CAN0TXTSR_TSR0                  _CAN0TXTSR.Bits.TSR0
#define CAN0TXTSR_TSR1                  _CAN0TXTSR.Bits.TSR1
#define CAN0TXTSR_TSR2                  _CAN0TXTSR.Bits.TSR2
#define CAN0TXTSR_TSR3                  _CAN0TXTSR.Bits.TSR3
#define CAN0TXTSR_TSR4                  _CAN0TXTSR.Bits.TSR4
#define CAN0TXTSR_TSR5                  _CAN0TXTSR.Bits.TSR5
#define CAN0TXTSR_TSR6                  _CAN0TXTSR.Bits.TSR6
#define CAN0TXTSR_TSR7                  _CAN0TXTSR.Bits.TSR7
#define CAN0TXTSR_TSR8                  _CAN0TXTSR.Bits.TSR8
#define CAN0TXTSR_TSR9                  _CAN0TXTSR.Bits.TSR9
#define CAN0TXTSR_TSR10                 _CAN0TXTSR.Bits.TSR10
#define CAN0TXTSR_TSR11                 _CAN0TXTSR.Bits.TSR11
#define CAN0TXTSR_TSR12                 _CAN0TXTSR.Bits.TSR12
#define CAN0TXTSR_TSR13                 _CAN0TXTSR.Bits.TSR13
#define CAN0TXTSR_TSR14                 _CAN0TXTSR.Bits.TSR14
#define CAN0TXTSR_TSR15                 _CAN0TXTSR.Bits.TSR15

#define CAN0TXTSR_TSR0_MASK             1U
#define CAN0TXTSR_TSR1_MASK             2U
#define CAN0TXTSR_TSR2_MASK             4U
#define CAN0TXTSR_TSR3_MASK             8U
#define CAN0TXTSR_TSR4_MASK             16U
#define CAN0TXTSR_TSR5_MASK             32U
#define CAN0TXTSR_TSR6_MASK             64U
#define CAN0TXTSR_TSR7_MASK             128U
#define CAN0TXTSR_TSR8_MASK             256U
#define CAN0TXTSR_TSR9_MASK             512U
#define CAN0TXTSR_TSR10_MASK            1024U
#define CAN0TXTSR_TSR11_MASK            2048U
#define CAN0TXTSR_TSR12_MASK            4096U
#define CAN0TXTSR_TSR13_MASK            8192U
#define CAN0TXTSR_TSR14_MASK            16384U
#define CAN0TXTSR_TSR15_MASK            32768U


/*** CAN1CTL0 - MSCAN1 Control 0 Register; 0x00000180 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN1CTL0STR;
extern volatile CAN1CTL0STR _CAN1CTL0 @(REG_BASE + 0x00000180UL);
#define CAN1CTL0                        _CAN1CTL0.Byte
#define CAN1CTL0_INITRQ                 _CAN1CTL0.Bits.INITRQ
#define CAN1CTL0_SLPRQ                  _CAN1CTL0.Bits.SLPRQ
#define CAN1CTL0_WUPE                   _CAN1CTL0.Bits.WUPE
#define CAN1CTL0_TIME                   _CAN1CTL0.Bits.TIME
#define CAN1CTL0_SYNCH                  _CAN1CTL0.Bits.SYNCH
#define CAN1CTL0_CSWAI                  _CAN1CTL0.Bits.CSWAI
#define CAN1CTL0_RXACT                  _CAN1CTL0.Bits.RXACT
#define CAN1CTL0_RXFRM                  _CAN1CTL0.Bits.RXFRM
/* CAN1CTL_ARR: Access 2 CAN1CTLx registers in an array */
#define CAN1CTL_ARR                     ((volatile byte *) &CAN1CTL0)

#define CAN1CTL0_INITRQ_MASK            1U
#define CAN1CTL0_SLPRQ_MASK             2U
#define CAN1CTL0_WUPE_MASK              4U
#define CAN1CTL0_TIME_MASK              8U
#define CAN1CTL0_SYNCH_MASK             16U
#define CAN1CTL0_CSWAI_MASK             32U
#define CAN1CTL0_RXACT_MASK             64U
#define CAN1CTL0_RXFRM_MASK             128U


/*** CAN1CTL1 - MSCAN1 Control 1 Register; 0x00000181 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN Clock Source */
    byte CANE        :1;                                       /* MSCAN Enable */
  } Bits;
} CAN1CTL1STR;
extern volatile CAN1CTL1STR _CAN1CTL1 @(REG_BASE + 0x00000181UL);
#define CAN1CTL1                        _CAN1CTL1.Byte
#define CAN1CTL1_INITAK                 _CAN1CTL1.Bits.INITAK
#define CAN1CTL1_SLPAK                  _CAN1CTL1.Bits.SLPAK
#define CAN1CTL1_WUPM                   _CAN1CTL1.Bits.WUPM
#define CAN1CTL1_BORM                   _CAN1CTL1.Bits.BORM
#define CAN1CTL1_LISTEN                 _CAN1CTL1.Bits.LISTEN
#define CAN1CTL1_LOOPB                  _CAN1CTL1.Bits.LOOPB
#define CAN1CTL1_CLKSRC                 _CAN1CTL1.Bits.CLKSRC
#define CAN1CTL1_CANE                   _CAN1CTL1.Bits.CANE

#define CAN1CTL1_INITAK_MASK            1U
#define CAN1CTL1_SLPAK_MASK             2U
#define CAN1CTL1_WUPM_MASK              4U
#define CAN1CTL1_BORM_MASK              8U
#define CAN1CTL1_LISTEN_MASK            16U
#define CAN1CTL1_LOOPB_MASK             32U
#define CAN1CTL1_CLKSRC_MASK            64U
#define CAN1CTL1_CANE_MASK              128U


/*** CAN1BTR0 - MSCAN1 Bus Timing Register 0; 0x00000182 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN1BTR0STR;
extern volatile CAN1BTR0STR _CAN1BTR0 @(REG_BASE + 0x00000182UL);
#define CAN1BTR0                        _CAN1BTR0.Byte
#define CAN1BTR0_BRP0                   _CAN1BTR0.Bits.BRP0
#define CAN1BTR0_BRP1                   _CAN1BTR0.Bits.BRP1
#define CAN1BTR0_BRP2                   _CAN1BTR0.Bits.BRP2
#define CAN1BTR0_BRP3                   _CAN1BTR0.Bits.BRP3
#define CAN1BTR0_BRP4                   _CAN1BTR0.Bits.BRP4
#define CAN1BTR0_BRP5                   _CAN1BTR0.Bits.BRP5
#define CAN1BTR0_SJW0                   _CAN1BTR0.Bits.SJW0
#define CAN1BTR0_SJW1                   _CAN1BTR0.Bits.SJW1
/* CAN1BTR_ARR: Access 2 CAN1BTRx registers in an array */
#define CAN1BTR_ARR                     ((volatile byte *) &CAN1BTR0)
#define CAN1BTR0_BRP                    _CAN1BTR0.MergedBits.grpBRP
#define CAN1BTR0_SJW                    _CAN1BTR0.MergedBits.grpSJW

#define CAN1BTR0_BRP0_MASK              1U
#define CAN1BTR0_BRP1_MASK              2U
#define CAN1BTR0_BRP2_MASK              4U
#define CAN1BTR0_BRP3_MASK              8U
#define CAN1BTR0_BRP4_MASK              16U
#define CAN1BTR0_BRP5_MASK              32U
#define CAN1BTR0_SJW0_MASK              64U
#define CAN1BTR0_SJW1_MASK              128U
#define CAN1BTR0_BRP_MASK               63U
#define CAN1BTR0_BRP_BITNUM             0U
#define CAN1BTR0_SJW_MASK               192U
#define CAN1BTR0_SJW_BITNUM             6U


/*** CAN1BTR1 - MSCAN1 Bus Timing Register 1; 0x00000183 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN1BTR1STR;
extern volatile CAN1BTR1STR _CAN1BTR1 @(REG_BASE + 0x00000183UL);
#define CAN1BTR1                        _CAN1BTR1.Byte
#define CAN1BTR1_TSEG10                 _CAN1BTR1.Bits.TSEG10
#define CAN1BTR1_TSEG11                 _CAN1BTR1.Bits.TSEG11
#define CAN1BTR1_TSEG12                 _CAN1BTR1.Bits.TSEG12
#define CAN1BTR1_TSEG13                 _CAN1BTR1.Bits.TSEG13
#define CAN1BTR1_TSEG20                 _CAN1BTR1.Bits.TSEG20
#define CAN1BTR1_TSEG21                 _CAN1BTR1.Bits.TSEG21
#define CAN1BTR1_TSEG22                 _CAN1BTR1.Bits.TSEG22
#define CAN1BTR1_SAMP                   _CAN1BTR1.Bits.SAMP
#define CAN1BTR1_TSEG_10                _CAN1BTR1.MergedBits.grpTSEG_10
#define CAN1BTR1_TSEG_20                _CAN1BTR1.MergedBits.grpTSEG_20
#define CAN1BTR1_TSEG                   CAN1BTR1_TSEG_10

#define CAN1BTR1_TSEG10_MASK            1U
#define CAN1BTR1_TSEG11_MASK            2U
#define CAN1BTR1_TSEG12_MASK            4U
#define CAN1BTR1_TSEG13_MASK            8U
#define CAN1BTR1_TSEG20_MASK            16U
#define CAN1BTR1_TSEG21_MASK            32U
#define CAN1BTR1_TSEG22_MASK            64U
#define CAN1BTR1_SAMP_MASK              128U
#define CAN1BTR1_TSEG_10_MASK           15U
#define CAN1BTR1_TSEG_10_BITNUM         0U
#define CAN1BTR1_TSEG_20_MASK           112U
#define CAN1BTR1_TSEG_20_BITNUM         4U


/*** CAN1RFLG - MSCAN1 Receiver Flag Register; 0x00000184 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RFLGSTR;
extern volatile CAN1RFLGSTR _CAN1RFLG @(REG_BASE + 0x00000184UL);
#define CAN1RFLG                        _CAN1RFLG.Byte
#define CAN1RFLG_RXF                    _CAN1RFLG.Bits.RXF
#define CAN1RFLG_OVRIF                  _CAN1RFLG.Bits.OVRIF
#define CAN1RFLG_TSTAT0                 _CAN1RFLG.Bits.TSTAT0
#define CAN1RFLG_TSTAT1                 _CAN1RFLG.Bits.TSTAT1
#define CAN1RFLG_RSTAT0                 _CAN1RFLG.Bits.RSTAT0
#define CAN1RFLG_RSTAT1                 _CAN1RFLG.Bits.RSTAT1
#define CAN1RFLG_CSCIF                  _CAN1RFLG.Bits.CSCIF
#define CAN1RFLG_WUPIF                  _CAN1RFLG.Bits.WUPIF
#define CAN1RFLG_TSTAT                  _CAN1RFLG.MergedBits.grpTSTAT
#define CAN1RFLG_RSTAT                  _CAN1RFLG.MergedBits.grpRSTAT

#define CAN1RFLG_RXF_MASK               1U
#define CAN1RFLG_OVRIF_MASK             2U
#define CAN1RFLG_TSTAT0_MASK            4U
#define CAN1RFLG_TSTAT1_MASK            8U
#define CAN1RFLG_RSTAT0_MASK            16U
#define CAN1RFLG_RSTAT1_MASK            32U
#define CAN1RFLG_CSCIF_MASK             64U
#define CAN1RFLG_WUPIF_MASK             128U
#define CAN1RFLG_TSTAT_MASK             12U
#define CAN1RFLG_TSTAT_BITNUM           2U
#define CAN1RFLG_RSTAT_MASK             48U
#define CAN1RFLG_RSTAT_BITNUM           4U


/*** CAN1RIER - MSCAN1 Receiver Interrupt Enable Register; 0x00000185 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RIERSTR;
extern volatile CAN1RIERSTR _CAN1RIER @(REG_BASE + 0x00000185UL);
#define CAN1RIER                        _CAN1RIER.Byte
#define CAN1RIER_RXFIE                  _CAN1RIER.Bits.RXFIE
#define CAN1RIER_OVRIE                  _CAN1RIER.Bits.OVRIE
#define CAN1RIER_TSTATE0                _CAN1RIER.Bits.TSTATE0
#define CAN1RIER_TSTATE1                _CAN1RIER.Bits.TSTATE1
#define CAN1RIER_RSTATE0                _CAN1RIER.Bits.RSTATE0
#define CAN1RIER_RSTATE1                _CAN1RIER.Bits.RSTATE1
#define CAN1RIER_CSCIE                  _CAN1RIER.Bits.CSCIE
#define CAN1RIER_WUPIE                  _CAN1RIER.Bits.WUPIE
#define CAN1RIER_TSTATE                 _CAN1RIER.MergedBits.grpTSTATE
#define CAN1RIER_RSTATE                 _CAN1RIER.MergedBits.grpRSTATE

#define CAN1RIER_RXFIE_MASK             1U
#define CAN1RIER_OVRIE_MASK             2U
#define CAN1RIER_TSTATE0_MASK           4U
#define CAN1RIER_TSTATE1_MASK           8U
#define CAN1RIER_RSTATE0_MASK           16U
#define CAN1RIER_RSTATE1_MASK           32U
#define CAN1RIER_CSCIE_MASK             64U
#define CAN1RIER_WUPIE_MASK             128U
#define CAN1RIER_TSTATE_MASK            12U
#define CAN1RIER_TSTATE_BITNUM          2U
#define CAN1RIER_RSTATE_MASK            48U
#define CAN1RIER_RSTATE_BITNUM          4U


/*** CAN1TFLG - MSCAN1 Transmitter Flag Register; 0x00000186 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TFLGSTR;
extern volatile CAN1TFLGSTR _CAN1TFLG @(REG_BASE + 0x00000186UL);
#define CAN1TFLG                        _CAN1TFLG.Byte
#define CAN1TFLG_TXE0                   _CAN1TFLG.Bits.TXE0
#define CAN1TFLG_TXE1                   _CAN1TFLG.Bits.TXE1
#define CAN1TFLG_TXE2                   _CAN1TFLG.Bits.TXE2
#define CAN1TFLG_TXE                    _CAN1TFLG.MergedBits.grpTXE

#define CAN1TFLG_TXE0_MASK              1U
#define CAN1TFLG_TXE1_MASK              2U
#define CAN1TFLG_TXE2_MASK              4U
#define CAN1TFLG_TXE_MASK               7U
#define CAN1TFLG_TXE_BITNUM             0U


/*** CAN1TIER - MSCAN1 Transmitter Interrupt Enable Register; 0x00000187 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TIERSTR;
extern volatile CAN1TIERSTR _CAN1TIER @(REG_BASE + 0x00000187UL);
#define CAN1TIER                        _CAN1TIER.Byte
#define CAN1TIER_TXEIE0                 _CAN1TIER.Bits.TXEIE0
#define CAN1TIER_TXEIE1                 _CAN1TIER.Bits.TXEIE1
#define CAN1TIER_TXEIE2                 _CAN1TIER.Bits.TXEIE2
#define CAN1TIER_TXEIE                  _CAN1TIER.MergedBits.grpTXEIE

#define CAN1TIER_TXEIE0_MASK            1U
#define CAN1TIER_TXEIE1_MASK            2U
#define CAN1TIER_TXEIE2_MASK            4U
#define CAN1TIER_TXEIE_MASK             7U
#define CAN1TIER_TXEIE_BITNUM           0U


/*** CAN1TARQ - MSCAN1 Transmitter Message Abort Request; 0x00000188 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TARQSTR;
extern volatile CAN1TARQSTR _CAN1TARQ @(REG_BASE + 0x00000188UL);
#define CAN1TARQ                        _CAN1TARQ.Byte
#define CAN1TARQ_ABTRQ0                 _CAN1TARQ.Bits.ABTRQ0
#define CAN1TARQ_ABTRQ1                 _CAN1TARQ.Bits.ABTRQ1
#define CAN1TARQ_ABTRQ2                 _CAN1TARQ.Bits.ABTRQ2
#define CAN1TARQ_ABTRQ                  _CAN1TARQ.MergedBits.grpABTRQ

#define CAN1TARQ_ABTRQ0_MASK            1U
#define CAN1TARQ_ABTRQ1_MASK            2U
#define CAN1TARQ_ABTRQ2_MASK            4U
#define CAN1TARQ_ABTRQ_MASK             7U
#define CAN1TARQ_ABTRQ_BITNUM           0U


/*** CAN1TAAK - MSCAN1 Transmitter Message Abort Acknowledge; 0x00000189 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TAAKSTR;
extern volatile CAN1TAAKSTR _CAN1TAAK @(REG_BASE + 0x00000189UL);
#define CAN1TAAK                        _CAN1TAAK.Byte
#define CAN1TAAK_ABTAK0                 _CAN1TAAK.Bits.ABTAK0
#define CAN1TAAK_ABTAK1                 _CAN1TAAK.Bits.ABTAK1
#define CAN1TAAK_ABTAK2                 _CAN1TAAK.Bits.ABTAK2
#define CAN1TAAK_ABTAK                  _CAN1TAAK.MergedBits.grpABTAK

#define CAN1TAAK_ABTAK0_MASK            1U
#define CAN1TAAK_ABTAK1_MASK            2U
#define CAN1TAAK_ABTAK2_MASK            4U
#define CAN1TAAK_ABTAK_MASK             7U
#define CAN1TAAK_ABTAK_BITNUM           0U


/*** CAN1TBSEL - MSCAN1 Transmit Buffer Selection; 0x0000018A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TBSELSTR;
extern volatile CAN1TBSELSTR _CAN1TBSEL @(REG_BASE + 0x0000018AUL);
#define CAN1TBSEL                       _CAN1TBSEL.Byte
#define CAN1TBSEL_TX0                   _CAN1TBSEL.Bits.TX0
#define CAN1TBSEL_TX1                   _CAN1TBSEL.Bits.TX1
#define CAN1TBSEL_TX2                   _CAN1TBSEL.Bits.TX2
#define CAN1TBSEL_TX                    _CAN1TBSEL.MergedBits.grpTX

#define CAN1TBSEL_TX0_MASK              1U
#define CAN1TBSEL_TX1_MASK              2U
#define CAN1TBSEL_TX2_MASK              4U
#define CAN1TBSEL_TX_MASK               7U
#define CAN1TBSEL_TX_BITNUM             0U


/*** CAN1IDAC - MSCAN1 Identifier Acceptance Control Register; 0x0000018B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1IDACSTR;
extern volatile CAN1IDACSTR _CAN1IDAC @(REG_BASE + 0x0000018BUL);
#define CAN1IDAC                        _CAN1IDAC.Byte
#define CAN1IDAC_IDHIT0                 _CAN1IDAC.Bits.IDHIT0
#define CAN1IDAC_IDHIT1                 _CAN1IDAC.Bits.IDHIT1
#define CAN1IDAC_IDHIT2                 _CAN1IDAC.Bits.IDHIT2
#define CAN1IDAC_IDAM0                  _CAN1IDAC.Bits.IDAM0
#define CAN1IDAC_IDAM1                  _CAN1IDAC.Bits.IDAM1
#define CAN1IDAC_IDHIT                  _CAN1IDAC.MergedBits.grpIDHIT
#define CAN1IDAC_IDAM                   _CAN1IDAC.MergedBits.grpIDAM

#define CAN1IDAC_IDHIT0_MASK            1U
#define CAN1IDAC_IDHIT1_MASK            2U
#define CAN1IDAC_IDHIT2_MASK            4U
#define CAN1IDAC_IDAM0_MASK             16U
#define CAN1IDAC_IDAM1_MASK             32U
#define CAN1IDAC_IDHIT_MASK             7U
#define CAN1IDAC_IDHIT_BITNUM           0U
#define CAN1IDAC_IDAM_MASK              48U
#define CAN1IDAC_IDAM_BITNUM            4U


/*** CAN1MISC - MSCAN1 Miscellaneous Register; 0x0000018D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-off State Hold Until User Request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN1MISCSTR;
extern volatile CAN1MISCSTR _CAN1MISC @(REG_BASE + 0x0000018DUL);
#define CAN1MISC                        _CAN1MISC.Byte
#define CAN1MISC_BOHOLD                 _CAN1MISC.Bits.BOHOLD

#define CAN1MISC_BOHOLD_MASK            1U


/*** CAN1RXERR - MSCAN1 Receive Error Counter Register; 0x0000018E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN1RXERRSTR;
extern volatile CAN1RXERRSTR _CAN1RXERR @(REG_BASE + 0x0000018EUL);
#define CAN1RXERR                       _CAN1RXERR.Byte
#define CAN1RXERR_RXERR0                _CAN1RXERR.Bits.RXERR0
#define CAN1RXERR_RXERR1                _CAN1RXERR.Bits.RXERR1
#define CAN1RXERR_RXERR2                _CAN1RXERR.Bits.RXERR2
#define CAN1RXERR_RXERR3                _CAN1RXERR.Bits.RXERR3
#define CAN1RXERR_RXERR4                _CAN1RXERR.Bits.RXERR4
#define CAN1RXERR_RXERR5                _CAN1RXERR.Bits.RXERR5
#define CAN1RXERR_RXERR6                _CAN1RXERR.Bits.RXERR6
#define CAN1RXERR_RXERR7                _CAN1RXERR.Bits.RXERR7

#define CAN1RXERR_RXERR0_MASK           1U
#define CAN1RXERR_RXERR1_MASK           2U
#define CAN1RXERR_RXERR2_MASK           4U
#define CAN1RXERR_RXERR3_MASK           8U
#define CAN1RXERR_RXERR4_MASK           16U
#define CAN1RXERR_RXERR5_MASK           32U
#define CAN1RXERR_RXERR6_MASK           64U
#define CAN1RXERR_RXERR7_MASK           128U


/*** CAN1TXERR - MSCAN1 Transmit Error Counter Register; 0x0000018F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN1TXERRSTR;
extern volatile CAN1TXERRSTR _CAN1TXERR @(REG_BASE + 0x0000018FUL);
#define CAN1TXERR                       _CAN1TXERR.Byte
#define CAN1TXERR_TXERR0                _CAN1TXERR.Bits.TXERR0
#define CAN1TXERR_TXERR1                _CAN1TXERR.Bits.TXERR1
#define CAN1TXERR_TXERR2                _CAN1TXERR.Bits.TXERR2
#define CAN1TXERR_TXERR3                _CAN1TXERR.Bits.TXERR3
#define CAN1TXERR_TXERR4                _CAN1TXERR.Bits.TXERR4
#define CAN1TXERR_TXERR5                _CAN1TXERR.Bits.TXERR5
#define CAN1TXERR_TXERR6                _CAN1TXERR.Bits.TXERR6
#define CAN1TXERR_TXERR7                _CAN1TXERR.Bits.TXERR7

#define CAN1TXERR_TXERR0_MASK           1U
#define CAN1TXERR_TXERR1_MASK           2U
#define CAN1TXERR_TXERR2_MASK           4U
#define CAN1TXERR_TXERR3_MASK           8U
#define CAN1TXERR_TXERR4_MASK           16U
#define CAN1TXERR_TXERR5_MASK           32U
#define CAN1TXERR_TXERR6_MASK           64U
#define CAN1TXERR_TXERR7_MASK           128U


/*** CAN1IDAR0 - MSCAN1 Identifier Acceptance Register 0; 0x00000190 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR0STR;
extern volatile CAN1IDAR0STR _CAN1IDAR0 @(REG_BASE + 0x00000190UL);
#define CAN1IDAR0                       _CAN1IDAR0.Byte
#define CAN1IDAR0_AC0                   _CAN1IDAR0.Bits.AC0
#define CAN1IDAR0_AC1                   _CAN1IDAR0.Bits.AC1
#define CAN1IDAR0_AC2                   _CAN1IDAR0.Bits.AC2
#define CAN1IDAR0_AC3                   _CAN1IDAR0.Bits.AC3
#define CAN1IDAR0_AC4                   _CAN1IDAR0.Bits.AC4
#define CAN1IDAR0_AC5                   _CAN1IDAR0.Bits.AC5
#define CAN1IDAR0_AC6                   _CAN1IDAR0.Bits.AC6
#define CAN1IDAR0_AC7                   _CAN1IDAR0.Bits.AC7
/* CAN1IDAR_ARR: Access 4 CAN1IDARx registers in an array */
#define CAN1IDAR_ARR                    ((volatile byte *) &CAN1IDAR0)

#define CAN1IDAR0_AC0_MASK              1U
#define CAN1IDAR0_AC1_MASK              2U
#define CAN1IDAR0_AC2_MASK              4U
#define CAN1IDAR0_AC3_MASK              8U
#define CAN1IDAR0_AC4_MASK              16U
#define CAN1IDAR0_AC5_MASK              32U
#define CAN1IDAR0_AC6_MASK              64U
#define CAN1IDAR0_AC7_MASK              128U


/*** CAN1IDAR1 - MSCAN1 Identifier Acceptance Register 1; 0x00000191 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR1STR;
extern volatile CAN1IDAR1STR _CAN1IDAR1 @(REG_BASE + 0x00000191UL);
#define CAN1IDAR1                       _CAN1IDAR1.Byte
#define CAN1IDAR1_AC0                   _CAN1IDAR1.Bits.AC0
#define CAN1IDAR1_AC1                   _CAN1IDAR1.Bits.AC1
#define CAN1IDAR1_AC2                   _CAN1IDAR1.Bits.AC2
#define CAN1IDAR1_AC3                   _CAN1IDAR1.Bits.AC3
#define CAN1IDAR1_AC4                   _CAN1IDAR1.Bits.AC4
#define CAN1IDAR1_AC5                   _CAN1IDAR1.Bits.AC5
#define CAN1IDAR1_AC6                   _CAN1IDAR1.Bits.AC6
#define CAN1IDAR1_AC7                   _CAN1IDAR1.Bits.AC7

#define CAN1IDAR1_AC0_MASK              1U
#define CAN1IDAR1_AC1_MASK              2U
#define CAN1IDAR1_AC2_MASK              4U
#define CAN1IDAR1_AC3_MASK              8U
#define CAN1IDAR1_AC4_MASK              16U
#define CAN1IDAR1_AC5_MASK              32U
#define CAN1IDAR1_AC6_MASK              64U
#define CAN1IDAR1_AC7_MASK              128U


/*** CAN1IDAR2 - MSCAN1 Identifier Acceptance Register 2; 0x00000192 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR2STR;
extern volatile CAN1IDAR2STR _CAN1IDAR2 @(REG_BASE + 0x00000192UL);
#define CAN1IDAR2                       _CAN1IDAR2.Byte
#define CAN1IDAR2_AC0                   _CAN1IDAR2.Bits.AC0
#define CAN1IDAR2_AC1                   _CAN1IDAR2.Bits.AC1
#define CAN1IDAR2_AC2                   _CAN1IDAR2.Bits.AC2
#define CAN1IDAR2_AC3                   _CAN1IDAR2.Bits.AC3
#define CAN1IDAR2_AC4                   _CAN1IDAR2.Bits.AC4
#define CAN1IDAR2_AC5                   _CAN1IDAR2.Bits.AC5
#define CAN1IDAR2_AC6                   _CAN1IDAR2.Bits.AC6
#define CAN1IDAR2_AC7                   _CAN1IDAR2.Bits.AC7

#define CAN1IDAR2_AC0_MASK              1U
#define CAN1IDAR2_AC1_MASK              2U
#define CAN1IDAR2_AC2_MASK              4U
#define CAN1IDAR2_AC3_MASK              8U
#define CAN1IDAR2_AC4_MASK              16U
#define CAN1IDAR2_AC5_MASK              32U
#define CAN1IDAR2_AC6_MASK              64U
#define CAN1IDAR2_AC7_MASK              128U


/*** CAN1IDAR3 - MSCAN1 Identifier Acceptance Register 3; 0x00000193 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR3STR;
extern volatile CAN1IDAR3STR _CAN1IDAR3 @(REG_BASE + 0x00000193UL);
#define CAN1IDAR3                       _CAN1IDAR3.Byte
#define CAN1IDAR3_AC0                   _CAN1IDAR3.Bits.AC0
#define CAN1IDAR3_AC1                   _CAN1IDAR3.Bits.AC1
#define CAN1IDAR3_AC2                   _CAN1IDAR3.Bits.AC2
#define CAN1IDAR3_AC3                   _CAN1IDAR3.Bits.AC3
#define CAN1IDAR3_AC4                   _CAN1IDAR3.Bits.AC4
#define CAN1IDAR3_AC5                   _CAN1IDAR3.Bits.AC5
#define CAN1IDAR3_AC6                   _CAN1IDAR3.Bits.AC6
#define CAN1IDAR3_AC7                   _CAN1IDAR3.Bits.AC7

#define CAN1IDAR3_AC0_MASK              1U
#define CAN1IDAR3_AC1_MASK              2U
#define CAN1IDAR3_AC2_MASK              4U
#define CAN1IDAR3_AC3_MASK              8U
#define CAN1IDAR3_AC4_MASK              16U
#define CAN1IDAR3_AC5_MASK              32U
#define CAN1IDAR3_AC6_MASK              64U
#define CAN1IDAR3_AC7_MASK              128U


/*** CAN1IDMR0 - MSCAN1 Identifier Mask Register 0; 0x00000194 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR0STR;
extern volatile CAN1IDMR0STR _CAN1IDMR0 @(REG_BASE + 0x00000194UL);
#define CAN1IDMR0                       _CAN1IDMR0.Byte
#define CAN1IDMR0_AM0                   _CAN1IDMR0.Bits.AM0
#define CAN1IDMR0_AM1                   _CAN1IDMR0.Bits.AM1
#define CAN1IDMR0_AM2                   _CAN1IDMR0.Bits.AM2
#define CAN1IDMR0_AM3                   _CAN1IDMR0.Bits.AM3
#define CAN1IDMR0_AM4                   _CAN1IDMR0.Bits.AM4
#define CAN1IDMR0_AM5                   _CAN1IDMR0.Bits.AM5
#define CAN1IDMR0_AM6                   _CAN1IDMR0.Bits.AM6
#define CAN1IDMR0_AM7                   _CAN1IDMR0.Bits.AM7
/* CAN1IDMR_ARR: Access 4 CAN1IDMRx registers in an array */
#define CAN1IDMR_ARR                    ((volatile byte *) &CAN1IDMR0)

#define CAN1IDMR0_AM0_MASK              1U
#define CAN1IDMR0_AM1_MASK              2U
#define CAN1IDMR0_AM2_MASK              4U
#define CAN1IDMR0_AM3_MASK              8U
#define CAN1IDMR0_AM4_MASK              16U
#define CAN1IDMR0_AM5_MASK              32U
#define CAN1IDMR0_AM6_MASK              64U
#define CAN1IDMR0_AM7_MASK              128U


/*** CAN1IDMR1 - MSCAN1 Identifier Mask Register 1; 0x00000195 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR1STR;
extern volatile CAN1IDMR1STR _CAN1IDMR1 @(REG_BASE + 0x00000195UL);
#define CAN1IDMR1                       _CAN1IDMR1.Byte
#define CAN1IDMR1_AM0                   _CAN1IDMR1.Bits.AM0
#define CAN1IDMR1_AM1                   _CAN1IDMR1.Bits.AM1
#define CAN1IDMR1_AM2                   _CAN1IDMR1.Bits.AM2
#define CAN1IDMR1_AM3                   _CAN1IDMR1.Bits.AM3
#define CAN1IDMR1_AM4                   _CAN1IDMR1.Bits.AM4
#define CAN1IDMR1_AM5                   _CAN1IDMR1.Bits.AM5
#define CAN1IDMR1_AM6                   _CAN1IDMR1.Bits.AM6
#define CAN1IDMR1_AM7                   _CAN1IDMR1.Bits.AM7

#define CAN1IDMR1_AM0_MASK              1U
#define CAN1IDMR1_AM1_MASK              2U
#define CAN1IDMR1_AM2_MASK              4U
#define CAN1IDMR1_AM3_MASK              8U
#define CAN1IDMR1_AM4_MASK              16U
#define CAN1IDMR1_AM5_MASK              32U
#define CAN1IDMR1_AM6_MASK              64U
#define CAN1IDMR1_AM7_MASK              128U


/*** CAN1IDMR2 - MSCAN1 Identifier Mask Register 2; 0x00000196 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR2STR;
extern volatile CAN1IDMR2STR _CAN1IDMR2 @(REG_BASE + 0x00000196UL);
#define CAN1IDMR2                       _CAN1IDMR2.Byte
#define CAN1IDMR2_AM0                   _CAN1IDMR2.Bits.AM0
#define CAN1IDMR2_AM1                   _CAN1IDMR2.Bits.AM1
#define CAN1IDMR2_AM2                   _CAN1IDMR2.Bits.AM2
#define CAN1IDMR2_AM3                   _CAN1IDMR2.Bits.AM3
#define CAN1IDMR2_AM4                   _CAN1IDMR2.Bits.AM4
#define CAN1IDMR2_AM5                   _CAN1IDMR2.Bits.AM5
#define CAN1IDMR2_AM6                   _CAN1IDMR2.Bits.AM6
#define CAN1IDMR2_AM7                   _CAN1IDMR2.Bits.AM7

#define CAN1IDMR2_AM0_MASK              1U
#define CAN1IDMR2_AM1_MASK              2U
#define CAN1IDMR2_AM2_MASK              4U
#define CAN1IDMR2_AM3_MASK              8U
#define CAN1IDMR2_AM4_MASK              16U
#define CAN1IDMR2_AM5_MASK              32U
#define CAN1IDMR2_AM6_MASK              64U
#define CAN1IDMR2_AM7_MASK              128U


/*** CAN1IDMR3 - MSCAN1 Identifier Mask Register 3; 0x00000197 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR3STR;
extern volatile CAN1IDMR3STR _CAN1IDMR3 @(REG_BASE + 0x00000197UL);
#define CAN1IDMR3                       _CAN1IDMR3.Byte
#define CAN1IDMR3_AM0                   _CAN1IDMR3.Bits.AM0
#define CAN1IDMR3_AM1                   _CAN1IDMR3.Bits.AM1
#define CAN1IDMR3_AM2                   _CAN1IDMR3.Bits.AM2
#define CAN1IDMR3_AM3                   _CAN1IDMR3.Bits.AM3
#define CAN1IDMR3_AM4                   _CAN1IDMR3.Bits.AM4
#define CAN1IDMR3_AM5                   _CAN1IDMR3.Bits.AM5
#define CAN1IDMR3_AM6                   _CAN1IDMR3.Bits.AM6
#define CAN1IDMR3_AM7                   _CAN1IDMR3.Bits.AM7

#define CAN1IDMR3_AM0_MASK              1U
#define CAN1IDMR3_AM1_MASK              2U
#define CAN1IDMR3_AM2_MASK              4U
#define CAN1IDMR3_AM3_MASK              8U
#define CAN1IDMR3_AM4_MASK              16U
#define CAN1IDMR3_AM5_MASK              32U
#define CAN1IDMR3_AM6_MASK              64U
#define CAN1IDMR3_AM7_MASK              128U


/*** CAN1IDAR4 - MSCAN1 Identifier Acceptance Register 4; 0x00000198 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR4STR;
extern volatile CAN1IDAR4STR _CAN1IDAR4 @(REG_BASE + 0x00000198UL);
#define CAN1IDAR4                       _CAN1IDAR4.Byte
#define CAN1IDAR4_AC0                   _CAN1IDAR4.Bits.AC0
#define CAN1IDAR4_AC1                   _CAN1IDAR4.Bits.AC1
#define CAN1IDAR4_AC2                   _CAN1IDAR4.Bits.AC2
#define CAN1IDAR4_AC3                   _CAN1IDAR4.Bits.AC3
#define CAN1IDAR4_AC4                   _CAN1IDAR4.Bits.AC4
#define CAN1IDAR4_AC5                   _CAN1IDAR4.Bits.AC5
#define CAN1IDAR4_AC6                   _CAN1IDAR4.Bits.AC6
#define CAN1IDAR4_AC7                   _CAN1IDAR4.Bits.AC7

#define CAN1IDAR4_AC0_MASK              1U
#define CAN1IDAR4_AC1_MASK              2U
#define CAN1IDAR4_AC2_MASK              4U
#define CAN1IDAR4_AC3_MASK              8U
#define CAN1IDAR4_AC4_MASK              16U
#define CAN1IDAR4_AC5_MASK              32U
#define CAN1IDAR4_AC6_MASK              64U
#define CAN1IDAR4_AC7_MASK              128U


/*** CAN1IDAR5 - MSCAN1 Identifier Acceptance Register 5; 0x00000199 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR5STR;
extern volatile CAN1IDAR5STR _CAN1IDAR5 @(REG_BASE + 0x00000199UL);
#define CAN1IDAR5                       _CAN1IDAR5.Byte
#define CAN1IDAR5_AC0                   _CAN1IDAR5.Bits.AC0
#define CAN1IDAR5_AC1                   _CAN1IDAR5.Bits.AC1
#define CAN1IDAR5_AC2                   _CAN1IDAR5.Bits.AC2
#define CAN1IDAR5_AC3                   _CAN1IDAR5.Bits.AC3
#define CAN1IDAR5_AC4                   _CAN1IDAR5.Bits.AC4
#define CAN1IDAR5_AC5                   _CAN1IDAR5.Bits.AC5
#define CAN1IDAR5_AC6                   _CAN1IDAR5.Bits.AC6
#define CAN1IDAR5_AC7                   _CAN1IDAR5.Bits.AC7

#define CAN1IDAR5_AC0_MASK              1U
#define CAN1IDAR5_AC1_MASK              2U
#define CAN1IDAR5_AC2_MASK              4U
#define CAN1IDAR5_AC3_MASK              8U
#define CAN1IDAR5_AC4_MASK              16U
#define CAN1IDAR5_AC5_MASK              32U
#define CAN1IDAR5_AC6_MASK              64U
#define CAN1IDAR5_AC7_MASK              128U


/*** CAN1IDAR6 - MSCAN1 Identifier Acceptance Register 6; 0x0000019A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR6STR;
extern volatile CAN1IDAR6STR _CAN1IDAR6 @(REG_BASE + 0x0000019AUL);
#define CAN1IDAR6                       _CAN1IDAR6.Byte
#define CAN1IDAR6_AC0                   _CAN1IDAR6.Bits.AC0
#define CAN1IDAR6_AC1                   _CAN1IDAR6.Bits.AC1
#define CAN1IDAR6_AC2                   _CAN1IDAR6.Bits.AC2
#define CAN1IDAR6_AC3                   _CAN1IDAR6.Bits.AC3
#define CAN1IDAR6_AC4                   _CAN1IDAR6.Bits.AC4
#define CAN1IDAR6_AC5                   _CAN1IDAR6.Bits.AC5
#define CAN1IDAR6_AC6                   _CAN1IDAR6.Bits.AC6
#define CAN1IDAR6_AC7                   _CAN1IDAR6.Bits.AC7

#define CAN1IDAR6_AC0_MASK              1U
#define CAN1IDAR6_AC1_MASK              2U
#define CAN1IDAR6_AC2_MASK              4U
#define CAN1IDAR6_AC3_MASK              8U
#define CAN1IDAR6_AC4_MASK              16U
#define CAN1IDAR6_AC5_MASK              32U
#define CAN1IDAR6_AC6_MASK              64U
#define CAN1IDAR6_AC7_MASK              128U


/*** CAN1IDAR7 - MSCAN1 Identifier Acceptance Register 7; 0x0000019B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR7STR;
extern volatile CAN1IDAR7STR _CAN1IDAR7 @(REG_BASE + 0x0000019BUL);
#define CAN1IDAR7                       _CAN1IDAR7.Byte
#define CAN1IDAR7_AC0                   _CAN1IDAR7.Bits.AC0
#define CAN1IDAR7_AC1                   _CAN1IDAR7.Bits.AC1
#define CAN1IDAR7_AC2                   _CAN1IDAR7.Bits.AC2
#define CAN1IDAR7_AC3                   _CAN1IDAR7.Bits.AC3
#define CAN1IDAR7_AC4                   _CAN1IDAR7.Bits.AC4
#define CAN1IDAR7_AC5                   _CAN1IDAR7.Bits.AC5
#define CAN1IDAR7_AC6                   _CAN1IDAR7.Bits.AC6
#define CAN1IDAR7_AC7                   _CAN1IDAR7.Bits.AC7

#define CAN1IDAR7_AC0_MASK              1U
#define CAN1IDAR7_AC1_MASK              2U
#define CAN1IDAR7_AC2_MASK              4U
#define CAN1IDAR7_AC3_MASK              8U
#define CAN1IDAR7_AC4_MASK              16U
#define CAN1IDAR7_AC5_MASK              32U
#define CAN1IDAR7_AC6_MASK              64U
#define CAN1IDAR7_AC7_MASK              128U


/*** CAN1IDMR4 - MSCAN1 Identifier Mask Register 4; 0x0000019C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR4STR;
extern volatile CAN1IDMR4STR _CAN1IDMR4 @(REG_BASE + 0x0000019CUL);
#define CAN1IDMR4                       _CAN1IDMR4.Byte
#define CAN1IDMR4_AM0                   _CAN1IDMR4.Bits.AM0
#define CAN1IDMR4_AM1                   _CAN1IDMR4.Bits.AM1
#define CAN1IDMR4_AM2                   _CAN1IDMR4.Bits.AM2
#define CAN1IDMR4_AM3                   _CAN1IDMR4.Bits.AM3
#define CAN1IDMR4_AM4                   _CAN1IDMR4.Bits.AM4
#define CAN1IDMR4_AM5                   _CAN1IDMR4.Bits.AM5
#define CAN1IDMR4_AM6                   _CAN1IDMR4.Bits.AM6
#define CAN1IDMR4_AM7                   _CAN1IDMR4.Bits.AM7

#define CAN1IDMR4_AM0_MASK              1U
#define CAN1IDMR4_AM1_MASK              2U
#define CAN1IDMR4_AM2_MASK              4U
#define CAN1IDMR4_AM3_MASK              8U
#define CAN1IDMR4_AM4_MASK              16U
#define CAN1IDMR4_AM5_MASK              32U
#define CAN1IDMR4_AM6_MASK              64U
#define CAN1IDMR4_AM7_MASK              128U


/*** CAN1IDMR5 - MSCAN1 Identifier Mask Register 5; 0x0000019D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR5STR;
extern volatile CAN1IDMR5STR _CAN1IDMR5 @(REG_BASE + 0x0000019DUL);
#define CAN1IDMR5                       _CAN1IDMR5.Byte
#define CAN1IDMR5_AM0                   _CAN1IDMR5.Bits.AM0
#define CAN1IDMR5_AM1                   _CAN1IDMR5.Bits.AM1
#define CAN1IDMR5_AM2                   _CAN1IDMR5.Bits.AM2
#define CAN1IDMR5_AM3                   _CAN1IDMR5.Bits.AM3
#define CAN1IDMR5_AM4                   _CAN1IDMR5.Bits.AM4
#define CAN1IDMR5_AM5                   _CAN1IDMR5.Bits.AM5
#define CAN1IDMR5_AM6                   _CAN1IDMR5.Bits.AM6
#define CAN1IDMR5_AM7                   _CAN1IDMR5.Bits.AM7

#define CAN1IDMR5_AM0_MASK              1U
#define CAN1IDMR5_AM1_MASK              2U
#define CAN1IDMR5_AM2_MASK              4U
#define CAN1IDMR5_AM3_MASK              8U
#define CAN1IDMR5_AM4_MASK              16U
#define CAN1IDMR5_AM5_MASK              32U
#define CAN1IDMR5_AM6_MASK              64U
#define CAN1IDMR5_AM7_MASK              128U


/*** CAN1IDMR6 - MSCAN1 Identifier Mask Register 6; 0x0000019E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR6STR;
extern volatile CAN1IDMR6STR _CAN1IDMR6 @(REG_BASE + 0x0000019EUL);
#define CAN1IDMR6                       _CAN1IDMR6.Byte
#define CAN1IDMR6_AM0                   _CAN1IDMR6.Bits.AM0
#define CAN1IDMR6_AM1                   _CAN1IDMR6.Bits.AM1
#define CAN1IDMR6_AM2                   _CAN1IDMR6.Bits.AM2
#define CAN1IDMR6_AM3                   _CAN1IDMR6.Bits.AM3
#define CAN1IDMR6_AM4                   _CAN1IDMR6.Bits.AM4
#define CAN1IDMR6_AM5                   _CAN1IDMR6.Bits.AM5
#define CAN1IDMR6_AM6                   _CAN1IDMR6.Bits.AM6
#define CAN1IDMR6_AM7                   _CAN1IDMR6.Bits.AM7

#define CAN1IDMR6_AM0_MASK              1U
#define CAN1IDMR6_AM1_MASK              2U
#define CAN1IDMR6_AM2_MASK              4U
#define CAN1IDMR6_AM3_MASK              8U
#define CAN1IDMR6_AM4_MASK              16U
#define CAN1IDMR6_AM5_MASK              32U
#define CAN1IDMR6_AM6_MASK              64U
#define CAN1IDMR6_AM7_MASK              128U


/*** CAN1IDMR7 - MSCAN1 Identifier Mask Register 7; 0x0000019F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR7STR;
extern volatile CAN1IDMR7STR _CAN1IDMR7 @(REG_BASE + 0x0000019FUL);
#define CAN1IDMR7                       _CAN1IDMR7.Byte
#define CAN1IDMR7_AM0                   _CAN1IDMR7.Bits.AM0
#define CAN1IDMR7_AM1                   _CAN1IDMR7.Bits.AM1
#define CAN1IDMR7_AM2                   _CAN1IDMR7.Bits.AM2
#define CAN1IDMR7_AM3                   _CAN1IDMR7.Bits.AM3
#define CAN1IDMR7_AM4                   _CAN1IDMR7.Bits.AM4
#define CAN1IDMR7_AM5                   _CAN1IDMR7.Bits.AM5
#define CAN1IDMR7_AM6                   _CAN1IDMR7.Bits.AM6
#define CAN1IDMR7_AM7                   _CAN1IDMR7.Bits.AM7

#define CAN1IDMR7_AM0_MASK              1U
#define CAN1IDMR7_AM1_MASK              2U
#define CAN1IDMR7_AM2_MASK              4U
#define CAN1IDMR7_AM3_MASK              8U
#define CAN1IDMR7_AM4_MASK              16U
#define CAN1IDMR7_AM5_MASK              32U
#define CAN1IDMR7_AM6_MASK              64U
#define CAN1IDMR7_AM7_MASK              128U


/*** CAN1RXIDR0 - MSCAN1 Receive Identifier Register 0; 0x000001A0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN1RXIDR0STR;
extern volatile CAN1RXIDR0STR _CAN1RXIDR0 @(REG_BASE + 0x000001A0UL);
#define CAN1RXIDR0                      _CAN1RXIDR0.Byte
#define CAN1RXIDR0_ID21                 _CAN1RXIDR0.Bits.ID21
#define CAN1RXIDR0_ID22                 _CAN1RXIDR0.Bits.ID22
#define CAN1RXIDR0_ID23                 _CAN1RXIDR0.Bits.ID23
#define CAN1RXIDR0_ID24                 _CAN1RXIDR0.Bits.ID24
#define CAN1RXIDR0_ID25                 _CAN1RXIDR0.Bits.ID25
#define CAN1RXIDR0_ID26                 _CAN1RXIDR0.Bits.ID26
#define CAN1RXIDR0_ID27                 _CAN1RXIDR0.Bits.ID27
#define CAN1RXIDR0_ID28                 _CAN1RXIDR0.Bits.ID28
/* CAN1RXIDR_ARR: Access 4 CAN1RXIDRx registers in an array */
#define CAN1RXIDR_ARR                   ((volatile byte *) &CAN1RXIDR0)

#define CAN1RXIDR0_ID21_MASK            1U
#define CAN1RXIDR0_ID22_MASK            2U
#define CAN1RXIDR0_ID23_MASK            4U
#define CAN1RXIDR0_ID24_MASK            8U
#define CAN1RXIDR0_ID25_MASK            16U
#define CAN1RXIDR0_ID26_MASK            32U
#define CAN1RXIDR0_ID27_MASK            64U
#define CAN1RXIDR0_ID28_MASK            128U


/*** CAN1RXIDR1 - MSCAN1 Receive Identifier Register 1; 0x000001A1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN1RXIDR1STR;
extern volatile CAN1RXIDR1STR _CAN1RXIDR1 @(REG_BASE + 0x000001A1UL);
#define CAN1RXIDR1                      _CAN1RXIDR1.Byte
#define CAN1RXIDR1_ID15                 _CAN1RXIDR1.Bits.ID15
#define CAN1RXIDR1_ID16                 _CAN1RXIDR1.Bits.ID16
#define CAN1RXIDR1_ID17                 _CAN1RXIDR1.Bits.ID17
#define CAN1RXIDR1_IDE                  _CAN1RXIDR1.Bits.IDE
#define CAN1RXIDR1_SRR                  _CAN1RXIDR1.Bits.SRR
#define CAN1RXIDR1_ID18                 _CAN1RXIDR1.Bits.ID18
#define CAN1RXIDR1_ID19                 _CAN1RXIDR1.Bits.ID19
#define CAN1RXIDR1_ID20                 _CAN1RXIDR1.Bits.ID20
#define CAN1RXIDR1_ID_15                _CAN1RXIDR1.MergedBits.grpID_15
#define CAN1RXIDR1_ID_18                _CAN1RXIDR1.MergedBits.grpID_18
#define CAN1RXIDR1_ID                   CAN1RXIDR1_ID_15

#define CAN1RXIDR1_ID15_MASK            1U
#define CAN1RXIDR1_ID16_MASK            2U
#define CAN1RXIDR1_ID17_MASK            4U
#define CAN1RXIDR1_IDE_MASK             8U
#define CAN1RXIDR1_SRR_MASK             16U
#define CAN1RXIDR1_ID18_MASK            32U
#define CAN1RXIDR1_ID19_MASK            64U
#define CAN1RXIDR1_ID20_MASK            128U
#define CAN1RXIDR1_ID_15_MASK           7U
#define CAN1RXIDR1_ID_15_BITNUM         0U
#define CAN1RXIDR1_ID_18_MASK           224U
#define CAN1RXIDR1_ID_18_BITNUM         5U


/*** CAN1RXIDR2 - MSCAN1 Receive Identifier Register 2; 0x000001A2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN1RXIDR2STR;
extern volatile CAN1RXIDR2STR _CAN1RXIDR2 @(REG_BASE + 0x000001A2UL);
#define CAN1RXIDR2                      _CAN1RXIDR2.Byte
#define CAN1RXIDR2_ID7                  _CAN1RXIDR2.Bits.ID7
#define CAN1RXIDR2_ID8                  _CAN1RXIDR2.Bits.ID8
#define CAN1RXIDR2_ID9                  _CAN1RXIDR2.Bits.ID9
#define CAN1RXIDR2_ID10                 _CAN1RXIDR2.Bits.ID10
#define CAN1RXIDR2_ID11                 _CAN1RXIDR2.Bits.ID11
#define CAN1RXIDR2_ID12                 _CAN1RXIDR2.Bits.ID12
#define CAN1RXIDR2_ID13                 _CAN1RXIDR2.Bits.ID13
#define CAN1RXIDR2_ID14                 _CAN1RXIDR2.Bits.ID14

#define CAN1RXIDR2_ID7_MASK             1U
#define CAN1RXIDR2_ID8_MASK             2U
#define CAN1RXIDR2_ID9_MASK             4U
#define CAN1RXIDR2_ID10_MASK            8U
#define CAN1RXIDR2_ID11_MASK            16U
#define CAN1RXIDR2_ID12_MASK            32U
#define CAN1RXIDR2_ID13_MASK            64U
#define CAN1RXIDR2_ID14_MASK            128U


/*** CAN1RXIDR3 - MSCAN1 Receive Identifier Register 3; 0x000001A3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN1RXIDR3STR;
extern volatile CAN1RXIDR3STR _CAN1RXIDR3 @(REG_BASE + 0x000001A3UL);
#define CAN1RXIDR3                      _CAN1RXIDR3.Byte
#define CAN1RXIDR3_RTR                  _CAN1RXIDR3.Bits.RTR
#define CAN1RXIDR3_ID0                  _CAN1RXIDR3.Bits.ID0
#define CAN1RXIDR3_ID1                  _CAN1RXIDR3.Bits.ID1
#define CAN1RXIDR3_ID2                  _CAN1RXIDR3.Bits.ID2
#define CAN1RXIDR3_ID3                  _CAN1RXIDR3.Bits.ID3
#define CAN1RXIDR3_ID4                  _CAN1RXIDR3.Bits.ID4
#define CAN1RXIDR3_ID5                  _CAN1RXIDR3.Bits.ID5
#define CAN1RXIDR3_ID6                  _CAN1RXIDR3.Bits.ID6
#define CAN1RXIDR3_ID                   _CAN1RXIDR3.MergedBits.grpID

#define CAN1RXIDR3_RTR_MASK             1U
#define CAN1RXIDR3_ID0_MASK             2U
#define CAN1RXIDR3_ID1_MASK             4U
#define CAN1RXIDR3_ID2_MASK             8U
#define CAN1RXIDR3_ID3_MASK             16U
#define CAN1RXIDR3_ID4_MASK             32U
#define CAN1RXIDR3_ID5_MASK             64U
#define CAN1RXIDR3_ID6_MASK             128U
#define CAN1RXIDR3_ID_MASK              254U
#define CAN1RXIDR3_ID_BITNUM            1U


/*** CAN1RXDSR0 - MSCAN1 Receive Data Segment Register 0; 0x000001A4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR0STR;
extern volatile CAN1RXDSR0STR _CAN1RXDSR0 @(REG_BASE + 0x000001A4UL);
#define CAN1RXDSR0                      _CAN1RXDSR0.Byte
#define CAN1RXDSR0_DB0                  _CAN1RXDSR0.Bits.DB0
#define CAN1RXDSR0_DB1                  _CAN1RXDSR0.Bits.DB1
#define CAN1RXDSR0_DB2                  _CAN1RXDSR0.Bits.DB2
#define CAN1RXDSR0_DB3                  _CAN1RXDSR0.Bits.DB3
#define CAN1RXDSR0_DB4                  _CAN1RXDSR0.Bits.DB4
#define CAN1RXDSR0_DB5                  _CAN1RXDSR0.Bits.DB5
#define CAN1RXDSR0_DB6                  _CAN1RXDSR0.Bits.DB6
#define CAN1RXDSR0_DB7                  _CAN1RXDSR0.Bits.DB7
/* CAN1RXDSR_ARR: Access 8 CAN1RXDSRx registers in an array */
#define CAN1RXDSR_ARR                   ((volatile byte *) &CAN1RXDSR0)

#define CAN1RXDSR0_DB0_MASK             1U
#define CAN1RXDSR0_DB1_MASK             2U
#define CAN1RXDSR0_DB2_MASK             4U
#define CAN1RXDSR0_DB3_MASK             8U
#define CAN1RXDSR0_DB4_MASK             16U
#define CAN1RXDSR0_DB5_MASK             32U
#define CAN1RXDSR0_DB6_MASK             64U
#define CAN1RXDSR0_DB7_MASK             128U


/*** CAN1RXDSR1 - MSCAN1 Receive Data Segment Register 1; 0x000001A5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR1STR;
extern volatile CAN1RXDSR1STR _CAN1RXDSR1 @(REG_BASE + 0x000001A5UL);
#define CAN1RXDSR1                      _CAN1RXDSR1.Byte
#define CAN1RXDSR1_DB0                  _CAN1RXDSR1.Bits.DB0
#define CAN1RXDSR1_DB1                  _CAN1RXDSR1.Bits.DB1
#define CAN1RXDSR1_DB2                  _CAN1RXDSR1.Bits.DB2
#define CAN1RXDSR1_DB3                  _CAN1RXDSR1.Bits.DB3
#define CAN1RXDSR1_DB4                  _CAN1RXDSR1.Bits.DB4
#define CAN1RXDSR1_DB5                  _CAN1RXDSR1.Bits.DB5
#define CAN1RXDSR1_DB6                  _CAN1RXDSR1.Bits.DB6
#define CAN1RXDSR1_DB7                  _CAN1RXDSR1.Bits.DB7

#define CAN1RXDSR1_DB0_MASK             1U
#define CAN1RXDSR1_DB1_MASK             2U
#define CAN1RXDSR1_DB2_MASK             4U
#define CAN1RXDSR1_DB3_MASK             8U
#define CAN1RXDSR1_DB4_MASK             16U
#define CAN1RXDSR1_DB5_MASK             32U
#define CAN1RXDSR1_DB6_MASK             64U
#define CAN1RXDSR1_DB7_MASK             128U


/*** CAN1RXDSR2 - MSCAN1 Receive Data Segment Register 2; 0x000001A6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR2STR;
extern volatile CAN1RXDSR2STR _CAN1RXDSR2 @(REG_BASE + 0x000001A6UL);
#define CAN1RXDSR2                      _CAN1RXDSR2.Byte
#define CAN1RXDSR2_DB0                  _CAN1RXDSR2.Bits.DB0
#define CAN1RXDSR2_DB1                  _CAN1RXDSR2.Bits.DB1
#define CAN1RXDSR2_DB2                  _CAN1RXDSR2.Bits.DB2
#define CAN1RXDSR2_DB3                  _CAN1RXDSR2.Bits.DB3
#define CAN1RXDSR2_DB4                  _CAN1RXDSR2.Bits.DB4
#define CAN1RXDSR2_DB5                  _CAN1RXDSR2.Bits.DB5
#define CAN1RXDSR2_DB6                  _CAN1RXDSR2.Bits.DB6
#define CAN1RXDSR2_DB7                  _CAN1RXDSR2.Bits.DB7

#define CAN1RXDSR2_DB0_MASK             1U
#define CAN1RXDSR2_DB1_MASK             2U
#define CAN1RXDSR2_DB2_MASK             4U
#define CAN1RXDSR2_DB3_MASK             8U
#define CAN1RXDSR2_DB4_MASK             16U
#define CAN1RXDSR2_DB5_MASK             32U
#define CAN1RXDSR2_DB6_MASK             64U
#define CAN1RXDSR2_DB7_MASK             128U


/*** CAN1RXDSR3 - MSCAN1 Receive Data Segment Register 3; 0x000001A7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR3STR;
extern volatile CAN1RXDSR3STR _CAN1RXDSR3 @(REG_BASE + 0x000001A7UL);
#define CAN1RXDSR3                      _CAN1RXDSR3.Byte
#define CAN1RXDSR3_DB0                  _CAN1RXDSR3.Bits.DB0
#define CAN1RXDSR3_DB1                  _CAN1RXDSR3.Bits.DB1
#define CAN1RXDSR3_DB2                  _CAN1RXDSR3.Bits.DB2
#define CAN1RXDSR3_DB3                  _CAN1RXDSR3.Bits.DB3
#define CAN1RXDSR3_DB4                  _CAN1RXDSR3.Bits.DB4
#define CAN1RXDSR3_DB5                  _CAN1RXDSR3.Bits.DB5
#define CAN1RXDSR3_DB6                  _CAN1RXDSR3.Bits.DB6
#define CAN1RXDSR3_DB7                  _CAN1RXDSR3.Bits.DB7

#define CAN1RXDSR3_DB0_MASK             1U
#define CAN1RXDSR3_DB1_MASK             2U
#define CAN1RXDSR3_DB2_MASK             4U
#define CAN1RXDSR3_DB3_MASK             8U
#define CAN1RXDSR3_DB4_MASK             16U
#define CAN1RXDSR3_DB5_MASK             32U
#define CAN1RXDSR3_DB6_MASK             64U
#define CAN1RXDSR3_DB7_MASK             128U


/*** CAN1RXDSR4 - MSCAN1 Receive Data Segment Register 4; 0x000001A8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR4STR;
extern volatile CAN1RXDSR4STR _CAN1RXDSR4 @(REG_BASE + 0x000001A8UL);
#define CAN1RXDSR4                      _CAN1RXDSR4.Byte
#define CAN1RXDSR4_DB0                  _CAN1RXDSR4.Bits.DB0
#define CAN1RXDSR4_DB1                  _CAN1RXDSR4.Bits.DB1
#define CAN1RXDSR4_DB2                  _CAN1RXDSR4.Bits.DB2
#define CAN1RXDSR4_DB3                  _CAN1RXDSR4.Bits.DB3
#define CAN1RXDSR4_DB4                  _CAN1RXDSR4.Bits.DB4
#define CAN1RXDSR4_DB5                  _CAN1RXDSR4.Bits.DB5
#define CAN1RXDSR4_DB6                  _CAN1RXDSR4.Bits.DB6
#define CAN1RXDSR4_DB7                  _CAN1RXDSR4.Bits.DB7

#define CAN1RXDSR4_DB0_MASK             1U
#define CAN1RXDSR4_DB1_MASK             2U
#define CAN1RXDSR4_DB2_MASK             4U
#define CAN1RXDSR4_DB3_MASK             8U
#define CAN1RXDSR4_DB4_MASK             16U
#define CAN1RXDSR4_DB5_MASK             32U
#define CAN1RXDSR4_DB6_MASK             64U
#define CAN1RXDSR4_DB7_MASK             128U


/*** CAN1RXDSR5 - MSCAN1 Receive Data Segment Register 5; 0x000001A9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR5STR;
extern volatile CAN1RXDSR5STR _CAN1RXDSR5 @(REG_BASE + 0x000001A9UL);
#define CAN1RXDSR5                      _CAN1RXDSR5.Byte
#define CAN1RXDSR5_DB0                  _CAN1RXDSR5.Bits.DB0
#define CAN1RXDSR5_DB1                  _CAN1RXDSR5.Bits.DB1
#define CAN1RXDSR5_DB2                  _CAN1RXDSR5.Bits.DB2
#define CAN1RXDSR5_DB3                  _CAN1RXDSR5.Bits.DB3
#define CAN1RXDSR5_DB4                  _CAN1RXDSR5.Bits.DB4
#define CAN1RXDSR5_DB5                  _CAN1RXDSR5.Bits.DB5
#define CAN1RXDSR5_DB6                  _CAN1RXDSR5.Bits.DB6
#define CAN1RXDSR5_DB7                  _CAN1RXDSR5.Bits.DB7

#define CAN1RXDSR5_DB0_MASK             1U
#define CAN1RXDSR5_DB1_MASK             2U
#define CAN1RXDSR5_DB2_MASK             4U
#define CAN1RXDSR5_DB3_MASK             8U
#define CAN1RXDSR5_DB4_MASK             16U
#define CAN1RXDSR5_DB5_MASK             32U
#define CAN1RXDSR5_DB6_MASK             64U
#define CAN1RXDSR5_DB7_MASK             128U


/*** CAN1RXDSR6 - MSCAN1 Receive Data Segment Register 6; 0x000001AA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR6STR;
extern volatile CAN1RXDSR6STR _CAN1RXDSR6 @(REG_BASE + 0x000001AAUL);
#define CAN1RXDSR6                      _CAN1RXDSR6.Byte
#define CAN1RXDSR6_DB0                  _CAN1RXDSR6.Bits.DB0
#define CAN1RXDSR6_DB1                  _CAN1RXDSR6.Bits.DB1
#define CAN1RXDSR6_DB2                  _CAN1RXDSR6.Bits.DB2
#define CAN1RXDSR6_DB3                  _CAN1RXDSR6.Bits.DB3
#define CAN1RXDSR6_DB4                  _CAN1RXDSR6.Bits.DB4
#define CAN1RXDSR6_DB5                  _CAN1RXDSR6.Bits.DB5
#define CAN1RXDSR6_DB6                  _CAN1RXDSR6.Bits.DB6
#define CAN1RXDSR6_DB7                  _CAN1RXDSR6.Bits.DB7

#define CAN1RXDSR6_DB0_MASK             1U
#define CAN1RXDSR6_DB1_MASK             2U
#define CAN1RXDSR6_DB2_MASK             4U
#define CAN1RXDSR6_DB3_MASK             8U
#define CAN1RXDSR6_DB4_MASK             16U
#define CAN1RXDSR6_DB5_MASK             32U
#define CAN1RXDSR6_DB6_MASK             64U
#define CAN1RXDSR6_DB7_MASK             128U


/*** CAN1RXDSR7 - MSCAN1 Receive Data Segment Register 7; 0x000001AB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR7STR;
extern volatile CAN1RXDSR7STR _CAN1RXDSR7 @(REG_BASE + 0x000001ABUL);
#define CAN1RXDSR7                      _CAN1RXDSR7.Byte
#define CAN1RXDSR7_DB0                  _CAN1RXDSR7.Bits.DB0
#define CAN1RXDSR7_DB1                  _CAN1RXDSR7.Bits.DB1
#define CAN1RXDSR7_DB2                  _CAN1RXDSR7.Bits.DB2
#define CAN1RXDSR7_DB3                  _CAN1RXDSR7.Bits.DB3
#define CAN1RXDSR7_DB4                  _CAN1RXDSR7.Bits.DB4
#define CAN1RXDSR7_DB5                  _CAN1RXDSR7.Bits.DB5
#define CAN1RXDSR7_DB6                  _CAN1RXDSR7.Bits.DB6
#define CAN1RXDSR7_DB7                  _CAN1RXDSR7.Bits.DB7

#define CAN1RXDSR7_DB0_MASK             1U
#define CAN1RXDSR7_DB1_MASK             2U
#define CAN1RXDSR7_DB2_MASK             4U
#define CAN1RXDSR7_DB3_MASK             8U
#define CAN1RXDSR7_DB4_MASK             16U
#define CAN1RXDSR7_DB5_MASK             32U
#define CAN1RXDSR7_DB6_MASK             64U
#define CAN1RXDSR7_DB7_MASK             128U


/*** CAN1RXDLR - MSCAN1 Receive Data Length Register; 0x000001AC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RXDLRSTR;
extern volatile CAN1RXDLRSTR _CAN1RXDLR @(REG_BASE + 0x000001ACUL);
#define CAN1RXDLR                       _CAN1RXDLR.Byte
#define CAN1RXDLR_DLC0                  _CAN1RXDLR.Bits.DLC0
#define CAN1RXDLR_DLC1                  _CAN1RXDLR.Bits.DLC1
#define CAN1RXDLR_DLC2                  _CAN1RXDLR.Bits.DLC2
#define CAN1RXDLR_DLC3                  _CAN1RXDLR.Bits.DLC3
#define CAN1RXDLR_DLC                   _CAN1RXDLR.MergedBits.grpDLC

#define CAN1RXDLR_DLC0_MASK             1U
#define CAN1RXDLR_DLC1_MASK             2U
#define CAN1RXDLR_DLC2_MASK             4U
#define CAN1RXDLR_DLC3_MASK             8U
#define CAN1RXDLR_DLC_MASK              15U
#define CAN1RXDLR_DLC_BITNUM            0U


/*** CAN1RXTSR - MSCAN1 Receive Time Stamp Register; 0x000001AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN1RXTSRH - MSCAN1 Receive Time Stamp Register High; 0x000001AE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN1RXTSRHSTR;
    #define CAN1RXTSRH                  _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Byte
    #define CAN1RXTSRH_TSR8             _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR8
    #define CAN1RXTSRH_TSR9             _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR9
    #define CAN1RXTSRH_TSR10            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR10
    #define CAN1RXTSRH_TSR11            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR11
    #define CAN1RXTSRH_TSR12            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR12
    #define CAN1RXTSRH_TSR13            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR13
    #define CAN1RXTSRH_TSR14            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR14
    #define CAN1RXTSRH_TSR15            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR15
    
    #define CAN1RXTSRH_TSR8_MASK        1U
    #define CAN1RXTSRH_TSR9_MASK        2U
    #define CAN1RXTSRH_TSR10_MASK       4U
    #define CAN1RXTSRH_TSR11_MASK       8U
    #define CAN1RXTSRH_TSR12_MASK       16U
    #define CAN1RXTSRH_TSR13_MASK       32U
    #define CAN1RXTSRH_TSR14_MASK       64U
    #define CAN1RXTSRH_TSR15_MASK       128U
    

    /*** CAN1RXTSRL - MSCAN1 Receive Time Stamp Register Low; 0x000001AF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN1RXTSRLSTR;
    #define CAN1RXTSRL                  _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Byte
    #define CAN1RXTSRL_TSR0             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR0
    #define CAN1RXTSRL_TSR1             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR1
    #define CAN1RXTSRL_TSR2             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR2
    #define CAN1RXTSRL_TSR3             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR3
    #define CAN1RXTSRL_TSR4             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR4
    #define CAN1RXTSRL_TSR5             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR5
    #define CAN1RXTSRL_TSR6             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR6
    #define CAN1RXTSRL_TSR7             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR7
    
    #define CAN1RXTSRL_TSR0_MASK        1U
    #define CAN1RXTSRL_TSR1_MASK        2U
    #define CAN1RXTSRL_TSR2_MASK        4U
    #define CAN1RXTSRL_TSR3_MASK        8U
    #define CAN1RXTSRL_TSR4_MASK        16U
    #define CAN1RXTSRL_TSR5_MASK        32U
    #define CAN1RXTSRL_TSR6_MASK        64U
    #define CAN1RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN1RXTSRSTR;
extern volatile CAN1RXTSRSTR _CAN1RXTSR @(REG_BASE + 0x000001AEUL);
#define CAN1RXTSR                       _CAN1RXTSR.Word
#define CAN1RXTSR_TSR0                  _CAN1RXTSR.Bits.TSR0
#define CAN1RXTSR_TSR1                  _CAN1RXTSR.Bits.TSR1
#define CAN1RXTSR_TSR2                  _CAN1RXTSR.Bits.TSR2
#define CAN1RXTSR_TSR3                  _CAN1RXTSR.Bits.TSR3
#define CAN1RXTSR_TSR4                  _CAN1RXTSR.Bits.TSR4
#define CAN1RXTSR_TSR5                  _CAN1RXTSR.Bits.TSR5
#define CAN1RXTSR_TSR6                  _CAN1RXTSR.Bits.TSR6
#define CAN1RXTSR_TSR7                  _CAN1RXTSR.Bits.TSR7
#define CAN1RXTSR_TSR8                  _CAN1RXTSR.Bits.TSR8
#define CAN1RXTSR_TSR9                  _CAN1RXTSR.Bits.TSR9
#define CAN1RXTSR_TSR10                 _CAN1RXTSR.Bits.TSR10
#define CAN1RXTSR_TSR11                 _CAN1RXTSR.Bits.TSR11
#define CAN1RXTSR_TSR12                 _CAN1RXTSR.Bits.TSR12
#define CAN1RXTSR_TSR13                 _CAN1RXTSR.Bits.TSR13
#define CAN1RXTSR_TSR14                 _CAN1RXTSR.Bits.TSR14
#define CAN1RXTSR_TSR15                 _CAN1RXTSR.Bits.TSR15

#define CAN1RXTSR_TSR0_MASK             1U
#define CAN1RXTSR_TSR1_MASK             2U
#define CAN1RXTSR_TSR2_MASK             4U
#define CAN1RXTSR_TSR3_MASK             8U
#define CAN1RXTSR_TSR4_MASK             16U
#define CAN1RXTSR_TSR5_MASK             32U
#define CAN1RXTSR_TSR6_MASK             64U
#define CAN1RXTSR_TSR7_MASK             128U
#define CAN1RXTSR_TSR8_MASK             256U
#define CAN1RXTSR_TSR9_MASK             512U
#define CAN1RXTSR_TSR10_MASK            1024U
#define CAN1RXTSR_TSR11_MASK            2048U
#define CAN1RXTSR_TSR12_MASK            4096U
#define CAN1RXTSR_TSR13_MASK            8192U
#define CAN1RXTSR_TSR14_MASK            16384U
#define CAN1RXTSR_TSR15_MASK            32768U


/*** CAN1TXIDR0 - MSCAN1 Transmit Identifier Register 0; 0x000001B0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN1TXIDR0STR;
extern volatile CAN1TXIDR0STR _CAN1TXIDR0 @(REG_BASE + 0x000001B0UL);
#define CAN1TXIDR0                      _CAN1TXIDR0.Byte
#define CAN1TXIDR0_ID21                 _CAN1TXIDR0.Bits.ID21
#define CAN1TXIDR0_ID22                 _CAN1TXIDR0.Bits.ID22
#define CAN1TXIDR0_ID23                 _CAN1TXIDR0.Bits.ID23
#define CAN1TXIDR0_ID24                 _CAN1TXIDR0.Bits.ID24
#define CAN1TXIDR0_ID25                 _CAN1TXIDR0.Bits.ID25
#define CAN1TXIDR0_ID26                 _CAN1TXIDR0.Bits.ID26
#define CAN1TXIDR0_ID27                 _CAN1TXIDR0.Bits.ID27
#define CAN1TXIDR0_ID28                 _CAN1TXIDR0.Bits.ID28
/* CAN1TXIDR_ARR: Access 4 CAN1TXIDRx registers in an array */
#define CAN1TXIDR_ARR                   ((volatile byte *) &CAN1TXIDR0)

#define CAN1TXIDR0_ID21_MASK            1U
#define CAN1TXIDR0_ID22_MASK            2U
#define CAN1TXIDR0_ID23_MASK            4U
#define CAN1TXIDR0_ID24_MASK            8U
#define CAN1TXIDR0_ID25_MASK            16U
#define CAN1TXIDR0_ID26_MASK            32U
#define CAN1TXIDR0_ID27_MASK            64U
#define CAN1TXIDR0_ID28_MASK            128U


/*** CAN1TXIDR1 - MSCAN1 Transmit Identifier Register 1; 0x000001B1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN1TXIDR1STR;
extern volatile CAN1TXIDR1STR _CAN1TXIDR1 @(REG_BASE + 0x000001B1UL);
#define CAN1TXIDR1                      _CAN1TXIDR1.Byte
#define CAN1TXIDR1_ID15                 _CAN1TXIDR1.Bits.ID15
#define CAN1TXIDR1_ID16                 _CAN1TXIDR1.Bits.ID16
#define CAN1TXIDR1_ID17                 _CAN1TXIDR1.Bits.ID17
#define CAN1TXIDR1_IDE                  _CAN1TXIDR1.Bits.IDE
#define CAN1TXIDR1_SRR                  _CAN1TXIDR1.Bits.SRR
#define CAN1TXIDR1_ID18                 _CAN1TXIDR1.Bits.ID18
#define CAN1TXIDR1_ID19                 _CAN1TXIDR1.Bits.ID19
#define CAN1TXIDR1_ID20                 _CAN1TXIDR1.Bits.ID20
#define CAN1TXIDR1_ID_15                _CAN1TXIDR1.MergedBits.grpID_15
#define CAN1TXIDR1_ID_18                _CAN1TXIDR1.MergedBits.grpID_18
#define CAN1TXIDR1_ID                   CAN1TXIDR1_ID_15

#define CAN1TXIDR1_ID15_MASK            1U
#define CAN1TXIDR1_ID16_MASK            2U
#define CAN1TXIDR1_ID17_MASK            4U
#define CAN1TXIDR1_IDE_MASK             8U
#define CAN1TXIDR1_SRR_MASK             16U
#define CAN1TXIDR1_ID18_MASK            32U
#define CAN1TXIDR1_ID19_MASK            64U
#define CAN1TXIDR1_ID20_MASK            128U
#define CAN1TXIDR1_ID_15_MASK           7U
#define CAN1TXIDR1_ID_15_BITNUM         0U
#define CAN1TXIDR1_ID_18_MASK           224U
#define CAN1TXIDR1_ID_18_BITNUM         5U


/*** CAN1TXIDR2 - MSCAN1 Transmit Identifier Register 2; 0x000001B2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN1TXIDR2STR;
extern volatile CAN1TXIDR2STR _CAN1TXIDR2 @(REG_BASE + 0x000001B2UL);
#define CAN1TXIDR2                      _CAN1TXIDR2.Byte
#define CAN1TXIDR2_ID7                  _CAN1TXIDR2.Bits.ID7
#define CAN1TXIDR2_ID8                  _CAN1TXIDR2.Bits.ID8
#define CAN1TXIDR2_ID9                  _CAN1TXIDR2.Bits.ID9
#define CAN1TXIDR2_ID10                 _CAN1TXIDR2.Bits.ID10
#define CAN1TXIDR2_ID11                 _CAN1TXIDR2.Bits.ID11
#define CAN1TXIDR2_ID12                 _CAN1TXIDR2.Bits.ID12
#define CAN1TXIDR2_ID13                 _CAN1TXIDR2.Bits.ID13
#define CAN1TXIDR2_ID14                 _CAN1TXIDR2.Bits.ID14

#define CAN1TXIDR2_ID7_MASK             1U
#define CAN1TXIDR2_ID8_MASK             2U
#define CAN1TXIDR2_ID9_MASK             4U
#define CAN1TXIDR2_ID10_MASK            8U
#define CAN1TXIDR2_ID11_MASK            16U
#define CAN1TXIDR2_ID12_MASK            32U
#define CAN1TXIDR2_ID13_MASK            64U
#define CAN1TXIDR2_ID14_MASK            128U


/*** CAN1TXIDR3 - MSCAN1 Transmit Identifier Register 3; 0x000001B3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN1TXIDR3STR;
extern volatile CAN1TXIDR3STR _CAN1TXIDR3 @(REG_BASE + 0x000001B3UL);
#define CAN1TXIDR3                      _CAN1TXIDR3.Byte
#define CAN1TXIDR3_RTR                  _CAN1TXIDR3.Bits.RTR
#define CAN1TXIDR3_ID0                  _CAN1TXIDR3.Bits.ID0
#define CAN1TXIDR3_ID1                  _CAN1TXIDR3.Bits.ID1
#define CAN1TXIDR3_ID2                  _CAN1TXIDR3.Bits.ID2
#define CAN1TXIDR3_ID3                  _CAN1TXIDR3.Bits.ID3
#define CAN1TXIDR3_ID4                  _CAN1TXIDR3.Bits.ID4
#define CAN1TXIDR3_ID5                  _CAN1TXIDR3.Bits.ID5
#define CAN1TXIDR3_ID6                  _CAN1TXIDR3.Bits.ID6
#define CAN1TXIDR3_ID                   _CAN1TXIDR3.MergedBits.grpID

#define CAN1TXIDR3_RTR_MASK             1U
#define CAN1TXIDR3_ID0_MASK             2U
#define CAN1TXIDR3_ID1_MASK             4U
#define CAN1TXIDR3_ID2_MASK             8U
#define CAN1TXIDR3_ID3_MASK             16U
#define CAN1TXIDR3_ID4_MASK             32U
#define CAN1TXIDR3_ID5_MASK             64U
#define CAN1TXIDR3_ID6_MASK             128U
#define CAN1TXIDR3_ID_MASK              254U
#define CAN1TXIDR3_ID_BITNUM            1U


/*** CAN1TXDSR0 - MSCAN1 Transmit Data Segment Register 0; 0x000001B4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR0STR;
extern volatile CAN1TXDSR0STR _CAN1TXDSR0 @(REG_BASE + 0x000001B4UL);
#define CAN1TXDSR0                      _CAN1TXDSR0.Byte
#define CAN1TXDSR0_DB0                  _CAN1TXDSR0.Bits.DB0
#define CAN1TXDSR0_DB1                  _CAN1TXDSR0.Bits.DB1
#define CAN1TXDSR0_DB2                  _CAN1TXDSR0.Bits.DB2
#define CAN1TXDSR0_DB3                  _CAN1TXDSR0.Bits.DB3
#define CAN1TXDSR0_DB4                  _CAN1TXDSR0.Bits.DB4
#define CAN1TXDSR0_DB5                  _CAN1TXDSR0.Bits.DB5
#define CAN1TXDSR0_DB6                  _CAN1TXDSR0.Bits.DB6
#define CAN1TXDSR0_DB7                  _CAN1TXDSR0.Bits.DB7
/* CAN1TXDSR_ARR: Access 8 CAN1TXDSRx registers in an array */
#define CAN1TXDSR_ARR                   ((volatile byte *) &CAN1TXDSR0)

#define CAN1TXDSR0_DB0_MASK             1U
#define CAN1TXDSR0_DB1_MASK             2U
#define CAN1TXDSR0_DB2_MASK             4U
#define CAN1TXDSR0_DB3_MASK             8U
#define CAN1TXDSR0_DB4_MASK             16U
#define CAN1TXDSR0_DB5_MASK             32U
#define CAN1TXDSR0_DB6_MASK             64U
#define CAN1TXDSR0_DB7_MASK             128U


/*** CAN1TXDSR1 - MSCAN1 Transmit Data Segment Register 1; 0x000001B5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR1STR;
extern volatile CAN1TXDSR1STR _CAN1TXDSR1 @(REG_BASE + 0x000001B5UL);
#define CAN1TXDSR1                      _CAN1TXDSR1.Byte
#define CAN1TXDSR1_DB0                  _CAN1TXDSR1.Bits.DB0
#define CAN1TXDSR1_DB1                  _CAN1TXDSR1.Bits.DB1
#define CAN1TXDSR1_DB2                  _CAN1TXDSR1.Bits.DB2
#define CAN1TXDSR1_DB3                  _CAN1TXDSR1.Bits.DB3
#define CAN1TXDSR1_DB4                  _CAN1TXDSR1.Bits.DB4
#define CAN1TXDSR1_DB5                  _CAN1TXDSR1.Bits.DB5
#define CAN1TXDSR1_DB6                  _CAN1TXDSR1.Bits.DB6
#define CAN1TXDSR1_DB7                  _CAN1TXDSR1.Bits.DB7

#define CAN1TXDSR1_DB0_MASK             1U
#define CAN1TXDSR1_DB1_MASK             2U
#define CAN1TXDSR1_DB2_MASK             4U
#define CAN1TXDSR1_DB3_MASK             8U
#define CAN1TXDSR1_DB4_MASK             16U
#define CAN1TXDSR1_DB5_MASK             32U
#define CAN1TXDSR1_DB6_MASK             64U
#define CAN1TXDSR1_DB7_MASK             128U


/*** CAN1TXDSR2 - MSCAN1 Transmit Data Segment Register 2; 0x000001B6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR2STR;
extern volatile CAN1TXDSR2STR _CAN1TXDSR2 @(REG_BASE + 0x000001B6UL);
#define CAN1TXDSR2                      _CAN1TXDSR2.Byte
#define CAN1TXDSR2_DB0                  _CAN1TXDSR2.Bits.DB0
#define CAN1TXDSR2_DB1                  _CAN1TXDSR2.Bits.DB1
#define CAN1TXDSR2_DB2                  _CAN1TXDSR2.Bits.DB2
#define CAN1TXDSR2_DB3                  _CAN1TXDSR2.Bits.DB3
#define CAN1TXDSR2_DB4                  _CAN1TXDSR2.Bits.DB4
#define CAN1TXDSR2_DB5                  _CAN1TXDSR2.Bits.DB5
#define CAN1TXDSR2_DB6                  _CAN1TXDSR2.Bits.DB6
#define CAN1TXDSR2_DB7                  _CAN1TXDSR2.Bits.DB7

#define CAN1TXDSR2_DB0_MASK             1U
#define CAN1TXDSR2_DB1_MASK             2U
#define CAN1TXDSR2_DB2_MASK             4U
#define CAN1TXDSR2_DB3_MASK             8U
#define CAN1TXDSR2_DB4_MASK             16U
#define CAN1TXDSR2_DB5_MASK             32U
#define CAN1TXDSR2_DB6_MASK             64U
#define CAN1TXDSR2_DB7_MASK             128U


/*** CAN1TXDSR3 - MSCAN1 Transmit Data Segment Register 3; 0x000001B7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR3STR;
extern volatile CAN1TXDSR3STR _CAN1TXDSR3 @(REG_BASE + 0x000001B7UL);
#define CAN1TXDSR3                      _CAN1TXDSR3.Byte
#define CAN1TXDSR3_DB0                  _CAN1TXDSR3.Bits.DB0
#define CAN1TXDSR3_DB1                  _CAN1TXDSR3.Bits.DB1
#define CAN1TXDSR3_DB2                  _CAN1TXDSR3.Bits.DB2
#define CAN1TXDSR3_DB3                  _CAN1TXDSR3.Bits.DB3
#define CAN1TXDSR3_DB4                  _CAN1TXDSR3.Bits.DB4
#define CAN1TXDSR3_DB5                  _CAN1TXDSR3.Bits.DB5
#define CAN1TXDSR3_DB6                  _CAN1TXDSR3.Bits.DB6
#define CAN1TXDSR3_DB7                  _CAN1TXDSR3.Bits.DB7

#define CAN1TXDSR3_DB0_MASK             1U
#define CAN1TXDSR3_DB1_MASK             2U
#define CAN1TXDSR3_DB2_MASK             4U
#define CAN1TXDSR3_DB3_MASK             8U
#define CAN1TXDSR3_DB4_MASK             16U
#define CAN1TXDSR3_DB5_MASK             32U
#define CAN1TXDSR3_DB6_MASK             64U
#define CAN1TXDSR3_DB7_MASK             128U


/*** CAN1TXDSR4 - MSCAN1 Transmit Data Segment Register 4; 0x000001B8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR4STR;
extern volatile CAN1TXDSR4STR _CAN1TXDSR4 @(REG_BASE + 0x000001B8UL);
#define CAN1TXDSR4                      _CAN1TXDSR4.Byte
#define CAN1TXDSR4_DB0                  _CAN1TXDSR4.Bits.DB0
#define CAN1TXDSR4_DB1                  _CAN1TXDSR4.Bits.DB1
#define CAN1TXDSR4_DB2                  _CAN1TXDSR4.Bits.DB2
#define CAN1TXDSR4_DB3                  _CAN1TXDSR4.Bits.DB3
#define CAN1TXDSR4_DB4                  _CAN1TXDSR4.Bits.DB4
#define CAN1TXDSR4_DB5                  _CAN1TXDSR4.Bits.DB5
#define CAN1TXDSR4_DB6                  _CAN1TXDSR4.Bits.DB6
#define CAN1TXDSR4_DB7                  _CAN1TXDSR4.Bits.DB7

#define CAN1TXDSR4_DB0_MASK             1U
#define CAN1TXDSR4_DB1_MASK             2U
#define CAN1TXDSR4_DB2_MASK             4U
#define CAN1TXDSR4_DB3_MASK             8U
#define CAN1TXDSR4_DB4_MASK             16U
#define CAN1TXDSR4_DB5_MASK             32U
#define CAN1TXDSR4_DB6_MASK             64U
#define CAN1TXDSR4_DB7_MASK             128U


/*** CAN1TXDSR5 - MSCAN1 Transmit Data Segment Register 5; 0x000001B9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR5STR;
extern volatile CAN1TXDSR5STR _CAN1TXDSR5 @(REG_BASE + 0x000001B9UL);
#define CAN1TXDSR5                      _CAN1TXDSR5.Byte
#define CAN1TXDSR5_DB0                  _CAN1TXDSR5.Bits.DB0
#define CAN1TXDSR5_DB1                  _CAN1TXDSR5.Bits.DB1
#define CAN1TXDSR5_DB2                  _CAN1TXDSR5.Bits.DB2
#define CAN1TXDSR5_DB3                  _CAN1TXDSR5.Bits.DB3
#define CAN1TXDSR5_DB4                  _CAN1TXDSR5.Bits.DB4
#define CAN1TXDSR5_DB5                  _CAN1TXDSR5.Bits.DB5
#define CAN1TXDSR5_DB6                  _CAN1TXDSR5.Bits.DB6
#define CAN1TXDSR5_DB7                  _CAN1TXDSR5.Bits.DB7

#define CAN1TXDSR5_DB0_MASK             1U
#define CAN1TXDSR5_DB1_MASK             2U
#define CAN1TXDSR5_DB2_MASK             4U
#define CAN1TXDSR5_DB3_MASK             8U
#define CAN1TXDSR5_DB4_MASK             16U
#define CAN1TXDSR5_DB5_MASK             32U
#define CAN1TXDSR5_DB6_MASK             64U
#define CAN1TXDSR5_DB7_MASK             128U


/*** CAN1TXDSR6 - MSCAN1 Transmit Data Segment Register 6; 0x000001BA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR6STR;
extern volatile CAN1TXDSR6STR _CAN1TXDSR6 @(REG_BASE + 0x000001BAUL);
#define CAN1TXDSR6                      _CAN1TXDSR6.Byte
#define CAN1TXDSR6_DB0                  _CAN1TXDSR6.Bits.DB0
#define CAN1TXDSR6_DB1                  _CAN1TXDSR6.Bits.DB1
#define CAN1TXDSR6_DB2                  _CAN1TXDSR6.Bits.DB2
#define CAN1TXDSR6_DB3                  _CAN1TXDSR6.Bits.DB3
#define CAN1TXDSR6_DB4                  _CAN1TXDSR6.Bits.DB4
#define CAN1TXDSR6_DB5                  _CAN1TXDSR6.Bits.DB5
#define CAN1TXDSR6_DB6                  _CAN1TXDSR6.Bits.DB6
#define CAN1TXDSR6_DB7                  _CAN1TXDSR6.Bits.DB7

#define CAN1TXDSR6_DB0_MASK             1U
#define CAN1TXDSR6_DB1_MASK             2U
#define CAN1TXDSR6_DB2_MASK             4U
#define CAN1TXDSR6_DB3_MASK             8U
#define CAN1TXDSR6_DB4_MASK             16U
#define CAN1TXDSR6_DB5_MASK             32U
#define CAN1TXDSR6_DB6_MASK             64U
#define CAN1TXDSR6_DB7_MASK             128U


/*** CAN1TXDSR7 - MSCAN1 Transmit Data Segment Register 7; 0x000001BB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR7STR;
extern volatile CAN1TXDSR7STR _CAN1TXDSR7 @(REG_BASE + 0x000001BBUL);
#define CAN1TXDSR7                      _CAN1TXDSR7.Byte
#define CAN1TXDSR7_DB0                  _CAN1TXDSR7.Bits.DB0
#define CAN1TXDSR7_DB1                  _CAN1TXDSR7.Bits.DB1
#define CAN1TXDSR7_DB2                  _CAN1TXDSR7.Bits.DB2
#define CAN1TXDSR7_DB3                  _CAN1TXDSR7.Bits.DB3
#define CAN1TXDSR7_DB4                  _CAN1TXDSR7.Bits.DB4
#define CAN1TXDSR7_DB5                  _CAN1TXDSR7.Bits.DB5
#define CAN1TXDSR7_DB6                  _CAN1TXDSR7.Bits.DB6
#define CAN1TXDSR7_DB7                  _CAN1TXDSR7.Bits.DB7

#define CAN1TXDSR7_DB0_MASK             1U
#define CAN1TXDSR7_DB1_MASK             2U
#define CAN1TXDSR7_DB2_MASK             4U
#define CAN1TXDSR7_DB3_MASK             8U
#define CAN1TXDSR7_DB4_MASK             16U
#define CAN1TXDSR7_DB5_MASK             32U
#define CAN1TXDSR7_DB6_MASK             64U
#define CAN1TXDSR7_DB7_MASK             128U


/*** CAN1TXDLR - MSCAN1 Transmit Data Length Register; 0x000001BC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TXDLRSTR;
extern volatile CAN1TXDLRSTR _CAN1TXDLR @(REG_BASE + 0x000001BCUL);
#define CAN1TXDLR                       _CAN1TXDLR.Byte
#define CAN1TXDLR_DLC0                  _CAN1TXDLR.Bits.DLC0
#define CAN1TXDLR_DLC1                  _CAN1TXDLR.Bits.DLC1
#define CAN1TXDLR_DLC2                  _CAN1TXDLR.Bits.DLC2
#define CAN1TXDLR_DLC3                  _CAN1TXDLR.Bits.DLC3
#define CAN1TXDLR_DLC                   _CAN1TXDLR.MergedBits.grpDLC

#define CAN1TXDLR_DLC0_MASK             1U
#define CAN1TXDLR_DLC1_MASK             2U
#define CAN1TXDLR_DLC2_MASK             4U
#define CAN1TXDLR_DLC3_MASK             8U
#define CAN1TXDLR_DLC_MASK              15U
#define CAN1TXDLR_DLC_BITNUM            0U


/*** CAN1TXTBPR - MSCAN1 Transmit Buffer Priority; 0x000001BD ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN1TXTBPRSTR;
extern volatile CAN1TXTBPRSTR _CAN1TXTBPR @(REG_BASE + 0x000001BDUL);
#define CAN1TXTBPR                      _CAN1TXTBPR.Byte
#define CAN1TXTBPR_PRIO0                _CAN1TXTBPR.Bits.PRIO0
#define CAN1TXTBPR_PRIO1                _CAN1TXTBPR.Bits.PRIO1
#define CAN1TXTBPR_PRIO2                _CAN1TXTBPR.Bits.PRIO2
#define CAN1TXTBPR_PRIO3                _CAN1TXTBPR.Bits.PRIO3
#define CAN1TXTBPR_PRIO4                _CAN1TXTBPR.Bits.PRIO4
#define CAN1TXTBPR_PRIO5                _CAN1TXTBPR.Bits.PRIO5
#define CAN1TXTBPR_PRIO6                _CAN1TXTBPR.Bits.PRIO6
#define CAN1TXTBPR_PRIO7                _CAN1TXTBPR.Bits.PRIO7

#define CAN1TXTBPR_PRIO0_MASK           1U
#define CAN1TXTBPR_PRIO1_MASK           2U
#define CAN1TXTBPR_PRIO2_MASK           4U
#define CAN1TXTBPR_PRIO3_MASK           8U
#define CAN1TXTBPR_PRIO4_MASK           16U
#define CAN1TXTBPR_PRIO5_MASK           32U
#define CAN1TXTBPR_PRIO6_MASK           64U
#define CAN1TXTBPR_PRIO7_MASK           128U


/*** CAN1TXTSR - MSCAN1 Transmit Time Stamp Register; 0x000001BE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN1TXTSRH - MSCAN1 Transmit Time Stamp Register High; 0x000001BE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN1TXTSRHSTR;
    #define CAN1TXTSRH                  _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Byte
    #define CAN1TXTSRH_TSR8             _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR8
    #define CAN1TXTSRH_TSR9             _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR9
    #define CAN1TXTSRH_TSR10            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR10
    #define CAN1TXTSRH_TSR11            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR11
    #define CAN1TXTSRH_TSR12            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR12
    #define CAN1TXTSRH_TSR13            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR13
    #define CAN1TXTSRH_TSR14            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR14
    #define CAN1TXTSRH_TSR15            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR15
    
    #define CAN1TXTSRH_TSR8_MASK        1U
    #define CAN1TXTSRH_TSR9_MASK        2U
    #define CAN1TXTSRH_TSR10_MASK       4U
    #define CAN1TXTSRH_TSR11_MASK       8U
    #define CAN1TXTSRH_TSR12_MASK       16U
    #define CAN1TXTSRH_TSR13_MASK       32U
    #define CAN1TXTSRH_TSR14_MASK       64U
    #define CAN1TXTSRH_TSR15_MASK       128U
    

    /*** CAN1TXTSRL - MSCAN1 Transmit Time Stamp Register Low; 0x000001BF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN1TXTSRLSTR;
    #define CAN1TXTSRL                  _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Byte
    #define CAN1TXTSRL_TSR0             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR0
    #define CAN1TXTSRL_TSR1             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR1
    #define CAN1TXTSRL_TSR2             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR2
    #define CAN1TXTSRL_TSR3             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR3
    #define CAN1TXTSRL_TSR4             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR4
    #define CAN1TXTSRL_TSR5             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR5
    #define CAN1TXTSRL_TSR6             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR6
    #define CAN1TXTSRL_TSR7             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR7
    
    #define CAN1TXTSRL_TSR0_MASK        1U
    #define CAN1TXTSRL_TSR1_MASK        2U
    #define CAN1TXTSRL_TSR2_MASK        4U
    #define CAN1TXTSRL_TSR3_MASK        8U
    #define CAN1TXTSRL_TSR4_MASK        16U
    #define CAN1TXTSRL_TSR5_MASK        32U
    #define CAN1TXTSRL_TSR6_MASK        64U
    #define CAN1TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN1TXTSRSTR;
extern volatile CAN1TXTSRSTR _CAN1TXTSR @(REG_BASE + 0x000001BEUL);
#define CAN1TXTSR                       _CAN1TXTSR.Word
#define CAN1TXTSR_TSR0                  _CAN1TXTSR.Bits.TSR0
#define CAN1TXTSR_TSR1                  _CAN1TXTSR.Bits.TSR1
#define CAN1TXTSR_TSR2                  _CAN1TXTSR.Bits.TSR2
#define CAN1TXTSR_TSR3                  _CAN1TXTSR.Bits.TSR3
#define CAN1TXTSR_TSR4                  _CAN1TXTSR.Bits.TSR4
#define CAN1TXTSR_TSR5                  _CAN1TXTSR.Bits.TSR5
#define CAN1TXTSR_TSR6                  _CAN1TXTSR.Bits.TSR6
#define CAN1TXTSR_TSR7                  _CAN1TXTSR.Bits.TSR7
#define CAN1TXTSR_TSR8                  _CAN1TXTSR.Bits.TSR8
#define CAN1TXTSR_TSR9                  _CAN1TXTSR.Bits.TSR9
#define CAN1TXTSR_TSR10                 _CAN1TXTSR.Bits.TSR10
#define CAN1TXTSR_TSR11                 _CAN1TXTSR.Bits.TSR11
#define CAN1TXTSR_TSR12                 _CAN1TXTSR.Bits.TSR12
#define CAN1TXTSR_TSR13                 _CAN1TXTSR.Bits.TSR13
#define CAN1TXTSR_TSR14                 _CAN1TXTSR.Bits.TSR14
#define CAN1TXTSR_TSR15                 _CAN1TXTSR.Bits.TSR15

#define CAN1TXTSR_TSR0_MASK             1U
#define CAN1TXTSR_TSR1_MASK             2U
#define CAN1TXTSR_TSR2_MASK             4U
#define CAN1TXTSR_TSR3_MASK             8U
#define CAN1TXTSR_TSR4_MASK             16U
#define CAN1TXTSR_TSR5_MASK             32U
#define CAN1TXTSR_TSR6_MASK             64U
#define CAN1TXTSR_TSR7_MASK             128U
#define CAN1TXTSR_TSR8_MASK             256U
#define CAN1TXTSR_TSR9_MASK             512U
#define CAN1TXTSR_TSR10_MASK            1024U
#define CAN1TXTSR_TSR11_MASK            2048U
#define CAN1TXTSR_TSR12_MASK            4096U
#define CAN1TXTSR_TSR13_MASK            8192U
#define CAN1TXTSR_TSR14_MASK            16384U
#define CAN1TXTSR_TSR15_MASK            32768U


/*** MCCTL0 - Motor Controller Control Register 0; 0x000001C0 ***/
typedef union {
  byte Byte;
  struct {
    byte MCTOIF      :1;                                       /* Motor Controller Timer Counter Overflow Interrupt Flag */
    byte             :1; 
    byte DITH        :1;                                       /* Motor Control/Driver Dither Feature Enable */
    byte FAST        :1;                                       /* Motor Controller PWM Resolution Mode */
    byte MCSWAI      :1;                                       /* Motor Controller Module Stop in Wait Mode */
    byte MCPRE0      :1;                                       /* Motor Controller Prescaler Select, bit 0 */
    byte MCPRE1      :1;                                       /* Motor Controller Prescaler Select, bit 1 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMCPRE :2;
    byte         :1;
  } MergedBits;
} MCCTL0STR;
extern volatile MCCTL0STR _MCCTL0 @(REG_BASE + 0x000001C0UL);
#define MCCTL0                          _MCCTL0.Byte
#define MCCTL0_MCTOIF                   _MCCTL0.Bits.MCTOIF
#define MCCTL0_DITH                     _MCCTL0.Bits.DITH
#define MCCTL0_FAST                     _MCCTL0.Bits.FAST
#define MCCTL0_MCSWAI                   _MCCTL0.Bits.MCSWAI
#define MCCTL0_MCPRE0                   _MCCTL0.Bits.MCPRE0
#define MCCTL0_MCPRE1                   _MCCTL0.Bits.MCPRE1
/* MCCTL_ARR: Access 2 MCCTLx registers in an array */
#define MCCTL_ARR                       ((volatile byte *) &MCCTL0)
#define MCCTL0_MCPRE                    _MCCTL0.MergedBits.grpMCPRE

#define MCCTL0_MCTOIF_MASK              1U
#define MCCTL0_DITH_MASK                4U
#define MCCTL0_FAST_MASK                8U
#define MCCTL0_MCSWAI_MASK              16U
#define MCCTL0_MCPRE0_MASK              32U
#define MCCTL0_MCPRE1_MASK              64U
#define MCCTL0_MCPRE_MASK               96U
#define MCCTL0_MCPRE_BITNUM             5U


/*** MCCTL1 - Motor Controller Control Register 1; 0x000001C1 ***/
typedef union {
  byte Byte;
  struct {
    byte MCTOIE      :1;                                       /* Motor Controller Timer Counter Overflow Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RECIRC      :1;                                       /* Recirculation in (Dual) Full H-Bridge Mode */
  } Bits;
} MCCTL1STR;
extern volatile MCCTL1STR _MCCTL1 @(REG_BASE + 0x000001C1UL);
#define MCCTL1                          _MCCTL1.Byte
#define MCCTL1_MCTOIE                   _MCCTL1.Bits.MCTOIE
#define MCCTL1_RECIRC                   _MCCTL1.Bits.RECIRC

#define MCCTL1_MCTOIE_MASK              1U
#define MCCTL1_RECIRC_MASK              128U


/*** MCPER - Motor Controller Period Register; 0x000001C2 ***/
typedef union {
  word Word;
  struct {
    word P0          :1;                                       /* Motor Controller Period Bit 1 */
    word P1          :1;                                       /* Motor Controller Period, bit 1 */
    word P2          :1;                                       /* Motor Controller Period, bit 2 */
    word P3          :1;                                       /* Motor Controller Period, bit 3 */
    word P4          :1;                                       /* Motor Controller Period, bit 4 */
    word P5          :1;                                       /* Motor Controller Period, bit 5 */
    word P6          :1;                                       /* Motor Controller Period, bit 6 */
    word P7          :1;                                       /* Motor Controller Period, bit 7 */
    word P8          :1;                                       /* Motor Controller Period, bit 8 */
    word P9          :1;                                       /* Motor Controller Period, bit 9 */
    word P10         :1;                                       /* Motor Controller Period, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpP    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCPERSTR;
extern volatile MCPERSTR _MCPER @(REG_BASE + 0x000001C2UL);
#define MCPER                           _MCPER.Word
#define MCPER_P0                        _MCPER.Bits.P0
#define MCPER_P1                        _MCPER.Bits.P1
#define MCPER_P2                        _MCPER.Bits.P2
#define MCPER_P3                        _MCPER.Bits.P3
#define MCPER_P4                        _MCPER.Bits.P4
#define MCPER_P5                        _MCPER.Bits.P5
#define MCPER_P6                        _MCPER.Bits.P6
#define MCPER_P7                        _MCPER.Bits.P7
#define MCPER_P8                        _MCPER.Bits.P8
#define MCPER_P9                        _MCPER.Bits.P9
#define MCPER_P10                       _MCPER.Bits.P10
#define MCPER_P                         _MCPER.MergedBits.grpP

#define MCPER_P0_MASK                   1U
#define MCPER_P1_MASK                   2U
#define MCPER_P2_MASK                   4U
#define MCPER_P3_MASK                   8U
#define MCPER_P4_MASK                   16U
#define MCPER_P5_MASK                   32U
#define MCPER_P6_MASK                   64U
#define MCPER_P7_MASK                   128U
#define MCPER_P8_MASK                   256U
#define MCPER_P9_MASK                   512U
#define MCPER_P10_MASK                  1024U
#define MCPER_P_MASK                    2047U
#define MCPER_P_BITNUM                  0U


/*** MCCC0 - Motor Controller Control Register 0; 0x000001D0 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC0STR;
extern volatile MCCC0STR _MCCC0 @(REG_BASE + 0x000001D0UL);
#define MCCC0                           _MCCC0.Byte
#define MCCC0_CD0                       _MCCC0.Bits.CD0
#define MCCC0_CD1                       _MCCC0.Bits.CD1
#define MCCC0_MCAM0                     _MCCC0.Bits.MCAM0
#define MCCC0_MCAM1                     _MCCC0.Bits.MCAM1
#define MCCC0_MCOM0                     _MCCC0.Bits.MCOM0
#define MCCC0_MCOM1                     _MCCC0.Bits.MCOM1
/* MCCC_ARR: Access 8 MCCCx registers in an array */
#define MCCC_ARR                        ((volatile byte *) &MCCC0)
#define MCCC0_CD                        _MCCC0.MergedBits.grpCD
#define MCCC0_MCAM                      _MCCC0.MergedBits.grpMCAM
#define MCCC0_MCOM                      _MCCC0.MergedBits.grpMCOM

#define MCCC0_CD0_MASK                  1U
#define MCCC0_CD1_MASK                  2U
#define MCCC0_MCAM0_MASK                16U
#define MCCC0_MCAM1_MASK                32U
#define MCCC0_MCOM0_MASK                64U
#define MCCC0_MCOM1_MASK                128U
#define MCCC0_CD_MASK                   3U
#define MCCC0_CD_BITNUM                 0U
#define MCCC0_MCAM_MASK                 48U
#define MCCC0_MCAM_BITNUM               4U
#define MCCC0_MCOM_MASK                 192U
#define MCCC0_MCOM_BITNUM               6U


/*** MCCC1 - Motor Controller Control Register 1; 0x000001D1 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC1STR;
extern volatile MCCC1STR _MCCC1 @(REG_BASE + 0x000001D1UL);
#define MCCC1                           _MCCC1.Byte
#define MCCC1_CD0                       _MCCC1.Bits.CD0
#define MCCC1_CD1                       _MCCC1.Bits.CD1
#define MCCC1_MCAM0                     _MCCC1.Bits.MCAM0
#define MCCC1_MCAM1                     _MCCC1.Bits.MCAM1
#define MCCC1_MCOM0                     _MCCC1.Bits.MCOM0
#define MCCC1_MCOM1                     _MCCC1.Bits.MCOM1
#define MCCC1_CD                        _MCCC1.MergedBits.grpCD
#define MCCC1_MCAM                      _MCCC1.MergedBits.grpMCAM
#define MCCC1_MCOM                      _MCCC1.MergedBits.grpMCOM

#define MCCC1_CD0_MASK                  1U
#define MCCC1_CD1_MASK                  2U
#define MCCC1_MCAM0_MASK                16U
#define MCCC1_MCAM1_MASK                32U
#define MCCC1_MCOM0_MASK                64U
#define MCCC1_MCOM1_MASK                128U
#define MCCC1_CD_MASK                   3U
#define MCCC1_CD_BITNUM                 0U
#define MCCC1_MCAM_MASK                 48U
#define MCCC1_MCAM_BITNUM               4U
#define MCCC1_MCOM_MASK                 192U
#define MCCC1_MCOM_BITNUM               6U


/*** MCCC2 - Motor Controller Control Register 2; 0x000001D2 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC2STR;
extern volatile MCCC2STR _MCCC2 @(REG_BASE + 0x000001D2UL);
#define MCCC2                           _MCCC2.Byte
#define MCCC2_CD0                       _MCCC2.Bits.CD0
#define MCCC2_CD1                       _MCCC2.Bits.CD1
#define MCCC2_MCAM0                     _MCCC2.Bits.MCAM0
#define MCCC2_MCAM1                     _MCCC2.Bits.MCAM1
#define MCCC2_MCOM0                     _MCCC2.Bits.MCOM0
#define MCCC2_MCOM1                     _MCCC2.Bits.MCOM1
#define MCCC2_CD                        _MCCC2.MergedBits.grpCD
#define MCCC2_MCAM                      _MCCC2.MergedBits.grpMCAM
#define MCCC2_MCOM                      _MCCC2.MergedBits.grpMCOM

#define MCCC2_CD0_MASK                  1U
#define MCCC2_CD1_MASK                  2U
#define MCCC2_MCAM0_MASK                16U
#define MCCC2_MCAM1_MASK                32U
#define MCCC2_MCOM0_MASK                64U
#define MCCC2_MCOM1_MASK                128U
#define MCCC2_CD_MASK                   3U
#define MCCC2_CD_BITNUM                 0U
#define MCCC2_MCAM_MASK                 48U
#define MCCC2_MCAM_BITNUM               4U
#define MCCC2_MCOM_MASK                 192U
#define MCCC2_MCOM_BITNUM               6U


/*** MCCC3 - Motor Controller Control Register 3; 0x000001D3 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC3STR;
extern volatile MCCC3STR _MCCC3 @(REG_BASE + 0x000001D3UL);
#define MCCC3                           _MCCC3.Byte
#define MCCC3_CD0                       _MCCC3.Bits.CD0
#define MCCC3_CD1                       _MCCC3.Bits.CD1
#define MCCC3_MCAM0                     _MCCC3.Bits.MCAM0
#define MCCC3_MCAM1                     _MCCC3.Bits.MCAM1
#define MCCC3_MCOM0                     _MCCC3.Bits.MCOM0
#define MCCC3_MCOM1                     _MCCC3.Bits.MCOM1
#define MCCC3_CD                        _MCCC3.MergedBits.grpCD
#define MCCC3_MCAM                      _MCCC3.MergedBits.grpMCAM
#define MCCC3_MCOM                      _MCCC3.MergedBits.grpMCOM

#define MCCC3_CD0_MASK                  1U
#define MCCC3_CD1_MASK                  2U
#define MCCC3_MCAM0_MASK                16U
#define MCCC3_MCAM1_MASK                32U
#define MCCC3_MCOM0_MASK                64U
#define MCCC3_MCOM1_MASK                128U
#define MCCC3_CD_MASK                   3U
#define MCCC3_CD_BITNUM                 0U
#define MCCC3_MCAM_MASK                 48U
#define MCCC3_MCAM_BITNUM               4U
#define MCCC3_MCOM_MASK                 192U
#define MCCC3_MCOM_BITNUM               6U


/*** MCCC4 - Motor Controller Control Register 4; 0x000001D4 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC4STR;
extern volatile MCCC4STR _MCCC4 @(REG_BASE + 0x000001D4UL);
#define MCCC4                           _MCCC4.Byte
#define MCCC4_CD0                       _MCCC4.Bits.CD0
#define MCCC4_CD1                       _MCCC4.Bits.CD1
#define MCCC4_MCAM0                     _MCCC4.Bits.MCAM0
#define MCCC4_MCAM1                     _MCCC4.Bits.MCAM1
#define MCCC4_MCOM0                     _MCCC4.Bits.MCOM0
#define MCCC4_MCOM1                     _MCCC4.Bits.MCOM1
#define MCCC4_CD                        _MCCC4.MergedBits.grpCD
#define MCCC4_MCAM                      _MCCC4.MergedBits.grpMCAM
#define MCCC4_MCOM                      _MCCC4.MergedBits.grpMCOM

#define MCCC4_CD0_MASK                  1U
#define MCCC4_CD1_MASK                  2U
#define MCCC4_MCAM0_MASK                16U
#define MCCC4_MCAM1_MASK                32U
#define MCCC4_MCOM0_MASK                64U
#define MCCC4_MCOM1_MASK                128U
#define MCCC4_CD_MASK                   3U
#define MCCC4_CD_BITNUM                 0U
#define MCCC4_MCAM_MASK                 48U
#define MCCC4_MCAM_BITNUM               4U
#define MCCC4_MCOM_MASK                 192U
#define MCCC4_MCOM_BITNUM               6U


/*** MCCC5 - Motor Controller Control Register 5; 0x000001D5 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC5STR;
extern volatile MCCC5STR _MCCC5 @(REG_BASE + 0x000001D5UL);
#define MCCC5                           _MCCC5.Byte
#define MCCC5_CD0                       _MCCC5.Bits.CD0
#define MCCC5_CD1                       _MCCC5.Bits.CD1
#define MCCC5_MCAM0                     _MCCC5.Bits.MCAM0
#define MCCC5_MCAM1                     _MCCC5.Bits.MCAM1
#define MCCC5_MCOM0                     _MCCC5.Bits.MCOM0
#define MCCC5_MCOM1                     _MCCC5.Bits.MCOM1
#define MCCC5_CD                        _MCCC5.MergedBits.grpCD
#define MCCC5_MCAM                      _MCCC5.MergedBits.grpMCAM
#define MCCC5_MCOM                      _MCCC5.MergedBits.grpMCOM

#define MCCC5_CD0_MASK                  1U
#define MCCC5_CD1_MASK                  2U
#define MCCC5_MCAM0_MASK                16U
#define MCCC5_MCAM1_MASK                32U
#define MCCC5_MCOM0_MASK                64U
#define MCCC5_MCOM1_MASK                128U
#define MCCC5_CD_MASK                   3U
#define MCCC5_CD_BITNUM                 0U
#define MCCC5_MCAM_MASK                 48U
#define MCCC5_MCAM_BITNUM               4U
#define MCCC5_MCOM_MASK                 192U
#define MCCC5_MCOM_BITNUM               6U


/*** MCCC6 - Motor Controller Control Register 6; 0x000001D6 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC6STR;
extern volatile MCCC6STR _MCCC6 @(REG_BASE + 0x000001D6UL);
#define MCCC6                           _MCCC6.Byte
#define MCCC6_CD0                       _MCCC6.Bits.CD0
#define MCCC6_CD1                       _MCCC6.Bits.CD1
#define MCCC6_MCAM0                     _MCCC6.Bits.MCAM0
#define MCCC6_MCAM1                     _MCCC6.Bits.MCAM1
#define MCCC6_MCOM0                     _MCCC6.Bits.MCOM0
#define MCCC6_MCOM1                     _MCCC6.Bits.MCOM1
#define MCCC6_CD                        _MCCC6.MergedBits.grpCD
#define MCCC6_MCAM                      _MCCC6.MergedBits.grpMCAM
#define MCCC6_MCOM                      _MCCC6.MergedBits.grpMCOM

#define MCCC6_CD0_MASK                  1U
#define MCCC6_CD1_MASK                  2U
#define MCCC6_MCAM0_MASK                16U
#define MCCC6_MCAM1_MASK                32U
#define MCCC6_MCOM0_MASK                64U
#define MCCC6_MCOM1_MASK                128U
#define MCCC6_CD_MASK                   3U
#define MCCC6_CD_BITNUM                 0U
#define MCCC6_MCAM_MASK                 48U
#define MCCC6_MCAM_BITNUM               4U
#define MCCC6_MCOM_MASK                 192U
#define MCCC6_MCOM_BITNUM               6U


/*** MCCC7 - Motor Controller Control Register 7; 0x000001D7 ***/
typedef union {
  byte Byte;
  struct {
    byte CD0         :1;                                       /* PWM Channel Delay */
    byte CD1         :1;                                       /* PWM Channel Delay */
    byte             :1; 
    byte             :1; 
    byte MCAM0       :1;                                       /* PWM Channel Alignment Mode */
    byte MCAM1       :1;                                       /* PWM Channel Alignment Mode */
    byte MCOM0       :1;                                       /* Output Mode */
    byte MCOM1       :1;                                       /* Output Mode */
  } Bits;
  struct {
    byte grpCD   :2;
    byte         :1;
    byte         :1;
    byte grpMCAM :2;
    byte grpMCOM :2;
  } MergedBits;
} MCCC7STR;
extern volatile MCCC7STR _MCCC7 @(REG_BASE + 0x000001D7UL);
#define MCCC7                           _MCCC7.Byte
#define MCCC7_CD0                       _MCCC7.Bits.CD0
#define MCCC7_CD1                       _MCCC7.Bits.CD1
#define MCCC7_MCAM0                     _MCCC7.Bits.MCAM0
#define MCCC7_MCAM1                     _MCCC7.Bits.MCAM1
#define MCCC7_MCOM0                     _MCCC7.Bits.MCOM0
#define MCCC7_MCOM1                     _MCCC7.Bits.MCOM1
#define MCCC7_CD                        _MCCC7.MergedBits.grpCD
#define MCCC7_MCAM                      _MCCC7.MergedBits.grpMCAM
#define MCCC7_MCOM                      _MCCC7.MergedBits.grpMCOM

#define MCCC7_CD0_MASK                  1U
#define MCCC7_CD1_MASK                  2U
#define MCCC7_MCAM0_MASK                16U
#define MCCC7_MCAM1_MASK                32U
#define MCCC7_MCOM0_MASK                64U
#define MCCC7_MCOM1_MASK                128U
#define MCCC7_CD_MASK                   3U
#define MCCC7_CD_BITNUM                 0U
#define MCCC7_MCAM_MASK                 48U
#define MCCC7_MCAM_BITNUM               4U
#define MCCC7_MCOM_MASK                 192U
#define MCCC7_MCOM_BITNUM               6U


/*** MCDC0 - Motor Controller Period Register 0; 0x000001E0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC0_FAST - Motor Controller Period Register 0 access with FAST bit = 1; 0x000001E0 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC0_FASTSTR;
    #define MCDC0_FAST                  _MCDC0.Overlap_STR.MCDC0_FASTSTR.Byte
    #define MCDC0_FAST_D2               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D2
    #define MCDC0_FAST_D3               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D3
    #define MCDC0_FAST_D4               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D4
    #define MCDC0_FAST_D5               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D5
    #define MCDC0_FAST_D6               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D6
    #define MCDC0_FAST_D7               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D7
    #define MCDC0_FAST_D8               _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.D8
    #define MCDC0_FAST_S                _MCDC0.Overlap_STR.MCDC0_FASTSTR.Bits.S
    #define MCDC0_FAST_D_2              _MCDC0.Overlap_STR.MCDC0_FASTSTR.MergedBits.grpD_2
    #define MCDC0_FAST_D                MCDC0_FAST_D_2
    
    #define MCDC0_FAST_D2_MASK          1U
    #define MCDC0_FAST_D3_MASK          2U
    #define MCDC0_FAST_D4_MASK          4U
    #define MCDC0_FAST_D5_MASK          8U
    #define MCDC0_FAST_D6_MASK          16U
    #define MCDC0_FAST_D7_MASK          32U
    #define MCDC0_FAST_D8_MASK          64U
    #define MCDC0_FAST_S_MASK           128U
    #define MCDC0_FAST_D_2_MASK         127U
    #define MCDC0_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC0STR;
extern volatile MCDC0STR _MCDC0 @(REG_BASE + 0x000001E0UL);
#define MCDC0                           _MCDC0.Word
#define MCDC0_D0                        _MCDC0.Bits.D0
#define MCDC0_D1                        _MCDC0.Bits.D1
#define MCDC0_D2                        _MCDC0.Bits.D2
#define MCDC0_D3                        _MCDC0.Bits.D3
#define MCDC0_D4                        _MCDC0.Bits.D4
#define MCDC0_D5                        _MCDC0.Bits.D5
#define MCDC0_D6                        _MCDC0.Bits.D6
#define MCDC0_D7                        _MCDC0.Bits.D7
#define MCDC0_D8                        _MCDC0.Bits.D8
#define MCDC0_D9                        _MCDC0.Bits.D9
#define MCDC0_D10                       _MCDC0.Bits.D10
#define MCDC0_S                         _MCDC0.Bits.S
/* MCDC_ARR: Access 8 MCDCx registers in an array */
#define MCDC_ARR                        ((volatile word *) &MCDC0)
#define MCDC0_D                         _MCDC0.MergedBits.grpD

#define MCDC0_D0_MASK                   1U
#define MCDC0_D1_MASK                   2U
#define MCDC0_D2_MASK                   4U
#define MCDC0_D3_MASK                   8U
#define MCDC0_D4_MASK                   16U
#define MCDC0_D5_MASK                   32U
#define MCDC0_D6_MASK                   64U
#define MCDC0_D7_MASK                   128U
#define MCDC0_D8_MASK                   256U
#define MCDC0_D9_MASK                   512U
#define MCDC0_D10_MASK                  1024U
#define MCDC0_S_MASK                    32768U
#define MCDC0_D_MASK                    2047U
#define MCDC0_D_BITNUM                  0U


/*** MCDC1 - Motor Controller Period Register 1; 0x000001E2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC1_FAST - Motor Controller Period Register 1 access with FAST bit = 1; 0x000001E2 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC1_FASTSTR;
    #define MCDC1_FAST                  _MCDC1.Overlap_STR.MCDC1_FASTSTR.Byte
    #define MCDC1_FAST_D2               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D2
    #define MCDC1_FAST_D3               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D3
    #define MCDC1_FAST_D4               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D4
    #define MCDC1_FAST_D5               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D5
    #define MCDC1_FAST_D6               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D6
    #define MCDC1_FAST_D7               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D7
    #define MCDC1_FAST_D8               _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.D8
    #define MCDC1_FAST_S                _MCDC1.Overlap_STR.MCDC1_FASTSTR.Bits.S
    #define MCDC1_FAST_D_2              _MCDC1.Overlap_STR.MCDC1_FASTSTR.MergedBits.grpD_2
    #define MCDC1_FAST_D                MCDC1_FAST_D_2
    
    #define MCDC1_FAST_D2_MASK          1U
    #define MCDC1_FAST_D3_MASK          2U
    #define MCDC1_FAST_D4_MASK          4U
    #define MCDC1_FAST_D5_MASK          8U
    #define MCDC1_FAST_D6_MASK          16U
    #define MCDC1_FAST_D7_MASK          32U
    #define MCDC1_FAST_D8_MASK          64U
    #define MCDC1_FAST_S_MASK           128U
    #define MCDC1_FAST_D_2_MASK         127U
    #define MCDC1_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC1STR;
extern volatile MCDC1STR _MCDC1 @(REG_BASE + 0x000001E2UL);
#define MCDC1                           _MCDC1.Word
#define MCDC1_D0                        _MCDC1.Bits.D0
#define MCDC1_D1                        _MCDC1.Bits.D1
#define MCDC1_D2                        _MCDC1.Bits.D2
#define MCDC1_D3                        _MCDC1.Bits.D3
#define MCDC1_D4                        _MCDC1.Bits.D4
#define MCDC1_D5                        _MCDC1.Bits.D5
#define MCDC1_D6                        _MCDC1.Bits.D6
#define MCDC1_D7                        _MCDC1.Bits.D7
#define MCDC1_D8                        _MCDC1.Bits.D8
#define MCDC1_D9                        _MCDC1.Bits.D9
#define MCDC1_D10                       _MCDC1.Bits.D10
#define MCDC1_S                         _MCDC1.Bits.S
#define MCDC1_D                         _MCDC1.MergedBits.grpD

#define MCDC1_D0_MASK                   1U
#define MCDC1_D1_MASK                   2U
#define MCDC1_D2_MASK                   4U
#define MCDC1_D3_MASK                   8U
#define MCDC1_D4_MASK                   16U
#define MCDC1_D5_MASK                   32U
#define MCDC1_D6_MASK                   64U
#define MCDC1_D7_MASK                   128U
#define MCDC1_D8_MASK                   256U
#define MCDC1_D9_MASK                   512U
#define MCDC1_D10_MASK                  1024U
#define MCDC1_S_MASK                    32768U
#define MCDC1_D_MASK                    2047U
#define MCDC1_D_BITNUM                  0U


/*** MCDC2 - Motor Controller Period Register 2; 0x000001E4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC2_FAST - Motor Controller Period Register 2 access with FAST bit = 1; 0x000001E4 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC2_FASTSTR;
    #define MCDC2_FAST                  _MCDC2.Overlap_STR.MCDC2_FASTSTR.Byte
    #define MCDC2_FAST_D2               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D2
    #define MCDC2_FAST_D3               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D3
    #define MCDC2_FAST_D4               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D4
    #define MCDC2_FAST_D5               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D5
    #define MCDC2_FAST_D6               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D6
    #define MCDC2_FAST_D7               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D7
    #define MCDC2_FAST_D8               _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.D8
    #define MCDC2_FAST_S                _MCDC2.Overlap_STR.MCDC2_FASTSTR.Bits.S
    #define MCDC2_FAST_D_2              _MCDC2.Overlap_STR.MCDC2_FASTSTR.MergedBits.grpD_2
    #define MCDC2_FAST_D                MCDC2_FAST_D_2
    
    #define MCDC2_FAST_D2_MASK          1U
    #define MCDC2_FAST_D3_MASK          2U
    #define MCDC2_FAST_D4_MASK          4U
    #define MCDC2_FAST_D5_MASK          8U
    #define MCDC2_FAST_D6_MASK          16U
    #define MCDC2_FAST_D7_MASK          32U
    #define MCDC2_FAST_D8_MASK          64U
    #define MCDC2_FAST_S_MASK           128U
    #define MCDC2_FAST_D_2_MASK         127U
    #define MCDC2_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC2STR;
extern volatile MCDC2STR _MCDC2 @(REG_BASE + 0x000001E4UL);
#define MCDC2                           _MCDC2.Word
#define MCDC2_D0                        _MCDC2.Bits.D0
#define MCDC2_D1                        _MCDC2.Bits.D1
#define MCDC2_D2                        _MCDC2.Bits.D2
#define MCDC2_D3                        _MCDC2.Bits.D3
#define MCDC2_D4                        _MCDC2.Bits.D4
#define MCDC2_D5                        _MCDC2.Bits.D5
#define MCDC2_D6                        _MCDC2.Bits.D6
#define MCDC2_D7                        _MCDC2.Bits.D7
#define MCDC2_D8                        _MCDC2.Bits.D8
#define MCDC2_D9                        _MCDC2.Bits.D9
#define MCDC2_D10                       _MCDC2.Bits.D10
#define MCDC2_S                         _MCDC2.Bits.S
#define MCDC2_D                         _MCDC2.MergedBits.grpD

#define MCDC2_D0_MASK                   1U
#define MCDC2_D1_MASK                   2U
#define MCDC2_D2_MASK                   4U
#define MCDC2_D3_MASK                   8U
#define MCDC2_D4_MASK                   16U
#define MCDC2_D5_MASK                   32U
#define MCDC2_D6_MASK                   64U
#define MCDC2_D7_MASK                   128U
#define MCDC2_D8_MASK                   256U
#define MCDC2_D9_MASK                   512U
#define MCDC2_D10_MASK                  1024U
#define MCDC2_S_MASK                    32768U
#define MCDC2_D_MASK                    2047U
#define MCDC2_D_BITNUM                  0U


/*** MCDC3 - Motor Controller Period Register 3; 0x000001E6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC3_FAST - Motor Controller Period Register 3 access with FAST bit = 1; 0x000001E6 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC3_FASTSTR;
    #define MCDC3_FAST                  _MCDC3.Overlap_STR.MCDC3_FASTSTR.Byte
    #define MCDC3_FAST_D2               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D2
    #define MCDC3_FAST_D3               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D3
    #define MCDC3_FAST_D4               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D4
    #define MCDC3_FAST_D5               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D5
    #define MCDC3_FAST_D6               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D6
    #define MCDC3_FAST_D7               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D7
    #define MCDC3_FAST_D8               _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.D8
    #define MCDC3_FAST_S                _MCDC3.Overlap_STR.MCDC3_FASTSTR.Bits.S
    #define MCDC3_FAST_D_2              _MCDC3.Overlap_STR.MCDC3_FASTSTR.MergedBits.grpD_2
    #define MCDC3_FAST_D                MCDC3_FAST_D_2
    
    #define MCDC3_FAST_D2_MASK          1U
    #define MCDC3_FAST_D3_MASK          2U
    #define MCDC3_FAST_D4_MASK          4U
    #define MCDC3_FAST_D5_MASK          8U
    #define MCDC3_FAST_D6_MASK          16U
    #define MCDC3_FAST_D7_MASK          32U
    #define MCDC3_FAST_D8_MASK          64U
    #define MCDC3_FAST_S_MASK           128U
    #define MCDC3_FAST_D_2_MASK         127U
    #define MCDC3_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC3STR;
extern volatile MCDC3STR _MCDC3 @(REG_BASE + 0x000001E6UL);
#define MCDC3                           _MCDC3.Word
#define MCDC3_D0                        _MCDC3.Bits.D0
#define MCDC3_D1                        _MCDC3.Bits.D1
#define MCDC3_D2                        _MCDC3.Bits.D2
#define MCDC3_D3                        _MCDC3.Bits.D3
#define MCDC3_D4                        _MCDC3.Bits.D4
#define MCDC3_D5                        _MCDC3.Bits.D5
#define MCDC3_D6                        _MCDC3.Bits.D6
#define MCDC3_D7                        _MCDC3.Bits.D7
#define MCDC3_D8                        _MCDC3.Bits.D8
#define MCDC3_D9                        _MCDC3.Bits.D9
#define MCDC3_D10                       _MCDC3.Bits.D10
#define MCDC3_S                         _MCDC3.Bits.S
#define MCDC3_D                         _MCDC3.MergedBits.grpD

#define MCDC3_D0_MASK                   1U
#define MCDC3_D1_MASK                   2U
#define MCDC3_D2_MASK                   4U
#define MCDC3_D3_MASK                   8U
#define MCDC3_D4_MASK                   16U
#define MCDC3_D5_MASK                   32U
#define MCDC3_D6_MASK                   64U
#define MCDC3_D7_MASK                   128U
#define MCDC3_D8_MASK                   256U
#define MCDC3_D9_MASK                   512U
#define MCDC3_D10_MASK                  1024U
#define MCDC3_S_MASK                    32768U
#define MCDC3_D_MASK                    2047U
#define MCDC3_D_BITNUM                  0U


/*** MCDC4 - Motor Controller Period Register 4; 0x000001E8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC4_FAST - Motor Controller Period Register 4 access with FAST bit = 1; 0x000001E8 ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC4_FASTSTR;
    #define MCDC4_FAST                  _MCDC4.Overlap_STR.MCDC4_FASTSTR.Byte
    #define MCDC4_FAST_D2               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D2
    #define MCDC4_FAST_D3               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D3
    #define MCDC4_FAST_D4               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D4
    #define MCDC4_FAST_D5               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D5
    #define MCDC4_FAST_D6               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D6
    #define MCDC4_FAST_D7               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D7
    #define MCDC4_FAST_D8               _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.D8
    #define MCDC4_FAST_S                _MCDC4.Overlap_STR.MCDC4_FASTSTR.Bits.S
    #define MCDC4_FAST_D_2              _MCDC4.Overlap_STR.MCDC4_FASTSTR.MergedBits.grpD_2
    #define MCDC4_FAST_D                MCDC4_FAST_D_2
    
    #define MCDC4_FAST_D2_MASK          1U
    #define MCDC4_FAST_D3_MASK          2U
    #define MCDC4_FAST_D4_MASK          4U
    #define MCDC4_FAST_D5_MASK          8U
    #define MCDC4_FAST_D6_MASK          16U
    #define MCDC4_FAST_D7_MASK          32U
    #define MCDC4_FAST_D8_MASK          64U
    #define MCDC4_FAST_S_MASK           128U
    #define MCDC4_FAST_D_2_MASK         127U
    #define MCDC4_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC4STR;
extern volatile MCDC4STR _MCDC4 @(REG_BASE + 0x000001E8UL);
#define MCDC4                           _MCDC4.Word
#define MCDC4_D0                        _MCDC4.Bits.D0
#define MCDC4_D1                        _MCDC4.Bits.D1
#define MCDC4_D2                        _MCDC4.Bits.D2
#define MCDC4_D3                        _MCDC4.Bits.D3
#define MCDC4_D4                        _MCDC4.Bits.D4
#define MCDC4_D5                        _MCDC4.Bits.D5
#define MCDC4_D6                        _MCDC4.Bits.D6
#define MCDC4_D7                        _MCDC4.Bits.D7
#define MCDC4_D8                        _MCDC4.Bits.D8
#define MCDC4_D9                        _MCDC4.Bits.D9
#define MCDC4_D10                       _MCDC4.Bits.D10
#define MCDC4_S                         _MCDC4.Bits.S
#define MCDC4_D                         _MCDC4.MergedBits.grpD

#define MCDC4_D0_MASK                   1U
#define MCDC4_D1_MASK                   2U
#define MCDC4_D2_MASK                   4U
#define MCDC4_D3_MASK                   8U
#define MCDC4_D4_MASK                   16U
#define MCDC4_D5_MASK                   32U
#define MCDC4_D6_MASK                   64U
#define MCDC4_D7_MASK                   128U
#define MCDC4_D8_MASK                   256U
#define MCDC4_D9_MASK                   512U
#define MCDC4_D10_MASK                  1024U
#define MCDC4_S_MASK                    32768U
#define MCDC4_D_MASK                    2047U
#define MCDC4_D_BITNUM                  0U


/*** MCDC5 - Motor Controller Period Register 5; 0x000001EA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC5_FAST - Motor Controller Period Register 5 access with FAST bit = 1; 0x000001EA ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC5_FASTSTR;
    #define MCDC5_FAST                  _MCDC5.Overlap_STR.MCDC5_FASTSTR.Byte
    #define MCDC5_FAST_D2               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D2
    #define MCDC5_FAST_D3               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D3
    #define MCDC5_FAST_D4               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D4
    #define MCDC5_FAST_D5               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D5
    #define MCDC5_FAST_D6               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D6
    #define MCDC5_FAST_D7               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D7
    #define MCDC5_FAST_D8               _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.D8
    #define MCDC5_FAST_S                _MCDC5.Overlap_STR.MCDC5_FASTSTR.Bits.S
    #define MCDC5_FAST_D_2              _MCDC5.Overlap_STR.MCDC5_FASTSTR.MergedBits.grpD_2
    #define MCDC5_FAST_D                MCDC5_FAST_D_2
    
    #define MCDC5_FAST_D2_MASK          1U
    #define MCDC5_FAST_D3_MASK          2U
    #define MCDC5_FAST_D4_MASK          4U
    #define MCDC5_FAST_D5_MASK          8U
    #define MCDC5_FAST_D6_MASK          16U
    #define MCDC5_FAST_D7_MASK          32U
    #define MCDC5_FAST_D8_MASK          64U
    #define MCDC5_FAST_S_MASK           128U
    #define MCDC5_FAST_D_2_MASK         127U
    #define MCDC5_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC5STR;
extern volatile MCDC5STR _MCDC5 @(REG_BASE + 0x000001EAUL);
#define MCDC5                           _MCDC5.Word
#define MCDC5_D0                        _MCDC5.Bits.D0
#define MCDC5_D1                        _MCDC5.Bits.D1
#define MCDC5_D2                        _MCDC5.Bits.D2
#define MCDC5_D3                        _MCDC5.Bits.D3
#define MCDC5_D4                        _MCDC5.Bits.D4
#define MCDC5_D5                        _MCDC5.Bits.D5
#define MCDC5_D6                        _MCDC5.Bits.D6
#define MCDC5_D7                        _MCDC5.Bits.D7
#define MCDC5_D8                        _MCDC5.Bits.D8
#define MCDC5_D9                        _MCDC5.Bits.D9
#define MCDC5_D10                       _MCDC5.Bits.D10
#define MCDC5_S                         _MCDC5.Bits.S
#define MCDC5_D                         _MCDC5.MergedBits.grpD

#define MCDC5_D0_MASK                   1U
#define MCDC5_D1_MASK                   2U
#define MCDC5_D2_MASK                   4U
#define MCDC5_D3_MASK                   8U
#define MCDC5_D4_MASK                   16U
#define MCDC5_D5_MASK                   32U
#define MCDC5_D6_MASK                   64U
#define MCDC5_D7_MASK                   128U
#define MCDC5_D8_MASK                   256U
#define MCDC5_D9_MASK                   512U
#define MCDC5_D10_MASK                  1024U
#define MCDC5_S_MASK                    32768U
#define MCDC5_D_MASK                    2047U
#define MCDC5_D_BITNUM                  0U


/*** MCDC6 - Motor Controller Period Register 6; 0x000001EC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC6_FAST - Motor Controller Period Register 6 access with FAST bit = 1; 0x000001EC ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC6_FASTSTR;
    #define MCDC6_FAST                  _MCDC6.Overlap_STR.MCDC6_FASTSTR.Byte
    #define MCDC6_FAST_D2               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D2
    #define MCDC6_FAST_D3               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D3
    #define MCDC6_FAST_D4               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D4
    #define MCDC6_FAST_D5               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D5
    #define MCDC6_FAST_D6               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D6
    #define MCDC6_FAST_D7               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D7
    #define MCDC6_FAST_D8               _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.D8
    #define MCDC6_FAST_S                _MCDC6.Overlap_STR.MCDC6_FASTSTR.Bits.S
    #define MCDC6_FAST_D_2              _MCDC6.Overlap_STR.MCDC6_FASTSTR.MergedBits.grpD_2
    #define MCDC6_FAST_D                MCDC6_FAST_D_2
    
    #define MCDC6_FAST_D2_MASK          1U
    #define MCDC6_FAST_D3_MASK          2U
    #define MCDC6_FAST_D4_MASK          4U
    #define MCDC6_FAST_D5_MASK          8U
    #define MCDC6_FAST_D6_MASK          16U
    #define MCDC6_FAST_D7_MASK          32U
    #define MCDC6_FAST_D8_MASK          64U
    #define MCDC6_FAST_S_MASK           128U
    #define MCDC6_FAST_D_2_MASK         127U
    #define MCDC6_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC6STR;
extern volatile MCDC6STR _MCDC6 @(REG_BASE + 0x000001ECUL);
#define MCDC6                           _MCDC6.Word
#define MCDC6_D0                        _MCDC6.Bits.D0
#define MCDC6_D1                        _MCDC6.Bits.D1
#define MCDC6_D2                        _MCDC6.Bits.D2
#define MCDC6_D3                        _MCDC6.Bits.D3
#define MCDC6_D4                        _MCDC6.Bits.D4
#define MCDC6_D5                        _MCDC6.Bits.D5
#define MCDC6_D6                        _MCDC6.Bits.D6
#define MCDC6_D7                        _MCDC6.Bits.D7
#define MCDC6_D8                        _MCDC6.Bits.D8
#define MCDC6_D9                        _MCDC6.Bits.D9
#define MCDC6_D10                       _MCDC6.Bits.D10
#define MCDC6_S                         _MCDC6.Bits.S
#define MCDC6_D                         _MCDC6.MergedBits.grpD

#define MCDC6_D0_MASK                   1U
#define MCDC6_D1_MASK                   2U
#define MCDC6_D2_MASK                   4U
#define MCDC6_D3_MASK                   8U
#define MCDC6_D4_MASK                   16U
#define MCDC6_D5_MASK                   32U
#define MCDC6_D6_MASK                   64U
#define MCDC6_D7_MASK                   128U
#define MCDC6_D8_MASK                   256U
#define MCDC6_D9_MASK                   512U
#define MCDC6_D10_MASK                  1024U
#define MCDC6_S_MASK                    32768U
#define MCDC6_D_MASK                    2047U
#define MCDC6_D_BITNUM                  0U


/*** MCDC7 - Motor Controller Period Register 7; 0x000001EE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCDC7_FAST - Motor Controller Period Register 7 access with FAST bit = 1; 0x000001EE ***/
    union {
      byte Byte;
      struct {
        byte D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
        byte D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
        byte D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
        byte D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
        byte D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
        byte D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
        byte D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
        byte S           :1;                                       /* Sign */
      } Bits;
      struct {
        byte grpD_2 :7;
        byte     :1;
      } MergedBits;
    } MCDC7_FASTSTR;
    #define MCDC7_FAST                  _MCDC7.Overlap_STR.MCDC7_FASTSTR.Byte
    #define MCDC7_FAST_D2               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D2
    #define MCDC7_FAST_D3               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D3
    #define MCDC7_FAST_D4               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D4
    #define MCDC7_FAST_D5               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D5
    #define MCDC7_FAST_D6               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D6
    #define MCDC7_FAST_D7               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D7
    #define MCDC7_FAST_D8               _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.D8
    #define MCDC7_FAST_S                _MCDC7.Overlap_STR.MCDC7_FASTSTR.Bits.S
    #define MCDC7_FAST_D_2              _MCDC7.Overlap_STR.MCDC7_FASTSTR.MergedBits.grpD_2
    #define MCDC7_FAST_D                MCDC7_FAST_D_2
    
    #define MCDC7_FAST_D2_MASK          1U
    #define MCDC7_FAST_D3_MASK          2U
    #define MCDC7_FAST_D4_MASK          4U
    #define MCDC7_FAST_D5_MASK          8U
    #define MCDC7_FAST_D6_MASK          16U
    #define MCDC7_FAST_D7_MASK          32U
    #define MCDC7_FAST_D8_MASK          64U
    #define MCDC7_FAST_S_MASK           128U
    #define MCDC7_FAST_D_2_MASK         127U
    #define MCDC7_FAST_D_2_BITNUM       0U
    
  } Overlap_STR;

  struct {
    word D0          :1;                                       /* Motor Controller Duty Cycle, bit 0 */
    word D1          :1;                                       /* Motor Controller Duty Cycle, bit 1 */
    word D2          :1;                                       /* Motor Controller Duty Cycle, bit 2 */
    word D3          :1;                                       /* Motor Controller Duty Cycle, bit 3 */
    word D4          :1;                                       /* Motor Controller Duty Cycle, bit 4 */
    word D5          :1;                                       /* Motor Controller Duty Cycle, bit 5 */
    word D6          :1;                                       /* Motor Controller Duty Cycle, bit 6 */
    word D7          :1;                                       /* Motor Controller Duty Cycle, bit 7 */
    word D8          :1;                                       /* Motor Controller Duty Cycle, bit 8 */
    word D9          :1;                                       /* Motor Controller Duty Cycle, bit 9 */
    word D10         :1;                                       /* Motor Controller Duty Cycle, bit 10 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word S           :1;                                       /* Sign */
  } Bits;
  struct {
    word grpD    :11;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCDC7STR;
extern volatile MCDC7STR _MCDC7 @(REG_BASE + 0x000001EEUL);
#define MCDC7                           _MCDC7.Word
#define MCDC7_D0                        _MCDC7.Bits.D0
#define MCDC7_D1                        _MCDC7.Bits.D1
#define MCDC7_D2                        _MCDC7.Bits.D2
#define MCDC7_D3                        _MCDC7.Bits.D3
#define MCDC7_D4                        _MCDC7.Bits.D4
#define MCDC7_D5                        _MCDC7.Bits.D5
#define MCDC7_D6                        _MCDC7.Bits.D6
#define MCDC7_D7                        _MCDC7.Bits.D7
#define MCDC7_D8                        _MCDC7.Bits.D8
#define MCDC7_D9                        _MCDC7.Bits.D9
#define MCDC7_D10                       _MCDC7.Bits.D10
#define MCDC7_S                         _MCDC7.Bits.S
#define MCDC7_D                         _MCDC7.MergedBits.grpD

#define MCDC7_D0_MASK                   1U
#define MCDC7_D1_MASK                   2U
#define MCDC7_D2_MASK                   4U
#define MCDC7_D3_MASK                   8U
#define MCDC7_D4_MASK                   16U
#define MCDC7_D5_MASK                   32U
#define MCDC7_D6_MASK                   64U
#define MCDC7_D7_MASK                   128U
#define MCDC7_D8_MASK                   256U
#define MCDC7_D9_MASK                   512U
#define MCDC7_D10_MASK                  1024U
#define MCDC7_S_MASK                    32768U
#define MCDC7_D_MASK                    2047U
#define MCDC7_D_BITNUM                  0U


/*** LCDCR0 - LCD Control Register 0; 0x00000200 ***/
typedef union {
  byte Byte;
  struct {
    byte DUTY0       :1;                                       /* LCD Duty Select Bit 0 */
    byte DUTY1       :1;                                       /* LCD Duty Select Bit 1 */
    byte BIAS        :1;                                       /* BIAS Voltage Level Select */
    byte LCLK0       :1;                                       /* LCD Clock Prescaler Bit 0 */
    byte LCLK1       :1;                                       /* LCD Clock Prescaler Bit 1 */
    byte LCLK2       :1;                                       /* LCD Clock Prescaler Bit 2 */
    byte             :1; 
    byte LCDEN       :1;                                       /* LCD32F4BV1 Driver System Enable */
  } Bits;
  struct {
    byte grpDUTY :2;
    byte         :1;
    byte grpLCLK :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDCR0STR;
extern volatile LCDCR0STR _LCDCR0 @(REG_BASE + 0x00000200UL);
#define LCDCR0                          _LCDCR0.Byte
#define LCDCR0_DUTY0                    _LCDCR0.Bits.DUTY0
#define LCDCR0_DUTY1                    _LCDCR0.Bits.DUTY1
#define LCDCR0_BIAS                     _LCDCR0.Bits.BIAS
#define LCDCR0_LCLK0                    _LCDCR0.Bits.LCLK0
#define LCDCR0_LCLK1                    _LCDCR0.Bits.LCLK1
#define LCDCR0_LCLK2                    _LCDCR0.Bits.LCLK2
#define LCDCR0_LCDEN                    _LCDCR0.Bits.LCDEN
/* LCDCR_ARR: Access 2 LCDCRx registers in an array */
#define LCDCR_ARR                       ((volatile byte *) &LCDCR0)
#define LCDCR0_DUTY                     _LCDCR0.MergedBits.grpDUTY
#define LCDCR0_LCLK                     _LCDCR0.MergedBits.grpLCLK

#define LCDCR0_DUTY0_MASK               1U
#define LCDCR0_DUTY1_MASK               2U
#define LCDCR0_BIAS_MASK                4U
#define LCDCR0_LCLK0_MASK               8U
#define LCDCR0_LCLK1_MASK               16U
#define LCDCR0_LCLK2_MASK               32U
#define LCDCR0_LCDEN_MASK               128U
#define LCDCR0_DUTY_MASK                3U
#define LCDCR0_DUTY_BITNUM              0U
#define LCDCR0_LCLK_MASK                56U
#define LCDCR0_LCLK_BITNUM              3U


/*** LCDCR1 - LCD Control Register 1; 0x00000201 ***/
typedef union {
  byte Byte;
  struct {
    byte LCDRPSTP    :1;                                       /* LCD Run in Pseudo Stop Mode */
    byte LCDSWAI     :1;                                       /* LCD Stop in Wait Mode */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} LCDCR1STR;
extern volatile LCDCR1STR _LCDCR1 @(REG_BASE + 0x00000201UL);
#define LCDCR1                          _LCDCR1.Byte
#define LCDCR1_LCDRPSTP                 _LCDCR1.Bits.LCDRPSTP
#define LCDCR1_LCDSWAI                  _LCDCR1.Bits.LCDSWAI

#define LCDCR1_LCDRPSTP_MASK            1U
#define LCDCR1_LCDSWAI_MASK             2U


/*** FPENR0 - LCD Frontplane Enable Register 0; 0x00000202 ***/
typedef union {
  byte Byte;
  struct {
    byte FP0EN       :1;                                       /* Frontplane Output Enable Bit 0 */
    byte FP1EN       :1;                                       /* Frontplane Output Enable Bit 1 */
    byte FP2EN       :1;                                       /* Frontplane Output Enable Bit 2 */
    byte FP3EN       :1;                                       /* Frontplane Output Enable Bit 3 */
    byte FP4EN       :1;                                       /* Frontplane Output Enable Bit 4 */
    byte FP5EN       :1;                                       /* Frontplane Output Enable Bit 5 */
    byte FP6EN       :1;                                       /* Frontplane Output Enable Bit 6 */
    byte FP7EN       :1;                                       /* Frontplane Output Enable Bit 7 */
  } Bits;
} FPENR0STR;
extern volatile FPENR0STR _FPENR0 @(REG_BASE + 0x00000202UL);
#define FPENR0                          _FPENR0.Byte
#define FPENR0_FP0EN                    _FPENR0.Bits.FP0EN
#define FPENR0_FP1EN                    _FPENR0.Bits.FP1EN
#define FPENR0_FP2EN                    _FPENR0.Bits.FP2EN
#define FPENR0_FP3EN                    _FPENR0.Bits.FP3EN
#define FPENR0_FP4EN                    _FPENR0.Bits.FP4EN
#define FPENR0_FP5EN                    _FPENR0.Bits.FP5EN
#define FPENR0_FP6EN                    _FPENR0.Bits.FP6EN
#define FPENR0_FP7EN                    _FPENR0.Bits.FP7EN
/* FPENR_ARR: Access 5 FPENRx registers in an array */
#define FPENR_ARR                       ((volatile byte *) &FPENR0)

#define FPENR0_FP0EN_MASK               1U
#define FPENR0_FP1EN_MASK               2U
#define FPENR0_FP2EN_MASK               4U
#define FPENR0_FP3EN_MASK               8U
#define FPENR0_FP4EN_MASK               16U
#define FPENR0_FP5EN_MASK               32U
#define FPENR0_FP6EN_MASK               64U
#define FPENR0_FP7EN_MASK               128U


/*** FPENR1 - LCD Frontplane Enable Register 1; 0x00000203 ***/
typedef union {
  byte Byte;
  struct {
    byte FP8EN       :1;                                       /* Frontplane Output Enable Bit 8 */
    byte FP9EN       :1;                                       /* Frontplane Output Enable Bit 9 */
    byte FP10EN      :1;                                       /* Frontplane Output Enable Bit 10 */
    byte FP11EN      :1;                                       /* Frontplane Output Enable Bit 11 */
    byte FP12EN      :1;                                       /* Frontplane Output Enable Bit 12 */
    byte FP13EN      :1;                                       /* Frontplane Output Enable Bit 13 */
    byte FP14EN      :1;                                       /* Frontplane Output Enable Bit 14 */
    byte FP15EN      :1;                                       /* Frontplane Output Enable Bit 15 */
  } Bits;
} FPENR1STR;
extern volatile FPENR1STR _FPENR1 @(REG_BASE + 0x00000203UL);
#define FPENR1                          _FPENR1.Byte
#define FPENR1_FP8EN                    _FPENR1.Bits.FP8EN
#define FPENR1_FP9EN                    _FPENR1.Bits.FP9EN
#define FPENR1_FP10EN                   _FPENR1.Bits.FP10EN
#define FPENR1_FP11EN                   _FPENR1.Bits.FP11EN
#define FPENR1_FP12EN                   _FPENR1.Bits.FP12EN
#define FPENR1_FP13EN                   _FPENR1.Bits.FP13EN
#define FPENR1_FP14EN                   _FPENR1.Bits.FP14EN
#define FPENR1_FP15EN                   _FPENR1.Bits.FP15EN

#define FPENR1_FP8EN_MASK               1U
#define FPENR1_FP9EN_MASK               2U
#define FPENR1_FP10EN_MASK              4U
#define FPENR1_FP11EN_MASK              8U
#define FPENR1_FP12EN_MASK              16U
#define FPENR1_FP13EN_MASK              32U
#define FPENR1_FP14EN_MASK              64U
#define FPENR1_FP15EN_MASK              128U


/*** FPENR2 - LCD Frontplane Enable Register 2; 0x00000204 ***/
typedef union {
  byte Byte;
  struct {
    byte FP16EN      :1;                                       /* Frontplane Output Enable Bit 16 */
    byte FP17EN      :1;                                       /* Frontplane Output Enable Bit 17 */
    byte FP18EN      :1;                                       /* Frontplane Output Enable Bit 18 */
    byte FP19EN      :1;                                       /* Frontplane Output Enable Bit 19 */
    byte FP20EN      :1;                                       /* Frontplane Output Enable Bit 20 */
    byte FP21EN      :1;                                       /* Frontplane Output Enable Bit 21 */
    byte FP22EN      :1;                                       /* Frontplane Output Enable Bit 22 */
    byte FP23EN      :1;                                       /* Frontplane Output Enable Bit 23 */
  } Bits;
} FPENR2STR;
extern volatile FPENR2STR _FPENR2 @(REG_BASE + 0x00000204UL);
#define FPENR2                          _FPENR2.Byte
#define FPENR2_FP16EN                   _FPENR2.Bits.FP16EN
#define FPENR2_FP17EN                   _FPENR2.Bits.FP17EN
#define FPENR2_FP18EN                   _FPENR2.Bits.FP18EN
#define FPENR2_FP19EN                   _FPENR2.Bits.FP19EN
#define FPENR2_FP20EN                   _FPENR2.Bits.FP20EN
#define FPENR2_FP21EN                   _FPENR2.Bits.FP21EN
#define FPENR2_FP22EN                   _FPENR2.Bits.FP22EN
#define FPENR2_FP23EN                   _FPENR2.Bits.FP23EN

#define FPENR2_FP16EN_MASK              1U
#define FPENR2_FP17EN_MASK              2U
#define FPENR2_FP18EN_MASK              4U
#define FPENR2_FP19EN_MASK              8U
#define FPENR2_FP20EN_MASK              16U
#define FPENR2_FP21EN_MASK              32U
#define FPENR2_FP22EN_MASK              64U
#define FPENR2_FP23EN_MASK              128U


/*** FPENR3 - LCD Frontplane Enable Register 3; 0x00000205 ***/
typedef union {
  byte Byte;
  struct {
    byte FP24EN      :1;                                       /* Frontplane Output Enable Bit 24 */
    byte FP25EN      :1;                                       /* Frontplane Output Enable Bit 25 */
    byte FP26EN      :1;                                       /* Frontplane Output Enable Bit 26 */
    byte FP27EN      :1;                                       /* Frontplane Output Enable Bit 27 */
    byte FP28EN      :1;                                       /* Frontplane Output Enable Bit 28 */
    byte FP29EN      :1;                                       /* Frontplane Output Enable Bit 29 */
    byte FP30EN      :1;                                       /* Frontplane Output Enable Bit 30 */
    byte FP31EN      :1;                                       /* Frontplane Output Enable Bit 31 */
  } Bits;
} FPENR3STR;
extern volatile FPENR3STR _FPENR3 @(REG_BASE + 0x00000205UL);
#define FPENR3                          _FPENR3.Byte
#define FPENR3_FP24EN                   _FPENR3.Bits.FP24EN
#define FPENR3_FP25EN                   _FPENR3.Bits.FP25EN
#define FPENR3_FP26EN                   _FPENR3.Bits.FP26EN
#define FPENR3_FP27EN                   _FPENR3.Bits.FP27EN
#define FPENR3_FP28EN                   _FPENR3.Bits.FP28EN
#define FPENR3_FP29EN                   _FPENR3.Bits.FP29EN
#define FPENR3_FP30EN                   _FPENR3.Bits.FP30EN
#define FPENR3_FP31EN                   _FPENR3.Bits.FP31EN

#define FPENR3_FP24EN_MASK              1U
#define FPENR3_FP25EN_MASK              2U
#define FPENR3_FP26EN_MASK              4U
#define FPENR3_FP27EN_MASK              8U
#define FPENR3_FP28EN_MASK              16U
#define FPENR3_FP29EN_MASK              32U
#define FPENR3_FP30EN_MASK              64U
#define FPENR3_FP31EN_MASK              128U


/*** FPENR4 - LCD Frontplane Enable Register 4; 0x00000206 ***/
typedef union {
  byte Byte;
  struct {
    byte FP32EN      :1;                                       /* Frontplane Output Enable Bit 32 */
    byte FP33EN      :1;                                       /* Frontplane Output Enable Bit 33 */
    byte FP34EN      :1;                                       /* Frontplane Output Enable Bit 34 */
    byte FP35EN      :1;                                       /* Frontplane Output Enable Bit 35 */
    byte FP36EN      :1;                                       /* Frontplane Output Enable Bit 36 */
    byte FP37EN      :1;                                       /* Frontplane Output Enable Bit 37 */
    byte FP38EN      :1;                                       /* Frontplane Output Enable Bit 38 */
    byte FP39EN      :1;                                       /* Frontplane Output Enable Bit 39 */
  } Bits;
} FPENR4STR;
extern volatile FPENR4STR _FPENR4 @(REG_BASE + 0x00000206UL);
#define FPENR4                          _FPENR4.Byte
#define FPENR4_FP32EN                   _FPENR4.Bits.FP32EN
#define FPENR4_FP33EN                   _FPENR4.Bits.FP33EN
#define FPENR4_FP34EN                   _FPENR4.Bits.FP34EN
#define FPENR4_FP35EN                   _FPENR4.Bits.FP35EN
#define FPENR4_FP36EN                   _FPENR4.Bits.FP36EN
#define FPENR4_FP37EN                   _FPENR4.Bits.FP37EN
#define FPENR4_FP38EN                   _FPENR4.Bits.FP38EN
#define FPENR4_FP39EN                   _FPENR4.Bits.FP39EN

#define FPENR4_FP32EN_MASK              1U
#define FPENR4_FP33EN_MASK              2U
#define FPENR4_FP34EN_MASK              4U
#define FPENR4_FP35EN_MASK              8U
#define FPENR4_FP36EN_MASK              16U
#define FPENR4_FP37EN_MASK              32U
#define FPENR4_FP38EN_MASK              64U
#define FPENR4_FP39EN_MASK              128U


/*** LCDRAM0 - LCD RAM 0; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte FP0BP0      :1;                                       /* LCD Segment FP0, BP0 ON */
    byte FP0BP1      :1;                                       /* LCD Segment FP0, BP1 ON */
    byte FP0BP2      :1;                                       /* LCD Segment FP0, BP2 ON */
    byte FP0BP3      :1;                                       /* LCD Segment FP0, BP3 ON */
    byte FP1BP0      :1;                                       /* LCD Segment FP1, BP0 ON */
    byte FP1BP1      :1;                                       /* LCD Segment FP1, BP1 ON */
    byte FP1BP2      :1;                                       /* LCD Segment FP1, BP2 ON */
    byte FP1BP3      :1;                                       /* LCD Segment FP1, BP3 ON */
  } Bits;
  struct {
    byte grpFP0BP :4;
    byte grpFP1BP :4;
  } MergedBits;
} LCDRAM0STR;
extern volatile LCDRAM0STR _LCDRAM0 @(REG_BASE + 0x00000208UL);
#define LCDRAM0                         _LCDRAM0.Byte
#define LCDRAM0_FP0BP0                  _LCDRAM0.Bits.FP0BP0
#define LCDRAM0_FP0BP1                  _LCDRAM0.Bits.FP0BP1
#define LCDRAM0_FP0BP2                  _LCDRAM0.Bits.FP0BP2
#define LCDRAM0_FP0BP3                  _LCDRAM0.Bits.FP0BP3
#define LCDRAM0_FP1BP0                  _LCDRAM0.Bits.FP1BP0
#define LCDRAM0_FP1BP1                  _LCDRAM0.Bits.FP1BP1
#define LCDRAM0_FP1BP2                  _LCDRAM0.Bits.FP1BP2
#define LCDRAM0_FP1BP3                  _LCDRAM0.Bits.FP1BP3
/* LCDRAM_ARR: Access 20 LCDRAMx registers in an array */
#define LCDRAM_ARR                      ((volatile byte *) &LCDRAM0)
#define LCDRAM0_FP0BP                   _LCDRAM0.MergedBits.grpFP0BP
#define LCDRAM0_FP1BP                   _LCDRAM0.MergedBits.grpFP1BP

#define LCDRAM0_FP0BP0_MASK             1U
#define LCDRAM0_FP0BP1_MASK             2U
#define LCDRAM0_FP0BP2_MASK             4U
#define LCDRAM0_FP0BP3_MASK             8U
#define LCDRAM0_FP1BP0_MASK             16U
#define LCDRAM0_FP1BP1_MASK             32U
#define LCDRAM0_FP1BP2_MASK             64U
#define LCDRAM0_FP1BP3_MASK             128U
#define LCDRAM0_FP0BP_MASK              15U
#define LCDRAM0_FP0BP_BITNUM            0U
#define LCDRAM0_FP1BP_MASK              240U
#define LCDRAM0_FP1BP_BITNUM            4U


/*** LCDRAM1 - LCD RAM 1; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte FP2BP0      :1;                                       /* LCD Segment FP2, BP0 ON */
    byte FP2BP1      :1;                                       /* LCD Segment FP2, BP1 ON */
    byte FP2BP2      :1;                                       /* LCD Segment FP2, BP2 ON */
    byte FP2BP3      :1;                                       /* LCD Segment FP2, BP3 ON */
    byte FP3BP0      :1;                                       /* LCD Segment FP3, BP0 ON */
    byte FP3BP1      :1;                                       /* LCD Segment FP3, BP1 ON */
    byte FP3BP2      :1;                                       /* LCD Segment FP3, BP2 ON */
    byte FP3BP3      :1;                                       /* LCD Segment FP3, BP3 ON */
  } Bits;
  struct {
    byte grpFP2BP :4;
    byte grpFP3BP :4;
  } MergedBits;
} LCDRAM1STR;
extern volatile LCDRAM1STR _LCDRAM1 @(REG_BASE + 0x00000209UL);
#define LCDRAM1                         _LCDRAM1.Byte
#define LCDRAM1_FP2BP0                  _LCDRAM1.Bits.FP2BP0
#define LCDRAM1_FP2BP1                  _LCDRAM1.Bits.FP2BP1
#define LCDRAM1_FP2BP2                  _LCDRAM1.Bits.FP2BP2
#define LCDRAM1_FP2BP3                  _LCDRAM1.Bits.FP2BP3
#define LCDRAM1_FP3BP0                  _LCDRAM1.Bits.FP3BP0
#define LCDRAM1_FP3BP1                  _LCDRAM1.Bits.FP3BP1
#define LCDRAM1_FP3BP2                  _LCDRAM1.Bits.FP3BP2
#define LCDRAM1_FP3BP3                  _LCDRAM1.Bits.FP3BP3
#define LCDRAM1_FP2BP                   _LCDRAM1.MergedBits.grpFP2BP
#define LCDRAM1_FP3BP                   _LCDRAM1.MergedBits.grpFP3BP

#define LCDRAM1_FP2BP0_MASK             1U
#define LCDRAM1_FP2BP1_MASK             2U
#define LCDRAM1_FP2BP2_MASK             4U
#define LCDRAM1_FP2BP3_MASK             8U
#define LCDRAM1_FP3BP0_MASK             16U
#define LCDRAM1_FP3BP1_MASK             32U
#define LCDRAM1_FP3BP2_MASK             64U
#define LCDRAM1_FP3BP3_MASK             128U
#define LCDRAM1_FP2BP_MASK              15U
#define LCDRAM1_FP2BP_BITNUM            0U
#define LCDRAM1_FP3BP_MASK              240U
#define LCDRAM1_FP3BP_BITNUM            4U


/*** LCDRAM2 - LCD RAM 2; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte FP4BP0      :1;                                       /* LCD Segment FP4, BP0 ON */
    byte FP4BP1      :1;                                       /* LCD Segment FP4, BP1 ON */
    byte FP4BP2      :1;                                       /* LCD Segment FP4, BP2 ON */
    byte FP4BP3      :1;                                       /* LCD Segment FP4, BP3 ON */
    byte FP5BP0      :1;                                       /* LCD Segment FP5, BP0 ON */
    byte FP5BP1      :1;                                       /* LCD Segment FP5, BP1 ON */
    byte FP5BP2      :1;                                       /* LCD Segment FP5, BP2 ON */
    byte FP5BP3      :1;                                       /* LCD Segment FP5, BP3 ON */
  } Bits;
  struct {
    byte grpFP4BP :4;
    byte grpFP5BP :4;
  } MergedBits;
} LCDRAM2STR;
extern volatile LCDRAM2STR _LCDRAM2 @(REG_BASE + 0x0000020AUL);
#define LCDRAM2                         _LCDRAM2.Byte
#define LCDRAM2_FP4BP0                  _LCDRAM2.Bits.FP4BP0
#define LCDRAM2_FP4BP1                  _LCDRAM2.Bits.FP4BP1
#define LCDRAM2_FP4BP2                  _LCDRAM2.Bits.FP4BP2
#define LCDRAM2_FP4BP3                  _LCDRAM2.Bits.FP4BP3
#define LCDRAM2_FP5BP0                  _LCDRAM2.Bits.FP5BP0
#define LCDRAM2_FP5BP1                  _LCDRAM2.Bits.FP5BP1
#define LCDRAM2_FP5BP2                  _LCDRAM2.Bits.FP5BP2
#define LCDRAM2_FP5BP3                  _LCDRAM2.Bits.FP5BP3
#define LCDRAM2_FP4BP                   _LCDRAM2.MergedBits.grpFP4BP
#define LCDRAM2_FP5BP                   _LCDRAM2.MergedBits.grpFP5BP

#define LCDRAM2_FP4BP0_MASK             1U
#define LCDRAM2_FP4BP1_MASK             2U
#define LCDRAM2_FP4BP2_MASK             4U
#define LCDRAM2_FP4BP3_MASK             8U
#define LCDRAM2_FP5BP0_MASK             16U
#define LCDRAM2_FP5BP1_MASK             32U
#define LCDRAM2_FP5BP2_MASK             64U
#define LCDRAM2_FP5BP3_MASK             128U
#define LCDRAM2_FP4BP_MASK              15U
#define LCDRAM2_FP4BP_BITNUM            0U
#define LCDRAM2_FP5BP_MASK              240U
#define LCDRAM2_FP5BP_BITNUM            4U


/*** LCDRAM3 - LCD RAM 3; 0x0000020B ***/
typedef union {
  byte Byte;
  struct {
    byte FP6BP0      :1;                                       /* LCD Segment FP6, BP0 ON */
    byte FP6BP1      :1;                                       /* LCD Segment FP6, BP1 ON */
    byte FP6BP2      :1;                                       /* LCD Segment FP6, BP2 ON */
    byte FP6BP3      :1;                                       /* LCD Segment FP6, BP3 ON */
    byte FP7BP0      :1;                                       /* LCD Segment FP7, BP0 ON */
    byte FP7BP1      :1;                                       /* LCD Segment FP7, BP1 ON */
    byte FP7BP2      :1;                                       /* LCD Segment FP7, BP2 ON */
    byte FP7BP3      :1;                                       /* LCD Segment FP7, BP3 ON */
  } Bits;
  struct {
    byte grpFP6BP :4;
    byte grpFP7BP :4;
  } MergedBits;
} LCDRAM3STR;
extern volatile LCDRAM3STR _LCDRAM3 @(REG_BASE + 0x0000020BUL);
#define LCDRAM3                         _LCDRAM3.Byte
#define LCDRAM3_FP6BP0                  _LCDRAM3.Bits.FP6BP0
#define LCDRAM3_FP6BP1                  _LCDRAM3.Bits.FP6BP1
#define LCDRAM3_FP6BP2                  _LCDRAM3.Bits.FP6BP2
#define LCDRAM3_FP6BP3                  _LCDRAM3.Bits.FP6BP3
#define LCDRAM3_FP7BP0                  _LCDRAM3.Bits.FP7BP0
#define LCDRAM3_FP7BP1                  _LCDRAM3.Bits.FP7BP1
#define LCDRAM3_FP7BP2                  _LCDRAM3.Bits.FP7BP2
#define LCDRAM3_FP7BP3                  _LCDRAM3.Bits.FP7BP3
#define LCDRAM3_FP6BP                   _LCDRAM3.MergedBits.grpFP6BP
#define LCDRAM3_FP7BP                   _LCDRAM3.MergedBits.grpFP7BP

#define LCDRAM3_FP6BP0_MASK             1U
#define LCDRAM3_FP6BP1_MASK             2U
#define LCDRAM3_FP6BP2_MASK             4U
#define LCDRAM3_FP6BP3_MASK             8U
#define LCDRAM3_FP7BP0_MASK             16U
#define LCDRAM3_FP7BP1_MASK             32U
#define LCDRAM3_FP7BP2_MASK             64U
#define LCDRAM3_FP7BP3_MASK             128U
#define LCDRAM3_FP6BP_MASK              15U
#define LCDRAM3_FP6BP_BITNUM            0U
#define LCDRAM3_FP7BP_MASK              240U
#define LCDRAM3_FP7BP_BITNUM            4U


/*** LCDRAM4 - LCD RAM 4; 0x0000020C ***/
typedef union {
  byte Byte;
  struct {
    byte FP8BP0      :1;                                       /* LCD Segment FP8, BP0 ON */
    byte FP8BP1      :1;                                       /* LCD Segment FP8, BP1 ON */
    byte FP8BP2      :1;                                       /* LCD Segment FP8, BP2 ON */
    byte FP8BP3      :1;                                       /* LCD Segment FP8, BP3 ON */
    byte FP9BP0      :1;                                       /* LCD Segment FP9, BP0 ON */
    byte FP9BP1      :1;                                       /* LCD Segment FP9, BP1 ON */
    byte FP9BP2      :1;                                       /* LCD Segment FP9, BP2 ON */
    byte FP9BP3      :1;                                       /* LCD Segment FP9, BP3 ON */
  } Bits;
  struct {
    byte grpFP8BP :4;
    byte grpFP9BP :4;
  } MergedBits;
} LCDRAM4STR;
extern volatile LCDRAM4STR _LCDRAM4 @(REG_BASE + 0x0000020CUL);
#define LCDRAM4                         _LCDRAM4.Byte
#define LCDRAM4_FP8BP0                  _LCDRAM4.Bits.FP8BP0
#define LCDRAM4_FP8BP1                  _LCDRAM4.Bits.FP8BP1
#define LCDRAM4_FP8BP2                  _LCDRAM4.Bits.FP8BP2
#define LCDRAM4_FP8BP3                  _LCDRAM4.Bits.FP8BP3
#define LCDRAM4_FP9BP0                  _LCDRAM4.Bits.FP9BP0
#define LCDRAM4_FP9BP1                  _LCDRAM4.Bits.FP9BP1
#define LCDRAM4_FP9BP2                  _LCDRAM4.Bits.FP9BP2
#define LCDRAM4_FP9BP3                  _LCDRAM4.Bits.FP9BP3
#define LCDRAM4_FP8BP                   _LCDRAM4.MergedBits.grpFP8BP
#define LCDRAM4_FP9BP                   _LCDRAM4.MergedBits.grpFP9BP

#define LCDRAM4_FP8BP0_MASK             1U
#define LCDRAM4_FP8BP1_MASK             2U
#define LCDRAM4_FP8BP2_MASK             4U
#define LCDRAM4_FP8BP3_MASK             8U
#define LCDRAM4_FP9BP0_MASK             16U
#define LCDRAM4_FP9BP1_MASK             32U
#define LCDRAM4_FP9BP2_MASK             64U
#define LCDRAM4_FP9BP3_MASK             128U
#define LCDRAM4_FP8BP_MASK              15U
#define LCDRAM4_FP8BP_BITNUM            0U
#define LCDRAM4_FP9BP_MASK              240U
#define LCDRAM4_FP9BP_BITNUM            4U


/*** LCDRAM5 - LCD RAM 5; 0x0000020D ***/
typedef union {
  byte Byte;
  struct {
    byte FP10BP0     :1;                                       /* LCD Segment FP10, BP0 ON */
    byte FP10BP1     :1;                                       /* LCD Segment FP10, BP1 ON */
    byte FP10BP2     :1;                                       /* LCD Segment FP10, BP2 ON */
    byte FP10BP3     :1;                                       /* LCD Segment FP10, BP3 ON */
    byte FP11BP0     :1;                                       /* LCD Segment FP11, BP0 ON */
    byte FP11BP1     :1;                                       /* LCD Segment FP11, BP1 ON */
    byte FP11BP2     :1;                                       /* LCD Segment FP11, BP2 ON */
    byte FP11BP3     :1;                                       /* LCD Segment FP11, BP3 ON */
  } Bits;
  struct {
    byte grpFP10BP :4;
    byte grpFP11BP :4;
  } MergedBits;
} LCDRAM5STR;
extern volatile LCDRAM5STR _LCDRAM5 @(REG_BASE + 0x0000020DUL);
#define LCDRAM5                         _LCDRAM5.Byte
#define LCDRAM5_FP10BP0                 _LCDRAM5.Bits.FP10BP0
#define LCDRAM5_FP10BP1                 _LCDRAM5.Bits.FP10BP1
#define LCDRAM5_FP10BP2                 _LCDRAM5.Bits.FP10BP2
#define LCDRAM5_FP10BP3                 _LCDRAM5.Bits.FP10BP3
#define LCDRAM5_FP11BP0                 _LCDRAM5.Bits.FP11BP0
#define LCDRAM5_FP11BP1                 _LCDRAM5.Bits.FP11BP1
#define LCDRAM5_FP11BP2                 _LCDRAM5.Bits.FP11BP2
#define LCDRAM5_FP11BP3                 _LCDRAM5.Bits.FP11BP3
#define LCDRAM5_FP10BP                  _LCDRAM5.MergedBits.grpFP10BP
#define LCDRAM5_FP11BP                  _LCDRAM5.MergedBits.grpFP11BP

#define LCDRAM5_FP10BP0_MASK            1U
#define LCDRAM5_FP10BP1_MASK            2U
#define LCDRAM5_FP10BP2_MASK            4U
#define LCDRAM5_FP10BP3_MASK            8U
#define LCDRAM5_FP11BP0_MASK            16U
#define LCDRAM5_FP11BP1_MASK            32U
#define LCDRAM5_FP11BP2_MASK            64U
#define LCDRAM5_FP11BP3_MASK            128U
#define LCDRAM5_FP10BP_MASK             15U
#define LCDRAM5_FP10BP_BITNUM           0U
#define LCDRAM5_FP11BP_MASK             240U
#define LCDRAM5_FP11BP_BITNUM           4U


/*** LCDRAM6 - LCD RAM 6; 0x0000020E ***/
typedef union {
  byte Byte;
  struct {
    byte FP12BP0     :1;                                       /* LCD Segment FP12, BP0 ON */
    byte FP12BP1     :1;                                       /* LCD Segment FP12, BP1 ON */
    byte FP12BP2     :1;                                       /* LCD Segment FP12, BP2 ON */
    byte FP12BP3     :1;                                       /* LCD Segment FP12, BP3 ON */
    byte FP13BP0     :1;                                       /* LCD Segment FP13, BP0 ON */
    byte FP13BP1     :1;                                       /* LCD Segment FP13, BP1 ON */
    byte FP13BP2     :1;                                       /* LCD Segment FP13, BP2 ON */
    byte FP13BP3     :1;                                       /* LCD Segment FP13, BP3 ON */
  } Bits;
  struct {
    byte grpFP12BP :4;
    byte grpFP13BP :4;
  } MergedBits;
} LCDRAM6STR;
extern volatile LCDRAM6STR _LCDRAM6 @(REG_BASE + 0x0000020EUL);
#define LCDRAM6                         _LCDRAM6.Byte
#define LCDRAM6_FP12BP0                 _LCDRAM6.Bits.FP12BP0
#define LCDRAM6_FP12BP1                 _LCDRAM6.Bits.FP12BP1
#define LCDRAM6_FP12BP2                 _LCDRAM6.Bits.FP12BP2
#define LCDRAM6_FP12BP3                 _LCDRAM6.Bits.FP12BP3
#define LCDRAM6_FP13BP0                 _LCDRAM6.Bits.FP13BP0
#define LCDRAM6_FP13BP1                 _LCDRAM6.Bits.FP13BP1
#define LCDRAM6_FP13BP2                 _LCDRAM6.Bits.FP13BP2
#define LCDRAM6_FP13BP3                 _LCDRAM6.Bits.FP13BP3
#define LCDRAM6_FP12BP                  _LCDRAM6.MergedBits.grpFP12BP
#define LCDRAM6_FP13BP                  _LCDRAM6.MergedBits.grpFP13BP

#define LCDRAM6_FP12BP0_MASK            1U
#define LCDRAM6_FP12BP1_MASK            2U
#define LCDRAM6_FP12BP2_MASK            4U
#define LCDRAM6_FP12BP3_MASK            8U
#define LCDRAM6_FP13BP0_MASK            16U
#define LCDRAM6_FP13BP1_MASK            32U
#define LCDRAM6_FP13BP2_MASK            64U
#define LCDRAM6_FP13BP3_MASK            128U
#define LCDRAM6_FP12BP_MASK             15U
#define LCDRAM6_FP12BP_BITNUM           0U
#define LCDRAM6_FP13BP_MASK             240U
#define LCDRAM6_FP13BP_BITNUM           4U


/*** LCDRAM7 - LCD RAM 7; 0x0000020F ***/
typedef union {
  byte Byte;
  struct {
    byte FP14BP0     :1;                                       /* LCD Segment FP14, BP0 ON */
    byte FP14BP1     :1;                                       /* LCD Segment FP14, BP1 ON */
    byte FP14BP2     :1;                                       /* LCD Segment FP14, BP2 ON */
    byte FP14BP3     :1;                                       /* LCD Segment FP14, BP3 ON */
    byte FP15BP0     :1;                                       /* LCD Segment FP15, BP0 ON */
    byte FP15BP1     :1;                                       /* LCD Segment FP15, BP1 ON */
    byte FP15BP2     :1;                                       /* LCD Segment FP15, BP2 ON */
    byte FP15BP3     :1;                                       /* LCD Segment FP15, BP3 ON */
  } Bits;
  struct {
    byte grpFP14BP :4;
    byte grpFP15BP :4;
  } MergedBits;
} LCDRAM7STR;
extern volatile LCDRAM7STR _LCDRAM7 @(REG_BASE + 0x0000020FUL);
#define LCDRAM7                         _LCDRAM7.Byte
#define LCDRAM7_FP14BP0                 _LCDRAM7.Bits.FP14BP0
#define LCDRAM7_FP14BP1                 _LCDRAM7.Bits.FP14BP1
#define LCDRAM7_FP14BP2                 _LCDRAM7.Bits.FP14BP2
#define LCDRAM7_FP14BP3                 _LCDRAM7.Bits.FP14BP3
#define LCDRAM7_FP15BP0                 _LCDRAM7.Bits.FP15BP0
#define LCDRAM7_FP15BP1                 _LCDRAM7.Bits.FP15BP1
#define LCDRAM7_FP15BP2                 _LCDRAM7.Bits.FP15BP2
#define LCDRAM7_FP15BP3                 _LCDRAM7.Bits.FP15BP3
#define LCDRAM7_FP14BP                  _LCDRAM7.MergedBits.grpFP14BP
#define LCDRAM7_FP15BP                  _LCDRAM7.MergedBits.grpFP15BP

#define LCDRAM7_FP14BP0_MASK            1U
#define LCDRAM7_FP14BP1_MASK            2U
#define LCDRAM7_FP14BP2_MASK            4U
#define LCDRAM7_FP14BP3_MASK            8U
#define LCDRAM7_FP15BP0_MASK            16U
#define LCDRAM7_FP15BP1_MASK            32U
#define LCDRAM7_FP15BP2_MASK            64U
#define LCDRAM7_FP15BP3_MASK            128U
#define LCDRAM7_FP14BP_MASK             15U
#define LCDRAM7_FP14BP_BITNUM           0U
#define LCDRAM7_FP15BP_MASK             240U
#define LCDRAM7_FP15BP_BITNUM           4U


/*** LCDRAM8 - LCD RAM 8; 0x00000210 ***/
typedef union {
  byte Byte;
  struct {
    byte FP16BP0     :1;                                       /* LCD Segment FP16, BP0 ON */
    byte FP16BP1     :1;                                       /* LCD Segment FP16, BP1 ON */
    byte FP16BP2     :1;                                       /* LCD Segment FP16, BP2 ON */
    byte FP16BP3     :1;                                       /* LCD Segment FP16, BP3 ON */
    byte FP17BP0     :1;                                       /* LCD Segment FP17, BP0 ON */
    byte FP17BP1     :1;                                       /* LCD Segment FP17, BP1 ON */
    byte FP17BP2     :1;                                       /* LCD Segment FP17, BP2 ON */
    byte FP17BP3     :1;                                       /* LCD Segment FP17, BP3 ON */
  } Bits;
  struct {
    byte grpFP16BP :4;
    byte grpFP17BP :4;
  } MergedBits;
} LCDRAM8STR;
extern volatile LCDRAM8STR _LCDRAM8 @(REG_BASE + 0x00000210UL);
#define LCDRAM8                         _LCDRAM8.Byte
#define LCDRAM8_FP16BP0                 _LCDRAM8.Bits.FP16BP0
#define LCDRAM8_FP16BP1                 _LCDRAM8.Bits.FP16BP1
#define LCDRAM8_FP16BP2                 _LCDRAM8.Bits.FP16BP2
#define LCDRAM8_FP16BP3                 _LCDRAM8.Bits.FP16BP3
#define LCDRAM8_FP17BP0                 _LCDRAM8.Bits.FP17BP0
#define LCDRAM8_FP17BP1                 _LCDRAM8.Bits.FP17BP1
#define LCDRAM8_FP17BP2                 _LCDRAM8.Bits.FP17BP2
#define LCDRAM8_FP17BP3                 _LCDRAM8.Bits.FP17BP3
#define LCDRAM8_FP16BP                  _LCDRAM8.MergedBits.grpFP16BP
#define LCDRAM8_FP17BP                  _LCDRAM8.MergedBits.grpFP17BP

#define LCDRAM8_FP16BP0_MASK            1U
#define LCDRAM8_FP16BP1_MASK            2U
#define LCDRAM8_FP16BP2_MASK            4U
#define LCDRAM8_FP16BP3_MASK            8U
#define LCDRAM8_FP17BP0_MASK            16U
#define LCDRAM8_FP17BP1_MASK            32U
#define LCDRAM8_FP17BP2_MASK            64U
#define LCDRAM8_FP17BP3_MASK            128U
#define LCDRAM8_FP16BP_MASK             15U
#define LCDRAM8_FP16BP_BITNUM           0U
#define LCDRAM8_FP17BP_MASK             240U
#define LCDRAM8_FP17BP_BITNUM           4U


/*** LCDRAM9 - LCD RAM 9; 0x00000211 ***/
typedef union {
  byte Byte;
  struct {
    byte FP18BP0     :1;                                       /* LCD Segment FP18, BP0 ON */
    byte FP18BP1     :1;                                       /* LCD Segment FP18, BP1 ON */
    byte FP18BP2     :1;                                       /* LCD Segment FP18, BP2 ON */
    byte FP18BP3     :1;                                       /* LCD Segment FP18, BP3 ON */
    byte FP19BP0     :1;                                       /* LCD Segment FP19, BP0 ON */
    byte FP19BP1     :1;                                       /* LCD Segment FP19, BP1 ON */
    byte FP19BP2     :1;                                       /* LCD Segment FP19, BP2 ON */
    byte FP19BP3     :1;                                       /* LCD Segment FP19, BP3 ON */
  } Bits;
  struct {
    byte grpFP18BP :4;
    byte grpFP19BP :4;
  } MergedBits;
} LCDRAM9STR;
extern volatile LCDRAM9STR _LCDRAM9 @(REG_BASE + 0x00000211UL);
#define LCDRAM9                         _LCDRAM9.Byte
#define LCDRAM9_FP18BP0                 _LCDRAM9.Bits.FP18BP0
#define LCDRAM9_FP18BP1                 _LCDRAM9.Bits.FP18BP1
#define LCDRAM9_FP18BP2                 _LCDRAM9.Bits.FP18BP2
#define LCDRAM9_FP18BP3                 _LCDRAM9.Bits.FP18BP3
#define LCDRAM9_FP19BP0                 _LCDRAM9.Bits.FP19BP0
#define LCDRAM9_FP19BP1                 _LCDRAM9.Bits.FP19BP1
#define LCDRAM9_FP19BP2                 _LCDRAM9.Bits.FP19BP2
#define LCDRAM9_FP19BP3                 _LCDRAM9.Bits.FP19BP3
#define LCDRAM9_FP18BP                  _LCDRAM9.MergedBits.grpFP18BP
#define LCDRAM9_FP19BP                  _LCDRAM9.MergedBits.grpFP19BP

#define LCDRAM9_FP18BP0_MASK            1U
#define LCDRAM9_FP18BP1_MASK            2U
#define LCDRAM9_FP18BP2_MASK            4U
#define LCDRAM9_FP18BP3_MASK            8U
#define LCDRAM9_FP19BP0_MASK            16U
#define LCDRAM9_FP19BP1_MASK            32U
#define LCDRAM9_FP19BP2_MASK            64U
#define LCDRAM9_FP19BP3_MASK            128U
#define LCDRAM9_FP18BP_MASK             15U
#define LCDRAM9_FP18BP_BITNUM           0U
#define LCDRAM9_FP19BP_MASK             240U
#define LCDRAM9_FP19BP_BITNUM           4U


/*** LCDRAM10 - LCD RAM 10; 0x00000212 ***/
typedef union {
  byte Byte;
  struct {
    byte FP20BP0     :1;                                       /* LCD Segment FP20, BP0 ON */
    byte FP20BP1     :1;                                       /* LCD Segment FP20, BP1 ON */
    byte FP20BP2     :1;                                       /* LCD Segment FP20, BP2 ON */
    byte FP20BP3     :1;                                       /* LCD Segment FP20, BP3 ON */
    byte FP21BP0     :1;                                       /* LCD Segment FP21, BP0 ON */
    byte FP21BP1     :1;                                       /* LCD Segment FP21, BP1 ON */
    byte FP21BP2     :1;                                       /* LCD Segment FP21, BP2 ON */
    byte FP21BP3     :1;                                       /* LCD Segment FP21, BP3 ON */
  } Bits;
  struct {
    byte grpFP20BP :4;
    byte grpFP21BP :4;
  } MergedBits;
} LCDRAM10STR;
extern volatile LCDRAM10STR _LCDRAM10 @(REG_BASE + 0x00000212UL);
#define LCDRAM10                        _LCDRAM10.Byte
#define LCDRAM10_FP20BP0                _LCDRAM10.Bits.FP20BP0
#define LCDRAM10_FP20BP1                _LCDRAM10.Bits.FP20BP1
#define LCDRAM10_FP20BP2                _LCDRAM10.Bits.FP20BP2
#define LCDRAM10_FP20BP3                _LCDRAM10.Bits.FP20BP3
#define LCDRAM10_FP21BP0                _LCDRAM10.Bits.FP21BP0
#define LCDRAM10_FP21BP1                _LCDRAM10.Bits.FP21BP1
#define LCDRAM10_FP21BP2                _LCDRAM10.Bits.FP21BP2
#define LCDRAM10_FP21BP3                _LCDRAM10.Bits.FP21BP3
#define LCDRAM10_FP20BP                 _LCDRAM10.MergedBits.grpFP20BP
#define LCDRAM10_FP21BP                 _LCDRAM10.MergedBits.grpFP21BP

#define LCDRAM10_FP20BP0_MASK           1U
#define LCDRAM10_FP20BP1_MASK           2U
#define LCDRAM10_FP20BP2_MASK           4U
#define LCDRAM10_FP20BP3_MASK           8U
#define LCDRAM10_FP21BP0_MASK           16U
#define LCDRAM10_FP21BP1_MASK           32U
#define LCDRAM10_FP21BP2_MASK           64U
#define LCDRAM10_FP21BP3_MASK           128U
#define LCDRAM10_FP20BP_MASK            15U
#define LCDRAM10_FP20BP_BITNUM          0U
#define LCDRAM10_FP21BP_MASK            240U
#define LCDRAM10_FP21BP_BITNUM          4U


/*** LCDRAM11 - LCD RAM 11; 0x00000213 ***/
typedef union {
  byte Byte;
  struct {
    byte FP22BP0     :1;                                       /* LCD Segment FP22, BP0 ON */
    byte FP22BP1     :1;                                       /* LCD Segment FP22, BP1 ON */
    byte FP22BP2     :1;                                       /* LCD Segment FP22, BP2 ON */
    byte FP22BP3     :1;                                       /* LCD Segment FP22, BP3 ON */
    byte FP23BP0     :1;                                       /* LCD Segment FP23, BP0 ON */
    byte FP23BP1     :1;                                       /* LCD Segment FP23, BP1 ON */
    byte FP23BP2     :1;                                       /* LCD Segment FP23, BP2 ON */
    byte FP23BP3     :1;                                       /* LCD Segment FP23, BP3 ON */
  } Bits;
  struct {
    byte grpFP22BP :4;
    byte grpFP23BP :4;
  } MergedBits;
} LCDRAM11STR;
extern volatile LCDRAM11STR _LCDRAM11 @(REG_BASE + 0x00000213UL);
#define LCDRAM11                        _LCDRAM11.Byte
#define LCDRAM11_FP22BP0                _LCDRAM11.Bits.FP22BP0
#define LCDRAM11_FP22BP1                _LCDRAM11.Bits.FP22BP1
#define LCDRAM11_FP22BP2                _LCDRAM11.Bits.FP22BP2
#define LCDRAM11_FP22BP3                _LCDRAM11.Bits.FP22BP3
#define LCDRAM11_FP23BP0                _LCDRAM11.Bits.FP23BP0
#define LCDRAM11_FP23BP1                _LCDRAM11.Bits.FP23BP1
#define LCDRAM11_FP23BP2                _LCDRAM11.Bits.FP23BP2
#define LCDRAM11_FP23BP3                _LCDRAM11.Bits.FP23BP3
#define LCDRAM11_FP22BP                 _LCDRAM11.MergedBits.grpFP22BP
#define LCDRAM11_FP23BP                 _LCDRAM11.MergedBits.grpFP23BP

#define LCDRAM11_FP22BP0_MASK           1U
#define LCDRAM11_FP22BP1_MASK           2U
#define LCDRAM11_FP22BP2_MASK           4U
#define LCDRAM11_FP22BP3_MASK           8U
#define LCDRAM11_FP23BP0_MASK           16U
#define LCDRAM11_FP23BP1_MASK           32U
#define LCDRAM11_FP23BP2_MASK           64U
#define LCDRAM11_FP23BP3_MASK           128U
#define LCDRAM11_FP22BP_MASK            15U
#define LCDRAM11_FP22BP_BITNUM          0U
#define LCDRAM11_FP23BP_MASK            240U
#define LCDRAM11_FP23BP_BITNUM          4U


/*** LCDRAM12 - LCD RAM 12; 0x00000214 ***/
typedef union {
  byte Byte;
  struct {
    byte FP24BP0     :1;                                       /* LCD Segment FP24, BP0 ON */
    byte FP24BP1     :1;                                       /* LCD Segment FP24, BP1 ON */
    byte FP24BP2     :1;                                       /* LCD Segment FP24, BP2 ON */
    byte FP24BP3     :1;                                       /* LCD Segment FP24, BP3 ON */
    byte FP25BP0     :1;                                       /* LCD Segment FP25, BP0 ON */
    byte FP25BP1     :1;                                       /* LCD Segment FP25, BP1 ON */
    byte FP25BP2     :1;                                       /* LCD Segment FP25, BP2 ON */
    byte FP25BP3     :1;                                       /* LCD Segment FP25, BP3 ON */
  } Bits;
  struct {
    byte grpFP24BP :4;
    byte grpFP25BP :4;
  } MergedBits;
} LCDRAM12STR;
extern volatile LCDRAM12STR _LCDRAM12 @(REG_BASE + 0x00000214UL);
#define LCDRAM12                        _LCDRAM12.Byte
#define LCDRAM12_FP24BP0                _LCDRAM12.Bits.FP24BP0
#define LCDRAM12_FP24BP1                _LCDRAM12.Bits.FP24BP1
#define LCDRAM12_FP24BP2                _LCDRAM12.Bits.FP24BP2
#define LCDRAM12_FP24BP3                _LCDRAM12.Bits.FP24BP3
#define LCDRAM12_FP25BP0                _LCDRAM12.Bits.FP25BP0
#define LCDRAM12_FP25BP1                _LCDRAM12.Bits.FP25BP1
#define LCDRAM12_FP25BP2                _LCDRAM12.Bits.FP25BP2
#define LCDRAM12_FP25BP3                _LCDRAM12.Bits.FP25BP3
#define LCDRAM12_FP24BP                 _LCDRAM12.MergedBits.grpFP24BP
#define LCDRAM12_FP25BP                 _LCDRAM12.MergedBits.grpFP25BP

#define LCDRAM12_FP24BP0_MASK           1U
#define LCDRAM12_FP24BP1_MASK           2U
#define LCDRAM12_FP24BP2_MASK           4U
#define LCDRAM12_FP24BP3_MASK           8U
#define LCDRAM12_FP25BP0_MASK           16U
#define LCDRAM12_FP25BP1_MASK           32U
#define LCDRAM12_FP25BP2_MASK           64U
#define LCDRAM12_FP25BP3_MASK           128U
#define LCDRAM12_FP24BP_MASK            15U
#define LCDRAM12_FP24BP_BITNUM          0U
#define LCDRAM12_FP25BP_MASK            240U
#define LCDRAM12_FP25BP_BITNUM          4U


/*** LCDRAM13 - LCD RAM 13; 0x00000215 ***/
typedef union {
  byte Byte;
  struct {
    byte FP26BP0     :1;                                       /* LCD Segment FP26, BP0 ON */
    byte FP26BP1     :1;                                       /* LCD Segment FP26, BP1 ON */
    byte FP26BP2     :1;                                       /* LCD Segment FP26, BP2 ON */
    byte FP26BP3     :1;                                       /* LCD Segment FP26, BP3 ON */
    byte FP27BP0     :1;                                       /* LCD Segment FP27, BP0 ON */
    byte FP27BP1     :1;                                       /* LCD Segment FP27, BP1 ON */
    byte FP27BP2     :1;                                       /* LCD Segment FP27, BP2 ON */
    byte FP27BP3     :1;                                       /* LCD Segment FP27, BP3 ON */
  } Bits;
  struct {
    byte grpFP26BP :4;
    byte grpFP27BP :4;
  } MergedBits;
} LCDRAM13STR;
extern volatile LCDRAM13STR _LCDRAM13 @(REG_BASE + 0x00000215UL);
#define LCDRAM13                        _LCDRAM13.Byte
#define LCDRAM13_FP26BP0                _LCDRAM13.Bits.FP26BP0
#define LCDRAM13_FP26BP1                _LCDRAM13.Bits.FP26BP1
#define LCDRAM13_FP26BP2                _LCDRAM13.Bits.FP26BP2
#define LCDRAM13_FP26BP3                _LCDRAM13.Bits.FP26BP3
#define LCDRAM13_FP27BP0                _LCDRAM13.Bits.FP27BP0
#define LCDRAM13_FP27BP1                _LCDRAM13.Bits.FP27BP1
#define LCDRAM13_FP27BP2                _LCDRAM13.Bits.FP27BP2
#define LCDRAM13_FP27BP3                _LCDRAM13.Bits.FP27BP3
#define LCDRAM13_FP26BP                 _LCDRAM13.MergedBits.grpFP26BP
#define LCDRAM13_FP27BP                 _LCDRAM13.MergedBits.grpFP27BP

#define LCDRAM13_FP26BP0_MASK           1U
#define LCDRAM13_FP26BP1_MASK           2U
#define LCDRAM13_FP26BP2_MASK           4U
#define LCDRAM13_FP26BP3_MASK           8U
#define LCDRAM13_FP27BP0_MASK           16U
#define LCDRAM13_FP27BP1_MASK           32U
#define LCDRAM13_FP27BP2_MASK           64U
#define LCDRAM13_FP27BP3_MASK           128U
#define LCDRAM13_FP26BP_MASK            15U
#define LCDRAM13_FP26BP_BITNUM          0U
#define LCDRAM13_FP27BP_MASK            240U
#define LCDRAM13_FP27BP_BITNUM          4U


/*** LCDRAM14 - LCD RAM 14; 0x00000216 ***/
typedef union {
  byte Byte;
  struct {
    byte FP28BP0     :1;                                       /* LCD Segment FP28, BP0 ON */
    byte FP28BP1     :1;                                       /* LCD Segment FP28, BP1 ON */
    byte FP28BP2     :1;                                       /* LCD Segment FP28, BP2 ON */
    byte FP28BP3     :1;                                       /* LCD Segment FP28, BP3 ON */
    byte FP29BP0     :1;                                       /* LCD Segment FP29, BP0 ON */
    byte FP29BP1     :1;                                       /* LCD Segment FP29, BP1 ON */
    byte FP29BP2     :1;                                       /* LCD Segment FP29, BP2 ON */
    byte FP29BP3     :1;                                       /* LCD Segment FP29, BP3 ON */
  } Bits;
  struct {
    byte grpFP28BP :4;
    byte grpFP29BP :4;
  } MergedBits;
} LCDRAM14STR;
extern volatile LCDRAM14STR _LCDRAM14 @(REG_BASE + 0x00000216UL);
#define LCDRAM14                        _LCDRAM14.Byte
#define LCDRAM14_FP28BP0                _LCDRAM14.Bits.FP28BP0
#define LCDRAM14_FP28BP1                _LCDRAM14.Bits.FP28BP1
#define LCDRAM14_FP28BP2                _LCDRAM14.Bits.FP28BP2
#define LCDRAM14_FP28BP3                _LCDRAM14.Bits.FP28BP3
#define LCDRAM14_FP29BP0                _LCDRAM14.Bits.FP29BP0
#define LCDRAM14_FP29BP1                _LCDRAM14.Bits.FP29BP1
#define LCDRAM14_FP29BP2                _LCDRAM14.Bits.FP29BP2
#define LCDRAM14_FP29BP3                _LCDRAM14.Bits.FP29BP3
#define LCDRAM14_FP28BP                 _LCDRAM14.MergedBits.grpFP28BP
#define LCDRAM14_FP29BP                 _LCDRAM14.MergedBits.grpFP29BP

#define LCDRAM14_FP28BP0_MASK           1U
#define LCDRAM14_FP28BP1_MASK           2U
#define LCDRAM14_FP28BP2_MASK           4U
#define LCDRAM14_FP28BP3_MASK           8U
#define LCDRAM14_FP29BP0_MASK           16U
#define LCDRAM14_FP29BP1_MASK           32U
#define LCDRAM14_FP29BP2_MASK           64U
#define LCDRAM14_FP29BP3_MASK           128U
#define LCDRAM14_FP28BP_MASK            15U
#define LCDRAM14_FP28BP_BITNUM          0U
#define LCDRAM14_FP29BP_MASK            240U
#define LCDRAM14_FP29BP_BITNUM          4U


/*** LCDRAM15 - LCD RAM 15; 0x00000217 ***/
typedef union {
  byte Byte;
  struct {
    byte FP30BP0     :1;                                       /* LCD Segment FP30, BP0 ON */
    byte FP30BP1     :1;                                       /* LCD Segment FP30, BP1 ON */
    byte FP30BP2     :1;                                       /* LCD Segment FP30, BP2 ON */
    byte FP30BP3     :1;                                       /* LCD Segment FP30, BP3 ON */
    byte FP31BP0     :1;                                       /* LCD Segment FP31, BP0 ON */
    byte FP31BP1     :1;                                       /* LCD Segment FP31, BP1 ON */
    byte FP31BP2     :1;                                       /* LCD Segment FP31, BP2 ON */
    byte FP31BP3     :1;                                       /* LCD Segment FP31, BP3 ON */
  } Bits;
  struct {
    byte grpFP30BP :4;
    byte grpFP31BP :4;
  } MergedBits;
} LCDRAM15STR;
extern volatile LCDRAM15STR _LCDRAM15 @(REG_BASE + 0x00000217UL);
#define LCDRAM15                        _LCDRAM15.Byte
#define LCDRAM15_FP30BP0                _LCDRAM15.Bits.FP30BP0
#define LCDRAM15_FP30BP1                _LCDRAM15.Bits.FP30BP1
#define LCDRAM15_FP30BP2                _LCDRAM15.Bits.FP30BP2
#define LCDRAM15_FP30BP3                _LCDRAM15.Bits.FP30BP3
#define LCDRAM15_FP31BP0                _LCDRAM15.Bits.FP31BP0
#define LCDRAM15_FP31BP1                _LCDRAM15.Bits.FP31BP1
#define LCDRAM15_FP31BP2                _LCDRAM15.Bits.FP31BP2
#define LCDRAM15_FP31BP3                _LCDRAM15.Bits.FP31BP3
#define LCDRAM15_FP30BP                 _LCDRAM15.MergedBits.grpFP30BP
#define LCDRAM15_FP31BP                 _LCDRAM15.MergedBits.grpFP31BP

#define LCDRAM15_FP30BP0_MASK           1U
#define LCDRAM15_FP30BP1_MASK           2U
#define LCDRAM15_FP30BP2_MASK           4U
#define LCDRAM15_FP30BP3_MASK           8U
#define LCDRAM15_FP31BP0_MASK           16U
#define LCDRAM15_FP31BP1_MASK           32U
#define LCDRAM15_FP31BP2_MASK           64U
#define LCDRAM15_FP31BP3_MASK           128U
#define LCDRAM15_FP30BP_MASK            15U
#define LCDRAM15_FP30BP_BITNUM          0U
#define LCDRAM15_FP31BP_MASK            240U
#define LCDRAM15_FP31BP_BITNUM          4U


/*** LCDRAM16 - LCD RAM 16; 0x00000218 ***/
typedef union {
  byte Byte;
  struct {
    byte FP32BP0     :1;                                       /* LCD Segment FP32, BP0 ON */
    byte FP32BP1     :1;                                       /* LCD Segment FP32, BP1 ON */
    byte FP32BP2     :1;                                       /* LCD Segment FP32, BP2 ON */
    byte FP32BP3     :1;                                       /* LCD Segment FP32, BP3 ON */
    byte FP33BP0     :1;                                       /* LCD Segment FP33, BP0 ON */
    byte FP33BP1     :1;                                       /* LCD Segment FP33, BP1 ON */
    byte FP33BP2     :1;                                       /* LCD Segment FP33, BP2 ON */
    byte FP33BP3     :1;                                       /* LCD Segment FP33, BP3 ON */
  } Bits;
  struct {
    byte grpFP32BP :4;
    byte grpFP33BP :4;
  } MergedBits;
} LCDRAM16STR;
extern volatile LCDRAM16STR _LCDRAM16 @(REG_BASE + 0x00000218UL);
#define LCDRAM16                        _LCDRAM16.Byte
#define LCDRAM16_FP32BP0                _LCDRAM16.Bits.FP32BP0
#define LCDRAM16_FP32BP1                _LCDRAM16.Bits.FP32BP1
#define LCDRAM16_FP32BP2                _LCDRAM16.Bits.FP32BP2
#define LCDRAM16_FP32BP3                _LCDRAM16.Bits.FP32BP3
#define LCDRAM16_FP33BP0                _LCDRAM16.Bits.FP33BP0
#define LCDRAM16_FP33BP1                _LCDRAM16.Bits.FP33BP1
#define LCDRAM16_FP33BP2                _LCDRAM16.Bits.FP33BP2
#define LCDRAM16_FP33BP3                _LCDRAM16.Bits.FP33BP3
#define LCDRAM16_FP32BP                 _LCDRAM16.MergedBits.grpFP32BP
#define LCDRAM16_FP33BP                 _LCDRAM16.MergedBits.grpFP33BP

#define LCDRAM16_FP32BP0_MASK           1U
#define LCDRAM16_FP32BP1_MASK           2U
#define LCDRAM16_FP32BP2_MASK           4U
#define LCDRAM16_FP32BP3_MASK           8U
#define LCDRAM16_FP33BP0_MASK           16U
#define LCDRAM16_FP33BP1_MASK           32U
#define LCDRAM16_FP33BP2_MASK           64U
#define LCDRAM16_FP33BP3_MASK           128U
#define LCDRAM16_FP32BP_MASK            15U
#define LCDRAM16_FP32BP_BITNUM          0U
#define LCDRAM16_FP33BP_MASK            240U
#define LCDRAM16_FP33BP_BITNUM          4U


/*** LCDRAM17 - LCD RAM 17; 0x00000219 ***/
typedef union {
  byte Byte;
  struct {
    byte FP34BP0     :1;                                       /* LCD Segment FP34, BP0 ON */
    byte FP34BP1     :1;                                       /* LCD Segment FP34, BP1 ON */
    byte FP34BP2     :1;                                       /* LCD Segment FP34, BP2 ON */
    byte FP34BP3     :1;                                       /* LCD Segment FP34, BP3 ON */
    byte FP35BP0     :1;                                       /* LCD Segment FP35, BP0 ON */
    byte FP35BP1     :1;                                       /* LCD Segment FP35, BP1 ON */
    byte FP35BP2     :1;                                       /* LCD Segment FP35, BP2 ON */
    byte FP35BP3     :1;                                       /* LCD Segment FP35, BP3 ON */
  } Bits;
  struct {
    byte grpFP34BP :4;
    byte grpFP35BP :4;
  } MergedBits;
} LCDRAM17STR;
extern volatile LCDRAM17STR _LCDRAM17 @(REG_BASE + 0x00000219UL);
#define LCDRAM17                        _LCDRAM17.Byte
#define LCDRAM17_FP34BP0                _LCDRAM17.Bits.FP34BP0
#define LCDRAM17_FP34BP1                _LCDRAM17.Bits.FP34BP1
#define LCDRAM17_FP34BP2                _LCDRAM17.Bits.FP34BP2
#define LCDRAM17_FP34BP3                _LCDRAM17.Bits.FP34BP3
#define LCDRAM17_FP35BP0                _LCDRAM17.Bits.FP35BP0
#define LCDRAM17_FP35BP1                _LCDRAM17.Bits.FP35BP1
#define LCDRAM17_FP35BP2                _LCDRAM17.Bits.FP35BP2
#define LCDRAM17_FP35BP3                _LCDRAM17.Bits.FP35BP3
#define LCDRAM17_FP34BP                 _LCDRAM17.MergedBits.grpFP34BP
#define LCDRAM17_FP35BP                 _LCDRAM17.MergedBits.grpFP35BP

#define LCDRAM17_FP34BP0_MASK           1U
#define LCDRAM17_FP34BP1_MASK           2U
#define LCDRAM17_FP34BP2_MASK           4U
#define LCDRAM17_FP34BP3_MASK           8U
#define LCDRAM17_FP35BP0_MASK           16U
#define LCDRAM17_FP35BP1_MASK           32U
#define LCDRAM17_FP35BP2_MASK           64U
#define LCDRAM17_FP35BP3_MASK           128U
#define LCDRAM17_FP34BP_MASK            15U
#define LCDRAM17_FP34BP_BITNUM          0U
#define LCDRAM17_FP35BP_MASK            240U
#define LCDRAM17_FP35BP_BITNUM          4U


/*** LCDRAM18 - LCD RAM 18; 0x0000021A ***/
typedef union {
  byte Byte;
  struct {
    byte FP36BP0     :1;                                       /* LCD Segment FP36, BP0 ON */
    byte FP36BP1     :1;                                       /* LCD Segment FP36, BP1 ON */
    byte FP36BP2     :1;                                       /* LCD Segment FP36, BP2 ON */
    byte FP36BP3     :1;                                       /* LCD Segment FP36, BP3 ON */
    byte FP37BP0     :1;                                       /* LCD Segment FP37, BP0 ON */
    byte FP37BP1     :1;                                       /* LCD Segment FP37, BP1 ON */
    byte FP37BP2     :1;                                       /* LCD Segment FP37, BP2 ON */
    byte FP37BP3     :1;                                       /* LCD Segment FP37, BP3 ON */
  } Bits;
  struct {
    byte grpFP36BP :4;
    byte grpFP37BP :4;
  } MergedBits;
} LCDRAM18STR;
extern volatile LCDRAM18STR _LCDRAM18 @(REG_BASE + 0x0000021AUL);
#define LCDRAM18                        _LCDRAM18.Byte
#define LCDRAM18_FP36BP0                _LCDRAM18.Bits.FP36BP0
#define LCDRAM18_FP36BP1                _LCDRAM18.Bits.FP36BP1
#define LCDRAM18_FP36BP2                _LCDRAM18.Bits.FP36BP2
#define LCDRAM18_FP36BP3                _LCDRAM18.Bits.FP36BP3
#define LCDRAM18_FP37BP0                _LCDRAM18.Bits.FP37BP0
#define LCDRAM18_FP37BP1                _LCDRAM18.Bits.FP37BP1
#define LCDRAM18_FP37BP2                _LCDRAM18.Bits.FP37BP2
#define LCDRAM18_FP37BP3                _LCDRAM18.Bits.FP37BP3
#define LCDRAM18_FP36BP                 _LCDRAM18.MergedBits.grpFP36BP
#define LCDRAM18_FP37BP                 _LCDRAM18.MergedBits.grpFP37BP

#define LCDRAM18_FP36BP0_MASK           1U
#define LCDRAM18_FP36BP1_MASK           2U
#define LCDRAM18_FP36BP2_MASK           4U
#define LCDRAM18_FP36BP3_MASK           8U
#define LCDRAM18_FP37BP0_MASK           16U
#define LCDRAM18_FP37BP1_MASK           32U
#define LCDRAM18_FP37BP2_MASK           64U
#define LCDRAM18_FP37BP3_MASK           128U
#define LCDRAM18_FP36BP_MASK            15U
#define LCDRAM18_FP36BP_BITNUM          0U
#define LCDRAM18_FP37BP_MASK            240U
#define LCDRAM18_FP37BP_BITNUM          4U


/*** LCDRAM19 - LCD RAM 19; 0x0000021B ***/
typedef union {
  byte Byte;
  struct {
    byte FP38BP0     :1;                                       /* LCD Segment FP38, BP0 ON */
    byte FP38BP1     :1;                                       /* LCD Segment FP38, BP1 ON */
    byte FP38BP2     :1;                                       /* LCD Segment FP38, BP2 ON */
    byte FP38BP3     :1;                                       /* LCD Segment FP38, BP3 ON */
    byte FP39BP0     :1;                                       /* LCD Segment FP39, BP0 ON */
    byte FP39BP1     :1;                                       /* LCD Segment FP39, BP1 ON */
    byte FP39BP2     :1;                                       /* LCD Segment FP39, BP2 ON */
    byte FP39BP3     :1;                                       /* LCD Segment FP39, BP3 ON */
  } Bits;
  struct {
    byte grpFP38BP :4;
    byte grpFP39BP :4;
  } MergedBits;
} LCDRAM19STR;
extern volatile LCDRAM19STR _LCDRAM19 @(REG_BASE + 0x0000021BUL);
#define LCDRAM19                        _LCDRAM19.Byte
#define LCDRAM19_FP38BP0                _LCDRAM19.Bits.FP38BP0
#define LCDRAM19_FP38BP1                _LCDRAM19.Bits.FP38BP1
#define LCDRAM19_FP38BP2                _LCDRAM19.Bits.FP38BP2
#define LCDRAM19_FP38BP3                _LCDRAM19.Bits.FP38BP3
#define LCDRAM19_FP39BP0                _LCDRAM19.Bits.FP39BP0
#define LCDRAM19_FP39BP1                _LCDRAM19.Bits.FP39BP1
#define LCDRAM19_FP39BP2                _LCDRAM19.Bits.FP39BP2
#define LCDRAM19_FP39BP3                _LCDRAM19.Bits.FP39BP3
#define LCDRAM19_FP38BP                 _LCDRAM19.MergedBits.grpFP38BP
#define LCDRAM19_FP39BP                 _LCDRAM19.MergedBits.grpFP39BP

#define LCDRAM19_FP38BP0_MASK           1U
#define LCDRAM19_FP38BP1_MASK           2U
#define LCDRAM19_FP38BP2_MASK           4U
#define LCDRAM19_FP38BP3_MASK           8U
#define LCDRAM19_FP39BP0_MASK           16U
#define LCDRAM19_FP39BP1_MASK           32U
#define LCDRAM19_FP39BP2_MASK           64U
#define LCDRAM19_FP39BP3_MASK           128U
#define LCDRAM19_FP38BP_MASK            15U
#define LCDRAM19_FP38BP_BITNUM          0U
#define LCDRAM19_FP39BP_MASK            240U
#define LCDRAM19_FP39BP_BITNUM          4U


/*** RTZ0CTL - SSD0 Return-to-Zero Control Register; 0x00000220 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ0CTLSTR;
extern volatile RTZ0CTLSTR _RTZ0CTL @(REG_BASE + 0x00000220UL);
#define RTZ0CTL                         _RTZ0CTL.Byte
#define RTZ0CTL_STEP                    _RTZ0CTL.Bits.STEP
#define RTZ0CTL_SMS                     _RTZ0CTL.Bits.SMS
#define RTZ0CTL_POL                     _RTZ0CTL.Bits.POL
#define RTZ0CTL_RCIR                    _RTZ0CTL.Bits.RCIR
#define RTZ0CTL_DCOIL                   _RTZ0CTL.Bits.DCOIL
#define RTZ0CTL_ITG                     _RTZ0CTL.Bits.ITG

#define RTZ0CTL_STEP_MASK               3U
#define RTZ0CTL_STEP_BITNUM             0U
#define RTZ0CTL_SMS_MASK                4U
#define RTZ0CTL_POL_MASK                16U
#define RTZ0CTL_RCIR_MASK               32U
#define RTZ0CTL_DCOIL_MASK              64U
#define RTZ0CTL_ITG_MASK                128U


/*** MDC0CTL - SSD0 Modulus Down Counter Control Register; 0x00000221 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC0CTLSTR;
extern volatile MDC0CTLSTR _MDC0CTL @(REG_BASE + 0x00000221UL);
#define MDC0CTL                         _MDC0CTL.Byte
#define MDC0CTL_AOVIE                   _MDC0CTL.Bits.AOVIE
#define MDC0CTL_MCEN                    _MDC0CTL.Bits.MCEN
#define MDC0CTL_FLMC                    _MDC0CTL.Bits.FLMC
#define MDC0CTL_PRE                     _MDC0CTL.Bits.PRE
#define MDC0CTL_RDMCL                   _MDC0CTL.Bits.RDMCL
#define MDC0CTL_MODMC                   _MDC0CTL.Bits.MODMC
#define MDC0CTL_MCZIE                   _MDC0CTL.Bits.MCZIE

#define MDC0CTL_AOVIE_MASK              1U
#define MDC0CTL_MCEN_MASK               4U
#define MDC0CTL_FLMC_MASK               8U
#define MDC0CTL_PRE_MASK                16U
#define MDC0CTL_RDMCL_MASK              32U
#define MDC0CTL_MODMC_MASK              64U
#define MDC0CTL_MCZIE_MASK              128U


/*** SSD0CTL - SSD0 Stepper Stall Detector Control Register; 0x00000222 ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD0CTLSTR;
extern volatile SSD0CTLSTR _SSD0CTL @(REG_BASE + 0x00000222UL);
#define SSD0CTL                         _SSD0CTL.Byte
#define SSD0CTL_ACLKS                   _SSD0CTL.Bits.ACLKS
#define SSD0CTL_FTST                    _SSD0CTL.Bits.FTST
#define SSD0CTL_SSDWAI                  _SSD0CTL.Bits.SSDWAI
#define SSD0CTL_SDCPU                   _SSD0CTL.Bits.SDCPU
#define SSD0CTL_RTZE                    _SSD0CTL.Bits.RTZE

#define SSD0CTL_ACLKS_MASK              3U
#define SSD0CTL_ACLKS_BITNUM            0U
#define SSD0CTL_FTST_MASK               16U
#define SSD0CTL_SSDWAI_MASK             32U
#define SSD0CTL_SDCPU_MASK              64U
#define SSD0CTL_RTZE_MASK               128U


/*** SSD0FLG - SSD0 Stepper Stall Detector Flag Register; 0x00000223 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD0FLGSTR;
extern volatile SSD0FLGSTR _SSD0FLG @(REG_BASE + 0x00000223UL);
#define SSD0FLG                         _SSD0FLG.Byte
#define SSD0FLG_AOVIF                   _SSD0FLG.Bits.AOVIF
#define SSD0FLG_MCZIF                   _SSD0FLG.Bits.MCZIF

#define SSD0FLG_AOVIF_MASK              1U
#define SSD0FLG_MCZIF_MASK              128U


/*** MDC0CNT - SSD0 Modulus Down-Counter Count Register; 0x00000224 ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC0CNTSTR;
extern volatile MDC0CNTSTR _MDC0CNT @(REG_BASE + 0x00000224UL);
#define MDC0CNT                         _MDC0CNT.Word
#define MDC0CNT_MDCCNT                  _MDC0CNT.Bits.MDCCNT

#define MDC0CNT_MDCCNT_MASK             65535U
#define MDC0CNT_MDCCNT_BITNUM           0U


/*** ITG0ACC - SSD0 Integration Accumulator Register; 0x00000226 ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG0ACCSTR;
extern volatile ITG0ACCSTR _ITG0ACC @(REG_BASE + 0x00000226UL);
#define ITG0ACC                         _ITG0ACC.Word
#define ITG0ACC_ITGACC                  _ITG0ACC.Bits.ITGACC

#define ITG0ACC_ITGACC_MASK             65535U
#define ITG0ACC_ITGACC_BITNUM           0U


/*** RTZ1CTL - SSD1 Return-to-Zero Control Register; 0x00000228 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ1CTLSTR;
extern volatile RTZ1CTLSTR _RTZ1CTL @(REG_BASE + 0x00000228UL);
#define RTZ1CTL                         _RTZ1CTL.Byte
#define RTZ1CTL_STEP                    _RTZ1CTL.Bits.STEP
#define RTZ1CTL_SMS                     _RTZ1CTL.Bits.SMS
#define RTZ1CTL_POL                     _RTZ1CTL.Bits.POL
#define RTZ1CTL_RCIR                    _RTZ1CTL.Bits.RCIR
#define RTZ1CTL_DCOIL                   _RTZ1CTL.Bits.DCOIL
#define RTZ1CTL_ITG                     _RTZ1CTL.Bits.ITG

#define RTZ1CTL_STEP_MASK               3U
#define RTZ1CTL_STEP_BITNUM             0U
#define RTZ1CTL_SMS_MASK                4U
#define RTZ1CTL_POL_MASK                16U
#define RTZ1CTL_RCIR_MASK               32U
#define RTZ1CTL_DCOIL_MASK              64U
#define RTZ1CTL_ITG_MASK                128U


/*** MDC1CTL - SSD1 Modulus Down Counter Control Register; 0x00000229 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC1CTLSTR;
extern volatile MDC1CTLSTR _MDC1CTL @(REG_BASE + 0x00000229UL);
#define MDC1CTL                         _MDC1CTL.Byte
#define MDC1CTL_AOVIE                   _MDC1CTL.Bits.AOVIE
#define MDC1CTL_MCEN                    _MDC1CTL.Bits.MCEN
#define MDC1CTL_FLMC                    _MDC1CTL.Bits.FLMC
#define MDC1CTL_PRE                     _MDC1CTL.Bits.PRE
#define MDC1CTL_RDMCL                   _MDC1CTL.Bits.RDMCL
#define MDC1CTL_MODMC                   _MDC1CTL.Bits.MODMC
#define MDC1CTL_MCZIE                   _MDC1CTL.Bits.MCZIE

#define MDC1CTL_AOVIE_MASK              1U
#define MDC1CTL_MCEN_MASK               4U
#define MDC1CTL_FLMC_MASK               8U
#define MDC1CTL_PRE_MASK                16U
#define MDC1CTL_RDMCL_MASK              32U
#define MDC1CTL_MODMC_MASK              64U
#define MDC1CTL_MCZIE_MASK              128U


/*** SSD1CTL - SSD1 Stepper Stall Detector Control Register; 0x0000022A ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD1CTLSTR;
extern volatile SSD1CTLSTR _SSD1CTL @(REG_BASE + 0x0000022AUL);
#define SSD1CTL                         _SSD1CTL.Byte
#define SSD1CTL_ACLKS                   _SSD1CTL.Bits.ACLKS
#define SSD1CTL_FTST                    _SSD1CTL.Bits.FTST
#define SSD1CTL_SSDWAI                  _SSD1CTL.Bits.SSDWAI
#define SSD1CTL_SDCPU                   _SSD1CTL.Bits.SDCPU
#define SSD1CTL_RTZE                    _SSD1CTL.Bits.RTZE

#define SSD1CTL_ACLKS_MASK              3U
#define SSD1CTL_ACLKS_BITNUM            0U
#define SSD1CTL_FTST_MASK               16U
#define SSD1CTL_SSDWAI_MASK             32U
#define SSD1CTL_SDCPU_MASK              64U
#define SSD1CTL_RTZE_MASK               128U


/*** SSD1FLG - SSD1 Stepper Stall Detector Flag Register; 0x0000022B ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD1FLGSTR;
extern volatile SSD1FLGSTR _SSD1FLG @(REG_BASE + 0x0000022BUL);
#define SSD1FLG                         _SSD1FLG.Byte
#define SSD1FLG_AOVIF                   _SSD1FLG.Bits.AOVIF
#define SSD1FLG_MCZIF                   _SSD1FLG.Bits.MCZIF

#define SSD1FLG_AOVIF_MASK              1U
#define SSD1FLG_MCZIF_MASK              128U


/*** MDC1CNT - SSD1 Modulus Down-Counter Count Register; 0x0000022C ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC1CNTSTR;
extern volatile MDC1CNTSTR _MDC1CNT @(REG_BASE + 0x0000022CUL);
#define MDC1CNT                         _MDC1CNT.Word
#define MDC1CNT_MDCCNT                  _MDC1CNT.Bits.MDCCNT

#define MDC1CNT_MDCCNT_MASK             65535U
#define MDC1CNT_MDCCNT_BITNUM           0U


/*** ITG1ACC - SSD1 Integration Accumulator Register; 0x0000022E ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG1ACCSTR;
extern volatile ITG1ACCSTR _ITG1ACC @(REG_BASE + 0x0000022EUL);
#define ITG1ACC                         _ITG1ACC.Word
#define ITG1ACC_ITGACC                  _ITG1ACC.Bits.ITGACC

#define ITG1ACC_ITGACC_MASK             65535U
#define ITG1ACC_ITGACC_BITNUM           0U


/*** RTZ2CTL - SSD2 Return-to-Zero Control Register; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ2CTLSTR;
extern volatile RTZ2CTLSTR _RTZ2CTL @(REG_BASE + 0x00000230UL);
#define RTZ2CTL                         _RTZ2CTL.Byte
#define RTZ2CTL_STEP                    _RTZ2CTL.Bits.STEP
#define RTZ2CTL_SMS                     _RTZ2CTL.Bits.SMS
#define RTZ2CTL_POL                     _RTZ2CTL.Bits.POL
#define RTZ2CTL_RCIR                    _RTZ2CTL.Bits.RCIR
#define RTZ2CTL_DCOIL                   _RTZ2CTL.Bits.DCOIL
#define RTZ2CTL_ITG                     _RTZ2CTL.Bits.ITG

#define RTZ2CTL_STEP_MASK               3U
#define RTZ2CTL_STEP_BITNUM             0U
#define RTZ2CTL_SMS_MASK                4U
#define RTZ2CTL_POL_MASK                16U
#define RTZ2CTL_RCIR_MASK               32U
#define RTZ2CTL_DCOIL_MASK              64U
#define RTZ2CTL_ITG_MASK                128U


/*** MDC2CTL - SSD2 Modulus Down Counter Control Register; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC2CTLSTR;
extern volatile MDC2CTLSTR _MDC2CTL @(REG_BASE + 0x00000231UL);
#define MDC2CTL                         _MDC2CTL.Byte
#define MDC2CTL_AOVIE                   _MDC2CTL.Bits.AOVIE
#define MDC2CTL_MCEN                    _MDC2CTL.Bits.MCEN
#define MDC2CTL_FLMC                    _MDC2CTL.Bits.FLMC
#define MDC2CTL_PRE                     _MDC2CTL.Bits.PRE
#define MDC2CTL_RDMCL                   _MDC2CTL.Bits.RDMCL
#define MDC2CTL_MODMC                   _MDC2CTL.Bits.MODMC
#define MDC2CTL_MCZIE                   _MDC2CTL.Bits.MCZIE

#define MDC2CTL_AOVIE_MASK              1U
#define MDC2CTL_MCEN_MASK               4U
#define MDC2CTL_FLMC_MASK               8U
#define MDC2CTL_PRE_MASK                16U
#define MDC2CTL_RDMCL_MASK              32U
#define MDC2CTL_MODMC_MASK              64U
#define MDC2CTL_MCZIE_MASK              128U


/*** SSD2CTL - SSD2 Stepper Stall Detector Control Register; 0x00000232 ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD2CTLSTR;
extern volatile SSD2CTLSTR _SSD2CTL @(REG_BASE + 0x00000232UL);
#define SSD2CTL                         _SSD2CTL.Byte
#define SSD2CTL_ACLKS                   _SSD2CTL.Bits.ACLKS
#define SSD2CTL_FTST                    _SSD2CTL.Bits.FTST
#define SSD2CTL_SSDWAI                  _SSD2CTL.Bits.SSDWAI
#define SSD2CTL_SDCPU                   _SSD2CTL.Bits.SDCPU
#define SSD2CTL_RTZE                    _SSD2CTL.Bits.RTZE

#define SSD2CTL_ACLKS_MASK              3U
#define SSD2CTL_ACLKS_BITNUM            0U
#define SSD2CTL_FTST_MASK               16U
#define SSD2CTL_SSDWAI_MASK             32U
#define SSD2CTL_SDCPU_MASK              64U
#define SSD2CTL_RTZE_MASK               128U


/*** SSD2FLG - SSD2 Stepper Stall Detector Flag Register; 0x00000233 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD2FLGSTR;
extern volatile SSD2FLGSTR _SSD2FLG @(REG_BASE + 0x00000233UL);
#define SSD2FLG                         _SSD2FLG.Byte
#define SSD2FLG_AOVIF                   _SSD2FLG.Bits.AOVIF
#define SSD2FLG_MCZIF                   _SSD2FLG.Bits.MCZIF

#define SSD2FLG_AOVIF_MASK              1U
#define SSD2FLG_MCZIF_MASK              128U


/*** MDC2CNT - SSD2 Modulus Down-Counter Count Register; 0x00000234 ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC2CNTSTR;
extern volatile MDC2CNTSTR _MDC2CNT @(REG_BASE + 0x00000234UL);
#define MDC2CNT                         _MDC2CNT.Word
#define MDC2CNT_MDCCNT                  _MDC2CNT.Bits.MDCCNT

#define MDC2CNT_MDCCNT_MASK             65535U
#define MDC2CNT_MDCCNT_BITNUM           0U


/*** ITG2ACC - SSD2 Integration Accumulator Register; 0x00000236 ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG2ACCSTR;
extern volatile ITG2ACCSTR _ITG2ACC @(REG_BASE + 0x00000236UL);
#define ITG2ACC                         _ITG2ACC.Word
#define ITG2ACC_ITGACC                  _ITG2ACC.Bits.ITGACC

#define ITG2ACC_ITGACC_MASK             65535U
#define ITG2ACC_ITGACC_BITNUM           0U


/*** RTZ3CTL - SSD3 Return-to-Zero Control Register; 0x00000238 ***/
typedef union {
  byte Byte;
  struct {
    byte STEP        :2;                                       /* Full Step State */
    byte SMS         :1;                                       /* Stepper Motor Select */
    byte             :1; 
    byte POL         :1;                                       /* Polarity */
    byte RCIR        :1;                                       /* Recirculation in Blanking Mode */
    byte DCOIL       :1;                                       /* Drive Coil */
    byte ITG         :1;                                       /* Integration */
  } Bits;
} RTZ3CTLSTR;
extern volatile RTZ3CTLSTR _RTZ3CTL @(REG_BASE + 0x00000238UL);
#define RTZ3CTL                         _RTZ3CTL.Byte
#define RTZ3CTL_STEP                    _RTZ3CTL.Bits.STEP
#define RTZ3CTL_SMS                     _RTZ3CTL.Bits.SMS
#define RTZ3CTL_POL                     _RTZ3CTL.Bits.POL
#define RTZ3CTL_RCIR                    _RTZ3CTL.Bits.RCIR
#define RTZ3CTL_DCOIL                   _RTZ3CTL.Bits.DCOIL
#define RTZ3CTL_ITG                     _RTZ3CTL.Bits.ITG

#define RTZ3CTL_STEP_MASK               3U
#define RTZ3CTL_STEP_BITNUM             0U
#define RTZ3CTL_SMS_MASK                4U
#define RTZ3CTL_POL_MASK                16U
#define RTZ3CTL_RCIR_MASK               32U
#define RTZ3CTL_DCOIL_MASK              64U
#define RTZ3CTL_ITG_MASK                128U


/*** MDC3CTL - SSD3 Modulus Down Counter Control Register; 0x00000239 ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIE       :1;                                       /* Accumulator Overflow Interrupt Enable */
    byte             :1; 
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte PRE         :1;                                       /* Prescaler */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZIE       :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
} MDC3CTLSTR;
extern volatile MDC3CTLSTR _MDC3CTL @(REG_BASE + 0x00000239UL);
#define MDC3CTL                         _MDC3CTL.Byte
#define MDC3CTL_AOVIE                   _MDC3CTL.Bits.AOVIE
#define MDC3CTL_MCEN                    _MDC3CTL.Bits.MCEN
#define MDC3CTL_FLMC                    _MDC3CTL.Bits.FLMC
#define MDC3CTL_PRE                     _MDC3CTL.Bits.PRE
#define MDC3CTL_RDMCL                   _MDC3CTL.Bits.RDMCL
#define MDC3CTL_MODMC                   _MDC3CTL.Bits.MODMC
#define MDC3CTL_MCZIE                   _MDC3CTL.Bits.MCZIE

#define MDC3CTL_AOVIE_MASK              1U
#define MDC3CTL_MCEN_MASK               4U
#define MDC3CTL_FLMC_MASK               8U
#define MDC3CTL_PRE_MASK                16U
#define MDC3CTL_RDMCL_MASK              32U
#define MDC3CTL_MODMC_MASK              64U
#define MDC3CTL_MCZIE_MASK              128U


/*** SSD3CTL - SSD3 Stepper Stall Detector Control Register; 0x0000023A ***/
typedef union {
  byte Byte;
  struct {
    byte ACLKS       :2;                                       /* Accumulator Sample Frequency Select */
    byte             :1; 
    byte             :1; 
    byte FTST        :1;                                       /* Factory Test */
    byte SSDWAI      :1;                                       /* SSD Disabled during Wait Mode */
    byte SDCPU       :1;                                       /* Sigma-Delta Converter Power Up */
    byte RTZE        :1;                                       /* Return to Zero Enable */
  } Bits;
} SSD3CTLSTR;
extern volatile SSD3CTLSTR _SSD3CTL @(REG_BASE + 0x0000023AUL);
#define SSD3CTL                         _SSD3CTL.Byte
#define SSD3CTL_ACLKS                   _SSD3CTL.Bits.ACLKS
#define SSD3CTL_FTST                    _SSD3CTL.Bits.FTST
#define SSD3CTL_SSDWAI                  _SSD3CTL.Bits.SSDWAI
#define SSD3CTL_SDCPU                   _SSD3CTL.Bits.SDCPU
#define SSD3CTL_RTZE                    _SSD3CTL.Bits.RTZE

#define SSD3CTL_ACLKS_MASK              3U
#define SSD3CTL_ACLKS_BITNUM            0U
#define SSD3CTL_FTST_MASK               16U
#define SSD3CTL_SSDWAI_MASK             32U
#define SSD3CTL_SDCPU_MASK              64U
#define SSD3CTL_RTZE_MASK               128U


/*** SSD3FLG - SSD3 Stepper Stall Detector Flag Register; 0x0000023B ***/
typedef union {
  byte Byte;
  struct {
    byte AOVIF       :1;                                       /* Accumulator Overflow Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZIF       :1;                                       /* Modulus Counter Underflow Interrupt Flag */
  } Bits;
} SSD3FLGSTR;
extern volatile SSD3FLGSTR _SSD3FLG @(REG_BASE + 0x0000023BUL);
#define SSD3FLG                         _SSD3FLG.Byte
#define SSD3FLG_AOVIF                   _SSD3FLG.Bits.AOVIF
#define SSD3FLG_MCZIF                   _SSD3FLG.Bits.MCZIF

#define SSD3FLG_AOVIF_MASK              1U
#define SSD3FLG_MCZIF_MASK              128U


/*** MDC3CNT - SSD3 Modulus Down-Counter Count Register; 0x0000023C ***/
typedef union {
  word Word;
  struct {
    word MDCCNT      :16;                                      /* Modulus Down Counter */
  } Bits;
} MDC3CNTSTR;
extern volatile MDC3CNTSTR _MDC3CNT @(REG_BASE + 0x0000023CUL);
#define MDC3CNT                         _MDC3CNT.Word
#define MDC3CNT_MDCCNT                  _MDC3CNT.Bits.MDCCNT

#define MDC3CNT_MDCCNT_MASK             65535U
#define MDC3CNT_MDCCNT_BITNUM           0U


/*** ITG3ACC - SSD3 Integration Accumulator Register; 0x0000023E ***/
typedef union {
  word Word;
  struct {
    word ITGACC      :16;                                      /* Integration Accumulator */
  } Bits;
} ITG3ACCSTR;
extern volatile ITG3ACCSTR _ITG3ACC @(REG_BASE + 0x0000023EUL);
#define ITG3ACC                         _ITG3ACC.Word
#define ITG3ACC_ITGACC                  _ITG3ACC.Bits.ITGACC

#define ITG3ACC_ITGACC_MASK             65535U
#define ITG3ACC_ITGACC_BITNUM           0U


/*** PTT - Port T Data Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T general purpose input/output data bit 0 */
    byte PTT1        :1;                                       /* Port T general purpose input/output data bit 1 */
    byte PTT2        :1;                                       /* Port T general purpose input/output data bit 2 */
    byte PTT3        :1;                                       /* Port T general purpose input/output data bit 3 */
    byte PTT4        :1;                                       /* Port T general purpose input/output data bit 4 */
    byte PTT5        :1;                                       /* Port T general purpose input/output data bit 5 */
    byte PTT6        :1;                                       /* Port T general purpose input/output data bit 6 */
    byte PTT7        :1;                                       /* Port T general purpose input/output data bit 7 */
  } Bits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000240UL);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT4                        _PTT.Bits.PTT4
#define PTT_PTT5                        _PTT.Bits.PTT5
#define PTT_PTT6                        _PTT.Bits.PTT6
#define PTT_PTT7                        _PTT.Bits.PTT7

#define PTT_PTT0_MASK                   1U
#define PTT_PTT1_MASK                   2U
#define PTT_PTT2_MASK                   4U
#define PTT_PTT3_MASK                   8U
#define PTT_PTT4_MASK                   16U
#define PTT_PTT5_MASK                   32U
#define PTT_PTT6_MASK                   64U
#define PTT_PTT7_MASK                   128U


/*** PTIT - Port T Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T input data bit 0 */
    byte PTIT1       :1;                                       /* Port T input data bit 1 */
    byte PTIT2       :1;                                       /* Port T input data bit 2 */
    byte PTIT3       :1;                                       /* Port T input data bit 3 */
    byte PTIT4       :1;                                       /* Port T input data bit 4 */
    byte PTIT5       :1;                                       /* Port T input data bit 5 */
    byte PTIT6       :1;                                       /* Port T input data bit 6 */
    byte PTIT7       :1;                                       /* Port T input data bit 7 */
  } Bits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000241UL);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT4                      _PTIT.Bits.PTIT4
#define PTIT_PTIT5                      _PTIT.Bits.PTIT5
#define PTIT_PTIT6                      _PTIT.Bits.PTIT6
#define PTIT_PTIT7                      _PTIT.Bits.PTIT7

#define PTIT_PTIT0_MASK                 1U
#define PTIT_PTIT1_MASK                 2U
#define PTIT_PTIT2_MASK                 4U
#define PTIT_PTIT3_MASK                 8U
#define PTIT_PTIT4_MASK                 16U
#define PTIT_PTIT5_MASK                 32U
#define PTIT_PTIT6_MASK                 64U
#define PTIT_PTIT7_MASK                 128U


/*** DDRT - Port T Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Port T data direction bit 0 */
    byte DDRT1       :1;                                       /* Port T data direction bit 1 */
    byte DDRT2       :1;                                       /* Port T data direction bit 2 */
    byte DDRT3       :1;                                       /* Port T data direction bit 3 */
    byte DDRT4       :1;                                       /* Port T data direction bit 4 */
    byte DDRT5       :1;                                       /* Port T data direction bit 5 */
    byte DDRT6       :1;                                       /* Port T data direction bit 6 */
    byte DDRT7       :1;                                       /* Port T data direction bit 7 */
  } Bits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000242UL);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT4                      _DDRT.Bits.DDRT4
#define DDRT_DDRT5                      _DDRT.Bits.DDRT5
#define DDRT_DDRT6                      _DDRT.Bits.DDRT6
#define DDRT_DDRT7                      _DDRT.Bits.DDRT7

#define DDRT_DDRT0_MASK                 1U
#define DDRT_DDRT1_MASK                 2U
#define DDRT_DDRT2_MASK                 4U
#define DDRT_DDRT3_MASK                 8U
#define DDRT_DDRT4_MASK                 16U
#define DDRT_DDRT5_MASK                 32U
#define DDRT_DDRT6_MASK                 64U
#define DDRT_DDRT7_MASK                 128U


/*** PERT - Port T Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Port T pull device enable bit 0 */
    byte PERT1       :1;                                       /* Port T pull device enable bit 1 */
    byte PERT2       :1;                                       /* Port T pull device enable bit 2 */
    byte PERT3       :1;                                       /* Port T pull device enable bit 3 */
    byte PERT4       :1;                                       /* Port T pull device enable bit 4 */
    byte PERT5       :1;                                       /* Port T pull device enable bit 5 */
    byte PERT6       :1;                                       /* Port T pull device enable bit 6 */
    byte PERT7       :1;                                       /* Port T pull device enable bit 7 */
  } Bits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000244UL);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT4                      _PERT.Bits.PERT4
#define PERT_PERT5                      _PERT.Bits.PERT5
#define PERT_PERT6                      _PERT.Bits.PERT6
#define PERT_PERT7                      _PERT.Bits.PERT7

#define PERT_PERT0_MASK                 1U
#define PERT_PERT1_MASK                 2U
#define PERT_PERT2_MASK                 4U
#define PERT_PERT3_MASK                 8U
#define PERT_PERT4_MASK                 16U
#define PERT_PERT5_MASK                 32U
#define PERT_PERT6_MASK                 64U
#define PERT_PERT7_MASK                 128U


/*** PPST - Port T Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Port T pull device select bit 0 */
    byte PPST1       :1;                                       /* Port T pull device select bit 1 */
    byte PPST2       :1;                                       /* Port T pull device select bit 2 */
    byte PPST3       :1;                                       /* Port T pull device select bit 3 */
    byte PPST4       :1;                                       /* Port T pull device select bit 4 */
    byte PPST5       :1;                                       /* Port T pull device select bit 5 */
    byte PPST6       :1;                                       /* Port T pull device select bit 6 */
    byte PPST7       :1;                                       /* Port T pull device select bit 7 */
  } Bits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000245UL);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST4                      _PPST.Bits.PPST4
#define PPST_PPST5                      _PPST.Bits.PPST5
#define PPST_PPST6                      _PPST.Bits.PPST6
#define PPST_PPST7                      _PPST.Bits.PPST7

#define PPST_PPST0_MASK                 1U
#define PPST_PPST1_MASK                 2U
#define PPST_PPST2_MASK                 4U
#define PPST_PPST3_MASK                 8U
#define PPST_PPST4_MASK                 16U
#define PPST_PPST5_MASK                 32U
#define PPST_PPST6_MASK                 64U
#define PPST_PPST7_MASK                 128U


/*** PTTRR - Port T Routing Register; 0x00000247 ***/
typedef union {
  byte Byte;
  struct {
    byte PTTRR0      :1;                                       /* Port T  routing */
    byte PTTRR1      :1;                                       /* Port T  routing */
    byte PTTRR2      :1;                                       /* Port T  routing */
    byte PTTRR3      :1;                                       /* Port T  routing */
    byte PTTRR4      :1;                                       /* Port T  routing */
    byte PTTRR5      :1;                                       /* Port T  routing */
    byte PTTRR6      :1;                                       /* Port T  routing */
    byte PTTRR7      :1;                                       /* Port T  routing */
  } Bits;
} PTTRRSTR;
extern volatile PTTRRSTR _PTTRR @(REG_BASE + 0x00000247UL);
#define PTTRR                           _PTTRR.Byte
#define PTTRR_PTTRR0                    _PTTRR.Bits.PTTRR0
#define PTTRR_PTTRR1                    _PTTRR.Bits.PTTRR1
#define PTTRR_PTTRR2                    _PTTRR.Bits.PTTRR2
#define PTTRR_PTTRR3                    _PTTRR.Bits.PTTRR3
#define PTTRR_PTTRR4                    _PTTRR.Bits.PTTRR4
#define PTTRR_PTTRR5                    _PTTRR.Bits.PTTRR5
#define PTTRR_PTTRR6                    _PTTRR.Bits.PTTRR6
#define PTTRR_PTTRR7                    _PTTRR.Bits.PTTRR7

#define PTTRR_PTTRR0_MASK               1U
#define PTTRR_PTTRR1_MASK               2U
#define PTTRR_PTTRR2_MASK               4U
#define PTTRR_PTTRR3_MASK               8U
#define PTTRR_PTTRR4_MASK               16U
#define PTTRR_PTTRR5_MASK               32U
#define PTTRR_PTTRR6_MASK               64U
#define PTTRR_PTTRR7_MASK               128U


/*** PTS - Port S Data Register; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S general purpose input/output data bit 0 */
    byte PTS1        :1;                                       /* Port S general purpose input/output data bit 1 */
    byte PTS2        :1;                                       /* Port S general purpose input/output data bit 2 */
    byte PTS3        :1;                                       /* Port S general purpose input/output data bit 3 */
    byte PTS4        :1;                                       /* Port S general purpose input/output data bit 4 */
    byte PTS5        :1;                                       /* Port S general purpose input/output data bit 5 */
    byte PTS6        :1;                                       /* Port S general purpose input/output data bit 6 */
    byte PTS7        :1;                                       /* Port S general purpose input/output data bit 7 */
  } Bits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000248UL);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS2                        _PTS.Bits.PTS2
#define PTS_PTS3                        _PTS.Bits.PTS3
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS7                        _PTS.Bits.PTS7

#define PTS_PTS0_MASK                   1U
#define PTS_PTS1_MASK                   2U
#define PTS_PTS2_MASK                   4U
#define PTS_PTS3_MASK                   8U
#define PTS_PTS4_MASK                   16U
#define PTS_PTS5_MASK                   32U
#define PTS_PTS6_MASK                   64U
#define PTS_PTS7_MASK                   128U


/*** PTIS - Port S Input Register; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S input data bit 0 */
    byte PTIS1       :1;                                       /* Port S input data bit 1 */
    byte PTIS2       :1;                                       /* Port S input data bit 2 */
    byte PTIS3       :1;                                       /* Port S input data bit 3 */
    byte PTIS4       :1;                                       /* Port S input data bit 4 */
    byte PTIS5       :1;                                       /* Port S input data bit 5 */
    byte PTIS6       :1;                                       /* Port S input data bit 6 */
    byte PTIS7       :1;                                       /* Port S input data bit 7 */
  } Bits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000249UL);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS2                      _PTIS.Bits.PTIS2
#define PTIS_PTIS3                      _PTIS.Bits.PTIS3
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS7                      _PTIS.Bits.PTIS7

#define PTIS_PTIS0_MASK                 1U
#define PTIS_PTIS1_MASK                 2U
#define PTIS_PTIS2_MASK                 4U
#define PTIS_PTIS3_MASK                 8U
#define PTIS_PTIS4_MASK                 16U
#define PTIS_PTIS5_MASK                 32U
#define PTIS_PTIS6_MASK                 64U
#define PTIS_PTIS7_MASK                 128U


/*** DDRS - Port S Data Direction Register; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Port S data direction bit 0 */
    byte DDRS1       :1;                                       /* Port S data direction bit 1 */
    byte DDRS2       :1;                                       /* Port S data direction bit 2 */
    byte DDRS3       :1;                                       /* Port S data direction bit 3 */
    byte DDRS4       :1;                                       /* Port S data direction bit 4 */
    byte DDRS5       :1;                                       /* Port S data direction bit 5 */
    byte DDRS6       :1;                                       /* Port S data direction bit 6 */
    byte DDRS7       :1;                                       /* Port S data direction bit 7 */
  } Bits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x0000024AUL);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS2                      _DDRS.Bits.DDRS2
#define DDRS_DDRS3                      _DDRS.Bits.DDRS3
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS7                      _DDRS.Bits.DDRS7

#define DDRS_DDRS0_MASK                 1U
#define DDRS_DDRS1_MASK                 2U
#define DDRS_DDRS2_MASK                 4U
#define DDRS_DDRS3_MASK                 8U
#define DDRS_DDRS4_MASK                 16U
#define DDRS_DDRS5_MASK                 32U
#define DDRS_DDRS6_MASK                 64U
#define DDRS_DDRS7_MASK                 128U


/*** PERS - Port S Pull Device Enable Register; 0x0000024C ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Port S pull device enable bit 0 */
    byte PERS1       :1;                                       /* Port S pull device enable bit 1 */
    byte PERS2       :1;                                       /* Port S pull device enable bit 2 */
    byte PERS3       :1;                                       /* Port S pull device enable bit 3 */
    byte PERS4       :1;                                       /* Port S pull device enable bit 4 */
    byte PERS5       :1;                                       /* Port S pull device enable bit 5 */
    byte PERS6       :1;                                       /* Port S pull device enable bit 6 */
    byte PERS7       :1;                                       /* Port S pull device enable bit 7 */
  } Bits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x0000024CUL);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS2                      _PERS.Bits.PERS2
#define PERS_PERS3                      _PERS.Bits.PERS3
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS7                      _PERS.Bits.PERS7

#define PERS_PERS0_MASK                 1U
#define PERS_PERS1_MASK                 2U
#define PERS_PERS2_MASK                 4U
#define PERS_PERS3_MASK                 8U
#define PERS_PERS4_MASK                 16U
#define PERS_PERS5_MASK                 32U
#define PERS_PERS6_MASK                 64U
#define PERS_PERS7_MASK                 128U


/*** PPSS - Port S Polarity Select Register; 0x0000024D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Port S pull device select bit 0 */
    byte PPSS1       :1;                                       /* Port S pull device select bit 1 */
    byte PPSS2       :1;                                       /* Port S pull device select bit 2 */
    byte PPSS3       :1;                                       /* Port S pull device select bit 3 */
    byte PPSS4       :1;                                       /* Port S pull device select bit 4 */
    byte PPSS5       :1;                                       /* Port S pull device select bit 5 */
    byte PPSS6       :1;                                       /* Port S pull device select bit 6 */
    byte PPSS7       :1;                                       /* Port S pull device select bit 7 */
  } Bits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x0000024DUL);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS2                      _PPSS.Bits.PPSS2
#define PPSS_PPSS3                      _PPSS.Bits.PPSS3
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS7                      _PPSS.Bits.PPSS7

#define PPSS_PPSS0_MASK                 1U
#define PPSS_PPSS1_MASK                 2U
#define PPSS_PPSS2_MASK                 4U
#define PPSS_PPSS3_MASK                 8U
#define PPSS_PPSS4_MASK                 16U
#define PPSS_PPSS5_MASK                 32U
#define PPSS_PPSS6_MASK                 64U
#define PPSS_PPSS7_MASK                 128U


/*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMS0       :1;                                       /* Port S wired-or mode bit 0 */
    byte WOMS1       :1;                                       /* Port S wired-or mode bit 1 */
    byte WOMS2       :1;                                       /* Port S wired-or mode bit 2 */
    byte WOMS3       :1;                                       /* Port S wired-or mode bit 3 */
    byte WOMS4       :1;                                       /* Port S wired-or mode bit 4 */
    byte WOMS5       :1;                                       /* Port S wired-or mode bit 5 */
    byte WOMS6       :1;                                       /* Port S wired-or mode bit 6 */
    byte WOMS7       :1;                                       /* Port S wired-or mode bit 7 */
  } Bits;
} WOMSSTR;
extern volatile WOMSSTR _WOMS @(REG_BASE + 0x0000024EUL);
#define WOMS                            _WOMS.Byte
#define WOMS_WOMS0                      _WOMS.Bits.WOMS0
#define WOMS_WOMS1                      _WOMS.Bits.WOMS1
#define WOMS_WOMS2                      _WOMS.Bits.WOMS2
#define WOMS_WOMS3                      _WOMS.Bits.WOMS3
#define WOMS_WOMS4                      _WOMS.Bits.WOMS4
#define WOMS_WOMS5                      _WOMS.Bits.WOMS5
#define WOMS_WOMS6                      _WOMS.Bits.WOMS6
#define WOMS_WOMS7                      _WOMS.Bits.WOMS7

#define WOMS_WOMS0_MASK                 1U
#define WOMS_WOMS1_MASK                 2U
#define WOMS_WOMS2_MASK                 4U
#define WOMS_WOMS3_MASK                 8U
#define WOMS_WOMS4_MASK                 16U
#define WOMS_WOMS5_MASK                 32U
#define WOMS_WOMS6_MASK                 64U
#define WOMS_WOMS7_MASK                 128U


/*** PTSRR - Port S Routing Register; 0x0000024F ***/
typedef union {
  byte Byte;
  struct {
    byte PTSRR0      :1;                                       /* Port S  routing */
    byte PTSRR1      :1;                                       /* Port S  routing */
    byte             :1; 
    byte             :1; 
    byte PTSRR4      :1;                                       /* Port S  routing */
    byte PTSRR5      :1;                                       /* Port S  routing */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTSRR :2;
    byte         :1;
    byte         :1;
    byte grpPTSRR_4 :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTSRRSTR;
extern volatile PTSRRSTR _PTSRR @(REG_BASE + 0x0000024FUL);
#define PTSRR                           _PTSRR.Byte
#define PTSRR_PTSRR0                    _PTSRR.Bits.PTSRR0
#define PTSRR_PTSRR1                    _PTSRR.Bits.PTSRR1
#define PTSRR_PTSRR4                    _PTSRR.Bits.PTSRR4
#define PTSRR_PTSRR5                    _PTSRR.Bits.PTSRR5
#define PTSRR_PTSRR                     _PTSRR.MergedBits.grpPTSRR
#define PTSRR_PTSRR_4                   _PTSRR.MergedBits.grpPTSRR_4

#define PTSRR_PTSRR0_MASK               1U
#define PTSRR_PTSRR1_MASK               2U
#define PTSRR_PTSRR4_MASK               16U
#define PTSRR_PTSRR5_MASK               32U
#define PTSRR_PTSRR_MASK                3U
#define PTSRR_PTSRR_BITNUM              0U
#define PTSRR_PTSRR_4_MASK              48U
#define PTSRR_PTSRR_4_BITNUM            4U


/*** PTM - Port M Data Register; 0x00000250 ***/
typedef union {
  byte Byte;
  struct {
    byte PTM0        :1;                                       /* Port M general purpose input/output data bit 0 */
    byte PTM1        :1;                                       /* Port M general purpose input/output data bit 1 */
    byte PTM2        :1;                                       /* Port M general purpose input/output data bit 2 */
    byte PTM3        :1;                                       /* Port M general purpose input/output data bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTM  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000250UL);
#define PTM                             _PTM.Byte
#define PTM_PTM0                        _PTM.Bits.PTM0
#define PTM_PTM1                        _PTM.Bits.PTM1
#define PTM_PTM2                        _PTM.Bits.PTM2
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM                         _PTM.MergedBits.grpPTM

#define PTM_PTM0_MASK                   1U
#define PTM_PTM1_MASK                   2U
#define PTM_PTM2_MASK                   4U
#define PTM_PTM3_MASK                   8U
#define PTM_PTM_MASK                    15U
#define PTM_PTM_BITNUM                  0U


/*** PTIM - Port M Input Register; 0x00000251 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIM0       :1;                                       /* Port M input data bit 0 */
    byte PTIM1       :1;                                       /* Port M input data bit 1 */
    byte PTIM2       :1;                                       /* Port M input data bit 2 */
    byte PTIM3       :1;                                       /* Port M input data bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTIM :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000251UL);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM0                      _PTIM.Bits.PTIM0
#define PTIM_PTIM1                      _PTIM.Bits.PTIM1
#define PTIM_PTIM2                      _PTIM.Bits.PTIM2
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM                       _PTIM.MergedBits.grpPTIM

#define PTIM_PTIM0_MASK                 1U
#define PTIM_PTIM1_MASK                 2U
#define PTIM_PTIM2_MASK                 4U
#define PTIM_PTIM3_MASK                 8U
#define PTIM_PTIM_MASK                  15U
#define PTIM_PTIM_BITNUM                0U


/*** DDRM - Port M Data Direction Register; 0x00000252 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRM0       :1;                                       /* Port M data direction bit 0 */
    byte DDRM1       :1;                                       /* Port M data direction bit 1 */
    byte DDRM2       :1;                                       /* Port M data direction bit 2 */
    byte DDRM3       :1;                                       /* Port M data direction bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRM :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x00000252UL);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM0                      _DDRM.Bits.DDRM0
#define DDRM_DDRM1                      _DDRM.Bits.DDRM1
#define DDRM_DDRM2                      _DDRM.Bits.DDRM2
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM                       _DDRM.MergedBits.grpDDRM

#define DDRM_DDRM0_MASK                 1U
#define DDRM_DDRM1_MASK                 2U
#define DDRM_DDRM2_MASK                 4U
#define DDRM_DDRM3_MASK                 8U
#define DDRM_DDRM_MASK                  15U
#define DDRM_DDRM_BITNUM                0U


/*** PERM - Port M Pull Device Enable Register; 0x00000254 ***/
typedef union {
  byte Byte;
  struct {
    byte PERM0       :1;                                       /* Port M pull device enable bit 0 */
    byte PERM1       :1;                                       /* Port M pull device enable bit 1 */
    byte PERM2       :1;                                       /* Port M pull device enable bit 2 */
    byte PERM3       :1;                                       /* Port M pull device enable bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPERM :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x00000254UL);
#define PERM                            _PERM.Byte
#define PERM_PERM0                      _PERM.Bits.PERM0
#define PERM_PERM1                      _PERM.Bits.PERM1
#define PERM_PERM2                      _PERM.Bits.PERM2
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM                       _PERM.MergedBits.grpPERM

#define PERM_PERM0_MASK                 1U
#define PERM_PERM1_MASK                 2U
#define PERM_PERM2_MASK                 4U
#define PERM_PERM3_MASK                 8U
#define PERM_PERM_MASK                  15U
#define PERM_PERM_BITNUM                0U


/*** PPSM - Port M Polarity Select Register; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSM0       :1;                                       /* Port M pull device select bit 0 */
    byte PPSM1       :1;                                       /* Port M pull device select bit 1 */
    byte PPSM2       :1;                                       /* Port M pull device select bit 2 */
    byte PPSM3       :1;                                       /* Port M pull device select bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPPSM :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x00000255UL);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM0                      _PPSM.Bits.PPSM0
#define PPSM_PPSM1                      _PPSM.Bits.PPSM1
#define PPSM_PPSM2                      _PPSM.Bits.PPSM2
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM                       _PPSM.MergedBits.grpPPSM

#define PPSM_PPSM0_MASK                 1U
#define PPSM_PPSM1_MASK                 2U
#define PPSM_PPSM2_MASK                 4U
#define PPSM_PPSM3_MASK                 8U
#define PPSM_PPSM_MASK                  15U
#define PPSM_PPSM_BITNUM                0U


/*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***/
typedef union {
  byte Byte;
  struct {
    byte WOMM0       :1;                                       /* Port M wired-or mode bit 0 */
    byte WOMM1       :1;                                       /* Port M wired-or mode bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpWOMM :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} WOMMSTR;
extern volatile WOMMSTR _WOMM @(REG_BASE + 0x00000256UL);
#define WOMM                            _WOMM.Byte
#define WOMM_WOMM0                      _WOMM.Bits.WOMM0
#define WOMM_WOMM1                      _WOMM.Bits.WOMM1
#define WOMM_WOMM                       _WOMM.MergedBits.grpWOMM

#define WOMM_WOMM0_MASK                 1U
#define WOMM_WOMM1_MASK                 2U
#define WOMM_WOMM_MASK                  3U
#define WOMM_WOMM_BITNUM                0U


/*** PTP - Port P Data Register; 0x00000258 ***/
typedef union {
  byte Byte;
  struct {
    byte PTP0        :1;                                       /* Port P general purpose input/output data bit 0 */
    byte PTP1        :1;                                       /* Port P general purpose input/output data bit 1 */
    byte PTP2        :1;                                       /* Port P general purpose input/output data bit 2 */
    byte PTP3        :1;                                       /* Port P general purpose input/output data bit 3 */
    byte PTP4        :1;                                       /* Port P general purpose input/output data bit 4 */
    byte PTP5        :1;                                       /* Port P general purpose input/output data bit 5 */
    byte PTP6        :1;                                       /* Port P general purpose input/output data bit 6 */
    byte PTP7        :1;                                       /* Port P general purpose input/output data bit 7 */
  } Bits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000258UL);
#define PTP                             _PTP.Byte
#define PTP_PTP0                        _PTP.Bits.PTP0
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP2                        _PTP.Bits.PTP2
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP6                        _PTP.Bits.PTP6
#define PTP_PTP7                        _PTP.Bits.PTP7

#define PTP_PTP0_MASK                   1U
#define PTP_PTP1_MASK                   2U
#define PTP_PTP2_MASK                   4U
#define PTP_PTP3_MASK                   8U
#define PTP_PTP4_MASK                   16U
#define PTP_PTP5_MASK                   32U
#define PTP_PTP6_MASK                   64U
#define PTP_PTP7_MASK                   128U


/*** PTIP - Port P Input Register; 0x00000259 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIP0       :1;                                       /* Port P input data bit 0 */
    byte PTIP1       :1;                                       /* Port P input data bit 1 */
    byte PTIP2       :1;                                       /* Port P input data bit 2 */
    byte PTIP3       :1;                                       /* Port P input data bit 3 */
    byte PTIP4       :1;                                       /* Port P input data bit 4 */
    byte PTIP5       :1;                                       /* Port P input data bit 5 */
    byte PTIP6       :1;                                       /* Port P input data bit 6 */
    byte PTIP7       :1;                                       /* Port P input data bit 7 */
  } Bits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000259UL);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP0                      _PTIP.Bits.PTIP0
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP2                      _PTIP.Bits.PTIP2
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP6                      _PTIP.Bits.PTIP6
#define PTIP_PTIP7                      _PTIP.Bits.PTIP7

#define PTIP_PTIP0_MASK                 1U
#define PTIP_PTIP1_MASK                 2U
#define PTIP_PTIP2_MASK                 4U
#define PTIP_PTIP3_MASK                 8U
#define PTIP_PTIP4_MASK                 16U
#define PTIP_PTIP5_MASK                 32U
#define PTIP_PTIP6_MASK                 64U
#define PTIP_PTIP7_MASK                 128U


/*** DDRP - Port P Data Direction Register; 0x0000025A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRP0       :1;                                       /* Port P data direction bit 0 */
    byte DDRP1       :1;                                       /* Port P data direction bit 1 */
    byte DDRP2       :1;                                       /* Port P data direction bit 2 */
    byte DDRP3       :1;                                       /* Port P data direction bit 3 */
    byte DDRP4       :1;                                       /* Port P data direction bit 4 */
    byte DDRP5       :1;                                       /* Port P data direction bit 5 */
    byte DDRP6       :1;                                       /* Port P data direction bit 6 */
    byte DDRP7       :1;                                       /* Port P data direction bit 7 */
  } Bits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000025AUL);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP0                      _DDRP.Bits.DDRP0
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP2                      _DDRP.Bits.DDRP2
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP6                      _DDRP.Bits.DDRP6
#define DDRP_DDRP7                      _DDRP.Bits.DDRP7

#define DDRP_DDRP0_MASK                 1U
#define DDRP_DDRP1_MASK                 2U
#define DDRP_DDRP2_MASK                 4U
#define DDRP_DDRP3_MASK                 8U
#define DDRP_DDRP4_MASK                 16U
#define DDRP_DDRP5_MASK                 32U
#define DDRP_DDRP6_MASK                 64U
#define DDRP_DDRP7_MASK                 128U


/*** PERP - Port P Pull Device Enable Register; 0x0000025C ***/
typedef union {
  byte Byte;
  struct {
    byte PERP0       :1;                                       /* Port P pull device enable bit 0 */
    byte PERP1       :1;                                       /* Port P pull device enable bit 1 */
    byte PERP2       :1;                                       /* Port P pull device enable bit 2 */
    byte PERP3       :1;                                       /* Port P pull device enable bit 3 */
    byte PERP4       :1;                                       /* Port P pull device enable bit 4 */
    byte PERP5       :1;                                       /* Port P pull device enable bit 5 */
    byte PERP6       :1;                                       /* Port P pull device enable bit 6 */
    byte PERP7       :1;                                       /* Port P pull device enable bit 7 */
  } Bits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000025CUL);
#define PERP                            _PERP.Byte
#define PERP_PERP0                      _PERP.Bits.PERP0
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP2                      _PERP.Bits.PERP2
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP6                      _PERP.Bits.PERP6
#define PERP_PERP7                      _PERP.Bits.PERP7

#define PERP_PERP0_MASK                 1U
#define PERP_PERP1_MASK                 2U
#define PERP_PERP2_MASK                 4U
#define PERP_PERP3_MASK                 8U
#define PERP_PERP4_MASK                 16U
#define PERP_PERP5_MASK                 32U
#define PERP_PERP6_MASK                 64U
#define PERP_PERP7_MASK                 128U


/*** PPSP - Port P Polarity Select Register; 0x0000025D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSP0       :1;                                       /* Port P pull device select bit 0 */
    byte PPSP1       :1;                                       /* Port P pull device select bit 1 */
    byte PPSP2       :1;                                       /* Port P pull device select bit 2 */
    byte PPSP3       :1;                                       /* Port P pull device select bit 3 */
    byte PPSP4       :1;                                       /* Port P pull device select bit 4 */
    byte PPSP5       :1;                                       /* Port P pull device select bit 5 */
    byte PPSP6       :1;                                       /* Port P pull device select bit 6 */
    byte PPSP7       :1;                                       /* Port P pull device select bit 7 */
  } Bits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000025DUL);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP0                      _PPSP.Bits.PPSP0
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP2                      _PPSP.Bits.PPSP2
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP6                      _PPSP.Bits.PPSP6
#define PPSP_PPSP7                      _PPSP.Bits.PPSP7

#define PPSP_PPSP0_MASK                 1U
#define PPSP_PPSP1_MASK                 2U
#define PPSP_PPSP2_MASK                 4U
#define PPSP_PPSP3_MASK                 8U
#define PPSP_PPSP4_MASK                 16U
#define PPSP_PPSP5_MASK                 32U
#define PPSP_PPSP6_MASK                 64U
#define PPSP_PPSP7_MASK                 128U


/*** PTPRR - Port P Routing Register; 0x0000025E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PTPRRH - Port P Routing Register High; 0x0000025E ***/
    union {
      byte Byte;
      struct {
        byte PTPRRH0     :1;                                       /* Port P  routing */
        byte PTPRRH1     :1;                                       /* Port P  routing */
        byte PTPRRH2     :1;                                       /* Port P  routing */
        byte PTPRRH3     :1;                                       /* Port P  routing */
        byte PTPRRH4     :1;                                       /* Port P  routing */
        byte PTPRRH5     :1;                                       /* Port P  routing */
        byte PTPRRH6     :1;                                       /* Port P  routing */
        byte PTPRRH7     :1;                                       /* Port P  routing */
      } Bits;
    } PTPRRHSTR;
    #define PTPRRH                      _PTPRR.Overlap_STR.PTPRRHSTR.Byte
    #define PTPRRH_PTPRRH0              _PTPRR.Overlap_STR.PTPRRHSTR.Bits.PTPRRH0
    #define PTPRRH_PTPRRH1              _PTPRR.Overlap_STR.PTPRRHSTR.Bits.PTPRRH1
    #define PTPRRH_PTPRRH2              _PTPRR.Overlap_STR.PTPRRHSTR.Bits.PTPRRH2
    #define PTPRRH_PTPRRH3              _PTPRR.Overlap_STR.PTPRRHSTR.Bits.PTPRRH3
    #define PTPRRH_PTPRRH4              _PTPRR.Overlap_STR.PTPRRHSTR.Bits.PTPRRH4
    #define PTPRRH_PTPRRH5              _PTPRR.Overlap_STR.PTPRRHSTR.Bits.PTPRRH5
    #define PTPRRH_PTPRRH6              _PTPRR.Overlap_STR.PTPRRHSTR.Bits.PTPRRH6
    #define PTPRRH_PTPRRH7              _PTPRR.Overlap_STR.PTPRRHSTR.Bits.PTPRRH7
    
    #define PTPRRH_PTPRRH0_MASK         1U
    #define PTPRRH_PTPRRH1_MASK         2U
    #define PTPRRH_PTPRRH2_MASK         4U
    #define PTPRRH_PTPRRH3_MASK         8U
    #define PTPRRH_PTPRRH4_MASK         16U
    #define PTPRRH_PTPRRH5_MASK         32U
    #define PTPRRH_PTPRRH6_MASK         64U
    #define PTPRRH_PTPRRH7_MASK         128U
    

    /*** PTPRRL - Port P Routing Register Low; 0x0000025F ***/
    union {
      byte Byte;
      struct {
        byte PTPRRL0     :1;                                       /* Port P  routing */
        byte PTPRRL1     :1;                                       /* Port P  routing */
        byte PTPRRL2     :1;                                       /* Port P  routing */
        byte PTPRRL3     :1;                                       /* Port P  routing */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpPTPRRL :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } PTPRRLSTR;
    #define PTPRRL                      _PTPRR.Overlap_STR.PTPRRLSTR.Byte
    #define PTPRRL_PTPRRL0              _PTPRR.Overlap_STR.PTPRRLSTR.Bits.PTPRRL0
    #define PTPRRL_PTPRRL1              _PTPRR.Overlap_STR.PTPRRLSTR.Bits.PTPRRL1
    #define PTPRRL_PTPRRL2              _PTPRR.Overlap_STR.PTPRRLSTR.Bits.PTPRRL2
    #define PTPRRL_PTPRRL3              _PTPRR.Overlap_STR.PTPRRLSTR.Bits.PTPRRL3
    #define PTPRRL_PTPRRL               _PTPRR.Overlap_STR.PTPRRLSTR.MergedBits.grpPTPRRL
    
    #define PTPRRL_PTPRRL0_MASK         1U
    #define PTPRRL_PTPRRL1_MASK         2U
    #define PTPRRL_PTPRRL2_MASK         4U
    #define PTPRRL_PTPRRL3_MASK         8U
    #define PTPRRL_PTPRRL_MASK          15U
    #define PTPRRL_PTPRRL_BITNUM        0U
    
  } Overlap_STR;

  struct {
    word PTPRRL0     :1;                                       /* Port P  routing */
    word PTPRRL1     :1;                                       /* Port P  routing */
    word PTPRRL2     :1;                                       /* Port P  routing */
    word PTPRRL3     :1;                                       /* Port P  routing */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word PTPRRH0     :1;                                       /* Port P  routing */
    word PTPRRH1     :1;                                       /* Port P  routing */
    word PTPRRH2     :1;                                       /* Port P  routing */
    word PTPRRH3     :1;                                       /* Port P  routing */
    word PTPRRH4     :1;                                       /* Port P  routing */
    word PTPRRH5     :1;                                       /* Port P  routing */
    word PTPRRH6     :1;                                       /* Port P  routing */
    word PTPRRH7     :1;                                       /* Port P  routing */
  } Bits;
  struct {
    word grpPTPRRL :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPTPRRH :8;
  } MergedBits;
} PTPRRSTR;
extern volatile PTPRRSTR _PTPRR @(REG_BASE + 0x0000025EUL);
#define PTPRR                           _PTPRR.Word
#define PTPRR_PTPRRL0                   _PTPRR.Bits.PTPRRL0
#define PTPRR_PTPRRL1                   _PTPRR.Bits.PTPRRL1
#define PTPRR_PTPRRL2                   _PTPRR.Bits.PTPRRL2
#define PTPRR_PTPRRL3                   _PTPRR.Bits.PTPRRL3
#define PTPRR_PTPRRH0                   _PTPRR.Bits.PTPRRH0
#define PTPRR_PTPRRH1                   _PTPRR.Bits.PTPRRH1
#define PTPRR_PTPRRH2                   _PTPRR.Bits.PTPRRH2
#define PTPRR_PTPRRH3                   _PTPRR.Bits.PTPRRH3
#define PTPRR_PTPRRH4                   _PTPRR.Bits.PTPRRH4
#define PTPRR_PTPRRH5                   _PTPRR.Bits.PTPRRH5
#define PTPRR_PTPRRH6                   _PTPRR.Bits.PTPRRH6
#define PTPRR_PTPRRH7                   _PTPRR.Bits.PTPRRH7
#define PTPRR_PTPRRL                    _PTPRR.MergedBits.grpPTPRRL
#define PTPRR_PTPRRH                    _PTPRR.MergedBits.grpPTPRRH

#define PTPRR_PTPRRL0_MASK              1U
#define PTPRR_PTPRRL1_MASK              2U
#define PTPRR_PTPRRL2_MASK              4U
#define PTPRR_PTPRRL3_MASK              8U
#define PTPRR_PTPRRH0_MASK              256U
#define PTPRR_PTPRRH1_MASK              512U
#define PTPRR_PTPRRH2_MASK              1024U
#define PTPRR_PTPRRH3_MASK              2048U
#define PTPRR_PTPRRH4_MASK              4096U
#define PTPRR_PTPRRH5_MASK              8192U
#define PTPRR_PTPRRH6_MASK              16384U
#define PTPRR_PTPRRH7_MASK              32768U
#define PTPRR_PTPRRL_MASK               15U
#define PTPRR_PTPRRL_BITNUM             0U
#define PTPRR_PTPRRH_MASK               65280U
#define PTPRR_PTPRRH_BITNUM             8U


/*** PTH - Port H Data Register; 0x00000260 ***/
typedef union {
  byte Byte;
  struct {
    byte PTH0        :1;                                       /* Port H general purpose input/output data bit 0 */
    byte PTH1        :1;                                       /* Port H general purpose input/output data bit 1 */
    byte PTH2        :1;                                       /* Port H general purpose input/output data bit 2 */
    byte PTH3        :1;                                       /* Port H general purpose input/output data bit 3 */
    byte PTH4        :1;                                       /* Port H general purpose input/output data bit 4 */
    byte PTH5        :1;                                       /* Port H general purpose input/output data bit 5 */
    byte PTH6        :1;                                       /* Port H general purpose input/output data bit 6 */
    byte PTH7        :1;                                       /* Port H general purpose input/output data bit 7 */
  } Bits;
} PTHSTR;
extern volatile PTHSTR _PTH @(REG_BASE + 0x00000260UL);
#define PTH                             _PTH.Byte
#define PTH_PTH0                        _PTH.Bits.PTH0
#define PTH_PTH1                        _PTH.Bits.PTH1
#define PTH_PTH2                        _PTH.Bits.PTH2
#define PTH_PTH3                        _PTH.Bits.PTH3
#define PTH_PTH4                        _PTH.Bits.PTH4
#define PTH_PTH5                        _PTH.Bits.PTH5
#define PTH_PTH6                        _PTH.Bits.PTH6
#define PTH_PTH7                        _PTH.Bits.PTH7

#define PTH_PTH0_MASK                   1U
#define PTH_PTH1_MASK                   2U
#define PTH_PTH2_MASK                   4U
#define PTH_PTH3_MASK                   8U
#define PTH_PTH4_MASK                   16U
#define PTH_PTH5_MASK                   32U
#define PTH_PTH6_MASK                   64U
#define PTH_PTH7_MASK                   128U


/*** PTIH - Port H Input Register; 0x00000261 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIH0       :1;                                       /* Port H input data bit 0 */
    byte PTIH1       :1;                                       /* Port H input data bit 1 */
    byte PTIH2       :1;                                       /* Port H input data bit 2 */
    byte PTIH3       :1;                                       /* Port H input data bit 3 */
    byte PTIH4       :1;                                       /* Port H input data bit 4 */
    byte PTIH5       :1;                                       /* Port H input data bit 5 */
    byte PTIH6       :1;                                       /* Port H input data bit 6 */
    byte PTIH7       :1;                                       /* Port H input data bit 7 */
  } Bits;
} PTIHSTR;
extern volatile PTIHSTR _PTIH @(REG_BASE + 0x00000261UL);
#define PTIH                            _PTIH.Byte
#define PTIH_PTIH0                      _PTIH.Bits.PTIH0
#define PTIH_PTIH1                      _PTIH.Bits.PTIH1
#define PTIH_PTIH2                      _PTIH.Bits.PTIH2
#define PTIH_PTIH3                      _PTIH.Bits.PTIH3
#define PTIH_PTIH4                      _PTIH.Bits.PTIH4
#define PTIH_PTIH5                      _PTIH.Bits.PTIH5
#define PTIH_PTIH6                      _PTIH.Bits.PTIH6
#define PTIH_PTIH7                      _PTIH.Bits.PTIH7

#define PTIH_PTIH0_MASK                 1U
#define PTIH_PTIH1_MASK                 2U
#define PTIH_PTIH2_MASK                 4U
#define PTIH_PTIH3_MASK                 8U
#define PTIH_PTIH4_MASK                 16U
#define PTIH_PTIH5_MASK                 32U
#define PTIH_PTIH6_MASK                 64U
#define PTIH_PTIH7_MASK                 128U


/*** DDRH - Port H Data Direction Register; 0x00000262 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRH0       :1;                                       /* Port H data direction bit 0 */
    byte DDRH1       :1;                                       /* Port H data direction bit 1 */
    byte DDRH2       :1;                                       /* Port H data direction bit 2 */
    byte DDRH3       :1;                                       /* Port H data direction bit 3 */
    byte DDRH4       :1;                                       /* Port H data direction bit 4 */
    byte DDRH5       :1;                                       /* Port H data direction bit 5 */
    byte DDRH6       :1;                                       /* Port H data direction bit 6 */
    byte DDRH7       :1;                                       /* Port H data direction bit 7 */
  } Bits;
} DDRHSTR;
extern volatile DDRHSTR _DDRH @(REG_BASE + 0x00000262UL);
#define DDRH                            _DDRH.Byte
#define DDRH_DDRH0                      _DDRH.Bits.DDRH0
#define DDRH_DDRH1                      _DDRH.Bits.DDRH1
#define DDRH_DDRH2                      _DDRH.Bits.DDRH2
#define DDRH_DDRH3                      _DDRH.Bits.DDRH3
#define DDRH_DDRH4                      _DDRH.Bits.DDRH4
#define DDRH_DDRH5                      _DDRH.Bits.DDRH5
#define DDRH_DDRH6                      _DDRH.Bits.DDRH6
#define DDRH_DDRH7                      _DDRH.Bits.DDRH7

#define DDRH_DDRH0_MASK                 1U
#define DDRH_DDRH1_MASK                 2U
#define DDRH_DDRH2_MASK                 4U
#define DDRH_DDRH3_MASK                 8U
#define DDRH_DDRH4_MASK                 16U
#define DDRH_DDRH5_MASK                 32U
#define DDRH_DDRH6_MASK                 64U
#define DDRH_DDRH7_MASK                 128U


/*** PERH - Port H Pull Device Enable Register; 0x00000264 ***/
typedef union {
  byte Byte;
  struct {
    byte PERH0       :1;                                       /* Port H pull device enable bit 0 */
    byte PERH1       :1;                                       /* Port H pull device enable bit 1 */
    byte PERH2       :1;                                       /* Port H pull device enable bit 2 */
    byte PERH3       :1;                                       /* Port H pull device enable bit 3 */
    byte PERH4       :1;                                       /* Port H pull device enable bit 4 */
    byte PERH5       :1;                                       /* Port H pull device enable bit 5 */
    byte PERH6       :1;                                       /* Port H pull device enable bit 6 */
    byte PERH7       :1;                                       /* Port H pull device enable bit 7 */
  } Bits;
} PERHSTR;
extern volatile PERHSTR _PERH @(REG_BASE + 0x00000264UL);
#define PERH                            _PERH.Byte
#define PERH_PERH0                      _PERH.Bits.PERH0
#define PERH_PERH1                      _PERH.Bits.PERH1
#define PERH_PERH2                      _PERH.Bits.PERH2
#define PERH_PERH3                      _PERH.Bits.PERH3
#define PERH_PERH4                      _PERH.Bits.PERH4
#define PERH_PERH5                      _PERH.Bits.PERH5
#define PERH_PERH6                      _PERH.Bits.PERH6
#define PERH_PERH7                      _PERH.Bits.PERH7

#define PERH_PERH0_MASK                 1U
#define PERH_PERH1_MASK                 2U
#define PERH_PERH2_MASK                 4U
#define PERH_PERH3_MASK                 8U
#define PERH_PERH4_MASK                 16U
#define PERH_PERH5_MASK                 32U
#define PERH_PERH6_MASK                 64U
#define PERH_PERH7_MASK                 128U


/*** PPSH - Port H Polarity Select Register; 0x00000265 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSH0       :1;                                       /* Port H pull device select bit 0 */
    byte PPSH1       :1;                                       /* Port H pull device select bit 1 */
    byte PPSH2       :1;                                       /* Port H pull device select bit 2 */
    byte PPSH3       :1;                                       /* Port H pull device select bit 3 */
    byte PPSH4       :1;                                       /* Port H pull device select bit 4 */
    byte PPSH5       :1;                                       /* Port H pull device select bit 5 */
    byte PPSH6       :1;                                       /* Port H pull device select bit 6 */
    byte PPSH7       :1;                                       /* Port H pull device select bit 7 */
  } Bits;
} PPSHSTR;
extern volatile PPSHSTR _PPSH @(REG_BASE + 0x00000265UL);
#define PPSH                            _PPSH.Byte
#define PPSH_PPSH0                      _PPSH.Bits.PPSH0
#define PPSH_PPSH1                      _PPSH.Bits.PPSH1
#define PPSH_PPSH2                      _PPSH.Bits.PPSH2
#define PPSH_PPSH3                      _PPSH.Bits.PPSH3
#define PPSH_PPSH4                      _PPSH.Bits.PPSH4
#define PPSH_PPSH5                      _PPSH.Bits.PPSH5
#define PPSH_PPSH6                      _PPSH.Bits.PPSH6
#define PPSH_PPSH7                      _PPSH.Bits.PPSH7

#define PPSH_PPSH0_MASK                 1U
#define PPSH_PPSH1_MASK                 2U
#define PPSH_PPSH2_MASK                 4U
#define PPSH_PPSH3_MASK                 8U
#define PPSH_PPSH4_MASK                 16U
#define PPSH_PPSH5_MASK                 32U
#define PPSH_PPSH6_MASK                 64U
#define PPSH_PPSH7_MASK                 128U


/*** WOMH - Port H Wired-Or Mode Register; 0x00000266 ***/
typedef union {
  byte Byte;
  struct {
    byte WOMH0       :1;                                       /* Port H wired-or mode bit 0 */
    byte WOMH1       :1;                                       /* Port H wired-or mode bit 1 */
    byte WOMH2       :1;                                       /* Port H wired-or mode bit 2 */
    byte WOMH3       :1;                                       /* Port H wired-or mode bit 3 */
    byte WOMH4       :1;                                       /* Port H wired-or mode bit 4 */
    byte WOMH5       :1;                                       /* Port H wired-or mode bit 5 */
    byte WOMH6       :1;                                       /* Port H wired-or mode bit 6 */
    byte WOMH7       :1;                                       /* Port H wired-or mode bit 7 */
  } Bits;
} WOMHSTR;
extern volatile WOMHSTR _WOMH @(REG_BASE + 0x00000266UL);
#define WOMH                            _WOMH.Byte
#define WOMH_WOMH0                      _WOMH.Bits.WOMH0
#define WOMH_WOMH1                      _WOMH.Bits.WOMH1
#define WOMH_WOMH2                      _WOMH.Bits.WOMH2
#define WOMH_WOMH3                      _WOMH.Bits.WOMH3
#define WOMH_WOMH4                      _WOMH.Bits.WOMH4
#define WOMH_WOMH5                      _WOMH.Bits.WOMH5
#define WOMH_WOMH6                      _WOMH.Bits.WOMH6
#define WOMH_WOMH7                      _WOMH.Bits.WOMH7

#define WOMH_WOMH0_MASK                 1U
#define WOMH_WOMH1_MASK                 2U
#define WOMH_WOMH2_MASK                 4U
#define WOMH_WOMH3_MASK                 8U
#define WOMH_WOMH4_MASK                 16U
#define WOMH_WOMH5_MASK                 32U
#define WOMH_WOMH6_MASK                 64U
#define WOMH_WOMH7_MASK                 128U


/*** PTHRR - Port H Routing Register; 0x00000267 ***/
typedef union {
  byte Byte;
  struct {
    byte PTHRR0      :1;                                       /* Port H  routing */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PTHRRSTR;
extern volatile PTHRRSTR _PTHRR @(REG_BASE + 0x00000267UL);
#define PTHRR                           _PTHRR.Byte
#define PTHRR_PTHRR0                    _PTHRR.Bits.PTHRR0

#define PTHRR_PTHRR0_MASK               1U


/*** PT01AD - Port AD Data Register; 0x00000270 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PT0AD - Port ADH Data Register; 0x00000270 ***/
    union {
      byte Byte;
      struct {
        byte PT0AD0      :1;                                       /* Port AD data bit 0 */
        byte PT0AD1      :1;                                       /* Port AD data bit 1 */
        byte PT0AD2      :1;                                       /* Port AD data bit 2 */
        byte PT0AD3      :1;                                       /* Port AD data bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpPT0AD :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } PT0ADSTR;
    #define PT0AD                       _PT01AD.Overlap_STR.PT0ADSTR.Byte
    #define PT0AD_PT0AD0                _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD0
    #define PT0AD_PT0AD1                _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD1
    #define PT0AD_PT0AD2                _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD2
    #define PT0AD_PT0AD3                _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD3
    #define PT0AD_PT0AD                 _PT01AD.Overlap_STR.PT0ADSTR.MergedBits.grpPT0AD
    
    #define PT0AD_PT0AD0_MASK           1U
    #define PT0AD_PT0AD1_MASK           2U
    #define PT0AD_PT0AD2_MASK           4U
    #define PT0AD_PT0AD3_MASK           8U
    #define PT0AD_PT0AD_MASK            15U
    #define PT0AD_PT0AD_BITNUM          0U
    

    /*** PT1AD - Port ADL Data Register; 0x00000271 ***/
    union {
      byte Byte;
      struct {
        byte PT1AD0      :1;                                       /* Port AD data bit 0 */
        byte PT1AD1      :1;                                       /* Port AD data bit 1 */
        byte PT1AD2      :1;                                       /* Port AD data bit 2 */
        byte PT1AD3      :1;                                       /* Port AD data bit 3 */
        byte PT1AD4      :1;                                       /* Port AD data bit 4 */
        byte PT1AD5      :1;                                       /* Port AD data bit 5 */
        byte PT1AD6      :1;                                       /* Port AD data bit 6 */
        byte PT1AD7      :1;                                       /* Port AD data bit 7 */
      } Bits;
    } PT1ADSTR;
    #define PT1AD                       _PT01AD.Overlap_STR.PT1ADSTR.Byte
    #define PT1AD_PT1AD0                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD0
    #define PT1AD_PT1AD1                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD1
    #define PT1AD_PT1AD2                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD2
    #define PT1AD_PT1AD3                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD3
    #define PT1AD_PT1AD4                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD4
    #define PT1AD_PT1AD5                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD5
    #define PT1AD_PT1AD6                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD6
    #define PT1AD_PT1AD7                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD7
    
    #define PT1AD_PT1AD0_MASK           1U
    #define PT1AD_PT1AD1_MASK           2U
    #define PT1AD_PT1AD2_MASK           4U
    #define PT1AD_PT1AD3_MASK           8U
    #define PT1AD_PT1AD4_MASK           16U
    #define PT1AD_PT1AD5_MASK           32U
    #define PT1AD_PT1AD6_MASK           64U
    #define PT1AD_PT1AD7_MASK           128U
    
  } Overlap_STR;

  struct {
    word PT1AD0      :1;                                       /* Port AD data bit 0 */
    word PT1AD1      :1;                                       /* Port AD data bit 1 */
    word PT1AD2      :1;                                       /* Port AD data bit 2 */
    word PT1AD3      :1;                                       /* Port AD data bit 3 */
    word PT1AD4      :1;                                       /* Port AD data bit 4 */
    word PT1AD5      :1;                                       /* Port AD data bit 5 */
    word PT1AD6      :1;                                       /* Port AD data bit 6 */
    word PT1AD7      :1;                                       /* Port AD data bit 7 */
    word PT0AD0      :1;                                       /* Port AD data bit 8 */
    word PT0AD1      :1;                                       /* Port AD data bit 9 */
    word PT0AD2      :1;                                       /* Port AD data bit 10 */
    word PT0AD3      :1;                                       /* Port AD data bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpPT1AD :8;
    word grpPT0AD :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} PT01ADSTR;
extern volatile PT01ADSTR _PT01AD @(REG_BASE + 0x00000270UL);
#define PT01AD                          _PT01AD.Word
#define PT01AD_PT1AD0                   _PT01AD.Bits.PT1AD0
#define PT01AD_PT1AD1                   _PT01AD.Bits.PT1AD1
#define PT01AD_PT1AD2                   _PT01AD.Bits.PT1AD2
#define PT01AD_PT1AD3                   _PT01AD.Bits.PT1AD3
#define PT01AD_PT1AD4                   _PT01AD.Bits.PT1AD4
#define PT01AD_PT1AD5                   _PT01AD.Bits.PT1AD5
#define PT01AD_PT1AD6                   _PT01AD.Bits.PT1AD6
#define PT01AD_PT1AD7                   _PT01AD.Bits.PT1AD7
#define PT01AD_PT0AD0                   _PT01AD.Bits.PT0AD0
#define PT01AD_PT0AD1                   _PT01AD.Bits.PT0AD1
#define PT01AD_PT0AD2                   _PT01AD.Bits.PT0AD2
#define PT01AD_PT0AD3                   _PT01AD.Bits.PT0AD3
#define PT01AD_PT1AD                    _PT01AD.MergedBits.grpPT1AD
#define PT01AD_PT0AD                    _PT01AD.MergedBits.grpPT0AD

#define PT01AD_PT1AD0_MASK              1U
#define PT01AD_PT1AD1_MASK              2U
#define PT01AD_PT1AD2_MASK              4U
#define PT01AD_PT1AD3_MASK              8U
#define PT01AD_PT1AD4_MASK              16U
#define PT01AD_PT1AD5_MASK              32U
#define PT01AD_PT1AD6_MASK              64U
#define PT01AD_PT1AD7_MASK              128U
#define PT01AD_PT0AD0_MASK              256U
#define PT01AD_PT0AD1_MASK              512U
#define PT01AD_PT0AD2_MASK              1024U
#define PT01AD_PT0AD3_MASK              2048U
#define PT01AD_PT1AD_MASK               255U
#define PT01AD_PT1AD_BITNUM             0U
#define PT01AD_PT0AD_MASK               3840U
#define PT01AD_PT0AD_BITNUM             8U


/*** DDR01AD - Port AD Data Direction Register; 0x00000272 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDR0AD - Port ADH Data Direction Register; 0x00000272 ***/
    union {
      byte Byte;
      struct {
        byte DDR0AD0     :1;                                       /* Port AD data direction bit 0 */
        byte DDR0AD1     :1;                                       /* Port AD data direction bit 1 */
        byte DDR0AD2     :1;                                       /* Port AD data direction bit 2 */
        byte DDR0AD3     :1;                                       /* Port AD data direction bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpDDR0AD :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DDR0ADSTR;
    #define DDR0AD                      _DDR01AD.Overlap_STR.DDR0ADSTR.Byte
    #define DDR0AD_DDR0AD0              _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD0
    #define DDR0AD_DDR0AD1              _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD1
    #define DDR0AD_DDR0AD2              _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD2
    #define DDR0AD_DDR0AD3              _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD3
    #define DDR0AD_DDR0AD               _DDR01AD.Overlap_STR.DDR0ADSTR.MergedBits.grpDDR0AD
    
    #define DDR0AD_DDR0AD0_MASK         1U
    #define DDR0AD_DDR0AD1_MASK         2U
    #define DDR0AD_DDR0AD2_MASK         4U
    #define DDR0AD_DDR0AD3_MASK         8U
    #define DDR0AD_DDR0AD_MASK          15U
    #define DDR0AD_DDR0AD_BITNUM        0U
    

    /*** DDR1AD - Port ADL Data Direction Register; 0x00000273 ***/
    union {
      byte Byte;
      struct {
        byte DDR1AD0     :1;                                       /* Port AD data direction bit 0 */
        byte DDR1AD1     :1;                                       /* Port AD data direction bit 1 */
        byte DDR1AD2     :1;                                       /* Port AD data direction bit 2 */
        byte DDR1AD3     :1;                                       /* Port AD data direction bit 3 */
        byte DDR1AD4     :1;                                       /* Port AD data direction bit 4 */
        byte DDR1AD5     :1;                                       /* Port AD data direction bit 5 */
        byte DDR1AD6     :1;                                       /* Port AD data direction bit 6 */
        byte DDR1AD7     :1;                                       /* Port AD data direction bit 7 */
      } Bits;
    } DDR1ADSTR;
    #define DDR1AD                      _DDR01AD.Overlap_STR.DDR1ADSTR.Byte
    #define DDR1AD_DDR1AD0              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD0
    #define DDR1AD_DDR1AD1              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD1
    #define DDR1AD_DDR1AD2              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD2
    #define DDR1AD_DDR1AD3              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD3
    #define DDR1AD_DDR1AD4              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD4
    #define DDR1AD_DDR1AD5              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD5
    #define DDR1AD_DDR1AD6              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD6
    #define DDR1AD_DDR1AD7              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD7
    
    #define DDR1AD_DDR1AD0_MASK         1U
    #define DDR1AD_DDR1AD1_MASK         2U
    #define DDR1AD_DDR1AD2_MASK         4U
    #define DDR1AD_DDR1AD3_MASK         8U
    #define DDR1AD_DDR1AD4_MASK         16U
    #define DDR1AD_DDR1AD5_MASK         32U
    #define DDR1AD_DDR1AD6_MASK         64U
    #define DDR1AD_DDR1AD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word DDR1AD0     :1;                                       /* Port AD data direction bit 0 */
    word DDR1AD1     :1;                                       /* Port AD data direction bit 1 */
    word DDR1AD2     :1;                                       /* Port AD data direction bit 2 */
    word DDR1AD3     :1;                                       /* Port AD data direction bit 3 */
    word DDR1AD4     :1;                                       /* Port AD data direction bit 4 */
    word DDR1AD5     :1;                                       /* Port AD data direction bit 5 */
    word DDR1AD6     :1;                                       /* Port AD data direction bit 6 */
    word DDR1AD7     :1;                                       /* Port AD data direction bit 7 */
    word DDR0AD0     :1;                                       /* Port AD data direction bit 8 */
    word DDR0AD1     :1;                                       /* Port AD data direction bit 9 */
    word DDR0AD2     :1;                                       /* Port AD data direction bit 10 */
    word DDR0AD3     :1;                                       /* Port AD data direction bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpDDR1AD :8;
    word grpDDR0AD :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} DDR01ADSTR;
extern volatile DDR01ADSTR _DDR01AD @(REG_BASE + 0x00000272UL);
#define DDR01AD                         _DDR01AD.Word
#define DDR01AD_DDR1AD0                 _DDR01AD.Bits.DDR1AD0
#define DDR01AD_DDR1AD1                 _DDR01AD.Bits.DDR1AD1
#define DDR01AD_DDR1AD2                 _DDR01AD.Bits.DDR1AD2
#define DDR01AD_DDR1AD3                 _DDR01AD.Bits.DDR1AD3
#define DDR01AD_DDR1AD4                 _DDR01AD.Bits.DDR1AD4
#define DDR01AD_DDR1AD5                 _DDR01AD.Bits.DDR1AD5
#define DDR01AD_DDR1AD6                 _DDR01AD.Bits.DDR1AD6
#define DDR01AD_DDR1AD7                 _DDR01AD.Bits.DDR1AD7
#define DDR01AD_DDR0AD0                 _DDR01AD.Bits.DDR0AD0
#define DDR01AD_DDR0AD1                 _DDR01AD.Bits.DDR0AD1
#define DDR01AD_DDR0AD2                 _DDR01AD.Bits.DDR0AD2
#define DDR01AD_DDR0AD3                 _DDR01AD.Bits.DDR0AD3
#define DDR01AD_DDR1AD                  _DDR01AD.MergedBits.grpDDR1AD
#define DDR01AD_DDR0AD                  _DDR01AD.MergedBits.grpDDR0AD

#define DDR01AD_DDR1AD0_MASK            1U
#define DDR01AD_DDR1AD1_MASK            2U
#define DDR01AD_DDR1AD2_MASK            4U
#define DDR01AD_DDR1AD3_MASK            8U
#define DDR01AD_DDR1AD4_MASK            16U
#define DDR01AD_DDR1AD5_MASK            32U
#define DDR01AD_DDR1AD6_MASK            64U
#define DDR01AD_DDR1AD7_MASK            128U
#define DDR01AD_DDR0AD0_MASK            256U
#define DDR01AD_DDR0AD1_MASK            512U
#define DDR01AD_DDR0AD2_MASK            1024U
#define DDR01AD_DDR0AD3_MASK            2048U
#define DDR01AD_DDR1AD_MASK             255U
#define DDR01AD_DDR1AD_BITNUM           0U
#define DDR01AD_DDR0AD_MASK             3840U
#define DDR01AD_DDR0AD_BITNUM           8U


/*** PER01AD - Port AD Pull Up Enable Register; 0x00000276 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PER0AD - Port ADH Pull Up Enable Register; 0x00000276 ***/
    union {
      byte Byte;
      struct {
        byte PER0AD0     :1;                                       /* Port ADH pull up enable bit 0 */
        byte PER0AD1     :1;                                       /* Port ADH pull up enable bit 1 */
        byte PER0AD2     :1;                                       /* Port ADH pull up enable bit 2 */
        byte PER0AD3     :1;                                       /* Port ADH pull up enable bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpPER0AD :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } PER0ADSTR;
    #define PER0AD                      _PER01AD.Overlap_STR.PER0ADSTR.Byte
    #define PER0AD_PER0AD0              _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD0
    #define PER0AD_PER0AD1              _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD1
    #define PER0AD_PER0AD2              _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD2
    #define PER0AD_PER0AD3              _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD3
    #define PER0AD_PER0AD               _PER01AD.Overlap_STR.PER0ADSTR.MergedBits.grpPER0AD
    
    #define PER0AD_PER0AD0_MASK         1U
    #define PER0AD_PER0AD1_MASK         2U
    #define PER0AD_PER0AD2_MASK         4U
    #define PER0AD_PER0AD3_MASK         8U
    #define PER0AD_PER0AD_MASK          15U
    #define PER0AD_PER0AD_BITNUM        0U
    

    /*** PER1AD - Port ADL Pull Up Enable Register; 0x00000277 ***/
    union {
      byte Byte;
      struct {
        byte PER1AD0     :1;                                       /* Port ADL pull up enable bit 0 */
        byte PER1AD1     :1;                                       /* Port ADL pull up enable bit 1 */
        byte PER1AD2     :1;                                       /* Port ADL pull up enable bit 2 */
        byte PER1AD3     :1;                                       /* Port ADL pull up enable bit 3 */
        byte PER1AD4     :1;                                       /* Port ADL pull up enable bit 4 */
        byte PER1AD5     :1;                                       /* Port ADL pull up enable bit 5 */
        byte PER1AD6     :1;                                       /* Port ADL pull up enable bit 6 */
        byte PER1AD7     :1;                                       /* Port ADL pull up enable bit 7 */
      } Bits;
    } PER1ADSTR;
    #define PER1AD                      _PER01AD.Overlap_STR.PER1ADSTR.Byte
    #define PER1AD_PER1AD0              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD0
    #define PER1AD_PER1AD1              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD1
    #define PER1AD_PER1AD2              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD2
    #define PER1AD_PER1AD3              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD3
    #define PER1AD_PER1AD4              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD4
    #define PER1AD_PER1AD5              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD5
    #define PER1AD_PER1AD6              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD6
    #define PER1AD_PER1AD7              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD7
    
    #define PER1AD_PER1AD0_MASK         1U
    #define PER1AD_PER1AD1_MASK         2U
    #define PER1AD_PER1AD2_MASK         4U
    #define PER1AD_PER1AD3_MASK         8U
    #define PER1AD_PER1AD4_MASK         16U
    #define PER1AD_PER1AD5_MASK         32U
    #define PER1AD_PER1AD6_MASK         64U
    #define PER1AD_PER1AD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word PER1AD0     :1;                                       /* Port AD pull up enable bit 0 */
    word PER1AD1     :1;                                       /* Port AD pull up enable bit 1 */
    word PER1AD2     :1;                                       /* Port AD pull up enable bit 2 */
    word PER1AD3     :1;                                       /* Port AD pull up enable bit 3 */
    word PER1AD4     :1;                                       /* Port AD pull up enable bit 4 */
    word PER1AD5     :1;                                       /* Port AD pull up enable bit 5 */
    word PER1AD6     :1;                                       /* Port AD pull up enable bit 6 */
    word PER1AD7     :1;                                       /* Port AD pull up enable bit 7 */
    word PER0AD0     :1;                                       /* Port AD pull up enable bit 8 */
    word PER0AD1     :1;                                       /* Port AD pull up enable bit 9 */
    word PER0AD2     :1;                                       /* Port AD pull up enable bit 10 */
    word PER0AD3     :1;                                       /* Port AD pull up enable bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpPER1AD :8;
    word grpPER0AD :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} PER01ADSTR;
extern volatile PER01ADSTR _PER01AD @(REG_BASE + 0x00000276UL);
#define PER01AD                         _PER01AD.Word
#define PER01AD_PER1AD0                 _PER01AD.Bits.PER1AD0
#define PER01AD_PER1AD1                 _PER01AD.Bits.PER1AD1
#define PER01AD_PER1AD2                 _PER01AD.Bits.PER1AD2
#define PER01AD_PER1AD3                 _PER01AD.Bits.PER1AD3
#define PER01AD_PER1AD4                 _PER01AD.Bits.PER1AD4
#define PER01AD_PER1AD5                 _PER01AD.Bits.PER1AD5
#define PER01AD_PER1AD6                 _PER01AD.Bits.PER1AD6
#define PER01AD_PER1AD7                 _PER01AD.Bits.PER1AD7
#define PER01AD_PER0AD0                 _PER01AD.Bits.PER0AD0
#define PER01AD_PER0AD1                 _PER01AD.Bits.PER0AD1
#define PER01AD_PER0AD2                 _PER01AD.Bits.PER0AD2
#define PER01AD_PER0AD3                 _PER01AD.Bits.PER0AD3
#define PER01AD_PER1AD                  _PER01AD.MergedBits.grpPER1AD
#define PER01AD_PER0AD                  _PER01AD.MergedBits.grpPER0AD

#define PER01AD_PER1AD0_MASK            1U
#define PER01AD_PER1AD1_MASK            2U
#define PER01AD_PER1AD2_MASK            4U
#define PER01AD_PER1AD3_MASK            8U
#define PER01AD_PER1AD4_MASK            16U
#define PER01AD_PER1AD5_MASK            32U
#define PER01AD_PER1AD6_MASK            64U
#define PER01AD_PER1AD7_MASK            128U
#define PER01AD_PER0AD0_MASK            256U
#define PER01AD_PER0AD1_MASK            512U
#define PER01AD_PER0AD2_MASK            1024U
#define PER01AD_PER0AD3_MASK            2048U
#define PER01AD_PER1AD_MASK             255U
#define PER01AD_PER1AD_BITNUM           0U
#define PER01AD_PER0AD_MASK             3840U
#define PER01AD_PER0AD_BITNUM           8U


/*** PTR - Port R Data Register; 0x00000280 ***/
typedef union {
  byte Byte;
  struct {
    byte PTR0        :1;                                       /* Port R general purpose input/output data bit 0 */
    byte PTR1        :1;                                       /* Port R general purpose input/output data bit 1 */
    byte PTR2        :1;                                       /* Port R general purpose input/output data bit 2 */
    byte PTR3        :1;                                       /* Port R general purpose input/output data bit 3 */
    byte PTR4        :1;                                       /* Port R general purpose input/output data bit 4 */
    byte PTR5        :1;                                       /* Port R general purpose input/output data bit 5 */
    byte PTR6        :1;                                       /* Port R general purpose input/output data bit 6 */
    byte PTR7        :1;                                       /* Port R general purpose input/output data bit 7 */
  } Bits;
} PTRSTR;
extern volatile PTRSTR _PTR @(REG_BASE + 0x00000280UL);
#define PTR                             _PTR.Byte
#define PTR_PTR0                        _PTR.Bits.PTR0
#define PTR_PTR1                        _PTR.Bits.PTR1
#define PTR_PTR2                        _PTR.Bits.PTR2
#define PTR_PTR3                        _PTR.Bits.PTR3
#define PTR_PTR4                        _PTR.Bits.PTR4
#define PTR_PTR5                        _PTR.Bits.PTR5
#define PTR_PTR6                        _PTR.Bits.PTR6
#define PTR_PTR7                        _PTR.Bits.PTR7

#define PTR_PTR0_MASK                   1U
#define PTR_PTR1_MASK                   2U
#define PTR_PTR2_MASK                   4U
#define PTR_PTR3_MASK                   8U
#define PTR_PTR4_MASK                   16U
#define PTR_PTR5_MASK                   32U
#define PTR_PTR6_MASK                   64U
#define PTR_PTR7_MASK                   128U


/*** PTIR - Port R Input Register; 0x00000281 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIR0       :1;                                       /* Port R input data bit 0 */
    byte PTIR1       :1;                                       /* Port R input data bit 1 */
    byte PTIR2       :1;                                       /* Port R input data bit 2 */
    byte PTIR3       :1;                                       /* Port R input data bit 3 */
    byte PTIR4       :1;                                       /* Port R input data bit 4 */
    byte PTIR5       :1;                                       /* Port R input data bit 5 */
    byte PTIR6       :1;                                       /* Port R input data bit 6 */
    byte PTIR7       :1;                                       /* Port R input data bit 7 */
  } Bits;
} PTIRSTR;
extern volatile PTIRSTR _PTIR @(REG_BASE + 0x00000281UL);
#define PTIR                            _PTIR.Byte
#define PTIR_PTIR0                      _PTIR.Bits.PTIR0
#define PTIR_PTIR1                      _PTIR.Bits.PTIR1
#define PTIR_PTIR2                      _PTIR.Bits.PTIR2
#define PTIR_PTIR3                      _PTIR.Bits.PTIR3
#define PTIR_PTIR4                      _PTIR.Bits.PTIR4
#define PTIR_PTIR5                      _PTIR.Bits.PTIR5
#define PTIR_PTIR6                      _PTIR.Bits.PTIR6
#define PTIR_PTIR7                      _PTIR.Bits.PTIR7

#define PTIR_PTIR0_MASK                 1U
#define PTIR_PTIR1_MASK                 2U
#define PTIR_PTIR2_MASK                 4U
#define PTIR_PTIR3_MASK                 8U
#define PTIR_PTIR4_MASK                 16U
#define PTIR_PTIR5_MASK                 32U
#define PTIR_PTIR6_MASK                 64U
#define PTIR_PTIR7_MASK                 128U


/*** DDRR - Port R Data Direction Register; 0x00000282 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRR0       :1;                                       /* Port R data direction bit 0 */
    byte DDRR1       :1;                                       /* Port R data direction bit 1 */
    byte DDRR2       :1;                                       /* Port R data direction bit 2 */
    byte DDRR3       :1;                                       /* Port R data direction bit 3 */
    byte DDRR4       :1;                                       /* Port R data direction bit 4 */
    byte DDRR5       :1;                                       /* Port R data direction bit 5 */
    byte DDRR6       :1;                                       /* Port R data direction bit 6 */
    byte DDRR7       :1;                                       /* Port R data direction bit 7 */
  } Bits;
} DDRRSTR;
extern volatile DDRRSTR _DDRR @(REG_BASE + 0x00000282UL);
#define DDRR                            _DDRR.Byte
#define DDRR_DDRR0                      _DDRR.Bits.DDRR0
#define DDRR_DDRR1                      _DDRR.Bits.DDRR1
#define DDRR_DDRR2                      _DDRR.Bits.DDRR2
#define DDRR_DDRR3                      _DDRR.Bits.DDRR3
#define DDRR_DDRR4                      _DDRR.Bits.DDRR4
#define DDRR_DDRR5                      _DDRR.Bits.DDRR5
#define DDRR_DDRR6                      _DDRR.Bits.DDRR6
#define DDRR_DDRR7                      _DDRR.Bits.DDRR7

#define DDRR_DDRR0_MASK                 1U
#define DDRR_DDRR1_MASK                 2U
#define DDRR_DDRR2_MASK                 4U
#define DDRR_DDRR3_MASK                 8U
#define DDRR_DDRR4_MASK                 16U
#define DDRR_DDRR5_MASK                 32U
#define DDRR_DDRR6_MASK                 64U
#define DDRR_DDRR7_MASK                 128U


/*** PERR - Port R Pull Device Enable Register; 0x00000284 ***/
typedef union {
  byte Byte;
  struct {
    byte PERR0       :1;                                       /* Port R pull device enable bit 0 */
    byte PERR1       :1;                                       /* Port R pull device enable bit 1 */
    byte PERR2       :1;                                       /* Port R pull device enable bit 2 */
    byte PERR3       :1;                                       /* Port R pull device enable bit 3 */
    byte PERR4       :1;                                       /* Port R pull device enable bit 4 */
    byte PERR5       :1;                                       /* Port R pull device enable bit 5 */
    byte PERR6       :1;                                       /* Port R pull device enable bit 6 */
    byte PERR7       :1;                                       /* Port R pull device enable bit 7 */
  } Bits;
} PERRSTR;
extern volatile PERRSTR _PERR @(REG_BASE + 0x00000284UL);
#define PERR                            _PERR.Byte
#define PERR_PERR0                      _PERR.Bits.PERR0
#define PERR_PERR1                      _PERR.Bits.PERR1
#define PERR_PERR2                      _PERR.Bits.PERR2
#define PERR_PERR3                      _PERR.Bits.PERR3
#define PERR_PERR4                      _PERR.Bits.PERR4
#define PERR_PERR5                      _PERR.Bits.PERR5
#define PERR_PERR6                      _PERR.Bits.PERR6
#define PERR_PERR7                      _PERR.Bits.PERR7

#define PERR_PERR0_MASK                 1U
#define PERR_PERR1_MASK                 2U
#define PERR_PERR2_MASK                 4U
#define PERR_PERR3_MASK                 8U
#define PERR_PERR4_MASK                 16U
#define PERR_PERR5_MASK                 32U
#define PERR_PERR6_MASK                 64U
#define PERR_PERR7_MASK                 128U


/*** PPSR - Port R Polarity Select Register; 0x00000285 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSR0       :1;                                       /* Port R pull device select bit 0 */
    byte PPSR1       :1;                                       /* Port R pull device select bit 1 */
    byte PPSR2       :1;                                       /* Port R pull device select bit 2 */
    byte PPSR3       :1;                                       /* Port R pull device select bit 3 */
    byte PPSR4       :1;                                       /* Port R pull device select bit 4 */
    byte PPSR5       :1;                                       /* Port R pull device select bit 5 */
    byte PPSR6       :1;                                       /* Port R pull device select bit 6 */
    byte PPSR7       :1;                                       /* Port R pull device select bit 7 */
  } Bits;
} PPSRSTR;
extern volatile PPSRSTR _PPSR @(REG_BASE + 0x00000285UL);
#define PPSR                            _PPSR.Byte
#define PPSR_PPSR0                      _PPSR.Bits.PPSR0
#define PPSR_PPSR1                      _PPSR.Bits.PPSR1
#define PPSR_PPSR2                      _PPSR.Bits.PPSR2
#define PPSR_PPSR3                      _PPSR.Bits.PPSR3
#define PPSR_PPSR4                      _PPSR.Bits.PPSR4
#define PPSR_PPSR5                      _PPSR.Bits.PPSR5
#define PPSR_PPSR6                      _PPSR.Bits.PPSR6
#define PPSR_PPSR7                      _PPSR.Bits.PPSR7

#define PPSR_PPSR0_MASK                 1U
#define PPSR_PPSR1_MASK                 2U
#define PPSR_PPSR2_MASK                 4U
#define PPSR_PPSR3_MASK                 8U
#define PPSR_PPSR4_MASK                 16U
#define PPSR_PPSR5_MASK                 32U
#define PPSR_PPSR6_MASK                 64U
#define PPSR_PPSR7_MASK                 128U


/*** WOMR - Port R Wired-Or Mode Register; 0x00000286 ***/
typedef union {
  byte Byte;
  struct {
    byte WOMR0       :1;                                       /* Port R wired-or mode bit 0 */
    byte WOMR1       :1;                                       /* Port R wired-or mode bit 1 */
    byte WOMR2       :1;                                       /* Port R wired-or mode bit 2 */
    byte WOMR3       :1;                                       /* Port R wired-or mode bit 3 */
    byte WOMR4       :1;                                       /* Port R wired-or mode bit 4 */
    byte WOMR5       :1;                                       /* Port R wired-or mode bit 5 */
    byte WOMR6       :1;                                       /* Port R wired-or mode bit 6 */
    byte WOMR7       :1;                                       /* Port R wired-or mode bit 7 */
  } Bits;
} WOMRSTR;
extern volatile WOMRSTR _WOMR @(REG_BASE + 0x00000286UL);
#define WOMR                            _WOMR.Byte
#define WOMR_WOMR0                      _WOMR.Bits.WOMR0
#define WOMR_WOMR1                      _WOMR.Bits.WOMR1
#define WOMR_WOMR2                      _WOMR.Bits.WOMR2
#define WOMR_WOMR3                      _WOMR.Bits.WOMR3
#define WOMR_WOMR4                      _WOMR.Bits.WOMR4
#define WOMR_WOMR5                      _WOMR.Bits.WOMR5
#define WOMR_WOMR6                      _WOMR.Bits.WOMR6
#define WOMR_WOMR7                      _WOMR.Bits.WOMR7

#define WOMR_WOMR0_MASK                 1U
#define WOMR_WOMR1_MASK                 2U
#define WOMR_WOMR2_MASK                 4U
#define WOMR_WOMR3_MASK                 8U
#define WOMR_WOMR4_MASK                 16U
#define WOMR_WOMR5_MASK                 32U
#define WOMR_WOMR6_MASK                 64U
#define WOMR_WOMR7_MASK                 128U


/*** PIET - Port T Interrupt Enable Register; 0x00000288 ***/
typedef union {
  byte Byte;
  struct {
    byte PIET0       :1;                                       /* Port T interrupt enable bit 0 */
    byte PIET1       :1;                                       /* Port T interrupt enable bit 1 */
    byte PIET2       :1;                                       /* Port T interrupt enable bit 2 */
    byte PIET3       :1;                                       /* Port T interrupt enable bit 3 */
    byte PIET4       :1;                                       /* Port T interrupt enable bit 4 */
    byte PIET5       :1;                                       /* Port T interrupt enable bit 5 */
    byte PIET6       :1;                                       /* Port T interrupt enable bit 6 */
    byte PIET7       :1;                                       /* Port T interrupt enable bit 7 */
  } Bits;
} PIETSTR;
extern volatile PIETSTR _PIET @(REG_BASE + 0x00000288UL);
#define PIET                            _PIET.Byte
#define PIET_PIET0                      _PIET.Bits.PIET0
#define PIET_PIET1                      _PIET.Bits.PIET1
#define PIET_PIET2                      _PIET.Bits.PIET2
#define PIET_PIET3                      _PIET.Bits.PIET3
#define PIET_PIET4                      _PIET.Bits.PIET4
#define PIET_PIET5                      _PIET.Bits.PIET5
#define PIET_PIET6                      _PIET.Bits.PIET6
#define PIET_PIET7                      _PIET.Bits.PIET7

#define PIET_PIET0_MASK                 1U
#define PIET_PIET1_MASK                 2U
#define PIET_PIET2_MASK                 4U
#define PIET_PIET3_MASK                 8U
#define PIET_PIET4_MASK                 16U
#define PIET_PIET5_MASK                 32U
#define PIET_PIET6_MASK                 64U
#define PIET_PIET7_MASK                 128U


/*** PIFT - Port T Interrupt Flag Register; 0x00000289 ***/
typedef union {
  byte Byte;
  struct {
    byte PIFT0       :1;                                       /* Port T interrupt flag bit 0 */
    byte PIFT1       :1;                                       /* Port T interrupt flag bit 1 */
    byte PIFT2       :1;                                       /* Port T interrupt flag bit 2 */
    byte PIFT3       :1;                                       /* Port T interrupt flag bit 3 */
    byte PIFT4       :1;                                       /* Port T interrupt flag bit 4 */
    byte PIFT5       :1;                                       /* Port T interrupt flag bit 5 */
    byte PIFT6       :1;                                       /* Port T interrupt flag bit 6 */
    byte PIFT7       :1;                                       /* Port T interrupt flag bit 7 */
  } Bits;
} PIFTSTR;
extern volatile PIFTSTR _PIFT @(REG_BASE + 0x00000289UL);
#define PIFT                            _PIFT.Byte
#define PIFT_PIFT0                      _PIFT.Bits.PIFT0
#define PIFT_PIFT1                      _PIFT.Bits.PIFT1
#define PIFT_PIFT2                      _PIFT.Bits.PIFT2
#define PIFT_PIFT3                      _PIFT.Bits.PIFT3
#define PIFT_PIFT4                      _PIFT.Bits.PIFT4
#define PIFT_PIFT5                      _PIFT.Bits.PIFT5
#define PIFT_PIFT6                      _PIFT.Bits.PIFT6
#define PIFT_PIFT7                      _PIFT.Bits.PIFT7

#define PIFT_PIFT0_MASK                 1U
#define PIFT_PIFT1_MASK                 2U
#define PIFT_PIFT2_MASK                 4U
#define PIFT_PIFT3_MASK                 8U
#define PIFT_PIFT4_MASK                 16U
#define PIFT_PIFT5_MASK                 32U
#define PIFT_PIFT6_MASK                 64U
#define PIFT_PIFT7_MASK                 128U


/*** PIES - Port S Interrupt Enable Register; 0x0000028A ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PIES2       :1;                                       /* Port S interrupt enable bit 2 */
    byte PIES3       :1;                                       /* Port S interrupt enable bit 3 */
    byte             :1; 
    byte PIES5       :1;                                       /* Port S interrupt enable bit 5 */
    byte PIES6       :1;                                       /* Port S interrupt enable bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpPIES_2 :2;
    byte         :1;
    byte grpPIES_5 :2;
    byte         :1;
  } MergedBits;
} PIESSTR;
extern volatile PIESSTR _PIES @(REG_BASE + 0x0000028AUL);
#define PIES                            _PIES.Byte
#define PIES_PIES2                      _PIES.Bits.PIES2
#define PIES_PIES3                      _PIES.Bits.PIES3
#define PIES_PIES5                      _PIES.Bits.PIES5
#define PIES_PIES6                      _PIES.Bits.PIES6
#define PIES_PIES_2                     _PIES.MergedBits.grpPIES_2
#define PIES_PIES_5                     _PIES.MergedBits.grpPIES_5

#define PIES_PIES2_MASK                 4U
#define PIES_PIES3_MASK                 8U
#define PIES_PIES5_MASK                 32U
#define PIES_PIES6_MASK                 64U
#define PIES_PIES_2_MASK                12U
#define PIES_PIES_2_BITNUM              2U
#define PIES_PIES_5_MASK                96U
#define PIES_PIES_5_BITNUM              5U


/*** PIFS - Port S Interrupt Flag Register; 0x0000028B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PIFS2       :1;                                       /* Port S interrupt flag bit 2 */
    byte PIFS3       :1;                                       /* Port S interrupt flag bit 3 */
    byte             :1; 
    byte PIFS5       :1;                                       /* Port S interrupt flag bit 5 */
    byte PIFS6       :1;                                       /* Port S interrupt flag bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpPIFS_2 :2;
    byte         :1;
    byte grpPIFS_5 :2;
    byte         :1;
  } MergedBits;
} PIFSSTR;
extern volatile PIFSSTR _PIFS @(REG_BASE + 0x0000028BUL);
#define PIFS                            _PIFS.Byte
#define PIFS_PIFS2                      _PIFS.Bits.PIFS2
#define PIFS_PIFS3                      _PIFS.Bits.PIFS3
#define PIFS_PIFS5                      _PIFS.Bits.PIFS5
#define PIFS_PIFS6                      _PIFS.Bits.PIFS6
#define PIFS_PIFS_2                     _PIFS.MergedBits.grpPIFS_2
#define PIFS_PIFS_5                     _PIFS.MergedBits.grpPIFS_5

#define PIFS_PIFS2_MASK                 4U
#define PIFS_PIFS3_MASK                 8U
#define PIFS_PIFS5_MASK                 32U
#define PIFS_PIFS6_MASK                 64U
#define PIFS_PIFS_2_MASK                12U
#define PIFS_PIFS_2_BITNUM              2U
#define PIFS_PIFS_5_MASK                96U
#define PIFS_PIFS_5_BITNUM              5U


/*** PIE1AD - Port ADL Interrupt Enable Register; 0x0000028C ***/
typedef union {
  byte Byte;
  struct {
    byte PIE1AD0     :1;                                       /* Port ADL Interrupt Enable Bit 0 */
    byte PIE1AD1     :1;                                       /* Port ADL Interrupt Enable Bit 1 */
    byte PIE1AD2     :1;                                       /* Port ADL Interrupt Enable Bit 2 */
    byte PIE1AD3     :1;                                       /* Port ADL Interrupt Enable Bit 3 */
    byte PIE1AD4     :1;                                       /* Port ADL Interrupt Enable Bit 4 */
    byte PIE1AD5     :1;                                       /* Port ADL Interrupt Enable Bit 5 */
    byte PIE1AD6     :1;                                       /* Port ADL Interrupt Enable Bit 6 */
    byte PIE1AD7     :1;                                       /* Port ADL Interrupt Enable Bit 7 */
  } Bits;
} PIE1ADSTR;
extern volatile PIE1ADSTR _PIE1AD @(REG_BASE + 0x0000028CUL);
#define PIE1AD                          _PIE1AD.Byte
#define PIE1AD_PIE1AD0                  _PIE1AD.Bits.PIE1AD0
#define PIE1AD_PIE1AD1                  _PIE1AD.Bits.PIE1AD1
#define PIE1AD_PIE1AD2                  _PIE1AD.Bits.PIE1AD2
#define PIE1AD_PIE1AD3                  _PIE1AD.Bits.PIE1AD3
#define PIE1AD_PIE1AD4                  _PIE1AD.Bits.PIE1AD4
#define PIE1AD_PIE1AD5                  _PIE1AD.Bits.PIE1AD5
#define PIE1AD_PIE1AD6                  _PIE1AD.Bits.PIE1AD6
#define PIE1AD_PIE1AD7                  _PIE1AD.Bits.PIE1AD7

#define PIE1AD_PIE1AD0_MASK             1U
#define PIE1AD_PIE1AD1_MASK             2U
#define PIE1AD_PIE1AD2_MASK             4U
#define PIE1AD_PIE1AD3_MASK             8U
#define PIE1AD_PIE1AD4_MASK             16U
#define PIE1AD_PIE1AD5_MASK             32U
#define PIE1AD_PIE1AD6_MASK             64U
#define PIE1AD_PIE1AD7_MASK             128U


/*** PIF1AD - Port ADL Interrupt Flag Register; 0x0000028D ***/
typedef union {
  byte Byte;
  struct {
    byte PIF1AD0     :1;                                       /* Port ADL Bit 0 */
    byte PIF1AD1     :1;                                       /* Port ADL Bit 1 */
    byte PIF1AD2     :1;                                       /* Port ADL Bit 2 */
    byte PIF1AD3     :1;                                       /* Port ADL Bit 3 */
    byte PIF1AD4     :1;                                       /* Port ADL Bit 4 */
    byte PIF1AD5     :1;                                       /* Port ADL Bit 5 */
    byte PIF1AD6     :1;                                       /* Port ADL Bit 6 */
    byte PIF1AD7     :1;                                       /* Port ADL Bit 7 */
  } Bits;
} PIF1ADSTR;
extern volatile PIF1ADSTR _PIF1AD @(REG_BASE + 0x0000028DUL);
#define PIF1AD                          _PIF1AD.Byte
#define PIF1AD_PIF1AD0                  _PIF1AD.Bits.PIF1AD0
#define PIF1AD_PIF1AD1                  _PIF1AD.Bits.PIF1AD1
#define PIF1AD_PIF1AD2                  _PIF1AD.Bits.PIF1AD2
#define PIF1AD_PIF1AD3                  _PIF1AD.Bits.PIF1AD3
#define PIF1AD_PIF1AD4                  _PIF1AD.Bits.PIF1AD4
#define PIF1AD_PIF1AD5                  _PIF1AD.Bits.PIF1AD5
#define PIF1AD_PIF1AD6                  _PIF1AD.Bits.PIF1AD6
#define PIF1AD_PIF1AD7                  _PIF1AD.Bits.PIF1AD7

#define PIF1AD_PIF1AD0_MASK             1U
#define PIF1AD_PIF1AD1_MASK             2U
#define PIF1AD_PIF1AD2_MASK             4U
#define PIF1AD_PIF1AD3_MASK             8U
#define PIF1AD_PIF1AD4_MASK             16U
#define PIF1AD_PIF1AD5_MASK             32U
#define PIF1AD_PIF1AD6_MASK             64U
#define PIF1AD_PIF1AD7_MASK             128U


/*** PIER - Port R Interrupt Enable Register; 0x0000028E ***/
typedef union {
  byte Byte;
  struct {
    byte PIER0       :1;                                       /* Port R interrupt enable bit 0 */
    byte PIER1       :1;                                       /* Port R interrupt enable bit 1 */
    byte PIER2       :1;                                       /* Port R interrupt enable bit 2 */
    byte PIER3       :1;                                       /* Port R interrupt enable bit 3 */
    byte PIER4       :1;                                       /* Port R interrupt enable bit 4 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIER :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PIERSTR;
extern volatile PIERSTR _PIER @(REG_BASE + 0x0000028EUL);
#define PIER                            _PIER.Byte
#define PIER_PIER0                      _PIER.Bits.PIER0
#define PIER_PIER1                      _PIER.Bits.PIER1
#define PIER_PIER2                      _PIER.Bits.PIER2
#define PIER_PIER3                      _PIER.Bits.PIER3
#define PIER_PIER4                      _PIER.Bits.PIER4
#define PIER_PIER                       _PIER.MergedBits.grpPIER

#define PIER_PIER0_MASK                 1U
#define PIER_PIER1_MASK                 2U
#define PIER_PIER2_MASK                 4U
#define PIER_PIER3_MASK                 8U
#define PIER_PIER4_MASK                 16U
#define PIER_PIER_MASK                  31U
#define PIER_PIER_BITNUM                0U


/*** PIFR - Port R Interrupt Flag Register; 0x0000028F ***/
typedef union {
  byte Byte;
  struct {
    byte PIFR0       :1;                                       /* Port R interrupt flag bit 0 */
    byte PIFR1       :1;                                       /* Port R interrupt flag bit 1 */
    byte PIFR2       :1;                                       /* Port R interrupt flag bit 2 */
    byte PIFR3       :1;                                       /* Port R interrupt flag bit 3 */
    byte PIFR4       :1;                                       /* Port R interrupt flag bit 4 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPIFR :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PIFRSTR;
extern volatile PIFRSTR _PIFR @(REG_BASE + 0x0000028FUL);
#define PIFR                            _PIFR.Byte
#define PIFR_PIFR0                      _PIFR.Bits.PIFR0
#define PIFR_PIFR1                      _PIFR.Bits.PIFR1
#define PIFR_PIFR2                      _PIFR.Bits.PIFR2
#define PIFR_PIFR3                      _PIFR.Bits.PIFR3
#define PIFR_PIFR4                      _PIFR.Bits.PIFR4
#define PIFR_PIFR                       _PIFR.MergedBits.grpPIFR

#define PIFR_PIFR0_MASK                 1U
#define PIFR_PIFR1_MASK                 2U
#define PIFR_PIFR2_MASK                 4U
#define PIFR_PIFR3_MASK                 8U
#define PIFR_PIFR4_MASK                 16U
#define PIFR_PIFR_MASK                  31U
#define PIFR_PIFR_BITNUM                0U


/*** PTU - Port U Data Register; 0x00000290 ***/
typedef union {
  byte Byte;
  struct {
    byte PTU0        :1;                                       /* Port U general purpose input/output data bit 0 */
    byte PTU1        :1;                                       /* Port U general purpose input/output data bit 1 */
    byte PTU2        :1;                                       /* Port U general purpose input/output data bit 2 */
    byte PTU3        :1;                                       /* Port U general purpose input/output data bit 3 */
    byte PTU4        :1;                                       /* Port U general purpose input/output data bit 4 */
    byte PTU5        :1;                                       /* Port U general purpose input/output data bit 5 */
    byte PTU6        :1;                                       /* Port U general purpose input/output data bit 6 */
    byte PTU7        :1;                                       /* Port U general purpose input/output data bit 7 */
  } Bits;
} PTUSTR;
extern volatile PTUSTR _PTU @(REG_BASE + 0x00000290UL);
#define PTU                             _PTU.Byte
#define PTU_PTU0                        _PTU.Bits.PTU0
#define PTU_PTU1                        _PTU.Bits.PTU1
#define PTU_PTU2                        _PTU.Bits.PTU2
#define PTU_PTU3                        _PTU.Bits.PTU3
#define PTU_PTU4                        _PTU.Bits.PTU4
#define PTU_PTU5                        _PTU.Bits.PTU5
#define PTU_PTU6                        _PTU.Bits.PTU6
#define PTU_PTU7                        _PTU.Bits.PTU7

#define PTU_PTU0_MASK                   1U
#define PTU_PTU1_MASK                   2U
#define PTU_PTU2_MASK                   4U
#define PTU_PTU3_MASK                   8U
#define PTU_PTU4_MASK                   16U
#define PTU_PTU5_MASK                   32U
#define PTU_PTU6_MASK                   64U
#define PTU_PTU7_MASK                   128U


/*** PTIU - Port U Input Register; 0x00000291 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIU0       :1;                                       /* Port U input data bit 0 */
    byte PTIU1       :1;                                       /* Port U input data bit 1 */
    byte PTIU2       :1;                                       /* Port U input data bit 2 */
    byte PTIU3       :1;                                       /* Port U input data bit 3 */
    byte PTIU4       :1;                                       /* Port U input data bit 4 */
    byte PTIU5       :1;                                       /* Port U input data bit 5 */
    byte PTIU6       :1;                                       /* Port U input data bit 6 */
    byte PTIU7       :1;                                       /* Port U input data bit 7 */
  } Bits;
} PTIUSTR;
extern volatile PTIUSTR _PTIU @(REG_BASE + 0x00000291UL);
#define PTIU                            _PTIU.Byte
#define PTIU_PTIU0                      _PTIU.Bits.PTIU0
#define PTIU_PTIU1                      _PTIU.Bits.PTIU1
#define PTIU_PTIU2                      _PTIU.Bits.PTIU2
#define PTIU_PTIU3                      _PTIU.Bits.PTIU3
#define PTIU_PTIU4                      _PTIU.Bits.PTIU4
#define PTIU_PTIU5                      _PTIU.Bits.PTIU5
#define PTIU_PTIU6                      _PTIU.Bits.PTIU6
#define PTIU_PTIU7                      _PTIU.Bits.PTIU7

#define PTIU_PTIU0_MASK                 1U
#define PTIU_PTIU1_MASK                 2U
#define PTIU_PTIU2_MASK                 4U
#define PTIU_PTIU3_MASK                 8U
#define PTIU_PTIU4_MASK                 16U
#define PTIU_PTIU5_MASK                 32U
#define PTIU_PTIU6_MASK                 64U
#define PTIU_PTIU7_MASK                 128U


/*** DDRU - Port U Data Direction Register; 0x00000292 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRU0       :1;                                       /* Port U data direction bit 0 */
    byte DDRU1       :1;                                       /* Port U data direction bit 1 */
    byte DDRU2       :1;                                       /* Port U data direction bit 2 */
    byte DDRU3       :1;                                       /* Port U data direction bit 3 */
    byte DDRU4       :1;                                       /* Port U data direction bit 4 */
    byte DDRU5       :1;                                       /* Port U data direction bit 5 */
    byte DDRU6       :1;                                       /* Port U data direction bit 6 */
    byte DDRU7       :1;                                       /* Port U data direction bit 7 */
  } Bits;
} DDRUSTR;
extern volatile DDRUSTR _DDRU @(REG_BASE + 0x00000292UL);
#define DDRU                            _DDRU.Byte
#define DDRU_DDRU0                      _DDRU.Bits.DDRU0
#define DDRU_DDRU1                      _DDRU.Bits.DDRU1
#define DDRU_DDRU2                      _DDRU.Bits.DDRU2
#define DDRU_DDRU3                      _DDRU.Bits.DDRU3
#define DDRU_DDRU4                      _DDRU.Bits.DDRU4
#define DDRU_DDRU5                      _DDRU.Bits.DDRU5
#define DDRU_DDRU6                      _DDRU.Bits.DDRU6
#define DDRU_DDRU7                      _DDRU.Bits.DDRU7

#define DDRU_DDRU0_MASK                 1U
#define DDRU_DDRU1_MASK                 2U
#define DDRU_DDRU2_MASK                 4U
#define DDRU_DDRU3_MASK                 8U
#define DDRU_DDRU4_MASK                 16U
#define DDRU_DDRU5_MASK                 32U
#define DDRU_DDRU6_MASK                 64U
#define DDRU_DDRU7_MASK                 128U


/*** PERU - Port U Pull Device Enable Register; 0x00000294 ***/
typedef union {
  byte Byte;
  struct {
    byte PERU0       :1;                                       /* Port U pull device enable bit 0 */
    byte PERU1       :1;                                       /* Port U pull device enable bit 1 */
    byte PERU2       :1;                                       /* Port U pull device enable bit 2 */
    byte PERU3       :1;                                       /* Port U pull device enable bit 3 */
    byte PERU4       :1;                                       /* Port U pull device enable bit 4 */
    byte PERU5       :1;                                       /* Port U pull device enable bit 5 */
    byte PERU6       :1;                                       /* Port U pull device enable bit 6 */
    byte PERU7       :1;                                       /* Port U pull device enable bit 7 */
  } Bits;
} PERUSTR;
extern volatile PERUSTR _PERU @(REG_BASE + 0x00000294UL);
#define PERU                            _PERU.Byte
#define PERU_PERU0                      _PERU.Bits.PERU0
#define PERU_PERU1                      _PERU.Bits.PERU1
#define PERU_PERU2                      _PERU.Bits.PERU2
#define PERU_PERU3                      _PERU.Bits.PERU3
#define PERU_PERU4                      _PERU.Bits.PERU4
#define PERU_PERU5                      _PERU.Bits.PERU5
#define PERU_PERU6                      _PERU.Bits.PERU6
#define PERU_PERU7                      _PERU.Bits.PERU7

#define PERU_PERU0_MASK                 1U
#define PERU_PERU1_MASK                 2U
#define PERU_PERU2_MASK                 4U
#define PERU_PERU3_MASK                 8U
#define PERU_PERU4_MASK                 16U
#define PERU_PERU5_MASK                 32U
#define PERU_PERU6_MASK                 64U
#define PERU_PERU7_MASK                 128U


/*** PPSU - Port U Polarity Select Register; 0x00000295 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSU0       :1;                                       /* Port U pull device select bit 0 */
    byte PPSU1       :1;                                       /* Port U pull device select bit 1 */
    byte PPSU2       :1;                                       /* Port U pull device select bit 2 */
    byte PPSU3       :1;                                       /* Port U pull device select bit 3 */
    byte PPSU4       :1;                                       /* Port U pull device select bit 4 */
    byte PPSU5       :1;                                       /* Port U pull device select bit 5 */
    byte PPSU6       :1;                                       /* Port U pull device select bit 6 */
    byte PPSU7       :1;                                       /* Port U pull device select bit 7 */
  } Bits;
} PPSUSTR;
extern volatile PPSUSTR _PPSU @(REG_BASE + 0x00000295UL);
#define PPSU                            _PPSU.Byte
#define PPSU_PPSU0                      _PPSU.Bits.PPSU0
#define PPSU_PPSU1                      _PPSU.Bits.PPSU1
#define PPSU_PPSU2                      _PPSU.Bits.PPSU2
#define PPSU_PPSU3                      _PPSU.Bits.PPSU3
#define PPSU_PPSU4                      _PPSU.Bits.PPSU4
#define PPSU_PPSU5                      _PPSU.Bits.PPSU5
#define PPSU_PPSU6                      _PPSU.Bits.PPSU6
#define PPSU_PPSU7                      _PPSU.Bits.PPSU7

#define PPSU_PPSU0_MASK                 1U
#define PPSU_PPSU1_MASK                 2U
#define PPSU_PPSU2_MASK                 4U
#define PPSU_PPSU3_MASK                 8U
#define PPSU_PPSU4_MASK                 16U
#define PPSU_PPSU5_MASK                 32U
#define PPSU_PPSU6_MASK                 64U
#define PPSU_PPSU7_MASK                 128U


/*** SRRU - Port U Slew Rate Register; 0x00000296 ***/
typedef union {
  byte Byte;
  struct {
    byte SRRU0       :1;                                       /* Slew rate port U bit 0 */
    byte SRRU1       :1;                                       /* Slew rate port U bit 1 */
    byte SRRU2       :1;                                       /* Slew rate port U bit 2 */
    byte SRRU3       :1;                                       /* Slew rate port U bit 3 */
    byte SRRU4       :1;                                       /* Slew rate port U bit 4 */
    byte SRRU5       :1;                                       /* Slew rate port U bit 5 */
    byte SRRU6       :1;                                       /* Slew rate port U bit 6 */
    byte SRRU7       :1;                                       /* Slew rate port U bit 7 */
  } Bits;
} SRRUSTR;
extern volatile SRRUSTR _SRRU @(REG_BASE + 0x00000296UL);
#define SRRU                            _SRRU.Byte
#define SRRU_SRRU0                      _SRRU.Bits.SRRU0
#define SRRU_SRRU1                      _SRRU.Bits.SRRU1
#define SRRU_SRRU2                      _SRRU.Bits.SRRU2
#define SRRU_SRRU3                      _SRRU.Bits.SRRU3
#define SRRU_SRRU4                      _SRRU.Bits.SRRU4
#define SRRU_SRRU5                      _SRRU.Bits.SRRU5
#define SRRU_SRRU6                      _SRRU.Bits.SRRU6
#define SRRU_SRRU7                      _SRRU.Bits.SRRU7

#define SRRU_SRRU0_MASK                 1U
#define SRRU_SRRU1_MASK                 2U
#define SRRU_SRRU2_MASK                 4U
#define SRRU_SRRU3_MASK                 8U
#define SRRU_SRRU4_MASK                 16U
#define SRRU_SRRU5_MASK                 32U
#define SRRU_SRRU6_MASK                 64U
#define SRRU_SRRU7_MASK                 128U


/*** PTURR - Port U Routing Register; 0x00000297 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PTURR2      :1;                                       /* Port U  routing */
    byte PTURR3      :1;                                       /* Port U  routing */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpPTURR_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTURRSTR;
extern volatile PTURRSTR _PTURR @(REG_BASE + 0x00000297UL);
#define PTURR                           _PTURR.Byte
#define PTURR_PTURR2                    _PTURR.Bits.PTURR2
#define PTURR_PTURR3                    _PTURR.Bits.PTURR3
#define PTURR_PTURR_2                   _PTURR.MergedBits.grpPTURR_2

#define PTURR_PTURR2_MASK               4U
#define PTURR_PTURR3_MASK               8U
#define PTURR_PTURR_2_MASK              12U
#define PTURR_PTURR_2_BITNUM            2U


/*** PTV - Port V Data Register; 0x00000298 ***/
typedef union {
  byte Byte;
  struct {
    byte PTV0        :1;                                       /* Port V general purpose input/output data bit 0 */
    byte PTV1        :1;                                       /* Port V general purpose input/output data bit 1 */
    byte PTV2        :1;                                       /* Port V general purpose input/output data bit 2 */
    byte PTV3        :1;                                       /* Port V general purpose input/output data bit 3 */
    byte PTV4        :1;                                       /* Port V general purpose input/output data bit 4 */
    byte PTV5        :1;                                       /* Port V general purpose input/output data bit 5 */
    byte PTV6        :1;                                       /* Port V general purpose input/output data bit 6 */
    byte PTV7        :1;                                       /* Port V general purpose input/output data bit 7 */
  } Bits;
} PTVSTR;
extern volatile PTVSTR _PTV @(REG_BASE + 0x00000298UL);
#define PTV                             _PTV.Byte
#define PTV_PTV0                        _PTV.Bits.PTV0
#define PTV_PTV1                        _PTV.Bits.PTV1
#define PTV_PTV2                        _PTV.Bits.PTV2
#define PTV_PTV3                        _PTV.Bits.PTV3
#define PTV_PTV4                        _PTV.Bits.PTV4
#define PTV_PTV5                        _PTV.Bits.PTV5
#define PTV_PTV6                        _PTV.Bits.PTV6
#define PTV_PTV7                        _PTV.Bits.PTV7

#define PTV_PTV0_MASK                   1U
#define PTV_PTV1_MASK                   2U
#define PTV_PTV2_MASK                   4U
#define PTV_PTV3_MASK                   8U
#define PTV_PTV4_MASK                   16U
#define PTV_PTV5_MASK                   32U
#define PTV_PTV6_MASK                   64U
#define PTV_PTV7_MASK                   128U


/*** PTIV - Port V Input Register; 0x00000299 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIV0       :1;                                       /* Port V input data bit 0 */
    byte PTIV1       :1;                                       /* Port V input data bit 1 */
    byte PTIV2       :1;                                       /* Port V input data bit 2 */
    byte PTIV3       :1;                                       /* Port V input data bit 3 */
    byte PTIV4       :1;                                       /* Port V input data bit 4 */
    byte PTIV5       :1;                                       /* Port V input data bit 5 */
    byte PTIV6       :1;                                       /* Port V input data bit 6 */
    byte PTIV7       :1;                                       /* Port V input data bit 7 */
  } Bits;
} PTIVSTR;
extern volatile PTIVSTR _PTIV @(REG_BASE + 0x00000299UL);
#define PTIV                            _PTIV.Byte
#define PTIV_PTIV0                      _PTIV.Bits.PTIV0
#define PTIV_PTIV1                      _PTIV.Bits.PTIV1
#define PTIV_PTIV2                      _PTIV.Bits.PTIV2
#define PTIV_PTIV3                      _PTIV.Bits.PTIV3
#define PTIV_PTIV4                      _PTIV.Bits.PTIV4
#define PTIV_PTIV5                      _PTIV.Bits.PTIV5
#define PTIV_PTIV6                      _PTIV.Bits.PTIV6
#define PTIV_PTIV7                      _PTIV.Bits.PTIV7

#define PTIV_PTIV0_MASK                 1U
#define PTIV_PTIV1_MASK                 2U
#define PTIV_PTIV2_MASK                 4U
#define PTIV_PTIV3_MASK                 8U
#define PTIV_PTIV4_MASK                 16U
#define PTIV_PTIV5_MASK                 32U
#define PTIV_PTIV6_MASK                 64U
#define PTIV_PTIV7_MASK                 128U


/*** DDRV - Port V Data Direction Register; 0x0000029A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRV0       :1;                                       /* Port V data direction bit 0 */
    byte DDRV1       :1;                                       /* Port V data direction bit 1 */
    byte DDRV2       :1;                                       /* Port V data direction bit 2 */
    byte DDRV3       :1;                                       /* Port V data direction bit 3 */
    byte DDRV4       :1;                                       /* Port V data direction bit 4 */
    byte DDRV5       :1;                                       /* Port V data direction bit 5 */
    byte DDRV6       :1;                                       /* Port V data direction bit 6 */
    byte DDRV7       :1;                                       /* Port V data direction bit 7 */
  } Bits;
} DDRVSTR;
extern volatile DDRVSTR _DDRV @(REG_BASE + 0x0000029AUL);
#define DDRV                            _DDRV.Byte
#define DDRV_DDRV0                      _DDRV.Bits.DDRV0
#define DDRV_DDRV1                      _DDRV.Bits.DDRV1
#define DDRV_DDRV2                      _DDRV.Bits.DDRV2
#define DDRV_DDRV3                      _DDRV.Bits.DDRV3
#define DDRV_DDRV4                      _DDRV.Bits.DDRV4
#define DDRV_DDRV5                      _DDRV.Bits.DDRV5
#define DDRV_DDRV6                      _DDRV.Bits.DDRV6
#define DDRV_DDRV7                      _DDRV.Bits.DDRV7

#define DDRV_DDRV0_MASK                 1U
#define DDRV_DDRV1_MASK                 2U
#define DDRV_DDRV2_MASK                 4U
#define DDRV_DDRV3_MASK                 8U
#define DDRV_DDRV4_MASK                 16U
#define DDRV_DDRV5_MASK                 32U
#define DDRV_DDRV6_MASK                 64U
#define DDRV_DDRV7_MASK                 128U


/*** PERV - Port V Pull Device Enable Register; 0x0000029C ***/
typedef union {
  byte Byte;
  struct {
    byte PERV0       :1;                                       /* Port V pull device enable bit 0 */
    byte PERV1       :1;                                       /* Port V pull device enable bit 1 */
    byte PERV2       :1;                                       /* Port V pull device enable bit 2 */
    byte PERV3       :1;                                       /* Port V pull device enable bit 3 */
    byte PERV4       :1;                                       /* Port V pull device enable bit 4 */
    byte PERV5       :1;                                       /* Port V pull device enable bit 5 */
    byte PERV6       :1;                                       /* Port V pull device enable bit 6 */
    byte PERV7       :1;                                       /* Port V pull device enable bit 7 */
  } Bits;
} PERVSTR;
extern volatile PERVSTR _PERV @(REG_BASE + 0x0000029CUL);
#define PERV                            _PERV.Byte
#define PERV_PERV0                      _PERV.Bits.PERV0
#define PERV_PERV1                      _PERV.Bits.PERV1
#define PERV_PERV2                      _PERV.Bits.PERV2
#define PERV_PERV3                      _PERV.Bits.PERV3
#define PERV_PERV4                      _PERV.Bits.PERV4
#define PERV_PERV5                      _PERV.Bits.PERV5
#define PERV_PERV6                      _PERV.Bits.PERV6
#define PERV_PERV7                      _PERV.Bits.PERV7

#define PERV_PERV0_MASK                 1U
#define PERV_PERV1_MASK                 2U
#define PERV_PERV2_MASK                 4U
#define PERV_PERV3_MASK                 8U
#define PERV_PERV4_MASK                 16U
#define PERV_PERV5_MASK                 32U
#define PERV_PERV6_MASK                 64U
#define PERV_PERV7_MASK                 128U


/*** PPSV - Port V Polarity Select Register; 0x0000029D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSV0       :1;                                       /* Port V pull device select bit 0 */
    byte PPSV1       :1;                                       /* Port V pull device select bit 1 */
    byte PPSV2       :1;                                       /* Port V pull device select bit 2 */
    byte PPSV3       :1;                                       /* Port V pull device select bit 3 */
    byte PPSV4       :1;                                       /* Port V pull device select bit 4 */
    byte PPSV5       :1;                                       /* Port V pull device select bit 5 */
    byte PPSV6       :1;                                       /* Port V pull device select bit 6 */
    byte PPSV7       :1;                                       /* Port V pull device select bit 7 */
  } Bits;
} PPSVSTR;
extern volatile PPSVSTR _PPSV @(REG_BASE + 0x0000029DUL);
#define PPSV                            _PPSV.Byte
#define PPSV_PPSV0                      _PPSV.Bits.PPSV0
#define PPSV_PPSV1                      _PPSV.Bits.PPSV1
#define PPSV_PPSV2                      _PPSV.Bits.PPSV2
#define PPSV_PPSV3                      _PPSV.Bits.PPSV3
#define PPSV_PPSV4                      _PPSV.Bits.PPSV4
#define PPSV_PPSV5                      _PPSV.Bits.PPSV5
#define PPSV_PPSV6                      _PPSV.Bits.PPSV6
#define PPSV_PPSV7                      _PPSV.Bits.PPSV7

#define PPSV_PPSV0_MASK                 1U
#define PPSV_PPSV1_MASK                 2U
#define PPSV_PPSV2_MASK                 4U
#define PPSV_PPSV3_MASK                 8U
#define PPSV_PPSV4_MASK                 16U
#define PPSV_PPSV5_MASK                 32U
#define PPSV_PPSV6_MASK                 64U
#define PPSV_PPSV7_MASK                 128U


/*** SRRV - Port V Slew Rate Register; 0x0000029E ***/
typedef union {
  byte Byte;
  struct {
    byte SRRV0       :1;                                       /* Slew rate port V bit 0 */
    byte SRRV1       :1;                                       /* Slew rate port V bit 1 */
    byte SRRV2       :1;                                       /* Slew rate port V bit 2 */
    byte SRRV3       :1;                                       /* Slew rate port V bit 3 */
    byte SRRV4       :1;                                       /* Slew rate port V bit 4 */
    byte SRRV5       :1;                                       /* Slew rate port V bit 5 */
    byte SRRV6       :1;                                       /* Slew rate port V bit 6 */
    byte SRRV7       :1;                                       /* Slew rate port V bit 7 */
  } Bits;
} SRRVSTR;
extern volatile SRRVSTR _SRRV @(REG_BASE + 0x0000029EUL);
#define SRRV                            _SRRV.Byte
#define SRRV_SRRV0                      _SRRV.Bits.SRRV0
#define SRRV_SRRV1                      _SRRV.Bits.SRRV1
#define SRRV_SRRV2                      _SRRV.Bits.SRRV2
#define SRRV_SRRV3                      _SRRV.Bits.SRRV3
#define SRRV_SRRV4                      _SRRV.Bits.SRRV4
#define SRRV_SRRV5                      _SRRV.Bits.SRRV5
#define SRRV_SRRV6                      _SRRV.Bits.SRRV6
#define SRRV_SRRV7                      _SRRV.Bits.SRRV7

#define SRRV_SRRV0_MASK                 1U
#define SRRV_SRRV1_MASK                 2U
#define SRRV_SRRV2_MASK                 4U
#define SRRV_SRRV3_MASK                 8U
#define SRRV_SRRV4_MASK                 16U
#define SRRV_SRRV5_MASK                 32U
#define SRRV_SRRV6_MASK                 64U
#define SRRV_SRRV7_MASK                 128U


/*** PTVRR - Port V Routing Register; 0x0000029F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte PTVRR2      :1;                                       /* Port V  routing */
    byte PTVRR3      :1;                                       /* Port V  routing */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpPTVRR_2 :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTVRRSTR;
extern volatile PTVRRSTR _PTVRR @(REG_BASE + 0x0000029FUL);
#define PTVRR                           _PTVRR.Byte
#define PTVRR_PTVRR2                    _PTVRR.Bits.PTVRR2
#define PTVRR_PTVRR3                    _PTVRR.Bits.PTVRR3
#define PTVRR_PTVRR_2                   _PTVRR.MergedBits.grpPTVRR_2

#define PTVRR_PTVRR2_MASK               4U
#define PTVRR_PTVRR3_MASK               8U
#define PTVRR_PTVRR_2_MASK              12U
#define PTVRR_PTVRR_2_BITNUM            2U


/*** TIM1_TIOS - Timer Input Capture/Output Compare Select; 0x000002A0 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} TIM1_TIOSSTR;
extern volatile TIM1_TIOSSTR _TIM1_TIOS @(REG_BASE + 0x000002A0UL);
#define TIM1_TIOS                       _TIM1_TIOS.Byte
#define TIM1_TIOS_IOS0                  _TIM1_TIOS.Bits.IOS0
#define TIM1_TIOS_IOS1                  _TIM1_TIOS.Bits.IOS1
#define TIM1_TIOS_IOS2                  _TIM1_TIOS.Bits.IOS2
#define TIM1_TIOS_IOS3                  _TIM1_TIOS.Bits.IOS3
#define TIM1_TIOS_IOS4                  _TIM1_TIOS.Bits.IOS4
#define TIM1_TIOS_IOS5                  _TIM1_TIOS.Bits.IOS5
#define TIM1_TIOS_IOS6                  _TIM1_TIOS.Bits.IOS6
#define TIM1_TIOS_IOS7                  _TIM1_TIOS.Bits.IOS7

#define TIM1_TIOS_IOS0_MASK             1U
#define TIM1_TIOS_IOS1_MASK             2U
#define TIM1_TIOS_IOS2_MASK             4U
#define TIM1_TIOS_IOS3_MASK             8U
#define TIM1_TIOS_IOS4_MASK             16U
#define TIM1_TIOS_IOS5_MASK             32U
#define TIM1_TIOS_IOS6_MASK             64U
#define TIM1_TIOS_IOS7_MASK             128U


/*** TIM1_CFORC - Timer Compare Force Register; 0x000002A1 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} TIM1_CFORCSTR;
extern volatile TIM1_CFORCSTR _TIM1_CFORC @(REG_BASE + 0x000002A1UL);
#define TIM1_CFORC                      _TIM1_CFORC.Byte
#define TIM1_CFORC_FOC0                 _TIM1_CFORC.Bits.FOC0
#define TIM1_CFORC_FOC1                 _TIM1_CFORC.Bits.FOC1
#define TIM1_CFORC_FOC2                 _TIM1_CFORC.Bits.FOC2
#define TIM1_CFORC_FOC3                 _TIM1_CFORC.Bits.FOC3
#define TIM1_CFORC_FOC4                 _TIM1_CFORC.Bits.FOC4
#define TIM1_CFORC_FOC5                 _TIM1_CFORC.Bits.FOC5
#define TIM1_CFORC_FOC6                 _TIM1_CFORC.Bits.FOC6
#define TIM1_CFORC_FOC7                 _TIM1_CFORC.Bits.FOC7

#define TIM1_CFORC_FOC0_MASK            1U
#define TIM1_CFORC_FOC1_MASK            2U
#define TIM1_CFORC_FOC2_MASK            4U
#define TIM1_CFORC_FOC3_MASK            8U
#define TIM1_CFORC_FOC4_MASK            16U
#define TIM1_CFORC_FOC5_MASK            32U
#define TIM1_CFORC_FOC6_MASK            64U
#define TIM1_CFORC_FOC7_MASK            128U


/*** TIM1_OC7M - Output Compare 7 Mask Register; 0x000002A2 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} TIM1_OC7MSTR;
extern volatile TIM1_OC7MSTR _TIM1_OC7M @(REG_BASE + 0x000002A2UL);
#define TIM1_OC7M                       _TIM1_OC7M.Byte
#define TIM1_OC7M_OC7M0                 _TIM1_OC7M.Bits.OC7M0
#define TIM1_OC7M_OC7M1                 _TIM1_OC7M.Bits.OC7M1
#define TIM1_OC7M_OC7M2                 _TIM1_OC7M.Bits.OC7M2
#define TIM1_OC7M_OC7M3                 _TIM1_OC7M.Bits.OC7M3
#define TIM1_OC7M_OC7M4                 _TIM1_OC7M.Bits.OC7M4
#define TIM1_OC7M_OC7M5                 _TIM1_OC7M.Bits.OC7M5
#define TIM1_OC7M_OC7M6                 _TIM1_OC7M.Bits.OC7M6
#define TIM1_OC7M_OC7M7                 _TIM1_OC7M.Bits.OC7M7

#define TIM1_OC7M_OC7M0_MASK            1U
#define TIM1_OC7M_OC7M1_MASK            2U
#define TIM1_OC7M_OC7M2_MASK            4U
#define TIM1_OC7M_OC7M3_MASK            8U
#define TIM1_OC7M_OC7M4_MASK            16U
#define TIM1_OC7M_OC7M5_MASK            32U
#define TIM1_OC7M_OC7M6_MASK            64U
#define TIM1_OC7M_OC7M7_MASK            128U


/*** TIM1_OC7D - Output Compare 7 Data Register; 0x000002A3 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7D0       :1;                                       /* Output Compare 7 Bit 0 */
    byte OC7D1       :1;                                       /* Output Compare 7 Bit 1 */
    byte OC7D2       :1;                                       /* Output Compare 7 Bit 2 */
    byte OC7D3       :1;                                       /* Output Compare 7 Bit 3 */
    byte OC7D4       :1;                                       /* Output Compare 7 Bit 4 */
    byte OC7D5       :1;                                       /* Output Compare 7 Bit 5 */
    byte OC7D6       :1;                                       /* Output Compare 7 Bit 6 */
    byte OC7D7       :1;                                       /* Output Compare 7 Bit 7 */
  } Bits;
} TIM1_OC7DSTR;
extern volatile TIM1_OC7DSTR _TIM1_OC7D @(REG_BASE + 0x000002A3UL);
#define TIM1_OC7D                       _TIM1_OC7D.Byte
#define TIM1_OC7D_OC7D0                 _TIM1_OC7D.Bits.OC7D0
#define TIM1_OC7D_OC7D1                 _TIM1_OC7D.Bits.OC7D1
#define TIM1_OC7D_OC7D2                 _TIM1_OC7D.Bits.OC7D2
#define TIM1_OC7D_OC7D3                 _TIM1_OC7D.Bits.OC7D3
#define TIM1_OC7D_OC7D4                 _TIM1_OC7D.Bits.OC7D4
#define TIM1_OC7D_OC7D5                 _TIM1_OC7D.Bits.OC7D5
#define TIM1_OC7D_OC7D6                 _TIM1_OC7D.Bits.OC7D6
#define TIM1_OC7D_OC7D7                 _TIM1_OC7D.Bits.OC7D7

#define TIM1_OC7D_OC7D0_MASK            1U
#define TIM1_OC7D_OC7D1_MASK            2U
#define TIM1_OC7D_OC7D2_MASK            4U
#define TIM1_OC7D_OC7D3_MASK            8U
#define TIM1_OC7D_OC7D4_MASK            16U
#define TIM1_OC7D_OC7D5_MASK            32U
#define TIM1_OC7D_OC7D6_MASK            64U
#define TIM1_OC7D_OC7D7_MASK            128U


/*** TIM1_TCNT - Timer Count Register; 0x000002A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TCNTHi - Timer Count Register High; 0x000002A4 ***/
    union {
      byte Byte;
    } TIM1_TCNTHiSTR;
    #define TIM1_TCNTHi                 _TIM1_TCNT.Overlap_STR.TIM1_TCNTHiSTR.Byte
    

    /*** TIM1_TCNTLo - Timer Count Register Low; 0x000002A5 ***/
    union {
      byte Byte;
    } TIM1_TCNTLoSTR;
    #define TIM1_TCNTLo                 _TIM1_TCNT.Overlap_STR.TIM1_TCNTLoSTR.Byte
    
  } Overlap_STR;

} TIM1_TCNTSTR;
extern volatile TIM1_TCNTSTR _TIM1_TCNT @(REG_BASE + 0x000002A4UL);
#define TIM1_TCNT                       _TIM1_TCNT.Word


/*** TIM1_TSCR1 - Timer System Control Register1; 0x000002A6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PRNT        :1;                                       /* Precision Timer */
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TIM1_TSCR1STR;
extern volatile TIM1_TSCR1STR _TIM1_TSCR1 @(REG_BASE + 0x000002A6UL);
#define TIM1_TSCR1                      _TIM1_TSCR1.Byte
#define TIM1_TSCR1_PRNT                 _TIM1_TSCR1.Bits.PRNT
#define TIM1_TSCR1_TFFCA                _TIM1_TSCR1.Bits.TFFCA
#define TIM1_TSCR1_TSFRZ                _TIM1_TSCR1.Bits.TSFRZ
#define TIM1_TSCR1_TSWAI                _TIM1_TSCR1.Bits.TSWAI
#define TIM1_TSCR1_TEN                  _TIM1_TSCR1.Bits.TEN

#define TIM1_TSCR1_PRNT_MASK            8U
#define TIM1_TSCR1_TFFCA_MASK           16U
#define TIM1_TSCR1_TSFRZ_MASK           32U
#define TIM1_TSCR1_TSWAI_MASK           64U
#define TIM1_TSCR1_TEN_MASK             128U


/*** TIM1_TTOV - Timer Toggle On Overflow Register; 0x000002A7 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} TIM1_TTOVSTR;
extern volatile TIM1_TTOVSTR _TIM1_TTOV @(REG_BASE + 0x000002A7UL);
#define TIM1_TTOV                       _TIM1_TTOV.Byte
#define TIM1_TTOV_TOV0                  _TIM1_TTOV.Bits.TOV0
#define TIM1_TTOV_TOV1                  _TIM1_TTOV.Bits.TOV1
#define TIM1_TTOV_TOV2                  _TIM1_TTOV.Bits.TOV2
#define TIM1_TTOV_TOV3                  _TIM1_TTOV.Bits.TOV3
#define TIM1_TTOV_TOV4                  _TIM1_TTOV.Bits.TOV4
#define TIM1_TTOV_TOV5                  _TIM1_TTOV.Bits.TOV5
#define TIM1_TTOV_TOV6                  _TIM1_TTOV.Bits.TOV6
#define TIM1_TTOV_TOV7                  _TIM1_TTOV.Bits.TOV7

#define TIM1_TTOV_TOV0_MASK             1U
#define TIM1_TTOV_TOV1_MASK             2U
#define TIM1_TTOV_TOV2_MASK             4U
#define TIM1_TTOV_TOV3_MASK             8U
#define TIM1_TTOV_TOV4_MASK             16U
#define TIM1_TTOV_TOV5_MASK             32U
#define TIM1_TTOV_TOV6_MASK             64U
#define TIM1_TTOV_TOV7_MASK             128U


/*** TIM1_TCTL1 - Timer Control Register 1; 0x000002A8 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TIM1_TCTL1STR;
extern volatile TIM1_TCTL1STR _TIM1_TCTL1 @(REG_BASE + 0x000002A8UL);
#define TIM1_TCTL1                      _TIM1_TCTL1.Byte
#define TIM1_TCTL1_OL4                  _TIM1_TCTL1.Bits.OL4
#define TIM1_TCTL1_OM4                  _TIM1_TCTL1.Bits.OM4
#define TIM1_TCTL1_OL5                  _TIM1_TCTL1.Bits.OL5
#define TIM1_TCTL1_OM5                  _TIM1_TCTL1.Bits.OM5
#define TIM1_TCTL1_OL6                  _TIM1_TCTL1.Bits.OL6
#define TIM1_TCTL1_OM6                  _TIM1_TCTL1.Bits.OM6
#define TIM1_TCTL1_OL7                  _TIM1_TCTL1.Bits.OL7
#define TIM1_TCTL1_OM7                  _TIM1_TCTL1.Bits.OM7

#define TIM1_TCTL1_OL4_MASK             1U
#define TIM1_TCTL1_OM4_MASK             2U
#define TIM1_TCTL1_OL5_MASK             4U
#define TIM1_TCTL1_OM5_MASK             8U
#define TIM1_TCTL1_OL6_MASK             16U
#define TIM1_TCTL1_OM6_MASK             32U
#define TIM1_TCTL1_OL7_MASK             64U
#define TIM1_TCTL1_OM7_MASK             128U


/*** TIM1_TCTL2 - Timer Control Register 2; 0x000002A9 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Lecel Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} TIM1_TCTL2STR;
extern volatile TIM1_TCTL2STR _TIM1_TCTL2 @(REG_BASE + 0x000002A9UL);
#define TIM1_TCTL2                      _TIM1_TCTL2.Byte
#define TIM1_TCTL2_OL0                  _TIM1_TCTL2.Bits.OL0
#define TIM1_TCTL2_OM0                  _TIM1_TCTL2.Bits.OM0
#define TIM1_TCTL2_OL1                  _TIM1_TCTL2.Bits.OL1
#define TIM1_TCTL2_OM1                  _TIM1_TCTL2.Bits.OM1
#define TIM1_TCTL2_OL2                  _TIM1_TCTL2.Bits.OL2
#define TIM1_TCTL2_OM2                  _TIM1_TCTL2.Bits.OM2
#define TIM1_TCTL2_OL3                  _TIM1_TCTL2.Bits.OL3
#define TIM1_TCTL2_OM3                  _TIM1_TCTL2.Bits.OM3

#define TIM1_TCTL2_OL0_MASK             1U
#define TIM1_TCTL2_OM0_MASK             2U
#define TIM1_TCTL2_OL1_MASK             4U
#define TIM1_TCTL2_OM1_MASK             8U
#define TIM1_TCTL2_OL2_MASK             16U
#define TIM1_TCTL2_OM2_MASK             32U
#define TIM1_TCTL2_OL3_MASK             64U
#define TIM1_TCTL2_OM3_MASK             128U


/*** TIM1_TCTL3 - Timer Control Register 3; 0x000002AA ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TIM1_TCTL3STR;
extern volatile TIM1_TCTL3STR _TIM1_TCTL3 @(REG_BASE + 0x000002AAUL);
#define TIM1_TCTL3                      _TIM1_TCTL3.Byte
#define TIM1_TCTL3_EDG4A                _TIM1_TCTL3.Bits.EDG4A
#define TIM1_TCTL3_EDG4B                _TIM1_TCTL3.Bits.EDG4B
#define TIM1_TCTL3_EDG5A                _TIM1_TCTL3.Bits.EDG5A
#define TIM1_TCTL3_EDG5B                _TIM1_TCTL3.Bits.EDG5B
#define TIM1_TCTL3_EDG6A                _TIM1_TCTL3.Bits.EDG6A
#define TIM1_TCTL3_EDG6B                _TIM1_TCTL3.Bits.EDG6B
#define TIM1_TCTL3_EDG7A                _TIM1_TCTL3.Bits.EDG7A
#define TIM1_TCTL3_EDG7B                _TIM1_TCTL3.Bits.EDG7B
#define TIM1_TCTL3_EDG4x                _TIM1_TCTL3.MergedBits.grpEDG4x
#define TIM1_TCTL3_EDG5x                _TIM1_TCTL3.MergedBits.grpEDG5x
#define TIM1_TCTL3_EDG6x                _TIM1_TCTL3.MergedBits.grpEDG6x
#define TIM1_TCTL3_EDG7x                _TIM1_TCTL3.MergedBits.grpEDG7x

#define TIM1_TCTL3_EDG4A_MASK           1U
#define TIM1_TCTL3_EDG4B_MASK           2U
#define TIM1_TCTL3_EDG5A_MASK           4U
#define TIM1_TCTL3_EDG5B_MASK           8U
#define TIM1_TCTL3_EDG6A_MASK           16U
#define TIM1_TCTL3_EDG6B_MASK           32U
#define TIM1_TCTL3_EDG7A_MASK           64U
#define TIM1_TCTL3_EDG7B_MASK           128U
#define TIM1_TCTL3_EDG4x_MASK           3U
#define TIM1_TCTL3_EDG4x_BITNUM         0U
#define TIM1_TCTL3_EDG5x_MASK           12U
#define TIM1_TCTL3_EDG5x_BITNUM         2U
#define TIM1_TCTL3_EDG6x_MASK           48U
#define TIM1_TCTL3_EDG6x_BITNUM         4U
#define TIM1_TCTL3_EDG7x_MASK           192U
#define TIM1_TCTL3_EDG7x_BITNUM         6U


/*** TIM1_TCTL4 - Timer Control Register 4; 0x000002AB ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} TIM1_TCTL4STR;
extern volatile TIM1_TCTL4STR _TIM1_TCTL4 @(REG_BASE + 0x000002ABUL);
#define TIM1_TCTL4                      _TIM1_TCTL4.Byte
#define TIM1_TCTL4_EDG0A                _TIM1_TCTL4.Bits.EDG0A
#define TIM1_TCTL4_EDG0B                _TIM1_TCTL4.Bits.EDG0B
#define TIM1_TCTL4_EDG1A                _TIM1_TCTL4.Bits.EDG1A
#define TIM1_TCTL4_EDG1B                _TIM1_TCTL4.Bits.EDG1B
#define TIM1_TCTL4_EDG2A                _TIM1_TCTL4.Bits.EDG2A
#define TIM1_TCTL4_EDG2B                _TIM1_TCTL4.Bits.EDG2B
#define TIM1_TCTL4_EDG3A                _TIM1_TCTL4.Bits.EDG3A
#define TIM1_TCTL4_EDG3B                _TIM1_TCTL4.Bits.EDG3B
#define TIM1_TCTL4_EDG0x                _TIM1_TCTL4.MergedBits.grpEDG0x
#define TIM1_TCTL4_EDG1x                _TIM1_TCTL4.MergedBits.grpEDG1x
#define TIM1_TCTL4_EDG2x                _TIM1_TCTL4.MergedBits.grpEDG2x
#define TIM1_TCTL4_EDG3x                _TIM1_TCTL4.MergedBits.grpEDG3x

#define TIM1_TCTL4_EDG0A_MASK           1U
#define TIM1_TCTL4_EDG0B_MASK           2U
#define TIM1_TCTL4_EDG1A_MASK           4U
#define TIM1_TCTL4_EDG1B_MASK           8U
#define TIM1_TCTL4_EDG2A_MASK           16U
#define TIM1_TCTL4_EDG2B_MASK           32U
#define TIM1_TCTL4_EDG3A_MASK           64U
#define TIM1_TCTL4_EDG3B_MASK           128U
#define TIM1_TCTL4_EDG0x_MASK           3U
#define TIM1_TCTL4_EDG0x_BITNUM         0U
#define TIM1_TCTL4_EDG1x_MASK           12U
#define TIM1_TCTL4_EDG1x_BITNUM         2U
#define TIM1_TCTL4_EDG2x_MASK           48U
#define TIM1_TCTL4_EDG2x_BITNUM         4U
#define TIM1_TCTL4_EDG3x_MASK           192U
#define TIM1_TCTL4_EDG3x_BITNUM         6U


/*** TIM1_TIE - Timer Interrupt Enable Register; 0x000002AC ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIM1_TIESTR;
extern volatile TIM1_TIESTR _TIM1_TIE @(REG_BASE + 0x000002ACUL);
#define TIM1_TIE                        _TIM1_TIE.Byte
#define TIM1_TIE_C0I                    _TIM1_TIE.Bits.C0I
#define TIM1_TIE_C1I                    _TIM1_TIE.Bits.C1I
#define TIM1_TIE_C2I                    _TIM1_TIE.Bits.C2I
#define TIM1_TIE_C3I                    _TIM1_TIE.Bits.C3I
#define TIM1_TIE_C4I                    _TIM1_TIE.Bits.C4I
#define TIM1_TIE_C5I                    _TIM1_TIE.Bits.C5I
#define TIM1_TIE_C6I                    _TIM1_TIE.Bits.C6I
#define TIM1_TIE_C7I                    _TIM1_TIE.Bits.C7I

#define TIM1_TIE_C0I_MASK               1U
#define TIM1_TIE_C1I_MASK               2U
#define TIM1_TIE_C2I_MASK               4U
#define TIM1_TIE_C3I_MASK               8U
#define TIM1_TIE_C4I_MASK               16U
#define TIM1_TIE_C5I_MASK               32U
#define TIM1_TIE_C6I_MASK               64U
#define TIM1_TIE_C7I_MASK               128U


/*** TIM1_TSCR2 - Timer System Control Register 2; 0x000002AD ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM1_TSCR2STR;
extern volatile TIM1_TSCR2STR _TIM1_TSCR2 @(REG_BASE + 0x000002ADUL);
#define TIM1_TSCR2                      _TIM1_TSCR2.Byte
#define TIM1_TSCR2_PR0                  _TIM1_TSCR2.Bits.PR0
#define TIM1_TSCR2_PR1                  _TIM1_TSCR2.Bits.PR1
#define TIM1_TSCR2_PR2                  _TIM1_TSCR2.Bits.PR2
#define TIM1_TSCR2_TCRE                 _TIM1_TSCR2.Bits.TCRE
#define TIM1_TSCR2_TOI                  _TIM1_TSCR2.Bits.TOI
#define TIM1_TSCR2_PR                   _TIM1_TSCR2.MergedBits.grpPR

#define TIM1_TSCR2_PR0_MASK             1U
#define TIM1_TSCR2_PR1_MASK             2U
#define TIM1_TSCR2_PR2_MASK             4U
#define TIM1_TSCR2_TCRE_MASK            8U
#define TIM1_TSCR2_TOI_MASK             128U
#define TIM1_TSCR2_PR_MASK              7U
#define TIM1_TSCR2_PR_BITNUM            0U


/*** TIM1_TFLG1 - Main Timer Interrupt Flag 1; 0x000002AE ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TIM1_TFLG1STR;
extern volatile TIM1_TFLG1STR _TIM1_TFLG1 @(REG_BASE + 0x000002AEUL);
#define TIM1_TFLG1                      _TIM1_TFLG1.Byte
#define TIM1_TFLG1_C0F                  _TIM1_TFLG1.Bits.C0F
#define TIM1_TFLG1_C1F                  _TIM1_TFLG1.Bits.C1F
#define TIM1_TFLG1_C2F                  _TIM1_TFLG1.Bits.C2F
#define TIM1_TFLG1_C3F                  _TIM1_TFLG1.Bits.C3F
#define TIM1_TFLG1_C4F                  _TIM1_TFLG1.Bits.C4F
#define TIM1_TFLG1_C5F                  _TIM1_TFLG1.Bits.C5F
#define TIM1_TFLG1_C6F                  _TIM1_TFLG1.Bits.C6F
#define TIM1_TFLG1_C7F                  _TIM1_TFLG1.Bits.C7F

#define TIM1_TFLG1_C0F_MASK             1U
#define TIM1_TFLG1_C1F_MASK             2U
#define TIM1_TFLG1_C2F_MASK             4U
#define TIM1_TFLG1_C3F_MASK             8U
#define TIM1_TFLG1_C4F_MASK             16U
#define TIM1_TFLG1_C5F_MASK             32U
#define TIM1_TFLG1_C6F_MASK             64U
#define TIM1_TFLG1_C7F_MASK             128U


/*** TIM1_TFLG2 - Main Timer Interrupt Flag 2; 0x000002AF ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TIM1_TFLG2STR;
extern volatile TIM1_TFLG2STR _TIM1_TFLG2 @(REG_BASE + 0x000002AFUL);
#define TIM1_TFLG2                      _TIM1_TFLG2.Byte
#define TIM1_TFLG2_TOF                  _TIM1_TFLG2.Bits.TOF

#define TIM1_TFLG2_TOF_MASK             128U


/*** TIM1_TC0 - Timer Input Capture/Output Compare Register 0; 0x000002B0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x000002B0 ***/
    union {
      byte Byte;
    } TIM1_TC0HiSTR;
    #define TIM1_TC0Hi                  _TIM1_TC0.Overlap_STR.TIM1_TC0HiSTR.Byte
    

    /*** TIM1_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x000002B1 ***/
    union {
      byte Byte;
    } TIM1_TC0LoSTR;
    #define TIM1_TC0Lo                  _TIM1_TC0.Overlap_STR.TIM1_TC0LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC0STR;
extern volatile TIM1_TC0STR _TIM1_TC0 @(REG_BASE + 0x000002B0UL);
#define TIM1_TC0                        _TIM1_TC0.Word
/* TIM1_TC_ARR: Access 8 TIM1_TCx registers in an array */
#define TIM1_TC_ARR                     ((volatile word *) &TIM1_TC0)


/*** TIM1_TC1 - Timer Input Capture/Output Compare Register 1; 0x000002B2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x000002B2 ***/
    union {
      byte Byte;
    } TIM1_TC1HiSTR;
    #define TIM1_TC1Hi                  _TIM1_TC1.Overlap_STR.TIM1_TC1HiSTR.Byte
    

    /*** TIM1_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x000002B3 ***/
    union {
      byte Byte;
    } TIM1_TC1LoSTR;
    #define TIM1_TC1Lo                  _TIM1_TC1.Overlap_STR.TIM1_TC1LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC1STR;
extern volatile TIM1_TC1STR _TIM1_TC1 @(REG_BASE + 0x000002B2UL);
#define TIM1_TC1                        _TIM1_TC1.Word


/*** TIM1_TC2 - Timer Input Capture/Output Compare Register 2; 0x000002B4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x000002B4 ***/
    union {
      byte Byte;
    } TIM1_TC2HiSTR;
    #define TIM1_TC2Hi                  _TIM1_TC2.Overlap_STR.TIM1_TC2HiSTR.Byte
    

    /*** TIM1_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x000002B5 ***/
    union {
      byte Byte;
    } TIM1_TC2LoSTR;
    #define TIM1_TC2Lo                  _TIM1_TC2.Overlap_STR.TIM1_TC2LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC2STR;
extern volatile TIM1_TC2STR _TIM1_TC2 @(REG_BASE + 0x000002B4UL);
#define TIM1_TC2                        _TIM1_TC2.Word


/*** TIM1_TC3 - Timer Input Capture/Output Compare Register 3; 0x000002B6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x000002B6 ***/
    union {
      byte Byte;
    } TIM1_TC3HiSTR;
    #define TIM1_TC3Hi                  _TIM1_TC3.Overlap_STR.TIM1_TC3HiSTR.Byte
    

    /*** TIM1_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x000002B7 ***/
    union {
      byte Byte;
    } TIM1_TC3LoSTR;
    #define TIM1_TC3Lo                  _TIM1_TC3.Overlap_STR.TIM1_TC3LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC3STR;
extern volatile TIM1_TC3STR _TIM1_TC3 @(REG_BASE + 0x000002B6UL);
#define TIM1_TC3                        _TIM1_TC3.Word


/*** TIM1_TC4 - Timer Input Capture/Output Compare Register 4; 0x000002B8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x000002B8 ***/
    union {
      byte Byte;
    } TIM1_TC4HiSTR;
    #define TIM1_TC4Hi                  _TIM1_TC4.Overlap_STR.TIM1_TC4HiSTR.Byte
    

    /*** TIM1_TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x000002B9 ***/
    union {
      byte Byte;
    } TIM1_TC4LoSTR;
    #define TIM1_TC4Lo                  _TIM1_TC4.Overlap_STR.TIM1_TC4LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC4STR;
extern volatile TIM1_TC4STR _TIM1_TC4 @(REG_BASE + 0x000002B8UL);
#define TIM1_TC4                        _TIM1_TC4.Word


/*** TIM1_TC5 - Timer Input Capture/Output Compare Register 5; 0x000002BA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x000002BA ***/
    union {
      byte Byte;
    } TIM1_TC5HiSTR;
    #define TIM1_TC5Hi                  _TIM1_TC5.Overlap_STR.TIM1_TC5HiSTR.Byte
    

    /*** TIM1_TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x000002BB ***/
    union {
      byte Byte;
    } TIM1_TC5LoSTR;
    #define TIM1_TC5Lo                  _TIM1_TC5.Overlap_STR.TIM1_TC5LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC5STR;
extern volatile TIM1_TC5STR _TIM1_TC5 @(REG_BASE + 0x000002BAUL);
#define TIM1_TC5                        _TIM1_TC5.Word


/*** TIM1_TC6 - Timer Input Capture/Output Compare Register 6; 0x000002BC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x000002BC ***/
    union {
      byte Byte;
    } TIM1_TC6HiSTR;
    #define TIM1_TC6Hi                  _TIM1_TC6.Overlap_STR.TIM1_TC6HiSTR.Byte
    

    /*** TIM1_TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x000002BD ***/
    union {
      byte Byte;
    } TIM1_TC6LoSTR;
    #define TIM1_TC6Lo                  _TIM1_TC6.Overlap_STR.TIM1_TC6LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC6STR;
extern volatile TIM1_TC6STR _TIM1_TC6 @(REG_BASE + 0x000002BCUL);
#define TIM1_TC6                        _TIM1_TC6.Word


/*** TIM1_TC7 - Timer Input Capture/Output Compare Register 7; 0x000002BE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x000002BE ***/
    union {
      byte Byte;
    } TIM1_TC7HiSTR;
    #define TIM1_TC7Hi                  _TIM1_TC7.Overlap_STR.TIM1_TC7HiSTR.Byte
    

    /*** TIM1_TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x000002BF ***/
    union {
      byte Byte;
    } TIM1_TC7LoSTR;
    #define TIM1_TC7Lo                  _TIM1_TC7.Overlap_STR.TIM1_TC7LoSTR.Byte
    
  } Overlap_STR;

} TIM1_TC7STR;
extern volatile TIM1_TC7STR _TIM1_TC7 @(REG_BASE + 0x000002BEUL);
#define TIM1_TC7                        _TIM1_TC7.Word


/*** TIM1_PACTL - 16-Bit Pulse Accumulator A Control Register; 0x000002C0 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TIM1_PACTLSTR;
extern volatile TIM1_PACTLSTR _TIM1_PACTL @(REG_BASE + 0x000002C0UL);
#define TIM1_PACTL                      _TIM1_PACTL.Byte
#define TIM1_PACTL_PAI                  _TIM1_PACTL.Bits.PAI
#define TIM1_PACTL_PAOVI                _TIM1_PACTL.Bits.PAOVI
#define TIM1_PACTL_CLK0                 _TIM1_PACTL.Bits.CLK0
#define TIM1_PACTL_CLK1                 _TIM1_PACTL.Bits.CLK1
#define TIM1_PACTL_PEDGE                _TIM1_PACTL.Bits.PEDGE
#define TIM1_PACTL_PAMOD                _TIM1_PACTL.Bits.PAMOD
#define TIM1_PACTL_PAEN                 _TIM1_PACTL.Bits.PAEN
#define TIM1_PACTL_CLK                  _TIM1_PACTL.MergedBits.grpCLK

#define TIM1_PACTL_PAI_MASK             1U
#define TIM1_PACTL_PAOVI_MASK           2U
#define TIM1_PACTL_CLK0_MASK            4U
#define TIM1_PACTL_CLK1_MASK            8U
#define TIM1_PACTL_PEDGE_MASK           16U
#define TIM1_PACTL_PAMOD_MASK           32U
#define TIM1_PACTL_PAEN_MASK            64U
#define TIM1_PACTL_CLK_MASK             12U
#define TIM1_PACTL_CLK_BITNUM           2U


/*** TIM1_PAFLG - Pulse Accumulator A Flag Register; 0x000002C1 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} TIM1_PAFLGSTR;
extern volatile TIM1_PAFLGSTR _TIM1_PAFLG @(REG_BASE + 0x000002C1UL);
#define TIM1_PAFLG                      _TIM1_PAFLG.Byte
#define TIM1_PAFLG_PAIF                 _TIM1_PAFLG.Bits.PAIF
#define TIM1_PAFLG_PAOVF                _TIM1_PAFLG.Bits.PAOVF

#define TIM1_PAFLG_PAIF_MASK            1U
#define TIM1_PAFLG_PAOVF_MASK           2U


/*** TIM1_PACNT - Pulse Accumulators Count Register; 0x000002C2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TIM1_PACNTH - Pulse Accumulators Count Register High; 0x000002C2 ***/
    union {
      byte Byte;
    } TIM1_PACNTHSTR;
    #define TIM1_PACNTH                 _TIM1_PACNT.Overlap_STR.TIM1_PACNTHSTR.Byte
    

    /*** TIM1_PACNTL - Pulse Accumulators Count Register Low; 0x000002C3 ***/
    union {
      byte Byte;
    } TIM1_PACNTLSTR;
    #define TIM1_PACNTL                 _TIM1_PACNT.Overlap_STR.TIM1_PACNTLSTR.Byte
    
  } Overlap_STR;

} TIM1_PACNTSTR;
extern volatile TIM1_PACNTSTR _TIM1_PACNT @(REG_BASE + 0x000002C2UL);
#define TIM1_PACNT                      _TIM1_PACNT.Word


/*** TIM1_OCPD - Output Compare Pin Disconnect Register; 0x000002CC ***/
typedef union {
  byte Byte;
  struct {
    byte OCPD0       :1;                                       /* Output Compare Pin Disconnect Bit 0 */
    byte OCPD1       :1;                                       /* Output Compare Pin Disconnect Bit 1 */
    byte OCPD2       :1;                                       /* Output Compare Pin Disconnect Bit 2 */
    byte OCPD3       :1;                                       /* Output Compare Pin Disconnect Bit 3 */
    byte OCPD4       :1;                                       /* Output Compare Pin Disconnect Bit 4 */
    byte OCPD5       :1;                                       /* Output Compare Pin Disconnect Bit 5 */
    byte OCPD6       :1;                                       /* Output Compare Pin Disconnect Bit 6 */
    byte OCPD7       :1;                                       /* Output Compare Pin Disconnect Bit 7 */
  } Bits;
} TIM1_OCPDSTR;
extern volatile TIM1_OCPDSTR _TIM1_OCPD @(REG_BASE + 0x000002CCUL);
#define TIM1_OCPD                       _TIM1_OCPD.Byte
#define TIM1_OCPD_OCPD0                 _TIM1_OCPD.Bits.OCPD0
#define TIM1_OCPD_OCPD1                 _TIM1_OCPD.Bits.OCPD1
#define TIM1_OCPD_OCPD2                 _TIM1_OCPD.Bits.OCPD2
#define TIM1_OCPD_OCPD3                 _TIM1_OCPD.Bits.OCPD3
#define TIM1_OCPD_OCPD4                 _TIM1_OCPD.Bits.OCPD4
#define TIM1_OCPD_OCPD5                 _TIM1_OCPD.Bits.OCPD5
#define TIM1_OCPD_OCPD6                 _TIM1_OCPD.Bits.OCPD6
#define TIM1_OCPD_OCPD7                 _TIM1_OCPD.Bits.OCPD7

#define TIM1_OCPD_OCPD0_MASK            1U
#define TIM1_OCPD_OCPD1_MASK            2U
#define TIM1_OCPD_OCPD2_MASK            4U
#define TIM1_OCPD_OCPD3_MASK            8U
#define TIM1_OCPD_OCPD4_MASK            16U
#define TIM1_OCPD_OCPD5_MASK            32U
#define TIM1_OCPD_OCPD6_MASK            64U
#define TIM1_OCPD_OCPD7_MASK            128U


/*** TIM1_PTPSR - Precision Timer Prescaler Select Register; 0x000002CE ***/
typedef union {
  byte Byte;
  struct {
    byte PTPS0       :1;                                       /* Precision Timer Prescaler Select Bit 0 */
    byte PTPS1       :1;                                       /* Precision Timer Prescaler Select Bit 1 */
    byte PTPS2       :1;                                       /* Precision Timer Prescaler Select Bit 2 */
    byte PTPS3       :1;                                       /* Precision Timer Prescaler Select Bit 3 */
    byte PTPS4       :1;                                       /* Precision Timer Prescaler Select Bit 4 */
    byte PTPS5       :1;                                       /* Precision Timer Prescaler Select Bit 5 */
    byte PTPS6       :1;                                       /* Precision Timer Prescaler Select Bit 6 */
    byte PTPS7       :1;                                       /* Precision Timer Prescaler Select Bit 7 */
  } Bits;
} TIM1_PTPSRSTR;
extern volatile TIM1_PTPSRSTR _TIM1_PTPSR @(REG_BASE + 0x000002CEUL);
#define TIM1_PTPSR                      _TIM1_PTPSR.Byte
#define TIM1_PTPSR_PTPS0                _TIM1_PTPSR.Bits.PTPS0
#define TIM1_PTPSR_PTPS1                _TIM1_PTPSR.Bits.PTPS1
#define TIM1_PTPSR_PTPS2                _TIM1_PTPSR.Bits.PTPS2
#define TIM1_PTPSR_PTPS3                _TIM1_PTPSR.Bits.PTPS3
#define TIM1_PTPSR_PTPS4                _TIM1_PTPSR.Bits.PTPS4
#define TIM1_PTPSR_PTPS5                _TIM1_PTPSR.Bits.PTPS5
#define TIM1_PTPSR_PTPS6                _TIM1_PTPSR.Bits.PTPS6
#define TIM1_PTPSR_PTPS7                _TIM1_PTPSR.Bits.PTPS7

#define TIM1_PTPSR_PTPS0_MASK           1U
#define TIM1_PTPSR_PTPS1_MASK           2U
#define TIM1_PTPSR_PTPS2_MASK           4U
#define TIM1_PTPSR_PTPS3_MASK           8U
#define TIM1_PTPSR_PTPS4_MASK           16U
#define TIM1_PTPSR_PTPS5_MASK           32U
#define TIM1_PTPSR_PTPS6_MASK           64U
#define TIM1_PTPSR_PTPS7_MASK           128U


/*** VREGHTCL - HT Control Register; 0x000002F0 ***/
typedef union {
  byte Byte;
  struct {
    byte HTIF        :1;                                       /* High Temperature Interrupt Flag */
    byte HTIE        :1;                                       /* High Temperature Interrupt Enable Bit */
    byte HTDS        :1;                                       /* High Temperature Detect Status Bi */
    byte HTEN        :1;                                       /* High Temperature Enable Bit */
    byte VAE         :1;                                       /* Voltage Access Enable Bit */
    byte VSEL        :1;                                       /* Voltage Access Select Bit */
    byte             :1; 
    byte             :1; 
  } Bits;
} VREGHTCLSTR;
extern volatile VREGHTCLSTR _VREGHTCL @(REG_BASE + 0x000002F0UL);
#define VREGHTCL                        _VREGHTCL.Byte
#define VREGHTCL_HTIF                   _VREGHTCL.Bits.HTIF
#define VREGHTCL_HTIE                   _VREGHTCL.Bits.HTIE
#define VREGHTCL_HTDS                   _VREGHTCL.Bits.HTDS
#define VREGHTCL_HTEN                   _VREGHTCL.Bits.HTEN
#define VREGHTCL_VAE                    _VREGHTCL.Bits.VAE
#define VREGHTCL_VSEL                   _VREGHTCL.Bits.VSEL

#define VREGHTCL_HTIF_MASK              1U
#define VREGHTCL_HTIE_MASK              2U
#define VREGHTCL_HTDS_MASK              4U
#define VREGHTCL_HTEN_MASK              8U
#define VREGHTCL_VAE_MASK               16U
#define VREGHTCL_VSEL_MASK              32U


/*** VREGCTRL - Control Register; 0x000002F1 ***/
typedef union {
  byte Byte;
  struct {
    byte LVIF        :1;                                       /* Low-Voltage Interrupt Flag */
    byte LVIE        :1;                                       /* Low-Voltage Interrupt Enable Bit */
    byte LVDS        :1;                                       /* Low-Voltage Detect Status Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} VREGCTRLSTR;
extern volatile VREGCTRLSTR _VREGCTRL @(REG_BASE + 0x000002F1UL);
#define VREGCTRL                        _VREGCTRL.Byte
#define VREGCTRL_LVIF                   _VREGCTRL.Bits.LVIF
#define VREGCTRL_LVIE                   _VREGCTRL.Bits.LVIE
#define VREGCTRL_LVDS                   _VREGCTRL.Bits.LVDS

#define VREGCTRL_LVIF_MASK              1U
#define VREGCTRL_LVIE_MASK              2U
#define VREGCTRL_LVDS_MASK              4U


/*** VREGAPICL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***/
typedef union {
  byte Byte;
  struct {
    byte APIF        :1;                                       /* Autonomous Periodical Interrupt Flag */
    byte APIE        :1;                                       /* Autonomous Periodical Interrupt Enable Bit */
    byte APIFE       :1;                                       /* Autonomous Periodical Interrupt Feature Enable Bit */
    byte APIEA       :1;                                       /* Autonomous Periodical Interrupt External Access Enable Bit */
    byte APIES       :1;                                       /* Autonomous Periodical Interrupt External Select Bit */
    byte             :1; 
    byte             :1; 
    byte APICLK      :1;                                       /* Autonomous Periodical Interrupt Clock Select Bit */
  } Bits;
} VREGAPICLSTR;
extern volatile VREGAPICLSTR _VREGAPICL @(REG_BASE + 0x000002F2UL);
#define VREGAPICL                       _VREGAPICL.Byte
#define VREGAPICL_APIF                  _VREGAPICL.Bits.APIF
#define VREGAPICL_APIE                  _VREGAPICL.Bits.APIE
#define VREGAPICL_APIFE                 _VREGAPICL.Bits.APIFE
#define VREGAPICL_APIEA                 _VREGAPICL.Bits.APIEA
#define VREGAPICL_APIES                 _VREGAPICL.Bits.APIES
#define VREGAPICL_APICLK                _VREGAPICL.Bits.APICLK

#define VREGAPICL_APIF_MASK             1U
#define VREGAPICL_APIE_MASK             2U
#define VREGAPICL_APIFE_MASK            4U
#define VREGAPICL_APIEA_MASK            8U
#define VREGAPICL_APIES_MASK            16U
#define VREGAPICL_APICLK_MASK           128U


/*** VREGAPITR - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte APITR0      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 0 */
    byte APITR1      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 1 */
    byte APITR2      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 2 */
    byte APITR3      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 3 */
    byte APITR4      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 4 */
    byte APITR5      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 5 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpAPITR :6;
  } MergedBits;
} VREGAPITRSTR;
extern volatile VREGAPITRSTR _VREGAPITR @(REG_BASE + 0x000002F3UL);
#define VREGAPITR                       _VREGAPITR.Byte
#define VREGAPITR_APITR0                _VREGAPITR.Bits.APITR0
#define VREGAPITR_APITR1                _VREGAPITR.Bits.APITR1
#define VREGAPITR_APITR2                _VREGAPITR.Bits.APITR2
#define VREGAPITR_APITR3                _VREGAPITR.Bits.APITR3
#define VREGAPITR_APITR4                _VREGAPITR.Bits.APITR4
#define VREGAPITR_APITR5                _VREGAPITR.Bits.APITR5
#define VREGAPITR_APITR                 _VREGAPITR.MergedBits.grpAPITR

#define VREGAPITR_APITR0_MASK           4U
#define VREGAPITR_APITR1_MASK           8U
#define VREGAPITR_APITR2_MASK           16U
#define VREGAPITR_APITR3_MASK           32U
#define VREGAPITR_APITR4_MASK           64U
#define VREGAPITR_APITR5_MASK           128U
#define VREGAPITR_APITR_MASK            252U
#define VREGAPITR_APITR_BITNUM          2U


/*** VREGAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** VREGAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***/
    union {
      byte Byte;
      struct {
        byte APIR8       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 8 */
        byte APIR9       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 9 */
        byte APIR10      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 10 */
        byte APIR11      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 11 */
        byte APIR12      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 12 */
        byte APIR13      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 13 */
        byte APIR14      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 14 */
        byte APIR15      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 15 */
      } Bits;
    } VREGAPIRHSTR;
    #define VREGAPIRH                   _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Byte
    #define VREGAPIRH_APIR8             _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR8
    #define VREGAPIRH_APIR9             _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR9
    #define VREGAPIRH_APIR10            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR10
    #define VREGAPIRH_APIR11            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR11
    #define VREGAPIRH_APIR12            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR12
    #define VREGAPIRH_APIR13            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR13
    #define VREGAPIRH_APIR14            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR14
    #define VREGAPIRH_APIR15            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR15
    
    #define VREGAPIRH_APIR8_MASK        1U
    #define VREGAPIRH_APIR9_MASK        2U
    #define VREGAPIRH_APIR10_MASK       4U
    #define VREGAPIRH_APIR11_MASK       8U
    #define VREGAPIRH_APIR12_MASK       16U
    #define VREGAPIRH_APIR13_MASK       32U
    #define VREGAPIRH_APIR14_MASK       64U
    #define VREGAPIRH_APIR15_MASK       128U
    

    /*** VREGAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***/
    union {
      byte Byte;
      struct {
        byte APIR0       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 0 */
        byte APIR1       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 1 */
        byte APIR2       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 2 */
        byte APIR3       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 3 */
        byte APIR4       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 4 */
        byte APIR5       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 5 */
        byte APIR6       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 6 */
        byte APIR7       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 7 */
      } Bits;
    } VREGAPIRLSTR;
    #define VREGAPIRL                   _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Byte
    #define VREGAPIRL_APIR0             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR0
    #define VREGAPIRL_APIR1             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR1
    #define VREGAPIRL_APIR2             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR2
    #define VREGAPIRL_APIR3             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR3
    #define VREGAPIRL_APIR4             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR4
    #define VREGAPIRL_APIR5             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR5
    #define VREGAPIRL_APIR6             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR6
    #define VREGAPIRL_APIR7             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR7
    
    #define VREGAPIRL_APIR0_MASK        1U
    #define VREGAPIRL_APIR1_MASK        2U
    #define VREGAPIRL_APIR2_MASK        4U
    #define VREGAPIRL_APIR3_MASK        8U
    #define VREGAPIRL_APIR4_MASK        16U
    #define VREGAPIRL_APIR5_MASK        32U
    #define VREGAPIRL_APIR6_MASK        64U
    #define VREGAPIRL_APIR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word APIR0       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 0 */
    word APIR1       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 1 */
    word APIR2       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 2 */
    word APIR3       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 3 */
    word APIR4       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 4 */
    word APIR5       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 5 */
    word APIR6       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 6 */
    word APIR7       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 7 */
    word APIR8       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 8 */
    word APIR9       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 9 */
    word APIR10      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 10 */
    word APIR11      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 11 */
    word APIR12      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 12 */
    word APIR13      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 13 */
    word APIR14      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 14 */
    word APIR15      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 15 */
  } Bits;
} VREGAPIRSTR;
extern volatile VREGAPIRSTR _VREGAPIR @(REG_BASE + 0x000002F4UL);
#define VREGAPIR                        _VREGAPIR.Word
#define VREGAPIR_APIR0                  _VREGAPIR.Bits.APIR0
#define VREGAPIR_APIR1                  _VREGAPIR.Bits.APIR1
#define VREGAPIR_APIR2                  _VREGAPIR.Bits.APIR2
#define VREGAPIR_APIR3                  _VREGAPIR.Bits.APIR3
#define VREGAPIR_APIR4                  _VREGAPIR.Bits.APIR4
#define VREGAPIR_APIR5                  _VREGAPIR.Bits.APIR5
#define VREGAPIR_APIR6                  _VREGAPIR.Bits.APIR6
#define VREGAPIR_APIR7                  _VREGAPIR.Bits.APIR7
#define VREGAPIR_APIR8                  _VREGAPIR.Bits.APIR8
#define VREGAPIR_APIR9                  _VREGAPIR.Bits.APIR9
#define VREGAPIR_APIR10                 _VREGAPIR.Bits.APIR10
#define VREGAPIR_APIR11                 _VREGAPIR.Bits.APIR11
#define VREGAPIR_APIR12                 _VREGAPIR.Bits.APIR12
#define VREGAPIR_APIR13                 _VREGAPIR.Bits.APIR13
#define VREGAPIR_APIR14                 _VREGAPIR.Bits.APIR14
#define VREGAPIR_APIR15                 _VREGAPIR.Bits.APIR15

#define VREGAPIR_APIR0_MASK             1U
#define VREGAPIR_APIR1_MASK             2U
#define VREGAPIR_APIR2_MASK             4U
#define VREGAPIR_APIR3_MASK             8U
#define VREGAPIR_APIR4_MASK             16U
#define VREGAPIR_APIR5_MASK             32U
#define VREGAPIR_APIR6_MASK             64U
#define VREGAPIR_APIR7_MASK             128U
#define VREGAPIR_APIR8_MASK             256U
#define VREGAPIR_APIR9_MASK             512U
#define VREGAPIR_APIR10_MASK            1024U
#define VREGAPIR_APIR11_MASK            2048U
#define VREGAPIR_APIR12_MASK            4096U
#define VREGAPIR_APIR13_MASK            8192U
#define VREGAPIR_APIR14_MASK            16384U
#define VREGAPIR_APIR15_MASK            32768U


/*** VREGHTTR - HTTrimming Register; 0x000002F7 ***/
typedef union {
  byte Byte;
  struct {
    byte HTTR        :4;                                       /* High Temperature Trimming Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte HTOEN       :1;                                       /* High Temperature Offeset Enable Bit */
  } Bits;
} VREGHTTRSTR;
extern volatile VREGHTTRSTR _VREGHTTR @(REG_BASE + 0x000002F7UL);
#define VREGHTTR                        _VREGHTTR.Byte
#define VREGHTTR_HTTR                   _VREGHTTR.Bits.HTTR
#define VREGHTTR_HTOEN                  _VREGHTTR.Bits.HTOEN

#define VREGHTTR_HTTR_MASK              15U
#define VREGHTTR_HTTR_BITNUM            0U
#define VREGHTTR_HTOEN_MASK             128U


/*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***/
typedef union {
  word Word;
  struct {
    word KEY         :16;                                      /* Backdoor Comparison Key Bits */
  } Bits;
} BAKEY0STR;
/* Tip for register initialization in the user code:  const word BAKEY0_INIT @0x0000FF00 = <BAKEY0_INITVAL>; */
#define _BAKEY0 (*(const BAKEY0STR *)0x0000FF00)
#define BAKEY0                          _BAKEY0.Word
#define BAKEY0_KEY                      _BAKEY0.Bits.KEY
/* BAKEY_ARR: Access 4 BAKEYx registers in an array */
#define BAKEY_ARR                       ((volatile word *) &BAKEY0)

#define BAKEY0_KEY_MASK                 65535U
#define BAKEY0_KEY_BITNUM               0U


/*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***/
typedef union {
  word Word;
  struct {
    word KEY         :16;                                      /* Backdoor Comparison Key Bits */
  } Bits;
} BAKEY1STR;
/* Tip for register initialization in the user code:  const word BAKEY1_INIT @0x0000FF02 = <BAKEY1_INITVAL>; */
#define _BAKEY1 (*(const BAKEY1STR *)0x0000FF02)
#define BAKEY1                          _BAKEY1.Word
#define BAKEY1_KEY                      _BAKEY1.Bits.KEY

#define BAKEY1_KEY_MASK                 65535U
#define BAKEY1_KEY_BITNUM               0U


/*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***/
typedef union {
  word Word;
  struct {
    word KEY         :16;                                      /* Backdoor Comparison Key Bits */
  } Bits;
} BAKEY2STR;
/* Tip for register initialization in the user code:  const word BAKEY2_INIT @0x0000FF04 = <BAKEY2_INITVAL>; */
#define _BAKEY2 (*(const BAKEY2STR *)0x0000FF04)
#define BAKEY2                          _BAKEY2.Word
#define BAKEY2_KEY                      _BAKEY2.Bits.KEY

#define BAKEY2_KEY_MASK                 65535U
#define BAKEY2_KEY_BITNUM               0U


/*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***/
typedef union {
  word Word;
  struct {
    word KEY         :16;                                      /* Backdoor Comparison Key Bits */
  } Bits;
} BAKEY3STR;
/* Tip for register initialization in the user code:  const word BAKEY3_INIT @0x0000FF06 = <BAKEY3_INITVAL>; */
#define _BAKEY3 (*(const BAKEY3STR *)0x0000FF06)
#define BAKEY3                          _BAKEY3.Word
#define BAKEY3_KEY                      _BAKEY3.Bits.KEY

#define BAKEY3_KEY_MASK                 65535U
#define BAKEY3_KEY_BITNUM               0U


/*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address Size Bit 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address Size Bit 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower Address Range Disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher Address Size Bit 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher Address Size Bit 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher Address Range Disable */
    byte RNV6        :1;                                       /* Reserved Nonvolatile Bit */
    byte FPOPEN      :1;                                       /* Flash Protection Operation Enable */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} NVFPROTSTR;
/* Tip for register initialization in the user code:  const byte NVFPROT_INIT @0x0000FF0C = <NVFPROT_INITVAL>; */
#define _NVFPROT (*(const NVFPROTSTR *)0x0000FF0C)
#define NVFPROT                         _NVFPROT.Byte
#define NVFPROT_FPLS0                   _NVFPROT.Bits.FPLS0
#define NVFPROT_FPLS1                   _NVFPROT.Bits.FPLS1
#define NVFPROT_FPLDIS                  _NVFPROT.Bits.FPLDIS
#define NVFPROT_FPHS0                   _NVFPROT.Bits.FPHS0
#define NVFPROT_FPHS1                   _NVFPROT.Bits.FPHS1
#define NVFPROT_FPHDIS                  _NVFPROT.Bits.FPHDIS
#define NVFPROT_RNV6                    _NVFPROT.Bits.RNV6
#define NVFPROT_FPOPEN                  _NVFPROT.Bits.FPOPEN
#define NVFPROT_FPLS                    _NVFPROT.MergedBits.grpFPLS
#define NVFPROT_FPHS                    _NVFPROT.MergedBits.grpFPHS

#define NVFPROT_FPLS0_MASK              1U
#define NVFPROT_FPLS1_MASK              2U
#define NVFPROT_FPLDIS_MASK             4U
#define NVFPROT_FPHS0_MASK              8U
#define NVFPROT_FPHS1_MASK              16U
#define NVFPROT_FPHDIS_MASK             32U
#define NVFPROT_RNV6_MASK               64U
#define NVFPROT_FPOPEN_MASK             128U
#define NVFPROT_FPLS_MASK               3U
#define NVFPROT_FPLS_BITNUM             0U
#define NVFPROT_FPHS_MASK               24U
#define NVFPROT_FPHS_BITNUM             3U


/*** NVDFPROT - Non Volatile D-Flash Protection Register; 0x0000FF0D ***/
typedef union {
  byte Byte;
  struct {
    byte DPS0        :1;                                       /* D-Flash Protection Size Bit 0 */
    byte DPS1        :1;                                       /* D-Flash Protection Size Bit 1 */
    byte DPS2        :1;                                       /* D-Flash Protection Size Bit 2 */
    byte DPS3        :1;                                       /* D-Flash Protection Size Bit 3 */
    byte DPS4        :1;                                       /* D-Flash Protection Size Bit 4 */
    byte             :1; 
    byte             :1; 
    byte DPOPEN      :1;                                       /* D-Flash Protection Control */
  } Bits;
  struct {
    byte grpDPS  :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NVDFPROTSTR;
/* Tip for register initialization in the user code:  const byte NVDFPROT_INIT @0x0000FF0D = <NVDFPROT_INITVAL>; */
#define _NVDFPROT (*(const NVDFPROTSTR *)0x0000FF0D)
#define NVDFPROT                        _NVDFPROT.Byte
#define NVDFPROT_DPS0                   _NVDFPROT.Bits.DPS0
#define NVDFPROT_DPS1                   _NVDFPROT.Bits.DPS1
#define NVDFPROT_DPS2                   _NVDFPROT.Bits.DPS2
#define NVDFPROT_DPS3                   _NVDFPROT.Bits.DPS3
#define NVDFPROT_DPS4                   _NVDFPROT.Bits.DPS4
#define NVDFPROT_DPOPEN                 _NVDFPROT.Bits.DPOPEN
#define NVDFPROT_DPS                    _NVDFPROT.MergedBits.grpDPS

#define NVDFPROT_DPS0_MASK              1U
#define NVDFPROT_DPS1_MASK              2U
#define NVDFPROT_DPS2_MASK              4U
#define NVDFPROT_DPS3_MASK              8U
#define NVDFPROT_DPS4_MASK              16U
#define NVDFPROT_DPOPEN_MASK            128U
#define NVDFPROT_DPS_MASK               31U
#define NVDFPROT_DPS_BITNUM             0U


/*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Nonvolatile Bit 0 */
    byte NV1         :1;                                       /* Nonvolatile Bit 1 */
    byte NV2         :1;                                       /* Nonvolatile Bit 2 */
    byte NV3         :1;                                       /* Nonvolatile Bit 3 */
    byte NV4         :1;                                       /* Nonvolatile Bit 4 */
    byte NV5         :1;                                       /* Nonvolatile Bit 5 */
    byte NV6         :1;                                       /* Nonvolatile Bit 6 */
    byte NV7         :1;                                       /* Nonvolatile Bit 7 */
  } Bits;
} NVFOPTSTR;
/* Tip for register initialization in the user code:  const byte NVFOPT_INIT @0x0000FF0E = <NVFOPT_INITVAL>; */
#define _NVFOPT (*(const NVFOPTSTR *)0x0000FF0E)
#define NVFOPT                          _NVFOPT.Byte
#define NVFOPT_NV0                      _NVFOPT.Bits.NV0
#define NVFOPT_NV1                      _NVFOPT.Bits.NV1
#define NVFOPT_NV2                      _NVFOPT.Bits.NV2
#define NVFOPT_NV3                      _NVFOPT.Bits.NV3
#define NVFOPT_NV4                      _NVFOPT.Bits.NV4
#define NVFOPT_NV5                      _NVFOPT.Bits.NV5
#define NVFOPT_NV6                      _NVFOPT.Bits.NV6
#define NVFOPT_NV7                      _NVFOPT.Bits.NV7

#define NVFOPT_NV0_MASK                 1U
#define NVFOPT_NV1_MASK                 2U
#define NVFOPT_NV2_MASK                 4U
#define NVFOPT_NV3_MASK                 8U
#define NVFOPT_NV4_MASK                 16U
#define NVFOPT_NV5_MASK                 32U
#define NVFOPT_NV6_MASK                 64U
#define NVFOPT_NV7_MASK                 128U


/*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte RNV2        :1;                                       /* Reserved Nonvolatile Bit 2 */
    byte RNV3        :1;                                       /* Reserved Nonvolatile Bit 3 */
    byte RNV4        :1;                                       /* Reserved Nonvolatile Bit 4 */
    byte RNV5        :1;                                       /* Reserved Nonvolatile Bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} NVFSECSTR;
/* Tip for register initialization in the user code:  const byte NVFSEC_INIT @0x0000FF0F = <NVFSEC_INITVAL>; */
#define _NVFSEC (*(const NVFSECSTR *)0x0000FF0F)
#define NVFSEC  