/* Based on CPU DB MC9S12XFR128_144, version 2.87.168 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12xfr128.h
**     Processor : MC9S12XFR128CFVE
**     FileFormat: V2.32
**     DataSheet : MC9S12XFR128 7Rev. 1.18 18 April 2006
**     Compiler  : CodeWarrior compiler
**     Date/Time : 7.6.2010, 15:33
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 16.01.2006, V2.87.007:
**              - Added bit PTJ_PTJ3
**              - Added bit PTIJ_PTIJ3
**              - Added bit DDRJ_DDRJ3
**              - Added bit RDRJ_RDRJ3
**              - Added bit PERJ_PERJ3
**              - Added bit PPSJ_PPSJ3
**              - Added register STBSCR
**              - Corrected register PIER0 address (0x41A ==>0x41C) 
**              - Corrected register PIER1 address (0x41C ==>0x41E) 
**              - Reason:
**              - Bug-fix (#2918 in Issue Manager), Bugs in 9S12XFRFAMPP Rev. 1.04, 3-Mar-200
**      - 03.07.2006, V2.87.053:
**              - Added register ATD1TEST1. REASON: Bug-fix (#3471  in Issue Manager)
**      - 12.07.2006, V2.87.062:
**              - Added bit 15 to PMFVALx registers. REASON: Bug-fix (#3494 in Issue Manager)
**      - 13.07.2006, V2.87.065:
**              - Removed register MODRR. REASON: Bug-fix (#3496 in Issue Manager)
**      - 03.09.2007, V2.87.107:
**              - Renamed groups XGCHID_XGCHIDGrp ==> XGCHID_XGCHID,  XGVBR_XGVBRGrp ==> XGVBR_XGVBR, XGSWT_XGSWTGrp ==> XGSWT_XGSWT, XGSEM_XGSEMGrp ==> XGSEM_XGSEM, Renamed registers XGIFn ==> XGIF_nF_n0.
**              -   REASON: Bug-fix (#5180 in Issue Manager).
**              - Removed bits PAxH_BIT0..BIT7/15, TCxH..BIT0..BIT7/15.
**              -   REASON: Access to the individual bits is not necessary (issue #5192 in Issue Manager).
**              - Added register DBGMFR.
**              -   REASON: Bug-fix (#5173 in Issue Manager).
**      - 04.09.2007, V2.87.110:
**              - Added bit DBGXCTL_BRK,  Renamed bits DBGXDH_BIT0..7 ==> DBGXDH_BIT8..15.
**              -   REASON: Bug-fix (#5173 in Issue Manager).
**      - 08.10.2007, V2.87.140:
**              - Renamed bits/groups SCIxCR2_SCTIE ==> SCIxCR2_TIE, INT_CFADDR[INT_CFADDRGrp] ==> INT_CFADDR[INT_CFADDR], EDATAHI/LO_EDATAHI/LO ==> EDATAHI/LO_EDHI/LO,
**              - NVFPROT_NV6 ==> NVFPROT_RNV6, PIER0/1[BITx_EN ] ==> PIER0/1[BITx_IE],PMFCNTA/B/C[PMFCNT] ==> PMFCNTA/B/C[PMFCNTA/B/C]
**              - PMFDTMA/B/C[PMFDTM] ==> PMFDTMA/B/C[PMFDTMA/B/C], PMFMODA/B/C[PMFMOD] ==> PMFMODA/B/C[PMFMODA/B/C], MCR_CLKSELbit_ ==> MCR_CLKSEL.
**              - Corrected register NVFSEC.
**              - Removed bit EADDRHI_EABHI2.
**              - Added bits ESTAT_FAIL, FSTAT_FAIL, FCNFG_BKSEL.
**              - Added registers EADDR, EDATA, FADDR, FDATA, FCTL, NVFCTL.
**              - Renamed interrupt vector Vatd ==> Vatd1.
**              -   REASON: Bug-fix (#5343 in Issue Manager).
**      - 14.11.2008, V2.87.168:
**              - Corrected definition of depreciated symbols.
**              -   REASON: Bug-fix(#6592 in Issue Manager).
**
**     File-Format-Revisions:
**      - 27.10.2006, V2.10 :
**               - __RESET_WATCHDOG improved formating and re-definition
**      - 23.11.2006, V2.11 :
**               - Changes have not affected this file (because they are related to another family)
**      - 22.01.2007, V2.12 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
**      - 01.03.2007, V2.13 :
**               - Flash commands constants values converted to HEX format
**      - 02.03.2007, V2.14 :
**               - Interrupt vector numbers added into .H, see VectorNumber_*
**      - 26.03.2007, V2.15 :
**               - Changes have not affected this file (because they are related to another family)
**      - 10.05.2007, V2.16 :
**               - Changes have not affected this file (because they are related to another family)
**      - 05.06.2007, V2.17 :
**               - Changes have not affected this file (because they are related to another family)
**      - 19.07.2007, V2.18 :
**               - Improved number of blanked lines inside register structures
**      - 06.08.2007, V2.19 :
**               - CPUDB revisions generated ahead of the file-format revisions.
**      - 11.09.2007, V2.20 :
**               - Added comment about initialization of unbonded pins.
**      - 02.01.2008, V2.21 :
**               - Changes have not affected this file (because they are related to another family)
**      - 13.02.2008, V2.22 :
**               - Changes have not affected this file (because they are related to another family)
**      - 20.02.2008, V2.23 :
**               - Termination of pragma V30toV31Compatible added, #5708
**      - 03.07.2008, V2.24 :
**               - Added support for bits with name starting with number (like "1HZ")
**      - 28.11.2008, V2.25 :
**               - StandBy RAM array declaration for ANSI-C added
**      - 1.12.2008, V2.26 :
**               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
**      - 17.3.2009, V2.27 :
**               - Merged bit-group is not generated, if the name matches with another bit name in the register
**      - 6.4.2009, V2.28 :
**               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
**      - 3.8.2009, V2.29 :
**               - If there is just one bits group matching register name, single bits are not generated
**      - 10.9.2009, V2.30 :
**               - Fixed generation of registers arrays.
**      - 15.10.2009, V2.31 :
**               - Changes have not affected this file (because they are related to another family)
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12XFR128_H
#define _MC9S12XFR128_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/*lint -save  -e621 Disable MISRA rule (5.1) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vsi                119U
#define VectorNumber_Reserved119        118U
#define VectorNumber_Reserved118        117U
#define VectorNumber_Reserved117        116U
#define VectorNumber_Reserved116        115U
#define VectorNumber_Reserved115        114U
#define VectorNumber_Reserved114        113U
#define VectorNumber_Reserved113        112U
#define VectorNumber_Reserved112        111U
#define VectorNumber_Reserved111        110U
#define VectorNumber_Reserved110        109U
#define VectorNumber_Reserved109        108U
#define VectorNumber_Reserved108        107U
#define VectorNumber_Reserved107        106U
#define VectorNumber_Reserved106        105U
#define VectorNumber_Reserved105        104U
#define VectorNumber_Reserved104        103U
#define VectorNumber_Reserved103        102U
#define VectorNumber_Reserved102        101U
#define VectorNumber_Reserved101        100U
#define VectorNumber_Reserved100        99U
#define VectorNumber_Reserved99         98U
#define VectorNumber_Reserved98         97U
#define VectorNumber_Reserved97         96U
#define VectorNumber_Reserved96         95U
#define VectorNumber_Reserved95         94U
#define VectorNumber_Reserved94         93U
#define VectorNumber_Reserved93         92U
#define VectorNumber_Reserved92         91U
#define VectorNumber_Reserved91         90U
#define VectorNumber_Reserved90         89U
#define VectorNumber_Reserved89         88U
#define VectorNumber_Reserved88         87U
#define VectorNumber_Reserved87         86U
#define VectorNumber_Reserved86         85U
#define VectorNumber_Reserved85         84U
#define VectorNumber_Reserved84         83U
#define VectorNumber_Reserved83         82U
#define VectorNumber_Reserved82         81U
#define VectorNumber_Reserved81         80U
#define VectorNumber_Vxsramav           79U
#define VectorNumber_Vxsei              78U
#define VectorNumber_Vxst7              77U
#define VectorNumber_Vxst6              76U
#define VectorNumber_Vxst5              75U
#define VectorNumber_Vxst4              74U
#define VectorNumber_Vxst3              73U
#define VectorNumber_Vxst2              72U
#define VectorNumber_Vxst1              71U
#define VectorNumber_Vxst0              70U
#define VectorNumber_Vpit3              69U
#define VectorNumber_Vpit2              68U
#define VectorNumber_Vpit1              67U
#define VectorNumber_Vpit0              66U
#define VectorNumber_VReserved65        65U
#define VectorNumber_Vapi               64U
#define VectorNumber_Vlvi               63U
#define VectorNumber_VReserved62        62U
#define VectorNumber_VReserved61        61U
#define VectorNumber_VReserved60        60U
#define VectorNumber_VReserved59        59U
#define VectorNumber_VReserved58        58U
#define VectorNumber_Vpmffault3         57U
#define VectorNumber_Vpmffault2         56U
#define VectorNumber_Vpmffault1         55U
#define VectorNumber_Vpmffault0         54U
#define VectorNumber_Vpmfgcr            53U
#define VectorNumber_Vpmfgbr            52U
#define VectorNumber_Vpmfgar            51U
#define VectorNumber_Vfrprot            50U
#define VectorNumber_Vfrchi             49U
#define VectorNumber_Vfrwakeup          48U
#define VectorNumber_Vfrrxfifob         47U
#define VectorNumber_Vfrrxfifoa         46U
#define VectorNumber_Vfrrxmessbuff      45U
#define VectorNumber_Vfrtxmessbuff      44U
#define VectorNumber_VReserved43        43U
#define VectorNumber_VReserved42        42U
#define VectorNumber_VReserved41        41U
#define VectorNumber_VReserved40        40U
#define VectorNumber_Vcan0tx            39U
#define VectorNumber_Vcan0rx            38U
#define VectorNumber_Vcan0err           37U
#define VectorNumber_Vcan0wkup          36U
#define VectorNumber_Vflash             35U
#define VectorNumber_Veeprom            34U
#define VectorNumber_VReserved33        33U
#define VectorNumber_Vspi1              32U
#define VectorNumber_VReserved31        31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_Vcrgscm            29U
#define VectorNumber_Vcrgplllck         28U
#define VectorNumber_Vtimpabovf         27U
#define VectorNumber_Vtimmdcu           26U
#define VectorNumber_VReserved25        25U
#define VectorNumber_VReserved24        24U
#define VectorNumber_Vatd1              23U
#define VectorNumber_VReserved22        22U
#define VectorNumber_Vsci1              21U
#define VectorNumber_Vsci0              20U
#define VectorNumber_Vspi0              19U
#define VectorNumber_Vtimpaie           18U
#define VectorNumber_Vtimpaaovf         17U
#define VectorNumber_Vtimovf            16U
#define VectorNumber_Vtimch7            15U
#define VectorNumber_Vtimch6            14U
#define VectorNumber_Vtimch5            13U
#define VectorNumber_Vtimch4            12U
#define VectorNumber_Vtimch3            11U
#define VectorNumber_Vtimch2            10U
#define VectorNumber_Vtimch1            9U
#define VectorNumber_Vtimch0            8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Virq               6U
#define VectorNumber_Vxirq              5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define Vsi                             0xFF10U
#define Reserved119                     0xFF12U
#define Reserved118                     0xFF14U
#define Reserved117                     0xFF16U
#define Reserved116                     0xFF18U
#define Reserved115                     0xFF1AU
#define Reserved114                     0xFF1CU
#define Reserved113                     0xFF1EU
#define Reserved112                     0xFF20U
#define Reserved111                     0xFF22U
#define Reserved110                     0xFF24U
#define Reserved109                     0xFF26U
#define Reserved108                     0xFF28U
#define Reserved107                     0xFF2AU
#define Reserved106                     0xFF2CU
#define Reserved105                     0xFF2EU
#define Reserved104                     0xFF30U
#define Reserved103                     0xFF32U
#define Reserved102                     0xFF34U
#define Reserved101                     0xFF36U
#define Reserved100                     0xFF38U
#define Reserved99                      0xFF3AU
#define Reserved98                      0xFF3CU
#define Reserved97                      0xFF3EU
#define Reserved96                      0xFF40U
#define Reserved95                      0xFF42U
#define Reserved94                      0xFF44U
#define Reserved93                      0xFF46U
#define Reserved92                      0xFF48U
#define Reserved91                      0xFF4AU
#define Reserved90                      0xFF4CU
#define Reserved89                      0xFF4EU
#define Reserved88                      0xFF50U
#define Reserved87                      0xFF52U
#define Reserved86                      0xFF54U
#define Reserved85                      0xFF56U
#define Reserved84                      0xFF58U
#define Reserved83                      0xFF5AU
#define Reserved82                      0xFF5CU
#define Reserved81                      0xFF5EU
#define Vxsramav                        0xFF60U
#define Vxsei                           0xFF62U
#define Vxst7                           0xFF64U
#define Vxst6                           0xFF66U
#define Vxst5                           0xFF68U
#define Vxst4                           0xFF6AU
#define Vxst3                           0xFF6CU
#define Vxst2                           0xFF6EU
#define Vxst1                           0xFF70U
#define Vxst0                           0xFF72U
#define Vpit3                           0xFF74U
#define Vpit2                           0xFF76U
#define Vpit1                           0xFF78U
#define Vpit0                           0xFF7AU
#define VReserved65                     0xFF7CU
#define Vapi                            0xFF7EU
#define Vlvi                            0xFF80U
#define VReserved62                     0xFF82U
#define VReserved61                     0xFF84U
#define VReserved60                     0xFF86U
#define VReserved59                     0xFF88U
#define VReserved58                     0xFF8AU
#define Vpmffault3                      0xFF8CU
#define Vpmffault2                      0xFF8EU
#define Vpmffault1                      0xFF90U
#define Vpmffault0                      0xFF92U
#define Vpmfgcr                         0xFF94U
#define Vpmfgbr                         0xFF96U
#define Vpmfgar                         0xFF98U
#define Vfrprot                         0xFF9AU
#define Vfrchi                          0xFF9CU
#define Vfrwakeup                       0xFF9EU
#define Vfrrxfifob                      0xFFA0U
#define Vfrrxfifoa                      0xFFA2U
#define Vfrrxmessbuff                   0xFFA4U
#define Vfrtxmessbuff                   0xFFA6U
#define VReserved43                     0xFFA8U
#define VReserved42                     0xFFAAU
#define VReserved41                     0xFFACU
#define VReserved40                     0xFFAEU
#define Vcan0tx                         0xFFB0U
#define Vcan0rx                         0xFFB2U
#define Vcan0err                        0xFFB4U
#define Vcan0wkup                       0xFFB6U
#define Vflash                          0xFFB8U
#define Veeprom                         0xFFBAU
#define VReserved33                     0xFFBCU
#define Vspi1                           0xFFBEU
#define VReserved31                     0xFFC0U
#define VReserved30                     0xFFC2U
#define Vcrgscm                         0xFFC4U
#define Vcrgplllck                      0xFFC6U
#define Vtimpabovf                      0xFFC8U
#define Vtimmdcu                        0xFFCAU
#define VReserved25                     0xFFCCU
#define VReserved24                     0xFFCEU
#define Vatd1                           0xFFD0U
#define VReserved22                     0xFFD2U
#define Vsci1                           0xFFD4U
#define Vsci0                           0xFFD6U
#define Vspi0                           0xFFD8U
#define Vtimpaie                        0xFFDAU
#define Vtimpaaovf                      0xFFDCU
#define Vtimovf                         0xFFDEU
#define Vtimch7                         0xFFE0U
#define Vtimch6                         0xFFE2U
#define Vtimch5                         0xFFE4U
#define Vtimch4                         0xFFE6U
#define Vtimch3                         0xFFE8U
#define Vtimch2                         0xFFEAU
#define Vtimch1                         0xFFECU
#define Vtimch0                         0xFFEEU
#define Vrti                            0xFFF0U
#define Virq                            0xFFF2U
#define Vxirq                           0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTAB - Port AB; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte PA0         :1;                                       /* Port A Bit 0 */
        byte PA1         :1;                                       /* Port A Bit 1 */
        byte PA2         :1;                                       /* Port A Bit 2 */
        byte PA3         :1;                                       /* Port A Bit 3 */
        byte PA4         :1;                                       /* Port A Bit 4 */
        byte PA5         :1;                                       /* Port A Bit 5 */
        byte PA6         :1;                                       /* Port A Bit 6 */
        byte PA7         :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_PA0                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA0
    #define PORTA_PA1                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA1
    #define PORTA_PA2                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA2
    #define PORTA_PA3                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA3
    #define PORTA_PA4                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA4
    #define PORTA_PA5                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA5
    #define PORTA_PA6                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA6
    #define PORTA_PA7                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA7
    
    #define PORTA_PA0_MASK              1U
    #define PORTA_PA1_MASK              2U
    #define PORTA_PA2_MASK              4U
    #define PORTA_PA3_MASK              8U
    #define PORTA_PA4_MASK              16U
    #define PORTA_PA5_MASK              32U
    #define PORTA_PA6_MASK              64U
    #define PORTA_PA7_MASK              128U
    

    /*** PORTB - Port B Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte PB0         :1;                                       /* Port B Bit 0 */
        byte PB1         :1;                                       /* Port B Bit 1 */
        byte PB2         :1;                                       /* Port B Bit 2 */
        byte PB3         :1;                                       /* Port B Bit 3 */
        byte PB4         :1;                                       /* Port B Bit 4 */
        byte PB5         :1;                                       /* Port B Bit 5 */
        byte PB6         :1;                                       /* Port B Bit 6 */
        byte PB7         :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_PB0                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB0
    #define PORTB_PB1                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB1
    #define PORTB_PB2                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB2
    #define PORTB_PB3                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB3
    #define PORTB_PB4                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB4
    #define PORTB_PB5                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB5
    #define PORTB_PB6                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB6
    #define PORTB_PB7                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB7
    
    #define PORTB_PB0_MASK              1U
    #define PORTB_PB1_MASK              2U
    #define PORTB_PB2_MASK              4U
    #define PORTB_PB3_MASK              8U
    #define PORTB_PB4_MASK              16U
    #define PORTB_PB5_MASK              32U
    #define PORTB_PB6_MASK              64U
    #define PORTB_PB7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PB0         :1;                                       /* Port B Bit 0 */
    word PB1         :1;                                       /* Port B Bit 1 */
    word PB2         :1;                                       /* Port B Bit 2 */
    word PB3         :1;                                       /* Port B Bit 3 */
    word PB4         :1;                                       /* Port B Bit 4 */
    word PB5         :1;                                       /* Port B Bit 5 */
    word PB6         :1;                                       /* Port B Bit 6 */
    word PB7         :1;                                       /* Port B Bit 7 */
    word PA0         :1;                                       /* Port A Bit 0 */
    word PA1         :1;                                       /* Port A Bit 1 */
    word PA2         :1;                                       /* Port A Bit 2 */
    word PA3         :1;                                       /* Port A Bit 3 */
    word PA4         :1;                                       /* Port A Bit 4 */
    word PA5         :1;                                       /* Port A Bit 5 */
    word PA6         :1;                                       /* Port A Bit 6 */
    word PA7         :1;                                       /* Port A Bit 7 */
  } Bits;
  struct {
    word grpPB   :8;
    word grpPA   :8;
  } MergedBits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000UL);
#define PORTAB                          _PORTAB.Word
#define PORTAB_PB0                      _PORTAB.Bits.PB0
#define PORTAB_PB1                      _PORTAB.Bits.PB1
#define PORTAB_PB2                      _PORTAB.Bits.PB2
#define PORTAB_PB3                      _PORTAB.Bits.PB3
#define PORTAB_PB4                      _PORTAB.Bits.PB4
#define PORTAB_PB5                      _PORTAB.Bits.PB5
#define PORTAB_PB6                      _PORTAB.Bits.PB6
#define PORTAB_PB7                      _PORTAB.Bits.PB7
#define PORTAB_PA0                      _PORTAB.Bits.PA0
#define PORTAB_PA1                      _PORTAB.Bits.PA1
#define PORTAB_PA2                      _PORTAB.Bits.PA2
#define PORTAB_PA3                      _PORTAB.Bits.PA3
#define PORTAB_PA4                      _PORTAB.Bits.PA4
#define PORTAB_PA5                      _PORTAB.Bits.PA5
#define PORTAB_PA6                      _PORTAB.Bits.PA6
#define PORTAB_PA7                      _PORTAB.Bits.PA7
#define PORTAB_PB                       _PORTAB.MergedBits.grpPB
#define PORTAB_PA                       _PORTAB.MergedBits.grpPA

#define PORTAB_PB0_MASK                 1U
#define PORTAB_PB1_MASK                 2U
#define PORTAB_PB2_MASK                 4U
#define PORTAB_PB3_MASK                 8U
#define PORTAB_PB4_MASK                 16U
#define PORTAB_PB5_MASK                 32U
#define PORTAB_PB6_MASK                 64U
#define PORTAB_PB7_MASK                 128U
#define PORTAB_PA0_MASK                 256U
#define PORTAB_PA1_MASK                 512U
#define PORTAB_PA2_MASK                 1024U
#define PORTAB_PA3_MASK                 2048U
#define PORTAB_PA4_MASK                 4096U
#define PORTAB_PA5_MASK                 8192U
#define PORTAB_PA6_MASK                 16384U
#define PORTAB_PA7_MASK                 32768U
#define PORTAB_PB_MASK                  255U
#define PORTAB_PB_BITNUM                0U
#define PORTAB_PA_MASK                  65280U
#define PORTAB_PA_BITNUM                8U


/*** DDRAB - Port AB Data Direction; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
        byte DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
        byte DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
        byte DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
        byte DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
        byte DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
        byte DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
        byte DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_DDRA0                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA0
    #define DDRA_DDRA1                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA1
    #define DDRA_DDRA2                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA2
    #define DDRA_DDRA3                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA3
    #define DDRA_DDRA4                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA4
    #define DDRA_DDRA5                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA5
    #define DDRA_DDRA6                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA6
    #define DDRA_DDRA7                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA7
    
    #define DDRA_DDRA0_MASK             1U
    #define DDRA_DDRA1_MASK             2U
    #define DDRA_DDRA2_MASK             4U
    #define DDRA_DDRA3_MASK             8U
    #define DDRA_DDRA4_MASK             16U
    #define DDRA_DDRA5_MASK             32U
    #define DDRA_DDRA6_MASK             64U
    #define DDRA_DDRA7_MASK             128U
    

    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
        byte DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
        byte DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
        byte DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
        byte DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
        byte DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
        byte DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
        byte DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_DDRB0                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB0
    #define DDRB_DDRB1                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB1
    #define DDRB_DDRB2                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB2
    #define DDRB_DDRB3                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB3
    #define DDRB_DDRB4                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB4
    #define DDRB_DDRB5                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB5
    #define DDRB_DDRB6                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB6
    #define DDRB_DDRB7                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB7
    
    #define DDRB_DDRB0_MASK             1U
    #define DDRB_DDRB1_MASK             2U
    #define DDRB_DDRB2_MASK             4U
    #define DDRB_DDRB3_MASK             8U
    #define DDRB_DDRB4_MASK             16U
    #define DDRB_DDRB5_MASK             32U
    #define DDRB_DDRB6_MASK             64U
    #define DDRB_DDRB7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
    word DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
    word DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
    word DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
    word DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
    word DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
    word DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
    word DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
    word DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
    word DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
    word DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
    word DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
    word DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
    word DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
    word DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
    word DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
  struct {
    word grpDDRB :8;
    word grpDDRA :8;
  } MergedBits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002UL);
#define DDRAB                           _DDRAB.Word
#define DDRAB_DDRB0                     _DDRAB.Bits.DDRB0
#define DDRAB_DDRB1                     _DDRAB.Bits.DDRB1
#define DDRAB_DDRB2                     _DDRAB.Bits.DDRB2
#define DDRAB_DDRB3                     _DDRAB.Bits.DDRB3
#define DDRAB_DDRB4                     _DDRAB.Bits.DDRB4
#define DDRAB_DDRB5                     _DDRAB.Bits.DDRB5
#define DDRAB_DDRB6                     _DDRAB.Bits.DDRB6
#define DDRAB_DDRB7                     _DDRAB.Bits.DDRB7
#define DDRAB_DDRA0                     _DDRAB.Bits.DDRA0
#define DDRAB_DDRA1                     _DDRAB.Bits.DDRA1
#define DDRAB_DDRA2                     _DDRAB.Bits.DDRA2
#define DDRAB_DDRA3                     _DDRAB.Bits.DDRA3
#define DDRAB_DDRA4                     _DDRAB.Bits.DDRA4
#define DDRAB_DDRA5                     _DDRAB.Bits.DDRA5
#define DDRAB_DDRA6                     _DDRAB.Bits.DDRA6
#define DDRAB_DDRA7                     _DDRAB.Bits.DDRA7
#define DDRAB_DDRB                      _DDRAB.MergedBits.grpDDRB
#define DDRAB_DDRA                      _DDRAB.MergedBits.grpDDRA

#define DDRAB_DDRB0_MASK                1U
#define DDRAB_DDRB1_MASK                2U
#define DDRAB_DDRB2_MASK                4U
#define DDRAB_DDRB3_MASK                8U
#define DDRAB_DDRB4_MASK                16U
#define DDRAB_DDRB5_MASK                32U
#define DDRAB_DDRB6_MASK                64U
#define DDRAB_DDRB7_MASK                128U
#define DDRAB_DDRA0_MASK                256U
#define DDRAB_DDRA1_MASK                512U
#define DDRAB_DDRA2_MASK                1024U
#define DDRAB_DDRA3_MASK                2048U
#define DDRAB_DDRA4_MASK                4096U
#define DDRAB_DDRA5_MASK                8192U
#define DDRAB_DDRA6_MASK                16384U
#define DDRAB_DDRA7_MASK                32768U
#define DDRAB_DDRB_MASK                 255U
#define DDRAB_DDRB_BITNUM               0U
#define DDRAB_DDRA_MASK                 65280U
#define DDRAB_DDRA_BITNUM               8U


/*** PORTCD - Port CD; 0x00000004 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTC - Port C Register; 0x00000004 ***/
    union {
      byte Byte;
      struct {
        byte PC0         :1;                                       /* Port C Bit 0 */
        byte PC1         :1;                                       /* Port C Bit 1 */
        byte PC2         :1;                                       /* Port C Bit 2 */
        byte PC3         :1;                                       /* Port C Bit 3 */
        byte PC4         :1;                                       /* Port C Bit 4 */
        byte PC5         :1;                                       /* Port C Bit 5 */
        byte PC6         :1;                                       /* Port C Bit 6 */
        byte PC7         :1;                                       /* Port C Bit 7 */
      } Bits;
    } PORTCSTR;
    #define PORTC                       _PORTCD.Overlap_STR.PORTCSTR.Byte
    #define PORTC_PC0                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC0
    #define PORTC_PC1                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC1
    #define PORTC_PC2                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC2
    #define PORTC_PC3                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC3
    #define PORTC_PC4                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC4
    #define PORTC_PC5                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC5
    #define PORTC_PC6                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC6
    #define PORTC_PC7                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC7
    
    #define PORTC_PC0_MASK              1U
    #define PORTC_PC1_MASK              2U
    #define PORTC_PC2_MASK              4U
    #define PORTC_PC3_MASK              8U
    #define PORTC_PC4_MASK              16U
    #define PORTC_PC5_MASK              32U
    #define PORTC_PC6_MASK              64U
    #define PORTC_PC7_MASK              128U
    

    /*** PORTD - Port D Register; 0x00000005 ***/
    union {
      byte Byte;
      struct {
        byte PD0         :1;                                       /* Port D Bit 0 */
        byte PD1         :1;                                       /* Port D Bit 1 */
        byte PD2         :1;                                       /* Port D Bit 2 */
        byte PD3         :1;                                       /* Port D Bit 3 */
        byte PD4         :1;                                       /* Port D Bit 4 */
        byte PD5         :1;                                       /* Port D Bit 5 */
        byte PD6         :1;                                       /* Port D Bit 6 */
        byte PD7         :1;                                       /* Port D Bit 7 */
      } Bits;
    } PORTDSTR;
    #define PORTD                       _PORTCD.Overlap_STR.PORTDSTR.Byte
    #define PORTD_PD0                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD0
    #define PORTD_PD1                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD1
    #define PORTD_PD2                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD2
    #define PORTD_PD3                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD3
    #define PORTD_PD4                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD4
    #define PORTD_PD5                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD5
    #define PORTD_PD6                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD6
    #define PORTD_PD7                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD7
    
    #define PORTD_PD0_MASK              1U
    #define PORTD_PD1_MASK              2U
    #define PORTD_PD2_MASK              4U
    #define PORTD_PD3_MASK              8U
    #define PORTD_PD4_MASK              16U
    #define PORTD_PD5_MASK              32U
    #define PORTD_PD6_MASK              64U
    #define PORTD_PD7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PD0         :1;                                       /* Port D Bit 0 */
    word PD1         :1;                                       /* Port D Bit 1 */
    word PD2         :1;                                       /* Port D Bit 2 */
    word PD3         :1;                                       /* Port D Bit 3 */
    word PD4         :1;                                       /* Port D Bit 4 */
    word PD5         :1;                                       /* Port D Bit 5 */
    word PD6         :1;                                       /* Port D Bit 6 */
    word PD7         :1;                                       /* Port D Bit 7 */
    word PC0         :1;                                       /* Port C Bit 0 */
    word PC1         :1;                                       /* Port C Bit 1 */
    word PC2         :1;                                       /* Port C Bit 2 */
    word PC3         :1;                                       /* Port C Bit 3 */
    word PC4         :1;                                       /* Port C Bit 4 */
    word PC5         :1;                                       /* Port C Bit 5 */
    word PC6         :1;                                       /* Port C Bit 6 */
    word PC7         :1;                                       /* Port C Bit 7 */
  } Bits;
  struct {
    word grpPD   :8;
    word grpPC   :8;
  } MergedBits;
} PORTCDSTR;
extern volatile PORTCDSTR _PORTCD @(REG_BASE + 0x00000004UL);
#define PORTCD                          _PORTCD.Word
#define PORTCD_PD0                      _PORTCD.Bits.PD0
#define PORTCD_PD1                      _PORTCD.Bits.PD1
#define PORTCD_PD2                      _PORTCD.Bits.PD2
#define PORTCD_PD3                      _PORTCD.Bits.PD3
#define PORTCD_PD4                      _PORTCD.Bits.PD4
#define PORTCD_PD5                      _PORTCD.Bits.PD5
#define PORTCD_PD6                      _PORTCD.Bits.PD6
#define PORTCD_PD7                      _PORTCD.Bits.PD7
#define PORTCD_PC0                      _PORTCD.Bits.PC0
#define PORTCD_PC1                      _PORTCD.Bits.PC1
#define PORTCD_PC2                      _PORTCD.Bits.PC2
#define PORTCD_PC3                      _PORTCD.Bits.PC3
#define PORTCD_PC4                      _PORTCD.Bits.PC4
#define PORTCD_PC5                      _PORTCD.Bits.PC5
#define PORTCD_PC6                      _PORTCD.Bits.PC6
#define PORTCD_PC7                      _PORTCD.Bits.PC7
#define PORTCD_PD                       _PORTCD.MergedBits.grpPD
#define PORTCD_PC                       _PORTCD.MergedBits.grpPC

#define PORTCD_PD0_MASK                 1U
#define PORTCD_PD1_MASK                 2U
#define PORTCD_PD2_MASK                 4U
#define PORTCD_PD3_MASK                 8U
#define PORTCD_PD4_MASK                 16U
#define PORTCD_PD5_MASK                 32U
#define PORTCD_PD6_MASK                 64U
#define PORTCD_PD7_MASK                 128U
#define PORTCD_PC0_MASK                 256U
#define PORTCD_PC1_MASK                 512U
#define PORTCD_PC2_MASK                 1024U
#define PORTCD_PC3_MASK                 2048U
#define PORTCD_PC4_MASK                 4096U
#define PORTCD_PC5_MASK                 8192U
#define PORTCD_PC6_MASK                 16384U
#define PORTCD_PC7_MASK                 32768U
#define PORTCD_PD_MASK                  255U
#define PORTCD_PD_BITNUM                0U
#define PORTCD_PC_MASK                  65280U
#define PORTCD_PC_BITNUM                8U


/*** DDRCD - Port CD Data Direction; 0x00000006 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRC - Port C Data Direction Register; 0x00000006 ***/
    union {
      byte Byte;
      struct {
        byte DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
        byte DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
        byte DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
        byte DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
        byte DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
        byte DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
        byte DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
        byte DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
      } Bits;
    } DDRCSTR;
    #define DDRC                        _DDRCD.Overlap_STR.DDRCSTR.Byte
    #define DDRC_DDRC0                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC0
    #define DDRC_DDRC1                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC1
    #define DDRC_DDRC2                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC2
    #define DDRC_DDRC3                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC3
    #define DDRC_DDRC4                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC4
    #define DDRC_DDRC5                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC5
    #define DDRC_DDRC6                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC6
    #define DDRC_DDRC7                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC7
    
    #define DDRC_DDRC0_MASK             1U
    #define DDRC_DDRC1_MASK             2U
    #define DDRC_DDRC2_MASK             4U
    #define DDRC_DDRC3_MASK             8U
    #define DDRC_DDRC4_MASK             16U
    #define DDRC_DDRC5_MASK             32U
    #define DDRC_DDRC6_MASK             64U
    #define DDRC_DDRC7_MASK             128U
    

    /*** DDRD - Port D Data Direction Register; 0x00000007 ***/
    union {
      byte Byte;
      struct {
        byte DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
        byte DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
        byte DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
        byte DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
        byte DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
        byte DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
        byte DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
        byte DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
      } Bits;
    } DDRDSTR;
    #define DDRD                        _DDRCD.Overlap_STR.DDRDSTR.Byte
    #define DDRD_DDRD0                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD0
    #define DDRD_DDRD1                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD1
    #define DDRD_DDRD2                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD2
    #define DDRD_DDRD3                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD3
    #define DDRD_DDRD4                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD4
    #define DDRD_DDRD5                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD5
    #define DDRD_DDRD6                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD6
    #define DDRD_DDRD7                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD7
    
    #define DDRD_DDRD0_MASK             1U
    #define DDRD_DDRD1_MASK             2U
    #define DDRD_DDRD2_MASK             4U
    #define DDRD_DDRD3_MASK             8U
    #define DDRD_DDRD4_MASK             16U
    #define DDRD_DDRD5_MASK             32U
    #define DDRD_DDRD6_MASK             64U
    #define DDRD_DDRD7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
    word DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
    word DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
    word DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
    word DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
    word DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
    word DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
    word DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
    word DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
    word DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
    word DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
    word DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
    word DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
    word DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
    word DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
    word DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
  } Bits;
  struct {
    word grpDDRD :8;
    word grpDDRC :8;
  } MergedBits;
} DDRCDSTR;
extern volatile DDRCDSTR _DDRCD @(REG_BASE + 0x00000006UL);
#define DDRCD                           _DDRCD.Word
#define DDRCD_DDRD0                     _DDRCD.Bits.DDRD0
#define DDRCD_DDRD1                     _DDRCD.Bits.DDRD1
#define DDRCD_DDRD2                     _DDRCD.Bits.DDRD2
#define DDRCD_DDRD3                     _DDRCD.Bits.DDRD3
#define DDRCD_DDRD4                     _DDRCD.Bits.DDRD4
#define DDRCD_DDRD5                     _DDRCD.Bits.DDRD5
#define DDRCD_DDRD6                     _DDRCD.Bits.DDRD6
#define DDRCD_DDRD7                     _DDRCD.Bits.DDRD7
#define DDRCD_DDRC0                     _DDRCD.Bits.DDRC0
#define DDRCD_DDRC1                     _DDRCD.Bits.DDRC1
#define DDRCD_DDRC2                     _DDRCD.Bits.DDRC2
#define DDRCD_DDRC3                     _DDRCD.Bits.DDRC3
#define DDRCD_DDRC4                     _DDRCD.Bits.DDRC4
#define DDRCD_DDRC5                     _DDRCD.Bits.DDRC5
#define DDRCD_DDRC6                     _DDRCD.Bits.DDRC6
#define DDRCD_DDRC7                     _DDRCD.Bits.DDRC7
#define DDRCD_DDRD                      _DDRCD.MergedBits.grpDDRD
#define DDRCD_DDRC                      _DDRCD.MergedBits.grpDDRC

#define DDRCD_DDRD0_MASK                1U
#define DDRCD_DDRD1_MASK                2U
#define DDRCD_DDRD2_MASK                4U
#define DDRCD_DDRD3_MASK                8U
#define DDRCD_DDRD4_MASK                16U
#define DDRCD_DDRD5_MASK                32U
#define DDRCD_DDRD6_MASK                64U
#define DDRCD_DDRD7_MASK                128U
#define DDRCD_DDRC0_MASK                256U
#define DDRCD_DDRC1_MASK                512U
#define DDRCD_DDRC2_MASK                1024U
#define DDRCD_DDRC3_MASK                2048U
#define DDRCD_DDRC4_MASK                4096U
#define DDRCD_DDRC5_MASK                8192U
#define DDRCD_DDRC6_MASK                16384U
#define DDRCD_DDRC7_MASK                32768U
#define DDRCD_DDRD_MASK                 255U
#define DDRCD_DDRD_BITNUM               0U
#define DDRCD_DDRC_MASK                 65280U
#define DDRCD_DDRC_BITNUM               8U


/*** PORTE - Port E Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Port E Bit 0 */
    byte PE1         :1;                                       /* Port E Bit 1 */
    byte PE2         :1;                                       /* Port E Bit 2 */
    byte PE3         :1;                                       /* Port E Bit 3 */
    byte PE4         :1;                                       /* Port E Bit 4 */
    byte PE5         :1;                                       /* Port E Bit 5 */
    byte PE6         :1;                                       /* Port E Bit 6 */
    byte PE7         :1;                                       /* Port E Bit 7 */
  } Bits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008UL);
#define PORTE                           _PORTE.Byte
#define PORTE_PE0                       _PORTE.Bits.PE0
#define PORTE_PE1                       _PORTE.Bits.PE1
#define PORTE_PE2                       _PORTE.Bits.PE2
#define PORTE_PE3                       _PORTE.Bits.PE3
#define PORTE_PE4                       _PORTE.Bits.PE4
#define PORTE_PE5                       _PORTE.Bits.PE5
#define PORTE_PE6                       _PORTE.Bits.PE6
#define PORTE_PE7                       _PORTE.Bits.PE7

#define PORTE_PE0_MASK                  1U
#define PORTE_PE1_MASK                  2U
#define PORTE_PE2_MASK                  4U
#define PORTE_PE3_MASK                  8U
#define PORTE_PE4_MASK                  16U
#define PORTE_PE5_MASK                  32U
#define PORTE_PE6_MASK                  64U
#define PORTE_PE7_MASK                  128U


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte DDRE2       :1;                                       /* Data Direction Port E Bit 2 */
    byte DDRE3       :1;                                       /* Data Direction Port E Bit 3 */
    byte DDRE4       :1;                                       /* Data Direction Port E Bit 4 */
    byte DDRE5       :1;                                       /* Data Direction Port E Bit 5 */
    byte DDRE6       :1;                                       /* Data Direction Port E Bit 6 */
    byte DDRE7       :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpDDRE_2 :6;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009UL);
#define DDRE                            _DDRE.Byte
#define DDRE_DDRE2                      _DDRE.Bits.DDRE2
#define DDRE_DDRE3                      _DDRE.Bits.DDRE3
#define DDRE_DDRE4                      _DDRE.Bits.DDRE4
#define DDRE_DDRE5                      _DDRE.Bits.DDRE5
#define DDRE_DDRE6                      _DDRE.Bits.DDRE6
#define DDRE_DDRE7                      _DDRE.Bits.DDRE7
#define DDRE_DDRE_2                     _DDRE.MergedBits.grpDDRE_2

#define DDRE_DDRE2_MASK                 4U
#define DDRE_DDRE3_MASK                 8U
#define DDRE_DDRE4_MASK                 16U
#define DDRE_DDRE5_MASK                 32U
#define DDRE_DDRE6_MASK                 64U
#define DDRE_DDRE7_MASK                 128U
#define DDRE_DDRE_2_MASK                252U
#define DDRE_DDRE_2_BITNUM              2U


/*** MMCCTL0 - S12X_MMC Control Register 0; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte CS0E        :1;                                       /* Chip Select Enable 0 */
    byte CS1E        :1;                                       /* Chip Select Enable 1 */
    byte CS2E        :1;                                       /* Chip Select Enable 2 */
    byte CS3E        :1;                                       /* Chip Select Enable 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MMCCTL0STR;
extern volatile MMCCTL0STR _MMCCTL0 @(REG_BASE + 0x0000000AUL);
#define MMCCTL0                         _MMCCTL0.Byte
#define MMCCTL0_CS0E                    _MMCCTL0.Bits.CS0E
#define MMCCTL0_CS1E                    _MMCCTL0.Bits.CS1E
#define MMCCTL0_CS2E                    _MMCCTL0.Bits.CS2E
#define MMCCTL0_CS3E                    _MMCCTL0.Bits.CS3E

#define MMCCTL0_CS0E_MASK               1U
#define MMCCTL0_CS1E_MASK               2U
#define MMCCTL0_CS2E_MASK               4U
#define MMCCTL0_CS3E_MASK               8U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit A */
    byte MODB        :1;                                       /* Mode Select Bit B */
    byte MODC        :1;                                       /* Mode Select Bit C */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_MODA_MASK                  32U
#define MODE_MODB_MASK                  64U
#define MODE_MODC_MASK                  128U
#define MODE_MODx_MASK                  224U
#define MODE_MODx_BITNUM                5U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-Up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-Up Port B Enable */
    byte PUPCE       :1;                                       /* Pull-Up Port C Enable */
    byte PUPDE       :1;                                       /* Pull-Up Port D Enable */
    byte PUPEE       :1;                                       /* Pull-Up Port E Enable */
    byte             :1; 
    byte BKPUE       :1;                                       /* BKGD and VREGEN Pin Pull-up Enable */
    byte PUPKE       :1;                                       /* Pull-Up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPCE                      _PUCR.Bits.PUPCE
#define PUCR_PUPDE                      _PUCR.Bits.PUPDE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_BKPUE                      _PUCR.Bits.BKPUE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1U
#define PUCR_PUPBE_MASK                 2U
#define PUCR_PUPCE_MASK                 4U
#define PUCR_PUPDE_MASK                 8U
#define PUCR_PUPEE_MASK                 16U
#define PUCR_BKPUE_MASK                 64U
#define PUCR_PUPKE_MASK                 128U


/*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte RDPC        :1;                                       /* Reduced Drive of Port C */
    byte RDPD        :1;                                       /* Reduced Drive of Port D */
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPC                      _RDRIV.Bits.RDPC
#define RDRIV_RDPD                      _RDRIV.Bits.RDPD
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1U
#define RDRIV_RDPB_MASK                 2U
#define RDRIV_RDPC_MASK                 4U
#define RDRIV_RDPD_MASK                 8U
#define RDRIV_RDPE_MASK                 16U
#define RDRIV_RDPK_MASK                 128U
#define RDRIV_RDPx_MASK                 31U
#define RDRIV_RDPx_BITNUM               0U


/*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte ASIZ0       :1;                                       /* External Address Bus Size Bit 0 */
    byte ASIZ1       :1;                                       /* External Address Bus Size Bit 1 */
    byte ASIZ2       :1;                                       /* External Address Bus Size Bit 2 */
    byte ASIZ3       :1;                                       /* External Address Bus Size Bit 3 */
    byte ASIZ4       :1;                                       /* External Address Bus Size Bit 4 */
    byte HDBE        :1;                                       /* High Data Byte Enable */
    byte             :1; 
    byte ITHRS       :1;                                       /* Reduced Input Threshold */
  } Bits;
  struct {
    byte grpASIZ :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} EBICTL0STR;
extern volatile EBICTL0STR _EBICTL0 @(REG_BASE + 0x0000000EUL);
#define EBICTL0                         _EBICTL0.Byte
#define EBICTL0_ASIZ0                   _EBICTL0.Bits.ASIZ0
#define EBICTL0_ASIZ1                   _EBICTL0.Bits.ASIZ1
#define EBICTL0_ASIZ2                   _EBICTL0.Bits.ASIZ2
#define EBICTL0_ASIZ3                   _EBICTL0.Bits.ASIZ3
#define EBICTL0_ASIZ4                   _EBICTL0.Bits.ASIZ4
#define EBICTL0_HDBE                    _EBICTL0.Bits.HDBE
#define EBICTL0_ITHRS                   _EBICTL0.Bits.ITHRS
/* EBICTL_ARR: Access 2 EBICTLx registers in an array */
#define EBICTL_ARR                      ((volatile byte *) &EBICTL0)
#define EBICTL0_ASIZ                    _EBICTL0.MergedBits.grpASIZ

#define EBICTL0_ASIZ0_MASK              1U
#define EBICTL0_ASIZ1_MASK              2U
#define EBICTL0_ASIZ2_MASK              4U
#define EBICTL0_ASIZ3_MASK              8U
#define EBICTL0_ASIZ4_MASK              16U
#define EBICTL0_HDBE_MASK               32U
#define EBICTL0_ITHRS_MASK              128U
#define EBICTL0_ASIZ_MASK               31U
#define EBICTL0_ASIZ_BITNUM             0U


/*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***/
typedef union {
  byte Byte;
  struct {
    byte EXSTR0      :1;                                       /* External Access Stretch Bit 0 */
    byte EXSTR1      :1;                                       /* External Access Stretch Bit 1 */
    byte EXSTR2      :1;                                       /* External Access Stretch Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte EWAITE      :1;                                       /* External Wait Enable */
  } Bits;
  struct {
    byte grpEXSTR :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} EBICTL1STR;
extern volatile EBICTL1STR _EBICTL1 @(REG_BASE + 0x0000000FUL);
#define EBICTL1                         _EBICTL1.Byte
#define EBICTL1_EXSTR0                  _EBICTL1.Bits.EXSTR0
#define EBICTL1_EXSTR1                  _EBICTL1.Bits.EXSTR1
#define EBICTL1_EXSTR2                  _EBICTL1.Bits.EXSTR2
#define EBICTL1_EWAITE                  _EBICTL1.Bits.EWAITE
#define EBICTL1_EXSTR                   _EBICTL1.MergedBits.grpEXSTR

#define EBICTL1_EXSTR0_MASK             1U
#define EBICTL1_EXSTR1_MASK             2U
#define EBICTL1_EXSTR2_MASK             4U
#define EBICTL1_EWAITE_MASK             128U
#define EBICTL1_EXSTR_MASK              7U
#define EBICTL1_EXSTR_BITNUM            0U


/*** GPAGE - Global Page Index Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte GP0         :1;                                       /* Global Page Index Bit 0 */
    byte GP1         :1;                                       /* Global Page Index Bit 1 */
    byte GP2         :1;                                       /* Global Page Index Bit 2 */
    byte GP3         :1;                                       /* Global Page Index Bit 3 */
    byte GP4         :1;                                       /* Global Page Index Bit 4 */
    byte GP5         :1;                                       /* Global Page Index Bit 5 */
    byte GP6         :1;                                       /* Global Page Index Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpGP   :7;
    byte         :1;
  } MergedBits;
} GPAGESTR;
extern volatile GPAGESTR _GPAGE @(REG_BASE + 0x00000010UL);
#define GPAGE                           _GPAGE.Byte
#define GPAGE_GP0                       _GPAGE.Bits.GP0
#define GPAGE_GP1                       _GPAGE.Bits.GP1
#define GPAGE_GP2                       _GPAGE.Bits.GP2
#define GPAGE_GP3                       _GPAGE.Bits.GP3
#define GPAGE_GP4                       _GPAGE.Bits.GP4
#define GPAGE_GP5                       _GPAGE.Bits.GP5
#define GPAGE_GP6                       _GPAGE.Bits.GP6
#define GPAGE_GP                        _GPAGE.MergedBits.grpGP

#define GPAGE_GP0_MASK                  1U
#define GPAGE_GP1_MASK                  2U
#define GPAGE_GP2_MASK                  4U
#define GPAGE_GP3_MASK                  8U
#define GPAGE_GP4_MASK                  16U
#define GPAGE_GP5_MASK                  32U
#define GPAGE_GP6_MASK                  64U
#define GPAGE_GP_MASK                   127U
#define GPAGE_GP_BITNUM                 0U


/*** DIRECT - Direct Page Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Bit 8 */
    byte DP9         :1;                                       /* Direct Page Bit 9 */
    byte DP10        :1;                                       /* Direct Page Bit 10 */
    byte DP11        :1;                                       /* Direct Page Bit 11 */
    byte DP12        :1;                                       /* Direct Page Bit 12 */
    byte DP13        :1;                                       /* Direct Page Bit 13 */
    byte DP14        :1;                                       /* Direct Page Bit 14 */
    byte DP15        :1;                                       /* Direct Page Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000011UL);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1U
#define DIRECT_DP9_MASK                 2U
#define DIRECT_DP10_MASK                4U
#define DIRECT_DP11_MASK                8U
#define DIRECT_DP12_MASK                16U
#define DIRECT_DP13_MASK                32U
#define DIRECT_DP14_MASK                64U
#define DIRECT_DP15_MASK                128U


/*** MMCCTL1 - S12X_MMC Control Register 1; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable FLASH or ROM in the memory map */
    byte ROMHM       :1;                                       /* FLASH or ROM only in higher Half of Memory Map */
    byte EROMON      :1;                                       /* Enables emulated FLASH or ROM memory in the memory map. */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MMCCTL1STR;
extern volatile MMCCTL1STR _MMCCTL1 @(REG_BASE + 0x00000013UL);
#define MMCCTL1                         _MMCCTL1.Byte
#define MMCCTL1_ROMON                   _MMCCTL1.Bits.ROMON
#define MMCCTL1_ROMHM                   _MMCCTL1.Bits.ROMHM
#define MMCCTL1_EROMON                  _MMCCTL1.Bits.EROMON

#define MMCCTL1_ROMON_MASK              1U
#define MMCCTL1_ROMHM_MASK              2U
#define MMCCTL1_EROMON_MASK             4U


/*** RPAGE - RAM Page Index Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte RP0         :1;                                       /* RAM Page Index Bit 0 */
    byte RP1         :1;                                       /* RAM Page Index Bit 1 */
    byte RP2         :1;                                       /* RAM Page Index Bit 2 */
    byte RP3         :1;                                       /* RAM Page Index Bit 3 */
    byte RP4         :1;                                       /* RAM Page Index Bit 4 */
    byte RP5         :1;                                       /* RAM Page Index Bit 5 */
    byte RP6         :1;                                       /* RAM Page Index Bit 6 */
    byte RP7         :1;                                       /* RAM Page Index Bit 7 */
  } Bits;
} RPAGESTR;
extern volatile RPAGESTR _RPAGE @(REG_BASE + 0x00000016UL);
#define RPAGE                           _RPAGE.Byte
#define RPAGE_RP0                       _RPAGE.Bits.RP0
#define RPAGE_RP1                       _RPAGE.Bits.RP1
#define RPAGE_RP2                       _RPAGE.Bits.RP2
#define RPAGE_RP3                       _RPAGE.Bits.RP3
#define RPAGE_RP4                       _RPAGE.Bits.RP4
#define RPAGE_RP5                       _RPAGE.Bits.RP5
#define RPAGE_RP6                       _RPAGE.Bits.RP6
#define RPAGE_RP7                       _RPAGE.Bits.RP7

#define RPAGE_RP0_MASK                  1U
#define RPAGE_RP1_MASK                  2U
#define RPAGE_RP2_MASK                  4U
#define RPAGE_RP3_MASK                  8U
#define RPAGE_RP4_MASK                  16U
#define RPAGE_RP5_MASK                  32U
#define RPAGE_RP6_MASK                  64U
#define RPAGE_RP7_MASK                  128U


/*** EPAGE - EEPROM Page Index Register; 0x00000017 ***/
typedef union {
  byte Byte;
  struct {
    byte EP0         :1;                                       /* EEPROM Page Index Bit 0 */
    byte EP1         :1;                                       /* EEPROM Page Index Bit 1 */
    byte EP2         :1;                                       /* EEPROM Page Index Bit 2 */
    byte EP3         :1;                                       /* EEPROM Page Index Bit 3 */
    byte EP4         :1;                                       /* EEPROM Page Index Bit 4 */
    byte EP5         :1;                                       /* EEPROM Page Index Bit 5 */
    byte EP6         :1;                                       /* EEPROM Page Index Bit 6 */
    byte EP7         :1;                                       /* EEPROM Page Index Bit 7 */
  } Bits;
} EPAGESTR;
extern volatile EPAGESTR _EPAGE @(REG_BASE + 0x00000017UL);
#define EPAGE                           _EPAGE.Byte
#define EPAGE_EP0                       _EPAGE.Bits.EP0
#define EPAGE_EP1                       _EPAGE.Bits.EP1
#define EPAGE_EP2                       _EPAGE.Bits.EP2
#define EPAGE_EP3                       _EPAGE.Bits.EP3
#define EPAGE_EP4                       _EPAGE.Bits.EP4
#define EPAGE_EP5                       _EPAGE.Bits.EP5
#define EPAGE_EP6                       _EPAGE.Bits.EP6
#define EPAGE_EP7                       _EPAGE.Bits.EP7

#define EPAGE_EP0_MASK                  1U
#define EPAGE_EP1_MASK                  2U
#define EPAGE_EP2_MASK                  4U
#define EPAGE_EP3_MASK                  8U
#define EPAGE_EP4_MASK                  16U
#define EPAGE_EP5_MASK                  32U
#define EPAGE_EP6_MASK                  64U
#define EPAGE_EP7_MASK                  128U


/*** RAMFRL - RAM FLEXRAY Lower Boundary Register; 0x00000018 ***/
typedef union {
  byte Byte;
  struct {
    byte FRL0        :1;                                       /* FLEXRAY Region Lower Boundary Bit 0 */
    byte FRL1        :1;                                       /* FLEXRAY Region Lower Boundary Bit 1 */
    byte FRL2        :1;                                       /* FLEXRAY Region Lower Boundary Bit 2 */
    byte FRL3        :1;                                       /* FLEXRAY Region Lower Boundary Bit 3 */
    byte FRL4        :1;                                       /* FLEXRAY Region Lower Boundary Bit 4 */
    byte FRL5        :1;                                       /* FLEXRAY Region Lower Boundary Bit 5 */
    byte FRL6        :1;                                       /* FLEXRAY Region Lower Boundary Bit 6 */
    byte FRL7        :1;                                       /* FLEXRAY Region Lower Boundary Bit 7 */
  } Bits;
} RAMFRLSTR;
extern volatile RAMFRLSTR _RAMFRL @(REG_BASE + 0x00000018UL);
#define RAMFRL                          _RAMFRL.Byte
#define RAMFRL_FRL0                     _RAMFRL.Bits.FRL0
#define RAMFRL_FRL1                     _RAMFRL.Bits.FRL1
#define RAMFRL_FRL2                     _RAMFRL.Bits.FRL2
#define RAMFRL_FRL3                     _RAMFRL.Bits.FRL3
#define RAMFRL_FRL4                     _RAMFRL.Bits.FRL4
#define RAMFRL_FRL5                     _RAMFRL.Bits.FRL5
#define RAMFRL_FRL6                     _RAMFRL.Bits.FRL6
#define RAMFRL_FRL7                     _RAMFRL.Bits.FRL7

#define RAMFRL_FRL0_MASK                1U
#define RAMFRL_FRL1_MASK                2U
#define RAMFRL_FRL2_MASK                4U
#define RAMFRL_FRL3_MASK                8U
#define RAMFRL_FRL4_MASK                16U
#define RAMFRL_FRL5_MASK                32U
#define RAMFRL_FRL6_MASK                64U
#define RAMFRL_FRL7_MASK                128U


/*** RAMFRU - RAM FLEXRAY Upper Boundary Register; 0x00000019 ***/
typedef union {
  byte Byte;
  struct {
    byte FRU0        :1;                                       /* XGATE Region Upper Boundary Bit 0 */
    byte FRU1        :1;                                       /* XGATE Region Upper Boundary Bit 1 */
    byte FRU2        :1;                                       /* XGATE Region Upper Boundary Bit 2 */
    byte FRU3        :1;                                       /* XGATE Region Upper Boundary Bit 3 */
    byte FRU4        :1;                                       /* XGATE Region Upper Boundary Bit 4 */
    byte FRU5        :1;                                       /* XGATE Region Upper Boundary Bit 5 */
    byte FRU6        :1;                                       /* XGATE Region Upper Boundary Bit 6 */
    byte FRU7        :1;                                       /* XGATE Region Upper Boundary Bit 7 */
  } Bits;
} RAMFRUSTR;
extern volatile RAMFRUSTR _RAMFRU @(REG_BASE + 0x00000019UL);
#define RAMFRU                          _RAMFRU.Byte
#define RAMFRU_FRU0                     _RAMFRU.Bits.FRU0
#define RAMFRU_FRU1                     _RAMFRU.Bits.FRU1
#define RAMFRU_FRU2                     _RAMFRU.Bits.FRU2
#define RAMFRU_FRU3                     _RAMFRU.Bits.FRU3
#define RAMFRU_FRU4                     _RAMFRU.Bits.FRU4
#define RAMFRU_FRU5                     _RAMFRU.Bits.FRU5
#define RAMFRU_FRU6                     _RAMFRU.Bits.FRU6
#define RAMFRU_FRU7                     _RAMFRU.Bits.FRU7

#define RAMFRU_FRU0_MASK                1U
#define RAMFRU_FRU1_MASK                2U
#define RAMFRU_FRU2_MASK                4U
#define RAMFRU_FRU3_MASK                8U
#define RAMFRU_FRU4_MASK                16U
#define RAMFRU_FRU5_MASK                32U
#define RAMFRU_FRU6_MASK                64U
#define RAMFRU_FRU7_MASK                128U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** ECLKCTL - ECLK Control Register; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* Free-running ECLK Divider Bit 0 */
    byte EDIV1       :1;                                       /* Free-running ECLK Divider Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte NCLKX2      :1;                                       /* No ECLKX2 */
    byte NECLK       :1;                                       /* No ECLK */
  } Bits;
  struct {
    byte grpEDIV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpNCLKX_2 :1;
    byte         :1;
  } MergedBits;
} ECLKCTLSTR;
extern volatile ECLKCTLSTR _ECLKCTL @(REG_BASE + 0x0000001CUL);
#define ECLKCTL                         _ECLKCTL.Byte
#define ECLKCTL_EDIV0                   _ECLKCTL.Bits.EDIV0
#define ECLKCTL_EDIV1                   _ECLKCTL.Bits.EDIV1
#define ECLKCTL_NCLKX2                  _ECLKCTL.Bits.NCLKX2
#define ECLKCTL_NECLK                   _ECLKCTL.Bits.NECLK
#define ECLKCTL_EDIV                    _ECLKCTL.MergedBits.grpEDIV

#define ECLKCTL_EDIV0_MASK              1U
#define ECLKCTL_EDIV1_MASK              2U
#define ECLKCTL_NCLKX2_MASK             64U
#define ECLKCTL_NECLK_MASK              128U
#define ECLKCTL_EDIV_MASK               3U
#define ECLKCTL_EDIV_BITNUM             0U


/*** IRQCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} IRQCRSTR;
extern volatile IRQCRSTR _IRQCR @(REG_BASE + 0x0000001EUL);
#define IRQCR                           _IRQCR.Byte
#define IRQCR_IRQEN                     _IRQCR.Bits.IRQEN
#define IRQCR_IRQE                      _IRQCR.Bits.IRQE

#define IRQCR_IRQEN_MASK                64U
#define IRQCR_IRQE_MASK                 128U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte COMRV       :2;                                       /* Comparator Register Visibility Bits */
    byte DBGBRK      :2;                                       /* S12X_DBG Breakpoint Enable Bits */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte XGSBPE      :1;                                       /* XGATE S/W Breakpoint Enable */
    byte TRIG        :1;                                       /* Immediate Trigger Request Bit */
    byte ARM         :1;                                       /* Arm Bit */
  } Bits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_COMRV                     _DBGC1.Bits.COMRV
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BDM                       _DBGC1.Bits.BDM
#define DBGC1_XGSBPE                    _DBGC1.Bits.XGSBPE
#define DBGC1_TRIG                      _DBGC1.Bits.TRIG
#define DBGC1_ARM                       _DBGC1.Bits.ARM

#define DBGC1_COMRV_MASK                3U
#define DBGC1_COMRV_BITNUM              0U
#define DBGC1_DBGBRK_MASK               12U
#define DBGC1_DBGBRK_BITNUM             2U
#define DBGC1_BDM_MASK                  16U
#define DBGC1_XGSBPE_MASK               32U
#define DBGC1_TRIG_MASK                 64U
#define DBGC1_ARM_MASK                  128U


/*** DBGSR - Debug Status Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSF0        :1;                                       /* State Sequencer Flag Bit 0 */
    byte SSF1        :1;                                       /* State Sequencer Flag Bit 1 */
    byte SSF2        :1;                                       /* State Sequencer Flag Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte EXTF        :1;                                       /* External Tag Hit Flag */
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpSSF  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSRSTR;
extern volatile DBGSRSTR _DBGSR @(REG_BASE + 0x00000021UL);
#define DBGSR                           _DBGSR.Byte
#define DBGSR_SSF0                      _DBGSR.Bits.SSF0
#define DBGSR_SSF1                      _DBGSR.Bits.SSF1
#define DBGSR_SSF2                      _DBGSR.Bits.SSF2
#define DBGSR_EXTF                      _DBGSR.Bits.EXTF
#define DBGSR_TBF                       _DBGSR.Bits.TBF
#define DBGSR_SSF                       _DBGSR.MergedBits.grpSSF

#define DBGSR_SSF0_MASK                 1U
#define DBGSR_SSF1_MASK                 2U
#define DBGSR_SSF2_MASK                 4U
#define DBGSR_EXTF_MASK                 64U
#define DBGSR_TBF_MASK                  128U
#define DBGSR_SSF_MASK                  7U
#define DBGSR_SSF_BITNUM                0U


/*** DBGTCR - Debug Trace Control Register; 0x00000022 ***/
typedef union {
  byte Byte;
  struct {
    byte TALIGN      :2;                                       /* Trigger Align Bits */
    byte TRCMOD      :2;                                       /* Trace Mode Bits */
    byte TRANGE      :2;                                       /* Trace Range Bits */
    byte TSOURCE     :2;                                       /* Trace Source Control Bits */
  } Bits;
} DBGTCRSTR;
extern volatile DBGTCRSTR _DBGTCR @(REG_BASE + 0x00000022UL);
#define DBGTCR                          _DBGTCR.Byte
#define DBGTCR_TALIGN                   _DBGTCR.Bits.TALIGN
#define DBGTCR_TRCMOD                   _DBGTCR.Bits.TRCMOD
#define DBGTCR_TRANGE                   _DBGTCR.Bits.TRANGE
#define DBGTCR_TSOURCE                  _DBGTCR.Bits.TSOURCE

#define DBGTCR_TALIGN_MASK              3U
#define DBGTCR_TALIGN_BITNUM            0U
#define DBGTCR_TRCMOD_MASK              12U
#define DBGTCR_TRCMOD_BITNUM            2U
#define DBGTCR_TRANGE_MASK              48U
#define DBGTCR_TRANGE_BITNUM            4U
#define DBGTCR_TSOURCE_MASK             192U
#define DBGTCR_TSOURCE_BITNUM           6U


/*** DBGC2 - Debug Control Register 2; 0x00000023 ***/
typedef union {
  byte Byte;
  struct {
    byte ABCM        :2;                                       /* A and B Comparator Match Control */
    byte CDCM        :2;                                       /* C and D Comparator Match Control */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000023UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_ABCM                      _DBGC2.Bits.ABCM
#define DBGC2_CDCM                      _DBGC2.Bits.CDCM

#define DBGC2_ABCM_MASK                 3U
#define DBGC2_ABCM_BITNUM               0U
#define DBGC2_CDCM_MASK                 12U
#define DBGC2_CDCM_BITNUM               2U


/*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Debug Trace Buffer Bit 8 */
        byte BIT9        :1;                                       /* Debug Trace Buffer Bit 9 */
        byte BIT10       :1;                                       /* Debug Trace Buffer Bit 10 */
        byte BIT11       :1;                                       /* Debug Trace Buffer Bit 11 */
        byte BIT12       :1;                                       /* Debug Trace Buffer Bit 12 */
        byte BIT13       :1;                                       /* Debug Trace Buffer Bit 13 */
        byte BIT14       :1;                                       /* Debug Trace Buffer Bit 14 */
        byte BIT15       :1;                                       /* Debug Trace Buffer Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Debug Trace Buffer Bit 0 */
        byte BIT1        :1;                                       /* Debug Trace Buffer Bit 1 */
        byte BIT2        :1;                                       /* Debug Trace Buffer Bit 2 */
        byte BIT3        :1;                                       /* Debug Trace Buffer Bit 3 */
        byte BIT4        :1;                                       /* Debug Trace Buffer Bit 4 */
        byte BIT5        :1;                                       /* Debug Trace Buffer Bit 5 */
        byte BIT6        :1;                                       /* Debug Trace Buffer Bit 6 */
        byte BIT7        :1;                                       /* Debug Trace Buffer Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Debug Trace Buffer Bit 0 */
    word BIT1        :1;                                       /* Debug Trace Buffer Bit 1 */
    word BIT2        :1;                                       /* Debug Trace Buffer Bit 2 */
    word BIT3        :1;                                       /* Debug Trace Buffer Bit 3 */
    word BIT4        :1;                                       /* Debug Trace Buffer Bit 4 */
    word BIT5        :1;                                       /* Debug Trace Buffer Bit 5 */
    word BIT6        :1;                                       /* Debug Trace Buffer Bit 6 */
    word BIT7        :1;                                       /* Debug Trace Buffer Bit 7 */
    word BIT8        :1;                                       /* Debug Trace Buffer Bit 8 */
    word BIT9        :1;                                       /* Debug Trace Buffer Bit 9 */
    word BIT10       :1;                                       /* Debug Trace Buffer Bit 10 */
    word BIT11       :1;                                       /* Debug Trace Buffer Bit 11 */
    word BIT12       :1;                                       /* Debug Trace Buffer Bit 12 */
    word BIT13       :1;                                       /* Debug Trace Buffer Bit 13 */
    word BIT14       :1;                                       /* Debug Trace Buffer Bit 14 */
    word BIT15       :1;                                       /* Debug Trace Buffer Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000024UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000026 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT         :7;                                       /* Count value */
    byte             :1; 
  } Bits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000026UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT                      _DBGCNT.Bits.CNT

#define DBGCNT_CNT_MASK                 127U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGSCRX - Debug State Control Register 0; 0x00000027 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** DBGSCRX - Debug State Control Register 0; Several registers at the same address ***/
    union {
      struct {
        byte SC0         :1;                                       /* These bit (0) select the targeted next state whilst in StateX, based upon the match event */
        byte SC1         :1;                                       /* These bit (1) select the targeted next state whilst in StateX, based upon the match event */
        byte SC2         :1;                                       /* These bit (2) select the targeted next state whilst in StateX, based upon the match event */
        byte SC3         :1;                                       /* These bit (3) select the targeted next state whilst in StateX, based upon the match event */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGSCRXSTR;
    #define DBGSCRX                     _DBGSCRX.Byte
    #define DBGSCRX_SC0                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC0
    #define DBGSCRX_SC1                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC1
    #define DBGSCRX_SC2                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC2
    #define DBGSCRX_SC3                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC3
    #define DBGSCRX_SC                  _DBGSCRX.SameAddr_STR.DBGSCRXSTR.MergedBits.grpSC
    
    #define DBGSCRX_SC0_MASK            1U
    #define DBGSCRX_SC1_MASK            2U
    #define DBGSCRX_SC2_MASK            4U
    #define DBGSCRX_SC3_MASK            8U
    #define DBGSCRX_SC_MASK             15U
    #define DBGSCRX_SC_BITNUM           0U
    
    /*** DBGMFR - Debug Match Flag Register; Several registers at the same address ***/
    union {
      struct {
        byte MC0         :1;                                       /* Debug Match Flag Bit 0 */
        byte MC1         :1;                                       /* Debug Match Flag Bit 1 */
        byte MC2         :1;                                       /* Debug Match Flag Bit 2 */
        byte MC3         :1;                                       /* Debug Match Flag Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpMC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGMFRSTR;
    #define DBGMFR                      _DBGSCRX.Byte
    #define DBGMFR_MC0                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC0
    #define DBGMFR_MC1                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC1
    #define DBGMFR_MC2                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC2
    #define DBGMFR_MC3                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC3
    #define DBGMFR_MC                   _DBGSCRX.SameAddr_STR.DBGMFRSTR.MergedBits.grpMC
    
    #define DBGMFR_MC0_MASK             1U
    #define DBGMFR_MC1_MASK             2U
    #define DBGMFR_MC2_MASK             4U
    #define DBGMFR_MC3_MASK             8U
    #define DBGMFR_MC_MASK              15U
    #define DBGMFR_MC_BITNUM            0U
    
  } SameAddr_STR; /*Several registers at the same address */

} DBGSCRXSTR;
extern volatile DBGSCRXSTR _DBGSCRX @(REG_BASE + 0x00000027UL);


/*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte COMPE       :1;                                       /* Determines if comparator is enabled */
    byte SRC         :1;                                       /* Determines mapping of comparator to S12X_CPU or XGATE */
    byte RWE         :1;                                       /* Read/Write Enable Bit */
    byte RW          :1;                                       /* Read/Write Comparator Value Bit */
    byte BRK         :1;                                       /* Break */
    byte TAG         :1;                                       /* Tag select */
    byte NDB_SZ      :1;                                       /* Not Data Bus Compare (for comparators A and C), Size Comparator Value Bit (for comparators B and D) */
    byte SZE         :1;                                       /* Size Comparator Enable Bit (for comparators B and D) */
  } Bits;
} DBGXCTLSTR;
extern volatile DBGXCTLSTR _DBGXCTL @(REG_BASE + 0x00000028UL);
#define DBGXCTL                         _DBGXCTL.Byte
#define DBGXCTL_COMPE                   _DBGXCTL.Bits.COMPE
#define DBGXCTL_SRC                     _DBGXCTL.Bits.SRC
#define DBGXCTL_RWE                     _DBGXCTL.Bits.RWE
#define DBGXCTL_RW                      _DBGXCTL.Bits.RW
#define DBGXCTL_BRK                     _DBGXCTL.Bits.BRK
#define DBGXCTL_TAG                     _DBGXCTL.Bits.TAG
#define DBGXCTL_NDB_SZ                  _DBGXCTL.Bits.NDB_SZ
#define DBGXCTL_SZE                     _DBGXCTL.Bits.SZE

#define DBGXCTL_COMPE_MASK              1U
#define DBGXCTL_SRC_MASK                2U
#define DBGXCTL_RWE_MASK                4U
#define DBGXCTL_RW_MASK                 8U
#define DBGXCTL_BRK_MASK                16U
#define DBGXCTL_TAG_MASK                32U
#define DBGXCTL_NDB_SZ_MASK             64U
#define DBGXCTL_SZE_MASK                128U


/*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT16       :1;                                       /* Comparator Address High Compare Bit 16 */
    byte BIT17       :1;                                       /* Comparator Address High Compare Bit 17 */
    byte BIT18       :1;                                       /* Comparator Address High Compare Bit 18 */
    byte BIT19       :1;                                       /* Comparator Address High Compare Bit 19 */
    byte BIT20       :1;                                       /* Comparator Address High Compare Bit 20 */
    byte BIT21       :1;                                       /* Comparator Address High Compare Bit 21 */
    byte BIT22       :1;                                       /* Comparator Address High Compare Bit 22 */
    byte             :1; 
  } Bits;
  struct {
    byte grpBIT_16 :7;
    byte         :1;
  } MergedBits;
} DBGXAHSTR;
extern volatile DBGXAHSTR _DBGXAH @(REG_BASE + 0x00000029UL);
#define DBGXAH                          _DBGXAH.Byte
#define DBGXAH_BIT16                    _DBGXAH.Bits.BIT16
#define DBGXAH_BIT17                    _DBGXAH.Bits.BIT17
#define DBGXAH_BIT18                    _DBGXAH.Bits.BIT18
#define DBGXAH_BIT19                    _DBGXAH.Bits.BIT19
#define DBGXAH_BIT20                    _DBGXAH.Bits.BIT20
#define DBGXAH_BIT21                    _DBGXAH.Bits.BIT21
#define DBGXAH_BIT22                    _DBGXAH.Bits.BIT22
#define DBGXAH_BIT_16                   _DBGXAH.MergedBits.grpBIT_16
#define DBGXAH_BIT                      DBGXAH_BIT_16

#define DBGXAH_BIT16_MASK               1U
#define DBGXAH_BIT17_MASK               2U
#define DBGXAH_BIT18_MASK               4U
#define DBGXAH_BIT19_MASK               8U
#define DBGXAH_BIT20_MASK               16U
#define DBGXAH_BIT21_MASK               32U
#define DBGXAH_BIT22_MASK               64U
#define DBGXAH_BIT_16_MASK              127U
#define DBGXAH_BIT_16_BITNUM            0U


/*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Address Mid Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator Address Mid Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Address Mid Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Address Mid Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Address Mid Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Address Mid Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Address Mid Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Address Mid Compare Bit 15 */
  } Bits;
} DBGXAMSTR;
extern volatile DBGXAMSTR _DBGXAM @(REG_BASE + 0x0000002AUL);
#define DBGXAM                          _DBGXAM.Byte
#define DBGXAM_BIT8                     _DBGXAM.Bits.BIT8
#define DBGXAM_BIT9                     _DBGXAM.Bits.BIT9
#define DBGXAM_BIT10                    _DBGXAM.Bits.BIT10
#define DBGXAM_BIT11                    _DBGXAM.Bits.BIT11
#define DBGXAM_BIT12                    _DBGXAM.Bits.BIT12
#define DBGXAM_BIT13                    _DBGXAM.Bits.BIT13
#define DBGXAM_BIT14                    _DBGXAM.Bits.BIT14
#define DBGXAM_BIT15                    _DBGXAM.Bits.BIT15

#define DBGXAM_BIT8_MASK                1U
#define DBGXAM_BIT9_MASK                2U
#define DBGXAM_BIT10_MASK               4U
#define DBGXAM_BIT11_MASK               8U
#define DBGXAM_BIT12_MASK               16U
#define DBGXAM_BIT13_MASK               32U
#define DBGXAM_BIT14_MASK               64U
#define DBGXAM_BIT15_MASK               128U


/*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXALSTR;
extern volatile DBGXALSTR _DBGXAL @(REG_BASE + 0x0000002BUL);
#define DBGXAL                          _DBGXAL.Byte
#define DBGXAL_BIT0                     _DBGXAL.Bits.BIT0
#define DBGXAL_BIT1                     _DBGXAL.Bits.BIT1
#define DBGXAL_BIT2                     _DBGXAL.Bits.BIT2
#define DBGXAL_BIT3                     _DBGXAL.Bits.BIT3
#define DBGXAL_BIT4                     _DBGXAL.Bits.BIT4
#define DBGXAL_BIT5                     _DBGXAL.Bits.BIT5
#define DBGXAL_BIT6                     _DBGXAL.Bits.BIT6
#define DBGXAL_BIT7                     _DBGXAL.Bits.BIT7

#define DBGXAL_BIT0_MASK                1U
#define DBGXAL_BIT1_MASK                2U
#define DBGXAL_BIT2_MASK                4U
#define DBGXAL_BIT3_MASK                8U
#define DBGXAL_BIT4_MASK                16U
#define DBGXAL_BIT5_MASK                32U
#define DBGXAL_BIT6_MASK                64U
#define DBGXAL_BIT7_MASK                128U


/*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator A Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator A Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator A Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator A Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator A Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator A Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator A Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator A Compare Bit 15 */
  } Bits;
} DBGXDHSTR;
extern volatile DBGXDHSTR _DBGXDH @(REG_BASE + 0x0000002CUL);
#define DBGXDH                          _DBGXDH.Byte
#define DBGXDH_BIT8                     _DBGXDH.Bits.BIT8
#define DBGXDH_BIT9                     _DBGXDH.Bits.BIT9
#define DBGXDH_BIT10                    _DBGXDH.Bits.BIT10
#define DBGXDH_BIT11                    _DBGXDH.Bits.BIT11
#define DBGXDH_BIT12                    _DBGXDH.Bits.BIT12
#define DBGXDH_BIT13                    _DBGXDH.Bits.BIT13
#define DBGXDH_BIT14                    _DBGXDH.Bits.BIT14
#define DBGXDH_BIT15                    _DBGXDH.Bits.BIT15

#define DBGXDH_BIT8_MASK                1U
#define DBGXDH_BIT9_MASK                2U
#define DBGXDH_BIT10_MASK               4U
#define DBGXDH_BIT11_MASK               8U
#define DBGXDH_BIT12_MASK               16U
#define DBGXDH_BIT13_MASK               32U
#define DBGXDH_BIT14_MASK               64U
#define DBGXDH_BIT15_MASK               128U


/*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXDLSTR;
extern volatile DBGXDLSTR _DBGXDL @(REG_BASE + 0x0000002DUL);
#define DBGXDL                          _DBGXDL.Byte
#define DBGXDL_BIT0                     _DBGXDL.Bits.BIT0
#define DBGXDL_BIT1                     _DBGXDL.Bits.BIT1
#define DBGXDL_BIT2                     _DBGXDL.Bits.BIT2
#define DBGXDL_BIT3                     _DBGXDL.Bits.BIT3
#define DBGXDL_BIT4                     _DBGXDL.Bits.BIT4
#define DBGXDL_BIT5                     _DBGXDL.Bits.BIT5
#define DBGXDL_BIT6                     _DBGXDL.Bits.BIT6
#define DBGXDL_BIT7                     _DBGXDL.Bits.BIT7

#define DBGXDL_BIT0_MASK                1U
#define DBGXDL_BIT1_MASK                2U
#define DBGXDL_BIT2_MASK                4U
#define DBGXDL_BIT3_MASK                8U
#define DBGXDL_BIT4_MASK                16U
#define DBGXDL_BIT5_MASK                32U
#define DBGXDL_BIT6_MASK                64U
#define DBGXDL_BIT7_MASK                128U


/*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Mask Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Mask Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Mask Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Mask Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Mask Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Mask Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Mask Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Mask Bit 15 */
  } Bits;
} DBGXDHMSTR;
extern volatile DBGXDHMSTR _DBGXDHM @(REG_BASE + 0x0000002EUL);
#define DBGXDHM                         _DBGXDHM.Byte
#define DBGXDHM_BIT8                    _DBGXDHM.Bits.BIT8
#define DBGXDHM_BIT9                    _DBGXDHM.Bits.BIT9
#define DBGXDHM_BIT10                   _DBGXDHM.Bits.BIT10
#define DBGXDHM_BIT11                   _DBGXDHM.Bits.BIT11
#define DBGXDHM_BIT12                   _DBGXDHM.Bits.BIT12
#define DBGXDHM_BIT13                   _DBGXDHM.Bits.BIT13
#define DBGXDHM_BIT14                   _DBGXDHM.Bits.BIT14
#define DBGXDHM_BIT15                   _DBGXDHM.Bits.BIT15

#define DBGXDHM_BIT8_MASK               1U
#define DBGXDHM_BIT9_MASK               2U
#define DBGXDHM_BIT10_MASK              4U
#define DBGXDHM_BIT11_MASK              8U
#define DBGXDHM_BIT12_MASK              16U
#define DBGXDHM_BIT13_MASK              32U
#define DBGXDHM_BIT14_MASK              64U
#define DBGXDHM_BIT15_MASK              128U


/*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data High Mask Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data High Mask Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data High Mask Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data High Mask Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data High Mask Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data High Mask Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data High Mask Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data High Mask Bit 7 */
  } Bits;
} DBGXDLMSTR;
extern volatile DBGXDLMSTR _DBGXDLM @(REG_BASE + 0x0000002FUL);
#define DBGXDLM                         _DBGXDLM.Byte
#define DBGXDLM_BIT0                    _DBGXDLM.Bits.BIT0
#define DBGXDLM_BIT1                    _DBGXDLM.Bits.BIT1
#define DBGXDLM_BIT2                    _DBGXDLM.Bits.BIT2
#define DBGXDLM_BIT3                    _DBGXDLM.Bits.BIT3
#define DBGXDLM_BIT4                    _DBGXDLM.Bits.BIT4
#define DBGXDLM_BIT5                    _DBGXDLM.Bits.BIT5
#define DBGXDLM_BIT6                    _DBGXDLM.Bits.BIT6
#define DBGXDLM_BIT7                    _DBGXDLM.Bits.BIT7

#define DBGXDLM_BIT0_MASK               1U
#define DBGXDLM_BIT1_MASK               2U
#define DBGXDLM_BIT2_MASK               4U
#define DBGXDLM_BIT3_MASK               8U
#define DBGXDLM_BIT4_MASK               16U
#define DBGXDLM_BIT5_MASK               32U
#define DBGXDLM_BIT6_MASK               64U
#define DBGXDLM_BIT7_MASK               128U


/*** PPAGE - Program Page Index Register; 0x00000030 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte PIX4        :1;                                       /* Program Page Index Bit 4 */
    byte PIX5        :1;                                       /* Program Page Index Bit 5 */
    byte PIX6        :1;                                       /* Program Page Index Bit 6 */
    byte PIX7        :1;                                       /* Program Page Index Bit 7 */
  } Bits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000030UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX6                      _PPAGE.Bits.PIX6
#define PPAGE_PIX7                      _PPAGE.Bits.PIX7

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX4_MASK                 16U
#define PPAGE_PIX5_MASK                 32U
#define PPAGE_PIX6_MASK                 64U
#define PPAGE_PIX7_MASK                 128U


/*** PORTK - Port K Data Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte PK0         :1;                                       /* Port K Bit 0 */
    byte PK1         :1;                                       /* Port K Bit 1 */
    byte PK2         :1;                                       /* Port K Bit 2 */
    byte PK3         :1;                                       /* Port K Bit 3 */
    byte PK4         :1;                                       /* Port K Bit 4 */
    byte PK5         :1;                                       /* Port K Bit 5 */
    byte PK6         :1;                                       /* Port K Bit 6 */
    byte PK7         :1;                                       /* Port K Bit 7 */
  } Bits;
} PORTKSTR;
extern volatile PORTKSTR _PORTK @(REG_BASE + 0x00000032UL);
#define PORTK                           _PORTK.Byte
#define PORTK_PK0                       _PORTK.Bits.PK0
#define PORTK_PK1                       _PORTK.Bits.PK1
#define PORTK_PK2                       _PORTK.Bits.PK2
#define PORTK_PK3                       _PORTK.Bits.PK3
#define PORTK_PK4                       _PORTK.Bits.PK4
#define PORTK_PK5                       _PORTK.Bits.PK5
#define PORTK_PK6                       _PORTK.Bits.PK6
#define PORTK_PK7                       _PORTK.Bits.PK7

#define PORTK_PK0_MASK                  1U
#define PORTK_PK1_MASK                  2U
#define PORTK_PK2_MASK                  4U
#define PORTK_PK3_MASK                  8U
#define PORTK_PK4_MASK                  16U
#define PORTK_PK5_MASK                  32U
#define PORTK_PK6_MASK                  64U
#define PORTK_PK7_MASK                  128U


/*** DDRK - Port K Data Direction Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRK0       :1;                                       /* Port K Data Direction Bit 0 */
    byte DDRK1       :1;                                       /* Port K Data Direction Bit 1 */
    byte DDRK2       :1;                                       /* Port K Data Direction Bit 2 */
    byte DDRK3       :1;                                       /* Port K Data Direction Bit 3 */
    byte DDRK4       :1;                                       /* Port K Data Direction Bit 4 */
    byte DDRK5       :1;                                       /* Port K Data Direction Bit 5 */
    byte DDRK6       :1;                                       /* Port K Data Direction Bit 6 */
    byte DDRK7       :1;                                       /* Port K Data Direction Bit 7 */
  } Bits;
} DDRKSTR;
extern volatile DDRKSTR _DDRK @(REG_BASE + 0x00000033UL);
#define DDRK                            _DDRK.Byte
#define DDRK_DDRK0                      _DDRK.Bits.DDRK0
#define DDRK_DDRK1                      _DDRK.Bits.DDRK1
#define DDRK_DDRK2                      _DDRK.Bits.DDRK2
#define DDRK_DDRK3                      _DDRK.Bits.DDRK3
#define DDRK_DDRK4                      _DDRK.Bits.DDRK4
#define DDRK_DDRK5                      _DDRK.Bits.DDRK5
#define DDRK_DDRK6                      _DDRK.Bits.DDRK6
#define DDRK_DDRK7                      _DDRK.Bits.DDRK7

#define DDRK_DDRK0_MASK                 1U
#define DDRK_DDRK1_MASK                 2U
#define DDRK_DDRK2_MASK                 4U
#define DDRK_DDRK3_MASK                 8U
#define DDRK_DDRK4_MASK                 16U
#define DDRK_DDRK5_MASK                 32U
#define DDRK_DDRK6_MASK                 64U
#define DDRK_DDRK7_MASK                 128U


/*** SYNR - CRG Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYN0        :1;                                       /* CRG Synthesizer Bit 0 */
    byte SYN1        :1;                                       /* CRG Synthesizer Bit 1 */
    byte SYN2        :1;                                       /* CRG Synthesizer Bit 2 */
    byte SYN3        :1;                                       /* CRG Synthesizer Bit 3 */
    byte SYN4        :1;                                       /* CRG Synthesizer Bit 4 */
    byte SYN5        :1;                                       /* CRG Synthesizer Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSYN  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} SYNRSTR;
extern volatile SYNRSTR _SYNR @(REG_BASE + 0x00000034UL);
#define SYNR                            _SYNR.Byte
#define SYNR_SYN0                       _SYNR.Bits.SYN0
#define SYNR_SYN1                       _SYNR.Bits.SYN1
#define SYNR_SYN2                       _SYNR.Bits.SYN2
#define SYNR_SYN3                       _SYNR.Bits.SYN3
#define SYNR_SYN4                       _SYNR.Bits.SYN4
#define SYNR_SYN5                       _SYNR.Bits.SYN5
#define SYNR_SYN                        _SYNR.MergedBits.grpSYN

#define SYNR_SYN0_MASK                  1U
#define SYNR_SYN1_MASK                  2U
#define SYNR_SYN2_MASK                  4U
#define SYNR_SYN3_MASK                  8U
#define SYNR_SYN4_MASK                  16U
#define SYNR_SYN5_MASK                  32U
#define SYNR_SYN_MASK                   63U
#define SYNR_SYN_BITNUM                 0U


/*** REFDV - CRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDV0      :1;                                       /* CRG Reference Divider Bit 0 */
    byte REFDV1      :1;                                       /* CRG Reference Divider Bit 1 */
    byte REFDV2      :1;                                       /* CRG Reference Divider Bit 2 */
    byte REFDV3      :1;                                       /* CRG Reference Divider Bit 3 */
    byte REFDV4      :1;                                       /* CRG Reference Divider Bit 4 */
    byte REFDV5      :1;                                       /* CRG Reference Divider Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREFDV :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035UL);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDV0                    _REFDV.Bits.REFDV0
#define REFDV_REFDV1                    _REFDV.Bits.REFDV1
#define REFDV_REFDV2                    _REFDV.Bits.REFDV2
#define REFDV_REFDV3                    _REFDV.Bits.REFDV3
#define REFDV_REFDV4                    _REFDV.Bits.REFDV4
#define REFDV_REFDV5                    _REFDV.Bits.REFDV5
#define REFDV_REFDV                     _REFDV.MergedBits.grpREFDV

#define REFDV_REFDV0_MASK               1U
#define REFDV_REFDV1_MASK               2U
#define REFDV_REFDV2_MASK               4U
#define REFDV_REFDV3_MASK               8U
#define REFDV_REFDV4_MASK               16U
#define REFDV_REFDV5_MASK               32U
#define REFDV_REFDV_MASK                63U
#define REFDV_REFDV_BITNUM              0U


/*** CRGFLG - CRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte SCM         :1;                                       /* Self-clock mode Status */
    byte SCMIF       :1;                                       /* Self-clock mode Interrupt Flag */
    byte TRACK       :1;                                       /* Track Status */
    byte LOCK        :1;                                       /* Lock Status */
    byte LOCKIF      :1;                                       /* PLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_SCM                      _CRGFLG.Bits.SCM
#define CRGFLG_SCMIF                    _CRGFLG.Bits.SCMIF
#define CRGFLG_TRACK                    _CRGFLG.Bits.TRACK
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_LVRF                     _CRGFLG.Bits.LVRF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_SCM_MASK                 1U
#define CRGFLG_SCMIF_MASK               2U
#define CRGFLG_TRACK_MASK               4U
#define CRGFLG_LOCK_MASK                8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_LVRF_MASK                32U
#define CRGFLG_PORF_MASK                64U
#define CRGFLG_RTIF_MASK                128U


/*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SCMIE       :1;                                       /* Self-clock mode Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable */
    byte             :1; 
    byte ILAF        :1;                                       /* Illegal Address Reset Flag */
    byte RTIE        :1;                                       /* Real Time Interrupt Enable */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038UL);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_SCMIE                    _CRGINT.Bits.SCMIE
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_ILAF                     _CRGINT.Bits.ILAF
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_SCMIE_MASK               2U
#define CRGINT_LOCKIE_MASK              16U
#define CRGINT_ILAF_MASK                64U
#define CRGINT_RTIE_MASK                128U


/*** CLKSEL - CRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP stops in WAIT mode */
    byte RTIWAI      :1;                                       /* RTI stops in WAIT mode */
    byte             :1; 
    byte PLLWAI      :1;                                       /* PLL stops in WAIT mode */
    byte             :1; 
    byte             :1; 
    byte PSTP        :1;                                       /* Pseudo Stop */
    byte PLLSEL      :1;                                       /* PLL selected for system clock */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039UL);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_PLLWAI                   _CLKSEL.Bits.PLLWAI
#define CLKSEL_PSTP                     _CLKSEL.Bits.PSTP
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1U
#define CLKSEL_RTIWAI_MASK              2U
#define CLKSEL_PLLWAI_MASK              8U
#define CLKSEL_PSTP_MASK                64U
#define CLKSEL_PLLSEL_MASK              128U


/*** PLLCTL - CRG PLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte SCME        :1;                                       /* Self-clock mode enable */
    byte PCE         :1;                                       /* COP Enable during Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable during Pseudo Stop Bit */
    byte FSTWKP      :1;                                       /* Fast Wake-up from Full Stop Bit */
    byte ACQ         :1;                                       /* Acquisition */
    byte AUTO        :1;                                       /* Automatic Bandwidth Control */
    byte PLLON       :1;                                       /* Phase Lock Loop On */
    byte CME         :1;                                       /* Clock Monitor Enable */
  } Bits;
} PLLCTLSTR;
extern volatile PLLCTLSTR _PLLCTL @(REG_BASE + 0x0000003AUL);
#define PLLCTL                          _PLLCTL.Byte
#define PLLCTL_SCME                     _PLLCTL.Bits.SCME
#define PLLCTL_PCE                      _PLLCTL.Bits.PCE
#define PLLCTL_PRE                      _PLLCTL.Bits.PRE
#define PLLCTL_FSTWKP                   _PLLCTL.Bits.FSTWKP
#define PLLCTL_ACQ                      _PLLCTL.Bits.ACQ
#define PLLCTL_AUTO                     _PLLCTL.Bits.AUTO
#define PLLCTL_PLLON                    _PLLCTL.Bits.PLLON
#define PLLCTL_CME                      _PLLCTL.Bits.CME

#define PLLCTL_SCME_MASK                1U
#define PLLCTL_PCE_MASK                 2U
#define PLLCTL_PRE_MASK                 4U
#define PLLCTL_FSTWKP_MASK              8U
#define PLLCTL_ACQ_MASK                 16U
#define PLLCTL_AUTO_MASK                32U
#define PLLCTL_PLLON_MASK               64U
#define PLLCTL_CME_MASK                 128U


/*** RTICTL - CRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte RTDEC       :1;                                       /* Decimal or Binary Divider Select Bit */
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003BUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTDEC                    _RTICTL.Bits.RTDEC
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTR2_MASK                4U
#define RTICTL_RTR3_MASK                8U
#define RTICTL_RTR4_MASK                16U
#define RTICTL_RTR5_MASK                32U
#define RTICTL_RTR6_MASK                64U
#define RTICTL_RTDEC_MASK               128U
#define RTICTL_RTR_MASK                 127U
#define RTICTL_RTR_BITNUM               0U


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte WRTMASK     :1;                                       /* Write Mask for WCOP and CR[2:0] Bit */
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003CUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_WRTMASK                  _COPCTL.Bits.WRTMASK
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_WRTMASK_MASK             32U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1U
#define ARMCOP_BIT1_MASK                2U
#define ARMCOP_BIT2_MASK                4U
#define ARMCOP_BIT3_MASK                8U
#define ARMCOP_BIT4_MASK                16U
#define ARMCOP_BIT5_MASK                32U
#define ARMCOP_BIT6_MASK                64U
#define ARMCOP_BIT7_MASK                128U


/*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} TIOSSTR;
extern volatile TIOSSTR _TIOS @(REG_BASE + 0x00000040UL);
#define TIOS                            _TIOS.Byte
#define TIOS_IOS0                       _TIOS.Bits.IOS0
#define TIOS_IOS1                       _TIOS.Bits.IOS1
#define TIOS_IOS2                       _TIOS.Bits.IOS2
#define TIOS_IOS3                       _TIOS.Bits.IOS3
#define TIOS_IOS4                       _TIOS.Bits.IOS4
#define TIOS_IOS5                       _TIOS.Bits.IOS5
#define TIOS_IOS6                       _TIOS.Bits.IOS6
#define TIOS_IOS7                       _TIOS.Bits.IOS7

#define TIOS_IOS0_MASK                  1U
#define TIOS_IOS1_MASK                  2U
#define TIOS_IOS2_MASK                  4U
#define TIOS_IOS3_MASK                  8U
#define TIOS_IOS4_MASK                  16U
#define TIOS_IOS5_MASK                  32U
#define TIOS_IOS6_MASK                  64U
#define TIOS_IOS7_MASK                  128U


/*** CFORC - Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} CFORCSTR;
extern volatile CFORCSTR _CFORC @(REG_BASE + 0x00000041UL);
#define CFORC                           _CFORC.Byte
#define CFORC_FOC0                      _CFORC.Bits.FOC0
#define CFORC_FOC1                      _CFORC.Bits.FOC1
#define CFORC_FOC2                      _CFORC.Bits.FOC2
#define CFORC_FOC3                      _CFORC.Bits.FOC3
#define CFORC_FOC4                      _CFORC.Bits.FOC4
#define CFORC_FOC5                      _CFORC.Bits.FOC5
#define CFORC_FOC6                      _CFORC.Bits.FOC6
#define CFORC_FOC7                      _CFORC.Bits.FOC7

#define CFORC_FOC0_MASK                 1U
#define CFORC_FOC1_MASK                 2U
#define CFORC_FOC2_MASK                 4U
#define CFORC_FOC3_MASK                 8U
#define CFORC_FOC4_MASK                 16U
#define CFORC_FOC5_MASK                 32U
#define CFORC_FOC6_MASK                 64U
#define CFORC_FOC7_MASK                 128U


/*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} OC7MSTR;
extern volatile OC7MSTR _OC7M @(REG_BASE + 0x00000042UL);
#define OC7M                            _OC7M.Byte
#define OC7M_OC7M0                      _OC7M.Bits.OC7M0
#define OC7M_OC7M1                      _OC7M.Bits.OC7M1
#define OC7M_OC7M2                      _OC7M.Bits.OC7M2
#define OC7M_OC7M3                      _OC7M.Bits.OC7M3
#define OC7M_OC7M4                      _OC7M.Bits.OC7M4
#define OC7M_OC7M5                      _OC7M.Bits.OC7M5
#define OC7M_OC7M6                      _OC7M.Bits.OC7M6
#define OC7M_OC7M7                      _OC7M.Bits.OC7M7

#define OC7M_OC7M0_MASK                 1U
#define OC7M_OC7M1_MASK                 2U
#define OC7M_OC7M2_MASK                 4U
#define OC7M_OC7M3_MASK                 8U
#define OC7M_OC7M4_MASK                 16U
#define OC7M_OC7M5_MASK                 32U
#define OC7M_OC7M6_MASK                 64U
#define OC7M_OC7M7_MASK                 128U


/*** OC7D - Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
} OC7DSTR;
extern volatile OC7DSTR _OC7D @(REG_BASE + 0x00000043UL);
#define OC7D                            _OC7D.Byte


/*** TCNT - Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCNTHi - Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } TCNTHiSTR;
    #define TCNTHi                      _TCNT.Overlap_STR.TCNTHiSTR.Byte
    

    /*** TCNTLo - Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } TCNTLoSTR;
    #define TCNTLo                      _TCNT.Overlap_STR.TCNTLoSTR.Byte
    
  } Overlap_STR;

} TCNTSTR;
extern volatile TCNTSTR _TCNT @(REG_BASE + 0x00000044UL);
#define TCNT                            _TCNT.Word


/*** TSCR1 - Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PRNT        :1;                                       /* Precision Timer */
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TSCR1STR;
extern volatile TSCR1STR _TSCR1 @(REG_BASE + 0x00000046UL);
#define TSCR1                           _TSCR1.Byte
#define TSCR1_PRNT                      _TSCR1.Bits.PRNT
#define TSCR1_TFFCA                     _TSCR1.Bits.TFFCA
#define TSCR1_TSFRZ                     _TSCR1.Bits.TSFRZ
#define TSCR1_TSWAI                     _TSCR1.Bits.TSWAI
#define TSCR1_TEN                       _TSCR1.Bits.TEN

#define TSCR1_PRNT_MASK                 8U
#define TSCR1_TFFCA_MASK                16U
#define TSCR1_TSFRZ_MASK                32U
#define TSCR1_TSWAI_MASK                64U
#define TSCR1_TEN_MASK                  128U


/*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} TTOVSTR;
extern volatile TTOVSTR _TTOV @(REG_BASE + 0x00000047UL);
#define TTOV                            _TTOV.Byte
#define TTOV_TOV0                       _TTOV.Bits.TOV0
#define TTOV_TOV1                       _TTOV.Bits.TOV1
#define TTOV_TOV2                       _TTOV.Bits.TOV2
#define TTOV_TOV3                       _TTOV.Bits.TOV3
#define TTOV_TOV4                       _TTOV.Bits.TOV4
#define TTOV_TOV5                       _TTOV.Bits.TOV5
#define TTOV_TOV6                       _TTOV.Bits.TOV6
#define TTOV_TOV7                       _TTOV.Bits.TOV7

#define TTOV_TOV0_MASK                  1U
#define TTOV_TOV1_MASK                  2U
#define TTOV_TOV2_MASK                  4U
#define TTOV_TOV3_MASK                  8U
#define TTOV_TOV4_MASK                  16U
#define TTOV_TOV5_MASK                  32U
#define TTOV_TOV6_MASK                  64U
#define TTOV_TOV7_MASK                  128U


/*** TCTL1 - Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TCTL1STR;
extern volatile TCTL1STR _TCTL1 @(REG_BASE + 0x00000048UL);
#define TCTL1                           _TCTL1.Byte
#define TCTL1_OL4                       _TCTL1.Bits.OL4
#define TCTL1_OM4                       _TCTL1.Bits.OM4
#define TCTL1_OL5                       _TCTL1.Bits.OL5
#define TCTL1_OM5                       _TCTL1.Bits.OM5
#define TCTL1_OL6                       _TCTL1.Bits.OL6
#define TCTL1_OM6                       _TCTL1.Bits.OM6
#define TCTL1_OL7                       _TCTL1.Bits.OL7
#define TCTL1_OM7                       _TCTL1.Bits.OM7

#define TCTL1_OL4_MASK                  1U
#define TCTL1_OM4_MASK                  2U
#define TCTL1_OL5_MASK                  4U
#define TCTL1_OM5_MASK                  8U
#define TCTL1_OL6_MASK                  16U
#define TCTL1_OM6_MASK                  32U
#define TCTL1_OL7_MASK                  64U
#define TCTL1_OM7_MASK                  128U


/*** TCTL2 - Timer Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Level Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} TCTL2STR;
extern volatile TCTL2STR _TCTL2 @(REG_BASE + 0x00000049UL);
#define TCTL2                           _TCTL2.Byte
#define TCTL2_OL0                       _TCTL2.Bits.OL0
#define TCTL2_OM0                       _TCTL2.Bits.OM0
#define TCTL2_OL1                       _TCTL2.Bits.OL1
#define TCTL2_OM1                       _TCTL2.Bits.OM1
#define TCTL2_OL2                       _TCTL2.Bits.OL2
#define TCTL2_OM2                       _TCTL2.Bits.OM2
#define TCTL2_OL3                       _TCTL2.Bits.OL3
#define TCTL2_OM3                       _TCTL2.Bits.OM3

#define TCTL2_OL0_MASK                  1U
#define TCTL2_OM0_MASK                  2U
#define TCTL2_OL1_MASK                  4U
#define TCTL2_OM1_MASK                  8U
#define TCTL2_OL2_MASK                  16U
#define TCTL2_OM2_MASK                  32U
#define TCTL2_OL3_MASK                  64U
#define TCTL2_OM3_MASK                  128U


/*** TCTL3 - Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TCTL3STR;
extern volatile TCTL3STR _TCTL3 @(REG_BASE + 0x0000004AUL);
#define TCTL3                           _TCTL3.Byte
#define TCTL3_EDG4A                     _TCTL3.Bits.EDG4A
#define TCTL3_EDG4B                     _TCTL3.Bits.EDG4B
#define TCTL3_EDG5A                     _TCTL3.Bits.EDG5A
#define TCTL3_EDG5B                     _TCTL3.Bits.EDG5B
#define TCTL3_EDG6A                     _TCTL3.Bits.EDG6A
#define TCTL3_EDG6B                     _TCTL3.Bits.EDG6B
#define TCTL3_EDG7A                     _TCTL3.Bits.EDG7A
#define TCTL3_EDG7B                     _TCTL3.Bits.EDG7B
#define TCTL3_EDG4x                     _TCTL3.MergedBits.grpEDG4x
#define TCTL3_EDG5x                     _TCTL3.MergedBits.grpEDG5x
#define TCTL3_EDG6x                     _TCTL3.MergedBits.grpEDG6x
#define TCTL3_EDG7x                     _TCTL3.MergedBits.grpEDG7x

#define TCTL3_EDG4A_MASK                1U
#define TCTL3_EDG4B_MASK                2U
#define TCTL3_EDG5A_MASK                4U
#define TCTL3_EDG5B_MASK                8U
#define TCTL3_EDG6A_MASK                16U
#define TCTL3_EDG6B_MASK                32U
#define TCTL3_EDG7A_MASK                64U
#define TCTL3_EDG7B_MASK                128U
#define TCTL3_EDG4x_MASK                3U
#define TCTL3_EDG4x_BITNUM              0U
#define TCTL3_EDG5x_MASK                12U
#define TCTL3_EDG5x_BITNUM              2U
#define TCTL3_EDG6x_MASK                48U
#define TCTL3_EDG6x_BITNUM              4U
#define TCTL3_EDG7x_MASK                192U
#define TCTL3_EDG7x_BITNUM              6U


/*** TCTL4 - Timer Control Register 4; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} TCTL4STR;
extern volatile TCTL4STR _TCTL4 @(REG_BASE + 0x0000004BUL);
#define TCTL4                           _TCTL4.Byte
#define TCTL4_EDG0A                     _TCTL4.Bits.EDG0A
#define TCTL4_EDG0B                     _TCTL4.Bits.EDG0B
#define TCTL4_EDG1A                     _TCTL4.Bits.EDG1A
#define TCTL4_EDG1B                     _TCTL4.Bits.EDG1B
#define TCTL4_EDG2A                     _TCTL4.Bits.EDG2A
#define TCTL4_EDG2B                     _TCTL4.Bits.EDG2B
#define TCTL4_EDG3A                     _TCTL4.Bits.EDG3A
#define TCTL4_EDG3B                     _TCTL4.Bits.EDG3B
#define TCTL4_EDG0x                     _TCTL4.MergedBits.grpEDG0x
#define TCTL4_EDG1x                     _TCTL4.MergedBits.grpEDG1x
#define TCTL4_EDG2x                     _TCTL4.MergedBits.grpEDG2x
#define TCTL4_EDG3x                     _TCTL4.MergedBits.grpEDG3x

#define TCTL4_EDG0A_MASK                1U
#define TCTL4_EDG0B_MASK                2U
#define TCTL4_EDG1A_MASK                4U
#define TCTL4_EDG1B_MASK                8U
#define TCTL4_EDG2A_MASK                16U
#define TCTL4_EDG2B_MASK                32U
#define TCTL4_EDG3A_MASK                64U
#define TCTL4_EDG3B_MASK                128U
#define TCTL4_EDG0x_MASK                3U
#define TCTL4_EDG0x_BITNUM              0U
#define TCTL4_EDG1x_MASK                12U
#define TCTL4_EDG1x_BITNUM              2U
#define TCTL4_EDG2x_MASK                48U
#define TCTL4_EDG2x_BITNUM              4U
#define TCTL4_EDG3x_MASK                192U
#define TCTL4_EDG3x_BITNUM              6U


/*** TIE - Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIESTR;
extern volatile TIESTR _TIE @(REG_BASE + 0x0000004CUL);
#define TIE                             _TIE.Byte
#define TIE_C0I                         _TIE.Bits.C0I
#define TIE_C1I                         _TIE.Bits.C1I
#define TIE_C2I                         _TIE.Bits.C2I
#define TIE_C3I                         _TIE.Bits.C3I
#define TIE_C4I                         _TIE.Bits.C4I
#define TIE_C5I                         _TIE.Bits.C5I
#define TIE_C6I                         _TIE.Bits.C6I
#define TIE_C7I                         _TIE.Bits.C7I

#define TIE_C0I_MASK                    1U
#define TIE_C1I_MASK                    2U
#define TIE_C2I_MASK                    4U
#define TIE_C3I_MASK                    8U
#define TIE_C4I_MASK                    16U
#define TIE_C5I_MASK                    32U
#define TIE_C6I_MASK                    64U
#define TIE_C7I_MASK                    128U


/*** TSCR2 - Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSCR2STR;
extern volatile TSCR2STR _TSCR2 @(REG_BASE + 0x0000004DUL);
#define TSCR2                           _TSCR2.Byte
#define TSCR2_PR0                       _TSCR2.Bits.PR0
#define TSCR2_PR1                       _TSCR2.Bits.PR1
#define TSCR2_PR2                       _TSCR2.Bits.PR2
#define TSCR2_TCRE                      _TSCR2.Bits.TCRE
#define TSCR2_TOI                       _TSCR2.Bits.TOI
#define TSCR2_PR                        _TSCR2.MergedBits.grpPR

#define TSCR2_PR0_MASK                  1U
#define TSCR2_PR1_MASK                  2U
#define TSCR2_PR2_MASK                  4U
#define TSCR2_TCRE_MASK                 8U
#define TSCR2_TOI_MASK                  128U
#define TSCR2_PR_MASK                   7U
#define TSCR2_PR_BITNUM                 0U


/*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TFLG1STR;
extern volatile TFLG1STR _TFLG1 @(REG_BASE + 0x0000004EUL);
#define TFLG1                           _TFLG1.Byte
#define TFLG1_C0F                       _TFLG1.Bits.C0F
#define TFLG1_C1F                       _TFLG1.Bits.C1F
#define TFLG1_C2F                       _TFLG1.Bits.C2F
#define TFLG1_C3F                       _TFLG1.Bits.C3F
#define TFLG1_C4F                       _TFLG1.Bits.C4F
#define TFLG1_C5F                       _TFLG1.Bits.C5F
#define TFLG1_C6F                       _TFLG1.Bits.C6F
#define TFLG1_C7F                       _TFLG1.Bits.C7F

#define TFLG1_C0F_MASK                  1U
#define TFLG1_C1F_MASK                  2U
#define TFLG1_C2F_MASK                  4U
#define TFLG1_C3F_MASK                  8U
#define TFLG1_C4F_MASK                  16U
#define TFLG1_C5F_MASK                  32U
#define TFLG1_C6F_MASK                  64U
#define TFLG1_C7F_MASK                  128U


/*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TFLG2STR;
extern volatile TFLG2STR _TFLG2 @(REG_BASE + 0x0000004FUL);
#define TFLG2                           _TFLG2.Byte
#define TFLG2_TOF                       _TFLG2.Bits.TOF

#define TFLG2_TOF_MASK                  128U


/*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***/
    union {
      byte Byte;
    } TC0HiSTR;
    #define TC0Hi                       _TC0.Overlap_STR.TC0HiSTR.Byte
    

    /*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***/
    union {
      byte Byte;
    } TC0LoSTR;
    #define TC0Lo                       _TC0.Overlap_STR.TC0LoSTR.Byte
    
  } Overlap_STR;

} TC0STR;
extern volatile TC0STR _TC0 @(REG_BASE + 0x00000050UL);
#define TC0                             _TC0.Word
/* TC_ARR: Access 8 TCx registers in an array */
#define TC_ARR                          ((volatile word *) &TC0)


/*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***/
    union {
      byte Byte;
    } TC1HiSTR;
    #define TC1Hi                       _TC1.Overlap_STR.TC1HiSTR.Byte
    

    /*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***/
    union {
      byte Byte;
    } TC1LoSTR;
    #define TC1Lo                       _TC1.Overlap_STR.TC1LoSTR.Byte
    
  } Overlap_STR;

} TC1STR;
extern volatile TC1STR _TC1 @(REG_BASE + 0x00000052UL);
#define TC1                             _TC1.Word


/*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***/
    union {
      byte Byte;
    } TC2HiSTR;
    #define TC2Hi                       _TC2.Overlap_STR.TC2HiSTR.Byte
    

    /*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***/
    union {
      byte Byte;
    } TC2LoSTR;
    #define TC2Lo                       _TC2.Overlap_STR.TC2LoSTR.Byte
    
  } Overlap_STR;

} TC2STR;
extern volatile TC2STR _TC2 @(REG_BASE + 0x00000054UL);
#define TC2                             _TC2.Word


/*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***/
    union {
      byte Byte;
    } TC3HiSTR;
    #define TC3Hi                       _TC3.Overlap_STR.TC3HiSTR.Byte
    

    /*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***/
    union {
      byte Byte;
    } TC3LoSTR;
    #define TC3Lo                       _TC3.Overlap_STR.TC3LoSTR.Byte
    
  } Overlap_STR;

} TC3STR;
extern volatile TC3STR _TC3 @(REG_BASE + 0x00000056UL);
#define TC3                             _TC3.Word


/*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } TC4HiSTR;
    #define TC4Hi                       _TC4.Overlap_STR.TC4HiSTR.Byte
    

    /*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } TC4LoSTR;
    #define TC4Lo                       _TC4.Overlap_STR.TC4LoSTR.Byte
    
  } Overlap_STR;

} TC4STR;
extern volatile TC4STR _TC4 @(REG_BASE + 0x00000058UL);
#define TC4                             _TC4.Word


/*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } TC5HiSTR;
    #define TC5Hi                       _TC5.Overlap_STR.TC5HiSTR.Byte
    

    /*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } TC5LoSTR;
    #define TC5Lo                       _TC5.Overlap_STR.TC5LoSTR.Byte
    
  } Overlap_STR;

} TC5STR;
extern volatile TC5STR _TC5 @(REG_BASE + 0x0000005AUL);
#define TC5                             _TC5.Word


/*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } TC6HiSTR;
    #define TC6Hi                       _TC6.Overlap_STR.TC6HiSTR.Byte
    

    /*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } TC6LoSTR;
    #define TC6Lo                       _TC6.Overlap_STR.TC6LoSTR.Byte
    
  } Overlap_STR;

} TC6STR;
extern volatile TC6STR _TC6 @(REG_BASE + 0x0000005CUL);
#define TC6                             _TC6.Word


/*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } TC7HiSTR;
    #define TC7Hi                       _TC7.Overlap_STR.TC7HiSTR.Byte
    

    /*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } TC7LoSTR;
    #define TC7Lo                       _TC7.Overlap_STR.TC7LoSTR.Byte
    
  } Overlap_STR;

} TC7STR;
extern volatile TC7STR _TC7 @(REG_BASE + 0x0000005EUL);
#define TC7                             _TC7.Word


/*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PACTLSTR;
extern volatile PACTLSTR _PACTL @(REG_BASE + 0x00000060UL);
#define PACTL                           _PACTL.Byte
#define PACTL_PAI                       _PACTL.Bits.PAI
#define PACTL_PAOVI                     _PACTL.Bits.PAOVI
#define PACTL_CLK0                      _PACTL.Bits.CLK0
#define PACTL_CLK1                      _PACTL.Bits.CLK1
#define PACTL_PEDGE                     _PACTL.Bits.PEDGE
#define PACTL_PAMOD                     _PACTL.Bits.PAMOD
#define PACTL_PAEN                      _PACTL.Bits.PAEN
#define PACTL_CLK                       _PACTL.MergedBits.grpCLK

#define PACTL_PAI_MASK                  1U
#define PACTL_PAOVI_MASK                2U
#define PACTL_CLK0_MASK                 4U
#define PACTL_CLK1_MASK                 8U
#define PACTL_PEDGE_MASK                16U
#define PACTL_PAMOD_MASK                32U
#define PACTL_PAEN_MASK                 64U
#define PACTL_CLK_MASK                  12U
#define PACTL_CLK_BITNUM                2U


/*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PAFLGSTR;
extern volatile PAFLGSTR _PAFLG @(REG_BASE + 0x00000061UL);
#define PAFLG                           _PAFLG.Byte
#define PAFLG_PAIF                      _PAFLG.Bits.PAIF
#define PAFLG_PAOVF                     _PAFLG.Bits.PAOVF

#define PAFLG_PAIF_MASK                 1U
#define PAFLG_PAOVF_MASK                2U


/*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***/
    union {
      byte Byte;
    } PACN3STR;
    #define PACN3                       _PACN32.Overlap_STR.PACN3STR.Byte
    

    /*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***/
    union {
      byte Byte;
    } PACN2STR;
    #define PACN2                       _PACN32.Overlap_STR.PACN2STR.Byte
    
  } Overlap_STR;

} PACN32STR;
extern volatile PACN32STR _PACN32 @(REG_BASE + 0x00000062UL);
#define PACN32                          _PACN32.Word


/*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***/
    union {
      byte Byte;
    } PACN1STR;
    #define PACN1                       _PACN10.Overlap_STR.PACN1STR.Byte
    

    /*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***/
    union {
      byte Byte;
    } PACN0STR;
    #define PACN0                       _PACN10.Overlap_STR.PACN0STR.Byte
    
  } Overlap_STR;

} PACN10STR;
extern volatile PACN10STR _PACN10 @(REG_BASE + 0x00000064UL);
#define PACN10                          _PACN10.Word


/*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***/
typedef union {
  byte Byte;
  struct {
    byte MCPR0       :1;                                       /* Modulus Counter Prescaler select 0 */
    byte MCPR1       :1;                                       /* Modulus Counter Prescaler select 1 */
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte ICLAT       :1;                                       /* Input Capture Force Latch Action */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZI        :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
  struct {
    byte grpMCPR :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MCCTLSTR;
extern volatile MCCTLSTR _MCCTL @(REG_BASE + 0x00000066UL);
#define MCCTL                           _MCCTL.Byte
#define MCCTL_MCPR0                     _MCCTL.Bits.MCPR0
#define MCCTL_MCPR1                     _MCCTL.Bits.MCPR1
#define MCCTL_MCEN                      _MCCTL.Bits.MCEN
#define MCCTL_FLMC                      _MCCTL.Bits.FLMC
#define MCCTL_ICLAT                     _MCCTL.Bits.ICLAT
#define MCCTL_RDMCL                     _MCCTL.Bits.RDMCL
#define MCCTL_MODMC                     _MCCTL.Bits.MODMC
#define MCCTL_MCZI                      _MCCTL.Bits.MCZI
#define MCCTL_MCPR                      _MCCTL.MergedBits.grpMCPR

#define MCCTL_MCPR0_MASK                1U
#define MCCTL_MCPR1_MASK                2U
#define MCCTL_MCEN_MASK                 4U
#define MCCTL_FLMC_MASK                 8U
#define MCCTL_ICLAT_MASK                16U
#define MCCTL_RDMCL_MASK                32U
#define MCCTL_MODMC_MASK                64U
#define MCCTL_MCZI_MASK                 128U
#define MCCTL_MCPR_MASK                 3U
#define MCCTL_MCPR_BITNUM               0U


/*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***/
typedef union {
  byte Byte;
  struct {
    byte POLF0       :1;                                       /* First Input Capture Polarity Status 0 */
    byte POLF1       :1;                                       /* First Input Capture Polarity Status 1 */
    byte POLF2       :1;                                       /* First Input Capture Polarity Status 2 */
    byte POLF3       :1;                                       /* First Input Capture Polarity Status 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZF        :1;                                       /* Modulus Counter Underflow Flag */
  } Bits;
  struct {
    byte grpPOLF :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MCFLGSTR;
extern volatile MCFLGSTR _MCFLG @(REG_BASE + 0x00000067UL);
#define MCFLG                           _MCFLG.Byte
#define MCFLG_POLF0                     _MCFLG.Bits.POLF0
#define MCFLG_POLF1                     _MCFLG.Bits.POLF1
#define MCFLG_POLF2                     _MCFLG.Bits.POLF2
#define MCFLG_POLF3                     _MCFLG.Bits.POLF3
#define MCFLG_MCZF                      _MCFLG.Bits.MCZF
#define MCFLG_POLF                      _MCFLG.MergedBits.grpPOLF

#define MCFLG_POLF0_MASK                1U
#define MCFLG_POLF1_MASK                2U
#define MCFLG_POLF2_MASK                4U
#define MCFLG_POLF3_MASK                8U
#define MCFLG_MCZF_MASK                 128U
#define MCFLG_POLF_MASK                 15U
#define MCFLG_POLF_BITNUM               0U


/*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***/
typedef union {
  byte Byte;
  struct {
    byte PA0EN       :1;                                       /* 8-Bit Pulse Accumulator 0 Enable */
    byte PA1EN       :1;                                       /* 8-Bit Pulse Accumulator 1 Enable */
    byte PA2EN       :1;                                       /* 8-Bit Pulse Accumulator 2 Enable */
    byte PA3EN       :1;                                       /* 8-Bit Pulse Accumulator 3 Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ICPARSTR;
extern volatile ICPARSTR _ICPAR @(REG_BASE + 0x00000068UL);
#define ICPAR                           _ICPAR.Byte
#define ICPAR_PA0EN                     _ICPAR.Bits.PA0EN
#define ICPAR_PA1EN                     _ICPAR.Bits.PA1EN
#define ICPAR_PA2EN                     _ICPAR.Bits.PA2EN
#define ICPAR_PA3EN                     _ICPAR.Bits.PA3EN

#define ICPAR_PA0EN_MASK                1U
#define ICPAR_PA1EN_MASK                2U
#define ICPAR_PA2EN_MASK                4U
#define ICPAR_PA3EN_MASK                8U


/*** DLYCT - Delay Counter Control Register; 0x00000069 ***/
typedef union {
  byte Byte;
  struct {
    byte DLY0        :1;                                       /* Delay Counter Select Bit 0 */
    byte DLY1        :1;                                       /* Delay Counter Select Bit 1 */
    byte DLY2        :1;                                       /* Delay Counter Select Bit 2 */
    byte DLY3        :1;                                       /* Delay Counter Select Bit 3 */
    byte DLY4        :1;                                       /* Delay Counter Select Bit 4 */
    byte DLY5        :1;                                       /* Delay Counter Select Bit 5 */
    byte DLY6        :1;                                       /* Delay Counter Select Bit 6 */
    byte DLY7        :1;                                       /* Delay Counter Select Bit 7 */
  } Bits;
} DLYCTSTR;
extern volatile DLYCTSTR _DLYCT @(REG_BASE + 0x00000069UL);
#define DLYCT                           _DLYCT.Byte
#define DLYCT_DLY0                      _DLYCT.Bits.DLY0
#define DLYCT_DLY1                      _DLYCT.Bits.DLY1
#define DLYCT_DLY2                      _DLYCT.Bits.DLY2
#define DLYCT_DLY3                      _DLYCT.Bits.DLY3
#define DLYCT_DLY4                      _DLYCT.Bits.DLY4
#define DLYCT_DLY5                      _DLYCT.Bits.DLY5
#define DLYCT_DLY6                      _DLYCT.Bits.DLY6
#define DLYCT_DLY7                      _DLYCT.Bits.DLY7

#define DLYCT_DLY0_MASK                 1U
#define DLYCT_DLY1_MASK                 2U
#define DLYCT_DLY2_MASK                 4U
#define DLYCT_DLY3_MASK                 8U
#define DLYCT_DLY4_MASK                 16U
#define DLYCT_DLY5_MASK                 32U
#define DLYCT_DLY6_MASK                 64U
#define DLYCT_DLY7_MASK                 128U


/*** ICOVW - Input Control Overwrite Register; 0x0000006A ***/
typedef union {
  byte Byte;
  struct {
    byte NOVW0       :1;                                       /* No Input Capture Overwrite 0 */
    byte NOVW1       :1;                                       /* No Input Capture Overwrite 1 */
    byte NOVW2       :1;                                       /* No Input Capture Overwrite 2 */
    byte NOVW3       :1;                                       /* No Input Capture Overwrite 3 */
    byte NOVW4       :1;                                       /* No Input Capture Overwrite 4 */
    byte NOVW5       :1;                                       /* No Input Capture Overwrite 5 */
    byte NOVW6       :1;                                       /* No Input Capture Overwrite 6 */
    byte NOVW7       :1;                                       /* No Input Capture Overwrite 7 */
  } Bits;
} ICOVWSTR;
extern volatile ICOVWSTR _ICOVW @(REG_BASE + 0x0000006AUL);
#define ICOVW                           _ICOVW.Byte
#define ICOVW_NOVW0                     _ICOVW.Bits.NOVW0
#define ICOVW_NOVW1                     _ICOVW.Bits.NOVW1
#define ICOVW_NOVW2                     _ICOVW.Bits.NOVW2
#define ICOVW_NOVW3                     _ICOVW.Bits.NOVW3
#define ICOVW_NOVW4                     _ICOVW.Bits.NOVW4
#define ICOVW_NOVW5                     _ICOVW.Bits.NOVW5
#define ICOVW_NOVW6                     _ICOVW.Bits.NOVW6
#define ICOVW_NOVW7                     _ICOVW.Bits.NOVW7

#define ICOVW_NOVW0_MASK                1U
#define ICOVW_NOVW1_MASK                2U
#define ICOVW_NOVW2_MASK                4U
#define ICOVW_NOVW3_MASK                8U
#define ICOVW_NOVW4_MASK                16U
#define ICOVW_NOVW5_MASK                32U
#define ICOVW_NOVW6_MASK                64U
#define ICOVW_NOVW7_MASK                128U


/*** ICSYS - Input Control System Control Register; 0x0000006B ***/
typedef union {
  byte Byte;
  struct {
    byte LATQ        :1;                                       /* Input Control Latch or Queue Mode Enable */
    byte BUFEN       :1;                                       /* IC Buffer Enable */
    byte PACMX       :1;                                       /* 8-Bit Pulse Accumulators Maximum Count */
    byte TFMOD       :1;                                       /* Timer Flag-setting Mode */
    byte SH04        :1;                                       /* Share Input action of Input Capture Channels 0 and 4 */
    byte SH15        :1;                                       /* Share Input action of Input Capture Channels 1 and 5 */
    byte SH26        :1;                                       /* Share Input action of Input Capture Channels 2 and 6 */
    byte SH37        :1;                                       /* Share Input action of Input Capture Channels 3 and 7 */
  } Bits;
} ICSYSSTR;
extern volatile ICSYSSTR _ICSYS @(REG_BASE + 0x0000006BUL);
#define ICSYS                           _ICSYS.Byte
#define ICSYS_LATQ                      _ICSYS.Bits.LATQ
#define ICSYS_BUFEN                     _ICSYS.Bits.BUFEN
#define ICSYS_PACMX                     _ICSYS.Bits.PACMX
#define ICSYS_TFMOD                     _ICSYS.Bits.TFMOD
#define ICSYS_SH04                      _ICSYS.Bits.SH04
#define ICSYS_SH15                      _ICSYS.Bits.SH15
#define ICSYS_SH26                      _ICSYS.Bits.SH26
#define ICSYS_SH37                      _ICSYS.Bits.SH37

#define ICSYS_LATQ_MASK                 1U
#define ICSYS_BUFEN_MASK                2U
#define ICSYS_PACMX_MASK                4U
#define ICSYS_TFMOD_MASK                8U
#define ICSYS_SH04_MASK                 16U
#define ICSYS_SH15_MASK                 32U
#define ICSYS_SH26_MASK                 64U
#define ICSYS_SH37_MASK                 128U


/*** PTPSR - Precision Timer Prescaler Select; 0x0000006E ***/
typedef union {
  byte Byte;
  struct {
    byte PTPS0       :1;                                       /* Precision Timer Prescaler Select Bit 0 */
    byte PTPS1       :1;                                       /* Precision Timer Prescaler Select Bit 1 */
    byte PTPS2       :1;                                       /* Precision Timer Prescaler Select Bit 2 */
    byte PTPS3       :1;                                       /* Precision Timer Prescaler Select Bit 3 */
    byte PTPS4       :1;                                       /* Precision Timer Prescaler Select Bit 4 */
    byte PTPS5       :1;                                       /* Precision Timer Prescaler Select Bit 5 */
    byte PTPS6       :1;                                       /* Precision Timer Prescaler Select Bit 6 */
    byte PTPS7       :1;                                       /* Precision Timer Prescaler Select Bit 7 */
  } Bits;
} PTPSRSTR;
extern volatile PTPSRSTR _PTPSR @(REG_BASE + 0x0000006EUL);
#define PTPSR                           _PTPSR.Byte
#define PTPSR_PTPS0                     _PTPSR.Bits.PTPS0
#define PTPSR_PTPS1                     _PTPSR.Bits.PTPS1
#define PTPSR_PTPS2                     _PTPSR.Bits.PTPS2
#define PTPSR_PTPS3                     _PTPSR.Bits.PTPS3
#define PTPSR_PTPS4                     _PTPSR.Bits.PTPS4
#define PTPSR_PTPS5                     _PTPSR.Bits.PTPS5
#define PTPSR_PTPS6                     _PTPSR.Bits.PTPS6
#define PTPSR_PTPS7                     _PTPSR.Bits.PTPS7

#define PTPSR_PTPS0_MASK                1U
#define PTPSR_PTPS1_MASK                2U
#define PTPSR_PTPS2_MASK                4U
#define PTPSR_PTPS3_MASK                8U
#define PTPSR_PTPS4_MASK                16U
#define PTPSR_PTPS5_MASK                32U
#define PTPSR_PTPS6_MASK                64U
#define PTPSR_PTPS7_MASK                128U


/*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***/
typedef union {
  byte Byte;
  struct {
    byte PTMPS0      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 0 */
    byte PTMPS1      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 1 */
    byte PTMPS2      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 2 */
    byte PTMPS3      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 3 */
    byte PTMPS4      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 4 */
    byte PTMPS5      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 5 */
    byte PTMPS6      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 6 */
    byte PTMPS7      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 7 */
  } Bits;
} PTMCPSRSTR;
extern volatile PTMCPSRSTR _PTMCPSR @(REG_BASE + 0x0000006FUL);
#define PTMCPSR                         _PTMCPSR.Byte
#define PTMCPSR_PTMPS0                  _PTMCPSR.Bits.PTMPS0
#define PTMCPSR_PTMPS1                  _PTMCPSR.Bits.PTMPS1
#define PTMCPSR_PTMPS2                  _PTMCPSR.Bits.PTMPS2
#define PTMCPSR_PTMPS3                  _PTMCPSR.Bits.PTMPS3
#define PTMCPSR_PTMPS4                  _PTMCPSR.Bits.PTMPS4
#define PTMCPSR_PTMPS5                  _PTMCPSR.Bits.PTMPS5
#define PTMCPSR_PTMPS6                  _PTMCPSR.Bits.PTMPS6
#define PTMCPSR_PTMPS7                  _PTMCPSR.Bits.PTMPS7

#define PTMCPSR_PTMPS0_MASK             1U
#define PTMCPSR_PTMPS1_MASK             2U
#define PTMCPSR_PTMPS2_MASK             4U
#define PTMCPSR_PTMPS3_MASK             8U
#define PTMCPSR_PTMPS4_MASK             16U
#define PTMCPSR_PTMPS5_MASK             32U
#define PTMCPSR_PTMPS6_MASK             64U
#define PTMCPSR_PTMPS7_MASK             128U


/*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PBOVI       :1;                                       /* Pulse Accumulator B Overflow Interrupt enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PBEN        :1;                                       /* Pulse Accumulator B System Enable */
    byte             :1; 
  } Bits;
} PBCTLSTR;
extern volatile PBCTLSTR _PBCTL @(REG_BASE + 0x00000070UL);
#define PBCTL                           _PBCTL.Byte
#define PBCTL_PBOVI                     _PBCTL.Bits.PBOVI
#define PBCTL_PBEN                      _PBCTL.Bits.PBEN

#define PBCTL_PBOVI_MASK                2U
#define PBCTL_PBEN_MASK                 64U


/*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PBOVF       :1;                                       /* Pulse Accumulator B Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PBFLGSTR;
extern volatile PBFLGSTR _PBFLG @(REG_BASE + 0x00000071UL);
#define PBFLG                           _PBFLG.Byte
#define PBFLG_PBOVF                     _PBFLG.Bits.PBOVF

#define PBFLG_PBOVF_MASK                2U


/*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***/
    union {
      byte Byte;
    } PA3HSTR;
    #define PA3H                        _PA32H.Overlap_STR.PA3HSTR.Byte
    

    /*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***/
    union {
      byte Byte;
    } PA2HSTR;
    #define PA2H                        _PA32H.Overlap_STR.PA2HSTR.Byte
    
  } Overlap_STR;

} PA32HSTR;
extern volatile PA32HSTR _PA32H @(REG_BASE + 0x00000072UL);
#define PA32H                           _PA32H.Word


/*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***/
    union {
      byte Byte;
    } PA1HSTR;
    #define PA1H                        _PA10H.Overlap_STR.PA1HSTR.Byte
    

    /*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***/
    union {
      byte Byte;
    } PA0HSTR;
    #define PA0H                        _PA10H.Overlap_STR.PA0HSTR.Byte
    
  } Overlap_STR;

} PA10HSTR;
extern volatile PA10HSTR _PA10H @(REG_BASE + 0x00000074UL);
#define PA10H                           _PA10H.Word


/*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***/
    union {
      byte Byte;
    } MCCNThiSTR;
    #define MCCNThi                     _MCCNT.Overlap_STR.MCCNThiSTR.Byte
    

    /*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***/
    union {
      byte Byte;
    } MCCNTloSTR;
    #define MCCNTlo                     _MCCNT.Overlap_STR.MCCNTloSTR.Byte
    
  } Overlap_STR;

} MCCNTSTR;
extern volatile MCCNTSTR _MCCNT @(REG_BASE + 0x00000076UL);
#define MCCNT                           _MCCNT.Word


/*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hhi - Timer Input Capture Holding Registers 0 High; 0x00000078 ***/
    union {
      byte Byte;
    } TC0HhiSTR;
    #define TC0Hhi                      _TC0H.Overlap_STR.TC0HhiSTR.Byte
    

    /*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***/
    union {
      byte Byte;
    } TC0HloSTR;
    #define TC0Hlo                      _TC0H.Overlap_STR.TC0HloSTR.Byte
    
  } Overlap_STR;

} TC0HSTR;
extern volatile TC0HSTR _TC0H @(REG_BASE + 0x00000078UL);
#define TC0H                            _TC0H.Word


/*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***/
    union {
      byte Byte;
    } TC1HhiSTR;
    #define TC1Hhi                      _TC1H.Overlap_STR.TC1HhiSTR.Byte
    

    /*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***/
    union {
      byte Byte;
    } TC1HloSTR;
    #define TC1Hlo                      _TC1H.Overlap_STR.TC1HloSTR.Byte
    
  } Overlap_STR;

} TC1HSTR;
extern volatile TC1HSTR _TC1H @(REG_BASE + 0x0000007AUL);
#define TC1H                            _TC1H.Word


/*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***/
    union {
      byte Byte;
    } TC2HhiSTR;
    #define TC2Hhi                      _TC2H.Overlap_STR.TC2HhiSTR.Byte
    

    /*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***/
    union {
      byte Byte;
    } TC2HloSTR;
    #define TC2Hlo                      _TC2H.Overlap_STR.TC2HloSTR.Byte
    
  } Overlap_STR;

} TC2HSTR;
extern volatile TC2HSTR _TC2H @(REG_BASE + 0x0000007CUL);
#define TC2H                            _TC2H.Word


/*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***/
    union {
      byte Byte;
    } TC3HhiSTR;
    #define TC3Hhi                      _TC3H.Overlap_STR.TC3HhiSTR.Byte
    

    /*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***/
    union {
      byte Byte;
    } TC3HloSTR;
    #define TC3Hlo                      _TC3H.Overlap_STR.TC3HloSTR.Byte
    
  } Overlap_STR;

} TC3HSTR;
extern volatile TC3HSTR _TC3H @(REG_BASE + 0x0000007EUL);
#define TC3H                            _TC3H.Word


/*** ATD1CTL01 - ATD 1 Control Register 01; 0x00000080 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL0 - ATD 1 Control Register 0; 0x00000080 ***/
    union {
      byte Byte;
      struct {
        byte WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
        byte WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
        byte WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
        byte WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpWRAP :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL0STR;
    #define ATD1CTL0                    _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Byte
    #define ATD1CTL0_WRAP0              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP0
    #define ATD1CTL0_WRAP1              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP1
    #define ATD1CTL0_WRAP2              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP2
    #define ATD1CTL0_WRAP3              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP3
    /* ATD1CTL_ARR: Access 6 ATD1CTLx registers in an array */
    #define ATD1CTL_ARR                 ((volatile byte *) &ATD1CTL0)
    #define ATD1CTL0_WRAP               _ATD1CTL01.Overlap_STR.ATD1CTL0STR.MergedBits.grpWRAP
    
    #define ATD1CTL0_WRAP0_MASK         1U
    #define ATD1CTL0_WRAP1_MASK         2U
    #define ATD1CTL0_WRAP2_MASK         4U
    #define ATD1CTL0_WRAP3_MASK         8U
    #define ATD1CTL0_WRAP_MASK          15U
    #define ATD1CTL0_WRAP_BITNUM        0U
    

    /*** ATD1CTL1 - ATD1 Control Register 1; 0x00000081 ***/
    union {
      byte Byte;
      struct {
        byte ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
        byte ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
        byte ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
        byte ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ETRIGSEL    :1;                                       /* External Trigger Source Select */
      } Bits;
      struct {
        byte grpETRIGCH :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL1STR;
    #define ATD1CTL1                    _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Byte
    #define ATD1CTL1_ETRIGCH0           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH0
    #define ATD1CTL1_ETRIGCH1           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH1
    #define ATD1CTL1_ETRIGCH2           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH2
    #define ATD1CTL1_ETRIGCH3           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH3
    #define ATD1CTL1_ETRIGSEL           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGSEL
    #define ATD1CTL1_ETRIGCH            _ATD1CTL01.Overlap_STR.ATD1CTL1STR.MergedBits.grpETRIGCH
    
    #define ATD1CTL1_ETRIGCH0_MASK      1U
    #define ATD1CTL1_ETRIGCH1_MASK      2U
    #define ATD1CTL1_ETRIGCH2_MASK      4U
    #define ATD1CTL1_ETRIGCH3_MASK      8U
    #define ATD1CTL1_ETRIGSEL_MASK      128U
    #define ATD1CTL1_ETRIGCH_MASK       15U
    #define ATD1CTL1_ETRIGCH_BITNUM     0U
    
  } Overlap_STR;

  struct {
    word ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
    word ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
    word ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
    word ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word ETRIGSEL    :1;                                       /* External Trigger Source Select */
    word WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
    word WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
    word WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
    word WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpETRIGCH :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpWRAP :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATD1CTL01STR;
extern volatile ATD1CTL01STR _ATD1CTL01 @(REG_BASE + 0x00000080UL);
#define ATD1CTL01                       _ATD1CTL01.Word
#define ATD1CTL01_ETRIGCH0              _ATD1CTL01.Bits.ETRIGCH0
#define ATD1CTL01_ETRIGCH1              _ATD1CTL01.Bits.ETRIGCH1
#define ATD1CTL01_ETRIGCH2              _ATD1CTL01.Bits.ETRIGCH2
#define ATD1CTL01_ETRIGCH3              _ATD1CTL01.Bits.ETRIGCH3
#define ATD1CTL01_ETRIGSEL              _ATD1CTL01.Bits.ETRIGSEL
#define ATD1CTL01_WRAP0                 _ATD1CTL01.Bits.WRAP0
#define ATD1CTL01_WRAP1                 _ATD1CTL01.Bits.WRAP1
#define ATD1CTL01_WRAP2                 _ATD1CTL01.Bits.WRAP2
#define ATD1CTL01_WRAP3                 _ATD1CTL01.Bits.WRAP3
#define ATD1CTL01_ETRIGCH               _ATD1CTL01.MergedBits.grpETRIGCH
#define ATD1CTL01_WRAP                  _ATD1CTL01.MergedBits.grpWRAP

#define ATD1CTL01_ETRIGCH0_MASK         1U
#define ATD1CTL01_ETRIGCH1_MASK         2U
#define ATD1CTL01_ETRIGCH2_MASK         4U
#define ATD1CTL01_ETRIGCH3_MASK         8U
#define ATD1CTL01_ETRIGSEL_MASK         128U
#define ATD1CTL01_WRAP0_MASK            256U
#define ATD1CTL01_WRAP1_MASK            512U
#define ATD1CTL01_WRAP2_MASK            1024U
#define ATD1CTL01_WRAP3_MASK            2048U
#define ATD1CTL01_ETRIGCH_MASK          15U
#define ATD1CTL01_ETRIGCH_BITNUM        0U
#define ATD1CTL01_WRAP_MASK             3840U
#define ATD1CTL01_WRAP_BITNUM           8U


/*** ATD1CTL23 - ATD 1 Control Register 23; 0x00000082 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL2 - ATD 1 Control Register 2; 0x00000082 ***/
    union {
      byte Byte;
      struct {
        byte ASCIF       :1;                                       /* ATD 1 Sequence Complete Interrupt Flag */
        byte ASCIE       :1;                                       /* ATD 1 Sequence Complete Interrupt Enable */
        byte ETRIGE      :1;                                       /* External Trigger Mode enable */
        byte ETRIGP      :1;                                       /* External Trigger Polarity */
        byte ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
        byte AWAI        :1;                                       /* ATD Power Down in Wait Mode */
        byte AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
        byte ADPU        :1;                                       /* ATD Disable / Power Down */
      } Bits;
    } ATD1CTL2STR;
    #define ATD1CTL2                    _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Byte
    #define ATD1CTL2_ASCIF              _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ASCIF
    #define ATD1CTL2_ASCIE              _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ASCIE
    #define ATD1CTL2_ETRIGE             _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGE
    #define ATD1CTL2_ETRIGP             _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGP
    #define ATD1CTL2_ETRIGLE            _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGLE
    #define ATD1CTL2_AWAI               _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.AWAI
    #define ATD1CTL2_AFFC               _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.AFFC
    #define ATD1CTL2_ADPU               _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ADPU
    
    #define ATD1CTL2_ASCIF_MASK         1U
    #define ATD1CTL2_ASCIE_MASK         2U
    #define ATD1CTL2_ETRIGE_MASK        4U
    #define ATD1CTL2_ETRIGP_MASK        8U
    #define ATD1CTL2_ETRIGLE_MASK       16U
    #define ATD1CTL2_AWAI_MASK          32U
    #define ATD1CTL2_AFFC_MASK          64U
    #define ATD1CTL2_ADPU_MASK          128U
    

    /*** ATD1CTL3 - ATD 1 Control Register 3; 0x00000083 ***/
    union {
      byte Byte;
      struct {
        byte FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
        byte FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
        byte FIFO        :1;                                       /* Result Register FIFO Mode */
        byte S1C         :1;                                       /* Conversion Sequence Length 1 */
        byte S2C         :1;                                       /* Conversion Sequence Length 2 */
        byte S4C         :1;                                       /* Conversion Sequence Length 4 */
        byte S8C         :1;                                       /* Conversion Sequence Length 8 */
        byte             :1; 
      } Bits;
      struct {
        byte grpFRZ :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL3STR;
    #define ATD1CTL3                    _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Byte
    #define ATD1CTL3_FRZ0               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FRZ0
    #define ATD1CTL3_FRZ1               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FRZ1
    #define ATD1CTL3_FIFO               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FIFO
    #define ATD1CTL3_S1C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S1C
    #define ATD1CTL3_S2C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S2C
    #define ATD1CTL3_S4C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S4C
    #define ATD1CTL3_S8C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S8C
    #define ATD1CTL3_FRZ                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.MergedBits.grpFRZ
    
    #define ATD1CTL3_FRZ0_MASK          1U
    #define ATD1CTL3_FRZ1_MASK          2U
    #define ATD1CTL3_FIFO_MASK          4U
    #define ATD1CTL3_S1C_MASK           8U
    #define ATD1CTL3_S2C_MASK           16U
    #define ATD1CTL3_S4C_MASK           32U
    #define ATD1CTL3_S8C_MASK           64U
    #define ATD1CTL3_FRZ_MASK           3U
    #define ATD1CTL3_FRZ_BITNUM         0U
    
  } Overlap_STR;

  struct {
    word FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
    word FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
    word FIFO        :1;                                       /* Result Register FIFO Mode */
    word S1C         :1;                                       /* Conversion Sequence Length 1 */
    word S2C         :1;                                       /* Conversion Sequence Length 2 */
    word S4C         :1;                                       /* Conversion Sequence Length 4 */
    word S8C         :1;                                       /* Conversion Sequence Length 8 */
    word             :1; 
    word ASCIF       :1;                                       /* ATD 1 Sequence Complete Interrupt Flag */
    word ASCIE       :1;                                       /* ATD 1 Sequence Complete Interrupt Enable */
    word ETRIGE      :1;                                       /* External Trigger Mode enable */
    word ETRIGP      :1;                                       /* External Trigger Polarity */
    word ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
    word AWAI        :1;                                       /* ATD Power Down in Wait Mode */
    word AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
    word ADPU        :1;                                       /* ATD Disable / Power Down */
  } Bits;
  struct {
    word grpFRZ  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATD1CTL23STR;
extern volatile ATD1CTL23STR _ATD1CTL23 @(REG_BASE + 0x00000082UL);
#define ATD1CTL23                       _ATD1CTL23.Word
#define ATD1CTL23_FRZ0                  _ATD1CTL23.Bits.FRZ0
#define ATD1CTL23_FRZ1                  _ATD1CTL23.Bits.FRZ1
#define ATD1CTL23_FIFO                  _ATD1CTL23.Bits.FIFO
#define ATD1CTL23_S1C                   _ATD1CTL23.Bits.S1C
#define ATD1CTL23_S2C                   _ATD1CTL23.Bits.S2C
#define ATD1CTL23_S4C                   _ATD1CTL23.Bits.S4C
#define ATD1CTL23_S8C                   _ATD1CTL23.Bits.S8C
#define ATD1CTL23_ASCIF                 _ATD1CTL23.Bits.ASCIF
#define ATD1CTL23_ASCIE                 _ATD1CTL23.Bits.ASCIE
#define ATD1CTL23_ETRIGE                _ATD1CTL23.Bits.ETRIGE
#define ATD1CTL23_ETRIGP                _ATD1CTL23.Bits.ETRIGP
#define ATD1CTL23_ETRIGLE               _ATD1CTL23.Bits.ETRIGLE
#define ATD1CTL23_AWAI                  _ATD1CTL23.Bits.AWAI
#define ATD1CTL23_AFFC                  _ATD1CTL23.Bits.AFFC
#define ATD1CTL23_ADPU                  _ATD1CTL23.Bits.ADPU
#define ATD1CTL23_FRZ                   _ATD1CTL23.MergedBits.grpFRZ

#define ATD1CTL23_FRZ0_MASK             1U
#define ATD1CTL23_FRZ1_MASK             2U
#define ATD1CTL23_FIFO_MASK             4U
#define ATD1CTL23_S1C_MASK              8U
#define ATD1CTL23_S2C_MASK              16U
#define ATD1CTL23_S4C_MASK              32U
#define ATD1CTL23_S8C_MASK              64U
#define ATD1CTL23_ASCIF_MASK            256U
#define ATD1CTL23_ASCIE_MASK            512U
#define ATD1CTL23_ETRIGE_MASK           1024U
#define ATD1CTL23_ETRIGP_MASK           2048U
#define ATD1CTL23_ETRIGLE_MASK          4096U
#define ATD1CTL23_AWAI_MASK             8192U
#define ATD1CTL23_AFFC_MASK             16384U
#define ATD1CTL23_ADPU_MASK             32768U
#define ATD1CTL23_FRZ_MASK              3U
#define ATD1CTL23_FRZ_BITNUM            0U


/*** ATD1CTL45 - ATD 1 Control Register 45; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL4 - ATD 1 Control Register 4; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte PRS0        :1;                                       /* ATD Clock Prescaler 0 */
        byte PRS1        :1;                                       /* ATD Clock Prescaler 1 */
        byte PRS2        :1;                                       /* ATD Clock Prescaler 2 */
        byte PRS3        :1;                                       /* ATD Clock Prescaler 3 */
        byte PRS4        :1;                                       /* ATD Clock Prescaler 4 */
        byte SMP0        :1;                                       /* Sample Time Select 0 */
        byte SMP1        :1;                                       /* Sample Time Select 1 */
        byte SRES8       :1;                                       /* ATD Resolution Select */
      } Bits;
      struct {
        byte grpPRS :5;
        byte grpSMP :2;
        byte grpSRES_8 :1;
      } MergedBits;
    } ATD1CTL4STR;
    #define ATD1CTL4                    _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Byte
    #define ATD1CTL4_PRS0               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS0
    #define ATD1CTL4_PRS1               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS1
    #define ATD1CTL4_PRS2               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS2
    #define ATD1CTL4_PRS3               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS3
    #define ATD1CTL4_PRS4               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS4
    #define ATD1CTL4_SMP0               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SMP0
    #define ATD1CTL4_SMP1               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SMP1
    #define ATD1CTL4_SRES8              _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SRES8
    #define ATD1CTL4_PRS                _ATD1CTL45.Overlap_STR.ATD1CTL4STR.MergedBits.grpPRS
    #define ATD1CTL4_SMP                _ATD1CTL45.Overlap_STR.ATD1CTL4STR.MergedBits.grpSMP
    
    #define ATD1CTL4_PRS0_MASK          1U
    #define ATD1CTL4_PRS1_MASK          2U
    #define ATD1CTL4_PRS2_MASK          4U
    #define ATD1CTL4_PRS3_MASK          8U
    #define ATD1CTL4_PRS4_MASK          16U
    #define ATD1CTL4_SMP0_MASK          32U
    #define ATD1CTL4_SMP1_MASK          64U
    #define ATD1CTL4_SRES8_MASK         128U
    #define ATD1CTL4_PRS_MASK           31U
    #define ATD1CTL4_PRS_BITNUM         0U
    #define ATD1CTL4_SMP_MASK           96U
    #define ATD1CTL4_SMP_BITNUM         5U
    

    /*** ATD1CTL5 - ATD 1 Control Register 5; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte CA          :1;                                       /* Analog Input Channel Select Code A */
        byte CB          :1;                                       /* Analog Input Channel Select Code B */
        byte CC          :1;                                       /* Analog Input Channel Select Code C */
        byte CD          :1;                                       /* Analog Input Channel Select Code D */
        byte MULT        :1;                                       /* Multi-Channel Sample Mode */
        byte SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
        byte DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
        byte DJM         :1;                                       /* Result Register Data Justification Mode */
      } Bits;
      struct {
        byte grpCx :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL5STR;
    #define ATD1CTL5                    _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Byte
    #define ATD1CTL5_CA                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CA
    #define ATD1CTL5_CB                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CB
    #define ATD1CTL5_CC                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CC
    #define ATD1CTL5_CD                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CD
    #define ATD1CTL5_MULT               _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.MULT
    #define ATD1CTL5_SCAN               _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.SCAN
    #define ATD1CTL5_DSGN               _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.DSGN
    #define ATD1CTL5_DJM                _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.DJM
    #define ATD1CTL5_Cx                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.MergedBits.grpCx
    
    #define ATD1CTL5_CA_MASK            1U
    #define ATD1CTL5_CB_MASK            2U
    #define ATD1CTL5_CC_MASK            4U
    #define ATD1CTL5_CD_MASK            8U
    #define ATD1CTL5_MULT_MASK          16U
    #define ATD1CTL5_SCAN_MASK          32U
    #define ATD1CTL5_DSGN_MASK          64U
    #define ATD1CTL5_DJM_MASK           128U
    #define ATD1CTL5_Cx_MASK            15U
    #define ATD1CTL5_Cx_BITNUM          0U
    
  } Overlap_STR;

  struct {
    word CA          :1;                                       /* Analog Input Channel Select Code A */
    word CB          :1;                                       /* Analog Input Channel Select Code B */
    word CC          :1;                                       /* Analog Input Channel Select Code C */
    word CD          :1;                                       /* Analog Input Channel Select Code D */
    word MULT        :1;                                       /* Multi-Channel Sample Mode */
    word SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
    word DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
    word DJM         :1;                                       /* Result Register Data Justification Mode */
    word PRS0        :1;                                       /* ATD Clock Prescaler 0 */
    word PRS1        :1;                                       /* ATD Clock Prescaler 1 */
    word PRS2        :1;                                       /* ATD Clock Prescaler 2 */
    word PRS3        :1;                                       /* ATD Clock Prescaler 3 */
    word PRS4        :1;                                       /* ATD Clock Prescaler 4 */
    word SMP0        :1;                                       /* Sample Time Select 0 */
    word SMP1        :1;                                       /* Sample Time Select 1 */
    word SRES8       :1;                                       /* ATD Resolution Select */
  } Bits;
  struct {
    word grpCx   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRS  :5;
    word grpSMP  :2;
    word grpSRES_8 :1;
  } MergedBits;
} ATD1CTL45STR;
extern volatile ATD1CTL45STR _ATD1CTL45 @(REG_BASE + 0x00000084UL);
#define ATD1CTL45                       _ATD1CTL45.Word
#define ATD1CTL45_CA                    _ATD1CTL45.Bits.CA
#define ATD1CTL45_CB                    _ATD1CTL45.Bits.CB
#define ATD1CTL45_CC                    _ATD1CTL45.Bits.CC
#define ATD1CTL45_CD                    _ATD1CTL45.Bits.CD
#define ATD1CTL45_MULT                  _ATD1CTL45.Bits.MULT
#define ATD1CTL45_SCAN                  _ATD1CTL45.Bits.SCAN
#define ATD1CTL45_DSGN                  _ATD1CTL45.Bits.DSGN
#define ATD1CTL45_DJM                   _ATD1CTL45.Bits.DJM
#define ATD1CTL45_PRS0                  _ATD1CTL45.Bits.PRS0
#define ATD1CTL45_PRS1                  _ATD1CTL45.Bits.PRS1
#define ATD1CTL45_PRS2                  _ATD1CTL45.Bits.PRS2
#define ATD1CTL45_PRS3                  _ATD1CTL45.Bits.PRS3
#define ATD1CTL45_PRS4                  _ATD1CTL45.Bits.PRS4
#define ATD1CTL45_SMP0                  _ATD1CTL45.Bits.SMP0
#define ATD1CTL45_SMP1                  _ATD1CTL45.Bits.SMP1
#define ATD1CTL45_SRES8                 _ATD1CTL45.Bits.SRES8
#define ATD1CTL45_Cx                    _ATD1CTL45.MergedBits.grpCx
#define ATD1CTL45_PRS                   _ATD1CTL45.MergedBits.grpPRS
#define ATD1CTL45_SMP                   _ATD1CTL45.MergedBits.grpSMP

#define ATD1CTL45_CA_MASK               1U
#define ATD1CTL45_CB_MASK               2U
#define ATD1CTL45_CC_MASK               4U
#define ATD1CTL45_CD_MASK               8U
#define ATD1CTL45_MULT_MASK             16U
#define ATD1CTL45_SCAN_MASK             32U
#define ATD1CTL45_DSGN_MASK             64U
#define ATD1CTL45_DJM_MASK              128U
#define ATD1CTL45_PRS0_MASK             256U
#define ATD1CTL45_PRS1_MASK             512U
#define ATD1CTL45_PRS2_MASK             1024U
#define ATD1CTL45_PRS3_MASK             2048U
#define ATD1CTL45_PRS4_MASK             4096U
#define ATD1CTL45_SMP0_MASK             8192U
#define ATD1CTL45_SMP1_MASK             16384U
#define ATD1CTL45_SRES8_MASK            32768U
#define ATD1CTL45_Cx_MASK               15U
#define ATD1CTL45_Cx_BITNUM             0U
#define ATD1CTL45_PRS_MASK              7936U
#define ATD1CTL45_PRS_BITNUM            8U
#define ATD1CTL45_SMP_MASK              24576U
#define ATD1CTL45_SMP_BITNUM            13U


/*** ATD1STAT0 - ATD 1 Status Register 0; 0x00000086 ***/
typedef union {
  byte Byte;
  struct {
    byte CC0         :1;                                       /* Conversion Counter 0 */
    byte CC1         :1;                                       /* Conversion Counter 1 */
    byte CC2         :1;                                       /* Conversion Counter 2 */
    byte CC3         :1;                                       /* Conversion Counter 3 */
    byte FIFOR       :1;                                       /* FIFO Over Run Flag */
    byte ETORF       :1;                                       /* External Trigger Overrun Flag */
    byte             :1; 
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
  struct {
    byte grpCC   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ATD1STAT0STR;
extern volatile ATD1STAT0STR _ATD1STAT0 @(REG_BASE + 0x00000086UL);
#define ATD1STAT0                       _ATD1STAT0.Byte
#define ATD1STAT0_CC0                   _ATD1STAT0.Bits.CC0
#define ATD1STAT0_CC1                   _ATD1STAT0.Bits.CC1
#define ATD1STAT0_CC2                   _ATD1STAT0.Bits.CC2
#define ATD1STAT0_CC3                   _ATD1STAT0.Bits.CC3
#define ATD1STAT0_FIFOR                 _ATD1STAT0.Bits.FIFOR
#define ATD1STAT0_ETORF                 _ATD1STAT0.Bits.ETORF
#define ATD1STAT0_SCF                   _ATD1STAT0.Bits.SCF
#define ATD1STAT0_CC                    _ATD1STAT0.MergedBits.grpCC

#define ATD1STAT0_CC0_MASK              1U
#define ATD1STAT0_CC1_MASK              2U
#define ATD1STAT0_CC2_MASK              4U
#define ATD1STAT0_CC3_MASK              8U
#define ATD1STAT0_FIFOR_MASK            16U
#define ATD1STAT0_ETORF_MASK            32U
#define ATD1STAT0_SCF_MASK              128U
#define ATD1STAT0_CC_MASK               15U
#define ATD1STAT0_CC_BITNUM             0U


/*** ATD1TEST1 - ATD Test Register 1; 0x00000089 ***/
typedef union {
  byte Byte;
  struct {
    byte SC          :1;                                       /* Special Channel Conversion Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ATD1TEST1STR;
extern volatile ATD1TEST1STR _ATD1TEST1 @(REG_BASE + 0x00000089UL);
#define ATD1TEST1                       _ATD1TEST1.Byte
#define ATD1TEST1_SC                    _ATD1TEST1.Bits.SC

#define ATD1TEST1_SC_MASK               1U


/*** ATD1STAT2 - ATD 1 Status Register 2; 0x0000008A ***/
typedef union {
  byte Byte;
  struct {
    byte CCF8        :1;                                       /* Conversion Complete Flag 8 */
    byte CCF9        :1;                                       /* Conversion Complete Flag 9 */
    byte CCF10       :1;                                       /* Conversion Complete Flag 10 */
    byte CCF11       :1;                                       /* Conversion Complete Flag 11 */
    byte CCF12       :1;                                       /* Conversion Complete Flag 12 */
    byte CCF13       :1;                                       /* Conversion Complete Flag 13 */
    byte CCF14       :1;                                       /* Conversion Complete Flag 14 */
    byte CCF15       :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
} ATD1STAT2STR;
extern volatile ATD1STAT2STR _ATD1STAT2 @(REG_BASE + 0x0000008AUL);
#define ATD1STAT2                       _ATD1STAT2.Byte
#define ATD1STAT2_CCF8                  _ATD1STAT2.Bits.CCF8
#define ATD1STAT2_CCF9                  _ATD1STAT2.Bits.CCF9
#define ATD1STAT2_CCF10                 _ATD1STAT2.Bits.CCF10
#define ATD1STAT2_CCF11                 _ATD1STAT2.Bits.CCF11
#define ATD1STAT2_CCF12                 _ATD1STAT2.Bits.CCF12
#define ATD1STAT2_CCF13                 _ATD1STAT2.Bits.CCF13
#define ATD1STAT2_CCF14                 _ATD1STAT2.Bits.CCF14
#define ATD1STAT2_CCF15                 _ATD1STAT2.Bits.CCF15

#define ATD1STAT2_CCF8_MASK             1U
#define ATD1STAT2_CCF9_MASK             2U
#define ATD1STAT2_CCF10_MASK            4U
#define ATD1STAT2_CCF11_MASK            8U
#define ATD1STAT2_CCF12_MASK            16U
#define ATD1STAT2_CCF13_MASK            32U
#define ATD1STAT2_CCF14_MASK            64U
#define ATD1STAT2_CCF15_MASK            128U


/*** ATD1STAT1 - ATD 1 Status Register 1; 0x0000008B ***/
typedef union {
  byte Byte;
  struct {
    byte CCF0        :1;                                       /* Conversion Complete Flag 0 */
    byte CCF1        :1;                                       /* Conversion Complete Flag 1 */
    byte CCF2        :1;                                       /* Conversion Complete Flag 2 */
    byte CCF3        :1;                                       /* Conversion Complete Flag 3 */
    byte CCF4        :1;                                       /* Conversion Complete Flag 4 */
    byte CCF5        :1;                                       /* Conversion Complete Flag 5 */
    byte CCF6        :1;                                       /* Conversion Complete Flag 6 */
    byte CCF7        :1;                                       /* Conversion Complete Flag 7 */
  } Bits;
} ATD1STAT1STR;
extern volatile ATD1STAT1STR _ATD1STAT1 @(REG_BASE + 0x0000008BUL);
#define ATD1STAT1                       _ATD1STAT1.Byte
#define ATD1STAT1_CCF0                  _ATD1STAT1.Bits.CCF0
#define ATD1STAT1_CCF1                  _ATD1STAT1.Bits.CCF1
#define ATD1STAT1_CCF2                  _ATD1STAT1.Bits.CCF2
#define ATD1STAT1_CCF3                  _ATD1STAT1.Bits.CCF3
#define ATD1STAT1_CCF4                  _ATD1STAT1.Bits.CCF4
#define ATD1STAT1_CCF5                  _ATD1STAT1.Bits.CCF5
#define ATD1STAT1_CCF6                  _ATD1STAT1.Bits.CCF6
#define ATD1STAT1_CCF7                  _ATD1STAT1.Bits.CCF7

#define ATD1STAT1_CCF0_MASK             1U
#define ATD1STAT1_CCF1_MASK             2U
#define ATD1STAT1_CCF2_MASK             4U
#define ATD1STAT1_CCF3_MASK             8U
#define ATD1STAT1_CCF4_MASK             16U
#define ATD1STAT1_CCF5_MASK             32U
#define ATD1STAT1_CCF6_MASK             64U
#define ATD1STAT1_CCF7_MASK             128U


/*** ATD1DIEN - ATD 1 Input Enable Register; 0x0000008C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DIEN0 - ATD 1 Input Enable Register 0; 0x0000008C ***/
    union {
      byte Byte;
      struct {
        byte IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
        byte IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
        byte IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
        byte IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
        byte IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
        byte IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
        byte IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
        byte IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
      } Bits;
    } ATD1DIEN0STR;
    #define ATD1DIEN0                   _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Byte
    #define ATD1DIEN0_IEN8              _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN8
    #define ATD1DIEN0_IEN9              _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN9
    #define ATD1DIEN0_IEN10             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN10
    #define ATD1DIEN0_IEN11             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN11
    #define ATD1DIEN0_IEN12             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN12
    #define ATD1DIEN0_IEN13             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN13
    #define ATD1DIEN0_IEN14             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN14
    #define ATD1DIEN0_IEN15             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN15
    /* ATD1DIEN_ARR: Access 2 ATD1DIENx registers in an array */
    #define ATD1DIEN_ARR                ((volatile byte *) &ATD1DIEN0)
    
    #define ATD1DIEN0_IEN8_MASK         1U
    #define ATD1DIEN0_IEN9_MASK         2U
    #define ATD1DIEN0_IEN10_MASK        4U
    #define ATD1DIEN0_IEN11_MASK        8U
    #define ATD1DIEN0_IEN12_MASK        16U
    #define ATD1DIEN0_IEN13_MASK        32U
    #define ATD1DIEN0_IEN14_MASK        64U
    #define ATD1DIEN0_IEN15_MASK        128U
    

    /*** ATD1DIEN1 - ATD 1 Input Enable Register 1; 0x0000008D ***/
    union {
      byte Byte;
      struct {
        byte IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
        byte IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
        byte IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
        byte IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
        byte IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
        byte IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
        byte IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
        byte IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
      } Bits;
    } ATD1DIEN1STR;
    #define ATD1DIEN1                   _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Byte
    #define ATD1DIEN1_IEN0              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN0
    #define ATD1DIEN1_IEN1              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN1
    #define ATD1DIEN1_IEN2              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN2
    #define ATD1DIEN1_IEN3              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN3
    #define ATD1DIEN1_IEN4              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN4
    #define ATD1DIEN1_IEN5              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN5
    #define ATD1DIEN1_IEN6              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN6
    #define ATD1DIEN1_IEN7              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN7
    
    #define ATD1DIEN1_IEN0_MASK         1U
    #define ATD1DIEN1_IEN1_MASK         2U
    #define ATD1DIEN1_IEN2_MASK         4U
    #define ATD1DIEN1_IEN3_MASK         8U
    #define ATD1DIEN1_IEN4_MASK         16U
    #define ATD1DIEN1_IEN5_MASK         32U
    #define ATD1DIEN1_IEN6_MASK         64U
    #define ATD1DIEN1_IEN7_MASK         128U
    
  } Overlap_STR;

  struct {
    word IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
    word IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
    word IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
    word IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
    word IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
    word IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
    word IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
    word IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
    word IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
    word IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
    word IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
    word IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
    word IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
    word IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
    word IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
    word IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
  } Bits;
} ATD1DIENSTR;
extern volatile ATD1DIENSTR _ATD1DIEN @(REG_BASE + 0x0000008CUL);
#define ATD1DIEN                        _ATD1DIEN.Word
#define ATD1DIEN_IEN0                   _ATD1DIEN.Bits.IEN0
#define ATD1DIEN_IEN1                   _ATD1DIEN.Bits.IEN1
#define ATD1DIEN_IEN2                   _ATD1DIEN.Bits.IEN2
#define ATD1DIEN_IEN3                   _ATD1DIEN.Bits.IEN3
#define ATD1DIEN_IEN4                   _ATD1DIEN.Bits.IEN4
#define ATD1DIEN_IEN5                   _ATD1DIEN.Bits.IEN5
#define ATD1DIEN_IEN6                   _ATD1DIEN.Bits.IEN6
#define ATD1DIEN_IEN7                   _ATD1DIEN.Bits.IEN7
#define ATD1DIEN_IEN8                   _ATD1DIEN.Bits.IEN8
#define ATD1DIEN_IEN9                   _ATD1DIEN.Bits.IEN9
#define ATD1DIEN_IEN10                  _ATD1DIEN.Bits.IEN10
#define ATD1DIEN_IEN11                  _ATD1DIEN.Bits.IEN11
#define ATD1DIEN_IEN12                  _ATD1DIEN.Bits.IEN12
#define ATD1DIEN_IEN13                  _ATD1DIEN.Bits.IEN13
#define ATD1DIEN_IEN14                  _ATD1DIEN.Bits.IEN14
#define ATD1DIEN_IEN15                  _ATD1DIEN.Bits.IEN15

#define ATD1DIEN_IEN0_MASK              1U
#define ATD1DIEN_IEN1_MASK              2U
#define ATD1DIEN_IEN2_MASK              4U
#define ATD1DIEN_IEN3_MASK              8U
#define ATD1DIEN_IEN4_MASK              16U
#define ATD1DIEN_IEN5_MASK              32U
#define ATD1DIEN_IEN6_MASK              64U
#define ATD1DIEN_IEN7_MASK              128U
#define ATD1DIEN_IEN8_MASK              256U
#define ATD1DIEN_IEN9_MASK              512U
#define ATD1DIEN_IEN10_MASK             1024U
#define ATD1DIEN_IEN11_MASK             2048U
#define ATD1DIEN_IEN12_MASK             4096U
#define ATD1DIEN_IEN13_MASK             8192U
#define ATD1DIEN_IEN14_MASK             16384U
#define ATD1DIEN_IEN15_MASK             32768U


/*** ATD1PTAD - ATD1 Port AD Register; 0x0000008E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1PTAD0 - ATD1 Port AD0 Register; 0x0000008E ***/
    union {
      byte Byte;
      struct {
        byte PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
        byte PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
        byte PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
        byte PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
        byte PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
        byte PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
        byte PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
        byte PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
      } Bits;
    } ATD1PTAD0STR;
    #define ATD1PTAD0                   _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Byte
    #define ATD1PTAD0_PTAD8             _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD8
    #define ATD1PTAD0_PTAD9             _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD9
    #define ATD1PTAD0_PTAD10            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD10
    #define ATD1PTAD0_PTAD11            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD11
    #define ATD1PTAD0_PTAD12            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD12
    #define ATD1PTAD0_PTAD13            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD13
    #define ATD1PTAD0_PTAD14            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD14
    #define ATD1PTAD0_PTAD15            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD15
    /* ATD1PTAD_ARR: Access 2 ATD1PTADx registers in an array */
    #define ATD1PTAD_ARR                ((volatile byte *) &ATD1PTAD0)
    
    #define ATD1PTAD0_PTAD8_MASK        1U
    #define ATD1PTAD0_PTAD9_MASK        2U
    #define ATD1PTAD0_PTAD10_MASK       4U
    #define ATD1PTAD0_PTAD11_MASK       8U
    #define ATD1PTAD0_PTAD12_MASK       16U
    #define ATD1PTAD0_PTAD13_MASK       32U
    #define ATD1PTAD0_PTAD14_MASK       64U
    #define ATD1PTAD0_PTAD15_MASK       128U
    

    /*** ATD1PTAD1 - ATD1 Port AD1 Register; 0x0000008F ***/
    union {
      byte Byte;
      struct {
        byte PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
        byte PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
        byte PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
        byte PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
        byte PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
        byte PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
        byte PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
        byte PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
      } Bits;
    } ATD1PTAD1STR;
    #define ATD1PTAD1                   _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Byte
    #define ATD1PTAD1_PTAD0             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD0
    #define ATD1PTAD1_PTAD1             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD1
    #define ATD1PTAD1_PTAD2             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD2
    #define ATD1PTAD1_PTAD3             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD3
    #define ATD1PTAD1_PTAD4             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD4
    #define ATD1PTAD1_PTAD5             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD5
    #define ATD1PTAD1_PTAD6             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD6
    #define ATD1PTAD1_PTAD7             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD7
    
    #define ATD1PTAD1_PTAD0_MASK        1U
    #define ATD1PTAD1_PTAD1_MASK        2U
    #define ATD1PTAD1_PTAD2_MASK        4U
    #define ATD1PTAD1_PTAD3_MASK        8U
    #define ATD1PTAD1_PTAD4_MASK        16U
    #define ATD1PTAD1_PTAD5_MASK        32U
    #define ATD1PTAD1_PTAD6_MASK        64U
    #define ATD1PTAD1_PTAD7_MASK        128U
    
  } Overlap_STR;

  struct {
    word PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
    word PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
    word PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
    word PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
    word PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
    word PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
    word PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
    word PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
    word PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
    word PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
    word PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
    word PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
    word PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
    word PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
    word PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
    word PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
  } Bits;
} ATD1PTADSTR;
extern volatile ATD1PTADSTR _ATD1PTAD @(REG_BASE + 0x0000008EUL);
#define ATD1PTAD                        _ATD1PTAD.Word
#define ATD1PTAD_PTAD0                  _ATD1PTAD.Bits.PTAD0
#define ATD1PTAD_PTAD1                  _ATD1PTAD.Bits.PTAD1
#define ATD1PTAD_PTAD2                  _ATD1PTAD.Bits.PTAD2
#define ATD1PTAD_PTAD3                  _ATD1PTAD.Bits.PTAD3
#define ATD1PTAD_PTAD4                  _ATD1PTAD.Bits.PTAD4
#define ATD1PTAD_PTAD5                  _ATD1PTAD.Bits.PTAD5
#define ATD1PTAD_PTAD6                  _ATD1PTAD.Bits.PTAD6
#define ATD1PTAD_PTAD7                  _ATD1PTAD.Bits.PTAD7
#define ATD1PTAD_PTAD8                  _ATD1PTAD.Bits.PTAD8
#define ATD1PTAD_PTAD9                  _ATD1PTAD.Bits.PTAD9
#define ATD1PTAD_PTAD10                 _ATD1PTAD.Bits.PTAD10
#define ATD1PTAD_PTAD11                 _ATD1PTAD.Bits.PTAD11
#define ATD1PTAD_PTAD12                 _ATD1PTAD.Bits.PTAD12
#define ATD1PTAD_PTAD13                 _ATD1PTAD.Bits.PTAD13
#define ATD1PTAD_PTAD14                 _ATD1PTAD.Bits.PTAD14
#define ATD1PTAD_PTAD15                 _ATD1PTAD.Bits.PTAD15

#define ATD1PTAD_PTAD0_MASK             1U
#define ATD1PTAD_PTAD1_MASK             2U
#define ATD1PTAD_PTAD2_MASK             4U
#define ATD1PTAD_PTAD3_MASK             8U
#define ATD1PTAD_PTAD4_MASK             16U
#define ATD1PTAD_PTAD5_MASK             32U
#define ATD1PTAD_PTAD6_MASK             64U
#define ATD1PTAD_PTAD7_MASK             128U
#define ATD1PTAD_PTAD8_MASK             256U
#define ATD1PTAD_PTAD9_MASK             512U
#define ATD1PTAD_PTAD10_MASK            1024U
#define ATD1PTAD_PTAD11_MASK            2048U
#define ATD1PTAD_PTAD12_MASK            4096U
#define ATD1PTAD_PTAD13_MASK            8192U
#define ATD1PTAD_PTAD14_MASK            16384U
#define ATD1PTAD_PTAD15_MASK            32768U


/*** ATD1DR0 - ATD 1 Conversion Result Register 0; 0x00000090 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR0H - ATD 1 Conversion Result Register 0 High; 0x00000090 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR0HSTR;
    #define ATD1DR0H                    _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Byte
    #define ATD1DR0H_BIT8               _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT8
    #define ATD1DR0H_BIT9               _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT9
    #define ATD1DR0H_BIT10              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT10
    #define ATD1DR0H_BIT11              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT11
    #define ATD1DR0H_BIT12              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT12
    #define ATD1DR0H_BIT13              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT13
    #define ATD1DR0H_BIT14              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT14
    #define ATD1DR0H_BIT15              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT15
    
    #define ATD1DR0H_BIT8_MASK          1U
    #define ATD1DR0H_BIT9_MASK          2U
    #define ATD1DR0H_BIT10_MASK         4U
    #define ATD1DR0H_BIT11_MASK         8U
    #define ATD1DR0H_BIT12_MASK         16U
    #define ATD1DR0H_BIT13_MASK         32U
    #define ATD1DR0H_BIT14_MASK         64U
    #define ATD1DR0H_BIT15_MASK         128U
    

    /*** ATD1DR0L - ATD 1 Conversion Result Register 0 Low; 0x00000091 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR0LSTR;
    #define ATD1DR0L                    _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Byte
    #define ATD1DR0L_BIT6               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT6
    #define ATD1DR0L_BIT7               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT7
    #define ATD1DR0L_BIT_6              _ATD1DR0.Overlap_STR.ATD1DR0LSTR.MergedBits.grpBIT_6
    #define ATD1DR0L_BIT                ATD1DR0L_BIT_6
    
    #define ATD1DR0L_BIT6_MASK          64U
    #define ATD1DR0L_BIT7_MASK          128U
    #define ATD1DR0L_BIT_6_MASK         192U
    #define ATD1DR0L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR0STR;
extern volatile ATD1DR0STR _ATD1DR0 @(REG_BASE + 0x00000090UL);
#define ATD1DR0                         _ATD1DR0.Word
#define ATD1DR0_BIT6                    _ATD1DR0.Bits.BIT6
#define ATD1DR0_BIT7                    _ATD1DR0.Bits.BIT7
#define ATD1DR0_BIT8                    _ATD1DR0.Bits.BIT8
#define ATD1DR0_BIT9                    _ATD1DR0.Bits.BIT9
#define ATD1DR0_BIT10                   _ATD1DR0.Bits.BIT10
#define ATD1DR0_BIT11                   _ATD1DR0.Bits.BIT11
#define ATD1DR0_BIT12                   _ATD1DR0.Bits.BIT12
#define ATD1DR0_BIT13                   _ATD1DR0.Bits.BIT13
#define ATD1DR0_BIT14                   _ATD1DR0.Bits.BIT14
#define ATD1DR0_BIT15                   _ATD1DR0.Bits.BIT15
/* ATD1DR_ARR: Access 16 ATD1DRx registers in an array */
#define ATD1DR_ARR                      ((volatile word *) &ATD1DR0)
#define ATD1DR0_BIT_6                   _ATD1DR0.MergedBits.grpBIT_6
#define ATD1DR0_BIT                     ATD1DR0_BIT_6

#define ATD1DR0_BIT6_MASK               64U
#define ATD1DR0_BIT7_MASK               128U
#define ATD1DR0_BIT8_MASK               256U
#define ATD1DR0_BIT9_MASK               512U
#define ATD1DR0_BIT10_MASK              1024U
#define ATD1DR0_BIT11_MASK              2048U
#define ATD1DR0_BIT12_MASK              4096U
#define ATD1DR0_BIT13_MASK              8192U
#define ATD1DR0_BIT14_MASK              16384U
#define ATD1DR0_BIT15_MASK              32768U
#define ATD1DR0_BIT_6_MASK              65472U
#define ATD1DR0_BIT_6_BITNUM            6U


/*** ATD1DR1 - ATD 1 Conversion Result Register 1; 0x00000092 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR1H - ATD 1 Conversion Result Register 1 High; 0x00000092 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR1HSTR;
    #define ATD1DR1H                    _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Byte
    #define ATD1DR1H_BIT8               _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT8
    #define ATD1DR1H_BIT9               _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT9
    #define ATD1DR1H_BIT10              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT10
    #define ATD1DR1H_BIT11              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT11
    #define ATD1DR1H_BIT12              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT12
    #define ATD1DR1H_BIT13              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT13
    #define ATD1DR1H_BIT14              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT14
    #define ATD1DR1H_BIT15              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT15
    
    #define ATD1DR1H_BIT8_MASK          1U
    #define ATD1DR1H_BIT9_MASK          2U
    #define ATD1DR1H_BIT10_MASK         4U
    #define ATD1DR1H_BIT11_MASK         8U
    #define ATD1DR1H_BIT12_MASK         16U
    #define ATD1DR1H_BIT13_MASK         32U
    #define ATD1DR1H_BIT14_MASK         64U
    #define ATD1DR1H_BIT15_MASK         128U
    

    /*** ATD1DR1L - ATD 1 Conversion Result Register 1 Low; 0x00000093 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR1LSTR;
    #define ATD1DR1L                    _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Byte
    #define ATD1DR1L_BIT6               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT6
    #define ATD1DR1L_BIT7               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT7
    #define ATD1DR1L_BIT_6              _ATD1DR1.Overlap_STR.ATD1DR1LSTR.MergedBits.grpBIT_6
    #define ATD1DR1L_BIT                ATD1DR1L_BIT_6
    
    #define ATD1DR1L_BIT6_MASK          64U
    #define ATD1DR1L_BIT7_MASK          128U
    #define ATD1DR1L_BIT_6_MASK         192U
    #define ATD1DR1L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR1STR;
extern volatile ATD1DR1STR _ATD1DR1 @(REG_BASE + 0x00000092UL);
#define ATD1DR1                         _ATD1DR1.Word
#define ATD1DR1_BIT6                    _ATD1DR1.Bits.BIT6
#define ATD1DR1_BIT7                    _ATD1DR1.Bits.BIT7
#define ATD1DR1_BIT8                    _ATD1DR1.Bits.BIT8
#define ATD1DR1_BIT9                    _ATD1DR1.Bits.BIT9
#define ATD1DR1_BIT10                   _ATD1DR1.Bits.BIT10
#define ATD1DR1_BIT11                   _ATD1DR1.Bits.BIT11
#define ATD1DR1_BIT12                   _ATD1DR1.Bits.BIT12
#define ATD1DR1_BIT13                   _ATD1DR1.Bits.BIT13
#define ATD1DR1_BIT14                   _ATD1DR1.Bits.BIT14
#define ATD1DR1_BIT15                   _ATD1DR1.Bits.BIT15
#define ATD1DR1_BIT_6                   _ATD1DR1.MergedBits.grpBIT_6
#define ATD1DR1_BIT                     ATD1DR1_BIT_6

#define ATD1DR1_BIT6_MASK               64U
#define ATD1DR1_BIT7_MASK               128U
#define ATD1DR1_BIT8_MASK               256U
#define ATD1DR1_BIT9_MASK               512U
#define ATD1DR1_BIT10_MASK              1024U
#define ATD1DR1_BIT11_MASK              2048U
#define ATD1DR1_BIT12_MASK              4096U
#define ATD1DR1_BIT13_MASK              8192U
#define ATD1DR1_BIT14_MASK              16384U
#define ATD1DR1_BIT15_MASK              32768U
#define ATD1DR1_BIT_6_MASK              65472U
#define ATD1DR1_BIT_6_BITNUM            6U


/*** ATD1DR2 - ATD 1 Conversion Result Register 2; 0x00000094 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR2H - ATD 1 Conversion Result Register 2 High; 0x00000094 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR2HSTR;
    #define ATD1DR2H                    _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Byte
    #define ATD1DR2H_BIT8               _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT8
    #define ATD1DR2H_BIT9               _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT9
    #define ATD1DR2H_BIT10              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT10
    #define ATD1DR2H_BIT11              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT11
    #define ATD1DR2H_BIT12              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT12
    #define ATD1DR2H_BIT13              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT13
    #define ATD1DR2H_BIT14              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT14
    #define ATD1DR2H_BIT15              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT15
    
    #define ATD1DR2H_BIT8_MASK          1U
    #define ATD1DR2H_BIT9_MASK          2U
    #define ATD1DR2H_BIT10_MASK         4U
    #define ATD1DR2H_BIT11_MASK         8U
    #define ATD1DR2H_BIT12_MASK         16U
    #define ATD1DR2H_BIT13_MASK         32U
    #define ATD1DR2H_BIT14_MASK         64U
    #define ATD1DR2H_BIT15_MASK         128U
    

    /*** ATD1DR2L - ATD 1 Conversion Result Register 2 Low; 0x00000095 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR2LSTR;
    #define ATD1DR2L                    _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Byte
    #define ATD1DR2L_BIT6               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT6
    #define ATD1DR2L_BIT7               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT7
    #define ATD1DR2L_BIT_6              _ATD1DR2.Overlap_STR.ATD1DR2LSTR.MergedBits.grpBIT_6
    #define ATD1DR2L_BIT                ATD1DR2L_BIT_6
    
    #define ATD1DR2L_BIT6_MASK          64U
    #define ATD1DR2L_BIT7_MASK          128U
    #define ATD1DR2L_BIT_6_MASK         192U
    #define ATD1DR2L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR2STR;
extern volatile ATD1DR2STR _ATD1DR2 @(REG_BASE + 0x00000094UL);
#define ATD1DR2                         _ATD1DR2.Word
#define ATD1DR2_BIT6                    _ATD1DR2.Bits.BIT6
#define ATD1DR2_BIT7                    _ATD1DR2.Bits.BIT7
#define ATD1DR2_BIT8                    _ATD1DR2.Bits.BIT8
#define ATD1DR2_BIT9                    _ATD1DR2.Bits.BIT9
#define ATD1DR2_BIT10                   _ATD1DR2.Bits.BIT10
#define ATD1DR2_BIT11                   _ATD1DR2.Bits.BIT11
#define ATD1DR2_BIT12                   _ATD1DR2.Bits.BIT12
#define ATD1DR2_BIT13                   _ATD1DR2.Bits.BIT13
#define ATD1DR2_BIT14                   _ATD1DR2.Bits.BIT14
#define ATD1DR2_BIT15                   _ATD1DR2.Bits.BIT15
#define ATD1DR2_BIT_6                   _ATD1DR2.MergedBits.grpBIT_6
#define ATD1DR2_BIT                     ATD1DR2_BIT_6

#define ATD1DR2_BIT6_MASK               64U
#define ATD1DR2_BIT7_MASK               128U
#define ATD1DR2_BIT8_MASK               256U
#define ATD1DR2_BIT9_MASK               512U
#define ATD1DR2_BIT10_MASK              1024U
#define ATD1DR2_BIT11_MASK              2048U
#define ATD1DR2_BIT12_MASK              4096U
#define ATD1DR2_BIT13_MASK              8192U
#define ATD1DR2_BIT14_MASK              16384U
#define ATD1DR2_BIT15_MASK              32768U
#define ATD1DR2_BIT_6_MASK              65472U
#define ATD1DR2_BIT_6_BITNUM            6U


/*** ATD1DR3 - ATD 1 Conversion Result Register 3; 0x00000096 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR3H - ATD 1 Conversion Result Register 3 High; 0x00000096 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR3HSTR;
    #define ATD1DR3H                    _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Byte
    #define ATD1DR3H_BIT8               _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT8
    #define ATD1DR3H_BIT9               _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT9
    #define ATD1DR3H_BIT10              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT10
    #define ATD1DR3H_BIT11              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT11
    #define ATD1DR3H_BIT12              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT12
    #define ATD1DR3H_BIT13              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT13
    #define ATD1DR3H_BIT14              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT14
    #define ATD1DR3H_BIT15              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT15
    
    #define ATD1DR3H_BIT8_MASK          1U
    #define ATD1DR3H_BIT9_MASK          2U
    #define ATD1DR3H_BIT10_MASK         4U
    #define ATD1DR3H_BIT11_MASK         8U
    #define ATD1DR3H_BIT12_MASK         16U
    #define ATD1DR3H_BIT13_MASK         32U
    #define ATD1DR3H_BIT14_MASK         64U
    #define ATD1DR3H_BIT15_MASK         128U
    

    /*** ATD1DR3L - ATD 1 Conversion Result Register 3 Low; 0x00000097 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR3LSTR;
    #define ATD1DR3L                    _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Byte
    #define ATD1DR3L_BIT6               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT6
    #define ATD1DR3L_BIT7               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT7
    #define ATD1DR3L_BIT_6              _ATD1DR3.Overlap_STR.ATD1DR3LSTR.MergedBits.grpBIT_6
    #define ATD1DR3L_BIT                ATD1DR3L_BIT_6
    
    #define ATD1DR3L_BIT6_MASK          64U
    #define ATD1DR3L_BIT7_MASK          128U
    #define ATD1DR3L_BIT_6_MASK         192U
    #define ATD1DR3L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR3STR;
extern volatile ATD1DR3STR _ATD1DR3 @(REG_BASE + 0x00000096UL);
#define ATD1DR3                         _ATD1DR3.Word
#define ATD1DR3_BIT6                    _ATD1DR3.Bits.BIT6
#define ATD1DR3_BIT7                    _ATD1DR3.Bits.BIT7
#define ATD1DR3_BIT8                    _ATD1DR3.Bits.BIT8
#define ATD1DR3_BIT9                    _ATD1DR3.Bits.BIT9
#define ATD1DR3_BIT10                   _ATD1DR3.Bits.BIT10
#define ATD1DR3_BIT11                   _ATD1DR3.Bits.BIT11
#define ATD1DR3_BIT12                   _ATD1DR3.Bits.BIT12
#define ATD1DR3_BIT13                   _ATD1DR3.Bits.BIT13
#define ATD1DR3_BIT14                   _ATD1DR3.Bits.BIT14
#define ATD1DR3_BIT15                   _ATD1DR3.Bits.BIT15
#define ATD1DR3_BIT_6                   _ATD1DR3.MergedBits.grpBIT_6
#define ATD1DR3_BIT                     ATD1DR3_BIT_6

#define ATD1DR3_BIT6_MASK               64U
#define ATD1DR3_BIT7_MASK               128U
#define ATD1DR3_BIT8_MASK               256U
#define ATD1DR3_BIT9_MASK               512U
#define ATD1DR3_BIT10_MASK              1024U
#define ATD1DR3_BIT11_MASK              2048U
#define ATD1DR3_BIT12_MASK              4096U
#define ATD1DR3_BIT13_MASK              8192U
#define ATD1DR3_BIT14_MASK              16384U
#define ATD1DR3_BIT15_MASK              32768U
#define ATD1DR3_BIT_6_MASK              65472U
#define ATD1DR3_BIT_6_BITNUM            6U


/*** ATD1DR4 - ATD 1 Conversion Result Register 4; 0x00000098 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR4H - ATD 1 Conversion Result Register 4 High; 0x00000098 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR4HSTR;
    #define ATD1DR4H                    _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Byte
    #define ATD1DR4H_BIT8               _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT8
    #define ATD1DR4H_BIT9               _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT9
    #define ATD1DR4H_BIT10              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT10
    #define ATD1DR4H_BIT11              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT11
    #define ATD1DR4H_BIT12              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT12
    #define ATD1DR4H_BIT13              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT13
    #define ATD1DR4H_BIT14              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT14
    #define ATD1DR4H_BIT15              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT15
    
    #define ATD1DR4H_BIT8_MASK          1U
    #define ATD1DR4H_BIT9_MASK          2U
    #define ATD1DR4H_BIT10_MASK         4U
    #define ATD1DR4H_BIT11_MASK         8U
    #define ATD1DR4H_BIT12_MASK         16U
    #define ATD1DR4H_BIT13_MASK         32U
    #define ATD1DR4H_BIT14_MASK         64U
    #define ATD1DR4H_BIT15_MASK         128U
    

    /*** ATD1DR4L - ATD 1 Conversion Result Register 4 Low; 0x00000099 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR4LSTR;
    #define ATD1DR4L                    _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Byte
    #define ATD1DR4L_BIT6               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT6
    #define ATD1DR4L_BIT7               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT7
    #define ATD1DR4L_BIT_6              _ATD1DR4.Overlap_STR.ATD1DR4LSTR.MergedBits.grpBIT_6
    #define ATD1DR4L_BIT                ATD1DR4L_BIT_6
    
    #define ATD1DR4L_BIT6_MASK          64U
    #define ATD1DR4L_BIT7_MASK          128U
    #define ATD1DR4L_BIT_6_MASK         192U
    #define ATD1DR4L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR4STR;
extern volatile ATD1DR4STR _ATD1DR4 @(REG_BASE + 0x00000098UL);
#define ATD1DR4                         _ATD1DR4.Word
#define ATD1DR4_BIT6                    _ATD1DR4.Bits.BIT6
#define ATD1DR4_BIT7                    _ATD1DR4.Bits.BIT7
#define ATD1DR4_BIT8                    _ATD1DR4.Bits.BIT8
#define ATD1DR4_BIT9                    _ATD1DR4.Bits.BIT9
#define ATD1DR4_BIT10                   _ATD1DR4.Bits.BIT10
#define ATD1DR4_BIT11                   _ATD1DR4.Bits.BIT11
#define ATD1DR4_BIT12                   _ATD1DR4.Bits.BIT12
#define ATD1DR4_BIT13                   _ATD1DR4.Bits.BIT13
#define ATD1DR4_BIT14                   _ATD1DR4.Bits.BIT14
#define ATD1DR4_BIT15                   _ATD1DR4.Bits.BIT15
#define ATD1DR4_BIT_6                   _ATD1DR4.MergedBits.grpBIT_6
#define ATD1DR4_BIT                     ATD1DR4_BIT_6

#define ATD1DR4_BIT6_MASK               64U
#define ATD1DR4_BIT7_MASK               128U
#define ATD1DR4_BIT8_MASK               256U
#define ATD1DR4_BIT9_MASK               512U
#define ATD1DR4_BIT10_MASK              1024U
#define ATD1DR4_BIT11_MASK              2048U
#define ATD1DR4_BIT12_MASK              4096U
#define ATD1DR4_BIT13_MASK              8192U
#define ATD1DR4_BIT14_MASK              16384U
#define ATD1DR4_BIT15_MASK              32768U
#define ATD1DR4_BIT_6_MASK              65472U
#define ATD1DR4_BIT_6_BITNUM            6U


/*** ATD1DR5 - ATD 1 Conversion Result Register 5; 0x0000009A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR5H - ATD 1 Conversion Result Register 5 High; 0x0000009A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR5HSTR;
    #define ATD1DR5H                    _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Byte
    #define ATD1DR5H_BIT8               _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT8
    #define ATD1DR5H_BIT9               _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT9
    #define ATD1DR5H_BIT10              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT10
    #define ATD1DR5H_BIT11              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT11
    #define ATD1DR5H_BIT12              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT12
    #define ATD1DR5H_BIT13              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT13
    #define ATD1DR5H_BIT14              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT14
    #define ATD1DR5H_BIT15              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT15
    
    #define ATD1DR5H_BIT8_MASK          1U
    #define ATD1DR5H_BIT9_MASK          2U
    #define ATD1DR5H_BIT10_MASK         4U
    #define ATD1DR5H_BIT11_MASK         8U
    #define ATD1DR5H_BIT12_MASK         16U
    #define ATD1DR5H_BIT13_MASK         32U
    #define ATD1DR5H_BIT14_MASK         64U
    #define ATD1DR5H_BIT15_MASK         128U
    

    /*** ATD1DR5L - ATD 1 Conversion Result Register 5 Low; 0x0000009B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR5LSTR;
    #define ATD1DR5L                    _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Byte
    #define ATD1DR5L_BIT6               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT6
    #define ATD1DR5L_BIT7               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT7
    #define ATD1DR5L_BIT_6              _ATD1DR5.Overlap_STR.ATD1DR5LSTR.MergedBits.grpBIT_6
    #define ATD1DR5L_BIT                ATD1DR5L_BIT_6
    
    #define ATD1DR5L_BIT6_MASK          64U
    #define ATD1DR5L_BIT7_MASK          128U
    #define ATD1DR5L_BIT_6_MASK         192U
    #define ATD1DR5L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR5STR;
extern volatile ATD1DR5STR _ATD1DR5 @(REG_BASE + 0x0000009AUL);
#define ATD1DR5                         _ATD1DR5.Word
#define ATD1DR5_BIT6                    _ATD1DR5.Bits.BIT6
#define ATD1DR5_BIT7                    _ATD1DR5.Bits.BIT7
#define ATD1DR5_BIT8                    _ATD1DR5.Bits.BIT8
#define ATD1DR5_BIT9                    _ATD1DR5.Bits.BIT9
#define ATD1DR5_BIT10                   _ATD1DR5.Bits.BIT10
#define ATD1DR5_BIT11                   _ATD1DR5.Bits.BIT11
#define ATD1DR5_BIT12                   _ATD1DR5.Bits.BIT12
#define ATD1DR5_BIT13                   _ATD1DR5.Bits.BIT13
#define ATD1DR5_BIT14                   _ATD1DR5.Bits.BIT14
#define ATD1DR5_BIT15                   _ATD1DR5.Bits.BIT15
#define ATD1DR5_BIT_6                   _ATD1DR5.MergedBits.grpBIT_6
#define ATD1DR5_BIT                     ATD1DR5_BIT_6

#define ATD1DR5_BIT6_MASK               64U
#define ATD1DR5_BIT7_MASK               128U
#define ATD1DR5_BIT8_MASK               256U
#define ATD1DR5_BIT9_MASK               512U
#define ATD1DR5_BIT10_MASK              1024U
#define ATD1DR5_BIT11_MASK              2048U
#define ATD1DR5_BIT12_MASK              4096U
#define ATD1DR5_BIT13_MASK              8192U
#define ATD1DR5_BIT14_MASK              16384U
#define ATD1DR5_BIT15_MASK              32768U
#define ATD1DR5_BIT_6_MASK              65472U
#define ATD1DR5_BIT_6_BITNUM            6U


/*** ATD1DR6 - ATD 1 Conversion Result Register 6; 0x0000009C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR6H - ATD 1 Conversion Result Register 6 High; 0x0000009C ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR6HSTR;
    #define ATD1DR6H                    _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Byte
    #define ATD1DR6H_BIT8               _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT8
    #define ATD1DR6H_BIT9               _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT9
    #define ATD1DR6H_BIT10              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT10
    #define ATD1DR6H_BIT11              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT11
    #define ATD1DR6H_BIT12              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT12
    #define ATD1DR6H_BIT13              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT13
    #define ATD1DR6H_BIT14              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT14
    #define ATD1DR6H_BIT15              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT15
    
    #define ATD1DR6H_BIT8_MASK          1U
    #define ATD1DR6H_BIT9_MASK          2U
    #define ATD1DR6H_BIT10_MASK         4U
    #define ATD1DR6H_BIT11_MASK         8U
    #define ATD1DR6H_BIT12_MASK         16U
    #define ATD1DR6H_BIT13_MASK         32U
    #define ATD1DR6H_BIT14_MASK         64U
    #define ATD1DR6H_BIT15_MASK         128U
    

    /*** ATD1DR6L - ATD 1 Conversion Result Register 6 Low; 0x0000009D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR6LSTR;
    #define ATD1DR6L                    _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Byte
    #define ATD1DR6L_BIT6               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT6
    #define ATD1DR6L_BIT7               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT7
    #define ATD1DR6L_BIT_6              _ATD1DR6.Overlap_STR.ATD1DR6LSTR.MergedBits.grpBIT_6
    #define ATD1DR6L_BIT                ATD1DR6L_BIT_6
    
    #define ATD1DR6L_BIT6_MASK          64U
    #define ATD1DR6L_BIT7_MASK          128U
    #define ATD1DR6L_BIT_6_MASK         192U
    #define ATD1DR6L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR6STR;
extern volatile ATD1DR6STR _ATD1DR6 @(REG_BASE + 0x0000009CUL);
#define ATD1DR6                         _ATD1DR6.Word
#define ATD1DR6_BIT6                    _ATD1DR6.Bits.BIT6
#define ATD1DR6_BIT7                    _ATD1DR6.Bits.BIT7
#define ATD1DR6_BIT8                    _ATD1DR6.Bits.BIT8
#define ATD1DR6_BIT9                    _ATD1DR6.Bits.BIT9
#define ATD1DR6_BIT10                   _ATD1DR6.Bits.BIT10
#define ATD1DR6_BIT11                   _ATD1DR6.Bits.BIT11
#define ATD1DR6_BIT12                   _ATD1DR6.Bits.BIT12
#define ATD1DR6_BIT13                   _ATD1DR6.Bits.BIT13
#define ATD1DR6_BIT14                   _ATD1DR6.Bits.BIT14
#define ATD1DR6_BIT15                   _ATD1DR6.Bits.BIT15
#define ATD1DR6_BIT_6                   _ATD1DR6.MergedBits.grpBIT_6
#define ATD1DR6_BIT                     ATD1DR6_BIT_6

#define ATD1DR6_BIT6_MASK               64U
#define ATD1DR6_BIT7_MASK               128U
#define ATD1DR6_BIT8_MASK               256U
#define ATD1DR6_BIT9_MASK               512U
#define ATD1DR6_BIT10_MASK              1024U
#define ATD1DR6_BIT11_MASK              2048U
#define ATD1DR6_BIT12_MASK              4096U
#define ATD1DR6_BIT13_MASK              8192U
#define ATD1DR6_BIT14_MASK              16384U
#define ATD1DR6_BIT15_MASK              32768U
#define ATD1DR6_BIT_6_MASK              65472U
#define ATD1DR6_BIT_6_BITNUM            6U


/*** ATD1DR7 - ATD 1 Conversion Result Register 7; 0x0000009E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR7H - ATD 1 Conversion Result Register 7 High; 0x0000009E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR7HSTR;
    #define ATD1DR7H                    _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Byte
    #define ATD1DR7H_BIT8               _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT8
    #define ATD1DR7H_BIT9               _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT9
    #define ATD1DR7H_BIT10              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT10
    #define ATD1DR7H_BIT11              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT11
    #define ATD1DR7H_BIT12              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT12
    #define ATD1DR7H_BIT13              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT13
    #define ATD1DR7H_BIT14              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT14
    #define ATD1DR7H_BIT15              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT15
    
    #define ATD1DR7H_BIT8_MASK          1U
    #define ATD1DR7H_BIT9_MASK          2U
    #define ATD1DR7H_BIT10_MASK         4U
    #define ATD1DR7H_BIT11_MASK         8U
    #define ATD1DR7H_BIT12_MASK         16U
    #define ATD1DR7H_BIT13_MASK         32U
    #define ATD1DR7H_BIT14_MASK         64U
    #define ATD1DR7H_BIT15_MASK         128U
    

    /*** ATD1DR7L - ATD 1 Conversion Result Register 7 Low; 0x0000009F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR7LSTR;
    #define ATD1DR7L                    _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Byte
    #define ATD1DR7L_BIT6               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT6
    #define ATD1DR7L_BIT7               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT7
    #define ATD1DR7L_BIT_6              _ATD1DR7.Overlap_STR.ATD1DR7LSTR.MergedBits.grpBIT_6
    #define ATD1DR7L_BIT                ATD1DR7L_BIT_6
    
    #define ATD1DR7L_BIT6_MASK          64U
    #define ATD1DR7L_BIT7_MASK          128U
    #define ATD1DR7L_BIT_6_MASK         192U
    #define ATD1DR7L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR7STR;
extern volatile ATD1DR7STR _ATD1DR7 @(REG_BASE + 0x0000009EUL);
#define ATD1DR7                         _ATD1DR7.Word
#define ATD1DR7_BIT6                    _ATD1DR7.Bits.BIT6
#define ATD1DR7_BIT7                    _ATD1DR7.Bits.BIT7
#define ATD1DR7_BIT8                    _ATD1DR7.Bits.BIT8
#define ATD1DR7_BIT9                    _ATD1DR7.Bits.BIT9
#define ATD1DR7_BIT10                   _ATD1DR7.Bits.BIT10
#define ATD1DR7_BIT11                   _ATD1DR7.Bits.BIT11
#define ATD1DR7_BIT12                   _ATD1DR7.Bits.BIT12
#define ATD1DR7_BIT13                   _ATD1DR7.Bits.BIT13
#define ATD1DR7_BIT14                   _ATD1DR7.Bits.BIT14
#define ATD1DR7_BIT15                   _ATD1DR7.Bits.BIT15
#define ATD1DR7_BIT_6                   _ATD1DR7.MergedBits.grpBIT_6
#define ATD1DR7_BIT                     ATD1DR7_BIT_6

#define ATD1DR7_BIT6_MASK               64U
#define ATD1DR7_BIT7_MASK               128U
#define ATD1DR7_BIT8_MASK               256U
#define ATD1DR7_BIT9_MASK               512U
#define ATD1DR7_BIT10_MASK              1024U
#define ATD1DR7_BIT11_MASK              2048U
#define ATD1DR7_BIT12_MASK              4096U
#define ATD1DR7_BIT13_MASK              8192U
#define ATD1DR7_BIT14_MASK              16384U
#define ATD1DR7_BIT15_MASK              32768U
#define ATD1DR7_BIT_6_MASK              65472U
#define ATD1DR7_BIT_6_BITNUM            6U


/*** ATD1DR8 - ATD 1 Conversion Result Register 8; 0x000000A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR8H - ATD 1 Conversion Result Register 8 High; 0x000000A0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR8HSTR;
    #define ATD1DR8H                    _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Byte
    #define ATD1DR8H_BIT8               _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT8
    #define ATD1DR8H_BIT9               _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT9
    #define ATD1DR8H_BIT10              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT10
    #define ATD1DR8H_BIT11              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT11
    #define ATD1DR8H_BIT12              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT12
    #define ATD1DR8H_BIT13              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT13
    #define ATD1DR8H_BIT14              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT14
    #define ATD1DR8H_BIT15              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT15
    
    #define ATD1DR8H_BIT8_MASK          1U
    #define ATD1DR8H_BIT9_MASK          2U
    #define ATD1DR8H_BIT10_MASK         4U
    #define ATD1DR8H_BIT11_MASK         8U
    #define ATD1DR8H_BIT12_MASK         16U
    #define ATD1DR8H_BIT13_MASK         32U
    #define ATD1DR8H_BIT14_MASK         64U
    #define ATD1DR8H_BIT15_MASK         128U
    

    /*** ATD1DR8L - ATD 1 Conversion Result Register 8 Low; 0x000000A1 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR8LSTR;
    #define ATD1DR8L                    _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Byte
    #define ATD1DR8L_BIT6               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT6
    #define ATD1DR8L_BIT7               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT7
    #define ATD1DR8L_BIT_6              _ATD1DR8.Overlap_STR.ATD1DR8LSTR.MergedBits.grpBIT_6
    #define ATD1DR8L_BIT                ATD1DR8L_BIT_6
    
    #define ATD1DR8L_BIT6_MASK          64U
    #define ATD1DR8L_BIT7_MASK          128U
    #define ATD1DR8L_BIT_6_MASK         192U
    #define ATD1DR8L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR8STR;
extern volatile ATD1DR8STR _ATD1DR8 @(REG_BASE + 0x000000A0UL);
#define ATD1DR8                         _ATD1DR8.Word
#define ATD1DR8_BIT6                    _ATD1DR8.Bits.BIT6
#define ATD1DR8_BIT7                    _ATD1DR8.Bits.BIT7
#define ATD1DR8_BIT8                    _ATD1DR8.Bits.BIT8
#define ATD1DR8_BIT9                    _ATD1DR8.Bits.BIT9
#define ATD1DR8_BIT10                   _ATD1DR8.Bits.BIT10
#define ATD1DR8_BIT11                   _ATD1DR8.Bits.BIT11
#define ATD1DR8_BIT12                   _ATD1DR8.Bits.BIT12
#define ATD1DR8_BIT13                   _ATD1DR8.Bits.BIT13
#define ATD1DR8_BIT14                   _ATD1DR8.Bits.BIT14
#define ATD1DR8_BIT15                   _ATD1DR8.Bits.BIT15
#define ATD1DR8_BIT_6                   _ATD1DR8.MergedBits.grpBIT_6
#define ATD1DR8_BIT                     ATD1DR8_BIT_6

#define ATD1DR8_BIT6_MASK               64U
#define ATD1DR8_BIT7_MASK               128U
#define ATD1DR8_BIT8_MASK               256U
#define ATD1DR8_BIT9_MASK               512U
#define ATD1DR8_BIT10_MASK              1024U
#define ATD1DR8_BIT11_MASK              2048U
#define ATD1DR8_BIT12_MASK              4096U
#define ATD1DR8_BIT13_MASK              8192U
#define ATD1DR8_BIT14_MASK              16384U
#define ATD1DR8_BIT15_MASK              32768U
#define ATD1DR8_BIT_6_MASK              65472U
#define ATD1DR8_BIT_6_BITNUM            6U


/*** ATD1DR9 - ATD 1 Conversion Result Register 9; 0x000000A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR9H - ATD 1 Conversion Result Register 9 High; 0x000000A2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR9HSTR;
    #define ATD1DR9H                    _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Byte
    #define ATD1DR9H_BIT8               _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT8
    #define ATD1DR9H_BIT9               _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT9
    #define ATD1DR9H_BIT10              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT10
    #define ATD1DR9H_BIT11              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT11
    #define ATD1DR9H_BIT12              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT12
    #define ATD1DR9H_BIT13              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT13
    #define ATD1DR9H_BIT14              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT14
    #define ATD1DR9H_BIT15              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT15
    
    #define ATD1DR9H_BIT8_MASK          1U
    #define ATD1DR9H_BIT9_MASK          2U
    #define ATD1DR9H_BIT10_MASK         4U
    #define ATD1DR9H_BIT11_MASK         8U
    #define ATD1DR9H_BIT12_MASK         16U
    #define ATD1DR9H_BIT13_MASK         32U
    #define ATD1DR9H_BIT14_MASK         64U
    #define ATD1DR9H_BIT15_MASK         128U
    

    /*** ATD1DR9L - ATD 1 Conversion Result Register 9 Low; 0x000000A3 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR9LSTR;
    #define ATD1DR9L                    _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Byte
    #define ATD1DR9L_BIT6               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT6
    #define ATD1DR9L_BIT7               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT7
    #define ATD1DR9L_BIT_6              _ATD1DR9.Overlap_STR.ATD1DR9LSTR.MergedBits.grpBIT_6
    #define ATD1DR9L_BIT                ATD1DR9L_BIT_6
    
    #define ATD1DR9L_BIT6_MASK          64U
    #define ATD1DR9L_BIT7_MASK          128U
    #define ATD1DR9L_BIT_6_MASK         192U
    #define ATD1DR9L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR9STR;
extern volatile ATD1DR9STR _ATD1DR9 @(REG_BASE + 0x000000A2UL);
#define ATD1DR9                         _ATD1DR9.Word
#define ATD1DR9_BIT6                    _ATD1DR9.Bits.BIT6
#define ATD1DR9_BIT7                    _ATD1DR9.Bits.BIT7
#define ATD1DR9_BIT8                    _ATD1DR9.Bits.BIT8
#define ATD1DR9_BIT9                    _ATD1DR9.Bits.BIT9
#define ATD1DR9_BIT10                   _ATD1DR9.Bits.BIT10
#define ATD1DR9_BIT11                   _ATD1DR9.Bits.BIT11
#define ATD1DR9_BIT12                   _ATD1DR9.Bits.BIT12
#define ATD1DR9_BIT13                   _ATD1DR9.Bits.BIT13
#define ATD1DR9_BIT14                   _ATD1DR9.Bits.BIT14
#define ATD1DR9_BIT15                   _ATD1DR9.Bits.BIT15
#define ATD1DR9_BIT_6                   _ATD1DR9.MergedBits.grpBIT_6
#define ATD1DR9_BIT                     ATD1DR9_BIT_6

#define ATD1DR9_BIT6_MASK               64U
#define ATD1DR9_BIT7_MASK               128U
#define ATD1DR9_BIT8_MASK               256U
#define ATD1DR9_BIT9_MASK               512U
#define ATD1DR9_BIT10_MASK              1024U
#define ATD1DR9_BIT11_MASK              2048U
#define ATD1DR9_BIT12_MASK              4096U
#define ATD1DR9_BIT13_MASK              8192U
#define ATD1DR9_BIT14_MASK              16384U
#define ATD1DR9_BIT15_MASK              32768U
#define ATD1DR9_BIT_6_MASK              65472U
#define ATD1DR9_BIT_6_BITNUM            6U


/*** ATD1DR10 - ATD 1 Conversion Result Register 10; 0x000000A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR10H - ATD 1 Conversion Result Register 10 High; 0x000000A4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR10HSTR;
    #define ATD1DR10H                   _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Byte
    #define ATD1DR10H_BIT8              _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT8
    #define ATD1DR10H_BIT9              _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT9
    #define ATD1DR10H_BIT10             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT10
    #define ATD1DR10H_BIT11             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT11
    #define ATD1DR10H_BIT12             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT12
    #define ATD1DR10H_BIT13             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT13
    #define ATD1DR10H_BIT14             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT14
    #define ATD1DR10H_BIT15             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT15
    
    #define ATD1DR10H_BIT8_MASK         1U
    #define ATD1DR10H_BIT9_MASK         2U
    #define ATD1DR10H_BIT10_MASK        4U
    #define ATD1DR10H_BIT11_MASK        8U
    #define ATD1DR10H_BIT12_MASK        16U
    #define ATD1DR10H_BIT13_MASK        32U
    #define ATD1DR10H_BIT14_MASK        64U
    #define ATD1DR10H_BIT15_MASK        128U
    

    /*** ATD1DR10L - ATD 1 Conversion Result Register 10 Low; 0x000000A5 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR10LSTR;
    #define ATD1DR10L                   _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Byte
    #define ATD1DR10L_BIT6              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT6
    #define ATD1DR10L_BIT7              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT7
    #define ATD1DR10L_BIT_6             _ATD1DR10.Overlap_STR.ATD1DR10LSTR.MergedBits.grpBIT_6
    #define ATD1DR10L_BIT               ATD1DR10L_BIT_6
    
    #define ATD1DR10L_BIT6_MASK         64U
    #define ATD1DR10L_BIT7_MASK         128U
    #define ATD1DR10L_BIT_6_MASK        192U
    #define ATD1DR10L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR10STR;
extern volatile ATD1DR10STR _ATD1DR10 @(REG_BASE + 0x000000A4UL);
#define ATD1DR10                        _ATD1DR10.Word
#define ATD1DR10_BIT6                   _ATD1DR10.Bits.BIT6
#define ATD1DR10_BIT7                   _ATD1DR10.Bits.BIT7
#define ATD1DR10_BIT8                   _ATD1DR10.Bits.BIT8
#define ATD1DR10_BIT9                   _ATD1DR10.Bits.BIT9
#define ATD1DR10_BIT10                  _ATD1DR10.Bits.BIT10
#define ATD1DR10_BIT11                  _ATD1DR10.Bits.BIT11
#define ATD1DR10_BIT12                  _ATD1DR10.Bits.BIT12
#define ATD1DR10_BIT13                  _ATD1DR10.Bits.BIT13
#define ATD1DR10_BIT14                  _ATD1DR10.Bits.BIT14
#define ATD1DR10_BIT15                  _ATD1DR10.Bits.BIT15
#define ATD1DR10_BIT_6                  _ATD1DR10.MergedBits.grpBIT_6
#define ATD1DR10_BIT                    ATD1DR10_BIT_6

#define ATD1DR10_BIT6_MASK              64U
#define ATD1DR10_BIT7_MASK              128U
#define ATD1DR10_BIT8_MASK              256U
#define ATD1DR10_BIT9_MASK              512U
#define ATD1DR10_BIT10_MASK             1024U
#define ATD1DR10_BIT11_MASK             2048U
#define ATD1DR10_BIT12_MASK             4096U
#define ATD1DR10_BIT13_MASK             8192U
#define ATD1DR10_BIT14_MASK             16384U
#define ATD1DR10_BIT15_MASK             32768U
#define ATD1DR10_BIT_6_MASK             65472U
#define ATD1DR10_BIT_6_BITNUM           6U


/*** ATD1DR11 - ATD 1 Conversion Result Register 11; 0x000000A6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR11H - ATD 1 Conversion Result Register 11 High; 0x000000A6 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR11HSTR;
    #define ATD1DR11H                   _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Byte
    #define ATD1DR11H_BIT8              _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT8
    #define ATD1DR11H_BIT9              _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT9
    #define ATD1DR11H_BIT10             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT10
    #define ATD1DR11H_BIT11             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT11
    #define ATD1DR11H_BIT12             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT12
    #define ATD1DR11H_BIT13             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT13
    #define ATD1DR11H_BIT14             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT14
    #define ATD1DR11H_BIT15             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT15
    
    #define ATD1DR11H_BIT8_MASK         1U
    #define ATD1DR11H_BIT9_MASK         2U
    #define ATD1DR11H_BIT10_MASK        4U
    #define ATD1DR11H_BIT11_MASK        8U
    #define ATD1DR11H_BIT12_MASK        16U
    #define ATD1DR11H_BIT13_MASK        32U
    #define ATD1DR11H_BIT14_MASK        64U
    #define ATD1DR11H_BIT15_MASK        128U
    

    /*** ATD1DR11L - ATD 1 Conversion Result Register 11 Low; 0x000000A7 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR11LSTR;
    #define ATD1DR11L                   _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Byte
    #define ATD1DR11L_BIT6              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT6
    #define ATD1DR11L_BIT7              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT7
    #define ATD1DR11L_BIT_6             _ATD1DR11.Overlap_STR.ATD1DR11LSTR.MergedBits.grpBIT_6
    #define ATD1DR11L_BIT               ATD1DR11L_BIT_6
    
    #define ATD1DR11L_BIT6_MASK         64U
    #define ATD1DR11L_BIT7_MASK         128U
    #define ATD1DR11L_BIT_6_MASK        192U
    #define ATD1DR11L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR11STR;
extern volatile ATD1DR11STR _ATD1DR11 @(REG_BASE + 0x000000A6UL);
#define ATD1DR11                        _ATD1DR11.Word
#define ATD1DR11_BIT6                   _ATD1DR11.Bits.BIT6
#define ATD1DR11_BIT7                   _ATD1DR11.Bits.BIT7
#define ATD1DR11_BIT8                   _ATD1DR11.Bits.BIT8
#define ATD1DR11_BIT9                   _ATD1DR11.Bits.BIT9
#define ATD1DR11_BIT10                  _ATD1DR11.Bits.BIT10
#define ATD1DR11_BIT11                  _ATD1DR11.Bits.BIT11
#define ATD1DR11_BIT12                  _ATD1DR11.Bits.BIT12
#define ATD1DR11_BIT13                  _ATD1DR11.Bits.BIT13
#define ATD1DR11_BIT14                  _ATD1DR11.Bits.BIT14
#define ATD1DR11_BIT15                  _ATD1DR11.Bits.BIT15
#define ATD1DR11_BIT_6                  _ATD1DR11.MergedBits.grpBIT_6
#define ATD1DR11_BIT                    ATD1DR11_BIT_6

#define ATD1DR11_BIT6_MASK              64U
#define ATD1DR11_BIT7_MASK              128U
#define ATD1DR11_BIT8_MASK              256U
#define ATD1DR11_BIT9_MASK              512U
#define ATD1DR11_BIT10_MASK             1024U
#define ATD1DR11_BIT11_MASK             2048U
#define ATD1DR11_BIT12_MASK             4096U
#define ATD1DR11_BIT13_MASK             8192U
#define ATD1DR11_BIT14_MASK             16384U
#define ATD1DR11_BIT15_MASK             32768U
#define ATD1DR11_BIT_6_MASK             65472U
#define ATD1DR11_BIT_6_BITNUM           6U


/*** ATD1DR12 - ATD 1 Conversion Result Register 12; 0x000000A8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR12H - ATD 1 Conversion Result Register 12 High; 0x000000A8 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR12HSTR;
    #define ATD1DR12H                   _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Byte
    #define ATD1DR12H_BIT8              _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT8
    #define ATD1DR12H_BIT9              _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT9
    #define ATD1DR12H_BIT10             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT10
    #define ATD1DR12H_BIT11             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT11
    #define ATD1DR12H_BIT12             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT12
    #define ATD1DR12H_BIT13             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT13
    #define ATD1DR12H_BIT14             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT14
    #define ATD1DR12H_BIT15             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT15
    
    #define ATD1DR12H_BIT8_MASK         1U
    #define ATD1DR12H_BIT9_MASK         2U
    #define ATD1DR12H_BIT10_MASK        4U
    #define ATD1DR12H_BIT11_MASK        8U
    #define ATD1DR12H_BIT12_MASK        16U
    #define ATD1DR12H_BIT13_MASK        32U
    #define ATD1DR12H_BIT14_MASK        64U
    #define ATD1DR12H_BIT15_MASK        128U
    

    /*** ATD1DR12L - ATD 1 Conversion Result Register 12 Low; 0x000000A9 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR12LSTR;
    #define ATD1DR12L                   _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Byte
    #define ATD1DR12L_BIT6              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT6
    #define ATD1DR12L_BIT7              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT7
    #define ATD1DR12L_BIT_6             _ATD1DR12.Overlap_STR.ATD1DR12LSTR.MergedBits.grpBIT_6
    #define ATD1DR12L_BIT               ATD1DR12L_BIT_6
    
    #define ATD1DR12L_BIT6_MASK         64U
    #define ATD1DR12L_BIT7_MASK         128U
    #define ATD1DR12L_BIT_6_MASK        192U
    #define ATD1DR12L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR12STR;
extern volatile ATD1DR12STR _ATD1DR12 @(REG_BASE + 0x000000A8UL);
#define ATD1DR12                        _ATD1DR12.Word
#define ATD1DR12_BIT6                   _ATD1DR12.Bits.BIT6
#define ATD1DR12_BIT7                   _ATD1DR12.Bits.BIT7
#define ATD1DR12_BIT8                   _ATD1DR12.Bits.BIT8
#define ATD1DR12_BIT9                   _ATD1DR12.Bits.BIT9
#define ATD1DR12_BIT10                  _ATD1DR12.Bits.BIT10
#define ATD1DR12_BIT11                  _ATD1DR12.Bits.BIT11
#define ATD1DR12_BIT12                  _ATD1DR12.Bits.BIT12
#define ATD1DR12_BIT13                  _ATD1DR12.Bits.BIT13
#define ATD1DR12_BIT14                  _ATD1DR12.Bits.BIT14
#define ATD1DR12_BIT15                  _ATD1DR12.Bits.BIT15
#define ATD1DR12_BIT_6                  _ATD1DR12.MergedBits.grpBIT_6
#define ATD1DR12_BIT                    ATD1DR12_BIT_6

#define ATD1DR12_BIT6_MASK              64U
#define ATD1DR12_BIT7_MASK              128U
#define ATD1DR12_BIT8_MASK              256U
#define ATD1DR12_BIT9_MASK              512U
#define ATD1DR12_BIT10_MASK             1024U
#define ATD1DR12_BIT11_MASK             2048U
#define ATD1DR12_BIT12_MASK             4096U
#define ATD1DR12_BIT13_MASK             8192U
#define ATD1DR12_BIT14_MASK             16384U
#define ATD1DR12_BIT15_MASK             32768U
#define ATD1DR12_BIT_6_MASK             65472U
#define ATD1DR12_BIT_6_BITNUM           6U


/*** ATD1DR13 - ATD 1 Conversion Result Register 13; 0x000000AA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR13H - ATD 1 Conversion Result Register 13 High; 0x000000AA ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR13HSTR;
    #define ATD1DR13H                   _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Byte
    #define ATD1DR13H_BIT8              _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT8
    #define ATD1DR13H_BIT9              _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT9
    #define ATD1DR13H_BIT10             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT10
    #define ATD1DR13H_BIT11             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT11
    #define ATD1DR13H_BIT12             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT12
    #define ATD1DR13H_BIT13             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT13
    #define ATD1DR13H_BIT14             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT14
    #define ATD1DR13H_BIT15             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT15
    
    #define ATD1DR13H_BIT8_MASK         1U
    #define ATD1DR13H_BIT9_MASK         2U
    #define ATD1DR13H_BIT10_MASK        4U
    #define ATD1DR13H_BIT11_MASK        8U
    #define ATD1DR13H_BIT12_MASK        16U
    #define ATD1DR13H_BIT13_MASK        32U
    #define ATD1DR13H_BIT14_MASK        64U
    #define ATD1DR13H_BIT15_MASK        128U
    

    /*** ATD1DR13L - ATD 1 Conversion Result Register 13 Low; 0x000000AB ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR13LSTR;
    #define ATD1DR13L                   _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Byte
    #define ATD1DR13L_BIT6              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT6
    #define ATD1DR13L_BIT7              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT7
    #define ATD1DR13L_BIT_6             _ATD1DR13.Overlap_STR.ATD1DR13LSTR.MergedBits.grpBIT_6
    #define ATD1DR13L_BIT               ATD1DR13L_BIT_6
    
    #define ATD1DR13L_BIT6_MASK         64U
    #define ATD1DR13L_BIT7_MASK         128U
    #define ATD1DR13L_BIT_6_MASK        192U
    #define ATD1DR13L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR13STR;
extern volatile ATD1DR13STR _ATD1DR13 @(REG_BASE + 0x000000AAUL);
#define ATD1DR13                        _ATD1DR13.Word
#define ATD1DR13_BIT6                   _ATD1DR13.Bits.BIT6
#define ATD1DR13_BIT7                   _ATD1DR13.Bits.BIT7
#define ATD1DR13_BIT8                   _ATD1DR13.Bits.BIT8
#define ATD1DR13_BIT9                   _ATD1DR13.Bits.BIT9
#define ATD1DR13_BIT10                  _ATD1DR13.Bits.BIT10
#define ATD1DR13_BIT11                  _ATD1DR13.Bits.BIT11
#define ATD1DR13_BIT12                  _ATD1DR13.Bits.BIT12
#define ATD1DR13_BIT13                  _ATD1DR13.Bits.BIT13
#define ATD1DR13_BIT14                  _ATD1DR13.Bits.BIT14
#define ATD1DR13_BIT15                  _ATD1DR13.Bits.BIT15
#define ATD1DR13_BIT_6                  _ATD1DR13.MergedBits.grpBIT_6
#define ATD1DR13_BIT                    ATD1DR13_BIT_6

#define ATD1DR13_BIT6_MASK              64U
#define ATD1DR13_BIT7_MASK              128U
#define ATD1DR13_BIT8_MASK              256U
#define ATD1DR13_BIT9_MASK              512U
#define ATD1DR13_BIT10_MASK             1024U
#define ATD1DR13_BIT11_MASK             2048U
#define ATD1DR13_BIT12_MASK             4096U
#define ATD1DR13_BIT13_MASK             8192U
#define ATD1DR13_BIT14_MASK             16384U
#define ATD1DR13_BIT15_MASK             32768U
#define ATD1DR13_BIT_6_MASK             65472U
#define ATD1DR13_BIT_6_BITNUM           6U


/*** ATD1DR14 - ATD 1 Conversion Result Register 14; 0x000000AC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR14H - ATD 1 Conversion Result Register 14 High; 0x000000AC ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR14HSTR;
    #define ATD1DR14H                   _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Byte
    #define ATD1DR14H_BIT8              _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT8
    #define ATD1DR14H_BIT9              _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT9
    #define ATD1DR14H_BIT10             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT10
    #define ATD1DR14H_BIT11             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT11
    #define ATD1DR14H_BIT12             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT12
    #define ATD1DR14H_BIT13             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT13
    #define ATD1DR14H_BIT14             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT14
    #define ATD1DR14H_BIT15             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT15
    
    #define ATD1DR14H_BIT8_MASK         1U
    #define ATD1DR14H_BIT9_MASK         2U
    #define ATD1DR14H_BIT10_MASK        4U
    #define ATD1DR14H_BIT11_MASK        8U
    #define ATD1DR14H_BIT12_MASK        16U
    #define ATD1DR14H_BIT13_MASK        32U
    #define ATD1DR14H_BIT14_MASK        64U
    #define ATD1DR14H_BIT15_MASK        128U
    

    /*** ATD1DR14L - ATD 1 Conversion Result Register 14 Low; 0x000000AD ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR14LSTR;
    #define ATD1DR14L                   _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Byte
    #define ATD1DR14L_BIT6              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT6
    #define ATD1DR14L_BIT7              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT7
    #define ATD1DR14L_BIT_6             _ATD1DR14.Overlap_STR.ATD1DR14LSTR.MergedBits.grpBIT_6
    #define ATD1DR14L_BIT               ATD1DR14L_BIT_6
    
    #define ATD1DR14L_BIT6_MASK         64U
    #define ATD1DR14L_BIT7_MASK         128U
    #define ATD1DR14L_BIT_6_MASK        192U
    #define ATD1DR14L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR14STR;
extern volatile ATD1DR14STR _ATD1DR14 @(REG_BASE + 0x000000ACUL);
#define ATD1DR14                        _ATD1DR14.Word
#define ATD1DR14_BIT6                   _ATD1DR14.Bits.BIT6
#define ATD1DR14_BIT7                   _ATD1DR14.Bits.BIT7
#define ATD1DR14_BIT8                   _ATD1DR14.Bits.BIT8
#define ATD1DR14_BIT9                   _ATD1DR14.Bits.BIT9
#define ATD1DR14_BIT10                  _ATD1DR14.Bits.BIT10
#define ATD1DR14_BIT11                  _ATD1DR14.Bits.BIT11
#define ATD1DR14_BIT12                  _ATD1DR14.Bits.BIT12
#define ATD1DR14_BIT13                  _ATD1DR14.Bits.BIT13
#define ATD1DR14_BIT14                  _ATD1DR14.Bits.BIT14
#define ATD1DR14_BIT15                  _ATD1DR14.Bits.BIT15
#define ATD1DR14_BIT_6                  _ATD1DR14.MergedBits.grpBIT_6
#define ATD1DR14_BIT                    ATD1DR14_BIT_6

#define ATD1DR14_BIT6_MASK              64U
#define ATD1DR14_BIT7_MASK              128U
#define ATD1DR14_BIT8_MASK              256U
#define ATD1DR14_BIT9_MASK              512U
#define ATD1DR14_BIT10_MASK             1024U
#define ATD1DR14_BIT11_MASK             2048U
#define ATD1DR14_BIT12_MASK             4096U
#define ATD1DR14_BIT13_MASK             8192U
#define ATD1DR14_BIT14_MASK             16384U
#define ATD1DR14_BIT15_MASK             32768U
#define ATD1DR14_BIT_6_MASK             65472U
#define ATD1DR14_BIT_6_BITNUM           6U


/*** ATD1DR15 - ATD 1 Conversion Result Register 15; 0x000000AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR15H - ATD 1 Conversion Result Register 15 High; 0x000000AE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR15HSTR;
    #define ATD1DR15H                   _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Byte
    #define ATD1DR15H_BIT8              _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT8
    #define ATD1DR15H_BIT9              _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT9
    #define ATD1DR15H_BIT10             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT10
    #define ATD1DR15H_BIT11             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT11
    #define ATD1DR15H_BIT12             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT12
    #define ATD1DR15H_BIT13             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT13
    #define ATD1DR15H_BIT14             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT14
    #define ATD1DR15H_BIT15             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT15
    
    #define ATD1DR15H_BIT8_MASK         1U
    #define ATD1DR15H_BIT9_MASK         2U
    #define ATD1DR15H_BIT10_MASK        4U
    #define ATD1DR15H_BIT11_MASK        8U
    #define ATD1DR15H_BIT12_MASK        16U
    #define ATD1DR15H_BIT13_MASK        32U
    #define ATD1DR15H_BIT14_MASK        64U
    #define ATD1DR15H_BIT15_MASK        128U
    

    /*** ATD1DR15L - ATD 1 Conversion Result Register 15 Low; 0x000000AF ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR15LSTR;
    #define ATD1DR15L                   _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Byte
    #define ATD1DR15L_BIT6              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT6
    #define ATD1DR15L_BIT7              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT7
    #define ATD1DR15L_BIT_6             _ATD1DR15.Overlap_STR.ATD1DR15LSTR.MergedBits.grpBIT_6
    #define ATD1DR15L_BIT               ATD1DR15L_BIT_6
    
    #define ATD1DR15L_BIT6_MASK         64U
    #define ATD1DR15L_BIT7_MASK         128U
    #define ATD1DR15L_BIT_6_MASK        192U
    #define ATD1DR15L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR15STR;
extern volatile ATD1DR15STR _ATD1DR15 @(REG_BASE + 0x000000AEUL);
#define ATD1DR15                        _ATD1DR15.Word
#define ATD1DR15_BIT6                   _ATD1DR15.Bits.BIT6
#define ATD1DR15_BIT7                   _ATD1DR15.Bits.BIT7
#define ATD1DR15_BIT8                   _ATD1DR15.Bits.BIT8
#define ATD1DR15_BIT9                   _ATD1DR15.Bits.BIT9
#define ATD1DR15_BIT10                  _ATD1DR15.Bits.BIT10
#define ATD1DR15_BIT11                  _ATD1DR15.Bits.BIT11
#define ATD1DR15_BIT12                  _ATD1DR15.Bits.BIT12
#define ATD1DR15_BIT13                  _ATD1DR15.Bits.BIT13
#define ATD1DR15_BIT14                  _ATD1DR15.Bits.BIT14
#define ATD1DR15_BIT15                  _ATD1DR15.Bits.BIT15
#define ATD1DR15_BIT_6                  _ATD1DR15.MergedBits.grpBIT_6
#define ATD1DR15_BIT                    ATD1DR15_BIT_6

#define ATD1DR15_BIT6_MASK              64U
#define ATD1DR15_BIT7_MASK              128U
#define ATD1DR15_BIT8_MASK              256U
#define ATD1DR15_BIT9_MASK              512U
#define ATD1DR15_BIT10_MASK             1024U
#define ATD1DR15_BIT11_MASK             2048U
#define ATD1DR15_BIT12_MASK             4096U
#define ATD1DR15_BIT13_MASK             8192U
#define ATD1DR15_BIT14_MASK             16384U
#define ATD1DR15_BIT15_MASK             32768U
#define ATD1DR15_BIT_6_MASK             65472U
#define ATD1DR15_BIT_6_BITNUM           6U


/*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI0ASR1STR;
        #define SCI0ASR1                _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0ASR1_BKDIF          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BKDIF
        #define SCI0ASR1_BERRIF         _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRIF
        #define SCI0ASR1_BERRV          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRV
        #define SCI0ASR1_RXEDGIF        _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.RXEDGIF
        
        #define SCI0ASR1_BKDIF_MASK     1U
        #define SCI0ASR1_BERRIF_MASK    2U
        #define SCI0ASR1_BERRV_MASK     4U
        #define SCI0ASR1_RXEDGIF_MASK   128U
        
        /*** SCI0BDH - SCI 0 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI0BDHSTR;
        #define SCI0BDH                 _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0BDH_SBR8            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR8
        #define SCI0BDH_SBR9            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR9
        #define SCI0BDH_SBR10           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR10
        #define SCI0BDH_SBR11           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR11
        #define SCI0BDH_SBR12           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR12
        #define SCI0BDH_TNP0            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP0
        #define SCI0BDH_TNP1            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP1
        #define SCI0BDH_IREN            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.IREN
        #define SCI0BDH_SBR_8           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpSBR_8
        #define SCI0BDH_TNP             _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpTNP
        #define SCI0BDH_SBR             SCI0BDH_SBR_8
        
        #define SCI0BDH_SBR8_MASK       1U
        #define SCI0BDH_SBR9_MASK       2U
        #define SCI0BDH_SBR10_MASK      4U
        #define SCI0BDH_SBR11_MASK      8U
        #define SCI0BDH_SBR12_MASK      16U
        #define SCI0BDH_TNP0_MASK       32U
        #define SCI0BDH_TNP1_MASK       64U
        #define SCI0BDH_IREN_MASK       128U
        #define SCI0BDH_SBR_8_MASK      31U
        #define SCI0BDH_SBR_8_BITNUM    0U
        #define SCI0BDH_TNP_MASK        96U
        #define SCI0BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ASR1STR;
    

    /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI0ACR1STR;
        #define SCI0ACR1                _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0ACR1_BKDIE          _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BKDIE
        #define SCI0ACR1_BERRIE         _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BERRIE
        #define SCI0ACR1_RXEDGIE        _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.RXEDGIE
        
        #define SCI0ACR1_BKDIE_MASK     1U
        #define SCI0ACR1_BERRIE_MASK    2U
        #define SCI0ACR1_RXEDGIE_MASK   128U
        
        /*** SCI0BDL - SCI 0 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI0BDLSTR;
        #define SCI0BDL                 _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0BDL_SBR0            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR0
        #define SCI0BDL_SBR1            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR1
        #define SCI0BDL_SBR2            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR2
        #define SCI0BDL_SBR3            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR3
        #define SCI0BDL_SBR4            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR4
        #define SCI0BDL_SBR5            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR5
        #define SCI0BDL_SBR6            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR6
        #define SCI0BDL_SBR7            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR7
        
        #define SCI0BDL_SBR0_MASK       1U
        #define SCI0BDL_SBR1_MASK       2U
        #define SCI0BDL_SBR2_MASK       4U
        #define SCI0BDL_SBR3_MASK       8U
        #define SCI0BDL_SBR4_MASK       16U
        #define SCI0BDL_SBR5_MASK       32U
        #define SCI0BDL_SBR6_MASK       64U
        #define SCI0BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @(REG_BASE + 0x000000C8UL);
#define SCI0BD                          _SCI0BD.Word
#define SCI0BD_SBR0                     _SCI0BD.Bits.SBR0
#define SCI0BD_SBR1                     _SCI0BD.Bits.SBR1
#define SCI0BD_SBR2                     _SCI0BD.Bits.SBR2
#define SCI0BD_SBR3                     _SCI0BD.Bits.SBR3
#define SCI0BD_SBR4                     _SCI0BD.Bits.SBR4
#define SCI0BD_SBR5                     _SCI0BD.Bits.SBR5
#define SCI0BD_SBR6                     _SCI0BD.Bits.SBR6
#define SCI0BD_SBR7                     _SCI0BD.Bits.SBR7
#define SCI0BD_SBR8                     _SCI0BD.Bits.SBR8
#define SCI0BD_SBR9                     _SCI0BD.Bits.SBR9
#define SCI0BD_SBR10                    _SCI0BD.Bits.SBR10
#define SCI0BD_SBR11                    _SCI0BD.Bits.SBR11
#define SCI0BD_SBR12                    _SCI0BD.Bits.SBR12
#define SCI0BD_TNP0                     _SCI0BD.Bits.TNP0
#define SCI0BD_TNP1                     _SCI0BD.Bits.TNP1
#define SCI0BD_IREN                     _SCI0BD.Bits.IREN
#define SCI0BD_SBR                      _SCI0BD.MergedBits.grpSBR
#define SCI0BD_TNP                      _SCI0BD.MergedBits.grpTNP

#define SCI0BD_SBR0_MASK                1U
#define SCI0BD_SBR1_MASK                2U
#define SCI0BD_SBR2_MASK                4U
#define SCI0BD_SBR3_MASK                8U
#define SCI0BD_SBR4_MASK                16U
#define SCI0BD_SBR5_MASK                32U
#define SCI0BD_SBR6_MASK                64U
#define SCI0BD_SBR7_MASK                128U
#define SCI0BD_SBR8_MASK                256U
#define SCI0BD_SBR9_MASK                512U
#define SCI0BD_SBR10_MASK               1024U
#define SCI0BD_SBR11_MASK               2048U
#define SCI0BD_SBR12_MASK               4096U
#define SCI0BD_TNP0_MASK                8192U
#define SCI0BD_TNP1_MASK                16384U
#define SCI0BD_IREN_MASK                32768U
#define SCI0BD_SBR_MASK                 8191U
#define SCI0BD_SBR_BITNUM               0U
#define SCI0BD_TNP_MASK                 24576U
#define SCI0BD_TNP_BITNUM               13U


/*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI0ACR2 - SCI 0 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode Bit 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode Bit 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI0ACR2STR;
    #define SCI0ACR2                    _SCI0ACR2.Byte
    #define SCI0ACR2_BKDFE              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BKDFE
    #define SCI0ACR2_BERRM0             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM0
    #define SCI0ACR2_BERRM1             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM1
    #define SCI0ACR2_BERRM              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.MergedBits.grpBERRM
    
    #define SCI0ACR2_BKDFE_MASK         1U
    #define SCI0ACR2_BERRM0_MASK        2U
    #define SCI0ACR2_BERRM1_MASK        4U
    #define SCI0ACR2_BERRM_MASK         6U
    #define SCI0ACR2_BERRM_BITNUM       1U
    
    /*** SCI0CR1 - SCI 0 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI0CR1STR;
    #define SCI0CR1                     _SCI0ACR2.Byte
    #define SCI0CR1_PT                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PT
    #define SCI0CR1_PE                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PE
    #define SCI0CR1_ILT                 _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.ILT
    #define SCI0CR1_WAKE                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.WAKE
    #define SCI0CR1_M                   _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.M
    #define SCI0CR1_RSRC                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.RSRC
    #define SCI0CR1_SCISWAI             _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.SCISWAI
    #define SCI0CR1_LOOPS               _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.LOOPS
    
    #define SCI0CR1_PT_MASK             1U
    #define SCI0CR1_PE_MASK             2U
    #define SCI0CR1_ILT_MASK            4U
    #define SCI0CR1_WAKE_MASK           8U
    #define SCI0CR1_M_MASK              16U
    #define SCI0CR1_RSRC_MASK           32U
    #define SCI0CR1_SCISWAI_MASK        64U
    #define SCI0CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI0ACR2STR;
extern volatile SCI0ACR2STR _SCI0ACR2 @(REG_BASE + 0x000000CAUL);


/*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI0CR2STR;
extern volatile SCI0CR2STR _SCI0CR2 @(REG_BASE + 0x000000CBUL);
#define SCI0CR2                         _SCI0CR2.Byte
#define SCI0CR2_SBK                     _SCI0CR2.Bits.SBK
#define SCI0CR2_RWU                     _SCI0CR2.Bits.RWU
#define SCI0CR2_RE                      _SCI0CR2.Bits.RE
#define SCI0CR2_TE                      _SCI0CR2.Bits.TE
#define SCI0CR2_ILIE                    _SCI0CR2.Bits.ILIE
#define SCI0CR2_RIE                     _SCI0CR2.Bits.RIE
#define SCI0CR2_TCIE                    _SCI0CR2.Bits.TCIE
#define SCI0CR2_TIE                     _SCI0CR2.Bits.TIE_bit

#define SCI0CR2_SBK_MASK                1U
#define SCI0CR2_RWU_MASK                2U
#define SCI0CR2_RE_MASK                 4U
#define SCI0CR2_TE_MASK                 8U
#define SCI0CR2_ILIE_MASK               16U
#define SCI0CR2_RIE_MASK                32U
#define SCI0CR2_TCIE_MASK               64U
#define SCI0CR2_TIE_MASK                128U


/*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0SR1STR;
extern volatile SCI0SR1STR _SCI0SR1 @(REG_BASE + 0x000000CCUL);
#define SCI0SR1                         _SCI0SR1.Byte
#define SCI0SR1_PF                      _SCI0SR1.Bits.PF
#define SCI0SR1_FE                      _SCI0SR1.Bits.FE
#define SCI0SR1_NF                      _SCI0SR1.Bits.NF
#define SCI0SR1_OR                      _SCI0SR1.Bits.OR
#define SCI0SR1_IDLE                    _SCI0SR1.Bits.IDLE
#define SCI0SR1_RDRF                    _SCI0SR1.Bits.RDRF
#define SCI0SR1_TC                      _SCI0SR1.Bits.TC
#define SCI0SR1_TDRE                    _SCI0SR1.Bits.TDRE

#define SCI0SR1_PF_MASK                 1U
#define SCI0SR1_FE_MASK                 2U
#define SCI0SR1_NF_MASK                 4U
#define SCI0SR1_OR_MASK                 8U
#define SCI0SR1_IDLE_MASK               16U
#define SCI0SR1_RDRF_MASK               32U
#define SCI0SR1_TC_MASK                 64U
#define SCI0SR1_TDRE_MASK               128U


/*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI0SR2STR;
extern volatile SCI0SR2STR _SCI0SR2 @(REG_BASE + 0x000000CDUL);
#define SCI0SR2                         _SCI0SR2.Byte
#define SCI0SR2_RAF                     _SCI0SR2.Bits.RAF
#define SCI0SR2_TXDIR                   _SCI0SR2.Bits.TXDIR
#define SCI0SR2_BRK13                   _SCI0SR2.Bits.BRK13
#define SCI0SR2_RXPOL                   _SCI0SR2.Bits.RXPOL
#define SCI0SR2_TXPOL                   _SCI0SR2.Bits.TXPOL
#define SCI0SR2_AMAP                    _SCI0SR2.Bits.AMAP

#define SCI0SR2_RAF_MASK                1U
#define SCI0SR2_TXDIR_MASK              2U
#define SCI0SR2_BRK13_MASK              4U
#define SCI0SR2_RXPOL_MASK              8U
#define SCI0SR2_TXPOL_MASK              16U
#define SCI0SR2_AMAP_MASK               128U


/*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI0DRHSTR;
extern volatile SCI0DRHSTR _SCI0DRH @(REG_BASE + 0x000000CEUL);
#define SCI0DRH                         _SCI0DRH.Byte
#define SCI0DRH_T8                      _SCI0DRH.Bits.T8
#define SCI0DRH_R8                      _SCI0DRH.Bits.R8

#define SCI0DRH_T8_MASK                 64U
#define SCI0DRH_R8_MASK                 128U


/*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI0DRLSTR;
extern volatile SCI0DRLSTR _SCI0DRL @(REG_BASE + 0x000000CFUL);
#define SCI0DRL                         _SCI0DRL.Byte
#define SCI0DRL_R0_T0                   _SCI0DRL.Bits.R0_T0
#define SCI0DRL_R1_T1                   _SCI0DRL.Bits.R1_T1
#define SCI0DRL_R2_T2                   _SCI0DRL.Bits.R2_T2
#define SCI0DRL_R3_T3                   _SCI0DRL.Bits.R3_T3
#define SCI0DRL_R4_T4                   _SCI0DRL.Bits.R4_T4
#define SCI0DRL_R5_T5                   _SCI0DRL.Bits.R5_T5
#define SCI0DRL_R6_T6                   _SCI0DRL.Bits.R6_T6
#define SCI0DRL_R7_T7                   _SCI0DRL.Bits.R7_T7

#define SCI0DRL_R0_T0_MASK              1U
#define SCI0DRL_R1_T1_MASK              2U
#define SCI0DRL_R2_T2_MASK              4U
#define SCI0DRL_R3_T3_MASK              8U
#define SCI0DRL_R4_T4_MASK              16U
#define SCI0DRL_R5_T5_MASK              32U
#define SCI0DRL_R6_T6_MASK              64U
#define SCI0DRL_R7_T7_MASK              128U


/*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI1ASR1STR;
        #define SCI1ASR1                _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1ASR1_BKDIF          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BKDIF
        #define SCI1ASR1_BERRIF         _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRIF
        #define SCI1ASR1_BERRV          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRV
        #define SCI1ASR1_RXEDGIF        _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.RXEDGIF
        
        #define SCI1ASR1_BKDIF_MASK     1U
        #define SCI1ASR1_BERRIF_MASK    2U
        #define SCI1ASR1_BERRV_MASK     4U
        #define SCI1ASR1_RXEDGIF_MASK   128U
        
        /*** SCI1BDH - SCI 1 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI1BDHSTR;
        #define SCI1BDH                 _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1BDH_SBR8            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR8
        #define SCI1BDH_SBR9            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR9
        #define SCI1BDH_SBR10           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR10
        #define SCI1BDH_SBR11           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR11
        #define SCI1BDH_SBR12           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR12
        #define SCI1BDH_TNP0            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP0
        #define SCI1BDH_TNP1            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP1
        #define SCI1BDH_IREN            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.IREN
        #define SCI1BDH_SBR_8           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpSBR_8
        #define SCI1BDH_TNP             _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpTNP
        #define SCI1BDH_SBR             SCI1BDH_SBR_8
        
        #define SCI1BDH_SBR8_MASK       1U
        #define SCI1BDH_SBR9_MASK       2U
        #define SCI1BDH_SBR10_MASK      4U
        #define SCI1BDH_SBR11_MASK      8U
        #define SCI1BDH_SBR12_MASK      16U
        #define SCI1BDH_TNP0_MASK       32U
        #define SCI1BDH_TNP1_MASK       64U
        #define SCI1BDH_IREN_MASK       128U
        #define SCI1BDH_SBR_8_MASK      31U
        #define SCI1BDH_SBR_8_BITNUM    0U
        #define SCI1BDH_TNP_MASK        96U
        #define SCI1BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ASR1STR;
    

    /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI1ACR1STR;
        #define SCI1ACR1                _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1ACR1_BKDIE          _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BKDIE
        #define SCI1ACR1_BERRIE         _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BERRIE
        #define SCI1ACR1_RXEDGIE        _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.RXEDGIE
        
        #define SCI1ACR1_BKDIE_MASK     1U
        #define SCI1ACR1_BERRIE_MASK    2U
        #define SCI1ACR1_RXEDGIE_MASK   128U
        
        /*** SCI1BDL - SCI 1 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI1BDLSTR;
        #define SCI1BDL                 _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1BDL_SBR0            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR0
        #define SCI1BDL_SBR1            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR1
        #define SCI1BDL_SBR2            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR2
        #define SCI1BDL_SBR3            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR3
        #define SCI1BDL_SBR4            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR4
        #define SCI1BDL_SBR5            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR5
        #define SCI1BDL_SBR6            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR6
        #define SCI1BDL_SBR7            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR7
        
        #define SCI1BDL_SBR0_MASK       1U
        #define SCI1BDL_SBR1_MASK       2U
        #define SCI1BDL_SBR2_MASK       4U
        #define SCI1BDL_SBR3_MASK       8U
        #define SCI1BDL_SBR4_MASK       16U
        #define SCI1BDL_SBR5_MASK       32U
        #define SCI1BDL_SBR6_MASK       64U
        #define SCI1BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI1BDSTR;
extern volatile SCI1BDSTR _SCI1BD @(REG_BASE + 0x000000D0UL);
#define SCI1BD                          _SCI1BD.Word
#define SCI1BD_SBR0                     _SCI1BD.Bits.SBR0
#define SCI1BD_SBR1                     _SCI1BD.Bits.SBR1
#define SCI1BD_SBR2                     _SCI1BD.Bits.SBR2
#define SCI1BD_SBR3                     _SCI1BD.Bits.SBR3
#define SCI1BD_SBR4                     _SCI1BD.Bits.SBR4
#define SCI1BD_SBR5                     _SCI1BD.Bits.SBR5
#define SCI1BD_SBR6                     _SCI1BD.Bits.SBR6
#define SCI1BD_SBR7                     _SCI1BD.Bits.SBR7
#define SCI1BD_SBR8                     _SCI1BD.Bits.SBR8
#define SCI1BD_SBR9                     _SCI1BD.Bits.SBR9
#define SCI1BD_SBR10                    _SCI1BD.Bits.SBR10
#define SCI1BD_SBR11                    _SCI1BD.Bits.SBR11
#define SCI1BD_SBR12                    _SCI1BD.Bits.SBR12
#define SCI1BD_TNP0                     _SCI1BD.Bits.TNP0
#define SCI1BD_TNP1                     _SCI1BD.Bits.TNP1
#define SCI1BD_IREN                     _SCI1BD.Bits.IREN
#define SCI1BD_SBR                      _SCI1BD.MergedBits.grpSBR
#define SCI1BD_TNP                      _SCI1BD.MergedBits.grpTNP

#define SCI1BD_SBR0_MASK                1U
#define SCI1BD_SBR1_MASK                2U
#define SCI1BD_SBR2_MASK                4U
#define SCI1BD_SBR3_MASK                8U
#define SCI1BD_SBR4_MASK                16U
#define SCI1BD_SBR5_MASK                32U
#define SCI1BD_SBR6_MASK                64U
#define SCI1BD_SBR7_MASK                128U
#define SCI1BD_SBR8_MASK                256U
#define SCI1BD_SBR9_MASK                512U
#define SCI1BD_SBR10_MASK               1024U
#define SCI1BD_SBR11_MASK               2048U
#define SCI1BD_SBR12_MASK               4096U
#define SCI1BD_TNP0_MASK                8192U
#define SCI1BD_TNP1_MASK                16384U
#define SCI1BD_IREN_MASK                32768U
#define SCI1BD_SBR_MASK                 8191U
#define SCI1BD_SBR_BITNUM               0U
#define SCI1BD_TNP_MASK                 24576U
#define SCI1BD_TNP_BITNUM               13U


/*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI1ACR2 - SCI 1 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode Bit 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode Bit 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI1ACR2STR;
    #define SCI1ACR2                    _SCI1ACR2.Byte
    #define SCI1ACR2_BKDFE              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BKDFE
    #define SCI1ACR2_BERRM0             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM0
    #define SCI1ACR2_BERRM1             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM1
    #define SCI1ACR2_BERRM              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.MergedBits.grpBERRM
    
    #define SCI1ACR2_BKDFE_MASK         1U
    #define SCI1ACR2_BERRM0_MASK        2U
    #define SCI1ACR2_BERRM1_MASK        4U
    #define SCI1ACR2_BERRM_MASK         6U
    #define SCI1ACR2_BERRM_BITNUM       1U
    
    /*** SCI1CR1 - SCI 1 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI1CR1STR;
    #define SCI1CR1                     _SCI1ACR2.Byte
    #define SCI1CR1_PT                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PT
    #define SCI1CR1_PE                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PE
    #define SCI1CR1_ILT                 _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.ILT
    #define SCI1CR1_WAKE                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.WAKE
    #define SCI1CR1_M                   _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.M
    #define SCI1CR1_RSRC                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.RSRC
    #define SCI1CR1_SCISWAI             _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.SCISWAI
    #define SCI1CR1_LOOPS               _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.LOOPS
    
    #define SCI1CR1_PT_MASK             1U
    #define SCI1CR1_PE_MASK             2U
    #define SCI1CR1_ILT_MASK            4U
    #define SCI1CR1_WAKE_MASK           8U
    #define SCI1CR1_M_MASK              16U
    #define SCI1CR1_RSRC_MASK           32U
    #define SCI1CR1_SCISWAI_MASK        64U
    #define SCI1CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI1ACR2STR;
extern volatile SCI1ACR2STR _SCI1ACR2 @(REG_BASE + 0x000000D2UL);


/*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI1CR2STR;
extern volatile SCI1CR2STR _SCI1CR2 @(REG_BASE + 0x000000D3UL);
#define SCI1CR2                         _SCI1CR2.Byte
#define SCI1CR2_SBK                     _SCI1CR2.Bits.SBK
#define SCI1CR2_RWU                     _SCI1CR2.Bits.RWU
#define SCI1CR2_RE                      _SCI1CR2.Bits.RE
#define SCI1CR2_TE                      _SCI1CR2.Bits.TE
#define SCI1CR2_ILIE                    _SCI1CR2.Bits.ILIE
#define SCI1CR2_RIE                     _SCI1CR2.Bits.RIE
#define SCI1CR2_TCIE                    _SCI1CR2.Bits.TCIE
#define SCI1CR2_TIE                     _SCI1CR2.Bits.TIE_bit

#define SCI1CR2_SBK_MASK                1U
#define SCI1CR2_RWU_MASK                2U
#define SCI1CR2_RE_MASK                 4U
#define SCI1CR2_TE_MASK                 8U
#define SCI1CR2_ILIE_MASK               16U
#define SCI1CR2_RIE_MASK                32U
#define SCI1CR2_TCIE_MASK               64U
#define SCI1CR2_TIE_MASK                128U


/*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI1SR1STR;
extern volatile SCI1SR1STR _SCI1SR1 @(REG_BASE + 0x000000D4UL);
#define SCI1SR1                         _SCI1SR1.Byte
#define SCI1SR1_PF                      _SCI1SR1.Bits.PF
#define SCI1SR1_FE                      _SCI1SR1.Bits.FE
#define SCI1SR1_NF                      _SCI1SR1.Bits.NF
#define SCI1SR1_OR                      _SCI1SR1.Bits.OR
#define SCI1SR1_IDLE                    _SCI1SR1.Bits.IDLE
#define SCI1SR1_RDRF                    _SCI1SR1.Bits.RDRF
#define SCI1SR1_TC                      _SCI1SR1.Bits.TC
#define SCI1SR1_TDRE                    _SCI1SR1.Bits.TDRE

#define SCI1SR1_PF_MASK                 1U
#define SCI1SR1_FE_MASK                 2U
#define SCI1SR1_NF_MASK                 4U
#define SCI1SR1_OR_MASK                 8U
#define SCI1SR1_IDLE_MASK               16U
#define SCI1SR1_RDRF_MASK               32U
#define SCI1SR1_TC_MASK                 64U
#define SCI1SR1_TDRE_MASK               128U


/*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI1SR2STR;
extern volatile SCI1SR2STR _SCI1SR2 @(REG_BASE + 0x000000D5UL);
#define SCI1SR2                         _SCI1SR2.Byte
#define SCI1SR2_RAF                     _SCI1SR2.Bits.RAF
#define SCI1SR2_TXDIR                   _SCI1SR2.Bits.TXDIR
#define SCI1SR2_BRK13                   _SCI1SR2.Bits.BRK13
#define SCI1SR2_RXPOL                   _SCI1SR2.Bits.RXPOL
#define SCI1SR2_TXPOL                   _SCI1SR2.Bits.TXPOL
#define SCI1SR2_AMAP                    _SCI1SR2.Bits.AMAP

#define SCI1SR2_RAF_MASK                1U
#define SCI1SR2_TXDIR_MASK              2U
#define SCI1SR2_BRK13_MASK              4U
#define SCI1SR2_RXPOL_MASK              8U
#define SCI1SR2_TXPOL_MASK              16U
#define SCI1SR2_AMAP_MASK               128U


/*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI1DRHSTR;
extern volatile SCI1DRHSTR _SCI1DRH @(REG_BASE + 0x000000D6UL);
#define SCI1DRH                         _SCI1DRH.Byte
#define SCI1DRH_T8                      _SCI1DRH.Bits.T8
#define SCI1DRH_R8                      _SCI1DRH.Bits.R8

#define SCI1DRH_T8_MASK                 64U
#define SCI1DRH_R8_MASK                 128U


/*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI1DRLSTR;
extern volatile SCI1DRLSTR _SCI1DRL @(REG_BASE + 0x000000D7UL);
#define SCI1DRL                         _SCI1DRL.Byte
#define SCI1DRL_R0_T0                   _SCI1DRL.Bits.R0_T0
#define SCI1DRL_R1_T1                   _SCI1DRL.Bits.R1_T1
#define SCI1DRL_R2_T2                   _SCI1DRL.Bits.R2_T2
#define SCI1DRL_R3_T3                   _SCI1DRL.Bits.R3_T3
#define SCI1DRL_R4_T4                   _SCI1DRL.Bits.R4_T4
#define SCI1DRL_R5_T5                   _SCI1DRL.Bits.R5_T5
#define SCI1DRL_R6_T6                   _SCI1DRL.Bits.R6_T6
#define SCI1DRL_R7_T7                   _SCI1DRL.Bits.R7_T7

#define SCI1DRL_R0_T0_MASK              1U
#define SCI1DRL_R1_T1_MASK              2U
#define SCI1DRL_R2_T2_MASK              4U
#define SCI1DRL_R3_T3_MASK              8U
#define SCI1DRL_R4_T4_MASK              16U
#define SCI1DRL_R5_T5_MASK              32U
#define SCI1DRL_R6_T6_MASK              64U
#define SCI1DRL_R7_T7_MASK              128U


/*** SPI0CR1 - SPI 0 Control Register; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI0CR1STR;
extern volatile SPI0CR1STR _SPI0CR1 @(REG_BASE + 0x000000D8UL);
#define SPI0CR1                         _SPI0CR1.Byte
#define SPI0CR1_LSBFE                   _SPI0CR1.Bits.LSBFE
#define SPI0CR1_SSOE                    _SPI0CR1.Bits.SSOE
#define SPI0CR1_CPHA                    _SPI0CR1.Bits.CPHA
#define SPI0CR1_CPOL                    _SPI0CR1.Bits.CPOL
#define SPI0CR1_MSTR                    _SPI0CR1.Bits.MSTR
#define SPI0CR1_SPTIE                   _SPI0CR1.Bits.SPTIE
#define SPI0CR1_SPE                     _SPI0CR1.Bits.SPE
#define SPI0CR1_SPIE                    _SPI0CR1.Bits.SPIE

#define SPI0CR1_LSBFE_MASK              1U
#define SPI0CR1_SSOE_MASK               2U
#define SPI0CR1_CPHA_MASK               4U
#define SPI0CR1_CPOL_MASK               8U
#define SPI0CR1_MSTR_MASK               16U
#define SPI0CR1_SPTIE_MASK              32U
#define SPI0CR1_SPE_MASK                64U
#define SPI0CR1_SPIE_MASK               128U


/*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI0CR2STR;
extern volatile SPI0CR2STR _SPI0CR2 @(REG_BASE + 0x000000D9UL);
#define SPI0CR2                         _SPI0CR2.Byte
#define SPI0CR2_SPC0                    _SPI0CR2.Bits.SPC0
#define SPI0CR2_SPISWAI                 _SPI0CR2.Bits.SPISWAI
#define SPI0CR2_BIDIROE                 _SPI0CR2.Bits.BIDIROE
#define SPI0CR2_MODFEN                  _SPI0CR2.Bits.MODFEN

#define SPI0CR2_SPC0_MASK               1U
#define SPI0CR2_SPISWAI_MASK            2U
#define SPI0CR2_BIDIROE_MASK            8U
#define SPI0CR2_MODFEN_MASK             16U


/*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI0BRSTR;
extern volatile SPI0BRSTR _SPI0BR @(REG_BASE + 0x000000DAUL);
#define SPI0BR                          _SPI0BR.Byte
#define SPI0BR_SPR0                     _SPI0BR.Bits.SPR0
#define SPI0BR_SPR1                     _SPI0BR.Bits.SPR1
#define SPI0BR_SPR2                     _SPI0BR.Bits.SPR2
#define SPI0BR_SPPR0                    _SPI0BR.Bits.SPPR0
#define SPI0BR_SPPR1                    _SPI0BR.Bits.SPPR1
#define SPI0BR_SPPR2                    _SPI0BR.Bits.SPPR2
#define SPI0BR_SPR                      _SPI0BR.MergedBits.grpSPR
#define SPI0BR_SPPR                     _SPI0BR.MergedBits.grpSPPR

#define SPI0BR_SPR0_MASK                1U
#define SPI0BR_SPR1_MASK                2U
#define SPI0BR_SPR2_MASK                4U
#define SPI0BR_SPPR0_MASK               16U
#define SPI0BR_SPPR1_MASK               32U
#define SPI0BR_SPPR2_MASK               64U
#define SPI0BR_SPR_MASK                 7U
#define SPI0BR_SPR_BITNUM               0U
#define SPI0BR_SPPR_MASK                112U
#define SPI0BR_SPPR_BITNUM              4U


/*** SPI0SR - SPI 0 Status Register; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI0SRSTR;
extern volatile SPI0SRSTR _SPI0SR @(REG_BASE + 0x000000DBUL);
#define SPI0SR                          _SPI0SR.Byte
#define SPI0SR_MODF                     _SPI0SR.Bits.MODF
#define SPI0SR_SPTEF                    _SPI0SR.Bits.SPTEF
#define SPI0SR_SPIF                     _SPI0SR.Bits.SPIF

#define SPI0SR_MODF_MASK                16U
#define SPI0SR_SPTEF_MASK               32U
#define SPI0SR_SPIF_MASK                128U


/*** SPI0DR - SPI 0 Data Register; 0x000000DD ***/
typedef union {
  byte Byte;
} SPI0DRSTR;
extern volatile SPI0DRSTR _SPI0DR @(REG_BASE + 0x000000DDUL);
#define SPI0DR                          _SPI0DR.Byte


/*** SPI1CR1 - SPI 1 Control Register; 0x000000F0 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI1CR1STR;
extern volatile SPI1CR1STR _SPI1CR1 @(REG_BASE + 0x000000F0UL);
#define SPI1CR1                         _SPI1CR1.Byte
#define SPI1CR1_LSBFE                   _SPI1CR1.Bits.LSBFE
#define SPI1CR1_SSOE                    _SPI1CR1.Bits.SSOE
#define SPI1CR1_CPHA                    _SPI1CR1.Bits.CPHA
#define SPI1CR1_CPOL                    _SPI1CR1.Bits.CPOL
#define SPI1CR1_MSTR                    _SPI1CR1.Bits.MSTR
#define SPI1CR1_SPTIE                   _SPI1CR1.Bits.SPTIE
#define SPI1CR1_SPE                     _SPI1CR1.Bits.SPE
#define SPI1CR1_SPIE                    _SPI1CR1.Bits.SPIE

#define SPI1CR1_LSBFE_MASK              1U
#define SPI1CR1_SSOE_MASK               2U
#define SPI1CR1_CPHA_MASK               4U
#define SPI1CR1_CPOL_MASK               8U
#define SPI1CR1_MSTR_MASK               16U
#define SPI1CR1_SPTIE_MASK              32U
#define SPI1CR1_SPE_MASK                64U
#define SPI1CR1_SPIE_MASK               128U


/*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI1CR2STR;
extern volatile SPI1CR2STR _SPI1CR2 @(REG_BASE + 0x000000F1UL);
#define SPI1CR2                         _SPI1CR2.Byte
#define SPI1CR2_SPC0                    _SPI1CR2.Bits.SPC0
#define SPI1CR2_SPISWAI                 _SPI1CR2.Bits.SPISWAI
#define SPI1CR2_BIDIROE                 _SPI1CR2.Bits.BIDIROE
#define SPI1CR2_MODFEN                  _SPI1CR2.Bits.MODFEN

#define SPI1CR2_SPC0_MASK               1U
#define SPI1CR2_SPISWAI_MASK            2U
#define SPI1CR2_BIDIROE_MASK            8U
#define SPI1CR2_MODFEN_MASK             16U


/*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI1BRSTR;
extern volatile SPI1BRSTR _SPI1BR @(REG_BASE + 0x000000F2UL);
#define SPI1BR                          _SPI1BR.Byte
#define SPI1BR_SPR0                     _SPI1BR.Bits.SPR0
#define SPI1BR_SPR1                     _SPI1BR.Bits.SPR1
#define SPI1BR_SPR2                     _SPI1BR.Bits.SPR2
#define SPI1BR_SPPR0                    _SPI1BR.Bits.SPPR0
#define SPI1BR_SPPR1                    _SPI1BR.Bits.SPPR1
#define SPI1BR_SPPR2                    _SPI1BR.Bits.SPPR2
#define SPI1BR_SPR                      _SPI1BR.MergedBits.grpSPR
#define SPI1BR_SPPR                     _SPI1BR.MergedBits.grpSPPR

#define SPI1BR_SPR0_MASK                1U
#define SPI1BR_SPR1_MASK                2U
#define SPI1BR_SPR2_MASK                4U
#define SPI1BR_SPPR0_MASK               16U
#define SPI1BR_SPPR1_MASK               32U
#define SPI1BR_SPPR2_MASK               64U
#define SPI1BR_SPR_MASK                 7U
#define SPI1BR_SPR_BITNUM               0U
#define SPI1BR_SPPR_MASK                112U
#define SPI1BR_SPPR_BITNUM              4U


/*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI1SRSTR;
extern volatile SPI1SRSTR _SPI1SR @(REG_BASE + 0x000000F3UL);
#define SPI1SR                          _SPI1SR.Byte
#define SPI1SR_MODF                     _SPI1SR.Bits.MODF
#define SPI1SR_SPTEF                    _SPI1SR.Bits.SPTEF
#define SPI1SR_SPIF                     _SPI1SR.Bits.SPIF

#define SPI1SR_MODF_MASK                16U
#define SPI1SR_SPTEF_MASK               32U
#define SPI1SR_SPIF_MASK                128U


/*** SPI1DR - SPI 1 Data Register; 0x000000F5 ***/
typedef union {
  byte Byte;
} SPI1DRSTR;
extern volatile SPI1DRSTR _SPI1DR @(REG_BASE + 0x000000F5UL);
#define SPI1DR                          _SPI1DR.Byte


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Flash Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Flash Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Flash Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Flash Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Flash Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Flash Clock Divider Bit 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte FDIVLD      :1;                                       /* Flash Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_PRDIV8                  _FCLKDIV.Bits.PRDIV8
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_PRDIV8_MASK             64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               63U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte RNV2        :1;                                       /* Reserved Non Volatile flag bit 2 */
    byte RNV3        :1;                                       /* Reserved Non Volatile flag bit 3 */
    byte RNV4        :1;                                       /* Reserved Non Volatile flag bit 4 */
    byte RNV5        :1;                                       /* Reserved Non Volatile flag bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_RNV2                       _FSEC.Bits.RNV2
#define FSEC_RNV3                       _FSEC.Bits.RNV3
#define FSEC_RNV4                       _FSEC.Bits.RNV4
#define FSEC_RNV5                       _FSEC.Bits.RNV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_RNV_2                      _FSEC.MergedBits.grpRNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_RNV                        FSEC_RNV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_RNV2_MASK                  4U
#define FSEC_RNV3_MASK                  8U
#define FSEC_RNV4_MASK                  16U
#define FSEC_RNV5_MASK                  32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_RNV_2_MASK                 60U
#define FSEC_RNV_2_BITNUM               2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte WRALL       :1;                                       /* Write to all register banks */
    byte MRDS        :2;                                       /* Margin Read Setting */
    byte             :1; 
  } Bits;
} FTSTMODSTR;
extern volatile FTSTMODSTR _FTSTMOD @(REG_BASE + 0x00000102UL);
#define FTSTMOD                         _FTSTMOD.Byte
#define FTSTMOD_WRALL                   _FTSTMOD.Bits.WRALL
#define FTSTMOD_MRDS                    _FTSTMOD.Bits.MRDS

#define FTSTMOD_WRALL_MASK              16U
#define FTSTMOD_MRDS_MASK               96U
#define FTSTMOD_MRDS_BITNUM             5U


/*** FCNFG - Flash Configuration Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte BKSEL       :1;                                       /* Block Select */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte KEYACC      :1;                                       /* Enable Security Key Writing */
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000103UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_BKSEL                     _FCNFG.Bits.BKSEL
#define FCNFG_KEYACC                    _FCNFG.Bits.KEYACC
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE
#define FCNFG_CBEIE                     _FCNFG.Bits.CBEIE

#define FCNFG_BKSEL_MASK                1U
#define FCNFG_KEYACC_MASK               32U
#define FCNFG_CCIE_MASK                 64U
#define FCNFG_CBEIE_MASK                128U


/*** FPROT - Flash Protection Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte RNV6        :1;                                       /* Reserved Non-Volatile Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000104UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_RNV6                      _FPROT.Bits.RNV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_RNV6_MASK                 64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** FSTAT - Flash Status Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte FAIL        :1;                                       /* Failed Flash Operation Flag (Special mode only) */
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffers Empty Interrupt Flag */
  } Bits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000105UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_FAIL                      _FSTAT.Bits.FAIL
#define FSTAT_BLANK                     _FSTAT.Bits.BLANK
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_PVIOL                     _FSTAT.Bits.PVIOL
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_CBEIF                     _FSTAT.Bits.CBEIF

#define FSTAT_FAIL_MASK                 2U
#define FSTAT_BLANK_MASK                4U
#define FSTAT_ACCERR_MASK               16U
#define FSTAT_PVIOL_MASK                32U
#define FSTAT_CCIF_MASK                 64U
#define FSTAT_CBEIF_MASK                128U


/*** FCMD - Flash Command Buffer and Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* NVM User Mode Command Bit 0 */
    byte CMDB1       :1;                                       /* NVM User Mode Command Bit 1 */
    byte CMDB2       :1;                                       /* NVM User Mode Command Bit 2 */
    byte CMDB3       :1;                                       /* NVM User Mode Command Bit 3 */
    byte CMDB4       :1;                                       /* NVM User Mode Command Bit 4 */
    byte CMDB5       :1;                                       /* NVM User Mode Command Bit 5 */
    byte CMDB6       :1;                                       /* NVM User Mode Command Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :7;
    byte         :1;
  } MergedBits;
} FCMDSTR;
extern volatile FCMDSTR _FCMD @(REG_BASE + 0x00000106UL);
#define FCMD                            _FCMD.Byte
#define FCMD_CMDB0                      _FCMD.Bits.CMDB0
#define FCMD_CMDB1                      _FCMD.Bits.CMDB1
#define FCMD_CMDB2                      _FCMD.Bits.CMDB2
#define FCMD_CMDB3                      _FCMD.Bits.CMDB3
#define FCMD_CMDB4                      _FCMD.Bits.CMDB4
#define FCMD_CMDB5                      _FCMD.Bits.CMDB5
#define FCMD_CMDB6                      _FCMD.Bits.CMDB6
#define FCMD_CMDB                       _FCMD.MergedBits.grpCMDB

#define FCMD_CMDB0_MASK                 1U
#define FCMD_CMDB1_MASK                 2U
#define FCMD_CMDB2_MASK                 4U
#define FCMD_CMDB3_MASK                 8U
#define FCMD_CMDB4_MASK                 16U
#define FCMD_CMDB5_MASK                 32U
#define FCMD_CMDB6_MASK                 64U
#define FCMD_CMDB_MASK                  127U
#define FCMD_CMDB_BITNUM                0U


/*** FCTL - Flash Control Register; 0x00000107 ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Non-volatile bit 0 */
    byte NV1         :1;                                       /* Non-volatile bit 1 */
    byte NV2         :1;                                       /* Non-volatile bit 2 */
    byte NV3         :1;                                       /* Non-volatile bit 3 */
    byte NV4         :1;                                       /* Non-volatile bit 4 */
    byte NV5         :1;                                       /* Non-volatile bit 5 */
    byte NV6         :1;                                       /* Non-volatile bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpNV   :7;
    byte         :1;
  } MergedBits;
} FCTLSTR;
extern volatile FCTLSTR _FCTL @(REG_BASE + 0x00000107UL);
#define FCTL                            _FCTL.Byte
#define FCTL_NV0                        _FCTL.Bits.NV0
#define FCTL_NV1                        _FCTL.Bits.NV1
#define FCTL_NV2                        _FCTL.Bits.NV2
#define FCTL_NV3                        _FCTL.Bits.NV3
#define FCTL_NV4                        _FCTL.Bits.NV4
#define FCTL_NV5                        _FCTL.Bits.NV5
#define FCTL_NV6                        _FCTL.Bits.NV6
#define FCTL_NV                         _FCTL.MergedBits.grpNV

#define FCTL_NV0_MASK                   1U
#define FCTL_NV1_MASK                   2U
#define FCTL_NV2_MASK                   4U
#define FCTL_NV3_MASK                   8U
#define FCTL_NV4_MASK                   16U
#define FCTL_NV5_MASK                   32U
#define FCTL_NV6_MASK                   64U
#define FCTL_NV_MASK                    127U
#define FCTL_NV_BITNUM                  0U


/*** FADDR - Flash Address Register; 0x00000108 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FADDRHI - Flash Address High Register; 0x00000108 ***/
    union {
      byte Byte;
    } FADDRHISTR;
    #define FADDRHI                     _FADDR.Overlap_STR.FADDRHISTR.Byte
    

    /*** FADDRLO - Flash Address Low Register; 0x00000109 ***/
    union {
      byte Byte;
    } FADDRLOSTR;
    #define FADDRLO                     _FADDR.Overlap_STR.FADDRLOSTR.Byte
    
  } Overlap_STR;

  struct {
    word FADDRLO_grp :8;                                       /* Flash Address Bits */ /*Warning: group name is duplicated with register name*/
    word FADDRHI_grp :8;                                       /* Flash Address Bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} FADDRSTR;
extern volatile FADDRSTR _FADDR @(REG_BASE + 0x00000108UL);
#define FADDR                           _FADDR.Word
#define FADDR_FADDRLO                   _FADDR.Bits.FADDRLO_grp
#define FADDR_FADDRHI                   _FADDR.Bits.FADDRHI_grp

#define FADDR_FADDRLO_MASK              255U
#define FADDR_FADDRLO_BITNUM            0U
#define FADDR_FADDRHI_MASK              65280U
#define FADDR_FADDRHI_BITNUM            8U


/*** FDATA - Flash Data Register; 0x0000010A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FDATAHI - Flash Data High Register; 0x0000010A ***/
    union {
      byte Byte;
    } FDATAHISTR;
    #define FDATAHI                     _FDATA.Overlap_STR.FDATAHISTR.Byte
    

    /*** FDATALO - Flash Data Low Register; 0x0000010B ***/
    union {
      byte Byte;
    } FDATALOSTR;
    #define FDATALO                     _FDATA.Overlap_STR.FDATALOSTR.Byte
    
  } Overlap_STR;

  struct {
    word FDATALO_grp :8;                                       /* Flash Data Bits */ /*Warning: group name is duplicated with register name*/
    word FDATAHI_grp :8;                                       /* Flash Data Bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} FDATASTR;
extern volatile FDATASTR _FDATA @(REG_BASE + 0x0000010AUL);
#define FDATA                           _FDATA.Word
#define FDATA_FDATALO                   _FDATA.Bits.FDATALO_grp
#define FDATA_FDATAHI                   _FDATA.Bits.FDATAHI_grp

#define FDATA_FDATALO_MASK              255U
#define FDATA_FDATALO_BITNUM            0U
#define FDATA_FDATAHI_MASK              65280U
#define FDATA_FDATAHI_BITNUM            8U


/*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* EEPROM Clock Divider 0 */
    byte EDIV1       :1;                                       /* EEPROM Clock Divider 1 */
    byte EDIV2       :1;                                       /* EEPROM Clock Divider 2 */
    byte EDIV3       :1;                                       /* EEPROM Clock Divider 3 */
    byte EDIV4       :1;                                       /* EEPROM Clock Divider 4 */
    byte EDIV5       :1;                                       /* EEPROM Clock Divider 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte EDIVLD      :1;                                       /* EEPROM Clock Divider Loaded */
  } Bits;
  struct {
    byte grpEDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} ECLKDIVSTR;
extern volatile ECLKDIVSTR _ECLKDIV @(REG_BASE + 0x00000110UL);
#define ECLKDIV                         _ECLKDIV.Byte
#define ECLKDIV_EDIV0                   _ECLKDIV.Bits.EDIV0
#define ECLKDIV_EDIV1                   _ECLKDIV.Bits.EDIV1
#define ECLKDIV_EDIV2                   _ECLKDIV.Bits.EDIV2
#define ECLKDIV_EDIV3                   _ECLKDIV.Bits.EDIV3
#define ECLKDIV_EDIV4                   _ECLKDIV.Bits.EDIV4
#define ECLKDIV_EDIV5                   _ECLKDIV.Bits.EDIV5
#define ECLKDIV_PRDIV8                  _ECLKDIV.Bits.PRDIV8
#define ECLKDIV_EDIVLD                  _ECLKDIV.Bits.EDIVLD
#define ECLKDIV_EDIV                    _ECLKDIV.MergedBits.grpEDIV

#define ECLKDIV_EDIV0_MASK              1U
#define ECLKDIV_EDIV1_MASK              2U
#define ECLKDIV_EDIV2_MASK              4U
#define ECLKDIV_EDIV3_MASK              8U
#define ECLKDIV_EDIV4_MASK              16U
#define ECLKDIV_EDIV5_MASK              32U
#define ECLKDIV_PRDIV8_MASK             64U
#define ECLKDIV_EDIVLD_MASK             128U
#define ECLKDIV_EDIV_MASK               63U
#define ECLKDIV_EDIV_BITNUM             0U


/*** ECNFG - EEPROM Configuration Register; 0x00000113 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} ECNFGSTR;
extern volatile ECNFGSTR _ECNFG @(REG_BASE + 0x00000113UL);
#define ECNFG                           _ECNFG.Byte
#define ECNFG_CCIE                      _ECNFG.Bits.CCIE
#define ECNFG_CBEIE                     _ECNFG.Bits.CBEIE

#define ECNFG_CCIE_MASK                 64U
#define ECNFG_CBEIE_MASK                128U


/*** EPROT - EEPROM Protection Register; 0x00000114 ***/
typedef union {
  byte Byte;
  struct {
    byte EPS0        :1;                                       /* EEPROM Protection address size 0 */
    byte EPS1        :1;                                       /* EEPROM Protection address size 1 */
    byte EPS2        :1;                                       /* EEPROM Protection address size 2 */
    byte EPDIS       :1;                                       /* EEPROM Protection disable */
    byte RNV4        :1;                                       /* EEPROM Protection address size 4 */
    byte RNV5        :1;                                       /* EEPROM Protection address size 5 */
    byte RNV6        :1;                                       /* EEPROM Protection address size 6 */
    byte EPOPEN      :1;                                       /* Opens the EEPROM block or a subsection of it for program or erase */
  } Bits;
  struct {
    byte grpEPS  :3;
    byte         :1;
    byte grpRNV_4 :3;
    byte         :1;
  } MergedBits;
} EPROTSTR;
extern volatile EPROTSTR _EPROT @(REG_BASE + 0x00000114UL);
#define EPROT                           _EPROT.Byte
#define EPROT_EPS0                      _EPROT.Bits.EPS0
#define EPROT_EPS1                      _EPROT.Bits.EPS1
#define EPROT_EPS2                      _EPROT.Bits.EPS2
#define EPROT_EPDIS                     _EPROT.Bits.EPDIS
#define EPROT_RNV4                      _EPROT.Bits.RNV4
#define EPROT_RNV5                      _EPROT.Bits.RNV5
#define EPROT_RNV6                      _EPROT.Bits.RNV6
#define EPROT_EPOPEN                    _EPROT.Bits.EPOPEN
#define EPROT_EPS                       _EPROT.MergedBits.grpEPS
#define EPROT_RNV_4                     _EPROT.MergedBits.grpRNV_4
#define EPROT_RNV                       EPROT_RNV_4

#define EPROT_EPS0_MASK                 1U
#define EPROT_EPS1_MASK                 2U
#define EPROT_EPS2_MASK                 4U
#define EPROT_EPDIS_MASK                8U
#define EPROT_RNV4_MASK                 16U
#define EPROT_RNV5_MASK                 32U
#define EPROT_RNV6_MASK                 64U
#define EPROT_EPOPEN_MASK               128U
#define EPROT_EPS_MASK                  7U
#define EPROT_EPS_BITNUM                0U
#define EPROT_RNV_4_MASK                112U
#define EPROT_RNV_4_BITNUM              4U


/*** ESTAT - EEPROM Status Register; 0x00000115 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte FAIL        :1;                                       /* Failed EEPROM Operation Flag (Special mode only) */
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffer Empty Interrupt Flag */
  } Bits;
} ESTATSTR;
extern volatile ESTATSTR _ESTAT @(REG_BASE + 0x00000115UL);
#define ESTAT                           _ESTAT.Byte
#define ESTAT_FAIL                      _ESTAT.Bits.FAIL
#define ESTAT_BLANK                     _ESTAT.Bits.BLANK
#define ESTAT_ACCERR                    _ESTAT.Bits.ACCERR
#define ESTAT_PVIOL                     _ESTAT.Bits.PVIOL
#define ESTAT_CCIF                      _ESTAT.Bits.CCIF
#define ESTAT_CBEIF                     _ESTAT.Bits.CBEIF

#define ESTAT_FAIL_MASK                 2U
#define ESTAT_BLANK_MASK                4U
#define ESTAT_ACCERR_MASK               16U
#define ESTAT_PVIOL_MASK                32U
#define ESTAT_CCIF_MASK                 64U
#define ESTAT_CBEIF_MASK                128U


/*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB        :7;                                       /* EEPROM command */
    byte             :1; 
  } Bits;
} ECMDSTR;
extern volatile ECMDSTR _ECMD @(REG_BASE + 0x00000116UL);
#define ECMD                            _ECMD.Byte
#define ECMD_CMDB                       _ECMD.Bits.CMDB

#define ECMD_CMDB_MASK                  127U
#define ECMD_CMDB_BITNUM                0U


/*** EADDR - EEPROM Address Register; 0x00000118 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** EADDRHI - EEPROM Address High Register; 0x00000118 ***/
    union {
      byte Byte;
      struct {
        byte EABHI       :2;                                       /* EEPROM Address High Bits */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } EADDRHISTR;
    #define EADDRHI                     _EADDR.Overlap_STR.EADDRHISTR.Byte
    #define EADDRHI_EABHI               _EADDR.Overlap_STR.EADDRHISTR.Bits.EABHI
    
    #define EADDRHI_EABHI_MASK          3U
    #define EADDRHI_EABHI_BITNUM        0U
    

    /*** EADDRLO - EEPROM Address Low Register; 0x00000119 ***/
    union {
      byte Byte;
      struct {
        byte EABLO       :8;                                       /* EEPROM Address Low Bits */
      } Bits;
    } EADDRLOSTR;
    #define EADDRLO                     _EADDR.Overlap_STR.EADDRLOSTR.Byte
    #define EADDRLO_EABLO               _EADDR.Overlap_STR.EADDRLOSTR.Bits.EABLO
    
    #define EADDRLO_EABLO_MASK          255U
    #define EADDRLO_EABLO_BITNUM        0U
    
  } Overlap_STR;

  struct {
    word EABLO       :8;                                       /* EEPROM Address Bits */
    word EABHI       :2;                                       /* EEPROM Address Bits */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} EADDRSTR;
extern volatile EADDRSTR _EADDR @(REG_BASE + 0x00000118UL);
#define EADDR                           _EADDR.Word
#define EADDR_EABLO                     _EADDR.Bits.EABLO
#define EADDR_EABHI                     _EADDR.Bits.EABHI

#define EADDR_EABLO_MASK                255U
#define EADDR_EABLO_BITNUM              0U
#define EADDR_EABHI_MASK                768U
#define EADDR_EABHI_BITNUM              8U


/*** EDATA - EEPROM Data Register; 0x0000011A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** EDATAHI - EEPROM Data High Register; 0x0000011A ***/
    union {
      byte Byte;
      struct {
        byte EDHI        :8;                                       /* EEPROM Data High Bits */
      } Bits;
    } EDATAHISTR;
    #define EDATAHI                     _EDATA.Overlap_STR.EDATAHISTR.Byte
    #define EDATAHI_EDHI                _EDATA.Overlap_STR.EDATAHISTR.Bits.EDHI
    
    #define EDATAHI_EDHI_MASK           255U
    #define EDATAHI_EDHI_BITNUM         0U
    

    /*** EDATALO - EEPROM Data Low Register; 0x0000011B ***/
    union {
      byte Byte;
      struct {
        byte EDLO        :8;                                       /* EEPROM Data Low Bits */
      } Bits;
    } EDATALOSTR;
    #define EDATALO                     _EDATA.Overlap_STR.EDATALOSTR.Byte
    #define EDATALO_EDLO                _EDATA.Overlap_STR.EDATALOSTR.Bits.EDLO
    
    #define EDATALO_EDLO_MASK           255U
    #define EDATALO_EDLO_BITNUM         0U
    
  } Overlap_STR;

  struct {
    word EDLO        :8;                                       /* EEPROM Data Bits */
    word EDHI        :8;                                       /* EEPROM Data Bits */
  } Bits;
} EDATASTR;
extern volatile EDATASTR _EDATA @(REG_BASE + 0x0000011AUL);
#define EDATA                           _EDATA.Word
#define EDATA_EDLO                      _EDATA.Bits.EDLO
#define EDATA_EDHI                      _EDATA.Bits.EDHI

#define EDATA_EDLO_MASK                 255U
#define EDATA_EDLO_BITNUM               0U
#define EDATA_EDHI_MASK                 65280U
#define EDATA_EDHI_BITNUM               8U


/*** RAMWPC - RAM Write Protection Control Register; 0x0000011C ***/
typedef union {
  byte Byte;
  struct {
    byte AVIF        :1;                                       /* S12X_CPU Access Violation Interrupt Flag */
    byte AVIE        :1;                                       /* S12X_CPU Access Violation Interrupt Enable */
    byte FRXG        :1;                                       /* FLEXRAY area could be accessible by the XGATE write command */
    byte FRCPU       :1;                                       /* FLEXRAY area could be accessible by the CPU write command */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RWPE        :1;                                       /* RAM Write Protection Enable */
  } Bits;
} RAMWPCSTR;
extern volatile RAMWPCSTR _RAMWPC @(REG_BASE + 0x0000011CUL);
#define RAMWPC                          _RAMWPC.Byte
#define RAMWPC_AVIF                     _RAMWPC.Bits.AVIF
#define RAMWPC_AVIE                     _RAMWPC.Bits.AVIE
#define RAMWPC_FRXG                     _RAMWPC.Bits.FRXG
#define RAMWPC_FRCPU                    _RAMWPC.Bits.FRCPU
#define RAMWPC_RWPE                     _RAMWPC.Bits.RWPE

#define RAMWPC_AVIF_MASK                1U
#define RAMWPC_AVIE_MASK                2U
#define RAMWPC_FRXG_MASK                4U
#define RAMWPC_FRCPU_MASK               8U
#define RAMWPC_RWPE_MASK                128U


/*** RAMXGU - RAM XGATE Upper Boundary Register; 0x0000011D ***/
typedef union {
  byte Byte;
  struct {
    byte XGU0        :1;                                       /* XGATE Region Upper Boundary Bit 0 */
    byte XGU1        :1;                                       /* XGATE Region Upper Boundary Bit 1 */
    byte XGU2        :1;                                       /* XGATE Region Upper Boundary Bit 2 */
    byte XGU3        :1;                                       /* XGATE Region Upper Boundary Bit 3 */
    byte XGU4        :1;                                       /* XGATE Region Upper Boundary Bit 4 */
    byte XGU5        :1;                                       /* XGATE Region Upper Boundary Bit 5 */
    byte XGU6        :1;                                       /* XGATE Region Upper Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpXGU  :7;
    byte         :1;
  } MergedBits;
} RAMXGUSTR;
extern volatile RAMXGUSTR _RAMXGU @(REG_BASE + 0x0000011DUL);
#define RAMXGU                          _RAMXGU.Byte
#define RAMXGU_XGU0                     _RAMXGU.Bits.XGU0
#define RAMXGU_XGU1                     _RAMXGU.Bits.XGU1
#define RAMXGU_XGU2                     _RAMXGU.Bits.XGU2
#define RAMXGU_XGU3                     _RAMXGU.Bits.XGU3
#define RAMXGU_XGU4                     _RAMXGU.Bits.XGU4
#define RAMXGU_XGU5                     _RAMXGU.Bits.XGU5
#define RAMXGU_XGU6                     _RAMXGU.Bits.XGU6
#define RAMXGU_XGU                      _RAMXGU.MergedBits.grpXGU

#define RAMXGU_XGU0_MASK                1U
#define RAMXGU_XGU1_MASK                2U
#define RAMXGU_XGU2_MASK                4U
#define RAMXGU_XGU3_MASK                8U
#define RAMXGU_XGU4_MASK                16U
#define RAMXGU_XGU5_MASK                32U
#define RAMXGU_XGU6_MASK                64U
#define RAMXGU_XGU_MASK                 127U
#define RAMXGU_XGU_BITNUM               0U


/*** RAMSHL - RAM Shared Region Lower Boundary Register; 0x0000011E ***/
typedef union {
  byte Byte;
  struct {
    byte SHL0        :1;                                       /* RAM Shared Region Lower Boundary Bit 0 */
    byte SHL1        :1;                                       /* RAM Shared Region Lower Boundary Bit 1 */
    byte SHL2        :1;                                       /* RAM Shared Region Lower Boundary Bit 2 */
    byte SHL3        :1;                                       /* RAM Shared Region Lower Boundary Bit 3 */
    byte SHL4        :1;                                       /* RAM Shared Region Lower Boundary Bit 4 */
    byte SHL5        :1;                                       /* RAM Shared Region Lower Boundary Bit 5 */
    byte SHL6        :1;                                       /* RAM Shared Region Lower Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSHL  :7;
    byte         :1;
  } MergedBits;
} RAMSHLSTR;
extern volatile RAMSHLSTR _RAMSHL @(REG_BASE + 0x0000011EUL);
#define RAMSHL                          _RAMSHL.Byte
#define RAMSHL_SHL0                     _RAMSHL.Bits.SHL0
#define RAMSHL_SHL1                     _RAMSHL.Bits.SHL1
#define RAMSHL_SHL2                     _RAMSHL.Bits.SHL2
#define RAMSHL_SHL3                     _RAMSHL.Bits.SHL3
#define RAMSHL_SHL4                     _RAMSHL.Bits.SHL4
#define RAMSHL_SHL5                     _RAMSHL.Bits.SHL5
#define RAMSHL_SHL6                     _RAMSHL.Bits.SHL6
#define RAMSHL_SHL                      _RAMSHL.MergedBits.grpSHL

#define RAMSHL_SHL0_MASK                1U
#define RAMSHL_SHL1_MASK                2U
#define RAMSHL_SHL2_MASK                4U
#define RAMSHL_SHL3_MASK                8U
#define RAMSHL_SHL4_MASK                16U
#define RAMSHL_SHL5_MASK                32U
#define RAMSHL_SHL6_MASK                64U
#define RAMSHL_SHL_MASK                 127U
#define RAMSHL_SHL_BITNUM               0U


/*** RAMSHU - RAM Shared Region Upper Boundary Register; 0x0000011F ***/
typedef union {
  byte Byte;
  struct {
    byte SHU0        :1;                                       /* RAM Shared Region Upper Boundary Bit 0 */
    byte SHU1        :1;                                       /* RAM Shared Region Upper Boundary Bit 1 */
    byte SHU2        :1;                                       /* RAM Shared Region Upper Boundary Bit 2 */
    byte SHU3        :1;                                       /* RAM Shared Region Upper Boundary Bit 3 */
    byte SHU4        :1;                                       /* RAM Shared Region Upper Boundary Bit 4 */
    byte SHU5        :1;                                       /* RAM Shared Region Upper Boundary Bit 5 */
    byte SHU6        :1;                                       /* RAM Shared Region Upper Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSHU  :7;
    byte         :1;
  } MergedBits;
} RAMSHUSTR;
extern volatile RAMSHUSTR _RAMSHU @(REG_BASE + 0x0000011FUL);
#define RAMSHU                          _RAMSHU.Byte
#define RAMSHU_SHU0                     _RAMSHU.Bits.SHU0
#define RAMSHU_SHU1                     _RAMSHU.Bits.SHU1
#define RAMSHU_SHU2                     _RAMSHU.Bits.SHU2
#define RAMSHU_SHU3                     _RAMSHU.Bits.SHU3
#define RAMSHU_SHU4                     _RAMSHU.Bits.SHU4
#define RAMSHU_SHU5                     _RAMSHU.Bits.SHU5
#define RAMSHU_SHU6                     _RAMSHU.Bits.SHU6
#define RAMSHU_SHU                      _RAMSHU.MergedBits.grpSHU

#define RAMSHU_SHU0_MASK                1U
#define RAMSHU_SHU1_MASK                2U
#define RAMSHU_SHU2_MASK                4U
#define RAMSHU_SHU3_MASK                8U
#define RAMSHU_SHU4_MASK                16U
#define RAMSHU_SHU5_MASK                32U
#define RAMSHU_SHU6_MASK                64U
#define RAMSHU_SHU_MASK                 127U
#define RAMSHU_SHU_BITNUM               0U


/*** IVBR - Interrupt Vector Base Register; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte IVB_ADDR    :8;                                       /* Interrupt vector base address bits */
  } Bits;
} IVBRSTR;
extern volatile IVBRSTR _IVBR @(REG_BASE + 0x00000121UL);
#define IVBR                            _IVBR.Byte
#define IVBR_IVB_ADDR                   _IVBR.Bits.IVB_ADDR

#define IVBR_IVB_ADDR_MASK              255U
#define IVBR_IVB_ADDR_BITNUM            0U


/*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x00000126 ***/
typedef union {
  byte Byte;
  struct {
    byte XILVL       :3;                                       /* XGATE Interrupt Priority Level */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} INT_XGPRIOSTR;
extern volatile INT_XGPRIOSTR _INT_XGPRIO @(REG_BASE + 0x00000126UL);
#define INT_XGPRIO                      _INT_XGPRIO.Byte
#define INT_XGPRIO_XILVL                _INT_XGPRIO.Bits.XILVL

#define INT_XGPRIO_XILVL_MASK           7U
#define INT_XGPRIO_XILVL_BITNUM         0U


/*** INT_CFADDR - Interrupt Configuration Address Register; 0x00000127 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte INT_CFADDR_grp :4;                                    /* Interrupt Request Configuration Data Register select bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} INT_CFADDRSTR;
extern volatile INT_CFADDRSTR _INT_CFADDR @(REG_BASE + 0x00000127UL);
#define INT_CFADDR                      _INT_CFADDR.Byte
#define INT_CFADDR_INT_CFADDR           _INT_CFADDR.Bits.INT_CFADDR_grp

#define INT_CFADDR_INT_CFADDR_MASK      240U
#define INT_CFADDR_INT_CFADDR_BITNUM    4U


/*** INT_CFDATA0 - Interrupt Configuration Data Register 0; 0x00000128 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA0STR;
extern volatile INT_CFDATA0STR _INT_CFDATA0 @(REG_BASE + 0x00000128UL);
#define INT_CFDATA0                     _INT_CFDATA0.Byte
#define INT_CFDATA0_PRIOLVL             _INT_CFDATA0.Bits.PRIOLVL
#define INT_CFDATA0_RQST                _INT_CFDATA0.Bits.RQST
/* INT_CFDATA_ARR: Access 8 INT_CFDATAx registers in an array */
#define INT_CFDATA_ARR                  ((volatile byte *) &INT_CFDATA0)

#define INT_CFDATA0_PRIOLVL_MASK        7U
#define INT_CFDATA0_PRIOLVL_BITNUM      0U
#define INT_CFDATA0_RQST_MASK           128U


/*** INT_CFDATA1 - Interrupt Configuration Data Register 1; 0x00000129 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA1STR;
extern volatile INT_CFDATA1STR _INT_CFDATA1 @(REG_BASE + 0x00000129UL);
#define INT_CFDATA1                     _INT_CFDATA1.Byte
#define INT_CFDATA1_PRIOLVL             _INT_CFDATA1.Bits.PRIOLVL
#define INT_CFDATA1_RQST                _INT_CFDATA1.Bits.RQST

#define INT_CFDATA1_PRIOLVL_MASK        7U
#define INT_CFDATA1_PRIOLVL_BITNUM      0U
#define INT_CFDATA1_RQST_MASK           128U


/*** INT_CFDATA2 - Interrupt Configuration Data Register 2; 0x0000012A ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA2STR;
extern volatile INT_CFDATA2STR _INT_CFDATA2 @(REG_BASE + 0x0000012AUL);
#define INT_CFDATA2                     _INT_CFDATA2.Byte
#define INT_CFDATA2_PRIOLVL             _INT_CFDATA2.Bits.PRIOLVL
#define INT_CFDATA2_RQST                _INT_CFDATA2.Bits.RQST

#define INT_CFDATA2_PRIOLVL_MASK        7U
#define INT_CFDATA2_PRIOLVL_BITNUM      0U
#define INT_CFDATA2_RQST_MASK           128U


/*** INT_CFDATA3 - Interrupt Configuration Data Register 3; 0x0000012B ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA3STR;
extern volatile INT_CFDATA3STR _INT_CFDATA3 @(REG_BASE + 0x0000012BUL);
#define INT_CFDATA3                     _INT_CFDATA3.Byte
#define INT_CFDATA3_PRIOLVL             _INT_CFDATA3.Bits.PRIOLVL
#define INT_CFDATA3_RQST                _INT_CFDATA3.Bits.RQST

#define INT_CFDATA3_PRIOLVL_MASK        7U
#define INT_CFDATA3_PRIOLVL_BITNUM      0U
#define INT_CFDATA3_RQST_MASK           128U


/*** INT_CFDATA4 - Interrupt Configuration Data Register 4; 0x0000012C ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA4STR;
extern volatile INT_CFDATA4STR _INT_CFDATA4 @(REG_BASE + 0x0000012CUL);
#define INT_CFDATA4                     _INT_CFDATA4.Byte
#define INT_CFDATA4_PRIOLVL             _INT_CFDATA4.Bits.PRIOLVL
#define INT_CFDATA4_RQST                _INT_CFDATA4.Bits.RQST

#define INT_CFDATA4_PRIOLVL_MASK        7U
#define INT_CFDATA4_PRIOLVL_BITNUM      0U
#define INT_CFDATA4_RQST_MASK           128U


/*** INT_CFDATA5 - Interrupt Configuration Data Register 5; 0x0000012D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA5STR;
extern volatile INT_CFDATA5STR _INT_CFDATA5 @(REG_BASE + 0x0000012DUL);
#define INT_CFDATA5                     _INT_CFDATA5.Byte
#define INT_CFDATA5_PRIOLVL             _INT_CFDATA5.Bits.PRIOLVL
#define INT_CFDATA5_RQST                _INT_CFDATA5.Bits.RQST

#define INT_CFDATA5_PRIOLVL_MASK        7U
#define INT_CFDATA5_PRIOLVL_BITNUM      0U
#define INT_CFDATA5_RQST_MASK           128U


/*** INT_CFDATA6 - Interrupt Configuration Data Register 6; 0x0000012E ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA6STR;
extern volatile INT_CFDATA6STR _INT_CFDATA6 @(REG_BASE + 0x0000012EUL);
#define INT_CFDATA6                     _INT_CFDATA6.Byte
#define INT_CFDATA6_PRIOLVL             _INT_CFDATA6.Bits.PRIOLVL
#define INT_CFDATA6_RQST                _INT_CFDATA6.Bits.RQST

#define INT_CFDATA6_PRIOLVL_MASK        7U
#define INT_CFDATA6_PRIOLVL_BITNUM      0U
#define INT_CFDATA6_RQST_MASK           128U


/*** INT_CFDATA7 - Interrupt Configuration Data Register 7; 0x0000012F ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA7STR;
extern volatile INT_CFDATA7STR _INT_CFDATA7 @(REG_BASE + 0x0000012FUL);
#define INT_CFDATA7                     _INT_CFDATA7.Byte
#define INT_CFDATA7_PRIOLVL             _INT_CFDATA7.Bits.PRIOLVL
#define INT_CFDATA7_RQST                _INT_CFDATA7.Bits.RQST

#define INT_CFDATA7_PRIOLVL_MASK        7U
#define INT_CFDATA7_PRIOLVL_BITNUM      0U
#define INT_CFDATA7_RQST_MASK           128U


/*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN0CTL0STR;
extern volatile CAN0CTL0STR _CAN0CTL0 @(REG_BASE + 0x00000140UL);
#define CAN0CTL0                        _CAN0CTL0.Byte
#define CAN0CTL0_INITRQ                 _CAN0CTL0.Bits.INITRQ
#define CAN0CTL0_SLPRQ                  _CAN0CTL0.Bits.SLPRQ
#define CAN0CTL0_WUPE                   _CAN0CTL0.Bits.WUPE
#define CAN0CTL0_TIME                   _CAN0CTL0.Bits.TIME
#define CAN0CTL0_SYNCH                  _CAN0CTL0.Bits.SYNCH
#define CAN0CTL0_CSWAI                  _CAN0CTL0.Bits.CSWAI
#define CAN0CTL0_RXACT                  _CAN0CTL0.Bits.RXACT
#define CAN0CTL0_RXFRM                  _CAN0CTL0.Bits.RXFRM
/* CAN0CTL_ARR: Access 2 CAN0CTLx registers in an array */
#define CAN0CTL_ARR                     ((volatile byte *) &CAN0CTL0)

#define CAN0CTL0_INITRQ_MASK            1U
#define CAN0CTL0_SLPRQ_MASK             2U
#define CAN0CTL0_WUPE_MASK              4U
#define CAN0CTL0_TIME_MASK              8U
#define CAN0CTL0_SYNCH_MASK             16U
#define CAN0CTL0_CSWAI_MASK             32U
#define CAN0CTL0_RXACT_MASK             64U
#define CAN0CTL0_RXFRM_MASK             128U


/*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN 0 Clock Source */
    byte CANE        :1;                                       /* MSCAN 0 Enable */
  } Bits;
} CAN0CTL1STR;
extern volatile CAN0CTL1STR _CAN0CTL1 @(REG_BASE + 0x00000141UL);
#define CAN0CTL1                        _CAN0CTL1.Byte
#define CAN0CTL1_INITAK                 _CAN0CTL1.Bits.INITAK
#define CAN0CTL1_SLPAK                  _CAN0CTL1.Bits.SLPAK
#define CAN0CTL1_WUPM                   _CAN0CTL1.Bits.WUPM
#define CAN0CTL1_BORM                   _CAN0CTL1.Bits.BORM
#define CAN0CTL1_LISTEN                 _CAN0CTL1.Bits.LISTEN
#define CAN0CTL1_LOOPB                  _CAN0CTL1.Bits.LOOPB
#define CAN0CTL1_CLKSRC                 _CAN0CTL1.Bits.CLKSRC
#define CAN0CTL1_CANE                   _CAN0CTL1.Bits.CANE

#define CAN0CTL1_INITAK_MASK            1U
#define CAN0CTL1_SLPAK_MASK             2U
#define CAN0CTL1_WUPM_MASK              4U
#define CAN0CTL1_BORM_MASK              8U
#define CAN0CTL1_LISTEN_MASK            16U
#define CAN0CTL1_LOOPB_MASK             32U
#define CAN0CTL1_CLKSRC_MASK            64U
#define CAN0CTL1_CANE_MASK              128U


/*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN0BTR0STR;
extern volatile CAN0BTR0STR _CAN0BTR0 @(REG_BASE + 0x00000142UL);
#define CAN0BTR0                        _CAN0BTR0.Byte
#define CAN0BTR0_BRP0                   _CAN0BTR0.Bits.BRP0
#define CAN0BTR0_BRP1                   _CAN0BTR0.Bits.BRP1
#define CAN0BTR0_BRP2                   _CAN0BTR0.Bits.BRP2
#define CAN0BTR0_BRP3                   _CAN0BTR0.Bits.BRP3
#define CAN0BTR0_BRP4                   _CAN0BTR0.Bits.BRP4
#define CAN0BTR0_BRP5                   _CAN0BTR0.Bits.BRP5
#define CAN0BTR0_SJW0                   _CAN0BTR0.Bits.SJW0
#define CAN0BTR0_SJW1                   _CAN0BTR0.Bits.SJW1
/* CAN0BTR_ARR: Access 2 CAN0BTRx registers in an array */
#define CAN0BTR_ARR                     ((volatile byte *) &CAN0BTR0)
#define CAN0BTR0_BRP                    _CAN0BTR0.MergedBits.grpBRP
#define CAN0BTR0_SJW                    _CAN0BTR0.MergedBits.grpSJW

#define CAN0BTR0_BRP0_MASK              1U
#define CAN0BTR0_BRP1_MASK              2U
#define CAN0BTR0_BRP2_MASK              4U
#define CAN0BTR0_BRP3_MASK              8U
#define CAN0BTR0_BRP4_MASK              16U
#define CAN0BTR0_BRP5_MASK              32U
#define CAN0BTR0_SJW0_MASK              64U
#define CAN0BTR0_SJW1_MASK              128U
#define CAN0BTR0_BRP_MASK               63U
#define CAN0BTR0_BRP_BITNUM             0U
#define CAN0BTR0_SJW_MASK               192U
#define CAN0BTR0_SJW_BITNUM             6U


/*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN0BTR1STR;
extern volatile CAN0BTR1STR _CAN0BTR1 @(REG_BASE + 0x00000143UL);
#define CAN0BTR1                        _CAN0BTR1.Byte
#define CAN0BTR1_TSEG10                 _CAN0BTR1.Bits.TSEG10
#define CAN0BTR1_TSEG11                 _CAN0BTR1.Bits.TSEG11
#define CAN0BTR1_TSEG12                 _CAN0BTR1.Bits.TSEG12
#define CAN0BTR1_TSEG13                 _CAN0BTR1.Bits.TSEG13
#define CAN0BTR1_TSEG20                 _CAN0BTR1.Bits.TSEG20
#define CAN0BTR1_TSEG21                 _CAN0BTR1.Bits.TSEG21
#define CAN0BTR1_TSEG22                 _CAN0BTR1.Bits.TSEG22
#define CAN0BTR1_SAMP                   _CAN0BTR1.Bits.SAMP
#define CAN0BTR1_TSEG_10                _CAN0BTR1.MergedBits.grpTSEG_10
#define CAN0BTR1_TSEG_20                _CAN0BTR1.MergedBits.grpTSEG_20
#define CAN0BTR1_TSEG                   CAN0BTR1_TSEG_10

#define CAN0BTR1_TSEG10_MASK            1U
#define CAN0BTR1_TSEG11_MASK            2U
#define CAN0BTR1_TSEG12_MASK            4U
#define CAN0BTR1_TSEG13_MASK            8U
#define CAN0BTR1_TSEG20_MASK            16U
#define CAN0BTR1_TSEG21_MASK            32U
#define CAN0BTR1_TSEG22_MASK            64U
#define CAN0BTR1_SAMP_MASK              128U
#define CAN0BTR1_TSEG_10_MASK           15U
#define CAN0BTR1_TSEG_10_BITNUM         0U
#define CAN0BTR1_TSEG_20_MASK           112U
#define CAN0BTR1_TSEG_20_BITNUM         4U


/*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RFLGSTR;
extern volatile CAN0RFLGSTR _CAN0RFLG @(REG_BASE + 0x00000144UL);
#define CAN0RFLG                        _CAN0RFLG.Byte
#define CAN0RFLG_RXF                    _CAN0RFLG.Bits.RXF
#define CAN0RFLG_OVRIF                  _CAN0RFLG.Bits.OVRIF
#define CAN0RFLG_TSTAT0                 _CAN0RFLG.Bits.TSTAT0
#define CAN0RFLG_TSTAT1                 _CAN0RFLG.Bits.TSTAT1
#define CAN0RFLG_RSTAT0                 _CAN0RFLG.Bits.RSTAT0
#define CAN0RFLG_RSTAT1                 _CAN0RFLG.Bits.RSTAT1
#define CAN0RFLG_CSCIF                  _CAN0RFLG.Bits.CSCIF
#define CAN0RFLG_WUPIF                  _CAN0RFLG.Bits.WUPIF
#define CAN0RFLG_TSTAT                  _CAN0RFLG.MergedBits.grpTSTAT
#define CAN0RFLG_RSTAT                  _CAN0RFLG.MergedBits.grpRSTAT

#define CAN0RFLG_RXF_MASK               1U
#define CAN0RFLG_OVRIF_MASK             2U
#define CAN0RFLG_TSTAT0_MASK            4U
#define CAN0RFLG_TSTAT1_MASK            8U
#define CAN0RFLG_RSTAT0_MASK            16U
#define CAN0RFLG_RSTAT1_MASK            32U
#define CAN0RFLG_CSCIF_MASK             64U
#define CAN0RFLG_WUPIF_MASK             128U
#define CAN0RFLG_TSTAT_MASK             12U
#define CAN0RFLG_TSTAT_BITNUM           2U
#define CAN0RFLG_RSTAT_MASK             48U
#define CAN0RFLG_RSTAT_BITNUM           4U


/*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RIERSTR;
extern volatile CAN0RIERSTR _CAN0RIER @(REG_BASE + 0x00000145UL);
#define CAN0RIER                        _CAN0RIER.Byte
#define CAN0RIER_RXFIE                  _CAN0RIER.Bits.RXFIE
#define CAN0RIER_OVRIE                  _CAN0RIER.Bits.OVRIE
#define CAN0RIER_TSTATE0                _CAN0RIER.Bits.TSTATE0
#define CAN0RIER_TSTATE1                _CAN0RIER.Bits.TSTATE1
#define CAN0RIER_RSTATE0                _CAN0RIER.Bits.RSTATE0
#define CAN0RIER_RSTATE1                _CAN0RIER.Bits.RSTATE1
#define CAN0RIER_CSCIE                  _CAN0RIER.Bits.CSCIE
#define CAN0RIER_WUPIE                  _CAN0RIER.Bits.WUPIE
#define CAN0RIER_TSTATE                 _CAN0RIER.MergedBits.grpTSTATE
#define CAN0RIER_RSTATE                 _CAN0RIER.MergedBits.grpRSTATE

#define CAN0RIER_RXFIE_MASK             1U
#define CAN0RIER_OVRIE_MASK             2U
#define CAN0RIER_TSTATE0_MASK           4U
#define CAN0RIER_TSTATE1_MASK           8U
#define CAN0RIER_RSTATE0_MASK           16U
#define CAN0RIER_RSTATE1_MASK           32U
#define CAN0RIER_CSCIE_MASK             64U
#define CAN0RIER_WUPIE_MASK             128U
#define CAN0RIER_TSTATE_MASK            12U
#define CAN0RIER_TSTATE_BITNUM          2U
#define CAN0RIER_RSTATE_MASK            48U
#define CAN0RIER_RSTATE_BITNUM          4U


/*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TFLGSTR;
extern volatile CAN0TFLGSTR _CAN0TFLG @(REG_BASE + 0x00000146UL);
#define CAN0TFLG                        _CAN0TFLG.Byte
#define CAN0TFLG_TXE0                   _CAN0TFLG.Bits.TXE0
#define CAN0TFLG_TXE1                   _CAN0TFLG.Bits.TXE1
#define CAN0TFLG_TXE2                   _CAN0TFLG.Bits.TXE2
#define CAN0TFLG_TXE                    _CAN0TFLG.MergedBits.grpTXE

#define CAN0TFLG_TXE0_MASK              1U
#define CAN0TFLG_TXE1_MASK              2U
#define CAN0TFLG_TXE2_MASK              4U
#define CAN0TFLG_TXE_MASK               7U
#define CAN0TFLG_TXE_BITNUM             0U


/*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TIERSTR;
extern volatile CAN0TIERSTR _CAN0TIER @(REG_BASE + 0x00000147UL);
#define CAN0TIER                        _CAN0TIER.Byte
#define CAN0TIER_TXEIE0                 _CAN0TIER.Bits.TXEIE0
#define CAN0TIER_TXEIE1                 _CAN0TIER.Bits.TXEIE1
#define CAN0TIER_TXEIE2                 _CAN0TIER.Bits.TXEIE2
#define CAN0TIER_TXEIE                  _CAN0TIER.MergedBits.grpTXEIE

#define CAN0TIER_TXEIE0_MASK            1U
#define CAN0TIER_TXEIE1_MASK            2U
#define CAN0TIER_TXEIE2_MASK            4U
#define CAN0TIER_TXEIE_MASK             7U
#define CAN0TIER_TXEIE_BITNUM           0U


/*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TARQSTR;
extern volatile CAN0TARQSTR _CAN0TARQ @(REG_BASE + 0x00000148UL);
#define CAN0TARQ                        _CAN0TARQ.Byte
#define CAN0TARQ_ABTRQ0                 _CAN0TARQ.Bits.ABTRQ0
#define CAN0TARQ_ABTRQ1                 _CAN0TARQ.Bits.ABTRQ1
#define CAN0TARQ_ABTRQ2                 _CAN0TARQ.Bits.ABTRQ2
#define CAN0TARQ_ABTRQ                  _CAN0TARQ.MergedBits.grpABTRQ

#define CAN0TARQ_ABTRQ0_MASK            1U
#define CAN0TARQ_ABTRQ1_MASK            2U
#define CAN0TARQ_ABTRQ2_MASK            4U
#define CAN0TARQ_ABTRQ_MASK             7U
#define CAN0TARQ_ABTRQ_BITNUM           0U


/*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TAAKSTR;
extern volatile CAN0TAAKSTR _CAN0TAAK @(REG_BASE + 0x00000149UL);
#define CAN0TAAK                        _CAN0TAAK.Byte
#define CAN0TAAK_ABTAK0                 _CAN0TAAK.Bits.ABTAK0
#define CAN0TAAK_ABTAK1                 _CAN0TAAK.Bits.ABTAK1
#define CAN0TAAK_ABTAK2                 _CAN0TAAK.Bits.ABTAK2
#define CAN0TAAK_ABTAK                  _CAN0TAAK.MergedBits.grpABTAK

#define CAN0TAAK_ABTAK0_MASK            1U
#define CAN0TAAK_ABTAK1_MASK            2U
#define CAN0TAAK_ABTAK2_MASK            4U
#define CAN0TAAK_ABTAK_MASK             7U
#define CAN0TAAK_ABTAK_BITNUM           0U


/*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TBSELSTR;
extern volatile CAN0TBSELSTR _CAN0TBSEL @(REG_BASE + 0x0000014AUL);
#define CAN0TBSEL                       _CAN0TBSEL.Byte
#define CAN0TBSEL_TX0                   _CAN0TBSEL.Bits.TX0
#define CAN0TBSEL_TX1                   _CAN0TBSEL.Bits.TX1
#define CAN0TBSEL_TX2                   _CAN0TBSEL.Bits.TX2
#define CAN0TBSEL_TX                    _CAN0TBSEL.MergedBits.grpTX

#define CAN0TBSEL_TX0_MASK              1U
#define CAN0TBSEL_TX1_MASK              2U
#define CAN0TBSEL_TX2_MASK              4U
#define CAN0TBSEL_TX_MASK               7U
#define CAN0TBSEL_TX_BITNUM             0U


/*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0IDACSTR;
extern volatile CAN0IDACSTR _CAN0IDAC @(REG_BASE + 0x0000014BUL);
#define CAN0IDAC                        _CAN0IDAC.Byte
#define CAN0IDAC_IDHIT0                 _CAN0IDAC.Bits.IDHIT0
#define CAN0IDAC_IDHIT1                 _CAN0IDAC.Bits.IDHIT1
#define CAN0IDAC_IDHIT2                 _CAN0IDAC.Bits.IDHIT2
#define CAN0IDAC_IDAM0                  _CAN0IDAC.Bits.IDAM0
#define CAN0IDAC_IDAM1                  _CAN0IDAC.Bits.IDAM1
#define CAN0IDAC_IDHIT                  _CAN0IDAC.MergedBits.grpIDHIT
#define CAN0IDAC_IDAM                   _CAN0IDAC.MergedBits.grpIDAM

#define CAN0IDAC_IDHIT0_MASK            1U
#define CAN0IDAC_IDHIT1_MASK            2U
#define CAN0IDAC_IDHIT2_MASK            4U
#define CAN0IDAC_IDAM0_MASK             16U
#define CAN0IDAC_IDAM1_MASK             32U
#define CAN0IDAC_IDHIT_MASK             7U
#define CAN0IDAC_IDHIT_BITNUM           0U
#define CAN0IDAC_IDAM_MASK              48U
#define CAN0IDAC_IDAM_BITNUM            4U


/*** CAN0MISC - MSCAN 0 Miscellaneous Register; 0x0000014D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-Off state Hold until user request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN0MISCSTR;
extern volatile CAN0MISCSTR _CAN0MISC @(REG_BASE + 0x0000014DUL);
#define CAN0MISC                        _CAN0MISC.Byte
#define CAN0MISC_BOHOLD                 _CAN0MISC.Bits.BOHOLD

#define CAN0MISC_BOHOLD_MASK            1U


/*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0RXERRSTR;
extern volatile CAN0RXERRSTR _CAN0RXERR @(REG_BASE + 0x0000014EUL);
#define CAN0RXERR                       _CAN0RXERR.Byte
#define CAN0RXERR_RXERR0                _CAN0RXERR.Bits.RXERR0
#define CAN0RXERR_RXERR1                _CAN0RXERR.Bits.RXERR1
#define CAN0RXERR_RXERR2                _CAN0RXERR.Bits.RXERR2
#define CAN0RXERR_RXERR3                _CAN0RXERR.Bits.RXERR3
#define CAN0RXERR_RXERR4                _CAN0RXERR.Bits.RXERR4
#define CAN0RXERR_RXERR5                _CAN0RXERR.Bits.RXERR5
#define CAN0RXERR_RXERR6                _CAN0RXERR.Bits.RXERR6
#define CAN0RXERR_RXERR7                _CAN0RXERR.Bits.RXERR7

#define CAN0RXERR_RXERR0_MASK           1U
#define CAN0RXERR_RXERR1_MASK           2U
#define CAN0RXERR_RXERR2_MASK           4U
#define CAN0RXERR_RXERR3_MASK           8U
#define CAN0RXERR_RXERR4_MASK           16U
#define CAN0RXERR_RXERR5_MASK           32U
#define CAN0RXERR_RXERR6_MASK           64U
#define CAN0RXERR_RXERR7_MASK           128U


/*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0TXERRSTR;
extern volatile CAN0TXERRSTR _CAN0TXERR @(REG_BASE + 0x0000014FUL);
#define CAN0TXERR                       _CAN0TXERR.Byte
#define CAN0TXERR_TXERR0                _CAN0TXERR.Bits.TXERR0
#define CAN0TXERR_TXERR1                _CAN0TXERR.Bits.TXERR1
#define CAN0TXERR_TXERR2                _CAN0TXERR.Bits.TXERR2
#define CAN0TXERR_TXERR3                _CAN0TXERR.Bits.TXERR3
#define CAN0TXERR_TXERR4                _CAN0TXERR.Bits.TXERR4
#define CAN0TXERR_TXERR5                _CAN0TXERR.Bits.TXERR5
#define CAN0TXERR_TXERR6                _CAN0TXERR.Bits.TXERR6
#define CAN0TXERR_TXERR7                _CAN0TXERR.Bits.TXERR7

#define CAN0TXERR_TXERR0_MASK           1U
#define CAN0TXERR_TXERR1_MASK           2U
#define CAN0TXERR_TXERR2_MASK           4U
#define CAN0TXERR_TXERR3_MASK           8U
#define CAN0TXERR_TXERR4_MASK           16U
#define CAN0TXERR_TXERR5_MASK           32U
#define CAN0TXERR_TXERR6_MASK           64U
#define CAN0TXERR_TXERR7_MASK           128U


/*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR0STR;
extern volatile CAN0IDAR0STR _CAN0IDAR0 @(REG_BASE + 0x00000150UL);
#define CAN0IDAR0                       _CAN0IDAR0.Byte
#define CAN0IDAR0_AC0                   _CAN0IDAR0.Bits.AC0
#define CAN0IDAR0_AC1                   _CAN0IDAR0.Bits.AC1
#define CAN0IDAR0_AC2                   _CAN0IDAR0.Bits.AC2
#define CAN0IDAR0_AC3                   _CAN0IDAR0.Bits.AC3
#define CAN0IDAR0_AC4                   _CAN0IDAR0.Bits.AC4
#define CAN0IDAR0_AC5                   _CAN0IDAR0.Bits.AC5
#define CAN0IDAR0_AC6                   _CAN0IDAR0.Bits.AC6
#define CAN0IDAR0_AC7                   _CAN0IDAR0.Bits.AC7
/* CAN0IDAR_ARR: Access 4 CAN0IDARx registers in an array */
#define CAN0IDAR_ARR                    ((volatile byte *) &CAN0IDAR0)

#define CAN0IDAR0_AC0_MASK              1U
#define CAN0IDAR0_AC1_MASK              2U
#define CAN0IDAR0_AC2_MASK              4U
#define CAN0IDAR0_AC3_MASK              8U
#define CAN0IDAR0_AC4_MASK              16U
#define CAN0IDAR0_AC5_MASK              32U
#define CAN0IDAR0_AC6_MASK              64U
#define CAN0IDAR0_AC7_MASK              128U


/*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR1STR;
extern volatile CAN0IDAR1STR _CAN0IDAR1 @(REG_BASE + 0x00000151UL);
#define CAN0IDAR1                       _CAN0IDAR1.Byte
#define CAN0IDAR1_AC0                   _CAN0IDAR1.Bits.AC0
#define CAN0IDAR1_AC1                   _CAN0IDAR1.Bits.AC1
#define CAN0IDAR1_AC2                   _CAN0IDAR1.Bits.AC2
#define CAN0IDAR1_AC3                   _CAN0IDAR1.Bits.AC3
#define CAN0IDAR1_AC4                   _CAN0IDAR1.Bits.AC4
#define CAN0IDAR1_AC5                   _CAN0IDAR1.Bits.AC5
#define CAN0IDAR1_AC6                   _CAN0IDAR1.Bits.AC6
#define CAN0IDAR1_AC7                   _CAN0IDAR1.Bits.AC7

#define CAN0IDAR1_AC0_MASK              1U
#define CAN0IDAR1_AC1_MASK              2U
#define CAN0IDAR1_AC2_MASK              4U
#define CAN0IDAR1_AC3_MASK              8U
#define CAN0IDAR1_AC4_MASK              16U
#define CAN0IDAR1_AC5_MASK              32U
#define CAN0IDAR1_AC6_MASK              64U
#define CAN0IDAR1_AC7_MASK              128U


/*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR2STR;
extern volatile CAN0IDAR2STR _CAN0IDAR2 @(REG_BASE + 0x00000152UL);
#define CAN0IDAR2                       _CAN0IDAR2.Byte
#define CAN0IDAR2_AC0                   _CAN0IDAR2.Bits.AC0
#define CAN0IDAR2_AC1                   _CAN0IDAR2.Bits.AC1
#define CAN0IDAR2_AC2                   _CAN0IDAR2.Bits.AC2
#define CAN0IDAR2_AC3                   _CAN0IDAR2.Bits.AC3
#define CAN0IDAR2_AC4                   _CAN0IDAR2.Bits.AC4
#define CAN0IDAR2_AC5                   _CAN0IDAR2.Bits.AC5
#define CAN0IDAR2_AC6                   _CAN0IDAR2.Bits.AC6
#define CAN0IDAR2_AC7                   _CAN0IDAR2.Bits.AC7

#define CAN0IDAR2_AC0_MASK              1U
#define CAN0IDAR2_AC1_MASK              2U
#define CAN0IDAR2_AC2_MASK              4U
#define CAN0IDAR2_AC3_MASK              8U
#define CAN0IDAR2_AC4_MASK              16U
#define CAN0IDAR2_AC5_MASK              32U
#define CAN0IDAR2_AC6_MASK              64U
#define CAN0IDAR2_AC7_MASK              128U


/*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR3STR;
extern volatile CAN0IDAR3STR _CAN0IDAR3 @(REG_BASE + 0x00000153UL);
#define CAN0IDAR3                       _CAN0IDAR3.Byte
#define CAN0IDAR3_AC0                   _CAN0IDAR3.Bits.AC0
#define CAN0IDAR3_AC1                   _CAN0IDAR3.Bits.AC1
#define CAN0IDAR3_AC2                   _CAN0IDAR3.Bits.AC2
#define CAN0IDAR3_AC3                   _CAN0IDAR3.Bits.AC3
#define CAN0IDAR3_AC4                   _CAN0IDAR3.Bits.AC4
#define CAN0IDAR3_AC5                   _CAN0IDAR3.Bits.AC5
#define CAN0IDAR3_AC6                   _CAN0IDAR3.Bits.AC6
#define CAN0IDAR3_AC7                   _CAN0IDAR3.Bits.AC7

#define CAN0IDAR3_AC0_MASK              1U
#define CAN0IDAR3_AC1_MASK              2U
#define CAN0IDAR3_AC2_MASK              4U
#define CAN0IDAR3_AC3_MASK              8U
#define CAN0IDAR3_AC4_MASK              16U
#define CAN0IDAR3_AC5_MASK              32U
#define CAN0IDAR3_AC6_MASK              64U
#define CAN0IDAR3_AC7_MASK              128U


/*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR0STR;
extern volatile CAN0IDMR0STR _CAN0IDMR0 @(REG_BASE + 0x00000154UL);
#define CAN0IDMR0                       _CAN0IDMR0.Byte
#define CAN0IDMR0_AM0                   _CAN0IDMR0.Bits.AM0
#define CAN0IDMR0_AM1                   _CAN0IDMR0.Bits.AM1
#define CAN0IDMR0_AM2                   _CAN0IDMR0.Bits.AM2
#define CAN0IDMR0_AM3                   _CAN0IDMR0.Bits.AM3
#define CAN0IDMR0_AM4                   _CAN0IDMR0.Bits.AM4
#define CAN0IDMR0_AM5                   _CAN0IDMR0.Bits.AM5
#define CAN0IDMR0_AM6                   _CAN0IDMR0.Bits.AM6
#define CAN0IDMR0_AM7                   _CAN0IDMR0.Bits.AM7
/* CAN0IDMR_ARR: Access 4 CAN0IDMRx registers in an array */
#define CAN0IDMR_ARR                    ((volatile byte *) &CAN0IDMR0)

#define CAN0IDMR0_AM0_MASK              1U
#define CAN0IDMR0_AM1_MASK              2U
#define CAN0IDMR0_AM2_MASK              4U
#define CAN0IDMR0_AM3_MASK              8U
#define CAN0IDMR0_AM4_MASK              16U
#define CAN0IDMR0_AM5_MASK              32U
#define CAN0IDMR0_AM6_MASK              64U
#define CAN0IDMR0_AM7_MASK              128U


/*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR1STR;
extern volatile CAN0IDMR1STR _CAN0IDMR1 @(REG_BASE + 0x00000155UL);
#define CAN0IDMR1                       _CAN0IDMR1.Byte
#define CAN0IDMR1_AM0                   _CAN0IDMR1.Bits.AM0
#define CAN0IDMR1_AM1                   _CAN0IDMR1.Bits.AM1
#define CAN0IDMR1_AM2                   _CAN0IDMR1.Bits.AM2
#define CAN0IDMR1_AM3                   _CAN0IDMR1.Bits.AM3
#define CAN0IDMR1_AM4                   _CAN0IDMR1.Bits.AM4
#define CAN0IDMR1_AM5                   _CAN0IDMR1.Bits.AM5
#define CAN0IDMR1_AM6                   _CAN0IDMR1.Bits.AM6
#define CAN0IDMR1_AM7                   _CAN0IDMR1.Bits.AM7

#define CAN0IDMR1_AM0_MASK              1U
#define CAN0IDMR1_AM1_MASK              2U
#define CAN0IDMR1_AM2_MASK              4U
#define CAN0IDMR1_AM3_MASK              8U
#define CAN0IDMR1_AM4_MASK              16U
#define CAN0IDMR1_AM5_MASK              32U
#define CAN0IDMR1_AM6_MASK              64U
#define CAN0IDMR1_AM7_MASK              128U


/*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR2STR;
extern volatile CAN0IDMR2STR _CAN0IDMR2 @(REG_BASE + 0x00000156UL);
#define CAN0IDMR2                       _CAN0IDMR2.Byte
#define CAN0IDMR2_AM0                   _CAN0IDMR2.Bits.AM0
#define CAN0IDMR2_AM1                   _CAN0IDMR2.Bits.AM1
#define CAN0IDMR2_AM2                   _CAN0IDMR2.Bits.AM2
#define CAN0IDMR2_AM3                   _CAN0IDMR2.Bits.AM3
#define CAN0IDMR2_AM4                   _CAN0IDMR2.Bits.AM4
#define CAN0IDMR2_AM5                   _CAN0IDMR2.Bits.AM5
#define CAN0IDMR2_AM6                   _CAN0IDMR2.Bits.AM6
#define CAN0IDMR2_AM7                   _CAN0IDMR2.Bits.AM7

#define CAN0IDMR2_AM0_MASK              1U
#define CAN0IDMR2_AM1_MASK              2U
#define CAN0IDMR2_AM2_MASK              4U
#define CAN0IDMR2_AM3_MASK              8U
#define CAN0IDMR2_AM4_MASK              16U
#define CAN0IDMR2_AM5_MASK              32U
#define CAN0IDMR2_AM6_MASK              64U
#define CAN0IDMR2_AM7_MASK              128U


/*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR3STR;
extern volatile CAN0IDMR3STR _CAN0IDMR3 @(REG_BASE + 0x00000157UL);
#define CAN0IDMR3                       _CAN0IDMR3.Byte
#define CAN0IDMR3_AM0                   _CAN0IDMR3.Bits.AM0
#define CAN0IDMR3_AM1                   _CAN0IDMR3.Bits.AM1
#define CAN0IDMR3_AM2                   _CAN0IDMR3.Bits.AM2
#define CAN0IDMR3_AM3                   _CAN0IDMR3.Bits.AM3
#define CAN0IDMR3_AM4                   _CAN0IDMR3.Bits.AM4
#define CAN0IDMR3_AM5                   _CAN0IDMR3.Bits.AM5
#define CAN0IDMR3_AM6                   _CAN0IDMR3.Bits.AM6
#define CAN0IDMR3_AM7                   _CAN0IDMR3.Bits.AM7

#define CAN0IDMR3_AM0_MASK              1U
#define CAN0IDMR3_AM1_MASK              2U
#define CAN0IDMR3_AM2_MASK              4U
#define CAN0IDMR3_AM3_MASK              8U
#define CAN0IDMR3_AM4_MASK              16U
#define CAN0IDMR3_AM5_MASK              32U
#define CAN0IDMR3_AM6_MASK              64U
#define CAN0IDMR3_AM7_MASK              128U


/*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR4STR;
extern volatile CAN0IDAR4STR _CAN0IDAR4 @(REG_BASE + 0x00000158UL);
#define CAN0IDAR4                       _CAN0IDAR4.Byte
#define CAN0IDAR4_AC0                   _CAN0IDAR4.Bits.AC0
#define CAN0IDAR4_AC1                   _CAN0IDAR4.Bits.AC1
#define CAN0IDAR4_AC2                   _CAN0IDAR4.Bits.AC2
#define CAN0IDAR4_AC3                   _CAN0IDAR4.Bits.AC3
#define CAN0IDAR4_AC4                   _CAN0IDAR4.Bits.AC4
#define CAN0IDAR4_AC5                   _CAN0IDAR4.Bits.AC5
#define CAN0IDAR4_AC6                   _CAN0IDAR4.Bits.AC6
#define CAN0IDAR4_AC7                   _CAN0IDAR4.Bits.AC7

#define CAN0IDAR4_AC0_MASK              1U
#define CAN0IDAR4_AC1_MASK              2U
#define CAN0IDAR4_AC2_MASK              4U
#define CAN0IDAR4_AC3_MASK              8U
#define CAN0IDAR4_AC4_MASK              16U
#define CAN0IDAR4_AC5_MASK              32U
#define CAN0IDAR4_AC6_MASK              64U
#define CAN0IDAR4_AC7_MASK              128U


/*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR5STR;
extern volatile CAN0IDAR5STR _CAN0IDAR5 @(REG_BASE + 0x00000159UL);
#define CAN0IDAR5                       _CAN0IDAR5.Byte
#define CAN0IDAR5_AC0                   _CAN0IDAR5.Bits.AC0
#define CAN0IDAR5_AC1                   _CAN0IDAR5.Bits.AC1
#define CAN0IDAR5_AC2                   _CAN0IDAR5.Bits.AC2
#define CAN0IDAR5_AC3                   _CAN0IDAR5.Bits.AC3
#define CAN0IDAR5_AC4                   _CAN0IDAR5.Bits.AC4
#define CAN0IDAR5_AC5                   _CAN0IDAR5.Bits.AC5
#define CAN0IDAR5_AC6                   _CAN0IDAR5.Bits.AC6
#define CAN0IDAR5_AC7                   _CAN0IDAR5.Bits.AC7

#define CAN0IDAR5_AC0_MASK              1U
#define CAN0IDAR5_AC1_MASK              2U
#define CAN0IDAR5_AC2_MASK              4U
#define CAN0IDAR5_AC3_MASK              8U
#define CAN0IDAR5_AC4_MASK              16U
#define CAN0IDAR5_AC5_MASK              32U
#define CAN0IDAR5_AC6_MASK              64U
#define CAN0IDAR5_AC7_MASK              128U


/*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR6STR;
extern volatile CAN0IDAR6STR _CAN0IDAR6 @(REG_BASE + 0x0000015AUL);
#define CAN0IDAR6                       _CAN0IDAR6.Byte
#define CAN0IDAR6_AC0                   _CAN0IDAR6.Bits.AC0
#define CAN0IDAR6_AC1                   _CAN0IDAR6.Bits.AC1
#define CAN0IDAR6_AC2                   _CAN0IDAR6.Bits.AC2
#define CAN0IDAR6_AC3                   _CAN0IDAR6.Bits.AC3
#define CAN0IDAR6_AC4                   _CAN0IDAR6.Bits.AC4
#define CAN0IDAR6_AC5                   _CAN0IDAR6.Bits.AC5
#define CAN0IDAR6_AC6                   _CAN0IDAR6.Bits.AC6
#define CAN0IDAR6_AC7                   _CAN0IDAR6.Bits.AC7

#define CAN0IDAR6_AC0_MASK              1U
#define CAN0IDAR6_AC1_MASK              2U
#define CAN0IDAR6_AC2_MASK              4U
#define CAN0IDAR6_AC3_MASK              8U
#define CAN0IDAR6_AC4_MASK              16U
#define CAN0IDAR6_AC5_MASK              32U
#define CAN0IDAR6_AC6_MASK              64U
#define CAN0IDAR6_AC7_MASK              128U


/*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR7STR;
extern volatile CAN0IDAR7STR _CAN0IDAR7 @(REG_BASE + 0x0000015BUL);
#define CAN0IDAR7                       _CAN0IDAR7.Byte
#define CAN0IDAR7_AC0                   _CAN0IDAR7.Bits.AC0
#define CAN0IDAR7_AC1                   _CAN0IDAR7.Bits.AC1
#define CAN0IDAR7_AC2                   _CAN0IDAR7.Bits.AC2
#define CAN0IDAR7_AC3                   _CAN0IDAR7.Bits.AC3
#define CAN0IDAR7_AC4                   _CAN0IDAR7.Bits.AC4
#define CAN0IDAR7_AC5                   _CAN0IDAR7.Bits.AC5
#define CAN0IDAR7_AC6                   _CAN0IDAR7.Bits.AC6
#define CAN0IDAR7_AC7                   _CAN0IDAR7.Bits.AC7

#define CAN0IDAR7_AC0_MASK              1U
#define CAN0IDAR7_AC1_MASK              2U
#define CAN0IDAR7_AC2_MASK              4U
#define CAN0IDAR7_AC3_MASK              8U
#define CAN0IDAR7_AC4_MASK              16U
#define CAN0IDAR7_AC5_MASK              32U
#define CAN0IDAR7_AC6_MASK              64U
#define CAN0IDAR7_AC7_MASK              128U


/*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR4STR;
extern volatile CAN0IDMR4STR _CAN0IDMR4 @(REG_BASE + 0x0000015CUL);
#define CAN0IDMR4                       _CAN0IDMR4.Byte
#define CAN0IDMR4_AM0                   _CAN0IDMR4.Bits.AM0
#define CAN0IDMR4_AM1                   _CAN0IDMR4.Bits.AM1
#define CAN0IDMR4_AM2                   _CAN0IDMR4.Bits.AM2
#define CAN0IDMR4_AM3                   _CAN0IDMR4.Bits.AM3
#define CAN0IDMR4_AM4                   _CAN0IDMR4.Bits.AM4
#define CAN0IDMR4_AM5                   _CAN0IDMR4.Bits.AM5
#define CAN0IDMR4_AM6                   _CAN0IDMR4.Bits.AM6
#define CAN0IDMR4_AM7                   _CAN0IDMR4.Bits.AM7

#define CAN0IDMR4_AM0_MASK              1U
#define CAN0IDMR4_AM1_MASK              2U
#define CAN0IDMR4_AM2_MASK              4U
#define CAN0IDMR4_AM3_MASK              8U
#define CAN0IDMR4_AM4_MASK              16U
#define CAN0IDMR4_AM5_MASK              32U
#define CAN0IDMR4_AM6_MASK              64U
#define CAN0IDMR4_AM7_MASK              128U


/*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR5STR;
extern volatile CAN0IDMR5STR _CAN0IDMR5 @(REG_BASE + 0x0000015DUL);
#define CAN0IDMR5                       _CAN0IDMR5.Byte
#define CAN0IDMR5_AM0                   _CAN0IDMR5.Bits.AM0
#define CAN0IDMR5_AM1                   _CAN0IDMR5.Bits.AM1
#define CAN0IDMR5_AM2                   _CAN0IDMR5.Bits.AM2
#define CAN0IDMR5_AM3                   _CAN0IDMR5.Bits.AM3
#define CAN0IDMR5_AM4                   _CAN0IDMR5.Bits.AM4
#define CAN0IDMR5_AM5                   _CAN0IDMR5.Bits.AM5
#define CAN0IDMR5_AM6                   _CAN0IDMR5.Bits.AM6
#define CAN0IDMR5_AM7                   _CAN0IDMR5.Bits.AM7

#define CAN0IDMR5_AM0_MASK              1U
#define CAN0IDMR5_AM1_MASK              2U
#define CAN0IDMR5_AM2_MASK              4U
#define CAN0IDMR5_AM3_MASK              8U
#define CAN0IDMR5_AM4_MASK              16U
#define CAN0IDMR5_AM5_MASK              32U
#define CAN0IDMR5_AM6_MASK              64U
#define CAN0IDMR5_AM7_MASK              128U


/*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR6STR;
extern volatile CAN0IDMR6STR _CAN0IDMR6 @(REG_BASE + 0x0000015EUL);
#define CAN0IDMR6                       _CAN0IDMR6.Byte
#define CAN0IDMR6_AM0                   _CAN0IDMR6.Bits.AM0
#define CAN0IDMR6_AM1                   _CAN0IDMR6.Bits.AM1
#define CAN0IDMR6_AM2                   _CAN0IDMR6.Bits.AM2
#define CAN0IDMR6_AM3                   _CAN0IDMR6.Bits.AM3
#define CAN0IDMR6_AM4                   _CAN0IDMR6.Bits.AM4
#define CAN0IDMR6_AM5                   _CAN0IDMR6.Bits.AM5
#define CAN0IDMR6_AM6                   _CAN0IDMR6.Bits.AM6
#define CAN0IDMR6_AM7                   _CAN0IDMR6.Bits.AM7

#define CAN0IDMR6_AM0_MASK              1U
#define CAN0IDMR6_AM1_MASK              2U
#define CAN0IDMR6_AM2_MASK              4U
#define CAN0IDMR6_AM3_MASK              8U
#define CAN0IDMR6_AM4_MASK              16U
#define CAN0IDMR6_AM5_MASK              32U
#define CAN0IDMR6_AM6_MASK              64U
#define CAN0IDMR6_AM7_MASK              128U


/*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR7STR;
extern volatile CAN0IDMR7STR _CAN0IDMR7 @(REG_BASE + 0x0000015FUL);
#define CAN0IDMR7                       _CAN0IDMR7.Byte
#define CAN0IDMR7_AM0                   _CAN0IDMR7.Bits.AM0
#define CAN0IDMR7_AM1                   _CAN0IDMR7.Bits.AM1
#define CAN0IDMR7_AM2                   _CAN0IDMR7.Bits.AM2
#define CAN0IDMR7_AM3                   _CAN0IDMR7.Bits.AM3
#define CAN0IDMR7_AM4                   _CAN0IDMR7.Bits.AM4
#define CAN0IDMR7_AM5                   _CAN0IDMR7.Bits.AM5
#define CAN0IDMR7_AM6                   _CAN0IDMR7.Bits.AM6
#define CAN0IDMR7_AM7                   _CAN0IDMR7.Bits.AM7

#define CAN0IDMR7_AM0_MASK              1U
#define CAN0IDMR7_AM1_MASK              2U
#define CAN0IDMR7_AM2_MASK              4U
#define CAN0IDMR7_AM3_MASK              8U
#define CAN0IDMR7_AM4_MASK              16U
#define CAN0IDMR7_AM5_MASK              32U
#define CAN0IDMR7_AM6_MASK              64U
#define CAN0IDMR7_AM7_MASK              128U


/*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0RXIDR0STR;
extern volatile CAN0RXIDR0STR _CAN0RXIDR0 @(REG_BASE + 0x00000160UL);
#define CAN0RXIDR0                      _CAN0RXIDR0.Byte
#define CAN0RXIDR0_ID21                 _CAN0RXIDR0.Bits.ID21
#define CAN0RXIDR0_ID22                 _CAN0RXIDR0.Bits.ID22
#define CAN0RXIDR0_ID23                 _CAN0RXIDR0.Bits.ID23
#define CAN0RXIDR0_ID24                 _CAN0RXIDR0.Bits.ID24
#define CAN0RXIDR0_ID25                 _CAN0RXIDR0.Bits.ID25
#define CAN0RXIDR0_ID26                 _CAN0RXIDR0.Bits.ID26
#define CAN0RXIDR0_ID27                 _CAN0RXIDR0.Bits.ID27
#define CAN0RXIDR0_ID28                 _CAN0RXIDR0.Bits.ID28
/* CAN0RXIDR_ARR: Access 4 CAN0RXIDRx registers in an array */
#define CAN0RXIDR_ARR                   ((volatile byte *) &CAN0RXIDR0)

#define CAN0RXIDR0_ID21_MASK            1U
#define CAN0RXIDR0_ID22_MASK            2U
#define CAN0RXIDR0_ID23_MASK            4U
#define CAN0RXIDR0_ID24_MASK            8U
#define CAN0RXIDR0_ID25_MASK            16U
#define CAN0RXIDR0_ID26_MASK            32U
#define CAN0RXIDR0_ID27_MASK            64U
#define CAN0RXIDR0_ID28_MASK            128U


/*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0RXIDR1STR;
extern volatile CAN0RXIDR1STR _CAN0RXIDR1 @(REG_BASE + 0x00000161UL);
#define CAN0RXIDR1                      _CAN0RXIDR1.Byte
#define CAN0RXIDR1_ID15                 _CAN0RXIDR1.Bits.ID15
#define CAN0RXIDR1_ID16                 _CAN0RXIDR1.Bits.ID16
#define CAN0RXIDR1_ID17                 _CAN0RXIDR1.Bits.ID17
#define CAN0RXIDR1_IDE                  _CAN0RXIDR1.Bits.IDE
#define CAN0RXIDR1_SRR                  _CAN0RXIDR1.Bits.SRR
#define CAN0RXIDR1_ID18                 _CAN0RXIDR1.Bits.ID18
#define CAN0RXIDR1_ID19                 _CAN0RXIDR1.Bits.ID19
#define CAN0RXIDR1_ID20                 _CAN0RXIDR1.Bits.ID20
#define CAN0RXIDR1_ID_15                _CAN0RXIDR1.MergedBits.grpID_15
#define CAN0RXIDR1_ID_18                _CAN0RXIDR1.MergedBits.grpID_18
#define CAN0RXIDR1_ID                   CAN0RXIDR1_ID_15

#define CAN0RXIDR1_ID15_MASK            1U
#define CAN0RXIDR1_ID16_MASK            2U
#define CAN0RXIDR1_ID17_MASK            4U
#define CAN0RXIDR1_IDE_MASK             8U
#define CAN0RXIDR1_SRR_MASK             16U
#define CAN0RXIDR1_ID18_MASK            32U
#define CAN0RXIDR1_ID19_MASK            64U
#define CAN0RXIDR1_ID20_MASK            128U
#define CAN0RXIDR1_ID_15_MASK           7U
#define CAN0RXIDR1_ID_15_BITNUM         0U
#define CAN0RXIDR1_ID_18_MASK           224U
#define CAN0RXIDR1_ID_18_BITNUM         5U


/*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0RXIDR2STR;
extern volatile CAN0RXIDR2STR _CAN0RXIDR2 @(REG_BASE + 0x00000162UL);
#define CAN0RXIDR2                      _CAN0RXIDR2.Byte
#define CAN0RXIDR2_ID7                  _CAN0RXIDR2.Bits.ID7
#define CAN0RXIDR2_ID8                  _CAN0RXIDR2.Bits.ID8
#define CAN0RXIDR2_ID9                  _CAN0RXIDR2.Bits.ID9
#define CAN0RXIDR2_ID10                 _CAN0RXIDR2.Bits.ID10
#define CAN0RXIDR2_ID11                 _CAN0RXIDR2.Bits.ID11
#define CAN0RXIDR2_ID12                 _CAN0RXIDR2.Bits.ID12
#define CAN0RXIDR2_ID13                 _CAN0RXIDR2.Bits.ID13
#define CAN0RXIDR2_ID14                 _CAN0RXIDR2.Bits.ID14

#define CAN0RXIDR2_ID7_MASK             1U
#define CAN0RXIDR2_ID8_MASK             2U
#define CAN0RXIDR2_ID9_MASK             4U
#define CAN0RXIDR2_ID10_MASK            8U
#define CAN0RXIDR2_ID11_MASK            16U
#define CAN0RXIDR2_ID12_MASK            32U
#define CAN0RXIDR2_ID13_MASK            64U
#define CAN0RXIDR2_ID14_MASK            128U


/*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0RXIDR3STR;
extern volatile CAN0RXIDR3STR _CAN0RXIDR3 @(REG_BASE + 0x00000163UL);
#define CAN0RXIDR3                      _CAN0RXIDR3.Byte
#define CAN0RXIDR3_RTR                  _CAN0RXIDR3.Bits.RTR
#define CAN0RXIDR3_ID0                  _CAN0RXIDR3.Bits.ID0
#define CAN0RXIDR3_ID1                  _CAN0RXIDR3.Bits.ID1
#define CAN0RXIDR3_ID2                  _CAN0RXIDR3.Bits.ID2
#define CAN0RXIDR3_ID3                  _CAN0RXIDR3.Bits.ID3
#define CAN0RXIDR3_ID4                  _CAN0RXIDR3.Bits.ID4
#define CAN0RXIDR3_ID5                  _CAN0RXIDR3.Bits.ID5
#define CAN0RXIDR3_ID6                  _CAN0RXIDR3.Bits.ID6
#define CAN0RXIDR3_ID                   _CAN0RXIDR3.MergedBits.grpID

#define CAN0RXIDR3_RTR_MASK             1U
#define CAN0RXIDR3_ID0_MASK             2U
#define CAN0RXIDR3_ID1_MASK             4U
#define CAN0RXIDR3_ID2_MASK             8U
#define CAN0RXIDR3_ID3_MASK             16U
#define CAN0RXIDR3_ID4_MASK             32U
#define CAN0RXIDR3_ID5_MASK             64U
#define CAN0RXIDR3_ID6_MASK             128U
#define CAN0RXIDR3_ID_MASK              254U
#define CAN0RXIDR3_ID_BITNUM            1U


/*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR0STR;
extern volatile CAN0RXDSR0STR _CAN0RXDSR0 @(REG_BASE + 0x00000164UL);
#define CAN0RXDSR0                      _CAN0RXDSR0.Byte
#define CAN0RXDSR0_DB0                  _CAN0RXDSR0.Bits.DB0
#define CAN0RXDSR0_DB1                  _CAN0RXDSR0.Bits.DB1
#define CAN0RXDSR0_DB2                  _CAN0RXDSR0.Bits.DB2
#define CAN0RXDSR0_DB3                  _CAN0RXDSR0.Bits.DB3
#define CAN0RXDSR0_DB4                  _CAN0RXDSR0.Bits.DB4
#define CAN0RXDSR0_DB5                  _CAN0RXDSR0.Bits.DB5
#define CAN0RXDSR0_DB6                  _CAN0RXDSR0.Bits.DB6
#define CAN0RXDSR0_DB7                  _CAN0RXDSR0.Bits.DB7
/* CAN0RXDSR_ARR: Access 8 CAN0RXDSRx registers in an array */
#define CAN0RXDSR_ARR                   ((volatile byte *) &CAN0RXDSR0)

#define CAN0RXDSR0_DB0_MASK             1U
#define CAN0RXDSR0_DB1_MASK             2U
#define CAN0RXDSR0_DB2_MASK             4U
#define CAN0RXDSR0_DB3_MASK             8U
#define CAN0RXDSR0_DB4_MASK             16U
#define CAN0RXDSR0_DB5_MASK             32U
#define CAN0RXDSR0_DB6_MASK             64U
#define CAN0RXDSR0_DB7_MASK             128U


/*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR1STR;
extern volatile CAN0RXDSR1STR _CAN0RXDSR1 @(REG_BASE + 0x00000165UL);
#define CAN0RXDSR1                      _CAN0RXDSR1.Byte
#define CAN0RXDSR1_DB0                  _CAN0RXDSR1.Bits.DB0
#define CAN0RXDSR1_DB1                  _CAN0RXDSR1.Bits.DB1
#define CAN0RXDSR1_DB2                  _CAN0RXDSR1.Bits.DB2
#define CAN0RXDSR1_DB3                  _CAN0RXDSR1.Bits.DB3
#define CAN0RXDSR1_DB4                  _CAN0RXDSR1.Bits.DB4
#define CAN0RXDSR1_DB5                  _CAN0RXDSR1.Bits.DB5
#define CAN0RXDSR1_DB6                  _CAN0RXDSR1.Bits.DB6
#define CAN0RXDSR1_DB7                  _CAN0RXDSR1.Bits.DB7

#define CAN0RXDSR1_DB0_MASK             1U
#define CAN0RXDSR1_DB1_MASK             2U
#define CAN0RXDSR1_DB2_MASK             4U
#define CAN0RXDSR1_DB3_MASK             8U
#define CAN0RXDSR1_DB4_MASK             16U
#define CAN0RXDSR1_DB5_MASK             32U
#define CAN0RXDSR1_DB6_MASK             64U
#define CAN0RXDSR1_DB7_MASK             128U


/*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR2STR;
extern volatile CAN0RXDSR2STR _CAN0RXDSR2 @(REG_BASE + 0x00000166UL);
#define CAN0RXDSR2                      _CAN0RXDSR2.Byte
#define CAN0RXDSR2_DB0                  _CAN0RXDSR2.Bits.DB0
#define CAN0RXDSR2_DB1                  _CAN0RXDSR2.Bits.DB1
#define CAN0RXDSR2_DB2                  _CAN0RXDSR2.Bits.DB2
#define CAN0RXDSR2_DB3                  _CAN0RXDSR2.Bits.DB3
#define CAN0RXDSR2_DB4                  _CAN0RXDSR2.Bits.DB4
#define CAN0RXDSR2_DB5                  _CAN0RXDSR2.Bits.DB5
#define CAN0RXDSR2_DB6                  _CAN0RXDSR2.Bits.DB6
#define CAN0RXDSR2_DB7                  _CAN0RXDSR2.Bits.DB7

#define CAN0RXDSR2_DB0_MASK             1U
#define CAN0RXDSR2_DB1_MASK             2U
#define CAN0RXDSR2_DB2_MASK             4U
#define CAN0RXDSR2_DB3_MASK             8U
#define CAN0RXDSR2_DB4_MASK             16U
#define CAN0RXDSR2_DB5_MASK             32U
#define CAN0RXDSR2_DB6_MASK             64U
#define CAN0RXDSR2_DB7_MASK             128U


/*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR3STR;
extern volatile CAN0RXDSR3STR _CAN0RXDSR3 @(REG_BASE + 0x00000167UL);
#define CAN0RXDSR3                      _CAN0RXDSR3.Byte
#define CAN0RXDSR3_DB0                  _CAN0RXDSR3.Bits.DB0
#define CAN0RXDSR3_DB1                  _CAN0RXDSR3.Bits.DB1
#define CAN0RXDSR3_DB2                  _CAN0RXDSR3.Bits.DB2
#define CAN0RXDSR3_DB3                  _CAN0RXDSR3.Bits.DB3
#define CAN0RXDSR3_DB4                  _CAN0RXDSR3.Bits.DB4
#define CAN0RXDSR3_DB5                  _CAN0RXDSR3.Bits.DB5
#define CAN0RXDSR3_DB6                  _CAN0RXDSR3.Bits.DB6
#define CAN0RXDSR3_DB7                  _CAN0RXDSR3.Bits.DB7

#define CAN0RXDSR3_DB0_MASK             1U
#define CAN0RXDSR3_DB1_MASK             2U
#define CAN0RXDSR3_DB2_MASK             4U
#define CAN0RXDSR3_DB3_MASK             8U
#define CAN0RXDSR3_DB4_MASK             16U
#define CAN0RXDSR3_DB5_MASK             32U
#define CAN0RXDSR3_DB6_MASK             64U
#define CAN0RXDSR3_DB7_MASK             128U


/*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR4STR;
extern volatile CAN0RXDSR4STR _CAN0RXDSR4 @(REG_BASE + 0x00000168UL);
#define CAN0RXDSR4                      _CAN0RXDSR4.Byte
#define CAN0RXDSR4_DB0                  _CAN0RXDSR4.Bits.DB0
#define CAN0RXDSR4_DB1                  _CAN0RXDSR4.Bits.DB1
#define CAN0RXDSR4_DB2                  _CAN0RXDSR4.Bits.DB2
#define CAN0RXDSR4_DB3                  _CAN0RXDSR4.Bits.DB3
#define CAN0RXDSR4_DB4                  _CAN0RXDSR4.Bits.DB4
#define CAN0RXDSR4_DB5                  _CAN0RXDSR4.Bits.DB5
#define CAN0RXDSR4_DB6                  _CAN0RXDSR4.Bits.DB6
#define CAN0RXDSR4_DB7                  _CAN0RXDSR4.Bits.DB7

#define CAN0RXDSR4_DB0_MASK             1U
#define CAN0RXDSR4_DB1_MASK             2U
#define CAN0RXDSR4_DB2_MASK             4U
#define CAN0RXDSR4_DB3_MASK             8U
#define CAN0RXDSR4_DB4_MASK             16U
#define CAN0RXDSR4_DB5_MASK             32U
#define CAN0RXDSR4_DB6_MASK             64U
#define CAN0RXDSR4_DB7_MASK             128U


/*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR5STR;
extern volatile CAN0RXDSR5STR _CAN0RXDSR5 @(REG_BASE + 0x00000169UL);
#define CAN0RXDSR5                      _CAN0RXDSR5.Byte
#define CAN0RXDSR5_DB0                  _CAN0RXDSR5.Bits.DB0
#define CAN0RXDSR5_DB1                  _CAN0RXDSR5.Bits.DB1
#define CAN0RXDSR5_DB2                  _CAN0RXDSR5.Bits.DB2
#define CAN0RXDSR5_DB3                  _CAN0RXDSR5.Bits.DB3
#define CAN0RXDSR5_DB4                  _CAN0RXDSR5.Bits.DB4
#define CAN0RXDSR5_DB5                  _CAN0RXDSR5.Bits.DB5
#define CAN0RXDSR5_DB6                  _CAN0RXDSR5.Bits.DB6
#define CAN0RXDSR5_DB7                  _CAN0RXDSR5.Bits.DB7

#define CAN0RXDSR5_DB0_MASK             1U
#define CAN0RXDSR5_DB1_MASK             2U
#define CAN0RXDSR5_DB2_MASK             4U
#define CAN0RXDSR5_DB3_MASK             8U
#define CAN0RXDSR5_DB4_MASK             16U
#define CAN0RXDSR5_DB5_MASK             32U
#define CAN0RXDSR5_DB6_MASK             64U
#define CAN0RXDSR5_DB7_MASK             128U


/*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR6STR;
extern volatile CAN0RXDSR6STR _CAN0RXDSR6 @(REG_BASE + 0x0000016AUL);
#define CAN0RXDSR6                      _CAN0RXDSR6.Byte
#define CAN0RXDSR6_DB0                  _CAN0RXDSR6.Bits.DB0
#define CAN0RXDSR6_DB1                  _CAN0RXDSR6.Bits.DB1
#define CAN0RXDSR6_DB2                  _CAN0RXDSR6.Bits.DB2
#define CAN0RXDSR6_DB3                  _CAN0RXDSR6.Bits.DB3
#define CAN0RXDSR6_DB4                  _CAN0RXDSR6.Bits.DB4
#define CAN0RXDSR6_DB5                  _CAN0RXDSR6.Bits.DB5
#define CAN0RXDSR6_DB6                  _CAN0RXDSR6.Bits.DB6
#define CAN0RXDSR6_DB7                  _CAN0RXDSR6.Bits.DB7

#define CAN0RXDSR6_DB0_MASK             1U
#define CAN0RXDSR6_DB1_MASK             2U
#define CAN0RXDSR6_DB2_MASK             4U
#define CAN0RXDSR6_DB3_MASK             8U
#define CAN0RXDSR6_DB4_MASK             16U
#define CAN0RXDSR6_DB5_MASK             32U
#define CAN0RXDSR6_DB6_MASK             64U
#define CAN0RXDSR6_DB7_MASK             128U


/*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR7STR;
extern volatile CAN0RXDSR7STR _CAN0RXDSR7 @(REG_BASE + 0x0000016BUL);
#define CAN0RXDSR7                      _CAN0RXDSR7.Byte
#define CAN0RXDSR7_DB0                  _CAN0RXDSR7.Bits.DB0
#define CAN0RXDSR7_DB1                  _CAN0RXDSR7.Bits.DB1
#define CAN0RXDSR7_DB2                  _CAN0RXDSR7.Bits.DB2
#define CAN0RXDSR7_DB3                  _CAN0RXDSR7.Bits.DB3
#define CAN0RXDSR7_DB4                  _CAN0RXDSR7.Bits.DB4
#define CAN0RXDSR7_DB5                  _CAN0RXDSR7.Bits.DB5
#define CAN0RXDSR7_DB6                  _CAN0RXDSR7.Bits.DB6
#define CAN0RXDSR7_DB7                  _CAN0RXDSR7.Bits.DB7

#define CAN0RXDSR7_DB0_MASK             1U
#define CAN0RXDSR7_DB1_MASK             2U
#define CAN0RXDSR7_DB2_MASK             4U
#define CAN0RXDSR7_DB3_MASK             8U
#define CAN0RXDSR7_DB4_MASK             16U
#define CAN0RXDSR7_DB5_MASK             32U
#define CAN0RXDSR7_DB6_MASK             64U
#define CAN0RXDSR7_DB7_MASK             128U


/*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RXDLRSTR;
extern volatile CAN0RXDLRSTR _CAN0RXDLR @(REG_BASE + 0x0000016CUL);
#define CAN0RXDLR                       _CAN0RXDLR.Byte
#define CAN0RXDLR_DLC0                  _CAN0RXDLR.Bits.DLC0
#define CAN0RXDLR_DLC1                  _CAN0RXDLR.Bits.DLC1
#define CAN0RXDLR_DLC2                  _CAN0RXDLR.Bits.DLC2
#define CAN0RXDLR_DLC3                  _CAN0RXDLR.Bits.DLC3
#define CAN0RXDLR_DLC                   _CAN0RXDLR.MergedBits.grpDLC

#define CAN0RXDLR_DLC0_MASK             1U
#define CAN0RXDLR_DLC1_MASK             2U
#define CAN0RXDLR_DLC2_MASK             4U
#define CAN0RXDLR_DLC3_MASK             8U
#define CAN0RXDLR_DLC_MASK              15U
#define CAN0RXDLR_DLC_BITNUM            0U


/*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0RXTSRHSTR;
    #define CAN0RXTSRH                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Byte
    #define CAN0RXTSRH_TSR8             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR8
    #define CAN0RXTSRH_TSR9             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR9
    #define CAN0RXTSRH_TSR10            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR10
    #define CAN0RXTSRH_TSR11            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR11
    #define CAN0RXTSRH_TSR12            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR12
    #define CAN0RXTSRH_TSR13            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR13
    #define CAN0RXTSRH_TSR14            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR14
    #define CAN0RXTSRH_TSR15            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR15
    
    #define CAN0RXTSRH_TSR8_MASK        1U
    #define CAN0RXTSRH_TSR9_MASK        2U
    #define CAN0RXTSRH_TSR10_MASK       4U
    #define CAN0RXTSRH_TSR11_MASK       8U
    #define CAN0RXTSRH_TSR12_MASK       16U
    #define CAN0RXTSRH_TSR13_MASK       32U
    #define CAN0RXTSRH_TSR14_MASK       64U
    #define CAN0RXTSRH_TSR15_MASK       128U
    

    /*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0RXTSRLSTR;
    #define CAN0RXTSRL                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Byte
    #define CAN0RXTSRL_TSR0             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR0
    #define CAN0RXTSRL_TSR1             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR1
    #define CAN0RXTSRL_TSR2             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR2
    #define CAN0RXTSRL_TSR3             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR3
    #define CAN0RXTSRL_TSR4             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR4
    #define CAN0RXTSRL_TSR5             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR5
    #define CAN0RXTSRL_TSR6             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR6
    #define CAN0RXTSRL_TSR7             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR7
    
    #define CAN0RXTSRL_TSR0_MASK        1U
    #define CAN0RXTSRL_TSR1_MASK        2U
    #define CAN0RXTSRL_TSR2_MASK        4U
    #define CAN0RXTSRL_TSR3_MASK        8U
    #define CAN0RXTSRL_TSR4_MASK        16U
    #define CAN0RXTSRL_TSR5_MASK        32U
    #define CAN0RXTSRL_TSR6_MASK        64U
    #define CAN0RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0RXTSRSTR;
extern volatile CAN0RXTSRSTR _CAN0RXTSR @(REG_BASE + 0x0000016EUL);
#define CAN0RXTSR                       _CAN0RXTSR.Word
#define CAN0RXTSR_TSR0                  _CAN0RXTSR.Bits.TSR0
#define CAN0RXTSR_TSR1                  _CAN0RXTSR.Bits.TSR1
#define CAN0RXTSR_TSR2                  _CAN0RXTSR.Bits.TSR2
#define CAN0RXTSR_TSR3                  _CAN0RXTSR.Bits.TSR3
#define CAN0RXTSR_TSR4                  _CAN0RXTSR.Bits.TSR4
#define CAN0RXTSR_TSR5                  _CAN0RXTSR.Bits.TSR5
#define CAN0RXTSR_TSR6                  _CAN0RXTSR.Bits.TSR6
#define CAN0RXTSR_TSR7                  _CAN0RXTSR.Bits.TSR7
#define CAN0RXTSR_TSR8                  _CAN0RXTSR.Bits.TSR8
#define CAN0RXTSR_TSR9                  _CAN0RXTSR.Bits.TSR9
#define CAN0RXTSR_TSR10                 _CAN0RXTSR.Bits.TSR10
#define CAN0RXTSR_TSR11                 _CAN0RXTSR.Bits.TSR11
#define CAN0RXTSR_TSR12                 _CAN0RXTSR.Bits.TSR12
#define CAN0RXTSR_TSR13                 _CAN0RXTSR.Bits.TSR13
#define CAN0RXTSR_TSR14                 _CAN0RXTSR.Bits.TSR14
#define CAN0RXTSR_TSR15                 _CAN0RXTSR.Bits.TSR15

#define CAN0RXTSR_TSR0_MASK             1U
#define CAN0RXTSR_TSR1_MASK             2U
#define CAN0RXTSR_TSR2_MASK             4U
#define CAN0RXTSR_TSR3_MASK             8U
#define CAN0RXTSR_TSR4_MASK             16U
#define CAN0RXTSR_TSR5_MASK             32U
#define CAN0RXTSR_TSR6_MASK             64U
#define CAN0RXTSR_TSR7_MASK             128U
#define CAN0RXTSR_TSR8_MASK             256U
#define CAN0RXTSR_TSR9_MASK             512U
#define CAN0RXTSR_TSR10_MASK            1024U
#define CAN0RXTSR_TSR11_MASK            2048U
#define CAN0RXTSR_TSR12_MASK            4096U
#define CAN0RXTSR_TSR13_MASK            8192U
#define CAN0RXTSR_TSR14_MASK            16384U
#define CAN0RXTSR_TSR15_MASK            32768U


/*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0TXIDR0STR;
extern volatile CAN0TXIDR0STR _CAN0TXIDR0 @(REG_BASE + 0x00000170UL);
#define CAN0TXIDR0                      _CAN0TXIDR0.Byte
#define CAN0TXIDR0_ID21                 _CAN0TXIDR0.Bits.ID21
#define CAN0TXIDR0_ID22                 _CAN0TXIDR0.Bits.ID22
#define CAN0TXIDR0_ID23                 _CAN0TXIDR0.Bits.ID23
#define CAN0TXIDR0_ID24                 _CAN0TXIDR0.Bits.ID24
#define CAN0TXIDR0_ID25                 _CAN0TXIDR0.Bits.ID25
#define CAN0TXIDR0_ID26                 _CAN0TXIDR0.Bits.ID26
#define CAN0TXIDR0_ID27                 _CAN0TXIDR0.Bits.ID27
#define CAN0TXIDR0_ID28                 _CAN0TXIDR0.Bits.ID28
/* CAN0TXIDR_ARR: Access 4 CAN0TXIDRx registers in an array */
#define CAN0TXIDR_ARR                   ((volatile byte *) &CAN0TXIDR0)

#define CAN0TXIDR0_ID21_MASK            1U
#define CAN0TXIDR0_ID22_MASK            2U
#define CAN0TXIDR0_ID23_MASK            4U
#define CAN0TXIDR0_ID24_MASK            8U
#define CAN0TXIDR0_ID25_MASK            16U
#define CAN0TXIDR0_ID26_MASK            32U
#define CAN0TXIDR0_ID27_MASK            64U
#define CAN0TXIDR0_ID28_MASK            128U


/*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0TXIDR1STR;
extern volatile CAN0TXIDR1STR _CAN0TXIDR1 @(REG_BASE + 0x00000171UL);
#define CAN0TXIDR1                      _CAN0TXIDR1.Byte
#define CAN0TXIDR1_ID15                 _CAN0TXIDR1.Bits.ID15
#define CAN0TXIDR1_ID16                 _CAN0TXIDR1.Bits.ID16
#define CAN0TXIDR1_ID17                 _CAN0TXIDR1.Bits.ID17
#define CAN0TXIDR1_IDE                  _CAN0TXIDR1.Bits.IDE
#define CAN0TXIDR1_SRR                  _CAN0TXIDR1.Bits.SRR
#define CAN0TXIDR1_ID18                 _CAN0TXIDR1.Bits.ID18
#define CAN0TXIDR1_ID19                 _CAN0TXIDR1.Bits.ID19
#define CAN0TXIDR1_ID20                 _CAN0TXIDR1.Bits.ID20
#define CAN0TXIDR1_ID_15                _CAN0TXIDR1.MergedBits.grpID_15
#define CAN0TXIDR1_ID_18                _CAN0TXIDR1.MergedBits.grpID_18
#define CAN0TXIDR1_ID                   CAN0TXIDR1_ID_15

#define CAN0TXIDR1_ID15_MASK            1U
#define CAN0TXIDR1_ID16_MASK            2U
#define CAN0TXIDR1_ID17_MASK            4U
#define CAN0TXIDR1_IDE_MASK             8U
#define CAN0TXIDR1_SRR_MASK             16U
#define CAN0TXIDR1_ID18_MASK            32U
#define CAN0TXIDR1_ID19_MASK            64U
#define CAN0TXIDR1_ID20_MASK            128U
#define CAN0TXIDR1_ID_15_MASK           7U
#define CAN0TXIDR1_ID_15_BITNUM         0U
#define CAN0TXIDR1_ID_18_MASK           224U
#define CAN0TXIDR1_ID_18_BITNUM         5U


/*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0TXIDR2STR;
extern volatile CAN0TXIDR2STR _CAN0TXIDR2 @(REG_BASE + 0x00000172UL);
#define CAN0TXIDR2                      _CAN0TXIDR2.Byte
#define CAN0TXIDR2_ID7                  _CAN0TXIDR2.Bits.ID7
#define CAN0TXIDR2_ID8                  _CAN0TXIDR2.Bits.ID8
#define CAN0TXIDR2_ID9                  _CAN0TXIDR2.Bits.ID9
#define CAN0TXIDR2_ID10                 _CAN0TXIDR2.Bits.ID10
#define CAN0TXIDR2_ID11                 _CAN0TXIDR2.Bits.ID11
#define CAN0TXIDR2_ID12                 _CAN0TXIDR2.Bits.ID12
#define CAN0TXIDR2_ID13                 _CAN0TXIDR2.Bits.ID13
#define CAN0TXIDR2_ID14                 _CAN0TXIDR2.Bits.ID14

#define CAN0TXIDR2_ID7_MASK             1U
#define CAN0TXIDR2_ID8_MASK             2U
#define CAN0TXIDR2_ID9_MASK             4U
#define CAN0TXIDR2_ID10_MASK            8U
#define CAN0TXIDR2_ID11_MASK            16U
#define CAN0TXIDR2_ID12_MASK            32U
#define CAN0TXIDR2_ID13_MASK            64U
#define CAN0TXIDR2_ID14_MASK            128U


/*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0TXIDR3STR;
extern volatile CAN0TXIDR3STR _CAN0TXIDR3 @(REG_BASE + 0x00000173UL);
#define CAN0TXIDR3                      _CAN0TXIDR3.Byte
#define CAN0TXIDR3_RTR                  _CAN0TXIDR3.Bits.RTR
#define CAN0TXIDR3_ID0                  _CAN0TXIDR3.Bits.ID0
#define CAN0TXIDR3_ID1                  _CAN0TXIDR3.Bits.ID1
#define CAN0TXIDR3_ID2                  _CAN0TXIDR3.Bits.ID2
#define CAN0TXIDR3_ID3                  _CAN0TXIDR3.Bits.ID3
#define CAN0TXIDR3_ID4                  _CAN0TXIDR3.Bits.ID4
#define CAN0TXIDR3_ID5                  _CAN0TXIDR3.Bits.ID5
#define CAN0TXIDR3_ID6                  _CAN0TXIDR3.Bits.ID6
#define CAN0TXIDR3_ID                   _CAN0TXIDR3.MergedBits.grpID

#define CAN0TXIDR3_RTR_MASK             1U
#define CAN0TXIDR3_ID0_MASK             2U
#define CAN0TXIDR3_ID1_MASK             4U
#define CAN0TXIDR3_ID2_MASK             8U
#define CAN0TXIDR3_ID3_MASK             16U
#define CAN0TXIDR3_ID4_MASK             32U
#define CAN0TXIDR3_ID5_MASK             64U
#define CAN0TXIDR3_ID6_MASK             128U
#define CAN0TXIDR3_ID_MASK              254U
#define CAN0TXIDR3_ID_BITNUM            1U


/*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR0STR;
extern volatile CAN0TXDSR0STR _CAN0TXDSR0 @(REG_BASE + 0x00000174UL);
#define CAN0TXDSR0                      _CAN0TXDSR0.Byte
#define CAN0TXDSR0_DB0                  _CAN0TXDSR0.Bits.DB0
#define CAN0TXDSR0_DB1                  _CAN0TXDSR0.Bits.DB1
#define CAN0TXDSR0_DB2                  _CAN0TXDSR0.Bits.DB2
#define CAN0TXDSR0_DB3                  _CAN0TXDSR0.Bits.DB3
#define CAN0TXDSR0_DB4                  _CAN0TXDSR0.Bits.DB4
#define CAN0TXDSR0_DB5                  _CAN0TXDSR0.Bits.DB5
#define CAN0TXDSR0_DB6                  _CAN0TXDSR0.Bits.DB6
#define CAN0TXDSR0_DB7                  _CAN0TXDSR0.Bits.DB7
/* CAN0TXDSR_ARR: Access 8 CAN0TXDSRx registers in an array */
#define CAN0TXDSR_ARR                   ((volatile byte *) &CAN0TXDSR0)

#define CAN0TXDSR0_DB0_MASK             1U
#define CAN0TXDSR0_DB1_MASK             2U
#define CAN0TXDSR0_DB2_MASK             4U
#define CAN0TXDSR0_DB3_MASK             8U
#define CAN0TXDSR0_DB4_MASK             16U
#define CAN0TXDSR0_DB5_MASK             32U
#define CAN0TXDSR0_DB6_MASK             64U
#define CAN0TXDSR0_DB7_MASK             128U


/*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR1STR;
extern volatile CAN0TXDSR1STR _CAN0TXDSR1 @(REG_BASE + 0x00000175UL);
#define CAN0TXDSR1                      _CAN0TXDSR1.Byte
#define CAN0TXDSR1_DB0                  _CAN0TXDSR1.Bits.DB0
#define CAN0TXDSR1_DB1                  _CAN0TXDSR1.Bits.DB1
#define CAN0TXDSR1_DB2                  _CAN0TXDSR1.Bits.DB2
#define CAN0TXDSR1_DB3                  _CAN0TXDSR1.Bits.DB3
#define CAN0TXDSR1_DB4                  _CAN0TXDSR1.Bits.DB4
#define CAN0TXDSR1_DB5                  _CAN0TXDSR1.Bits.DB5
#define CAN0TXDSR1_DB6                  _CAN0TXDSR1.Bits.DB6
#define CAN0TXDSR1_DB7                  _CAN0TXDSR1.Bits.DB7

#define CAN0TXDSR1_DB0_MASK             1U
#define CAN0TXDSR1_DB1_MASK             2U
#define CAN0TXDSR1_DB2_MASK             4U
#define CAN0TXDSR1_DB3_MASK             8U
#define CAN0TXDSR1_DB4_MASK             16U
#define CAN0TXDSR1_DB5_MASK             32U
#define CAN0TXDSR1_DB6_MASK             64U
#define CAN0TXDSR1_DB7_MASK             128U


/*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR2STR;
extern volatile CAN0TXDSR2STR _CAN0TXDSR2 @(REG_BASE + 0x00000176UL);
#define CAN0TXDSR2                      _CAN0TXDSR2.Byte
#define CAN0TXDSR2_DB0                  _CAN0TXDSR2.Bits.DB0
#define CAN0TXDSR2_DB1                  _CAN0TXDSR2.Bits.DB1
#define CAN0TXDSR2_DB2                  _CAN0TXDSR2.Bits.DB2
#define CAN0TXDSR2_DB3                  _CAN0TXDSR2.Bits.DB3
#define CAN0TXDSR2_DB4                  _CAN0TXDSR2.Bits.DB4
#define CAN0TXDSR2_DB5                  _CAN0TXDSR2.Bits.DB5
#define CAN0TXDSR2_DB6                  _CAN0TXDSR2.Bits.DB6
#define CAN0TXDSR2_DB7                  _CAN0TXDSR2.Bits.DB7

#define CAN0TXDSR2_DB0_MASK             1U
#define CAN0TXDSR2_DB1_MASK             2U
#define CAN0TXDSR2_DB2_MASK             4U
#define CAN0TXDSR2_DB3_MASK             8U
#define CAN0TXDSR2_DB4_MASK             16U
#define CAN0TXDSR2_DB5_MASK             32U
#define CAN0TXDSR2_DB6_MASK             64U
#define CAN0TXDSR2_DB7_MASK             128U


/*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR3STR;
extern volatile CAN0TXDSR3STR _CAN0TXDSR3 @(REG_BASE + 0x00000177UL);
#define CAN0TXDSR3                      _CAN0TXDSR3.Byte
#define CAN0TXDSR3_DB0                  _CAN0TXDSR3.Bits.DB0
#define CAN0TXDSR3_DB1                  _CAN0TXDSR3.Bits.DB1
#define CAN0TXDSR3_DB2                  _CAN0TXDSR3.Bits.DB2
#define CAN0TXDSR3_DB3                  _CAN0TXDSR3.Bits.DB3
#define CAN0TXDSR3_DB4                  _CAN0TXDSR3.Bits.DB4
#define CAN0TXDSR3_DB5                  _CAN0TXDSR3.Bits.DB5
#define CAN0TXDSR3_DB6                  _CAN0TXDSR3.Bits.DB6
#define CAN0TXDSR3_DB7                  _CAN0TXDSR3.Bits.DB7

#define CAN0TXDSR3_DB0_MASK             1U
#define CAN0TXDSR3_DB1_MASK             2U
#define CAN0TXDSR3_DB2_MASK             4U
#define CAN0TXDSR3_DB3_MASK             8U
#define CAN0TXDSR3_DB4_MASK             16U
#define CAN0TXDSR3_DB5_MASK             32U
#define CAN0TXDSR3_DB6_MASK             64U
#define CAN0TXDSR3_DB7_MASK             128U


/*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR4STR;
extern volatile CAN0TXDSR4STR _CAN0TXDSR4 @(REG_BASE + 0x00000178UL);
#define CAN0TXDSR4                      _CAN0TXDSR4.Byte
#define CAN0TXDSR4_DB0                  _CAN0TXDSR4.Bits.DB0
#define CAN0TXDSR4_DB1                  _CAN0TXDSR4.Bits.DB1
#define CAN0TXDSR4_DB2                  _CAN0TXDSR4.Bits.DB2
#define CAN0TXDSR4_DB3                  _CAN0TXDSR4.Bits.DB3
#define CAN0TXDSR4_DB4                  _CAN0TXDSR4.Bits.DB4
#define CAN0TXDSR4_DB5                  _CAN0TXDSR4.Bits.DB5
#define CAN0TXDSR4_DB6                  _CAN0TXDSR4.Bits.DB6
#define CAN0TXDSR4_DB7                  _CAN0TXDSR4.Bits.DB7

#define CAN0TXDSR4_DB0_MASK             1U
#define CAN0TXDSR4_DB1_MASK             2U
#define CAN0TXDSR4_DB2_MASK             4U
#define CAN0TXDSR4_DB3_MASK             8U
#define CAN0TXDSR4_DB4_MASK             16U
#define CAN0TXDSR4_DB5_MASK             32U
#define CAN0TXDSR4_DB6_MASK             64U
#define CAN0TXDSR4_DB7_MASK             128U


/*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR5STR;
extern volatile CAN0TXDSR5STR _CAN0TXDSR5 @(REG_BASE + 0x00000179UL);
#define CAN0TXDSR5                      _CAN0TXDSR5.Byte
#define CAN0TXDSR5_DB0                  _CAN0TXDSR5.Bits.DB0
#define CAN0TXDSR5_DB1                  _CAN0TXDSR5.Bits.DB1
#define CAN0TXDSR5_DB2                  _CAN0TXDSR5.Bits.DB2
#define CAN0TXDSR5_DB3                  _CAN0TXDSR5.Bits.DB3
#define CAN0TXDSR5_DB4                  _CAN0TXDSR5.Bits.DB4
#define CAN0TXDSR5_DB5                  _CAN0TXDSR5.Bits.DB5
#define CAN0TXDSR5_DB6                  _CAN0TXDSR5.Bits.DB6
#define CAN0TXDSR5_DB7                  _CAN0TXDSR5.Bits.DB7

#define CAN0TXDSR5_DB0_MASK             1U
#define CAN0TXDSR5_DB1_MASK             2U
#define CAN0TXDSR5_DB2_MASK             4U
#define CAN0TXDSR5_DB3_MASK             8U
#define CAN0TXDSR5_DB4_MASK             16U
#define CAN0TXDSR5_DB5_MASK             32U
#define CAN0TXDSR5_DB6_MASK             64U
#define CAN0TXDSR5_DB7_MASK             128U


/*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR6STR;
extern volatile CAN0TXDSR6STR _CAN0TXDSR6 @(REG_BASE + 0x0000017AUL);
#define CAN0TXDSR6                      _CAN0TXDSR6.Byte
#define CAN0TXDSR6_DB0                  _CAN0TXDSR6.Bits.DB0
#define CAN0TXDSR6_DB1                  _CAN0TXDSR6.Bits.DB1
#define CAN0TXDSR6_DB2                  _CAN0TXDSR6.Bits.DB2
#define CAN0TXDSR6_DB3                  _CAN0TXDSR6.Bits.DB3
#define CAN0TXDSR6_DB4                  _CAN0TXDSR6.Bits.DB4
#define CAN0TXDSR6_DB5                  _CAN0TXDSR6.Bits.DB5
#define CAN0TXDSR6_DB6                  _CAN0TXDSR6.Bits.DB6
#define CAN0TXDSR6_DB7                  _CAN0TXDSR6.Bits.DB7

#define CAN0TXDSR6_DB0_MASK             1U
#define CAN0TXDSR6_DB1_MASK             2U
#define CAN0TXDSR6_DB2_MASK             4U
#define CAN0TXDSR6_DB3_MASK             8U
#define CAN0TXDSR6_DB4_MASK             16U
#define CAN0TXDSR6_DB5_MASK             32U
#define CAN0TXDSR6_DB6_MASK             64U
#define CAN0TXDSR6_DB7_MASK             128U


/*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR7STR;
extern volatile CAN0TXDSR7STR _CAN0TXDSR7 @(REG_BASE + 0x0000017BUL);
#define CAN0TXDSR7                      _CAN0TXDSR7.Byte
#define CAN0TXDSR7_DB0                  _CAN0TXDSR7.Bits.DB0
#define CAN0TXDSR7_DB1                  _CAN0TXDSR7.Bits.DB1
#define CAN0TXDSR7_DB2                  _CAN0TXDSR7.Bits.DB2
#define CAN0TXDSR7_DB3                  _CAN0TXDSR7.Bits.DB3
#define CAN0TXDSR7_DB4                  _CAN0TXDSR7.Bits.DB4
#define CAN0TXDSR7_DB5                  _CAN0TXDSR7.Bits.DB5
#define CAN0TXDSR7_DB6                  _CAN0TXDSR7.Bits.DB6
#define CAN0TXDSR7_DB7                  _CAN0TXDSR7.Bits.DB7

#define CAN0TXDSR7_DB0_MASK             1U
#define CAN0TXDSR7_DB1_MASK             2U
#define CAN0TXDSR7_DB2_MASK             4U
#define CAN0TXDSR7_DB3_MASK             8U
#define CAN0TXDSR7_DB4_MASK             16U
#define CAN0TXDSR7_DB5_MASK             32U
#define CAN0TXDSR7_DB6_MASK             64U
#define CAN0TXDSR7_DB7_MASK             128U


/*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TXDLRSTR;
extern volatile CAN0TXDLRSTR _CAN0TXDLR @(REG_BASE + 0x0000017CUL);
#define CAN0TXDLR                       _CAN0TXDLR.Byte
#define CAN0TXDLR_DLC0                  _CAN0TXDLR.Bits.DLC0
#define CAN0TXDLR_DLC1                  _CAN0TXDLR.Bits.DLC1
#define CAN0TXDLR_DLC2                  _CAN0TXDLR.Bits.DLC2
#define CAN0TXDLR_DLC3                  _CAN0TXDLR.Bits.DLC3
#define CAN0TXDLR_DLC                   _CAN0TXDLR.MergedBits.grpDLC

#define CAN0TXDLR_DLC0_MASK             1U
#define CAN0TXDLR_DLC1_MASK             2U
#define CAN0TXDLR_DLC2_MASK             4U
#define CAN0TXDLR_DLC3_MASK             8U
#define CAN0TXDLR_DLC_MASK              15U
#define CAN0TXDLR_DLC_BITNUM            0U


/*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN0TXTBPRSTR;
extern volatile CAN0TXTBPRSTR _CAN0TXTBPR @(REG_BASE + 0x0000017DUL);
#define CAN0TXTBPR                      _CAN0TXTBPR.Byte
#define CAN0TXTBPR_PRIO0                _CAN0TXTBPR.Bits.PRIO0
#define CAN0TXTBPR_PRIO1                _CAN0TXTBPR.Bits.PRIO1
#define CAN0TXTBPR_PRIO2                _CAN0TXTBPR.Bits.PRIO2
#define CAN0TXTBPR_PRIO3                _CAN0TXTBPR.Bits.PRIO3
#define CAN0TXTBPR_PRIO4                _CAN0TXTBPR.Bits.PRIO4
#define CAN0TXTBPR_PRIO5                _CAN0TXTBPR.Bits.PRIO5
#define CAN0TXTBPR_PRIO6                _CAN0TXTBPR.Bits.PRIO6
#define CAN0TXTBPR_PRIO7                _CAN0TXTBPR.Bits.PRIO7

#define CAN0TXTBPR_PRIO0_MASK           1U
#define CAN0TXTBPR_PRIO1_MASK           2U
#define CAN0TXTBPR_PRIO2_MASK           4U
#define CAN0TXTBPR_PRIO3_MASK           8U
#define CAN0TXTBPR_PRIO4_MASK           16U
#define CAN0TXTBPR_PRIO5_MASK           32U
#define CAN0TXTBPR_PRIO6_MASK           64U
#define CAN0TXTBPR_PRIO7_MASK           128U


/*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0TXTSRHSTR;
    #define CAN0TXTSRH                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Byte
    #define CAN0TXTSRH_TSR8             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR8
    #define CAN0TXTSRH_TSR9             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR9
    #define CAN0TXTSRH_TSR10            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR10
    #define CAN0TXTSRH_TSR11            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR11
    #define CAN0TXTSRH_TSR12            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR12
    #define CAN0TXTSRH_TSR13            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR13
    #define CAN0TXTSRH_TSR14            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR14
    #define CAN0TXTSRH_TSR15            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR15
    
    #define CAN0TXTSRH_TSR8_MASK        1U
    #define CAN0TXTSRH_TSR9_MASK        2U
    #define CAN0TXTSRH_TSR10_MASK       4U
    #define CAN0TXTSRH_TSR11_MASK       8U
    #define CAN0TXTSRH_TSR12_MASK       16U
    #define CAN0TXTSRH_TSR13_MASK       32U
    #define CAN0TXTSRH_TSR14_MASK       64U
    #define CAN0TXTSRH_TSR15_MASK       128U
    

    /*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0TXTSRLSTR;
    #define CAN0TXTSRL                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Byte
    #define CAN0TXTSRL_TSR0             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR0
    #define CAN0TXTSRL_TSR1             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR1
    #define CAN0TXTSRL_TSR2             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR2
    #define CAN0TXTSRL_TSR3             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR3
    #define CAN0TXTSRL_TSR4             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR4
    #define CAN0TXTSRL_TSR5             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR5
    #define CAN0TXTSRL_TSR6             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR6
    #define CAN0TXTSRL_TSR7             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR7
    
    #define CAN0TXTSRL_TSR0_MASK        1U
    #define CAN0TXTSRL_TSR1_MASK        2U
    #define CAN0TXTSRL_TSR2_MASK        4U
    #define CAN0TXTSRL_TSR3_MASK        8U
    #define CAN0TXTSRL_TSR4_MASK        16U
    #define CAN0TXTSRL_TSR5_MASK        32U
    #define CAN0TXTSRL_TSR6_MASK        64U
    #define CAN0TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0TXTSRSTR;
extern volatile CAN0TXTSRSTR _CAN0TXTSR @(REG_BASE + 0x0000017EUL);
#define CAN0TXTSR                       _CAN0TXTSR.Word
#define CAN0TXTSR_TSR0                  _CAN0TXTSR.Bits.TSR0
#define CAN0TXTSR_TSR1                  _CAN0TXTSR.Bits.TSR1
#define CAN0TXTSR_TSR2                  _CAN0TXTSR.Bits.TSR2
#define CAN0TXTSR_TSR3                  _CAN0TXTSR.Bits.TSR3
#define CAN0TXTSR_TSR4                  _CAN0TXTSR.Bits.TSR4
#define CAN0TXTSR_TSR5                  _CAN0TXTSR.Bits.TSR5
#define CAN0TXTSR_TSR6                  _CAN0TXTSR.Bits.TSR6
#define CAN0TXTSR_TSR7                  _CAN0TXTSR.Bits.TSR7
#define CAN0TXTSR_TSR8                  _CAN0TXTSR.Bits.TSR8
#define CAN0TXTSR_TSR9                  _CAN0TXTSR.Bits.TSR9
#define CAN0TXTSR_TSR10                 _CAN0TXTSR.Bits.TSR10
#define CAN0TXTSR_TSR11                 _CAN0TXTSR.Bits.TSR11
#define CAN0TXTSR_TSR12                 _CAN0TXTSR.Bits.TSR12
#define CAN0TXTSR_TSR13                 _CAN0TXTSR.Bits.TSR13
#define CAN0TXTSR_TSR14                 _CAN0TXTSR.Bits.TSR14
#define CAN0TXTSR_TSR15                 _CAN0TXTSR.Bits.TSR15

#define CAN0TXTSR_TSR0_MASK             1U
#define CAN0TXTSR_TSR1_MASK             2U
#define CAN0TXTSR_TSR2_MASK             4U
#define CAN0TXTSR_TSR3_MASK             8U
#define CAN0TXTSR_TSR4_MASK             16U
#define CAN0TXTSR_TSR5_MASK             32U
#define CAN0TXTSR_TSR6_MASK             64U
#define CAN0TXTSR_TSR7_MASK             128U
#define CAN0TXTSR_TSR8_MASK             256U
#define CAN0TXTSR_TSR9_MASK             512U
#define CAN0TXTSR_TSR10_MASK            1024U
#define CAN0TXTSR_TSR11_MASK            2048U
#define CAN0TXTSR_TSR12_MASK            4096U
#define CAN0TXTSR_TSR13_MASK            8192U
#define CAN0TXTSR_TSR14_MASK            16384U
#define CAN0TXTSR_TSR15_MASK            32768U


/*** PMFCFG0 - PMF Configure 0 Register; 0x00000200 ***/
typedef union {
  byte Byte;
  struct {
    byte INDEPA      :1;                                       /* Independent or Complimentary Operation for Pair A */
    byte INDEPB      :1;                                       /* Independent or Complimentary Operation for Pair B */
    byte INDEPC      :1;                                       /* Independent or Complimentary Operation for Pair C */
    byte EDGEA       :1;                                       /* Edge-Aligned or Center-Aligned PWM for Pair A */
    byte EDGEB       :1;                                       /* Edge-Aligned or Center-Aligned PWM for Pair B */
    byte EDGEC       :1;                                       /* Edge-Aligned or Center-Aligned PWM for Pair C */
    byte MTG         :1;                                       /* Multiple Timebase Generators */
    byte WP          :1;                                       /* Write Protect */
  } Bits;
  struct {
    byte grpINDEPx :3;
    byte grpEDGEx :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFCFG0STR;
extern volatile PMFCFG0STR _PMFCFG0 @(REG_BASE + 0x00000200UL);
#define PMFCFG0                         _PMFCFG0.Byte
#define PMFCFG0_INDEPA                  _PMFCFG0.Bits.INDEPA
#define PMFCFG0_INDEPB                  _PMFCFG0.Bits.INDEPB
#define PMFCFG0_INDEPC                  _PMFCFG0.Bits.INDEPC
#define PMFCFG0_EDGEA                   _PMFCFG0.Bits.EDGEA
#define PMFCFG0_EDGEB                   _PMFCFG0.Bits.EDGEB
#define PMFCFG0_EDGEC                   _PMFCFG0.Bits.EDGEC
#define PMFCFG0_MTG                     _PMFCFG0.Bits.MTG
#define PMFCFG0_WP                      _PMFCFG0.Bits.WP
/* PMFCFG_ARR: Access 4 PMFCFGx registers in an array */
#define PMFCFG_ARR                      ((volatile byte *) &PMFCFG0)
#define PMFCFG0_INDEPx                  _PMFCFG0.MergedBits.grpINDEPx
#define PMFCFG0_EDGEx                   _PMFCFG0.MergedBits.grpEDGEx

#define PMFCFG0_INDEPA_MASK             1U
#define PMFCFG0_INDEPB_MASK             2U
#define PMFCFG0_INDEPC_MASK             4U
#define PMFCFG0_EDGEA_MASK              8U
#define PMFCFG0_EDGEB_MASK              16U
#define PMFCFG0_EDGEC_MASK              32U
#define PMFCFG0_MTG_MASK                64U
#define PMFCFG0_WP_MASK                 128U
#define PMFCFG0_INDEPx_MASK             7U
#define PMFCFG0_INDEPx_BITNUM           0U
#define PMFCFG0_EDGEx_MASK              56U
#define PMFCFG0_EDGEx_BITNUM            3U


/*** PMFCFG1 - PMF Configure 1 Register; 0x00000201 ***/
typedef union {
  byte Byte;
  struct {
    byte TOPNEGA     :1;                                       /* Pair A Top-side PWM Polarity */
    byte BOTNEGA     :1;                                       /* Pair A Bottom-side PWM Polarity */
    byte TOPNEGB     :1;                                       /* Pair B Top-side PWM Polarity */
    byte BOTNEGB     :1;                                       /* Pair B Bottom-side PWM Polarity */
    byte TOPNEGC     :1;                                       /* Pair C Top-side PWM Polarity */
    byte BOTNEGC     :1;                                       /* Pair C Bottom-side PWM Polarity */
    byte             :1; 
    byte ENHA        :1;                                       /* Enable Hardware Acceleration */
  } Bits;
} PMFCFG1STR;
extern volatile PMFCFG1STR _PMFCFG1 @(REG_BASE + 0x00000201UL);
#define PMFCFG1                         _PMFCFG1.Byte
#define PMFCFG1_TOPNEGA                 _PMFCFG1.Bits.TOPNEGA
#define PMFCFG1_BOTNEGA                 _PMFCFG1.Bits.BOTNEGA
#define PMFCFG1_TOPNEGB                 _PMFCFG1.Bits.TOPNEGB
#define PMFCFG1_BOTNEGB                 _PMFCFG1.Bits.BOTNEGB
#define PMFCFG1_TOPNEGC                 _PMFCFG1.Bits.TOPNEGC
#define PMFCFG1_BOTNEGC                 _PMFCFG1.Bits.BOTNEGC
#define PMFCFG1_ENHA                    _PMFCFG1.Bits.ENHA

#define PMFCFG1_TOPNEGA_MASK            1U
#define PMFCFG1_BOTNEGA_MASK            2U
#define PMFCFG1_TOPNEGB_MASK            4U
#define PMFCFG1_BOTNEGB_MASK            8U
#define PMFCFG1_TOPNEGC_MASK            16U
#define PMFCFG1_BOTNEGC_MASK            32U
#define PMFCFG1_ENHA_MASK               128U


/*** PMFCFG2 - PMF Configure 2 Register; 0x00000202 ***/
typedef union {
  byte Byte;
  struct {
    byte MSK0        :1;                                       /* Mask PWM 0 */
    byte MSK1        :1;                                       /* Mask PWM 1 */
    byte MSK2        :1;                                       /* Mask PWM 2 */
    byte MSK3        :1;                                       /* Mask PWM 3 */
    byte MSK4        :1;                                       /* Mask PWM 4 */
    byte MSK5        :1;                                       /* Mask PWM 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpMSK  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFCFG2STR;
extern volatile PMFCFG2STR _PMFCFG2 @(REG_BASE + 0x00000202UL);
#define PMFCFG2                         _PMFCFG2.Byte
#define PMFCFG2_MSK0                    _PMFCFG2.Bits.MSK0
#define PMFCFG2_MSK1                    _PMFCFG2.Bits.MSK1
#define PMFCFG2_MSK2                    _PMFCFG2.Bits.MSK2
#define PMFCFG2_MSK3                    _PMFCFG2.Bits.MSK3
#define PMFCFG2_MSK4                    _PMFCFG2.Bits.MSK4
#define PMFCFG2_MSK5                    _PMFCFG2.Bits.MSK5
#define PMFCFG2_MSK                     _PMFCFG2.MergedBits.grpMSK

#define PMFCFG2_MSK0_MASK               1U
#define PMFCFG2_MSK1_MASK               2U
#define PMFCFG2_MSK2_MASK               4U
#define PMFCFG2_MSK3_MASK               8U
#define PMFCFG2_MSK4_MASK               16U
#define PMFCFG2_MSK5_MASK               32U
#define PMFCFG2_MSK_MASK                63U
#define PMFCFG2_MSK_BITNUM              0U


/*** PMFCFG3 - PMF Configure 3 Register; 0x00000203 ***/
typedef union {
  byte Byte;
  struct {
    byte SWAPA       :1;                                       /* Swap Pair A */
    byte SWAPB       :1;                                       /* Swap Pair B */
    byte SWAPC       :1;                                       /* Swap Pair C */
    byte VLMODE0     :1;                                       /* Value Register Load Mode Bit 0 */
    byte VLMODE1     :1;                                       /* Value Register Load Mode Bit 1 */
    byte             :1; 
    byte PMFFRZ      :1;                                       /* PMF stops in FREEZE mode */
    byte PMFWAI      :1;                                       /* PMF stops in WAIT mode */
  } Bits;
  struct {
    byte grpSWAPx :3;
    byte grpVLMODE :2;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFCFG3STR;
extern volatile PMFCFG3STR _PMFCFG3 @(REG_BASE + 0x00000203UL);
#define PMFCFG3                         _PMFCFG3.Byte
#define PMFCFG3_SWAPA                   _PMFCFG3.Bits.SWAPA
#define PMFCFG3_SWAPB                   _PMFCFG3.Bits.SWAPB
#define PMFCFG3_SWAPC                   _PMFCFG3.Bits.SWAPC
#define PMFCFG3_VLMODE0                 _PMFCFG3.Bits.VLMODE0
#define PMFCFG3_VLMODE1                 _PMFCFG3.Bits.VLMODE1
#define PMFCFG3_PMFFRZ                  _PMFCFG3.Bits.PMFFRZ
#define PMFCFG3_PMFWAI                  _PMFCFG3.Bits.PMFWAI
#define PMFCFG3_SWAPx                   _PMFCFG3.MergedBits.grpSWAPx
#define PMFCFG3_VLMODE                  _PMFCFG3.MergedBits.grpVLMODE

#define PMFCFG3_SWAPA_MASK              1U
#define PMFCFG3_SWAPB_MASK              2U
#define PMFCFG3_SWAPC_MASK              4U
#define PMFCFG3_VLMODE0_MASK            8U
#define PMFCFG3_VLMODE1_MASK            16U
#define PMFCFG3_PMFFRZ_MASK             64U
#define PMFCFG3_PMFWAI_MASK             128U
#define PMFCFG3_SWAPx_MASK              7U
#define PMFCFG3_SWAPx_BITNUM            0U
#define PMFCFG3_VLMODE_MASK             24U
#define PMFCFG3_VLMODE_BITNUM           3U


/*** PMFFCTL - PMF fault control register; 0x00000204 ***/
typedef union {
  byte Byte;
  struct {
    byte FIE0        :1;                                       /* Fault 0 Pin Interrupt Enable */
    byte FMODE0      :1;                                       /* Fault 0 Pin Clearing Mode */
    byte FIE1        :1;                                       /* Fault 1 Pin Interrupt Enable */
    byte FMODE1      :1;                                       /* Fault 1 Pin Clearing Mode */
    byte FIE2        :1;                                       /* Fault 2 Pin Interrupt Enable */
    byte FMODE2      :1;                                       /* Fault 2 Pin Clearing Mode */
    byte FIE3        :1;                                       /* Fault 3 Pin Interrupt Enable */
    byte FMODE3      :1;                                       /* Fault 3 Pin Clearing Mode */
  } Bits;
} PMFFCTLSTR;
extern volatile PMFFCTLSTR _PMFFCTL @(REG_BASE + 0x00000204UL);
#define PMFFCTL                         _PMFFCTL.Byte
#define PMFFCTL_FIE0                    _PMFFCTL.Bits.FIE0
#define PMFFCTL_FMODE0                  _PMFFCTL.Bits.FMODE0
#define PMFFCTL_FIE1                    _PMFFCTL.Bits.FIE1
#define PMFFCTL_FMODE1                  _PMFFCTL.Bits.FMODE1
#define PMFFCTL_FIE2                    _PMFFCTL.Bits.FIE2
#define PMFFCTL_FMODE2                  _PMFFCTL.Bits.FMODE2
#define PMFFCTL_FIE3                    _PMFFCTL.Bits.FIE3
#define PMFFCTL_FMODE3                  _PMFFCTL.Bits.FMODE3

#define PMFFCTL_FIE0_MASK               1U
#define PMFFCTL_FMODE0_MASK             2U
#define PMFFCTL_FIE1_MASK               4U
#define PMFFCTL_FMODE1_MASK             8U
#define PMFFCTL_FIE2_MASK               16U
#define PMFFCTL_FMODE2_MASK             32U
#define PMFFCTL_FIE3_MASK               64U
#define PMFFCTL_FMODE3_MASK             128U


/*** PMFFPIN - PMF fault acknowledge register; 0x00000205 ***/
typedef union {
  byte Byte;
  struct {
    byte FPINE0      :1;                                       /* Fault 0 Pin Enable */
    byte             :1; 
    byte FPINE1      :1;                                       /* Fault 1 Pin Enable */
    byte             :1; 
    byte FPINE2      :1;                                       /* Fault 2 Pin Enable */
    byte             :1; 
    byte FPINE3      :1;                                       /* Fault 3 Pin Enable */
    byte             :1; 
  } Bits;
} PMFFPINSTR;
extern volatile PMFFPINSTR _PMFFPIN @(REG_BASE + 0x00000205UL);
#define PMFFPIN                         _PMFFPIN.Byte
#define PMFFPIN_FPINE0                  _PMFFPIN.Bits.FPINE0
#define PMFFPIN_FPINE1                  _PMFFPIN.Bits.FPINE1
#define PMFFPIN_FPINE2                  _PMFFPIN.Bits.FPINE2
#define PMFFPIN_FPINE3                  _PMFFPIN.Bits.FPINE3

#define PMFFPIN_FPINE0_MASK             1U
#define PMFFPIN_FPINE1_MASK             4U
#define PMFFPIN_FPINE2_MASK             16U
#define PMFFPIN_FPINE3_MASK             64U


/*** PMFFSTA - PMF fault status register; 0x00000206 ***/
typedef union {
  byte Byte;
  struct {
    byte FFLAG0      :1;                                       /* Fault 0 pin Flag */
    byte             :1; 
    byte FFLAG1      :1;                                       /* Fault 1 pin Flag */
    byte             :1; 
    byte FFLAG2      :1;                                       /* Fault 2 pin Flag */
    byte             :1; 
    byte FFLAG3      :1;                                       /* Fault 3 pin Flag */
    byte             :1; 
  } Bits;
} PMFFSTASTR;
extern volatile PMFFSTASTR _PMFFSTA @(REG_BASE + 0x00000206UL);
#define PMFFSTA                         _PMFFSTA.Byte
#define PMFFSTA_FFLAG0                  _PMFFSTA.Bits.FFLAG0
#define PMFFSTA_FFLAG1                  _PMFFSTA.Bits.FFLAG1
#define PMFFSTA_FFLAG2                  _PMFFSTA.Bits.FFLAG2
#define PMFFSTA_FFLAG3                  _PMFFSTA.Bits.FFLAG3

#define PMFFSTA_FFLAG0_MASK             1U
#define PMFFSTA_FFLAG1_MASK             4U
#define PMFFSTA_FFLAG2_MASK             16U
#define PMFFSTA_FFLAG3_MASK             64U


/*** PMFQSMP - PMF fault qualifying samples register; 0x00000207 ***/
typedef union {
  byte Byte;
  struct {
    byte QSMP0       :2;                                       /* Fault 0 Qualifying samples */
    byte QSMP1       :2;                                       /* Fault 1 Qualifying samples */
    byte QSMP2       :2;                                       /* Fault 2 Qualifying samples */
    byte QSMP3       :2;                                       /* Fault 3 Qualifying samples */
  } Bits;
} PMFQSMPSTR;
extern volatile PMFQSMPSTR _PMFQSMP @(REG_BASE + 0x00000207UL);
#define PMFQSMP                         _PMFQSMP.Byte
#define PMFQSMP_QSMP0                   _PMFQSMP.Bits.QSMP0
#define PMFQSMP_QSMP1                   _PMFQSMP.Bits.QSMP1
#define PMFQSMP_QSMP2                   _PMFQSMP.Bits.QSMP2
#define PMFQSMP_QSMP3                   _PMFQSMP.Bits.QSMP3

#define PMFQSMP_QSMP0_MASK              3U
#define PMFQSMP_QSMP0_BITNUM            0U
#define PMFQSMP_QSMP1_MASK              12U
#define PMFQSMP_QSMP1_BITNUM            2U
#define PMFQSMP_QSMP2_MASK              48U
#define PMFQSMP_QSMP2_BITNUM            4U
#define PMFQSMP_QSMP3_MASK              192U
#define PMFQSMP_QSMP3_BITNUM            6U


/*** PMFDMPA - PMF disable mapping A register; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte DMP00       :1;                                       /* PMF Disable Mapping A Bit 00 */
    byte DMP01       :1;                                       /* PMF Disable Mapping A Bit 01 */
    byte DMP02       :1;                                       /* PMF Disable Mapping A Bit 02 */
    byte DMP03       :1;                                       /* PMF Disable Mapping A Bit 03 */
    byte DMP10       :1;                                       /* PMF Disable Mapping A Bit 10 */
    byte DMP11       :1;                                       /* PMF Disable Mapping A Bit 11 */
    byte DMP12       :1;                                       /* PMF Disable Mapping A Bit 12 */
    byte DMP13       :1;                                       /* PMF Disable Mapping A Bit 13 */
  } Bits;
  struct {
    byte grpDMP0 :4;
    byte grpDMP_10 :4;
  } MergedBits;
} PMFDMPASTR;
extern volatile PMFDMPASTR _PMFDMPA @(REG_BASE + 0x00000208UL);
#define PMFDMPA                         _PMFDMPA.Byte
#define PMFDMPA_DMP00                   _PMFDMPA.Bits.DMP00
#define PMFDMPA_DMP01                   _PMFDMPA.Bits.DMP01
#define PMFDMPA_DMP02                   _PMFDMPA.Bits.DMP02
#define PMFDMPA_DMP03                   _PMFDMPA.Bits.DMP03
#define PMFDMPA_DMP10                   _PMFDMPA.Bits.DMP10
#define PMFDMPA_DMP11                   _PMFDMPA.Bits.DMP11
#define PMFDMPA_DMP12                   _PMFDMPA.Bits.DMP12
#define PMFDMPA_DMP13                   _PMFDMPA.Bits.DMP13
#define PMFDMPA_DMP0                    _PMFDMPA.MergedBits.grpDMP0
#define PMFDMPA_DMP_10                  _PMFDMPA.MergedBits.grpDMP_10
#define PMFDMPA_DMP                     PMFDMPA_DMP_10

#define PMFDMPA_DMP00_MASK              1U
#define PMFDMPA_DMP01_MASK              2U
#define PMFDMPA_DMP02_MASK              4U
#define PMFDMPA_DMP03_MASK              8U
#define PMFDMPA_DMP10_MASK              16U
#define PMFDMPA_DMP11_MASK              32U
#define PMFDMPA_DMP12_MASK              64U
#define PMFDMPA_DMP13_MASK              128U
#define PMFDMPA_DMP0_MASK               15U
#define PMFDMPA_DMP0_BITNUM             0U
#define PMFDMPA_DMP_10_MASK             240U
#define PMFDMPA_DMP_10_BITNUM           4U


/*** PMFDMPB - PMF disable mapping B register; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte DMP20       :1;                                       /* PMF Disable Mapping A Bit 20 */
    byte DMP21       :1;                                       /* PMF Disable Mapping A Bit 21 */
    byte DMP22       :1;                                       /* PMF Disable Mapping A Bit 22 */
    byte DMP23       :1;                                       /* PMF Disable Mapping A Bit 23 */
    byte DMP30       :1;                                       /* PMF Disable Mapping A Bit 30 */
    byte DMP31       :1;                                       /* PMF Disable Mapping A Bit 31 */
    byte DMP32       :1;                                       /* PMF Disable Mapping A Bit 32 */
    byte DMP33       :1;                                       /* PMF Disable Mapping A Bit 33 */
  } Bits;
  struct {
    byte grpDMP_20 :4;
    byte grpDMP_30 :4;
  } MergedBits;
} PMFDMPBSTR;
extern volatile PMFDMPBSTR _PMFDMPB @(REG_BASE + 0x00000209UL);
#define PMFDMPB                         _PMFDMPB.Byte
#define PMFDMPB_DMP20                   _PMFDMPB.Bits.DMP20
#define PMFDMPB_DMP21                   _PMFDMPB.Bits.DMP21
#define PMFDMPB_DMP22                   _PMFDMPB.Bits.DMP22
#define PMFDMPB_DMP23                   _PMFDMPB.Bits.DMP23
#define PMFDMPB_DMP30                   _PMFDMPB.Bits.DMP30
#define PMFDMPB_DMP31                   _PMFDMPB.Bits.DMP31
#define PMFDMPB_DMP32                   _PMFDMPB.Bits.DMP32
#define PMFDMPB_DMP33                   _PMFDMPB.Bits.DMP33
#define PMFDMPB_DMP_20                  _PMFDMPB.MergedBits.grpDMP_20
#define PMFDMPB_DMP_30                  _PMFDMPB.MergedBits.grpDMP_30
#define PMFDMPB_DMP                     PMFDMPB_DMP_20

#define PMFDMPB_DMP20_MASK              1U
#define PMFDMPB_DMP21_MASK              2U
#define PMFDMPB_DMP22_MASK              4U
#define PMFDMPB_DMP23_MASK              8U
#define PMFDMPB_DMP30_MASK              16U
#define PMFDMPB_DMP31_MASK              32U
#define PMFDMPB_DMP32_MASK              64U
#define PMFDMPB_DMP33_MASK              128U
#define PMFDMPB_DMP_20_MASK             15U
#define PMFDMPB_DMP_20_BITNUM           0U
#define PMFDMPB_DMP_30_MASK             240U
#define PMFDMPB_DMP_30_BITNUM           4U


/*** PMFDMPC - PMF disable mapping C register; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte DMP40       :1;                                       /* PMF Disable Mapping A Bit 40 */
    byte DMP41       :1;                                       /* PMF Disable Mapping A Bit 41 */
    byte DMP42       :1;                                       /* PMF Disable Mapping A Bit 42 */
    byte DMP43       :1;                                       /* PMF Disable Mapping A Bit 43 */
    byte DMP50       :1;                                       /* PMF Disable Mapping A Bit 50 */
    byte DMP51       :1;                                       /* PMF Disable Mapping A Bit 51 */
    byte DMP52       :1;                                       /* PMF Disable Mapping A Bit 52 */
    byte DMP53       :1;                                       /* PMF Disable Mapping A Bit 53 */
  } Bits;
  struct {
    byte grpDMP_40 :4;
    byte grpDMP_50 :4;
  } MergedBits;
} PMFDMPCSTR;
extern volatile PMFDMPCSTR _PMFDMPC @(REG_BASE + 0x0000020AUL);
#define PMFDMPC                         _PMFDMPC.Byte
#define PMFDMPC_DMP40                   _PMFDMPC.Bits.DMP40
#define PMFDMPC_DMP41                   _PMFDMPC.Bits.DMP41
#define PMFDMPC_DMP42                   _PMFDMPC.Bits.DMP42
#define PMFDMPC_DMP43                   _PMFDMPC.Bits.DMP43
#define PMFDMPC_DMP50                   _PMFDMPC.Bits.DMP50
#define PMFDMPC_DMP51                   _PMFDMPC.Bits.DMP51
#define PMFDMPC_DMP52                   _PMFDMPC.Bits.DMP52
#define PMFDMPC_DMP53                   _PMFDMPC.Bits.DMP53
#define PMFDMPC_DMP_40                  _PMFDMPC.MergedBits.grpDMP_40
#define PMFDMPC_DMP_50                  _PMFDMPC.MergedBits.grpDMP_50
#define PMFDMPC_DMP                     PMFDMPC_DMP_40

#define PMFDMPC_DMP40_MASK              1U
#define PMFDMPC_DMP41_MASK              2U
#define PMFDMPC_DMP42_MASK              4U
#define PMFDMPC_DMP43_MASK              8U
#define PMFDMPC_DMP50_MASK              16U
#define PMFDMPC_DMP51_MASK              32U
#define PMFDMPC_DMP52_MASK              64U
#define PMFDMPC_DMP53_MASK              128U
#define PMFDMPC_DMP_40_MASK             15U
#define PMFDMPC_DMP_40_BITNUM           0U
#define PMFDMPC_DMP_50_MASK             240U
#define PMFDMPC_DMP_50_BITNUM           4U


/*** PMFOUTC - PMF output control register; 0x0000020C ***/
typedef union {
  byte Byte;
  struct {
    byte OUTCTL0     :1;                                       /* PMF Output Control Bit 0 */
    byte OUTCTL1     :1;                                       /* PMF Output Control Bit 1 */
    byte OUTCTL2     :1;                                       /* PMF Output Control Bit 2 */
    byte OUTCTL3     :1;                                       /* PMF Output Control Bit 3 */
    byte OUTCTL4     :1;                                       /* PMF Output Control Bit 4 */
    byte OUTCTL5     :1;                                       /* PMF Output Control Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOUTCTL :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFOUTCSTR;
extern volatile PMFOUTCSTR _PMFOUTC @(REG_BASE + 0x0000020CUL);
#define PMFOUTC                         _PMFOUTC.Byte
#define PMFOUTC_OUTCTL0                 _PMFOUTC.Bits.OUTCTL0
#define PMFOUTC_OUTCTL1                 _PMFOUTC.Bits.OUTCTL1
#define PMFOUTC_OUTCTL2                 _PMFOUTC.Bits.OUTCTL2
#define PMFOUTC_OUTCTL3                 _PMFOUTC.Bits.OUTCTL3
#define PMFOUTC_OUTCTL4                 _PMFOUTC.Bits.OUTCTL4
#define PMFOUTC_OUTCTL5                 _PMFOUTC.Bits.OUTCTL5
#define PMFOUTC_OUTCTL                  _PMFOUTC.MergedBits.grpOUTCTL

#define PMFOUTC_OUTCTL0_MASK            1U
#define PMFOUTC_OUTCTL1_MASK            2U
#define PMFOUTC_OUTCTL2_MASK            4U
#define PMFOUTC_OUTCTL3_MASK            8U
#define PMFOUTC_OUTCTL4_MASK            16U
#define PMFOUTC_OUTCTL5_MASK            32U
#define PMFOUTC_OUTCTL_MASK             63U
#define PMFOUTC_OUTCTL_BITNUM           0U


/*** PMFOUTB - PMF output control bit register; 0x0000020D ***/
typedef union {
  byte Byte;
  struct {
    byte OUT0        :1;                                       /* PMF Output Control Bit Bit 0 */
    byte OUT1        :1;                                       /* PMF Output Control Bit Bit 1 */
    byte OUT2        :1;                                       /* PMF Output Control Bit Bit 2 */
    byte OUT3        :1;                                       /* PMF Output Control Bit Bit 3 */
    byte OUT4        :1;                                       /* PMF Output Control Bit Bit 4 */
    byte OUT5        :1;                                       /* PMF Output Control Bit Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpOUT  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFOUTBSTR;
extern volatile PMFOUTBSTR _PMFOUTB @(REG_BASE + 0x0000020DUL);
#define PMFOUTB                         _PMFOUTB.Byte
#define PMFOUTB_OUT0                    _PMFOUTB.Bits.OUT0
#define PMFOUTB_OUT1                    _PMFOUTB.Bits.OUT1
#define PMFOUTB_OUT2                    _PMFOUTB.Bits.OUT2
#define PMFOUTB_OUT3                    _PMFOUTB.Bits.OUT3
#define PMFOUTB_OUT4                    _PMFOUTB.Bits.OUT4
#define PMFOUTB_OUT5                    _PMFOUTB.Bits.OUT5
#define PMFOUTB_OUT                     _PMFOUTB.MergedBits.grpOUT

#define PMFOUTB_OUT0_MASK               1U
#define PMFOUTB_OUT1_MASK               2U
#define PMFOUTB_OUT2_MASK               4U
#define PMFOUTB_OUT3_MASK               8U
#define PMFOUTB_OUT4_MASK               16U
#define PMFOUTB_OUT5_MASK               32U
#define PMFOUTB_OUT_MASK                63U
#define PMFOUTB_OUT_BITNUM              0U


/*** PMFDTMS - PMF deadtime sample register; 0x0000020E ***/
typedef union {
  byte Byte;
  struct {
    byte DT0         :1;                                       /* PMF Deadtime Sample Bit 0 */
    byte DT1         :1;                                       /* PMF Deadtime Sample Bit 1 */
    byte DT2         :1;                                       /* PMF Deadtime Sample Bit 2 */
    byte DT3         :1;                                       /* PMF Deadtime Sample Bit 3 */
    byte DT4         :1;                                       /* PMF Deadtime Sample Bit 4 */
    byte DT5         :1;                                       /* PMF Deadtime Sample Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDT   :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFDTMSSTR;
extern volatile PMFDTMSSTR _PMFDTMS @(REG_BASE + 0x0000020EUL);
#define PMFDTMS                         _PMFDTMS.Byte
#define PMFDTMS_DT0                     _PMFDTMS.Bits.DT0
#define PMFDTMS_DT1                     _PMFDTMS.Bits.DT1
#define PMFDTMS_DT2                     _PMFDTMS.Bits.DT2
#define PMFDTMS_DT3                     _PMFDTMS.Bits.DT3
#define PMFDTMS_DT4                     _PMFDTMS.Bits.DT4
#define PMFDTMS_DT5                     _PMFDTMS.Bits.DT5
#define PMFDTMS_DT                      _PMFDTMS.MergedBits.grpDT

#define PMFDTMS_DT0_MASK                1U
#define PMFDTMS_DT1_MASK                2U
#define PMFDTMS_DT2_MASK                4U
#define PMFDTMS_DT3_MASK                8U
#define PMFDTMS_DT4_MASK                16U
#define PMFDTMS_DT5_MASK                32U
#define PMFDTMS_DT_MASK                 63U
#define PMFDTMS_DT_BITNUM               0U


/*** PMFCCTL - PMF correction control register; 0x0000020F ***/
typedef union {
  byte Byte;
  struct {
    byte IPOLA       :1;                                       /* Current Polarity A */
    byte IPOLB       :1;                                       /* Current Polarity B */
    byte IPOLC       :1;                                       /* Current Polarity C */
    byte             :1; 
    byte ISENS0      :1;                                       /* Current status sensing method Bit 0 */
    byte ISENS1      :1;                                       /* Current status sensing method Bit 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIPOLx :3;
    byte         :1;
    byte grpISENS :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} PMFCCTLSTR;
extern volatile PMFCCTLSTR _PMFCCTL @(REG_BASE + 0x0000020FUL);
#define PMFCCTL                         _PMFCCTL.Byte
#define PMFCCTL_IPOLA                   _PMFCCTL.Bits.IPOLA
#define PMFCCTL_IPOLB                   _PMFCCTL.Bits.IPOLB
#define PMFCCTL_IPOLC                   _PMFCCTL.Bits.IPOLC
#define PMFCCTL_ISENS0                  _PMFCCTL.Bits.ISENS0
#define PMFCCTL_ISENS1                  _PMFCCTL.Bits.ISENS1
#define PMFCCTL_IPOLx                   _PMFCCTL.MergedBits.grpIPOLx
#define PMFCCTL_ISENS                   _PMFCCTL.MergedBits.grpISENS

#define PMFCCTL_IPOLA_MASK              1U
#define PMFCCTL_IPOLB_MASK              2U
#define PMFCCTL_IPOLC_MASK              4U
#define PMFCCTL_ISENS0_MASK             16U
#define PMFCCTL_ISENS1_MASK             32U
#define PMFCCTL_IPOLx_MASK              7U
#define PMFCCTL_IPOLx_BITNUM            0U
#define PMFCCTL_ISENS_MASK              48U
#define PMFCCTL_ISENS_BITNUM            4U


/*** PMFVAL0 - PMF Value 0 Register; 0x00000210 ***/
typedef union {
  word Word;
} PMFVAL0STR;
extern volatile PMFVAL0STR _PMFVAL0 @(REG_BASE + 0x00000210UL);
#define PMFVAL0                         _PMFVAL0.Word
/* PMFVAL_ARR: Access 6 PMFVALx registers in an array */
#define PMFVAL_ARR                      ((volatile word *) &PMFVAL0)


/*** PMFVAL1 - PMF Value 1 Register; 0x00000212 ***/
typedef union {
  word Word;
} PMFVAL1STR;
extern volatile PMFVAL1STR _PMFVAL1 @(REG_BASE + 0x00000212UL);
#define PMFVAL1                         _PMFVAL1.Word


/*** PMFVAL2 - PMF Value 2 Register; 0x00000214 ***/
typedef union {
  word Word;
} PMFVAL2STR;
extern volatile PMFVAL2STR _PMFVAL2 @(REG_BASE + 0x00000214UL);
#define PMFVAL2                         _PMFVAL2.Word


/*** PMFVAL3 - PMF Value 3 Register; 0x00000216 ***/
typedef union {
  word Word;
} PMFVAL3STR;
extern volatile PMFVAL3STR _PMFVAL3 @(REG_BASE + 0x00000216UL);
#define PMFVAL3                         _PMFVAL3.Word


/*** PMFVAL4 - PMF Value 4 Register; 0x00000218 ***/
typedef union {
  word Word;
} PMFVAL4STR;
extern volatile PMFVAL4STR _PMFVAL4 @(REG_BASE + 0x00000218UL);
#define PMFVAL4                         _PMFVAL4.Word


/*** PMFVAL5 - PMF Value 5 Register; 0x0000021A ***/
typedef union {
  word Word;
} PMFVAL5STR;
extern volatile PMFVAL5STR _PMFVAL5 @(REG_BASE + 0x0000021AUL);
#define PMFVAL5                         _PMFVAL5.Word


/*** PMFENCA - PMF Enable Control A Register; 0x00000220 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRIEA     :1;                                       /* PWM Reload Interrupt Enable A */
    byte LDOKA       :1;                                       /* Load Okay A */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PWMENA      :1;                                       /* PWM Generator A Enable */
  } Bits;
} PMFENCASTR;
extern volatile PMFENCASTR _PMFENCA @(REG_BASE + 0x00000220UL);
#define PMFENCA                         _PMFENCA.Byte
#define PMFENCA_PWMRIEA                 _PMFENCA.Bits.PWMRIEA
#define PMFENCA_LDOKA                   _PMFENCA.Bits.LDOKA
#define PMFENCA_PWMENA                  _PMFENCA.Bits.PWMENA

#define PMFENCA_PWMRIEA_MASK            1U
#define PMFENCA_LDOKA_MASK              2U
#define PMFENCA_PWMENA_MASK             128U


/*** PMFFQCA - PMF Frequency Control A Register; 0x00000221 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRFA      :1;                                       /* PWM Reload Flag A */
    byte PRSCA       :2;                                       /* Prescaler A */
    byte HALFA       :1;                                       /* Half Cycle Reload A */
    byte LDFQA       :4;                                       /* Load Frequency A */
  } Bits;
} PMFFQCASTR;
extern volatile PMFFQCASTR _PMFFQCA @(REG_BASE + 0x00000221UL);
#define PMFFQCA                         _PMFFQCA.Byte
#define PMFFQCA_PWMRFA                  _PMFFQCA.Bits.PWMRFA
#define PMFFQCA_PRSCA                   _PMFFQCA.Bits.PRSCA
#define PMFFQCA_HALFA                   _PMFFQCA.Bits.HALFA
#define PMFFQCA_LDFQA                   _PMFFQCA.Bits.LDFQA

#define PMFFQCA_PWMRFA_MASK             1U
#define PMFFQCA_PRSCA_MASK              6U
#define PMFFQCA_PRSCA_BITNUM            1U
#define PMFFQCA_HALFA_MASK              8U
#define PMFFQCA_LDFQA_MASK              240U
#define PMFFQCA_LDFQA_BITNUM            4U


/*** PMFCNTA - PMF Counter A Register; 0x00000222 ***/
typedef union {
  word Word;
  struct {
    word PMFCNTA_grp :15;                                      /* PMF Counter A */ /*Warning: group name is duplicated with register name*/
    word             :1; 
  } Bits;
} PMFCNTASTR;
extern volatile PMFCNTASTR _PMFCNTA @(REG_BASE + 0x00000222UL);
#define PMFCNTA                         _PMFCNTA.Word
#define PMFCNTA_PMFCNTA                 _PMFCNTA.Bits.PMFCNTA_grp

#define PMFCNTA_PMFCNTA_MASK            32767U
#define PMFCNTA_PMFCNTA_BITNUM          0U


/*** PMFMODA - PMF Counter Modulo A Register; 0x00000224 ***/
typedef union {
  word Word;
  struct {
    word PMFMODA_grp :15;                                      /* PMF Counter Modulo A */ /*Warning: group name is duplicated with register name*/
    word             :1; 
  } Bits;
} PMFMODASTR;
extern volatile PMFMODASTR _PMFMODA @(REG_BASE + 0x00000224UL);
#define PMFMODA                         _PMFMODA.Word
#define PMFMODA_PMFMODA                 _PMFMODA.Bits.PMFMODA_grp

#define PMFMODA_PMFMODA_MASK            32767U
#define PMFMODA_PMFMODA_BITNUM          0U


/*** PMFDTMA - PMF Deadtime A Register; 0x00000226 ***/
typedef union {
  word Word;
  struct {
    word PMFDTMA_grp :12;                                      /* PMF Deadtime A */ /*Warning: group name is duplicated with register name*/
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} PMFDTMASTR;
extern volatile PMFDTMASTR _PMFDTMA @(REG_BASE + 0x00000226UL);
#define PMFDTMA                         _PMFDTMA.Word
#define PMFDTMA_PMFDTMA                 _PMFDTMA.Bits.PMFDTMA_grp

#define PMFDTMA_PMFDTMA_MASK            4095U
#define PMFDTMA_PMFDTMA_BITNUM          0U


/*** PMFENCB - PMF enable control B register; 0x00000228 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRIEB     :1;                                       /* PWM Reload Interrupt Enable B */
    byte LDOKB       :1;                                       /* Load Okay B */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PWMENB      :1;                                       /* PWM Generator B Enable */
  } Bits;
} PMFENCBSTR;
extern volatile PMFENCBSTR _PMFENCB @(REG_BASE + 0x00000228UL);
#define PMFENCB                         _PMFENCB.Byte
#define PMFENCB_PWMRIEB                 _PMFENCB.Bits.PWMRIEB
#define PMFENCB_LDOKB                   _PMFENCB.Bits.LDOKB
#define PMFENCB_PWMENB                  _PMFENCB.Bits.PWMENB

#define PMFENCB_PWMRIEB_MASK            1U
#define PMFENCB_LDOKB_MASK              2U
#define PMFENCB_PWMENB_MASK             128U


/*** PMFFQCB - PMF Frequency Control B Register; 0x00000229 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRFB      :1;                                       /* PWM Reload Flag B */
    byte PRSCB       :2;                                       /* Prescaler B */
    byte HALFB       :1;                                       /* Half Cycle Reload B */
    byte LDFQB       :4;                                       /* Load Frequency B */
  } Bits;
} PMFFQCBSTR;
extern volatile PMFFQCBSTR _PMFFQCB @(REG_BASE + 0x00000229UL);
#define PMFFQCB                         _PMFFQCB.Byte
#define PMFFQCB_PWMRFB                  _PMFFQCB.Bits.PWMRFB
#define PMFFQCB_PRSCB                   _PMFFQCB.Bits.PRSCB
#define PMFFQCB_HALFB                   _PMFFQCB.Bits.HALFB
#define PMFFQCB_LDFQB                   _PMFFQCB.Bits.LDFQB

#define PMFFQCB_PWMRFB_MASK             1U
#define PMFFQCB_PRSCB_MASK              6U
#define PMFFQCB_PRSCB_BITNUM            1U
#define PMFFQCB_HALFB_MASK              8U
#define PMFFQCB_LDFQB_MASK              240U
#define PMFFQCB_LDFQB_BITNUM            4U


/*** PMFCNTB - PMF Counter B Register; 0x0000022A ***/
typedef union {
  word Word;
  struct {
    word PMFCNTB_grp :15;                                      /* PMF Counter B */ /*Warning: group name is duplicated with register name*/
    word             :1; 
  } Bits;
} PMFCNTBSTR;
extern volatile PMFCNTBSTR _PMFCNTB @(REG_BASE + 0x0000022AUL);
#define PMFCNTB                         _PMFCNTB.Word
#define PMFCNTB_PMFCNTB                 _PMFCNTB.Bits.PMFCNTB_grp

#define PMFCNTB_PMFCNTB_MASK            32767U
#define PMFCNTB_PMFCNTB_BITNUM          0U


/*** PMFMODB - PMF Counter Modulo B Register; 0x0000022C ***/
typedef union {
  word Word;
  struct {
    word PMFMODB_grp :15;                                      /* PMF Counter Modulo B */ /*Warning: group name is duplicated with register name*/
    word             :1; 
  } Bits;
} PMFMODBSTR;
extern volatile PMFMODBSTR _PMFMODB @(REG_BASE + 0x0000022CUL);
#define PMFMODB                         _PMFMODB.Word
#define PMFMODB_PMFMODB                 _PMFMODB.Bits.PMFMODB_grp

#define PMFMODB_PMFMODB_MASK            32767U
#define PMFMODB_PMFMODB_BITNUM          0U


/*** PMFDTMB - PMF Deadtime B Register; 0x0000022E ***/
typedef union {
  word Word;
  struct {
    word PMFDTMB_grp :12;                                      /* PMF Deadtime B */ /*Warning: group name is duplicated with register name*/
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} PMFDTMBSTR;
extern volatile PMFDTMBSTR _PMFDTMB @(REG_BASE + 0x0000022EUL);
#define PMFDTMB                         _PMFDTMB.Word
#define PMFDTMB_PMFDTMB                 _PMFDTMB.Bits.PMFDTMB_grp

#define PMFDTMB_PMFDTMB_MASK            4095U
#define PMFDTMB_PMFDTMB_BITNUM          0U


/*** PMFENCC - PMF Enable Control C Register; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRIEC     :1;                                       /* PWM Reload Interrupt Enable C */
    byte LDOKC       :1;                                       /* Load Okay C */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PWMENC      :1;                                       /* PWM Generator C Enable */
  } Bits;
} PMFENCCSTR;
extern volatile PMFENCCSTR _PMFENCC @(REG_BASE + 0x00000230UL);
#define PMFENCC                         _PMFENCC.Byte
#define PMFENCC_PWMRIEC                 _PMFENCC.Bits.PWMRIEC
#define PMFENCC_LDOKC                   _PMFENCC.Bits.LDOKC
#define PMFENCC_PWMENC                  _PMFENCC.Bits.PWMENC

#define PMFENCC_PWMRIEC_MASK            1U
#define PMFENCC_LDOKC_MASK              2U
#define PMFENCC_PWMENC_MASK             128U


/*** PMFFQCC - PMF Frequency Control C Register; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte PWMRFC      :1;                                       /* PWM Reload Flag C */
    byte PRSCC       :2;                                       /* Prescaler C */
    byte HALFC       :1;                                       /* Half Cycle Reload C */
    byte LDFQC       :4;                                       /* Load Frequency C */
  } Bits;
} PMFFQCCSTR;
extern volatile PMFFQCCSTR _PMFFQCC @(REG_BASE + 0x00000231UL);
#define PMFFQCC                         _PMFFQCC.Byte
#define PMFFQCC_PWMRFC                  _PMFFQCC.Bits.PWMRFC
#define PMFFQCC_PRSCC                   _PMFFQCC.Bits.PRSCC
#define PMFFQCC_HALFC                   _PMFFQCC.Bits.HALFC
#define PMFFQCC_LDFQC                   _PMFFQCC.Bits.LDFQC

#define PMFFQCC_PWMRFC_MASK             1U
#define PMFFQCC_PRSCC_MASK              6U
#define PMFFQCC_PRSCC_BITNUM            1U
#define PMFFQCC_HALFC_MASK              8U
#define PMFFQCC_LDFQC_MASK              240U
#define PMFFQCC_LDFQC_BITNUM            4U


/*** PMFCNTC - PMF Counter C Register; 0x00000232 ***/
typedef union {
  word Word;
  struct {
    word PMFCNTC_grp :15;                                      /* PMF Counter C */ /*Warning: group name is duplicated with register name*/
    word             :1; 
  } Bits;
} PMFCNTCSTR;
extern volatile PMFCNTCSTR _PMFCNTC @(REG_BASE + 0x00000232UL);
#define PMFCNTC                         _PMFCNTC.Word
#define PMFCNTC_PMFCNTC                 _PMFCNTC.Bits.PMFCNTC_grp

#define PMFCNTC_PMFCNTC_MASK            32767U
#define PMFCNTC_PMFCNTC_BITNUM          0U


/*** PMFMODC - PMF Counter Modulo C Register; 0x00000234 ***/
typedef union {
  word Word;
  struct {
    word PMFMODC_grp :15;                                      /* PMF Counter Modulo C */ /*Warning: group name is duplicated with register name*/
    word             :1; 
  } Bits;
} PMFMODCSTR;
extern volatile PMFMODCSTR _PMFMODC @(REG_BASE + 0x00000234UL);
#define PMFMODC                         _PMFMODC.Word
#define PMFMODC_PMFMODC                 _PMFMODC.Bits.PMFMODC_grp

#define PMFMODC_PMFMODC_MASK            32767U
#define PMFMODC_PMFMODC_BITNUM          0U


/*** PMFDTMC - PMF Deadtime C Register; 0x00000236 ***/
typedef union {
  word Word;
  struct {
    word PMFDTMC_grp :12;                                      /* PMF Deadtime C */ /*Warning: group name is duplicated with register name*/
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} PMFDTMCSTR;
extern volatile PMFDTMCSTR _PMFDTMC @(REG_BASE + 0x00000236UL);
#define PMFDTMC                         _PMFDTMC.Word
#define PMFDTMC_PMFDTMC                 _PMFDTMC.Bits.PMFDTMC_grp

#define PMFDTMC_PMFDTMC_MASK            4095U
#define PMFDTMC_PMFDTMC_BITNUM          0U


/*** PTT - Port T I/O Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T Bit 0 */
    byte PTT1        :1;                                       /* Port T Bit 1 */
    byte PTT2        :1;                                       /* Port T Bit 2 */
    byte PTT3        :1;                                       /* Port T Bit 3 */
    byte PTT4        :1;                                       /* Port T Bit 4 */
    byte PTT5        :1;                                       /* Port T Bit 5 */
    byte PTT6        :1;                                       /* Port T Bit 6 */
    byte PTT7        :1;                                       /* Port T Bit 7 */
  } Bits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000240UL);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT4                        _PTT.Bits.PTT4
#define PTT_PTT5                        _PTT.Bits.PTT5
#define PTT_PTT6                        _PTT.Bits.PTT6
#define PTT_PTT7                        _PTT.Bits.PTT7

#define PTT_PTT0_MASK                   1U
#define PTT_PTT1_MASK                   2U
#define PTT_PTT2_MASK                   4U
#define PTT_PTT3_MASK                   8U
#define PTT_PTT4_MASK                   16U
#define PTT_PTT5_MASK                   32U
#define PTT_PTT6_MASK                   64U
#define PTT_PTT7_MASK                   128U


/*** PTIT - Port T Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T Bit 0 */
    byte PTIT1       :1;                                       /* Port T Bit 1 */
    byte PTIT2       :1;                                       /* Port T Bit 2 */
    byte PTIT3       :1;                                       /* Port T Bit 3 */
    byte PTIT4       :1;                                       /* Port T Bit 4 */
    byte PTIT5       :1;                                       /* Port T Bit 5 */
    byte PTIT6       :1;                                       /* Port T Bit 6 */
    byte PTIT7       :1;                                       /* Port T Bit 7 */
  } Bits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000241UL);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT4                      _PTIT.Bits.PTIT4
#define PTIT_PTIT5                      _PTIT.Bits.PTIT5
#define PTIT_PTIT6                      _PTIT.Bits.PTIT6
#define PTIT_PTIT7                      _PTIT.Bits.PTIT7

#define PTIT_PTIT0_MASK                 1U
#define PTIT_PTIT1_MASK                 2U
#define PTIT_PTIT2_MASK                 4U
#define PTIT_PTIT3_MASK                 8U
#define PTIT_PTIT4_MASK                 16U
#define PTIT_PTIT5_MASK                 32U
#define PTIT_PTIT6_MASK                 64U
#define PTIT_PTIT7_MASK                 128U


/*** DDRT - Port T Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Data Direction Port T Bit 0 */
    byte DDRT1       :1;                                       /* Data Direction Port T Bit 1 */
    byte DDRT2       :1;                                       /* Data Direction Port T Bit 2 */
    byte DDRT3       :1;                                       /* Data Direction Port T Bit 3 */
    byte DDRT4       :1;                                       /* Data Direction Port T Bit 4 */
    byte DDRT5       :1;                                       /* Data Direction Port T Bit 5 */
    byte DDRT6       :1;                                       /* Data Direction Port T Bit 6 */
    byte DDRT7       :1;                                       /* Data Direction Port T Bit 7 */
  } Bits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000242UL);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT4                      _DDRT.Bits.DDRT4
#define DDRT_DDRT5                      _DDRT.Bits.DDRT5
#define DDRT_DDRT6                      _DDRT.Bits.DDRT6
#define DDRT_DDRT7                      _DDRT.Bits.DDRT7

#define DDRT_DDRT0_MASK                 1U
#define DDRT_DDRT1_MASK                 2U
#define DDRT_DDRT2_MASK                 4U
#define DDRT_DDRT3_MASK                 8U
#define DDRT_DDRT4_MASK                 16U
#define DDRT_DDRT5_MASK                 32U
#define DDRT_DDRT6_MASK                 64U
#define DDRT_DDRT7_MASK                 128U


/*** RDRT - Port T Reduced Drive Register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRT0       :1;                                       /* Reduced Drive Port T Bit 0 */
    byte RDRT1       :1;                                       /* Reduced Drive Port T Bit 1 */
    byte RDRT2       :1;                                       /* Reduced Drive Port T Bit 2 */
    byte RDRT3       :1;                                       /* Reduced Drive Port T Bit 3 */
    byte RDRT4       :1;                                       /* Reduced Drive Port T Bit 4 */
    byte RDRT5       :1;                                       /* Reduced Drive Port T Bit 5 */
    byte RDRT6       :1;                                       /* Reduced Drive Port T Bit 6 */
    byte RDRT7       :1;                                       /* Reduced Drive Port T Bit 7 */
  } Bits;
} RDRTSTR;
extern volatile RDRTSTR _RDRT @(REG_BASE + 0x00000243UL);
#define RDRT                            _RDRT.Byte
#define RDRT_RDRT0                      _RDRT.Bits.RDRT0
#define RDRT_RDRT1                      _RDRT.Bits.RDRT1
#define RDRT_RDRT2                      _RDRT.Bits.RDRT2
#define RDRT_RDRT3                      _RDRT.Bits.RDRT3
#define RDRT_RDRT4                      _RDRT.Bits.RDRT4
#define RDRT_RDRT5                      _RDRT.Bits.RDRT5
#define RDRT_RDRT6                      _RDRT.Bits.RDRT6
#define RDRT_RDRT7                      _RDRT.Bits.RDRT7

#define RDRT_RDRT0_MASK                 1U
#define RDRT_RDRT1_MASK                 2U
#define RDRT_RDRT2_MASK                 4U
#define RDRT_RDRT3_MASK                 8U
#define RDRT_RDRT4_MASK                 16U
#define RDRT_RDRT5_MASK                 32U
#define RDRT_RDRT6_MASK                 64U
#define RDRT_RDRT7_MASK                 128U


/*** PERT - Port T Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Pull Device Enable Port T Bit 0 */
    byte PERT1       :1;                                       /* Pull Device Enable Port T Bit 1 */
    byte PERT2       :1;                                       /* Pull Device Enable Port T Bit 2 */
    byte PERT3       :1;                                       /* Pull Device Enable Port T Bit 3 */
    byte PERT4       :1;                                       /* Pull Device Enable Port T Bit 4 */
    byte PERT5       :1;                                       /* Pull Device Enable Port T Bit 5 */
    byte PERT6       :1;                                       /* Pull Device Enable Port T Bit 6 */
    byte PERT7       :1;                                       /* Pull Device Enable Port T Bit 7 */
  } Bits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000244UL);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT4                      _PERT.Bits.PERT4
#define PERT_PERT5                      _PERT.Bits.PERT5
#define PERT_PERT6                      _PERT.Bits.PERT6
#define PERT_PERT7                      _PERT.Bits.PERT7

#define PERT_PERT0_MASK                 1U
#define PERT_PERT1_MASK                 2U
#define PERT_PERT2_MASK                 4U
#define PERT_PERT3_MASK                 8U
#define PERT_PERT4_MASK                 16U
#define PERT_PERT5_MASK                 32U
#define PERT_PERT6_MASK                 64U
#define PERT_PERT7_MASK                 128U


/*** PPST - Port T Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Pull Select Port T Bit 0 */
    byte PPST1       :1;                                       /* Pull Select Port T Bit 1 */
    byte PPST2       :1;                                       /* Pull Select Port T Bit 2 */
    byte PPST3       :1;                                       /* Pull Select Port T Bit 3 */
    byte PPST4       :1;                                       /* Pull Select Port T Bit 4 */
    byte PPST5       :1;                                       /* Pull Select Port T Bit 5 */
    byte PPST6       :1;                                       /* Pull Select Port T Bit 6 */
    byte PPST7       :1;                                       /* Pull Select Port T Bit 7 */
  } Bits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000245UL);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST4                      _PPST.Bits.PPST4
#define PPST_PPST5                      _PPST.Bits.PPST5
#define PPST_PPST6                      _PPST.Bits.PPST6
#define PPST_PPST7                      _PPST.Bits.PPST7

#define PPST_PPST0_MASK                 1U
#define PPST_PPST1_MASK                 2U
#define PPST_PPST2_MASK                 4U
#define PPST_PPST3_MASK                 8U
#define PPST_PPST4_MASK                 16U
#define PPST_PPST5_MASK                 32U
#define PPST_PPST6_MASK                 64U
#define PPST_PPST7_MASK                 128U


/*** PTS - Port S I/O Register; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S Bit 0 */
    byte PTS1        :1;                                       /* Port S Bit 1 */
    byte PTS2        :1;                                       /* Port S Bit 2 */
    byte PTS3        :1;                                       /* Port S Bit 3 */
    byte PTS4        :1;                                       /* Port S Bit 4 */
    byte PTS5        :1;                                       /* Port S Bit 5 */
    byte PTS6        :1;                                       /* Port S Bit 6 */
    byte PTS7        :1;                                       /* Port S Bit 7 */
  } Bits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000248UL);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS2                        _PTS.Bits.PTS2
#define PTS_PTS3                        _PTS.Bits.PTS3
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS7                        _PTS.Bits.PTS7

#define PTS_PTS0_MASK                   1U
#define PTS_PTS1_MASK                   2U
#define PTS_PTS2_MASK                   4U
#define PTS_PTS3_MASK                   8U
#define PTS_PTS4_MASK                   16U
#define PTS_PTS5_MASK                   32U
#define PTS_PTS6_MASK                   64U
#define PTS_PTS7_MASK                   128U


/*** PTIS - Port S Input Register; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S Bit 0 */
    byte PTIS1       :1;                                       /* Port S Bit 1 */
    byte PTIS2       :1;                                       /* Port S Bit 2 */
    byte PTIS3       :1;                                       /* Port S Bit 3 */
    byte PTIS4       :1;                                       /* Port S Bit 4 */
    byte PTIS5       :1;                                       /* Port S Bit 5 */
    byte PTIS6       :1;                                       /* Port S Bit 6 */
    byte PTIS7       :1;                                       /* Port S Bit 7 */
  } Bits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000249UL);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS2                      _PTIS.Bits.PTIS2
#define PTIS_PTIS3                      _PTIS.Bits.PTIS3
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS7                      _PTIS.Bits.PTIS7

#define PTIS_PTIS0_MASK                 1U
#define PTIS_PTIS1_MASK                 2U
#define PTIS_PTIS2_MASK                 4U
#define PTIS_PTIS3_MASK                 8U
#define PTIS_PTIS4_MASK                 16U
#define PTIS_PTIS5_MASK                 32U
#define PTIS_PTIS6_MASK                 64U
#define PTIS_PTIS7_MASK                 128U


/*** DDRS - Port S Data Direction Register; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Data Direction Port S Bit 0 */
    byte DDRS1       :1;                                       /* Data Direction Port S Bit 1 */
    byte DDRS2       :1;                                       /* Data Direction Port S Bit 2 */
    byte DDRS3       :1;                                       /* Data Direction Port S Bit 3 */
    byte DDRS4       :1;                                       /* Data Direction Port S Bit 4 */
    byte DDRS5       :1;                                       /* Data Direction Port S Bit 5 */
    byte DDRS6       :1;                                       /* Data Direction Port S Bit 6 */
    byte DDRS7       :1;                                       /* Data Direction Port S Bit 7 */
  } Bits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x0000024AUL);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS2                      _DDRS.Bits.DDRS2
#define DDRS_DDRS3                      _DDRS.Bits.DDRS3
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS7                      _DDRS.Bits.DDRS7

#define DDRS_DDRS0_MASK                 1U
#define DDRS_DDRS1_MASK                 2U
#define DDRS_DDRS2_MASK                 4U
#define DDRS_DDRS3_MASK                 8U
#define DDRS_DDRS4_MASK                 16U
#define DDRS_DDRS5_MASK                 32U
#define DDRS_DDRS6_MASK                 64U
#define DDRS_DDRS7_MASK                 128U


/*** RDRS - Port S Reduced Drive Register; 0x0000024B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRS0       :1;                                       /* Reduced Drive Port S Bit 0 */
    byte RDRS1       :1;                                       /* Reduced Drive Port S Bit 1 */
    byte RDRS2       :1;                                       /* Reduced Drive Port S Bit 2 */
    byte RDRS3       :1;                                       /* Reduced Drive Port S Bit 3 */
    byte RDRS4       :1;                                       /* Reduced Drive Port S Bit 4 */
    byte RDRS5       :1;                                       /* Reduced Drive Port S Bit 5 */
    byte RDRS6       :1;                                       /* Reduced Drive Port S Bit 6 */
    byte RDRS7       :1;                                       /* Reduced Drive Port S Bit 7 */
  } Bits;
} RDRSSTR;
extern volatile RDRSSTR _RDRS @(REG_BASE + 0x0000024BUL);
#define RDRS                            _RDRS.Byte
#define RDRS_RDRS0                      _RDRS.Bits.RDRS0
#define RDRS_RDRS1                      _RDRS.Bits.RDRS1
#define RDRS_RDRS2                      _RDRS.Bits.RDRS2
#define RDRS_RDRS3                      _RDRS.Bits.RDRS3
#define RDRS_RDRS4                      _RDRS.Bits.RDRS4
#define RDRS_RDRS5                      _RDRS.Bits.RDRS5
#define RDRS_RDRS6                      _RDRS.Bits.RDRS6
#define RDRS_RDRS7                      _RDRS.Bits.RDRS7

#define RDRS_RDRS0_MASK                 1U
#define RDRS_RDRS1_MASK                 2U
#define RDRS_RDRS2_MASK                 4U
#define RDRS_RDRS3_MASK                 8U
#define RDRS_RDRS4_MASK                 16U
#define RDRS_RDRS5_MASK                 32U
#define RDRS_RDRS6_MASK                 64U
#define RDRS_RDRS7_MASK                 128U


/*** PERS - Port S Pull Device Enable Register; 0x0000024C ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Pull Device Enable Port S Bit 0 */
    byte PERS1       :1;                                       /* Pull Device Enable Port S Bit 1 */
    byte PERS2       :1;                                       /* Pull Device Enable Port S Bit 2 */
    byte PERS3       :1;                                       /* Pull Device Enable Port S Bit 3 */
    byte PERS4       :1;                                       /* Pull Device Enable Port S Bit 4 */
    byte PERS5       :1;                                       /* Pull Device Enable Port S Bit 5 */
    byte PERS6       :1;                                       /* Pull Device Enable Port S Bit 6 */
    byte PERS7       :1;                                       /* Pull Device Enable Port S Bit 7 */
  } Bits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x0000024CUL);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS2                      _PERS.Bits.PERS2
#define PERS_PERS3                      _PERS.Bits.PERS3
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS7                      _PERS.Bits.PERS7

#define PERS_PERS0_MASK                 1U
#define PERS_PERS1_MASK                 2U
#define PERS_PERS2_MASK                 4U
#define PERS_PERS3_MASK                 8U
#define PERS_PERS4_MASK                 16U
#define PERS_PERS5_MASK                 32U
#define PERS_PERS6_MASK                 64U
#define PERS_PERS7_MASK                 128U


/*** PPSS - Port S Polarity Select Register; 0x0000024D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Pull Select Port S Bit 0 */
    byte PPSS1       :1;                                       /* Pull Select Port S Bit 1 */
    byte PPSS2       :1;                                       /* Pull Select Port S Bit 2 */
    byte PPSS3       :1;                                       /* Pull Select Port S Bit 3 */
    byte PPSS4       :1;                                       /* Pull Select Port S Bit 4 */
    byte PPSS5       :1;                                       /* Pull Select Port S Bit 5 */
    byte PPSS6       :1;                                       /* Pull Select Port S Bit 6 */
    byte PPSS7       :1;                                       /* Pull Select Port S Bit 7 */
  } Bits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x0000024DUL);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS2                      _PPSS.Bits.PPSS2
#define PPSS_PPSS3                      _PPSS.Bits.PPSS3
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS7                      _PPSS.Bits.PPSS7

#define PPSS_PPSS0_MASK                 1U
#define PPSS_PPSS1_MASK                 2U
#define PPSS_PPSS2_MASK                 4U
#define PPSS_PPSS3_MASK                 8U
#define PPSS_PPSS4_MASK                 16U
#define PPSS_PPSS5_MASK                 32U
#define PPSS_PPSS6_MASK                 64U
#define PPSS_PPSS7_MASK                 128U


/*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMS0       :1;                                       /* Wired-Or Mode Port S Bit 0 */
    byte WOMS1       :1;                                       /* Wired-Or Mode Port S Bit 1 */
    byte WOMS2       :1;                                       /* Wired-Or Mode Port S Bit 2 */
    byte WOMS3       :1;                                       /* Wired-Or Mode Port S Bit 3 */
    byte WOMS4       :1;                                       /* Wired-Or Mode Port S Bit 4 */
    byte WOMS5       :1;                                       /* Wired-Or Mode Port S Bit 5 */
    byte WOMS6       :1;                                       /* Wired-Or Mode Port S Bit 6 */
    byte WOMS7       :1;                                       /* Wired-Or Mode Port S Bit 7 */
  } Bits;
} WOMSSTR;
extern volatile WOMSSTR _WOMS @(REG_BASE + 0x0000024EUL);
#define WOMS                            _WOMS.Byte
#define WOMS_WOMS0                      _WOMS.Bits.WOMS0
#define WOMS_WOMS1                      _WOMS.Bits.WOMS1
#define WOMS_WOMS2                      _WOMS.Bits.WOMS2
#define WOMS_WOMS3                      _WOMS.Bits.WOMS3
#define WOMS_WOMS4                      _WOMS.Bits.WOMS4
#define WOMS_WOMS5                      _WOMS.Bits.WOMS5
#define WOMS_WOMS6                      _WOMS.Bits.WOMS6
#define WOMS_WOMS7                      _WOMS.Bits.WOMS7

#define WOMS_WOMS0_MASK                 1U
#define WOMS_WOMS1_MASK                 2U
#define WOMS_WOMS2_MASK                 4U
#define WOMS_WOMS3_MASK                 8U
#define WOMS_WOMS4_MASK                 16U
#define WOMS_WOMS5_MASK                 32U
#define WOMS_WOMS6_MASK                 64U
#define WOMS_WOMS7_MASK                 128U


/*** PTM - Port M I/O Register; 0x00000250 ***/
typedef union {
  byte Byte;
  struct {
    byte PTM0        :1;                                       /* Port M Bit 0 */
    byte PTM1        :1;                                       /* Port M Bit 1 */
    byte PTM2        :1;                                       /* Port M Bit 2 */
    byte PTM3        :1;                                       /* Port M Bit 3 */
    byte PTM4        :1;                                       /* Port M Bit 4 */
    byte PTM5        :1;                                       /* Port M Bit 5 */
    byte PTM6        :1;                                       /* Port M Bit 6 */
    byte PTM7        :1;                                       /* Port M Bit 7 */
  } Bits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000250UL);
#define PTM                             _PTM.Byte
#define PTM_PTM0                        _PTM.Bits.PTM0
#define PTM_PTM1                        _PTM.Bits.PTM1
#define PTM_PTM2                        _PTM.Bits.PTM2
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM4                        _PTM.Bits.PTM4
#define PTM_PTM5                        _PTM.Bits.PTM5
#define PTM_PTM6                        _PTM.Bits.PTM6
#define PTM_PTM7                        _PTM.Bits.PTM7

#define PTM_PTM0_MASK                   1U
#define PTM_PTM1_MASK                   2U
#define PTM_PTM2_MASK                   4U
#define PTM_PTM3_MASK                   8U
#define PTM_PTM4_MASK                   16U
#define PTM_PTM5_MASK                   32U
#define PTM_PTM6_MASK                   64U
#define PTM_PTM7_MASK                   128U


/*** PTIM - Port M Input Register; 0x00000251 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIM0       :1;                                       /* Port M Bit 0 */
    byte PTIM1       :1;                                       /* Port M Bit 1 */
    byte PTIM2       :1;                                       /* Port M Bit 2 */
    byte PTIM3       :1;                                       /* Port M Bit 3 */
    byte PTIM4       :1;                                       /* Port M Bit 4 */
    byte PTIM5       :1;                                       /* Port M Bit 5 */
    byte PTIM6       :1;                                       /* Port M Bit 6 */
    byte PTIM7       :1;                                       /* Port M Bit 7 */
  } Bits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000251UL);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM0                      _PTIM.Bits.PTIM0
#define PTIM_PTIM1                      _PTIM.Bits.PTIM1
#define PTIM_PTIM2                      _PTIM.Bits.PTIM2
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM4                      _PTIM.Bits.PTIM4
#define PTIM_PTIM5                      _PTIM.Bits.PTIM5
#define PTIM_PTIM6                      _PTIM.Bits.PTIM6
#define PTIM_PTIM7                      _PTIM.Bits.PTIM7

#define PTIM_PTIM0_MASK                 1U
#define PTIM_PTIM1_MASK                 2U
#define PTIM_PTIM2_MASK                 4U
#define PTIM_PTIM3_MASK                 8U
#define PTIM_PTIM4_MASK                 16U
#define PTIM_PTIM5_MASK                 32U
#define PTIM_PTIM6_MASK                 64U
#define PTIM_PTIM7_MASK                 128U


/*** DDRM - Port M Data Direction Register; 0x00000252 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRM0       :1;                                       /* Data Direction Port M Bit 0 */
    byte DDRM1       :1;                                       /* Data Direction Port M Bit 1 */
    byte DDRM2       :1;                                       /* Data Direction Port M Bit 2 */
    byte DDRM3       :1;                                       /* Data Direction Port M Bit 3 */
    byte DDRM4       :1;                                       /* Data Direction Port M Bit 4 */
    byte DDRM5       :1;                                       /* Data Direction Port M Bit 5 */
    byte DDRM6       :1;                                       /* Data Direction Port M Bit 6 */
    byte DDRM7       :1;                                       /* Data Direction Port M Bit 7 */
  } Bits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x00000252UL);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM0                      _DDRM.Bits.DDRM0
#define DDRM_DDRM1                      _DDRM.Bits.DDRM1
#define DDRM_DDRM2                      _DDRM.Bits.DDRM2
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM4                      _DDRM.Bits.DDRM4
#define DDRM_DDRM5                      _DDRM.Bits.DDRM5
#define DDRM_DDRM6                      _DDRM.Bits.DDRM6
#define DDRM_DDRM7                      _DDRM.Bits.DDRM7

#define DDRM_DDRM0_MASK                 1U
#define DDRM_DDRM1_MASK                 2U
#define DDRM_DDRM2_MASK                 4U
#define DDRM_DDRM3_MASK                 8U
#define DDRM_DDRM4_MASK                 16U
#define DDRM_DDRM5_MASK                 32U
#define DDRM_DDRM6_MASK                 64U
#define DDRM_DDRM7_MASK                 128U


/*** RDRM - Port M Reduced Drive Register; 0x00000253 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRM0       :1;                                       /* Reduced Drive Port M Bit 0 */
    byte RDRM1       :1;                                       /* Reduced Drive Port M Bit 1 */
    byte RDRM2       :1;                                       /* Reduced Drive Port M Bit 2 */
    byte RDRM3       :1;                                       /* Reduced Drive Port M Bit 3 */
    byte RDRM4       :1;                                       /* Reduced Drive Port M Bit 4 */
    byte RDRM5       :1;                                       /* Reduced Drive Port M Bit 5 */
    byte RDRM6       :1;                                       /* Reduced Drive Port M Bit 6 */
    byte RDRM7       :1;                                       /* Reduced Drive Port M Bit 7 */
  } Bits;
} RDRMSTR;
extern volatile RDRMSTR _RDRM @(REG_BASE + 0x00000253UL);
#define RDRM                            _RDRM.Byte
#define RDRM_RDRM0                      _RDRM.Bits.RDRM0
#define RDRM_RDRM1                      _RDRM.Bits.RDRM1
#define RDRM_RDRM2                      _RDRM.Bits.RDRM2
#define RDRM_RDRM3                      _RDRM.Bits.RDRM3
#define RDRM_RDRM4                      _RDRM.Bits.RDRM4
#define RDRM_RDRM5                      _RDRM.Bits.RDRM5
#define RDRM_RDRM6                      _RDRM.Bits.RDRM6
#define RDRM_RDRM7                      _RDRM.Bits.RDRM7

#define RDRM_RDRM0_MASK                 1U
#define RDRM_RDRM1_MASK                 2U
#define RDRM_RDRM2_MASK                 4U
#define RDRM_RDRM3_MASK                 8U
#define RDRM_RDRM4_MASK                 16U
#define RDRM_RDRM5_MASK                 32U
#define RDRM_RDRM6_MASK                 64U
#define RDRM_RDRM7_MASK                 128U


/*** PERM - Port M Pull Device Enable Register; 0x00000254 ***/
typedef union {
  byte Byte;
  struct {
    byte PERM0       :1;                                       /* Pull Device Enable Port M Bit 0 */
    byte PERM1       :1;                                       /* Pull Device Enable Port M Bit 1 */
    byte PERM2       :1;                                       /* Pull Device Enable Port M Bit 2 */
    byte PERM3       :1;                                       /* Pull Device Enable Port M Bit 3 */
    byte PERM4       :1;                                       /* Pull Device Enable Port M Bit 4 */
    byte PERM5       :1;                                       /* Pull Device Enable Port M Bit 5 */
    byte PERM6       :1;                                       /* Pull Device Enable Port M Bit 6 */
    byte PERM7       :1;                                       /* Pull Device Enable Port M Bit 7 */
  } Bits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x00000254UL);
#define PERM                            _PERM.Byte
#define PERM_PERM0                      _PERM.Bits.PERM0
#define PERM_PERM1                      _PERM.Bits.PERM1
#define PERM_PERM2                      _PERM.Bits.PERM2
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM4                      _PERM.Bits.PERM4
#define PERM_PERM5                      _PERM.Bits.PERM5
#define PERM_PERM6                      _PERM.Bits.PERM6
#define PERM_PERM7                      _PERM.Bits.PERM7

#define PERM_PERM0_MASK                 1U
#define PERM_PERM1_MASK                 2U
#define PERM_PERM2_MASK                 4U
#define PERM_PERM3_MASK                 8U
#define PERM_PERM4_MASK                 16U
#define PERM_PERM5_MASK                 32U
#define PERM_PERM6_MASK                 64U
#define PERM_PERM7_MASK                 128U


/*** PPSM - Port M Polarity Select Register; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSM0       :1;                                       /* Pull Select Port M Bit 0 */
    byte PPSM1       :1;                                       /* Pull Select Port M Bit 1 */
    byte PPSM2       :1;                                       /* Pull Select Port M Bit 2 */
    byte PPSM3       :1;                                       /* Pull Select Port M Bit 3 */
    byte PPSM4       :1;                                       /* Pull Select Port M Bit 4 */
    byte PPSM5       :1;                                       /* Pull Select Port M Bit 5 */
    byte PPSM6       :1;                                       /* Pull Select Port M Bit 6 */
    byte PPSM7       :1;                                       /* Pull Select Port M Bit 7 */
  } Bits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x00000255UL);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM0                      _PPSM.Bits.PPSM0
#define PPSM_PPSM1                      _PPSM.Bits.PPSM1
#define PPSM_PPSM2                      _PPSM.Bits.PPSM2
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM4                      _PPSM.Bits.PPSM4
#define PPSM_PPSM5                      _PPSM.Bits.PPSM5
#define PPSM_PPSM6                      _PPSM.Bits.PPSM6
#define PPSM_PPSM7                      _PPSM.Bits.PPSM7

#define PPSM_PPSM0_MASK                 1U
#define PPSM_PPSM1_MASK                 2U
#define PPSM_PPSM2_MASK                 4U
#define PPSM_PPSM3_MASK                 8U
#define PPSM_PPSM4_MASK                 16U
#define PPSM_PPSM5_MASK                 32U
#define PPSM_PPSM6_MASK                 64U
#define PPSM_PPSM7_MASK                 128U


/*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***/
typedef union {
  byte Byte;
  struct {
    byte WOMM0       :1;                                       /* Wired-Or Mode Port M Bit 0 */
    byte WOMM1       :1;                                       /* Wired-Or Mode Port M Bit 1 */
    byte WOMM2       :1;                                       /* Wired-Or Mode Port M Bit 2 */
    byte WOMM3       :1;                                       /* Wired-Or Mode Port M Bit 3 */
    byte WOMM4       :1;                                       /* Wired-Or Mode Port M Bit 4 */
    byte WOMM5       :1;                                       /* Wired-Or Mode Port M Bit 5 */
    byte WOMM6       :1;                                       /* Wired-Or Mode Port M Bit 6 */
    byte WOMM7       :1;                                       /* Wired-Or Mode Port M Bit 7 */
  } Bits;
} WOMMSTR;
extern volatile WOMMSTR _WOMM @(REG_BASE + 0x00000256UL);
#define WOMM                            _WOMM.Byte
#define WOMM_WOMM0                      _WOMM.Bits.WOMM0
#define WOMM_WOMM1                      _WOMM.Bits.WOMM1
#define WOMM_WOMM2                      _WOMM.Bits.WOMM2
#define WOMM_WOMM3                      _WOMM.Bits.WOMM3
#define WOMM_WOMM4                      _WOMM.Bits.WOMM4
#define WOMM_WOMM5                      _WOMM.Bits.WOMM5
#define WOMM_WOMM6                      _WOMM.Bits.WOMM6
#define WOMM_WOMM7                      _WOMM.Bits.WOMM7

#define WOMM_WOMM0_MASK                 1U
#define WOMM_WOMM1_MASK                 2U
#define WOMM_WOMM2_MASK                 4U
#define WOMM_WOMM3_MASK                 8U
#define WOMM_WOMM4_MASK                 16U
#define WOMM_WOMM5_MASK                 32U
#define WOMM_WOMM6_MASK                 64U
#define WOMM_WOMM7_MASK                 128U


/*** PTP - Port P I/O Register; 0x00000258 ***/
typedef union {
  byte Byte;
  struct {
    byte PTP0        :1;                                       /* Port P Bit 0 */
    byte PTP1        :1;                                       /* Port P Bit 1 */
    byte PTP2        :1;                                       /* Port P Bit 2 */
    byte PTP3        :1;                                       /* Port P Bit 3 */
    byte PTP4        :1;                                       /* Port P Bit 4 */
    byte PTP5        :1;                                       /* Port P Bit 5 */
    byte PTP6        :1;                                       /* Port P Bit 6 */
    byte PTP7        :1;                                       /* Port P Bit 7 */
  } Bits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000258UL);
#define PTP                             _PTP.Byte
#define PTP_PTP0                        _PTP.Bits.PTP0
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP2                        _PTP.Bits.PTP2
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP6                        _PTP.Bits.PTP6
#define PTP_PTP7                        _PTP.Bits.PTP7

#define PTP_PTP0_MASK                   1U
#define PTP_PTP1_MASK                   2U
#define PTP_PTP2_MASK                   4U
#define PTP_PTP3_MASK                   8U
#define PTP_PTP4_MASK                   16U
#define PTP_PTP5_MASK                   32U
#define PTP_PTP6_MASK                   64U
#define PTP_PTP7_MASK                   128U


/*** PTIP - Port P Input Register; 0x00000259 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIP0       :1;                                       /* Port P Bit 0 */
    byte PTIP1       :1;                                       /* Port P Bit 1 */
    byte PTIP2       :1;                                       /* Port P Bit 2 */
    byte PTIP3       :1;                                       /* Port P Bit 3 */
    byte PTIP4       :1;                                       /* Port P Bit 4 */
    byte PTIP5       :1;                                       /* Port P Bit 5 */
    byte PTIP6       :1;                                       /* Port P Bit 6 */
    byte PTIP7       :1;                                       /* Port P Bit 7 */
  } Bits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000259UL);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP0                      _PTIP.Bits.PTIP0
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP2                      _PTIP.Bits.PTIP2
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP6                      _PTIP.Bits.PTIP6
#define PTIP_PTIP7                      _PTIP.Bits.PTIP7

#define PTIP_PTIP0_MASK                 1U
#define PTIP_PTIP1_MASK                 2U
#define PTIP_PTIP2_MASK                 4U
#define PTIP_PTIP3_MASK                 8U
#define PTIP_PTIP4_MASK                 16U
#define PTIP_PTIP5_MASK                 32U
#define PTIP_PTIP6_MASK                 64U
#define PTIP_PTIP7_MASK                 128U


/*** DDRP - Port P Data Direction Register; 0x0000025A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRP0       :1;                                       /* Data Direction Port P Bit 0 */
    byte DDRP1       :1;                                       /* Data Direction Port P Bit 1 */
    byte DDRP2       :1;                                       /* Data Direction Port P Bit 2 */
    byte DDRP3       :1;                                       /* Data Direction Port P Bit 3 */
    byte DDRP4       :1;                                       /* Data Direction Port P Bit 4 */
    byte DDRP5       :1;                                       /* Data Direction Port P Bit 5 */
    byte DDRP6       :1;                                       /* Data Direction Port P Bit 6 */
    byte DDRP7       :1;                                       /* Data Direction Port P Bit 7 */
  } Bits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000025AUL);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP0                      _DDRP.Bits.DDRP0
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP2                      _DDRP.Bits.DDRP2
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP6                      _DDRP.Bits.DDRP6
#define DDRP_DDRP7                      _DDRP.Bits.DDRP7

#define DDRP_DDRP0_MASK                 1U
#define DDRP_DDRP1_MASK                 2U
#define DDRP_DDRP2_MASK                 4U
#define DDRP_DDRP3_MASK                 8U
#define DDRP_DDRP4_MASK                 16U
#define DDRP_DDRP5_MASK                 32U
#define DDRP_DDRP6_MASK                 64U
#define DDRP_DDRP7_MASK                 128U


/*** RDRP - Port P Reduced Drive Register; 0x0000025B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRP0       :1;                                       /* Reduced Drive Port P Bit 0 */
    byte RDRP1       :1;                                       /* Reduced Drive Port P Bit 1 */
    byte RDRP2       :1;                                       /* Reduced Drive Port P Bit 2 */
    byte RDRP3       :1;                                       /* Reduced Drive Port P Bit 3 */
    byte RDRP4       :1;                                       /* Reduced Drive Port P Bit 4 */
    byte RDRP5       :1;                                       /* Reduced Drive Port P Bit 5 */
    byte RDRP6       :1;                                       /* Reduced Drive Port P Bit 6 */
    byte RDRP7       :1;                                       /* Reduced Drive Port P Bit 7 */
  } Bits;
} RDRPSTR;
extern volatile RDRPSTR _RDRP @(REG_BASE + 0x0000025BUL);
#define RDRP                            _RDRP.Byte
#define RDRP_RDRP0                      _RDRP.Bits.RDRP0
#define RDRP_RDRP1                      _RDRP.Bits.RDRP1
#define RDRP_RDRP2                      _RDRP.Bits.RDRP2
#define RDRP_RDRP3                      _RDRP.Bits.RDRP3
#define RDRP_RDRP4                      _RDRP.Bits.RDRP4
#define RDRP_RDRP5                      _RDRP.Bits.RDRP5
#define RDRP_RDRP6                      _RDRP.Bits.RDRP6
#define RDRP_RDRP7                      _RDRP.Bits.RDRP7

#define RDRP_RDRP0_MASK                 1U
#define RDRP_RDRP1_MASK                 2U
#define RDRP_RDRP2_MASK                 4U
#define RDRP_RDRP3_MASK                 8U
#define RDRP_RDRP4_MASK                 16U
#define RDRP_RDRP5_MASK                 32U
#define RDRP_RDRP6_MASK                 64U
#define RDRP_RDRP7_MASK                 128U


/*** PERP - Port P Pull Device Enable Register; 0x0000025C ***/
typedef union {
  byte Byte;
  struct {
    byte PERP0       :1;                                       /* Pull Device Enable Port P Bit 0 */
    byte PERP1       :1;                                       /* Pull Device Enable Port P Bit 1 */
    byte PERP2       :1;                                       /* Pull Device Enable Port P Bit 2 */
    byte PERP3       :1;                                       /* Pull Device Enable Port P Bit 3 */
    byte PERP4       :1;                                       /* Pull Device Enable Port P Bit 4 */
    byte PERP5       :1;                                       /* Pull Device Enable Port P Bit 5 */
    byte PERP6       :1;                                       /* Pull Device Enable Port P Bit 6 */
    byte PERP7       :1;                                       /* Pull Device Enable Port P Bit 7 */
  } Bits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000025CUL);
#define PERP                            _PERP.Byte
#define PERP_PERP0                      _PERP.Bits.PERP0
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP2                      _PERP.Bits.PERP2
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP6                      _PERP.Bits.PERP6
#define PERP_PERP7                      _PERP.Bits.PERP7

#define PERP_PERP0_MASK                 1U
#define PERP_PERP1_MASK                 2U
#define PERP_PERP2_MASK                 4U
#define PERP_PERP3_MASK                 8U
#define PERP_PERP4_MASK                 16U
#define PERP_PERP5_MASK                 32U
#define PERP_PERP6_MASK                 64U
#define PERP_PERP7_MASK                 128U


/*** PPSP - Port P Polarity Select Register; 0x0000025D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSP0       :1;                                       /* Pull Select Port P Bit 0 */
    byte PPSP1       :1;                                       /* Pull Select Port P Bit 1 */
    byte PPSP2       :1;                                       /* Pull Select Port P Bit 2 */
    byte PPSP3       :1;                                       /* Pull Select Port P Bit 3 */
    byte PPSP4       :1;                                       /* Pull Select Port P Bit 4 */
    byte PPSP5       :1;                                       /* Pull Select Port P Bit 5 */
    byte PPSP6       :1;                                       /* Pull Select Port P Bit 6 */
    byte PPSP7       :1;                                       /* Pull Select Port P Bit 7 */
  } Bits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000025DUL);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP0                      _PPSP.Bits.PPSP0
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP2                      _PPSP.Bits.PPSP2
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP6                      _PPSP.Bits.PPSP6
#define PPSP_PPSP7                      _PPSP.Bits.PPSP7

#define PPSP_PPSP0_MASK                 1U
#define PPSP_PPSP1_MASK                 2U
#define PPSP_PPSP2_MASK                 4U
#define PPSP_PPSP3_MASK                 8U
#define PPSP_PPSP4_MASK                 16U
#define PPSP_PPSP5_MASK                 32U
#define PPSP_PPSP6_MASK                 64U
#define PPSP_PPSP7_MASK                 128U


/*** PTH - Port H I/O Register; 0x00000260 ***/
typedef union {
  byte Byte;
  struct {
    byte PTH0        :1;                                       /* Port H Bit 0 */
    byte PTH1        :1;                                       /* Port H Bit 1 */
    byte PTH2        :1;                                       /* Port H Bit 2 */
    byte PTH3        :1;                                       /* Port H Bit 3 */
    byte PTH4        :1;                                       /* Port H Bit 4 */
    byte PTH5        :1;                                       /* Port H Bit 5 */
    byte PTH6        :1;                                       /* Port H Bit 6 */
    byte PTH7        :1;                                       /* Port H Bit 7 */
  } Bits;
} PTHSTR;
extern volatile PTHSTR _PTH @(REG_BASE + 0x00000260UL);
#define PTH                             _PTH.Byte
#define PTH_PTH0                        _PTH.Bits.PTH0
#define PTH_PTH1                        _PTH.Bits.PTH1
#define PTH_PTH2                        _PTH.Bits.PTH2
#define PTH_PTH3                        _PTH.Bits.PTH3
#define PTH_PTH4                        _PTH.Bits.PTH4
#define PTH_PTH5                        _PTH.Bits.PTH5
#define PTH_PTH6                        _PTH.Bits.PTH6
#define PTH_PTH7                        _PTH.Bits.PTH7

#define PTH_PTH0_MASK                   1U
#define PTH_PTH1_MASK                   2U
#define PTH_PTH2_MASK                   4U
#define PTH_PTH3_MASK                   8U
#define PTH_PTH4_MASK                   16U
#define PTH_PTH5_MASK                   32U
#define PTH_PTH6_MASK                   64U
#define PTH_PTH7_MASK                   128U


/*** PTIH - Port H Input Register; 0x00000261 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIH0       :1;                                       /* Port H Bit 0 */
    byte PTIH1       :1;                                       /* Port H Bit 1 */
    byte PTIH2       :1;                                       /* Port H Bit 2 */
    byte PTIH3       :1;                                       /* Port H Bit 3 */
    byte PTIH4       :1;                                       /* Port H Bit 4 */
    byte PTIH5       :1;                                       /* Port H Bit 5 */
    byte PTIH6       :1;                                       /* Port H Bit 6 */
    byte PTIH7       :1;                                       /* Port H Bit 7 */
  } Bits;
} PTIHSTR;
extern volatile PTIHSTR _PTIH @(REG_BASE + 0x00000261UL);
#define PTIH                            _PTIH.Byte
#define PTIH_PTIH0                      _PTIH.Bits.PTIH0
#define PTIH_PTIH1                      _PTIH.Bits.PTIH1
#define PTIH_PTIH2                      _PTIH.Bits.PTIH2
#define PTIH_PTIH3                      _PTIH.Bits.PTIH3
#define PTIH_PTIH4                      _PTIH.Bits.PTIH4
#define PTIH_PTIH5                      _PTIH.Bits.PTIH5
#define PTIH_PTIH6                      _PTIH.Bits.PTIH6
#define PTIH_PTIH7                      _PTIH.Bits.PTIH7

#define PTIH_PTIH0_MASK                 1U
#define PTIH_PTIH1_MASK                 2U
#define PTIH_PTIH2_MASK                 4U
#define PTIH_PTIH3_MASK                 8U
#define PTIH_PTIH4_MASK                 16U
#define PTIH_PTIH5_MASK                 32U
#define PTIH_PTIH6_MASK                 64U
#define PTIH_PTIH7_MASK                 128U


/*** DDRH - Port H Data Direction Register; 0x00000262 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRH0       :1;                                       /* Data Direction Port H Bit 0 */
    byte DDRH1       :1;                                       /* Data Direction Port H Bit 1 */
    byte DDRH2       :1;                                       /* Data Direction Port H Bit 2 */
    byte DDRH3       :1;                                       /* Data Direction Port H Bit 3 */
    byte DDRH4       :1;                                       /* Data Direction Port H Bit 4 */
    byte DDRH5       :1;                                       /* Data Direction Port H Bit 5 */
    byte DDRH6       :1;                                       /* Data Direction Port H Bit 6 */
    byte DDRH7       :1;                                       /* Data Direction Port H Bit 7 */
  } Bits;
} DDRHSTR;
extern volatile DDRHSTR _DDRH @(REG_BASE + 0x00000262UL);
#define DDRH                            _DDRH.Byte
#define DDRH_DDRH0                      _DDRH.Bits.DDRH0
#define DDRH_DDRH1                      _DDRH.Bits.DDRH1
#define DDRH_DDRH2                      _DDRH.Bits.DDRH2
#define DDRH_DDRH3                      _DDRH.Bits.DDRH3
#define DDRH_DDRH4                      _DDRH.Bits.DDRH4
#define DDRH_DDRH5                      _DDRH.Bits.DDRH5
#define DDRH_DDRH6                      _DDRH.Bits.DDRH6
#define DDRH_DDRH7                      _DDRH.Bits.DDRH7

#define DDRH_DDRH0_MASK                 1U
#define DDRH_DDRH1_MASK                 2U
#define DDRH_DDRH2_MASK                 4U
#define DDRH_DDRH3_MASK                 8U
#define DDRH_DDRH4_MASK                 16U
#define DDRH_DDRH5_MASK                 32U
#define DDRH_DDRH6_MASK                 64U
#define DDRH_DDRH7_MASK                 128U


/*** RDRH - Port H Reduced Drive Register; 0x00000263 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRH0       :1;                                       /* Reduced Drive Port H Bit 0 */
    byte RDRH1       :1;                                       /* Reduced Drive Port H Bit 1 */
    byte RDRH2       :1;                                       /* Reduced Drive Port H Bit 2 */
    byte RDRH3       :1;                                       /* Reduced Drive Port H Bit 3 */
    byte RDRH4       :1;                                       /* Reduced Drive Port H Bit 4 */
    byte RDRH5       :1;                                       /* Reduced Drive Port H Bit 5 */
    byte RDRH6       :1;                                       /* Reduced Drive Port H Bit 6 */
    byte RDRH7       :1;                                       /* Reduced Drive Port H Bit 7 */
  } Bits;
} RDRHSTR;
extern volatile RDRHSTR _RDRH @(REG_BASE + 0x00000263UL);
#define RDRH                            _RDRH.Byte
#define RDRH_RDRH0                      _RDRH.Bits.RDRH0
#define RDRH_RDRH1                      _RDRH.Bits.RDRH1
#define RDRH_RDRH2                      _RDRH.Bits.RDRH2
#define RDRH_RDRH3                      _RDRH.Bits.RDRH3
#define RDRH_RDRH4                      _RDRH.Bits.RDRH4
#define RDRH_RDRH5                      _RDRH.Bits.RDRH5
#define RDRH_RDRH6                      _RDRH.Bits.RDRH6
#define RDRH_RDRH7                      _RDRH.Bits.RDRH7

#define RDRH_RDRH0_MASK                 1U
#define RDRH_RDRH1_MASK                 2U
#define RDRH_RDRH2_MASK                 4U
#define RDRH_RDRH3_MASK                 8U
#define RDRH_RDRH4_MASK                 16U
#define RDRH_RDRH5_MASK                 32U
#define RDRH_RDRH6_MASK                 64U
#define RDRH_RDRH7_MASK                 128U


/*** PERH - Port H Pull Device Enable Register; 0x00000264 ***/
typedef union {
  byte Byte;
  struct {
    byte PERH0       :1;                                       /* Pull Device Enable Port H Bit 0 */
    byte PERH1       :1;                                       /* Pull Device Enable Port H Bit 1 */
    byte PERH2       :1;                                       /* Pull Device Enable Port H Bit 2 */
    byte PERH3       :1;                                       /* Pull Device Enable Port H Bit 3 */
    byte PERH4       :1;                                       /* Pull Device Enable Port H Bit 4 */
    byte PERH5       :1;                                       /* Pull Device Enable Port H Bit 5 */
    byte PERH6       :1;                                       /* Pull Device Enable Port H Bit 6 */
    byte PERH7       :1;                                       /* Pull Device Enable Port H Bit 7 */
  } Bits;
} PERHSTR;
extern volatile PERHSTR _PERH @(REG_BASE + 0x00000264UL);
#define PERH                            _PERH.Byte
#define PERH_PERH0                      _PERH.Bits.PERH0
#define PERH_PERH1                      _PERH.Bits.PERH1
#define PERH_PERH2                      _PERH.Bits.PERH2
#define PERH_PERH3                      _PERH.Bits.PERH3
#define PERH_PERH4                      _PERH.Bits.PERH4
#define PERH_PERH5                      _PERH.Bits.PERH5
#define PERH_PERH6                      _PERH.Bits.PERH6
#define PERH_PERH7                      _PERH.Bits.PERH7

#define PERH_PERH0_MASK                 1U
#define PERH_PERH1_MASK                 2U
#define PERH_PERH2_MASK                 4U
#define PERH_PERH3_MASK                 8U
#define PERH_PERH4_MASK                 16U
#define PERH_PERH5_MASK                 32U
#define PERH_PERH6_MASK                 64U
#define PERH_PERH7_MASK                 128U


/*** PPSH - Port H Polarity Select Register; 0x00000265 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSH0       :1;                                       /* Pull Select Port H Bit 0 */
    byte PPSH1       :1;                                       /* Pull Select Port H Bit 1 */
    byte PPSH2       :1;                                       /* Pull Select Port H Bit 2 */
    byte PPSH3       :1;                                       /* Pull Select Port H Bit 3 */
    byte PPSH4       :1;                                       /* Pull Select Port H Bit 4 */
    byte PPSH5       :1;                                       /* Pull Select Port H Bit 5 */
    byte PPSH6       :1;                                       /* Pull Select Port H Bit 6 */
    byte PPSH7       :1;                                       /* Pull Select Port H Bit 7 */
  } Bits;
} PPSHSTR;
extern volatile PPSHSTR _PPSH @(REG_BASE + 0x00000265UL);
#define PPSH                            _PPSH.Byte
#define PPSH_PPSH0                      _PPSH.Bits.PPSH0
#define PPSH_PPSH1                      _PPSH.Bits.PPSH1
#define PPSH_PPSH2                      _PPSH.Bits.PPSH2
#define PPSH_PPSH3                      _PPSH.Bits.PPSH3
#define PPSH_PPSH4                      _PPSH.Bits.PPSH4
#define PPSH_PPSH5                      _PPSH.Bits.PPSH5
#define PPSH_PPSH6                      _PPSH.Bits.PPSH6
#define PPSH_PPSH7                      _PPSH.Bits.PPSH7

#define PPSH_PPSH0_MASK                 1U
#define PPSH_PPSH1_MASK                 2U
#define PPSH_PPSH2_MASK                 4U
#define PPSH_PPSH3_MASK                 8U
#define PPSH_PPSH4_MASK                 16U
#define PPSH_PPSH5_MASK                 32U
#define PPSH_PPSH6_MASK                 64U
#define PPSH_PPSH7_MASK                 128U


/*** PTJ - Port J I/O Register; 0x00000268 ***/
typedef union {
  byte Byte;
  struct {
    byte PTJ0        :1;                                       /* Port J Bit 0 */
    byte PTJ1        :1;                                       /* Port J Bit 1 */
    byte PTJ2        :1;                                       /* Port J Bit 2 */
    byte PTJ3        :1;                                       /* Port J Bit 3 */
    byte PTJ4        :1;                                       /* Port J Bit 4 */
    byte PTJ5        :1;                                       /* Port J Bit 5 */
    byte PTJ6        :1;                                       /* Port J Bit 6 */
    byte PTJ7        :1;                                       /* Port J Bit 7 */
  } Bits;
} PTJSTR;
extern volatile PTJSTR _PTJ @(REG_BASE + 0x00000268UL);
#define PTJ                             _PTJ.Byte
#define PTJ_PTJ0                        _PTJ.Bits.PTJ0
#define PTJ_PTJ1                        _PTJ.Bits.PTJ1
#define PTJ_PTJ2                        _PTJ.Bits.PTJ2
#define PTJ_PTJ3                        _PTJ.Bits.PTJ3
#define PTJ_PTJ4                        _PTJ.Bits.PTJ4
#define PTJ_PTJ5                        _PTJ.Bits.PTJ5
#define PTJ_PTJ6                        _PTJ.Bits.PTJ6
#define PTJ_PTJ7                        _PTJ.Bits.PTJ7

#define PTJ_PTJ0_MASK                   1U
#define PTJ_PTJ1_MASK                   2U
#define PTJ_PTJ2_MASK                   4U
#define PTJ_PTJ3_MASK                   8U
#define PTJ_PTJ4_MASK                   16U
#define PTJ_PTJ5_MASK                   32U
#define PTJ_PTJ6_MASK                   64U
#define PTJ_PTJ7_MASK                   128U


/*** PTIJ - Port J Input Register; 0x00000269 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIJ0       :1;                                       /* Port J Bit 0 */
    byte PTIJ1       :1;                                       /* Port J Bit 1 */
    byte PTIJ2       :1;                                       /* Port J Bit 2 */
    byte PTIJ3       :1;                                       /* Port J Bit 3 */
    byte PTIJ4       :1;                                       /* Port J Bit 4 */
    byte PTIJ5       :1;                                       /* Port J Bit 5 */
    byte PTIJ6       :1;                                       /* Port J Bit 6 */
    byte PTIJ7       :1;                                       /* Port J Bit 7 */
  } Bits;
} PTIJSTR;
extern volatile PTIJSTR _PTIJ @(REG_BASE + 0x00000269UL);
#define PTIJ                            _PTIJ.Byte
#define PTIJ_PTIJ0                      _PTIJ.Bits.PTIJ0
#define PTIJ_PTIJ1                      _PTIJ.Bits.PTIJ1
#define PTIJ_PTIJ2                      _PTIJ.Bits.PTIJ2
#define PTIJ_PTIJ3                      _PTIJ.Bits.PTIJ3
#define PTIJ_PTIJ4                      _PTIJ.Bits.PTIJ4
#define PTIJ_PTIJ5                      _PTIJ.Bits.PTIJ5
#define PTIJ_PTIJ6                      _PTIJ.Bits.PTIJ6
#define PTIJ_PTIJ7                      _PTIJ.Bits.PTIJ7

#define PTIJ_PTIJ0_MASK                 1U
#define PTIJ_PTIJ1_MASK                 2U
#define PTIJ_PTIJ2_MASK                 4U
#define PTIJ_PTIJ3_MASK                 8U
#define PTIJ_PTIJ4_MASK                 16U
#define PTIJ_PTIJ5_MASK                 32U
#define PTIJ_PTIJ6_MASK                 64U
#define PTIJ_PTIJ7_MASK                 128U


/*** DDRJ - Port J Data Direction Register; 0x0000026A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRJ0       :1;                                       /* Data Direction Port J Bit 0 */
    byte DDRJ1       :1;                                       /* Data Direction Port J Bit 1 */
    byte DDRJ2       :1;                                       /* Data Direction Port J Bit 2 */
    byte DDRJ3       :1;                                       /* Data Direction Port J Bit 3 */
    byte DDRJ4       :1;                                       /* Data Direction Port J Bit 4 */
    byte DDRJ5       :1;                                       /* Data Direction Port J Bit 5 */
    byte DDRJ6       :1;                                       /* Data Direction Port J Bit 6 */
    byte DDRJ7       :1;                                       /* Data Direction Port J Bit 7 */
  } Bits;
} DDRJSTR;
extern volatile DDRJSTR _DDRJ @(REG_BASE + 0x0000026AUL);
#define DDRJ                            _DDRJ.Byte
#define DDRJ_DDRJ0                      _DDRJ.Bits.DDRJ0
#define DDRJ_DDRJ1                      _DDRJ.Bits.DDRJ1
#define DDRJ_DDRJ2                      _DDRJ.Bits.DDRJ2
#define DDRJ_DDRJ3                      _DDRJ.Bits.DDRJ3
#define DDRJ_DDRJ4                      _DDRJ.Bits.DDRJ4
#define DDRJ_DDRJ5                      _DDRJ.Bits.DDRJ5
#define DDRJ_DDRJ6                      _DDRJ.Bits.DDRJ6
#define DDRJ_DDRJ7                      _DDRJ.Bits.DDRJ7

#define DDRJ_DDRJ0_MASK                 1U
#define DDRJ_DDRJ1_MASK                 2U
#define DDRJ_DDRJ2_MASK                 4U
#define DDRJ_DDRJ3_MASK                 8U
#define DDRJ_DDRJ4_MASK                 16U
#define DDRJ_DDRJ5_MASK                 32U
#define DDRJ_DDRJ6_MASK                 64U
#define DDRJ_DDRJ7_MASK                 128U


/*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRJ0       :1;                                       /* Reduced Drive Port J Bit 0 */
    byte RDRJ1       :1;                                       /* Reduced Drive Port J Bit 1 */
    byte RDRJ2       :1;                                       /* Reduced Drive Port J Bit 2 */
    byte RDRJ3       :1;                                       /* Reduced Drive Port J Bit 3 */
    byte RDRJ4       :1;                                       /* Reduced Drive Port J Bit 4 */
    byte RDRJ5       :1;                                       /* Reduced Drive Port J Bit 5 */
    byte RDRJ6       :1;                                       /* Reduced Drive Port J Bit 6 */
    byte RDRJ7       :1;                                       /* Reduced Drive Port J Bit 7 */
  } Bits;
} RDRJSTR;
extern volatile RDRJSTR _RDRJ @(REG_BASE + 0x0000026BUL);
#define RDRJ                            _RDRJ.Byte
#define RDRJ_RDRJ0                      _RDRJ.Bits.RDRJ0
#define RDRJ_RDRJ1                      _RDRJ.Bits.RDRJ1
#define RDRJ_RDRJ2                      _RDRJ.Bits.RDRJ2
#define RDRJ_RDRJ3                      _RDRJ.Bits.RDRJ3
#define RDRJ_RDRJ4                      _RDRJ.Bits.RDRJ4
#define RDRJ_RDRJ5                      _RDRJ.Bits.RDRJ5
#define RDRJ_RDRJ6                      _RDRJ.Bits.RDRJ6
#define RDRJ_RDRJ7                      _RDRJ.Bits.RDRJ7

#define RDRJ_RDRJ0_MASK                 1U
#define RDRJ_RDRJ1_MASK                 2U
#define RDRJ_RDRJ2_MASK                 4U
#define RDRJ_RDRJ3_MASK                 8U
#define RDRJ_RDRJ4_MASK                 16U
#define RDRJ_RDRJ5_MASK                 32U
#define RDRJ_RDRJ6_MASK                 64U
#define RDRJ_RDRJ7_MASK                 128U


/*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***/
typedef union {
  byte Byte;
  struct {
    byte PERJ0       :1;                                       /* Pull Device Enable Port J Bit 0 */
    byte PERJ1       :1;                                       /* Pull Device Enable Port J Bit 1 */
    byte PERJ2       :1;                                       /* Pull Device Enable Port J Bit 2 */
    byte PERJ3       :1;                                       /* Pull Device Enable Port J Bit 3 */
    byte PERJ4       :1;                                       /* Pull Device Enable Port J Bit 4 */
    byte PERJ5       :1;                                       /* Pull Device Enable Port J Bit 5 */
    byte PERJ6       :1;                                       /* Pull Device Enable Port J Bit 6 */
    byte PERJ7       :1;                                       /* Pull Device Enable Port J Bit 7 */
  } Bits;
} PERJSTR;
extern volatile PERJSTR _PERJ @(REG_BASE + 0x0000026CUL);
#define PERJ                            _PERJ.Byte
#define PERJ_PERJ0                      _PERJ.Bits.PERJ0
#define PERJ_PERJ1                      _PERJ.Bits.PERJ1
#define PERJ_PERJ2                      _PERJ.Bits.PERJ2
#define PERJ_PERJ3                      _PERJ.Bits.PERJ3
#define PERJ_PERJ4                      _PERJ.Bits.PERJ4
#define PERJ_PERJ5                      _PERJ.Bits.PERJ5
#define PERJ_PERJ6                      _PERJ.Bits.PERJ6
#define PERJ_PERJ7                      _PERJ.Bits.PERJ7

#define PERJ_PERJ0_MASK                 1U
#define PERJ_PERJ1_MASK                 2U
#define PERJ_PERJ2_MASK                 4U
#define PERJ_PERJ3_MASK                 8U
#define PERJ_PERJ4_MASK                 16U
#define PERJ_PERJ5_MASK                 32U
#define PERJ_PERJ6_MASK                 64U
#define PERJ_PERJ7_MASK                 128U


/*** PPSJ - Port J Polarity Select Register; 0x0000026D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSJ0       :1;                                       /* Pull Select Port J Bit 0 */
    byte PPSJ1       :1;                                       /* Pull Select Port J Bit 1 */
    byte PPSJ2       :1;                                       /* Pull Select Port J Bit 2 */
    byte PPSJ3       :1;                                       /* Pull Select Port J Bit 3 */
    byte PPSJ4       :1;                                       /* Pull Select Port J Bit 4 */
    byte PPSJ5       :1;                                       /* Pull Select Port J Bit 5 */
    byte PPSJ6       :1;                                       /* Pull Select Port J Bit 6 */
    byte PPSJ7       :1;                                       /* Pull Select Port J Bit 7 */
  } Bits;
} PPSJSTR;
extern volatile PPSJSTR _PPSJ @(REG_BASE + 0x0000026DUL);
#define PPSJ                            _PPSJ.Byte
#define PPSJ_PPSJ0                      _PPSJ.Bits.PPSJ0
#define PPSJ_PPSJ1                      _PPSJ.Bits.PPSJ1
#define PPSJ_PPSJ2                      _PPSJ.Bits.PPSJ2
#define PPSJ_PPSJ3                      _PPSJ.Bits.PPSJ3
#define PPSJ_PPSJ4                      _PPSJ.Bits.PPSJ4
#define PPSJ_PPSJ5                      _PPSJ.Bits.PPSJ5
#define PPSJ_PPSJ6                      _PPSJ.Bits.PPSJ6
#define PPSJ_PPSJ7                      _PPSJ.Bits.PPSJ7

#define PPSJ_PPSJ0_MASK                 1U
#define PPSJ_PPSJ1_MASK                 2U
#define PPSJ_PPSJ2_MASK                 4U
#define PPSJ_PPSJ3_MASK                 8U
#define PPSJ_PPSJ4_MASK                 16U
#define PPSJ_PPSJ5_MASK                 32U
#define PPSJ_PPSJ6_MASK                 64U
#define PPSJ_PPSJ7_MASK                 128U


/*** PT01AD - Port AD Data Register; 0x00000270 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PT0AD - Port AD Data Register 1; 0x00000270 ***/
    union {
      byte Byte;
      struct {
        byte PT0AD8      :1;                                       /* Port AD Data Bit 8 */
        byte PT0AD9      :1;                                       /* Port AD Data Bit 9 */
        byte PT0AD10     :1;                                       /* Port AD Data Bit 10 */
        byte PT0AD11     :1;                                       /* Port AD Data Bit 11 */
        byte PT0AD12     :1;                                       /* Port AD Data Bit 12 */
        byte PT0AD13     :1;                                       /* Port AD Data Bit 13 */
        byte PT0AD14     :1;                                       /* Port AD Data Bit 14 */
        byte PT0AD15     :1;                                       /* Port AD Data Bit 15 */
      } Bits;
    } PT0ADSTR;
    #define PT0AD                       _PT01AD.Overlap_STR.PT0ADSTR.Byte
    #define PT0AD_PT0AD8                _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD8
    #define PT0AD_PT0AD9                _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD9
    #define PT0AD_PT0AD10               _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD10
    #define PT0AD_PT0AD11               _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD11
    #define PT0AD_PT0AD12               _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD12
    #define PT0AD_PT0AD13               _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD13
    #define PT0AD_PT0AD14               _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD14
    #define PT0AD_PT0AD15               _PT01AD.Overlap_STR.PT0ADSTR.Bits.PT0AD15
    
    #define PT0AD_PT0AD8_MASK           1U
    #define PT0AD_PT0AD9_MASK           2U
    #define PT0AD_PT0AD10_MASK          4U
    #define PT0AD_PT0AD11_MASK          8U
    #define PT0AD_PT0AD12_MASK          16U
    #define PT0AD_PT0AD13_MASK          32U
    #define PT0AD_PT0AD14_MASK          64U
    #define PT0AD_PT0AD15_MASK          128U
    

    /*** PT1AD - Port AD Data Register 1; 0x00000271 ***/
    union {
      byte Byte;
      struct {
        byte PT1AD0      :1;                                       /* Port AD Data Bit 0 */
        byte PT1AD1      :1;                                       /* Port AD Data Bit 1 */
        byte PT1AD2      :1;                                       /* Port AD Data Bit 2 */
        byte PT1AD3      :1;                                       /* Port AD Data Bit 3 */
        byte PT1AD4      :1;                                       /* Port AD Data Bit 4 */
        byte PT1AD5      :1;                                       /* Port AD Data Bit 5 */
        byte PT1AD6      :1;                                       /* Port AD Data Bit 6 */
        byte PT1AD7      :1;                                       /* Port AD Data Bit 7 */
      } Bits;
    } PT1ADSTR;
    #define PT1AD                       _PT01AD.Overlap_STR.PT1ADSTR.Byte
    #define PT1AD_PT1AD0                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD0
    #define PT1AD_PT1AD1                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD1
    #define PT1AD_PT1AD2                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD2
    #define PT1AD_PT1AD3                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD3
    #define PT1AD_PT1AD4                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD4
    #define PT1AD_PT1AD5                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD5
    #define PT1AD_PT1AD6                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD6
    #define PT1AD_PT1AD7                _PT01AD.Overlap_STR.PT1ADSTR.Bits.PT1AD7
    
    #define PT1AD_PT1AD0_MASK           1U
    #define PT1AD_PT1AD1_MASK           2U
    #define PT1AD_PT1AD2_MASK           4U
    #define PT1AD_PT1AD3_MASK           8U
    #define PT1AD_PT1AD4_MASK           16U
    #define PT1AD_PT1AD5_MASK           32U
    #define PT1AD_PT1AD6_MASK           64U
    #define PT1AD_PT1AD7_MASK           128U
    
  } Overlap_STR;

  struct {
    word PT1AD0      :1;                                       /* Port AD Data Bit 0 */
    word PT1AD1      :1;                                       /* Port AD Data Bit 1 */
    word PT1AD2      :1;                                       /* Port AD Data Bit 2 */
    word PT1AD3      :1;                                       /* Port AD Data Bit 3 */
    word PT1AD4      :1;                                       /* Port AD Data Bit 4 */
    word PT1AD5      :1;                                       /* Port AD Data Bit 5 */
    word PT1AD6      :1;                                       /* Port AD Data Bit 6 */
    word PT1AD7      :1;                                       /* Port AD Data Bit 7 */
    word PT0AD8      :1;                                       /* Port AD Data Bit 8 */
    word PT0AD9      :1;                                       /* Port AD Data Bit 9 */
    word PT0AD10     :1;                                       /* Port AD Data Bit 10 */
    word PT0AD11     :1;                                       /* Port AD Data Bit 11 */
    word PT0AD12     :1;                                       /* Port AD Data Bit 12 */
    word PT0AD13     :1;                                       /* Port AD Data Bit 13 */
    word PT0AD14     :1;                                       /* Port AD Data Bit 14 */
    word PT0AD15     :1;                                       /* Port AD Data Bit 15 */
  } Bits;
  struct {
    word grpPT1AD :8;
    word grpPT0AD_8 :8;
  } MergedBits;
} PT01ADSTR;
extern volatile PT01ADSTR _PT01AD @(REG_BASE + 0x00000270UL);
#define PT01AD                          _PT01AD.Word
#define PT01AD_PT1AD0                   _PT01AD.Bits.PT1AD0
#define PT01AD_PT1AD1                   _PT01AD.Bits.PT1AD1
#define PT01AD_PT1AD2                   _PT01AD.Bits.PT1AD2
#define PT01AD_PT1AD3                   _PT01AD.Bits.PT1AD3
#define PT01AD_PT1AD4                   _PT01AD.Bits.PT1AD4
#define PT01AD_PT1AD5                   _PT01AD.Bits.PT1AD5
#define PT01AD_PT1AD6                   _PT01AD.Bits.PT1AD6
#define PT01AD_PT1AD7                   _PT01AD.Bits.PT1AD7
#define PT01AD_PT0AD8                   _PT01AD.Bits.PT0AD8
#define PT01AD_PT0AD9                   _PT01AD.Bits.PT0AD9
#define PT01AD_PT0AD10                  _PT01AD.Bits.PT0AD10
#define PT01AD_PT0AD11                  _PT01AD.Bits.PT0AD11
#define PT01AD_PT0AD12                  _PT01AD.Bits.PT0AD12
#define PT01AD_PT0AD13                  _PT01AD.Bits.PT0AD13
#define PT01AD_PT0AD14                  _PT01AD.Bits.PT0AD14
#define PT01AD_PT0AD15                  _PT01AD.Bits.PT0AD15
#define PT01AD_PT1AD                    _PT01AD.MergedBits.grpPT1AD
#define PT01AD_PT0AD_8                  _PT01AD.MergedBits.grpPT0AD_8
#define PT01AD_PT0AD                    PT01AD_PT0AD_8

#define PT01AD_PT1AD0_MASK              1U
#define PT01AD_PT1AD1_MASK              2U
#define PT01AD_PT1AD2_MASK              4U
#define PT01AD_PT1AD3_MASK              8U
#define PT01AD_PT1AD4_MASK              16U
#define PT01AD_PT1AD5_MASK              32U
#define PT01AD_PT1AD6_MASK              64U
#define PT01AD_PT1AD7_MASK              128U
#define PT01AD_PT0AD8_MASK              256U
#define PT01AD_PT0AD9_MASK              512U
#define PT01AD_PT0AD10_MASK             1024U
#define PT01AD_PT0AD11_MASK             2048U
#define PT01AD_PT0AD12_MASK             4096U
#define PT01AD_PT0AD13_MASK             8192U
#define PT01AD_PT0AD14_MASK             16384U
#define PT01AD_PT0AD15_MASK             32768U
#define PT01AD_PT1AD_MASK               255U
#define PT01AD_PT1AD_BITNUM             0U
#define PT01AD_PT0AD_8_MASK             65280U
#define PT01AD_PT0AD_8_BITNUM           8U


/*** DDR01AD - Port AD Data Direction Register; 0x00000272 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDR0AD - Port AD Data Direction Register 0; 0x00000272 ***/
    union {
      byte Byte;
      struct {
        byte DDR0AD8     :1;                                       /* Port AD Data Direction Bit 8 */
        byte DDR0AD9     :1;                                       /* Port AD Data Direction Bit 9 */
        byte DDR0AD10    :1;                                       /* Port AD Data Direction Bit 10 */
        byte DDR0AD11    :1;                                       /* Port AD Data Direction Bit 11 */
        byte DDR0AD12    :1;                                       /* Port AD Data Direction Bit 12 */
        byte DDR0AD13    :1;                                       /* Port AD Data Direction Bit 13 */
        byte DDR0AD14    :1;                                       /* Port AD Data Direction Bit 14 */
        byte DDR0AD15    :1;                                       /* Port AD Data Direction Bit 15 */
      } Bits;
    } DDR0ADSTR;
    #define DDR0AD                      _DDR01AD.Overlap_STR.DDR0ADSTR.Byte
    #define DDR0AD_DDR0AD8              _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD8
    #define DDR0AD_DDR0AD9              _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD9
    #define DDR0AD_DDR0AD10             _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD10
    #define DDR0AD_DDR0AD11             _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD11
    #define DDR0AD_DDR0AD12             _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD12
    #define DDR0AD_DDR0AD13             _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD13
    #define DDR0AD_DDR0AD14             _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD14
    #define DDR0AD_DDR0AD15             _DDR01AD.Overlap_STR.DDR0ADSTR.Bits.DDR0AD15
    
    #define DDR0AD_DDR0AD8_MASK         1U
    #define DDR0AD_DDR0AD9_MASK         2U
    #define DDR0AD_DDR0AD10_MASK        4U
    #define DDR0AD_DDR0AD11_MASK        8U
    #define DDR0AD_DDR0AD12_MASK        16U
    #define DDR0AD_DDR0AD13_MASK        32U
    #define DDR0AD_DDR0AD14_MASK        64U
    #define DDR0AD_DDR0AD15_MASK        128U
    

    /*** DDR1AD - Port AD Data Direction Register 1; 0x00000273 ***/
    union {
      byte Byte;
      struct {
        byte DDR1AD0     :1;                                       /* Port AD Data Direction Bit 0 */
        byte DDR1AD1     :1;                                       /* Port AD Data Direction Bit 1 */
        byte DDR1AD2     :1;                                       /* Port AD Data Direction Bit 2 */
        byte DDR1AD3     :1;                                       /* Port AD Data Direction Bit 3 */
        byte DDR1AD4     :1;                                       /* Port AD Data Direction Bit 4 */
        byte DDR1AD5     :1;                                       /* Port AD Data Direction Bit 5 */
        byte DDR1AD6     :1;                                       /* Port AD Data Direction Bit 6 */
        byte DDR1AD7     :1;                                       /* Port AD Data Direction Bit 7 */
      } Bits;
    } DDR1ADSTR;
    #define DDR1AD                      _DDR01AD.Overlap_STR.DDR1ADSTR.Byte
    #define DDR1AD_DDR1AD0              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD0
    #define DDR1AD_DDR1AD1              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD1
    #define DDR1AD_DDR1AD2              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD2
    #define DDR1AD_DDR1AD3              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD3
    #define DDR1AD_DDR1AD4              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD4
    #define DDR1AD_DDR1AD5              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD5
    #define DDR1AD_DDR1AD6              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD6
    #define DDR1AD_DDR1AD7              _DDR01AD.Overlap_STR.DDR1ADSTR.Bits.DDR1AD7
    
    #define DDR1AD_DDR1AD0_MASK         1U
    #define DDR1AD_DDR1AD1_MASK         2U
    #define DDR1AD_DDR1AD2_MASK         4U
    #define DDR1AD_DDR1AD3_MASK         8U
    #define DDR1AD_DDR1AD4_MASK         16U
    #define DDR1AD_DDR1AD5_MASK         32U
    #define DDR1AD_DDR1AD6_MASK         64U
    #define DDR1AD_DDR1AD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word DDR1AD0     :1;                                       /* Port AD Data Direction Bit 0 */
    word DDR1AD1     :1;                                       /* Port AD Data Direction Bit 1 */
    word DDR1AD2     :1;                                       /* Port AD Data Direction Bit 2 */
    word DDR1AD3     :1;                                       /* Port AD Data Direction Bit 3 */
    word DDR1AD4     :1;                                       /* Port AD Data Direction Bit 4 */
    word DDR1AD5     :1;                                       /* Port AD Data Direction Bit 5 */
    word DDR1AD6     :1;                                       /* Port AD Data Direction Bit 6 */
    word DDR1AD7     :1;                                       /* Port AD Data Direction Bit 7 */
    word DDR0AD8     :1;                                       /* Port AD Data Direction Bit 8 */
    word DDR0AD9     :1;                                       /* Port AD Data Direction Bit 9 */
    word DDR0AD10    :1;                                       /* Port AD Data Direction Bit 10 */
    word DDR0AD11    :1;                                       /* Port AD Data Direction Bit 11 */
    word DDR0AD12    :1;                                       /* Port AD Data Direction Bit 12 */
    word DDR0AD13    :1;                                       /* Port AD Data Direction Bit 13 */
    word DDR0AD14    :1;                                       /* Port AD Data Direction Bit 14 */
    word DDR0AD15    :1;                                       /* Port AD Data Direction Bit 15 */
  } Bits;
  struct {
    word grpDDR1AD :8;
    word grpDDR0AD_8 :8;
  } MergedBits;
} DDR01ADSTR;
extern volatile DDR01ADSTR _DDR01AD @(REG_BASE + 0x00000272UL);
#define DDR01AD                         _DDR01AD.Word
#define DDR01AD_DDR1AD0                 _DDR01AD.Bits.DDR1AD0
#define DDR01AD_DDR1AD1                 _DDR01AD.Bits.DDR1AD1
#define DDR01AD_DDR1AD2                 _DDR01AD.Bits.DDR1AD2
#define DDR01AD_DDR1AD3                 _DDR01AD.Bits.DDR1AD3
#define DDR01AD_DDR1AD4                 _DDR01AD.Bits.DDR1AD4
#define DDR01AD_DDR1AD5                 _DDR01AD.Bits.DDR1AD5
#define DDR01AD_DDR1AD6                 _DDR01AD.Bits.DDR1AD6
#define DDR01AD_DDR1AD7                 _DDR01AD.Bits.DDR1AD7
#define DDR01AD_DDR0AD8                 _DDR01AD.Bits.DDR0AD8
#define DDR01AD_DDR0AD9                 _DDR01AD.Bits.DDR0AD9
#define DDR01AD_DDR0AD10                _DDR01AD.Bits.DDR0AD10
#define DDR01AD_DDR0AD11                _DDR01AD.Bits.DDR0AD11
#define DDR01AD_DDR0AD12                _DDR01AD.Bits.DDR0AD12
#define DDR01AD_DDR0AD13                _DDR01AD.Bits.DDR0AD13
#define DDR01AD_DDR0AD14                _DDR01AD.Bits.DDR0AD14
#define DDR01AD_DDR0AD15                _DDR01AD.Bits.DDR0AD15
#define DDR01AD_DDR1AD                  _DDR01AD.MergedBits.grpDDR1AD
#define DDR01AD_DDR0AD_8                _DDR01AD.MergedBits.grpDDR0AD_8
#define DDR01AD_DDR0AD                  DDR01AD_DDR0AD_8

#define DDR01AD_DDR1AD0_MASK            1U
#define DDR01AD_DDR1AD1_MASK            2U
#define DDR01AD_DDR1AD2_MASK            4U
#define DDR01AD_DDR1AD3_MASK            8U
#define DDR01AD_DDR1AD4_MASK            16U
#define DDR01AD_DDR1AD5_MASK            32U
#define DDR01AD_DDR1AD6_MASK            64U
#define DDR01AD_DDR1AD7_MASK            128U
#define DDR01AD_DDR0AD8_MASK            256U
#define DDR01AD_DDR0AD9_MASK            512U
#define DDR01AD_DDR0AD10_MASK           1024U
#define DDR01AD_DDR0AD11_MASK           2048U
#define DDR01AD_DDR0AD12_MASK           4096U
#define DDR01AD_DDR0AD13_MASK           8192U
#define DDR01AD_DDR0AD14_MASK           16384U
#define DDR01AD_DDR0AD15_MASK           32768U
#define DDR01AD_DDR1AD_MASK             255U
#define DDR01AD_DDR1AD_BITNUM           0U
#define DDR01AD_DDR0AD_8_MASK           65280U
#define DDR01AD_DDR0AD_8_BITNUM         8U


/*** RDR01AD - Port AD Reduced Drive Register; 0x00000274 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** RDR0AD - Port AD Reduced Drive Register 0; 0x00000274 ***/
    union {
      byte Byte;
      struct {
        byte RDR0AD8     :1;                                       /* Port AD Reduced Drive Bit 8 */
        byte RDR0AD9     :1;                                       /* Port AD Reduced Drive Bit 9 */
        byte RDR0AD10    :1;                                       /* Port AD Reduced Drive Bit 10 */
        byte RDR0AD11    :1;                                       /* Port AD Reduced Drive Bit 11 */
        byte RDR0AD12    :1;                                       /* Port AD Reduced Drive Bit 12 */
        byte RDR0AD13    :1;                                       /* Port AD Reduced Drive Bit 13 */
        byte RDR0AD14    :1;                                       /* Port AD Reduced Drive Bit 14 */
        byte RDR0AD15    :1;                                       /* Port AD Reduced Drive Bit 15 */
      } Bits;
    } RDR0ADSTR;
    #define RDR0AD                      _RDR01AD.Overlap_STR.RDR0ADSTR.Byte
    #define RDR0AD_RDR0AD8              _RDR01AD.Overlap_STR.RDR0ADSTR.Bits.RDR0AD8
    #define RDR0AD_RDR0AD9              _RDR01AD.Overlap_STR.RDR0ADSTR.Bits.RDR0AD9
    #define RDR0AD_RDR0AD10             _RDR01AD.Overlap_STR.RDR0ADSTR.Bits.RDR0AD10
    #define RDR0AD_RDR0AD11             _RDR01AD.Overlap_STR.RDR0ADSTR.Bits.RDR0AD11
    #define RDR0AD_RDR0AD12             _RDR01AD.Overlap_STR.RDR0ADSTR.Bits.RDR0AD12
    #define RDR0AD_RDR0AD13             _RDR01AD.Overlap_STR.RDR0ADSTR.Bits.RDR0AD13
    #define RDR0AD_RDR0AD14             _RDR01AD.Overlap_STR.RDR0ADSTR.Bits.RDR0AD14
    #define RDR0AD_RDR0AD15             _RDR01AD.Overlap_STR.RDR0ADSTR.Bits.RDR0AD15
    
    #define RDR0AD_RDR0AD8_MASK         1U
    #define RDR0AD_RDR0AD9_MASK         2U
    #define RDR0AD_RDR0AD10_MASK        4U
    #define RDR0AD_RDR0AD11_MASK        8U
    #define RDR0AD_RDR0AD12_MASK        16U
    #define RDR0AD_RDR0AD13_MASK        32U
    #define RDR0AD_RDR0AD14_MASK        64U
    #define RDR0AD_RDR0AD15_MASK        128U
    

    /*** RDR1AD - Port AD Reduced Drive Register 1; 0x00000275 ***/
    union {
      byte Byte;
      struct {
        byte RDR1AD0     :1;                                       /* Port AD Reduced Drive Bit 0 */
        byte RDR1AD1     :1;                                       /* Port AD Reduced Drive Bit 1 */
        byte RDR1AD2     :1;                                       /* Port AD Reduced Drive Bit 2 */
        byte RDR1AD3     :1;                                       /* Port AD Reduced Drive Bit 3 */
        byte RDR1AD4     :1;                                       /* Port AD Reduced Drive Bit 4 */
        byte RDR1AD5     :1;                                       /* Port AD Reduced Drive Bit 5 */
        byte RDR1AD6     :1;                                       /* Port AD Reduced Drive Bit 6 */
        byte RDR1AD7     :1;                                       /* Port AD Reduced Drive Bit 7 */
      } Bits;
    } RDR1ADSTR;
    #define RDR1AD                      _RDR01AD.Overlap_STR.RDR1ADSTR.Byte
    #define RDR1AD_RDR1AD0              _RDR01AD.Overlap_STR.RDR1ADSTR.Bits.RDR1AD0
    #define RDR1AD_RDR1AD1              _RDR01AD.Overlap_STR.RDR1ADSTR.Bits.RDR1AD1
    #define RDR1AD_RDR1AD2              _RDR01AD.Overlap_STR.RDR1ADSTR.Bits.RDR1AD2
    #define RDR1AD_RDR1AD3              _RDR01AD.Overlap_STR.RDR1ADSTR.Bits.RDR1AD3
    #define RDR1AD_RDR1AD4              _RDR01AD.Overlap_STR.RDR1ADSTR.Bits.RDR1AD4
    #define RDR1AD_RDR1AD5              _RDR01AD.Overlap_STR.RDR1ADSTR.Bits.RDR1AD5
    #define RDR1AD_RDR1AD6              _RDR01AD.Overlap_STR.RDR1ADSTR.Bits.RDR1AD6
    #define RDR1AD_RDR1AD7              _RDR01AD.Overlap_STR.RDR1ADSTR.Bits.RDR1AD7
    
    #define RDR1AD_RDR1AD0_MASK         1U
    #define RDR1AD_RDR1AD1_MASK         2U
    #define RDR1AD_RDR1AD2_MASK         4U
    #define RDR1AD_RDR1AD3_MASK         8U
    #define RDR1AD_RDR1AD4_MASK         16U
    #define RDR1AD_RDR1AD5_MASK         32U
    #define RDR1AD_RDR1AD6_MASK         64U
    #define RDR1AD_RDR1AD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word RDR1AD0     :1;                                       /* Port AD Reduced Drive Bit 0 */
    word RDR1AD1     :1;                                       /* Port AD Reduced Drive Bit 1 */
    word RDR1AD2     :1;                                       /* Port AD Reduced Drive Bit 2 */
    word RDR1AD3     :1;                                       /* Port AD Reduced Drive Bit 3 */
    word RDR1AD4     :1;                                       /* Port AD Reduced Drive Bit 4 */
    word RDR1AD5     :1;                                       /* Port AD Reduced Drive Bit 5 */
    word RDR1AD6     :1;                                       /* Port AD Reduced Drive Bit 6 */
    word RDR1AD7     :1;                                       /* Port AD Reduced Drive Bit 7 */
    word RDR0AD8     :1;                                       /* Port AD Reduced Drive Bit 8 */
    word RDR0AD9     :1;                                       /* Port AD Reduced Drive Bit 9 */
    word RDR0AD10    :1;                                       /* Port AD Reduced Drive Bit 10 */
    word RDR0AD11    :1;                                       /* Port AD Reduced Drive Bit 11 */
    word RDR0AD12    :1;                                       /* Port AD Reduced Drive Bit 12 */
    word RDR0AD13    :1;                                       /* Port AD Reduced Drive Bit 13 */
    word RDR0AD14    :1;                                       /* Port AD Reduced Drive Bit 14 */
    word RDR0AD15    :1;                                       /* Port AD Reduced Drive Bit 15 */
  } Bits;
  struct {
    word grpRDR1AD :8;
    word grpRDR0AD_8 :8;
  } MergedBits;
} RDR01ADSTR;
extern volatile RDR01ADSTR _RDR01AD @(REG_BASE + 0x00000274UL);
#define RDR01AD                         _RDR01AD.Word
#define RDR01AD_RDR1AD0                 _RDR01AD.Bits.RDR1AD0
#define RDR01AD_RDR1AD1                 _RDR01AD.Bits.RDR1AD1
#define RDR01AD_RDR1AD2                 _RDR01AD.Bits.RDR1AD2
#define RDR01AD_RDR1AD3                 _RDR01AD.Bits.RDR1AD3
#define RDR01AD_RDR1AD4                 _RDR01AD.Bits.RDR1AD4
#define RDR01AD_RDR1AD5                 _RDR01AD.Bits.RDR1AD5
#define RDR01AD_RDR1AD6                 _RDR01AD.Bits.RDR1AD6
#define RDR01AD_RDR1AD7                 _RDR01AD.Bits.RDR1AD7
#define RDR01AD_RDR0AD8                 _RDR01AD.Bits.RDR0AD8
#define RDR01AD_RDR0AD9                 _RDR01AD.Bits.RDR0AD9
#define RDR01AD_RDR0AD10                _RDR01AD.Bits.RDR0AD10
#define RDR01AD_RDR0AD11                _RDR01AD.Bits.RDR0AD11
#define RDR01AD_RDR0AD12                _RDR01AD.Bits.RDR0AD12
#define RDR01AD_RDR0AD13                _RDR01AD.Bits.RDR0AD13
#define RDR01AD_RDR0AD14                _RDR01AD.Bits.RDR0AD14
#define RDR01AD_RDR0AD15                _RDR01AD.Bits.RDR0AD15
#define RDR01AD_RDR1AD                  _RDR01AD.MergedBits.grpRDR1AD
#define RDR01AD_RDR0AD_8                _RDR01AD.MergedBits.grpRDR0AD_8
#define RDR01AD_RDR0AD                  RDR01AD_RDR0AD_8

#define RDR01AD_RDR1AD0_MASK            1U
#define RDR01AD_RDR1AD1_MASK            2U
#define RDR01AD_RDR1AD2_MASK            4U
#define RDR01AD_RDR1AD3_MASK            8U
#define RDR01AD_RDR1AD4_MASK            16U
#define RDR01AD_RDR1AD5_MASK            32U
#define RDR01AD_RDR1AD6_MASK            64U
#define RDR01AD_RDR1AD7_MASK            128U
#define RDR01AD_RDR0AD8_MASK            256U
#define RDR01AD_RDR0AD9_MASK            512U
#define RDR01AD_RDR0AD10_MASK           1024U
#define RDR01AD_RDR0AD11_MASK           2048U
#define RDR01AD_RDR0AD12_MASK           4096U
#define RDR01AD_RDR0AD13_MASK           8192U
#define RDR01AD_RDR0AD14_MASK           16384U
#define RDR01AD_RDR0AD15_MASK           32768U
#define RDR01AD_RDR1AD_MASK             255U
#define RDR01AD_RDR1AD_BITNUM           0U
#define RDR01AD_RDR0AD_8_MASK           65280U
#define RDR01AD_RDR0AD_8_BITNUM         8U


/*** PER01AD - Port AD Pull Up Enable Register; 0x00000276 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PER0AD - Port AD Pull Up Enable Register 0; 0x00000276 ***/
    union {
      byte Byte;
      struct {
        byte PER0AD8     :1;                                       /* Port AD Pull Up Enable Bit 8 */
        byte PER0AD9     :1;                                       /* Port AD Pull Up Enable Bit 9 */
        byte PER0AD10    :1;                                       /* Port AD Pull Up Enable Bit 10 */
        byte PER0AD11    :1;                                       /* Port AD Pull Up Enable Bit 11 */
        byte PER0AD12    :1;                                       /* Port AD Pull Up Enable Bit 12 */
        byte PER0AD13    :1;                                       /* Port AD Pull Up Enable Bit 13 */
        byte PER0AD14    :1;                                       /* Port AD Pull Up Enable Bit 14 */
        byte PER0AD15    :1;                                       /* Port AD Pull Up Enable Bit 15 */
      } Bits;
    } PER0ADSTR;
    #define PER0AD                      _PER01AD.Overlap_STR.PER0ADSTR.Byte
    #define PER0AD_PER0AD8              _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD8
    #define PER0AD_PER0AD9              _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD9
    #define PER0AD_PER0AD10             _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD10
    #define PER0AD_PER0AD11             _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD11
    #define PER0AD_PER0AD12             _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD12
    #define PER0AD_PER0AD13             _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD13
    #define PER0AD_PER0AD14             _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD14
    #define PER0AD_PER0AD15             _PER01AD.Overlap_STR.PER0ADSTR.Bits.PER0AD15
    
    #define PER0AD_PER0AD8_MASK         1U
    #define PER0AD_PER0AD9_MASK         2U
    #define PER0AD_PER0AD10_MASK        4U
    #define PER0AD_PER0AD11_MASK        8U
    #define PER0AD_PER0AD12_MASK        16U
    #define PER0AD_PER0AD13_MASK        32U
    #define PER0AD_PER0AD14_MASK        64U
    #define PER0AD_PER0AD15_MASK        128U
    

    /*** PER1AD - Port AD Pull Up Enable Register 1; 0x00000277 ***/
    union {
      byte Byte;
      struct {
        byte PER1AD0     :1;                                       /* Port AD Pull Up Enable Bit 0 */
        byte PER1AD1     :1;                                       /* Port AD Pull Up Enable Bit 1 */
        byte PER1AD2     :1;                                       /* Port AD Pull Up Enable Bit 2 */
        byte PER1AD3     :1;                                       /* Port AD Pull Up Enable Bit 3 */
        byte PER1AD4     :1;                                       /* Port AD Pull Up Enable Bit 4 */
        byte PER1AD5     :1;                                       /* Port AD Pull Up Enable Bit 5 */
        byte PER1AD6     :1;                                       /* Port AD Pull Up Enable Bit 6 */
        byte PER1AD7     :1;                                       /* Port AD Pull Up Enable Bit 7 */
      } Bits;
    } PER1ADSTR;
    #define PER1AD                      _PER01AD.Overlap_STR.PER1ADSTR.Byte
    #define PER1AD_PER1AD0              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD0
    #define PER1AD_PER1AD1              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD1
    #define PER1AD_PER1AD2              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD2
    #define PER1AD_PER1AD3              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD3
    #define PER1AD_PER1AD4              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD4
    #define PER1AD_PER1AD5              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD5
    #define PER1AD_PER1AD6              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD6
    #define PER1AD_PER1AD7              _PER01AD.Overlap_STR.PER1ADSTR.Bits.PER1AD7
    
    #define PER1AD_PER1AD0_MASK         1U
    #define PER1AD_PER1AD1_MASK         2U
    #define PER1AD_PER1AD2_MASK         4U
    #define PER1AD_PER1AD3_MASK         8U
    #define PER1AD_PER1AD4_MASK         16U
    #define PER1AD_PER1AD5_MASK         32U
    #define PER1AD_PER1AD6_MASK         64U
    #define PER1AD_PER1AD7_MASK         128U
    
  } Overlap_STR;

  struct {
    word PER1AD0     :1;                                       /* Port AD Pull Up Enable Bit 0 */
    word PER1AD1     :1;                                       /* Port AD Pull Up Enable Bit 1 */
    word PER1AD2     :1;                                       /* Port AD Pull Up Enable Bit 2 */
    word PER1AD3     :1;                                       /* Port AD Pull Up Enable Bit 3 */
    word PER1AD4     :1;                                       /* Port AD Pull Up Enable Bit 4 */
    word PER1AD5     :1;                                       /* Port AD Pull Up Enable Bit 5 */
    word PER1AD6     :1;                                       /* Port AD Pull Up Enable Bit 6 */
    word PER1AD7     :1;                                       /* Port AD Pull Up Enable Bit 7 */
    word PER0AD8     :1;                                       /* Port AD Pull Up Enable Bit 8 */
    word PER0AD9     :1;                                       /* Port AD Pull Up Enable Bit 9 */
    word PER0AD10    :1;                                       /* Port AD Pull Up Enable Bit 10 */
    word PER0AD11    :1;                                       /* Port AD Pull Up Enable Bit 11 */
    word PER0AD12    :1;                                       /* Port AD Pull Up Enable Bit 12 */
    word PER0AD13    :1;                                       /* Port AD Pull Up Enable Bit 13 */
    word PER0AD14    :1;                                       /* Port AD Pull Up Enable Bit 14 */
    word PER0AD15    :1;                                       /* Port AD Pull Up Enable Bit 15 */
  } Bits;
  struct {
    word grpPER1AD :8;
    word grpPER0AD_8 :8;
  } MergedBits;
} PER01ADSTR;
extern volatile PER01ADSTR _PER01AD @(REG_BASE + 0x00000276UL);
#define PER01AD                         _PER01AD.Word
#define PER01AD_PER1AD0                 _PER01AD.Bits.PER1AD0
#define PER01AD_PER1AD1                 _PER01AD.Bits.PER1AD1
#define PER01AD_PER1AD2                 _PER01AD.Bits.PER1AD2
#define PER01AD_PER1AD3                 _PER01AD.Bits.PER1AD3
#define PER01AD_PER1AD4                 _PER01AD.Bits.PER1AD4
#define PER01AD_PER1AD5                 _PER01AD.Bits.PER1AD5
#define PER01AD_PER1AD6                 _PER01AD.Bits.PER1AD6
#define PER01AD_PER1AD7                 _PER01AD.Bits.PER1AD7
#define PER01AD_PER0AD8                 _PER01AD.Bits.PER0AD8
#define PER01AD_PER0AD9                 _PER01AD.Bits.PER0AD9
#define PER01AD_PER0AD10                _PER01AD.Bits.PER0AD10
#define PER01AD_PER0AD11                _PER01AD.Bits.PER0AD11
#define PER01AD_PER0AD12                _PER01AD.Bits.PER0AD12
#define PER01AD_PER0AD13                _PER01AD.Bits.PER0AD13
#define PER01AD_PER0AD14                _PER01AD.Bits.PER0AD14
#define PER01AD_PER0AD15                _PER01AD.Bits.PER0AD15
#define PER01AD_PER1AD                  _PER01AD.MergedBits.grpPER1AD
#define PER01AD_PER0AD_8                _PER01AD.MergedBits.grpPER0AD_8
#define PER01AD_PER0AD                  PER01AD_PER0AD_8

#define PER01AD_PER1AD0_MASK            1U
#define PER01AD_PER1AD1_MASK            2U
#define PER01AD_PER1AD2_MASK            4U
#define PER01AD_PER1AD3_MASK            8U
#define PER01AD_PER1AD4_MASK            16U
#define PER01AD_PER1AD5_MASK            32U
#define PER01AD_PER1AD6_MASK            64U
#define PER01AD_PER1AD7_MASK            128U
#define PER01AD_PER0AD8_MASK            256U
#define PER01AD_PER0AD9_MASK            512U
#define PER01AD_PER0AD10_MASK           1024U
#define PER01AD_PER0AD11_MASK           2048U
#define PER01AD_PER0AD12_MASK           4096U
#define PER01AD_PER0AD13_MASK           8192U
#define PER01AD_PER0AD14_MASK           16384U
#define PER01AD_PER0AD15_MASK           32768U
#define PER01AD_PER1AD_MASK             255U
#define PER01AD_PER1AD_BITNUM           0U
#define PER01AD_PER0AD_8_MASK           65280U
#define PER01AD_PER0AD_8_BITNUM         8U


/*** VREGCTRL - VREG_3V3 - Control Register; 0x000002F1 ***/
typedef union {
  byte Byte;
  struct {
    byte LVIF        :1;                                       /* Low Voltage Interrupt Flag */
    byte LVIE        :1;                                       /* Low Voltage Interrupt Enable Bit */
    byte LVDS        :1;                                       /* Low Voltage Detect Status Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} VREGCTRLSTR;
extern volatile VREGCTRLSTR _VREGCTRL @(REG_BASE + 0x000002F1UL);
#define VREGCTRL                        _VREGCTRL.Byte
#define VREGCTRL_LVIF                   _VREGCTRL.Bits.LVIF
#define VREGCTRL_LVIE                   _VREGCTRL.Bits.LVIE
#define VREGCTRL_LVDS                   _VREGCTRL.Bits.LVDS

#define VREGCTRL_LVIF_MASK              1U
#define VREGCTRL_LVIE_MASK              2U
#define VREGCTRL_LVDS_MASK              4U


/*** VREGAPICL - VREG_3V3 - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***/
typedef union {
  byte Byte;
  struct {
    byte APIF        :1;                                       /* Autonomous Periodical Interrupt Flag */
    byte APIE        :1;                                       /* Autonomous Periodical Interrupt Enable Bit */
    byte APIFE       :1;                                       /* Autonomous Periodical Interrupt Feature Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte APICLK      :1;                                       /* Autonomous Periodical Interrupt Clock Select Bit */
  } Bits;
} VREGAPICLSTR;
extern volatile VREGAPICLSTR _VREGAPICL @(REG_BASE + 0x000002F2UL);
#define VREGAPICL                       _VREGAPICL.Byte
#define VREGAPICL_APIF                  _VREGAPICL.Bits.APIF
#define VREGAPICL_APIE                  _VREGAPICL.Bits.APIE
#define VREGAPICL_APIFE                 _VREGAPICL.Bits.APIFE
#define VREGAPICL_APICLK                _VREGAPICL.Bits.APICLK

#define VREGAPICL_APIF_MASK             1U
#define VREGAPICL_APIE_MASK             2U
#define VREGAPICL_APIFE_MASK            4U
#define VREGAPICL_APICLK_MASK           128U


/*** VREGAPITR - VREG_3V3 - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte APITR0      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 0 */
    byte APITR1      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 1 */
    byte APITR2      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 2 */
    byte APITR3      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 3 */
    byte APITR4      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 4 */
    byte APITR5      :1;                                       /* Autonomous Periodical Interrupt Period Trimming Bit 5 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpAPITR :6;
  } MergedBits;
} VREGAPITRSTR;
extern volatile VREGAPITRSTR _VREGAPITR @(REG_BASE + 0x000002F3UL);
#define VREGAPITR                       _VREGAPITR.Byte
#define VREGAPITR_APITR0                _VREGAPITR.Bits.APITR0
#define VREGAPITR_APITR1                _VREGAPITR.Bits.APITR1
#define VREGAPITR_APITR2                _VREGAPITR.Bits.APITR2
#define VREGAPITR_APITR3                _VREGAPITR.Bits.APITR3
#define VREGAPITR_APITR4                _VREGAPITR.Bits.APITR4
#define VREGAPITR_APITR5                _VREGAPITR.Bits.APITR5
#define VREGAPITR_APITR                 _VREGAPITR.MergedBits.grpAPITR

#define VREGAPITR_APITR0_MASK           4U
#define VREGAPITR_APITR1_MASK           8U
#define VREGAPITR_APITR2_MASK           16U
#define VREGAPITR_APITR3_MASK           32U
#define VREGAPITR_APITR4_MASK           64U
#define VREGAPITR_APITR5_MASK           128U
#define VREGAPITR_APITR_MASK            252U
#define VREGAPITR_APITR_BITNUM          2U


/*** VREGAPIR - VREG_3V3 - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** VREGAPIRH - VREG_3V3 - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***/
    union {
      byte Byte;
      struct {
        byte APIR8       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 8 */
        byte APIR9       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 9 */
        byte APIR10      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 10 */
        byte APIR11      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 11 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpAPIR_8 :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } VREGAPIRHSTR;
    #define VREGAPIRH                   _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Byte
    #define VREGAPIRH_APIR8             _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR8
    #define VREGAPIRH_APIR9             _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR9
    #define VREGAPIRH_APIR10            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR10
    #define VREGAPIRH_APIR11            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.Bits.APIR11
    #define VREGAPIRH_APIR_8            _VREGAPIR.Overlap_STR.VREGAPIRHSTR.MergedBits.grpAPIR_8
    #define VREGAPIRH_APIR              VREGAPIRH_APIR_8
    
    #define VREGAPIRH_APIR8_MASK        1U
    #define VREGAPIRH_APIR9_MASK        2U
    #define VREGAPIRH_APIR10_MASK       4U
    #define VREGAPIRH_APIR11_MASK       8U
    #define VREGAPIRH_APIR_8_MASK       15U
    #define VREGAPIRH_APIR_8_BITNUM     0U
    

    /*** VREGAPIRL - VREG_3V3 - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***/
    union {
      byte Byte;
      struct {
        byte APIR0       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 0 */
        byte APIR1       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 1 */
        byte APIR2       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 2 */
        byte APIR3       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 3 */
        byte APIR4       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 4 */
        byte APIR5       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 5 */
        byte APIR6       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 6 */
        byte APIR7       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 7 */
      } Bits;
    } VREGAPIRLSTR;
    #define VREGAPIRL                   _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Byte
    #define VREGAPIRL_APIR0             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR0
    #define VREGAPIRL_APIR1             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR1
    #define VREGAPIRL_APIR2             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR2
    #define VREGAPIRL_APIR3             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR3
    #define VREGAPIRL_APIR4             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR4
    #define VREGAPIRL_APIR5             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR5
    #define VREGAPIRL_APIR6             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR6
    #define VREGAPIRL_APIR7             _VREGAPIR.Overlap_STR.VREGAPIRLSTR.Bits.APIR7
    
    #define VREGAPIRL_APIR0_MASK        1U
    #define VREGAPIRL_APIR1_MASK        2U
    #define VREGAPIRL_APIR2_MASK        4U
    #define VREGAPIRL_APIR3_MASK        8U
    #define VREGAPIRL_APIR4_MASK        16U
    #define VREGAPIRL_APIR5_MASK        32U
    #define VREGAPIRL_APIR6_MASK        64U
    #define VREGAPIRL_APIR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word APIR0       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 0 */
    word APIR1       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 1 */
    word APIR2       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 2 */
    word APIR3       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 3 */
    word APIR4       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 4 */
    word APIR5       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 5 */
    word APIR6       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 6 */
    word APIR7       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 7 */
    word APIR8       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 8 */
    word APIR9       :1;                                       /* Autonomous Periodical Interrupt Rate Bit 9 */
    word APIR10      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 10 */
    word APIR11      :1;                                       /* Autonomous Periodical Interrupt Rate Bit 11 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpAPIR :12;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} VREGAPIRSTR;
extern volatile VREGAPIRSTR _VREGAPIR @(REG_BASE + 0x000002F4UL);
#define VREGAPIR                        _VREGAPIR.Word
#define VREGAPIR_APIR0                  _VREGAPIR.Bits.APIR0
#define VREGAPIR_APIR1                  _VREGAPIR.Bits.APIR1
#define VREGAPIR_APIR2                  _VREGAPIR.Bits.APIR2
#define VREGAPIR_APIR3                  _VREGAPIR.Bits.APIR3
#define VREGAPIR_APIR4                  _VREGAPIR.Bits.APIR4
#define VREGAPIR_APIR5                  _VREGAPIR.Bits.APIR5
#define VREGAPIR_APIR6                  _VREGAPIR.Bits.APIR6
#define VREGAPIR_APIR7                  _VREGAPIR.Bits.APIR7
#define VREGAPIR_APIR8                  _VREGAPIR.Bits.APIR8
#define VREGAPIR_APIR9                  _VREGAPIR.Bits.APIR9
#define VREGAPIR_APIR10                 _VREGAPIR.Bits.APIR10
#define VREGAPIR_APIR11                 _VREGAPIR.Bits.APIR11
#define VREGAPIR_APIR                   _VREGAPIR.MergedBits.grpAPIR

#define VREGAPIR_APIR0_MASK             1U
#define VREGAPIR_APIR1_MASK             2U
#define VREGAPIR_APIR2_MASK             4U
#define VREGAPIR_APIR3_MASK             8U
#define VREGAPIR_APIR4_MASK             16U
#define VREGAPIR_APIR5_MASK             32U
#define VREGAPIR_APIR6_MASK             64U
#define VREGAPIR_APIR7_MASK             128U
#define VREGAPIR_APIR8_MASK             256U
#define VREGAPIR_APIR9_MASK             512U
#define VREGAPIR_APIR10_MASK            1024U
#define VREGAPIR_APIR11_MASK            2048U
#define VREGAPIR_APIR_MASK              4095U
#define VREGAPIR_APIR_BITNUM            0U


/*** PITCFLMT - PIT Control and Force Load Micro Timer Register; 0x00000340 ***/
typedef union {
  byte Byte;
  struct {
    byte PFLMT0      :1;                                       /* PIT Force Load Bits for Micro Timer 0 */
    byte PFLMT1      :1;                                       /* PIT Force Load Bits for Micro Timer 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PITFRZ      :1;                                       /* PIT Counter Freeze while in Freeze Mode Bit */
    byte PITSWAI     :1;                                       /* PIT Stop in Wait Mode Bit */
    byte PITE        :1;                                       /* PIT Module Enable Bit */
  } Bits;
  struct {
    byte grpPFLMT :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PITCFLMTSTR;
extern volatile PITCFLMTSTR _PITCFLMT @(REG_BASE + 0x00000340UL);
#define PITCFLMT                        _PITCFLMT.Byte
#define PITCFLMT_PFLMT0                 _PITCFLMT.Bits.PFLMT0
#define PITCFLMT_PFLMT1                 _PITCFLMT.Bits.PFLMT1
#define PITCFLMT_PITFRZ                 _PITCFLMT.Bits.PITFRZ
#define PITCFLMT_PITSWAI                _PITCFLMT.Bits.PITSWAI
#define PITCFLMT_PITE                   _PITCFLMT.Bits.PITE
#define PITCFLMT_PFLMT                  _PITCFLMT.MergedBits.grpPFLMT

#define PITCFLMT_PFLMT0_MASK            1U
#define PITCFLMT_PFLMT1_MASK            2U
#define PITCFLMT_PITFRZ_MASK            32U
#define PITCFLMT_PITSWAI_MASK           64U
#define PITCFLMT_PITE_MASK              128U
#define PITCFLMT_PFLMT_MASK             3U
#define PITCFLMT_PFLMT_BITNUM           0U


/*** PITFLT - PIT Force Load Timer Register; 0x00000341 ***/
typedef union {
  byte Byte;
  struct {
    byte PFLT0       :1;                                       /* PIT Force Load Bits for Timer 0 */
    byte PFLT1       :1;                                       /* PIT Force Load Bits for Timer 1 */
    byte PFLT2       :1;                                       /* PIT Force Load Bits for Timer 2 */
    byte PFLT3       :1;                                       /* PIT Force Load Bits for Timer 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPFLT :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PITFLTSTR;
extern volatile PITFLTSTR _PITFLT @(REG_BASE + 0x00000341UL);
#define PITFLT                          _PITFLT.Byte
#define PITFLT_PFLT0                    _PITFLT.Bits.PFLT0
#define PITFLT_PFLT1                    _PITFLT.Bits.PFLT1
#define PITFLT_PFLT2                    _PITFLT.Bits.PFLT2
#define PITFLT_PFLT3                    _PITFLT.Bits.PFLT3
#define PITFLT_PFLT                     _PITFLT.MergedBits.grpPFLT

#define PITFLT_PFLT0_MASK               1U
#define PITFLT_PFLT1_MASK               2U
#define PITFLT_PFLT2_MASK               4U
#define PITFLT_PFLT3_MASK               8U
#define PITFLT_PFLT_MASK                15U
#define PITFLT_PFLT_BITNUM              0U


/*** PITCE - PIT Channel Enable Register; 0x00000342 ***/
typedef union {
  byte Byte;
  struct {
    byte PCE0        :1;                                       /* PIT Enable Bits for Timer Channel 0 */
    byte PCE1        :1;                                       /* PIT Enable Bits for Timer Channel 1 */
    byte PCE2        :1;                                       /* PIT Enable Bits for Timer Channel 2 */
    byte PCE3        :1;                                       /* PIT Enable Bits for Timer Channel 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPCE  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PITCESTR;
extern volatile PITCESTR _PITCE @(REG_BASE + 0x00000342UL);
#define PITCE                           _PITCE.Byte
#define PITCE_PCE0                      _PITCE.Bits.PCE0
#define PITCE_PCE1                      _PITCE.Bits.PCE1
#define PITCE_PCE2                      _PITCE.Bits.PCE2
#define PITCE_PCE3                      _PITCE.Bits.PCE3
#define PITCE_PCE                       _PITCE.MergedBits.grpPCE

#define PITCE_PCE0_MASK                 1U
#define PITCE_PCE1_MASK                 2U
#define PITCE_PCE2_MASK                 4U
#define PITCE_PCE3_MASK                 8U
#define PITCE_PCE_MASK                  15U
#define PITCE_PCE_BITNUM                0U


/*** PITMUX - PIT Multiplex Register; 0x00000343 ***/
typedef union {
  byte Byte;
  struct {
    byte PMUX0       :1;                                       /* PIT Multiplex Bits for Timer Channel 0 */
    byte PMUX1       :1;                                       /* PIT Multiplex Bits for Timer Channel 1 */
    byte PMUX2       :1;                                       /* PIT Multiplex Bits for Timer Channel 2 */
    byte PMUX3       :1;                                       /* PIT Multiplex Bits for Timer Channel 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPMUX :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PITMUXSTR;
extern volatile PITMUXSTR _PITMUX @(REG_BASE + 0x00000343UL);
#define PITMUX                          _PITMUX.Byte
#define PITMUX_PMUX0                    _PITMUX.Bits.PMUX0
#define PITMUX_PMUX1                    _PITMUX.Bits.PMUX1
#define PITMUX_PMUX2                    _PITMUX.Bits.PMUX2
#define PITMUX_PMUX3                    _PITMUX.Bits.PMUX3
#define PITMUX_PMUX                     _PITMUX.MergedBits.grpPMUX

#define PITMUX_PMUX0_MASK               1U
#define PITMUX_PMUX1_MASK               2U
#define PITMUX_PMUX2_MASK               4U
#define PITMUX_PMUX3_MASK               8U
#define PITMUX_PMUX_MASK                15U
#define PITMUX_PMUX_BITNUM              0U


/*** PITINTE - PIT Interrupt Enable Register; 0x00000344 ***/
typedef union {
  byte Byte;
  struct {
    byte PINTE0      :1;                                       /* PIT Time-out Interrupt Enable Bits for Timer Channel 0 */
    byte PINTE1      :1;                                       /* PIT Time-out Interrupt Enable Bits for Timer Channel 1 */
    byte PINTE2      :1;                                       /* PIT Time-out Interrupt Enable Bits for Timer Channel 2 */
    byte PINTE3      :1;                                       /* PIT Time-out Interrupt Enable Bits for Timer Channel 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPINTE :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PITINTESTR;
extern volatile PITINTESTR _PITINTE @(REG_BASE + 0x00000344UL);
#define PITINTE                         _PITINTE.Byte
#define PITINTE_PINTE0                  _PITINTE.Bits.PINTE0
#define PITINTE_PINTE1                  _PITINTE.Bits.PINTE1
#define PITINTE_PINTE2                  _PITINTE.Bits.PINTE2
#define PITINTE_PINTE3                  _PITINTE.Bits.PINTE3
#define PITINTE_PINTE                   _PITINTE.MergedBits.grpPINTE

#define PITINTE_PINTE0_MASK             1U
#define PITINTE_PINTE1_MASK             2U
#define PITINTE_PINTE2_MASK             4U
#define PITINTE_PINTE3_MASK             8U
#define PITINTE_PINTE_MASK              15U
#define PITINTE_PINTE_BITNUM            0U


/*** PITTF - PIT Time-out Flag Register; 0x00000345 ***/
typedef union {
  byte Byte;
  struct {
    byte PTF0        :1;                                       /* PIT Time-out Flag Bits for Timer Channel 0 */
    byte PTF1        :1;                                       /* PIT Time-out Flag Bits for Timer Channel 1 */
    byte PTF2        :1;                                       /* PIT Time-out Flag Bits for Timer Channel 2 */
    byte PTF3        :1;                                       /* PIT Time-out Flag Bits for Timer Channel 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTF  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PITTFSTR;
extern volatile PITTFSTR _PITTF @(REG_BASE + 0x00000345UL);
#define PITTF                           _PITTF.Byte
#define PITTF_PTF0                      _PITTF.Bits.PTF0
#define PITTF_PTF1                      _PITTF.Bits.PTF1
#define PITTF_PTF2                      _PITTF.Bits.PTF2
#define PITTF_PTF3                      _PITTF.Bits.PTF3
#define PITTF_PTF                       _PITTF.MergedBits.grpPTF

#define PITTF_PTF0_MASK                 1U
#define PITTF_PTF1_MASK                 2U
#define PITTF_PTF2_MASK                 4U
#define PITTF_PTF3_MASK                 8U
#define PITTF_PTF_MASK                  15U
#define PITTF_PTF_BITNUM                0U


/*** PITMTLD0 - PIT Micro Timer Load Register 0; 0x00000346 ***/
typedef union {
  byte Byte;
  struct {
    byte PMTLD0      :1;                                       /* PIT Micro Timer Load Bit 0 */
    byte PMTLD1      :1;                                       /* PIT Micro Timer Load Bit 1 */
    byte PMTLD2      :1;                                       /* PIT Micro Timer Load Bit 2 */
    byte PMTLD3      :1;                                       /* PIT Micro Timer Load Bit 3 */
    byte PMTLD4      :1;                                       /* PIT Micro Timer Load Bit 4 */
    byte PMTLD5      :1;                                       /* PIT Micro Timer Load Bit 5 */
    byte PMTLD6      :1;                                       /* PIT Micro Timer Load Bit 6 */
    byte PMTLD7      :1;                                       /* PIT Micro Timer Load Bit 7 */
  } Bits;
} PITMTLD0STR;
extern volatile PITMTLD0STR _PITMTLD0 @(REG_BASE + 0x00000346UL);
#define PITMTLD0                        _PITMTLD0.Byte
#define PITMTLD0_PMTLD0                 _PITMTLD0.Bits.PMTLD0
#define PITMTLD0_PMTLD1                 _PITMTLD0.Bits.PMTLD1
#define PITMTLD0_PMTLD2                 _PITMTLD0.Bits.PMTLD2
#define PITMTLD0_PMTLD3                 _PITMTLD0.Bits.PMTLD3
#define PITMTLD0_PMTLD4                 _PITMTLD0.Bits.PMTLD4
#define PITMTLD0_PMTLD5                 _PITMTLD0.Bits.PMTLD5
#define PITMTLD0_PMTLD6                 _PITMTLD0.Bits.PMTLD6
#define PITMTLD0_PMTLD7                 _PITMTLD0.Bits.PMTLD7
/* PITMTLD_ARR: Access 2 PITMTLDx registers in an array */
#define PITMTLD_ARR                     ((volatile byte *) &PITMTLD0)

#define PITMTLD0_PMTLD0_MASK            1U
#define PITMTLD0_PMTLD1_MASK            2U
#define PITMTLD0_PMTLD2_MASK            4U
#define PITMTLD0_PMTLD3_MASK            8U
#define PITMTLD0_PMTLD4_MASK            16U
#define PITMTLD0_PMTLD5_MASK            32U
#define PITMTLD0_PMTLD6_MASK            64U
#define PITMTLD0_PMTLD7_MASK            128U


/*** PITMTLD1 - PIT Micro Timer Load Register 1; 0x00000347 ***/
typedef union {
  byte Byte;
  struct {
    byte PMTLD0      :1;                                       /* PIT Micro Timer Load Bit 0 */
    byte PMTLD1      :1;                                       /* PIT Micro Timer Load Bit 1 */
    byte PMTLD2      :1;                                       /* PIT Micro Timer Load Bit 2 */
    byte PMTLD3      :1;                                       /* PIT Micro Timer Load Bit 3 */
    byte PMTLD4      :1;                                       /* PIT Micro Timer Load Bit 4 */
    byte PMTLD5      :1;                                       /* PIT Micro Timer Load Bit 5 */
    byte PMTLD6      :1;                                       /* PIT Micro Timer Load Bit 6 */
    byte PMTLD7      :1;                                       /* PIT Micro Timer Load Bit 7 */
  } Bits;
} PITMTLD1STR;
extern volatile PITMTLD1STR _PITMTLD1 @(REG_BASE + 0x00000347UL);
#define PITMTLD1                        _PITMTLD1.Byte
#define PITMTLD1_PMTLD0                 _PITMTLD1.Bits.PMTLD0
#define PITMTLD1_PMTLD1                 _PITMTLD1.Bits.PMTLD1
#define PITMTLD1_PMTLD2                 _PITMTLD1.Bits.PMTLD2
#define PITMTLD1_PMTLD3                 _PITMTLD1.Bits.PMTLD3
#define PITMTLD1_PMTLD4                 _PITMTLD1.Bits.PMTLD4
#define PITMTLD1_PMTLD5                 _PITMTLD1.Bits.PMTLD5
#define PITMTLD1_PMTLD6                 _PITMTLD1.Bits.PMTLD6
#define PITMTLD1_PMTLD7                 _PITMTLD1.Bits.PMTLD7

#define PITMTLD1_PMTLD0_MASK            1U
#define PITMTLD1_PMTLD1_MASK            2U
#define PITMTLD1_PMTLD2_MASK            4U
#define PITMTLD1_PMTLD3_MASK            8U
#define PITMTLD1_PMTLD4_MASK            16U
#define PITMTLD1_PMTLD5_MASK            32U
#define PITMTLD1_PMTLD6_MASK            64U
#define PITMTLD1_PMTLD7_MASK            128U


/*** PITLD0 - PIT Load Register 0; 0x00000348 ***/
typedef union {
  word Word;
} PITLD0STR;
extern volatile PITLD0STR _PITLD0 @(REG_BASE + 0x00000348UL);
#define PITLD0                          _PITLD0.Word


/*** PITCNT0 - PIT Count Register 0; 0x0000034A ***/
typedef union {
  word Word;
} PITCNT0STR;
extern volatile PITCNT0STR _PITCNT0 @(REG_BASE + 0x0000034AUL);
#define PITCNT0                         _PITCNT0.Word


/*** PITLD1 - PIT Load Register 1; 0x0000034C ***/
typedef union {
  word Word;
} PITLD1STR;
extern volatile PITLD1STR _PITLD1 @(REG_BASE + 0x0000034CUL);
#define PITLD1                          _PITLD1.Word


/*** PITCNT1 - PIT Count Register 1; 0x0000034E ***/
typedef union {
  word Word;
} PITCNT1STR;
extern volatile PITCNT1STR _PITCNT1 @(REG_BASE + 0x0000034EUL);
#define PITCNT1                         _PITCNT1.Word


/*** PITLD2 - PIT Load Register 2; 0x00000350 ***/
typedef union {
  word Word;
} PITLD2STR;
extern volatile PITLD2STR _PITLD2 @(REG_BASE + 0x00000350UL);
#define PITLD2                          _PITLD2.Word


/*** PITCNT2 - PIT Count Register 2; 0x00000352 ***/
typedef union {
  word Word;
} PITCNT2STR;
extern volatile PITCNT2STR _PITCNT2 @(REG_BASE + 0x00000352UL);
#define PITCNT2                         _PITCNT2.Word


/*** PITLD3 - PIT Load Register 3; 0x00000354 ***/
typedef union {
  word Word;
} PITLD3STR;
extern volatile PITLD3STR _PITLD3 @(REG_BASE + 0x00000354UL);
#define PITLD3                          _PITLD3.Word


/*** PITCNT3 - PIT Count Register 3; 0x00000356 ***/
typedef union {
  word Word;
} PITCNT3STR;
extern volatile PITCNT3STR _PITCNT3 @(REG_BASE + 0x00000356UL);
#define PITCNT3                         _PITCNT3.Word


/*** XGMCTL - XGATE Module Control Register; 0x00000380 ***/
typedef union {
  word Word;
  struct {
    word XGIE        :1;                                       /* XGATE Interrupt Enable */
    word XGSWEIF     :1;                                       /* XGATE Software Error Interrupt Flag */
    word             :1; 
    word XGFACT      :1;                                       /* Fake XGATE Activity */
    word XGSS        :1;                                       /* XGATE Single Step */
    word XGDBG       :1;                                       /* XGATE Debug Mode */
    word XGFRZ       :1;                                       /* Halt XGATE in Freeze Mode */
    word XGE         :1;                                       /* XGATE Module Enable */
    word XGIEM       :1;                                       /* XGIE Mask */
    word XGSWEIFM    :1;                                       /* XGSWEIF Mask */
    word             :1; 
    word XGFACTM     :1;                                       /* XGFACT Mask */
    word XGSSM       :1;                                       /* XGSS Mask */
    word XGDBGM      :1;                                       /* XGDBG Mask */
    word XGFRZM      :1;                                       /* XGFRZ Mask */
    word XGEM        :1;                                       /* XGE Mask */
  } Bits;
} XGMCTLSTR;
extern volatile XGMCTLSTR _XGMCTL @(REG_BASE + 0x00000380UL);
#define XGMCTL                          _XGMCTL.Word
#define XGMCTL_XGIE                     _XGMCTL.Bits.XGIE
#define XGMCTL_XGSWEIF                  _XGMCTL.Bits.XGSWEIF
#define XGMCTL_XGFACT                   _XGMCTL.Bits.XGFACT
#define XGMCTL_XGSS                     _XGMCTL.Bits.XGSS
#define XGMCTL_XGDBG                    _XGMCTL.Bits.XGDBG
#define XGMCTL_XGFRZ                    _XGMCTL.Bits.XGFRZ
#define XGMCTL_XGE                      _XGMCTL.Bits.XGE
#define XGMCTL_XGIEM                    _XGMCTL.Bits.XGIEM
#define XGMCTL_XGSWEIFM                 _XGMCTL.Bits.XGSWEIFM
#define XGMCTL_XGFACTM                  _XGMCTL.Bits.XGFACTM
#define XGMCTL_XGSSM                    _XGMCTL.Bits.XGSSM
#define XGMCTL_XGDBGM                   _XGMCTL.Bits.XGDBGM
#define XGMCTL_XGFRZM                   _XGMCTL.Bits.XGFRZM
#define XGMCTL_XGEM                     _XGMCTL.Bits.XGEM

#define XGMCTL_XGIE_MASK                1U
#define XGMCTL_XGSWEIF_MASK             2U
#define XGMCTL_XGFACT_MASK              8U
#define XGMCTL_XGSS_MASK                16U
#define XGMCTL_XGDBG_MASK               32U
#define XGMCTL_XGFRZ_MASK               64U
#define XGMCTL_XGE_MASK                 128U
#define XGMCTL_XGIEM_MASK               256U
#define XGMCTL_XGSWEIFM_MASK            512U
#define XGMCTL_XGFACTM_MASK             2048U
#define XGMCTL_XGSSM_MASK               4096U
#define XGMCTL_XGDBGM_MASK              8192U
#define XGMCTL_XGFRZM_MASK              16384U
#define XGMCTL_XGEM_MASK                32768U


/*** XGCHID - XGATE Channel ID Register; 0x00000382 ***/
typedef union {
  byte Byte;
  struct {
    byte XGCHID_grp  :7;                                       /* Request Identifier */ /*Warning: group name is duplicated with register name*/
    byte             :1; 
  } Bits;
} XGCHIDSTR;
extern volatile XGCHIDSTR _XGCHID @(REG_BASE + 0x00000382UL);
#define XGCHID                          _XGCHID.Byte
#define XGCHID_XGCHID                   _XGCHID.Bits.XGCHID_grp

#define XGCHID_XGCHID_MASK              127U
#define XGCHID_XGCHID_BITNUM            0U


/*** XGVBR - XGATE Vector Base Address Register; 0x00000386 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word XGVBR_grp   :15;                                      /* Vector Base Address */ /*Warning: group name is duplicated with register name*/
  } Bits;
} XGVBRSTR;
extern volatile XGVBRSTR _XGVBR @(REG_BASE + 0x00000386UL);
#define XGVBR                           _XGVBR.Word
#define XGVBR_XGVBR                     _XGVBR.Bits.XGVBR_grp

#define XGVBR_XGVBR_MASK                65534U
#define XGVBR_XGVBR_BITNUM              1U


/*** XGIF_7F_70 - XGATE Channel Interrupt Flag Vector 0; 0x00000388 ***/
typedef union {
  word Word;
  struct {
    word XGIF_70     :1;                                       /* Channel Interrupt Flag 70 */
    word XGIF_71     :1;                                       /* Channel Interrupt Flag 71 */
    word XGIF_72     :1;                                       /* Channel Interrupt Flag 72 */
    word XGIF_73     :1;                                       /* Channel Interrupt Flag 73 */
    word XGIF_74     :1;                                       /* Channel Interrupt Flag 74 */
    word XGIF_75     :1;                                       /* Channel Interrupt Flag 75 */
    word XGIF_76     :1;                                       /* Channel Interrupt Flag 76 */
    word XGIF_77     :1;                                       /* Channel Interrupt Flag 77 */
    word XGIF_78     :1;                                       /* Channel Interrupt Flag 78 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpXGIF__70 :9;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} XGIF_7F_70STR;
extern volatile XGIF_7F_70STR _XGIF_7F_70 @(REG_BASE + 0x00000388UL);
#define XGIF_7F_70                      _XGIF_7F_70.Word
#define XGIF_7F_70_XGIF_70              _XGIF_7F_70.Bits.XGIF_70
#define XGIF_7F_70_XGIF_71              _XGIF_7F_70.Bits.XGIF_71
#define XGIF_7F_70_XGIF_72              _XGIF_7F_70.Bits.XGIF_72
#define XGIF_7F_70_XGIF_73              _XGIF_7F_70.Bits.XGIF_73
#define XGIF_7F_70_XGIF_74              _XGIF_7F_70.Bits.XGIF_74
#define XGIF_7F_70_XGIF_75              _XGIF_7F_70.Bits.XGIF_75
#define XGIF_7F_70_XGIF_76              _XGIF_7F_70.Bits.XGIF_76
#define XGIF_7F_70_XGIF_77              _XGIF_7F_70.Bits.XGIF_77
#define XGIF_7F_70_XGIF_78              _XGIF_7F_70.Bits.XGIF_78
#define XGIF_7F_70_XGIF__70             _XGIF_7F_70.MergedBits.grpXGIF__70
#define XGIF_7F_70_XGIF_                XGIF_7F_70_XGIF__70

#define XGIF_7F_70_XGIF_70_MASK         1U
#define XGIF_7F_70_XGIF_71_MASK         2U
#define XGIF_7F_70_XGIF_72_MASK         4U
#define XGIF_7F_70_XGIF_73_MASK         8U
#define XGIF_7F_70_XGIF_74_MASK         16U
#define XGIF_7F_70_XGIF_75_MASK         32U
#define XGIF_7F_70_XGIF_76_MASK         64U
#define XGIF_7F_70_XGIF_77_MASK         128U
#define XGIF_7F_70_XGIF_78_MASK         256U
#define XGIF_7F_70_XGIF__70_MASK        511U
#define XGIF_7F_70_XGIF__70_BITNUM      0U


/*** XGIF_6F_60 - XGATE Channel Interrupt Flag Vector 1; 0x0000038A ***/
typedef union {
  word Word;
  struct {
    word XGIF_60     :1;                                       /* Channel Interrupt Flag 60 */
    word XGIF_61     :1;                                       /* Channel Interrupt Flag 61 */
    word XGIF_62     :1;                                       /* Channel Interrupt Flag 62 */
    word XGIF_63     :1;                                       /* Channel Interrupt Flag 63 */
    word XGIF_64     :1;                                       /* Channel Interrupt Flag 64 */
    word XGIF_65     :1;                                       /* Channel Interrupt Flag 65 */
    word XGIF_66     :1;                                       /* Channel Interrupt Flag 66 */
    word XGIF_67     :1;                                       /* Channel Interrupt Flag 67 */
    word XGIF_68     :1;                                       /* Channel Interrupt Flag 68 */
    word XGIF_69     :1;                                       /* Channel Interrupt Flag 69 */
    word XGIF_6A     :1;                                       /* Channel Interrupt Flag 6A */
    word XGIF_6B     :1;                                       /* Channel Interrupt Flag 6B */
    word XGIF_6C     :1;                                       /* Channel Interrupt Flag 6C */
    word XGIF_6D     :1;                                       /* Channel Interrupt Flag 6D */
    word XGIF_6E     :1;                                       /* Channel Interrupt Flag 6E */
    word XGIF_6F     :1;                                       /* Channel Interrupt Flag 6F */
  } Bits;
  struct {
    word grpXGIF__60 :10;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} XGIF_6F_60STR;
extern volatile XGIF_6F_60STR _XGIF_6F_60 @(REG_BASE + 0x0000038AUL);
#define XGIF_6F_60                      _XGIF_6F_60.Word
#define XGIF_6F_60_XGIF_60              _XGIF_6F_60.Bits.XGIF_60
#define XGIF_6F_60_XGIF_61              _XGIF_6F_60.Bits.XGIF_61
#define XGIF_6F_60_XGIF_62              _XGIF_6F_60.Bits.XGIF_62
#define XGIF_6F_60_XGIF_63              _XGIF_6F_60.Bits.XGIF_63
#define XGIF_6F_60_XGIF_64              _XGIF_6F_60.Bits.XGIF_64
#define XGIF_6F_60_XGIF_65              _XGIF_6F_60.Bits.XGIF_65
#define XGIF_6F_60_XGIF_66              _XGIF_6F_60.Bits.XGIF_66
#define XGIF_6F_60_XGIF_67              _XGIF_6F_60.Bits.XGIF_67
#define XGIF_6F_60_XGIF_68              _XGIF_6F_60.Bits.XGIF_68
#define XGIF_6F_60_XGIF_69              _XGIF_6F_60.Bits.XGIF_69
#define XGIF_6F_60_XGIF_6A              _XGIF_6F_60.Bits.XGIF_6A
#define XGIF_6F_60_XGIF_6B              _XGIF_6F_60.Bits.XGIF_6B
#define XGIF_6F_60_XGIF_6C              _XGIF_6F_60.Bits.XGIF_6C
#define XGIF_6F_60_XGIF_6D              _XGIF_6F_60.Bits.XGIF_6D
#define XGIF_6F_60_XGIF_6E              _XGIF_6F_60.Bits.XGIF_6E
#define XGIF_6F_60_XGIF_6F              _XGIF_6F_60.Bits.XGIF_6F
#define XGIF_6F_60_XGIF__60             _XGIF_6F_60.MergedBits.grpXGIF__60
#define XGIF_6F_60_XGIF_                XGIF_6F_60_XGIF__60

#define XGIF_6F_60_XGIF_60_MASK         1U
#define XGIF_6F_60_XGIF_61_MASK         2U
#define XGIF_6F_60_XGIF_62_MASK         4U
#define XGIF_6F_60_XGIF_63_MASK         8U
#define XGIF_6F_60_XGIF_64_MASK         16U
#define XGIF_6F_60_XGIF_65_MASK         32U
#define XGIF_6F_60_XGIF_66_MASK         64U
#define XGIF_6F_60_XGIF_67_MASK         128U
#define XGIF_6F_60_XGIF_68_MASK         256U
#define XGIF_6F_60_XGIF_69_MASK         512U
#define XGIF_6F_60_XGIF_6A_MASK         1024U
#define XGIF_6F_60_XGIF_6B_MASK         2048U
#define XGIF_6F_60_XGIF_6C_MASK         4096U
#define XGIF_6F_60_XGIF_6D_MASK         8192U
#define XGIF_6F_60_XGIF_6E_MASK         16384U
#define XGIF_6F_60_XGIF_6F_MASK         32768U
#define XGIF_6F_60_XGIF__60_MASK        1023U
#define XGIF_6F_60_XGIF__60_BITNUM      0U


/*** XGIF_5F_50 - XGATE Channel Interrupt Flag Vector 2; 0x0000038C ***/
typedef union {
  word Word;
  struct {
    word XGIF_50     :1;                                       /* Channel Interrupt Flag 50 */
    word XGIF_51     :1;                                       /* Channel Interrupt Flag 51 */
    word XGIF_52     :1;                                       /* Channel Interrupt Flag 52 */
    word XGIF_53     :1;                                       /* Channel Interrupt Flag 53 */
    word XGIF_54     :1;                                       /* Channel Interrupt Flag 54 */
    word XGIF_55     :1;                                       /* Channel Interrupt Flag 55 */
    word XGIF_56     :1;                                       /* Channel Interrupt Flag 56 */
    word XGIF_57     :1;                                       /* Channel Interrupt Flag 57 */
    word XGIF_58     :1;                                       /* Channel Interrupt Flag 58 */
    word XGIF_59     :1;                                       /* Channel Interrupt Flag 59 */
    word XGIF_5A     :1;                                       /* Channel Interrupt Flag 5A */
    word XGIF_5B     :1;                                       /* Channel Interrupt Flag 5B */
    word XGIF_5C     :1;                                       /* Channel Interrupt Flag 5C */
    word XGIF_5D     :1;                                       /* Channel Interrupt Flag 5D */
    word XGIF_5E     :1;                                       /* Channel Interrupt Flag 5E */
    word XGIF_5F     :1;                                       /* Channel Interrupt Flag 5F */
  } Bits;
  struct {
    word grpXGIF__50 :10;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} XGIF_5F_50STR;
extern volatile XGIF_5F_50STR _XGIF_5F_50 @(REG_BASE + 0x0000038CUL);
#define XGIF_5F_50                      _XGIF_5F_50.Word
#define XGIF_5F_50_XGIF_50              _XGIF_5F_50.Bits.XGIF_50
#define XGIF_5F_50_XGIF_51              _XGIF_5F_50.Bits.XGIF_51
#define XGIF_5F_50_XGIF_52              _XGIF_5F_50.Bits.XGIF_52
#define XGIF_5F_50_XGIF_53              _XGIF_5F_50.Bits.XGIF_53
#define XGIF_5F_50_XGIF_54              _XGIF_5F_50.Bits.XGIF_54
#define XGIF_5F_50_XGIF_55              _XGIF_5F_50.Bits.XGIF_55
#define XGIF_5F_50_XGIF_56              _XGIF_5F_50.Bits.XGIF_56
#define XGIF_5F_50_XGIF_57              _XGIF_5F_50.Bits.XGIF_57
#define XGIF_5F_50_XGIF_58              _XGIF_5F_50.Bits.XGIF_58
#define XGIF_5F_50_XGIF_59              _XGIF_5F_50.Bits.XGIF_59
#define XGIF_5F_50_XGIF_5A              _XGIF_5F_50.Bits.XGIF_5A
#define XGIF_5F_50_XGIF_5B              _XGIF_5F_50.Bits.XGIF_5B
#define XGIF_5F_50_XGIF_5C              _XGIF_5F_50.Bits.XGIF_5C
#define XGIF_5F_50_XGIF_5D              _XGIF_5F_50.Bits.XGIF_5D
#define XGIF_5F_50_XGIF_5E              _XGIF_5F_50.Bits.XGIF_5E
#define XGIF_5F_50_XGIF_5F              _XGIF_5F_50.Bits.XGIF_5F
#define XGIF_5F_50_XGIF__50             _XGIF_5F_50.MergedBits.grpXGIF__50
#define XGIF_5F_50_XGIF_                XGIF_5F_50_XGIF__50

#define XGIF_5F_50_XGIF_50_MASK         1U
#define XGIF_5F_50_XGIF_51_MASK         2U
#define XGIF_5F_50_XGIF_52_MASK         4U
#define XGIF_5F_50_XGIF_53_MASK         8U
#define XGIF_5F_50_XGIF_54_MASK         16U
#define XGIF_5F_50_XGIF_55_MASK         32U
#define XGIF_5F_50_XGIF_56_MASK         64U
#define XGIF_5F_50_XGIF_57_MASK         128U
#define XGIF_5F_50_XGIF_58_MASK         256U
#define XGIF_5F_50_XGIF_59_MASK         512U
#define XGIF_5F_50_XGIF_5A_MASK         1024U
#define XGIF_5F_50_XGIF_5B_MASK         2048U
#define XGIF_5F_50_XGIF_5C_MASK         4096U
#define XGIF_5F_50_XGIF_5D_MASK         8192U
#define XGIF_5F_50_XGIF_5E_MASK         16384U
#define XGIF_5F_50_XGIF_5F_MASK         32768U
#define XGIF_5F_50_XGIF__50_MASK        1023U
#define XGIF_5F_50_XGIF__50_BITNUM      0U


/*** XGIF_4F_40 - XGATE Channel Interrupt Flag Vector 3; 0x0000038E ***/
typedef union {
  word Word;
  struct {
    word XGIF_40     :1;                                       /* Channel Interrupt Flag 40 */
    word XGIF_41     :1;                                       /* Channel Interrupt Flag 41 */
    word XGIF_42     :1;                                       /* Channel Interrupt Flag 42 */
    word XGIF_43     :1;                                       /* Channel Interrupt Flag 43 */
    word XGIF_44     :1;                                       /* Channel Interrupt Flag 44 */
    word XGIF_45     :1;                                       /* Channel Interrupt Flag 45 */
    word XGIF_46     :1;                                       /* Channel Interrupt Flag 46 */
    word XGIF_47     :1;                                       /* Channel Interrupt Flag 47 */
    word XGIF_48     :1;                                       /* Channel Interrupt Flag 48 */
    word XGIF_49     :1;                                       /* Channel Interrupt Flag 49 */
    word XGIF_4A     :1;                                       /* Channel Interrupt Flag 4A */
    word XGIF_4B     :1;                                       /* Channel Interrupt Flag 4B */
    word XGIF_4C     :1;                                       /* Channel Interrupt Flag 4C */
    word XGIF_4D     :1;                                       /* Channel Interrupt Flag 4D */
    word XGIF_4E     :1;                                       /* Channel Interrupt Flag 4E */
    word XGIF_4F     :1;                                       /* Channel Interrupt Flag 4F */
  } Bits;
  struct {
    word grpXGIF__40 :10;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} XGIF_4F_40STR;
extern volatile XGIF_4F_40STR _XGIF_4F_40 @(REG_BASE + 0x0000038EUL);
#define XGIF_4F_40                      _XGIF_4F_40.Word
#define XGIF_4F_40_XGIF_40              _XGIF_4F_40.Bits.XGIF_40
#define XGIF_4F_40_XGIF_41              _XGIF_4F_40.Bits.XGIF_41
#define XGIF_4F_40_XGIF_42              _XGIF_4F_40.Bits.XGIF_42
#define XGIF_4F_40_XGIF_43              _XGIF_4F_40.Bits.XGIF_43
#define XGIF_4F_40_XGIF_44              _XGIF_4F_40.Bits.XGIF_44
#define XGIF_4F_40_XGIF_45              _XGIF_4F_40.Bits.XGIF_45
#define XGIF_4F_40_XGIF_46              _XGIF_4F_40.Bits.XGIF_46
#define XGIF_4F_40_XGIF_47              _XGIF_4F_40.Bits.XGIF_47
#define XGIF_4F_40_XGIF_48              _XGIF_4F_40.Bits.XGIF_48
#define XGIF_4F_40_XGIF_49              _XGIF_4F_40.Bits.XGIF_49
#define XGIF_4F_40_XGIF_4A              _XGIF_4F_40.Bits.XGIF_4A
#define XGIF_4F_40_XGIF_4B              _XGIF_4F_40.Bits.XGIF_4B
#define XGIF_4F_40_XGIF_4C              _XGIF_4F_40.Bits.XGIF_4C
#define XGIF_4F_40_XGIF_4D              _XGIF_4F_40.Bits.XGIF_4D
#define XGIF_4F_40_XGIF_4E              _XGIF_4F_40.Bits.XGIF_4E
#define XGIF_4F_40_XGIF_4F              _XGIF_4F_40.Bits.XGIF_4F
#define XGIF_4F_40_XGIF__40             _XGIF_4F_40.MergedBits.grpXGIF__40
#define XGIF_4F_40_XGIF_                XGIF_4F_40_XGIF__40

#define XGIF_4F_40_XGIF_40_MASK         1U
#define XGIF_4F_40_XGIF_41_MASK         2U
#define XGIF_4F_40_XGIF_42_MASK         4U
#define XGIF_4F_40_XGIF_43_MASK         8U
#define XGIF_4F_40_XGIF_44_MASK         16U
#define XGIF_4F_40_XGIF_45_MASK         32U
#define XGIF_4F_40_XGIF_46_MASK         64U
#define XGIF_4F_40_XGIF_47_MASK         128U
#define XGIF_4F_40_XGIF_48_MASK         256U
#define XGIF_4F_40_XGIF_49_MASK         512U
#define XGIF_4F_40_XGIF_4A_MASK         1024U
#define XGIF_4F_40_XGIF_4B_MASK         2048U
#define XGIF_4F_40_XGIF_4C_MASK         4096U
#define XGIF_4F_40_XGIF_4D_MASK         8192U
#define XGIF_4F_40_XGIF_4E_MASK         16384U
#define XGIF_4F_40_XGIF_4F_MASK         32768U
#define XGIF_4F_40_XGIF__40_MASK        1023U
#define XGIF_4F_40_XGIF__40_BITNUM      0U


/*** XGIF_3F_30 - XGATE Channel Interrupt Flag Vector 4; 0x00000390 ***/
typedef union {
  word Word;
  struct {
    word XGIF_30     :1;                                       /* Channel Interrupt Flag 30 */
    word XGIF_31     :1;                                       /* Channel Interrupt Flag 31 */
    word XGIF_32     :1;                                       /* Channel Interrupt Flag 32 */
    word XGIF_33     :1;                                       /* Channel Interrupt Flag 33 */
    word XGIF_34     :1;                                       /* Channel Interrupt Flag 34 */
    word XGIF_35     :1;                                       /* Channel Interrupt Flag 35 */
    word XGIF_36     :1;                                       /* Channel Interrupt Flag 36 */
    word XGIF_37     :1;                                       /* Channel Interrupt Flag 37 */
    word XGIF_38     :1;                                       /* Channel Interrupt Flag 38 */
    word XGIF_39     :1;                                       /* Channel Interrupt Flag 39 */
    word XGIF_3A     :1;                                       /* Channel Interrupt Flag 3A */
    word XGIF_3B     :1;                                       /* Channel Interrupt Flag 3B */
    word XGIF_3C     :1;                                       /* Channel Interrupt Flag 3C */
    word XGIF_3D     :1;                                       /* Channel Interrupt Flag 3D */
    word XGIF_3E     :1;                                       /* Channel Interrupt Flag 3E */
    word XGIF_3F     :1;                                       /* Channel Interrupt Flag 3F */
  } Bits;
  struct {
    word grpXGIF__30 :10;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} XGIF_3F_30STR;
extern volatile XGIF_3F_30STR _XGIF_3F_30 @(REG_BASE + 0x00000390UL);
#define XGIF_3F_30                      _XGIF_3F_30.Word
#define XGIF_3F_30_XGIF_30              _XGIF_3F_30.Bits.XGIF_30
#define XGIF_3F_30_XGIF_31              _XGIF_3F_30.Bits.XGIF_31
#define XGIF_3F_30_XGIF_32              _XGIF_3F_30.Bits.XGIF_32
#define XGIF_3F_30_XGIF_33              _XGIF_3F_30.Bits.XGIF_33
#define XGIF_3F_30_XGIF_34              _XGIF_3F_30.Bits.XGIF_34
#define XGIF_3F_30_XGIF_35              _XGIF_3F_30.Bits.XGIF_35
#define XGIF_3F_30_XGIF_36              _XGIF_3F_30.Bits.XGIF_36
#define XGIF_3F_30_XGIF_37              _XGIF_3F_30.Bits.XGIF_37
#define XGIF_3F_30_XGIF_38              _XGIF_3F_30.Bits.XGIF_38
#define XGIF_3F_30_XGIF_39              _XGIF_3F_30.Bits.XGIF_39
#define XGIF_3F_30_XGIF_3A              _XGIF_3F_30.Bits.XGIF_3A
#define XGIF_3F_30_XGIF_3B              _XGIF_3F_30.Bits.XGIF_3B
#define XGIF_3F_30_XGIF_3C              _XGIF_3F_30.Bits.XGIF_3C
#define XGIF_3F_30_XGIF_3D              _XGIF_3F_30.Bits.XGIF_3D
#define XGIF_3F_30_XGIF_3E              _XGIF_3F_30.Bits.XGIF_3E
#define XGIF_3F_30_XGIF_3F              _XGIF_3F_30.Bits.XGIF_3F
#define XGIF_3F_30_XGIF__30             _XGIF_3F_30.MergedBits.grpXGIF__30
#define XGIF_3F_30_XGIF_                XGIF_3F_30_XGIF__30

#define XGIF_3F_30_XGIF_30_MASK         1U
#define XGIF_3F_30_XGIF_31_MASK         2U
#define XGIF_3F_30_XGIF_32_MASK         4U
#define XGIF_3F_30_XGIF_33_MASK         8U
#define XGIF_3F_30_XGIF_34_MASK         16U
#define XGIF_3F_30_XGIF_35_MASK         32U
#define XGIF_3F_30_XGIF_36_MASK         64U
#define XGIF_3F_30_XGIF_37_MASK         128U
#define XGIF_3F_30_XGIF_38_MASK         256U
#define XGIF_3F_30_XGIF_39_MASK         512U
#define XGIF_3F_30_XGIF_3A_MASK         1024U
#define XGIF_3F_30_XGIF_3B_MASK         2048U
#define XGIF_3F_30_XGIF_3C_MASK         4096U
#define XGIF_3F_30_XGIF_3D_MASK         8192U
#define XGIF_3F_30_XGIF_3E_MASK         16384U
#define XGIF_3F_30_XGIF_3F_MASK         32768U
#define XGIF_3F_30_XGIF__30_MASK        1023U
#define XGIF_3F_30_XGIF__30_BITNUM      0U


/*** XGIF_2F_20 - XGATE Channel Interrupt Flag Vector 5; 0x00000392 ***/
typedef union {
  word Word;
  struct {
    word XGIF_20     :1;                                       /* Channel Interrupt Flag 20 */
    word XGIF_21     :1;                                       /* Channel Interrupt Flag 21 */
    word XGIF_22     :1;                                       /* Channel Interrupt Flag 22 */
    word XGIF_23     :1;                                       /* Channel Interrupt Flag 23 */
    word XGIF_24     :1;                                       /* Channel Interrupt Flag 24 */
    word XGIF_25     :1;                                       /* Channel Interrupt Flag 25 */
    word XGIF_26     :1;                                       /* Channel Interrupt Flag 26 */
    word XGIF_27     :1;                                       /* Channel Interrupt Flag 27 */
    word XGIF_28     :1;                                       /* Channel Interrupt Flag 28 */
    word XGIF_29     :1;                                       /* Channel Interrupt Flag 29 */
    word XGIF_2A     :1;                                       /* Channel Interrupt Flag 2A */
    word XGIF_2B     :1;                                       /* Channel Interrupt Flag 2B */
    word XGIF_2C     :1;                                       /* Channel Interrupt Flag 2C */
    word XGIF_2D     :1;                                       /* Channel Interrupt Flag 2D */
    word XGIF_2E     :1;                                       /* Channel Interrupt Flag 2E */
    word XGIF_2F     :1;                                       /* Channel Interrupt Flag 2F */
  } Bits;
  struct {
    word grpXGIF__20 :10;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} XGIF_2F_20STR;
extern volatile XGIF_2F_20STR _XGIF_2F_20 @(REG_BASE + 0x00000392UL);
#define XGIF_2F_20                      _XGIF_2F_20.Word
#define XGIF_2F_20_XGIF_20              _XGIF_2F_20.Bits.XGIF_20
#define XGIF_2F_20_XGIF_21              _XGIF_2F_20.Bits.XGIF_21
#define XGIF_2F_20_XGIF_22              _XGIF_2F_20.Bits.XGIF_22
#define XGIF_2F_20_XGIF_23              _XGIF_2F_20.Bits.XGIF_23
#define XGIF_2F_20_XGIF_24              _XGIF_2F_20.Bits.XGIF_24
#define XGIF_2F_20_XGIF_25              _XGIF_2F_20.Bits.XGIF_25
#define XGIF_2F_20_XGIF_26              _XGIF_2F_20.Bits.XGIF_26
#define XGIF_2F_20_XGIF_27              _XGIF_2F_20.Bits.XGIF_27
#define XGIF_2F_20_XGIF_28              _XGIF_2F_20.Bits.XGIF_28
#define XGIF_2F_20_XGIF_29              _XGIF_2F_20.Bits.XGIF_29
#define XGIF_2F_20_XGIF_2A              _XGIF_2F_20.Bits.XGIF_2A
#define XGIF_2F_20_XGIF_2B              _XGIF_2F_20.Bits.XGIF_2B
#define XGIF_2F_20_XGIF_2C              _XGIF_2F_20.Bits.XGIF_2C
#define XGIF_2F_20_XGIF_2D              _XGIF_2F_20.Bits.XGIF_2D
#define XGIF_2F_20_XGIF_2E              _XGIF_2F_20.Bits.XGIF_2E
#define XGIF_2F_20_XGIF_2F              _XGIF_2F_20.Bits.XGIF_2F
#define XGIF_2F_20_XGIF__20             _XGIF_2F_20.MergedBits.grpXGIF__20
#define XGIF_2F_20_XGIF_                XGIF_2F_20_XGIF__20

#define XGIF_2F_20_XGIF_20_MASK         1U
#define XGIF_2F_20_XGIF_21_MASK         2U
#define XGIF_2F_20_XGIF_22_MASK         4U
#define XGIF_2F_20_XGIF_23_MASK         8U
#define XGIF_2F_20_XGIF_24_MASK         16U
#define XGIF_2F_20_XGIF_25_MASK         32U
#define XGIF_2F_20_XGIF_26_MASK         64U
#define XGIF_2F_20_XGIF_27_MASK         128U
#define XGIF_2F_20_XGIF_28_MASK         256U
#define XGIF_2F_20_XGIF_29_MASK         512U
#define XGIF_2F_20_XGIF_2A_MASK         1024U
#define XGIF_2F_20_XGIF_2B_MASK         2048U
#define XGIF_2F_20_XGIF_2C_MASK         4096U
#define XGIF_2F_20_XGIF_2D_MASK         8192U
#define XGIF_2F_20_XGIF_2E_MASK         16384U
#define XGIF_2F_20_XGIF_2F_MASK         32768U
#define XGIF_2F_20_XGIF__20_MASK        1023U
#define XGIF_2F_20_XGIF__20_BITNUM      0U


/*** XGIF_1F_10 - XGATE Channel Interrupt Flag Vector 6; 0x00000394 ***/
typedef union {
  word Word;
  struct {
    word XGIF_10     :1;                                       /* Channel Interrupt Flag 10 */
    word XGIF_11     :1;                                       /* Channel Interrupt Flag 11 */
    word XGIF_12     :1;                                       /* Channel Interrupt Flag 12 */
    word XGIF_13     :1;                                       /* Channel Interrupt Flag 13 */
    word XGIF_14     :1;                                       /* Channel Interrupt Flag 14 */
    word XGIF_15     :1;                                       /* Channel Interrupt Flag 15 */
    word XGIF_16     :1;                                       /* Channel Interrupt Flag 16 */
    word XGIF_17     :1;                                       /* Channel Interrupt Flag 17 */
    word XGIF_18     :1;                                       /* Channel Interrupt Flag 18 */
    word XGIF_19     :1;                                       /* Channel Interrupt Flag 19 */
    word XGIF_1A     :1;                                       /* Channel Interrupt Flag 1A */
    word XGIF_1B     :1;                                       /* Channel Interrupt Flag 1B */
    word XGIF_1C     :1;                                       /* Channel Interrupt Flag 1C */
    word XGIF_1D     :1;                                       /* Channel Interrupt Flag 1D */
    word XGIF_1E     :1;                                       /* Channel Interrupt Flag 1E */
    word XGIF_1F     :1;                                       /* Channel Interrupt Flag 1F */
  } Bits;
  struct {
    word grpXGIF__10 :10;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} XGIF_1F_10STR;
extern volatile XGIF_1F_10STR _XGIF_1F_10 @(REG_BASE + 0x00000394UL);
#define XGIF_1F_10                      _XGIF_1F_10.Word
#define XGIF_1F_10_XGIF_10              _XGIF_1F_10.Bits.XGIF_10
#define XGIF_1F_10_XGIF_11              _XGIF_1F_10.Bits.XGIF_11
#define XGIF_1F_10_XGIF_12              _XGIF_1F_10.Bits.XGIF_12
#define XGIF_1F_10_XGIF_13              _XGIF_1F_10.Bits.XGIF_13
#define XGIF_1F_10_XGIF_14              _XGIF_1F_10.Bits.XGIF_14
#define XGIF_1F_10_XGIF_15              _XGIF_1F_10.Bits.XGIF_15
#define XGIF_1F_10_XGIF_16              _XGIF_1F_10.Bits.XGIF_16
#define XGIF_1F_10_XGIF_17              _XGIF_1F_10.Bits.XGIF_17
#define XGIF_1F_10_XGIF_18              _XGIF_1F_10.Bits.XGIF_18
#define XGIF_1F_10_XGIF_19              _XGIF_1F_10.Bits.XGIF_19
#define XGIF_1F_10_XGIF_1A              _XGIF_1F_10.Bits.XGIF_1A
#define XGIF_1F_10_XGIF_1B              _XGIF_1F_10.Bits.XGIF_1B
#define XGIF_1F_10_XGIF_1C              _XGIF_1F_10.Bits.XGIF_1C
#define XGIF_1F_10_XGIF_1D              _XGIF_1F_10.Bits.XGIF_1D
#define XGIF_1F_10_XGIF_1E              _XGIF_1F_10.Bits.XGIF_1E
#define XGIF_1F_10_XGIF_1F              _XGIF_1F_10.Bits.XGIF_1F
#define XGIF_1F_10_XGIF__10             _XGIF_1F_10.MergedBits.grpXGIF__10
#define XGIF_1F_10_XGIF_                XGIF_1F_10_XGIF__10

#define XGIF_1F_10_XGIF_10_MASK         1U
#define XGIF_1F_10_XGIF_11_MASK         2U
#define XGIF_1F_10_XGIF_12_MASK         4U
#define XGIF_1F_10_XGIF_13_MASK         8U
#define XGIF_1F_10_XGIF_14_MASK         16U
#define XGIF_1F_10_XGIF_15_MASK         32U
#define XGIF_1F_10_XGIF_16_MASK         64U
#define XGIF_1F_10_XGIF_17_MASK         128U
#define XGIF_1F_10_XGIF_18_MASK         256U
#define XGIF_1F_10_XGIF_19_MASK         512U
#define XGIF_1F_10_XGIF_1A_MASK         1024U
#define XGIF_1F_10_XGIF_1B_MASK         2048U
#define XGIF_1F_10_XGIF_1C_MASK         4096U
#define XGIF_1F_10_XGIF_1D_MASK         8192U
#define XGIF_1F_10_XGIF_1E_MASK         16384U
#define XGIF_1F_10_XGIF_1F_MASK         32768U
#define XGIF_1F_10_XGIF__10_MASK        1023U
#define XGIF_1F_10_XGIF__10_BITNUM      0U


/*** XGIF_0F_00 - XGATE Channel Interrupt Flag Vector 7; 0x00000396 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word XGIF_09     :1;                                       /* Channel Interrupt Flag 09 */
    word XGIF_0A     :1;                                       /* Channel Interrupt Flag 0A */
    word XGIF_0B     :1;                                       /* Channel Interrupt Flag 0B */
    word XGIF_0C     :1;                                       /* Channel Interrupt Flag 0C */
    word XGIF_0D     :1;                                       /* Channel Interrupt Flag 0D */
    word XGIF_0E     :1;                                       /* Channel Interrupt Flag 0E */
    word XGIF_0F     :1;                                       /* Channel Interrupt Flag 0F */
  } Bits;
} XGIF_0F_00STR;
extern volatile XGIF_0F_00STR _XGIF_0F_00 @(REG_BASE + 0x00000396UL);
#define XGIF_0F_00                      _XGIF_0F_00.Word
#define XGIF_0F_00_XGIF_09              _XGIF_0F_00.Bits.XGIF_09
#define XGIF_0F_00_XGIF_0A              _XGIF_0F_00.Bits.XGIF_0A
#define XGIF_0F_00_XGIF_0B              _XGIF_0F_00.Bits.XGIF_0B
#define XGIF_0F_00_XGIF_0C              _XGIF_0F_00.Bits.XGIF_0C
#define XGIF_0F_00_XGIF_0D              _XGIF_0F_00.Bits.XGIF_0D
#define XGIF_0F_00_XGIF_0E              _XGIF_0F_00.Bits.XGIF_0E
#define XGIF_0F_00_XGIF_0F              _XGIF_0F_00.Bits.XGIF_0F

#define XGIF_0F_00_XGIF_09_MASK         512U
#define XGIF_0F_00_XGIF_0A_MASK         1024U
#define XGIF_0F_00_XGIF_0B_MASK         2048U
#define XGIF_0F_00_XGIF_0C_MASK         4096U
#define XGIF_0F_00_XGIF_0D_MASK         8192U
#define XGIF_0F_00_XGIF_0E_MASK         16384U
#define XGIF_0F_00_XGIF_0F_MASK         32768U


/*** XGSWT - XGATE Software Trigger Register; 0x00000398 ***/
typedef union {
  word Word;
  struct {
    word XGSWT_grp   :8;                                       /* Software Trigger Bits */ /*Warning: group name is duplicated with register name*/
    word XGSWTM      :8;                                       /* Software Trigger Mask */
  } Bits;
} XGSWTSTR;
extern volatile XGSWTSTR _XGSWT @(REG_BASE + 0x00000398UL);
#define XGSWT                           _XGSWT.Word
#define XGSWT_XGSWT                     _XGSWT.Bits.XGSWT_grp
#define XGSWT_XGSWTM                    _XGSWT.Bits.XGSWTM

#define XGSWT_XGSWT_MASK                255U
#define XGSWT_XGSWT_BITNUM              0U
#define XGSWT_XGSWTM_MASK               65280U
#define XGSWT_XGSWTM_BITNUM             8U


/*** XGSEM - XGATE Semaphore Register; 0x0000039A ***/
typedef union {
  word Word;
  struct {
    word XGSEM_grp   :8;                                       /* Semaphore Bits */ /*Warning: group name is duplicated with register name*/
    word XGSEMM      :8;                                       /* Semaphore Mask */
  } Bits;
} XGSEMSTR;
extern volatile XGSEMSTR _XGSEM @(REG_BASE + 0x0000039AUL);
#define XGSEM                           _XGSEM.Word
#define XGSEM_XGSEM                     _XGSEM.Bits.XGSEM_grp
#define XGSEM_XGSEMM                    _XGSEM.Bits.XGSEMM

#define XGSEM_XGSEM_MASK                255U
#define XGSEM_XGSEM_BITNUM              0U
#define XGSEM_XGSEMM_MASK               65280U
#define XGSEM_XGSEMM_BITNUM             8U


/*** XGCCR - XGATE Condition Code Register; 0x0000039D ***/
typedef union {
  byte Byte;
  struct {
    byte XGC         :1;                                       /* Carry Flag */
    byte XGV         :1;                                       /* Overflow Flag */
    byte XGZ         :1;                                       /* Zero Flag */
    byte XGN         :1;                                       /* Sign Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} XGCCRSTR;
extern volatile XGCCRSTR _XGCCR @(REG_BASE + 0x0000039DUL);
#define XGCCR                           _XGCCR.Byte
#define XGCCR_XGC                       _XGCCR.Bits.XGC
#define XGCCR_XGV                       _XGCCR.Bits.XGV
#define XGCCR_XGZ                       _XGCCR.Bits.XGZ
#define XGCCR_XGN                       _XGCCR.Bits.XGN

#define XGCCR_XGC_MASK                  1U
#define XGCCR_XGV_MASK                  2U
#define XGCCR_XGZ_MASK                  4U
#define XGCCR_XGN_MASK                  8U


/*** XGPC - XGATE Program Counter Register; 0x0000039E ***/
typedef union {
  word Word;
} XGPCSTR;
extern volatile XGPCSTR _XGPC @(REG_BASE + 0x0000039EUL);
#define XGPC                            _XGPC.Word


/*** XGR1 - XGATE Register 1; 0x000003A2 ***/
typedef union {
  word Word;
} XGR1STR;
extern volatile XGR1STR _XGR1 @(REG_BASE + 0x000003A2UL);
#define XGR1                            _XGR1.Word


/*** XGR2 - XGATE Register 2; 0x000003A4 ***/
typedef union {
  word Word;
} XGR2STR;
extern volatile XGR2STR _XGR2 @(REG_BASE + 0x000003A4UL);
#define XGR2                            _XGR2.Word


/*** XGR3 - XGATE Register 3; 0x000003A6 ***/
typedef union {
  word Word;
} XGR3STR;
extern volatile XGR3STR _XGR3 @(REG_BASE + 0x000003A6UL);
#define XGR3                            _XGR3.Word


/*** XGR4 - XGATE Register 4; 0x000003A8 ***/
typedef union {
  word Word;
} XGR4STR;
extern volatile XGR4STR _XGR4 @(REG_BASE + 0x000003A8UL);
#define XGR4                            _XGR4.Word


/*** XGR5 - XGATE Register 5; 0x000003AA ***/
typedef union {
  word Word;
} XGR5STR;
extern volatile XGR5STR _XGR5 @(REG_BASE + 0x000003AAUL);
#define XGR5                            _XGR5.Word


/*** XGR6 - XGATE Register 6; 0x000003AC ***/
typedef union {
  word Word;
} XGR6STR;
extern volatile XGR6STR _XGR6 @(REG_BASE + 0x000003ACUL);
#define XGR6                            _XGR6.Word


/*** XGR7 - XGATE Register 7; 0x000003AE ***/
typedef union {
  word Word;
} XGR7STR;
extern volatile XGR7STR _XGR7 @(REG_BASE + 0x000003AEUL);
#define XGR7                            _XGR7.Word


/*** MVR - Module Version Register; 0x00000400 ***/
typedef union {
  word Word;
  struct {
    word PEVER       :8;                                       /* PE Version Number */
    word CHIVER      :8;                                       /* CHI Version Number */
  } Bits;
} MVRSTR;
extern volatile MVRSTR _MVR @(REG_BASE + 0x00000400UL);
#define MVR                             _MVR.Word
#define MVR_PEVER                       _MVR.Bits.PEVER
#define MVR_CHIVER                      _MVR.Bits.CHIVER

#define MVR_PEVER_MASK                  255U
#define MVR_PEVER_BITNUM                0U
#define MVR_CHIVER_MASK                 65280U
#define MVR_CHIVER_BITNUM               8U


/*** MCR - Module Configuration Register; 0x00000402 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word PRESCALE    :3;                                       /* Protocol Engine Clock Prescaler */
    word CLKSEL_bit  :1;                                       /* Protocol Engine Clock Source Select */ /*Warning: bit name is duplicated with register name*/
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word SFFE        :1;                                       /* Synchronization Frame Filter Enable */
    word CHA         :1;                                       /* Channel Enable */
    word CHB         :1;                                       /* Channel Enable */
    word SCM         :1;                                       /* Single Channel Device Mode */
    word             :1; 
    word MEN         :1;                                       /* Module Enable */
  } Bits;
  struct {
    word         :1;
    word         :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpCHx  :2;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCRSTR;
extern volatile MCRSTR _MCR @(REG_BASE + 0x00000402UL);
#define MCR                             _MCR.Word
#define MCR_PRESCALE                    _MCR.Bits.PRESCALE
#define MCR_CLKSEL                      _MCR.Bits.CLKSEL_bit
#define MCR_SFFE                        _MCR.Bits.SFFE
#define MCR_CHA                         _MCR.Bits.CHA
#define MCR_CHB                         _MCR.Bits.CHB
#define MCR_SCM                         _MCR.Bits.SCM
#define MCR_MEN                         _MCR.Bits.MEN
#define MCR_CHx                         _MCR.MergedBits.grpCHx

#define MCR_PRESCALE_MASK               14U
#define MCR_PRESCALE_BITNUM             1U
#define MCR_CLKSEL_MASK                 16U
#define MCR_SFFE_MASK                   1024U
#define MCR_CHA_MASK                    2048U
#define MCR_CHB_MASK                    4096U
#define MCR_SCM_MASK                    8192U
#define MCR_MEN_MASK                    32768U
#define MCR_CHx_MASK                    6144U
#define MCR_CHx_BITNUM                  11U


/*** SYMBADR - System Memory Base Address Register; 0x00000404 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SYMBADHR - System Memory Base Address High Register; 0x00000404 ***/
    union {
      word Word;
      struct {
        word SYS_MEM_BASE_ADDR16 :1;                               /* System Memory Base Address Bit 16 */
        word SYS_MEM_BASE_ADDR17 :1;                               /* System Memory Base Address Bit 17 */
        word SYS_MEM_BASE_ADDR18 :1;                               /* System Memory Base Address Bit 18 */
        word SYS_MEM_BASE_ADDR19 :1;                               /* System Memory Base Address Bit 19 */
        word SYS_MEM_BASE_ADDR20 :1;                               /* System Memory Base Address Bit 20 */
        word SYS_MEM_BASE_ADDR21 :1;                               /* System Memory Base Address Bit 21 */
        word SYS_MEM_BASE_ADDR22 :1;                               /* System Memory Base Address Bit 22 */
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
      } Bits;
      struct {
        word grpSYS_MEM_BASE_ADDR_16 :7;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
      } MergedBits;
    } SYMBADHRSTR;
    #define SYMBADHR                    _SYMBADR.Overlap_STR.SYMBADHRSTR.Word
    #define SYMBADHR_SYS_MEM_BASE_ADDR16 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR16
    #define SYMBADHR_SYS_MEM_BASE_ADDR17 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR17
    #define SYMBADHR_SYS_MEM_BASE_ADDR18 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR18
    #define SYMBADHR_SYS_MEM_BASE_ADDR19 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR19
    #define SYMBADHR_SYS_MEM_BASE_ADDR20 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR20
    #define SYMBADHR_SYS_MEM_BASE_ADDR21 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR21
    #define SYMBADHR_SYS_MEM_BASE_ADDR22 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR22
    #define SYMBADHR_SYS_MEM_BASE_ADDR_16 _SYMBADR.Overlap_STR.SYMBADHRSTR.MergedBits.grpSYS_MEM_BASE_ADDR_16
    #define SYMBADHR_SYS_MEM_BASE_ADDR  SYMBADHR_SYS_MEM_BASE_ADDR_16
    
    #define SYMBADHR_SYS_MEM_BASE_ADDR16_MASK 1U
    #define SYMBADHR_SYS_MEM_BASE_ADDR17_MASK 2U
    #define SYMBADHR_SYS_MEM_BASE_ADDR18_MASK 4U
    #define SYMBADHR_SYS_MEM_BASE_ADDR19_MASK 8U
    #define SYMBADHR_SYS_MEM_BASE_ADDR20_MASK 16U
    #define SYMBADHR_SYS_MEM_BASE_ADDR21_MASK 32U
    #define SYMBADHR_SYS_MEM_BASE_ADDR22_MASK 64U
    #define SYMBADHR_SYS_MEM_BASE_ADDR_16_MASK 127U
    #define SYMBADHR_SYS_MEM_BASE_ADDR_16_BITNUM 0U
    

    /*** SYMBADLR - System Memory Base Address Low Register; 0x00000406 ***/
    union {
      word Word;
      struct {
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word SYS_MEM_BASE_ADDR4 :1;                                /* System Memory Base Address Bit 4 */
        word SYS_MEM_BASE_ADDR5 :1;                                /* System Memory Base Address Bit 5 */
        word SYS_MEM_BASE_ADDR6 :1;                                /* System Memory Base Address Bit 6 */
        word SYS_MEM_BASE_ADDR7 :1;                                /* System Memory Base Address Bit 7 */
        word SYS_MEM_BASE_ADDR8 :1;                                /* System Memory Base Address Bit 8 */
        word SYS_MEM_BASE_ADDR9 :1;                                /* System Memory Base Address Bit 9 */
        word SYS_MEM_BASE_ADDR10 :1;                               /* System Memory Base Address Bit 10 */
        word SYS_MEM_BASE_ADDR11 :1;                               /* System Memory Base Address Bit 11 */
        word SYS_MEM_BASE_ADDR12 :1;                               /* System Memory Base Address Bit 12 */
        word SYS_MEM_BASE_ADDR13 :1;                               /* System Memory Base Address Bit 13 */
        word SYS_MEM_BASE_ADDR14 :1;                               /* System Memory Base Address Bit 14 */
        word SYS_MEM_BASE_ADDR15 :1;                               /* System Memory Base Address Bit 15 */
      } Bits;
      struct {
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word grpSYS_MEM_BASE_ADDR_4 :12;
      } MergedBits;
    } SYMBADLRSTR;
    #define SYMBADLR                    _SYMBADR.Overlap_STR.SYMBADLRSTR.Word
    #define SYMBADLR_SYS_MEM_BASE_ADDR4 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR4
    #define SYMBADLR_SYS_MEM_BASE_ADDR5 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR5
    #define SYMBADLR_SYS_MEM_BASE_ADDR6 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR6
    #define SYMBADLR_SYS_MEM_BASE_ADDR7 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR7
    #define SYMBADLR_SYS_MEM_BASE_ADDR8 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR8
    #define SYMBADLR_SYS_MEM_BASE_ADDR9 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR9
    #define SYMBADLR_SYS_MEM_BASE_ADDR10 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR10
    #define SYMBADLR_SYS_MEM_BASE_ADDR11 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR11
    #define SYMBADLR_SYS_MEM_BASE_ADDR12 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR12
    #define SYMBADLR_SYS_MEM_BASE_ADDR13 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR13
    #define SYMBADLR_SYS_MEM_BASE_ADDR14 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR14
    #define SYMBADLR_SYS_MEM_BASE_ADDR15 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR15
    #define SYMBADLR_SYS_MEM_BASE_ADDR_4 _SYMBADR.Overlap_STR.SYMBADLRSTR.MergedBits.grpSYS_MEM_BASE_ADDR_4
    #define SYMBADLR_SYS_MEM_BASE_ADDR  SYMBADLR_SYS_MEM_BASE_ADDR_4
    
    #define SYMBADLR_SYS_MEM_BASE_ADDR4_MASK 16U
    #define SYMBADLR_SYS_MEM_BASE_ADDR5_MASK 32U
    #define SYMBADLR_SYS_MEM_BASE_ADDR6_MASK 64U
    #define SYMBADLR_SYS_MEM_BASE_ADDR7_MASK 128U
    #define SYMBADLR_SYS_MEM_BASE_ADDR8_MASK 256U
    #define SYMBADLR_SYS_MEM_BASE_ADDR9_MASK 512U
    #define SYMBADLR_SYS_MEM_BASE_ADDR10_MASK 1024U
    #define SYMBADLR_SYS_MEM_BASE_ADDR11_MASK 2048U
    #define SYMBADLR_SYS_MEM_BASE_ADDR12_MASK 4096U
    #define SYMBADLR_SYS_MEM_BASE_ADDR13_MASK 8192U
    #define SYMBADLR_SYS_MEM_BASE_ADDR14_MASK 16384U
    #define SYMBADLR_SYS_MEM_BASE_ADDR15_MASK 32768U
    #define SYMBADLR_SYS_MEM_BASE_ADDR_4_MASK 65520U
    #define SYMBADLR_SYS_MEM_BASE_ADDR_4_BITNUM 4U
    
  } Overlap_STR;

} SYMBADRSTR;
extern volatile SYMBADRSTR _SYMBADR @(REG_BASE + 0x00000404UL);
#define SYMBADR                         _SYMBADR.Dword


/*** STBSCR - Strobe Signal Control Register; 0x00000408 ***/
typedef union {
  word Word;
  struct {
    word STBPSEL     :2;                                       /* Strobe Port Select */
    word             :1; 
    word             :1; 
    word ENB         :1;                                       /* Strobe Signal Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word SEL         :7;                                       /* Strobe Signal Select */
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} STBSCRSTR;
extern volatile STBSCRSTR _STBSCR @(REG_BASE + 0x00000408UL);
#define STBSCR                          _STBSCR.Word
#define STBSCR_STBPSEL                  _STBSCR.Bits.STBPSEL
#define STBSCR_ENB                      _STBSCR.Bits.ENB
#define STBSCR_SEL                      _STBSCR.Bits.SEL
#define STBSCR_WMD                      _STBSCR.Bits.WMD

#define STBSCR_STBPSEL_MASK             3U
#define STBSCR_STBPSEL_BITNUM           0U
#define STBSCR_ENB_MASK                 16U
#define STBSCR_SEL_MASK                 32512U
#define STBSCR_SEL_BITNUM               8U
#define STBSCR_WMD_MASK                 32768U


/*** STBPCR - Strobe Port Control Register; 0x0000040A ***/
typedef union {
  word Word;
  struct {
    word STB0EN      :1;                                       /* Strobe Port STB0 Enable */
    word STB1EN      :1;                                       /* Strobe Port STB1 Enable */
    word STB2EN      :1;                                       /* Strobe Port STB2 Enable */
    word STB3EN      :1;                                       /* Strobe Port STB3 Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} STBPCRSTR;
extern volatile STBPCRSTR _STBPCR @(REG_BASE + 0x0000040AUL);
#define STBPCR                          _STBPCR.Word
#define STBPCR_STB0EN                   _STBPCR.Bits.STB0EN
#define STBPCR_STB1EN                   _STBPCR.Bits.STB1EN
#define STBPCR_STB2EN                   _STBPCR.Bits.STB2EN
#define STBPCR_STB3EN                   _STBPCR.Bits.STB3EN

#define STBPCR_STB0EN_MASK              1U
#define STBPCR_STB1EN_MASK              2U
#define STBPCR_STB2EN_MASK              4U
#define STBPCR_STB3EN_MASK              8U


/*** MBDSR - Message Buffer Data Size Register; 0x0000040C ***/
typedef union {
  word Word;
  struct {
    word MBSEG1DS    :7;                                       /* Message Buffer Segment 1 Data Size */
    word             :1; 
    word MBSEG2DS    :7;                                       /* Message Buffer Segment 2 Data Size */
    word             :1; 
  } Bits;
} MBDSRSTR;
extern volatile MBDSRSTR _MBDSR @(REG_BASE + 0x0000040CUL);
#define MBDSR                           _MBDSR.Word
#define MBDSR_MBSEG1DS                  _MBDSR.Bits.MBSEG1DS
#define MBDSR_MBSEG2DS                  _MBDSR.Bits.MBSEG2DS

#define MBDSR_MBSEG1DS_MASK             127U
#define MBDSR_MBSEG1DS_BITNUM           0U
#define MBDSR_MBSEG2DS_MASK             32512U
#define MBDSR_MBSEG2DS_BITNUM           8U


/*** MBSSUTR - Message Buffer Segment Size and Utilization Register; 0x0000040E ***/
typedef union {
  word Word;
  struct {
    word LAST_MB_UTIL :5;                                      /* Last Message Buffer Utilized */
    word             :1; 
    word             :1; 
    word             :1; 
    word LAST_MB_SEG1 :5;                                      /* Last Message Buffer In Segment 1 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBSSUTRSTR;
extern volatile MBSSUTRSTR _MBSSUTR @(REG_BASE + 0x0000040EUL);
#define MBSSUTR                         _MBSSUTR.Word
#define MBSSUTR_LAST_MB_UTIL            _MBSSUTR.Bits.LAST_MB_UTIL
#define MBSSUTR_LAST_MB_SEG1            _MBSSUTR.Bits.LAST_MB_SEG1

#define MBSSUTR_LAST_MB_UTIL_MASK       31U
#define MBSSUTR_LAST_MB_UTIL_BITNUM     0U
#define MBSSUTR_LAST_MB_SEG1_MASK       7936U
#define MBSSUTR_LAST_MB_SEG1_BITNUM     8U


/*** POCR - Protocol Operation Control Register; 0x00000414 ***/
typedef union {
  word Word;
  struct {
    word POCCMD      :4;                                       /* Protocol Command */
    word             :1; 
    word             :1; 
    word             :1; 
    word BSY_WMC     :1;                                       /* Protocol Command Write Busy, Write Mode Command */
    word ERC_AP      :2;                                       /* External Rate Correction Application */
    word EOC_AP      :2;                                       /* External Offset Correction Application */
    word             :1; 
    word             :1; 
    word             :1; 
    word WME         :1;                                       /* Write Mode External Correction */
  } Bits;
} POCRSTR;
extern volatile POCRSTR _POCR @(REG_BASE + 0x00000414UL);
#define POCR                            _POCR.Word
#define POCR_POCCMD                     _POCR.Bits.POCCMD
#define POCR_BSY_WMC                    _POCR.Bits.BSY_WMC
#define POCR_ERC_AP                     _POCR.Bits.ERC_AP
#define POCR_EOC_AP                     _POCR.Bits.EOC_AP
#define POCR_WME                        _POCR.Bits.WME

#define POCR_POCCMD_MASK                15U
#define POCR_POCCMD_BITNUM              0U
#define POCR_BSY_WMC_MASK               128U
#define POCR_ERC_AP_MASK                768U
#define POCR_ERC_AP_BITNUM              8U
#define POCR_EOC_AP_MASK                3072U
#define POCR_EOC_AP_BITNUM              10U
#define POCR_WME_MASK                   32768U


/*** GIFER - Global Interrupt Flag and Enable Register; 0x00000416 ***/
typedef union {
  word Word;
  struct {
    word TBIE        :1;                                       /* Transmit Interrupt Enable */
    word RBIE        :1;                                       /* Receive Buffer Interrupt Enable */
    word FNEAIE      :1;                                       /* Receive FIFO channel A Not Empty Interrupt Enable */
    word FNEBIE      :1;                                       /* Receive FIFO channel B Not Empty Interrupt Enable */
    word WUPIE       :1;                                       /* Wakeup Interrupt Enable */
    word CHIE        :1;                                       /* CHI Interrupt Enable */
    word PRIE        :1;                                       /* Protocol Interrupt Enable */
    word MIE         :1;                                       /* Module Interrupt Enable */
    word TBIF        :1;                                       /* Transmit Buffer Interrupt Flag */
    word RBIF        :1;                                       /* Receive Message Buffer Interrupt Flag */
    word FNEAIF      :1;                                       /* Receive FIFO channel A Not Empty Interrupt Flag */
    word FNEBIF      :1;                                       /* Receive FIFO channel B Not Empty Interrupt Flag */
    word WUPIF       :1;                                       /* Wakeup Interrupt Flag */
    word CHIF        :1;                                       /* CHI Interrupt Flag */
    word PRIF        :1;                                       /* Protocol Interrupt Flag */
    word MIF         :1;                                       /* Module Interrupt Flag */
  } Bits;
} GIFERSTR;
extern volatile GIFERSTR _GIFER @(REG_BASE + 0x00000416UL);
#define GIFER                           _GIFER.Word
#define GIFER_TBIE                      _GIFER.Bits.TBIE
#define GIFER_RBIE                      _GIFER.Bits.RBIE
#define GIFER_FNEAIE                    _GIFER.Bits.FNEAIE
#define GIFER_FNEBIE                    _GIFER.Bits.FNEBIE
#define GIFER_WUPIE                     _GIFER.Bits.WUPIE
#define GIFER_CHIE                      _GIFER.Bits.CHIE
#define GIFER_PRIE                      _GIFER.Bits.PRIE
#define GIFER_MIE                       _GIFER.Bits.MIE
#define GIFER_TBIF                      _GIFER.Bits.TBIF
#define GIFER_RBIF                      _GIFER.Bits.RBIF
#define GIFER_FNEAIF                    _GIFER.Bits.FNEAIF
#define GIFER_FNEBIF                    _GIFER.Bits.FNEBIF
#define GIFER_WUPIF                     _GIFER.Bits.WUPIF
#define GIFER_CHIF                      _GIFER.Bits.CHIF
#define GIFER_PRIF                      _GIFER.Bits.PRIF
#define GIFER_MIF                       _GIFER.Bits.MIF

#define GIFER_TBIE_MASK                 1U
#define GIFER_RBIE_MASK                 2U
#define GIFER_FNEAIE_MASK               4U
#define GIFER_FNEBIE_MASK               8U
#define GIFER_WUPIE_MASK                16U
#define GIFER_CHIE_MASK                 32U
#define GIFER_PRIE_MASK                 64U
#define GIFER_MIE_MASK                  128U
#define GIFER_TBIF_MASK                 256U
#define GIFER_RBIF_MASK                 512U
#define GIFER_FNEAIF_MASK               1024U
#define GIFER_FNEBIF_MASK               2048U
#define GIFER_WUPIF_MASK                4096U
#define GIFER_CHIF_MASK                 8192U
#define GIFER_PRIF_MASK                 16384U
#define GIFER_MIF_MASK                  32768U


/*** PIFR0 - Protocol Interrupt Flag Register 0; 0x00000418 ***/
typedef union {
  word Word;
  struct {
    word CYS_IF      :1;                                       /* Cycle Start Interrupt Flag */
    word TI1_IF      :1;                                       /* Timer 1 Expired Interrupt Flag */
    word TI2_IF      :1;                                       /* Timer 2 Expired Interrupt Flag */
    word TBVA_IF     :1;                                       /* Transmission across boundary on channel A Interrupt Flag */
    word TBVB_IF     :1;                                       /* Transmission across boundary on channel B Interrupt Flag */
    word LTXA_IF     :1;                                       /* pdLatestTx Violation on Channel A Interrupt Flag */
    word LTXB_IF     :1;                                       /* pdLatestTx Violation on Channel B Interrupt Flag */
    word MTX_IF      :1;                                       /* Media Access Test Symbol Received Interrupt Flag */
    word MXS_IF      :1;                                       /* Max Sync Frames Detected Interrupt Flag */
    word CCL_IF      :1;                                       /* Clock Correction Limit Reached Interrupt Flag */
    word MOC_IF      :1;                                       /* Missing Offset Correction Interrupt Flag */
    word MRC_IF      :1;                                       /* Missing Rate Correction Interrupt Flag */
    word CSA_IF      :1;                                       /* Cold Start Abort Interrupt Flag */
    word ILCF_IF     :1;                                       /* Illegal Protocol Configuration Interrupt Flag */
    word INTL_IF     :1;                                       /* Internal Protocol Error Interrupt Flag */
    word FATL_IF     :1;                                       /* Fatal Protocol Error Interrupt Flag */
  } Bits;
} PIFR0STR;
extern volatile PIFR0STR _PIFR0 @(REG_BASE + 0x00000418UL);
#define PIFR0                           _PIFR0.Word
#define PIFR0_CYS_IF                    _PIFR0.Bits.CYS_IF
#define PIFR0_TI1_IF                    _PIFR0.Bits.TI1_IF
#define PIFR0_TI2_IF                    _PIFR0.Bits.TI2_IF
#define PIFR0_TBVA_IF                   _PIFR0.Bits.TBVA_IF
#define PIFR0_TBVB_IF                   _PIFR0.Bits.TBVB_IF
#define PIFR0_LTXA_IF                   _PIFR0.Bits.LTXA_IF
#define PIFR0_LTXB_IF                   _PIFR0.Bits.LTXB_IF
#define PIFR0_MTX_IF                    _PIFR0.Bits.MTX_IF
#define PIFR0_MXS_IF                    _PIFR0.Bits.MXS_IF
#define PIFR0_CCL_IF                    _PIFR0.Bits.CCL_IF
#define PIFR0_MOC_IF                    _PIFR0.Bits.MOC_IF
#define PIFR0_MRC_IF                    _PIFR0.Bits.MRC_IF
#define PIFR0_CSA_IF                    _PIFR0.Bits.CSA_IF
#define PIFR0_ILCF_IF                   _PIFR0.Bits.ILCF_IF
#define PIFR0_INTL_IF                   _PIFR0.Bits.INTL_IF
#define PIFR0_FATL_IF                   _PIFR0.Bits.FATL_IF
/* PIFR_ARR: Access 2 PIFRx registers in an array */
#define PIFR_ARR                        ((volatile word *) &PIFR0)

#define PIFR0_CYS_IF_MASK               1U
#define PIFR0_TI1_IF_MASK               2U
#define PIFR0_TI2_IF_MASK               4U
#define PIFR0_TBVA_IF_MASK              8U
#define PIFR0_TBVB_IF_MASK              16U
#define PIFR0_LTXA_IF_MASK              32U
#define PIFR0_LTXB_IF_MASK              64U
#define PIFR0_MTX_IF_MASK               128U
#define PIFR0_MXS_IF_MASK               256U
#define PIFR0_CCL_IF_MASK               512U
#define PIFR0_MOC_IF_MASK               1024U
#define PIFR0_MRC_IF_MASK               2048U
#define PIFR0_CSA_IF_MASK               4096U
#define PIFR0_ILCF_IF_MASK              8192U
#define PIFR0_INTL_IF_MASK              16384U
#define PIFR0_FATL_IF_MASK              32768U


/*** PIFR1 - Protocol Interrupt Flag Register 1; 0x0000041A ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ODT_IF      :1;                                       /* Odd Cycle Table Written Interrupt Flag */
    word EVT_IF      :1;                                       /* Even Cycle Table Written Interrupt Flag */
    word             :1; 
    word             :1; 
    word SSI0_IF     :1;                                       /* Slot Status Counter Incremented Interrupt Flag Bit 0 */
    word SSI1_IF     :1;                                       /* Slot Status Counter Incremented Interrupt Flag Bit 1 */
    word SSI2_IF     :1;                                       /* Slot Status Counter Incremented Interrupt Flag Bit 2 */
    word SSI3_IF     :1;                                       /* Slot Status Counter Incremented Interrupt Flag Bit 3 */
    word PSC_IF      :1;                                       /* Protocol State Changed Interrupt Flag */
    word PECF_IF     :1;                                       /* Protocol Engine Communication Failure Interrupt Flag */
    word IPC_IF      :1;                                       /* Illegal Protocol Command Interrupt Flag */
    word EMC_IF      :1;                                       /* Error Mode Changed Interrupt Flag */
  } Bits;
} PIFR1STR;
extern volatile PIFR1STR _PIFR1 @(REG_BASE + 0x0000041AUL);
#define PIFR1                           _PIFR1.Word
#define PIFR1_ODT_IF                    _PIFR1.Bits.ODT_IF
#define PIFR1_EVT_IF                    _PIFR1.Bits.EVT_IF
#define PIFR1_SSI0_IF                   _PIFR1.Bits.SSI0_IF
#define PIFR1_SSI1_IF                   _PIFR1.Bits.SSI1_IF
#define PIFR1_SSI2_IF                   _PIFR1.Bits.SSI2_IF
#define PIFR1_SSI3_IF                   _PIFR1.Bits.SSI3_IF
#define PIFR1_PSC_IF                    _PIFR1.Bits.PSC_IF
#define PIFR1_PECF_IF                   _PIFR1.Bits.PECF_IF
#define PIFR1_IPC_IF                    _PIFR1.Bits.IPC_IF
#define PIFR1_EMC_IF                    _PIFR1.Bits.EMC_IF

#define PIFR1_ODT_IF_MASK               16U
#define PIFR1_EVT_IF_MASK               32U
#define PIFR1_SSI0_IF_MASK              256U
#define PIFR1_SSI1_IF_MASK              512U
#define PIFR1_SSI2_IF_MASK              1024U
#define PIFR1_SSI3_IF_MASK              2048U
#define PIFR1_PSC_IF_MASK               4096U
#define PIFR1_PECF_IF_MASK              8192U
#define PIFR1_IPC_IF_MASK               16384U
#define PIFR1_EMC_IF_MASK               32768U


/*** PIER0 - Protocol Interrupt Enable Register 0; 0x0000041C ***/
typedef union {
  word Word;
  struct {
    word CYS_IE      :1;                                       /* Cycle Start Interrupt Enable */
    word TI1_IE      :1;                                       /* Timer 1 Expired Interrupt Enable */
    word TI2_IE      :1;                                       /* Timer 2 Expired Interrupt Enable */
    word TBVA_IE     :1;                                       /* Transmission across boundary on channel A Interrupt Enable */
    word TBVB_IE     :1;                                       /* Transmission across boundary on channel B Interrupt Enable */
    word LTXA_IE     :1;                                       /* pdLatestTx Violation on Channel A Interrupt Enable */
    word LTXB_IE     :1;                                       /* pdLatestTx Violation on Channel B Interrupt Enable */
    word MTX_IE      :1;                                       /* Media Access Test Symbol Received Interrupt Enable */
    word MXS_IE      :1;                                       /* Max Sync Frames Detected Interrupt Enable */
    word CCL_IE      :1;                                       /* Clock Correction Limit Reached Interrupt Enable */
    word MOC_IE      :1;                                       /* Missing Offset Correction Interrupt Enable */
    word MRC_IE      :1;                                       /* Missing Rate Correction Interrupt Enable */
    word CSA_IE      :1;                                       /* Cold Start Abort Interrupt Enable */
    word ILCF_IE     :1;                                       /* Illegal Protocol Configuration Interrupt Enable */
    word INTL_IE     :1;                                       /* Internal Protocol Error Interrupt Enable */
    word FATL_IE     :1;                                       /* Fatal Protocol Error Interrupt Enable */
  } Bits;
} PIER0STR;
extern volatile PIER0STR _PIER0 @(REG_BASE + 0x0000041CUL);
#define PIER0                           _PIER0.Word
#define PIER0_CYS_IE                    _PIER0.Bits.CYS_IE
#define PIER0_TI1_IE                    _PIER0.Bits.TI1_IE
#define PIER0_TI2_IE                    _PIER0.Bits.TI2_IE
#define PIER0_TBVA_IE                   _PIER0.Bits.TBVA_IE
#define PIER0_TBVB_IE                   _PIER0.Bits.TBVB_IE
#define PIER0_LTXA_IE                   _PIER0.Bits.LTXA_IE
#define PIER0_LTXB_IE                   _PIER0.Bits.LTXB_IE
#define PIER0_MTX_IE                    _PIER0.Bits.MTX_IE
#define PIER0_MXS_IE                    _PIER0.Bits.MXS_IE
#define PIER0_CCL_IE                    _PIER0.Bits.CCL_IE
#define PIER0_MOC_IE                    _PIER0.Bits.MOC_IE
#define PIER0_MRC_IE                    _PIER0.Bits.MRC_IE
#define PIER0_CSA_IE                    _PIER0.Bits.CSA_IE
#define PIER0_ILCF_IE                   _PIER0.Bits.ILCF_IE
#define PIER0_INTL_IE                   _PIER0.Bits.INTL_IE
#define PIER0_FATL_IE                   _PIER0.Bits.FATL_IE
/* PIER_ARR: Access 2 PIERx registers in an array */
#define PIER_ARR                        ((volatile word *) &PIER0)

#define PIER0_CYS_IE_MASK               1U
#define PIER0_TI1_IE_MASK               2U
#define PIER0_TI2_IE_MASK               4U
#define PIER0_TBVA_IE_MASK              8U
#define PIER0_TBVB_IE_MASK              16U
#define PIER0_LTXA_IE_MASK              32U
#define PIER0_LTXB_IE_MASK              64U
#define PIER0_MTX_IE_MASK               128U
#define PIER0_MXS_IE_MASK               256U
#define PIER0_CCL_IE_MASK               512U
#define PIER0_MOC_IE_MASK               1024U
#define PIER0_MRC_IE_MASK               2048U
#define PIER0_CSA_IE_MASK               4096U
#define PIER0_ILCF_IE_MASK              8192U
#define PIER0_INTL_IE_MASK              16384U
#define PIER0_FATL_IE_MASK              32768U


/*** PIER1 - Protocol Interrupt Enable Register 1; 0x0000041E ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ODT_IE      :1;                                       /* Odd Cycle Table Written Interrupt Enable */
    word EVT_IE      :1;                                       /* Even Cycle Table Written Interrupt Enable */
    word             :1; 
    word             :1; 
    word SSI0_IE     :1;                                       /* Slot Status Counter Incremented Interrupt Enable Bit 0 */
    word SSI1_IE     :1;                                       /* Slot Status Counter Incremented Interrupt Enable Bit 1 */
    word SSI2_IE     :1;                                       /* Slot Status Counter Incremented Interrupt Enable Bit 2 */
    word SSI3_IE     :1;                                       /* Slot Status Counter Incremented Interrupt Enable Bit 3 */
    word PSC_IE      :1;                                       /* Protocol State Changed Interrupt Enable */
    word PECF_IE     :1;                                       /* Protocol Engine Communication Failure Interrupt Enable */
    word IPC_IE      :1;                                       /* Illegal Protocol Command Interrupt Enable */
    word EMC_IE      :1;                                       /* Error Mode Changed Interrupt Enable */
  } Bits;
} PIER1STR;
extern volatile PIER1STR _PIER1 @(REG_BASE + 0x0000041EUL);
#define PIER1                           _PIER1.Word
#define PIER1_ODT_IE                    _PIER1.Bits.ODT_IE
#define PIER1_EVT_IE                    _PIER1.Bits.EVT_IE
#define PIER1_SSI0_IE                   _PIER1.Bits.SSI0_IE
#define PIER1_SSI1_IE                   _PIER1.Bits.SSI1_IE
#define PIER1_SSI2_IE                   _PIER1.Bits.SSI2_IE
#define PIER1_SSI3_IE                   _PIER1.Bits.SSI3_IE
#define PIER1_PSC_IE                    _PIER1.Bits.PSC_IE
#define PIER1_PECF_IE                   _PIER1.Bits.PECF_IE
#define PIER1_IPC_IE                    _PIER1.Bits.IPC_IE
#define PIER1_EMC_IE                    _PIER1.Bits.EMC_IE

#define PIER1_ODT_IE_MASK               16U
#define PIER1_EVT_IE_MASK               32U
#define PIER1_SSI0_IE_MASK              256U
#define PIER1_SSI1_IE_MASK              512U
#define PIER1_SSI2_IE_MASK              1024U
#define PIER1_SSI3_IE_MASK              2048U
#define PIER1_PSC_IE_MASK               4096U
#define PIER1_PECF_IE_MASK              8192U
#define PIER1_IPC_IE_MASK               16384U
#define PIER1_EMC_IE_MASK               32768U


/*** CHIERFR - CHI Error Flag Register; 0x00000420 ***/
typedef union {
  word Word;
  struct {
    word ILSA_EF     :1;                                       /* Illegal System Memory Access Error Flag */
    word NMF_EF      :1;                                       /* Network Management Frame Error Flag */
    word NML_EF      :1;                                       /* Network Management Length Error Flag */
    word SPL_EF      :1;                                       /* Static Payload Length Error Flag */
    word DPL_EF      :1;                                       /* Dynamic Payload Length Error Flag */
    word FID_EF      :1;                                       /* Frame ID Error Flag */
    word SBCF_EF     :1;                                       /* System Bus Communication Failure Error Flag */
    word DBL_EF      :1;                                       /* Double Transmit Message Buffer Lock Error Flag */
    word LCK_EF      :1;                                       /* Lock Error Flag */
    word MBU_EF      :1;                                       /* Message Buffer Utilization Error Flag */
    word MBS_EF      :1;                                       /* Message Buffer Search Error Flag */
    word FOVA_EF     :1;                                       /* Receive FIFO Overrun Channel A Error Flag */
    word FOVB_EF     :1;                                       /* Receive FIFO Overrun Channel B Error Flag */
    word PCMI_EF     :1;                                       /* Protocol Command Ignored Error Flag */
    word FRLA_EF     :1;                                       /* Frame Lost Channel A Error Flag */
    word FRLB_EF     :1;                                       /* Frame Lost Channel B Error Flag */
  } Bits;
} CHIERFRSTR;
extern volatile CHIERFRSTR _CHIERFR @(REG_BASE + 0x00000420UL);
#define CHIERFR                         _CHIERFR.Word
#define CHIERFR_ILSA_EF                 _CHIERFR.Bits.ILSA_EF
#define CHIERFR_NMF_EF                  _CHIERFR.Bits.NMF_EF
#define CHIERFR_NML_EF                  _CHIERFR.Bits.NML_EF
#define CHIERFR_SPL_EF                  _CHIERFR.Bits.SPL_EF
#define CHIERFR_DPL_EF                  _CHIERFR.Bits.DPL_EF
#define CHIERFR_FID_EF                  _CHIERFR.Bits.FID_EF
#define CHIERFR_SBCF_EF                 _CHIERFR.Bits.SBCF_EF
#define CHIERFR_DBL_EF                  _CHIERFR.Bits.DBL_EF
#define CHIERFR_LCK_EF                  _CHIERFR.Bits.LCK_EF
#define CHIERFR_MBU_EF                  _CHIERFR.Bits.MBU_EF
#define CHIERFR_MBS_EF                  _CHIERFR.Bits.MBS_EF
#define CHIERFR_FOVA_EF                 _CHIERFR.Bits.FOVA_EF
#define CHIERFR_FOVB_EF                 _CHIERFR.Bits.FOVB_EF
#define CHIERFR_PCMI_EF                 _CHIERFR.Bits.PCMI_EF
#define CHIERFR_FRLA_EF                 _CHIERFR.Bits.FRLA_EF
#define CHIERFR_FRLB_EF                 _CHIERFR.Bits.FRLB_EF

#define CHIERFR_ILSA_EF_MASK            1U
#define CHIERFR_NMF_EF_MASK             2U
#define CHIERFR_NML_EF_MASK             4U
#define CHIERFR_SPL_EF_MASK             8U
#define CHIERFR_DPL_EF_MASK             16U
#define CHIERFR_FID_EF_MASK             32U
#define CHIERFR_SBCF_EF_MASK            64U
#define CHIERFR_DBL_EF_MASK             128U
#define CHIERFR_LCK_EF_MASK             256U
#define CHIERFR_MBU_EF_MASK             512U
#define CHIERFR_MBS_EF_MASK             1024U
#define CHIERFR_FOVA_EF_MASK            2048U
#define CHIERFR_FOVB_EF_MASK            4096U
#define CHIERFR_PCMI_EF_MASK            8192U
#define CHIERFR_FRLA_EF_MASK            16384U
#define CHIERFR_FRLB_EF_MASK            32768U


/*** MBIVEC - Message Buffer Interrupt Vector Register; 0x00000422 ***/
typedef union {
  word Word;
  struct {
    word RBIVEC      :5;                                       /* Receive Buffer Interrupt Vector */
    word             :1; 
    word             :1; 
    word             :1; 
    word TBIVEC      :5;                                       /* Transmit Buffer Interrupt Vector */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIVECSTR;
extern volatile MBIVECSTR _MBIVEC @(REG_BASE + 0x00000422UL);
#define MBIVEC                          _MBIVEC.Word
#define MBIVEC_RBIVEC                   _MBIVEC.Bits.RBIVEC
#define MBIVEC_TBIVEC                   _MBIVEC.Bits.TBIVEC

#define MBIVEC_RBIVEC_MASK              31U
#define MBIVEC_RBIVEC_BITNUM            0U
#define MBIVEC_TBIVEC_MASK              7936U
#define MBIVEC_TBIVEC_BITNUM            8U


/*** CASERCR - Channel A Status Error Counter Register; 0x00000424 ***/
typedef union {
  word Word;
  struct {
    word STATUS_ERR_CNT :16;                                   /* Channel Status Error Counter */
  } Bits;
} CASERCRSTR;
extern volatile CASERCRSTR _CASERCR @(REG_BASE + 0x00000424UL);
#define CASERCR                         _CASERCR.Word
#define CASERCR_STATUS_ERR_CNT          _CASERCR.Bits.STATUS_ERR_CNT

#define CASERCR_STATUS_ERR_CNT_MASK     65535U
#define CASERCR_STATUS_ERR_CNT_BITNUM   0U


/*** CBSERCR - Channel B Status Error Counter Register; 0x00000426 ***/
typedef union {
  word Word;
  struct {
    word STATUS_ERR_CNT :16;                                   /* Channel Status Error Counter */
  } Bits;
} CBSERCRSTR;
extern volatile CBSERCRSTR _CBSERCR @(REG_BASE + 0x00000426UL);
#define CBSERCR                         _CBSERCR.Word
#define CBSERCR_STATUS_ERR_CNT          _CBSERCR.Bits.STATUS_ERR_CNT

#define CBSERCR_STATUS_ERR_CNT_MASK     65535U
#define CBSERCR_STATUS_ERR_CNT_BITNUM   0U


/*** PSR0 - Protocol Status Register 0; 0x00000428 ***/
typedef union {
  word Word;
  struct {
    word WAKEUPSTATUS :3;                                      /* Wakeup Status */
    word             :1; 
    word STARTUPSTATE :4;                                      /* Startup State */
    word PROTSTATE   :3;                                       /* Protocol State */
    word             :1; 
    word SLOTMODE    :2;                                       /* Slot Mod */
    word ERRMODE     :2;                                       /* Error Mode */
  } Bits;
} PSR0STR;
extern volatile PSR0STR _PSR0 @(REG_BASE + 0x00000428UL);
#define PSR0                            _PSR0.Word
#define PSR0_WAKEUPSTATUS               _PSR0.Bits.WAKEUPSTATUS
#define PSR0_STARTUPSTATE               _PSR0.Bits.STARTUPSTATE
#define PSR0_PROTSTATE                  _PSR0.Bits.PROTSTATE
#define PSR0_SLOTMODE                   _PSR0.Bits.SLOTMODE
#define PSR0_ERRMODE                    _PSR0.Bits.ERRMODE
/* PSR_ARR: Access 4 PSRx registers in an array */
#define PSR_ARR                         ((volatile word *) &PSR0)

#define PSR0_WAKEUPSTATUS_MASK          7U
#define PSR0_WAKEUPSTATUS_BITNUM        0U
#define PSR0_STARTUPSTATE_MASK          240U
#define PSR0_STARTUPSTATE_BITNUM        4U
#define PSR0_PROTSTATE_MASK             1792U
#define PSR0_PROTSTATE_BITNUM           8U
#define PSR0_SLOTMODE_MASK              12288U
#define PSR0_SLOTMODE_BITNUM            12U
#define PSR0_ERRMODE_MASK               49152U
#define PSR0_ERRMODE_BITNUM             14U


/*** PSR1 - Protocol Status Register 1; 0x0000042A ***/
typedef union {
  word Word;
  struct {
    word APTAC       :5;                                       /* Allow Passive to Active Counter */
    word FRZ         :1;                                       /* Freeze Occurred */
    word HHR         :1;                                       /* Host Halt Request Pending */
    word CPN         :1;                                       /* Cold Start Path Noise */
    word REMCSAT     :5;                                       /* Remaining Coldstart Attempts */
    word             :1; 
    word CSP         :1;                                       /* Cold Start Path */
    word CSAA        :1;                                       /* Cold Start Attempt Aborted Flag */
  } Bits;
} PSR1STR;
extern volatile PSR1STR _PSR1 @(REG_BASE + 0x0000042AUL);
#define PSR1                            _PSR1.Word
#define PSR1_APTAC                      _PSR1.Bits.APTAC
#define PSR1_FRZ                        _PSR1.Bits.FRZ
#define PSR1_HHR                        _PSR1.Bits.HHR
#define PSR1_CPN                        _PSR1.Bits.CPN
#define PSR1_REMCSAT                    _PSR1.Bits.REMCSAT
#define PSR1_CSP                        _PSR1.Bits.CSP
#define PSR1_CSAA                       _PSR1.Bits.CSAA

#define PSR1_APTAC_MASK                 31U
#define PSR1_APTAC_BITNUM               0U
#define PSR1_FRZ_MASK                   32U
#define PSR1_HHR_MASK                   64U
#define PSR1_CPN_MASK                   128U
#define PSR1_REMCSAT_MASK               7936U
#define PSR1_REMCSAT_BITNUM             8U
#define PSR1_CSP_MASK                   16384U
#define PSR1_CSAA_MASK                  32768U


/*** PSR2 - Protocol Status Register 2; 0x0000042C ***/
typedef union {
  word Word;
  struct {
    word CLKCORRFAILCNT :4;                                    /* Clock Correction Failed Counter */
    word MTA         :1;                                       /* Media Access Test Symbol MTS Received on Channel A */
    word SSEA        :1;                                       /* Symbol Window Syntax Error on Channel A */
    word SBVA        :1;                                       /* Symbol Window Boundary Violation on Channel A */
    word STCA        :1;                                       /* Symbol Window Transmit Conflict on Channel A */
    word NSEA        :1;                                       /* NIT Syntax Error on Channel A */
    word NBVA        :1;                                       /* NIT Boundary Violation on Channel A */
    word MTB         :1;                                       /* Media Access Test Symbol MTS Received on Channel B */
    word SSEB        :1;                                       /* Symbol Window Syntax Error on Channel B */
    word SBVB        :1;                                       /* Symbol Window Boundary Violation on Channel */
    word STCB        :1;                                       /* Symbol Window Transmit Conflict on Channel B */
    word NSEB        :1;                                       /* NIT Syntax Error on Channel B */
    word NBVB        :1;                                       /* NIT Boundary Violation on Channel B */
  } Bits;
} PSR2STR;
extern volatile PSR2STR _PSR2 @(REG_BASE + 0x0000042CUL);
#define PSR2                            _PSR2.Word
#define PSR2_CLKCORRFAILCNT             _PSR2.Bits.CLKCORRFAILCNT
#define PSR2_MTA                        _PSR2.Bits.MTA
#define PSR2_SSEA                       _PSR2.Bits.SSEA
#define PSR2_SBVA                       _PSR2.Bits.SBVA
#define PSR2_STCA                       _PSR2.Bits.STCA
#define PSR2_NSEA                       _PSR2.Bits.NSEA
#define PSR2_NBVA                       _PSR2.Bits.NBVA
#define PSR2_MTB                        _PSR2.Bits.MTB
#define PSR2_SSEB                       _PSR2.Bits.SSEB
#define PSR2_SBVB                       _PSR2.Bits.SBVB
#define PSR2_STCB                       _PSR2.Bits.STCB
#define PSR2_NSEB                       _PSR2.Bits.NSEB
#define PSR2_NBVB                       _PSR2.Bits.NBVB

#define PSR2_CLKCORRFAILCNT_MASK        15U
#define PSR2_CLKCORRFAILCNT_BITNUM      0U
#define PSR2_MTA_MASK                   16U
#define PSR2_SSEA_MASK                  32U
#define PSR2_SBVA_MASK                  64U
#define PSR2_STCA_MASK                  128U
#define PSR2_NSEA_MASK                  256U
#define PSR2_NBVA_MASK                  512U
#define PSR2_MTB_MASK                   1024U
#define PSR2_SSEB_MASK                  2048U
#define PSR2_SBVB_MASK                  4096U
#define PSR2_STCB_MASK                  8192U
#define PSR2_NSEB_MASK                  16384U
#define PSR2_NBVB_MASK                  32768U


/*** PSR3 - Protocol Status Register 3; 0x0000042E ***/
typedef union {
  word Word;
  struct {
    word AVFA        :1;                                       /* Aggregated Valid Frame on Channel A */
    word ASEA        :1;                                       /* Aggregated Syntax Error on Channel A */
    word ACEA        :1;                                       /* Aggregated Content Error on Channel A */
    word AACA        :1;                                       /* Aggregated Additional Communication on Channel A */
    word ABVA        :1;                                       /* Aggregated Boundary Violation on Channel A */
    word WUA         :1;                                       /* Wakeup Symbol Received on Channel A */
    word             :1; 
    word             :1; 
    word AVFB        :1;                                       /* Aggregated Valid Frame on Channel B */
    word ASEB        :1;                                       /* Aggregated Syntax Error on Channel B */
    word ACEB        :1;                                       /* Aggregated Content Error on Channel B */
    word AACB        :1;                                       /* Aggregated Additional Communication on Channel B */
    word ABVB        :1;                                       /* Aggregated Boundary Violation on Channel B */
    word WUB         :1;                                       /* Wakeup Symbol Received on Channel B */
    word             :1; 
    word             :1; 
  } Bits;
} PSR3STR;
extern volatile PSR3STR _PSR3 @(REG_BASE + 0x0000042EUL);
#define PSR3                            _PSR3.Word
#define PSR3_AVFA                       _PSR3.Bits.AVFA
#define PSR3_ASEA                       _PSR3.Bits.ASEA
#define PSR3_ACEA                       _PSR3.Bits.ACEA
#define PSR3_AACA                       _PSR3.Bits.AACA
#define PSR3_ABVA                       _PSR3.Bits.ABVA
#define PSR3_WUA                        _PSR3.Bits.WUA
#define PSR3_AVFB                       _PSR3.Bits.AVFB
#define PSR3_ASEB                       _PSR3.Bits.ASEB
#define PSR3_ACEB                       _PSR3.Bits.ACEB
#define PSR3_AACB                       _PSR3.Bits.AACB
#define PSR3_ABVB                       _PSR3.Bits.ABVB
#define PSR3_WUB                        _PSR3.Bits.WUB

#define PSR3_AVFA_MASK                  1U
#define PSR3_ASEA_MASK                  2U
#define PSR3_ACEA_MASK                  4U
#define PSR3_AACA_MASK                  8U
#define PSR3_ABVA_MASK                  16U
#define PSR3_WUA_MASK                   32U
#define PSR3_AVFB_MASK                  256U
#define PSR3_ASEB_MASK                  512U
#define PSR3_ACEB_MASK                  1024U
#define PSR3_AACB_MASK                  2048U
#define PSR3_ABVB_MASK                  4096U
#define PSR3_WUB_MASK                   8192U


/*** MTCTR - Macrotick Counter Register; 0x00000430 ***/
typedef union {
  word Word;
  struct {
    word MTCT        :14;                                      /* Macrotick Counter */
    word             :1; 
    word             :1; 
  } Bits;
} MTCTRSTR;
extern volatile MTCTRSTR _MTCTR @(REG_BASE + 0x00000430UL);
#define MTCTR                           _MTCTR.Word
#define MTCTR_MTCT                      _MTCTR.Bits.MTCT

#define MTCTR_MTCT_MASK                 16383U
#define MTCTR_MTCT_BITNUM               0U


/*** CYCTR - Cycle Counter Register; 0x00000432 ***/
typedef union {
  word Word;
  struct {
    word CYCCNT      :6;                                       /* Cycle Counter */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} CYCTRSTR;
extern volatile CYCTRSTR _CYCTR @(REG_BASE + 0x00000432UL);
#define CYCTR                           _CYCTR.Word
#define CYCTR_CYCCNT                    _CYCTR.Bits.CYCCNT

#define CYCTR_CYCCNT_MASK               63U
#define CYCTR_CYCCNT_BITNUM             0U


/*** SLTCTAR - Slot Counter Channel A Register; 0x00000434 ***/
typedef union {
  word Word;
  struct {
    word SLOTCNTA    :11;                                      /* Slot Counter Value for Channel A */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SLTCTARSTR;
extern volatile SLTCTARSTR _SLTCTAR @(REG_BASE + 0x00000434UL);
#define SLTCTAR                         _SLTCTAR.Word
#define SLTCTAR_SLOTCNTA                _SLTCTAR.Bits.SLOTCNTA

#define SLTCTAR_SLOTCNTA_MASK           2047U
#define SLTCTAR_SLOTCNTA_BITNUM         0U


/*** SLTCTBR - Slot Counter Channel B Register; 0x00000436 ***/
typedef union {
  word Word;
  struct {
    word SLOTCNTB    :11;                                      /* Slot Counter Value for Channel B */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SLTCTBRSTR;
extern volatile SLTCTBRSTR _SLTCTBR @(REG_BASE + 0x00000436UL);
#define SLTCTBR                         _SLTCTBR.Word
#define SLTCTBR_SLOTCNTB                _SLTCTBR.Bits.SLOTCNTB

#define SLTCTBR_SLOTCNTB_MASK           2047U
#define SLTCTBR_SLOTCNTB_BITNUM         0U


/*** RTCORVR - Rate Correction Value Register; 0x00000438 ***/
typedef union {
  word Word;
  struct {
    word RATECORR    :16;                                      /* Rate Correction Value */
  } Bits;
} RTCORVRSTR;
extern volatile RTCORVRSTR _RTCORVR @(REG_BASE + 0x00000438UL);
#define RTCORVR                         _RTCORVR.Word
#define RTCORVR_RATECORR                _RTCORVR.Bits.RATECORR

#define RTCORVR_RATECORR_MASK           65535U
#define RTCORVR_RATECORR_BITNUM         0U


/*** OFCORVR - Offset Correction Value Register; 0x0000043A ***/
typedef union {
  word Word;
  struct {
    word OFFSETCORR  :16;                                      /* Offset Correction Value */
  } Bits;
} OFCORVRSTR;
extern volatile OFCORVRSTR _OFCORVR @(REG_BASE + 0x0000043AUL);
#define OFCORVR                         _OFCORVR.Word
#define OFCORVR_OFFSETCORR              _OFCORVR.Bits.OFFSETCORR

#define OFCORVR_OFFSETCORR_MASK         65535U
#define OFCORVR_OFFSETCORR_BITNUM       0U


/*** CIFRR - Combined Interrupt Flag Register; 0x0000043C ***/
typedef union {
  word Word;
  struct {
    word TBIF        :1;                                       /* Transmit Interrupt Flag */
    word RBIF        :1;                                       /* Receive Buffer Interrupt Flag */
    word FNEAIF      :1;                                       /* Receive FIFO channel A Not Empty Interrupt Flag */
    word FNEBIF      :1;                                       /* Receive FIFO channel B Not Empty Interrupt Flag */
    word WUPIF       :1;                                       /* Wakeup Interrupt Flag */
    word CHIF        :1;                                       /* CHI Interrupt Flag */
    word PRIF        :1;                                       /* Protocol Interrupt Flag */
    word MIF         :1;                                       /* Module Interrupt Flag */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} CIFRRSTR;
extern volatile CIFRRSTR _CIFRR @(REG_BASE + 0x0000043CUL);
#define CIFRR                           _CIFRR.Word
#define CIFRR_TBIF                      _CIFRR.Bits.TBIF
#define CIFRR_RBIF                      _CIFRR.Bits.RBIF
#define CIFRR_FNEAIF                    _CIFRR.Bits.FNEAIF
#define CIFRR_FNEBIF                    _CIFRR.Bits.FNEBIF
#define CIFRR_WUPIF                     _CIFRR.Bits.WUPIF
#define CIFRR_CHIF                      _CIFRR.Bits.CHIF
#define CIFRR_PRIF                      _CIFRR.Bits.PRIF
#define CIFRR_MIF                       _CIFRR.Bits.MIF

#define CIFRR_TBIF_MASK                 1U
#define CIFRR_RBIF_MASK                 2U
#define CIFRR_FNEAIF_MASK               4U
#define CIFRR_FNEBIF_MASK               8U
#define CIFRR_WUPIF_MASK                16U
#define CIFRR_CHIF_MASK                 32U
#define CIFRR_PRIF_MASK                 64U
#define CIFRR_MIF_MASK                  128U


/*** SFCNTR - Sync Frame Counter Register; 0x00000440 ***/
typedef union {
  word Word;
  struct {
    word SFODA       :4;                                       /* Sync Frames Channel A, odd cycle */
    word SFODB       :4;                                       /* Sync Frames Channel B, odd cycle */
    word SFEVA       :4;                                       /* Sync Frames Channel A, even cycle */
    word SFEVB       :4;                                       /* Sync Frames Channel B, even cycle */
  } Bits;
} SFCNTRSTR;
extern volatile SFCNTRSTR _SFCNTR @(REG_BASE + 0x00000440UL);
#define SFCNTR                          _SFCNTR.Word
#define SFCNTR_SFODA                    _SFCNTR.Bits.SFODA
#define SFCNTR_SFODB                    _SFCNTR.Bits.SFODB
#define SFCNTR_SFEVA                    _SFCNTR.Bits.SFEVA
#define SFCNTR_SFEVB                    _SFCNTR.Bits.SFEVB

#define SFCNTR_SFODA_MASK               15U
#define SFCNTR_SFODA_BITNUM             0U
#define SFCNTR_SFODB_MASK               240U
#define SFCNTR_SFODB_BITNUM             4U
#define SFCNTR_SFEVA_MASK               3840U
#define SFCNTR_SFEVA_BITNUM             8U
#define SFCNTR_SFEVB_MASK               61440U
#define SFCNTR_SFEVB_BITNUM             12U


/*** SFTOR - Sync Frame Table Offset Register; 0x00000442 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word SFT_OFFSET1 :1;                                       /* Sync Frame Table Offset Bit 1 */
    word SFT_OFFSET2 :1;                                       /* Sync Frame Table Offset Bit 2 */
    word SFT_OFFSET3 :1;                                       /* Sync Frame Table Offset Bit 3 */
    word SFT_OFFSET4 :1;                                       /* Sync Frame Table Offset Bit 4 */
    word SFT_OFFSET5 :1;                                       /* Sync Frame Table Offset Bit 5 */
    word SFT_OFFSET6 :1;                                       /* Sync Frame Table Offset Bit 6 */
    word SFT_OFFSET7 :1;                                       /* Sync Frame Table Offset Bit 7 */
    word SFT_OFFSET8 :1;                                       /* Sync Frame Table Offset Bit 8 */
    word SFT_OFFSET9 :1;                                       /* Sync Frame Table Offset Bit 9 */
    word SFT_OFFSET10 :1;                                      /* Sync Frame Table Offset Bit 10 */
    word SFT_OFFSET11 :1;                                      /* Sync Frame Table Offset Bit 11 */
    word SFT_OFFSET12 :1;                                      /* Sync Frame Table Offset Bit 12 */
    word SFT_OFFSET13 :1;                                      /* Sync Frame Table Offset Bit 13 */
    word SFT_OFFSET14 :1;                                      /* Sync Frame Table Offset Bit 14 */
    word SFT_OFFSET15 :1;                                      /* Sync Frame Table Offset Bit 15 */
  } Bits;
  struct {
    word         :1;
    word grpSFT_OFFSET_1 :15;
  } MergedBits;
} SFTORSTR;
extern volatile SFTORSTR _SFTOR @(REG_BASE + 0x00000442UL);
#define SFTOR                           _SFTOR.Word
#define SFTOR_SFT_OFFSET1               _SFTOR.Bits.SFT_OFFSET1
#define SFTOR_SFT_OFFSET2               _SFTOR.Bits.SFT_OFFSET2
#define SFTOR_SFT_OFFSET3               _SFTOR.Bits.SFT_OFFSET3
#define SFTOR_SFT_OFFSET4               _SFTOR.Bits.SFT_OFFSET4
#define SFTOR_SFT_OFFSET5               _SFTOR.Bits.SFT_OFFSET5
#define SFTOR_SFT_OFFSET6               _SFTOR.Bits.SFT_OFFSET6
#define SFTOR_SFT_OFFSET7               _SFTOR.Bits.SFT_OFFSET7
#define SFTOR_SFT_OFFSET8               _SFTOR.Bits.SFT_OFFSET8
#define SFTOR_SFT_OFFSET9               _SFTOR.Bits.SFT_OFFSET9
#define SFTOR_SFT_OFFSET10              _SFTOR.Bits.SFT_OFFSET10
#define SFTOR_SFT_OFFSET11              _SFTOR.Bits.SFT_OFFSET11
#define SFTOR_SFT_OFFSET12              _SFTOR.Bits.SFT_OFFSET12
#define SFTOR_SFT_OFFSET13              _SFTOR.Bits.SFT_OFFSET13
#define SFTOR_SFT_OFFSET14              _SFTOR.Bits.SFT_OFFSET14
#define SFTOR_SFT_OFFSET15              _SFTOR.Bits.SFT_OFFSET15
#define SFTOR_SFT_OFFSET_1              _SFTOR.MergedBits.grpSFT_OFFSET_1
#define SFTOR_SFT_OFFSET                SFTOR_SFT_OFFSET_1

#define SFTOR_SFT_OFFSET1_MASK          2U
#define SFTOR_SFT_OFFSET2_MASK          4U
#define SFTOR_SFT_OFFSET3_MASK          8U
#define SFTOR_SFT_OFFSET4_MASK          16U
#define SFTOR_SFT_OFFSET5_MASK          32U
#define SFTOR_SFT_OFFSET6_MASK          64U
#define SFTOR_SFT_OFFSET7_MASK          128U
#define SFTOR_SFT_OFFSET8_MASK          256U
#define SFTOR_SFT_OFFSET9_MASK          512U
#define SFTOR_SFT_OFFSET10_MASK         1024U
#define SFTOR_SFT_OFFSET11_MASK         2048U
#define SFTOR_SFT_OFFSET12_MASK         4096U
#define SFTOR_SFT_OFFSET13_MASK         8192U
#define SFTOR_SFT_OFFSET14_MASK         16384U
#define SFTOR_SFT_OFFSET15_MASK         32768U
#define SFTOR_SFT_OFFSET_1_MASK         65534U
#define SFTOR_SFT_OFFSET_1_BITNUM       1U


/*** SFTCCSR - Sync Frame Table Configuration, Control, Status Register; 0x00000444 ***/
typedef union {
  word Word;
  struct {
    word SIDEN       :1;                                       /* Sync Frame ID Table Enable */
    word SDVEN       :1;                                       /* Sync Frame Deviation Table Enable */
    word OPT         :1;                                       /* One Pair Trigger */
    word             :1; 
    word OVAL        :1;                                       /* Odd Cycle Tables Valid */
    word EVAL        :1;                                       /* Even Cycle Tables Valid */
    word OLKS        :1;                                       /* Odd Cycle Tables Lock Status */
    word ELKS        :1;                                       /* Even Cycle Tables Lock Status */
    word CYCNUM      :6;                                       /* Cycle Number */
    word OLKT        :1;                                       /* Odd Cycle Tables Lock/Unlock Trigger */
    word ELKT        :1;                                       /* Even Cycle Tables Lock/Unlock Trigger */
  } Bits;
} SFTCCSRSTR;
extern volatile SFTCCSRSTR _SFTCCSR @(REG_BASE + 0x00000444UL);
#define SFTCCSR                         _SFTCCSR.Word
#define SFTCCSR_SIDEN                   _SFTCCSR.Bits.SIDEN
#define SFTCCSR_SDVEN                   _SFTCCSR.Bits.SDVEN
#define SFTCCSR_OPT                     _SFTCCSR.Bits.OPT
#define SFTCCSR_OVAL                    _SFTCCSR.Bits.OVAL
#define SFTCCSR_EVAL                    _SFTCCSR.Bits.EVAL
#define SFTCCSR_OLKS                    _SFTCCSR.Bits.OLKS
#define SFTCCSR_ELKS                    _SFTCCSR.Bits.ELKS
#define SFTCCSR_CYCNUM                  _SFTCCSR.Bits.CYCNUM
#define SFTCCSR_OLKT                    _SFTCCSR.Bits.OLKT
#define SFTCCSR_ELKT                    _SFTCCSR.Bits.ELKT

#define SFTCCSR_SIDEN_MASK              1U
#define SFTCCSR_SDVEN_MASK              2U
#define SFTCCSR_OPT_MASK                4U
#define SFTCCSR_OVAL_MASK               16U
#define SFTCCSR_EVAL_MASK               32U
#define SFTCCSR_OLKS_MASK               64U
#define SFTCCSR_ELKS_MASK               128U
#define SFTCCSR_CYCNUM_MASK             16128U
#define SFTCCSR_CYCNUM_BITNUM           8U
#define SFTCCSR_OLKT_MASK               16384U
#define SFTCCSR_ELKT_MASK               32768U


/*** SFIDRFR - Sync Frame ID Rejection Filter Register; 0x00000446 ***/
typedef union {
  word Word;
  struct {
    word SYNFRID     :10;                                      /* Sync Frame Rejection ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SFIDRFRSTR;
extern volatile SFIDRFRSTR _SFIDRFR @(REG_BASE + 0x00000446UL);
#define SFIDRFR                         _SFIDRFR.Word
#define SFIDRFR_SYNFRID                 _SFIDRFR.Bits.SYNFRID

#define SFIDRFR_SYNFRID_MASK            1023U
#define SFIDRFR_SYNFRID_BITNUM          0U


/*** SFIDAFVR - Sync Frame ID Acceptance Filter Value Register; 0x00000448 ***/
typedef union {
  word Word;
  struct {
    word FVAL        :10;                                      /* Filter Value */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SFIDAFVRSTR;
extern volatile SFIDAFVRSTR _SFIDAFVR @(REG_BASE + 0x00000448UL);
#define SFIDAFVR                        _SFIDAFVR.Word
#define SFIDAFVR_FVAL                   _SFIDAFVR.Bits.FVAL

#define SFIDAFVR_FVAL_MASK              1023U
#define SFIDAFVR_FVAL_BITNUM            0U


/*** SFIDAFMR - Sync Frame ID Acceptance Filter Mask Register; 0x0000044A ***/
typedef union {
  word Word;
  struct {
    word FMSK        :10;                                      /* Filter Mask */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SFIDAFMRSTR;
extern volatile SFIDAFMRSTR _SFIDAFMR @(REG_BASE + 0x0000044AUL);
#define SFIDAFMR                        _SFIDAFMR.Word
#define SFIDAFMR_FMSK                   _SFIDAFMR.Bits.FMSK

#define SFIDAFMR_FMSK_MASK              1023U
#define SFIDAFMR_FMSK_BITNUM            0U


/*** NMVR0 - Network Management Vector Register 0; 0x0000044C ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR0STR;
extern volatile NMVR0STR _NMVR0 @(REG_BASE + 0x0000044CUL);
#define NMVR0                           _NMVR0.Word
#define NMVR0_NMVP                      _NMVR0.Bits.NMVP
/* NMVR_ARR: Access 6 NMVRx registers in an array */
#define NMVR_ARR                        ((volatile word *) &NMVR0)

#define NMVR0_NMVP_MASK                 65535U
#define NMVR0_NMVP_BITNUM               0U


/*** NMVR1 - Network Management Vector Register 1; 0x0000044E ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR1STR;
extern volatile NMVR1STR _NMVR1 @(REG_BASE + 0x0000044EUL);
#define NMVR1                           _NMVR1.Word
#define NMVR1_NMVP                      _NMVR1.Bits.NMVP

#define NMVR1_NMVP_MASK                 65535U
#define NMVR1_NMVP_BITNUM               0U


/*** NMVR2 - Network Management Vector Register 2; 0x00000450 ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR2STR;
extern volatile NMVR2STR _NMVR2 @(REG_BASE + 0x00000450UL);
#define NMVR2                           _NMVR2.Word
#define NMVR2_NMVP                      _NMVR2.Bits.NMVP

#define NMVR2_NMVP_MASK                 65535U
#define NMVR2_NMVP_BITNUM               0U


/*** NMVR3 - Network Management Vector Register 3; 0x00000452 ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR3STR;
extern volatile NMVR3STR _NMVR3 @(REG_BASE + 0x00000452UL);
#define NMVR3                           _NMVR3.Word
#define NMVR3_NMVP                      _NMVR3.Bits.NMVP

#define NMVR3_NMVP_MASK                 65535U
#define NMVR3_NMVP_BITNUM               0U


/*** NMVR4 - Network Management Vector Register 4; 0x00000454 ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR4STR;
extern volatile NMVR4STR _NMVR4 @(REG_BASE + 0x00000454UL);
#define NMVR4                           _NMVR4.Word
#define NMVR4_NMVP                      _NMVR4.Bits.NMVP

#define NMVR4_NMVP_MASK                 65535U
#define NMVR4_NMVP_BITNUM               0U


/*** NMVR5 - Network Management Vector Register 5; 0x00000456 ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR5STR;
extern volatile NMVR5STR _NMVR5 @(REG_BASE + 0x00000456UL);
#define NMVR5                           _NMVR5.Word
#define NMVR5_NMVP                      _NMVR5.Bits.NMVP

#define NMVR5_NMVP_MASK                 65535U
#define NMVR5_NMVP_BITNUM               0U


/*** NMVLR - Network Management Vector Length Register; 0x00000458 ***/
typedef union {
  word Word;
  struct {
    word NMVL        :4;                                       /* Network Management Vector Length */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NMVLRSTR;
extern volatile NMVLRSTR _NMVLR @(REG_BASE + 0x00000458UL);
#define NMVLR                           _NMVLR.Word
#define NMVLR_NMVL                      _NMVLR.Bits.NMVL

#define NMVLR_NMVL_MASK                 15U
#define NMVLR_NMVL_BITNUM               0U


/*** TICCR - Timer Configuration and Control Register; 0x0000045A ***/
typedef union {
  word Word;
  struct {
    word T1ST        :1;                                       /* Timer T1 State */
    word T1TR        :1;                                       /* Timer T1 Trigger */
    word T1SP        :1;                                       /* Timer T1 Stop */
    word             :1; 
    word T1_REP      :1;                                       /* Timer T1 Repetitive Mode */
    word             :1; 
    word             :1; 
    word             :1; 
    word T2ST        :1;                                       /* Timer T2 State */
    word T2TR        :1;                                       /* Timer T2 Trigger */
    word T2SP        :1;                                       /* Timer T2 Stop */
    word             :1; 
    word T2_REP      :1;                                       /* Timer T2 Repetitive Mode */
    word T2_CFG      :1;                                       /* Timer T2 Configuration */
    word             :1; 
    word             :1; 
  } Bits;
} TICCRSTR;
extern volatile TICCRSTR _TICCR @(REG_BASE + 0x0000045AUL);
#define TICCR                           _TICCR.Word
#define TICCR_T1ST                      _TICCR.Bits.T1ST
#define TICCR_T1TR                      _TICCR.Bits.T1TR
#define TICCR_T1SP                      _TICCR.Bits.T1SP
#define TICCR_T1_REP                    _TICCR.Bits.T1_REP
#define TICCR_T2ST                      _TICCR.Bits.T2ST
#define TICCR_T2TR                      _TICCR.Bits.T2TR
#define TICCR_T2SP                      _TICCR.Bits.T2SP
#define TICCR_T2_REP                    _TICCR.Bits.T2_REP
#define TICCR_T2_CFG                    _TICCR.Bits.T2_CFG

#define TICCR_T1ST_MASK                 1U
#define TICCR_T1TR_MASK                 2U
#define TICCR_T1SP_MASK                 4U
#define TICCR_T1_REP_MASK               16U
#define TICCR_T2ST_MASK                 256U
#define TICCR_T2TR_MASK                 512U
#define TICCR_T2SP_MASK                 1024U
#define TICCR_T2_REP_MASK               4096U
#define TICCR_T2_CFG_MASK               8192U


/*** TI1CYSR - Timer 1 Cycle Set Register; 0x0000045C ***/
typedef union {
  word Word;
  struct {
    word T1_CYC_MSK  :6;                                       /* Timer T1 Cycle Filter Mask */
    word             :1; 
    word             :1; 
    word T1_CYC_VAL  :6;                                       /* Timer T1 Cycle Filter Value */
    word             :1; 
    word             :1; 
  } Bits;
} TI1CYSRSTR;
extern volatile TI1CYSRSTR _TI1CYSR @(REG_BASE + 0x0000045CUL);
#define TI1CYSR                         _TI1CYSR.Word
#define TI1CYSR_T1_CYC_MSK              _TI1CYSR.Bits.T1_CYC_MSK
#define TI1CYSR_T1_CYC_VAL              _TI1CYSR.Bits.T1_CYC_VAL

#define TI1CYSR_T1_CYC_MSK_MASK         63U
#define TI1CYSR_T1_CYC_MSK_BITNUM       0U
#define TI1CYSR_T1_CYC_VAL_MASK         16128U
#define TI1CYSR_T1_CYC_VAL_BITNUM       8U


/*** TI1MTOR - Timer 1 Macrotick Offset Register; 0x0000045E ***/
typedef union {
  word Word;
  struct {
    word T1_MTOFFSET :14;                                      /* Timer 1 Macrotick Offset */
    word             :1; 
    word             :1; 
  } Bits;
} TI1MTORSTR;
extern volatile TI1MTORSTR _TI1MTOR @(REG_BASE + 0x0000045EUL);
#define TI1MTOR                         _TI1MTOR.Word
#define TI1MTOR_T1_MTOFFSET             _TI1MTOR.Bits.T1_MTOFFSET

#define TI1MTOR_T1_MTOFFSET_MASK        16383U
#define TI1MTOR_T1_MTOFFSET_BITNUM      0U


/*** TI2CR0_MTCNT - Timer 2 Configuration Register 1; 0x00000460 ***/
typedef union {
  word Word;
  union { /* Several registers at the same address */
    /*** TI2CR0_MTCNT - Timer 2 Configuration Register 1; Several registers at the same address ***/
    union {
      struct {
        word T2_MTCNT    :16;                                      /* Timer T2 Macrotick High Word */
      } Bits;
    } TI2CR0_MTCNTSTR;
    #define TI2CR0_MTCNT                _TI2CR0_MTCNT.Word
    #define TI2CR0_MTCNT_T2_MTCNT       _TI2CR0_MTCNT.SameAddr_STR.TI2CR0_MTCNTSTR.Bits.T2_MTCNT
    
    #define TI2CR0_MTCNT_T2_MTCNT_MASK  65535U
    #define TI2CR0_MTCNT_T2_MTCNT_BITNUM 0U
    
    /*** TI2CR0_CYC - Timer 2 Configuration Register 0; Several registers at the same address ***/
    union {
      struct {
        word T2_CYC_MSK  :6;                                       /* Timer T2 Cycle Filter Mask */
        word             :1; 
        word             :1; 
        word T2_CYC_VAL  :6;                                       /* Timer T2 Cycle Filter Value */
        word             :1; 
        word             :1; 
      } Bits;
    } TI2CR0_CYCSTR;
    #define TI2CR0_CYC                  _TI2CR0_MTCNT.Word
    #define TI2CR0_CYC_T2_CYC_MSK       _TI2CR0_MTCNT.SameAddr_STR.TI2CR0_CYCSTR.Bits.T2_CYC_MSK
    #define TI2CR0_CYC_T2_CYC_VAL       _TI2CR0_MTCNT.SameAddr_STR.TI2CR0_CYCSTR.Bits.T2_CYC_VAL
    
    #define TI2CR0_CYC_T2_CYC_MSK_MASK  63U
    #define TI2CR0_CYC_T2_CYC_MSK_BITNUM 0U
    #define TI2CR0_CYC_T2_CYC_VAL_MASK  16128U
    #define TI2CR0_CYC_T2_CYC_VAL_BITNUM 8U
    
  } SameAddr_STR; /*Several registers at the same address */

} TI2CR0_MTCNTSTR;
extern volatile TI2CR0_MTCNTSTR _TI2CR0_MTCNT @(REG_BASE + 0x00000460UL);


/*** TI2CR1_MTOFFSET - Timer 2 Configuration Register 2; 0x00000462 ***/
typedef union {
  word Word;
  union { /* Several registers at the same address */
    /*** TI2CR1_MTOFFSET - Timer 2 Configuration Register 2; Several registers at the same address ***/
    union {
      struct {
        word T2_MTOFFSET :14;                                      /* Timer T2 Macrotick Offset */
        word             :1; 
        word             :1; 
      } Bits;
    } TI2CR1_MTOFFSETSTR;
    #define TI2CR1_MTOFFSET             _TI2CR1_MTOFFSET.Word
    #define TI2CR1_MTOFFSET_T2_MTOFFSET _TI2CR1_MTOFFSET.SameAddr_STR.TI2CR1_MTOFFSETSTR.Bits.T2_MTOFFSET
    
    #define TI2CR1_MTOFFSET_T2_MTOFFSET_MASK 16383U
    #define TI2CR1_MTOFFSET_T2_MTOFFSET_BITNUM 0U
    
    /*** TI2CR1_MTCNT - Timer 2 Configuration Register 3; Several registers at the same address ***/
    union {
      struct {
        word T2_MTCNT    :16;                                      /* Timer T2 Macrotick Low Word */
      } Bits;
    } TI2CR1_MTCNTSTR;
    #define TI2CR1_MTCNT                _TI2CR1_MTOFFSET.Word
    #define TI2CR1_MTCNT_T2_MTCNT       _TI2CR1_MTOFFSET.SameAddr_STR.TI2CR1_MTCNTSTR.Bits.T2_MTCNT
    
    #define TI2CR1_MTCNT_T2_MTCNT_MASK  65535U
    #define TI2CR1_MTCNT_T2_MTCNT_BITNUM 0U
    
  } SameAddr_STR; /*Several registers at the same address */

} TI2CR1_MTOFFSETSTR;
extern volatile TI2CR1_MTOFFSETSTR _TI2CR1_MTOFFSET @(REG_BASE + 0x00000462UL);


/*** SSSR - Slot Status Selection Register; 0x00000464 ***/
typedef union {
  word Word;
  struct {
    word SLOTNUMBER  :11;                                      /* Slot Number */
    word             :1; 
    word SEL         :2;                                       /* Selector */
    word             :1; 
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} SSSRSTR;
extern volatile SSSRSTR _SSSR @(REG_BASE + 0x00000464UL);
#define SSSR                            _SSSR.Word
#define SSSR_SLOTNUMBER                 _SSSR.Bits.SLOTNUMBER
#define SSSR_SEL                        _SSSR.Bits.SEL
#define SSSR_WMD                        _SSSR.Bits.WMD

#define SSSR_SLOTNUMBER_MASK            2047U
#define SSSR_SLOTNUMBER_BITNUM          0U
#define SSSR_SEL_MASK                   12288U
#define SSSR_SEL_BITNUM                 12U
#define SSSR_WMD_MASK                   32768U


/*** SSCCR - Slot Status Selection Register; 0x00000466 ***/
typedef union {
  word Word;
  struct {
    word STATUSMASK  :4;                                       /* Slot Status Mask */
    word SUF         :1;                                       /* Startup Frame Restriction */
    word NUF         :1;                                       /* Null Frame Restriction */
    word SYF         :1;                                       /* Sync Frame Restriction */
    word VFR         :1;                                       /* Valid Frame Restrictio */
    word MCY         :1;                                       /* Multi Cycle Selection */
    word CNTCFG      :2;                                       /* Counter Configuration */
    word             :1; 
    word SEL         :2;                                       /* Selector */
    word             :1; 
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} SSCCRSTR;
extern volatile SSCCRSTR _SSCCR @(REG_BASE + 0x00000466UL);
#define SSCCR                           _SSCCR.Word
#define SSCCR_STATUSMASK                _SSCCR.Bits.STATUSMASK
#define SSCCR_SUF                       _SSCCR.Bits.SUF
#define SSCCR_NUF                       _SSCCR.Bits.NUF
#define SSCCR_SYF                       _SSCCR.Bits.SYF
#define SSCCR_VFR                       _SSCCR.Bits.VFR
#define SSCCR_MCY                       _SSCCR.Bits.MCY
#define SSCCR_CNTCFG                    _SSCCR.Bits.CNTCFG
#define SSCCR_SEL                       _SSCCR.Bits.SEL
#define SSCCR_WMD                       _SSCCR.Bits.WMD

#define SSCCR_STATUSMASK_MASK           15U
#define SSCCR_STATUSMASK_BITNUM         0U
#define SSCCR_SUF_MASK                  16U
#define SSCCR_NUF_MASK                  32U
#define SSCCR_SYF_MASK                  64U
#define SSCCR_VFR_MASK                  128U
#define SSCCR_MCY_MASK                  256U
#define SSCCR_CNTCFG_MASK               1536U
#define SSCCR_CNTCFG_BITNUM             9U
#define SSCCR_SEL_MASK                  12288U
#define SSCCR_SEL_BITNUM                12U
#define SSCCR_WMD_MASK                  32768U


/*** SSR0 - Slot Status Register 0; 0x00000468 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR0STR;
extern volatile SSR0STR _SSR0 @(REG_BASE + 0x00000468UL);
#define SSR0                            _SSR0.Word
#define SSR0_TCA                        _SSR0.Bits.TCA
#define SSR0_BVA                        _SSR0.Bits.BVA
#define SSR0_CEA                        _SSR0.Bits.CEA
#define SSR0_SEA                        _SSR0.Bits.SEA
#define SSR0_SUA                        _SSR0.Bits.SUA
#define SSR0_NFA                        _SSR0.Bits.NFA
#define SSR0_SYA                        _SSR0.Bits.SYA
#define SSR0_VFA                        _SSR0.Bits.VFA
#define SSR0_TCB                        _SSR0.Bits.TCB
#define SSR0_BVB                        _SSR0.Bits.BVB
#define SSR0_CEB                        _SSR0.Bits.CEB
#define SSR0_SEB                        _SSR0.Bits.SEB
#define SSR0_SUB                        _SSR0.Bits.SUB
#define SSR0_NFB                        _SSR0.Bits.NFB
#define SSR0_SYB                        _SSR0.Bits.SYB
#define SSR0_VFB                        _SSR0.Bits.VFB
/* SSR_ARR: Access 8 SSRx registers in an array */
#define SSR_ARR                         ((volatile word *) &SSR0)

#define SSR0_TCA_MASK                   1U
#define SSR0_BVA_MASK                   2U
#define SSR0_CEA_MASK                   4U
#define SSR0_SEA_MASK                   8U
#define SSR0_SUA_MASK                   16U
#define SSR0_NFA_MASK                   32U
#define SSR0_SYA_MASK                   64U
#define SSR0_VFA_MASK                   128U
#define SSR0_TCB_MASK                   256U
#define SSR0_BVB_MASK                   512U
#define SSR0_CEB_MASK                   1024U
#define SSR0_SEB_MASK                   2048U
#define SSR0_SUB_MASK                   4096U
#define SSR0_NFB_MASK                   8192U
#define SSR0_SYB_MASK                   16384U
#define SSR0_VFB_MASK                   32768U


/*** SSR1 - Slot Status Register 1; 0x0000046A ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR1STR;
extern volatile SSR1STR _SSR1 @(REG_BASE + 0x0000046AUL);
#define SSR1                            _SSR1.Word
#define SSR1_TCA                        _SSR1.Bits.TCA
#define SSR1_BVA                        _SSR1.Bits.BVA
#define SSR1_CEA                        _SSR1.Bits.CEA
#define SSR1_SEA                        _SSR1.Bits.SEA
#define SSR1_SUA                        _SSR1.Bits.SUA
#define SSR1_NFA                        _SSR1.Bits.NFA
#define SSR1_SYA                        _SSR1.Bits.SYA
#define SSR1_VFA                        _SSR1.Bits.VFA
#define SSR1_TCB                        _SSR1.Bits.TCB
#define SSR1_BVB                        _SSR1.Bits.BVB
#define SSR1_CEB                        _SSR1.Bits.CEB
#define SSR1_SEB                        _SSR1.Bits.SEB
#define SSR1_SUB                        _SSR1.Bits.SUB
#define SSR1_NFB                        _SSR1.Bits.NFB
#define SSR1_SYB                        _SSR1.Bits.SYB
#define SSR1_VFB                        _SSR1.Bits.VFB

#define SSR1_TCA_MASK                   1U
#define SSR1_BVA_MASK                   2U
#define SSR1_CEA_MASK                   4U
#define SSR1_SEA_MASK                   8U
#define SSR1_SUA_MASK                   16U
#define SSR1_NFA_MASK                   32U
#define SSR1_SYA_MASK                   64U
#define SSR1_VFA_MASK                   128U
#define SSR1_TCB_MASK                   256U
#define SSR1_BVB_MASK                   512U
#define SSR1_CEB_MASK                   1024U
#define SSR1_SEB_MASK                   2048U
#define SSR1_SUB_MASK                   4096U
#define SSR1_NFB_MASK                   8192U
#define SSR1_SYB_MASK                   16384U
#define SSR1_VFB_MASK                   32768U


/*** SSR2 - Slot Status Register 2; 0x0000046C ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR2STR;
extern volatile SSR2STR _SSR2 @(REG_BASE + 0x0000046CUL);
#define SSR2                            _SSR2.Word
#define SSR2_TCA                        _SSR2.Bits.TCA
#define SSR2_BVA                        _SSR2.Bits.BVA
#define SSR2_CEA                        _SSR2.Bits.CEA
#define SSR2_SEA                        _SSR2.Bits.SEA
#define SSR2_SUA                        _SSR2.Bits.SUA
#define SSR2_NFA                        _SSR2.Bits.NFA
#define SSR2_SYA                        _SSR2.Bits.SYA
#define SSR2_VFA                        _SSR2.Bits.VFA
#define SSR2_TCB                        _SSR2.Bits.TCB
#define SSR2_BVB                        _SSR2.Bits.BVB
#define SSR2_CEB                        _SSR2.Bits.CEB
#define SSR2_SEB                        _SSR2.Bits.SEB
#define SSR2_SUB                        _SSR2.Bits.SUB
#define SSR2_NFB                        _SSR2.Bits.NFB
#define SSR2_SYB                        _SSR2.Bits.SYB
#define SSR2_VFB                        _SSR2.Bits.VFB

#define SSR2_TCA_MASK                   1U
#define SSR2_BVA_MASK                   2U
#define SSR2_CEA_MASK                   4U
#define SSR2_SEA_MASK                   8U
#define SSR2_SUA_MASK                   16U
#define SSR2_NFA_MASK                   32U
#define SSR2_SYA_MASK                   64U
#define SSR2_VFA_MASK                   128U
#define SSR2_TCB_MASK                   256U
#define SSR2_BVB_MASK                   512U
#define SSR2_CEB_MASK                   1024U
#define SSR2_SEB_MASK                   2048U
#define SSR2_SUB_MASK                   4096U
#define SSR2_NFB_MASK                   8192U
#define SSR2_SYB_MASK                   16384U
#define SSR2_VFB_MASK                   32768U


/*** SSR3 - Slot Status Register 3; 0x0000046E ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR3STR;
extern volatile SSR3STR _SSR3 @(REG_BASE + 0x0000046EUL);
#define SSR3                            _SSR3.Word
#define SSR3_TCA                        _SSR3.Bits.TCA
#define SSR3_BVA                        _SSR3.Bits.BVA
#define SSR3_CEA                        _SSR3.Bits.CEA
#define SSR3_SEA                        _SSR3.Bits.SEA
#define SSR3_SUA                        _SSR3.Bits.SUA
#define SSR3_NFA                        _SSR3.Bits.NFA
#define SSR3_SYA                        _SSR3.Bits.SYA
#define SSR3_VFA                        _SSR3.Bits.VFA
#define SSR3_TCB                        _SSR3.Bits.TCB
#define SSR3_BVB                        _SSR3.Bits.BVB
#define SSR3_CEB                        _SSR3.Bits.CEB
#define SSR3_SEB                        _SSR3.Bits.SEB
#define SSR3_SUB                        _SSR3.Bits.SUB
#define SSR3_NFB                        _SSR3.Bits.NFB
#define SSR3_SYB                        _SSR3.Bits.SYB
#define SSR3_VFB                        _SSR3.Bits.VFB

#define SSR3_TCA_MASK                   1U
#define SSR3_BVA_MASK                   2U
#define SSR3_CEA_MASK                   4U
#define SSR3_SEA_MASK                   8U
#define SSR3_SUA_MASK                   16U
#define SSR3_NFA_MASK                   32U
#define SSR3_SYA_MASK                   64U
#define SSR3_VFA_MASK                   128U
#define SSR3_TCB_MASK                   256U
#define SSR3_BVB_MASK                   512U
#define SSR3_CEB_MASK                   1024U
#define SSR3_SEB_MASK                   2048U
#define SSR3_SUB_MASK                   4096U
#define SSR3_NFB_MASK                   8192U
#define SSR3_SYB_MASK                   16384U
#define SSR3_VFB_MASK                   32768U


/*** SSR4 - Slot Status Register 4; 0x00000470 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR4STR;
extern volatile SSR4STR _SSR4 @(REG_BASE + 0x00000470UL);
#define SSR4                            _SSR4.Word
#define SSR4_TCA                        _SSR4.Bits.TCA
#define SSR4_BVA                        _SSR4.Bits.BVA
#define SSR4_CEA                        _SSR4.Bits.CEA
#define SSR4_SEA                        _SSR4.Bits.SEA
#define SSR4_SUA                        _SSR4.Bits.SUA
#define SSR4_NFA                        _SSR4.Bits.NFA
#define SSR4_SYA                        _SSR4.Bits.SYA
#define SSR4_VFA                        _SSR4.Bits.VFA
#define SSR4_TCB                        _SSR4.Bits.TCB
#define SSR4_BVB                        _SSR4.Bits.BVB
#define SSR4_CEB                        _SSR4.Bits.CEB
#define SSR4_SEB                        _SSR4.Bits.SEB
#define SSR4_SUB                        _SSR4.Bits.SUB
#define SSR4_NFB                        _SSR4.Bits.NFB
#define SSR4_SYB                        _SSR4.Bits.SYB
#define SSR4_VFB                        _SSR4.Bits.VFB

#define SSR4_TCA_MASK                   1U
#define SSR4_BVA_MASK                   2U
#define SSR4_CEA_MASK                   4U
#define SSR4_SEA_MASK                   8U
#define SSR4_SUA_MASK                   16U
#define SSR4_NFA_MASK                   32U
#define SSR4_SYA_MASK                   64U
#define SSR4_VFA_MASK                   128U
#define SSR4_TCB_MASK                   256U
#define SSR4_BVB_MASK                   512U
#define SSR4_CEB_MASK                   1024U
#define SSR4_SEB_MASK                   2048U
#define SSR4_SUB_MASK                   4096U
#define SSR4_NFB_MASK                   8192U
#define SSR4_SYB_MASK                   16384U
#define SSR4_VFB_MASK                   32768U


/*** SSR5 - Slot Status Register 5; 0x00000472 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR5STR;
extern volatile SSR5STR _SSR5 @(REG_BASE + 0x00000472UL);
#define SSR5                            _SSR5.Word
#define SSR5_TCA                        _SSR5.Bits.TCA
#define SSR5_BVA                        _SSR5.Bits.BVA
#define SSR5_CEA                        _SSR5.Bits.CEA
#define SSR5_SEA                        _SSR5.Bits.SEA
#define SSR5_SUA                        _SSR5.Bits.SUA
#define SSR5_NFA                        _SSR5.Bits.NFA
#define SSR5_SYA                        _SSR5.Bits.SYA
#define SSR5_VFA                        _SSR5.Bits.VFA
#define SSR5_TCB                        _SSR5.Bits.TCB
#define SSR5_BVB                        _SSR5.Bits.BVB
#define SSR5_CEB                        _SSR5.Bits.CEB
#define SSR5_SEB                        _SSR5.Bits.SEB
#define SSR5_SUB                        _SSR5.Bits.SUB
#define SSR5_NFB                        _SSR5.Bits.NFB
#define SSR5_SYB                        _SSR5.Bits.SYB
#define SSR5_VFB                        _SSR5.Bits.VFB

#define SSR5_TCA_MASK                   1U
#define SSR5_BVA_MASK                   2U
#define SSR5_CEA_MASK                   4U
#define SSR5_SEA_MASK                   8U
#define SSR5_SUA_MASK                   16U
#define SSR5_NFA_MASK                   32U
#define SSR5_SYA_MASK                   64U
#define SSR5_VFA_MASK                   128U
#define SSR5_TCB_MASK                   256U
#define SSR5_BVB_MASK                   512U
#define SSR5_CEB_MASK                   1024U
#define SSR5_SEB_MASK                   2048U
#define SSR5_SUB_MASK                   4096U
#define SSR5_NFB_MASK                   8192U
#define SSR5_SYB_MASK                   16384U
#define SSR5_VFB_MASK                   32768U


/*** SSR6 - Slot Status Register 6; 0x00000474 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR6STR;
extern volatile SSR6STR _SSR6 @(REG_BASE + 0x00000474UL);
#define SSR6                            _SSR6.Word
#define SSR6_TCA                        _SSR6.Bits.TCA
#define SSR6_BVA                        _SSR6.Bits.BVA
#define SSR6_CEA                        _SSR6.Bits.CEA
#define SSR6_SEA                        _SSR6.Bits.SEA
#define SSR6_SUA                        _SSR6.Bits.SUA
#define SSR6_NFA                        _SSR6.Bits.NFA
#define SSR6_SYA                        _SSR6.Bits.SYA
#define SSR6_VFA                        _SSR6.Bits.VFA
#define SSR6_TCB                        _SSR6.Bits.TCB
#define SSR6_BVB                        _SSR6.Bits.BVB
#define SSR6_CEB                        _SSR6.Bits.CEB
#define SSR6_SEB                        _SSR6.Bits.SEB
#define SSR6_SUB                        _SSR6.Bits.SUB
#define SSR6_NFB                        _SSR6.Bits.NFB
#define SSR6_SYB                        _SSR6.Bits.SYB
#define SSR6_VFB                        _SSR6.Bits.VFB

#define SSR6_TCA_MASK                   1U
#define SSR6_BVA_MASK                   2U
#define SSR6_CEA_MASK                   4U
#define SSR6_SEA_MASK                   8U
#define SSR6_SUA_MASK                   16U
#define SSR6_NFA_MASK                   32U
#define SSR6_SYA_MASK                   64U
#define SSR6_VFA_MASK                   128U
#define SSR6_TCB_MASK                   256U
#define SSR6_BVB_MASK                   512U
#define SSR6_CEB_MASK                   1024U
#define SSR6_SEB_MASK                   2048U
#define SSR6_SUB_MASK                   4096U
#define SSR6_NFB_MASK                   8192U
#define SSR6_SYB_MASK                   16384U
#define SSR6_VFB_MASK                   32768U


/*** SSR7 - Slot Status Register 7; 0x00000476 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR7STR;
extern volatile SSR7STR _SSR7 @(REG_BASE + 0x00000476UL);
#define SSR7                            _SSR7.Word
#define SSR7_TCA                        _SSR7.Bits.TCA
#define SSR7_BVA                        _SSR7.Bits.BVA
#define SSR7_CEA                        _SSR7.Bits.CEA
#define SSR7_SEA                        _SSR7.Bits.SEA
#define SSR7_SUA                        _SSR7.Bits.SUA
#define SSR7_NFA                        _SSR7.Bits.NFA
#define SSR7_SYA                        _SSR7.Bits.SYA
#define SSR7_VFA                        _SSR7.Bits.VFA
#define SSR7_TCB                        _SSR7.Bits.TCB
#define SSR7_BVB                        _SSR7.Bits.BVB
#define SSR7_CEB                        _SSR7.Bits.CEB
#define SSR7_SEB                        _SSR7.Bits.SEB
#define SSR7_SUB                        _SSR7.Bits.SUB
#define SSR7_NFB                        _SSR7.Bits.NFB
#define SSR7_SYB                        _SSR7.Bits.SYB
#define SSR7_VFB                        _SSR7.Bits.VFB

#define SSR7_TCA_MASK                   1U
#define SSR7_BVA_MASK                   2U
#define SSR7_CEA_MASK                   4U
#define SSR7_SEA_MASK                   8U
#define SSR7_SUA_MASK                   16U
#define SSR7_NFA_MASK                   32U
#define SSR7_SYA_MASK                   64U
#define SSR7_VFA_MASK                   128U
#define SSR7_TCB_MASK                   256U
#define SSR7_BVB_MASK                   512U
#define SSR7_CEB_MASK                   1024U
#define SSR7_SEB_MASK                   2048U
#define SSR7_SUB_MASK                   4096U
#define SSR7_NFB_MASK                   8192U
#define SSR7_SYB_MASK                   16384U
#define SSR7_VFB_MASK                   32768U


/*** SSCR0 - Slot Status Counter Register 0; 0x00000478 ***/
typedef union {
  word Word;
  struct {
    word SLOTSTATUSCNT :16;                                    /* Slot Status Counter */
  } Bits;
} SSCR0STR;
extern volatile SSCR0STR _SSCR0 @(REG_BASE + 0x00000478UL);
#define SSCR0                           _SSCR0.Word
#define SSCR0_SLOTSTATUSCNT             _SSCR0.Bits.SLOTSTATUSCNT
/* SSCR_ARR: Access 4 SSCRx registers in an array */
#define SSCR_ARR                        ((volatile word *) &SSCR0)

#define SSCR0_SLOTSTATUSCNT_MASK        65535U
#define SSCR0_SLOTSTATUSCNT_BITNUM      0U


/*** SSCR1 - Slot Status Counter Register 1; 0x0000047A ***/
typedef union {
  word Word;
  struct {
    word SLOTSTATUSCNT :16;                                    /* Slot Status Counter */
  } Bits;
} SSCR1STR;
extern volatile SSCR1STR _SSCR1 @(REG_BASE + 0x0000047AUL);
#define SSCR1                           _SSCR1.Word
#define SSCR1_SLOTSTATUSCNT             _SSCR1.Bits.SLOTSTATUSCNT

#define SSCR1_SLOTSTATUSCNT_MASK        65535U
#define SSCR1_SLOTSTATUSCNT_BITNUM      0U


/*** SSCR2 - Slot Status Counter Register 2; 0x0000047C ***/
typedef union {
  word Word;
  struct {
    word SLOTSTATUSCNT :16;                                    /* Slot Status Counter */
  } Bits;
} SSCR2STR;
extern volatile SSCR2STR _SSCR2 @(REG_BASE + 0x0000047CUL);
#define SSCR2                           _SSCR2.Word
#define SSCR2_SLOTSTATUSCNT             _SSCR2.Bits.SLOTSTATUSCNT

#define SSCR2_SLOTSTATUSCNT_MASK        65535U
#define SSCR2_SLOTSTATUSCNT_BITNUM      0U


/*** SSCR3 - Slot Status Counter Register 3; 0x0000047E ***/
typedef union {
  word Word;
  struct {
    word SLOTSTATUSCNT :16;                                    /* Slot Status Counter */
  } Bits;
} SSCR3STR;
extern volatile SSCR3STR _SSCR3 @(REG_BASE + 0x0000047EUL);
#define SSCR3                           _SSCR3.Word
#define SSCR3_SLOTSTATUSCNT             _SSCR3.Bits.SLOTSTATUSCNT

#define SSCR3_SLOTSTATUSCNT_MASK        65535U
#define SSCR3_SLOTSTATUSCNT_BITNUM      0U


/*** MTSACFR - MTS A Configuration Register; 0x00000480 ***/
typedef union {
  word Word;
  struct {
    word CYCCNTVAL   :6;                                       /* Cycle Counter Value */
    word             :1; 
    word             :1; 
    word CYCCNTMSK   :6;                                       /* Cycle Counter Mask */
    word             :1; 
    word MTE         :1;                                       /* Media Access Test Symbol Transmission Enable */
  } Bits;
} MTSACFRSTR;
extern volatile MTSACFRSTR _MTSACFR @(REG_BASE + 0x00000480UL);
#define MTSACFR                         _MTSACFR.Word
#define MTSACFR_CYCCNTVAL               _MTSACFR.Bits.CYCCNTVAL
#define MTSACFR_CYCCNTMSK               _MTSACFR.Bits.CYCCNTMSK
#define MTSACFR_MTE                     _MTSACFR.Bits.MTE

#define MTSACFR_CYCCNTVAL_MASK          63U
#define MTSACFR_CYCCNTVAL_BITNUM        0U
#define MTSACFR_CYCCNTMSK_MASK          16128U
#define MTSACFR_CYCCNTMSK_BITNUM        8U
#define MTSACFR_MTE_MASK                32768U


/*** MTSBCFR - MTS B Configuration Register; 0x00000482 ***/
typedef union {
  word Word;
  struct {
    word CYCCNTVAL   :6;                                       /* Cycle Counter Value */
    word             :1; 
    word             :1; 
    word CYCCNTMSK   :6;                                       /* Cycle Counter Mask */
    word             :1; 
    word MTE         :1;                                       /* Media Access Test Symbol Transmission Enable */
  } Bits;
} MTSBCFRSTR;
extern volatile MTSBCFRSTR _MTSBCFR @(REG_BASE + 0x00000482UL);
#define MTSBCFR                         _MTSBCFR.Word
#define MTSBCFR_CYCCNTVAL               _MTSBCFR.Bits.CYCCNTVAL
#define MTSBCFR_CYCCNTMSK               _MTSBCFR.Bits.CYCCNTMSK
#define MTSBCFR_MTE                     _MTSBCFR.Bits.MTE

#define MTSBCFR_CYCCNTVAL_MASK          63U
#define MTSBCFR_CYCCNTVAL_BITNUM        0U
#define MTSBCFR_CYCCNTMSK_MASK          16128U
#define MTSBCFR_CYCCNTMSK_BITNUM        8U
#define MTSBCFR_MTE_MASK                32768U


/*** RSBIR - Receive Shadow Buffer Index Register; 0x00000484 ***/
typedef union {
  word Word;
  struct {
    word RSBIDX      :8;                                       /* Receive Shadow Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word SEL         :2;                                       /* Selector */
    word             :1; 
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} RSBIRSTR;
extern volatile RSBIRSTR _RSBIR @(REG_BASE + 0x00000484UL);
#define RSBIR                           _RSBIR.Word
#define RSBIR_RSBIDX                    _RSBIR.Bits.RSBIDX
#define RSBIR_SEL                       _RSBIR.Bits.SEL
#define RSBIR_WMD                       _RSBIR.Bits.WMD

#define RSBIR_RSBIDX_MASK               255U
#define RSBIR_RSBIDX_BITNUM             0U
#define RSBIR_SEL_MASK                  12288U
#define RSBIR_SEL_BITNUM                12U
#define RSBIR_WMD_MASK                  32768U


/*** RFSR - Receive FIFO Selection Register; 0x00000486 ***/
typedef union {
  word Word;
  struct {
    word SEL         :1;                                       /* Select */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFSRSTR;
extern volatile RFSRSTR _RFSR @(REG_BASE + 0x00000486UL);
#define RFSR                            _RFSR.Word
#define RFSR_SEL                        _RFSR.Bits.SEL

#define RFSR_SEL_MASK                   1U


/*** RFSIR - Receive FIFO Start Index Register; 0x00000488 ***/
typedef union {
  word Word;
  struct {
    word SIDX        :8;                                       /* Start Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFSIRSTR;
extern volatile RFSIRSTR _RFSIR @(REG_BASE + 0x00000488UL);
#define RFSIR                           _RFSIR.Word
#define RFSIR_SIDX                      _RFSIR.Bits.SIDX

#define RFSIR_SIDX_MASK                 255U
#define RFSIR_SIDX_BITNUM               0U


/*** RFDSR - Receive FIFO Depth and Size Register; 0x0000048A ***/
typedef union {
  word Word;
  struct {
    word ENTRY_SIZE  :7;                                       /* Entry Size */
    word             :1; 
    word FIFO_DEPTH  :8;                                       /* FIFO Depth */
  } Bits;
} RFDSRSTR;
extern volatile RFDSRSTR _RFDSR @(REG_BASE + 0x0000048AUL);
#define RFDSR                           _RFDSR.Word
#define RFDSR_ENTRY_SIZE                _RFDSR.Bits.ENTRY_SIZE
#define RFDSR_FIFO_DEPTH                _RFDSR.Bits.FIFO_DEPTH

#define RFDSR_ENTRY_SIZE_MASK           127U
#define RFDSR_ENTRY_SIZE_BITNUM         0U
#define RFDSR_FIFO_DEPTH_MASK           65280U
#define RFDSR_FIFO_DEPTH_BITNUM         8U


/*** RFARIR - Receive FIFO A Read Index Register; 0x0000048C ***/
typedef union {
  word Word;
  struct {
    word RDIDX       :8;                                       /* Read Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFARIRSTR;
extern volatile RFARIRSTR _RFARIR @(REG_BASE + 0x0000048CUL);
#define RFARIR                          _RFARIR.Word
#define RFARIR_RDIDX                    _RFARIR.Bits.RDIDX

#define RFARIR_RDIDX_MASK               255U
#define RFARIR_RDIDX_BITNUM             0U


/*** RFBRIR - Receive FIFO B Read Index Register; 0x0000048E ***/
typedef union {
  word Word;
  struct {
    word RDIDX       :8;                                       /* Read Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFBRIRSTR;
extern volatile RFBRIRSTR _RFBRIR @(REG_BASE + 0x0000048EUL);
#define RFBRIR                          _RFBRIR.Word
#define RFBRIR_RDIDX                    _RFBRIR.Bits.RDIDX

#define RFBRIR_RDIDX_MASK               255U
#define RFBRIR_RDIDX_BITNUM             0U


/*** RFMIDAFVR - Receive FIFO Message ID Acceptance Filter Value Register; 0x00000490 ***/
typedef union {
  word Word;
  struct {
    word MIDAFVAL    :16;                                      /* Message ID Acceptance Filter Value */
  } Bits;
} RFMIDAFVRSTR;
extern volatile RFMIDAFVRSTR _RFMIDAFVR @(REG_BASE + 0x00000490UL);
#define RFMIDAFVR                       _RFMIDAFVR.Word
#define RFMIDAFVR_MIDAFVAL              _RFMIDAFVR.Bits.MIDAFVAL

#define RFMIDAFVR_MIDAFVAL_MASK         65535U
#define RFMIDAFVR_MIDAFVAL_BITNUM       0U


/*** RFMIAFMR - Receive FIFO Message ID Acceptance Filter Mask Register; 0x00000492 ***/
typedef union {
  word Word;
  struct {
    word MIDAFMSK    :16;                                      /* Message ID Acceptance Filter Mask */
  } Bits;
} RFMIAFMRSTR;
extern volatile RFMIAFMRSTR _RFMIAFMR @(REG_BASE + 0x00000492UL);
#define RFMIAFMR                        _RFMIAFMR.Word
#define RFMIAFMR_MIDAFMSK               _RFMIAFMR.Bits.MIDAFMSK

#define RFMIAFMR_MIDAFMSK_MASK          65535U
#define RFMIAFMR_MIDAFMSK_BITNUM        0U


/*** RFFIDRFVR - Receive FIFO Frame ID Rejection Filter Value Register; 0x00000494 ***/
typedef union {
  word Word;
  struct {
    word FIDRFVAL    :11;                                      /* Frame ID Rejection Filter Value */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFFIDRFVRSTR;
extern volatile RFFIDRFVRSTR _RFFIDRFVR @(REG_BASE + 0x00000494UL);
#define RFFIDRFVR                       _RFFIDRFVR.Word
#define RFFIDRFVR_FIDRFVAL              _RFFIDRFVR.Bits.FIDRFVAL

#define RFFIDRFVR_FIDRFVAL_MASK         2047U
#define RFFIDRFVR_FIDRFVAL_BITNUM       0U


/*** RFFIDRFMR - Receive FIFO Frame ID Rejection Filter Mask Register; 0x00000496 ***/
typedef union {
  word Word;
  struct {
    word FIDRFMSK    :11;                                      /* Frame ID Rejection Filter Mask */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFFIDRFMRSTR;
extern volatile RFFIDRFMRSTR _RFFIDRFMR @(REG_BASE + 0x00000496UL);
#define RFFIDRFMR                       _RFFIDRFMR.Word
#define RFFIDRFMR_FIDRFMSK              _RFFIDRFMR.Bits.FIDRFMSK

#define RFFIDRFMR_FIDRFMSK_MASK         2047U
#define RFFIDRFMR_FIDRFMSK_BITNUM       0U


/*** RFRFCFR - Receive FIFO Range Filter Configuration Register; 0x00000498 ***/
typedef union {
  word Word;
  struct {
    word SID         :11;                                      /* Slot ID */
    word             :1; 
    word SEL         :2;                                       /* Filter Selector */
    word IBD         :1;                                       /* Interval Boundary */
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} RFRFCFRSTR;
extern volatile RFRFCFRSTR _RFRFCFR @(REG_BASE + 0x00000498UL);
#define RFRFCFR                         _RFRFCFR.Word
#define RFRFCFR_SID                     _RFRFCFR.Bits.SID
#define RFRFCFR_SEL                     _RFRFCFR.Bits.SEL
#define RFRFCFR_IBD                     _RFRFCFR.Bits.IBD
#define RFRFCFR_WMD                     _RFRFCFR.Bits.WMD

#define RFRFCFR_SID_MASK                2047U
#define RFRFCFR_SID_BITNUM              0U
#define RFRFCFR_SEL_MASK                12288U
#define RFRFCFR_SEL_BITNUM              12U
#define RFRFCFR_IBD_MASK                16384U
#define RFRFCFR_WMD_MASK                32768U


/*** RFRFCTR - Receive FIFO Range Filter Control Register; 0x0000049A ***/
typedef union {
  word Word;
  struct {
    word F0EN        :1;                                       /* Range Filter 0 Enable */
    word F1EN        :1;                                       /* Range Filter 1 Enable */
    word F2EN        :1;                                       /* Range Filter 2 Enable */
    word F3EN        :1;                                       /* Range Filter 3 Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word F0MD        :1;                                       /* Range Filter 0 Mode */
    word F1MD        :1;                                       /* Range Filter 1 Mode */
    word F2MD        :1;                                       /* Range Filter 2 Mode */
    word F3MD        :1;                                       /* Range Filter 3 Mode */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFRFCTRSTR;
extern volatile RFRFCTRSTR _RFRFCTR @(REG_BASE + 0x0000049AUL);
#define RFRFCTR                         _RFRFCTR.Word
#define RFRFCTR_F0EN                    _RFRFCTR.Bits.F0EN
#define RFRFCTR_F1EN                    _RFRFCTR.Bits.F1EN
#define RFRFCTR_F2EN                    _RFRFCTR.Bits.F2EN
#define RFRFCTR_F3EN                    _RFRFCTR.Bits.F3EN
#define RFRFCTR_F0MD                    _RFRFCTR.Bits.F0MD
#define RFRFCTR_F1MD                    _RFRFCTR.Bits.F1MD
#define RFRFCTR_F2MD                    _RFRFCTR.Bits.F2MD
#define RFRFCTR_F3MD                    _RFRFCTR.Bits.F3MD

#define RFRFCTR_F0EN_MASK               1U
#define RFRFCTR_F1EN_MASK               2U
#define RFRFCTR_F2EN_MASK               4U
#define RFRFCTR_F3EN_MASK               8U
#define RFRFCTR_F0MD_MASK               256U
#define RFRFCTR_F1MD_MASK               512U
#define RFRFCTR_F2MD_MASK               1024U
#define RFRFCTR_F3MD_MASK               2048U


/*** LDTXSLAR - Last Dynamic Transmit Slot Channel A Register; 0x0000049C ***/
typedef union {
  word Word;
  struct {
    word LASTDYNTXSLOTA :11;                                   /* Last Dynamic Transmission Slot Channel A */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} LDTXSLARSTR;
extern volatile LDTXSLARSTR _LDTXSLAR @(REG_BASE + 0x0000049CUL);
#define LDTXSLAR                        _LDTXSLAR.Word
#define LDTXSLAR_LASTDYNTXSLOTA         _LDTXSLAR.Bits.LASTDYNTXSLOTA

#define LDTXSLAR_LASTDYNTXSLOTA_MASK    2047U
#define LDTXSLAR_LASTDYNTXSLOTA_BITNUM  0U


/*** LDTXSLBR - Last Dynamic Transmit Slot Channel B Register; 0x0000049E ***/
typedef union {
  word Word;
  struct {
    word LASTDYNTXSLOTB :11;                                   /* Last Dynamic Transmission Slot Channel B */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} LDTXSLBRSTR;
extern volatile LDTXSLBRSTR _LDTXSLBR @(REG_BASE + 0x0000049EUL);
#define LDTXSLBR                        _LDTXSLBR.Word
#define LDTXSLBR_LASTDYNTXSLOTB         _LDTXSLBR.Bits.LASTDYNTXSLOTB

#define LDTXSLBR_LASTDYNTXSLOTB_MASK    2047U
#define LDTXSLBR_LASTDYNTXSLOTB_BITNUM  0U


/*** PCR0 - Protocol Configuration Register 0; 0x000004A0 ***/
typedef union {
  word Word;
  struct {
    word static_slot_length :10;                               /* static_slot_length */
    word action_point_offset :6;                               /* action_point_offset */
  } Bits;
} PCR0STR;
extern volatile PCR0STR _PCR0 @(REG_BASE + 0x000004A0UL);
#define PCR0                            _PCR0.Word
#define PCR0_static_slot_length         _PCR0.Bits.static_slot_length
#define PCR0_action_point_offset        _PCR0.Bits.action_point_offset
/* PCR_ARR: Access 31 PCRx registers in an array */
#define PCR_ARR                         ((volatile word *) &PCR0)

#define PCR0_static_slot_length_MASK    1023U
#define PCR0_static_slot_length_BITNUM  0U
#define PCR0_action_point_offset_MASK   64512U
#define PCR0_action_point_offset_BITNUM 10U


/*** PCR1 - Protocol Configuration Register 1; 0x000004A2 ***/
typedef union {
  word Word;
  struct {
    word macro_after_first_static_slot :14;                    /* macro_after_first_static_slot */
    word filter_bypass :1;                                     /* filter_bypass */
    word             :1; 
  } Bits;
} PCR1STR;
extern volatile PCR1STR _PCR1 @(REG_BASE + 0x000004A2UL);
#define PCR1                            _PCR1.Word
#define PCR1_macro_after_first_static_slot _PCR1.Bits.macro_after_first_static_slot
#define PCR1_filter_bypass              _PCR1.Bits.filter_bypass

#define PCR1_macro_after_first_static_slot_MASK 16383U
#define PCR1_macro_after_first_static_slot_BITNUM 0U
#define PCR1_filter_bypass_MASK         16384U


/*** PCR2 - Protocol Configuration Register 2; 0x000004A4 ***/
typedef union {
  word Word;
  struct {
    word number_of_static_slots :10;                           /* number_of_static_slots */
    word minislot_after_action_point :6;                       /* minislot_after_action_point */
  } Bits;
} PCR2STR;
extern volatile PCR2STR _PCR2 @(REG_BASE + 0x000004A4UL);
#define PCR2                            _PCR2.Word
#define PCR2_number_of_static_slots     _PCR2.Bits.number_of_static_slots
#define PCR2_minislot_after_action_point _PCR2.Bits.minislot_after_action_point

#define PCR2_number_of_static_slots_MASK 1023U
#define PCR2_number_of_static_slots_BITNUM 0U
#define PCR2_minislot_after_action_point_MASK 64512U
#define PCR2_minislot_after_action_point_BITNUM 10U


/*** PCR3 - Protocol Configuration Register 3; 0x000004A6 ***/
typedef union {
  word Word;
  struct {
    word coldstart_attempts :5;                                /* coldstart_attempts */
    word minislot_action_point_offset :5;                      /* minislot_action_point_offset[4:0] */
    word wakeup_symbol_rx_low :6;                              /* wakeup_symbol_rx_low */
  } Bits;
} PCR3STR;
extern volatile PCR3STR _PCR3 @(REG_BASE + 0x000004A6UL);
#define PCR3                            _PCR3.Word
#define PCR3_coldstart_attempts         _PCR3.Bits.coldstart_attempts
#define PCR3_minislot_action_point_offset _PCR3.Bits.minislot_action_point_offset
#define PCR3_wakeup_symbol_rx_low       _PCR3.Bits.wakeup_symbol_rx_low

#define PCR3_coldstart_attempts_MASK    31U
#define PCR3_coldstart_attempts_BITNUM  0U
#define PCR3_minislot_action_point_offset_MASK 992U
#define PCR3_minislot_action_point_offset_BITNUM 5U
#define PCR3_wakeup_symbol_rx_low_MASK  64512U
#define PCR3_wakeup_symbol_rx_low_BITNUM 10U


/*** PCR4 - Protocol Configuration Register 4; 0x000004A8 ***/
typedef union {
  word Word;
  struct {
    word wakeup_symbol_rx_window :9;                           /* wakeup_symbol_rx_window */
    word cas_rx_low_max :7;                                    /* cas_rx_low_max */
  } Bits;
} PCR4STR;
extern volatile PCR4STR _PCR4 @(REG_BASE + 0x000004A8UL);
#define PCR4                            _PCR4.Word
#define PCR4_wakeup_symbol_rx_window    _PCR4.Bits.wakeup_symbol_rx_window
#define PCR4_cas_rx_low_max             _PCR4.Bits.cas_rx_low_max

#define PCR4_wakeup_symbol_rx_window_MASK 511U
#define PCR4_wakeup_symbol_rx_window_BITNUM 0U
#define PCR4_cas_rx_low_max_MASK        65024U
#define PCR4_cas_rx_low_max_BITNUM      9U


/*** PCR5 - Protocol Configuration Register 5; 0x000004AA ***/
typedef union {
  word Word;
  struct {
    word wakeup_symbol_rx_idle :6;                             /* wakeup_symbol_rx_idle */
    word wakeup_symbol_tx_low :6;                              /* wakeup_symbol_tx_low */
    word tss_transmitter :4;                                   /* tss_transmitter */
  } Bits;
} PCR5STR;
extern volatile PCR5STR _PCR5 @(REG_BASE + 0x000004AAUL);
#define PCR5                            _PCR5.Word
#define PCR5_wakeup_symbol_rx_idle      _PCR5.Bits.wakeup_symbol_rx_idle
#define PCR5_wakeup_symbol_tx_low       _PCR5.Bits.wakeup_symbol_tx_low
#define PCR5_tss_transmitter            _PCR5.Bits.tss_transmitter

#define PCR5_wakeup_symbol_rx_idle_MASK 63U
#define PCR5_wakeup_symbol_rx_idle_BITNUM 0U
#define PCR5_wakeup_symbol_tx_low_MASK  4032U
#define PCR5_wakeup_symbol_tx_low_BITNUM 6U
#define PCR5_tss_transmitter_MASK       61440U
#define PCR5_tss_transmitter_BITNUM     12U


/*** PCR6 - Protocol Configuration Register 6; 0x000004AC ***/
typedef union {
  word Word;
  struct {
    word macro_initial_offset_a :7;                            /* macro_initial_offset_a */
    word symbol_window_after_action_point :8;                  /* symbol_window_after_action_point */
    word             :1; 
  } Bits;
} PCR6STR;
extern volatile PCR6STR _PCR6 @(REG_BASE + 0x000004ACUL);
#define PCR6                            _PCR6.Word
#define PCR6_macro_initial_offset_a     _PCR6.Bits.macro_initial_offset_a
#define PCR6_symbol_window_after_action_point _PCR6.Bits.symbol_window_after_action_point

#define PCR6_macro_initial_offset_a_MASK 127U
#define PCR6_macro_initial_offset_a_BITNUM 0U
#define PCR6_symbol_window_after_action_point_MASK 32640U
#define PCR6_symbol_window_after_action_point_BITNUM 7U


/*** PCR7 - Protocol Configuration Register 7; 0x000004AE ***/
typedef union {
  word Word;
  struct {
    word micro_per_macro_nom_half :7;                          /* micro_per_macro_nom_half */
    word decoding_correction_b :9;                             /* decoding_correction_b */
  } Bits;
} PCR7STR;
extern volatile PCR7STR _PCR7 @(REG_BASE + 0x000004AEUL);
#define PCR7                            _PCR7.Word
#define PCR7_micro_per_macro_nom_half   _PCR7.Bits.micro_per_macro_nom_half
#define PCR7_decoding_correction_b      _PCR7.Bits.decoding_correction_b

#define PCR7_micro_per_macro_nom_half_MASK 127U
#define PCR7_micro_per_macro_nom_half_BITNUM 0U
#define PCR7_decoding_correction_b_MASK 65408U
#define PCR7_decoding_correction_b_BITNUM 7U


/*** PCR8 - Protocol Configuration Register 8; 0x000004B0 ***/
typedef union {
  word Word;
  struct {
    word wakeup_symbol_tx_idle :8;                             /* wakeup_symbol_tx_idle */
    word max_without_clock_correction_passive :4;              /* max_without_clock_correction_passive */
    word max_without_clock_correction_fatal :4;                /* max_without_clock_correction_fatal */
  } Bits;
} PCR8STR;
extern volatile PCR8STR _PCR8 @(REG_BASE + 0x000004B0UL);
#define PCR8                            _PCR8.Word
#define PCR8_wakeup_symbol_tx_idle      _PCR8.Bits.wakeup_symbol_tx_idle
#define PCR8_max_without_clock_correction_passive _PCR8.Bits.max_without_clock_correction_passive
#define PCR8_max_without_clock_correction_fatal _PCR8.Bits.max_without_clock_correction_fatal

#define PCR8_wakeup_symbol_tx_idle_MASK 255U
#define PCR8_wakeup_symbol_tx_idle_BITNUM 0U
#define PCR8_max_without_clock_correction_passive_MASK 3840U
#define PCR8_max_without_clock_correction_passive_BITNUM 8U
#define PCR8_max_without_clock_correction_fatal_MASK 61440U
#define PCR8_max_without_clock_correction_fatal_BITNUM 12U


/*** PCR9 - Protocol Configuration Register 9; 0x000004B2 ***/
typedef union {
  word Word;
  struct {
    word offset_correction_out :14;                            /* offset_correction_out */
    word symbol_window_exists :1;                              /* symbol_window_exists */
    word minislot_exists :1;                                   /* minislot_exists */
  } Bits;
} PCR9STR;
extern volatile PCR9STR _PCR9 @(REG_BASE + 0x000004B2UL);
#define PCR9                            _PCR9.Word
#define PCR9_offset_correction_out      _PCR9.Bits.offset_correction_out
#define PCR9_symbol_window_exists       _PCR9.Bits.symbol_window_exists
#define PCR9_minislot_exists            _PCR9.Bits.minislot_exists

#define PCR9_offset_correction_out_MASK 16383U
#define PCR9_offset_correction_out_BITNUM 0U
#define PCR9_symbol_window_exists_MASK  16384U
#define PCR9_minislot_exists_MASK       32768U


/*** PCR10 - Protocol Configuration Register 10; 0x000004B4 ***/
typedef union {
  word Word;
  struct {
    word macro_per_cycle :14;                                  /* macro_per_cycle */
    word wakeup_channel :1;                                    /* wakeup_channel */
    word single_slot_enabled :1;                               /* single_slot_enabled */
  } Bits;
} PCR10STR;
extern volatile PCR10STR _PCR10 @(REG_BASE + 0x000004B4UL);
#define PCR10                           _PCR10.Word
#define PCR10_macro_per_cycle           _PCR10.Bits.macro_per_cycle
#define PCR10_wakeup_channel            _PCR10.Bits.wakeup_channel
#define PCR10_single_slot_enabled       _PCR10.Bits.single_slot_enabled

#define PCR10_macro_per_cycle_MASK      16383U
#define PCR10_macro_per_cycle_BITNUM    0U
#define PCR10_wakeup_channel_MASK       16384U
#define PCR10_single_slot_enabled_MASK  32768U


/*** PCR11 - Protocol Configuration Register 11; 0x000004B6 ***/
typedef union {
  word Word;
  struct {
    word offset_correction_start :14;                          /* offset_correction_start */
    word key_slot_used_for_sync :1;                            /* key_slot_used_for_sync */
    word key_slot_used_for_startup :1;                         /* key_slot_used_for_startup */
  } Bits;
} PCR11STR;
extern volatile PCR11STR _PCR11 @(REG_BASE + 0x000004B6UL);
#define PCR11                           _PCR11.Word
#define PCR11_offset_correction_start   _PCR11.Bits.offset_correction_start
#define PCR11_key_slot_used_for_sync    _PCR11.Bits.key_slot_used_for_sync
#define PCR11_key_slot_used_for_startup _PCR11.Bits.key_slot_used_for_startup

#define PCR11_offset_correction_start_MASK 16383U
#define PCR11_offset_correction_start_BITNUM 0U
#define PCR11_key_slot_used_for_sync_MASK 16384U
#define PCR11_key_slot_used_for_startup_MASK 32768U


/*** PCR12 - Protocol Configuration Register 12; 0x000004B8 ***/
typedef union {
  word Word;
  struct {
    word key_slot_header_crc :11;                              /* key_slot_header_crc */
    word allow_passive_to_active :5;                           /* allow_passive_to_active */
  } Bits;
} PCR12STR;
extern volatile PCR12STR _PCR12 @(REG_BASE + 0x000004B8UL);
#define PCR12                           _PCR12.Word
#define PCR12_key_slot_header_crc       _PCR12.Bits.key_slot_header_crc
#define PCR12_allow_passive_to_active   _PCR12.Bits.allow_passive_to_active

#define PCR12_key_slot_header_crc_MASK  2047U
#define PCR12_key_slot_header_crc_BITNUM 0U
#define PCR12_allow_passive_to_active_MASK 63488U
#define PCR12_allow_passive_to_active_BITNUM 11U


/*** PCR13 - Protocol Configuration Register 13; 0x000004BA ***/
typedef union {
  word Word;
  struct {
    word static_slot_after_action_point :10;                   /* static_slot_after_action_point */
    word first_minislot_action_point_offset :6;                /* first_minislot_action_point_offset */
  } Bits;
} PCR13STR;
extern volatile PCR13STR _PCR13 @(REG_BASE + 0x000004BAUL);
#define PCR13                           _PCR13.Word
#define PCR13_static_slot_after_action_point _PCR13.Bits.static_slot_after_action_point
#define PCR13_first_minislot_action_point_offset _PCR13.Bits.first_minislot_action_point_offset

#define PCR13_static_slot_after_action_point_MASK 1023U
#define PCR13_static_slot_after_action_point_BITNUM 0U
#define PCR13_first_minislot_action_point_offset_MASK 64512U
#define PCR13_first_minislot_action_point_offset_BITNUM 10U


/*** PCR14 - Protocol Configuration Register 14; 0x000004BC ***/
typedef union {
  word Word;
  struct {
    word listen_timeout :5;                                    /* listen_timeout[20:16] */
    word rate_correction_out :11;                              /* rate_correction_out */
  } Bits;
} PCR14STR;
extern volatile PCR14STR _PCR14 @(REG_BASE + 0x000004BCUL);
#define PCR14                           _PCR14.Word
#define PCR14_listen_timeout            _PCR14.Bits.listen_timeout
#define PCR14_rate_correction_out       _PCR14.Bits.rate_correction_out

#define PCR14_listen_timeout_MASK       31U
#define PCR14_listen_timeout_BITNUM     0U
#define PCR14_rate_correction_out_MASK  65504U
#define PCR14_rate_correction_out_BITNUM 5U


/*** PCR15 - Protocol Configuration Register 15; 0x000004BE ***/
typedef union {
  word Word;
  struct {
    word listen_timeout :16;                                   /* listen_timeout[15:0] */
  } Bits;
} PCR15STR;
extern volatile PCR15STR _PCR15 @(REG_BASE + 0x000004BEUL);
#define PCR15                           _PCR15.Word
#define PCR15_listen_timeout            _PCR15.Bits.listen_timeout

#define PCR15_listen_timeout_MASK       65535U
#define PCR15_listen_timeout_BITNUM     0U


/*** PCR16 - Protocol Configuration Register 16; 0x000004C0 ***/
typedef union {
  word Word;
  struct {
    word noise_listen_timeout :9;                              /* noise_listen_timeout[24:16] */
    word macro_initial_offset_b :7;                            /* macro_initial_offset_b */
  } Bits;
} PCR16STR;
extern volatile PCR16STR _PCR16 @(REG_BASE + 0x000004C0UL);
#define PCR16                           _PCR16.Word
#define PCR16_noise_listen_timeout      _PCR16.Bits.noise_listen_timeout
#define PCR16_macro_initial_offset_b    _PCR16.Bits.macro_initial_offset_b

#define PCR16_noise_listen_timeout_MASK 511U
#define PCR16_noise_listen_timeout_BITNUM 0U
#define PCR16_macro_initial_offset_b_MASK 65024U
#define PCR16_macro_initial_offset_b_BITNUM 9U


/*** PCR17 - Protocol Configuration Register 17; 0x000004C2 ***/
typedef union {
  word Word;
  struct {
    word noise_listen_timeout :16;                             /* noise_listen_timeout[15:0] */
  } Bits;
} PCR17STR;
extern volatile PCR17STR _PCR17 @(REG_BASE + 0x000004C2UL);
#define PCR17                           _PCR17.Word
#define PCR17_noise_listen_timeout      _PCR17.Bits.noise_listen_timeout

#define PCR17_noise_listen_timeout_MASK 65535U
#define PCR17_noise_listen_timeout_BITNUM 0U


/*** PCR18 - Protocol Configuration Register 18; 0x000004C4 ***/
typedef union {
  word Word;
  struct {
    word key_slot_id :10;                                      /* key_slot_id */
    word wakeup_pattern :6;                                    /* wakeup_pattern */
  } Bits;
} PCR18STR;
extern volatile PCR18STR _PCR18 @(REG_BASE + 0x000004C4UL);
#define PCR18                           _PCR18.Word
#define PCR18_key_slot_id               _PCR18.Bits.key_slot_id
#define PCR18_wakeup_pattern            _PCR18.Bits.wakeup_pattern

#define PCR18_key_slot_id_MASK          1023U
#define PCR18_key_slot_id_BITNUM        0U
#define PCR18_wakeup_pattern_MASK       64512U
#define PCR18_wakeup_pattern_BITNUM     10U


/*** PCR19 - Protocol Configuration Register 19; 0x000004C6 ***/
typedef union {
  word Word;
  struct {
    word payload_length_static :7;                             /* payload_length_static */
    word decoding_correction_a :9;                             /* decoding_correction_a */
  } Bits;
} PCR19STR;
extern volatile PCR19STR _PCR19 @(REG_BASE + 0x000004C6UL);
#define PCR19                           _PCR19.Word
#define PCR19_payload_length_static     _PCR19.Bits.payload_length_static
#define PCR19_decoding_correction_a     _PCR19.Bits.decoding_correction_a

#define PCR19_payload_length_static_MASK 127U
#define PCR19_payload_length_static_BITNUM 0U
#define PCR19_decoding_correction_a_MASK 65408U
#define PCR19_decoding_correction_a_BITNUM 7U


/*** PCR20 - Protocol Configuration Register 20; 0x000004C8 ***/
typedef union {
  word Word;
  struct {
    word micro_initial_offset_a :8;                            /* micro_initial_offset_a */
    word micro_initial_offset_b :8;                            /* micro_initial_offset_b */
  } Bits;
} PCR20STR;
extern volatile PCR20STR _PCR20 @(REG_BASE + 0x000004C8UL);
#define PCR20                           _PCR20.Word
#define PCR20_micro_initial_offset_a    _PCR20.Bits.micro_initial_offset_a
#define PCR20_micro_initial_offset_b    _PCR20.Bits.micro_initial_offset_b

#define PCR20_micro_initial_offset_a_MASK 255U
#define PCR20_micro_initial_offset_a_BITNUM 0U
#define PCR20_micro_initial_offset_b_MASK 65280U
#define PCR20_micro_initial_offset_b_BITNUM 8U


/*** PCR21 - Protocol Configuration Register 21; 0x000004CA ***/
typedef union {
  word Word;
  struct {
    word latest_tx   :13;                                      /* latest_tx */
    word extern_rate_correction :3;                            /* extern_rate_correction */
  } Bits;
} PCR21STR;
extern volatile PCR21STR _PCR21 @(REG_BASE + 0x000004CAUL);
#define PCR21                           _PCR21.Word
#define PCR21_latest_tx                 _PCR21.Bits.latest_tx
#define PCR21_extern_rate_correction    _PCR21.Bits.extern_rate_correction

#define PCR21_latest_tx_MASK            8191U
#define PCR21_latest_tx_BITNUM          0U
#define PCR21_extern_rate_correction_MASK 57344U
#define PCR21_extern_rate_correction_BITNUM 13U


/*** PCR22 - Protocol Configuration Register 22; 0x000004CC ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle :4;                                   /* micro_per_cycle[19:16] */
    word comp_accepted_startup_range_a :11;                    /* comp_accepted_startup_range_a */
    word             :1; 
  } Bits;
} PCR22STR;
extern volatile PCR22STR _PCR22 @(REG_BASE + 0x000004CCUL);
#define PCR22                           _PCR22.Word
#define PCR22_micro_per_cycle           _PCR22.Bits.micro_per_cycle
#define PCR22_comp_accepted_startup_range_a _PCR22.Bits.comp_accepted_startup_range_a

#define PCR22_micro_per_cycle_MASK      15U
#define PCR22_micro_per_cycle_BITNUM    0U
#define PCR22_comp_accepted_startup_range_a_MASK 32752U
#define PCR22_comp_accepted_startup_range_a_BITNUM 4U


/*** PCR23 - Protocol Configuration Register 23; 0x000004CE ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle :16;                                  /* micro_per_cycle[15:0] */
  } Bits;
} PCR23STR;
extern volatile PCR23STR _PCR23 @(REG_BASE + 0x000004CEUL);
#define PCR23                           _PCR23.Word
#define PCR23_micro_per_cycle           _PCR23.Bits.micro_per_cycle

#define PCR23_micro_per_cycle_MASK      65535U
#define PCR23_micro_per_cycle_BITNUM    0U


/*** PCR24 - Protocol Configuration Register 24; 0x000004D0 ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle_min :4;                               /* micro_per_cycle_min[19:16] */
    word max_payload_length_dynamic :7;                        /* max_payload_length_dynamic */
    word cluster_drift_damping :5;                             /* cluster_drift_damping */
  } Bits;
} PCR24STR;
extern volatile PCR24STR _PCR24 @(REG_BASE + 0x000004D0UL);
#define PCR24                           _PCR24.Word
#define PCR24_micro_per_cycle_min       _PCR24.Bits.micro_per_cycle_min
#define PCR24_max_payload_length_dynamic _PCR24.Bits.max_payload_length_dynamic
#define PCR24_cluster_drift_damping     _PCR24.Bits.cluster_drift_damping

#define PCR24_micro_per_cycle_min_MASK  15U
#define PCR24_micro_per_cycle_min_BITNUM 0U
#define PCR24_max_payload_length_dynamic_MASK 2032U
#define PCR24_max_payload_length_dynamic_BITNUM 4U
#define PCR24_cluster_drift_damping_MASK 63488U
#define PCR24_cluster_drift_damping_BITNUM 11U


/*** PCR25 - Protocol Configuration Register 25; 0x000004D2 ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle_min :16;                              /* micro_per_cycle_min[15:0] */
  } Bits;
} PCR25STR;
extern volatile PCR25STR _PCR25 @(REG_BASE + 0x000004D2UL);
#define PCR25                           _PCR25.Word
#define PCR25_micro_per_cycle_min       _PCR25.Bits.micro_per_cycle_min

#define PCR25_micro_per_cycle_min_MASK  65535U
#define PCR25_micro_per_cycle_min_BITNUM 0U


/*** PCR26 - Protocol Configuration Register 26; 0x000004D4 ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle_max :4;                               /* micro_per_cycle_max[19:16] */
    word comp_accepted_startup_range_b :11;                    /* comp_accepted_startup_range_b */
    word allow_halt_due_to_clock :1;                           /* allow_halt_due_to_clock */
  } Bits;
} PCR26STR;
extern volatile PCR26STR _PCR26 @(REG_BASE + 0x000004D4UL);
#define PCR26                           _PCR26.Word
#define PCR26_micro_per_cycle_max       _PCR26.Bits.micro_per_cycle_max
#define PCR26_comp_accepted_startup_range_b _PCR26.Bits.comp_accepted_startup_range_b
#define PCR26_allow_halt_due_to_clock   _PCR26.Bits.allow_halt_due_to_clock

#define PCR26_micro_per_cycle_max_MASK  15U
#define PCR26_micro_per_cycle_max_BITNUM 0U
#define PCR26_comp_accepted_startup_range_b_MASK 32752U
#define PCR26_comp_accepted_startup_range_b_BITNUM 4U
#define PCR26_allow_halt_due_to_clock_MASK 32768U


/*** PCR27 - Protocol Configuration Register 27; 0x000004D6 ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle_max :16;                              /* micro_per_cycle_max[15:0] */
  } Bits;
} PCR27STR;
extern volatile PCR27STR _PCR27 @(REG_BASE + 0x000004D6UL);
#define PCR27                           _PCR27.Word
#define PCR27_micro_per_cycle_max       _PCR27.Bits.micro_per_cycle_max

#define PCR27_micro_per_cycle_max_MASK  65535U
#define PCR27_micro_per_cycle_max_BITNUM 0U


/*** PCR28 - Protocol Configuration Register 28; 0x000004D8 ***/
typedef union {
  word Word;
  struct {
    word macro_after_offset_correction :14;                    /* macro_after_offset_correction */
    word dynamic_slot_idle_phase :2;                           /* dynamic_slot_idle_phase */
  } Bits;
} PCR28STR;
extern volatile PCR28STR _PCR28 @(REG_BASE + 0x000004D8UL);
#define PCR28                           _PCR28.Word
#define PCR28_macro_after_offset_correction _PCR28.Bits.macro_after_offset_correction
#define PCR28_dynamic_slot_idle_phase   _PCR28.Bits.dynamic_slot_idle_phase

#define PCR28_macro_after_offset_correction_MASK 16383U
#define PCR28_macro_after_offset_correction_BITNUM 0U
#define PCR28_dynamic_slot_idle_phase_MASK 49152U
#define PCR28_dynamic_slot_idle_phase_BITNUM 14U


/*** PCR29 - Protocol Configuration Register 29; 0x000004DA ***/
typedef union {
  word Word;
  struct {
    word minislots_max :13;                                    /* minislots_max */
    word extern_offset_correction :3;                          /* extern_offset_correction */
  } Bits;
} PCR29STR;
extern volatile PCR29STR _PCR29 @(REG_BASE + 0x000004DAUL);
#define PCR29                           _PCR29.Word
#define PCR29_minislots_max             _PCR29.Bits.minislots_max
#define PCR29_extern_offset_correction  _PCR29.Bits.extern_offset_correction

#define PCR29_minislots_max_MASK        8191U
#define PCR29_minislots_max_BITNUM      0U
#define PCR29_extern_offset_correction_MASK 57344U
#define PCR29_extern_offset_correction_BITNUM 13U


/*** PCR30 - Protocol Configuration Register 30; 0x000004DC ***/
typedef union {
  word Word;
  struct {
    word sync_node_max :4;                                     /* sync_node_max */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} PCR30STR;
extern volatile PCR30STR _PCR30 @(REG_BASE + 0x000004DCUL);
#define PCR30                           _PCR30.Word
#define PCR30_sync_node_max             _PCR30.Bits.sync_node_max

#define PCR30_sync_node_max_MASK        15U
#define PCR30_sync_node_max_BITNUM      0U


/*** MBCCSR0 - Message Buffer Configuration, Control, Status Register 0; 0x00000500 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR0STR;
extern volatile MBCCSR0STR _MBCCSR0 @(REG_BASE + 0x00000500UL);
#define MBCCSR0                         _MBCCSR0.Word
#define MBCCSR0_MBIF                    _MBCCSR0.Bits.MBIF
#define MBCCSR0_LCKS                    _MBCCSR0.Bits.LCKS
#define MBCCSR0_EDS                     _MBCCSR0.Bits.EDS
#define MBCCSR0_DVAL                    _MBCCSR0.Bits.DVAL
#define MBCCSR0_DUP                     _MBCCSR0.Bits.DUP
#define MBCCSR0_MBIE                    _MBCCSR0.Bits.MBIE
#define MBCCSR0_LCKT                    _MBCCSR0.Bits.LCKT
#define MBCCSR0_EDT                     _MBCCSR0.Bits.EDT
#define MBCCSR0_CMT                     _MBCCSR0.Bits.CMT
#define MBCCSR0_MTD                     _MBCCSR0.Bits.MTD
#define MBCCSR0_MBT                     _MBCCSR0.Bits.MBT
#define MBCCSR0_MCM                     _MBCCSR0.Bits.MCM

#define MBCCSR0_MBIF_MASK               1U
#define MBCCSR0_LCKS_MASK               2U
#define MBCCSR0_EDS_MASK                4U
#define MBCCSR0_DVAL_MASK               8U
#define MBCCSR0_DUP_MASK                16U
#define MBCCSR0_MBIE_MASK               256U
#define MBCCSR0_LCKT_MASK               512U
#define MBCCSR0_EDT_MASK                1024U
#define MBCCSR0_CMT_MASK                2048U
#define MBCCSR0_MTD_MASK                4096U
#define MBCCSR0_MBT_MASK                8192U
#define MBCCSR0_MCM_MASK                16384U


/*** MBCCFR0 - Message Buffer Cycle Counter Filter Register 1; 0x00000502 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR0STR;
extern volatile MBCCFR0STR _MBCCFR0 @(REG_BASE + 0x00000502UL);
#define MBCCFR0                         _MBCCFR0.Word
#define MBCCFR0_CCFVAL                  _MBCCFR0.Bits.CCFVAL
#define MBCCFR0_CCFMSK                  _MBCCFR0.Bits.CCFMSK
#define MBCCFR0_CCFE                    _MBCCFR0.Bits.CCFE
#define MBCCFR0_CHB                     _MBCCFR0.Bits.CHB
#define MBCCFR0_CHA                     _MBCCFR0.Bits.CHA
#define MBCCFR0_MTM                     _MBCCFR0.Bits.MTM

#define MBCCFR0_CCFVAL_MASK             63U
#define MBCCFR0_CCFVAL_BITNUM           0U
#define MBCCFR0_CCFMSK_MASK             4032U
#define MBCCFR0_CCFMSK_BITNUM           6U
#define MBCCFR0_CCFE_MASK               4096U
#define MBCCFR0_CHB_MASK                8192U
#define MBCCFR0_CHA_MASK                16384U
#define MBCCFR0_MTM_MASK                32768U


/*** MBFIDR0 - Message Buffer Frame ID Registers; 0x00000504 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR0STR;
extern volatile MBFIDR0STR _MBFIDR0 @(REG_BASE + 0x00000504UL);
#define MBFIDR0                         _MBFIDR0.Word
#define MBFIDR0_FID                     _MBFIDR0.Bits.FID

#define MBFIDR0_FID_MASK                2047U
#define MBFIDR0_FID_BITNUM              0U


/*** MBIDXR0 - Message Buffer Index Register; 0x00000506 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR0STR;
extern volatile MBIDXR0STR _MBIDXR0 @(REG_BASE + 0x00000506UL);
#define MBIDXR0                         _MBIDXR0.Word
#define MBIDXR0_MBIDX                   _MBIDXR0.Bits.MBIDX

#define MBIDXR0_MBIDX_MASK              63U
#define MBIDXR0_MBIDX_BITNUM            0U


/*** MBCCSR1 - Message Buffer Configuration, Control, Status Register 1; 0x00000508 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR1STR;
extern volatile MBCCSR1STR _MBCCSR1 @(REG_BASE + 0x00000508UL);
#define MBCCSR1                         _MBCCSR1.Word
#define MBCCSR1_MBIF                    _MBCCSR1.Bits.MBIF
#define MBCCSR1_LCKS                    _MBCCSR1.Bits.LCKS
#define MBCCSR1_EDS                     _MBCCSR1.Bits.EDS
#define MBCCSR1_DVAL                    _MBCCSR1.Bits.DVAL
#define MBCCSR1_DUP                     _MBCCSR1.Bits.DUP
#define MBCCSR1_MBIE                    _MBCCSR1.Bits.MBIE
#define MBCCSR1_LCKT                    _MBCCSR1.Bits.LCKT
#define MBCCSR1_EDT                     _MBCCSR1.Bits.EDT
#define MBCCSR1_CMT                     _MBCCSR1.Bits.CMT
#define MBCCSR1_MTD                     _MBCCSR1.Bits.MTD
#define MBCCSR1_MBT                     _MBCCSR1.Bits.MBT
#define MBCCSR1_MCM                     _MBCCSR1.Bits.MCM

#define MBCCSR1_MBIF_MASK               1U
#define MBCCSR1_LCKS_MASK               2U
#define MBCCSR1_EDS_MASK                4U
#define MBCCSR1_DVAL_MASK               8U
#define MBCCSR1_DUP_MASK                16U
#define MBCCSR1_MBIE_MASK               256U
#define MBCCSR1_LCKT_MASK               512U
#define MBCCSR1_EDT_MASK                1024U
#define MBCCSR1_CMT_MASK                2048U
#define MBCCSR1_MTD_MASK                4096U
#define MBCCSR1_MBT_MASK                8192U
#define MBCCSR1_MCM_MASK                16384U


/*** MBCCFR1 - Message Buffer Cycle Counter Filter Register 1; 0x0000050A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR1STR;
extern volatile MBCCFR1STR _MBCCFR1 @(REG_BASE + 0x0000050AUL);
#define MBCCFR1                         _MBCCFR1.Word
#define MBCCFR1_CCFVAL                  _MBCCFR1.Bits.CCFVAL
#define MBCCFR1_CCFMSK                  _MBCCFR1.Bits.CCFMSK
#define MBCCFR1_CCFE                    _MBCCFR1.Bits.CCFE
#define MBCCFR1_CHB                     _MBCCFR1.Bits.CHB
#define MBCCFR1_CHA                     _MBCCFR1.Bits.CHA
#define MBCCFR1_MTM                     _MBCCFR1.Bits.MTM

#define MBCCFR1_CCFVAL_MASK             63U
#define MBCCFR1_CCFVAL_BITNUM           0U
#define MBCCFR1_CCFMSK_MASK             4032U
#define MBCCFR1_CCFMSK_BITNUM           6U
#define MBCCFR1_CCFE_MASK               4096U
#define MBCCFR1_CHB_MASK                8192U
#define MBCCFR1_CHA_MASK                16384U
#define MBCCFR1_MTM_MASK                32768U


/*** MBFIDR1 - Message Buffer Frame ID Registers; 0x0000050C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR1STR;
extern volatile MBFIDR1STR _MBFIDR1 @(REG_BASE + 0x0000050CUL);
#define MBFIDR1                         _MBFIDR1.Word
#define MBFIDR1_FID                     _MBFIDR1.Bits.FID

#define MBFIDR1_FID_MASK                2047U
#define MBFIDR1_FID_BITNUM              0U


/*** MBIDXR1 - Message Buffer Index Register; 0x0000050E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR1STR;
extern volatile MBIDXR1STR _MBIDXR1 @(REG_BASE + 0x0000050EUL);
#define MBIDXR1                         _MBIDXR1.Word
#define MBIDXR1_MBIDX                   _MBIDXR1.Bits.MBIDX

#define MBIDXR1_MBIDX_MASK              63U
#define MBIDXR1_MBIDX_BITNUM            0U


/*** MBCCSR2 - Message Buffer Configuration, Control, Status Register 2; 0x00000510 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR2STR;
extern volatile MBCCSR2STR _MBCCSR2 @(REG_BASE + 0x00000510UL);
#define MBCCSR2                         _MBCCSR2.Word
#define MBCCSR2_MBIF                    _MBCCSR2.Bits.MBIF
#define MBCCSR2_LCKS                    _MBCCSR2.Bits.LCKS
#define MBCCSR2_EDS                     _MBCCSR2.Bits.EDS
#define MBCCSR2_DVAL                    _MBCCSR2.Bits.DVAL
#define MBCCSR2_DUP                     _MBCCSR2.Bits.DUP
#define MBCCSR2_MBIE                    _MBCCSR2.Bits.MBIE
#define MBCCSR2_LCKT                    _MBCCSR2.Bits.LCKT
#define MBCCSR2_EDT                     _MBCCSR2.Bits.EDT
#define MBCCSR2_CMT                     _MBCCSR2.Bits.CMT
#define MBCCSR2_MTD                     _MBCCSR2.Bits.MTD
#define MBCCSR2_MBT                     _MBCCSR2.Bits.MBT
#define MBCCSR2_MCM                     _MBCCSR2.Bits.MCM

#define MBCCSR2_MBIF_MASK               1U
#define MBCCSR2_LCKS_MASK               2U
#define MBCCSR2_EDS_MASK                4U
#define MBCCSR2_DVAL_MASK               8U
#define MBCCSR2_DUP_MASK                16U
#define MBCCSR2_MBIE_MASK               256U
#define MBCCSR2_LCKT_MASK               512U
#define MBCCSR2_EDT_MASK                1024U
#define MBCCSR2_CMT_MASK                2048U
#define MBCCSR2_MTD_MASK                4096U
#define MBCCSR2_MBT_MASK                8192U
#define MBCCSR2_MCM_MASK                16384U


/*** MBCCFR2 - Message Buffer Cycle Counter Filter Register 2; 0x00000512 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR2STR;
extern volatile MBCCFR2STR _MBCCFR2 @(REG_BASE + 0x00000512UL);
#define MBCCFR2                         _MBCCFR2.Word
#define MBCCFR2_CCFVAL                  _MBCCFR2.Bits.CCFVAL
#define MBCCFR2_CCFMSK                  _MBCCFR2.Bits.CCFMSK
#define MBCCFR2_CCFE                    _MBCCFR2.Bits.CCFE
#define MBCCFR2_CHB                     _MBCCFR2.Bits.CHB
#define MBCCFR2_CHA                     _MBCCFR2.Bits.CHA
#define MBCCFR2_MTM                     _MBCCFR2.Bits.MTM

#define MBCCFR2_CCFVAL_MASK             63U
#define MBCCFR2_CCFVAL_BITNUM           0U
#define MBCCFR2_CCFMSK_MASK             4032U
#define MBCCFR2_CCFMSK_BITNUM           6U
#define MBCCFR2_CCFE_MASK               4096U
#define MBCCFR2_CHB_MASK                8192U
#define MBCCFR2_CHA_MASK                16384U
#define MBCCFR2_MTM_MASK                32768U


/*** MBFIDR2 - Message Buffer Frame ID Registers; 0x00000514 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR2STR;
extern volatile MBFIDR2STR _MBFIDR2 @(REG_BASE + 0x00000514UL);
#define MBFIDR2                         _MBFIDR2.Word
#define MBFIDR2_FID                     _MBFIDR2.Bits.FID

#define MBFIDR2_FID_MASK                2047U
#define MBFIDR2_FID_BITNUM              0U


/*** MBIDXR2 - Message Buffer Index Register; 0x00000516 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR2STR;
extern volatile MBIDXR2STR _MBIDXR2 @(REG_BASE + 0x00000516UL);
#define MBIDXR2                         _MBIDXR2.Word
#define MBIDXR2_MBIDX                   _MBIDXR2.Bits.MBIDX

#define MBIDXR2_MBIDX_MASK              63U
#define MBIDXR2_MBIDX_BITNUM            0U


/*** MBCCSR3 - Message Buffer Configuration, Control, Status Register 3; 0x00000518 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR3STR;
extern volatile MBCCSR3STR _MBCCSR3 @(REG_BASE + 0x00000518UL);
#define MBCCSR3                         _MBCCSR3.Word
#define MBCCSR3_MBIF                    _MBCCSR3.Bits.MBIF
#define MBCCSR3_LCKS                    _MBCCSR3.Bits.LCKS
#define MBCCSR3_EDS                     _MBCCSR3.Bits.EDS
#define MBCCSR3_DVAL                    _MBCCSR3.Bits.DVAL
#define MBCCSR3_DUP                     _MBCCSR3.Bits.DUP
#define MBCCSR3_MBIE                    _MBCCSR3.Bits.MBIE
#define MBCCSR3_LCKT                    _MBCCSR3.Bits.LCKT
#define MBCCSR3_EDT                     _MBCCSR3.Bits.EDT
#define MBCCSR3_CMT                     _MBCCSR3.Bits.CMT
#define MBCCSR3_MTD                     _MBCCSR3.Bits.MTD
#define MBCCSR3_MBT                     _MBCCSR3.Bits.MBT
#define MBCCSR3_MCM                     _MBCCSR3.Bits.MCM

#define MBCCSR3_MBIF_MASK               1U
#define MBCCSR3_LCKS_MASK               2U
#define MBCCSR3_EDS_MASK                4U
#define MBCCSR3_DVAL_MASK               8U
#define MBCCSR3_DUP_MASK                16U
#define MBCCSR3_MBIE_MASK               256U
#define MBCCSR3_LCKT_MASK               512U
#define MBCCSR3_EDT_MASK                1024U
#define MBCCSR3_CMT_MASK                2048U
#define MBCCSR3_MTD_MASK                4096U
#define MBCCSR3_MBT_MASK                8192U
#define MBCCSR3_MCM_MASK                16384U


/*** MBCCFR3 - Message Buffer Cycle Counter Filter Register 3; 0x0000051A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR3STR;
extern volatile MBCCFR3STR _MBCCFR3 @(REG_BASE + 0x0000051AUL);
#define MBCCFR3                         _MBCCFR3.Word
#define MBCCFR3_CCFVAL                  _MBCCFR3.Bits.CCFVAL
#define MBCCFR3_CCFMSK                  _MBCCFR3.Bits.CCFMSK
#define MBCCFR3_CCFE                    _MBCCFR3.Bits.CCFE
#define MBCCFR3_CHB                     _MBCCFR3.Bits.CHB
#define MBCCFR3_CHA                     _MBCCFR3.Bits.CHA
#define MBCCFR3_MTM                     _MBCCFR3.Bits.MTM

#define MBCCFR3_CCFVAL_MASK             63U
#define MBCCFR3_CCFVAL_BITNUM           0U
#define MBCCFR3_CCFMSK_MASK             4032U
#define MBCCFR3_CCFMSK_BITNUM           6U
#define MBCCFR3_CCFE_MASK               4096U
#define MBCCFR3_CHB_MASK                8192U
#define MBCCFR3_CHA_MASK                16384U
#define MBCCFR3_MTM_MASK                32768U


/*** MBFIDR3 - Message Buffer Frame ID Registers; 0x0000051C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR3STR;
extern volatile MBFIDR3STR _MBFIDR3 @(REG_BASE + 0x0000051CUL);
#define MBFIDR3                         _MBFIDR3.Word
#define MBFIDR3_FID                     _MBFIDR3.Bits.FID

#define MBFIDR3_FID_MASK                2047U
#define MBFIDR3_FID_BITNUM              0U


/*** MBIDXR3 - Message Buffer Index Register; 0x0000051E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR3STR;
extern volatile MBIDXR3STR _MBIDXR3 @(REG_BASE + 0x0000051EUL);
#define MBIDXR3                         _MBIDXR3.Word
#define MBIDXR3_MBIDX                   _MBIDXR3.Bits.MBIDX

#define MBIDXR3_MBIDX_MASK              63U
#define MBIDXR3_MBIDX_BITNUM            0U


/*** MBCCSR4 - Message Buffer Configuration, Control, Status Register 4; 0x00000520 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR4STR;
extern volatile MBCCSR4STR _MBCCSR4 @(REG_BASE + 0x00000520UL);
#define MBCCSR4                         _MBCCSR4.Word
#define MBCCSR4_MBIF                    _MBCCSR4.Bits.MBIF
#define MBCCSR4_LCKS                    _MBCCSR4.Bits.LCKS
#define MBCCSR4_EDS                     _MBCCSR4.Bits.EDS
#define MBCCSR4_DVAL                    _MBCCSR4.Bits.DVAL
#define MBCCSR4_DUP                     _MBCCSR4.Bits.DUP
#define MBCCSR4_MBIE                    _MBCCSR4.Bits.MBIE
#define MBCCSR4_LCKT                    _MBCCSR4.Bits.LCKT
#define MBCCSR4_EDT                     _MBCCSR4.Bits.EDT
#define MBCCSR4_CMT                     _MBCCSR4.Bits.CMT
#define MBCCSR4_MTD                     _MBCCSR4.Bits.MTD
#define MBCCSR4_MBT                     _MBCCSR4.Bits.MBT
#define MBCCSR4_MCM                     _MBCCSR4.Bits.MCM

#define MBCCSR4_MBIF_MASK               1U
#define MBCCSR4_LCKS_MASK               2U
#define MBCCSR4_EDS_MASK                4U
#define MBCCSR4_DVAL_MASK               8U
#define MBCCSR4_DUP_MASK                16U
#define MBCCSR4_MBIE_MASK               256U
#define MBCCSR4_LCKT_MASK               512U
#define MBCCSR4_EDT_MASK                1024U
#define MBCCSR4_CMT_MASK                2048U
#define MBCCSR4_MTD_MASK                4096U
#define MBCCSR4_MBT_MASK                8192U
#define MBCCSR4_MCM_MASK                16384U


/*** MBCCFR4 - Message Buffer Cycle Counter Filter Register 4; 0x00000522 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR4STR;
extern volatile MBCCFR4STR _MBCCFR4 @(REG_BASE + 0x00000522UL);
#define MBCCFR4                         _MBCCFR4.Word
#define MBCCFR4_CCFVAL                  _MBCCFR4.Bits.CCFVAL
#define MBCCFR4_CCFMSK                  _MBCCFR4.Bits.CCFMSK
#define MBCCFR4_CCFE                    _MBCCFR4.Bits.CCFE
#define MBCCFR4_CHB                     _MBCCFR4.Bits.CHB
#define MBCCFR4_CHA                     _MBCCFR4.Bits.CHA
#define MBCCFR4_MTM                     _MBCCFR4.Bits.MTM

#define MBCCFR4_CCFVAL_MASK             63U
#define MBCCFR4_CCFVAL_BITNUM           0U
#define MBCCFR4_CCFMSK_MASK             4032U
#define MBCCFR4_CCFMSK_BITNUM           6U
#define MBCCFR4_CCFE_MASK               4096U
#define MBCCFR4_CHB_MASK                8192U
#define MBCCFR4_CHA_MASK                16384U
#define MBCCFR4_MTM_MASK                32768U


/*** MBFIDR4 - Message Buffer Frame ID Registers; 0x00000524 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR4STR;
extern volatile MBFIDR4STR _MBFIDR4 @(REG_BASE + 0x00000524UL);
#define MBFIDR4                         _MBFIDR4.Word
#define MBFIDR4_FID                     _MBFIDR4.Bits.FID

#define MBFIDR4_FID_MASK                2047U
#define MBFIDR4_FID_BITNUM              0U


/*** MBIDXR4 - Message Buffer Index Register; 0x00000526 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR4STR;
extern volatile MBIDXR4STR _MBIDXR4 @(REG_BASE + 0x00000526UL);
#define MBIDXR4                         _MBIDXR4.Word
#define MBIDXR4_MBIDX                   _MBIDXR4.Bits.MBIDX

#define MBIDXR4_MBIDX_MASK              63U
#define MBIDXR4_MBIDX_BITNUM            0U


/*** MBCCSR5 - Message Buffer Configuration, Control, Status Register 5; 0x00000528 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR5STR;
extern volatile MBCCSR5STR _MBCCSR5 @(REG_BASE + 0x00000528UL);
#define MBCCSR5                         _MBCCSR5.Word
#define MBCCSR5_MBIF                    _MBCCSR5.Bits.MBIF
#define MBCCSR5_LCKS                    _MBCCSR5.Bits.LCKS
#define MBCCSR5_EDS                     _MBCCSR5.Bits.EDS
#define MBCCSR5_DVAL                    _MBCCSR5.Bits.DVAL
#define MBCCSR5_DUP                     _MBCCSR5.Bits.DUP
#define MBCCSR5_MBIE                    _MBCCSR5.Bits.MBIE
#define MBCCSR5_LCKT                    _MBCCSR5.Bits.LCKT
#define MBCCSR5_EDT                     _MBCCSR5.Bits.EDT
#define MBCCSR5_CMT                     _MBCCSR5.Bits.CMT
#define MBCCSR5_MTD                     _MBCCSR5.Bits.MTD
#define MBCCSR5_MBT                     _MBCCSR5.Bits.MBT
#define MBCCSR5_MCM                     _MBCCSR5.Bits.MCM

#define MBCCSR5_MBIF_MASK               1U
#define MBCCSR5_LCKS_MASK               2U
#define MBCCSR5_EDS_MASK                4U
#define MBCCSR5_DVAL_MASK               8U
#define MBCCSR5_DUP_MASK                16U
#define MBCCSR5_MBIE_MASK               256U
#define MBCCSR5_LCKT_MASK               512U
#define MBCCSR5_EDT_MASK                1024U
#define MBCCSR5_CMT_MASK                2048U
#define MBCCSR5_MTD_MASK                4096U
#define MBCCSR5_MBT_MASK                8192U
#define MBCCSR5_MCM_MASK                16384U


/*** MBCCFR5 - Message Buffer Cycle Counter Filter Register 5; 0x0000052A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR5STR;
extern volatile MBCCFR5STR _MBCCFR5 @(REG_BASE + 0x0000052AUL);
#define MBCCFR5                         _MBCCFR5.Word
#define MBCCFR5_CCFVAL                  _MBCCFR5.Bits.CCFVAL
#define MBCCFR5_CCFMSK                  _MBCCFR5.Bits.CCFMSK
#define MBCCFR5_CCFE                    _MBCCFR5.Bits.CCFE
#define MBCCFR5_CHB                     _MBCCFR5.Bits.CHB
#define MBCCFR5_CHA                     _MBCCFR5.Bits.CHA
#define MBCCFR5_MTM                     _MBCCFR5.Bits.MTM

#define MBCCFR5_CCFVAL_MASK             63U
#define MBCCFR5_CCFVAL_BITNUM           0U
#define MBCCFR5_CCFMSK_MASK             4032U
#define MBCCFR5_CCFMSK_BITNUM           6U
#define MBCCFR5_CCFE_MASK               4096U
#define MBCCFR5_CHB_MASK                8192U
#define MBCCFR5_CHA_MASK                16384U
#define MBCCFR5_MTM_MASK                32768U


/*** MBFIDR5 - Message Buffer Frame ID Registers; 0x0000052C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR5STR;
extern volatile MBFIDR5STR _MBFIDR5 @(REG_BASE + 0x0000052CUL);
#define MBFIDR5                         _MBFIDR5.Word
#define MBFIDR5_FID                     _MBFIDR5.Bits.FID

#define MBFIDR5_FID_MASK                2047U
#define MBFIDR5_FID_BITNUM              0U


/*** MBIDXR5 - Message Buffer Index Register; 0x0000052E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR5STR;
extern volatile MBIDXR5STR _MBIDXR5 @(REG_BASE + 0x0000052EUL);
#define MBIDXR5                         _MBIDXR5.Word
#define MBIDXR5_MBIDX                   _MBIDXR5.Bits.MBIDX

#define MBIDXR5_MBIDX_MASK              63U
#define MBIDXR5_MBIDX_BITNUM            0U


/*** MBCCSR6 - Message Buffer Configuration, Control, Status Register 6; 0x00000530 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR6STR;
extern volatile MBCCSR6STR _MBCCSR6 @(REG_BASE + 0x00000530UL);
#define MBCCSR6                         _MBCCSR6.Word
#define MBCCSR6_MBIF                    _MBCCSR6.Bits.MBIF
#define MBCCSR6_LCKS                    _MBCCSR6.Bits.LCKS
#define MBCCSR6_EDS                     _MBCCSR6.Bits.EDS
#define MBCCSR6_DVAL                    _MBCCSR6.Bits.DVAL
#define MBCCSR6_DUP                     _MBCCSR6.Bits.DUP
#define MBCCSR6_MBIE                    _MBCCSR6.Bits.MBIE
#define MBCCSR6_LCKT                    _MBCCSR6.Bits.LCKT
#define MBCCSR6_EDT                     _MBCCSR6.Bits.EDT
#define MBCCSR6_CMT                     _MBCCSR6.Bits.CMT
#define MBCCSR6_MTD                     _MBCCSR6.Bits.MTD
#define MBCCSR6_MBT                     _MBCCSR6.Bits.MBT
#define MBCCSR6_MCM                     _MBCCSR6.Bits.MCM

#define MBCCSR6_MBIF_MASK               1U
#define MBCCSR6_LCKS_MASK               2U
#define MBCCSR6_EDS_MASK                4U
#define MBCCSR6_DVAL_MASK               8U
#define MBCCSR6_DUP_MASK                16U
#define MBCCSR6_MBIE_MASK               256U
#define MBCCSR6_LCKT_MASK               512U
#define MBCCSR6_EDT_MASK                1024U
#define MBCCSR6_CMT_MASK                2048U
#define MBCCSR6_MTD_MASK                4096U
#define MBCCSR6_MBT_MASK                8192U
#define MBCCSR6_MCM_MASK                16384U


/*** MBCCFR6 - Message Buffer Cycle Counter Filter Register 6; 0x00000532 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR6STR;
extern volatile MBCCFR6STR _MBCCFR6 @(REG_BASE + 0x00000532UL);
#define MBCCFR6                         _MBCCFR6.Word
#define MBCCFR6_CCFVAL                  _MBCCFR6.Bits.CCFVAL
#define MBCCFR6_CCFMSK                  _MBCCFR6.Bits.CCFMSK
#define MBCCFR6_CCFE                    _MBCCFR6.Bits.CCFE
#define MBCCFR6_CHB                     _MBCCFR6.Bits.CHB
#define MBCCFR6_CHA                     _MBCCFR6.Bits.CHA
#define MBCCFR6_MTM                     _MBCCFR6.Bits.MTM

#define MBCCFR6_CCFVAL_MASK             63U
#define MBCCFR6_CCFVAL_BITNUM           0U
#define MBCCFR6_CCFMSK_MASK             4032U
#define MBCCFR6_CCFMSK_BITNUM           6U
#define MBCCFR6_CCFE_MASK               4096U
#define MBCCFR6_CHB_MASK                8192U
#define MBCCFR6_CHA_MASK                16384U
#define MBCCFR6_MTM_MASK                32768U


/*** MBFIDR6 - Message Buffer Frame ID Registers; 0x00000534 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR6STR;
extern volatile MBFIDR6STR _MBFIDR6 @(REG_BASE + 0x00000534UL);
#define MBFIDR6                         _MBFIDR6.Word
#define MBFIDR6_FID                     _MBFIDR6.Bits.FID

#define MBFIDR6_FID_MASK                2047U
#define MBFIDR6_FID_BITNUM              0U


/*** MBIDXR6 - Message Buffer Index Register; 0x00000536 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR6STR;
extern volatile MBIDXR6STR _MBIDXR6 @(REG_BASE + 0x00000536UL);
#define MBIDXR6                         _MBIDXR6.Word
#define MBIDXR6_MBIDX                   _MBIDXR6.Bits.MBIDX

#define MBIDXR6_MBIDX_MASK              63U
#define MBIDXR6_MBIDX_BITNUM            0U


/*** MBCCSR7 - Message Buffer Configuration, Control, Status Register 7; 0x00000538 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR7STR;
extern volatile MBCCSR7STR _MBCCSR7 @(REG_BASE + 0x00000538UL);
#define MBCCSR7                         _MBCCSR7.Word
#define MBCCSR7_MBIF                    _MBCCSR7.Bits.MBIF
#define MBCCSR7_LCKS                    _MBCCSR7.Bits.LCKS
#define MBCCSR7_EDS                     _MBCCSR7.Bits.EDS
#define MBCCSR7_DVAL                    _MBCCSR7.Bits.DVAL
#define MBCCSR7_DUP                     _MBCCSR7.Bits.DUP
#define MBCCSR7_MBIE                    _MBCCSR7.Bits.MBIE
#define MBCCSR7_LCKT                    _MBCCSR7.Bits.LCKT
#define MBCCSR7_EDT                     _MBCCSR7.Bits.EDT
#define MBCCSR7_CMT                     _MBCCSR7.Bits.CMT
#define MBCCSR7_MTD                     _MBCCSR7.Bits.MTD
#define MBCCSR7_MBT                     _MBCCSR7.Bits.MBT
#define MBCCSR7_MCM                     _MBCCSR7.Bits.MCM

#define MBCCSR7_MBIF_MASK               1U
#define MBCCSR7_LCKS_MASK               2U
#define MBCCSR7_EDS_MASK                4U
#define MBCCSR7_DVAL_MASK               8U
#define MBCCSR7_DUP_MASK                16U
#define MBCCSR7_MBIE_MASK               256U
#define MBCCSR7_LCKT_MASK               512U
#define MBCCSR7_EDT_MASK                1024U
#define MBCCSR7_CMT_MASK                2048U
#define MBCCSR7_MTD_MASK                4096U
#define MBCCSR7_MBT_MASK                8192U
#define MBCCSR7_MCM_MASK                16384U


/*** MBCCFR7 - Message Buffer Cycle Counter Filter Register 7; 0x0000053A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR7STR;
extern volatile MBCCFR7STR _MBCCFR7 @(REG_BASE + 0x0000053AUL);
#define MBCCFR7                         _MBCCFR7.Word
#define MBCCFR7_CCFVAL                  _MBCCFR7.Bits.CCFVAL
#define MBCCFR7_CCFMSK                  _MBCCFR7.Bits.CCFMSK
#define MBCCFR7_CCFE                    _MBCCFR7.Bits.CCFE
#define MBCCFR7_CHB                     _MBCCFR7.Bits.CHB
#define MBCCFR7_CHA                     _MBCCFR7.Bits.CHA
#define MBCCFR7_MTM                     _MBCCFR7.Bits.MTM

#define MBCCFR7_CCFVAL_MASK             63U
#define MBCCFR7_CCFVAL_BITNUM           0U
#define MBCCFR7_CCFMSK_MASK             4032U
#define MBCCFR7_CCFMSK_BITNUM           6U
#define MBCCFR7_CCFE_MASK               4096U
#define MBCCFR7_CHB_MASK                8192U
#define MBCCFR7_CHA_MASK                16384U
#define MBCCFR7_MTM_MASK                32768U


/*** MBFIDR7 - Message Buffer Frame ID Registers; 0x0000053C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR7STR;
extern volatile MBFIDR7STR _MBFIDR7 @(REG_BASE + 0x0000053CUL);
#define MBFIDR7                         _MBFIDR7.Word
#define MBFIDR7_FID                     _MBFIDR7.Bits.FID

#define MBFIDR7_FID_MASK                2047U
#define MBFIDR7_FID_BITNUM              0U


/*** MBIDXR7 - Message Buffer Index Register; 0x0000053E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR7STR;
extern volatile MBIDXR7STR _MBIDXR7 @(REG_BASE + 0x0000053EUL);
#define MBIDXR7                         _MBIDXR7.Word
#define MBIDXR7_MBIDX                   _MBIDXR7.Bits.MBIDX

#define MBIDXR7_MBIDX_MASK              63U
#define MBIDXR7_MBIDX_BITNUM            0U


/*** MBCCSR8 - Message Buffer Configuration, Control, Status Register 8; 0x00000540 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR8STR;
extern volatile MBCCSR8STR _MBCCSR8 @(REG_BASE + 0x00000540UL);
#define MBCCSR8                         _MBCCSR8.Word
#define MBCCSR8_MBIF                    _MBCCSR8.Bits.MBIF
#define MBCCSR8_LCKS                    _MBCCSR8.Bits.LCKS
#define MBCCSR8_EDS                     _MBCCSR8.Bits.EDS
#define MBCCSR8_DVAL                    _MBCCSR8.Bits.DVAL
#define MBCCSR8_DUP                     _MBCCSR8.Bits.DUP
#define MBCCSR8_MBIE                    _MBCCSR8.Bits.MBIE
#define MBCCSR8_LCKT                    _MBCCSR8.Bits.LCKT
#define MBCCSR8_EDT                     _MBCCSR8.Bits.EDT
#define MBCCSR8_CMT                     _MBCCSR8.Bits.CMT
#define MBCCSR8_MTD                     _MBCCSR8.Bits.MTD
#define MBCCSR8_MBT                     _MBCCSR8.Bits.MBT
#define MBCCSR8_MCM                     _MBCCSR8.Bits.MCM

#define MBCCSR8_MBIF_MASK               1U
#define MBCCSR8_LCKS_MASK               2U
#define MBCCSR8_EDS_MASK                4U
#define MBCCSR8_DVAL_MASK               8U
#define MBCCSR8_DUP_MASK                16U
#define MBCCSR8_MBIE_MASK               256U
#define MBCCSR8_LCKT_MASK               512U
#define MBCCSR8_EDT_MASK                1024U
#define MBCCSR8_CMT_MASK                2048U
#define MBCCSR8_MTD_MASK                4096U
#define MBCCSR8_MBT_MASK                8192U
#define MBCCSR8_MCM_MASK                16384U


/*** MBCCFR8 - Message Buffer Cycle Counter Filter Register 8; 0x00000542 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR8STR;
extern volatile MBCCFR8STR _MBCCFR8 @(REG_BASE + 0x00000542UL);
#define MBCCFR8                         _MBCCFR8.Word
#define MBCCFR8_CCFVAL                  _MBCCFR8.Bits.CCFVAL
#define MBCCFR8_CCFMSK                  _MBCCFR8.Bits.CCFMSK
#define MBCCFR8_CCFE                    _MBCCFR8.Bits.CCFE
#define MBCCFR8_CHB                     _MBCCFR8.Bits.CHB
#define MBCCFR8_CHA                     _MBCCFR8.Bits.CHA
#define MBCCFR8_MTM                     _MBCCFR8.Bits.MTM

#define MBCCFR8_CCFVAL_MASK             63U
#define MBCCFR8_CCFVAL_BITNUM           0U
#define MBCCFR8_CCFMSK_MASK             4032U
#define MBCCFR8_CCFMSK_BITNUM           6U
#define MBCCFR8_CCFE_MASK               4096U
#define MBCCFR8_CHB_MASK                8192U
#define MBCCFR8_CHA_MASK                16384U
#define MBCCFR8_MTM_MASK                32768U


/*** MBFIDR8 - Message Buffer Frame ID Registers; 0x00000544 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR8STR;
extern volatile MBFIDR8STR _MBFIDR8 @(REG_BASE + 0x00000544UL);
#define MBFIDR8                         _MBFIDR8.Word
#define MBFIDR8_FID                     _MBFIDR8.Bits.FID

#define MBFIDR8_FID_MASK                2047U
#define MBFIDR8_FID_BITNUM              0U


/*** MBIDXR8 - Message Buffer Index Register; 0x00000546 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR8STR;
extern volatile MBIDXR8STR _MBIDXR8 @(REG_BASE + 0x00000546UL);
#define MBIDXR8                         _MBIDXR8.Word
#define MBIDXR8_MBIDX                   _MBIDXR8.Bits.MBIDX

#define MBIDXR8_MBIDX_MASK              63U
#define MBIDXR8_MBIDX_BITNUM            0U


/*** MBCCSR9 - Message Buffer Configuration, Control, Status Register 9; 0x00000548 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR9STR;
extern volatile MBCCSR9STR _MBCCSR9 @(REG_BASE + 0x00000548UL);
#define MBCCSR9                         _MBCCSR9.Word
#define MBCCSR9_MBIF                    _MBCCSR9.Bits.MBIF
#define MBCCSR9_LCKS                    _MBCCSR9.Bits.LCKS
#define MBCCSR9_EDS                     _MBCCSR9.Bits.EDS
#define MBCCSR9_DVAL                    _MBCCSR9.Bits.DVAL
#define MBCCSR9_DUP                     _MBCCSR9.Bits.DUP
#define MBCCSR9_MBIE                    _MBCCSR9.Bits.MBIE
#define MBCCSR9_LCKT                    _MBCCSR9.Bits.LCKT
#define MBCCSR9_EDT                     _MBCCSR9.Bits.EDT
#define MBCCSR9_CMT                     _MBCCSR9.Bits.CMT
#define MBCCSR9_MTD                     _MBCCSR9.Bits.MTD
#define MBCCSR9_MBT                     _MBCCSR9.Bits.MBT
#define MBCCSR9_MCM                     _MBCCSR9.Bits.MCM

#define MBCCSR9_MBIF_MASK               1U
#define MBCCSR9_LCKS_MASK               2U
#define MBCCSR9_EDS_MASK                4U
#define MBCCSR9_DVAL_MASK               8U
#define MBCCSR9_DUP_MASK                16U
#define MBCCSR9_MBIE_MASK               256U
#define MBCCSR9_LCKT_MASK               512U
#define MBCCSR9_EDT_MASK                1024U
#define MBCCSR9_CMT_MASK                2048U
#define MBCCSR9_MTD_MASK                4096U
#define MBCCSR9_MBT_MASK                8192U
#define MBCCSR9_MCM_MASK                16384U


/*** MBCCFR9 - Message Buffer Cycle Counter Filter Register 9; 0x0000054A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR9STR;
extern volatile MBCCFR9STR _MBCCFR9 @(REG_BASE + 0x0000054AUL);
#define MBCCFR9                         _MBCCFR9.Word
#define MBCCFR9_CCFVAL                  _MBCCFR9.Bits.CCFVAL
#define MBCCFR9_CCFMSK                  _MBCCFR9.Bits.CCFMSK
#define MBCCFR9_CCFE                    _MBCCFR9.Bits.CCFE
#define MBCCFR9_CHB                     _MBCCFR9.Bits.CHB
#define MBCCFR9_CHA                     _MBCCFR9.Bits.CHA
#define MBCCFR9_MTM                     _MBCCFR9.Bits.MTM

#define MBCCFR9_CCFVAL_MASK             63U
#define MBCCFR9_CCFVAL_BITNUM           0U
#define MBCCFR9_CCFMSK_MASK             4032U
#define MBCCFR9_CCFMSK_BITNUM           6U
#define MBCCFR9_CCFE_MASK               4096U
#define MBCCFR9_CHB_MASK                8192U
#define MBCCFR9_CHA_MASK                16384U
#define MBCCFR9_MTM_MASK                32768U


/*** MBFIDR9 - Message Buffer Frame ID Registers; 0x0000054C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR9STR;
extern volatile MBFIDR9STR _MBFIDR9 @(REG_BASE + 0x0000054CUL);
#define MBFIDR9                         _MBFIDR9.Word
#define MBFIDR9_FID                     _MBFIDR9.Bits.FID

#define MBFIDR9_FID_MASK                2047U
#define MBFIDR9_FID_BITNUM              0U


/*** MBIDXR9 - Message Buffer Index Register; 0x0000054E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR9STR;
extern volatile MBIDXR9STR _MBIDXR9 @(REG_BASE + 0x0000054EUL);
#define MBIDXR9                         _MBIDXR9.Word
#define MBIDXR9_MBIDX                   _MBIDXR9.Bits.MBIDX

#define MBIDXR9_MBIDX_MASK              63U
#define MBIDXR9_MBIDX_BITNUM            0U


/*** MBCCSR10 - Message Buffer Configuration, Control, Status Register 10; 0x00000550 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR10STR;
extern volatile MBCCSR10STR _MBCCSR10 @(REG_BASE + 0x00000550UL);
#define MBCCSR10                        _MBCCSR10.Word
#define MBCCSR10_MBIF                   _MBCCSR10.Bits.MBIF
#define MBCCSR10_LCKS                   _MBCCSR10.Bits.LCKS
#define MBCCSR10_EDS                    _MBCCSR10.Bits.EDS
#define MBCCSR10_DVAL                   _MBCCSR10.Bits.DVAL
#define MBCCSR10_DUP                    _MBCCSR10.Bits.DUP
#define MBCCSR10_MBIE                   _MBCCSR10.Bits.MBIE
#define MBCCSR10_LCKT                   _MBCCSR10.Bits.LCKT
#define MBCCSR10_EDT                    _MBCCSR10.Bits.EDT
#define MBCCSR10_CMT                    _MBCCSR10.Bits.CMT
#define MBCCSR10_MTD                    _MBCCSR10.Bits.MTD
#define MBCCSR10_MBT                    _MBCCSR10.Bits.MBT
#define MBCCSR10_MCM                    _MBCCSR10.Bits.MCM

#define MBCCSR10_MBIF_MASK              1U
#define MBCCSR10_LCKS_MASK              2U
#define MBCCSR10_EDS_MASK               4U
#define MBCCSR10_DVAL_MASK              8U
#define MBCCSR10_DUP_MASK               16U
#define MBCCSR10_MBIE_MASK              256U
#define MBCCSR10_LCKT_MASK              512U
#define MBCCSR10_EDT_MASK               1024U
#define MBCCSR10_CMT_MASK               2048U
#define MBCCSR10_MTD_MASK               4096U
#define MBCCSR10_MBT_MASK               8192U
#define MBCCSR10_MCM_MASK               16384U


/*** MBCCFR10 - Message Buffer Cycle Counter Filter Register 10; 0x00000552 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR10STR;
extern volatile MBCCFR10STR _MBCCFR10 @(REG_BASE + 0x00000552UL);
#define MBCCFR10                        _MBCCFR10.Word
#define MBCCFR10_CCFVAL                 _MBCCFR10.Bits.CCFVAL
#define MBCCFR10_CCFMSK                 _MBCCFR10.Bits.CCFMSK
#define MBCCFR10_CCFE                   _MBCCFR10.Bits.CCFE
#define MBCCFR10_CHB                    _MBCCFR10.Bits.CHB
#define MBCCFR10_CHA                    _MBCCFR10.Bits.CHA
#define MBCCFR10_MTM                    _MBCCFR10.Bits.MTM

#define MBCCFR10_CCFVAL_MASK            63U
#define MBCCFR10_CCFVAL_BITNUM          0U
#define MBCCFR10_CCFMSK_MASK            4032U
#define MBCCFR10_CCFMSK_BITNUM          6U
#define MBCCFR10_CCFE_MASK              4096U
#define MBCCFR10_CHB_MASK               8192U
#define MBCCFR10_CHA_MASK               16384U
#define MBCCFR10_MTM_MASK               32768U


/*** MBFIDR10 - Message Buffer Frame ID Registers; 0x00000554 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR10STR;
extern volatile MBFIDR10STR _MBFIDR10 @(REG_BASE + 0x00000554UL);
#define MBFIDR10                        _MBFIDR10.Word
#define MBFIDR10_FID                    _MBFIDR10.Bits.FID

#define MBFIDR10_FID_MASK               2047U
#define MBFIDR10_FID_BITNUM             0U


/*** MBIDXR10 - Message Buffer Index Register; 0x00000556 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR10STR;
extern volatile MBIDXR10STR _MBIDXR10 @(REG_BASE + 0x00000556UL);
#define MBIDXR10                        _MBIDXR10.Word
#define MBIDXR10_MBIDX                  _MBIDXR10.Bits.MBIDX

#define MBIDXR10_MBIDX_MASK             63U
#define MBIDXR10_MBIDX_BITNUM           0U


/*** MBCCSR11 - Message Buffer Configuration, Control, Status Register 11; 0x00000558 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR11STR;
extern volatile MBCCSR11STR _MBCCSR11 @(REG_BASE + 0x00000558UL);
#define MBCCSR11                        _MBCCSR11.Word
#define MBCCSR11_MBIF                   _MBCCSR11.Bits.MBIF
#define MBCCSR11_LCKS                   _MBCCSR11.Bits.LCKS
#define MBCCSR11_EDS                    _MBCCSR11.Bits.EDS
#define MBCCSR11_DVAL                   _MBCCSR11.Bits.DVAL
#define MBCCSR11_DUP                    _MBCCSR11.Bits.DUP
#define MBCCSR11_MBIE                   _MBCCSR11.Bits.MBIE
#define MBCCSR11_LCKT                   _MBCCSR11.Bits.LCKT
#define MBCCSR11_EDT                    _MBCCSR11.Bits.EDT
#define MBCCSR11_CMT                    _MBCCSR11.Bits.CMT
#define MBCCSR11_MTD                    _MBCCSR11.Bits.MTD
#define MBCCSR11_MBT                    _MBCCSR11.Bits.MBT
#define MBCCSR11_MCM                    _MBCCSR11.Bits.MCM

#define MBCCSR11_MBIF_MASK              1U
#define MBCCSR11_LCKS_MASK              2U
#define MBCCSR11_EDS_MASK               4U
#define MBCCSR11_DVAL_MASK              8U
#define MBCCSR11_DUP_MASK               16U
#define MBCCSR11_MBIE_MASK              256U
#define MBCCSR11_LCKT_MASK              512U
#define MBCCSR11_EDT_MASK               1024U
#define MBCCSR11_CMT_MASK               2048U
#define MBCCSR11_MTD_MASK               4096U
#define MBCCSR11_MBT_MASK               8192U
#define MBCCSR11_MCM_MASK               16384U


/*** MBCCFR11 - Message Buffer Cycle Counter Filter Register 11; 0x0000055A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR11STR;
extern volatile MBCCFR11STR _MBCCFR11 @(REG_BASE + 0x0000055AUL);
#define MBCCFR11                        _MBCCFR11.Word
#define MBCCFR11_CCFVAL                 _MBCCFR11.Bits.CCFVAL
#define MBCCFR11_CCFMSK                 _MBCCFR11.Bits.CCFMSK
#define MBCCFR11_CCFE                   _MBCCFR11.Bits.CCFE
#define MBCCFR11_CHB                    _MBCCFR11.Bits.CHB
#define MBCCFR11_CHA                    _MBCCFR11.Bits.CHA
#define MBCCFR11_MTM                    _MBCCFR11.Bits.MTM

#define MBCCFR11_CCFVAL_MASK            63U
#define MBCCFR11_CCFVAL_BITNUM          0U
#define MBCCFR11_CCFMSK_MASK            4032U
#define MBCCFR11_CCFMSK_BITNUM          6U
#define MBCCFR11_CCFE_MASK              4096U
#define MBCCFR11_CHB_MASK               8192U
#define MBCCFR11_CHA_MASK               16384U
#define MBCCFR11_MTM_MASK               32768U


/*** MBFIDR11 - Message Buffer Frame ID Registers; 0x0000055C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR11STR;
extern volatile MBFIDR11STR _MBFIDR11 @(REG_BASE + 0x0000055CUL);
#define MBFIDR11                        _MBFIDR11.Word
#define MBFIDR11_FID                    _MBFIDR11.Bits.FID

#define MBFIDR11_FID_MASK               2047U
#define MBFIDR11_FID_BITNUM             0U


/*** MBIDXR11 - Message Buffer Index Register; 0x0000055E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR11STR;
extern volatile MBIDXR11STR _MBIDXR11 @(REG_BASE + 0x0000055EUL);
#define MBIDXR11                        _MBIDXR11.Word
#define MBIDXR11_MBIDX                  _MBIDXR11.Bits.MBIDX

#define MBIDXR11_MBIDX_MASK             63U
#define MBIDXR11_MBIDX_BITNUM           0U


/*** MBCCSR12 - Message Buffer Configuration, Control, Status Register 12; 0x00000560 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR12STR;
extern volatile MBCCSR12STR _MBCCSR12 @(REG_BASE + 0x00000560UL);
#define MBCCSR12                        _MBCCSR12.Word
#define MBCCSR12_MBIF                   _MBCCSR12.Bits.MBIF
#define MBCCSR12_LCKS                   _MBCCSR12.Bits.LCKS
#define MBCCSR12_EDS                    _MBCCSR12.Bits.EDS
#define MBCCSR12_DVAL                   _MBCCSR12.Bits.DVAL
#define MBCCSR12_DUP                    _MBCCSR12.Bits.DUP
#define MBCCSR12_MBIE                   _MBCCSR12.Bits.MBIE
#define MBCCSR12_LCKT                   _MBCCSR12.Bits.LCKT
#define MBCCSR12_EDT                    _MBCCSR12.Bits.EDT
#define MBCCSR12_CMT                    _MBCCSR12.Bits.CMT
#define MBCCSR12_MTD                    _MBCCSR12.Bits.MTD
#define MBCCSR12_MBT                    _MBCCSR12.Bits.MBT
#define MBCCSR12_MCM                    _MBCCSR12.Bits.MCM

#define MBCCSR12_MBIF_MASK              1U
#define MBCCSR12_LCKS_MASK              2U
#define MBCCSR12_EDS_MASK               4U
#define MBCCSR12_DVAL_MASK              8U
#define MBCCSR12_DUP_MASK               16U
#define MBCCSR12_MBIE_MASK              256U
#define MBCCSR12_LCKT_MASK              512U
#define MBCCSR12_EDT_MASK               1024U
#define MBCCSR12_CMT_MASK               2048U
#define MBCCSR12_MTD_MASK               4096U
#define MBCCSR12_MBT_MASK               8192U
#define MBCCSR12_MCM_MASK               16384U


/*** MBCCFR12 - Message Buffer Cycle Counter Filter Register 12; 0x00000562 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR12STR;
extern volatile MBCCFR12STR _MBCCFR12 @(REG_BASE + 0x00000562UL);
#define MBCCFR12                        _MBCCFR12.Word
#define MBCCFR12_CCFVAL                 _MBCCFR12.Bits.CCFVAL
#define MBCCFR12_CCFMSK                 _MBCCFR12.Bits.CCFMSK
#define MBCCFR12_CCFE                   _MBCCFR12.Bits.CCFE
#define MBCCFR12_CHB                    _MBCCFR12.Bits.CHB
#define MBCCFR12_CHA                    _MBCCFR12.Bits.CHA
#define MBCCFR12_MTM                    _MBCCFR12.Bits.MTM

#define MBCCFR12_CCFVAL_MASK            63U
#define MBCCFR12_CCFVAL_BITNUM          0U
#define MBCCFR12_CCFMSK_MASK            4032U
#define MBCCFR12_CCFMSK_BITNUM          6U
#define MBCCFR12_CCFE_MASK              4096U
#define MBCCFR12_CHB_MASK               8192U
#define MBCCFR12_CHA_MASK               16384U
#define MBCCFR12_MTM_MASK               32768U


/*** MBFIDR12 - Message Buffer Frame ID Registers; 0x00000564 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR12STR;
extern volatile MBFIDR12STR _MBFIDR12 @(REG_BASE + 0x00000564UL);
#define MBFIDR12                        _MBFIDR12.Word
#define MBFIDR12_FID                    _MBFIDR12.Bits.FID

#define MBFIDR12_FID_MASK               2047U
#define MBFIDR12_FID_BITNUM             0U


/*** MBIDXR12 - Message Buffer Index Register; 0x00000566 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR12STR;
extern volatile MBIDXR12STR _MBIDXR12 @(REG_BASE + 0x00000566UL);
#define MBIDXR12                        _MBIDXR12.Word
#define MBIDXR12_MBIDX                  _MBIDXR12.Bits.MBIDX

#define MBIDXR12_MBIDX_MASK             63U
#define MBIDXR12_MBIDX_BITNUM           0U


/*** MBCCSR13 - Message Buffer Configuration, Control, Status Register 13; 0x00000568 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR13STR;
extern volatile MBCCSR13STR _MBCCSR13 @(REG_BASE + 0x00000568UL);
#define MBCCSR13                        _MBCCSR13.Word
#define MBCCSR13_MBIF                   _MBCCSR13.Bits.MBIF
#define MBCCSR13_LCKS                   _MBCCSR13.Bits.LCKS
#define MBCCSR13_EDS                    _MBCCSR13.Bits.EDS
#define MBCCSR13_DVAL                   _MBCCSR13.Bits.DVAL
#define MBCCSR13_DUP                    _MBCCSR13.Bits.DUP
#define MBCCSR13_MBIE                   _MBCCSR13.Bits.MBIE
#define MBCCSR13_LCKT                   _MBCCSR13.Bits.LCKT
#define MBCCSR13_EDT                    _MBCCSR13.Bits.EDT
#define MBCCSR13_CMT                    _MBCCSR13.Bits.CMT
#define MBCCSR13_MTD                    _MBCCSR13.Bits.MTD
#define MBCCSR13_MBT                    _MBCCSR13.Bits.MBT
#define MBCCSR13_MCM                    _MBCCSR13.Bits.MCM

#define MBCCSR13_MBIF_MASK              1U
#define MBCCSR13_LCKS_MASK              2U
#define MBCCSR13_EDS_MASK               4U
#define MBCCSR13_DVAL_MASK              8U
#define MBCCSR13_DUP_MASK               16U
#define MBCCSR13_MBIE_MASK              256U
#define MBCCSR13_LCKT_MASK              512U
#define MBCCSR13_EDT_MASK               1024U
#define MBCCSR13_CMT_MASK               2048U
#define MBCCSR13_MTD_MASK               4096U
#define MBCCSR13_MBT_MASK               8192U
#define MBCCSR13_MCM_MASK               16384U


/*** MBCCFR13 - Message Buffer Cycle Counter Filter Register 13; 0x0000056A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR13STR;
extern volatile MBCCFR13STR _MBCCFR13 @(REG_BASE + 0x0000056AUL);
#define MBCCFR13                        _MBCCFR13.Word
#define MBCCFR13_CCFVAL                 _MBCCFR13.Bits.CCFVAL
#define MBCCFR13_CCFMSK                 _MBCCFR13.Bits.CCFMSK
#define MBCCFR13_CCFE                   _MBCCFR13.Bits.CCFE
#define MBCCFR13_CHB                    _MBCCFR13.Bits.CHB
#define MBCCFR13_CHA                    _MBCCFR13.Bits.CHA
#define MBCCFR13_MTM                    _MBCCFR13.Bits.MTM

#define MBCCFR13_CCFVAL_MASK            63U
#define MBCCFR13_CCFVAL_BITNUM          0U
#define MBCCFR13_CCFMSK_MASK            4032U
#define MBCCFR13_CCFMSK_BITNUM          6U
#define MBCCFR13_CCFE_MASK              4096U
#define MBCCFR13_CHB_MASK               8192U
#define MBCCFR13_CHA_MASK               16384U
#define MBCCFR13_MTM_MASK               32768U


/*** MBFIDR13 - Message Buffer Frame ID Registers; 0x0000056C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR13STR;
extern volatile MBFIDR13STR _MBFIDR13 @(REG_BASE + 0x0000056CUL);
#define MBFIDR13                        _MBFIDR13.Word
#define MBFIDR13_FID                    _MBFIDR13.Bits.FID

#define MBFIDR13_FID_MASK               2047U
#define MBFIDR13_FID_BITNUM             0U


/*** MBIDXR13 - Message Buffer Index Register; 0x0000056E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR13STR;
extern volatile MBIDXR13STR _MBIDXR13 @(REG_BASE + 0x0000056EUL);
#define MBIDXR13                        _MBIDXR13.Word
#define MBIDXR13_MBIDX                  _MBIDXR13.Bits.MBIDX

#define MBIDXR13_MBIDX_MASK             63U
#define MBIDXR13_MBIDX_BITNUM           0U


/*** MBCCSR14 - Message Buffer Configuration, Control, Status Register 14; 0x00000570 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR14STR;
extern volatile MBCCSR14STR _MBCCSR14 @(REG_BASE + 0x00000570UL);
#define MBCCSR14                        _MBCCSR14.Word
#define MBCCSR14_MBIF                   _MBCCSR14.Bits.MBIF
#define MBCCSR14_LCKS                   _MBCCSR14.Bits.LCKS
#define MBCCSR14_EDS                    _MBCCSR14.Bits.EDS
#define MBCCSR14_DVAL                   _MBCCSR14.Bits.DVAL
#define MBCCSR14_DUP                    _MBCCSR14.Bits.DUP
#define MBCCSR14_MBIE                   _MBCCSR14.Bits.MBIE
#define MBCCSR14_LCKT                   _MBCCSR14.Bits.LCKT
#define MBCCSR14_EDT                    _MBCCSR14.Bits.EDT
#define MBCCSR14_CMT                    _MBCCSR14.Bits.CMT
#define MBCCSR14_MTD                    _MBCCSR14.Bits.MTD
#define MBCCSR14_MBT                    _MBCCSR14.Bits.MBT
#define MBCCSR14_MCM                    _MBCCSR14.Bits.MCM

#define MBCCSR14_MBIF_MASK              1U
#define MBCCSR14_LCKS_MASK              2U
#define MBCCSR14_EDS_MASK               4U
#define MBCCSR14_DVAL_MASK              8U
#define MBCCSR14_DUP_MASK               16U
#define MBCCSR14_MBIE_MASK              256U
#define MBCCSR14_LCKT_MASK              512U
#define MBCCSR14_EDT_MASK               1024U
#define MBCCSR14_CMT_MASK               2048U
#define MBCCSR14_MTD_MASK               4096U
#define MBCCSR14_MBT_MASK               8192U
#define MBCCSR14_MCM_MASK               16384U


/*** MBCCFR14 - Message Buffer Cycle Counter Filter Register 14; 0x00000572 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR14STR;
extern volatile MBCCFR14STR _MBCCFR14 @(REG_BASE + 0x00000572UL);
#define MBCCFR14                        _MBCCFR14.Word
#define MBCCFR14_CCFVAL                 _MBCCFR14.Bits.CCFVAL
#define MBCCFR14_CCFMSK                 _MBCCFR14.Bits.CCFMSK
#define MBCCFR14_CCFE                   _MBCCFR14.Bits.CCFE
#define MBCCFR14_CHB                    _MBCCFR14.Bits.CHB
#define MBCCFR14_CHA                    _MBCCFR14.Bits.CHA
#define MBCCFR14_MTM                    _MBCCFR14.Bits.MTM

#define MBCCFR14_CCFVAL_MASK            63U
#define MBCCFR14_CCFVAL_BITNUM          0U
#define MBCCFR14_CCFMSK_MASK            4032U
#define MBCCFR14_CCFMSK_BITNUM          6U
#define MBCCFR14_CCFE_MASK              4096U
#define MBCCFR14_CHB_MASK               8192U
#define MBCCFR14_CHA_MASK               16384U
#define MBCCFR14_MTM_MASK               32768U


/*** MBFIDR14 - Message Buffer Frame ID Registers; 0x00000574 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR14STR;
extern volatile MBFIDR14STR _MBFIDR14 @(REG_BASE + 0x00000574UL);
#define MBFIDR14                        _MBFIDR14.Word
#define MBFIDR14_FID                    _MBFIDR14.Bits.FID

#define MBFIDR14_FID_MASK               2047U
#define MBFIDR14_FID_BITNUM             0U


/*** MBIDXR14 - Message Buffer Index Register; 0x00000576 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR14STR;
extern volatile MBIDXR14STR _MBIDXR14 @(REG_BASE + 0x00000576UL);
#define MBIDXR14                        _MBIDXR14.Word
#define MBIDXR14_MBIDX                  _MBIDXR14.Bits.MBIDX

#define MBIDXR14_MBIDX_MASK             63U
#define MBIDXR14_MBIDX_BITNUM           0U


/*** MBCCSR15 - Message Buffer Configuration, Control, Status Register 15; 0x00000578 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR15STR;
extern volatile MBCCSR15STR _MBCCSR15 @(REG_BASE + 0x00000578UL);
#define MBCCSR15                        _MBCCSR15.Word
#define MBCCSR15_MBIF                   _MBCCSR15.Bits.MBIF
#define MBCCSR15_LCKS                   _MBCCSR15.Bits.LCKS
#define MBCCSR15_EDS                    _MBCCSR15.Bits.EDS
#define MBCCSR15_DVAL                   _MBCCSR15.Bits.DVAL
#define MBCCSR15_DUP                    _MBCCSR15.Bits.DUP
#define MBCCSR15_MBIE                   _MBCCSR15.Bits.MBIE
#define MBCCSR15_LCKT                   _MBCCSR15.Bits.LCKT
#define MBCCSR15_EDT                    _MBCCSR15.Bits.EDT
#define MBCCSR15_CMT                    _MBCCSR15.Bits.CMT
#define MBCCSR15_MTD                    _MBCCSR15.Bits.MTD
#define MBCCSR15_MBT                    _MBCCSR15.Bits.MBT
#define MBCCSR15_MCM                    _MBCCSR15.Bits.MCM

#define MBCCSR15_MBIF_MASK              1U
#define MBCCSR15_LCKS_MASK              2U
#define MBCCSR15_EDS_MASK               4U
#define MBCCSR15_DVAL_MASK              8U
#define MBCCSR15_DUP_MASK               16U
#define MBCCSR15_MBIE_MASK              256U
#define MBCCSR15_LCKT_MASK              512U
#define MBCCSR15_EDT_MASK               1024U
#define MBCCSR15_CMT_MASK               2048U
#define MBCCSR15_MTD_MASK               4096U
#define MBCCSR15_MBT_MASK               8192U
#define MBCCSR15_MCM_MASK               16384U


/*** MBCCFR15 - Message Buffer Cycle Counter Filter Register 15; 0x0000057A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR15STR;
extern volatile MBCCFR15STR _MBCCFR15 @(REG_BASE + 0x0000057AUL);
#define MBCCFR15                        _MBCCFR15.Word
#define MBCCFR15_CCFVAL                 _MBCCFR15.Bits.CCFVAL
#define MBCCFR15_CCFMSK                 _MBCCFR15.Bits.CCFMSK
#define MBCCFR15_CCFE                   _MBCCFR15.Bits.CCFE
#define MBCCFR15_CHB                    _MBCCFR15.Bits.CHB
#define MBCCFR15_CHA                    _MBCCFR15.Bits.CHA
#define MBCCFR15_MTM                    _MBCCFR15.Bits.MTM

#define MBCCFR15_CCFVAL_MASK            63U
#define MBCCFR15_CCFVAL_BITNUM          0U
#define MBCCFR15_CCFMSK_MASK            4032U
#define MBCCFR15_CCFMSK_BITNUM          6U
#define MBCCFR15_CCFE_MASK              4096U
#define MBCCFR15_CHB_MASK               8192U
#define MBCCFR15_CHA_MASK               16384U
#define MBCCFR15_MTM_MASK               32768U


/*** MBFIDR15 - Message Buffer Frame ID Registers; 0x0000057C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR15STR;
extern volatile MBFIDR15STR _MBFIDR15 @(REG_BASE + 0x0000057CUL);
#define MBFIDR15                        _MBFIDR15.Word
#define MBFIDR15_FID                    _MBFIDR15.Bits.FID

#define MBFIDR15_FID_MASK               2047U
#define MBFIDR15_FID_BITNUM             0U


/*** MBIDXR15 - Message Buffer Index Register; 0x0000057E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR15STR;
extern volatile MBIDXR15STR _MBIDXR15 @(REG_BASE + 0x0000057EUL);
#define MBIDXR15                        _MBIDXR15.Word
#define MBIDXR15_MBIDX                  _MBIDXR15.Bits.MBIDX

#define MBIDXR15_MBIDX_MASK             63U
#define MBIDXR15_MBIDX_BITNUM           0U


/*** MBCCSR16 - Message Buffer Configuration, Control, Status Register 16; 0x00000580 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR16STR;
extern volatile MBCCSR16STR _MBCCSR16 @(REG_BASE + 0x00000580UL);
#define MBCCSR16                        _MBCCSR16.Word
#define MBCCSR16_MBIF                   _MBCCSR16.Bits.MBIF
#define MBCCSR16_LCKS                   _MBCCSR16.Bits.LCKS
#define MBCCSR16_EDS                    _MBCCSR16.Bits.EDS
#define MBCCSR16_DVAL                   _MBCCSR16.Bits.DVAL
#define MBCCSR16_DUP                    _MBCCSR16.Bits.DUP
#define MBCCSR16_MBIE                   _MBCCSR16.Bits.MBIE
#define MBCCSR16_LCKT                   _MBCCSR16.Bits.LCKT
#define MBCCSR16_EDT                    _MBCCSR16.Bits.EDT
#define MBCCSR16_CMT                    _MBCCSR16.Bits.CMT
#define MBCCSR16_MTD                    _MBCCSR16.Bits.MTD
#define MBCCSR16_MBT                    _MBCCSR16.Bits.MBT
#define MBCCSR16_MCM                    _MBCCSR16.Bits.MCM

#define MBCCSR16_MBIF_MASK              1U
#define MBCCSR16_LCKS_MASK              2U
#define MBCCSR16_EDS_MASK               4U
#define MBCCSR16_DVAL_MASK              8U
#define MBCCSR16_DUP_MASK               16U
#define MBCCSR16_MBIE_MASK              256U
#define MBCCSR16_LCKT_MASK              512U
#define MBCCSR16_EDT_MASK               1024U
#define MBCCSR16_CMT_MASK               2048U
#define MBCCSR16_MTD_MASK               4096U
#define MBCCSR16_MBT_MASK               8192U
#define MBCCSR16_MCM_MASK               16384U


/*** MBCCFR16 - Message Buffer Cycle Counter Filter Register 16; 0x00000582 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR16STR;
extern volatile MBCCFR16STR _MBCCFR16 @(REG_BASE + 0x00000582UL);
#define MBCCFR16                        _MBCCFR16.Word
#define MBCCFR16_CCFVAL                 _MBCCFR16.Bits.CCFVAL
#define MBCCFR16_CCFMSK                 _MBCCFR16.Bits.CCFMSK
#define MBCCFR16_CCFE                   _MBCCFR16.Bits.CCFE
#define MBCCFR16_CHB                    _MBCCFR16.Bits.CHB
#define MBCCFR16_CHA                    _MBCCFR16.Bits.CHA
#define MBCCFR16_MTM                    _MBCCFR16.Bits.MTM

#define MBCCFR16_CCFVAL_MASK            63U
#define MBCCFR16_CCFVAL_BITNUM          0U
#define MBCCFR16_CCFMSK_MASK            4032U
#define MBCCFR16_CCFMSK_BITNUM          6U
#define MBCCFR16_CCFE_MASK              4096U
#define MBCCFR16_CHB_MASK               8192U
#define MBCCFR16_CHA_MASK               16384U
#define MBCCFR16_MTM_MASK               32768U


/*** MBFIDR16 - Message Buffer Frame ID Registers; 0x00000584 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR16STR;
extern volatile MBFIDR16STR _MBFIDR16 @(REG_BASE + 0x00000584UL);
#define MBFIDR16                        _MBFIDR16.Word
#define MBFIDR16_FID                    _MBFIDR16.Bits.FID

#define MBFIDR16_FID_MASK               2047U
#define MBFIDR16_FID_BITNUM             0U


/*** MBIDXR16 - Message Buffer Index Register; 0x00000586 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR16STR;
extern volatile MBIDXR16STR _MBIDXR16 @(REG_BASE + 0x00000586UL);
#define MBIDXR16                        _MBIDXR16.Word
#define MBIDXR16_MBIDX                  _MBIDXR16.Bits.MBIDX

#define MBIDXR16_MBIDX_MASK             63U
#define MBIDXR16_MBIDX_BITNUM           0U


/*** MBCCSR17 - Message Buffer Configuration, Control, Status Register 17; 0x00000588 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR17STR;
extern volatile MBCCSR17STR _MBCCSR17 @(REG_BASE + 0x00000588UL);
#define MBCCSR17                        _MBCCSR17.Word
#define MBCCSR17_MBIF                   _MBCCSR17.Bits.MBIF
#define MBCCSR17_LCKS                   _MBCCSR17.Bits.LCKS
#define MBCCSR17_EDS                    _MBCCSR17.Bits.EDS
#define MBCCSR17_DVAL                   _MBCCSR17.Bits.DVAL
#define MBCCSR17_DUP                    _MBCCSR17.Bits.DUP
#define MBCCSR17_MBIE                   _MBCCSR17.Bits.MBIE
#define MBCCSR17_LCKT                   _MBCCSR17.Bits.LCKT
#define MBCCSR17_EDT                    _MBCCSR17.Bits.EDT
#define MBCCSR17_CMT                    _MBCCSR17.Bits.CMT
#define MBCCSR17_MTD                    _MBCCSR17.Bits.MTD
#define MBCCSR17_MBT                    _MBCCSR17.Bits.MBT
#define MBCCSR17_MCM                    _MBCCSR17.Bits.MCM

#define MBCCSR17_MBIF_MASK              1U
#define MBCCSR17_LCKS_MASK              2U
#define MBCCSR17_EDS_MASK               4U
#define MBCCSR17_DVAL_MASK              8U
#define MBCCSR17_DUP_MASK               16U
#define MBCCSR17_MBIE_MASK              256U
#define MBCCSR17_LCKT_MASK              512U
#define MBCCSR17_EDT_MASK               1024U
#define MBCCSR17_CMT_MASK               2048U
#define MBCCSR17_MTD_MASK               4096U
#define MBCCSR17_MBT_MASK               8192U
#define MBCCSR17_MCM_MASK               16384U


/*** MBCCFR17 - Message Buffer Cycle Counter Filter Register 17; 0x0000058A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR17STR;
extern volatile MBCCFR17STR _MBCCFR17 @(REG_BASE + 0x0000058AUL);
#define MBCCFR17                        _MBCCFR17.Word
#define MBCCFR17_CCFVAL                 _MBCCFR17.Bits.CCFVAL
#define MBCCFR17_CCFMSK                 _MBCCFR17.Bits.CCFMSK
#define MBCCFR17_CCFE                   _MBCCFR17.Bits.CCFE
#define MBCCFR17_CHB                    _MBCCFR17.Bits.CHB
#define MBCCFR17_CHA                    _MBCCFR17.Bits.CHA
#define MBCCFR17_MTM                    _MBCCFR17.Bits.MTM

#define MBCCFR17_CCFVAL_MASK            63U
#define MBCCFR17_CCFVAL_BITNUM          0U
#define MBCCFR17_CCFMSK_MASK            4032U
#define MBCCFR17_CCFMSK_BITNUM          6U
#define MBCCFR17_CCFE_MASK              4096U
#define MBCCFR17_CHB_MASK               8192U
#define MBCCFR17_CHA_MASK               16384U
#define MBCCFR17_MTM_MASK               32768U


/*** MBFIDR17 - Message Buffer Frame ID Registers; 0x0000058C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR17STR;
extern volatile MBFIDR17STR _MBFIDR17 @(REG_BASE + 0x0000058CUL);
#define MBFIDR17                        _MBFIDR17.Word
#define MBFIDR17_FID                    _MBFIDR17.Bits.FID

#define MBFIDR17_FID_MASK               2047U
#define MBFIDR17_FID_BITNUM             0U


/*** MBIDXR17 - Message Buffer Index Register; 0x0000058E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR17STR;
extern volatile MBIDXR17STR _MBIDXR17 @(REG_BASE + 0x0000058EUL);
#define MBIDXR17                        _MBIDXR17.Word
#define MBIDXR17_MBIDX                  _MBIDXR17.Bits.MBIDX

#define MBIDXR17_MBIDX_MASK             63U
#define MBIDXR17_MBIDX_BITNUM           0U


/*** MBCCSR18 - Message Buffer Configuration, Control, St