; Based on CPU DB MC9S12XF512_144, version 3.00.030 (RegistersPrg V2.32)

; ###################################################################
;     Filename  : mc9s12xf256.inc
;     Processor : MC9S12XF256CAG
;     FileFormat: V2.32
;     DataSheet : MC9S12XF512V1RM Rev.1.18 01-March-2010
;     Compiler  : CodeWarrior compiler
;     Date/Time : 29.7.2010, 10:37
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 12.10.2007, V3.00.0:
;              - Renamed interrupt vector VReserved65 ==> Vhti.
;              - Added definitions of the individual bits in registers MMCCTL0, SYNR, REFDV, POSTDIV, FCCOBIX, FECCRIX, FSTAT, PITMTLD0/1.
;              - Removed bits PAxH, TCxH, FSTAT[RSVD], TI2CR0/1[MTCNTx].
;              - Addedbits ATDDRx[BIT0:3], MPUSEL[SEL4], VREGHTCL[HTIF, HTIE, HTDS, HTEN], XGIF_0F_00[bit8:11].
;              - Renamed CAN Buffers: *R/T* ==> *RX/TX* (for example CAN1TIDR1 ==> CAN1TXIDR1).
;              - Added register VREGHTTR.
;              - Renamed bits PITCFLMT[PITLMT] ==> PITCFLMT[PFLMT], PITFLT[PITFLTx] ==> PITFLT[PFLTx], PITCE[PITCEx] ==> PITCE[PCEx], PITMUX[PITMUXx] ==> PITMUX[PMUXx], PITINTE[PITINTEx] ==> PITINTE[PINTEx], PITTF[PITTFx] ==> PITTF[PTFx].
;              - Corrected registers' addresses NVEPROT 0xFF0C ==> 0xFF0D, NVFPROT 0xFF0D ==> 0xFF0C.
;              -   REASON: Bug-fix (#5367 in Issue Manager).
;      - 14.11.2008, V3.00.1:
;              - Corrected definition of depreciated symbols.
;              -   REASON: Bug-fix(#6592 in Issue Manager).
;
;     File-Format-Revisions:
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, if register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;      - 3.8.2009, V2.29 :
;               - If there is just one bits group matching register name, single bits are not generated
;      - 10.9.2009, V2.30 :
;               - Fixed generation of registers arrays.
;      - 15.10.2009, V2.31 :
;               - Changes have not affected this file (because they are related to another family)
;      - 18.05.2010, V2.32 :
;               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
EEPROMStart:        equ   $00000C00
EEPROMEnd:          equ   $00000FFF
RAMStart:           equ   $00002000
RAMEnd:             equ   $00003FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
EEPROM_00Start:     equ   $00100000
EEPROM_00End:       equ   $001003FF
EEPROM_01Start:     equ   $00100400
EEPROM_01End:       equ   $001007FF
EEPROM_02Start:     equ   $00100800
EEPROM_02End:       equ   $00100BFF
EEPROM_03Start:     equ   $00100C00
EEPROM_03End:       equ   $00100FFF
EEPROM_04Start:     equ   $00101000
EEPROM_04End:       equ   $001013FF
EEPROM_05Start:     equ   $00101400
EEPROM_05End:       equ   $001017FF
EEPROM_06Start:     equ   $00101800
EEPROM_06End:       equ   $00101BFF
EEPROM_07Start:     equ   $00101C00
EEPROM_07End:       equ   $00101FFF
EEPROM_08Start:     equ   $00102000
EEPROM_08End:       equ   $001023FF
EEPROM_09Start:     equ   $00102400
EEPROM_09End:       equ   $001027FF
EEPROM_0AStart:     equ   $00102800
EEPROM_0AEnd:       equ   $00102BFF
EEPROM_0BStart:     equ   $00102C00
EEPROM_0BEnd:       equ   $00102FFF
EEPROM_0CStart:     equ   $00103000
EEPROM_0CEnd:       equ   $001033FF
EEPROM_0DStart:     equ   $00103400
EEPROM_0DEnd:       equ   $001037FF
EEPROM_0EStart:     equ   $00103800
EEPROM_0EEnd:       equ   $00103BFF
EEPROM_0FStart:     equ   $00103C00
EEPROM_0FEnd:       equ   $00103FFF
EEPROM_10Start:     equ   $00104000
EEPROM_10End:       equ   $001043FF
EEPROM_11Start:     equ   $00104400
EEPROM_11End:       equ   $001047FF
EEPROM_12Start:     equ   $00104800
EEPROM_12End:       equ   $00104BFF
EEPROM_13Start:     equ   $00104C00
EEPROM_13End:       equ   $00104FFF
EEPROM_14Start:     equ   $00105000
EEPROM_14End:       equ   $001053FF
EEPROM_15Start:     equ   $00105400
EEPROM_15End:       equ   $001057FF
EEPROM_16Start:     equ   $00105800
EEPROM_16End:       equ   $00105BFF
EEPROM_17Start:     equ   $00105C00
EEPROM_17End:       equ   $00105FFF
EEPROM_18Start:     equ   $00106000
EEPROM_18End:       equ   $001063FF
EEPROM_19Start:     equ   $00106400
EEPROM_19End:       equ   $001067FF
EEPROM_1AStart:     equ   $00106800
EEPROM_1AEnd:       equ   $00106BFF
EEPROM_1BStart:     equ   $00106C00
EEPROM_1BEnd:       equ   $00106FFF
EEPROM_1CStart:     equ   $00107000
EEPROM_1CEnd:       equ   $001073FF
EEPROM_1DStart:     equ   $00107400
EEPROM_1DEnd:       equ   $001077FF
EEPROM_1EStart:     equ   $00107800
EEPROM_1EEnd:       equ   $00107BFF
EEPROM_1FStart:     equ   $00107C00
EEPROM_1FEnd:       equ   $00107FFF
EEPROM_FEStart:     equ   $0013F800
EEPROM_FEEnd:       equ   $0013FBFF
RAM_FBStart:        equ   $000FB000
RAM_FBEnd:          equ   $000FBFFF
RAM_FCStart:        equ   $000FC000
RAM_FCEnd:          equ   $000FCFFF
RAM_FDStart:        equ   $000FD000
RAM_FDEnd:          equ   $000FDFFF
PAGE_E0Start:       equ   $00780000
PAGE_E0End:         equ   $00783FFF
PAGE_E1Start:       equ   $00784000
PAGE_E1End:         equ   $00787FFF
PAGE_E2Start:       equ   $00788000
PAGE_E2End:         equ   $0078BFFF
PAGE_E3Start:       equ   $0078C000
PAGE_E3End:         equ   $0078FFFF
PAGE_E4Start:       equ   $00790000
PAGE_E4End:         equ   $00793FFF
PAGE_E5Start:       equ   $00794000
PAGE_E5End:         equ   $00797FFF
PAGE_E6Start:       equ   $00798000
PAGE_E6End:         equ   $0079BFFF
PAGE_E7Start:       equ   $0079C000
PAGE_E7End:         equ   $0079FFFF
PAGE_F8Start:       equ   $007E0000
PAGE_F8End:         equ   $007E3FFF
PAGE_F9Start:       equ   $007E4000
PAGE_F9End:         equ   $007E7FFF
PAGE_FAStart:       equ   $007E8000
PAGE_FAEnd:         equ   $007EBFFF
PAGE_FBStart:       equ   $007EC000
PAGE_FBEnd:         equ   $007EFFFF
PAGE_FCStart:       equ   $007F0000
PAGE_FCEnd:         equ   $007F3FFF
PAGE_FEStart:       equ   $007F8000
PAGE_FEEnd:         equ   $007FBFFF
;
Vsi:                equ   $0000FF10
Vsyscall:           equ   $0000FF12
Vmpuaccesserr:      equ   $0000FF14
Vxsei:              equ   $0000FF16
VReserved115:       equ   $0000FF18
VReserved114:       equ   $0000FF1A
VReserved113:       equ   $0000FF1C
VReserved112:       equ   $0000FF1E
VReserved111:       equ   $0000FF20
VReserved110:       equ   $0000FF22
VReserved109:       equ   $0000FF24
VReserved108:       equ   $0000FF26
VReserved107:       equ   $0000FF28
VReserved106:       equ   $0000FF2A
VReserved105:       equ   $0000FF2C
VReserved104:       equ   $0000FF2E
VReserved103:       equ   $0000FF30
VReserved102:       equ   $0000FF32
VReserved101:       equ   $0000FF34
VReserved100:       equ   $0000FF36
VReserved99:        equ   $0000FF38
VReserved98:        equ   $0000FF3A
Vatdcompare:        equ   $0000FF3C
VReserved96:        equ   $0000FF3E
VReserved95:        equ   $0000FF40
VReserved94:        equ   $0000FF42
VReserved93:        equ   $0000FF44
VReserved92:        equ   $0000FF46
VReserved91:        equ   $0000FF48
VReserved90:        equ   $0000FF4A
VReserved89:        equ   $0000FF4C
VReserved88:        equ   $0000FF4E
VReserved87:        equ   $0000FF50
VReserved86:        equ   $0000FF52
VReserved85:        equ   $0000FF54
Vintrig:            equ   $0000FF56
Vpit7:              equ   $0000FF58
Vpit6:              equ   $0000FF5A
Vpit5:              equ   $0000FF5C
Vpit4:              equ   $0000FF5E
VReserved79:        equ   $0000FF60
VReserved78:        equ   $0000FF62
Vxst7:              equ   $0000FF64
Vxst6:              equ   $0000FF66
Vxst5:              equ   $0000FF68
Vxst4:              equ   $0000FF6A
Vxst3:              equ   $0000FF6C
Vxst2:              equ   $0000FF6E
Vxst1:              equ   $0000FF70
Vxst0:              equ   $0000FF72
Vpit3:              equ   $0000FF74
Vpit2:              equ   $0000FF76
Vpit1:              equ   $0000FF78
Vpit0:              equ   $0000FF7A
Vhti:               equ   $0000FF7C
Vapi:               equ   $0000FF7E
Vlvi:               equ   $0000FF80
VReserved62:        equ   $0000FF82
VReserved61:        equ   $0000FF84
VReserved60:        equ   $0000FF86
VReserved59:        equ   $0000FF88
VReserved58:        equ   $0000FF8A
Vpmffault3:         equ   $0000FF8C
Vpmffault2:         equ   $0000FF8E
Vpmffault1:         equ   $0000FF90
Vpmffault0:         equ   $0000FF92
Vpmfgcr:            equ   $0000FF94
Vpmfgbr:            equ   $0000FF96
Vpmfgar:            equ   $0000FF98
Vfrprot:            equ   $0000FF9A
Vfrchi:             equ   $0000FF9C
Vfrwakeup:          equ   $0000FF9E
Vfrrxfifob:         equ   $0000FFA0
Vfrrxfifoa:         equ   $0000FFA2
Vfrrxmessbuff:      equ   $0000FFA4
Vfrtxmessbuff:      equ   $0000FFA6
VReserved43:        equ   $0000FFA8
VReserved42:        equ   $0000FFAA
VReserved41:        equ   $0000FFAC
VReserved40:        equ   $0000FFAE
Vcan0tx:            equ   $0000FFB0
Vcan0rx:            equ   $0000FFB2
Vcan0err:           equ   $0000FFB4
Vcan0wkup:          equ   $0000FFB6
Vflash:             equ   $0000FFB8
Vflashfd:           equ   $0000FFBA
VReserved33:        equ   $0000FFBC
Vspi1:              equ   $0000FFBE
VReserved31:        equ   $0000FFC0
Vcrgipllcol:        equ   $0000FFC2
Vcrgscm:            equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
Vtimpabovf:         equ   $0000FFC8
Vtimmdcu:           equ   $0000FFCA
VReserved25:        equ   $0000FFCC
VReserved24:        equ   $0000FFCE
Vatd:               equ   $0000FFD0
VReserved22:        equ   $0000FFD2
Vsci1:              equ   $0000FFD4
Vsci0:              equ   $0000FFD6
Vspi0:              equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaaovf:         equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
Vtimch3:            equ   $0000FFE8
Vtimch2:            equ   $0000FFEA
Vtimch1:            equ   $0000FFEC
Vtimch0:            equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB Data Register; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_PB0:         equ    0                                         ; Port B Bit 0
PORTAB_PB1:         equ    1                                         ; Port B Bit 1
PORTAB_PB2:         equ    2                                         ; Port B Bit 2
PORTAB_PB3:         equ    3                                         ; Port B Bit 3
PORTAB_PB4:         equ    4                                         ; Port B Bit 4
PORTAB_PB5:         equ    5                                         ; Port B Bit 5
PORTAB_PB6:         equ    6                                         ; Port B Bit 6
PORTAB_PB7:         equ    7                                         ; Port B Bit 7
PORTAB_PA0:         equ    8                                         ; Port A Bit 0
PORTAB_PA1:         equ    9                                         ; Port A Bit 1
PORTAB_PA2:         equ    10                                        ; Port A Bit 2
PORTAB_PA3:         equ    11                                        ; Port A Bit 3
PORTAB_PA4:         equ    12                                        ; Port A Bit 4
PORTAB_PA5:         equ    13                                        ; Port A Bit 5
PORTAB_PA6:         equ    14                                        ; Port A Bit 6
PORTAB_PA7:         equ    15                                        ; Port A Bit 7
; bit position masks
mPORTAB_PB0:        equ    %00000001
mPORTAB_PB1:        equ    %00000010
mPORTAB_PB2:        equ    %00000100
mPORTAB_PB3:        equ    %00001000
mPORTAB_PB4:        equ    %00010000
mPORTAB_PB5:        equ    %00100000
mPORTAB_PB6:        equ    %01000000
mPORTAB_PB7:        equ    %10000000
mPORTAB_PA0:        equ    %100000000
mPORTAB_PA1:        equ    %1000000000
mPORTAB_PA2:        equ    %10000000000
mPORTAB_PA3:        equ    %100000000000
mPORTAB_PA4:        equ    %1000000000000
mPORTAB_PA5:        equ    %10000000000000
mPORTAB_PA6:        equ    %100000000000000
mPORTAB_PA7:        equ    %1000000000000000


;*** PORTA - Port A Data Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_PA0:          equ    0                                         ; Port A Bit 0
PORTA_PA1:          equ    1                                         ; Port A Bit 1
PORTA_PA2:          equ    2                                         ; Port A Bit 2
PORTA_PA3:          equ    3                                         ; Port A Bit 3
PORTA_PA4:          equ    4                                         ; Port A Bit 4
PORTA_PA5:          equ    5                                         ; Port A Bit 5
PORTA_PA6:          equ    6                                         ; Port A Bit 6
PORTA_PA7:          equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_PA0:         equ    %00000001
mPORTA_PA1:         equ    %00000010
mPORTA_PA2:         equ    %00000100
mPORTA_PA3:         equ    %00001000
mPORTA_PA4:         equ    %00010000
mPORTA_PA5:         equ    %00100000
mPORTA_PA6:         equ    %01000000
mPORTA_PA7:         equ    %10000000


;*** PORTB - Port B Data Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Data Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_PB0:          equ    0                                         ; Port B Bit 0
PORTB_PB1:          equ    1                                         ; Port B Bit 1
PORTB_PB2:          equ    2                                         ; Port B Bit 2
PORTB_PB3:          equ    3                                         ; Port B Bit 3
PORTB_PB4:          equ    4                                         ; Port B Bit 4
PORTB_PB5:          equ    5                                         ; Port B Bit 5
PORTB_PB6:          equ    6                                         ; Port B Bit 6
PORTB_PB7:          equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_PB0:         equ    %00000001
mPORTB_PB1:         equ    %00000010
mPORTB_PB2:         equ    %00000100
mPORTB_PB3:         equ    %00001000
mPORTB_PB4:         equ    %00010000
mPORTB_PB5:         equ    %00100000
mPORTB_PB6:         equ    %01000000
mPORTB_PB7:         equ    %10000000


;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_DDRB0:        equ    0                                         ; Data Direction Port B Bit 0
DDRAB_DDRB1:        equ    1                                         ; Data Direction Port B Bit 1
DDRAB_DDRB2:        equ    2                                         ; Data Direction Port B Bit 2
DDRAB_DDRB3:        equ    3                                         ; Data Direction Port B Bit 3
DDRAB_DDRB4:        equ    4                                         ; Data Direction Port B Bit 4
DDRAB_DDRB5:        equ    5                                         ; Data Direction Port B Bit 5
DDRAB_DDRB6:        equ    6                                         ; Data Direction Port B Bit 6
DDRAB_DDRB7:        equ    7                                         ; Data Direction Port B Bit 7
DDRAB_DDRA0:        equ    8                                         ; Data Direction Port A Bit 0
DDRAB_DDRA1:        equ    9                                         ; Data Direction Port A Bit 1
DDRAB_DDRA2:        equ    10                                        ; Data Direction Port A Bit 2
DDRAB_DDRA3:        equ    11                                        ; Data Direction Port A Bit 3
DDRAB_DDRA4:        equ    12                                        ; Data Direction Port A Bit 4
DDRAB_DDRA5:        equ    13                                        ; Data Direction Port A Bit 5
DDRAB_DDRA6:        equ    14                                        ; Data Direction Port A Bit 6
DDRAB_DDRA7:        equ    15                                        ; Data Direction Port A Bit 7
; bit position masks
mDDRAB_DDRB0:       equ    %00000001
mDDRAB_DDRB1:       equ    %00000010
mDDRAB_DDRB2:       equ    %00000100
mDDRAB_DDRB3:       equ    %00001000
mDDRAB_DDRB4:       equ    %00010000
mDDRAB_DDRB5:       equ    %00100000
mDDRAB_DDRB6:       equ    %01000000
mDDRAB_DDRB7:       equ    %10000000
mDDRAB_DDRA0:       equ    %100000000
mDDRAB_DDRA1:       equ    %1000000000
mDDRAB_DDRA2:       equ    %10000000000
mDDRAB_DDRA3:       equ    %100000000000
mDDRAB_DDRA4:       equ    %1000000000000
mDDRAB_DDRA5:       equ    %10000000000000
mDDRAB_DDRA6:       equ    %100000000000000
mDDRAB_DDRA7:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Port A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Port A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Port A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Port A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Port A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Port A Bit 5
DDRA_DDRA6:         equ    6                                         ; Data Direction Port A Bit 6
DDRA_DDRA7:         equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000
mDDRA_DDRA6:        equ    %01000000
mDDRA_DDRA7:        equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_DDRB0:         equ    0                                         ; Data Direction Port B Bit 0
DDRB_DDRB1:         equ    1                                         ; Data Direction Port B Bit 1
DDRB_DDRB2:         equ    2                                         ; Data Direction Port B Bit 2
DDRB_DDRB3:         equ    3                                         ; Data Direction Port B Bit 3
DDRB_DDRB4:         equ    4                                         ; Data Direction Port B Bit 4
DDRB_DDRB5:         equ    5                                         ; Data Direction Port B Bit 5
DDRB_DDRB6:         equ    6                                         ; Data Direction Port B Bit 6
DDRB_DDRB7:         equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_DDRB0:        equ    %00000001
mDDRB_DDRB1:        equ    %00000010
mDDRB_DDRB2:        equ    %00000100
mDDRB_DDRB3:        equ    %00001000
mDDRB_DDRB4:        equ    %00010000
mDDRB_DDRB5:        equ    %00100000
mDDRB_DDRB6:        equ    %01000000
mDDRB_DDRB7:        equ    %10000000


;*** PORTCD - Port CD Data Register; 0x00000004 ***
PORTCD:             equ    $00000004                                ;*** PORTCD - Port CD Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTCD_PD0:         equ    0                                         ; Port D Bit 0
PORTCD_PD1:         equ    1                                         ; Port D Bit 1
PORTCD_PD2:         equ    2                                         ; Port D Bit 2
PORTCD_PD3:         equ    3                                         ; Port D Bit 3
PORTCD_PD4:         equ    4                                         ; Port D Bit 4
PORTCD_PD5:         equ    5                                         ; Port D Bit 5
PORTCD_PD6:         equ    6                                         ; Port D Bit 6
PORTCD_PD7:         equ    7                                         ; Port D Bit 7
PORTCD_PC0:         equ    8                                         ; Port C Bit 0
PORTCD_PC1:         equ    9                                         ; Port C Bit 1
PORTCD_PC2:         equ    10                                        ; Port C Bit 2
PORTCD_PC3:         equ    11                                        ; Port C Bit 3
PORTCD_PC4:         equ    12                                        ; Port C Bit 4
PORTCD_PC5:         equ    13                                        ; Port C Bit 5
PORTCD_PC6:         equ    14                                        ; Port C Bit 6
PORTCD_PC7:         equ    15                                        ; Port C Bit 7
; bit position masks
mPORTCD_PD0:        equ    %00000001
mPORTCD_PD1:        equ    %00000010
mPORTCD_PD2:        equ    %00000100
mPORTCD_PD3:        equ    %00001000
mPORTCD_PD4:        equ    %00010000
mPORTCD_PD5:        equ    %00100000
mPORTCD_PD6:        equ    %01000000
mPORTCD_PD7:        equ    %10000000
mPORTCD_PC0:        equ    %100000000
mPORTCD_PC1:        equ    %1000000000
mPORTCD_PC2:        equ    %10000000000
mPORTCD_PC3:        equ    %100000000000
mPORTCD_PC4:        equ    %1000000000000
mPORTCD_PC5:        equ    %10000000000000
mPORTCD_PC6:        equ    %100000000000000
mPORTCD_PC7:        equ    %1000000000000000


;*** PORTC - Port C Data Register; 0x00000004 ***
PORTC:              equ    $00000004                                ;*** PORTC - Port C Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTC_PC0:          equ    0                                         ; Port C Bit 0
PORTC_PC1:          equ    1                                         ; Port C Bit 1
PORTC_PC2:          equ    2                                         ; Port C Bit 2
PORTC_PC3:          equ    3                                         ; Port C Bit 3
PORTC_PC4:          equ    4                                         ; Port C Bit 4
PORTC_PC5:          equ    5                                         ; Port C Bit 5
PORTC_PC6:          equ    6                                         ; Port C Bit 6
PORTC_PC7:          equ    7                                         ; Port C Bit 7
; bit position masks
mPORTC_PC0:         equ    %00000001
mPORTC_PC1:         equ    %00000010
mPORTC_PC2:         equ    %00000100
mPORTC_PC3:         equ    %00001000
mPORTC_PC4:         equ    %00010000
mPORTC_PC5:         equ    %00100000
mPORTC_PC6:         equ    %01000000
mPORTC_PC7:         equ    %10000000


;*** PORTD - Port D Data Register; 0x00000005 ***
PORTD:              equ    $00000005                                ;*** PORTD - Port D Data Register; 0x00000005 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTD_PD0:          equ    0                                         ; Port D Bit 0
PORTD_PD1:          equ    1                                         ; Port D Bit 1
PORTD_PD2:          equ    2                                         ; Port D Bit 2
PORTD_PD3:          equ    3                                         ; Port D Bit 3
PORTD_PD4:          equ    4                                         ; Port D Bit 4
PORTD_PD5:          equ    5                                         ; Port D Bit 5
PORTD_PD6:          equ    6                                         ; Port D Bit 6
PORTD_PD7:          equ    7                                         ; Port D Bit 7
; bit position masks
mPORTD_PD0:         equ    %00000001
mPORTD_PD1:         equ    %00000010
mPORTD_PD2:         equ    %00000100
mPORTD_PD3:         equ    %00001000
mPORTD_PD4:         equ    %00010000
mPORTD_PD5:         equ    %00100000
mPORTD_PD6:         equ    %01000000
mPORTD_PD7:         equ    %10000000


;*** DDRCD - Port CD Data Direction Register; 0x00000006 ***
DDRCD:              equ    $00000006                                ;*** DDRCD - Port CD Data Direction Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRCD_DDRD0:        equ    0                                         ; Data Direction Port D Bit 0
DDRCD_DDRD1:        equ    1                                         ; Data Direction Port D Bit 1
DDRCD_DDRD2:        equ    2                                         ; Data Direction Port D Bit 2
DDRCD_DDRD3:        equ    3                                         ; Data Direction Port D Bit 3
DDRCD_DDRD4:        equ    4                                         ; Data Direction Port D Bit 4
DDRCD_DDRD5:        equ    5                                         ; Data Direction Port D Bit 5
DDRCD_DDRD6:        equ    6                                         ; Data Direction Port D Bit 6
DDRCD_DDRD7:        equ    7                                         ; Data Direction Port D Bit 7
DDRCD_DDRC0:        equ    8                                         ; Data Direction Port C Bit 0
DDRCD_DDRC1:        equ    9                                         ; Data Direction Port C Bit 1
DDRCD_DDRC2:        equ    10                                        ; Data Direction Port C Bit 2
DDRCD_DDRC3:        equ    11                                        ; Data Direction Port C Bit 3
DDRCD_DDRC4:        equ    12                                        ; Data Direction Port C Bit 4
DDRCD_DDRC5:        equ    13                                        ; Data Direction Port C Bit 5
DDRCD_DDRC6:        equ    14                                        ; Data Direction Port C Bit 6
DDRCD_DDRC7:        equ    15                                        ; Data Direction Port C Bit 7
; bit position masks
mDDRCD_DDRD0:       equ    %00000001
mDDRCD_DDRD1:       equ    %00000010
mDDRCD_DDRD2:       equ    %00000100
mDDRCD_DDRD3:       equ    %00001000
mDDRCD_DDRD4:       equ    %00010000
mDDRCD_DDRD5:       equ    %00100000
mDDRCD_DDRD6:       equ    %01000000
mDDRCD_DDRD7:       equ    %10000000
mDDRCD_DDRC0:       equ    %100000000
mDDRCD_DDRC1:       equ    %1000000000
mDDRCD_DDRC2:       equ    %10000000000
mDDRCD_DDRC3:       equ    %100000000000
mDDRCD_DDRC4:       equ    %1000000000000
mDDRCD_DDRC5:       equ    %10000000000000
mDDRCD_DDRC6:       equ    %100000000000000
mDDRCD_DDRC7:       equ    %1000000000000000


;*** DDRC - Port C Data Direction Register; 0x00000006 ***
DDRC:               equ    $00000006                                ;*** DDRC - Port C Data Direction Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRC_DDRC0:         equ    0                                         ; Data Direction Port C Bit 0
DDRC_DDRC1:         equ    1                                         ; Data Direction Port C Bit 1
DDRC_DDRC2:         equ    2                                         ; Data Direction Port C Bit 2
DDRC_DDRC3:         equ    3                                         ; Data Direction Port C Bit 3
DDRC_DDRC4:         equ    4                                         ; Data Direction Port C Bit 4
DDRC_DDRC5:         equ    5                                         ; Data Direction Port C Bit 5
DDRC_DDRC6:         equ    6                                         ; Data Direction Port C Bit 6
DDRC_DDRC7:         equ    7                                         ; Data Direction Port C Bit 7
; bit position masks
mDDRC_DDRC0:        equ    %00000001
mDDRC_DDRC1:        equ    %00000010
mDDRC_DDRC2:        equ    %00000100
mDDRC_DDRC3:        equ    %00001000
mDDRC_DDRC4:        equ    %00010000
mDDRC_DDRC5:        equ    %00100000
mDDRC_DDRC6:        equ    %01000000
mDDRC_DDRC7:        equ    %10000000


;*** DDRD - Port D Data Direction Register; 0x00000007 ***
DDRD:               equ    $00000007                                ;*** DDRD - Port D Data Direction Register; 0x00000007 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRD_DDRD0:         equ    0                                         ; Data Direction Port D Bit 0
DDRD_DDRD1:         equ    1                                         ; Data Direction Port D Bit 1
DDRD_DDRD2:         equ    2                                         ; Data Direction Port D Bit 2
DDRD_DDRD3:         equ    3                                         ; Data Direction Port D Bit 3
DDRD_DDRD4:         equ    4                                         ; Data Direction Port D Bit 4
DDRD_DDRD5:         equ    5                                         ; Data Direction Port D Bit 5
DDRD_DDRD6:         equ    6                                         ; Data Direction Port D Bit 6
DDRD_DDRD7:         equ    7                                         ; Data Direction Port D Bit 7
; bit position masks
mDDRD_DDRD0:        equ    %00000001
mDDRD_DDRD1:        equ    %00000010
mDDRD_DDRD2:        equ    %00000100
mDDRD_DDRD3:        equ    %00001000
mDDRD_DDRD4:        equ    %00010000
mDDRD_DDRD5:        equ    %00100000
mDDRD_DDRD6:        equ    %01000000
mDDRD_DDRD7:        equ    %10000000


;*** PORTE - Port E Data Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Data Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_PE0:          equ    0                                         ; Port E Bit 0
PORTE_PE1:          equ    1                                         ; Port E Bit 1
PORTE_PE2:          equ    2                                         ; Port E Bit 2
PORTE_PE3:          equ    3                                         ; Port E Bit 3
PORTE_PE4:          equ    4                                         ; Port E Bit 4
PORTE_PE5:          equ    5                                         ; Port E Bit 5
PORTE_PE6:          equ    6                                         ; Port E Bit 6
PORTE_PE7:          equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_PE0:         equ    %00000001
mPORTE_PE1:         equ    %00000010
mPORTE_PE2:         equ    %00000100
mPORTE_PE3:         equ    %00001000
mPORTE_PE4:         equ    %00010000
mPORTE_PE5:         equ    %00100000
mPORTE_PE6:         equ    %01000000
mPORTE_PE7:         equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_DDRE2:         equ    2                                         ; Data Direction Port E Bit 2
DDRE_DDRE3:         equ    3                                         ; Data Direction Port E Bit 3
DDRE_DDRE4:         equ    4                                         ; Data Direction Port E Bit 4
DDRE_DDRE5:         equ    5                                         ; Data Direction Port E Bit 5
DDRE_DDRE6:         equ    6                                         ; Data Direction Port E Bit 6
DDRE_DDRE7:         equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_DDRE2:        equ    %00000100
mDDRE_DDRE3:        equ    %00001000
mDDRE_DDRE4:        equ    %00010000
mDDRE_DDRE5:        equ    %00100000
mDDRE_DDRE6:        equ    %01000000
mDDRE_DDRE7:        equ    %10000000


;*** MMCCTL0 - MMC Control Register; 0x0000000A ***
MMCCTL0:            equ    $0000000A                                ;*** MMCCTL0 - MMC Control Register; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL0_CS0E0:      equ    0                                         ; Chip Select 0 Enables Bit 0
MMCCTL0_CS0E1:      equ    1                                         ; Chip Select 0 Enables Bit 1
MMCCTL0_CS1E0:      equ    2                                         ; Chip Select 1 Enables Bit 0
MMCCTL0_CS1E1:      equ    3                                         ; Chip Select 1 Enables Bit 1
MMCCTL0_CS2E0:      equ    4                                         ; Chip Select 2 Enables Bit 0
MMCCTL0_CS2E1:      equ    5                                         ; Chip Select 2 Enables Bit 1
MMCCTL0_CS3E0:      equ    6                                         ; Chip Select 3 Enables Bit 0
MMCCTL0_CS3E1:      equ    7                                         ; Chip Select 3 Enables Bit 1
; bit position masks
mMMCCTL0_CS0E0:     equ    %00000001
mMMCCTL0_CS0E1:     equ    %00000010
mMMCCTL0_CS1E0:     equ    %00000100
mMMCCTL0_CS1E1:     equ    %00001000
mMMCCTL0_CS2E0:     equ    %00010000
mMMCCTL0_CS2E1:     equ    %00100000
mMMCCTL0_CS3E0:     equ    %01000000
mMMCCTL0_CS3E1:     equ    %10000000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODA:          equ    5                                         ; Mode Select Bit
MODE_MODB:          equ    6                                         ; Mode Select Bit
MODE_MODC:          equ    7                                         ; Mode Select Bit
; bit position masks
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-up Port B Enable
PUCR_PUPCE:         equ    2                                         ; Pull-up Port C Enable
PUCR_PUPDE:         equ    3                                         ; Pull-up Port D Enable
PUCR_PUPEE:         equ    4                                         ; Pull-up Port E Enable
PUCR_BKPUE:         equ    6                                         ; BKGD and VREGEN Pin Pull-up Enable
PUCR_PUPKE:         equ    7                                         ; Pull-up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPCE:        equ    %00000100
mPUCR_PUPDE:        equ    %00001000
mPUCR_PUPEE:        equ    %00010000
mPUCR_BKPUE:        equ    %01000000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive Register; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPC:         equ    2                                         ; Reduced Drive of Port C
RDRIV_RDPD:         equ    3                                         ; Reduced Drive of Port D
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPC:        equ    %00000100
mRDRIV_RDPD:        equ    %00001000
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***
EBICTL0:            equ    $0000000E                                ;*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL0_ASIZ0:      equ    0                                         ; External Address Bus Size Bit 0
EBICTL0_ASIZ1:      equ    1                                         ; External Address Bus Size Bit 1
EBICTL0_ASIZ2:      equ    2                                         ; External Address Bus Size Bit 2
EBICTL0_ASIZ3:      equ    3                                         ; External Address Bus Size Bit 3
EBICTL0_ASIZ4:      equ    4                                         ; External Address Bus Size Bit 4
EBICTL0_HDBE:       equ    5                                         ; High Data Byte Enable
EBICTL0_ITHRS:      equ    7                                         ; Reduced Input Threshold
; bit position masks
mEBICTL0_ASIZ0:     equ    %00000001
mEBICTL0_ASIZ1:     equ    %00000010
mEBICTL0_ASIZ2:     equ    %00000100
mEBICTL0_ASIZ3:     equ    %00001000
mEBICTL0_ASIZ4:     equ    %00010000
mEBICTL0_HDBE:      equ    %00100000
mEBICTL0_ITHRS:     equ    %10000000


;*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***
EBICTL1:            equ    $0000000F                                ;*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL1_EXSTR00:    equ    0                                         ; External Access Stretch Option 0 Bit 0
EBICTL1_EXSTR01:    equ    1                                         ; External Access Stretch Option 0 Bit 1
EBICTL1_EXSTR02:    equ    2                                         ; External Access Stretch Option 0 Bit 2
EBICTL1_EXSTR10:    equ    4                                         ; External Access Stretch Option 2 Bit 0
EBICTL1_EXSTR11:    equ    5                                         ; External Access Stretch Option 2 Bit 1
EBICTL1_EXSTR12:    equ    6                                         ; External Access Stretch Option 2 Bit 2
; bit position masks
mEBICTL1_EXSTR00:   equ    %00000001
mEBICTL1_EXSTR01:   equ    %00000010
mEBICTL1_EXSTR02:   equ    %00000100
mEBICTL1_EXSTR10:   equ    %00010000
mEBICTL1_EXSTR11:   equ    %00100000
mEBICTL1_EXSTR12:   equ    %01000000


;*** GPAGE - Global Page Index Register; 0x00000010 ***
GPAGE:              equ    $00000010                                ;*** GPAGE - Global Page Index Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
GPAGE_GP0:          equ    0                                         ; Global Page Index Bit 0
GPAGE_GP1:          equ    1                                         ; Global Page Index Bit 1
GPAGE_GP2:          equ    2                                         ; Global Page Index Bit 2
GPAGE_GP3:          equ    3                                         ; Global Page Index Bit 3
GPAGE_GP4:          equ    4                                         ; Global Page Index Bit 4
GPAGE_GP5:          equ    5                                         ; Global Page Index Bit 5
GPAGE_GP6:          equ    6                                         ; Global Page Index Bit 6
; bit position masks
mGPAGE_GP0:         equ    %00000001
mGPAGE_GP1:         equ    %00000010
mGPAGE_GP2:         equ    %00000100
mGPAGE_GP3:         equ    %00001000
mGPAGE_GP4:         equ    %00010000
mGPAGE_GP5:         equ    %00100000
mGPAGE_GP6:         equ    %01000000


;*** DIRECT - Direct Page Register; 0x00000011 ***
DIRECT:             equ    $00000011                                ;*** DIRECT - Direct Page Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Index Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Index Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Index Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Index Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Index Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Index Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Index Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Index Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
MMCCTL1:            equ    $00000013                                ;*** MMCCTL1 - MMC Control Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL1_ROMON:      equ    0                                         ; Enable FLASH or ROM in the memory map
MMCCTL1_ROMHM:      equ    1                                         ; FLASH or ROM only in higher Half of Memory Map
MMCCTL1_EROMON:     equ    2                                         ; Enables emulated Flash or ROM memory in the memory map
MMCCTL1_RAMHM:      equ    3                                         ; RAM only in higher Half of the memory map
MMCCTL1_PGMIFRON:   equ    4                                         ; Program Flash Information Row (IFR) visible in the global memory map
MMCCTL1_EEEIFRON:   equ    5                                         ; EEE IFR visible in the memory map
MMCCTL1_TGMRAMON:   equ    7                                         ; EEE Tag RAM and FTM SCRATCH RAM visible in the memory map
; bit position masks
mMMCCTL1_ROMON:     equ    %00000001
mMMCCTL1_ROMHM:     equ    %00000010
mMMCCTL1_EROMON:    equ    %00000100
mMMCCTL1_RAMHM:     equ    %00001000
mMMCCTL1_PGMIFRON:  equ    %00010000
mMMCCTL1_EEEIFRON:  equ    %00100000
mMMCCTL1_TGMRAMON:  equ    %10000000


;*** PPAGE - Program Page Index Register; 0x00000015 ***
PPAGE:              equ    $00000015                                ;*** PPAGE - Program Page Index Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
PPAGE_PIX4:         equ    4                                         ; Program Page Index Bit 4
PPAGE_PIX5:         equ    5                                         ; Program Page Index Bit 5
PPAGE_PIX6:         equ    6                                         ; Program Page Index Bit 6
PPAGE_PIX7:         equ    7                                         ; Program Page Index Bit 7
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000
mPPAGE_PIX6:        equ    %01000000
mPPAGE_PIX7:        equ    %10000000


;*** RPAGE - RAM Page Index Register; 0x00000016 ***
RPAGE:              equ    $00000016                                ;*** RPAGE - RAM Page Index Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RPAGE_RP0:          equ    0                                         ; RAM Page Index Bit 0
RPAGE_RP1:          equ    1                                         ; RAM Page Index Bit 1
RPAGE_RP2:          equ    2                                         ; RAM Page Index Bit 2
RPAGE_RP3:          equ    3                                         ; RAM Page Index Bit 3
RPAGE_RP4:          equ    4                                         ; RAM Page Index Bit 4
RPAGE_RP5:          equ    5                                         ; RAM Page Index Bit 5
RPAGE_RP6:          equ    6                                         ; RAM Page Index Bit 6
RPAGE_RP7:          equ    7                                         ; RAM Page Index Bit 7
; bit position masks
mRPAGE_RP0:         equ    %00000001
mRPAGE_RP1:         equ    %00000010
mRPAGE_RP2:         equ    %00000100
mRPAGE_RP3:         equ    %00001000
mRPAGE_RP4:         equ    %00010000
mRPAGE_RP5:         equ    %00100000
mRPAGE_RP6:         equ    %01000000
mRPAGE_RP7:         equ    %10000000


;*** EPAGE - Data FLASH Page Index Register; 0x00000017 ***
EPAGE:              equ    $00000017                                ;*** EPAGE - Data FLASH Page Index Register; 0x00000017 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPAGE_EP0:          equ    0                                         ; Data FLASH Page Index Bit 0
EPAGE_EP1:          equ    1                                         ; Data FLASH Page Index Bit 1
EPAGE_EP2:          equ    2                                         ; Data FLASH Page Index Bit 2
EPAGE_EP3:          equ    3                                         ; Data FLASH Page Index Bit 3
EPAGE_EP4:          equ    4                                         ; Data FLASH Page Index Bit 4
EPAGE_EP5:          equ    5                                         ; Data FLASH Page Index Bit 5
EPAGE_EP6:          equ    6                                         ; Data FLASH Page Index Bit 6
EPAGE_EP7:          equ    7                                         ; Data FLASH Page Index Bit 7
; bit position masks
mEPAGE_EP0:         equ    %00000001
mEPAGE_EP1:         equ    %00000010
mEPAGE_EP2:         equ    %00000100
mEPAGE_EP3:         equ    %00001000
mEPAGE_EP4:         equ    %00010000
mEPAGE_EP5:         equ    %00100000
mEPAGE_EP6:         equ    %01000000
mEPAGE_EP7:         equ    %10000000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
ECLKCTL:            equ    $0000001C                                ;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKCTL_EDIV0:      equ    0                                         ; Free-running ECLK Divider, bit 0
ECLKCTL_EDIV1:      equ    1                                         ; Free-running ECLK Divider, bit 1
ECLKCTL_EDIV2:      equ    2                                         ; Free-running ECLK Divider, bit 2
ECLKCTL_EDIV3:      equ    3                                         ; Free-running ECLK Divider, bit 3
ECLKCTL_EDIV4:      equ    4                                         ; Free-running ECLK Divider, bit 4
ECLKCTL_DIV16:      equ    5                                         ; Free-running ECLK predivider
ECLKCTL_NCLKX2:     equ    6                                         ; No ECLKX2
ECLKCTL_NECLK:      equ    7                                         ; No ECLK
; bit position masks
mECLKCTL_EDIV0:     equ    %00000001
mECLKCTL_EDIV1:     equ    %00000010
mECLKCTL_EDIV2:     equ    %00000100
mECLKCTL_EDIV3:     equ    %00001000
mECLKCTL_EDIV4:     equ    %00010000
mECLKCTL_DIV16:     equ    %00100000
mECLKCTL_NCLKX2:    equ    %01000000
mECLKCTL_NECLK:     equ    %10000000


;*** IRQCR - Interrupt Control Register; 0x0000001E ***
IRQCR:              equ    $0000001E                                ;*** IRQCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQCR_IRQEN:        equ    6                                         ; External IRQ Enable
IRQCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mIRQCR_IRQEN:       equ    %01000000
mIRQCR_IRQE:        equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV:        equ    0                                         ; Comparator Register Visibility Bits
DBGC1_DBGBRK:       equ    2                                         ; S12XDBG Breakpoint Enable Bits
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_XGSBPE:       equ    5                                         ; XGATE S/W Breakpoint Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV:       equ    %00000011
mDBGC1_DBGBRK:      equ    %00001100
mDBGC1_BDM:         equ    %00010000
mDBGC1_XGSBPE:      equ    %00100000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bits
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_EXTF:         equ    6                                         ; External Tag Hit Flag
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_EXTF:        equ    %01000000
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bits
DBGTCR_TRCMOD:      equ    2                                         ; Trace Mode Bits
DBGTCR_TRANGE:      equ    4                                         ; Trace Range Bits
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bits
; bit position masks
mDBGTCR_TALIGN:     equ    %00000011
mDBGTCR_TRCMOD:     equ    %00001100
mDBGTCR_TRANGE:     equ    %00110000
mDBGTCR_TSOURCE:    equ    %11000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM:         equ    0                                         ; A and B Comparator Match Control
DBGC2_CDCM:         equ    2                                         ; C and D Comparator Match Control
; bit position masks
mDBGC2_ABCM:        equ    %00000011
mDBGC2_CDCM:        equ    %00001100


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Trace Buffer Data Bits
DBGTB_BIT1:         equ    1                                         ; Trace Buffer Data Bit 1
DBGTB_BIT2:         equ    2                                         ; Trace Buffer Data Bit 2
DBGTB_BIT3:         equ    3                                         ; Trace Buffer Data Bit 3
DBGTB_BIT4:         equ    4                                         ; Trace Buffer Data Bit 4
DBGTB_BIT5:         equ    5                                         ; Trace Buffer Data Bit 5
DBGTB_BIT6:         equ    6                                         ; Trace Buffer Data Bit 6
DBGTB_BIT7:         equ    7                                         ; Trace Buffer Data Bit 7
DBGTB_BIT8:         equ    8                                         ; Trace Buffer Data Bit 8
DBGTB_BIT9:         equ    9                                         ; Trace Buffer Data Bit 9
DBGTB_BIT10:        equ    10                                        ; Trace Buffer Data Bit 10
DBGTB_BIT11:        equ    11                                        ; Trace Buffer Data Bit 11
DBGTB_BIT12:        equ    12                                        ; Trace Buffer Data Bit 12
DBGTB_BIT13:        equ    13                                        ; Trace Buffer Data Bit 13
DBGTB_BIT14:        equ    14                                        ; Trace Buffer Data Bit 14
DBGTB_BIT15:        equ    15                                        ; Trace Buffer Data Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Trace Buffer Data Bits
DBGTBH_BIT9:        equ    1                                         ; Trace Buffer Data Bit 9
DBGTBH_BIT10:       equ    2                                         ; Trace Buffer Data Bit 10
DBGTBH_BIT11:       equ    3                                         ; Trace Buffer Data Bit 11
DBGTBH_BIT12:       equ    4                                         ; Trace Buffer Data Bit 12
DBGTBH_BIT13:       equ    5                                         ; Trace Buffer Data Bit 13
DBGTBH_BIT14:       equ    6                                         ; Trace Buffer Data Bit 14
DBGTBH_BIT15:       equ    7                                         ; Trace Buffer Data Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Trace Buffer Data Bits
DBGTBL_BIT1:        equ    1                                         ; Trace Buffer Data Bit 1
DBGTBL_BIT2:        equ    2                                         ; Trace Buffer Data Bit 2
DBGTBL_BIT3:        equ    3                                         ; Trace Buffer Data Bit 3
DBGTBL_BIT4:        equ    4                                         ; Trace Buffer Data Bit 4
DBGTBL_BIT5:        equ    5                                         ; Trace Buffer Data Bit 5
DBGTBL_BIT6:        equ    6                                         ; Trace Buffer Data Bit 6
DBGTBL_BIT7:        equ    7                                         ; Trace Buffer Data Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT:         equ    0                                         ; Count Value
; bit position masks
mDBGCNT_CNT:        equ    %01111111


;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; State X Sequencer Next State Selection Bit 0
DBGSCRX_SC1:        equ    1                                         ; State X Sequencer Next State Selection Bit 1
DBGSCRX_SC2:        equ    2                                         ; State X Sequencer Next State Selection Bit 2
DBGSCRX_SC3:        equ    3                                         ; State X Sequencer Next State Selection Bit 3
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100
mDBGSCRX_SC3:       equ    %00001000


;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; Debug Match Flag Bit 0
DBGMFR_MC1:         equ    1                                         ; Debug Match Flag Bit 1
DBGMFR_MC2:         equ    2                                         ; Debug Match Flag Bit 2
DBGMFR_MC3:         equ    3                                         ; Debug Match Flag Bit 3
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100
mDBGMFR_MC3:        equ    %00001000


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_SRC:        equ    1                                         ; Determines mapping of comparator to CPU or XGATE
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_BRK:        equ    4                                         ; Break
DBGXCTL_TAG:        equ    5                                         ; Tag Select
DBGXCTL_NDB_SZ:     equ    6                                         ; Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D)
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_SRC:       equ    %00000010
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_BRK:       equ    %00010000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_NDB_SZ:    equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bits
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
DBGXAH_BIT18:       equ    2                                         ; Comparator Address High Compare Bit 18
DBGXAH_BIT19:       equ    3                                         ; Comparator Address High Compare Bit 19
DBGXAH_BIT20:       equ    4                                         ; Comparator Address High Compare Bit 20
DBGXAH_BIT21:       equ    5                                         ; Comparator Address High Compare Bit 21
DBGXAH_BIT22:       equ    6                                         ; Comparator Address High Compare Bit 22
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010
mDBGXAH_BIT18:      equ    %00000100
mDBGXAH_BIT19:      equ    %00001000
mDBGXAH_BIT20:      equ    %00010000
mDBGXAH_BIT21:      equ    %00100000
mDBGXAH_BIT22:      equ    %01000000


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bits
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bits
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***
DBGXDH:             equ    $0000002C                                ;*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDH_BIT8:        equ    0                                         ; Comparator Data High Compare Bit 8
DBGXDH_BIT9:        equ    1                                         ; Comparator Data High Compare Bit 9
DBGXDH_BIT10:       equ    2                                         ; Comparator Data High Compare Bit 10
DBGXDH_BIT11:       equ    3                                         ; Comparator Data High Compare Bit 11
DBGXDH_BIT12:       equ    4                                         ; Comparator Data High Compare Bit 12
DBGXDH_BIT13:       equ    5                                         ; Comparator Data High Compare Bit 13
DBGXDH_BIT14:       equ    6                                         ; Comparator Data High Compare Bit 14
DBGXDH_BIT15:       equ    7                                         ; Comparator Data High Compare Bit 15
; bit position masks
mDBGXDH_BIT8:       equ    %00000001
mDBGXDH_BIT9:       equ    %00000010
mDBGXDH_BIT10:      equ    %00000100
mDBGXDH_BIT11:      equ    %00001000
mDBGXDH_BIT12:      equ    %00010000
mDBGXDH_BIT13:      equ    %00100000
mDBGXDH_BIT14:      equ    %01000000
mDBGXDH_BIT15:      equ    %10000000


;*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***
DBGXDL:             equ    $0000002D                                ;*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDL_BIT0:        equ    0                                         ; Comparator Data Low Compare Bit 0
DBGXDL_BIT1:        equ    1                                         ; Comparator Data Low Compare Bit 1
DBGXDL_BIT2:        equ    2                                         ; Comparator Data Low Compare Bit 2
DBGXDL_BIT3:        equ    3                                         ; Comparator Data Low Compare Bit 3
DBGXDL_BIT4:        equ    4                                         ; Comparator Data Low Compare Bit 4
DBGXDL_BIT5:        equ    5                                         ; Comparator Data Low Compare Bit 5
DBGXDL_BIT6:        equ    6                                         ; Comparator Data Low Compare Bit 6
DBGXDL_BIT7:        equ    7                                         ; Comparator Data Low Compare Bit 7
; bit position masks
mDBGXDL_BIT0:       equ    %00000001
mDBGXDL_BIT1:       equ    %00000010
mDBGXDL_BIT2:       equ    %00000100
mDBGXDL_BIT3:       equ    %00001000
mDBGXDL_BIT4:       equ    %00010000
mDBGXDL_BIT5:       equ    %00100000
mDBGXDL_BIT6:       equ    %01000000
mDBGXDL_BIT7:       equ    %10000000


;*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGXDHM:            equ    $0000002E                                ;*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGXDHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGXDHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGXDHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGXDHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGXDHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGXDHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGXDHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGXDHM_BIT8:      equ    %00000001
mDBGXDHM_BIT9:      equ    %00000010
mDBGXDHM_BIT10:     equ    %00000100
mDBGXDHM_BIT11:     equ    %00001000
mDBGXDHM_BIT12:     equ    %00010000
mDBGXDHM_BIT13:     equ    %00100000
mDBGXDHM_BIT14:     equ    %01000000
mDBGXDHM_BIT15:     equ    %10000000


;*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGXDLM:            equ    $0000002F                                ;*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDLM_BIT0:       equ    0                                         ; Comparator Data Low Mask Bit 0
DBGXDLM_BIT1:       equ    1                                         ; Comparator Data Low Mask Bit 1
DBGXDLM_BIT2:       equ    2                                         ; Comparator Data Low Mask Bit 2
DBGXDLM_BIT3:       equ    3                                         ; Comparator Data Low Mask Bit 3
DBGXDLM_BIT4:       equ    4                                         ; Comparator Data Low Mask Bit 4
DBGXDLM_BIT5:       equ    5                                         ; Comparator Data Low Mask Bit 5
DBGXDLM_BIT6:       equ    6                                         ; Comparator Data Low Mask Bit 6
DBGXDLM_BIT7:       equ    7                                         ; Comparator Data Low Mask Bit 7
; bit position masks
mDBGXDLM_BIT0:      equ    %00000001
mDBGXDLM_BIT1:      equ    %00000010
mDBGXDLM_BIT2:      equ    %00000100
mDBGXDLM_BIT3:      equ    %00001000
mDBGXDLM_BIT4:      equ    %00010000
mDBGXDLM_BIT5:      equ    %00100000
mDBGXDLM_BIT6:      equ    %01000000
mDBGXDLM_BIT7:      equ    %10000000


;*** PORTK - Port K Data Register; 0x00000032 ***
PORTK:              equ    $00000032                                ;*** PORTK - Port K Data Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTK_PK0:          equ    0                                         ; Port K Bit 0
PORTK_PK1:          equ    1                                         ; Port K Bit 1
PORTK_PK2:          equ    2                                         ; Port K Bit 2
PORTK_PK3:          equ    3                                         ; Port K Bit 3
PORTK_PK4:          equ    4                                         ; Port K Bit 4
PORTK_PK5:          equ    5                                         ; Port K Bit 5
PORTK_PK6:          equ    6                                         ; Port K Bit 6
PORTK_PK7:          equ    7                                         ; Port K Bit 7
; bit position masks
mPORTK_PK0:         equ    %00000001
mPORTK_PK1:         equ    %00000010
mPORTK_PK2:         equ    %00000100
mPORTK_PK3:         equ    %00001000
mPORTK_PK4:         equ    %00010000
mPORTK_PK5:         equ    %00100000
mPORTK_PK6:         equ    %01000000
mPORTK_PK7:         equ    %10000000


;*** DDRK - Port K Data Direction Register; 0x00000033 ***
DDRK:               equ    $00000033                                ;*** DDRK - Port K Data Direction Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRK_DDRK0:         equ    0                                         ; Data Direction Port K Bit 0
DDRK_DDRK1:         equ    1                                         ; Data Direction Port K Bit 1
DDRK_DDRK2:         equ    2                                         ; Data Direction Port K Bit 2
DDRK_DDRK3:         equ    3                                         ; Data Direction Port K Bit 3
DDRK_DDRK4:         equ    4                                         ; Data Direction Port K Bit 4
DDRK_DDRK5:         equ    5                                         ; Data Direction Port K Bit 5
DDRK_DDRK6:         equ    6                                         ; Data Direction Port K Bit 6
DDRK_DDRK7:         equ    7                                         ; Data Direction Port K Bit 7
; bit position masks
mDDRK_DDRK0:        equ    %00000001
mDDRK_DDRK1:        equ    %00000010
mDDRK_DDRK2:        equ    %00000100
mDDRK_DDRK3:        equ    %00001000
mDDRK_DDRK4:        equ    %00010000
mDDRK_DDRK5:        equ    %00100000
mDDRK_DDRK6:        equ    %01000000
mDDRK_DDRK7:        equ    %10000000


;*** SYNR - S12XECRG Synthesizer Register; 0x00000034 ***
SYNR:               equ    $00000034                                ;*** SYNR - S12XECRG Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYNR_SYNDIV0:       equ    0                                         ; Multiplication factor of the IPLL bit 0
SYNR_SYNDIV1:       equ    1                                         ; Multiplication factor of the IPLL bit 1
SYNR_SYNDIV2:       equ    2                                         ; Multiplication factor of the IPLL bit 2
SYNR_SYNDIV3:       equ    3                                         ; Multiplication factor of the IPLL bit 3
SYNR_SYNDIV4:       equ    4                                         ; Multiplication factor of the IPLL bit 4
SYNR_SYNDIV5:       equ    5                                         ; Multiplication factor of the IPLL bit 5
SYNR_VCOFRQ0:       equ    6                                         ; VCO frequency range bit 0
SYNR_VCOFRQ1:       equ    7                                         ; VCO frequency range bit 1
; bit position masks
mSYNR_SYNDIV0:      equ    %00000001
mSYNR_SYNDIV1:      equ    %00000010
mSYNR_SYNDIV2:      equ    %00000100
mSYNR_SYNDIV3:      equ    %00001000
mSYNR_SYNDIV4:      equ    %00010000
mSYNR_SYNDIV5:      equ    %00100000
mSYNR_VCOFRQ0:      equ    %01000000
mSYNR_VCOFRQ1:      equ    %10000000


;*** REFDV - S12XECRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - S12XECRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDIV0:      equ    0                                         ; Finer granularity for the IPLL multiplier steps bit 0
REFDV_REFDIV1:      equ    1                                         ; Finer granularity for the IPLL multiplier steps bit 1
REFDV_REFDIV2:      equ    2                                         ; Finer granularity for the IPLL multiplier steps bit 2
REFDV_REFDIV3:      equ    3                                         ; Finer granularity for the IPLL multiplier steps bit 3
REFDV_REFDIV4:      equ    4                                         ; Finer granularity for the IPLL multiplier steps bit 4
REFDV_REFDIV5:      equ    5                                         ; Finer granularity for the IPLL multiplier steps bit 5
REFDV_REFFRQ0:      equ    6                                         ; IPLL optimal stability and lock time configuration bit 0
REFDV_REFFRQ1:      equ    7                                         ; IPLL optimal stability and lock time configuration bit 1
; bit position masks
mREFDV_REFDIV0:     equ    %00000001
mREFDV_REFDIV1:     equ    %00000010
mREFDV_REFDIV2:     equ    %00000100
mREFDV_REFDIV3:     equ    %00001000
mREFDV_REFDIV4:     equ    %00010000
mREFDV_REFDIV5:     equ    %00100000
mREFDV_REFFRQ0:     equ    %01000000
mREFDV_REFFRQ1:     equ    %10000000


;*** POSTDIV - S12XECRG Post Divider Register; 0x00000036 ***
POSTDIV:            equ    $00000036                                ;*** POSTDIV - S12XECRG Post Divider Register; 0x00000036 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
POSTDIV_POSTDIV0:   equ    0                                         ; Frequency ratio between the VCOCLK and PLLCLK control bit 0
POSTDIV_POSTDIV1:   equ    1                                         ; Frequency ratio between the VCOCLK and PLLCLK control bit 1
POSTDIV_POSTDIV2:   equ    2                                         ; Frequency ratio between the VCOCLK and PLLCLK control bit 2
POSTDIV_POSTDIV3:   equ    3                                         ; Frequency ratio between the VCOCLK and PLLCLK control bit 3
POSTDIV_POSTDIV4:   equ    4                                         ; Frequency ratio between the VCOCLK and PLLCLK control bit 4
; bit position masks
mPOSTDIV_POSTDIV0:  equ    %00000001
mPOSTDIV_POSTDIV1:  equ    %00000010
mPOSTDIV_POSTDIV2:  equ    %00000100
mPOSTDIV_POSTDIV3:  equ    %00001000
mPOSTDIV_POSTDIV4:  equ    %00010000


;*** CRGFLG - S12XECRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - S12XECRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_SCM:         equ    0                                         ; Self Clock Mode Status Bit
CRGFLG_SCMIF:       equ    1                                         ; Self Clock Mode Interrupt Flag
CRGFLG_ILAF:        equ    2                                         ; Illegal Address Reset Flag
CRGFLG_LOCK:        equ    3                                         ; Lock Status Bit
CRGFLG_LOCKIF:      equ    4                                         ; IPLL Lock Interrupt Flag
CRGFLG_LVRF:        equ    5                                         ; Low Voltage Reset Flag
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_SCM:        equ    %00000001
mCRGFLG_SCMIF:      equ    %00000010
mCRGFLG_ILAF:       equ    %00000100
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_LVRF:       equ    %00100000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - S12XECRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - S12XECRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_SCMIE:       equ    1                                         ; Self Clock Mode Interrupt Enable Bit
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable Bit
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable Bit
; bit position masks
mCRGINT_SCMIE:      equ    %00000010
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - S12XECRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - S12XECRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP Stops in Wait Mode Bit
CLKSEL_RTIWAI:      equ    1                                         ; RTI Stops in Wait Mode Bit
CLKSEL_PLLWAI:      equ    3                                         ; PLL Stops in Wait Mode Bit
CLKSEL_XCLKS:       equ    5                                         ; Oscillator Configuration Status Bit
CLKSEL_PSTP:        equ    6                                         ; Pseudo Stop Bit
CLKSEL_PLLSEL:      equ    7                                         ; PLL Select Bit
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_PLLWAI:     equ    %00001000
mCLKSEL_XCLKS:      equ    %00100000
mCLKSEL_PSTP:       equ    %01000000
mCLKSEL_PLLSEL:     equ    %10000000


;*** PLLCTL - S12XECRG IPLL Control Register; 0x0000003A ***
PLLCTL:             equ    $0000003A                                ;*** PLLCTL - S12XECRG IPLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PLLCTL_SCME:        equ    0                                         ; Self Clock Mode Enable Bit
PLLCTL_PCE:         equ    1                                         ; COP Enable During Pseudo Stop Bit
PLLCTL_PRE:         equ    2                                         ; RTI Enable During Pseudo Stop Bit
PLLCTL_FSTWKP:      equ    3                                         ; Fast Wake-up from Full Stop Bit
PLLCTL_FM0:         equ    4                                         ; IPLL Frequency Modulation Enable Bit 0
PLLCTL_FM1:         equ    5                                         ; IPLL Frequency Modulation Enable Bit 1
PLLCTL_PLLON:       equ    6                                         ; Phase Lock Loop On Bit
PLLCTL_CME:         equ    7                                         ; Clock Monitor Enable Bit
; bit position masks
mPLLCTL_SCME:       equ    %00000001
mPLLCTL_PCE:        equ    %00000010
mPLLCTL_PRE:        equ    %00000100
mPLLCTL_FSTWKP:     equ    %00001000
mPLLCTL_FM0:        equ    %00010000
mPLLCTL_FM1:        equ    %00100000
mPLLCTL_PLLON:      equ    %01000000
mPLLCTL_CME:        equ    %10000000


;*** RTICTL - ECRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - ECRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
RTICTL_RTDEC:       equ    7                                         ; Decimal or Binary Divider Select Bit
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000
mRTICTL_RTDEC:      equ    %10000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_WRTMASK:     equ    5                                         ; Write Mask for WCOP
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_WRTMASK:    equ    %00100000
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS0:          equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIOS_IOS1:          equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIOS_IOS2:          equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIOS_IOS3:          equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS0:         equ    %00000001
mTIOS_IOS1:         equ    %00000010
mTIOS_IOS2:         equ    %00000100
mTIOS_IOS3:         equ    %00001000
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC0:         equ    0                                         ; Force Output Compare Action for Channel 0
CFORC_FOC1:         equ    1                                         ; Force Output Compare Action for Channel 1
CFORC_FOC2:         equ    2                                         ; Force Output Compare Action for Channel 2
CFORC_FOC3:         equ    3                                         ; Force Output Compare Action for Channel 3
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC0:        equ    %00000001
mCFORC_FOC1:        equ    %00000010
mCFORC_FOC2:        equ    %00000100
mCFORC_FOC3:        equ    %00001000
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M0:         equ    0                                         ; Output Compare 7 Mask Bit 0
OC7M_OC7M1:         equ    1                                         ; Output Compare 7 Mask Bit 1
OC7M_OC7M2:         equ    2                                         ; Output Compare 7 Mask Bit 2
OC7M_OC7M3:         equ    3                                         ; Output Compare 7 Mask Bit 3
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M0:        equ    %00000001
mOC7M_OC7M1:        equ    %00000010
mOC7M_OC7M2:        equ    %00000100
mOC7M_OC7M3:        equ    %00001000
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_PRNT:         equ    3                                         ; Precision Timer
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_PRNT:        equ    %00001000
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV0:          equ    0                                         ; Toggle On Overflow Bit 0
TTOV_TOV1:          equ    1                                         ; Toggle On Overflow Bit 1
TTOV_TOV2:          equ    2                                         ; Toggle On Overflow Bit 2
TTOV_TOV3:          equ    3                                         ; Toggle On Overflow Bit 3
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV0:         equ    %00000001
mTTOV_TOV1:         equ    %00000010
mTTOV_TOV2:         equ    %00000100
mTTOV_TOV3:         equ    %00001000
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
TCTL2:              equ    $00000049                                ;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL2_OL0:          equ    0                                         ; Output Level Bit 0
TCTL2_OM0:          equ    1                                         ; Output Mode Bit 0
TCTL2_OL1:          equ    2                                         ; Output Lecel Bit 1
TCTL2_OM1:          equ    3                                         ; Output Mode Bit 1
TCTL2_OL2:          equ    4                                         ; Output Level Bit 2
TCTL2_OM2:          equ    5                                         ; Output Mode Bit 2
TCTL2_OL3:          equ    6                                         ; Output Level Bit 3
TCTL2_OM3:          equ    7                                         ; Output Mode Bit 3
; bit position masks
mTCTL2_OL0:         equ    %00000001
mTCTL2_OM0:         equ    %00000010
mTCTL2_OL1:         equ    %00000100
mTCTL2_OM1:         equ    %00001000
mTCTL2_OL2:         equ    %00010000
mTCTL2_OM2:         equ    %00100000
mTCTL2_OL3:         equ    %01000000
mTCTL2_OM3:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
TCTL4:              equ    $0000004B                                ;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL4_EDG0A:        equ    0                                         ; Input Capture Edge Control 0A
TCTL4_EDG0B:        equ    1                                         ; Input Capture Edge Control 0B
TCTL4_EDG1A:        equ    2                                         ; Input Capture Edge Control 1A
TCTL4_EDG1B:        equ    3                                         ; Input Capture Edge Control 1B
TCTL4_EDG2A:        equ    4                                         ; Input Capture Edge Control 2A
TCTL4_EDG2B:        equ    5                                         ; Input Capture Edge Control 2B
TCTL4_EDG3A:        equ    6                                         ; Input Capture Edge Control 3A
TCTL4_EDG3B:        equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTCTL4_EDG0A:       equ    %00000001
mTCTL4_EDG0B:       equ    %00000010
mTCTL4_EDG1A:       equ    %00000100
mTCTL4_EDG1B:       equ    %00001000
mTCTL4_EDG2A:       equ    %00010000
mTCTL4_EDG2B:       equ    %00100000
mTCTL4_EDG3A:       equ    %01000000
mTCTL4_EDG3B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C0I:            equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIE_C1I:            equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIE_C2I:            equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIE_C3I:            equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C0I:           equ    %00000001
mTIE_C1I:           equ    %00000010
mTIE_C2I:           equ    %00000100
mTIE_C3I:           equ    %00001000
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C0F:          equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TFLG1_C1F:          equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TFLG1_C2F:          equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TFLG1_C3F:          equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C0F:         equ    %00000001
mTFLG1_C1F:         equ    %00000010
mTFLG1_C2F:         equ    %00000100
mTFLG1_C3F:         equ    %00001000
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***
TC0:                equ    $00000050                                ;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***


;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***
TC0Hi:              equ    $00000050                                ;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***


;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***
TC0Lo:              equ    $00000051                                ;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***


;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***
TC1:                equ    $00000052                                ;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***


;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***
TC1Hi:              equ    $00000052                                ;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***


;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***
TC1Lo:              equ    $00000053                                ;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***


;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TC2:                equ    $00000054                                ;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TC2Hi:              equ    $00000054                                ;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TC2Lo:              equ    $00000055                                ;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TC3:                equ    $00000056                                ;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TC3Hi:              equ    $00000056                                ;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TC3Lo:              equ    $00000057                                ;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***
PACN32:             equ    $00000062                                ;*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***


;*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***
PACN3:              equ    $00000062                                ;*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***


;*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***
PACN2:              equ    $00000063                                ;*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***


;*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***
PACN10:             equ    $00000064                                ;*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***


;*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***
PACN1:              equ    $00000064                                ;*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***


;*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***
PACN0:              equ    $00000065                                ;*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***


;*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***
MCCTL:              equ    $00000066                                ;*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL_MCPR0:        equ    0                                         ; Modulus Counter Prescaler select 0
MCCTL_MCPR1:        equ    1                                         ; Modulus Counter Prescaler select 1
MCCTL_MCEN:         equ    2                                         ; Modulus Down-Counter Enable
MCCTL_FLMC:         equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MCCTL_ICLAT:        equ    4                                         ; Input Capture Force Latch Action
MCCTL_RDMCL:        equ    5                                         ; Read Modulus Down-Counter Load
MCCTL_MODMC:        equ    6                                         ; Modulus Mode Enable
MCCTL_MCZI:         equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMCCTL_MCPR0:       equ    %00000001
mMCCTL_MCPR1:       equ    %00000010
mMCCTL_MCEN:        equ    %00000100
mMCCTL_FLMC:        equ    %00001000
mMCCTL_ICLAT:       equ    %00010000
mMCCTL_RDMCL:       equ    %00100000
mMCCTL_MODMC:       equ    %01000000
mMCCTL_MCZI:        equ    %10000000


;*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***
MCFLG:              equ    $00000067                                ;*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCFLG_POLF0:        equ    0                                         ; First Input Capture Polarity Status 0
MCFLG_POLF1:        equ    1                                         ; First Input Capture Polarity Status 1
MCFLG_POLF2:        equ    2                                         ; First Input Capture Polarity Status 2
MCFLG_POLF3:        equ    3                                         ; First Input Capture Polarity Status 3
MCFLG_MCZF:         equ    7                                         ; Modulus Counter Underflow Flag
; bit position masks
mMCFLG_POLF0:       equ    %00000001
mMCFLG_POLF1:       equ    %00000010
mMCFLG_POLF2:       equ    %00000100
mMCFLG_POLF3:       equ    %00001000
mMCFLG_MCZF:        equ    %10000000


;*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***
ICPAR:              equ    $00000068                                ;*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICPAR_PA0EN:        equ    0                                         ; 8-Bit Pulse Accumulator 0 Enable
ICPAR_PA1EN:        equ    1                                         ; 8-Bit Pulse Accumulator 1 Enable
ICPAR_PA2EN:        equ    2                                         ; 8-Bit Pulse Accumulator 2 Enable
ICPAR_PA3EN:        equ    3                                         ; 8-Bit Pulse Accumulator 3 Enable
; bit position masks
mICPAR_PA0EN:       equ    %00000001
mICPAR_PA1EN:       equ    %00000010
mICPAR_PA2EN:       equ    %00000100
mICPAR_PA3EN:       equ    %00001000


;*** DLYCT - Delay Counter Control Register; 0x00000069 ***
DLYCT:              equ    $00000069                                ;*** DLYCT - Delay Counter Control Register; 0x00000069 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DLYCT_DLY0:         equ    0                                         ; Delay Counter Select 0
DLYCT_DLY1:         equ    1                                         ; Delay Counter Select 1
DLYCT_DLY2:         equ    2                                         ; Delay Counter Select 2
DLYCT_DLY3:         equ    3                                         ; Delay Counter Select 3
DLYCT_DLY4:         equ    4                                         ; Delay Counter Select 4
DLYCT_DLY5:         equ    5                                         ; Delay Counter Select 5
DLYCT_DLY6:         equ    6                                         ; Delay Counter Select 6
DLYCT_DLY7:         equ    7                                         ; Delay Counter Select 7
; bit position masks
mDLYCT_DLY0:        equ    %00000001
mDLYCT_DLY1:        equ    %00000010
mDLYCT_DLY2:        equ    %00000100
mDLYCT_DLY3:        equ    %00001000
mDLYCT_DLY4:        equ    %00010000
mDLYCT_DLY5:        equ    %00100000
mDLYCT_DLY6:        equ    %01000000
mDLYCT_DLY7:        equ    %10000000


;*** ICOVW - Input Control Overwrite Register; 0x0000006A ***
ICOVW:              equ    $0000006A                                ;*** ICOVW - Input Control Overwrite Register; 0x0000006A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICOVW_NOVW0:        equ    0                                         ; No Input Capture Overwrite 0
ICOVW_NOVW1:        equ    1                                         ; No Input Capture Overwrite 1
ICOVW_NOVW2:        equ    2                                         ; No Input Capture Overwrite 2
ICOVW_NOVW3:        equ    3                                         ; No Input Capture Overwrite 3
ICOVW_NOVW4:        equ    4                                         ; No Input Capture Overwrite 4
ICOVW_NOVW5:        equ    5                                         ; No Input Capture Overwrite 5
ICOVW_NOVW6:        equ    6                                         ; No Input Capture Overwrite 6
ICOVW_NOVW7:        equ    7                                         ; No Input Capture Overwrite 7
; bit position masks
mICOVW_NOVW0:       equ    %00000001
mICOVW_NOVW1:       equ    %00000010
mICOVW_NOVW2:       equ    %00000100
mICOVW_NOVW3:       equ    %00001000
mICOVW_NOVW4:       equ    %00010000
mICOVW_NOVW5:       equ    %00100000
mICOVW_NOVW6:       equ    %01000000
mICOVW_NOVW7:       equ    %10000000


;*** ICSYS - Input Control System Control Register; 0x0000006B ***
ICSYS:              equ    $0000006B                                ;*** ICSYS - Input Control System Control Register; 0x0000006B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSYS_LATQ:         equ    0                                         ; Input Control Latch or Queue Mode Enable
ICSYS_BUFEN:        equ    1                                         ; IC Buffer Enable
ICSYS_PACMX:        equ    2                                         ; 8-Bit Pulse Accumulators Maximum Count
ICSYS_TFMOD:        equ    3                                         ; Timer Flag-setting Mode
ICSYS_SH04:         equ    4                                         ; Share Input action of Input Capture Channels 0 and 4
ICSYS_SH15:         equ    5                                         ; Share Input action of Input Capture Channels 1 and 5
ICSYS_SH26:         equ    6                                         ; Share Input action of Input Capture Channels 2 and 6
ICSYS_SH37:         equ    7                                         ; Share Input action of Input Capture Channels 3 and 7
; bit position masks
mICSYS_LATQ:        equ    %00000001
mICSYS_BUFEN:       equ    %00000010
mICSYS_PACMX:       equ    %00000100
mICSYS_TFMOD:       equ    %00001000
mICSYS_SH04:        equ    %00010000
mICSYS_SH15:        equ    %00100000
mICSYS_SH26:        equ    %01000000
mICSYS_SH37:        equ    %10000000


;*** OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***
OCPD:               equ    $0000006C                                ;*** OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OCPD_OCPD0:         equ    0                                         ; Output Compare Pin Disconnect Bit 0
OCPD_OCPD1:         equ    1                                         ; Output Compare Pin Disconnect Bit 1
OCPD_OCPD2:         equ    2                                         ; Output Compare Pin Disconnect Bit 2
OCPD_OCPD3:         equ    3                                         ; Output Compare Pin Disconnect Bit 3
OCPD_OCPD4:         equ    4                                         ; Output Compare Pin Disconnect Bit 4
OCPD_OCPD5:         equ    5                                         ; Output Compare Pin Disconnect Bit 5
OCPD_OCPD6:         equ    6                                         ; Output Compare Pin Disconnect Bit 6
OCPD_OCPD7:         equ    7                                         ; Output Compare Pin Disconnect Bit 7
; bit position masks
mOCPD_OCPD0:        equ    %00000001
mOCPD_OCPD1:        equ    %00000010
mOCPD_OCPD2:        equ    %00000100
mOCPD_OCPD3:        equ    %00001000
mOCPD_OCPD4:        equ    %00010000
mOCPD_OCPD5:        equ    %00100000
mOCPD_OCPD6:        equ    %01000000
mOCPD_OCPD7:        equ    %10000000


;*** PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***
PTPSR:              equ    $0000006E                                ;*** PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTPSR_PTPS0:        equ    0                                         ; Precision Timer Prescaler Select, bit 0
PTPSR_PTPS1:        equ    1                                         ; Precision Timer Prescaler Select, bit 1
PTPSR_PTPS2:        equ    2                                         ; Precision Timer Prescaler Select, bit 2
PTPSR_PTPS3:        equ    3                                         ; Precision Timer Prescaler Select, bit 3
PTPSR_PTPS4:        equ    4                                         ; Precision Timer Prescaler Select, bit 4
PTPSR_PTPS5:        equ    5                                         ; Precision Timer Prescaler Select, bit 5
PTPSR_PTPS6:        equ    6                                         ; Precision Timer Prescaler Select, bit 6
PTPSR_PTPS7:        equ    7                                         ; Precision Timer Prescaler Select, bit 7
; bit position masks
mPTPSR_PTPS0:       equ    %00000001
mPTPSR_PTPS1:       equ    %00000010
mPTPSR_PTPS2:       equ    %00000100
mPTPSR_PTPS3:       equ    %00001000
mPTPSR_PTPS4:       equ    %00010000
mPTPSR_PTPS5:       equ    %00100000
mPTPSR_PTPS6:       equ    %01000000
mPTPSR_PTPS7:       equ    %10000000


;*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***
PTMCPSR:            equ    $0000006F                                ;*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTMCPSR_PTMPS0:     equ    0                                         ; Precision Timer Modulus Counter Prescaler Select, bit 0
PTMCPSR_PTMPS1:     equ    1                                         ; Precision Timer Modulus Counter Prescaler Select, bit 1
PTMCPSR_PTMPS2:     equ    2                                         ; Precision Timer Modulus Counter Prescaler Select, bit 2
PTMCPSR_PTMPS3:     equ    3                                         ; Precision Timer Modulus Counter Prescaler Select, bit 3
PTMCPSR_PTMPS4:     equ    4                                         ; Precision Timer Modulus Counter Prescaler Select, bit 4
PTMCPSR_PTMPS5:     equ    5                                         ; Precision Timer Modulus Counter Prescaler Select, bit 5
PTMCPSR_PTMPS6:     equ    6                                         ; Precision Timer Modulus Counter Prescaler Select, bit 6
PTMCPSR_PTMPS7:     equ    7                                         ; Precision Timer Modulus Counter Prescaler Select, bit 7
; bit position masks
mPTMCPSR_PTMPS0:    equ    %00000001
mPTMCPSR_PTMPS1:    equ    %00000010
mPTMCPSR_PTMPS2:    equ    %00000100
mPTMCPSR_PTMPS3:    equ    %00001000
mPTMCPSR_PTMPS4:    equ    %00010000
mPTMCPSR_PTMPS5:    equ    %00100000
mPTMCPSR_PTMPS6:    equ    %01000000
mPTMCPSR_PTMPS7:    equ    %10000000


;*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***
PBCTL:              equ    $00000070                                ;*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PBCTL_PBOVI:        equ    1                                         ; Pulse Accumulator B Overflow Interrupt enable
PBCTL_PBEN:         equ    6                                         ; Pulse Accumulator B System Enable
; bit position masks
mPBCTL_PBOVI:       equ    %00000010
mPBCTL_PBEN:        equ    %01000000


;*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***
PBFLG:              equ    $00000071                                ;*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PBFLG_PBOVF:        equ    1                                         ; Pulse Accumulator B Overflow Flag
; bit position masks
mPBFLG_PBOVF:       equ    %00000010


;*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***
PA32H:              equ    $00000072                                ;*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***


;*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***
PA3H:               equ    $00000072                                ;*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***


;*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***
PA2H:               equ    $00000073                                ;*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***


;*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***
PA10H:              equ    $00000074                                ;*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***


;*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***
PA1H:               equ    $00000074                                ;*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***


;*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***
PA0H:               equ    $00000075                                ;*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***


;*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***
MCCNT:              equ    $00000076                                ;*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***


;*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***
MCCNThi:            equ    $00000076                                ;*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***


;*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***
MCCNTlo:            equ    $00000077                                ;*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***


;*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***
TC0H:               equ    $00000078                                ;*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***


;*** TC0Hhi - Timer Input Capture Holding Registers High; 0x00000078 ***
TC0Hhi:             equ    $00000078                                ;*** TC0Hhi - Timer Input Capture Holding Registers High; 0x00000078 ***


;*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***
TC0Hlo:             equ    $00000079                                ;*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***


;*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***
TC1H:               equ    $0000007A                                ;*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***


;*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***
TC1Hhi:             equ    $0000007A                                ;*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***


;*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***
TC1Hlo:             equ    $0000007B                                ;*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***


;*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***
TC2H:               equ    $0000007C                                ;*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***


;*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***
TC2Hhi:             equ    $0000007C                                ;*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***


;*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***
TC2Hlo:             equ    $0000007D                                ;*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***


;*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***
TC3H:               equ    $0000007E                                ;*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***


;*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***
TC3Hhi:             equ    $0000007E                                ;*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***


;*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***
TC3Hlo:             equ    $0000007F                                ;*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***


;*** ATDCTL01 - ATD  Control Register 01; 0x00000080 ***
ATDCTL01:           equ    $00000080                                ;*** ATDCTL01 - ATD  Control Register 01; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL01_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL01_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL01_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL01_ETRIGCH3:  equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL01_SMP_DIS:   equ    4                                         ; Discharge Before Sampling Bit
ATDCTL01_SRES0:     equ    5                                         ; A/D Resolution Select Bit 0
ATDCTL01_SRES1:     equ    6                                         ; A/D Resolution Select Bit 1
ATDCTL01_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
ATDCTL01_WRAP0:     equ    8                                         ; Wrap Around Channel Select Bit 0
ATDCTL01_WRAP1:     equ    9                                         ; Wrap Around Channel Select Bit 1
ATDCTL01_WRAP2:     equ    10                                        ; Wrap Around Channel Select Bit 2
ATDCTL01_WRAP3:     equ    11                                        ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL01_ETRIGCH0: equ    %00000001
mATDCTL01_ETRIGCH1: equ    %00000010
mATDCTL01_ETRIGCH2: equ    %00000100
mATDCTL01_ETRIGCH3: equ    %00001000
mATDCTL01_SMP_DIS:  equ    %00010000
mATDCTL01_SRES0:    equ    %00100000
mATDCTL01_SRES1:    equ    %01000000
mATDCTL01_ETRIGSEL: equ    %10000000
mATDCTL01_WRAP0:    equ    %100000000
mATDCTL01_WRAP1:    equ    %1000000000
mATDCTL01_WRAP2:    equ    %10000000000
mATDCTL01_WRAP3:    equ    %100000000000


;*** ATDCTL0 - ATD  Control Register 0; 0x00000080 ***
ATDCTL0:            equ    $00000080                                ;*** ATDCTL0 - ATD  Control Register 0; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL0_WRAP0:      equ    0                                         ; Wrap Around Channel Select Bit 0
ATDCTL0_WRAP1:      equ    1                                         ; Wrap Around Channel Select Bit 1
ATDCTL0_WRAP2:      equ    2                                         ; Wrap Around Channel Select Bit 2
ATDCTL0_WRAP3:      equ    3                                         ; Wrap Around Channel Select Bit 3
; bit position masks
mATDCTL0_WRAP0:     equ    %00000001
mATDCTL0_WRAP1:     equ    %00000010
mATDCTL0_WRAP2:     equ    %00000100
mATDCTL0_WRAP3:     equ    %00001000


;*** ATDCTL1 - ATD  Control Register 1; 0x00000081 ***
ATDCTL1:            equ    $00000081                                ;*** ATDCTL1 - ATD  Control Register 1; 0x00000081 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL1_ETRIGCH0:   equ    0                                         ; External Trigger Channel Select Bit 0
ATDCTL1_ETRIGCH1:   equ    1                                         ; External Trigger Channel Select Bit 1
ATDCTL1_ETRIGCH2:   equ    2                                         ; External Trigger Channel Select Bit 2
ATDCTL1_ETRIGCH3:   equ    3                                         ; External Trigger Channel Select Bit 3
ATDCTL1_SMP_DIS:    equ    4                                         ; Discharge Before Sampling Bit
ATDCTL1_SRES0:      equ    5                                         ; A/D Resolution Select Bit 0
ATDCTL1_SRES1:      equ    6                                         ; A/D Resolution Select Bit 1
ATDCTL1_ETRIGSEL:   equ    7                                         ; External Trigger Source Select
; bit position masks
mATDCTL1_ETRIGCH0:  equ    %00000001
mATDCTL1_ETRIGCH1:  equ    %00000010
mATDCTL1_ETRIGCH2:  equ    %00000100
mATDCTL1_ETRIGCH3:  equ    %00001000
mATDCTL1_SMP_DIS:   equ    %00010000
mATDCTL1_SRES0:     equ    %00100000
mATDCTL1_SRES1:     equ    %01000000
mATDCTL1_ETRIGSEL:  equ    %10000000


;*** ATDCTL23 - ATD  Control Register 23; 0x00000082 ***
ATDCTL23:           equ    $00000082                                ;*** ATDCTL23 - ATD  Control Register 23; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL23_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL23_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL23_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATDCTL23_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATDCTL23_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATDCTL23_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATDCTL23_S8C:       equ    6                                         ; Conversion Sequence Length 8
ATDCTL23_DJM:       equ    7                                         ; Result Register Data Justification
ATDCTL23_ACMPIE:    equ    8                                         ; ATD Compare Interrupt Enable
ATDCTL23_ASCIE:     equ    9                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL23_ETRIGE:    equ    10                                        ; External Trigger Mode enable
ATDCTL23_ETRIGP:    equ    11                                        ; External Trigger Polarity
ATDCTL23_ETRIGLE:   equ    12                                        ; External Trigger Level/Edge control
ATDCTL23_ICLKSTP:   equ    13                                        ; Internal Clock in Stop Mode Bit
ATDCTL23_AFFC:      equ    14                                        ; ATD Fast Conversion Complete Flag Clear
; bit position masks
mATDCTL23_FRZ0:     equ    %00000001
mATDCTL23_FRZ1:     equ    %00000010
mATDCTL23_FIFO:     equ    %00000100
mATDCTL23_S1C:      equ    %00001000
mATDCTL23_S2C:      equ    %00010000
mATDCTL23_S4C:      equ    %00100000
mATDCTL23_S8C:      equ    %01000000
mATDCTL23_DJM:      equ    %10000000
mATDCTL23_ACMPIE:   equ    %100000000
mATDCTL23_ASCIE:    equ    %1000000000
mATDCTL23_ETRIGE:   equ    %10000000000
mATDCTL23_ETRIGP:   equ    %100000000000
mATDCTL23_ETRIGLE:  equ    %1000000000000
mATDCTL23_ICLKSTP:  equ    %10000000000000
mATDCTL23_AFFC:     equ    %100000000000000


;*** ATDCTL2 - ATD  Control Register 2; 0x00000082 ***
ATDCTL2:            equ    $00000082                                ;*** ATDCTL2 - ATD  Control Register 2; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL2_ACMPIE:     equ    0                                         ; ATD Compare Interrupt Enable
ATDCTL2_ASCIE:      equ    1                                         ; ATD Sequence Complete Interrupt Enable
ATDCTL2_ETRIGE:     equ    2                                         ; External Trigger Mode enable
ATDCTL2_ETRIGP:     equ    3                                         ; External Trigger Polarity
ATDCTL2_ETRIGLE:    equ    4                                         ; External Trigger Level/Edge control
ATDCTL2_ICLKSTP:    equ    5                                         ; Internal Clock in Stop Mode Bit
ATDCTL2_AFFC:       equ    6                                         ; ATD Fast Conversion Complete Flag Clear
; bit position masks
mATDCTL2_ACMPIE:    equ    %00000001
mATDCTL2_ASCIE:     equ    %00000010
mATDCTL2_ETRIGE:    equ    %00000100
mATDCTL2_ETRIGP:    equ    %00001000
mATDCTL2_ETRIGLE:   equ    %00010000
mATDCTL2_ICLKSTP:   equ    %00100000
mATDCTL2_AFFC:      equ    %01000000


;*** ATDCTL3 - ATD  Control Register 3; 0x00000083 ***
ATDCTL3:            equ    $00000083                                ;*** ATDCTL3 - ATD  Control Register 3; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL3_FRZ0:       equ    0                                         ; Background Debug Freeze Enable Bit 0
ATDCTL3_FRZ1:       equ    1                                         ; Background Debug Freeze Enable Bit 1
ATDCTL3_FIFO:       equ    2                                         ; Result Register FIFO Mode
ATDCTL3_S1C:        equ    3                                         ; Conversion Sequence Length 1
ATDCTL3_S2C:        equ    4                                         ; Conversion Sequence Length 2
ATDCTL3_S4C:        equ    5                                         ; Conversion Sequence Length 4
ATDCTL3_S8C:        equ    6                                         ; Conversion Sequence Length 8
ATDCTL3_DJM:        equ    7                                         ; Result Register Data Justification
; bit position masks
mATDCTL3_FRZ0:      equ    %00000001
mATDCTL3_FRZ1:      equ    %00000010
mATDCTL3_FIFO:      equ    %00000100
mATDCTL3_S1C:       equ    %00001000
mATDCTL3_S2C:       equ    %00010000
mATDCTL3_S4C:       equ    %00100000
mATDCTL3_S8C:       equ    %01000000
mATDCTL3_DJM:       equ    %10000000


;*** ATDCTL45 - ATD  Control Register 45; 0x00000084 ***
ATDCTL45:           equ    $00000084                                ;*** ATDCTL45 - ATD  Control Register 45; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL45_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATDCTL45_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATDCTL45_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATDCTL45_CD:        equ    3                                         ; Analog Input Channel Select Code D
ATDCTL45_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATDCTL45_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL45_SC:        equ    6                                         ; Special Channel Conversion Bit
ATDCTL45_PRS0:      equ    8                                         ; ATD Clock Prescaler 0
ATDCTL45_PRS1:      equ    9                                         ; ATD Clock Prescaler 1
ATDCTL45_PRS2:      equ    10                                        ; ATD Clock Prescaler 2
ATDCTL45_PRS3:      equ    11                                        ; ATD Clock Prescaler 3
ATDCTL45_PRS4:      equ    12                                        ; ATD Clock Prescaler 4
ATDCTL45_SMP0:      equ    13                                        ; Sample Time Select 0
ATDCTL45_SMP1:      equ    14                                        ; Sample Time Select 1
ATDCTL45_SMP2:      equ    15                                        ; Sample Time Select 2
; bit position masks
mATDCTL45_CA:       equ    %00000001
mATDCTL45_CB:       equ    %00000010
mATDCTL45_CC:       equ    %00000100
mATDCTL45_CD:       equ    %00001000
mATDCTL45_MULT:     equ    %00010000
mATDCTL45_SCAN:     equ    %00100000
mATDCTL45_SC:       equ    %01000000
mATDCTL45_PRS0:     equ    %100000000
mATDCTL45_PRS1:     equ    %1000000000
mATDCTL45_PRS2:     equ    %10000000000
mATDCTL45_PRS3:     equ    %100000000000
mATDCTL45_PRS4:     equ    %1000000000000
mATDCTL45_SMP0:     equ    %10000000000000
mATDCTL45_SMP1:     equ    %100000000000000
mATDCTL45_SMP2:     equ    %1000000000000000


;*** ATDCTL4 - ATD  Control Register 4; 0x00000084 ***
ATDCTL4:            equ    $00000084                                ;*** ATDCTL4 - ATD  Control Register 4; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL4_PRS0:       equ    0                                         ; ATD Clock Prescaler 0
ATDCTL4_PRS1:       equ    1                                         ; ATD Clock Prescaler 1
ATDCTL4_PRS2:       equ    2                                         ; ATD Clock Prescaler 2
ATDCTL4_PRS3:       equ    3                                         ; ATD Clock Prescaler 3
ATDCTL4_PRS4:       equ    4                                         ; ATD Clock Prescaler 4
ATDCTL4_SMP0:       equ    5                                         ; Sample Time Select 0
ATDCTL4_SMP1:       equ    6                                         ; Sample Time Select 1
ATDCTL4_SMP2:       equ    7                                         ; Sample Time Select 2
; bit position masks
mATDCTL4_PRS0:      equ    %00000001
mATDCTL4_PRS1:      equ    %00000010
mATDCTL4_PRS2:      equ    %00000100
mATDCTL4_PRS3:      equ    %00001000
mATDCTL4_PRS4:      equ    %00010000
mATDCTL4_SMP0:      equ    %00100000
mATDCTL4_SMP1:      equ    %01000000
mATDCTL4_SMP2:      equ    %10000000


;*** ATDCTL5 - ATD  Control Register 5; 0x00000085 ***
ATDCTL5:            equ    $00000085                                ;*** ATDCTL5 - ATD  Control Register 5; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCTL5_CA:         equ    0                                         ; Analog Input Channel Select Code A
ATDCTL5_CB:         equ    1                                         ; Analog Input Channel Select Code B
ATDCTL5_CC:         equ    2                                         ; Analog Input Channel Select Code C
ATDCTL5_CD:         equ    3                                         ; Analog Input Channel Select Code D
ATDCTL5_MULT:       equ    4                                         ; Multi-Channel Sample Mode
ATDCTL5_SCAN:       equ    5                                         ; Continuous Conversion Sequence Mode
ATDCTL5_SC:         equ    6                                         ; Special Channel Conversion Bit
; bit position masks
mATDCTL5_CA:        equ    %00000001
mATDCTL5_CB:        equ    %00000010
mATDCTL5_CC:        equ    %00000100
mATDCTL5_CD:        equ    %00001000
mATDCTL5_MULT:      equ    %00010000
mATDCTL5_SCAN:      equ    %00100000
mATDCTL5_SC:        equ    %01000000


;*** ATDSTAT0 - ATD  Status Register 0; 0x00000086 ***
ATDSTAT0:           equ    $00000086                                ;*** ATDSTAT0 - ATD  Status Register 0; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT0_CC0:       equ    0                                         ; Conversion Counter 0
ATDSTAT0_CC1:       equ    1                                         ; Conversion Counter 1
ATDSTAT0_CC2:       equ    2                                         ; Conversion Counter 2
ATDSTAT0_CC3:       equ    3                                         ; Conversion Counter 3
ATDSTAT0_FIFOR:     equ    4                                         ; FIFO Over Run Flag
ATDSTAT0_ETORF:     equ    5                                         ; External Trigger Overrun Flag
ATDSTAT0_SCF:       equ    7                                         ; Sequence Complete Flag
; bit position masks
mATDSTAT0_CC0:      equ    %00000001
mATDSTAT0_CC1:      equ    %00000010
mATDSTAT0_CC2:      equ    %00000100
mATDSTAT0_CC3:      equ    %00001000
mATDSTAT0_FIFOR:    equ    %00010000
mATDSTAT0_ETORF:    equ    %00100000
mATDSTAT0_SCF:      equ    %10000000


;*** ATDCMPE - ATD  Compare Enable Register; 0x00000088 ***
ATDCMPE:            equ    $00000088                                ;*** ATDCMPE - ATD  Compare Enable Register; 0x00000088 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPE_CMPE0:      equ    0                                         ; Compare Enable for Conversion Number 0 of a Sequence
ATDCMPE_CMPE1:      equ    1                                         ; Compare Enable for Conversion Number 1 of a Sequence
ATDCMPE_CMPE2:      equ    2                                         ; Compare Enable for Conversion Number 2 of a Sequence
ATDCMPE_CMPE3:      equ    3                                         ; Compare Enable for Conversion Number 3 of a Sequence
ATDCMPE_CMPE4:      equ    4                                         ; Compare Enable for Conversion Number 4 of a Sequence
ATDCMPE_CMPE5:      equ    5                                         ; Compare Enable for Conversion Number 5 of a Sequence
ATDCMPE_CMPE6:      equ    6                                         ; Compare Enable for Conversion Number 6 of a Sequence
ATDCMPE_CMPE7:      equ    7                                         ; Compare Enable for Conversion Number 7 of a Sequence
ATDCMPE_CMPE8:      equ    8                                         ; Compare Enable for Conversion Number 8 of a Sequence
ATDCMPE_CMPE9:      equ    9                                         ; Compare Enable for Conversion Number 9 of a Sequence
ATDCMPE_CMPE10:     equ    10                                        ; Compare Enable for Conversion Number 10 of a Sequence
ATDCMPE_CMPE11:     equ    11                                        ; Compare Enable for Conversion Number 11 of a Sequence
ATDCMPE_CMPE12:     equ    12                                        ; Compare Enable for Conversion Number 12 of a Sequence
ATDCMPE_CMPE13:     equ    13                                        ; Compare Enable for Conversion Number 13 of a Sequence
ATDCMPE_CMPE14:     equ    14                                        ; Compare Enable for Conversion Number 14 of a Sequence
ATDCMPE_CMPE15:     equ    15                                        ; Compare Enable for Conversion Number 15 of a Sequence
; bit position masks
mATDCMPE_CMPE0:     equ    %00000001
mATDCMPE_CMPE1:     equ    %00000010
mATDCMPE_CMPE2:     equ    %00000100
mATDCMPE_CMPE3:     equ    %00001000
mATDCMPE_CMPE4:     equ    %00010000
mATDCMPE_CMPE5:     equ    %00100000
mATDCMPE_CMPE6:     equ    %01000000
mATDCMPE_CMPE7:     equ    %10000000
mATDCMPE_CMPE8:     equ    %100000000
mATDCMPE_CMPE9:     equ    %1000000000
mATDCMPE_CMPE10:    equ    %10000000000
mATDCMPE_CMPE11:    equ    %100000000000
mATDCMPE_CMPE12:    equ    %1000000000000
mATDCMPE_CMPE13:    equ    %10000000000000
mATDCMPE_CMPE14:    equ    %100000000000000
mATDCMPE_CMPE15:    equ    %1000000000000000


;*** ATDCMPEH - ATD  Compare Enable Register High; 0x00000088 ***
ATDCMPEH:           equ    $00000088                                ;*** ATDCMPEH - ATD  Compare Enable Register High; 0x00000088 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPEH_CMPE8:     equ    0                                         ; Compare Enable for Conversion Number 8 of a Sequence
ATDCMPEH_CMPE9:     equ    1                                         ; Compare Enable for Conversion Number 9 of a Sequence
ATDCMPEH_CMPE10:    equ    2                                         ; Compare Enable for Conversion Number 10 of a Sequence
ATDCMPEH_CMPE11:    equ    3                                         ; Compare Enable for Conversion Number 11 of a Sequence
ATDCMPEH_CMPE12:    equ    4                                         ; Compare Enable for Conversion Number 12 of a Sequence
ATDCMPEH_CMPE13:    equ    5                                         ; Compare Enable for Conversion Number 13 of a Sequence
ATDCMPEH_CMPE14:    equ    6                                         ; Compare Enable for Conversion Number 14 of a Sequence
ATDCMPEH_CMPE15:    equ    7                                         ; Compare Enable for Conversion Number 15 of a Sequence
; bit position masks
mATDCMPEH_CMPE8:    equ    %00000001
mATDCMPEH_CMPE9:    equ    %00000010
mATDCMPEH_CMPE10:   equ    %00000100
mATDCMPEH_CMPE11:   equ    %00001000
mATDCMPEH_CMPE12:   equ    %00010000
mATDCMPEH_CMPE13:   equ    %00100000
mATDCMPEH_CMPE14:   equ    %01000000
mATDCMPEH_CMPE15:   equ    %10000000


;*** ATDCMPEL - ATD  Compare Enable Register Low; 0x00000089 ***
ATDCMPEL:           equ    $00000089                                ;*** ATDCMPEL - ATD  Compare Enable Register Low; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPEL_CMPE0:     equ    0                                         ; Compare Enable for Conversion Number 0 of a Sequence
ATDCMPEL_CMPE1:     equ    1                                         ; Compare Enable for Conversion Number 1 of a Sequence
ATDCMPEL_CMPE2:     equ    2                                         ; Compare Enable for Conversion Number 2 of a Sequence
ATDCMPEL_CMPE3:     equ    3                                         ; Compare Enable for Conversion Number 3 of a Sequence
ATDCMPEL_CMPE4:     equ    4                                         ; Compare Enable for Conversion Number 4 of a Sequence
ATDCMPEL_CMPE5:     equ    5                                         ; Compare Enable for Conversion Number 5 of a Sequence
ATDCMPEL_CMPE6:     equ    6                                         ; Compare Enable for Conversion Number 6 of a Sequence
ATDCMPEL_CMPE7:     equ    7                                         ; Compare Enable for Conversion Number 7 of a Sequence
; bit position masks
mATDCMPEL_CMPE0:    equ    %00000001
mATDCMPEL_CMPE1:    equ    %00000010
mATDCMPEL_CMPE2:    equ    %00000100
mATDCMPEL_CMPE3:    equ    %00001000
mATDCMPEL_CMPE4:    equ    %00010000
mATDCMPEL_CMPE5:    equ    %00100000
mATDCMPEL_CMPE6:    equ    %01000000
mATDCMPEL_CMPE7:    equ    %10000000


;*** ATDSTAT2 - ATD  Status Register 2; 0x0000008A ***
ATDSTAT2:           equ    $0000008A                                ;*** ATDSTAT2 - ATD  Status Register 2; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2_CCF0:      equ    0                                         ; Conversion Complete Flag 0
ATDSTAT2_CCF1:      equ    1                                         ; Conversion Complete Flag 1
ATDSTAT2_CCF2:      equ    2                                         ; Conversion Complete Flag 2
ATDSTAT2_CCF3:      equ    3                                         ; Conversion Complete Flag 3
ATDSTAT2_CCF4:      equ    4                                         ; Conversion Complete Flag 4
ATDSTAT2_CCF5:      equ    5                                         ; Conversion Complete Flag 5
ATDSTAT2_CCF6:      equ    6                                         ; Conversion Complete Flag 6
ATDSTAT2_CCF7:      equ    7                                         ; Conversion Complete Flag 7
ATDSTAT2_CCF8:      equ    8                                         ; Conversion Complete Flag 8
ATDSTAT2_CCF9:      equ    9                                         ; Conversion Complete Flag 9
ATDSTAT2_CCF10:     equ    10                                        ; Conversion Complete Flag 10
ATDSTAT2_CCF11:     equ    11                                        ; Conversion Complete Flag 11
ATDSTAT2_CCF12:     equ    12                                        ; Conversion Complete Flag 12
ATDSTAT2_CCF13:     equ    13                                        ; Conversion Complete Flag 13
ATDSTAT2_CCF14:     equ    14                                        ; Conversion Complete Flag 14
ATDSTAT2_CCF15:     equ    15                                        ; Conversion Complete Flag 15
; bit position masks
mATDSTAT2_CCF0:     equ    %00000001
mATDSTAT2_CCF1:     equ    %00000010
mATDSTAT2_CCF2:     equ    %00000100
mATDSTAT2_CCF3:     equ    %00001000
mATDSTAT2_CCF4:     equ    %00010000
mATDSTAT2_CCF5:     equ    %00100000
mATDSTAT2_CCF6:     equ    %01000000
mATDSTAT2_CCF7:     equ    %10000000
mATDSTAT2_CCF8:     equ    %100000000
mATDSTAT2_CCF9:     equ    %1000000000
mATDSTAT2_CCF10:    equ    %10000000000
mATDSTAT2_CCF11:    equ    %100000000000
mATDSTAT2_CCF12:    equ    %1000000000000
mATDSTAT2_CCF13:    equ    %10000000000000
mATDSTAT2_CCF14:    equ    %100000000000000
mATDSTAT2_CCF15:    equ    %1000000000000000


;*** ATDSTAT2H - ATD  Status Register 2 High; 0x0000008A ***
ATDSTAT2H:          equ    $0000008A                                ;*** ATDSTAT2H - ATD  Status Register 2 High; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2H_CCF8:     equ    0                                         ; Conversion Complete Flag 8
ATDSTAT2H_CCF9:     equ    1                                         ; Conversion Complete Flag 9
ATDSTAT2H_CCF10:    equ    2                                         ; Conversion Complete Flag 10
ATDSTAT2H_CCF11:    equ    3                                         ; Conversion Complete Flag 11
ATDSTAT2H_CCF12:    equ    4                                         ; Conversion Complete Flag 12
ATDSTAT2H_CCF13:    equ    5                                         ; Conversion Complete Flag 13
ATDSTAT2H_CCF14:    equ    6                                         ; Conversion Complete Flag 14
ATDSTAT2H_CCF15:    equ    7                                         ; Conversion Complete Flag 15
; bit position masks
mATDSTAT2H_CCF8:    equ    %00000001
mATDSTAT2H_CCF9:    equ    %00000010
mATDSTAT2H_CCF10:   equ    %00000100
mATDSTAT2H_CCF11:   equ    %00001000
mATDSTAT2H_CCF12:   equ    %00010000
mATDSTAT2H_CCF13:   equ    %00100000
mATDSTAT2H_CCF14:   equ    %01000000
mATDSTAT2H_CCF15:   equ    %10000000


;*** ATDSTAT2L - ATD  Status Register 2 Low; 0x0000008B ***
ATDSTAT2L:          equ    $0000008B                                ;*** ATDSTAT2L - ATD  Status Register 2 Low; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDSTAT2L_CCF0:     equ    0                                         ; Conversion Complete Flag 0
ATDSTAT2L_CCF1:     equ    1                                         ; Conversion Complete Flag 1
ATDSTAT2L_CCF2:     equ    2                                         ; Conversion Complete Flag 2
ATDSTAT2L_CCF3:     equ    3                                         ; Conversion Complete Flag 3
ATDSTAT2L_CCF4:     equ    4                                         ; Conversion Complete Flag 4
ATDSTAT2L_CCF5:     equ    5                                         ; Conversion Complete Flag 5
ATDSTAT2L_CCF6:     equ    6                                         ; Conversion Complete Flag 6
ATDSTAT2L_CCF7:     equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATDSTAT2L_CCF0:    equ    %00000001
mATDSTAT2L_CCF1:    equ    %00000010
mATDSTAT2L_CCF2:    equ    %00000100
mATDSTAT2L_CCF3:    equ    %00001000
mATDSTAT2L_CCF4:    equ    %00010000
mATDSTAT2L_CCF5:    equ    %00100000
mATDSTAT2L_CCF6:    equ    %01000000
mATDSTAT2L_CCF7:    equ    %10000000


;*** ATDDIEN - ATD  Input Enable Register; 0x0000008C ***
ATDDIEN:            equ    $0000008C                                ;*** ATDDIEN - ATD  Input Enable Register; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIEN_IEN0:       equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIEN_IEN1:       equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIEN_IEN2:       equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIEN_IEN3:       equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIEN_IEN4:       equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIEN_IEN5:       equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIEN_IEN6:       equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIEN_IEN7:       equ    7                                         ; ATD Digital Input Enable on channel 7
ATDDIEN_IEN8:       equ    8                                         ; ATD Digital Input Enable on channel 8
ATDDIEN_IEN9:       equ    9                                         ; ATD Digital Input Enable on channel 9
ATDDIEN_IEN10:      equ    10                                        ; ATD Digital Input Enable on channel 10
ATDDIEN_IEN11:      equ    11                                        ; ATD Digital Input Enable on channel 11
ATDDIEN_IEN12:      equ    12                                        ; ATD Digital Input Enable on channel 12
ATDDIEN_IEN13:      equ    13                                        ; ATD Digital Input Enable on channel 13
ATDDIEN_IEN14:      equ    14                                        ; ATD Digital Input Enable on channel 14
ATDDIEN_IEN15:      equ    15                                        ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIEN_IEN0:      equ    %00000001
mATDDIEN_IEN1:      equ    %00000010
mATDDIEN_IEN2:      equ    %00000100
mATDDIEN_IEN3:      equ    %00001000
mATDDIEN_IEN4:      equ    %00010000
mATDDIEN_IEN5:      equ    %00100000
mATDDIEN_IEN6:      equ    %01000000
mATDDIEN_IEN7:      equ    %10000000
mATDDIEN_IEN8:      equ    %100000000
mATDDIEN_IEN9:      equ    %1000000000
mATDDIEN_IEN10:     equ    %10000000000
mATDDIEN_IEN11:     equ    %100000000000
mATDDIEN_IEN12:     equ    %1000000000000
mATDDIEN_IEN13:     equ    %10000000000000
mATDDIEN_IEN14:     equ    %100000000000000
mATDDIEN_IEN15:     equ    %1000000000000000


;*** ATDDIENH - ATD  Input Enable Register High; 0x0000008C ***
ATDDIENH:           equ    $0000008C                                ;*** ATDDIENH - ATD  Input Enable Register High; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIENH_IEN8:      equ    0                                         ; ATD Digital Input Enable on channel 8
ATDDIENH_IEN9:      equ    1                                         ; ATD Digital Input Enable on channel 9
ATDDIENH_IEN10:     equ    2                                         ; ATD Digital Input Enable on channel 10
ATDDIENH_IEN11:     equ    3                                         ; ATD Digital Input Enable on channel 11
ATDDIENH_IEN12:     equ    4                                         ; ATD Digital Input Enable on channel 12
ATDDIENH_IEN13:     equ    5                                         ; ATD Digital Input Enable on channel 13
ATDDIENH_IEN14:     equ    6                                         ; ATD Digital Input Enable on channel 14
ATDDIENH_IEN15:     equ    7                                         ; ATD Digital Input Enable on channel 15
; bit position masks
mATDDIENH_IEN8:     equ    %00000001
mATDDIENH_IEN9:     equ    %00000010
mATDDIENH_IEN10:    equ    %00000100
mATDDIENH_IEN11:    equ    %00001000
mATDDIENH_IEN12:    equ    %00010000
mATDDIENH_IEN13:    equ    %00100000
mATDDIENH_IEN14:    equ    %01000000
mATDDIENH_IEN15:    equ    %10000000


;*** ATDDIENL - ATD  Input Enable Register Low; 0x0000008D ***
ATDDIENL:           equ    $0000008D                                ;*** ATDDIENL - ATD  Input Enable Register Low; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDIENL_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATDDIENL_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATDDIENL_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATDDIENL_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATDDIENL_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATDDIENL_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATDDIENL_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATDDIENL_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATDDIENL_IEN0:     equ    %00000001
mATDDIENL_IEN1:     equ    %00000010
mATDDIENL_IEN2:     equ    %00000100
mATDDIENL_IEN3:     equ    %00001000
mATDDIENL_IEN4:     equ    %00010000
mATDDIENL_IEN5:     equ    %00100000
mATDDIENL_IEN6:     equ    %01000000
mATDDIENL_IEN7:     equ    %10000000


;*** ATDCMPHT - ATD  Compare Higher Than Register; 0x0000008E ***
ATDCMPHT:           equ    $0000008E                                ;*** ATDCMPHT - ATD  Compare Higher Than Register; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPHT_CMPHT0:    equ    0                                         ; Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence
ATDCMPHT_CMPHT1:    equ    1                                         ; Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence
ATDCMPHT_CMPHT2:    equ    2                                         ; Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence
ATDCMPHT_CMPHT3:    equ    3                                         ; Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence
ATDCMPHT_CMPHT4:    equ    4                                         ; Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence
ATDCMPHT_CMPHT5:    equ    5                                         ; Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence
ATDCMPHT_CMPHT6:    equ    6                                         ; Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence
ATDCMPHT_CMPHT7:    equ    7                                         ; Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence
ATDCMPHT_CMPHT8:    equ    8                                         ; Compare Operation Higher Than Enable for Conversion Number 8 of a Sequence
ATDCMPHT_CMPHT9:    equ    9                                         ; Compare Operation Higher Than Enable for Conversion Number 9 of a Sequence
ATDCMPHT_CMPHT10:   equ    10                                        ; Compare Operation Higher Than Enable for Conversion Number 10 of a Sequence
ATDCMPHT_CMPHT11:   equ    11                                        ; Compare Operation Higher Than Enable for Conversion Number 11 of a Sequence
ATDCMPHT_CMPHT12:   equ    12                                        ; Compare Operation Higher Than Enable for Conversion Number 12 of a Sequence
ATDCMPHT_CMPHT13:   equ    13                                        ; Compare Operation Higher Than Enable for Conversion Number 13 of a Sequence
ATDCMPHT_CMPHT14:   equ    14                                        ; Compare Operation Higher Than Enable for Conversion Number 14 of a Sequence
ATDCMPHT_CMPHT15:   equ    15                                        ; Compare Operation Higher Than Enable for Conversion Number 15 of a Sequence
; bit position masks
mATDCMPHT_CMPHT0:   equ    %00000001
mATDCMPHT_CMPHT1:   equ    %00000010
mATDCMPHT_CMPHT2:   equ    %00000100
mATDCMPHT_CMPHT3:   equ    %00001000
mATDCMPHT_CMPHT4:   equ    %00010000
mATDCMPHT_CMPHT5:   equ    %00100000
mATDCMPHT_CMPHT6:   equ    %01000000
mATDCMPHT_CMPHT7:   equ    %10000000
mATDCMPHT_CMPHT8:   equ    %100000000
mATDCMPHT_CMPHT9:   equ    %1000000000
mATDCMPHT_CMPHT10:  equ    %10000000000
mATDCMPHT_CMPHT11:  equ    %100000000000
mATDCMPHT_CMPHT12:  equ    %1000000000000
mATDCMPHT_CMPHT13:  equ    %10000000000000
mATDCMPHT_CMPHT14:  equ    %100000000000000
mATDCMPHT_CMPHT15:  equ    %1000000000000000


;*** ATDCMPHTH - ATD  Compare Higher Than Register High; 0x0000008E ***
ATDCMPHTH:          equ    $0000008E                                ;*** ATDCMPHTH - ATD  Compare Higher Than Register High; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPHTH_CMPHT8:   equ    0                                         ; Compare Operation Higher Than Enable for Conversion Number 8 of a Sequence
ATDCMPHTH_CMPHT9:   equ    1                                         ; Compare Operation Higher Than Enable for Conversion Number 9 of a Sequence
ATDCMPHTH_CMPHT10:  equ    2                                         ; Compare Operation Higher Than Enable for Conversion Number 10 of a Sequence
ATDCMPHTH_CMPHT11:  equ    3                                         ; Compare Operation Higher Than Enable for Conversion Number 11 of a Sequence
ATDCMPHTH_CMPHT12:  equ    4                                         ; Compare Operation Higher Than Enable for Conversion Number 12 of a Sequence
ATDCMPHTH_CMPHT13:  equ    5                                         ; Compare Operation Higher Than Enable for Conversion Number 13 of a Sequence
ATDCMPHTH_CMPHT14:  equ    6                                         ; Compare Operation Higher Than Enable for Conversion Number 14 of a Sequence
ATDCMPHTH_CMPHT15:  equ    7                                         ; Compare Operation Higher Than Enable for Conversion Number 15 of a Sequence
; bit position masks
mATDCMPHTH_CMPHT8:  equ    %00000001
mATDCMPHTH_CMPHT9:  equ    %00000010
mATDCMPHTH_CMPHT10: equ    %00000100
mATDCMPHTH_CMPHT11: equ    %00001000
mATDCMPHTH_CMPHT12: equ    %00010000
mATDCMPHTH_CMPHT13: equ    %00100000
mATDCMPHTH_CMPHT14: equ    %01000000
mATDCMPHTH_CMPHT15: equ    %10000000


;*** ATDCMPHTL - ATD  Compare Higher Than Register Low; 0x0000008F ***
ATDCMPHTL:          equ    $0000008F                                ;*** ATDCMPHTL - ATD  Compare Higher Than Register Low; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDCMPHTL_CMPHT0:   equ    0                                         ; Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence
ATDCMPHTL_CMPHT1:   equ    1                                         ; Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence
ATDCMPHTL_CMPHT2:   equ    2                                         ; Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence
ATDCMPHTL_CMPHT3:   equ    3                                         ; Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence
ATDCMPHTL_CMPHT4:   equ    4                                         ; Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence
ATDCMPHTL_CMPHT5:   equ    5                                         ; Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence
ATDCMPHTL_CMPHT6:   equ    6                                         ; Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence
ATDCMPHTL_CMPHT7:   equ    7                                         ; Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence
; bit position masks
mATDCMPHTL_CMPHT0:  equ    %00000001
mATDCMPHTL_CMPHT1:  equ    %00000010
mATDCMPHTL_CMPHT2:  equ    %00000100
mATDCMPHTL_CMPHT3:  equ    %00001000
mATDCMPHTL_CMPHT4:  equ    %00010000
mATDCMPHTL_CMPHT5:  equ    %00100000
mATDCMPHTL_CMPHT6:  equ    %01000000
mATDCMPHTL_CMPHT7:  equ    %10000000


;*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000090 ***
ATDDR0:             equ    $00000090                                ;*** ATDDR0 - ATD  Conversion Result Register 0; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0_BIT0:        equ    0                                         ; Bit 0
ATDDR0_BIT1:        equ    1                                         ; Bit 1
ATDDR0_BIT2:        equ    2                                         ; Bit 2
ATDDR0_BIT3:        equ    3                                         ; Bit 3
ATDDR0_BIT4:        equ    4                                         ; Bit 4
ATDDR0_BIT5:        equ    5                                         ; Bit 5
ATDDR0_BIT6:        equ    6                                         ; Bit 6
ATDDR0_BIT7:        equ    7                                         ; Bit 7
ATDDR0_BIT8:        equ    8                                         ; Bit 8
ATDDR0_BIT9:        equ    9                                         ; Bit 9
ATDDR0_BIT10:       equ    10                                        ; Bit 10
ATDDR0_BIT11:       equ    11                                        ; Bit 11
ATDDR0_BIT12:       equ    12                                        ; Bit 12
ATDDR0_BIT13:       equ    13                                        ; Bit 13
ATDDR0_BIT14:       equ    14                                        ; Bit 14
ATDDR0_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR0_BIT0:       equ    %00000001
mATDDR0_BIT1:       equ    %00000010
mATDDR0_BIT2:       equ    %00000100
mATDDR0_BIT3:       equ    %00001000
mATDDR0_BIT4:       equ    %00010000
mATDDR0_BIT5:       equ    %00100000
mATDDR0_BIT6:       equ    %01000000
mATDDR0_BIT7:       equ    %10000000
mATDDR0_BIT8:       equ    %100000000
mATDDR0_BIT9:       equ    %1000000000
mATDDR0_BIT10:      equ    %10000000000
mATDDR0_BIT11:      equ    %100000000000
mATDDR0_BIT12:      equ    %1000000000000
mATDDR0_BIT13:      equ    %10000000000000
mATDDR0_BIT14:      equ    %100000000000000
mATDDR0_BIT15:      equ    %1000000000000000


;*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000090 ***
ATDDR0H:            equ    $00000090                                ;*** ATDDR0H - ATD  Conversion Result Register 0 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0H_BIT8:       equ    0                                         ; Bit 8
ATDDR0H_BIT9:       equ    1                                         ; Bit 9
ATDDR0H_BIT10:      equ    2                                         ; Bit 10
ATDDR0H_BIT11:      equ    3                                         ; Bit 11
ATDDR0H_BIT12:      equ    4                                         ; Bit 12
ATDDR0H_BIT13:      equ    5                                         ; Bit 13
ATDDR0H_BIT14:      equ    6                                         ; Bit 14
ATDDR0H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR0H_BIT8:      equ    %00000001
mATDDR0H_BIT9:      equ    %00000010
mATDDR0H_BIT10:     equ    %00000100
mATDDR0H_BIT11:     equ    %00001000
mATDDR0H_BIT12:     equ    %00010000
mATDDR0H_BIT13:     equ    %00100000
mATDDR0H_BIT14:     equ    %01000000
mATDDR0H_BIT15:     equ    %10000000


;*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000091 ***
ATDDR0L:            equ    $00000091                                ;*** ATDDR0L - ATD  Conversion Result Register 0 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR0L_BIT0:       equ    0                                         ; Bit 0
ATDDR0L_BIT1:       equ    1                                         ; Bit 1
ATDDR0L_BIT2:       equ    2                                         ; Bit 2
ATDDR0L_BIT3:       equ    3                                         ; Bit 3
ATDDR0L_BIT4:       equ    4                                         ; Bit 4
ATDDR0L_BIT5:       equ    5                                         ; Bit 5
ATDDR0L_BIT6:       equ    6                                         ; Bit 6
ATDDR0L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR0L_BIT0:      equ    %00000001
mATDDR0L_BIT1:      equ    %00000010
mATDDR0L_BIT2:      equ    %00000100
mATDDR0L_BIT3:      equ    %00001000
mATDDR0L_BIT4:      equ    %00010000
mATDDR0L_BIT5:      equ    %00100000
mATDDR0L_BIT6:      equ    %01000000
mATDDR0L_BIT7:      equ    %10000000


;*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000092 ***
ATDDR1:             equ    $00000092                                ;*** ATDDR1 - ATD  Conversion Result Register 1; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1_BIT0:        equ    0                                         ; Bit 0
ATDDR1_BIT1:        equ    1                                         ; Bit 1
ATDDR1_BIT2:        equ    2                                         ; Bit 2
ATDDR1_BIT3:        equ    3                                         ; Bit 3
ATDDR1_BIT4:        equ    4                                         ; Bit 4
ATDDR1_BIT5:        equ    5                                         ; Bit 5
ATDDR1_BIT6:        equ    6                                         ; Bit 6
ATDDR1_BIT7:        equ    7                                         ; Bit 7
ATDDR1_BIT8:        equ    8                                         ; Bit 8
ATDDR1_BIT9:        equ    9                                         ; Bit 9
ATDDR1_BIT10:       equ    10                                        ; Bit 10
ATDDR1_BIT11:       equ    11                                        ; Bit 11
ATDDR1_BIT12:       equ    12                                        ; Bit 12
ATDDR1_BIT13:       equ    13                                        ; Bit 13
ATDDR1_BIT14:       equ    14                                        ; Bit 14
ATDDR1_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR1_BIT0:       equ    %00000001
mATDDR1_BIT1:       equ    %00000010
mATDDR1_BIT2:       equ    %00000100
mATDDR1_BIT3:       equ    %00001000
mATDDR1_BIT4:       equ    %00010000
mATDDR1_BIT5:       equ    %00100000
mATDDR1_BIT6:       equ    %01000000
mATDDR1_BIT7:       equ    %10000000
mATDDR1_BIT8:       equ    %100000000
mATDDR1_BIT9:       equ    %1000000000
mATDDR1_BIT10:      equ    %10000000000
mATDDR1_BIT11:      equ    %100000000000
mATDDR1_BIT12:      equ    %1000000000000
mATDDR1_BIT13:      equ    %10000000000000
mATDDR1_BIT14:      equ    %100000000000000
mATDDR1_BIT15:      equ    %1000000000000000


;*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000092 ***
ATDDR1H:            equ    $00000092                                ;*** ATDDR1H - ATD  Conversion Result Register 1 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1H_BIT8:       equ    0                                         ; Bit 8
ATDDR1H_BIT9:       equ    1                                         ; Bit 9
ATDDR1H_BIT10:      equ    2                                         ; Bit 10
ATDDR1H_BIT11:      equ    3                                         ; Bit 11
ATDDR1H_BIT12:      equ    4                                         ; Bit 12
ATDDR1H_BIT13:      equ    5                                         ; Bit 13
ATDDR1H_BIT14:      equ    6                                         ; Bit 14
ATDDR1H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR1H_BIT8:      equ    %00000001
mATDDR1H_BIT9:      equ    %00000010
mATDDR1H_BIT10:     equ    %00000100
mATDDR1H_BIT11:     equ    %00001000
mATDDR1H_BIT12:     equ    %00010000
mATDDR1H_BIT13:     equ    %00100000
mATDDR1H_BIT14:     equ    %01000000
mATDDR1H_BIT15:     equ    %10000000


;*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000093 ***
ATDDR1L:            equ    $00000093                                ;*** ATDDR1L - ATD  Conversion Result Register 1 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR1L_BIT0:       equ    0                                         ; Bit 0
ATDDR1L_BIT1:       equ    1                                         ; Bit 1
ATDDR1L_BIT2:       equ    2                                         ; Bit 2
ATDDR1L_BIT3:       equ    3                                         ; Bit 3
ATDDR1L_BIT4:       equ    4                                         ; Bit 4
ATDDR1L_BIT5:       equ    5                                         ; Bit 5
ATDDR1L_BIT6:       equ    6                                         ; Bit 6
ATDDR1L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR1L_BIT0:      equ    %00000001
mATDDR1L_BIT1:      equ    %00000010
mATDDR1L_BIT2:      equ    %00000100
mATDDR1L_BIT3:      equ    %00001000
mATDDR1L_BIT4:      equ    %00010000
mATDDR1L_BIT5:      equ    %00100000
mATDDR1L_BIT6:      equ    %01000000
mATDDR1L_BIT7:      equ    %10000000


;*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000094 ***
ATDDR2:             equ    $00000094                                ;*** ATDDR2 - ATD  Conversion Result Register 2; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2_BIT0:        equ    0                                         ; Bit 0
ATDDR2_BIT1:        equ    1                                         ; Bit 1
ATDDR2_BIT2:        equ    2                                         ; Bit 2
ATDDR2_BIT3:        equ    3                                         ; Bit 3
ATDDR2_BIT4:        equ    4                                         ; Bit 4
ATDDR2_BIT5:        equ    5                                         ; Bit 5
ATDDR2_BIT6:        equ    6                                         ; Bit 6
ATDDR2_BIT7:        equ    7                                         ; Bit 7
ATDDR2_BIT8:        equ    8                                         ; Bit 8
ATDDR2_BIT9:        equ    9                                         ; Bit 9
ATDDR2_BIT10:       equ    10                                        ; Bit 10
ATDDR2_BIT11:       equ    11                                        ; Bit 11
ATDDR2_BIT12:       equ    12                                        ; Bit 12
ATDDR2_BIT13:       equ    13                                        ; Bit 13
ATDDR2_BIT14:       equ    14                                        ; Bit 14
ATDDR2_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR2_BIT0:       equ    %00000001
mATDDR2_BIT1:       equ    %00000010
mATDDR2_BIT2:       equ    %00000100
mATDDR2_BIT3:       equ    %00001000
mATDDR2_BIT4:       equ    %00010000
mATDDR2_BIT5:       equ    %00100000
mATDDR2_BIT6:       equ    %01000000
mATDDR2_BIT7:       equ    %10000000
mATDDR2_BIT8:       equ    %100000000
mATDDR2_BIT9:       equ    %1000000000
mATDDR2_BIT10:      equ    %10000000000
mATDDR2_BIT11:      equ    %100000000000
mATDDR2_BIT12:      equ    %1000000000000
mATDDR2_BIT13:      equ    %10000000000000
mATDDR2_BIT14:      equ    %100000000000000
mATDDR2_BIT15:      equ    %1000000000000000


;*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000094 ***
ATDDR2H:            equ    $00000094                                ;*** ATDDR2H - ATD  Conversion Result Register 2 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2H_BIT8:       equ    0                                         ; Bit 8
ATDDR2H_BIT9:       equ    1                                         ; Bit 9
ATDDR2H_BIT10:      equ    2                                         ; Bit 10
ATDDR2H_BIT11:      equ    3                                         ; Bit 11
ATDDR2H_BIT12:      equ    4                                         ; Bit 12
ATDDR2H_BIT13:      equ    5                                         ; Bit 13
ATDDR2H_BIT14:      equ    6                                         ; Bit 14
ATDDR2H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR2H_BIT8:      equ    %00000001
mATDDR2H_BIT9:      equ    %00000010
mATDDR2H_BIT10:     equ    %00000100
mATDDR2H_BIT11:     equ    %00001000
mATDDR2H_BIT12:     equ    %00010000
mATDDR2H_BIT13:     equ    %00100000
mATDDR2H_BIT14:     equ    %01000000
mATDDR2H_BIT15:     equ    %10000000


;*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000095 ***
ATDDR2L:            equ    $00000095                                ;*** ATDDR2L - ATD  Conversion Result Register 2 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR2L_BIT0:       equ    0                                         ; Bit 0
ATDDR2L_BIT1:       equ    1                                         ; Bit 1
ATDDR2L_BIT2:       equ    2                                         ; Bit 2
ATDDR2L_BIT3:       equ    3                                         ; Bit 3
ATDDR2L_BIT4:       equ    4                                         ; Bit 4
ATDDR2L_BIT5:       equ    5                                         ; Bit 5
ATDDR2L_BIT6:       equ    6                                         ; Bit 6
ATDDR2L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR2L_BIT0:      equ    %00000001
mATDDR2L_BIT1:      equ    %00000010
mATDDR2L_BIT2:      equ    %00000100
mATDDR2L_BIT3:      equ    %00001000
mATDDR2L_BIT4:      equ    %00010000
mATDDR2L_BIT5:      equ    %00100000
mATDDR2L_BIT6:      equ    %01000000
mATDDR2L_BIT7:      equ    %10000000


;*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000096 ***
ATDDR3:             equ    $00000096                                ;*** ATDDR3 - ATD  Conversion Result Register 3; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3_BIT0:        equ    0                                         ; Bit 0
ATDDR3_BIT1:        equ    1                                         ; Bit 1
ATDDR3_BIT2:        equ    2                                         ; Bit 2
ATDDR3_BIT3:        equ    3                                         ; Bit 3
ATDDR3_BIT4:        equ    4                                         ; Bit 4
ATDDR3_BIT5:        equ    5                                         ; Bit 5
ATDDR3_BIT6:        equ    6                                         ; Bit 6
ATDDR3_BIT7:        equ    7                                         ; Bit 7
ATDDR3_BIT8:        equ    8                                         ; Bit 8
ATDDR3_BIT9:        equ    9                                         ; Bit 9
ATDDR3_BIT10:       equ    10                                        ; Bit 10
ATDDR3_BIT11:       equ    11                                        ; Bit 11
ATDDR3_BIT12:       equ    12                                        ; Bit 12
ATDDR3_BIT13:       equ    13                                        ; Bit 13
ATDDR3_BIT14:       equ    14                                        ; Bit 14
ATDDR3_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR3_BIT0:       equ    %00000001
mATDDR3_BIT1:       equ    %00000010
mATDDR3_BIT2:       equ    %00000100
mATDDR3_BIT3:       equ    %00001000
mATDDR3_BIT4:       equ    %00010000
mATDDR3_BIT5:       equ    %00100000
mATDDR3_BIT6:       equ    %01000000
mATDDR3_BIT7:       equ    %10000000
mATDDR3_BIT8:       equ    %100000000
mATDDR3_BIT9:       equ    %1000000000
mATDDR3_BIT10:      equ    %10000000000
mATDDR3_BIT11:      equ    %100000000000
mATDDR3_BIT12:      equ    %1000000000000
mATDDR3_BIT13:      equ    %10000000000000
mATDDR3_BIT14:      equ    %100000000000000
mATDDR3_BIT15:      equ    %1000000000000000


;*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000096 ***
ATDDR3H:            equ    $00000096                                ;*** ATDDR3H - ATD  Conversion Result Register 3 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3H_BIT8:       equ    0                                         ; Bit 8
ATDDR3H_BIT9:       equ    1                                         ; Bit 9
ATDDR3H_BIT10:      equ    2                                         ; Bit 10
ATDDR3H_BIT11:      equ    3                                         ; Bit 11
ATDDR3H_BIT12:      equ    4                                         ; Bit 12
ATDDR3H_BIT13:      equ    5                                         ; Bit 13
ATDDR3H_BIT14:      equ    6                                         ; Bit 14
ATDDR3H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR3H_BIT8:      equ    %00000001
mATDDR3H_BIT9:      equ    %00000010
mATDDR3H_BIT10:     equ    %00000100
mATDDR3H_BIT11:     equ    %00001000
mATDDR3H_BIT12:     equ    %00010000
mATDDR3H_BIT13:     equ    %00100000
mATDDR3H_BIT14:     equ    %01000000
mATDDR3H_BIT15:     equ    %10000000


;*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000097 ***
ATDDR3L:            equ    $00000097                                ;*** ATDDR3L - ATD  Conversion Result Register 3 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR3L_BIT0:       equ    0                                         ; Bit 0
ATDDR3L_BIT1:       equ    1                                         ; Bit 1
ATDDR3L_BIT2:       equ    2                                         ; Bit 2
ATDDR3L_BIT3:       equ    3                                         ; Bit 3
ATDDR3L_BIT4:       equ    4                                         ; Bit 4
ATDDR3L_BIT5:       equ    5                                         ; Bit 5
ATDDR3L_BIT6:       equ    6                                         ; Bit 6
ATDDR3L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR3L_BIT0:      equ    %00000001
mATDDR3L_BIT1:      equ    %00000010
mATDDR3L_BIT2:      equ    %00000100
mATDDR3L_BIT3:      equ    %00001000
mATDDR3L_BIT4:      equ    %00010000
mATDDR3L_BIT5:      equ    %00100000
mATDDR3L_BIT6:      equ    %01000000
mATDDR3L_BIT7:      equ    %10000000


;*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000098 ***
ATDDR4:             equ    $00000098                                ;*** ATDDR4 - ATD  Conversion Result Register 4; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4_BIT0:        equ    0                                         ; Bit 0
ATDDR4_BIT1:        equ    1                                         ; Bit 1
ATDDR4_BIT2:        equ    2                                         ; Bit 2
ATDDR4_BIT3:        equ    3                                         ; Bit 3
ATDDR4_BIT4:        equ    4                                         ; Bit 4
ATDDR4_BIT5:        equ    5                                         ; Bit 5
ATDDR4_BIT6:        equ    6                                         ; Bit 6
ATDDR4_BIT7:        equ    7                                         ; Bit 7
ATDDR4_BIT8:        equ    8                                         ; Bit 8
ATDDR4_BIT9:        equ    9                                         ; Bit 9
ATDDR4_BIT10:       equ    10                                        ; Bit 10
ATDDR4_BIT11:       equ    11                                        ; Bit 11
ATDDR4_BIT12:       equ    12                                        ; Bit 12
ATDDR4_BIT13:       equ    13                                        ; Bit 13
ATDDR4_BIT14:       equ    14                                        ; Bit 14
ATDDR4_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR4_BIT0:       equ    %00000001
mATDDR4_BIT1:       equ    %00000010
mATDDR4_BIT2:       equ    %00000100
mATDDR4_BIT3:       equ    %00001000
mATDDR4_BIT4:       equ    %00010000
mATDDR4_BIT5:       equ    %00100000
mATDDR4_BIT6:       equ    %01000000
mATDDR4_BIT7:       equ    %10000000
mATDDR4_BIT8:       equ    %100000000
mATDDR4_BIT9:       equ    %1000000000
mATDDR4_BIT10:      equ    %10000000000
mATDDR4_BIT11:      equ    %100000000000
mATDDR4_BIT12:      equ    %1000000000000
mATDDR4_BIT13:      equ    %10000000000000
mATDDR4_BIT14:      equ    %100000000000000
mATDDR4_BIT15:      equ    %1000000000000000


;*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000098 ***
ATDDR4H:            equ    $00000098                                ;*** ATDDR4H - ATD  Conversion Result Register 4 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4H_BIT8:       equ    0                                         ; Bit 8
ATDDR4H_BIT9:       equ    1                                         ; Bit 9
ATDDR4H_BIT10:      equ    2                                         ; Bit 10
ATDDR4H_BIT11:      equ    3                                         ; Bit 11
ATDDR4H_BIT12:      equ    4                                         ; Bit 12
ATDDR4H_BIT13:      equ    5                                         ; Bit 13
ATDDR4H_BIT14:      equ    6                                         ; Bit 14
ATDDR4H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR4H_BIT8:      equ    %00000001
mATDDR4H_BIT9:      equ    %00000010
mATDDR4H_BIT10:     equ    %00000100
mATDDR4H_BIT11:     equ    %00001000
mATDDR4H_BIT12:     equ    %00010000
mATDDR4H_BIT13:     equ    %00100000
mATDDR4H_BIT14:     equ    %01000000
mATDDR4H_BIT15:     equ    %10000000


;*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000099 ***
ATDDR4L:            equ    $00000099                                ;*** ATDDR4L - ATD  Conversion Result Register 4 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR4L_BIT0:       equ    0                                         ; Bit 0
ATDDR4L_BIT1:       equ    1                                         ; Bit 1
ATDDR4L_BIT2:       equ    2                                         ; Bit 2
ATDDR4L_BIT3:       equ    3                                         ; Bit 3
ATDDR4L_BIT4:       equ    4                                         ; Bit 4
ATDDR4L_BIT5:       equ    5                                         ; Bit 5
ATDDR4L_BIT6:       equ    6                                         ; Bit 6
ATDDR4L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR4L_BIT0:      equ    %00000001
mATDDR4L_BIT1:      equ    %00000010
mATDDR4L_BIT2:      equ    %00000100
mATDDR4L_BIT3:      equ    %00001000
mATDDR4L_BIT4:      equ    %00010000
mATDDR4L_BIT5:      equ    %00100000
mATDDR4L_BIT6:      equ    %01000000
mATDDR4L_BIT7:      equ    %10000000


;*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000009A ***
ATDDR5:             equ    $0000009A                                ;*** ATDDR5 - ATD  Conversion Result Register 5; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5_BIT0:        equ    0                                         ; Bit 0
ATDDR5_BIT1:        equ    1                                         ; Bit 1
ATDDR5_BIT2:        equ    2                                         ; Bit 2
ATDDR5_BIT3:        equ    3                                         ; Bit 3
ATDDR5_BIT4:        equ    4                                         ; Bit 4
ATDDR5_BIT5:        equ    5                                         ; Bit 5
ATDDR5_BIT6:        equ    6                                         ; Bit 6
ATDDR5_BIT7:        equ    7                                         ; Bit 7
ATDDR5_BIT8:        equ    8                                         ; Bit 8
ATDDR5_BIT9:        equ    9                                         ; Bit 9
ATDDR5_BIT10:       equ    10                                        ; Bit 10
ATDDR5_BIT11:       equ    11                                        ; Bit 11
ATDDR5_BIT12:       equ    12                                        ; Bit 12
ATDDR5_BIT13:       equ    13                                        ; Bit 13
ATDDR5_BIT14:       equ    14                                        ; Bit 14
ATDDR5_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR5_BIT0:       equ    %00000001
mATDDR5_BIT1:       equ    %00000010
mATDDR5_BIT2:       equ    %00000100
mATDDR5_BIT3:       equ    %00001000
mATDDR5_BIT4:       equ    %00010000
mATDDR5_BIT5:       equ    %00100000
mATDDR5_BIT6:       equ    %01000000
mATDDR5_BIT7:       equ    %10000000
mATDDR5_BIT8:       equ    %100000000
mATDDR5_BIT9:       equ    %1000000000
mATDDR5_BIT10:      equ    %10000000000
mATDDR5_BIT11:      equ    %100000000000
mATDDR5_BIT12:      equ    %1000000000000
mATDDR5_BIT13:      equ    %10000000000000
mATDDR5_BIT14:      equ    %100000000000000
mATDDR5_BIT15:      equ    %1000000000000000


;*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000009A ***
ATDDR5H:            equ    $0000009A                                ;*** ATDDR5H - ATD  Conversion Result Register 5 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5H_BIT8:       equ    0                                         ; Bit 8
ATDDR5H_BIT9:       equ    1                                         ; Bit 9
ATDDR5H_BIT10:      equ    2                                         ; Bit 10
ATDDR5H_BIT11:      equ    3                                         ; Bit 11
ATDDR5H_BIT12:      equ    4                                         ; Bit 12
ATDDR5H_BIT13:      equ    5                                         ; Bit 13
ATDDR5H_BIT14:      equ    6                                         ; Bit 14
ATDDR5H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR5H_BIT8:      equ    %00000001
mATDDR5H_BIT9:      equ    %00000010
mATDDR5H_BIT10:     equ    %00000100
mATDDR5H_BIT11:     equ    %00001000
mATDDR5H_BIT12:     equ    %00010000
mATDDR5H_BIT13:     equ    %00100000
mATDDR5H_BIT14:     equ    %01000000
mATDDR5H_BIT15:     equ    %10000000


;*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000009B ***
ATDDR5L:            equ    $0000009B                                ;*** ATDDR5L - ATD  Conversion Result Register 5 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR5L_BIT0:       equ    0                                         ; Bit 0
ATDDR5L_BIT1:       equ    1                                         ; Bit 1
ATDDR5L_BIT2:       equ    2                                         ; Bit 2
ATDDR5L_BIT3:       equ    3                                         ; Bit 3
ATDDR5L_BIT4:       equ    4                                         ; Bit 4
ATDDR5L_BIT5:       equ    5                                         ; Bit 5
ATDDR5L_BIT6:       equ    6                                         ; Bit 6
ATDDR5L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR5L_BIT0:      equ    %00000001
mATDDR5L_BIT1:      equ    %00000010
mATDDR5L_BIT2:      equ    %00000100
mATDDR5L_BIT3:      equ    %00001000
mATDDR5L_BIT4:      equ    %00010000
mATDDR5L_BIT5:      equ    %00100000
mATDDR5L_BIT6:      equ    %01000000
mATDDR5L_BIT7:      equ    %10000000


;*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000009C ***
ATDDR6:             equ    $0000009C                                ;*** ATDDR6 - ATD  Conversion Result Register 6; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6_BIT0:        equ    0                                         ; Bit 0
ATDDR6_BIT1:        equ    1                                         ; Bit 1
ATDDR6_BIT2:        equ    2                                         ; Bit 2
ATDDR6_BIT3:        equ    3                                         ; Bit 3
ATDDR6_BIT4:        equ    4                                         ; Bit 4
ATDDR6_BIT5:        equ    5                                         ; Bit 5
ATDDR6_BIT6:        equ    6                                         ; Bit 6
ATDDR6_BIT7:        equ    7                                         ; Bit 7
ATDDR6_BIT8:        equ    8                                         ; Bit 8
ATDDR6_BIT9:        equ    9                                         ; Bit 9
ATDDR6_BIT10:       equ    10                                        ; Bit 10
ATDDR6_BIT11:       equ    11                                        ; Bit 11
ATDDR6_BIT12:       equ    12                                        ; Bit 12
ATDDR6_BIT13:       equ    13                                        ; Bit 13
ATDDR6_BIT14:       equ    14                                        ; Bit 14
ATDDR6_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR6_BIT0:       equ    %00000001
mATDDR6_BIT1:       equ    %00000010
mATDDR6_BIT2:       equ    %00000100
mATDDR6_BIT3:       equ    %00001000
mATDDR6_BIT4:       equ    %00010000
mATDDR6_BIT5:       equ    %00100000
mATDDR6_BIT6:       equ    %01000000
mATDDR6_BIT7:       equ    %10000000
mATDDR6_BIT8:       equ    %100000000
mATDDR6_BIT9:       equ    %1000000000
mATDDR6_BIT10:      equ    %10000000000
mATDDR6_BIT11:      equ    %100000000000
mATDDR6_BIT12:      equ    %1000000000000
mATDDR6_BIT13:      equ    %10000000000000
mATDDR6_BIT14:      equ    %100000000000000
mATDDR6_BIT15:      equ    %1000000000000000


;*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000009C ***
ATDDR6H:            equ    $0000009C                                ;*** ATDDR6H - ATD  Conversion Result Register 6 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6H_BIT8:       equ    0                                         ; Bit 8
ATDDR6H_BIT9:       equ    1                                         ; Bit 9
ATDDR6H_BIT10:      equ    2                                         ; Bit 10
ATDDR6H_BIT11:      equ    3                                         ; Bit 11
ATDDR6H_BIT12:      equ    4                                         ; Bit 12
ATDDR6H_BIT13:      equ    5                                         ; Bit 13
ATDDR6H_BIT14:      equ    6                                         ; Bit 14
ATDDR6H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR6H_BIT8:      equ    %00000001
mATDDR6H_BIT9:      equ    %00000010
mATDDR6H_BIT10:     equ    %00000100
mATDDR6H_BIT11:     equ    %00001000
mATDDR6H_BIT12:     equ    %00010000
mATDDR6H_BIT13:     equ    %00100000
mATDDR6H_BIT14:     equ    %01000000
mATDDR6H_BIT15:     equ    %10000000


;*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000009D ***
ATDDR6L:            equ    $0000009D                                ;*** ATDDR6L - ATD  Conversion Result Register 6 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR6L_BIT0:       equ    0                                         ; Bit 0
ATDDR6L_BIT1:       equ    1                                         ; Bit 1
ATDDR6L_BIT2:       equ    2                                         ; Bit 2
ATDDR6L_BIT3:       equ    3                                         ; Bit 3
ATDDR6L_BIT4:       equ    4                                         ; Bit 4
ATDDR6L_BIT5:       equ    5                                         ; Bit 5
ATDDR6L_BIT6:       equ    6                                         ; Bit 6
ATDDR6L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR6L_BIT0:      equ    %00000001
mATDDR6L_BIT1:      equ    %00000010
mATDDR6L_BIT2:      equ    %00000100
mATDDR6L_BIT3:      equ    %00001000
mATDDR6L_BIT4:      equ    %00010000
mATDDR6L_BIT5:      equ    %00100000
mATDDR6L_BIT6:      equ    %01000000
mATDDR6L_BIT7:      equ    %10000000


;*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000009E ***
ATDDR7:             equ    $0000009E                                ;*** ATDDR7 - ATD  Conversion Result Register 7; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7_BIT0:        equ    0                                         ; Bit 0
ATDDR7_BIT1:        equ    1                                         ; Bit 1
ATDDR7_BIT2:        equ    2                                         ; Bit 2
ATDDR7_BIT3:        equ    3                                         ; Bit 3
ATDDR7_BIT4:        equ    4                                         ; Bit 4
ATDDR7_BIT5:        equ    5                                         ; Bit 5
ATDDR7_BIT6:        equ    6                                         ; Bit 6
ATDDR7_BIT7:        equ    7                                         ; Bit 7
ATDDR7_BIT8:        equ    8                                         ; Bit 8
ATDDR7_BIT9:        equ    9                                         ; Bit 9
ATDDR7_BIT10:       equ    10                                        ; Bit 10
ATDDR7_BIT11:       equ    11                                        ; Bit 11
ATDDR7_BIT12:       equ    12                                        ; Bit 12
ATDDR7_BIT13:       equ    13                                        ; Bit 13
ATDDR7_BIT14:       equ    14                                        ; Bit 14
ATDDR7_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR7_BIT0:       equ    %00000001
mATDDR7_BIT1:       equ    %00000010
mATDDR7_BIT2:       equ    %00000100
mATDDR7_BIT3:       equ    %00001000
mATDDR7_BIT4:       equ    %00010000
mATDDR7_BIT5:       equ    %00100000
mATDDR7_BIT6:       equ    %01000000
mATDDR7_BIT7:       equ    %10000000
mATDDR7_BIT8:       equ    %100000000
mATDDR7_BIT9:       equ    %1000000000
mATDDR7_BIT10:      equ    %10000000000
mATDDR7_BIT11:      equ    %100000000000
mATDDR7_BIT12:      equ    %1000000000000
mATDDR7_BIT13:      equ    %10000000000000
mATDDR7_BIT14:      equ    %100000000000000
mATDDR7_BIT15:      equ    %1000000000000000


;*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000009E ***
ATDDR7H:            equ    $0000009E                                ;*** ATDDR7H - ATD  Conversion Result Register 7 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7H_BIT8:       equ    0                                         ; Bit 8
ATDDR7H_BIT9:       equ    1                                         ; Bit 9
ATDDR7H_BIT10:      equ    2                                         ; Bit 10
ATDDR7H_BIT11:      equ    3                                         ; Bit 11
ATDDR7H_BIT12:      equ    4                                         ; Bit 12
ATDDR7H_BIT13:      equ    5                                         ; Bit 13
ATDDR7H_BIT14:      equ    6                                         ; Bit 14
ATDDR7H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR7H_BIT8:      equ    %00000001
mATDDR7H_BIT9:      equ    %00000010
mATDDR7H_BIT10:     equ    %00000100
mATDDR7H_BIT11:     equ    %00001000
mATDDR7H_BIT12:     equ    %00010000
mATDDR7H_BIT13:     equ    %00100000
mATDDR7H_BIT14:     equ    %01000000
mATDDR7H_BIT15:     equ    %10000000


;*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000009F ***
ATDDR7L:            equ    $0000009F                                ;*** ATDDR7L - ATD  Conversion Result Register 7 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR7L_BIT0:       equ    0                                         ; Bit 0
ATDDR7L_BIT1:       equ    1                                         ; Bit 1
ATDDR7L_BIT2:       equ    2                                         ; Bit 2
ATDDR7L_BIT3:       equ    3                                         ; Bit 3
ATDDR7L_BIT4:       equ    4                                         ; Bit 4
ATDDR7L_BIT5:       equ    5                                         ; Bit 5
ATDDR7L_BIT6:       equ    6                                         ; Bit 6
ATDDR7L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR7L_BIT0:      equ    %00000001
mATDDR7L_BIT1:      equ    %00000010
mATDDR7L_BIT2:      equ    %00000100
mATDDR7L_BIT3:      equ    %00001000
mATDDR7L_BIT4:      equ    %00010000
mATDDR7L_BIT5:      equ    %00100000
mATDDR7L_BIT6:      equ    %01000000
mATDDR7L_BIT7:      equ    %10000000


;*** ATDDR8 - ATD  Conversion Result Register 8; 0x000000A0 ***
ATDDR8:             equ    $000000A0                                ;*** ATDDR8 - ATD  Conversion Result Register 8; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8_BIT0:        equ    0                                         ; Bit 0
ATDDR8_BIT1:        equ    1                                         ; Bit 1
ATDDR8_BIT2:        equ    2                                         ; Bit 2
ATDDR8_BIT3:        equ    3                                         ; Bit 3
ATDDR8_BIT4:        equ    4                                         ; Bit 4
ATDDR8_BIT5:        equ    5                                         ; Bit 5
ATDDR8_BIT6:        equ    6                                         ; Bit 6
ATDDR8_BIT7:        equ    7                                         ; Bit 7
ATDDR8_BIT8:        equ    8                                         ; Bit 8
ATDDR8_BIT9:        equ    9                                         ; Bit 9
ATDDR8_BIT10:       equ    10                                        ; Bit 10
ATDDR8_BIT11:       equ    11                                        ; Bit 11
ATDDR8_BIT12:       equ    12                                        ; Bit 12
ATDDR8_BIT13:       equ    13                                        ; Bit 13
ATDDR8_BIT14:       equ    14                                        ; Bit 14
ATDDR8_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR8_BIT0:       equ    %00000001
mATDDR8_BIT1:       equ    %00000010
mATDDR8_BIT2:       equ    %00000100
mATDDR8_BIT3:       equ    %00001000
mATDDR8_BIT4:       equ    %00010000
mATDDR8_BIT5:       equ    %00100000
mATDDR8_BIT6:       equ    %01000000
mATDDR8_BIT7:       equ    %10000000
mATDDR8_BIT8:       equ    %100000000
mATDDR8_BIT9:       equ    %1000000000
mATDDR8_BIT10:      equ    %10000000000
mATDDR8_BIT11:      equ    %100000000000
mATDDR8_BIT12:      equ    %1000000000000
mATDDR8_BIT13:      equ    %10000000000000
mATDDR8_BIT14:      equ    %100000000000000
mATDDR8_BIT15:      equ    %1000000000000000


;*** ATDDR8H - ATD  Conversion Result Register 8 High; 0x000000A0 ***
ATDDR8H:            equ    $000000A0                                ;*** ATDDR8H - ATD  Conversion Result Register 8 High; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8H_BIT8:       equ    0                                         ; Bit 8
ATDDR8H_BIT9:       equ    1                                         ; Bit 9
ATDDR8H_BIT10:      equ    2                                         ; Bit 10
ATDDR8H_BIT11:      equ    3                                         ; Bit 11
ATDDR8H_BIT12:      equ    4                                         ; Bit 12
ATDDR8H_BIT13:      equ    5                                         ; Bit 13
ATDDR8H_BIT14:      equ    6                                         ; Bit 14
ATDDR8H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR8H_BIT8:      equ    %00000001
mATDDR8H_BIT9:      equ    %00000010
mATDDR8H_BIT10:     equ    %00000100
mATDDR8H_BIT11:     equ    %00001000
mATDDR8H_BIT12:     equ    %00010000
mATDDR8H_BIT13:     equ    %00100000
mATDDR8H_BIT14:     equ    %01000000
mATDDR8H_BIT15:     equ    %10000000


;*** ATDDR8L - ATD  Conversion Result Register 8 Low; 0x000000A1 ***
ATDDR8L:            equ    $000000A1                                ;*** ATDDR8L - ATD  Conversion Result Register 8 Low; 0x000000A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR8L_BIT0:       equ    0                                         ; Bit 0
ATDDR8L_BIT1:       equ    1                                         ; Bit 1
ATDDR8L_BIT2:       equ    2                                         ; Bit 2
ATDDR8L_BIT3:       equ    3                                         ; Bit 3
ATDDR8L_BIT4:       equ    4                                         ; Bit 4
ATDDR8L_BIT5:       equ    5                                         ; Bit 5
ATDDR8L_BIT6:       equ    6                                         ; Bit 6
ATDDR8L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR8L_BIT0:      equ    %00000001
mATDDR8L_BIT1:      equ    %00000010
mATDDR8L_BIT2:      equ    %00000100
mATDDR8L_BIT3:      equ    %00001000
mATDDR8L_BIT4:      equ    %00010000
mATDDR8L_BIT5:      equ    %00100000
mATDDR8L_BIT6:      equ    %01000000
mATDDR8L_BIT7:      equ    %10000000


;*** ATDDR9 - ATD  Conversion Result Register 9; 0x000000A2 ***
ATDDR9:             equ    $000000A2                                ;*** ATDDR9 - ATD  Conversion Result Register 9; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9_BIT0:        equ    0                                         ; Bit 0
ATDDR9_BIT1:        equ    1                                         ; Bit 1
ATDDR9_BIT2:        equ    2                                         ; Bit 2
ATDDR9_BIT3:        equ    3                                         ; Bit 3
ATDDR9_BIT4:        equ    4                                         ; Bit 4
ATDDR9_BIT5:        equ    5                                         ; Bit 5
ATDDR9_BIT6:        equ    6                                         ; Bit 6
ATDDR9_BIT7:        equ    7                                         ; Bit 7
ATDDR9_BIT8:        equ    8                                         ; Bit 8
ATDDR9_BIT9:        equ    9                                         ; Bit 9
ATDDR9_BIT10:       equ    10                                        ; Bit 10
ATDDR9_BIT11:       equ    11                                        ; Bit 11
ATDDR9_BIT12:       equ    12                                        ; Bit 12
ATDDR9_BIT13:       equ    13                                        ; Bit 13
ATDDR9_BIT14:       equ    14                                        ; Bit 14
ATDDR9_BIT15:       equ    15                                        ; Bit 15
; bit position masks
mATDDR9_BIT0:       equ    %00000001
mATDDR9_BIT1:       equ    %00000010
mATDDR9_BIT2:       equ    %00000100
mATDDR9_BIT3:       equ    %00001000
mATDDR9_BIT4:       equ    %00010000
mATDDR9_BIT5:       equ    %00100000
mATDDR9_BIT6:       equ    %01000000
mATDDR9_BIT7:       equ    %10000000
mATDDR9_BIT8:       equ    %100000000
mATDDR9_BIT9:       equ    %1000000000
mATDDR9_BIT10:      equ    %10000000000
mATDDR9_BIT11:      equ    %100000000000
mATDDR9_BIT12:      equ    %1000000000000
mATDDR9_BIT13:      equ    %10000000000000
mATDDR9_BIT14:      equ    %100000000000000
mATDDR9_BIT15:      equ    %1000000000000000


;*** ATDDR9H - ATD  Conversion Result Register 9 High; 0x000000A2 ***
ATDDR9H:            equ    $000000A2                                ;*** ATDDR9H - ATD  Conversion Result Register 9 High; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9H_BIT8:       equ    0                                         ; Bit 8
ATDDR9H_BIT9:       equ    1                                         ; Bit 9
ATDDR9H_BIT10:      equ    2                                         ; Bit 10
ATDDR9H_BIT11:      equ    3                                         ; Bit 11
ATDDR9H_BIT12:      equ    4                                         ; Bit 12
ATDDR9H_BIT13:      equ    5                                         ; Bit 13
ATDDR9H_BIT14:      equ    6                                         ; Bit 14
ATDDR9H_BIT15:      equ    7                                         ; Bit 15
; bit position masks
mATDDR9H_BIT8:      equ    %00000001
mATDDR9H_BIT9:      equ    %00000010
mATDDR9H_BIT10:     equ    %00000100
mATDDR9H_BIT11:     equ    %00001000
mATDDR9H_BIT12:     equ    %00010000
mATDDR9H_BIT13:     equ    %00100000
mATDDR9H_BIT14:     equ    %01000000
mATDDR9H_BIT15:     equ    %10000000


;*** ATDDR9L - ATD  Conversion Result Register 9 Low; 0x000000A3 ***
ATDDR9L:            equ    $000000A3                                ;*** ATDDR9L - ATD  Conversion Result Register 9 Low; 0x000000A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR9L_BIT0:       equ    0                                         ; Bit 0
ATDDR9L_BIT1:       equ    1                                         ; Bit 1
ATDDR9L_BIT2:       equ    2                                         ; Bit 2
ATDDR9L_BIT3:       equ    3                                         ; Bit 3
ATDDR9L_BIT4:       equ    4                                         ; Bit 4
ATDDR9L_BIT5:       equ    5                                         ; Bit 5
ATDDR9L_BIT6:       equ    6                                         ; Bit 6
ATDDR9L_BIT7:       equ    7                                         ; Bit 7
; bit position masks
mATDDR9L_BIT0:      equ    %00000001
mATDDR9L_BIT1:      equ    %00000010
mATDDR9L_BIT2:      equ    %00000100
mATDDR9L_BIT3:      equ    %00001000
mATDDR9L_BIT4:      equ    %00010000
mATDDR9L_BIT5:      equ    %00100000
mATDDR9L_BIT6:      equ    %01000000
mATDDR9L_BIT7:      equ    %10000000


;*** ATDDR10 - ATD  Conversion Result Register 10; 0x000000A4 ***
ATDDR10:            equ    $000000A4                                ;*** ATDDR10 - ATD  Conversion Result Register 10; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10_BIT0:       equ    0                                         ; Bit 0
ATDDR10_BIT1:       equ    1                                         ; Bit 1
ATDDR10_BIT2:       equ    2                                         ; Bit 2
ATDDR10_BIT3:       equ    3                                         ; Bit 3
ATDDR10_BIT4:       equ    4                                         ; Bit 4
ATDDR10_BIT5:       equ    5                                         ; Bit 5
ATDDR10_BIT6:       equ    6                                         ; Bit 6
ATDDR10_BIT7:       equ    7                                         ; Bit 7
ATDDR10_BIT8:       equ    8                                         ; Bit 8
ATDDR10_BIT9:       equ    9                                         ; Bit 9
ATDDR10_BIT10:      equ    10                                        ; Bit 10
ATDDR10_BIT11:      equ    11                                        ; Bit 11
ATDDR10_BIT12:      equ    12                                        ; Bit 12
ATDDR10_BIT13:      equ    13                                        ; Bit 13
ATDDR10_BIT14:      equ    14                                        ; Bit 14
ATDDR10_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR10_BIT0:      equ    %00000001
mATDDR10_BIT1:      equ    %00000010
mATDDR10_BIT2:      equ    %00000100
mATDDR10_BIT3:      equ    %00001000
mATDDR10_BIT4:      equ    %00010000
mATDDR10_BIT5:      equ    %00100000
mATDDR10_BIT6:      equ    %01000000
mATDDR10_BIT7:      equ    %10000000
mATDDR10_BIT8:      equ    %100000000
mATDDR10_BIT9:      equ    %1000000000
mATDDR10_BIT10:     equ    %10000000000
mATDDR10_BIT11:     equ    %100000000000
mATDDR10_BIT12:     equ    %1000000000000
mATDDR10_BIT13:     equ    %10000000000000
mATDDR10_BIT14:     equ    %100000000000000
mATDDR10_BIT15:     equ    %1000000000000000


;*** ATDDR10H - ATD  Conversion Result Register 10 High; 0x000000A4 ***
ATDDR10H:           equ    $000000A4                                ;*** ATDDR10H - ATD  Conversion Result Register 10 High; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10H_BIT8:      equ    0                                         ; Bit 8
ATDDR10H_BIT9:      equ    1                                         ; Bit 9
ATDDR10H_BIT10:     equ    2                                         ; Bit 10
ATDDR10H_BIT11:     equ    3                                         ; Bit 11
ATDDR10H_BIT12:     equ    4                                         ; Bit 12
ATDDR10H_BIT13:     equ    5                                         ; Bit 13
ATDDR10H_BIT14:     equ    6                                         ; Bit 14
ATDDR10H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR10H_BIT8:     equ    %00000001
mATDDR10H_BIT9:     equ    %00000010
mATDDR10H_BIT10:    equ    %00000100
mATDDR10H_BIT11:    equ    %00001000
mATDDR10H_BIT12:    equ    %00010000
mATDDR10H_BIT13:    equ    %00100000
mATDDR10H_BIT14:    equ    %01000000
mATDDR10H_BIT15:    equ    %10000000


;*** ATDDR10L - ATD  Conversion Result Register 10 Low; 0x000000A5 ***
ATDDR10L:           equ    $000000A5                                ;*** ATDDR10L - ATD  Conversion Result Register 10 Low; 0x000000A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR10L_BIT0:      equ    0                                         ; Bit 0
ATDDR10L_BIT1:      equ    1                                         ; Bit 1
ATDDR10L_BIT2:      equ    2                                         ; Bit 2
ATDDR10L_BIT3:      equ    3                                         ; Bit 3
ATDDR10L_BIT4:      equ    4                                         ; Bit 4
ATDDR10L_BIT5:      equ    5                                         ; Bit 5
ATDDR10L_BIT6:      equ    6                                         ; Bit 6
ATDDR10L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR10L_BIT0:     equ    %00000001
mATDDR10L_BIT1:     equ    %00000010
mATDDR10L_BIT2:     equ    %00000100
mATDDR10L_BIT3:     equ    %00001000
mATDDR10L_BIT4:     equ    %00010000
mATDDR10L_BIT5:     equ    %00100000
mATDDR10L_BIT6:     equ    %01000000
mATDDR10L_BIT7:     equ    %10000000


;*** ATDDR11 - ATD  Conversion Result Register 11; 0x000000A6 ***
ATDDR11:            equ    $000000A6                                ;*** ATDDR11 - ATD  Conversion Result Register 11; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11_BIT0:       equ    0                                         ; Bit 0
ATDDR11_BIT1:       equ    1                                         ; Bit 1
ATDDR11_BIT2:       equ    2                                         ; Bit 2
ATDDR11_BIT3:       equ    3                                         ; Bit 3
ATDDR11_BIT4:       equ    4                                         ; Bit 4
ATDDR11_BIT5:       equ    5                                         ; Bit 5
ATDDR11_BIT6:       equ    6                                         ; Bit 6
ATDDR11_BIT7:       equ    7                                         ; Bit 7
ATDDR11_BIT8:       equ    8                                         ; Bit 8
ATDDR11_BIT9:       equ    9                                         ; Bit 9
ATDDR11_BIT10:      equ    10                                        ; Bit 10
ATDDR11_BIT11:      equ    11                                        ; Bit 11
ATDDR11_BIT12:      equ    12                                        ; Bit 12
ATDDR11_BIT13:      equ    13                                        ; Bit 13
ATDDR11_BIT14:      equ    14                                        ; Bit 14
ATDDR11_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR11_BIT0:      equ    %00000001
mATDDR11_BIT1:      equ    %00000010
mATDDR11_BIT2:      equ    %00000100
mATDDR11_BIT3:      equ    %00001000
mATDDR11_BIT4:      equ    %00010000
mATDDR11_BIT5:      equ    %00100000
mATDDR11_BIT6:      equ    %01000000
mATDDR11_BIT7:      equ    %10000000
mATDDR11_BIT8:      equ    %100000000
mATDDR11_BIT9:      equ    %1000000000
mATDDR11_BIT10:     equ    %10000000000
mATDDR11_BIT11:     equ    %100000000000
mATDDR11_BIT12:     equ    %1000000000000
mATDDR11_BIT13:     equ    %10000000000000
mATDDR11_BIT14:     equ    %100000000000000
mATDDR11_BIT15:     equ    %1000000000000000


;*** ATDDR11H - ATD  Conversion Result Register 11 High; 0x000000A6 ***
ATDDR11H:           equ    $000000A6                                ;*** ATDDR11H - ATD  Conversion Result Register 11 High; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11H_BIT8:      equ    0                                         ; Bit 8
ATDDR11H_BIT9:      equ    1                                         ; Bit 9
ATDDR11H_BIT10:     equ    2                                         ; Bit 10
ATDDR11H_BIT11:     equ    3                                         ; Bit 11
ATDDR11H_BIT12:     equ    4                                         ; Bit 12
ATDDR11H_BIT13:     equ    5                                         ; Bit 13
ATDDR11H_BIT14:     equ    6                                         ; Bit 14
ATDDR11H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR11H_BIT8:     equ    %00000001
mATDDR11H_BIT9:     equ    %00000010
mATDDR11H_BIT10:    equ    %00000100
mATDDR11H_BIT11:    equ    %00001000
mATDDR11H_BIT12:    equ    %00010000
mATDDR11H_BIT13:    equ    %00100000
mATDDR11H_BIT14:    equ    %01000000
mATDDR11H_BIT15:    equ    %10000000


;*** ATDDR11L - ATD  Conversion Result Register 11 Low; 0x000000A7 ***
ATDDR11L:           equ    $000000A7                                ;*** ATDDR11L - ATD  Conversion Result Register 11 Low; 0x000000A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR11L_BIT0:      equ    0                                         ; Bit 0
ATDDR11L_BIT1:      equ    1                                         ; Bit 1
ATDDR11L_BIT2:      equ    2                                         ; Bit 2
ATDDR11L_BIT3:      equ    3                                         ; Bit 3
ATDDR11L_BIT4:      equ    4                                         ; Bit 4
ATDDR11L_BIT5:      equ    5                                         ; Bit 5
ATDDR11L_BIT6:      equ    6                                         ; Bit 6
ATDDR11L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR11L_BIT0:     equ    %00000001
mATDDR11L_BIT1:     equ    %00000010
mATDDR11L_BIT2:     equ    %00000100
mATDDR11L_BIT3:     equ    %00001000
mATDDR11L_BIT4:     equ    %00010000
mATDDR11L_BIT5:     equ    %00100000
mATDDR11L_BIT6:     equ    %01000000
mATDDR11L_BIT7:     equ    %10000000


;*** ATDDR12 - ATD  Conversion Result Register 12; 0x000000A8 ***
ATDDR12:            equ    $000000A8                                ;*** ATDDR12 - ATD  Conversion Result Register 12; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12_BIT0:       equ    0                                         ; Bit 0
ATDDR12_BIT1:       equ    1                                         ; Bit 1
ATDDR12_BIT2:       equ    2                                         ; Bit 2
ATDDR12_BIT3:       equ    3                                         ; Bit 3
ATDDR12_BIT4:       equ    4                                         ; Bit 4
ATDDR12_BIT5:       equ    5                                         ; Bit 5
ATDDR12_BIT6:       equ    6                                         ; Bit 6
ATDDR12_BIT7:       equ    7                                         ; Bit 7
ATDDR12_BIT8:       equ    8                                         ; Bit 8
ATDDR12_BIT9:       equ    9                                         ; Bit 9
ATDDR12_BIT10:      equ    10                                        ; Bit 10
ATDDR12_BIT11:      equ    11                                        ; Bit 11
ATDDR12_BIT12:      equ    12                                        ; Bit 12
ATDDR12_BIT13:      equ    13                                        ; Bit 13
ATDDR12_BIT14:      equ    14                                        ; Bit 14
ATDDR12_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR12_BIT0:      equ    %00000001
mATDDR12_BIT1:      equ    %00000010
mATDDR12_BIT2:      equ    %00000100
mATDDR12_BIT3:      equ    %00001000
mATDDR12_BIT4:      equ    %00010000
mATDDR12_BIT5:      equ    %00100000
mATDDR12_BIT6:      equ    %01000000
mATDDR12_BIT7:      equ    %10000000
mATDDR12_BIT8:      equ    %100000000
mATDDR12_BIT9:      equ    %1000000000
mATDDR12_BIT10:     equ    %10000000000
mATDDR12_BIT11:     equ    %100000000000
mATDDR12_BIT12:     equ    %1000000000000
mATDDR12_BIT13:     equ    %10000000000000
mATDDR12_BIT14:     equ    %100000000000000
mATDDR12_BIT15:     equ    %1000000000000000


;*** ATDDR12H - ATD  Conversion Result Register 12 High; 0x000000A8 ***
ATDDR12H:           equ    $000000A8                                ;*** ATDDR12H - ATD  Conversion Result Register 12 High; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12H_BIT8:      equ    0                                         ; Bit 8
ATDDR12H_BIT9:      equ    1                                         ; Bit 9
ATDDR12H_BIT10:     equ    2                                         ; Bit 10
ATDDR12H_BIT11:     equ    3                                         ; Bit 11
ATDDR12H_BIT12:     equ    4                                         ; Bit 12
ATDDR12H_BIT13:     equ    5                                         ; Bit 13
ATDDR12H_BIT14:     equ    6                                         ; Bit 14
ATDDR12H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR12H_BIT8:     equ    %00000001
mATDDR12H_BIT9:     equ    %00000010
mATDDR12H_BIT10:    equ    %00000100
mATDDR12H_BIT11:    equ    %00001000
mATDDR12H_BIT12:    equ    %00010000
mATDDR12H_BIT13:    equ    %00100000
mATDDR12H_BIT14:    equ    %01000000
mATDDR12H_BIT15:    equ    %10000000


;*** ATDDR12L - ATD  Conversion Result Register 12 Low; 0x000000A9 ***
ATDDR12L:           equ    $000000A9                                ;*** ATDDR12L - ATD  Conversion Result Register 12 Low; 0x000000A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR12L_BIT0:      equ    0                                         ; Bit 0
ATDDR12L_BIT1:      equ    1                                         ; Bit 1
ATDDR12L_BIT2:      equ    2                                         ; Bit 2
ATDDR12L_BIT3:      equ    3                                         ; Bit 3
ATDDR12L_BIT4:      equ    4                                         ; Bit 4
ATDDR12L_BIT5:      equ    5                                         ; Bit 5
ATDDR12L_BIT6:      equ    6                                         ; Bit 6
ATDDR12L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR12L_BIT0:     equ    %00000001
mATDDR12L_BIT1:     equ    %00000010
mATDDR12L_BIT2:     equ    %00000100
mATDDR12L_BIT3:     equ    %00001000
mATDDR12L_BIT4:     equ    %00010000
mATDDR12L_BIT5:     equ    %00100000
mATDDR12L_BIT6:     equ    %01000000
mATDDR12L_BIT7:     equ    %10000000


;*** ATDDR13 - ATD  Conversion Result Register 13; 0x000000AA ***
ATDDR13:            equ    $000000AA                                ;*** ATDDR13 - ATD  Conversion Result Register 13; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13_BIT0:       equ    0                                         ; Bit 0
ATDDR13_BIT1:       equ    1                                         ; Bit 1
ATDDR13_BIT2:       equ    2                                         ; Bit 2
ATDDR13_BIT3:       equ    3                                         ; Bit 3
ATDDR13_BIT4:       equ    4                                         ; Bit 4
ATDDR13_BIT5:       equ    5                                         ; Bit 5
ATDDR13_BIT6:       equ    6                                         ; Bit 6
ATDDR13_BIT7:       equ    7                                         ; Bit 7
ATDDR13_BIT8:       equ    8                                         ; Bit 8
ATDDR13_BIT9:       equ    9                                         ; Bit 9
ATDDR13_BIT10:      equ    10                                        ; Bit 10
ATDDR13_BIT11:      equ    11                                        ; Bit 11
ATDDR13_BIT12:      equ    12                                        ; Bit 12
ATDDR13_BIT13:      equ    13                                        ; Bit 13
ATDDR13_BIT14:      equ    14                                        ; Bit 14
ATDDR13_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR13_BIT0:      equ    %00000001
mATDDR13_BIT1:      equ    %00000010
mATDDR13_BIT2:      equ    %00000100
mATDDR13_BIT3:      equ    %00001000
mATDDR13_BIT4:      equ    %00010000
mATDDR13_BIT5:      equ    %00100000
mATDDR13_BIT6:      equ    %01000000
mATDDR13_BIT7:      equ    %10000000
mATDDR13_BIT8:      equ    %100000000
mATDDR13_BIT9:      equ    %1000000000
mATDDR13_BIT10:     equ    %10000000000
mATDDR13_BIT11:     equ    %100000000000
mATDDR13_BIT12:     equ    %1000000000000
mATDDR13_BIT13:     equ    %10000000000000
mATDDR13_BIT14:     equ    %100000000000000
mATDDR13_BIT15:     equ    %1000000000000000


;*** ATDDR13H - ATD  Conversion Result Register 13 High; 0x000000AA ***
ATDDR13H:           equ    $000000AA                                ;*** ATDDR13H - ATD  Conversion Result Register 13 High; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13H_BIT8:      equ    0                                         ; Bit 8
ATDDR13H_BIT9:      equ    1                                         ; Bit 9
ATDDR13H_BIT10:     equ    2                                         ; Bit 10
ATDDR13H_BIT11:     equ    3                                         ; Bit 11
ATDDR13H_BIT12:     equ    4                                         ; Bit 12
ATDDR13H_BIT13:     equ    5                                         ; Bit 13
ATDDR13H_BIT14:     equ    6                                         ; Bit 14
ATDDR13H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR13H_BIT8:     equ    %00000001
mATDDR13H_BIT9:     equ    %00000010
mATDDR13H_BIT10:    equ    %00000100
mATDDR13H_BIT11:    equ    %00001000
mATDDR13H_BIT12:    equ    %00010000
mATDDR13H_BIT13:    equ    %00100000
mATDDR13H_BIT14:    equ    %01000000
mATDDR13H_BIT15:    equ    %10000000


;*** ATDDR13L - ATD  Conversion Result Register 13 Low; 0x000000AB ***
ATDDR13L:           equ    $000000AB                                ;*** ATDDR13L - ATD  Conversion Result Register 13 Low; 0x000000AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR13L_BIT0:      equ    0                                         ; Bit 0
ATDDR13L_BIT1:      equ    1                                         ; Bit 1
ATDDR13L_BIT2:      equ    2                                         ; Bit 2
ATDDR13L_BIT3:      equ    3                                         ; Bit 3
ATDDR13L_BIT4:      equ    4                                         ; Bit 4
ATDDR13L_BIT5:      equ    5                                         ; Bit 5
ATDDR13L_BIT6:      equ    6                                         ; Bit 6
ATDDR13L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR13L_BIT0:     equ    %00000001
mATDDR13L_BIT1:     equ    %00000010
mATDDR13L_BIT2:     equ    %00000100
mATDDR13L_BIT3:     equ    %00001000
mATDDR13L_BIT4:     equ    %00010000
mATDDR13L_BIT5:     equ    %00100000
mATDDR13L_BIT6:     equ    %01000000
mATDDR13L_BIT7:     equ    %10000000


;*** ATDDR14 - ATD  Conversion Result Register 14; 0x000000AC ***
ATDDR14:            equ    $000000AC                                ;*** ATDDR14 - ATD  Conversion Result Register 14; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14_BIT0:       equ    0                                         ; Bit 0
ATDDR14_BIT1:       equ    1                                         ; Bit 1
ATDDR14_BIT2:       equ    2                                         ; Bit 2
ATDDR14_BIT3:       equ    3                                         ; Bit 3
ATDDR14_BIT4:       equ    4                                         ; Bit 4
ATDDR14_BIT5:       equ    5                                         ; Bit 5
ATDDR14_BIT6:       equ    6                                         ; Bit 6
ATDDR14_BIT7:       equ    7                                         ; Bit 7
ATDDR14_BIT8:       equ    8                                         ; Bit 8
ATDDR14_BIT9:       equ    9                                         ; Bit 9
ATDDR14_BIT10:      equ    10                                        ; Bit 10
ATDDR14_BIT11:      equ    11                                        ; Bit 11
ATDDR14_BIT12:      equ    12                                        ; Bit 12
ATDDR14_BIT13:      equ    13                                        ; Bit 13
ATDDR14_BIT14:      equ    14                                        ; Bit 14
ATDDR14_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR14_BIT0:      equ    %00000001
mATDDR14_BIT1:      equ    %00000010
mATDDR14_BIT2:      equ    %00000100
mATDDR14_BIT3:      equ    %00001000
mATDDR14_BIT4:      equ    %00010000
mATDDR14_BIT5:      equ    %00100000
mATDDR14_BIT6:      equ    %01000000
mATDDR14_BIT7:      equ    %10000000
mATDDR14_BIT8:      equ    %100000000
mATDDR14_BIT9:      equ    %1000000000
mATDDR14_BIT10:     equ    %10000000000
mATDDR14_BIT11:     equ    %100000000000
mATDDR14_BIT12:     equ    %1000000000000
mATDDR14_BIT13:     equ    %10000000000000
mATDDR14_BIT14:     equ    %100000000000000
mATDDR14_BIT15:     equ    %1000000000000000


;*** ATDDR14H - ATD  Conversion Result Register 14 High; 0x000000AC ***
ATDDR14H:           equ    $000000AC                                ;*** ATDDR14H - ATD  Conversion Result Register 14 High; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14H_BIT8:      equ    0                                         ; Bit 8
ATDDR14H_BIT9:      equ    1                                         ; Bit 9
ATDDR14H_BIT10:     equ    2                                         ; Bit 10
ATDDR14H_BIT11:     equ    3                                         ; Bit 11
ATDDR14H_BIT12:     equ    4                                         ; Bit 12
ATDDR14H_BIT13:     equ    5                                         ; Bit 13
ATDDR14H_BIT14:     equ    6                                         ; Bit 14
ATDDR14H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR14H_BIT8:     equ    %00000001
mATDDR14H_BIT9:     equ    %00000010
mATDDR14H_BIT10:    equ    %00000100
mATDDR14H_BIT11:    equ    %00001000
mATDDR14H_BIT12:    equ    %00010000
mATDDR14H_BIT13:    equ    %00100000
mATDDR14H_BIT14:    equ    %01000000
mATDDR14H_BIT15:    equ    %10000000


;*** ATDDR14L - ATD  Conversion Result Register 14 Low; 0x000000AD ***
ATDDR14L:           equ    $000000AD                                ;*** ATDDR14L - ATD  Conversion Result Register 14 Low; 0x000000AD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR14L_BIT0:      equ    0                                         ; Bit 0
ATDDR14L_BIT1:      equ    1                                         ; Bit 1
ATDDR14L_BIT2:      equ    2                                         ; Bit 2
ATDDR14L_BIT3:      equ    3                                         ; Bit 3
ATDDR14L_BIT4:      equ    4                                         ; Bit 4
ATDDR14L_BIT5:      equ    5                                         ; Bit 5
ATDDR14L_BIT6:      equ    6                                         ; Bit 6
ATDDR14L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR14L_BIT0:     equ    %00000001
mATDDR14L_BIT1:     equ    %00000010
mATDDR14L_BIT2:     equ    %00000100
mATDDR14L_BIT3:     equ    %00001000
mATDDR14L_BIT4:     equ    %00010000
mATDDR14L_BIT5:     equ    %00100000
mATDDR14L_BIT6:     equ    %01000000
mATDDR14L_BIT7:     equ    %10000000


;*** ATDDR15 - ATD  Conversion Result Register 15; 0x000000AE ***
ATDDR15:            equ    $000000AE                                ;*** ATDDR15 - ATD  Conversion Result Register 15; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15_BIT0:       equ    0                                         ; Bit 0
ATDDR15_BIT1:       equ    1                                         ; Bit 1
ATDDR15_BIT2:       equ    2                                         ; Bit 2
ATDDR15_BIT3:       equ    3                                         ; Bit 3
ATDDR15_BIT4:       equ    4                                         ; Bit 4
ATDDR15_BIT5:       equ    5                                         ; Bit 5
ATDDR15_BIT6:       equ    6                                         ; Bit 6
ATDDR15_BIT7:       equ    7                                         ; Bit 7
ATDDR15_BIT8:       equ    8                                         ; Bit 8
ATDDR15_BIT9:       equ    9                                         ; Bit 9
ATDDR15_BIT10:      equ    10                                        ; Bit 10
ATDDR15_BIT11:      equ    11                                        ; Bit 11
ATDDR15_BIT12:      equ    12                                        ; Bit 12
ATDDR15_BIT13:      equ    13                                        ; Bit 13
ATDDR15_BIT14:      equ    14                                        ; Bit 14
ATDDR15_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATDDR15_BIT0:      equ    %00000001
mATDDR15_BIT1:      equ    %00000010
mATDDR15_BIT2:      equ    %00000100
mATDDR15_BIT3:      equ    %00001000
mATDDR15_BIT4:      equ    %00010000
mATDDR15_BIT5:      equ    %00100000
mATDDR15_BIT6:      equ    %01000000
mATDDR15_BIT7:      equ    %10000000
mATDDR15_BIT8:      equ    %100000000
mATDDR15_BIT9:      equ    %1000000000
mATDDR15_BIT10:     equ    %10000000000
mATDDR15_BIT11:     equ    %100000000000
mATDDR15_BIT12:     equ    %1000000000000
mATDDR15_BIT13:     equ    %10000000000000
mATDDR15_BIT14:     equ    %100000000000000
mATDDR15_BIT15:     equ    %1000000000000000


;*** ATDDR15H - ATD  Conversion Result Register 15 High; 0x000000AE ***
ATDDR15H:           equ    $000000AE                                ;*** ATDDR15H - ATD  Conversion Result Register 15 High; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15H_BIT8:      equ    0                                         ; Bit 8
ATDDR15H_BIT9:      equ    1                                         ; Bit 9
ATDDR15H_BIT10:     equ    2                                         ; Bit 10
ATDDR15H_BIT11:     equ    3                                         ; Bit 11
ATDDR15H_BIT12:     equ    4                                         ; Bit 12
ATDDR15H_BIT13:     equ    5                                         ; Bit 13
ATDDR15H_BIT14:     equ    6                                         ; Bit 14
ATDDR15H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATDDR15H_BIT8:     equ    %00000001
mATDDR15H_BIT9:     equ    %00000010
mATDDR15H_BIT10:    equ    %00000100
mATDDR15H_BIT11:    equ    %00001000
mATDDR15H_BIT12:    equ    %00010000
mATDDR15H_BIT13:    equ    %00100000
mATDDR15H_BIT14:    equ    %01000000
mATDDR15H_BIT15:    equ    %10000000


;*** ATDDR15L - ATD  Conversion Result Register 15 Low; 0x000000AF ***
ATDDR15L:           equ    $000000AF                                ;*** ATDDR15L - ATD  Conversion Result Register 15 Low; 0x000000AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATDDR15L_BIT0:      equ    0                                         ; Bit 0
ATDDR15L_BIT1:      equ    1                                         ; Bit 1
ATDDR15L_BIT2:      equ    2                                         ; Bit 2
ATDDR15L_BIT3:      equ    3                                         ; Bit 3
ATDDR15L_BIT4:      equ    4                                         ; Bit 4
ATDDR15L_BIT5:      equ    5                                         ; Bit 5
ATDDR15L_BIT6:      equ    6                                         ; Bit 6
ATDDR15L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATDDR15L_BIT0:     equ    %00000001
mATDDR15L_BIT1:     equ    %00000010
mATDDR15L_BIT2:     equ    %00000100
mATDDR15L_BIT3:     equ    %00001000
mATDDR15L_BIT4:     equ    %00010000
mATDDR15L_BIT5:     equ    %00100000
mATDDR15L_BIT6:     equ    %01000000
mATDDR15L_BIT7:     equ    %10000000


;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
SCI0BD:             equ    $000000C8                                ;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI0BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI0BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI0BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI0BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI0BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI0BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI0BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI0BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI0BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI0BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI0BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI0BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI0BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI0BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI0BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI0BD_SBR0:       equ    %00000001
mSCI0BD_SBR1:       equ    %00000010
mSCI0BD_SBR2:       equ    %00000100
mSCI0BD_SBR3:       equ    %00001000
mSCI0BD_SBR4:       equ    %00010000
mSCI0BD_SBR5:       equ    %00100000
mSCI0BD_SBR6:       equ    %01000000
mSCI0BD_SBR7:       equ    %10000000
mSCI0BD_SBR8:       equ    %100000000
mSCI0BD_SBR9:       equ    %1000000000
mSCI0BD_SBR10:      equ    %10000000000
mSCI0BD_SBR11:      equ    %100000000000
mSCI0BD_SBR12:      equ    %1000000000000
mSCI0BD_TNP0:       equ    %10000000000000
mSCI0BD_TNP1:       equ    %100000000000000
mSCI0BD_IREN:       equ    %1000000000000000


;*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***
SCI0ASR1:           equ    $000000C8                                ;*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI0ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI0ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI0ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI0ASR1_BKDIF:    equ    %00000001
mSCI0ASR1_BERRIF:   equ    %00000010
mSCI0ASR1_BERRV:    equ    %00000100
mSCI0ASR1_RXEDGIF:  equ    %10000000


;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
SCI0BDH:            equ    $000000C8                                ;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI0BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI0BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI0BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI0BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI0BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI0BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI0BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI0BDH_SBR8:      equ    %00000001
mSCI0BDH_SBR9:      equ    %00000010
mSCI0BDH_SBR10:     equ    %00000100
mSCI0BDH_SBR11:     equ    %00001000
mSCI0BDH_SBR12:     equ    %00010000
mSCI0BDH_TNP0:      equ    %00100000
mSCI0BDH_TNP1:      equ    %01000000
mSCI0BDH_IREN:      equ    %10000000


;*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***
SCI0ACR1:           equ    $000000C9                                ;*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI0ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI0ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI0ACR1_BKDIE:    equ    %00000001
mSCI0ACR1_BERRIE:   equ    %00000010
mSCI0ACR1_RXEDGIE:  equ    %10000000


;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
SCI0BDL:            equ    $000000C9                                ;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI0BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI0BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI0BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI0BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI0BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI0BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI0BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI0BDL_SBR0:      equ    %00000001
mSCI0BDL_SBR1:      equ    %00000010
mSCI0BDL_SBR2:      equ    %00000100
mSCI0BDL_SBR3:      equ    %00001000
mSCI0BDL_SBR4:      equ    %00010000
mSCI0BDL_SBR5:      equ    %00100000
mSCI0BDL_SBR6:      equ    %01000000
mSCI0BDL_SBR7:      equ    %10000000


;*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***
SCI0ACR2:           equ    $000000CA                                ;*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI0ACR2_BERRM0:    equ    1                                         ; Bit Error Mode 0
SCI0ACR2_BERRM1:    equ    2                                         ; Bit Error Mode 1
; bit position masks
mSCI0ACR2_BKDFE:    equ    %00000001
mSCI0ACR2_BERRM0:   equ    %00000010
mSCI0ACR2_BERRM1:   equ    %00000100


;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
SCI0CR1:            equ    $000000CA                                ;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR1_PT:         equ    0                                         ; Parity Type Bit
SCI0CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI0CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI0CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI0CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI0CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI0CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI0CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI0CR1_PT:        equ    %00000001
mSCI0CR1_PE:        equ    %00000010
mSCI0CR1_ILT:       equ    %00000100
mSCI0CR1_WAKE:      equ    %00001000
mSCI0CR1_M:         equ    %00010000
mSCI0CR1_RSRC:      equ    %00100000
mSCI0CR1_SCISWAI:   equ    %01000000
mSCI0CR1_LOOPS:     equ    %10000000


;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
SCI0CR2:            equ    $000000CB                                ;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR2_SBK:        equ    0                                         ; Send Break Bit
SCI0CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI0CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI0CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI0CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI0CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI0CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI0CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI0CR2_SBK:       equ    %00000001
mSCI0CR2_RWU:       equ    %00000010
mSCI0CR2_RE:        equ    %00000100
mSCI0CR2_TE:        equ    %00001000
mSCI0CR2_ILIE:      equ    %00010000
mSCI0CR2_RIE:       equ    %00100000
mSCI0CR2_TCIE:      equ    %01000000
mSCI0CR2_TIE:       equ    %10000000


;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
SCI0SR1:            equ    $000000CC                                ;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR1_PF:         equ    0                                         ; Parity Error Flag
SCI0SR1_FE:         equ    1                                         ; Framing Error Flag
SCI0SR1_NF:         equ    2                                         ; Noise Flag
SCI0SR1_OR:         equ    3                                         ; Overrun Flag
SCI0SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI0SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI0SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI0SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI0SR1_PF:        equ    %00000001
mSCI0SR1_FE:        equ    %00000010
mSCI0SR1_NF:        equ    %00000100
mSCI0SR1_OR:        equ    %00001000
mSCI0SR1_IDLE:      equ    %00010000
mSCI0SR1_RDRF:      equ    %00100000
mSCI0SR1_TC:        equ    %01000000
mSCI0SR1_TDRE:      equ    %10000000


;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
SCI0SR2:            equ    $000000CD                                ;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI0SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI0SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI0SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI0SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI0SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI0SR2_RAF:       equ    %00000001
mSCI0SR2_TXDIR:     equ    %00000010
mSCI0SR2_BRK13:     equ    %00000100
mSCI0SR2_RXPOL:     equ    %00001000
mSCI0SR2_TXPOL:     equ    %00010000
mSCI0SR2_AMAP:      equ    %10000000


;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
SCI0DRH:            equ    $000000CE                                ;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI0DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI0DRH_T8:        equ    %01000000
mSCI0DRH_R8:        equ    %10000000


;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
SCI0DRL:            equ    $000000CF                                ;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI0DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI0DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI0DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI0DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI0DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI0DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI0DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI0DRL_R0_T0:     equ    %00000001
mSCI0DRL_R1_T1:     equ    %00000010
mSCI0DRL_R2_T2:     equ    %00000100
mSCI0DRL_R3_T3:     equ    %00001000
mSCI0DRL_R4_T4:     equ    %00010000
mSCI0DRL_R5_T5:     equ    %00100000
mSCI0DRL_R6_T6:     equ    %01000000
mSCI0DRL_R7_T7:     equ    %10000000


;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
SCI1BD:             equ    $000000D0                                ;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI1BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI1BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI1BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI1BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI1BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI1BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI1BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI1BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI1BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI1BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI1BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI1BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI1BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI1BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI1BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI1BD_SBR0:       equ    %00000001
mSCI1BD_SBR1:       equ    %00000010
mSCI1BD_SBR2:       equ    %00000100
mSCI1BD_SBR3:       equ    %00001000
mSCI1BD_SBR4:       equ    %00010000
mSCI1BD_SBR5:       equ    %00100000
mSCI1BD_SBR6:       equ    %01000000
mSCI1BD_SBR7:       equ    %10000000
mSCI1BD_SBR8:       equ    %100000000
mSCI1BD_SBR9:       equ    %1000000000
mSCI1BD_SBR10:      equ    %10000000000
mSCI1BD_SBR11:      equ    %100000000000
mSCI1BD_SBR12:      equ    %1000000000000
mSCI1BD_TNP0:       equ    %10000000000000
mSCI1BD_TNP1:       equ    %100000000000000
mSCI1BD_IREN:       equ    %1000000000000000


;*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***
SCI1ASR1:           equ    $000000D0                                ;*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI1ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI1ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI1ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI1ASR1_BKDIF:    equ    %00000001
mSCI1ASR1_BERRIF:   equ    %00000010
mSCI1ASR1_BERRV:    equ    %00000100
mSCI1ASR1_RXEDGIF:  equ    %10000000


;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
SCI1BDH:            equ    $000000D0                                ;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI1BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI1BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI1BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI1BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI1BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI1BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI1BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI1BDH_SBR8:      equ    %00000001
mSCI1BDH_SBR9:      equ    %00000010
mSCI1BDH_SBR10:     equ    %00000100
mSCI1BDH_SBR11:     equ    %00001000
mSCI1BDH_SBR12:     equ    %00010000
mSCI1BDH_TNP0:      equ    %00100000
mSCI1BDH_TNP1:      equ    %01000000
mSCI1BDH_IREN:      equ    %10000000


;*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***
SCI1ACR1:           equ    $000000D1                                ;*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI1ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI1ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI1ACR1_BKDIE:    equ    %00000001
mSCI1ACR1_BERRIE:   equ    %00000010
mSCI1ACR1_RXEDGIE:  equ    %10000000


;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
SCI1BDL:            equ    $000000D1                                ;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI1BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI1BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI1BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI1BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI1BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI1BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI1BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI1BDL_SBR0:      equ    %00000001
mSCI1BDL_SBR1:      equ    %00000010
mSCI1BDL_SBR2:      equ    %00000100
mSCI1BDL_SBR3:      equ    %00001000
mSCI1BDL_SBR4:      equ    %00010000
mSCI1BDL_SBR5:      equ    %00100000
mSCI1BDL_SBR6:      equ    %01000000
mSCI1BDL_SBR7:      equ    %10000000


;*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***
SCI1ACR2:           equ    $000000D2                                ;*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI1ACR2_BERRM0:    equ    1                                         ; Bit Error Mode 0
SCI1ACR2_BERRM1:    equ    2                                         ; Bit Error Mode 1
; bit position masks
mSCI1ACR2_BKDFE:    equ    %00000001
mSCI1ACR2_BERRM0:   equ    %00000010
mSCI1ACR2_BERRM1:   equ    %00000100


;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
SCI1CR1:            equ    $000000D2                                ;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR1_PT:         equ    0                                         ; Parity Type Bit
SCI1CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI1CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI1CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI1CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI1CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI1CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI1CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI1CR1_PT:        equ    %00000001
mSCI1CR1_PE:        equ    %00000010
mSCI1CR1_ILT:       equ    %00000100
mSCI1CR1_WAKE:      equ    %00001000
mSCI1CR1_M:         equ    %00010000
mSCI1CR1_RSRC:      equ    %00100000
mSCI1CR1_SCISWAI:   equ    %01000000
mSCI1CR1_LOOPS:     equ    %10000000


;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
SCI1CR2:            equ    $000000D3                                ;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR2_SBK:        equ    0                                         ; Send Break Bit
SCI1CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI1CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI1CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI1CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI1CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI1CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI1CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI1CR2_SBK:       equ    %00000001
mSCI1CR2_RWU:       equ    %00000010
mSCI1CR2_RE:        equ    %00000100
mSCI1CR2_TE:        equ    %00001000
mSCI1CR2_ILIE:      equ    %00010000
mSCI1CR2_RIE:       equ    %00100000
mSCI1CR2_TCIE:      equ    %01000000
mSCI1CR2_TIE:       equ    %10000000


;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
SCI1SR1:            equ    $000000D4                                ;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR1_PF:         equ    0                                         ; Parity Error Flag
SCI1SR1_FE:         equ    1                                         ; Framing Error Flag
SCI1SR1_NF:         equ    2                                         ; Noise Flag
SCI1SR1_OR:         equ    3                                         ; Overrun Flag
SCI1SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI1SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI1SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI1SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI1SR1_PF:        equ    %00000001
mSCI1SR1_FE:        equ    %00000010
mSCI1SR1_NF:        equ    %00000100
mSCI1SR1_OR:        equ    %00001000
mSCI1SR1_IDLE:      equ    %00010000
mSCI1SR1_RDRF:      equ    %00100000
mSCI1SR1_TC:        equ    %01000000
mSCI1SR1_TDRE:      equ    %10000000


;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
SCI1SR2:            equ    $000000D5                                ;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI1SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI1SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI1SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI1SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI1SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI1SR2_RAF:       equ    %00000001
mSCI1SR2_TXDIR:     equ    %00000010
mSCI1SR2_BRK13:     equ    %00000100
mSCI1SR2_RXPOL:     equ    %00001000
mSCI1SR2_TXPOL:     equ    %00010000
mSCI1SR2_AMAP:      equ    %10000000


;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
SCI1DRH:            equ    $000000D6                                ;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI1DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI1DRH_T8:        equ    %01000000
mSCI1DRH_R8:        equ    %10000000


;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
SCI1DRL:            equ    $000000D7                                ;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI1DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI1DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI1DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI1DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI1DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI1DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI1DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI1DRL_R0_T0:     equ    %00000001
mSCI1DRL_R1_T1:     equ    %00000010
mSCI1DRL_R2_T2:     equ    %00000100
mSCI1DRL_R3_T3:     equ    %00001000
mSCI1DRL_R4_T4:     equ    %00010000
mSCI1DRL_R5_T5:     equ    %00100000
mSCI1DRL_R6_T6:     equ    %01000000
mSCI1DRL_R7_T7:     equ    %10000000


;*** SPI0CR1 - SPI 0 Control Register 1; 0x000000D8 ***
SPI0CR1:            equ    $000000D8                                ;*** SPI0CR1 - SPI 0 Control Register 1; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI0CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI0CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI0CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI0CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI0CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI0CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI0CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI0CR1_LSBFE:     equ    %00000001
mSPI0CR1_SSOE:      equ    %00000010
mSPI0CR1_CPHA:      equ    %00000100
mSPI0CR1_CPOL:      equ    %00001000
mSPI0CR1_MSTR:      equ    %00010000
mSPI0CR1_SPTIE:     equ    %00100000
mSPI0CR1_SPE:       equ    %01000000
mSPI0CR1_SPIE:      equ    %10000000


;*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***
SPI0CR2:            equ    $000000D9                                ;*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI0CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI0CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI0CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
SPI0CR2_XFRW:       equ    6                                         ; Transfer Width
; bit position masks
mSPI0CR2_SPC0:      equ    %00000001
mSPI0CR2_SPISWAI:   equ    %00000010
mSPI0CR2_BIDIROE:   equ    %00001000
mSPI0CR2_MODFEN:    equ    %00010000
mSPI0CR2_XFRW:      equ    %01000000


;*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***
SPI0BR:             equ    $000000DA                                ;*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI0BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI0BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI0BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI0BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI0BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI0BR_SPR0:       equ    %00000001
mSPI0BR_SPR1:       equ    %00000010
mSPI0BR_SPR2:       equ    %00000100
mSPI0BR_SPPR0:      equ    %00010000
mSPI0BR_SPPR1:      equ    %00100000
mSPI0BR_SPPR2:      equ    %01000000


;*** SPI0SR - SPI 0 Status Register; 0x000000DB ***
SPI0SR:             equ    $000000DB                                ;*** SPI0SR - SPI 0 Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI0SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI0SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI0SR_MODF:       equ    %00010000
mSPI0SR_SPTEF:      equ    %00100000
mSPI0SR_SPIF:       equ    %10000000


;*** SPI0DR - SPI 0 Data Register; 0x000000DC ***
SPI0DR:             equ    $000000DC                                ;*** SPI0DR - SPI 0 Data Register; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0DR_R0_T0:       equ    0                                         ; SPI 0 Data Bit 0
SPI0DR_R1_T1:       equ    1                                         ; SPI 0 Data Bit 1
SPI0DR_R2_T2:       equ    2                                         ; SPI 0 Data Bit 2
SPI0DR_R3_T3:       equ    3                                         ; SPI 0 Data Bit 3
SPI0DR_R4_T4:       equ    4                                         ; SPI 0 Data Bit 4
SPI0DR_R5_T5:       equ    5                                         ; SPI 0 Data Bit 5
SPI0DR_R6_T6:       equ    6                                         ; SPI 0 Data Bit 6
SPI0DR_R7_T7:       equ    7                                         ; SPI 0 Data Bit 7
SPI0DR_R8_T8:       equ    8                                         ; SPI 0 Data Bit 8
SPI0DR_R9_T9:       equ    9                                         ; SPI 0 Data Bit 9
SPI0DR_R10_T10:     equ    10                                        ; SPI 0 Data Bit 10
SPI0DR_R11_T11:     equ    11                                        ; SPI 0 Data Bit 11
SPI0DR_R12_T12:     equ    12                                        ; SPI 0 Data Bit 12
SPI0DR_R13_T13:     equ    13                                        ; SPI 0 Data Bit 13
SPI0DR_R14_T14:     equ    14                                        ; SPI 0 Data Bit 14
SPI0DR_R15_T15:     equ    15                                        ; SPI 0 Data Bit 15
; bit position masks
mSPI0DR_R0_T0:      equ    %00000001
mSPI0DR_R1_T1:      equ    %00000010
mSPI0DR_R2_T2:      equ    %00000100
mSPI0DR_R3_T3:      equ    %00001000
mSPI0DR_R4_T4:      equ    %00010000
mSPI0DR_R5_T5:      equ    %00100000
mSPI0DR_R6_T6:      equ    %01000000
mSPI0DR_R7_T7:      equ    %10000000
mSPI0DR_R8_T8:      equ    %100000000
mSPI0DR_R9_T9:      equ    %1000000000
mSPI0DR_R10_T10:    equ    %10000000000
mSPI0DR_R11_T11:    equ    %100000000000
mSPI0DR_R12_T12:    equ    %1000000000000
mSPI0DR_R13_T13:    equ    %10000000000000
mSPI0DR_R14_T14:    equ    %100000000000000
mSPI0DR_R15_T15:    equ    %1000000000000000


;*** SPI0DRH - SPI 0 Data Register High; 0x000000DC ***
SPI0DRH:            equ    $000000DC                                ;*** SPI0DRH - SPI 0 Data Register High; 0x000000DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0DRH_R8_T8:      equ    0                                         ; SPI 0 Data Bit 8
SPI0DRH_R9_T9:      equ    1                                         ; SPI 0 Data Bit 9
SPI0DRH_R10_T10:    equ    2                                         ; SPI 0 Data Bit 10
SPI0DRH_R11_T11:    equ    3                                         ; SPI 0 Data Bit 11
SPI0DRH_R12_T12:    equ    4                                         ; SPI 0 Data Bit 12
SPI0DRH_R13_T13:    equ    5                                         ; SPI 0 Data Bit 13
SPI0DRH_R14_T14:    equ    6                                         ; SPI 0 Data Bit 14
SPI0DRH_R15_T15:    equ    7                                         ; SPI 0 Data Bit 15
; bit position masks
mSPI0DRH_R8_T8:     equ    %00000001
mSPI0DRH_R9_T9:     equ    %00000010
mSPI0DRH_R10_T10:   equ    %00000100
mSPI0DRH_R11_T11:   equ    %00001000
mSPI0DRH_R12_T12:   equ    %00010000
mSPI0DRH_R13_T13:   equ    %00100000
mSPI0DRH_R14_T14:   equ    %01000000
mSPI0DRH_R15_T15:   equ    %10000000


;*** SPI0DRL - SPI 0 Data Register Low; 0x000000DD ***
SPI0DRL:            equ    $000000DD                                ;*** SPI0DRL - SPI 0 Data Register Low; 0x000000DD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0DRL_R0_T0:      equ    0                                         ; SPI 0 Data Bit 0
SPI0DRL_R1_T1:      equ    1                                         ; SPI 0 Data Bit 1
SPI0DRL_R2_T2:      equ    2                                         ; SPI 0 Data Bit 2
SPI0DRL_R3_T3:      equ    3                                         ; SPI 0 Data Bit 3
SPI0DRL_R4_T4:      equ    4                                         ; SPI 0 Data Bit 4
SPI0DRL_R5_T5:      equ    5                                         ; SPI 0 Data Bit 5
SPI0DRL_R6_T6:      equ    6                                         ; SPI 0 Data Bit 6
SPI0DRL_R7_T7:      equ    7                                         ; SPI 0 Data Bit 7
; bit position masks
mSPI0DRL_R0_T0:     equ    %00000001
mSPI0DRL_R1_T1:     equ    %00000010
mSPI0DRL_R2_T2:     equ    %00000100
mSPI0DRL_R3_T3:     equ    %00001000
mSPI0DRL_R4_T4:     equ    %00010000
mSPI0DRL_R5_T5:     equ    %00100000
mSPI0DRL_R6_T6:     equ    %01000000
mSPI0DRL_R7_T7:     equ    %10000000


;*** SPI1CR1 - SPI 1 Control Register 1; 0x000000F0 ***
SPI1CR1:            equ    $000000F0                                ;*** SPI1CR1 - SPI 1 Control Register 1; 0x000000F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI1CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI1CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI1CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI1CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI1CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI1CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI1CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI1CR1_LSBFE:     equ    %00000001
mSPI1CR1_SSOE:      equ    %00000010
mSPI1CR1_CPHA:      equ    %00000100
mSPI1CR1_CPOL:      equ    %00001000
mSPI1CR1_MSTR:      equ    %00010000
mSPI1CR1_SPTIE:     equ    %00100000
mSPI1CR1_SPE:       equ    %01000000
mSPI1CR1_SPIE:      equ    %10000000


;*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***
SPI1CR2:            equ    $000000F1                                ;*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI1CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI1CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI1CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
SPI1CR2_XFRW:       equ    6                                         ; Transfer Width
; bit position masks
mSPI1CR2_SPC0:      equ    %00000001
mSPI1CR2_SPISWAI:   equ    %00000010
mSPI1CR2_BIDIROE:   equ    %00001000
mSPI1CR2_MODFEN:    equ    %00010000
mSPI1CR2_XFRW:      equ    %01000000


;*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***
SPI1BR:             equ    $000000F2                                ;*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI1BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI1BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI1BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI1BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI1BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI1BR_SPR0:       equ    %00000001
mSPI1BR_SPR1:       equ    %00000010
mSPI1BR_SPR2:       equ    %00000100
mSPI1BR_SPPR0:      equ    %00010000
mSPI1BR_SPPR1:      equ    %00100000
mSPI1BR_SPPR2:      equ    %01000000


;*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***
SPI1SR:             equ    $000000F3                                ;*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI1SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI1SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI1SR_MODF:       equ    %00010000
mSPI1SR_SPTEF:      equ    %00100000
mSPI1SR_SPIF:       equ    %10000000


;*** SPI1DR - SPI 1 Data Register; 0x000000F4 ***
SPI1DR:             equ    $000000F4                                ;*** SPI1DR - SPI 1 Data Register; 0x000000F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1DR_R0_T0:       equ    0                                         ; SPI 1 Data Bit 0
SPI1DR_R1_T1:       equ    1                                         ; SPI 1 Data Bit 1
SPI1DR_R2_T2:       equ    2                                         ; SPI 1 Data Bit 2
SPI1DR_R3_T3:       equ    3                                         ; SPI 1 Data Bit 3
SPI1DR_R4_T4:       equ    4                                         ; SPI 1 Data Bit 4
SPI1DR_R5_T5:       equ    5                                         ; SPI 1 Data Bit 5
SPI1DR_R6_T6:       equ    6                                         ; SPI 1 Data Bit 6
SPI1DR_R7_T7:       equ    7                                         ; SPI 1 Data Bit 7
SPI1DR_R8_T8:       equ    8                                         ; SPI 1 Data Bit 8
SPI1DR_R9_T9:       equ    9                                         ; SPI 1 Data Bit 9
SPI1DR_R10_T10:     equ    10                                        ; SPI 1 Data Bit 10
SPI1DR_R11_T11:     equ    11                                        ; SPI 1 Data Bit 11
SPI1DR_R12_T12:     equ    12                                        ; SPI 1 Data Bit 12
SPI1DR_R13_T13:     equ    13                                        ; SPI 1 Data Bit 13
SPI1DR_R14_T14:     equ    14                                        ; SPI 1 Data Bit 14
SPI1DR_R15_T15:     equ    15                                        ; SPI 1 Data Bit 15
; bit position masks
mSPI1DR_R0_T0:      equ    %00000001
mSPI1DR_R1_T1:      equ    %00000010
mSPI1DR_R2_T2:      equ    %00000100
mSPI1DR_R3_T3:      equ    %00001000
mSPI1DR_R4_T4:      equ    %00010000
mSPI1DR_R5_T5:      equ    %00100000
mSPI1DR_R6_T6:      equ    %01000000
mSPI1DR_R7_T7:      equ    %10000000
mSPI1DR_R8_T8:      equ    %100000000
mSPI1DR_R9_T9:      equ    %1000000000
mSPI1DR_R10_T10:    equ    %10000000000
mSPI1DR_R11_T11:    equ    %100000000000
mSPI1DR_R12_T12:    equ    %1000000000000
mSPI1DR_R13_T13:    equ    %10000000000000
mSPI1DR_R14_T14:    equ    %100000000000000
mSPI1DR_R15_T15:    equ    %1000000000000000


;*** SPI1DRH - SPI 1 Data Register High; 0x000000F4 ***
SPI1DRH:            equ    $000000F4                                ;*** SPI1DRH - SPI 1 Data Register High; 0x000000F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1DRH_R8_T8:      equ    0                                         ; SPI 1 Data Bit 8
SPI1DRH_R9_T9:      equ    1                                         ; SPI 1 Data Bit 9
SPI1DRH_R10_T10:    equ    2                                         ; SPI 1 Data Bit 10
SPI1DRH_R11_T11:    equ    3                                         ; SPI 1 Data Bit 11
SPI1DRH_R12_T12:    equ    4                                         ; SPI 1 Data Bit 12
SPI1DRH_R13_T13:    equ    5                                         ; SPI 1 Data Bit 13
SPI1DRH_R14_T14:    equ    6                                         ; SPI 1 Data Bit 14
SPI1DRH_R15_T15:    equ    7                                         ; SPI 1 Data Bit 15
; bit position masks
mSPI1DRH_R8_T8:     equ    %00000001
mSPI1DRH_R9_T9:     equ    %00000010
mSPI1DRH_R10_T10:   equ    %00000100
mSPI1DRH_R11_T11:   equ    %00001000
mSPI1DRH_R12_T12:   equ    %00010000
mSPI1DRH_R13_T13:   equ    %00100000
mSPI1DRH_R14_T14:   equ    %01000000
mSPI1DRH_R15_T15:   equ    %10000000


;*** SPI1DRL - SPI 1 Data Register Low; 0x000000F5 ***
SPI1DRL:            equ    $000000F5                                ;*** SPI1DRL - SPI 1 Data Register Low; 0x000000F5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1DRL_R0_T0:      equ    0                                         ; SPI 1 Data Bit 0
SPI1DRL_R1_T1:      equ    1                                         ; SPI 1 Data Bit 1
SPI1DRL_R2_T2:      equ    2                                         ; SPI 1 Data Bit 2
SPI1DRL_R3_T3:      equ    3                                         ; SPI 1 Data Bit 3
SPI1DRL_R4_T4:      equ    4                                         ; SPI 1 Data Bit 4
SPI1DRL_R5_T5:      equ    5                                         ; SPI 1 Data Bit 5
SPI1DRL_R6_T6:      equ    6                                         ; SPI 1 Data Bit 6
SPI1DRL_R7_T7:      equ    7                                         ; SPI 1 Data Bit 7
; bit position masks
mSPI1DRL_R0_T0:     equ    %00000001
mSPI1DRL_R1_T1:     equ    %00000010
mSPI1DRL_R2_T2:     equ    %00000100
mSPI1DRL_R3_T3:     equ    %00001000
mSPI1DRL_R4_T4:     equ    %00010000
mSPI1DRL_R5_T5:     equ    %00100000
mSPI1DRL_R6_T6:     equ    %01000000
mSPI1DRL_R7_T7:     equ    %10000000


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Clock Divider Bit 5
FCLKDIV_FDIV6:      equ    6                                         ; Clock Divider Bit 6
FCLKDIV_FDIVLD:     equ    7                                         ; Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_FDIV6:     equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Flash Security Bit 0
FSEC_SEC1:          equ    1                                         ; Flash Security Bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Nonvolatile Bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Nonvolatile Bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Nonvolatile Bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Nonvolatile Bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
FCCOBIX:            equ    $00000102                                ;*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBIX_CCOBIX0:    equ    0                                         ; Common Command Register Index Bit 0
FCCOBIX_CCOBIX1:    equ    1                                         ; Common Command Register Index Bit 1
FCCOBIX_CCOBIX2:    equ    2                                         ; Common Command Register Index Bit 2
; bit position masks
mFCCOBIX_CCOBIX0:   equ    %00000001
mFCCOBIX_CCOBIX1:   equ    %00000010
mFCCOBIX_CCOBIX2:   equ    %00000100


;*** FECCRIX - Flash ECCR Index Register; 0x00000103 ***
FECCRIX:            equ    $00000103                                ;*** FECCRIX - Flash ECCR Index Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FECCRIX_ECCRIX0:    equ    0                                         ; ECC Error Register Index Bit 0
FECCRIX_ECCRIX1:    equ    1                                         ; ECC Error Register Index Bit 1
FECCRIX_ECCRIX2:    equ    2                                         ; ECC Error Register Index Bit 2
; bit position masks
mFECCRIX_ECCRIX0:   equ    %00000001
mFECCRIX_ECCRIX1:   equ    %00000010
mFECCRIX_ECCRIX2:   equ    %00000100


;*** FCNFG - Flash Configuration Register; 0x00000104 ***
FCNFG:              equ    $00000104                                ;*** FCNFG - Flash Configuration Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_FSFD:         equ    0                                         ; Force Single Bit Fault Detect
FCNFG_FDFD:         equ    1                                         ; Force Double Bit Fault Detect
FCNFG_IGNSF:        equ    4                                         ; Ignore Single Bit Fault
FCNFG_CCIE:         equ    7                                         ; Command Complete Interrupt Enable
; bit position masks
mFCNFG_FSFD:        equ    %00000001
mFCNFG_FDFD:        equ    %00000010
mFCNFG_IGNSF:       equ    %00010000
mFCNFG_CCIE:        equ    %10000000


;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
FERCNFG:            equ    $00000105                                ;*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERCNFG_SFDIE:      equ    0                                         ; Single Bit Fault Detect Interrupt Enable
FERCNFG_DFDIE:      equ    1                                         ; Double Bit Fault Detect Interrupt Enable
FERCNFG_ERSVIE0:    equ    2                                         ; EEE Error Type 0 Interrupt Enable
FERCNFG_ERSVIE1:    equ    3                                         ; EEE Error Type 1 Interrupt Enable
FERCNFG_EPVIOLIE:   equ    4                                         ; EEE Protection Violation Interrupt Enable
FERCNFG_PGMERIE:    equ    6                                         ; EEE Program Error Interrupt Enable
FERCNFG_ERSERIE:    equ    7                                         ; EEE Erase Error Interrupt Enable
; bit position masks
mFERCNFG_SFDIE:     equ    %00000001
mFERCNFG_DFDIE:     equ    %00000010
mFERCNFG_ERSVIE0:   equ    %00000100
mFERCNFG_ERSVIE1:   equ    %00001000
mFERCNFG_EPVIOLIE:  equ    %00010000
mFERCNFG_PGMERIE:   equ    %01000000
mFERCNFG_ERSERIE:   equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000106 ***
FSTAT:              equ    $00000106                                ;*** FSTAT - Flash Status Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_MGSTAT0:      equ    0                                         ; Memory Controller Command Completion Status Flag 0
FSTAT_MGSTAT1:      equ    1                                         ; Memory Controller Command Completion Status Flag 1
FSTAT_MGBUSY:       equ    3                                         ; Memory Controller Busy Flag
FSTAT_FPVIOL:       equ    4                                         ; Flash Protection Violation Flag
FSTAT_ACCERR:       equ    5                                         ; Flash Access Error Flag
FSTAT_CCIF:         equ    7                                         ; Command Complete Interrupt Flag
; bit position masks
mFSTAT_MGSTAT0:     equ    %00000001
mFSTAT_MGSTAT1:     equ    %00000010
mFSTAT_MGBUSY:      equ    %00001000
mFSTAT_FPVIOL:      equ    %00010000
mFSTAT_ACCERR:      equ    %00100000
mFSTAT_CCIF:        equ    %10000000


;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
FERSTAT:            equ    $00000107                                ;*** FERSTAT - Flash Error Status Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FERSTAT_SFDIF:      equ    0                                         ; Single Bit Fault Detect Interrupt Flag
FERSTAT_DFDIF:      equ    1                                         ; Double Bit Fault Detect Interrupt Flag
FERSTAT_ERSVIF0:    equ    2                                         ; EEE Error Type 0 Interrupt Flag
FERSTAT_ERSVIF1:    equ    3                                         ; EEE Error Type 1 Interrupt Flag
FERSTAT_EPVIOLIF:   equ    4                                         ; EEE Protection Violation Interrupt Flag
FERSTAT_PGMERIF:    equ    6                                         ; EEE Program Error Interrupt Flag
FERSTAT_ERSERIF:    equ    7                                         ; EEE Erase Error Interrupt Flag
; bit position masks
mFERSTAT_SFDIF:     equ    %00000001
mFERSTAT_DFDIF:     equ    %00000010
mFERSTAT_ERSVIF0:   equ    %00000100
mFERSTAT_ERSVIF1:   equ    %00001000
mFERSTAT_EPVIOLIF:  equ    %00010000
mFERSTAT_PGMERIF:   equ    %01000000
mFERSTAT_ERSERIF:   equ    %10000000


;*** FPROT - P-Flash Protection Register; 0x00000108 ***
FPROT:              equ    $00000108                                ;*** FPROT - P-Flash Protection Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address Size Bit 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address Size Bit 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower Address Range Disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher Address Size Bit 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher Address Size Bit 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher Address Range Disable
FPROT_RNV6:         equ    6                                         ; Reserved Nonvolatile Bit
FPROT_FPOPEN:       equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** EPROT - EEE Protection Register; 0x00000109 ***
EPROT:              equ    $00000109                                ;*** EPROT - EEE Protection Register; 0x00000109 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPROT_EPS0:         equ    0                                         ; Buffer RAM Protection Size 0
EPROT_EPS1:         equ    1                                         ; Buffer RAM Protection Size 1
EPROT_EPS2:         equ    2                                         ; Buffer RAM Protection Size 2
EPROT_EPDIS:        equ    3                                         ; Buffer RAM Protection Address Range Disable
EPROT_RNV4:         equ    4                                         ; Reserved Non-volatile Bits
EPROT_RNV5:         equ    5                                         ; Reserved Non-volatile Bit 1
EPROT_RNV6:         equ    6                                         ; Reserved Non-volatile Bit 2
EPROT_EPOPEN:       equ    7                                         ; Enables writes to Buffer RAM partitioned for EEE
; bit position masks
mEPROT_EPS0:        equ    %00000001
mEPROT_EPS1:        equ    %00000010
mEPROT_EPS2:        equ    %00000100
mEPROT_EPDIS:       equ    %00001000
mEPROT_RNV4:        equ    %00010000
mEPROT_RNV5:        equ    %00100000
mEPROT_RNV6:        equ    %01000000
mEPROT_EPOPEN:      equ    %10000000


;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
FCCOB:              equ    $0000010A                                ;*** FCCOB - Flash Common Command Object Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOB_CCOB0:        equ    0                                         ; Flash Common Command Object Bit 0
FCCOB_CCOB1:        equ    1                                         ; Flash Common Command Object Bit 1
FCCOB_CCOB2:        equ    2                                         ; Flash Common Command Object Bit 2
FCCOB_CCOB3:        equ    3                                         ; Flash Common Command Object Bit 3
FCCOB_CCOB4:        equ    4                                         ; Flash Common Command Object Bit 4
FCCOB_CCOB5:        equ    5                                         ; Flash Common Command Object Bit 5
FCCOB_CCOB6:        equ    6                                         ; Flash Common Command Object Bit 6
FCCOB_CCOB7:        equ    7                                         ; Flash Common Command Object Bit 7
FCCOB_CCOB8:        equ    8                                         ; Flash Common Command Object Bit 8
FCCOB_CCOB9:        equ    9                                         ; Flash Common Command Object Bit 9
FCCOB_CCOB10:       equ    10                                        ; Flash Common Command Object Bit 10
FCCOB_CCOB11:       equ    11                                        ; Flash Common Command Object Bit 11
FCCOB_CCOB12:       equ    12                                        ; Flash Common Command Object Bit 12
FCCOB_CCOB13:       equ    13                                        ; Flash Common Command Object Bit 13
FCCOB_CCOB14:       equ    14                                        ; Flash Common Command Object Bit 14
FCCOB_CCOB15:       equ    15                                        ; Flash Common Command Object Bit 15
; bit position masks
mFCCOB_CCOB0:       equ    %00000001
mFCCOB_CCOB1:       equ    %00000010
mFCCOB_CCOB2:       equ    %00000100
mFCCOB_CCOB3:       equ    %00001000
mFCCOB_CCOB4:       equ    %00010000
mFCCOB_CCOB5:       equ    %00100000
mFCCOB_CCOB6:       equ    %01000000
mFCCOB_CCOB7:       equ    %10000000
mFCCOB_CCOB8:       equ    %100000000
mFCCOB_CCOB9:       equ    %1000000000
mFCCOB_CCOB10:      equ    %10000000000
mFCCOB_CCOB11:      equ    %100000000000
mFCCOB_CCOB12:      equ    %1000000000000
mFCCOB_CCOB13:      equ    %10000000000000
mFCCOB_CCOB14:      equ    %100000000000000
mFCCOB_CCOB15:      equ    %1000000000000000


;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
FCCOBHI:            equ    $0000010A                                ;*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBHI_CCOB8:      equ    0                                         ; Flash Common Command Object Bit 8
FCCOBHI_CCOB9:      equ    1                                         ; Flash Common Command Object Bit 9
FCCOBHI_CCOB10:     equ    2                                         ; Flash Common Command Object Bit 10
FCCOBHI_CCOB11:     equ    3                                         ; Flash Common Command Object Bit 11
FCCOBHI_CCOB12:     equ    4                                         ; Flash Common Command Object Bit 12
FCCOBHI_CCOB13:     equ    5                                         ; Flash Common Command Object Bit 13
FCCOBHI_CCOB14:     equ    6                                         ; Flash Common Command Object Bit 14
FCCOBHI_CCOB15:     equ    7                                         ; Flash Common Command Object Bit 15
; bit position masks
mFCCOBHI_CCOB8:     equ    %00000001
mFCCOBHI_CCOB9:     equ    %00000010
mFCCOBHI_CCOB10:    equ    %00000100
mFCCOBHI_CCOB11:    equ    %00001000
mFCCOBHI_CCOB12:    equ    %00010000
mFCCOBHI_CCOB13:    equ    %00100000
mFCCOBHI_CCOB14:    equ    %01000000
mFCCOBHI_CCOB15:    equ    %10000000


;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
FCCOBLO:            equ    $0000010B                                ;*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCCOBLO_CCOB0:      equ    0                                         ; Flash Common Command Object Bit 0
FCCOBLO_CCOB1:      equ    1                                         ; Flash Common Command Object Bit 1
FCCOBLO_CCOB2:      equ    2                                         ; Flash Common Command Object Bit 2
FCCOBLO_CCOB3:      equ    3                                         ; Flash Common Command Object Bit 3
FCCOBLO_CCOB4:      equ    4                                         ; Flash Common Command Object Bit 4
FCCOBLO_CCOB5:      equ    5                                         ; Flash Common Command Object Bit 5
FCCOBLO_CCOB6:      equ    6                                         ; Flash Common Command Object Bit 6
FCCOBLO_CCOB7:      equ    7                                         ; Flash Common Command Object Bit 7
; bit position masks
mFCCOBLO_CCOB0:     equ    %00000001
mFCCOBLO_CCOB1:     equ    %00000010
mFCCOBLO_CCOB2:     equ    %00000100
mFCCOBLO_CCOB3:     equ    %00001000
mFCCOBLO_CCOB4:     equ    %00010000
mFCCOBLO_CCOB5:     equ    %00100000
mFCCOBLO_CCOB6:     equ    %01000000
mFCCOBLO_CCOB7:     equ    %10000000


;*** ETAG - EEE Tag Counter Register; 0x0000010C ***
ETAG:               equ    $0000010C                                ;*** ETAG - EEE Tag Counter Register; 0x0000010C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ETAG_ETAG0:         equ    0                                         ; EEE Tag Counter Bit 0
ETAG_ETAG1:         equ    1                                         ; EEE Tag Counter Bit 1
ETAG_ETAG2:         equ    2                                         ; EEE Tag Counter Bit 2
ETAG_ETAG3:         equ    3                                         ; EEE Tag Counter Bit 3
ETAG_ETAG4:         equ    4                                         ; EEE Tag Counter Bit 4
ETAG_ETAG5:         equ    5                                         ; EEE Tag Counter Bit 5
ETAG_ETAG6:         equ    6                                         ; EEE Tag Counter Bit 6
ETAG_ETAG7:         equ    7                                         ; EEE Tag Counter Bit 7
ETAG_ETAG8:         equ    8                                         ; EEE Tag Counter Bit 8
ETAG_ETAG9:         equ    9                                         ; EEE Tag Counter Bit 9
ETAG_ETAG10:        equ    10                                        ; EEE Tag Counter Bit 10
ETAG_ETAG11:        equ    11                                        ; EEE Tag Counter Bit 11
ETAG_ETAG12:        equ    12                                        ; EEE Tag Counter Bit 12
ETAG_ETAG13:        equ    13                                        ; EEE Tag Counter Bit 13
ETAG_ETAG14:        equ    14                                        ; EEE Tag Counter Bit 14
ETAG_ETAG15:        equ    15                                        ; EEE Tag Counter Bit 15
; bit position masks
mETAG_ETAG0:        equ    %00000001
mETAG_ETAG1:        equ    %00000010
mETAG_ETAG2:        equ    %00000100
mETAG_ETAG3:        equ    %00001000
mETAG_ETAG4:        equ    %00010000
mETAG_ETAG5:        equ    %00100000
mETAG_ETAG6:        equ    %01000000
mETAG_ETAG7:        equ    %10000000
mETAG_ETAG8:        equ    %100000000
mETAG_ETAG9:        equ    %1000000000
mETAG_ETAG10:       equ    %10000000000
mETAG_ETAG11:       equ    %100000000000
mETAG_ETAG12:       equ    %1000000000000
mETAG_ETAG13:       equ    %10000000000000
mETAG_ETAG14:       equ    %100000000000000
mETAG_ETAG15:       equ    %1000000000000000


;*** ETAGHI - EEE Tag Counter High Register; 0x0000010C ***
ETAGHI:             equ    $0000010C                                ;*** ETAGHI - EEE Tag Counter High Register; 0x0000010C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ETAGHI_ETAG8:       equ    0                                         ; EEE Tag Counter Bit 8
ETAGHI_ETAG9:       equ    1                                         ; EEE Tag Counter Bit 9
ETAGHI_ETAG10:      equ    2                                         ; EEE Tag Counter Bit 10
ETAGHI_ETAG11:      equ    3                                         ; EEE Tag Counter Bit 11
ETAGHI_ETAG12:      equ    4                                         ; EEE Tag Counter Bit 12
ETAGHI_ETAG13:      equ    5                                         ; EEE Tag Counter Bit 13
ETAGHI_ETAG14:      equ    6                                         ; EEE Tag Counter Bit 14
ETAGHI_ETAG15:      equ    7                                         ; EEE Tag Counter Bit 15
; bit position masks
mETAGHI_ETAG8:      equ    %00000001
mETAGHI_ETAG9:      equ    %00000010
mETAGHI_ETAG10:     equ    %00000100
mETAGHI_ETAG11:     equ    %00001000
mETAGHI_ETAG12:     equ    %00010000
mETAGHI_ETAG13:     equ    %00100000
mETAGHI_ETAG14:     equ    %01000000
mETAGHI_ETAG15:     equ    %10000000


;*** ETAGLO - EEE Tag Counter Low Register; 0x0000010D ***
ETAGLO:             equ    $0000010D                                ;*** ETAGLO - EEE Tag Counter Low Register; 0x0000010D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ETAGLO_ETAG0:       equ    0                                         ; EEE Tag Counter Bit 0
ETAGLO_ETAG1:       equ    1                                         ; EEE Tag Counter Bit 1
ETAGLO_ETAG2:       equ    2                                         ; EEE Tag Counter Bit 2
ETAGLO_ETAG3:       equ    3                                         ; EEE Tag Counter Bit 3
ETAGLO_ETAG4:       equ    4                                         ; EEE Tag Counter Bit 4
ETAGLO_ETAG5:       equ    5                                         ; EEE Tag Counter Bit 5
ETAGLO_ETAG6:       equ    6                                         ; EEE Tag Counter Bit 6
ETAGLO_ETAG7:       equ    7                                         ; EEE Tag Counter Bit 7
; bit position masks
mETAGLO_ETAG0:      equ    %00000001
mETAGLO_ETAG1:      equ    %00000010
mETAGLO_ETAG2:      equ    %00000100
mETAGLO_ETAG3:      equ    %00001000
mETAGLO_ETAG4:      equ    %00010000
mETAGLO_ETAG5:      equ    %00100000
mETAGLO_ETAG6:      equ    %01000000
mETAGLO_ETAG7:      equ    %10000000


;*** FECCR - Flash ECC Error Results Register; 0x0000010E ***
FECCR:              equ    $0000010E                                ;*** FECCR - Flash ECC Error Results Register; 0x0000010E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FECCR_ECCR0:        equ    0                                         ; Flash ECC Error Result Bit 0
FECCR_ECCR1:        equ    1                                         ; Flash ECC Error Result Bit 1
FECCR_ECCR2:        equ    2                                         ; Flash ECC Error Result Bit 2
FECCR_ECCR3:        equ    3                                         ; Flash ECC Error Result Bit 3
FECCR_ECCR4:        equ    4                                         ; Flash ECC Error Result Bit 4
FECCR_ECCR5:        equ    5                                         ; Flash ECC Error Result Bit 5
FECCR_ECCR6:        equ    6                                         ; Flash ECC Error Result Bit 6
FECCR_ECCR7:        equ    7                                         ; Flash ECC Error Result Bit 7
FECCR_ECCR8:        equ    8                                         ; Flash ECC Error Result Bit 8
FECCR_ECCR9:        equ    9                                         ; Flash ECC Error Result Bit 9
FECCR_ECCR10:       equ    10                                        ; Flash ECC Error Result Bit 10
FECCR_ECCR11:       equ    11                                        ; Flash ECC Error Result Bit 11
FECCR_ECCR12:       equ    12                                        ; Flash ECC Error Result Bit 12
FECCR_ECCR13:       equ    13                                        ; Flash ECC Error Result Bit 13
FECCR_ECCR14:       equ    14                                        ; Flash ECC Error Result Bit 14
FECCR_ECCR15:       equ    15                                        ; Flash ECC Error Result Bit 15
; bit position masks
mFECCR_ECCR0:       equ    %00000001
mFECCR_ECCR1:       equ    %00000010
mFECCR_ECCR2:       equ    %00000100
mFECCR_ECCR3:       equ    %00001000
mFECCR_ECCR4:       equ    %00010000
mFECCR_ECCR5:       equ    %00100000
mFECCR_ECCR6:       equ    %01000000
mFECCR_ECCR7:       equ    %10000000
mFECCR_ECCR8:       equ    %100000000
mFECCR_ECCR9:       equ    %1000000000
mFECCR_ECCR10:      equ    %10000000000
mFECCR_ECCR11:      equ    %100000000000
mFECCR_ECCR12:      equ    %1000000000000
mFECCR_ECCR13:      equ    %10000000000000
mFECCR_ECCR14:      equ    %100000000000000
mFECCR_ECCR15:      equ    %1000000000000000


;*** FECCRHI - Flash ECC Error Results Register High; 0x0000010E ***
FECCRHI:            equ    $0000010E                                ;*** FECCRHI - Flash ECC Error Results Register High; 0x0000010E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FECCRHI_ECCR8:      equ    0                                         ; Flash ECC Error Result Bit 8
FECCRHI_ECCR9:      equ    1                                         ; Flash ECC Error Result Bit 9
FECCRHI_ECCR10:     equ    2                                         ; Flash ECC Error Result Bit 10
FECCRHI_ECCR11:     equ    3                                         ; Flash ECC Error Result Bit 11
FECCRHI_ECCR12:     equ    4                                         ; Flash ECC Error Result Bit 12
FECCRHI_ECCR13:     equ    5                                         ; Flash ECC Error Result Bit 13
FECCRHI_ECCR14:     equ    6                                         ; Flash ECC Error Result Bit 14
FECCRHI_ECCR15:     equ    7                                         ; Flash ECC Error Result Bit 15
; bit position masks
mFECCRHI_ECCR8:     equ    %00000001
mFECCRHI_ECCR9:     equ    %00000010
mFECCRHI_ECCR10:    equ    %00000100
mFECCRHI_ECCR11:    equ    %00001000
mFECCRHI_ECCR12:    equ    %00010000
mFECCRHI_ECCR13:    equ    %00100000
mFECCRHI_ECCR14:    equ    %01000000
mFECCRHI_ECCR15:    equ    %10000000


;*** FECCRLO - Flash ECC Error Results Register Low; 0x0000010F ***
FECCRLO:            equ    $0000010F                                ;*** FECCRLO - Flash ECC Error Results Register Low; 0x0000010F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FECCRLO_ECCR0:      equ    0                                         ; Flash ECC Error Result Bit 0
FECCRLO_ECCR1:      equ    1                                         ; Flash ECC Error Result Bit 1
FECCRLO_ECCR2:      equ    2                                         ; Flash ECC Error Result Bit 2
FECCRLO_ECCR3:      equ    3                                         ; Flash ECC Error Result Bit 3
FECCRLO_ECCR4:      equ    4                                         ; Flash ECC Error Result Bit 4
FECCRLO_ECCR5:      equ    5                                         ; Flash ECC Error Result Bit 5
FECCRLO_ECCR6:      equ    6                                         ; Flash ECC Error Result Bit 6
FECCRLO_ECCR7:      equ    7                                         ; Flash ECC Error Result Bit 7
; bit position masks
mFECCRLO_ECCR0:     equ    %00000001
mFECCRLO_ECCR1:     equ    %00000010
mFECCRLO_ECCR2:     equ    %00000100
mFECCRLO_ECCR3:     equ    %00001000
mFECCRLO_ECCR4:     equ    %00010000
mFECCRLO_ECCR5:     equ    %00100000
mFECCRLO_ECCR6:     equ    %01000000
mFECCRLO_ECCR7:     equ    %10000000


;*** FOPT - Flash Option Register; 0x00000110 ***
FOPT:               equ    $00000110                                ;*** FOPT - Flash Option Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_NV0:           equ    0                                         ; Nonvolatile Bit 0
FOPT_NV1:           equ    1                                         ; Nonvolatile Bit 1
FOPT_NV2:           equ    2                                         ; Nonvolatile Bit 2
FOPT_NV3:           equ    3                                         ; Nonvolatile Bit 3
FOPT_NV4:           equ    4                                         ; Nonvolatile Bit 4
FOPT_NV5:           equ    5                                         ; Nonvolatile Bit 5
FOPT_NV6:           equ    6                                         ; Nonvolatile Bit 6
FOPT_NV7:           equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mFOPT_NV0:          equ    %00000001
mFOPT_NV1:          equ    %00000010
mFOPT_NV2:          equ    %00000100
mFOPT_NV3:          equ    %00001000
mFOPT_NV4:          equ    %00010000
mFOPT_NV5:          equ    %00100000
mFOPT_NV6:          equ    %01000000
mFOPT_NV7:          equ    %10000000


;*** MPUFLG - MPU Flag Register; 0x00000114 ***
MPUFLG:             equ    $00000114                                ;*** MPUFLG - MPU Flag Register; 0x00000114 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUFLG_SVSF:        equ    0                                         ; Supervisor State Flag
MPUFLG_NEXF:        equ    5                                         ; No-Execute Violation Flag
MPUFLG_WPF:         equ    6                                         ; Write-Protect Violation Flag
MPUFLG_AEF:         equ    7                                         ; Access Error Flag
; bit position masks
mMPUFLG_SVSF:       equ    %00000001
mMPUFLG_NEXF:       equ    %00100000
mMPUFLG_WPF:        equ    %01000000
mMPUFLG_AEF:        equ    %10000000


;*** MPUASTAT0 - MPU Address Status Register 0; 0x00000115 ***
MPUASTAT0:          equ    $00000115                                ;*** MPUASTAT0 - MPU Address Status Register 0; 0x00000115 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUASTAT0_ADDR16:   equ    0                                         ; Access violation address bits, bit 16
MPUASTAT0_ADDR17:   equ    1                                         ; Access violation address bits, bit 17
MPUASTAT0_ADDR18:   equ    2                                         ; Access violation address bits, bit 18
MPUASTAT0_ADDR19:   equ    3                                         ; Access violation address bits, bit 19
MPUASTAT0_ADDR20:   equ    4                                         ; Access violation address bits, bit 20
MPUASTAT0_ADDR21:   equ    5                                         ; Access violation address bits, bit 21
MPUASTAT0_ADDR22:   equ    6                                         ; Access violation address bits, bit 22
; bit position masks
mMPUASTAT0_ADDR16:  equ    %00000001
mMPUASTAT0_ADDR17:  equ    %00000010
mMPUASTAT0_ADDR18:  equ    %00000100
mMPUASTAT0_ADDR19:  equ    %00001000
mMPUASTAT0_ADDR20:  equ    %00010000
mMPUASTAT0_ADDR21:  equ    %00100000
mMPUASTAT0_ADDR22:  equ    %01000000


;*** MPUASTAT1 - MPU Address Status Register 1; 0x00000116 ***
MPUASTAT1:          equ    $00000116                                ;*** MPUASTAT1 - MPU Address Status Register 1; 0x00000116 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUASTAT1_ADDR8:    equ    0                                         ; Access violation address bits, bit 8
MPUASTAT1_ADDR9:    equ    1                                         ; Access violation address bits, bit 9
MPUASTAT1_ADDR10:   equ    2                                         ; Access violation address bits, bit 10
MPUASTAT1_ADDR11:   equ    3                                         ; Access violation address bits, bit 11
MPUASTAT1_ADDR12:   equ    4                                         ; Access violation address bits, bit 12
MPUASTAT1_ADDR13:   equ    5                                         ; Access violation address bits, bit 13
MPUASTAT1_ADDR14:   equ    6                                         ; Access violation address bits, bit 14
MPUASTAT1_ADDR15:   equ    7                                         ; Access violation address bits, bit 15
; bit position masks
mMPUASTAT1_ADDR8:   equ    %00000001
mMPUASTAT1_ADDR9:   equ    %00000010
mMPUASTAT1_ADDR10:  equ    %00000100
mMPUASTAT1_ADDR11:  equ    %00001000
mMPUASTAT1_ADDR12:  equ    %00010000
mMPUASTAT1_ADDR13:  equ    %00100000
mMPUASTAT1_ADDR14:  equ    %01000000
mMPUASTAT1_ADDR15:  equ    %10000000


;*** MPUASTAT2 - MPU Address Status Register 2; 0x00000117 ***
MPUASTAT2:          equ    $00000117                                ;*** MPUASTAT2 - MPU Address Status Register 2; 0x00000117 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUASTAT2_ADDR0:    equ    0                                         ; Access violation address bits, bit 0
MPUASTAT2_ADDR1:    equ    1                                         ; Access violation address bits, bit 1
MPUASTAT2_ADDR2:    equ    2                                         ; Access violation address bits, bit 2
MPUASTAT2_ADDR3:    equ    3                                         ; Access violation address bits, bit 3
MPUASTAT2_ADDR4:    equ    4                                         ; Access violation address bits, bit 4
MPUASTAT2_ADDR5:    equ    5                                         ; Access violation address bits, bit 5
MPUASTAT2_ADDR6:    equ    6                                         ; Access violation address bits, bit 6
MPUASTAT2_ADDR7:    equ    7                                         ; Access violation address bits, bit 7
; bit position masks
mMPUASTAT2_ADDR0:   equ    %00000001
mMPUASTAT2_ADDR1:   equ    %00000010
mMPUASTAT2_ADDR2:   equ    %00000100
mMPUASTAT2_ADDR3:   equ    %00001000
mMPUASTAT2_ADDR4:   equ    %00010000
mMPUASTAT2_ADDR5:   equ    %00100000
mMPUASTAT2_ADDR6:   equ    %01000000
mMPUASTAT2_ADDR7:   equ    %10000000


;*** MPUSEL - MPU Descriptor Select Register; 0x00000119 ***
MPUSEL:             equ    $00000119                                ;*** MPUSEL - MPU Descriptor Select Register; 0x00000119 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUSEL_SEL:         equ    0                                         ; Descriptor select
MPUSEL_SVSEN:       equ    7                                         ; MPU supervisor state enable bit
; bit position masks
mMPUSEL_SEL:        equ    %00001111
mMPUSEL_SVSEN:      equ    %10000000


;*** MPUDESC0 - MPU Descriptor Register 0; 0x0000011A ***
MPUDESC0:           equ    $0000011A                                ;*** MPUDESC0 - MPU Descriptor Register 0; 0x0000011A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUDESC0_LOW_ADDR19: equ    0                                        ; Memory range lower boundary address bits, bit 19
MPUDESC0_LOW_ADDR20: equ    1                                        ; Memory range lower boundary address bits, bit 20
MPUDESC0_LOW_ADDR21: equ    2                                        ; Memory range lower boundary address bits, bit 21
MPUDESC0_LOW_ADDR22: equ    3                                        ; Memory range lower boundary address bits, bit 22
MPUDESC0_MSTR3:     equ    4                                         ; Master 3 select bit
MPUDESC0_MSTR2:     equ    5                                         ; Master 2 select bit
MPUDESC0_MSTR1:     equ    6                                         ; Master 1 select bit
MPUDESC0_MSTR0:     equ    7                                         ; Master 0 select bit
; bit position masks
mMPUDESC0_LOW_ADDR19: equ    %00000001
mMPUDESC0_LOW_ADDR20: equ    %00000010
mMPUDESC0_LOW_ADDR21: equ    %00000100
mMPUDESC0_LOW_ADDR22: equ    %00001000
mMPUDESC0_MSTR3:    equ    %00010000
mMPUDESC0_MSTR2:    equ    %00100000
mMPUDESC0_MSTR1:    equ    %01000000
mMPUDESC0_MSTR0:    equ    %10000000


;*** MPUDESC1 - MPU Descriptor Register 1; 0x0000011B ***
MPUDESC1:           equ    $0000011B                                ;*** MPUDESC1 - MPU Descriptor Register 1; 0x0000011B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUDESC1_LOW_ADDR11: equ    0                                        ; Memory range lower boundary address bits, bit 11
MPUDESC1_LOW_ADDR12: equ    1                                        ; Memory range lower boundary address bits, bit 12
MPUDESC1_LOW_ADDR13: equ    2                                        ; Memory range lower boundary address bits, bit 13
MPUDESC1_LOW_ADDR14: equ    3                                        ; Memory range lower boundary address bits, bit 14
MPUDESC1_LOW_ADDR15: equ    4                                        ; Memory range lower boundary address bits, bit 15
MPUDESC1_LOW_ADDR16: equ    5                                        ; Memory range lower boundary address bits, bit 16
MPUDESC1_LOW_ADDR17: equ    6                                        ; Memory range lower boundary address bits, bit 17
MPUDESC1_LOW_ADDR18: equ    7                                        ; Memory range lower boundary address bits, bit 18
; bit position masks
mMPUDESC1_LOW_ADDR11: equ    %00000001
mMPUDESC1_LOW_ADDR12: equ    %00000010
mMPUDESC1_LOW_ADDR13: equ    %00000100
mMPUDESC1_LOW_ADDR14: equ    %00001000
mMPUDESC1_LOW_ADDR15: equ    %00010000
mMPUDESC1_LOW_ADDR16: equ    %00100000
mMPUDESC1_LOW_ADDR17: equ    %01000000
mMPUDESC1_LOW_ADDR18: equ    %10000000


;*** MPUDESC2 - MPU Descriptor Register 2; 0x0000011C ***
MPUDESC2:           equ    $0000011C                                ;*** MPUDESC2 - MPU Descriptor Register 2; 0x0000011C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUDESC2_LOW_ADDR3: equ    0                                         ; Memory range lower boundary address bits, bit 3
MPUDESC2_LOW_ADDR4: equ    1                                         ; Memory range lower boundary address bits, bit 4
MPUDESC2_LOW_ADDR5: equ    2                                         ; Memory range lower boundary address bits, bit 5
MPUDESC2_LOW_ADDR6: equ    3                                         ; Memory range lower boundary address bits, bit 6
MPUDESC2_LOW_ADDR7: equ    4                                         ; Memory range lower boundary address bits, bit 7
MPUDESC2_LOW_ADDR8: equ    5                                         ; Memory range lower boundary address bits, bit 8
MPUDESC2_LOW_ADDR9: equ    6                                         ; Memory range lower boundary address bits, bit 9
MPUDESC2_LOW_ADDR10: equ    7                                        ; Memory range lower boundary address bits, bit 10
; bit position masks
mMPUDESC2_LOW_ADDR3: equ    %00000001
mMPUDESC2_LOW_ADDR4: equ    %00000010
mMPUDESC2_LOW_ADDR5: equ    %00000100
mMPUDESC2_LOW_ADDR6: equ    %00001000
mMPUDESC2_LOW_ADDR7: equ    %00010000
mMPUDESC2_LOW_ADDR8: equ    %00100000
mMPUDESC2_LOW_ADDR9: equ    %01000000
mMPUDESC2_LOW_ADDR10: equ    %10000000


;*** MPUDESC3 - MPU Descriptor Register 2; 0x0000011D ***
MPUDESC3:           equ    $0000011D                                ;*** MPUDESC3 - MPU Descriptor Register 2; 0x0000011D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUDESC3_HIGH_ADDR19: equ    0                                       ; Memory range upper boundary address bits, bit 19
MPUDESC3_HIGH_ADDR20: equ    1                                       ; Memory range upper boundary address bits, bit 20
MPUDESC3_HIGH_ADDR21: equ    2                                       ; Memory range upper boundary address bits, bit 21
MPUDESC3_HIGH_ADDR22: equ    3                                       ; Memory range upper boundary address bits, bit 22
MPUDESC3_NEX:       equ    6                                         ; No-Execute bit
MPUDESC3_WP:        equ    7                                         ; Write-Protect bit
; bit position masks
mMPUDESC3_HIGH_ADDR19: equ    %00000001
mMPUDESC3_HIGH_ADDR20: equ    %00000010
mMPUDESC3_HIGH_ADDR21: equ    %00000100
mMPUDESC3_HIGH_ADDR22: equ    %00001000
mMPUDESC3_NEX:      equ    %01000000
mMPUDESC3_WP:       equ    %10000000


;*** MPUDESC4 - MPU Descriptor Register 2; 0x0000011E ***
MPUDESC4:           equ    $0000011E                                ;*** MPUDESC4 - MPU Descriptor Register 2; 0x0000011E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUDESC4_HIGH_ADDR11: equ    0                                       ; Memory range upper boundary address bits, bit 11
MPUDESC4_HIGH_ADDR12: equ    1                                       ; Memory range upper boundary address bits, bit 12
MPUDESC4_HIGH_ADDR13: equ    2                                       ; Memory range upper boundary address bits, bit 13
MPUDESC4_HIGH_ADDR14: equ    3                                       ; Memory range upper boundary address bits, bit 14
MPUDESC4_HIGH_ADDR15: equ    4                                       ; Memory range upper boundary address bits, bit 15
MPUDESC4_HIGH_ADDR16: equ    5                                       ; Memory range upper boundary address bits, bit 16
MPUDESC4_HIGH_ADDR17: equ    6                                       ; Memory range upper boundary address bits, bit 17
MPUDESC4_HIGH_ADDR18: equ    7                                       ; Memory range upper boundary address bits, bit 18
; bit position masks
mMPUDESC4_HIGH_ADDR11: equ    %00000001
mMPUDESC4_HIGH_ADDR12: equ    %00000010
mMPUDESC4_HIGH_ADDR13: equ    %00000100
mMPUDESC4_HIGH_ADDR14: equ    %00001000
mMPUDESC4_HIGH_ADDR15: equ    %00010000
mMPUDESC4_HIGH_ADDR16: equ    %00100000
mMPUDESC4_HIGH_ADDR17: equ    %01000000
mMPUDESC4_HIGH_ADDR18: equ    %10000000


;*** MPUDESC5 - MPU Descriptor Register 2; 0x0000011F ***
MPUDESC5:           equ    $0000011F                                ;*** MPUDESC5 - MPU Descriptor Register 2; 0x0000011F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MPUDESC5_HIGH_ADDR3: equ    0                                        ; Memory range upper boundary address bits, bit 3
MPUDESC5_HIGH_ADDR4: equ    1                                        ; Memory range upper boundary address bits, bit 4
MPUDESC5_HIGH_ADDR5: equ    2                                        ; Memory range upper boundary address bits, bit 5
MPUDESC5_HIGH_ADDR6: equ    3                                        ; Memory range upper boundary address bits, bit 6
MPUDESC5_HIGH_ADDR7: equ    4                                        ; Memory range upper boundary address bits, bit 7
MPUDESC5_HIGH_ADDR8: equ    5                                        ; Memory range upper boundary address bits, bit 8
MPUDESC5_HIGH_ADDR9: equ    6                                        ; Memory range upper boundary address bits, bit 9
MPUDESC5_HIGH_ADDR10: equ    7                                       ; Memory range upper boundary address bits, bit 10
; bit position masks
mMPUDESC5_HIGH_ADDR3: equ    %00000001
mMPUDESC5_HIGH_ADDR4: equ    %00000010
mMPUDESC5_HIGH_ADDR5: equ    %00000100
mMPUDESC5_HIGH_ADDR6: equ    %00001000
mMPUDESC5_HIGH_ADDR7: equ    %00010000
mMPUDESC5_HIGH_ADDR8: equ    %00100000
mMPUDESC5_HIGH_ADDR9: equ    %01000000
mMPUDESC5_HIGH_ADDR10: equ    %10000000


;*** IVBR - Interrupt Vector Base Register; 0x00000121 ***
IVBR:               equ    $00000121                                ;*** IVBR - Interrupt Vector Base Register; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR:      equ    0                                         ; Interrupt Vector Base Address Bits
; bit position masks
mIVBR_IVB_ADDR:     equ    %11111111


;*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x00000126 ***
INT_XGPRIO:         equ    $00000126                                ;*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x00000126 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_XGPRIO_XILVL:   equ    0                                         ; XGATE Interrupt Priority Level
; bit position masks
mINT_XGPRIO_XILVL:  equ    %00000111


;*** INT_CFADDR - Interrupt Request Configuration Address Register; 0x00000127 ***
INT_CFADDR:         equ    $00000127                                ;*** INT_CFADDR - Interrupt Request Configuration Address Register; 0x00000127 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFADDR_INT_CFADDR: equ    4                                      ; Interrupt Request Configuration Data Register Select Bits
; bit position masks
mINT_CFADDR_INT_CFADDR: equ    %11110000


;*** INT_CFDATA0 - Interrupt Request Configuration Data Register 0; 0x00000128 ***
INT_CFDATA0:        equ    $00000128                                ;*** INT_CFDATA0 - Interrupt Request Configuration Data Register 0; 0x00000128 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA0_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA0_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA0_PRIOLVL: equ    %00000111
mINT_CFDATA0_RQST:  equ    %10000000


;*** INT_CFDATA1 - Interrupt Request Configuration Data Register 1; 0x00000129 ***
INT_CFDATA1:        equ    $00000129                                ;*** INT_CFDATA1 - Interrupt Request Configuration Data Register 1; 0x00000129 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA1_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA1_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA1_PRIOLVL: equ    %00000111
mINT_CFDATA1_RQST:  equ    %10000000


;*** INT_CFDATA2 - Interrupt Request Configuration Data Register 2; 0x0000012A ***
INT_CFDATA2:        equ    $0000012A                                ;*** INT_CFDATA2 - Interrupt Request Configuration Data Register 2; 0x0000012A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA2_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA2_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA2_PRIOLVL: equ    %00000111
mINT_CFDATA2_RQST:  equ    %10000000


;*** INT_CFDATA3 - Interrupt Request Configuration Data Register 3; 0x0000012B ***
INT_CFDATA3:        equ    $0000012B                                ;*** INT_CFDATA3 - Interrupt Request Configuration Data Register 3; 0x0000012B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA3_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA3_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA3_PRIOLVL: equ    %00000111
mINT_CFDATA3_RQST:  equ    %10000000


;*** INT_CFDATA4 - Interrupt Request Configuration Data Register 4; 0x0000012C ***
INT_CFDATA4:        equ    $0000012C                                ;*** INT_CFDATA4 - Interrupt Request Configuration Data Register 4; 0x0000012C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA4_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA4_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA4_PRIOLVL: equ    %00000111
mINT_CFDATA4_RQST:  equ    %10000000


;*** INT_CFDATA5 - Interrupt Request Configuration Data Register 5; 0x0000012D ***
INT_CFDATA5:        equ    $0000012D                                ;*** INT_CFDATA5 - Interrupt Request Configuration Data Register 5; 0x0000012D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA5_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA5_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA5_PRIOLVL: equ    %00000111
mINT_CFDATA5_RQST:  equ    %10000000


;*** INT_CFDATA6 - Interrupt Request Configuration Data Register 6; 0x0000012E ***
INT_CFDATA6:        equ    $0000012E                                ;*** INT_CFDATA6 - Interrupt Request Configuration Data Register 6; 0x0000012E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA6_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA6_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA6_PRIOLVL: equ    %00000111
mINT_CFDATA6_RQST:  equ    %10000000


;*** INT_CFDATA7 - Interrupt Request Configuration Data Register 7; 0x0000012F ***
INT_CFDATA7:        equ    $0000012F                                ;*** INT_CFDATA7 - Interrupt Request Configuration Data Register 7; 0x0000012F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA7_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA7_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA7_PRIOLVL: equ    %00000111
mINT_CFDATA7_RQST:  equ    %10000000


;*** CAN0CTL0 - MSCAN0 Control 0 Register; 0x00000140 ***
CAN0CTL0:           equ    $00000140                                ;*** CAN0CTL0 - MSCAN0 Control 0 Register; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN0CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN0CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN0CTL0_TIME:      equ    3                                         ; Timer Enable
CAN0CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN0CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN0CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN0CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN0CTL0_INITRQ:   equ    %00000001
mCAN0CTL0_SLPRQ:    equ    %00000010
mCAN0CTL0_WUPE:     equ    %00000100
mCAN0CTL0_TIME:     equ    %00001000
mCAN0CTL0_SYNCH:    equ    %00010000
mCAN0CTL0_CSWAI:    equ    %00100000
mCAN0CTL0_RXACT:    equ    %01000000
mCAN0CTL0_RXFRM:    equ    %10000000


;*** CAN0CTL1 - MSCAN0 Control 1 Register; 0x00000141 ***
CAN0CTL1:           equ    $00000141                                ;*** CAN0CTL1 - MSCAN0 Control 1 Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN0CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN0CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN0CTL1_BORM:      equ    3                                         ; Bus-Off Recovery Mode
CAN0CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN0CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN0CTL1_CLKSRC:    equ    6                                         ; MSCAN Clock Source
CAN0CTL1_CANE:      equ    7                                         ; MSCAN Enable
; bit position masks
mCAN0CTL1_INITAK:   equ    %00000001
mCAN0CTL1_SLPAK:    equ    %00000010
mCAN0CTL1_WUPM:     equ    %00000100
mCAN0CTL1_BORM:     equ    %00001000
mCAN0CTL1_LISTEN:   equ    %00010000
mCAN0CTL1_LOOPB:    equ    %00100000
mCAN0CTL1_CLKSRC:   equ    %01000000
mCAN0CTL1_CANE:     equ    %10000000


;*** CAN0BTR0 - MSCAN0 Bus Timing Register 0; 0x00000142 ***
CAN0BTR0:           equ    $00000142                                ;*** CAN0BTR0 - MSCAN0 Bus Timing Register 0; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN0BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN0BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN0BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN0BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN0BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN0BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN0BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN0BTR0_BRP0:     equ    %00000001
mCAN0BTR0_BRP1:     equ    %00000010
mCAN0BTR0_BRP2:     equ    %00000100
mCAN0BTR0_BRP3:     equ    %00001000
mCAN0BTR0_BRP4:     equ    %00010000
mCAN0BTR0_BRP5:     equ    %00100000
mCAN0BTR0_SJW0:     equ    %01000000
mCAN0BTR0_SJW1:     equ    %10000000


;*** CAN0BTR1 - MSCAN0 Bus Timing Register 1; 0x00000143 ***
CAN0BTR1:           equ    $00000143                                ;*** CAN0BTR1 - MSCAN0 Bus Timing Register 1; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN0BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN0BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN0BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN0BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN0BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN0BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN0BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN0BTR1_TSEG10:   equ    %00000001
mCAN0BTR1_TSEG11:   equ    %00000010
mCAN0BTR1_TSEG12:   equ    %00000100
mCAN0BTR1_TSEG13:   equ    %00001000
mCAN0BTR1_TSEG20:   equ    %00010000
mCAN0BTR1_TSEG21:   equ    %00100000
mCAN0BTR1_TSEG22:   equ    %01000000
mCAN0BTR1_SAMP:     equ    %10000000


;*** CAN0RFLG - MSCAN0 Receiver Flag Register; 0x00000144 ***
CAN0RFLG:           equ    $00000144                                ;*** CAN0RFLG - MSCAN0 Receiver Flag Register; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN0RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN0RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN0RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN0RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN0RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN0RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN0RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN0RFLG_RXF:      equ    %00000001
mCAN0RFLG_OVRIF:    equ    %00000010
mCAN0RFLG_TSTAT0:   equ    %00000100
mCAN0RFLG_TSTAT1:   equ    %00001000
mCAN0RFLG_RSTAT0:   equ    %00010000
mCAN0RFLG_RSTAT1:   equ    %00100000
mCAN0RFLG_CSCIF:    equ    %01000000
mCAN0RFLG_WUPIF:    equ    %10000000


;*** CAN0RIER - MSCAN0 Receiver Interrupt Enable Register; 0x00000145 ***
CAN0RIER:           equ    $00000145                                ;*** CAN0RIER - MSCAN0 Receiver Interrupt Enable Register; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN0RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN0RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN0RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN0RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN0RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN0RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN0RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN0RIER_RXFIE:    equ    %00000001
mCAN0RIER_OVRIE:    equ    %00000010
mCAN0RIER_TSTATE0:  equ    %00000100
mCAN0RIER_TSTATE1:  equ    %00001000
mCAN0RIER_RSTATE0:  equ    %00010000
mCAN0RIER_RSTATE1:  equ    %00100000
mCAN0RIER_CSCIE:    equ    %01000000
mCAN0RIER_WUPIE:    equ    %10000000


;*** CAN0TFLG - MSCAN0 Transmitter Flag Register; 0x00000146 ***
CAN0TFLG:           equ    $00000146                                ;*** CAN0TFLG - MSCAN0 Transmitter Flag Register; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN0TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN0TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN0TFLG_TXE0:     equ    %00000001
mCAN0TFLG_TXE1:     equ    %00000010
mCAN0TFLG_TXE2:     equ    %00000100


;*** CAN0TIER - MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 ***
CAN0TIER:           equ    $00000147                                ;*** CAN0TIER - MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN0TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN0TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN0TIER_TXEIE0:   equ    %00000001
mCAN0TIER_TXEIE1:   equ    %00000010
mCAN0TIER_TXEIE2:   equ    %00000100


;*** CAN0TARQ - MSCAN0 Transmitter Message Abort Request; 0x00000148 ***
CAN0TARQ:           equ    $00000148                                ;*** CAN0TARQ - MSCAN0 Transmitter Message Abort Request; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN0TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN0TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN0TARQ_ABTRQ0:   equ    %00000001
mCAN0TARQ_ABTRQ1:   equ    %00000010
mCAN0TARQ_ABTRQ2:   equ    %00000100


;*** CAN0TAAK - MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 ***
CAN0TAAK:           equ    $00000149                                ;*** CAN0TAAK - MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN0TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN0TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN0TAAK_ABTAK0:   equ    %00000001
mCAN0TAAK_ABTAK1:   equ    %00000010
mCAN0TAAK_ABTAK2:   equ    %00000100


;*** CAN0TBSEL - MSCAN0 Transmit Buffer Selection; 0x0000014A ***
CAN0TBSEL:          equ    $0000014A                                ;*** CAN0TBSEL - MSCAN0 Transmit Buffer Selection; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN0TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN0TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN0TBSEL_TX0:     equ    %00000001
mCAN0TBSEL_TX1:     equ    %00000010
mCAN0TBSEL_TX2:     equ    %00000100


;*** CAN0IDAC - MSCAN0 Identifier Acceptance Control Register; 0x0000014B ***
CAN0IDAC:           equ    $0000014B                                ;*** CAN0IDAC - MSCAN0 Identifier Acceptance Control Register; 0x0000014B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN0IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN0IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN0IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN0IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN0IDAC_IDHIT0:   equ    %00000001
mCAN0IDAC_IDHIT1:   equ    %00000010
mCAN0IDAC_IDHIT2:   equ    %00000100
mCAN0IDAC_IDAM0:    equ    %00010000
mCAN0IDAC_IDAM1:    equ    %00100000


;*** CAN0MISC - MSCAN0 Miscellaneous Register; 0x0000014D ***
CAN0MISC:           equ    $0000014D                                ;*** CAN0MISC - MSCAN0 Miscellaneous Register; 0x0000014D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0MISC_BOHOLD:    equ    0                                         ; Bus-off State Hold Until User Request
; bit position masks
mCAN0MISC_BOHOLD:   equ    %00000001


;*** CAN0RXERR - MSCAN0 Receive Error Counter Register; 0x0000014E ***
CAN0RXERR:          equ    $0000014E                                ;*** CAN0RXERR - MSCAN0 Receive Error Counter Register; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN0RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN0RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN0RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN0RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN0RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN0RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN0RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0RXERR_RXERR0:  equ    %00000001
mCAN0RXERR_RXERR1:  equ    %00000010
mCAN0RXERR_RXERR2:  equ    %00000100
mCAN0RXERR_RXERR3:  equ    %00001000
mCAN0RXERR_RXERR4:  equ    %00010000
mCAN0RXERR_RXERR5:  equ    %00100000
mCAN0RXERR_RXERR6:  equ    %01000000
mCAN0RXERR_RXERR7:  equ    %10000000


;*** CAN0TXERR - MSCAN0 Transmit Error Counter Register; 0x0000014F ***
CAN0TXERR:          equ    $0000014F                                ;*** CAN0TXERR - MSCAN0 Transmit Error Counter Register; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN0TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN0TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN0TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN0TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN0TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN0TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN0TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0TXERR_TXERR0:  equ    %00000001
mCAN0TXERR_TXERR1:  equ    %00000010
mCAN0TXERR_TXERR2:  equ    %00000100
mCAN0TXERR_TXERR3:  equ    %00001000
mCAN0TXERR_TXERR4:  equ    %00010000
mCAN0TXERR_TXERR5:  equ    %00100000
mCAN0TXERR_TXERR6:  equ    %01000000
mCAN0TXERR_TXERR7:  equ    %10000000


;*** CAN0IDAR0 - MSCAN0 Identifier Acceptance Register 0; 0x00000150 ***
CAN0IDAR0:          equ    $00000150                                ;*** CAN0IDAR0 - MSCAN0 Identifier Acceptance Register 0; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR0_AC0:     equ    %00000001
mCAN0IDAR0_AC1:     equ    %00000010
mCAN0IDAR0_AC2:     equ    %00000100
mCAN0IDAR0_AC3:     equ    %00001000
mCAN0IDAR0_AC4:     equ    %00010000
mCAN0IDAR0_AC5:     equ    %00100000
mCAN0IDAR0_AC6:     equ    %01000000
mCAN0IDAR0_AC7:     equ    %10000000


;*** CAN0IDAR1 - MSCAN0 Identifier Acceptance Register 1; 0x00000151 ***
CAN0IDAR1:          equ    $00000151                                ;*** CAN0IDAR1 - MSCAN0 Identifier Acceptance Register 1; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR1_AC0:     equ    %00000001
mCAN0IDAR1_AC1:     equ    %00000010
mCAN0IDAR1_AC2:     equ    %00000100
mCAN0IDAR1_AC3:     equ    %00001000
mCAN0IDAR1_AC4:     equ    %00010000
mCAN0IDAR1_AC5:     equ    %00100000
mCAN0IDAR1_AC6:     equ    %01000000
mCAN0IDAR1_AC7:     equ    %10000000


;*** CAN0IDAR2 - MSCAN0 Identifier Acceptance Register 2; 0x00000152 ***
CAN0IDAR2:          equ    $00000152                                ;*** CAN0IDAR2 - MSCAN0 Identifier Acceptance Register 2; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR2_AC0:     equ    %00000001
mCAN0IDAR2_AC1:     equ    %00000010
mCAN0IDAR2_AC2:     equ    %00000100
mCAN0IDAR2_AC3:     equ    %00001000
mCAN0IDAR2_AC4:     equ    %00010000
mCAN0IDAR2_AC5:     equ    %00100000
mCAN0IDAR2_AC6:     equ    %01000000
mCAN0IDAR2_AC7:     equ    %10000000


;*** CAN0IDAR3 - MSCAN0 Identifier Acceptance Register 3; 0x00000153 ***
CAN0IDAR3:          equ    $00000153                                ;*** CAN0IDAR3 - MSCAN0 Identifier Acceptance Register 3; 0x00000153 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR3_AC0:     equ    %00000001
mCAN0IDAR3_AC1:     equ    %00000010
mCAN0IDAR3_AC2:     equ    %00000100
mCAN0IDAR3_AC3:     equ    %00001000
mCAN0IDAR3_AC4:     equ    %00010000
mCAN0IDAR3_AC5:     equ    %00100000
mCAN0IDAR3_AC6:     equ    %01000000
mCAN0IDAR3_AC7:     equ    %10000000


;*** CAN0IDMR0 - MSCAN0 Identifier Mask Register 0; 0x00000154 ***
CAN0IDMR0:          equ    $00000154                                ;*** CAN0IDMR0 - MSCAN0 Identifier Mask Register 0; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR0_AM0:     equ    %00000001
mCAN0IDMR0_AM1:     equ    %00000010
mCAN0IDMR0_AM2:     equ    %00000100
mCAN0IDMR0_AM3:     equ    %00001000
mCAN0IDMR0_AM4:     equ    %00010000
mCAN0IDMR0_AM5:     equ    %00100000
mCAN0IDMR0_AM6:     equ    %01000000
mCAN0IDMR0_AM7:     equ    %10000000


;*** CAN0IDMR1 - MSCAN0 Identifier Mask Register 1; 0x00000155 ***
CAN0IDMR1:          equ    $00000155                                ;*** CAN0IDMR1 - MSCAN0 Identifier Mask Register 1; 0x00000155 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR1_AM0:     equ    %00000001
mCAN0IDMR1_AM1:     equ    %00000010
mCAN0IDMR1_AM2:     equ    %00000100
mCAN0IDMR1_AM3:     equ    %00001000
mCAN0IDMR1_AM4:     equ    %00010000
mCAN0IDMR1_AM5:     equ    %00100000
mCAN0IDMR1_AM6:     equ    %01000000
mCAN0IDMR1_AM7:     equ    %10000000


;*** CAN0IDMR2 - MSCAN0 Identifier Mask Register 2; 0x00000156 ***
CAN0IDMR2:          equ    $00000156                                ;*** CAN0IDMR2 - MSCAN0 Identifier Mask Register 2; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR2_AM0:     equ    %00000001
mCAN0IDMR2_AM1:     equ    %00000010
mCAN0IDMR2_AM2:     equ    %00000100
mCAN0IDMR2_AM3:     equ    %00001000
mCAN0IDMR2_AM4:     equ    %00010000
mCAN0IDMR2_AM5:     equ    %00100000
mCAN0IDMR2_AM6:     equ    %01000000
mCAN0IDMR2_AM7:     equ    %10000000


;*** CAN0IDMR3 - MSCAN0 Identifier Mask Register 3; 0x00000157 ***
CAN0IDMR3:          equ    $00000157                                ;*** CAN0IDMR3 - MSCAN0 Identifier Mask Register 3; 0x00000157 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR3_AM0:     equ    %00000001
mCAN0IDMR3_AM1:     equ    %00000010
mCAN0IDMR3_AM2:     equ    %00000100
mCAN0IDMR3_AM3:     equ    %00001000
mCAN0IDMR3_AM4:     equ    %00010000
mCAN0IDMR3_AM5:     equ    %00100000
mCAN0IDMR3_AM6:     equ    %01000000
mCAN0IDMR3_AM7:     equ    %10000000


;*** CAN0IDAR4 - MSCAN0 Identifier Acceptance Register 4; 0x00000158 ***
CAN0IDAR4:          equ    $00000158                                ;*** CAN0IDAR4 - MSCAN0 Identifier Acceptance Register 4; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR4_AC0:     equ    %00000001
mCAN0IDAR4_AC1:     equ    %00000010
mCAN0IDAR4_AC2:     equ    %00000100
mCAN0IDAR4_AC3:     equ    %00001000
mCAN0IDAR4_AC4:     equ    %00010000
mCAN0IDAR4_AC5:     equ    %00100000
mCAN0IDAR4_AC6:     equ    %01000000
mCAN0IDAR4_AC7:     equ    %10000000


;*** CAN0IDAR5 - MSCAN0 Identifier Acceptance Register 5; 0x00000159 ***
CAN0IDAR5:          equ    $00000159                                ;*** CAN0IDAR5 - MSCAN0 Identifier Acceptance Register 5; 0x00000159 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR5_AC0:     equ    %00000001
mCAN0IDAR5_AC1:     equ    %00000010
mCAN0IDAR5_AC2:     equ    %00000100
mCAN0IDAR5_AC3:     equ    %00001000
mCAN0IDAR5_AC4:     equ    %00010000
mCAN0IDAR5_AC5:     equ    %00100000
mCAN0IDAR5_AC6:     equ    %01000000
mCAN0IDAR5_AC7:     equ    %10000000


;*** CAN0IDAR6 - MSCAN0 Identifier Acceptance Register 6; 0x0000015A ***
CAN0IDAR6:          equ    $0000015A                                ;*** CAN0IDAR6 - MSCAN0 Identifier Acceptance Register 6; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR6_AC0:     equ    %00000001
mCAN0IDAR6_AC1:     equ    %00000010
mCAN0IDAR6_AC2:     equ    %00000100
mCAN0IDAR6_AC3:     equ    %00001000
mCAN0IDAR6_AC4:     equ    %00010000
mCAN0IDAR6_AC5:     equ    %00100000
mCAN0IDAR6_AC6:     equ    %01000000
mCAN0IDAR6_AC7:     equ    %10000000


;*** CAN0IDAR7 - MSCAN0 Identifier Acceptance Register 7; 0x0000015B ***
CAN0IDAR7:          equ    $0000015B                                ;*** CAN0IDAR7 - MSCAN0 Identifier Acceptance Register 7; 0x0000015B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR7_AC0:     equ    %00000001
mCAN0IDAR7_AC1:     equ    %00000010
mCAN0IDAR7_AC2:     equ    %00000100
mCAN0IDAR7_AC3:     equ    %00001000
mCAN0IDAR7_AC4:     equ    %00010000
mCAN0IDAR7_AC5:     equ    %00100000
mCAN0IDAR7_AC6:     equ    %01000000
mCAN0IDAR7_AC7:     equ    %10000000


;*** CAN0IDMR4 - MSCAN0 Identifier Mask Register 4; 0x0000015C ***
CAN0IDMR4:          equ    $0000015C                                ;*** CAN0IDMR4 - MSCAN0 Identifier Mask Register 4; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR4_AM0:     equ    %00000001
mCAN0IDMR4_AM1:     equ    %00000010
mCAN0IDMR4_AM2:     equ    %00000100
mCAN0IDMR4_AM3:     equ    %00001000
mCAN0IDMR4_AM4:     equ    %00010000
mCAN0IDMR4_AM5:     equ    %00100000
mCAN0IDMR4_AM6:     equ    %01000000
mCAN0IDMR4_AM7:     equ    %10000000


;*** CAN0IDMR5 - MSCAN0 Identifier Mask Register 5; 0x0000015D ***
CAN0IDMR5:          equ    $0000015D                                ;*** CAN0IDMR5 - MSCAN0 Identifier Mask Register 5; 0x0000015D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR5_AM0:     equ    %00000001
mCAN0IDMR5_AM1:     equ    %00000010
mCAN0IDMR5_AM2:     equ    %00000100
mCAN0IDMR5_AM3:     equ    %00001000
mCAN0IDMR5_AM4:     equ    %00010000
mCAN0IDMR5_AM5:     equ    %00100000
mCAN0IDMR5_AM6:     equ    %01000000
mCAN0IDMR5_AM7:     equ    %10000000


;*** CAN0IDMR6 - MSCAN0 Identifier Mask Register 6; 0x0000015E ***
CAN0IDMR6:          equ    $0000015E                                ;*** CAN0IDMR6 - MSCAN0 Identifier Mask Register 6; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR6_AM0:     equ    %00000001
mCAN0IDMR6_AM1:     equ    %00000010
mCAN0IDMR6_AM2:     equ    %00000100
mCAN0IDMR6_AM3:     equ    %00001000
mCAN0IDMR6_AM4:     equ    %00010000
mCAN0IDMR6_AM5:     equ    %00100000
mCAN0IDMR6_AM6:     equ    %01000000
mCAN0IDMR6_AM7:     equ    %10000000


;*** CAN0IDMR7 - MSCAN0 Identifier Mask Register 7; 0x0000015F ***
CAN0IDMR7:          equ    $0000015F                                ;*** CAN0IDMR7 - MSCAN0 Identifier Mask Register 7; 0x0000015F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR7_AM0:     equ    %00000001
mCAN0IDMR7_AM1:     equ    %00000010
mCAN0IDMR7_AM2:     equ    %00000100
mCAN0IDMR7_AM3:     equ    %00001000
mCAN0IDMR7_AM4:     equ    %00010000
mCAN0IDMR7_AM5:     equ    %00100000
mCAN0IDMR7_AM6:     equ    %01000000
mCAN0IDMR7_AM7:     equ    %10000000


;*** CAN0RXIDR0 - MSCAN0 Receive Identifier Register 0; 0x00000160 ***
CAN0RXIDR0:         equ    $00000160                                ;*** CAN0RXIDR0 - MSCAN0 Receive Identifier Register 0; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0RXIDR0_ID21:   equ    %00000001
mCAN0RXIDR0_ID22:   equ    %00000010
mCAN0RXIDR0_ID23:   equ    %00000100
mCAN0RXIDR0_ID24:   equ    %00001000
mCAN0RXIDR0_ID25:   equ    %00010000
mCAN0RXIDR0_ID26:   equ    %00100000
mCAN0RXIDR0_ID27:   equ    %01000000
mCAN0RXIDR0_ID28:   equ    %10000000


;*** CAN0RXIDR1 - MSCAN0 Receive Identifier Register 1; 0x00000161 ***
CAN0RXIDR1:         equ    $00000161                                ;*** CAN0RXIDR1 - MSCAN0 Receive Identifier Register 1; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0RXIDR1_ID15:   equ    %00000001
mCAN0RXIDR1_ID16:   equ    %00000010
mCAN0RXIDR1_ID17:   equ    %00000100
mCAN0RXIDR1_IDE:    equ    %00001000
mCAN0RXIDR1_SRR:    equ    %00010000
mCAN0RXIDR1_ID18:   equ    %00100000
mCAN0RXIDR1_ID19:   equ    %01000000
mCAN0RXIDR1_ID20:   equ    %10000000


;*** CAN0RXIDR2 - MSCAN0 Receive Identifier Register 2; 0x00000162 ***
CAN0RXIDR2:         equ    $00000162                                ;*** CAN0RXIDR2 - MSCAN0 Receive Identifier Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0RXIDR2_ID7:    equ    %00000001
mCAN0RXIDR2_ID8:    equ    %00000010
mCAN0RXIDR2_ID9:    equ    %00000100
mCAN0RXIDR2_ID10:   equ    %00001000
mCAN0RXIDR2_ID11:   equ    %00010000
mCAN0RXIDR2_ID12:   equ    %00100000
mCAN0RXIDR2_ID13:   equ    %01000000
mCAN0RXIDR2_ID14:   equ    %10000000


;*** CAN0RXIDR3 - MSCAN0 Receive Identifier Register 3; 0x00000163 ***
CAN0RXIDR3:         equ    $00000163                                ;*** CAN0RXIDR3 - MSCAN0 Receive Identifier Register 3; 0x00000163 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0RXIDR3_RTR:    equ    %00000001
mCAN0RXIDR3_ID0:    equ    %00000010
mCAN0RXIDR3_ID1:    equ    %00000100
mCAN0RXIDR3_ID2:    equ    %00001000
mCAN0RXIDR3_ID3:    equ    %00010000
mCAN0RXIDR3_ID4:    equ    %00100000
mCAN0RXIDR3_ID5:    equ    %01000000
mCAN0RXIDR3_ID6:    equ    %10000000


;*** CAN0RXDSR0 - MSCAN0 Receive Data Segment Register 0; 0x00000164 ***
CAN0RXDSR0:         equ    $00000164                                ;*** CAN0RXDSR0 - MSCAN0 Receive Data Segment Register 0; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR0_DB0:    equ    %00000001
mCAN0RXDSR0_DB1:    equ    %00000010
mCAN0RXDSR0_DB2:    equ    %00000100
mCAN0RXDSR0_DB3:    equ    %00001000
mCAN0RXDSR0_DB4:    equ    %00010000
mCAN0RXDSR0_DB5:    equ    %00100000
mCAN0RXDSR0_DB6:    equ    %01000000
mCAN0RXDSR0_DB7:    equ    %10000000


;*** CAN0RXDSR1 - MSCAN0 Receive Data Segment Register 1; 0x00000165 ***
CAN0RXDSR1:         equ    $00000165                                ;*** CAN0RXDSR1 - MSCAN0 Receive Data Segment Register 1; 0x00000165 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR1_DB0:    equ    %00000001
mCAN0RXDSR1_DB1:    equ    %00000010
mCAN0RXDSR1_DB2:    equ    %00000100
mCAN0RXDSR1_DB3:    equ    %00001000
mCAN0RXDSR1_DB4:    equ    %00010000
mCAN0RXDSR1_DB5:    equ    %00100000
mCAN0RXDSR1_DB6:    equ    %01000000
mCAN0RXDSR1_DB7:    equ    %10000000


;*** CAN0RXDSR2 - MSCAN0 Receive Data Segment Register 2; 0x00000166 ***
CAN0RXDSR2:         equ    $00000166                                ;*** CAN0RXDSR2 - MSCAN0 Receive Data Segment Register 2; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR2_DB0:    equ    %00000001
mCAN0RXDSR2_DB1:    equ    %00000010
mCAN0RXDSR2_DB2:    equ    %00000100
mCAN0RXDSR2_DB3:    equ    %00001000
mCAN0RXDSR2_DB4:    equ    %00010000
mCAN0RXDSR2_DB5:    equ    %00100000
mCAN0RXDSR2_DB6:    equ    %01000000
mCAN0RXDSR2_DB7:    equ    %10000000


;*** CAN0RXDSR3 - MSCAN0 Receive Data Segment Register 3; 0x00000167 ***
CAN0RXDSR3:         equ    $00000167                                ;*** CAN0RXDSR3 - MSCAN0 Receive Data Segment Register 3; 0x00000167 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR3_DB0:    equ    %00000001
mCAN0RXDSR3_DB1:    equ    %00000010
mCAN0RXDSR3_DB2:    equ    %00000100
mCAN0RXDSR3_DB3:    equ    %00001000
mCAN0RXDSR3_DB4:    equ    %00010000
mCAN0RXDSR3_DB5:    equ    %00100000
mCAN0RXDSR3_DB6:    equ    %01000000
mCAN0RXDSR3_DB7:    equ    %10000000


;*** CAN0RXDSR4 - MSCAN0 Receive Data Segment Register 4; 0x00000168 ***
CAN0RXDSR4:         equ    $00000168                                ;*** CAN0RXDSR4 - MSCAN0 Receive Data Segment Register 4; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR4_DB0:    equ    %00000001
mCAN0RXDSR4_DB1:    equ    %00000010
mCAN0RXDSR4_DB2:    equ    %00000100
mCAN0RXDSR4_DB3:    equ    %00001000
mCAN0RXDSR4_DB4:    equ    %00010000
mCAN0RXDSR4_DB5:    equ    %00100000
mCAN0RXDSR4_DB6:    equ    %01000000
mCAN0RXDSR4_DB7:    equ    %10000000


;*** CAN0RXDSR5 - MSCAN0 Receive Data Segment Register 5; 0x00000169 ***
CAN0RXDSR5:         equ    $00000169                                ;*** CAN0RXDSR5 - MSCAN0 Receive Data Segment Register 5; 0x00000169 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR5_DB0:    equ    %00000001
mCAN0RXDSR5_DB1:    equ    %00000010
mCAN0RXDSR5_DB2:    equ    %00000100
mCAN0RXDSR5_DB3:    equ    %00001000
mCAN0RXDSR5_DB4:    equ    %00010000
mCAN0RXDSR5_DB5:    equ    %00100000
mCAN0RXDSR5_DB6:    equ    %01000000
mCAN0RXDSR5_DB7:    equ    %10000000


;*** CAN0RXDSR6 - MSCAN0 Receive Data Segment Register 6; 0x0000016A ***
CAN0RXDSR6:         equ    $0000016A                                ;*** CAN0RXDSR6 - MSCAN0 Receive Data Segment Register 6; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR6_DB0:    equ    %00000001
mCAN0RXDSR6_DB1:    equ    %00000010
mCAN0RXDSR6_DB2:    equ    %00000100
mCAN0RXDSR6_DB3:    equ    %00001000
mCAN0RXDSR6_DB4:    equ    %00010000
mCAN0RXDSR6_DB5:    equ    %00100000
mCAN0RXDSR6_DB6:    equ    %01000000
mCAN0RXDSR6_DB7:    equ    %10000000


;*** CAN0RXDSR7 - MSCAN0 Receive Data Segment Register 7; 0x0000016B ***
CAN0RXDSR7:         equ    $0000016B                                ;*** CAN0RXDSR7 - MSCAN0 Receive Data Segment Register 7; 0x0000016B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR7_DB0:    equ    %00000001
mCAN0RXDSR7_DB1:    equ    %00000010
mCAN0RXDSR7_DB2:    equ    %00000100
mCAN0RXDSR7_DB3:    equ    %00001000
mCAN0RXDSR7_DB4:    equ    %00010000
mCAN0RXDSR7_DB5:    equ    %00100000
mCAN0RXDSR7_DB6:    equ    %01000000
mCAN0RXDSR7_DB7:    equ    %10000000


;*** CAN0RXDLR - MSCAN0 Receive Data Length Register; 0x0000016C ***
CAN0RXDLR:          equ    $0000016C                                ;*** CAN0RXDLR - MSCAN0 Receive Data Length Register; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0RXDLR_DLC0:    equ    %00000001
mCAN0RXDLR_DLC1:    equ    %00000010
mCAN0RXDLR_DLC2:    equ    %00000100
mCAN0RXDLR_DLC3:    equ    %00001000


;*** CAN0RXTSR - MSCAN0 Receive Time Stamp Register; 0x0000016E ***
CAN0RXTSR:          equ    $0000016E                                ;*** CAN0RXTSR - MSCAN0 Receive Time Stamp Register; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSR_TSR0:    equ    %00000001
mCAN0RXTSR_TSR1:    equ    %00000010
mCAN0RXTSR_TSR2:    equ    %00000100
mCAN0RXTSR_TSR3:    equ    %00001000
mCAN0RXTSR_TSR4:    equ    %00010000
mCAN0RXTSR_TSR5:    equ    %00100000
mCAN0RXTSR_TSR6:    equ    %01000000
mCAN0RXTSR_TSR7:    equ    %10000000
mCAN0RXTSR_TSR8:    equ    %100000000
mCAN0RXTSR_TSR9:    equ    %1000000000
mCAN0RXTSR_TSR10:   equ    %10000000000
mCAN0RXTSR_TSR11:   equ    %100000000000
mCAN0RXTSR_TSR12:   equ    %1000000000000
mCAN0RXTSR_TSR13:   equ    %10000000000000
mCAN0RXTSR_TSR14:   equ    %100000000000000
mCAN0RXTSR_TSR15:   equ    %1000000000000000


;*** CAN0RXTSRH - MSCAN0 Receive Time Stamp Register High; 0x0000016E ***
CAN0RXTSRH:         equ    $0000016E                                ;*** CAN0RXTSRH - MSCAN0 Receive Time Stamp Register High; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSRH_TSR8:   equ    %00000001
mCAN0RXTSRH_TSR9:   equ    %00000010
mCAN0RXTSRH_TSR10:  equ    %00000100
mCAN0RXTSRH_TSR11:  equ    %00001000
mCAN0RXTSRH_TSR12:  equ    %00010000
mCAN0RXTSRH_TSR13:  equ    %00100000
mCAN0RXTSRH_TSR14:  equ    %01000000
mCAN0RXTSRH_TSR15:  equ    %10000000


;*** CAN0RXTSRL - MSCAN0 Receive Time Stamp Register Low; 0x0000016F ***
CAN0RXTSRL:         equ    $0000016F                                ;*** CAN0RXTSRL - MSCAN0 Receive Time Stamp Register Low; 0x0000016F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0RXTSRL_TSR0:   equ    %00000001
mCAN0RXTSRL_TSR1:   equ    %00000010
mCAN0RXTSRL_TSR2:   equ    %00000100
mCAN0RXTSRL_TSR3:   equ    %00001000
mCAN0RXTSRL_TSR4:   equ    %00010000
mCAN0RXTSRL_TSR5:   equ    %00100000
mCAN0RXTSRL_TSR6:   equ    %01000000
mCAN0RXTSRL_TSR7:   equ    %10000000


;*** CAN0TXIDR0 - MSCAN0 Transmit Identifier Register 0; 0x00000170 ***
CAN0TXIDR0:         equ    $00000170                                ;*** CAN0TXIDR0 - MSCAN0 Transmit Identifier Register 0; 0x00000170 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0TXIDR0_ID21:   equ    %00000001
mCAN0TXIDR0_ID22:   equ    %00000010
mCAN0TXIDR0_ID23:   equ    %00000100
mCAN0TXIDR0_ID24:   equ    %00001000
mCAN0TXIDR0_ID25:   equ    %00010000
mCAN0TXIDR0_ID26:   equ    %00100000
mCAN0TXIDR0_ID27:   equ    %01000000
mCAN0TXIDR0_ID28:   equ    %10000000


;*** CAN0TXIDR1 - MSCAN0 Transmit Identifier Register 1; 0x00000171 ***
CAN0TXIDR1:         equ    $00000171                                ;*** CAN0TXIDR1 - MSCAN0 Transmit Identifier Register 1; 0x00000171 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0TXIDR1_ID15:   equ    %00000001
mCAN0TXIDR1_ID16:   equ    %00000010
mCAN0TXIDR1_ID17:   equ    %00000100
mCAN0TXIDR1_IDE:    equ    %00001000
mCAN0TXIDR1_SRR:    equ    %00010000
mCAN0TXIDR1_ID18:   equ    %00100000
mCAN0TXIDR1_ID19:   equ    %01000000
mCAN0TXIDR1_ID20:   equ    %10000000


;*** CAN0TXIDR2 - MSCAN0 Transmit Identifier Register 2; 0x00000172 ***
CAN0TXIDR2:         equ    $00000172                                ;*** CAN0TXIDR2 - MSCAN0 Transmit Identifier Register 2; 0x00000172 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0TXIDR2_ID7:    equ    %00000001
mCAN0TXIDR2_ID8:    equ    %00000010
mCAN0TXIDR2_ID9:    equ    %00000100
mCAN0TXIDR2_ID10:   equ    %00001000
mCAN0TXIDR2_ID11:   equ    %00010000
mCAN0TXIDR2_ID12:   equ    %00100000
mCAN0TXIDR2_ID13:   equ    %01000000
mCAN0TXIDR2_ID14:   equ    %10000000


;*** CAN0TXIDR3 - MSCAN0 Transmit Identifier Register 3; 0x00000173 ***
CAN0TXIDR3:         equ    $00000173                                ;*** CAN0TXIDR3 - MSCAN0 Transmit Identifier Register 3; 0x00000173 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0TXIDR3_RTR:    equ    %00000001
mCAN0TXIDR3_ID0:    equ    %00000010
mCAN0TXIDR3_ID1:    equ    %00000100
mCAN0TXIDR3_ID2:    equ    %00001000
mCAN0TXIDR3_ID3:    equ    %00010000
mCAN0TXIDR3_ID4:    equ    %00100000
mCAN0TXIDR3_ID5:    equ    %01000000
mCAN0TXIDR3_ID6:    equ    %10000000


;*** CAN0TXDSR0 - MSCAN0 Transmit Data Segment Register 0; 0x00000174 ***
CAN0TXDSR0:         equ    $00000174                                ;*** CAN0TXDSR0 - MSCAN0 Transmit Data Segment Register 0; 0x00000174 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR0_DB0:    equ    %00000001
mCAN0TXDSR0_DB1:    equ    %00000010
mCAN0TXDSR0_DB2:    equ    %00000100
mCAN0TXDSR0_DB3:    equ    %00001000
mCAN0TXDSR0_DB4:    equ    %00010000
mCAN0TXDSR0_DB5:    equ    %00100000
mCAN0TXDSR0_DB6:    equ    %01000000
mCAN0TXDSR0_DB7:    equ    %10000000


;*** CAN0TXDSR1 - MSCAN0 Transmit Data Segment Register 1; 0x00000175 ***
CAN0TXDSR1:         equ    $00000175                                ;*** CAN0TXDSR1 - MSCAN0 Transmit Data Segment Register 1; 0x00000175 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR1_DB0:    equ    %00000001
mCAN0TXDSR1_DB1:    equ    %00000010
mCAN0TXDSR1_DB2:    equ    %00000100
mCAN0TXDSR1_DB3:    equ    %00001000
mCAN0TXDSR1_DB4:    equ    %00010000
mCAN0TXDSR1_DB5:    equ    %00100000
mCAN0TXDSR1_DB6:    equ    %01000000
mCAN0TXDSR1_DB7:    equ    %10000000


;*** CAN0TXDSR2 - MSCAN0 Transmit Data Segment Register 2; 0x00000176 ***
CAN0TXDSR2:         equ    $00000176                                ;*** CAN0TXDSR2 - MSCAN0 Transmit Data Segment Register 2; 0x00000176 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR2_DB0:    equ    %00000001
mCAN0TXDSR2_DB1:    equ    %00000010
mCAN0TXDSR2_DB2:    equ    %00000100
mCAN0TXDSR2_DB3:    equ    %00001000
mCAN0TXDSR2_DB4:    equ    %00010000
mCAN0TXDSR2_DB5:    equ    %00100000
mCAN0TXDSR2_DB6:    equ    %01000000
mCAN0TXDSR2_DB7:    equ    %10000000


;*** CAN0TXDSR3 - MSCAN0 Transmit Data Segment Register 3; 0x00000177 ***
CAN0TXDSR3:         equ    $00000177                                ;*** CAN0TXDSR3 - MSCAN0 Transmit Data Segment Register 3; 0x00000177 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR3_DB0:    equ    %00000001
mCAN0TXDSR3_DB1:    equ    %00000010
mCAN0TXDSR3_DB2:    equ    %00000100
mCAN0TXDSR3_DB3:    equ    %00001000
mCAN0TXDSR3_DB4:    equ    %00010000
mCAN0TXDSR3_DB5:    equ    %00100000
mCAN0TXDSR3_DB6:    equ    %01000000
mCAN0TXDSR3_DB7:    equ    %10000000


;*** CAN0TXDSR4 - MSCAN0 Transmit Data Segment Register 4; 0x00000178 ***
CAN0TXDSR4:         equ    $00000178                                ;*** CAN0TXDSR4 - MSCAN0 Transmit Data Segment Register 4; 0x00000178 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR4_DB0:    equ    %00000001
mCAN0TXDSR4_DB1:    equ    %00000010
mCAN0TXDSR4_DB2:    equ    %00000100
mCAN0TXDSR4_DB3:    equ    %00001000
mCAN0TXDSR4_DB4:    equ    %00010000
mCAN0TXDSR4_DB5:    equ    %00100000
mCAN0TXDSR4_DB6:    equ    %01000000
mCAN0TXDSR4_DB7:    equ    %10000000


;*** CAN0TXDSR5 - MSCAN0 Transmit Data Segment Register 5; 0x00000179 ***
CAN0TXDSR5:         equ    $00000179                                ;*** CAN0TXDSR5 - MSCAN0 Transmit Data Segment Register 5; 0x00000179 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR5_DB0:    equ    %00000001
mCAN0TXDSR5_DB1:    equ    %00000010
mCAN0TXDSR5_DB2:    equ    %00000100
mCAN0TXDSR5_DB3:    equ    %00001000
mCAN0TXDSR5_DB4:    equ    %00010000
mCAN0TXDSR5_DB5:    equ    %00100000
mCAN0TXDSR5_DB6:    equ    %01000000
mCAN0TXDSR5_DB7:    equ    %10000000


;*** CAN0TXDSR6 - MSCAN0 Transmit Data Segment Register 6; 0x0000017A ***
CAN0TXDSR6:         equ    $0000017A                                ;*** CAN0TXDSR6 - MSCAN0 Transmit Data Segment Register 6; 0x0000017A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR6_DB0:    equ    %00000001
mCAN0TXDSR6_DB1:    equ    %00000010
mCAN0TXDSR6_DB2:    equ    %00000100
mCAN0TXDSR6_DB3:    equ    %00001000
mCAN0TXDSR6_DB4:    equ    %00010000
mCAN0TXDSR6_DB5:    equ    %00100000
mCAN0TXDSR6_DB6:    equ    %01000000
mCAN0TXDSR6_DB7:    equ    %10000000


;*** CAN0TXDSR7 - MSCAN0 Transmit Data Segment Register 7; 0x0000017B ***
CAN0TXDSR7:         equ    $0000017B                                ;*** CAN0TXDSR7 - MSCAN0 Transmit Data Segment Register 7; 0x0000017B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR7_DB0:    equ    %00000001
mCAN0TXDSR7_DB1:    equ    %00000010
mCAN0TXDSR7_DB2:    equ    %00000100
mCAN0TXDSR7_DB3:    equ    %00001000
mCAN0TXDSR7_DB4:    equ    %00010000
mCAN0TXDSR7_DB5:    equ    %00100000
mCAN0TXDSR7_DB6:    equ    %01000000
mCAN0TXDSR7_DB7:    equ    %10000000


;*** CAN0TXDLR - MSCAN0 Transmit Data Length Register; 0x0000017C ***
CAN0TXDLR:          equ    $0000017C                                ;*** CAN0TXDLR - MSCAN0 Transmit Data Length Register; 0x0000017C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0TXDLR_DLC0:    equ    %00000001
mCAN0TXDLR_DLC1:    equ    %00000010
mCAN0TXDLR_DLC2:    equ    %00000100
mCAN0TXDLR_DLC3:    equ    %00001000


;*** CAN0TXTBPR - MSCAN0 Transmit Buffer Priority; 0x0000017D ***
CAN0TXTBPR:         equ    $0000017D                                ;*** CAN0TXTBPR - MSCAN0 Transmit Buffer Priority; 0x0000017D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN0TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN0TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN0TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN0TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN0TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN0TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN0TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN0TXTBPR_PRIO0:  equ    %00000001
mCAN0TXTBPR_PRIO1:  equ    %00000010
mCAN0TXTBPR_PRIO2:  equ    %00000100
mCAN0TXTBPR_PRIO3:  equ    %00001000
mCAN0TXTBPR_PRIO4:  equ    %00010000
mCAN0TXTBPR_PRIO5:  equ    %00100000
mCAN0TXTBPR_PRIO6:  equ    %01000000
mCAN0TXTBPR_PRIO7:  equ    %10000000


;*** CAN0TXTSR - MSCAN0 Transmit Time Stamp Register; 0x0000017E ***
CAN0TXTSR:          equ    $0000017E                                ;*** CAN0TXTSR - MSCAN0 Transmit Time Stamp Register; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSR_TSR0:    equ    %00000001
mCAN0TXTSR_TSR1:    equ    %00000010
mCAN0TXTSR_TSR2:    equ    %00000100
mCAN0TXTSR_TSR3:    equ    %00001000
mCAN0TXTSR_TSR4:    equ    %00010000
mCAN0TXTSR_TSR5:    equ    %00100000
mCAN0TXTSR_TSR6:    equ    %01000000
mCAN0TXTSR_TSR7:    equ    %10000000
mCAN0TXTSR_TSR8:    equ    %100000000
mCAN0TXTSR_TSR9:    equ    %1000000000
mCAN0TXTSR_TSR10:   equ    %10000000000
mCAN0TXTSR_TSR11:   equ    %100000000000
mCAN0TXTSR_TSR12:   equ    %1000000000000
mCAN0TXTSR_TSR13:   equ    %10000000000000
mCAN0TXTSR_TSR14:   equ    %100000000000000
mCAN0TXTSR_TSR15:   equ    %1000000000000000


;*** CAN0TXTSRH - MSCAN0 Transmit Time Stamp Register High; 0x0000017E ***
CAN0TXTSRH:         equ    $0000017E                                ;*** CAN0TXTSRH - MSCAN0 Transmit Time Stamp Register High; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSRH_TSR8:   equ    %00000001
mCAN0TXTSRH_TSR9:   equ    %00000010
mCAN0TXTSRH_TSR10:  equ    %00000100
mCAN0TXTSRH_TSR11:  equ    %00001000
mCAN0TXTSRH_TSR12:  equ    %00010000
mCAN0TXTSRH_TSR13:  equ    %00100000
mCAN0TXTSRH_TSR14:  equ    %01000000
mCAN0TXTSRH_TSR15:  equ    %10000000


;*** CAN0TXTSRL - MSCAN0 Transmit Time Stamp Register Low; 0x0000017F ***
CAN0TXTSRL:         equ    $0000017F                                ;*** CAN0TXTSRL - MSCAN0 Transmit Time Stamp Register Low; 0x0000017F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0TXTSRL_TSR0:   equ    %00000001
mCAN0TXTSRL_TSR1:   equ    %00000010
mCAN0TXTSRL_TSR2:   equ    %00000100
mCAN0TXTSRL_TSR3:   equ    %00001000
mCAN0TXTSRL_TSR4:   equ    %00010000
mCAN0TXTSRL_TSR5:   equ    %00100000
mCAN0TXTSRL_TSR6:   equ    %01000000
mCAN0TXTSRL_TSR7:   equ    %10000000


;*** PMFCFG0 - PMF Configure 0 Register; 0x00000200 ***
PMFCFG0:            equ    $00000200                                ;*** PMFCFG0 - PMF Configure 0 Register; 0x00000200 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCFG0_INDEPA:     equ    0                                         ; Independent or Complimentary Operation for Pair A
PMFCFG0_INDEPB:     equ    1                                         ; Independent or Complimentary Operation for Pair B
PMFCFG0_INDEPC:     equ    2                                         ; Independent or Complimentary Operation for Pair C
PMFCFG0_EDGEA:      equ    3                                         ; Edge-Aligned or Center-Aligned PWM for Pair A
PMFCFG0_EDGEB:      equ    4                                         ; Edge-Aligned or Center-Aligned PWM for Pair B
PMFCFG0_EDGEC:      equ    5                                         ; Edge-Aligned or Center-Aligned PWM for Pair C
PMFCFG0_MTG:        equ    6                                         ; Multiple Timebase Generators
PMFCFG0_WP:         equ    7                                         ; Write Protect
; bit position masks
mPMFCFG0_INDEPA:    equ    %00000001
mPMFCFG0_INDEPB:    equ    %00000010
mPMFCFG0_INDEPC:    equ    %00000100
mPMFCFG0_EDGEA:     equ    %00001000
mPMFCFG0_EDGEB:     equ    %00010000
mPMFCFG0_EDGEC:     equ    %00100000
mPMFCFG0_MTG:       equ    %01000000
mPMFCFG0_WP:        equ    %10000000


;*** PMFCFG1 - PMF Configure 1 Register; 0x00000201 ***
PMFCFG1:            equ    $00000201                                ;*** PMFCFG1 - PMF Configure 1 Register; 0x00000201 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCFG1_TOPNEGA:    equ    0                                         ; Pair A Top-Side PWM Polarity
PMFCFG1_BOTNEGA:    equ    1                                         ; Pair A Bottom-Side PWM Polarity
PMFCFG1_TOPNEGB:    equ    2                                         ; Pair B Top-Side PWM Polarity
PMFCFG1_BOTNEGB:    equ    3                                         ; Pair A Bottom-Side PWM Polarity
PMFCFG1_TOPNEGC:    equ    4                                         ; Pair C Top-Side PWM Polarity
PMFCFG1_BOTNEGC:    equ    5                                         ; Pair C Bottom-Side PWM Polarity
PMFCFG1_ENHA:       equ    7                                         ; Enable Hardware Acceleration
; bit position masks
mPMFCFG1_TOPNEGA:   equ    %00000001
mPMFCFG1_BOTNEGA:   equ    %00000010
mPMFCFG1_TOPNEGB:   equ    %00000100
mPMFCFG1_BOTNEGB:   equ    %00001000
mPMFCFG1_TOPNEGC:   equ    %00010000
mPMFCFG1_BOTNEGC:   equ    %00100000
mPMFCFG1_ENHA:      equ    %10000000


;*** PMFCFG2 - PMF Configure 2 Register; 0x00000202 ***
PMFCFG2:            equ    $00000202                                ;*** PMFCFG2 - PMF Configure 2 Register; 0x00000202 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCFG2_MSK0:       equ    0                                         ; Mask PWM0 Bit0
PMFCFG2_MSK1:       equ    1                                         ; Mask PWM1 Bit1
PMFCFG2_MSK2:       equ    2                                         ; Mask PWM2 Bit2
PMFCFG2_MSK3:       equ    3                                         ; Mask PWM3 Bit3
PMFCFG2_MSK4:       equ    4                                         ; Mask PWM4 Bit4
PMFCFG2_MSK5:       equ    5                                         ; Mask PWM5 Bit5
; bit position masks
mPMFCFG2_MSK0:      equ    %00000001
mPMFCFG2_MSK1:      equ    %00000010
mPMFCFG2_MSK2:      equ    %00000100
mPMFCFG2_MSK3:      equ    %00001000
mPMFCFG2_MSK4:      equ    %00010000
mPMFCFG2_MSK5:      equ    %00100000


;*** PMFCFG3 - PMF Configure 3 Register; 0x00000203 ***
PMFCFG3:            equ    $00000203                                ;*** PMFCFG3 - PMF Configure 3 Register; 0x00000203 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCFG3_SWAPA:      equ    0                                         ; Swap Pair A
PMFCFG3_SWAPB:      equ    1                                         ; Swap Pair B
PMFCFG3_SWAPC:      equ    2                                         ; Swap Pair C
PMFCFG3_VLMODE0:    equ    3                                         ; Value Register Load Mode, bit 0
PMFCFG3_VLMODE1:    equ    4                                         ; Value Register Load Mode, bit 1
PMFCFG3_PMFFRZ:     equ    6                                         ; PMF Stops While in FREEZE Mode
PMFCFG3_PMFWAI:     equ    7                                         ; PMF Stops While in WAIT Mode
; bit position masks
mPMFCFG3_SWAPA:     equ    %00000001
mPMFCFG3_SWAPB:     equ    %00000010
mPMFCFG3_SWAPC:     equ    %00000100
mPMFCFG3_VLMODE0:   equ    %00001000
mPMFCFG3_VLMODE1:   equ    %00010000
mPMFCFG3_PMFFRZ:    equ    %01000000
mPMFCFG3_PMFWAI:    equ    %10000000


;*** PMFFCTL - PMF Fault Control Register; 0x00000204 ***
PMFFCTL:            equ    $00000204                                ;*** PMFFCTL - PMF Fault Control Register; 0x00000204 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFCTL_FIE0:       equ    0                                         ; Fault 0 Pin Interrupt Enable
PMFFCTL_FMODE0:     equ    1                                         ; Fault 0 Pin Clearing Mode
PMFFCTL_FIE1:       equ    2                                         ; Fault 1 Pin Interrupt Enable
PMFFCTL_FMODE1:     equ    3                                         ; Fault 1 Pin Clearing Mode
PMFFCTL_FIE2:       equ    4                                         ; Fault 2 Pin Interrupt Enable
PMFFCTL_FMODE2:     equ    5                                         ; Fault 2 Pin Clearing Mode
PMFFCTL_FIE3:       equ    6                                         ; Fault 3 Pin Interrupt Enable
PMFFCTL_FMODE3:     equ    7                                         ; Fault 3 Pin Clearing Mode
; bit position masks
mPMFFCTL_FIE0:      equ    %00000001
mPMFFCTL_FMODE0:    equ    %00000010
mPMFFCTL_FIE1:      equ    %00000100
mPMFFCTL_FMODE1:    equ    %00001000
mPMFFCTL_FIE2:      equ    %00010000
mPMFFCTL_FMODE2:    equ    %00100000
mPMFFCTL_FIE3:      equ    %01000000
mPMFFCTL_FMODE3:    equ    %10000000


;*** PMFFPIN - PMF Fault Pin Enable Register; 0x00000205 ***
PMFFPIN:            equ    $00000205                                ;*** PMFFPIN - PMF Fault Pin Enable Register; 0x00000205 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFPIN_FPINE0:     equ    0                                         ; Fault 0 Pin Enable
PMFFPIN_FPINE1:     equ    2                                         ; Fault 1 Pin Enable
PMFFPIN_FPINE2:     equ    4                                         ; Fault 2 Pin Enable
PMFFPIN_FPINE3:     equ    6                                         ; Fault 3 Pin Enable
; bit position masks
mPMFFPIN_FPINE0:    equ    %00000001
mPMFFPIN_FPINE1:    equ    %00000100
mPMFFPIN_FPINE2:    equ    %00010000
mPMFFPIN_FPINE3:    equ    %01000000


;*** PMFFSTA - PMF Fault Status Register; 0x00000206 ***
PMFFSTA:            equ    $00000206                                ;*** PMFFSTA - PMF Fault Status Register; 0x00000206 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFSTA_FFLAG0:     equ    0                                         ; Fault 0 pin Flag
PMFFSTA_FFLAG1:     equ    2                                         ; Fault 1 pin Flag
PMFFSTA_FFLAG2:     equ    4                                         ; Fault 2 pin Flag
PMFFSTA_FFLAG3:     equ    6                                         ; Fault 3 pin Flag
; bit position masks
mPMFFSTA_FFLAG0:    equ    %00000001
mPMFFSTA_FFLAG1:    equ    %00000100
mPMFFSTA_FFLAG2:    equ    %00010000
mPMFFSTA_FFLAG3:    equ    %01000000


;*** PMFQSMP - PMF Fault Qualifying Samples Register; 0x00000207 ***
PMFQSMP:            equ    $00000207                                ;*** PMFQSMP - PMF Fault Qualifying Samples Register; 0x00000207 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFQSMP_QSMP0:      equ    0                                         ; Fault 0 Qualifying Samples
PMFQSMP_QSMP1:      equ    2                                         ; Fault 1 Qualifying Samples
PMFQSMP_QSMP2:      equ    4                                         ; Fault 2 Qualifying Samples
PMFQSMP_QSMP3:      equ    6                                         ; Fault 3 Qualifying Samples
; bit position masks
mPMFQSMP_QSMP0:     equ    %00000011
mPMFQSMP_QSMP1:     equ    %00001100
mPMFQSMP_QSMP2:     equ    %00110000
mPMFQSMP_QSMP3:     equ    %11000000


;*** PMFDMPA - PMF Disable Mapping Register; 0x00000208 ***
PMFDMPA:            equ    $00000208                                ;*** PMFDMPA - PMF Disable Mapping Register; 0x00000208 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDMPA_DMP00:      equ    0                                         ; Disable PWM pin 0 by fault 0
PMFDMPA_DMP01:      equ    1                                         ; Disable PWM pin 0 by fault 1
PMFDMPA_DMP02:      equ    2                                         ; Disable PWM pin 0 by fault 2
PMFDMPA_DMP03:      equ    3                                         ; Disable PWM pin 0 by fault 3
PMFDMPA_DMP10:      equ    4                                         ; Disable PWM pin 1 by fault 0
PMFDMPA_DMP11:      equ    5                                         ; Disable PWM pin 1 by fault 1
PMFDMPA_DMP12:      equ    6                                         ; Disable PWM pin 1 by fault 2
PMFDMPA_DMP13:      equ    7                                         ; Disable PWM pin 1 by fault 3
; bit position masks
mPMFDMPA_DMP00:     equ    %00000001
mPMFDMPA_DMP01:     equ    %00000010
mPMFDMPA_DMP02:     equ    %00000100
mPMFDMPA_DMP03:     equ    %00001000
mPMFDMPA_DMP10:     equ    %00010000
mPMFDMPA_DMP11:     equ    %00100000
mPMFDMPA_DMP12:     equ    %01000000
mPMFDMPA_DMP13:     equ    %10000000


;*** PMFDMPB - PMF Disable Mapping Register; 0x00000209 ***
PMFDMPB:            equ    $00000209                                ;*** PMFDMPB - PMF Disable Mapping Register; 0x00000209 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDMPB_DMP20:      equ    0                                         ; Disable PWM pin 2 by fault 0
PMFDMPB_DMP21:      equ    1                                         ; Disable PWM pin 2 by fault 1
PMFDMPB_DMP22:      equ    2                                         ; Disable PWM pin 2 by fault 2
PMFDMPB_DMP23:      equ    3                                         ; Disable PWM pin 2 by fault 3
PMFDMPB_DMP30:      equ    4                                         ; Disable PWM pin 3 by fault 0
PMFDMPB_DMP31:      equ    5                                         ; Disable PWM pin 3 by fault 1
PMFDMPB_DMP32:      equ    6                                         ; Disable PWM pin 3 by fault 2
PMFDMPB_DMP33:      equ    7                                         ; Disable PWM pin 3 by fault 3
; bit position masks
mPMFDMPB_DMP20:     equ    %00000001
mPMFDMPB_DMP21:     equ    %00000010
mPMFDMPB_DMP22:     equ    %00000100
mPMFDMPB_DMP23:     equ    %00001000
mPMFDMPB_DMP30:     equ    %00010000
mPMFDMPB_DMP31:     equ    %00100000
mPMFDMPB_DMP32:     equ    %01000000
mPMFDMPB_DMP33:     equ    %10000000


;*** PMFDMPC - PMF Disable Mapping Register; 0x0000020A ***
PMFDMPC:            equ    $0000020A                                ;*** PMFDMPC - PMF Disable Mapping Register; 0x0000020A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDMPC_DMP40:      equ    0                                         ; Disable PWM pin 4 by fault 0
PMFDMPC_DMP41:      equ    1                                         ; Disable PWM pin 4 by fault 1
PMFDMPC_DMP42:      equ    2                                         ; Disable PWM pin 4 by fault 2
PMFDMPC_DMP43:      equ    3                                         ; Disable PWM pin 4 by fault 3
PMFDMPC_DMP50:      equ    4                                         ; Disable PWM pin 5 by fault 0
PMFDMPC_DMP51:      equ    5                                         ; Disable PWM pin 5 by fault 1
PMFDMPC_DMP52:      equ    6                                         ; Disable PWM pin 5 by fault 2
PMFDMPC_DMP53:      equ    7                                         ; Disable PWM pin 5 by fault 3
; bit position masks
mPMFDMPC_DMP40:     equ    %00000001
mPMFDMPC_DMP41:     equ    %00000010
mPMFDMPC_DMP42:     equ    %00000100
mPMFDMPC_DMP43:     equ    %00001000
mPMFDMPC_DMP50:     equ    %00010000
mPMFDMPC_DMP51:     equ    %00100000
mPMFDMPC_DMP52:     equ    %01000000
mPMFDMPC_DMP53:     equ    %10000000


;*** PMFOUTC - PMF Output Control Register; 0x0000020C ***
PMFOUTC:            equ    $0000020C                                ;*** PMFOUTC - PMF Output Control Register; 0x0000020C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFOUTC_OUTCTL0:    equ    0                                         ; OUTCTL0 Bits
PMFOUTC_OUTCTL1:    equ    1                                         ; OUTCTL1 Bits
PMFOUTC_OUTCTL2:    equ    2                                         ; OUTCTL2 Bits
PMFOUTC_OUTCTL3:    equ    3                                         ; OUTCTL3 Bits
PMFOUTC_OUTCTL4:    equ    4                                         ; OUTCTL4 Bits
PMFOUTC_OUTCTL5:    equ    5                                         ; OUTCTL5 Bits
; bit position masks
mPMFOUTC_OUTCTL0:   equ    %00000001
mPMFOUTC_OUTCTL1:   equ    %00000010
mPMFOUTC_OUTCTL2:   equ    %00000100
mPMFOUTC_OUTCTL3:   equ    %00001000
mPMFOUTC_OUTCTL4:   equ    %00010000
mPMFOUTC_OUTCTL5:   equ    %00100000


;*** PMFOUTB - PMF Output Control Bit Register; 0x0000020D ***
PMFOUTB:            equ    $0000020D                                ;*** PMFOUTB - PMF Output Control Bit Register; 0x0000020D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFOUTB_OUT0:       equ    0                                         ; OUT Bits
PMFOUTB_OUT1:       equ    1                                         ; OUT Bits
PMFOUTB_OUT2:       equ    2                                         ; OUT Bits
PMFOUTB_OUT3:       equ    3                                         ; OUT Bits
PMFOUTB_OUT4:       equ    4                                         ; OUT Bits
PMFOUTB_OUT5:       equ    5                                         ; OUT Bits
; bit position masks
mPMFOUTB_OUT0:      equ    %00000001
mPMFOUTB_OUT1:      equ    %00000010
mPMFOUTB_OUT2:      equ    %00000100
mPMFOUTB_OUT3:      equ    %00001000
mPMFOUTB_OUT4:      equ    %00010000
mPMFOUTB_OUT5:      equ    %00100000


;*** PMFDTMS - PMF Deadtime Sample Register; 0x0000020E ***
PMFDTMS:            equ    $0000020E                                ;*** PMFDTMS - PMF Deadtime Sample Register; 0x0000020E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDTMS_DT0:        equ    0                                         ; DT0 Bits
PMFDTMS_DT1:        equ    1                                         ; DT1 Bits
PMFDTMS_DT2:        equ    2                                         ; DT2 Bits
PMFDTMS_DT3:        equ    3                                         ; DT3 Bits
PMFDTMS_DT4:        equ    4                                         ; DT4 Bits
PMFDTMS_DT5:        equ    5                                         ; DT5 Bits
; bit position masks
mPMFDTMS_DT0:       equ    %00000001
mPMFDTMS_DT1:       equ    %00000010
mPMFDTMS_DT2:       equ    %00000100
mPMFDTMS_DT3:       equ    %00001000
mPMFDTMS_DT4:       equ    %00010000
mPMFDTMS_DT5:       equ    %00100000


;*** PMFCCTL - PMF Correction Control Register; 0x0000020F ***
PMFCCTL:            equ    $0000020F                                ;*** PMFCCTL - PMF Correction Control Register; 0x0000020F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCCTL_IPOLA:      equ    0                                         ; Current Polarity
PMFCCTL_IPOLB:      equ    1                                         ; Current Polarity
PMFCCTL_IPOLC:      equ    2                                         ; Current Polarity
PMFCCTL_ISENS0:     equ    4                                         ; Current Status Sensing Method, bit 0
PMFCCTL_ISENS1:     equ    5                                         ; Current Status Sensing Method, bit 1
; bit position masks
mPMFCCTL_IPOLA:     equ    %00000001
mPMFCCTL_IPOLB:     equ    %00000010
mPMFCCTL_IPOLC:     equ    %00000100
mPMFCCTL_ISENS0:    equ    %00010000
mPMFCCTL_ISENS1:    equ    %00100000


;*** PMFVAL0 - PMF Value 0 Register; 0x00000210 ***
PMFVAL0:            equ    $00000210                                ;*** PMFVAL0 - PMF Value 0 Register; 0x00000210 ***


;*** PMFVAL1 - PMF Value 1 Register; 0x00000212 ***
PMFVAL1:            equ    $00000212                                ;*** PMFVAL1 - PMF Value 1 Register; 0x00000212 ***


;*** PMFVAL2 - PMF Value 2 Register; 0x00000214 ***
PMFVAL2:            equ    $00000214                                ;*** PMFVAL2 - PMF Value 2 Register; 0x00000214 ***


;*** PMFVAL3 - PMF Value 3 Register; 0x00000216 ***
PMFVAL3:            equ    $00000216                                ;*** PMFVAL3 - PMF Value 3 Register; 0x00000216 ***


;*** PMFVAL4 - PMF Value 4 Register; 0x00000218 ***
PMFVAL4:            equ    $00000218                                ;*** PMFVAL4 - PMF Value 4 Register; 0x00000218 ***


;*** PMFVAL5 - PMF Value 5 Register; 0x0000021A ***
PMFVAL5:            equ    $0000021A                                ;*** PMFVAL5 - PMF Value 5 Register; 0x0000021A ***


;*** PMFENCA - PMF Enable Control A Register; 0x00000220 ***
PMFENCA:            equ    $00000220                                ;*** PMFENCA - PMF Enable Control A Register; 0x00000220 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFENCA_PWMRIEA:    equ    0                                         ; PWM Reload Interrupt Enable A
PMFENCA_LDOKA:      equ    1                                         ; Load Okay A
PMFENCA_PWMENA:     equ    7                                         ; PWM Generator A Enable
; bit position masks
mPMFENCA_PWMRIEA:   equ    %00000001
mPMFENCA_LDOKA:     equ    %00000010
mPMFENCA_PWMENA:    equ    %10000000


;*** PMFFQCA - PMF Enable Control A Register; 0x00000221 ***
PMFFQCA:            equ    $00000221                                ;*** PMFFQCA - PMF Enable Control A Register; 0x00000221 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFQCA_PWMRFA:     equ    0                                         ; PWM Reload Flag A
PMFFQCA_PRSCA:      equ    1                                         ; PRSCA
PMFFQCA_HALFA:      equ    3                                         ; Half Cycle Reload A
PMFFQCA_LDFQA:      equ    4                                         ; Load Frequency A
; bit position masks
mPMFFQCA_PWMRFA:    equ    %00000001
mPMFFQCA_PRSCA:     equ    %00000110
mPMFFQCA_HALFA:     equ    %00001000
mPMFFQCA_LDFQA:     equ    %11110000


;*** PMFCNTA - PMF counter A Register; 0x00000222 ***
PMFCNTA:            equ    $00000222                                ;*** PMFCNTA - PMF counter A Register; 0x00000222 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCNTA_PMFCNTA:    equ    0                                         ; PMF counter
; bit position masks
mPMFCNTA_PMFCNTA:   equ    %111111111111111


;*** PMFMODA - PMF modulo counter A Register; 0x00000224 ***
PMFMODA:            equ    $00000224                                ;*** PMFMODA - PMF modulo counter A Register; 0x00000224 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFMODA_PMFMODA:    equ    0                                         ; PMF modulo counter
; bit position masks
mPMFMODA_PMFMODA:   equ    %111111111111111


;*** PMFDTMA - PMF deadtime A Register; 0x00000226 ***
PMFDTMA:            equ    $00000226                                ;*** PMFDTMA - PMF deadtime A Register; 0x00000226 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDTMA_PMFDTMA:    equ    0                                         ; PMF Value 0
; bit position masks
mPMFDTMA_PMFDTMA:   equ    %111111111111


;*** PMFENCB - PMF Enable Control B Register; 0x00000228 ***
PMFENCB:            equ    $00000228                                ;*** PMFENCB - PMF Enable Control B Register; 0x00000228 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFENCB_PWMRIEB:    equ    0                                         ; PWM Reload Interrupt Enable B
PMFENCB_LDOKB:      equ    1                                         ; Load Okay B
PMFENCB_PWMENB:     equ    7                                         ; PWM Generator B Enable
; bit position masks
mPMFENCB_PWMRIEB:   equ    %00000001
mPMFENCB_LDOKB:     equ    %00000010
mPMFENCB_PWMENB:    equ    %10000000


;*** PMFFQCB - PMF Frequency Control B Register; 0x00000229 ***
PMFFQCB:            equ    $00000229                                ;*** PMFFQCB - PMF Frequency Control B Register; 0x00000229 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFQCB_PWMRFB:     equ    0                                         ; PWM Reload Flag B
PMFFQCB_PRSCB:      equ    1                                         ; Prescaler B
PMFFQCB_HALFB:      equ    3                                         ; Half Cycle Reload B
PMFFQCB_LDFQB:      equ    4                                         ; Load Frequency B
; bit position masks
mPMFFQCB_PWMRFB:    equ    %00000001
mPMFFQCB_PRSCB:     equ    %00000110
mPMFFQCB_HALFB:     equ    %00001000
mPMFFQCB_LDFQB:     equ    %11110000


;*** PMFCNTB - PMF counter B Register; 0x0000022A ***
PMFCNTB:            equ    $0000022A                                ;*** PMFCNTB - PMF counter B Register; 0x0000022A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCNTB_PMFCNTB:    equ    0                                         ; PMF counter
; bit position masks
mPMFCNTB_PMFCNTB:   equ    %111111111111111


;*** PMFMODB - PMF modulo counter B Register; 0x0000022C ***
PMFMODB:            equ    $0000022C                                ;*** PMFMODB - PMF modulo counter B Register; 0x0000022C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFMODB_PMFMODB:    equ    0                                         ; PMF modulo counter
; bit position masks
mPMFMODB_PMFMODB:   equ    %111111111111111


;*** PMFDTMB - PMF deadtime B Register; 0x0000022E ***
PMFDTMB:            equ    $0000022E                                ;*** PMFDTMB - PMF deadtime B Register; 0x0000022E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDTMB_PMFDTMB:    equ    0                                         ; PMF Value 0
; bit position masks
mPMFDTMB_PMFDTMB:   equ    %111111111111


;*** PMFENCC - PMF Enable Control C Register; 0x00000230 ***
PMFENCC:            equ    $00000230                                ;*** PMFENCC - PMF Enable Control C Register; 0x00000230 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFENCC_PWMRIEC:    equ    0                                         ; PWM Reload Interrupt Enable C
PMFENCC_LDOKC:      equ    1                                         ; Load Okay C
PMFENCC_PWMENC:     equ    7                                         ; PWM Generator C Enable
; bit position masks
mPMFENCC_PWMRIEC:   equ    %00000001
mPMFENCC_LDOKC:     equ    %00000010
mPMFENCC_PWMENC:    equ    %10000000


;*** PMFFQCC - PMF Frequency Control C Register; 0x00000231 ***
PMFFQCC:            equ    $00000231                                ;*** PMFFQCC - PMF Frequency Control C Register; 0x00000231 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFFQCC_PWMRFC:     equ    0                                         ; PWM Reload Flag C
PMFFQCC_PRSCC:      equ    1                                         ; Prescaler C
PMFFQCC_HALFC:      equ    3                                         ; Half Cycle Reload B
PMFFQCC_LDFQC:      equ    4                                         ; Load Frequency C
; bit position masks
mPMFFQCC_PWMRFC:    equ    %00000001
mPMFFQCC_PRSCC:     equ    %00000110
mPMFFQCC_HALFC:     equ    %00001000
mPMFFQCC_LDFQC:     equ    %11110000


;*** PMFCNTC - PMF counter C Register; 0x00000232 ***
PMFCNTC:            equ    $00000232                                ;*** PMFCNTC - PMF counter C Register; 0x00000232 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFCNTC_PMFCNTC:    equ    0                                         ; PMF counter
; bit position masks
mPMFCNTC_PMFCNTC:   equ    %111111111111111


;*** PMFMODC - PMF modulo counter C Register; 0x00000234 ***
PMFMODC:            equ    $00000234                                ;*** PMFMODC - PMF modulo counter C Register; 0x00000234 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFMODC_PMFMODC:    equ    0                                         ; PMF modulo counter
; bit position masks
mPMFMODC_PMFMODC:   equ    %111111111111111


;*** PMFDTMC - PMF deadtime C Register; 0x00000236 ***
PMFDTMC:            equ    $00000236                                ;*** PMFDTMC - PMF deadtime C Register; 0x00000236 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PMFDTMC_PMFDTMC:    equ    0                                         ; PMF Value 0
; bit position masks
mPMFDTMC_PMFDTMC:   equ    %111111111111


;*** PTT - Port T Data Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T Data Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T general purpose input/output data bit 0
PTT_PTT1:           equ    1                                         ; Port T general purpose input/output data bit 1
PTT_PTT2:           equ    2                                         ; Port T general purpose input/output data bit 2
PTT_PTT3:           equ    3                                         ; Port T general purpose input/output data bit 3
PTT_PTT4:           equ    4                                         ; Port T general purpose input/output data bit 4
PTT_PTT5:           equ    5                                         ; Port T general purpose input/output data bit 5
PTT_PTT6:           equ    6                                         ; Port T general purpose input/output data bit 6
PTT_PTT7:           equ    7                                         ; Port T general purpose input/output data bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T input data bit 0
PTIT_PTIT1:         equ    1                                         ; Port T input data bit 1
PTIT_PTIT2:         equ    2                                         ; Port T input data bit 2
PTIT_PTIT3:         equ    3                                         ; Port T input data bit 3
PTIT_PTIT4:         equ    4                                         ; Port T input data bit 4
PTIT_PTIT5:         equ    5                                         ; Port T input data bit 5
PTIT_PTIT6:         equ    6                                         ; Port T input data bit 6
PTIT_PTIT7:         equ    7                                         ; Port T input data bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Port T data direction bit 0
DDRT_DDRT1:         equ    1                                         ; Port T data direction bit 1
DDRT_DDRT2:         equ    2                                         ; Port T data direction bit 2
DDRT_DDRT3:         equ    3                                         ; Port T data direction bit 3
DDRT_DDRT4:         equ    4                                         ; Port T data direction bit 4
DDRT_DDRT5:         equ    5                                         ; Port T data direction bit 5
DDRT_DDRT6:         equ    6                                         ; Port T data direction bit 6
DDRT_DDRT7:         equ    7                                         ; Port T data direction bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
RDRT:               equ    $00000243                                ;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Port T reduced drive bit 0
RDRT_RDRT1:         equ    1                                         ; Port T reduced drive bit 1
RDRT_RDRT2:         equ    2                                         ; Port T reduced drive bit 2
RDRT_RDRT3:         equ    3                                         ; Port T reduced drive bit 3
RDRT_RDRT4:         equ    4                                         ; Port T reduced drive bit 4
RDRT_RDRT5:         equ    5                                         ; Port T reduced drive bit 5
RDRT_RDRT6:         equ    6                                         ; Port T reduced drive bit 6
RDRT_RDRT7:         equ    7                                         ; Port T reduced drive bit 7
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Port T pull device enable bit 0
PERT_PERT1:         equ    1                                         ; Port T pull device enable bit 1
PERT_PERT2:         equ    2                                         ; Port T pull device enable bit 2
PERT_PERT3:         equ    3                                         ; Port T pull device enable bit 3
PERT_PERT4:         equ    4                                         ; Port T pull device enable bit 4
PERT_PERT5:         equ    5                                         ; Port T pull device enable bit 5
PERT_PERT6:         equ    6                                         ; Port T pull device enable bit 6
PERT_PERT7:         equ    7                                         ; Port T pull device enable bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Port T pull device select bit 0
PPST_PPST1:         equ    1                                         ; Port T pull device select bit 1
PPST_PPST2:         equ    2                                         ; Port T pull device select bit 2
PPST_PPST3:         equ    3                                         ; Port T pull device select bit 3
PPST_PPST4:         equ    4                                         ; Port T pull device select bit 4
PPST_PPST5:         equ    5                                         ; Port T pull device select bit 5
PPST_PPST6:         equ    6                                         ; Port T pull device select bit 6
PPST_PPST7:         equ    7                                         ; Port T pull device select bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** PTS - Port S Data Register; 0x00000248 ***
PTS:                equ    $00000248                                ;*** PTS - Port S Data Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S general purpose input/output data bit 0
PTS_PTS1:           equ    1                                         ; Port S general purpose input/output data bit 1
PTS_PTS2:           equ    2                                         ; Port S general purpose input/output data bit 2
PTS_PTS3:           equ    3                                         ; Port S general purpose input/output data bit 3
PTS_PTS4:           equ    4                                         ; Port S general purpose input/output data bit 4
PTS_PTS5:           equ    5                                         ; Port S general purpose input/output data bit 5
PTS_PTS6:           equ    6                                         ; Port S general purpose input/output data bit 6
PTS_PTS7:           equ    7                                         ; Port S general purpose input/output data bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000249 ***
PTIS:               equ    $00000249                                ;*** PTIS - Port S Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S input data bit 0
PTIS_PTIS1:         equ    1                                         ; Port S input data bit 1
PTIS_PTIS2:         equ    2                                         ; Port S input data bit 2
PTIS_PTIS3:         equ    3                                         ; Port S input data bit 3
PTIS_PTIS4:         equ    4                                         ; Port S input data bit 4
PTIS_PTIS5:         equ    5                                         ; Port S input data bit 5
PTIS_PTIS6:         equ    6                                         ; Port S input data bit 6
PTIS_PTIS7:         equ    7                                         ; Port S input data bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000024A ***
DDRS:               equ    $0000024A                                ;*** DDRS - Port S Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Port S data direction bit 0
DDRS_DDRS1:         equ    1                                         ; Port S data direction bit 1
DDRS_DDRS2:         equ    2                                         ; Port S data direction bit 2
DDRS_DDRS3:         equ    3                                         ; Port S data direction bit 3
DDRS_DDRS4:         equ    4                                         ; Port S data direction bit 4
DDRS_DDRS5:         equ    5                                         ; Port S data direction bit 5
DDRS_DDRS6:         equ    6                                         ; Port S data direction bit 6
DDRS_DDRS7:         equ    7                                         ; Port S data direction bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
RDRS:               equ    $0000024B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Port S reduced drive bit 0
RDRS_RDRS1:         equ    1                                         ; Port S reduced drive bit 1
RDRS_RDRS2:         equ    2                                         ; Port S reduced drive bit 2
RDRS_RDRS3:         equ    3                                         ; Port S reduced drive bit 3
RDRS_RDRS4:         equ    4                                         ; Port S reduced drive bit 4
RDRS_RDRS5:         equ    5                                         ; Port S reduced drive bit 5
RDRS_RDRS6:         equ    6                                         ; Port S reduced drive bit 6
RDRS_RDRS7:         equ    7                                         ; Port S reduced drive bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
PERS:               equ    $0000024C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Port S pull device enable bit 0
PERS_PERS1:         equ    1                                         ; Port S pull device enable bit 1
PERS_PERS2:         equ    2                                         ; Port S pull device enable bit 2
PERS_PERS3:         equ    3                                         ; Port S pull device enable bit 3
PERS_PERS4:         equ    4                                         ; Port S pull device enable bit 4
PERS_PERS5:         equ    5                                         ; Port S pull device enable bit 5
PERS_PERS6:         equ    6                                         ; Port S pull device enable bit 6
PERS_PERS7:         equ    7                                         ; Port S pull device enable bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
PPSS:               equ    $0000024D                                ;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Port S pull device select bit 0
PPSS_PPSS1:         equ    1                                         ; Port S pull device select bit 1
PPSS_PPSS2:         equ    2                                         ; Port S pull device select bit 2
PPSS_PPSS3:         equ    3                                         ; Port S pull device select bit 3
PPSS_PPSS4:         equ    4                                         ; Port S pull device select bit 4
PPSS_PPSS5:         equ    5                                         ; Port S pull device select bit 5
PPSS_PPSS6:         equ    6                                         ; Port S pull device select bit 6
PPSS_PPSS7:         equ    7                                         ; Port S pull device select bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
WOMS:               equ    $0000024E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Port S wired-or mode bit 0
WOMS_WOMS1:         equ    1                                         ; Port S wired-or mode bit 1
WOMS_WOMS2:         equ    2                                         ; Port S wired-or mode bit 2
WOMS_WOMS3:         equ    3                                         ; Port S wired-or mode bit 3
WOMS_WOMS4:         equ    4                                         ; Port S wired-or mode bit 4
WOMS_WOMS5:         equ    5                                         ; Port S wired-or mode bit 5
WOMS_WOMS6:         equ    6                                         ; Port S wired-or mode bit 6
WOMS_WOMS7:         equ    7                                         ; Port S wired-or mode bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** PTM - Port M Data Register; 0x00000250 ***
PTM:                equ    $00000250                                ;*** PTM - Port M Data Register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM0:           equ    0                                         ; Port M general purpose input/output data bit 0
PTM_PTM1:           equ    1                                         ; Port M general purpose input/output data bit 1
PTM_PTM2:           equ    2                                         ; Port M general purpose input/output data bit 2
PTM_PTM3:           equ    3                                         ; Port M general purpose input/output data bit 3
PTM_PTM4:           equ    4                                         ; Port M general purpose input/output data bit 4
PTM_PTM5:           equ    5                                         ; Port M general purpose input/output data bit 5
PTM_PTM6:           equ    6                                         ; Port M general purpose input/output data bit 6
PTM_PTM7:           equ    7                                         ; Port M general purpose input/output data bit 7
; bit position masks
mPTM_PTM0:          equ    %00000001
mPTM_PTM1:          equ    %00000010
mPTM_PTM2:          equ    %00000100
mPTM_PTM3:          equ    %00001000
mPTM_PTM4:          equ    %00010000
mPTM_PTM5:          equ    %00100000
mPTM_PTM6:          equ    %01000000
mPTM_PTM7:          equ    %10000000


;*** PTIM - Port M Input Register; 0x00000251 ***
PTIM:               equ    $00000251                                ;*** PTIM - Port M Input Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM0:         equ    0                                         ; Port M input data bit 0
PTIM_PTIM1:         equ    1                                         ; Port M input data bit 1
PTIM_PTIM2:         equ    2                                         ; Port M input data bit 2
PTIM_PTIM3:         equ    3                                         ; Port M input data bit 3
PTIM_PTIM4:         equ    4                                         ; Port M input data bit 4
PTIM_PTIM5:         equ    5                                         ; Port M input data bit 5
PTIM_PTIM6:         equ    6                                         ; Port M input data bit 6
PTIM_PTIM7:         equ    7                                         ; Port M input data bit 7
; bit position masks
mPTIM_PTIM0:        equ    %00000001
mPTIM_PTIM1:        equ    %00000010
mPTIM_PTIM2:        equ    %00000100
mPTIM_PTIM3:        equ    %00001000
mPTIM_PTIM4:        equ    %00010000
mPTIM_PTIM5:        equ    %00100000
mPTIM_PTIM6:        equ    %01000000
mPTIM_PTIM7:        equ    %10000000


;*** DDRM - Port M Data Direction Register; 0x00000252 ***
DDRM:               equ    $00000252                                ;*** DDRM - Port M Data Direction Register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM0:         equ    0                                         ; Port M data direction bit 0
DDRM_DDRM1:         equ    1                                         ; Port M data direction bit 1
DDRM_DDRM2:         equ    2                                         ; Port M data direction bit 2
DDRM_DDRM3:         equ    3                                         ; Port M data direction bit 3
DDRM_DDRM4:         equ    4                                         ; Port M data direction bit 4
DDRM_DDRM5:         equ    5                                         ; Port M data direction bit 5
DDRM_DDRM6:         equ    6                                         ; Port M data direction bit 6
DDRM_DDRM7:         equ    7                                         ; Port M data direction bit 7
; bit position masks
mDDRM_DDRM0:        equ    %00000001
mDDRM_DDRM1:        equ    %00000010
mDDRM_DDRM2:        equ    %00000100
mDDRM_DDRM3:        equ    %00001000
mDDRM_DDRM4:        equ    %00010000
mDDRM_DDRM5:        equ    %00100000
mDDRM_DDRM6:        equ    %01000000
mDDRM_DDRM7:        equ    %10000000


;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
RDRM:               equ    $00000253                                ;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRM_RDRM0:         equ    0                                         ; Port M reduced drive bit 0
RDRM_RDRM1:         equ    1                                         ; Port M reduced drive bit 1
RDRM_RDRM2:         equ    2                                         ; Port M reduced drive bit 2
RDRM_RDRM3:         equ    3                                         ; Port M reduced drive bit 3
RDRM_RDRM4:         equ    4                                         ; Port M reduced drive bit 4
RDRM_RDRM5:         equ    5                                         ; Port M reduced drive bit 5
RDRM_RDRM6:         equ    6                                         ; Port M reduced drive bit 6
RDRM_RDRM7:         equ    7                                         ; Port M reduced drive bit 7
; bit position masks
mRDRM_RDRM0:        equ    %00000001
mRDRM_RDRM1:        equ    %00000010
mRDRM_RDRM2:        equ    %00000100
mRDRM_RDRM3:        equ    %00001000
mRDRM_RDRM4:        equ    %00010000
mRDRM_RDRM5:        equ    %00100000
mRDRM_RDRM6:        equ    %01000000
mRDRM_RDRM7:        equ    %10000000


;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
PERM:               equ    $00000254                                ;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM0:         equ    0                                         ; Port M pull device enable bit 0
PERM_PERM1:         equ    1                                         ; Port M pull device enable bit 1
PERM_PERM2:         equ    2                                         ; Port M pull device enable bit 2
PERM_PERM3:         equ    3                                         ; Port M pull device enable bit 3
PERM_PERM4:         equ    4                                         ; Port M pull device enable bit 4
PERM_PERM5:         equ    5                                         ; Port M pull device enable bit 5
PERM_PERM6:         equ    6                                         ; Port M pull device enable bit 6
PERM_PERM7:         equ    7                                         ; Port M pull device enable bit 7
; bit position masks
mPERM_PERM0:        equ    %00000001
mPERM_PERM1:        equ    %00000010
mPERM_PERM2:        equ    %00000100
mPERM_PERM3:        equ    %00001000
mPERM_PERM4:        equ    %00010000
mPERM_PERM5:        equ    %00100000
mPERM_PERM6:        equ    %01000000
mPERM_PERM7:        equ    %10000000


;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
PPSM:               equ    $00000255                                ;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM0:         equ    0                                         ; Port M pull device select bit 0
PPSM_PPSM1:         equ    1                                         ; Port M pull device select bit 1
PPSM_PPSM2:         equ    2                                         ; Port M pull device select bit 2
PPSM_PPSM3:         equ    3                                         ; Port M pull device select bit 3
PPSM_PPSM4:         equ    4                                         ; Port M pull device select bit 4
PPSM_PPSM5:         equ    5                                         ; Port M pull device select bit 5
PPSM_PPSM6:         equ    6                                         ; Port M pull device select bit 6
PPSM_PPSM7:         equ    7                                         ; Port M pull device select bit 7
; bit position masks
mPPSM_PPSM0:        equ    %00000001
mPPSM_PPSM1:        equ    %00000010
mPPSM_PPSM2:        equ    %00000100
mPPSM_PPSM3:        equ    %00001000
mPPSM_PPSM4:        equ    %00010000
mPPSM_PPSM5:        equ    %00100000
mPPSM_PPSM6:        equ    %01000000
mPPSM_PPSM7:        equ    %10000000


;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
WOMM:               equ    $00000256                                ;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMM_WOMM0:         equ    0                                         ; Port M wired-or mode bit 0
WOMM_WOMM1:         equ    1                                         ; Port M wired-or mode bit 1
WOMM_WOMM2:         equ    2                                         ; Port M wired-or mode bit 2
WOMM_WOMM3:         equ    3                                         ; Port M wired-or mode bit 3
WOMM_WOMM4:         equ    4                                         ; Port M wired-or mode bit 4
WOMM_WOMM5:         equ    5                                         ; Port M wired-or mode bit 5
WOMM_WOMM6:         equ    6                                         ; Port M wired-or mode bit 6
WOMM_WOMM7:         equ    7                                         ; Port M wired-or mode bit 7
; bit position masks
mWOMM_WOMM0:        equ    %00000001
mWOMM_WOMM1:        equ    %00000010
mWOMM_WOMM2:        equ    %00000100
mWOMM_WOMM3:        equ    %00001000
mWOMM_WOMM4:        equ    %00010000
mWOMM_WOMM5:        equ    %00100000
mWOMM_WOMM6:        equ    %01000000
mWOMM_WOMM7:        equ    %10000000


;*** PTP - Port P Data Register; 0x00000258 ***
PTP:                equ    $00000258                                ;*** PTP - Port P Data Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P general purpose input/output data bit 0
PTP_PTP1:           equ    1                                         ; Port P general purpose input/output data bit 1
PTP_PTP2:           equ    2                                         ; Port P general purpose input/output data bit 2
PTP_PTP3:           equ    3                                         ; Port P general purpose input/output data bit 3
PTP_PTP4:           equ    4                                         ; Port P general purpose input/output data bit 4
PTP_PTP5:           equ    5                                         ; Port P general purpose input/output data bit 5
PTP_PTP6:           equ    6                                         ; Port P general purpose input/output data bit 6
PTP_PTP7:           equ    7                                         ; Port P general purpose input/output data bit 7
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000
mPTP_PTP6:          equ    %01000000
mPTP_PTP7:          equ    %10000000


;*** PTIP - Port P Input Register; 0x00000259 ***
PTIP:               equ    $00000259                                ;*** PTIP - Port P Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P input data bit 0
PTIP_PTIP1:         equ    1                                         ; Port P input data bit 1
PTIP_PTIP2:         equ    2                                         ; Port P input data bit 2
PTIP_PTIP3:         equ    3                                         ; Port P input data bit 3
PTIP_PTIP4:         equ    4                                         ; Port P input data bit 4
PTIP_PTIP5:         equ    5                                         ; Port P input data bit 5
PTIP_PTIP6:         equ    6                                         ; Port P input data bit 6
PTIP_PTIP7:         equ    7                                         ; Port P input data bit 7
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000
mPTIP_PTIP6:        equ    %01000000
mPTIP_PTIP7:        equ    %10000000


;*** DDRP - Port P Data Direction Register; 0x0000025A ***
DDRP:               equ    $0000025A                                ;*** DDRP - Port P Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Port P data direction bit 0
DDRP_DDRP1:         equ    1                                         ; Port P data direction bit 1
DDRP_DDRP2:         equ    2                                         ; Port P data direction bit 2
DDRP_DDRP3:         equ    3                                         ; Port P data direction bit 3
DDRP_DDRP4:         equ    4                                         ; Port P data direction bit 4
DDRP_DDRP5:         equ    5                                         ; Port P data direction bit 5
DDRP_DDRP6:         equ    6                                         ; Port P data direction bit 6
DDRP_DDRP7:         equ    7                                         ; Port P data direction bit 7
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000
mDDRP_DDRP6:        equ    %01000000
mDDRP_DDRP7:        equ    %10000000


;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
RDRP:               equ    $0000025B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Port P reduced drive bit 0
RDRP_RDRP1:         equ    1                                         ; Port P reduced drive bit 1
RDRP_RDRP2:         equ    2                                         ; Port P reduced drive bit 2
RDRP_RDRP3:         equ    3                                         ; Port P reduced drive bit 3
RDRP_RDRP4:         equ    4                                         ; Port P reduced drive bit 4
RDRP_RDRP5:         equ    5                                         ; Port P reduced drive bit 5
RDRP_RDRP6:         equ    6                                         ; Port P reduced drive bit 6
RDRP_RDRP7:         equ    7                                         ; Port P reduced drive bit 7
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000
mRDRP_RDRP6:        equ    %01000000
mRDRP_RDRP7:        equ    %10000000


;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
PERP:               equ    $0000025C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Port P pull device enable bit 0
PERP_PERP1:         equ    1                                         ; Port P pull device enable bit 1
PERP_PERP2:         equ    2                                         ; Port P pull device enable bit 2
PERP_PERP3:         equ    3                                         ; Port P pull device enable bit 3
PERP_PERP4:         equ    4                                         ; Port P pull device enable bit 4
PERP_PERP5:         equ    5                                         ; Port P pull device enable bit 5
PERP_PERP6:         equ    6                                         ; Port P pull device enable bit 6
PERP_PERP7:         equ    7                                         ; Port P pull device enable bit 7
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000
mPERP_PERP6:        equ    %01000000
mPERP_PERP7:        equ    %10000000


;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
PPSP:               equ    $0000025D                                ;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Port P pull device select bit 0
PPSP_PPSP1:         equ    1                                         ; Port P pull device select bit 1
PPSP_PPSP2:         equ    2                                         ; Port P pull device select bit 2
PPSP_PPSP3:         equ    3                                         ; Port P pull device select bit 3
PPSP_PPSP4:         equ    4                                         ; Port P pull device select bit 4
PPSP_PPSP5:         equ    5                                         ; Port P pull device select bit 5
PPSP_PPSP6:         equ    6                                         ; Port P pull device select bit 6
PPSP_PPSP7:         equ    7                                         ; Port P pull device select bit 7
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000
mPPSP_PPSP6:        equ    %01000000
mPPSP_PPSP7:        equ    %10000000


;*** PTH - Port H Data Register; 0x00000260 ***
PTH:                equ    $00000260                                ;*** PTH - Port H Data Register; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTH_PTH0:           equ    0                                         ; Port H general purpose input/output data bit 0
PTH_PTH1:           equ    1                                         ; Port H general purpose input/output data bit 1
PTH_PTH2:           equ    2                                         ; Port H general purpose input/output data bit 2
PTH_PTH3:           equ    3                                         ; Port H general purpose input/output data bit 3
PTH_PTH4:           equ    4                                         ; Port H general purpose input/output data bit 4
PTH_PTH5:           equ    5                                         ; Port H general purpose input/output data bit 5
PTH_PTH6:           equ    6                                         ; Port H general purpose input/output data bit 6
PTH_PTH7:           equ    7                                         ; Port H general purpose input/output data bit 7
; bit position masks
mPTH_PTH0:          equ    %00000001
mPTH_PTH1:          equ    %00000010
mPTH_PTH2:          equ    %00000100
mPTH_PTH3:          equ    %00001000
mPTH_PTH4:          equ    %00010000
mPTH_PTH5:          equ    %00100000
mPTH_PTH6:          equ    %01000000
mPTH_PTH7:          equ    %10000000


;*** PTIH - Port H Input Register; 0x00000261 ***
PTIH:               equ    $00000261                                ;*** PTIH - Port H Input Register; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIH_PTIH0:         equ    0                                         ; Port H input data bit 0
PTIH_PTIH1:         equ    1                                         ; Port H input data bit 1
PTIH_PTIH2:         equ    2                                         ; Port H input data bit 2
PTIH_PTIH3:         equ    3                                         ; Port H input data bit 3
PTIH_PTIH4:         equ    4                                         ; Port H input data bit 4
PTIH_PTIH5:         equ    5                                         ; Port H input data bit 5
PTIH_PTIH6:         equ    6                                         ; Port H input data bit 6
PTIH_PTIH7:         equ    7                                         ; Port H input data bit 7
; bit position masks
mPTIH_PTIH0:        equ    %00000001
mPTIH_PTIH1:        equ    %00000010
mPTIH_PTIH2:        equ    %00000100
mPTIH_PTIH3:        equ    %00001000
mPTIH_PTIH4:        equ    %00010000
mPTIH_PTIH5:        equ    %00100000
mPTIH_PTIH6:        equ    %01000000
mPTIH_PTIH7:        equ    %10000000


;*** DDRH - Port H Data Direction Register; 0x00000262 ***
DDRH:               equ    $00000262                                ;*** DDRH - Port H Data Direction Register; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRH_DDRH0:         equ    0                                         ; Port H data direction bit 0
DDRH_DDRH1:         equ    1                                         ; Port H data direction bit 1
DDRH_DDRH2:         equ    2                                         ; Port H data direction bit 2
DDRH_DDRH3:         equ    3                                         ; Port H data direction bit 3
DDRH_DDRH4:         equ    4                                         ; Port H data direction bit 4
DDRH_DDRH5:         equ    5                                         ; Port H data direction bit 5
DDRH_DDRH6:         equ    6                                         ; Port H data direction bit 6
DDRH_DDRH7:         equ    7                                         ; Port H data direction bit 7
; bit position masks
mDDRH_DDRH0:        equ    %00000001
mDDRH_DDRH1:        equ    %00000010
mDDRH_DDRH2:        equ    %00000100
mDDRH_DDRH3:        equ    %00001000
mDDRH_DDRH4:        equ    %00010000
mDDRH_DDRH5:        equ    %00100000
mDDRH_DDRH6:        equ    %01000000
mDDRH_DDRH7:        equ    %10000000


;*** RDRH - Port H Reduced Drive Register; 0x00000263 ***
RDRH:               equ    $00000263                                ;*** RDRH - Port H Reduced Drive Register; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRH_RDRH0:         equ    0                                         ; Port H reduced drive bit 0
RDRH_RDRH1:         equ    1                                         ; Port H reduced drive bit 1
RDRH_RDRH2:         equ    2                                         ; Port H reduced drive bit 2
RDRH_RDRH3:         equ    3                                         ; Port H reduced drive bit 3
RDRH_RDRH4:         equ    4                                         ; Port H reduced drive bit 4
RDRH_RDRH5:         equ    5                                         ; Port H reduced drive bit 5
RDRH_RDRH6:         equ    6                                         ; Port H reduced drive bit 6
RDRH_RDRH7:         equ    7                                         ; Port H reduced drive bit 7
; bit position masks
mRDRH_RDRH0:        equ    %00000001
mRDRH_RDRH1:        equ    %00000010
mRDRH_RDRH2:        equ    %00000100
mRDRH_RDRH3:        equ    %00001000
mRDRH_RDRH4:        equ    %00010000
mRDRH_RDRH5:        equ    %00100000
mRDRH_RDRH6:        equ    %01000000
mRDRH_RDRH7:        equ    %10000000


;*** PERH - Port H Pull Device Enable Register; 0x00000264 ***
PERH:               equ    $00000264                                ;*** PERH - Port H Pull Device Enable Register; 0x00000264 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERH_PERH0:         equ    0                                         ; Port H pull device enable bit 0
PERH_PERH1:         equ    1                                         ; Port H pull device enable bit 1
PERH_PERH2:         equ    2                                         ; Port H pull device enable bit 2
PERH_PERH3:         equ    3                                         ; Port H pull device enable bit 3
PERH_PERH4:         equ    4                                         ; Port H pull device enable bit 4
PERH_PERH5:         equ    5                                         ; Port H pull device enable bit 5
PERH_PERH6:         equ    6                                         ; Port H pull device enable bit 6
PERH_PERH7:         equ    7                                         ; Port H pull device enable bit 7
; bit position masks
mPERH_PERH0:        equ    %00000001
mPERH_PERH1:        equ    %00000010
mPERH_PERH2:        equ    %00000100
mPERH_PERH3:        equ    %00001000
mPERH_PERH4:        equ    %00010000
mPERH_PERH5:        equ    %00100000
mPERH_PERH6:        equ    %01000000
mPERH_PERH7:        equ    %10000000


;*** PPSH - Port H Polarity Select Register; 0x00000265 ***
PPSH:               equ    $00000265                                ;*** PPSH - Port H Polarity Select Register; 0x00000265 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSH_PPSH0:         equ    0                                         ; Port H pull device select bit 0
PPSH_PPSH1:         equ    1                                         ; Port H pull device select bit 1
PPSH_PPSH2:         equ    2                                         ; Port H pull device select bit 2
PPSH_PPSH3:         equ    3                                         ; Port H pull device select bit 3
PPSH_PPSH4:         equ    4                                         ; Port H pull device select bit 4
PPSH_PPSH5:         equ    5                                         ; Port H pull device select bit 5
PPSH_PPSH6:         equ    6                                         ; Port H pull device select bit 6
PPSH_PPSH7:         equ    7                                         ; Port H pull device select bit 7
; bit position masks
mPPSH_PPSH0:        equ    %00000001
mPPSH_PPSH1:        equ    %00000010
mPPSH_PPSH2:        equ    %00000100
mPPSH_PPSH3:        equ    %00001000
mPPSH_PPSH4:        equ    %00010000
mPPSH_PPSH5:        equ    %00100000
mPPSH_PPSH6:        equ    %01000000
mPPSH_PPSH7:        equ    %10000000


;*** PTJ - Port J Data Register; 0x00000268 ***
PTJ:                equ    $00000268                                ;*** PTJ - Port J Data Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTJ_PTJ0:           equ    0                                         ; Port J general purpose input/output data bit 0
PTJ_PTJ1:           equ    1                                         ; Port J general purpose input/output data bit 1
PTJ_PTJ2:           equ    2                                         ; Port J general purpose input/output data bit 2
PTJ_PTJ3:           equ    3                                         ; Port J general purpose input/output data bit 3
PTJ_PTJ4:           equ    4                                         ; Port J general purpose input/output data bit 4
PTJ_PTJ5:           equ    5                                         ; Port J general purpose input/output data bit 5
PTJ_PTJ6:           equ    6                                         ; Port J general purpose input/output data bit 6
PTJ_PTJ7:           equ    7                                         ; Port J general purpose input/output data bit 7
; bit position masks
mPTJ_PTJ0:          equ    %00000001
mPTJ_PTJ1:          equ    %00000010
mPTJ_PTJ2:          equ    %00000100
mPTJ_PTJ3:          equ    %00001000
mPTJ_PTJ4:          equ    %00010000
mPTJ_PTJ5:          equ    %00100000
mPTJ_PTJ6:          equ    %01000000
mPTJ_PTJ7:          equ    %10000000


;*** PTIJ - Port J Input Register; 0x00000269 ***
PTIJ:               equ    $00000269                                ;*** PTIJ - Port J Input Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIJ_PTIJ0:         equ    0                                         ; Port J input data bit 0
PTIJ_PTIJ1:         equ    1                                         ; Port J input data bit 1
PTIJ_PTIJ2:         equ    2                                         ; Port J input data bit 2
PTIJ_PTIJ3:         equ    3                                         ; Port J input data bit 3
PTIJ_PTIJ4:         equ    4                                         ; Port J input data bit 4
PTIJ_PTIJ5:         equ    5                                         ; Port J input data bit 5
PTIJ_PTIJ6:         equ    6                                         ; Port J input data bit 6
PTIJ_PTIJ7:         equ    7                                         ; Port J input data bit 7
; bit position masks
mPTIJ_PTIJ0:        equ    %00000001
mPTIJ_PTIJ1:        equ    %00000010
mPTIJ_PTIJ2:        equ    %00000100
mPTIJ_PTIJ3:        equ    %00001000
mPTIJ_PTIJ4:        equ    %00010000
mPTIJ_PTIJ5:        equ    %00100000
mPTIJ_PTIJ6:        equ    %01000000
mPTIJ_PTIJ7:        equ    %10000000


;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
DDRJ:               equ    $0000026A                                ;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRJ_DDRJ0:         equ    0                                         ; Port J data direction bit 0
DDRJ_DDRJ1:         equ    1                                         ; Port J data direction bit 1
DDRJ_DDRJ2:         equ    2                                         ; Port J data direction bit 2
DDRJ_DDRJ3:         equ    3                                         ; Port J data direction bit 3
DDRJ_DDRJ4:         equ    4                                         ; Port J data direction bit 4
DDRJ_DDRJ5:         equ    5                                         ; Port J data direction bit 5
DDRJ_DDRJ6:         equ    6                                         ; Port J data direction bit 6
DDRJ_DDRJ7:         equ    7                                         ; Port J data direction bit 7
; bit position masks
mDDRJ_DDRJ0:        equ    %00000001
mDDRJ_DDRJ1:        equ    %00000010
mDDRJ_DDRJ2:        equ    %00000100
mDDRJ_DDRJ3:        equ    %00001000
mDDRJ_DDRJ4:        equ    %00010000
mDDRJ_DDRJ5:        equ    %00100000
mDDRJ_DDRJ6:        equ    %01000000
mDDRJ_DDRJ7:        equ    %10000000


;*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***
RDRJ:               equ    $0000026B                                ;*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRJ_RDRJ0:         equ    0                                         ; Port J reduced drive bit 0
RDRJ_RDRJ1:         equ    1                                         ; Port J reduced drive bit 1
RDRJ_RDRJ2:         equ    2                                         ; Port J reduced drive bit 2
RDRJ_RDRJ3:         equ    3                                         ; Port J reduced drive bit 3
RDRJ_RDRJ4:         equ    4                                         ; Port J reduced drive bit 4
RDRJ_RDRJ5:         equ    5                                         ; Port J reduced drive bit 5
RDRJ_RDRJ6:         equ    6                                         ; Port J reduced drive bit 6
RDRJ_RDRJ7:         equ    7                                         ; Port J reduced drive bit 7
; bit position masks
mRDRJ_RDRJ0:        equ    %00000001
mRDRJ_RDRJ1:        equ    %00000010
mRDRJ_RDRJ2:        equ    %00000100
mRDRJ_RDRJ3:        equ    %00001000
mRDRJ_RDRJ4:        equ    %00010000
mRDRJ_RDRJ5:        equ    %00100000
mRDRJ_RDRJ6:        equ    %01000000
mRDRJ_RDRJ7:        equ    %10000000


;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
PERJ:               equ    $0000026C                                ;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERJ_PERJ0:         equ    0                                         ; Port J pull device enable bit 0
PERJ_PERJ1:         equ    1                                         ; Port J pull device enable bit 1
PERJ_PERJ2:         equ    2                                         ; Port J pull device enable bit 2
PERJ_PERJ3:         equ    3                                         ; Port J pull device enable bit 3
PERJ_PERJ4:         equ    4                                         ; Port J pull device enable bit 4
PERJ_PERJ5:         equ    5                                         ; Port J pull device enable bit 5
PERJ_PERJ6:         equ    6                                         ; Port J pull device enable bit 6
PERJ_PERJ7:         equ    7                                         ; Port J pull device enable bit 7
; bit position masks
mPERJ_PERJ0:        equ    %00000001
mPERJ_PERJ1:        equ    %00000010
mPERJ_PERJ2:        equ    %00000100
mPERJ_PERJ3:        equ    %00001000
mPERJ_PERJ4:        equ    %00010000
mPERJ_PERJ5:        equ    %00100000
mPERJ_PERJ6:        equ    %01000000
mPERJ_PERJ7:        equ    %10000000


;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
PPSJ:               equ    $0000026D                                ;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSJ_PPSJ0:         equ    0                                         ; Port J pull device select bit 0
PPSJ_PPSJ1:         equ    1                                         ; Port J pull device select bit 1
PPSJ_PPSJ2:         equ    2                                         ; Port J pull device select bit 2
PPSJ_PPSJ3:         equ    3                                         ; Port J pull device select bit 3
PPSJ_PPSJ4:         equ    4                                         ; Port J pull device select bit 4
PPSJ_PPSJ5:         equ    5                                         ; Port J pull device select bit 5
PPSJ_PPSJ6:         equ    6                                         ; Port J pull device select bit 6
PPSJ_PPSJ7:         equ    7                                         ; Port J pull device select bit 7
; bit position masks
mPPSJ_PPSJ0:        equ    %00000001
mPPSJ_PPSJ1:        equ    %00000010
mPPSJ_PPSJ2:        equ    %00000100
mPPSJ_PPSJ3:        equ    %00001000
mPPSJ_PPSJ4:        equ    %00010000
mPPSJ_PPSJ5:        equ    %00100000
mPPSJ_PPSJ6:        equ    %01000000
mPPSJ_PPSJ7:        equ    %10000000


;*** PT01AD - Port AD Data Register; 0x00000270 ***
PT01AD:             equ    $00000270                                ;*** PT01AD - Port AD Data Register; 0x00000270 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT01AD_PT1AD0:      equ    0                                         ; Port AD data bit 0
PT01AD_PT1AD1:      equ    1                                         ; Port AD data bit 1
PT01AD_PT1AD2:      equ    2                                         ; Port AD data bit 2
PT01AD_PT1AD3:      equ    3                                         ; Port AD data bit 3
PT01AD_PT1AD4:      equ    4                                         ; Port AD data bit 4
PT01AD_PT1AD5:      equ    5                                         ; Port AD data bit 5
PT01AD_PT1AD6:      equ    6                                         ; Port AD data bit 6
PT01AD_PT1AD7:      equ    7                                         ; Port AD data bit 7
PT01AD_PT0AD8:      equ    8                                         ; Port AD data bit 8
PT01AD_PT0AD9:      equ    9                                         ; Port AD data bit 9
PT01AD_PT0AD10:     equ    10                                        ; Port AD data bit 10
PT01AD_PT0AD11:     equ    11                                        ; Port AD data bit 11
PT01AD_PT0AD12:     equ    12                                        ; Port AD data bit 12
PT01AD_PT0AD13:     equ    13                                        ; Port AD data bit 13
PT01AD_PT0AD14:     equ    14                                        ; Port AD data bit 14
PT01AD_PT0AD15:     equ    15                                        ; Port AD data bit 15
; bit position masks
mPT01AD_PT1AD0:     equ    %00000001
mPT01AD_PT1AD1:     equ    %00000010
mPT01AD_PT1AD2:     equ    %00000100
mPT01AD_PT1AD3:     equ    %00001000
mPT01AD_PT1AD4:     equ    %00010000
mPT01AD_PT1AD5:     equ    %00100000
mPT01AD_PT1AD6:     equ    %01000000
mPT01AD_PT1AD7:     equ    %10000000
mPT01AD_PT0AD8:     equ    %100000000
mPT01AD_PT0AD9:     equ    %1000000000
mPT01AD_PT0AD10:    equ    %10000000000
mPT01AD_PT0AD11:    equ    %100000000000
mPT01AD_PT0AD12:    equ    %1000000000000
mPT01AD_PT0AD13:    equ    %10000000000000
mPT01AD_PT0AD14:    equ    %100000000000000
mPT01AD_PT0AD15:    equ    %1000000000000000


;*** PT0AD - Port ADH Data Register; 0x00000270 ***
PT0AD:              equ    $00000270                                ;*** PT0AD - Port ADH Data Register; 0x00000270 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT0AD_PT0AD8:       equ    0                                         ; Port AD data bit 8
PT0AD_PT0AD9:       equ    1                                         ; Port AD data bit 9
PT0AD_PT0AD10:      equ    2                                         ; Port AD data bit 10
PT0AD_PT0AD11:      equ    3                                         ; Port AD data bit 11
PT0AD_PT0AD12:      equ    4                                         ; Port AD data bit 12
PT0AD_PT0AD13:      equ    5                                         ; Port AD data bit 13
PT0AD_PT0AD14:      equ    6                                         ; Port AD data bit 14
PT0AD_PT0AD15:      equ    7                                         ; Port AD data bit 15
; bit position masks
mPT0AD_PT0AD8:      equ    %00000001
mPT0AD_PT0AD9:      equ    %00000010
mPT0AD_PT0AD10:     equ    %00000100
mPT0AD_PT0AD11:     equ    %00001000
mPT0AD_PT0AD12:     equ    %00010000
mPT0AD_PT0AD13:     equ    %00100000
mPT0AD_PT0AD14:     equ    %01000000
mPT0AD_PT0AD15:     equ    %10000000


;*** PT1AD - Port ADL Data Register; 0x00000271 ***
PT1AD:              equ    $00000271                                ;*** PT1AD - Port ADL Data Register; 0x00000271 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT1AD_PT1AD0:       equ    0                                         ; Port AD data bit 0
PT1AD_PT1AD1:       equ    1                                         ; Port AD data bit 1
PT1AD_PT1AD2:       equ    2                                         ; Port AD data bit 2
PT1AD_PT1AD3:       equ    3                                         ; Port AD data bit 3
PT1AD_PT1AD4:       equ    4                                         ; Port AD data bit 4
PT1AD_PT1AD5:       equ    5                                         ; Port AD data bit 5
PT1AD_PT1AD6:       equ    6                                         ; Port AD data bit 6
PT1AD_PT1AD7:       equ    7                                         ; Port AD data bit 7
; bit position masks
mPT1AD_PT1AD0:      equ    %00000001
mPT1AD_PT1AD1:      equ    %00000010
mPT1AD_PT1AD2:      equ    %00000100
mPT1AD_PT1AD3:      equ    %00001000
mPT1AD_PT1AD4:      equ    %00010000
mPT1AD_PT1AD5:      equ    %00100000
mPT1AD_PT1AD6:      equ    %01000000
mPT1AD_PT1AD7:      equ    %10000000


;*** DDR01AD - Port AD Data Direction Register; 0x00000272 ***
DDR01AD:            equ    $00000272                                ;*** DDR01AD - Port AD Data Direction Register; 0x00000272 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR01AD_DDR1AD0:    equ    0                                         ; Port AD data direction bit 0
DDR01AD_DDR1AD1:    equ    1                                         ; Port AD data direction bit 1
DDR01AD_DDR1AD2:    equ    2                                         ; Port AD data direction bit 2
DDR01AD_DDR1AD3:    equ    3                                         ; Port AD data direction bit 3
DDR01AD_DDR1AD4:    equ    4                                         ; Port AD data direction bit 4
DDR01AD_DDR1AD5:    equ    5                                         ; Port AD data direction bit 5
DDR01AD_DDR1AD6:    equ    6                                         ; Port AD data direction bit 6
DDR01AD_DDR1AD7:    equ    7                                         ; Port AD data direction bit 7
DDR01AD_DDR0AD8:    equ    8                                         ; Port AD data direction bit 8
DDR01AD_DDR0AD9:    equ    9                                         ; Port AD data direction bit 9
DDR01AD_DDR0AD10:   equ    10                                        ; Port AD data direction bit 10
DDR01AD_DDR0AD11:   equ    11                                        ; Port AD data direction bit 11
DDR01AD_DDR0AD12:   equ    12                                        ; Port AD data direction bit 12
DDR01AD_DDR0AD13:   equ    13                                        ; Port AD data direction bit 13
DDR01AD_DDR0AD14:   equ    14                                        ; Port AD data direction bit 14
DDR01AD_DDR0AD15:   equ    15                                        ; Port AD data direction bit 15
; bit position masks
mDDR01AD_DDR1AD0:   equ    %00000001
mDDR01AD_DDR1AD1:   equ    %00000010
mDDR01AD_DDR1AD2:   equ    %00000100
mDDR01AD_DDR1AD3:   equ    %00001000
mDDR01AD_DDR1AD4:   equ    %00010000
mDDR01AD_DDR1AD5:   equ    %00100000
mDDR01AD_DDR1AD6:   equ    %01000000
mDDR01AD_DDR1AD7:   equ    %10000000
mDDR01AD_DDR0AD8:   equ    %100000000
mDDR01AD_DDR0AD9:   equ    %1000000000
mDDR01AD_DDR0AD10:  equ    %10000000000
mDDR01AD_DDR0AD11:  equ    %100000000000
mDDR01AD_DDR0AD12:  equ    %1000000000000
mDDR01AD_DDR0AD13:  equ    %10000000000000
mDDR01AD_DDR0AD14:  equ    %100000000000000
mDDR01AD_DDR0AD15:  equ    %1000000000000000


;*** DDR0AD - Port ADH Data Direction Register; 0x00000272 ***
DDR0AD:             equ    $00000272                                ;*** DDR0AD - Port ADH Data Direction Register; 0x00000272 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR0AD_DDR0AD8:     equ    0                                         ; Port AD data direction bit 8
DDR0AD_DDR0AD9:     equ    1                                         ; Port AD data direction bit 9
DDR0AD_DDR0AD10:    equ    2                                         ; Port AD data direction bit 10
DDR0AD_DDR0AD11:    equ    3                                         ; Port AD data direction bit 11
DDR0AD_DDR0AD12:    equ    4                                         ; Port AD data direction bit 12
DDR0AD_DDR0AD13:    equ    5                                         ; Port AD data direction bit 13
DDR0AD_DDR0AD14:    equ    6                                         ; Port AD data direction bit 14
DDR0AD_DDR0AD15:    equ    7                                         ; Port AD data direction bit 15
; bit position masks
mDDR0AD_DDR0AD8:    equ    %00000001
mDDR0AD_DDR0AD9:    equ    %00000010
mDDR0AD_DDR0AD10:   equ    %00000100
mDDR0AD_DDR0AD11:   equ    %00001000
mDDR0AD_DDR0AD12:   equ    %00010000
mDDR0AD_DDR0AD13:   equ    %00100000
mDDR0AD_DDR0AD14:   equ    %01000000
mDDR0AD_DDR0AD15:   equ    %10000000


;*** DDR1AD - Port ADL Data Direction Register; 0x00000273 ***
DDR1AD:             equ    $00000273                                ;*** DDR1AD - Port ADL Data Direction Register; 0x00000273 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR1AD_DDR1AD0:     equ    0                                         ; Port AD data direction bit 0
DDR1AD_DDR1AD1:     equ    1                                         ; Port AD data direction bit 1
DDR1AD_DDR1AD2:     equ    2                                         ; Port AD data direction bit 2
DDR1AD_DDR1AD3:     equ    3                                         ; Port AD data direction bit 3
DDR1AD_DDR1AD4:     equ    4                                         ; Port AD data direction bit 4
DDR1AD_DDR1AD5:     equ    5                                         ; Port AD data direction bit 5
DDR1AD_DDR1AD6:     equ    6                                         ; Port AD data direction bit 6
DDR1AD_DDR1AD7:     equ    7                                         ; Port AD data direction bit 7
; bit position masks
mDDR1AD_DDR1AD0:    equ    %00000001
mDDR1AD_DDR1AD1:    equ    %00000010
mDDR1AD_DDR1AD2:    equ    %00000100
mDDR1AD_DDR1AD3:    equ    %00001000
mDDR1AD_DDR1AD4:    equ    %00010000
mDDR1AD_DDR1AD5:    equ    %00100000
mDDR1AD_DDR1AD6:    equ    %01000000
mDDR1AD_DDR1AD7:    equ    %10000000


;*** RDR01AD - Port AD Reduced Drive Register; 0x00000274 ***
RDR01AD:            equ    $00000274                                ;*** RDR01AD - Port AD Reduced Drive Register; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDR01AD_RDR1AD0:    equ    0                                         ; Port AD reduced drive bit 0
RDR01AD_RDR1AD1:    equ    1                                         ; Port AD reduced drive bit 1
RDR01AD_RDR1AD2:    equ    2                                         ; Port AD reduced drive bit 2
RDR01AD_RDR1AD3:    equ    3                                         ; Port AD reduced drive bit 3
RDR01AD_RDR1AD4:    equ    4                                         ; Port AD reduced drive bit 4
RDR01AD_RDR1AD5:    equ    5                                         ; Port AD reduced drive bit 5
RDR01AD_RDR1AD6:    equ    6                                         ; Port AD reduced drive bit 6
RDR01AD_RDR1AD7:    equ    7                                         ; Port AD reduced drive bit 7
RDR01AD_RDR0AD8:    equ    8                                         ; Port AD reduced drive bit 8
RDR01AD_RDR0AD9:    equ    9                                         ; Port AD reduced drive bit 9
RDR01AD_RDR0AD10:   equ    10                                        ; Port AD reduced drive bit 10
RDR01AD_RDR0AD11:   equ    11                                        ; Port AD reduced drive bit 11
RDR01AD_RDR0AD12:   equ    12                                        ; Port AD reduced drive bit 12
RDR01AD_RDR0AD13:   equ    13                                        ; Port AD reduced drive bit 13
RDR01AD_RDR0AD14:   equ    14                                        ; Port AD reduced drive bit 14
RDR01AD_RDR0AD15:   equ    15                                        ; Port AD reduced drive bit 15
; bit position masks
mRDR01AD_RDR1AD0:   equ    %00000001
mRDR01AD_RDR1AD1:   equ    %00000010
mRDR01AD_RDR1AD2:   equ    %00000100
mRDR01AD_RDR1AD3:   equ    %00001000
mRDR01AD_RDR1AD4:   equ    %00010000
mRDR01AD_RDR1AD5:   equ    %00100000
mRDR01AD_RDR1AD6:   equ    %01000000
mRDR01AD_RDR1AD7:   equ    %10000000
mRDR01AD_RDR0AD8:   equ    %100000000
mRDR01AD_RDR0AD9:   equ    %1000000000
mRDR01AD_RDR0AD10:  equ    %10000000000
mRDR01AD_RDR0AD11:  equ    %100000000000
mRDR01AD_RDR0AD12:  equ    %1000000000000
mRDR01AD_RDR0AD13:  equ    %10000000000000
mRDR01AD_RDR0AD14:  equ    %100000000000000
mRDR01AD_RDR0AD15:  equ    %1000000000000000


;*** RDR0AD - Port ADH Reduced Drive Register; 0x00000274 ***
RDR0AD:             equ    $00000274                                ;*** RDR0AD - Port ADH Reduced Drive Register; 0x00000274 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDR0AD_RDR0AD8:     equ    0                                         ; Port ADH reduced drive bit 8
RDR0AD_RDR0AD9:     equ    1                                         ; Port ADH reduced drive bit 9
RDR0AD_RDR0AD10:    equ    2                                         ; Port ADH reduced drive bit 10
RDR0AD_RDR0AD11:    equ    3                                         ; Port ADH reduced drive bit 11
RDR0AD_RDR0AD12:    equ    4                                         ; Port ADH reduced drive bit 12
RDR0AD_RDR0AD13:    equ    5                                         ; Port ADH reduced drive bit 13
RDR0AD_RDR0AD14:    equ    6                                         ; Port ADH reduced drive bit 14
RDR0AD_RDR0AD15:    equ    7                                         ; Port ADH reduced drive bit 15
; bit position masks
mRDR0AD_RDR0AD8:    equ    %00000001
mRDR0AD_RDR0AD9:    equ    %00000010
mRDR0AD_RDR0AD10:   equ    %00000100
mRDR0AD_RDR0AD11:   equ    %00001000
mRDR0AD_RDR0AD12:   equ    %00010000
mRDR0AD_RDR0AD13:   equ    %00100000
mRDR0AD_RDR0AD14:   equ    %01000000
mRDR0AD_RDR0AD15:   equ    %10000000


;*** RDR1AD - Port ADL Reduced Drive Register; 0x00000275 ***
RDR1AD:             equ    $00000275                                ;*** RDR1AD - Port ADL Reduced Drive Register; 0x00000275 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDR1AD_RDR1AD0:     equ    0                                         ; Port ADL reduced drive bit 0
RDR1AD_RDR1AD1:     equ    1                                         ; Port ADL reduced drive bit 1
RDR1AD_RDR1AD2:     equ    2                                         ; Port ADL reduced drive bit 2
RDR1AD_RDR1AD3:     equ    3                                         ; Port ADL reduced drive bit 3
RDR1AD_RDR1AD4:     equ    4                                         ; Port ADL reduced drive bit 4
RDR1AD_RDR1AD5:     equ    5                                         ; Port ADL reduced drive bit 5
RDR1AD_RDR1AD6:     equ    6                                         ; Port ADL reduced drive bit 6
RDR1AD_RDR1AD7:     equ    7                                         ; Port ADL reduced drive bit 7
; bit position masks
mRDR1AD_RDR1AD0:    equ    %00000001
mRDR1AD_RDR1AD1:    equ    %00000010
mRDR1AD_RDR1AD2:    equ    %00000100
mRDR1AD_RDR1AD3:    equ    %00001000
mRDR1AD_RDR1AD4:    equ    %00010000
mRDR1AD_RDR1AD5:    equ    %00100000
mRDR1AD_RDR1AD6:    equ    %01000000
mRDR1AD_RDR1AD7:    equ    %10000000


;*** PER01AD - Port AD Pull Up Enable Register; 0x00000276 ***
PER01AD:            equ    $00000276                                ;*** PER01AD - Port AD Pull Up Enable Register; 0x00000276 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER01AD_PER1AD0:    equ    0                                         ; Port AD pull up enable bit 0
PER01AD_PER1AD1:    equ    1                                         ; Port AD pull up enable bit 1
PER01AD_PER1AD2:    equ    2                                         ; Port AD pull up enable bit 2
PER01AD_PER1AD3:    equ    3                                         ; Port AD pull up enable bit 3
PER01AD_PER1AD4:    equ    4                                         ; Port AD pull up enable bit 4
PER01AD_PER1AD5:    equ    5                                         ; Port AD pull up enable bit 5
PER01AD_PER1AD6:    equ    6                                         ; Port AD pull up enable bit 6
PER01AD_PER1AD7:    equ    7                                         ; Port AD pull up enable bit 7
PER01AD_PER0AD8:    equ    8                                         ; Port AD pull up enable bit 8
PER01AD_PER0AD9:    equ    9                                         ; Port AD pull up enable bit 9
PER01AD_PER0AD10:   equ    10                                        ; Port AD pull up enable bit 10
PER01AD_PER0AD11:   equ    11                                        ; Port AD pull up enable bit 11
PER01AD_PER0AD12:   equ    12                                        ; Port AD pull up enable bit 12
PER01AD_PER0AD13:   equ    13                                        ; Port AD pull up enable bit 13
PER01AD_PER0AD14:   equ    14                                        ; Port AD pull up enable bit 14
PER01AD_PER0AD15:   equ    15                                        ; Port AD pull up enable bit 15
; bit position masks
mPER01AD_PER1AD0:   equ    %00000001
mPER01AD_PER1AD1:   equ    %00000010
mPER01AD_PER1AD2:   equ    %00000100
mPER01AD_PER1AD3:   equ    %00001000
mPER01AD_PER1AD4:   equ    %00010000
mPER01AD_PER1AD5:   equ    %00100000
mPER01AD_PER1AD6:   equ    %01000000
mPER01AD_PER1AD7:   equ    %10000000
mPER01AD_PER0AD8:   equ    %100000000
mPER01AD_PER0AD9:   equ    %1000000000
mPER01AD_PER0AD10:  equ    %10000000000
mPER01AD_PER0AD11:  equ    %100000000000
mPER01AD_PER0AD12:  equ    %1000000000000
mPER01AD_PER0AD13:  equ    %10000000000000
mPER01AD_PER0AD14:  equ    %100000000000000
mPER01AD_PER0AD15:  equ    %1000000000000000


;*** PER0AD - Port ADH Pull Up Enable Register; 0x00000276 ***
PER0AD:             equ    $00000276                                ;*** PER0AD - Port ADH Pull Up Enable Register; 0x00000276 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER0AD_PER0AD8:     equ    0                                         ; Port ADH pull up enable bit 8
PER0AD_PER0AD9:     equ    1                                         ; Port ADH pull up enable bit 9
PER0AD_PER0AD10:    equ    2                                         ; Port ADH pull up enable bit 10
PER0AD_PER0AD11:    equ    3                                         ; Port ADH pull up enable bit 11
PER0AD_PER0AD12:    equ    4                                         ; Port ADH pull up enable bit 12
PER0AD_PER0AD13:    equ    5                                         ; Port ADH pull up enable bit 13
PER0AD_PER0AD14:    equ    6                                         ; Port ADH pull up enable bit 14
PER0AD_PER0AD15:    equ    7                                         ; Port ADH pull up enable bit 15
; bit position masks
mPER0AD_PER0AD8:    equ    %00000001
mPER0AD_PER0AD9:    equ    %00000010
mPER0AD_PER0AD10:   equ    %00000100
mPER0AD_PER0AD11:   equ    %00001000
mPER0AD_PER0AD12:   equ    %00010000
mPER0AD_PER0AD13:   equ    %00100000
mPER0AD_PER0AD14:   equ    %01000000
mPER0AD_PER0AD15:   equ    %10000000


;*** PER1AD - Port ADL Pull Up Enable Register; 0x00000277 ***
PER1AD:             equ    $00000277                                ;*** PER1AD - Port ADL Pull Up Enable Register; 0x00000277 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER1AD_PER1AD0:     equ    0                                         ; Port ADL pull up enable bit 0
PER1AD_PER1AD1:     equ    1                                         ; Port ADL pull up enable bit 1
PER1AD_PER1AD2:     equ    2                                         ; Port ADL pull up enable bit 2
PER1AD_PER1AD3:     equ    3                                         ; Port ADL pull up enable bit 3
PER1AD_PER1AD4:     equ    4                                         ; Port ADL pull up enable bit 4
PER1AD_PER1AD5:     equ    5                                         ; Port ADL pull up enable bit 5
PER1AD_PER1AD6:     equ    6                                         ; Port ADL pull up enable bit 6
PER1AD_PER1AD7:     equ    7                                         ; Port ADL pull up enable bit 7
; bit position masks
mPER1AD_PER1AD0:    equ    %00000001
mPER1AD_PER1AD1:    equ    %00000010
mPER1AD_PER1AD2:    equ    %00000100
mPER1AD_PER1AD3:    equ    %00001000
mPER1AD_PER1AD4:    equ    %00010000
mPER1AD_PER1AD5:    equ    %00100000
mPER1AD_PER1AD6:    equ    %01000000
mPER1AD_PER1AD7:    equ    %10000000


;*** VREGHTCL - HT Control Register; 0x000002F0 ***
VREGHTCL:           equ    $000002F0                                ;*** VREGHTCL - HT Control Register; 0x000002F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGHTCL_HTIF:      equ    0                                         ; High Temperature Interrupt Flag
VREGHTCL_HTIE:      equ    1                                         ; High Temperature Interrupt Enable Bit
VREGHTCL_HTDS:      equ    2                                         ; High Temperature Detect Status Bi
VREGHTCL_HTEN:      equ    3                                         ; High Temperature Enable Bit
VREGHTCL_VAE:       equ    4                                         ; Voltage Access Enable Bit
VREGHTCL_VSEL:      equ    5                                         ; Voltage Access Select Bit
; bit position masks
mVREGHTCL_HTIF:     equ    %00000001
mVREGHTCL_HTIE:     equ    %00000010
mVREGHTCL_HTDS:     equ    %00000100
mVREGHTCL_HTEN:     equ    %00001000
mVREGHTCL_VAE:      equ    %00010000
mVREGHTCL_VSEL:     equ    %00100000


;*** VREGCTRL - Control Register; 0x000002F1 ***
VREGCTRL:           equ    $000002F1                                ;*** VREGCTRL - Control Register; 0x000002F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGCTRL_LVIF:      equ    0                                         ; Low-Voltage Interrupt Flag
VREGCTRL_LVIE:      equ    1                                         ; Low-Voltage Interrupt Enable Bit
VREGCTRL_LVDS:      equ    2                                         ; Low-Voltage Detect Status Bit
; bit position masks
mVREGCTRL_LVIF:     equ    %00000001
mVREGCTRL_LVIE:     equ    %00000010
mVREGCTRL_LVDS:     equ    %00000100


;*** VREGAPICL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
VREGAPICL:          equ    $000002F2                                ;*** VREGAPICL - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPICL_APIF:     equ    0                                         ; Autonomous Periodical Interrupt Flag
VREGAPICL_APIE:     equ    1                                         ; Autonomous Periodical Interrupt Enable Bit
VREGAPICL_APIFE:    equ    2                                         ; Autonomous Periodical Interrupt Feature Enable Bit
VREGAPICL_APIEA:    equ    3                                         ; Autonomous Periodical Interrupt External Access Enable Bit
VREGAPICL_APIES:    equ    4                                         ; Autonomous Periodical Interrupt External Select Bit
VREGAPICL_APICLK:   equ    7                                         ; Autonomous Periodical Interrupt Clock Select Bit
; bit position masks
mVREGAPICL_APIF:    equ    %00000001
mVREGAPICL_APIE:    equ    %00000010
mVREGAPICL_APIFE:   equ    %00000100
mVREGAPICL_APIEA:   equ    %00001000
mVREGAPICL_APIES:   equ    %00010000
mVREGAPICL_APICLK:  equ    %10000000


;*** VREGAPITR - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***
VREGAPITR:          equ    $000002F3                                ;*** VREGAPITR - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPITR_APITR0:   equ    2                                         ; Autonomous Periodical Interrupt Period Trimming Bit 0
VREGAPITR_APITR1:   equ    3                                         ; Autonomous Periodical Interrupt Period Trimming Bit 1
VREGAPITR_APITR2:   equ    4                                         ; Autonomous Periodical Interrupt Period Trimming Bit 2
VREGAPITR_APITR3:   equ    5                                         ; Autonomous Periodical Interrupt Period Trimming Bit 3
VREGAPITR_APITR4:   equ    6                                         ; Autonomous Periodical Interrupt Period Trimming Bit 4
VREGAPITR_APITR5:   equ    7                                         ; Autonomous Periodical Interrupt Period Trimming Bit 5
; bit position masks
mVREGAPITR_APITR0:  equ    %00000100
mVREGAPITR_APITR1:  equ    %00001000
mVREGAPITR_APITR2:  equ    %00010000
mVREGAPITR_APITR3:  equ    %00100000
mVREGAPITR_APITR4:  equ    %01000000
mVREGAPITR_APITR5:  equ    %10000000


;*** VREGAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
VREGAPIR:           equ    $000002F4                                ;*** VREGAPIR - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIR_APIR0:     equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
VREGAPIR_APIR1:     equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
VREGAPIR_APIR2:     equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
VREGAPIR_APIR3:     equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
VREGAPIR_APIR4:     equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
VREGAPIR_APIR5:     equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
VREGAPIR_APIR6:     equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
VREGAPIR_APIR7:     equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
VREGAPIR_APIR8:     equ    8                                         ; Autonomous Periodical Interrupt Rate Bit 8
VREGAPIR_APIR9:     equ    9                                         ; Autonomous Periodical Interrupt Rate Bit 9
VREGAPIR_APIR10:    equ    10                                        ; Autonomous Periodical Interrupt Rate Bit 10
VREGAPIR_APIR11:    equ    11                                        ; Autonomous Periodical Interrupt Rate Bit 11
VREGAPIR_APIR12:    equ    12                                        ; Autonomous Periodical Interrupt Rate Bit 12
VREGAPIR_APIR13:    equ    13                                        ; Autonomous Periodical Interrupt Rate Bit 13
VREGAPIR_APIR14:    equ    14                                        ; Autonomous Periodical Interrupt Rate Bit 14
VREGAPIR_APIR15:    equ    15                                        ; Autonomous Periodical Interrupt Rate Bit 15
; bit position masks
mVREGAPIR_APIR0:    equ    %00000001
mVREGAPIR_APIR1:    equ    %00000010
mVREGAPIR_APIR2:    equ    %00000100
mVREGAPIR_APIR3:    equ    %00001000
mVREGAPIR_APIR4:    equ    %00010000
mVREGAPIR_APIR5:    equ    %00100000
mVREGAPIR_APIR6:    equ    %01000000
mVREGAPIR_APIR7:    equ    %10000000
mVREGAPIR_APIR8:    equ    %100000000
mVREGAPIR_APIR9:    equ    %1000000000
mVREGAPIR_APIR10:   equ    %10000000000
mVREGAPIR_APIR11:   equ    %100000000000
mVREGAPIR_APIR12:   equ    %1000000000000
mVREGAPIR_APIR13:   equ    %10000000000000
mVREGAPIR_APIR14:   equ    %100000000000000
mVREGAPIR_APIR15:   equ    %1000000000000000


;*** VREGAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
VREGAPIRH:          equ    $000002F4                                ;*** VREGAPIRH - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIRH_APIR8:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 8
VREGAPIRH_APIR9:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 9
VREGAPIRH_APIR10:   equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 10
VREGAPIRH_APIR11:   equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 11
VREGAPIRH_APIR12:   equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 12
VREGAPIRH_APIR13:   equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 13
VREGAPIRH_APIR14:   equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 14
VREGAPIRH_APIR15:   equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 15
; bit position masks
mVREGAPIRH_APIR8:   equ    %00000001
mVREGAPIRH_APIR9:   equ    %00000010
mVREGAPIRH_APIR10:  equ    %00000100
mVREGAPIRH_APIR11:  equ    %00001000
mVREGAPIRH_APIR12:  equ    %00010000
mVREGAPIRH_APIR13:  equ    %00100000
mVREGAPIRH_APIR14:  equ    %01000000
mVREGAPIRH_APIR15:  equ    %10000000


;*** VREGAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
VREGAPIRL:          equ    $000002F5                                ;*** VREGAPIRL - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIRL_APIR0:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
VREGAPIRL_APIR1:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
VREGAPIRL_APIR2:    equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
VREGAPIRL_APIR3:    equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
VREGAPIRL_APIR4:    equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
VREGAPIRL_APIR5:    equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
VREGAPIRL_APIR6:    equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
VREGAPIRL_APIR7:    equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
; bit position masks
mVREGAPIRL_APIR0:   equ    %00000001
mVREGAPIRL_APIR1:   equ    %00000010
mVREGAPIRL_APIR2:   equ    %00000100
mVREGAPIRL_APIR3:   equ    %00001000
mVREGAPIRL_APIR4:   equ    %00010000
mVREGAPIRL_APIR5:   equ    %00100000
mVREGAPIRL_APIR6:   equ    %01000000
mVREGAPIRL_APIR7:   equ    %10000000


;*** VREGHTTR - HTTrimming Register; 0x000002F7 ***
VREGHTTR:           equ    $000002F7                                ;*** VREGHTTR - HTTrimming Register; 0x000002F7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGHTTR_HTTR:      equ    0                                         ; High Temperature Trimming Bits
VREGHTTR_HTOEN:     equ    7                                         ; High Temperature Offeset Enable Bit
; bit position masks
mVREGHTTR_HTTR:     equ    %00001111
mVREGHTTR_HTOEN:    equ    %10000000


;*** CGMSYNR - Debug Control Register 1; 0x00000300 ***
CGMSYNR:            equ    $00000300                                ;*** CGMSYNR - Debug Control Register 1; 0x00000300 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CGMSYNR_SYNDIV:     equ    0                                         ; Multiplication factor of the IPLL
CGMSYNR_VCOFRQ:     equ    6                                         ; VCO frequency range
; bit position masks
mCGMSYNR_SYNDIV:    equ    %00111111
mCGMSYNR_VCOFRQ:    equ    %11000000


;*** CGMREFDV - CGMIPLL Reference Divider Register; 0x00000301 ***
CGMREFDV:           equ    $00000301                                ;*** CGMREFDV - CGMIPLL Reference Divider Register; 0x00000301 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CGMREFDV_REFDIV:    equ    0                                         ; Finer granularity for the IPLL multiplier steps
CGMREFDV_REFFRQ:    equ    6                                         ; REF frequency range
; bit position masks
mCGMREFDV_REFDIV:   equ    %00111111
mCGMREFDV_REFFRQ:   equ    %11000000


;*** CGMFLG - CGMIPLL Flags Register; 0x00000303 ***
CGMFLG:             equ    $00000303                                ;*** CGMFLG - CGMIPLL Flags Register; 0x00000303 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CGMFLG_UNLOCKF:     equ    0                                         ; IPLL Unlock Flag
CGMFLG_LOCK:        equ    3                                         ; IPLL Lock Status Bit
CGMFLG_LOCKIF:      equ    4                                         ; IPLL Lock Interrupt Flag
CGMFLG_LOCKIE:      equ    7                                         ; Lock Interrupt Enable Bit
; bit position masks
mCGMFLG_UNLOCKF:    equ    %00000001
mCGMFLG_LOCK:       equ    %00001000
mCGMFLG_LOCKIF:     equ    %00010000
mCGMFLG_LOCKIE:     equ    %10000000


;*** CGMCTL - CGMIPLL Control Register; 0x00000304 ***
CGMCTL:             equ    $00000304                                ;*** CGMCTL - CGMIPLL Control Register; 0x00000304 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CGMCTL_PLLON:       equ    0                                         ; Phase Lock Loop On Bit
CGMCTL_FM0:         equ    1                                         ; IPLL Frequency Modulation Enable Bit
CGMCTL_FM1:         equ    2                                         ; IPLL Frequency Modulation Enable Bit
CGMCTL_DIV2:        equ    3                                         ; VCOCLK divide by 2 Bit
; bit position masks
mCGMCTL_PLLON:      equ    %00000001
mCGMCTL_FM0:        equ    %00000010
mCGMCTL_FM1:        equ    %00000100
mCGMCTL_DIV2:       equ    %00001000


;*** PITCFLMT - PIT Control and Force Load Micro Timer Register; 0x00000340 ***
PITCFLMT:           equ    $00000340                                ;*** PITCFLMT - PIT Control and Force Load Micro Timer Register; 0x00000340 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITCFLMT_PFLMT0:    equ    0                                         ; PIT Force Load Bits for Micro Timer 0
PITCFLMT_PFLMT1:    equ    1                                         ; PIT Force Load Bits for Micro Timer 1
PITCFLMT_PITFRZ:    equ    5                                         ; PIT Counter Freeze while in Freeze Mode Bit
PITCFLMT_PITSWAI:   equ    6                                         ; PIT Stop in Wait Mode Bit
PITCFLMT_PITE:      equ    7                                         ; PIT Module Enable Bit
; bit position masks
mPITCFLMT_PFLMT0:   equ    %00000001
mPITCFLMT_PFLMT1:   equ    %00000010
mPITCFLMT_PITFRZ:   equ    %00100000
mPITCFLMT_PITSWAI:  equ    %01000000
mPITCFLMT_PITE:     equ    %10000000


;*** PITFLT - PIT Force Load Timer Register; 0x00000341 ***
PITFLT:             equ    $00000341                                ;*** PITFLT - PIT Force Load Timer Register; 0x00000341 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITFLT_PFLT0:       equ    0                                         ; PIT Force Load Bits for Timer 0
PITFLT_PFLT1:       equ    1                                         ; PIT Force Load Bits for Timer 1
PITFLT_PFLT2:       equ    2                                         ; PIT Force Load Bits for Timer 2
PITFLT_PFLT3:       equ    3                                         ; PIT Force Load Bits for Timer 3
PITFLT_PFLT4:       equ    4                                         ; PIT Force Load Bits for Timer 4
PITFLT_PFLT5:       equ    5                                         ; PIT Force Load Bits for Timer 5
PITFLT_PFLT6:       equ    6                                         ; PIT Force Load Bits for Timer 6
PITFLT_PFLT7:       equ    7                                         ; PIT Force Load Bits for Timer 7
; bit position masks
mPITFLT_PFLT0:      equ    %00000001
mPITFLT_PFLT1:      equ    %00000010
mPITFLT_PFLT2:      equ    %00000100
mPITFLT_PFLT3:      equ    %00001000
mPITFLT_PFLT4:      equ    %00010000
mPITFLT_PFLT5:      equ    %00100000
mPITFLT_PFLT6:      equ    %01000000
mPITFLT_PFLT7:      equ    %10000000


;*** PITCE - PIT Channel Enable Register; 0x00000342 ***
PITCE:              equ    $00000342                                ;*** PITCE - PIT Channel Enable Register; 0x00000342 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITCE_PCE0:         equ    0                                         ; PIT Enable Bits for Timer Channel 0
PITCE_PCE1:         equ    1                                         ; PIT Enable Bits for Timer Channel 1
PITCE_PCE2:         equ    2                                         ; PIT Enable Bits for Timer Channel 2
PITCE_PCE3:         equ    3                                         ; PIT Enable Bits for Timer Channel 3
PITCE_PCE4:         equ    4                                         ; PIT Enable Bits for Timer Channel 4
PITCE_PCE5:         equ    5                                         ; PIT Enable Bits for Timer Channel 5
PITCE_PCE6:         equ    6                                         ; PIT Enable Bits for Timer Channel 6
PITCE_PCE7:         equ    7                                         ; PIT Enable Bits for Timer Channel 7
; bit position masks
mPITCE_PCE0:        equ    %00000001
mPITCE_PCE1:        equ    %00000010
mPITCE_PCE2:        equ    %00000100
mPITCE_PCE3:        equ    %00001000
mPITCE_PCE4:        equ    %00010000
mPITCE_PCE5:        equ    %00100000
mPITCE_PCE6:        equ    %01000000
mPITCE_PCE7:        equ    %10000000


;*** PITMUX - PIT Multiplex Register; 0x00000343 ***
PITMUX:             equ    $00000343                                ;*** PITMUX - PIT Multiplex Register; 0x00000343 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMUX_PMUX0:       equ    0                                         ; PIT Multiplex Bits for Timer Channel 0
PITMUX_PMUX1:       equ    1                                         ; PIT Multiplex Bits for Timer Channel 1
PITMUX_PMUX2:       equ    2                                         ; PIT Multiplex Bits for Timer Channel 2
PITMUX_PMUX3:       equ    3                                         ; PIT Multiplex Bits for Timer Channel 3
PITMUX_PMUX4:       equ    4                                         ; PIT Multiplex Bits for Timer Channel 4
PITMUX_PMUX5:       equ    5                                         ; PIT Multiplex Bits for Timer Channel 5
PITMUX_PMUX6:       equ    6                                         ; PIT Multiplex Bits for Timer Channel 6
PITMUX_PMUX7:       equ    7                                         ; PIT Multiplex Bits for Timer Channel 7
; bit position masks
mPITMUX_PMUX0:      equ    %00000001
mPITMUX_PMUX1:      equ    %00000010
mPITMUX_PMUX2:      equ    %00000100
mPITMUX_PMUX3:      equ    %00001000
mPITMUX_PMUX4:      equ    %00010000
mPITMUX_PMUX5:      equ    %00100000
mPITMUX_PMUX6:      equ    %01000000
mPITMUX_PMUX7:      equ    %10000000


;*** PITINTE - PIT Interrupt Enable Register; 0x00000344 ***
PITINTE:            equ    $00000344                                ;*** PITINTE - PIT Interrupt Enable Register; 0x00000344 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITINTE_PINTE0:     equ    0                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 0
PITINTE_PINTE1:     equ    1                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 1
PITINTE_PINTE2:     equ    2                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 2
PITINTE_PINTE3:     equ    3                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 3
PITINTE_PINTE4:     equ    4                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 4
PITINTE_PINTE5:     equ    5                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 5
PITINTE_PINTE6:     equ    6                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 6
PITINTE_PINTE7:     equ    7                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 7
; bit position masks
mPITINTE_PINTE0:    equ    %00000001
mPITINTE_PINTE1:    equ    %00000010
mPITINTE_PINTE2:    equ    %00000100
mPITINTE_PINTE3:    equ    %00001000
mPITINTE_PINTE4:    equ    %00010000
mPITINTE_PINTE5:    equ    %00100000
mPITINTE_PINTE6:    equ    %01000000
mPITINTE_PINTE7:    equ    %10000000


;*** PITTF - PIT Time-out Flag Register; 0x00000345 ***
PITTF:              equ    $00000345                                ;*** PITTF - PIT Time-out Flag Register; 0x00000345 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITTF_PTF0:         equ    0                                         ; PIT Time-out Flag Bits for Timer Channel 0
PITTF_PTF1:         equ    1                                         ; PIT Time-out Flag Bits for Timer Channel 1
PITTF_PTF2:         equ    2                                         ; PIT Time-out Flag Bits for Timer Channel 2
PITTF_PTF3:         equ    3                                         ; PIT Time-out Flag Bits for Timer Channel 3
PITTF_PTF4:         equ    4                                         ; PIT Time-out Flag Bits for Timer Channel 4
PITTF_PTF5:         equ    5                                         ; PIT Time-out Flag Bits for Timer Channel 5
PITTF_PTF6:         equ    6                                         ; PIT Time-out Flag Bits for Timer Channel 6
PITTF_PTF7:         equ    7                                         ; PIT Time-out Flag Bits for Timer Channel 7
; bit position masks
mPITTF_PTF0:        equ    %00000001
mPITTF_PTF1:        equ    %00000010
mPITTF_PTF2:        equ    %00000100
mPITTF_PTF3:        equ    %00001000
mPITTF_PTF4:        equ    %00010000
mPITTF_PTF5:        equ    %00100000
mPITTF_PTF6:        equ    %01000000
mPITTF_PTF7:        equ    %10000000


;*** PITMTLD0 - PIT Micro Timer Load Register 0; 0x00000346 ***
PITMTLD0:           equ    $00000346                                ;*** PITMTLD0 - PIT Micro Timer Load Register 0; 0x00000346 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMTLD0_PMTLD0:    equ    0                                         ; PIT Micro Timer Load Bit 0
PITMTLD0_PMTLD1:    equ    1                                         ; PIT Micro Timer Load Bit 1
PITMTLD0_PMTLD2:    equ    2                                         ; PIT Micro Timer Load Bit 2
PITMTLD0_PMTLD3:    equ    3                                         ; PIT Micro Timer Load Bit 3
PITMTLD0_PMTLD4:    equ    4                                         ; PIT Micro Timer Load Bit 4
PITMTLD0_PMTLD5:    equ    5                                         ; PIT Micro Timer Load Bit 5
PITMTLD0_PMTLD6:    equ    6                                         ; PIT Micro Timer Load Bit 6
PITMTLD0_PMTLD7:    equ    7                                         ; PIT Micro Timer Load Bit 7
; bit position masks
mPITMTLD0_PMTLD0:   equ    %00000001
mPITMTLD0_PMTLD1:   equ    %00000010
mPITMTLD0_PMTLD2:   equ    %00000100
mPITMTLD0_PMTLD3:   equ    %00001000
mPITMTLD0_PMTLD4:   equ    %00010000
mPITMTLD0_PMTLD5:   equ    %00100000
mPITMTLD0_PMTLD6:   equ    %01000000
mPITMTLD0_PMTLD7:   equ    %10000000


;*** PITMTLD1 - PIT Micro Timer Load Register 1; 0x00000347 ***
PITMTLD1:           equ    $00000347                                ;*** PITMTLD1 - PIT Micro Timer Load Register 1; 0x00000347 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMTLD1_PMTLD0:    equ    0                                         ; PIT Micro Timer Load Bit 0
PITMTLD1_PMTLD1:    equ    1                                         ; PIT Micro Timer Load Bit 1
PITMTLD1_PMTLD2:    equ    2                                         ; PIT Micro Timer Load Bit 2
PITMTLD1_PMTLD3:    equ    3                                         ; PIT Micro Timer Load Bit 3
PITMTLD1_PMTLD4:    equ    4                                         ; PIT Micro Timer Load Bit 4
PITMTLD1_PMTLD5:    equ    5                                         ; PIT Micro Timer Load Bit 5
PITMTLD1_PMTLD6:    equ    6                                         ; PIT Micro Timer Load Bit 6
PITMTLD1_PMTLD7:    equ    7                                         ; PIT Micro Timer Load Bit 7
; bit position masks
mPITMTLD1_PMTLD0:   equ    %00000001
mPITMTLD1_PMTLD1:   equ    %00000010
mPITMTLD1_PMTLD2:   equ    %00000100
mPITMTLD1_PMTLD3:   equ    %00001000
mPITMTLD1_PMTLD4:   equ    %00010000
mPITMTLD1_PMTLD5:   equ    %00100000
mPITMTLD1_PMTLD6:   equ    %01000000
mPITMTLD1_PMTLD7:   equ    %10000000


;*** PITLD0 - PIT Load Register 0; 0x00000348 ***
PITLD0:             equ    $00000348                                ;*** PITLD0 - PIT Load Register 0; 0x00000348 ***


;*** PITCNT0 - PIT Count Register 0; 0x0000034A ***
PITCNT0:            equ    $0000034A                                ;*** PITCNT0 - PIT Count Register 0; 0x0000034A ***


;*** PITLD1 - PIT Load Register 1; 0x0000034C ***
PITLD1:             equ    $0000034C                                ;*** PITLD1 - PIT Load Register 1; 0x0000034C ***


;*** PITCNT1 - PIT Count Register 1; 0x0000034E ***
PITCNT1:            equ    $0000034E                                ;*** PITCNT1 - PIT Count Register 1; 0x0000034E ***


;*** PITLD2 - PIT Load Register 2; 0x00000350 ***
PITLD2:             equ    $00000350                                ;*** PITLD2 - PIT Load Register 2; 0x00000350 ***


;*** PITCNT2 - PIT Count Register 2; 0x00000352 ***
PITCNT2:            equ    $00000352                                ;*** PITCNT2 - PIT Count Register 2; 0x00000352 ***


;*** PITLD3 - PIT Load Register 3; 0x00000354 ***
PITLD3:             equ    $00000354                                ;*** PITLD3 - PIT Load Register 3; 0x00000354 ***


;*** PITCNT3 - PIT Count Register 3; 0x00000356 ***
PITCNT3:            equ    $00000356                                ;*** PITCNT3 - PIT Count Register 3; 0x00000356 ***


;*** PITLD4 - PIT Load Register 4; 0x00000358 ***
PITLD4:             equ    $00000358                                ;*** PITLD4 - PIT Load Register 4; 0x00000358 ***


;*** PITCNT4 - PIT Count Register 4; 0x0000035A ***
PITCNT4:            equ    $0000035A                                ;*** PITCNT4 - PIT Count Register 4; 0x0000035A ***


;*** PITLD5 - PIT Load Register 5; 0x0000035C ***
PITLD5:             equ    $0000035C                                ;*** PITLD5 - PIT Load Register 5; 0x0000035C ***


;*** PITCNT5 - PIT Count Register 5; 0x0000035E ***
PITCNT5:            equ    $0000035E                                ;*** PITCNT5 - PIT Count Register 5; 0x0000035E ***


;*** PITLD6 - PIT Load Register 6; 0x00000360 ***
PITLD6:             equ    $00000360                                ;*** PITLD6 - PIT Load Register 6; 0x00000360 ***


;*** PITCNT6 - PIT Count Register 6; 0x00000362 ***
PITCNT6:            equ    $00000362                                ;*** PITCNT6 - PIT Count Register 6; 0x00000362 ***


;*** PITLD7 - PIT Load Register 7; 0x00000364 ***
PITLD7:             equ    $00000364                                ;*** PITLD7 - PIT Load Register 7; 0x00000364 ***


;*** PITCNT7 - PIT Count Register 7; 0x00000366 ***
PITCNT7:            equ    $00000366                                ;*** PITCNT7 - PIT Count Register 7; 0x00000366 ***


;*** PITCSTP - PIT Channel Stop Register; 0x00000368 ***
PITCSTP:            equ    $00000368                                ;*** PITCSTP - PIT Channel Stop Register; 0x00000368 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITCSTP_PITCSTP0:   equ    0                                         ; PIT Channel Stop Bit 0
PITCSTP_PITCSTP1:   equ    1                                         ; PIT Channel Stop Bit 1
PITCSTP_PITCSTP2:   equ    2                                         ; PIT Channel Stop Bit 2
PITCSTP_PITCSTP3:   equ    3                                         ; PIT Channel Stop Bit 3
PITCSTP_PITCSTP4:   equ    4                                         ; PIT Channel Stop Bit 4
PITCSTP_PITCSTP5:   equ    5                                         ; PIT Channel Stop Bit 5
PITCSTP_PITCSTP6:   equ    6                                         ; PIT Channel Stop Bit 6
PITCSTP_PITCSTP7:   equ    7                                         ; PIT Channel Stop Bit 7
; bit position masks
mPITCSTP_PITCSTP0:  equ    %00000001
mPITCSTP_PITCSTP1:  equ    %00000010
mPITCSTP_PITCSTP2:  equ    %00000100
mPITCSTP_PITCSTP3:  equ    %00001000
mPITCSTP_PITCSTP4:  equ    %00010000
mPITCSTP_PITCSTP5:  equ    %00100000
mPITCSTP_PITCSTP6:  equ    %01000000
mPITCSTP_PITCSTP7:  equ    %10000000


;*** PITTRIGOUT - PIT Combined Output Trigger Configuration Register; 0x00000369 ***
PITTRIGOUT:         equ    $00000369                                ;*** PITTRIGOUT - PIT Combined Output Trigger Configuration Register; 0x00000369 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITTRIGOUT_PITCOTE0: equ    0                                        ; PIT Combined Output Trigger Enable Bit 0
PITTRIGOUT_PITCOTE1: equ    1                                        ; PIT Combined Output Trigger Enable Bit 1
PITTRIGOUT_PITCOTE2: equ    2                                        ; PIT Combined Output Trigger Enable Bit 2
PITTRIGOUT_PITCOTE3: equ    3                                        ; PIT Combined Output Trigger Enable Bit 3
PITTRIGOUT_PITCOTE4: equ    4                                        ; PIT Combined Output Trigger Enable Bit 4
PITTRIGOUT_PITCOTE5: equ    5                                        ; PIT Combined Output Trigger Enable Bit 5
PITTRIGOUT_PITCOTE6: equ    6                                        ; PIT Combined Output Trigger Enable Bit 6
PITTRIGOUT_PITCOTE7: equ    7                                        ; PIT Combined Output Trigger Enable Bit 7
; bit position masks
mPITTRIGOUT_PITCOTE0: equ    %00000001
mPITTRIGOUT_PITCOTE1: equ    %00000010
mPITTRIGOUT_PITCOTE2: equ    %00000100
mPITTRIGOUT_PITCOTE3: equ    %00001000
mPITTRIGOUT_PITCOTE4: equ    %00010000
mPITTRIGOUT_PITCOTE5: equ    %00100000
mPITTRIGOUT_PITCOTE6: equ    %01000000
mPITTRIGOUT_PITCOTE7: equ    %10000000


;*** PITTRIGCTL - PIT Input Trigger Control Register; 0x0000036A ***
PITTRIGCTL:         equ    $0000036A                                ;*** PITTRIGCTL - PIT Input Trigger Control Register; 0x0000036A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITTRIGCTL_PITTRIGSRC: equ    0                                      ; PIT Input Trigger Source Select
PITTRIGCTL_PITTRIGEDGE: equ    4                                     ; PIT Input Trigger Edge Select
PITTRIGCTL_PITTRIGIE: equ    7                                       ; PIT Input Trigger Interrupt Enable
; bit position masks
mPITTRIGCTL_PITTRIGSRC: equ    %00000011
mPITTRIGCTL_PITTRIGEDGE: equ    %00110000
mPITTRIGCTL_PITTRIGIE: equ    %10000000


;*** PITTRIGSTAT - PIT Input Trigger Status Register; 0x0000036B ***
PITTRIGSTAT:        equ    $0000036B                                ;*** PITTRIGSTAT - PIT Input Trigger Status Register; 0x0000036B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITTRIGSTAT_PITTRIGIF: equ    7                                      ; PIT Input Trigger Interrupt Flag
; bit position masks
mPITTRIGSTAT_PITTRIGIF: equ    %10000000


;*** PITTRIGE - PIT Input Trigger Channel Enable Register; 0x0000036C ***
PITTRIGE:           equ    $0000036C                                ;*** PITTRIGE - PIT Input Trigger Channel Enable Register; 0x0000036C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITTRIGE_PITTRIGE0: equ    0                                         ; PIT Input Trigger Channel Enable Bit 0
PITTRIGE_PITTRIGE1: equ    1                                         ; PIT Input Trigger Channel Enable Bit 1
PITTRIGE_PITTRIGE2: equ    2                                         ; PIT Input Trigger Channel Enable Bit 2
PITTRIGE_PITTRIGE3: equ    3                                         ; PIT Input Trigger Channel Enable Bit 3
PITTRIGE_PITTRIGE4: equ    4                                         ; PIT Input Trigger Channel Enable Bit 4
PITTRIGE_PITTRIGE5: equ    5                                         ; PIT Input Trigger Channel Enable Bit 5
PITTRIGE_PITTRIGE6: equ    6                                         ; PIT Input Trigger Channel Enable Bit 6
PITTRIGE_PITTRIGE7: equ    7                                         ; PIT Input Trigger Channel Enable Bit 7
; bit position masks
mPITTRIGE_PITTRIGE0: equ    %00000001
mPITTRIGE_PITTRIGE1: equ    %00000010
mPITTRIGE_PITTRIGE2: equ    %00000100
mPITTRIGE_PITTRIGE3: equ    %00001000
mPITTRIGE_PITTRIGE4: equ    %00010000
mPITTRIGE_PITTRIGE5: equ    %00100000
mPITTRIGE_PITTRIGE6: equ    %01000000
mPITTRIGE_PITTRIGE7: equ    %10000000


;*** XGMCTL - XGATE Control Register; 0x00000380 ***
XGMCTL:             equ    $00000380                                ;*** XGMCTL - XGATE Control Register; 0x00000380 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGMCTL_XGIE:        equ    0                                         ; XGATE Interrupt Enable
XGMCTL_XGSWEF:      equ    1                                         ; XGATE Software Error Flag
XGMCTL_XGFACT:      equ    3                                         ; Fake XGATE Activity
XGMCTL_XGSS:        equ    4                                         ; XGATE Single Step
XGMCTL_XGDBG:       equ    5                                         ; XGATE Debug Mode
XGMCTL_XGFRZ:       equ    6                                         ; Halt XGATE in Freeze Mode
XGMCTL_XGE:         equ    7                                         ; XGATE Module Enable
XGMCTL_XGIEM:       equ    8                                         ; XGIE Mask
XGMCTL_XGSWEFM:     equ    9                                         ; XGSWEF Mask
XGMCTL_XGFACTM:     equ    11                                        ; XGFACT Mask
XGMCTL_XGSSM:       equ    12                                        ; XGSS Mask
XGMCTL_XGDBGM:      equ    13                                        ; XGDBG Mask
XGMCTL_XGFRZM:      equ    14                                        ; XGFRZ Mask
XGMCTL_XGEM:        equ    15                                        ; XGE Mask
; bit position masks
mXGMCTL_XGIE:       equ    %00000001
mXGMCTL_XGSWEF:     equ    %00000010
mXGMCTL_XGFACT:     equ    %00001000
mXGMCTL_XGSS:       equ    %00010000
mXGMCTL_XGDBG:      equ    %00100000
mXGMCTL_XGFRZ:      equ    %01000000
mXGMCTL_XGE:        equ    %10000000
mXGMCTL_XGIEM:      equ    %100000000
mXGMCTL_XGSWEFM:    equ    %1000000000
mXGMCTL_XGFACTM:    equ    %100000000000
mXGMCTL_XGSSM:      equ    %1000000000000
mXGMCTL_XGDBGM:     equ    %10000000000000
mXGMCTL_XGFRZM:     equ    %100000000000000
mXGMCTL_XGEM:       equ    %1000000000000000


;*** XGCHID - XGATE Channel ID Register; 0x00000382 ***
XGCHID:             equ    $00000382                                ;*** XGCHID - XGATE Channel ID Register; 0x00000382 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGCHID_XGCHID:      equ    0                                         ; Request Identifier
; bit position masks
mXGCHID_XGCHID:     equ    %01111111


;*** XGCHPL - XGATE Channel Priority Level; 0x00000383 ***
XGCHPL:             equ    $00000383                                ;*** XGCHPL - XGATE Channel Priority Level; 0x00000383 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGCHPL_XGCHPL:      equ    0                                         ; Priority Level Bits
; bit position masks
mXGCHPL_XGCHPL:     equ    %00000111


;*** XGISPSEL - XGATE Initial Stack Pointer Select Register; 0x00000385 ***
XGISPSEL:           equ    $00000385                                ;*** XGISPSEL - XGATE Initial Stack Pointer Select Register; 0x00000385 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGISPSEL_XGISPSEL:  equ    0                                         ; Register select bits
; bit position masks
mXGISPSEL_XGISPSEL: equ    %00000011


;*** XGISP31 - XGATE Initial Stack Pointer for Interrupt Priorities 3 to 1; 0x00000386 ***
XGISP31:            equ    $00000386                                ;*** XGISP31 - XGATE Initial Stack Pointer for Interrupt Priorities 3 to 1; 0x00000386 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGISP31_XGISP31:    equ    1                                         ; Initial Stack Pointer
; bit position masks
mXGISP31_XGISP31:   equ    %1111111111111110


;*** XGISP74 - XGATE Initial Stack Pointer for Interrupt Priorities 7 to 4; 0x00000386 ***
XGISP74:            equ    $00000386                                ;*** XGISP74 - XGATE Initial Stack Pointer for Interrupt Priorities 7 to 4; 0x00000386 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGISP74_XGISP74:    equ    1                                         ; Initial Stack Pointer
; bit position masks
mXGISP74_XGISP74:   equ    %1111111111111110


;*** XGVBR - XGATE Control Register; 0x00000386 ***
XGVBR:              equ    $00000386                                ;*** XGVBR - XGATE Control Register; 0x00000386 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGVBR_XGVBR:        equ    1                                         ; Vector Base Address
; bit position masks
mXGVBR_XGVBR:       equ    %1111111111111110


;*** XGIF_7F_70 - XGATE Channel Interrupt Flag Vector; 0x00000388 ***
XGIF_7F_70:         equ    $00000388                                ;*** XGIF_7F_70 - XGATE Channel Interrupt Flag Vector; 0x00000388 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_7F_70_XGIF_70: equ    0                                         ; Channel Interrupt Flags, bit 112
XGIF_7F_70_XGIF_71: equ    1                                         ; Channel Interrupt Flags, bit 113
XGIF_7F_70_XGIF_72: equ    2                                         ; Channel Interrupt Flags, bit 114
XGIF_7F_70_XGIF_73: equ    3                                         ; Channel Interrupt Flags, bit 115
XGIF_7F_70_XGIF_74: equ    4                                         ; Channel Interrupt Flags, bit 116
XGIF_7F_70_XGIF_75: equ    5                                         ; Channel Interrupt Flags, bit 117
XGIF_7F_70_XGIF_76: equ    6                                         ; Channel Interrupt Flags, bit 118
XGIF_7F_70_XGIF_77: equ    7                                         ; Channel Interrupt Flags, bit 119
XGIF_7F_70_XGIF_78: equ    8                                         ; Channel Interrupt Flags, bit 120
; bit position masks
mXGIF_7F_70_XGIF_70: equ    %00000001
mXGIF_7F_70_XGIF_71: equ    %00000010
mXGIF_7F_70_XGIF_72: equ    %00000100
mXGIF_7F_70_XGIF_73: equ    %00001000
mXGIF_7F_70_XGIF_74: equ    %00010000
mXGIF_7F_70_XGIF_75: equ    %00100000
mXGIF_7F_70_XGIF_76: equ    %01000000
mXGIF_7F_70_XGIF_77: equ    %10000000
mXGIF_7F_70_XGIF_78: equ    %100000000


;*** XGIF_6F_60 - XGATE Channel Interrupt Flag Vector; 0x0000038A ***
XGIF_6F_60:         equ    $0000038A                                ;*** XGIF_6F_60 - XGATE Channel Interrupt Flag Vector; 0x0000038A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_6F_60_XGIF_60: equ    0                                         ; Channel Interrupt Flags, bit 96
XGIF_6F_60_XGIF_61: equ    1                                         ; Channel Interrupt Flags, bit 97
XGIF_6F_60_XGIF_62: equ    2                                         ; Channel Interrupt Flags, bit 98
XGIF_6F_60_XGIF_63: equ    3                                         ; Channel Interrupt Flags, bit 99
XGIF_6F_60_XGIF_64: equ    4                                         ; Channel Interrupt Flags, bit 100
XGIF_6F_60_XGIF_65: equ    5                                         ; Channel Interrupt Flags, bit 101
XGIF_6F_60_XGIF_66: equ    6                                         ; Channel Interrupt Flags, bit 102
XGIF_6F_60_XGIF_67: equ    7                                         ; Channel Interrupt Flags, bit 103
XGIF_6F_60_XGIF_68: equ    8                                         ; Channel Interrupt Flags, bit 104
XGIF_6F_60_XGIF_69: equ    9                                         ; Channel Interrupt Flags, bit 105
XGIF_6F_60_XGIF_6A: equ    10                                        ; Channel Interrupt Flags, bit 106
XGIF_6F_60_XGIF_6B: equ    11                                        ; Channel Interrupt Flags, bit 107
XGIF_6F_60_XGIF_6C: equ    12                                        ; Channel Interrupt Flags, bit 108
XGIF_6F_60_XGIF_6D: equ    13                                        ; Channel Interrupt Flags, bit 109
XGIF_6F_60_XGIF_6E: equ    14                                        ; Channel Interrupt Flags, bit 110
XGIF_6F_60_XGIF_6F: equ    15                                        ; Channel Interrupt Flags, bit 111
; bit position masks
mXGIF_6F_60_XGIF_60: equ    %00000001
mXGIF_6F_60_XGIF_61: equ    %00000010
mXGIF_6F_60_XGIF_62: equ    %00000100
mXGIF_6F_60_XGIF_63: equ    %00001000
mXGIF_6F_60_XGIF_64: equ    %00010000
mXGIF_6F_60_XGIF_65: equ    %00100000
mXGIF_6F_60_XGIF_66: equ    %01000000
mXGIF_6F_60_XGIF_67: equ    %10000000
mXGIF_6F_60_XGIF_68: equ    %100000000
mXGIF_6F_60_XGIF_69: equ    %1000000000
mXGIF_6F_60_XGIF_6A: equ    %10000000000
mXGIF_6F_60_XGIF_6B: equ    %100000000000
mXGIF_6F_60_XGIF_6C: equ    %1000000000000
mXGIF_6F_60_XGIF_6D: equ    %10000000000000
mXGIF_6F_60_XGIF_6E: equ    %100000000000000
mXGIF_6F_60_XGIF_6F: equ    %1000000000000000


;*** XGIF_5F_50 - XGATE Channel Interrupt Flag Vector; 0x0000038C ***
XGIF_5F_50:         equ    $0000038C                                ;*** XGIF_5F_50 - XGATE Channel Interrupt Flag Vector; 0x0000038C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_5F_50_XGIF_50: equ    0                                         ; Channel Interrupt Flags, bit 80
XGIF_5F_50_XGIF_51: equ    1                                         ; Channel Interrupt Flags, bit 81
XGIF_5F_50_XGIF_52: equ    2                                         ; Channel Interrupt Flags, bit 82
XGIF_5F_50_XGIF_53: equ    3                                         ; Channel Interrupt Flags, bit 83
XGIF_5F_50_XGIF_54: equ    4                                         ; Channel Interrupt Flags, bit 84
XGIF_5F_50_XGIF_55: equ    5                                         ; Channel Interrupt Flags, bit 85
XGIF_5F_50_XGIF_56: equ    6                                         ; Channel Interrupt Flags, bit 86
XGIF_5F_50_XGIF_57: equ    7                                         ; Channel Interrupt Flags, bit 87
XGIF_5F_50_XGIF_58: equ    8                                         ; Channel Interrupt Flags, bit 88
XGIF_5F_50_XGIF_59: equ    9                                         ; Channel Interrupt Flags, bit 89
XGIF_5F_50_XGIF_5A: equ    10                                        ; Channel Interrupt Flags, bit 90
XGIF_5F_50_XGIF_5B: equ    11                                        ; Channel Interrupt Flags, bit 91
XGIF_5F_50_XGIF_5C: equ    12                                        ; Channel Interrupt Flags, bit 92
XGIF_5F_50_XGIF_5D: equ    13                                        ; Channel Interrupt Flags, bit 93
XGIF_5F_50_XGIF_5E: equ    14                                        ; Channel Interrupt Flags, bit 94
XGIF_5F_50_XGIF_5F: equ    15                                        ; Channel Interrupt Flags, bit 95
; bit position masks
mXGIF_5F_50_XGIF_50: equ    %00000001
mXGIF_5F_50_XGIF_51: equ    %00000010
mXGIF_5F_50_XGIF_52: equ    %00000100
mXGIF_5F_50_XGIF_53: equ    %00001000
mXGIF_5F_50_XGIF_54: equ    %00010000
mXGIF_5F_50_XGIF_55: equ    %00100000
mXGIF_5F_50_XGIF_56: equ    %01000000
mXGIF_5F_50_XGIF_57: equ    %10000000
mXGIF_5F_50_XGIF_58: equ    %100000000
mXGIF_5F_50_XGIF_59: equ    %1000000000
mXGIF_5F_50_XGIF_5A: equ    %10000000000
mXGIF_5F_50_XGIF_5B: equ    %100000000000
mXGIF_5F_50_XGIF_5C: equ    %1000000000000
mXGIF_5F_50_XGIF_5D: equ    %10000000000000
mXGIF_5F_50_XGIF_5E: equ    %100000000000000
mXGIF_5F_50_XGIF_5F: equ    %1000000000000000


;*** XGIF_4F_40 - XGATE Channel Interrupt Flag Vector; 0x0000038E ***
XGIF_4F_40:         equ    $0000038E                                ;*** XGIF_4F_40 - XGATE Channel Interrupt Flag Vector; 0x0000038E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_4F_40_XGIF_40: equ    0                                         ; Channel Interrupt Flags, bit 64
XGIF_4F_40_XGIF_41: equ    1                                         ; Channel Interrupt Flags, bit 65
XGIF_4F_40_XGIF_42: equ    2                                         ; Channel Interrupt Flags, bit 66
XGIF_4F_40_XGIF_43: equ    3                                         ; Channel Interrupt Flags, bit 67
XGIF_4F_40_XGIF_44: equ    4                                         ; Channel Interrupt Flags, bit 68
XGIF_4F_40_XGIF_45: equ    5                                         ; Channel Interrupt Flags, bit 69
XGIF_4F_40_XGIF_46: equ    6                                         ; Channel Interrupt Flags, bit 70
XGIF_4F_40_XGIF_47: equ    7                                         ; Channel Interrupt Flags, bit 71
XGIF_4F_40_XGIF_48: equ    8                                         ; Channel Interrupt Flags, bit 72
XGIF_4F_40_XGIF_49: equ    9                                         ; Channel Interrupt Flags, bit 73
XGIF_4F_40_XGIF_4A: equ    10                                        ; Channel Interrupt Flags, bit 74
XGIF_4F_40_XGIF_4B: equ    11                                        ; Channel Interrupt Flags, bit 75
XGIF_4F_40_XGIF_4C: equ    12                                        ; Channel Interrupt Flags, bit 76
XGIF_4F_40_XGIF_4D: equ    13                                        ; Channel Interrupt Flags, bit 77
XGIF_4F_40_XGIF_4E: equ    14                                        ; Channel Interrupt Flags, bit 78
XGIF_4F_40_XGIF_4F: equ    15                                        ; Channel Interrupt Flags, bit 79
; bit position masks
mXGIF_4F_40_XGIF_40: equ    %00000001
mXGIF_4F_40_XGIF_41: equ    %00000010
mXGIF_4F_40_XGIF_42: equ    %00000100
mXGIF_4F_40_XGIF_43: equ    %00001000
mXGIF_4F_40_XGIF_44: equ    %00010000
mXGIF_4F_40_XGIF_45: equ    %00100000
mXGIF_4F_40_XGIF_46: equ    %01000000
mXGIF_4F_40_XGIF_47: equ    %10000000
mXGIF_4F_40_XGIF_48: equ    %100000000
mXGIF_4F_40_XGIF_49: equ    %1000000000
mXGIF_4F_40_XGIF_4A: equ    %10000000000
mXGIF_4F_40_XGIF_4B: equ    %100000000000
mXGIF_4F_40_XGIF_4C: equ    %1000000000000
mXGIF_4F_40_XGIF_4D: equ    %10000000000000
mXGIF_4F_40_XGIF_4E: equ    %100000000000000
mXGIF_4F_40_XGIF_4F: equ    %1000000000000000


;*** XGIF_3F_30 - XGATE Channel Interrupt Flag Vector; 0x00000390 ***
XGIF_3F_30:         equ    $00000390                                ;*** XGIF_3F_30 - XGATE Channel Interrupt Flag Vector; 0x00000390 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_3F_30_XGIF_30: equ    0                                         ; Channel Interrupt Flags, bit 48
XGIF_3F_30_XGIF_31: equ    1                                         ; Channel Interrupt Flags, bit 49
XGIF_3F_30_XGIF_32: equ    2                                         ; Channel Interrupt Flags, bit 50
XGIF_3F_30_XGIF_33: equ    3                                         ; Channel Interrupt Flags, bit 51
XGIF_3F_30_XGIF_34: equ    4                                         ; Channel Interrupt Flags, bit 52
XGIF_3F_30_XGIF_35: equ    5                                         ; Channel Interrupt Flags, bit 53
XGIF_3F_30_XGIF_36: equ    6                                         ; Channel Interrupt Flags, bit 54
XGIF_3F_30_XGIF_37: equ    7                                         ; Channel Interrupt Flags, bit 55
XGIF_3F_30_XGIF_38: equ    8                                         ; Channel Interrupt Flags, bit 56
XGIF_3F_30_XGIF_39: equ    9                                         ; Channel Interrupt Flags, bit 57
XGIF_3F_30_XGIF_3A: equ    10                                        ; Channel Interrupt Flags, bit 58
XGIF_3F_30_XGIF_3B: equ    11                                        ; Channel Interrupt Flags, bit 59
XGIF_3F_30_XGIF_3C: equ    12                                        ; Channel Interrupt Flags, bit 60
XGIF_3F_30_XGIF_3D: equ    13                                        ; Channel Interrupt Flags, bit 61
XGIF_3F_30_XGIF_3E: equ    14                                        ; Channel Interrupt Flags, bit 62
XGIF_3F_30_XGIF_3F: equ    15                                        ; Channel Interrupt Flags, bit 63
; bit position masks
mXGIF_3F_30_XGIF_30: equ    %00000001
mXGIF_3F_30_XGIF_31: equ    %00000010
mXGIF_3F_30_XGIF_32: equ    %00000100
mXGIF_3F_30_XGIF_33: equ    %00001000
mXGIF_3F_30_XGIF_34: equ    %00010000
mXGIF_3F_30_XGIF_35: equ    %00100000
mXGIF_3F_30_XGIF_36: equ    %01000000
mXGIF_3F_30_XGIF_37: equ    %10000000
mXGIF_3F_30_XGIF_38: equ    %100000000
mXGIF_3F_30_XGIF_39: equ    %1000000000
mXGIF_3F_30_XGIF_3A: equ    %10000000000
mXGIF_3F_30_XGIF_3B: equ    %100000000000
mXGIF_3F_30_XGIF_3C: equ    %1000000000000
mXGIF_3F_30_XGIF_3D: equ    %10000000000000
mXGIF_3F_30_XGIF_3E: equ    %100000000000000
mXGIF_3F_30_XGIF_3F: equ    %1000000000000000


;*** XGIF_2F_20 - XGATE Channel Interrupt Flag Vector; 0x00000392 ***
XGIF_2F_20:         equ    $00000392                                ;*** XGIF_2F_20 - XGATE Channel Interrupt Flag Vector; 0x00000392 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_2F_20_XGIF_20: equ    0                                         ; Channel Interrupt Flags, bit 32
XGIF_2F_20_XGIF_21: equ    1                                         ; Channel Interrupt Flags, bit 33
XGIF_2F_20_XGIF_22: equ    2                                         ; Channel Interrupt Flags, bit 34
XGIF_2F_20_XGIF_23: equ    3                                         ; Channel Interrupt Flags, bit 35
XGIF_2F_20_XGIF_24: equ    4                                         ; Channel Interrupt Flags, bit 36
XGIF_2F_20_XGIF_25: equ    5                                         ; Channel Interrupt Flags, bit 37
XGIF_2F_20_XGIF_26: equ    6                                         ; Channel Interrupt Flags, bit 38
XGIF_2F_20_XGIF_27: equ    7                                         ; Channel Interrupt Flags, bit 39
XGIF_2F_20_XGIF_28: equ    8                                         ; Channel Interrupt Flags, bit 40
XGIF_2F_20_XGIF_29: equ    9                                         ; Channel Interrupt Flags, bit 41
XGIF_2F_20_XGIF_2A: equ    10                                        ; Channel Interrupt Flags, bit 42
XGIF_2F_20_XGIF_2B: equ    11                                        ; Channel Interrupt Flags, bit 43
XGIF_2F_20_XGIF_2C: equ    12                                        ; Channel Interrupt Flags, bit 44
XGIF_2F_20_XGIF_2D: equ    13                                        ; Channel Interrupt Flags, bit 45
XGIF_2F_20_XGIF_2E: equ    14                                        ; Channel Interrupt Flags, bit 46
XGIF_2F_20_XGIF_2F: equ    15                                        ; Channel Interrupt Flags, bit 47
; bit position masks
mXGIF_2F_20_XGIF_20: equ    %00000001
mXGIF_2F_20_XGIF_21: equ    %00000010
mXGIF_2F_20_XGIF_22: equ    %00000100
mXGIF_2F_20_XGIF_23: equ    %00001000
mXGIF_2F_20_XGIF_24: equ    %00010000
mXGIF_2F_20_XGIF_25: equ    %00100000
mXGIF_2F_20_XGIF_26: equ    %01000000
mXGIF_2F_20_XGIF_27: equ    %10000000
mXGIF_2F_20_XGIF_28: equ    %100000000
mXGIF_2F_20_XGIF_29: equ    %1000000000
mXGIF_2F_20_XGIF_2A: equ    %10000000000
mXGIF_2F_20_XGIF_2B: equ    %100000000000
mXGIF_2F_20_XGIF_2C: equ    %1000000000000
mXGIF_2F_20_XGIF_2D: equ    %10000000000000
mXGIF_2F_20_XGIF_2E: equ    %100000000000000
mXGIF_2F_20_XGIF_2F: equ    %1000000000000000


;*** XGIF_1F_10 - XGATE Channel Interrupt Flag Vector; 0x00000394 ***
XGIF_1F_10:         equ    $00000394                                ;*** XGIF_1F_10 - XGATE Channel Interrupt Flag Vector; 0x00000394 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_1F_10_XGIF_10: equ    0                                         ; Channel Interrupt Flags, bit 16
XGIF_1F_10_XGIF_11: equ    1                                         ; Channel Interrupt Flags, bit 17
XGIF_1F_10_XGIF_12: equ    2                                         ; Channel Interrupt Flags, bit 18
XGIF_1F_10_XGIF_13: equ    3                                         ; Channel Interrupt Flags, bit 19
XGIF_1F_10_XGIF_14: equ    4                                         ; Channel Interrupt Flags, bit 20
XGIF_1F_10_XGIF_15: equ    5                                         ; Channel Interrupt Flags, bit 21
XGIF_1F_10_XGIF_16: equ    6                                         ; Channel Interrupt Flags, bit 22
XGIF_1F_10_XGIF_17: equ    7                                         ; Channel Interrupt Flags, bit 23
XGIF_1F_10_XGIF_18: equ    8                                         ; Channel Interrupt Flags, bit 24
XGIF_1F_10_XGIF_19: equ    9                                         ; Channel Interrupt Flags, bit 25
XGIF_1F_10_XGIF_1A: equ    10                                        ; Channel Interrupt Flags, bit 26
XGIF_1F_10_XGIF_1B: equ    11                                        ; Channel Interrupt Flags, bit 27
XGIF_1F_10_XGIF_1C: equ    12                                        ; Channel Interrupt Flags, bit 28
XGIF_1F_10_XGIF_1D: equ    13                                        ; Channel Interrupt Flags, bit 29
XGIF_1F_10_XGIF_1E: equ    14                                        ; Channel Interrupt Flags, bit 30
XGIF_1F_10_XGIF_1F: equ    15                                        ; Channel Interrupt Flags, bit 31
; bit position masks
mXGIF_1F_10_XGIF_10: equ    %00000001
mXGIF_1F_10_XGIF_11: equ    %00000010
mXGIF_1F_10_XGIF_12: equ    %00000100
mXGIF_1F_10_XGIF_13: equ    %00001000
mXGIF_1F_10_XGIF_14: equ    %00010000
mXGIF_1F_10_XGIF_15: equ    %00100000
mXGIF_1F_10_XGIF_16: equ    %01000000
mXGIF_1F_10_XGIF_17: equ    %10000000
mXGIF_1F_10_XGIF_18: equ    %100000000
mXGIF_1F_10_XGIF_19: equ    %1000000000
mXGIF_1F_10_XGIF_1A: equ    %10000000000
mXGIF_1F_10_XGIF_1B: equ    %100000000000
mXGIF_1F_10_XGIF_1C: equ    %1000000000000
mXGIF_1F_10_XGIF_1D: equ    %10000000000000
mXGIF_1F_10_XGIF_1E: equ    %100000000000000
mXGIF_1F_10_XGIF_1F: equ    %1000000000000000


;*** XGIF_0F_00 - XGATE Channel Interrupt Flag Vector; 0x00000396 ***
XGIF_0F_00:         equ    $00000396                                ;*** XGIF_0F_00 - XGATE Channel Interrupt Flag Vector; 0x00000396 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_0F_00_XGIF_09: equ    9                                         ; Channel Interrupt Flags, bit 9
XGIF_0F_00_XGIF_0A: equ    10                                        ; Channel Interrupt Flags, bit 10
XGIF_0F_00_XGIF_0B: equ    11                                        ; Channel Interrupt Flags, bit 11
XGIF_0F_00_XGIF_0C: equ    12                                        ; Channel Interrupt Flags, bit 12
XGIF_0F_00_XGIF_0D: equ    13                                        ; Channel Interrupt Flags, bit 13
XGIF_0F_00_XGIF_0E: equ    14                                        ; Channel Interrupt Flags, bit 14
XGIF_0F_00_XGIF_0F: equ    15                                        ; Channel Interrupt Flags, bit 15
; bit position masks
mXGIF_0F_00_XGIF_09: equ    %1000000000
mXGIF_0F_00_XGIF_0A: equ    %10000000000
mXGIF_0F_00_XGIF_0B: equ    %100000000000
mXGIF_0F_00_XGIF_0C: equ    %1000000000000
mXGIF_0F_00_XGIF_0D: equ    %10000000000000
mXGIF_0F_00_XGIF_0E: equ    %100000000000000
mXGIF_0F_00_XGIF_0F: equ    %1000000000000000


;*** XGSWT - XGATE Control Register; 0x00000398 ***
XGSWT:              equ    $00000398                                ;*** XGSWT - XGATE Control Register; 0x00000398 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGSWT_XGSWT:        equ    0                                         ; Software Trigger Bits
XGSWT_XGSWTM:       equ    8                                         ; Software Trigger Mask
; bit position masks
mXGSWT_XGSWT:       equ    %11111111
mXGSWT_XGSWTM:      equ    %1111111100000000


;*** XGSEM - XGATE Semaphore Register; 0x0000039A ***
XGSEM:              equ    $0000039A                                ;*** XGSEM - XGATE Semaphore Register; 0x0000039A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGSEM_XGSEM:        equ    0                                         ; Semaphore Bits
XGSEM_XGSEMM:       equ    8                                         ; Semaphore Mask
; bit position masks
mXGSEM_XGSEM:       equ    %11111111
mXGSEM_XGSEMM:      equ    %1111111100000000


;*** XGCCR - XGATE Condition Code Register; 0x0000039D ***
XGCCR:              equ    $0000039D                                ;*** XGCCR - XGATE Condition Code Register; 0x0000039D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGCCR_XGC:          equ    0                                         ; Carry Flag
XGCCR_XGV:          equ    1                                         ; Overflow Flag
XGCCR_XGZ:          equ    2                                         ; Zero Flag
XGCCR_XGN:          equ    3                                         ; Sign Flag
; bit position masks
mXGCCR_XGC:         equ    %00000001
mXGCCR_XGV:         equ    %00000010
mXGCCR_XGZ:         equ    %00000100
mXGCCR_XGN:         equ    %00001000


;*** XGPC - XGATE Program Counter Register; 0x0000039E ***
XGPC:               equ    $0000039E                                ;*** XGPC - XGATE Program Counter Register; 0x0000039E ***


;*** XGR1 - XGATE Register 1; 0x000003A2 ***
XGR1:               equ    $000003A2                                ;*** XGR1 - XGATE Register 1; 0x000003A2 ***


;*** XGR2 - XGATE Register 2; 0x000003A4 ***
XGR2:               equ    $000003A4                                ;*** XGR2 - XGATE Register 2; 0x000003A4 ***


;*** XGR3 - XGATE Register 3; 0x000003A6 ***
XGR3:               equ    $000003A6                                ;*** XGR3 - XGATE Register 3; 0x000003A6 ***


;*** XGR4 - XGATE Register 4; 0x000003A8 ***
XGR4:               equ    $000003A8                                ;*** XGR4 - XGATE Register 4; 0x000003A8 ***


;*** XGR5 - XGATE Register 5; 0x000003AA ***
XGR5:               equ    $000003AA                                ;*** XGR5 - XGATE Register 5; 0x000003AA ***


;*** XGR6 - XGATE Register 6; 0x000003AC ***
XGR6:               equ    $000003AC                                ;*** XGR6 - XGATE Register 6; 0x000003AC ***


;*** XGR7 - XGATE Register 7; 0x000003AE ***
XGR7:               equ    $000003AE                                ;*** XGR7 - XGATE Register 7; 0x000003AE ***


;*** MVR - Module Version Register; 0x00000400 ***
MVR:                equ    $00000400                                ;*** MVR - Module Version Register; 0x00000400 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MVR_PEVER:          equ    0                                         ; PE Version Number
MVR_CHIVER:         equ    8                                         ; CHI Version Number
; bit position masks
mMVR_PEVER:         equ    %11111111
mMVR_CHIVER:        equ    %1111111100000000


;*** MCR - Module Configuration Register; 0x00000402 ***
MCR:                equ    $00000402                                ;*** MCR - Module Configuration Register; 0x00000402 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCR_BITRATE:        equ    1                                         ; FlexRay Bus Bit Rate
MCR_CLKSEL:         equ    4                                         ; Protocol Engine Clock Source Select
MCR_SFFE:           equ    10                                        ; Synchronization Frame Filter Enable
MCR_CHA:            equ    11                                        ; Channel Enable
MCR_CHB:            equ    12                                        ; Channel Enable
MCR_SCM:            equ    13                                        ; Single Channel Device Mode
MCR_MEN:            equ    15                                        ; Module Enable
; bit position masks
mMCR_BITRATE:       equ    %00001110
mMCR_CLKSEL:        equ    %00010000
mMCR_SFFE:          equ    %10000000000
mMCR_CHA:           equ    %100000000000
mMCR_CHB:           equ    %1000000000000
mMCR_SCM:           equ    %10000000000000
mMCR_MEN:           equ    %1000000000000000


;*** SYMBADR - System Memory Base Address Register; 0x00000404 ***
SYMBADR:            equ    $00000404                                ;*** SYMBADR - System Memory Base Address Register; 0x00000404 ***


;*** SYMBADHR - System Memory Base Address High Register; 0x00000404 ***
SYMBADHR:           equ    $00000404                                ;*** SYMBADHR - System Memory Base Address High Register; 0x00000404 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYMBADHR_SYS_MEM_BASE_ADDR16: equ    0                               ; System Memory Base Address High, bit 0
SYMBADHR_SYS_MEM_BASE_ADDR17: equ    1                               ; System Memory Base Address High, bit 1
SYMBADHR_SYS_MEM_BASE_ADDR18: equ    2                               ; System Memory Base Address High, bit 2
SYMBADHR_SYS_MEM_BASE_ADDR19: equ    3                               ; System Memory Base Address High, bit 3
SYMBADHR_SYS_MEM_BASE_ADDR20: equ    4                               ; System Memory Base Address High, bit 4
SYMBADHR_SYS_MEM_BASE_ADDR21: equ    5                               ; System Memory Base Address High, bit 5
SYMBADHR_SYS_MEM_BASE_ADDR22: equ    6                               ; System Memory Base Address High, bit 6
; bit position masks
mSYMBADHR_SYS_MEM_BASE_ADDR16: equ    %00000001
mSYMBADHR_SYS_MEM_BASE_ADDR17: equ    %00000010
mSYMBADHR_SYS_MEM_BASE_ADDR18: equ    %00000100
mSYMBADHR_SYS_MEM_BASE_ADDR19: equ    %00001000
mSYMBADHR_SYS_MEM_BASE_ADDR20: equ    %00010000
mSYMBADHR_SYS_MEM_BASE_ADDR21: equ    %00100000
mSYMBADHR_SYS_MEM_BASE_ADDR22: equ    %01000000


;*** SYMBADLR - System Memory Base Address Low Register; 0x00000406 ***
SYMBADLR:           equ    $00000406                                ;*** SYMBADLR - System Memory Base Address Low Register; 0x00000406 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYMBADLR_SYS_MEM_BASE_ADDR4: equ    4                                ; System Memory Base Address Low, bit 0
SYMBADLR_SYS_MEM_BASE_ADDR5: equ    5                                ; System Memory Base Address Low, bit 1
SYMBADLR_SYS_MEM_BASE_ADDR6: equ    6                                ; System Memory Base Address Low, bit 2
SYMBADLR_SYS_MEM_BASE_ADDR7: equ    7                                ; System Memory Base Address Low, bit 3
SYMBADLR_SYS_MEM_BASE_ADDR8: equ    8                                ; System Memory Base Address Low, bit 4
SYMBADLR_SYS_MEM_BASE_ADDR9: equ    9                                ; System Memory Base Address Low, bit 5
SYMBADLR_SYS_MEM_BASE_ADDR10: equ    10                              ; System Memory Base Address Low, bit 6
SYMBADLR_SYS_MEM_BASE_ADDR11: equ    11                              ; System Memory Base Address Low, bit 7
SYMBADLR_SYS_MEM_BASE_ADDR12: equ    12                              ; System Memory Base Address Low, bit 8
SYMBADLR_SYS_MEM_BASE_ADDR13: equ    13                              ; System Memory Base Address Low, bit 9
SYMBADLR_SYS_MEM_BASE_ADDR14: equ    14                              ; System Memory Base Address Low, bit 10
SYMBADLR_SYS_MEM_BASE_ADDR15: equ    15                              ; System Memory Base Address Low, bit 11
; bit position masks
mSYMBADLR_SYS_MEM_BASE_ADDR4: equ    %00010000
mSYMBADLR_SYS_MEM_BASE_ADDR5: equ    %00100000
mSYMBADLR_SYS_MEM_BASE_ADDR6: equ    %01000000
mSYMBADLR_SYS_MEM_BASE_ADDR7: equ    %10000000
mSYMBADLR_SYS_MEM_BASE_ADDR8: equ    %100000000
mSYMBADLR_SYS_MEM_BASE_ADDR9: equ    %1000000000
mSYMBADLR_SYS_MEM_BASE_ADDR10: equ    %10000000000
mSYMBADLR_SYS_MEM_BASE_ADDR11: equ    %100000000000
mSYMBADLR_SYS_MEM_BASE_ADDR12: equ    %1000000000000
mSYMBADLR_SYS_MEM_BASE_ADDR13: equ    %10000000000000
mSYMBADLR_SYS_MEM_BASE_ADDR14: equ    %100000000000000
mSYMBADLR_SYS_MEM_BASE_ADDR15: equ    %1000000000000000


;*** STBSCR - Strobe Signal Control Register; 0x00000408 ***
STBSCR:             equ    $00000408                                ;*** STBSCR - Strobe Signal Control Register; 0x00000408 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
STBSCR_STBPSEL:     equ    0                                         ; Strobe Port Select
STBSCR_ENB:         equ    4                                         ; Strobe Signal Enable
STBSCR_SEL:         equ    8                                         ; Strobe Signal Select
STBSCR_WMD:         equ    15                                        ; Write Mode
; bit position masks
mSTBSCR_STBPSEL:    equ    %00000011
mSTBSCR_ENB:        equ    %00010000
mSTBSCR_SEL:        equ    %111111100000000
mSTBSCR_WMD:        equ    %1000000000000000


;*** STBPCR - Strobe Port Control Register; 0x0000040A ***
STBPCR:             equ    $0000040A                                ;*** STBPCR - Strobe Port Control Register; 0x0000040A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
STBPCR_STB0EN:      equ    0                                         ; Strobe Port 0 Enable
STBPCR_STB1EN:      equ    1                                         ; Strobe Port 1 Enable
STBPCR_STB2EN:      equ    2                                         ; Strobe Port 2 Enable
STBPCR_STB3EN:      equ    3                                         ; Strobe Port 3 Enable
; bit position masks
mSTBPCR_STB0EN:     equ    %00000001
mSTBPCR_STB1EN:     equ    %00000010
mSTBPCR_STB2EN:     equ    %00000100
mSTBPCR_STB3EN:     equ    %00001000


;*** MBDSR - Message Buffer Data Size Register; 0x0000040C ***
MBDSR:              equ    $0000040C                                ;*** MBDSR - Message Buffer Data Size Register; 0x0000040C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBDSR_MBSEG1DS:     equ    0                                         ; Message Buffer Segment 1 Data Size
MBDSR_MBSEG2DS:     equ    8                                         ; Message Buffer Segment 2 Data Size
; bit position masks
mMBDSR_MBSEG1DS:    equ    %01111111
mMBDSR_MBSEG2DS:    equ    %111111100000000


;*** MBSSUTR - Message Buffer Segment Size and Utilization Register; 0x0000040E ***
MBSSUTR:            equ    $0000040E                                ;*** MBSSUTR - Message Buffer Segment Size and Utilization Register; 0x0000040E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBSSUTR_LAST_MB_UTIL: equ    0                                       ; Last Message Buffer Utilized
MBSSUTR_LAST_MB_SEG1: equ    8                                       ; Last Message Buffer In Segment 1
; bit position masks
mMBSSUTR_LAST_MB_UTIL: equ    %00011111
mMBSSUTR_LAST_MB_SEG1: equ    %1111100000000


;*** POCR - Message Buffer Segment Size and Utilization Register; 0x00000414 ***
POCR:               equ    $00000414                                ;*** POCR - Message Buffer Segment Size and Utilization Register; 0x00000414 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
POCR_POCCMD:        equ    0                                         ; Protocol Control Command
POCR_BSY_WMC:       equ    7                                         ; Protocol Control Command Write Busy, Write Mode Command
POCR_ERC_AP:        equ    8                                         ; External Rate Correction Application
POCR_EOC_AP:        equ    10                                        ; External Offset Correction Application
POCR_WME:           equ    15                                        ; Write Mode External Correction
; bit position masks
mPOCR_POCCMD:       equ    %00001111
mPOCR_BSY_WMC:      equ    %10000000
mPOCR_ERC_AP:       equ    %1100000000
mPOCR_EOC_AP:       equ    %110000000000
mPOCR_WME:          equ    %1000000000000000


;*** GIFER - Message Buffer Segment Size and Utilization Register; 0x00000416 ***
GIFER:              equ    $00000416                                ;*** GIFER - Message Buffer Segment Size and Utilization Register; 0x00000416 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
GIFER_TBIE:         equ    0                                         ; Transmit Interrupt Enable
GIFER_RBIE:         equ    1                                         ; Receive Buffer Interrupt Enable
GIFER_FNEAIE:       equ    2                                         ; Receive FIFO channel A Not Empty Interrupt Enable
GIFER_FNEBIE:       equ    3                                         ; Receive FIFO channel B Not Empty Interrupt Enable
GIFER_WUPIE:        equ    4                                         ; Wakeup Interrupt Enable
GIFER_CHIE:         equ    5                                         ; CHI Interrupt Enable
GIFER_PRIE:         equ    6                                         ; Protocol Interrupt Enable
GIFER_MIE:          equ    7                                         ; Module Interrupt Enable
GIFER_TBIF:         equ    8                                         ; Transmit Buffer Interrupt Flag
GIFER_RBIF:         equ    9                                         ; Receive Message Buffer Interrupt Flag
GIFER_FNEAIF:       equ    10                                        ; Receive FIFO channel A Not Empty Interrupt Flag
GIFER_FNEBIF:       equ    11                                        ; Receive FIFO channel B Not Empty Interrupt Flag
GIFER_WUPIF:        equ    12                                        ; Wakeup Interrupt Flag
GIFER_CHIF:         equ    13                                        ; CHI Interrupt Flag
GIFER_PRIF:         equ    14                                        ; Protocol Interrupt Flag
GIFER_MIF:          equ    15                                        ; Module Interrupt Flag
; bit position masks
mGIFER_TBIE:        equ    %00000001
mGIFER_RBIE:        equ    %00000010
mGIFER_FNEAIE:      equ    %00000100
mGIFER_FNEBIE:      equ    %00001000
mGIFER_WUPIE:       equ    %00010000
mGIFER_CHIE:        equ    %00100000
mGIFER_PRIE:        equ    %01000000
mGIFER_MIE:         equ    %10000000
mGIFER_TBIF:        equ    %100000000
mGIFER_RBIF:        equ    %1000000000
mGIFER_FNEAIF:      equ    %10000000000
mGIFER_FNEBIF:      equ    %100000000000
mGIFER_WUPIF:       equ    %1000000000000
mGIFER_CHIF:        equ    %10000000000000
mGIFER_PRIF:        equ    %100000000000000
mGIFER_MIF:         equ    %1000000000000000


;*** PIFR0 - Protocol Interrupt Flag Register; 0x00000418 ***
PIFR0:              equ    $00000418                                ;*** PIFR0 - Protocol Interrupt Flag Register; 0x00000418 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFR0_CYS_IF:       equ    0                                         ; Cycle Start Interrupt Flag
PIFR0_TI1_IF:       equ    1                                         ; Timer 1 Expired Interrupt Flag
PIFR0_TI2_IF:       equ    2                                         ; Timer 2 Expired Interrupt Flag
PIFR0_TBVA_IF:      equ    3                                         ; Transmission across boundary on channel A Interrupt Flag
PIFR0_TBVB_IF:      equ    4                                         ; Transmission across boundary on channel B Interrupt Flag
PIFR0_LTXA_IF:      equ    5                                         ; Violation on Channel A Interrupt Flag
PIFR0_LTXB_IF:      equ    6                                         ; Violation on Channel B Interrupt Flag
PIFR0_MTX_IF:       equ    7                                         ; Media Access Test Symbol Received Interrupt Flag
PIFR0_MXS_IF:       equ    8                                         ; Max Sync Frames Detected Interrupt Flag
PIFR0_CCL_IF:       equ    9                                         ; Clock Correction Limit Reached Interrupt Flag
PIFR0_MOC_IF:       equ    10                                        ; Missing Offset Correction Interrupt Flag
PIFR0_MRC_IF:       equ    11                                        ; Missing Rate Correction Interrupt Flag
PIFR0_CSA_IF:       equ    12                                        ; Cold Start Abort Interrupt Flag
PIFR0_ILCF_IF:      equ    13                                        ; Illegal Protocol Configuration Interrupt Flag
PIFR0_INTL_IF:      equ    14                                        ; Internal Protocol Error Interrupt Flag
PIFR0_FATL_IF:      equ    15                                        ; Fatal Protocol Error Interrupt Flag
; bit position masks
mPIFR0_CYS_IF:      equ    %00000001
mPIFR0_TI1_IF:      equ    %00000010
mPIFR0_TI2_IF:      equ    %00000100
mPIFR0_TBVA_IF:     equ    %00001000
mPIFR0_TBVB_IF:     equ    %00010000
mPIFR0_LTXA_IF:     equ    %00100000
mPIFR0_LTXB_IF:     equ    %01000000
mPIFR0_MTX_IF:      equ    %10000000
mPIFR0_MXS_IF:      equ    %100000000
mPIFR0_CCL_IF:      equ    %1000000000
mPIFR0_MOC_IF:      equ    %10000000000
mPIFR0_MRC_IF:      equ    %100000000000
mPIFR0_CSA_IF:      equ    %1000000000000
mPIFR0_ILCF_IF:     equ    %10000000000000
mPIFR0_INTL_IF:     equ    %100000000000000
mPIFR0_FATL_IF:     equ    %1000000000000000


;*** PIFR1 - Protocol Interrupt Flag Register; 0x0000041A ***
PIFR1:              equ    $0000041A                                ;*** PIFR1 - Protocol Interrupt Flag Register; 0x0000041A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFR1_ODT_IF:       equ    4                                         ; Odd Cycle Table Written Interrupt Flag
PIFR1_EVT_IF:       equ    5                                         ; Even Cycle Table Written Interrupt Flag
PIFR1_SSI0_IF:      equ    8                                         ; Slot Status Counter Incremented Interrupt Flag
PIFR1_SSI1_IF:      equ    9                                         ; Slot Status Counter Incremented Interrupt Flag
PIFR1_SSI2_IF:      equ    10                                        ; Slot Status Counter Incremented Interrupt Flag
PIFR1_SSI3_IF:      equ    11                                        ; Slot Status Counter Incremented Interrupt Flag
PIFR1_PSC_IF:       equ    12                                        ; Protocol State Changed Interrupt Flag
PIFR1_PECF_IF:      equ    13                                        ; Protocol Engine Communication Failure Interrupt Flag
PIFR1_IPC_IF:       equ    14                                        ; Illegal Protocol Control Command Interrupt Flag
PIFR1_EMC_IF:       equ    15                                        ; Error Mode Changed Interrupt Flag
; bit position masks
mPIFR1_ODT_IF:      equ    %00010000
mPIFR1_EVT_IF:      equ    %00100000
mPIFR1_SSI0_IF:     equ    %100000000
mPIFR1_SSI1_IF:     equ    %1000000000
mPIFR1_SSI2_IF:     equ    %10000000000
mPIFR1_SSI3_IF:     equ    %100000000000
mPIFR1_PSC_IF:      equ    %1000000000000
mPIFR1_PECF_IF:     equ    %10000000000000
mPIFR1_IPC_IF:      equ    %100000000000000
mPIFR1_EMC_IF:      equ    %1000000000000000


;*** PIER0 - Protocol Interrupt Enable Register; 0x0000041C ***
PIER0:              equ    $0000041C                                ;*** PIER0 - Protocol Interrupt Enable Register; 0x0000041C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIER0_CYS_IE:       equ    0                                         ; Cycle Start Interrupt Enable
PIER0_TI1_IE:       equ    1                                         ; Timer 1 Expired Interrupt Enable
PIER0_TI2_IE:       equ    2                                         ; Timer 2 Expired Interrupt Enable
PIER0_TBVA_IE:      equ    3                                         ; Transmission across boundary on channel A Interrupt Enable
PIER0_TBVB_IE:      equ    4                                         ; Transmission across boundary on channel B Interrupt Enable
PIER0_LTXA_IE:      equ    5                                         ; Violation on Channel A Interrupt Enable
PIER0_LTXB_IE:      equ    6                                         ; Violation on Channel B Interrupt Enable
PIER0_MTX_IE:       equ    7                                         ; Media Access Test Symbol Received Interrupt Enable
PIER0_MXS_IE:       equ    8                                         ; Max Sync Frames Detected Interrupt Enable
PIER0_CCL_IE:       equ    9                                         ; Clock Correction Limit Reached Interrupt Enable
PIER0_MOC_IE:       equ    10                                        ; Missing Offset Correction Interrupt Enable
PIER0_MRC_IE:       equ    11                                        ; Missing Rate Correction Interrupt Enable
PIER0_CSA_IE:       equ    12                                        ; Cold Start Abort Interrupt Enable
PIER0_ILCF_IE:      equ    13                                        ; Illegal Protocol Configuration Interrupt Enable
PIER0_INTL_IE:      equ    14                                        ; Internal Protocol Error Interrupt Enable
PIER0_FATL_IE:      equ    15                                        ; Fatal Protocol Error Interrupt Enable
; bit position masks
mPIER0_CYS_IE:      equ    %00000001
mPIER0_TI1_IE:      equ    %00000010
mPIER0_TI2_IE:      equ    %00000100
mPIER0_TBVA_IE:     equ    %00001000
mPIER0_TBVB_IE:     equ    %00010000
mPIER0_LTXA_IE:     equ    %00100000
mPIER0_LTXB_IE:     equ    %01000000
mPIER0_MTX_IE:      equ    %10000000
mPIER0_MXS_IE:      equ    %100000000
mPIER0_CCL_IE:      equ    %1000000000
mPIER0_MOC_IE:      equ    %10000000000
mPIER0_MRC_IE:      equ    %100000000000
mPIER0_CSA_IE:      equ    %1000000000000
mPIER0_ILCF_IE:     equ    %10000000000000
mPIER0_INTL_IE:     equ    %100000000000000
mPIER0_FATL_IE:     equ    %1000000000000000


;*** PIER1 - Protocol Interrupt Enable Register; 0x0000041E ***
PIER1:              equ    $0000041E                                ;*** PIER1 - Protocol Interrupt Enable Register; 0x0000041E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIER1_ODT_IE:       equ    4                                         ; Odd Cycle Table Written Interrupt Enable
PIER1_EVT_IE:       equ    5                                         ; Even Cycle Table Written Interrupt Enable
PIER1_SSI0_IE:      equ    8                                         ; Slot Status Counter Incremented Interrupt Enable
PIER1_SSI1_IE:      equ    9                                         ; Slot Status Counter Incremented Interrupt Enable
PIER1_SSI2_IE:      equ    10                                        ; Slot Status Counter Incremented Interrupt Enable
PIER1_SSI3_IE:      equ    11                                        ; Slot Status Counter Incremented Interrupt Enable
PIER1_PSC_IE:       equ    12                                        ; Protocol State Changed Interrupt Enable
PIER1_PECF_IE:      equ    13                                        ; Protocol Engine Communication Failure Interrupt Enable
PIER1_IPC_IE:       equ    14                                        ; Illegal Protocol Control Command Interrupt Enable
PIER1_EMC_IE:       equ    15                                        ; Error Mode Changed Interrupt Enable
; bit position masks
mPIER1_ODT_IE:      equ    %00010000
mPIER1_EVT_IE:      equ    %00100000
mPIER1_SSI0_IE:     equ    %100000000
mPIER1_SSI1_IE:     equ    %1000000000
mPIER1_SSI2_IE:     equ    %10000000000
mPIER1_SSI3_IE:     equ    %100000000000
mPIER1_PSC_IE:      equ    %1000000000000
mPIER1_PECF_IE:     equ    %10000000000000
mPIER1_IPC_IE:      equ    %100000000000000
mPIER1_EMC_IE:      equ    %1000000000000000


;*** CHIERFR - Protocol Interrupt Flag Register; 0x00000420 ***
CHIERFR:            equ    $00000420                                ;*** CHIERFR - Protocol Interrupt Flag Register; 0x00000420 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CHIERFR_ILSA_EF:    equ    0                                         ; Illegal System Memory Access Error Flag
CHIERFR_NMF_EF:     equ    1                                         ; Network Management Frame Error Flag
CHIERFR_NML_EF:     equ    2                                         ; Network Management Length Error Flag
CHIERFR_SPL_EF:     equ    3                                         ; Static Payload Length Error Flag
CHIERFR_DPL_EF:     equ    4                                         ; Dynamic Payload Length Error Flag
CHIERFR_FID_EF:     equ    5                                         ; Frame ID Error Flag
CHIERFR_SBCF_EF:    equ    6                                         ; System Bus Communication Failure Error Flag
CHIERFR_DBL_EF:     equ    7                                         ; Double Transmit Message Buffer Lock Error Flag
CHIERFR_LCK_EF:     equ    8                                         ; Lock Error Flag
CHIERFR_MBU_EF:     equ    9                                         ; Message Buffer Utilization Error Flag
CHIERFR_MBS_EF:     equ    10                                        ; Message Buffer Search Error Flag
CHIERFR_FOVA_EF:    equ    11                                        ; Receive FIFO Overrun Channel A Error Flag
CHIERFR_FOVB_EF:    equ    12                                        ; Receive FIFO Overrun Channel B Error Flag
CHIERFR_PCMI_EF:    equ    13                                        ; Protocol Command Ignored Error Flag
CHIERFR_FRLA_EF:    equ    14                                        ; Frame Lost Channel A Error Flag
CHIERFR_FRLB_EF:    equ    15                                        ; Frame Lost Channel B Error Flag
; bit position masks
mCHIERFR_ILSA_EF:   equ    %00000001
mCHIERFR_NMF_EF:    equ    %00000010
mCHIERFR_NML_EF:    equ    %00000100
mCHIERFR_SPL_EF:    equ    %00001000
mCHIERFR_DPL_EF:    equ    %00010000
mCHIERFR_FID_EF:    equ    %00100000
mCHIERFR_SBCF_EF:   equ    %01000000
mCHIERFR_DBL_EF:    equ    %10000000
mCHIERFR_LCK_EF:    equ    %100000000
mCHIERFR_MBU_EF:    equ    %1000000000
mCHIERFR_MBS_EF:    equ    %10000000000
mCHIERFR_FOVA_EF:   equ    %100000000000
mCHIERFR_FOVB_EF:   equ    %1000000000000
mCHIERFR_PCMI_EF:   equ    %10000000000000
mCHIERFR_FRLA_EF:   equ    %100000000000000
mCHIERFR_FRLB_EF:   equ    %1000000000000000


;*** MBIVEC - Message Buffer Data Size Register; 0x00000422 ***
MBIVEC:             equ    $00000422                                ;*** MBIVEC - Message Buffer Data Size Register; 0x00000422 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIVEC_RBIVEC:      equ    0                                         ; Receive Buffer Interrupt Vector
MBIVEC_TBIVEC:      equ    8                                         ; Transmit Buffer Interrupt Vector
; bit position masks
mMBIVEC_RBIVEC:     equ    %00011111
mMBIVEC_TBIVEC:     equ    %1111100000000


;*** CASERCR - Channel A Status Error Counter Register; 0x00000424 ***
CASERCR:            equ    $00000424                                ;*** CASERCR - Channel A Status Error Counter Register; 0x00000424 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CASERCR_STATUS_ERR_CNT: equ    0                                     ; Channel Status Error Counter
; bit position masks
mCASERCR_STATUS_ERR_CNT: equ    %1111111111111111


;*** CBSERCR - Channel B Status Error Counter Register; 0x00000426 ***
CBSERCR:            equ    $00000426                                ;*** CBSERCR - Channel B Status Error Counter Register; 0x00000426 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CBSERCR_STATUS_ERR_CNT: equ    0                                     ; Channel Status Error Counter
; bit position masks
mCBSERCR_STATUS_ERR_CNT: equ    %1111111111111111


;*** PSR0 - Protocol Status 0 Register; 0x00000428 ***
PSR0:               equ    $00000428                                ;*** PSR0 - Protocol Status 0 Register; 0x00000428 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PSR0_WAKEUPSTATUS:  equ    0                                         ; Last Message Buffer Utilized
PSR0_STARTUPSTATE:  equ    4                                         ; Startup State
PSR0_PROTSTATE:     equ    8                                         ; Protocol State
PSR0_SLOTMODE:      equ    12                                        ; Slot Mode
PSR0_ERRMODE:       equ    14                                        ; Error Mode
; bit position masks
mPSR0_WAKEUPSTATUS: equ    %00000111
mPSR0_STARTUPSTATE: equ    %11110000
mPSR0_PROTSTATE:    equ    %11100000000
mPSR0_SLOTMODE:     equ    %11000000000000
mPSR0_ERRMODE:      equ    %1100000000000000


;*** PSR1 - Protocol Status 1 Register; 0x0000042A ***
PSR1:               equ    $0000042A                                ;*** PSR1 - Protocol Status 1 Register; 0x0000042A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PSR1_APTAC:         equ    0                                         ; Allow Passive to Active Counter
PSR1_FRZ:           equ    5                                         ; Freeze Occurred
PSR1_HHR:           equ    6                                         ; Host Halt Request Pending
PSR1_CPN:           equ    7                                         ; Leading Cold Start Path Noise
PSR1_REMCSAT:       equ    8                                         ; Remaining Coldstart Attempts
PSR1_CSP:           equ    14                                        ; Leading Cold Start Path
PSR1_CSAA:          equ    15                                        ; Cold Start Attempt Aborted Flag
; bit position masks
mPSR1_APTAC:        equ    %00011111
mPSR1_FRZ:          equ    %00100000
mPSR1_HHR:          equ    %01000000
mPSR1_CPN:          equ    %10000000
mPSR1_REMCSAT:      equ    %1111100000000
mPSR1_CSP:          equ    %100000000000000
mPSR1_CSAA:         equ    %1000000000000000


;*** PSR2 - Protocol Status 0 Register; 0x0000042C ***
PSR2:               equ    $0000042C                                ;*** PSR2 - Protocol Status 0 Register; 0x0000042C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PSR2_CLKCORRFAILCNT: equ    0                                        ; Allow Passive to Active Counter
PSR2_MTA:           equ    4                                         ; Media Access Test Symbol MTS Received on Channel A
PSR2_SSEA:          equ    5                                         ; Symbol Window Syntax Error on Channel A
PSR2_SBVA:          equ    6                                         ; Symbol Window Boundary Violation on Channel A
PSR2_STCA:          equ    7                                         ; Symbol Window Transmit Conflict on Channel A
PSR2_NSEA:          equ    8                                         ; NIT Syntax Error on Channel A
PSR2_NBVA:          equ    9                                         ; NIT Boundary Violation on Channel A
PSR2_MTB:           equ    10                                        ; Media Access Test Symbol MTS Received on Channel B
PSR2_SSEB:          equ    11                                        ; Symbol Window Syntax Error on Channel B
PSR2_SBVB:          equ    12                                        ; Symbol Window Boundary Violation on Channel B
PSR2_STCB:          equ    13                                        ; Symbol Window Transmit Conflict on Channel B
PSR2_NSEB:          equ    14                                        ; NIT Syntax Error on Channel B
PSR2_NBVB:          equ    15                                        ; NIT Boundary Violation on Channel B
; bit position masks
mPSR2_CLKCORRFAILCNT: equ    %00001111
mPSR2_MTA:          equ    %00010000
mPSR2_SSEA:         equ    %00100000
mPSR2_SBVA:         equ    %01000000
mPSR2_STCA:         equ    %10000000
mPSR2_NSEA:         equ    %100000000
mPSR2_NBVA:         equ    %1000000000
mPSR2_MTB:          equ    %10000000000
mPSR2_SSEB:         equ    %100000000000
mPSR2_SBVB:         equ    %1000000000000
mPSR2_STCB:         equ    %10000000000000
mPSR2_NSEB:         equ    %100000000000000
mPSR2_NBVB:         equ    %1000000000000000


;*** PSR3 - Protocol Status 3 Register; 0x0000042E ***
PSR3:               equ    $0000042E                                ;*** PSR3 - Protocol Status 3 Register; 0x0000042E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PSR3_AVFA:          equ    0                                         ; Aggregated Valid Frame on Channel A
PSR3_ASEA:          equ    1                                         ; Aggregated Syntax Error on Channel A
PSR3_ACEA:          equ    2                                         ; Aggregated Content Error on Channel A
PSR3_AACA:          equ    3                                         ; Aggregated Additional Communication on Channel A
PSR3_ABVA:          equ    4                                         ; Aggregated Boundary Violation on Channel A
PSR3_WUA:           equ    5                                         ; Wakeup Symbol Received on Channel A
PSR3_AVFB:          equ    8                                         ; Aggregated Valid Frame on Channel B
PSR3_ASEB:          equ    9                                         ; Aggregated Syntax Error on Channel B
PSR3_ACEB:          equ    10                                        ; Aggregated Content Error on Channel B
PSR3_AACB:          equ    11                                        ; Aggregated Additional Communication on Channel B
PSR3_ABVB:          equ    12                                        ; Aggregated Boundary Violation on Channel B
PSR3_WUB:           equ    13                                        ; Wakeup Symbol Received on Channel B
; bit position masks
mPSR3_AVFA:         equ    %00000001
mPSR3_ASEA:         equ    %00000010
mPSR3_ACEA:         equ    %00000100
mPSR3_AACA:         equ    %00001000
mPSR3_ABVA:         equ    %00010000
mPSR3_WUA:          equ    %00100000
mPSR3_AVFB:         equ    %100000000
mPSR3_ASEB:         equ    %1000000000
mPSR3_ACEB:         equ    %10000000000
mPSR3_AACB:         equ    %100000000000
mPSR3_ABVB:         equ    %1000000000000
mPSR3_WUB:          equ    %10000000000000


;*** MTCTR - Macrotick Counter Register; 0x00000430 ***
MTCTR:              equ    $00000430                                ;*** MTCTR - Macrotick Counter Register; 0x00000430 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTCTR_MTCT:         equ    0                                         ; Macrotick Counter
; bit position masks
mMTCTR_MTCT:        equ    %11111111111111


;*** CYCTR - Cycle Counter Register; 0x00000432 ***
CYCTR:              equ    $00000432                                ;*** CYCTR - Cycle Counter Register; 0x00000432 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CYCTR_CYCCNT:       equ    0                                         ; Cycle Counter
; bit position masks
mCYCTR_CYCCNT:      equ    %00111111


;*** SLTCTAR - Slot Counter Channel A Register; 0x00000434 ***
SLTCTAR:            equ    $00000434                                ;*** SLTCTAR - Slot Counter Channel A Register; 0x00000434 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SLTCTAR_SLOTCNTA:   equ    0                                         ; Slot Counter Value for Channel A
; bit position masks
mSLTCTAR_SLOTCNTA:  equ    %11111111111


;*** SLTCTBR - Slot Counter Channel B Register; 0x00000436 ***
SLTCTBR:            equ    $00000436                                ;*** SLTCTBR - Slot Counter Channel B Register; 0x00000436 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SLTCTBR_SLOTCNTB:   equ    0                                         ; Slot Counter Value for Channel B
; bit position masks
mSLTCTBR_SLOTCNTB:  equ    %11111111111


;*** RTCORVR - Rate Correction Value Register; 0x00000438 ***
RTCORVR:            equ    $00000438                                ;*** RTCORVR - Rate Correction Value Register; 0x00000438 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTCORVR_RATECORR:   equ    0                                         ; Rate Correction Value
; bit position masks
mRTCORVR_RATECORR:  equ    %1111111111111111


;*** OFCORVR - Offset Correction Value Register; 0x0000043A ***
OFCORVR:            equ    $0000043A                                ;*** OFCORVR - Offset Correction Value Register; 0x0000043A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OFCORVR_OFFSETCORR: equ    0                                         ; Offset Correction Value
; bit position masks
mOFCORVR_OFFSETCORR: equ    %1111111111111111


;*** CIFRR - Combined Interrupt Flag Register; 0x0000043C ***
CIFRR:              equ    $0000043C                                ;*** CIFRR - Combined Interrupt Flag Register; 0x0000043C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CIFRR_TBIF:         equ    0                                         ; Transmit Message Buffer Interrupt Flag
CIFRR_RBIF:         equ    1                                         ; Receive Message Buffer Interrupt Flag
CIFRR_FNEAIF:       equ    2                                         ; Receive FIFO channel A Not Empty Interrupt Flag
CIFRR_FNEBIF:       equ    3                                         ; Receive FIFO channel B Not Empty Interrupt Flag
CIFRR_WUPIF:        equ    4                                         ; Wakeup Interrupt Flag
CIFRR_CHIF:         equ    5                                         ; CHI Interrupt Flag
CIFRR_PRIF:         equ    6                                         ; Protocol Interrupt Flag
CIFRR_MIF:          equ    7                                         ; Module Interrupt Flag
; bit position masks
mCIFRR_TBIF:        equ    %00000001
mCIFRR_RBIF:        equ    %00000010
mCIFRR_FNEAIF:      equ    %00000100
mCIFRR_FNEBIF:      equ    %00001000
mCIFRR_WUPIF:       equ    %00010000
mCIFRR_CHIF:        equ    %00100000
mCIFRR_PRIF:        equ    %01000000
mCIFRR_MIF:         equ    %10000000


;*** SYMATOR - System Memory Access Time-Out Register Register; 0x0000043E ***
SYMATOR:            equ    $0000043E                                ;*** SYMATOR - System Memory Access Time-Out Register Register; 0x0000043E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYMATOR_TIMEOUT:    equ    0                                         ; Time-Out
; bit position masks
mSYMATOR_TIMEOUT:   equ    %00011111


;*** SFCNTR - Sync Frame Counter Register; 0x00000440 ***
SFCNTR:             equ    $00000440                                ;*** SFCNTR - Sync Frame Counter Register; 0x00000440 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SFCNTR_SFODA:       equ    0                                         ; Sync Frames Channel A
SFCNTR_SFODB:       equ    4                                         ; Sync Frames Channel B
SFCNTR_SFEVA:       equ    8                                         ; Sync Frames Channel A
SFCNTR_SFEVB:       equ    12                                        ; Sync Frames Channel B
; bit position masks
mSFCNTR_SFODA:      equ    %00001111
mSFCNTR_SFODB:      equ    %11110000
mSFCNTR_SFEVA:      equ    %111100000000
mSFCNTR_SFEVB:      equ    %1111000000000000


;*** SFTOR - Sync Frame Table Offset Register; 0x00000442 ***
SFTOR:              equ    $00000442                                ;*** SFTOR - Sync Frame Table Offset Register; 0x00000442 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SFTOR_SFT_OFFSET1:  equ    1                                         ; Sync Frame Table Offset, bit 0
SFTOR_SFT_OFFSET2:  equ    2                                         ; Sync Frame Table Offset, bit 1
SFTOR_SFT_OFFSET3:  equ    3                                         ; Sync Frame Table Offset, bit 2
SFTOR_SFT_OFFSET4:  equ    4                                         ; Sync Frame Table Offset, bit 3
SFTOR_SFT_OFFSET5:  equ    5                                         ; Sync Frame Table Offset, bit 4
SFTOR_SFT_OFFSET6:  equ    6                                         ; Sync Frame Table Offset, bit 5
SFTOR_SFT_OFFSET7:  equ    7                                         ; Sync Frame Table Offset, bit 6
SFTOR_SFT_OFFSET8:  equ    8                                         ; Sync Frame Table Offset, bit 7
SFTOR_SFT_OFFSET9:  equ    9                                         ; Sync Frame Table Offset, bit 8
SFTOR_SFT_OFFSET10: equ    10                                        ; Sync Frame Table Offset, bit 9
SFTOR_SFT_OFFSET11: equ    11                                        ; Sync Frame Table Offset, bit 10
SFTOR_SFT_OFFSET12: equ    12                                        ; Sync Frame Table Offset, bit 11
SFTOR_SFT_OFFSET13: equ    13                                        ; Sync Frame Table Offset, bit 12
SFTOR_SFT_OFFSET14: equ    14                                        ; Sync Frame Table Offset, bit 13
SFTOR_SFT_OFFSET15: equ    15                                        ; Sync Frame Table Offset, bit 14
; bit position masks
mSFTOR_SFT_OFFSET1: equ    %00000010
mSFTOR_SFT_OFFSET2: equ    %00000100
mSFTOR_SFT_OFFSET3: equ    %00001000
mSFTOR_SFT_OFFSET4: equ    %00010000
mSFTOR_SFT_OFFSET5: equ    %00100000
mSFTOR_SFT_OFFSET6: equ    %01000000
mSFTOR_SFT_OFFSET7: equ    %10000000
mSFTOR_SFT_OFFSET8: equ    %100000000
mSFTOR_SFT_OFFSET9: equ    %1000000000
mSFTOR_SFT_OFFSET10: equ    %10000000000
mSFTOR_SFT_OFFSET11: equ    %100000000000
mSFTOR_SFT_OFFSET12: equ    %1000000000000
mSFTOR_SFT_OFFSET13: equ    %10000000000000
mSFTOR_SFT_OFFSET14: equ    %100000000000000
mSFTOR_SFT_OFFSET15: equ    %1000000000000000


;*** SFTCCSR - Sync Frame Table Configuration, Control, Status Register; 0x00000444 ***
SFTCCSR:            equ    $00000444                                ;*** SFTCCSR - Sync Frame Table Configuration, Control, Status Register; 0x00000444 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SFTCCSR_SIDEN:      equ    0                                         ; Sync Frame ID Table Enable
SFTCCSR_SDVEN:      equ    1                                         ; Sync Frame Deviation Table Enable
SFTCCSR_OPT:        equ    2                                         ; One Pair Trigger
SFTCCSR_OVAL:       equ    4                                         ; Odd Cycle Tables Valid
SFTCCSR_EVAL:       equ    5                                         ; Even Cycle Tables Valid
SFTCCSR_OLKS:       equ    6                                         ; Odd Cycle Tables Lock Status
SFTCCSR_ELKS:       equ    7                                         ; Even Cycle Tables Lock Status
SFTCCSR_CYCNUM:     equ    8                                         ; Cycle Number
SFTCCSR_OLKT:       equ    14                                        ; Odd Cycle Tables Lock/Unlock Trigger
SFTCCSR_ELKT:       equ    15                                        ; Even Cycle Tables Lock/Unlock Trigger
; bit position masks
mSFTCCSR_SIDEN:     equ    %00000001
mSFTCCSR_SDVEN:     equ    %00000010
mSFTCCSR_OPT:       equ    %00000100
mSFTCCSR_OVAL:      equ    %00010000
mSFTCCSR_EVAL:      equ    %00100000
mSFTCCSR_OLKS:      equ    %01000000
mSFTCCSR_ELKS:      equ    %10000000
mSFTCCSR_CYCNUM:    equ    %11111100000000
mSFTCCSR_OLKT:      equ    %100000000000000
mSFTCCSR_ELKT:      equ    %1000000000000000


;*** SFIDRFR - Sync Frame ID Rejection Filter Register; 0x00000446 ***
SFIDRFR:            equ    $00000446                                ;*** SFIDRFR - Sync Frame ID Rejection Filter Register; 0x00000446 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SFIDRFR_SYNFRID:    equ    0                                         ; Sync Frame ID Rejection Filter
; bit position masks
mSFIDRFR_SYNFRID:   equ    %1111111111


;*** SFIDAFVR - Sync Frame ID Acceptance Filter Value Register; 0x00000448 ***
SFIDAFVR:           equ    $00000448                                ;*** SFIDAFVR - Sync Frame ID Acceptance Filter Value Register; 0x00000448 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SFIDAFVR_FVAL:      equ    0                                         ; Filter Value
; bit position masks
mSFIDAFVR_FVAL:     equ    %1111111111


;*** SFIDAFMR - Sync Frame ID Acceptance Filter Mask Register; 0x0000044A ***
SFIDAFMR:           equ    $0000044A                                ;*** SFIDAFMR - Sync Frame ID Acceptance Filter Mask Register; 0x0000044A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SFIDAFMR_FMSK:      equ    0                                         ; Filter Mask
; bit position masks
mSFIDAFMR_FMSK:     equ    %1111111111


;*** NMVR0 - Network Management Vector Register; 0x0000044C ***
NMVR0:              equ    $0000044C                                ;*** NMVR0 - Network Management Vector Register; 0x0000044C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NMVR0_NMVP:         equ    0                                         ; Network Management Vector Part
; bit position masks
mNMVR0_NMVP:        equ    %1111111111111111


;*** NMVR1 - Network Management Vector Register; 0x0000044E ***
NMVR1:              equ    $0000044E                                ;*** NMVR1 - Network Management Vector Register; 0x0000044E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NMVR1_NMVP:         equ    0                                         ; Network Management Vector Part
; bit position masks
mNMVR1_NMVP:        equ    %1111111111111111


;*** NMVR2 - Network Management Vector Register; 0x00000450 ***
NMVR2:              equ    $00000450                                ;*** NMVR2 - Network Management Vector Register; 0x00000450 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NMVR2_NMVP:         equ    0                                         ; Network Management Vector Part
; bit position masks
mNMVR2_NMVP:        equ    %1111111111111111


;*** NMVR3 - Network Management Vector Register; 0x00000452 ***
NMVR3:              equ    $00000452                                ;*** NMVR3 - Network Management Vector Register; 0x00000452 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NMVR3_NMVP:         equ    0                                         ; Network Management Vector Part
; bit position masks
mNMVR3_NMVP:        equ    %1111111111111111


;*** NMVR4 - Network Management Vector Register; 0x00000454 ***
NMVR4:              equ    $00000454                                ;*** NMVR4 - Network Management Vector Register; 0x00000454 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NMVR4_NMVP:         equ    0                                         ; Network Management Vector Part
; bit position masks
mNMVR4_NMVP:        equ    %1111111111111111


;*** NMVR5 - Network Management Vector Register; 0x00000456 ***
NMVR5:              equ    $00000456                                ;*** NMVR5 - Network Management Vector Register; 0x00000456 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NMVR5_NMVP:         equ    0                                         ; Network Management Vector Part
; bit position masks
mNMVR5_NMVP:        equ    %1111111111111111


;*** NMVLR - Network Management Vector Length Register; 0x00000458 ***
NMVLR:              equ    $00000458                                ;*** NMVLR - Network Management Vector Length Register; 0x00000458 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NMVLR_NMVL:         equ    0                                         ; Network Management Vector Length
; bit position masks
mNMVLR_NMVL:        equ    %00001111


;*** TICCR - Timer Configuration and Control Register; 0x0000045A ***
TICCR:              equ    $0000045A                                ;*** TICCR - Timer Configuration and Control Register; 0x0000045A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TICCR_T1ST:         equ    0                                         ; Timer T1 State
TICCR_T1TR:         equ    1                                         ; Timer T1 Trigger
TICCR_T1SP:         equ    2                                         ; Timer T1 Stop
TICCR_T1_REP:       equ    4                                         ; Timer T1 Repetitive Mode
TICCR_T2ST:         equ    8                                         ; Timer T2 State
TICCR_T2TR:         equ    9                                         ; Timer T2 Trigger
TICCR_T2SP:         equ    10                                        ; Timer T2 Stop
TICCR_T2_REP:       equ    12                                        ; Timer T2 Repetitive Mode
TICCR_T2_CFG:       equ    13                                        ; Timer T2 Configuration
; bit position masks
mTICCR_T1ST:        equ    %00000001
mTICCR_T1TR:        equ    %00000010
mTICCR_T1SP:        equ    %00000100
mTICCR_T1_REP:      equ    %00010000
mTICCR_T2ST:        equ    %100000000
mTICCR_T2TR:        equ    %1000000000
mTICCR_T2SP:        equ    %10000000000
mTICCR_T2_REP:      equ    %1000000000000
mTICCR_T2_CFG:      equ    %10000000000000


;*** TI1CYSR - Timer 1 Cycle Set Register; 0x0000045C ***
TI1CYSR:            equ    $0000045C                                ;*** TI1CYSR - Timer 1 Cycle Set Register; 0x0000045C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TI1CYSR_T1_CYC_MSK: equ    0                                         ; Timer T1 Cycle Filter Mask
TI1CYSR_T1_CYC_VAL: equ    8                                         ; Timer T1 Cycle Filter Value
; bit position masks
mTI1CYSR_T1_CYC_MSK: equ    %00111111
mTI1CYSR_T1_CYC_VAL: equ    %11111100000000


;*** TI1MTOR - Timer 1 Macrotick Offset Register; 0x0000045E ***
TI1MTOR:            equ    $0000045E                                ;*** TI1MTOR - Timer 1 Macrotick Offset Register; 0x0000045E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TI1MTOR_T1_MTOFFSET: equ    0                                        ; Timer 1 Macrotick Offset
; bit position masks
mTI1MTOR_T1_MTOFFSET: equ    %11111111111111


;*** TI2CR0_MTCNT - Timer 2 Configuration Register 0; 0x00000460 ***
TI2CR0_MTCNT:       equ    $00000460                                ;*** TI2CR0_MTCNT - Timer 2 Configuration Register 0; 0x00000460 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TI2CR0_MTCNT_T2_MTCNT: equ    0                                      ; Timer T2 Macrotick High Word
; bit position masks
mTI2CR0_MTCNT_T2_MTCNT: equ    %1111111111111111


;*** TI2CR0_CYC - Timer 2 Configuration Register 0; 0x00000460 ***
TI2CR0_CYC:         equ    $00000460                                ;*** TI2CR0_CYC - Timer 2 Configuration Register 0; 0x00000460 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TI2CR0_CYC_T2_CYC_MSK: equ    0                                      ; Timer T2 Cycle Filter Mask
TI2CR0_CYC_T2_CYC_VAL: equ    8                                      ; Timer T2 Cycle Filter Value
; bit position masks
mTI2CR0_CYC_T2_CYC_MSK: equ    %00111111
mTI2CR0_CYC_T2_CYC_VAL: equ    %11111100000000


;*** TI2CR1_MTOFFSET - Timer 2 Configuration Register 1; 0x00000462 ***
TI2CR1_MTOFFSET:    equ    $00000462                                ;*** TI2CR1_MTOFFSET - Timer 2 Configuration Register 1; 0x00000462 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TI2CR1_MTOFFSET_T2_MTOFFSET: equ    0                                ; Timer T2 Macrotick Offset
; bit position masks
mTI2CR1_MTOFFSET_T2_MTOFFSET: equ    %11111111111111


;*** TI2CR1_MTCNT - Timer 2 Configuration Register 1; 0x00000462 ***
TI2CR1_MTCNT:       equ    $00000462                                ;*** TI2CR1_MTCNT - Timer 2 Configuration Register 1; 0x00000462 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TI2CR1_MTCNT_T2_MTCNT: equ    0                                      ; Timer T2 Macrotick High Word
; bit position masks
mTI2CR1_MTCNT_T2_MTCNT: equ    %1111111111111111


;*** SSSR - Slot Status Selection Register; 0x00000464 ***
SSSR:               equ    $00000464                                ;*** SSSR - Slot Status Selection Register; 0x00000464 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSSR_SLOTNUMBER:    equ    0                                         ; Slot Number
SSSR_SEL:           equ    12                                        ; Selector
SSSR_WMD:           equ    15                                        ; Write Mode
; bit position masks
mSSSR_SLOTNUMBER:   equ    %11111111111
mSSSR_SEL:          equ    %11000000000000
mSSSR_WMD:          equ    %1000000000000000


;*** SSCCR - Slot Status Counter Condition Register; 0x00000466 ***
SSCCR:              equ    $00000466                                ;*** SSCCR - Slot Status Counter Condition Register; 0x00000466 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSCCR_STATUSMASK:   equ    0                                         ; Slot Status Mask
SSCCR_SUF:          equ    4                                         ; Startup Frame Restriction
SSCCR_NUF:          equ    5                                         ; Null Frame Restriction
SSCCR_SYF:          equ    6                                         ; Sync Frame Restriction
SSCCR_VFR:          equ    7                                         ; Valid Frame Restriction
SSCCR_MCY:          equ    8                                         ; Multi Cycle Selection
SSCCR_CNTCFG:       equ    9                                         ; Counter Configuration
SSCCR_SEL:          equ    12                                        ; Selector
SSCCR_WMD:          equ    15                                        ; Write Mode
; bit position masks
mSSCCR_STATUSMASK:  equ    %00001111
mSSCCR_SUF:         equ    %00010000
mSSCCR_NUF:         equ    %00100000
mSSCCR_SYF:         equ    %01000000
mSSCCR_VFR:         equ    %10000000
mSSCCR_MCY:         equ    %100000000
mSSCCR_CNTCFG:      equ    %11000000000
mSSCCR_SEL:         equ    %11000000000000
mSSCCR_WMD:         equ    %1000000000000000


;*** SSR0 - Slot Status 0 Register; 0x00000468 ***
SSR0:               equ    $00000468                                ;*** SSR0 - Slot Status 0 Register; 0x00000468 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSR0_TCA:           equ    0                                         ; Transmission Conflict on Channel A
SSR0_BVA:           equ    1                                         ; Boundary Violation on Channel A
SSR0_CEA:           equ    2                                         ; Content Error on Channel A
SSR0_SEA:           equ    3                                         ; Syntax Error on Channel A
SSR0_SUA:           equ    4                                         ; Startup Frame Indicator Channel A
SSR0_NFA:           equ    5                                         ; Null Frame Indicator Channel A
SSR0_SYA:           equ    6                                         ; Sync Frame Indicator Channel A
SSR0_VFA:           equ    7                                         ; Valid Frame on Channel A
SSR0_TCB:           equ    8                                         ; Transmission Conflict on Channel B
SSR0_BVB:           equ    9                                         ; Boundary Violation on Channel B
SSR0_CEB:           equ    10                                        ; Content Error on Channel B
SSR0_SEB:           equ    11                                        ; Syntax Error on Channel B
SSR0_SUB:           equ    12                                        ; Startup Frame Indicator Channel B
SSR0_NFB:           equ    13                                        ; Null Frame Indicator Channel B
SSR0_SYB:           equ    14                                        ; Sync Frame Indicator Channel B
SSR0_VFB:           equ    15                                        ; Valid Frame on Channel B
; bit position masks
mSSR0_TCA:          equ    %00000001
mSSR0_BVA:          equ    %00000010
mSSR0_CEA:          equ    %00000100
mSSR0_SEA:          equ    %00001000
mSSR0_SUA:          equ    %00010000
mSSR0_NFA:          equ    %00100000
mSSR0_SYA:          equ    %01000000
mSSR0_VFA:          equ    %10000000
mSSR0_TCB:          equ    %100000000
mSSR0_BVB:          equ    %1000000000
mSSR0_CEB:          equ    %10000000000
mSSR0_SEB:          equ    %100000000000
mSSR0_SUB:          equ    %1000000000000
mSSR0_NFB:          equ    %10000000000000
mSSR0_SYB:          equ    %100000000000000
mSSR0_VFB:          equ    %1000000000000000


;*** SSR1 - Slot Status 1 Register; 0x0000046A ***
SSR1:               equ    $0000046A                                ;*** SSR1 - Slot Status 1 Register; 0x0000046A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSR1_TCA:           equ    0                                         ; Transmission Conflict on Channel A
SSR1_BVA:           equ    1                                         ; Boundary Violation on Channel A
SSR1_CEA:           equ    2                                         ; Content Error on Channel A
SSR1_SEA:           equ    3                                         ; Syntax Error on Channel A
SSR1_SUA:           equ    4                                         ; Startup Frame Indicator Channel A
SSR1_NFA:           equ    5                                         ; Null Frame Indicator Channel A
SSR1_SYA:           equ    6                                         ; Sync Frame Indicator Channel A
SSR1_VFA:           equ    7                                         ; Valid Frame on Channel A
SSR1_TCB:           equ    8                                         ; Transmission Conflict on Channel B
SSR1_BVB:           equ    9                                         ; Boundary Violation on Channel B
SSR1_CEB:           equ    10                                        ; Content Error on Channel B
SSR1_SEB:           equ    11                                        ; Syntax Error on Channel B
SSR1_SUB:           equ    12                                        ; Startup Frame Indicator Channel B
SSR1_NFB:           equ    13                                        ; Null Frame Indicator Channel B
SSR1_SYB:           equ    14                                        ; Sync Frame Indicator Channel B
SSR1_VFB:           equ    15                                        ; Valid Frame on Channel B
; bit position masks
mSSR1_TCA:          equ    %00000001
mSSR1_BVA:          equ    %00000010
mSSR1_CEA:          equ    %00000100
mSSR1_SEA:          equ    %00001000
mSSR1_SUA:          equ    %00010000
mSSR1_NFA:          equ    %00100000
mSSR1_SYA:          equ    %01000000
mSSR1_VFA:          equ    %10000000
mSSR1_TCB:          equ    %100000000
mSSR1_BVB:          equ    %1000000000
mSSR1_CEB:          equ    %10000000000
mSSR1_SEB:          equ    %100000000000
mSSR1_SUB:          equ    %1000000000000
mSSR1_NFB:          equ    %10000000000000
mSSR1_SYB:          equ    %100000000000000
mSSR1_VFB:          equ    %1000000000000000


;*** SSR2 - Slot Status 2 Register; 0x0000046C ***
SSR2:               equ    $0000046C                                ;*** SSR2 - Slot Status 2 Register; 0x0000046C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSR2_TCA:           equ    0                                         ; Transmission Conflict on Channel A
SSR2_BVA:           equ    1                                         ; Boundary Violation on Channel A
SSR2_CEA:           equ    2                                         ; Content Error on Channel A
SSR2_SEA:           equ    3                                         ; Syntax Error on Channel A
SSR2_SUA:           equ    4                                         ; Startup Frame Indicator Channel A
SSR2_NFA:           equ    5                                         ; Null Frame Indicator Channel A
SSR2_SYA:           equ    6                                         ; Sync Frame Indicator Channel A
SSR2_VFA:           equ    7                                         ; Valid Frame on Channel A
SSR2_TCB:           equ    8                                         ; Transmission Conflict on Channel B
SSR2_BVB:           equ    9                                         ; Boundary Violation on Channel B
SSR2_CEB:           equ    10                                        ; Content Error on Channel B
SSR2_SEB:           equ    11                                        ; Syntax Error on Channel B
SSR2_SUB:           equ    12                                        ; Startup Frame Indicator Channel B
SSR2_NFB:           equ    13                                        ; Null Frame Indicator Channel B
SSR2_SYB:           equ    14                                        ; Sync Frame Indicator Channel B
SSR2_VFB:           equ    15                                        ; Valid Frame on Channel B
; bit position masks
mSSR2_TCA:          equ    %00000001
mSSR2_BVA:          equ    %00000010
mSSR2_CEA:          equ    %00000100
mSSR2_SEA:          equ    %00001000
mSSR2_SUA:          equ    %00010000
mSSR2_NFA:          equ    %00100000
mSSR2_SYA:          equ    %01000000
mSSR2_VFA:          equ    %10000000
mSSR2_TCB:          equ    %100000000
mSSR2_BVB:          equ    %1000000000
mSSR2_CEB:          equ    %10000000000
mSSR2_SEB:          equ    %100000000000
mSSR2_SUB:          equ    %1000000000000
mSSR2_NFB:          equ    %10000000000000
mSSR2_SYB:          equ    %100000000000000
mSSR2_VFB:          equ    %1000000000000000


;*** SSR3 - Slot Status 3 Register; 0x0000046E ***
SSR3:               equ    $0000046E                                ;*** SSR3 - Slot Status 3 Register; 0x0000046E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSR3_TCA:           equ    0                                         ; Transmission Conflict on Channel A
SSR3_BVA:           equ    1                                         ; Boundary Violation on Channel A
SSR3_CEA:           equ    2                                         ; Content Error on Channel A
SSR3_SEA:           equ    3                                         ; Syntax Error on Channel A
SSR3_SUA:           equ    4                                         ; Startup Frame Indicator Channel A
SSR3_NFA:           equ    5                                         ; Null Frame Indicator Channel A
SSR3_SYA:           equ    6                                         ; Sync Frame Indicator Channel A
SSR3_VFA:           equ    7                                         ; Valid Frame on Channel A
SSR3_TCB:           equ    8                                         ; Transmission Conflict on Channel B
SSR3_BVB:           equ    9                                         ; Boundary Violation on Channel B
SSR3_CEB:           equ    10                                        ; Content Error on Channel B
SSR3_SEB:           equ    11                                        ; Syntax Error on Channel B
SSR3_SUB:           equ    12                                        ; Startup Frame Indicator Channel B
SSR3_NFB:           equ    13                                        ; Null Frame Indicator Channel B
SSR3_SYB:           equ    14                                        ; Sync Frame Indicator Channel B
SSR3_VFB:           equ    15                                        ; Valid Frame on Channel B
; bit position masks
mSSR3_TCA:          equ    %00000001
mSSR3_BVA:          equ    %00000010
mSSR3_CEA:          equ    %00000100
mSSR3_SEA:          equ    %00001000
mSSR3_SUA:          equ    %00010000
mSSR3_NFA:          equ    %00100000
mSSR3_SYA:          equ    %01000000
mSSR3_VFA:          equ    %10000000
mSSR3_TCB:          equ    %100000000
mSSR3_BVB:          equ    %1000000000
mSSR3_CEB:          equ    %10000000000
mSSR3_SEB:          equ    %100000000000
mSSR3_SUB:          equ    %1000000000000
mSSR3_NFB:          equ    %10000000000000
mSSR3_SYB:          equ    %100000000000000
mSSR3_VFB:          equ    %1000000000000000


;*** SSR4 - Slot Status 4 Register; 0x00000470 ***
SSR4:               equ    $00000470                                ;*** SSR4 - Slot Status 4 Register; 0x00000470 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSR4_TCA:           equ    0                                         ; Transmission Conflict on Channel A
SSR4_BVA:           equ    1                                         ; Boundary Violation on Channel A
SSR4_CEA:           equ    2                                         ; Content Error on Channel A
SSR4_SEA:           equ    3                                         ; Syntax Error on Channel A
SSR4_SUA:           equ    4                                         ; Startup Frame Indicator Channel A
SSR4_NFA:           equ    5                                         ; Null Frame Indicator Channel A
SSR4_SYA:           equ    6                                         ; Sync Frame Indicator Channel A
SSR4_VFA:           equ    7                                         ; Valid Frame on Channel A
SSR4_TCB:           equ    8                                         ; Transmission Conflict on Channel B
SSR4_BVB:           equ    9                                         ; Boundary Violation on Channel B
SSR4_CEB:           equ    10                                        ; Content Error on Channel B
SSR4_SEB:           equ    11                                        ; Syntax Error on Channel B
SSR4_SUB:           equ    12                                        ; Startup Frame Indicator Channel B
SSR4_NFB:           equ    13                                        ; Null Frame Indicator Channel B
SSR4_SYB:           equ    14                                        ; Sync Frame Indicator Channel B
SSR4_VFB:           equ    15                                        ; Valid Frame on Channel B
; bit position masks
mSSR4_TCA:          equ    %00000001
mSSR4_BVA:          equ    %00000010
mSSR4_CEA:          equ    %00000100
mSSR4_SEA:          equ    %00001000
mSSR4_SUA:          equ    %00010000
mSSR4_NFA:          equ    %00100000
mSSR4_SYA:          equ    %01000000
mSSR4_VFA:          equ    %10000000
mSSR4_TCB:          equ    %100000000
mSSR4_BVB:          equ    %1000000000
mSSR4_CEB:          equ    %10000000000
mSSR4_SEB:          equ    %100000000000
mSSR4_SUB:          equ    %1000000000000
mSSR4_NFB:          equ    %10000000000000
mSSR4_SYB:          equ    %100000000000000
mSSR4_VFB:          equ    %1000000000000000


;*** SSR5 - Slot Status 5 Register; 0x00000472 ***
SSR5:               equ    $00000472                                ;*** SSR5 - Slot Status 5 Register; 0x00000472 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSR5_TCA:           equ    0                                         ; Transmission Conflict on Channel A
SSR5_BVA:           equ    1                                         ; Boundary Violation on Channel A
SSR5_CEA:           equ    2                                         ; Content Error on Channel A
SSR5_SEA:           equ    3                                         ; Syntax Error on Channel A
SSR5_SUA:           equ    4                                         ; Startup Frame Indicator Channel A
SSR5_NFA:           equ    5                                         ; Null Frame Indicator Channel A
SSR5_SYA:           equ    6                                         ; Sync Frame Indicator Channel A
SSR5_VFA:           equ    7                                         ; Valid Frame on Channel A
SSR5_TCB:           equ    8                                         ; Transmission Conflict on Channel B
SSR5_BVB:           equ    9                                         ; Boundary Violation on Channel B
SSR5_CEB:           equ    10                                        ; Content Error on Channel B
SSR5_SEB:           equ    11                                        ; Syntax Error on Channel B
SSR5_SUB:           equ    12                                        ; Startup Frame Indicator Channel B
SSR5_NFB:           equ    13                                        ; Null Frame Indicator Channel B
SSR5_SYB:           equ    14                                        ; Sync Frame Indicator Channel B
SSR5_VFB:           equ    15                                        ; Valid Frame on Channel B
; bit position masks
mSSR5_TCA:          equ    %00000001
mSSR5_BVA:          equ    %00000010
mSSR5_CEA:          equ    %00000100
mSSR5_SEA:          equ    %00001000
mSSR5_SUA:          equ    %00010000
mSSR5_NFA:          equ    %00100000
mSSR5_SYA:          equ    %01000000
mSSR5_VFA:          equ    %10000000
mSSR5_TCB:          equ    %100000000
mSSR5_BVB:          equ    %1000000000
mSSR5_CEB:          equ    %10000000000
mSSR5_SEB:          equ    %100000000000
mSSR5_SUB:          equ    %1000000000000
mSSR5_NFB:          equ    %10000000000000
mSSR5_SYB:          equ    %100000000000000
mSSR5_VFB:          equ    %1000000000000000


;*** SSR6 - Slot Status 6 Register; 0x00000474 ***
SSR6:               equ    $00000474                                ;*** SSR6 - Slot Status 6 Register; 0x00000474 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSR6_TCA:           equ    0                                         ; Transmission Conflict on Channel A
SSR6_BVA:           equ    1                                         ; Boundary Violation on Channel A
SSR6_CEA:           equ    2                                         ; Content Error on Channel A
SSR6_SEA:           equ    3                                         ; Syntax Error on Channel A
SSR6_SUA:           equ    4                                         ; Startup Frame Indicator Channel A
SSR6_NFA:           equ    5                                         ; Null Frame Indicator Channel A
SSR6_SYA:           equ    6                                         ; Sync Frame Indicator Channel A
SSR6_VFA:           equ    7                                         ; Valid Frame on Channel A
SSR6_TCB:           equ    8                                         ; Transmission Conflict on Channel B
SSR6_BVB:           equ    9                                         ; Boundary Violation on Channel B
SSR6_CEB:           equ    10                                        ; Content Error on Channel B
SSR6_SEB:           equ    11                                        ; Syntax Error on Channel B
SSR6_SUB:           equ    12                                        ; Startup Frame Indicator Channel B
SSR6_NFB:           equ    13                                        ; Null Frame Indicator Channel B
SSR6_SYB:           equ    14                                        ; Sync Frame Indicator Channel B
SSR6_VFB:           equ    15                                        ; Valid Frame on Channel B
; bit position masks
mSSR6_TCA:          equ    %00000001
mSSR6_BVA:          equ    %00000010
mSSR6_CEA:          equ    %00000100
mSSR6_SEA:          equ    %00001000
mSSR6_SUA:          equ    %00010000
mSSR6_NFA:          equ    %00100000
mSSR6_SYA:          equ    %01000000
mSSR6_VFA:          equ    %10000000
mSSR6_TCB:          equ    %100000000
mSSR6_BVB:          equ    %1000000000
mSSR6_CEB:          equ    %10000000000
mSSR6_SEB:          equ    %100000000000
mSSR6_SUB:          equ    %1000000000000
mSSR6_NFB:          equ    %10000000000000
mSSR6_SYB:          equ    %100000000000000
mSSR6_VFB:          equ    %1000000000000000


;*** SSR7 - Slot Status 7 Register; 0x00000476 ***
SSR7:               equ    $00000476                                ;*** SSR7 - Slot Status 7 Register; 0x00000476 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSR7_TCA:           equ    0                                         ; Transmission Conflict on Channel A
SSR7_BVA:           equ    1                                         ; Boundary Violation on Channel A
SSR7_CEA:           equ    2                                         ; Content Error on Channel A
SSR7_SEA:           equ    3                                         ; Syntax Error on Channel A
SSR7_SUA:           equ    4                                         ; Startup Frame Indicator Channel A
SSR7_NFA:           equ    5                                         ; Null Frame Indicator Channel A
SSR7_SYA:           equ    6                                         ; Sync Frame Indicator Channel A
SSR7_VFA:           equ    7                                         ; Valid Frame on Channel A
SSR7_TCB:           equ    8                                         ; Transmission Conflict on Channel B
SSR7_BVB:           equ    9                                         ; Boundary Violation on Channel B
SSR7_CEB:           equ    10                                        ; Content Error on Channel B
SSR7_SEB:           equ    11                                        ; Syntax Error on Channel B
SSR7_SUB:           equ    12                                        ; Startup Frame Indicator Channel B
SSR7_NFB:           equ    13                                        ; Null Frame Indicator Channel B
SSR7_SYB:           equ    14                                        ; Sync Frame Indicator Channel B
SSR7_VFB:           equ    15                                        ; Valid Frame on Channel B
; bit position masks
mSSR7_TCA:          equ    %00000001
mSSR7_BVA:          equ    %00000010
mSSR7_CEA:          equ    %00000100
mSSR7_SEA:          equ    %00001000
mSSR7_SUA:          equ    %00010000
mSSR7_NFA:          equ    %00100000
mSSR7_SYA:          equ    %01000000
mSSR7_VFA:          equ    %10000000
mSSR7_TCB:          equ    %100000000
mSSR7_BVB:          equ    %1000000000
mSSR7_CEB:          equ    %10000000000
mSSR7_SEB:          equ    %100000000000
mSSR7_SUB:          equ    %1000000000000
mSSR7_NFB:          equ    %10000000000000
mSSR7_SYB:          equ    %100000000000000
mSSR7_VFB:          equ    %1000000000000000


;*** SSCR0 - Slot Status Counter 0 Register; 0x00000478 ***
SSCR0:              equ    $00000478                                ;*** SSCR0 - Slot Status Counter 0 Register; 0x00000478 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSCR0_SLOTSTATUSCNT: equ    0                                        ; Slot Status Counter
; bit position masks
mSSCR0_SLOTSTATUSCNT: equ    %1111111111111111


;*** SSCR1 - Slot Status Counter 1 Register; 0x0000047A ***
SSCR1:              equ    $0000047A                                ;*** SSCR1 - Slot Status Counter 1 Register; 0x0000047A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSCR1_SLOTSTATUSCNT: equ    0                                        ; Slot Status Counter
; bit position masks
mSSCR1_SLOTSTATUSCNT: equ    %1111111111111111


;*** SSCR2 - Slot Status Counter 2 Register; 0x0000047C ***
SSCR2:              equ    $0000047C                                ;*** SSCR2 - Slot Status Counter 2 Register; 0x0000047C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSCR2_SLOTSTATUSCNT: equ    0                                        ; Slot Status Counter
; bit position masks
mSSCR2_SLOTSTATUSCNT: equ    %1111111111111111


;*** SSCR3 - Slot Status Counter 3 Register; 0x0000047E ***
SSCR3:              equ    $0000047E                                ;*** SSCR3 - Slot Status Counter 3 Register; 0x0000047E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SSCR3_SLOTSTATUSCNT: equ    0                                        ; Slot Status Counter
; bit position masks
mSSCR3_SLOTSTATUSCNT: equ    %1111111111111111


;*** MTSACFR - MTS A Configuration Register; 0x00000480 ***
MTSACFR:            equ    $00000480                                ;*** MTSACFR - MTS A Configuration Register; 0x00000480 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTSACFR_CYCCNTVAL:  equ    0                                         ; Cycle Counter Value
MTSACFR_CYCCNTMSK:  equ    8                                         ; Cycle Counter Mask
MTSACFR_MTE:        equ    15                                        ; Media Access Test Symbol Transmission Enable
; bit position masks
mMTSACFR_CYCCNTVAL: equ    %00111111
mMTSACFR_CYCCNTMSK: equ    %11111100000000
mMTSACFR_MTE:       equ    %1000000000000000


;*** MTSBCFR - MTS B Configuration Register; 0x00000482 ***
MTSBCFR:            equ    $00000482                                ;*** MTSBCFR - MTS B Configuration Register; 0x00000482 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTSBCFR_CYCCNTVAL:  equ    0                                         ; Cycle Counter Value
MTSBCFR_CYCCNTMSK:  equ    8                                         ; Cycle Counter Mask
MTSBCFR_MTE:        equ    15                                        ; Media Access Test Symbol Transmission Enable
; bit position masks
mMTSBCFR_CYCCNTVAL: equ    %00111111
mMTSBCFR_CYCCNTMSK: equ    %11111100000000
mMTSBCFR_MTE:       equ    %1000000000000000


;*** RSBIR - Receive Shadow Buffer Index Register; 0x00000484 ***
RSBIR:              equ    $00000484                                ;*** RSBIR - Receive Shadow Buffer Index Register; 0x00000484 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RSBIR_RSBIDX:       equ    0                                         ; Receive Shadow Buffer Index
RSBIR_SEL:          equ    12                                        ; Selector
RSBIR_WMD:          equ    15                                        ; Write Mode
; bit position masks
mRSBIR_RSBIDX:      equ    %00111111
mRSBIR_SEL:         equ    %11000000000000
mRSBIR_WMD:         equ    %1000000000000000


;*** RFSR - Receive FIFO Selection Register; 0x00000486 ***
RFSR:               equ    $00000486                                ;*** RFSR - Receive FIFO Selection Register; 0x00000486 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFSR_SEL:           equ    0                                         ; Select
; bit position masks
mRFSR_SEL:          equ    %00000001


;*** RFSIR - Receive FIFO Start Index Register; 0x00000488 ***
RFSIR:              equ    $00000488                                ;*** RFSIR - Receive FIFO Start Index Register; 0x00000488 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFSIR_SIDX:         equ    0                                         ; Start Index
; bit position masks
mRFSIR_SIDX:        equ    %1111111111


;*** RFDSR - Receive FIFO Start Index Register; 0x0000048A ***
RFDSR:              equ    $0000048A                                ;*** RFDSR - Receive FIFO Start Index Register; 0x0000048A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFDSR_ENTRY_SIZE:   equ    0                                         ; Entry Size
RFDSR_FIFO_DEPTH:   equ    8                                         ; FIFO Depth
; bit position masks
mRFDSR_ENTRY_SIZE:  equ    %01111111
mRFDSR_FIFO_DEPTH:  equ    %1111111100000000


;*** RFARIR - Receive FIFO A Read Index Register; 0x0000048C ***
RFARIR:             equ    $0000048C                                ;*** RFARIR - Receive FIFO A Read Index Register; 0x0000048C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFARIR_RDIDX:       equ    0                                         ; Read Index
; bit position masks
mRFARIR_RDIDX:      equ    %1111111111


;*** RFBRIR - Receive FIFO B Read Index Register; 0x0000048E ***
RFBRIR:             equ    $0000048E                                ;*** RFBRIR - Receive FIFO B Read Index Register; 0x0000048E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFBRIR_RDIDX:       equ    0                                         ; Read Index
; bit position masks
mRFBRIR_RDIDX:      equ    %1111111111


;*** RFMIDAFVR - Receive FIFO Message ID Acceptance Filter Value Register; 0x00000490 ***
RFMIDAFVR:          equ    $00000490                                ;*** RFMIDAFVR - Receive FIFO Message ID Acceptance Filter Value Register; 0x00000490 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFMIDAFVR_MIDAFVAL: equ    0                                         ; Message ID Acceptance Filter Value
; bit position masks
mRFMIDAFVR_MIDAFVAL: equ    %1111111111111111


;*** RFMIAFMR - Receive FIFO Message ID Acceptance Filter Mask Register; 0x00000492 ***
RFMIAFMR:           equ    $00000492                                ;*** RFMIAFMR - Receive FIFO Message ID Acceptance Filter Mask Register; 0x00000492 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFMIAFMR_MIDAFMSK:  equ    0                                         ; Message ID Acceptance Filter Mask
; bit position masks
mRFMIAFMR_MIDAFMSK: equ    %1111111111111111


;*** RFFIDRFVR - Receive FIFO Frame ID Rejection Filter Value Register; 0x00000494 ***
RFFIDRFVR:          equ    $00000494                                ;*** RFFIDRFVR - Receive FIFO Frame ID Rejection Filter Value Register; 0x00000494 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFFIDRFVR_FIDRFVAL: equ    0                                         ; Frame ID Rejection Filter Value
; bit position masks
mRFFIDRFVR_FIDRFVAL: equ    %11111111111


;*** RFFIDRFMR - Receive FIFO Frame ID Rejection Filter Mask Register; 0x00000496 ***
RFFIDRFMR:          equ    $00000496                                ;*** RFFIDRFMR - Receive FIFO Frame ID Rejection Filter Mask Register; 0x00000496 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFFIDRFMR_FIDRFMSK: equ    0                                         ; Frame ID Rejection Filter Mask
; bit position masks
mRFFIDRFMR_FIDRFMSK: equ    %11111111111


;*** RFRFCFR - Receive FIFO Range Filter Configuration Register; 0x00000498 ***
RFRFCFR:            equ    $00000498                                ;*** RFRFCFR - Receive FIFO Range Filter Configuration Register; 0x00000498 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFRFCFR_SID:        equ    0                                         ; Slot ID
RFRFCFR_SEL:        equ    12                                        ; Filter Selector
RFRFCFR_IBD:        equ    14                                        ; Interval Boundary
RFRFCFR_WMD:        equ    15                                        ; Write Mode
; bit position masks
mRFRFCFR_SID:       equ    %11111111111
mRFRFCFR_SEL:       equ    %11000000000000
mRFRFCFR_IBD:       equ    %100000000000000
mRFRFCFR_WMD:       equ    %1000000000000000


;*** RFRFCTR - Receive FIFO Range Filter Control Register; 0x0000049A ***
RFRFCTR:            equ    $0000049A                                ;*** RFRFCTR - Receive FIFO Range Filter Control Register; 0x0000049A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RFRFCTR_F0EN:       equ    0                                         ; Range Filter 0 Enable
RFRFCTR_F1EN:       equ    1                                         ; Range Filter 1 Enable
RFRFCTR_F2EN:       equ    2                                         ; Range Filter 2 Enable
RFRFCTR_F3EN:       equ    3                                         ; Range Filter 3 Enable
RFRFCTR_F0MD:       equ    8                                         ; Range Filter 0 Mode
RFRFCTR_F1MD:       equ    9                                         ; Range Filter 1 Mode
RFRFCTR_F2MD:       equ    10                                        ; Range Filter 2 Mode
RFRFCTR_F3MD:       equ    11                                        ; Range Filter 3 Mode
; bit position masks
mRFRFCTR_F0EN:      equ    %00000001
mRFRFCTR_F1EN:      equ    %00000010
mRFRFCTR_F2EN:      equ    %00000100
mRFRFCTR_F3EN:      equ    %00001000
mRFRFCTR_F0MD:      equ    %100000000
mRFRFCTR_F1MD:      equ    %1000000000
mRFRFCTR_F2MD:      equ    %10000000000
mRFRFCTR_F3MD:      equ    %100000000000


;*** LDTXSLAR - Last Dynamic Transmit Slot Channel A Register; 0x0000049C ***
LDTXSLAR:           equ    $0000049C                                ;*** LDTXSLAR - Last Dynamic Transmit Slot Channel A Register; 0x0000049C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LDTXSLAR_LASTDYNTXSLOTA: equ    0                                    ; Last Dynamic Transmission Slot Channel A
; bit position masks
mLDTXSLAR_LASTDYNTXSLOTA: equ    %11111111111


;*** LDTXSLBR - Last Dynamic Transmit Slot Channel B Register; 0x0000049E ***
LDTXSLBR:           equ    $0000049E                                ;*** LDTXSLBR - Last Dynamic Transmit Slot Channel B Register; 0x0000049E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LDTXSLBR_LASTDYNTXSLOTB: equ    0                                    ; Last Dynamic Transmission Slot Channel B
; bit position masks
mLDTXSLBR_LASTDYNTXSLOTB: equ    %11111111111


;*** PCR0 - Protocol Configuration Register 0; 0x000004A0 ***
PCR0:               equ    $000004A0                                ;*** PCR0 - Protocol Configuration Register 0; 0x000004A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR0_static_slot_length: equ    0                                    ; static_slot_length
PCR0_action_point_offset: equ    10                                  ; action_point_offset
; bit position masks
mPCR0_static_slot_length: equ    %1111111111
mPCR0_action_point_offset: equ    %1111110000000000


;*** PCR1 - Protocol Configuration Register 1; 0x000004A2 ***
PCR1:               equ    $000004A2                                ;*** PCR1 - Protocol Configuration Register 1; 0x000004A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR1_macro_after_first_static_slot: equ    0                         ; macro_after_first_static_slot
; bit position masks
mPCR1_macro_after_first_static_slot: equ    %11111111111111


;*** PCR2 - Protocol Configuration Register 2; 0x000004A4 ***
PCR2:               equ    $000004A4                                ;*** PCR2 - Protocol Configuration Register 2; 0x000004A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR2_number_of_static_slots: equ    0                                ; number_of_static_slots
PCR2_minislot_after_action_point: equ    10                          ; minislot_after_action_point
; bit position masks
mPCR2_number_of_static_slots: equ    %1111111111
mPCR2_minislot_after_action_point: equ    %1111110000000000


;*** PCR3 - Protocol Configuration Register 3; 0x000004A6 ***
PCR3:               equ    $000004A6                                ;*** PCR3 - Protocol Configuration Register 3; 0x000004A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR3_coldstart_attempts: equ    0                                    ; coldstart_attempts
PCR3_minislot_action_point_offset: equ    5                          ; minislot_action_point_offset0
PCR3_wakeup_symbol_rx_low: equ    10                                 ; wakeup_symbol_rx_low
; bit position masks
mPCR3_coldstart_attempts: equ    %00011111
mPCR3_minislot_action_point_offset: equ    %1111100000
mPCR3_wakeup_symbol_rx_low: equ    %1111110000000000


;*** PCR4 - Protocol Configuration Register 4; 0x000004A8 ***
PCR4:               equ    $000004A8                                ;*** PCR4 - Protocol Configuration Register 4; 0x000004A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR4_wakeup_symbol_rx_window: equ    0                               ; wakeup_symbol_rx_window
PCR4_cas_rx_low_max: equ    9                                        ; cas_rx_low_max
; bit position masks
mPCR4_wakeup_symbol_rx_window: equ    %111111111
mPCR4_cas_rx_low_max: equ    %1111111000000000


;*** PCR5 - Protocol Configuration Register 5; 0x000004AA ***
PCR5:               equ    $000004AA                                ;*** PCR5 - Protocol Configuration Register 5; 0x000004AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR5_wakeup_symbol_rx_idle: equ    0                                 ; wakeup_symbol_rx_idle
PCR5_wakeup_symbol_tx_low: equ    6                                  ; wakeup_symbol_tx_low
PCR5_tss_transmitter: equ    12                                      ; tss_transmitter
; bit position masks
mPCR5_wakeup_symbol_rx_idle: equ    %00111111
mPCR5_wakeup_symbol_tx_low: equ    %111111000000
mPCR5_tss_transmitter: equ    %1111000000000000


;*** PCR6 - Protocol Configuration Register 6; 0x000004AC ***
PCR6:               equ    $000004AC                                ;*** PCR6 - Protocol Configuration Register 6; 0x000004AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR6_macro_initial_offset_a: equ    0                                ; macro_initial_offset_a
PCR6_symbol_window_after_action_point: equ    7                      ; symbol_window_after_action_point
; bit position masks
mPCR6_macro_initial_offset_a: equ    %01111111
mPCR6_symbol_window_after_action_point: equ    %111111110000000


;*** PCR7 - Protocol Configuration Register 7; 0x000004AE ***
PCR7:               equ    $000004AE                                ;*** PCR7 - Protocol Configuration Register 7; 0x000004AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR7_micro_per_macro_nom_half: equ    0                              ; micro_per_macro_nom_half
PCR7_decoding_correction_b: equ    7                                 ; decoding_correction_b
; bit position masks
mPCR7_micro_per_macro_nom_half: equ    %01111111
mPCR7_decoding_correction_b: equ    %1111111110000000


;*** PCR8 - Protocol Configuration Register 8; 0x000004B0 ***
PCR8:               equ    $000004B0                                ;*** PCR8 - Protocol Configuration Register 8; 0x000004B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR8_wakeup_symbol_tx_idle: equ    0                                 ; wakeup_symbol_tx_idle
PCR8_max_without_clock_correction_passive: equ    8                  ; max_without_clock_correction_passive
PCR8_max_without_clock_correction_fatal: equ    12                   ; max_without_clock_correction_fatal
; bit position masks
mPCR8_wakeup_symbol_tx_idle: equ    %11111111
mPCR8_max_without_clock_correction_passive: equ    %111100000000
mPCR8_max_without_clock_correction_fatal: equ    %1111000000000000


;*** PCR9 - Protocol Configuration Register 9; 0x000004B2 ***
PCR9:               equ    $000004B2                                ;*** PCR9 - Protocol Configuration Register 9; 0x000004B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR9_offset_correction_out: equ    0                                 ; offset_correction_out
PCR9_symbol_window_exists: equ    14                                 ; symbol_window_exists
PCR9_minislot_exists: equ    15                                      ; mini_slot_exists
; bit position masks
mPCR9_offset_correction_out: equ    %11111111111111
mPCR9_symbol_window_exists: equ    %100000000000000
mPCR9_minislot_exists: equ    %1000000000000000


;*** PCR10 - Protocol Configuration Register 10; 0x000004B4 ***
PCR10:              equ    $000004B4                                ;*** PCR10 - Protocol Configuration Register 10; 0x000004B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR10_macro_per_cycle: equ    0                                      ; macro_per_cycle
PCR10_wakeup_channel: equ    14                                      ; wakeup_channel
PCR10_single_slot_enabled: equ    15                                 ; single_slot_enabled
; bit position masks
mPCR10_macro_per_cycle: equ    %11111111111111
mPCR10_wakeup_channel: equ    %100000000000000
mPCR10_single_slot_enabled: equ    %1000000000000000


;*** PCR11 - Protocol Configuration Register 11; 0x000004B6 ***
PCR11:              equ    $000004B6                                ;*** PCR11 - Protocol Configuration Register 11; 0x000004B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR11_offset_correction_start: equ    0                              ; offset_correction_start
PCR11_key_slot_used_for_sync: equ    14                              ; key_slot_used_for_sync
PCR11_key_slot_used_for_startup: equ    15                           ; key_slot_used_for_startup
; bit position masks
mPCR11_offset_correction_start: equ    %11111111111111
mPCR11_key_slot_used_for_sync: equ    %100000000000000
mPCR11_key_slot_used_for_startup: equ    %1000000000000000


;*** PCR12 - Protocol Configuration Register 12; 0x000004B8 ***
PCR12:              equ    $000004B8                                ;*** PCR12 - Protocol Configuration Register 12; 0x000004B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR12_key_slot_header_crc: equ    0                                  ; key_slot_header_crc
PCR12_allow_passive_to_active: equ    11                             ; allow_passive_to_active
; bit position masks
mPCR12_key_slot_header_crc: equ    %11111111111
mPCR12_allow_passive_to_active: equ    %1111100000000000


;*** PCR13 - Protocol Configuration Register 13; 0x000004BA ***
PCR13:              equ    $000004BA                                ;*** PCR13 - Protocol Configuration Register 13; 0x000004BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR13_static_slot_after_action_point: equ    0                       ; static_slot_after_action_point
PCR13_first_minislot_action_point_offset: equ    10                  ; first_minislot_action_point_offset
; bit position masks
mPCR13_static_slot_after_action_point: equ    %1111111111
mPCR13_first_minislot_action_point_offset: equ    %1111110000000000


;*** PCR14 - Protocol Configuration Register 14; 0x000004BC ***
PCR14:              equ    $000004BC                                ;*** PCR14 - Protocol Configuration Register 14; 0x000004BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR14_listen_timeout: equ    0                                       ; listen_timeout, bit 16
PCR14_rate_correction_out: equ    5                                  ; rate_correction_out
; bit position masks
mPCR14_listen_timeout: equ    %00011111
mPCR14_rate_correction_out: equ    %1111111111100000


;*** PCR15 - Protocol Configuration Register 15; 0x000004BE ***
PCR15:              equ    $000004BE                                ;*** PCR15 - Protocol Configuration Register 15; 0x000004BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR15_listen_timeout: equ    0                                       ; listen_timeout, bit 0
; bit position masks
mPCR15_listen_timeout: equ    %1111111111111111


;*** PCR16 - Protocol Configuration Register 16; 0x000004C0 ***
PCR16:              equ    $000004C0                                ;*** PCR16 - Protocol Configuration Register 16; 0x000004C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR16_noise_listen_timeout: equ    0                                 ; noise_listen_timeout, bit 16
PCR16_macro_initial_offset_b: equ    9                               ; macro_initial_offset_b
; bit position masks
mPCR16_noise_listen_timeout: equ    %111111111
mPCR16_macro_initial_offset_b: equ    %1111111000000000


;*** PCR17 - Protocol Configuration Register 17; 0x000004C2 ***
PCR17:              equ    $000004C2                                ;*** PCR17 - Protocol Configuration Register 17; 0x000004C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR17_noise_listen_timeout: equ    0                                 ; noise_listen_timeout, bit 0
; bit position masks
mPCR17_noise_listen_timeout: equ    %1111111111111111


;*** PCR18 - Protocol Configuration Register 18; 0x000004C4 ***
PCR18:              equ    $000004C4                                ;*** PCR18 - Protocol Configuration Register 18; 0x000004C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR18_key_slot_id:  equ    0                                         ; key_slot_id
PCR18_wakeup_pattern: equ    10                                      ; wakeup_pattern
; bit position masks
mPCR18_key_slot_id: equ    %1111111111
mPCR18_wakeup_pattern: equ    %1111110000000000


;*** PCR19 - Protocol Configuration Register 19; 0x000004C6 ***
PCR19:              equ    $000004C6                                ;*** PCR19 - Protocol Configuration Register 19; 0x000004C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR19_payload_length_static: equ    0                                ; payload_length_static
PCR19_decoding_correction_a: equ    7                                ; decoding_correction_a
; bit position masks
mPCR19_payload_length_static: equ    %01111111
mPCR19_decoding_correction_a: equ    %1111111110000000


;*** PCR20 - Protocol Configuration Register 20; 0x000004C8 ***
PCR20:              equ    $000004C8                                ;*** PCR20 - Protocol Configuration Register 20; 0x000004C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR20_micro_initial_offset_a: equ    0                               ; micro_initial_offset_a
PCR20_micro_initial_offset_b: equ    8                               ; micro_initial_offset_b
; bit position masks
mPCR20_micro_initial_offset_a: equ    %11111111
mPCR20_micro_initial_offset_b: equ    %1111111100000000


;*** PCR21 - Protocol Configuration Register 21; 0x000004CA ***
PCR21:              equ    $000004CA                                ;*** PCR21 - Protocol Configuration Register 21; 0x000004CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR21_latest_tx:    equ    0                                         ; latest_tx
PCR21_extern_rate_correction: equ    13                              ; extern_rate_correction
; bit position masks
mPCR21_latest_tx:   equ    %1111111111111
mPCR21_extern_rate_correction: equ    %1110000000000000


;*** PCR22 - Protocol Configuration Register 22; 0x000004CC ***
PCR22:              equ    $000004CC                                ;*** PCR22 - Protocol Configuration Register 22; 0x000004CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR22_micro_per_cycle: equ    0                                      ; micro_per_cycle, bit 16
PCR22_comp_accepted_startup_range_a: equ    4                        ; comp_accepted_startup_range_a
; bit position masks
mPCR22_micro_per_cycle: equ    %00001111
mPCR22_comp_accepted_startup_range_a: equ    %111111111110000


;*** PCR23 - Protocol Configuration Register 23; 0x000004CE ***
PCR23:              equ    $000004CE                                ;*** PCR23 - Protocol Configuration Register 23; 0x000004CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR23_micro_per_cycle: equ    0                                      ; micro_per_cycle, bit 0
; bit position masks
mPCR23_micro_per_cycle: equ    %1111111111111111


;*** PCR24 - Protocol Configuration Register 24; 0x000004D0 ***
PCR24:              equ    $000004D0                                ;*** PCR24 - Protocol Configuration Register 24; 0x000004D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR24_micro_per_cycle_min: equ    0                                  ; micro_per_cycle_min, bit 16
PCR24_max_payload_length_dynamic: equ    4                           ; max_payload_length_dynamic
PCR24_cluster_drift_damping: equ    11                               ; cluster_drift_damping
; bit position masks
mPCR24_micro_per_cycle_min: equ    %00001111
mPCR24_max_payload_length_dynamic: equ    %11111110000
mPCR24_cluster_drift_damping: equ    %1111100000000000


;*** PCR25 - Protocol Configuration Register 25; 0x000004D2 ***
PCR25:              equ    $000004D2                                ;*** PCR25 - Protocol Configuration Register 25; 0x000004D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR25_micro_per_cycle_min: equ    0                                  ; micro_per_cycle_min, bit 0
; bit position masks
mPCR25_micro_per_cycle_min: equ    %1111111111111111


;*** PCR26 - Protocol Configuration Register 26; 0x000004D4 ***
PCR26:              equ    $000004D4                                ;*** PCR26 - Protocol Configuration Register 26; 0x000004D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR26_micro_per_cycle_max: equ    0                                  ; micro_per_cycle_max, bit 16
PCR26_comp_accepted_startup_range_b: equ    4                        ; comp_accepted_startup_range_b
PCR26_allow_halt_due_to_clock: equ    15                             ; allow_halt_due_to_clock
; bit position masks
mPCR26_micro_per_cycle_max: equ    %00001111
mPCR26_comp_accepted_startup_range_b: equ    %111111111110000
mPCR26_allow_halt_due_to_clock: equ    %1000000000000000


;*** PCR27 - Protocol Configuration Register 27; 0x000004D6 ***
PCR27:              equ    $000004D6                                ;*** PCR27 - Protocol Configuration Register 27; 0x000004D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR27_micro_per_cycle_max: equ    0                                  ; micro_per_cycle_max, bit 0
; bit position masks
mPCR27_micro_per_cycle_max: equ    %1111111111111111


;*** PCR28 - Protocol Configuration Register 28; 0x000004D8 ***
PCR28:              equ    $000004D8                                ;*** PCR28 - Protocol Configuration Register 28; 0x000004D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR28_macro_after_offset_correction: equ    0                        ; macro_after_offset_correction
PCR28_dynamic_slot_idle_phase: equ    14                             ; dynamic_slot_idle_phase
; bit position masks
mPCR28_macro_after_offset_correction: equ    %11111111111111
mPCR28_dynamic_slot_idle_phase: equ    %1100000000000000


;*** PCR29 - Protocol Configuration Register 29; 0x000004DA ***
PCR29:              equ    $000004DA                                ;*** PCR29 - Protocol Configuration Register 29; 0x000004DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR29_minislots_max: equ    0                                        ; minislots_max
PCR29_extern_offset_correction: equ    13                            ; extern_offset_correction
; bit position masks
mPCR29_minislots_max: equ    %1111111111111
mPCR29_extern_offset_correction: equ    %1110000000000000


;*** PCR30 - Protocol Configuration Register 30; 0x000004DC ***
PCR30:              equ    $000004DC                                ;*** PCR30 - Protocol Configuration Register 30; 0x000004DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PCR30_sync_node_max: equ    0                                        ; sync_node_max
; bit position masks
mPCR30_sync_node_max: equ    %00001111


;*** MBCCSR0 - Message Buffer Configuration, Control, Status Registers; 0x00000500 ***
MBCCSR0:            equ    $00000500                                ;*** MBCCSR0 - Message Buffer Configuration, Control, Status Registers; 0x00000500 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR0_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR0_LCKS:       equ    1                                         ; Lock Status
MBCCSR0_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR0_DVAL:       equ    3                                         ; Data Valid
MBCCSR0_DUP:        equ    4                                         ; Data Updated
MBCCSR0_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR0_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR0_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR0_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR0_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR0_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR0_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR0_MBIF:      equ    %00000001
mMBCCSR0_LCKS:      equ    %00000010
mMBCCSR0_EDS:       equ    %00000100
mMBCCSR0_DVAL:      equ    %00001000
mMBCCSR0_DUP:       equ    %00010000
mMBCCSR0_MBIE:      equ    %100000000
mMBCCSR0_LCKT:      equ    %1000000000
mMBCCSR0_EDT:       equ    %10000000000
mMBCCSR0_CMT:       equ    %100000000000
mMBCCSR0_MTD:       equ    %1000000000000
mMBCCSR0_MBT:       equ    %10000000000000
mMBCCSR0_MCM:       equ    %100000000000000


;*** MBCCFR0 - Message Buffer Configuration, Control, Status Registers; 0x00000502 ***
MBCCFR0:            equ    $00000502                                ;*** MBCCFR0 - Message Buffer Configuration, Control, Status Registers; 0x00000502 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR0_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR0_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR0_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR0_CHB:        equ    13                                        ; Channel Assignment
MBCCFR0_CHA:        equ    14                                        ; Channel Assignment
MBCCFR0_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR0_CCFVAL:    equ    %00111111
mMBCCFR0_CCFMSK:    equ    %111111000000
mMBCCFR0_CCFE:      equ    %1000000000000
mMBCCFR0_CHB:       equ    %10000000000000
mMBCCFR0_CHA:       equ    %100000000000000
mMBCCFR0_MTM:       equ    %1000000000000000


;*** MBFIDR0 - Message Buffer Frame ID Registers; 0x00000504 ***
MBFIDR0:            equ    $00000504                                ;*** MBFIDR0 - Message Buffer Frame ID Registers; 0x00000504 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR0_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR0_FID:       equ    %11111111111


;*** MBIDXR0 - Message Buffer Index Registers; 0x00000506 ***
MBIDXR0:            equ    $00000506                                ;*** MBIDXR0 - Message Buffer Index Registers; 0x00000506 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR0_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR0_MBIDX:     equ    %00111111


;*** MBCCSR1 - Message Buffer Configuration, Control, Status Registers; 0x00000508 ***
MBCCSR1:            equ    $00000508                                ;*** MBCCSR1 - Message Buffer Configuration, Control, Status Registers; 0x00000508 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR1_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR1_LCKS:       equ    1                                         ; Lock Status
MBCCSR1_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR1_DVAL:       equ    3                                         ; Data Valid
MBCCSR1_DUP:        equ    4                                         ; Data Updated
MBCCSR1_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR1_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR1_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR1_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR1_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR1_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR1_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR1_MBIF:      equ    %00000001
mMBCCSR1_LCKS:      equ    %00000010
mMBCCSR1_EDS:       equ    %00000100
mMBCCSR1_DVAL:      equ    %00001000
mMBCCSR1_DUP:       equ    %00010000
mMBCCSR1_MBIE:      equ    %100000000
mMBCCSR1_LCKT:      equ    %1000000000
mMBCCSR1_EDT:       equ    %10000000000
mMBCCSR1_CMT:       equ    %100000000000
mMBCCSR1_MTD:       equ    %1000000000000
mMBCCSR1_MBT:       equ    %10000000000000
mMBCCSR1_MCM:       equ    %100000000000000


;*** MBCCFR1 - Message Buffer Configuration, Control, Status Registers; 0x0000050A ***
MBCCFR1:            equ    $0000050A                                ;*** MBCCFR1 - Message Buffer Configuration, Control, Status Registers; 0x0000050A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR1_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR1_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR1_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR1_CHB:        equ    13                                        ; Channel Assignment
MBCCFR1_CHA:        equ    14                                        ; Channel Assignment
MBCCFR1_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR1_CCFVAL:    equ    %00111111
mMBCCFR1_CCFMSK:    equ    %111111000000
mMBCCFR1_CCFE:      equ    %1000000000000
mMBCCFR1_CHB:       equ    %10000000000000
mMBCCFR1_CHA:       equ    %100000000000000
mMBCCFR1_MTM:       equ    %1000000000000000


;*** MBFIDR1 - Message Buffer Frame ID Registers; 0x0000050C ***
MBFIDR1:            equ    $0000050C                                ;*** MBFIDR1 - Message Buffer Frame ID Registers; 0x0000050C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR1_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR1_FID:       equ    %11111111111


;*** MBIDXR1 - Message Buffer Index Registers; 0x0000050E ***
MBIDXR1:            equ    $0000050E                                ;*** MBIDXR1 - Message Buffer Index Registers; 0x0000050E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR1_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR1_MBIDX:     equ    %00111111


;*** MBCCSR2 - Message Buffer Configuration, Control, Status Registers; 0x00000510 ***
MBCCSR2:            equ    $00000510                                ;*** MBCCSR2 - Message Buffer Configuration, Control, Status Registers; 0x00000510 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR2_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR2_LCKS:       equ    1                                         ; Lock Status
MBCCSR2_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR2_DVAL:       equ    3                                         ; Data Valid
MBCCSR2_DUP:        equ    4                                         ; Data Updated
MBCCSR2_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR2_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR2_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR2_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR2_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR2_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR2_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR2_MBIF:      equ    %00000001
mMBCCSR2_LCKS:      equ    %00000010
mMBCCSR2_EDS:       equ    %00000100
mMBCCSR2_DVAL:      equ    %00001000
mMBCCSR2_DUP:       equ    %00010000
mMBCCSR2_MBIE:      equ    %100000000
mMBCCSR2_LCKT:      equ    %1000000000
mMBCCSR2_EDT:       equ    %10000000000
mMBCCSR2_CMT:       equ    %100000000000
mMBCCSR2_MTD:       equ    %1000000000000
mMBCCSR2_MBT:       equ    %10000000000000
mMBCCSR2_MCM:       equ    %100000000000000


;*** MBCCFR2 - Message Buffer Configuration, Control, Status Registers; 0x00000512 ***
MBCCFR2:            equ    $00000512                                ;*** MBCCFR2 - Message Buffer Configuration, Control, Status Registers; 0x00000512 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR2_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR2_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR2_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR2_CHB:        equ    13                                        ; Channel Assignment
MBCCFR2_CHA:        equ    14                                        ; Channel Assignment
MBCCFR2_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR2_CCFVAL:    equ    %00111111
mMBCCFR2_CCFMSK:    equ    %111111000000
mMBCCFR2_CCFE:      equ    %1000000000000
mMBCCFR2_CHB:       equ    %10000000000000
mMBCCFR2_CHA:       equ    %100000000000000
mMBCCFR2_MTM:       equ    %1000000000000000


;*** MBFIDR2 - Message Buffer Frame ID Registers; 0x00000514 ***
MBFIDR2:            equ    $00000514                                ;*** MBFIDR2 - Message Buffer Frame ID Registers; 0x00000514 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR2_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR2_FID:       equ    %11111111111


;*** MBIDXR2 - Message Buffer Index Registers; 0x00000516 ***
MBIDXR2:            equ    $00000516                                ;*** MBIDXR2 - Message Buffer Index Registers; 0x00000516 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR2_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR2_MBIDX:     equ    %00111111


;*** MBCCSR3 - Message Buffer Configuration, Control, Status Registers; 0x00000518 ***
MBCCSR3:            equ    $00000518                                ;*** MBCCSR3 - Message Buffer Configuration, Control, Status Registers; 0x00000518 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR3_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR3_LCKS:       equ    1                                         ; Lock Status
MBCCSR3_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR3_DVAL:       equ    3                                         ; Data Valid
MBCCSR3_DUP:        equ    4                                         ; Data Updated
MBCCSR3_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR3_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR3_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR3_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR3_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR3_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR3_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR3_MBIF:      equ    %00000001
mMBCCSR3_LCKS:      equ    %00000010
mMBCCSR3_EDS:       equ    %00000100
mMBCCSR3_DVAL:      equ    %00001000
mMBCCSR3_DUP:       equ    %00010000
mMBCCSR3_MBIE:      equ    %100000000
mMBCCSR3_LCKT:      equ    %1000000000
mMBCCSR3_EDT:       equ    %10000000000
mMBCCSR3_CMT:       equ    %100000000000
mMBCCSR3_MTD:       equ    %1000000000000
mMBCCSR3_MBT:       equ    %10000000000000
mMBCCSR3_MCM:       equ    %100000000000000


;*** MBCCFR3 - Message Buffer Configuration, Control, Status Registers; 0x0000051A ***
MBCCFR3:            equ    $0000051A                                ;*** MBCCFR3 - Message Buffer Configuration, Control, Status Registers; 0x0000051A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR3_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR3_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR3_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR3_CHB:        equ    13                                        ; Channel Assignment
MBCCFR3_CHA:        equ    14                                        ; Channel Assignment
MBCCFR3_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR3_CCFVAL:    equ    %00111111
mMBCCFR3_CCFMSK:    equ    %111111000000
mMBCCFR3_CCFE:      equ    %1000000000000
mMBCCFR3_CHB:       equ    %10000000000000
mMBCCFR3_CHA:       equ    %100000000000000
mMBCCFR3_MTM:       equ    %1000000000000000


;*** MBFIDR3 - Message Buffer Frame ID Registers; 0x0000051C ***
MBFIDR3:            equ    $0000051C                                ;*** MBFIDR3 - Message Buffer Frame ID Registers; 0x0000051C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR3_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR3_FID:       equ    %11111111111


;*** MBIDXR3 - Message Buffer Index Registers; 0x0000051E ***
MBIDXR3:            equ    $0000051E                                ;*** MBIDXR3 - Message Buffer Index Registers; 0x0000051E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR3_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR3_MBIDX:     equ    %00111111


;*** MBCCSR4 - Message Buffer Configuration, Control, Status Registers; 0x00000520 ***
MBCCSR4:            equ    $00000520                                ;*** MBCCSR4 - Message Buffer Configuration, Control, Status Registers; 0x00000520 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR4_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR4_LCKS:       equ    1                                         ; Lock Status
MBCCSR4_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR4_DVAL:       equ    3                                         ; Data Valid
MBCCSR4_DUP:        equ    4                                         ; Data Updated
MBCCSR4_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR4_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR4_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR4_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR4_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR4_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR4_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR4_MBIF:      equ    %00000001
mMBCCSR4_LCKS:      equ    %00000010
mMBCCSR4_EDS:       equ    %00000100
mMBCCSR4_DVAL:      equ    %00001000
mMBCCSR4_DUP:       equ    %00010000
mMBCCSR4_MBIE:      equ    %100000000
mMBCCSR4_LCKT:      equ    %1000000000
mMBCCSR4_EDT:       equ    %10000000000
mMBCCSR4_CMT:       equ    %100000000000
mMBCCSR4_MTD:       equ    %1000000000000
mMBCCSR4_MBT:       equ    %10000000000000
mMBCCSR4_MCM:       equ    %100000000000000


;*** MBCCFR4 - Message Buffer Configuration, Control, Status Registers; 0x00000522 ***
MBCCFR4:            equ    $00000522                                ;*** MBCCFR4 - Message Buffer Configuration, Control, Status Registers; 0x00000522 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR4_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR4_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR4_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR4_CHB:        equ    13                                        ; Channel Assignment
MBCCFR4_CHA:        equ    14                                        ; Channel Assignment
MBCCFR4_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR4_CCFVAL:    equ    %00111111
mMBCCFR4_CCFMSK:    equ    %111111000000
mMBCCFR4_CCFE:      equ    %1000000000000
mMBCCFR4_CHB:       equ    %10000000000000
mMBCCFR4_CHA:       equ    %100000000000000
mMBCCFR4_MTM:       equ    %1000000000000000


;*** MBFIDR4 - Message Buffer Frame ID Registers; 0x00000524 ***
MBFIDR4:            equ    $00000524                                ;*** MBFIDR4 - Message Buffer Frame ID Registers; 0x00000524 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR4_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR4_FID:       equ    %11111111111


;*** MBIDXR4 - Message Buffer Index Registers; 0x00000526 ***
MBIDXR4:            equ    $00000526                                ;*** MBIDXR4 - Message Buffer Index Registers; 0x00000526 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR4_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR4_MBIDX:     equ    %00111111


;*** MBCCSR5 - Message Buffer Configuration, Control, Status Registers; 0x00000528 ***
MBCCSR5:            equ    $00000528                                ;*** MBCCSR5 - Message Buffer Configuration, Control, Status Registers; 0x00000528 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR5_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR5_LCKS:       equ    1                                         ; Lock Status
MBCCSR5_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR5_DVAL:       equ    3                                         ; Data Valid
MBCCSR5_DUP:        equ    4                                         ; Data Updated
MBCCSR5_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR5_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR5_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR5_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR5_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR5_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR5_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR5_MBIF:      equ    %00000001
mMBCCSR5_LCKS:      equ    %00000010
mMBCCSR5_EDS:       equ    %00000100
mMBCCSR5_DVAL:      equ    %00001000
mMBCCSR5_DUP:       equ    %00010000
mMBCCSR5_MBIE:      equ    %100000000
mMBCCSR5_LCKT:      equ    %1000000000
mMBCCSR5_EDT:       equ    %10000000000
mMBCCSR5_CMT:       equ    %100000000000
mMBCCSR5_MTD:       equ    %1000000000000
mMBCCSR5_MBT:       equ    %10000000000000
mMBCCSR5_MCM:       equ    %100000000000000


;*** MBCCFR5 - Message Buffer Configuration, Control, Status Registers; 0x0000052A ***
MBCCFR5:            equ    $0000052A                                ;*** MBCCFR5 - Message Buffer Configuration, Control, Status Registers; 0x0000052A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR5_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR5_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR5_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR5_CHB:        equ    13                                        ; Channel Assignment
MBCCFR5_CHA:        equ    14                                        ; Channel Assignment
MBCCFR5_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR5_CCFVAL:    equ    %00111111
mMBCCFR5_CCFMSK:    equ    %111111000000
mMBCCFR5_CCFE:      equ    %1000000000000
mMBCCFR5_CHB:       equ    %10000000000000
mMBCCFR5_CHA:       equ    %100000000000000
mMBCCFR5_MTM:       equ    %1000000000000000


;*** MBFIDR5 - Message Buffer Frame ID Registers; 0x0000052C ***
MBFIDR5:            equ    $0000052C                                ;*** MBFIDR5 - Message Buffer Frame ID Registers; 0x0000052C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR5_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR5_FID:       equ    %11111111111


;*** MBIDXR5 - Message Buffer Index Registers; 0x0000052E ***
MBIDXR5:            equ    $0000052E                                ;*** MBIDXR5 - Message Buffer Index Registers; 0x0000052E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR5_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR5_MBIDX:     equ    %00111111


;*** MBCCSR6 - Message Buffer Configuration, Control, Status Registers; 0x00000530 ***
MBCCSR6:            equ    $00000530                                ;*** MBCCSR6 - Message Buffer Configuration, Control, Status Registers; 0x00000530 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR6_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR6_LCKS:       equ    1                                         ; Lock Status
MBCCSR6_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR6_DVAL:       equ    3                                         ; Data Valid
MBCCSR6_DUP:        equ    4                                         ; Data Updated
MBCCSR6_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR6_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR6_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR6_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR6_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR6_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR6_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR6_MBIF:      equ    %00000001
mMBCCSR6_LCKS:      equ    %00000010
mMBCCSR6_EDS:       equ    %00000100
mMBCCSR6_DVAL:      equ    %00001000
mMBCCSR6_DUP:       equ    %00010000
mMBCCSR6_MBIE:      equ    %100000000
mMBCCSR6_LCKT:      equ    %1000000000
mMBCCSR6_EDT:       equ    %10000000000
mMBCCSR6_CMT:       equ    %100000000000
mMBCCSR6_MTD:       equ    %1000000000000
mMBCCSR6_MBT:       equ    %10000000000000
mMBCCSR6_MCM:       equ    %100000000000000


;*** MBCCFR6 - Message Buffer Configuration, Control, Status Registers; 0x00000532 ***
MBCCFR6:            equ    $00000532                                ;*** MBCCFR6 - Message Buffer Configuration, Control, Status Registers; 0x00000532 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR6_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR6_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR6_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR6_CHB:        equ    13                                        ; Channel Assignment
MBCCFR6_CHA:        equ    14                                        ; Channel Assignment
MBCCFR6_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR6_CCFVAL:    equ    %00111111
mMBCCFR6_CCFMSK:    equ    %111111000000
mMBCCFR6_CCFE:      equ    %1000000000000
mMBCCFR6_CHB:       equ    %10000000000000
mMBCCFR6_CHA:       equ    %100000000000000
mMBCCFR6_MTM:       equ    %1000000000000000


;*** MBFIDR6 - Message Buffer Frame ID Registers; 0x00000534 ***
MBFIDR6:            equ    $00000534                                ;*** MBFIDR6 - Message Buffer Frame ID Registers; 0x00000534 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR6_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR6_FID:       equ    %11111111111


;*** MBIDXR6 - Message Buffer Index Registers; 0x00000536 ***
MBIDXR6:            equ    $00000536                                ;*** MBIDXR6 - Message Buffer Index Registers; 0x00000536 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR6_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR6_MBIDX:     equ    %00111111


;*** MBCCSR7 - Message Buffer Configuration, Control, Status Registers; 0x00000538 ***
MBCCSR7:            equ    $00000538                                ;*** MBCCSR7 - Message Buffer Configuration, Control, Status Registers; 0x00000538 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR7_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR7_LCKS:       equ    1                                         ; Lock Status
MBCCSR7_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR7_DVAL:       equ    3                                         ; Data Valid
MBCCSR7_DUP:        equ    4                                         ; Data Updated
MBCCSR7_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR7_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR7_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR7_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR7_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR7_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR7_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR7_MBIF:      equ    %00000001
mMBCCSR7_LCKS:      equ    %00000010
mMBCCSR7_EDS:       equ    %00000100
mMBCCSR7_DVAL:      equ    %00001000
mMBCCSR7_DUP:       equ    %00010000
mMBCCSR7_MBIE:      equ    %100000000
mMBCCSR7_LCKT:      equ    %1000000000
mMBCCSR7_EDT:       equ    %10000000000
mMBCCSR7_CMT:       equ    %100000000000
mMBCCSR7_MTD:       equ    %1000000000000
mMBCCSR7_MBT:       equ    %10000000000000
mMBCCSR7_MCM:       equ    %100000000000000


;*** MBCCFR7 - Message Buffer Configuration, Control, Status Registers; 0x0000053A ***
MBCCFR7:            equ    $0000053A                                ;*** MBCCFR7 - Message Buffer Configuration, Control, Status Registers; 0x0000053A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR7_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR7_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR7_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR7_CHB:        equ    13                                        ; Channel Assignment
MBCCFR7_CHA:        equ    14                                        ; Channel Assignment
MBCCFR7_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR7_CCFVAL:    equ    %00111111
mMBCCFR7_CCFMSK:    equ    %111111000000
mMBCCFR7_CCFE:      equ    %1000000000000
mMBCCFR7_CHB:       equ    %10000000000000
mMBCCFR7_CHA:       equ    %100000000000000
mMBCCFR7_MTM:       equ    %1000000000000000


;*** MBFIDR7 - Message Buffer Frame ID Registers; 0x0000053C ***
MBFIDR7:            equ    $0000053C                                ;*** MBFIDR7 - Message Buffer Frame ID Registers; 0x0000053C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR7_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR7_FID:       equ    %11111111111


;*** MBIDXR7 - Message Buffer Index Registers; 0x0000053E ***
MBIDXR7:            equ    $0000053E                                ;*** MBIDXR7 - Message Buffer Index Registers; 0x0000053E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR7_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR7_MBIDX:     equ    %00111111


;*** MBCCSR8 - Message Buffer Configuration, Control, Status Registers; 0x00000540 ***
MBCCSR8:            equ    $00000540                                ;*** MBCCSR8 - Message Buffer Configuration, Control, Status Registers; 0x00000540 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR8_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR8_LCKS:       equ    1                                         ; Lock Status
MBCCSR8_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR8_DVAL:       equ    3                                         ; Data Valid
MBCCSR8_DUP:        equ    4                                         ; Data Updated
MBCCSR8_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR8_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR8_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR8_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR8_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR8_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR8_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR8_MBIF:      equ    %00000001
mMBCCSR8_LCKS:      equ    %00000010
mMBCCSR8_EDS:       equ    %00000100
mMBCCSR8_DVAL:      equ    %00001000
mMBCCSR8_DUP:       equ    %00010000
mMBCCSR8_MBIE:      equ    %100000000
mMBCCSR8_LCKT:      equ    %1000000000
mMBCCSR8_EDT:       equ    %10000000000
mMBCCSR8_CMT:       equ    %100000000000
mMBCCSR8_MTD:       equ    %1000000000000
mMBCCSR8_MBT:       equ    %10000000000000
mMBCCSR8_MCM:       equ    %100000000000000


;*** MBCCFR8 - Message Buffer Configuration, Control, Status Registers; 0x00000542 ***
MBCCFR8:            equ    $00000542                                ;*** MBCCFR8 - Message Buffer Configuration, Control, Status Registers; 0x00000542 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR8_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR8_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR8_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR8_CHB:        equ    13                                        ; Channel Assignment
MBCCFR8_CHA:        equ    14                                        ; Channel Assignment
MBCCFR8_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR8_CCFVAL:    equ    %00111111
mMBCCFR8_CCFMSK:    equ    %111111000000
mMBCCFR8_CCFE:      equ    %1000000000000
mMBCCFR8_CHB:       equ    %10000000000000
mMBCCFR8_CHA:       equ    %100000000000000
mMBCCFR8_MTM:       equ    %1000000000000000


;*** MBFIDR8 - Message Buffer Frame ID Registers; 0x00000544 ***
MBFIDR8:            equ    $00000544                                ;*** MBFIDR8 - Message Buffer Frame ID Registers; 0x00000544 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR8_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR8_FID:       equ    %11111111111


;*** MBIDXR8 - Message Buffer Index Registers; 0x00000546 ***
MBIDXR8:            equ    $00000546                                ;*** MBIDXR8 - Message Buffer Index Registers; 0x00000546 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR8_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR8_MBIDX:     equ    %00111111


;*** MBCCSR9 - Message Buffer Configuration, Control, Status Registers; 0x00000548 ***
MBCCSR9:            equ    $00000548                                ;*** MBCCSR9 - Message Buffer Configuration, Control, Status Registers; 0x00000548 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR9_MBIF:       equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR9_LCKS:       equ    1                                         ; Lock Status
MBCCSR9_EDS:        equ    2                                         ; Enable/Disable Status
MBCCSR9_DVAL:       equ    3                                         ; Data Valid
MBCCSR9_DUP:        equ    4                                         ; Data Updated
MBCCSR9_MBIE:       equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR9_LCKT:       equ    9                                         ; Lock/Unlock Trigger
MBCCSR9_EDT:        equ    10                                        ; Enable/Disable Trigger
MBCCSR9_CMT:        equ    11                                        ; Commit for Transmission
MBCCSR9_MTD:        equ    12                                        ; Message Buffer Transfer Direction
MBCCSR9_MBT:        equ    13                                        ; Message Buffer Type
MBCCSR9_MCM:        equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR9_MBIF:      equ    %00000001
mMBCCSR9_LCKS:      equ    %00000010
mMBCCSR9_EDS:       equ    %00000100
mMBCCSR9_DVAL:      equ    %00001000
mMBCCSR9_DUP:       equ    %00010000
mMBCCSR9_MBIE:      equ    %100000000
mMBCCSR9_LCKT:      equ    %1000000000
mMBCCSR9_EDT:       equ    %10000000000
mMBCCSR9_CMT:       equ    %100000000000
mMBCCSR9_MTD:       equ    %1000000000000
mMBCCSR9_MBT:       equ    %10000000000000
mMBCCSR9_MCM:       equ    %100000000000000


;*** MBCCFR9 - Message Buffer Configuration, Control, Status Registers; 0x0000054A ***
MBCCFR9:            equ    $0000054A                                ;*** MBCCFR9 - Message Buffer Configuration, Control, Status Registers; 0x0000054A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR9_CCFVAL:     equ    0                                         ; Cycle Counter Filtering Value
MBCCFR9_CCFMSK:     equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR9_CCFE:       equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR9_CHB:        equ    13                                        ; Channel Assignment
MBCCFR9_CHA:        equ    14                                        ; Channel Assignment
MBCCFR9_MTM:        equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR9_CCFVAL:    equ    %00111111
mMBCCFR9_CCFMSK:    equ    %111111000000
mMBCCFR9_CCFE:      equ    %1000000000000
mMBCCFR9_CHB:       equ    %10000000000000
mMBCCFR9_CHA:       equ    %100000000000000
mMBCCFR9_MTM:       equ    %1000000000000000


;*** MBFIDR9 - Message Buffer Frame ID Registers; 0x0000054C ***
MBFIDR9:            equ    $0000054C                                ;*** MBFIDR9 - Message Buffer Frame ID Registers; 0x0000054C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR9_FID:        equ    0                                         ; Frame ID
; bit position masks
mMBFIDR9_FID:       equ    %11111111111


;*** MBIDXR9 - Message Buffer Index Registers; 0x0000054E ***
MBIDXR9:            equ    $0000054E                                ;*** MBIDXR9 - Message Buffer Index Registers; 0x0000054E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR9_MBIDX:      equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR9_MBIDX:     equ    %00111111


;*** MBCCSR10 - Message Buffer Configuration, Control, Status Registers; 0x00000550 ***
MBCCSR10:           equ    $00000550                                ;*** MBCCSR10 - Message Buffer Configuration, Control, Status Registers; 0x00000550 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR10_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR10_LCKS:      equ    1                                         ; Lock Status
MBCCSR10_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR10_DVAL:      equ    3                                         ; Data Valid
MBCCSR10_DUP:       equ    4                                         ; Data Updated
MBCCSR10_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR10_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR10_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR10_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR10_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR10_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR10_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR10_MBIF:     equ    %00000001
mMBCCSR10_LCKS:     equ    %00000010
mMBCCSR10_EDS:      equ    %00000100
mMBCCSR10_DVAL:     equ    %00001000
mMBCCSR10_DUP:      equ    %00010000
mMBCCSR10_MBIE:     equ    %100000000
mMBCCSR10_LCKT:     equ    %1000000000
mMBCCSR10_EDT:      equ    %10000000000
mMBCCSR10_CMT:      equ    %100000000000
mMBCCSR10_MTD:      equ    %1000000000000
mMBCCSR10_MBT:      equ    %10000000000000
mMBCCSR10_MCM:      equ    %100000000000000


;*** MBCCFR10 - Message Buffer Configuration, Control, Status Registers; 0x00000552 ***
MBCCFR10:           equ    $00000552                                ;*** MBCCFR10 - Message Buffer Configuration, Control, Status Registers; 0x00000552 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR10_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR10_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR10_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR10_CHB:       equ    13                                        ; Channel Assignment
MBCCFR10_CHA:       equ    14                                        ; Channel Assignment
MBCCFR10_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR10_CCFVAL:   equ    %00111111
mMBCCFR10_CCFMSK:   equ    %111111000000
mMBCCFR10_CCFE:     equ    %1000000000000
mMBCCFR10_CHB:      equ    %10000000000000
mMBCCFR10_CHA:      equ    %100000000000000
mMBCCFR10_MTM:      equ    %1000000000000000


;*** MBFIDR10 - Message Buffer Frame ID Registers; 0x00000554 ***
MBFIDR10:           equ    $00000554                                ;*** MBFIDR10 - Message Buffer Frame ID Registers; 0x00000554 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR10_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR10_FID:      equ    %11111111111


;*** MBIDXR10 - Message Buffer Index Registers; 0x00000556 ***
MBIDXR10:           equ    $00000556                                ;*** MBIDXR10 - Message Buffer Index Registers; 0x00000556 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR10_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR10_MBIDX:    equ    %00111111


;*** MBCCSR11 - Message Buffer Configuration, Control, Status Registers; 0x00000558 ***
MBCCSR11:           equ    $00000558                                ;*** MBCCSR11 - Message Buffer Configuration, Control, Status Registers; 0x00000558 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR11_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR11_LCKS:      equ    1                                         ; Lock Status
MBCCSR11_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR11_DVAL:      equ    3                                         ; Data Valid
MBCCSR11_DUP:       equ    4                                         ; Data Updated
MBCCSR11_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR11_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR11_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR11_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR11_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR11_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR11_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR11_MBIF:     equ    %00000001
mMBCCSR11_LCKS:     equ    %00000010
mMBCCSR11_EDS:      equ    %00000100
mMBCCSR11_DVAL:     equ    %00001000
mMBCCSR11_DUP:      equ    %00010000
mMBCCSR11_MBIE:     equ    %100000000
mMBCCSR11_LCKT:     equ    %1000000000
mMBCCSR11_EDT:      equ    %10000000000
mMBCCSR11_CMT:      equ    %100000000000
mMBCCSR11_MTD:      equ    %1000000000000
mMBCCSR11_MBT:      equ    %10000000000000
mMBCCSR11_MCM:      equ    %100000000000000


;*** MBCCFR11 - Message Buffer Configuration, Control, Status Registers; 0x0000055A ***
MBCCFR11:           equ    $0000055A                                ;*** MBCCFR11 - Message Buffer Configuration, Control, Status Registers; 0x0000055A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR11_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR11_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR11_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR11_CHB:       equ    13                                        ; Channel Assignment
MBCCFR11_CHA:       equ    14                                        ; Channel Assignment
MBCCFR11_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR11_CCFVAL:   equ    %00111111
mMBCCFR11_CCFMSK:   equ    %111111000000
mMBCCFR11_CCFE:     equ    %1000000000000
mMBCCFR11_CHB:      equ    %10000000000000
mMBCCFR11_CHA:      equ    %100000000000000
mMBCCFR11_MTM:      equ    %1000000000000000


;*** MBFIDR11 - Message Buffer Frame ID Registers; 0x0000055C ***
MBFIDR11:           equ    $0000055C                                ;*** MBFIDR11 - Message Buffer Frame ID Registers; 0x0000055C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR11_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR11_FID:      equ    %11111111111


;*** MBIDXR11 - Message Buffer Index Registers; 0x0000055E ***
MBIDXR11:           equ    $0000055E                                ;*** MBIDXR11 - Message Buffer Index Registers; 0x0000055E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR11_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR11_MBIDX:    equ    %00111111


;*** MBCCSR12 - Message Buffer Configuration, Control, Status Registers; 0x00000560 ***
MBCCSR12:           equ    $00000560                                ;*** MBCCSR12 - Message Buffer Configuration, Control, Status Registers; 0x00000560 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR12_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR12_LCKS:      equ    1                                         ; Lock Status
MBCCSR12_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR12_DVAL:      equ    3                                         ; Data Valid
MBCCSR12_DUP:       equ    4                                         ; Data Updated
MBCCSR12_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR12_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR12_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR12_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR12_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR12_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR12_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR12_MBIF:     equ    %00000001
mMBCCSR12_LCKS:     equ    %00000010
mMBCCSR12_EDS:      equ    %00000100
mMBCCSR12_DVAL:     equ    %00001000
mMBCCSR12_DUP:      equ    %00010000
mMBCCSR12_MBIE:     equ    %100000000
mMBCCSR12_LCKT:     equ    %1000000000
mMBCCSR12_EDT:      equ    %10000000000
mMBCCSR12_CMT:      equ    %100000000000
mMBCCSR12_MTD:      equ    %1000000000000
mMBCCSR12_MBT:      equ    %10000000000000
mMBCCSR12_MCM:      equ    %100000000000000


;*** MBCCFR12 - Message Buffer Configuration, Control, Status Registers; 0x00000562 ***
MBCCFR12:           equ    $00000562                                ;*** MBCCFR12 - Message Buffer Configuration, Control, Status Registers; 0x00000562 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR12_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR12_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR12_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR12_CHB:       equ    13                                        ; Channel Assignment
MBCCFR12_CHA:       equ    14                                        ; Channel Assignment
MBCCFR12_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR12_CCFVAL:   equ    %00111111
mMBCCFR12_CCFMSK:   equ    %111111000000
mMBCCFR12_CCFE:     equ    %1000000000000
mMBCCFR12_CHB:      equ    %10000000000000
mMBCCFR12_CHA:      equ    %100000000000000
mMBCCFR12_MTM:      equ    %1000000000000000


;*** MBFIDR12 - Message Buffer Frame ID Registers; 0x00000564 ***
MBFIDR12:           equ    $00000564                                ;*** MBFIDR12 - Message Buffer Frame ID Registers; 0x00000564 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR12_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR12_FID:      equ    %11111111111


;*** MBIDXR12 - Message Buffer Index Registers; 0x00000566 ***
MBIDXR12:           equ    $00000566                                ;*** MBIDXR12 - Message Buffer Index Registers; 0x00000566 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR12_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR12_MBIDX:    equ    %00111111


;*** MBCCSR13 - Message Buffer Configuration, Control, Status Registers; 0x00000568 ***
MBCCSR13:           equ    $00000568                                ;*** MBCCSR13 - Message Buffer Configuration, Control, Status Registers; 0x00000568 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR13_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR13_LCKS:      equ    1                                         ; Lock Status
MBCCSR13_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR13_DVAL:      equ    3                                         ; Data Valid
MBCCSR13_DUP:       equ    4                                         ; Data Updated
MBCCSR13_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR13_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR13_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR13_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR13_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR13_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR13_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR13_MBIF:     equ    %00000001
mMBCCSR13_LCKS:     equ    %00000010
mMBCCSR13_EDS:      equ    %00000100
mMBCCSR13_DVAL:     equ    %00001000
mMBCCSR13_DUP:      equ    %00010000
mMBCCSR13_MBIE:     equ    %100000000
mMBCCSR13_LCKT:     equ    %1000000000
mMBCCSR13_EDT:      equ    %10000000000
mMBCCSR13_CMT:      equ    %100000000000
mMBCCSR13_MTD:      equ    %1000000000000
mMBCCSR13_MBT:      equ    %10000000000000
mMBCCSR13_MCM:      equ    %100000000000000


;*** MBCCFR13 - Message Buffer Configuration, Control, Status Registers; 0x0000056A ***
MBCCFR13:           equ    $0000056A                                ;*** MBCCFR13 - Message Buffer Configuration, Control, Status Registers; 0x0000056A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR13_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR13_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR13_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR13_CHB:       equ    13                                        ; Channel Assignment
MBCCFR13_CHA:       equ    14                                        ; Channel Assignment
MBCCFR13_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR13_CCFVAL:   equ    %00111111
mMBCCFR13_CCFMSK:   equ    %111111000000
mMBCCFR13_CCFE:     equ    %1000000000000
mMBCCFR13_CHB:      equ    %10000000000000
mMBCCFR13_CHA:      equ    %100000000000000
mMBCCFR13_MTM:      equ    %1000000000000000


;*** MBFIDR13 - Message Buffer Frame ID Registers; 0x0000056C ***
MBFIDR13:           equ    $0000056C                                ;*** MBFIDR13 - Message Buffer Frame ID Registers; 0x0000056C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR13_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR13_FID:      equ    %11111111111


;*** MBIDXR13 - Message Buffer Index Registers; 0x0000056E ***
MBIDXR13:           equ    $0000056E                                ;*** MBIDXR13 - Message Buffer Index Registers; 0x0000056E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR13_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR13_MBIDX:    equ    %00111111


;*** MBCCSR14 - Message Buffer Configuration, Control, Status Registers; 0x00000570 ***
MBCCSR14:           equ    $00000570                                ;*** MBCCSR14 - Message Buffer Configuration, Control, Status Registers; 0x00000570 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR14_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR14_LCKS:      equ    1                                         ; Lock Status
MBCCSR14_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR14_DVAL:      equ    3                                         ; Data Valid
MBCCSR14_DUP:       equ    4                                         ; Data Updated
MBCCSR14_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR14_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR14_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR14_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR14_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR14_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR14_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR14_MBIF:     equ    %00000001
mMBCCSR14_LCKS:     equ    %00000010
mMBCCSR14_EDS:      equ    %00000100
mMBCCSR14_DVAL:     equ    %00001000
mMBCCSR14_DUP:      equ    %00010000
mMBCCSR14_MBIE:     equ    %100000000
mMBCCSR14_LCKT:     equ    %1000000000
mMBCCSR14_EDT:      equ    %10000000000
mMBCCSR14_CMT:      equ    %100000000000
mMBCCSR14_MTD:      equ    %1000000000000
mMBCCSR14_MBT:      equ    %10000000000000
mMBCCSR14_MCM:      equ    %100000000000000


;*** MBCCFR14 - Message Buffer Configuration, Control, Status Registers; 0x00000572 ***
MBCCFR14:           equ    $00000572                                ;*** MBCCFR14 - Message Buffer Configuration, Control, Status Registers; 0x00000572 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR14_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR14_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR14_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR14_CHB:       equ    13                                        ; Channel Assignment
MBCCFR14_CHA:       equ    14                                        ; Channel Assignment
MBCCFR14_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR14_CCFVAL:   equ    %00111111
mMBCCFR14_CCFMSK:   equ    %111111000000
mMBCCFR14_CCFE:     equ    %1000000000000
mMBCCFR14_CHB:      equ    %10000000000000
mMBCCFR14_CHA:      equ    %100000000000000
mMBCCFR14_MTM:      equ    %1000000000000000


;*** MBFIDR14 - Message Buffer Frame ID Registers; 0x00000574 ***
MBFIDR14:           equ    $00000574                                ;*** MBFIDR14 - Message Buffer Frame ID Registers; 0x00000574 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR14_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR14_FID:      equ    %11111111111


;*** MBIDXR14 - Message Buffer Index Registers; 0x00000576 ***
MBIDXR14:           equ    $00000576                                ;*** MBIDXR14 - Message Buffer Index Registers; 0x00000576 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR14_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR14_MBIDX:    equ    %00111111


;*** MBCCSR15 - Message Buffer Configuration, Control, Status Registers; 0x00000578 ***
MBCCSR15:           equ    $00000578                                ;*** MBCCSR15 - Message Buffer Configuration, Control, Status Registers; 0x00000578 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR15_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR15_LCKS:      equ    1                                         ; Lock Status
MBCCSR15_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR15_DVAL:      equ    3                                         ; Data Valid
MBCCSR15_DUP:       equ    4                                         ; Data Updated
MBCCSR15_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR15_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR15_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR15_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR15_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR15_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR15_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR15_MBIF:     equ    %00000001
mMBCCSR15_LCKS:     equ    %00000010
mMBCCSR15_EDS:      equ    %00000100
mMBCCSR15_DVAL:     equ    %00001000
mMBCCSR15_DUP:      equ    %00010000
mMBCCSR15_MBIE:     equ    %100000000
mMBCCSR15_LCKT:     equ    %1000000000
mMBCCSR15_EDT:      equ    %10000000000
mMBCCSR15_CMT:      equ    %100000000000
mMBCCSR15_MTD:      equ    %1000000000000
mMBCCSR15_MBT:      equ    %10000000000000
mMBCCSR15_MCM:      equ    %100000000000000


;*** MBCCFR15 - Message Buffer Configuration, Control, Status Registers; 0x0000057A ***
MBCCFR15:           equ    $0000057A                                ;*** MBCCFR15 - Message Buffer Configuration, Control, Status Registers; 0x0000057A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR15_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR15_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR15_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR15_CHB:       equ    13                                        ; Channel Assignment
MBCCFR15_CHA:       equ    14                                        ; Channel Assignment
MBCCFR15_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR15_CCFVAL:   equ    %00111111
mMBCCFR15_CCFMSK:   equ    %111111000000
mMBCCFR15_CCFE:     equ    %1000000000000
mMBCCFR15_CHB:      equ    %10000000000000
mMBCCFR15_CHA:      equ    %100000000000000
mMBCCFR15_MTM:      equ    %1000000000000000


;*** MBFIDR15 - Message Buffer Frame ID Registers; 0x0000057C ***
MBFIDR15:           equ    $0000057C                                ;*** MBFIDR15 - Message Buffer Frame ID Registers; 0x0000057C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR15_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR15_FID:      equ    %11111111111


;*** MBIDXR15 - Message Buffer Index Registers; 0x0000057E ***
MBIDXR15:           equ    $0000057E                                ;*** MBIDXR15 - Message Buffer Index Registers; 0x0000057E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR15_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR15_MBIDX:    equ    %00111111


;*** MBCCSR16 - Message Buffer Configuration, Control, Status Registers; 0x00000580 ***
MBCCSR16:           equ    $00000580                                ;*** MBCCSR16 - Message Buffer Configuration, Control, Status Registers; 0x00000580 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR16_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR16_LCKS:      equ    1                                         ; Lock Status
MBCCSR16_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR16_DVAL:      equ    3                                         ; Data Valid
MBCCSR16_DUP:       equ    4                                         ; Data Updated
MBCCSR16_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR16_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR16_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR16_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR16_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR16_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR16_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR16_MBIF:     equ    %00000001
mMBCCSR16_LCKS:     equ    %00000010
mMBCCSR16_EDS:      equ    %00000100
mMBCCSR16_DVAL:     equ    %00001000
mMBCCSR16_DUP:      equ    %00010000
mMBCCSR16_MBIE:     equ    %100000000
mMBCCSR16_LCKT:     equ    %1000000000
mMBCCSR16_EDT:      equ    %10000000000
mMBCCSR16_CMT:      equ    %100000000000
mMBCCSR16_MTD:      equ    %1000000000000
mMBCCSR16_MBT:      equ    %10000000000000
mMBCCSR16_MCM:      equ    %100000000000000


;*** MBCCFR16 - Message Buffer Configuration, Control, Status Registers; 0x00000582 ***
MBCCFR16:           equ    $00000582                                ;*** MBCCFR16 - Message Buffer Configuration, Control, Status Registers; 0x00000582 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR16_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR16_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR16_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR16_CHB:       equ    13                                        ; Channel Assignment
MBCCFR16_CHA:       equ    14                                        ; Channel Assignment
MBCCFR16_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR16_CCFVAL:   equ    %00111111
mMBCCFR16_CCFMSK:   equ    %111111000000
mMBCCFR16_CCFE:     equ    %1000000000000
mMBCCFR16_CHB:      equ    %10000000000000
mMBCCFR16_CHA:      equ    %100000000000000
mMBCCFR16_MTM:      equ    %1000000000000000


;*** MBFIDR16 - Message Buffer Frame ID Registers; 0x00000584 ***
MBFIDR16:           equ    $00000584                                ;*** MBFIDR16 - Message Buffer Frame ID Registers; 0x00000584 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR16_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR16_FID:      equ    %11111111111


;*** MBIDXR16 - Message Buffer Index Registers; 0x00000586 ***
MBIDXR16:           equ    $00000586                                ;*** MBIDXR16 - Message Buffer Index Registers; 0x00000586 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR16_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR16_MBIDX:    equ    %00111111


;*** MBCCSR17 - Message Buffer Configuration, Control, Status Registers; 0x00000588 ***
MBCCSR17:           equ    $00000588                                ;*** MBCCSR17 - Message Buffer Configuration, Control, Status Registers; 0x00000588 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR17_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR17_LCKS:      equ    1                                         ; Lock Status
MBCCSR17_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR17_DVAL:      equ    3                                         ; Data Valid
MBCCSR17_DUP:       equ    4                                         ; Data Updated
MBCCSR17_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR17_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR17_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR17_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR17_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR17_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR17_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR17_MBIF:     equ    %00000001
mMBCCSR17_LCKS:     equ    %00000010
mMBCCSR17_EDS:      equ    %00000100
mMBCCSR17_DVAL:     equ    %00001000
mMBCCSR17_DUP:      equ    %00010000
mMBCCSR17_MBIE:     equ    %100000000
mMBCCSR17_LCKT:     equ    %1000000000
mMBCCSR17_EDT:      equ    %10000000000
mMBCCSR17_CMT:      equ    %100000000000
mMBCCSR17_MTD:      equ    %1000000000000
mMBCCSR17_MBT:      equ    %10000000000000
mMBCCSR17_MCM:      equ    %100000000000000


;*** MBCCFR17 - Message Buffer Configuration, Control, Status Registers; 0x0000058A ***
MBCCFR17:           equ    $0000058A                                ;*** MBCCFR17 - Message Buffer Configuration, Control, Status Registers; 0x0000058A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR17_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR17_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR17_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR17_CHB:       equ    13                                        ; Channel Assignment
MBCCFR17_CHA:       equ    14                                        ; Channel Assignment
MBCCFR17_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR17_CCFVAL:   equ    %00111111
mMBCCFR17_CCFMSK:   equ    %111111000000
mMBCCFR17_CCFE:     equ    %1000000000000
mMBCCFR17_CHB:      equ    %10000000000000
mMBCCFR17_CHA:      equ    %100000000000000
mMBCCFR17_MTM:      equ    %1000000000000000


;*** MBFIDR17 - Message Buffer Frame ID Registers; 0x0000058C ***
MBFIDR17:           equ    $0000058C                                ;*** MBFIDR17 - Message Buffer Frame ID Registers; 0x0000058C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR17_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR17_FID:      equ    %11111111111


;*** MBIDXR17 - Message Buffer Index Registers; 0x0000058E ***
MBIDXR17:           equ    $0000058E                                ;*** MBIDXR17 - Message Buffer Index Registers; 0x0000058E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR17_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR17_MBIDX:    equ    %00111111


;*** MBCCSR18 - Message Buffer Configuration, Control, Status Registers; 0x00000590 ***
MBCCSR18:           equ    $00000590                                ;*** MBCCSR18 - Message Buffer Configuration, Control, Status Registers; 0x00000590 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR18_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR18_LCKS:      equ    1                                         ; Lock Status
MBCCSR18_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR18_DVAL:      equ    3                                         ; Data Valid
MBCCSR18_DUP:       equ    4                                         ; Data Updated
MBCCSR18_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR18_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR18_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR18_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR18_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR18_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR18_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR18_MBIF:     equ    %00000001
mMBCCSR18_LCKS:     equ    %00000010
mMBCCSR18_EDS:      equ    %00000100
mMBCCSR18_DVAL:     equ    %00001000
mMBCCSR18_DUP:      equ    %00010000
mMBCCSR18_MBIE:     equ    %100000000
mMBCCSR18_LCKT:     equ    %1000000000
mMBCCSR18_EDT:      equ    %10000000000
mMBCCSR18_CMT:      equ    %100000000000
mMBCCSR18_MTD:      equ    %1000000000000
mMBCCSR18_MBT:      equ    %10000000000000
mMBCCSR18_MCM:      equ    %100000000000000


;*** MBCCFR18 - Message Buffer Configuration, Control, Status Registers; 0x00000592 ***
MBCCFR18:           equ    $00000592                                ;*** MBCCFR18 - Message Buffer Configuration, Control, Status Registers; 0x00000592 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR18_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR18_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR18_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR18_CHB:       equ    13                                        ; Channel Assignment
MBCCFR18_CHA:       equ    14                                        ; Channel Assignment
MBCCFR18_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR18_CCFVAL:   equ    %00111111
mMBCCFR18_CCFMSK:   equ    %111111000000
mMBCCFR18_CCFE:     equ    %1000000000000
mMBCCFR18_CHB:      equ    %10000000000000
mMBCCFR18_CHA:      equ    %100000000000000
mMBCCFR18_MTM:      equ    %1000000000000000


;*** MBFIDR18 - Message Buffer Frame ID Registers; 0x00000594 ***
MBFIDR18:           equ    $00000594                                ;*** MBFIDR18 - Message Buffer Frame ID Registers; 0x00000594 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR18_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR18_FID:      equ    %11111111111


;*** MBIDXR18 - Message Buffer Index Registers; 0x00000596 ***
MBIDXR18:           equ    $00000596                                ;*** MBIDXR18 - Message Buffer Index Registers; 0x00000596 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR18_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR18_MBIDX:    equ    %00111111


;*** MBCCSR19 - Message Buffer Configuration, Control, Status Registers; 0x00000598 ***
MBCCSR19:           equ    $00000598                                ;*** MBCCSR19 - Message Buffer Configuration, Control, Status Registers; 0x00000598 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR19_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR19_LCKS:      equ    1                                         ; Lock Status
MBCCSR19_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR19_DVAL:      equ    3                                         ; Data Valid
MBCCSR19_DUP:       equ    4                                         ; Data Updated
MBCCSR19_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR19_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR19_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR19_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR19_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR19_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR19_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR19_MBIF:     equ    %00000001
mMBCCSR19_LCKS:     equ    %00000010
mMBCCSR19_EDS:      equ    %00000100
mMBCCSR19_DVAL:     equ    %00001000
mMBCCSR19_DUP:      equ    %00010000
mMBCCSR19_MBIE:     equ    %100000000
mMBCCSR19_LCKT:     equ    %1000000000
mMBCCSR19_EDT:      equ    %10000000000
mMBCCSR19_CMT:      equ    %100000000000
mMBCCSR19_MTD:      equ    %1000000000000
mMBCCSR19_MBT:      equ    %10000000000000
mMBCCSR19_MCM:      equ    %100000000000000


;*** MBCCFR19 - Message Buffer Configuration, Control, Status Registers; 0x0000059A ***
MBCCFR19:           equ    $0000059A                                ;*** MBCCFR19 - Message Buffer Configuration, Control, Status Registers; 0x0000059A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR19_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR19_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR19_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR19_CHB:       equ    13                                        ; Channel Assignment
MBCCFR19_CHA:       equ    14                                        ; Channel Assignment
MBCCFR19_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR19_CCFVAL:   equ    %00111111
mMBCCFR19_CCFMSK:   equ    %111111000000
mMBCCFR19_CCFE:     equ    %1000000000000
mMBCCFR19_CHB:      equ    %10000000000000
mMBCCFR19_CHA:      equ    %100000000000000
mMBCCFR19_MTM:      equ    %1000000000000000


;*** MBFIDR19 - Message Buffer Frame ID Registers; 0x0000059C ***
MBFIDR19:           equ    $0000059C                                ;*** MBFIDR19 - Message Buffer Frame ID Registers; 0x0000059C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR19_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR19_FID:      equ    %11111111111


;*** MBIDXR19 - Message Buffer Index Registers; 0x0000059E ***
MBIDXR19:           equ    $0000059E                                ;*** MBIDXR19 - Message Buffer Index Registers; 0x0000059E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR19_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR19_MBIDX:    equ    %00111111


;*** MBCCSR20 - Message Buffer Configuration, Control, Status Registers; 0x000005A0 ***
MBCCSR20:           equ    $000005A0                                ;*** MBCCSR20 - Message Buffer Configuration, Control, Status Registers; 0x000005A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR20_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR20_LCKS:      equ    1                                         ; Lock Status
MBCCSR20_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR20_DVAL:      equ    3                                         ; Data Valid
MBCCSR20_DUP:       equ    4                                         ; Data Updated
MBCCSR20_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR20_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR20_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR20_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR20_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR20_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR20_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR20_MBIF:     equ    %00000001
mMBCCSR20_LCKS:     equ    %00000010
mMBCCSR20_EDS:      equ    %00000100
mMBCCSR20_DVAL:     equ    %00001000
mMBCCSR20_DUP:      equ    %00010000
mMBCCSR20_MBIE:     equ    %100000000
mMBCCSR20_LCKT:     equ    %1000000000
mMBCCSR20_EDT:      equ    %10000000000
mMBCCSR20_CMT:      equ    %100000000000
mMBCCSR20_MTD:      equ    %1000000000000
mMBCCSR20_MBT:      equ    %10000000000000
mMBCCSR20_MCM:      equ    %100000000000000


;*** MBCCFR20 - Message Buffer Configuration, Control, Status Registers; 0x000005A2 ***
MBCCFR20:           equ    $000005A2                                ;*** MBCCFR20 - Message Buffer Configuration, Control, Status Registers; 0x000005A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR20_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR20_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR20_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR20_CHB:       equ    13                                        ; Channel Assignment
MBCCFR20_CHA:       equ    14                                        ; Channel Assignment
MBCCFR20_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR20_CCFVAL:   equ    %00111111
mMBCCFR20_CCFMSK:   equ    %111111000000
mMBCCFR20_CCFE:     equ    %1000000000000
mMBCCFR20_CHB:      equ    %10000000000000
mMBCCFR20_CHA:      equ    %100000000000000
mMBCCFR20_MTM:      equ    %1000000000000000


;*** MBFIDR20 - Message Buffer Frame ID Registers; 0x000005A4 ***
MBFIDR20:           equ    $000005A4                                ;*** MBFIDR20 - Message Buffer Frame ID Registers; 0x000005A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR20_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR20_FID:      equ    %11111111111


;*** MBIDXR20 - Message Buffer Index Registers; 0x000005A6 ***
MBIDXR20:           equ    $000005A6                                ;*** MBIDXR20 - Message Buffer Index Registers; 0x000005A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR20_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR20_MBIDX:    equ    %00111111


;*** MBCCSR21 - Message Buffer Configuration, Control, Status Registers; 0x000005A8 ***
MBCCSR21:           equ    $000005A8                                ;*** MBCCSR21 - Message Buffer Configuration, Control, Status Registers; 0x000005A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR21_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR21_LCKS:      equ    1                                         ; Lock Status
MBCCSR21_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR21_DVAL:      equ    3                                         ; Data Valid
MBCCSR21_DUP:       equ    4                                         ; Data Updated
MBCCSR21_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR21_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR21_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR21_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR21_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR21_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR21_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR21_MBIF:     equ    %00000001
mMBCCSR21_LCKS:     equ    %00000010
mMBCCSR21_EDS:      equ    %00000100
mMBCCSR21_DVAL:     equ    %00001000
mMBCCSR21_DUP:      equ    %00010000
mMBCCSR21_MBIE:     equ    %100000000
mMBCCSR21_LCKT:     equ    %1000000000
mMBCCSR21_EDT:      equ    %10000000000
mMBCCSR21_CMT:      equ    %100000000000
mMBCCSR21_MTD:      equ    %1000000000000
mMBCCSR21_MBT:      equ    %10000000000000
mMBCCSR21_MCM:      equ    %100000000000000


;*** MBCCFR21 - Message Buffer Configuration, Control, Status Registers; 0x000005AA ***
MBCCFR21:           equ    $000005AA                                ;*** MBCCFR21 - Message Buffer Configuration, Control, Status Registers; 0x000005AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR21_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR21_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR21_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR21_CHB:       equ    13                                        ; Channel Assignment
MBCCFR21_CHA:       equ    14                                        ; Channel Assignment
MBCCFR21_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR21_CCFVAL:   equ    %00111111
mMBCCFR21_CCFMSK:   equ    %111111000000
mMBCCFR21_CCFE:     equ    %1000000000000
mMBCCFR21_CHB:      equ    %10000000000000
mMBCCFR21_CHA:      equ    %100000000000000
mMBCCFR21_MTM:      equ    %1000000000000000


;*** MBFIDR21 - Message Buffer Frame ID Registers; 0x000005AC ***
MBFIDR21:           equ    $000005AC                                ;*** MBFIDR21 - Message Buffer Frame ID Registers; 0x000005AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR21_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR21_FID:      equ    %11111111111


;*** MBIDXR21 - Message Buffer Index Registers; 0x000005AE ***
MBIDXR21:           equ    $000005AE                                ;*** MBIDXR21 - Message Buffer Index Registers; 0x000005AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR21_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR21_MBIDX:    equ    %00111111


;*** MBCCSR22 - Message Buffer Configuration, Control, Status Registers; 0x000005B0 ***
MBCCSR22:           equ    $000005B0                                ;*** MBCCSR22 - Message Buffer Configuration, Control, Status Registers; 0x000005B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR22_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR22_LCKS:      equ    1                                         ; Lock Status
MBCCSR22_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR22_DVAL:      equ    3                                         ; Data Valid
MBCCSR22_DUP:       equ    4                                         ; Data Updated
MBCCSR22_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR22_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR22_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR22_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR22_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR22_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR22_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR22_MBIF:     equ    %00000001
mMBCCSR22_LCKS:     equ    %00000010
mMBCCSR22_EDS:      equ    %00000100
mMBCCSR22_DVAL:     equ    %00001000
mMBCCSR22_DUP:      equ    %00010000
mMBCCSR22_MBIE:     equ    %100000000
mMBCCSR22_LCKT:     equ    %1000000000
mMBCCSR22_EDT:      equ    %10000000000
mMBCCSR22_CMT:      equ    %100000000000
mMBCCSR22_MTD:      equ    %1000000000000
mMBCCSR22_MBT:      equ    %10000000000000
mMBCCSR22_MCM:      equ    %100000000000000


;*** MBCCFR22 - Message Buffer Configuration, Control, Status Registers; 0x000005B2 ***
MBCCFR22:           equ    $000005B2                                ;*** MBCCFR22 - Message Buffer Configuration, Control, Status Registers; 0x000005B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR22_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR22_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR22_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR22_CHB:       equ    13                                        ; Channel Assignment
MBCCFR22_CHA:       equ    14                                        ; Channel Assignment
MBCCFR22_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR22_CCFVAL:   equ    %00111111
mMBCCFR22_CCFMSK:   equ    %111111000000
mMBCCFR22_CCFE:     equ    %1000000000000
mMBCCFR22_CHB:      equ    %10000000000000
mMBCCFR22_CHA:      equ    %100000000000000
mMBCCFR22_MTM:      equ    %1000000000000000


;*** MBFIDR22 - Message Buffer Frame ID Registers; 0x000005B4 ***
MBFIDR22:           equ    $000005B4                                ;*** MBFIDR22 - Message Buffer Frame ID Registers; 0x000005B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR22_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR22_FID:      equ    %11111111111


;*** MBIDXR22 - Message Buffer Index Registers; 0x000005B6 ***
MBIDXR22:           equ    $000005B6                                ;*** MBIDXR22 - Message Buffer Index Registers; 0x000005B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR22_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR22_MBIDX:    equ    %00111111


;*** MBCCSR23 - Message Buffer Configuration, Control, Status Registers; 0x000005B8 ***
MBCCSR23:           equ    $000005B8                                ;*** MBCCSR23 - Message Buffer Configuration, Control, Status Registers; 0x000005B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR23_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR23_LCKS:      equ    1                                         ; Lock Status
MBCCSR23_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR23_DVAL:      equ    3                                         ; Data Valid
MBCCSR23_DUP:       equ    4                                         ; Data Updated
MBCCSR23_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR23_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR23_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR23_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR23_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR23_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR23_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR23_MBIF:     equ    %00000001
mMBCCSR23_LCKS:     equ    %00000010
mMBCCSR23_EDS:      equ    %00000100
mMBCCSR23_DVAL:     equ    %00001000
mMBCCSR23_DUP:      equ    %00010000
mMBCCSR23_MBIE:     equ    %100000000
mMBCCSR23_LCKT:     equ    %1000000000
mMBCCSR23_EDT:      equ    %10000000000
mMBCCSR23_CMT:      equ    %100000000000
mMBCCSR23_MTD:      equ    %1000000000000
mMBCCSR23_MBT:      equ    %10000000000000
mMBCCSR23_MCM:      equ    %100000000000000


;*** MBCCFR23 - Message Buffer Configuration, Control, Status Registers; 0x000005BA ***
MBCCFR23:           equ    $000005BA                                ;*** MBCCFR23 - Message Buffer Configuration, Control, Status Registers; 0x000005BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR23_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR23_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR23_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR23_CHB:       equ    13                                        ; Channel Assignment
MBCCFR23_CHA:       equ    14                                        ; Channel Assignment
MBCCFR23_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR23_CCFVAL:   equ    %00111111
mMBCCFR23_CCFMSK:   equ    %111111000000
mMBCCFR23_CCFE:     equ    %1000000000000
mMBCCFR23_CHB:      equ    %10000000000000
mMBCCFR23_CHA:      equ    %100000000000000
mMBCCFR23_MTM:      equ    %1000000000000000


;*** MBFIDR23 - Message Buffer Frame ID Registers; 0x000005BC ***
MBFIDR23:           equ    $000005BC                                ;*** MBFIDR23 - Message Buffer Frame ID Registers; 0x000005BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR23_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR23_FID:      equ    %11111111111


;*** MBIDXR23 - Message Buffer Index Registers; 0x000005BE ***
MBIDXR23:           equ    $000005BE                                ;*** MBIDXR23 - Message Buffer Index Registers; 0x000005BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR23_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR23_MBIDX:    equ    %00111111


;*** MBCCSR24 - Message Buffer Configuration, Control, Status Registers; 0x000005C0 ***
MBCCSR24:           equ    $000005C0                                ;*** MBCCSR24 - Message Buffer Configuration, Control, Status Registers; 0x000005C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR24_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR24_LCKS:      equ    1                                         ; Lock Status
MBCCSR24_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR24_DVAL:      equ    3                                         ; Data Valid
MBCCSR24_DUP:       equ    4                                         ; Data Updated
MBCCSR24_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR24_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR24_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR24_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR24_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR24_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR24_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR24_MBIF:     equ    %00000001
mMBCCSR24_LCKS:     equ    %00000010
mMBCCSR24_EDS:      equ    %00000100
mMBCCSR24_DVAL:     equ    %00001000
mMBCCSR24_DUP:      equ    %00010000
mMBCCSR24_MBIE:     equ    %100000000
mMBCCSR24_LCKT:     equ    %1000000000
mMBCCSR24_EDT:      equ    %10000000000
mMBCCSR24_CMT:      equ    %100000000000
mMBCCSR24_MTD:      equ    %1000000000000
mMBCCSR24_MBT:      equ    %10000000000000
mMBCCSR24_MCM:      equ    %100000000000000


;*** MBCCFR24 - Message Buffer Configuration, Control, Status Registers; 0x000005C2 ***
MBCCFR24:           equ    $000005C2                                ;*** MBCCFR24 - Message Buffer Configuration, Control, Status Registers; 0x000005C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR24_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR24_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR24_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR24_CHB:       equ    13                                        ; Channel Assignment
MBCCFR24_CHA:       equ    14                                        ; Channel Assignment
MBCCFR24_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR24_CCFVAL:   equ    %00111111
mMBCCFR24_CCFMSK:   equ    %111111000000
mMBCCFR24_CCFE:     equ    %1000000000000
mMBCCFR24_CHB:      equ    %10000000000000
mMBCCFR24_CHA:      equ    %100000000000000
mMBCCFR24_MTM:      equ    %1000000000000000


;*** MBFIDR24 - Message Buffer Frame ID Registers; 0x000005C4 ***
MBFIDR24:           equ    $000005C4                                ;*** MBFIDR24 - Message Buffer Frame ID Registers; 0x000005C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR24_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR24_FID:      equ    %11111111111


;*** MBIDXR24 - Message Buffer Index Registers; 0x000005C6 ***
MBIDXR24:           equ    $000005C6                                ;*** MBIDXR24 - Message Buffer Index Registers; 0x000005C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR24_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR24_MBIDX:    equ    %00111111


;*** MBCCSR25 - Message Buffer Configuration, Control, Status Registers; 0x000005C8 ***
MBCCSR25:           equ    $000005C8                                ;*** MBCCSR25 - Message Buffer Configuration, Control, Status Registers; 0x000005C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR25_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR25_LCKS:      equ    1                                         ; Lock Status
MBCCSR25_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR25_DVAL:      equ    3                                         ; Data Valid
MBCCSR25_DUP:       equ    4                                         ; Data Updated
MBCCSR25_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR25_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR25_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR25_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR25_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR25_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR25_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR25_MBIF:     equ    %00000001
mMBCCSR25_LCKS:     equ    %00000010
mMBCCSR25_EDS:      equ    %00000100
mMBCCSR25_DVAL:     equ    %00001000
mMBCCSR25_DUP:      equ    %00010000
mMBCCSR25_MBIE:     equ    %100000000
mMBCCSR25_LCKT:     equ    %1000000000
mMBCCSR25_EDT:      equ    %10000000000
mMBCCSR25_CMT:      equ    %100000000000
mMBCCSR25_MTD:      equ    %1000000000000
mMBCCSR25_MBT:      equ    %10000000000000
mMBCCSR25_MCM:      equ    %100000000000000


;*** MBCCFR25 - Message Buffer Configuration, Control, Status Registers; 0x000005CA ***
MBCCFR25:           equ    $000005CA                                ;*** MBCCFR25 - Message Buffer Configuration, Control, Status Registers; 0x000005CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR25_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR25_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR25_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR25_CHB:       equ    13                                        ; Channel Assignment
MBCCFR25_CHA:       equ    14                                        ; Channel Assignment
MBCCFR25_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR25_CCFVAL:   equ    %00111111
mMBCCFR25_CCFMSK:   equ    %111111000000
mMBCCFR25_CCFE:     equ    %1000000000000
mMBCCFR25_CHB:      equ    %10000000000000
mMBCCFR25_CHA:      equ    %100000000000000
mMBCCFR25_MTM:      equ    %1000000000000000


;*** MBFIDR25 - Message Buffer Frame ID Registers; 0x000005CC ***
MBFIDR25:           equ    $000005CC                                ;*** MBFIDR25 - Message Buffer Frame ID Registers; 0x000005CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR25_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR25_FID:      equ    %11111111111


;*** MBIDXR25 - Message Buffer Index Registers; 0x000005CE ***
MBIDXR25:           equ    $000005CE                                ;*** MBIDXR25 - Message Buffer Index Registers; 0x000005CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR25_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR25_MBIDX:    equ    %00111111


;*** MBCCSR26 - Message Buffer Configuration, Control, Status Registers; 0x000005D0 ***
MBCCSR26:           equ    $000005D0                                ;*** MBCCSR26 - Message Buffer Configuration, Control, Status Registers; 0x000005D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR26_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR26_LCKS:      equ    1                                         ; Lock Status
MBCCSR26_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR26_DVAL:      equ    3                                         ; Data Valid
MBCCSR26_DUP:       equ    4                                         ; Data Updated
MBCCSR26_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR26_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR26_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR26_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR26_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR26_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR26_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR26_MBIF:     equ    %00000001
mMBCCSR26_LCKS:     equ    %00000010
mMBCCSR26_EDS:      equ    %00000100
mMBCCSR26_DVAL:     equ    %00001000
mMBCCSR26_DUP:      equ    %00010000
mMBCCSR26_MBIE:     equ    %100000000
mMBCCSR26_LCKT:     equ    %1000000000
mMBCCSR26_EDT:      equ    %10000000000
mMBCCSR26_CMT:      equ    %100000000000
mMBCCSR26_MTD:      equ    %1000000000000
mMBCCSR26_MBT:      equ    %10000000000000
mMBCCSR26_MCM:      equ    %100000000000000


;*** MBCCFR26 - Message Buffer Configuration, Control, Status Registers; 0x000005D2 ***
MBCCFR26:           equ    $000005D2                                ;*** MBCCFR26 - Message Buffer Configuration, Control, Status Registers; 0x000005D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR26_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR26_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR26_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR26_CHB:       equ    13                                        ; Channel Assignment
MBCCFR26_CHA:       equ    14                                        ; Channel Assignment
MBCCFR26_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR26_CCFVAL:   equ    %00111111
mMBCCFR26_CCFMSK:   equ    %111111000000
mMBCCFR26_CCFE:     equ    %1000000000000
mMBCCFR26_CHB:      equ    %10000000000000
mMBCCFR26_CHA:      equ    %100000000000000
mMBCCFR26_MTM:      equ    %1000000000000000


;*** MBFIDR26 - Message Buffer Frame ID Registers; 0x000005D4 ***
MBFIDR26:           equ    $000005D4                                ;*** MBFIDR26 - Message Buffer Frame ID Registers; 0x000005D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR26_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR26_FID:      equ    %11111111111


;*** MBIDXR26 - Message Buffer Index Registers; 0x000005D6 ***
MBIDXR26:           equ    $000005D6                                ;*** MBIDXR26 - Message Buffer Index Registers; 0x000005D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR26_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR26_MBIDX:    equ    %00111111


;*** MBCCSR27 - Message Buffer Configuration, Control, Status Registers; 0x000005D8 ***
MBCCSR27:           equ    $000005D8                                ;*** MBCCSR27 - Message Buffer Configuration, Control, Status Registers; 0x000005D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR27_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR27_LCKS:      equ    1                                         ; Lock Status
MBCCSR27_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR27_DVAL:      equ    3                                         ; Data Valid
MBCCSR27_DUP:       equ    4                                         ; Data Updated
MBCCSR27_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR27_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR27_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR27_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR27_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR27_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR27_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR27_MBIF:     equ    %00000001
mMBCCSR27_LCKS:     equ    %00000010
mMBCCSR27_EDS:      equ    %00000100
mMBCCSR27_DVAL:     equ    %00001000
mMBCCSR27_DUP:      equ    %00010000
mMBCCSR27_MBIE:     equ    %100000000
mMBCCSR27_LCKT:     equ    %1000000000
mMBCCSR27_EDT:      equ    %10000000000
mMBCCSR27_CMT:      equ    %100000000000
mMBCCSR27_MTD:      equ    %1000000000000
mMBCCSR27_MBT:      equ    %10000000000000
mMBCCSR27_MCM:      equ    %100000000000000


;*** MBCCFR27 - Message Buffer Configuration, Control, Status Registers; 0x000005DA ***
MBCCFR27:           equ    $000005DA                                ;*** MBCCFR27 - Message Buffer Configuration, Control, Status Registers; 0x000005DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR27_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR27_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR27_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR27_CHB:       equ    13                                        ; Channel Assignment
MBCCFR27_CHA:       equ    14                                        ; Channel Assignment
MBCCFR27_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR27_CCFVAL:   equ    %00111111
mMBCCFR27_CCFMSK:   equ    %111111000000
mMBCCFR27_CCFE:     equ    %1000000000000
mMBCCFR27_CHB:      equ    %10000000000000
mMBCCFR27_CHA:      equ    %100000000000000
mMBCCFR27_MTM:      equ    %1000000000000000


;*** MBFIDR27 - Message Buffer Frame ID Registers; 0x000005DC ***
MBFIDR27:           equ    $000005DC                                ;*** MBFIDR27 - Message Buffer Frame ID Registers; 0x000005DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR27_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR27_FID:      equ    %11111111111


;*** MBIDXR27 - Message Buffer Index Registers; 0x000005DE ***
MBIDXR27:           equ    $000005DE                                ;*** MBIDXR27 - Message Buffer Index Registers; 0x000005DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR27_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR27_MBIDX:    equ    %00111111


;*** MBCCSR28 - Message Buffer Configuration, Control, Status Registers; 0x000005E0 ***
MBCCSR28:           equ    $000005E0                                ;*** MBCCSR28 - Message Buffer Configuration, Control, Status Registers; 0x000005E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR28_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR28_LCKS:      equ    1                                         ; Lock Status
MBCCSR28_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR28_DVAL:      equ    3                                         ; Data Valid
MBCCSR28_DUP:       equ    4                                         ; Data Updated
MBCCSR28_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR28_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR28_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR28_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR28_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR28_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR28_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR28_MBIF:     equ    %00000001
mMBCCSR28_LCKS:     equ    %00000010
mMBCCSR28_EDS:      equ    %00000100
mMBCCSR28_DVAL:     equ    %00001000
mMBCCSR28_DUP:      equ    %00010000
mMBCCSR28_MBIE:     equ    %100000000
mMBCCSR28_LCKT:     equ    %1000000000
mMBCCSR28_EDT:      equ    %10000000000
mMBCCSR28_CMT:      equ    %100000000000
mMBCCSR28_MTD:      equ    %1000000000000
mMBCCSR28_MBT:      equ    %10000000000000
mMBCCSR28_MCM:      equ    %100000000000000


;*** MBCCFR28 - Message Buffer Configuration, Control, Status Registers; 0x000005E2 ***
MBCCFR28:           equ    $000005E2                                ;*** MBCCFR28 - Message Buffer Configuration, Control, Status Registers; 0x000005E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR28_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR28_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR28_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR28_CHB:       equ    13                                        ; Channel Assignment
MBCCFR28_CHA:       equ    14                                        ; Channel Assignment
MBCCFR28_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR28_CCFVAL:   equ    %00111111
mMBCCFR28_CCFMSK:   equ    %111111000000
mMBCCFR28_CCFE:     equ    %1000000000000
mMBCCFR28_CHB:      equ    %10000000000000
mMBCCFR28_CHA:      equ    %100000000000000
mMBCCFR28_MTM:      equ    %1000000000000000


;*** MBFIDR28 - Message Buffer Frame ID Registers; 0x000005E4 ***
MBFIDR28:           equ    $000005E4                                ;*** MBFIDR28 - Message Buffer Frame ID Registers; 0x000005E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR28_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR28_FID:      equ    %11111111111


;*** MBIDXR28 - Message Buffer Index Registers; 0x000005E6 ***
MBIDXR28:           equ    $000005E6                                ;*** MBIDXR28 - Message Buffer Index Registers; 0x000005E6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR28_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR28_MBIDX:    equ    %00111111


;*** MBCCSR29 - Message Buffer Configuration, Control, Status Registers; 0x000005E8 ***
MBCCSR29:           equ    $000005E8                                ;*** MBCCSR29 - Message Buffer Configuration, Control, Status Registers; 0x000005E8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR29_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR29_LCKS:      equ    1                                         ; Lock Status
MBCCSR29_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR29_DVAL:      equ    3                                         ; Data Valid
MBCCSR29_DUP:       equ    4                                         ; Data Updated
MBCCSR29_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR29_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR29_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR29_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR29_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR29_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR29_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR29_MBIF:     equ    %00000001
mMBCCSR29_LCKS:     equ    %00000010
mMBCCSR29_EDS:      equ    %00000100
mMBCCSR29_DVAL:     equ    %00001000
mMBCCSR29_DUP:      equ    %00010000
mMBCCSR29_MBIE:     equ    %100000000
mMBCCSR29_LCKT:     equ    %1000000000
mMBCCSR29_EDT:      equ    %10000000000
mMBCCSR29_CMT:      equ    %100000000000
mMBCCSR29_MTD:      equ    %1000000000000
mMBCCSR29_MBT:      equ    %10000000000000
mMBCCSR29_MCM:      equ    %100000000000000


;*** MBCCFR29 - Message Buffer Configuration, Control, Status Registers; 0x000005EA ***
MBCCFR29:           equ    $000005EA                                ;*** MBCCFR29 - Message Buffer Configuration, Control, Status Registers; 0x000005EA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR29_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR29_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR29_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR29_CHB:       equ    13                                        ; Channel Assignment
MBCCFR29_CHA:       equ    14                                        ; Channel Assignment
MBCCFR29_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR29_CCFVAL:   equ    %00111111
mMBCCFR29_CCFMSK:   equ    %111111000000
mMBCCFR29_CCFE:     equ    %1000000000000
mMBCCFR29_CHB:      equ    %10000000000000
mMBCCFR29_CHA:      equ    %100000000000000
mMBCCFR29_MTM:      equ    %1000000000000000


;*** MBFIDR29 - Message Buffer Frame ID Registers; 0x000005EC ***
MBFIDR29:           equ    $000005EC                                ;*** MBFIDR29 - Message Buffer Frame ID Registers; 0x000005EC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR29_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR29_FID:      equ    %11111111111


;*** MBIDXR29 - Message Buffer Index Registers; 0x000005EE ***
MBIDXR29:           equ    $000005EE                                ;*** MBIDXR29 - Message Buffer Index Registers; 0x000005EE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR29_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR29_MBIDX:    equ    %00111111


;*** MBCCSR30 - Message Buffer Configuration, Control, Status Registers; 0x000005F0 ***
MBCCSR30:           equ    $000005F0                                ;*** MBCCSR30 - Message Buffer Configuration, Control, Status Registers; 0x000005F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR30_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR30_LCKS:      equ    1                                         ; Lock Status
MBCCSR30_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR30_DVAL:      equ    3                                         ; Data Valid
MBCCSR30_DUP:       equ    4                                         ; Data Updated
MBCCSR30_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR30_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR30_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR30_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR30_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR30_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR30_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR30_MBIF:     equ    %00000001
mMBCCSR30_LCKS:     equ    %00000010
mMBCCSR30_EDS:      equ    %00000100
mMBCCSR30_DVAL:     equ    %00001000
mMBCCSR30_DUP:      equ    %00010000
mMBCCSR30_MBIE:     equ    %100000000
mMBCCSR30_LCKT:     equ    %1000000000
mMBCCSR30_EDT:      equ    %10000000000
mMBCCSR30_CMT:      equ    %100000000000
mMBCCSR30_MTD:      equ    %1000000000000
mMBCCSR30_MBT:      equ    %10000000000000
mMBCCSR30_MCM:      equ    %100000000000000


;*** MBCCFR30 - Message Buffer Configuration, Control, Status Registers; 0x000005F2 ***
MBCCFR30:           equ    $000005F2                                ;*** MBCCFR30 - Message Buffer Configuration, Control, Status Registers; 0x000005F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR30_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR30_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR30_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR30_CHB:       equ    13                                        ; Channel Assignment
MBCCFR30_CHA:       equ    14                                        ; Channel Assignment
MBCCFR30_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR30_CCFVAL:   equ    %00111111
mMBCCFR30_CCFMSK:   equ    %111111000000
mMBCCFR30_CCFE:     equ    %1000000000000
mMBCCFR30_CHB:      equ    %10000000000000
mMBCCFR30_CHA:      equ    %100000000000000
mMBCCFR30_MTM:      equ    %1000000000000000


;*** MBFIDR30 - Message Buffer Frame ID Registers; 0x000005F4 ***
MBFIDR30:           equ    $000005F4                                ;*** MBFIDR30 - Message Buffer Frame ID Registers; 0x000005F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR30_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR30_FID:      equ    %11111111111


;*** MBIDXR30 - Message Buffer Index Registers; 0x000005F6 ***
MBIDXR30:           equ    $000005F6                                ;*** MBIDXR30 - Message Buffer Index Registers; 0x000005F6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR30_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR30_MBIDX:    equ    %00111111


;*** MBCCSR31 - Message Buffer Configuration, Control, Status Registers; 0x000005F8 ***
MBCCSR31:           equ    $000005F8                                ;*** MBCCSR31 - Message Buffer Configuration, Control, Status Registers; 0x000005F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCSR31_MBIF:      equ    0                                         ; Message Buffer Interrupt Flag
MBCCSR31_LCKS:      equ    1                                         ; Lock Status
MBCCSR31_EDS:       equ    2                                         ; Enable/Disable Status
MBCCSR31_DVAL:      equ    3                                         ; Data Valid
MBCCSR31_DUP:       equ    4                                         ; Data Updated
MBCCSR31_MBIE:      equ    8                                         ; Message Buffer Interrupt Enable
MBCCSR31_LCKT:      equ    9                                         ; Lock/Unlock Trigger
MBCCSR31_EDT:       equ    10                                        ; Enable/Disable Trigger
MBCCSR31_CMT:       equ    11                                        ; Commit for Transmission
MBCCSR31_MTD:       equ    12                                        ; Message Buffer Transfer Direction
MBCCSR31_MBT:       equ    13                                        ; Message Buffer Type
MBCCSR31_MCM:       equ    14                                        ; Message Buffer Commit Mode
; bit position masks
mMBCCSR31_MBIF:     equ    %00000001
mMBCCSR31_LCKS:     equ    %00000010
mMBCCSR31_EDS:      equ    %00000100
mMBCCSR31_DVAL:     equ    %00001000
mMBCCSR31_DUP:      equ    %00010000
mMBCCSR31_MBIE:     equ    %100000000
mMBCCSR31_LCKT:     equ    %1000000000
mMBCCSR31_EDT:      equ    %10000000000
mMBCCSR31_CMT:      equ    %100000000000
mMBCCSR31_MTD:      equ    %1000000000000
mMBCCSR31_MBT:      equ    %10000000000000
mMBCCSR31_MCM:      equ    %100000000000000


;*** MBCCFR31 - Message Buffer Configuration, Control, Status Registers; 0x000005FA ***
MBCCFR31:           equ    $000005FA                                ;*** MBCCFR31 - Message Buffer Configuration, Control, Status Registers; 0x000005FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBCCFR31_CCFVAL:    equ    0                                         ; Cycle Counter Filtering Value
MBCCFR31_CCFMSK:    equ    6                                         ; Cycle Counter Filtering Mask
MBCCFR31_CCFE:      equ    12                                        ; Cycle Counter Filtering Enable
MBCCFR31_CHB:       equ    13                                        ; Channel Assignment
MBCCFR31_CHA:       equ    14                                        ; Channel Assignment
MBCCFR31_MTM:       equ    15                                        ; Message Buffer Transmission Mode
; bit position masks
mMBCCFR31_CCFVAL:   equ    %00111111
mMBCCFR31_CCFMSK:   equ    %111111000000
mMBCCFR31_CCFE:     equ    %1000000000000
mMBCCFR31_CHB:      equ    %10000000000000
mMBCCFR31_CHA:      equ    %100000000000000
mMBCCFR31_MTM:      equ    %1000000000000000


;*** MBFIDR31 - Message Buffer Frame ID Registers; 0x000005FC ***
MBFIDR31:           equ    $000005FC                                ;*** MBFIDR31 - Message Buffer Frame ID Registers; 0x000005FC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBFIDR31_FID:       equ    0                                         ; Frame ID
; bit position masks
mMBFIDR31_FID:      equ    %11111111111


;*** MBIDXR31 - Message Buffer Index Registers; 0x000005FE ***
MBIDXR31:           equ    $000005FE                                ;*** MBIDXR31 - Message Buffer Index Registers; 0x000005FE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MBIDXR31_MBIDX:     equ    0                                         ; Message Buffer Index
; bit position masks
mMBIDXR31_MBIDX:    equ    %00111111


;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Comparison Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY:         equ    0                                         ; Backdoor Comparison Key Bits
; bit position masks
mBAKEY0_KEY:        equ    %1111111111111111


;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Comparison Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY:         equ    0                                         ; Backdoor Comparison Key Bits
; bit position masks
mBAKEY1_KEY:        equ    %1111111111111111


;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Comparison Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY:         equ    0                                         ; Backdoor Comparison Key Bits
; bit position masks
mBAKEY2_KEY:        equ    %1111111111111111


;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Comparison Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY:         equ    0                                         ; Backdoor Comparison Key Bits
; bit position masks
mBAKEY3_KEY:        equ    %1111111111111111


;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
NVFPROT:            equ    $0000FF0C                                ;*** NVFPROT - Non Volatile P-Flash Protection Register; 0x0000FF0C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT_FPLS0:      equ    0                                         ; Flash Protection Lower Address Size Bit 0
NVFPROT_FPLS1:      equ    1                                         ; Flash Protection Lower Address Size Bit 1
NVFPROT_FPLDIS:     equ    2                                         ; Flash Protection Lower Address Range Disable
NVFPROT_FPHS0:      equ    3                                         ; Flash Protection Higher Address Size Bit 0
NVFPROT_FPHS1:      equ    4                                         ; Flash Protection Higher Address Size Bit 1
NVFPROT_FPHDIS:     equ    5                                         ; Flash Protection Higher Address Range Disable
NVFPROT_RNV6:       equ    6                                         ; Reserved Nonvolatile Bit
NVFPROT_FPOPEN:     equ    7                                         ; Flash Protection Operation Enable
; bit position masks
mNVFPROT_FPLS0:     equ    %00000001
mNVFPROT_FPLS1:     equ    %00000010
mNVFPROT_FPLDIS:    equ    %00000100
mNVFPROT_FPHS0:     equ    %00001000
mNVFPROT_FPHS1:     equ    %00010000
mNVFPROT_FPHDIS:    equ    %00100000
mNVFPROT_RNV6:      equ    %01000000
mNVFPROT_FPOPEN:    equ    %10000000


;*** NVEPROT - Non Volatile EEE Protection Register; 0x0000FF0D ***
NVEPROT:            equ    $0000FF0D                                ;*** NVEPROT - Non Volatile EEE Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVEPROT_EPS0:       equ    0                                         ; Buffer RAM Protection Size 0
NVEPROT_EPS1:       equ    1                                         ; Buffer RAM Protection Size 1
NVEPROT_EPS2:       equ    2                                         ; Buffer RAM Protection Size 2
NVEPROT_EPDIS:      equ    3                                         ; Buffer RAM Protection Address Range Disable
NVEPROT_RNV4:       equ    4                                         ; Reserved Non-volatile Bits
NVEPROT_RNV5:       equ    5                                         ; Reserved Non-volatile Bit 1
NVEPROT_RNV6:       equ    6                                         ; Reserved Non-volatile Bit 2
NVEPROT_EPOPEN:     equ    7                                         ; Enables writes to Buffer RAM partitioned for EEE
; bit position masks
mNVEPROT_EPS0:      equ    %00000001
mNVEPROT_EPS1:      equ    %00000010
mNVEPROT_EPS2:      equ    %00000100
mNVEPROT_EPDIS:     equ    %00001000
mNVEPROT_RNV4:      equ    %00010000
mNVEPROT_RNV5:      equ    %00100000
mNVEPROT_RNV6:      equ    %01000000
mNVEPROT_EPOPEN:    equ    %10000000


;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
NVFOPT:             equ    $0000FF0E                                ;*** NVFOPT - Non Volatile Flash Option Register; 0x0000FF0E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFOPT_NV0:         equ    0                                         ; Nonvolatile Bit 0
NVFOPT_NV1:         equ    1                                         ; Nonvolatile Bit 1
NVFOPT_NV2:         equ    2                                         ; Nonvolatile Bit 2
NVFOPT_NV3:         equ    3                                         ; Nonvolatile Bit 3
NVFOPT_NV4:         equ    4                                         ; Nonvolatile Bit 4
NVFOPT_NV5:         equ    5                                         ; Nonvolatile Bit 5
NVFOPT_NV6:         equ    6                                         ; Nonvolatile Bit 6
NVFOPT_NV7:         equ    7                                         ; Nonvolatile Bit 7
; bit position masks
mNVFOPT_NV0:        equ    %00000001
mNVFOPT_NV1:        equ    %00000010
mNVFOPT_NV2:        equ    %00000100
mNVFOPT_NV3:        equ    %00001000
mNVFOPT_NV4:        equ    %00010000
mNVFOPT_NV5:        equ    %00100000
mNVFOPT_NV6:        equ    %01000000
mNVFOPT_NV7:        equ    %10000000


;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non Volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Flash Security Bit 0
NVFSEC_SEC1:        equ    1                                         ; Flash Security Bit 1
NVFSEC_RNV2:        equ    2                                         ; Reserved Nonvolatile Bit 2
NVFSEC_RNV3:        equ    3                                         ; Reserved Nonvolatile Bit 3
NVFSEC_RNV4:        equ    4                                         ; Reserved Nonvolatile Bit 4
NVFSEC_RNV5:        equ    5                                         ; Reserved Nonvolatile Bit 5
NVFSEC_KEYEN0:      equ    6                                         ; Backdoor Key Security Enable Bit 0
NVFSEC_KEYEN1:      equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_RNV2:       equ    %00000100
mNVFSEC_RNV3:       equ    %00001000
mNVFSEC_RNV4:       equ    %00010000
mNVFSEC_RNV5:       equ    %00100000
mNVFSEC_KEYEN0:     equ    %01000000
mNVFSEC_KEYEN1:     equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------



; **** 12.10.2007 8:52:04

        IFNDEF __GENERATE_APPLICATION__
VReserved65:                             equ        Vhti
MMCCTL0_CS0E:                            equ        This_symb_has_been_depreciated
MMCCTL0_CS1E:                            equ        This_symb_has_been_depreciated
MMCCTL0_CS2E:                            equ        This_symb_has_been_depreciated
MMCCTL0_CS3E:                            equ        This_symb_has_been_depreciated
mMMCCTL0_CS0E:                           equ        This_symb_has_been_depreciated
mMMCCTL0_CS1E:                           equ        This_symb_has_been_depreciated
mMMCCTL0_CS2E:                           equ        This_symb_has_been_depreciated
mMMCCTL0_CS3E:                           equ        This_symb_has_been_depreciated
SYNR_VCOFRQ:                             equ        This_symb_has_been_depreciated
mSYNR_VCOFRQ:                            equ        This_symb_has_been_depreciated
REFDV_REFFRQ:                            equ        This_symb_has_been_depreciated
mREFDV_REFFRQ:                           equ        This_symb_has_been_depreciated
POSTDIV_POSTDIV:                         equ        This_symb_has_been_depreciated
mPOSTDIV_POSTDIV:                        equ        This_symb_has_been_depreciated
PA3H_PA3H0:                              equ        This_symb_has_been_depreciated
PA3H_PA3H1:                              equ        This_symb_has_been_depreciated
PA3H_PA3H2:                              equ        This_symb_has_been_depreciated
PA3H_PA3H3:                              equ        This_symb_has_been_depreciated
PA3H_PA3H4:                              equ        This_symb_has_been_depreciated
PA3H_PA3H5:                              equ        This_symb_has_been_depreciated
PA3H_PA3H6:                              equ        This_symb_has_been_depreciated
PA3H_PA3H7:                              equ        This_symb_has_been_depreciated
mPA3H_PA3H0:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H1:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H2:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H3:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H4:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H5:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H6:                             equ        This_symb_has_been_depreciated
mPA3H_PA3H7:                             equ        This_symb_has_been_depreciated
PA2H_PA2H0:                              equ        This_symb_has_been_depreciated
PA2H_PA2H1:                              equ        This_symb_has_been_depreciated
PA2H_PA2H2:                              equ        This_symb_has_been_depreciated
PA2H_PA2H3:                              equ        This_symb_has_been_depreciated
PA2H_PA2H4:                              equ        This_symb_has_been_depreciated
PA2H_PA2H5:                              equ        This_symb_has_been_depreciated
PA2H_PA2H6:                              equ        This_symb_has_been_depreciated
PA2H_PA2H7:                              equ        This_symb_has_been_depreciated
mPA2H_PA2H0:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H1:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H2:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H3:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H4:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H5:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H6:                             equ        This_symb_has_been_depreciated
mPA2H_PA2H7:                             equ        This_symb_has_been_depreciated
PA1H_PA1H0:                              equ        This_symb_has_been_depreciated
PA1H_PA1H1:                              equ        This_symb_has_been_depreciated
PA1H_PA1H2:                              equ        This_symb_has_been_depreciated
PA1H_PA1H3:                              equ        This_symb_has_been_depreciated
PA1H_PA1H4:                              equ        This_symb_has_been_depreciated
PA1H_PA1H5:                              equ        This_symb_has_been_depreciated
PA1H_PA1H6:                              equ        This_symb_has_been_depreciated
PA1H_PA1H7:                              equ        This_symb_has_been_depreciated
mPA1H_PA1H0:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H1:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H2:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H3:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H4:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H5:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H6:                             equ        This_symb_has_been_depreciated
mPA1H_PA1H7:                             equ        This_symb_has_been_depreciated
PA0H_PA0H0:                              equ        This_symb_has_been_depreciated
PA0H_PA0H1:                              equ        This_symb_has_been_depreciated
PA0H_PA0H2:                              equ        This_symb_has_been_depreciated
PA0H_PA0H3:                              equ        This_symb_has_been_depreciated
PA0H_PA0H4:                              equ        This_symb_has_been_depreciated
PA0H_PA0H5:                              equ        This_symb_has_been_depreciated
PA0H_PA0H6:                              equ        This_symb_has_been_depreciated
PA0H_PA0H7:                              equ        This_symb_has_been_depreciated
mPA0H_PA0H0:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H1:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H2:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H3:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H4:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H5:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H6:                             equ        This_symb_has_been_depreciated
mPA0H_PA0H7:                             equ        This_symb_has_been_depreciated
TC0H_BIT0:                               equ        This_symb_has_been_depreciated
TC0H_BIT1:                               equ        This_symb_has_been_depreciated
TC0H_BIT2:                               equ        This_symb_has_been_depreciated
TC0H_BIT3:                               equ        This_symb_has_been_depreciated
TC0H_BIT4:                               equ        This_symb_has_been_depreciated
TC0H_BIT5:                               equ        This_symb_has_been_depreciated
TC0H_BIT6:                               equ        This_symb_has_been_depreciated
TC0H_BIT7:                               equ        This_symb_has_been_depreciated
TC0H_BIT8:                               equ        This_symb_has_been_depreciated
TC0H_BIT9:                               equ        This_symb_has_been_depreciated
TC0H_BIT10:                              equ        This_symb_has_been_depreciated
TC0H_BIT11:                              equ        This_symb_has_been_depreciated
TC0H_BIT12:                              equ        This_symb_has_been_depreciated
TC0H_BIT13:                              equ        This_symb_has_been_depreciated
TC0H_BIT14:                              equ        This_symb_has_been_depreciated
TC0H_BIT15:                              equ        This_symb_has_been_depreciated
mTC0H_BIT0:                              equ        This_symb_has_been_depreciated
mTC0H_BIT1:                              equ        This_symb_has_been_depreciated
mTC0H_BIT2:                              equ        This_symb_has_been_depreciated
mTC0H_BIT3:                              equ        This_symb_has_been_depreciated
mTC0H_BIT4:                              equ        This_symb_has_been_depreciated
mTC0H_BIT5:                              equ        This_symb_has_been_depreciated
mTC0H_BIT6:                              equ        This_symb_has_been_depreciated
mTC0H_BIT7:                              equ        This_symb_has_been_depreciated
mTC0H_BIT8:                              equ        This_symb_has_been_depreciated
mTC0H_BIT9:                              equ        This_symb_has_been_depreciated
mTC0H_BIT10:                             equ        This_symb_has_been_depreciated
mTC0H_BIT11:                             equ        This_symb_has_been_depreciated
mTC0H_BIT12:                             equ        This_symb_has_been_depreciated
mTC0H_BIT13:                             equ        This_symb_has_been_depreciated
mTC0H_BIT14:                             equ        This_symb_has_been_depreciated
mTC0H_BIT15:                             equ        This_symb_has_been_depreciated
TC0Hhi_BIT8:                             equ        This_symb_has_been_depreciated
TC0Hhi_BIT9:                             equ        This_symb_has_been_depreciated
TC0Hhi_BIT10:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT11:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT12:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT13:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT14:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT15:                            equ        This_symb_has_been_depreciated
mTC0Hhi_BIT8:                            equ        This_symb_has_been_depreciated
mTC0Hhi_BIT9:                            equ        This_symb_has_been_depreciated
mTC0Hhi_BIT10:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT11:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT12:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT13:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT14:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT15:                           equ        This_symb_has_been_depreciated
TC0Hlo_BIT0:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT1:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT2:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT3:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT4:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT5:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT6:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT7:                             equ        This_symb_has_been_depreciated
mTC0Hlo_BIT0:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT1:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT2:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT3:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT4:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT5:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT6:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT7:                            equ        This_symb_has_been_depreciated
TC1H_BIT0:                               equ        This_symb_has_been_depreciated
TC1H_BIT1:                               equ        This_symb_has_been_depreciated
TC1H_BIT2:                               equ        This_symb_has_been_depreciated
TC1H_BIT3:                               equ        This_symb_has_been_depreciated
TC1H_BIT4:                               equ        This_symb_has_been_depreciated
TC1H_BIT5:                               equ        This_symb_has_been_depreciated
TC1H_BIT6:                               equ        This_symb_has_been_depreciated
TC1H_BIT7:                               equ        This_symb_has_been_depreciated
TC1H_BIT8:                               equ        This_symb_has_been_depreciated
TC1H_BIT9:                               equ        This_symb_has_been_depreciated
TC1H_BIT10:                              equ        This_symb_has_been_depreciated
TC1H_BIT11:                              equ        This_symb_has_been_depreciated
TC1H_BIT12:                              equ        This_symb_has_been_depreciated
TC1H_BIT13:                              equ        This_symb_has_been_depreciated
TC1H_BIT14:                              equ        This_symb_has_been_depreciated
TC1H_BIT15:                              equ        This_symb_has_been_depreciated
mTC1H_BIT0:                              equ        This_symb_has_been_depreciated
mTC1H_BIT1:                              equ        This_symb_has_been_depreciated
mTC1H_BIT2:                              equ        This_symb_has_been_depreciated
mTC1H_BIT3:                              equ        This_symb_has_been_depreciated
mTC1H_BIT4:                              equ        This_symb_has_been_depreciated
mTC1H_BIT5:                              equ        This_symb_has_been_depreciated
mTC1H_BIT6:                              equ        This_symb_has_been_depreciated
mTC1H_BIT7:                              equ        This_symb_has_been_depreciated
mTC1H_BIT8:                              equ        This_symb_has_been_depreciated
mTC1H_BIT9:                              equ        This_symb_has_been_depreciated
mTC1H_BIT10:                             equ        This_symb_has_been_depreciated
mTC1H_BIT11:                             equ        This_symb_has_been_depreciated
mTC1H_BIT12:                             equ        This_symb_has_been_depreciated
mTC1H_BIT13:                             equ        This_symb_has_been_depreciated
mTC1H_BIT14:                             equ        This_symb_has_been_depreciated
mTC1H_BIT15:                             equ        This_symb_has_been_depreciated
TC1Hhi_BIT8:                             equ        This_symb_has_been_depreciated
TC1Hhi_BIT9:                             equ        This_symb_has_been_depreciated
TC1Hhi_BIT10:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT11:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT12:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT13:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT14:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT15:                            equ        This_symb_has_been_depreciated
mTC1Hhi_BIT8:                            equ        This_symb_has_been_depreciated
mTC1Hhi_BIT9:                            equ        This_symb_has_been_depreciated
mTC1Hhi_BIT10:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT11:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT12:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT13:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT14:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT15:                           equ        This_symb_has_been_depreciated
TC1Hlo_BIT0:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT1:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT2:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT3:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT4:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT5:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT6:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT7:                             equ        This_symb_has_been_depreciated
mTC1Hlo_BIT0:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT1:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT2:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT3:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT4:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT5:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT6:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT7:                            equ        This_symb_has_been_depreciated
TC2H_BIT0:                               equ        This_symb_has_been_depreciated
TC2H_BIT1:                               equ        This_symb_has_been_depreciated
TC2H_BIT2:                               equ        This_symb_has_been_depreciated
TC2H_BIT3:                               equ        This_symb_has_been_depreciated
TC2H_BIT4:                               equ        This_symb_has_been_depreciated
TC2H_BIT5:                               equ        This_symb_has_been_depreciated
TC2H_BIT6:                               equ        This_symb_has_been_depreciated
TC2H_BIT7:                               equ        This_symb_has_been_depreciated
TC2H_BIT8:                               equ        This_symb_has_been_depreciated
TC2H_BIT9:                               equ        This_symb_has_been_depreciated
TC2H_BIT10:                              equ        This_symb_has_been_depreciated
TC2H_BIT11:                              equ        This_symb_has_been_depreciated
TC2H_BIT12:                              equ        This_symb_has_been_depreciated
TC2H_BIT13:                              equ        This_symb_has_been_depreciated
TC2H_BIT14:                              equ        This_symb_has_been_depreciated
TC2H_BIT15:                              equ        This_symb_has_been_depreciated
mTC2H_BIT0:                              equ        This_symb_has_been_depreciated
mTC2H_BIT1:                              equ        This_symb_has_been_depreciated
mTC2H_BIT2:                              equ        This_symb_has_been_depreciated
mTC2H_BIT3:                              equ        This_symb_has_been_depreciated
mTC2H_BIT4:                              equ        This_symb_has_been_depreciated
mTC2H_BIT5:                              equ        This_symb_has_been_depreciated
mTC2H_BIT6:                              equ        This_symb_has_been_depreciated
mTC2H_BIT7:                              equ        This_symb_has_been_depreciated
mTC2H_BIT8:                              equ        This_symb_has_been_depreciated
mTC2H_BIT9:                              equ        This_symb_has_been_depreciated
mTC2H_BIT10:                             equ        This_symb_has_been_depreciated
mTC2H_BIT11:                             equ        This_symb_has_been_depreciated
mTC2H_BIT12:                             equ        This_symb_has_been_depreciated
mTC2H_BIT13:                             equ        This_symb_has_been_depreciated
mTC2H_BIT14:                             equ        This_symb_has_been_depreciated
mTC2H_BIT15:                             equ        This_symb_has_been_depreciated
TC2Hhi_BIT8:                             equ        This_symb_has_been_depreciated
TC2Hhi_BIT9:                             equ        This_symb_has_been_depreciated
TC2Hhi_BIT10:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT11:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT12:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT13:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT14:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT15:                            equ        This_symb_has_been_depreciated
mTC2Hhi_BIT8:                            equ        This_symb_has_been_depreciated
mTC2Hhi_BIT9:                            equ        This_symb_has_been_depreciated
mTC2Hhi_BIT10:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT11:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT12:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT13:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT14:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT15:                           equ        This_symb_has_been_depreciated
TC2Hlo_BIT0:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT1:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT2:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT3:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT4:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT5:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT6:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT7:                             equ        This_symb_has_been_depreciated
mTC2Hlo_BIT0:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT1:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT2:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT3:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT4:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT5:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT6:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT7:                            equ        This_symb_has_been_depreciated
TC3H_BIT0:                               equ        This_symb_has_been_depreciated
TC3H_BIT1:                               equ        This_symb_has_been_depreciated
TC3H_BIT2:                               equ        This_symb_has_been_depreciated
TC3H_BIT3:                               equ        This_symb_has_been_depreciated
TC3H_BIT4:                               equ        This_symb_has_been_depreciated
TC3H_BIT5:                               equ        This_symb_has_been_depreciated
TC3H_BIT6:                               equ        This_symb_has_been_depreciated
TC3H_BIT7:                               equ        This_symb_has_been_depreciated
TC3H_BIT8:                               equ        This_symb_has_been_depreciated
TC3H_BIT9:                               equ        This_symb_has_been_depreciated
TC3H_BIT10:                              equ        This_symb_has_been_depreciated
TC3H_BIT11:                              equ        This_symb_has_been_depreciated
TC3H_BIT12:                              equ        This_symb_has_been_depreciated
TC3H_BIT13:                              equ        This_symb_has_been_depreciated
TC3H_BIT14:                              equ        This_symb_has_been_depreciated
TC3H_BIT15:                              equ        This_symb_has_been_depreciated
mTC3H_BIT0:                              equ        This_symb_has_been_depreciated
mTC3H_BIT1:                              equ        This_symb_has_been_depreciated
mTC3H_BIT2:                              equ        This_symb_has_been_depreciated
mTC3H_BIT3:                              equ        This_symb_has_been_depreciated
mTC3H_BIT4:                              equ        This_symb_has_been_depreciated
mTC3H_BIT5:                              equ        This_symb_has_been_depreciated
mTC3H_BIT6:                              equ        This_symb_has_been_depreciated
mTC3H_BIT7:                              equ        This_symb_has_been_depreciated
mTC3H_BIT8:                              equ        This_symb_has_been_depreciated
mTC3H_BIT9:                              equ        This_symb_has_been_depreciated
mTC3H_BIT10:                             equ        This_symb_has_been_depreciated
mTC3H_BIT11:                             equ        This_symb_has_been_depreciated
mTC3H_BIT12:                             equ        This_symb_has_been_depreciated
mTC3H_BIT13:                             equ        This_symb_has_been_depreciated
mTC3H_BIT14:                             equ        This_symb_has_been_depreciated
mTC3H_BIT15:                             equ        This_symb_has_been_depreciated
TC3Hhi_BIT8:                             equ        This_symb_has_been_depreciated
TC3Hhi_BIT9:                             equ        This_symb_has_been_depreciated
TC3Hhi_BIT10:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT11:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT12:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT13:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT14:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT15:                            equ        This_symb_has_been_depreciated
mTC3Hhi_BIT8:                            equ        This_symb_has_been_depreciated
mTC3Hhi_BIT9:                            equ        This_symb_has_been_depreciated
mTC3Hhi_BIT10:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT11:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT12:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT13:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT14:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT15:                           equ        This_symb_has_been_depreciated
TC3Hlo_BIT0:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT1:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT2:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT3:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT4:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT5:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT6:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT7:                             equ        This_symb_has_been_depreciated
mTC3Hlo_BIT0:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT1:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT2:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT3:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT4:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT5:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT6:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT7:                            equ        This_symb_has_been_depreciated
FCCOBIX_CCOBIX:                          equ        This_symb_has_been_depreciated
mFCCOBIX_CCOBIX:                         equ        This_symb_has_been_depreciated
FECCRIX_ECCRIX:                          equ        This_symb_has_been_depreciated
mFECCRIX_ECCRIX:                         equ        This_symb_has_been_depreciated
FSTAT_MGSTAT:                            equ        This_symb_has_been_depreciated
FSTAT_RSVD:                              equ        This_symb_has_been_depreciated
mFSTAT_MGSTAT:                           equ        This_symb_has_been_depreciated
mFSTAT_RSVD:                             equ        This_symb_has_been_depreciated
        ENDIF
CAN0RIDR0:                               equ        CAN0RXIDR0
CAN0RIDR0_ID21:                          equ        CAN0RXIDR0_ID21
CAN0RIDR0_ID22:                          equ        CAN0RXIDR0_ID22
CAN0RIDR0_ID23:                          equ        CAN0RXIDR0_ID23
CAN0RIDR0_ID24:                          equ        CAN0RXIDR0_ID24
CAN0RIDR0_ID25:                          equ        CAN0RXIDR0_ID25
CAN0RIDR0_ID26:                          equ        CAN0RXIDR0_ID26
CAN0RIDR0_ID27:                          equ        CAN0RXIDR0_ID27
CAN0RIDR0_ID28:                          equ        CAN0RXIDR0_ID28
mCAN0RIDR0_ID21:                         equ        mCAN0RXIDR0_ID21
mCAN0RIDR0_ID22:                         equ        mCAN0RXIDR0_ID22
mCAN0RIDR0_ID23:                         equ        mCAN0RXIDR0_ID23
mCAN0RIDR0_ID24:                         equ        mCAN0RXIDR0_ID24
mCAN0RIDR0_ID25:                         equ        mCAN0RXIDR0_ID25
mCAN0RIDR0_ID26:                         equ        mCAN0RXIDR0_ID26
mCAN0RIDR0_ID27:                         equ        mCAN0RXIDR0_ID27
mCAN0RIDR0_ID28:                         equ        mCAN0RXIDR0_ID28
CAN0RIDR1:                               equ        CAN0RXIDR1
CAN0RIDR1_ID15:                          equ        CAN0RXIDR1_ID15
CAN0RIDR1_ID16:                          equ        CAN0RXIDR1_ID16
CAN0RIDR1_ID17:                          equ        CAN0RXIDR1_ID17
CAN0RIDR1_IDE:                           equ        CAN0RXIDR1_IDE
CAN0RIDR1_SRR:                           equ        CAN0RXIDR1_SRR
CAN0RIDR1_ID18:                          equ        CAN0RXIDR1_ID18
CAN0RIDR1_ID19:                          equ        CAN0RXIDR1_ID19
CAN0RIDR1_ID20:                          equ        CAN0RXIDR1_ID20
mCAN0RIDR1_ID15:                         equ        mCAN0RXIDR1_ID15
mCAN0RIDR1_ID16:                         equ        mCAN0RXIDR1_ID16
mCAN0RIDR1_ID17:                         equ        mCAN0RXIDR1_ID17
mCAN0RIDR1_IDE:                          equ        mCAN0RXIDR1_IDE
mCAN0RIDR1_SRR:                          equ        mCAN0RXIDR1_SRR
mCAN0RIDR1_ID18:                         equ        mCAN0RXIDR1_ID18
mCAN0RIDR1_ID19:                         equ        mCAN0RXIDR1_ID19
mCAN0RIDR1_ID20:                         equ        mCAN0RXIDR1_ID20
CAN0RIDR2:                               equ        CAN0RXIDR2
CAN0RIDR2_ID7:                           equ        CAN0RXIDR2_ID7
CAN0RIDR2_ID8:                           equ        CAN0RXIDR2_ID8
CAN0RIDR2_ID9:                           equ        CAN0RXIDR2_ID9
CAN0RIDR2_ID10:                          equ        CAN0RXIDR2_ID10
CAN0RIDR2_ID11:                          equ        CAN0RXIDR2_ID11
CAN0RIDR2_ID12:                          equ        CAN0RXIDR2_ID12
CAN0RIDR2_ID13:                          equ        CAN0RXIDR2_ID13
CAN0RIDR2_ID14:                          equ        CAN0RXIDR2_ID14
mCAN0RIDR2_ID7:                          equ        mCAN0RXIDR2_ID7
mCAN0RIDR2_ID8:                          equ        mCAN0RXIDR2_ID8
mCAN0RIDR2_ID9:                          equ        mCAN0RXIDR2_ID9
mCAN0RIDR2_ID10:                         equ        mCAN0RXIDR2_ID10
mCAN0RIDR2_ID11:                         equ        mCAN0RXIDR2_ID11
mCAN0RIDR2_ID12:                         equ        mCAN0RXIDR2_ID12
mCAN0RIDR2_ID13:                         equ        mCAN0RXIDR2_ID13
mCAN0RIDR2_ID14:                         equ        mCAN0RXIDR2_ID14
CAN0RIDR3:                               equ        CAN0RXIDR3
CAN0RIDR3_RTR:                           equ        CAN0RXIDR3_RTR
CAN0RIDR3_ID0:                           equ        CAN0RXIDR3_ID0
CAN0RIDR3_ID1:                           equ        CAN0RXIDR3_ID1
CAN0RIDR3_ID2:                           equ        CAN0RXIDR3_ID2
CAN0RIDR3_ID3:                           equ        CAN0RXIDR3_ID3
CAN0RIDR3_ID4:                           equ        CAN0RXIDR3_ID4
CAN0RIDR3_ID5:                           equ        CAN0RXIDR3_ID5
CAN0RIDR3_ID6:                           equ        CAN0RXIDR3_ID6
mCAN0RIDR3_RTR:                          equ        mCAN0RXIDR3_RTR
mCAN0RIDR3_ID0:                          equ        mCAN0RXIDR3_ID0
mCAN0RIDR3_ID1:                          equ        mCAN0RXIDR3_ID1
mCAN0RIDR3_ID2:                          equ        mCAN0RXIDR3_ID2
mCAN0RIDR3_ID3:                          equ        mCAN0RXIDR3_ID3
mCAN0RIDR3_ID4:                          equ        mCAN0RXIDR3_ID4
mCAN0RIDR3_ID5:                          equ        mCAN0RXIDR3_ID5
mCAN0RIDR3_ID6:                          equ        mCAN0RXIDR3_ID6
CAN0RDSR0:                               equ        CAN0RXDSR0
CAN0RDSR0_DB0:                           equ        CAN0RXDSR0_DB0
CAN0RDSR0_DB1:                           equ        CAN0RXDSR0_DB1
CAN0RDSR0_DB2:                           equ        CAN0RXDSR0_DB2
CAN0RDSR0_DB3:                           equ        CAN0RXDSR0_DB3
CAN0RDSR0_DB4:                           equ        CAN0RXDSR0_DB4
CAN0RDSR0_DB5:                           equ        CAN0RXDSR0_DB5
CAN0RDSR0_DB6:                           equ        CAN0RXDSR0_DB6
CAN0RDSR0_DB7:                           equ        CAN0RXDSR0_DB7
mCAN0RDSR0_DB0:                          equ        mCAN0RXDSR0_DB0
mCAN0RDSR0_DB1:                          equ        mCAN0RXDSR0_DB1
mCAN0RDSR0_DB2:                          equ        mCAN0RXDSR0_DB2
mCAN0RDSR0_DB3:                          equ        mCAN0RXDSR0_DB3
mCAN0RDSR0_DB4:                          equ        mCAN0RXDSR0_DB4
mCAN0RDSR0_DB5:                          equ        mCAN0RXDSR0_DB5
mCAN0RDSR0_DB6:                          equ        mCAN0RXDSR0_DB6
mCAN0RDSR0_DB7:                          equ        mCAN0RXDSR0_DB7
CAN0RDSR1:                               equ        CAN0RXDSR1
CAN0RDSR1_DB0:                           equ        CAN0RXDSR1_DB0
CAN0RDSR1_DB1:                           equ        CAN0RXDSR1_DB1
CAN0RDSR1_DB2:                           equ        CAN0RXDSR1_DB2
CAN0RDSR1_DB3:                           equ        CAN0RXDSR1_DB3
CAN0RDSR1_DB4:                           equ        CAN0RXDSR1_DB4
CAN0RDSR1_DB5:                           equ        CAN0RXDSR1_DB5
CAN0RDSR1_DB6:                           equ        CAN0RXDSR1_DB6
CAN0RDSR1_DB7:                           equ        CAN0RXDSR1_DB7
mCAN0RDSR1_DB0:                          equ        mCAN0RXDSR1_DB0
mCAN0RDSR1_DB1:                          equ        mCAN0RXDSR1_DB1
mCAN0RDSR1_DB2:                          equ        mCAN0RXDSR1_DB2
mCAN0RDSR1_DB3:                          equ        mCAN0RXDSR1_DB3
mCAN0RDSR1_DB4:                          equ        mCAN0RXDSR1_DB4
mCAN0RDSR1_DB5:                          equ        mCAN0RXDSR1_DB5
mCAN0RDSR1_DB6:                          equ        mCAN0RXDSR1_DB6
mCAN0RDSR1_DB7:                          equ        mCAN0RXDSR1_DB7
CAN0RDSR2:                               equ        CAN0RXDSR2
CAN0RDSR2_DB0:                           equ        CAN0RXDSR2_DB0
CAN0RDSR2_DB1:                           equ        CAN0RXDSR2_DB1
CAN0RDSR2_DB2:                           equ        CAN0RXDSR2_DB2
CAN0RDSR2_DB3:                           equ        CAN0RXDSR2_DB3
CAN0RDSR2_DB4:                           equ        CAN0RXDSR2_DB4
CAN0RDSR2_DB5:                           equ        CAN0RXDSR2_DB5
CAN0RDSR2_DB6:                           equ        CAN0RXDSR2_DB6
CAN0RDSR2_DB7:                           equ        CAN0RXDSR2_DB7
mCAN0RDSR2_DB0:                          equ        mCAN0RXDSR2_DB0
mCAN0RDSR2_DB1:                          equ        mCAN0RXDSR2_DB1
mCAN0RDSR2_DB2:                          equ        mCAN0RXDSR2_DB2
mCAN0RDSR2_DB3:                          equ        mCAN0RXDSR2_DB3
mCAN0RDSR2_DB4:                          equ        mCAN0RXDSR2_DB4
mCAN0RDSR2_DB5:                          equ        mCAN0RXDSR2_DB5
mCAN0RDSR2_DB6:                          equ        mCAN0RXDSR2_DB6
mCAN0RDSR2_DB7:                          equ        mCAN0RXDSR2_DB7
CAN0RDSR3:                               equ        CAN0RXDSR3
CAN0RDSR3_DB0:                           equ        CAN0RXDSR3_DB0
CAN0RDSR3_DB1:                           equ        CAN0RXDSR3_DB1
CAN0RDSR3_DB2:                           equ        CAN0RXDSR3_DB2
CAN0RDSR3_DB3:                           equ        CAN0RXDSR3_DB3
CAN0RDSR3_DB4:                           equ        CAN0RXDSR3_DB4
CAN0RDSR3_DB5:                           equ        CAN0RXDSR3_DB5
CAN0RDSR3_DB6:                           equ        CAN0RXDSR3_DB6
CAN0RDSR3_DB7:                           equ        CAN0RXDSR3_DB7
mCAN0RDSR3_DB0:                          equ        mCAN0RXDSR3_DB0
mCAN0RDSR3_DB1:                          equ        mCAN0RXDSR3_DB1
mCAN0RDSR3_DB2:                          equ        mCAN0RXDSR3_DB2
mCAN0RDSR3_DB3:                          equ        mCAN0RXDSR3_DB3
mCAN0RDSR3_DB4:                          equ        mCAN0RXDSR3_DB4
mCAN0RDSR3_DB5:                          equ        mCAN0RXDSR3_DB5
mCAN0RDSR3_DB6:                          equ        mCAN0RXDSR3_DB6
mCAN0RDSR3_DB7:                          equ        mCAN0RXDSR3_DB7
CAN0RDSR4:                               equ        CAN0RXDSR4
CAN0RDSR4_DB0:                           equ        CAN0RXDSR4_DB0
CAN0RDSR4_DB1:                           equ        CAN0RXDSR4_DB1
CAN0RDSR4_DB2:                           equ        CAN0RXDSR4_DB2
CAN0RDSR4_DB3:                           equ        CAN0RXDSR4_DB3
CAN0RDSR4_DB4:                           equ        CAN0RXDSR4_DB4
CAN0RDSR4_DB5:                           equ        CAN0RXDSR4_DB5
CAN0RDSR4_DB6:                           equ        CAN0RXDSR4_DB6
CAN0RDSR4_DB7:                           equ        CAN0RXDSR4_DB7
mCAN0RDSR4_DB0:                          equ        mCAN0RXDSR4_DB0
mCAN0RDSR4_DB1:                          equ        mCAN0RXDSR4_DB1
mCAN0RDSR4_DB2:                          equ        mCAN0RXDSR4_DB2
mCAN0RDSR4_DB3:                          equ        mCAN0RXDSR4_DB3
mCAN0RDSR4_DB4:                          equ        mCAN0RXDSR4_DB4
mCAN0RDSR4_DB5:                          equ        mCAN0RXDSR4_DB5
mCAN0RDSR4_DB6:                          equ        mCAN0RXDSR4_DB6
mCAN0RDSR4_DB7:                          equ        mCAN0RXDSR4_DB7
CAN0RDSR5:                               equ        CAN0RXDSR5
CAN0RDSR5_DB0:                           equ        CAN0RXDSR5_DB0
CAN0RDSR5_DB1:                           equ        CAN0RXDSR5_DB1
CAN0RDSR5_DB2:                           equ        CAN0RXDSR5_DB2
CAN0RDSR5_DB3:                           equ        CAN0RXDSR5_DB3
CAN0RDSR5_DB4:                           equ        CAN0RXDSR5_DB4
CAN0RDSR5_DB5:                           equ        CAN0RXDSR5_DB5
CAN0RDSR5_DB6:                           equ        CAN0RXDSR5_DB6
CAN0RDSR5_DB7:                           equ        CAN0RXDSR5_DB7
mCAN0RDSR5_DB0:                          equ        mCAN0RXDSR5_DB0
mCAN0RDSR5_DB1:                          equ        mCAN0RXDSR5_DB1
mCAN0RDSR5_DB2:                          equ        mCAN0RXDSR5_DB2
mCAN0RDSR5_DB3:                          equ        mCAN0RXDSR5_DB3
mCAN0RDSR5_DB4:                          equ        mCAN0RXDSR5_DB4
mCAN0RDSR5_DB5:                          equ        mCAN0RXDSR5_DB5
mCAN0RDSR5_DB6:                          equ        mCAN0RXDSR5_DB6
mCAN0RDSR5_DB7:                          equ        mCAN0RXDSR5_DB7
CAN0RDSR6:                               equ        CAN0RXDSR6
CAN0RDSR6_DB0:                           equ        CAN0RXDSR6_DB0
CAN0RDSR6_DB1:                           equ        CAN0RXDSR6_DB1
CAN0RDSR6_DB2:                           equ        CAN0RXDSR6_DB2
CAN0RDSR6_DB3:                           equ        CAN0RXDSR6_DB3
CAN0RDSR6_DB4:                           equ        CAN0RXDSR6_DB4
CAN0RDSR6_DB5:                           equ        CAN0RXDSR6_DB5
CAN0RDSR6_DB6:                           equ        CAN0RXDSR6_DB6
CAN0RDSR6_DB7:                           equ        CAN0RXDSR6_DB7
mCAN0RDSR6_DB0:                          equ        mCAN0RXDSR6_DB0
mCAN0RDSR6_DB1:                          equ        mCAN0RXDSR6_DB1
mCAN0RDSR6_DB2:                          equ        mCAN0RXDSR6_DB2
mCAN0RDSR6_DB3:                          equ        mCAN0RXDSR6_DB3
mCAN0RDSR6_DB4:                          equ        mCAN0RXDSR6_DB4
mCAN0RDSR6_DB5:                          equ        mCAN0RXDSR6_DB5
mCAN0RDSR6_DB6:                          equ        mCAN0RXDSR6_DB6
mCAN0RDSR6_DB7:                          equ        mCAN0RXDSR6_DB7
CAN0RDSR7:                               equ        CAN0RXDSR7
CAN0RDSR7_DB0:                           equ        CAN0RXDSR7_DB0
CAN0RDSR7_DB1:                           equ        CAN0RXDSR7_DB1
CAN0RDSR7_DB2:                           equ        CAN0RXDSR7_DB2
CAN0RDSR7_DB3:                           equ        CAN0RXDSR7_DB3
CAN0RDSR7_DB4:                           equ        CAN0RXDSR7_DB4
CAN0RDSR7_DB5:                           equ        CAN0RXDSR7_DB5
CAN0RDSR7_DB6:                           equ        CAN0RXDSR7_DB6
CAN0RDSR7_DB7:                           equ        CAN0RXDSR7_DB7
mCAN0RDSR7_DB0:                          equ        mCAN0RXDSR7_DB0
mCAN0RDSR7_DB1:                          equ        mCAN0RXDSR7_DB1
mCAN0RDSR7_DB2:                          equ        mCAN0RXDSR7_DB2
mCAN0RDSR7_DB3:                          equ        mCAN0RXDSR7_DB3
mCAN0RDSR7_DB4:                          equ        mCAN0RXDSR7_DB4
mCAN0RDSR7_DB5:                          equ        mCAN0RXDSR7_DB5
mCAN0RDSR7_DB6:                          equ        mCAN0RXDSR7_DB6
mCAN0RDSR7_DB7:                          equ        mCAN0RXDSR7_DB7
CAN0RDLR:                                equ        CAN0RXDLR
CAN0RDLR_DLC0:                           equ        CAN0RXDLR_DLC0
CAN0RDLR_DLC1:                           equ        CAN0RXDLR_DLC1
CAN0RDLR_DLC2:                           equ        CAN0RXDLR_DLC2
CAN0RDLR_DLC3:                           equ        CAN0RXDLR_DLC3
mCAN0RDLR_DLC0:                          equ        mCAN0RXDLR_DLC0
mCAN0RDLR_DLC1:                          equ        mCAN0RXDLR_DLC1
mCAN0RDLR_DLC2:                          equ        mCAN0RXDLR_DLC2
mCAN0RDLR_DLC3:                          equ        mCAN0RXDLR_DLC3
CAN0RTSR:                                equ        CAN0RXTSR
CAN0RTSR_TSR0:                           equ        CAN0RXTSR_TSR0
CAN0RTSR_TSR1:                           equ        CAN0RXTSR_TSR1
CAN0RTSR_TSR2:                           equ        CAN0RXTSR_TSR2
CAN0RTSR_TSR3:                           equ        CAN0RXTSR_TSR3
CAN0RTSR_TSR4:                           equ        CAN0RXTSR_TSR4
CAN0RTSR_TSR5:                           equ        CAN0RXTSR_TSR5
CAN0RTSR_TSR6:                           equ        CAN0RXTSR_TSR6
CAN0RTSR_TSR7:                           equ        CAN0RXTSR_TSR7
CAN0RTSR_TSR8:                           equ        CAN0RXTSR_TSR8
CAN0RTSR_TSR9:                           equ        CAN0RXTSR_TSR9
CAN0RTSR_TSR10:                          equ        CAN0RXTSR_TSR10
CAN0RTSR_TSR11:                          equ        CAN0RXTSR_TSR11
CAN0RTSR_TSR12:                          equ        CAN0RXTSR_TSR12
CAN0RTSR_TSR13:                          equ        CAN0RXTSR_TSR13
CAN0RTSR_TSR14:                          equ        CAN0RXTSR_TSR14
CAN0RTSR_TSR15:                          equ        CAN0RXTSR_TSR15
mCAN0RTSR_TSR0:                          equ        mCAN0RXTSR_TSR0
mCAN0RTSR_TSR1:                          equ        mCAN0RXTSR_TSR1
mCAN0RTSR_TSR2:                          equ        mCAN0RXTSR_TSR2
mCAN0RTSR_TSR3:                          equ        mCAN0RXTSR_TSR3
mCAN0RTSR_TSR4:                          equ        mCAN0RXTSR_TSR4
mCAN0RTSR_TSR5:                          equ        mCAN0RXTSR_TSR5
mCAN0RTSR_TSR6:                          equ        mCAN0RXTSR_TSR6
mCAN0RTSR_TSR7:                          equ        mCAN0RXTSR_TSR7
mCAN0RTSR_TSR8:                          equ        mCAN0RXTSR_TSR8
mCAN0RTSR_TSR9:                          equ        mCAN0RXTSR_TSR9
mCAN0RTSR_TSR10:                         equ        mCAN0RXTSR_TSR10
mCAN0RTSR_TSR11:                         equ        mCAN0RXTSR_TSR11
mCAN0RTSR_TSR12:                         equ        mCAN0RXTSR_TSR12
mCAN0RTSR_TSR13:                         equ        mCAN0RXTSR_TSR13
mCAN0RTSR_TSR14:                         equ        mCAN0RXTSR_TSR14
mCAN0RTSR_TSR15:                         equ        mCAN0RXTSR_TSR15
CAN0RTSRH:                               equ        CAN0RXTSRH
CAN0RTSRH_TSR8:                          equ        CAN0RXTSRH_TSR8
CAN0RTSRH_TSR9:                          equ        CAN0RXTSRH_TSR9
CAN0RTSRH_TSR10:                         equ        CAN0RXTSRH_TSR10
CAN0RTSRH_TSR11:                         equ        CAN0RXTSRH_TSR11
CAN0RTSRH_TSR12:                         equ        CAN0RXTSRH_TSR12
CAN0RTSRH_TSR13:                         equ        CAN0RXTSRH_TSR13
CAN0RTSRH_TSR14:                         equ        CAN0RXTSRH_TSR14
CAN0RTSRH_TSR15:                         equ        CAN0RXTSRH_TSR15
mCAN0RTSRH_TSR8:                         equ        mCAN0RXTSRH_TSR8
mCAN0RTSRH_TSR9:                         equ        mCAN0RXTSRH_TSR9
mCAN0RTSRH_TSR10:                        equ        mCAN0RXTSRH_TSR10
mCAN0RTSRH_TSR11:                        equ        mCAN0RXTSRH_TSR11
mCAN0RTSRH_TSR12:                        equ        mCAN0RXTSRH_TSR12
mCAN0RTSRH_TSR13:                        equ        mCAN0RXTSRH_TSR13
mCAN0RTSRH_TSR14:                        equ        mCAN0RXTSRH_TSR14
mCAN0RTSRH_TSR15:                        equ        mCAN0RXTSRH_TSR15
CAN0RTSRL:                               equ        CAN0RXTSRL
CAN0RTSRL_TSR0:                          equ        CAN0RXTSRL_TSR0
CAN0RTSRL_TSR1:                          equ        CAN0RXTSRL_TSR1
CAN0RTSRL_TSR2:                          equ        CAN0RXTSRL_TSR2
CAN0RTSRL_TSR3:                          equ        CAN0RXTSRL_TSR3
CAN0RTSRL_TSR4:                          equ        CAN0RXTSRL_TSR4
CAN0RTSRL_TSR5:                          equ        CAN0RXTSRL_TSR5
CAN0RTSRL_TSR6:                          equ        CAN0RXTSRL_TSR6
CAN0RTSRL_TSR7:                          equ        CAN0RXTSRL_TSR7
mCAN0RTSRL_TSR0:                         equ        mCAN0RXTSRL_TSR0
mCAN0RTSRL_TSR1:                         equ        mCAN0RXTSRL_TSR1
mCAN0RTSRL_TSR2:                         equ        mCAN0RXTSRL_TSR2
mCAN0RTSRL_TSR3:                         equ        mCAN0RXTSRL_TSR3
mCAN0RTSRL_TSR4:                         equ        mCAN0RXTSRL_TSR4
mCAN0RTSRL_TSR5:                         equ        mCAN0RXTSRL_TSR5
mCAN0RTSRL_TSR6:                         equ        mCAN0RXTSRL_TSR6
mCAN0RTSRL_TSR7:                         equ        mCAN0RXTSRL_TSR7
CAN0TIDR0:                               equ        CAN0TXIDR0
CAN0TIDR0_ID21:                          equ        CAN0TXIDR0_ID21
CAN0TIDR0_ID22:                          equ        CAN0TXIDR0_ID22
CAN0TIDR0_ID23:                          equ        CAN0TXIDR0_ID23
CAN0TIDR0_ID24:                          equ        CAN0TXIDR0_ID24
CAN0TIDR0_ID25:                          equ        CAN0TXIDR0_ID25
CAN0TIDR0_ID26:                          equ        CAN0TXIDR0_ID26
CAN0TIDR0_ID27:                          equ        CAN0TXIDR0_ID27
CAN0TIDR0_ID28:                          equ        CAN0TXIDR0_ID28
mCAN0TIDR0_ID21:                         equ        mCAN0TXIDR0_ID21
mCAN0TIDR0_ID22:                         equ        mCAN0TXIDR0_ID22
mCAN0TIDR0_ID23:                         equ        mCAN0TXIDR0_ID23
mCAN0TIDR0_ID24:                         equ        mCAN0TXIDR0_ID24
mCAN0TIDR0_ID25:                         equ        mCAN0TXIDR0_ID25
mCAN0TIDR0_ID26:                         equ        mCAN0TXIDR0_ID26
mCAN0TIDR0_ID27:                         equ        mCAN0TXIDR0_ID27
mCAN0TIDR0_ID28:                         equ        mCAN0TXIDR0_ID28
CAN0TIDR1:                               equ        CAN0TXIDR1
CAN0TIDR1_ID15:                          equ        CAN0TXIDR1_ID15
CAN0TIDR1_ID16:                          equ        CAN0TXIDR1_ID16
CAN0TIDR1_ID17:                          equ        CAN0TXIDR1_ID17
CAN0TIDR1_IDE:                           equ        CAN0TXIDR1_IDE
CAN0TIDR1_SRR:                           equ        CAN0TXIDR1_SRR
CAN0TIDR1_ID18:                          equ        CAN0TXIDR1_ID18
CAN0TIDR1_ID19:                          equ        CAN0TXIDR1_ID19
CAN0TIDR1_ID20:                          equ        CAN0TXIDR1_ID20
mCAN0TIDR1_ID15:                         equ        mCAN0TXIDR1_ID15
mCAN0TIDR1_ID16:                         equ        mCAN0TXIDR1_ID16
mCAN0TIDR1_ID17:                         equ        mCAN0TXIDR1_ID17
mCAN0TIDR1_IDE:                          equ        mCAN0TXIDR1_IDE
mCAN0TIDR1_SRR:                          equ        mCAN0TXIDR1_SRR
mCAN0TIDR1_ID18:                         equ        mCAN0TXIDR1_ID18
mCAN0TIDR1_ID19:                         equ        mCAN0TXIDR1_ID19
mCAN0TIDR1_ID20:                         equ        mCAN0TXIDR1_ID20
CAN0TIDR2:                               equ        CAN0TXIDR2
CAN0TIDR2_ID7:                           equ        CAN0TXIDR2_ID7
CAN0TIDR2_ID8:                           equ        CAN0TXIDR2_ID8
CAN0TIDR2_ID9:                           equ        CAN0TXIDR2_ID9
CAN0TIDR2_ID10:                          equ        CAN0TXIDR2_ID10
CAN0TIDR2_ID11:                          equ        CAN0TXIDR2_ID11
CAN0TIDR2_ID12:                          equ        CAN0TXIDR2_ID12
CAN0TIDR2_ID13:                          equ        CAN0TXIDR2_ID13
CAN0TIDR2_ID14:                          equ        CAN0TXIDR2_ID14
mCAN0TIDR2_ID7:                          equ        mCAN0TXIDR2_ID7
mCAN0TIDR2_ID8:                          equ        mCAN0TXIDR2_ID8
mCAN0TIDR2_ID9:                          equ        mCAN0TXIDR2_ID9
mCAN0TIDR2_ID10:                         equ        mCAN0TXIDR2_ID10
mCAN0TIDR2_ID11:                         equ        mCAN0TXIDR2_ID11
mCAN0TIDR2_ID12:                         equ        mCAN0TXIDR2_ID12
mCAN0TIDR2_ID13:                         equ        mCAN0TXIDR2_ID13
mCAN0TIDR2_ID14:                         equ        mCAN0TXIDR2_ID14
CAN0TIDR3:                               equ        CAN0TXIDR3
CAN0TIDR3_RTR:                           equ        CAN0TXIDR3_RTR
CAN0TIDR3_ID0:                           equ        CAN0TXIDR3_ID0
CAN0TIDR3_ID1:                           equ        CAN0TXIDR3_ID1
CAN0TIDR3_ID2:                           equ        CAN0TXIDR3_ID2
CAN0TIDR3_ID3:                           equ        CAN0TXIDR3_ID3
CAN0TIDR3_ID4:                           equ        CAN0TXIDR3_ID4
CAN0TIDR3_ID5:                           equ        CAN0TXIDR3_ID5
CAN0TIDR3_ID6:                           equ        CAN0TXIDR3_ID6
mCAN0TIDR3_RTR:                          equ        mCAN0TXIDR3_RTR
mCAN0TIDR3_ID0:                          equ        mCAN0TXIDR3_ID0
mCAN0TIDR3_ID1:                          equ        mCAN0TXIDR3_ID1
mCAN0TIDR3_ID2:                          equ        mCAN0TXIDR3_ID2
mCAN0TIDR3_ID3:                          equ        mCAN0TXIDR3_ID3
mCAN0TIDR3_ID4:                          equ        mCAN0TXIDR3_ID4
mCAN0TIDR3_ID5:                          equ        mCAN0TXIDR3_ID5
mCAN0TIDR3_ID6:                          equ        mCAN0TXIDR3_ID6
CAN0TDSR0:                               equ        CAN0TXDSR0
CAN0TDSR0_DB0:                           equ        CAN0TXDSR0_DB0
CAN0TDSR0_DB1:                           equ        CAN0TXDSR0_DB1
CAN0TDSR0_DB2:                           equ        CAN0TXDSR0_DB2
CAN0TDSR0_DB3:                           equ        CAN0TXDSR0_DB3
CAN0TDSR0_DB4:                           equ        CAN0TXDSR0_DB4
CAN0TDSR0_DB5:                           equ        CAN0TXDSR0_DB5
CAN0TDSR0_DB6:                           equ        CAN0TXDSR0_DB6
CAN0TDSR0_DB7:                           equ        CAN0TXDSR0_DB7
mCAN0TDSR0_DB0:                          equ        mCAN0TXDSR0_DB0
mCAN0TDSR0_DB1:                          equ        mCAN0TXDSR0_DB1
mCAN0TDSR0_DB2:                          equ        mCAN0TXDSR0_DB2
mCAN0TDSR0_DB3:                          equ        mCAN0TXDSR0_DB3
mCAN0TDSR0_DB4:                          equ        mCAN0TXDSR0_DB4
mCAN0TDSR0_DB5:                          equ        mCAN0TXDSR0_DB5
mCAN0TDSR0_DB6:                          equ        mCAN0TXDSR0_DB6
mCAN0TDSR0_DB7:                          equ        mCAN0TXDSR0_DB7
CAN0TDSR1:                               equ        CAN0TXDSR1
CAN0TDSR1_DB0:                           equ        CAN0TXDSR1_DB0
CAN0TDSR1_DB1:                           equ        CAN0TXDSR1_DB1
CAN0TDSR1_DB2:                           equ        CAN0TXDSR1_DB2
CAN0TDSR1_DB3:                           equ        CAN0TXDSR1_DB3
CAN0TDSR1_DB4:                           equ        CAN0TXDSR1_DB4
CAN0TDSR1_DB5:                           equ        CAN0TXDSR1_DB5
CAN0TDSR1_DB6:                           equ        CAN0TXDSR1_DB6
CAN0TDSR1_DB7:                           equ        CAN0TXDSR1_DB7
mCAN0TDSR1_DB0:                          equ        mCAN0TXDSR1_DB0
mCAN0TDSR1_DB1:                          equ        mCAN0TXDSR1_DB1
mCAN0TDSR1_DB2:                          equ        mCAN0TXDSR1_DB2
mCAN0TDSR1_DB3:                          equ        mCAN0TXDSR1_DB3
mCAN0TDSR1_DB4:                          equ        mCAN0TXDSR1_DB4
mCAN0TDSR1_DB5:                          equ        mCAN0TXDSR1_DB5
mCAN0TDSR1_DB6:                          equ        mCAN0TXDSR1_DB6
mCAN0TDSR1_DB7:                          equ        mCAN0TXDSR1_DB7
CAN0TDSR2:                               equ        CAN0TXDSR2
CAN0TDSR2_DB0:                           equ        CAN0TXDSR2_DB0
CAN0TDSR2_DB1:                           equ        CAN0TXDSR2_DB1
CAN0TDSR2_DB2:                           equ        CAN0TXDSR2_DB2
CAN0TDSR2_DB3:                           equ        CAN0TXDSR2_DB3
CAN0TDSR2_DB4:                           equ        CAN0TXDSR2_DB4
CAN0TDSR2_DB5:                           equ        CAN0TXDSR2_DB5
CAN0TDSR2_DB6:                           equ        CAN0TXDSR2_DB6
CAN0TDSR2_DB7:                           equ        CAN0TXDSR2_DB7
mCAN0TDSR2_DB0:                          equ        mCAN0TXDSR2_DB0
mCAN0TDSR2_DB1:                          equ        mCAN0TXDSR2_DB1
mCAN0TDSR2_DB2:                          equ        mCAN0TXDSR2_DB2
mCAN0TDSR2_DB3:                          equ        mCAN0TXDSR2_DB3
mCAN0TDSR2_DB4:                          equ        mCAN0TXDSR2_DB4
mCAN0TDSR2_DB5:                          equ        mCAN0TXDSR2_DB5
mCAN0TDSR2_DB6:                          equ        mCAN0TXDSR2_DB6
mCAN0TDSR2_DB7:                          equ        mCAN0TXDSR2_DB7
CAN0TDSR3:                               equ        CAN0TXDSR3
CAN0TDSR3_DB0:                           equ        CAN0TXDSR3_DB0
CAN0TDSR3_DB1:                           equ        CAN0TXDSR3_DB1
CAN0TDSR3_DB2:                           equ        CAN0TXDSR3_DB2
CAN0TDSR3_DB3:                           equ        CAN0TXDSR3_DB3
CAN0TDSR3_DB4:                           equ        CAN0TXDSR3_DB4
CAN0TDSR3_DB5:                           equ        CAN0TXDSR3_DB5
CAN0TDSR3_DB6:                           equ        CAN0TXDSR3_DB6
CAN0TDSR3_DB7:                           equ        CAN0TXDSR3_DB7
mCAN0TDSR3_DB0:                          equ        mCAN0TXDSR3_DB0
mCAN0TDSR3_DB1:                          equ        mCAN0TXDSR3_DB1
mCAN0TDSR3_DB2:                          equ        mCAN0TXDSR3_DB2
mCAN0TDSR3_DB3:                          equ        mCAN0TXDSR3_DB3
mCAN0TDSR3_DB4:                          equ        mCAN0TXDSR3_DB4
mCAN0TDSR3_DB5:                          equ        mCAN0TXDSR3_DB5
mCAN0TDSR3_DB6:                          equ        mCAN0TXDSR3_DB6
mCAN0TDSR3_DB7:                          equ        mCAN0TXDSR3_DB7
CAN0TDSR4:                               equ        CAN0TXDSR4
CAN0TDSR4_DB0:                           equ        CAN0TXDSR4_DB0
CAN0TDSR4_DB1:                           equ        CAN0TXDSR4_DB1
CAN0TDSR4_DB2:                           equ        CAN0TXDSR4_DB2
CAN0TDSR4_DB3:                           equ        CAN0TXDSR4_DB3
CAN0TDSR4_DB4:                           equ        CAN0TXDSR4_DB4
CAN0TDSR4_DB5:                           equ        CAN0TXDSR4_DB5
CAN0TDSR4_DB6:                           equ        CAN0TXDSR4_DB6
CAN0TDSR4_DB7:                           equ        CAN0TXDSR4_DB7
mCAN0TDSR4_DB0:                          equ        mCAN0TXDSR4_DB0
mCAN0TDSR4_DB1:                          equ        mCAN0TXDSR4_DB1
mCAN0TDSR4_DB2:                          equ        mCAN0TXDSR4_DB2
mCAN0TDSR4_DB3:                          equ        mCAN0TXDSR4_DB3
mCAN0TDSR4_DB4:                          equ        mCAN0TXDSR4_DB4
mCAN0TDSR4_DB5:                          equ        mCAN0TXDSR4_DB5
mCAN0TDSR4_DB6:                          equ        mCAN0TXDSR4_DB6
mCAN0TDSR4_DB7:                          equ        mCAN0TXDSR4_DB7
CAN0TDSR5:                               equ        CAN0TXDSR5
CAN0TDSR5_DB0:                           equ        CAN0TXDSR5_DB0
CAN0TDSR5_DB1:                           equ        CAN0TXDSR5_DB1
CAN0TDSR5_DB2:                           equ        CAN0TXDSR5_DB2
CAN0TDSR5_DB3:                           equ        CAN0TXDSR5_DB3
CAN0TDSR5_DB4:                           equ        CAN0TXDSR5_DB4
CAN0TDSR5_DB5:                           equ        CAN0TXDSR5_DB5
CAN0TDSR5_DB6:                           equ        CAN0TXDSR5_DB6
CAN0TDSR5_DB7:                           equ        CAN0TXDSR5_DB7
mCAN0TDSR5_DB0:                          equ        mCAN0TXDSR5_DB0
mCAN0TDSR5_DB1:                          equ        mCAN0TXDSR5_DB1
mCAN0TDSR5_DB2:                          equ        mCAN0TXDSR5_DB2
mCAN0TDSR5_DB3:                          equ        mCAN0TXDSR5_DB3
mCAN0TDSR5_DB4:                          equ        mCAN0TXDSR5_DB4
mCAN0TDSR5_DB5:                          equ        mCAN0TXDSR5_DB5
mCAN0TDSR5_DB6:                          equ        mCAN0TXDSR5_DB6
mCAN0TDSR5_DB7:                          equ        mCAN0TXDSR5_DB7
CAN0TDSR6:                               equ        CAN0TXDSR6
CAN0TDSR6_DB0:                           equ        CAN0TXDSR6_DB0
CAN0TDSR6_DB1:                           equ        CAN0TXDSR6_DB1
CAN0TDSR6_DB2:                           equ        CAN0TXDSR6_DB2
CAN0TDSR6_DB3:                           equ        CAN0TXDSR6_DB3
CAN0TDSR6_DB4:                           equ        CAN0TXDSR6_DB4
CAN0TDSR6_DB5:                           equ        CAN0TXDSR6_DB5
CAN0TDSR6_DB6:                           equ        CAN0TXDSR6_DB6
CAN0TDSR6_DB7:                           equ        CAN0TXDSR6_DB7
mCAN0TDSR6_DB0:                          equ        mCAN0TXDSR6_DB0
mCAN0TDSR6_DB1:                          equ        mCAN0TXDSR6_DB1
mCAN0TDSR6_DB2:                          equ        mCAN0TXDSR6_DB2
mCAN0TDSR6_DB3:                          equ        mCAN0TXDSR6_DB3
mCAN0TDSR6_DB4:                          equ        mCAN0TXDSR6_DB4
mCAN0TDSR6_DB5:                          equ        mCAN0TXDSR6_DB5
mCAN0TDSR6_DB6:                          equ        mCAN0TXDSR6_DB6
mCAN0TDSR6_DB7:                          equ        mCAN0TXDSR6_DB7
CAN0TDSR7:                               equ        CAN0TXDSR7
CAN0TDSR7_DB0:                           equ        CAN0TXDSR7_DB0
CAN0TDSR7_DB1:                           equ        CAN0TXDSR7_DB1
CAN0TDSR7_DB2:                           equ        CAN0TXDSR7_DB2
CAN0TDSR7_DB3:                           equ        CAN0TXDSR7_DB3
CAN0TDSR7_DB4:                           equ        CAN0TXDSR7_DB4
CAN0TDSR7_DB5:                           equ        CAN0TXDSR7_DB5
CAN0TDSR7_DB6:                           equ        CAN0TXDSR7_DB6
CAN0TDSR7_DB7:                           equ        CAN0TXDSR7_DB7
mCAN0TDSR7_DB0:                          equ        mCAN0TXDSR7_DB0
mCAN0TDSR7_DB1:                          equ        mCAN0TXDSR7_DB1
mCAN0TDSR7_DB2:                          equ        mCAN0TXDSR7_DB2
mCAN0TDSR7_DB3:                          equ        mCAN0TXDSR7_DB3
mCAN0TDSR7_DB4:                          equ        mCAN0TXDSR7_DB4
mCAN0TDSR7_DB5:                          equ        mCAN0TXDSR7_DB5
mCAN0TDSR7_DB6:                          equ        mCAN0TXDSR7_DB6
mCAN0TDSR7_DB7:                          equ        mCAN0TXDSR7_DB7
CAN0TDLR:                                equ        CAN0TXDLR
CAN0TDLR_DLC0:                           equ        CAN0TXDLR_DLC0
CAN0TDLR_DLC1:                           equ        CAN0TXDLR_DLC1
CAN0TDLR_DLC2:                           equ        CAN0TXDLR_DLC2
CAN0TDLR_DLC3:                           equ        CAN0TXDLR_DLC3
mCAN0TDLR_DLC0:                          equ        mCAN0TXDLR_DLC0
mCAN0TDLR_DLC1:                          equ        mCAN0TXDLR_DLC1
mCAN0TDLR_DLC2:                          equ        mCAN0TXDLR_DLC2
mCAN0TDLR_DLC3:                          equ        mCAN0TXDLR_DLC3
CAN0TTBPR:                               equ        CAN0TXTBPR
CAN0TTBPR_PRIO0:                         equ        CAN0TXTBPR_PRIO0
CAN0TTBPR_PRIO1:                         equ        CAN0TXTBPR_PRIO1
CAN0TTBPR_PRIO2:                         equ        CAN0TXTBPR_PRIO2
CAN0TTBPR_PRIO3:                         equ        CAN0TXTBPR_PRIO3
CAN0TTBPR_PRIO4:                         equ        CAN0TXTBPR_PRIO4
CAN0TTBPR_PRIO5:                         equ        CAN0TXTBPR_PRIO5
CAN0TTBPR_PRIO6:                         equ        CAN0TXTBPR_PRIO6
CAN0TTBPR_PRIO7:                         equ        CAN0TXTBPR_PRIO7
mCAN0TTBPR_PRIO0:                        equ        mCAN0TXTBPR_PRIO0
mCAN0TTBPR_PRIO1:                        equ        mCAN0TXTBPR_PRIO1
mCAN0TTBPR_PRIO2:                        equ        mCAN0TXTBPR_PRIO2
mCAN0TTBPR_PRIO3:                        equ        mCAN0TXTBPR_PRIO3
mCAN0TTBPR_PRIO4:                        equ        mCAN0TXTBPR_PRIO4
mCAN0TTBPR_PRIO5:                        equ        mCAN0TXTBPR_PRIO5
mCAN0TTBPR_PRIO6:                        equ        mCAN0TXTBPR_PRIO6
mCAN0TTBPR_PRIO7:                        equ        mCAN0TXTBPR_PRIO7
CAN0TTSR:                                equ        CAN0TXTSR
CAN0TTSR_TSR0:                           equ        CAN0TXTSR_TSR0
CAN0TTSR_TSR1:                           equ        CAN0TXTSR_TSR1
CAN0TTSR_TSR2:                           equ        CAN0TXTSR_TSR2
CAN0TTSR_TSR3:                           equ        CAN0TXTSR_TSR3
CAN0TTSR_TSR4:                           equ        CAN0TXTSR_TSR4
CAN0TTSR_TSR5:                           equ        CAN0TXTSR_TSR5
CAN0TTSR_TSR6:                           equ        CAN0TXTSR_TSR6
CAN0TTSR_TSR7:                           equ        CAN0TXTSR_TSR7
CAN0TTSR_TSR8:                           equ        CAN0TXTSR_TSR8
CAN0TTSR_TSR9:                           equ        CAN0TXTSR_TSR9
CAN0TTSR_TSR10:                          equ        CAN0TXTSR_TSR10
CAN0TTSR_TSR11:                          equ        CAN0TXTSR_TSR11
CAN0TTSR_TSR12:                          equ        CAN0TXTSR_TSR12
CAN0TTSR_TSR13:                          equ        CAN0TXTSR_TSR13
CAN0TTSR_TSR14:                          equ        CAN0TXTSR_TSR14
CAN0TTSR_TSR15:                          equ        CAN0TXTSR_TSR15
mCAN0TTSR_TSR0:                          equ        mCAN0TXTSR_TSR0
mCAN0TTSR_TSR1:                          equ        mCAN0TXTSR_TSR1
mCAN0TTSR_TSR2:                          equ        mCAN0TXTSR_TSR2
mCAN0TTSR_TSR3:                          equ        mCAN0TXTSR_TSR3
mCAN0TTSR_TSR4:                          equ        mCAN0TXTSR_TSR4
mCAN0TTSR_TSR5:                          equ        mCAN0TXTSR_TSR5
mCAN0TTSR_TSR6:                          equ        mCAN0TXTSR_TSR6
mCAN0TTSR_TSR7:                          equ        mCAN0TXTSR_TSR7
mCAN0TTSR_TSR8:                          equ        mCAN0TXTSR_TSR8
mCAN0TTSR_TSR9:                          equ        mCAN0TXTSR_TSR9
mCAN0TTSR_TSR10:                         equ        mCAN0TXTSR_TSR10
mCAN0TTSR_TSR11:                         equ        mCAN0TXTSR_TSR11
mCAN0TTSR_TSR12:                         equ        mCAN0TXTSR_TSR12
mCAN0TTSR_TSR13:                         equ        mCAN0TXTSR_TSR13
mCAN0TTSR_TSR14:                         equ        mCAN0TXTSR_TSR14
mCAN0TTSR_TSR15:                         equ        mCAN0TXTSR_TSR15
CAN0TTSRH:                               equ        CAN0TXTSRH
CAN0TTSRH_TSR8:                          equ        CAN0TXTSRH_TSR8
CAN0TTSRH_TSR9:                          equ        CAN0TXTSRH_TSR9
CAN0TTSRH_TSR10:                         equ        CAN0TXTSRH_TSR10
CAN0TTSRH_TSR11:                         equ        CAN0TXTSRH_TSR11
CAN0TTSRH_TSR12:                         equ        CAN0TXTSRH_TSR12
CAN0TTSRH_TSR13:                         equ        CAN0TXTSRH_TSR13
CAN0TTSRH_TSR14:                         equ        CAN0TXTSRH_TSR14
CAN0TTSRH_TSR15:                         equ        CAN0TXTSRH_TSR15
mCAN0TTSRH_TSR8:                         equ        mCAN0TXTSRH_TSR8
mCAN0TTSRH_TSR9:                         equ        mCAN0TXTSRH_TSR9
mCAN0TTSRH_TSR10:                        equ        mCAN0TXTSRH_TSR10
mCAN0TTSRH_TSR11:                        equ        mCAN0TXTSRH_TSR11
mCAN0TTSRH_TSR12:                        equ        mCAN0TXTSRH_TSR12
mCAN0TTSRH_TSR13:                        equ        mCAN0TXTSRH_TSR13
mCAN0TTSRH_TSR14:                        equ        mCAN0TXTSRH_TSR14
mCAN0TTSRH_TSR15:                        equ        mCAN0TXTSRH_TSR15
CAN0TTSRL:                               equ        CAN0TXTSRL
CAN0TTSRL_TSR0:                          equ        CAN0TXTSRL_TSR0
CAN0TTSRL_TSR1:                          equ        CAN0TXTSRL_TSR1
CAN0TTSRL_TSR2:                          equ        CAN0TXTSRL_TSR2
CAN0TTSRL_TSR3:                          equ        CAN0TXTSRL_TSR3
CAN0TTSRL_TSR4:                          equ        CAN0TXTSRL_TSR4
CAN0TTSRL_TSR5:                          equ        CAN0TXTSRL_TSR5
CAN0TTSRL_TSR6:                          equ        CAN0TXTSRL_TSR6
CAN0TTSRL_TSR7:                          equ        CAN0TXTSRL_TSR7
mCAN0TTSRL_TSR0:                         equ        mCAN0TXTSRL_TSR0
mCAN0TTSRL_TSR1:                         equ        mCAN0TXTSRL_TSR1
mCAN0TTSRL_TSR2:                         equ        mCAN0TXTSRL_TSR2
mCAN0TTSRL_TSR3:                         equ        mCAN0TXTSRL_TSR3
mCAN0TTSRL_TSR4:                         equ        mCAN0TXTSRL_TSR4
mCAN0TTSRL_TSR5:                         equ        mCAN0TXTSRL_TSR5
mCAN0TTSRL_TSR6:                         equ        mCAN0TXTSRL_TSR6
mCAN0TTSRL_TSR7:                         equ        mCAN0TXTSRL_TSR7
PITCFLMT_PITLMT0:                        equ        PITCFLMT_PFLMT0
PITCFLMT_PITLMT1:                        equ        PITCFLMT_PFLMT1
mPITCFLMT_PITLMT0:                       equ        mPITCFLMT_PFLMT0
mPITCFLMT_PITLMT1:                       equ        mPITCFLMT_PFLMT1
PITFLT_PITFLT0:                          equ        PITFLT_PFLT0
PITFLT_PITFLT1:                          equ        PITFLT_PFLT1
PITFLT_PITFLT2:                          equ        PITFLT_PFLT2
PITFLT_PITFLT3:                          equ        PITFLT_PFLT3
PITFLT_PITFLT4:                          equ        PITFLT_PFLT4
PITFLT_PITFLT5:                          equ        PITFLT_PFLT5
PITFLT_PITFLT6:                          equ        PITFLT_PFLT6
PITFLT_PITFLT7:                          equ        PITFLT_PFLT7
mPITFLT_PITFLT0:                         equ        mPITFLT_PFLT0
mPITFLT_PITFLT1:                         equ        mPITFLT_PFLT1
mPITFLT_PITFLT2:                         equ        mPITFLT_PFLT2
mPITFLT_PITFLT3:                         equ        mPITFLT_PFLT3
mPITFLT_PITFLT4:                         equ        mPITFLT_PFLT4
mPITFLT_PITFLT5:                         equ        mPITFLT_PFLT5
mPITFLT_PITFLT6:                         equ        mPITFLT_PFLT6
mPITFLT_PITFLT7:                         equ        mPITFLT_PFLT7
PITCE_PITCE0:                            equ        PITCE_PCE0
PITCE_PITCE1:                            equ        PITCE_PCE1
PITCE_PITCE2:                            equ        PITCE_PCE2
PITCE_PITCE3:                            equ        PITCE_PCE3
PITCE_PITCE4:                            equ        PITCE_PCE4
PITCE_PITCE5:                            equ        PITCE_PCE5
PITCE_PITCE6:                            equ        PITCE_PCE6
PITCE_PITCE7:                            equ        PITCE_PCE7
mPITCE_PITCE0:                           equ        mPITCE_PCE0
mPITCE_PITCE1:                           equ        mPITCE_PCE1
mPITCE_PITCE2:                           equ        mPITCE_PCE2
mPITCE_PITCE3:                           equ        mPITCE_PCE3
mPITCE_PITCE4:                           equ        mPITCE_PCE4
mPITCE_PITCE5:                           equ        mPITCE_PCE5
mPITCE_PITCE6:                           equ        mPITCE_PCE6
mPITCE_PITCE7:                           equ        mPITCE_PCE7
PITMUX_PITMUX0:                          equ        PITMUX_PMUX0
PITMUX_PITMUX1:                          equ        PITMUX_PMUX1
PITMUX_PITMUX2:                          equ        PITMUX_PMUX2
PITMUX_PITMUX3:                          equ        PITMUX_PMUX3
PITMUX_PITMUX4:                          equ        PITMUX_PMUX4
PITMUX_PITMUX5:                          equ        PITMUX_PMUX5
PITMUX_PITMUX6:                          equ        PITMUX_PMUX6
PITMUX_PITMUX7:                          equ        PITMUX_PMUX7
mPITMUX_PITMUX0:                         equ        mPITMUX_PMUX0
mPITMUX_PITMUX1:                         equ        mPITMUX_PMUX1
mPITMUX_PITMUX2:                         equ        mPITMUX_PMUX2
mPITMUX_PITMUX3:                         equ        mPITMUX_PMUX3
mPITMUX_PITMUX4:                         equ        mPITMUX_PMUX4
mPITMUX_PITMUX5:                         equ        mPITMUX_PMUX5
mPITMUX_PITMUX6:                         equ        mPITMUX_PMUX6
mPITMUX_PITMUX7:                         equ        mPITMUX_PMUX7
PITINTE_PITINTE0:                        equ        PITINTE_PINTE0
PITINTE_PITINTE1:                        equ        PITINTE_PINTE1
PITINTE_PITINTE2:                        equ        PITINTE_PINTE2
PITINTE_PITINTE3:                        equ        PITINTE_PINTE3
PITINTE_PITINTE4:                        equ        PITINTE_PINTE4
PITINTE_PITINTE5:                        equ        PITINTE_PINTE5
PITINTE_PITINTE6:                        equ        PITINTE_PINTE6
PITINTE_PITINTE7:                        equ        PITINTE_PINTE7
mPITINTE_PITINTE0:                       equ        mPITINTE_PINTE0
mPITINTE_PITINTE1:                       equ        mPITINTE_PINTE1
mPITINTE_PITINTE2:                       equ        mPITINTE_PINTE2
mPITINTE_PITINTE3:                       equ        mPITINTE_PINTE3
mPITINTE_PITINTE4:                       equ        mPITINTE_PINTE4
mPITINTE_PITINTE5:                       equ        mPITINTE_PINTE5
mPITINTE_PITINTE6:                       equ        mPITINTE_PINTE6
mPITINTE_PITINTE7:                       equ        mPITINTE_PINTE7
PITTF_PITTF0:                            equ        PITTF_PTF0
PITTF_PITTF1:                            equ        PITTF_PTF1
PITTF_PITTF2:                            equ        PITTF_PTF2
PITTF_PITTF3:                            equ        PITTF_PTF3
PITTF_PITTF4:                            equ        PITTF_PTF4
PITTF_PITTF5:                            equ        PITTF_PTF5
PITTF_PITTF6:                            equ        PITTF_PTF6
PITTF_PITTF7:                            equ        PITTF_PTF7
mPITTF_PITTF0:                           equ        mPITTF_PTF0
mPITTF_PITTF1:                           equ        mPITTF_PTF1
mPITTF_PITTF2:                           equ        mPITTF_PTF2
mPITTF_PITTF3:                           equ        mPITTF_PTF3
mPITTF_PITTF4:                           equ        mPITTF_PTF4
mPITTF_PITTF5:                           equ        mPITTF_PTF5
mPITTF_PITTF6:                           equ        mPITTF_PTF6
mPITTF_PITTF7:                           equ        mPITTF_PTF7
        IFNDEF __GENERATE_APPLICATION__
TI2CR0_MTCNT_T2_MTCNT16:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT17:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT18:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT19:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT20:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT21:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT22:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT23:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT24:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT25:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT26:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT27:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT28:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT29:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT30:                 equ        This_symb_has_been_depreciated
TI2CR0_MTCNT_T2_MTCNT31:                 equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT16:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT17:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT18:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT19:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT20:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT21:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT22:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT23:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT24:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT25:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT26:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT27:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT28:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT29:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT30:                equ        This_symb_has_been_depreciated
mTI2CR0_MTCNT_T2_MTCNT31:                equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT0:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT1:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT2:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT3:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT4:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT5:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT6:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT7:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT8:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT9:                  equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT10:                 equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT11:                 equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT12:                 equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT13:                 equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT14:                 equ        This_symb_has_been_depreciated
TI2CR1_MTCNT_T2_MTCNT15:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT0:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT1:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT2:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT3:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT4:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT5:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT6:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT7:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT8:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT9:                 equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT10:                equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT11:                equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT12:                equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT13:                equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT14:                equ        This_symb_has_been_depreciated
mTI2CR1_MTCNT_T2_MTCNT15:                equ        This_symb_has_been_depreciated
        ENDIF

; 23.5.2008 7:45:59


        IFNDEF __GENERATE_APPLICATION__
EEPROM_FCStart:                          equ        This_symb_has_been_depreciated
EEPROM_FCEnd:                            equ        This_symb_has_been_depreciated
EEPROM_FDStart:                          equ        This_symb_has_been_depreciated
EEPROM_FDEnd:                            equ        This_symb_has_been_depreciated
        ENDIF

	
	
 

; EOF
