/* Based on CPU DB MC9S12XEG384_144, version 3.00.020 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12xeg384.h
**     Processor : MC9S12XEG384CAG
**     FileFormat: V2.32
**     DataSheet : MC9S12XEP100 Rev. 1.19 12/2008
**     Compiler  : CodeWarrior compiler
**     Date/Time : 7.6.2010, 15:27
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 14.11.2008, V3.00.0:
**              - Renamed bits IBCR2[ADR2:0] -> IBCR2[ADR10:8].
**              -   REASON: Bug-fix(#6799 in Issue Manager).
**
**     File-Format-Revisions:
**      - 03.07.2008, V2.24 :
**               - Added support for bits with name starting with number (like "1HZ")
**      - 28.11.2008, V2.25 :
**               - StandBy RAM array declaration for ANSI-C added
**      - 1.12.2008, V2.26 :
**               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
**      - 17.3.2009, V2.27 :
**               - Merged bit-group is not generated, if the name matches with another bit name in the register
**      - 6.4.2009, V2.28 :
**               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
**      - 3.8.2009, V2.29 :
**               - If there is just one bits group matching register name, single bits are not generated
**      - 10.9.2009, V2.30 :
**               - Fixed generation of registers arrays.
**      - 15.10.2009, V2.31 :
**               - Changes have not affected this file (because they are related to another family)
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12XEG384_H
#define _MC9S12XEG384_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vsi                119U
#define VectorNumber_Vsyscall           118U
#define VectorNumber_Vmpuaccesserr      117U
#define VectorNumber_Vxsei              116U
#define VectorNumber_VReserved115       115U
#define VectorNumber_VReserved114       114U
#define VectorNumber_VReserved113       113U
#define VectorNumber_VReserved112       112U
#define VectorNumber_VReserved111       111U
#define VectorNumber_VReserved110       110U
#define VectorNumber_VReserved109       109U
#define VectorNumber_VReserved108       108U
#define VectorNumber_VReserved107       107U
#define VectorNumber_VReserved106       106U
#define VectorNumber_VReserved105       105U
#define VectorNumber_VReserved104       104U
#define VectorNumber_VReserved103       103U
#define VectorNumber_VReserved102       102U
#define VectorNumber_VReserved101       101U
#define VectorNumber_VReserved100       100U
#define VectorNumber_VReserved99        99U
#define VectorNumber_VReserved98        98U
#define VectorNumber_Vatd1compare       97U
#define VectorNumber_Vatd0compare       96U
#define VectorNumber_VReserved95        95U
#define VectorNumber_VReserved94        94U
#define VectorNumber_VReserved93        93U
#define VectorNumber_VReserved92        92U
#define VectorNumber_VReserved91        91U
#define VectorNumber_VReserved90        90U
#define VectorNumber_VReserved89        89U
#define VectorNumber_VReserved88        88U
#define VectorNumber_VReserved87        87U
#define VectorNumber_VReserved86        86U
#define VectorNumber_VReserved85        85U
#define VectorNumber_VReserved84        84U
#define VectorNumber_VReserved83        83U
#define VectorNumber_VReserved82        82U
#define VectorNumber_VReserved81        81U
#define VectorNumber_VReserved80        80U
#define VectorNumber_VReserved79        79U
#define VectorNumber_VReserved78        78U
#define VectorNumber_Vxst7              77U
#define VectorNumber_Vxst6              76U
#define VectorNumber_Vxst5              75U
#define VectorNumber_Vxst4              74U
#define VectorNumber_Vxst3              73U
#define VectorNumber_Vxst2              72U
#define VectorNumber_Vxst1              71U
#define VectorNumber_Vxst0              70U
#define VectorNumber_Vpit3              69U
#define VectorNumber_Vpit2              68U
#define VectorNumber_Vpit1              67U
#define VectorNumber_Vpit0              66U
#define VectorNumber_Vhti               65U
#define VectorNumber_Vapi               64U
#define VectorNumber_Vlvi               63U
#define VectorNumber_Viic1              62U
#define VectorNumber_Vsci5              61U
#define VectorNumber_Vsci4              60U
#define VectorNumber_Vsci3              59U
#define VectorNumber_Vsci2              58U
#define VectorNumber_Vpwmesdn           57U
#define VectorNumber_Vportp             56U
#define VectorNumber_Vcan4tx            55U
#define VectorNumber_Vcan4rx            54U
#define VectorNumber_Vcan4err           53U
#define VectorNumber_Vcan4wkup          52U
#define VectorNumber_VReserved51        51U
#define VectorNumber_VReserved50        50U
#define VectorNumber_VReserved49        49U
#define VectorNumber_VReserved48        48U
#define VectorNumber_VReserved47        47U
#define VectorNumber_VReserved46        46U
#define VectorNumber_VReserved45        45U
#define VectorNumber_VReserved44        44U
#define VectorNumber_VReserved43        43U
#define VectorNumber_VReserved42        42U
#define VectorNumber_VReserved41        41U
#define VectorNumber_VReserved40        40U
#define VectorNumber_Vcan0tx            39U
#define VectorNumber_Vcan0rx            38U
#define VectorNumber_Vcan0err           37U
#define VectorNumber_Vcan0wkup          36U
#define VectorNumber_Vflash             35U
#define VectorNumber_Vflashfd           34U
#define VectorNumber_Vspi2              33U
#define VectorNumber_Vspi1              32U
#define VectorNumber_Viic0              31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_Vcrgscm            29U
#define VectorNumber_Vcrgplllck         28U
#define VectorNumber_Vectpabovf         27U
#define VectorNumber_Vectmdcu           26U
#define VectorNumber_Vporth             25U
#define VectorNumber_Vportj             24U
#define VectorNumber_Vatd1              23U
#define VectorNumber_Vatd0              22U
#define VectorNumber_Vsci1              21U
#define VectorNumber_Vsci0              20U
#define VectorNumber_Vspi0              19U
#define VectorNumber_Vectpaie           18U
#define VectorNumber_Vectpaaovf         17U
#define VectorNumber_Vectovf            16U
#define VectorNumber_Vectch7            15U
#define VectorNumber_Vectch6            14U
#define VectorNumber_Vectch5            13U
#define VectorNumber_Vectch4            12U
#define VectorNumber_Vectch3            11U
#define VectorNumber_Vectch2            10U
#define VectorNumber_Vectch1            9U
#define VectorNumber_Vectch0            8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Virq               6U
#define VectorNumber_Vxirq              5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define Vsi                             0xFF10U
#define Vsyscall                        0xFF12U
#define Vmpuaccesserr                   0xFF14U
#define Vxsei                           0xFF16U
#define VReserved115                    0xFF18U
#define VReserved114                    0xFF1AU
#define VReserved113                    0xFF1CU
#define VReserved112                    0xFF1EU
#define VReserved111                    0xFF20U
#define VReserved110                    0xFF22U
#define VReserved109                    0xFF24U
#define VReserved108                    0xFF26U
#define VReserved107                    0xFF28U
#define VReserved106                    0xFF2AU
#define VReserved105                    0xFF2CU
#define VReserved104                    0xFF2EU
#define VReserved103                    0xFF30U
#define VReserved102                    0xFF32U
#define VReserved101                    0xFF34U
#define VReserved100                    0xFF36U
#define VReserved99                     0xFF38U
#define VReserved98                     0xFF3AU
#define Vatd1compare                    0xFF3CU
#define Vatd0compare                    0xFF3EU
#define VReserved95                     0xFF40U
#define VReserved94                     0xFF42U
#define VReserved93                     0xFF44U
#define VReserved92                     0xFF46U
#define VReserved91                     0xFF48U
#define VReserved90                     0xFF4AU
#define VReserved89                     0xFF4CU
#define VReserved88                     0xFF4EU
#define VReserved87                     0xFF50U
#define VReserved86                     0xFF52U
#define VReserved85                     0xFF54U
#define VReserved84                     0xFF56U
#define VReserved83                     0xFF58U
#define VReserved82                     0xFF5AU
#define VReserved81                     0xFF5CU
#define VReserved80                     0xFF5EU
#define VReserved79                     0xFF60U
#define VReserved78                     0xFF62U
#define Vxst7                           0xFF64U
#define Vxst6                           0xFF66U
#define Vxst5                           0xFF68U
#define Vxst4                           0xFF6AU
#define Vxst3                           0xFF6CU
#define Vxst2                           0xFF6EU
#define Vxst1                           0xFF70U
#define Vxst0                           0xFF72U
#define Vpit3                           0xFF74U
#define Vpit2                           0xFF76U
#define Vpit1                           0xFF78U
#define Vpit0                           0xFF7AU
#define Vhti                            0xFF7CU
#define Vapi                            0xFF7EU
#define Vlvi                            0xFF80U
#define Viic1                           0xFF82U
#define Vsci5                           0xFF84U
#define Vsci4                           0xFF86U
#define Vsci3                           0xFF88U
#define Vsci2                           0xFF8AU
#define Vpwmesdn                        0xFF8CU
#define Vportp                          0xFF8EU
#define Vcan4tx                         0xFF90U
#define Vcan4rx                         0xFF92U
#define Vcan4err                        0xFF94U
#define Vcan4wkup                       0xFF96U
#define VReserved51                     0xFF98U
#define VReserved50                     0xFF9AU
#define VReserved49                     0xFF9CU
#define VReserved48                     0xFF9EU
#define VReserved47                     0xFFA0U
#define VReserved46                     0xFFA2U
#define VReserved45                     0xFFA4U
#define VReserved44                     0xFFA6U
#define VReserved43                     0xFFA8U
#define VReserved42                     0xFFAAU
#define VReserved41                     0xFFACU
#define VReserved40                     0xFFAEU
#define Vcan0tx                         0xFFB0U
#define Vcan0rx                         0xFFB2U
#define Vcan0err                        0xFFB4U
#define Vcan0wkup                       0xFFB6U
#define Vflash                          0xFFB8U
#define Vflashfd                        0xFFBAU
#define Vspi2                           0xFFBCU
#define Vspi1                           0xFFBEU
#define Viic0                           0xFFC0U
#define VReserved30                     0xFFC2U
#define Vcrgscm                         0xFFC4U
#define Vcrgplllck                      0xFFC6U
#define Vectpabovf                      0xFFC8U
#define Vectmdcu                        0xFFCAU
#define Vporth                          0xFFCCU
#define Vportj                          0xFFCEU
#define Vatd1                           0xFFD0U
#define Vatd0                           0xFFD2U
#define Vsci1                           0xFFD4U
#define Vsci0                           0xFFD6U
#define Vspi0                           0xFFD8U
#define Vectpaie                        0xFFDAU
#define Vectpaaovf                      0xFFDCU
#define Vectovf                         0xFFDEU
#define Vectch7                         0xFFE0U
#define Vectch6                         0xFFE2U
#define Vectch5                         0xFFE4U
#define Vectch4                         0xFFE6U
#define Vectch3                         0xFFE8U
#define Vectch2                         0xFFEAU
#define Vectch1                         0xFFECU
#define Vectch0                         0xFFEEU
#define Vrti                            0xFFF0U
#define Virq                            0xFFF2U
#define Vxirq                           0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTAB - Port AB Data Register; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Data Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte PA0         :1;                                       /* Port A Bit 0 */
        byte PA1         :1;                                       /* Port A Bit 1 */
        byte PA2         :1;                                       /* Port A Bit 2 */
        byte PA3         :1;                                       /* Port A Bit 3 */
        byte PA4         :1;                                       /* Port A Bit 4 */
        byte PA5         :1;                                       /* Port A Bit 5 */
        byte PA6         :1;                                       /* Port A Bit 6 */
        byte PA7         :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_PA0                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA0
    #define PORTA_PA1                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA1
    #define PORTA_PA2                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA2
    #define PORTA_PA3                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA3
    #define PORTA_PA4                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA4
    #define PORTA_PA5                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA5
    #define PORTA_PA6                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA6
    #define PORTA_PA7                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA7
    
    #define PORTA_PA0_MASK              1U
    #define PORTA_PA1_MASK              2U
    #define PORTA_PA2_MASK              4U
    #define PORTA_PA3_MASK              8U
    #define PORTA_PA4_MASK              16U
    #define PORTA_PA5_MASK              32U
    #define PORTA_PA6_MASK              64U
    #define PORTA_PA7_MASK              128U
    

    /*** PORTB - Port B Data Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte PB0         :1;                                       /* Port B Bit 0 */
        byte PB1         :1;                                       /* Port B Bit 1 */
        byte PB2         :1;                                       /* Port B Bit 2 */
        byte PB3         :1;                                       /* Port B Bit 3 */
        byte PB4         :1;                                       /* Port B Bit 4 */
        byte PB5         :1;                                       /* Port B Bit 5 */
        byte PB6         :1;                                       /* Port B Bit 6 */
        byte PB7         :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_PB0                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB0
    #define PORTB_PB1                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB1
    #define PORTB_PB2                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB2
    #define PORTB_PB3                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB3
    #define PORTB_PB4                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB4
    #define PORTB_PB5                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB5
    #define PORTB_PB6                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB6
    #define PORTB_PB7                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB7
    
    #define PORTB_PB0_MASK              1U
    #define PORTB_PB1_MASK              2U
    #define PORTB_PB2_MASK              4U
    #define PORTB_PB3_MASK              8U
    #define PORTB_PB4_MASK              16U
    #define PORTB_PB5_MASK              32U
    #define PORTB_PB6_MASK              64U
    #define PORTB_PB7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PB0         :1;                                       /* Port B Bit 0 */
    word PB1         :1;                                       /* Port B Bit 1 */
    word PB2         :1;                                       /* Port B Bit 2 */
    word PB3         :1;                                       /* Port B Bit 3 */
    word PB4         :1;                                       /* Port B Bit 4 */
    word PB5         :1;                                       /* Port B Bit 5 */
    word PB6         :1;                                       /* Port B Bit 6 */
    word PB7         :1;                                       /* Port B Bit 7 */
    word PA0         :1;                                       /* Port A Bit 0 */
    word PA1         :1;                                       /* Port A Bit 1 */
    word PA2         :1;                                       /* Port A Bit 2 */
    word PA3         :1;                                       /* Port A Bit 3 */
    word PA4         :1;                                       /* Port A Bit 4 */
    word PA5         :1;                                       /* Port A Bit 5 */
    word PA6         :1;                                       /* Port A Bit 6 */
    word PA7         :1;                                       /* Port A Bit 7 */
  } Bits;
  struct {
    word grpPB   :8;
    word grpPA   :8;
  } MergedBits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000UL);
#define PORTAB                          _PORTAB.Word
#define PORTAB_PB0                      _PORTAB.Bits.PB0
#define PORTAB_PB1                      _PORTAB.Bits.PB1
#define PORTAB_PB2                      _PORTAB.Bits.PB2
#define PORTAB_PB3                      _PORTAB.Bits.PB3
#define PORTAB_PB4                      _PORTAB.Bits.PB4
#define PORTAB_PB5                      _PORTAB.Bits.PB5
#define PORTAB_PB6                      _PORTAB.Bits.PB6
#define PORTAB_PB7                      _PORTAB.Bits.PB7
#define PORTAB_PA0                      _PORTAB.Bits.PA0
#define PORTAB_PA1                      _PORTAB.Bits.PA1
#define PORTAB_PA2                      _PORTAB.Bits.PA2
#define PORTAB_PA3                      _PORTAB.Bits.PA3
#define PORTAB_PA4                      _PORTAB.Bits.PA4
#define PORTAB_PA5                      _PORTAB.Bits.PA5
#define PORTAB_PA6                      _PORTAB.Bits.PA6
#define PORTAB_PA7                      _PORTAB.Bits.PA7
#define PORTAB_PB                       _PORTAB.MergedBits.grpPB
#define PORTAB_PA                       _PORTAB.MergedBits.grpPA

#define PORTAB_PB0_MASK                 1U
#define PORTAB_PB1_MASK                 2U
#define PORTAB_PB2_MASK                 4U
#define PORTAB_PB3_MASK                 8U
#define PORTAB_PB4_MASK                 16U
#define PORTAB_PB5_MASK                 32U
#define PORTAB_PB6_MASK                 64U
#define PORTAB_PB7_MASK                 128U
#define PORTAB_PA0_MASK                 256U
#define PORTAB_PA1_MASK                 512U
#define PORTAB_PA2_MASK                 1024U
#define PORTAB_PA3_MASK                 2048U
#define PORTAB_PA4_MASK                 4096U
#define PORTAB_PA5_MASK                 8192U
#define PORTAB_PA6_MASK                 16384U
#define PORTAB_PA7_MASK                 32768U
#define PORTAB_PB_MASK                  255U
#define PORTAB_PB_BITNUM                0U
#define PORTAB_PA_MASK                  65280U
#define PORTAB_PA_BITNUM                8U


/*** DDRAB - Port AB Data Direction Register; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
        byte DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
        byte DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
        byte DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
        byte DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
        byte DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
        byte DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
        byte DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_DDRA0                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA0
    #define DDRA_DDRA1                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA1
    #define DDRA_DDRA2                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA2
    #define DDRA_DDRA3                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA3
    #define DDRA_DDRA4                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA4
    #define DDRA_DDRA5                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA5
    #define DDRA_DDRA6                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA6
    #define DDRA_DDRA7                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA7
    
    #define DDRA_DDRA0_MASK             1U
    #define DDRA_DDRA1_MASK             2U
    #define DDRA_DDRA2_MASK             4U
    #define DDRA_DDRA3_MASK             8U
    #define DDRA_DDRA4_MASK             16U
    #define DDRA_DDRA5_MASK             32U
    #define DDRA_DDRA6_MASK             64U
    #define DDRA_DDRA7_MASK             128U
    

    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
        byte DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
        byte DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
        byte DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
        byte DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
        byte DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
        byte DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
        byte DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_DDRB0                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB0
    #define DDRB_DDRB1                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB1
    #define DDRB_DDRB2                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB2
    #define DDRB_DDRB3                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB3
    #define DDRB_DDRB4                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB4
    #define DDRB_DDRB5                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB5
    #define DDRB_DDRB6                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB6
    #define DDRB_DDRB7                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB7
    
    #define DDRB_DDRB0_MASK             1U
    #define DDRB_DDRB1_MASK             2U
    #define DDRB_DDRB2_MASK             4U
    #define DDRB_DDRB3_MASK             8U
    #define DDRB_DDRB4_MASK             16U
    #define DDRB_DDRB5_MASK             32U
    #define DDRB_DDRB6_MASK             64U
    #define DDRB_DDRB7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
    word DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
    word DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
    word DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
    word DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
    word DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
    word DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
    word DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
    word DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
    word DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
    word DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
    word DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
    word DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
    word DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
    word DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
    word DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
  struct {
    word grpDDRB :8;
    word grpDDRA :8;
  } MergedBits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002UL);
#define DDRAB                           _DDRAB.Word
#define DDRAB_DDRB0                     _DDRAB.Bits.DDRB0
#define DDRAB_DDRB1                     _DDRAB.Bits.DDRB1
#define DDRAB_DDRB2                     _DDRAB.Bits.DDRB2
#define DDRAB_DDRB3                     _DDRAB.Bits.DDRB3
#define DDRAB_DDRB4                     _DDRAB.Bits.DDRB4
#define DDRAB_DDRB5                     _DDRAB.Bits.DDRB5
#define DDRAB_DDRB6                     _DDRAB.Bits.DDRB6
#define DDRAB_DDRB7                     _DDRAB.Bits.DDRB7
#define DDRAB_DDRA0                     _DDRAB.Bits.DDRA0
#define DDRAB_DDRA1                     _DDRAB.Bits.DDRA1
#define DDRAB_DDRA2                     _DDRAB.Bits.DDRA2
#define DDRAB_DDRA3                     _DDRAB.Bits.DDRA3
#define DDRAB_DDRA4                     _DDRAB.Bits.DDRA4
#define DDRAB_DDRA5                     _DDRAB.Bits.DDRA5
#define DDRAB_DDRA6                     _DDRAB.Bits.DDRA6
#define DDRAB_DDRA7                     _DDRAB.Bits.DDRA7
#define DDRAB_DDRB                      _DDRAB.MergedBits.grpDDRB
#define DDRAB_DDRA                      _DDRAB.MergedBits.grpDDRA

#define DDRAB_DDRB0_MASK                1U
#define DDRAB_DDRB1_MASK                2U
#define DDRAB_DDRB2_MASK                4U
#define DDRAB_DDRB3_MASK                8U
#define DDRAB_DDRB4_MASK                16U
#define DDRAB_DDRB5_MASK                32U
#define DDRAB_DDRB6_MASK                64U
#define DDRAB_DDRB7_MASK                128U
#define DDRAB_DDRA0_MASK                256U
#define DDRAB_DDRA1_MASK                512U
#define DDRAB_DDRA2_MASK                1024U
#define DDRAB_DDRA3_MASK                2048U
#define DDRAB_DDRA4_MASK                4096U
#define DDRAB_DDRA5_MASK                8192U
#define DDRAB_DDRA6_MASK                16384U
#define DDRAB_DDRA7_MASK                32768U
#define DDRAB_DDRB_MASK                 255U
#define DDRAB_DDRB_BITNUM               0U
#define DDRAB_DDRA_MASK                 65280U
#define DDRAB_DDRA_BITNUM               8U


/*** PORTCD - Port CD Data Register; 0x00000004 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTC - Port C Data Register; 0x00000004 ***/
    union {
      byte Byte;
      struct {
        byte PC0         :1;                                       /* Port C Bit 0 */
        byte PC1         :1;                                       /* Port C Bit 1 */
        byte PC2         :1;                                       /* Port C Bit 2 */
        byte PC3         :1;                                       /* Port C Bit 3 */
        byte PC4         :1;                                       /* Port C Bit 4 */
        byte PC5         :1;                                       /* Port C Bit 5 */
        byte PC6         :1;                                       /* Port C Bit 6 */
        byte PC7         :1;                                       /* Port C Bit 7 */
      } Bits;
    } PORTCSTR;
    #define PORTC                       _PORTCD.Overlap_STR.PORTCSTR.Byte
    #define PORTC_PC0                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC0
    #define PORTC_PC1                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC1
    #define PORTC_PC2                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC2
    #define PORTC_PC3                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC3
    #define PORTC_PC4                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC4
    #define PORTC_PC5                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC5
    #define PORTC_PC6                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC6
    #define PORTC_PC7                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC7
    
    #define PORTC_PC0_MASK              1U
    #define PORTC_PC1_MASK              2U
    #define PORTC_PC2_MASK              4U
    #define PORTC_PC3_MASK              8U
    #define PORTC_PC4_MASK              16U
    #define PORTC_PC5_MASK              32U
    #define PORTC_PC6_MASK              64U
    #define PORTC_PC7_MASK              128U
    

    /*** PORTD - Port D Data Register; 0x00000005 ***/
    union {
      byte Byte;
      struct {
        byte PD0         :1;                                       /* Port D Bit 0 */
        byte PD1         :1;                                       /* Port D Bit 1 */
        byte PD2         :1;                                       /* Port D Bit 2 */
        byte PD3         :1;                                       /* Port D Bit 3 */
        byte PD4         :1;                                       /* Port D Bit 4 */
        byte PD5         :1;                                       /* Port D Bit 5 */
        byte PD6         :1;                                       /* Port D Bit 6 */
        byte PD7         :1;                                       /* Port D Bit 7 */
      } Bits;
    } PORTDSTR;
    #define PORTD                       _PORTCD.Overlap_STR.PORTDSTR.Byte
    #define PORTD_PD0                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD0
    #define PORTD_PD1                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD1
    #define PORTD_PD2                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD2
    #define PORTD_PD3                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD3
    #define PORTD_PD4                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD4
    #define PORTD_PD5                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD5
    #define PORTD_PD6                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD6
    #define PORTD_PD7                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD7
    
    #define PORTD_PD0_MASK              1U
    #define PORTD_PD1_MASK              2U
    #define PORTD_PD2_MASK              4U
    #define PORTD_PD3_MASK              8U
    #define PORTD_PD4_MASK              16U
    #define PORTD_PD5_MASK              32U
    #define PORTD_PD6_MASK              64U
    #define PORTD_PD7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PD0         :1;                                       /* Port D Bit 0 */
    word PD1         :1;                                       /* Port D Bit 1 */
    word PD2         :1;                                       /* Port D Bit 2 */
    word PD3         :1;                                       /* Port D Bit 3 */
    word PD4         :1;                                       /* Port D Bit 4 */
    word PD5         :1;                                       /* Port D Bit 5 */
    word PD6         :1;                                       /* Port D Bit 6 */
    word PD7         :1;                                       /* Port D Bit 7 */
    word PC0         :1;                                       /* Port C Bit 0 */
    word PC1         :1;                                       /* Port C Bit 1 */
    word PC2         :1;                                       /* Port C Bit 2 */
    word PC3         :1;                                       /* Port C Bit 3 */
    word PC4         :1;                                       /* Port C Bit 4 */
    word PC5         :1;                                       /* Port C Bit 5 */
    word PC6         :1;                                       /* Port C Bit 6 */
    word PC7         :1;                                       /* Port C Bit 7 */
  } Bits;
  struct {
    word grpPD   :8;
    word grpPC   :8;
  } MergedBits;
} PORTCDSTR;
extern volatile PORTCDSTR _PORTCD @(REG_BASE + 0x00000004UL);
#define PORTCD                          _PORTCD.Word
#define PORTCD_PD0                      _PORTCD.Bits.PD0
#define PORTCD_PD1                      _PORTCD.Bits.PD1
#define PORTCD_PD2                      _PORTCD.Bits.PD2
#define PORTCD_PD3                      _PORTCD.Bits.PD3
#define PORTCD_PD4                      _PORTCD.Bits.PD4
#define PORTCD_PD5                      _PORTCD.Bits.PD5
#define PORTCD_PD6                      _PORTCD.Bits.PD6
#define PORTCD_PD7                      _PORTCD.Bits.PD7
#define PORTCD_PC0                      _PORTCD.Bits.PC0
#define PORTCD_PC1                      _PORTCD.Bits.PC1
#define PORTCD_PC2                      _PORTCD.Bits.PC2
#define PORTCD_PC3                      _PORTCD.Bits.PC3
#define PORTCD_PC4                      _PORTCD.Bits.PC4
#define PORTCD_PC5                      _PORTCD.Bits.PC5
#define PORTCD_PC6                      _PORTCD.Bits.PC6
#define PORTCD_PC7                      _PORTCD.Bits.PC7
#define PORTCD_PD                       _PORTCD.MergedBits.grpPD
#define PORTCD_PC                       _PORTCD.MergedBits.grpPC

#define PORTCD_PD0_MASK                 1U
#define PORTCD_PD1_MASK                 2U
#define PORTCD_PD2_MASK                 4U
#define PORTCD_PD3_MASK                 8U
#define PORTCD_PD4_MASK                 16U
#define PORTCD_PD5_MASK                 32U
#define PORTCD_PD6_MASK                 64U
#define PORTCD_PD7_MASK                 128U
#define PORTCD_PC0_MASK                 256U
#define PORTCD_PC1_MASK                 512U
#define PORTCD_PC2_MASK                 1024U
#define PORTCD_PC3_MASK                 2048U
#define PORTCD_PC4_MASK                 4096U
#define PORTCD_PC5_MASK                 8192U
#define PORTCD_PC6_MASK                 16384U
#define PORTCD_PC7_MASK                 32768U
#define PORTCD_PD_MASK                  255U
#define PORTCD_PD_BITNUM                0U
#define PORTCD_PC_MASK                  65280U
#define PORTCD_PC_BITNUM                8U


/*** DDRCD - Port CD Data Direction Register; 0x00000006 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRC - Port C Data Direction Register; 0x00000006 ***/
    union {
      byte Byte;
      struct {
        byte DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
        byte DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
        byte DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
        byte DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
        byte DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
        byte DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
        byte DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
        byte DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
      } Bits;
    } DDRCSTR;
    #define DDRC                        _DDRCD.Overlap_STR.DDRCSTR.Byte
    #define DDRC_DDRC0                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC0
    #define DDRC_DDRC1                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC1
    #define DDRC_DDRC2                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC2
    #define DDRC_DDRC3                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC3
    #define DDRC_DDRC4                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC4
    #define DDRC_DDRC5                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC5
    #define DDRC_DDRC6                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC6
    #define DDRC_DDRC7                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC7
    
    #define DDRC_DDRC0_MASK             1U
    #define DDRC_DDRC1_MASK             2U
    #define DDRC_DDRC2_MASK             4U
    #define DDRC_DDRC3_MASK             8U
    #define DDRC_DDRC4_MASK             16U
    #define DDRC_DDRC5_MASK             32U
    #define DDRC_DDRC6_MASK             64U
    #define DDRC_DDRC7_MASK             128U
    

    /*** DDRD - Port D Data Direction Register; 0x00000007 ***/
    union {
      byte Byte;
      struct {
        byte DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
        byte DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
        byte DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
        byte DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
        byte DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
        byte DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
        byte DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
        byte DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
      } Bits;
    } DDRDSTR;
    #define DDRD                        _DDRCD.Overlap_STR.DDRDSTR.Byte
    #define DDRD_DDRD0                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD0
    #define DDRD_DDRD1                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD1
    #define DDRD_DDRD2                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD2
    #define DDRD_DDRD3                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD3
    #define DDRD_DDRD4                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD4
    #define DDRD_DDRD5                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD5
    #define DDRD_DDRD6                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD6
    #define DDRD_DDRD7                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD7
    
    #define DDRD_DDRD0_MASK             1U
    #define DDRD_DDRD1_MASK             2U
    #define DDRD_DDRD2_MASK             4U
    #define DDRD_DDRD3_MASK             8U
    #define DDRD_DDRD4_MASK             16U
    #define DDRD_DDRD5_MASK             32U
    #define DDRD_DDRD6_MASK             64U
    #define DDRD_DDRD7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
    word DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
    word DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
    word DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
    word DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
    word DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
    word DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
    word DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
    word DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
    word DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
    word DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
    word DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
    word DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
    word DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
    word DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
    word DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
  } Bits;
  struct {
    word grpDDRD :8;
    word grpDDRC :8;
  } MergedBits;
} DDRCDSTR;
extern volatile DDRCDSTR _DDRCD @(REG_BASE + 0x00000006UL);
#define DDRCD                           _DDRCD.Word
#define DDRCD_DDRD0                     _DDRCD.Bits.DDRD0
#define DDRCD_DDRD1                     _DDRCD.Bits.DDRD1
#define DDRCD_DDRD2                     _DDRCD.Bits.DDRD2
#define DDRCD_DDRD3                     _DDRCD.Bits.DDRD3
#define DDRCD_DDRD4                     _DDRCD.Bits.DDRD4
#define DDRCD_DDRD5                     _DDRCD.Bits.DDRD5
#define DDRCD_DDRD6                     _DDRCD.Bits.DDRD6
#define DDRCD_DDRD7                     _DDRCD.Bits.DDRD7
#define DDRCD_DDRC0                     _DDRCD.Bits.DDRC0
#define DDRCD_DDRC1                     _DDRCD.Bits.DDRC1
#define DDRCD_DDRC2                     _DDRCD.Bits.DDRC2
#define DDRCD_DDRC3                     _DDRCD.Bits.DDRC3
#define DDRCD_DDRC4                     _DDRCD.Bits.DDRC4
#define DDRCD_DDRC5                     _DDRCD.Bits.DDRC5
#define DDRCD_DDRC6                     _DDRCD.Bits.DDRC6
#define DDRCD_DDRC7                     _DDRCD.Bits.DDRC7
#define DDRCD_DDRD                      _DDRCD.MergedBits.grpDDRD
#define DDRCD_DDRC                      _DDRCD.MergedBits.grpDDRC

#define DDRCD_DDRD0_MASK                1U
#define DDRCD_DDRD1_MASK                2U
#define DDRCD_DDRD2_MASK                4U
#define DDRCD_DDRD3_MASK                8U
#define DDRCD_DDRD4_MASK                16U
#define DDRCD_DDRD5_MASK                32U
#define DDRCD_DDRD6_MASK                64U
#define DDRCD_DDRD7_MASK                128U
#define DDRCD_DDRC0_MASK                256U
#define DDRCD_DDRC1_MASK                512U
#define DDRCD_DDRC2_MASK                1024U
#define DDRCD_DDRC3_MASK                2048U
#define DDRCD_DDRC4_MASK                4096U
#define DDRCD_DDRC5_MASK                8192U
#define DDRCD_DDRC6_MASK                16384U
#define DDRCD_DDRC7_MASK                32768U
#define DDRCD_DDRD_MASK                 255U
#define DDRCD_DDRD_BITNUM               0U
#define DDRCD_DDRC_MASK                 65280U
#define DDRCD_DDRC_BITNUM               8U


/*** PORTE - Port E Data Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Port E Bit 0 */
    byte PE1         :1;                                       /* Port E Bit 1 */
    byte PE2         :1;                                       /* Port E Bit 2 */
    byte PE3         :1;                                       /* Port E Bit 3 */
    byte PE4         :1;                                       /* Port E Bit 4 */
    byte PE5         :1;                                       /* Port E Bit 5 */
    byte PE6         :1;                                       /* Port E Bit 6 */
    byte PE7         :1;                                       /* Port E Bit 7 */
  } Bits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008UL);
#define PORTE                           _PORTE.Byte
#define PORTE_PE0                       _PORTE.Bits.PE0
#define PORTE_PE1                       _PORTE.Bits.PE1
#define PORTE_PE2                       _PORTE.Bits.PE2
#define PORTE_PE3                       _PORTE.Bits.PE3
#define PORTE_PE4                       _PORTE.Bits.PE4
#define PORTE_PE5                       _PORTE.Bits.PE5
#define PORTE_PE6                       _PORTE.Bits.PE6
#define PORTE_PE7                       _PORTE.Bits.PE7

#define PORTE_PE0_MASK                  1U
#define PORTE_PE1_MASK                  2U
#define PORTE_PE2_MASK                  4U
#define PORTE_PE3_MASK                  8U
#define PORTE_PE4_MASK                  16U
#define PORTE_PE5_MASK                  32U
#define PORTE_PE6_MASK                  64U
#define PORTE_PE7_MASK                  128U


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte DDRE2       :1;                                       /* Data Direction Port E Bit 2 */
    byte DDRE3       :1;                                       /* Data Direction Port E Bit 3 */
    byte DDRE4       :1;                                       /* Data Direction Port E Bit 4 */
    byte DDRE5       :1;                                       /* Data Direction Port E Bit 5 */
    byte DDRE6       :1;                                       /* Data Direction Port E Bit 6 */
    byte DDRE7       :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpDDRE_2 :6;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009UL);
#define DDRE                            _DDRE.Byte
#define DDRE_DDRE2                      _DDRE.Bits.DDRE2
#define DDRE_DDRE3                      _DDRE.Bits.DDRE3
#define DDRE_DDRE4                      _DDRE.Bits.DDRE4
#define DDRE_DDRE5                      _DDRE.Bits.DDRE5
#define DDRE_DDRE6                      _DDRE.Bits.DDRE6
#define DDRE_DDRE7                      _DDRE.Bits.DDRE7
#define DDRE_DDRE_2                     _DDRE.MergedBits.grpDDRE_2

#define DDRE_DDRE2_MASK                 4U
#define DDRE_DDRE3_MASK                 8U
#define DDRE_DDRE4_MASK                 16U
#define DDRE_DDRE5_MASK                 32U
#define DDRE_DDRE6_MASK                 64U
#define DDRE_DDRE7_MASK                 128U
#define DDRE_DDRE_2_MASK                252U
#define DDRE_DDRE_2_BITNUM              2U


/*** MMCCTL0 - MMC Control Register; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte CS0E0       :1;                                       /* Chip Select 0 Enables Bit 0 */
    byte CS0E1       :1;                                       /* Chip Select 0 Enables Bit 1 */
    byte CS1E0       :1;                                       /* Chip Select 1 Enables Bit 0 */
    byte CS1E1       :1;                                       /* Chip Select 1 Enables Bit 1 */
    byte CS2E0       :1;                                       /* Chip Select 2 Enables Bit 0 */
    byte CS2E1       :1;                                       /* Chip Select 2 Enables Bit 1 */
    byte CS3E0       :1;                                       /* Chip Select 3 Enables Bit 0 */
    byte CS3E1       :1;                                       /* Chip Select 3 Enables Bit 1 */
  } Bits;
  struct {
    byte grpCS0E :2;
    byte grpCS1E :2;
    byte grpCS2E :2;
    byte grpCS3E :2;
  } MergedBits;
} MMCCTL0STR;
extern volatile MMCCTL0STR _MMCCTL0 @(REG_BASE + 0x0000000AUL);
#define MMCCTL0                         _MMCCTL0.Byte
#define MMCCTL0_CS0E0                   _MMCCTL0.Bits.CS0E0
#define MMCCTL0_CS0E1                   _MMCCTL0.Bits.CS0E1
#define MMCCTL0_CS1E0                   _MMCCTL0.Bits.CS1E0
#define MMCCTL0_CS1E1                   _MMCCTL0.Bits.CS1E1
#define MMCCTL0_CS2E0                   _MMCCTL0.Bits.CS2E0
#define MMCCTL0_CS2E1                   _MMCCTL0.Bits.CS2E1
#define MMCCTL0_CS3E0                   _MMCCTL0.Bits.CS3E0
#define MMCCTL0_CS3E1                   _MMCCTL0.Bits.CS3E1
#define MMCCTL0_CS0E                    _MMCCTL0.MergedBits.grpCS0E
#define MMCCTL0_CS1E                    _MMCCTL0.MergedBits.grpCS1E
#define MMCCTL0_CS2E                    _MMCCTL0.MergedBits.grpCS2E
#define MMCCTL0_CS3E                    _MMCCTL0.MergedBits.grpCS3E

#define MMCCTL0_CS0E0_MASK              1U
#define MMCCTL0_CS0E1_MASK              2U
#define MMCCTL0_CS1E0_MASK              4U
#define MMCCTL0_CS1E1_MASK              8U
#define MMCCTL0_CS2E0_MASK              16U
#define MMCCTL0_CS2E1_MASK              32U
#define MMCCTL0_CS3E0_MASK              64U
#define MMCCTL0_CS3E1_MASK              128U
#define MMCCTL0_CS0E_MASK               3U
#define MMCCTL0_CS0E_BITNUM             0U
#define MMCCTL0_CS1E_MASK               12U
#define MMCCTL0_CS1E_BITNUM             2U
#define MMCCTL0_CS2E_MASK               48U
#define MMCCTL0_CS2E_BITNUM             4U
#define MMCCTL0_CS3E_MASK               192U
#define MMCCTL0_CS3E_BITNUM             6U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit */
    byte MODB        :1;                                       /* Mode Select Bit */
    byte MODC        :1;                                       /* Mode Select Bit */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_MODA_MASK                  32U
#define MODE_MODB_MASK                  64U
#define MODE_MODC_MASK                  128U
#define MODE_MODx_MASK                  224U
#define MODE_MODx_BITNUM                5U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-up Port B Enable */
    byte PUPCE       :1;                                       /* Pull-up Port C Enable */
    byte PUPDE       :1;                                       /* Pull-up Port D Enable */
    byte PUPEE       :1;                                       /* Pull-up Port E Enable */
    byte             :1; 
    byte BKPUE       :1;                                       /* BKGD and VREGEN Pin Pull-up Enable */
    byte PUPKE       :1;                                       /* Pull-up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPCE                      _PUCR.Bits.PUPCE
#define PUCR_PUPDE                      _PUCR.Bits.PUPDE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_BKPUE                      _PUCR.Bits.BKPUE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1U
#define PUCR_PUPBE_MASK                 2U
#define PUCR_PUPCE_MASK                 4U
#define PUCR_PUPDE_MASK                 8U
#define PUCR_PUPEE_MASK                 16U
#define PUCR_BKPUE_MASK                 64U
#define PUCR_PUPKE_MASK                 128U


/*** RDRIV - Reduced Drive Register; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte RDPC        :1;                                       /* Reduced Drive of Port C */
    byte RDPD        :1;                                       /* Reduced Drive of Port D */
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPC                      _RDRIV.Bits.RDPC
#define RDRIV_RDPD                      _RDRIV.Bits.RDPD
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1U
#define RDRIV_RDPB_MASK                 2U
#define RDRIV_RDPC_MASK                 4U
#define RDRIV_RDPD_MASK                 8U
#define RDRIV_RDPE_MASK                 16U
#define RDRIV_RDPK_MASK                 128U
#define RDRIV_RDPx_MASK                 31U
#define RDRIV_RDPx_BITNUM               0U


/*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte ASIZ0       :1;                                       /* External Address Bus Size Bit 0 */
    byte ASIZ1       :1;                                       /* External Address Bus Size Bit 1 */
    byte ASIZ2       :1;                                       /* External Address Bus Size Bit 2 */
    byte ASIZ3       :1;                                       /* External Address Bus Size Bit 3 */
    byte ASIZ4       :1;                                       /* External Address Bus Size Bit 4 */
    byte HDBE        :1;                                       /* High Data Byte Enable */
    byte             :1; 
    byte ITHRS       :1;                                       /* Reduced Input Threshold */
  } Bits;
  struct {
    byte grpASIZ :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} EBICTL0STR;
extern volatile EBICTL0STR _EBICTL0 @(REG_BASE + 0x0000000EUL);
#define EBICTL0                         _EBICTL0.Byte
#define EBICTL0_ASIZ0                   _EBICTL0.Bits.ASIZ0
#define EBICTL0_ASIZ1                   _EBICTL0.Bits.ASIZ1
#define EBICTL0_ASIZ2                   _EBICTL0.Bits.ASIZ2
#define EBICTL0_ASIZ3                   _EBICTL0.Bits.ASIZ3
#define EBICTL0_ASIZ4                   _EBICTL0.Bits.ASIZ4
#define EBICTL0_HDBE                    _EBICTL0.Bits.HDBE
#define EBICTL0_ITHRS                   _EBICTL0.Bits.ITHRS
/* EBICTL_ARR: Access 2 EBICTLx registers in an array */
#define EBICTL_ARR                      ((volatile byte *) &EBICTL0)
#define EBICTL0_ASIZ                    _EBICTL0.MergedBits.grpASIZ

#define EBICTL0_ASIZ0_MASK              1U
#define EBICTL0_ASIZ1_MASK              2U
#define EBICTL0_ASIZ2_MASK              4U
#define EBICTL0_ASIZ3_MASK              8U
#define EBICTL0_ASIZ4_MASK              16U
#define EBICTL0_HDBE_MASK               32U
#define EBICTL0_ITHRS_MASK              128U
#define EBICTL0_ASIZ_MASK               31U
#define EBICTL0_ASIZ_BITNUM             0U


/*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***/
typedef union {
  byte Byte;
  struct {
    byte EXSTR00     :1;                                       /* External Access Stretch Option 0 Bit 0 */
    byte EXSTR01     :1;                                       /* External Access Stretch Option 0 Bit 1 */
    byte EXSTR02     :1;                                       /* External Access Stretch Option 0 Bit 2 */
    byte             :1; 
    byte EXSTR10     :1;                                       /* External Access Stretch Option 2 Bit 0 */
    byte EXSTR11     :1;                                       /* External Access Stretch Option 2 Bit 1 */
    byte EXSTR12     :1;                                       /* External Access Stretch Option 2 Bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpEXSTR0 :3;
    byte         :1;
    byte grpEXSTR_10 :3;
    byte         :1;
  } MergedBits;
} EBICTL1STR;
extern volatile EBICTL1STR _EBICTL1 @(REG_BASE + 0x0000000FUL);
#define EBICTL1                         _EBICTL1.Byte
#define EBICTL1_EXSTR00                 _EBICTL1.Bits.EXSTR00
#define EBICTL1_EXSTR01                 _EBICTL1.Bits.EXSTR01
#define EBICTL1_EXSTR02                 _EBICTL1.Bits.EXSTR02
#define EBICTL1_EXSTR10                 _EBICTL1.Bits.EXSTR10
#define EBICTL1_EXSTR11                 _EBICTL1.Bits.EXSTR11
#define EBICTL1_EXSTR12                 _EBICTL1.Bits.EXSTR12
#define EBICTL1_EXSTR0                  _EBICTL1.MergedBits.grpEXSTR0
#define EBICTL1_EXSTR_10                _EBICTL1.MergedBits.grpEXSTR_10
#define EBICTL1_EXSTR                   EBICTL1_EXSTR_10

#define EBICTL1_EXSTR00_MASK            1U
#define EBICTL1_EXSTR01_MASK            2U
#define EBICTL1_EXSTR02_MASK            4U
#define EBICTL1_EXSTR10_MASK            16U
#define EBICTL1_EXSTR11_MASK            32U
#define EBICTL1_EXSTR12_MASK            64U
#define EBICTL1_EXSTR0_MASK             7U
#define EBICTL1_EXSTR0_BITNUM           0U
#define EBICTL1_EXSTR_10_MASK           112U
#define EBICTL1_EXSTR_10_BITNUM         4U


/*** GPAGE - Global Page Index Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte GP0         :1;                                       /* Global Page Index Bit 0 */
    byte GP1         :1;                                       /* Global Page Index Bit 1 */
    byte GP2         :1;                                       /* Global Page Index Bit 2 */
    byte GP3         :1;                                       /* Global Page Index Bit 3 */
    byte GP4         :1;                                       /* Global Page Index Bit 4 */
    byte GP5         :1;                                       /* Global Page Index Bit 5 */
    byte GP6         :1;                                       /* Global Page Index Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpGP   :7;
    byte         :1;
  } MergedBits;
} GPAGESTR;
extern volatile GPAGESTR _GPAGE @(REG_BASE + 0x00000010UL);
#define GPAGE                           _GPAGE.Byte
#define GPAGE_GP0                       _GPAGE.Bits.GP0
#define GPAGE_GP1                       _GPAGE.Bits.GP1
#define GPAGE_GP2                       _GPAGE.Bits.GP2
#define GPAGE_GP3                       _GPAGE.Bits.GP3
#define GPAGE_GP4                       _GPAGE.Bits.GP4
#define GPAGE_GP5                       _GPAGE.Bits.GP5
#define GPAGE_GP6                       _GPAGE.Bits.GP6
#define GPAGE_GP                        _GPAGE.MergedBits.grpGP

#define GPAGE_GP0_MASK                  1U
#define GPAGE_GP1_MASK                  2U
#define GPAGE_GP2_MASK                  4U
#define GPAGE_GP3_MASK                  8U
#define GPAGE_GP4_MASK                  16U
#define GPAGE_GP5_MASK                  32U
#define GPAGE_GP6_MASK                  64U
#define GPAGE_GP_MASK                   127U
#define GPAGE_GP_BITNUM                 0U


/*** DIRECT - Direct Page Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Index Bit 8 */
    byte DP9         :1;                                       /* Direct Page Index Bit 9 */
    byte DP10        :1;                                       /* Direct Page Index Bit 10 */
    byte DP11        :1;                                       /* Direct Page Index Bit 11 */
    byte DP12        :1;                                       /* Direct Page Index Bit 12 */
    byte DP13        :1;                                       /* Direct Page Index Bit 13 */
    byte DP14        :1;                                       /* Direct Page Index Bit 14 */
    byte DP15        :1;                                       /* Direct Page Index Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000011UL);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1U
#define DIRECT_DP9_MASK                 2U
#define DIRECT_DP10_MASK                4U
#define DIRECT_DP11_MASK                8U
#define DIRECT_DP12_MASK                16U
#define DIRECT_DP13_MASK                32U
#define DIRECT_DP14_MASK                64U
#define DIRECT_DP15_MASK                128U


/*** MMCCTL1 - MMC Control Register; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable FLASH or ROM in the memory map */
    byte ROMHM       :1;                                       /* FLASH or ROM only in higher Half of Memory Map */
    byte EROMON      :1;                                       /* Enables emulated Flash or ROM memory in the memory map */
    byte RAMHM       :1;                                       /* RAM only in higher Half of the memory map */
    byte PGMIFRON    :1;                                       /* Program Flash Information Row (IFR) visible in the global memory map */
    byte EEEIFRON    :1;                                       /* EEE IFR visible in the memory map */
    byte             :1; 
    byte TGMRAMON    :1;                                       /* EEE Tag RAM and FTM SCRATCH RAM visible in the memory map */
  } Bits;
} MMCCTL1STR;
extern volatile MMCCTL1STR _MMCCTL1 @(REG_BASE + 0x00000013UL);
#define MMCCTL1                         _MMCCTL1.Byte
#define MMCCTL1_ROMON                   _MMCCTL1.Bits.ROMON
#define MMCCTL1_ROMHM                   _MMCCTL1.Bits.ROMHM
#define MMCCTL1_EROMON                  _MMCCTL1.Bits.EROMON
#define MMCCTL1_RAMHM                   _MMCCTL1.Bits.RAMHM
#define MMCCTL1_PGMIFRON                _MMCCTL1.Bits.PGMIFRON
#define MMCCTL1_EEEIFRON                _MMCCTL1.Bits.EEEIFRON
#define MMCCTL1_TGMRAMON                _MMCCTL1.Bits.TGMRAMON

#define MMCCTL1_ROMON_MASK              1U
#define MMCCTL1_ROMHM_MASK              2U
#define MMCCTL1_EROMON_MASK             4U
#define MMCCTL1_RAMHM_MASK              8U
#define MMCCTL1_PGMIFRON_MASK           16U
#define MMCCTL1_EEEIFRON_MASK           32U
#define MMCCTL1_TGMRAMON_MASK           128U


/*** PPAGE - Program Page Index Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte PIX4        :1;                                       /* Program Page Index Bit 4 */
    byte PIX5        :1;                                       /* Program Page Index Bit 5 */
    byte PIX6        :1;                                       /* Program Page Index Bit 6 */
    byte PIX7        :1;                                       /* Program Page Index Bit 7 */
  } Bits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000015UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX6                      _PPAGE.Bits.PIX6
#define PPAGE_PIX7                      _PPAGE.Bits.PIX7

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX4_MASK                 16U
#define PPAGE_PIX5_MASK                 32U
#define PPAGE_PIX6_MASK                 64U
#define PPAGE_PIX7_MASK                 128U


/*** RPAGE - RAM Page Index Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte RP0         :1;                                       /* RAM Page Index Bit 0 */
    byte RP1         :1;                                       /* RAM Page Index Bit 1 */
    byte RP2         :1;                                       /* RAM Page Index Bit 2 */
    byte RP3         :1;                                       /* RAM Page Index Bit 3 */
    byte RP4         :1;                                       /* RAM Page Index Bit 4 */
    byte RP5         :1;                                       /* RAM Page Index Bit 5 */
    byte RP6         :1;                                       /* RAM Page Index Bit 6 */
    byte RP7         :1;                                       /* RAM Page Index Bit 7 */
  } Bits;
} RPAGESTR;
extern volatile RPAGESTR _RPAGE @(REG_BASE + 0x00000016UL);
#define RPAGE                           _RPAGE.Byte
#define RPAGE_RP0                       _RPAGE.Bits.RP0
#define RPAGE_RP1                       _RPAGE.Bits.RP1
#define RPAGE_RP2                       _RPAGE.Bits.RP2
#define RPAGE_RP3                       _RPAGE.Bits.RP3
#define RPAGE_RP4                       _RPAGE.Bits.RP4
#define RPAGE_RP5                       _RPAGE.Bits.RP5
#define RPAGE_RP6                       _RPAGE.Bits.RP6
#define RPAGE_RP7                       _RPAGE.Bits.RP7

#define RPAGE_RP0_MASK                  1U
#define RPAGE_RP1_MASK                  2U
#define RPAGE_RP2_MASK                  4U
#define RPAGE_RP3_MASK                  8U
#define RPAGE_RP4_MASK                  16U
#define RPAGE_RP5_MASK                  32U
#define RPAGE_RP6_MASK                  64U
#define RPAGE_RP7_MASK                  128U


/*** EPAGE - Data FLASH Page Index Register; 0x00000017 ***/
typedef union {
  byte Byte;
  struct {
    byte EP0         :1;                                       /* Data FLASH Page Index Bit 0 */
    byte EP1         :1;                                       /* Data FLASH Page Index Bit 1 */
    byte EP2         :1;                                       /* Data FLASH Page Index Bit 2 */
    byte EP3         :1;                                       /* Data FLASH Page Index Bit 3 */
    byte EP4         :1;                                       /* Data FLASH Page Index Bit 4 */
    byte EP5         :1;                                       /* Data FLASH Page Index Bit 5 */
    byte EP6         :1;                                       /* Data FLASH Page Index Bit 6 */
    byte EP7         :1;                                       /* Data FLASH Page Index Bit 7 */
  } Bits;
} EPAGESTR;
extern volatile EPAGESTR _EPAGE @(REG_BASE + 0x00000017UL);
#define EPAGE                           _EPAGE.Byte
#define EPAGE_EP0                       _EPAGE.Bits.EP0
#define EPAGE_EP1                       _EPAGE.Bits.EP1
#define EPAGE_EP2                       _EPAGE.Bits.EP2
#define EPAGE_EP3                       _EPAGE.Bits.EP3
#define EPAGE_EP4                       _EPAGE.Bits.EP4
#define EPAGE_EP5                       _EPAGE.Bits.EP5
#define EPAGE_EP6                       _EPAGE.Bits.EP6
#define EPAGE_EP7                       _EPAGE.Bits.EP7

#define EPAGE_EP0_MASK                  1U
#define EPAGE_EP1_MASK                  2U
#define EPAGE_EP2_MASK                  4U
#define EPAGE_EP3_MASK                  8U
#define EPAGE_EP4_MASK                  16U
#define EPAGE_EP5_MASK                  32U
#define EPAGE_EP6_MASK                  64U
#define EPAGE_EP7_MASK                  128U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** ECLKCTL - ECLK Control Register; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* Free-running ECLK Divider, bit 0 */
    byte EDIV1       :1;                                       /* Free-running ECLK Divider, bit 1 */
    byte EDIV2       :1;                                       /* Free-running ECLK Divider, bit 2 */
    byte EDIV3       :1;                                       /* Free-running ECLK Divider, bit 3 */
    byte EDIV4       :1;                                       /* Free-running ECLK Divider, bit 4 */
    byte DIV16       :1;                                       /* Free-running ECLK predivider */
    byte NCLKX2      :1;                                       /* No ECLKX2 */
    byte NECLK       :1;                                       /* No ECLK */
  } Bits;
  struct {
    byte grpEDIV :5;
    byte grpDIV_16 :1;
    byte grpNCLKX_2 :1;
    byte         :1;
  } MergedBits;
} ECLKCTLSTR;
extern volatile ECLKCTLSTR _ECLKCTL @(REG_BASE + 0x0000001CUL);
#define ECLKCTL                         _ECLKCTL.Byte
#define ECLKCTL_EDIV0                   _ECLKCTL.Bits.EDIV0
#define ECLKCTL_EDIV1                   _ECLKCTL.Bits.EDIV1
#define ECLKCTL_EDIV2                   _ECLKCTL.Bits.EDIV2
#define ECLKCTL_EDIV3                   _ECLKCTL.Bits.EDIV3
#define ECLKCTL_EDIV4                   _ECLKCTL.Bits.EDIV4
#define ECLKCTL_DIV16                   _ECLKCTL.Bits.DIV16
#define ECLKCTL_NCLKX2                  _ECLKCTL.Bits.NCLKX2
#define ECLKCTL_NECLK                   _ECLKCTL.Bits.NECLK
#define ECLKCTL_EDIV                    _ECLKCTL.MergedBits.grpEDIV

#define ECLKCTL_EDIV0_MASK              1U
#define ECLKCTL_EDIV1_MASK              2U
#define ECLKCTL_EDIV2_MASK              4U
#define ECLKCTL_EDIV3_MASK              8U
#define ECLKCTL_EDIV4_MASK              16U
#define ECLKCTL_DIV16_MASK              32U
#define ECLKCTL_NCLKX2_MASK             64U
#define ECLKCTL_NECLK_MASK              128U
#define ECLKCTL_EDIV_MASK               31U
#define ECLKCTL_EDIV_BITNUM             0U


/*** IRQCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} IRQCRSTR;
extern volatile IRQCRSTR _IRQCR @(REG_BASE + 0x0000001EUL);
#define IRQCR                           _IRQCR.Byte
#define IRQCR_IRQEN                     _IRQCR.Bits.IRQEN
#define IRQCR_IRQE                      _IRQCR.Bits.IRQE

#define IRQCR_IRQEN_MASK                64U
#define IRQCR_IRQE_MASK                 128U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte COMRV       :2;                                       /* Comparator Register Visibility Bits */
    byte DBGBRK      :2;                                       /* S12XDBG Breakpoint Enable Bits */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte XGSBPE      :1;                                       /* XGATE S/W Breakpoint Enable */
    byte TRIG        :1;                                       /* Immediate Trigger Request Bit */
    byte ARM         :1;                                       /* Arm Bit */
  } Bits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_COMRV                     _DBGC1.Bits.COMRV
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BDM                       _DBGC1.Bits.BDM
#define DBGC1_XGSBPE                    _DBGC1.Bits.XGSBPE
#define DBGC1_TRIG                      _DBGC1.Bits.TRIG
#define DBGC1_ARM                       _DBGC1.Bits.ARM

#define DBGC1_COMRV_MASK                3U
#define DBGC1_COMRV_BITNUM              0U
#define DBGC1_DBGBRK_MASK               12U
#define DBGC1_DBGBRK_BITNUM             2U
#define DBGC1_BDM_MASK                  16U
#define DBGC1_XGSBPE_MASK               32U
#define DBGC1_TRIG_MASK                 64U
#define DBGC1_ARM_MASK                  128U


/*** DBGSR - Debug Status Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSF0        :1;                                       /* State Sequencer Flag Bits */
    byte SSF1        :1;                                       /* State Sequencer Flag Bit 1 */
    byte SSF2        :1;                                       /* State Sequencer Flag Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte EXTF        :1;                                       /* External Tag Hit Flag */
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpSSF  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSRSTR;
extern volatile DBGSRSTR _DBGSR @(REG_BASE + 0x00000021UL);
#define DBGSR                           _DBGSR.Byte
#define DBGSR_SSF0                      _DBGSR.Bits.SSF0
#define DBGSR_SSF1                      _DBGSR.Bits.SSF1
#define DBGSR_SSF2                      _DBGSR.Bits.SSF2
#define DBGSR_EXTF                      _DBGSR.Bits.EXTF
#define DBGSR_TBF                       _DBGSR.Bits.TBF
#define DBGSR_SSF                       _DBGSR.MergedBits.grpSSF

#define DBGSR_SSF0_MASK                 1U
#define DBGSR_SSF1_MASK                 2U
#define DBGSR_SSF2_MASK                 4U
#define DBGSR_EXTF_MASK                 64U
#define DBGSR_TBF_MASK                  128U
#define DBGSR_SSF_MASK                  7U
#define DBGSR_SSF_BITNUM                0U


/*** DBGTCR - Debug Trace Control Register; 0x00000022 ***/
typedef union {
  byte Byte;
  struct {
    byte TALIGN      :2;                                       /* Trigger Align Bits */
    byte TRCMOD      :2;                                       /* Trace Mode Bits */
    byte TRANGE      :2;                                       /* Trace Range Bits */
    byte TSOURCE     :2;                                       /* Trace Source Control Bits */
  } Bits;
} DBGTCRSTR;
extern volatile DBGTCRSTR _DBGTCR @(REG_BASE + 0x00000022UL);
#define DBGTCR                          _DBGTCR.Byte
#define DBGTCR_TALIGN                   _DBGTCR.Bits.TALIGN
#define DBGTCR_TRCMOD                   _DBGTCR.Bits.TRCMOD
#define DBGTCR_TRANGE                   _DBGTCR.Bits.TRANGE
#define DBGTCR_TSOURCE                  _DBGTCR.Bits.TSOURCE

#define DBGTCR_TALIGN_MASK              3U
#define DBGTCR_TALIGN_BITNUM            0U
#define DBGTCR_TRCMOD_MASK              12U
#define DBGTCR_TRCMOD_BITNUM            2U
#define DBGTCR_TRANGE_MASK              48U
#define DBGTCR_TRANGE_BITNUM            4U
#define DBGTCR_TSOURCE_MASK             192U
#define DBGTCR_TSOURCE_BITNUM           6U


/*** DBGC2 - Debug Control Register 2; 0x00000023 ***/
typedef union {
  byte Byte;
  struct {
    byte ABCM        :2;                                       /* A and B Comparator Match Control */
    byte CDCM        :2;                                       /* C and D Comparator Match Control */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000023UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_ABCM                      _DBGC2.Bits.ABCM
#define DBGC2_CDCM                      _DBGC2.Bits.CDCM

#define DBGC2_ABCM_MASK                 3U
#define DBGC2_ABCM_BITNUM               0U
#define DBGC2_CDCM_MASK                 12U
#define DBGC2_CDCM_BITNUM               2U


/*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Trace Buffer Data Bits */
        byte BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
        byte BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
        byte BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
        byte BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
        byte BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
        byte BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
        byte BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Trace Buffer Data Bits */
        byte BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
        byte BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
        byte BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
        byte BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
        byte BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
        byte BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
        byte BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Trace Buffer Data Bits */
    word BIT1        :1;                                       /* Trace Buffer Data Bit 1 */
    word BIT2        :1;                                       /* Trace Buffer Data Bit 2 */
    word BIT3        :1;                                       /* Trace Buffer Data Bit 3 */
    word BIT4        :1;                                       /* Trace Buffer Data Bit 4 */
    word BIT5        :1;                                       /* Trace Buffer Data Bit 5 */
    word BIT6        :1;                                       /* Trace Buffer Data Bit 6 */
    word BIT7        :1;                                       /* Trace Buffer Data Bit 7 */
    word BIT8        :1;                                       /* Trace Buffer Data Bit 8 */
    word BIT9        :1;                                       /* Trace Buffer Data Bit 9 */
    word BIT10       :1;                                       /* Trace Buffer Data Bit 10 */
    word BIT11       :1;                                       /* Trace Buffer Data Bit 11 */
    word BIT12       :1;                                       /* Trace Buffer Data Bit 12 */
    word BIT13       :1;                                       /* Trace Buffer Data Bit 13 */
    word BIT14       :1;                                       /* Trace Buffer Data Bit 14 */
    word BIT15       :1;                                       /* Trace Buffer Data Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000024UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000026 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT         :7;                                       /* Count Value */
    byte             :1; 
  } Bits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000026UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT                      _DBGCNT.Bits.CNT

#define DBGCNT_CNT_MASK                 127U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGSCRX - Debug State Control Register; 0x00000027 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** DBGSCRX - Debug State Control Register; Several registers at the same address ***/
    union {
      struct {
        byte SC0         :1;                                       /* State X Sequencer Next State Selection Bit 0 */
        byte SC1         :1;                                       /* State X Sequencer Next State Selection Bit 1 */
        byte SC2         :1;                                       /* State X Sequencer Next State Selection Bit 2 */
        byte SC3         :1;                                       /* State X Sequencer Next State Selection Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGSCRXSTR;
    #define DBGSCRX                     _DBGSCRX.Byte
    #define DBGSCRX_SC0                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC0
    #define DBGSCRX_SC1                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC1
    #define DBGSCRX_SC2                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC2
    #define DBGSCRX_SC3                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC3
    #define DBGSCRX_SC                  _DBGSCRX.SameAddr_STR.DBGSCRXSTR.MergedBits.grpSC
    
    #define DBGSCRX_SC0_MASK            1U
    #define DBGSCRX_SC1_MASK            2U
    #define DBGSCRX_SC2_MASK            4U
    #define DBGSCRX_SC3_MASK            8U
    #define DBGSCRX_SC_MASK             15U
    #define DBGSCRX_SC_BITNUM           0U
    
    /*** DBGMFR - Debug Match Flag Register; Several registers at the same address ***/
    union {
      struct {
        byte MC0         :1;                                       /* Debug Match Flag Bit 0 */
        byte MC1         :1;                                       /* Debug Match Flag Bit 1 */
        byte MC2         :1;                                       /* Debug Match Flag Bit 2 */
        byte MC3         :1;                                       /* Debug Match Flag Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpMC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGMFRSTR;
    #define DBGMFR                      _DBGSCRX.Byte
    #define DBGMFR_MC0                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC0
    #define DBGMFR_MC1                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC1
    #define DBGMFR_MC2                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC2
    #define DBGMFR_MC3                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC3
    #define DBGMFR_MC                   _DBGSCRX.SameAddr_STR.DBGMFRSTR.MergedBits.grpMC
    
    #define DBGMFR_MC0_MASK             1U
    #define DBGMFR_MC1_MASK             2U
    #define DBGMFR_MC2_MASK             4U
    #define DBGMFR_MC3_MASK             8U
    #define DBGMFR_MC_MASK              15U
    #define DBGMFR_MC_BITNUM            0U
    
  } SameAddr_STR; /*Several registers at the same address */

} DBGSCRXSTR;
extern volatile DBGSCRXSTR _DBGSCRX @(REG_BASE + 0x00000027UL);


/*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte COMPE       :1;                                       /* Determines if comparator is enabled */
    byte SRC         :1;                                       /* Determines mapping of comparator to CPU or XGATE */
    byte RWE         :1;                                       /* Read/Write Enable Bit */
    byte RW          :1;                                       /* Read/Write Comparator Value Bit */
    byte BRK         :1;                                       /* Break */
    byte TAG         :1;                                       /* Tag Select */
    byte NDB_SZ      :1;                                       /* Not Data Bus(Comparators A and C), Size Comparator Value Bit(Comparators B and D) */
    byte SZE         :1;                                       /* Size Comparator Enable Bit */
  } Bits;
} DBGXCTLSTR;
extern volatile DBGXCTLSTR _DBGXCTL @(REG_BASE + 0x00000028UL);
#define DBGXCTL                         _DBGXCTL.Byte
#define DBGXCTL_COMPE                   _DBGXCTL.Bits.COMPE
#define DBGXCTL_SRC                     _DBGXCTL.Bits.SRC
#define DBGXCTL_RWE                     _DBGXCTL.Bits.RWE
#define DBGXCTL_RW                      _DBGXCTL.Bits.RW
#define DBGXCTL_BRK                     _DBGXCTL.Bits.BRK
#define DBGXCTL_TAG                     _DBGXCTL.Bits.TAG
#define DBGXCTL_NDB_SZ                  _DBGXCTL.Bits.NDB_SZ
#define DBGXCTL_SZE                     _DBGXCTL.Bits.SZE

#define DBGXCTL_COMPE_MASK              1U
#define DBGXCTL_SRC_MASK                2U
#define DBGXCTL_RWE_MASK                4U
#define DBGXCTL_RW_MASK                 8U
#define DBGXCTL_BRK_MASK                16U
#define DBGXCTL_TAG_MASK                32U
#define DBGXCTL_NDB_SZ_MASK             64U
#define DBGXCTL_SZE_MASK                128U


/*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT16       :1;                                       /* Comparator Address High Compare Bits */
    byte BIT17       :1;                                       /* Comparator Address High Compare Bit 17 */
    byte BIT18       :1;                                       /* Comparator Address High Compare Bit 18 */
    byte BIT19       :1;                                       /* Comparator Address High Compare Bit 19 */
    byte BIT20       :1;                                       /* Comparator Address High Compare Bit 20 */
    byte BIT21       :1;                                       /* Comparator Address High Compare Bit 21 */
    byte BIT22       :1;                                       /* Comparator Address High Compare Bit 22 */
    byte             :1; 
  } Bits;
  struct {
    byte grpBIT_16 :7;
    byte         :1;
  } MergedBits;
} DBGXAHSTR;
extern volatile DBGXAHSTR _DBGXAH @(REG_BASE + 0x00000029UL);
#define DBGXAH                          _DBGXAH.Byte
#define DBGXAH_BIT16                    _DBGXAH.Bits.BIT16
#define DBGXAH_BIT17                    _DBGXAH.Bits.BIT17
#define DBGXAH_BIT18                    _DBGXAH.Bits.BIT18
#define DBGXAH_BIT19                    _DBGXAH.Bits.BIT19
#define DBGXAH_BIT20                    _DBGXAH.Bits.BIT20
#define DBGXAH_BIT21                    _DBGXAH.Bits.BIT21
#define DBGXAH_BIT22                    _DBGXAH.Bits.BIT22
#define DBGXAH_BIT_16                   _DBGXAH.MergedBits.grpBIT_16
#define DBGXAH_BIT                      DBGXAH_BIT_16

#define DBGXAH_BIT16_MASK               1U
#define DBGXAH_BIT17_MASK               2U
#define DBGXAH_BIT18_MASK               4U
#define DBGXAH_BIT19_MASK               8U
#define DBGXAH_BIT20_MASK               16U
#define DBGXAH_BIT21_MASK               32U
#define DBGXAH_BIT22_MASK               64U
#define DBGXAH_BIT_16_MASK              127U
#define DBGXAH_BIT_16_BITNUM            0U


/*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Address Mid Compare Bits */
    byte BIT9        :1;                                       /* Comparator Address Mid Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Address Mid Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Address Mid Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Address Mid Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Address Mid Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Address Mid Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Address Mid Compare Bit 15 */
  } Bits;
} DBGXAMSTR;
extern volatile DBGXAMSTR _DBGXAM @(REG_BASE + 0x0000002AUL);
#define DBGXAM                          _DBGXAM.Byte
#define DBGXAM_BIT8                     _DBGXAM.Bits.BIT8
#define DBGXAM_BIT9                     _DBGXAM.Bits.BIT9
#define DBGXAM_BIT10                    _DBGXAM.Bits.BIT10
#define DBGXAM_BIT11                    _DBGXAM.Bits.BIT11
#define DBGXAM_BIT12                    _DBGXAM.Bits.BIT12
#define DBGXAM_BIT13                    _DBGXAM.Bits.BIT13
#define DBGXAM_BIT14                    _DBGXAM.Bits.BIT14
#define DBGXAM_BIT15                    _DBGXAM.Bits.BIT15

#define DBGXAM_BIT8_MASK                1U
#define DBGXAM_BIT9_MASK                2U
#define DBGXAM_BIT10_MASK               4U
#define DBGXAM_BIT11_MASK               8U
#define DBGXAM_BIT12_MASK               16U
#define DBGXAM_BIT13_MASK               32U
#define DBGXAM_BIT14_MASK               64U
#define DBGXAM_BIT15_MASK               128U


/*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bits */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXALSTR;
extern volatile DBGXALSTR _DBGXAL @(REG_BASE + 0x0000002BUL);
#define DBGXAL                          _DBGXAL.Byte
#define DBGXAL_BIT0                     _DBGXAL.Bits.BIT0
#define DBGXAL_BIT1                     _DBGXAL.Bits.BIT1
#define DBGXAL_BIT2                     _DBGXAL.Bits.BIT2
#define DBGXAL_BIT3                     _DBGXAL.Bits.BIT3
#define DBGXAL_BIT4                     _DBGXAL.Bits.BIT4
#define DBGXAL_BIT5                     _DBGXAL.Bits.BIT5
#define DBGXAL_BIT6                     _DBGXAL.Bits.BIT6
#define DBGXAL_BIT7                     _DBGXAL.Bits.BIT7

#define DBGXAL_BIT0_MASK                1U
#define DBGXAL_BIT1_MASK                2U
#define DBGXAL_BIT2_MASK                4U
#define DBGXAL_BIT3_MASK                8U
#define DBGXAL_BIT4_MASK                16U
#define DBGXAL_BIT5_MASK                32U
#define DBGXAL_BIT6_MASK                64U
#define DBGXAL_BIT7_MASK                128U


/*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Compare Bit 15 */
  } Bits;
} DBGXDHSTR;
extern volatile DBGXDHSTR _DBGXDH @(REG_BASE + 0x0000002CUL);
#define DBGXDH                          _DBGXDH.Byte
#define DBGXDH_BIT8                     _DBGXDH.Bits.BIT8
#define DBGXDH_BIT9                     _DBGXDH.Bits.BIT9
#define DBGXDH_BIT10                    _DBGXDH.Bits.BIT10
#define DBGXDH_BIT11                    _DBGXDH.Bits.BIT11
#define DBGXDH_BIT12                    _DBGXDH.Bits.BIT12
#define DBGXDH_BIT13                    _DBGXDH.Bits.BIT13
#define DBGXDH_BIT14                    _DBGXDH.Bits.BIT14
#define DBGXDH_BIT15                    _DBGXDH.Bits.BIT15

#define DBGXDH_BIT8_MASK                1U
#define DBGXDH_BIT9_MASK                2U
#define DBGXDH_BIT10_MASK               4U
#define DBGXDH_BIT11_MASK               8U
#define DBGXDH_BIT12_MASK               16U
#define DBGXDH_BIT13_MASK               32U
#define DBGXDH_BIT14_MASK               64U
#define DBGXDH_BIT15_MASK               128U


/*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Compare Bit 7 */
  } Bits;
} DBGXDLSTR;
extern volatile DBGXDLSTR _DBGXDL @(REG_BASE + 0x0000002DUL);
#define DBGXDL                          _DBGXDL.Byte
#define DBGXDL_BIT0                     _DBGXDL.Bits.BIT0
#define DBGXDL_BIT1                     _DBGXDL.Bits.BIT1
#define DBGXDL_BIT2                     _DBGXDL.Bits.BIT2
#define DBGXDL_BIT3                     _DBGXDL.Bits.BIT3
#define DBGXDL_BIT4                     _DBGXDL.Bits.BIT4
#define DBGXDL_BIT5                     _DBGXDL.Bits.BIT5
#define DBGXDL_BIT6                     _DBGXDL.Bits.BIT6
#define DBGXDL_BIT7                     _DBGXDL.Bits.BIT7

#define DBGXDL_BIT0_MASK                1U
#define DBGXDL_BIT1_MASK                2U
#define DBGXDL_BIT2_MASK                4U
#define DBGXDL_BIT3_MASK                8U
#define DBGXDL_BIT4_MASK                16U
#define DBGXDL_BIT5_MASK                32U
#define DBGXDL_BIT6_MASK                64U
#define DBGXDL_BIT7_MASK                128U


/*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Mask Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Mask Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Mask Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Mask Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Mask Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Mask Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Mask Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Mask Bit 15 */
  } Bits;
} DBGXDHMSTR;
extern volatile DBGXDHMSTR _DBGXDHM @(REG_BASE + 0x0000002EUL);
#define DBGXDHM                         _DBGXDHM.Byte
#define DBGXDHM_BIT8                    _DBGXDHM.Bits.BIT8
#define DBGXDHM_BIT9                    _DBGXDHM.Bits.BIT9
#define DBGXDHM_BIT10                   _DBGXDHM.Bits.BIT10
#define DBGXDHM_BIT11                   _DBGXDHM.Bits.BIT11
#define DBGXDHM_BIT12                   _DBGXDHM.Bits.BIT12
#define DBGXDHM_BIT13                   _DBGXDHM.Bits.BIT13
#define DBGXDHM_BIT14                   _DBGXDHM.Bits.BIT14
#define DBGXDHM_BIT15                   _DBGXDHM.Bits.BIT15

#define DBGXDHM_BIT8_MASK               1U
#define DBGXDHM_BIT9_MASK               2U
#define DBGXDHM_BIT10_MASK              4U
#define DBGXDHM_BIT11_MASK              8U
#define DBGXDHM_BIT12_MASK              16U
#define DBGXDHM_BIT13_MASK              32U
#define DBGXDHM_BIT14_MASK              64U
#define DBGXDHM_BIT15_MASK              128U


/*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data Low Mask Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data Low Mask Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data Low Mask Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data Low Mask Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data Low Mask Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data Low Mask Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data Low Mask Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data Low Mask Bit 7 */
  } Bits;
} DBGXDLMSTR;
extern volatile DBGXDLMSTR _DBGXDLM @(REG_BASE + 0x0000002FUL);
#define DBGXDLM                         _DBGXDLM.Byte
#define DBGXDLM_BIT0                    _DBGXDLM.Bits.BIT0
#define DBGXDLM_BIT1                    _DBGXDLM.Bits.BIT1
#define DBGXDLM_BIT2                    _DBGXDLM.Bits.BIT2
#define DBGXDLM_BIT3                    _DBGXDLM.Bits.BIT3
#define DBGXDLM_BIT4                    _DBGXDLM.Bits.BIT4
#define DBGXDLM_BIT5                    _DBGXDLM.Bits.BIT5
#define DBGXDLM_BIT6                    _DBGXDLM.Bits.BIT6
#define DBGXDLM_BIT7                    _DBGXDLM.Bits.BIT7

#define DBGXDLM_BIT0_MASK               1U
#define DBGXDLM_BIT1_MASK               2U
#define DBGXDLM_BIT2_MASK               4U
#define DBGXDLM_BIT3_MASK               8U
#define DBGXDLM_BIT4_MASK               16U
#define DBGXDLM_BIT5_MASK               32U
#define DBGXDLM_BIT6_MASK               64U
#define DBGXDLM_BIT7_MASK               128U


/*** PORTK - Port K Data Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte PK0         :1;                                       /* Port K Bit 0 */
    byte PK1         :1;                                       /* Port K Bit 1 */
    byte PK2         :1;                                       /* Port K Bit 2 */
    byte PK3         :1;                                       /* Port K Bit 3 */
    byte PK4         :1;                                       /* Port K Bit 4 */
    byte PK5         :1;                                       /* Port K Bit 5 */
    byte PK6         :1;                                       /* Port K Bit 6 */
    byte PK7         :1;                                       /* Port K Bit 7 */
  } Bits;
} PORTKSTR;
extern volatile PORTKSTR _PORTK @(REG_BASE + 0x00000032UL);
#define PORTK                           _PORTK.Byte
#define PORTK_PK0                       _PORTK.Bits.PK0
#define PORTK_PK1                       _PORTK.Bits.PK1
#define PORTK_PK2                       _PORTK.Bits.PK2
#define PORTK_PK3                       _PORTK.Bits.PK3
#define PORTK_PK4                       _PORTK.Bits.PK4
#define PORTK_PK5                       _PORTK.Bits.PK5
#define PORTK_PK6                       _PORTK.Bits.PK6
#define PORTK_PK7                       _PORTK.Bits.PK7

#define PORTK_PK0_MASK                  1U
#define PORTK_PK1_MASK                  2U
#define PORTK_PK2_MASK                  4U
#define PORTK_PK3_MASK                  8U
#define PORTK_PK4_MASK                  16U
#define PORTK_PK5_MASK                  32U
#define PORTK_PK6_MASK                  64U
#define PORTK_PK7_MASK                  128U


/*** DDRK - Port K Data Direction Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRK0       :1;                                       /* Data Direction Port K Bit 0 */
    byte DDRK1       :1;                                       /* Data Direction Port K Bit 1 */
    byte DDRK2       :1;                                       /* Data Direction Port K Bit 2 */
    byte DDRK3       :1;                                       /* Data Direction Port K Bit 3 */
    byte DDRK4       :1;                                       /* Data Direction Port K Bit 4 */
    byte DDRK5       :1;                                       /* Data Direction Port K Bit 5 */
    byte DDRK6       :1;                                       /* Data Direction Port K Bit 6 */
    byte DDRK7       :1;                                       /* Data Direction Port K Bit 7 */
  } Bits;
} DDRKSTR;
extern volatile DDRKSTR _DDRK @(REG_BASE + 0x00000033UL);
#define DDRK                            _DDRK.Byte
#define DDRK_DDRK0                      _DDRK.Bits.DDRK0
#define DDRK_DDRK1                      _DDRK.Bits.DDRK1
#define DDRK_DDRK2                      _DDRK.Bits.DDRK2
#define DDRK_DDRK3                      _DDRK.Bits.DDRK3
#define DDRK_DDRK4                      _DDRK.Bits.DDRK4
#define DDRK_DDRK5                      _DDRK.Bits.DDRK5
#define DDRK_DDRK6                      _DDRK.Bits.DDRK6
#define DDRK_DDRK7                      _DDRK.Bits.DDRK7

#define DDRK_DDRK0_MASK                 1U
#define DDRK_DDRK1_MASK                 2U
#define DDRK_DDRK2_MASK                 4U
#define DDRK_DDRK3_MASK                 8U
#define DDRK_DDRK4_MASK                 16U
#define DDRK_DDRK5_MASK                 32U
#define DDRK_DDRK6_MASK                 64U
#define DDRK_DDRK7_MASK                 128U


/*** SYNR - S12XECRG Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYNDIV0     :1;                                       /* Multiplication factor of the IPLL bit 0 */
    byte SYNDIV1     :1;                                       /* Multiplication factor of the IPLL bit 1 */
    byte SYNDIV2     :1;                                       /* Multiplication factor of the IPLL bit 2 */
    byte SYNDIV3     :1;                                       /* Multiplication factor of the IPLL bit 3 */
    byte SYNDIV4     :1;                                       /* Multiplication factor of the IPLL bit 4 */
    byte SYNDIV5     :1;                                       /* Multiplication factor of the IPLL bit 5 */
    byte VCOFRQ0     :1;                                       /* VCO frequency range bit 0 */
    byte VCOFRQ1     :1;                                       /* VCO frequency range bit 1 */
  } Bits;
  struct {
    byte grpSYNDIV :6;
    byte grpVCOFRQ :2;
  } MergedBits;
} SYNRSTR;
extern volatile SYNRSTR _SYNR @(REG_BASE + 0x00000034UL);
#define SYNR                            _SYNR.Byte
#define SYNR_SYNDIV0                    _SYNR.Bits.SYNDIV0
#define SYNR_SYNDIV1                    _SYNR.Bits.SYNDIV1
#define SYNR_SYNDIV2                    _SYNR.Bits.SYNDIV2
#define SYNR_SYNDIV3                    _SYNR.Bits.SYNDIV3
#define SYNR_SYNDIV4                    _SYNR.Bits.SYNDIV4
#define SYNR_SYNDIV5                    _SYNR.Bits.SYNDIV5
#define SYNR_VCOFRQ0                    _SYNR.Bits.VCOFRQ0
#define SYNR_VCOFRQ1                    _SYNR.Bits.VCOFRQ1
#define SYNR_SYNDIV                     _SYNR.MergedBits.grpSYNDIV
#define SYNR_VCOFRQ                     _SYNR.MergedBits.grpVCOFRQ

#define SYNR_SYNDIV0_MASK               1U
#define SYNR_SYNDIV1_MASK               2U
#define SYNR_SYNDIV2_MASK               4U
#define SYNR_SYNDIV3_MASK               8U
#define SYNR_SYNDIV4_MASK               16U
#define SYNR_SYNDIV5_MASK               32U
#define SYNR_VCOFRQ0_MASK               64U
#define SYNR_VCOFRQ1_MASK               128U
#define SYNR_SYNDIV_MASK                63U
#define SYNR_SYNDIV_BITNUM              0U
#define SYNR_VCOFRQ_MASK                192U
#define SYNR_VCOFRQ_BITNUM              6U


/*** REFDV - S12XECRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDIV0     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 0 */
    byte REFDIV1     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 1 */
    byte REFDIV2     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 2 */
    byte REFDIV3     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 3 */
    byte REFDIV4     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 4 */
    byte REFDIV5     :1;                                       /* Finer granularity for the IPLL multiplier steps bit 5 */
    byte REFFRQ0     :1;                                       /* IPLL optimal stability and lock time configuration bit 0 */
    byte REFFRQ1     :1;                                       /* IPLL optimal stability and lock time configuration bit 1 */
  } Bits;
  struct {
    byte grpREFDIV :6;
    byte grpREFFRQ :2;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035UL);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDIV0                   _REFDV.Bits.REFDIV0
#define REFDV_REFDIV1                   _REFDV.Bits.REFDIV1
#define REFDV_REFDIV2                   _REFDV.Bits.REFDIV2
#define REFDV_REFDIV3                   _REFDV.Bits.REFDIV3
#define REFDV_REFDIV4                   _REFDV.Bits.REFDIV4
#define REFDV_REFDIV5                   _REFDV.Bits.REFDIV5
#define REFDV_REFFRQ0                   _REFDV.Bits.REFFRQ0
#define REFDV_REFFRQ1                   _REFDV.Bits.REFFRQ1
#define REFDV_REFDIV                    _REFDV.MergedBits.grpREFDIV
#define REFDV_REFFRQ                    _REFDV.MergedBits.grpREFFRQ

#define REFDV_REFDIV0_MASK              1U
#define REFDV_REFDIV1_MASK              2U
#define REFDV_REFDIV2_MASK              4U
#define REFDV_REFDIV3_MASK              8U
#define REFDV_REFDIV4_MASK              16U
#define REFDV_REFDIV5_MASK              32U
#define REFDV_REFFRQ0_MASK              64U
#define REFDV_REFFRQ1_MASK              128U
#define REFDV_REFDIV_MASK               63U
#define REFDV_REFDIV_BITNUM             0U
#define REFDV_REFFRQ_MASK               192U
#define REFDV_REFFRQ_BITNUM             6U


/*** POSTDIV - S12XECRG Post Divider Register; 0x00000036 ***/
typedef union {
  byte Byte;
  struct {
    byte POSTDIV0    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 0 */
    byte POSTDIV1    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 1 */
    byte POSTDIV2    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 2 */
    byte POSTDIV3    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 3 */
    byte POSTDIV4    :1;                                       /* Frequency ratio between the VCOCLK and PLLCLK control bit 4 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPOSTDIV :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} POSTDIVSTR;
extern volatile POSTDIVSTR _POSTDIV @(REG_BASE + 0x00000036UL);
#define POSTDIV                         _POSTDIV.Byte
#define POSTDIV_POSTDIV0                _POSTDIV.Bits.POSTDIV0
#define POSTDIV_POSTDIV1                _POSTDIV.Bits.POSTDIV1
#define POSTDIV_POSTDIV2                _POSTDIV.Bits.POSTDIV2
#define POSTDIV_POSTDIV3                _POSTDIV.Bits.POSTDIV3
#define POSTDIV_POSTDIV4                _POSTDIV.Bits.POSTDIV4
#define POSTDIV_POSTDIV                 _POSTDIV.MergedBits.grpPOSTDIV

#define POSTDIV_POSTDIV0_MASK           1U
#define POSTDIV_POSTDIV1_MASK           2U
#define POSTDIV_POSTDIV2_MASK           4U
#define POSTDIV_POSTDIV3_MASK           8U
#define POSTDIV_POSTDIV4_MASK           16U
#define POSTDIV_POSTDIV_MASK            31U
#define POSTDIV_POSTDIV_BITNUM          0U


/*** CRGFLG - S12XECRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte SCM         :1;                                       /* Self Clock Mode Status Bit */
    byte SCMIF       :1;                                       /* Self Clock Mode Interrupt Flag */
    byte ILAF        :1;                                       /* Illegal Address Reset Flag */
    byte LOCK        :1;                                       /* Lock Status Bit */
    byte LOCKIF      :1;                                       /* IPLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_SCM                      _CRGFLG.Bits.SCM
#define CRGFLG_SCMIF                    _CRGFLG.Bits.SCMIF
#define CRGFLG_ILAF                     _CRGFLG.Bits.ILAF
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_LVRF                     _CRGFLG.Bits.LVRF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_SCM_MASK                 1U
#define CRGFLG_SCMIF_MASK               2U
#define CRGFLG_ILAF_MASK                4U
#define CRGFLG_LOCK_MASK                8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_LVRF_MASK                32U
#define CRGFLG_PORF_MASK                64U
#define CRGFLG_RTIF_MASK                128U


/*** CRGINT - S12XECRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SCMIE       :1;                                       /* Self Clock Mode Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable Bit */
    byte             :1; 
    byte             :1; 
    byte RTIE        :1;                                       /* Real Time Interrupt Enable Bit */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038UL);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_SCMIE                    _CRGINT.Bits.SCMIE
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_SCMIE_MASK               2U
#define CRGINT_LOCKIE_MASK              16U
#define CRGINT_RTIE_MASK                128U


/*** CLKSEL - S12XECRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP Stops in Wait Mode Bit */
    byte RTIWAI      :1;                                       /* RTI Stops in Wait Mode Bit */
    byte             :1; 
    byte PLLWAI      :1;                                       /* PLL Stops in Wait Mode Bit */
    byte             :1; 
    byte XCLKS       :1;                                       /* Oscillator Configuration Status Bit */
    byte PSTP        :1;                                       /* Pseudo Stop Bit */
    byte PLLSEL      :1;                                       /* PLL Select Bit */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039UL);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_PLLWAI                   _CLKSEL.Bits.PLLWAI
#define CLKSEL_XCLKS                    _CLKSEL.Bits.XCLKS
#define CLKSEL_PSTP                     _CLKSEL.Bits.PSTP
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1U
#define CLKSEL_RTIWAI_MASK              2U
#define CLKSEL_PLLWAI_MASK              8U
#define CLKSEL_XCLKS_MASK               32U
#define CLKSEL_PSTP_MASK                64U
#define CLKSEL_PLLSEL_MASK              128U


/*** PLLCTL - S12XECRG IPLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte SCME        :1;                                       /* Self Clock Mode Enable Bit */
    byte PCE         :1;                                       /* COP Enable During Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable During Pseudo Stop Bit */
    byte FSTWKP      :1;                                       /* Fast Wake-up from Full Stop Bit */
    byte FM0         :1;                                       /* IPLL Frequency Modulation Enable Bit 0 */
    byte FM1         :1;                                       /* IPLL Frequency Modulation Enable Bit 1 */
    byte PLLON       :1;                                       /* Phase Lock Loop On Bit */
    byte CME         :1;                                       /* Clock Monitor Enable Bit */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpFM   :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} PLLCTLSTR;
extern volatile PLLCTLSTR _PLLCTL @(REG_BASE + 0x0000003AUL);
#define PLLCTL                          _PLLCTL.Byte
#define PLLCTL_SCME                     _PLLCTL.Bits.SCME
#define PLLCTL_PCE                      _PLLCTL.Bits.PCE
#define PLLCTL_PRE                      _PLLCTL.Bits.PRE
#define PLLCTL_FSTWKP                   _PLLCTL.Bits.FSTWKP
#define PLLCTL_FM0                      _PLLCTL.Bits.FM0
#define PLLCTL_FM1                      _PLLCTL.Bits.FM1
#define PLLCTL_PLLON                    _PLLCTL.Bits.PLLON
#define PLLCTL_CME                      _PLLCTL.Bits.CME
#define PLLCTL_FM                       _PLLCTL.MergedBits.grpFM

#define PLLCTL_SCME_MASK                1U
#define PLLCTL_PCE_MASK                 2U
#define PLLCTL_PRE_MASK                 4U
#define PLLCTL_FSTWKP_MASK              8U
#define PLLCTL_FM0_MASK                 16U
#define PLLCTL_FM1_MASK                 32U
#define PLLCTL_PLLON_MASK               64U
#define PLLCTL_CME_MASK                 128U
#define PLLCTL_FM_MASK                  48U
#define PLLCTL_FM_BITNUM                4U


/*** RTICTL - ECRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte RTDEC       :1;                                       /* Decimal or Binary Divider Select Bit */
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003BUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTDEC                    _RTICTL.Bits.RTDEC
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTR2_MASK                4U
#define RTICTL_RTR3_MASK                8U
#define RTICTL_RTR4_MASK                16U
#define RTICTL_RTR5_MASK                32U
#define RTICTL_RTR6_MASK                64U
#define RTICTL_RTDEC_MASK               128U
#define RTICTL_RTR_MASK                 127U
#define RTICTL_RTR_BITNUM               0U


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte WRTMASK     :1;                                       /* Write Mask for WCOP */
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003CUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_WRTMASK                  _COPCTL.Bits.WRTMASK
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_WRTMASK_MASK             32U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1U
#define ARMCOP_BIT1_MASK                2U
#define ARMCOP_BIT2_MASK                4U
#define ARMCOP_BIT3_MASK                8U
#define ARMCOP_BIT4_MASK                16U
#define ARMCOP_BIT5_MASK                32U
#define ARMCOP_BIT6_MASK                64U
#define ARMCOP_BIT7_MASK                128U


/*** ECT_TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} ECT_TIOSSTR;
extern volatile ECT_TIOSSTR _ECT_TIOS @(REG_BASE + 0x00000040UL);
#define ECT_TIOS                        _ECT_TIOS.Byte
#define ECT_TIOS_IOS0                   _ECT_TIOS.Bits.IOS0
#define ECT_TIOS_IOS1                   _ECT_TIOS.Bits.IOS1
#define ECT_TIOS_IOS2                   _ECT_TIOS.Bits.IOS2
#define ECT_TIOS_IOS3                   _ECT_TIOS.Bits.IOS3
#define ECT_TIOS_IOS4                   _ECT_TIOS.Bits.IOS4
#define ECT_TIOS_IOS5                   _ECT_TIOS.Bits.IOS5
#define ECT_TIOS_IOS6                   _ECT_TIOS.Bits.IOS6
#define ECT_TIOS_IOS7                   _ECT_TIOS.Bits.IOS7

#define ECT_TIOS_IOS0_MASK              1U
#define ECT_TIOS_IOS1_MASK              2U
#define ECT_TIOS_IOS2_MASK              4U
#define ECT_TIOS_IOS3_MASK              8U
#define ECT_TIOS_IOS4_MASK              16U
#define ECT_TIOS_IOS5_MASK              32U
#define ECT_TIOS_IOS6_MASK              64U
#define ECT_TIOS_IOS7_MASK              128U


/*** ECT_CFORC - Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} ECT_CFORCSTR;
extern volatile ECT_CFORCSTR _ECT_CFORC @(REG_BASE + 0x00000041UL);
#define ECT_CFORC                       _ECT_CFORC.Byte
#define ECT_CFORC_FOC0                  _ECT_CFORC.Bits.FOC0
#define ECT_CFORC_FOC1                  _ECT_CFORC.Bits.FOC1
#define ECT_CFORC_FOC2                  _ECT_CFORC.Bits.FOC2
#define ECT_CFORC_FOC3                  _ECT_CFORC.Bits.FOC3
#define ECT_CFORC_FOC4                  _ECT_CFORC.Bits.FOC4
#define ECT_CFORC_FOC5                  _ECT_CFORC.Bits.FOC5
#define ECT_CFORC_FOC6                  _ECT_CFORC.Bits.FOC6
#define ECT_CFORC_FOC7                  _ECT_CFORC.Bits.FOC7

#define ECT_CFORC_FOC0_MASK             1U
#define ECT_CFORC_FOC1_MASK             2U
#define ECT_CFORC_FOC2_MASK             4U
#define ECT_CFORC_FOC3_MASK             8U
#define ECT_CFORC_FOC4_MASK             16U
#define ECT_CFORC_FOC5_MASK             32U
#define ECT_CFORC_FOC6_MASK             64U
#define ECT_CFORC_FOC7_MASK             128U


/*** ECT_OC7M - Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} ECT_OC7MSTR;
extern volatile ECT_OC7MSTR _ECT_OC7M @(REG_BASE + 0x00000042UL);
#define ECT_OC7M                        _ECT_OC7M.Byte
#define ECT_OC7M_OC7M0                  _ECT_OC7M.Bits.OC7M0
#define ECT_OC7M_OC7M1                  _ECT_OC7M.Bits.OC7M1
#define ECT_OC7M_OC7M2                  _ECT_OC7M.Bits.OC7M2
#define ECT_OC7M_OC7M3                  _ECT_OC7M.Bits.OC7M3
#define ECT_OC7M_OC7M4                  _ECT_OC7M.Bits.OC7M4
#define ECT_OC7M_OC7M5                  _ECT_OC7M.Bits.OC7M5
#define ECT_OC7M_OC7M6                  _ECT_OC7M.Bits.OC7M6
#define ECT_OC7M_OC7M7                  _ECT_OC7M.Bits.OC7M7

#define ECT_OC7M_OC7M0_MASK             1U
#define ECT_OC7M_OC7M1_MASK             2U
#define ECT_OC7M_OC7M2_MASK             4U
#define ECT_OC7M_OC7M3_MASK             8U
#define ECT_OC7M_OC7M4_MASK             16U
#define ECT_OC7M_OC7M5_MASK             32U
#define ECT_OC7M_OC7M6_MASK             64U
#define ECT_OC7M_OC7M7_MASK             128U


/*** ECT_OC7D - Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
} ECT_OC7DSTR;
extern volatile ECT_OC7DSTR _ECT_OC7D @(REG_BASE + 0x00000043UL);
#define ECT_OC7D                        _ECT_OC7D.Byte


/*** ECT_TCNT - Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TCNTHi - Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } ECT_TCNTHiSTR;
    #define ECT_TCNTHi                  _ECT_TCNT.Overlap_STR.ECT_TCNTHiSTR.Byte
    

    /*** ECT_TCNTLo - Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } ECT_TCNTLoSTR;
    #define ECT_TCNTLo                  _ECT_TCNT.Overlap_STR.ECT_TCNTLoSTR.Byte
    
  } Overlap_STR;

} ECT_TCNTSTR;
extern volatile ECT_TCNTSTR _ECT_TCNT @(REG_BASE + 0x00000044UL);
#define ECT_TCNT                        _ECT_TCNT.Word


/*** ECT_TSCR1 - Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PRNT        :1;                                       /* Precision Timer */
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} ECT_TSCR1STR;
extern volatile ECT_TSCR1STR _ECT_TSCR1 @(REG_BASE + 0x00000046UL);
#define ECT_TSCR1                       _ECT_TSCR1.Byte
#define ECT_TSCR1_PRNT                  _ECT_TSCR1.Bits.PRNT
#define ECT_TSCR1_TFFCA                 _ECT_TSCR1.Bits.TFFCA
#define ECT_TSCR1_TSFRZ                 _ECT_TSCR1.Bits.TSFRZ
#define ECT_TSCR1_TSWAI                 _ECT_TSCR1.Bits.TSWAI
#define ECT_TSCR1_TEN                   _ECT_TSCR1.Bits.TEN

#define ECT_TSCR1_PRNT_MASK             8U
#define ECT_TSCR1_TFFCA_MASK            16U
#define ECT_TSCR1_TSFRZ_MASK            32U
#define ECT_TSCR1_TSWAI_MASK            64U
#define ECT_TSCR1_TEN_MASK              128U


/*** ECT_TTOV - Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} ECT_TTOVSTR;
extern volatile ECT_TTOVSTR _ECT_TTOV @(REG_BASE + 0x00000047UL);
#define ECT_TTOV                        _ECT_TTOV.Byte
#define ECT_TTOV_TOV0                   _ECT_TTOV.Bits.TOV0
#define ECT_TTOV_TOV1                   _ECT_TTOV.Bits.TOV1
#define ECT_TTOV_TOV2                   _ECT_TTOV.Bits.TOV2
#define ECT_TTOV_TOV3                   _ECT_TTOV.Bits.TOV3
#define ECT_TTOV_TOV4                   _ECT_TTOV.Bits.TOV4
#define ECT_TTOV_TOV5                   _ECT_TTOV.Bits.TOV5
#define ECT_TTOV_TOV6                   _ECT_TTOV.Bits.TOV6
#define ECT_TTOV_TOV7                   _ECT_TTOV.Bits.TOV7

#define ECT_TTOV_TOV0_MASK              1U
#define ECT_TTOV_TOV1_MASK              2U
#define ECT_TTOV_TOV2_MASK              4U
#define ECT_TTOV_TOV3_MASK              8U
#define ECT_TTOV_TOV4_MASK              16U
#define ECT_TTOV_TOV5_MASK              32U
#define ECT_TTOV_TOV6_MASK              64U
#define ECT_TTOV_TOV7_MASK              128U


/*** ECT_TCTL1 - Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} ECT_TCTL1STR;
extern volatile ECT_TCTL1STR _ECT_TCTL1 @(REG_BASE + 0x00000048UL);
#define ECT_TCTL1                       _ECT_TCTL1.Byte
#define ECT_TCTL1_OL4                   _ECT_TCTL1.Bits.OL4
#define ECT_TCTL1_OM4                   _ECT_TCTL1.Bits.OM4
#define ECT_TCTL1_OL5                   _ECT_TCTL1.Bits.OL5
#define ECT_TCTL1_OM5                   _ECT_TCTL1.Bits.OM5
#define ECT_TCTL1_OL6                   _ECT_TCTL1.Bits.OL6
#define ECT_TCTL1_OM6                   _ECT_TCTL1.Bits.OM6
#define ECT_TCTL1_OL7                   _ECT_TCTL1.Bits.OL7
#define ECT_TCTL1_OM7                   _ECT_TCTL1.Bits.OM7

#define ECT_TCTL1_OL4_MASK              1U
#define ECT_TCTL1_OM4_MASK              2U
#define ECT_TCTL1_OL5_MASK              4U
#define ECT_TCTL1_OM5_MASK              8U
#define ECT_TCTL1_OL6_MASK              16U
#define ECT_TCTL1_OM6_MASK              32U
#define ECT_TCTL1_OL7_MASK              64U
#define ECT_TCTL1_OM7_MASK              128U


/*** ECT_TCTL2 - Timer Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Lecel Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} ECT_TCTL2STR;
extern volatile ECT_TCTL2STR _ECT_TCTL2 @(REG_BASE + 0x00000049UL);
#define ECT_TCTL2                       _ECT_TCTL2.Byte
#define ECT_TCTL2_OL0                   _ECT_TCTL2.Bits.OL0
#define ECT_TCTL2_OM0                   _ECT_TCTL2.Bits.OM0
#define ECT_TCTL2_OL1                   _ECT_TCTL2.Bits.OL1
#define ECT_TCTL2_OM1                   _ECT_TCTL2.Bits.OM1
#define ECT_TCTL2_OL2                   _ECT_TCTL2.Bits.OL2
#define ECT_TCTL2_OM2                   _ECT_TCTL2.Bits.OM2
#define ECT_TCTL2_OL3                   _ECT_TCTL2.Bits.OL3
#define ECT_TCTL2_OM3                   _ECT_TCTL2.Bits.OM3

#define ECT_TCTL2_OL0_MASK              1U
#define ECT_TCTL2_OM0_MASK              2U
#define ECT_TCTL2_OL1_MASK              4U
#define ECT_TCTL2_OM1_MASK              8U
#define ECT_TCTL2_OL2_MASK              16U
#define ECT_TCTL2_OM2_MASK              32U
#define ECT_TCTL2_OL3_MASK              64U
#define ECT_TCTL2_OM3_MASK              128U


/*** ECT_TCTL3 - Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} ECT_TCTL3STR;
extern volatile ECT_TCTL3STR _ECT_TCTL3 @(REG_BASE + 0x0000004AUL);
#define ECT_TCTL3                       _ECT_TCTL3.Byte
#define ECT_TCTL3_EDG4A                 _ECT_TCTL3.Bits.EDG4A
#define ECT_TCTL3_EDG4B                 _ECT_TCTL3.Bits.EDG4B
#define ECT_TCTL3_EDG5A                 _ECT_TCTL3.Bits.EDG5A
#define ECT_TCTL3_EDG5B                 _ECT_TCTL3.Bits.EDG5B
#define ECT_TCTL3_EDG6A                 _ECT_TCTL3.Bits.EDG6A
#define ECT_TCTL3_EDG6B                 _ECT_TCTL3.Bits.EDG6B
#define ECT_TCTL3_EDG7A                 _ECT_TCTL3.Bits.EDG7A
#define ECT_TCTL3_EDG7B                 _ECT_TCTL3.Bits.EDG7B
#define ECT_TCTL3_EDG4x                 _ECT_TCTL3.MergedBits.grpEDG4x
#define ECT_TCTL3_EDG5x                 _ECT_TCTL3.MergedBits.grpEDG5x
#define ECT_TCTL3_EDG6x                 _ECT_TCTL3.MergedBits.grpEDG6x
#define ECT_TCTL3_EDG7x                 _ECT_TCTL3.MergedBits.grpEDG7x

#define ECT_TCTL3_EDG4A_MASK            1U
#define ECT_TCTL3_EDG4B_MASK            2U
#define ECT_TCTL3_EDG5A_MASK            4U
#define ECT_TCTL3_EDG5B_MASK            8U
#define ECT_TCTL3_EDG6A_MASK            16U
#define ECT_TCTL3_EDG6B_MASK            32U
#define ECT_TCTL3_EDG7A_MASK            64U
#define ECT_TCTL3_EDG7B_MASK            128U
#define ECT_TCTL3_EDG4x_MASK            3U
#define ECT_TCTL3_EDG4x_BITNUM          0U
#define ECT_TCTL3_EDG5x_MASK            12U
#define ECT_TCTL3_EDG5x_BITNUM          2U
#define ECT_TCTL3_EDG6x_MASK            48U
#define ECT_TCTL3_EDG6x_BITNUM          4U
#define ECT_TCTL3_EDG7x_MASK            192U
#define ECT_TCTL3_EDG7x_BITNUM          6U


/*** ECT_TCTL4 - Timer Control Register 4; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} ECT_TCTL4STR;
extern volatile ECT_TCTL4STR _ECT_TCTL4 @(REG_BASE + 0x0000004BUL);
#define ECT_TCTL4                       _ECT_TCTL4.Byte
#define ECT_TCTL4_EDG0A                 _ECT_TCTL4.Bits.EDG0A
#define ECT_TCTL4_EDG0B                 _ECT_TCTL4.Bits.EDG0B
#define ECT_TCTL4_EDG1A                 _ECT_TCTL4.Bits.EDG1A
#define ECT_TCTL4_EDG1B                 _ECT_TCTL4.Bits.EDG1B
#define ECT_TCTL4_EDG2A                 _ECT_TCTL4.Bits.EDG2A
#define ECT_TCTL4_EDG2B                 _ECT_TCTL4.Bits.EDG2B
#define ECT_TCTL4_EDG3A                 _ECT_TCTL4.Bits.EDG3A
#define ECT_TCTL4_EDG3B                 _ECT_TCTL4.Bits.EDG3B
#define ECT_TCTL4_EDG0x                 _ECT_TCTL4.MergedBits.grpEDG0x
#define ECT_TCTL4_EDG1x                 _ECT_TCTL4.MergedBits.grpEDG1x
#define ECT_TCTL4_EDG2x                 _ECT_TCTL4.MergedBits.grpEDG2x
#define ECT_TCTL4_EDG3x                 _ECT_TCTL4.MergedBits.grpEDG3x

#define ECT_TCTL4_EDG0A_MASK            1U
#define ECT_TCTL4_EDG0B_MASK            2U
#define ECT_TCTL4_EDG1A_MASK            4U
#define ECT_TCTL4_EDG1B_MASK            8U
#define ECT_TCTL4_EDG2A_MASK            16U
#define ECT_TCTL4_EDG2B_MASK            32U
#define ECT_TCTL4_EDG3A_MASK            64U
#define ECT_TCTL4_EDG3B_MASK            128U
#define ECT_TCTL4_EDG0x_MASK            3U
#define ECT_TCTL4_EDG0x_BITNUM          0U
#define ECT_TCTL4_EDG1x_MASK            12U
#define ECT_TCTL4_EDG1x_BITNUM          2U
#define ECT_TCTL4_EDG2x_MASK            48U
#define ECT_TCTL4_EDG2x_BITNUM          4U
#define ECT_TCTL4_EDG3x_MASK            192U
#define ECT_TCTL4_EDG3x_BITNUM          6U


/*** ECT_TIE - Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} ECT_TIESTR;
extern volatile ECT_TIESTR _ECT_TIE @(REG_BASE + 0x0000004CUL);
#define ECT_TIE                         _ECT_TIE.Byte
#define ECT_TIE_C0I                     _ECT_TIE.Bits.C0I
#define ECT_TIE_C1I                     _ECT_TIE.Bits.C1I
#define ECT_TIE_C2I                     _ECT_TIE.Bits.C2I
#define ECT_TIE_C3I                     _ECT_TIE.Bits.C3I
#define ECT_TIE_C4I                     _ECT_TIE.Bits.C4I
#define ECT_TIE_C5I                     _ECT_TIE.Bits.C5I
#define ECT_TIE_C6I                     _ECT_TIE.Bits.C6I
#define ECT_TIE_C7I                     _ECT_TIE.Bits.C7I

#define ECT_TIE_C0I_MASK                1U
#define ECT_TIE_C1I_MASK                2U
#define ECT_TIE_C2I_MASK                4U
#define ECT_TIE_C3I_MASK                8U
#define ECT_TIE_C4I_MASK                16U
#define ECT_TIE_C5I_MASK                32U
#define ECT_TIE_C6I_MASK                64U
#define ECT_TIE_C7I_MASK                128U


/*** ECT_TSCR2 - Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ECT_TSCR2STR;
extern volatile ECT_TSCR2STR _ECT_TSCR2 @(REG_BASE + 0x0000004DUL);
#define ECT_TSCR2                       _ECT_TSCR2.Byte
#define ECT_TSCR2_PR0                   _ECT_TSCR2.Bits.PR0
#define ECT_TSCR2_PR1                   _ECT_TSCR2.Bits.PR1
#define ECT_TSCR2_PR2                   _ECT_TSCR2.Bits.PR2
#define ECT_TSCR2_TCRE                  _ECT_TSCR2.Bits.TCRE
#define ECT_TSCR2_TOI                   _ECT_TSCR2.Bits.TOI
#define ECT_TSCR2_PR                    _ECT_TSCR2.MergedBits.grpPR

#define ECT_TSCR2_PR0_MASK              1U
#define ECT_TSCR2_PR1_MASK              2U
#define ECT_TSCR2_PR2_MASK              4U
#define ECT_TSCR2_TCRE_MASK             8U
#define ECT_TSCR2_TOI_MASK              128U
#define ECT_TSCR2_PR_MASK               7U
#define ECT_TSCR2_PR_BITNUM             0U


/*** ECT_TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} ECT_TFLG1STR;
extern volatile ECT_TFLG1STR _ECT_TFLG1 @(REG_BASE + 0x0000004EUL);
#define ECT_TFLG1                       _ECT_TFLG1.Byte
#define ECT_TFLG1_C0F                   _ECT_TFLG1.Bits.C0F
#define ECT_TFLG1_C1F                   _ECT_TFLG1.Bits.C1F
#define ECT_TFLG1_C2F                   _ECT_TFLG1.Bits.C2F
#define ECT_TFLG1_C3F                   _ECT_TFLG1.Bits.C3F
#define ECT_TFLG1_C4F                   _ECT_TFLG1.Bits.C4F
#define ECT_TFLG1_C5F                   _ECT_TFLG1.Bits.C5F
#define ECT_TFLG1_C6F                   _ECT_TFLG1.Bits.C6F
#define ECT_TFLG1_C7F                   _ECT_TFLG1.Bits.C7F

#define ECT_TFLG1_C0F_MASK              1U
#define ECT_TFLG1_C1F_MASK              2U
#define ECT_TFLG1_C2F_MASK              4U
#define ECT_TFLG1_C3F_MASK              8U
#define ECT_TFLG1_C4F_MASK              16U
#define ECT_TFLG1_C5F_MASK              32U
#define ECT_TFLG1_C6F_MASK              64U
#define ECT_TFLG1_C7F_MASK              128U


/*** ECT_TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} ECT_TFLG2STR;
extern volatile ECT_TFLG2STR _ECT_TFLG2 @(REG_BASE + 0x0000004FUL);
#define ECT_TFLG2                       _ECT_TFLG2.Byte
#define ECT_TFLG2_TOF                   _ECT_TFLG2.Bits.TOF

#define ECT_TFLG2_TOF_MASK              128U


/*** ECT_TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***/
    union {
      byte Byte;
    } ECT_TC0HiSTR;
    #define ECT_TC0Hi                   _ECT_TC0.Overlap_STR.ECT_TC0HiSTR.Byte
    

    /*** ECT_TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***/
    union {
      byte Byte;
    } ECT_TC0LoSTR;
    #define ECT_TC0Lo                   _ECT_TC0.Overlap_STR.ECT_TC0LoSTR.Byte
    
  } Overlap_STR;

} ECT_TC0STR;
extern volatile ECT_TC0STR _ECT_TC0 @(REG_BASE + 0x00000050UL);
#define ECT_TC0                         _ECT_TC0.Word
/* ECT_TC_ARR: Access 8 ECT_TCx registers in an array */
#define ECT_TC_ARR                      ((volatile word *) &ECT_TC0)


/*** ECT_TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***/
    union {
      byte Byte;
    } ECT_TC1HiSTR;
    #define ECT_TC1Hi                   _ECT_TC1.Overlap_STR.ECT_TC1HiSTR.Byte
    

    /*** ECT_TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***/
    union {
      byte Byte;
    } ECT_TC1LoSTR;
    #define ECT_TC1Lo                   _ECT_TC1.Overlap_STR.ECT_TC1LoSTR.Byte
    
  } Overlap_STR;

} ECT_TC1STR;
extern volatile ECT_TC1STR _ECT_TC1 @(REG_BASE + 0x00000052UL);
#define ECT_TC1                         _ECT_TC1.Word


/*** ECT_TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***/
    union {
      byte Byte;
    } ECT_TC2HiSTR;
    #define ECT_TC2Hi                   _ECT_TC2.Overlap_STR.ECT_TC2HiSTR.Byte
    

    /*** ECT_TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***/
    union {
      byte Byte;
    } ECT_TC2LoSTR;
    #define ECT_TC2Lo                   _ECT_TC2.Overlap_STR.ECT_TC2LoSTR.Byte
    
  } Overlap_STR;

} ECT_TC2STR;
extern volatile ECT_TC2STR _ECT_TC2 @(REG_BASE + 0x00000054UL);
#define ECT_TC2                         _ECT_TC2.Word


/*** ECT_TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***/
    union {
      byte Byte;
    } ECT_TC3HiSTR;
    #define ECT_TC3Hi                   _ECT_TC3.Overlap_STR.ECT_TC3HiSTR.Byte
    

    /*** ECT_TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***/
    union {
      byte Byte;
    } ECT_TC3LoSTR;
    #define ECT_TC3Lo                   _ECT_TC3.Overlap_STR.ECT_TC3LoSTR.Byte
    
  } Overlap_STR;

} ECT_TC3STR;
extern volatile ECT_TC3STR _ECT_TC3 @(REG_BASE + 0x00000056UL);
#define ECT_TC3                         _ECT_TC3.Word


/*** ECT_TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } ECT_TC4HiSTR;
    #define ECT_TC4Hi                   _ECT_TC4.Overlap_STR.ECT_TC4HiSTR.Byte
    

    /*** ECT_TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } ECT_TC4LoSTR;
    #define ECT_TC4Lo                   _ECT_TC4.Overlap_STR.ECT_TC4LoSTR.Byte
    
  } Overlap_STR;

} ECT_TC4STR;
extern volatile ECT_TC4STR _ECT_TC4 @(REG_BASE + 0x00000058UL);
#define ECT_TC4                         _ECT_TC4.Word


/*** ECT_TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } ECT_TC5HiSTR;
    #define ECT_TC5Hi                   _ECT_TC5.Overlap_STR.ECT_TC5HiSTR.Byte
    

    /*** ECT_TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } ECT_TC5LoSTR;
    #define ECT_TC5Lo                   _ECT_TC5.Overlap_STR.ECT_TC5LoSTR.Byte
    
  } Overlap_STR;

} ECT_TC5STR;
extern volatile ECT_TC5STR _ECT_TC5 @(REG_BASE + 0x0000005AUL);
#define ECT_TC5                         _ECT_TC5.Word


/*** ECT_TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } ECT_TC6HiSTR;
    #define ECT_TC6Hi                   _ECT_TC6.Overlap_STR.ECT_TC6HiSTR.Byte
    

    /*** ECT_TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } ECT_TC6LoSTR;
    #define ECT_TC6Lo                   _ECT_TC6.Overlap_STR.ECT_TC6LoSTR.Byte
    
  } Overlap_STR;

} ECT_TC6STR;
extern volatile ECT_TC6STR _ECT_TC6 @(REG_BASE + 0x0000005CUL);
#define ECT_TC6                         _ECT_TC6.Word


/*** ECT_TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } ECT_TC7HiSTR;
    #define ECT_TC7Hi                   _ECT_TC7.Overlap_STR.ECT_TC7HiSTR.Byte
    

    /*** ECT_TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } ECT_TC7LoSTR;
    #define ECT_TC7Lo                   _ECT_TC7.Overlap_STR.ECT_TC7LoSTR.Byte
    
  } Overlap_STR;

} ECT_TC7STR;
extern volatile ECT_TC7STR _ECT_TC7 @(REG_BASE + 0x0000005EUL);
#define ECT_TC7                         _ECT_TC7.Word


/*** ECT_PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ECT_PACTLSTR;
extern volatile ECT_PACTLSTR _ECT_PACTL @(REG_BASE + 0x00000060UL);
#define ECT_PACTL                       _ECT_PACTL.Byte
#define ECT_PACTL_PAI                   _ECT_PACTL.Bits.PAI
#define ECT_PACTL_PAOVI                 _ECT_PACTL.Bits.PAOVI
#define ECT_PACTL_CLK0                  _ECT_PACTL.Bits.CLK0
#define ECT_PACTL_CLK1                  _ECT_PACTL.Bits.CLK1
#define ECT_PACTL_PEDGE                 _ECT_PACTL.Bits.PEDGE
#define ECT_PACTL_PAMOD                 _ECT_PACTL.Bits.PAMOD
#define ECT_PACTL_PAEN                  _ECT_PACTL.Bits.PAEN
#define ECT_PACTL_CLK                   _ECT_PACTL.MergedBits.grpCLK

#define ECT_PACTL_PAI_MASK              1U
#define ECT_PACTL_PAOVI_MASK            2U
#define ECT_PACTL_CLK0_MASK             4U
#define ECT_PACTL_CLK1_MASK             8U
#define ECT_PACTL_PEDGE_MASK            16U
#define ECT_PACTL_PAMOD_MASK            32U
#define ECT_PACTL_PAEN_MASK             64U
#define ECT_PACTL_CLK_MASK              12U
#define ECT_PACTL_CLK_BITNUM            2U


/*** ECT_PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ECT_PAFLGSTR;
extern volatile ECT_PAFLGSTR _ECT_PAFLG @(REG_BASE + 0x00000061UL);
#define ECT_PAFLG                       _ECT_PAFLG.Byte
#define ECT_PAFLG_PAIF                  _ECT_PAFLG.Bits.PAIF
#define ECT_PAFLG_PAOVF                 _ECT_PAFLG.Bits.PAOVF

#define ECT_PAFLG_PAIF_MASK             1U
#define ECT_PAFLG_PAOVF_MASK            2U


/*** ECT_PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***/
    union {
      byte Byte;
    } ECT_PACN3STR;
    #define ECT_PACN3                   _ECT_PACN32.Overlap_STR.ECT_PACN3STR.Byte
    

    /*** ECT_PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***/
    union {
      byte Byte;
    } ECT_PACN2STR;
    #define ECT_PACN2                   _ECT_PACN32.Overlap_STR.ECT_PACN2STR.Byte
    
  } Overlap_STR;

} ECT_PACN32STR;
extern volatile ECT_PACN32STR _ECT_PACN32 @(REG_BASE + 0x00000062UL);
#define ECT_PACN32                      _ECT_PACN32.Word


/*** ECT_PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***/
    union {
      byte Byte;
    } ECT_PACN1STR;
    #define ECT_PACN1                   _ECT_PACN10.Overlap_STR.ECT_PACN1STR.Byte
    

    /*** ECT_PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***/
    union {
      byte Byte;
    } ECT_PACN0STR;
    #define ECT_PACN0                   _ECT_PACN10.Overlap_STR.ECT_PACN0STR.Byte
    
  } Overlap_STR;

} ECT_PACN10STR;
extern volatile ECT_PACN10STR _ECT_PACN10 @(REG_BASE + 0x00000064UL);
#define ECT_PACN10                      _ECT_PACN10.Word


/*** ECT_MCCTL - Modulus Down Counter underflow; 0x00000066 ***/
typedef union {
  byte Byte;
  struct {
    byte MCPR0       :1;                                       /* Modulus Counter Prescaler select 0 */
    byte MCPR1       :1;                                       /* Modulus Counter Prescaler select 1 */
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte ICLAT       :1;                                       /* Input Capture Force Latch Action */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZI        :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
  struct {
    byte grpMCPR :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ECT_MCCTLSTR;
extern volatile ECT_MCCTLSTR _ECT_MCCTL @(REG_BASE + 0x00000066UL);
#define ECT_MCCTL                       _ECT_MCCTL.Byte
#define ECT_MCCTL_MCPR0                 _ECT_MCCTL.Bits.MCPR0
#define ECT_MCCTL_MCPR1                 _ECT_MCCTL.Bits.MCPR1
#define ECT_MCCTL_MCEN                  _ECT_MCCTL.Bits.MCEN
#define ECT_MCCTL_FLMC                  _ECT_MCCTL.Bits.FLMC
#define ECT_MCCTL_ICLAT                 _ECT_MCCTL.Bits.ICLAT
#define ECT_MCCTL_RDMCL                 _ECT_MCCTL.Bits.RDMCL
#define ECT_MCCTL_MODMC                 _ECT_MCCTL.Bits.MODMC
#define ECT_MCCTL_MCZI                  _ECT_MCCTL.Bits.MCZI
#define ECT_MCCTL_MCPR                  _ECT_MCCTL.MergedBits.grpMCPR

#define ECT_MCCTL_MCPR0_MASK            1U
#define ECT_MCCTL_MCPR1_MASK            2U
#define ECT_MCCTL_MCEN_MASK             4U
#define ECT_MCCTL_FLMC_MASK             8U
#define ECT_MCCTL_ICLAT_MASK            16U
#define ECT_MCCTL_RDMCL_MASK            32U
#define ECT_MCCTL_MODMC_MASK            64U
#define ECT_MCCTL_MCZI_MASK             128U
#define ECT_MCCTL_MCPR_MASK             3U
#define ECT_MCCTL_MCPR_BITNUM           0U


/*** ECT_MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***/
typedef union {
  byte Byte;
  struct {
    byte POLF0       :1;                                       /* First Input Capture Polarity Status 0 */
    byte POLF1       :1;                                       /* First Input Capture Polarity Status 1 */
    byte POLF2       :1;                                       /* First Input Capture Polarity Status 2 */
    byte POLF3       :1;                                       /* First Input Capture Polarity Status 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZF        :1;                                       /* Modulus Counter Underflow Flag */
  } Bits;
  struct {
    byte grpPOLF :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ECT_MCFLGSTR;
extern volatile ECT_MCFLGSTR _ECT_MCFLG @(REG_BASE + 0x00000067UL);
#define ECT_MCFLG                       _ECT_MCFLG.Byte
#define ECT_MCFLG_POLF0                 _ECT_MCFLG.Bits.POLF0
#define ECT_MCFLG_POLF1                 _ECT_MCFLG.Bits.POLF1
#define ECT_MCFLG_POLF2                 _ECT_MCFLG.Bits.POLF2
#define ECT_MCFLG_POLF3                 _ECT_MCFLG.Bits.POLF3
#define ECT_MCFLG_MCZF                  _ECT_MCFLG.Bits.MCZF
#define ECT_MCFLG_POLF                  _ECT_MCFLG.MergedBits.grpPOLF

#define ECT_MCFLG_POLF0_MASK            1U
#define ECT_MCFLG_POLF1_MASK            2U
#define ECT_MCFLG_POLF2_MASK            4U
#define ECT_MCFLG_POLF3_MASK            8U
#define ECT_MCFLG_MCZF_MASK             128U
#define ECT_MCFLG_POLF_MASK             15U
#define ECT_MCFLG_POLF_BITNUM           0U


/*** ECT_ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***/
typedef union {
  byte Byte;
  struct {
    byte PA0EN       :1;                                       /* 8-Bit Pulse Accumulator 0 Enable */
    byte PA1EN       :1;                                       /* 8-Bit Pulse Accumulator 1 Enable */
    byte PA2EN       :1;                                       /* 8-Bit Pulse Accumulator 2 Enable */
    byte PA3EN       :1;                                       /* 8-Bit Pulse Accumulator 3 Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ECT_ICPARSTR;
extern volatile ECT_ICPARSTR _ECT_ICPAR @(REG_BASE + 0x00000068UL);
#define ECT_ICPAR                       _ECT_ICPAR.Byte
#define ECT_ICPAR_PA0EN                 _ECT_ICPAR.Bits.PA0EN
#define ECT_ICPAR_PA1EN                 _ECT_ICPAR.Bits.PA1EN
#define ECT_ICPAR_PA2EN                 _ECT_ICPAR.Bits.PA2EN
#define ECT_ICPAR_PA3EN                 _ECT_ICPAR.Bits.PA3EN

#define ECT_ICPAR_PA0EN_MASK            1U
#define ECT_ICPAR_PA1EN_MASK            2U
#define ECT_ICPAR_PA2EN_MASK            4U
#define ECT_ICPAR_PA3EN_MASK            8U


/*** ECT_DLYCT - Delay Counter Control Register; 0x00000069 ***/
typedef union {
  byte Byte;
  struct {
    byte DLY0        :1;                                       /* Delay Counter Select 0 */
    byte DLY1        :1;                                       /* Delay Counter Select 1 */
    byte DLY2        :1;                                       /* Delay Counter Select 2 */
    byte DLY3        :1;                                       /* Delay Counter Select 3 */
    byte DLY4        :1;                                       /* Delay Counter Select 4 */
    byte DLY5        :1;                                       /* Delay Counter Select 5 */
    byte DLY6        :1;                                       /* Delay Counter Select 6 */
    byte DLY7        :1;                                       /* Delay Counter Select 7 */
  } Bits;
} ECT_DLYCTSTR;
extern volatile ECT_DLYCTSTR _ECT_DLYCT @(REG_BASE + 0x00000069UL);
#define ECT_DLYCT                       _ECT_DLYCT.Byte
#define ECT_DLYCT_DLY0                  _ECT_DLYCT.Bits.DLY0
#define ECT_DLYCT_DLY1                  _ECT_DLYCT.Bits.DLY1
#define ECT_DLYCT_DLY2                  _ECT_DLYCT.Bits.DLY2
#define ECT_DLYCT_DLY3                  _ECT_DLYCT.Bits.DLY3
#define ECT_DLYCT_DLY4                  _ECT_DLYCT.Bits.DLY4
#define ECT_DLYCT_DLY5                  _ECT_DLYCT.Bits.DLY5
#define ECT_DLYCT_DLY6                  _ECT_DLYCT.Bits.DLY6
#define ECT_DLYCT_DLY7                  _ECT_DLYCT.Bits.DLY7

#define ECT_DLYCT_DLY0_MASK             1U
#define ECT_DLYCT_DLY1_MASK             2U
#define ECT_DLYCT_DLY2_MASK             4U
#define ECT_DLYCT_DLY3_MASK             8U
#define ECT_DLYCT_DLY4_MASK             16U
#define ECT_DLYCT_DLY5_MASK             32U
#define ECT_DLYCT_DLY6_MASK             64U
#define ECT_DLYCT_DLY7_MASK             128U


/*** ECT_ICOVW - Input Control Overwrite Register; 0x0000006A ***/
typedef union {
  byte Byte;
  struct {
    byte NOVW0       :1;                                       /* No Input Capture Overwrite 0 */
    byte NOVW1       :1;                                       /* No Input Capture Overwrite 1 */
    byte NOVW2       :1;                                       /* No Input Capture Overwrite 2 */
    byte NOVW3       :1;                                       /* No Input Capture Overwrite 3 */
    byte NOVW4       :1;                                       /* No Input Capture Overwrite 4 */
    byte NOVW5       :1;                                       /* No Input Capture Overwrite 5 */
    byte NOVW6       :1;                                       /* No Input Capture Overwrite 6 */
    byte NOVW7       :1;                                       /* No Input Capture Overwrite 7 */
  } Bits;
} ECT_ICOVWSTR;
extern volatile ECT_ICOVWSTR _ECT_ICOVW @(REG_BASE + 0x0000006AUL);
#define ECT_ICOVW                       _ECT_ICOVW.Byte
#define ECT_ICOVW_NOVW0                 _ECT_ICOVW.Bits.NOVW0
#define ECT_ICOVW_NOVW1                 _ECT_ICOVW.Bits.NOVW1
#define ECT_ICOVW_NOVW2                 _ECT_ICOVW.Bits.NOVW2
#define ECT_ICOVW_NOVW3                 _ECT_ICOVW.Bits.NOVW3
#define ECT_ICOVW_NOVW4                 _ECT_ICOVW.Bits.NOVW4
#define ECT_ICOVW_NOVW5                 _ECT_ICOVW.Bits.NOVW5
#define ECT_ICOVW_NOVW6                 _ECT_ICOVW.Bits.NOVW6
#define ECT_ICOVW_NOVW7                 _ECT_ICOVW.Bits.NOVW7

#define ECT_ICOVW_NOVW0_MASK            1U
#define ECT_ICOVW_NOVW1_MASK            2U
#define ECT_ICOVW_NOVW2_MASK            4U
#define ECT_ICOVW_NOVW3_MASK            8U
#define ECT_ICOVW_NOVW4_MASK            16U
#define ECT_ICOVW_NOVW5_MASK            32U
#define ECT_ICOVW_NOVW6_MASK            64U
#define ECT_ICOVW_NOVW7_MASK            128U


/*** ECT_ICSYS - Input Control System Control Register; 0x0000006B ***/
typedef union {
  byte Byte;
  struct {
    byte LATQ        :1;                                       /* Input Control Latch or Queue Mode Enable */
    byte BUFEN       :1;                                       /* IC Buffer Enable */
    byte PACMX       :1;                                       /* 8-Bit Pulse Accumulators Maximum Count */
    byte TFMOD       :1;                                       /* Timer Flag-setting Mode */
    byte SH04        :1;                                       /* Share Input action of Input Capture Channels 0 and 4 */
    byte SH15        :1;                                       /* Share Input action of Input Capture Channels 1 and 5 */
    byte SH26        :1;                                       /* Share Input action of Input Capture Channels 2 and 6 */
    byte SH37        :1;                                       /* Share Input action of Input Capture Channels 3 and 7 */
  } Bits;
} ECT_ICSYSSTR;
extern volatile ECT_ICSYSSTR _ECT_ICSYS @(REG_BASE + 0x0000006BUL);
#define ECT_ICSYS                       _ECT_ICSYS.Byte
#define ECT_ICSYS_LATQ                  _ECT_ICSYS.Bits.LATQ
#define ECT_ICSYS_BUFEN                 _ECT_ICSYS.Bits.BUFEN
#define ECT_ICSYS_PACMX                 _ECT_ICSYS.Bits.PACMX
#define ECT_ICSYS_TFMOD                 _ECT_ICSYS.Bits.TFMOD
#define ECT_ICSYS_SH04                  _ECT_ICSYS.Bits.SH04
#define ECT_ICSYS_SH15                  _ECT_ICSYS.Bits.SH15
#define ECT_ICSYS_SH26                  _ECT_ICSYS.Bits.SH26
#define ECT_ICSYS_SH37                  _ECT_ICSYS.Bits.SH37

#define ECT_ICSYS_LATQ_MASK             1U
#define ECT_ICSYS_BUFEN_MASK            2U
#define ECT_ICSYS_PACMX_MASK            4U
#define ECT_ICSYS_TFMOD_MASK            8U
#define ECT_ICSYS_SH04_MASK             16U
#define ECT_ICSYS_SH15_MASK             32U
#define ECT_ICSYS_SH26_MASK             64U
#define ECT_ICSYS_SH37_MASK             128U


/*** ECT_OCPD - Output Compare Pin Disconnect Register; 0x0000006C ***/
typedef union {
  byte Byte;
  struct {
    byte OCPD0       :1;                                       /* Output Compare Pin Disconnect Bit 0 */
    byte OCPD1       :1;                                       /* Output Compare Pin Disconnect Bit 1 */
    byte OCPD2       :1;                                       /* Output Compare Pin Disconnect Bit 2 */
    byte OCPD3       :1;                                       /* Output Compare Pin Disconnect Bit 3 */
    byte OCPD4       :1;                                       /* Output Compare Pin Disconnect Bit 4 */
    byte OCPD5       :1;                                       /* Output Compare Pin Disconnect Bit 5 */
    byte OCPD6       :1;                                       /* Output Compare Pin Disconnect Bit 6 */
    byte OCPD7       :1;                                       /* Output Compare Pin Disconnect Bit 7 */
  } Bits;
} ECT_OCPDSTR;
extern volatile ECT_OCPDSTR _ECT_OCPD @(REG_BASE + 0x0000006CUL);
#define ECT_OCPD                        _ECT_OCPD.Byte
#define ECT_OCPD_OCPD0                  _ECT_OCPD.Bits.OCPD0
#define ECT_OCPD_OCPD1                  _ECT_OCPD.Bits.OCPD1
#define ECT_OCPD_OCPD2                  _ECT_OCPD.Bits.OCPD2
#define ECT_OCPD_OCPD3                  _ECT_OCPD.Bits.OCPD3
#define ECT_OCPD_OCPD4                  _ECT_OCPD.Bits.OCPD4
#define ECT_OCPD_OCPD5                  _ECT_OCPD.Bits.OCPD5
#define ECT_OCPD_OCPD6                  _ECT_OCPD.Bits.OCPD6
#define ECT_OCPD_OCPD7                  _ECT_OCPD.Bits.OCPD7

#define ECT_OCPD_OCPD0_MASK             1U
#define ECT_OCPD_OCPD1_MASK             2U
#define ECT_OCPD_OCPD2_MASK             4U
#define ECT_OCPD_OCPD3_MASK             8U
#define ECT_OCPD_OCPD4_MASK             16U
#define ECT_OCPD_OCPD5_MASK             32U
#define ECT_OCPD_OCPD6_MASK             64U
#define ECT_OCPD_OCPD7_MASK             128U


/*** ECT_PTPSR - Precision Timer Prescaler Select Register; 0x0000006E ***/
typedef union {
  byte Byte;
  struct {
    byte PTPS0       :1;                                       /* Precision Timer Prescaler Select, bit 0 */
    byte PTPS1       :1;                                       /* Precision Timer Prescaler Select, bit 1 */
    byte PTPS2       :1;                                       /* Precision Timer Prescaler Select, bit 2 */
    byte PTPS3       :1;                                       /* Precision Timer Prescaler Select, bit 3 */
    byte PTPS4       :1;                                       /* Precision Timer Prescaler Select, bit 4 */
    byte PTPS5       :1;                                       /* Precision Timer Prescaler Select, bit 5 */
    byte PTPS6       :1;                                       /* Precision Timer Prescaler Select, bit 6 */
    byte PTPS7       :1;                                       /* Precision Timer Prescaler Select, bit 7 */
  } Bits;
} ECT_PTPSRSTR;
extern volatile ECT_PTPSRSTR _ECT_PTPSR @(REG_BASE + 0x0000006EUL);
#define ECT_PTPSR                       _ECT_PTPSR.Byte
#define ECT_PTPSR_PTPS0                 _ECT_PTPSR.Bits.PTPS0
#define ECT_PTPSR_PTPS1                 _ECT_PTPSR.Bits.PTPS1
#define ECT_PTPSR_PTPS2                 _ECT_PTPSR.Bits.PTPS2
#define ECT_PTPSR_PTPS3                 _ECT_PTPSR.Bits.PTPS3
#define ECT_PTPSR_PTPS4                 _ECT_PTPSR.Bits.PTPS4
#define ECT_PTPSR_PTPS5                 _ECT_PTPSR.Bits.PTPS5
#define ECT_PTPSR_PTPS6                 _ECT_PTPSR.Bits.PTPS6
#define ECT_PTPSR_PTPS7                 _ECT_PTPSR.Bits.PTPS7

#define ECT_PTPSR_PTPS0_MASK            1U
#define ECT_PTPSR_PTPS1_MASK            2U
#define ECT_PTPSR_PTPS2_MASK            4U
#define ECT_PTPSR_PTPS3_MASK            8U
#define ECT_PTPSR_PTPS4_MASK            16U
#define ECT_PTPSR_PTPS5_MASK            32U
#define ECT_PTPSR_PTPS6_MASK            64U
#define ECT_PTPSR_PTPS7_MASK            128U


/*** ECT_PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***/
typedef union {
  byte Byte;
  struct {
    byte PTMPS0      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 0 */
    byte PTMPS1      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 1 */
    byte PTMPS2      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 2 */
    byte PTMPS3      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 3 */
    byte PTMPS4      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 4 */
    byte PTMPS5      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 5 */
    byte PTMPS6      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 6 */
    byte PTMPS7      :1;                                       /* Precision Timer Modulus Counter Prescaler Select, bit 7 */
  } Bits;
} ECT_PTMCPSRSTR;
extern volatile ECT_PTMCPSRSTR _ECT_PTMCPSR @(REG_BASE + 0x0000006FUL);
#define ECT_PTMCPSR                     _ECT_PTMCPSR.Byte
#define ECT_PTMCPSR_PTMPS0              _ECT_PTMCPSR.Bits.PTMPS0
#define ECT_PTMCPSR_PTMPS1              _ECT_PTMCPSR.Bits.PTMPS1
#define ECT_PTMCPSR_PTMPS2              _ECT_PTMCPSR.Bits.PTMPS2
#define ECT_PTMCPSR_PTMPS3              _ECT_PTMCPSR.Bits.PTMPS3
#define ECT_PTMCPSR_PTMPS4              _ECT_PTMCPSR.Bits.PTMPS4
#define ECT_PTMCPSR_PTMPS5              _ECT_PTMCPSR.Bits.PTMPS5
#define ECT_PTMCPSR_PTMPS6              _ECT_PTMCPSR.Bits.PTMPS6
#define ECT_PTMCPSR_PTMPS7              _ECT_PTMCPSR.Bits.PTMPS7

#define ECT_PTMCPSR_PTMPS0_MASK         1U
#define ECT_PTMCPSR_PTMPS1_MASK         2U
#define ECT_PTMCPSR_PTMPS2_MASK         4U
#define ECT_PTMCPSR_PTMPS3_MASK         8U
#define ECT_PTMCPSR_PTMPS4_MASK         16U
#define ECT_PTMCPSR_PTMPS5_MASK         32U
#define ECT_PTMCPSR_PTMPS6_MASK         64U
#define ECT_PTMCPSR_PTMPS7_MASK         128U


/*** ECT_PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PBOVI       :1;                                       /* Pulse Accumulator B Overflow Interrupt enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PBEN        :1;                                       /* Pulse Accumulator B System Enable */
    byte             :1; 
  } Bits;
} ECT_PBCTLSTR;
extern volatile ECT_PBCTLSTR _ECT_PBCTL @(REG_BASE + 0x00000070UL);
#define ECT_PBCTL                       _ECT_PBCTL.Byte
#define ECT_PBCTL_PBOVI                 _ECT_PBCTL.Bits.PBOVI
#define ECT_PBCTL_PBEN                  _ECT_PBCTL.Bits.PBEN

#define ECT_PBCTL_PBOVI_MASK            2U
#define ECT_PBCTL_PBEN_MASK             64U


/*** ECT_PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PBOVF       :1;                                       /* Pulse Accumulator B Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ECT_PBFLGSTR;
extern volatile ECT_PBFLGSTR _ECT_PBFLG @(REG_BASE + 0x00000071UL);
#define ECT_PBFLG                       _ECT_PBFLG.Byte
#define ECT_PBFLG_PBOVF                 _ECT_PBFLG.Bits.PBOVF

#define ECT_PBFLG_PBOVF_MASK            2U


/*** ECT_PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***/
    union {
      byte Byte;
    } ECT_PA3HSTR;
    #define ECT_PA3H                    _ECT_PA32H.Overlap_STR.ECT_PA3HSTR.Byte
    

    /*** ECT_PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***/
    union {
      byte Byte;
    } ECT_PA2HSTR;
    #define ECT_PA2H                    _ECT_PA32H.Overlap_STR.ECT_PA2HSTR.Byte
    
  } Overlap_STR;

} ECT_PA32HSTR;
extern volatile ECT_PA32HSTR _ECT_PA32H @(REG_BASE + 0x00000072UL);
#define ECT_PA32H                       _ECT_PA32H.Word


/*** ECT_PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***/
    union {
      byte Byte;
    } ECT_PA1HSTR;
    #define ECT_PA1H                    _ECT_PA10H.Overlap_STR.ECT_PA1HSTR.Byte
    

    /*** ECT_PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***/
    union {
      byte Byte;
    } ECT_PA0HSTR;
    #define ECT_PA0H                    _ECT_PA10H.Overlap_STR.ECT_PA0HSTR.Byte
    
  } Overlap_STR;

} ECT_PA10HSTR;
extern volatile ECT_PA10HSTR _ECT_PA10H @(REG_BASE + 0x00000074UL);
#define ECT_PA10H                       _ECT_PA10H.Word


/*** ECT_MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***/
    union {
      byte Byte;
    } ECT_MCCNThiSTR;
    #define ECT_MCCNThi                 _ECT_MCCNT.Overlap_STR.ECT_MCCNThiSTR.Byte
    

    /*** ECT_MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***/
    union {
      byte Byte;
    } ECT_MCCNTloSTR;
    #define ECT_MCCNTlo                 _ECT_MCCNT.Overlap_STR.ECT_MCCNTloSTR.Byte
    
  } Overlap_STR;

} ECT_MCCNTSTR;
extern volatile ECT_MCCNTSTR _ECT_MCCNT @(REG_BASE + 0x00000076UL);
#define ECT_MCCNT                       _ECT_MCCNT.Word


/*** ECT_TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC0Hhi - Timer Input Capture Holding Registers High; 0x00000078 ***/
    union {
      byte Byte;
    } ECT_TC0HhiSTR;
    #define ECT_TC0Hhi                  _ECT_TC0H.Overlap_STR.ECT_TC0HhiSTR.Byte
    

    /*** ECT_TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***/
    union {
      byte Byte;
    } ECT_TC0HloSTR;
    #define ECT_TC0Hlo                  _ECT_TC0H.Overlap_STR.ECT_TC0HloSTR.Byte
    
  } Overlap_STR;

} ECT_TC0HSTR;
extern volatile ECT_TC0HSTR _ECT_TC0H @(REG_BASE + 0x00000078UL);
#define ECT_TC0H                        _ECT_TC0H.Word


/*** ECT_TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***/
    union {
      byte Byte;
    } ECT_TC1HhiSTR;
    #define ECT_TC1Hhi                  _ECT_TC1H.Overlap_STR.ECT_TC1HhiSTR.Byte
    

    /*** ECT_TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***/
    union {
      byte Byte;
    } ECT_TC1HloSTR;
    #define ECT_TC1Hlo                  _ECT_TC1H.Overlap_STR.ECT_TC1HloSTR.Byte
    
  } Overlap_STR;

} ECT_TC1HSTR;
extern volatile ECT_TC1HSTR _ECT_TC1H @(REG_BASE + 0x0000007AUL);
#define ECT_TC1H                        _ECT_TC1H.Word


/*** ECT_TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***/
    union {
      byte Byte;
    } ECT_TC2HhiSTR;
    #define ECT_TC2Hhi                  _ECT_TC2H.Overlap_STR.ECT_TC2HhiSTR.Byte
    

    /*** ECT_TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***/
    union {
      byte Byte;
    } ECT_TC2HloSTR;
    #define ECT_TC2Hlo                  _ECT_TC2H.Overlap_STR.ECT_TC2HloSTR.Byte
    
  } Overlap_STR;

} ECT_TC2HSTR;
extern volatile ECT_TC2HSTR _ECT_TC2H @(REG_BASE + 0x0000007CUL);
#define ECT_TC2H                        _ECT_TC2H.Word


/*** ECT_TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ECT_TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***/
    union {
      byte Byte;
    } ECT_TC3HhiSTR;
    #define ECT_TC3Hhi                  _ECT_TC3H.Overlap_STR.ECT_TC3HhiSTR.Byte
    

    /*** ECT_TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***/
    union {
      byte Byte;
    } ECT_TC3HloSTR;
    #define ECT_TC3Hlo                  _ECT_TC3H.Overlap_STR.ECT_TC3HloSTR.Byte
    
  } Overlap_STR;

} ECT_TC3HSTR;
extern volatile ECT_TC3HSTR _ECT_TC3H @(REG_BASE + 0x0000007EUL);
#define ECT_TC3H                        _ECT_TC3H.Word


/*** ATD1CTL01 - ATD 1 Control Register 01; 0x00000080 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL0 - ATD 1 Control Register 0; 0x00000080 ***/
    union {
      byte Byte;
      struct {
        byte WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
        byte WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
        byte WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
        byte WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpWRAP :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL0STR;
    #define ATD1CTL0                    _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Byte
    #define ATD1CTL0_WRAP0              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP0
    #define ATD1CTL0_WRAP1              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP1
    #define ATD1CTL0_WRAP2              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP2
    #define ATD1CTL0_WRAP3              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP3
    /* ATD1CTL_ARR: Access 6 ATD1CTLx registers in an array */
    #define ATD1CTL_ARR                 ((volatile byte *) &ATD1CTL0)
    #define ATD1CTL0_WRAP               _ATD1CTL01.Overlap_STR.ATD1CTL0STR.MergedBits.grpWRAP
    
    #define ATD1CTL0_WRAP0_MASK         1U
    #define ATD1CTL0_WRAP1_MASK         2U
    #define ATD1CTL0_WRAP2_MASK         4U
    #define ATD1CTL0_WRAP3_MASK         8U
    #define ATD1CTL0_WRAP_MASK          15U
    #define ATD1CTL0_WRAP_BITNUM        0U
    

    /*** ATD1CTL1 - ATD 1 Control Register 1; 0x00000081 ***/
    union {
      byte Byte;
      struct {
        byte ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
        byte ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
        byte ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
        byte ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
        byte SMP_DIS     :1;                                       /* Discharge Before Sampling Bit */
        byte SRES0       :1;                                       /* A/D Resolution Select Bit 0 */
        byte SRES1       :1;                                       /* A/D Resolution Select Bit 1 */
        byte ETRIGSEL    :1;                                       /* External Trigger Source Select */
      } Bits;
      struct {
        byte grpETRIGCH :4;
        byte     :1;
        byte grpSRES :2;
        byte     :1;
      } MergedBits;
    } ATD1CTL1STR;
    #define ATD1CTL1                    _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Byte
    #define ATD1CTL1_ETRIGCH0           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH0
    #define ATD1CTL1_ETRIGCH1           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH1
    #define ATD1CTL1_ETRIGCH2           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH2
    #define ATD1CTL1_ETRIGCH3           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH3
    #define ATD1CTL1_SMP_DIS            _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.SMP_DIS
    #define ATD1CTL1_SRES0              _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.SRES0
    #define ATD1CTL1_SRES1              _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.SRES1
    #define ATD1CTL1_ETRIGSEL           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGSEL
    #define ATD1CTL1_ETRIGCH            _ATD1CTL01.Overlap_STR.ATD1CTL1STR.MergedBits.grpETRIGCH
    #define ATD1CTL1_SRES               _ATD1CTL01.Overlap_STR.ATD1CTL1STR.MergedBits.grpSRES
    
    #define ATD1CTL1_ETRIGCH0_MASK      1U
    #define ATD1CTL1_ETRIGCH1_MASK      2U
    #define ATD1CTL1_ETRIGCH2_MASK      4U
    #define ATD1CTL1_ETRIGCH3_MASK      8U
    #define ATD1CTL1_SMP_DIS_MASK       16U
    #define ATD1CTL1_SRES0_MASK         32U
    #define ATD1CTL1_SRES1_MASK         64U
    #define ATD1CTL1_ETRIGSEL_MASK      128U
    #define ATD1CTL1_ETRIGCH_MASK       15U
    #define ATD1CTL1_ETRIGCH_BITNUM     0U
    #define ATD1CTL1_SRES_MASK          96U
    #define ATD1CTL1_SRES_BITNUM        5U
    
  } Overlap_STR;

  struct {
    word ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
    word ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
    word ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
    word ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
    word SMP_DIS     :1;                                       /* Discharge Before Sampling Bit */
    word SRES0       :1;                                       /* A/D Resolution Select Bit 0 */
    word SRES1       :1;                                       /* A/D Resolution Select Bit 1 */
    word ETRIGSEL    :1;                                       /* External Trigger Source Select */
    word WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
    word WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
    word WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
    word WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpETRIGCH :4;
    word         :1;
    word grpSRES :2;
    word         :1;
    word grpWRAP :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATD1CTL01STR;
extern volatile ATD1CTL01STR _ATD1CTL01 @(REG_BASE + 0x00000080UL);
#define ATD1CTL01                       _ATD1CTL01.Word
#define ATD1CTL01_ETRIGCH0              _ATD1CTL01.Bits.ETRIGCH0
#define ATD1CTL01_ETRIGCH1              _ATD1CTL01.Bits.ETRIGCH1
#define ATD1CTL01_ETRIGCH2              _ATD1CTL01.Bits.ETRIGCH2
#define ATD1CTL01_ETRIGCH3              _ATD1CTL01.Bits.ETRIGCH3
#define ATD1CTL01_SMP_DIS               _ATD1CTL01.Bits.SMP_DIS
#define ATD1CTL01_SRES0                 _ATD1CTL01.Bits.SRES0
#define ATD1CTL01_SRES1                 _ATD1CTL01.Bits.SRES1
#define ATD1CTL01_ETRIGSEL              _ATD1CTL01.Bits.ETRIGSEL
#define ATD1CTL01_WRAP0                 _ATD1CTL01.Bits.WRAP0
#define ATD1CTL01_WRAP1                 _ATD1CTL01.Bits.WRAP1
#define ATD1CTL01_WRAP2                 _ATD1CTL01.Bits.WRAP2
#define ATD1CTL01_WRAP3                 _ATD1CTL01.Bits.WRAP3
#define ATD1CTL01_ETRIGCH               _ATD1CTL01.MergedBits.grpETRIGCH
#define ATD1CTL01_SRES                  _ATD1CTL01.MergedBits.grpSRES
#define ATD1CTL01_WRAP                  _ATD1CTL01.MergedBits.grpWRAP

#define ATD1CTL01_ETRIGCH0_MASK         1U
#define ATD1CTL01_ETRIGCH1_MASK         2U
#define ATD1CTL01_ETRIGCH2_MASK         4U
#define ATD1CTL01_ETRIGCH3_MASK         8U
#define ATD1CTL01_SMP_DIS_MASK          16U
#define ATD1CTL01_SRES0_MASK            32U
#define ATD1CTL01_SRES1_MASK            64U
#define ATD1CTL01_ETRIGSEL_MASK         128U
#define ATD1CTL01_WRAP0_MASK            256U
#define ATD1CTL01_WRAP1_MASK            512U
#define ATD1CTL01_WRAP2_MASK            1024U
#define ATD1CTL01_WRAP3_MASK            2048U
#define ATD1CTL01_ETRIGCH_MASK          15U
#define ATD1CTL01_ETRIGCH_BITNUM        0U
#define ATD1CTL01_SRES_MASK             96U
#define ATD1CTL01_SRES_BITNUM           5U
#define ATD1CTL01_WRAP_MASK             3840U
#define ATD1CTL01_WRAP_BITNUM           8U


/*** ATD1CTL23 - ATD 1 Control Register 23; 0x00000082 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL2 - ATD 1 Control Register 2; 0x00000082 ***/
    union {
      byte Byte;
      struct {
        byte ACMPIE      :1;                                       /* ATD Compare Interrupt Enable */
        byte ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
        byte ETRIGE      :1;                                       /* External Trigger Mode enable */
        byte ETRIGP      :1;                                       /* External Trigger Polarity */
        byte ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
        byte ICLKSTP     :1;                                       /* Internal Clock in Stop Mode Bit */
        byte AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
        byte             :1; 
      } Bits;
    } ATD1CTL2STR;
    #define ATD1CTL2                    _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Byte
    #define ATD1CTL2_ACMPIE             _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ACMPIE
    #define ATD1CTL2_ASCIE              _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ASCIE
    #define ATD1CTL2_ETRIGE             _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGE
    #define ATD1CTL2_ETRIGP             _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGP
    #define ATD1CTL2_ETRIGLE            _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGLE
    #define ATD1CTL2_ICLKSTP            _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ICLKSTP
    #define ATD1CTL2_AFFC               _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.AFFC
    
    #define ATD1CTL2_ACMPIE_MASK        1U
    #define ATD1CTL2_ASCIE_MASK         2U
    #define ATD1CTL2_ETRIGE_MASK        4U
    #define ATD1CTL2_ETRIGP_MASK        8U
    #define ATD1CTL2_ETRIGLE_MASK       16U
    #define ATD1CTL2_ICLKSTP_MASK       32U
    #define ATD1CTL2_AFFC_MASK          64U
    

    /*** ATD1CTL3 - ATD 1 Control Register 3; 0x00000083 ***/
    union {
      byte Byte;
      struct {
        byte FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
        byte FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
        byte FIFO        :1;                                       /* Result Register FIFO Mode */
        byte S1C         :1;                                       /* Conversion Sequence Length 1 */
        byte S2C         :1;                                       /* Conversion Sequence Length 2 */
        byte S4C         :1;                                       /* Conversion Sequence Length 4 */
        byte S8C         :1;                                       /* Conversion Sequence Length 8 */
        byte DJM         :1;                                       /* Result Register Data Justification */
      } Bits;
      struct {
        byte grpFRZ :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL3STR;
    #define ATD1CTL3                    _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Byte
    #define ATD1CTL3_FRZ0               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FRZ0
    #define ATD1CTL3_FRZ1               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FRZ1
    #define ATD1CTL3_FIFO               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FIFO
    #define ATD1CTL3_S1C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S1C
    #define ATD1CTL3_S2C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S2C
    #define ATD1CTL3_S4C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S4C
    #define ATD1CTL3_S8C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S8C
    #define ATD1CTL3_DJM                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.DJM
    #define ATD1CTL3_FRZ                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.MergedBits.grpFRZ
    
    #define ATD1CTL3_FRZ0_MASK          1U
    #define ATD1CTL3_FRZ1_MASK          2U
    #define ATD1CTL3_FIFO_MASK          4U
    #define ATD1CTL3_S1C_MASK           8U
    #define ATD1CTL3_S2C_MASK           16U
    #define ATD1CTL3_S4C_MASK           32U
    #define ATD1CTL3_S8C_MASK           64U
    #define ATD1CTL3_DJM_MASK           128U
    #define ATD1CTL3_FRZ_MASK           3U
    #define ATD1CTL3_FRZ_BITNUM         0U
    
  } Overlap_STR;

  struct {
    word FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
    word FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
    word FIFO        :1;                                       /* Result Register FIFO Mode */
    word S1C         :1;                                       /* Conversion Sequence Length 1 */
    word S2C         :1;                                       /* Conversion Sequence Length 2 */
    word S4C         :1;                                       /* Conversion Sequence Length 4 */
    word S8C         :1;                                       /* Conversion Sequence Length 8 */
    word DJM         :1;                                       /* Result Register Data Justification */
    word ACMPIE      :1;                                       /* ATD Compare Interrupt Enable */
    word ASCIE       :1;                                       /* ATD Sequence Complete Interrupt Enable */
    word ETRIGE      :1;                                       /* External Trigger Mode enable */
    word ETRIGP      :1;                                       /* External Trigger Polarity */
    word ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
    word ICLKSTP     :1;                                       /* Internal Clock in Stop Mode Bit */
    word AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
    word             :1; 
  } Bits;
  struct {
    word grpFRZ  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATD1CTL23STR;
extern volatile ATD1CTL23STR _ATD1CTL23 @(REG_BASE + 0x00000082UL);
#define ATD1CTL23                       _ATD1CTL23.Word
#define ATD1CTL23_FRZ0                  _ATD1CTL23.Bits.FRZ0
#define ATD1CTL23_FRZ1                  _ATD1CTL23.Bits.FRZ1
#define ATD1CTL23_FIFO                  _ATD1CTL23.Bits.FIFO
#define ATD1CTL23_S1C                   _ATD1CTL23.Bits.S1C
#define ATD1CTL23_S2C                   _ATD1CTL23.Bits.S2C
#define ATD1CTL23_S4C                   _ATD1CTL23.Bits.S4C
#define ATD1CTL23_S8C                   _ATD1CTL23.Bits.S8C
#define ATD1CTL23_DJM                   _ATD1CTL23.Bits.DJM
#define ATD1CTL23_ACMPIE                _ATD1CTL23.Bits.ACMPIE
#define ATD1CTL23_ASCIE                 _ATD1CTL23.Bits.ASCIE
#define ATD1CTL23_ETRIGE                _ATD1CTL23.Bits.ETRIGE
#define ATD1CTL23_ETRIGP                _ATD1CTL23.Bits.ETRIGP
#define ATD1CTL23_ETRIGLE               _ATD1CTL23.Bits.ETRIGLE
#define ATD1CTL23_ICLKSTP               _ATD1CTL23.Bits.ICLKSTP
#define ATD1CTL23_AFFC                  _ATD1CTL23.Bits.AFFC
#define ATD1CTL23_FRZ                   _ATD1CTL23.MergedBits.grpFRZ

#define ATD1CTL23_FRZ0_MASK             1U
#define ATD1CTL23_FRZ1_MASK             2U
#define ATD1CTL23_FIFO_MASK             4U
#define ATD1CTL23_S1C_MASK              8U
#define ATD1CTL23_S2C_MASK              16U
#define ATD1CTL23_S4C_MASK              32U
#define ATD1CTL23_S8C_MASK              64U
#define ATD1CTL23_DJM_MASK              128U
#define ATD1CTL23_ACMPIE_MASK           256U
#define ATD1CTL23_ASCIE_MASK            512U
#define ATD1CTL23_ETRIGE_MASK           1024U
#define ATD1CTL23_ETRIGP_MASK           2048U
#define ATD1CTL23_ETRIGLE_MASK          4096U
#define ATD1CTL23_ICLKSTP_MASK          8192U
#define ATD1CTL23_AFFC_MASK             16384U
#define ATD1CTL23_FRZ_MASK              3U
#define ATD1CTL23_FRZ_BITNUM            0U


/*** ATD1CTL45 - ATD 1 Control Register 45; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL4 - ATD 1 Control Register 4; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte PRS0        :1;                                       /* ATD Clock Prescaler 0 */
        byte PRS1        :1;                                       /* ATD Clock Prescaler 1 */
        byte PRS2        :1;                                       /* ATD Clock Prescaler 2 */
        byte PRS3        :1;                                       /* ATD Clock Prescaler 3 */
        byte PRS4        :1;                                       /* ATD Clock Prescaler 4 */
        byte SMP0        :1;                                       /* Sample Time Select 0 */
        byte SMP1        :1;                                       /* Sample Time Select 1 */
        byte SMP2        :1;                                       /* Sample Time Select 2 */
      } Bits;
      struct {
        byte grpPRS :5;
        byte grpSMP :3;
      } MergedBits;
    } ATD1CTL4STR;
    #define ATD1CTL4                    _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Byte
    #define ATD1CTL4_PRS0               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS0
    #define ATD1CTL4_PRS1               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS1
    #define ATD1CTL4_PRS2               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS2
    #define ATD1CTL4_PRS3               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS3
    #define ATD1CTL4_PRS4               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS4
    #define ATD1CTL4_SMP0               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SMP0
    #define ATD1CTL4_SMP1               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SMP1
    #define ATD1CTL4_SMP2               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SMP2
    #define ATD1CTL4_PRS                _ATD1CTL45.Overlap_STR.ATD1CTL4STR.MergedBits.grpPRS
    #define ATD1CTL4_SMP                _ATD1CTL45.Overlap_STR.ATD1CTL4STR.MergedBits.grpSMP
    
    #define ATD1CTL4_PRS0_MASK          1U
    #define ATD1CTL4_PRS1_MASK          2U
    #define ATD1CTL4_PRS2_MASK          4U
    #define ATD1CTL4_PRS3_MASK          8U
    #define ATD1CTL4_PRS4_MASK          16U
    #define ATD1CTL4_SMP0_MASK          32U
    #define ATD1CTL4_SMP1_MASK          64U
    #define ATD1CTL4_SMP2_MASK          128U
    #define ATD1CTL4_PRS_MASK           31U
    #define ATD1CTL4_PRS_BITNUM         0U
    #define ATD1CTL4_SMP_MASK           224U
    #define ATD1CTL4_SMP_BITNUM         5U
    

    /*** ATD1CTL5 - ATD 1 Control Register 5; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte CA          :1;                                       /* Analog Input Channel Select Code A */
        byte CB          :1;                                       /* Analog Input Channel Select Code B */
        byte CC          :1;                                       /* Analog Input Channel Select Code C */
        byte CD          :1;                                       /* Analog Input Channel Select Code D */
        byte MULT        :1;                                       /* Multi-Channel Sample Mode */
        byte SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
        byte SC          :1;                                       /* Special Channel Conversion Bit */
        byte             :1; 
      } Bits;
      struct {
        byte grpCx :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL5STR;
    #define ATD1CTL5                    _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Byte
    #define ATD1CTL5_CA                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CA
    #define ATD1CTL5_CB                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CB
    #define ATD1CTL5_CC                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CC
    #define ATD1CTL5_CD                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CD
    #define ATD1CTL5_MULT               _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.MULT
    #define ATD1CTL5_SCAN               _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.SCAN
    #define ATD1CTL5_SC                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.SC
    #define ATD1CTL5_Cx                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.MergedBits.grpCx
    
    #define ATD1CTL5_CA_MASK            1U
    #define ATD1CTL5_CB_MASK            2U
    #define ATD1CTL5_CC_MASK            4U
    #define ATD1CTL5_CD_MASK            8U
    #define ATD1CTL5_MULT_MASK          16U
    #define ATD1CTL5_SCAN_MASK          32U
    #define ATD1CTL5_SC_MASK            64U
    #define ATD1CTL5_Cx_MASK            15U
    #define ATD1CTL5_Cx_BITNUM          0U
    
  } Overlap_STR;

  struct {
    word CA          :1;                                       /* Analog Input Channel Select Code A */
    word CB          :1;                                       /* Analog Input Channel Select Code B */
    word CC          :1;                                       /* Analog Input Channel Select Code C */
    word CD          :1;                                       /* Analog Input Channel Select Code D */
    word MULT        :1;                                       /* Multi-Channel Sample Mode */
    word SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
    word SC          :1;                                       /* Special Channel Conversion Bit */
    word             :1; 
    word PRS0        :1;                                       /* ATD Clock Prescaler 0 */
    word PRS1        :1;                                       /* ATD Clock Prescaler 1 */
    word PRS2        :1;                                       /* ATD Clock Prescaler 2 */
    word PRS3        :1;                                       /* ATD Clock Prescaler 3 */
    word PRS4        :1;                                       /* ATD Clock Prescaler 4 */
    word SMP0        :1;                                       /* Sample Time Select 0 */
    word SMP1        :1;                                       /* Sample Time Select 1 */
    word SMP2        :1;                                       /* Sample Time Select 2 */
  } Bits;
  struct {
    word grpCx   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRS  :5;
    word grpSMP  :3;
  } MergedBits;
} ATD1CTL45STR;
extern volatile ATD1CTL45STR _ATD1CTL45 @(REG_BASE + 0x00000084UL);
#define ATD1CTL45                       _ATD1CTL45.Word
#define ATD1CTL45_CA                    _ATD1CTL45.Bits.CA
#define ATD1CTL45_CB                    _ATD1CTL45.Bits.CB
#define ATD1CTL45_CC                    _ATD1CTL45.Bits.CC
#define ATD1CTL45_CD                    _ATD1CTL45.Bits.CD
#define ATD1CTL45_MULT                  _ATD1CTL45.Bits.MULT
#define ATD1CTL45_SCAN                  _ATD1CTL45.Bits.SCAN
#define ATD1CTL45_SC                    _ATD1CTL45.Bits.SC
#define ATD1CTL45_PRS0                  _ATD1CTL45.Bits.PRS0
#define ATD1CTL45_PRS1                  _ATD1CTL45.Bits.PRS1
#define ATD1CTL45_PRS2                  _ATD1CTL45.Bits.PRS2
#define ATD1CTL45_PRS3                  _ATD1CTL45.Bits.PRS3
#define ATD1CTL45_PRS4                  _ATD1CTL45.Bits.PRS4
#define ATD1CTL45_SMP0                  _ATD1CTL45.Bits.SMP0
#define ATD1CTL45_SMP1                  _ATD1CTL45.Bits.SMP1
#define ATD1CTL45_SMP2                  _ATD1CTL45.Bits.SMP2
#define ATD1CTL45_Cx                    _ATD1CTL45.MergedBits.grpCx
#define ATD1CTL45_PRS                   _ATD1CTL45.MergedBits.grpPRS
#define ATD1CTL45_SMP                   _ATD1CTL45.MergedBits.grpSMP

#define ATD1CTL45_CA_MASK               1U
#define ATD1CTL45_CB_MASK               2U
#define ATD1CTL45_CC_MASK               4U
#define ATD1CTL45_CD_MASK               8U
#define ATD1CTL45_MULT_MASK             16U
#define ATD1CTL45_SCAN_MASK             32U
#define ATD1CTL45_SC_MASK               64U
#define ATD1CTL45_PRS0_MASK             256U
#define ATD1CTL45_PRS1_MASK             512U
#define ATD1CTL45_PRS2_MASK             1024U
#define ATD1CTL45_PRS3_MASK             2048U
#define ATD1CTL45_PRS4_MASK             4096U
#define ATD1CTL45_SMP0_MASK             8192U
#define ATD1CTL45_SMP1_MASK             16384U
#define ATD1CTL45_SMP2_MASK             32768U
#define ATD1CTL45_Cx_MASK               15U
#define ATD1CTL45_Cx_BITNUM             0U
#define ATD1CTL45_PRS_MASK              7936U
#define ATD1CTL45_PRS_BITNUM            8U
#define ATD1CTL45_SMP_MASK              57344U
#define ATD1CTL45_SMP_BITNUM            13U


/*** ATD1STAT0 - ATD 1 Status Register 0; 0x00000086 ***/
typedef union {
  byte Byte;
  struct {
    byte CC0         :1;                                       /* Conversion Counter 0 */
    byte CC1         :1;                                       /* Conversion Counter 1 */
    byte CC2         :1;                                       /* Conversion Counter 2 */
    byte CC3         :1;                                       /* Conversion Counter 3 */
    byte FIFOR       :1;                                       /* FIFO Over Run Flag */
    byte ETORF       :1;                                       /* External Trigger Overrun Flag */
    byte             :1; 
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
  struct {
    byte grpCC   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ATD1STAT0STR;
extern volatile ATD1STAT0STR _ATD1STAT0 @(REG_BASE + 0x00000086UL);
#define ATD1STAT0                       _ATD1STAT0.Byte
#define ATD1STAT0_CC0                   _ATD1STAT0.Bits.CC0
#define ATD1STAT0_CC1                   _ATD1STAT0.Bits.CC1
#define ATD1STAT0_CC2                   _ATD1STAT0.Bits.CC2
#define ATD1STAT0_CC3                   _ATD1STAT0.Bits.CC3
#define ATD1STAT0_FIFOR                 _ATD1STAT0.Bits.FIFOR
#define ATD1STAT0_ETORF                 _ATD1STAT0.Bits.ETORF
#define ATD1STAT0_SCF                   _ATD1STAT0.Bits.SCF
#define ATD1STAT0_CC                    _ATD1STAT0.MergedBits.grpCC

#define ATD1STAT0_CC0_MASK              1U
#define ATD1STAT0_CC1_MASK              2U
#define ATD1STAT0_CC2_MASK              4U
#define ATD1STAT0_CC3_MASK              8U
#define ATD1STAT0_FIFOR_MASK            16U
#define ATD1STAT0_ETORF_MASK            32U
#define ATD1STAT0_SCF_MASK              128U
#define ATD1STAT0_CC_MASK               15U
#define ATD1STAT0_CC_BITNUM             0U


/*** ATD1CMPE - ATD 1 Compare Enable Register; 0x00000088 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CMPEH - ATD 1 Compare Enable Register High; 0x00000088 ***/
    union {
      byte Byte;
      struct {
        byte CMPE8       :1;                                       /* Compare Enable for Conversion Number 8 of a Sequence */
        byte CMPE9       :1;                                       /* Compare Enable for Conversion Number 9 of a Sequence */
        byte CMPE10      :1;                                       /* Compare Enable for Conversion Number 10 of a Sequence */
        byte CMPE11      :1;                                       /* Compare Enable for Conversion Number 11 of a Sequence */
        byte CMPE12      :1;                                       /* Compare Enable for Conversion Number 12 of a Sequence */
        byte CMPE13      :1;                                       /* Compare Enable for Conversion Number 13 of a Sequence */
        byte CMPE14      :1;                                       /* Compare Enable for Conversion Number 14 of a Sequence */
        byte CMPE15      :1;                                       /* Compare Enable for Conversion Number 15 of a Sequence */
      } Bits;
    } ATD1CMPEHSTR;
    #define ATD1CMPEH                   _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Byte
    #define ATD1CMPEH_CMPE8             _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Bits.CMPE8
    #define ATD1CMPEH_CMPE9             _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Bits.CMPE9
    #define ATD1CMPEH_CMPE10            _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Bits.CMPE10
    #define ATD1CMPEH_CMPE11            _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Bits.CMPE11
    #define ATD1CMPEH_CMPE12            _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Bits.CMPE12
    #define ATD1CMPEH_CMPE13            _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Bits.CMPE13
    #define ATD1CMPEH_CMPE14            _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Bits.CMPE14
    #define ATD1CMPEH_CMPE15            _ATD1CMPE.Overlap_STR.ATD1CMPEHSTR.Bits.CMPE15
    
    #define ATD1CMPEH_CMPE8_MASK        1U
    #define ATD1CMPEH_CMPE9_MASK        2U
    #define ATD1CMPEH_CMPE10_MASK       4U
    #define ATD1CMPEH_CMPE11_MASK       8U
    #define ATD1CMPEH_CMPE12_MASK       16U
    #define ATD1CMPEH_CMPE13_MASK       32U
    #define ATD1CMPEH_CMPE14_MASK       64U
    #define ATD1CMPEH_CMPE15_MASK       128U
    

    /*** ATD1CMPEL - ATD 1 Compare Enable Register Low; 0x00000089 ***/
    union {
      byte Byte;
      struct {
        byte CMPE0       :1;                                       /* Compare Enable for Conversion Number 0 of a Sequence */
        byte CMPE1       :1;                                       /* Compare Enable for Conversion Number 1 of a Sequence */
        byte CMPE2       :1;                                       /* Compare Enable for Conversion Number 2 of a Sequence */
        byte CMPE3       :1;                                       /* Compare Enable for Conversion Number 3 of a Sequence */
        byte CMPE4       :1;                                       /* Compare Enable for Conversion Number 4 of a Sequence */
        byte CMPE5       :1;                                       /* Compare Enable for Conversion Number 5 of a Sequence */
        byte CMPE6       :1;                                       /* Compare Enable for Conversion Number 6 of a Sequence */
        byte CMPE7       :1;                                       /* Compare Enable for Conversion Number 7 of a Sequence */
      } Bits;
    } ATD1CMPELSTR;
    #define ATD1CMPEL                   _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Byte
    #define ATD1CMPEL_CMPE0             _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Bits.CMPE0
    #define ATD1CMPEL_CMPE1             _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Bits.CMPE1
    #define ATD1CMPEL_CMPE2             _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Bits.CMPE2
    #define ATD1CMPEL_CMPE3             _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Bits.CMPE3
    #define ATD1CMPEL_CMPE4             _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Bits.CMPE4
    #define ATD1CMPEL_CMPE5             _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Bits.CMPE5
    #define ATD1CMPEL_CMPE6             _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Bits.CMPE6
    #define ATD1CMPEL_CMPE7             _ATD1CMPE.Overlap_STR.ATD1CMPELSTR.Bits.CMPE7
    
    #define ATD1CMPEL_CMPE0_MASK        1U
    #define ATD1CMPEL_CMPE1_MASK        2U
    #define ATD1CMPEL_CMPE2_MASK        4U
    #define ATD1CMPEL_CMPE3_MASK        8U
    #define ATD1CMPEL_CMPE4_MASK        16U
    #define ATD1CMPEL_CMPE5_MASK        32U
    #define ATD1CMPEL_CMPE6_MASK        64U
    #define ATD1CMPEL_CMPE7_MASK        128U
    
  } Overlap_STR;

  struct {
    word CMPE0       :1;                                       /* Compare Enable for Conversion Number 0 of a Sequence */
    word CMPE1       :1;                                       /* Compare Enable for Conversion Number 1 of a Sequence */
    word CMPE2       :1;                                       /* Compare Enable for Conversion Number 2 of a Sequence */
    word CMPE3       :1;                                       /* Compare Enable for Conversion Number 3 of a Sequence */
    word CMPE4       :1;                                       /* Compare Enable for Conversion Number 4 of a Sequence */
    word CMPE5       :1;                                       /* Compare Enable for Conversion Number 5 of a Sequence */
    word CMPE6       :1;                                       /* Compare Enable for Conversion Number 6 of a Sequence */
    word CMPE7       :1;                                       /* Compare Enable for Conversion Number 7 of a Sequence */
    word CMPE8       :1;                                       /* Compare Enable for Conversion Number 8 of a Sequence */
    word CMPE9       :1;                                       /* Compare Enable for Conversion Number 9 of a Sequence */
    word CMPE10      :1;                                       /* Compare Enable for Conversion Number 10 of a Sequence */
    word CMPE11      :1;                                       /* Compare Enable for Conversion Number 11 of a Sequence */
    word CMPE12      :1;                                       /* Compare Enable for Conversion Number 12 of a Sequence */
    word CMPE13      :1;                                       /* Compare Enable for Conversion Number 13 of a Sequence */
    word CMPE14      :1;                                       /* Compare Enable for Conversion Number 14 of a Sequence */
    word CMPE15      :1;                                       /* Compare Enable for Conversion Number 15 of a Sequence */
  } Bits;
} ATD1CMPESTR;
extern volatile ATD1CMPESTR _ATD1CMPE @(REG_BASE + 0x00000088UL);
#define ATD1CMPE                        _ATD1CMPE.Word
#define ATD1CMPE_CMPE0                  _ATD1CMPE.Bits.CMPE0
#define ATD1CMPE_CMPE1                  _ATD1CMPE.Bits.CMPE1
#define ATD1CMPE_CMPE2                  _ATD1CMPE.Bits.CMPE2
#define ATD1CMPE_CMPE3                  _ATD1CMPE.Bits.CMPE3
#define ATD1CMPE_CMPE4                  _ATD1CMPE.Bits.CMPE4
#define ATD1CMPE_CMPE5                  _ATD1CMPE.Bits.CMPE5
#define ATD1CMPE_CMPE6                  _ATD1CMPE.Bits.CMPE6
#define ATD1CMPE_CMPE7                  _ATD1CMPE.Bits.CMPE7
#define ATD1CMPE_CMPE8                  _ATD1CMPE.Bits.CMPE8
#define ATD1CMPE_CMPE9                  _ATD1CMPE.Bits.CMPE9
#define ATD1CMPE_CMPE10                 _ATD1CMPE.Bits.CMPE10
#define ATD1CMPE_CMPE11                 _ATD1CMPE.Bits.CMPE11
#define ATD1CMPE_CMPE12                 _ATD1CMPE.Bits.CMPE12
#define ATD1CMPE_CMPE13                 _ATD1CMPE.Bits.CMPE13
#define ATD1CMPE_CMPE14                 _ATD1CMPE.Bits.CMPE14
#define ATD1CMPE_CMPE15                 _ATD1CMPE.Bits.CMPE15

#define ATD1CMPE_CMPE0_MASK             1U
#define ATD1CMPE_CMPE1_MASK             2U
#define ATD1CMPE_CMPE2_MASK             4U
#define ATD1CMPE_CMPE3_MASK             8U
#define ATD1CMPE_CMPE4_MASK             16U
#define ATD1CMPE_CMPE5_MASK             32U
#define ATD1CMPE_CMPE6_MASK             64U
#define ATD1CMPE_CMPE7_MASK             128U
#define ATD1CMPE_CMPE8_MASK             256U
#define ATD1CMPE_CMPE9_MASK             512U
#define ATD1CMPE_CMPE10_MASK            1024U
#define ATD1CMPE_CMPE11_MASK            2048U
#define ATD1CMPE_CMPE12_MASK            4096U
#define ATD1CMPE_CMPE13_MASK            8192U
#define ATD1CMPE_CMPE14_MASK            16384U
#define ATD1CMPE_CMPE15_MASK            32768U


/*** ATD1STAT2 - ATD 1 Status Register 2; 0x0000008A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1STAT2H - ATD 1 Status Register 2 High; 0x0000008A ***/
    union {
      byte Byte;
      struct {
        byte CCF8        :1;                                       /* Conversion Complete Flag 8 */
        byte CCF9        :1;                                       /* Conversion Complete Flag 9 */
        byte CCF10       :1;                                       /* Conversion Complete Flag 10 */
        byte CCF11       :1;                                       /* Conversion Complete Flag 11 */
        byte CCF12       :1;                                       /* Conversion Complete Flag 12 */
        byte CCF13       :1;                                       /* Conversion Complete Flag 13 */
        byte CCF14       :1;                                       /* Conversion Complete Flag 14 */
        byte CCF15       :1;                                       /* Conversion Complete Flag 15 */
      } Bits;
    } ATD1STAT2HSTR;
    #define ATD1STAT2H                  _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Byte
    #define ATD1STAT2H_CCF8             _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Bits.CCF8
    #define ATD1STAT2H_CCF9             _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Bits.CCF9
    #define ATD1STAT2H_CCF10            _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Bits.CCF10
    #define ATD1STAT2H_CCF11            _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Bits.CCF11
    #define ATD1STAT2H_CCF12            _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Bits.CCF12
    #define ATD1STAT2H_CCF13            _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Bits.CCF13
    #define ATD1STAT2H_CCF14            _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Bits.CCF14
    #define ATD1STAT2H_CCF15            _ATD1STAT2.Overlap_STR.ATD1STAT2HSTR.Bits.CCF15
    
    #define ATD1STAT2H_CCF8_MASK        1U
    #define ATD1STAT2H_CCF9_MASK        2U
    #define ATD1STAT2H_CCF10_MASK       4U
    #define ATD1STAT2H_CCF11_MASK       8U
    #define ATD1STAT2H_CCF12_MASK       16U
    #define ATD1STAT2H_CCF13_MASK       32U
    #define ATD1STAT2H_CCF14_MASK       64U
    #define ATD1STAT2H_CCF15_MASK       128U
    

    /*** ATD1STAT2L - ATD 1 Status Register 2 Low; 0x0000008B ***/
    union {
      byte Byte;
      struct {
        byte CCF0        :1;                                       /* Conversion Complete Flag 0 */
        byte CCF1        :1;                                       /* Conversion Complete Flag 1 */
        byte CCF2        :1;                                       /* Conversion Complete Flag 2 */
        byte CCF3        :1;                                       /* Conversion Complete Flag 3 */
        byte CCF4        :1;                                       /* Conversion Complete Flag 4 */
        byte CCF5        :1;                                       /* Conversion Complete Flag 5 */
        byte CCF6        :1;                                       /* Conversion Complete Flag 6 */
        byte CCF7        :1;                                       /* Conversion Complete Flag 7 */
      } Bits;
    } ATD1STAT2LSTR;
    #define ATD1STAT2L                  _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Byte
    #define ATD1STAT2L_CCF0             _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Bits.CCF0
    #define ATD1STAT2L_CCF1             _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Bits.CCF1
    #define ATD1STAT2L_CCF2             _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Bits.CCF2
    #define ATD1STAT2L_CCF3             _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Bits.CCF3
    #define ATD1STAT2L_CCF4             _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Bits.CCF4
    #define ATD1STAT2L_CCF5             _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Bits.CCF5
    #define ATD1STAT2L_CCF6             _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Bits.CCF6
    #define ATD1STAT2L_CCF7             _ATD1STAT2.Overlap_STR.ATD1STAT2LSTR.Bits.CCF7
    
    #define ATD1STAT2L_CCF0_MASK        1U
    #define ATD1STAT2L_CCF1_MASK        2U
    #define ATD1STAT2L_CCF2_MASK        4U
    #define ATD1STAT2L_CCF3_MASK        8U
    #define ATD1STAT2L_CCF4_MASK        16U
    #define ATD1STAT2L_CCF5_MASK        32U
    #define ATD1STAT2L_CCF6_MASK        64U
    #define ATD1STAT2L_CCF7_MASK        128U
    
  } Overlap_STR;

  struct {
    word CCF0        :1;                                       /* Conversion Complete Flag 0 */
    word CCF1        :1;                                       /* Conversion Complete Flag 1 */
    word CCF2        :1;                                       /* Conversion Complete Flag 2 */
    word CCF3        :1;                                       /* Conversion Complete Flag 3 */
    word CCF4        :1;                                       /* Conversion Complete Flag 4 */
    word CCF5        :1;                                       /* Conversion Complete Flag 5 */
    word CCF6        :1;                                       /* Conversion Complete Flag 6 */
    word CCF7        :1;                                       /* Conversion Complete Flag 7 */
    word CCF8        :1;                                       /* Conversion Complete Flag 8 */
    word CCF9        :1;                                       /* Conversion Complete Flag 9 */
    word CCF10       :1;                                       /* Conversion Complete Flag 10 */
    word CCF11       :1;                                       /* Conversion Complete Flag 11 */
    word CCF12       :1;                                       /* Conversion Complete Flag 12 */
    word CCF13       :1;                                       /* Conversion Complete Flag 13 */
    word CCF14       :1;                                       /* Conversion Complete Flag 14 */
    word CCF15       :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
} ATD1STAT2STR;
extern volatile ATD1STAT2STR _ATD1STAT2 @(REG_BASE + 0x0000008AUL);
#define ATD1STAT2                       _ATD1STAT2.Word
#define ATD1STAT2_CCF0                  _ATD1STAT2.Bits.CCF0
#define ATD1STAT2_CCF1                  _ATD1STAT2.Bits.CCF1
#define ATD1STAT2_CCF2                  _ATD1STAT2.Bits.CCF2
#define ATD1STAT2_CCF3                  _ATD1STAT2.Bits.CCF3
#define ATD1STAT2_CCF4                  _ATD1STAT2.Bits.CCF4
#define ATD1STAT2_CCF5                  _ATD1STAT2.Bits.CCF5
#define ATD1STAT2_CCF6                  _ATD1STAT2.Bits.CCF6
#define ATD1STAT2_CCF7                  _ATD1STAT2.Bits.CCF7
#define ATD1STAT2_CCF8                  _ATD1STAT2.Bits.CCF8
#define ATD1STAT2_CCF9                  _ATD1STAT2.Bits.CCF9
#define ATD1STAT2_CCF10                 _ATD1STAT2.Bits.CCF10
#define ATD1STAT2_CCF11                 _ATD1STAT2.Bits.CCF11
#define ATD1STAT2_CCF12                 _ATD1STAT2.Bits.CCF12
#define ATD1STAT2_CCF13                 _ATD1STAT2.Bits.CCF13
#define ATD1STAT2_CCF14                 _ATD1STAT2.Bits.CCF14
#define ATD1STAT2_CCF15                 _ATD1STAT2.Bits.CCF15

#define ATD1STAT2_CCF0_MASK             1U
#define ATD1STAT2_CCF1_MASK             2U
#define ATD1STAT2_CCF2_MASK             4U
#define ATD1STAT2_CCF3_MASK             8U
#define ATD1STAT2_CCF4_MASK             16U
#define ATD1STAT2_CCF5_MASK             32U
#define ATD1STAT2_CCF6_MASK             64U
#define ATD1STAT2_CCF7_MASK             128U
#define ATD1STAT2_CCF8_MASK             256U
#define ATD1STAT2_CCF9_MASK             512U
#define ATD1STAT2_CCF10_MASK            1024U
#define ATD1STAT2_CCF11_MASK            2048U
#define ATD1STAT2_CCF12_MASK            4096U
#define ATD1STAT2_CCF13_MASK            8192U
#define ATD1STAT2_CCF14_MASK            16384U
#define ATD1STAT2_CCF15_MASK            32768U


/*** ATD1DIEN - ATD 1 Input Enable Register; 0x0000008C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DIENH - ATD 1 Input Enable Register High; 0x0000008C ***/
    union {
      byte Byte;
      struct {
        byte IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
        byte IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
        byte IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
        byte IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
        byte IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
        byte IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
        byte IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
        byte IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
      } Bits;
    } ATD1DIENHSTR;
    #define ATD1DIENH                   _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Byte
    #define ATD1DIENH_IEN8              _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Bits.IEN8
    #define ATD1DIENH_IEN9              _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Bits.IEN9
    #define ATD1DIENH_IEN10             _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Bits.IEN10
    #define ATD1DIENH_IEN11             _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Bits.IEN11
    #define ATD1DIENH_IEN12             _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Bits.IEN12
    #define ATD1DIENH_IEN13             _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Bits.IEN13
    #define ATD1DIENH_IEN14             _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Bits.IEN14
    #define ATD1DIENH_IEN15             _ATD1DIEN.Overlap_STR.ATD1DIENHSTR.Bits.IEN15
    
    #define ATD1DIENH_IEN8_MASK         1U
    #define ATD1DIENH_IEN9_MASK         2U
    #define ATD1DIENH_IEN10_MASK        4U
    #define ATD1DIENH_IEN11_MASK        8U
    #define ATD1DIENH_IEN12_MASK        16U
    #define ATD1DIENH_IEN13_MASK        32U
    #define ATD1DIENH_IEN14_MASK        64U
    #define ATD1DIENH_IEN15_MASK        128U
    

    /*** ATD1DIENL - ATD 1 Input Enable Register Low; 0x0000008D ***/
    union {
      byte Byte;
      struct {
        byte IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
        byte IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
        byte IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
        byte IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
        byte IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
        byte IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
        byte IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
        byte IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
      } Bits;
    } ATD1DIENLSTR;
    #define ATD1DIENL                   _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Byte
    #define ATD1DIENL_IEN0              _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Bits.IEN0
    #define ATD1DIENL_IEN1              _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Bits.IEN1
    #define ATD1DIENL_IEN2              _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Bits.IEN2
    #define ATD1DIENL_IEN3              _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Bits.IEN3
    #define ATD1DIENL_IEN4              _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Bits.IEN4
    #define ATD1DIENL_IEN5              _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Bits.IEN5
    #define ATD1DIENL_IEN6              _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Bits.IEN6
    #define ATD1DIENL_IEN7              _ATD1DIEN.Overlap_STR.ATD1DIENLSTR.Bits.IEN7
    
    #define ATD1DIENL_IEN0_MASK         1U
    #define ATD1DIENL_IEN1_MASK         2U
    #define ATD1DIENL_IEN2_MASK         4U
    #define ATD1DIENL_IEN3_MASK         8U
    #define ATD1DIENL_IEN4_MASK         16U
    #define ATD1DIENL_IEN5_MASK         32U
    #define ATD1DIENL_IEN6_MASK         64U
    #define ATD1DIENL_IEN7_MASK         128U
    
  } Overlap_STR;

  struct {
    word IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
    word IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
    word IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
    word IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
    word IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
    word IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
    word IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
    word IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
    word IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
    word IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
    word IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
    word IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
    word IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
    word IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
    word IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
    word IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
  } Bits;
} ATD1DIENSTR;
extern volatile ATD1DIENSTR _ATD1DIEN @(REG_BASE + 0x0000008CUL);
#define ATD1DIEN                        _ATD1DIEN.Word
#define ATD1DIEN_IEN0                   _ATD1DIEN.Bits.IEN0
#define ATD1DIEN_IEN1                   _ATD1DIEN.Bits.IEN1
#define ATD1DIEN_IEN2                   _ATD1DIEN.Bits.IEN2
#define ATD1DIEN_IEN3                   _ATD1DIEN.Bits.IEN3
#define ATD1DIEN_IEN4                   _ATD1DIEN.Bits.IEN4
#define ATD1DIEN_IEN5                   _ATD1DIEN.Bits.IEN5
#define ATD1DIEN_IEN6                   _ATD1DIEN.Bits.IEN6
#define ATD1DIEN_IEN7                   _ATD1DIEN.Bits.IEN7
#define ATD1DIEN_IEN8                   _ATD1DIEN.Bits.IEN8
#define ATD1DIEN_IEN9                   _ATD1DIEN.Bits.IEN9
#define ATD1DIEN_IEN10                  _ATD1DIEN.Bits.IEN10
#define ATD1DIEN_IEN11                  _ATD1DIEN.Bits.IEN11
#define ATD1DIEN_IEN12                  _ATD1DIEN.Bits.IEN12
#define ATD1DIEN_IEN13                  _ATD1DIEN.Bits.IEN13
#define ATD1DIEN_IEN14                  _ATD1DIEN.Bits.IEN14
#define ATD1DIEN_IEN15                  _ATD1DIEN.Bits.IEN15

#define ATD1DIEN_IEN0_MASK              1U
#define ATD1DIEN_IEN1_MASK              2U
#define ATD1DIEN_IEN2_MASK              4U
#define ATD1DIEN_IEN3_MASK              8U
#define ATD1DIEN_IEN4_MASK              16U
#define ATD1DIEN_IEN5_MASK              32U
#define ATD1DIEN_IEN6_MASK              64U
#define ATD1DIEN_IEN7_MASK              128U
#define ATD1DIEN_IEN8_MASK              256U
#define ATD1DIEN_IEN9_MASK              512U
#define ATD1DIEN_IEN10_MASK             1024U
#define ATD1DIEN_IEN11_MASK             2048U
#define ATD1DIEN_IEN12_MASK             4096U
#define ATD1DIEN_IEN13_MASK             8192U
#define ATD1DIEN_IEN14_MASK             16384U
#define ATD1DIEN_IEN15_MASK             32768U


/*** ATD1CMPHT - ATD 1 Compare Higher Than Register; 0x0000008E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CMPHTH - ATD 1 Compare Higher Than Register High; 0x0000008E ***/
    union {
      byte Byte;
      struct {
        byte CMPHT8      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 8 of a Sequence */
        byte CMPHT9      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 9 of a Sequence */
        byte CMPHT10     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 10 of a Sequence */
        byte CMPHT11     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 11 of a Sequence */
        byte CMPHT12     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 12 of a Sequence */
        byte CMPHT13     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 13 of a Sequence */
        byte CMPHT14     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 14 of a Sequence */
        byte CMPHT15     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 15 of a Sequence */
      } Bits;
    } ATD1CMPHTHSTR;
    #define ATD1CMPHTH                  _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Byte
    #define ATD1CMPHTH_CMPHT8           _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Bits.CMPHT8
    #define ATD1CMPHTH_CMPHT9           _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Bits.CMPHT9
    #define ATD1CMPHTH_CMPHT10          _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Bits.CMPHT10
    #define ATD1CMPHTH_CMPHT11          _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Bits.CMPHT11
    #define ATD1CMPHTH_CMPHT12          _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Bits.CMPHT12
    #define ATD1CMPHTH_CMPHT13          _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Bits.CMPHT13
    #define ATD1CMPHTH_CMPHT14          _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Bits.CMPHT14
    #define ATD1CMPHTH_CMPHT15          _ATD1CMPHT.Overlap_STR.ATD1CMPHTHSTR.Bits.CMPHT15
    
    #define ATD1CMPHTH_CMPHT8_MASK      1U
    #define ATD1CMPHTH_CMPHT9_MASK      2U
    #define ATD1CMPHTH_CMPHT10_MASK     4U
    #define ATD1CMPHTH_CMPHT11_MASK     8U
    #define ATD1CMPHTH_CMPHT12_MASK     16U
    #define ATD1CMPHTH_CMPHT13_MASK     32U
    #define ATD1CMPHTH_CMPHT14_MASK     64U
    #define ATD1CMPHTH_CMPHT15_MASK     128U
    

    /*** ATD1CMPHTL - ATD 1 Compare Higher Than Register Low; 0x0000008F ***/
    union {
      byte Byte;
      struct {
        byte CMPHT0      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence */
        byte CMPHT1      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence */
        byte CMPHT2      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence */
        byte CMPHT3      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence */
        byte CMPHT4      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence */
        byte CMPHT5      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence */
        byte CMPHT6      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence */
        byte CMPHT7      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence */
      } Bits;
    } ATD1CMPHTLSTR;
    #define ATD1CMPHTL                  _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Byte
    #define ATD1CMPHTL_CMPHT0           _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Bits.CMPHT0
    #define ATD1CMPHTL_CMPHT1           _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Bits.CMPHT1
    #define ATD1CMPHTL_CMPHT2           _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Bits.CMPHT2
    #define ATD1CMPHTL_CMPHT3           _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Bits.CMPHT3
    #define ATD1CMPHTL_CMPHT4           _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Bits.CMPHT4
    #define ATD1CMPHTL_CMPHT5           _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Bits.CMPHT5
    #define ATD1CMPHTL_CMPHT6           _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Bits.CMPHT6
    #define ATD1CMPHTL_CMPHT7           _ATD1CMPHT.Overlap_STR.ATD1CMPHTLSTR.Bits.CMPHT7
    
    #define ATD1CMPHTL_CMPHT0_MASK      1U
    #define ATD1CMPHTL_CMPHT1_MASK      2U
    #define ATD1CMPHTL_CMPHT2_MASK      4U
    #define ATD1CMPHTL_CMPHT3_MASK      8U
    #define ATD1CMPHTL_CMPHT4_MASK      16U
    #define ATD1CMPHTL_CMPHT5_MASK      32U
    #define ATD1CMPHTL_CMPHT6_MASK      64U
    #define ATD1CMPHTL_CMPHT7_MASK      128U
    
  } Overlap_STR;

  struct {
    word CMPHT0      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 0 of a Sequence */
    word CMPHT1      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 1 of a Sequence */
    word CMPHT2      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 2 of a Sequence */
    word CMPHT3      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 3 of a Sequence */
    word CMPHT4      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 4 of a Sequence */
    word CMPHT5      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 5 of a Sequence */
    word CMPHT6      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 6 of a Sequence */
    word CMPHT7      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 7 of a Sequence */
    word CMPHT8      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 8 of a Sequence */
    word CMPHT9      :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 9 of a Sequence */
    word CMPHT10     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 10 of a Sequence */
    word CMPHT11     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 11 of a Sequence */
    word CMPHT12     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 12 of a Sequence */
    word CMPHT13     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 13 of a Sequence */
    word CMPHT14     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 14 of a Sequence */
    word CMPHT15     :1;                                       /* Compare Operation Higher Than Enable for Conversion Number 15 of a Sequence */
  } Bits;
} ATD1CMPHTSTR;
extern volatile ATD1CMPHTSTR _ATD1CMPHT @(REG_BASE + 0x0000008EUL);
#define ATD1CMPHT                       _ATD1CMPHT.Word
#define ATD1CMPHT_CMPHT0                _ATD1CMPHT.Bits.CMPHT0
#define ATD1CMPHT_CMPHT1                _ATD1CMPHT.Bits.CMPHT1
#define ATD1CMPHT_CMPHT2                _ATD1CMPHT.Bits.CMPHT2
#define ATD1CMPHT_CMPHT3                _ATD1CMPHT.Bits.CMPHT3
#define ATD1CMPHT_CMPHT4                _ATD1CMPHT.Bits.CMPHT4
#define ATD1CMPHT_CMPHT5                _ATD1CMPHT.Bits.CMPHT5
#define ATD1CMPHT_CMPHT6                _ATD1CMPHT.Bits.CMPHT6
#define ATD1CMPHT_CMPHT7                _ATD1CMPHT.Bits.CMPHT7
#define ATD1CMPHT_CMPHT8                _ATD1CMPHT.Bits.CMPHT8
#define ATD1CMPHT_CMPHT9                _ATD1CMPHT.Bits.CMPHT9
#define ATD1CMPHT_CMPHT10               _ATD1CMPHT.Bits.CMPHT10
#define ATD1CMPHT_CMPHT11               _ATD1CMPHT.Bits.CMPHT11
#define ATD1CMPHT_CMPHT12               _ATD1CMPHT.Bits.CMPHT12
#define ATD1CMPHT_CMPHT13               _ATD1CMPHT.Bits.CMPHT13
#define ATD1CMPHT_CMPHT14               _ATD1CMPHT.Bits.CMPHT14
#define ATD1CMPHT_CMPHT15               _ATD1CMPHT.Bits.CMPHT15

#define ATD1CMPHT_CMPHT0_MASK           1U
#define ATD1CMPHT_CMPHT1_MASK           2U
#define ATD1CMPHT_CMPHT2_MASK           4U
#define ATD1CMPHT_CMPHT3_MASK           8U
#define ATD1CMPHT_CMPHT4_MASK           16U
#define ATD1CMPHT_CMPHT5_MASK           32U
#define ATD1CMPHT_CMPHT6_MASK           64U
#define ATD1CMPHT_CMPHT7_MASK           128U
#define ATD1CMPHT_CMPHT8_MASK           256U
#define ATD1CMPHT_CMPHT9_MASK           512U
#define ATD1CMPHT_CMPHT10_MASK          1024U
#define ATD1CMPHT_CMPHT11_MASK          2048U
#define ATD1CMPHT_CMPHT12_MASK          4096U
#define ATD1CMPHT_CMPHT13_MASK          8192U
#define ATD1CMPHT_CMPHT14_MASK          16384U
#define ATD1CMPHT_CMPHT15_MASK          32768U


/*** ATD1DR0 - ATD 1 Conversion Result Register 0; 0x00000090 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR0H - ATD 1 Conversion Result Register 0 High; 0x00000090 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR0HSTR;
    #define ATD1DR0H                    _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Byte
    #define ATD1DR0H_BIT8               _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT8
    #define ATD1DR0H_BIT9               _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT9
    #define ATD1DR0H_BIT10              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT10
    #define ATD1DR0H_BIT11              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT11
    #define ATD1DR0H_BIT12              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT12
    #define ATD1DR0H_BIT13              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT13
    #define ATD1DR0H_BIT14              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT14
    #define ATD1DR0H_BIT15              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT15
    
    #define ATD1DR0H_BIT8_MASK          1U
    #define ATD1DR0H_BIT9_MASK          2U
    #define ATD1DR0H_BIT10_MASK         4U
    #define ATD1DR0H_BIT11_MASK         8U
    #define ATD1DR0H_BIT12_MASK         16U
    #define ATD1DR0H_BIT13_MASK         32U
    #define ATD1DR0H_BIT14_MASK         64U
    #define ATD1DR0H_BIT15_MASK         128U
    

    /*** ATD1DR0L - ATD 1 Conversion Result Register 0 Low; 0x00000091 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR0LSTR;
    #define ATD1DR0L                    _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Byte
    #define ATD1DR0L_BIT0               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT0
    #define ATD1DR0L_BIT1               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT1
    #define ATD1DR0L_BIT2               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT2
    #define ATD1DR0L_BIT3               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT3
    #define ATD1DR0L_BIT4               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT4
    #define ATD1DR0L_BIT5               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT5
    #define ATD1DR0L_BIT6               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT6
    #define ATD1DR0L_BIT7               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT7
    
    #define ATD1DR0L_BIT0_MASK          1U
    #define ATD1DR0L_BIT1_MASK          2U
    #define ATD1DR0L_BIT2_MASK          4U
    #define ATD1DR0L_BIT3_MASK          8U
    #define ATD1DR0L_BIT4_MASK          16U
    #define ATD1DR0L_BIT5_MASK          32U
    #define ATD1DR0L_BIT6_MASK          64U
    #define ATD1DR0L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR0STR;
extern volatile ATD1DR0STR _ATD1DR0 @(REG_BASE + 0x00000090UL);
#define ATD1DR0                         _ATD1DR0.Word
#define ATD1DR0_BIT0                    _ATD1DR0.Bits.BIT0
#define ATD1DR0_BIT1                    _ATD1DR0.Bits.BIT1
#define ATD1DR0_BIT2                    _ATD1DR0.Bits.BIT2
#define ATD1DR0_BIT3                    _ATD1DR0.Bits.BIT3
#define ATD1DR0_BIT4                    _ATD1DR0.Bits.BIT4
#define ATD1DR0_BIT5                    _ATD1DR0.Bits.BIT5
#define ATD1DR0_BIT6                    _ATD1DR0.Bits.BIT6
#define ATD1DR0_BIT7                    _ATD1DR0.Bits.BIT7
#define ATD1DR0_BIT8                    _ATD1DR0.Bits.BIT8
#define ATD1DR0_BIT9                    _ATD1DR0.Bits.BIT9
#define ATD1DR0_BIT10                   _ATD1DR0.Bits.BIT10
#define ATD1DR0_BIT11                   _ATD1DR0.Bits.BIT11
#define ATD1DR0_BIT12                   _ATD1DR0.Bits.BIT12
#define ATD1DR0_BIT13                   _ATD1DR0.Bits.BIT13
#define ATD1DR0_BIT14                   _ATD1DR0.Bits.BIT14
#define ATD1DR0_BIT15                   _ATD1DR0.Bits.BIT15
/* ATD1DR_ARR: Access 16 ATD1DRx registers in an array */
#define ATD1DR_ARR                      ((volatile word *) &ATD1DR0)

#define ATD1DR0_BIT0_MASK               1U
#define ATD1DR0_BIT1_MASK               2U
#define ATD1DR0_BIT2_MASK               4U
#define ATD1DR0_BIT3_MASK               8U
#define ATD1DR0_BIT4_MASK               16U
#define ATD1DR0_BIT5_MASK               32U
#define ATD1DR0_BIT6_MASK               64U
#define ATD1DR0_BIT7_MASK               128U
#define ATD1DR0_BIT8_MASK               256U
#define ATD1DR0_BIT9_MASK               512U
#define ATD1DR0_BIT10_MASK              1024U
#define ATD1DR0_BIT11_MASK              2048U
#define ATD1DR0_BIT12_MASK              4096U
#define ATD1DR0_BIT13_MASK              8192U
#define ATD1DR0_BIT14_MASK              16384U
#define ATD1DR0_BIT15_MASK              32768U


/*** ATD1DR1 - ATD 1 Conversion Result Register 1; 0x00000092 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR1H - ATD 1 Conversion Result Register 1 High; 0x00000092 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR1HSTR;
    #define ATD1DR1H                    _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Byte
    #define ATD1DR1H_BIT8               _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT8
    #define ATD1DR1H_BIT9               _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT9
    #define ATD1DR1H_BIT10              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT10
    #define ATD1DR1H_BIT11              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT11
    #define ATD1DR1H_BIT12              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT12
    #define ATD1DR1H_BIT13              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT13
    #define ATD1DR1H_BIT14              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT14
    #define ATD1DR1H_BIT15              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT15
    
    #define ATD1DR1H_BIT8_MASK          1U
    #define ATD1DR1H_BIT9_MASK          2U
    #define ATD1DR1H_BIT10_MASK         4U
    #define ATD1DR1H_BIT11_MASK         8U
    #define ATD1DR1H_BIT12_MASK         16U
    #define ATD1DR1H_BIT13_MASK         32U
    #define ATD1DR1H_BIT14_MASK         64U
    #define ATD1DR1H_BIT15_MASK         128U
    

    /*** ATD1DR1L - ATD 1 Conversion Result Register 1 Low; 0x00000093 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR1LSTR;
    #define ATD1DR1L                    _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Byte
    #define ATD1DR1L_BIT0               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT0
    #define ATD1DR1L_BIT1               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT1
    #define ATD1DR1L_BIT2               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT2
    #define ATD1DR1L_BIT3               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT3
    #define ATD1DR1L_BIT4               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT4
    #define ATD1DR1L_BIT5               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT5
    #define ATD1DR1L_BIT6               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT6
    #define ATD1DR1L_BIT7               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT7
    
    #define ATD1DR1L_BIT0_MASK          1U
    #define ATD1DR1L_BIT1_MASK          2U
    #define ATD1DR1L_BIT2_MASK          4U
    #define ATD1DR1L_BIT3_MASK          8U
    #define ATD1DR1L_BIT4_MASK          16U
    #define ATD1DR1L_BIT5_MASK          32U
    #define ATD1DR1L_BIT6_MASK          64U
    #define ATD1DR1L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR1STR;
extern volatile ATD1DR1STR _ATD1DR1 @(REG_BASE + 0x00000092UL);
#define ATD1DR1                         _ATD1DR1.Word
#define ATD1DR1_BIT0                    _ATD1DR1.Bits.BIT0
#define ATD1DR1_BIT1                    _ATD1DR1.Bits.BIT1
#define ATD1DR1_BIT2                    _ATD1DR1.Bits.BIT2
#define ATD1DR1_BIT3                    _ATD1DR1.Bits.BIT3
#define ATD1DR1_BIT4                    _ATD1DR1.Bits.BIT4
#define ATD1DR1_BIT5                    _ATD1DR1.Bits.BIT5
#define ATD1DR1_BIT6                    _ATD1DR1.Bits.BIT6
#define ATD1DR1_BIT7                    _ATD1DR1.Bits.BIT7
#define ATD1DR1_BIT8                    _ATD1DR1.Bits.BIT8
#define ATD1DR1_BIT9                    _ATD1DR1.Bits.BIT9
#define ATD1DR1_BIT10                   _ATD1DR1.Bits.BIT10
#define ATD1DR1_BIT11                   _ATD1DR1.Bits.BIT11
#define ATD1DR1_BIT12                   _ATD1DR1.Bits.BIT12
#define ATD1DR1_BIT13                   _ATD1DR1.Bits.BIT13
#define ATD1DR1_BIT14                   _ATD1DR1.Bits.BIT14
#define ATD1DR1_BIT15                   _ATD1DR1.Bits.BIT15

#define ATD1DR1_BIT0_MASK               1U
#define ATD1DR1_BIT1_MASK               2U
#define ATD1DR1_BIT2_MASK               4U
#define ATD1DR1_BIT3_MASK               8U
#define ATD1DR1_BIT4_MASK               16U
#define ATD1DR1_BIT5_MASK               32U
#define ATD1DR1_BIT6_MASK               64U
#define ATD1DR1_BIT7_MASK               128U
#define ATD1DR1_BIT8_MASK               256U
#define ATD1DR1_BIT9_MASK               512U
#define ATD1DR1_BIT10_MASK              1024U
#define ATD1DR1_BIT11_MASK              2048U
#define ATD1DR1_BIT12_MASK              4096U
#define ATD1DR1_BIT13_MASK              8192U
#define ATD1DR1_BIT14_MASK              16384U
#define ATD1DR1_BIT15_MASK              32768U


/*** ATD1DR2 - ATD 1 Conversion Result Register 2; 0x00000094 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR2H - ATD 1 Conversion Result Register 2 High; 0x00000094 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR2HSTR;
    #define ATD1DR2H                    _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Byte
    #define ATD1DR2H_BIT8               _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT8
    #define ATD1DR2H_BIT9               _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT9
    #define ATD1DR2H_BIT10              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT10
    #define ATD1DR2H_BIT11              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT11
    #define ATD1DR2H_BIT12              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT12
    #define ATD1DR2H_BIT13              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT13
    #define ATD1DR2H_BIT14              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT14
    #define ATD1DR2H_BIT15              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT15
    
    #define ATD1DR2H_BIT8_MASK          1U
    #define ATD1DR2H_BIT9_MASK          2U
    #define ATD1DR2H_BIT10_MASK         4U
    #define ATD1DR2H_BIT11_MASK         8U
    #define ATD1DR2H_BIT12_MASK         16U
    #define ATD1DR2H_BIT13_MASK         32U
    #define ATD1DR2H_BIT14_MASK         64U
    #define ATD1DR2H_BIT15_MASK         128U
    

    /*** ATD1DR2L - ATD 1 Conversion Result Register 2 Low; 0x00000095 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR2LSTR;
    #define ATD1DR2L                    _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Byte
    #define ATD1DR2L_BIT0               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT0
    #define ATD1DR2L_BIT1               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT1
    #define ATD1DR2L_BIT2               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT2
    #define ATD1DR2L_BIT3               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT3
    #define ATD1DR2L_BIT4               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT4
    #define ATD1DR2L_BIT5               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT5
    #define ATD1DR2L_BIT6               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT6
    #define ATD1DR2L_BIT7               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT7
    
    #define ATD1DR2L_BIT0_MASK          1U
    #define ATD1DR2L_BIT1_MASK          2U
    #define ATD1DR2L_BIT2_MASK          4U
    #define ATD1DR2L_BIT3_MASK          8U
    #define ATD1DR2L_BIT4_MASK          16U
    #define ATD1DR2L_BIT5_MASK          32U
    #define ATD1DR2L_BIT6_MASK          64U
    #define ATD1DR2L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR2STR;
extern volatile ATD1DR2STR _ATD1DR2 @(REG_BASE + 0x00000094UL);
#define ATD1DR2                         _ATD1DR2.Word
#define ATD1DR2_BIT0                    _ATD1DR2.Bits.BIT0
#define ATD1DR2_BIT1                    _ATD1DR2.Bits.BIT1
#define ATD1DR2_BIT2                    _ATD1DR2.Bits.BIT2
#define ATD1DR2_BIT3                    _ATD1DR2.Bits.BIT3
#define ATD1DR2_BIT4                    _ATD1DR2.Bits.BIT4
#define ATD1DR2_BIT5                    _ATD1DR2.Bits.BIT5
#define ATD1DR2_BIT6                    _ATD1DR2.Bits.BIT6
#define ATD1DR2_BIT7                    _ATD1DR2.Bits.BIT7
#define ATD1DR2_BIT8                    _ATD1DR2.Bits.BIT8
#define ATD1DR2_BIT9                    _ATD1DR2.Bits.BIT9
#define ATD1DR2_BIT10                   _ATD1DR2.Bits.BIT10
#define ATD1DR2_BIT11                   _ATD1DR2.Bits.BIT11
#define ATD1DR2_BIT12                   _ATD1DR2.Bits.BIT12
#define ATD1DR2_BIT13                   _ATD1DR2.Bits.BIT13
#define ATD1DR2_BIT14                   _ATD1DR2.Bits.BIT14
#define ATD1DR2_BIT15                   _ATD1DR2.Bits.BIT15

#define ATD1DR2_BIT0_MASK               1U
#define ATD1DR2_BIT1_MASK               2U
#define ATD1DR2_BIT2_MASK               4U
#define ATD1DR2_BIT3_MASK               8U
#define ATD1DR2_BIT4_MASK               16U
#define ATD1DR2_BIT5_MASK               32U
#define ATD1DR2_BIT6_MASK               64U
#define ATD1DR2_BIT7_MASK               128U
#define ATD1DR2_BIT8_MASK               256U
#define ATD1DR2_BIT9_MASK               512U
#define ATD1DR2_BIT10_MASK              1024U
#define ATD1DR2_BIT11_MASK              2048U
#define ATD1DR2_BIT12_MASK              4096U
#define ATD1DR2_BIT13_MASK              8192U
#define ATD1DR2_BIT14_MASK              16384U
#define ATD1DR2_BIT15_MASK              32768U


/*** ATD1DR3 - ATD 1 Conversion Result Register 3; 0x00000096 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR3H - ATD 1 Conversion Result Register 3 High; 0x00000096 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR3HSTR;
    #define ATD1DR3H                    _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Byte
    #define ATD1DR3H_BIT8               _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT8
    #define ATD1DR3H_BIT9               _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT9
    #define ATD1DR3H_BIT10              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT10
    #define ATD1DR3H_BIT11              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT11
    #define ATD1DR3H_BIT12              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT12
    #define ATD1DR3H_BIT13              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT13
    #define ATD1DR3H_BIT14              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT14
    #define ATD1DR3H_BIT15              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT15
    
    #define ATD1DR3H_BIT8_MASK          1U
    #define ATD1DR3H_BIT9_MASK          2U
    #define ATD1DR3H_BIT10_MASK         4U
    #define ATD1DR3H_BIT11_MASK         8U
    #define ATD1DR3H_BIT12_MASK         16U
    #define ATD1DR3H_BIT13_MASK         32U
    #define ATD1DR3H_BIT14_MASK         64U
    #define ATD1DR3H_BIT15_MASK         128U
    

    /*** ATD1DR3L - ATD 1 Conversion Result Register 3 Low; 0x00000097 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR3LSTR;
    #define ATD1DR3L                    _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Byte
    #define ATD1DR3L_BIT0               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT0
    #define ATD1DR3L_BIT1               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT1
    #define ATD1DR3L_BIT2               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT2
    #define ATD1DR3L_BIT3               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT3
    #define ATD1DR3L_BIT4               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT4
    #define ATD1DR3L_BIT5               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT5
    #define ATD1DR3L_BIT6               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT6
    #define ATD1DR3L_BIT7               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT7
    
    #define ATD1DR3L_BIT0_MASK          1U
    #define ATD1DR3L_BIT1_MASK          2U
    #define ATD1DR3L_BIT2_MASK          4U
    #define ATD1DR3L_BIT3_MASK          8U
    #define ATD1DR3L_BIT4_MASK          16U
    #define ATD1DR3L_BIT5_MASK          32U
    #define ATD1DR3L_BIT6_MASK          64U
    #define ATD1DR3L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR3STR;
extern volatile ATD1DR3STR _ATD1DR3 @(REG_BASE + 0x00000096UL);
#define ATD1DR3                         _ATD1DR3.Word
#define ATD1DR3_BIT0                    _ATD1DR3.Bits.BIT0
#define ATD1DR3_BIT1                    _ATD1DR3.Bits.BIT1
#define ATD1DR3_BIT2                    _ATD1DR3.Bits.BIT2
#define ATD1DR3_BIT3                    _ATD1DR3.Bits.BIT3
#define ATD1DR3_BIT4                    _ATD1DR3.Bits.BIT4
#define ATD1DR3_BIT5                    _ATD1DR3.Bits.BIT5
#define ATD1DR3_BIT6                    _ATD1DR3.Bits.BIT6
#define ATD1DR3_BIT7                    _ATD1DR3.Bits.BIT7
#define ATD1DR3_BIT8                    _ATD1DR3.Bits.BIT8
#define ATD1DR3_BIT9                    _ATD1DR3.Bits.BIT9
#define ATD1DR3_BIT10                   _ATD1DR3.Bits.BIT10
#define ATD1DR3_BIT11                   _ATD1DR3.Bits.BIT11
#define ATD1DR3_BIT12                   _ATD1DR3.Bits.BIT12
#define ATD1DR3_BIT13                   _ATD1DR3.Bits.BIT13
#define ATD1DR3_BIT14                   _ATD1DR3.Bits.BIT14
#define ATD1DR3_BIT15                   _ATD1DR3.Bits.BIT15

#define ATD1DR3_BIT0_MASK               1U
#define ATD1DR3_BIT1_MASK               2U
#define ATD1DR3_BIT2_MASK               4U
#define ATD1DR3_BIT3_MASK               8U
#define ATD1DR3_BIT4_MASK               16U
#define ATD1DR3_BIT5_MASK               32U
#define ATD1DR3_BIT6_MASK               64U
#define ATD1DR3_BIT7_MASK               128U
#define ATD1DR3_BIT8_MASK               256U
#define ATD1DR3_BIT9_MASK               512U
#define ATD1DR3_BIT10_MASK              1024U
#define ATD1DR3_BIT11_MASK              2048U
#define ATD1DR3_BIT12_MASK              4096U
#define ATD1DR3_BIT13_MASK              8192U
#define ATD1DR3_BIT14_MASK              16384U
#define ATD1DR3_BIT15_MASK              32768U


/*** ATD1DR4 - ATD 1 Conversion Result Register 4; 0x00000098 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR4H - ATD 1 Conversion Result Register 4 High; 0x00000098 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR4HSTR;
    #define ATD1DR4H                    _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Byte
    #define ATD1DR4H_BIT8               _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT8
    #define ATD1DR4H_BIT9               _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT9
    #define ATD1DR4H_BIT10              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT10
    #define ATD1DR4H_BIT11              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT11
    #define ATD1DR4H_BIT12              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT12
    #define ATD1DR4H_BIT13              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT13
    #define ATD1DR4H_BIT14              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT14
    #define ATD1DR4H_BIT15              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT15
    
    #define ATD1DR4H_BIT8_MASK          1U
    #define ATD1DR4H_BIT9_MASK          2U
    #define ATD1DR4H_BIT10_MASK         4U
    #define ATD1DR4H_BIT11_MASK         8U
    #define ATD1DR4H_BIT12_MASK         16U
    #define ATD1DR4H_BIT13_MASK         32U
    #define ATD1DR4H_BIT14_MASK         64U
    #define ATD1DR4H_BIT15_MASK         128U
    

    /*** ATD1DR4L - ATD 1 Conversion Result Register 4 Low; 0x00000099 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR4LSTR;
    #define ATD1DR4L                    _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Byte
    #define ATD1DR4L_BIT0               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT0
    #define ATD1DR4L_BIT1               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT1
    #define ATD1DR4L_BIT2               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT2
    #define ATD1DR4L_BIT3               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT3
    #define ATD1DR4L_BIT4               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT4
    #define ATD1DR4L_BIT5               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT5
    #define ATD1DR4L_BIT6               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT6
    #define ATD1DR4L_BIT7               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT7
    
    #define ATD1DR4L_BIT0_MASK          1U
    #define ATD1DR4L_BIT1_MASK          2U
    #define ATD1DR4L_BIT2_MASK          4U
    #define ATD1DR4L_BIT3_MASK          8U
    #define ATD1DR4L_BIT4_MASK          16U
    #define ATD1DR4L_BIT5_MASK          32U
    #define ATD1DR4L_BIT6_MASK          64U
    #define ATD1DR4L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR4STR;
extern volatile ATD1DR4STR _ATD1DR4 @(REG_BASE + 0x00000098UL);
#define ATD1DR4                         _ATD1DR4.Word
#define ATD1DR4_BIT0                    _ATD1DR4.Bits.BIT0
#define ATD1DR4_BIT1                    _ATD1DR4.Bits.BIT1
#define ATD1DR4_BIT2                    _ATD1DR4.Bits.BIT2
#define ATD1DR4_BIT3                    _ATD1DR4.Bits.BIT3
#define ATD1DR4_BIT4                    _ATD1DR4.Bits.BIT4
#define ATD1DR4_BIT5                    _ATD1DR4.Bits.BIT5
#define ATD1DR4_BIT6                    _ATD1DR4.Bits.BIT6
#define ATD1DR4_BIT7                    _ATD1DR4.Bits.BIT7
#define ATD1DR4_BIT8                    _ATD1DR4.Bits.BIT8
#define ATD1DR4_BIT9                    _ATD1DR4.Bits.BIT9
#define ATD1DR4_BIT10                   _ATD1DR4.Bits.BIT10
#define ATD1DR4_BIT11                   _ATD1DR4.Bits.BIT11
#define ATD1DR4_BIT12                   _ATD1DR4.Bits.BIT12
#define ATD1DR4_BIT13                   _ATD1DR4.Bits.BIT13
#define ATD1DR4_BIT14                   _ATD1DR4.Bits.BIT14
#define ATD1DR4_BIT15                   _ATD1DR4.Bits.BIT15

#define ATD1DR4_BIT0_MASK               1U
#define ATD1DR4_BIT1_MASK               2U
#define ATD1DR4_BIT2_MASK               4U
#define ATD1DR4_BIT3_MASK               8U
#define ATD1DR4_BIT4_MASK               16U
#define ATD1DR4_BIT5_MASK               32U
#define ATD1DR4_BIT6_MASK               64U
#define ATD1DR4_BIT7_MASK               128U
#define ATD1DR4_BIT8_MASK               256U
#define ATD1DR4_BIT9_MASK               512U
#define ATD1DR4_BIT10_MASK              1024U
#define ATD1DR4_BIT11_MASK              2048U
#define ATD1DR4_BIT12_MASK              4096U
#define ATD1DR4_BIT13_MASK              8192U
#define ATD1DR4_BIT14_MASK              16384U
#define ATD1DR4_BIT15_MASK              32768U


/*** ATD1DR5 - ATD 1 Conversion Result Register 5; 0x0000009A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR5H - ATD 1 Conversion Result Register 5 High; 0x0000009A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR5HSTR;
    #define ATD1DR5H                    _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Byte
    #define ATD1DR5H_BIT8               _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT8
    #define ATD1DR5H_BIT9               _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT9
    #define ATD1DR5H_BIT10              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT10
    #define ATD1DR5H_BIT11              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT11
    #define ATD1DR5H_BIT12              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT12
    #define ATD1DR5H_BIT13              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT13
    #define ATD1DR5H_BIT14              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT14
    #define ATD1DR5H_BIT15              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT15
    
    #define ATD1DR5H_BIT8_MASK          1U
    #define ATD1DR5H_BIT9_MASK          2U
    #define ATD1DR5H_BIT10_MASK         4U
    #define ATD1DR5H_BIT11_MASK         8U
    #define ATD1DR5H_BIT12_MASK         16U
    #define ATD1DR5H_BIT13_MASK         32U
    #define ATD1DR5H_BIT14_MASK         64U
    #define ATD1DR5H_BIT15_MASK         128U
    

    /*** ATD1DR5L - ATD 1 Conversion Result Register 5 Low; 0x0000009B ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR5LSTR;
    #define ATD1DR5L                    _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Byte
    #define ATD1DR5L_BIT0               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT0
    #define ATD1DR5L_BIT1               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT1
    #define ATD1DR5L_BIT2               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT2
    #define ATD1DR5L_BIT3               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT3
    #define ATD1DR5L_BIT4               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT4
    #define ATD1DR5L_BIT5               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT5
    #define ATD1DR5L_BIT6               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT6
    #define ATD1DR5L_BIT7               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT7
    
    #define ATD1DR5L_BIT0_MASK          1U
    #define ATD1DR5L_BIT1_MASK          2U
    #define ATD1DR5L_BIT2_MASK          4U
    #define ATD1DR5L_BIT3_MASK          8U
    #define ATD1DR5L_BIT4_MASK          16U
    #define ATD1DR5L_BIT5_MASK          32U
    #define ATD1DR5L_BIT6_MASK          64U
    #define ATD1DR5L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR5STR;
extern volatile ATD1DR5STR _ATD1DR5 @(REG_BASE + 0x0000009AUL);
#define ATD1DR5                         _ATD1DR5.Word
#define ATD1DR5_BIT0                    _ATD1DR5.Bits.BIT0
#define ATD1DR5_BIT1                    _ATD1DR5.Bits.BIT1
#define ATD1DR5_BIT2                    _ATD1DR5.Bits.BIT2
#define ATD1DR5_BIT3                    _ATD1DR5.Bits.BIT3
#define ATD1DR5_BIT4                    _ATD1DR5.Bits.BIT4
#define ATD1DR5_BIT5                    _ATD1DR5.Bits.BIT5
#define ATD1DR5_BIT6                    _ATD1DR5.Bits.BIT6
#define ATD1DR5_BIT7                    _ATD1DR5.Bits.BIT7
#define ATD1DR5_BIT8                    _ATD1DR5.Bits.BIT8
#define ATD1DR5_BIT9                    _ATD1DR5.Bits.BIT9
#define ATD1DR5_BIT10                   _ATD1DR5.Bits.BIT10
#define ATD1DR5_BIT11                   _ATD1DR5.Bits.BIT11
#define ATD1DR5_BIT12                   _ATD1DR5.Bits.BIT12
#define ATD1DR5_BIT13                   _ATD1DR5.Bits.BIT13
#define ATD1DR5_BIT14                   _ATD1DR5.Bits.BIT14
#define ATD1DR5_BIT15                   _ATD1DR5.Bits.BIT15

#define ATD1DR5_BIT0_MASK               1U
#define ATD1DR5_BIT1_MASK               2U
#define ATD1DR5_BIT2_MASK               4U
#define ATD1DR5_BIT3_MASK               8U
#define ATD1DR5_BIT4_MASK               16U
#define ATD1DR5_BIT5_MASK               32U
#define ATD1DR5_BIT6_MASK               64U
#define ATD1DR5_BIT7_MASK               128U
#define ATD1DR5_BIT8_MASK               256U
#define ATD1DR5_BIT9_MASK               512U
#define ATD1DR5_BIT10_MASK              1024U
#define ATD1DR5_BIT11_MASK              2048U
#define ATD1DR5_BIT12_MASK              4096U
#define ATD1DR5_BIT13_MASK              8192U
#define ATD1DR5_BIT14_MASK              16384U
#define ATD1DR5_BIT15_MASK              32768U


/*** ATD1DR6 - ATD 1 Conversion Result Register 6; 0x0000009C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR6H - ATD 1 Conversion Result Register 6 High; 0x0000009C ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR6HSTR;
    #define ATD1DR6H                    _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Byte
    #define ATD1DR6H_BIT8               _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT8
    #define ATD1DR6H_BIT9               _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT9
    #define ATD1DR6H_BIT10              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT10
    #define ATD1DR6H_BIT11              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT11
    #define ATD1DR6H_BIT12              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT12
    #define ATD1DR6H_BIT13              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT13
    #define ATD1DR6H_BIT14              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT14
    #define ATD1DR6H_BIT15              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT15
    
    #define ATD1DR6H_BIT8_MASK          1U
    #define ATD1DR6H_BIT9_MASK          2U
    #define ATD1DR6H_BIT10_MASK         4U
    #define ATD1DR6H_BIT11_MASK         8U
    #define ATD1DR6H_BIT12_MASK         16U
    #define ATD1DR6H_BIT13_MASK         32U
    #define ATD1DR6H_BIT14_MASK         64U
    #define ATD1DR6H_BIT15_MASK         128U
    

    /*** ATD1DR6L - ATD 1 Conversion Result Register 6 Low; 0x0000009D ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR6LSTR;
    #define ATD1DR6L                    _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Byte
    #define ATD1DR6L_BIT0               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT0
    #define ATD1DR6L_BIT1               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT1
    #define ATD1DR6L_BIT2               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT2
    #define ATD1DR6L_BIT3               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT3
    #define ATD1DR6L_BIT4               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT4
    #define ATD1DR6L_BIT5               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT5
    #define ATD1DR6L_BIT6               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT6
    #define ATD1DR6L_BIT7               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT7
    
    #define ATD1DR6L_BIT0_MASK          1U
    #define ATD1DR6L_BIT1_MASK          2U
    #define ATD1DR6L_BIT2_MASK          4U
    #define ATD1DR6L_BIT3_MASK          8U
    #define ATD1DR6L_BIT4_MASK          16U
    #define ATD1DR6L_BIT5_MASK          32U
    #define ATD1DR6L_BIT6_MASK          64U
    #define ATD1DR6L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR6STR;
extern volatile ATD1DR6STR _ATD1DR6 @(REG_BASE + 0x0000009CUL);
#define ATD1DR6                         _ATD1DR6.Word
#define ATD1DR6_BIT0                    _ATD1DR6.Bits.BIT0
#define ATD1DR6_BIT1                    _ATD1DR6.Bits.BIT1
#define ATD1DR6_BIT2                    _ATD1DR6.Bits.BIT2
#define ATD1DR6_BIT3                    _ATD1DR6.Bits.BIT3
#define ATD1DR6_BIT4                    _ATD1DR6.Bits.BIT4
#define ATD1DR6_BIT5                    _ATD1DR6.Bits.BIT5
#define ATD1DR6_BIT6                    _ATD1DR6.Bits.BIT6
#define ATD1DR6_BIT7                    _ATD1DR6.Bits.BIT7
#define ATD1DR6_BIT8                    _ATD1DR6.Bits.BIT8
#define ATD1DR6_BIT9                    _ATD1DR6.Bits.BIT9
#define ATD1DR6_BIT10                   _ATD1DR6.Bits.BIT10
#define ATD1DR6_BIT11                   _ATD1DR6.Bits.BIT11
#define ATD1DR6_BIT12                   _ATD1DR6.Bits.BIT12
#define ATD1DR6_BIT13                   _ATD1DR6.Bits.BIT13
#define ATD1DR6_BIT14                   _ATD1DR6.Bits.BIT14
#define ATD1DR6_BIT15                   _ATD1DR6.Bits.BIT15

#define ATD1DR6_BIT0_MASK               1U
#define ATD1DR6_BIT1_MASK               2U
#define ATD1DR6_BIT2_MASK               4U
#define ATD1DR6_BIT3_MASK               8U
#define ATD1DR6_BIT4_MASK               16U
#define ATD1DR6_BIT5_MASK               32U
#define ATD1DR6_BIT6_MASK               64U
#define ATD1DR6_BIT7_MASK               128U
#define ATD1DR6_BIT8_MASK               256U
#define ATD1DR6_BIT9_MASK               512U
#define ATD1DR6_BIT10_MASK              1024U
#define ATD1DR6_BIT11_MASK              2048U
#define ATD1DR6_BIT12_MASK              4096U
#define ATD1DR6_BIT13_MASK              8192U
#define ATD1DR6_BIT14_MASK              16384U
#define ATD1DR6_BIT15_MASK              32768U


/*** ATD1DR7 - ATD 1 Conversion Result Register 7; 0x0000009E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR7H - ATD 1 Conversion Result Register 7 High; 0x0000009E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR7HSTR;
    #define ATD1DR7H                    _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Byte
    #define ATD1DR7H_BIT8               _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT8
    #define ATD1DR7H_BIT9               _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT9
    #define ATD1DR7H_BIT10              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT10
    #define ATD1DR7H_BIT11              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT11
    #define ATD1DR7H_BIT12              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT12
    #define ATD1DR7H_BIT13              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT13
    #define ATD1DR7H_BIT14              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT14
    #define ATD1DR7H_BIT15              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT15
    
    #define ATD1DR7H_BIT8_MASK          1U
    #define ATD1DR7H_BIT9_MASK          2U
    #define ATD1DR7H_BIT10_MASK         4U
    #define ATD1DR7H_BIT11_MASK         8U
    #define ATD1DR7H_BIT12_MASK         16U
    #define ATD1DR7H_BIT13_MASK         32U
    #define ATD1DR7H_BIT14_MASK         64U
    #define ATD1DR7H_BIT15_MASK         128U
    

    /*** ATD1DR7L - ATD 1 Conversion Result Register 7 Low; 0x0000009F ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR7LSTR;
    #define ATD1DR7L                    _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Byte
    #define ATD1DR7L_BIT0               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT0
    #define ATD1DR7L_BIT1               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT1
    #define ATD1DR7L_BIT2               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT2
    #define ATD1DR7L_BIT3               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT3
    #define ATD1DR7L_BIT4               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT4
    #define ATD1DR7L_BIT5               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT5
    #define ATD1DR7L_BIT6               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT6
    #define ATD1DR7L_BIT7               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT7
    
    #define ATD1DR7L_BIT0_MASK          1U
    #define ATD1DR7L_BIT1_MASK          2U
    #define ATD1DR7L_BIT2_MASK          4U
    #define ATD1DR7L_BIT3_MASK          8U
    #define ATD1DR7L_BIT4_MASK          16U
    #define ATD1DR7L_BIT5_MASK          32U
    #define ATD1DR7L_BIT6_MASK          64U
    #define ATD1DR7L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR7STR;
extern volatile ATD1DR7STR _ATD1DR7 @(REG_BASE + 0x0000009EUL);
#define ATD1DR7                         _ATD1DR7.Word
#define ATD1DR7_BIT0                    _ATD1DR7.Bits.BIT0
#define ATD1DR7_BIT1                    _ATD1DR7.Bits.BIT1
#define ATD1DR7_BIT2                    _ATD1DR7.Bits.BIT2
#define ATD1DR7_BIT3                    _ATD1DR7.Bits.BIT3
#define ATD1DR7_BIT4                    _ATD1DR7.Bits.BIT4
#define ATD1DR7_BIT5                    _ATD1DR7.Bits.BIT5
#define ATD1DR7_BIT6                    _ATD1DR7.Bits.BIT6
#define ATD1DR7_BIT7                    _ATD1DR7.Bits.BIT7
#define ATD1DR7_BIT8                    _ATD1DR7.Bits.BIT8
#define ATD1DR7_BIT9                    _ATD1DR7.Bits.BIT9
#define ATD1DR7_BIT10                   _ATD1DR7.Bits.BIT10
#define ATD1DR7_BIT11                   _ATD1DR7.Bits.BIT11
#define ATD1DR7_BIT12                   _ATD1DR7.Bits.BIT12
#define ATD1DR7_BIT13                   _ATD1DR7.Bits.BIT13
#define ATD1DR7_BIT14                   _ATD1DR7.Bits.BIT14
#define ATD1DR7_BIT15                   _ATD1DR7.Bits.BIT15

#define ATD1DR7_BIT0_MASK               1U
#define ATD1DR7_BIT1_MASK               2U
#define ATD1DR7_BIT2_MASK               4U
#define ATD1DR7_BIT3_MASK               8U
#define ATD1DR7_BIT4_MASK               16U
#define ATD1DR7_BIT5_MASK               32U
#define ATD1DR7_BIT6_MASK               64U
#define ATD1DR7_BIT7_MASK               128U
#define ATD1DR7_BIT8_MASK               256U
#define ATD1DR7_BIT9_MASK               512U
#define ATD1DR7_BIT10_MASK              1024U
#define ATD1DR7_BIT11_MASK              2048U
#define ATD1DR7_BIT12_MASK              4096U
#define ATD1DR7_BIT13_MASK              8192U
#define ATD1DR7_BIT14_MASK              16384U
#define ATD1DR7_BIT15_MASK              32768U


/*** ATD1DR8 - ATD 1 Conversion Result Register 8; 0x000000A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR8H - ATD 1 Conversion Result Register 8 High; 0x000000A0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR8HSTR;
    #define ATD1DR8H                    _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Byte
    #define ATD1DR8H_BIT8               _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT8
    #define ATD1DR8H_BIT9               _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT9
    #define ATD1DR8H_BIT10              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT10
    #define ATD1DR8H_BIT11              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT11
    #define ATD1DR8H_BIT12              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT12
    #define ATD1DR8H_BIT13              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT13
    #define ATD1DR8H_BIT14              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT14
    #define ATD1DR8H_BIT15              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT15
    
    #define ATD1DR8H_BIT8_MASK          1U
    #define ATD1DR8H_BIT9_MASK          2U
    #define ATD1DR8H_BIT10_MASK         4U
    #define ATD1DR8H_BIT11_MASK         8U
    #define ATD1DR8H_BIT12_MASK         16U
    #define ATD1DR8H_BIT13_MASK         32U
    #define ATD1DR8H_BIT14_MASK         64U
    #define ATD1DR8H_BIT15_MASK         128U
    

    /*** ATD1DR8L - ATD 1 Conversion Result Register 8 Low; 0x000000A1 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR8LSTR;
    #define ATD1DR8L                    _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Byte
    #define ATD1DR8L_BIT0               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT0
    #define ATD1DR8L_BIT1               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT1
    #define ATD1DR8L_BIT2               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT2
    #define ATD1DR8L_BIT3               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT3
    #define ATD1DR8L_BIT4               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT4
    #define ATD1DR8L_BIT5               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT5
    #define ATD1DR8L_BIT6               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT6
    #define ATD1DR8L_BIT7               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT7
    
    #define ATD1DR8L_BIT0_MASK          1U
    #define ATD1DR8L_BIT1_MASK          2U
    #define ATD1DR8L_BIT2_MASK          4U
    #define ATD1DR8L_BIT3_MASK          8U
    #define ATD1DR8L_BIT4_MASK          16U
    #define ATD1DR8L_BIT5_MASK          32U
    #define ATD1DR8L_BIT6_MASK          64U
    #define ATD1DR8L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR8STR;
extern volatile ATD1DR8STR _ATD1DR8 @(REG_BASE + 0x000000A0UL);
#define ATD1DR8                         _ATD1DR8.Word
#define ATD1DR8_BIT0                    _ATD1DR8.Bits.BIT0
#define ATD1DR8_BIT1                    _ATD1DR8.Bits.BIT1
#define ATD1DR8_BIT2                    _ATD1DR8.Bits.BIT2
#define ATD1DR8_BIT3                    _ATD1DR8.Bits.BIT3
#define ATD1DR8_BIT4                    _ATD1DR8.Bits.BIT4
#define ATD1DR8_BIT5                    _ATD1DR8.Bits.BIT5
#define ATD1DR8_BIT6                    _ATD1DR8.Bits.BIT6
#define ATD1DR8_BIT7                    _ATD1DR8.Bits.BIT7
#define ATD1DR8_BIT8                    _ATD1DR8.Bits.BIT8
#define ATD1DR8_BIT9                    _ATD1DR8.Bits.BIT9
#define ATD1DR8_BIT10                   _ATD1DR8.Bits.BIT10
#define ATD1DR8_BIT11                   _ATD1DR8.Bits.BIT11
#define ATD1DR8_BIT12                   _ATD1DR8.Bits.BIT12
#define ATD1DR8_BIT13                   _ATD1DR8.Bits.BIT13
#define ATD1DR8_BIT14                   _ATD1DR8.Bits.BIT14
#define ATD1DR8_BIT15                   _ATD1DR8.Bits.BIT15

#define ATD1DR8_BIT0_MASK               1U
#define ATD1DR8_BIT1_MASK               2U
#define ATD1DR8_BIT2_MASK               4U
#define ATD1DR8_BIT3_MASK               8U
#define ATD1DR8_BIT4_MASK               16U
#define ATD1DR8_BIT5_MASK               32U
#define ATD1DR8_BIT6_MASK               64U
#define ATD1DR8_BIT7_MASK               128U
#define ATD1DR8_BIT8_MASK               256U
#define ATD1DR8_BIT9_MASK               512U
#define ATD1DR8_BIT10_MASK              1024U
#define ATD1DR8_BIT11_MASK              2048U
#define ATD1DR8_BIT12_MASK              4096U
#define ATD1DR8_BIT13_MASK              8192U
#define ATD1DR8_BIT14_MASK              16384U
#define ATD1DR8_BIT15_MASK              32768U


/*** ATD1DR9 - ATD 1 Conversion Result Register 9; 0x000000A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR9H - ATD 1 Conversion Result Register 9 High; 0x000000A2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR9HSTR;
    #define ATD1DR9H                    _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Byte
    #define ATD1DR9H_BIT8               _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT8
    #define ATD1DR9H_BIT9               _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT9
    #define ATD1DR9H_BIT10              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT10
    #define ATD1DR9H_BIT11              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT11
    #define ATD1DR9H_BIT12              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT12
    #define ATD1DR9H_BIT13              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT13
    #define ATD1DR9H_BIT14              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT14
    #define ATD1DR9H_BIT15              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT15
    
    #define ATD1DR9H_BIT8_MASK          1U
    #define ATD1DR9H_BIT9_MASK          2U
    #define ATD1DR9H_BIT10_MASK         4U
    #define ATD1DR9H_BIT11_MASK         8U
    #define ATD1DR9H_BIT12_MASK         16U
    #define ATD1DR9H_BIT13_MASK         32U
    #define ATD1DR9H_BIT14_MASK         64U
    #define ATD1DR9H_BIT15_MASK         128U
    

    /*** ATD1DR9L - ATD 1 Conversion Result Register 9 Low; 0x000000A3 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR9LSTR;
    #define ATD1DR9L                    _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Byte
    #define ATD1DR9L_BIT0               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT0
    #define ATD1DR9L_BIT1               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT1
    #define ATD1DR9L_BIT2               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT2
    #define ATD1DR9L_BIT3               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT3
    #define ATD1DR9L_BIT4               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT4
    #define ATD1DR9L_BIT5               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT5
    #define ATD1DR9L_BIT6               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT6
    #define ATD1DR9L_BIT7               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT7
    
    #define ATD1DR9L_BIT0_MASK          1U
    #define ATD1DR9L_BIT1_MASK          2U
    #define ATD1DR9L_BIT2_MASK          4U
    #define ATD1DR9L_BIT3_MASK          8U
    #define ATD1DR9L_BIT4_MASK          16U
    #define ATD1DR9L_BIT5_MASK          32U
    #define ATD1DR9L_BIT6_MASK          64U
    #define ATD1DR9L_BIT7_MASK          128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR9STR;
extern volatile ATD1DR9STR _ATD1DR9 @(REG_BASE + 0x000000A2UL);
#define ATD1DR9                         _ATD1DR9.Word
#define ATD1DR9_BIT0                    _ATD1DR9.Bits.BIT0
#define ATD1DR9_BIT1                    _ATD1DR9.Bits.BIT1
#define ATD1DR9_BIT2                    _ATD1DR9.Bits.BIT2
#define ATD1DR9_BIT3                    _ATD1DR9.Bits.BIT3
#define ATD1DR9_BIT4                    _ATD1DR9.Bits.BIT4
#define ATD1DR9_BIT5                    _ATD1DR9.Bits.BIT5
#define ATD1DR9_BIT6                    _ATD1DR9.Bits.BIT6
#define ATD1DR9_BIT7                    _ATD1DR9.Bits.BIT7
#define ATD1DR9_BIT8                    _ATD1DR9.Bits.BIT8
#define ATD1DR9_BIT9                    _ATD1DR9.Bits.BIT9
#define ATD1DR9_BIT10                   _ATD1DR9.Bits.BIT10
#define ATD1DR9_BIT11                   _ATD1DR9.Bits.BIT11
#define ATD1DR9_BIT12                   _ATD1DR9.Bits.BIT12
#define ATD1DR9_BIT13                   _ATD1DR9.Bits.BIT13
#define ATD1DR9_BIT14                   _ATD1DR9.Bits.BIT14
#define ATD1DR9_BIT15                   _ATD1DR9.Bits.BIT15

#define ATD1DR9_BIT0_MASK               1U
#define ATD1DR9_BIT1_MASK               2U
#define ATD1DR9_BIT2_MASK               4U
#define ATD1DR9_BIT3_MASK               8U
#define ATD1DR9_BIT4_MASK               16U
#define ATD1DR9_BIT5_MASK               32U
#define ATD1DR9_BIT6_MASK               64U
#define ATD1DR9_BIT7_MASK               128U
#define ATD1DR9_BIT8_MASK               256U
#define ATD1DR9_BIT9_MASK               512U
#define ATD1DR9_BIT10_MASK              1024U
#define ATD1DR9_BIT11_MASK              2048U
#define ATD1DR9_BIT12_MASK              4096U
#define ATD1DR9_BIT13_MASK              8192U
#define ATD1DR9_BIT14_MASK              16384U
#define ATD1DR9_BIT15_MASK              32768U


/*** ATD1DR10 - ATD 1 Conversion Result Register 10; 0x000000A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR10H - ATD 1 Conversion Result Register 10 High; 0x000000A4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR10HSTR;
    #define ATD1DR10H                   _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Byte
    #define ATD1DR10H_BIT8              _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT8
    #define ATD1DR10H_BIT9              _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT9
    #define ATD1DR10H_BIT10             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT10
    #define ATD1DR10H_BIT11             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT11
    #define ATD1DR10H_BIT12             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT12
    #define ATD1DR10H_BIT13             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT13
    #define ATD1DR10H_BIT14             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT14
    #define ATD1DR10H_BIT15             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT15
    
    #define ATD1DR10H_BIT8_MASK         1U
    #define ATD1DR10H_BIT9_MASK         2U
    #define ATD1DR10H_BIT10_MASK        4U
    #define ATD1DR10H_BIT11_MASK        8U
    #define ATD1DR10H_BIT12_MASK        16U
    #define ATD1DR10H_BIT13_MASK        32U
    #define ATD1DR10H_BIT14_MASK        64U
    #define ATD1DR10H_BIT15_MASK        128U
    

    /*** ATD1DR10L - ATD 1 Conversion Result Register 10 Low; 0x000000A5 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR10LSTR;
    #define ATD1DR10L                   _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Byte
    #define ATD1DR10L_BIT0              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT0
    #define ATD1DR10L_BIT1              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT1
    #define ATD1DR10L_BIT2              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT2
    #define ATD1DR10L_BIT3              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT3
    #define ATD1DR10L_BIT4              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT4
    #define ATD1DR10L_BIT5              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT5
    #define ATD1DR10L_BIT6              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT6
    #define ATD1DR10L_BIT7              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT7
    
    #define ATD1DR10L_BIT0_MASK         1U
    #define ATD1DR10L_BIT1_MASK         2U
    #define ATD1DR10L_BIT2_MASK         4U
    #define ATD1DR10L_BIT3_MASK         8U
    #define ATD1DR10L_BIT4_MASK         16U
    #define ATD1DR10L_BIT5_MASK         32U
    #define ATD1DR10L_BIT6_MASK         64U
    #define ATD1DR10L_BIT7_MASK         128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR10STR;
extern volatile ATD1DR10STR _ATD1DR10 @(REG_BASE + 0x000000A4UL);
#define ATD1DR10                        _ATD1DR10.Word
#define ATD1DR10_BIT0                   _ATD1DR10.Bits.BIT0
#define ATD1DR10_BIT1                   _ATD1DR10.Bits.BIT1
#define ATD1DR10_BIT2                   _ATD1DR10.Bits.BIT2
#define ATD1DR10_BIT3                   _ATD1DR10.Bits.BIT3
#define ATD1DR10_BIT4                   _ATD1DR10.Bits.BIT4
#define ATD1DR10_BIT5                   _ATD1DR10.Bits.BIT5
#define ATD1DR10_BIT6                   _ATD1DR10.Bits.BIT6
#define ATD1DR10_BIT7                   _ATD1DR10.Bits.BIT7
#define ATD1DR10_BIT8                   _ATD1DR10.Bits.BIT8
#define ATD1DR10_BIT9                   _ATD1DR10.Bits.BIT9
#define ATD1DR10_BIT10                  _ATD1DR10.Bits.BIT10
#define ATD1DR10_BIT11                  _ATD1DR10.Bits.BIT11
#define ATD1DR10_BIT12                  _ATD1DR10.Bits.BIT12
#define ATD1DR10_BIT13                  _ATD1DR10.Bits.BIT13
#define ATD1DR10_BIT14                  _ATD1DR10.Bits.BIT14
#define ATD1DR10_BIT15                  _ATD1DR10.Bits.BIT15

#define ATD1DR10_BIT0_MASK              1U
#define ATD1DR10_BIT1_MASK              2U
#define ATD1DR10_BIT2_MASK              4U
#define ATD1DR10_BIT3_MASK              8U
#define ATD1DR10_BIT4_MASK              16U
#define ATD1DR10_BIT5_MASK              32U
#define ATD1DR10_BIT6_MASK              64U
#define ATD1DR10_BIT7_MASK              128U
#define ATD1DR10_BIT8_MASK              256U
#define ATD1DR10_BIT9_MASK              512U
#define ATD1DR10_BIT10_MASK             1024U
#define ATD1DR10_BIT11_MASK             2048U
#define ATD1DR10_BIT12_MASK             4096U
#define ATD1DR10_BIT13_MASK             8192U
#define ATD1DR10_BIT14_MASK             16384U
#define ATD1DR10_BIT15_MASK             32768U


/*** ATD1DR11 - ATD 1 Conversion Result Register 11; 0x000000A6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR11H - ATD 1 Conversion Result Register 11 High; 0x000000A6 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR11HSTR;
    #define ATD1DR11H                   _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Byte
    #define ATD1DR11H_BIT8              _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT8
    #define ATD1DR11H_BIT9              _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT9
    #define ATD1DR11H_BIT10             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT10
    #define ATD1DR11H_BIT11             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT11
    #define ATD1DR11H_BIT12             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT12
    #define ATD1DR11H_BIT13             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT13
    #define ATD1DR11H_BIT14             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT14
    #define ATD1DR11H_BIT15             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT15
    
    #define ATD1DR11H_BIT8_MASK         1U
    #define ATD1DR11H_BIT9_MASK         2U
    #define ATD1DR11H_BIT10_MASK        4U
    #define ATD1DR11H_BIT11_MASK        8U
    #define ATD1DR11H_BIT12_MASK        16U
    #define ATD1DR11H_BIT13_MASK        32U
    #define ATD1DR11H_BIT14_MASK        64U
    #define ATD1DR11H_BIT15_MASK        128U
    

    /*** ATD1DR11L - ATD 1 Conversion Result Register 11 Low; 0x000000A7 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR11LSTR;
    #define ATD1DR11L                   _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Byte
    #define ATD1DR11L_BIT0              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT0
    #define ATD1DR11L_BIT1              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT1
    #define ATD1DR11L_BIT2              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT2
    #define ATD1DR11L_BIT3              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT3
    #define ATD1DR11L_BIT4              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT4
    #define ATD1DR11L_BIT5              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT5
    #define ATD1DR11L_BIT6              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT6
    #define ATD1DR11L_BIT7              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT7
    
    #define ATD1DR11L_BIT0_MASK         1U
    #define ATD1DR11L_BIT1_MASK         2U
    #define ATD1DR11L_BIT2_MASK         4U
    #define ATD1DR11L_BIT3_MASK         8U
    #define ATD1DR11L_BIT4_MASK         16U
    #define ATD1DR11L_BIT5_MASK         32U
    #define ATD1DR11L_BIT6_MASK         64U
    #define ATD1DR11L_BIT7_MASK         128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR11STR;
extern volatile ATD1DR11STR _ATD1DR11 @(REG_BASE + 0x000000A6UL);
#define ATD1DR11                        _ATD1DR11.Word
#define ATD1DR11_BIT0                   _ATD1DR11.Bits.BIT0
#define ATD1DR11_BIT1                   _ATD1DR11.Bits.BIT1
#define ATD1DR11_BIT2                   _ATD1DR11.Bits.BIT2
#define ATD1DR11_BIT3                   _ATD1DR11.Bits.BIT3
#define ATD1DR11_BIT4                   _ATD1DR11.Bits.BIT4
#define ATD1DR11_BIT5                   _ATD1DR11.Bits.BIT5
#define ATD1DR11_BIT6                   _ATD1DR11.Bits.BIT6
#define ATD1DR11_BIT7                   _ATD1DR11.Bits.BIT7
#define ATD1DR11_BIT8                   _ATD1DR11.Bits.BIT8
#define ATD1DR11_BIT9                   _ATD1DR11.Bits.BIT9
#define ATD1DR11_BIT10                  _ATD1DR11.Bits.BIT10
#define ATD1DR11_BIT11                  _ATD1DR11.Bits.BIT11
#define ATD1DR11_BIT12                  _ATD1DR11.Bits.BIT12
#define ATD1DR11_BIT13                  _ATD1DR11.Bits.BIT13
#define ATD1DR11_BIT14                  _ATD1DR11.Bits.BIT14
#define ATD1DR11_BIT15                  _ATD1DR11.Bits.BIT15

#define ATD1DR11_BIT0_MASK              1U
#define ATD1DR11_BIT1_MASK              2U
#define ATD1DR11_BIT2_MASK              4U
#define ATD1DR11_BIT3_MASK              8U
#define ATD1DR11_BIT4_MASK              16U
#define ATD1DR11_BIT5_MASK              32U
#define ATD1DR11_BIT6_MASK              64U
#define ATD1DR11_BIT7_MASK              128U
#define ATD1DR11_BIT8_MASK              256U
#define ATD1DR11_BIT9_MASK              512U
#define ATD1DR11_BIT10_MASK             1024U
#define ATD1DR11_BIT11_MASK             2048U
#define ATD1DR11_BIT12_MASK             4096U
#define ATD1DR11_BIT13_MASK             8192U
#define ATD1DR11_BIT14_MASK             16384U
#define ATD1DR11_BIT15_MASK             32768U


/*** ATD1DR12 - ATD 1 Conversion Result Register 12; 0x000000A8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR12H - ATD 1 Conversion Result Register 12 High; 0x000000A8 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR12HSTR;
    #define ATD1DR12H                   _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Byte
    #define ATD1DR12H_BIT8              _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT8
    #define ATD1DR12H_BIT9              _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT9
    #define ATD1DR12H_BIT10             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT10
    #define ATD1DR12H_BIT11             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT11
    #define ATD1DR12H_BIT12             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT12
    #define ATD1DR12H_BIT13             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT13
    #define ATD1DR12H_BIT14             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT14
    #define ATD1DR12H_BIT15             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT15
    
    #define ATD1DR12H_BIT8_MASK         1U
    #define ATD1DR12H_BIT9_MASK         2U
    #define ATD1DR12H_BIT10_MASK        4U
    #define ATD1DR12H_BIT11_MASK        8U
    #define ATD1DR12H_BIT12_MASK        16U
    #define ATD1DR12H_BIT13_MASK        32U
    #define ATD1DR12H_BIT14_MASK        64U
    #define ATD1DR12H_BIT15_MASK        128U
    

    /*** ATD1DR12L - ATD 1 Conversion Result Register 12 Low; 0x000000A9 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR12LSTR;
    #define ATD1DR12L                   _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Byte
    #define ATD1DR12L_BIT0              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT0
    #define ATD1DR12L_BIT1              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT1
    #define ATD1DR12L_BIT2              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT2
    #define ATD1DR12L_BIT3              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT3
    #define ATD1DR12L_BIT4              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT4
    #define ATD1DR12L_BIT5              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT5
    #define ATD1DR12L_BIT6              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT6
    #define ATD1DR12L_BIT7              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT7
    
    #define ATD1DR12L_BIT0_MASK         1U
    #define ATD1DR12L_BIT1_MASK         2U
    #define ATD1DR12L_BIT2_MASK         4U
    #define ATD1DR12L_BIT3_MASK         8U
    #define ATD1DR12L_BIT4_MASK         16U
    #define ATD1DR12L_BIT5_MASK         32U
    #define ATD1DR12L_BIT6_MASK         64U
    #define ATD1DR12L_BIT7_MASK         128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR12STR;
extern volatile ATD1DR12STR _ATD1DR12 @(REG_BASE + 0x000000A8UL);
#define ATD1DR12                        _ATD1DR12.Word
#define ATD1DR12_BIT0                   _ATD1DR12.Bits.BIT0
#define ATD1DR12_BIT1                   _ATD1DR12.Bits.BIT1
#define ATD1DR12_BIT2                   _ATD1DR12.Bits.BIT2
#define ATD1DR12_BIT3                   _ATD1DR12.Bits.BIT3
#define ATD1DR12_BIT4                   _ATD1DR12.Bits.BIT4
#define ATD1DR12_BIT5                   _ATD1DR12.Bits.BIT5
#define ATD1DR12_BIT6                   _ATD1DR12.Bits.BIT6
#define ATD1DR12_BIT7                   _ATD1DR12.Bits.BIT7
#define ATD1DR12_BIT8                   _ATD1DR12.Bits.BIT8
#define ATD1DR12_BIT9                   _ATD1DR12.Bits.BIT9
#define ATD1DR12_BIT10                  _ATD1DR12.Bits.BIT10
#define ATD1DR12_BIT11                  _ATD1DR12.Bits.BIT11
#define ATD1DR12_BIT12                  _ATD1DR12.Bits.BIT12
#define ATD1DR12_BIT13                  _ATD1DR12.Bits.BIT13
#define ATD1DR12_BIT14                  _ATD1DR12.Bits.BIT14
#define ATD1DR12_BIT15                  _ATD1DR12.Bits.BIT15

#define ATD1DR12_BIT0_MASK              1U
#define ATD1DR12_BIT1_MASK              2U
#define ATD1DR12_BIT2_MASK              4U
#define ATD1DR12_BIT3_MASK              8U
#define ATD1DR12_BIT4_MASK              16U
#define ATD1DR12_BIT5_MASK              32U
#define ATD1DR12_BIT6_MASK              64U
#define ATD1DR12_BIT7_MASK              128U
#define ATD1DR12_BIT8_MASK              256U
#define ATD1DR12_BIT9_MASK              512U
#define ATD1DR12_BIT10_MASK             1024U
#define ATD1DR12_BIT11_MASK             2048U
#define ATD1DR12_BIT12_MASK             4096U
#define ATD1DR12_BIT13_MASK             8192U
#define ATD1DR12_BIT14_MASK             16384U
#define ATD1DR12_BIT15_MASK             32768U


/*** ATD1DR13 - ATD 1 Conversion Result Register 13; 0x000000AA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR13H - ATD 1 Conversion Result Register 13 High; 0x000000AA ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR13HSTR;
    #define ATD1DR13H                   _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Byte
    #define ATD1DR13H_BIT8              _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT8
    #define ATD1DR13H_BIT9              _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT9
    #define ATD1DR13H_BIT10             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT10
    #define ATD1DR13H_BIT11             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT11
    #define ATD1DR13H_BIT12             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT12
    #define ATD1DR13H_BIT13             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT13
    #define ATD1DR13H_BIT14             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT14
    #define ATD1DR13H_BIT15             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT15
    
    #define ATD1DR13H_BIT8_MASK         1U
    #define ATD1DR13H_BIT9_MASK         2U
    #define ATD1DR13H_BIT10_MASK        4U
    #define ATD1DR13H_BIT11_MASK        8U
    #define ATD1DR13H_BIT12_MASK        16U
    #define ATD1DR13H_BIT13_MASK        32U
    #define ATD1DR13H_BIT14_MASK        64U
    #define ATD1DR13H_BIT15_MASK        128U
    

    /*** ATD1DR13L - ATD 1 Conversion Result Register 13 Low; 0x000000AB ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR13LSTR;
    #define ATD1DR13L                   _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Byte
    #define ATD1DR13L_BIT0              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT0
    #define ATD1DR13L_BIT1              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT1
    #define ATD1DR13L_BIT2              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT2
    #define ATD1DR13L_BIT3              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT3
    #define ATD1DR13L_BIT4              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT4
    #define ATD1DR13L_BIT5              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT5
    #define ATD1DR13L_BIT6              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT6
    #define ATD1DR13L_BIT7              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT7
    
    #define ATD1DR13L_BIT0_MASK         1U
    #define ATD1DR13L_BIT1_MASK         2U
    #define ATD1DR13L_BIT2_MASK         4U
    #define ATD1DR13L_BIT3_MASK         8U
    #define ATD1DR13L_BIT4_MASK         16U
    #define ATD1DR13L_BIT5_MASK         32U
    #define ATD1DR13L_BIT6_MASK         64U
    #define ATD1DR13L_BIT7_MASK         128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR13STR;
extern volatile ATD1DR13STR _ATD1DR13 @(REG_BASE + 0x000000AAUL);
#define ATD1DR13                        _ATD1DR13.Word
#define ATD1DR13_BIT0                   _ATD1DR13.Bits.BIT0
#define ATD1DR13_BIT1                   _ATD1DR13.Bits.BIT1
#define ATD1DR13_BIT2                   _ATD1DR13.Bits.BIT2
#define ATD1DR13_BIT3                   _ATD1DR13.Bits.BIT3
#define ATD1DR13_BIT4                   _ATD1DR13.Bits.BIT4
#define ATD1DR13_BIT5                   _ATD1DR13.Bits.BIT5
#define ATD1DR13_BIT6                   _ATD1DR13.Bits.BIT6
#define ATD1DR13_BIT7                   _ATD1DR13.Bits.BIT7
#define ATD1DR13_BIT8                   _ATD1DR13.Bits.BIT8
#define ATD1DR13_BIT9                   _ATD1DR13.Bits.BIT9
#define ATD1DR13_BIT10                  _ATD1DR13.Bits.BIT10
#define ATD1DR13_BIT11                  _ATD1DR13.Bits.BIT11
#define ATD1DR13_BIT12                  _ATD1DR13.Bits.BIT12
#define ATD1DR13_BIT13                  _ATD1DR13.Bits.BIT13
#define ATD1DR13_BIT14                  _ATD1DR13.Bits.BIT14
#define ATD1DR13_BIT15                  _ATD1DR13.Bits.BIT15

#define ATD1DR13_BIT0_MASK              1U
#define ATD1DR13_BIT1_MASK              2U
#define ATD1DR13_BIT2_MASK              4U
#define ATD1DR13_BIT3_MASK              8U
#define ATD1DR13_BIT4_MASK              16U
#define ATD1DR13_BIT5_MASK              32U
#define ATD1DR13_BIT6_MASK              64U
#define ATD1DR13_BIT7_MASK              128U
#define ATD1DR13_BIT8_MASK              256U
#define ATD1DR13_BIT9_MASK              512U
#define ATD1DR13_BIT10_MASK             1024U
#define ATD1DR13_BIT11_MASK             2048U
#define ATD1DR13_BIT12_MASK             4096U
#define ATD1DR13_BIT13_MASK             8192U
#define ATD1DR13_BIT14_MASK             16384U
#define ATD1DR13_BIT15_MASK             32768U


/*** ATD1DR14 - ATD 1 Conversion Result Register 14; 0x000000AC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR14H - ATD 1 Conversion Result Register 14 High; 0x000000AC ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR14HSTR;
    #define ATD1DR14H                   _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Byte
    #define ATD1DR14H_BIT8              _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT8
    #define ATD1DR14H_BIT9              _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT9
    #define ATD1DR14H_BIT10             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT10
    #define ATD1DR14H_BIT11             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT11
    #define ATD1DR14H_BIT12             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT12
    #define ATD1DR14H_BIT13             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT13
    #define ATD1DR14H_BIT14             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT14
    #define ATD1DR14H_BIT15             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT15
    
    #define ATD1DR14H_BIT8_MASK         1U
    #define ATD1DR14H_BIT9_MASK         2U
    #define ATD1DR14H_BIT10_MASK        4U
    #define ATD1DR14H_BIT11_MASK        8U
    #define ATD1DR14H_BIT12_MASK        16U
    #define ATD1DR14H_BIT13_MASK        32U
    #define ATD1DR14H_BIT14_MASK        64U
    #define ATD1DR14H_BIT15_MASK        128U
    

    /*** ATD1DR14L - ATD 1 Conversion Result Register 14 Low; 0x000000AD ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR14LSTR;
    #define ATD1DR14L                   _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Byte
    #define ATD1DR14L_BIT0              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT0
    #define ATD1DR14L_BIT1              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT1
    #define ATD1DR14L_BIT2              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT2
    #define ATD1DR14L_BIT3              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT3
    #define ATD1DR14L_BIT4              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT4
    #define ATD1DR14L_BIT5              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT5
    #define ATD1DR14L_BIT6              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT6
    #define ATD1DR14L_BIT7              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT7
    
    #define ATD1DR14L_BIT0_MASK         1U
    #define ATD1DR14L_BIT1_MASK         2U
    #define ATD1DR14L_BIT2_MASK         4U
    #define ATD1DR14L_BIT3_MASK         8U
    #define ATD1DR14L_BIT4_MASK         16U
    #define ATD1DR14L_BIT5_MASK         32U
    #define ATD1DR14L_BIT6_MASK         64U
    #define ATD1DR14L_BIT7_MASK         128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR14STR;
extern volatile ATD1DR14STR _ATD1DR14 @(REG_BASE + 0x000000ACUL);
#define ATD1DR14                        _ATD1DR14.Word
#define ATD1DR14_BIT0                   _ATD1DR14.Bits.BIT0
#define ATD1DR14_BIT1                   _ATD1DR14.Bits.BIT1
#define ATD1DR14_BIT2                   _ATD1DR14.Bits.BIT2
#define ATD1DR14_BIT3                   _ATD1DR14.Bits.BIT3
#define ATD1DR14_BIT4                   _ATD1DR14.Bits.BIT4
#define ATD1DR14_BIT5                   _ATD1DR14.Bits.BIT5
#define ATD1DR14_BIT6                   _ATD1DR14.Bits.BIT6
#define ATD1DR14_BIT7                   _ATD1DR14.Bits.BIT7
#define ATD1DR14_BIT8                   _ATD1DR14.Bits.BIT8
#define ATD1DR14_BIT9                   _ATD1DR14.Bits.BIT9
#define ATD1DR14_BIT10                  _ATD1DR14.Bits.BIT10
#define ATD1DR14_BIT11                  _ATD1DR14.Bits.BIT11
#define ATD1DR14_BIT12                  _ATD1DR14.Bits.BIT12
#define ATD1DR14_BIT13                  _ATD1DR14.Bits.BIT13
#define ATD1DR14_BIT14                  _ATD1DR14.Bits.BIT14
#define ATD1DR14_BIT15                  _ATD1DR14.Bits.BIT15

#define ATD1DR14_BIT0_MASK              1U
#define ATD1DR14_BIT1_MASK              2U
#define ATD1DR14_BIT2_MASK              4U
#define ATD1DR14_BIT3_MASK              8U
#define ATD1DR14_BIT4_MASK              16U
#define ATD1DR14_BIT5_MASK              32U
#define ATD1DR14_BIT6_MASK              64U
#define ATD1DR14_BIT7_MASK              128U
#define ATD1DR14_BIT8_MASK              256U
#define ATD1DR14_BIT9_MASK              512U
#define ATD1DR14_BIT10_MASK             1024U
#define ATD1DR14_BIT11_MASK             2048U
#define ATD1DR14_BIT12_MASK             4096U
#define ATD1DR14_BIT13_MASK             8192U
#define ATD1DR14_BIT14_MASK             16384U
#define ATD1DR14_BIT15_MASK             32768U


/*** ATD1DR15 - ATD 1 Conversion Result Register 15; 0x000000AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR15H - ATD 1 Conversion Result Register 15 High; 0x000000AE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR15HSTR;
    #define ATD1DR15H                   _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Byte
    #define ATD1DR15H_BIT8              _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT8
    #define ATD1DR15H_BIT9              _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT9
    #define ATD1DR15H_BIT10             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT10
    #define ATD1DR15H_BIT11             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT11
    #define ATD1DR15H_BIT12             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT12
    #define ATD1DR15H_BIT13             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT13
    #define ATD1DR15H_BIT14             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT14
    #define ATD1DR15H_BIT15             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT15
    
    #define ATD1DR15H_BIT8_MASK         1U
    #define ATD1DR15H_BIT9_MASK         2U
    #define ATD1DR15H_BIT10_MASK        4U
    #define ATD1DR15H_BIT11_MASK        8U
    #define ATD1DR15H_BIT12_MASK        16U
    #define ATD1DR15H_BIT13_MASK        32U
    #define ATD1DR15H_BIT14_MASK        64U
    #define ATD1DR15H_BIT15_MASK        128U
    

    /*** ATD1DR15L - ATD 1 Conversion Result Register 15 Low; 0x000000AF ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Bit 0 */
        byte BIT1        :1;                                       /* Bit 1 */
        byte BIT2        :1;                                       /* Bit 2 */
        byte BIT3        :1;                                       /* Bit 3 */
        byte BIT4        :1;                                       /* Bit 4 */
        byte BIT5        :1;                                       /* Bit 5 */
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
    } ATD1DR15LSTR;
    #define ATD1DR15L                   _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Byte
    #define ATD1DR15L_BIT0              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT0
    #define ATD1DR15L_BIT1              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT1
    #define ATD1DR15L_BIT2              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT2
    #define ATD1DR15L_BIT3              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT3
    #define ATD1DR15L_BIT4              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT4
    #define ATD1DR15L_BIT5              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT5
    #define ATD1DR15L_BIT6              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT6
    #define ATD1DR15L_BIT7              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT7
    
    #define ATD1DR15L_BIT0_MASK         1U
    #define ATD1DR15L_BIT1_MASK         2U
    #define ATD1DR15L_BIT2_MASK         4U
    #define ATD1DR15L_BIT3_MASK         8U
    #define ATD1DR15L_BIT4_MASK         16U
    #define ATD1DR15L_BIT5_MASK         32U
    #define ATD1DR15L_BIT6_MASK         64U
    #define ATD1DR15L_BIT7_MASK         128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Bit 0 */
    word BIT1        :1;                                       /* Bit 1 */
    word BIT2        :1;                                       /* Bit 2 */
    word BIT3        :1;                                       /* Bit 3 */
    word BIT4        :1;                                       /* Bit 4 */
    word BIT5        :1;                                       /* Bit 5 */
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
} ATD1DR15STR;
extern volatile ATD1DR15STR _ATD1DR15 @(REG_BASE + 0x000000AEUL);
#define ATD1DR15                        _ATD1DR15.Word
#define ATD1DR15_BIT0                   _ATD1DR15.Bits.BIT0
#define ATD1DR15_BIT1                   _ATD1DR15.Bits.BIT1
#define ATD1DR15_BIT2                   _ATD1DR15.Bits.BIT2
#define ATD1DR15_BIT3                   _ATD1DR15.Bits.BIT3
#define ATD1DR15_BIT4                   _ATD1DR15.Bits.BIT4
#define ATD1DR15_BIT5                   _ATD1DR15.Bits.BIT5
#define ATD1DR15_BIT6                   _ATD1DR15.Bits.BIT6
#define ATD1DR15_BIT7                   _ATD1DR15.Bits.BIT7
#define ATD1DR15_BIT8                   _ATD1DR15.Bits.BIT8
#define ATD1DR15_BIT9                   _ATD1DR15.Bits.BIT9
#define ATD1DR15_BIT10                  _ATD1DR15.Bits.BIT10
#define ATD1DR15_BIT11                  _ATD1DR15.Bits.BIT11
#define ATD1DR15_BIT12                  _ATD1DR15.Bits.BIT12
#define ATD1DR15_BIT13                  _ATD1DR15.Bits.BIT13
#define ATD1DR15_BIT14                  _ATD1DR15.Bits.BIT14
#define ATD1DR15_BIT15                  _ATD1DR15.Bits.BIT15

#define ATD1DR15_BIT0_MASK              1U
#define ATD1DR15_BIT1_MASK              2U
#define ATD1DR15_BIT2_MASK              4U
#define ATD1DR15_BIT3_MASK              8U
#define ATD1DR15_BIT4_MASK              16U
#define ATD1DR15_BIT5_MASK              32U
#define ATD1DR15_BIT6_MASK              64U
#define ATD1DR15_BIT7_MASK              128U
#define ATD1DR15_BIT8_MASK              256U
#define ATD1DR15_BIT9_MASK              512U
#define ATD1DR15_BIT10_MASK             1024U
#define ATD1DR15_BIT11_MASK             2048U
#define ATD1DR15_BIT12_MASK             4096U
#define ATD1DR15_BIT13_MASK             8192U
#define ATD1DR15_BIT14_MASK             16384U
#define ATD1DR15_BIT15_MASK             32768U


/*** IIC1_IBAD - IIC Address Register; 0x000000B0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IIC1_IBADSTR;
extern volatile IIC1_IBADSTR _IIC1_IBAD @(REG_BASE + 0x000000B0UL);
#define IIC1_IBAD                       _IIC1_IBAD.Byte
#define IIC1_IBAD_ADR1                  _IIC1_IBAD.Bits.ADR1
#define IIC1_IBAD_ADR2                  _IIC1_IBAD.Bits.ADR2
#define IIC1_IBAD_ADR3                  _IIC1_IBAD.Bits.ADR3
#define IIC1_IBAD_ADR4                  _IIC1_IBAD.Bits.ADR4
#define IIC1_IBAD_ADR5                  _IIC1_IBAD.Bits.ADR5
#define IIC1_IBAD_ADR6                  _IIC1_IBAD.Bits.ADR6
#define IIC1_IBAD_ADR7                  _IIC1_IBAD.Bits.ADR7
#define IIC1_IBAD_ADR_1                 _IIC1_IBAD.MergedBits.grpADR_1
#define IIC1_IBAD_ADR                   IIC1_IBAD_ADR_1

#define IIC1_IBAD_ADR1_MASK             2U
#define IIC1_IBAD_ADR2_MASK             4U
#define IIC1_IBAD_ADR3_MASK             8U
#define IIC1_IBAD_ADR4_MASK             16U
#define IIC1_IBAD_ADR5_MASK             32U
#define IIC1_IBAD_ADR6_MASK             64U
#define IIC1_IBAD_ADR7_MASK             128U
#define IIC1_IBAD_ADR_1_MASK            254U
#define IIC1_IBAD_ADR_1_BITNUM          1U


/*** IIC1_IBFD - IIC Frequency Divider Register; 0x000000B1 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IIC1_IBFDSTR;
extern volatile IIC1_IBFDSTR _IIC1_IBFD @(REG_BASE + 0x000000B1UL);
#define IIC1_IBFD                       _IIC1_IBFD.Byte
#define IIC1_IBFD_IBC0                  _IIC1_IBFD.Bits.IBC0
#define IIC1_IBFD_IBC1                  _IIC1_IBFD.Bits.IBC1
#define IIC1_IBFD_IBC2                  _IIC1_IBFD.Bits.IBC2
#define IIC1_IBFD_IBC3                  _IIC1_IBFD.Bits.IBC3
#define IIC1_IBFD_IBC4                  _IIC1_IBFD.Bits.IBC4
#define IIC1_IBFD_IBC5                  _IIC1_IBFD.Bits.IBC5
#define IIC1_IBFD_IBC6                  _IIC1_IBFD.Bits.IBC6
#define IIC1_IBFD_IBC7                  _IIC1_IBFD.Bits.IBC7

#define IIC1_IBFD_IBC0_MASK             1U
#define IIC1_IBFD_IBC1_MASK             2U
#define IIC1_IBFD_IBC2_MASK             4U
#define IIC1_IBFD_IBC3_MASK             8U
#define IIC1_IBFD_IBC4_MASK             16U
#define IIC1_IBFD_IBC5_MASK             32U
#define IIC1_IBFD_IBC6_MASK             64U
#define IIC1_IBFD_IBC7_MASK             128U


/*** IIC1_IBCR - IIC Control Register; 0x000000B2 ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IIC1_IBCRSTR;
extern volatile IIC1_IBCRSTR _IIC1_IBCR @(REG_BASE + 0x000000B2UL);
#define IIC1_IBCR                       _IIC1_IBCR.Byte
#define IIC1_IBCR_IBSWAI                _IIC1_IBCR.Bits.IBSWAI
#define IIC1_IBCR_RSTA                  _IIC1_IBCR.Bits.RSTA
#define IIC1_IBCR_TXAK                  _IIC1_IBCR.Bits.TXAK
#define IIC1_IBCR_TX_RX                 _IIC1_IBCR.Bits.TX_RX
#define IIC1_IBCR_MS_SL                 _IIC1_IBCR.Bits.MS_SL
#define IIC1_IBCR_IBIE                  _IIC1_IBCR.Bits.IBIE
#define IIC1_IBCR_IBEN                  _IIC1_IBCR.Bits.IBEN

#define IIC1_IBCR_IBSWAI_MASK           1U
#define IIC1_IBCR_RSTA_MASK             4U
#define IIC1_IBCR_TXAK_MASK             8U
#define IIC1_IBCR_TX_RX_MASK            16U
#define IIC1_IBCR_MS_SL_MASK            32U
#define IIC1_IBCR_IBIE_MASK             64U
#define IIC1_IBCR_IBEN_MASK             128U


/*** IIC1_IBSR - IIC Status Register; 0x000000B3 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IIC1_IBSRSTR;
extern volatile IIC1_IBSRSTR _IIC1_IBSR @(REG_BASE + 0x000000B3UL);
#define IIC1_IBSR                       _IIC1_IBSR.Byte
#define IIC1_IBSR_RXAK                  _IIC1_IBSR.Bits.RXAK
#define IIC1_IBSR_IBIF                  _IIC1_IBSR.Bits.IBIF
#define IIC1_IBSR_SRW                   _IIC1_IBSR.Bits.SRW
#define IIC1_IBSR_IBAL                  _IIC1_IBSR.Bits.IBAL
#define IIC1_IBSR_IBB                   _IIC1_IBSR.Bits.IBB
#define IIC1_IBSR_IAAS                  _IIC1_IBSR.Bits.IAAS
#define IIC1_IBSR_TCF                   _IIC1_IBSR.Bits.TCF

#define IIC1_IBSR_RXAK_MASK             1U
#define IIC1_IBSR_IBIF_MASK             2U
#define IIC1_IBSR_SRW_MASK              4U
#define IIC1_IBSR_IBAL_MASK             16U
#define IIC1_IBSR_IBB_MASK              32U
#define IIC1_IBSR_IAAS_MASK             64U
#define IIC1_IBSR_TCF_MASK              128U


/*** IIC1_IBDR - IIC Data I/O Register; 0x000000B4 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IIC1_IBDRSTR;
extern volatile IIC1_IBDRSTR _IIC1_IBDR @(REG_BASE + 0x000000B4UL);
#define IIC1_IBDR                       _IIC1_IBDR.Byte
#define IIC1_IBDR_D0                    _IIC1_IBDR.Bits.D0
#define IIC1_IBDR_D1                    _IIC1_IBDR.Bits.D1
#define IIC1_IBDR_D2                    _IIC1_IBDR.Bits.D2
#define IIC1_IBDR_D3                    _IIC1_IBDR.Bits.D3
#define IIC1_IBDR_D4                    _IIC1_IBDR.Bits.D4
#define IIC1_IBDR_D5                    _IIC1_IBDR.Bits.D5
#define IIC1_IBDR_D6                    _IIC1_IBDR.Bits.D6
#define IIC1_IBDR_D7                    _IIC1_IBDR.Bits.D7

#define IIC1_IBDR_D0_MASK               1U
#define IIC1_IBDR_D1_MASK               2U
#define IIC1_IBDR_D2_MASK               4U
#define IIC1_IBDR_D3_MASK               8U
#define IIC1_IBDR_D4_MASK               16U
#define IIC1_IBDR_D5_MASK               32U
#define IIC1_IBDR_D6_MASK               64U
#define IIC1_IBDR_D7_MASK               128U


/*** IIC1_IBCR2 - IIC Control Register 2; 0x000000B5 ***/
typedef union {
  byte Byte;
  struct {
    byte ADR8        :1;                                       /* Slave Address Bit 8 */
    byte ADR9        :1;                                       /* Slave Address Bit 9 */
    byte ADR10       :1;                                       /* Slave Address Bit 10 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte ADTYPE      :1;                                       /* Address Type */
    byte GCEN        :1;                                       /* General Call Enable */
  } Bits;
  struct {
    byte grpADR_8 :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IIC1_IBCR2STR;
extern volatile IIC1_IBCR2STR _IIC1_IBCR2 @(REG_BASE + 0x000000B5UL);
#define IIC1_IBCR2                      _IIC1_IBCR2.Byte
#define IIC1_IBCR2_ADR8                 _IIC1_IBCR2.Bits.ADR8
#define IIC1_IBCR2_ADR9                 _IIC1_IBCR2.Bits.ADR9
#define IIC1_IBCR2_ADR10                _IIC1_IBCR2.Bits.ADR10
#define IIC1_IBCR2_ADTYPE               _IIC1_IBCR2.Bits.ADTYPE
#define IIC1_IBCR2_GCEN                 _IIC1_IBCR2.Bits.GCEN
#define IIC1_IBCR2_ADR_8                _IIC1_IBCR2.MergedBits.grpADR_8
#define IIC1_IBCR2_ADR                  IIC1_IBCR2_ADR_8

#define IIC1_IBCR2_ADR8_MASK            1U
#define IIC1_IBCR2_ADR9_MASK            2U
#define IIC1_IBCR2_ADR10_MASK           4U
#define IIC1_IBCR2_ADTYPE_MASK          64U
#define IIC1_IBCR2_GCEN_MASK            128U
#define IIC1_IBCR2_ADR_8_MASK           7U
#define IIC1_IBCR2_ADR_8_BITNUM         0U


/*** SCI2BD - SCI 2 Baud Rate Register; 0x000000B8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI2ASR1 - SCI 2 Alternative Status Register 1; 0x000000B8 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI2ASR1 - SCI 2 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI2ASR1STR;
        #define SCI2ASR1                _SCI2BD.Overlap_STR.SCI2ASR1STR.Byte
        #define SCI2ASR1_BKDIF          _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2ASR1STR.Bits.BKDIF
        #define SCI2ASR1_BERRIF         _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2ASR1STR.Bits.BERRIF
        #define SCI2ASR1_BERRV          _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2ASR1STR.Bits.BERRV
        #define SCI2ASR1_RXEDGIF        _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2ASR1STR.Bits.RXEDGIF
        
        #define SCI2ASR1_BKDIF_MASK     1U
        #define SCI2ASR1_BERRIF_MASK    2U
        #define SCI2ASR1_BERRV_MASK     4U
        #define SCI2ASR1_RXEDGIF_MASK   128U
        
        /*** SCI2BDH - SCI 2 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI2BDHSTR;
        #define SCI2BDH                 _SCI2BD.Overlap_STR.SCI2ASR1STR.Byte
        #define SCI2BDH_SBR8            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR8
        #define SCI2BDH_SBR9            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR9
        #define SCI2BDH_SBR10           _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR10
        #define SCI2BDH_SBR11           _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR11
        #define SCI2BDH_SBR12           _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR12
        #define SCI2BDH_TNP0            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.TNP0
        #define SCI2BDH_TNP1            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.TNP1
        #define SCI2BDH_IREN            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.IREN
        #define SCI2BDH_SBR_8           _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.MergedBits.grpSBR_8
        #define SCI2BDH_TNP             _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.MergedBits.grpTNP
        #define SCI2BDH_SBR             SCI2BDH_SBR_8
        
        #define SCI2BDH_SBR8_MASK       1U
        #define SCI2BDH_SBR9_MASK       2U
        #define SCI2BDH_SBR10_MASK      4U
        #define SCI2BDH_SBR11_MASK      8U
        #define SCI2BDH_SBR12_MASK      16U
        #define SCI2BDH_TNP0_MASK       32U
        #define SCI2BDH_TNP1_MASK       64U
        #define SCI2BDH_IREN_MASK       128U
        #define SCI2BDH_SBR_8_MASK      31U
        #define SCI2BDH_SBR_8_BITNUM    0U
        #define SCI2BDH_TNP_MASK        96U
        #define SCI2BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI2ASR1STR;
    

    /*** SCI2ACR1 - SCI 2 Alternative Control Register 1; 0x000000B9 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI2ACR1 - SCI 2 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI2ACR1STR;
        #define SCI2ACR1                _SCI2BD.Overlap_STR.SCI2ACR1STR.Byte
        #define SCI2ACR1_BKDIE          _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2ACR1STR.Bits.BKDIE
        #define SCI2ACR1_BERRIE         _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2ACR1STR.Bits.BERRIE
        #define SCI2ACR1_RXEDGIE        _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2ACR1STR.Bits.RXEDGIE
        
        #define SCI2ACR1_BKDIE_MASK     1U
        #define SCI2ACR1_BERRIE_MASK    2U
        #define SCI2ACR1_RXEDGIE_MASK   128U
        
        /*** SCI2BDL - SCI 2 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI2BDLSTR;
        #define SCI2BDL                 _SCI2BD.Overlap_STR.SCI2ACR1STR.Byte
        #define SCI2BDL_SBR0            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR0
        #define SCI2BDL_SBR1            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR1
        #define SCI2BDL_SBR2            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR2
        #define SCI2BDL_SBR3            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR3
        #define SCI2BDL_SBR4            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR4
        #define SCI2BDL_SBR5            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR5
        #define SCI2BDL_SBR6            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR6
        #define SCI2BDL_SBR7            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR7
        
        #define SCI2BDL_SBR0_MASK       1U
        #define SCI2BDL_SBR1_MASK       2U
        #define SCI2BDL_SBR2_MASK       4U
        #define SCI2BDL_SBR3_MASK       8U
        #define SCI2BDL_SBR4_MASK       16U
        #define SCI2BDL_SBR5_MASK       32U
        #define SCI2BDL_SBR6_MASK       64U
        #define SCI2BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI2ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI2BDSTR;
extern volatile SCI2BDSTR _SCI2BD @(REG_BASE + 0x000000B8UL);
#define SCI2BD                          _SCI2BD.Word
#define SCI2BD_SBR0                     _SCI2BD.Bits.SBR0
#define SCI2BD_SBR1                     _SCI2BD.Bits.SBR1
#define SCI2BD_SBR2                     _SCI2BD.Bits.SBR2
#define SCI2BD_SBR3                     _SCI2BD.Bits.SBR3
#define SCI2BD_SBR4                     _SCI2BD.Bits.SBR4
#define SCI2BD_SBR5                     _SCI2BD.Bits.SBR5
#define SCI2BD_SBR6                     _SCI2BD.Bits.SBR6
#define SCI2BD_SBR7                     _SCI2BD.Bits.SBR7
#define SCI2BD_SBR8                     _SCI2BD.Bits.SBR8
#define SCI2BD_SBR9                     _SCI2BD.Bits.SBR9
#define SCI2BD_SBR10                    _SCI2BD.Bits.SBR10
#define SCI2BD_SBR11                    _SCI2BD.Bits.SBR11
#define SCI2BD_SBR12                    _SCI2BD.Bits.SBR12
#define SCI2BD_TNP0                     _SCI2BD.Bits.TNP0
#define SCI2BD_TNP1                     _SCI2BD.Bits.TNP1
#define SCI2BD_IREN                     _SCI2BD.Bits.IREN
#define SCI2BD_SBR                      _SCI2BD.MergedBits.grpSBR
#define SCI2BD_TNP                      _SCI2BD.MergedBits.grpTNP

#define SCI2BD_SBR0_MASK                1U
#define SCI2BD_SBR1_MASK                2U
#define SCI2BD_SBR2_MASK                4U
#define SCI2BD_SBR3_MASK                8U
#define SCI2BD_SBR4_MASK                16U
#define SCI2BD_SBR5_MASK                32U
#define SCI2BD_SBR6_MASK                64U
#define SCI2BD_SBR7_MASK                128U
#define SCI2BD_SBR8_MASK                256U
#define SCI2BD_SBR9_MASK                512U
#define SCI2BD_SBR10_MASK               1024U
#define SCI2BD_SBR11_MASK               2048U
#define SCI2BD_SBR12_MASK               4096U
#define SCI2BD_TNP0_MASK                8192U
#define SCI2BD_TNP1_MASK                16384U
#define SCI2BD_IREN_MASK                32768U
#define SCI2BD_SBR_MASK                 8191U
#define SCI2BD_SBR_BITNUM               0U
#define SCI2BD_TNP_MASK                 24576U
#define SCI2BD_TNP_BITNUM               13U


/*** SCI2ACR2 - SCI 2 Alternative Control Register 2; 0x000000BA ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI2ACR2 - SCI 2 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI2ACR2STR;
    #define SCI2ACR2                    _SCI2ACR2.Byte
    #define SCI2ACR2_BKDFE              _SCI2ACR2.SameAddr_STR.SCI2ACR2STR.Bits.BKDFE
    #define SCI2ACR2_BERRM0             _SCI2ACR2.SameAddr_STR.SCI2ACR2STR.Bits.BERRM0
    #define SCI2ACR2_BERRM1             _SCI2ACR2.SameAddr_STR.SCI2ACR2STR.Bits.BERRM1
    #define SCI2ACR2_BERRM              _SCI2ACR2.SameAddr_STR.SCI2ACR2STR.MergedBits.grpBERRM
    
    #define SCI2ACR2_BKDFE_MASK         1U
    #define SCI2ACR2_BERRM0_MASK        2U
    #define SCI2ACR2_BERRM1_MASK        4U
    #define SCI2ACR2_BERRM_MASK         6U
    #define SCI2ACR2_BERRM_BITNUM       1U
    
    /*** SCI2CR1 - SCI 2 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI2CR1STR;
    #define SCI2CR1                     _SCI2ACR2.Byte
    #define SCI2CR1_PT                  _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.PT
    #define SCI2CR1_PE                  _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.PE
    #define SCI2CR1_ILT                 _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.ILT
    #define SCI2CR1_WAKE                _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.WAKE
    #define SCI2CR1_M                   _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.M
    #define SCI2CR1_RSRC                _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.RSRC
    #define SCI2CR1_SCISWAI             _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.SCISWAI
    #define SCI2CR1_LOOPS               _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.LOOPS
    
    #define SCI2CR1_PT_MASK             1U
    #define SCI2CR1_PE_MASK             2U
    #define SCI2CR1_ILT_MASK            4U
    #define SCI2CR1_WAKE_MASK           8U
    #define SCI2CR1_M_MASK              16U
    #define SCI2CR1_RSRC_MASK           32U
    #define SCI2CR1_SCISWAI_MASK        64U
    #define SCI2CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI2ACR2STR;
extern volatile SCI2ACR2STR _SCI2ACR2 @(REG_BASE + 0x000000BAUL);


/*** SCI2CR2 - SCI 2 Control Register 2; 0x000000BB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE         :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI2CR2STR;
extern volatile SCI2CR2STR _SCI2CR2 @(REG_BASE + 0x000000BBUL);
#define SCI2CR2                         _SCI2CR2.Byte
#define SCI2CR2_SBK                     _SCI2CR2.Bits.SBK
#define SCI2CR2_RWU                     _SCI2CR2.Bits.RWU
#define SCI2CR2_RE                      _SCI2CR2.Bits.RE
#define SCI2CR2_TE                      _SCI2CR2.Bits.TE
#define SCI2CR2_ILIE                    _SCI2CR2.Bits.ILIE
#define SCI2CR2_RIE                     _SCI2CR2.Bits.RIE
#define SCI2CR2_TCIE                    _SCI2CR2.Bits.TCIE
#define SCI2CR2_TIE                     _SCI2CR2.Bits.TIE

#define SCI2CR2_SBK_MASK                1U
#define SCI2CR2_RWU_MASK                2U
#define SCI2CR2_RE_MASK                 4U
#define SCI2CR2_TE_MASK                 8U
#define SCI2CR2_ILIE_MASK               16U
#define SCI2CR2_RIE_MASK                32U
#define SCI2CR2_TCIE_MASK               64U
#define SCI2CR2_TIE_MASK                128U


/*** SCI2SR1 - SCI 2 Status Register 1; 0x000000BC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF_bit    :1;                                       /* Receive Data Register Full Flag */ /*Warning: bit name is duplicated with register name*/
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI2SR1STR;
extern volatile SCI2SR1STR _SCI2SR1 @(REG_BASE + 0x000000BCUL);
#define SCI2SR1                         _SCI2SR1.Byte
#define SCI2SR1_PF                      _SCI2SR1.Bits.PF
#define SCI2SR1_FE                      _SCI2SR1.Bits.FE
#define SCI2SR1_NF                      _SCI2SR1.Bits.NF
#define SCI2SR1_OR                      _SCI2SR1.Bits.OR
#define SCI2SR1_IDLE                    _SCI2SR1.Bits.IDLE
#define SCI2SR1_RDRF                    _SCI2SR1.Bits.RDRF_bit
#define SCI2SR1_TC                      _SCI2SR1.Bits.TC
#define SCI2SR1_TDRE                    _SCI2SR1.Bits.TDRE

#define SCI2SR1_PF_MASK                 1U
#define SCI2SR1_FE_MASK                 2U
#define SCI2SR1_NF_MASK                 4U
#define SCI2SR1_OR_MASK                 8U
#define SCI2SR1_IDLE_MASK               16U
#define SCI2SR1_RDRF_MASK               32U
#define SCI2SR1_TC_MASK                 64U
#define SCI2SR1_TDRE_MASK               128U


/*** SCI2SR2 - SCI 2 Status Register 2; 0x000000BD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI2SR2STR;
extern volatile SCI2SR2STR _SCI2SR2 @(REG_BASE + 0x000000BDUL);
#define SCI2SR2                         _SCI2SR2.Byte
#define SCI2SR2_RAF                     _SCI2SR2.Bits.RAF
#define SCI2SR2_TXDIR                   _SCI2SR2.Bits.TXDIR
#define SCI2SR2_BRK13                   _SCI2SR2.Bits.BRK13
#define SCI2SR2_RXPOL                   _SCI2SR2.Bits.RXPOL
#define SCI2SR2_TXPOL                   _SCI2SR2.Bits.TXPOL
#define SCI2SR2_AMAP                    _SCI2SR2.Bits.AMAP

#define SCI2SR2_RAF_MASK                1U
#define SCI2SR2_TXDIR_MASK              2U
#define SCI2SR2_BRK13_MASK              4U
#define SCI2SR2_RXPOL_MASK              8U
#define SCI2SR2_TXPOL_MASK              16U
#define SCI2SR2_AMAP_MASK               128U


/*** SCI2DRH - SCI 2 Data Register High; 0x000000BE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI2DRHSTR;
extern volatile SCI2DRHSTR _SCI2DRH @(REG_BASE + 0x000000BEUL);
#define SCI2DRH                         _SCI2DRH.Byte
#define SCI2DRH_T8                      _SCI2DRH.Bits.T8
#define SCI2DRH_R8                      _SCI2DRH.Bits.R8

#define SCI2DRH_T8_MASK                 64U
#define SCI2DRH_R8_MASK                 128U


/*** SCI2DRL - SCI 2 Data Register Low; 0x000000BF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI2DRLSTR;
extern volatile SCI2DRLSTR _SCI2DRL @(REG_BASE + 0x000000BFUL);
#define SCI2DRL                         _SCI2DRL.Byte
#define SCI2DRL_R0_T0                   _SCI2DRL.Bits.R0_T0
#define SCI2DRL_R1_T1                   _SCI2DRL.Bits.R1_T1
#define SCI2DRL_R2_T2                   _SCI2DRL.Bits.R2_T2
#define SCI2DRL_R3_T3                   _SCI2DRL.Bits.R3_T3
#define SCI2DRL_R4_T4                   _SCI2DRL.Bits.R4_T4
#define SCI2DRL_R5_T5                   _SCI2DRL.Bits.R5_T5
#define SCI2DRL_R6_T6                   _SCI2DRL.Bits.R6_T6
#define SCI2DRL_R7_T7                   _SCI2DRL.Bits.R7_T7

#define SCI2DRL_R0_T0_MASK              1U
#define SCI2DRL_R1_T1_MASK              2U
#define SCI2DRL_R2_T2_MASK              4U
#define SCI2DRL_R3_T3_MASK              8U
#define SCI2DRL_R4_T4_MASK              16U
#define SCI2DRL_R5_T5_MASK              32U
#define SCI2DRL_R6_T6_MASK              64U
#define SCI2DRL_R7_T7_MASK              128U


/*** SCI3BD - SCI 3 Baud Rate Register; 0x000000C0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI3ASR1 - SCI 3 Alternative Status Register 1; 0x000000C0 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI3ASR1 - SCI 3 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI3ASR1STR;
        #define SCI3ASR1                _SCI3BD.Overlap_STR.SCI3ASR1STR.Byte
        #define SCI3ASR1_BKDIF          _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3ASR1STR.Bits.BKDIF
        #define SCI3ASR1_BERRIF         _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3ASR1STR.Bits.BERRIF
        #define SCI3ASR1_BERRV          _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3ASR1STR.Bits.BERRV
        #define SCI3ASR1_RXEDGIF        _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3ASR1STR.Bits.RXEDGIF
        
        #define SCI3ASR1_BKDIF_MASK     1U
        #define SCI3ASR1_BERRIF_MASK    2U
        #define SCI3ASR1_BERRV_MASK     4U
        #define SCI3ASR1_RXEDGIF_MASK   128U
        
        /*** SCI3BDH - SCI 3 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI3BDHSTR;
        #define SCI3BDH                 _SCI3BD.Overlap_STR.SCI3ASR1STR.Byte
        #define SCI3BDH_SBR8            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR8
        #define SCI3BDH_SBR9            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR9
        #define SCI3BDH_SBR10           _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR10
        #define SCI3BDH_SBR11           _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR11
        #define SCI3BDH_SBR12           _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR12
        #define SCI3BDH_TNP0            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.TNP0
        #define SCI3BDH_TNP1            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.TNP1
        #define SCI3BDH_IREN            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.IREN
        #define SCI3BDH_SBR_8           _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.MergedBits.grpSBR_8
        #define SCI3BDH_TNP             _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.MergedBits.grpTNP
        #define SCI3BDH_SBR             SCI3BDH_SBR_8
        
        #define SCI3BDH_SBR8_MASK       1U
        #define SCI3BDH_SBR9_MASK       2U
        #define SCI3BDH_SBR10_MASK      4U
        #define SCI3BDH_SBR11_MASK      8U
        #define SCI3BDH_SBR12_MASK      16U
        #define SCI3BDH_TNP0_MASK       32U
        #define SCI3BDH_TNP1_MASK       64U
        #define SCI3BDH_IREN_MASK       128U
        #define SCI3BDH_SBR_8_MASK      31U
        #define SCI3BDH_SBR_8_BITNUM    0U
        #define SCI3BDH_TNP_MASK        96U
        #define SCI3BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI3ASR1STR;
    

    /*** SCI3ACR1 - SCI 3 Alternative Control Register 1; 0x000000C1 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI3ACR1 - SCI 3 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI3ACR1STR;
        #define SCI3ACR1                _SCI3BD.Overlap_STR.SCI3ACR1STR.Byte
        #define SCI3ACR1_BKDIE          _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3ACR1STR.Bits.BKDIE
        #define SCI3ACR1_BERRIE         _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3ACR1STR.Bits.BERRIE
        #define SCI3ACR1_RXEDGIE        _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3ACR1STR.Bits.RXEDGIE
        
        #define SCI3ACR1_BKDIE_MASK     1U
        #define SCI3ACR1_BERRIE_MASK    2U
        #define SCI3ACR1_RXEDGIE_MASK   128U
        
        /*** SCI3BDL - SCI 3 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI3BDLSTR;
        #define SCI3BDL                 _SCI3BD.Overlap_STR.SCI3ACR1STR.Byte
        #define SCI3BDL_SBR0            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR0
        #define SCI3BDL_SBR1            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR1
        #define SCI3BDL_SBR2            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR2
        #define SCI3BDL_SBR3            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR3
        #define SCI3BDL_SBR4            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR4
        #define SCI3BDL_SBR5            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR5
        #define SCI3BDL_SBR6            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR6
        #define SCI3BDL_SBR7            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR7
        
        #define SCI3BDL_SBR0_MASK       1U
        #define SCI3BDL_SBR1_MASK       2U
        #define SCI3BDL_SBR2_MASK       4U
        #define SCI3BDL_SBR3_MASK       8U
        #define SCI3BDL_SBR4_MASK       16U
        #define SCI3BDL_SBR5_MASK       32U
        #define SCI3BDL_SBR6_MASK       64U
        #define SCI3BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI3ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI3BDSTR;
extern volatile SCI3BDSTR _SCI3BD @(REG_BASE + 0x000000C0UL);
#define SCI3BD                          _SCI3BD.Word
#define SCI3BD_SBR0                     _SCI3BD.Bits.SBR0
#define SCI3BD_SBR1                     _SCI3BD.Bits.SBR1
#define SCI3BD_SBR2                     _SCI3BD.Bits.SBR2
#define SCI3BD_SBR3                     _SCI3BD.Bits.SBR3
#define SCI3BD_SBR4                     _SCI3BD.Bits.SBR4
#define SCI3BD_SBR5                     _SCI3BD.Bits.SBR5
#define SCI3BD_SBR6                     _SCI3BD.Bits.SBR6
#define SCI3BD_SBR7                     _SCI3BD.Bits.SBR7
#define SCI3BD_SBR8                     _SCI3BD.Bits.SBR8
#define SCI3BD_SBR9                     _SCI3BD.Bits.SBR9
#define SCI3BD_SBR10                    _SCI3BD.Bits.SBR10
#define SCI3BD_SBR11                    _SCI3BD.Bits.SBR11
#define SCI3BD_SBR12                    _SCI3BD.Bits.SBR12
#define SCI3BD_TNP0                     _SCI3BD.Bits.TNP0
#define SCI3BD_TNP1                     _SCI3BD.Bits.TNP1
#define SCI3BD_IREN                     _SCI3BD.Bits.IREN
#define SCI3BD_SBR                      _SCI3BD.MergedBits.grpSBR
#define SCI3BD_TNP                      _SCI3BD.MergedBits.grpTNP

#define SCI3BD_SBR0_MASK                1U
#define SCI3BD_SBR1_MASK                2U
#define SCI3BD_SBR2_MASK                4U
#define SCI3BD_SBR3_MASK                8U
#define SCI3BD_SBR4_MASK                16U
#define SCI3BD_SBR5_MASK                32U
#define SCI3BD_SBR6_MASK                64U
#define SCI3BD_SBR7_MASK                128U
#define SCI3BD_SBR8_MASK                256U
#define SCI3BD_SBR9_MASK                512U
#define SCI3BD_SBR10_MASK               1024U
#define SCI3BD_SBR11_MASK               2048U
#define SCI3BD_SBR12_MASK               4096U
#define SCI3BD_TNP0_MASK                8192U
#define SCI3BD_TNP1_MASK                16384U
#define SCI3BD_IREN_MASK                32768U
#define SCI3BD_SBR_MASK                 8191U
#define SCI3BD_SBR_BITNUM               0U
#define SCI3BD_TNP_MASK                 24576U
#define SCI3BD_TNP_BITNUM               13U


/*** SCI3ACR2 - SCI 3 Alternative Control Register 2; 0x000000C2 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI3ACR2 - SCI 3 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI3ACR2STR;
    #define SCI3ACR2                    _SCI3ACR2.Byte
    #define SCI3ACR2_BKDFE              _SCI3ACR2.SameAddr_STR.SCI3ACR2STR.Bits.BKDFE
    #define SCI3ACR2_BERRM0             _SCI3ACR2.SameAddr_STR.SCI3ACR2STR.Bits.BERRM0
    #define SCI3ACR2_BERRM1             _SCI3ACR2.SameAddr_STR.SCI3ACR2STR.Bits.BERRM1
    #define SCI3ACR2_BERRM              _SCI3ACR2.SameAddr_STR.SCI3ACR2STR.MergedBits.grpBERRM
    
    #define SCI3ACR2_BKDFE_MASK         1U
    #define SCI3ACR2_BERRM0_MASK        2U
    #define SCI3ACR2_BERRM1_MASK        4U
    #define SCI3ACR2_BERRM_MASK         6U
    #define SCI3ACR2_BERRM_BITNUM       1U
    
    /*** SCI3CR1 - SCI 3 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI3CR1STR;
    #define SCI3CR1                     _SCI3ACR2.Byte
    #define SCI3CR1_PT                  _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.PT
    #define SCI3CR1_PE                  _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.PE
    #define SCI3CR1_ILT                 _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.ILT
    #define SCI3CR1_WAKE                _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.WAKE
    #define SCI3CR1_M                   _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.M
    #define SCI3CR1_RSRC                _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.RSRC
    #define SCI3CR1_SCISWAI             _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.SCISWAI
    #define SCI3CR1_LOOPS               _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.LOOPS
    
    #define SCI3CR1_PT_MASK             1U
    #define SCI3CR1_PE_MASK             2U
    #define SCI3CR1_ILT_MASK            4U
    #define SCI3CR1_WAKE_MASK           8U
    #define SCI3CR1_M_MASK              16U
    #define SCI3CR1_RSRC_MASK           32U
    #define SCI3CR1_SCISWAI_MASK        64U
    #define SCI3CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI3ACR2STR;
extern volatile SCI3ACR2STR _SCI3ACR2 @(REG_BASE + 0x000000C2UL);


/*** SCI3CR2 - SCI 3 Control Register 2; 0x000000C3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE         :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI3CR2STR;
extern volatile SCI3CR2STR _SCI3CR2 @(REG_BASE + 0x000000C3UL);
#define SCI3CR2                         _SCI3CR2.Byte
#define SCI3CR2_SBK                     _SCI3CR2.Bits.SBK
#define SCI3CR2_RWU                     _SCI3CR2.Bits.RWU
#define SCI3CR2_RE                      _SCI3CR2.Bits.RE
#define SCI3CR2_TE                      _SCI3CR2.Bits.TE
#define SCI3CR2_ILIE                    _SCI3CR2.Bits.ILIE
#define SCI3CR2_RIE                     _SCI3CR2.Bits.RIE
#define SCI3CR2_TCIE                    _SCI3CR2.Bits.TCIE
#define SCI3CR2_TIE                     _SCI3CR2.Bits.TIE

#define SCI3CR2_SBK_MASK                1U
#define SCI3CR2_RWU_MASK                2U
#define SCI3CR2_RE_MASK                 4U
#define SCI3CR2_TE_MASK                 8U
#define SCI3CR2_ILIE_MASK               16U
#define SCI3CR2_RIE_MASK                32U
#define SCI3CR2_TCIE_MASK               64U
#define SCI3CR2_TIE_MASK                128U


/*** SCI3SR1 - SCI 3 Status Register 1; 0x000000C4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF_bit    :1;                                       /* Receive Data Register Full Flag */ /*Warning: bit name is duplicated with register name*/
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI3SR1STR;
extern volatile SCI3SR1STR _SCI3SR1 @(REG_BASE + 0x000000C4UL);
#define SCI3SR1                         _SCI3SR1.Byte
#define SCI3SR1_PF                      _SCI3SR1.Bits.PF
#define SCI3SR1_FE                      _SCI3SR1.Bits.FE
#define SCI3SR1_NF                      _SCI3SR1.Bits.NF
#define SCI3SR1_OR                      _SCI3SR1.Bits.OR
#define SCI3SR1_IDLE                    _SCI3SR1.Bits.IDLE
#define SCI3SR1_RDRF                    _SCI3SR1.Bits.RDRF_bit
#define SCI3SR1_TC                      _SCI3SR1.Bits.TC
#define SCI3SR1_TDRE                    _SCI3SR1.Bits.TDRE

#define SCI3SR1_PF_MASK                 1U
#define SCI3SR1_FE_MASK                 2U
#define SCI3SR1_NF_MASK                 4U
#define SCI3SR1_OR_MASK                 8U
#define SCI3SR1_IDLE_MASK               16U
#define SCI3SR1_RDRF_MASK               32U
#define SCI3SR1_TC_MASK                 64U
#define SCI3SR1_TDRE_MASK               128U


/*** SCI3SR2 - SCI 3 Status Register 2; 0x000000C5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI3SR2STR;
extern volatile SCI3SR2STR _SCI3SR2 @(REG_BASE + 0x000000C5UL);
#define SCI3SR2                         _SCI3SR2.Byte
#define SCI3SR2_RAF                     _SCI3SR2.Bits.RAF
#define SCI3SR2_TXDIR                   _SCI3SR2.Bits.TXDIR
#define SCI3SR2_BRK13                   _SCI3SR2.Bits.BRK13
#define SCI3SR2_RXPOL                   _SCI3SR2.Bits.RXPOL
#define SCI3SR2_TXPOL                   _SCI3SR2.Bits.TXPOL
#define SCI3SR2_AMAP                    _SCI3SR2.Bits.AMAP

#define SCI3SR2_RAF_MASK                1U
#define SCI3SR2_TXDIR_MASK              2U
#define SCI3SR2_BRK13_MASK              4U
#define SCI3SR2_RXPOL_MASK              8U
#define SCI3SR2_TXPOL_MASK              16U
#define SCI3SR2_AMAP_MASK               128U


/*** SCI3DRH - SCI 3 Data Register High; 0x000000C6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI3DRHSTR;
extern volatile SCI3DRHSTR _SCI3DRH @(REG_BASE + 0x000000C6UL);
#define SCI3DRH                         _SCI3DRH.Byte
#define SCI3DRH_T8                      _SCI3DRH.Bits.T8
#define SCI3DRH_R8                      _SCI3DRH.Bits.R8

#define SCI3DRH_T8_MASK                 64U
#define SCI3DRH_R8_MASK                 128U


/*** SCI3DRL - SCI 3 Data Register Low; 0x000000C7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI3DRLSTR;
extern volatile SCI3DRLSTR _SCI3DRL @(REG_BASE + 0x000000C7UL);
#define SCI3DRL                         _SCI3DRL.Byte
#define SCI3DRL_R0_T0                   _SCI3DRL.Bits.R0_T0
#define SCI3DRL_R1_T1                   _SCI3DRL.Bits.R1_T1
#define SCI3DRL_R2_T2                   _SCI3DRL.Bits.R2_T2
#define SCI3DRL_R3_T3                   _SCI3DRL.Bits.R3_T3
#define SCI3DRL_R4_T4                   _SCI3DRL.Bits.R4_T4
#define SCI3DRL_R5_T5                   _SCI3DRL.Bits.R5_T5
#define SCI3DRL_R6_T6                   _SCI3DRL.Bits.R6_T6
#define SCI3DRL_R7_T7                   _SCI3DRL.Bits.R7_T7

#define SCI3DRL_R0_T0_MASK              1U
#define SCI3DRL_R1_T1_MASK              2U
#define SCI3DRL_R2_T2_MASK              4U
#define SCI3DRL_R3_T3_MASK              8U
#define SCI3DRL_R4_T4_MASK              16U
#define SCI3DRL_R5_T5_MASK              32U
#define SCI3DRL_R6_T6_MASK              64U
#define SCI3DRL_R7_T7_MASK              128U


/*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI0ASR1STR;
        #define SCI0ASR1                _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0ASR1_BKDIF          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BKDIF
        #define SCI0ASR1_BERRIF         _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRIF
        #define SCI0ASR1_BERRV          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRV
        #define SCI0ASR1_RXEDGIF        _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.RXEDGIF
        
        #define SCI0ASR1_BKDIF_MASK     1U
        #define SCI0ASR1_BERRIF_MASK    2U
        #define SCI0ASR1_BERRV_MASK     4U
        #define SCI0ASR1_RXEDGIF_MASK   128U
        
        /*** SCI0BDH - SCI 0 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI0BDHSTR;
        #define SCI0BDH                 _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0BDH_SBR8            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR8
        #define SCI0BDH_SBR9            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR9
        #define SCI0BDH_SBR10           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR10
        #define SCI0BDH_SBR11           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR11
        #define SCI0BDH_SBR12           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR12
        #define SCI0BDH_TNP0            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP0
        #define SCI0BDH_TNP1            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP1
        #define SCI0BDH_IREN            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.IREN
        #define SCI0BDH_SBR_8           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpSBR_8
        #define SCI0BDH_TNP             _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpTNP
        #define SCI0BDH_SBR             SCI0BDH_SBR_8
        
        #define SCI0BDH_SBR8_MASK       1U
        #define SCI0BDH_SBR9_MASK       2U
        #define SCI0BDH_SBR10_MASK      4U
        #define SCI0BDH_SBR11_MASK      8U
        #define SCI0BDH_SBR12_MASK      16U
        #define SCI0BDH_TNP0_MASK       32U
        #define SCI0BDH_TNP1_MASK       64U
        #define SCI0BDH_IREN_MASK       128U
        #define SCI0BDH_SBR_8_MASK      31U
        #define SCI0BDH_SBR_8_BITNUM    0U
        #define SCI0BDH_TNP_MASK        96U
        #define SCI0BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ASR1STR;
    

    /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI0ACR1STR;
        #define SCI0ACR1                _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0ACR1_BKDIE          _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BKDIE
        #define SCI0ACR1_BERRIE         _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BERRIE
        #define SCI0ACR1_RXEDGIE        _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.RXEDGIE
        
        #define SCI0ACR1_BKDIE_MASK     1U
        #define SCI0ACR1_BERRIE_MASK    2U
        #define SCI0ACR1_RXEDGIE_MASK   128U
        
        /*** SCI0BDL - SCI 0 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI0BDLSTR;
        #define SCI0BDL                 _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0BDL_SBR0            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR0
        #define SCI0BDL_SBR1            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR1
        #define SCI0BDL_SBR2            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR2
        #define SCI0BDL_SBR3            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR3
        #define SCI0BDL_SBR4            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR4
        #define SCI0BDL_SBR5            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR5
        #define SCI0BDL_SBR6            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR6
        #define SCI0BDL_SBR7            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR7
        
        #define SCI0BDL_SBR0_MASK       1U
        #define SCI0BDL_SBR1_MASK       2U
        #define SCI0BDL_SBR2_MASK       4U
        #define SCI0BDL_SBR3_MASK       8U
        #define SCI0BDL_SBR4_MASK       16U
        #define SCI0BDL_SBR5_MASK       32U
        #define SCI0BDL_SBR6_MASK       64U
        #define SCI0BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @(REG_BASE + 0x000000C8UL);
#define SCI0BD                          _SCI0BD.Word
#define SCI0BD_SBR0                     _SCI0BD.Bits.SBR0
#define SCI0BD_SBR1                     _SCI0BD.Bits.SBR1
#define SCI0BD_SBR2                     _SCI0BD.Bits.SBR2
#define SCI0BD_SBR3                     _SCI0BD.Bits.SBR3
#define SCI0BD_SBR4                     _SCI0BD.Bits.SBR4
#define SCI0BD_SBR5                     _SCI0BD.Bits.SBR5
#define SCI0BD_SBR6                     _SCI0BD.Bits.SBR6
#define SCI0BD_SBR7                     _SCI0BD.Bits.SBR7
#define SCI0BD_SBR8                     _SCI0BD.Bits.SBR8
#define SCI0BD_SBR9                     _SCI0BD.Bits.SBR9
#define SCI0BD_SBR10                    _SCI0BD.Bits.SBR10
#define SCI0BD_SBR11                    _SCI0BD.Bits.SBR11
#define SCI0BD_SBR12                    _SCI0BD.Bits.SBR12
#define SCI0BD_TNP0                     _SCI0BD.Bits.TNP0
#define SCI0BD_TNP1                     _SCI0BD.Bits.TNP1
#define SCI0BD_IREN                     _SCI0BD.Bits.IREN
#define SCI0BD_SBR                      _SCI0BD.MergedBits.grpSBR
#define SCI0BD_TNP                      _SCI0BD.MergedBits.grpTNP

#define SCI0BD_SBR0_MASK                1U
#define SCI0BD_SBR1_MASK                2U
#define SCI0BD_SBR2_MASK                4U
#define SCI0BD_SBR3_MASK                8U
#define SCI0BD_SBR4_MASK                16U
#define SCI0BD_SBR5_MASK                32U
#define SCI0BD_SBR6_MASK                64U
#define SCI0BD_SBR7_MASK                128U
#define SCI0BD_SBR8_MASK                256U
#define SCI0BD_SBR9_MASK                512U
#define SCI0BD_SBR10_MASK               1024U
#define SCI0BD_SBR11_MASK               2048U
#define SCI0BD_SBR12_MASK               4096U
#define SCI0BD_TNP0_MASK                8192U
#define SCI0BD_TNP1_MASK                16384U
#define SCI0BD_IREN_MASK                32768U
#define SCI0BD_SBR_MASK                 8191U
#define SCI0BD_SBR_BITNUM               0U
#define SCI0BD_TNP_MASK                 24576U
#define SCI0BD_TNP_BITNUM               13U


/*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI0ACR2 - SCI 0 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI0ACR2STR;
    #define SCI0ACR2                    _SCI0ACR2.Byte
    #define SCI0ACR2_BKDFE              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BKDFE
    #define SCI0ACR2_BERRM0             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM0
    #define SCI0ACR2_BERRM1             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM1
    #define SCI0ACR2_BERRM              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.MergedBits.grpBERRM
    
    #define SCI0ACR2_BKDFE_MASK         1U
    #define SCI0ACR2_BERRM0_MASK        2U
    #define SCI0ACR2_BERRM1_MASK        4U
    #define SCI0ACR2_BERRM_MASK         6U
    #define SCI0ACR2_BERRM_BITNUM       1U
    
    /*** SCI0CR1 - SCI 0 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI0CR1STR;
    #define SCI0CR1                     _SCI0ACR2.Byte
    #define SCI0CR1_PT                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PT
    #define SCI0CR1_PE                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PE
    #define SCI0CR1_ILT                 _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.ILT
    #define SCI0CR1_WAKE                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.WAKE
    #define SCI0CR1_M                   _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.M
    #define SCI0CR1_RSRC                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.RSRC
    #define SCI0CR1_SCISWAI             _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.SCISWAI
    #define SCI0CR1_LOOPS               _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.LOOPS
    
    #define SCI0CR1_PT_MASK             1U
    #define SCI0CR1_PE_MASK             2U
    #define SCI0CR1_ILT_MASK            4U
    #define SCI0CR1_WAKE_MASK           8U
    #define SCI0CR1_M_MASK              16U
    #define SCI0CR1_RSRC_MASK           32U
    #define SCI0CR1_SCISWAI_MASK        64U
    #define SCI0CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI0ACR2STR;
extern volatile SCI0ACR2STR _SCI0ACR2 @(REG_BASE + 0x000000CAUL);


/*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE         :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI0CR2STR;
extern volatile SCI0CR2STR _SCI0CR2 @(REG_BASE + 0x000000CBUL);
#define SCI0CR2                         _SCI0CR2.Byte
#define SCI0CR2_SBK                     _SCI0CR2.Bits.SBK
#define SCI0CR2_RWU                     _SCI0CR2.Bits.RWU
#define SCI0CR2_RE                      _SCI0CR2.Bits.RE
#define SCI0CR2_TE                      _SCI0CR2.Bits.TE
#define SCI0CR2_ILIE                    _SCI0CR2.Bits.ILIE
#define SCI0CR2_RIE                     _SCI0CR2.Bits.RIE
#define SCI0CR2_TCIE                    _SCI0CR2.Bits.TCIE
#define SCI0CR2_TIE                     _SCI0CR2.Bits.TIE

#define SCI0CR2_SBK_MASK                1U
#define SCI0CR2_RWU_MASK                2U
#define SCI0CR2_RE_MASK                 4U
#define SCI0CR2_TE_MASK                 8U
#define SCI0CR2_ILIE_MASK               16U
#define SCI0CR2_RIE_MASK                32U
#define SCI0CR2_TCIE_MASK               64U
#define SCI0CR2_TIE_MASK                128U


/*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF_bit    :1;                                       /* Receive Data Register Full Flag */ /*Warning: bit name is duplicated with register name*/
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0SR1STR;
extern volatile SCI0SR1STR _SCI0SR1 @(REG_BASE + 0x000000CCUL);
#define SCI0SR1                         _SCI0SR1.Byte
#define SCI0SR1_PF                      _SCI0SR1.Bits.PF
#define SCI0SR1_FE                      _SCI0SR1.Bits.FE
#define SCI0SR1_NF                      _SCI0SR1.Bits.NF
#define SCI0SR1_OR                      _SCI0SR1.Bits.OR
#define SCI0SR1_IDLE                    _SCI0SR1.Bits.IDLE
#define SCI0SR1_RDRF                    _SCI0SR1.Bits.RDRF_bit
#define SCI0SR1_TC                      _SCI0SR1.Bits.TC
#define SCI0SR1_TDRE                    _SCI0SR1.Bits.TDRE

#define SCI0SR1_PF_MASK                 1U
#define SCI0SR1_FE_MASK                 2U
#define SCI0SR1_NF_MASK                 4U
#define SCI0SR1_OR_MASK                 8U
#define SCI0SR1_IDLE_MASK               16U
#define SCI0SR1_RDRF_MASK               32U
#define SCI0SR1_TC_MASK                 64U
#define SCI0SR1_TDRE_MASK               128U


/*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI0SR2STR;
extern volatile SCI0SR2STR _SCI0SR2 @(REG_BASE + 0x000000CDUL);
#define SCI0SR2                         _SCI0SR2.Byte
#define SCI0SR2_RAF                     _SCI0SR2.Bits.RAF
#define SCI0SR2_TXDIR                   _SCI0SR2.Bits.TXDIR
#define SCI0SR2_BRK13                   _SCI0SR2.Bits.BRK13
#define SCI0SR2_RXPOL                   _SCI0SR2.Bits.RXPOL
#define SCI0SR2_TXPOL                   _SCI0SR2.Bits.TXPOL
#define SCI0SR2_AMAP                    _SCI0SR2.Bits.AMAP

#define SCI0SR2_RAF_MASK                1U
#define SCI0SR2_TXDIR_MASK              2U
#define SCI0SR2_BRK13_MASK              4U
#define SCI0SR2_RXPOL_MASK              8U
#define SCI0SR2_TXPOL_MASK              16U
#define SCI0SR2_AMAP_MASK               128U


/*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI0DRHSTR;
extern volatile SCI0DRHSTR _SCI0DRH @(REG_BASE + 0x000000CEUL);
#define SCI0DRH                         _SCI0DRH.Byte
#define SCI0DRH_T8                      _SCI0DRH.Bits.T8
#define SCI0DRH_R8                      _SCI0DRH.Bits.R8

#define SCI0DRH_T8_MASK                 64U
#define SCI0DRH_R8_MASK                 128U


/*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI0DRLSTR;
extern volatile SCI0DRLSTR _SCI0DRL @(REG_BASE + 0x000000CFUL);
#define SCI0DRL                         _SCI0DRL.Byte
#define SCI0DRL_R0_T0                   _SCI0DRL.Bits.R0_T0
#define SCI0DRL_R1_T1                   _SCI0DRL.Bits.R1_T1
#define SCI0DRL_R2_T2                   _SCI0DRL.Bits.R2_T2
#define SCI0DRL_R3_T3                   _SCI0DRL.Bits.R3_T3
#define SCI0DRL_R4_T4                   _SCI0DRL.Bits.R4_T4
#define SCI0DRL_R5_T5                   _SCI0DRL.Bits.R5_T5
#define SCI0DRL_R6_T6                   _SCI0DRL.Bits.R6_T6
#define SCI0DRL_R7_T7                   _SCI0DRL.Bits.R7_T7

#define SCI0DRL_R0_T0_MASK              1U
#define SCI0DRL_R1_T1_MASK              2U
#define SCI0DRL_R2_T2_MASK              4U
#define SCI0DRL_R3_T3_MASK              8U
#define SCI0DRL_R4_T4_MASK              16U
#define SCI0DRL_R5_T5_MASK              32U
#define SCI0DRL_R6_T6_MASK              64U
#define SCI0DRL_R7_T7_MASK              128U


/*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI1ASR1STR;
        #define SCI1ASR1                _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1ASR1_BKDIF          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BKDIF
        #define SCI1ASR1_BERRIF         _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRIF
        #define SCI1ASR1_BERRV          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRV
        #define SCI1ASR1_RXEDGIF        _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.RXEDGIF
        
        #define SCI1ASR1_BKDIF_MASK     1U
        #define SCI1ASR1_BERRIF_MASK    2U
        #define SCI1ASR1_BERRV_MASK     4U
        #define SCI1ASR1_RXEDGIF_MASK   128U
        
        /*** SCI1BDH - SCI 1 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI1BDHSTR;
        #define SCI1BDH                 _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1BDH_SBR8            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR8
        #define SCI1BDH_SBR9            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR9
        #define SCI1BDH_SBR10           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR10
        #define SCI1BDH_SBR11           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR11
        #define SCI1BDH_SBR12           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR12
        #define SCI1BDH_TNP0            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP0
        #define SCI1BDH_TNP1            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP1
        #define SCI1BDH_IREN            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.IREN
        #define SCI1BDH_SBR_8           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpSBR_8
        #define SCI1BDH_TNP             _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpTNP
        #define SCI1BDH_SBR             SCI1BDH_SBR_8
        
        #define SCI1BDH_SBR8_MASK       1U
        #define SCI1BDH_SBR9_MASK       2U
        #define SCI1BDH_SBR10_MASK      4U
        #define SCI1BDH_SBR11_MASK      8U
        #define SCI1BDH_SBR12_MASK      16U
        #define SCI1BDH_TNP0_MASK       32U
        #define SCI1BDH_TNP1_MASK       64U
        #define SCI1BDH_IREN_MASK       128U
        #define SCI1BDH_SBR_8_MASK      31U
        #define SCI1BDH_SBR_8_BITNUM    0U
        #define SCI1BDH_TNP_MASK        96U
        #define SCI1BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ASR1STR;
    

    /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI1ACR1STR;
        #define SCI1ACR1                _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1ACR1_BKDIE          _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BKDIE
        #define SCI1ACR1_BERRIE         _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BERRIE
        #define SCI1ACR1_RXEDGIE        _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.RXEDGIE
        
        #define SCI1ACR1_BKDIE_MASK     1U
        #define SCI1ACR1_BERRIE_MASK    2U
        #define SCI1ACR1_RXEDGIE_MASK   128U
        
        /*** SCI1BDL - SCI 1 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI1BDLSTR;
        #define SCI1BDL                 _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1BDL_SBR0            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR0
        #define SCI1BDL_SBR1            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR1
        #define SCI1BDL_SBR2            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR2
        #define SCI1BDL_SBR3            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR3
        #define SCI1BDL_SBR4            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR4
        #define SCI1BDL_SBR5            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR5
        #define SCI1BDL_SBR6            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR6
        #define SCI1BDL_SBR7            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR7
        
        #define SCI1BDL_SBR0_MASK       1U
        #define SCI1BDL_SBR1_MASK       2U
        #define SCI1BDL_SBR2_MASK       4U
        #define SCI1BDL_SBR3_MASK       8U
        #define SCI1BDL_SBR4_MASK       16U
        #define SCI1BDL_SBR5_MASK       32U
        #define SCI1BDL_SBR6_MASK       64U
        #define SCI1BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI1BDSTR;
extern volatile SCI1BDSTR _SCI1BD @(REG_BASE + 0x000000D0UL);
#define SCI1BD                          _SCI1BD.Word
#define SCI1BD_SBR0                     _SCI1BD.Bits.SBR0
#define SCI1BD_SBR1                     _SCI1BD.Bits.SBR1
#define SCI1BD_SBR2                     _SCI1BD.Bits.SBR2
#define SCI1BD_SBR3                     _SCI1BD.Bits.SBR3
#define SCI1BD_SBR4                     _SCI1BD.Bits.SBR4
#define SCI1BD_SBR5                     _SCI1BD.Bits.SBR5
#define SCI1BD_SBR6                     _SCI1BD.Bits.SBR6
#define SCI1BD_SBR7                     _SCI1BD.Bits.SBR7
#define SCI1BD_SBR8                     _SCI1BD.Bits.SBR8
#define SCI1BD_SBR9                     _SCI1BD.Bits.SBR9
#define SCI1BD_SBR10                    _SCI1BD.Bits.SBR10
#define SCI1BD_SBR11                    _SCI1BD.Bits.SBR11
#define SCI1BD_SBR12                    _SCI1BD.Bits.SBR12
#define SCI1BD_TNP0                     _SCI1BD.Bits.TNP0
#define SCI1BD_TNP1                     _SCI1BD.Bits.TNP1
#define SCI1BD_IREN                     _SCI1BD.Bits.IREN
#define SCI1BD_SBR                      _SCI1BD.MergedBits.grpSBR
#define SCI1BD_TNP                      _SCI1BD.MergedBits.grpTNP

#define SCI1BD_SBR0_MASK                1U
#define SCI1BD_SBR1_MASK                2U
#define SCI1BD_SBR2_MASK                4U
#define SCI1BD_SBR3_MASK                8U
#define SCI1BD_SBR4_MASK                16U
#define SCI1BD_SBR5_MASK                32U
#define SCI1BD_SBR6_MASK                64U
#define SCI1BD_SBR7_MASK                128U
#define SCI1BD_SBR8_MASK                256U
#define SCI1BD_SBR9_MASK                512U
#define SCI1BD_SBR10_MASK               1024U
#define SCI1BD_SBR11_MASK               2048U
#define SCI1BD_SBR12_MASK               4096U
#define SCI1BD_TNP0_MASK                8192U
#define SCI1BD_TNP1_MASK                16384U
#define SCI1BD_IREN_MASK                32768U
#define SCI1BD_SBR_MASK                 8191U
#define SCI1BD_SBR_BITNUM               0U
#define SCI1BD_TNP_MASK                 24576U
#define SCI1BD_TNP_BITNUM               13U


/*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI1ACR2 - SCI 1 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI1ACR2STR;
    #define SCI1ACR2                    _SCI1ACR2.Byte
    #define SCI1ACR2_BKDFE              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BKDFE
    #define SCI1ACR2_BERRM0             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM0
    #define SCI1ACR2_BERRM1             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM1
    #define SCI1ACR2_BERRM              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.MergedBits.grpBERRM
    
    #define SCI1ACR2_BKDFE_MASK         1U
    #define SCI1ACR2_BERRM0_MASK        2U
    #define SCI1ACR2_BERRM1_MASK        4U
    #define SCI1ACR2_BERRM_MASK         6U
    #define SCI1ACR2_BERRM_BITNUM       1U
    
    /*** SCI1CR1 - SCI 1 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI1CR1STR;
    #define SCI1CR1                     _SCI1ACR2.Byte
    #define SCI1CR1_PT                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PT
    #define SCI1CR1_PE                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PE
    #define SCI1CR1_ILT                 _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.ILT
    #define SCI1CR1_WAKE                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.WAKE
    #define SCI1CR1_M                   _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.M
    #define SCI1CR1_RSRC                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.RSRC
    #define SCI1CR1_SCISWAI             _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.SCISWAI
    #define SCI1CR1_LOOPS               _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.LOOPS
    
    #define SCI1CR1_PT_MASK             1U
    #define SCI1CR1_PE_MASK             2U
    #define SCI1CR1_ILT_MASK            4U
    #define SCI1CR1_WAKE_MASK           8U
    #define SCI1CR1_M_MASK              16U
    #define SCI1CR1_RSRC_MASK           32U
    #define SCI1CR1_SCISWAI_MASK        64U
    #define SCI1CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI1ACR2STR;
extern volatile SCI1ACR2STR _SCI1ACR2 @(REG_BASE + 0x000000D2UL);


/*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE         :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI1CR2STR;
extern volatile SCI1CR2STR _SCI1CR2 @(REG_BASE + 0x000000D3UL);
#define SCI1CR2                         _SCI1CR2.Byte
#define SCI1CR2_SBK                     _SCI1CR2.Bits.SBK
#define SCI1CR2_RWU                     _SCI1CR2.Bits.RWU
#define SCI1CR2_RE                      _SCI1CR2.Bits.RE
#define SCI1CR2_TE                      _SCI1CR2.Bits.TE
#define SCI1CR2_ILIE                    _SCI1CR2.Bits.ILIE
#define SCI1CR2_RIE                     _SCI1CR2.Bits.RIE
#define SCI1CR2_TCIE                    _SCI1CR2.Bits.TCIE
#define SCI1CR2_TIE                     _SCI1CR2.Bits.TIE

#define SCI1CR2_SBK_MASK                1U
#define SCI1CR2_RWU_MASK                2U
#define SCI1CR2_RE_MASK                 4U
#define SCI1CR2_TE_MASK                 8U
#define SCI1CR2_ILIE_MASK               16U
#define SCI1CR2_RIE_MASK                32U
#define SCI1CR2_TCIE_MASK               64U
#define SCI1CR2_TIE_MASK                128U


/*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF_bit    :1;                                       /* Receive Data Register Full Flag */ /*Warning: bit name is duplicated with register name*/
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI1SR1STR;
extern volatile SCI1SR1STR _SCI1SR1 @(REG_BASE + 0x000000D4UL);
#define SCI1SR1                         _SCI1SR1.Byte
#define SCI1SR1_PF                      _SCI1SR1.Bits.PF
#define SCI1SR1_FE                      _SCI1SR1.Bits.FE
#define SCI1SR1_NF                      _SCI1SR1.Bits.NF
#define SCI1SR1_OR                      _SCI1SR1.Bits.OR
#define SCI1SR1_IDLE                    _SCI1SR1.Bits.IDLE
#define SCI1SR1_RDRF                    _SCI1SR1.Bits.RDRF_bit
#define SCI1SR1_TC                      _SCI1SR1.Bits.TC
#define SCI1SR1_TDRE                    _SCI1SR1.Bits.TDRE

#define SCI1SR1_PF_MASK                 1U
#define SCI1SR1_FE_MASK                 2U
#define SCI1SR1_NF_MASK                 4U
#define SCI1SR1_OR_MASK                 8U
#define SCI1SR1_IDLE_MASK               16U
#define SCI1SR1_RDRF_MASK               32U
#define SCI1SR1_TC_MASK                 64U
#define SCI1SR1_TDRE_MASK               128U


/*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI1SR2STR;
extern volatile SCI1SR2STR _SCI1SR2 @(REG_BASE + 0x000000D5UL);
#define SCI1SR2                         _SCI1SR2.Byte
#define SCI1SR2_RAF                     _SCI1SR2.Bits.RAF
#define SCI1SR2_TXDIR                   _SCI1SR2.Bits.TXDIR
#define SCI1SR2_BRK13                   _SCI1SR2.Bits.BRK13
#define SCI1SR2_RXPOL                   _SCI1SR2.Bits.RXPOL
#define SCI1SR2_TXPOL                   _SCI1SR2.Bits.TXPOL
#define SCI1SR2_AMAP                    _SCI1SR2.Bits.AMAP

#define SCI1SR2_RAF_MASK                1U
#define SCI1SR2_TXDIR_MASK              2U
#define SCI1SR2_BRK13_MASK              4U
#define SCI1SR2_RXPOL_MASK              8U
#define SCI1SR2_TXPOL_MASK              16U
#define SCI1SR2_AMAP_MASK               128U


/*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI1DRHSTR;
extern volatile SCI1DRHSTR _SCI1DRH @(REG_BASE + 0x000000D6UL);
#define SCI1DRH                         _SCI1DRH.Byte
#define SCI1DRH_T8                      _SCI1DRH.Bits.T8
#define SCI1DRH_R8                      _SCI1DRH.Bits.R8

#define SCI1DRH_T8_MASK                 64U
#define SCI1DRH_R8_MASK                 128U


/*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI1DRLSTR;
extern volatile SCI1DRLSTR _SCI1DRL @(REG_BASE + 0x000000D7UL);
#define SCI1DRL                         _SCI1DRL.Byte
#define SCI1DRL_R0_T0                   _SCI1DRL.Bits.R0_T0
#define SCI1DRL_R1_T1                   _SCI1DRL.Bits.R1_T1
#define SCI1DRL_R2_T2                   _SCI1DRL.Bits.R2_T2
#define SCI1DRL_R3_T3                   _SCI1DRL.Bits.R3_T3
#define SCI1DRL_R4_T4                   _SCI1DRL.Bits.R4_T4
#define SCI1DRL_R5_T5                   _SCI1DRL.Bits.R5_T5
#define SCI1DRL_R6_T6                   _SCI1DRL.Bits.R6_T6
#define SCI1DRL_R7_T7                   _SCI1DRL.Bits.R7_T7

#define SCI1DRL_R0_T0_MASK              1U
#define SCI1DRL_R1_T1_MASK              2U
#define SCI1DRL_R2_T2_MASK              4U
#define SCI1DRL_R3_T3_MASK              8U
#define SCI1DRL_R4_T4_MASK              16U
#define SCI1DRL_R5_T5_MASK              32U
#define SCI1DRL_R6_T6_MASK              64U
#define SCI1DRL_R7_T7_MASK              128U


/*** SPI0CR1 - SPI 0 Control Register 1; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI0CR1STR;
extern volatile SPI0CR1STR _SPI0CR1 @(REG_BASE + 0x000000D8UL);
#define SPI0CR1                         _SPI0CR1.Byte
#define SPI0CR1_LSBFE                   _SPI0CR1.Bits.LSBFE
#define SPI0CR1_SSOE                    _SPI0CR1.Bits.SSOE
#define SPI0CR1_CPHA                    _SPI0CR1.Bits.CPHA
#define SPI0CR1_CPOL                    _SPI0CR1.Bits.CPOL
#define SPI0CR1_MSTR                    _SPI0CR1.Bits.MSTR
#define SPI0CR1_SPTIE                   _SPI0CR1.Bits.SPTIE
#define SPI0CR1_SPE                     _SPI0CR1.Bits.SPE
#define SPI0CR1_SPIE                    _SPI0CR1.Bits.SPIE

#define SPI0CR1_LSBFE_MASK              1U
#define SPI0CR1_SSOE_MASK               2U
#define SPI0CR1_CPHA_MASK               4U
#define SPI0CR1_CPOL_MASK               8U
#define SPI0CR1_MSTR_MASK               16U
#define SPI0CR1_SPTIE_MASK              32U
#define SPI0CR1_SPE_MASK                64U
#define SPI0CR1_SPIE_MASK               128U


/*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte XFRW        :1;                                       /* Transfer Width */
    byte             :1; 
  } Bits;
} SPI0CR2STR;
extern volatile SPI0CR2STR _SPI0CR2 @(REG_BASE + 0x000000D9UL);
#define SPI0CR2                         _SPI0CR2.Byte
#define SPI0CR2_SPC0                    _SPI0CR2.Bits.SPC0
#define SPI0CR2_SPISWAI                 _SPI0CR2.Bits.SPISWAI
#define SPI0CR2_BIDIROE                 _SPI0CR2.Bits.BIDIROE
#define SPI0CR2_MODFEN                  _SPI0CR2.Bits.MODFEN
#define SPI0CR2_XFRW                    _SPI0CR2.Bits.XFRW

#define SPI0CR2_SPC0_MASK               1U
#define SPI0CR2_SPISWAI_MASK            2U
#define SPI0CR2_BIDIROE_MASK            8U
#define SPI0CR2_MODFEN_MASK             16U
#define SPI0CR2_XFRW_MASK               64U


/*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI0BRSTR;
extern volatile SPI0BRSTR _SPI0BR @(REG_BASE + 0x000000DAUL);
#define SPI0BR                          _SPI0BR.Byte
#define SPI0BR_SPR0                     _SPI0BR.Bits.SPR0
#define SPI0BR_SPR1                     _SPI0BR.Bits.SPR1
#define SPI0BR_SPR2                     _SPI0BR.Bits.SPR2
#define SPI0BR_SPPR0                    _SPI0BR.Bits.SPPR0
#define SPI0BR_SPPR1                    _SPI0BR.Bits.SPPR1
#define SPI0BR_SPPR2                    _SPI0BR.Bits.SPPR2
#define SPI0BR_SPR                      _SPI0BR.MergedBits.grpSPR
#define SPI0BR_SPPR                     _SPI0BR.MergedBits.grpSPPR

#define SPI0BR_SPR0_MASK                1U
#define SPI0BR_SPR1_MASK                2U
#define SPI0BR_SPR2_MASK                4U
#define SPI0BR_SPPR0_MASK               16U
#define SPI0BR_SPPR1_MASK               32U
#define SPI0BR_SPPR2_MASK               64U
#define SPI0BR_SPR_MASK                 7U
#define SPI0BR_SPR_BITNUM               0U
#define SPI0BR_SPPR_MASK                112U
#define SPI0BR_SPPR_BITNUM              4U


/*** SPI0SR - SPI 0 Status Register; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI0SRSTR;
extern volatile SPI0SRSTR _SPI0SR @(REG_BASE + 0x000000DBUL);
#define SPI0SR                          _SPI0SR.Byte
#define SPI0SR_MODF                     _SPI0SR.Bits.MODF
#define SPI0SR_SPTEF                    _SPI0SR.Bits.SPTEF
#define SPI0SR_SPIF                     _SPI0SR.Bits.SPIF

#define SPI0SR_MODF_MASK                16U
#define SPI0SR_SPTEF_MASK               32U
#define SPI0SR_SPIF_MASK                128U


/*** SPI0DR - SPI 0 Data Register; 0x000000DC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SPI0DRH - SPI 0 Data Register High; 0x000000DC ***/
    union {
      byte Byte;
      struct {
        byte R8_T8       :1;                                       /* SPI 0 Data Bit 8 */
        byte R9_T9       :1;                                       /* SPI 0 Data Bit 9 */
        byte R10_T10     :1;                                       /* SPI 0 Data Bit 10 */
        byte R11_T11     :1;                                       /* SPI 0 Data Bit 11 */
        byte R12_T12     :1;                                       /* SPI 0 Data Bit 12 */
        byte R13_T13     :1;                                       /* SPI 0 Data Bit 13 */
        byte R14_T14     :1;                                       /* SPI 0 Data Bit 14 */
        byte R15_T15     :1;                                       /* SPI 0 Data Bit 15 */
      } Bits;
    } SPI0DRHSTR;
    #define SPI0DRH                     _SPI0DR.Overlap_STR.SPI0DRHSTR.Byte
    #define SPI0DRH_R8_T8               _SPI0DR.Overlap_STR.SPI0DRHSTR.Bits.R8_T8
    #define SPI0DRH_R9_T9               _SPI0DR.Overlap_STR.SPI0DRHSTR.Bits.R9_T9
    #define SPI0DRH_R10_T10             _SPI0DR.Overlap_STR.SPI0DRHSTR.Bits.R10_T10
    #define SPI0DRH_R11_T11             _SPI0DR.Overlap_STR.SPI0DRHSTR.Bits.R11_T11
    #define SPI0DRH_R12_T12             _SPI0DR.Overlap_STR.SPI0DRHSTR.Bits.R12_T12
    #define SPI0DRH_R13_T13             _SPI0DR.Overlap_STR.SPI0DRHSTR.Bits.R13_T13
    #define SPI0DRH_R14_T14             _SPI0DR.Overlap_STR.SPI0DRHSTR.Bits.R14_T14
    #define SPI0DRH_R15_T15             _SPI0DR.Overlap_STR.SPI0DRHSTR.Bits.R15_T15
    
    #define SPI0DRH_R8_T8_MASK          1U
    #define SPI0DRH_R9_T9_MASK          2U
    #define SPI0DRH_R10_T10_MASK        4U
    #define SPI0DRH_R11_T11_MASK        8U
    #define SPI0DRH_R12_T12_MASK        16U
    #define SPI0DRH_R13_T13_MASK        32U
    #define SPI0DRH_R14_T14_MASK        64U
    #define SPI0DRH_R15_T15_MASK        128U
    

    /*** SPI0DRL - SPI 0 Data Register Low; 0x000000DD ***/
    union {
      byte Byte;
      struct {
        byte R0_T0       :1;                                       /* SPI 0 Data Bit 0 */
        byte R1_T1       :1;                                       /* SPI 0 Data Bit 1 */
        byte R2_T2       :1;                                       /* SPI 0 Data Bit 2 */
        byte R3_T3       :1;                                       /* SPI 0 Data Bit 3 */
        byte R4_T4       :1;                                       /* SPI 0 Data Bit 4 */
        byte R5_T5       :1;                                       /* SPI 0 Data Bit 5 */
        byte R6_T6       :1;                                       /* SPI 0 Data Bit 6 */
        byte R7_T7       :1;                                       /* SPI 0 Data Bit 7 */
      } Bits;
    } SPI0DRLSTR;
    #define SPI0DRL                     _SPI0DR.Overlap_STR.SPI0DRLSTR.Byte
    #define SPI0DRL_R0_T0               _SPI0DR.Overlap_STR.SPI0DRLSTR.Bits.R0_T0
    #define SPI0DRL_R1_T1               _SPI0DR.Overlap_STR.SPI0DRLSTR.Bits.R1_T1
    #define SPI0DRL_R2_T2               _SPI0DR.Overlap_STR.SPI0DRLSTR.Bits.R2_T2
    #define SPI0DRL_R3_T3               _SPI0DR.Overlap_STR.SPI0DRLSTR.Bits.R3_T3
    #define SPI0DRL_R4_T4               _SPI0DR.Overlap_STR.SPI0DRLSTR.Bits.R4_T4
    #define SPI0DRL_R5_T5               _SPI0DR.Overlap_STR.SPI0DRLSTR.Bits.R5_T5
    #define SPI0DRL_R6_T6               _SPI0DR.Overlap_STR.SPI0DRLSTR.Bits.R6_T6
    #define SPI0DRL_R7_T7               _SPI0DR.Overlap_STR.SPI0DRLSTR.Bits.R7_T7
    
    #define SPI0DRL_R0_T0_MASK          1U
    #define SPI0DRL_R1_T1_MASK          2U
    #define SPI0DRL_R2_T2_MASK          4U
    #define SPI0DRL_R3_T3_MASK          8U
    #define SPI0DRL_R4_T4_MASK          16U
    #define SPI0DRL_R5_T5_MASK          32U
    #define SPI0DRL_R6_T6_MASK          64U
    #define SPI0DRL_R7_T7_MASK          128U
    
  } Overlap_STR;

  struct {
    word R0_T0       :1;                                       /* SPI 0 Data Bit 0 */
    word R1_T1       :1;                                       /* SPI 0 Data Bit 1 */
    word R2_T2       :1;                                       /* SPI 0 Data Bit 2 */
    word R3_T3       :1;                                       /* SPI 0 Data Bit 3 */
    word R4_T4       :1;                                       /* SPI 0 Data Bit 4 */
    word R5_T5       :1;                                       /* SPI 0 Data Bit 5 */
    word R6_T6       :1;                                       /* SPI 0 Data Bit 6 */
    word R7_T7       :1;                                       /* SPI 0 Data Bit 7 */
    word R8_T8       :1;                                       /* SPI 0 Data Bit 8 */
    word R9_T9       :1;                                       /* SPI 0 Data Bit 9 */
    word R10_T10     :1;                                       /* SPI 0 Data Bit 10 */
    word R11_T11     :1;                                       /* SPI 0 Data Bit 11 */
    word R12_T12     :1;                                       /* SPI 0 Data Bit 12 */
    word R13_T13     :1;                                       /* SPI 0 Data Bit 13 */
    word R14_T14     :1;                                       /* SPI 0 Data Bit 14 */
    word R15_T15     :1;                                       /* SPI 0 Data Bit 15 */
  } Bits;
} SPI0DRSTR;
extern volatile SPI0DRSTR _SPI0DR @(REG_BASE + 0x000000DCUL);
#define SPI0DR                          _SPI0DR.Word
#define SPI0DR_R0_T0                    _SPI0DR.Bits.R0_T0
#define SPI0DR_R1_T1                    _SPI0DR.Bits.R1_T1
#define SPI0DR_R2_T2                    _SPI0DR.Bits.R2_T2
#define SPI0DR_R3_T3                    _SPI0DR.Bits.R3_T3
#define SPI0DR_R4_T4                    _SPI0DR.Bits.R4_T4
#define SPI0DR_R5_T5                    _SPI0DR.Bits.R5_T5
#define SPI0DR_R6_T6                    _SPI0DR.Bits.R6_T6
#define SPI0DR_R7_T7                    _SPI0DR.Bits.R7_T7
#define SPI0DR_R8_T8                    _SPI0DR.Bits.R8_T8
#define SPI0DR_R9_T9                    _SPI0DR.Bits.R9_T9
#define SPI0DR_R10_T10                  _SPI0DR.Bits.R10_T10
#define SPI0DR_R11_T11                  _SPI0DR.Bits.R11_T11
#define SPI0DR_R12_T12                  _SPI0DR.Bits.R12_T12
#define SPI0DR_R13_T13                  _SPI0DR.Bits.R13_T13
#define SPI0DR_R14_T14                  _SPI0DR.Bits.R14_T14
#define SPI0DR_R15_T15                  _SPI0DR.Bits.R15_T15

#define SPI0DR_R0_T0_MASK               1U
#define SPI0DR_R1_T1_MASK               2U
#define SPI0DR_R2_T2_MASK               4U
#define SPI0DR_R3_T3_MASK               8U
#define SPI0DR_R4_T4_MASK               16U
#define SPI0DR_R5_T5_MASK               32U
#define SPI0DR_R6_T6_MASK               64U
#define SPI0DR_R7_T7_MASK               128U
#define SPI0DR_R8_T8_MASK               256U
#define SPI0DR_R9_T9_MASK               512U
#define SPI0DR_R10_T10_MASK             1024U
#define SPI0DR_R11_T11_MASK             2048U
#define SPI0DR_R12_T12_MASK             4096U
#define SPI0DR_R13_T13_MASK             8192U
#define SPI0DR_R14_T14_MASK             16384U
#define SPI0DR_R15_T15_MASK             32768U


/*** IIC0_IBAD - IIC Address Register; 0x000000E0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IIC0_IBADSTR;
extern volatile IIC0_IBADSTR _IIC0_IBAD @(REG_BASE + 0x000000E0UL);
#define IIC0_IBAD                       _IIC0_IBAD.Byte
#define IIC0_IBAD_ADR1                  _IIC0_IBAD.Bits.ADR1
#define IIC0_IBAD_ADR2                  _IIC0_IBAD.Bits.ADR2
#define IIC0_IBAD_ADR3                  _IIC0_IBAD.Bits.ADR3
#define IIC0_IBAD_ADR4                  _IIC0_IBAD.Bits.ADR4
#define IIC0_IBAD_ADR5                  _IIC0_IBAD.Bits.ADR5
#define IIC0_IBAD_ADR6                  _IIC0_IBAD.Bits.ADR6
#define IIC0_IBAD_ADR7                  _IIC0_IBAD.Bits.ADR7
#define IIC0_IBAD_ADR_1                 _IIC0_IBAD.MergedBits.grpADR_1
#define IIC0_IBAD_ADR                   IIC0_IBAD_ADR_1

#define IIC0_IBAD_ADR1_MASK             2U
#define IIC0_IBAD_ADR2_MASK             4U
#define IIC0_IBAD_ADR3_MASK             8U
#define IIC0_IBAD_ADR4_MASK             16U
#define IIC0_IBAD_ADR5_MASK             32U
#define IIC0_IBAD_ADR6_MASK             64U
#define IIC0_IBAD_ADR7_MASK             128U
#define IIC0_IBAD_ADR_1_MASK            254U
#define IIC0_IBAD_ADR_1_BITNUM          1U


/*** IIC0_IBFD - IIC Frequency Divider Register; 0x000000E1 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IIC0_IBFDSTR;
extern volatile IIC0_IBFDSTR _IIC0_IBFD @(REG_BASE + 0x000000E1UL);
#define IIC0_IBFD                       _IIC0_IBFD.Byte
#define IIC0_IBFD_IBC0                  _IIC0_IBFD.Bits.IBC0
#define IIC0_IBFD_IBC1                  _IIC0_IBFD.Bits.IBC1
#define IIC0_IBFD_IBC2                  _IIC0_IBFD.Bits.IBC2
#define IIC0_IBFD_IBC3                  _IIC0_IBFD.Bits.IBC3
#define IIC0_IBFD_IBC4                  _IIC0_IBFD.Bits.IBC4
#define IIC0_IBFD_IBC5                  _IIC0_IBFD.Bits.IBC5
#define IIC0_IBFD_IBC6                  _IIC0_IBFD.Bits.IBC6
#define IIC0_IBFD_IBC7                  _IIC0_IBFD.Bits.IBC7

#define IIC0_IBFD_IBC0_MASK             1U
#define IIC0_IBFD_IBC1_MASK             2U
#define IIC0_IBFD_IBC2_MASK             4U
#define IIC0_IBFD_IBC3_MASK             8U
#define IIC0_IBFD_IBC4_MASK             16U
#define IIC0_IBFD_IBC5_MASK             32U
#define IIC0_IBFD_IBC6_MASK             64U
#define IIC0_IBFD_IBC7_MASK             128U


/*** IIC0_IBCR - IIC Control Register; 0x000000E2 ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IIC0_IBCRSTR;
extern volatile IIC0_IBCRSTR _IIC0_IBCR @(REG_BASE + 0x000000E2UL);
#define IIC0_IBCR                       _IIC0_IBCR.Byte
#define IIC0_IBCR_IBSWAI                _IIC0_IBCR.Bits.IBSWAI
#define IIC0_IBCR_RSTA                  _IIC0_IBCR.Bits.RSTA
#define IIC0_IBCR_TXAK                  _IIC0_IBCR.Bits.TXAK
#define IIC0_IBCR_TX_RX                 _IIC0_IBCR.Bits.TX_RX
#define IIC0_IBCR_MS_SL                 _IIC0_IBCR.Bits.MS_SL
#define IIC0_IBCR_IBIE                  _IIC0_IBCR.Bits.IBIE
#define IIC0_IBCR_IBEN                  _IIC0_IBCR.Bits.IBEN

#define IIC0_IBCR_IBSWAI_MASK           1U
#define IIC0_IBCR_RSTA_MASK             4U
#define IIC0_IBCR_TXAK_MASK             8U
#define IIC0_IBCR_TX_RX_MASK            16U
#define IIC0_IBCR_MS_SL_MASK            32U
#define IIC0_IBCR_IBIE_MASK             64U
#define IIC0_IBCR_IBEN_MASK             128U


/*** IIC0_IBSR - IIC Status Register; 0x000000E3 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IIC0_IBSRSTR;
extern volatile IIC0_IBSRSTR _IIC0_IBSR @(REG_BASE + 0x000000E3UL);
#define IIC0_IBSR                       _IIC0_IBSR.Byte
#define IIC0_IBSR_RXAK                  _IIC0_IBSR.Bits.RXAK
#define IIC0_IBSR_IBIF                  _IIC0_IBSR.Bits.IBIF
#define IIC0_IBSR_SRW                   _IIC0_IBSR.Bits.SRW
#define IIC0_IBSR_IBAL                  _IIC0_IBSR.Bits.IBAL
#define IIC0_IBSR_IBB                   _IIC0_IBSR.Bits.IBB
#define IIC0_IBSR_IAAS                  _IIC0_IBSR.Bits.IAAS
#define IIC0_IBSR_TCF                   _IIC0_IBSR.Bits.TCF

#define IIC0_IBSR_RXAK_MASK             1U
#define IIC0_IBSR_IBIF_MASK             2U
#define IIC0_IBSR_SRW_MASK              4U
#define IIC0_IBSR_IBAL_MASK             16U
#define IIC0_IBSR_IBB_MASK              32U
#define IIC0_IBSR_IAAS_MASK             64U
#define IIC0_IBSR_TCF_MASK              128U


/*** IIC0_IBDR - IIC Data I/O Register; 0x000000E4 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IIC0_IBDRSTR;
extern volatile IIC0_IBDRSTR _IIC0_IBDR @(REG_BASE + 0x000000E4UL);
#define IIC0_IBDR                       _IIC0_IBDR.Byte
#define IIC0_IBDR_D0                    _IIC0_IBDR.Bits.D0
#define IIC0_IBDR_D1                    _IIC0_IBDR.Bits.D1
#define IIC0_IBDR_D2                    _IIC0_IBDR.Bits.D2
#define IIC0_IBDR_D3                    _IIC0_IBDR.Bits.D3
#define IIC0_IBDR_D4                    _IIC0_IBDR.Bits.D4
#define IIC0_IBDR_D5                    _IIC0_IBDR.Bits.D5
#define IIC0_IBDR_D6                    _IIC0_IBDR.Bits.D6
#define IIC0_IBDR_D7                    _IIC0_IBDR.Bits.D7

#define IIC0_IBDR_D0_MASK               1U
#define IIC0_IBDR_D1_MASK               2U
#define IIC0_IBDR_D2_MASK               4U
#define IIC0_IBDR_D3_MASK               8U
#define IIC0_IBDR_D4_MASK               16U
#define IIC0_IBDR_D5_MASK               32U
#define IIC0_IBDR_D6_MASK               64U
#define IIC0_IBDR_D7_MASK               128U


/*** IIC0_IBCR2 - IIC Control Register 2; 0x000000E5 ***/
typedef union {
  byte Byte;
  struct {
    byte ADR8        :1;                                       /* Slave Address Bit 8 */
    byte ADR9        :1;                                       /* Slave Address Bit 9 */
    byte ADR10       :1;                                       /* Slave Address Bit 10 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte ADTYPE      :1;                                       /* Address Type */
    byte GCEN        :1;                                       /* General Call Enable */
  } Bits;
  struct {
    byte grpADR_8 :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IIC0_IBCR2STR;
extern volatile IIC0_IBCR2STR _IIC0_IBCR2 @(REG_BASE + 0x000000E5UL);
#define IIC0_IBCR2                      _IIC0_IBCR2.Byte
#define IIC0_IBCR2_ADR8                 _IIC0_IBCR2.Bits.ADR8
#define IIC0_IBCR2_ADR9                 _IIC0_IBCR2.Bits.ADR9
#define IIC0_IBCR2_ADR10                _IIC0_IBCR2.Bits.ADR10
#define IIC0_IBCR2_ADTYPE               _IIC0_IBCR2.Bits.ADTYPE
#define IIC0_IBCR2_GCEN                 _IIC0_IBCR2.Bits.GCEN
#define IIC0_IBCR2_ADR_8                _IIC0_IBCR2.MergedBits.grpADR_8
#define IIC0_IBCR2_ADR                  IIC0_IBCR2_ADR_8

#define IIC0_IBCR2_ADR8_MASK            1U
#define IIC0_IBCR2_ADR9_MASK            2U
#define IIC0_IBCR2_ADR10_MASK           4U
#define IIC0_IBCR2_ADTYPE_MASK          64U
#define IIC0_IBCR2_GCEN_MASK            128U
#define IIC0_IBCR2_ADR_8_MASK           7U
#define IIC0_IBCR2_ADR_8_BITNUM         0U


/*** SPI1CR1 - SPI 1 Control Register 1; 0x000000F0 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI1CR1STR;
extern volatile SPI1CR1STR _SPI1CR1 @(REG_BASE + 0x000000F0UL);
#define SPI1CR1                         _SPI1CR1.Byte
#define SPI1CR1_LSBFE                   _SPI1CR1.Bits.LSBFE
#define SPI1CR1_SSOE                    _SPI1CR1.Bits.SSOE
#define SPI1CR1_CPHA                    _SPI1CR1.Bits.CPHA
#define SPI1CR1_CPOL                    _SPI1CR1.Bits.CPOL
#define SPI1CR1_MSTR                    _SPI1CR1.Bits.MSTR
#define SPI1CR1_SPTIE                   _SPI1CR1.Bits.SPTIE
#define SPI1CR1_SPE                     _SPI1CR1.Bits.SPE
#define SPI1CR1_SPIE                    _SPI1CR1.Bits.SPIE

#define SPI1CR1_LSBFE_MASK              1U
#define SPI1CR1_SSOE_MASK               2U
#define SPI1CR1_CPHA_MASK               4U
#define SPI1CR1_CPOL_MASK               8U
#define SPI1CR1_MSTR_MASK               16U
#define SPI1CR1_SPTIE_MASK              32U
#define SPI1CR1_SPE_MASK                64U
#define SPI1CR1_SPIE_MASK               128U


/*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte XFRW        :1;                                       /* Transfer Width */
    byte             :1; 
  } Bits;
} SPI1CR2STR;
extern volatile SPI1CR2STR _SPI1CR2 @(REG_BASE + 0x000000F1UL);
#define SPI1CR2                         _SPI1CR2.Byte
#define SPI1CR2_SPC0                    _SPI1CR2.Bits.SPC0
#define SPI1CR2_SPISWAI                 _SPI1CR2.Bits.SPISWAI
#define SPI1CR2_BIDIROE                 _SPI1CR2.Bits.BIDIROE
#define SPI1CR2_MODFEN                  _SPI1CR2.Bits.MODFEN
#define SPI1CR2_XFRW                    _SPI1CR2.Bits.XFRW

#define SPI1CR2_SPC0_MASK               1U
#define SPI1CR2_SPISWAI_MASK            2U
#define SPI1CR2_BIDIROE_MASK            8U
#define SPI1CR2_MODFEN_MASK             16U
#define SPI1CR2_XFRW_MASK               64U


/*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI1BRSTR;
extern volatile SPI1BRSTR _SPI1BR @(REG_BASE + 0x000000F2UL);
#define SPI1BR                          _SPI1BR.Byte
#define SPI1BR_SPR0                     _SPI1BR.Bits.SPR0
#define SPI1BR_SPR1                     _SPI1BR.Bits.SPR1
#define SPI1BR_SPR2                     _SPI1BR.Bits.SPR2
#define SPI1BR_SPPR0                    _SPI1BR.Bits.SPPR0
#define SPI1BR_SPPR1                    _SPI1BR.Bits.SPPR1
#define SPI1BR_SPPR2                    _SPI1BR.Bits.SPPR2
#define SPI1BR_SPR                      _SPI1BR.MergedBits.grpSPR
#define SPI1BR_SPPR                     _SPI1BR.MergedBits.grpSPPR

#define SPI1BR_SPR0_MASK                1U
#define SPI1BR_SPR1_MASK                2U
#define SPI1BR_SPR2_MASK                4U
#define SPI1BR_SPPR0_MASK               16U
#define SPI1BR_SPPR1_MASK               32U
#define SPI1BR_SPPR2_MASK               64U
#define SPI1BR_SPR_MASK                 7U
#define SPI1BR_SPR_BITNUM               0U
#define SPI1BR_SPPR_MASK                112U
#define SPI1BR_SPPR_BITNUM              4U


/*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI1SRSTR;
extern volatile SPI1SRSTR _SPI1SR @(REG_BASE + 0x000000F3UL);
#define SPI1SR                          _SPI1SR.Byte
#define SPI1SR_MODF                     _SPI1SR.Bits.MODF
#define SPI1SR_SPTEF                    _SPI1SR.Bits.SPTEF
#define SPI1SR_SPIF                     _SPI1SR.Bits.SPIF

#define SPI1SR_MODF_MASK                16U
#define SPI1SR_SPTEF_MASK               32U
#define SPI1SR_SPIF_MASK                128U


/*** SPI1DR - SPI 1 Data Register; 0x000000F4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SPI1DRH - SPI 1 Data Register High; 0x000000F4 ***/
    union {
      byte Byte;
      struct {
        byte R8_T8       :1;                                       /* SPI 1 Data Bit 8 */
        byte R9_T9       :1;                                       /* SPI 1 Data Bit 9 */
        byte R10_T10     :1;                                       /* SPI 1 Data Bit 10 */
        byte R11_T11     :1;                                       /* SPI 1 Data Bit 11 */
        byte R12_T12     :1;                                       /* SPI 1 Data Bit 12 */
        byte R13_T13     :1;                                       /* SPI 1 Data Bit 13 */
        byte R14_T14     :1;                                       /* SPI 1 Data Bit 14 */
        byte R15_T15     :1;                                       /* SPI 1 Data Bit 15 */
      } Bits;
    } SPI1DRHSTR;
    #define SPI1DRH                     _SPI1DR.Overlap_STR.SPI1DRHSTR.Byte
    #define SPI1DRH_R8_T8               _SPI1DR.Overlap_STR.SPI1DRHSTR.Bits.R8_T8
    #define SPI1DRH_R9_T9               _SPI1DR.Overlap_STR.SPI1DRHSTR.Bits.R9_T9
    #define SPI1DRH_R10_T10             _SPI1DR.Overlap_STR.SPI1DRHSTR.Bits.R10_T10
    #define SPI1DRH_R11_T11             _SPI1DR.Overlap_STR.SPI1DRHSTR.Bits.R11_T11
    #define SPI1DRH_R12_T12             _SPI1DR.Overlap_STR.SPI1DRHSTR.Bits.R12_T12
    #define SPI1DRH_R13_T13             _SPI1DR.Overlap_STR.SPI1DRHSTR.Bits.R13_T13
    #define SPI1DRH_R14_T14             _SPI1DR.Overlap_STR.SPI1DRHSTR.Bits.R14_T14
    #define SPI1DRH_R15_T15             _SPI1DR.Overlap_STR.SPI1DRHSTR.Bits.R15_T15
    
    #define SPI1DRH_R8_T8_MASK          1U
    #define SPI1DRH_R9_T9_MASK          2U
    #define SPI1DRH_R10_T10_MASK        4U
    #define SPI1DRH_R11_T11_MASK        8U
    #define SPI1DRH_R12_T12_MASK        16U
    #define SPI1DRH_R13_T13_MASK        32U
    #define SPI1DRH_R14_T14_MASK        64U
    #define SPI1DRH_R15_T15_MASK        128U
    

    /*** SPI1DRL - SPI 1 Data Register Low; 0x000000F5 ***/
    union {
      byte Byte;
      struct {
        byte R0_T0       :1;                                       /* SPI 1 Data Bit 0 */
        byte R1_T1       :1;                                       /* SPI 1 Data Bit 1 */
        byte R2_T2       :1;                                       /* SPI 1 Data Bit 2 */
        byte R3_T3       :1;                                       /* SPI 1 Data Bit 3 */
        byte R4_T4       :1;                                       /* SPI 1 Data Bit 4 */
        byte R5_T5       :1;                                       /* SPI 1 Data Bit 5 */
        byte R6_T6       :1;                                       /* SPI 1 Data Bit 6 */
        byte R7_T7       :1;                                       /* SPI 1 Data Bit 7 */
      } Bits;
    } SPI1DRLSTR;
    #define SPI1DRL                     _SPI1DR.Overlap_STR.SPI1DRLSTR.Byte
    #define SPI1DRL_R0_T0               _SPI1DR.Overlap_STR.SPI1DRLSTR.Bits.R0_T0
    #define SPI1DRL_R1_T1               _SPI1DR.Overlap_STR.SPI1DRLSTR.Bits.R1_T1
    #define SPI1DRL_R2_T2               _SPI1DR.Overlap_STR.SPI1DRLSTR.Bits.R2_T2
    #define SPI1DRL_R3_T3               _SPI1DR.Overlap_STR.SPI1DRLSTR.Bits.R3_T3
    #define SPI1DRL_R4_T4               _SPI1DR.Overlap_STR.SPI1DRLSTR.Bits.R4_T4
    #define SPI1DRL_R5_T5               _SPI1DR.Overlap_STR.SPI1DRLSTR.Bits.R5_T5
    #define SPI1DRL_R6_T6               _SPI1DR.Overlap_STR.SPI1DRLSTR.Bits.R6_T6
    #define SPI1DRL_R7_T7               _SPI1DR.Overlap_STR.SPI1DRLSTR.Bits.R7_T7
    
    #define SPI1DRL_R0_T0_MASK          1U
    #define SPI1DRL_R1_T1_MASK          2U
    #define SPI1DRL_R2_T2_MASK          4U
    #define SPI1DRL_R3_T3_MASK          8U
    #define SPI1DRL_R4_T4_MASK          16U
    #define SPI1DRL_R5_T5_MASK          32U
    #define SPI1DRL_R6_T6_MASK          64U
    #define SPI1DRL_R7_T7_MASK          128U
    
  } Overlap_STR;

  struct {
    word R0_T0       :1;                                       /* SPI 1 Data Bit 0 */
    word R1_T1       :1;                                       /* SPI 1 Data Bit 1 */
    word R2_T2       :1;                                       /* SPI 1 Data Bit 2 */
    word R3_T3       :1;                                       /* SPI 1 Data Bit 3 */
    word R4_T4       :1;                                       /* SPI 1 Data Bit 4 */
    word R5_T5       :1;                                       /* SPI 1 Data Bit 5 */
    word R6_T6       :1;                                       /* SPI 1 Data Bit 6 */
    word R7_T7       :1;                                       /* SPI 1 Data Bit 7 */
    word R8_T8       :1;                                       /* SPI 1 Data Bit 8 */
    word R9_T9       :1;                                       /* SPI 1 Data Bit 9 */
    word R10_T10     :1;                                       /* SPI 1 Data Bit 10 */
    word R11_T11     :1;                                       /* SPI 1 Data Bit 11 */
    word R12_T12     :1;                                       /* SPI 1 Data Bit 12 */
    word R13_T13     :1;                                       /* SPI 1 Data Bit 13 */
    word R14_T14     :1;                                       /* SPI 1 Data Bit 14 */
    word R15_T15     :1;                                       /* SPI 1 Data Bit 15 */
  } Bits;
} SPI1DRSTR;
extern volatile SPI1DRSTR _SPI1DR @(REG_BASE + 0x000000F4UL);
#define SPI1DR                          _SPI1DR.Word
#define SPI1DR_R0_T0                    _SPI1DR.Bits.R0_T0
#define SPI1DR_R1_T1                    _SPI1DR.Bits.R1_T1
#define SPI1DR_R2_T2                    _SPI1DR.Bits.R2_T2
#define SPI1DR_R3_T3                    _SPI1DR.Bits.R3_T3
#define SPI1DR_R4_T4                    _SPI1DR.Bits.R4_T4
#define SPI1DR_R5_T5                    _SPI1DR.Bits.R5_T5
#define SPI1DR_R6_T6                    _SPI1DR.Bits.R6_T6
#define SPI1DR_R7_T7                    _SPI1DR.Bits.R7_T7
#define SPI1DR_R8_T8                    _SPI1DR.Bits.R8_T8
#define SPI1DR_R9_T9                    _SPI1DR.Bits.R9_T9
#define SPI1DR_R10_T10                  _SPI1DR.Bits.R10_T10
#define SPI1DR_R11_T11                  _SPI1DR.Bits.R11_T11
#define SPI1DR_R12_T12                  _SPI1DR.Bits.R12_T12
#define SPI1DR_R13_T13                  _SPI1DR.Bits.R13_T13
#define SPI1DR_R14_T14                  _SPI1DR.Bits.R14_T14
#define SPI1DR_R15_T15                  _SPI1DR.Bits.R15_T15

#define SPI1DR_R0_T0_MASK               1U
#define SPI1DR_R1_T1_MASK               2U
#define SPI1DR_R2_T2_MASK               4U
#define SPI1DR_R3_T3_MASK               8U
#define SPI1DR_R4_T4_MASK               16U
#define SPI1DR_R5_T5_MASK               32U
#define SPI1DR_R6_T6_MASK               64U
#define SPI1DR_R7_T7_MASK               128U
#define SPI1DR_R8_T8_MASK               256U
#define SPI1DR_R9_T9_MASK               512U
#define SPI1DR_R10_T10_MASK             1024U
#define SPI1DR_R11_T11_MASK             2048U
#define SPI1DR_R12_T12_MASK             4096U
#define SPI1DR_R13_T13_MASK             8192U
#define SPI1DR_R14_T14_MASK             16384U
#define SPI1DR_R15_T15_MASK             32768U


/*** SPI2CR1 - SPI 2 Control Register 1; 0x000000F8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI2CR1STR;
extern volatile SPI2CR1STR _SPI2CR1 @(REG_BASE + 0x000000F8UL);
#define SPI2CR1                         _SPI2CR1.Byte
#define SPI2CR1_LSBFE                   _SPI2CR1.Bits.LSBFE
#define SPI2CR1_SSOE                    _SPI2CR1.Bits.SSOE
#define SPI2CR1_CPHA                    _SPI2CR1.Bits.CPHA
#define SPI2CR1_CPOL                    _SPI2CR1.Bits.CPOL
#define SPI2CR1_MSTR                    _SPI2CR1.Bits.MSTR
#define SPI2CR1_SPTIE                   _SPI2CR1.Bits.SPTIE
#define SPI2CR1_SPE                     _SPI2CR1.Bits.SPE
#define SPI2CR1_SPIE                    _SPI2CR1.Bits.SPIE

#define SPI2CR1_LSBFE_MASK              1U
#define SPI2CR1_SSOE_MASK               2U
#define SPI2CR1_CPHA_MASK               4U
#define SPI2CR1_CPOL_MASK               8U
#define SPI2CR1_MSTR_MASK               16U
#define SPI2CR1_SPTIE_MASK              32U
#define SPI2CR1_SPE_MASK                64U
#define SPI2CR1_SPIE_MASK               128U


/*** SPI2CR2 - SPI 2 Control Register 2; 0x000000F9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte XFRW        :1;                                       /* Transfer Width */
    byte             :1; 
  } Bits;
} SPI2CR2STR;
extern volatile SPI2CR2STR _SPI2CR2 @(REG_BASE + 0x000000F9UL);
#define SPI2CR2                         _SPI2CR2.Byte
#define SPI2CR2_SPC0                    _SPI2CR2.Bits.SPC0
#define SPI2CR2_SPISWAI                 _SPI2CR2.Bits.SPISWAI
#define SPI2CR2_BIDIROE                 _SPI2CR2.Bits.BIDIROE
#define SPI2CR2_MODFEN                  _SPI2CR2.Bits.MODFEN
#define SPI2CR2_XFRW                    _SPI2CR2.Bits.XFRW

#define SPI2CR2_SPC0_MASK               1U
#define SPI2CR2_SPISWAI_MASK            2U
#define SPI2CR2_BIDIROE_MASK            8U
#define SPI2CR2_MODFEN_MASK             16U
#define SPI2CR2_XFRW_MASK               64U


/*** SPI2BR - SPI 2 Baud Rate Register; 0x000000FA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI2BRSTR;
extern volatile SPI2BRSTR _SPI2BR @(REG_BASE + 0x000000FAUL);
#define SPI2BR                          _SPI2BR.Byte
#define SPI2BR_SPR0                     _SPI2BR.Bits.SPR0
#define SPI2BR_SPR1                     _SPI2BR.Bits.SPR1
#define SPI2BR_SPR2                     _SPI2BR.Bits.SPR2
#define SPI2BR_SPPR0                    _SPI2BR.Bits.SPPR0
#define SPI2BR_SPPR1                    _SPI2BR.Bits.SPPR1
#define SPI2BR_SPPR2                    _SPI2BR.Bits.SPPR2
#define SPI2BR_SPR                      _SPI2BR.MergedBits.grpSPR
#define SPI2BR_SPPR                     _SPI2BR.MergedBits.grpSPPR

#define SPI2BR_SPR0_MASK                1U
#define SPI2BR_SPR1_MASK                2U
#define SPI2BR_SPR2_MASK                4U
#define SPI2BR_SPPR0_MASK               16U
#define SPI2BR_SPPR1_MASK               32U
#define SPI2BR_SPPR2_MASK               64U
#define SPI2BR_SPR_MASK                 7U
#define SPI2BR_SPR_BITNUM               0U
#define SPI2BR_SPPR_MASK                112U
#define SPI2BR_SPPR_BITNUM              4U


/*** SPI2SR - SPI 2 Status Register; 0x000000FB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI2SRSTR;
extern volatile SPI2SRSTR _SPI2SR @(REG_BASE + 0x000000FBUL);
#define SPI2SR                          _SPI2SR.Byte
#define SPI2SR_MODF                     _SPI2SR.Bits.MODF
#define SPI2SR_SPTEF                    _SPI2SR.Bits.SPTEF
#define SPI2SR_SPIF                     _SPI2SR.Bits.SPIF

#define SPI2SR_MODF_MASK                16U
#define SPI2SR_SPTEF_MASK               32U
#define SPI2SR_SPIF_MASK                128U


/*** SPI2DR - SPI 2 Data Register; 0x000000FC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SPI2DRH - SPI 2 Data Register High; 0x000000FC ***/
    union {
      byte Byte;
      struct {
        byte R8_T8       :1;                                       /* SPI 2 Data Bit 8 */
        byte R9_T9       :1;                                       /* SPI 2 Data Bit 9 */
        byte R10_T10     :1;                                       /* SPI 2 Data Bit 10 */
        byte R11_T11     :1;                                       /* SPI 2 Data Bit 11 */
        byte R12_T12     :1;                                       /* SPI 2 Data Bit 12 */
        byte R13_T13     :1;                                       /* SPI 2 Data Bit 13 */
        byte R14_T14     :1;                                       /* SPI 2 Data Bit 14 */
        byte R15_T15     :1;                                       /* SPI 2 Data Bit 15 */
      } Bits;
    } SPI2DRHSTR;
    #define SPI2DRH                     _SPI2DR.Overlap_STR.SPI2DRHSTR.Byte
    #define SPI2DRH_R8_T8               _SPI2DR.Overlap_STR.SPI2DRHSTR.Bits.R8_T8
    #define SPI2DRH_R9_T9               _SPI2DR.Overlap_STR.SPI2DRHSTR.Bits.R9_T9
    #define SPI2DRH_R10_T10             _SPI2DR.Overlap_STR.SPI2DRHSTR.Bits.R10_T10
    #define SPI2DRH_R11_T11             _SPI2DR.Overlap_STR.SPI2DRHSTR.Bits.R11_T11
    #define SPI2DRH_R12_T12             _SPI2DR.Overlap_STR.SPI2DRHSTR.Bits.R12_T12
    #define SPI2DRH_R13_T13             _SPI2DR.Overlap_STR.SPI2DRHSTR.Bits.R13_T13
    #define SPI2DRH_R14_T14             _SPI2DR.Overlap_STR.SPI2DRHSTR.Bits.R14_T14
    #define SPI2DRH_R15_T15             _SPI2DR.Overlap_STR.SPI2DRHSTR.Bits.R15_T15
    
    #define SPI2DRH_R8_T8_MASK          1U
    #define SPI2DRH_R9_T9_MASK          2U
    #define SPI2DRH_R10_T10_MASK        4U
    #define SPI2DRH_R11_T11_MASK        8U
    #define SPI2DRH_R12_T12_MASK        16U
    #define SPI2DRH_R13_T13_MASK        32U
    #define SPI2DRH_R14_T14_MASK        64U
    #define SPI2DRH_R15_T15_MASK        128U
    

    /*** SPI2DRL - SPI 2 Data Register Low; 0x000000FD ***/
    union {
      byte Byte;
      struct {
        byte R0_T0       :1;                                       /* SPI 2 Data Bit 0 */
        byte R1_T1       :1;                                       /* SPI 2 Data Bit 1 */
        byte R2_T2       :1;                                       /* SPI 2 Data Bit 2 */
        byte R3_T3       :1;                                       /* SPI 2 Data Bit 3 */
        byte R4_T4       :1;                                       /* SPI 2 Data Bit 4 */
        byte R5_T5       :1;                                       /* SPI 2 Data Bit 5 */
        byte R6_T6       :1;                                       /* SPI 2 Data Bit 6 */
        byte R7_T7       :1;                                       /* SPI 2 Data Bit 7 */
      } Bits;
    } SPI2DRLSTR;
    #define SPI2DRL                     _SPI2DR.Overlap_STR.SPI2DRLSTR.Byte
    #define SPI2DRL_R0_T0               _SPI2DR.Overlap_STR.SPI2DRLSTR.Bits.R0_T0
    #define SPI2DRL_R1_T1               _SPI2DR.Overlap_STR.SPI2DRLSTR.Bits.R1_T1
    #define SPI2DRL_R2_T2               _SPI2DR.Overlap_STR.SPI2DRLSTR.Bits.R2_T2
    #define SPI2DRL_R3_T3               _SPI2DR.Overlap_STR.SPI2DRLSTR.Bits.R3_T3
    #define SPI2DRL_R4_T4               _SPI2DR.Overlap_STR.SPI2DRLSTR.Bits.R4_T4
    #define SPI2DRL_R5_T5               _SPI2DR.Overlap_STR.SPI2DRLSTR.Bits.R5_T5
    #define SPI2DRL_R6_T6               _SPI2DR.Overlap_STR.SPI2DRLSTR.Bits.R6_T6
    #define SPI2DRL_R7_T7               _SPI2DR.Overlap_STR.SPI2DRLSTR.Bits.R7_T7
    
    #define SPI2DRL_R0_T0_MASK          1U
    #define SPI2DRL_R1_T1_MASK          2U
    #define SPI2DRL_R2_T2_MASK          4U
    #define SPI2DRL_R3_T3_MASK          8U
    #define SPI2DRL_R4_T4_MASK          16U
    #define SPI2DRL_R5_T5_MASK          32U
    #define SPI2DRL_R6_T6_MASK          64U
    #define SPI2DRL_R7_T7_MASK          128U
    
  } Overlap_STR;

  struct {
    word R0_T0       :1;                                       /* SPI 2 Data Bit 0 */
    word R1_T1       :1;                                       /* SPI 2 Data Bit 1 */
    word R2_T2       :1;                                       /* SPI 2 Data Bit 2 */
    word R3_T3       :1;                                       /* SPI 2 Data Bit 3 */
    word R4_T4       :1;                                       /* SPI 2 Data Bit 4 */
    word R5_T5       :1;                                       /* SPI 2 Data Bit 5 */
    word R6_T6       :1;                                       /* SPI 2 Data Bit 6 */
    word R7_T7       :1;                                       /* SPI 2 Data Bit 7 */
    word R8_T8       :1;                                       /* SPI 2 Data Bit 8 */
    word R9_T9       :1;                                       /* SPI 2 Data Bit 9 */
    word R10_T10     :1;                                       /* SPI 2 Data Bit 10 */
    word R11_T11     :1;                                       /* SPI 2 Data Bit 11 */
    word R12_T12     :1;                                       /* SPI 2 Data Bit 12 */
    word R13_T13     :1;                                       /* SPI 2 Data Bit 13 */
    word R14_T14     :1;                                       /* SPI 2 Data Bit 14 */
    word R15_T15     :1;                                       /* SPI 2 Data Bit 15 */
  } Bits;
} SPI2DRSTR;
extern volatile SPI2DRSTR _SPI2DR @(REG_BASE + 0x000000FCUL);
#define SPI2DR                          _SPI2DR.Word
#define SPI2DR_R0_T0                    _SPI2DR.Bits.R0_T0
#define SPI2DR_R1_T1                    _SPI2DR.Bits.R1_T1
#define SPI2DR_R2_T2                    _SPI2DR.Bits.R2_T2
#define SPI2DR_R3_T3                    _SPI2DR.Bits.R3_T3
#define SPI2DR_R4_T4                    _SPI2DR.Bits.R4_T4
#define SPI2DR_R5_T5                    _SPI2DR.Bits.R5_T5
#define SPI2DR_R6_T6                    _SPI2DR.Bits.R6_T6
#define SPI2DR_R7_T7                    _SPI2DR.Bits.R7_T7
#define SPI2DR_R8_T8                    _SPI2DR.Bits.R8_T8
#define SPI2DR_R9_T9                    _SPI2DR.Bits.R9_T9
#define SPI2DR_R10_T10                  _SPI2DR.Bits.R10_T10
#define SPI2DR_R11_T11                  _SPI2DR.Bits.R11_T11
#define SPI2DR_R12_T12                  _SPI2DR.Bits.R12_T12
#define SPI2DR_R13_T13                  _SPI2DR.Bits.R13_T13
#define SPI2DR_R14_T14                  _SPI2DR.Bits.R14_T14
#define SPI2DR_R15_T15                  _SPI2DR.Bits.R15_T15

#define SPI2DR_R0_T0_MASK               1U
#define SPI2DR_R1_T1_MASK               2U
#define SPI2DR_R2_T2_MASK               4U
#define SPI2DR_R3_T3_MASK               8U
#define SPI2DR_R4_T4_MASK               16U
#define SPI2DR_R5_T5_MASK               32U
#define SPI2DR_R6_T6_MASK               64U
#define SPI2DR_R7_T7_MASK               128U
#define SPI2DR_R8_T8_MASK               256U
#define SPI2DR_R9_T9_MASK               512U
#define SPI2DR_R10_T10_MASK             1024U
#define SPI2DR_R11_T11_MASK             2048U
#define SPI2DR_R12_T12_MASK             4096U
#define SPI2DR_R13_T13_MASK             8192U
#define SPI2DR_R14_T14_MASK             16384U
#define SPI2DR_R15_T15_MASK             32768U


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Clock Divider Bit 5 */
    byte FDIV6       :1;                                       /* Clock Divider Bit 6 */
    byte FDIVLD      :1;                                       /* Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :7;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_FDIV6                   _FCLKDIV.Bits.FDIV6
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_FDIV6_MASK              64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               127U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte RNV2        :1;                                       /* Reserved Nonvolatile Bit 2 */
    byte RNV3        :1;                                       /* Reserved Nonvolatile Bit 3 */
    byte RNV4        :1;                                       /* Reserved Nonvolatile Bit 4 */
    byte RNV5        :1;                                       /* Reserved Nonvolatile Bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_RNV2                       _FSEC.Bits.RNV2
#define FSEC_RNV3                       _FSEC.Bits.RNV3
#define FSEC_RNV4                       _FSEC.Bits.RNV4
#define FSEC_RNV5                       _FSEC.Bits.RNV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_RNV_2                      _FSEC.MergedBits.grpRNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_RNV                        FSEC_RNV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_RNV2_MASK                  4U
#define FSEC_RNV3_MASK                  8U
#define FSEC_RNV4_MASK                  16U
#define FSEC_RNV5_MASK                  32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_RNV_2_MASK                 60U
#define FSEC_RNV_2_BITNUM               2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FCCOBIX - Flash CCOB Index Register; 0x00000102 ***/
typedef union {
  byte Byte;
  struct {
    byte CCOBIX0     :1;                                       /* Common Command Register Index Bit 0 */
    byte CCOBIX1     :1;                                       /* Common Command Register Index Bit 1 */
    byte CCOBIX2     :1;                                       /* Common Command Register Index Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCCOBIX :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCCOBIXSTR;
extern volatile FCCOBIXSTR _FCCOBIX @(REG_BASE + 0x00000102UL);
#define FCCOBIX                         _FCCOBIX.Byte
#define FCCOBIX_CCOBIX0                 _FCCOBIX.Bits.CCOBIX0
#define FCCOBIX_CCOBIX1                 _FCCOBIX.Bits.CCOBIX1
#define FCCOBIX_CCOBIX2                 _FCCOBIX.Bits.CCOBIX2
#define FCCOBIX_CCOBIX                  _FCCOBIX.MergedBits.grpCCOBIX

#define FCCOBIX_CCOBIX0_MASK            1U
#define FCCOBIX_CCOBIX1_MASK            2U
#define FCCOBIX_CCOBIX2_MASK            4U
#define FCCOBIX_CCOBIX_MASK             7U
#define FCCOBIX_CCOBIX_BITNUM           0U


/*** FECCRIX - Flash ECCR Index Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte ECCRIX0     :1;                                       /* ECC Error Register Index Bit 0 */
    byte ECCRIX1     :1;                                       /* ECC Error Register Index Bit 1 */
    byte ECCRIX2     :1;                                       /* ECC Error Register Index Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpECCRIX :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FECCRIXSTR;
extern volatile FECCRIXSTR _FECCRIX @(REG_BASE + 0x00000103UL);
#define FECCRIX                         _FECCRIX.Byte
#define FECCRIX_ECCRIX0                 _FECCRIX.Bits.ECCRIX0
#define FECCRIX_ECCRIX1                 _FECCRIX.Bits.ECCRIX1
#define FECCRIX_ECCRIX2                 _FECCRIX.Bits.ECCRIX2
#define FECCRIX_ECCRIX                  _FECCRIX.MergedBits.grpECCRIX

#define FECCRIX_ECCRIX0_MASK            1U
#define FECCRIX_ECCRIX1_MASK            2U
#define FECCRIX_ECCRIX2_MASK            4U
#define FECCRIX_ECCRIX_MASK             7U
#define FECCRIX_ECCRIX_BITNUM           0U


/*** FCNFG - Flash Configuration Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FSFD        :1;                                       /* Force Single Bit Fault Detect */
    byte FDFD        :1;                                       /* Force Double Bit Fault Detect */
    byte             :1; 
    byte             :1; 
    byte IGNSF       :1;                                       /* Ignore Single Bit Fault */
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000104UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_FSFD                      _FCNFG.Bits.FSFD
#define FCNFG_FDFD                      _FCNFG.Bits.FDFD
#define FCNFG_IGNSF                     _FCNFG.Bits.IGNSF
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE

#define FCNFG_FSFD_MASK                 1U
#define FCNFG_FDFD_MASK                 2U
#define FCNFG_IGNSF_MASK                16U
#define FCNFG_CCIE_MASK                 128U


/*** FERCNFG - Flash Error Configuration Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte SFDIE       :1;                                       /* Single Bit Fault Detect Interrupt Enable */
    byte DFDIE       :1;                                       /* Double Bit Fault Detect Interrupt Enable */
    byte ERSVIE0     :1;                                       /* EEE Error Type 0 Interrupt Enable */
    byte ERSVIE1     :1;                                       /* EEE Error Type 1 Interrupt Enable */
    byte EPVIOLIE    :1;                                       /* EEE Protection Violation Interrupt Enable */
    byte             :1; 
    byte PGMERIE     :1;                                       /* EEE Program Error Interrupt Enable */
    byte ERSERIE     :1;                                       /* EEE Erase Error Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpERSVIE :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FERCNFGSTR;
extern volatile FERCNFGSTR _FERCNFG @(REG_BASE + 0x00000105UL);
#define FERCNFG                         _FERCNFG.Byte
#define FERCNFG_SFDIE                   _FERCNFG.Bits.SFDIE
#define FERCNFG_DFDIE                   _FERCNFG.Bits.DFDIE
#define FERCNFG_ERSVIE0                 _FERCNFG.Bits.ERSVIE0
#define FERCNFG_ERSVIE1                 _FERCNFG.Bits.ERSVIE1
#define FERCNFG_EPVIOLIE                _FERCNFG.Bits.EPVIOLIE
#define FERCNFG_PGMERIE                 _FERCNFG.Bits.PGMERIE
#define FERCNFG_ERSERIE                 _FERCNFG.Bits.ERSERIE
#define FERCNFG_ERSVIE                  _FERCNFG.MergedBits.grpERSVIE

#define FERCNFG_SFDIE_MASK              1U
#define FERCNFG_DFDIE_MASK              2U
#define FERCNFG_ERSVIE0_MASK            4U
#define FERCNFG_ERSVIE1_MASK            8U
#define FERCNFG_EPVIOLIE_MASK           16U
#define FERCNFG_PGMERIE_MASK            64U
#define FERCNFG_ERSERIE_MASK            128U
#define FERCNFG_ERSVIE_MASK             12U
#define FERCNFG_ERSVIE_BITNUM           2U


/*** FSTAT - Flash Status Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte MGSTAT0     :1;                                       /* Memory Controller Command Completion Status Flag 0 */
    byte MGSTAT1     :1;                                       /* Memory Controller Command Completion Status Flag 1 */
    byte             :1; 
    byte MGBUSY      :1;                                       /* Memory Controller Busy Flag */
    byte FPVIOL      :1;                                       /* Flash Protection Violation Flag */
    byte ACCERR      :1;                                       /* Flash Access Error Flag */
    byte             :1; 
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
  } Bits;
  struct {
    byte grpMGSTAT :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000106UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_MGSTAT0                   _FSTAT.Bits.MGSTAT0
#define FSTAT_MGSTAT1                   _FSTAT.Bits.MGSTAT1
#define FSTAT_MGBUSY                    _FSTAT.Bits.MGBUSY
#define FSTAT_FPVIOL                    _FSTAT.Bits.FPVIOL
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_MGSTAT                    _FSTAT.MergedBits.grpMGSTAT

#define FSTAT_MGSTAT0_MASK              1U
#define FSTAT_MGSTAT1_MASK              2U
#define FSTAT_MGBUSY_MASK               8U
#define FSTAT_FPVIOL_MASK               16U
#define FSTAT_ACCERR_MASK               32U
#define FSTAT_CCIF_MASK                 128U
#define FSTAT_MGSTAT_MASK               3U
#define FSTAT_MGSTAT_BITNUM             0U


/*** FERSTAT - Flash Error Status Register; 0x00000107 ***/
typedef union {
  byte Byte;
  struct {
    byte SFDIF       :1;                                       /* Single Bit Fault Detect Interrupt Flag */
    byte DFDIF       :1;                                       /* Double Bit Fault Detect Interrupt Flag */
    byte ERSVIF0     :1;                                       /* EEE Error Type 0 Interrupt Flag */
    byte ERSVIF1     :1;                                       /* EEE Error Type 1 Interrupt Flag */
    byte EPVIOLIF    :1;                                       /* EEE Protection Violation Interrupt Flag */
    byte             :1; 
    byte PGMERIF     :1;                                       /* EEE Program Error Interrupt Flag */
    byte ERSERIF     :1;                                       /* EEE Erase Error Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpERSVIF :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FERSTATSTR;
extern volatile FERSTATSTR _FERSTAT @(REG_BASE + 0x00000107UL);
#define FERSTAT                         _FERSTAT.Byte
#define FERSTAT_SFDIF                   _FERSTAT.Bits.SFDIF
#define FERSTAT_DFDIF                   _FERSTAT.Bits.DFDIF
#define FERSTAT_ERSVIF0                 _FERSTAT.Bits.ERSVIF0
#define FERSTAT_ERSVIF1                 _FERSTAT.Bits.ERSVIF1
#define FERSTAT_EPVIOLIF                _FERSTAT.Bits.EPVIOLIF
#define FERSTAT_PGMERIF                 _FERSTAT.Bits.PGMERIF
#define FERSTAT_ERSERIF                 _FERSTAT.Bits.ERSERIF
#define FERSTAT_ERSVIF                  _FERSTAT.MergedBits.grpERSVIF

#define FERSTAT_SFDIF_MASK              1U
#define FERSTAT_DFDIF_MASK              2U
#define FERSTAT_ERSVIF0_MASK            4U
#define FERSTAT_ERSVIF1_MASK            8U
#define FERSTAT_EPVIOLIF_MASK           16U
#define FERSTAT_PGMERIF_MASK            64U
#define FERSTAT_ERSERIF_MASK            128U
#define FERSTAT_ERSVIF_MASK             12U
#define FERSTAT_ERSVIF_BITNUM           2U


/*** FPROT - P-Flash Protection Register; 0x00000108 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address Size Bit 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address Size Bit 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower Address Range Disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher Address Size Bit 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher Address Size Bit 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher Address Range Disable */
    byte RNV6        :1;                                       /* Reserved Nonvolatile Bit */
    byte FPOPEN      :1;                                       /* Flash Protection Operation Enable */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000108UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_RNV6                      _FPROT.Bits.RNV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_RNV6_MASK                 64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** EPROT - EEE Protection Register; 0x00000109 ***/
typedef union {
  byte Byte;
  struct {
    byte EPS0        :1;                                       /* Buffer RAM Protection Size 0 */
    byte EPS1        :1;                                       /* Buffer RAM Protection Size 1 */
    byte EPS2        :1;                                       /* Buffer RAM Protection Size 2 */
    byte EPDIS       :1;                                       /* Buffer RAM Protection Address Range Disable */
    byte RNV4        :1;                                       /* Reserved Non-volatile Bits */
    byte RNV5        :1;                                       /* Reserved Non-volatile Bit 1 */
    byte RNV6        :1;                                       /* Reserved Non-volatile Bit 2 */
    byte EPOPEN      :1;                                       /* Enables writes to Buffer RAM partitioned for EEE */
  } Bits;
  struct {
    byte grpEPS  :3;
    byte         :1;
    byte grpRNV_4 :3;
    byte         :1;
  } MergedBits;
} EPROTSTR;
extern volatile EPROTSTR _EPROT @(REG_BASE + 0x00000109UL);
#define EPROT                           _EPROT.Byte
#define EPROT_EPS0                      _EPROT.Bits.EPS0
#define EPROT_EPS1                      _EPROT.Bits.EPS1
#define EPROT_EPS2                      _EPROT.Bits.EPS2
#define EPROT_EPDIS                     _EPROT.Bits.EPDIS
#define EPROT_RNV4                      _EPROT.Bits.RNV4
#define EPROT_RNV5                      _EPROT.Bits.RNV5
#define EPROT_RNV6                      _EPROT.Bits.RNV6
#define EPROT_EPOPEN                    _EPROT.Bits.EPOPEN
#define EPROT_EPS                       _EPROT.MergedBits.grpEPS
#define EPROT_RNV_4                     _EPROT.MergedBits.grpRNV_4
#define EPROT_RNV                       EPROT_RNV_4

#define EPROT_EPS0_MASK                 1U
#define EPROT_EPS1_MASK                 2U
#define EPROT_EPS2_MASK                 4U
#define EPROT_EPDIS_MASK                8U
#define EPROT_RNV4_MASK                 16U
#define EPROT_RNV5_MASK                 32U
#define EPROT_RNV6_MASK                 64U
#define EPROT_EPOPEN_MASK               128U
#define EPROT_EPS_MASK                  7U
#define EPROT_EPS_BITNUM                0U
#define EPROT_RNV_4_MASK                112U
#define EPROT_RNV_4_BITNUM              4U


/*** FCCOB - Flash Common Command Object Register; 0x0000010A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FCCOBHI - Flash Common Command Object Register High; 0x0000010A ***/
    union {
      byte Byte;
      struct {
        byte CCOB8       :1;                                       /* Flash Common Command Object Bit 8 */
        byte CCOB9       :1;                                       /* Flash Common Command Object Bit 9 */
        byte CCOB10      :1;                                       /* Flash Common Command Object Bit 10 */
        byte CCOB11      :1;                                       /* Flash Common Command Object Bit 11 */
        byte CCOB12      :1;                                       /* Flash Common Command Object Bit 12 */
        byte CCOB13      :1;                                       /* Flash Common Command Object Bit 13 */
        byte CCOB14      :1;                                       /* Flash Common Command Object Bit 14 */
        byte CCOB15      :1;                                       /* Flash Common Command Object Bit 15 */
      } Bits;
    } FCCOBHISTR;
    #define FCCOBHI                     _FCCOB.Overlap_STR.FCCOBHISTR.Byte
    #define FCCOBHI_CCOB8               _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB8
    #define FCCOBHI_CCOB9               _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB9
    #define FCCOBHI_CCOB10              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB10
    #define FCCOBHI_CCOB11              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB11
    #define FCCOBHI_CCOB12              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB12
    #define FCCOBHI_CCOB13              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB13
    #define FCCOBHI_CCOB14              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB14
    #define FCCOBHI_CCOB15              _FCCOB.Overlap_STR.FCCOBHISTR.Bits.CCOB15
    
    #define FCCOBHI_CCOB8_MASK          1U
    #define FCCOBHI_CCOB9_MASK          2U
    #define FCCOBHI_CCOB10_MASK         4U
    #define FCCOBHI_CCOB11_MASK         8U
    #define FCCOBHI_CCOB12_MASK         16U
    #define FCCOBHI_CCOB13_MASK         32U
    #define FCCOBHI_CCOB14_MASK         64U
    #define FCCOBHI_CCOB15_MASK         128U
    

    /*** FCCOBLO - Flash Common Command Object Register Low; 0x0000010B ***/
    union {
      byte Byte;
      struct {
        byte CCOB0       :1;                                       /* Flash Common Command Object Bit 0 */
        byte CCOB1       :1;                                       /* Flash Common Command Object Bit 1 */
        byte CCOB2       :1;                                       /* Flash Common Command Object Bit 2 */
        byte CCOB3       :1;                                       /* Flash Common Command Object Bit 3 */
        byte CCOB4       :1;                                       /* Flash Common Command Object Bit 4 */
        byte CCOB5       :1;                                       /* Flash Common Command Object Bit 5 */
        byte CCOB6       :1;                                       /* Flash Common Command Object Bit 6 */
        byte CCOB7       :1;                                       /* Flash Common Command Object Bit 7 */
      } Bits;
    } FCCOBLOSTR;
    #define FCCOBLO                     _FCCOB.Overlap_STR.FCCOBLOSTR.Byte
    #define FCCOBLO_CCOB0               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB0
    #define FCCOBLO_CCOB1               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB1
    #define FCCOBLO_CCOB2               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB2
    #define FCCOBLO_CCOB3               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB3
    #define FCCOBLO_CCOB4               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB4
    #define FCCOBLO_CCOB5               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB5
    #define FCCOBLO_CCOB6               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB6
    #define FCCOBLO_CCOB7               _FCCOB.Overlap_STR.FCCOBLOSTR.Bits.CCOB7
    
    #define FCCOBLO_CCOB0_MASK          1U
    #define FCCOBLO_CCOB1_MASK          2U
    #define FCCOBLO_CCOB2_MASK          4U
    #define FCCOBLO_CCOB3_MASK          8U
    #define FCCOBLO_CCOB4_MASK          16U
    #define FCCOBLO_CCOB5_MASK          32U
    #define FCCOBLO_CCOB6_MASK          64U
    #define FCCOBLO_CCOB7_MASK          128U
    
  } Overlap_STR;

  struct {
    word CCOB0       :1;                                       /* Flash Common Command Object Bit 0 */
    word CCOB1       :1;                                       /* Flash Common Command Object Bit 1 */
    word CCOB2       :1;                                       /* Flash Common Command Object Bit 2 */
    word CCOB3       :1;                                       /* Flash Common Command Object Bit 3 */
    word CCOB4       :1;                                       /* Flash Common Command Object Bit 4 */
    word CCOB5       :1;                                       /* Flash Common Command Object Bit 5 */
    word CCOB6       :1;                                       /* Flash Common Command Object Bit 6 */
    word CCOB7       :1;                                       /* Flash Common Command Object Bit 7 */
    word CCOB8       :1;                                       /* Flash Common Command Object Bit 8 */
    word CCOB9       :1;                                       /* Flash Common Command Object Bit 9 */
    word CCOB10      :1;                                       /* Flash Common Command Object Bit 10 */
    word CCOB11      :1;                                       /* Flash Common Command Object Bit 11 */
    word CCOB12      :1;                                       /* Flash Common Command Object Bit 12 */
    word CCOB13      :1;                                       /* Flash Common Command Object Bit 13 */
    word CCOB14      :1;                                       /* Flash Common Command Object Bit 14 */
    word CCOB15      :1;                                       /* Flash Common Command Object Bit 15 */
  } Bits;
} FCCOBSTR;
extern volatile FCCOBSTR _FCCOB @(REG_BASE + 0x0000010AUL);
#define FCCOB                           _FCCOB.Word
#define FCCOB_CCOB0                     _FCCOB.Bits.CCOB0
#define FCCOB_CCOB1                     _FCCOB.Bits.CCOB1
#define FCCOB_CCOB2                     _FCCOB.Bits.CCOB2
#define FCCOB_CCOB3                     _FCCOB.Bits.CCOB3
#define FCCOB_CCOB4                     _FCCOB.Bits.CCOB4
#define FCCOB_CCOB5                     _FCCOB.Bits.CCOB5
#define FCCOB_CCOB6                     _FCCOB.Bits.CCOB6
#define FCCOB_CCOB7                     _FCCOB.Bits.CCOB7
#define FCCOB_CCOB8                     _FCCOB.Bits.CCOB8
#define FCCOB_CCOB9                     _FCCOB.Bits.CCOB9
#define FCCOB_CCOB10                    _FCCOB.Bits.CCOB10
#define FCCOB_CCOB11                    _FCCOB.Bits.CCOB11
#define FCCOB_CCOB12                    _FCCOB.Bits.CCOB12
#define FCCOB_CCOB13                    _FCCOB.Bits.CCOB13
#define FCCOB_CCOB14                    _FCCOB.Bits.CCOB14
#define FCCOB_CCOB15                    _FCCOB.Bits.CCOB15

#define FCCOB_CCOB0_MASK                1U
#define FCCOB_CCOB1_MASK                2U
#define FCCOB_CCOB2_MASK                4U
#define FCCOB_CCOB3_MASK                8U
#define FCCOB_CCOB4_MASK                16U
#define FCCOB_CCOB5_MASK                32U
#define FCCOB_CCOB6_MASK                64U
#define FCCOB_CCOB7_MASK                128U
#define FCCOB_CCOB8_MASK                256U
#define FCCOB_CCOB9_MASK                512U
#define FCCOB_CCOB10_MASK               1024U
#define FCCOB_CCOB11_MASK               2048U
#define FCCOB_CCOB12_MASK               4096U
#define FCCOB_CCOB13_MASK               8192U
#define FCCOB_CCOB14_MASK               16384U
#define FCCOB_CCOB15_MASK               32768U


/*** ETAG - EEE Tag Counter Register; 0x0000010C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ETAGHI - EEE Tag Counter High Register; 0x0000010C ***/
    union {
      byte Byte;
      struct {
        byte ETAG8       :1;                                       /* EEE Tag Counter Bit 8 */
        byte ETAG9       :1;                                       /* EEE Tag Counter Bit 9 */
        byte ETAG10      :1;                                       /* EEE Tag Counter Bit 10 */
        byte ETAG11      :1;                                       /* EEE Tag Counter Bit 11 */
        byte ETAG12      :1;                                       /* EEE Tag Counter Bit 12 */
        byte ETAG13      :1;                                       /* EEE Tag Counter Bit 13 */
        byte ETAG14      :1;                                       /* EEE Tag Counter Bit 14 */
        byte ETAG15      :1;                                       /* EEE Tag Counter Bit 15 */
      } Bits;
    } ETAGHISTR;
    #define ETAGHI                      _ETAG.Overlap_STR.ETAGHISTR.Byte
    #define ETAGHI_ETAG8                _ETAG.Overlap_STR.ETAGHISTR.Bits.ETAG8
    #define ETAGHI_ETAG9                _ETAG.Overlap_STR.ETAGHISTR.Bits.ETAG9
    #define ETAGHI_ETAG10               _ETAG.Overlap_STR.ETAGHISTR.Bits.ETAG10
    #define ETAGHI_ETAG11               _ETAG.Overlap_STR.ETAGHISTR.Bits.ETAG11
    #define ETAGHI_ETAG12               _ETAG.Overlap_STR.ETAGHISTR.Bits.ETAG12
    #define ETAGHI_ETAG13               _ETAG.Overlap_STR.ETAGHISTR.Bits.ETAG13
    #define ETAGHI_ETAG14               _ETAG.Overlap_STR.ETAGHISTR.Bits.ETAG14
    #define ETAGHI_ETAG15               _ETAG.Overlap_STR.ETAGHISTR.Bits.ETAG15
    
    #define ETAGHI_ETAG8_MASK           1U
    #define ETAGHI_ETAG9_MASK           2U
    #define ETAGHI_ETAG10_MASK          4U
    #define ETAGHI_ETAG11_MASK          8U
    #define ETAGHI_ETAG12_MASK          16U
    #define ETAGHI_ETAG13_MASK          32U
    #define ETAGHI_ETAG14_MASK          64U
    #define ETAGHI_ETAG15_MASK          128U
    

    /*** ETAGLO - EEE Tag Counter Low Register; 0x0000010D ***/
    union {
      byte Byte;
      struct {
        byte ETAG0       :1;                                       /* EEE Tag Counter Bit 0 */
        byte ETAG1       :1;                                       /* EEE Tag Counter Bit 1 */
        byte ETAG2       :1;                                       /* EEE Tag Counter Bit 2 */
        byte ETAG3       :1;                                       /* EEE Tag Counter Bit 3 */
        byte ETAG4       :1;                                       /* EEE Tag Counter Bit 4 */
        byte ETAG5       :1;                                       /* EEE Tag Counter Bit 5 */
        byte ETAG6       :1;                                       /* EEE Tag Counter Bit 6 */
        byte ETAG7       :1;                                       /* EEE Tag Counter Bit 7 */
      } Bits;
    } ETAGLOSTR;
    #define ETAGLO                      _ETAG.Overlap_STR.ETAGLOSTR.Byte
    #define ETAGLO_ETAG0                _ETAG.Overlap_STR.ETAGLOSTR.Bits.ETAG0
    #define ETAGLO_ETAG1                _ETAG.Overlap_STR.ETAGLOSTR.Bits.ETAG1
    #define ETAGLO_ETAG2                _ETAG.Overlap_STR.ETAGLOSTR.Bits.ETAG2
    #define ETAGLO_ETAG3                _ETAG.Overlap_STR.ETAGLOSTR.Bits.ETAG3
    #define ETAGLO_ETAG4                _ETAG.Overlap_STR.ETAGLOSTR.Bits.ETAG4
    #define ETAGLO_ETAG5                _ETAG.Overlap_STR.ETAGLOSTR.Bits.ETAG5
    #define ETAGLO_ETAG6                _ETAG.Overlap_STR.ETAGLOSTR.Bits.ETAG6
    #define ETAGLO_ETAG7                _ETAG.Overlap_STR.ETAGLOSTR.Bits.ETAG7
    
    #define ETAGLO_ETAG0_MASK           1U
    #define ETAGLO_ETAG1_MASK           2U
    #define ETAGLO_ETAG2_MASK           4U
    #define ETAGLO_ETAG3_MASK           8U
    #define ETAGLO_ETAG4_MASK           16U
    #define ETAGLO_ETAG5_MASK           32U
    #define ETAGLO_ETAG6_MASK           64U
    #define ETAGLO_ETAG7_MASK           128U
    
  } Overlap_STR;

  struct {
    word ETAG0       :1;                                       /* EEE Tag Counter Bit 0 */
    word ETAG1       :1;                                       /* EEE Tag Counter Bit 1 */
    word ETAG2       :1;                                       /* EEE Tag Counter Bit 2 */
    word ETAG3       :1;                                       /* EEE Tag Counter Bit 3 */
    word ETAG4       :1;                                       /* EEE Tag Counter Bit 4 */
    word ETAG5       :1;                                       /* EEE Tag Counter Bit 5 */
    word ETAG6       :1;                                       /* EEE Tag Counter Bit 6 */
    word ETAG7       :1;                                       /* EEE Tag Counter Bit 7 */
    word ETAG8       :1;                                       /* EEE Tag Counter Bit 8 */
    word ETAG9       :1;                                       /* EEE Tag Counter Bit 9 */
    word ETAG10      :1;                                       /* EEE Tag Counter Bit 10 */
    word ETAG11      :1;                                       /* EEE Tag Counter Bit 11 */
    word ETAG12      :1;                                       /* EEE Tag Counter Bit 12 */
    word ETAG13      :1;                                       /* EEE Tag Counter Bit 13 */
    word ETAG14      :1;                                       /* EEE Tag Counter Bit 14 */
    word ETAG15      :1;                                       /* EEE Tag Counter Bit 15 */
  } Bits;
} ETAGSTR;
extern volatile ETAGSTR _ETAG @(REG_BASE + 0x0000010CUL);
#define ETAG                            _ETAG.Word
#define ETAG_ETAG0                      _ETAG.Bits.ETAG0
#define ETAG_ETAG1                      _ETAG.Bits.ETAG1
#define ETAG_ETAG2                      _ETAG.Bits.ETAG2
#define ETAG_ETAG3                      _ETAG.Bits.ETAG3
#define ETAG_ETAG4                      _ETAG.Bits.ETAG4
#define ETAG_ETAG5                      _ETAG.Bits.ETAG5
#define ETAG_ETAG6                      _ETAG.Bits.ETAG6
#define ETAG_ETAG7                      _ETAG.Bits.ETAG7
#define ETAG_ETAG8                      _ETAG.Bits.ETAG8
#define ETAG_ETAG9                      _ETAG.Bits.ETAG9
#define ETAG_ETAG10                     _ETAG.Bits.ETAG10
#define ETAG_ETAG11                     _ETAG.Bits.ETAG11
#define ETAG_ETAG12                     _ETAG.Bits.ETAG12
#define ETAG_ETAG13                     _ETAG.Bits.ETAG13
#define ETAG_ETAG14                     _ETAG.Bits.ETAG14
#define ETAG_ETAG15                     _ETAG.Bits.ETAG15

#define ETAG_ETAG0_MASK                 1U
#define ETAG_ETAG1_MASK                 2U
#define ETAG_ETAG2_MASK                 4U
#define ETAG_ETAG3_MASK                 8U
#define ETAG_ETAG4_MASK                 16U
#define ETAG_ETAG5_MASK                 32U
#define ETAG_ETAG6_MASK                 64U
#define ETAG_ETAG7_MASK                 128U
#define ETAG_ETAG8_MASK                 256U
#define ETAG_ETAG9_MASK                 512U
#define ETAG_ETAG10_MASK                1024U
#define ETAG_ETAG11_MASK                2048U
#define ETAG_ETAG12_MASK                4096U
#define ETAG_ETAG13_MASK                8192U
#define ETAG_ETAG14_MASK                16384U
#define ETAG_ETAG15_MASK                32768U


/*** FECCR - Flash ECC Error Results Register; 0x0000010E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FECCRHI - Flash ECC Error Results Register High; 0x0000010E ***/
    union {
      byte Byte;
      struct {
        byte ECCR8       :1;                                       /* Flash ECC Error Result Bit 8 */
        byte ECCR9       :1;                                       /* Flash ECC Error Result Bit 9 */
        byte ECCR10      :1;                                       /* Flash ECC Error Result Bit 10 */
        byte ECCR11      :1;                                       /* Flash ECC Error Result Bit 11 */
        byte ECCR12      :1;                                       /* Flash ECC Error Result Bit 12 */
        byte ECCR13      :1;                                       /* Flash ECC Error Result Bit 13 */
        byte ECCR14      :1;                                       /* Flash ECC Error Result Bit 14 */
        byte ECCR15      :1;                                       /* Flash ECC Error Result Bit 15 */
      } Bits;
    } FECCRHISTR;
    #define FECCRHI                     _FECCR.Overlap_STR.FECCRHISTR.Byte
    #define FECCRHI_ECCR8               _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR8
    #define FECCRHI_ECCR9               _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR9
    #define FECCRHI_ECCR10              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR10
    #define FECCRHI_ECCR11              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR11
    #define FECCRHI_ECCR12              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR12
    #define FECCRHI_ECCR13              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR13
    #define FECCRHI_ECCR14              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR14
    #define FECCRHI_ECCR15              _FECCR.Overlap_STR.FECCRHISTR.Bits.ECCR15
    
    #define FECCRHI_ECCR8_MASK          1U
    #define FECCRHI_ECCR9_MASK          2U
    #define FECCRHI_ECCR10_MASK         4U
    #define FECCRHI_ECCR11_MASK         8U
    #define FECCRHI_ECCR12_MASK         16U
    #define FECCRHI_ECCR13_MASK         32U
    #define FECCRHI_ECCR14_MASK         64U
    #define FECCRHI_ECCR15_MASK         128U
    

    /*** FECCRLO - Flash ECC Error Results Register Low; 0x0000010F ***/
    union {
      byte Byte;
      struct {
        byte ECCR0       :1;                                       /* Flash ECC Error Result Bit 0 */
        byte ECCR1       :1;                                       /* Flash ECC Error Result Bit 1 */
        byte ECCR2       :1;                                       /* Flash ECC Error Result Bit 2 */
        byte ECCR3       :1;                                       /* Flash ECC Error Result Bit 3 */
        byte ECCR4       :1;                                       /* Flash ECC Error Result Bit 4 */
        byte ECCR5       :1;                                       /* Flash ECC Error Result Bit 5 */
        byte ECCR6       :1;                                       /* Flash ECC Error Result Bit 6 */
        byte ECCR7       :1;                                       /* Flash ECC Error Result Bit 7 */
      } Bits;
    } FECCRLOSTR;
    #define FECCRLO                     _FECCR.Overlap_STR.FECCRLOSTR.Byte
    #define FECCRLO_ECCR0               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR0
    #define FECCRLO_ECCR1               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR1
    #define FECCRLO_ECCR2               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR2
    #define FECCRLO_ECCR3               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR3
    #define FECCRLO_ECCR4               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR4
    #define FECCRLO_ECCR5               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR5
    #define FECCRLO_ECCR6               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR6
    #define FECCRLO_ECCR7               _FECCR.Overlap_STR.FECCRLOSTR.Bits.ECCR7
    
    #define FECCRLO_ECCR0_MASK          1U
    #define FECCRLO_ECCR1_MASK          2U
    #define FECCRLO_ECCR2_MASK          4U
    #define FECCRLO_ECCR3_MASK          8U
    #define FECCRLO_ECCR4_MASK          16U
    #define FECCRLO_ECCR5_MASK          32U
    #define FECCRLO_ECCR6_MASK          64U
    #define FECCRLO_ECCR7_MASK          128U
    
  } Overlap_STR;

  struct {
    word ECCR0       :1;                                       /* Flash ECC Error Result Bit 0 */
    word ECCR1       :1;                                       /* Flash ECC Error Result Bit 1 */
    word ECCR2       :1;                                       /* Flash ECC Error Result Bit 2 */
    word ECCR3       :1;                                       /* Flash ECC Error Result Bit 3 */
    word ECCR4       :1;                                       /* Flash ECC Error Result Bit 4 */
    word ECCR5       :1;                                       /* Flash ECC Error Result Bit 5 */
    word ECCR6       :1;                                       /* Flash ECC Error Result Bit 6 */
    word ECCR7       :1;                                       /* Flash ECC Error Result Bit 7 */
    word ECCR8       :1;                                       /* Flash ECC Error Result Bit 8 */
    word ECCR9       :1;                                       /* Flash ECC Error Result Bit 9 */
    word ECCR10      :1;                                       /* Flash ECC Error Result Bit 10 */
    word ECCR11      :1;                                       /* Flash ECC Error Result Bit 11 */
    word ECCR12      :1;                                       /* Flash ECC Error Result Bit 12 */
    word ECCR13      :1;                                       /* Flash ECC Error Result Bit 13 */
    word ECCR14      :1;                                       /* Flash ECC Error Result Bit 14 */
    word ECCR15      :1;                                       /* Flash ECC Error Result Bit 15 */
  } Bits;
} FECCRSTR;
extern volatile FECCRSTR _FECCR @(REG_BASE + 0x0000010EUL);
#define FECCR                           _FECCR.Word
#define FECCR_ECCR0                     _FECCR.Bits.ECCR0
#define FECCR_ECCR1                     _FECCR.Bits.ECCR1
#define FECCR_ECCR2                     _FECCR.Bits.ECCR2
#define FECCR_ECCR3                     _FECCR.Bits.ECCR3
#define FECCR_ECCR4                     _FECCR.Bits.ECCR4
#define FECCR_ECCR5                     _FECCR.Bits.ECCR5
#define FECCR_ECCR6                     _FECCR.Bits.ECCR6
#define FECCR_ECCR7                     _FECCR.Bits.ECCR7
#define FECCR_ECCR8                     _FECCR.Bits.ECCR8
#define FECCR_ECCR9                     _FECCR.Bits.ECCR9
#define FECCR_ECCR10                    _FECCR.Bits.ECCR10
#define FECCR_ECCR11                    _FECCR.Bits.ECCR11
#define FECCR_ECCR12                    _FECCR.Bits.ECCR12
#define FECCR_ECCR13                    _FECCR.Bits.ECCR13
#define FECCR_ECCR14                    _FECCR.Bits.ECCR14
#define FECCR_ECCR15                    _FECCR.Bits.ECCR15

#define FECCR_ECCR0_MASK                1U
#define FECCR_ECCR1_MASK                2U
#define FECCR_ECCR2_MASK                4U
#define FECCR_ECCR3_MASK                8U
#define FECCR_ECCR4_MASK                16U
#define FECCR_ECCR5_MASK                32U
#define FECCR_ECCR6_MASK                64U
#define FECCR_ECCR7_MASK                128U
#define FECCR_ECCR8_MASK                256U
#define FECCR_ECCR9_MASK                512U
#define FECCR_ECCR10_MASK               1024U
#define FECCR_ECCR11_MASK               2048U
#define FECCR_ECCR12_MASK               4096U
#define FECCR_ECCR13_MASK               8192U
#define FECCR_ECCR14_MASK               16384U
#define FECCR_ECCR15_MASK               32768U


/*** FOPT - Flash Option Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Nonvolatile Bit 0 */
    byte NV1         :1;                                       /* Nonvolatile Bit 1 */
    byte NV2         :1;                                       /* Nonvolatile Bit 2 */
    byte NV3         :1;                                       /* Nonvolatile Bit 3 */
    byte NV4         :1;                                       /* Nonvolatile Bit 4 */
    byte NV5         :1;                                       /* Nonvolatile Bit 5 */
    byte NV6         :1;                                       /* Nonvolatile Bit 6 */
    byte NV7         :1;                                       /* Nonvolatile Bit 7 */
  } Bits;
} FOPTSTR;
extern volatile FOPTSTR _FOPT @(REG_BASE + 0x00000110UL);
#define FOPT                            _FOPT.Byte
#define FOPT_NV0                        _FOPT.Bits.NV0
#define FOPT_NV1                        _FOPT.Bits.NV1
#define FOPT_NV2                        _FOPT.Bits.NV2
#define FOPT_NV3                        _FOPT.Bits.NV3
#define FOPT_NV4                        _FOPT.Bits.NV4
#define FOPT_NV5                        _FOPT.Bits.NV5
#define FOPT_NV6                        _FOPT.Bits.NV6
#define FOPT_NV7                        _FOPT.Bits.NV7

#define FOPT_NV0_MASK                   1U
#define FOPT_NV1_MASK                   2U
#define FOPT_NV2_MASK                   4U
#define FOPT_NV3_MASK                   8U
#define FOPT_NV4_MASK                   16U
#define FOPT_NV5_MASK                   32U
#define FOPT_NV6_MASK                   64U
#define FOPT_NV7_MASK                   128U


/*** MPUFLG - MPU Flag Register; 0x00000114 ***/
typedef union {
  byte Byte;
  struct {
    byte SVSF        :1;                                       /* Supervisor State Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte NEXF        :1;                                       /* No-Execute Violation Flag */
    byte WPF         :1;                                       /* Write-Protect Violation Flag */
    byte AEF         :1;                                       /* Access Error Flag */
  } Bits;
} MPUFLGSTR;
extern volatile MPUFLGSTR _MPUFLG @(REG_BASE + 0x00000114UL);
#define MPUFLG                          _MPUFLG.Byte
#define MPUFLG_SVSF                     _MPUFLG.Bits.SVSF
#define MPUFLG_NEXF                     _MPUFLG.Bits.NEXF
#define MPUFLG_WPF                      _MPUFLG.Bits.WPF
#define MPUFLG_AEF                      _MPUFLG.Bits.AEF

#define MPUFLG_SVSF_MASK                1U
#define MPUFLG_NEXF_MASK                32U
#define MPUFLG_WPF_MASK                 64U
#define MPUFLG_AEF_MASK                 128U


/*** MPUASTAT0 - MPU Address Status Register 0; 0x00000115 ***/
typedef union {
  byte Byte;
  struct {
    byte ADDR16      :1;                                       /* Access violation address bits, bit 16 */
    byte ADDR17      :1;                                       /* Access violation address bits, bit 17 */
    byte ADDR18      :1;                                       /* Access violation address bits, bit 18 */
    byte ADDR19      :1;                                       /* Access violation address bits, bit 19 */
    byte ADDR20      :1;                                       /* Access violation address bits, bit 20 */
    byte ADDR21      :1;                                       /* Access violation address bits, bit 21 */
    byte ADDR22      :1;                                       /* Access violation address bits, bit 22 */
    byte             :1; 
  } Bits;
  struct {
    byte grpADDR_16 :7;
    byte         :1;
  } MergedBits;
} MPUASTAT0STR;
extern volatile MPUASTAT0STR _MPUASTAT0 @(REG_BASE + 0x00000115UL);
#define MPUASTAT0                       _MPUASTAT0.Byte
#define MPUASTAT0_ADDR16                _MPUASTAT0.Bits.ADDR16
#define MPUASTAT0_ADDR17                _MPUASTAT0.Bits.ADDR17
#define MPUASTAT0_ADDR18                _MPUASTAT0.Bits.ADDR18
#define MPUASTAT0_ADDR19                _MPUASTAT0.Bits.ADDR19
#define MPUASTAT0_ADDR20                _MPUASTAT0.Bits.ADDR20
#define MPUASTAT0_ADDR21                _MPUASTAT0.Bits.ADDR21
#define MPUASTAT0_ADDR22                _MPUASTAT0.Bits.ADDR22
/* MPUASTAT_ARR: Access 3 MPUASTATx registers in an array */
#define MPUASTAT_ARR                    ((volatile byte *) &MPUASTAT0)
#define MPUASTAT0_ADDR_16               _MPUASTAT0.MergedBits.grpADDR_16
#define MPUASTAT0_ADDR                  MPUASTAT0_ADDR_16

#define MPUASTAT0_ADDR16_MASK           1U
#define MPUASTAT0_ADDR17_MASK           2U
#define MPUASTAT0_ADDR18_MASK           4U
#define MPUASTAT0_ADDR19_MASK           8U
#define MPUASTAT0_ADDR20_MASK           16U
#define MPUASTAT0_ADDR21_MASK           32U
#define MPUASTAT0_ADDR22_MASK           64U
#define MPUASTAT0_ADDR_16_MASK          127U
#define MPUASTAT0_ADDR_16_BITNUM        0U


/*** MPUASTAT1 - MPU Address Status Register 1; 0x00000116 ***/
typedef union {
  byte Byte;
  struct {
    byte ADDR8       :1;                                       /* Access violation address bits, bit 8 */
    byte ADDR9       :1;                                       /* Access violation address bits, bit 9 */
    byte ADDR10      :1;                                       /* Access violation address bits, bit 10 */
    byte ADDR11      :1;                                       /* Access violation address bits, bit 11 */
    byte ADDR12      :1;                                       /* Access violation address bits, bit 12 */
    byte ADDR13      :1;                                       /* Access violation address bits, bit 13 */
    byte ADDR14      :1;                                       /* Access violation address bits, bit 14 */
    byte ADDR15      :1;                                       /* Access violation address bits, bit 15 */
  } Bits;
} MPUASTAT1STR;
extern volatile MPUASTAT1STR _MPUASTAT1 @(REG_BASE + 0x00000116UL);
#define MPUASTAT1                       _MPUASTAT1.Byte
#define MPUASTAT1_ADDR8                 _MPUASTAT1.Bits.ADDR8
#define MPUASTAT1_ADDR9                 _MPUASTAT1.Bits.ADDR9
#define MPUASTAT1_ADDR10                _MPUASTAT1.Bits.ADDR10
#define MPUASTAT1_ADDR11                _MPUASTAT1.Bits.ADDR11
#define MPUASTAT1_ADDR12                _MPUASTAT1.Bits.ADDR12
#define MPUASTAT1_ADDR13                _MPUASTAT1.Bits.ADDR13
#define MPUASTAT1_ADDR14                _MPUASTAT1.Bits.ADDR14
#define MPUASTAT1_ADDR15                _MPUASTAT1.Bits.ADDR15

#define MPUASTAT1_ADDR8_MASK            1U
#define MPUASTAT1_ADDR9_MASK            2U
#define MPUASTAT1_ADDR10_MASK           4U
#define MPUASTAT1_ADDR11_MASK           8U
#define MPUASTAT1_ADDR12_MASK           16U
#define MPUASTAT1_ADDR13_MASK           32U
#define MPUASTAT1_ADDR14_MASK           64U
#define MPUASTAT1_ADDR15_MASK           128U


/*** MPUASTAT2 - MPU Address Status Register 2; 0x00000117 ***/
typedef union {
  byte Byte;
  struct {
    byte ADDR0       :1;                                       /* Access violation address bits, bit 0 */
    byte ADDR1       :1;                                       /* Access violation address bits, bit 1 */
    byte ADDR2       :1;                                       /* Access violation address bits, bit 2 */
    byte ADDR3       :1;                                       /* Access violation address bits, bit 3 */
    byte ADDR4       :1;                                       /* Access violation address bits, bit 4 */
    byte ADDR5       :1;                                       /* Access violation address bits, bit 5 */
    byte ADDR6       :1;                                       /* Access violation address bits, bit 6 */
    byte ADDR7       :1;                                       /* Access violation address bits, bit 7 */
  } Bits;
} MPUASTAT2STR;
extern volatile MPUASTAT2STR _MPUASTAT2 @(REG_BASE + 0x00000117UL);
#define MPUASTAT2                       _MPUASTAT2.Byte
#define MPUASTAT2_ADDR0                 _MPUASTAT2.Bits.ADDR0
#define MPUASTAT2_ADDR1                 _MPUASTAT2.Bits.ADDR1
#define MPUASTAT2_ADDR2                 _MPUASTAT2.Bits.ADDR2
#define MPUASTAT2_ADDR3                 _MPUASTAT2.Bits.ADDR3
#define MPUASTAT2_ADDR4                 _MPUASTAT2.Bits.ADDR4
#define MPUASTAT2_ADDR5                 _MPUASTAT2.Bits.ADDR5
#define MPUASTAT2_ADDR6                 _MPUASTAT2.Bits.ADDR6
#define MPUASTAT2_ADDR7                 _MPUASTAT2.Bits.ADDR7

#define MPUASTAT2_ADDR0_MASK            1U
#define MPUASTAT2_ADDR1_MASK            2U
#define MPUASTAT2_ADDR2_MASK            4U
#define MPUASTAT2_ADDR3_MASK            8U
#define MPUASTAT2_ADDR4_MASK            16U
#define MPUASTAT2_ADDR5_MASK            32U
#define MPUASTAT2_ADDR6_MASK            64U
#define MPUASTAT2_ADDR7_MASK            128U


/*** MPUSEL - MPU Descriptor Select Register; 0x00000119 ***/
typedef union {
  byte Byte;
  struct {
    byte SEL         :3;                                       /* Descriptor select */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte SVSEN       :1;                                       /* MPU supervisor state enable bit */
  } Bits;
} MPUSELSTR;
extern volatile MPUSELSTR _MPUSEL @(REG_BASE + 0x00000119UL);
#define MPUSEL                          _MPUSEL.Byte
#define MPUSEL_SEL                      _MPUSEL.Bits.SEL
#define MPUSEL_SVSEN                    _MPUSEL.Bits.SVSEN

#define MPUSEL_SEL_MASK                 7U
#define MPUSEL_SEL_BITNUM               0U
#define MPUSEL_SVSEN_MASK               128U


/*** MPUDESC0 - MPU Descriptor Register 0; 0x0000011A ***/
typedef union {
  byte Byte;
  struct {
    byte LOW_ADDR19  :1;                                       /* Memory range lower boundary address bits, bit 19 */
    byte LOW_ADDR20  :1;                                       /* Memory range lower boundary address bits, bit 20 */
    byte LOW_ADDR21  :1;                                       /* Memory range lower boundary address bits, bit 21 */
    byte LOW_ADDR22  :1;                                       /* Memory range lower boundary address bits, bit 22 */
    byte MSTR3       :1;                                       /* Master 3 select bit */
    byte MSTR2       :1;                                       /* Master 2 select bit */
    byte MSTR1       :1;                                       /* Master 1 select bit */
    byte MSTR0       :1;                                       /* Master 0 select bit */
  } Bits;
  struct {
    byte grpLOW_ADDR_19 :4;
    byte grpMSTR_3 :1;
    byte grpMSTR_2 :1;
    byte grpMSTR_1 :1;
    byte grpMSTR :1;
  } MergedBits;
} MPUDESC0STR;
extern volatile MPUDESC0STR _MPUDESC0 @(REG_BASE + 0x0000011AUL);
#define MPUDESC0                        _MPUDESC0.Byte
#define MPUDESC0_LOW_ADDR19             _MPUDESC0.Bits.LOW_ADDR19
#define MPUDESC0_LOW_ADDR20             _MPUDESC0.Bits.LOW_ADDR20
#define MPUDESC0_LOW_ADDR21             _MPUDESC0.Bits.LOW_ADDR21
#define MPUDESC0_LOW_ADDR22             _MPUDESC0.Bits.LOW_ADDR22
#define MPUDESC0_MSTR3                  _MPUDESC0.Bits.MSTR3
#define MPUDESC0_MSTR2                  _MPUDESC0.Bits.MSTR2
#define MPUDESC0_MSTR1                  _MPUDESC0.Bits.MSTR1
#define MPUDESC0_MSTR0                  _MPUDESC0.Bits.MSTR0
/* MPUDESC_ARR: Access 6 MPUDESCx registers in an array */
#define MPUDESC_ARR                     ((volatile byte *) &MPUDESC0)
#define MPUDESC0_LOW_ADDR_19            _MPUDESC0.MergedBits.grpLOW_ADDR_19
#define MPUDESC0_LOW_ADDR               MPUDESC0_LOW_ADDR_19

#define MPUDESC0_LOW_ADDR19_MASK        1U
#define MPUDESC0_LOW_ADDR20_MASK        2U
#define MPUDESC0_LOW_ADDR21_MASK        4U
#define MPUDESC0_LOW_ADDR22_MASK        8U
#define MPUDESC0_MSTR3_MASK             16U
#define MPUDESC0_MSTR2_MASK             32U
#define MPUDESC0_MSTR1_MASK             64U
#define MPUDESC0_MSTR0_MASK             128U
#define MPUDESC0_LOW_ADDR_19_MASK       15U
#define MPUDESC0_LOW_ADDR_19_BITNUM     0U


/*** MPUDESC1 - MPU Descriptor Register 1; 0x0000011B ***/
typedef union {
  byte Byte;
  struct {
    byte LOW_ADDR11  :1;                                       /* Memory range lower boundary address bits, bit 11 */
    byte LOW_ADDR12  :1;                                       /* Memory range lower boundary address bits, bit 12 */
    byte LOW_ADDR13  :1;                                       /* Memory range lower boundary address bits, bit 13 */
    byte LOW_ADDR14  :1;                                       /* Memory range lower boundary address bits, bit 14 */
    byte LOW_ADDR15  :1;                                       /* Memory range lower boundary address bits, bit 15 */
    byte LOW_ADDR16  :1;                                       /* Memory range lower boundary address bits, bit 16 */
    byte LOW_ADDR17  :1;                                       /* Memory range lower boundary address bits, bit 17 */
    byte LOW_ADDR18  :1;                                       /* Memory range lower boundary address bits, bit 18 */
  } Bits;
} MPUDESC1STR;
extern volatile MPUDESC1STR _MPUDESC1 @(REG_BASE + 0x0000011BUL);
#define MPUDESC1                        _MPUDESC1.Byte
#define MPUDESC1_LOW_ADDR11             _MPUDESC1.Bits.LOW_ADDR11
#define MPUDESC1_LOW_ADDR12             _MPUDESC1.Bits.LOW_ADDR12
#define MPUDESC1_LOW_ADDR13             _MPUDESC1.Bits.LOW_ADDR13
#define MPUDESC1_LOW_ADDR14             _MPUDESC1.Bits.LOW_ADDR14
#define MPUDESC1_LOW_ADDR15             _MPUDESC1.Bits.LOW_ADDR15
#define MPUDESC1_LOW_ADDR16             _MPUDESC1.Bits.LOW_ADDR16
#define MPUDESC1_LOW_ADDR17             _MPUDESC1.Bits.LOW_ADDR17
#define MPUDESC1_LOW_ADDR18             _MPUDESC1.Bits.LOW_ADDR18

#define MPUDESC1_LOW_ADDR11_MASK        1U
#define MPUDESC1_LOW_ADDR12_MASK        2U
#define MPUDESC1_LOW_ADDR13_MASK        4U
#define MPUDESC1_LOW_ADDR14_MASK        8U
#define MPUDESC1_LOW_ADDR15_MASK        16U
#define MPUDESC1_LOW_ADDR16_MASK        32U
#define MPUDESC1_LOW_ADDR17_MASK        64U
#define MPUDESC1_LOW_ADDR18_MASK        128U


/*** MPUDESC2 - MPU Descriptor Register 2; 0x0000011C ***/
typedef union {
  byte Byte;
  struct {
    byte LOW_ADDR3   :1;                                       /* Memory range lower boundary address bits, bit 3 */
    byte LOW_ADDR4   :1;                                       /* Memory range lower boundary address bits, bit 4 */
    byte LOW_ADDR5   :1;                                       /* Memory range lower boundary address bits, bit 5 */
    byte LOW_ADDR6   :1;                                       /* Memory range lower boundary address bits, bit 6 */
    byte LOW_ADDR7   :1;                                       /* Memory range lower boundary address bits, bit 7 */
    byte LOW_ADDR8   :1;                                       /* Memory range lower boundary address bits, bit 8 */
    byte LOW_ADDR9   :1;                                       /* Memory range lower boundary address bits, bit 9 */
    byte LOW_ADDR10  :1;                                       /* Memory range lower boundary address bits, bit 10 */
  } Bits;
} MPUDESC2STR;
extern volatile MPUDESC2STR _MPUDESC2 @(REG_BASE + 0x0000011CUL);
#define MPUDESC2                        _MPUDESC2.Byte
#define MPUDESC2_LOW_ADDR3              _MPUDESC2.Bits.LOW_ADDR3
#define MPUDESC2_LOW_ADDR4              _MPUDESC2.Bits.LOW_ADDR4
#define MPUDESC2_LOW_ADDR5              _MPUDESC2.Bits.LOW_ADDR5
#define MPUDESC2_LOW_ADDR6              _MPUDESC2.Bits.LOW_ADDR6
#define MPUDESC2_LOW_ADDR7              _MPUDESC2.Bits.LOW_ADDR7
#define MPUDESC2_LOW_ADDR8              _MPUDESC2.Bits.LOW_ADDR8
#define MPUDESC2_LOW_ADDR9              _MPUDESC2.Bits.LOW_ADDR9
#define MPUDESC2_LOW_ADDR10             _MPUDESC2.Bits.LOW_ADDR10

#define MPUDESC2_LOW_ADDR3_MASK         1U
#define MPUDESC2_LOW_ADDR4_MASK         2U
#define MPUDESC2_LOW_ADDR5_MASK         4U
#define MPUDESC2_LOW_ADDR6_MASK         8U
#define MPUDESC2_LOW_ADDR7_MASK         16U
#define MPUDESC2_LOW_ADDR8_MASK         32U
#define MPUDESC2_LOW_ADDR9_MASK         64U
#define MPUDESC2_LOW_ADDR10_MASK        128U


/*** MPUDESC3 - MPU Descriptor Register 2; 0x0000011D ***/
typedef union {
  byte Byte;
  struct {
    byte HIGH_ADDR19 :1;                                       /* Memory range upper boundary address bits, bit 19 */
    byte HIGH_ADDR20 :1;                                       /* Memory range upper boundary address bits, bit 20 */
    byte HIGH_ADDR21 :1;                                       /* Memory range upper boundary address bits, bit 21 */
    byte HIGH_ADDR22 :1;                                       /* Memory range upper boundary address bits, bit 22 */
    byte             :1; 
    byte             :1; 
    byte NEX         :1;                                       /* No-Execute bit */
    byte WP          :1;                                       /* Write-Protect bit */
  } Bits;
  struct {
    byte grpHIGH_ADDR_19 :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MPUDESC3STR;
extern volatile MPUDESC3STR _MPUDESC3 @(REG_BASE + 0x0000011DUL);
#define MPUDESC3                        _MPUDESC3.Byte
#define MPUDESC3_HIGH_ADDR19            _MPUDESC3.Bits.HIGH_ADDR19
#define MPUDESC3_HIGH_ADDR20            _MPUDESC3.Bits.HIGH_ADDR20
#define MPUDESC3_HIGH_ADDR21            _MPUDESC3.Bits.HIGH_ADDR21
#define MPUDESC3_HIGH_ADDR22            _MPUDESC3.Bits.HIGH_ADDR22
#define MPUDESC3_NEX                    _MPUDESC3.Bits.NEX
#define MPUDESC3_WP                     _MPUDESC3.Bits.WP
#define MPUDESC3_HIGH_ADDR_19           _MPUDESC3.MergedBits.grpHIGH_ADDR_19
#define MPUDESC3_HIGH_ADDR              MPUDESC3_HIGH_ADDR_19

#define MPUDESC3_HIGH_ADDR19_MASK       1U
#define MPUDESC3_HIGH_ADDR20_MASK       2U
#define MPUDESC3_HIGH_ADDR21_MASK       4U
#define MPUDESC3_HIGH_ADDR22_MASK       8U
#define MPUDESC3_NEX_MASK               64U
#define MPUDESC3_WP_MASK                128U
#define MPUDESC3_HIGH_ADDR_19_MASK      15U
#define MPUDESC3_HIGH_ADDR_19_BITNUM    0U


/*** MPUDESC4 - MPU Descriptor Register 2; 0x0000011E ***/
typedef union {
  byte Byte;
  struct {
    byte HIGH_ADDR11 :1;                                       /* Memory range upper boundary address bits, bit 11 */
    byte HIGH_ADDR12 :1;                                       /* Memory range upper boundary address bits, bit 12 */
    byte HIGH_ADDR13 :1;                                       /* Memory range upper boundary address bits, bit 13 */
    byte HIGH_ADDR14 :1;                                       /* Memory range upper boundary address bits, bit 14 */
    byte HIGH_ADDR15 :1;                                       /* Memory range upper boundary address bits, bit 15 */
    byte HIGH_ADDR16 :1;                                       /* Memory range upper boundary address bits, bit 16 */
    byte HIGH_ADDR17 :1;                                       /* Memory range upper boundary address bits, bit 17 */
    byte HIGH_ADDR18 :1;                                       /* Memory range upper boundary address bits, bit 18 */
  } Bits;
} MPUDESC4STR;
extern volatile MPUDESC4STR _MPUDESC4 @(REG_BASE + 0x0000011EUL);
#define MPUDESC4                        _MPUDESC4.Byte
#define MPUDESC4_HIGH_ADDR11            _MPUDESC4.Bits.HIGH_ADDR11
#define MPUDESC4_HIGH_ADDR12            _MPUDESC4.Bits.HIGH_ADDR12
#define MPUDESC4_HIGH_ADDR13            _MPUDESC4.Bits.HIGH_ADDR13
#define MPUDESC4_HIGH_ADDR14            _MPUDESC4.Bits.HIGH_ADDR14
#define MPUDESC4_HIGH_ADDR15            _MPUDESC4.Bits.HIGH_ADDR15
#define MPUDESC4_HIGH_ADDR16            _MPUDESC4.Bits.HIGH_ADDR16
#define MPUDESC4_HIGH_ADDR17            _MPUDESC4.Bits.HIGH_ADDR17
#define MPUDESC4_HIGH_ADDR18            _MPUDESC4.Bits.HIGH_ADDR18

#define MPUDESC4_HIGH_ADDR11_MASK       1U
#define MPUDESC4_HIGH_ADDR12_MASK       2U
#define MPUDESC4_HIGH_ADDR13_MASK       4U
#define MPUDESC4_HIGH_ADDR14_MASK       8U
#define MPUDESC4_HIGH_ADDR15_MASK       16U
#define MPUDESC4_HIGH_ADDR16_MASK       32U
#define MPUDESC4_HIGH_ADDR17_MASK       64U
#define MPUDESC4_HIGH_ADDR18_MASK       128U


/*** MPUDESC5 - MPU Descriptor Register 2; 0x0000011F ***/
typedef union {
  byte Byte;
  struct {
    byte HIGH_ADDR3  :1;                                       /* Memory range upper boundary address bits, bit 3 */
    byte HIGH_ADDR4  :1;                                       /* Memory range upper boundary address bits, bit 4 */
    byte HIGH_ADDR5  :1;                                       /* Memory range upper boundary address bits, bit 5 */
    byte HIGH_ADDR6  :1;                                       /* Memory range upper boundary address bits, bit 6 */
    byte HIGH_ADDR7  :1;                                       /* Memory range upper boundary address bits, bit 7 */
    byte HIGH_ADDR8  :1;                                       /* Memory range upper boundary address bits, bit 8 */
    byte HIGH_ADDR9  :1;                                       /* Memory range upper boundary address bits, bit 9 */
    byte HIGH_ADDR10 :1;                                       /* Memory range upper boundary address bits, bit 10 */
  } Bits;
} MPUDESC5STR;
extern volatile MPUDESC5STR _MPUDESC5 @(REG_BASE + 0x0000011FUL);
#define MPUDESC5                        _MPUDESC5.Byte
#define MPUDESC5_HIGH_ADDR3             _MPUDESC5.Bits.HIGH_ADDR3
#define MPUDESC5_HIGH_ADDR4             _MPUDESC5.Bits.HIGH_ADDR4
#define MPUDESC5_HIGH_ADDR5             _MPUDESC5.Bits.HIGH_ADDR5
#define MPUDESC5_HIGH_ADDR6             _MPUDESC5.Bits.HIGH_ADDR6
#define MPUDESC5_HIGH_ADDR7             _MPUDESC5.Bits.HIGH_ADDR7
#define MPUDESC5_HIGH_ADDR8             _MPUDESC5.Bits.HIGH_ADDR8
#define MPUDESC5_HIGH_ADDR9             _MPUDESC5.Bits.HIGH_ADDR9
#define MPUDESC5_HIGH_ADDR10            _MPUDESC5.Bits.HIGH_ADDR10

#define MPUDESC5_HIGH_ADDR3_MASK        1U
#define MPUDESC5_HIGH_ADDR4_MASK        2U
#define MPUDESC5_HIGH_ADDR5_MASK        4U
#define MPUDESC5_HIGH_ADDR6_MASK        8U
#define MPUDESC5_HIGH_ADDR7_MASK        16U
#define MPUDESC5_HIGH_ADDR8_MASK        32U
#define MPUDESC5_HIGH_ADDR9_MASK        64U
#define MPUDESC5_HIGH_ADDR10_MASK       128U


/*** IVBR - Interrupt Vector Base Register; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte IVB_ADDR    :8;                                       /* Interrupt Vector Base Address Bits */
  } Bits;
} IVBRSTR;
extern volatile IVBRSTR _IVBR @(REG_BASE + 0x00000121UL);
#define IVBR                            _IVBR.Byte
#define IVBR_IVB_ADDR                   _IVBR.Bits.IVB_ADDR

#define IVBR_IVB_ADDR_MASK              255U
#define IVBR_IVB_ADDR_BITNUM            0U


/*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x00000126 ***/
typedef union {
  byte Byte;
  struct {
    byte XILVL       :3;                                       /* XGATE Interrupt Priority Level */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} INT_XGPRIOSTR;
extern volatile INT_XGPRIOSTR _INT_XGPRIO @(REG_BASE + 0x00000126UL);
#define INT_XGPRIO                      _INT_XGPRIO.Byte
#define INT_XGPRIO_XILVL                _INT_XGPRIO.Bits.XILVL

#define INT_XGPRIO_XILVL_MASK           7U
#define INT_XGPRIO_XILVL_BITNUM         0U


/*** INT_CFADDR - Interrupt Request Configuration Address Register; 0x00000127 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte INT_CFADDR_grp :4;                                    /* Interrupt Request Configuration Data Register Select Bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} INT_CFADDRSTR;
extern volatile INT_CFADDRSTR _INT_CFADDR @(REG_BASE + 0x00000127UL);
#define INT_CFADDR                      _INT_CFADDR.Byte
#define INT_CFADDR_INT_CFADDR           _INT_CFADDR.Bits.INT_CFADDR_grp

#define INT_CFADDR_INT_CFADDR_MASK      240U
#define INT_CFADDR_INT_CFADDR_BITNUM    4U


/*** INT_CFDATA0 - Interrupt Request Configuration Data Register 0; 0x00000128 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA0STR;
extern volatile INT_CFDATA0STR _INT_CFDATA0 @(REG_BASE + 0x00000128UL);
#define INT_CFDATA0                     _INT_CFDATA0.Byte
#define INT_CFDATA0_PRIOLVL             _INT_CFDATA0.Bits.PRIOLVL
#define INT_CFDATA0_RQST                _INT_CFDATA0.Bits.RQST
/* INT_CFDATA_ARR: Access 8 INT_CFDATAx registers in an array */
#define INT_CFDATA_ARR                  ((volatile byte *) &INT_CFDATA0)

#define INT_CFDATA0_PRIOLVL_MASK        7U
#define INT_CFDATA0_PRIOLVL_BITNUM      0U
#define INT_CFDATA0_RQST_MASK           128U


/*** INT_CFDATA1 - Interrupt Request Configuration Data Register 1; 0x00000129 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA1STR;
extern volatile INT_CFDATA1STR _INT_CFDATA1 @(REG_BASE + 0x00000129UL);
#define INT_CFDATA1                     _INT_CFDATA1.Byte
#define INT_CFDATA1_PRIOLVL             _INT_CFDATA1.Bits.PRIOLVL
#define INT_CFDATA1_RQST                _INT_CFDATA1.Bits.RQST

#define INT_CFDATA1_PRIOLVL_MASK        7U
#define INT_CFDATA1_PRIOLVL_BITNUM      0U
#define INT_CFDATA1_RQST_MASK           128U


/*** INT_CFDATA2 - Interrupt Request Configuration Data Register 2; 0x0000012A ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA2STR;
extern volatile INT_CFDATA2STR _INT_CFDATA2 @(REG_BASE + 0x0000012AUL);
#define INT_CFDATA2                     _INT_CFDATA2.Byte
#define INT_CFDATA2_PRIOLVL             _INT_CFDATA2.Bits.PRIOLVL
#define INT_CFDATA2_RQST                _INT_CFDATA2.Bits.RQST

#define INT_CFDATA2_PRIOLVL_MASK        7U
#define INT_CFDATA2_PRIOLVL_BITNUM      0U
#define INT_CFDATA2_RQST_MASK           128U


/*** INT_CFDATA3 - Interrupt Request Configuration Data Register 3; 0x0000012B ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA3STR;
extern volatile INT_CFDATA3STR _INT_CFDATA3 @(REG_BASE + 0x0000012BUL);
#define INT_CFDATA3                     _INT_CFDATA3.Byte
#define INT_CFDATA3_PRIOLVL             _INT_CFDATA3.Bits.PRIOLVL
#define INT_CFDATA3_RQST                _INT_CFDATA3.Bits.RQST

#define INT_CFDATA3_PRIOLVL_MASK        7U
#define INT_CFDATA3_PRIOLVL_BITNUM      0U
#define INT_CFDATA3_RQST_MASK           128U


/*** INT_CFDATA4 - Interrupt Request Configuration Data Register 4; 0x0000012C ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA4STR;
extern volatile INT_CFDATA4STR _INT_CFDATA4 @(REG_BASE + 0x0000012CUL);
#define INT_CFDATA4                     _INT_CFDATA4.Byte
#define INT_CFDATA4_PRIOLVL             _INT_CFDATA4.Bits.PRIOLVL
#define INT_CFDATA4_RQST                _INT_CFDATA4.Bits.RQST

#define INT_CFDATA4_PRIOLVL_MASK        7U
#define INT_CFDATA4_PRIOLVL_BITNUM      0U
#define INT_CFDATA4_RQST_MASK           128U


/*** INT_CFDATA5 - Interrupt Request Configuration Data Register 5; 0x0000012D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA5STR;
extern volatile INT_CFDATA5STR _INT_CFDATA5 @(REG_BASE + 0x0000012DUL);
#define INT_CFDATA5                     _INT_CFDATA5.Byte
#define INT_CFDATA5_PRIOLVL             _INT_CFDATA5.Bits.PRIOLVL
#define INT_CFDATA5_RQST                _INT_CFDATA5.Bits.RQST

#define INT_CFDATA5_PRIOLVL_MASK        7U
#define INT_CFDATA5_PRIOLVL_BITNUM      0U
#define INT_CFDATA5_RQST_MASK           128U


/*** INT_CFDATA6 - Interrupt Request Configuration Data Register 6; 0x0000012E ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA6STR;
extern volatile INT_CFDATA6STR _INT_CFDATA6 @(REG_BASE + 0x0000012EUL);
#define INT_CFDATA6                     _INT_CFDATA6.Byte
#define INT_CFDATA6_PRIOLVL             _INT_CFDATA6.Bits.PRIOLVL
#define INT_CFDATA6_RQST                _INT_CFDATA6.Bits.RQST

#define INT_CFDATA6_PRIOLVL_MASK        7U
#define INT_CFDATA6_PRIOLVL_BITNUM      0U
#define INT_CFDATA6_RQST_MASK           128U


/*** INT_CFDATA7 - Interrupt Request Configuration Data Register 7; 0x0000012F ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA7STR;
extern volatile INT_CFDATA7STR _INT_CFDATA7 @(REG_BASE + 0x0000012FUL);
#define INT_CFDATA7                     _INT_CFDATA7.Byte
#define INT_CFDATA7_PRIOLVL             _INT_CFDATA7.Bits.PRIOLVL
#define INT_CFDATA7_RQST                _INT_CFDATA7.Bits.RQST

#define INT_CFDATA7_PRIOLVL_MASK        7U
#define INT_CFDATA7_PRIOLVL_BITNUM      0U
#define INT_CFDATA7_RQST_MASK           128U


/*** SCI4BD - SCI 4 Baud Rate Register; 0x00000130 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI4ASR1 - SCI 4 Alternative Status Register 1; 0x00000130 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI4ASR1 - SCI 4 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI4ASR1STR;
        #define SCI4ASR1                _SCI4BD.Overlap_STR.SCI4ASR1STR.Byte
        #define SCI4ASR1_BKDIF          _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4ASR1STR.Bits.BKDIF
        #define SCI4ASR1_BERRIF         _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4ASR1STR.Bits.BERRIF
        #define SCI4ASR1_BERRV          _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4ASR1STR.Bits.BERRV
        #define SCI4ASR1_RXEDGIF        _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4ASR1STR.Bits.RXEDGIF
        
        #define SCI4ASR1_BKDIF_MASK     1U
        #define SCI4ASR1_BERRIF_MASK    2U
        #define SCI4ASR1_BERRV_MASK     4U
        #define SCI4ASR1_RXEDGIF_MASK   128U
        
        /*** SCI4BDH - SCI 4 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI4BDHSTR;
        #define SCI4BDH                 _SCI4BD.Overlap_STR.SCI4ASR1STR.Byte
        #define SCI4BDH_SBR8            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR8
        #define SCI4BDH_SBR9            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR9
        #define SCI4BDH_SBR10           _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR10
        #define SCI4BDH_SBR11           _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR11
        #define SCI4BDH_SBR12           _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR12
        #define SCI4BDH_TNP0            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.TNP0
        #define SCI4BDH_TNP1            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.TNP1
        #define SCI4BDH_IREN            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.IREN
        #define SCI4BDH_SBR_8           _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.MergedBits.grpSBR_8
        #define SCI4BDH_TNP             _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.MergedBits.grpTNP
        #define SCI4BDH_SBR             SCI4BDH_SBR_8
        
        #define SCI4BDH_SBR8_MASK       1U
        #define SCI4BDH_SBR9_MASK       2U
        #define SCI4BDH_SBR10_MASK      4U
        #define SCI4BDH_SBR11_MASK      8U
        #define SCI4BDH_SBR12_MASK      16U
        #define SCI4BDH_TNP0_MASK       32U
        #define SCI4BDH_TNP1_MASK       64U
        #define SCI4BDH_IREN_MASK       128U
        #define SCI4BDH_SBR_8_MASK      31U
        #define SCI4BDH_SBR_8_BITNUM    0U
        #define SCI4BDH_TNP_MASK        96U
        #define SCI4BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI4ASR1STR;
    

    /*** SCI4ACR1 - SCI 4 Alternative Control Register 1; 0x00000131 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI4ACR1 - SCI 4 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI4ACR1STR;
        #define SCI4ACR1                _SCI4BD.Overlap_STR.SCI4ACR1STR.Byte
        #define SCI4ACR1_BKDIE          _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4ACR1STR.Bits.BKDIE
        #define SCI4ACR1_BERRIE         _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4ACR1STR.Bits.BERRIE
        #define SCI4ACR1_RXEDGIE        _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4ACR1STR.Bits.RXEDGIE
        
        #define SCI4ACR1_BKDIE_MASK     1U
        #define SCI4ACR1_BERRIE_MASK    2U
        #define SCI4ACR1_RXEDGIE_MASK   128U
        
        /*** SCI4BDL - SCI 4 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI4BDLSTR;
        #define SCI4BDL                 _SCI4BD.Overlap_STR.SCI4ACR1STR.Byte
        #define SCI4BDL_SBR0            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR0
        #define SCI4BDL_SBR1            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR1
        #define SCI4BDL_SBR2            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR2
        #define SCI4BDL_SBR3            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR3
        #define SCI4BDL_SBR4            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR4
        #define SCI4BDL_SBR5            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR5
        #define SCI4BDL_SBR6            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR6
        #define SCI4BDL_SBR7            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR7
        
        #define SCI4BDL_SBR0_MASK       1U
        #define SCI4BDL_SBR1_MASK       2U
        #define SCI4BDL_SBR2_MASK       4U
        #define SCI4BDL_SBR3_MASK       8U
        #define SCI4BDL_SBR4_MASK       16U
        #define SCI4BDL_SBR5_MASK       32U
        #define SCI4BDL_SBR6_MASK       64U
        #define SCI4BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI4ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI4BDSTR;
extern volatile SCI4BDSTR _SCI4BD @(REG_BASE + 0x00000130UL);
#define SCI4BD                          _SCI4BD.Word
#define SCI4BD_SBR0                     _SCI4BD.Bits.SBR0
#define SCI4BD_SBR1                     _SCI4BD.Bits.SBR1
#define SCI4BD_SBR2                     _SCI4BD.Bits.SBR2
#define SCI4BD_SBR3                     _SCI4BD.Bits.SBR3
#define SCI4BD_SBR4                     _SCI4BD.Bits.SBR4
#define SCI4BD_SBR5                     _SCI4BD.Bits.SBR5
#define SCI4BD_SBR6                     _SCI4BD.Bits.SBR6
#define SCI4BD_SBR7                     _SCI4BD.Bits.SBR7
#define SCI4BD_SBR8                     _SCI4BD.Bits.SBR8
#define SCI4BD_SBR9                     _SCI4BD.Bits.SBR9
#define SCI4BD_SBR10                    _SCI4BD.Bits.SBR10
#define SCI4BD_SBR11                    _SCI4BD.Bits.SBR11
#define SCI4BD_SBR12                    _SCI4BD.Bits.SBR12
#define SCI4BD_TNP0                     _SCI4BD.Bits.TNP0
#define SCI4BD_TNP1                     _SCI4BD.Bits.TNP1
#define SCI4BD_IREN                     _SCI4BD.Bits.IREN
#define SCI4BD_SBR                      _SCI4BD.MergedBits.grpSBR
#define SCI4BD_TNP                      _SCI4BD.MergedBits.grpTNP

#define SCI4BD_SBR0_MASK                1U
#define SCI4BD_SBR1_MASK                2U
#define SCI4BD_SBR2_MASK                4U
#define SCI4BD_SBR3_MASK                8U
#define SCI4BD_SBR4_MASK                16U
#define SCI4BD_SBR5_MASK                32U
#define SCI4BD_SBR6_MASK                64U
#define SCI4BD_SBR7_MASK                128U
#define SCI4BD_SBR8_MASK                256U
#define SCI4BD_SBR9_MASK                512U
#define SCI4BD_SBR10_MASK               1024U
#define SCI4BD_SBR11_MASK               2048U
#define SCI4BD_SBR12_MASK               4096U
#define SCI4BD_TNP0_MASK                8192U
#define SCI4BD_TNP1_MASK                16384U
#define SCI4BD_IREN_MASK                32768U
#define SCI4BD_SBR_MASK                 8191U
#define SCI4BD_SBR_BITNUM               0U
#define SCI4BD_TNP_MASK                 24576U
#define SCI4BD_TNP_BITNUM               13U


/*** SCI4ACR2 - SCI 4 Alternative Control Register 2; 0x00000132 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI4ACR2 - SCI 4 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI4ACR2STR;
    #define SCI4ACR2                    _SCI4ACR2.Byte
    #define SCI4ACR2_BKDFE              _SCI4ACR2.SameAddr_STR.SCI4ACR2STR.Bits.BKDFE
    #define SCI4ACR2_BERRM0             _SCI4ACR2.SameAddr_STR.SCI4ACR2STR.Bits.BERRM0
    #define SCI4ACR2_BERRM1             _SCI4ACR2.SameAddr_STR.SCI4ACR2STR.Bits.BERRM1
    #define SCI4ACR2_BERRM              _SCI4ACR2.SameAddr_STR.SCI4ACR2STR.MergedBits.grpBERRM
    
    #define SCI4ACR2_BKDFE_MASK         1U
    #define SCI4ACR2_BERRM0_MASK        2U
    #define SCI4ACR2_BERRM1_MASK        4U
    #define SCI4ACR2_BERRM_MASK         6U
    #define SCI4ACR2_BERRM_BITNUM       1U
    
    /*** SCI4CR1 - SCI 4 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI4CR1STR;
    #define SCI4CR1                     _SCI4ACR2.Byte
    #define SCI4CR1_PT                  _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.PT
    #define SCI4CR1_PE                  _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.PE
    #define SCI4CR1_ILT                 _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.ILT
    #define SCI4CR1_WAKE                _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.WAKE
    #define SCI4CR1_M                   _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.M
    #define SCI4CR1_RSRC                _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.RSRC
    #define SCI4CR1_SCISWAI             _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.SCISWAI
    #define SCI4CR1_LOOPS               _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.LOOPS
    
    #define SCI4CR1_PT_MASK             1U
    #define SCI4CR1_PE_MASK             2U
    #define SCI4CR1_ILT_MASK            4U
    #define SCI4CR1_WAKE_MASK           8U
    #define SCI4CR1_M_MASK              16U
    #define SCI4CR1_RSRC_MASK           32U
    #define SCI4CR1_SCISWAI_MASK        64U
    #define SCI4CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI4ACR2STR;
extern volatile SCI4ACR2STR _SCI4ACR2 @(REG_BASE + 0x00000132UL);


/*** SCI4CR2 - SCI 4 Control Register 2; 0x00000133 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE         :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI4CR2STR;
extern volatile SCI4CR2STR _SCI4CR2 @(REG_BASE + 0x00000133UL);
#define SCI4CR2                         _SCI4CR2.Byte
#define SCI4CR2_SBK                     _SCI4CR2.Bits.SBK
#define SCI4CR2_RWU                     _SCI4CR2.Bits.RWU
#define SCI4CR2_RE                      _SCI4CR2.Bits.RE
#define SCI4CR2_TE                      _SCI4CR2.Bits.TE
#define SCI4CR2_ILIE                    _SCI4CR2.Bits.ILIE
#define SCI4CR2_RIE                     _SCI4CR2.Bits.RIE
#define SCI4CR2_TCIE                    _SCI4CR2.Bits.TCIE
#define SCI4CR2_TIE                     _SCI4CR2.Bits.TIE

#define SCI4CR2_SBK_MASK                1U
#define SCI4CR2_RWU_MASK                2U
#define SCI4CR2_RE_MASK                 4U
#define SCI4CR2_TE_MASK                 8U
#define SCI4CR2_ILIE_MASK               16U
#define SCI4CR2_RIE_MASK                32U
#define SCI4CR2_TCIE_MASK               64U
#define SCI4CR2_TIE_MASK                128U


/*** SCI4SR1 - SCI 4 Status Register 1; 0x00000134 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF_bit    :1;                                       /* Receive Data Register Full Flag */ /*Warning: bit name is duplicated with register name*/
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI4SR1STR;
extern volatile SCI4SR1STR _SCI4SR1 @(REG_BASE + 0x00000134UL);
#define SCI4SR1                         _SCI4SR1.Byte
#define SCI4SR1_PF                      _SCI4SR1.Bits.PF
#define SCI4SR1_FE                      _SCI4SR1.Bits.FE
#define SCI4SR1_NF                      _SCI4SR1.Bits.NF
#define SCI4SR1_OR                      _SCI4SR1.Bits.OR
#define SCI4SR1_IDLE                    _SCI4SR1.Bits.IDLE
#define SCI4SR1_RDRF                    _SCI4SR1.Bits.RDRF_bit
#define SCI4SR1_TC                      _SCI4SR1.Bits.TC
#define SCI4SR1_TDRE                    _SCI4SR1.Bits.TDRE

#define SCI4SR1_PF_MASK                 1U
#define SCI4SR1_FE_MASK                 2U
#define SCI4SR1_NF_MASK                 4U
#define SCI4SR1_OR_MASK                 8U
#define SCI4SR1_IDLE_MASK               16U
#define SCI4SR1_RDRF_MASK               32U
#define SCI4SR1_TC_MASK                 64U
#define SCI4SR1_TDRE_MASK               128U


/*** SCI4SR2 - SCI 4 Status Register 2; 0x00000135 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI4SR2STR;
extern volatile SCI4SR2STR _SCI4SR2 @(REG_BASE + 0x00000135UL);
#define SCI4SR2                         _SCI4SR2.Byte
#define SCI4SR2_RAF                     _SCI4SR2.Bits.RAF
#define SCI4SR2_TXDIR                   _SCI4SR2.Bits.TXDIR
#define SCI4SR2_BRK13                   _SCI4SR2.Bits.BRK13
#define SCI4SR2_RXPOL                   _SCI4SR2.Bits.RXPOL
#define SCI4SR2_TXPOL                   _SCI4SR2.Bits.TXPOL
#define SCI4SR2_AMAP                    _SCI4SR2.Bits.AMAP

#define SCI4SR2_RAF_MASK                1U
#define SCI4SR2_TXDIR_MASK              2U
#define SCI4SR2_BRK13_MASK              4U
#define SCI4SR2_RXPOL_MASK              8U
#define SCI4SR2_TXPOL_MASK              16U
#define SCI4SR2_AMAP_MASK               128U


/*** SCI4DRH - SCI 4 Data Register High; 0x00000136 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI4DRHSTR;
extern volatile SCI4DRHSTR _SCI4DRH @(REG_BASE + 0x00000136UL);
#define SCI4DRH                         _SCI4DRH.Byte
#define SCI4DRH_T8                      _SCI4DRH.Bits.T8
#define SCI4DRH_R8                      _SCI4DRH.Bits.R8

#define SCI4DRH_T8_MASK                 64U
#define SCI4DRH_R8_MASK                 128U


/*** SCI4DRL - SCI 4 Data Register Low; 0x00000137 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI4DRLSTR;
extern volatile SCI4DRLSTR _SCI4DRL @(REG_BASE + 0x00000137UL);
#define SCI4DRL                         _SCI4DRL.Byte
#define SCI4DRL_R0_T0                   _SCI4DRL.Bits.R0_T0
#define SCI4DRL_R1_T1                   _SCI4DRL.Bits.R1_T1
#define SCI4DRL_R2_T2                   _SCI4DRL.Bits.R2_T2
#define SCI4DRL_R3_T3                   _SCI4DRL.Bits.R3_T3
#define SCI4DRL_R4_T4                   _SCI4DRL.Bits.R4_T4
#define SCI4DRL_R5_T5                   _SCI4DRL.Bits.R5_T5
#define SCI4DRL_R6_T6                   _SCI4DRL.Bits.R6_T6
#define SCI4DRL_R7_T7                   _SCI4DRL.Bits.R7_T7

#define SCI4DRL_R0_T0_MASK              1U
#define SCI4DRL_R1_T1_MASK              2U
#define SCI4DRL_R2_T2_MASK              4U
#define SCI4DRL_R3_T3_MASK              8U
#define SCI4DRL_R4_T4_MASK              16U
#define SCI4DRL_R5_T5_MASK              32U
#define SCI4DRL_R6_T6_MASK              64U
#define SCI4DRL_R7_T7_MASK              128U


/*** SCI5BD - SCI 5 Baud Rate Register; 0x00000138 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI5ASR1 - SCI 5 Alternative Status Register 1; 0x00000138 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI5ASR1 - SCI 5 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI5ASR1STR;
        #define SCI5ASR1                _SCI5BD.Overlap_STR.SCI5ASR1STR.Byte
        #define SCI5ASR1_BKDIF          _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5ASR1STR.Bits.BKDIF
        #define SCI5ASR1_BERRIF         _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5ASR1STR.Bits.BERRIF
        #define SCI5ASR1_BERRV          _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5ASR1STR.Bits.BERRV
        #define SCI5ASR1_RXEDGIF        _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5ASR1STR.Bits.RXEDGIF
        
        #define SCI5ASR1_BKDIF_MASK     1U
        #define SCI5ASR1_BERRIF_MASK    2U
        #define SCI5ASR1_BERRV_MASK     4U
        #define SCI5ASR1_RXEDGIF_MASK   128U
        
        /*** SCI5BDH - SCI 5 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI5BDHSTR;
        #define SCI5BDH                 _SCI5BD.Overlap_STR.SCI5ASR1STR.Byte
        #define SCI5BDH_SBR8            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR8
        #define SCI5BDH_SBR9            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR9
        #define SCI5BDH_SBR10           _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR10
        #define SCI5BDH_SBR11           _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR11
        #define SCI5BDH_SBR12           _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR12
        #define SCI5BDH_TNP0            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.TNP0
        #define SCI5BDH_TNP1            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.TNP1
        #define SCI5BDH_IREN            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.IREN
        #define SCI5BDH_SBR_8           _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.MergedBits.grpSBR_8
        #define SCI5BDH_TNP             _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.MergedBits.grpTNP
        #define SCI5BDH_SBR             SCI5BDH_SBR_8
        
        #define SCI5BDH_SBR8_MASK       1U
        #define SCI5BDH_SBR9_MASK       2U
        #define SCI5BDH_SBR10_MASK      4U
        #define SCI5BDH_SBR11_MASK      8U
        #define SCI5BDH_SBR12_MASK      16U
        #define SCI5BDH_TNP0_MASK       32U
        #define SCI5BDH_TNP1_MASK       64U
        #define SCI5BDH_IREN_MASK       128U
        #define SCI5BDH_SBR_8_MASK      31U
        #define SCI5BDH_SBR_8_BITNUM    0U
        #define SCI5BDH_TNP_MASK        96U
        #define SCI5BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI5ASR1STR;
    

    /*** SCI5ACR1 - SCI 5 Alternative Control Register 1; 0x00000139 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI5ACR1 - SCI 5 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI5ACR1STR;
        #define SCI5ACR1                _SCI5BD.Overlap_STR.SCI5ACR1STR.Byte
        #define SCI5ACR1_BKDIE          _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5ACR1STR.Bits.BKDIE
        #define SCI5ACR1_BERRIE         _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5ACR1STR.Bits.BERRIE
        #define SCI5ACR1_RXEDGIE        _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5ACR1STR.Bits.RXEDGIE
        
        #define SCI5ACR1_BKDIE_MASK     1U
        #define SCI5ACR1_BERRIE_MASK    2U
        #define SCI5ACR1_RXEDGIE_MASK   128U
        
        /*** SCI5BDL - SCI 5 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI5BDLSTR;
        #define SCI5BDL                 _SCI5BD.Overlap_STR.SCI5ACR1STR.Byte
        #define SCI5BDL_SBR0            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR0
        #define SCI5BDL_SBR1            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR1
        #define SCI5BDL_SBR2            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR2
        #define SCI5BDL_SBR3            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR3
        #define SCI5BDL_SBR4            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR4
        #define SCI5BDL_SBR5            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR5
        #define SCI5BDL_SBR6            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR6
        #define SCI5BDL_SBR7            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR7
        
        #define SCI5BDL_SBR0_MASK       1U
        #define SCI5BDL_SBR1_MASK       2U
        #define SCI5BDL_SBR2_MASK       4U
        #define SCI5BDL_SBR3_MASK       8U
        #define SCI5BDL_SBR4_MASK       16U
        #define SCI5BDL_SBR5_MASK       32U
        #define SCI5BDL_SBR6_MASK       64U
        #define SCI5BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI5ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI5BDSTR;
extern volatile SCI5BDSTR _SCI5BD @(REG_BASE + 0x00000138UL);
#define SCI5BD                          _SCI5BD.Word
#define SCI5BD_SBR0                     _SCI5BD.Bits.SBR0
#define SCI5BD_SBR1                     _SCI5BD.Bits.SBR1
#define SCI5BD_SBR2                     _SCI5BD.Bits.SBR2
#define SCI5BD_SBR3                     _SCI5BD.Bits.SBR3
#define SCI5BD_SBR4                     _SCI5BD.Bits.SBR4
#define SCI5BD_SBR5                     _SCI5BD.Bits.SBR5
#define SCI5BD_SBR6                     _SCI5BD.Bits.SBR6
#define SCI5BD_SBR7                     _SCI5BD.Bits.SBR7
#define SCI5BD_SBR8                     _SCI5BD.Bits.SBR8
#define SCI5BD_SBR9                     _SCI5BD.Bits.SBR9
#define SCI5BD_SBR10                    _SCI5BD.Bits.SBR10
#define SCI5BD_SBR11                    _SCI5BD.Bits.SBR11
#define SCI5BD_SBR12                    _SCI5BD.Bits.SBR12
#define SCI5BD_TNP0                     _SCI5BD.Bits.TNP0
#define SCI5BD_TNP1                     _SCI5BD.Bits.TNP1
#define SCI5BD_IREN                     _SCI5BD.Bits.IREN
#define SCI5BD_SBR                      _SCI5BD.MergedBits.grpSBR
#define SCI5BD_TNP                      _SCI5BD.MergedBits.grpTNP

#define SCI5BD_SBR0_MASK                1U
#define SCI5BD_SBR1_MASK                2U
#define SCI5BD_SBR2_MASK                4U
#define SCI5BD_SBR3_MASK                8U
#define SCI5BD_SBR4_MASK                16U
#define SCI5BD_SBR5_MASK                32U
#define SCI5BD_SBR6_MASK                64U
#define SCI5BD_SBR7_MASK                128U
#define SCI5BD_SBR8_MASK                256U
#define SCI5BD_SBR9_MASK                512U
#define SCI5BD_SBR10_MASK               1024U
#define SCI5BD_SBR11_MASK               2048U
#define SCI5BD_SBR12_MASK               4096U
#define SCI5BD_TNP0_MASK                8192U
#define SCI5BD_TNP1_MASK                16384U
#define SCI5BD_IREN_MASK                32768U
#define SCI5BD_SBR_MASK                 8191U
#define SCI5BD_SBR_BITNUM               0U
#define SCI5BD_TNP_MASK                 24576U
#define SCI5BD_TNP_BITNUM               13U


/*** SCI5ACR2 - SCI 5 Alternative Control Register 2; 0x0000013A ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI5ACR2 - SCI 5 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI5ACR2STR;
    #define SCI5ACR2                    _SCI5ACR2.Byte
    #define SCI5ACR2_BKDFE              _SCI5ACR2.SameAddr_STR.SCI5ACR2STR.Bits.BKDFE
    #define SCI5ACR2_BERRM0             _SCI5ACR2.SameAddr_STR.SCI5ACR2STR.Bits.BERRM0
    #define SCI5ACR2_BERRM1             _SCI5ACR2.SameAddr_STR.SCI5ACR2STR.Bits.BERRM1
    #define SCI5ACR2_BERRM              _SCI5ACR2.SameAddr_STR.SCI5ACR2STR.MergedBits.grpBERRM
    
    #define SCI5ACR2_BKDFE_MASK         1U
    #define SCI5ACR2_BERRM0_MASK        2U
    #define SCI5ACR2_BERRM1_MASK        4U
    #define SCI5ACR2_BERRM_MASK         6U
    #define SCI5ACR2_BERRM_BITNUM       1U
    
    /*** SCI5CR1 - SCI 5 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI5CR1STR;
    #define SCI5CR1                     _SCI5ACR2.Byte
    #define SCI5CR1_PT                  _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.PT
    #define SCI5CR1_PE                  _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.PE
    #define SCI5CR1_ILT                 _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.ILT
    #define SCI5CR1_WAKE                _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.WAKE
    #define SCI5CR1_M                   _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.M
    #define SCI5CR1_RSRC                _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.RSRC
    #define SCI5CR1_SCISWAI             _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.SCISWAI
    #define SCI5CR1_LOOPS               _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.LOOPS
    
    #define SCI5CR1_PT_MASK             1U
    #define SCI5CR1_PE_MASK             2U
    #define SCI5CR1_ILT_MASK            4U
    #define SCI5CR1_WAKE_MASK           8U
    #define SCI5CR1_M_MASK              16U
    #define SCI5CR1_RSRC_MASK           32U
    #define SCI5CR1_SCISWAI_MASK        64U
    #define SCI5CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI5ACR2STR;
extern volatile SCI5ACR2STR _SCI5ACR2 @(REG_BASE + 0x0000013AUL);


/*** SCI5CR2 - SCI 5 Control Register 2; 0x0000013B ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE         :1;                                       /* Transmitter Interrupt Enable Bit */
  } Bits;
} SCI5CR2STR;
extern volatile SCI5CR2STR _SCI5CR2 @(REG_BASE + 0x0000013BUL);
#define SCI5CR2                         _SCI5CR2.Byte
#define SCI5CR2_SBK                     _SCI5CR2.Bits.SBK
#define SCI5CR2_RWU                     _SCI5CR2.Bits.RWU
#define SCI5CR2_RE                      _SCI5CR2.Bits.RE
#define SCI5CR2_TE                      _SCI5CR2.Bits.TE
#define SCI5CR2_ILIE                    _SCI5CR2.Bits.ILIE
#define SCI5CR2_RIE                     _SCI5CR2.Bits.RIE
#define SCI5CR2_TCIE                    _SCI5CR2.Bits.TCIE
#define SCI5CR2_TIE                     _SCI5CR2.Bits.TIE

#define SCI5CR2_SBK_MASK                1U
#define SCI5CR2_RWU_MASK                2U
#define SCI5CR2_RE_MASK                 4U
#define SCI5CR2_TE_MASK                 8U
#define SCI5CR2_ILIE_MASK               16U
#define SCI5CR2_RIE_MASK                32U
#define SCI5CR2_TCIE_MASK               64U
#define SCI5CR2_TIE_MASK                128U


/*** SCI5SR1 - SCI 5 Status Register 1; 0x0000013C ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF_bit    :1;                                       /* Receive Data Register Full Flag */ /*Warning: bit name is duplicated with register name*/
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI5SR1STR;
extern volatile SCI5SR1STR _SCI5SR1 @(REG_BASE + 0x0000013CUL);
#define SCI5SR1                         _SCI5SR1.Byte
#define SCI5SR1_PF                      _SCI5SR1.Bits.PF
#define SCI5SR1_FE                      _SCI5SR1.Bits.FE
#define SCI5SR1_NF                      _SCI5SR1.Bits.NF
#define SCI5SR1_OR                      _SCI5SR1.Bits.OR
#define SCI5SR1_IDLE                    _SCI5SR1.Bits.IDLE
#define SCI5SR1_RDRF                    _SCI5SR1.Bits.RDRF_bit
#define SCI5SR1_TC                      _SCI5SR1.Bits.TC
#define SCI5SR1_TDRE                    _SCI5SR1.Bits.TDRE

#define SCI5SR1_PF_MASK                 1U
#define SCI5SR1_FE_MASK                 2U
#define SCI5SR1_NF_MASK                 4U
#define SCI5SR1_OR_MASK                 8U
#define SCI5SR1_IDLE_MASK               16U
#define SCI5SR1_RDRF_MASK               32U
#define SCI5SR1_TC_MASK                 64U
#define SCI5SR1_TDRE_MASK               128U


/*** SCI5SR2 - SCI 5 Status Register 2; 0x0000013D ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI5SR2STR;
extern volatile SCI5SR2STR _SCI5SR2 @(REG_BASE + 0x0000013DUL);
#define SCI5SR2                         _SCI5SR2.Byte
#define SCI5SR2_RAF                     _SCI5SR2.Bits.RAF
#define SCI5SR2_TXDIR                   _SCI5SR2.Bits.TXDIR
#define SCI5SR2_BRK13                   _SCI5SR2.Bits.BRK13
#define SCI5SR2_RXPOL                   _SCI5SR2.Bits.RXPOL
#define SCI5SR2_TXPOL                   _SCI5SR2.Bits.TXPOL
#define SCI5SR2_AMAP                    _SCI5SR2.Bits.AMAP

#define SCI5SR2_RAF_MASK                1U
#define SCI5SR2_TXDIR_MASK              2U
#define SCI5SR2_BRK13_MASK              4U
#define SCI5SR2_RXPOL_MASK              8U
#define SCI5SR2_TXPOL_MASK              16U
#define SCI5SR2_AMAP_MASK               128U


/*** SCI5DRH - SCI 5 Data Register High; 0x0000013E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI5DRHSTR;
extern volatile SCI5DRHSTR _SCI5DRH @(REG_BASE + 0x0000013EUL);
#define SCI5DRH                         _SCI5DRH.Byte
#define SCI5DRH_T8                      _SCI5DRH.Bits.T8
#define SCI5DRH_R8                      _SCI5DRH.Bits.R8

#define SCI5DRH_T8_MASK                 64U
#define SCI5DRH_R8_MASK                 128U


/*** SCI5DRL - SCI 5 Data Register Low; 0x0000013F ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI5DRLSTR;
extern volatile SCI5DRLSTR _SCI5DRL @(REG_BASE + 0x0000013FUL);
#define SCI5DRL                         _SCI5DRL.Byte
#define SCI5DRL_R0_T0                   _SCI5DRL.Bits.R0_T0
#define SCI5DRL_R1_T1                   _SCI5DRL.Bits.R1_T1
#define SCI5DRL_R2_T2                   _SCI5DRL.Bits.R2_T2
#define SCI5DRL_R3_T3                   _SCI5DRL.Bits.R3_T3
#define SCI5DRL_R4_T4                   _SCI5DRL.Bits.R4_T4
#define SCI5DRL_R5_T5                   _SCI5DRL.Bits.R5_T5
#define SCI5DRL_R6_T6                   _SCI5DRL.Bits.R6_T6
#define SCI5DRL_R7_T7                   _SCI5DRL.Bits.R7_T7

#define SCI5DRL_R0_T0_MASK              1U
#define SCI5DRL_R1_T1_MASK              2U
#define SCI5DRL_R2_T2_MASK              4U
#define SCI5DRL_R3_T3_MASK              8U
#define SCI5DRL_R4_T4_MASK              16U
#define SCI5DRL_R5_T5_MASK              32U
#define SCI5DRL_R6_T6_MASK              64U
#define SCI5DRL_R7_T7_MASK              128U


/*** CAN0CTL0 - MSCAN0 Control 0 Register; 0x00000140 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN0CTL0STR;
extern volatile CAN0CTL0STR _CAN0CTL0 @(REG_BASE + 0x00000140UL);
#define CAN0CTL0                        _CAN0CTL0.Byte
#define CAN0CTL0_INITRQ                 _CAN0CTL0.Bits.INITRQ
#define CAN0CTL0_SLPRQ                  _CAN0CTL0.Bits.SLPRQ
#define CAN0CTL0_WUPE                   _CAN0CTL0.Bits.WUPE
#define CAN0CTL0_TIME                   _CAN0CTL0.Bits.TIME
#define CAN0CTL0_SYNCH                  _CAN0CTL0.Bits.SYNCH
#define CAN0CTL0_CSWAI                  _CAN0CTL0.Bits.CSWAI
#define CAN0CTL0_RXACT                  _CAN0CTL0.Bits.RXACT
#define CAN0CTL0_RXFRM                  _CAN0CTL0.Bits.RXFRM
/* CAN0CTL_ARR: Access 2 CAN0CTLx registers in an array */
#define CAN0CTL_ARR                     ((volatile byte *) &CAN0CTL0)

#define CAN0CTL0_INITRQ_MASK            1U
#define CAN0CTL0_SLPRQ_MASK             2U
#define CAN0CTL0_WUPE_MASK              4U
#define CAN0CTL0_TIME_MASK              8U
#define CAN0CTL0_SYNCH_MASK             16U
#define CAN0CTL0_CSWAI_MASK             32U
#define CAN0CTL0_RXACT_MASK             64U
#define CAN0CTL0_RXFRM_MASK             128U


/*** CAN0CTL1 - MSCAN0 Control 1 Register; 0x00000141 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN Clock Source */
    byte CANE        :1;                                       /* MSCAN Enable */
  } Bits;
} CAN0CTL1STR;
extern volatile CAN0CTL1STR _CAN0CTL1 @(REG_BASE + 0x00000141UL);
#define CAN0CTL1                        _CAN0CTL1.Byte
#define CAN0CTL1_INITAK                 _CAN0CTL1.Bits.INITAK
#define CAN0CTL1_SLPAK                  _CAN0CTL1.Bits.SLPAK
#define CAN0CTL1_WUPM                   _CAN0CTL1.Bits.WUPM
#define CAN0CTL1_BORM                   _CAN0CTL1.Bits.BORM
#define CAN0CTL1_LISTEN                 _CAN0CTL1.Bits.LISTEN
#define CAN0CTL1_LOOPB                  _CAN0CTL1.Bits.LOOPB
#define CAN0CTL1_CLKSRC                 _CAN0CTL1.Bits.CLKSRC
#define CAN0CTL1_CANE                   _CAN0CTL1.Bits.CANE

#define CAN0CTL1_INITAK_MASK            1U
#define CAN0CTL1_SLPAK_MASK             2U
#define CAN0CTL1_WUPM_MASK              4U
#define CAN0CTL1_BORM_MASK              8U
#define CAN0CTL1_LISTEN_MASK            16U
#define CAN0CTL1_LOOPB_MASK             32U
#define CAN0CTL1_CLKSRC_MASK            64U
#define CAN0CTL1_CANE_MASK              128U


/*** CAN0BTR0 - MSCAN0 Bus Timing Register 0; 0x00000142 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN0BTR0STR;
extern volatile CAN0BTR0STR _CAN0BTR0 @(REG_BASE + 0x00000142UL);
#define CAN0BTR0                        _CAN0BTR0.Byte
#define CAN0BTR0_BRP0                   _CAN0BTR0.Bits.BRP0
#define CAN0BTR0_BRP1                   _CAN0BTR0.Bits.BRP1
#define CAN0BTR0_BRP2                   _CAN0BTR0.Bits.BRP2
#define CAN0BTR0_BRP3                   _CAN0BTR0.Bits.BRP3
#define CAN0BTR0_BRP4                   _CAN0BTR0.Bits.BRP4
#define CAN0BTR0_BRP5                   _CAN0BTR0.Bits.BRP5
#define CAN0BTR0_SJW0                   _CAN0BTR0.Bits.SJW0
#define CAN0BTR0_SJW1                   _CAN0BTR0.Bits.SJW1
/* CAN0BTR_ARR: Access 2 CAN0BTRx registers in an array */
#define CAN0BTR_ARR                     ((volatile byte *) &CAN0BTR0)
#define CAN0BTR0_BRP                    _CAN0BTR0.MergedBits.grpBRP
#define CAN0BTR0_SJW                    _CAN0BTR0.MergedBits.grpSJW

#define CAN0BTR0_BRP0_MASK              1U
#define CAN0BTR0_BRP1_MASK              2U
#define CAN0BTR0_BRP2_MASK              4U
#define CAN0BTR0_BRP3_MASK              8U
#define CAN0BTR0_BRP4_MASK              16U
#define CAN0BTR0_BRP5_MASK              32U
#define CAN0BTR0_SJW0_MASK              64U
#define CAN0BTR0_SJW1_MASK              128U
#define CAN0BTR0_BRP_MASK               63U
#define CAN0BTR0_BRP_BITNUM             0U
#define CAN0BTR0_SJW_MASK               192U
#define CAN0BTR0_SJW_BITNUM             6U


/*** CAN0BTR1 - MSCAN0 Bus Timing Register 1; 0x00000143 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN0BTR1STR;
extern volatile CAN0BTR1STR _CAN0BTR1 @(REG_BASE + 0x00000143UL);
#define CAN0BTR1                        _CAN0BTR1.Byte
#define CAN0BTR1_TSEG10                 _CAN0BTR1.Bits.TSEG10
#define CAN0BTR1_TSEG11                 _CAN0BTR1.Bits.TSEG11
#define CAN0BTR1_TSEG12                 _CAN0BTR1.Bits.TSEG12
#define CAN0BTR1_TSEG13                 _CAN0BTR1.Bits.TSEG13
#define CAN0BTR1_TSEG20                 _CAN0BTR1.Bits.TSEG20
#define CAN0BTR1_TSEG21                 _CAN0BTR1.Bits.TSEG21
#define CAN0BTR1_TSEG22                 _CAN0BTR1.Bits.TSEG22
#define CAN0BTR1_SAMP                   _CAN0BTR1.Bits.SAMP
#define CAN0BTR1_TSEG_10                _CAN0BTR1.MergedBits.grpTSEG_10
#define CAN0BTR1_TSEG_20                _CAN0BTR1.MergedBits.grpTSEG_20
#define CAN0BTR1_TSEG                   CAN0BTR1_TSEG_10

#define CAN0BTR1_TSEG10_MASK            1U
#define CAN0BTR1_TSEG11_MASK            2U
#define CAN0BTR1_TSEG12_MASK            4U
#define CAN0BTR1_TSEG13_MASK            8U
#define CAN0BTR1_TSEG20_MASK            16U
#define CAN0BTR1_TSEG21_MASK            32U
#define CAN0BTR1_TSEG22_MASK            64U
#define CAN0BTR1_SAMP_MASK              128U
#define CAN0BTR1_TSEG_10_MASK           15U
#define CAN0BTR1_TSEG_10_BITNUM         0U
#define CAN0BTR1_TSEG_20_MASK           112U
#define CAN0BTR1_TSEG_20_BITNUM         4U


/*** CAN0RFLG - MSCAN0 Receiver Flag Register; 0x00000144 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RFLGSTR;
extern volatile CAN0RFLGSTR _CAN0RFLG @(REG_BASE + 0x00000144UL);
#define CAN0RFLG                        _CAN0RFLG.Byte
#define CAN0RFLG_RXF                    _CAN0RFLG.Bits.RXF
#define CAN0RFLG_OVRIF                  _CAN0RFLG.Bits.OVRIF
#define CAN0RFLG_TSTAT0                 _CAN0RFLG.Bits.TSTAT0
#define CAN0RFLG_TSTAT1                 _CAN0RFLG.Bits.TSTAT1
#define CAN0RFLG_RSTAT0                 _CAN0RFLG.Bits.RSTAT0
#define CAN0RFLG_RSTAT1                 _CAN0RFLG.Bits.RSTAT1
#define CAN0RFLG_CSCIF                  _CAN0RFLG.Bits.CSCIF
#define CAN0RFLG_WUPIF                  _CAN0RFLG.Bits.WUPIF
#define CAN0RFLG_TSTAT                  _CAN0RFLG.MergedBits.grpTSTAT
#define CAN0RFLG_RSTAT                  _CAN0RFLG.MergedBits.grpRSTAT

#define CAN0RFLG_RXF_MASK               1U
#define CAN0RFLG_OVRIF_MASK             2U
#define CAN0RFLG_TSTAT0_MASK            4U
#define CAN0RFLG_TSTAT1_MASK            8U
#define CAN0RFLG_RSTAT0_MASK            16U
#define CAN0RFLG_RSTAT1_MASK            32U
#define CAN0RFLG_CSCIF_MASK             64U
#define CAN0RFLG_WUPIF_MASK             128U
#define CAN0RFLG_TSTAT_MASK             12U
#define CAN0RFLG_TSTAT_BITNUM           2U
#define CAN0RFLG_RSTAT_MASK             48U
#define CAN0RFLG_RSTAT_BITNUM           4U


/*** CAN0RIER - MSCAN0 Receiver Interrupt Enable Register; 0x00000145 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RIERSTR;
extern volatile CAN0RIERSTR _CAN0RIER @(REG_BASE + 0x00000145UL);
#define CAN0RIER                        _CAN0RIER.Byte
#define CAN0RIER_RXFIE                  _CAN0RIER.Bits.RXFIE
#define CAN0RIER_OVRIE                  _CAN0RIER.Bits.OVRIE
#define CAN0RIER_TSTATE0                _CAN0RIER.Bits.TSTATE0
#define CAN0RIER_TSTATE1                _CAN0RIER.Bits.TSTATE1
#define CAN0RIER_RSTATE0                _CAN0RIER.Bits.RSTATE0
#define CAN0RIER_RSTATE1                _CAN0RIER.Bits.RSTATE1
#define CAN0RIER_CSCIE                  _CAN0RIER.Bits.CSCIE
#define CAN0RIER_WUPIE                  _CAN0RIER.Bits.WUPIE
#define CAN0RIER_TSTATE                 _CAN0RIER.MergedBits.grpTSTATE
#define CAN0RIER_RSTATE                 _CAN0RIER.MergedBits.grpRSTATE

#define CAN0RIER_RXFIE_MASK             1U
#define CAN0RIER_OVRIE_MASK             2U
#define CAN0RIER_TSTATE0_MASK           4U
#define CAN0RIER_TSTATE1_MASK           8U
#define CAN0RIER_RSTATE0_MASK           16U
#define CAN0RIER_RSTATE1_MASK           32U
#define CAN0RIER_CSCIE_MASK             64U
#define CAN0RIER_WUPIE_MASK             128U
#define CAN0RIER_TSTATE_MASK            12U
#define CAN0RIER_TSTATE_BITNUM          2U
#define CAN0RIER_RSTATE_MASK            48U
#define CAN0RIER_RSTATE_BITNUM          4U


/*** CAN0TFLG - MSCAN0 Transmitter Flag Register; 0x00000146 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TFLGSTR;
extern volatile CAN0TFLGSTR _CAN0TFLG @(REG_BASE + 0x00000146UL);
#define CAN0TFLG                        _CAN0TFLG.Byte
#define CAN0TFLG_TXE0                   _CAN0TFLG.Bits.TXE0
#define CAN0TFLG_TXE1                   _CAN0TFLG.Bits.TXE1
#define CAN0TFLG_TXE2                   _CAN0TFLG.Bits.TXE2
#define CAN0TFLG_TXE                    _CAN0TFLG.MergedBits.grpTXE

#define CAN0TFLG_TXE0_MASK              1U
#define CAN0TFLG_TXE1_MASK              2U
#define CAN0TFLG_TXE2_MASK              4U
#define CAN0TFLG_TXE_MASK               7U
#define CAN0TFLG_TXE_BITNUM             0U


/*** CAN0TIER - MSCAN0 Transmitter Interrupt Enable Register; 0x00000147 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TIERSTR;
extern volatile CAN0TIERSTR _CAN0TIER @(REG_BASE + 0x00000147UL);
#define CAN0TIER                        _CAN0TIER.Byte
#define CAN0TIER_TXEIE0                 _CAN0TIER.Bits.TXEIE0
#define CAN0TIER_TXEIE1                 _CAN0TIER.Bits.TXEIE1
#define CAN0TIER_TXEIE2                 _CAN0TIER.Bits.TXEIE2
#define CAN0TIER_TXEIE                  _CAN0TIER.MergedBits.grpTXEIE

#define CAN0TIER_TXEIE0_MASK            1U
#define CAN0TIER_TXEIE1_MASK            2U
#define CAN0TIER_TXEIE2_MASK            4U
#define CAN0TIER_TXEIE_MASK             7U
#define CAN0TIER_TXEIE_BITNUM           0U


/*** CAN0TARQ - MSCAN0 Transmitter Message Abort Request; 0x00000148 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TARQSTR;
extern volatile CAN0TARQSTR _CAN0TARQ @(REG_BASE + 0x00000148UL);
#define CAN0TARQ                        _CAN0TARQ.Byte
#define CAN0TARQ_ABTRQ0                 _CAN0TARQ.Bits.ABTRQ0
#define CAN0TARQ_ABTRQ1                 _CAN0TARQ.Bits.ABTRQ1
#define CAN0TARQ_ABTRQ2                 _CAN0TARQ.Bits.ABTRQ2
#define CAN0TARQ_ABTRQ                  _CAN0TARQ.MergedBits.grpABTRQ

#define CAN0TARQ_ABTRQ0_MASK            1U
#define CAN0TARQ_ABTRQ1_MASK            2U
#define CAN0TARQ_ABTRQ2_MASK            4U
#define CAN0TARQ_ABTRQ_MASK             7U
#define CAN0TARQ_ABTRQ_BITNUM           0U


/*** CAN0TAAK - MSCAN0 Transmitter Message Abort Acknowledge; 0x00000149 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TAAKSTR;
extern volatile CAN0TAAKSTR _CAN0TAAK @(REG_BASE + 0x00000149UL);
#define CAN0TAAK                        _CAN0TAAK.Byte
#define CAN0TAAK_ABTAK0                 _CAN0TAAK.Bits.ABTAK0
#define CAN0TAAK_ABTAK1                 _CAN0TAAK.Bits.ABTAK1
#define CAN0TAAK_ABTAK2                 _CAN0TAAK.Bits.ABTAK2
#define CAN0TAAK_ABTAK                  _CAN0TAAK.MergedBits.grpABTAK

#define CAN0TAAK_ABTAK0_MASK            1U
#define CAN0TAAK_ABTAK1_MASK            2U
#define CAN0TAAK_ABTAK2_MASK            4U
#define CAN0TAAK_ABTAK_MASK             7U
#define CAN0TAAK_ABTAK_BITNUM           0U


/*** CAN0TBSEL - MSCAN0 Transmit Buffer Selection; 0x0000014A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TBSELSTR;
extern volatile CAN0TBSELSTR _CAN0TBSEL @(REG_BASE + 0x0000014AUL);
#define CAN0TBSEL                       _CAN0TBSEL.Byte
#define CAN0TBSEL_TX0                   _CAN0TBSEL.Bits.TX0
#define CAN0TBSEL_TX1                   _CAN0TBSEL.Bits.TX1
#define CAN0TBSEL_TX2                   _CAN0TBSEL.Bits.TX2
#define CAN0TBSEL_TX                    _CAN0TBSEL.MergedBits.grpTX

#define CAN0TBSEL_TX0_MASK              1U
#define CAN0TBSEL_TX1_MASK              2U
#define CAN0TBSEL_TX2_MASK              4U
#define CAN0TBSEL_TX_MASK               7U
#define CAN0TBSEL_TX_BITNUM             0U


/*** CAN0IDAC - MSCAN0 Identifier Acceptance Control Register; 0x0000014B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0IDACSTR;
extern volatile CAN0IDACSTR _CAN0IDAC @(REG_BASE + 0x0000014BUL);
#define CAN0IDAC                        _CAN0IDAC.Byte
#define CAN0IDAC_IDHIT0                 _CAN0IDAC.Bits.IDHIT0
#define CAN0IDAC_IDHIT1                 _CAN0IDAC.Bits.IDHIT1
#define CAN0IDAC_IDHIT2                 _CAN0IDAC.Bits.IDHIT2
#define CAN0IDAC_IDAM0                  _CAN0IDAC.Bits.IDAM0
#define CAN0IDAC_IDAM1                  _CAN0IDAC.Bits.IDAM1
#define CAN0IDAC_IDHIT                  _CAN0IDAC.MergedBits.grpIDHIT
#define CAN0IDAC_IDAM                   _CAN0IDAC.MergedBits.grpIDAM

#define CAN0IDAC_IDHIT0_MASK            1U
#define CAN0IDAC_IDHIT1_MASK            2U
#define CAN0IDAC_IDHIT2_MASK            4U
#define CAN0IDAC_IDAM0_MASK             16U
#define CAN0IDAC_IDAM1_MASK             32U
#define CAN0IDAC_IDHIT_MASK             7U
#define CAN0IDAC_IDHIT_BITNUM           0U
#define CAN0IDAC_IDAM_MASK              48U
#define CAN0IDAC_IDAM_BITNUM            4U


/*** CAN0MISC - MSCAN0 Miscellaneous Register; 0x0000014D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-off State Hold Until User Request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN0MISCSTR;
extern volatile CAN0MISCSTR _CAN0MISC @(REG_BASE + 0x0000014DUL);
#define CAN0MISC                        _CAN0MISC.Byte
#define CAN0MISC_BOHOLD                 _CAN0MISC.Bits.BOHOLD

#define CAN0MISC_BOHOLD_MASK            1U


/*** CAN0RXERR - MSCAN0 Receive Error Counter Register; 0x0000014E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0RXERRSTR;
extern volatile CAN0RXERRSTR _CAN0RXERR @(REG_BASE + 0x0000014EUL);
#define CAN0RXERR                       _CAN0RXERR.Byte
#define CAN0RXERR_RXERR0                _CAN0RXERR.Bits.RXERR0
#define CAN0RXERR_RXERR1                _CAN0RXERR.Bits.RXERR1
#define CAN0RXERR_RXERR2                _CAN0RXERR.Bits.RXERR2
#define CAN0RXERR_RXERR3                _CAN0RXERR.Bits.RXERR3
#define CAN0RXERR_RXERR4                _CAN0RXERR.Bits.RXERR4
#define CAN0RXERR_RXERR5                _CAN0RXERR.Bits.RXERR5
#define CAN0RXERR_RXERR6                _CAN0RXERR.Bits.RXERR6
#define CAN0RXERR_RXERR7                _CAN0RXERR.Bits.RXERR7

#define CAN0RXERR_RXERR0_MASK           1U
#define CAN0RXERR_RXERR1_MASK           2U
#define CAN0RXERR_RXERR2_MASK           4U
#define CAN0RXERR_RXERR3_MASK           8U
#define CAN0RXERR_RXERR4_MASK           16U
#define CAN0RXERR_RXERR5_MASK           32U
#define CAN0RXERR_RXERR6_MASK           64U
#define CAN0RXERR_RXERR7_MASK           128U


/*** CAN0TXERR - MSCAN0 Transmit Error Counter Register; 0x0000014F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0TXERRSTR;
extern volatile CAN0TXERRSTR _CAN0TXERR @(REG_BASE + 0x0000014FUL);
#define CAN0TXERR                       _CAN0TXERR.Byte
#define CAN0TXERR_TXERR0                _CAN0TXERR.Bits.TXERR0
#define CAN0TXERR_TXERR1                _CAN0TXERR.Bits.TXERR1
#define CAN0TXERR_TXERR2                _CAN0TXERR.Bits.TXERR2
#define CAN0TXERR_TXERR3                _CAN0TXERR.Bits.TXERR3
#define CAN0TXERR_TXERR4                _CAN0TXERR.Bits.TXERR4
#define CAN0TXERR_TXERR5                _CAN0TXERR.Bits.TXERR5
#define CAN0TXERR_TXERR6                _CAN0TXERR.Bits.TXERR6
#define CAN0TXERR_TXERR7                _CAN0TXERR.Bits.TXERR7

#define CAN0TXERR_TXERR0_MASK           1U
#define CAN0TXERR_TXERR1_MASK           2U
#define CAN0TXERR_TXERR2_MASK           4U
#define CAN0TXERR_TXERR3_MASK           8U
#define CAN0TXERR_TXERR4_MASK           16U
#define CAN0TXERR_TXERR5_MASK           32U
#define CAN0TXERR_TXERR6_MASK           64U
#define CAN0TXERR_TXERR7_MASK           128U


/*** CAN0IDAR0 - MSCAN0 Identifier Acceptance Register 0; 0x00000150 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR0STR;
extern volatile CAN0IDAR0STR _CAN0IDAR0 @(REG_BASE + 0x00000150UL);
#define CAN0IDAR0                       _CAN0IDAR0.Byte
#define CAN0IDAR0_AC0                   _CAN0IDAR0.Bits.AC0
#define CAN0IDAR0_AC1                   _CAN0IDAR0.Bits.AC1
#define CAN0IDAR0_AC2                   _CAN0IDAR0.Bits.AC2
#define CAN0IDAR0_AC3                   _CAN0IDAR0.Bits.AC3
#define CAN0IDAR0_AC4                   _CAN0IDAR0.Bits.AC4
#define CAN0IDAR0_AC5                   _CAN0IDAR0.Bits.AC5
#define CAN0IDAR0_AC6                   _CAN0IDAR0.Bits.AC6
#define CAN0IDAR0_AC7                   _CAN0IDAR0.Bits.AC7
/* CAN0IDAR_ARR: Access 4 CAN0IDARx registers in an array */
#define CAN0IDAR_ARR                    ((volatile byte *) &CAN0IDAR0)

#define CAN0IDAR0_AC0_MASK              1U
#define CAN0IDAR0_AC1_MASK              2U
#define CAN0IDAR0_AC2_MASK              4U
#define CAN0IDAR0_AC3_MASK              8U
#define CAN0IDAR0_AC4_MASK              16U
#define CAN0IDAR0_AC5_MASK              32U
#define CAN0IDAR0_AC6_MASK              64U
#define CAN0IDAR0_AC7_MASK              128U


/*** CAN0IDAR1 - MSCAN0 Identifier Acceptance Register 1; 0x00000151 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR1STR;
extern volatile CAN0IDAR1STR _CAN0IDAR1 @(REG_BASE + 0x00000151UL);
#define CAN0IDAR1                       _CAN0IDAR1.Byte
#define CAN0IDAR1_AC0                   _CAN0IDAR1.Bits.AC0
#define CAN0IDAR1_AC1                   _CAN0IDAR1.Bits.AC1
#define CAN0IDAR1_AC2                   _CAN0IDAR1.Bits.AC2
#define CAN0IDAR1_AC3                   _CAN0IDAR1.Bits.AC3
#define CAN0IDAR1_AC4                   _CAN0IDAR1.Bits.AC4
#define CAN0IDAR1_AC5                   _CAN0IDAR1.Bits.AC5
#define CAN0IDAR1_AC6                   _CAN0IDAR1.Bits.AC6
#define CAN0IDAR1_AC7                   _CAN0IDAR1.Bits.AC7

#define CAN0IDAR1_AC0_MASK              1U
#define CAN0IDAR1_AC1_MASK              2U
#define CAN0IDAR1_AC2_MASK              4U
#define CAN0IDAR1_AC3_MASK              8U
#define CAN0IDAR1_AC4_MASK              16U
#define CAN0IDAR1_AC5_MASK              32U
#define CAN0IDAR1_AC6_MASK              64U
#define CAN0IDAR1_AC7_MASK              128U


/*** CAN0IDAR2 - MSCAN0 Identifier Acceptance Register 2; 0x00000152 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR2STR;
extern volatile CAN0IDAR2STR _CAN0IDAR2 @(REG_BASE + 0x00000152UL);
#define CAN0IDAR2                       _CAN0IDAR2.Byte
#define CAN0IDAR2_AC0                   _CAN0IDAR2.Bits.AC0
#define CAN0IDAR2_AC1                   _CAN0IDAR2.Bits.AC1
#define CAN0IDAR2_AC2                   _CAN0IDAR2.Bits.AC2
#define CAN0IDAR2_AC3                   _CAN0IDAR2.Bits.AC3
#define CAN0IDAR2_AC4                   _CAN0IDAR2.Bits.AC4
#define CAN0IDAR2_AC5                   _CAN0IDAR2.Bits.AC5
#define CAN0IDAR2_AC6                   _CAN0IDAR2.Bits.AC6
#define CAN0IDAR2_AC7                   _CAN0IDAR2.Bits.AC7

#define CAN0IDAR2_AC0_MASK              1U
#define CAN0IDAR2_AC1_MASK              2U
#define CAN0IDAR2_AC2_MASK              4U
#define CAN0IDAR2_AC3_MASK              8U
#define CAN0IDAR2_AC4_MASK              16U
#define CAN0IDAR2_AC5_MASK              32U
#define CAN0IDAR2_AC6_MASK              64U
#define CAN0IDAR2_AC7_MASK              128U


/*** CAN0IDAR3 - MSCAN0 Identifier Acceptance Register 3; 0x00000153 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR3STR;
extern volatile CAN0IDAR3STR _CAN0IDAR3 @(REG_BASE + 0x00000153UL);
#define CAN0IDAR3                       _CAN0IDAR3.Byte
#define CAN0IDAR3_AC0                   _CAN0IDAR3.Bits.AC0
#define CAN0IDAR3_AC1                   _CAN0IDAR3.Bits.AC1
#define CAN0IDAR3_AC2                   _CAN0IDAR3.Bits.AC2
#define CAN0IDAR3_AC3                   _CAN0IDAR3.Bits.AC3
#define CAN0IDAR3_AC4                   _CAN0IDAR3.Bits.AC4
#define CAN0IDAR3_AC5                   _CAN0IDAR3.Bits.AC5
#define CAN0IDAR3_AC6                   _CAN0IDAR3.Bits.AC6
#define CAN0IDAR3_AC7                   _CAN0IDAR3.Bits.AC7

#define CAN0IDAR3_AC0_MASK              1U
#define CAN0IDAR3_AC1_MASK              2U
#define CAN0IDAR3_AC2_MASK              4U
#define CAN0IDAR3_AC3_MASK              8U
#define CAN0IDAR3_AC4_MASK              16U
#define CAN0IDAR3_AC5_MASK              32U
#define CAN0IDAR3_AC6_MASK              64U
#define CAN0IDAR3_AC7_MASK              128U


/*** CAN0IDMR0 - MSCAN0 Identifier Mask Register 0; 0x00000154 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR0STR;
extern volatile CAN0IDMR0STR _CAN0IDMR0 @(REG_BASE + 0x00000154UL);
#define CAN0IDMR0                       _CAN0IDMR0.Byte
#define CAN0IDMR0_AM0                   _CAN0IDMR0.Bits.AM0
#define CAN0IDMR0_AM1                   _CAN0IDMR0.Bits.AM1
#define CAN0IDMR0_AM2                   _CAN0IDMR0.Bits.AM2
#define CAN0IDMR0_AM3                   _CAN0IDMR0.Bits.AM3
#define CAN0IDMR0_AM4                   _CAN0IDMR0.Bits.AM4
#define CAN0IDMR0_AM5                   _CAN0IDMR0.Bits.AM5
#define CAN0IDMR0_AM6                   _CAN0IDMR0.Bits.AM6
#define CAN0IDMR0_AM7                   _CAN0IDMR0.Bits.AM7
/* CAN0IDMR_ARR: Access 4 CAN0IDMRx registers in an array */
#define CAN0IDMR_ARR                    ((volatile byte *) &CAN0IDMR0)

#define CAN0IDMR0_AM0_MASK              1U
#define CAN0IDMR0_AM1_MASK              2U
#define CAN0IDMR0_AM2_MASK              4U
#define CAN0IDMR0_AM3_MASK              8U
#define CAN0IDMR0_AM4_MASK              16U
#define CAN0IDMR0_AM5_MASK              32U
#define CAN0IDMR0_AM6_MASK              64U
#define CAN0IDMR0_AM7_MASK              128U


/*** CAN0IDMR1 - MSCAN0 Identifier Mask Register 1; 0x00000155 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR1STR;
extern volatile CAN0IDMR1STR _CAN0IDMR1 @(REG_BASE + 0x00000155UL);
#define CAN0IDMR1                       _CAN0IDMR1.Byte
#define CAN0IDMR1_AM0                   _CAN0IDMR1.Bits.AM0
#define CAN0IDMR1_AM1                   _CAN0IDMR1.Bits.AM1
#define CAN0IDMR1_AM2                   _CAN0IDMR1.Bits.AM2
#define CAN0IDMR1_AM3                   _CAN0IDMR1.Bits.AM3
#define CAN0IDMR1_AM4                   _CAN0IDMR1.Bits.AM4
#define CAN0IDMR1_AM5                   _CAN0IDMR1.Bits.AM5
#define CAN0IDMR1_AM6                   _CAN0IDMR1.Bits.AM6
#define CAN0IDMR1_AM7                   _CAN0IDMR1.Bits.AM7

#define CAN0IDMR1_AM0_MASK              1U
#define CAN0IDMR1_AM1_MASK              2U
#define CAN0IDMR1_AM2_MASK              4U
#define CAN0IDMR1_AM3_MASK              8U
#define CAN0IDMR1_AM4_MASK              16U
#define CAN0IDMR1_AM5_MASK              32U
#define CAN0IDMR1_AM6_MASK              64U
#define CAN0IDMR1_AM7_MASK              128U


/*** CAN0IDMR2 - MSCAN0 Identifier Mask Register 2; 0x00000156 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR2STR;
extern volatile CAN0IDMR2STR _CAN0IDMR2 @(REG_BASE + 0x00000156UL);
#define CAN0IDMR2                       _CAN0IDMR2.Byte
#define CAN0IDMR2_AM0                   _CAN0IDMR2.Bits.AM0
#define CAN0IDMR2_AM1                   _CAN0IDMR2.Bits.AM1
#define CAN0IDMR2_AM2                   _CAN0IDMR2.Bits.AM2
#define CAN0IDMR2_AM3                   _CAN0IDMR2.Bits.AM3
#define CAN0IDMR2_AM4                   _CAN0IDMR2.Bits.AM4
#define CAN0IDMR2_AM5                   _CAN0IDMR2.Bits.AM5
#define CAN0IDMR2_AM6                   _CAN0IDMR2.Bits.AM6
#define CAN0IDMR2_AM7                   _CAN0IDMR2.Bits.AM7

#define CAN0IDMR2_AM0_MASK              1U
#define CAN0IDMR2_AM1_MASK              2U
#define CAN0IDMR2_AM2_MASK              4U
#define CAN0IDMR2_AM3_MASK              8U
#define CAN0IDMR2_AM4_MASK              16U
#define CAN0IDMR2_AM5_MASK              32U
#define CAN0IDMR2_AM6_MASK              64U
#define CAN0IDMR2_AM7_MASK              128U


/*** CAN0IDMR3 - MSCAN0 Identifier Mask Register 3; 0x00000157 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR3STR;
extern volatile CAN0IDMR3STR _CAN0IDMR3 @(REG_BASE + 0x00000157UL);
#define CAN0IDMR3                       _CAN0IDMR3.Byte
#define CAN0IDMR3_AM0                   _CAN0IDMR3.Bits.AM0
#define CAN0IDMR3_AM1                   _CAN0IDMR3.Bits.AM1
#define CAN0IDMR3_AM2                   _CAN0IDMR3.Bits.AM2
#define CAN0IDMR3_AM3                   _CAN0IDMR3.Bits.AM3
#define CAN0IDMR3_AM4                   _CAN0IDMR3.Bits.AM4
#define CAN0IDMR3_AM5                   _CAN0IDMR3.Bits.AM5
#define CAN0IDMR3_AM6                   _CAN0IDMR3.Bits.AM6
#define CAN0IDMR3_AM7                   _CAN0IDMR3.Bits.AM7

#define CAN0IDMR3_AM0_MASK              1U
#define CAN0IDMR3_AM1_MASK              2U
#define CAN0IDMR3_AM2_MASK              4U
#define CAN0IDMR3_AM3_MASK              8U
#define CAN0IDMR3_AM4_MASK              16U
#define CAN0IDMR3_AM5_MASK              32U
#define CAN0IDMR3_AM6_MASK              64U
#define CAN0IDMR3_AM7_MASK              128U


/*** CAN0IDAR4 - MSCAN0 Identifier Acceptance Register 4; 0x00000158 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR4STR;
extern volatile CAN0IDAR4STR _CAN0IDAR4 @(REG_BASE + 0x00000158UL);
#define CAN0IDAR4                       _CAN0IDAR4.Byte
#define CAN0IDAR4_AC0                   _CAN0IDAR4.Bits.AC0
#define CAN0IDAR4_AC1                   _CAN0IDAR4.Bits.AC1
#define CAN0IDAR4_AC2                   _CAN0IDAR4.Bits.AC2
#define CAN0IDAR4_AC3                   _CAN0IDAR4.Bits.AC3
#define CAN0IDAR4_AC4                   _CAN0IDAR4.Bits.AC4
#define CAN0IDAR4_AC5                   _CAN0IDAR4.Bits.AC5
#define CAN0IDAR4_AC6                   _CAN0IDAR4.Bits.AC6
#define CAN0IDAR4_AC7                   _CAN0IDAR4.Bits.AC7

#define CAN0IDAR4_AC0_MASK              1U
#define CAN0IDAR4_AC1_MASK              2U
#define CAN0IDAR4_AC2_MASK              4U
#define CAN0IDAR4_AC3_MASK              8U
#define CAN0IDAR4_AC4_MASK              16U
#define CAN0IDAR4_AC5_MASK              32U
#define CAN0IDAR4_AC6_MASK              64U
#define CAN0IDAR4_AC7_MASK              128U


/*** CAN0IDAR5 - MSCAN0 Identifier Acceptance Register 5; 0x00000159 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR5STR;
extern volatile CAN0IDAR5STR _CAN0IDAR5 @(REG_BASE + 0x00000159UL);
#define CAN0IDAR5                       _CAN0IDAR5.Byte
#define CAN0IDAR5_AC0                   _CAN0IDAR5.Bits.AC0
#define CAN0IDAR5_AC1                   _CAN0IDAR5.Bits.AC1
#define CAN0IDAR5_AC2                   _CAN0IDAR5.Bits.AC2
#define CAN0IDAR5_AC3                   _CAN0IDAR5.Bits.AC3
#define CAN0IDAR5_AC4                   _CAN0IDAR5.Bits.AC4
#define CAN0IDAR5_AC5                   _CAN0IDAR5.Bits.AC5
#define CAN0IDAR5_AC6                   _CAN0IDAR5.Bits.AC6
#define CAN0IDAR5_AC7                   _CAN0IDAR5.Bits.AC7

#define CAN0IDAR5_AC0_MASK              1U
#define CAN0IDAR5_AC1_MASK              2U
#define CAN0IDAR5_AC2_MASK              4U
#define CAN0IDAR5_AC3_MASK              8U
#define CAN0IDAR5_AC4_MASK              16U
#define CAN0IDAR5_AC5_MASK              32U
#define CAN0IDAR5_AC6_MASK              64U
#define CAN0IDAR5_AC7_MASK              128U


/*** CAN0IDAR6 - MSCAN0 Identifier Acceptance Register 6; 0x0000015A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR6STR;
extern volatile CAN0IDAR6STR _CAN0IDAR6 @(REG_BASE + 0x0000015AUL);
#define CAN0IDAR6                       _CAN0IDAR6.Byte
#define CAN0IDAR6_AC0                   _CAN0IDAR6.Bits.AC0
#define CAN0IDAR6_AC1                   _CAN0IDAR6.Bits.AC1
#define CAN0IDAR6_AC2                   _CAN0IDAR6.Bits.AC2
#define CAN0IDAR6_AC3                   _CAN0IDAR6.Bits.AC3
#define CAN0IDAR6_AC4                   _CAN0IDAR6.Bits.AC4
#define CAN0IDAR6_AC5                   _CAN0IDAR6.Bits.AC5
#define CAN0IDAR6_AC6                   _CAN0IDAR6.Bits.AC6
#define CAN0IDAR6_AC7                   _CAN0IDAR6.Bits.AC7

#define CAN0IDAR6_AC0_MASK              1U
#define CAN0IDAR6_AC1_MASK              2U
#define CAN0IDAR6_AC2_MASK              4U
#define CAN0IDAR6_AC3_MASK              8U
#define CAN0IDAR6_AC4_MASK              16U
#define CAN0IDAR6_AC5_MASK              32U
#define CAN0IDAR6_AC6_MASK              64U
#define CAN0IDAR6_AC7_MASK              128U


/*** CAN0IDAR7 - MSCAN0 Identifier Acceptance Register 7; 0x0000015B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR7STR;
extern volatile CAN0IDAR7STR _CAN0IDAR7 @(REG_BASE + 0x0000015BUL);
#define CAN0IDAR7                       _CAN0IDAR7.Byte
#define CAN0IDAR7_AC0                   _CAN0IDAR7.Bits.AC0
#define CAN0IDAR7_AC1                   _CAN0IDAR7.Bits.AC1
#define CAN0IDAR7_AC2                   _CAN0IDAR7.Bits.AC2
#define CAN0IDAR7_AC3                   _CAN0IDAR7.Bits.AC3
#define CAN0IDAR7_AC4                   _CAN0IDAR7.Bits.AC4
#define CAN0IDAR7_AC5                   _CAN0IDAR7.Bits.AC5
#define CAN0IDAR7_AC6                   _CAN0IDAR7.Bits.AC6
#define CAN0IDAR7_AC7                   _CAN0IDAR7.Bits.AC7

#define CAN0IDAR7_AC0_MASK              1U
#define CAN0IDAR7_AC1_MASK              2U
#define CAN0IDAR7_AC2_MASK              4U
#define CAN0IDAR7_AC3_MASK              8U
#define CAN0IDAR7_AC4_MASK              16U
#define CAN0IDAR7_AC5_MASK              32U
#define CAN0IDAR7_AC6_MASK              64U
#define CAN0IDAR7_AC7_MASK              128U


/*** CAN0IDMR4 - MSCAN0 Identifier Mask Register 4; 0x0000015C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR4STR;
extern volatile CAN0IDMR4STR _CAN0IDMR4 @(REG_BASE + 0x0000015CUL);
#define CAN0IDMR4                       _CAN0IDMR4.Byte
#define CAN0IDMR4_AM0                   _CAN0IDMR4.Bits.AM0
#define CAN0IDMR4_AM1                   _CAN0IDMR4.Bits.AM1
#define CAN0IDMR4_AM2                   _CAN0IDMR4.Bits.AM2
#define CAN0IDMR4_AM3                   _CAN0IDMR4.Bits.AM3
#define CAN0IDMR4_AM4                   _CAN0IDMR4.Bits.AM4
#define CAN0IDMR4_AM5                   _CAN0IDMR4.Bits.AM5
#define CAN0IDMR4_AM6                   _CAN0IDMR4.Bits.AM6
#define CAN0IDMR4_AM7                   _CAN0IDMR4.Bits.AM7

#define CAN0IDMR4_AM0_MASK              1U
#define CAN0IDMR4_AM1_MASK              2U
#define CAN0IDMR4_AM2_MASK              4U
#define CAN0IDMR4_AM3_MASK              8U
#define CAN0IDMR4_AM4_MASK              16U
#define CAN0IDMR4_AM5_MASK              32U
#define CAN0IDMR4_AM6_MASK              64U
#define CAN0IDMR4_AM7_MASK              128U


/*** CAN0IDMR5 - MSCAN0 Identifier Mask Register 5; 0x0000015D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR5STR;
extern volatile CAN0IDMR5STR _CAN0IDMR5 @(REG_BASE + 0x0000015DUL);
#define CAN0IDMR5                       _CAN0IDMR5.Byte
#define CAN0IDMR5_AM0                   _CAN0IDMR5.Bits.AM0
#define CAN0IDMR5_AM1                   _CAN0IDMR5.Bits.AM1
#define CAN0IDMR5_AM2                   _CAN0IDMR5.Bits.AM2
#define CAN0IDMR5_AM3                   _CAN0IDMR5.Bits.AM3
#define CAN0IDMR5_AM4                   _CAN0IDMR5.Bits.AM4
#define CAN0IDMR5_AM5                   _CAN0IDMR5.Bits.AM5
#define CAN0IDMR5_AM6                   _CAN0IDMR5.Bits.AM6
#define CAN0IDMR5_AM7                   _CAN0IDMR5.Bits.AM7

#define CAN0IDMR5_AM0_MASK              1U
#define CAN0IDMR5_AM1_MASK              2U
#define CAN0IDMR5_AM2_MASK              4U
#define CAN0IDMR5_AM3_MASK              8U
#define CAN0IDMR5_AM4_MASK              16U
#define CAN0IDMR5_AM5_MASK              32U
#define CAN0IDMR5_AM6_MASK              64U
#define CAN0IDMR5_AM7_MASK              128U


/*** CAN0IDMR6 - MSCAN0 Identifier Mask Register 6; 0x0000015E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR6STR;
extern volatile CAN0IDMR6STR _CAN0IDMR6 @(REG_BASE + 0x0000015EUL);
#define CAN0IDMR6                       _CAN0IDMR6.Byte
#define CAN0IDMR6_AM0                   _CAN0IDMR6.Bits.AM0
#define CAN0IDMR6_AM1                   _CAN0IDMR6.Bits.AM1
#define CAN0IDMR6_AM2                   _CAN0IDMR6.Bits.AM2
#define CAN0IDMR6_AM3                   _CAN0IDMR6.Bits.AM3
#define CAN0IDMR6_AM4                   _CAN0IDMR6.Bits.AM4
#define CAN0IDMR6_AM5                   _CAN0IDMR6.Bits.AM5
#define CAN0IDMR6_AM6                   _CAN0IDMR6.Bits.AM6
#define CAN0IDMR6_AM7                   _CAN0IDMR6.Bits.AM7

#define CAN0IDMR6_AM0_MASK              1U
#define CAN0IDMR6_AM1_MASK              2U
#define CAN0IDMR6_AM2_MASK              4U
#define CAN0IDMR6_AM3_MASK              8U
#define CAN0IDMR6_AM4_MASK              16U
#define CAN0IDMR6_AM5_MASK              32U
#define CAN0IDMR6_AM6_MASK              64U
#define CAN0IDMR6_AM7_MASK              128U


/*** CAN0IDMR7 - MSCAN0 Identifier Mask Register 7; 0x0000015F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR7STR;
extern volatile CAN0IDMR7STR _CAN0IDMR7 @(REG_BASE + 0x0000015FUL);
#define CAN0IDMR7                       _CAN0IDMR7.Byte
#define CAN0IDMR7_AM0                   _CAN0IDMR7.Bits.AM0
#define CAN0IDMR7_AM1                   _CAN0IDMR7.Bits.AM1
#define CAN0IDMR7_AM2                   _CAN0IDMR7.Bits.AM2
#define CAN0IDMR7_AM3                   _CAN0IDMR7.Bits.AM3
#define CAN0IDMR7_AM4                   _CAN0IDMR7.Bits.AM4
#define CAN0IDMR7_AM5                   _CAN0IDMR7.Bits.AM5
#define CAN0IDMR7_AM6                   _CAN0IDMR7.Bits.AM6
#define CAN0IDMR7_AM7                   _CAN0IDMR7.Bits.AM7

#define CAN0IDMR7_AM0_MASK              1U
#define CAN0IDMR7_AM1_MASK              2U
#define CAN0IDMR7_AM2_MASK              4U
#define CAN0IDMR7_AM3_MASK              8U
#define CAN0IDMR7_AM4_MASK              16U
#define CAN0IDMR7_AM5_MASK              32U
#define CAN0IDMR7_AM6_MASK              64U
#define CAN0IDMR7_AM7_MASK              128U


/*** CAN0RXIDR0 - MSCAN0 Receive Identifier Register 0; 0x00000160 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0RXIDR0STR;
extern volatile CAN0RXIDR0STR _CAN0RXIDR0 @(REG_BASE + 0x00000160UL);
#define CAN0RXIDR0                      _CAN0RXIDR0.Byte
#define CAN0RXIDR0_ID21                 _CAN0RXIDR0.Bits.ID21
#define CAN0RXIDR0_ID22                 _CAN0RXIDR0.Bits.ID22
#define CAN0RXIDR0_ID23                 _CAN0RXIDR0.Bits.ID23
#define CAN0RXIDR0_ID24                 _CAN0RXIDR0.Bits.ID24
#define CAN0RXIDR0_ID25                 _CAN0RXIDR0.Bits.ID25
#define CAN0RXIDR0_ID26                 _CAN0RXIDR0.Bits.ID26
#define CAN0RXIDR0_ID27                 _CAN0RXIDR0.Bits.ID27
#define CAN0RXIDR0_ID28                 _CAN0RXIDR0.Bits.ID28
/* CAN0RXIDR_ARR: Access 4 CAN0RXIDRx registers in an array */
#define CAN0RXIDR_ARR                   ((volatile byte *) &CAN0RXIDR0)

#define CAN0RXIDR0_ID21_MASK            1U
#define CAN0RXIDR0_ID22_MASK            2U
#define CAN0RXIDR0_ID23_MASK            4U
#define CAN0RXIDR0_ID24_MASK            8U
#define CAN0RXIDR0_ID25_MASK            16U
#define CAN0RXIDR0_ID26_MASK            32U
#define CAN0RXIDR0_ID27_MASK            64U
#define CAN0RXIDR0_ID28_MASK            128U


/*** CAN0RXIDR1 - MSCAN0 Receive Identifier Register 1; 0x00000161 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0RXIDR1STR;
extern volatile CAN0RXIDR1STR _CAN0RXIDR1 @(REG_BASE + 0x00000161UL);
#define CAN0RXIDR1                      _CAN0RXIDR1.Byte
#define CAN0RXIDR1_ID15                 _CAN0RXIDR1.Bits.ID15
#define CAN0RXIDR1_ID16                 _CAN0RXIDR1.Bits.ID16
#define CAN0RXIDR1_ID17                 _CAN0RXIDR1.Bits.ID17
#define CAN0RXIDR1_IDE                  _CAN0RXIDR1.Bits.IDE
#define CAN0RXIDR1_SRR                  _CAN0RXIDR1.Bits.SRR
#define CAN0RXIDR1_ID18                 _CAN0RXIDR1.Bits.ID18
#define CAN0RXIDR1_ID19                 _CAN0RXIDR1.Bits.ID19
#define CAN0RXIDR1_ID20                 _CAN0RXIDR1.Bits.ID20
#define CAN0RXIDR1_ID_15                _CAN0RXIDR1.MergedBits.grpID_15
#define CAN0RXIDR1_ID_18                _CAN0RXIDR1.MergedBits.grpID_18
#define CAN0RXIDR1_ID                   CAN0RXIDR1_ID_15

#define CAN0RXIDR1_ID15_MASK            1U
#define CAN0RXIDR1_ID16_MASK            2U
#define CAN0RXIDR1_ID17_MASK            4U
#define CAN0RXIDR1_IDE_MASK             8U
#define CAN0RXIDR1_SRR_MASK             16U
#define CAN0RXIDR1_ID18_MASK            32U
#define CAN0RXIDR1_ID19_MASK            64U
#define CAN0RXIDR1_ID20_MASK            128U
#define CAN0RXIDR1_ID_15_MASK           7U
#define CAN0RXIDR1_ID_15_BITNUM         0U
#define CAN0RXIDR1_ID_18_MASK           224U
#define CAN0RXIDR1_ID_18_BITNUM         5U


/*** CAN0RXIDR2 - MSCAN0 Receive Identifier Register 2; 0x00000162 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0RXIDR2STR;
extern volatile CAN0RXIDR2STR _CAN0RXIDR2 @(REG_BASE + 0x00000162UL);
#define CAN0RXIDR2                      _CAN0RXIDR2.Byte
#define CAN0RXIDR2_ID7                  _CAN0RXIDR2.Bits.ID7
#define CAN0RXIDR2_ID8                  _CAN0RXIDR2.Bits.ID8
#define CAN0RXIDR2_ID9                  _CAN0RXIDR2.Bits.ID9
#define CAN0RXIDR2_ID10                 _CAN0RXIDR2.Bits.ID10
#define CAN0RXIDR2_ID11                 _CAN0RXIDR2.Bits.ID11
#define CAN0RXIDR2_ID12                 _CAN0RXIDR2.Bits.ID12
#define CAN0RXIDR2_ID13                 _CAN0RXIDR2.Bits.ID13
#define CAN0RXIDR2_ID14                 _CAN0RXIDR2.Bits.ID14

#define CAN0RXIDR2_ID7_MASK             1U
#define CAN0RXIDR2_ID8_MASK             2U
#define CAN0RXIDR2_ID9_MASK             4U
#define CAN0RXIDR2_ID10_MASK            8U
#define CAN0RXIDR2_ID11_MASK            16U
#define CAN0RXIDR2_ID12_MASK            32U
#define CAN0RXIDR2_ID13_MASK            64U
#define CAN0RXIDR2_ID14_MASK            128U


/*** CAN0RXIDR3 - MSCAN0 Receive Identifier Register 3; 0x00000163 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0RXIDR3STR;
extern volatile CAN0RXIDR3STR _CAN0RXIDR3 @(REG_BASE + 0x00000163UL);
#define CAN0RXIDR3                      _CAN0RXIDR3.Byte
#define CAN0RXIDR3_RTR                  _CAN0RXIDR3.Bits.RTR
#define CAN0RXIDR3_ID0                  _CAN0RXIDR3.Bits.ID0
#define CAN0RXIDR3_ID1                  _CAN0RXIDR3.Bits.ID1
#define CAN0RXIDR3_ID2                  _CAN0RXIDR3.Bits.ID2
#define CAN0RXIDR3_ID3                  _CAN0RXIDR3.Bits.ID3
#define CAN0RXIDR3_ID4                  _CAN0RXIDR3.Bits.ID4
#define CAN0RXIDR3_ID5                  _CAN0RXIDR3.Bits.ID5
#define CAN0RXIDR3_ID6                  _CAN0RXIDR3.Bits.ID6
#define CAN0RXIDR3_ID                   _CAN0RXIDR3.MergedBits.grpID

#define CAN0RXIDR3_RTR_MASK             1U
#define CAN0RXIDR3_ID0_MASK             2U
#define CAN0RXIDR3_ID1_MASK             4U
#define CAN0RXIDR3_ID2_MASK             8U
#define CAN0RXIDR3_ID3_MASK             16U
#define CAN0RXIDR3_ID4_MASK             32U
#define CAN0RXIDR3_ID5_MASK             64U
#define CAN0RXIDR3_ID6_MASK             128U
#define CAN0RXIDR3_ID_MASK              254U
#define CAN0RXIDR3_ID_BITNUM            1U


/*** CAN0RXDSR0 - MSCAN0 Receive Data Segment Register 0; 0x00000164 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR0STR;
extern volatile CAN0RXDSR0STR _CAN0RXDSR0 @(REG_BASE + 0x00000164UL);
#define CAN0RXDSR0                      _CAN0RXDSR0.Byte
#define CAN0RXDSR0_DB0                  _CAN0RXDSR0.Bits.DB0
#define CAN0RXDSR0_DB1                  _CAN0RXDSR0.Bits.DB1
#define CAN0RXDSR0_DB2                  _CAN0RXDSR0.Bits.DB2
#define CAN0RXDSR0_DB3                  _CAN0RXDSR0.Bits.DB3
#define CAN0RXDSR0_DB4                  _CAN0RXDSR0.Bits.DB4
#define CAN0RXDSR0_DB5                  _CAN0RXDSR0.Bits.DB5
#define CAN0RXDSR0_DB6                  _CAN0RXDSR0.Bits.DB6
#define CAN0RXDSR0_DB7                  _CAN0RXDSR0.Bits.DB7
/* CAN0RXDSR_ARR: Access 8 CAN0RXDSRx registers in an array */
#define CAN0RXDSR_ARR                   ((volatile byte *) &CAN0RXDSR0)

#define CAN0RXDSR0_DB0_MASK             1U
#define CAN0RXDSR0_DB1_MASK             2U
#define CAN0RXDSR0_DB2_MASK             4U
#define CAN0RXDSR0_DB3_MASK             8U
#define CAN0RXDSR0_DB4_MASK             16U
#define CAN0RXDSR0_DB5_MASK             32U
#define CAN0RXDSR0_DB6_MASK             64U
#define CAN0RXDSR0_DB7_MASK             128U


/*** CAN0RXDSR1 - MSCAN0 Receive Data Segment Register 1; 0x00000165 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR1STR;
extern volatile CAN0RXDSR1STR _CAN0RXDSR1 @(REG_BASE + 0x00000165UL);
#define CAN0RXDSR1                      _CAN0RXDSR1.Byte
#define CAN0RXDSR1_DB0                  _CAN0RXDSR1.Bits.DB0
#define CAN0RXDSR1_DB1                  _CAN0RXDSR1.Bits.DB1
#define CAN0RXDSR1_DB2                  _CAN0RXDSR1.Bits.DB2
#define CAN0RXDSR1_DB3                  _CAN0RXDSR1.Bits.DB3
#define CAN0RXDSR1_DB4                  _CAN0RXDSR1.Bits.DB4
#define CAN0RXDSR1_DB5                  _CAN0RXDSR1.Bits.DB5
#define CAN0RXDSR1_DB6                  _CAN0RXDSR1.Bits.DB6
#define CAN0RXDSR1_DB7                  _CAN0RXDSR1.Bits.DB7

#define CAN0RXDSR1_DB0_MASK             1U
#define CAN0RXDSR1_DB1_MASK             2U
#define CAN0RXDSR1_DB2_MASK             4U
#define CAN0RXDSR1_DB3_MASK             8U
#define CAN0RXDSR1_DB4_MASK             16U
#define CAN0RXDSR1_DB5_MASK             32U
#define CAN0RXDSR1_DB6_MASK             64U
#define CAN0RXDSR1_DB7_MASK             128U


/*** CAN0RXDSR2 - MSCAN0 Receive Data Segment Register 2; 0x00000166 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR2STR;
extern volatile CAN0RXDSR2STR _CAN0RXDSR2 @(REG_BASE + 0x00000166UL);
#define CAN0RXDSR2                      _CAN0RXDSR2.Byte
#define CAN0RXDSR2_DB0                  _CAN0RXDSR2.Bits.DB0
#define CAN0RXDSR2_DB1                  _CAN0RXDSR2.Bits.DB1
#define CAN0RXDSR2_DB2                  _CAN0RXDSR2.Bits.DB2
#define CAN0RXDSR2_DB3                  _CAN0RXDSR2.Bits.DB3
#define CAN0RXDSR2_DB4                  _CAN0RXDSR2.Bits.DB4
#define CAN0RXDSR2_DB5                  _CAN0RXDSR2.Bits.DB5
#define CAN0RXDSR2_DB6                  _CAN0RXDSR2.Bits.DB6
#define CAN0RXDSR2_DB7                  _CAN0RXDSR2.Bits.DB7

#define CAN0RXDSR2_DB0_MASK             1U
#define CAN0RXDSR2_DB1_MASK             2U
#define CAN0RXDSR2_DB2_MASK             4U
#define CAN0RXDSR2_DB3_MASK             8U
#define CAN0RXDSR2_DB4_MASK             16U
#define CAN0RXDSR2_DB5_MASK             32U
#define CAN0RXDSR2_DB6_MASK             64U
#define CAN0RXDSR2_DB7_MASK             128U


/*** CAN0RXDSR3 - MSCAN0 Receive Data Segment Register 3; 0x00000167 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR3STR;
extern volatile CAN0RXDSR3STR _CAN0RXDSR3 @(REG_BASE + 0x00000167UL);
#define CAN0RXDSR3                      _CAN0RXDSR3.Byte
#define CAN0RXDSR3_DB0                  _CAN0RXDSR3.Bits.DB0
#define CAN0RXDSR3_DB1                  _CAN0RXDSR3.Bits.DB1
#define CAN0RXDSR3_DB2                  _CAN0RXDSR3.Bits.DB2
#define CAN0RXDSR3_DB3                  _CAN0RXDSR3.Bits.DB3
#define CAN0RXDSR3_DB4                  _CAN0RXDSR3.Bits.DB4
#define CAN0RXDSR3_DB5                  _CAN0RXDSR3.Bits.DB5
#define CAN0RXDSR3_DB6                  _CAN0RXDSR3.Bits.DB6
#define CAN0RXDSR3_DB7                  _CAN0RXDSR3.Bits.DB7

#define CAN0RXDSR3_DB0_MASK             1U
#define CAN0RXDSR3_DB1_MASK             2U
#define CAN0RXDSR3_DB2_MASK             4U
#define CAN0RXDSR3_DB3_MASK             8U
#define CAN0RXDSR3_DB4_MASK             16U
#define CAN0RXDSR3_DB5_MASK             32U
#define CAN0RXDSR3_DB6_MASK             64U
#define CAN0RXDSR3_DB7_MASK             128U


/*** CAN0RXDSR4 - MSCAN0 Receive Data Segment Register 4; 0x00000168 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR4STR;
extern volatile CAN0RXDSR4STR _CAN0RXDSR4 @(REG_BASE + 0x00000168UL);
#define CAN0RXDSR4                      _CAN0RXDSR4.Byte
#define CAN0RXDSR4_DB0                  _CAN0RXDSR4.Bits.DB0
#define CAN0RXDSR4_DB1                  _CAN0RXDSR4.Bits.DB1
#define CAN0RXDSR4_DB2                  _CAN0RXDSR4.Bits.DB2
#define CAN0RXDSR4_DB3                  _CAN0RXDSR4.Bits.DB3
#define CAN0RXDSR4_DB4                  _CAN0RXDSR4.Bits.DB4
#define CAN0RXDSR4_DB5                  _CAN0RXDSR4.Bits.DB5
#define CAN0RXDSR4_DB6                  _CAN0RXDSR4.Bits.DB6
#define CAN0RXDSR4_DB7                  _CAN0RXDSR4.Bits.DB7

#define CAN0RXDSR4_DB0_MASK             1U
#define CAN0RXDSR4_DB1_MASK             2U
#define CAN0RXDSR4_DB2_MASK             4U
#define CAN0RXDSR4_DB3_MASK             8U
#define CAN0RXDSR4_DB4_MASK             16U
#define CAN0RXDSR4_DB5_MASK             32U
#define CAN0RXDSR4_DB6_MASK             64U
#define CAN0RXDSR4_DB7_MASK             128U


/*** CAN0RXDSR5 - MSCAN0 Receive Data Segment Register 5; 0x00000169 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR5STR;
extern volatile CAN0RXDSR5STR _CAN0RXDSR5 @(REG_BASE + 0x00000169UL);
#define CAN0RXDSR5                      _CAN0RXDSR5.Byte
#define CAN0RXDSR5_DB0                  _CAN0RXDSR5.Bits.DB0
#define CAN0RXDSR5_DB1                  _CAN0RXDSR5.Bits.DB1
#define CAN0RXDSR5_DB2                  _CAN0RXDSR5.Bits.DB2
#define CAN0RXDSR5_DB3                  _CAN0RXDSR5.Bits.DB3
#define CAN0RXDSR5_DB4                  _CAN0RXDSR5.Bits.DB4
#define CAN0RXDSR5_DB5                  _CAN0RXDSR5.Bits.DB5
#define CAN0RXDSR5_DB6                  _CAN0RXDSR5.Bits.DB6
#define CAN0RXDSR5_DB7                  _CAN0RXDSR5.Bits.DB7

#define CAN0RXDSR5_DB0_MASK             1U
#define CAN0RXDSR5_DB1_MASK             2U
#define CAN0RXDSR5_DB2_MASK             4U
#define CAN0RXDSR5_DB3_MASK             8U
#define CAN0RXDSR5_DB4_MASK             16U
#define CAN0RXDSR5_DB5_MASK             32U
#define CAN0RXDSR5_DB6_MASK             64U
#define CAN0RXDSR5_DB7_MASK             128U


/*** CAN0RXDSR6 - MSCAN0 Receive Data Segment Register 6; 0x0000016A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR6STR;
extern volatile CAN0RXDSR6STR _CAN0RXDSR6 @(REG_BASE + 0x0000016AUL);
#define CAN0RXDSR6                      _CAN0RXDSR6.Byte
#define CAN0RXDSR6_DB0                  _CAN0RXDSR6.Bits.DB0
#define CAN0RXDSR6_DB1                  _CAN0RXDSR6.Bits.DB1
#define CAN0RXDSR6_DB2                  _CAN0RXDSR6.Bits.DB2
#define CAN0RXDSR6_DB3                  _CAN0RXDSR6.Bits.DB3
#define CAN0RXDSR6_DB4                  _CAN0RXDSR6.Bits.DB4
#define CAN0RXDSR6_DB5                  _CAN0RXDSR6.Bits.DB5
#define CAN0RXDSR6_DB6                  _CAN0RXDSR6.Bits.DB6
#define CAN0RXDSR6_DB7                  _CAN0RXDSR6.Bits.DB7

#define CAN0RXDSR6_DB0_MASK             1U
#define CAN0RXDSR6_DB1_MASK             2U
#define CAN0RXDSR6_DB2_MASK             4U
#define CAN0RXDSR6_DB3_MASK             8U
#define CAN0RXDSR6_DB4_MASK             16U
#define CAN0RXDSR6_DB5_MASK             32U
#define CAN0RXDSR6_DB6_MASK             64U
#define CAN0RXDSR6_DB7_MASK             128U


/*** CAN0RXDSR7 - MSCAN0 Receive Data Segment Register 7; 0x0000016B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR7STR;
extern volatile CAN0RXDSR7STR _CAN0RXDSR7 @(REG_BASE + 0x0000016BUL);
#define CAN0RXDSR7                      _CAN0RXDSR7.Byte
#define CAN0RXDSR7_DB0                  _CAN0RXDSR7.Bits.DB0
#define CAN0RXDSR7_DB1                  _CAN0RXDSR7.Bits.DB1
#define CAN0RXDSR7_DB2                  _CAN0RXDSR7.Bits.DB2
#define CAN0RXDSR7_DB3                  _CAN0RXDSR7.Bits.DB3
#define CAN0RXDSR7_DB4                  _CAN0RXDSR7.Bits.DB4
#define CAN0RXDSR7_DB5                  _CAN0RXDSR7.Bits.DB5
#define CAN0RXDSR7_DB6                  _CAN0RXDSR7.Bits.DB6
#define CAN0RXDSR7_DB7                  _CAN0RXDSR7.Bits.DB7

#define CAN0RXDSR7_DB0_MASK             1U
#define CAN0RXDSR7_DB1_MASK             2U
#define CAN0RXDSR7_DB2_MASK             4U
#define CAN0RXDSR7_DB3_MASK             8U
#define CAN0RXDSR7_DB4_MASK             16U
#define CAN0RXDSR7_DB5_MASK             32U
#define CAN0RXDSR7_DB6_MASK             64U
#define CAN0RXDSR7_DB7_MASK             128U


/*** CAN0RXDLR - MSCAN0 Receive Data Length Register; 0x0000016C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RXDLRSTR;
extern volatile CAN0RXDLRSTR _CAN0RXDLR @(REG_BASE + 0x0000016CUL);
#define CAN0RXDLR                       _CAN0RXDLR.Byte
#define CAN0RXDLR_DLC0                  _CAN0RXDLR.Bits.DLC0
#define CAN0RXDLR_DLC1                  _CAN0RXDLR.Bits.DLC1
#define CAN0RXDLR_DLC2                  _CAN0RXDLR.Bits.DLC2
#define CAN0RXDLR_DLC3                  _CAN0RXDLR.Bits.DLC3
#define CAN0RXDLR_DLC                   _CAN0RXDLR.MergedBits.grpDLC

#define CAN0RXDLR_DLC0_MASK             1U
#define CAN0RXDLR_DLC1_MASK             2U
#define CAN0RXDLR_DLC2_MASK             4U
#define CAN0RXDLR_DLC3_MASK             8U
#define CAN0RXDLR_DLC_MASK              15U
#define CAN0RXDLR_DLC_BITNUM            0U


/*** CAN0RXTSR - MSCAN0 Receive Time Stamp Register; 0x0000016E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0RXTSRH - MSCAN0 Receive Time Stamp Register High; 0x0000016E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0RXTSRHSTR;
    #define CAN0RXTSRH                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Byte
    #define CAN0RXTSRH_TSR8             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR8
    #define CAN0RXTSRH_TSR9             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR9
    #define CAN0RXTSRH_TSR10            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR10
    #define CAN0RXTSRH_TSR11            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR11
    #define CAN0RXTSRH_TSR12            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR12
    #define CAN0RXTSRH_TSR13            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR13
    #define CAN0RXTSRH_TSR14            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR14
    #define CAN0RXTSRH_TSR15            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR15
    
    #define CAN0RXTSRH_TSR8_MASK        1U
    #define CAN0RXTSRH_TSR9_MASK        2U
    #define CAN0RXTSRH_TSR10_MASK       4U
    #define CAN0RXTSRH_TSR11_MASK       8U
    #define CAN0RXTSRH_TSR12_MASK       16U
    #define CAN0RXTSRH_TSR13_MASK       32U
    #define CAN0RXTSRH_TSR14_MASK       64U
    #define CAN0RXTSRH_TSR15_MASK       128U
    

    /*** CAN0RXTSRL - MSCAN0 Receive Time Stamp Register Low; 0x0000016F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0RXTSRLSTR;
    #define CAN0RXTSRL                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Byte
    #define CAN0RXTSRL_TSR0             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR0
    #define CAN0RXTSRL_TSR1             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR1
    #define CAN0RXTSRL_TSR2             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR2
    #define CAN0RXTSRL_TSR3             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR3
    #define CAN0RXTSRL_TSR4             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR4
    #define CAN0RXTSRL_TSR5             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR5
    #define CAN0RXTSRL_TSR6             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR6
    #define CAN0RXTSRL_TSR7             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR7
    
    #define CAN0RXTSRL_TSR0_MASK        1U
    #define CAN0RXTSRL_TSR1_MASK        2U
    #define CAN0RXTSRL_TSR2_MASK        4U
    #define CAN0RXTSRL_TSR3_MASK        8U
    #define CAN0RXTSRL_TSR4_MASK        16U
    #define CAN0RXTSRL_TSR5_MASK        32U
    #define CAN0RXTSRL_TSR6_MASK        64U
    #define CAN0RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0RXTSRSTR;
extern volatile CAN0RXTSRSTR _CAN0RXTSR @(REG_BASE + 0x0000016EUL);
#define CAN0RXTSR                       _CAN0RXTSR.Word
#define CAN0RXTSR_TSR0                  _CAN0RXTSR.Bits.TSR0
#define CAN0RXTSR_TSR1                  _CAN0RXTSR.Bits.TSR1
#define CAN0RXTSR_TSR2                  _CAN0RXTSR.Bits.TSR2
#define CAN0RXTSR_TSR3                  _CAN0RXTSR.Bits.TSR3
#define CAN0RXTSR_TSR4                  _CAN0RXTSR.Bits.TSR4
#define CAN0RXTSR_TSR5                  _CAN0RXTSR.Bits.TSR5
#define CAN0RXTSR_TSR6                  _CAN0RXTSR.Bits.TSR6
#define CAN0RXTSR_TSR7                  _CAN0RXTSR.Bits.TSR7
#define CAN0RXTSR_TSR8                  _CAN0RXTSR.Bits.TSR8
#define CAN0RXTSR_TSR9                  _CAN0RXTSR.Bits.TSR9
#define CAN0RXTSR_TSR10                 _CAN0RXTSR.Bits.TSR10
#define CAN0RXTSR_TSR11                 _CAN0RXTSR.Bits.TSR11
#define CAN0RXTSR_TSR12                 _CAN0RXTSR.Bits.TSR12
#define CAN0RXTSR_TSR13                 _CAN0RXTSR.Bits.TSR13
#define CAN0RXTSR_TSR14                 _CAN0RXTSR.Bits.TSR14
#define CAN0RXTSR_TSR15                 _CAN0RXTSR.Bits.TSR15

#define CAN0RXTSR_TSR0_MASK             1U
#define CAN0RXTSR_TSR1_MASK             2U
#define CAN0RXTSR_TSR2_MASK             4U
#define CAN0RXTSR_TSR3_MASK             8U
#define CAN0RXTSR_TSR4_MASK             16U
#define CAN0RXTSR_TSR5_MASK             32U
#define CAN0RXTSR_TSR6_MASK             64U
#define CAN0RXTSR_TSR7_MASK             128U
#define CAN0RXTSR_TSR8_MASK             256U
#define CAN0RXTSR_TSR9_MASK             512U
#define CAN0RXTSR_TSR10_MASK            1024U
#define CAN0RXTSR_TSR11_MASK            2048U
#define CAN0RXTSR_TSR12_MASK            4096U
#define CAN0RXTSR_TSR13_MASK            8192U
#define CAN0RXTSR_TSR14_MASK            16384U
#define CAN0RXTSR_TSR15_MASK            32768U


/*** CAN0TXIDR0 - MSCAN0 Transmit Identifier Register 0; 0x00000170 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0TXIDR0STR;
extern volatile CAN0TXIDR0STR _CAN0TXIDR0 @(REG_BASE + 0x00000170UL);
#define CAN0TXIDR0                      _CAN0TXIDR0.Byte
#define CAN0TXIDR0_ID21                 _CAN0TXIDR0.Bits.ID21
#define CAN0TXIDR0_ID22                 _CAN0TXIDR0.Bits.ID22
#define CAN0TXIDR0_ID23                 _CAN0TXIDR0.Bits.ID23
#define CAN0TXIDR0_ID24                 _CAN0TXIDR0.Bits.ID24
#define CAN0TXIDR0_ID25                 _CAN0TXIDR0.Bits.ID25
#define CAN0TXIDR0_ID26                 _CAN0TXIDR0.Bits.ID26
#define CAN0TXIDR0_ID27                 _CAN0TXIDR0.Bits.ID27
#define CAN0TXIDR0_ID28                 _CAN0TXIDR0.Bits.ID28
/* CAN0TXIDR_ARR: Access 4 CAN0TXIDRx registers in an array */
#define CAN0TXIDR_ARR                   ((volatile byte *) &CAN0TXIDR0)

#define CAN0TXIDR0_ID21_MASK            1U
#define CAN0TXIDR0_ID22_MASK            2U
#define CAN0TXIDR0_ID23_MASK            4U
#define CAN0TXIDR0_ID24_MASK            8U
#define CAN0TXIDR0_ID25_MASK            16U
#define CAN0TXIDR0_ID26_MASK            32U
#define CAN0TXIDR0_ID27_MASK            64U
#define CAN0TXIDR0_ID28_MASK            128U


/*** CAN0TXIDR1 - MSCAN0 Transmit Identifier Register 1; 0x00000171 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0TXIDR1STR;
extern volatile CAN0TXIDR1STR _CAN0TXIDR1 @(REG_BASE + 0x00000171UL);
#define CAN0TXIDR1                      _CAN0TXIDR1.Byte
#define CAN0TXIDR1_ID15                 _CAN0TXIDR1.Bits.ID15
#define CAN0TXIDR1_ID16                 _CAN0TXIDR1.Bits.ID16
#define CAN0TXIDR1_ID17                 _CAN0TXIDR1.Bits.ID17
#define CAN0TXIDR1_IDE                  _CAN0TXIDR1.Bits.IDE
#define CAN0TXIDR1_SRR                  _CAN0TXIDR1.Bits.SRR
#define CAN0TXIDR1_ID18                 _CAN0TXIDR1.Bits.ID18
#define CAN0TXIDR1_ID19                 _CAN0TXIDR1.Bits.ID19
#define CAN0TXIDR1_ID20                 _CAN0TXIDR1.Bits.ID20
#define CAN0TXIDR1_ID_15                _CAN0TXIDR1.MergedBits.grpID_15
#define CAN0TXIDR1_ID_18                _CAN0TXIDR1.MergedBits.grpID_18
#define CAN0TXIDR1_ID                   CAN0TXIDR1_ID_15

#define CAN0TXIDR1_ID15_MASK            1U
#define CAN0TXIDR1_ID16_MASK            2U
#define CAN0TXIDR1_ID17_MASK            4U
#define CAN0TXIDR1_IDE_MASK             8U
#define CAN0TXIDR1_SRR_MASK             16U
#define CAN0TXIDR1_ID18_MASK            32U
#define CAN0TXIDR1_ID19_MASK            64U
#define CAN0TXIDR1_ID20_MASK            128U
#define CAN0TXIDR1_ID_15_MASK           7U
#define CAN0TXIDR1_ID_15_BITNUM         0U
#define CAN0TXIDR1_ID_18_MASK           224U
#define CAN0TXIDR1_ID_18_BITNUM         5U


/*** CAN0TXIDR2 - MSCAN0 Transmit Identifier Register 2; 0x00000172 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0TXIDR2STR;
extern volatile CAN0TXIDR2STR _CAN0TXIDR2 @(REG_BASE + 0x00000172UL);
#define CAN0TXIDR2                      _CAN0TXIDR2.Byte
#define CAN0TXIDR2_ID7                  _CAN0TXIDR2.Bits.ID7
#define CAN0TXIDR2_ID8                  _CAN0TXIDR2.Bits.ID8
#define CAN0TXIDR2_ID9                  _CAN0TXIDR2.Bits.ID9
#define CAN0TXIDR2_ID10                 _CAN0TXIDR2.Bits.ID10
#define CAN0TXIDR2_ID11                 _CAN0TXIDR2.Bits.ID11
#define CAN0TXIDR2_ID12                 _CAN0TXIDR2.Bits.ID12
#define CAN0TXIDR2_ID13                 _CAN0TXIDR2.Bits.ID13
#define CAN0TXIDR2_ID14                 _CAN0TXIDR2.Bits.ID14

#define CAN0TXIDR2_ID7_MASK             1U
#define CAN0TXIDR2_ID8_MASK             2U
#define CAN0TXIDR2_ID9_MASK             4U
#define CAN0TXIDR2_ID10_MASK            8U
#define CAN0TXIDR2_ID11_MASK            16U
#define CAN0TXIDR2_ID12_MASK            32U
#define CAN0TXIDR2_ID13_MASK            64U
#define CAN0TXIDR2_ID14_MASK            128U


/*** CAN0TXIDR3 - MSCAN0 Transmit Identifier Register 3; 0x00000173 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0TXIDR3STR;
extern volatile CAN0TXIDR3STR _CAN0TXIDR3 @(REG_BASE + 0x00000173UL);
#define CAN0TXIDR3                      _CAN0TXIDR3.Byte
#define CAN0TXIDR3_RTR                  _CAN0TXIDR3.Bits.RTR
#define CAN0TXIDR3_ID0                  _CAN0TXIDR3.Bits.ID0
#define CAN0TXIDR3_ID1                  _CAN0TXIDR3.Bits.ID1
#define CAN0TXIDR3_ID2                  _CAN0TXIDR3.Bits.ID2
#define CAN0TXIDR3_ID3                  _CAN0TXIDR3.Bits.ID3
#define CAN0TXIDR3_ID4                  _CAN0TXIDR3.Bits.ID4
#define CAN0TXIDR3_ID5                  _CAN0TXIDR3.Bits.ID5
#define CAN0TXIDR3_ID6                  _CAN0TXIDR3.Bits.ID6
#define CAN0TXIDR3_ID                   _CAN0TXIDR3.MergedBits.grpID

#define CAN0TXIDR3_RTR_MASK             1U
#define CAN0TXIDR3_ID0_MASK             2U
#define CAN0TXIDR3_ID1_MASK             4U
#define CAN0TXIDR3_ID2_MASK             8U
#define CAN0TXIDR3_ID3_MASK             16U
#define CAN0TXIDR3_ID4_MASK             32U
#define CAN0TXIDR3_ID5_MASK             64U
#define CAN0TXIDR3_ID6_MASK             128U
#define CAN0TXIDR3_ID_MASK              254U
#define CAN0TXIDR3_ID_BITNUM            1U


/*** CAN0TXDSR0 - MSCAN0 Transmit Data Segment Register 0; 0x00000174 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR0STR;
extern volatile CAN0TXDSR0STR _CAN0TXDSR0 @(REG_BASE + 0x00000174UL);
#define CAN0TXDSR0                      _CAN0TXDSR0.Byte
#define CAN0TXDSR0_DB0                  _CAN0TXDSR0.Bits.DB0
#define CAN0TXDSR0_DB1                  _CAN0TXDSR0.Bits.DB1
#define CAN0TXDSR0_DB2                  _CAN0TXDSR0.Bits.DB2
#define CAN0TXDSR0_DB3                  _CAN0TXDSR0.Bits.DB3
#define CAN0TXDSR0_DB4                  _CAN0TXDSR0.Bits.DB4
#define CAN0TXDSR0_DB5                  _CAN0TXDSR0.Bits.DB5
#define CAN0TXDSR0_DB6                  _CAN0TXDSR0.Bits.DB6
#define CAN0TXDSR0_DB7                  _CAN0TXDSR0.Bits.DB7
/* CAN0TXDSR_ARR: Access 8 CAN0TXDSRx registers in an array */
#define CAN0TXDSR_ARR                   ((volatile byte *) &CAN0TXDSR0)

#define CAN0TXDSR0_DB0_MASK             1U
#define CAN0TXDSR0_DB1_MASK             2U
#define CAN0TXDSR0_DB2_MASK             4U
#define CAN0TXDSR0_DB3_MASK             8U
#define CAN0TXDSR0_DB4_MASK             16U
#define CAN0TXDSR0_DB5_MASK             32U
#define CAN0TXDSR0_DB6_MASK             64U
#define CAN0TXDSR0_DB7_MASK             128U


/*** CAN0TXDSR1 - MSCAN0 Transmit Data Segment Register 1; 0x00000175 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR1STR;
extern volatile CAN0TXDSR1STR _CAN0TXDSR1 @(REG_BASE + 0x00000175UL);
#define CAN0TXDSR1                      _CAN0TXDSR1.Byte
#define CAN0TXDSR1_DB0                  _CAN0TXDSR1.Bits.DB0
#define CAN0TXDSR1_DB1                  _CAN0TXDSR1.Bits.DB1
#define CAN0TXDSR1_DB2                  _CAN0TXDSR1.Bits.DB2
#define CAN0TXDSR1_DB3                  _CAN0TXDSR1.Bits.DB3
#define CAN0TXDSR1_DB4                  _CAN0TXDSR1.Bits.DB4
#define CAN0TXDSR1_DB5                  _CAN0TXDSR1.Bits.DB5
#define CAN0TXDSR1_DB6                  _CAN0TXDSR1.Bits.DB6
#define CAN0TXDSR1_DB7                  _CAN0TXDSR1.Bits.DB7

#define CAN0TXDSR1_DB0_MASK             1U
#define CAN0TXDSR1_DB1_MASK             2U
#define CAN0TXDSR1_DB2_MASK             4U
#define CAN0TXDSR1_DB3_MASK             8U
#define CAN0TXDSR1_DB4_MASK             16U
#define CAN0TXDSR1_DB5_MASK             32U
#define CAN0TXDSR1_DB6_MASK             64U
#define CAN0TXDSR1_DB7_MASK             128U


/*** CAN0TXDSR2 - MSCAN0 Transmit Data Segment Register 2; 0x00000176 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR2STR;
extern volatile CAN0TXDSR2STR _CAN0TXDSR2 @(REG_BASE + 0x00000176UL);
#define CAN0TXDSR2                      _CAN0TXDSR2.Byte
#define CAN0TXDSR2_DB0                  _CAN0TXDSR2.Bits.DB0
#define CAN0TXDSR2_DB1                  _CAN0TXDSR2.Bits.DB1
#define CAN0TXDSR2_DB2                  _CAN0TXDSR2.Bits.DB2
#define CAN0TXDSR2_DB3                  _CAN0TXDSR2.Bits.DB3
#define CAN0TXDSR2_DB4                  _CAN0TXDSR2.Bits.DB4
#define CAN0TXDSR2_DB5                  _CAN0TXDSR2.Bits.DB5
#define CAN0TXDSR2_DB6                  _CAN0TXDSR2.Bits.DB6
#define CAN0TXDSR2_DB7                  _CAN0TXDSR2.Bits.DB7

#define CAN0TXDSR2_DB0_MASK             1U
#define CAN0TXDSR2_DB1_MASK             2U
#define CAN0TXDSR2_DB2_MASK             4U
#define CAN0TXDSR2_DB3_MASK             8U
#define CAN0TXDSR2_DB4_MASK             16U
#define CAN0TXDSR2_DB5_MASK             32U
#define CAN0TXDSR2_DB6_MASK             64U
#define CAN0TXDSR2_DB7_MASK             128U


/*** CAN0TXDSR3 - MSCAN0 Transmit Data Segment Register 3; 0x00000177 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR3STR;
extern volatile CAN0TXDSR3STR _CAN0TXDSR3 @(REG_BASE + 0x00000177UL);
#define CAN0TXDSR3                      _CAN0TXDSR3.Byte
#define CAN0TXDSR3_DB0                  _CAN0TXDSR3.Bits.DB0
#define CAN0TXDSR3_DB1                  _CAN0TXDSR3.Bits.DB1
#define CAN0TXDSR3_DB2                  _CAN0TXDSR3.Bits.DB2
#define CAN0TXDSR3_DB3                  _CAN0TXDSR3.Bits.DB3
#define CAN0TXDSR3_DB4                  _CAN0TXDSR3.Bits.DB4
#define CAN0TXDSR3_DB5                  _CAN0TXDSR3.Bits.DB5
#define CAN0TXDSR3_DB6                  _CAN0TXDSR3.Bits.DB6
#define CAN0TXDSR3_DB7                  _CAN0TXDSR3.Bits.DB7

#define CAN0TXDSR3_DB0_MASK             1U
#define CAN0TXDSR3_DB1_MASK             2U
#define CAN0TXDSR3_DB2_MASK             4U
#define CAN0TXDSR3_DB3_MASK             8U
#define CAN0TXDSR3_DB4_MASK             16U
#define CAN0TXDSR3_DB5_MASK             32U
#define CAN0TXDSR3_DB6_MASK             64U
#define CAN0TXDSR3_DB7_MASK             128U


/*** CAN0TXDSR4 - MSCAN0 Transmit Data Segment Register 4; 0x00000178 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR4STR;
extern volatile CAN0TXDSR4STR _CAN0TXDSR4 @(REG_BASE + 0x00000178UL);
#define CAN0TXDSR4                      _CAN0TXDSR4.Byte
#define CAN0TXDSR4_DB0                  _CAN0TXDSR4.Bits.DB0
#define CAN0TXDSR4_DB1                  _CAN0TXDSR4.Bits.DB1
#define CAN0TXDSR4_DB2                  _CAN0TXDSR4.Bits.DB2
#define CAN0TXDSR4_DB3                  _CAN0TXDSR4.Bits.DB3
#define CAN0TXDSR4_DB4                  _CAN0TXDSR4.Bits.DB4
#define CAN0TXDSR4_DB5                  _CAN0TXDSR4.Bits.DB5
#define CAN0TXDSR4_DB6                  _CAN0TXDSR4.Bits.DB6
#define CAN0TXDSR4_DB7                  _CAN0TXDSR4.Bits.DB7

#define CAN0TXDSR4_DB0_MASK             1U
#define CAN0TXDSR4_DB1_MASK             2U
#define CAN0TXDSR4_DB2_MASK             4U
#define CAN0TXDSR4_DB3_MASK             8U
#define CAN0TXDSR4_DB4_MASK             16U
#define CAN0TXDSR4_DB5_MASK             32U
#define CAN0TXDSR4_DB6_MASK             64U
#define CAN0TXDSR4_DB7_MASK             128U


/*** CAN0TXDSR5 - MSCAN0 Transmit Data Segment Register 5; 0x00000179 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR5STR;
extern volatile CAN0TXDSR5STR _CAN0TXDSR5 @(REG_BASE + 0x00000179UL);
#define CAN0TXDSR5                      _CAN0TXDSR5.Byte
#define CAN0TXDSR5_DB0                  _CAN0TXDSR5.Bits.DB0
#define CAN0TXDSR5_DB1                  _CAN0TXDSR5.Bits.DB1
#define CAN0TXDSR5_DB2                  _CAN0TXDSR5.Bits.DB2
#define CAN0TXDSR5_DB3                  _CAN0TXDSR5.Bits.DB3
#define CAN0TXDSR5_DB4                  _CAN0TXDSR5.Bits.DB4
#define CAN0TXDSR5_DB5                  _CAN0TXDSR5.Bits.DB5
#define CAN0TXDSR5_DB6                  _CAN0TXDSR5.Bits.DB6
#define CAN0TXDSR5_DB7                  _CAN0TXDSR5.Bits.DB7

#define CAN0TXDSR5_DB0_MASK             1U
#define CAN0TXDSR5_DB1_MASK             2U
#define CAN0TXDSR5_DB2_MASK             4U
#define CAN0TXDSR5_DB3_MASK             8U
#define CAN0TXDSR5_DB4_MASK             16U
#define CAN0TXDSR5_DB5_MASK             32U
#define CAN0TXDSR5_DB6_MASK             64U
#define CAN0TXDSR5_DB7_MASK             128U


/*** CAN0TXDSR6 - MSCAN0 Transmit Data Segment Register 6; 0x0000017A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR6STR;
extern volatile CAN0TXDSR6STR _CAN0TXDSR6 @(REG_BASE + 0x0000017AUL);
#define CAN0TXDSR6                      _CAN0TXDSR6.Byte
#define CAN0TXDSR6_DB0                  _CAN0TXDSR6.Bits.DB0
#define CAN0TXDSR6_DB1                  _CAN0TXDSR6.Bits.DB1
#define CAN0TXDSR6_DB2                  _CAN0TXDSR6.Bits.DB2
#define CAN0TXDSR6_DB3                  _CAN0TXDSR6.Bits.DB3
#define CAN0TXDSR6_DB4                  _CAN0TXDSR6.Bits.DB4
#define CAN0TXDSR6_DB5                  _CAN0TXDSR6.Bits.DB5
#define CAN0TXDSR6_DB6                  _CAN0TXDSR6.Bits.DB6
#define CAN0TXDSR6_DB7                  _CAN0TXDSR6.Bits.DB7

#define CAN0TXDSR6_DB0_MASK             1U
#define CAN0TXDSR6_DB1_MASK             2U
#define CAN0TXDSR6_DB2_MASK             4U
#define CAN0TXDSR6_DB3_MASK             8U
#define CAN0TXDSR6_DB4_MASK             16U
#define CAN0TXDSR6_DB5_MASK             32U
#define CAN0TXDSR6_DB6_MASK             64U
#define CAN0TXDSR6_DB7_MASK             128U


/*** CAN0TXDSR7 - MSCAN0 Transmit Data Segment Register 7; 0x0000017B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR7STR;
extern volatile CAN0TXDSR7STR _CAN0TXDSR7 @(REG_BASE + 0x0000017BUL);
#define CAN0TXDSR7                      _CAN0TXDSR7.Byte
#define CAN0TXDSR7_DB0                  _CAN0TXDSR7.Bits.DB0
#define CAN0TXDSR7_DB1                  _CAN0TXDSR7.Bits.DB1
#define CAN0TXDSR7_DB2                  _CAN0TXDSR7.Bits.DB2
#define CAN0TXDSR7_DB3                  _CAN0TXDSR7.Bits.DB3
#define CAN0TXDSR7_DB4                  _CAN0TXDSR7.Bits.DB4
#define CAN0TXDSR7_DB5                  _CAN0TXDSR7.Bits.DB5
#define CAN0TXDSR7_DB6                  _CAN0TXDSR7.Bits.DB6
#define CAN0TXDSR7_DB7                  _CAN0TXDSR7.Bits.DB7

#define CAN0TXDSR7_DB0_MASK             1U
#define CAN0TXDSR7_DB1_MASK             2U
#define CAN0TXDSR7_DB2_MASK             4U
#define CAN0TXDSR7_DB3_MASK             8U
#define CAN0TXDSR7_DB4_MASK             16U
#define CAN0TXDSR7_DB5_MASK             32U
#define CAN0TXDSR7_DB6_MASK             64U
#define CAN0TXDSR7_DB7_MASK             128U


/*** CAN0TXDLR - MSCAN0 Transmit Data Length Register; 0x0000017C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TXDLRSTR;
extern volatile CAN0TXDLRSTR _CAN0TXDLR @(REG_BASE + 0x0000017CUL);
#define CAN0TXDLR                       _CAN0TXDLR.Byte
#define CAN0TXDLR_DLC0                  _CAN0TXDLR.Bits.DLC0
#define CAN0TXDLR_DLC1                  _CAN0TXDLR.Bits.DLC1
#define CAN0TXDLR_DLC2                  _CAN0TXDLR.Bits.DLC2
#define CAN0TXDLR_DLC3                  _CAN0TXDLR.Bits.DLC3
#define CAN0TXDLR_DLC                   _CAN0TXDLR.MergedBits.grpDLC

#define CAN0TXDLR_DLC0_MASK             1U
#define CAN0TXDLR_DLC1_MASK             2U
#define CAN0TXDLR_DLC2_MASK             4U
#define CAN0TXDLR_DLC3_MASK             8U
#define CAN0TXDLR_DLC_MASK              15U
#define CAN0TXDLR_DLC_BITNUM            0U


/*** CAN0TXTBPR - MSCAN0 Transmit Buffer Priority; 0x0000017D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN0TXTBPRSTR;
extern volatile CAN0TXTBPRSTR _CAN0TXTBPR @(REG_BASE + 0x0000017DUL);
#define CAN0TXTBPR                      _CAN0TXTBPR.Byte
#define CAN0TXTBPR_PRIO0                _CAN0TXTBPR.Bits.PRIO0
#define CAN0TXTBPR_PRIO1                _CAN0TXTBPR.Bits.PRIO1
#define CAN0TXTBPR_PRIO2                _CAN0TXTBPR.Bits.PRIO2
#define CAN0TXTBPR_PRIO3                _CAN0TXTBPR.Bits.PRIO3
#define CAN0TXTBPR_PRIO4                _CAN0TXTBPR.Bits.PRIO4
#define CAN0TXTBPR_PRIO5                _CAN0TXTBPR.Bits.PRIO5
#define CAN0TXTBPR_PRIO6                _CAN0TXTBPR.Bits.PRIO6
#define CAN0TXTBPR_PRIO7                _CAN0TXTBPR.Bits.PRIO7

#define CAN0TXTBPR_PRIO0_MASK           1U
#define CAN0TXTBPR_PRIO1_MASK           2U
#define CAN0TXTBPR_PRIO2_MASK           4U
#define CAN0TXTBPR_PRIO3_MASK           8U
#define CAN0TXTBPR_PRIO4_MASK           16U
#define CAN0TXTBPR_PRIO5_MASK           32U
#define CAN0TXTBPR_PRIO6_MASK           64U
#define CAN0TXTBPR_PRIO7_MASK           128U


/*** CAN0TXTSR - MSCAN0 Transmit Time Stamp Register; 0x0000017E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0TXTSRH - MSCAN0 Transmit Time Stamp Register High; 0x0000017E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0TXTSRHSTR;
    #define CAN0TXTSRH                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Byte
    #define CAN0TXTSRH_TSR8             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR8
    #define CAN0TXTSRH_TSR9             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR9
    #define CAN0TXTSRH_TSR10            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR10
    #define CAN0TXTSRH_TSR11            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR11
    #define CAN0TXTSRH_TSR12            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR12
    #define CAN0TXTSRH_TSR13            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR13
    #define CAN0TXTSRH_TSR14            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR14
    #define CAN0TXTSRH_TSR15            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR15
    
    #define CAN0TXTSRH_TSR8_MASK        1U
    #define CAN0TXTSRH_TSR9_MASK        2U
    #define CAN0TXTSRH_TSR10_MASK       4U
    #define CAN0TXTSRH_TSR11_MASK       8U
    #define CAN0TXTSRH_TSR12_MASK       16U
    #define CAN0TXTSRH_TSR13_MASK       32U
    #define CAN0TXTSRH_TSR14_MASK       64U
    #define CAN0TXTSRH_TSR15_MASK       128U
    

    /*** CAN0TXTSRL - MSCAN0 Transmit Time Stamp Register Low; 0x0000017F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0TXTSRLSTR;
    #define CAN0TXTSRL                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Byte
    #define CAN0TXTSRL_TSR0             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR0
    #define CAN0TXTSRL_TSR1             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR1
    #define CAN0TXTSRL_TSR2             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR2
    #define CAN0TXTSRL_TSR3             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR3
    #define CAN0TXTSRL_TSR4             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR4
    #define CAN0TXTSRL_TSR5             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR5
    #define CAN0TXTSRL_TSR6             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR6
    #define CAN0TXTSRL_TSR7             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR7
    
    #define CAN0TXTSRL_TSR0_MASK        1U
    #define CAN0TXTSRL_TSR1_MASK        2U
    #define CAN0TXTSRL_TSR2_MASK        4U
    #define CAN0TXTSRL_TSR3_MASK        8U
    #define CAN0TXTSRL_TSR4_MASK        16U
    #define CAN0TXTSRL_TSR5_MASK        32U
    #define CAN0TXTSRL_TSR6_MASK        64U
    #define CAN0TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0TXTSRSTR;
extern volatile CAN0TXTSRSTR _CAN0TXTSR @(REG_BASE + 0x0000017EUL);
#define CAN0TXTSR                       _CAN0TXTSR.Word
#define CAN0TXTSR_TSR0                  _CAN0TXTSR.Bits.TSR0
#define CAN0TXTSR_TSR1                  _CAN0TXTSR.Bits.TSR1
#define CAN0TXTSR_TSR2                  _CAN0TXTSR.Bits.TSR2
#define CAN0TXTSR_TSR3                  _CAN0TXTSR.Bits.TSR3
#define CAN0TXTSR_TSR4                  _CAN0TXTSR.Bits.TSR4
#define CAN0TXTSR_TSR5                  _CAN0TXTSR.Bits.TSR5
#define CAN0TXTSR_TSR6                  _CAN0TXTSR.Bits.TSR6
#define CAN0TXTSR_TSR7                  _CAN0TXTSR.Bits.TSR7
#define CAN0TXTSR_TSR8                  _CAN0TXTSR.Bits.TSR8
#define CAN0TXTSR_TSR9                  _CAN0TXTSR.Bits.TSR9
#define CAN0TXTSR_TSR10                 _CAN0TXTSR.Bits.TSR10
#define CAN0TXTSR_TSR11                 _CAN0TXTSR.Bits.TSR11
#define CAN0TXTSR_TSR12                 _CAN0TXTSR.Bits.TSR12
#define CAN0TXTSR_TSR13                 _CAN0TXTSR.Bits.TSR13
#define CAN0TXTSR_TSR14                 _CAN0TXTSR.Bits.TSR14
#define CAN0TXTSR_TSR15                 _CAN0TXTSR.Bits.TSR15

#define CAN0TXTSR_TSR0_MASK             1U
#define CAN0TXTSR_TSR1_MASK             2U
#define CAN0TXTSR_TSR2_MASK             4U
#define CAN0TXTSR_TSR3_MASK             8U
#define CAN0TXTSR_TSR4_MASK             16U
#define CAN0TXTSR_TSR5_MASK             32U
#define CAN0TXTSR_TSR6_MASK             64U
#define CAN0TXTSR_TSR7_MASK             128U
#define CAN0TXTSR_TSR8_MASK             256U
#define CAN0TXTSR_TSR9_MASK             512U
#define CAN0TXTSR_TSR10_MASK            1024U
#define CAN0TXTSR_TSR11_MASK            2048U
#define CAN0TXTSR_TSR12_MASK            4096U
#define CAN0TXTSR_TSR13_MASK            8192U
#define CAN0TXTSR_TSR14_MASK            16384U
#define CAN0TXTSR_TSR15_MASK            32768U


/*** PTT - Port T Data Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T general purpose input/output data bit 0 */
    byte PTT1        :1;                                       /* Port T general purpose input/output data bit 1 */
    byte PTT2        :1;                                       /* Port T general purpose input/output data bit 2 */
    byte PTT3        :1;                                       /* Port T general purpose input/output data bit 3 */
    byte PTT4        :1;                                       /* Port T general purpose input/output data bit 4 */
    byte PTT5        :1;                                       /* Port T general purpose input/output data bit 5 */
    byte PTT6        :1;                                       /* Port T general purpose input/output data bit 6 */
    byte PTT7        :1;                                       /* Port T general purpose input/output data bit 7 */
  } Bits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000240UL);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT4                        _PTT.Bits.PTT4
#define PTT_PTT5                        _PTT.Bits.PTT5
#define PTT_PTT6                        _PTT.Bits.PTT6
#define PTT_PTT7                        _PTT.Bits.PTT7

#define PTT_PTT0_MASK                   1U
#define PTT_PTT1_MASK                   2U
#define PTT_PTT2_MASK                   4U
#define PTT_PTT3_MASK                   8U
#define PTT_PTT4_MASK                   16U
#define PTT_PTT5_MASK                   32U
#define PTT_PTT6_MASK                   64U
#define PTT_PTT7_MASK                   128U


/*** PTIT - Port T Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T input data bit 0 */
    byte PTIT1       :1;                                       /* Port T input data bit 1 */
    byte PTIT2       :1;                                       /* Port T input data bit 2 */
    byte PTIT3       :1;                                       /* Port T input data bit 3 */
    byte PTIT4       :1;                                       /* Port T input data bit 4 */
    byte PTIT5       :1;                                       /* Port T input data bit 5 */
    byte PTIT6       :1;                                       /* Port T input data bit 6 */
    byte PTIT7       :1;                                       /* Port T input data bit 7 */
  } Bits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000241UL);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT4                      _PTIT.Bits.PTIT4
#define PTIT_PTIT5                      _PTIT.Bits.PTIT5
#define PTIT_PTIT6                      _PTIT.Bits.PTIT6
#define PTIT_PTIT7                      _PTIT.Bits.PTIT7

#define PTIT_PTIT0_MASK                 1U
#define PTIT_PTIT1_MASK                 2U
#define PTIT_PTIT2_MASK                 4U
#define PTIT_PTIT3_MASK                 8U
#define PTIT_PTIT4_MASK                 16U
#define PTIT_PTIT5_MASK                 32U
#define PTIT_PTIT6_MASK                 64U
#define PTIT_PTIT7_MASK                 128U


/*** DDRT - Port T Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Port T data direction bit 0 */
    byte DDRT1       :1;                                       /* Port T data direction bit 1 */
    byte DDRT2       :1;                                       /* Port T data direction bit 2 */
    byte DDRT3       :1;                                       /* Port T data direction bit 3 */
    byte DDRT4       :1;                                       /* Port T data direction bit 4 */
    byte DDRT5       :1;                                       /* Port T data direction bit 5 */
    byte DDRT6       :1;                                       /* Port T data direction bit 6 */
    byte DDRT7       :1;                                       /* Port T data direction bit 7 */
  } Bits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000242UL);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT4                      _DDRT.Bits.DDRT4
#define DDRT_DDRT5                      _DDRT.Bits.DDRT5
#define DDRT_DDRT6                      _DDRT.Bits.DDRT6
#define DDRT_DDRT7                      _DDRT.Bits.DDRT7

#define DDRT_DDRT0_MASK                 1U
#define DDRT_DDRT1_MASK                 2U
#define DDRT_DDRT2_MASK                 4U
#define DDRT_DDRT3_MASK                 8U
#define DDRT_DDRT4_MASK                 16U
#define DDRT_DDRT5_MASK                 32U
#define DDRT_DDRT6_MASK                 64U
#define DDRT_DDRT7_MASK                 128U


/*** RDRT - Port T Reduced Drive Register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRT0       :1;                                       /* Port T reduced drive bit 0 */
    byte RDRT1       :1;                                       /* Port T reduced drive bit 1 */
    byte RDRT2       :1;                                       /* Port T reduced drive bit 2 */
    byte RDRT3       :1;                                       /* Port T reduced drive bit 3 */
    byte RDRT4       :1;                                       /* Port T reduced drive bit 4 */
    byte RDRT5       :1;                                       /* Port T reduced drive bit 5 */
    byte RDRT6       :1;                                       /* Port T reduced drive bit 6 */
    byte RDRT7       :1;                                       /* Port T reduced drive bit 7 */
  } Bits;
} RDRTSTR;
extern volatile RDRTSTR _RDRT @(REG_BASE + 0x00000243UL);
#define RDRT                            _RDRT.Byte
#define RDRT_RDRT0                      _RDRT.Bits.RDRT0
#define RDRT_RDRT1                      _RDRT.Bits.RDRT1
#define RDRT_RDRT2                      _RDRT.Bits.RDRT2
#define RDRT_RDRT3                      _RDRT.Bits.RDRT3
#define RDRT_RDRT4                      _RDRT.Bits.RDRT4
#define RDRT_RDRT5                      _RDRT.Bits.RDRT5
#define RDRT_RDRT6                      _RDRT.Bits.RDRT6
#define RDRT_RDRT7                      _RDRT.Bits.RDRT7

#define RDRT_RDRT0_MASK                 1U
#define RDRT_RDRT1_MASK                 2U
#define RDRT_RDRT2_MASK                 4U
#define RDRT_RDRT3_MASK                 8U
#define RDRT_RDRT4_MASK                 16U
#define RDRT_RDRT5_MASK                 32U
#define RDRT_RDRT6_MASK                 64U
#define RDRT_RDRT7_MASK                 128U


/*** PERT - Port T Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Port T pull device enable bit 0 */
    byte PERT1       :1;                                       /* Port T pull device enable bit 1 */
    byte PERT2       :1;                                       /* Port T pull device enable bit 2 */
    byte PERT3       :1;                                       /* Port T pull device enable bit 3 */
    byte PERT4       :1;                                       /* Port T pull device enable bit 4 */
    byte PERT5       :1;                                       /* Port T pull device enable bit 5 */
    byte PERT6       :1;                                       /* Port T pull device enable bit 6 */
    byte PERT7       :1;                                       /* Port T pull device enable bit 7 */
  } Bits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000244UL);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT4                      _PERT.Bits.PERT4
#define PERT_PERT5                      _PERT.Bits.PERT5
#define PERT_PERT6                      _PERT.Bits.PERT6
#define PERT_PERT7                      _PERT.Bits.PERT7

#define PERT_PERT0_MASK                 1U
#define PERT_PERT1_MASK                 2U
#define PERT_PERT2_MASK                 4U
#define PERT_PERT3_MASK                 8U
#define PERT_PERT4_MASK                 16U
#define PERT_PERT5_MASK                 32U
#define PERT_PERT6_MASK                 64U
#define PERT_PERT7_MASK                 128U


/*** PPST - Port T Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Port T pull device select bit 0 */
    byte PPST1       :1;                                       /* Port T pull device select bit 1 */
    byte PPST2       :1;                                       /* Port T pull device select bit 2 */
    byte PPST3       :1;                                       /* Port T pull device select bit 3 */
    byte PPST4       :1;                                       /* Port T pull device select bit 4 */
    byte PPST5       :1;                                       /* Port T pull device select bit 5 */
    byte PPST6       :1;                                       /* Port T pull device select bit 6 */
    byte PPST7       :1;                                       /* Port T pull device select bit 7 */
  } Bits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000245UL);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST4                      _PPST.Bits.PPST4
#define PPST_PPST5                      _PPST.Bits.PPST5
#define PPST_PPST6                      _PPST.Bits.PPST6
#define PPST_PPST7                      _PPST.Bits.PPST7

#define PPST_PPST0_MASK                 1U
#define PPST_PPST1_MASK                 2U
#define PPST_PPST2_MASK                 4U
#define PPST_PPST3_MASK                 8U
#define PPST_PPST4_MASK                 16U
#define PPST_PPST5_MASK                 32U
#define PPST_PPST6_MASK                 64U
#define PPST_PPST7_MASK                 128U


/*** PTS - Port S Data Register; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S general purpose input/output data bit 0 */
    byte PTS1        :1;                                       /* Port S general purpose input/output data bit 1 */
    byte PTS2        :1;                                       /* Port S general purpose input/output data bit 2 */
    byte PTS3        :1;                                       /* Port S general purpose input/output data bit 3 */
    byte PTS4        :1;                                       /* Port S general purpose input/output data bit 4 */
    byte PTS5        :1;                                       /* Port S general purpose input/output data bit 5 */
    byte PTS6        :1;                                       /* Port S general purpose input/output data bit 6 */
    byte PTS7        :1;                                       /* Port S general purpose input/output data bit 7 */
  } Bits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000248UL);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS2                        _PTS.Bits.PTS2
#define PTS_PTS3                        _PTS.Bits.PTS3
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS7                        _PTS.Bits.PTS7

#define PTS_PTS0_MASK                   1U
#define PTS_PTS1_MASK                   2U
#define PTS_PTS2_MASK                   4U
#define PTS_PTS3_MASK                   8U
#define PTS_PTS4_MASK                   16U
#define PTS_PTS5_MASK                   32U
#define PTS_PTS6_MASK                   64U
#define PTS_PTS7_MASK                   128U


/*** PTIS - Port S Input Register; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S input data bit 0 */
    byte PTIS1       :1;                                       /* Port S input data bit 1 */
    byte PTIS2       :1;                                       /* Port S input data bit 2 */
    byte PTIS3       :1;                                       /* Port S input data bit 3 */
    byte PTIS4       :1;                                       /* Port S input data bit 4 */
    byte PTIS5       :1;                                       /* Port S input data bit 5 */
    byte PTIS6       :1;                                       /* Port S input data bit 6 */
    byte PTIS7       :1;                                       /* Port S input data bit 7 */
  } Bits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000249UL);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS2                      _PTIS.Bits.PTIS2
#define PTIS_PTIS3                      _PTIS.Bits.PTIS3
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS7                      _PTIS.Bits.PTIS7

#define PTIS_PTIS0_MASK                 1U
#define PTIS_PTIS1_MASK                 2U
#define PTIS_PTIS2_MASK                 4U
#define PTIS_PTIS3_MASK                 8U
#define PTIS_PTIS4_MASK                 16U
#define PTIS_PTIS5_MASK                 32U
#define PTIS_PTIS6_MASK                 64U
#define PTIS_PTIS7_MASK                 128U


/*** DDRS - Port S Data Direction Register; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Port S data direction bit 0 */
    byte DDRS1       :1;                                       /* Port S data direction bit 1 */
    byte DDRS2       :1;                                       /* Port S data direction bit 2 */
    byte DDRS3       :1;                                       /* Port S data direction bit 3 */
    byte DDRS4       :1;                                       /* Port S data direction bit 4 */
    byte DDRS5       :1;                                       /* Port S data direction bit 5 */
    byte DDRS6       :1;                                       /* Port S data direction bit 6 */
    byte DDRS7       :1;                                       /* Port S data direction bit 7 */
  } Bits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x0000024AUL);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS2                      _DDRS.Bits.DDRS2
#define DDRS_DDRS3                      _DDRS.Bits.DDRS3
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS7                      _DDRS.Bits.DDRS7

#define DDRS_DDRS0_MASK                 1U
#define DDRS_DDRS1_MASK                 2U
#define DDRS_DDRS2_MASK                 4U
#define DDRS_DDRS3_MASK                 8U
#define DDRS_DDRS4_MASK                 16U
#define DDRS_DDRS5_MASK                 32U
#define DDRS_DDRS6_MASK                 64U
#define DDRS_DDRS7_MASK                 128U


/*** RDRS - Port S Reduced Drive Register; 0x0000024B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRS0       :1;                                       /* Port S reduced drive bit 0 */
    byte RDRS1       :1;                                       /* Port S reduced drive bit 1 */
    byte RDRS2       :1;                                       /* Port S reduced drive bit 2 */
    byte RDRS3       :1;                                       /* Port S reduced drive bit 3 */
    byte RDRS4       :1;                                       /* Port S reduced drive bit 4 */
    byte RDRS5       :1;                                       /* Port S reduced drive bit 5 */
    byte RDRS6       :1;                                       /* Port S reduced drive bit 6 */
    byte RDRS7       :1;                                       /* Port S reduced drive bit 7 */
  } Bits;
} RDRSSTR;
extern volatile RDRSSTR _RDRS @(REG_BASE + 0x0000024BUL);
#define RDRS                            _RDRS.Byte
#define RDRS_RDRS0                      _RDRS.Bits.RDRS0
#define RDRS_RDRS1                      _RDRS.Bits.RDRS1
#define RDRS_RDRS2                      _RDRS.Bits.RDRS2
#define RDRS_RDRS3                      _RDRS.Bits.RDRS3
#define RDRS_RDRS4                      _RDRS.Bits.RDRS4
#define RDRS_RDRS5                      _RDRS.Bits.RDRS5
#define RDRS_RDRS6                      _RDRS.Bits.RDRS6
#define RDRS_RDRS7                      _RDRS.Bits.RDRS7

#define RDRS_RDRS0_MASK                 1U
#define RDRS_RDRS1_MASK                 2U
#define RDRS_RDRS2_MASK                 4U
#define RDRS_RDRS3_MASK                 8U
#define RDRS_RDRS4_MASK                 16U
#define RDRS_RDRS5_MASK                 32U
#define RDRS_RDRS6_MASK                 64U
#define RDRS_RDRS7_MASK                 128U


/*** PERS - Port S Pull Device Enable Register; 0x0000024C ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Port S pull device enable bit 0 */
    byte PERS1       :1;                                       /* Port S pull device enable bit 1 */
    byte PERS2       :1;                                       /* Port S pull device enable bit 2 */
    byte PERS3       :1;                                       /* Port S pull device enable bit 3 */
    byte PERS4       :1;                                       /* Port S pull device enable bit 4 */
    byte PERS5       :1;                                       /* Port S pull device enable bit 5 */
    byte PERS6       :1;                                       /* Port S pull device enable bit 6 */
    byte PERS7       :1;                                       /* Port S pull device enable bit 7 */
  } Bits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x0000024CUL);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS2                      _PERS.Bits.PERS2
#define PERS_PERS3                      _PERS.Bits.PERS3
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS7                      _PERS.Bits.PERS7

#define PERS_PERS0_MASK                 1U
#define PERS_PERS1_MASK                 2U
#define PERS_PERS2_MASK                 4U
#define PERS_PERS3_MASK                 8U
#define PERS_PERS4_MASK                 16U
#define PERS_PERS5_MASK                 32U
#define PERS_PERS6_MASK                 64U
#define PERS_PERS7_MASK                 128U


/*** PPSS - Port S Polarity Select Register; 0x0000024D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Port S pull device select bit 0 */
    byte PPSS1       :1;                                       /* Port S pull device select bit 1 */
    byte PPSS2       :1;                                       /* Port S pull device select bit 2 */
    byte PPSS3       :1;                                       /* Port S pull device select bit 3 */
    byte PPSS4       :1;                                       /* Port S pull device select bit 4 */
    byte PPSS5       :1;                                       /* Port S pull device select bit 5 */
    byte PPSS6       :1;                                       /* Port S pull device select bit 6 */
    byte PPSS7       :1;                                       /* Port S pull device select bit 7 */
  } Bits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x0000024DUL);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS2                      _PPSS.Bits.PPSS2
#define PPSS_PPSS3                      _PPSS.Bits.PPSS3
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS7                      _PPSS.Bits.PPSS7

#define PPSS_PPSS0_MASK                 1U
#define PPSS_PPSS1_MASK                 2U
#define PPSS_PPSS2_MASK                 4U
#define PPSS_PPSS3_MASK                 8U
#define PPSS_PPSS4_MASK                 16U
#define PPSS_PPSS5_MASK                 32U
#define PPSS_PPSS6_MASK                 64U
#define PPSS_PPSS7_MASK                 128U


/*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMS0       :1;                                       /* Port S wired-or mode bit 0 */
    byte WOMS1       :1;                                       /* Port S wired-or mode bit 1 */
    byte WOMS2       :1;                                       /* Port S wired-or mode bit 2 */
    byte WOMS3       :1;                                       /* Port S wired-or mode bit 3 */
    byte WOMS4       :1;                                       /* Port S wired-or mode bit 4 */
    byte WOMS5       :1;                                       /* Port S wired-or mode bit 5 */
    byte WOMS6       :1;                                       /* Port S wired-or mode bit 6 */
    byte WOMS7       :1;                                       /* Port S wired-or mode bit 7 */
  } Bits;
} WOMSSTR;
extern volatile WOMSSTR _WOMS @(REG_BASE + 0x0000024EUL);
#define WOMS                            _WOMS.Byte
#define WOMS_WOMS0                      _WOMS.Bits.WOMS0
#define WOMS_WOMS1                      _WOMS.Bits.WOMS1
#define WOMS_WOMS2                      _WOMS.Bits.WOMS2
#define WOMS_WOMS3                      _WOMS.Bits.WOMS3
#define WOMS_WOMS4                      _WOMS.Bits.WOMS4
#define WOMS_WOMS5                      _WOMS.Bits.WOMS5
#define WOMS_WOMS6                      _WOMS.Bits.WOMS6
#define WOMS_WOMS7                      _WOMS.Bits.WOMS7

#define WOMS_WOMS0_MASK                 1U
#define WOMS_WOMS1_MASK                 2U
#define WOMS_WOMS2_MASK                 4U
#define WOMS_WOMS3_MASK                 8U
#define WOMS_WOMS4_MASK                 16U
#define WOMS_WOMS5_MASK                 32U
#define WOMS_WOMS6_MASK                 64U
#define WOMS_WOMS7_MASK                 128U


/*** PTM - Port M Data Register; 0x00000250 ***/
typedef union {
  byte Byte;
  struct {
    byte PTM0        :1;                                       /* Port M general purpose input/output data bit 0 */
    byte PTM1        :1;                                       /* Port M general purpose input/output data bit 1 */
    byte PTM2        :1;                                       /* Port M general purpose input/output data bit 2 */
    byte PTM3        :1;                                       /* Port M general purpose input/output data bit 3 */
    byte PTM4        :1;                                       /* Port M general purpose input/output data bit 4 */
    byte PTM5        :1;                                       /* Port M general purpose input/output data bit 5 */
    byte PTM6        :1;                                       /* Port M general purpose input/output data bit 6 */
    byte PTM7        :1;                                       /* Port M general purpose input/output data bit 7 */
  } Bits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000250UL);
#define PTM                             _PTM.Byte
#define PTM_PTM0                        _PTM.Bits.PTM0
#define PTM_PTM1                        _PTM.Bits.PTM1
#define PTM_PTM2                        _PTM.Bits.PTM2
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM4                        _PTM.Bits.PTM4
#define PTM_PTM5                        _PTM.Bits.PTM5
#define PTM_PTM6                        _PTM.Bits.PTM6
#define PTM_PTM7                        _PTM.Bits.PTM7

#define PTM_PTM0_MASK                   1U
#define PTM_PTM1_MASK                   2U
#define PTM_PTM2_MASK                   4U
#define PTM_PTM3_MASK                   8U
#define PTM_PTM4_MASK                   16U
#define PTM_PTM5_MASK                   32U
#define PTM_PTM6_MASK                   64U
#define PTM_PTM7_MASK                   128U


/*** PTIM - Port M Input Register; 0x00000251 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIM0       :1;                                       /* Port M input data bit 0 */
    byte PTIM1       :1;                                       /* Port M input data bit 1 */
    byte PTIM2       :1;                                       /* Port M input data bit 2 */
    byte PTIM3       :1;                                       /* Port M input data bit 3 */
    byte PTIM4       :1;                                       /* Port M input data bit 4 */
    byte PTIM5       :1;                                       /* Port M input data bit 5 */
    byte PTIM6       :1;                                       /* Port M input data bit 6 */
    byte PTIM7       :1;                                       /* Port M input data bit 7 */
  } Bits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000251UL);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM0                      _PTIM.Bits.PTIM0
#define PTIM_PTIM1                      _PTIM.Bits.PTIM1
#define PTIM_PTIM2                      _PTIM.Bits.PTIM2
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM4                      _PTIM.Bits.PTIM4
#define PTIM_PTIM5                      _PTIM.Bits.PTIM5
#define PTIM_PTIM6                      _PTIM.Bits.PTIM6
#define PTIM_PTIM7                      _PTIM.Bits.PTIM7

#define PTIM_PTIM0_MASK                 1U
#define PTIM_PTIM1_MASK                 2U
#define PTIM_PTIM2_MASK                 4U
#define PTIM_PTIM3_MASK                 8U
#define PTIM_PTIM4_MASK                 16U
#define PTIM_PTIM5_MASK                 32U
#define PTIM_PTIM6_MASK                 64U
#define PTIM_PTIM7_MASK                 128U


/*** DDRM - Port M Data Direction Register; 0x00000252 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRM0       :1;                                       /* Port M data direction bit 0 */
    byte DDRM1       :1;                                       /* Port M data direction bit 1 */
    byte DDRM2       :1;                                       /* Port M data direction bit 2 */
    byte DDRM3       :1;                                       /* Port M data direction bit 3 */
    byte DDRM4       :1;                                       /* Port M data direction bit 4 */
    byte DDRM5       :1;                                       /* Port M data direction bit 5 */
    byte DDRM6       :1;                                       /* Port M data direction bit 6 */
    byte DDRM7       :1;                                       /* Port M data direction bit 7 */
  } Bits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x00000252UL);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM0                      _DDRM.Bits.DDRM0
#define DDRM_DDRM1                      _DDRM.Bits.DDRM1
#define DDRM_DDRM2                      _DDRM.Bits.DDRM2
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM4                      _DDRM.Bits.DDRM4
#define DDRM_DDRM5                      _DDRM.Bits.DDRM5
#define DDRM_DDRM6                      _DDRM.Bits.DDRM6
#define DDRM_DDRM7                      _DDRM.Bits.DDRM7

#define DDRM_DDRM0_MASK                 1U
#define DDRM_DDRM1_MASK                 2U
#define DDRM_DDRM2_MASK                 4U
#define DDRM_DDRM3_MASK                 8U
#define DDRM_DDRM4_MASK                 16U
#define DDRM_DDRM5_MASK                 32U
#define DDRM_DDRM6_MASK                 64U
#define DDRM_DDRM7_MASK                 128U


/*** RDRM - Port M Reduced Drive Register; 0x00000253 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRM0       :1;                                       /* Port M reduced drive bit 0 */
    byte RDRM1       :1;                                       /* Port M reduced drive bit 1 */
    byte RDRM2       :1;                                       /* Port M reduced drive bit 2 */
    byte RDRM3       :1;                                       /* Port M reduced drive bit 3 */
    byte RDRM4       :1;                                       /* Port M reduced drive bit 4 */
    byte RDRM5       :1;                                       /* Port M reduced drive bit 5 */
    byte RDRM6       :1;                                       /* Port M reduced drive bit 6 */
    byte RDRM7       :1;                                       /* Port M reduced drive bit 7 */
  } Bits;
} RDRMSTR;
extern volatile RDRMSTR _RDRM @(REG_BASE + 0x00000253UL);
#define RDRM                            _RDRM.Byte
#define RDRM_RDRM0                      _RDRM.Bits.RDRM0
#define RDRM_RDRM1                      _RDRM.Bits.RDRM1
#define RDRM_RDRM2                      _RDRM.Bits.RDRM2
#define RDRM_RDRM3                      _RDRM.Bits.RDRM3
#define RDRM_RDRM4                      _RDRM.Bits.RDRM4
#define RDRM_RDRM5                      _RDRM.Bits.RDRM5
#define RDRM_RDRM6                      _RDRM.Bits.RDRM6
#define RDRM_RDRM7                      _RDRM.Bits.RDRM7

#define RDRM_RDRM0_MASK                 1U
#define RDRM_RDRM1_MASK                 2U
#define RDRM_RDRM2_MASK                 4U
#define RDRM_RDRM3_MASK                 8U
#define RDRM_RDRM4_MASK                 16U
#define RDRM_RDRM5_MASK                 32U
#define RDRM_RDRM6_MASK                 64U
#define RDRM_RDRM7_MASK                 128U


/*** PERM - Port M Pull Device Enable Register; 0x00000254 ***/
typedef union {
  byte Byte;
  struct {
    byte PERM0       :1;                                       /* Port M pull device enable bit 0 */
    byte PERM1       :1;                                       /* Port M pull device enable bit 1 */
    byte PERM2       :1;                                       /* Port M pull device enable bit 2 */
    byte PERM3       :1;                                       /* Port M pull device enable bit 3 */
    byte PERM4       :1;                                       /* Port M pull device enable bit 4 */
    byte PERM5       :1;                                       /* Port M pull device enable bit 5 */
    byte PERM6       :1;                                       /* Port M pull device enable bit 6 */
    byte PERM7       :1;                                       /* Port M pull device enable bit 7 */
  } Bits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x00000254UL);
#define PERM                            _PERM.Byte
#define PERM_PERM0                      _PERM.Bits.PERM0
#define PERM_PERM1                      _PERM.Bits.PERM1
#define PERM_PERM2                      _PERM.Bits.PERM2
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM4                      _PERM.Bits.PERM4
#define PERM_PERM5                      _PERM.Bits.PERM5
#define PERM_PERM6                      _PERM.Bits.PERM6
#define PERM_PERM7                      _PERM.Bits.PERM7

#define PERM_PERM0_MASK                 1U
#define PERM_PERM1_MASK                 2U
#define PERM_PERM2_MASK                 4U
#define PERM_PERM3_MASK                 8U
#define PERM_PERM4_MASK                 16U
#define PERM_PERM5_MASK                 32U
#define PERM_PERM6_MASK                 64U
#define PERM_PERM7_MASK                 128U


/*** PPSM - Port M Polarity Select Register; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSM0       :1;                                       /* Port M pull device select bit 0 */
    byte PPSM1       :1;                                       /* Port M pull device select bit 1 */
    byte PPSM2       :1;                                       /* Port M pull device select bit 2 */
    byte PPSM3       :1;                                       /* Port M pull device select bit 3 */
    byte PPSM4       :1;                                       /* Port M pull device select bit 4 */
    byte PPSM5       :1;                                       /* Port M pull device select bit 5 */
    byte PPSM6       :1;                                       /* Port M pull device select bit 6 */
    byte PPSM7       :1;                                       /* Port M pull device select bit 7 */
  } Bits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x00000255UL);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM0                      _PPSM.Bits.PPSM0
#define PPSM_PPSM1                      _PPSM.Bits.PPSM1
#define PPSM_PPSM2                      _PPSM.Bits.PPSM2
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM4                      _PPSM.Bits.PPSM4
#define PPSM_PPSM5                      _PPSM.Bits.PPSM5
#define PPSM_PPSM6                      _PPSM.Bits.PPSM6
#define PPSM_PPSM7                      _PPSM.Bits.PPSM7

#define PPSM_PPSM0_MASK                 1U
#define PPSM_PPSM1_MASK                 2U
#define PPSM_PPSM2_MASK                 4U
#define PPSM_PPSM3_MASK                 8U
#define PPSM_PPSM4_MASK                 16U
#define PPSM_PPSM5_MASK                 32U
#define PPSM_PPSM6_MASK                 64U
#define PPSM_PPSM7_MASK                 128U


/*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***/
typedef union {
  byte Byte;
  struct {
    byte WOMM0       :1;                                       /* Port M wired-or mode bit 0 */
    byte WOMM1       :1;                                       /* Port M wired-or mode bit 1 */
    byte WOMM2       :1;                                       /* Port M wired-or mode bit 2 */
    byte WOMM3       :1;                                       /* Port M wired-or mode bit 3 */
    byte WOMM4       :1;                                       /* Port M wired-or mode bit 4 */
    byte WOMM5       :1;                                       /* Port M wired-or mode bit 5 */
    byte WOMM6       :1;                                       /* Port M wired-or mode bit 6 */
    byte WOMM7       :1;                                       /* Port M wired-or mode bit 7 */
  } Bits;
} WOMMSTR;
extern volatile WOMMSTR _WOMM @(REG_BASE + 0x00000256UL);
#define WOMM                            _WOMM.Byte
#define WOMM_WOMM0                      _WOMM.Bits.WOMM0
#define WOMM_WOMM1                      _WOMM.Bits.WOMM1
#define WOMM_WOMM2                      _WOMM.Bits.WOMM2
#define WOMM_WOMM3                      _WOMM.Bits.WOMM3
#define WOMM_WOMM4                      _WOMM.Bits.WOMM4
#define WOMM_WOMM5                      _WOMM.Bits.WOMM5
#define WOMM_WOMM6                      _WOMM.Bits.WOMM6
#define WOMM_WOMM7                      _WOMM.Bits.WOMM7

#define WOMM_WOMM0_MASK                 1U
#define WOMM_WOMM1_MASK                 2U
#define WOMM_WOMM2_MASK                 4U
#define WOMM_WOMM3_MASK                 8U
#define WOMM_WOMM4_MASK                 16U
#define WOMM_WOMM5_MASK                 32U
#define WOMM_WOMM6_MASK                 64U
#define WOMM_WOMM7_MASK                 128U


/*** MODRR - Module Routing Register; 0x00000257 ***/
typedef union {
  byte Byte;
  struct {
    byte MODRR0      :1;                                       /* Module Routing bit 0 */
    byte MODRR1      :1;                                       /* Module Routing bit 1 */
    byte MODRR2      :1;                                       /* Module Routing bit 2 */
    byte MODRR3      :1;                                       /* Module Routing bit 3 */
    byte MODRR4      :1;                                       /* Module Routing bit 4 */
    byte MODRR5      :1;                                       /* Module Routing bit 5 */
    byte MODRR6      :1;                                       /* Module Routing bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpMODRR :7;
    byte         :1;
  } MergedBits;
} MODRRSTR;
extern volatile MODRRSTR _MODRR @(REG_BASE + 0x00000257UL);
#define MODRR                           _MODRR.Byte
#define MODRR_MODRR0                    _MODRR.Bits.MODRR0
#define MODRR_MODRR1                    _MODRR.Bits.MODRR1
#define MODRR_MODRR2                    _MODRR.Bits.MODRR2
#define MODRR_MODRR3                    _MODRR.Bits.MODRR3
#define MODRR_MODRR4                    _MODRR.Bits.MODRR4
#define MODRR_MODRR5                    _MODRR.Bits.MODRR5
#define MODRR_MODRR6                    _MODRR.Bits.MODRR6
#define MODRR_MODRR                     _MODRR.MergedBits.grpMODRR

#define MODRR_MODRR0_MASK               1U
#define MODRR_MODRR1_MASK               2U
#define MODRR_MODRR2_MASK               4U
#define MODRR_MODRR3_MASK               8U
#define MODRR_MODRR4_MASK               16U
#define MODRR_MODRR5_MASK               32U
#define MODRR_MODRR6_MASK               64U
#define MODRR_MODRR_MASK                127U
#define MODRR_MODRR_BITNUM              0U


/*** PTP - Port P Data Register; 0x00000258 ***/
typedef union {
  byte Byte;
  struct {
    byte PTP0        :1;                                       /* Port P general purpose input/output data bit 0 */
    byte PTP1        :1;                                       /* Port P general purpose input/output data bit 1 */
    byte PTP2        :1;                                       /* Port P general purpose input/output data bit 2 */
    byte PTP3        :1;                                       /* Port P general purpose input/output data bit 3 */
    byte PTP4        :1;                                       /* Port P general purpose input/output data bit 4 */
    byte PTP5        :1;                                       /* Port P general purpose input/output data bit 5 */
    byte PTP6        :1;                                       /* Port P general purpose input/output data bit 6 */
    byte PTP7        :1;                                       /* Port P general purpose input/output data bit 7 */
  } Bits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000258UL);
#define PTP                             _PTP.Byte
#define PTP_PTP0                        _PTP.Bits.PTP0
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP2                        _PTP.Bits.PTP2
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP6                        _PTP.Bits.PTP6
#define PTP_PTP7                        _PTP.Bits.PTP7

#define PTP_PTP0_MASK                   1U
#define PTP_PTP1_MASK                   2U
#define PTP_PTP2_MASK                   4U
#define PTP_PTP3_MASK                   8U
#define PTP_PTP4_MASK                   16U
#define PTP_PTP5_MASK                   32U
#define PTP_PTP6_MASK                   64U
#define PTP_PTP7_MASK                   128U


/*** PTIP - Port P Input Register; 0x00000259 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIP0       :1;                                       /* Port P input data bit 0 */
    byte PTIP1       :1;                                       /* Port P input data bit 1 */
    byte PTIP2       :1;                                       /* Port P input data bit 2 */
    byte PTIP3       :1;                                       /* Port P input data bit 3 */
    byte PTIP4       :1;                                       /* Port P input data bit 4 */
    byte PTIP5       :1;                                       /* Port P input data bit 5 */
    byte PTIP6       :1;                                       /* Port P input data bit 6 */
    byte PTIP7       :1;                                       /* Port P input data bit 7 */
  } Bits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000259UL);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP0                      _PTIP.Bits.PTIP0
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP2                      _PTIP.Bits.PTIP2
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP6                      _PTIP.Bits.PTIP6
#define PTIP_PTIP7                      _PTIP.Bits.PTIP7

#define PTIP_PTIP0_MASK                 1U
#define PTIP_PTIP1_MASK                 2U
#define PTIP_PTIP2_MASK                 4U
#define PTIP_PTIP3_MASK                 8U
#define PTIP_PTIP4_MASK                 16U
#define PTIP_PTIP5_MASK                 32U
#define PTIP_PTIP6_MASK                 64U
#define PTIP_PTIP7_MASK                 128U


/*** DDRP - Port P Data Direction Register; 0x0000025A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRP0       :1;                                       /* Port P data direction bit 0 */
    byte DDRP1       :1;                                       /* Port P data direction bit 1 */
    byte DDRP2       :1;                                       /* Port P data direction bit 2 */
    byte DDRP3       :1;                                       /* Port P data direction bit 3 */
    byte DDRP4       :1;                                       /* Port P data direction bit 4 */
    byte DDRP5       :1;                                       /* Port P data direction bit 5 */
    byte DDRP6       :1;                                       /* Port P data direction bit 6 */
    byte DDRP7       :1;                                       /* Port P data direction bit 7 */
  } Bits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000025AUL);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP0                      _DDRP.Bits.DDRP0
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP2                      _DDRP.Bits.DDRP2
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP6                      _DDRP.Bits.DDRP6
#define DDRP_DDRP7                      _DDRP.Bits.DDRP7

#define DDRP_DDRP0_MASK                 1U
#define DDRP_DDRP1_MASK                 2U
#define DDRP_DDRP2_MASK                 4U
#define DDRP_DDRP3_MASK                 8U
#define DDRP_DDRP4_MASK                 16U
#define DDRP_DDRP5_MASK                 32U
#define DDRP_DDRP6_MASK                 64U
#define DDRP_DDRP7_MASK                 128U


/*** RDRP - Port P Reduced Drive Register; 0x0000025B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRP0       :1;                                       /* Port P reduced drive bit 0 */
    byte RDRP1       :1;                                       /* Port P reduced drive bit 1 */
    byte RDRP2       :1;                                       /* Port P reduced drive bit 2 */
    byte RDRP3       :1;                                       /* Port P reduced drive bit 3 */
    byte RDRP4       :1;                                       /* Port P reduced drive bit 4 */
    byte RDRP5       :1;                                       /* Port P reduced drive bit 5 */
    byte RDRP6       :1;                                       /* Port P reduced drive bit 6 */
    byte RDRP7       :1;                                       /* Port P reduced drive bit 7 */
  } Bits;
} RDRPSTR;
extern volatile RDRPSTR _RDRP @(REG_BASE + 0x0000025BUL);
#define RDRP                            _RDRP.Byte
#define RDRP_RDRP0                      _RDRP.Bits.RDRP0
#define RDRP_RDRP1                      _RDRP.Bits.RDRP1
#define RDRP_RDRP2                      _RDRP.Bits.RDRP2
#define RDRP_RDRP3                      _RDRP.Bits.RDRP3
#define RDRP_RDRP4                      _RDRP.Bits.RDRP4
#define RDRP_RDRP5                      _RDRP.Bits.RDRP5
#define RDRP_RDRP6                      _RDRP.Bits.RDRP6
#define RDRP_RDRP7                      _RDRP.Bits.RDRP7

#define RDRP_RDRP0_MASK                 1U
#define RDRP_RDRP1_MASK                 2U
#define RDRP_RDRP2_MASK                 4U
#define RDRP_RDRP3_MASK                 8U
#define RDRP_RDRP4_MASK                 16U
#define RDRP_RDRP5_MASK                 32U
#define RDRP_RDRP6_MASK                 64U
#define RDRP_RDRP7_MASK                 128U


/*** PERP - Port P Pull Device Enable Register; 0x0000025C ***/
typedef union {
  byte Byte;
  struct {
    byte PERP0       :1;                                       /* Port P pull device enable bit 0 */
    byte PERP1       :1;                                       /* Port P pull device enable bit 1 */
    byte PERP2       :1;                                       /* Port P pull device enable bit 2 */
    byte PERP3       :1;                                       /* Port P pull device enable bit 3 */
    byte PERP4       :1;                                       /* Port P pull device enable bit 4 */
    byte PERP5       :1;                                       /* Port P pull device enable bit 5 */
    byte PERP6       :1;                                       /* Port P pull device enable bit 6 */
    byte PERP7       :1;                                       /* Port P pull device enable bit 7 */
  } Bits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000025CUL);
#define PERP                            _PERP.Byte
#define PERP_PERP0                      _PERP.Bits.PERP0
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP2                      _PERP.Bits.PERP2
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP6                      _PERP.Bits.PERP6
#define PERP_PERP7                      _PERP.Bits.PERP7

#define PERP_PERP0_MASK                 1U
#define PERP_PERP1_MASK                 2U
#define PERP_PERP2_MASK                 4U
#define PERP_PERP3_MASK                 8U
#define PERP_PERP4_MASK                 16U
#define PERP_PERP5_MASK                 32U
#define PERP_PERP6_MASK                 64U
#define PERP_PERP7_MASK                 128U


/*** PPSP - Port P Polarity Select Register; 0x0000025D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSP0       :1;                                       /* Port P pull device select bit 0 */
    byte PPSP1       :1;                                       /* Port P pull device select bit 1 */
    byte PPSP2       :1;                                       /* Port P pull device select bit 2 */
    byte PPSP3       :1;                                       /* Port P pull device select bit 3 */
    byte PPSP4       :1;                                       /* Port P pull device select bit 4 */
    byte PPSP5       :1;                                       /* Port P pull device select bit 5 */
    byte PPSP6       :1;                                       /* Port P pull device select bit 6 */
    byte PPSP7       :1;                                       /* Port P pull device select bit 7 */
  } Bits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000025DUL);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP0                      _PPSP.Bits.PPSP0
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP2                      _PPSP.Bits.PPSP2
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP6                      _PPSP.Bits.PPSP6
#define PPSP_PPSP7                      _PPSP.Bits.PPSP7

#define PPSP_PPSP0_MASK                 1U
#define PPSP_PPSP1_MASK                 2U
#define PPSP_PPSP2_MASK                 4U
#define PPSP_PPSP3_MASK                 8U
#define PPSP_PPSP4_MASK                 16U
#define PPSP_PPSP5_MASK                 32U
#define PPSP_PPSP6_MASK                 64U
#define PPSP_PPSP7_MASK                 128U


/*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***/
typedef union {
  byte Byte;
  struct {
    byte PIEP0       :1;                                       /* Port P interrupt enable bit 0 */
    byte PIEP1       :1;                                       /* Port P interrupt enable bit 1 */
    byte PIEP2       :1;                                       /* Port P interrupt enable bit 2 */
    byte PIEP3       :1;                                       /* Port P interrupt enable bit 3 */
    byte PIEP4       :1;                                       /* Port P interrupt enable bit 4 */
    byte PIEP5       :1;                                       /* Port P interrupt enable bit 5 */
    byte PIEP6       :1;                                       /* Port P interrupt enable bit 6 */
    byte PIEP7       :1;                                       /* Port P interrupt enable bit 7 */
  } Bits;
} PIEPSTR;
extern volatile PIEPSTR _PIEP @(REG_BASE + 0x0000025EUL);
#define PIEP                            _PIEP.Byte
#define PIEP_PIEP0                      _PIEP.Bits.PIEP0
#define PIEP_PIEP1                      _PIEP.Bits.PIEP1
#define PIEP_PIEP2                      _PIEP.Bits.PIEP2
#define PIEP_PIEP3                      _PIEP.Bits.PIEP3
#define PIEP_PIEP4                      _PIEP.Bits.PIEP4
#define PIEP_PIEP5                      _PIEP.Bits.PIEP5
#define PIEP_PIEP6                      _PIEP.Bits.PIEP6
#define PIEP_PIEP7                      _PIEP.Bits.PIEP7

#define PIEP_PIEP0_MASK                 1U
#define PIEP_PIEP1_MASK                 2U
#define PIEP_PIEP2_MASK                 4U
#define PIEP_PIEP3_MASK                 8U
#define PIEP_PIEP4_MASK                 16U
#define PIEP_PIEP5_MASK                 32U
#define PIEP_PIEP6_MASK                 64U
#define PIEP_PIEP7_MASK                 128U


/*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***/
typedef union {
  byte Byte;
  struct {
    byte PIFP0       :1;                                       /* Port P interrupt flag bit 0 */
    byte PIFP1       :1;                                       /* Port P interrupt flag bit 1 */
    byte PIFP2       :1;                                       /* Port P interrupt flag bit 2 */
    byte PIFP3       :1;                                       /* Port P interrupt flag bit 3 */
    byte PIFP4       :1;                                       /* Port P interrupt flag bit 4 */
    byte PIFP5       :1;                                       /* Port P interrupt flag bit 5 */
    byte PIFP6       :1;                                       /* Port P interrupt flag bit 6 */
    byte PIFP7       :1;                                       /* Port P interrupt flag bit 7 */
  } Bits;
} PIFPSTR;
extern volatile PIFPSTR _PIFP @(REG_BASE + 0x0000025FUL);
#define PIFP                            _PIFP.Byte
#define PIFP_PIFP0                      _PIFP.Bits.PIFP0
#define PIFP_PIFP1                      _PIFP.Bits.PIFP1
#define PIFP_PIFP2                      _PIFP.Bits.PIFP2
#define PIFP_PIFP3                      _PIFP.Bits.PIFP3
#define PIFP_PIFP4                      _PIFP.Bits.PIFP4
#define PIFP_PIFP5                      _PIFP.Bits.PIFP5
#define PIFP_PIFP6                      _PIFP.Bits.PIFP6
#define PIFP_PIFP7                      _PIFP.Bits.PIFP7

#define PIFP_PIFP0_MASK                 1U
#define PIFP_PIFP1_MASK                 2U
#define PIFP_PIFP2_MASK                 4U
#define PIFP_PIFP3_MASK                 8U
#define PIFP_PIFP4_MASK                 16U
#define PIFP_PIFP5_MASK                 32U
#define PIFP_PIFP6_MASK                 64U
#define PIFP_PIFP7_MASK                 128U


/*** PTH - Port H Data Register; 0x00000260 ***/
typedef union {
  byte Byte;
  struct {
    byte PTH0        :1;                                       /* Port H general purpose input/output data bit 0 */
    byte PTH1        :1;                                       /* Port H general purpose input/output data bit 1 */
    byte PTH2        :1;                                       /* Port H general purpose input/output data bit 2 */
    byte PTH3        :1;                                       /* Port H general purpose input/output data bit 3 */
    byte PTH4        :1;                                       /* Port H general purpose input/output data bit 4 */
    byte PTH5        :1;                                       /* Port H general purpose input/output data bit 5 */
    byte PTH6        :1;                                       /* Port H general purpose input/output data bit 6 */
    byte PTH7        :1;                                       /* Port H general purpose input/output data bit 7 */
  } Bits;
} PTHSTR;
extern volatile PTHSTR _PTH @(REG_BASE + 0x00000260UL);
#define PTH                             _PTH.Byte
#define PTH_PTH0                        _PTH.Bits.PTH0
#define PTH_PTH1                        _PTH.Bits.PTH1
#define PTH_PTH2                        _PTH.Bits.PTH2
#define PTH_PTH3                        _PTH.Bits.PTH3
#define PTH_PTH4                        _PTH.Bits.PTH4
#define PTH_PTH5                        _PTH.Bits.PTH5
#define PTH_PTH6                        _PTH.Bits.PTH6
#define PTH_PTH7                        _PTH.Bits.PTH7

#define PTH_PTH0_MASK                   1U
#define PTH_PTH1_MASK                   2U
#define PTH_PTH2_MASK                   4U
#define PTH_PTH3_MASK                   8U
#define PTH_PTH4_MASK                   16U
#define PTH_PTH5_MASK                   32U
#define PTH_PTH6_MASK                   64U
#define PTH_PTH7_MASK                   128U


/*** PTIH - Port H Input Register; 0x00000261 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIH0       :1;                                       /* Port H input data bit 0 */
    byte PTIH1       :1;                                       /* Port H input data bit 1 */
    byte PTIH2       :1;                                       /* Port H input data bit 2 */
    byte PTIH3       :1;                                       /* Port H input data bit 3 */
    byte PTIH4       :1;                                       /* Port H input data bit 4 */
    byte PTIH5       :1;                                       /* Port H input data bit 5 */
    byte PTIH6       :1;                                       /* Port H input data bit 6 */
    byte PTIH7       :1;                                       /* Port H input data bit 7 */
  } Bits;
} PTIHSTR;
extern volatile PTIHSTR _PTIH @(REG_BASE + 0x00000261UL);
#define PTIH                            _PTIH.Byte
#define PTIH_PTIH0                      _PTIH.Bits.PTIH0
#define PTIH_PTIH1                      _PTIH.Bits.PTIH1
#define PTIH_PTIH2                      _PTIH.Bits.PTIH2
#define PTIH_PTIH3                      _PTIH.Bits.PTIH3
#define PTIH_PTIH4                      _PTIH.Bits.PTIH4
#define PTIH_PTIH5                      _PTIH.Bits.PTIH5
#define PTIH_PTIH6                      _PTIH.Bits.PTIH6
#define PTIH_PTIH7                      _PTIH.Bits.PTIH7

#define PTIH_PTIH0_MASK                 1U
#define PTIH_PTIH1_MASK                 2U
#define PTIH_PTIH2_MASK                 4U
#define PTIH_PTIH3_MASK                 8U
#define PTIH_PTIH4_MASK                 16U
#define PTIH_PTIH5_MASK                 32U
#define PTIH_PTIH6_MASK                 64U
#define PTIH_PTIH7_MASK                 128U


/*** DDRH - Port H Data Direction Register; 0x00000262 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRH0       :1;                                       /* Port H data direction bit 0 */
    byte DDRH1       :1;                                       /* Port H data direction bit 1 */
    byte DDRH2       :1;                                       /* Port H data direction bit 2 */
    byte DDRH3       :1;                                       /* Port H data direction bit 3 */
    byte DDRH4       :1;                                       /* Port H data direction bit 4 */
    byte DDRH5       :1;                                       /* Port H data direction bit 5 */
    byte DDRH6       :1;                                       /* Port H data direction bit 6 */
    byte DDRH7       :1;                                       /* Port H data direction bit 7 */
  } Bits;
} DDRHSTR;
extern volatile DDRHSTR _DDRH @(REG_BASE + 0x00000262UL);
#define DDRH                            _DDRH.Byte
#define DDRH_DDRH0                      _DDRH.Bits.DDRH0
#define DDRH_DDRH1                      _DDRH.Bits.DDRH1
#define DDRH_DDRH2                      _DDRH.Bits.DDRH2
#define DDRH_DDRH3                      _DDRH.Bits.DDRH3
#define DDRH_DDRH4                      _DDRH.Bits.DDRH4
#define DDRH_DDRH5                      _DDRH.Bits.DDRH5
#define DDRH_DDRH6                      _DDRH.Bits.DDRH6
#define DDRH_DDRH7                      _DDRH.Bits.DDRH7

#define DDRH_DDRH0_MASK                 1U
#define DDRH_DDRH1_MASK                 2U
#define DDRH_DDRH2_MASK                 4U
#define DDRH_DDRH3_MASK                 8U
#define DDRH_DDRH4_MASK                 16U
#define DDRH_DDRH5_MASK                 32U
#define DDRH_DDRH6_MASK                 64U
#define DDRH_DDRH7_MASK                 128U


/*** RDRH - Port H Reduced Drive Register; 0x00000263 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRH0       :1;                                       /* Port H reduced drive bit 0 */
    byte RDRH1       :1;                                       /* Port H reduced drive bit 1 */
    byte RDRH2       :1;                                       /* Port H reduced drive bit 2 */
    byte RDRH3       :1;                                       /* Port H reduced drive bit 3 */
    byte RDRH4       :1;                                       /* Port H reduced drive bit 4 */
    byte RDRH5       :1;                                       /* Port H reduced drive bit 5 */
    byte RDRH6       :1;                                       /* Port H reduced drive bit 6 */
    byte RDRH7       :1;                                       /* Port H reduced drive bit 7 */
  } Bits;
} RDRHSTR;
extern volatile RDRHSTR _RDRH @(REG_BASE + 0x00000263UL);
#define RDRH                            _RDRH.Byte
#define RDRH_RDRH0                      _RDRH.Bits.RDRH0
#define RDRH_RDRH1                      _RDRH.Bits.RDRH1
#define RDRH_RDRH2                      _RDRH.Bits.RDRH2
#define RDRH_RDRH3                      _RDRH.Bits.RDRH3
#define RDRH_RDRH4                      _RDRH.Bits.RDRH4
#define RDRH_RDRH5                      _RDRH.Bits.RDRH5
#define RDRH_RDRH6                      _RDRH.Bits.RDRH6
#define RDRH_RDRH7                      _RDRH.Bits.RDRH7

#define RDRH_RDRH0_MASK                 1U
#define RDRH_RDRH1_MASK                 2U
#define RDRH_RDRH2_MASK                 4U
#define RDRH_RDRH3_MASK                 8U
#define RDRH_RDRH4_MASK                 16U
#define RDRH_RDRH5_MASK                 32U
#define RDRH_RDRH6_MASK                 64U
#define RDRH_RDRH7_MASK                 128U


/*** PERH - Port H Pull Device Enable Register; 0x00000264 ***/
typedef union {
  byte Byte;
  struct {
    byte PERH0       :1;                                       /* Port H pull device enable bit 0 */
    byte PERH1       :1;                                       /* Port H pull device enable bit 1 */
    byte PERH2       :1;                                       /* Port H pull device enable bit 2 */
    byte PERH3       :1;                                       /* Port H pull device enable bit 3 */
    byte PERH4       :1;                                       /* Port H pull device enable bit 4 */
    byte PERH5       :1;                                       /* Port H pull device enable bit 5 */
    byte PERH6       :1;                                       /* Port H pull device enable bit 6 */
    byte PERH7       :1;                                       /* Port H pull device enable bit 7 */
  } Bits;
} PERHSTR;
extern volatile PERHSTR _PERH @(REG_BASE + 0x00000264UL);
#define PERH                            _PERH.Byte
#define PERH_PERH0                      _PERH.Bits.PERH0
#define PERH_PERH1                      _PERH.Bits.PERH1
#define PERH_PERH2                      _PERH.Bits.PERH2
#define PERH_PERH3                      _PERH.Bits.PERH3
#define PERH_PERH4                      _PERH.Bits.PERH4
#define PERH_PERH5                      _PERH.Bits.PERH5
#define PERH_PERH6                      _PERH.Bits.PERH6
#define PERH_PERH7                      _PERH.Bits.PERH7

#define PERH_PERH0_MASK                 1U
#define PERH_PERH1_MASK                 2U
#define PERH_PERH2_MASK                 4U
#define PERH_PERH3_MASK                 8U
#define PERH_PERH4_MASK                 16U
#define PERH_PERH5_MASK                 32U
#define PERH_PERH6_MASK                 64U
#define PERH_PERH7_MASK                 128U


/*** PPSH - Port H Polarity Select Register; 0x00000265 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSH0       :1;                                       /* Port H pull device select bit 0 */
    byte PPSH1       :1;                                       /* Port H pull device select bit 1 */
    byte PPSH2       :1;                                       /* Port H pull device select bit 2 */
    byte PPSH3       :1;                                       /* Port H pull device select bit 3 */
    byte PPSH4       :1;                                       /* Port H pull device select bit 4 */
    byte PPSH5       :1;                                       /* Port H pull device select bit 5 */
    byte PPSH6       :1;                                       /* Port H pull device select bit 6 */
    byte PPSH7       :1;                                       /* Port H pull device select bit 7 */
  } Bits;
} PPSHSTR;
extern volatile PPSHSTR _PPSH @(REG_BASE + 0x00000265UL);
#define PPSH                            _PPSH.Byte
#define PPSH_PPSH0                      _PPSH.Bits.PPSH0
#define PPSH_PPSH1                      _PPSH.Bits.PPSH1
#define PPSH_PPSH2                      _PPSH.Bits.PPSH2
#define PPSH_PPSH3                      _PPSH.Bits.PPSH3
#define PPSH_PPSH4                      _PPSH.Bits.PPSH4
#define PPSH_PPSH5                      _PPSH.Bits.PPSH5
#define PPSH_PPSH6                      _PPSH.Bits.PPSH6
#define PPSH_PPSH7                      _PPSH.Bits.PPSH7

#define PPSH_PPSH0_MASK                 1U
#define PPSH_PPSH1_MASK                 2U
#define PPSH_PPSH2_MASK                 4U
#define PPSH_PPSH3_MASK                 8U
#define PPSH_PPSH4_MASK                 16U
#define PPSH_PPSH5_MASK                 32U
#define PPSH_PPSH6_MASK                 64U
#define PPSH_PPSH7_MASK                 128U


/*** PIEH - Port H Interrupt Enable Register; 0x00000266 ***/
typedef union {
  byte Byte;
  struct {
    byte PIEH0       :1;                                       /* Port H interrupt enable bit 0 */
    byte PIEH1       :1;                                       /* Port H interrupt enable bit 1 */
    byte PIEH2       :1;                                       /* Port H interrupt enable bit 2 */
    byte PIEH3       :1;                                       /* Port H interrupt enable bit 3 */
    byte PIEH4       :1;                                       /* Port H interrupt enable bit 4 */
    byte PIEH5       :1;                                       /* Port H interrupt enable bit 5 */
    byte PIEH6       :1;                                       /* Port H interrupt enable bit 6 */
    byte PIEH7       :1;                                       /* Port H interrupt enable bit 7 */
  } Bits;
} PIEHSTR;
extern volatile PIEHSTR _PIEH @(REG_BASE + 0x00000266UL);
#define PIEH                            _PIEH.Byte
#define PIEH_PIEH0                      _PIEH.Bits.PIEH0
#define PIEH_PIEH1                      _PIEH.Bits.PIEH1
#define PIEH_PIEH2                      _PIEH.Bits.PIEH2
#define PIEH_PIEH3                      _PIEH.Bits.PIEH3
#define PIEH_PIEH4                      _PIEH.Bits.PIEH4
#define PIEH_PIEH5                      _PIEH.Bits.PIEH5
#define PIEH_PIEH6                      _PIEH.Bits.PIEH6
#define PIEH_PIEH7                      _PIEH.Bits.PIEH7

#define PIEH_PIEH0_MASK                 1U
#define PIEH_PIEH1_MASK                 2U
#define PIEH_PIEH2_MASK                 4U
#define PIEH_PIEH3_MASK                 8U
#define PIEH_PIEH4_MASK                 16U
#define PIEH_PIEH5_MASK                 32U
#define PIEH_PIEH6_MASK                 64U
#define PIEH_PIEH7_MASK                 128U


/*** PIFH - Port H Interrupt Flag Register; 0x00000267 ***/
typedef union {
  byte Byte;
  struct {
    byte PIFH0       :1;                                       /* Port H interrupt flag bit 0 */
    byte PIFH1       :1;                                       /* Port H interrupt flag bit 1 */
    byte PIFH2       :1;                                       /* Port H interrupt flag bit 2 */
    byte PIFH3       :1;                                       /* Port H interrupt flag bit 3 */
    byte PIFH4       :1;                                       /* Port H interrupt flag bit 4 */
    byte PIFH5       :1;                                       /* Port H interrupt flag bit 5 */
    byte PIFH6       :1;                                       /* Port H interrupt flag bit 6 */
    byte PIFH7       :1;                                       /* Port H interrupt flag bit 7 */
  } Bits;
} PIFHSTR;
extern volatile PIFHSTR _PIFH @(REG_BASE + 0x00000267UL);
#define PIFH                            _PIFH.Byte
#define PIFH_PIFH0                      _PIFH.Bits.PIFH0
#define PIFH_PIFH1                      _PIFH.Bits.PIFH1
#define PIFH_PIFH2                      _PIFH.Bits.PIFH2
#define PIFH_PIFH3                      _PIFH.Bits.PIFH3
#define PIFH_PIFH4                      _PIFH.Bits.PIFH4
#define PIFH_PIFH5                      _PIFH.Bits.PIFH5
#define PIFH_PIFH6                      _PIFH.Bits.PIFH6
#define PIFH_PIFH7                      _PIFH.Bits.PIFH7

#define PIFH_PIFH0_MASK                 1U
#define PIFH_PIFH1_MASK                 2U
#define PIFH_PIFH2_MASK                 4U
#define PIFH_PIFH3_MASK                 8U
#define PIFH_PIFH4_MASK                 16U
#define PIFH_PIFH5_MASK                 32U
#define PIFH_PIFH6_MASK                 64U
#define PIFH_PIFH7_MASK                 128U


/*** PTJ - Port J Data Register; 0x00000268 ***/
typedef union {
  byte Byte;
  struct {
    byte PTJ0        :1;                                       /* Port J general purpose input/output data bit 0 */
    byte PTJ1        :1;                                       /* Port J general purpose input/output data bit 1 */
    byte PTJ2        :1;                                       /* Port J general purpose input/output data bit 2 */
    byte PTJ3        :1;                                       /* Port J general purpose input/output data bit 3 */
    byte PTJ4        :1;                                       /* Port J general purpose input/output data bit 4 */
    byte PTJ5        :1;                                       /* Port J general purpose input/output data bit 5 */
    byte PTJ6        :1;                                       /* Port J general purpose input/output data bit 6 */
    byte PTJ7        :1;                                       /* Port J general purpose input/output data bit 7 */
  } Bits;
} PTJSTR;
extern volatile PTJSTR _PTJ @(REG_BASE + 0x00000268UL);
#define PTJ                             _PTJ.Byte
#define PTJ_PTJ0                        _PTJ.Bits.PTJ0
#define PTJ_PTJ1                        _PTJ.Bits.PTJ1
#define PTJ_PTJ2                        _PTJ.Bits.PTJ2
#define PTJ_PTJ3                        _PTJ.Bits.PTJ3
#define PTJ_PTJ4                        _PTJ.Bits.PTJ4
#define PTJ_PTJ5                        _PTJ.Bits.PTJ5
#define PTJ_PTJ6                        _PTJ.Bits.PTJ6
#define PTJ_PTJ7                        _PTJ.Bits.PTJ7

#define PTJ_PTJ0_MASK                   1U
#define PTJ_PTJ1_MASK                   2U
#define PTJ_PTJ2_MASK                   4U
#define PTJ_PTJ3_MASK                   8U
#define PTJ_PTJ4_MASK                   16U
#define PTJ_PTJ5_MASK                   32U
#define PTJ_PTJ6_MASK                   64U
#define PTJ_PTJ7_MASK                   128U


/*** PTIJ - Port J Input Register; 0x00000269 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIJ0       :1;                                       /* Port J input data bit 0 */
    byte PTIJ1       :1;                                       /* Port J input data bit 1 */
    byte PTIJ2       :1;                                       /* Port J input data bit 2 */
    byte PTIJ3       :1;                                       /* Port J input data bit 3 */
    byte PTIJ4       :1;                                       /* Port J input data bit 4 */
    byte PTIJ5       :1;                                       /* Port J input data bit 5 */
    byte PTIJ6       :1;                                       /* Port J input data bit 6 */
    byte PTIJ7       :1;                                       /* Port J input data bit 7 */
  } Bits;
} PTIJSTR;
extern volatile PTIJSTR _PTIJ @(REG_BASE + 0x00000269UL);
#define PTIJ                            _PTIJ.Byte
#define PTIJ_PTIJ0                      _PTIJ.Bits.PTIJ0
#define PTIJ_PTIJ1                      _PTIJ.Bits.PTIJ1
#define PTIJ_PTIJ2                      _PTIJ.Bits.PTIJ2
#define PTIJ_PTIJ3                      _PTIJ.Bits.PTIJ3
#define PTIJ_PTIJ4                      _PTIJ.Bits.PTIJ4
#define PTIJ_PTIJ5                      _PTIJ.Bits.PTIJ5
#define PTIJ_PTIJ6                      _PTIJ.Bits.PTIJ6
#define PTIJ_PTIJ7                      _PTIJ.Bits.PTIJ7

#define PTIJ_PTIJ0_MASK                 1U
#define PTIJ_PTIJ1_MASK                 2U
#define PTIJ_PTIJ2_MASK                 4U
#define PTIJ_PTIJ3_MASK                 8U
#define PTIJ_PTIJ4_MASK                 16U
#define PTIJ_PTIJ5_MASK                 32U
#define PTIJ_PTIJ6_MASK                 64U
#define PTIJ_PTIJ7_MASK                 128U


/*** DDRJ - Port J Data Direction Register; 0x0000026A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRJ0       :1;                                       /* Port J data direction bit 0 */
    byte DDRJ1       :1;                                       /* Port J data direction bit 1 */
    byte DDRJ2       :1;                                       /* Port J data direction bit 2 */
    byte DDRJ3       :1;                                       /* Port J data direction bit 3 */
    byte DDRJ4       :1;                                       /* Port J data direction bit 4 */
    byte DDRJ5       :1;                                       /* Port J data direction bit 5 */
    byte DDRJ6       :1;                                       /* Port J data direction bit 6 */
    byte DDRJ7       :1;                                       /* Port J data direction bit 7 */
  } Bits;
} DDRJSTR;
extern volatile DDRJSTR _DDRJ @(REG_BASE + 0x0000026AUL);
#define DDRJ                            _DDRJ.Byte
#define DDRJ_DDRJ0                      _DDRJ.Bits.DDRJ0
#define DDRJ_DDRJ1                      _DDRJ.Bits.DDRJ1
#define DDRJ_DDRJ2                      _DDRJ.Bits.DDRJ2
#define DDRJ_DDRJ3                      _DDRJ.Bits.DDRJ3
#define DDRJ_DDRJ4                      _DDRJ.Bits.DDRJ4
#define DDRJ_DDRJ5                      _DDRJ.Bits.DDRJ5
#define DDRJ_DDRJ6                      _DDRJ.Bits.DDRJ6
#define DDRJ_DDRJ7                      _DDRJ.Bits.DDRJ7

#define DDRJ_DDRJ0_MASK                 1U
#define DDRJ_DDRJ1_MASK                 2U
#define DDRJ_DDRJ2_MASK                 4U
#define DDRJ_DDRJ3_MASK                 8U
#define DDRJ_DDRJ4_MASK                 16U
#define DDRJ_DDRJ5_MASK                 32U
#define DDRJ_DDRJ6_MASK                 64U
#define DDRJ_DDRJ7_MASK                 128U


/*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRJ0       :1;                                       /* Port J reduced drive bit 0 */
    byte RDRJ1       :1;                                       /* Port J reduced drive bit 1 */
    byte RDRJ2       :1;                                       /* Port J reduced drive bit 2 */
    byte RDRJ3       :1;                                       /* Port J reduced drive bit 3 */
    byte RDRJ4       :1;                                       /* Port J reduced drive bit 4 */
    byte RDRJ5       :1;                                       /* Port J reduced drive bit 5 */
    byte RDRJ6       :1;                                       /* Port J reduced drive bit 6 */
    byte RDRJ7       :1;                                       /* Port J reduced drive bit 7 */
  } Bits;
} RDRJSTR;
extern volatile RDRJSTR _RDRJ @(REG_BASE + 0x0000026BUL);
#define RDRJ                            _RDRJ.Byte
#define RDRJ_RDRJ0                      _RDRJ.Bits.RDRJ0
#define RDRJ_RDRJ1                      _RDRJ.Bits.RDRJ1
#define RDRJ_RDRJ2                      _RDRJ.Bits.RDRJ2
#define RDRJ_RDRJ3                      _RDRJ.Bits.RDRJ3
#define RDRJ_RDRJ4                      _RDRJ.Bits.RDRJ4
#define RDRJ_RDRJ5                      _RDRJ.Bits.RDRJ5
#define RDRJ_RDRJ6                      _RDRJ.Bits.RDRJ6
#define RDRJ_RDRJ7                      _RDRJ.Bits.RDRJ7

#define RDRJ_RDRJ0_MASK                 1U
#define RDRJ_RDRJ1_MASK                 2U
#define RDRJ_RDRJ2_MASK                 4U
#define RDRJ_RDRJ3_MASK                 8U
#define RDRJ_RDRJ4_MASK                 16U
#define RDRJ_RDRJ5_MASK                 32U
#define RDRJ_RDRJ6_MASK                 64U
#define RDRJ_RDRJ7_MASK                 128U


/*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***/
typedef union {
  byte Byte;
  struct {
    byte PERJ0       :1;                                       /* Port J pull device enable bit 0 */
    byte PERJ1       :1;                                       /* Port J pull device enable bit 1 */
    byte PERJ2       :1;                                       /* Port J pull device enable bit 2 */
    byte PERJ3       :1;                                       /* Port J pull device enable bit 3 */
    byte PERJ4       :1;                                       /* Port J pull device enable bit 4 */
    byte PERJ5       :1;                                       /* Port J pull device enable bit 5 */
    byte PERJ6       :1;                                       /* Port J pull device enable bit 6 */
    byte PERJ7       :1;                                       /* Port J pull device enable bit 7 */
  } Bits;
} PERJSTR;
extern volatile PERJSTR _PERJ @(REG_BASE + 0x0000026CUL);
#define PERJ                            _PERJ.Byte
#define PERJ_PERJ0                      _PERJ.Bits.PERJ0
#define PERJ_PERJ1                      _PERJ.Bits.PERJ1
#define PERJ_PERJ2                      _PERJ.Bits.PERJ2
#define PERJ_PERJ3                      _PERJ.Bits.PERJ3
#define PERJ_PERJ4                      _PERJ.Bits.PERJ4
#define PERJ_PERJ5                      _PERJ.Bits.PERJ5
#define PERJ_PERJ6                      _PERJ.Bits.PERJ6
#define PERJ_PERJ7                      _PERJ.Bits.PERJ7

#define PERJ_PERJ0_MASK                 1U
#define PERJ_PERJ1_MASK                 2U
#define PERJ_PERJ2_MASK                 4U
#define PERJ_PERJ3_MASK                 8U
#define PERJ_PERJ4_MASK                 16U
#define PERJ_PERJ5_MASK                 32U
#define PERJ_PERJ6_MASK                 64U
#define PERJ_PERJ7_MASK                 128U


/*** PPSJ - Port J Polarity Select Register; 0x0000026D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSJ0       :1;                                       /* Port J pull device select bit 0 */
    byte PPSJ1       :1;                                       /* Port J pull device select bit 1 */
    byte PPSJ2       :1;                                       /* Port J pull device select bit 2 */
    byte PPSJ3       :1;                                       /* Port J pull device select bit 3 */
    byte PPSJ4       :1;                                       /* Port J pull device select bit 4 */
    byte PPSJ5       :1;                                       /* Port J pull device select bit 5 */
    byte PPSJ6       :1;                                       /* Port J pull device select bit 6 */
    byte PPSJ7       :1;                                       /* Port J pull device select bit 7 */
  } Bits;
} PPSJSTR;
extern volatile PPSJSTR _PPSJ @(REG_BASE + 0x0000026DUL);
#define PPSJ                            _PPSJ.Byte
#define PPSJ_PPSJ0                      _PPSJ.Bits.PPSJ0
#define PPSJ_PPSJ1                      _PPSJ.Bits.PPSJ1
#define PPSJ_PPSJ2                      _PPSJ.Bits.PPSJ2
#define PPSJ_PPSJ3                      _PPSJ.Bits.PPSJ3
#define PPSJ_PPSJ4                      _PPSJ.Bits.PPSJ4
#define PPSJ_PPSJ5                      _PPSJ.Bits.PPSJ5
#define PPSJ_PPSJ6                      _PPSJ.Bits.PPSJ6
#define PPSJ_PPSJ7                      _PPSJ.Bits.PPSJ7

#define PPSJ_PPSJ0_MASK                 1U
#define PPSJ_PPSJ1_MASK                 2U
#define PPSJ_PPSJ2_MASK                 4U
#define PPSJ_PPSJ3_MASK                 8U
#define PPSJ_PPSJ4_MASK                 16U
#define PPSJ_PPSJ5_MASK                 32U
#define PPSJ_PPSJ6_MASK                 64U
#define PPSJ_PPSJ7_MASK                 128U


/*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***/
typedef union {
  byte Byte;
  struct {
    byte PIEJ0       :1;                                       /* Port J interrupt enable bit 0 */
    byte PIEJ1       :1;                                       /* Port J interrupt enable bit 1 */
    byte PIEJ2       :1;                                       /* Port J interrupt enable bit 2 */
    byte PIEJ3       :1;                                       /* Port J interrupt enable bit 3 */
    byte PIEJ4       :1;                                       /* Port J interrupt enable bit 4 */
    byte PIEJ5       :1;                                       /* Port J interrupt enable bit 5 */
    byte PIEJ6       :1;                                       /* Port J interrupt enable bit 6 */
    byte PIEJ7       :1;                                       /* Port J interrupt enable bit 7 */
  } Bits;
} PIEJSTR;
extern volatile PIEJSTR _PIEJ @(REG_BASE + 0x0000026EUL);
#define PIEJ                            _PIEJ.Byte
#define PIEJ_PIEJ0                      _PIEJ.Bits.PIEJ0
#define PIEJ_PIEJ1                      _PIEJ.Bits.PIEJ1
#define PIEJ_PIEJ2                      _PIEJ.Bits.PIEJ2
#define PIEJ_PIEJ3                      _PIEJ.Bits.PIEJ3
#define PIEJ_PIEJ4                      _PIEJ.Bits.PIEJ4
#define PIEJ_PIEJ5                      _PIEJ.Bits.PIEJ5
#define PIEJ_PIEJ6                      _PIEJ.Bits.PIEJ6
#define PIEJ_PIEJ7                      _PIEJ.Bits.PIEJ7

#define PIEJ_PIEJ0_MASK                 1U
#define PIEJ_PIEJ1_MASK                 2U
#define PIEJ_PIEJ2_MASK                 4U
#define PIEJ_PIEJ3_MASK                 8U
#define PIEJ_PIEJ4_MASK                 16U
#define PIEJ_PIEJ5_MASK                 32U
#define PIEJ_PIEJ6_MASK                 64U
#define PIEJ_PIEJ7_MASK                 128U


/*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***/
typedef union {
  byte Byte;
  struct {
    byte PIFJ0       :1;                                       /* Port J interrupt flag bit 0 */
    byte PIFJ1       :1;                                       /* Port J interrupt flag bit 1 */
    byte PIFJ2       :1;                                       /* Port J interrupt flag bit 2 */
    byte PIFJ3       :1;                                       /* Port J interrupt flag bit 3 */
    byte PIFJ4       :1;                                       /* Port J interrupt flag bit 4 */
    byte PIFJ5       :1;                                       /* Port J interrupt flag bit 5 */
    byte PIFJ6       :1;                                       /* Port J interrupt flag bit 6 */
    byte PIFJ7       :1;                                       /* Port J interrupt flag bit 7 */
  } Bits;
} PIFJSTR;
extern volatile PIFJSTR _PIFJ @(REG_BASE + 0x0000026FUL);
#define PIFJ                            _PIFJ.Byte
#define PIFJ_PIFJ0                      _PIFJ.Bits.PIFJ0
#define PIFJ_PIFJ1                      _PIFJ.Bits.PIFJ1
#define PIFJ_PIFJ2                      _PIFJ.Bits.PIFJ2
#define PIFJ_PIFJ3                      _PIFJ.Bits.PIFJ3
#define PIFJ_PIFJ4                      _PIFJ.Bits.PIFJ4
#define PIFJ_PIFJ5                      _PIFJ.Bits.PIFJ5
#define PIFJ_PIFJ6                      _PIFJ.Bits.PIFJ6
#define PIFJ_PIFJ7                      _PIFJ.Bits.PIFJ7

#define PIFJ_PIFJ0_MASK                 1U
#define PIFJ_PIFJ1_MASK                 2U
#define PIFJ_PIFJ2_MASK                 4U
#define PIFJ_PIFJ3_MASK                 8U
#define PIFJ_PIFJ4_MASK                 16U
#define PIFJ_PIFJ5_MASK                 32U
#define PIFJ_PIFJ6_MASK                 64U
#define PIFJ_PIFJ7_MASK                 128U


/*** PT01AD0 - Port AD0 Data Register; 0x00000270 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PT0AD0 - Port AD0H Data Register; 0x00000270 ***/
    union {
      byte Byte;
      struct {
        byte PT0AD00     :1;                                       /* Port AD0 data bit 0 */
        byte PT0AD01     :1;                                       /* Port AD0 data bit 1 */
        byte PT0AD02     :1;                                       /* Port AD0 data bit 2 */
        byte PT0AD03     :1;                                       /* Port AD0 data bit 3 */
        byte PT0AD04     :1;                                       /* Port AD0 data bit 4 */
        byte PT0AD05     :1;                                       /* Port AD0 data bit 5 */
        byte PT0AD06     :1;                                       /* Port AD0 data bit 6 */
        byte PT0AD07     :1;                                       /* Port AD0 data bit 7 */
      } Bits;
    } PT0AD0STR;
    #define PT0AD0                      _PT01AD0.Overlap_STR.PT0AD0STR.Byte
    #define PT0AD0_PT0AD00              _PT01AD0.Overlap_STR.PT0AD0STR.Bits.PT0AD00
    #define PT0AD0_PT0AD01              _PT01AD0.Overlap_STR.PT0AD0STR.Bits.PT0AD01
    #define PT0AD0_PT0AD02              _PT01AD0.Overlap_STR.PT0AD0STR.Bits.PT0AD02
    #define PT0AD0_PT0AD03              _PT01AD0.Overlap_STR.PT0AD0STR.Bits.PT0AD03
    #define PT0AD0_PT0AD04              _PT01AD0.Overlap_STR.PT0AD0STR.Bits.PT0AD04
    #define PT0AD0_PT0AD05              _PT01AD0.Overlap_STR.PT0AD0STR.Bits.PT0AD05
    #define PT0AD0_PT0AD06              _PT01AD0.Overlap_STR.PT0AD0STR.Bits.PT0AD06
    #define PT0AD0_PT0AD07              _PT01AD0.Overlap_STR.PT0AD0STR.Bits.PT0AD07
    
    #define PT0AD0_PT0AD00_MASK         1U
    #define PT0AD0_PT0AD01_MASK         2U
    #define PT0AD0_PT0AD02_MASK         4U
    #define PT0AD0_PT0AD03_MASK         8U
    #define PT0AD0_PT0AD04_MASK         16U
    #define PT0AD0_PT0AD05_MASK         32U
    #define PT0AD0_PT0AD06_MASK         64U
    #define PT0AD0_PT0AD07_MASK         128U
    

    /*** PT1AD0 - Port AD0L Data Register; 0x00000271 ***/
    union {
      byte Byte;
      struct {
        byte PT1AD00     :1;                                       /* Port AD0 data bit 0 */
        byte PT1AD01     :1;                                       /* Port AD0 data bit 1 */
        byte PT1AD02     :1;                                       /* Port AD0 data bit 2 */
        byte PT1AD03     :1;                                       /* Port AD0 data bit 3 */
        byte PT1AD04     :1;                                       /* Port AD0 data bit 4 */
        byte PT1AD05     :1;                                       /* Port AD0 data bit 5 */
        byte PT1AD06     :1;                                       /* Port AD0 data bit 6 */
        byte PT1AD07     :1;                                       /* Port AD0 data bit 7 */
      } Bits;
    } PT1AD0STR;
    #define PT1AD0                      _PT01AD0.Overlap_STR.PT1AD0STR.Byte
    #define PT1AD0_PT1AD00              _PT01AD0.Overlap_STR.PT1AD0STR.Bits.PT1AD00
    #define PT1AD0_PT1AD01              _PT01AD0.Overlap_STR.PT1AD0STR.Bits.PT1AD01
    #define PT1AD0_PT1AD02              _PT01AD0.Overlap_STR.PT1AD0STR.Bits.PT1AD02
    #define PT1AD0_PT1AD03              _PT01AD0.Overlap_STR.PT1AD0STR.Bits.PT1AD03
    #define PT1AD0_PT1AD04              _PT01AD0.Overlap_STR.PT1AD0STR.Bits.PT1AD04
    #define PT1AD0_PT1AD05              _PT01AD0.Overlap_STR.PT1AD0STR.Bits.PT1AD05
    #define PT1AD0_PT1AD06              _PT01AD0.Overlap_STR.PT1AD0STR.Bits.PT1AD06
    #define PT1AD0_PT1AD07              _PT01AD0.Overlap_STR.PT1AD0STR.Bits.PT1AD07
    
    #define PT1AD0_PT1AD00_MASK         1U
    #define PT1AD0_PT1AD01_MASK         2U
    #define PT1AD0_PT1AD02_MASK         4U
    #define PT1AD0_PT1AD03_MASK         8U
    #define PT1AD0_PT1AD04_MASK         16U
    #define PT1AD0_PT1AD05_MASK         32U
    #define PT1AD0_PT1AD06_MASK         64U
    #define PT1AD0_PT1AD07_MASK         128U
    
  } Overlap_STR;

  struct {
    word PT1AD00     :1;                                       /* Port AD0 data bit 0 */
    word PT1AD01     :1;                                       /* Port AD0 data bit 1 */
    word PT1AD02     :1;                                       /* Port AD0 data bit 2 */
    word PT1AD03     :1;                                       /* Port AD0 data bit 3 */
    word PT1AD04     :1;                                       /* Port AD0 data bit 4 */
    word PT1AD05     :1;                                       /* Port AD0 data bit 5 */
    word PT1AD06     :1;                                       /* Port AD0 data bit 6 */
    word PT1AD07     :1;                                       /* Port AD0 data bit 7 */
    word PT0AD00     :1;                                       /* Port AD0 data bit 8 */
    word PT0AD01     :1;                                       /* Port AD0 data bit 9 */
    word PT0AD02     :1;                                       /* Port AD0 data bit 10 */
    word PT0AD03     :1;                                       /* Port AD0 data bit 11 */
    word PT0AD04     :1;                                       /* Port AD0 data bit 12 */
    word PT0AD05     :1;                                       /* Port AD0 data bit 13 */
    word PT0AD06     :1;                                       /* Port AD0 data bit 14 */
    word PT0AD07     :1;                                       /* Port AD0 data bit 15 */
  } Bits;
  struct {
    word grpPT1AD0 :8;
    word grpPT0AD0 :8;
  } MergedBits;
} PT01AD0STR;
extern volatile PT01AD0STR _PT01AD0 @(REG_BASE + 0x00000270UL);
#define PT01AD0                         _PT01AD0.Word
#define PT01AD0_PT1AD00                 _PT01AD0.Bits.PT1AD00
#define PT01AD0_PT1AD01                 _PT01AD0.Bits.PT1AD01
#define PT01AD0_PT1AD02                 _PT01AD0.Bits.PT1AD02
#define PT01AD0_PT1AD03                 _PT01AD0.Bits.PT1AD03
#define PT01AD0_PT1AD04                 _PT01AD0.Bits.PT1AD04
#define PT01AD0_PT1AD05                 _PT01AD0.Bits.PT1AD05
#define PT01AD0_PT1AD06                 _PT01AD0.Bits.PT1AD06
#define PT01AD0_PT1AD07                 _PT01AD0.Bits.PT1AD07
#define PT01AD0_PT0AD00                 _PT01AD0.Bits.PT0AD00
#define PT01AD0_PT0AD01                 _PT01AD0.Bits.PT0AD01
#define PT01AD0_PT0AD02                 _PT01AD0.Bits.PT0AD02
#define PT01AD0_PT0AD03                 _PT01AD0.Bits.PT0AD03
#define PT01AD0_PT0AD04                 _PT01AD0.Bits.PT0AD04
#define PT01AD0_PT0AD05                 _PT01AD0.Bits.PT0AD05
#define PT01AD0_PT0AD06                 _PT01AD0.Bits.PT0AD06
#define PT01AD0_PT0AD07                 _PT01AD0.Bits.PT0AD07
#define PT01AD0_PT1AD0                  _PT01AD0.MergedBits.grpPT1AD0
#define PT01AD0_PT0AD0                  _PT01AD0.MergedBits.grpPT0AD0

#define PT01AD0_PT1AD00_MASK            1U
#define PT01AD0_PT1AD01_MASK            2U
#define PT01AD0_PT1AD02_MASK            4U
#define PT01AD0_PT1AD03_MASK            8U
#define PT01AD0_PT1AD04_MASK            16U
#define PT01AD0_PT1AD05_MASK            32U
#define PT01AD0_PT1AD06_MASK            64U
#define PT01AD0_PT1AD07_MASK            128U
#define PT01AD0_PT0AD00_MASK            256U
#define PT01AD0_PT0AD01_MASK            512U
#define PT01AD0_PT0AD02_MASK            1024U
#define PT01AD0_PT0AD03_MASK            2048U
#define PT01AD0_PT0AD04_MASK            4096U
#define PT01AD0_PT0AD05_MASK            8192U
#define PT01AD0_PT0AD06_MASK            16384U
#define PT01AD0_PT0AD07_MASK            32768U
#define PT01AD0_PT1AD0_MASK             255U
#define PT01AD0_PT1AD0_BITNUM           0U
#define PT01AD0_PT0AD0_MASK             65280U
#define PT01AD0_PT0AD0_BITNUM           8U


/*** DDR01AD0 - Port AD0 Data Direction Register; 0x00000272 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDR0AD0 - Port AD0H Data Direction Register; 0x00000272 ***/
    union {
      byte Byte;
      struct {
        byte DDR0AD00    :1;                                       /* Port AD0 data direction bit 0 */
        byte DDR0AD01    :1;                                       /* Port AD0 data direction bit 1 */
        byte DDR0AD02    :1;                                       /* Port AD0 data direction bit 2 */
        byte DDR0AD03    :1;                                       /* Port AD0 data direction bit 3 */
        byte DDR0AD04    :1;                                       /* Port AD0 data direction bit 4 */
        byte DDR0AD05    :1;                                       /* Port AD0 data direction bit 5 */
        byte DDR0AD06    :1;                                       /* Port AD0 data direction bit 6 */
        byte DDR0AD07    :1;                                       /* Port AD0 data direction bit 7 */
      } Bits;
    } DDR0AD0STR;
    #define DDR0AD0                     _DDR01AD0.Overlap_STR.DDR0AD0STR.Byte
    #define DDR0AD0_DDR0AD00            _DDR01AD0.Overlap_STR.DDR0AD0STR.Bits.DDR0AD00
    #define DDR0AD0_DDR0AD01            _DDR01AD0.Overlap_STR.DDR0AD0STR.Bits.DDR0AD01
    #define DDR0AD0_DDR0AD02            _DDR01AD0.Overlap_STR.DDR0AD0STR.Bits.DDR0AD02
    #define DDR0AD0_DDR0AD03            _DDR01AD0.Overlap_STR.DDR0AD0STR.Bits.DDR0AD03
    #define DDR0AD0_DDR0AD04            _DDR01AD0.Overlap_STR.DDR0AD0STR.Bits.DDR0AD04
    #define DDR0AD0_DDR0AD05            _DDR01AD0.Overlap_STR.DDR0AD0STR.Bits.DDR0AD05
    #define DDR0AD0_DDR0AD06            _DDR01AD0.Overlap_STR.DDR0AD0STR.Bits.DDR0AD06
    #define DDR0AD0_DDR0AD07            _DDR01AD0.Overlap_STR.DDR0AD0STR.Bits.DDR0AD07
    
    #define DDR0AD0_DDR0AD00_MASK       1U
    #define DDR0AD0_DDR0AD01_MASK       2U
    #define DDR0AD0_DDR0AD02_MASK       4U
    #define DDR0AD0_DDR0AD03_MASK       8U
    #define DDR0AD0_DDR0AD04_MASK       16U
    #define DDR0AD0_DDR0AD05_MASK       32U
    #define DDR0AD0_DDR0AD06_MASK       64U
    #define DDR0AD0_DDR0AD07_MASK       128U
    

    /*** DDR1AD0 - Port AD0L Data Direction Register; 0x00000273 ***/
    union {
      byte Byte;
      struct {
        byte DDR1AD00    :1;                                       /* Port AD0 data direction bit 0 */
        byte DDR1AD01    :1;                                       /* Port AD0 data direction bit 1 */
        byte DDR1AD02    :1;                                       /* Port AD0 data direction bit 2 */
        byte DDR1AD03    :1;                                       /* Port AD0 data direction bit 3 */
        byte DDR1AD04    :1;                                       /* Port AD0 data direction bit 4 */
        byte DDR1AD05    :1;                                       /* Port AD0 data direction bit 5 */
        byte DDR1AD06    :1;                                       /* Port AD0 data direction bit 6 */
        byte DDR1AD07    :1;                                       /* Port AD0 data direction bit 7 */
      } Bits;
    } DDR1AD0STR;
    #define DDR1AD0                     _DDR01AD0.Overlap_STR.DDR1AD0STR.Byte
    #define DDR1AD0_DDR1AD00            _DDR01AD0.Overlap_STR.DDR1AD0STR.Bits.DDR1AD00
    #define DDR1AD0_DDR1AD01            _DDR01AD0.Overlap_STR.DDR1AD0STR.Bits.DDR1AD01
    #define DDR1AD0_DDR1AD02            _DDR01AD0.Overlap_STR.DDR1AD0STR.Bits.DDR1AD02
    #define DDR1AD0_DDR1AD03            _DDR01AD0.Overlap_STR.DDR1AD0STR.Bits.DDR1AD03
    #define DDR1AD0_DDR1AD04            _DDR01AD0.Overlap_STR.DDR1AD0STR.Bits.DDR1AD04
    #define DDR1AD0_DDR1AD05            _DDR01AD0.Overlap_STR.DDR1AD0STR.Bits.DDR1AD05
    #define DDR1AD0_DDR1AD06            _DDR01AD0.Overlap_STR.DDR1AD0STR.Bits.DDR1AD06
    #define DDR1AD0_DDR1AD07            _DDR01AD0.Overlap_STR.DDR1AD0STR.Bits.DDR1AD07
    
    #define DDR1AD0_DDR1AD00_MASK       1U
    #define DDR1AD0_DDR1AD01_MASK       2U
    #define DDR1AD0_DDR1AD02_MASK       4U
    #define DDR1AD0_DDR1AD03_MASK       8U
    #define DDR1AD0_DDR1AD04_MASK       16U
    #define DDR1AD0_DDR1AD05_MASK       32U
    #define DDR1AD0_DDR1AD06_MASK       64U
    #define DDR1AD0_DDR1AD07_MASK       128U
    
  } Overlap_STR;

  struct {
    word DDR1AD00    :1;                                       /* Port AD0 data direction bit 0 */
    word DDR1AD01    :1;                                       /* Port AD0 data direction bit 1 */
    word DDR1AD02    :1;                                       /* Port AD0 data direction bit 2 */
    word DDR1AD03    :1;                                       /* Port AD0 data direction bit 3 */
    word DDR1AD04    :1;                                       /* Port AD0 data direction bit 4 */
    word DDR1AD05    :1;                                       /* Port AD0 data direction bit 5 */
    word DDR1AD06    :1;                                       /* Port AD0 data direction bit 6 */
    word DDR1AD07    :1;                                       /* Port AD0 data direction bit 7 */
    word DDR0AD00    :1;                                       /* Port AD0 data direction bit 8 */
    word DDR0AD01    :1;                                       /* Port AD0 data direction bit 9 */
    word DDR0AD02    :1;                                       /* Port AD0 data direction bit 10 */
    word DDR0AD03    :1;                                       /* Port AD0 data direction bit 11 */
    word DDR0AD04    :1;                                       /* Port AD0 data direction bit 12 */
    word DDR0AD05    :1;                                       /* Port AD0 data direction bit 13 */
    word DDR0AD06    :1;                                       /* Port AD0 data direction bit 14 */
    word DDR0AD07    :1;                                       /* Port AD0 data direction bit 15 */
  } Bits;
  struct {
    word grpDDR1AD0 :8;
    word grpDDR0AD0 :8;
  } MergedBits;
} DDR01AD0STR;
extern volatile DDR01AD0STR _DDR01AD0 @(REG_BASE + 0x00000272UL);
#define DDR01AD0                        _DDR01AD0.Word
#define DDR01AD0_DDR1AD00               _DDR01AD0.Bits.DDR1AD00
#define DDR01AD0_DDR1AD01               _DDR01AD0.Bits.DDR1AD01
#define DDR01AD0_DDR1AD02               _DDR01AD0.Bits.DDR1AD02
#define DDR01AD0_DDR1AD03               _DDR01AD0.Bits.DDR1AD03
#define DDR01AD0_DDR1AD04               _DDR01AD0.Bits.DDR1AD04
#define DDR01AD0_DDR1AD05               _DDR01AD0.Bits.DDR1AD05
#define DDR01AD0_DDR1AD06               _DDR01AD0.Bits.DDR1AD06
#define DDR01AD0_DDR1AD07               _DDR01AD0.Bits.DDR1AD07
#define DDR01AD0_DDR0AD00               _DDR01AD0.Bits.DDR0AD00
#define DDR01AD0_DDR0AD01               _DDR01AD0.Bits.DDR0AD01
#define DDR01AD0_DDR0AD02               _DDR01AD0.Bits.DDR0AD02
#define DDR01AD0_DDR0AD03               _DDR01AD0.Bits.DDR0AD03
#define DDR01AD0_DDR0AD04               _DDR01AD0.Bits.DDR0AD04
#define DDR01AD0_DDR0AD05               _DDR01AD0.Bits.DDR0AD05
#define DDR01AD0_DDR0AD06               _DDR01AD0.Bits.DDR0AD06
#define DDR01AD0_DDR0AD07               _DDR01AD0.Bits.DDR0AD07
#define DDR01AD0_DDR1AD0                _DDR01AD0.MergedBits.grpDDR1AD0
#define DDR01AD0_DDR0AD0                _DDR01AD0.MergedBits.grpDDR0AD0

#define DDR01AD0_DDR1AD00_MASK          1U
#define DDR01AD0_DDR1AD01_MASK          2U
#define DDR01AD0_DDR1AD02_MASK          4U
#define DDR01AD0_DDR1AD03_MASK          8U
#define DDR01AD0_DDR1AD04_MASK          16U
#define DDR01AD0_DDR1AD05_MASK          32U
#define DDR01AD0_DDR1AD06_MASK          64U
#define DDR01AD0_DDR1AD07_MASK          128U
#define DDR01AD0_DDR0AD00_MASK          256U
#define DDR01AD0_DDR0AD01_MASK          512U
#define DDR01AD0_DDR0AD02_MASK          1024U
#define DDR01AD0_DDR0AD03_MASK          2048U
#define DDR01AD0_DDR0AD04_MASK          4096U
#define DDR01AD0_DDR0AD05_MASK          8192U
#define DDR01AD0_DDR0AD06_MASK          16384U
#define DDR01AD0_DDR0AD07_MASK          32768U
#define DDR01AD0_DDR1AD0_MASK           255U
#define DDR01AD0_DDR1AD0_BITNUM         0U
#define DDR01AD0_DDR0AD0_MASK           65280U
#define DDR01AD0_DDR0AD0_BITNUM         8U


/*** RDR01AD0 - Port AD0 Reduced Drive Register; 0x00000274 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** RDR0AD0 - Port AD0H Reduced Drive Register; 0x00000274 ***/
    union {
      byte Byte;
      struct {
        byte RDR0AD00    :1;                                       /* Port AD0H reduced drive bit 0 */
        byte RDR0AD01    :1;                                       /* Port AD0H reduced drive bit 1 */
        byte RDR0AD02    :1;                                       /* Port AD0H reduced drive bit 2 */
        byte RDR0AD03    :1;                                       /* Port AD0H reduced drive bit 3 */
        byte RDR0AD04    :1;                                       /* Port AD0H reduced drive bit 4 */
        byte RDR0AD05    :1;                                       /* Port AD0H reduced drive bit 5 */
        byte RDR0AD06    :1;                                       /* Port AD0H reduced drive bit 6 */
        byte RDR0AD07    :1;                                       /* Port AD0H reduced drive bit 7 */
      } Bits;
    } RDR0AD0STR;
    #define RDR0AD0                     _RDR01AD0.Overlap_STR.RDR0AD0STR.Byte
    #define RDR0AD0_RDR0AD00            _RDR01AD0.Overlap_STR.RDR0AD0STR.Bits.RDR0AD00
    #define RDR0AD0_RDR0AD01            _RDR01AD0.Overlap_STR.RDR0AD0STR.Bits.RDR0AD01
    #define RDR0AD0_RDR0AD02            _RDR01AD0.Overlap_STR.RDR0AD0STR.Bits.RDR0AD02
    #define RDR0AD0_RDR0AD03            _RDR01AD0.Overlap_STR.RDR0AD0STR.Bits.RDR0AD03
    #define RDR0AD0_RDR0AD04            _RDR01AD0.Overlap_STR.RDR0AD0STR.Bits.RDR0AD04
    #define RDR0AD0_RDR0AD05            _RDR01AD0.Overlap_STR.RDR0AD0STR.Bits.RDR0AD05
    #define RDR0AD0_RDR0AD06            _RDR01AD0.Overlap_STR.RDR0AD0STR.Bits.RDR0AD06
    #define RDR0AD0_RDR0AD07            _RDR01AD0.Overlap_STR.RDR0AD0STR.Bits.RDR0AD07
    
    #define RDR0AD0_RDR0AD00_MASK       1U
    #define RDR0AD0_RDR0AD01_MASK       2U
    #define RDR0AD0_RDR0AD02_MASK       4U
    #define RDR0AD0_RDR0AD03_MASK       8U
    #define RDR0AD0_RDR0AD04_MASK       16U
    #define RDR0AD0_RDR0AD05_MASK       32U
    #define RDR0AD0_RDR0AD06_MASK       64U
    #define RDR0AD0_RDR0AD07_MASK       128U
    

    /*** RDR1AD0 - Port AD0L Reduced Drive Register; 0x00000275 ***/
    union {
      byte Byte;
      struct {
        byte RDR1AD00    :1;                                       /* Port AD0L reduced drive bit 0 */
        byte RDR1AD01    :1;                                       /* Port AD0L reduced drive bit 1 */
        byte RDR1AD02    :1;                                       /* Port AD0L reduced drive bit 2 */
        byte RDR1AD03    :1;                                       /* Port AD0L reduced drive bit 3 */
        byte RDR1AD04    :1;                                       /* Port AD0L reduced drive bit 4 */
        byte RDR1AD05    :1;                                       /* Port AD0L reduced drive bit 5 */
        byte RDR1AD06    :1;                                       /* Port AD0L reduced drive bit 6 */
        byte RDR1AD07    :1;                                       /* Port AD0L reduced drive bit 7 */
      } Bits;
    } RDR1AD0STR;
    #define RDR1AD0                     _RDR01AD0.Overlap_STR.RDR1AD0STR.Byte
    #define RDR1AD0_RDR1AD00            _RDR01AD0.Overlap_STR.RDR1AD0STR.Bits.RDR1AD00
    #define RDR1AD0_RDR1AD01            _RDR01AD0.Overlap_STR.RDR1AD0STR.Bits.RDR1AD01
    #define RDR1AD0_RDR1AD02            _RDR01AD0.Overlap_STR.RDR1AD0STR.Bits.RDR1AD02
    #define RDR1AD0_RDR1AD03            _RDR01AD0.Overlap_STR.RDR1AD0STR.Bits.RDR1AD03
    #define RDR1AD0_RDR1AD04            _RDR01AD0.Overlap_STR.RDR1AD0STR.Bits.RDR1AD04
    #define RDR1AD0_RDR1AD05            _RDR01AD0.Overlap_STR.RDR1AD0STR.Bits.RDR1AD05
    #define RDR1AD0_RDR1AD06            _RDR01AD0.Overlap_STR.RDR1AD0STR.Bits.RDR1AD06
    #define RDR1AD0_RDR1AD07            _RDR01AD0.Overlap_STR.RDR1AD0STR.Bits.RDR1AD07
    
    #define RDR1AD0_RDR1AD00_MASK       1U
    #define RDR1AD0_RDR1AD01_MASK       2U
    #define RDR1AD0_RDR1AD02_MASK       4U
    #define RDR1AD0_RDR1AD03_MASK       8U
    #define RDR1AD0_RDR1AD04_MASK       16U
    #define RDR1AD0_RDR1AD05_MASK       32U
    #define RDR1AD0_RDR1AD06_MASK       64U
    #define RDR1AD0_RDR1AD07_MASK       128U
    
  } Overlap_STR;

  struct {
    word RDR1AD00    :1;                                       /* Port AD0 reduced drive bit 0 */
    word RDR1AD01    :1;                                       /* Port AD0 reduced drive bit 1 */
    word RDR1AD02    :1;                                       /* Port AD0 reduced drive bit 2 */
    word RDR1AD03    :1;                                       /* Port AD0 reduced drive bit 3 */
    word RDR1AD04    :1;                                       /* Port AD0 reduced drive bit 4 */
    word RDR1AD05    :1;                                       /* Port AD0 reduced drive bit 5 */
    word RDR1AD06    :1;                                       /* Port AD0 reduced drive bit 6 */
    word RDR1AD07    :1;                                       /* Port AD0 reduced drive bit 7 */
    word RDR0AD00    :1;                                       /* Port AD0 reduced drive bit 8 */
    word RDR0AD01    :1;                                       /* Port AD0 reduced drive bit 9 */
    word RDR0AD02    :1;                                       /* Port AD0 reduced drive bit 10 */
    word RDR0AD03    :1;                                       /* Port AD0 reduced drive bit 11 */
    word RDR0AD04    :1;                                       /* Port AD0 reduced drive bit 12 */
    word RDR0AD05    :1;                                       /* Port AD0 reduced drive bit 13 */
    word RDR0AD06    :1;                                       /* Port AD0 reduced drive bit 14 */
    word RDR0AD07    :1;                                       /* Port AD0 reduced drive bit 15 */
  } Bits;
  struct {
    word grpRDR1AD0 :8;
    word grpRDR0AD0 :8;
  } MergedBits;
} RDR01AD0STR;
extern volatile RDR01AD0STR _RDR01AD0 @(REG_BASE + 0x00000274UL);
#define RDR01AD0                        _RDR01AD0.Word
#define RDR01AD0_RDR1AD00               _RDR01AD0.Bits.RDR1AD00
#define RDR01AD0_RDR1AD01               _RDR01AD0.Bits.RDR1AD01
#define RDR01AD0_RDR1AD02               _RDR01AD0.Bits.RDR1AD02
#define RDR01AD0_RDR1AD03               _RDR01AD0.Bits.RDR1AD03
#define RDR01AD0_RDR1AD04               _RDR01AD0.Bits.RDR1AD04
#define RDR01AD0_RDR1AD05               _RDR01AD0.Bits.RDR1AD05
#define RDR01AD0_RDR1AD06               _RDR01AD0.Bits.RDR1AD06
#define RDR01AD0_RDR1AD07               _RDR01AD0.Bits.RDR1AD07
#define RDR01AD0_RDR0AD00               _RDR01AD0.Bits.RDR0AD00
#define RDR01AD0_RDR0AD01               _RDR01AD0.Bits.RDR0AD01
#define RDR01AD0_RDR0AD02               _RDR01AD0.Bits.RDR0AD02
#define RDR01AD0_RDR0AD03               _RDR01AD0.Bits.RDR0AD03
#define RDR01AD0_RDR0AD04               _RDR01AD0.Bits.RDR0AD04
#define RDR01AD0_RDR0AD05               _RDR01AD0.Bits.RDR0AD05
#define RDR01AD0_RDR0AD06               _RDR01AD0.Bits.RDR0AD06
#define RDR01AD0_RDR0AD07               _RDR01AD0.Bits.RDR0AD07
#define RDR01AD0_RDR1AD0                _RDR01AD0.MergedBits.grpRDR1AD0
#define RDR01AD0_RDR0AD0                _RDR01AD0.MergedBits.grpRDR0AD0

#define RDR01AD0_RDR1AD00_MASK          1U
#define RDR01AD0_RDR1AD01_MASK          2U
#define RDR01AD0_RDR1AD02_MASK          4U
#define RDR01AD0_RDR1AD03_MASK          8U
#define RDR01AD0_RDR1AD04_MASK          16U
#define RDR01AD0_RDR1AD05_MASK          32U
#define RDR01AD0_RDR1AD06_MASK          64U
#define RDR01AD0_RDR1AD07_MASK          128U
#define RDR01AD0_RDR0AD00_MASK          256U
#define RDR01AD0_RDR0AD01_MASK          512U
#define RDR01AD0_RDR0AD02_MASK          1024U
#define RDR01AD0_RDR0AD03_MASK          2048U
#define RDR01AD0_RDR0AD04_MASK          4096U
#define RDR01AD0_RDR0AD05_MASK          8192U
#define RDR01AD0_RDR0AD06_MASK          16384U
#define RDR01AD0_RDR0AD07_MASK          32768U
#define RDR01AD0_RDR1AD0_MASK           255U
#define RDR01AD0_RDR1AD0_BITNUM         0U
#define RDR01AD0_RDR0AD0_MASK           65280U
#define RDR01AD0_RDR0AD0_BITNUM         8U


/*** PER01AD0 - Port AD0 Pull Up Enable Register; 0x00000276 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PER0AD0 - Port AD0H Pull Up Enable Register; 0x00000276 ***/
    union {
      byte Byte;
      struct {
        byte PER0AD00    :1;                                       /* Port AD0H pull up enable bit 0 */
        byte PER0AD01    :1;                                       /* Port AD0H pull up enable bit 1 */
        byte PER0AD02    :1;                                       /* Port AD0H pull up enable bit 2 */
        byte PER0AD03    :1;                                       /* Port AD0H pull up enable bit 3 */
        byte PER0AD04    :1;                                       /* Port AD0H pull up enable bit 4 */
        byte PER0AD05    :1;                                       /* Port AD0H pull up enable bit 5 */
        byte PER0AD06    :1;                                       /* Port AD0H pull up enable bit 6 */
        byte PER0AD07    :1;                                       /* Port AD0H pull up enable bit 7 */
      } Bits;
    } PER0AD0STR;
    #define PER0AD0                     _PER01AD0.Overlap_STR.PER0AD0STR.Byte
    #define PER0AD0_PER0AD00            _PER01AD0.Overlap_STR.PER0AD0STR.Bits.PER0AD00
    #define PER0AD0_PER0AD01            _PER01AD0.Overlap_STR.PER0AD0STR.Bits.PER0AD01
    #define PER0AD0_PER0AD02            _PER01AD0.Overlap_STR.PER0AD0STR.Bits.PER0AD02
    #define PER0AD0_PER0AD03            _PER01AD0.Overlap_STR.PER0AD0STR.Bits.PER0AD03
    #define PER0AD0_PER0AD04            _PER01AD0.Overlap_STR.PER0AD0STR.Bits.PER0AD04
    #define PER0AD0_PER0AD05            _PER01AD0.Overlap_STR.PER0AD0STR.Bits.PER0AD05
    #define PER0AD0_PER0AD06            _PER01AD0.Overlap_STR.PER0AD0STR.Bits.PER0AD06
    #define PER0AD0_PER0AD07            _PER01AD0.Overlap_STR.PER0AD0STR.Bits.PER0AD07
    
    #define PER0AD0_PER0AD00_MASK       1U
    #define PER0AD0_PER0AD01_MASK       2U
    #define PER0AD0_PER0AD02_MASK       4U
    #define PER0AD0_PER0AD03_MASK       8U
    #define PER0AD0_PER0AD04_MASK       16U
    #define PER0AD0_PER0AD05_MASK       32U
    #define PER0AD0_PER0AD06_MASK       64U
    #define PER0AD0_PER0AD07_MASK       128U
    

    /*** PER1AD0 - Port AD0L Pull Up Enable Register; 0x00000277 ***/
    union {
      byte Byte;
      struct {
        byte PER1AD00    :1;                                       /* Port AD0L pull up enable bit 0 */
        byte PER1AD01    :1;                                       /* Port AD0L pull up enable bit 1 */
        byte PER1AD02    :1;                                       /* Port AD0L pull up enable bit 2 */
        byte PER1AD03    :1;                                       /* Port AD0L pull up enable bit 3 */
        byte PER1AD04    :1;                                       /* Port AD0L pull up enable bit 4 */
        byte PER1AD05    :1;                                       /* Port AD0L pull up enable bit 5 */
        byte PER1AD06    :1;                                       /* Port AD0L pull up enable bit 6 */
        byte PER1AD07    :1;                                       /* Port AD0L pull up enable bit 7 */
      } Bits;
    } PER1AD0STR;
    #define PER1AD0                     _PER01AD0.Overlap_STR.PER1AD0STR.Byte
    #define PER1AD0_PER1AD00            _PER01AD0.Overlap_STR.PER1AD0STR.Bits.PER1AD00
    #define PER1AD0_PER1AD01            _PER01AD0.Overlap_STR.PER1AD0STR.Bits.PER1AD01
    #define PER1AD0_PER1AD02            _PER01AD0.Overlap_STR.PER1AD0STR.Bits.PER1AD02
    #define PER1AD0_PER1AD03            _PER01AD0.Overlap_STR.PER1AD0STR.Bits.PER1AD03
    #define PER1AD0_PER1AD04            _PER01AD0.Overlap_STR.PER1AD0STR.Bits.PER1AD04
    #define PER1AD0_PER1AD05            _PER01AD0.Overlap_STR.PER1AD0STR.Bits.PER1AD05
    #define PER1AD0_PER1AD06            _PER01AD0.Overlap_STR.PER1AD0STR.Bits.PER1AD06
    #define PER1AD0_PER1AD07            _PER01AD0.Overlap_STR.PER1AD0STR.Bits.PER1AD07
    
    #define PER1AD0_PER1AD00_MASK       1U
    #define PER1AD0_PER1AD01_MASK       2U
    #define PER1AD0_PER1AD02_MASK       4U
    #define PER1AD0_PER1AD03_MASK       8U
    #define PER1AD0_PER1AD04_MASK       16U
    #define PER1AD0_PER1AD05_MASK       32U
    #define PER1AD0_PER1AD06_MASK       64U
    #define PER1AD0_PER1AD07_MASK       128U
    
  } Overlap_STR;

  struct {
    word PER1AD00    :1;                                       /* Port AD0 pull up enable bit 0 */
    word PER1AD01    :1;                                       /* Port AD0 pull up enable bit 1 */
    word PER1AD02    :1;                                       /* Port AD0 pull up enable bit 2 */
    word PER1AD03    :1;                                       /* Port AD0 pull up enable bit 3 */
    word PER1AD04    :1;                                       /* Port AD0 pull up enable bit 4 */
    word PER1AD05    :1;                                       /* Port AD0 pull up enable bit 5 */
    word PER1AD06    :1;                                       /* Port AD0 pull up enable bit 6 */
    word PER1AD07    :1;                                       /* Port AD0 pull up enable bit 7 */
    word PER0AD00    :1;                                       /* Port AD0 pull up enable bit 8 */
    word PER0AD01    :1;                                       /* Port AD0 pull up enable bit 9 */
    word PER0AD02    :1;                                       /* Port AD0 pull up enable bit 10 */
    word PER0AD03    :1;                                       /* Port AD0 pull up enable bit 11 */
    word PER0AD04    :1;                                       /* Port AD0 pull up enable bit 12 */
    word PER0AD05    :1;                                       /* Port AD0 pull up enable bit 13 */
    word PER0AD06    :1;                                       /* Port AD0 pull up enable bit 14 */
    word PER0AD07    :1;                                       /* Port AD0 pull up enable bit 15 */
  } Bits;
  struct {
    word grpPER1AD0 :8;
    word grpPER0AD0 :8;
  } MergedBits;
} PER01AD0STR;
extern volatile PER01AD0STR _PER01AD0 @(REG_BASE + 0x00000276UL);
#define PER01AD0                        _PER01AD0.Word
#define PER01AD0_PER1AD00               _PER01AD0.Bits.PER1AD00
#define PER01AD0_PER1AD01               _PER01AD0.Bits.PER1AD01
#define PER01AD0_PER1AD02               _PER01AD0.Bits.PER1AD02
#define PER01AD0_PER1AD03               _PER01AD0.Bits.PER1AD03
#define PER01AD0_PER1AD04               _PER01AD0.Bits.PER1AD04
#define PER01AD0_PER1AD05               _PER01AD0.Bits.PER1AD05
#define PER01AD0_PER1AD06               _PER01AD0.Bits.PER1AD06
#define PER01AD0_PER1AD07               _PER01AD0.Bits.PER1AD07
#define PER01AD0_PER0AD00               _PER01AD0.Bits.PER0AD00
#define PER01AD0_PER0AD01               _PER01AD0.Bits.PER0AD01
#define PER01AD0_PER0AD02               _PER01AD0.Bits.PER0AD02
#define PER01AD0_PER0AD03               _PER01AD0.Bits.PER0AD03
#define PER01AD0_PER0AD04               _PER01AD0.Bits.PER0AD04
#define PER01AD0_PER0AD05               _PER01AD0.Bits.PER0AD05
#define PER01AD0_PER0AD06               _PER01AD0.Bits.PER0AD06
#define PER01AD0_PER0AD07               _PER01AD0.Bits.PER0AD07
#define PER01AD0_PER1AD0                _PER01AD0.MergedBits.grpPER1AD0
#define PER01AD0_PER0AD0                _PER01AD0.MergedBits.grpPER0AD0

#define PER01AD0_PER1AD00_MASK          1U
#define PER01AD0_PER1AD01_MASK          2U
#define PER01AD0_PER1AD02_MASK          4U
#define PER01AD0_PER1AD03_MASK          8U
#define PER01AD0_PER1AD04_MASK          16U
#define PER01AD0_PER1AD05_MASK          32U
#define PER01AD0_PER1AD06_MASK          64U
#define PER01AD0_PER1AD07_MASK          128U
#define PER01AD0_PER0AD00_MASK          256U
#define PER01AD0_PER0AD01_MASK          512U
#define PER01AD0_PER0AD02_MASK          1024U
#define PER01AD0_PER0AD03_MASK          2048U
#define PER01AD0_PER0AD04_MASK          4096U
#define PER01AD0_PER0AD05_MASK          8192U
#define PER01AD0_PER0AD06_MASK          16384U
#define PER01AD0_PER0AD07_MASK          32768U
#define PER01AD0_PER1AD0_MASK           255U
#define PER01AD0_PER1AD0_BITNUM         0U
#define PER01AD0_PER0AD0_MASK           65280U
#define PER01AD0_PER0AD0_BITNUM         8U


/*** PT01AD1 - Port AD1 Data Register; 0x00000278 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PT0AD1 - Port AD1H Data Register; 0x00000278 ***/
    union {
      byte Byte;
      struct {
        byte PT0AD10     :1;                                       /* Port AD1 data bit 0 */
        byte PT0AD11     :1;                                       /* Port AD1 data bit 1 */
        byte PT0AD12     :1;                                       /* Port AD1 data bit 2 */
        byte PT0AD13     :1;                                       /* Port AD1 data bit 3 */
        byte PT0AD14     :1;                                       /* Port AD1 data bit 4 */
        byte PT0AD15     :1;                                       /* Port AD1 data bit 5 */
        byte PT0AD16     :1;                                       /* Port AD1 data bit 6 */
        byte PT0AD17     :1;                                       /* Port AD1 data bit 7 */
      } Bits;
    } PT0AD1STR;
    #define PT0AD1                      _PT01AD1.Overlap_STR.PT0AD1STR.Byte
    #define PT0AD1_PT0AD10              _PT01AD1.Overlap_STR.PT0AD1STR.Bits.PT0AD10
    #define PT0AD1_PT0AD11              _PT01AD1.Overlap_STR.PT0AD1STR.Bits.PT0AD11
    #define PT0AD1_PT0AD12              _PT01AD1.Overlap_STR.PT0AD1STR.Bits.PT0AD12
    #define PT0AD1_PT0AD13              _PT01AD1.Overlap_STR.PT0AD1STR.Bits.PT0AD13
    #define PT0AD1_PT0AD14              _PT01AD1.Overlap_STR.PT0AD1STR.Bits.PT0AD14
    #define PT0AD1_PT0AD15              _PT01AD1.Overlap_STR.PT0AD1STR.Bits.PT0AD15
    #define PT0AD1_PT0AD16              _PT01AD1.Overlap_STR.PT0AD1STR.Bits.PT0AD16
    #define PT0AD1_PT0AD17              _PT01AD1.Overlap_STR.PT0AD1STR.Bits.PT0AD17
    
    #define PT0AD1_PT0AD10_MASK         1U
    #define PT0AD1_PT0AD11_MASK         2U
    #define PT0AD1_PT0AD12_MASK         4U
    #define PT0AD1_PT0AD13_MASK         8U
    #define PT0AD1_PT0AD14_MASK         16U
    #define PT0AD1_PT0AD15_MASK         32U
    #define PT0AD1_PT0AD16_MASK         64U
    #define PT0AD1_PT0AD17_MASK         128U
    

    /*** PT1AD1 - Port AD1L Data Register; 0x00000279 ***/
    union {
      byte Byte;
      struct {
        byte PT1AD10     :1;                                       /* Port AD1 data bit 0 */
        byte PT1AD11     :1;                                       /* Port AD1 data bit 1 */
        byte PT1AD12     :1;                                       /* Port AD1 data bit 2 */
        byte PT1AD13     :1;                                       /* Port AD1 data bit 3 */
        byte PT1AD14     :1;                                       /* Port AD1 data bit 4 */
        byte PT1AD15     :1;                                       /* Port AD1 data bit 5 */
        byte PT1AD16     :1;                                       /* Port AD1 data bit 6 */
        byte PT1AD17     :1;                                       /* Port AD1 data bit 7 */
      } Bits;
    } PT1AD1STR;
    #define PT1AD1                      _PT01AD1.Overlap_STR.PT1AD1STR.Byte
    #define PT1AD1_PT1AD10              _PT01AD1.Overlap_STR.PT1AD1STR.Bits.PT1AD10
    #define PT1AD1_PT1AD11              _PT01AD1.Overlap_STR.PT1AD1STR.Bits.PT1AD11
    #define PT1AD1_PT1AD12              _PT01AD1.Overlap_STR.PT1AD1STR.Bits.PT1AD12
    #define PT1AD1_PT1AD13              _PT01AD1.Overlap_STR.PT1AD1STR.Bits.PT1AD13
    #define PT1AD1_PT1AD14              _PT01AD1.Overlap_STR.PT1AD1STR.Bits.PT1AD14
    #define PT1AD1_PT1AD15              _PT01AD1.Overlap_STR.PT1AD1STR.Bits.PT1AD15
    #define PT1AD1_PT1AD16              _PT01AD1.Overlap_STR.PT1AD1STR.Bits.PT1AD16
    #define PT1AD1_PT1AD17              _PT01AD1.Overlap_STR.PT1AD1STR.Bits.PT1AD17
    
    #define PT1AD1_PT1AD10_MASK         1U
    #define PT1AD1_PT1AD11_MASK         2U
    #define PT1AD1_PT1AD12_MASK         4U
    #define PT1AD1_PT1AD13_MASK         8U
    #define PT1AD1_PT1AD14_MASK         16U
    #define PT1AD1_PT1AD15_MASK         32U
    #define PT1AD1_PT1AD16_MASK         64U
    #define PT1AD1_PT1AD17_MASK         128U
    
  } Overlap_STR;

  struct {
    word PT1AD10     :1;                                       /* Port AD1 data bit 0 */
    word PT1AD11     :1;                                       /* Port AD1 data bit 1 */
    word PT1AD12     :1;                                       /* Port AD1 data bit 2 */
    word PT1AD13     :1;                                       /* Port AD1 data bit 3 */
    word PT1AD14     :1;                                       /* Port AD1 data bit 4 */
    word PT1AD15     :1;                                       /* Port AD1 data bit 5 */
    word PT1AD16     :1;                                       /* Port AD1 data bit 6 */
    word PT1AD17     :1;                                       /* Port AD1 data bit 7 */
    word PT0AD10     :1;                                       /* Port AD1 data bit 8 */
    word PT0AD11     :1;                                       /* Port AD1 data bit 9 */
    word PT0AD12     :1;                                       /* Port AD1 data bit 10 */
    word PT0AD13     :1;                                       /* Port AD1 data bit 11 */
    word PT0AD14     :1;                                       /* Port AD1 data bit 12 */
    word PT0AD15     :1;                                       /* Port AD1 data bit 13 */
    word PT0AD16     :1;                                       /* Port AD1 data bit 14 */
    word PT0AD17     :1;                                       /* Port AD1 data bit 15 */
  } Bits;
  struct {
    word grpPT1AD_10 :8;
    word grpPT0AD_10 :8;
  } MergedBits;
} PT01AD1STR;
extern volatile PT01AD1STR _PT01AD1 @(REG_BASE + 0x00000278UL);
#define PT01AD1                         _PT01AD1.Word
#define PT01AD1_PT1AD10                 _PT01AD1.Bits.PT1AD10
#define PT01AD1_PT1AD11                 _PT01AD1.Bits.PT1AD11
#define PT01AD1_PT1AD12                 _PT01AD1.Bits.PT1AD12
#define PT01AD1_PT1AD13                 _PT01AD1.Bits.PT1AD13
#define PT01AD1_PT1AD14                 _PT01AD1.Bits.PT1AD14
#define PT01AD1_PT1AD15                 _PT01AD1.Bits.PT1AD15
#define PT01AD1_PT1AD16                 _PT01AD1.Bits.PT1AD16
#define PT01AD1_PT1AD17                 _PT01AD1.Bits.PT1AD17
#define PT01AD1_PT0AD10                 _PT01AD1.Bits.PT0AD10
#define PT01AD1_PT0AD11                 _PT01AD1.Bits.PT0AD11
#define PT01AD1_PT0AD12                 _PT01AD1.Bits.PT0AD12
#define PT01AD1_PT0AD13                 _PT01AD1.Bits.PT0AD13
#define PT01AD1_PT0AD14                 _PT01AD1.Bits.PT0AD14
#define PT01AD1_PT0AD15                 _PT01AD1.Bits.PT0AD15
#define PT01AD1_PT0AD16                 _PT01AD1.Bits.PT0AD16
#define PT01AD1_PT0AD17                 _PT01AD1.Bits.PT0AD17
#define PT01AD1_PT1AD_10                _PT01AD1.MergedBits.grpPT1AD_10
#define PT01AD1_PT0AD_10                _PT01AD1.MergedBits.grpPT0AD_10
#define PT01AD1_PT1AD                   PT01AD1_PT1AD_10
#define PT01AD1_PT0AD                   PT01AD1_PT0AD_10

#define PT01AD1_PT1AD10_MASK            1U
#define PT01AD1_PT1AD11_MASK            2U
#define PT01AD1_PT1AD12_MASK            4U
#define PT01AD1_PT1AD13_MASK            8U
#define PT01AD1_PT1AD14_MASK            16U
#define PT01AD1_PT1AD15_MASK            32U
#define PT01AD1_PT1AD16_MASK            64U
#define PT01AD1_PT1AD17_MASK            128U
#define PT01AD1_PT0AD10_MASK            256U
#define PT01AD1_PT0AD11_MASK            512U
#define PT01AD1_PT0AD12_MASK            1024U
#define PT01AD1_PT0AD13_MASK            2048U
#define PT01AD1_PT0AD14_MASK            4096U
#define PT01AD1_PT0AD15_MASK            8192U
#define PT01AD1_PT0AD16_MASK            16384U
#define PT01AD1_PT0AD17_MASK            32768U
#define PT01AD1_PT1AD_10_MASK           255U
#define PT01AD1_PT1AD_10_BITNUM         0U
#define PT01AD1_PT0AD_10_MASK           65280U
#define PT01AD1_PT0AD_10_BITNUM         8U


/*** DDR01AD1 - Port AD1 Data Direction Register; 0x0000027A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDR0AD1 - Port AD1H Data Direction Register; 0x0000027A ***/
    union {
      byte Byte;
      struct {
        byte DDR0AD10    :1;                                       /* Port AD1 data direction bit 0 */
        byte DDR0AD11    :1;                                       /* Port AD1 data direction bit 1 */
        byte DDR0AD12    :1;                                       /* Port AD1 data direction bit 2 */
        byte DDR0AD13    :1;                                       /* Port AD1 data direction bit 3 */
        byte DDR0AD14    :1;                                       /* Port AD1 data direction bit 4 */
        byte DDR0AD15    :1;                                       /* Port AD1 data direction bit 5 */
        byte DDR0AD16    :1;                                       /* Port AD1 data direction bit 6 */
        byte DDR0AD17    :1;                                       /* Port AD1 data direction bit 7 */
      } Bits;
    } DDR0AD1STR;
    #define DDR0AD1                     _DDR01AD1.Overlap_STR.DDR0AD1STR.Byte
    #define DDR0AD1_DDR0AD10            _DDR01AD1.Overlap_STR.DDR0AD1STR.Bits.DDR0AD10
    #define DDR0AD1_DDR0AD11            _DDR01AD1.Overlap_STR.DDR0AD1STR.Bits.DDR0AD11
    #define DDR0AD1_DDR0AD12            _DDR01AD1.Overlap_STR.DDR0AD1STR.Bits.DDR0AD12
    #define DDR0AD1_DDR0AD13            _DDR01AD1.Overlap_STR.DDR0AD1STR.Bits.DDR0AD13
    #define DDR0AD1_DDR0AD14            _DDR01AD1.Overlap_STR.DDR0AD1STR.Bits.DDR0AD14
    #define DDR0AD1_DDR0AD15            _DDR01AD1.Overlap_STR.DDR0AD1STR.Bits.DDR0AD15
    #define DDR0AD1_DDR0AD16            _DDR01AD1.Overlap_STR.DDR0AD1STR.Bits.DDR0AD16
    #define DDR0AD1_DDR0AD17            _DDR01AD1.Overlap_STR.DDR0AD1STR.Bits.DDR0AD17
    
    #define DDR0AD1_DDR0AD10_MASK       1U
    #define DDR0AD1_DDR0AD11_MASK       2U
    #define DDR0AD1_DDR0AD12_MASK       4U
    #define DDR0AD1_DDR0AD13_MASK       8U
    #define DDR0AD1_DDR0AD14_MASK       16U
    #define DDR0AD1_DDR0AD15_MASK       32U
    #define DDR0AD1_DDR0AD16_MASK       64U
    #define DDR0AD1_DDR0AD17_MASK       128U
    

    /*** DDR1AD1 - Port AD1L Data Direction Register; 0x0000027B ***/
    union {
      byte Byte;
      struct {
        byte DDR1AD10    :1;                                       /* Port AD1 data direction bit 0 */
        byte DDR1AD11    :1;                                       /* Port AD1 data direction bit 1 */
        byte DDR1AD12    :1;                                       /* Port AD1 data direction bit 2 */
        byte DDR1AD13    :1;                                       /* Port AD1 data direction bit 3 */
        byte DDR1AD14    :1;                                       /* Port AD1 data direction bit 4 */
        byte DDR1AD15    :1;                                       /* Port AD1 data direction bit 5 */
        byte DDR1AD16    :1;                                       /* Port AD1 data direction bit 6 */
        byte DDR1AD17    :1;                                       /* Port AD1 data direction bit 7 */
      } Bits;
    } DDR1AD1STR;
    #define DDR1AD1                     _DDR01AD1.Overlap_STR.DDR1AD1STR.Byte
    #define DDR1AD1_DDR1AD10            _DDR01AD1.Overlap_STR.DDR1AD1STR.Bits.DDR1AD10
    #define DDR1AD1_DDR1AD11            _DDR01AD1.Overlap_STR.DDR1AD1STR.Bits.DDR1AD11
    #define DDR1AD1_DDR1AD12            _DDR01AD1.Overlap_STR.DDR1AD1STR.Bits.DDR1AD12
    #define DDR1AD1_DDR1AD13            _DDR01AD1.Overlap_STR.DDR1AD1STR.Bits.DDR1AD13
    #define DDR1AD1_DDR1AD14            _DDR01AD1.Overlap_STR.DDR1AD1STR.Bits.DDR1AD14
    #define DDR1AD1_DDR1AD15            _DDR01AD1.Overlap_STR.DDR1AD1STR.Bits.DDR1AD15
    #define DDR1AD1_DDR1AD16            _DDR01AD1.Overlap_STR.DDR1AD1STR.Bits.DDR1AD16
    #define DDR1AD1_DDR1AD17            _DDR01AD1.Overlap_STR.DDR1AD1STR.Bits.DDR1AD17
    
    #define DDR1AD1_DDR1AD10_MASK       1U
    #define DDR1AD1_DDR1AD11_MASK       2U
    #define DDR1AD1_DDR1AD12_MASK       4U
    #define DDR1AD1_DDR1AD13_MASK       8U
    #define DDR1AD1_DDR1AD14_MASK       16U
    #define DDR1AD1_DDR1AD15_MASK       32U
    #define DDR1AD1_DDR1AD16_MASK       64U
    #define DDR1AD1_DDR1AD17_MASK       128U
    
  } Overlap_STR;

  struct {
    word DDR1AD10    :1;                                       /* Port AD1 data direction bit 0 */
    word DDR1AD11    :1;                                       /* Port AD1 data direction bit 1 */
    word DDR1AD12    :1;                                       /* Port AD1 data direction bit 2 */
    word DDR1AD13    :1;                                       /* Port AD1 data direction bit 3 */
    word DDR1AD14    :1;                                       /* Port AD1 data direction bit 4 */
    word DDR1AD15    :1;                                       /* Port AD1 data direction bit 5 */
    word DDR1AD16    :1;                                       /* Port AD1 data direction bit 6 */
    word DDR1AD17    :1;                                       /* Port AD1 data direction bit 7 */
    word DDR0AD10    :1;                                       /* Port AD1 data direction bit 8 */
    word DDR0AD11    :1;                                       /* Port AD1 data direction bit 9 */
    word DDR0AD12    :1;                                       /* Port AD1 data direction bit 10 */
    word DDR0AD13    :1;                                       /* Port AD1 data direction bit 11 */
    word DDR0AD14    :1;                                       /* Port AD1 data direction bit 12 */
    word DDR0AD15    :1;                                       /* Port AD1 data direction bit 13 */
    word DDR0AD16    :1;                                       /* Port AD1 data direction bit 14 */
    word DDR0AD17    :1;                                       /* Port AD1 data direction bit 15 */
  } Bits;
  struct {
    word grpDDR1AD_10 :8;
    word grpDDR0AD_10 :8;
  } MergedBits;
} DDR01AD1STR;
extern volatile DDR01AD1STR _DDR01AD1 @(REG_BASE + 0x0000027AUL);
#define DDR01AD1                        _DDR01AD1.Word
#define DDR01AD1_DDR1AD10               _DDR01AD1.Bits.DDR1AD10
#define DDR01AD1_DDR1AD11               _DDR01AD1.Bits.DDR1AD11
#define DDR01AD1_DDR1AD12               _DDR01AD1.Bits.DDR1AD12
#define DDR01AD1_DDR1AD13               _DDR01AD1.Bits.DDR1AD13
#define DDR01AD1_DDR1AD14               _DDR01AD1.Bits.DDR1AD14
#define DDR01AD1_DDR1AD15               _DDR01AD1.Bits.DDR1AD15
#define DDR01AD1_DDR1AD16               _DDR01AD1.Bits.DDR1AD16
#define DDR01AD1_DDR1AD17               _DDR01AD1.Bits.DDR1AD17
#define DDR01AD1_DDR0AD10               _DDR01AD1.Bits.DDR0AD10
#define DDR01AD1_DDR0AD11               _DDR01AD1.Bits.DDR0AD11
#define DDR01AD1_DDR0AD12               _DDR01AD1.Bits.DDR0AD12
#define DDR01AD1_DDR0AD13               _DDR01AD1.Bits.DDR0AD13
#define DDR01AD1_DDR0AD14               _DDR01AD1.Bits.DDR0AD14
#define DDR01AD1_DDR0AD15               _DDR01AD1.Bits.DDR0AD15
#define DDR01AD1_DDR0AD16               _DDR01AD1.Bits.DDR0AD16
#define DDR01AD1_DDR0AD17               _DDR01AD1.Bits.DDR0AD17
#define DDR01AD1_DDR1AD_10              _DDR01AD1.MergedBits.grpDDR1AD_10
#define DDR01AD1_DDR0AD_10              _DDR01AD1.MergedBits.grpDDR0AD_10
#define DDR01AD1_DDR1AD                 DDR01AD1_DDR1AD_10
#define DDR01AD1_DDR0AD                 DDR01AD1_DDR0AD_10

#define DDR01AD1_DDR1AD10_MASK          1U
#define DDR01AD1_DDR1AD11_MASK          2U
#define DDR01AD1_DDR1AD12_MASK          4U
#define DDR01AD1_DDR1AD13_MASK          8U
#define DDR01AD1_DDR1AD14_MASK          16U
#define DDR01AD1_DDR1AD15_MASK          32U
#define DDR01AD1_DDR1AD16_MASK          64U
#define DDR01AD1_DDR1AD17_MASK          128U
#define DDR01AD1_DDR0AD10_MASK          256U
#define DDR01AD1_DDR0AD11_MASK          512U
#define DDR01AD1_DDR0AD12_MASK          1024U
#define DDR01AD1_DDR0AD13_MASK          2048U
#define DDR01AD1_DDR0AD14_MASK          4096U
#define DDR01AD1_DDR0AD15_MASK          8192U
#define DDR01AD1_DDR0AD16_MASK          16384U
#define DDR01AD1_DDR0AD17_MASK          32768U
#define DDR01AD1_DDR1AD_10_MASK         255U
#define DDR01AD1_DDR1AD_10_BITNUM       0U
#define DDR01AD1_DDR0AD_10_MASK         65280U
#define DDR01AD1_DDR0AD_10_BITNUM       8U


/*** RDR01AD1 - Port AD1 Reduced Drive Register; 0x0000027C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** RDR0AD1 - Port AD1H Reduced Drive Register; 0x0000027C ***/
    union {
      byte Byte;
      struct {
        byte RDR0AD10    :1;                                       /* Port AD1H reduced drive bit 0 */
        byte RDR0AD11    :1;                                       /* Port AD1H reduced drive bit 1 */
        byte RDR0AD12    :1;                                       /* Port AD1H reduced drive bit 2 */
        byte RDR0AD13    :1;                                       /* Port AD1H reduced drive bit 3 */
        byte RDR0AD14    :1;                                       /* Port AD1H reduced drive bit 4 */
        byte RDR0AD15    :1;                                       /* Port AD1H reduced drive bit 5 */
        byte RDR0AD16    :1;                                       /* Port AD1H reduced drive bit 6 */
        byte RDR0AD17    :1;                                       /* Port AD1H reduced drive bit 7 */
      } Bits;
    } RDR0AD1STR;
    #define RDR0AD1                     _RDR01AD1.Overlap_STR.RDR0AD1STR.Byte
    #define RDR0AD1_RDR0AD10            _RDR01AD1.Overlap_STR.RDR0AD1STR.Bits.RDR0AD10
    #define RDR0AD1_RDR0AD11            _RDR01AD1.Overlap_STR.RDR0AD1STR.Bits.RDR0AD11
    #define RDR0AD1_RDR0AD12            _RDR01AD1.Overlap_STR.RDR0AD1STR.Bits.RDR0AD12
    #define RDR0AD1_RDR0AD13            _RDR01AD1.Overlap_STR.RDR0AD1STR.Bits.RDR0AD13
    #define RDR0AD1_RDR0AD14            _RDR01AD1.Overlap_STR.RDR0AD1STR.Bits.RDR0AD14
    #define RDR0AD1_RDR0AD15            _RDR01AD1.Overlap_STR.RDR0AD1STR.Bits.RDR0AD15
    #define RDR0AD1_RDR0AD16            _RDR01AD1.Overlap_STR.RDR0AD1STR.Bits.RDR0AD16
    #define RDR0AD1_RDR0AD17            _RDR01AD1.Overlap_STR.RDR0AD1STR.Bits.RDR0AD17
    
    #define RDR0AD1_RDR0AD10_MASK       1U
    #define RDR0AD1_RDR0AD11_MASK       2U
    #define RDR0AD1_RDR0AD12_MASK       4U
    #define RDR0AD1_RDR0AD13_MASK       8U
    #define RDR0AD1_RDR0AD14_MASK       16U
    #define RDR0AD1_RDR0AD15_MASK       32U
    #define RDR0AD1_RDR0AD16_MASK       64U
    #define RDR0AD1_RDR0AD17_MASK       128U
    

    /*** RDR1AD1 - Port AD1L Reduced Drive Register; 0x0000027D ***/
    union {
      byte Byte;
      struct {
        byte RDR1AD10    :1;                                       /* Port AD1L reduced drive bit 0 */
        byte RDR1AD11    :1;                                       /* Port AD1L reduced drive bit 1 */
        byte RDR1AD12    :1;                                       /* Port AD1L reduced drive bit 2 */
        byte RDR1AD13    :1;                                       /* Port AD1L reduced drive bit 3 */
        byte RDR1AD14    :1;                                       /* Port AD1L reduced drive bit 4 */
        byte RDR1AD15    :1;                                       /* Port AD1L reduced drive bit 5 */
        byte RDR1AD16    :1;                                       /* Port AD1L reduced drive bit 6 */
        byte RDR1AD17    :1;                                       /* Port AD1L reduced drive bit 7 */
      } Bits;
    } RDR1AD1STR;
    #define RDR1AD1                     _RDR01AD1.Overlap_STR.RDR1AD1STR.Byte
    #define RDR1AD1_RDR1AD10            _RDR01AD1.Overlap_STR.RDR1AD1STR.Bits.RDR1AD10
    #define RDR1AD1_RDR1AD11            _RDR01AD1.Overlap_STR.RDR1AD1STR.Bits.RDR1AD11
    #define RDR1AD1_RDR1AD12            _RDR01AD1.Overlap_STR.RDR1AD1STR.Bits.RDR1AD12
    #define RDR1AD1_RDR1AD13            _RDR01AD1.Overlap_STR.RDR1AD1STR.Bits.RDR1AD13
    #define RDR1AD1_RDR1AD14            _RDR01AD1.Overlap_STR.RDR1AD1STR.Bits.RDR1AD14
    #define RDR1AD1_RDR1AD15            _RDR01AD1.Overlap_STR.RDR1AD1STR.Bits.RDR1AD15
    #define RDR1AD1_RDR1AD16            _RDR01AD1.Overlap_STR.RDR1AD1STR.Bits.RDR1AD16
    #define RDR1AD1_RDR1AD17            _RDR01AD1.Overlap_STR.RDR1AD1STR.Bits.RDR1AD17
    
    #define RDR1AD1_RDR1AD10_MASK       1U
    #define RDR1AD1_RDR1AD11_MASK       2U
    #define RDR1AD1_RDR1AD12_MASK       4U
    #define RDR1AD1_RDR1AD13_MASK       8U
    #define RDR1AD1_RDR1AD14_MASK       16U
    #define RDR1AD1_RDR1AD15_MASK       32U
    #define RDR1AD1_RDR1AD16_MASK       64U
    #define RDR1AD1_RDR1AD17_MASK       128U
    
  } Overlap_STR;

  struct {
    word RDR1AD10    :1;                                       /* Port AD1 reduced drive bit 0 */
    word RDR1AD11    :1;                                       /* Port AD1 reduced drive bit 1 */
    word RDR1AD12    :1;                                       /* Port AD1 reduced drive bit 2 */
    word RDR1AD13    :1;                                       /* Port AD1 reduced drive bit 3 */
    word RDR1AD14    :1;                                       /* Port AD1 reduced drive bit 4 */
    word RDR1AD15    :1;                                       /* Port AD1 reduced drive bit 5 */
    word RDR1AD16    :1;                                       /* Port AD1 reduced drive bit 6 */
    word RDR1AD17    :1;                                       /* Port AD1 reduced drive bit 7 */
    word RDR0AD10    :1;                                       /* Port AD1 reduced drive bit 8 */
    word RDR0AD11    :1;                                       /* Port AD1 reduced drive bit 9 */
    word RDR0AD12    :1;                                       /* Port AD1 reduced drive bit 10 */
    word RDR0AD13    :1;                                       /* Port AD1 reduced drive bit 11 */
    word RDR0AD14    :1;                                       /* Port AD1 reduced drive bit 12 */
    word RDR0AD15    :1;                                       /* Port AD1 reduced drive bit 13 */
    word RDR0AD16    :1;                                       /* Port AD1 reduced drive bit 14 */
    word RDR0AD17    :1;                                       /* Port AD1 reduced drive bit 15 */
  } Bits;
  struct {
    word grpRDR1AD_10 :8;
    word grpRDR0AD_10 :8;
  } MergedBits;
} RDR01AD1STR;
extern volatile RDR01AD1STR _RDR01AD1 @(REG_BASE + 0x0000027CUL);
#define RDR01AD1                        _RDR01AD1.Word
#define RDR01AD1_RDR1AD10               _RDR01AD1.Bits.RDR1AD10
#define RDR01AD1_RDR1AD11               _RDR01AD1.Bits.RDR1AD11
#define RDR01AD1_RDR1AD12               _RDR01AD1.Bits.RDR1AD12
#define RDR01AD1_RDR1AD13               _RDR01AD1.Bits.RDR1AD13
#define RDR01AD1_RDR1AD14               _RDR01AD1.Bits.RDR1AD14
#define RDR01AD1_RDR1AD15               _RDR01AD1.Bits.RDR1AD15
#define RDR01AD1_RDR1AD16               _RDR01AD1.Bits.RDR1AD16
#define RDR01AD1_RDR1AD17               _RDR01AD1.Bits.RDR1AD17
#define RDR01AD1_RDR0AD10               _RDR01AD1.Bits.RDR0AD10
#define RDR01AD1_RDR0AD11               _RDR01AD1.Bits.RDR0AD11
#define RDR01AD1_RDR0AD12               _RDR01AD1.Bits.RDR0AD12
#define RDR01AD1_RDR0AD13               _RDR01AD1.Bits.RDR0AD13
#define RDR01AD1_RDR0AD14               _RDR01AD1.Bits.RDR0AD14
#define RDR01AD1_RDR0AD15               _RDR01AD1.Bits.RDR0AD15
#define RDR01AD1_RDR0AD16               _RDR01AD1.Bits.RDR0AD16
#define RDR01AD1_RDR0AD17               _RDR01AD1.Bits.RDR0AD17
#define RDR01AD1_RDR1AD_10              _RDR01AD1.MergedBits.grpRDR1AD_10
#define RDR01AD1_RDR0AD_10              _RDR01AD1.MergedBits.grpRDR0AD_10
#define RDR01AD1_RDR1AD                 RDR01AD1_RDR1AD_10
#define RDR01AD1_RDR0AD                 RDR01AD1_RDR0AD_10

#define RDR01AD1_RDR1AD10_MASK          1U
#define RDR01AD1_RDR1AD11_MASK          2U
#define RDR01AD1_RDR1AD12_MASK          4U
#define RDR01AD1_RDR1AD13_MASK          8U
#define RDR01AD1_RDR1AD14_MASK          16U
#define RDR01AD1_RDR1AD15_MASK          32U
#define RDR01AD1_RDR1AD16_MASK          64U
#define RDR01AD1_RDR1AD17_MASK          128U
#define RDR01AD1_RDR0AD10_MASK          256U
#define RDR01AD1_RDR0AD11_MASK          512U
#define RDR01AD1_RDR0AD12_MASK          1024U
#define RDR01AD1_RDR0AD13_MASK          2048U
#define RDR01AD1_RDR0AD14_MASK          4096U
#define RDR01AD1_RDR0AD15_MASK          8192U
#define RDR01AD1_RDR0AD16_MASK          16384U
#define RDR01AD1_RDR0AD17_MASK          32768U
#define RDR01AD1_RDR1AD_10_MASK         255U
#define RDR01AD1_RDR1AD_10_BITNUM       0U
#define RDR01AD1_RDR0AD_10_MASK         65280U
#define RDR01AD1_RDR0AD_10_BITNUM       8U


/*** PER01AD1 - Port AD1 Pull Up Enable Register; 0x0000027E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PER0AD1 - Port AD1H Pull Up Enable Register; 0x0000027E ***/
    union {
      byte Byte;
      struct {
        byte PER0AD10    :1;                                       /* Port AD1H pull up enable bit 0 */
        byte PER0AD11    :1;                                       /* Port AD1H pull up enable bit 1 */
        byte PER0AD12    :1;                                       /* Port AD1H pull up enable bit 2 */
        byte PER0AD13    :1;                                       /* Port AD1H pull up enable bit 3 */
        byte PER0AD14    :1;                                       /* Port AD1H pull up enable bit 4 */
        byte PER0AD15    :1;                                       /* Port AD1H pull up enable bit 5 */
        byte PER0AD16    :1;                                       /* Port AD1H pull up enable bit 6 */
        byte PER0AD17    :1;                                       /* Port AD1H pull up enable bit 7 */
      } Bits;
    } PER0AD1STR;
    #define PER0AD1                     _PER01AD1.Overlap_STR.PER0AD1STR.Byte
    #define PER0AD1_PER0AD10            _PER01AD1.Overlap_STR.PER0AD1STR.Bits.PER0AD10
    #define PER0AD1_PER0AD11            _PER01AD1.Overlap_STR.PER0AD1STR.Bits.PER0AD11
    #define PER0AD1_PER0AD12            _PER01AD1.Overlap_STR.PER0AD1STR.Bits.PER0AD12
    #define PER0AD1_PER0AD13            _PER01AD1.Overlap_STR.PER0AD1STR.Bits.PER0AD13
    #define PER0AD1_PER0AD14            _PER01AD1.Overlap_STR.PER0AD1STR.Bits.PER0AD14
    #define PER0AD1_PER0AD15            _PER01AD1.Overlap_STR.PER0AD1STR.Bits.PER0AD15
    #define PER0AD1_PER0AD16            _PER01AD1.Overlap_STR.PER0AD1STR.Bits.PER0AD16
    #define PER0AD1_PER0AD17            _PER01AD1.Overlap_STR.PER0AD1STR.Bits.PER0AD17
    
    #define PER0AD1_PER0AD10_MASK       1U
    #define PER0AD1_PER0AD11_MASK       2U
    #define PER0AD1_PER0AD12_MASK       4U
    #define PER0AD1_PER0AD13_MASK       8U
    #define PER0AD1_PER0AD14_MASK       16U
    #define PER0AD1_PER0AD15_MASK       32U
    #define PER0AD1_PER0AD16_MASK       64U
    #define PER0AD1_PER0AD17_MASK       128U
    

    /*** PER1AD1 - Port AD1L Pull Up Enable Register; 0x0000027F ***/
    union {
      byte Byte;
      struct {
        byte PER1AD10    :1;                                       /* Port AD1L pull up enable bit 0 */
        byte PER1AD11    :1;                                       /* Port AD1L pull up enable bit 1 */
        byte PER1AD12    :1;                                       /* Port AD1L pull up enable bit 2 */
        byte PER1AD13    :1;                                       /* Port AD1L pull up enable bit 3 */
        byte PER1AD14    :1;                                       /* Port AD1L pull up enable bit 4 */
        byte PER1AD15    :1;                                       /* Port AD1L pull up enable bit 5 */
        byte PER1AD16    :1;                                       /* Port AD1L pull up enable bit 6 */
        byte PER1AD17    :1;                                       /* Port AD1L pull up enable bit 7 */
      } Bits;
    } PER1AD1STR;
    #define PER1AD1                     _PER01AD1.Overlap_STR.PER1AD1STR.Byte
    #define PER1AD1_PER1AD10            _PER01AD1.Overlap_STR.PER1AD1STR.Bits.PER1AD10
    #define PER1AD1_PER1AD11            _PER01AD1.Overlap_STR.PER1AD1STR.Bits.PER1AD11
    #define PER1AD1_PER1AD12            _PER01AD1.Overlap_STR.PER1AD1STR.Bits.PER1AD12
    #define PER1AD1_PER1AD13            _PER01AD1.Overlap_STR.PER1AD1STR.Bits.PER1AD13
    #define PER1AD1_PER1AD14            _PER01AD1.Overlap_STR.PER1AD1STR.Bits.PER1AD14
    #define PER1AD1_PER1AD15            _PER01AD1.Overlap_STR.PER1AD1STR.Bits.PER1AD15
    #define PER1AD1_PER1AD16            _PER01AD1.Overlap_STR.PER1AD1STR.Bits.PER1AD16
    #define PER1AD1_PER1AD17            _PER01AD1.Overlap_STR.PER1AD1STR.Bits.PER1AD17
    
    #define PER1AD1_PER1AD10_MASK       1U
    #define PER1AD1_PER1AD11_MASK       2U
    #define PER1AD1_PER1AD12_MASK       4U
    #define PER1AD1_PER1AD13_MASK       8U
    #define PER1AD1_PER1AD14_MASK       16U
    #define PER1AD1_PER1AD15_MASK       32U
    #define PER1AD1_PER1AD16_MASK       64U
    #define PER1AD1_PER1AD17_MASK       128U
    
  } Overlap_STR;

  struct {
    word PER1AD10    :1;                                       /* Port AD1 pull up enable bit 0 */
    word PER1AD11    :1;                                       /* Port AD1 pull up enable bit 1 */
    word PER1AD12    :1;                                       /* Port AD1 pull up enable bit 2 */
    word PER1AD13    :1;                                       /* Port AD1 pull up enable bit 3 */
    word PER1AD14    :1;                                       /* Port AD1 pull up enable bit 4 */
    word PER1AD15    :1;                                       /* Port AD1 pull up enable bit 5 */
    word PER1AD16    :1;                                       /* Port AD1 pull up enable bit 6 */
    word PER1AD17    :1;                                       /* Port AD1 pull up enable bit 7 */
    word PER0AD10    :1;                                       /* Port AD1 pull up enable bit 8 */
    word PER0AD11    :1;                                       /* Port AD1 pull up enable bit 9 */
    word PER0AD12    :1;                                       /* Port AD1 pull up enable bit 10 */
    word PER0AD13    :1;                                       /* Port AD1 pull up enable bit 11 */
    word PER0AD14    :1;                                       /* Port AD1 pull up enable bit 12 */
    word PER0AD15    :1;                                       /* Port AD1 pull up enable bit 13 */
    word PER0AD16    :1;                                       /* Port AD1 pull up enable bit 14 */
    word PER0AD17    :1;                                       /* Port AD1 pull up enable bit 15 */
  } Bits;
  struct {
    word grpPER1AD_10 :8;
    word grpPER0AD_10 :8;
  } MergedBits;
} PER01AD1STR;
extern volatile PER01AD1STR _PER01AD1 @(REG_BASE + 0x0000027EUL);
#define PER01AD1                        _PER01AD1.Word
#define PER01AD1_PER1AD10               _PER01AD1.Bits.PER1AD10
#define PER01AD1_PER1AD11               _PER01AD1.Bits.PER1AD11
#define PER01AD1_PER1AD12               _PER01AD1.Bits.PER1AD12
#define PER01AD1_PER1AD13               _PER01AD1.Bits.PER1AD13
#define PER01AD1_PER1AD14               _PER01AD1.Bits.PER1AD14
#define PER01AD1_PER1AD15               _PER01AD1.Bits.PER1AD15
#define PER01AD1_PER1AD16               _PER01AD1.Bits.PER1AD16
#define PER01AD1_PER1AD17               _PER01AD1.Bits.PER1AD17
#define PER01AD1_PER0AD10               _PER01AD1.Bits.PER0AD10
#define PER01AD1_PER0AD11               _PER01AD1.Bits.PER0AD11
#define PER01AD1_PER0AD12               _PER01AD1.Bits.PER0AD12
#define PER01AD1_PER0AD13               _PER01AD1.Bits.PER0AD13
#define PER01AD1_PER0AD14               _PER01AD1.Bits.PER0AD14
#define PER01AD1_PER0AD15               _PER01AD1.Bits.PER0AD15
#define PER01AD1_PER0AD16               _PER01AD1.Bits.PER0AD16
#define PER01AD1_PER0AD17               _PER01AD1.Bits.PER0AD17
#define PER01AD1_PER1AD_10              _PER01AD1.MergedBits.grpPER1AD_10
#define PER01AD1_PER0AD_10              _PER01AD1.MergedBits.grpPER0AD_10
#define PER01AD1_PER1AD                 PER01AD1_PER1AD_10
#define PER01AD1_PER0AD                 PER01AD1_PER0AD_10

#define PER01AD1_PER1AD10_MASK          1U
#define PER01AD1_PER1AD11_MASK          2U
#define PER01AD1_PER1AD12_MASK          4U
#define PER01AD1_PER1AD13_MASK          8U
#define PER01AD1_PER1AD14_MASK          16U
#define PER01AD1_PER1AD15_MASK          32U
#define PER01AD1_PER1AD16_MASK          64U
#define PER01AD1_PER1AD17_MASK          128U
#define PER01AD1_PER0AD10_MASK          256U
#define PER01AD1_PER0AD11_MASK          512U
#define PER01AD1_PER0AD12_MASK          1024U
#define PER01AD1_PER0AD13_MASK          2048U
#define PER01AD1_PER0AD14_MASK          4096U
#define PER01AD1_PER0AD15_MASK          8192U
#define PER01AD1_PER0AD16_MASK          16384U
#define PER01AD1_PER0AD17_MASK          32768U
#define PER01AD1_PER1AD_10_MASK         255U
#define PER01AD1_PER1AD_10_BITNUM       0U
#define PER01AD1_PER0AD_10_MASK         65280U
#define PER01AD1_PER0AD_10_BITNUM       8U


/*** CAN4CTL0 - MSCAN4 Control 0 Register; 0x00000280 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN4CTL0STR;
extern volatile CAN4CTL0STR _CAN4CTL0 @(REG_BASE + 0x00000280UL);
#define CAN4CTL0                        _CAN4CTL0.Byte
#define CAN4CTL0_INITRQ                 _CAN4CTL0.Bits.INITRQ
#define CAN4CTL0_SLPRQ                  _CAN4CTL0.Bits.SLPRQ
#define CAN4CTL0_WUPE                   _CAN4CTL0.Bits.WUPE
#define CAN4CTL0_TIME                   _CAN4CTL0.Bits.TIME
#define CAN4CTL0_SYNCH                  _CAN4CTL0.Bits.SYNCH
#define CAN4CTL0_CSWAI                  _CAN4CTL0.Bits.CSWAI
#define CAN4CTL0_RXACT                  _CAN4CTL0.Bits.RXACT
#define CAN4CTL0_RXFRM                  _CAN4CTL0.Bits.RXFRM
/* CAN4CTL_ARR: Access 2 CAN4CTLx registers in an array */
#define CAN4CTL_ARR                     ((volatile byte *) &CAN4CTL0)

#define CAN4CTL0_INITRQ_MASK            1U
#define CAN4CTL0_SLPRQ_MASK             2U
#define CAN4CTL0_WUPE_MASK              4U
#define CAN4CTL0_TIME_MASK              8U
#define CAN4CTL0_SYNCH_MASK             16U
#define CAN4CTL0_CSWAI_MASK             32U
#define CAN4CTL0_RXACT_MASK             64U
#define CAN4CTL0_RXFRM_MASK             128U


/*** CAN4CTL1 - MSCAN4 Control 1 Register; 0x00000281 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN Clock Source */
    byte CANE        :1;                                       /* MSCAN Enable */
  } Bits;
} CAN4CTL1STR;
extern volatile CAN4CTL1STR _CAN4CTL1 @(REG_BASE + 0x00000281UL);
#define CAN4CTL1                        _CAN4CTL1.Byte
#define CAN4CTL1_INITAK                 _CAN4CTL1.Bits.INITAK
#define CAN4CTL1_SLPAK                  _CAN4CTL1.Bits.SLPAK
#define CAN4CTL1_WUPM                   _CAN4CTL1.Bits.WUPM
#define CAN4CTL1_BORM                   _CAN4CTL1.Bits.BORM
#define CAN4CTL1_LISTEN                 _CAN4CTL1.Bits.LISTEN
#define CAN4CTL1_LOOPB                  _CAN4CTL1.Bits.LOOPB
#define CAN4CTL1_CLKSRC                 _CAN4CTL1.Bits.CLKSRC
#define CAN4CTL1_CANE                   _CAN4CTL1.Bits.CANE

#define CAN4CTL1_INITAK_MASK            1U
#define CAN4CTL1_SLPAK_MASK             2U
#define CAN4CTL1_WUPM_MASK              4U
#define CAN4CTL1_BORM_MASK              8U
#define CAN4CTL1_LISTEN_MASK            16U
#define CAN4CTL1_LOOPB_MASK             32U
#define CAN4CTL1_CLKSRC_MASK            64U
#define CAN4CTL1_CANE_MASK              128U


/*** CAN4BTR0 - MSCAN4 Bus Timing Register 0; 0x00000282 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN4BTR0STR;
extern volatile CAN4BTR0STR _CAN4BTR0 @(REG_BASE + 0x00000282UL);
#define CAN4BTR0                        _CAN4BTR0.Byte
#define CAN4BTR0_BRP0                   _CAN4BTR0.Bits.BRP0
#define CAN4BTR0_BRP1                   _CAN4BTR0.Bits.BRP1
#define CAN4BTR0_BRP2                   _CAN4BTR0.Bits.BRP2
#define CAN4BTR0_BRP3                   _CAN4BTR0.Bits.BRP3
#define CAN4BTR0_BRP4                   _CAN4BTR0.Bits.BRP4
#define CAN4BTR0_BRP5                   _CAN4BTR0.Bits.BRP5
#define CAN4BTR0_SJW0                   _CAN4BTR0.Bits.SJW0
#define CAN4BTR0_SJW1                   _CAN4BTR0.Bits.SJW1
/* CAN4BTR_ARR: Access 2 CAN4BTRx registers in an array */
#define CAN4BTR_ARR                     ((volatile byte *) &CAN4BTR0)
#define CAN4BTR0_BRP                    _CAN4BTR0.MergedBits.grpBRP
#define CAN4BTR0_SJW                    _CAN4BTR0.MergedBits.grpSJW

#define CAN4BTR0_BRP0_MASK              1U
#define CAN4BTR0_BRP1_MASK              2U
#define CAN4BTR0_BRP2_MASK              4U
#define CAN4BTR0_BRP3_MASK              8U
#define CAN4BTR0_BRP4_MASK              16U
#define CAN4BTR0_BRP5_MASK              32U
#define CAN4BTR0_SJW0_MASK              64U
#define CAN4BTR0_SJW1_MASK              128U
#define CAN4BTR0_BRP_MASK               63U
#define CAN4BTR0_BRP_BITNUM             0U
#define CAN4BTR0_SJW_MASK               192U
#define CAN4BTR0_SJW_BITNUM             6U


/*** CAN4BTR1 - MSCAN4 Bus Timing Register 1; 0x00000283 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN4BTR1STR;
extern volatile CAN4BTR1STR _CAN4BTR1 @(REG_BASE + 0x00000283UL);
#define CAN4BTR1                        _CAN4BTR1.Byte
#define CAN4BTR1_TSEG10                 _CAN4BTR1.Bits.TSEG10
#define CAN4BTR1_TSEG11                 _CAN4BTR1.Bits.TSEG11
#define CAN4BTR1_TSEG12                 _CAN4BTR1.Bits.TSEG12
#define CAN4BTR1_TSEG13                 _CAN4BTR1.Bits.TSEG13
#define CAN4BTR1_TSEG20                 _CAN4BTR1.Bits.TSEG20
#define CAN4BTR1_TSEG21                 _CAN4BTR1.Bits.TSEG21
#define CAN4BTR1_TSEG22                 _CAN4BTR1.Bits.TSEG22
#define CAN4BTR1_SAMP                   _CAN4BTR1.Bits.SAMP
#define CAN4BTR1_TSEG_10                _CAN4BTR1.MergedBits.grpTSEG_10
#define CAN4BTR1_TSEG_20                _CAN4BTR1.MergedBits.grpTSEG_20
#define CAN4BTR1_TSEG                   CAN4BTR1_TSEG_10

#define CAN4BTR1_TSEG10_MASK            1U
#define CAN4BTR1_TSEG11_MASK            2U
#define CAN4BTR1_TSEG12_MASK            4U
#define CAN4BTR1_TSEG13_MASK            8U
#define CAN4BTR1_TSEG20_MASK            16U
#define CAN4BTR1_TSEG21_MASK            32U
#define CAN4BTR1_TSEG22_MASK            64U
#define CAN4BTR1_SAMP_MASK              128U
#define CAN4BTR1_TSEG_10_MASK           15U
#define CAN4BTR1_TSEG_10_BITNUM         0U
#define CAN4BTR1_TSEG_20_MASK           112U
#define CAN4BTR1_TSEG_20_BITNUM         4U


/*** CAN4RFLG - MSCAN4 Receiver Flag Register; 0x00000284 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4RFLGSTR;
extern volatile CAN4RFLGSTR _CAN4RFLG @(REG_BASE + 0x00000284UL);
#define CAN4RFLG                        _CAN4RFLG.Byte
#define CAN4RFLG_RXF                    _CAN4RFLG.Bits.RXF
#define CAN4RFLG_OVRIF                  _CAN4RFLG.Bits.OVRIF
#define CAN4RFLG_TSTAT0                 _CAN4RFLG.Bits.TSTAT0
#define CAN4RFLG_TSTAT1                 _CAN4RFLG.Bits.TSTAT1
#define CAN4RFLG_RSTAT0                 _CAN4RFLG.Bits.RSTAT0
#define CAN4RFLG_RSTAT1                 _CAN4RFLG.Bits.RSTAT1
#define CAN4RFLG_CSCIF                  _CAN4RFLG.Bits.CSCIF
#define CAN4RFLG_WUPIF                  _CAN4RFLG.Bits.WUPIF
#define CAN4RFLG_TSTAT                  _CAN4RFLG.MergedBits.grpTSTAT
#define CAN4RFLG_RSTAT                  _CAN4RFLG.MergedBits.grpRSTAT

#define CAN4RFLG_RXF_MASK               1U
#define CAN4RFLG_OVRIF_MASK             2U
#define CAN4RFLG_TSTAT0_MASK            4U
#define CAN4RFLG_TSTAT1_MASK            8U
#define CAN4RFLG_RSTAT0_MASK            16U
#define CAN4RFLG_RSTAT1_MASK            32U
#define CAN4RFLG_CSCIF_MASK             64U
#define CAN4RFLG_WUPIF_MASK             128U
#define CAN4RFLG_TSTAT_MASK             12U
#define CAN4RFLG_TSTAT_BITNUM           2U
#define CAN4RFLG_RSTAT_MASK             48U
#define CAN4RFLG_RSTAT_BITNUM           4U


/*** CAN4RIER - MSCAN4 Receiver Interrupt Enable Register; 0x00000285 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4RIERSTR;
extern volatile CAN4RIERSTR _CAN4RIER @(REG_BASE + 0x00000285UL);
#define CAN4RIER                        _CAN4RIER.Byte
#define CAN4RIER_RXFIE                  _CAN4RIER.Bits.RXFIE
#define CAN4RIER_OVRIE                  _CAN4RIER.Bits.OVRIE
#define CAN4RIER_TSTATE0                _CAN4RIER.Bits.TSTATE0
#define CAN4RIER_TSTATE1                _CAN4RIER.Bits.TSTATE1
#define CAN4RIER_RSTATE0                _CAN4RIER.Bits.RSTATE0
#define CAN4RIER_RSTATE1                _CAN4RIER.Bits.RSTATE1
#define CAN4RIER_CSCIE                  _CAN4RIER.Bits.CSCIE
#define CAN4RIER_WUPIE                  _CAN4RIER.Bits.WUPIE
#define CAN4RIER_TSTATE                 _CAN4RIER.MergedBits.grpTSTATE
#define CAN4RIER_RSTATE                 _CAN4RIER.MergedBits.grpRSTATE

#define CAN4RIER_RXFIE_MASK             1U
#define CAN4RIER_OVRIE_MASK             2U
#define CAN4RIER_TSTATE0_MASK           4U
#define CAN4RIER_TSTATE1_MASK           8U
#define CAN4RIER_RSTATE0_MASK           16U
#define CAN4RIER_RSTATE1_MASK           32U
#define CAN4RIER_CSCIE_MASK             64U
#define CAN4RIER_WUPIE_MASK             128U
#define CAN4RIER_TSTATE_MASK            12U
#define CAN4RIER_TSTATE_BITNUM          2U
#define CAN4RIER_RSTATE_MASK            48U
#define CAN4RIER_RSTATE_BITNUM          4U


/*** CAN4TFLG - MSCAN4 Transmitter Flag Register; 0x00000286 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4TFLGSTR;
extern volatile CAN4TFLGSTR _CAN4TFLG @(REG_BASE + 0x00000286UL);
#define CAN4TFLG                        _CAN4TFLG.Byte
#define CAN4TFLG_TXE0                   _CAN4TFLG.Bits.TXE0
#define CAN4TFLG_TXE1                   _CAN4TFLG.Bits.TXE1
#define CAN4TFLG_TXE2                   _CAN4TFLG.Bits.TXE2
#define CAN4TFLG_TXE                    _CAN4TFLG.MergedBits.grpTXE

#define CAN4TFLG_TXE0_MASK              1U
#define CAN4TFLG_TXE1_MASK              2U
#define CAN4TFLG_TXE2_MASK              4U
#define CAN4TFLG_TXE_MASK               7U
#define CAN4TFLG_TXE_BITNUM             0U


/*** CAN4TIER - MSCAN4 Transmitter Interrupt Enable Register; 0x00000287 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4TIERSTR;
extern volatile CAN4TIERSTR _CAN4TIER @(REG_BASE + 0x00000287UL);
#define CAN4TIER                        _CAN4TIER.Byte
#define CAN4TIER_TXEIE0                 _CAN4TIER.Bits.TXEIE0
#define CAN4TIER_TXEIE1                 _CAN4TIER.Bits.TXEIE1
#define CAN4TIER_TXEIE2                 _CAN4TIER.Bits.TXEIE2
#define CAN4TIER_TXEIE                  _CAN4TIER.MergedBits.grpTXEIE

#define CAN4TIER_TXEIE0_MASK            1U
#define CAN4TIER_TXEIE1_MASK            2U
#define CAN4TIER_TXEIE2_MASK            4U
#define CAN4TIER_TXEIE_MASK             7U
#define CAN4TIER_TXEIE_BITNUM           0U


/*** CAN4TARQ - MSCAN4 Transmitter Message Abort Request; 0x00000288 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4TARQSTR;
extern volatile CAN4TARQSTR _CAN4TARQ @(REG_BASE + 0x00000288UL);
#define CAN4TARQ                        _CAN4TARQ.Byte
#define CAN4TARQ_ABTRQ0                 _CAN4TARQ.Bits.ABTRQ0
#define CAN4TARQ_ABTRQ1                 _CAN4TARQ.Bits.ABTRQ1
#define CAN4TARQ_ABTRQ2                 _CAN4TARQ.Bits.ABTRQ2
#define CAN4TARQ_ABTRQ                  _CAN4TARQ.MergedBits.grpABTRQ

#define CAN4TARQ_ABTRQ0_MASK            1U
#define CAN4TARQ_ABTRQ1_MASK            2U
#define CAN4TARQ_ABTRQ2_MASK            4U
#define CAN4TARQ_ABTRQ_MASK             7U
#define CAN4TARQ_ABTRQ_BITNUM           0U


/*** CAN4TAAK - MSCAN4 Transmitter Message Abort Acknowledge; 0x00000289 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4TAAKSTR;
extern volatile CAN4TAAKSTR _CAN4TAAK @(REG_BASE + 0x00000289UL);
#define CAN4TAAK                        _CAN4TAAK.Byte
#define CAN4TAAK_ABTAK0                 _CAN4TAAK.Bits.ABTAK0
#define CAN4TAAK_ABTAK1                 _CAN4TAAK.Bits.ABTAK1
#define CAN4TAAK_ABTAK2                 _CAN4TAAK.Bits.ABTAK2
#define CAN4TAAK_ABTAK                  _CAN4TAAK.MergedBits.grpABTAK

#define CAN4TAAK_ABTAK0_MASK            1U
#define CAN4TAAK_ABTAK1_MASK            2U
#define CAN4TAAK_ABTAK2_MASK            4U
#define CAN4TAAK_ABTAK_MASK             7U
#define CAN4TAAK_ABTAK_BITNUM           0U


/*** CAN4TBSEL - MSCAN4 Transmit Buffer Selection; 0x0000028A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4TBSELSTR;
extern volatile CAN4TBSELSTR _CAN4TBSEL @(REG_BASE + 0x0000028AUL);
#define CAN4TBSEL                       _CAN4TBSEL.Byte
#define CAN4TBSEL_TX0                   _CAN4TBSEL.Bits.TX0
#define CAN4TBSEL_TX1                   _CAN4TBSEL.Bits.TX1
#define CAN4TBSEL_TX2                   _CAN4TBSEL.Bits.TX2
#define CAN4TBSEL_TX                    _CAN4TBSEL.MergedBits.grpTX

#define CAN4TBSEL_TX0_MASK              1U
#define CAN4TBSEL_TX1_MASK              2U
#define CAN4TBSEL_TX2_MASK              4U
#define CAN4TBSEL_TX_MASK               7U
#define CAN4TBSEL_TX_BITNUM             0U


/*** CAN4IDAC - MSCAN4 Identifier Acceptance Control Register; 0x0000028B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4IDACSTR;
extern volatile CAN4IDACSTR _CAN4IDAC @(REG_BASE + 0x0000028BUL);
#define CAN4IDAC                        _CAN4IDAC.Byte
#define CAN4IDAC_IDHIT0                 _CAN4IDAC.Bits.IDHIT0
#define CAN4IDAC_IDHIT1                 _CAN4IDAC.Bits.IDHIT1
#define CAN4IDAC_IDHIT2                 _CAN4IDAC.Bits.IDHIT2
#define CAN4IDAC_IDAM0                  _CAN4IDAC.Bits.IDAM0
#define CAN4IDAC_IDAM1                  _CAN4IDAC.Bits.IDAM1
#define CAN4IDAC_IDHIT                  _CAN4IDAC.MergedBits.grpIDHIT
#define CAN4IDAC_IDAM                   _CAN4IDAC.MergedBits.grpIDAM

#define CAN4IDAC_IDHIT0_MASK            1U
#define CAN4IDAC_IDHIT1_MASK            2U
#define CAN4IDAC_IDHIT2_MASK            4U
#define CAN4IDAC_IDAM0_MASK             16U
#define CAN4IDAC_IDAM1_MASK             32U
#define CAN4IDAC_IDHIT_MASK             7U
#define CAN4IDAC_IDHIT_BITNUM           0U
#define CAN4IDAC_IDAM_MASK              48U
#define CAN4IDAC_IDAM_BITNUM            4U


/*** CAN4MISC - MSCAN4 Miscellaneous Register; 0x0000028D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-off State Hold Until User Request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN4MISCSTR;
extern volatile CAN4MISCSTR _CAN4MISC @(REG_BASE + 0x0000028DUL);
#define CAN4MISC                        _CAN4MISC.Byte
#define CAN4MISC_BOHOLD                 _CAN4MISC.Bits.BOHOLD

#define CAN4MISC_BOHOLD_MASK            1U


/*** CAN4RXERR - MSCAN4 Receive Error Counter Register; 0x0000028E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN4RXERRSTR;
extern volatile CAN4RXERRSTR _CAN4RXERR @(REG_BASE + 0x0000028EUL);
#define CAN4RXERR                       _CAN4RXERR.Byte
#define CAN4RXERR_RXERR0                _CAN4RXERR.Bits.RXERR0
#define CAN4RXERR_RXERR1                _CAN4RXERR.Bits.RXERR1
#define CAN4RXERR_RXERR2                _CAN4RXERR.Bits.RXERR2
#define CAN4RXERR_RXERR3                _CAN4RXERR.Bits.RXERR3
#define CAN4RXERR_RXERR4                _CAN4RXERR.Bits.RXERR4
#define CAN4RXERR_RXERR5                _CAN4RXERR.Bits.RXERR5
#define CAN4RXERR_RXERR6                _CAN4RXERR.Bits.RXERR6
#define CAN4RXERR_RXERR7                _CAN4RXERR.Bits.RXERR7

#define CAN4RXERR_RXERR0_MASK           1U
#define CAN4RXERR_RXERR1_MASK           2U
#define CAN4RXERR_RXERR2_MASK           4U
#define CAN4RXERR_RXERR3_MASK           8U
#define CAN4RXERR_RXERR4_MASK           16U
#define CAN4RXERR_RXERR5_MASK           32U
#define CAN4RXERR_RXERR6_MASK           64U
#define CAN4RXERR_RXERR7_MASK           128U


/*** CAN4TXERR - MSCAN4 Transmit Error Counter Register; 0x0000028F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN4TXERRSTR;
extern volatile CAN4TXERRSTR _CAN4TXERR @(REG_BASE + 0x0000028FUL);
#define CAN4TXERR                       _CAN4TXERR.Byte
#define CAN4TXERR_TXERR0                _CAN4TXERR.Bits.TXERR0
#define CAN4TXERR_TXERR1                _CAN4TXERR.Bits.TXERR1
#define CAN4TXERR_TXERR2                _CAN4TXERR.Bits.TXERR2
#define CAN4TXERR_TXERR3                _CAN4TXERR.Bits.TXERR3
#define CAN4TXERR_TXERR4                _CAN4TXERR.Bits.TXERR4
#define CAN4TXERR_TXERR5                _CAN4TXERR.Bits.TXERR5
#define CAN4TXERR_TXERR6                _CAN4TXERR.Bits.TXERR6
#define CAN4TXERR_TXERR7                _CAN4TXERR.Bits.TXERR7

#define CAN4TXERR_TXERR0_MASK           1U
#define CAN4TXERR_TXERR1_MASK           2U
#define CAN4TXERR_TXERR2_MASK           4U
#define CAN4TXERR_TXERR3_MASK           8U
#define CAN4TXERR_TXERR4_MASK           16U
#define CAN4TXERR_TXERR5_MASK           32U
#define CAN4TXERR_TXERR6_MASK           64U
#define CAN4TXERR_TXERR7_MASK           128U


/*** CAN4IDAR0 - MSCAN4 Identifier Acceptance Register 0; 0x00000290 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN4IDAR0STR;
extern volatile CAN4IDAR0STR _CAN4IDAR0 @(REG_BASE + 0x00000290UL);
#define CAN4IDAR0                       _CAN4IDAR0.Byte
#define CAN4IDAR0_AC0                   _CAN4IDAR0.Bits.AC0
#define CAN4IDAR0_AC1                   _CAN4IDAR0.Bits.AC1
#define CAN4IDAR0_AC2                   _CAN4IDAR0.Bits.AC2
#define CAN4IDAR0_AC3                   _CAN4IDAR0.Bits.AC3
#define CAN4IDAR0_AC4                   _CAN4IDAR0.Bits.AC4
#define CAN4IDAR0_AC5                   _CAN4IDAR0.Bits.AC5
#define CAN4IDAR0_AC6                   _CAN4IDAR0.Bits.AC6
#define CAN4IDAR0_AC7                   _CAN4IDAR0.Bits.AC7
/* CAN4IDAR_ARR: Access 4 CAN4IDARx registers in an array */
#define CAN4IDAR_ARR                    ((volatile byte *) &CAN4IDAR0)

#define CAN4IDAR0_AC0_MASK              1U
#define CAN4IDAR0_AC1_MASK              2U
#define CAN4IDAR0_AC2_MASK              4U
#define CAN4IDAR0_AC3_MASK              8U
#define CAN4IDAR0_AC4_MASK              16U
#define CAN4IDAR0_AC5_MASK              32U
#define CAN4IDAR0_AC6_MASK              64U
#define CAN4IDAR0_AC7_MASK              128U


/*** CAN4IDAR1 - MSCAN4 Identifier Acceptance Register 1; 0x00000291 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN4IDAR1STR;
extern volatile CAN4IDAR1STR _CAN4IDAR1 @(REG_BASE + 0x00000291UL);
#define CAN4IDAR1                       _CAN4IDAR1.Byte
#define CAN4IDAR1_AC0                   _CAN4IDAR1.Bits.AC0
#define CAN4IDAR1_AC1                   _CAN4IDAR1.Bits.AC1
#define CAN4IDAR1_AC2                   _CAN4IDAR1.Bits.AC2
#define CAN4IDAR1_AC3                   _CAN4IDAR1.Bits.AC3
#define CAN4IDAR1_AC4                   _CAN4IDAR1.Bits.AC4
#define CAN4IDAR1_AC5                   _CAN4IDAR1.Bits.AC5
#define CAN4IDAR1_AC6                   _CAN4IDAR1.Bits.AC6
#define CAN4IDAR1_AC7                   _CAN4IDAR1.Bits.AC7

#define CAN4IDAR1_AC0_MASK              1U
#define CAN4IDAR1_AC1_MASK              2U
#define CAN4IDAR1_AC2_MASK              4U
#define CAN4IDAR1_AC3_MASK              8U
#define CAN4IDAR1_AC4_MASK              16U
#define CAN4IDAR1_AC5_MASK              32U
#define CAN4IDAR1_AC6_MASK              64U
#define CAN4IDAR1_AC7_MASK              128U


/*** CAN4IDAR2 - MSCAN4 Identifier Acceptance Register 2; 0x00000292 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN4IDAR2STR;
extern volatile CAN4IDAR2STR _CAN4IDAR2 @(REG_BASE + 0x00000292UL);
#define CAN4IDAR2                       _CAN4IDAR2.Byte
#define CAN4IDAR2_AC0                   _CAN4IDAR2.Bits.AC0
#define CAN4IDAR2_AC1                   _CAN4IDAR2.Bits.AC1
#define CAN4IDAR2_AC2                   _CAN4IDAR2.Bits.AC2
#define CAN4IDAR2_AC3                   _CAN4IDAR2.Bits.AC3
#define CAN4IDAR2_AC4                   _CAN4IDAR2.Bits.AC4
#define CAN4IDAR2_AC5                   _CAN4IDAR2.Bits.AC5
#define CAN4IDAR2_AC6                   _CAN4IDAR2.Bits.AC6
#define CAN4IDAR2_AC7                   _CAN4IDAR2.Bits.AC7

#define CAN4IDAR2_AC0_MASK              1U
#define CAN4IDAR2_AC1_MASK              2U
#define CAN4IDAR2_AC2_MASK              4U
#define CAN4IDAR2_AC3_MASK              8U
#define CAN4IDAR2_AC4_MASK              16U
#define CAN4IDAR2_AC5_MASK              32U
#define CAN4IDAR2_AC6_MASK              64U
#define CAN4IDAR2_AC7_MASK              128U


/*** CAN4IDAR3 - MSCAN4 Identifier Acceptance Register 3; 0x00000293 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN4IDAR3STR;
extern volatile CAN4IDAR3STR _CAN4IDAR3 @(REG_BASE + 0x00000293UL);
#define CAN4IDAR3                       _CAN4IDAR3.Byte
#define CAN4IDAR3_AC0                   _CAN4IDAR3.Bits.AC0
#define CAN4IDAR3_AC1                   _CAN4IDAR3.Bits.AC1
#define CAN4IDAR3_AC2                   _CAN4IDAR3.Bits.AC2
#define CAN4IDAR3_AC3                   _CAN4IDAR3.Bits.AC3
#define CAN4IDAR3_AC4                   _CAN4IDAR3.Bits.AC4
#define CAN4IDAR3_AC5                   _CAN4IDAR3.Bits.AC5
#define CAN4IDAR3_AC6                   _CAN4IDAR3.Bits.AC6
#define CAN4IDAR3_AC7                   _CAN4IDAR3.Bits.AC7

#define CAN4IDAR3_AC0_MASK              1U
#define CAN4IDAR3_AC1_MASK              2U
#define CAN4IDAR3_AC2_MASK              4U
#define CAN4IDAR3_AC3_MASK              8U
#define CAN4IDAR3_AC4_MASK              16U
#define CAN4IDAR3_AC5_MASK              32U
#define CAN4IDAR3_AC6_MASK              64U
#define CAN4IDAR3_AC7_MASK              128U


/*** CAN4IDMR0 - MSCAN4 Identifier Mask Register 0; 0x00000294 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN4IDMR0STR;
extern volatile CAN4IDMR0STR _CAN4IDMR0 @(REG_BASE + 0x00000294UL);
#define CAN4IDMR0                       _CAN4IDMR0.Byte
#define CAN4IDMR0_AM0                   _CAN4IDMR0.Bits.AM0
#define CAN4IDMR0_AM1                   _CAN4IDMR0.Bits.AM1
#define CAN4IDMR0_AM2                   _CAN4IDMR0.Bits.AM2
#define CAN4IDMR0_AM3                   _CAN4IDMR0.Bits.AM3
#define CAN4IDMR0_AM4                   _CAN4IDMR0.Bits.AM4
#define CAN4IDMR0_AM5                   _CAN4IDMR0.Bits.AM5
#define CAN4IDMR0_AM6                   _CAN4IDMR0.Bits.AM6
#define CAN4IDMR0_AM7                   _CAN4IDMR0.Bits.AM7
/* CAN4IDMR_ARR: Access 4 CAN4IDMRx registers in an array */
#define CAN4IDMR_ARR                    ((volatile byte *) &CAN4IDMR0)

#define CAN4IDMR0_AM0_MASK              1U
#define CAN4IDMR0_AM1_MASK              2U
#define CAN4IDMR0_AM2_MASK              4U
#define CAN4IDMR0_AM3_MASK              8U
#define CAN4IDMR0_AM4_MASK              16U
#define CAN4IDMR0_AM5_MASK              32U
#define CAN4IDMR0_AM6_MASK              64U
#define CAN4IDMR0_AM7_MASK              128U


/*** CAN4IDMR1 - MSCAN4 Identifier Mask Register 1; 0x00000295 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN4IDMR1STR;
extern volatile CAN4IDMR1STR _CAN4IDMR1 @(REG_BASE + 0x00000295UL);
#define CAN4IDMR1                       _CAN4IDMR1.Byte
#define CAN4IDMR1_AM0                   _CAN4IDMR1.Bits.AM0
#define CAN4IDMR1_AM1                   _CAN4IDMR1.Bits.AM1
#define CAN4IDMR1_AM2                   _CAN4IDMR1.Bits.AM2
#define CAN4IDMR1_AM3                   _CAN4IDMR1.Bits.AM3
#define CAN4IDMR1_AM4                   _CAN4IDMR1.Bits.AM4
#define CAN4IDMR1_AM5                   _CAN4IDMR1.Bits.AM5
#define CAN4IDMR1_AM6                   _CAN4IDMR1.Bits.AM6
#define CAN4IDMR1_AM7                   _CAN4IDMR1.Bits.AM7

#define CAN4IDMR1_AM0_MASK              1U
#define CAN4IDMR1_AM1_MASK              2U
#define CAN4IDMR1_AM2_MASK              4U
#define CAN4IDMR1_AM3_MASK              8U
#define CAN4IDMR1_AM4_MASK              16U
#define CAN4IDMR1_AM5_MASK              32U
#define CAN4IDMR1_AM6_MASK              64U
#define CAN4IDMR1_AM7_MASK              128U


/*** CAN4IDMR2 - MSCAN4 Identifier Mask Register 2; 0x00000296 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN4IDMR2STR;
extern volatile CAN4IDMR2STR _CAN4IDMR2 @(REG_BASE + 0x00000296UL);
#define CAN4IDMR2                       _CAN4IDMR2.Byte
#define CAN4IDMR2_AM0                   _CAN4IDMR2.Bits.AM0
#define CAN4IDMR2_AM1                   _CAN4IDMR2.Bits.AM1
#define CAN4IDMR2_AM2                   _CAN4IDMR2.Bits.AM2
#define CAN4IDMR2_AM3                   _CAN4IDMR2.Bits.AM3
#define CAN4IDMR2_AM4                   _CAN4IDMR2.Bits.AM4
#define CAN4IDMR2_AM5                   _CAN4IDMR2.Bits.AM5
#define CAN4IDMR2_AM6                   _CAN4IDMR2.Bits.AM6
#define CAN4IDMR2_AM7                   _CAN4IDMR2.Bits.AM7

#define CAN4IDMR2_AM0_MASK              1U
#define CAN4IDMR2_AM1_MASK              2U
#define CAN4IDMR2_AM2_MASK              4U
#define CAN4IDMR2_AM3_MASK              8U
#define CAN4IDMR2_AM4_MASK              16U
#define CAN4IDMR2_AM5_MASK              32U
#define CAN4IDMR2_AM6_MASK              64U
#define CAN4IDMR2_AM7_MASK              128U


/*** CAN4IDMR3 - MSCAN4 Identifier Mask Register 3; 0x00000297 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN4IDMR3STR;
extern volatile CAN4IDMR3STR _CAN4IDMR3 @(REG_BASE + 0x00000297UL);
#define CAN4IDMR3                       _CAN4IDMR3.Byte
#define CAN4IDMR3_AM0                   _CAN4IDMR3.Bits.AM0
#define CAN4IDMR3_AM1                   _CAN4IDMR3.Bits.AM1
#define CAN4IDMR3_AM2                   _CAN4IDMR3.Bits.AM2
#define CAN4IDMR3_AM3                   _CAN4IDMR3.Bits.AM3
#define CAN4IDMR3_AM4                   _CAN4IDMR3.Bits.AM4
#define CAN4IDMR3_AM5                   _CAN4IDMR3.Bits.AM5
#define CAN4IDMR3_AM6                   _CAN4IDMR3.Bits.AM6
#define CAN4IDMR3_AM7                   _CAN4IDMR3.Bits.AM7

#define CAN4IDMR3_AM0_MASK              1U
#define CAN4IDMR3_AM1_MASK              2U
#define CAN4IDMR3_AM2_MASK              4U
#define CAN4IDMR3_AM3_MASK              8U
#define CAN4IDMR3_AM4_MASK              16U
#define CAN4IDMR3_AM5_MASK              32U
#define CAN4IDMR3_AM6_MASK              64U
#define CAN4IDMR3_AM7_MASK              128U


/*** CAN4IDAR4 - MSCAN4 Identifier Acceptance Register 4; 0x00000298 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN4IDAR4STR;
extern volatile CAN4IDAR4STR _CAN4IDAR4 @(REG_BASE + 0x00000298UL);
#define CAN4IDAR4                       _CAN4IDAR4.Byte
#define CAN4IDAR4_AC0                   _CAN4IDAR4.Bits.AC0
#define CAN4IDAR4_AC1                   _CAN4IDAR4.Bits.AC1
#define CAN4IDAR4_AC2                   _CAN4IDAR4.Bits.AC2
#define CAN4IDAR4_AC3                   _CAN4IDAR4.Bits.AC3
#define CAN4IDAR4_AC4                   _CAN4IDAR4.Bits.AC4
#define CAN4IDAR4_AC5                   _CAN4IDAR4.Bits.AC5
#define CAN4IDAR4_AC6                   _CAN4IDAR4.Bits.AC6
#define CAN4IDAR4_AC7                   _CAN4IDAR4.Bits.AC7

#define CAN4IDAR4_AC0_MASK              1U
#define CAN4IDAR4_AC1_MASK              2U
#define CAN4IDAR4_AC2_MASK              4U
#define CAN4IDAR4_AC3_MASK              8U
#define CAN4IDAR4_AC4_MASK              16U
#define CAN4IDAR4_AC5_MASK              32U
#define CAN4IDAR4_AC6_MASK              64U
#define CAN4IDAR4_AC7_MASK              128U


/*** CAN4IDAR5 - MSCAN4 Identifier Acceptance Register 5; 0x00000299 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN4IDAR5STR;
extern volatile CAN4IDAR5STR _CAN4IDAR5 @(REG_BASE + 0x00000299UL);
#define CAN4IDAR5                       _CAN4IDAR5.Byte
#define CAN4IDAR5_AC0                   _CAN4IDAR5.Bits.AC0
#define CAN4IDAR5_AC1                   _CAN4IDAR5.Bits.AC1
#define CAN4IDAR5_AC2                   _CAN4IDAR5.Bits.AC2
#define CAN4IDAR5_AC3                   _CAN4IDAR5.Bits.AC3
#define CAN4IDAR5_AC4                   _CAN4IDAR5.Bits.AC4
#define CAN4IDAR5_AC5                   _CAN4IDAR5.Bits.AC5
#define CAN4IDAR5_AC6                   _CAN4IDAR5.Bits.AC6
#define CAN4IDAR5_AC7                   _CAN4IDAR5.Bits.AC7

#define CAN4IDAR5_AC0_MASK              1U
#define CAN4IDAR5_AC1_MASK              2U
#define CAN4IDAR5_AC2_MASK              4U
#define CAN4IDAR5_AC3_MASK              8U
#define CAN4IDAR5_AC4_MASK              16U
#define CAN4IDAR5_AC5_MASK              32U
#define CAN4IDAR5_AC6_MASK              64U
#define CAN4IDAR5_AC7_MASK              128U


/*** CAN4IDAR6 - MSCAN4 Identifier Acceptance Register 6; 0x0000029A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN4IDAR6STR;
extern volatile CAN4IDAR6STR _CAN4IDAR6 @(REG_BASE + 0x0000029AUL);
#define CAN4IDAR6                       _CAN4IDAR6.Byte
#define CAN4IDAR6_AC0                   _CAN4IDAR6.Bits.AC0
#define CAN4IDAR6_AC1                   _CAN4IDAR6.Bits.AC1
#define CAN4IDAR6_AC2                   _CAN4IDAR6.Bits.AC2
#define CAN4IDAR6_AC3                   _CAN4IDAR6.Bits.AC3
#define CAN4IDAR6_AC4                   _CAN4IDAR6.Bits.AC4
#define CAN4IDAR6_AC5                   _CAN4IDAR6.Bits.AC5
#define CAN4IDAR6_AC6                   _CAN4IDAR6.Bits.AC6
#define CAN4IDAR6_AC7                   _CAN4IDAR6.Bits.AC7

#define CAN4IDAR6_AC0_MASK              1U
#define CAN4IDAR6_AC1_MASK              2U
#define CAN4IDAR6_AC2_MASK              4U
#define CAN4IDAR6_AC3_MASK              8U
#define CAN4IDAR6_AC4_MASK              16U
#define CAN4IDAR6_AC5_MASK              32U
#define CAN4IDAR6_AC6_MASK              64U
#define CAN4IDAR6_AC7_MASK              128U


/*** CAN4IDAR7 - MSCAN4 Identifier Acceptance Register 7; 0x0000029B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN4IDAR7STR;
extern volatile CAN4IDAR7STR _CAN4IDAR7 @(REG_BASE + 0x0000029BUL);
#define CAN4IDAR7                       _CAN4IDAR7.Byte
#define CAN4IDAR7_AC0                   _CAN4IDAR7.Bits.AC0
#define CAN4IDAR7_AC1                   _CAN4IDAR7.Bits.AC1
#define CAN4IDAR7_AC2                   _CAN4IDAR7.Bits.AC2
#define CAN4IDAR7_AC3                   _CAN4IDAR7.Bits.AC3
#define CAN4IDAR7_AC4                   _CAN4IDAR7.Bits.AC4
#define CAN4IDAR7_AC5                   _CAN4IDAR7.Bits.AC5
#define CAN4IDAR7_AC6                   _CAN4IDAR7.Bits.AC6
#define CAN4IDAR7_AC7                   _CAN4IDAR7.Bits.AC7

#define CAN4IDAR7_AC0_MASK              1U
#define CAN4IDAR7_AC1_MASK              2U
#define CAN4IDAR7_AC2_MASK              4U
#define CAN4IDAR7_AC3_MASK              8U
#define CAN4IDAR7_AC4_MASK              16U
#define CAN4IDAR7_AC5_MASK              32U
#define CAN4IDAR7_AC6_MASK              64U
#define CAN4IDAR7_AC7_MASK              128U


/*** CAN4IDMR4 - MSCAN4 Identifier Mask Register 4; 0x0000029C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN4IDMR4STR;
extern volatile CAN4IDMR4STR _CAN4IDMR4 @(REG_BASE + 0x0000029CUL);
#define CAN4IDMR4                       _CAN4IDMR4.Byte
#define CAN4IDMR4_AM0                   _CAN4IDMR4.Bits.AM0
#define CAN4IDMR4_AM1                   _CAN4IDMR4.Bits.AM1
#define CAN4IDMR4_AM2                   _CAN4IDMR4.Bits.AM2
#define CAN4IDMR4_AM3                   _CAN4IDMR4.Bits.AM3
#define CAN4IDMR4_AM4                   _CAN4IDMR4.Bits.AM4
#define CAN4IDMR4_AM5                   _CAN4IDMR4.Bits.AM5
#define CAN4IDMR4_AM6                   _CAN4IDMR4.Bits.AM6
#define CAN4IDMR4_AM7                   _CAN4IDMR4.Bits.AM7

#define CAN4IDMR4_AM0_MASK              1U
#define CAN4IDMR4_AM1_MASK              2U
#define CAN4IDMR4_AM2_MASK              4U
#define CAN4IDMR4_AM3_MASK              8U
#define CAN4IDMR4_AM4_MASK              16U
#define CAN4IDMR4_AM5_MASK              32U
#define CAN4IDMR4_AM6_MASK              64U
#define CAN4IDMR4_AM7_MASK              128U


/*** CAN4IDMR5 - MSCAN4 Identifier Mask Register 5; 0x0000029D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN4IDMR5STR;
extern volatile CAN4IDMR5STR _CAN4IDMR5 @(REG_BASE + 0x0000029DUL);
#define CAN4IDMR5                       _CAN4IDMR5.Byte
#define CAN4IDMR5_AM0                   _CAN4IDMR5.Bits.AM0
#define CAN4IDMR5_AM1                   _CAN4IDMR5.Bits.AM1
#define CAN4IDMR5_AM2                   _CAN4IDMR5.Bits.AM2
#define CAN4IDMR5_AM3                   _CAN4IDMR5.Bits.AM3
#define CAN4IDMR5_AM4                   _CAN4IDMR5.Bits.AM4
#define CAN4IDMR5_AM5                   _CAN4IDMR5.Bits.AM5
#define CAN4IDMR5_AM6                   _CAN4IDMR5.Bits.AM6
#define CAN4IDMR5_AM7                   _CAN4IDMR5.Bits.AM7

#define CAN4IDMR5_AM0_MASK              1U
#define CAN4IDMR5_AM1_MASK              2U
#define CAN4IDMR5_AM2_MASK              4U
#define CAN4IDMR5_AM3_MASK              8U
#define CAN4IDMR5_AM4_MASK              16U
#define CAN4IDMR5_AM5_MASK              32U
#define CAN4IDMR5_AM6_MASK              64U
#define CAN4IDMR5_AM7_MASK              128U


/*** CAN4IDMR6 - MSCAN4 Identifier Mask Register 6; 0x0000029E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN4IDMR6STR;
extern volatile CAN4IDMR6STR _CAN4IDMR6 @(REG_BASE + 0x0000029EUL);
#define CAN4IDMR6                       _CAN4IDMR6.Byte
#define CAN4IDMR6_AM0                   _CAN4IDMR6.Bits.AM0
#define CAN4IDMR6_AM1                   _CAN4IDMR6.Bits.AM1
#define CAN4IDMR6_AM2                   _CAN4IDMR6.Bits.AM2
#define CAN4IDMR6_AM3                   _CAN4IDMR6.Bits.AM3
#define CAN4IDMR6_AM4                   _CAN4IDMR6.Bits.AM4
#define CAN4IDMR6_AM5                   _CAN4IDMR6.Bits.AM5
#define CAN4IDMR6_AM6                   _CAN4IDMR6.Bits.AM6
#define CAN4IDMR6_AM7                   _CAN4IDMR6.Bits.AM7

#define CAN4IDMR6_AM0_MASK              1U
#define CAN4IDMR6_AM1_MASK              2U
#define CAN4IDMR6_AM2_MASK              4U
#define CAN4IDMR6_AM3_MASK              8U
#define CAN4IDMR6_AM4_MASK              16U
#define CAN4IDMR6_AM5_MASK              32U
#define CAN4IDMR6_AM6_MASK              64U
#define CAN4IDMR6_AM7_MASK              128U


/*** CAN4IDMR7 - MSCAN4 Identifier Mask Register 7; 0x0000029F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN4IDMR7STR;
extern volatile CAN4IDMR7STR _CAN4IDMR7 @(REG_BASE + 0x0000029FUL);
#define CAN4IDMR7                       _CAN4IDMR7.Byte
#define CAN4IDMR7_AM0                   _CAN4IDMR7.Bits.AM0
#define CAN4IDMR7_AM1                   _CAN4IDMR7.Bits.AM1
#define CAN4IDMR7_AM2                   _CAN4IDMR7.Bits.AM2
#define CAN4IDMR7_AM3                   _CAN4IDMR7.Bits.AM3
#define CAN4IDMR7_AM4                   _CAN4IDMR7.Bits.AM4
#define CAN4IDMR7_AM5                   _CAN4IDMR7.Bits.AM5
#define CAN4IDMR7_AM6                   _CAN4IDMR7.Bits.AM6
#define CAN4IDMR7_AM7                   _CAN4IDMR7.Bits.AM7

#define CAN4IDMR7_AM0_MASK              1U
#define CAN4IDMR7_AM1_MASK              2U
#define CAN4IDMR7_AM2_MASK              4U
#define CAN4IDMR7_AM3_MASK              8U
#define CAN4IDMR7_AM4_MASK              16U
#define CAN4IDMR7_AM5_MASK              32U
#define CAN4IDMR7_AM6_MASK              64U
#define CAN4IDMR7_AM7_MASK              128U


/*** CAN4RXIDR0 - MSCAN4 Receive Identifier Register 0; 0x000002A0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN4RXIDR0STR;
extern volatile CAN4RXIDR0STR _CAN4RXIDR0 @(REG_BASE + 0x000002A0UL);
#define CAN4RXIDR0                      _CAN4RXIDR0.Byte
#define CAN4RXIDR0_ID21                 _CAN4RXIDR0.Bits.ID21
#define CAN4RXIDR0_ID22                 _CAN4RXIDR0.Bits.ID22
#define CAN4RXIDR0_ID23                 _CAN4RXIDR0.Bits.ID23
#define CAN4RXIDR0_ID24                 _CAN4RXIDR0.Bits.ID24
#define CAN4RXIDR0_ID25                 _CAN4RXIDR0.Bits.ID25
#define CAN4RXIDR0_ID26                 _CAN4RXIDR0.Bits.ID26
#define CAN4RXIDR0_ID27                 _CAN4RXIDR0.Bits.ID27
#define CAN4RXIDR0_ID28                 _CAN4RXIDR0.Bits.ID28
/* CAN4RXIDR_ARR: Access 4 CAN4RXIDRx registers in an array */
#define CAN4RXIDR_ARR                   ((volatile byte *) &CAN4RXIDR0)

#define CAN4RXIDR0_ID21_MASK            1U
#define CAN4RXIDR0_ID22_MASK            2U
#define CAN4RXIDR0_ID23_MASK            4U
#define CAN4RXIDR0_ID24_MASK            8U
#define CAN4RXIDR0_ID25_MASK            16U
#define CAN4RXIDR0_ID26_MASK            32U
#define CAN4RXIDR0_ID27_MASK            64U
#define CAN4RXIDR0_ID28_MASK            128U


/*** CAN4RXIDR1 - MSCAN4 Receive Identifier Register 1; 0x000002A1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN4RXIDR1STR;
extern volatile CAN4RXIDR1STR _CAN4RXIDR1 @(REG_BASE + 0x000002A1UL);
#define CAN4RXIDR1                      _CAN4RXIDR1.Byte
#define CAN4RXIDR1_ID15                 _CAN4RXIDR1.Bits.ID15
#define CAN4RXIDR1_ID16                 _CAN4RXIDR1.Bits.ID16
#define CAN4RXIDR1_ID17                 _CAN4RXIDR1.Bits.ID17
#define CAN4RXIDR1_IDE                  _CAN4RXIDR1.Bits.IDE
#define CAN4RXIDR1_SRR                  _CAN4RXIDR1.Bits.SRR
#define CAN4RXIDR1_ID18                 _CAN4RXIDR1.Bits.ID18
#define CAN4RXIDR1_ID19                 _CAN4RXIDR1.Bits.ID19
#define CAN4RXIDR1_ID20                 _CAN4RXIDR1.Bits.ID20
#define CAN4RXIDR1_ID_15                _CAN4RXIDR1.MergedBits.grpID_15
#define CAN4RXIDR1_ID_18                _CAN4RXIDR1.MergedBits.grpID_18
#define CAN4RXIDR1_ID                   CAN4RXIDR1_ID_15

#define CAN4RXIDR1_ID15_MASK            1U
#define CAN4RXIDR1_ID16_MASK            2U
#define CAN4RXIDR1_ID17_MASK            4U
#define CAN4RXIDR1_IDE_MASK             8U
#define CAN4RXIDR1_SRR_MASK             16U
#define CAN4RXIDR1_ID18_MASK            32U
#define CAN4RXIDR1_ID19_MASK            64U
#define CAN4RXIDR1_ID20_MASK            128U
#define CAN4RXIDR1_ID_15_MASK           7U
#define CAN4RXIDR1_ID_15_BITNUM         0U
#define CAN4RXIDR1_ID_18_MASK           224U
#define CAN4RXIDR1_ID_18_BITNUM         5U


/*** CAN4RXIDR2 - MSCAN4 Receive Identifier Register 2; 0x000002A2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN4RXIDR2STR;
extern volatile CAN4RXIDR2STR _CAN4RXIDR2 @(REG_BASE + 0x000002A2UL);
#define CAN4RXIDR2                      _CAN4RXIDR2.Byte
#define CAN4RXIDR2_ID7                  _CAN4RXIDR2.Bits.ID7
#define CAN4RXIDR2_ID8                  _CAN4RXIDR2.Bits.ID8
#define CAN4RXIDR2_ID9                  _CAN4RXIDR2.Bits.ID9
#define CAN4RXIDR2_ID10                 _CAN4RXIDR2.Bits.ID10
#define CAN4RXIDR2_ID11                 _CAN4RXIDR2.Bits.ID11
#define CAN4RXIDR2_ID12                 _CAN4RXIDR2.Bits.ID12
#define CAN4RXIDR2_ID13                 _CAN4RXIDR2.Bits.ID13
#define CAN4RXIDR2_ID14                 _CAN4RXIDR2.Bits.ID14

#define CAN4RXIDR2_ID7_MASK             1U
#define CAN4RXIDR2_ID8_MASK             2U
#define CAN4RXIDR2_ID9_MASK             4U
#define CAN4RXIDR2_ID10_MASK            8U
#define CAN4RXIDR2_ID11_MASK            16U
#define CAN4RXIDR2_ID12_MASK            32U
#define CAN4RXIDR2_ID13_MASK            64U
#define CAN4RXIDR2_ID14_MASK            128U


/*** CAN4RXIDR3 - MSCAN4 Receive Identifier Register 3; 0x000002A3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN4RXIDR3STR;
extern volatile CAN4RXIDR3STR _CAN4RXIDR3 @(REG_BASE + 0x000002A3UL);
#define CAN4RXIDR3                      _CAN4RXIDR3.Byte
#define CAN4RXIDR3_RTR                  _CAN4RXIDR3.Bits.RTR
#define CAN4RXIDR3_ID0                  _CAN4RXIDR3.Bits.ID0
#define CAN4RXIDR3_ID1                  _CAN4RXIDR3.Bits.ID1
#define CAN4RXIDR3_ID2                  _CAN4RXIDR3.Bits.ID2
#define CAN4RXIDR3_ID3                  _CAN4RXIDR3.Bits.ID3
#define CAN4RXIDR3_ID4                  _CAN4RXIDR3.Bits.ID4
#define CAN4RXIDR3_ID5                  _CAN4RXIDR3.Bits.ID5
#define CAN4RXIDR3_ID6                  _CAN4RXIDR3.Bits.ID6
#define CAN4RXIDR3_ID                   _CAN4RXIDR3.MergedBits.grpID

#define CAN4RXIDR3_RTR_MASK             1U
#define CAN4RXIDR3_ID0_MASK             2U
#define CAN4RXIDR3_ID1_MASK             4U
#define CAN4RXIDR3_ID2_MASK             8U
#define CAN4RXIDR3_ID3_MASK             16U
#define CAN4RXIDR3_ID4_MASK             32U
#define CAN4RXIDR3_ID5_MASK             64U
#define CAN4RXIDR3_ID6_MASK             128U
#define CAN4RXIDR3_ID_MASK              254U
#define CAN4RXIDR3_ID_BITNUM            1U


/*** CAN4RXDSR0 - MSCAN4 Receive Data Segment Register 0; 0x000002A4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN4RXDSR0STR;
extern volatile CAN4RXDSR0STR _CAN4RXDSR0 @(REG_BASE + 0x000002A4UL);
#define CAN4RXDSR0                      _CAN4RXDSR0.Byte
#define CAN4RXDSR0_DB0                  _CAN4RXDSR0.Bits.DB0
#define CAN4RXDSR0_DB1                  _CAN4RXDSR0.Bits.DB1
#define CAN4RXDSR0_DB2                  _CAN4RXDSR0.Bits.DB2
#define CAN4RXDSR0_DB3                  _CAN4RXDSR0.Bits.DB3
#define CAN4RXDSR0_DB4                  _CAN4RXDSR0.Bits.DB4
#define CAN4RXDSR0_DB5                  _CAN4RXDSR0.Bits.DB5
#define CAN4RXDSR0_DB6                  _CAN4RXDSR0.Bits.DB6
#define CAN4RXDSR0_DB7                  _CAN4RXDSR0.Bits.DB7
/* CAN4RXDSR_ARR: Access 8 CAN4RXDSRx registers in an array */
#define CAN4RXDSR_ARR                   ((volatile byte *) &CAN4RXDSR0)

#define CAN4RXDSR0_DB0_MASK             1U
#define CAN4RXDSR0_DB1_MASK             2U
#define CAN4RXDSR0_DB2_MASK             4U
#define CAN4RXDSR0_DB3_MASK             8U
#define CAN4RXDSR0_DB4_MASK             16U
#define CAN4RXDSR0_DB5_MASK             32U
#define CAN4RXDSR0_DB6_MASK             64U
#define CAN4RXDSR0_DB7_MASK             128U


/*** CAN4RXDSR1 - MSCAN4 Receive Data Segment Register 1; 0x000002A5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN4RXDSR1STR;
extern volatile CAN4RXDSR1STR _CAN4RXDSR1 @(REG_BASE + 0x000002A5UL);
#define CAN4RXDSR1                      _CAN4RXDSR1.Byte
#define CAN4RXDSR1_DB0                  _CAN4RXDSR1.Bits.DB0
#define CAN4RXDSR1_DB1                  _CAN4RXDSR1.Bits.DB1
#define CAN4RXDSR1_DB2                  _CAN4RXDSR1.Bits.DB2
#define CAN4RXDSR1_DB3                  _CAN4RXDSR1.Bits.DB3
#define CAN4RXDSR1_DB4                  _CAN4RXDSR1.Bits.DB4
#define CAN4RXDSR1_DB5                  _CAN4RXDSR1.Bits.DB5
#define CAN4RXDSR1_DB6                  _CAN4RXDSR1.Bits.DB6
#define CAN4RXDSR1_DB7                  _CAN4RXDSR1.Bits.DB7

#define CAN4RXDSR1_DB0_MASK             1U
#define CAN4RXDSR1_DB1_MASK             2U
#define CAN4RXDSR1_DB2_MASK             4U
#define CAN4RXDSR1_DB3_MASK             8U
#define CAN4RXDSR1_DB4_MASK             16U
#define CAN4RXDSR1_DB5_MASK             32U
#define CAN4RXDSR1_DB6_MASK             64U
#define CAN4RXDSR1_DB7_MASK             128U


/*** CAN4RXDSR2 - MSCAN4 Receive Data Segment Register 2; 0x000002A6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN4RXDSR2STR;
extern volatile CAN4RXDSR2STR _CAN4RXDSR2 @(REG_BASE + 0x000002A6UL);
#define CAN4RXDSR2                      _CAN4RXDSR2.Byte
#define CAN4RXDSR2_DB0                  _CAN4RXDSR2.Bits.DB0
#define CAN4RXDSR2_DB1                  _CAN4RXDSR2.Bits.DB1
#define CAN4RXDSR2_DB2                  _CAN4RXDSR2.Bits.DB2
#define CAN4RXDSR2_DB3                  _CAN4RXDSR2.Bits.DB3
#define CAN4RXDSR2_DB4                  _CAN4RXDSR2.Bits.DB4
#define CAN4RXDSR2_DB5                  _CAN4RXDSR2.Bits.DB5
#define CAN4RXDSR2_DB6                  _CAN4RXDSR2.Bits.DB6
#define CAN4RXDSR2_DB7                  _CAN4RXDSR2.Bits.DB7

#define CAN4RXDSR2_DB0_MASK             1U
#define CAN4RXDSR2_DB1_MASK             2U
#define CAN4RXDSR2_DB2_MASK             4U
#define CAN4RXDSR2_DB3_MASK             8U
#define CAN4RXDSR2_DB4_MASK             16U
#define CAN4RXDSR2_DB5_MASK             32U
#define CAN4RXDSR2_DB6_MASK             64U
#define CAN4RXDSR2_DB7_MASK             128U


/*** CAN4RXDSR3 - MSCAN4 Receive Data Segment Register 3; 0x000002A7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN4RXDSR3STR;
extern volatile CAN4RXDSR3STR _CAN4RXDSR3 @(REG_BASE + 0x000002A7UL);
#define CAN4RXDSR3                      _CAN4RXDSR3.Byte
#define CAN4RXDSR3_DB0                  _CAN4RXDSR3.Bits.DB0
#define CAN4RXDSR3_DB1                  _CAN4RXDSR3.Bits.DB1
#define CAN4RXDSR3_DB2                  _CAN4RXDSR3.Bits.DB2
#define CAN4RXDSR3_DB3                  _CAN4RXDSR3.Bits.DB3
#define CAN4RXDSR3_DB4                  _CAN4RXDSR3.Bits.DB4
#define CAN4RXDSR3_DB5                  _CAN4RXDSR3.Bits.DB5
#define CAN4RXDSR3_DB6                  _CAN4RXDSR3.Bits.DB6
#define CAN4RXDSR3_DB7                  _CAN4RXDSR3.Bits.DB7

#define CAN4RXDSR3_DB0_MASK             1U
#define CAN4RXDSR3_DB1_MASK             2U
#define CAN4RXDSR3_DB2_MASK             4U
#define CAN4RXDSR3_DB3_MASK             8U
#define CAN4RXDSR3_DB4_MASK             16U
#define CAN4RXDSR3_DB5_MASK             32U
#define CAN4RXDSR3_DB6_MASK             64U
#define CAN4RXDSR3_DB7_MASK             128U


/*** CAN4RXDSR4 - MSCAN4 Receive Data Segment Register 4; 0x000002A8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN4RXDSR4STR;
extern volatile CAN4RXDSR4STR _CAN4RXDSR4 @(REG_BASE + 0x000002A8UL);
#define CAN4RXDSR4                      _CAN4RXDSR4.Byte
#define CAN4RXDSR4_DB0                  _CAN4RXDSR4.Bits.DB0
#define CAN4RXDSR4_DB1                  _CAN4RXDSR4.Bits.DB1
#define CAN4RXDSR4_DB2                  _CAN4RXDSR4.Bits.DB2
#define CAN4RXDSR4_DB3                  _CAN4RXDSR4.Bits.DB3
#define CAN4RXDSR4_DB4                  _CAN4RXDSR4.Bits.DB4
#define CAN4RXDSR4_DB5                  _CAN4RXDSR4.Bits.DB5
#define CAN4RXDSR4_DB6                  _CAN4RXDSR4.Bits.DB6
#define CAN4RXDSR4_DB7                  _CAN4RXDSR4.Bits.DB7

#define CAN4RXDSR4_DB0_MASK             1U
#define CAN4RXDSR4_DB1_MASK             2U
#define CAN4RXDSR4_DB2_MASK             4U
#define CAN4RXDSR4_DB3_MASK             8U
#define CAN4RXDSR4_DB4_MASK             16U
#define CAN4RXDSR4_DB5_MASK             32U
#define CAN4RXDSR4_DB6_MASK             64U
#define CAN4RXDSR4_DB7_MASK             128U


/*** CAN4RXDSR5 - MSCAN4 Receive Data Segment Register 5; 0x000002A9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN4RXDSR5STR;
extern volatile CAN4RXDSR5STR _CAN4RXDSR5 @(REG_BASE + 0x000002A9UL);
#define CAN4RXDSR5                      _CAN4RXDSR5.Byte
#define CAN4RXDSR5_DB0                  _CAN4RXDSR5.Bits.DB0
#define CAN4RXDSR5_DB1                  _CAN4RXDSR5.Bits.DB1
#define CAN4RXDSR5_DB2                  _CAN4RXDSR5.Bits.DB2
#define CAN4RXDSR5_DB3                  _CAN4RXDSR5.Bits.DB3
#define CAN4RXDSR5_DB4                  _CAN4RXDSR5.Bits.DB4
#define CAN4RXDSR5_DB5                  _CAN4RXDSR5.Bits.DB5
#define CAN4RXDSR5_DB6                  _CAN4RXDSR5.Bits.DB6
#define CAN4RXDSR5_DB7                  _CAN4RXDSR5.Bits.DB7

#define CAN4RXDSR5_DB0_MASK             1U
#define CAN4RXDSR5_DB1_MASK             2U
#define CAN4RXDSR5_DB2_MASK             4U
#define CAN4RXDSR5_DB3_MASK             8U
#define CAN4RXDSR5_DB4_MASK             16U
#define CAN4RXDSR5_DB5_MASK             32U
#define CAN4RXDSR5_DB6_MASK             64U
#define CAN4RXDSR5_DB7_MASK             128U


/*** CAN4RXDSR6 - MSCAN4 Receive Data Segment Register 6; 0x000002AA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN4RXDSR6STR;
extern volatile CAN4RXDSR6STR _CAN4RXDSR6 @(REG_BASE + 0x000002AAUL);
#define CAN4RXDSR6                      _CAN4RXDSR6.Byte
#define CAN4RXDSR6_DB0                  _CAN4RXDSR6.Bits.DB0
#define CAN4RXDSR6_DB1                  _CAN4RXDSR6.Bits.DB1
#define CAN4RXDSR6_DB2                  _CAN4RXDSR6.Bits.DB2
#define CAN4RXDSR6_DB3                  _CAN4RXDSR6.Bits.DB3
#define CAN4RXDSR6_DB4                  _CAN4RXDSR6.Bits.DB4
#define CAN4RXDSR6_DB5                  _CAN4RXDSR6.Bits.DB5
#define CAN4RXDSR6_DB6                  _CAN4RXDSR6.Bits.DB6
#define CAN4RXDSR6_DB7                  _CAN4RXDSR6.Bits.DB7

#define CAN4RXDSR6_DB0_MASK             1U
#define CAN4RXDSR6_DB1_MASK             2U
#define CAN4RXDSR6_DB2_MASK             4U
#define CAN4RXDSR6_DB3_MASK             8U
#define CAN4RXDSR6_DB4_MASK             16U
#define CAN4RXDSR6_DB5_MASK             32U
#define CAN4RXDSR6_DB6_MASK             64U
#define CAN4RXDSR6_DB7_MASK             128U


/*** CAN4RXDSR7 - MSCAN4 Receive Data Segment Register 7; 0x000002AB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN4RXDSR7STR;
extern volatile CAN4RXDSR7STR _CAN4RXDSR7 @(REG_BASE + 0x000002ABUL);
#define CAN4RXDSR7                      _CAN4RXDSR7.Byte
#define CAN4RXDSR7_DB0                  _CAN4RXDSR7.Bits.DB0
#define CAN4RXDSR7_DB1                  _CAN4RXDSR7.Bits.DB1
#define CAN4RXDSR7_DB2                  _CAN4RXDSR7.Bits.DB2
#define CAN4RXDSR7_DB3                  _CAN4RXDSR7.Bits.DB3
#define CAN4RXDSR7_DB4                  _CAN4RXDSR7.Bits.DB4
#define CAN4RXDSR7_DB5                  _CAN4RXDSR7.Bits.DB5
#define CAN4RXDSR7_DB6                  _CAN4RXDSR7.Bits.DB6
#define CAN4RXDSR7_DB7                  _CAN4RXDSR7.Bits.DB7

#define CAN4RXDSR7_DB0_MASK             1U
#define CAN4RXDSR7_DB1_MASK             2U
#define CAN4RXDSR7_DB2_MASK             4U
#define CAN4RXDSR7_DB3_MASK             8U
#define CAN4RXDSR7_DB4_MASK             16U
#define CAN4RXDSR7_DB5_MASK             32U
#define CAN4RXDSR7_DB6_MASK             64U
#define CAN4RXDSR7_DB7_MASK             128U


/*** CAN4RXDLR - MSCAN4 Receive Data Length Register; 0x000002AC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN4RXDLRSTR;
extern volatile CAN4RXDLRSTR _CAN4RXDLR @(REG_BASE + 0x000002ACUL);
#define CAN4RXDLR                       _CAN4RXDLR.Byte
#define CAN4RXDLR_DLC0                  _CAN4RXDLR.Bits.DLC0
#define CAN4RXDLR_DLC1                  _CAN4RXDLR.Bits.DLC1
#define CAN4RXDLR_DLC2                  _CAN4RXDLR.Bits.DLC2
#define CAN4RXDLR_DLC3                  _CAN4RXDLR.Bits.DLC3
#define CAN4RXDLR_DLC                   _CAN4RXDLR.MergedBits.grpDLC

#define CAN4RXDLR_DLC0_MASK             1U
#define CAN4RXDLR_DLC1_MASK             2U
#define CAN4RXDLR_DLC2_MASK             4U
#define CAN4RXDLR_DLC3_MASK             8U
#define CAN4RXDLR_DLC_MASK              15U
#define CAN4RXDLR_DLC_BITNUM            0U


/*** CAN4RXTSR - MSCAN4 Receive Time Stamp Register; 0x000002AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN4RXTSRH - MSCAN4 Receive Time Stamp Register High; 0x000002AE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN4RXTSRHSTR;
    #define CAN4RXTSRH                  _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Byte
    #define CAN4RXTSRH_TSR8             _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Bits.TSR8
    #define CAN4RXTSRH_TSR9             _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Bits.TSR9
    #define CAN4RXTSRH_TSR10            _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Bits.TSR10
    #define CAN4RXTSRH_TSR11            _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Bits.TSR11
    #define CAN4RXTSRH_TSR12            _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Bits.TSR12
    #define CAN4RXTSRH_TSR13            _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Bits.TSR13
    #define CAN4RXTSRH_TSR14            _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Bits.TSR14
    #define CAN4RXTSRH_TSR15            _CAN4RXTSR.Overlap_STR.CAN4RXTSRHSTR.Bits.TSR15
    
    #define CAN4RXTSRH_TSR8_MASK        1U
    #define CAN4RXTSRH_TSR9_MASK        2U
    #define CAN4RXTSRH_TSR10_MASK       4U
    #define CAN4RXTSRH_TSR11_MASK       8U
    #define CAN4RXTSRH_TSR12_MASK       16U
    #define CAN4RXTSRH_TSR13_MASK       32U
    #define CAN4RXTSRH_TSR14_MASK       64U
    #define CAN4RXTSRH_TSR15_MASK       128U
    

    /*** CAN4RXTSRL - MSCAN4 Receive Time Stamp Register Low; 0x000002AF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN4RXTSRLSTR;
    #define CAN4RXTSRL                  _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Byte
    #define CAN4RXTSRL_TSR0             _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Bits.TSR0
    #define CAN4RXTSRL_TSR1             _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Bits.TSR1
    #define CAN4RXTSRL_TSR2             _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Bits.TSR2
    #define CAN4RXTSRL_TSR3             _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Bits.TSR3
    #define CAN4RXTSRL_TSR4             _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Bits.TSR4
    #define CAN4RXTSRL_TSR5             _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Bits.TSR5
    #define CAN4RXTSRL_TSR6             _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Bits.TSR6
    #define CAN4RXTSRL_TSR7             _CAN4RXTSR.Overlap_STR.CAN4RXTSRLSTR.Bits.TSR7
    
    #define CAN4RXTSRL_TSR0_MASK        1U
    #define CAN4RXTSRL_TSR1_MASK        2U
    #define CAN4RXTSRL_TSR2_MASK        4U
    #define CAN4RXTSRL_TSR3_MASK        8U
    #define CAN4RXTSRL_TSR4_MASK        16U
    #define CAN4RXTSRL_TSR5_MASK        32U
    #define CAN4RXTSRL_TSR6_MASK        64U
    #define CAN4RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN4RXTSRSTR;
extern volatile CAN4RXTSRSTR _CAN4RXTSR @(REG_BASE + 0x000002AEUL);
#define CAN4RXTSR                       _CAN4RXTSR.Word
#define CAN4RXTSR_TSR0                  _CAN4RXTSR.Bits.TSR0
#define CAN4RXTSR_TSR1                  _CAN4RXTSR.Bits.TSR1
#define CAN4RXTSR_TSR2                  _CAN4RXTSR.Bits.TSR2
#define CAN4RXTSR_TSR3                  _CAN4RXTSR.Bits.TSR3
#define CAN4RXTSR_TSR4                  _CAN4RXTSR.Bits.TSR4
#define CAN4RXTSR_TSR5                  _CAN4RXTSR.Bits.TSR5
#define CAN4RXTSR_TSR6                  _CAN4RXTSR.Bits.TSR6
#define CAN4RXTSR_TSR7                  _CAN4RXTSR.Bits.TSR7
#define CAN4RXTSR_TSR8                  _CAN4RXTSR.Bits.TSR8
#define CAN4RXTSR_TSR9                  _CAN4RXTSR.Bits.TSR9
#define CAN4RXTSR_TSR10                 _CAN4RXTSR.Bits.TSR10
#define CAN4RXTSR_TSR11                 _CAN4RXTSR.Bits.TSR11
#define CAN4RXTSR_TSR12                 _CAN4RXTSR.Bits.TSR12
#define CAN4RXTSR_TSR13                 _CAN4RXTSR.Bits.TSR13
#define CAN4RXTSR_TSR14                 _CAN4RXTSR.Bits.TSR14
#define CAN4RXTSR_TSR15                 _CAN4RXTSR.Bits.TSR15

#define CAN4RXTSR_TSR0_MASK             1U
#define CAN4RXTSR_TSR1_MASK             2U
#define CAN4RXTSR_TSR2_MASK             4U
#define CAN4RXTSR_TSR3_MASK             8U
#define CAN4RXTSR_TSR4_MASK             16U
#define CAN4RXTSR_TSR5_MASK             32U
#define CAN4RXTSR_TSR6_MASK             64U
#define CAN4RXTSR_TSR7_MASK             128U
#define CAN4RXTSR_TSR8_MASK             256U
#define CAN4RXTSR_TSR9_MASK             512U
#define CAN4RXTSR_TSR10_MASK            1024U
#define CAN4RXTSR_TSR11_MASK            2048U
#define CAN4RXTSR_TSR12_MASK            4096U
#define CAN4RXTSR_TSR13_MASK            8192U
#define CAN4RXTSR_TSR14_MASK            16384U
#define CAN4RXTSR_TSR15_MASK            32768U


/*** CAN4TXIDR0 - MSCAN4 Transmit Identifier Register 0; 0x000002B0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN4TXIDR0STR;
extern volatile CAN4TXIDR0STR _CAN4TXIDR0 @(REG_BASE + 0x000002B0UL);
#define CAN4TXIDR0                      _CAN4TXIDR0.Byte
#define CAN4TXIDR0_ID21                 _CAN4TXIDR0.Bits.ID21
#define CAN4TXIDR0_ID22                 _CAN4TXIDR0.Bits.ID22
#define CAN4TXIDR0_ID23                 _CAN4TXIDR0.Bits.ID23
#define CAN4TXIDR0_ID24                 _CAN4TXIDR0.Bits.ID24
#define CAN4TXIDR0_ID25                 _CAN4TXIDR0.Bits.ID25
#define CAN4TXIDR0_ID26                 _CAN4TXIDR0.Bits.ID26
#define CAN4TXIDR0_ID27                 _CAN4TXIDR0.Bits.ID27
#define CAN4TXIDR0_ID28                 _CAN4TXIDR0.Bits.ID28
/* CAN4TXIDR_ARR: Access 4 CAN4TXIDRx registers in an array */
#define CAN4TXIDR_ARR                   ((volatile byte *) &CAN4TXIDR0)

#define CAN4TXIDR0_ID21_MASK            1U
#define CAN4TXIDR0_ID22_MASK            2U
#define CAN4TXIDR0_ID23_MASK            4U
#define CAN4TXIDR0_ID24_MASK            8U
#define CAN4TXIDR0_ID25_MASK            16U
#define CAN4TXIDR0_ID26_MASK            32U
#define CAN4TXIDR0_ID27_MASK            64U
#define CAN4TXIDR0_ID28_MASK            128U


/*** CAN4TXIDR1 - MSCAN4 Transmit Identifier Register 1; 0x000002B1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN4TXIDR1STR;
extern volatile CAN4TXIDR1STR _CAN4TXIDR1 @(REG_BASE + 0x000002B1UL);
#define CAN4TXIDR1                      _CAN4TXIDR1.Byte
#define CAN4TXIDR1_ID15                 _CAN4TXIDR1.Bits.ID15
#define CAN4TXIDR1_ID16                 _CAN4TXIDR1.Bits.ID16
#define CAN4TXIDR1_ID17                 _CAN4TXIDR1.Bits.ID17
#define CAN4TXIDR1_IDE                  _CAN4TXIDR1.Bits.IDE
#define CAN4TXIDR1_SRR                  _CAN4TXIDR1.Bits.SRR
#define CAN4TXIDR1_ID18                 _CAN4TXIDR1.Bits.ID18
#define CAN4TXIDR1_ID19                 _CAN4TXIDR1.Bits.ID19
#define CAN4TXIDR1_ID20                 _CAN4TXIDR1.Bits.ID20
#define CAN4TXIDR1_ID_15                _CAN4TXIDR1.MergedBits.grpID_15
#define CAN4TXIDR1_ID_18                _CAN4TXIDR1.MergedBits.grpID_18
#define CAN4TXIDR1_ID                   CAN4TXIDR1_ID_15

#define CAN4TXIDR1_ID15_MASK            1U
#define CAN4TXIDR1_ID16_MASK            2U
#define CAN4TXIDR1_ID17_MASK            4U
#define CAN4TXIDR1_IDE_MASK             8U
#define CAN4TXIDR1_SRR_MASK             16U
#define CAN4TXIDR1_ID18_MASK            32U
#define CAN4TXIDR1_ID19_MASK            64U
#define CAN4TXIDR1_ID20_MASK            128U
#define CAN4TXIDR1_ID_15_MASK           7U
#define CAN4TXIDR1_ID_15_BITNUM         0U
#define CAN4TXIDR1_ID_18_MASK           224U
#define CAN4TXIDR1_ID_18_BITNUM         5U


/*** CAN4TXIDR2 - MSCAN4 Transmit Identifier Register 2; 0x000002B2 ***/
typedef union {
  byte Byte;
  struct 