; Based on CPU DB MC9S12XDT512_144, version 2.87.228 (RegistersPrg V2.28)

; ###################################################################
;     Filename  : mc9s12xdt512.inc
;     Processor : MC9S12XDT512BCFV
;     FileFormat: V2.28
;     DataSheet : MC9S12XDP512RMV2 Rev. 2.18 May 2008
;     Compiler  : CodeWarrior compiler
;     Date/Time : 2.7.2009, 9:19
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;      - 23.05.2006, V2.87.115:
;              - Added register ATD1TEST1. REASON: Bug in data sheet (Rev. 2.12)
;      - 24.05.2006, V2.87.116:
;              - Removed bits MCCNTlo_BIT0..MCCNTlo_BIT7 and MCCNThi_BIT8.. MCCNThi_BIT15. REASON: Bug-fix (#3166 in Issue Manager)
;      - 29.08.2007, V2.87.182:
;              -  Added bit DBGXCTL_BRK, Renamed bits DBGXDH_BIT0..7 ==> DBGXDH_BIT8..15. REASON: Bug-fix (#5173 in Issue Manager).
;      - 29.08.2007, V2.87.184:
;              -   Added register DBGMFR. REASON: Bug-fix(#5173 in the Issue Manager).
;      - 03.09.2007, V2.87.189:
;              -  Added register XGCCR, Renamed groups XGCHID_XGCHIDGrp ==> XGCHID_XGCHID,  XGVBR_XGVBRGrp ==> XGVBR_XGVBR, XGSWT_XGSWTGrp ==> XGSWT_XGSWT, XGSEM_XGSEMGrp ==> XGSEM_XGSEM, Renamed registers XGIFn ==> XGIF_nF_n0. REASON: Bug-fix (#5180 in Issue Manager). 
;              -  Removed bits PAxH_BIT0..BIT7/15, TCxH..BIT0..BIT7/15. REASON: Access to the individual bits is not necessary (issue #5192 in Issue Manager).
;      - 05.09.2007, V2.87.193:
;              - Added registers FCTL, NVFCTL, EADDR, EDATA, FADDR, FDATA. Added bits COPCTL_WRTMASK, MMCCTL0_CS3E, FCNFG_BKSEL0..1, FSTAT_FAIL, ESTAT_FAIL. Renamed group INT_CFADDRGrp ==> INT_CFADDR, Renamed bit NVFPROT_NV6 ==> NVFPROT_RNV6.\nCorrected bits in register NVFSEC[SEC0:1,NV2:NV6,KEYEN] ==> NVFSEC[SEC0:1,RNV2:RNV5,KEYEN0:1].\nREASON: Bug-fix (issue #5204 in the Issue Manager).
;      - 01.10.2007, V2.87.196:
;              -  Renamed bit SCIxCR2_SCTIE ==> SCIxCR2_TIE.
;              -  REASON: Bug-fix (#4855 in Issue Manager).
;      - 01.10.2007, V2.87.198:
;              -  Added bits EDATAHI_EDHI0..7, EDATALO_EDLO0..7.
;              - REASON:  Bug-fix (#5204 in Issue Manager).
;      - 14.11.2008, V2.87.229:
;              - Corrected definition of depreciated symbols.
;              -   REASON: Bug-fix(#6592 in Issue Manager).
;
;     File-Format-Revisions:
;      - 14.11.2005, V2.00 :
;               - Deprecated symbols added for backward compatibility (section at the end of this file)
;      - 15.11.2005, V2.01 :
;               - Fixed invalid instruction in macro __RESET_WATCHDOG for HCS12 family.
;      - 17.12.2005, V2.02 :
;               - Arrays (symbols xx_ARR) are defined as pointer to volatile, see issue #2778
;      - 16.01.2006, V2.03 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #2920.
;               - "volatile" modifier removed from declaration of non volatile registers (that contain modifier "const")
;      - 08.03.2006, V2.04 :
;               - Support for bit(s) names duplicated with any register name in .h header files
;      - 24.03.2006, V2.05 :
;               - Fixed macro __RESET_WATCHDOG for HCS12 family - address and correct write order.
;      - 26.04.2006, V2.06 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.04.2006, V2.07 :
;               - Fixed macro __RESET_WATCHDOG for HCS12, HCS12X ,HCS08 DZ and HCS08 EN derivatives (write 0x55,0xAA).
;      - 07.06.2006, V2.08 :
;               - Changes have not affected this file (because they are related to another family)
;      - 03.07.2006, V2.09 :
;               - Changes have not affected this file (because they are related to another family)
;      - 27.10.2006, V2.10 :
;               - __RESET_WATCHDOG improved formating and re-definition
;      - 23.11.2006, V2.11 :
;               - Changes have not affected this file (because they are related to another family)
;      - 22.01.2007, V2.12 :
;               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
;      - 01.03.2007, V2.13 :
;               - Flash commands constants values converted to HEX format
;      - 02.03.2007, V2.14 :
;               - Interrupt vector numbers added into .H, see VectorNumber_*
;      - 26.03.2007, V2.15 :
;               - Changes have not affected this file (because they are related to another family)
;      - 10.05.2007, V2.16 :
;               - Changes have not affected this file (because they are related to another family)
;      - 05.06.2007, V2.17 :
;               - Changes have not affected this file (because they are related to another family)
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               - Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               - Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               - Termination of pragma V30toV31Compatible added, #5708
;      - 03.07.2008, V2.24 :
;               - Added support for bits with name starting with number (like "1HZ")
;      - 28.11.2008, V2.25 :
;               - StandBy RAM array declaration for ANSI-C added
;      - 1.12.2008, V2.26 :
;               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
;      - 17.3.2009, V2.27 :
;               - Merged bit-group is not generated, if the name matches with another bit name in the register
;      - 6.4.2009, V2.28 :
;               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
EEPROMStart:        equ   $00000C00
EEPROMEnd:          equ   $00000FFB
RAMStart:           equ   $00002000
RAMEnd:             equ   $00003FFF
ROM_4000Start:      equ   $00004000
ROM_4000End:        equ   $00007FFF
ROM_C000Start:      equ   $0000C000
ROM_C000End:        equ   $0000FEFF
EEPROM_FCStart:     equ   $0013F000
EEPROM_FCEnd:       equ   $0013F3FF
EEPROM_FDStart:     equ   $0013F400
EEPROM_FDEnd:       equ   $0013F7FF
EEPROM_FEStart:     equ   $0013F800
EEPROM_FEEnd:       equ   $0013FBFF
RAM_FBStart:        equ   $000FB000
RAM_FBEnd:          equ   $000FBFFF
RAM_FCStart:        equ   $000FC000
RAM_FCEnd:          equ   $000FCFFF
RAM_FDStart:        equ   $000FD000
RAM_FDEnd:          equ   $000FDFFF
PAGE_E0Start:       equ   $00780000
PAGE_E0End:         equ   $00783FFF
PAGE_E1Start:       equ   $00784000
PAGE_E1End:         equ   $00787FFF
PAGE_E2Start:       equ   $00788000
PAGE_E2End:         equ   $0078BFFF
PAGE_E3Start:       equ   $0078C000
PAGE_E3End:         equ   $0078FFFF
PAGE_E4Start:       equ   $00790000
PAGE_E4End:         equ   $00793FFF
PAGE_E5Start:       equ   $00794000
PAGE_E5End:         equ   $00797FFF
PAGE_E6Start:       equ   $00798000
PAGE_E6End:         equ   $0079BFFF
PAGE_E7Start:       equ   $0079C000
PAGE_E7End:         equ   $0079FFFF
PAGE_E8Start:       equ   $007A0000
PAGE_E8End:         equ   $007A3FFF
PAGE_E9Start:       equ   $007A4000
PAGE_E9End:         equ   $007A7FFF
PAGE_EAStart:       equ   $007A8000
PAGE_EAEnd:         equ   $007ABFFF
PAGE_EBStart:       equ   $007AC000
PAGE_EBEnd:         equ   $007AFFFF
PAGE_ECStart:       equ   $007B0000
PAGE_ECEnd:         equ   $007B3FFF
PAGE_EDStart:       equ   $007B4000
PAGE_EDEnd:         equ   $007B7FFF
PAGE_EEStart:       equ   $007B8000
PAGE_EEEnd:         equ   $007BBFFF
PAGE_EFStart:       equ   $007BC000
PAGE_EFEnd:         equ   $007BFFFF
PAGE_F0Start:       equ   $007C0000
PAGE_F0End:         equ   $007C3FFF
PAGE_F1Start:       equ   $007C4000
PAGE_F1End:         equ   $007C7FFF
PAGE_F2Start:       equ   $007C8000
PAGE_F2End:         equ   $007CBFFF
PAGE_F3Start:       equ   $007CC000
PAGE_F3End:         equ   $007CFFFF
PAGE_F4Start:       equ   $007D0000
PAGE_F4End:         equ   $007D3FFF
PAGE_F5Start:       equ   $007D4000
PAGE_F5End:         equ   $007D7FFF
PAGE_F6Start:       equ   $007D8000
PAGE_F6End:         equ   $007DBFFF
PAGE_F7Start:       equ   $007DC000
PAGE_F7End:         equ   $007DFFFF
PAGE_F8Start:       equ   $007E0000
PAGE_F8End:         equ   $007E3FFF
PAGE_F9Start:       equ   $007E4000
PAGE_F9End:         equ   $007E7FFF
PAGE_FAStart:       equ   $007E8000
PAGE_FAEnd:         equ   $007EBFFF
PAGE_FBStart:       equ   $007EC000
PAGE_FBEnd:         equ   $007EFFFF
PAGE_FCStart:       equ   $007F0000
PAGE_FCEnd:         equ   $007F3FFF
PAGE_FEStart:       equ   $007F8000
PAGE_FEEnd:         equ   $007FBFFF
;
Vsi:                equ   $0000FF10
Reserved119:        equ   $0000FF12
Reserved118:        equ   $0000FF14
Reserved117:        equ   $0000FF16
Reserved116:        equ   $0000FF18
Reserved115:        equ   $0000FF1A
Reserved114:        equ   $0000FF1C
Reserved113:        equ   $0000FF1E
Reserved112:        equ   $0000FF20
Reserved111:        equ   $0000FF22
Reserved110:        equ   $0000FF24
Reserved109:        equ   $0000FF26
Reserved108:        equ   $0000FF28
Reserved107:        equ   $0000FF2A
Reserved106:        equ   $0000FF2C
Reserved105:        equ   $0000FF2E
Reserved104:        equ   $0000FF30
Reserved103:        equ   $0000FF32
Reserved102:        equ   $0000FF34
Reserved101:        equ   $0000FF36
Reserved100:        equ   $0000FF38
Reserved99:         equ   $0000FF3A
Reserved98:         equ   $0000FF3C
Reserved97:         equ   $0000FF3E
Reserved96:         equ   $0000FF40
Reserved95:         equ   $0000FF42
Reserved94:         equ   $0000FF44
Reserved93:         equ   $0000FF46
Reserved92:         equ   $0000FF48
Reserved91:         equ   $0000FF4A
Reserved90:         equ   $0000FF4C
Reserved89:         equ   $0000FF4E
Reserved88:         equ   $0000FF50
Reserved87:         equ   $0000FF52
Reserved86:         equ   $0000FF54
Reserved85:         equ   $0000FF56
Reserved84:         equ   $0000FF58
Reserved83:         equ   $0000FF5A
Reserved82:         equ   $0000FF5C
Reserved81:         equ   $0000FF5E
Vxsramav:           equ   $0000FF60
Vxsei:              equ   $0000FF62
Vxst7:              equ   $0000FF64
Vxst6:              equ   $0000FF66
Vxst5:              equ   $0000FF68
Vxst4:              equ   $0000FF6A
Vxst3:              equ   $0000FF6C
Vxst2:              equ   $0000FF6E
Vxst1:              equ   $0000FF70
Vxst0:              equ   $0000FF72
Vpit3:              equ   $0000FF74
Vpit2:              equ   $0000FF76
Vpit1:              equ   $0000FF78
Vpit0:              equ   $0000FF7A
VReserved65:        equ   $0000FF7C
Vapi:               equ   $0000FF7E
Vlvi:               equ   $0000FF80
VReserved62:        equ   $0000FF82
Vsci5:              equ   $0000FF84
Vsci4:              equ   $0000FF86
Vsci3:              equ   $0000FF88
Vsci2:              equ   $0000FF8A
Vpwmesdn:           equ   $0000FF8C
Vportp:             equ   $0000FF8E
Vcan4tx:            equ   $0000FF90
Vcan4rx:            equ   $0000FF92
Vcan4err:           equ   $0000FF94
Vcan4wkup:          equ   $0000FF96
VReserved51:        equ   $0000FF98
VReserved50:        equ   $0000FF9A
VReserved49:        equ   $0000FF9C
VReserved48:        equ   $0000FF9E
VReserved47:        equ   $0000FFA0
VReserved46:        equ   $0000FFA2
VReserved45:        equ   $0000FFA4
VReserved44:        equ   $0000FFA6
Vcan1tx:            equ   $0000FFA8
Vcan1rx:            equ   $0000FFAA
Vcan1err:           equ   $0000FFAC
Vcan1wkup:          equ   $0000FFAE
Vcan0tx:            equ   $0000FFB0
Vcan0rx:            equ   $0000FFB2
Vcan0err:           equ   $0000FFB4
Vcan0wkup:          equ   $0000FFB6
Vflash:             equ   $0000FFB8
Veeprom:            equ   $0000FFBA
Vspi2:              equ   $0000FFBC
Vspi1:              equ   $0000FFBE
Viic0:              equ   $0000FFC0
VReserved30:        equ   $0000FFC2
Vcrgscm:            equ   $0000FFC4
Vcrgplllck:         equ   $0000FFC6
Vtimpabovf:         equ   $0000FFC8
Vtimmdcu:           equ   $0000FFCA
Vporth:             equ   $0000FFCC
Vportj:             equ   $0000FFCE
Vatd1:              equ   $0000FFD0
Vatd0:              equ   $0000FFD2
Vsci1:              equ   $0000FFD4
Vsci0:              equ   $0000FFD6
Vspi0:              equ   $0000FFD8
Vtimpaie:           equ   $0000FFDA
Vtimpaaovf:         equ   $0000FFDC
Vtimovf:            equ   $0000FFDE
Vtimch7:            equ   $0000FFE0
Vtimch6:            equ   $0000FFE2
Vtimch5:            equ   $0000FFE4
Vtimch4:            equ   $0000FFE6
Vtimch3:            equ   $0000FFE8
Vtimch2:            equ   $0000FFEA
Vtimch1:            equ   $0000FFEC
Vtimch0:            equ   $0000FFEE
Vrti:               equ   $0000FFF0
Virq:               equ   $0000FFF2
Vxirq:              equ   $0000FFF4
Vswi:               equ   $0000FFF6
Vtrap:              equ   $0000FFF8
Vcop:               equ   $0000FFFA
Vclkmon:            equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PORTAB - Port AB; 0x00000000 ***
PORTAB:             equ    $00000000                                ;*** PORTAB - Port AB; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTAB_PB0:         equ    0                                         ; Port B Bit 0
PORTAB_PB1:         equ    1                                         ; Port B Bit 1
PORTAB_PB2:         equ    2                                         ; Port B Bit 2
PORTAB_PB3:         equ    3                                         ; Port B Bit 3
PORTAB_PB4:         equ    4                                         ; Port B Bit 4
PORTAB_PB5:         equ    5                                         ; Port B Bit 5
PORTAB_PB6:         equ    6                                         ; Port B Bit 6
PORTAB_PB7:         equ    7                                         ; Port B Bit 7
PORTAB_PA0:         equ    8                                         ; Port A Bit 0
PORTAB_PA1:         equ    9                                         ; Port A Bit 1
PORTAB_PA2:         equ    10                                        ; Port A Bit 2
PORTAB_PA3:         equ    11                                        ; Port A Bit 3
PORTAB_PA4:         equ    12                                        ; Port A Bit 4
PORTAB_PA5:         equ    13                                        ; Port A Bit 5
PORTAB_PA6:         equ    14                                        ; Port A Bit 6
PORTAB_PA7:         equ    15                                        ; Port A Bit 7
; bit position masks
mPORTAB_PB0:        equ    %00000001
mPORTAB_PB1:        equ    %00000010
mPORTAB_PB2:        equ    %00000100
mPORTAB_PB3:        equ    %00001000
mPORTAB_PB4:        equ    %00010000
mPORTAB_PB5:        equ    %00100000
mPORTAB_PB6:        equ    %01000000
mPORTAB_PB7:        equ    %10000000
mPORTAB_PA0:        equ    %100000000
mPORTAB_PA1:        equ    %1000000000
mPORTAB_PA2:        equ    %10000000000
mPORTAB_PA3:        equ    %100000000000
mPORTAB_PA4:        equ    %1000000000000
mPORTAB_PA5:        equ    %10000000000000
mPORTAB_PA6:        equ    %100000000000000
mPORTAB_PA7:        equ    %1000000000000000


;*** PORTA - Port A Register; 0x00000000 ***
PORTA:              equ    $00000000                                ;*** PORTA - Port A Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTA_PA0:          equ    0                                         ; Port A Bit 0
PORTA_PA1:          equ    1                                         ; Port A Bit 1
PORTA_PA2:          equ    2                                         ; Port A Bit 2
PORTA_PA3:          equ    3                                         ; Port A Bit 3
PORTA_PA4:          equ    4                                         ; Port A Bit 4
PORTA_PA5:          equ    5                                         ; Port A Bit 5
PORTA_PA6:          equ    6                                         ; Port A Bit 6
PORTA_PA7:          equ    7                                         ; Port A Bit 7
; bit position masks
mPORTA_PA0:         equ    %00000001
mPORTA_PA1:         equ    %00000010
mPORTA_PA2:         equ    %00000100
mPORTA_PA3:         equ    %00001000
mPORTA_PA4:         equ    %00010000
mPORTA_PA5:         equ    %00100000
mPORTA_PA6:         equ    %01000000
mPORTA_PA7:         equ    %10000000


;*** PORTB - Port B Register; 0x00000001 ***
PORTB:              equ    $00000001                                ;*** PORTB - Port B Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTB_PB0:          equ    0                                         ; Port B Bit 0
PORTB_PB1:          equ    1                                         ; Port B Bit 1
PORTB_PB2:          equ    2                                         ; Port B Bit 2
PORTB_PB3:          equ    3                                         ; Port B Bit 3
PORTB_PB4:          equ    4                                         ; Port B Bit 4
PORTB_PB5:          equ    5                                         ; Port B Bit 5
PORTB_PB6:          equ    6                                         ; Port B Bit 6
PORTB_PB7:          equ    7                                         ; Port B Bit 7
; bit position masks
mPORTB_PB0:         equ    %00000001
mPORTB_PB1:         equ    %00000010
mPORTB_PB2:         equ    %00000100
mPORTB_PB3:         equ    %00001000
mPORTB_PB4:         equ    %00010000
mPORTB_PB5:         equ    %00100000
mPORTB_PB6:         equ    %01000000
mPORTB_PB7:         equ    %10000000


;*** DDRAB - Port AB Data Direction; 0x00000002 ***
DDRAB:              equ    $00000002                                ;*** DDRAB - Port AB Data Direction; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRAB_DDRB0:        equ    0                                         ; Data Direction Port B Bit 0
DDRAB_DDRB1:        equ    1                                         ; Data Direction Port B Bit 1
DDRAB_DDRB2:        equ    2                                         ; Data Direction Port B Bit 2
DDRAB_DDRB3:        equ    3                                         ; Data Direction Port B Bit 3
DDRAB_DDRB4:        equ    4                                         ; Data Direction Port B Bit 4
DDRAB_DDRB5:        equ    5                                         ; Data Direction Port B Bit 5
DDRAB_DDRB6:        equ    6                                         ; Data Direction Port B Bit 6
DDRAB_DDRB7:        equ    7                                         ; Data Direction Port B Bit 7
DDRAB_DDRA0:        equ    8                                         ; Data Direction Port A Bit 0
DDRAB_DDRA1:        equ    9                                         ; Data Direction Port A Bit 1
DDRAB_DDRA2:        equ    10                                        ; Data Direction Port A Bit 2
DDRAB_DDRA3:        equ    11                                        ; Data Direction Port A Bit 3
DDRAB_DDRA4:        equ    12                                        ; Data Direction Port A Bit 4
DDRAB_DDRA5:        equ    13                                        ; Data Direction Port A Bit 5
DDRAB_DDRA6:        equ    14                                        ; Data Direction Port A Bit 6
DDRAB_DDRA7:        equ    15                                        ; Data Direction Port A Bit 7
; bit position masks
mDDRAB_DDRB0:       equ    %00000001
mDDRAB_DDRB1:       equ    %00000010
mDDRAB_DDRB2:       equ    %00000100
mDDRAB_DDRB3:       equ    %00001000
mDDRAB_DDRB4:       equ    %00010000
mDDRAB_DDRB5:       equ    %00100000
mDDRAB_DDRB6:       equ    %01000000
mDDRAB_DDRB7:       equ    %10000000
mDDRAB_DDRA0:       equ    %100000000
mDDRAB_DDRA1:       equ    %1000000000
mDDRAB_DDRA2:       equ    %10000000000
mDDRAB_DDRA3:       equ    %100000000000
mDDRAB_DDRA4:       equ    %1000000000000
mDDRAB_DDRA5:       equ    %10000000000000
mDDRAB_DDRA6:       equ    %100000000000000
mDDRAB_DDRA7:       equ    %1000000000000000


;*** DDRA - Port A Data Direction Register; 0x00000002 ***
DDRA:               equ    $00000002                                ;*** DDRA - Port A Data Direction Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRA_DDRA0:         equ    0                                         ; Data Direction Port A Bit 0
DDRA_DDRA1:         equ    1                                         ; Data Direction Port A Bit 1
DDRA_DDRA2:         equ    2                                         ; Data Direction Port A Bit 2
DDRA_DDRA3:         equ    3                                         ; Data Direction Port A Bit 3
DDRA_DDRA4:         equ    4                                         ; Data Direction Port A Bit 4
DDRA_DDRA5:         equ    5                                         ; Data Direction Port A Bit 5
DDRA_DDRA6:         equ    6                                         ; Data Direction Port A Bit 6
DDRA_DDRA7:         equ    7                                         ; Data Direction Port A Bit 7
; bit position masks
mDDRA_DDRA0:        equ    %00000001
mDDRA_DDRA1:        equ    %00000010
mDDRA_DDRA2:        equ    %00000100
mDDRA_DDRA3:        equ    %00001000
mDDRA_DDRA4:        equ    %00010000
mDDRA_DDRA5:        equ    %00100000
mDDRA_DDRA6:        equ    %01000000
mDDRA_DDRA7:        equ    %10000000


;*** DDRB - Port B Data Direction Register; 0x00000003 ***
DDRB:               equ    $00000003                                ;*** DDRB - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRB_DDRB0:         equ    0                                         ; Data Direction Port B Bit 0
DDRB_DDRB1:         equ    1                                         ; Data Direction Port B Bit 1
DDRB_DDRB2:         equ    2                                         ; Data Direction Port B Bit 2
DDRB_DDRB3:         equ    3                                         ; Data Direction Port B Bit 3
DDRB_DDRB4:         equ    4                                         ; Data Direction Port B Bit 4
DDRB_DDRB5:         equ    5                                         ; Data Direction Port B Bit 5
DDRB_DDRB6:         equ    6                                         ; Data Direction Port B Bit 6
DDRB_DDRB7:         equ    7                                         ; Data Direction Port B Bit 7
; bit position masks
mDDRB_DDRB0:        equ    %00000001
mDDRB_DDRB1:        equ    %00000010
mDDRB_DDRB2:        equ    %00000100
mDDRB_DDRB3:        equ    %00001000
mDDRB_DDRB4:        equ    %00010000
mDDRB_DDRB5:        equ    %00100000
mDDRB_DDRB6:        equ    %01000000
mDDRB_DDRB7:        equ    %10000000


;*** PORTCD - Port CD; 0x00000004 ***
PORTCD:             equ    $00000004                                ;*** PORTCD - Port CD; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTCD_PD0:         equ    0                                         ; Port D Bit 0
PORTCD_PD1:         equ    1                                         ; Port D Bit 1
PORTCD_PD2:         equ    2                                         ; Port D Bit 2
PORTCD_PD3:         equ    3                                         ; Port D Bit 3
PORTCD_PD4:         equ    4                                         ; Port D Bit 4
PORTCD_PD5:         equ    5                                         ; Port D Bit 5
PORTCD_PD6:         equ    6                                         ; Port D Bit 6
PORTCD_PD7:         equ    7                                         ; Port D Bit 7
PORTCD_PC0:         equ    8                                         ; Port C Bit 0
PORTCD_PC1:         equ    9                                         ; Port C Bit 1
PORTCD_PC2:         equ    10                                        ; Port C Bit 2
PORTCD_PC3:         equ    11                                        ; Port C Bit 3
PORTCD_PC4:         equ    12                                        ; Port C Bit 4
PORTCD_PC5:         equ    13                                        ; Port C Bit 5
PORTCD_PC6:         equ    14                                        ; Port C Bit 6
PORTCD_PC7:         equ    15                                        ; Port C Bit 7
; bit position masks
mPORTCD_PD0:        equ    %00000001
mPORTCD_PD1:        equ    %00000010
mPORTCD_PD2:        equ    %00000100
mPORTCD_PD3:        equ    %00001000
mPORTCD_PD4:        equ    %00010000
mPORTCD_PD5:        equ    %00100000
mPORTCD_PD6:        equ    %01000000
mPORTCD_PD7:        equ    %10000000
mPORTCD_PC0:        equ    %100000000
mPORTCD_PC1:        equ    %1000000000
mPORTCD_PC2:        equ    %10000000000
mPORTCD_PC3:        equ    %100000000000
mPORTCD_PC4:        equ    %1000000000000
mPORTCD_PC5:        equ    %10000000000000
mPORTCD_PC6:        equ    %100000000000000
mPORTCD_PC7:        equ    %1000000000000000


;*** PORTC - Port C Register; 0x00000004 ***
PORTC:              equ    $00000004                                ;*** PORTC - Port C Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTC_PC0:          equ    0                                         ; Port C Bit 0
PORTC_PC1:          equ    1                                         ; Port C Bit 1
PORTC_PC2:          equ    2                                         ; Port C Bit 2
PORTC_PC3:          equ    3                                         ; Port C Bit 3
PORTC_PC4:          equ    4                                         ; Port C Bit 4
PORTC_PC5:          equ    5                                         ; Port C Bit 5
PORTC_PC6:          equ    6                                         ; Port C Bit 6
PORTC_PC7:          equ    7                                         ; Port C Bit 7
; bit position masks
mPORTC_PC0:         equ    %00000001
mPORTC_PC1:         equ    %00000010
mPORTC_PC2:         equ    %00000100
mPORTC_PC3:         equ    %00001000
mPORTC_PC4:         equ    %00010000
mPORTC_PC5:         equ    %00100000
mPORTC_PC6:         equ    %01000000
mPORTC_PC7:         equ    %10000000


;*** PORTD - Port D Register; 0x00000005 ***
PORTD:              equ    $00000005                                ;*** PORTD - Port D Register; 0x00000005 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTD_PD0:          equ    0                                         ; Port D Bit 0
PORTD_PD1:          equ    1                                         ; Port D Bit 1
PORTD_PD2:          equ    2                                         ; Port D Bit 2
PORTD_PD3:          equ    3                                         ; Port D Bit 3
PORTD_PD4:          equ    4                                         ; Port D Bit 4
PORTD_PD5:          equ    5                                         ; Port D Bit 5
PORTD_PD6:          equ    6                                         ; Port D Bit 6
PORTD_PD7:          equ    7                                         ; Port D Bit 7
; bit position masks
mPORTD_PD0:         equ    %00000001
mPORTD_PD1:         equ    %00000010
mPORTD_PD2:         equ    %00000100
mPORTD_PD3:         equ    %00001000
mPORTD_PD4:         equ    %00010000
mPORTD_PD5:         equ    %00100000
mPORTD_PD6:         equ    %01000000
mPORTD_PD7:         equ    %10000000


;*** DDRCD - Port CD Data Direction; 0x00000006 ***
DDRCD:              equ    $00000006                                ;*** DDRCD - Port CD Data Direction; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRCD_DDRD0:        equ    0                                         ; Data Direction Port D Bit 0
DDRCD_DDRD1:        equ    1                                         ; Data Direction Port D Bit 1
DDRCD_DDRD2:        equ    2                                         ; Data Direction Port D Bit 2
DDRCD_DDRD3:        equ    3                                         ; Data Direction Port D Bit 3
DDRCD_DDRD4:        equ    4                                         ; Data Direction Port D Bit 4
DDRCD_DDRD5:        equ    5                                         ; Data Direction Port D Bit 5
DDRCD_DDRD6:        equ    6                                         ; Data Direction Port D Bit 6
DDRCD_DDRD7:        equ    7                                         ; Data Direction Port D Bit 7
DDRCD_DDRC0:        equ    8                                         ; Data Direction Port C Bit 0
DDRCD_DDRC1:        equ    9                                         ; Data Direction Port C Bit 1
DDRCD_DDRC2:        equ    10                                        ; Data Direction Port C Bit 2
DDRCD_DDRC3:        equ    11                                        ; Data Direction Port C Bit 3
DDRCD_DDRC4:        equ    12                                        ; Data Direction Port C Bit 4
DDRCD_DDRC5:        equ    13                                        ; Data Direction Port C Bit 5
DDRCD_DDRC6:        equ    14                                        ; Data Direction Port C Bit 6
DDRCD_DDRC7:        equ    15                                        ; Data Direction Port C Bit 7
; bit position masks
mDDRCD_DDRD0:       equ    %00000001
mDDRCD_DDRD1:       equ    %00000010
mDDRCD_DDRD2:       equ    %00000100
mDDRCD_DDRD3:       equ    %00001000
mDDRCD_DDRD4:       equ    %00010000
mDDRCD_DDRD5:       equ    %00100000
mDDRCD_DDRD6:       equ    %01000000
mDDRCD_DDRD7:       equ    %10000000
mDDRCD_DDRC0:       equ    %100000000
mDDRCD_DDRC1:       equ    %1000000000
mDDRCD_DDRC2:       equ    %10000000000
mDDRCD_DDRC3:       equ    %100000000000
mDDRCD_DDRC4:       equ    %1000000000000
mDDRCD_DDRC5:       equ    %10000000000000
mDDRCD_DDRC6:       equ    %100000000000000
mDDRCD_DDRC7:       equ    %1000000000000000


;*** DDRC - Port C Data Direction Register; 0x00000006 ***
DDRC:               equ    $00000006                                ;*** DDRC - Port C Data Direction Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRC_DDRC0:         equ    0                                         ; Data Direction Port C Bit 0
DDRC_DDRC1:         equ    1                                         ; Data Direction Port C Bit 1
DDRC_DDRC2:         equ    2                                         ; Data Direction Port C Bit 2
DDRC_DDRC3:         equ    3                                         ; Data Direction Port C Bit 3
DDRC_DDRC4:         equ    4                                         ; Data Direction Port C Bit 4
DDRC_DDRC5:         equ    5                                         ; Data Direction Port C Bit 5
DDRC_DDRC6:         equ    6                                         ; Data Direction Port C Bit 6
DDRC_DDRC7:         equ    7                                         ; Data Direction Port C Bit 7
; bit position masks
mDDRC_DDRC0:        equ    %00000001
mDDRC_DDRC1:        equ    %00000010
mDDRC_DDRC2:        equ    %00000100
mDDRC_DDRC3:        equ    %00001000
mDDRC_DDRC4:        equ    %00010000
mDDRC_DDRC5:        equ    %00100000
mDDRC_DDRC6:        equ    %01000000
mDDRC_DDRC7:        equ    %10000000


;*** DDRD - Port D Data Direction Register; 0x00000007 ***
DDRD:               equ    $00000007                                ;*** DDRD - Port D Data Direction Register; 0x00000007 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRD_DDRD0:         equ    0                                         ; Data Direction Port D Bit 0
DDRD_DDRD1:         equ    1                                         ; Data Direction Port D Bit 1
DDRD_DDRD2:         equ    2                                         ; Data Direction Port D Bit 2
DDRD_DDRD3:         equ    3                                         ; Data Direction Port D Bit 3
DDRD_DDRD4:         equ    4                                         ; Data Direction Port D Bit 4
DDRD_DDRD5:         equ    5                                         ; Data Direction Port D Bit 5
DDRD_DDRD6:         equ    6                                         ; Data Direction Port D Bit 6
DDRD_DDRD7:         equ    7                                         ; Data Direction Port D Bit 7
; bit position masks
mDDRD_DDRD0:        equ    %00000001
mDDRD_DDRD1:        equ    %00000010
mDDRD_DDRD2:        equ    %00000100
mDDRD_DDRD3:        equ    %00001000
mDDRD_DDRD4:        equ    %00010000
mDDRD_DDRD5:        equ    %00100000
mDDRD_DDRD6:        equ    %01000000
mDDRD_DDRD7:        equ    %10000000


;*** PORTE - Port E Register; 0x00000008 ***
PORTE:              equ    $00000008                                ;*** PORTE - Port E Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTE_PE0:          equ    0                                         ; Port E Bit 0
PORTE_PE1:          equ    1                                         ; Port E Bit 1
PORTE_PE2:          equ    2                                         ; Port E Bit 2
PORTE_PE3:          equ    3                                         ; Port E Bit 3
PORTE_PE4:          equ    4                                         ; Port E Bit 4
PORTE_PE5:          equ    5                                         ; Port E Bit 5
PORTE_PE6:          equ    6                                         ; Port E Bit 6
PORTE_PE7:          equ    7                                         ; Port E Bit 7
; bit position masks
mPORTE_PE0:         equ    %00000001
mPORTE_PE1:         equ    %00000010
mPORTE_PE2:         equ    %00000100
mPORTE_PE3:         equ    %00001000
mPORTE_PE4:         equ    %00010000
mPORTE_PE5:         equ    %00100000
mPORTE_PE6:         equ    %01000000
mPORTE_PE7:         equ    %10000000


;*** DDRE - Port E Data Direction Register; 0x00000009 ***
DDRE:               equ    $00000009                                ;*** DDRE - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRE_DDRE2:         equ    2                                         ; Data Direction Port E Bit 2
DDRE_DDRE3:         equ    3                                         ; Data Direction Port E Bit 3
DDRE_DDRE4:         equ    4                                         ; Data Direction Port E Bit 4
DDRE_DDRE5:         equ    5                                         ; Data Direction Port E Bit 5
DDRE_DDRE6:         equ    6                                         ; Data Direction Port E Bit 6
DDRE_DDRE7:         equ    7                                         ; Data Direction Port E Bit 7
; bit position masks
mDDRE_DDRE2:        equ    %00000100
mDDRE_DDRE3:        equ    %00001000
mDDRE_DDRE4:        equ    %00010000
mDDRE_DDRE5:        equ    %00100000
mDDRE_DDRE6:        equ    %01000000
mDDRE_DDRE7:        equ    %10000000


;*** MMCCTL0 - S12X_MMC Control Register 0; 0x0000000A ***
MMCCTL0:            equ    $0000000A                                ;*** MMCCTL0 - S12X_MMC Control Register 0; 0x0000000A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL0_CS0E:       equ    0                                         ; Chip Select Enable 0
MMCCTL0_CS1E:       equ    1                                         ; Chip Select Enable 1
MMCCTL0_CS2E:       equ    2                                         ; Chip Select Enable 2
MMCCTL0_CS3E:       equ    3                                         ; Chip Select Enable 3
; bit position masks
mMMCCTL0_CS0E:      equ    %00000001
mMMCCTL0_CS1E:      equ    %00000010
mMMCCTL0_CS2E:      equ    %00000100
mMMCCTL0_CS3E:      equ    %00001000


;*** MODE - Mode Register; 0x0000000B ***
MODE:               equ    $0000000B                                ;*** MODE - Mode Register; 0x0000000B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODE_MODA:          equ    5                                         ; Mode Select Bit A
MODE_MODB:          equ    6                                         ; Mode Select Bit B
MODE_MODC:          equ    7                                         ; Mode Select Bit C
; bit position masks
mMODE_MODA:         equ    %00100000
mMODE_MODB:         equ    %01000000
mMODE_MODC:         equ    %10000000


;*** PUCR - Pull-Up Control Register; 0x0000000C ***
PUCR:               equ    $0000000C                                ;*** PUCR - Pull-Up Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PUCR_PUPAE:         equ    0                                         ; Pull-Up Port A Enable
PUCR_PUPBE:         equ    1                                         ; Pull-Up Port B Enable
PUCR_PUPCE:         equ    2                                         ; Pull-Up Port C Enable
PUCR_PUPDE:         equ    3                                         ; Pull-Up Port D Enable
PUCR_PUPEE:         equ    4                                         ; Pull-Up Port E Enable
PUCR_BKPUE:         equ    6                                         ; BKGD and VREGEN Pin Pull-up Enable
PUCR_PUPKE:         equ    7                                         ; Pull-Up Port K Enable
; bit position masks
mPUCR_PUPAE:        equ    %00000001
mPUCR_PUPBE:        equ    %00000010
mPUCR_PUPCE:        equ    %00000100
mPUCR_PUPDE:        equ    %00001000
mPUCR_PUPEE:        equ    %00010000
mPUCR_BKPUE:        equ    %01000000
mPUCR_PUPKE:        equ    %10000000


;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
RDRIV:              equ    $0000000D                                ;*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRIV_RDPA:         equ    0                                         ; Reduced Drive of Port A
RDRIV_RDPB:         equ    1                                         ; Reduced Drive of Port B
RDRIV_RDPC:         equ    2                                         ; Reduced Drive of Port C
RDRIV_RDPD:         equ    3                                         ; Reduced Drive of Port D
RDRIV_RDPE:         equ    4                                         ; Reduced Drive of Port E
RDRIV_RDPK:         equ    7                                         ; Reduced Drive of Port K
; bit position masks
mRDRIV_RDPA:        equ    %00000001
mRDRIV_RDPB:        equ    %00000010
mRDRIV_RDPC:        equ    %00000100
mRDRIV_RDPD:        equ    %00001000
mRDRIV_RDPE:        equ    %00010000
mRDRIV_RDPK:        equ    %10000000


;*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***
EBICTL0:            equ    $0000000E                                ;*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL0_ASIZ0:      equ    0                                         ; External Address Bus Size Bit 0
EBICTL0_ASIZ1:      equ    1                                         ; External Address Bus Size Bit 1
EBICTL0_ASIZ2:      equ    2                                         ; External Address Bus Size Bit 2
EBICTL0_ASIZ3:      equ    3                                         ; External Address Bus Size Bit 3
EBICTL0_ASIZ4:      equ    4                                         ; External Address Bus Size Bit 4
EBICTL0_HDBE:       equ    5                                         ; High Data Byte Enable
EBICTL0_ITHRS:      equ    7                                         ; Reduced Input Threshold
; bit position masks
mEBICTL0_ASIZ0:     equ    %00000001
mEBICTL0_ASIZ1:     equ    %00000010
mEBICTL0_ASIZ2:     equ    %00000100
mEBICTL0_ASIZ3:     equ    %00001000
mEBICTL0_ASIZ4:     equ    %00010000
mEBICTL0_HDBE:      equ    %00100000
mEBICTL0_ITHRS:     equ    %10000000


;*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***
EBICTL1:            equ    $0000000F                                ;*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EBICTL1_EXSTR0:     equ    0                                         ; External Access Stretch Bit 0
EBICTL1_EXSTR1:     equ    1                                         ; External Access Stretch Bit 1
EBICTL1_EXSTR2:     equ    2                                         ; External Access Stretch Bit 2
EBICTL1_EWAITE:     equ    7                                         ; External Wait Enable
; bit position masks
mEBICTL1_EXSTR0:    equ    %00000001
mEBICTL1_EXSTR1:    equ    %00000010
mEBICTL1_EXSTR2:    equ    %00000100
mEBICTL1_EWAITE:    equ    %10000000


;*** GPAGE - Global Page Index Register; 0x00000010 ***
GPAGE:              equ    $00000010                                ;*** GPAGE - Global Page Index Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
GPAGE_GP0:          equ    0                                         ; Global Page Index Bit 0
GPAGE_GP1:          equ    1                                         ; Global Page Index Bit 1
GPAGE_GP2:          equ    2                                         ; Global Page Index Bit 2
GPAGE_GP3:          equ    3                                         ; Global Page Index Bit 3
GPAGE_GP4:          equ    4                                         ; Global Page Index Bit 4
GPAGE_GP5:          equ    5                                         ; Global Page Index Bit 5
GPAGE_GP6:          equ    6                                         ; Global Page Index Bit 6
; bit position masks
mGPAGE_GP0:         equ    %00000001
mGPAGE_GP1:         equ    %00000010
mGPAGE_GP2:         equ    %00000100
mGPAGE_GP3:         equ    %00001000
mGPAGE_GP4:         equ    %00010000
mGPAGE_GP5:         equ    %00100000
mGPAGE_GP6:         equ    %01000000


;*** DIRECT - Direct Page Register; 0x00000011 ***
DIRECT:             equ    $00000011                                ;*** DIRECT - Direct Page Register; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DIRECT_DP8:         equ    0                                         ; Direct Page Bit 8
DIRECT_DP9:         equ    1                                         ; Direct Page Bit 9
DIRECT_DP10:        equ    2                                         ; Direct Page Bit 10
DIRECT_DP11:        equ    3                                         ; Direct Page Bit 11
DIRECT_DP12:        equ    4                                         ; Direct Page Bit 12
DIRECT_DP13:        equ    5                                         ; Direct Page Bit 13
DIRECT_DP14:        equ    6                                         ; Direct Page Bit 14
DIRECT_DP15:        equ    7                                         ; Direct Page Bit 15
; bit position masks
mDIRECT_DP8:        equ    %00000001
mDIRECT_DP9:        equ    %00000010
mDIRECT_DP10:       equ    %00000100
mDIRECT_DP11:       equ    %00001000
mDIRECT_DP12:       equ    %00010000
mDIRECT_DP13:       equ    %00100000
mDIRECT_DP14:       equ    %01000000
mDIRECT_DP15:       equ    %10000000


;*** MMCCTL1 - S12X_MMC Control Register 1; 0x00000013 ***
MMCCTL1:            equ    $00000013                                ;*** MMCCTL1 - S12X_MMC Control Register 1; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MMCCTL1_ROMON:      equ    0                                         ; Enable FLASH or ROM in the memory map
MMCCTL1_ROMHM:      equ    1                                         ; FLASH or ROM only in higher Half of Memory Map
MMCCTL1_EROMON:     equ    2                                         ; Enables emulated FLASH or ROM memory in the memory map.
; bit position masks
mMMCCTL1_ROMON:     equ    %00000001
mMMCCTL1_ROMHM:     equ    %00000010
mMMCCTL1_EROMON:    equ    %00000100


;*** RPAGE - RAM Page Index Register; 0x00000016 ***
RPAGE:              equ    $00000016                                ;*** RPAGE - RAM Page Index Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RPAGE_RP0:          equ    0                                         ; RAM Page Index Bit 0
RPAGE_RP1:          equ    1                                         ; RAM Page Index Bit 1
RPAGE_RP2:          equ    2                                         ; RAM Page Index Bit 2
RPAGE_RP3:          equ    3                                         ; RAM Page Index Bit 3
RPAGE_RP4:          equ    4                                         ; RAM Page Index Bit 4
RPAGE_RP5:          equ    5                                         ; RAM Page Index Bit 5
RPAGE_RP6:          equ    6                                         ; RAM Page Index Bit 6
RPAGE_RP7:          equ    7                                         ; RAM Page Index Bit 7
; bit position masks
mRPAGE_RP0:         equ    %00000001
mRPAGE_RP1:         equ    %00000010
mRPAGE_RP2:         equ    %00000100
mRPAGE_RP3:         equ    %00001000
mRPAGE_RP4:         equ    %00010000
mRPAGE_RP5:         equ    %00100000
mRPAGE_RP6:         equ    %01000000
mRPAGE_RP7:         equ    %10000000


;*** EPAGE - EEPROM Page Index Register; 0x00000017 ***
EPAGE:              equ    $00000017                                ;*** EPAGE - EEPROM Page Index Register; 0x00000017 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPAGE_EP0:          equ    0                                         ; EEPROM Page Index Bit 0
EPAGE_EP1:          equ    1                                         ; EEPROM Page Index Bit 1
EPAGE_EP2:          equ    2                                         ; EEPROM Page Index Bit 2
EPAGE_EP3:          equ    3                                         ; EEPROM Page Index Bit 3
EPAGE_EP4:          equ    4                                         ; EEPROM Page Index Bit 4
EPAGE_EP5:          equ    5                                         ; EEPROM Page Index Bit 5
EPAGE_EP6:          equ    6                                         ; EEPROM Page Index Bit 6
EPAGE_EP7:          equ    7                                         ; EEPROM Page Index Bit 7
; bit position masks
mEPAGE_EP0:         equ    %00000001
mEPAGE_EP1:         equ    %00000010
mEPAGE_EP2:         equ    %00000100
mEPAGE_EP3:         equ    %00001000
mEPAGE_EP4:         equ    %00010000
mEPAGE_EP5:         equ    %00100000
mEPAGE_EP6:         equ    %01000000
mEPAGE_EP7:         equ    %10000000


;*** PARTID - Part ID Register; 0x0000001A ***
PARTID:             equ    $0000001A                                ;*** PARTID - Part ID Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTID_ID0:         equ    0                                         ; Part ID Register Bit 0
PARTID_ID1:         equ    1                                         ; Part ID Register Bit 1
PARTID_ID2:         equ    2                                         ; Part ID Register Bit 2
PARTID_ID3:         equ    3                                         ; Part ID Register Bit 3
PARTID_ID4:         equ    4                                         ; Part ID Register Bit 4
PARTID_ID5:         equ    5                                         ; Part ID Register Bit 5
PARTID_ID6:         equ    6                                         ; Part ID Register Bit 6
PARTID_ID7:         equ    7                                         ; Part ID Register Bit 7
PARTID_ID8:         equ    8                                         ; Part ID Register Bit 8
PARTID_ID9:         equ    9                                         ; Part ID Register Bit 9
PARTID_ID10:        equ    10                                        ; Part ID Register Bit 10
PARTID_ID11:        equ    11                                        ; Part ID Register Bit 11
PARTID_ID12:        equ    12                                        ; Part ID Register Bit 12
PARTID_ID13:        equ    13                                        ; Part ID Register Bit 13
PARTID_ID14:        equ    14                                        ; Part ID Register Bit 14
PARTID_ID15:        equ    15                                        ; Part ID Register Bit 15
; bit position masks
mPARTID_ID0:        equ    %00000001
mPARTID_ID1:        equ    %00000010
mPARTID_ID2:        equ    %00000100
mPARTID_ID3:        equ    %00001000
mPARTID_ID4:        equ    %00010000
mPARTID_ID5:        equ    %00100000
mPARTID_ID6:        equ    %01000000
mPARTID_ID7:        equ    %10000000
mPARTID_ID8:        equ    %100000000
mPARTID_ID9:        equ    %1000000000
mPARTID_ID10:       equ    %10000000000
mPARTID_ID11:       equ    %100000000000
mPARTID_ID12:       equ    %1000000000000
mPARTID_ID13:       equ    %10000000000000
mPARTID_ID14:       equ    %100000000000000
mPARTID_ID15:       equ    %1000000000000000


;*** PARTIDH - Part ID Register High; 0x0000001A ***
PARTIDH:            equ    $0000001A                                ;*** PARTIDH - Part ID Register High; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDH_ID8:        equ    0                                         ; Part ID Register Bit 8
PARTIDH_ID9:        equ    1                                         ; Part ID Register Bit 9
PARTIDH_ID10:       equ    2                                         ; Part ID Register Bit 10
PARTIDH_ID11:       equ    3                                         ; Part ID Register Bit 11
PARTIDH_ID12:       equ    4                                         ; Part ID Register Bit 12
PARTIDH_ID13:       equ    5                                         ; Part ID Register Bit 13
PARTIDH_ID14:       equ    6                                         ; Part ID Register Bit 14
PARTIDH_ID15:       equ    7                                         ; Part ID Register Bit 15
; bit position masks
mPARTIDH_ID8:       equ    %00000001
mPARTIDH_ID9:       equ    %00000010
mPARTIDH_ID10:      equ    %00000100
mPARTIDH_ID11:      equ    %00001000
mPARTIDH_ID12:      equ    %00010000
mPARTIDH_ID13:      equ    %00100000
mPARTIDH_ID14:      equ    %01000000
mPARTIDH_ID15:      equ    %10000000


;*** PARTIDL - Part ID Register Low; 0x0000001B ***
PARTIDL:            equ    $0000001B                                ;*** PARTIDL - Part ID Register Low; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PARTIDL_ID0:        equ    0                                         ; Part ID Register Bit 0
PARTIDL_ID1:        equ    1                                         ; Part ID Register Bit 1
PARTIDL_ID2:        equ    2                                         ; Part ID Register Bit 2
PARTIDL_ID3:        equ    3                                         ; Part ID Register Bit 3
PARTIDL_ID4:        equ    4                                         ; Part ID Register Bit 4
PARTIDL_ID5:        equ    5                                         ; Part ID Register Bit 5
PARTIDL_ID6:        equ    6                                         ; Part ID Register Bit 6
PARTIDL_ID7:        equ    7                                         ; Part ID Register Bit 7
; bit position masks
mPARTIDL_ID0:       equ    %00000001
mPARTIDL_ID1:       equ    %00000010
mPARTIDL_ID2:       equ    %00000100
mPARTIDL_ID3:       equ    %00001000
mPARTIDL_ID4:       equ    %00010000
mPARTIDL_ID5:       equ    %00100000
mPARTIDL_ID6:       equ    %01000000
mPARTIDL_ID7:       equ    %10000000


;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
ECLKCTL:            equ    $0000001C                                ;*** ECLKCTL - ECLK Control Register; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKCTL_EDIV0:      equ    0                                         ; Free-running ECLK Divider Bit 0
ECLKCTL_EDIV1:      equ    1                                         ; Free-running ECLK Divider Bit 1
ECLKCTL_NCLKX2:     equ    6                                         ; No ECLKX2
ECLKCTL_NECLK:      equ    7                                         ; No ECLK
; bit position masks
mECLKCTL_EDIV0:     equ    %00000001
mECLKCTL_EDIV1:     equ    %00000010
mECLKCTL_NCLKX2:    equ    %01000000
mECLKCTL_NECLK:     equ    %10000000


;*** IRQCR - Interrupt Control Register; 0x0000001E ***
IRQCR:              equ    $0000001E                                ;*** IRQCR - Interrupt Control Register; 0x0000001E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQCR_IRQEN:        equ    6                                         ; External IRQ Enable
IRQCR_IRQE:         equ    7                                         ; IRQ Select Edge Sensitive Only
; bit position masks
mIRQCR_IRQEN:       equ    %01000000
mIRQCR_IRQE:        equ    %10000000


;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
DBGC1:              equ    $00000020                                ;*** DBGC1 - Debug Control Register 1; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC1_COMRV:        equ    0                                         ; Comparator Register Visibility Bits
DBGC1_DBGBRK:       equ    2                                         ; S12X_DBG Breakpoint Enable Bits
DBGC1_BDM:          equ    4                                         ; Background Debug Mode Enable
DBGC1_XGSBPE:       equ    5                                         ; XGATE S/W Breakpoint Enable
DBGC1_TRIG:         equ    6                                         ; Immediate Trigger Request Bit
DBGC1_ARM:          equ    7                                         ; Arm Bit
; bit position masks
mDBGC1_COMRV:       equ    %00000011
mDBGC1_DBGBRK:      equ    %00001100
mDBGC1_BDM:         equ    %00010000
mDBGC1_XGSBPE:      equ    %00100000
mDBGC1_TRIG:        equ    %01000000
mDBGC1_ARM:         equ    %10000000


;*** DBGSR - Debug Status Register; 0x00000021 ***
DBGSR:              equ    $00000021                                ;*** DBGSR - Debug Status Register; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSR_SSF0:         equ    0                                         ; State Sequencer Flag Bit 0
DBGSR_SSF1:         equ    1                                         ; State Sequencer Flag Bit 1
DBGSR_SSF2:         equ    2                                         ; State Sequencer Flag Bit 2
DBGSR_EXTF:         equ    6                                         ; External Tag Hit Flag
DBGSR_TBF:          equ    7                                         ; Trace Buffer Full
; bit position masks
mDBGSR_SSF0:        equ    %00000001
mDBGSR_SSF1:        equ    %00000010
mDBGSR_SSF2:        equ    %00000100
mDBGSR_EXTF:        equ    %01000000
mDBGSR_TBF:         equ    %10000000


;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
DBGTCR:             equ    $00000022                                ;*** DBGTCR - Debug Trace Control Register; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTCR_TALIGN:      equ    0                                         ; Trigger Align Bits
DBGTCR_TRCMOD:      equ    2                                         ; Trace Mode Bits
DBGTCR_TRANGE:      equ    4                                         ; Trace Range Bits
DBGTCR_TSOURCE:     equ    6                                         ; Trace Source Control Bits
; bit position masks
mDBGTCR_TALIGN:     equ    %00000011
mDBGTCR_TRCMOD:     equ    %00001100
mDBGTCR_TRANGE:     equ    %00110000
mDBGTCR_TSOURCE:    equ    %11000000


;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
DBGC2:              equ    $00000023                                ;*** DBGC2 - Debug Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC2_ABCM:         equ    0                                         ; A and B Comparator Match Control
DBGC2_CDCM:         equ    2                                         ; C and D Comparator Match Control
; bit position masks
mDBGC2_ABCM:        equ    %00000011
mDBGC2_CDCM:        equ    %00001100


;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
DBGTB:              equ    $00000024                                ;*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTB_BIT0:         equ    0                                         ; Debug Trace Buffer Bit 0
DBGTB_BIT1:         equ    1                                         ; Debug Trace Buffer Bit 1
DBGTB_BIT2:         equ    2                                         ; Debug Trace Buffer Bit 2
DBGTB_BIT3:         equ    3                                         ; Debug Trace Buffer Bit 3
DBGTB_BIT4:         equ    4                                         ; Debug Trace Buffer Bit 4
DBGTB_BIT5:         equ    5                                         ; Debug Trace Buffer Bit 5
DBGTB_BIT6:         equ    6                                         ; Debug Trace Buffer Bit 6
DBGTB_BIT7:         equ    7                                         ; Debug Trace Buffer Bit 7
DBGTB_BIT8:         equ    8                                         ; Debug Trace Buffer Bit 8
DBGTB_BIT9:         equ    9                                         ; Debug Trace Buffer Bit 9
DBGTB_BIT10:        equ    10                                        ; Debug Trace Buffer Bit 10
DBGTB_BIT11:        equ    11                                        ; Debug Trace Buffer Bit 11
DBGTB_BIT12:        equ    12                                        ; Debug Trace Buffer Bit 12
DBGTB_BIT13:        equ    13                                        ; Debug Trace Buffer Bit 13
DBGTB_BIT14:        equ    14                                        ; Debug Trace Buffer Bit 14
DBGTB_BIT15:        equ    15                                        ; Debug Trace Buffer Bit 15
; bit position masks
mDBGTB_BIT0:        equ    %00000001
mDBGTB_BIT1:        equ    %00000010
mDBGTB_BIT2:        equ    %00000100
mDBGTB_BIT3:        equ    %00001000
mDBGTB_BIT4:        equ    %00010000
mDBGTB_BIT5:        equ    %00100000
mDBGTB_BIT6:        equ    %01000000
mDBGTB_BIT7:        equ    %10000000
mDBGTB_BIT8:        equ    %100000000
mDBGTB_BIT9:        equ    %1000000000
mDBGTB_BIT10:       equ    %10000000000
mDBGTB_BIT11:       equ    %100000000000
mDBGTB_BIT12:       equ    %1000000000000
mDBGTB_BIT13:       equ    %10000000000000
mDBGTB_BIT14:       equ    %100000000000000
mDBGTB_BIT15:       equ    %1000000000000000


;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
DBGTBH:             equ    $00000024                                ;*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBH_BIT8:        equ    0                                         ; Debug Trace Buffer Bit 8
DBGTBH_BIT9:        equ    1                                         ; Debug Trace Buffer Bit 9
DBGTBH_BIT10:       equ    2                                         ; Debug Trace Buffer Bit 10
DBGTBH_BIT11:       equ    3                                         ; Debug Trace Buffer Bit 11
DBGTBH_BIT12:       equ    4                                         ; Debug Trace Buffer Bit 12
DBGTBH_BIT13:       equ    5                                         ; Debug Trace Buffer Bit 13
DBGTBH_BIT14:       equ    6                                         ; Debug Trace Buffer Bit 14
DBGTBH_BIT15:       equ    7                                         ; Debug Trace Buffer Bit 15
; bit position masks
mDBGTBH_BIT8:       equ    %00000001
mDBGTBH_BIT9:       equ    %00000010
mDBGTBH_BIT10:      equ    %00000100
mDBGTBH_BIT11:      equ    %00001000
mDBGTBH_BIT12:      equ    %00010000
mDBGTBH_BIT13:      equ    %00100000
mDBGTBH_BIT14:      equ    %01000000
mDBGTBH_BIT15:      equ    %10000000


;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
DBGTBL:             equ    $00000025                                ;*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGTBL_BIT0:        equ    0                                         ; Debug Trace Buffer Bit 0
DBGTBL_BIT1:        equ    1                                         ; Debug Trace Buffer Bit 1
DBGTBL_BIT2:        equ    2                                         ; Debug Trace Buffer Bit 2
DBGTBL_BIT3:        equ    3                                         ; Debug Trace Buffer Bit 3
DBGTBL_BIT4:        equ    4                                         ; Debug Trace Buffer Bit 4
DBGTBL_BIT5:        equ    5                                         ; Debug Trace Buffer Bit 5
DBGTBL_BIT6:        equ    6                                         ; Debug Trace Buffer Bit 6
DBGTBL_BIT7:        equ    7                                         ; Debug Trace Buffer Bit 7
; bit position masks
mDBGTBL_BIT0:       equ    %00000001
mDBGTBL_BIT1:       equ    %00000010
mDBGTBL_BIT2:       equ    %00000100
mDBGTBL_BIT3:       equ    %00001000
mDBGTBL_BIT4:       equ    %00010000
mDBGTBL_BIT5:       equ    %00100000
mDBGTBL_BIT6:       equ    %01000000
mDBGTBL_BIT7:       equ    %10000000


;*** DBGCNT - Debug Count Register; 0x00000026 ***
DBGCNT:             equ    $00000026                                ;*** DBGCNT - Debug Count Register; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT:         equ    0                                         ; Count value
; bit position masks
mDBGCNT_CNT:        equ    %01111111


;*** DBGSCRX - Debug State Control Register 0; 0x00000027 ***
DBGSCRX:            equ    $00000027                                ;*** DBGSCRX - Debug State Control Register 0; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGSCRX_SC0:        equ    0                                         ; These bit (0) select the targeted next state whilst in StateX, based upon the match event
DBGSCRX_SC1:        equ    1                                         ; These bit (1) select the targeted next state whilst in StateX, based upon the match event
DBGSCRX_SC2:        equ    2                                         ; These bit (2) select the targeted next state whilst in StateX, based upon the match event
DBGSCRX_SC3:        equ    3                                         ; These bit (3) select the targeted next state whilst in StateX, based upon the match event
; bit position masks
mDBGSCRX_SC0:       equ    %00000001
mDBGSCRX_SC1:       equ    %00000010
mDBGSCRX_SC2:       equ    %00000100
mDBGSCRX_SC3:       equ    %00001000


;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
DBGMFR:             equ    $00000027                                ;*** DBGMFR - Debug Match Flag Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGMFR_MC0:         equ    0                                         ; Debug Match Flag Bit 0
DBGMFR_MC1:         equ    1                                         ; Debug Match Flag Bit 1
DBGMFR_MC2:         equ    2                                         ; Debug Match Flag Bit 2
DBGMFR_MC3:         equ    3                                         ; Debug Match Flag Bit 3
; bit position masks
mDBGMFR_MC0:        equ    %00000001
mDBGMFR_MC1:        equ    %00000010
mDBGMFR_MC2:        equ    %00000100
mDBGMFR_MC3:        equ    %00001000


;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
DBGXCTL:            equ    $00000028                                ;*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXCTL_COMPE:      equ    0                                         ; Determines if comparator is enabled
DBGXCTL_SRC:        equ    1                                         ; Determines mapping of comparator to S12X_CPU or XGATE
DBGXCTL_RWE:        equ    2                                         ; Read/Write Enable Bit
DBGXCTL_RW:         equ    3                                         ; Read/Write Comparator Value Bit
DBGXCTL_BRK:        equ    4                                         ; Break
DBGXCTL_TAG:        equ    5                                         ; Tag select
DBGXCTL_NDB_SZ:     equ    6                                         ; Not Data Bus Compare (for comparators A and C), Size Comparator Value Bit (for comparators B and D)
DBGXCTL_SZE:        equ    7                                         ; Size Comparator Enable Bit (for comparators B and D)
; bit position masks
mDBGXCTL_COMPE:     equ    %00000001
mDBGXCTL_SRC:       equ    %00000010
mDBGXCTL_RWE:       equ    %00000100
mDBGXCTL_RW:        equ    %00001000
mDBGXCTL_BRK:       equ    %00010000
mDBGXCTL_TAG:       equ    %00100000
mDBGXCTL_NDB_SZ:    equ    %01000000
mDBGXCTL_SZE:       equ    %10000000


;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
DBGXAH:             equ    $00000029                                ;*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAH_BIT16:       equ    0                                         ; Comparator Address High Compare Bit 16
DBGXAH_BIT17:       equ    1                                         ; Comparator Address High Compare Bit 17
DBGXAH_BIT18:       equ    2                                         ; Comparator Address High Compare Bit 18
DBGXAH_BIT19:       equ    3                                         ; Comparator Address High Compare Bit 19
DBGXAH_BIT20:       equ    4                                         ; Comparator Address High Compare Bit 20
DBGXAH_BIT21:       equ    5                                         ; Comparator Address High Compare Bit 21
DBGXAH_BIT22:       equ    6                                         ; Comparator Address High Compare Bit 22
; bit position masks
mDBGXAH_BIT16:      equ    %00000001
mDBGXAH_BIT17:      equ    %00000010
mDBGXAH_BIT18:      equ    %00000100
mDBGXAH_BIT19:      equ    %00001000
mDBGXAH_BIT20:      equ    %00010000
mDBGXAH_BIT21:      equ    %00100000
mDBGXAH_BIT22:      equ    %01000000


;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
DBGXAM:             equ    $0000002A                                ;*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAM_BIT8:        equ    0                                         ; Comparator Address Mid Compare Bit 8
DBGXAM_BIT9:        equ    1                                         ; Comparator Address Mid Compare Bit 9
DBGXAM_BIT10:       equ    2                                         ; Comparator Address Mid Compare Bit 10
DBGXAM_BIT11:       equ    3                                         ; Comparator Address Mid Compare Bit 11
DBGXAM_BIT12:       equ    4                                         ; Comparator Address Mid Compare Bit 12
DBGXAM_BIT13:       equ    5                                         ; Comparator Address Mid Compare Bit 13
DBGXAM_BIT14:       equ    6                                         ; Comparator Address Mid Compare Bit 14
DBGXAM_BIT15:       equ    7                                         ; Comparator Address Mid Compare Bit 15
; bit position masks
mDBGXAM_BIT8:       equ    %00000001
mDBGXAM_BIT9:       equ    %00000010
mDBGXAM_BIT10:      equ    %00000100
mDBGXAM_BIT11:      equ    %00001000
mDBGXAM_BIT12:      equ    %00010000
mDBGXAM_BIT13:      equ    %00100000
mDBGXAM_BIT14:      equ    %01000000
mDBGXAM_BIT15:      equ    %10000000


;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
DBGXAL:             equ    $0000002B                                ;*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXAL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bit 0
DBGXAL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXAL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXAL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXAL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXAL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXAL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXAL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXAL_BIT0:       equ    %00000001
mDBGXAL_BIT1:       equ    %00000010
mDBGXAL_BIT2:       equ    %00000100
mDBGXAL_BIT3:       equ    %00001000
mDBGXAL_BIT4:       equ    %00010000
mDBGXAL_BIT5:       equ    %00100000
mDBGXAL_BIT6:       equ    %01000000
mDBGXAL_BIT7:       equ    %10000000


;*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***
DBGXDH:             equ    $0000002C                                ;*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDH_BIT8:        equ    0                                         ; Comparator A Compare Bit 8
DBGXDH_BIT9:        equ    1                                         ; Comparator A Compare Bit 9
DBGXDH_BIT10:       equ    2                                         ; Comparator A Compare Bit 10
DBGXDH_BIT11:       equ    3                                         ; Comparator A Compare Bit 11
DBGXDH_BIT12:       equ    4                                         ; Comparator A Compare Bit 12
DBGXDH_BIT13:       equ    5                                         ; Comparator A Compare Bit 13
DBGXDH_BIT14:       equ    6                                         ; Comparator A Compare Bit 14
DBGXDH_BIT15:       equ    7                                         ; Comparator A Compare Bit 15
; bit position masks
mDBGXDH_BIT8:       equ    %00000001
mDBGXDH_BIT9:       equ    %00000010
mDBGXDH_BIT10:      equ    %00000100
mDBGXDH_BIT11:      equ    %00001000
mDBGXDH_BIT12:      equ    %00010000
mDBGXDH_BIT13:      equ    %00100000
mDBGXDH_BIT14:      equ    %01000000
mDBGXDH_BIT15:      equ    %10000000


;*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***
DBGXDL:             equ    $0000002D                                ;*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDL_BIT0:        equ    0                                         ; Comparator Address Low Compare Bit 0
DBGXDL_BIT1:        equ    1                                         ; Comparator Address Low Compare Bit 1
DBGXDL_BIT2:        equ    2                                         ; Comparator Address Low Compare Bit 2
DBGXDL_BIT3:        equ    3                                         ; Comparator Address Low Compare Bit 3
DBGXDL_BIT4:        equ    4                                         ; Comparator Address Low Compare Bit 4
DBGXDL_BIT5:        equ    5                                         ; Comparator Address Low Compare Bit 5
DBGXDL_BIT6:        equ    6                                         ; Comparator Address Low Compare Bit 6
DBGXDL_BIT7:        equ    7                                         ; Comparator Address Low Compare Bit 7
; bit position masks
mDBGXDL_BIT0:       equ    %00000001
mDBGXDL_BIT1:       equ    %00000010
mDBGXDL_BIT2:       equ    %00000100
mDBGXDL_BIT3:       equ    %00001000
mDBGXDL_BIT4:       equ    %00010000
mDBGXDL_BIT5:       equ    %00100000
mDBGXDL_BIT6:       equ    %01000000
mDBGXDL_BIT7:       equ    %10000000


;*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***
DBGXDHM:            equ    $0000002E                                ;*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDHM_BIT8:       equ    0                                         ; Comparator Data High Mask Bit 8
DBGXDHM_BIT9:       equ    1                                         ; Comparator Data High Mask Bit 9
DBGXDHM_BIT10:      equ    2                                         ; Comparator Data High Mask Bit 10
DBGXDHM_BIT11:      equ    3                                         ; Comparator Data High Mask Bit 11
DBGXDHM_BIT12:      equ    4                                         ; Comparator Data High Mask Bit 12
DBGXDHM_BIT13:      equ    5                                         ; Comparator Data High Mask Bit 13
DBGXDHM_BIT14:      equ    6                                         ; Comparator Data High Mask Bit 14
DBGXDHM_BIT15:      equ    7                                         ; Comparator Data High Mask Bit 15
; bit position masks
mDBGXDHM_BIT8:      equ    %00000001
mDBGXDHM_BIT9:      equ    %00000010
mDBGXDHM_BIT10:     equ    %00000100
mDBGXDHM_BIT11:     equ    %00001000
mDBGXDHM_BIT12:     equ    %00010000
mDBGXDHM_BIT13:     equ    %00100000
mDBGXDHM_BIT14:     equ    %01000000
mDBGXDHM_BIT15:     equ    %10000000


;*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
DBGXDLM:            equ    $0000002F                                ;*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGXDLM_BIT0:       equ    0                                         ; Comparator Data High Mask Bit 0
DBGXDLM_BIT1:       equ    1                                         ; Comparator Data High Mask Bit 1
DBGXDLM_BIT2:       equ    2                                         ; Comparator Data High Mask Bit 2
DBGXDLM_BIT3:       equ    3                                         ; Comparator Data High Mask Bit 3
DBGXDLM_BIT4:       equ    4                                         ; Comparator Data High Mask Bit 4
DBGXDLM_BIT5:       equ    5                                         ; Comparator Data High Mask Bit 5
DBGXDLM_BIT6:       equ    6                                         ; Comparator Data High Mask Bit 6
DBGXDLM_BIT7:       equ    7                                         ; Comparator Data High Mask Bit 7
; bit position masks
mDBGXDLM_BIT0:      equ    %00000001
mDBGXDLM_BIT1:      equ    %00000010
mDBGXDLM_BIT2:      equ    %00000100
mDBGXDLM_BIT3:      equ    %00001000
mDBGXDLM_BIT4:      equ    %00010000
mDBGXDLM_BIT5:      equ    %00100000
mDBGXDLM_BIT6:      equ    %01000000
mDBGXDLM_BIT7:      equ    %10000000


;*** PPAGE - Program Page Index Register; 0x00000030 ***
PPAGE:              equ    $00000030                                ;*** PPAGE - Program Page Index Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_PIX0:         equ    0                                         ; Program Page Index Bit 0
PPAGE_PIX1:         equ    1                                         ; Program Page Index Bit 1
PPAGE_PIX2:         equ    2                                         ; Program Page Index Bit 2
PPAGE_PIX3:         equ    3                                         ; Program Page Index Bit 3
PPAGE_PIX4:         equ    4                                         ; Program Page Index Bit 4
PPAGE_PIX5:         equ    5                                         ; Program Page Index Bit 5
PPAGE_PIX6:         equ    6                                         ; Program Page Index Bit 6
PPAGE_PIX7:         equ    7                                         ; Program Page Index Bit 7
; bit position masks
mPPAGE_PIX0:        equ    %00000001
mPPAGE_PIX1:        equ    %00000010
mPPAGE_PIX2:        equ    %00000100
mPPAGE_PIX3:        equ    %00001000
mPPAGE_PIX4:        equ    %00010000
mPPAGE_PIX5:        equ    %00100000
mPPAGE_PIX6:        equ    %01000000
mPPAGE_PIX7:        equ    %10000000


;*** PORTK - Port K Data Register; 0x00000032 ***
PORTK:              equ    $00000032                                ;*** PORTK - Port K Data Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PORTK_PK0:          equ    0                                         ; Port K Bit 0
PORTK_PK1:          equ    1                                         ; Port K Bit 1
PORTK_PK2:          equ    2                                         ; Port K Bit 2
PORTK_PK3:          equ    3                                         ; Port K Bit 3
PORTK_PK4:          equ    4                                         ; Port K Bit 4
PORTK_PK5:          equ    5                                         ; Port K Bit 5
PORTK_PK6:          equ    6                                         ; Port K Bit 6
PORTK_PK7:          equ    7                                         ; Port K Bit 7
; bit position masks
mPORTK_PK0:         equ    %00000001
mPORTK_PK1:         equ    %00000010
mPORTK_PK2:         equ    %00000100
mPORTK_PK3:         equ    %00001000
mPORTK_PK4:         equ    %00010000
mPORTK_PK5:         equ    %00100000
mPORTK_PK6:         equ    %01000000
mPORTK_PK7:         equ    %10000000


;*** DDRK - Port K Data Direction Register; 0x00000033 ***
DDRK:               equ    $00000033                                ;*** DDRK - Port K Data Direction Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRK_DDRK0:         equ    0                                         ; Port K Data Direction Bit 0
DDRK_DDRK1:         equ    1                                         ; Port K Data Direction Bit 1
DDRK_DDRK2:         equ    2                                         ; Port K Data Direction Bit 2
DDRK_DDRK3:         equ    3                                         ; Port K Data Direction Bit 3
DDRK_DDRK4:         equ    4                                         ; Port K Data Direction Bit 4
DDRK_DDRK5:         equ    5                                         ; Port K Data Direction Bit 5
DDRK_DDRK6:         equ    6                                         ; Port K Data Direction Bit 6
DDRK_DDRK7:         equ    7                                         ; Port K Data Direction Bit 7
; bit position masks
mDDRK_DDRK0:        equ    %00000001
mDDRK_DDRK1:        equ    %00000010
mDDRK_DDRK2:        equ    %00000100
mDDRK_DDRK3:        equ    %00001000
mDDRK_DDRK4:        equ    %00010000
mDDRK_DDRK5:        equ    %00100000
mDDRK_DDRK6:        equ    %01000000
mDDRK_DDRK7:        equ    %10000000


;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
SYNR:               equ    $00000034                                ;*** SYNR - CRG Synthesizer Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SYNR_SYN0:          equ    0                                         ; CRG Synthesizer Bit 0
SYNR_SYN1:          equ    1                                         ; CRG Synthesizer Bit 1
SYNR_SYN2:          equ    2                                         ; CRG Synthesizer Bit 2
SYNR_SYN3:          equ    3                                         ; CRG Synthesizer Bit 3
SYNR_SYN4:          equ    4                                         ; CRG Synthesizer Bit 4
SYNR_SYN5:          equ    5                                         ; CRG Synthesizer Bit 5
; bit position masks
mSYNR_SYN0:         equ    %00000001
mSYNR_SYN1:         equ    %00000010
mSYNR_SYN2:         equ    %00000100
mSYNR_SYN3:         equ    %00001000
mSYNR_SYN4:         equ    %00010000
mSYNR_SYN5:         equ    %00100000


;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
REFDV:              equ    $00000035                                ;*** REFDV - CRG Reference Divider Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
REFDV_REFDV0:       equ    0                                         ; CRG Reference Divider Bit 0
REFDV_REFDV1:       equ    1                                         ; CRG Reference Divider Bit 1
REFDV_REFDV2:       equ    2                                         ; CRG Reference Divider Bit 2
REFDV_REFDV3:       equ    3                                         ; CRG Reference Divider Bit 3
REFDV_REFDV4:       equ    4                                         ; CRG Reference Divider Bit 4
REFDV_REFDV5:       equ    5                                         ; CRG Reference Divider Bit 5
; bit position masks
mREFDV_REFDV0:      equ    %00000001
mREFDV_REFDV1:      equ    %00000010
mREFDV_REFDV2:      equ    %00000100
mREFDV_REFDV3:      equ    %00001000
mREFDV_REFDV4:      equ    %00010000
mREFDV_REFDV5:      equ    %00100000


;*** CRGFLG - CRG Flags Register; 0x00000037 ***
CRGFLG:             equ    $00000037                                ;*** CRGFLG - CRG Flags Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGFLG_SCM:         equ    0                                         ; Self-clock mode Status
CRGFLG_SCMIF:       equ    1                                         ; Self-clock mode Interrupt Flag
CRGFLG_TRACK:       equ    2                                         ; Track Status
CRGFLG_LOCK:        equ    3                                         ; Lock Status
CRGFLG_LOCKIF:      equ    4                                         ; PLL Lock Interrupt Flag
CRGFLG_LVRF:        equ    5                                         ; Low Voltage Reset Flag
CRGFLG_PORF:        equ    6                                         ; Power on Reset Flag
CRGFLG_RTIF:        equ    7                                         ; Real Time Interrupt Flag
; bit position masks
mCRGFLG_SCM:        equ    %00000001
mCRGFLG_SCMIF:      equ    %00000010
mCRGFLG_TRACK:      equ    %00000100
mCRGFLG_LOCK:       equ    %00001000
mCRGFLG_LOCKIF:     equ    %00010000
mCRGFLG_LVRF:       equ    %00100000
mCRGFLG_PORF:       equ    %01000000
mCRGFLG_RTIF:       equ    %10000000


;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
CRGINT:             equ    $00000038                                ;*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CRGINT_SCMIE:       equ    1                                         ; Self-clock mode Interrupt Enable
CRGINT_LOCKIE:      equ    4                                         ; Lock Interrupt Enable
CRGINT_ILAF:        equ    6                                         ; Illegal Address Reset Flag
CRGINT_RTIE:        equ    7                                         ; Real Time Interrupt Enable
; bit position masks
mCRGINT_SCMIE:      equ    %00000010
mCRGINT_LOCKIE:     equ    %00010000
mCRGINT_ILAF:       equ    %01000000
mCRGINT_RTIE:       equ    %10000000


;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
CLKSEL:             equ    $00000039                                ;*** CLKSEL - CRG Clock Select Register; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CLKSEL_COPWAI:      equ    0                                         ; COP stops in WAIT mode
CLKSEL_RTIWAI:      equ    1                                         ; RTI stops in WAIT mode
CLKSEL_PLLWAI:      equ    3                                         ; PLL stops in WAIT mode
CLKSEL_PSTP:        equ    6                                         ; Pseudo Stop
CLKSEL_PLLSEL:      equ    7                                         ; PLL selected for system clock
; bit position masks
mCLKSEL_COPWAI:     equ    %00000001
mCLKSEL_RTIWAI:     equ    %00000010
mCLKSEL_PLLWAI:     equ    %00001000
mCLKSEL_PSTP:       equ    %01000000
mCLKSEL_PLLSEL:     equ    %10000000


;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
PLLCTL:             equ    $0000003A                                ;*** PLLCTL - CRG PLL Control Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PLLCTL_SCME:        equ    0                                         ; Self-clock mode enable
PLLCTL_PCE:         equ    1                                         ; COP Enable during Pseudo Stop Bit
PLLCTL_PRE:         equ    2                                         ; RTI Enable during Pseudo Stop Bit
PLLCTL_FSTWKP:      equ    3                                         ; Fast Wake-up from Full Stop Bit
PLLCTL_ACQ:         equ    4                                         ; Acquisition
PLLCTL_AUTO:        equ    5                                         ; Automatic Bandwidth Control
PLLCTL_PLLON:       equ    6                                         ; Phase Lock Loop On
PLLCTL_CME:         equ    7                                         ; Clock Monitor Enable
; bit position masks
mPLLCTL_SCME:       equ    %00000001
mPLLCTL_PCE:        equ    %00000010
mPLLCTL_PRE:        equ    %00000100
mPLLCTL_FSTWKP:     equ    %00001000
mPLLCTL_ACQ:        equ    %00010000
mPLLCTL_AUTO:       equ    %00100000
mPLLCTL_PLLON:      equ    %01000000
mPLLCTL_CME:        equ    %10000000


;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
RTICTL:             equ    $0000003B                                ;*** RTICTL - CRG RTI Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTICTL_RTR0:        equ    0                                         ; Real Time Interrupt Modulus Counter Select Bit 0
RTICTL_RTR1:        equ    1                                         ; Real Time Interrupt Modulus Counter Select Bit 1
RTICTL_RTR2:        equ    2                                         ; Real Time Interrupt Modulus Counter Select Bit 2
RTICTL_RTR3:        equ    3                                         ; Real Time Interrupt Modulus Counter Select Bit 3
RTICTL_RTR4:        equ    4                                         ; Real Time Interrupt Prescale Rate Select Bit 4
RTICTL_RTR5:        equ    5                                         ; Real Time Interrupt Prescale Rate Select Bit 5
RTICTL_RTR6:        equ    6                                         ; Real Time Interrupt Prescale Rate Select Bit 6
RTICTL_RTDEC:       equ    7                                         ; Decimal or Binary Divider Select Bit
; bit position masks
mRTICTL_RTR0:       equ    %00000001
mRTICTL_RTR1:       equ    %00000010
mRTICTL_RTR2:       equ    %00000100
mRTICTL_RTR3:       equ    %00001000
mRTICTL_RTR4:       equ    %00010000
mRTICTL_RTR5:       equ    %00100000
mRTICTL_RTR6:       equ    %01000000
mRTICTL_RTDEC:      equ    %10000000


;*** COPCTL - CRG COP Control Register; 0x0000003C ***
COPCTL:             equ    $0000003C                                ;*** COPCTL - CRG COP Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
COPCTL_CR0:         equ    0                                         ; COP Watchdog Timer Rate select Bit 0
COPCTL_CR1:         equ    1                                         ; COP Watchdog Timer Rate select Bit 1
COPCTL_CR2:         equ    2                                         ; COP Watchdog Timer Rate select Bit 2
COPCTL_WRTMASK:     equ    5                                         ; Write Mask for WCOP and CR[2:0] Bit
COPCTL_RSBCK:       equ    6                                         ; COP and RTI stop in Active BDM mode Bit
COPCTL_WCOP:        equ    7                                         ; Window COP mode
; bit position masks
mCOPCTL_CR0:        equ    %00000001
mCOPCTL_CR1:        equ    %00000010
mCOPCTL_CR2:        equ    %00000100
mCOPCTL_WRTMASK:    equ    %00100000
mCOPCTL_RSBCK:      equ    %01000000
mCOPCTL_WCOP:       equ    %10000000


;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
ARMCOP:             equ    $0000003F                                ;*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ARMCOP_BIT0:        equ    0                                         ; CRG COP Timer Arm/Reset Bit 0
ARMCOP_BIT1:        equ    1                                         ; CRG COP Timer Arm/Reset Bit 1
ARMCOP_BIT2:        equ    2                                         ; CRG COP Timer Arm/Reset Bit 2
ARMCOP_BIT3:        equ    3                                         ; CRG COP Timer Arm/Reset Bit 3
ARMCOP_BIT4:        equ    4                                         ; CRG COP Timer Arm/Reset Bit 4
ARMCOP_BIT5:        equ    5                                         ; CRG COP Timer Arm/Reset Bit 5
ARMCOP_BIT6:        equ    6                                         ; CRG COP Timer Arm/Reset Bit 6
ARMCOP_BIT7:        equ    7                                         ; CRG COP Timer Arm/Reset Bit 7
; bit position masks
mARMCOP_BIT0:       equ    %00000001
mARMCOP_BIT1:       equ    %00000010
mARMCOP_BIT2:       equ    %00000100
mARMCOP_BIT3:       equ    %00001000
mARMCOP_BIT4:       equ    %00010000
mARMCOP_BIT5:       equ    %00100000
mARMCOP_BIT6:       equ    %01000000
mARMCOP_BIT7:       equ    %10000000


;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
TIOS:               equ    $00000040                                ;*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIOS_IOS0:          equ    0                                         ; Input Capture or Output Compare Channel Configuration Bit 0
TIOS_IOS1:          equ    1                                         ; Input Capture or Output Compare Channel Configuration Bit 1
TIOS_IOS2:          equ    2                                         ; Input Capture or Output Compare Channel Configuration Bit 2
TIOS_IOS3:          equ    3                                         ; Input Capture or Output Compare Channel Configuration Bit 3
TIOS_IOS4:          equ    4                                         ; Input Capture or Output Compare Channel Configuration Bit 4
TIOS_IOS5:          equ    5                                         ; Input Capture or Output Compare Channel Configuration Bit 5
TIOS_IOS6:          equ    6                                         ; Input Capture or Output Compare Channel Configuration Bit 6
TIOS_IOS7:          equ    7                                         ; Input Capture or Output Compare Channel Configuration Bit 7
; bit position masks
mTIOS_IOS0:         equ    %00000001
mTIOS_IOS1:         equ    %00000010
mTIOS_IOS2:         equ    %00000100
mTIOS_IOS3:         equ    %00001000
mTIOS_IOS4:         equ    %00010000
mTIOS_IOS5:         equ    %00100000
mTIOS_IOS6:         equ    %01000000
mTIOS_IOS7:         equ    %10000000


;*** CFORC - Timer Compare Force Register; 0x00000041 ***
CFORC:              equ    $00000041                                ;*** CFORC - Timer Compare Force Register; 0x00000041 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CFORC_FOC0:         equ    0                                         ; Force Output Compare Action for Channel 0
CFORC_FOC1:         equ    1                                         ; Force Output Compare Action for Channel 1
CFORC_FOC2:         equ    2                                         ; Force Output Compare Action for Channel 2
CFORC_FOC3:         equ    3                                         ; Force Output Compare Action for Channel 3
CFORC_FOC4:         equ    4                                         ; Force Output Compare Action for Channel 4
CFORC_FOC5:         equ    5                                         ; Force Output Compare Action for Channel 5
CFORC_FOC6:         equ    6                                         ; Force Output Compare Action for Channel 6
CFORC_FOC7:         equ    7                                         ; Force Output Compare Action for Channel 7
; bit position masks
mCFORC_FOC0:        equ    %00000001
mCFORC_FOC1:        equ    %00000010
mCFORC_FOC2:        equ    %00000100
mCFORC_FOC3:        equ    %00001000
mCFORC_FOC4:        equ    %00010000
mCFORC_FOC5:        equ    %00100000
mCFORC_FOC6:        equ    %01000000
mCFORC_FOC7:        equ    %10000000


;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
OC7M:               equ    $00000042                                ;*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
OC7M_OC7M0:         equ    0                                         ; Output Compare 7 Mask Bit 0
OC7M_OC7M1:         equ    1                                         ; Output Compare 7 Mask Bit 1
OC7M_OC7M2:         equ    2                                         ; Output Compare 7 Mask Bit 2
OC7M_OC7M3:         equ    3                                         ; Output Compare 7 Mask Bit 3
OC7M_OC7M4:         equ    4                                         ; Output Compare 7 Mask Bit 4
OC7M_OC7M5:         equ    5                                         ; Output Compare 7 Mask Bit 5
OC7M_OC7M6:         equ    6                                         ; Output Compare 7 Mask Bit 6
OC7M_OC7M7:         equ    7                                         ; Output Compare 7 Mask Bit 7
; bit position masks
mOC7M_OC7M0:        equ    %00000001
mOC7M_OC7M1:        equ    %00000010
mOC7M_OC7M2:        equ    %00000100
mOC7M_OC7M3:        equ    %00001000
mOC7M_OC7M4:        equ    %00010000
mOC7M_OC7M5:        equ    %00100000
mOC7M_OC7M6:        equ    %01000000
mOC7M_OC7M7:        equ    %10000000


;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***
OC7D:               equ    $00000043                                ;*** OC7D - Output Compare 7 Data Register; 0x00000043 ***


;*** TCNT - Timer Count Register; 0x00000044 ***
TCNT:               equ    $00000044                                ;*** TCNT - Timer Count Register; 0x00000044 ***


;*** TCNTHi - Timer Count Register High; 0x00000044 ***
TCNTHi:             equ    $00000044                                ;*** TCNTHi - Timer Count Register High; 0x00000044 ***


;*** TCNTLo - Timer Count Register Low; 0x00000045 ***
TCNTLo:             equ    $00000045                                ;*** TCNTLo - Timer Count Register Low; 0x00000045 ***


;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
TSCR1:              equ    $00000046                                ;*** TSCR1 - Timer System Control Register1; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR1_PRNT:         equ    3                                         ; Precision Timer
TSCR1_TFFCA:        equ    4                                         ; Timer Fast Flag Clear All
TSCR1_TSFRZ:        equ    5                                         ; Timer and Modulus Counter Stop While in Freeze Mode
TSCR1_TSWAI:        equ    6                                         ; Timer Module Stops While in Wait
TSCR1_TEN:          equ    7                                         ; Timer Enable
; bit position masks
mTSCR1_PRNT:        equ    %00001000
mTSCR1_TFFCA:       equ    %00010000
mTSCR1_TSFRZ:       equ    %00100000
mTSCR1_TSWAI:       equ    %01000000
mTSCR1_TEN:         equ    %10000000


;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
TTOV:               equ    $00000047                                ;*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TTOV_TOV0:          equ    0                                         ; Toggle On Overflow Bit 0
TTOV_TOV1:          equ    1                                         ; Toggle On Overflow Bit 1
TTOV_TOV2:          equ    2                                         ; Toggle On Overflow Bit 2
TTOV_TOV3:          equ    3                                         ; Toggle On Overflow Bit 3
TTOV_TOV4:          equ    4                                         ; Toggle On Overflow Bit 4
TTOV_TOV5:          equ    5                                         ; Toggle On Overflow Bit 5
TTOV_TOV6:          equ    6                                         ; Toggle On Overflow Bit 6
TTOV_TOV7:          equ    7                                         ; Toggle On Overflow Bit 7
; bit position masks
mTTOV_TOV0:         equ    %00000001
mTTOV_TOV1:         equ    %00000010
mTTOV_TOV2:         equ    %00000100
mTTOV_TOV3:         equ    %00001000
mTTOV_TOV4:         equ    %00010000
mTTOV_TOV5:         equ    %00100000
mTTOV_TOV6:         equ    %01000000
mTTOV_TOV7:         equ    %10000000


;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
TCTL1:              equ    $00000048                                ;*** TCTL1 - Timer Control Register 1; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL1_OL4:          equ    0                                         ; Output Level Bit 4
TCTL1_OM4:          equ    1                                         ; Output Mode Bit 4
TCTL1_OL5:          equ    2                                         ; Output Level Bit 5
TCTL1_OM5:          equ    3                                         ; Output Mode Bit 5
TCTL1_OL6:          equ    4                                         ; Output Level Bit 6
TCTL1_OM6:          equ    5                                         ; Output Mode Bit 6
TCTL1_OL7:          equ    6                                         ; Output Level Bit 7
TCTL1_OM7:          equ    7                                         ; Output Mode Bit 7
; bit position masks
mTCTL1_OL4:         equ    %00000001
mTCTL1_OM4:         equ    %00000010
mTCTL1_OL5:         equ    %00000100
mTCTL1_OM5:         equ    %00001000
mTCTL1_OL6:         equ    %00010000
mTCTL1_OM6:         equ    %00100000
mTCTL1_OL7:         equ    %01000000
mTCTL1_OM7:         equ    %10000000


;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
TCTL2:              equ    $00000049                                ;*** TCTL2 - Timer Control Register 2; 0x00000049 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL2_OL0:          equ    0                                         ; Output Level Bit 0
TCTL2_OM0:          equ    1                                         ; Output Mode Bit 0
TCTL2_OL1:          equ    2                                         ; Output Level Bit 1
TCTL2_OM1:          equ    3                                         ; Output Mode Bit 1
TCTL2_OL2:          equ    4                                         ; Output Level Bit 2
TCTL2_OM2:          equ    5                                         ; Output Mode Bit 2
TCTL2_OL3:          equ    6                                         ; Output Level Bit 3
TCTL2_OM3:          equ    7                                         ; Output Mode Bit 3
; bit position masks
mTCTL2_OL0:         equ    %00000001
mTCTL2_OM0:         equ    %00000010
mTCTL2_OL1:         equ    %00000100
mTCTL2_OM1:         equ    %00001000
mTCTL2_OL2:         equ    %00010000
mTCTL2_OM2:         equ    %00100000
mTCTL2_OL3:         equ    %01000000
mTCTL2_OM3:         equ    %10000000


;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
TCTL3:              equ    $0000004A                                ;*** TCTL3 - Timer Control Register 3; 0x0000004A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL3_EDG4A:        equ    0                                         ; Input Capture Edge Control 4A
TCTL3_EDG4B:        equ    1                                         ; Input Capture Edge Control 4B
TCTL3_EDG5A:        equ    2                                         ; Input Capture Edge Control 5A
TCTL3_EDG5B:        equ    3                                         ; Input Capture Edge Control 5B
TCTL3_EDG6A:        equ    4                                         ; Input Capture Edge Control 6A
TCTL3_EDG6B:        equ    5                                         ; Input Capture Edge Control 6B
TCTL3_EDG7A:        equ    6                                         ; Input Capture Edge Control 7A
TCTL3_EDG7B:        equ    7                                         ; Input Capture Edge Control 7B
; bit position masks
mTCTL3_EDG4A:       equ    %00000001
mTCTL3_EDG4B:       equ    %00000010
mTCTL3_EDG5A:       equ    %00000100
mTCTL3_EDG5B:       equ    %00001000
mTCTL3_EDG6A:       equ    %00010000
mTCTL3_EDG6B:       equ    %00100000
mTCTL3_EDG7A:       equ    %01000000
mTCTL3_EDG7B:       equ    %10000000


;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
TCTL4:              equ    $0000004B                                ;*** TCTL4 - Timer Control Register 4; 0x0000004B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TCTL4_EDG0A:        equ    0                                         ; Input Capture Edge Control 0A
TCTL4_EDG0B:        equ    1                                         ; Input Capture Edge Control 0B
TCTL4_EDG1A:        equ    2                                         ; Input Capture Edge Control 1A
TCTL4_EDG1B:        equ    3                                         ; Input Capture Edge Control 1B
TCTL4_EDG2A:        equ    4                                         ; Input Capture Edge Control 2A
TCTL4_EDG2B:        equ    5                                         ; Input Capture Edge Control 2B
TCTL4_EDG3A:        equ    6                                         ; Input Capture Edge Control 3A
TCTL4_EDG3B:        equ    7                                         ; Input Capture Edge Control 3B
; bit position masks
mTCTL4_EDG0A:       equ    %00000001
mTCTL4_EDG0B:       equ    %00000010
mTCTL4_EDG1A:       equ    %00000100
mTCTL4_EDG1B:       equ    %00001000
mTCTL4_EDG2A:       equ    %00010000
mTCTL4_EDG2B:       equ    %00100000
mTCTL4_EDG3A:       equ    %01000000
mTCTL4_EDG3B:       equ    %10000000


;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
TIE:                equ    $0000004C                                ;*** TIE - Timer Interrupt Enable Register; 0x0000004C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TIE_C0I:            equ    0                                         ; Input Capture/Output Compare Interrupt Enable Bit 0
TIE_C1I:            equ    1                                         ; Input Capture/Output Compare Interrupt Enable Bit 1
TIE_C2I:            equ    2                                         ; Input Capture/Output Compare Interrupt Enable Bit 2
TIE_C3I:            equ    3                                         ; Input Capture/Output Compare Interrupt Enable Bit 3
TIE_C4I:            equ    4                                         ; Input Capture/Output Compare Interrupt Enable Bit 4
TIE_C5I:            equ    5                                         ; Input Capture/Output Compare Interrupt Enable Bit 5
TIE_C6I:            equ    6                                         ; Input Capture/Output Compare Interrupt Enable Bit 6
TIE_C7I:            equ    7                                         ; Input Capture/Output Compare Interrupt Enable Bit 7
; bit position masks
mTIE_C0I:           equ    %00000001
mTIE_C1I:           equ    %00000010
mTIE_C2I:           equ    %00000100
mTIE_C3I:           equ    %00001000
mTIE_C4I:           equ    %00010000
mTIE_C5I:           equ    %00100000
mTIE_C6I:           equ    %01000000
mTIE_C7I:           equ    %10000000


;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
TSCR2:              equ    $0000004D                                ;*** TSCR2 - Timer System Control Register 2; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TSCR2_PR0:          equ    0                                         ; Timer Prescaler Select Bit 0
TSCR2_PR1:          equ    1                                         ; Timer Prescaler Select Bit 1
TSCR2_PR2:          equ    2                                         ; Timer Prescaler Select Bit 2
TSCR2_TCRE:         equ    3                                         ; Timer Counter Reset Enable
TSCR2_TOI:          equ    7                                         ; Timer Overflow Interrupt Enable
; bit position masks
mTSCR2_PR0:         equ    %00000001
mTSCR2_PR1:         equ    %00000010
mTSCR2_PR2:         equ    %00000100
mTSCR2_TCRE:        equ    %00001000
mTSCR2_TOI:         equ    %10000000


;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
TFLG1:              equ    $0000004E                                ;*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG1_C0F:          equ    0                                         ; Input Capture/Output Compare Channel Flag 0
TFLG1_C1F:          equ    1                                         ; Input Capture/Output Compare Channel Flag 1
TFLG1_C2F:          equ    2                                         ; Input Capture/Output Compare Channel Flag 2
TFLG1_C3F:          equ    3                                         ; Input Capture/Output Compare Channel Flag 3
TFLG1_C4F:          equ    4                                         ; Input Capture/Output Compare Channel Flag 4
TFLG1_C5F:          equ    5                                         ; Input Capture/Output Compare Channel Flag 5
TFLG1_C6F:          equ    6                                         ; Input Capture/Output Compare Channel Flag 6
TFLG1_C7F:          equ    7                                         ; Input Capture/Output Compare Channel Flag 7
; bit position masks
mTFLG1_C0F:         equ    %00000001
mTFLG1_C1F:         equ    %00000010
mTFLG1_C2F:         equ    %00000100
mTFLG1_C3F:         equ    %00001000
mTFLG1_C4F:         equ    %00010000
mTFLG1_C5F:         equ    %00100000
mTFLG1_C6F:         equ    %01000000
mTFLG1_C7F:         equ    %10000000


;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
TFLG2:              equ    $0000004F                                ;*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TFLG2_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTFLG2_TOF:         equ    %10000000


;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***
TC0:                equ    $00000050                                ;*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***


;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***
TC0Hi:              equ    $00000050                                ;*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***


;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***
TC0Lo:              equ    $00000051                                ;*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***


;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***
TC1:                equ    $00000052                                ;*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***


;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***
TC1Hi:              equ    $00000052                                ;*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***


;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***
TC1Lo:              equ    $00000053                                ;*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***


;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***
TC2:                equ    $00000054                                ;*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***


;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***
TC2Hi:              equ    $00000054                                ;*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***


;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***
TC2Lo:              equ    $00000055                                ;*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***


;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***
TC3:                equ    $00000056                                ;*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***


;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***
TC3Hi:              equ    $00000056                                ;*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***


;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***
TC3Lo:              equ    $00000057                                ;*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***


;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***
TC4:                equ    $00000058                                ;*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***


;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***
TC4Hi:              equ    $00000058                                ;*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***


;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***
TC4Lo:              equ    $00000059                                ;*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***


;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***
TC5:                equ    $0000005A                                ;*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***


;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***
TC5Hi:              equ    $0000005A                                ;*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***


;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***
TC5Lo:              equ    $0000005B                                ;*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***


;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***
TC6:                equ    $0000005C                                ;*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***


;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***
TC6Hi:              equ    $0000005C                                ;*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***


;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***
TC6Lo:              equ    $0000005D                                ;*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***


;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***
TC7:                equ    $0000005E                                ;*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***


;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***
TC7Hi:              equ    $0000005E                                ;*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***


;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***
TC7Lo:              equ    $0000005F                                ;*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***


;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
PACTL:              equ    $00000060                                ;*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PACTL_PAI:          equ    0                                         ; Pulse Accumulator Input Interrupt enable
PACTL_PAOVI:        equ    1                                         ; Pulse Accumulator A Overflow Interrupt enable
PACTL_CLK0:         equ    2                                         ; Clock Select Bit 0
PACTL_CLK1:         equ    3                                         ; Clock Select Bit 1
PACTL_PEDGE:        equ    4                                         ; Pulse Accumulator Edge Control
PACTL_PAMOD:        equ    5                                         ; Pulse Accumulator Mode
PACTL_PAEN:         equ    6                                         ; Pulse Accumulator A System Enable
; bit position masks
mPACTL_PAI:         equ    %00000001
mPACTL_PAOVI:       equ    %00000010
mPACTL_CLK0:        equ    %00000100
mPACTL_CLK1:        equ    %00001000
mPACTL_PEDGE:       equ    %00010000
mPACTL_PAMOD:       equ    %00100000
mPACTL_PAEN:        equ    %01000000


;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
PAFLG:              equ    $00000061                                ;*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PAFLG_PAIF:         equ    0                                         ; Pulse Accumulator Input edge Flag
PAFLG_PAOVF:        equ    1                                         ; Pulse Accumulator A Overflow Flag
; bit position masks
mPAFLG_PAIF:        equ    %00000001
mPAFLG_PAOVF:       equ    %00000010


;*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***
PACN32:             equ    $00000062                                ;*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***


;*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***
PACN3:              equ    $00000062                                ;*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***


;*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***
PACN2:              equ    $00000063                                ;*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***


;*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***
PACN10:             equ    $00000064                                ;*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***


;*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***
PACN1:              equ    $00000064                                ;*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***


;*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***
PACN0:              equ    $00000065                                ;*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***


;*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***
MCCTL:              equ    $00000066                                ;*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCCTL_MCPR0:        equ    0                                         ; Modulus Counter Prescaler select 0
MCCTL_MCPR1:        equ    1                                         ; Modulus Counter Prescaler select 1
MCCTL_MCEN:         equ    2                                         ; Modulus Down-Counter Enable
MCCTL_FLMC:         equ    3                                         ; Force Load Register into the Modulus Counter Count Register
MCCTL_ICLAT:        equ    4                                         ; Input Capture Force Latch Action
MCCTL_RDMCL:        equ    5                                         ; Read Modulus Down-Counter Load
MCCTL_MODMC:        equ    6                                         ; Modulus Mode Enable
MCCTL_MCZI:         equ    7                                         ; Modulus Counter Underflow Interrupt Enable
; bit position masks
mMCCTL_MCPR0:       equ    %00000001
mMCCTL_MCPR1:       equ    %00000010
mMCCTL_MCEN:        equ    %00000100
mMCCTL_FLMC:        equ    %00001000
mMCCTL_ICLAT:       equ    %00010000
mMCCTL_RDMCL:       equ    %00100000
mMCCTL_MODMC:       equ    %01000000
mMCCTL_MCZI:        equ    %10000000


;*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***
MCFLG:              equ    $00000067                                ;*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MCFLG_POLF0:        equ    0                                         ; First Input Capture Polarity Status 0
MCFLG_POLF1:        equ    1                                         ; First Input Capture Polarity Status 1
MCFLG_POLF2:        equ    2                                         ; First Input Capture Polarity Status 2
MCFLG_POLF3:        equ    3                                         ; First Input Capture Polarity Status 3
MCFLG_MCZF:         equ    7                                         ; Modulus Counter Underflow Flag
; bit position masks
mMCFLG_POLF0:       equ    %00000001
mMCFLG_POLF1:       equ    %00000010
mMCFLG_POLF2:       equ    %00000100
mMCFLG_POLF3:       equ    %00001000
mMCFLG_MCZF:        equ    %10000000


;*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***
ICPAR:              equ    $00000068                                ;*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICPAR_PA0EN:        equ    0                                         ; 8-Bit Pulse Accumulator 0 Enable
ICPAR_PA1EN:        equ    1                                         ; 8-Bit Pulse Accumulator 1 Enable
ICPAR_PA2EN:        equ    2                                         ; 8-Bit Pulse Accumulator 2 Enable
ICPAR_PA3EN:        equ    3                                         ; 8-Bit Pulse Accumulator 3 Enable
; bit position masks
mICPAR_PA0EN:       equ    %00000001
mICPAR_PA1EN:       equ    %00000010
mICPAR_PA2EN:       equ    %00000100
mICPAR_PA3EN:       equ    %00001000


;*** DLYCT - Delay Counter Control Register; 0x00000069 ***
DLYCT:              equ    $00000069                                ;*** DLYCT - Delay Counter Control Register; 0x00000069 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DLYCT_DLY0:         equ    0                                         ; Delay Counter Select Bit 0
DLYCT_DLY1:         equ    1                                         ; Delay Counter Select Bit 1
DLYCT_DLY2:         equ    2                                         ; Delay Counter Select Bit 2
DLYCT_DLY3:         equ    3                                         ; Delay Counter Select Bit 3
DLYCT_DLY4:         equ    4                                         ; Delay Counter Select Bit 4
DLYCT_DLY5:         equ    5                                         ; Delay Counter Select Bit 5
DLYCT_DLY6:         equ    6                                         ; Delay Counter Select Bit 6
DLYCT_DLY7:         equ    7                                         ; Delay Counter Select Bit 7
; bit position masks
mDLYCT_DLY0:        equ    %00000001
mDLYCT_DLY1:        equ    %00000010
mDLYCT_DLY2:        equ    %00000100
mDLYCT_DLY3:        equ    %00001000
mDLYCT_DLY4:        equ    %00010000
mDLYCT_DLY5:        equ    %00100000
mDLYCT_DLY6:        equ    %01000000
mDLYCT_DLY7:        equ    %10000000


;*** ICOVW - Input Control Overwrite Register; 0x0000006A ***
ICOVW:              equ    $0000006A                                ;*** ICOVW - Input Control Overwrite Register; 0x0000006A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICOVW_NOVW0:        equ    0                                         ; No Input Capture Overwrite 0
ICOVW_NOVW1:        equ    1                                         ; No Input Capture Overwrite 1
ICOVW_NOVW2:        equ    2                                         ; No Input Capture Overwrite 2
ICOVW_NOVW3:        equ    3                                         ; No Input Capture Overwrite 3
ICOVW_NOVW4:        equ    4                                         ; No Input Capture Overwrite 4
ICOVW_NOVW5:        equ    5                                         ; No Input Capture Overwrite 5
ICOVW_NOVW6:        equ    6                                         ; No Input Capture Overwrite 6
ICOVW_NOVW7:        equ    7                                         ; No Input Capture Overwrite 7
; bit position masks
mICOVW_NOVW0:       equ    %00000001
mICOVW_NOVW1:       equ    %00000010
mICOVW_NOVW2:       equ    %00000100
mICOVW_NOVW3:       equ    %00001000
mICOVW_NOVW4:       equ    %00010000
mICOVW_NOVW5:       equ    %00100000
mICOVW_NOVW6:       equ    %01000000
mICOVW_NOVW7:       equ    %10000000


;*** ICSYS - Input Control System Control Register; 0x0000006B ***
ICSYS:              equ    $0000006B                                ;*** ICSYS - Input Control System Control Register; 0x0000006B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSYS_LATQ:         equ    0                                         ; Input Control Latch or Queue Mode Enable
ICSYS_BUFEN:        equ    1                                         ; IC Buffer Enable
ICSYS_PACMX:        equ    2                                         ; 8-Bit Pulse Accumulators Maximum Count
ICSYS_TFMOD:        equ    3                                         ; Timer Flag-setting Mode
ICSYS_SH04:         equ    4                                         ; Share Input action of Input Capture Channels 0 and 4
ICSYS_SH15:         equ    5                                         ; Share Input action of Input Capture Channels 1 and 5
ICSYS_SH26:         equ    6                                         ; Share Input action of Input Capture Channels 2 and 6
ICSYS_SH37:         equ    7                                         ; Share Input action of Input Capture Channels 3 and 7
; bit position masks
mICSYS_LATQ:        equ    %00000001
mICSYS_BUFEN:       equ    %00000010
mICSYS_PACMX:       equ    %00000100
mICSYS_TFMOD:       equ    %00001000
mICSYS_SH04:        equ    %00010000
mICSYS_SH15:        equ    %00100000
mICSYS_SH26:        equ    %01000000
mICSYS_SH37:        equ    %10000000


;*** PTPSR - Precision Timer Prescaler Select; 0x0000006E ***
PTPSR:              equ    $0000006E                                ;*** PTPSR - Precision Timer Prescaler Select; 0x0000006E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTPSR_PTPS0:        equ    0                                         ; Precision Timer Prescaler Select Bit 0
PTPSR_PTPS1:        equ    1                                         ; Precision Timer Prescaler Select Bit 1
PTPSR_PTPS2:        equ    2                                         ; Precision Timer Prescaler Select Bit 2
PTPSR_PTPS3:        equ    3                                         ; Precision Timer Prescaler Select Bit 3
PTPSR_PTPS4:        equ    4                                         ; Precision Timer Prescaler Select Bit 4
PTPSR_PTPS5:        equ    5                                         ; Precision Timer Prescaler Select Bit 5
PTPSR_PTPS6:        equ    6                                         ; Precision Timer Prescaler Select Bit 6
PTPSR_PTPS7:        equ    7                                         ; Precision Timer Prescaler Select Bit 7
; bit position masks
mPTPSR_PTPS0:       equ    %00000001
mPTPSR_PTPS1:       equ    %00000010
mPTPSR_PTPS2:       equ    %00000100
mPTPSR_PTPS3:       equ    %00001000
mPTPSR_PTPS4:       equ    %00010000
mPTPSR_PTPS5:       equ    %00100000
mPTPSR_PTPS6:       equ    %01000000
mPTPSR_PTPS7:       equ    %10000000


;*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***
PTMCPSR:            equ    $0000006F                                ;*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTMCPSR_PTMPS0:     equ    0                                         ; Precision Timer Modulus Counter Prescaler Select bit 0
PTMCPSR_PTMPS1:     equ    1                                         ; Precision Timer Modulus Counter Prescaler Select bit 1
PTMCPSR_PTMPS2:     equ    2                                         ; Precision Timer Modulus Counter Prescaler Select bit 2
PTMCPSR_PTMPS3:     equ    3                                         ; Precision Timer Modulus Counter Prescaler Select bit 3
PTMCPSR_PTMPS4:     equ    4                                         ; Precision Timer Modulus Counter Prescaler Select bit 4
PTMCPSR_PTMPS5:     equ    5                                         ; Precision Timer Modulus Counter Prescaler Select bit 5
PTMCPSR_PTMPS6:     equ    6                                         ; Precision Timer Modulus Counter Prescaler Select bit 6
PTMCPSR_PTMPS7:     equ    7                                         ; Precision Timer Modulus Counter Prescaler Select bit 7
; bit position masks
mPTMCPSR_PTMPS0:    equ    %00000001
mPTMCPSR_PTMPS1:    equ    %00000010
mPTMCPSR_PTMPS2:    equ    %00000100
mPTMCPSR_PTMPS3:    equ    %00001000
mPTMCPSR_PTMPS4:    equ    %00010000
mPTMCPSR_PTMPS5:    equ    %00100000
mPTMCPSR_PTMPS6:    equ    %01000000
mPTMCPSR_PTMPS7:    equ    %10000000


;*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***
PBCTL:              equ    $00000070                                ;*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PBCTL_PBOVI:        equ    1                                         ; Pulse Accumulator B Overflow Interrupt enable
PBCTL_PBEN:         equ    6                                         ; Pulse Accumulator B System Enable
; bit position masks
mPBCTL_PBOVI:       equ    %00000010
mPBCTL_PBEN:        equ    %01000000


;*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***
PBFLG:              equ    $00000071                                ;*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PBFLG_PBOVF:        equ    1                                         ; Pulse Accumulator B Overflow Flag
; bit position masks
mPBFLG_PBOVF:       equ    %00000010


;*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***
PA32H:              equ    $00000072                                ;*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***


;*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***
PA3H:               equ    $00000072                                ;*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***


;*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***
PA2H:               equ    $00000073                                ;*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***


;*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***
PA10H:              equ    $00000074                                ;*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***


;*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***
PA1H:               equ    $00000074                                ;*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***


;*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***
PA0H:               equ    $00000075                                ;*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***


;*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***
MCCNT:              equ    $00000076                                ;*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***


;*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***
MCCNThi:            equ    $00000076                                ;*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***


;*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***
MCCNTlo:            equ    $00000077                                ;*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***


;*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***
TC0H:               equ    $00000078                                ;*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***


;*** TC0Hhi - Timer Input Capture Holding Registers 0 High; 0x00000078 ***
TC0Hhi:             equ    $00000078                                ;*** TC0Hhi - Timer Input Capture Holding Registers 0 High; 0x00000078 ***


;*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***
TC0Hlo:             equ    $00000079                                ;*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***


;*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***
TC1H:               equ    $0000007A                                ;*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***


;*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***
TC1Hhi:             equ    $0000007A                                ;*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***


;*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***
TC1Hlo:             equ    $0000007B                                ;*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***


;*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***
TC2H:               equ    $0000007C                                ;*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***


;*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***
TC2Hhi:             equ    $0000007C                                ;*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***


;*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***
TC2Hlo:             equ    $0000007D                                ;*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***


;*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***
TC3H:               equ    $0000007E                                ;*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***


;*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***
TC3Hhi:             equ    $0000007E                                ;*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***


;*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***
TC3Hlo:             equ    $0000007F                                ;*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***


;*** ATD1CTL01 - ATD 1 Control Register 01; 0x00000080 ***
ATD1CTL01:          equ    $00000080                                ;*** ATD1CTL01 - ATD 1 Control Register 01; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL01_ETRIGCH0: equ    0                                         ; External Trigger Channel Select Bit 0
ATD1CTL01_ETRIGCH1: equ    1                                         ; External Trigger Channel Select Bit 1
ATD1CTL01_ETRIGCH2: equ    2                                         ; External Trigger Channel Select Bit 2
ATD1CTL01_ETRIGCH3: equ    3                                         ; External Trigger Channel Select Bit 3
ATD1CTL01_ETRIGSEL: equ    7                                         ; External Trigger Source Select
ATD1CTL01_WRAP0:    equ    8                                         ; Wrap Around Channel Select Bit 0
ATD1CTL01_WRAP1:    equ    9                                         ; Wrap Around Channel Select Bit 1
ATD1CTL01_WRAP2:    equ    10                                        ; Wrap Around Channel Select Bit 2
ATD1CTL01_WRAP3:    equ    11                                        ; Wrap Around Channel Select Bit 3
; bit position masks
mATD1CTL01_ETRIGCH0: equ    %00000001
mATD1CTL01_ETRIGCH1: equ    %00000010
mATD1CTL01_ETRIGCH2: equ    %00000100
mATD1CTL01_ETRIGCH3: equ    %00001000
mATD1CTL01_ETRIGSEL: equ    %10000000
mATD1CTL01_WRAP0:   equ    %100000000
mATD1CTL01_WRAP1:   equ    %1000000000
mATD1CTL01_WRAP2:   equ    %10000000000
mATD1CTL01_WRAP3:   equ    %100000000000


;*** ATD1CTL0 - ATD 1 Control Register 0; 0x00000080 ***
ATD1CTL0:           equ    $00000080                                ;*** ATD1CTL0 - ATD 1 Control Register 0; 0x00000080 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL0_WRAP0:     equ    0                                         ; Wrap Around Channel Select Bit 0
ATD1CTL0_WRAP1:     equ    1                                         ; Wrap Around Channel Select Bit 1
ATD1CTL0_WRAP2:     equ    2                                         ; Wrap Around Channel Select Bit 2
ATD1CTL0_WRAP3:     equ    3                                         ; Wrap Around Channel Select Bit 3
; bit position masks
mATD1CTL0_WRAP0:    equ    %00000001
mATD1CTL0_WRAP1:    equ    %00000010
mATD1CTL0_WRAP2:    equ    %00000100
mATD1CTL0_WRAP3:    equ    %00001000


;*** ATD1CTL1 - ATD1 Control Register 1; 0x00000081 ***
ATD1CTL1:           equ    $00000081                                ;*** ATD1CTL1 - ATD1 Control Register 1; 0x00000081 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL1_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATD1CTL1_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATD1CTL1_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATD1CTL1_ETRIGCH3:  equ    3                                         ; External Trigger Channel Select Bit 3
ATD1CTL1_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
; bit position masks
mATD1CTL1_ETRIGCH0: equ    %00000001
mATD1CTL1_ETRIGCH1: equ    %00000010
mATD1CTL1_ETRIGCH2: equ    %00000100
mATD1CTL1_ETRIGCH3: equ    %00001000
mATD1CTL1_ETRIGSEL: equ    %10000000


;*** ATD1CTL23 - ATD 1 Control Register 23; 0x00000082 ***
ATD1CTL23:          equ    $00000082                                ;*** ATD1CTL23 - ATD 1 Control Register 23; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL23_FRZ0:     equ    0                                         ; Background Debug Freeze Enable Bit 0
ATD1CTL23_FRZ1:     equ    1                                         ; Background Debug Freeze Enable Bit 1
ATD1CTL23_FIFO:     equ    2                                         ; Result Register FIFO Mode
ATD1CTL23_S1C:      equ    3                                         ; Conversion Sequence Length 1
ATD1CTL23_S2C:      equ    4                                         ; Conversion Sequence Length 2
ATD1CTL23_S4C:      equ    5                                         ; Conversion Sequence Length 4
ATD1CTL23_S8C:      equ    6                                         ; Conversion Sequence Length 8
ATD1CTL23_ASCIF:    equ    8                                         ; ATD 1 Sequence Complete Interrupt Flag
ATD1CTL23_ASCIE:    equ    9                                         ; ATD 1 Sequence Complete Interrupt Enable
ATD1CTL23_ETRIGE:   equ    10                                        ; External Trigger Mode enable
ATD1CTL23_ETRIGP:   equ    11                                        ; External Trigger Polarity
ATD1CTL23_ETRIGLE:  equ    12                                        ; External Trigger Level/Edge control
ATD1CTL23_AWAI:     equ    13                                        ; ATD Power Down in Wait Mode
ATD1CTL23_AFFC:     equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATD1CTL23_ADPU:     equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATD1CTL23_FRZ0:    equ    %00000001
mATD1CTL23_FRZ1:    equ    %00000010
mATD1CTL23_FIFO:    equ    %00000100
mATD1CTL23_S1C:     equ    %00001000
mATD1CTL23_S2C:     equ    %00010000
mATD1CTL23_S4C:     equ    %00100000
mATD1CTL23_S8C:     equ    %01000000
mATD1CTL23_ASCIF:   equ    %100000000
mATD1CTL23_ASCIE:   equ    %1000000000
mATD1CTL23_ETRIGE:  equ    %10000000000
mATD1CTL23_ETRIGP:  equ    %100000000000
mATD1CTL23_ETRIGLE: equ    %1000000000000
mATD1CTL23_AWAI:    equ    %10000000000000
mATD1CTL23_AFFC:    equ    %100000000000000
mATD1CTL23_ADPU:    equ    %1000000000000000


;*** ATD1CTL2 - ATD 1 Control Register 2; 0x00000082 ***
ATD1CTL2:           equ    $00000082                                ;*** ATD1CTL2 - ATD 1 Control Register 2; 0x00000082 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL2_ASCIF:     equ    0                                         ; ATD 1 Sequence Complete Interrupt Flag
ATD1CTL2_ASCIE:     equ    1                                         ; ATD 1 Sequence Complete Interrupt Enable
ATD1CTL2_ETRIGE:    equ    2                                         ; External Trigger Mode enable
ATD1CTL2_ETRIGP:    equ    3                                         ; External Trigger Polarity
ATD1CTL2_ETRIGLE:   equ    4                                         ; External Trigger Level/Edge control
ATD1CTL2_AWAI:      equ    5                                         ; ATD Power Down in Wait Mode
ATD1CTL2_AFFC:      equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATD1CTL2_ADPU:      equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATD1CTL2_ASCIF:    equ    %00000001
mATD1CTL2_ASCIE:    equ    %00000010
mATD1CTL2_ETRIGE:   equ    %00000100
mATD1CTL2_ETRIGP:   equ    %00001000
mATD1CTL2_ETRIGLE:  equ    %00010000
mATD1CTL2_AWAI:     equ    %00100000
mATD1CTL2_AFFC:     equ    %01000000
mATD1CTL2_ADPU:     equ    %10000000


;*** ATD1CTL3 - ATD 1 Control Register 3; 0x00000083 ***
ATD1CTL3:           equ    $00000083                                ;*** ATD1CTL3 - ATD 1 Control Register 3; 0x00000083 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL3_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATD1CTL3_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATD1CTL3_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATD1CTL3_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATD1CTL3_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATD1CTL3_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATD1CTL3_S8C:       equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATD1CTL3_FRZ0:     equ    %00000001
mATD1CTL3_FRZ1:     equ    %00000010
mATD1CTL3_FIFO:     equ    %00000100
mATD1CTL3_S1C:      equ    %00001000
mATD1CTL3_S2C:      equ    %00010000
mATD1CTL3_S4C:      equ    %00100000
mATD1CTL3_S8C:      equ    %01000000


;*** ATD1CTL45 - ATD 1 Control Register 45; 0x00000084 ***
ATD1CTL45:          equ    $00000084                                ;*** ATD1CTL45 - ATD 1 Control Register 45; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL45_CA:       equ    0                                         ; Analog Input Channel Select Code A
ATD1CTL45_CB:       equ    1                                         ; Analog Input Channel Select Code B
ATD1CTL45_CC:       equ    2                                         ; Analog Input Channel Select Code C
ATD1CTL45_CD:       equ    3                                         ; Analog Input Channel Select Code D
ATD1CTL45_MULT:     equ    4                                         ; Multi-Channel Sample Mode
ATD1CTL45_SCAN:     equ    5                                         ; Continuous Conversion Sequence Mode
ATD1CTL45_DSGN:     equ    6                                         ; Signed/Unsigned Result Data Mode
ATD1CTL45_DJM:      equ    7                                         ; Result Register Data Justification Mode
ATD1CTL45_PRS0:     equ    8                                         ; ATD Clock Prescaler 0
ATD1CTL45_PRS1:     equ    9                                         ; ATD Clock Prescaler 1
ATD1CTL45_PRS2:     equ    10                                        ; ATD Clock Prescaler 2
ATD1CTL45_PRS3:     equ    11                                        ; ATD Clock Prescaler 3
ATD1CTL45_PRS4:     equ    12                                        ; ATD Clock Prescaler 4
ATD1CTL45_SMP0:     equ    13                                        ; Sample Time Select 0
ATD1CTL45_SMP1:     equ    14                                        ; Sample Time Select 1
ATD1CTL45_SRES8:    equ    15                                        ; ATD Resolution Select
; bit position masks
mATD1CTL45_CA:      equ    %00000001
mATD1CTL45_CB:      equ    %00000010
mATD1CTL45_CC:      equ    %00000100
mATD1CTL45_CD:      equ    %00001000
mATD1CTL45_MULT:    equ    %00010000
mATD1CTL45_SCAN:    equ    %00100000
mATD1CTL45_DSGN:    equ    %01000000
mATD1CTL45_DJM:     equ    %10000000
mATD1CTL45_PRS0:    equ    %100000000
mATD1CTL45_PRS1:    equ    %1000000000
mATD1CTL45_PRS2:    equ    %10000000000
mATD1CTL45_PRS3:    equ    %100000000000
mATD1CTL45_PRS4:    equ    %1000000000000
mATD1CTL45_SMP0:    equ    %10000000000000
mATD1CTL45_SMP1:    equ    %100000000000000
mATD1CTL45_SRES8:   equ    %1000000000000000


;*** ATD1CTL4 - ATD 1 Control Register 4; 0x00000084 ***
ATD1CTL4:           equ    $00000084                                ;*** ATD1CTL4 - ATD 1 Control Register 4; 0x00000084 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL4_PRS0:      equ    0                                         ; ATD Clock Prescaler 0
ATD1CTL4_PRS1:      equ    1                                         ; ATD Clock Prescaler 1
ATD1CTL4_PRS2:      equ    2                                         ; ATD Clock Prescaler 2
ATD1CTL4_PRS3:      equ    3                                         ; ATD Clock Prescaler 3
ATD1CTL4_PRS4:      equ    4                                         ; ATD Clock Prescaler 4
ATD1CTL4_SMP0:      equ    5                                         ; Sample Time Select 0
ATD1CTL4_SMP1:      equ    6                                         ; Sample Time Select 1
ATD1CTL4_SRES8:     equ    7                                         ; ATD Resolution Select
; bit position masks
mATD1CTL4_PRS0:     equ    %00000001
mATD1CTL4_PRS1:     equ    %00000010
mATD1CTL4_PRS2:     equ    %00000100
mATD1CTL4_PRS3:     equ    %00001000
mATD1CTL4_PRS4:     equ    %00010000
mATD1CTL4_SMP0:     equ    %00100000
mATD1CTL4_SMP1:     equ    %01000000
mATD1CTL4_SRES8:    equ    %10000000


;*** ATD1CTL5 - ATD 1 Control Register 5; 0x00000085 ***
ATD1CTL5:           equ    $00000085                                ;*** ATD1CTL5 - ATD 1 Control Register 5; 0x00000085 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1CTL5_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATD1CTL5_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATD1CTL5_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATD1CTL5_CD:        equ    3                                         ; Analog Input Channel Select Code D
ATD1CTL5_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATD1CTL5_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATD1CTL5_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATD1CTL5_DJM:       equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATD1CTL5_CA:       equ    %00000001
mATD1CTL5_CB:       equ    %00000010
mATD1CTL5_CC:       equ    %00000100
mATD1CTL5_CD:       equ    %00001000
mATD1CTL5_MULT:     equ    %00010000
mATD1CTL5_SCAN:     equ    %00100000
mATD1CTL5_DSGN:     equ    %01000000
mATD1CTL5_DJM:      equ    %10000000


;*** ATD1STAT0 - ATD 1 Status Register 0; 0x00000086 ***
ATD1STAT0:          equ    $00000086                                ;*** ATD1STAT0 - ATD 1 Status Register 0; 0x00000086 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1STAT0_CC0:      equ    0                                         ; Conversion Counter 0
ATD1STAT0_CC1:      equ    1                                         ; Conversion Counter 1
ATD1STAT0_CC2:      equ    2                                         ; Conversion Counter 2
ATD1STAT0_CC3:      equ    3                                         ; Conversion Counter 3
ATD1STAT0_FIFOR:    equ    4                                         ; FIFO Over Run Flag
ATD1STAT0_ETORF:    equ    5                                         ; External Trigger Overrun Flag
ATD1STAT0_SCF:      equ    7                                         ; Sequence Complete Flag
; bit position masks
mATD1STAT0_CC0:     equ    %00000001
mATD1STAT0_CC1:     equ    %00000010
mATD1STAT0_CC2:     equ    %00000100
mATD1STAT0_CC3:     equ    %00001000
mATD1STAT0_FIFOR:   equ    %00010000
mATD1STAT0_ETORF:   equ    %00100000
mATD1STAT0_SCF:     equ    %10000000


;*** ATD1TEST1 - ATD1 Test Register; 0x00000089 ***
ATD1TEST1:          equ    $00000089                                ;*** ATD1TEST1 - ATD1 Test Register; 0x00000089 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1TEST1_SC:       equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATD1TEST1_SC:      equ    %00000001


;*** ATD1STAT2 - ATD 1 Status Register 2; 0x0000008A ***
ATD1STAT2:          equ    $0000008A                                ;*** ATD1STAT2 - ATD 1 Status Register 2; 0x0000008A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1STAT2_CCF8:     equ    0                                         ; Conversion Complete Flag 8
ATD1STAT2_CCF9:     equ    1                                         ; Conversion Complete Flag 9
ATD1STAT2_CCF10:    equ    2                                         ; Conversion Complete Flag 10
ATD1STAT2_CCF11:    equ    3                                         ; Conversion Complete Flag 11
ATD1STAT2_CCF12:    equ    4                                         ; Conversion Complete Flag 12
ATD1STAT2_CCF13:    equ    5                                         ; Conversion Complete Flag 13
ATD1STAT2_CCF14:    equ    6                                         ; Conversion Complete Flag 14
ATD1STAT2_CCF15:    equ    7                                         ; Conversion Complete Flag 15
; bit position masks
mATD1STAT2_CCF8:    equ    %00000001
mATD1STAT2_CCF9:    equ    %00000010
mATD1STAT2_CCF10:   equ    %00000100
mATD1STAT2_CCF11:   equ    %00001000
mATD1STAT2_CCF12:   equ    %00010000
mATD1STAT2_CCF13:   equ    %00100000
mATD1STAT2_CCF14:   equ    %01000000
mATD1STAT2_CCF15:   equ    %10000000


;*** ATD1STAT1 - ATD 1 Status Register 1; 0x0000008B ***
ATD1STAT1:          equ    $0000008B                                ;*** ATD1STAT1 - ATD 1 Status Register 1; 0x0000008B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1STAT1_CCF0:     equ    0                                         ; Conversion Complete Flag 0
ATD1STAT1_CCF1:     equ    1                                         ; Conversion Complete Flag 1
ATD1STAT1_CCF2:     equ    2                                         ; Conversion Complete Flag 2
ATD1STAT1_CCF3:     equ    3                                         ; Conversion Complete Flag 3
ATD1STAT1_CCF4:     equ    4                                         ; Conversion Complete Flag 4
ATD1STAT1_CCF5:     equ    5                                         ; Conversion Complete Flag 5
ATD1STAT1_CCF6:     equ    6                                         ; Conversion Complete Flag 6
ATD1STAT1_CCF7:     equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATD1STAT1_CCF0:    equ    %00000001
mATD1STAT1_CCF1:    equ    %00000010
mATD1STAT1_CCF2:    equ    %00000100
mATD1STAT1_CCF3:    equ    %00001000
mATD1STAT1_CCF4:    equ    %00010000
mATD1STAT1_CCF5:    equ    %00100000
mATD1STAT1_CCF6:    equ    %01000000
mATD1STAT1_CCF7:    equ    %10000000


;*** ATD1DIEN - ATD 1 Input Enable Register; 0x0000008C ***
ATD1DIEN:           equ    $0000008C                                ;*** ATD1DIEN - ATD 1 Input Enable Register; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DIEN_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATD1DIEN_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATD1DIEN_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATD1DIEN_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATD1DIEN_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATD1DIEN_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATD1DIEN_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATD1DIEN_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
ATD1DIEN_IEN8:      equ    8                                         ; ATD Digital Input Enable on channel 8
ATD1DIEN_IEN9:      equ    9                                         ; ATD Digital Input Enable on channel 9
ATD1DIEN_IEN10:     equ    10                                        ; ATD Digital Input Enable on channel 10
ATD1DIEN_IEN11:     equ    11                                        ; ATD Digital Input Enable on channel 11
ATD1DIEN_IEN12:     equ    12                                        ; ATD Digital Input Enable on channel 12
ATD1DIEN_IEN13:     equ    13                                        ; ATD Digital Input Enable on channel 13
ATD1DIEN_IEN14:     equ    14                                        ; ATD Digital Input Enable on channel 14
ATD1DIEN_IEN15:     equ    15                                        ; ATD Digital Input Enable on channel 15
; bit position masks
mATD1DIEN_IEN0:     equ    %00000001
mATD1DIEN_IEN1:     equ    %00000010
mATD1DIEN_IEN2:     equ    %00000100
mATD1DIEN_IEN3:     equ    %00001000
mATD1DIEN_IEN4:     equ    %00010000
mATD1DIEN_IEN5:     equ    %00100000
mATD1DIEN_IEN6:     equ    %01000000
mATD1DIEN_IEN7:     equ    %10000000
mATD1DIEN_IEN8:     equ    %100000000
mATD1DIEN_IEN9:     equ    %1000000000
mATD1DIEN_IEN10:    equ    %10000000000
mATD1DIEN_IEN11:    equ    %100000000000
mATD1DIEN_IEN12:    equ    %1000000000000
mATD1DIEN_IEN13:    equ    %10000000000000
mATD1DIEN_IEN14:    equ    %100000000000000
mATD1DIEN_IEN15:    equ    %1000000000000000


;*** ATD1DIEN0 - ATD 1 Input Enable Register 0; 0x0000008C ***
ATD1DIEN0:          equ    $0000008C                                ;*** ATD1DIEN0 - ATD 1 Input Enable Register 0; 0x0000008C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DIEN0_IEN8:     equ    0                                         ; ATD Digital Input Enable on channel 8
ATD1DIEN0_IEN9:     equ    1                                         ; ATD Digital Input Enable on channel 9
ATD1DIEN0_IEN10:    equ    2                                         ; ATD Digital Input Enable on channel 10
ATD1DIEN0_IEN11:    equ    3                                         ; ATD Digital Input Enable on channel 11
ATD1DIEN0_IEN12:    equ    4                                         ; ATD Digital Input Enable on channel 12
ATD1DIEN0_IEN13:    equ    5                                         ; ATD Digital Input Enable on channel 13
ATD1DIEN0_IEN14:    equ    6                                         ; ATD Digital Input Enable on channel 14
ATD1DIEN0_IEN15:    equ    7                                         ; ATD Digital Input Enable on channel 15
; bit position masks
mATD1DIEN0_IEN8:    equ    %00000001
mATD1DIEN0_IEN9:    equ    %00000010
mATD1DIEN0_IEN10:   equ    %00000100
mATD1DIEN0_IEN11:   equ    %00001000
mATD1DIEN0_IEN12:   equ    %00010000
mATD1DIEN0_IEN13:   equ    %00100000
mATD1DIEN0_IEN14:   equ    %01000000
mATD1DIEN0_IEN15:   equ    %10000000


;*** ATD1DIEN1 - ATD 1 Input Enable Register 1; 0x0000008D ***
ATD1DIEN1:          equ    $0000008D                                ;*** ATD1DIEN1 - ATD 1 Input Enable Register 1; 0x0000008D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DIEN1_IEN0:     equ    0                                         ; ATD Digital Input Enable on channel 0
ATD1DIEN1_IEN1:     equ    1                                         ; ATD Digital Input Enable on channel 1
ATD1DIEN1_IEN2:     equ    2                                         ; ATD Digital Input Enable on channel 2
ATD1DIEN1_IEN3:     equ    3                                         ; ATD Digital Input Enable on channel 3
ATD1DIEN1_IEN4:     equ    4                                         ; ATD Digital Input Enable on channel 4
ATD1DIEN1_IEN5:     equ    5                                         ; ATD Digital Input Enable on channel 5
ATD1DIEN1_IEN6:     equ    6                                         ; ATD Digital Input Enable on channel 6
ATD1DIEN1_IEN7:     equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATD1DIEN1_IEN0:    equ    %00000001
mATD1DIEN1_IEN1:    equ    %00000010
mATD1DIEN1_IEN2:    equ    %00000100
mATD1DIEN1_IEN3:    equ    %00001000
mATD1DIEN1_IEN4:    equ    %00010000
mATD1DIEN1_IEN5:    equ    %00100000
mATD1DIEN1_IEN6:    equ    %01000000
mATD1DIEN1_IEN7:    equ    %10000000


;*** ATD1PTAD - ATD1 Port AD Register; 0x0000008E ***
ATD1PTAD:           equ    $0000008E                                ;*** ATD1PTAD - ATD1 Port AD Register; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1PTAD_PTAD0:     equ    0                                         ; A/D Channel 0 (AN0) Digital Input
ATD1PTAD_PTAD1:     equ    1                                         ; A/D Channel 1 (AN1) Digital Input
ATD1PTAD_PTAD2:     equ    2                                         ; A/D Channel 2 (AN2) Digital Input
ATD1PTAD_PTAD3:     equ    3                                         ; A/D Channel 3 (AN3) Digital Input
ATD1PTAD_PTAD4:     equ    4                                         ; A/D Channel 4 (AN4) Digital Input
ATD1PTAD_PTAD5:     equ    5                                         ; A/D Channel 5 (AN5) Digital Input
ATD1PTAD_PTAD6:     equ    6                                         ; A/D Channel 6 (AN6) Digital Input
ATD1PTAD_PTAD7:     equ    7                                         ; A/D Channel 7 (AN7) Digital Input
ATD1PTAD_PTAD8:     equ    8                                         ; A/D Channel 8 (AN8) Digital Input
ATD1PTAD_PTAD9:     equ    9                                         ; A/D Channel 9 (AN9) Digital Input
ATD1PTAD_PTAD10:    equ    10                                        ; A/D Channel 10 (AN10) Digital Input
ATD1PTAD_PTAD11:    equ    11                                        ; A/D Channel 11 (AN11) Digital Input
ATD1PTAD_PTAD12:    equ    12                                        ; A/D Channel 12 (AN12) Digital Input
ATD1PTAD_PTAD13:    equ    13                                        ; A/D Channel 13 (AN13) Digital Input
ATD1PTAD_PTAD14:    equ    14                                        ; A/D Channel 14 (AN14) Digital Input
ATD1PTAD_PTAD15:    equ    15                                        ; A/D Channel 15 (AN15) Digital Input
; bit position masks
mATD1PTAD_PTAD0:    equ    %00000001
mATD1PTAD_PTAD1:    equ    %00000010
mATD1PTAD_PTAD2:    equ    %00000100
mATD1PTAD_PTAD3:    equ    %00001000
mATD1PTAD_PTAD4:    equ    %00010000
mATD1PTAD_PTAD5:    equ    %00100000
mATD1PTAD_PTAD6:    equ    %01000000
mATD1PTAD_PTAD7:    equ    %10000000
mATD1PTAD_PTAD8:    equ    %100000000
mATD1PTAD_PTAD9:    equ    %1000000000
mATD1PTAD_PTAD10:   equ    %10000000000
mATD1PTAD_PTAD11:   equ    %100000000000
mATD1PTAD_PTAD12:   equ    %1000000000000
mATD1PTAD_PTAD13:   equ    %10000000000000
mATD1PTAD_PTAD14:   equ    %100000000000000
mATD1PTAD_PTAD15:   equ    %1000000000000000


;*** ATD1PTAD0 - ATD1 Port AD0 Register; 0x0000008E ***
ATD1PTAD0:          equ    $0000008E                                ;*** ATD1PTAD0 - ATD1 Port AD0 Register; 0x0000008E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1PTAD0_PTAD8:    equ    0                                         ; A/D Channel 8 (AN8) Digital Input
ATD1PTAD0_PTAD9:    equ    1                                         ; A/D Channel 9 (AN9) Digital Input
ATD1PTAD0_PTAD10:   equ    2                                         ; A/D Channel 10 (AN10) Digital Input
ATD1PTAD0_PTAD11:   equ    3                                         ; A/D Channel 11 (AN11) Digital Input
ATD1PTAD0_PTAD12:   equ    4                                         ; A/D Channel 12 (AN12) Digital Input
ATD1PTAD0_PTAD13:   equ    5                                         ; A/D Channel 13 (AN13) Digital Input
ATD1PTAD0_PTAD14:   equ    6                                         ; A/D Channel 14 (AN14) Digital Input
ATD1PTAD0_PTAD15:   equ    7                                         ; A/D Channel 15 (AN15) Digital Input
; bit position masks
mATD1PTAD0_PTAD8:   equ    %00000001
mATD1PTAD0_PTAD9:   equ    %00000010
mATD1PTAD0_PTAD10:  equ    %00000100
mATD1PTAD0_PTAD11:  equ    %00001000
mATD1PTAD0_PTAD12:  equ    %00010000
mATD1PTAD0_PTAD13:  equ    %00100000
mATD1PTAD0_PTAD14:  equ    %01000000
mATD1PTAD0_PTAD15:  equ    %10000000


;*** ATD1PTAD1 - ATD1 Port AD1 Register; 0x0000008F ***
ATD1PTAD1:          equ    $0000008F                                ;*** ATD1PTAD1 - ATD1 Port AD1 Register; 0x0000008F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1PTAD1_PTAD0:    equ    0                                         ; A/D Channel 0 (AN0) Digital Input
ATD1PTAD1_PTAD1:    equ    1                                         ; A/D Channel 1 (AN1) Digital Input
ATD1PTAD1_PTAD2:    equ    2                                         ; A/D Channel 2 (AN2) Digital Input
ATD1PTAD1_PTAD3:    equ    3                                         ; A/D Channel 3 (AN3) Digital Input
ATD1PTAD1_PTAD4:    equ    4                                         ; A/D Channel 4 (AN4) Digital Input
ATD1PTAD1_PTAD5:    equ    5                                         ; A/D Channel 5 (AN5) Digital Input
ATD1PTAD1_PTAD6:    equ    6                                         ; A/D Channel 6 (AN6) Digital Input
ATD1PTAD1_PTAD7:    equ    7                                         ; A/D Channel 7 (AN7) Digital Input
; bit position masks
mATD1PTAD1_PTAD0:   equ    %00000001
mATD1PTAD1_PTAD1:   equ    %00000010
mATD1PTAD1_PTAD2:   equ    %00000100
mATD1PTAD1_PTAD3:   equ    %00001000
mATD1PTAD1_PTAD4:   equ    %00010000
mATD1PTAD1_PTAD5:   equ    %00100000
mATD1PTAD1_PTAD6:   equ    %01000000
mATD1PTAD1_PTAD7:   equ    %10000000


;*** ATD1DR0 - ATD 1 Conversion Result Register 0; 0x00000090 ***
ATD1DR0:            equ    $00000090                                ;*** ATD1DR0 - ATD 1 Conversion Result Register 0; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR0_BIT6:       equ    6                                         ; Bit 6
ATD1DR0_BIT7:       equ    7                                         ; Bit 7
ATD1DR0_BIT8:       equ    8                                         ; Bit 8
ATD1DR0_BIT9:       equ    9                                         ; Bit 9
ATD1DR0_BIT10:      equ    10                                        ; Bit 10
ATD1DR0_BIT11:      equ    11                                        ; Bit 11
ATD1DR0_BIT12:      equ    12                                        ; Bit 12
ATD1DR0_BIT13:      equ    13                                        ; Bit 13
ATD1DR0_BIT14:      equ    14                                        ; Bit 14
ATD1DR0_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR0_BIT6:      equ    %01000000
mATD1DR0_BIT7:      equ    %10000000
mATD1DR0_BIT8:      equ    %100000000
mATD1DR0_BIT9:      equ    %1000000000
mATD1DR0_BIT10:     equ    %10000000000
mATD1DR0_BIT11:     equ    %100000000000
mATD1DR0_BIT12:     equ    %1000000000000
mATD1DR0_BIT13:     equ    %10000000000000
mATD1DR0_BIT14:     equ    %100000000000000
mATD1DR0_BIT15:     equ    %1000000000000000


;*** ATD1DR0H - ATD 1 Conversion Result Register 0 High; 0x00000090 ***
ATD1DR0H:           equ    $00000090                                ;*** ATD1DR0H - ATD 1 Conversion Result Register 0 High; 0x00000090 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR0H_BIT8:      equ    0                                         ; Bit 8
ATD1DR0H_BIT9:      equ    1                                         ; Bit 9
ATD1DR0H_BIT10:     equ    2                                         ; Bit 10
ATD1DR0H_BIT11:     equ    3                                         ; Bit 11
ATD1DR0H_BIT12:     equ    4                                         ; Bit 12
ATD1DR0H_BIT13:     equ    5                                         ; Bit 13
ATD1DR0H_BIT14:     equ    6                                         ; Bit 14
ATD1DR0H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR0H_BIT8:     equ    %00000001
mATD1DR0H_BIT9:     equ    %00000010
mATD1DR0H_BIT10:    equ    %00000100
mATD1DR0H_BIT11:    equ    %00001000
mATD1DR0H_BIT12:    equ    %00010000
mATD1DR0H_BIT13:    equ    %00100000
mATD1DR0H_BIT14:    equ    %01000000
mATD1DR0H_BIT15:    equ    %10000000


;*** ATD1DR0L - ATD 1 Conversion Result Register 0 Low; 0x00000091 ***
ATD1DR0L:           equ    $00000091                                ;*** ATD1DR0L - ATD 1 Conversion Result Register 0 Low; 0x00000091 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR0L_BIT6:      equ    6                                         ; Bit 6
ATD1DR0L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR0L_BIT6:     equ    %01000000
mATD1DR0L_BIT7:     equ    %10000000


;*** ATD1DR1 - ATD 1 Conversion Result Register 1; 0x00000092 ***
ATD1DR1:            equ    $00000092                                ;*** ATD1DR1 - ATD 1 Conversion Result Register 1; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR1_BIT6:       equ    6                                         ; Bit 6
ATD1DR1_BIT7:       equ    7                                         ; Bit 7
ATD1DR1_BIT8:       equ    8                                         ; Bit 8
ATD1DR1_BIT9:       equ    9                                         ; Bit 9
ATD1DR1_BIT10:      equ    10                                        ; Bit 10
ATD1DR1_BIT11:      equ    11                                        ; Bit 11
ATD1DR1_BIT12:      equ    12                                        ; Bit 12
ATD1DR1_BIT13:      equ    13                                        ; Bit 13
ATD1DR1_BIT14:      equ    14                                        ; Bit 14
ATD1DR1_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR1_BIT6:      equ    %01000000
mATD1DR1_BIT7:      equ    %10000000
mATD1DR1_BIT8:      equ    %100000000
mATD1DR1_BIT9:      equ    %1000000000
mATD1DR1_BIT10:     equ    %10000000000
mATD1DR1_BIT11:     equ    %100000000000
mATD1DR1_BIT12:     equ    %1000000000000
mATD1DR1_BIT13:     equ    %10000000000000
mATD1DR1_BIT14:     equ    %100000000000000
mATD1DR1_BIT15:     equ    %1000000000000000


;*** ATD1DR1H - ATD 1 Conversion Result Register 1 High; 0x00000092 ***
ATD1DR1H:           equ    $00000092                                ;*** ATD1DR1H - ATD 1 Conversion Result Register 1 High; 0x00000092 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR1H_BIT8:      equ    0                                         ; Bit 8
ATD1DR1H_BIT9:      equ    1                                         ; Bit 9
ATD1DR1H_BIT10:     equ    2                                         ; Bit 10
ATD1DR1H_BIT11:     equ    3                                         ; Bit 11
ATD1DR1H_BIT12:     equ    4                                         ; Bit 12
ATD1DR1H_BIT13:     equ    5                                         ; Bit 13
ATD1DR1H_BIT14:     equ    6                                         ; Bit 14
ATD1DR1H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR1H_BIT8:     equ    %00000001
mATD1DR1H_BIT9:     equ    %00000010
mATD1DR1H_BIT10:    equ    %00000100
mATD1DR1H_BIT11:    equ    %00001000
mATD1DR1H_BIT12:    equ    %00010000
mATD1DR1H_BIT13:    equ    %00100000
mATD1DR1H_BIT14:    equ    %01000000
mATD1DR1H_BIT15:    equ    %10000000


;*** ATD1DR1L - ATD 1 Conversion Result Register 1 Low; 0x00000093 ***
ATD1DR1L:           equ    $00000093                                ;*** ATD1DR1L - ATD 1 Conversion Result Register 1 Low; 0x00000093 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR1L_BIT6:      equ    6                                         ; Bit 6
ATD1DR1L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR1L_BIT6:     equ    %01000000
mATD1DR1L_BIT7:     equ    %10000000


;*** ATD1DR2 - ATD 1 Conversion Result Register 2; 0x00000094 ***
ATD1DR2:            equ    $00000094                                ;*** ATD1DR2 - ATD 1 Conversion Result Register 2; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR2_BIT6:       equ    6                                         ; Bit 6
ATD1DR2_BIT7:       equ    7                                         ; Bit 7
ATD1DR2_BIT8:       equ    8                                         ; Bit 8
ATD1DR2_BIT9:       equ    9                                         ; Bit 9
ATD1DR2_BIT10:      equ    10                                        ; Bit 10
ATD1DR2_BIT11:      equ    11                                        ; Bit 11
ATD1DR2_BIT12:      equ    12                                        ; Bit 12
ATD1DR2_BIT13:      equ    13                                        ; Bit 13
ATD1DR2_BIT14:      equ    14                                        ; Bit 14
ATD1DR2_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR2_BIT6:      equ    %01000000
mATD1DR2_BIT7:      equ    %10000000
mATD1DR2_BIT8:      equ    %100000000
mATD1DR2_BIT9:      equ    %1000000000
mATD1DR2_BIT10:     equ    %10000000000
mATD1DR2_BIT11:     equ    %100000000000
mATD1DR2_BIT12:     equ    %1000000000000
mATD1DR2_BIT13:     equ    %10000000000000
mATD1DR2_BIT14:     equ    %100000000000000
mATD1DR2_BIT15:     equ    %1000000000000000


;*** ATD1DR2H - ATD 1 Conversion Result Register 2 High; 0x00000094 ***
ATD1DR2H:           equ    $00000094                                ;*** ATD1DR2H - ATD 1 Conversion Result Register 2 High; 0x00000094 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR2H_BIT8:      equ    0                                         ; Bit 8
ATD1DR2H_BIT9:      equ    1                                         ; Bit 9
ATD1DR2H_BIT10:     equ    2                                         ; Bit 10
ATD1DR2H_BIT11:     equ    3                                         ; Bit 11
ATD1DR2H_BIT12:     equ    4                                         ; Bit 12
ATD1DR2H_BIT13:     equ    5                                         ; Bit 13
ATD1DR2H_BIT14:     equ    6                                         ; Bit 14
ATD1DR2H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR2H_BIT8:     equ    %00000001
mATD1DR2H_BIT9:     equ    %00000010
mATD1DR2H_BIT10:    equ    %00000100
mATD1DR2H_BIT11:    equ    %00001000
mATD1DR2H_BIT12:    equ    %00010000
mATD1DR2H_BIT13:    equ    %00100000
mATD1DR2H_BIT14:    equ    %01000000
mATD1DR2H_BIT15:    equ    %10000000


;*** ATD1DR2L - ATD 1 Conversion Result Register 2 Low; 0x00000095 ***
ATD1DR2L:           equ    $00000095                                ;*** ATD1DR2L - ATD 1 Conversion Result Register 2 Low; 0x00000095 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR2L_BIT6:      equ    6                                         ; Bit 6
ATD1DR2L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR2L_BIT6:     equ    %01000000
mATD1DR2L_BIT7:     equ    %10000000


;*** ATD1DR3 - ATD 1 Conversion Result Register 3; 0x00000096 ***
ATD1DR3:            equ    $00000096                                ;*** ATD1DR3 - ATD 1 Conversion Result Register 3; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR3_BIT6:       equ    6                                         ; Bit 6
ATD1DR3_BIT7:       equ    7                                         ; Bit 7
ATD1DR3_BIT8:       equ    8                                         ; Bit 8
ATD1DR3_BIT9:       equ    9                                         ; Bit 9
ATD1DR3_BIT10:      equ    10                                        ; Bit 10
ATD1DR3_BIT11:      equ    11                                        ; Bit 11
ATD1DR3_BIT12:      equ    12                                        ; Bit 12
ATD1DR3_BIT13:      equ    13                                        ; Bit 13
ATD1DR3_BIT14:      equ    14                                        ; Bit 14
ATD1DR3_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR3_BIT6:      equ    %01000000
mATD1DR3_BIT7:      equ    %10000000
mATD1DR3_BIT8:      equ    %100000000
mATD1DR3_BIT9:      equ    %1000000000
mATD1DR3_BIT10:     equ    %10000000000
mATD1DR3_BIT11:     equ    %100000000000
mATD1DR3_BIT12:     equ    %1000000000000
mATD1DR3_BIT13:     equ    %10000000000000
mATD1DR3_BIT14:     equ    %100000000000000
mATD1DR3_BIT15:     equ    %1000000000000000


;*** ATD1DR3H - ATD 1 Conversion Result Register 3 High; 0x00000096 ***
ATD1DR3H:           equ    $00000096                                ;*** ATD1DR3H - ATD 1 Conversion Result Register 3 High; 0x00000096 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR3H_BIT8:      equ    0                                         ; Bit 8
ATD1DR3H_BIT9:      equ    1                                         ; Bit 9
ATD1DR3H_BIT10:     equ    2                                         ; Bit 10
ATD1DR3H_BIT11:     equ    3                                         ; Bit 11
ATD1DR3H_BIT12:     equ    4                                         ; Bit 12
ATD1DR3H_BIT13:     equ    5                                         ; Bit 13
ATD1DR3H_BIT14:     equ    6                                         ; Bit 14
ATD1DR3H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR3H_BIT8:     equ    %00000001
mATD1DR3H_BIT9:     equ    %00000010
mATD1DR3H_BIT10:    equ    %00000100
mATD1DR3H_BIT11:    equ    %00001000
mATD1DR3H_BIT12:    equ    %00010000
mATD1DR3H_BIT13:    equ    %00100000
mATD1DR3H_BIT14:    equ    %01000000
mATD1DR3H_BIT15:    equ    %10000000


;*** ATD1DR3L - ATD 1 Conversion Result Register 3 Low; 0x00000097 ***
ATD1DR3L:           equ    $00000097                                ;*** ATD1DR3L - ATD 1 Conversion Result Register 3 Low; 0x00000097 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR3L_BIT6:      equ    6                                         ; Bit 6
ATD1DR3L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR3L_BIT6:     equ    %01000000
mATD1DR3L_BIT7:     equ    %10000000


;*** ATD1DR4 - ATD 1 Conversion Result Register 4; 0x00000098 ***
ATD1DR4:            equ    $00000098                                ;*** ATD1DR4 - ATD 1 Conversion Result Register 4; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR4_BIT6:       equ    6                                         ; Bit 6
ATD1DR4_BIT7:       equ    7                                         ; Bit 7
ATD1DR4_BIT8:       equ    8                                         ; Bit 8
ATD1DR4_BIT9:       equ    9                                         ; Bit 9
ATD1DR4_BIT10:      equ    10                                        ; Bit 10
ATD1DR4_BIT11:      equ    11                                        ; Bit 11
ATD1DR4_BIT12:      equ    12                                        ; Bit 12
ATD1DR4_BIT13:      equ    13                                        ; Bit 13
ATD1DR4_BIT14:      equ    14                                        ; Bit 14
ATD1DR4_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR4_BIT6:      equ    %01000000
mATD1DR4_BIT7:      equ    %10000000
mATD1DR4_BIT8:      equ    %100000000
mATD1DR4_BIT9:      equ    %1000000000
mATD1DR4_BIT10:     equ    %10000000000
mATD1DR4_BIT11:     equ    %100000000000
mATD1DR4_BIT12:     equ    %1000000000000
mATD1DR4_BIT13:     equ    %10000000000000
mATD1DR4_BIT14:     equ    %100000000000000
mATD1DR4_BIT15:     equ    %1000000000000000


;*** ATD1DR4H - ATD 1 Conversion Result Register 4 High; 0x00000098 ***
ATD1DR4H:           equ    $00000098                                ;*** ATD1DR4H - ATD 1 Conversion Result Register 4 High; 0x00000098 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR4H_BIT8:      equ    0                                         ; Bit 8
ATD1DR4H_BIT9:      equ    1                                         ; Bit 9
ATD1DR4H_BIT10:     equ    2                                         ; Bit 10
ATD1DR4H_BIT11:     equ    3                                         ; Bit 11
ATD1DR4H_BIT12:     equ    4                                         ; Bit 12
ATD1DR4H_BIT13:     equ    5                                         ; Bit 13
ATD1DR4H_BIT14:     equ    6                                         ; Bit 14
ATD1DR4H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR4H_BIT8:     equ    %00000001
mATD1DR4H_BIT9:     equ    %00000010
mATD1DR4H_BIT10:    equ    %00000100
mATD1DR4H_BIT11:    equ    %00001000
mATD1DR4H_BIT12:    equ    %00010000
mATD1DR4H_BIT13:    equ    %00100000
mATD1DR4H_BIT14:    equ    %01000000
mATD1DR4H_BIT15:    equ    %10000000


;*** ATD1DR4L - ATD 1 Conversion Result Register 4 Low; 0x00000099 ***
ATD1DR4L:           equ    $00000099                                ;*** ATD1DR4L - ATD 1 Conversion Result Register 4 Low; 0x00000099 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR4L_BIT6:      equ    6                                         ; Bit 6
ATD1DR4L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR4L_BIT6:     equ    %01000000
mATD1DR4L_BIT7:     equ    %10000000


;*** ATD1DR5 - ATD 1 Conversion Result Register 5; 0x0000009A ***
ATD1DR5:            equ    $0000009A                                ;*** ATD1DR5 - ATD 1 Conversion Result Register 5; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR5_BIT6:       equ    6                                         ; Bit 6
ATD1DR5_BIT7:       equ    7                                         ; Bit 7
ATD1DR5_BIT8:       equ    8                                         ; Bit 8
ATD1DR5_BIT9:       equ    9                                         ; Bit 9
ATD1DR5_BIT10:      equ    10                                        ; Bit 10
ATD1DR5_BIT11:      equ    11                                        ; Bit 11
ATD1DR5_BIT12:      equ    12                                        ; Bit 12
ATD1DR5_BIT13:      equ    13                                        ; Bit 13
ATD1DR5_BIT14:      equ    14                                        ; Bit 14
ATD1DR5_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR5_BIT6:      equ    %01000000
mATD1DR5_BIT7:      equ    %10000000
mATD1DR5_BIT8:      equ    %100000000
mATD1DR5_BIT9:      equ    %1000000000
mATD1DR5_BIT10:     equ    %10000000000
mATD1DR5_BIT11:     equ    %100000000000
mATD1DR5_BIT12:     equ    %1000000000000
mATD1DR5_BIT13:     equ    %10000000000000
mATD1DR5_BIT14:     equ    %100000000000000
mATD1DR5_BIT15:     equ    %1000000000000000


;*** ATD1DR5H - ATD 1 Conversion Result Register 5 High; 0x0000009A ***
ATD1DR5H:           equ    $0000009A                                ;*** ATD1DR5H - ATD 1 Conversion Result Register 5 High; 0x0000009A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR5H_BIT8:      equ    0                                         ; Bit 8
ATD1DR5H_BIT9:      equ    1                                         ; Bit 9
ATD1DR5H_BIT10:     equ    2                                         ; Bit 10
ATD1DR5H_BIT11:     equ    3                                         ; Bit 11
ATD1DR5H_BIT12:     equ    4                                         ; Bit 12
ATD1DR5H_BIT13:     equ    5                                         ; Bit 13
ATD1DR5H_BIT14:     equ    6                                         ; Bit 14
ATD1DR5H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR5H_BIT8:     equ    %00000001
mATD1DR5H_BIT9:     equ    %00000010
mATD1DR5H_BIT10:    equ    %00000100
mATD1DR5H_BIT11:    equ    %00001000
mATD1DR5H_BIT12:    equ    %00010000
mATD1DR5H_BIT13:    equ    %00100000
mATD1DR5H_BIT14:    equ    %01000000
mATD1DR5H_BIT15:    equ    %10000000


;*** ATD1DR5L - ATD 1 Conversion Result Register 5 Low; 0x0000009B ***
ATD1DR5L:           equ    $0000009B                                ;*** ATD1DR5L - ATD 1 Conversion Result Register 5 Low; 0x0000009B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR5L_BIT6:      equ    6                                         ; Bit 6
ATD1DR5L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR5L_BIT6:     equ    %01000000
mATD1DR5L_BIT7:     equ    %10000000


;*** ATD1DR6 - ATD 1 Conversion Result Register 6; 0x0000009C ***
ATD1DR6:            equ    $0000009C                                ;*** ATD1DR6 - ATD 1 Conversion Result Register 6; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR6_BIT6:       equ    6                                         ; Bit 6
ATD1DR6_BIT7:       equ    7                                         ; Bit 7
ATD1DR6_BIT8:       equ    8                                         ; Bit 8
ATD1DR6_BIT9:       equ    9                                         ; Bit 9
ATD1DR6_BIT10:      equ    10                                        ; Bit 10
ATD1DR6_BIT11:      equ    11                                        ; Bit 11
ATD1DR6_BIT12:      equ    12                                        ; Bit 12
ATD1DR6_BIT13:      equ    13                                        ; Bit 13
ATD1DR6_BIT14:      equ    14                                        ; Bit 14
ATD1DR6_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR6_BIT6:      equ    %01000000
mATD1DR6_BIT7:      equ    %10000000
mATD1DR6_BIT8:      equ    %100000000
mATD1DR6_BIT9:      equ    %1000000000
mATD1DR6_BIT10:     equ    %10000000000
mATD1DR6_BIT11:     equ    %100000000000
mATD1DR6_BIT12:     equ    %1000000000000
mATD1DR6_BIT13:     equ    %10000000000000
mATD1DR6_BIT14:     equ    %100000000000000
mATD1DR6_BIT15:     equ    %1000000000000000


;*** ATD1DR6H - ATD 1 Conversion Result Register 6 High; 0x0000009C ***
ATD1DR6H:           equ    $0000009C                                ;*** ATD1DR6H - ATD 1 Conversion Result Register 6 High; 0x0000009C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR6H_BIT8:      equ    0                                         ; Bit 8
ATD1DR6H_BIT9:      equ    1                                         ; Bit 9
ATD1DR6H_BIT10:     equ    2                                         ; Bit 10
ATD1DR6H_BIT11:     equ    3                                         ; Bit 11
ATD1DR6H_BIT12:     equ    4                                         ; Bit 12
ATD1DR6H_BIT13:     equ    5                                         ; Bit 13
ATD1DR6H_BIT14:     equ    6                                         ; Bit 14
ATD1DR6H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR6H_BIT8:     equ    %00000001
mATD1DR6H_BIT9:     equ    %00000010
mATD1DR6H_BIT10:    equ    %00000100
mATD1DR6H_BIT11:    equ    %00001000
mATD1DR6H_BIT12:    equ    %00010000
mATD1DR6H_BIT13:    equ    %00100000
mATD1DR6H_BIT14:    equ    %01000000
mATD1DR6H_BIT15:    equ    %10000000


;*** ATD1DR6L - ATD 1 Conversion Result Register 6 Low; 0x0000009D ***
ATD1DR6L:           equ    $0000009D                                ;*** ATD1DR6L - ATD 1 Conversion Result Register 6 Low; 0x0000009D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR6L_BIT6:      equ    6                                         ; Bit 6
ATD1DR6L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR6L_BIT6:     equ    %01000000
mATD1DR6L_BIT7:     equ    %10000000


;*** ATD1DR7 - ATD 1 Conversion Result Register 7; 0x0000009E ***
ATD1DR7:            equ    $0000009E                                ;*** ATD1DR7 - ATD 1 Conversion Result Register 7; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR7_BIT6:       equ    6                                         ; Bit 6
ATD1DR7_BIT7:       equ    7                                         ; Bit 7
ATD1DR7_BIT8:       equ    8                                         ; Bit 8
ATD1DR7_BIT9:       equ    9                                         ; Bit 9
ATD1DR7_BIT10:      equ    10                                        ; Bit 10
ATD1DR7_BIT11:      equ    11                                        ; Bit 11
ATD1DR7_BIT12:      equ    12                                        ; Bit 12
ATD1DR7_BIT13:      equ    13                                        ; Bit 13
ATD1DR7_BIT14:      equ    14                                        ; Bit 14
ATD1DR7_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR7_BIT6:      equ    %01000000
mATD1DR7_BIT7:      equ    %10000000
mATD1DR7_BIT8:      equ    %100000000
mATD1DR7_BIT9:      equ    %1000000000
mATD1DR7_BIT10:     equ    %10000000000
mATD1DR7_BIT11:     equ    %100000000000
mATD1DR7_BIT12:     equ    %1000000000000
mATD1DR7_BIT13:     equ    %10000000000000
mATD1DR7_BIT14:     equ    %100000000000000
mATD1DR7_BIT15:     equ    %1000000000000000


;*** ATD1DR7H - ATD 1 Conversion Result Register 7 High; 0x0000009E ***
ATD1DR7H:           equ    $0000009E                                ;*** ATD1DR7H - ATD 1 Conversion Result Register 7 High; 0x0000009E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR7H_BIT8:      equ    0                                         ; Bit 8
ATD1DR7H_BIT9:      equ    1                                         ; Bit 9
ATD1DR7H_BIT10:     equ    2                                         ; Bit 10
ATD1DR7H_BIT11:     equ    3                                         ; Bit 11
ATD1DR7H_BIT12:     equ    4                                         ; Bit 12
ATD1DR7H_BIT13:     equ    5                                         ; Bit 13
ATD1DR7H_BIT14:     equ    6                                         ; Bit 14
ATD1DR7H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR7H_BIT8:     equ    %00000001
mATD1DR7H_BIT9:     equ    %00000010
mATD1DR7H_BIT10:    equ    %00000100
mATD1DR7H_BIT11:    equ    %00001000
mATD1DR7H_BIT12:    equ    %00010000
mATD1DR7H_BIT13:    equ    %00100000
mATD1DR7H_BIT14:    equ    %01000000
mATD1DR7H_BIT15:    equ    %10000000


;*** ATD1DR7L - ATD 1 Conversion Result Register 7 Low; 0x0000009F ***
ATD1DR7L:           equ    $0000009F                                ;*** ATD1DR7L - ATD 1 Conversion Result Register 7 Low; 0x0000009F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR7L_BIT6:      equ    6                                         ; Bit 6
ATD1DR7L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR7L_BIT6:     equ    %01000000
mATD1DR7L_BIT7:     equ    %10000000


;*** ATD1DR8 - ATD 1 Conversion Result Register 8; 0x000000A0 ***
ATD1DR8:            equ    $000000A0                                ;*** ATD1DR8 - ATD 1 Conversion Result Register 8; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR8_BIT6:       equ    6                                         ; Bit 6
ATD1DR8_BIT7:       equ    7                                         ; Bit 7
ATD1DR8_BIT8:       equ    8                                         ; Bit 8
ATD1DR8_BIT9:       equ    9                                         ; Bit 9
ATD1DR8_BIT10:      equ    10                                        ; Bit 10
ATD1DR8_BIT11:      equ    11                                        ; Bit 11
ATD1DR8_BIT12:      equ    12                                        ; Bit 12
ATD1DR8_BIT13:      equ    13                                        ; Bit 13
ATD1DR8_BIT14:      equ    14                                        ; Bit 14
ATD1DR8_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR8_BIT6:      equ    %01000000
mATD1DR8_BIT7:      equ    %10000000
mATD1DR8_BIT8:      equ    %100000000
mATD1DR8_BIT9:      equ    %1000000000
mATD1DR8_BIT10:     equ    %10000000000
mATD1DR8_BIT11:     equ    %100000000000
mATD1DR8_BIT12:     equ    %1000000000000
mATD1DR8_BIT13:     equ    %10000000000000
mATD1DR8_BIT14:     equ    %100000000000000
mATD1DR8_BIT15:     equ    %1000000000000000


;*** ATD1DR8H - ATD 1 Conversion Result Register 8 High; 0x000000A0 ***
ATD1DR8H:           equ    $000000A0                                ;*** ATD1DR8H - ATD 1 Conversion Result Register 8 High; 0x000000A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR8H_BIT8:      equ    0                                         ; Bit 8
ATD1DR8H_BIT9:      equ    1                                         ; Bit 9
ATD1DR8H_BIT10:     equ    2                                         ; Bit 10
ATD1DR8H_BIT11:     equ    3                                         ; Bit 11
ATD1DR8H_BIT12:     equ    4                                         ; Bit 12
ATD1DR8H_BIT13:     equ    5                                         ; Bit 13
ATD1DR8H_BIT14:     equ    6                                         ; Bit 14
ATD1DR8H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR8H_BIT8:     equ    %00000001
mATD1DR8H_BIT9:     equ    %00000010
mATD1DR8H_BIT10:    equ    %00000100
mATD1DR8H_BIT11:    equ    %00001000
mATD1DR8H_BIT12:    equ    %00010000
mATD1DR8H_BIT13:    equ    %00100000
mATD1DR8H_BIT14:    equ    %01000000
mATD1DR8H_BIT15:    equ    %10000000


;*** ATD1DR8L - ATD 1 Conversion Result Register 8 Low; 0x000000A1 ***
ATD1DR8L:           equ    $000000A1                                ;*** ATD1DR8L - ATD 1 Conversion Result Register 8 Low; 0x000000A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR8L_BIT6:      equ    6                                         ; Bit 6
ATD1DR8L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR8L_BIT6:     equ    %01000000
mATD1DR8L_BIT7:     equ    %10000000


;*** ATD1DR9 - ATD 1 Conversion Result Register 9; 0x000000A2 ***
ATD1DR9:            equ    $000000A2                                ;*** ATD1DR9 - ATD 1 Conversion Result Register 9; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR9_BIT6:       equ    6                                         ; Bit 6
ATD1DR9_BIT7:       equ    7                                         ; Bit 7
ATD1DR9_BIT8:       equ    8                                         ; Bit 8
ATD1DR9_BIT9:       equ    9                                         ; Bit 9
ATD1DR9_BIT10:      equ    10                                        ; Bit 10
ATD1DR9_BIT11:      equ    11                                        ; Bit 11
ATD1DR9_BIT12:      equ    12                                        ; Bit 12
ATD1DR9_BIT13:      equ    13                                        ; Bit 13
ATD1DR9_BIT14:      equ    14                                        ; Bit 14
ATD1DR9_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD1DR9_BIT6:      equ    %01000000
mATD1DR9_BIT7:      equ    %10000000
mATD1DR9_BIT8:      equ    %100000000
mATD1DR9_BIT9:      equ    %1000000000
mATD1DR9_BIT10:     equ    %10000000000
mATD1DR9_BIT11:     equ    %100000000000
mATD1DR9_BIT12:     equ    %1000000000000
mATD1DR9_BIT13:     equ    %10000000000000
mATD1DR9_BIT14:     equ    %100000000000000
mATD1DR9_BIT15:     equ    %1000000000000000


;*** ATD1DR9H - ATD 1 Conversion Result Register 9 High; 0x000000A2 ***
ATD1DR9H:           equ    $000000A2                                ;*** ATD1DR9H - ATD 1 Conversion Result Register 9 High; 0x000000A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR9H_BIT8:      equ    0                                         ; Bit 8
ATD1DR9H_BIT9:      equ    1                                         ; Bit 9
ATD1DR9H_BIT10:     equ    2                                         ; Bit 10
ATD1DR9H_BIT11:     equ    3                                         ; Bit 11
ATD1DR9H_BIT12:     equ    4                                         ; Bit 12
ATD1DR9H_BIT13:     equ    5                                         ; Bit 13
ATD1DR9H_BIT14:     equ    6                                         ; Bit 14
ATD1DR9H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD1DR9H_BIT8:     equ    %00000001
mATD1DR9H_BIT9:     equ    %00000010
mATD1DR9H_BIT10:    equ    %00000100
mATD1DR9H_BIT11:    equ    %00001000
mATD1DR9H_BIT12:    equ    %00010000
mATD1DR9H_BIT13:    equ    %00100000
mATD1DR9H_BIT14:    equ    %01000000
mATD1DR9H_BIT15:    equ    %10000000


;*** ATD1DR9L - ATD 1 Conversion Result Register 9 Low; 0x000000A3 ***
ATD1DR9L:           equ    $000000A3                                ;*** ATD1DR9L - ATD 1 Conversion Result Register 9 Low; 0x000000A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR9L_BIT6:      equ    6                                         ; Bit 6
ATD1DR9L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD1DR9L_BIT6:     equ    %01000000
mATD1DR9L_BIT7:     equ    %10000000


;*** ATD1DR10 - ATD 1 Conversion Result Register 10; 0x000000A4 ***
ATD1DR10:           equ    $000000A4                                ;*** ATD1DR10 - ATD 1 Conversion Result Register 10; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR10_BIT6:      equ    6                                         ; Bit 6
ATD1DR10_BIT7:      equ    7                                         ; Bit 7
ATD1DR10_BIT8:      equ    8                                         ; Bit 8
ATD1DR10_BIT9:      equ    9                                         ; Bit 9
ATD1DR10_BIT10:     equ    10                                        ; Bit 10
ATD1DR10_BIT11:     equ    11                                        ; Bit 11
ATD1DR10_BIT12:     equ    12                                        ; Bit 12
ATD1DR10_BIT13:     equ    13                                        ; Bit 13
ATD1DR10_BIT14:     equ    14                                        ; Bit 14
ATD1DR10_BIT15:     equ    15                                        ; Bit 15
; bit position masks
mATD1DR10_BIT6:     equ    %01000000
mATD1DR10_BIT7:     equ    %10000000
mATD1DR10_BIT8:     equ    %100000000
mATD1DR10_BIT9:     equ    %1000000000
mATD1DR10_BIT10:    equ    %10000000000
mATD1DR10_BIT11:    equ    %100000000000
mATD1DR10_BIT12:    equ    %1000000000000
mATD1DR10_BIT13:    equ    %10000000000000
mATD1DR10_BIT14:    equ    %100000000000000
mATD1DR10_BIT15:    equ    %1000000000000000


;*** ATD1DR10H - ATD 1 Conversion Result Register 10 High; 0x000000A4 ***
ATD1DR10H:          equ    $000000A4                                ;*** ATD1DR10H - ATD 1 Conversion Result Register 10 High; 0x000000A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR10H_BIT8:     equ    0                                         ; Bit 8
ATD1DR10H_BIT9:     equ    1                                         ; Bit 9
ATD1DR10H_BIT10:    equ    2                                         ; Bit 10
ATD1DR10H_BIT11:    equ    3                                         ; Bit 11
ATD1DR10H_BIT12:    equ    4                                         ; Bit 12
ATD1DR10H_BIT13:    equ    5                                         ; Bit 13
ATD1DR10H_BIT14:    equ    6                                         ; Bit 14
ATD1DR10H_BIT15:    equ    7                                         ; Bit 15
; bit position masks
mATD1DR10H_BIT8:    equ    %00000001
mATD1DR10H_BIT9:    equ    %00000010
mATD1DR10H_BIT10:   equ    %00000100
mATD1DR10H_BIT11:   equ    %00001000
mATD1DR10H_BIT12:   equ    %00010000
mATD1DR10H_BIT13:   equ    %00100000
mATD1DR10H_BIT14:   equ    %01000000
mATD1DR10H_BIT15:   equ    %10000000


;*** ATD1DR10L - ATD 1 Conversion Result Register 10 Low; 0x000000A5 ***
ATD1DR10L:          equ    $000000A5                                ;*** ATD1DR10L - ATD 1 Conversion Result Register 10 Low; 0x000000A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR10L_BIT6:     equ    6                                         ; Bit 6
ATD1DR10L_BIT7:     equ    7                                         ; Bit 7
; bit position masks
mATD1DR10L_BIT6:    equ    %01000000
mATD1DR10L_BIT7:    equ    %10000000


;*** ATD1DR11 - ATD 1 Conversion Result Register 11; 0x000000A6 ***
ATD1DR11:           equ    $000000A6                                ;*** ATD1DR11 - ATD 1 Conversion Result Register 11; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR11_BIT6:      equ    6                                         ; Bit 6
ATD1DR11_BIT7:      equ    7                                         ; Bit 7
ATD1DR11_BIT8:      equ    8                                         ; Bit 8
ATD1DR11_BIT9:      equ    9                                         ; Bit 9
ATD1DR11_BIT10:     equ    10                                        ; Bit 10
ATD1DR11_BIT11:     equ    11                                        ; Bit 11
ATD1DR11_BIT12:     equ    12                                        ; Bit 12
ATD1DR11_BIT13:     equ    13                                        ; Bit 13
ATD1DR11_BIT14:     equ    14                                        ; Bit 14
ATD1DR11_BIT15:     equ    15                                        ; Bit 15
; bit position masks
mATD1DR11_BIT6:     equ    %01000000
mATD1DR11_BIT7:     equ    %10000000
mATD1DR11_BIT8:     equ    %100000000
mATD1DR11_BIT9:     equ    %1000000000
mATD1DR11_BIT10:    equ    %10000000000
mATD1DR11_BIT11:    equ    %100000000000
mATD1DR11_BIT12:    equ    %1000000000000
mATD1DR11_BIT13:    equ    %10000000000000
mATD1DR11_BIT14:    equ    %100000000000000
mATD1DR11_BIT15:    equ    %1000000000000000


;*** ATD1DR11H - ATD 1 Conversion Result Register 11 High; 0x000000A6 ***
ATD1DR11H:          equ    $000000A6                                ;*** ATD1DR11H - ATD 1 Conversion Result Register 11 High; 0x000000A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR11H_BIT8:     equ    0                                         ; Bit 8
ATD1DR11H_BIT9:     equ    1                                         ; Bit 9
ATD1DR11H_BIT10:    equ    2                                         ; Bit 10
ATD1DR11H_BIT11:    equ    3                                         ; Bit 11
ATD1DR11H_BIT12:    equ    4                                         ; Bit 12
ATD1DR11H_BIT13:    equ    5                                         ; Bit 13
ATD1DR11H_BIT14:    equ    6                                         ; Bit 14
ATD1DR11H_BIT15:    equ    7                                         ; Bit 15
; bit position masks
mATD1DR11H_BIT8:    equ    %00000001
mATD1DR11H_BIT9:    equ    %00000010
mATD1DR11H_BIT10:   equ    %00000100
mATD1DR11H_BIT11:   equ    %00001000
mATD1DR11H_BIT12:   equ    %00010000
mATD1DR11H_BIT13:   equ    %00100000
mATD1DR11H_BIT14:   equ    %01000000
mATD1DR11H_BIT15:   equ    %10000000


;*** ATD1DR11L - ATD 1 Conversion Result Register 11 Low; 0x000000A7 ***
ATD1DR11L:          equ    $000000A7                                ;*** ATD1DR11L - ATD 1 Conversion Result Register 11 Low; 0x000000A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR11L_BIT6:     equ    6                                         ; Bit 6
ATD1DR11L_BIT7:     equ    7                                         ; Bit 7
; bit position masks
mATD1DR11L_BIT6:    equ    %01000000
mATD1DR11L_BIT7:    equ    %10000000


;*** ATD1DR12 - ATD 1 Conversion Result Register 12; 0x000000A8 ***
ATD1DR12:           equ    $000000A8                                ;*** ATD1DR12 - ATD 1 Conversion Result Register 12; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR12_BIT6:      equ    6                                         ; Bit 6
ATD1DR12_BIT7:      equ    7                                         ; Bit 7
ATD1DR12_BIT8:      equ    8                                         ; Bit 8
ATD1DR12_BIT9:      equ    9                                         ; Bit 9
ATD1DR12_BIT10:     equ    10                                        ; Bit 10
ATD1DR12_BIT11:     equ    11                                        ; Bit 11
ATD1DR12_BIT12:     equ    12                                        ; Bit 12
ATD1DR12_BIT13:     equ    13                                        ; Bit 13
ATD1DR12_BIT14:     equ    14                                        ; Bit 14
ATD1DR12_BIT15:     equ    15                                        ; Bit 15
; bit position masks
mATD1DR12_BIT6:     equ    %01000000
mATD1DR12_BIT7:     equ    %10000000
mATD1DR12_BIT8:     equ    %100000000
mATD1DR12_BIT9:     equ    %1000000000
mATD1DR12_BIT10:    equ    %10000000000
mATD1DR12_BIT11:    equ    %100000000000
mATD1DR12_BIT12:    equ    %1000000000000
mATD1DR12_BIT13:    equ    %10000000000000
mATD1DR12_BIT14:    equ    %100000000000000
mATD1DR12_BIT15:    equ    %1000000000000000


;*** ATD1DR12H - ATD 1 Conversion Result Register 12 High; 0x000000A8 ***
ATD1DR12H:          equ    $000000A8                                ;*** ATD1DR12H - ATD 1 Conversion Result Register 12 High; 0x000000A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR12H_BIT8:     equ    0                                         ; Bit 8
ATD1DR12H_BIT9:     equ    1                                         ; Bit 9
ATD1DR12H_BIT10:    equ    2                                         ; Bit 10
ATD1DR12H_BIT11:    equ    3                                         ; Bit 11
ATD1DR12H_BIT12:    equ    4                                         ; Bit 12
ATD1DR12H_BIT13:    equ    5                                         ; Bit 13
ATD1DR12H_BIT14:    equ    6                                         ; Bit 14
ATD1DR12H_BIT15:    equ    7                                         ; Bit 15
; bit position masks
mATD1DR12H_BIT8:    equ    %00000001
mATD1DR12H_BIT9:    equ    %00000010
mATD1DR12H_BIT10:   equ    %00000100
mATD1DR12H_BIT11:   equ    %00001000
mATD1DR12H_BIT12:   equ    %00010000
mATD1DR12H_BIT13:   equ    %00100000
mATD1DR12H_BIT14:   equ    %01000000
mATD1DR12H_BIT15:   equ    %10000000


;*** ATD1DR12L - ATD 1 Conversion Result Register 12 Low; 0x000000A9 ***
ATD1DR12L:          equ    $000000A9                                ;*** ATD1DR12L - ATD 1 Conversion Result Register 12 Low; 0x000000A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR12L_BIT6:     equ    6                                         ; Bit 6
ATD1DR12L_BIT7:     equ    7                                         ; Bit 7
; bit position masks
mATD1DR12L_BIT6:    equ    %01000000
mATD1DR12L_BIT7:    equ    %10000000


;*** ATD1DR13 - ATD 1 Conversion Result Register 13; 0x000000AA ***
ATD1DR13:           equ    $000000AA                                ;*** ATD1DR13 - ATD 1 Conversion Result Register 13; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR13_BIT6:      equ    6                                         ; Bit 6
ATD1DR13_BIT7:      equ    7                                         ; Bit 7
ATD1DR13_BIT8:      equ    8                                         ; Bit 8
ATD1DR13_BIT9:      equ    9                                         ; Bit 9
ATD1DR13_BIT10:     equ    10                                        ; Bit 10
ATD1DR13_BIT11:     equ    11                                        ; Bit 11
ATD1DR13_BIT12:     equ    12                                        ; Bit 12
ATD1DR13_BIT13:     equ    13                                        ; Bit 13
ATD1DR13_BIT14:     equ    14                                        ; Bit 14
ATD1DR13_BIT15:     equ    15                                        ; Bit 15
; bit position masks
mATD1DR13_BIT6:     equ    %01000000
mATD1DR13_BIT7:     equ    %10000000
mATD1DR13_BIT8:     equ    %100000000
mATD1DR13_BIT9:     equ    %1000000000
mATD1DR13_BIT10:    equ    %10000000000
mATD1DR13_BIT11:    equ    %100000000000
mATD1DR13_BIT12:    equ    %1000000000000
mATD1DR13_BIT13:    equ    %10000000000000
mATD1DR13_BIT14:    equ    %100000000000000
mATD1DR13_BIT15:    equ    %1000000000000000


;*** ATD1DR13H - ATD 1 Conversion Result Register 13 High; 0x000000AA ***
ATD1DR13H:          equ    $000000AA                                ;*** ATD1DR13H - ATD 1 Conversion Result Register 13 High; 0x000000AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR13H_BIT8:     equ    0                                         ; Bit 8
ATD1DR13H_BIT9:     equ    1                                         ; Bit 9
ATD1DR13H_BIT10:    equ    2                                         ; Bit 10
ATD1DR13H_BIT11:    equ    3                                         ; Bit 11
ATD1DR13H_BIT12:    equ    4                                         ; Bit 12
ATD1DR13H_BIT13:    equ    5                                         ; Bit 13
ATD1DR13H_BIT14:    equ    6                                         ; Bit 14
ATD1DR13H_BIT15:    equ    7                                         ; Bit 15
; bit position masks
mATD1DR13H_BIT8:    equ    %00000001
mATD1DR13H_BIT9:    equ    %00000010
mATD1DR13H_BIT10:   equ    %00000100
mATD1DR13H_BIT11:   equ    %00001000
mATD1DR13H_BIT12:   equ    %00010000
mATD1DR13H_BIT13:   equ    %00100000
mATD1DR13H_BIT14:   equ    %01000000
mATD1DR13H_BIT15:   equ    %10000000


;*** ATD1DR13L - ATD 1 Conversion Result Register 13 Low; 0x000000AB ***
ATD1DR13L:          equ    $000000AB                                ;*** ATD1DR13L - ATD 1 Conversion Result Register 13 Low; 0x000000AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR13L_BIT6:     equ    6                                         ; Bit 6
ATD1DR13L_BIT7:     equ    7                                         ; Bit 7
; bit position masks
mATD1DR13L_BIT6:    equ    %01000000
mATD1DR13L_BIT7:    equ    %10000000


;*** ATD1DR14 - ATD 1 Conversion Result Register 14; 0x000000AC ***
ATD1DR14:           equ    $000000AC                                ;*** ATD1DR14 - ATD 1 Conversion Result Register 14; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR14_BIT6:      equ    6                                         ; Bit 6
ATD1DR14_BIT7:      equ    7                                         ; Bit 7
ATD1DR14_BIT8:      equ    8                                         ; Bit 8
ATD1DR14_BIT9:      equ    9                                         ; Bit 9
ATD1DR14_BIT10:     equ    10                                        ; Bit 10
ATD1DR14_BIT11:     equ    11                                        ; Bit 11
ATD1DR14_BIT12:     equ    12                                        ; Bit 12
ATD1DR14_BIT13:     equ    13                                        ; Bit 13
ATD1DR14_BIT14:     equ    14                                        ; Bit 14
ATD1DR14_BIT15:     equ    15                                        ; Bit 15
; bit position masks
mATD1DR14_BIT6:     equ    %01000000
mATD1DR14_BIT7:     equ    %10000000
mATD1DR14_BIT8:     equ    %100000000
mATD1DR14_BIT9:     equ    %1000000000
mATD1DR14_BIT10:    equ    %10000000000
mATD1DR14_BIT11:    equ    %100000000000
mATD1DR14_BIT12:    equ    %1000000000000
mATD1DR14_BIT13:    equ    %10000000000000
mATD1DR14_BIT14:    equ    %100000000000000
mATD1DR14_BIT15:    equ    %1000000000000000


;*** ATD1DR14H - ATD 1 Conversion Result Register 14 High; 0x000000AC ***
ATD1DR14H:          equ    $000000AC                                ;*** ATD1DR14H - ATD 1 Conversion Result Register 14 High; 0x000000AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR14H_BIT8:     equ    0                                         ; Bit 8
ATD1DR14H_BIT9:     equ    1                                         ; Bit 9
ATD1DR14H_BIT10:    equ    2                                         ; Bit 10
ATD1DR14H_BIT11:    equ    3                                         ; Bit 11
ATD1DR14H_BIT12:    equ    4                                         ; Bit 12
ATD1DR14H_BIT13:    equ    5                                         ; Bit 13
ATD1DR14H_BIT14:    equ    6                                         ; Bit 14
ATD1DR14H_BIT15:    equ    7                                         ; Bit 15
; bit position masks
mATD1DR14H_BIT8:    equ    %00000001
mATD1DR14H_BIT9:    equ    %00000010
mATD1DR14H_BIT10:   equ    %00000100
mATD1DR14H_BIT11:   equ    %00001000
mATD1DR14H_BIT12:   equ    %00010000
mATD1DR14H_BIT13:   equ    %00100000
mATD1DR14H_BIT14:   equ    %01000000
mATD1DR14H_BIT15:   equ    %10000000


;*** ATD1DR14L - ATD 1 Conversion Result Register 14 Low; 0x000000AD ***
ATD1DR14L:          equ    $000000AD                                ;*** ATD1DR14L - ATD 1 Conversion Result Register 14 Low; 0x000000AD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR14L_BIT6:     equ    6                                         ; Bit 6
ATD1DR14L_BIT7:     equ    7                                         ; Bit 7
; bit position masks
mATD1DR14L_BIT6:    equ    %01000000
mATD1DR14L_BIT7:    equ    %10000000


;*** ATD1DR15 - ATD 1 Conversion Result Register 15; 0x000000AE ***
ATD1DR15:           equ    $000000AE                                ;*** ATD1DR15 - ATD 1 Conversion Result Register 15; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR15_BIT6:      equ    6                                         ; Bit 6
ATD1DR15_BIT7:      equ    7                                         ; Bit 7
ATD1DR15_BIT8:      equ    8                                         ; Bit 8
ATD1DR15_BIT9:      equ    9                                         ; Bit 9
ATD1DR15_BIT10:     equ    10                                        ; Bit 10
ATD1DR15_BIT11:     equ    11                                        ; Bit 11
ATD1DR15_BIT12:     equ    12                                        ; Bit 12
ATD1DR15_BIT13:     equ    13                                        ; Bit 13
ATD1DR15_BIT14:     equ    14                                        ; Bit 14
ATD1DR15_BIT15:     equ    15                                        ; Bit 15
; bit position masks
mATD1DR15_BIT6:     equ    %01000000
mATD1DR15_BIT7:     equ    %10000000
mATD1DR15_BIT8:     equ    %100000000
mATD1DR15_BIT9:     equ    %1000000000
mATD1DR15_BIT10:    equ    %10000000000
mATD1DR15_BIT11:    equ    %100000000000
mATD1DR15_BIT12:    equ    %1000000000000
mATD1DR15_BIT13:    equ    %10000000000000
mATD1DR15_BIT14:    equ    %100000000000000
mATD1DR15_BIT15:    equ    %1000000000000000


;*** ATD1DR15H - ATD 1 Conversion Result Register 15 High; 0x000000AE ***
ATD1DR15H:          equ    $000000AE                                ;*** ATD1DR15H - ATD 1 Conversion Result Register 15 High; 0x000000AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR15H_BIT8:     equ    0                                         ; Bit 8
ATD1DR15H_BIT9:     equ    1                                         ; Bit 9
ATD1DR15H_BIT10:    equ    2                                         ; Bit 10
ATD1DR15H_BIT11:    equ    3                                         ; Bit 11
ATD1DR15H_BIT12:    equ    4                                         ; Bit 12
ATD1DR15H_BIT13:    equ    5                                         ; Bit 13
ATD1DR15H_BIT14:    equ    6                                         ; Bit 14
ATD1DR15H_BIT15:    equ    7                                         ; Bit 15
; bit position masks
mATD1DR15H_BIT8:    equ    %00000001
mATD1DR15H_BIT9:    equ    %00000010
mATD1DR15H_BIT10:   equ    %00000100
mATD1DR15H_BIT11:   equ    %00001000
mATD1DR15H_BIT12:   equ    %00010000
mATD1DR15H_BIT13:   equ    %00100000
mATD1DR15H_BIT14:   equ    %01000000
mATD1DR15H_BIT15:   equ    %10000000


;*** ATD1DR15L - ATD 1 Conversion Result Register 15 Low; 0x000000AF ***
ATD1DR15L:          equ    $000000AF                                ;*** ATD1DR15L - ATD 1 Conversion Result Register 15 Low; 0x000000AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD1DR15L_BIT6:     equ    6                                         ; Bit 6
ATD1DR15L_BIT7:     equ    7                                         ; Bit 7
; bit position masks
mATD1DR15L_BIT6:    equ    %01000000
mATD1DR15L_BIT7:    equ    %10000000


;*** SCI2BD - SCI 2 Baud Rate Register; 0x000000B8 ***
SCI2BD:             equ    $000000B8                                ;*** SCI2BD - SCI 2 Baud Rate Register; 0x000000B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI2BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI2BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI2BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI2BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI2BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI2BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI2BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI2BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI2BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI2BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI2BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI2BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI2BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI2BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI2BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI2BD_SBR0:       equ    %00000001
mSCI2BD_SBR1:       equ    %00000010
mSCI2BD_SBR2:       equ    %00000100
mSCI2BD_SBR3:       equ    %00001000
mSCI2BD_SBR4:       equ    %00010000
mSCI2BD_SBR5:       equ    %00100000
mSCI2BD_SBR6:       equ    %01000000
mSCI2BD_SBR7:       equ    %10000000
mSCI2BD_SBR8:       equ    %100000000
mSCI2BD_SBR9:       equ    %1000000000
mSCI2BD_SBR10:      equ    %10000000000
mSCI2BD_SBR11:      equ    %100000000000
mSCI2BD_SBR12:      equ    %1000000000000
mSCI2BD_TNP0:       equ    %10000000000000
mSCI2BD_TNP1:       equ    %100000000000000
mSCI2BD_IREN:       equ    %1000000000000000


;*** SCI2ASR1 - SCI 2 Alternative Status Register 1; 0x000000B8 ***
SCI2ASR1:           equ    $000000B8                                ;*** SCI2ASR1 - SCI 2 Alternative Status Register 1; 0x000000B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI2ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI2ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI2ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI2ASR1_BKDIF:    equ    %00000001
mSCI2ASR1_BERRIF:   equ    %00000010
mSCI2ASR1_BERRV:    equ    %00000100
mSCI2ASR1_RXEDGIF:  equ    %10000000


;*** SCI2BDH - SCI 2 Baud Rate Register High; 0x000000B8 ***
SCI2BDH:            equ    $000000B8                                ;*** SCI2BDH - SCI 2 Baud Rate Register High; 0x000000B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI2BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI2BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI2BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI2BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI2BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI2BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI2BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI2BDH_SBR8:      equ    %00000001
mSCI2BDH_SBR9:      equ    %00000010
mSCI2BDH_SBR10:     equ    %00000100
mSCI2BDH_SBR11:     equ    %00001000
mSCI2BDH_SBR12:     equ    %00010000
mSCI2BDH_TNP0:      equ    %00100000
mSCI2BDH_TNP1:      equ    %01000000
mSCI2BDH_IREN:      equ    %10000000


;*** SCI2ACR1 - SCI 2 Alternative Control Register 1; 0x000000B9 ***
SCI2ACR1:           equ    $000000B9                                ;*** SCI2ACR1 - SCI 2 Alternative Control Register 1; 0x000000B9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI2ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI2ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI2ACR1_BKDIE:    equ    %00000001
mSCI2ACR1_BERRIE:   equ    %00000010
mSCI2ACR1_RXEDGIE:  equ    %10000000


;*** SCI2BDL - SCI 2 Baud Rate Register Low; 0x000000B9 ***
SCI2BDL:            equ    $000000B9                                ;*** SCI2BDL - SCI 2 Baud Rate Register Low; 0x000000B9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI2BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI2BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI2BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI2BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI2BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI2BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI2BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI2BDL_SBR0:      equ    %00000001
mSCI2BDL_SBR1:      equ    %00000010
mSCI2BDL_SBR2:      equ    %00000100
mSCI2BDL_SBR3:      equ    %00001000
mSCI2BDL_SBR4:      equ    %00010000
mSCI2BDL_SBR5:      equ    %00100000
mSCI2BDL_SBR6:      equ    %01000000
mSCI2BDL_SBR7:      equ    %10000000


;*** SCI2ACR2 - SCI 2 Alternative Control Register 2; 0x000000BA ***
SCI2ACR2:           equ    $000000BA                                ;*** SCI2ACR2 - SCI 2 Alternative Control Register 2; 0x000000BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI2ACR2_BERRM0:    equ    1                                         ; Bit Error Mode Bit 0
SCI2ACR2_BERRM1:    equ    2                                         ; Bit Error Mode Bit 1
; bit position masks
mSCI2ACR2_BKDFE:    equ    %00000001
mSCI2ACR2_BERRM0:   equ    %00000010
mSCI2ACR2_BERRM1:   equ    %00000100


;*** SCI2CR1 - SCI 2 Control Register 1; 0x000000BA ***
SCI2CR1:            equ    $000000BA                                ;*** SCI2CR1 - SCI 2 Control Register 1; 0x000000BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2CR1_PT:         equ    0                                         ; Parity Type Bit
SCI2CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI2CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI2CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI2CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI2CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI2CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI2CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI2CR1_PT:        equ    %00000001
mSCI2CR1_PE:        equ    %00000010
mSCI2CR1_ILT:       equ    %00000100
mSCI2CR1_WAKE:      equ    %00001000
mSCI2CR1_M:         equ    %00010000
mSCI2CR1_RSRC:      equ    %00100000
mSCI2CR1_SCISWAI:   equ    %01000000
mSCI2CR1_LOOPS:     equ    %10000000


;*** SCI2CR2 - SCI 2 Control Register 2; 0x000000BB ***
SCI2CR2:            equ    $000000BB                                ;*** SCI2CR2 - SCI 2 Control Register 2; 0x000000BB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2CR2_SBK:        equ    0                                         ; Send Break Bit
SCI2CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI2CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI2CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI2CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI2CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI2CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI2CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI2CR2_SBK:       equ    %00000001
mSCI2CR2_RWU:       equ    %00000010
mSCI2CR2_RE:        equ    %00000100
mSCI2CR2_TE:        equ    %00001000
mSCI2CR2_ILIE:      equ    %00010000
mSCI2CR2_RIE:       equ    %00100000
mSCI2CR2_TCIE:      equ    %01000000
mSCI2CR2_TIE:       equ    %10000000


;*** SCI2SR1 - SCI 2 Status Register 1; 0x000000BC ***
SCI2SR1:            equ    $000000BC                                ;*** SCI2SR1 - SCI 2 Status Register 1; 0x000000BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2SR1_PF:         equ    0                                         ; Parity Error Flag
SCI2SR1_FE:         equ    1                                         ; Framing Error Flag
SCI2SR1_NF:         equ    2                                         ; Noise Flag
SCI2SR1_OR:         equ    3                                         ; Overrun Flag
SCI2SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI2SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI2SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI2SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI2SR1_PF:        equ    %00000001
mSCI2SR1_FE:        equ    %00000010
mSCI2SR1_NF:        equ    %00000100
mSCI2SR1_OR:        equ    %00001000
mSCI2SR1_IDLE:      equ    %00010000
mSCI2SR1_RDRF:      equ    %00100000
mSCI2SR1_TC:        equ    %01000000
mSCI2SR1_TDRE:      equ    %10000000


;*** SCI2SR2 - SCI 2 Status Register 2; 0x000000BD ***
SCI2SR2:            equ    $000000BD                                ;*** SCI2SR2 - SCI 2 Status Register 2; 0x000000BD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI2SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI2SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI2SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI2SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI2SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI2SR2_RAF:       equ    %00000001
mSCI2SR2_TXDIR:     equ    %00000010
mSCI2SR2_BRK13:     equ    %00000100
mSCI2SR2_RXPOL:     equ    %00001000
mSCI2SR2_TXPOL:     equ    %00010000
mSCI2SR2_AMAP:      equ    %10000000


;*** SCI2DRH - SCI 2 Data Register High; 0x000000BE ***
SCI2DRH:            equ    $000000BE                                ;*** SCI2DRH - SCI 2 Data Register High; 0x000000BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI2DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI2DRH_T8:        equ    %01000000
mSCI2DRH_R8:        equ    %10000000


;*** SCI2DRL - SCI 2 Data Register Low; 0x000000BF ***
SCI2DRL:            equ    $000000BF                                ;*** SCI2DRL - SCI 2 Data Register Low; 0x000000BF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI2DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI2DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI2DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI2DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI2DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI2DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI2DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI2DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI2DRL_R0_T0:     equ    %00000001
mSCI2DRL_R1_T1:     equ    %00000010
mSCI2DRL_R2_T2:     equ    %00000100
mSCI2DRL_R3_T3:     equ    %00001000
mSCI2DRL_R4_T4:     equ    %00010000
mSCI2DRL_R5_T5:     equ    %00100000
mSCI2DRL_R6_T6:     equ    %01000000
mSCI2DRL_R7_T7:     equ    %10000000


;*** SCI3BD - SCI 3 Baud Rate Register; 0x000000C0 ***
SCI3BD:             equ    $000000C0                                ;*** SCI3BD - SCI 3 Baud Rate Register; 0x000000C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI3BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI3BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI3BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI3BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI3BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI3BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI3BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI3BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI3BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI3BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI3BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI3BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI3BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI3BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI3BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI3BD_SBR0:       equ    %00000001
mSCI3BD_SBR1:       equ    %00000010
mSCI3BD_SBR2:       equ    %00000100
mSCI3BD_SBR3:       equ    %00001000
mSCI3BD_SBR4:       equ    %00010000
mSCI3BD_SBR5:       equ    %00100000
mSCI3BD_SBR6:       equ    %01000000
mSCI3BD_SBR7:       equ    %10000000
mSCI3BD_SBR8:       equ    %100000000
mSCI3BD_SBR9:       equ    %1000000000
mSCI3BD_SBR10:      equ    %10000000000
mSCI3BD_SBR11:      equ    %100000000000
mSCI3BD_SBR12:      equ    %1000000000000
mSCI3BD_TNP0:       equ    %10000000000000
mSCI3BD_TNP1:       equ    %100000000000000
mSCI3BD_IREN:       equ    %1000000000000000


;*** SCI3ASR1 - SCI 3 Alternative Status Register 1; 0x000000C0 ***
SCI3ASR1:           equ    $000000C0                                ;*** SCI3ASR1 - SCI 3 Alternative Status Register 1; 0x000000C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI3ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI3ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI3ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI3ASR1_BKDIF:    equ    %00000001
mSCI3ASR1_BERRIF:   equ    %00000010
mSCI3ASR1_BERRV:    equ    %00000100
mSCI3ASR1_RXEDGIF:  equ    %10000000


;*** SCI3BDH - SCI 3 Baud Rate Register High; 0x000000C0 ***
SCI3BDH:            equ    $000000C0                                ;*** SCI3BDH - SCI 3 Baud Rate Register High; 0x000000C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI3BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI3BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI3BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI3BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI3BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI3BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI3BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI3BDH_SBR8:      equ    %00000001
mSCI3BDH_SBR9:      equ    %00000010
mSCI3BDH_SBR10:     equ    %00000100
mSCI3BDH_SBR11:     equ    %00001000
mSCI3BDH_SBR12:     equ    %00010000
mSCI3BDH_TNP0:      equ    %00100000
mSCI3BDH_TNP1:      equ    %01000000
mSCI3BDH_IREN:      equ    %10000000


;*** SCI3ACR1 - SCI 3 Alternative Control Register 1; 0x000000C1 ***
SCI3ACR1:           equ    $000000C1                                ;*** SCI3ACR1 - SCI 3 Alternative Control Register 1; 0x000000C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI3ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI3ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI3ACR1_BKDIE:    equ    %00000001
mSCI3ACR1_BERRIE:   equ    %00000010
mSCI3ACR1_RXEDGIE:  equ    %10000000


;*** SCI3BDL - SCI 3 Baud Rate Register Low; 0x000000C1 ***
SCI3BDL:            equ    $000000C1                                ;*** SCI3BDL - SCI 3 Baud Rate Register Low; 0x000000C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI3BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI3BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI3BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI3BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI3BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI3BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI3BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI3BDL_SBR0:      equ    %00000001
mSCI3BDL_SBR1:      equ    %00000010
mSCI3BDL_SBR2:      equ    %00000100
mSCI3BDL_SBR3:      equ    %00001000
mSCI3BDL_SBR4:      equ    %00010000
mSCI3BDL_SBR5:      equ    %00100000
mSCI3BDL_SBR6:      equ    %01000000
mSCI3BDL_SBR7:      equ    %10000000


;*** SCI3ACR2 - SCI 3 Alternative Control Register 2; 0x000000C2 ***
SCI3ACR2:           equ    $000000C2                                ;*** SCI3ACR2 - SCI 3 Alternative Control Register 2; 0x000000C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI3ACR2_BERRM0:    equ    1                                         ; Bit Error Mode Bit 0
SCI3ACR2_BERRM1:    equ    2                                         ; Bit Error Mode Bit 1
; bit position masks
mSCI3ACR2_BKDFE:    equ    %00000001
mSCI3ACR2_BERRM0:   equ    %00000010
mSCI3ACR2_BERRM1:   equ    %00000100


;*** SCI3CR1 - SCI 3 Control Register 1; 0x000000C2 ***
SCI3CR1:            equ    $000000C2                                ;*** SCI3CR1 - SCI 3 Control Register 1; 0x000000C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3CR1_PT:         equ    0                                         ; Parity Type Bit
SCI3CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI3CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI3CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI3CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI3CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI3CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI3CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI3CR1_PT:        equ    %00000001
mSCI3CR1_PE:        equ    %00000010
mSCI3CR1_ILT:       equ    %00000100
mSCI3CR1_WAKE:      equ    %00001000
mSCI3CR1_M:         equ    %00010000
mSCI3CR1_RSRC:      equ    %00100000
mSCI3CR1_SCISWAI:   equ    %01000000
mSCI3CR1_LOOPS:     equ    %10000000


;*** SCI3CR2 - SCI 3 Control Register 2; 0x000000C3 ***
SCI3CR2:            equ    $000000C3                                ;*** SCI3CR2 - SCI 3 Control Register 2; 0x000000C3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3CR2_SBK:        equ    0                                         ; Send Break Bit
SCI3CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI3CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI3CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI3CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI3CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI3CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI3CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI3CR2_SBK:       equ    %00000001
mSCI3CR2_RWU:       equ    %00000010
mSCI3CR2_RE:        equ    %00000100
mSCI3CR2_TE:        equ    %00001000
mSCI3CR2_ILIE:      equ    %00010000
mSCI3CR2_RIE:       equ    %00100000
mSCI3CR2_TCIE:      equ    %01000000
mSCI3CR2_TIE:       equ    %10000000


;*** SCI3SR1 - SCI 3 Status Register 1; 0x000000C4 ***
SCI3SR1:            equ    $000000C4                                ;*** SCI3SR1 - SCI 3 Status Register 1; 0x000000C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3SR1_PF:         equ    0                                         ; Parity Error Flag
SCI3SR1_FE:         equ    1                                         ; Framing Error Flag
SCI3SR1_NF:         equ    2                                         ; Noise Flag
SCI3SR1_OR:         equ    3                                         ; Overrun Flag
SCI3SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI3SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI3SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI3SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI3SR1_PF:        equ    %00000001
mSCI3SR1_FE:        equ    %00000010
mSCI3SR1_NF:        equ    %00000100
mSCI3SR1_OR:        equ    %00001000
mSCI3SR1_IDLE:      equ    %00010000
mSCI3SR1_RDRF:      equ    %00100000
mSCI3SR1_TC:        equ    %01000000
mSCI3SR1_TDRE:      equ    %10000000


;*** SCI3SR2 - SCI 3 Status Register 2; 0x000000C5 ***
SCI3SR2:            equ    $000000C5                                ;*** SCI3SR2 - SCI 3 Status Register 2; 0x000000C5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI3SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI3SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI3SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI3SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI3SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI3SR2_RAF:       equ    %00000001
mSCI3SR2_TXDIR:     equ    %00000010
mSCI3SR2_BRK13:     equ    %00000100
mSCI3SR2_RXPOL:     equ    %00001000
mSCI3SR2_TXPOL:     equ    %00010000
mSCI3SR2_AMAP:      equ    %10000000


;*** SCI3DRH - SCI 3 Data Register High; 0x000000C6 ***
SCI3DRH:            equ    $000000C6                                ;*** SCI3DRH - SCI 3 Data Register High; 0x000000C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI3DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI3DRH_T8:        equ    %01000000
mSCI3DRH_R8:        equ    %10000000


;*** SCI3DRL - SCI 3 Data Register Low; 0x000000C7 ***
SCI3DRL:            equ    $000000C7                                ;*** SCI3DRL - SCI 3 Data Register Low; 0x000000C7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI3DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI3DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI3DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI3DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI3DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI3DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI3DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI3DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI3DRL_R0_T0:     equ    %00000001
mSCI3DRL_R1_T1:     equ    %00000010
mSCI3DRL_R2_T2:     equ    %00000100
mSCI3DRL_R3_T3:     equ    %00001000
mSCI3DRL_R4_T4:     equ    %00010000
mSCI3DRL_R5_T5:     equ    %00100000
mSCI3DRL_R6_T6:     equ    %01000000
mSCI3DRL_R7_T7:     equ    %10000000


;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
SCI0BD:             equ    $000000C8                                ;*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI0BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI0BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI0BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI0BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI0BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI0BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI0BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI0BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI0BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI0BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI0BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI0BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI0BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI0BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI0BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI0BD_SBR0:       equ    %00000001
mSCI0BD_SBR1:       equ    %00000010
mSCI0BD_SBR2:       equ    %00000100
mSCI0BD_SBR3:       equ    %00001000
mSCI0BD_SBR4:       equ    %00010000
mSCI0BD_SBR5:       equ    %00100000
mSCI0BD_SBR6:       equ    %01000000
mSCI0BD_SBR7:       equ    %10000000
mSCI0BD_SBR8:       equ    %100000000
mSCI0BD_SBR9:       equ    %1000000000
mSCI0BD_SBR10:      equ    %10000000000
mSCI0BD_SBR11:      equ    %100000000000
mSCI0BD_SBR12:      equ    %1000000000000
mSCI0BD_TNP0:       equ    %10000000000000
mSCI0BD_TNP1:       equ    %100000000000000
mSCI0BD_IREN:       equ    %1000000000000000


;*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***
SCI0ASR1:           equ    $000000C8                                ;*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI0ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI0ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI0ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI0ASR1_BKDIF:    equ    %00000001
mSCI0ASR1_BERRIF:   equ    %00000010
mSCI0ASR1_BERRV:    equ    %00000100
mSCI0ASR1_RXEDGIF:  equ    %10000000


;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
SCI0BDH:            equ    $000000C8                                ;*** SCI0BDH - SCI 0 Baud Rate Register High; 0x000000C8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI0BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI0BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI0BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI0BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI0BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI0BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI0BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI0BDH_SBR8:      equ    %00000001
mSCI0BDH_SBR9:      equ    %00000010
mSCI0BDH_SBR10:     equ    %00000100
mSCI0BDH_SBR11:     equ    %00001000
mSCI0BDH_SBR12:     equ    %00010000
mSCI0BDH_TNP0:      equ    %00100000
mSCI0BDH_TNP1:      equ    %01000000
mSCI0BDH_IREN:      equ    %10000000


;*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***
SCI0ACR1:           equ    $000000C9                                ;*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI0ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI0ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI0ACR1_BKDIE:    equ    %00000001
mSCI0ACR1_BERRIE:   equ    %00000010
mSCI0ACR1_RXEDGIE:  equ    %10000000


;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
SCI0BDL:            equ    $000000C9                                ;*** SCI0BDL - SCI 0 Baud Rate Register Low; 0x000000C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI0BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI0BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI0BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI0BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI0BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI0BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI0BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI0BDL_SBR0:      equ    %00000001
mSCI0BDL_SBR1:      equ    %00000010
mSCI0BDL_SBR2:      equ    %00000100
mSCI0BDL_SBR3:      equ    %00001000
mSCI0BDL_SBR4:      equ    %00010000
mSCI0BDL_SBR5:      equ    %00100000
mSCI0BDL_SBR6:      equ    %01000000
mSCI0BDL_SBR7:      equ    %10000000


;*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***
SCI0ACR2:           equ    $000000CA                                ;*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI0ACR2_BERRM0:    equ    1                                         ; Bit Error Mode Bit 0
SCI0ACR2_BERRM1:    equ    2                                         ; Bit Error Mode Bit 1
; bit position masks
mSCI0ACR2_BKDFE:    equ    %00000001
mSCI0ACR2_BERRM0:   equ    %00000010
mSCI0ACR2_BERRM1:   equ    %00000100


;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
SCI0CR1:            equ    $000000CA                                ;*** SCI0CR1 - SCI 0 Control Register 1; 0x000000CA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR1_PT:         equ    0                                         ; Parity Type Bit
SCI0CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI0CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI0CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI0CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI0CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI0CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI0CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI0CR1_PT:        equ    %00000001
mSCI0CR1_PE:        equ    %00000010
mSCI0CR1_ILT:       equ    %00000100
mSCI0CR1_WAKE:      equ    %00001000
mSCI0CR1_M:         equ    %00010000
mSCI0CR1_RSRC:      equ    %00100000
mSCI0CR1_SCISWAI:   equ    %01000000
mSCI0CR1_LOOPS:     equ    %10000000


;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
SCI0CR2:            equ    $000000CB                                ;*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0CR2_SBK:        equ    0                                         ; Send Break Bit
SCI0CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI0CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI0CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI0CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI0CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI0CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI0CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI0CR2_SBK:       equ    %00000001
mSCI0CR2_RWU:       equ    %00000010
mSCI0CR2_RE:        equ    %00000100
mSCI0CR2_TE:        equ    %00001000
mSCI0CR2_ILIE:      equ    %00010000
mSCI0CR2_RIE:       equ    %00100000
mSCI0CR2_TCIE:      equ    %01000000
mSCI0CR2_TIE:       equ    %10000000


;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
SCI0SR1:            equ    $000000CC                                ;*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR1_PF:         equ    0                                         ; Parity Error Flag
SCI0SR1_FE:         equ    1                                         ; Framing Error Flag
SCI0SR1_NF:         equ    2                                         ; Noise Flag
SCI0SR1_OR:         equ    3                                         ; Overrun Flag
SCI0SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI0SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI0SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI0SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI0SR1_PF:        equ    %00000001
mSCI0SR1_FE:        equ    %00000010
mSCI0SR1_NF:        equ    %00000100
mSCI0SR1_OR:        equ    %00001000
mSCI0SR1_IDLE:      equ    %00010000
mSCI0SR1_RDRF:      equ    %00100000
mSCI0SR1_TC:        equ    %01000000
mSCI0SR1_TDRE:      equ    %10000000


;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
SCI0SR2:            equ    $000000CD                                ;*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI0SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI0SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI0SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI0SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI0SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI0SR2_RAF:       equ    %00000001
mSCI0SR2_TXDIR:     equ    %00000010
mSCI0SR2_BRK13:     equ    %00000100
mSCI0SR2_RXPOL:     equ    %00001000
mSCI0SR2_TXPOL:     equ    %00010000
mSCI0SR2_AMAP:      equ    %10000000


;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
SCI0DRH:            equ    $000000CE                                ;*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI0DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI0DRH_T8:        equ    %01000000
mSCI0DRH_R8:        equ    %10000000


;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
SCI0DRL:            equ    $000000CF                                ;*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI0DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI0DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI0DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI0DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI0DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI0DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI0DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI0DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI0DRL_R0_T0:     equ    %00000001
mSCI0DRL_R1_T1:     equ    %00000010
mSCI0DRL_R2_T2:     equ    %00000100
mSCI0DRL_R3_T3:     equ    %00001000
mSCI0DRL_R4_T4:     equ    %00010000
mSCI0DRL_R5_T5:     equ    %00100000
mSCI0DRL_R6_T6:     equ    %01000000
mSCI0DRL_R7_T7:     equ    %10000000


;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
SCI1BD:             equ    $000000D0                                ;*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI1BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI1BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI1BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI1BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI1BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI1BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI1BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI1BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI1BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI1BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI1BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI1BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI1BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI1BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI1BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI1BD_SBR0:       equ    %00000001
mSCI1BD_SBR1:       equ    %00000010
mSCI1BD_SBR2:       equ    %00000100
mSCI1BD_SBR3:       equ    %00001000
mSCI1BD_SBR4:       equ    %00010000
mSCI1BD_SBR5:       equ    %00100000
mSCI1BD_SBR6:       equ    %01000000
mSCI1BD_SBR7:       equ    %10000000
mSCI1BD_SBR8:       equ    %100000000
mSCI1BD_SBR9:       equ    %1000000000
mSCI1BD_SBR10:      equ    %10000000000
mSCI1BD_SBR11:      equ    %100000000000
mSCI1BD_SBR12:      equ    %1000000000000
mSCI1BD_TNP0:       equ    %10000000000000
mSCI1BD_TNP1:       equ    %100000000000000
mSCI1BD_IREN:       equ    %1000000000000000


;*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***
SCI1ASR1:           equ    $000000D0                                ;*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI1ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI1ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI1ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI1ASR1_BKDIF:    equ    %00000001
mSCI1ASR1_BERRIF:   equ    %00000010
mSCI1ASR1_BERRV:    equ    %00000100
mSCI1ASR1_RXEDGIF:  equ    %10000000


;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
SCI1BDH:            equ    $000000D0                                ;*** SCI1BDH - SCI 1 Baud Rate Register High; 0x000000D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI1BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI1BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI1BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI1BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI1BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI1BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI1BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI1BDH_SBR8:      equ    %00000001
mSCI1BDH_SBR9:      equ    %00000010
mSCI1BDH_SBR10:     equ    %00000100
mSCI1BDH_SBR11:     equ    %00001000
mSCI1BDH_SBR12:     equ    %00010000
mSCI1BDH_TNP0:      equ    %00100000
mSCI1BDH_TNP1:      equ    %01000000
mSCI1BDH_IREN:      equ    %10000000


;*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***
SCI1ACR1:           equ    $000000D1                                ;*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI1ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI1ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI1ACR1_BKDIE:    equ    %00000001
mSCI1ACR1_BERRIE:   equ    %00000010
mSCI1ACR1_RXEDGIE:  equ    %10000000


;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
SCI1BDL:            equ    $000000D1                                ;*** SCI1BDL - SCI 1 Baud Rate Register Low; 0x000000D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI1BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI1BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI1BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI1BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI1BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI1BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI1BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI1BDL_SBR0:      equ    %00000001
mSCI1BDL_SBR1:      equ    %00000010
mSCI1BDL_SBR2:      equ    %00000100
mSCI1BDL_SBR3:      equ    %00001000
mSCI1BDL_SBR4:      equ    %00010000
mSCI1BDL_SBR5:      equ    %00100000
mSCI1BDL_SBR6:      equ    %01000000
mSCI1BDL_SBR7:      equ    %10000000


;*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***
SCI1ACR2:           equ    $000000D2                                ;*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI1ACR2_BERRM0:    equ    1                                         ; Bit Error Mode Bit 0
SCI1ACR2_BERRM1:    equ    2                                         ; Bit Error Mode Bit 1
; bit position masks
mSCI1ACR2_BKDFE:    equ    %00000001
mSCI1ACR2_BERRM0:   equ    %00000010
mSCI1ACR2_BERRM1:   equ    %00000100


;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
SCI1CR1:            equ    $000000D2                                ;*** SCI1CR1 - SCI 1 Control Register 1; 0x000000D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR1_PT:         equ    0                                         ; Parity Type Bit
SCI1CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI1CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI1CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI1CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI1CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI1CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI1CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI1CR1_PT:        equ    %00000001
mSCI1CR1_PE:        equ    %00000010
mSCI1CR1_ILT:       equ    %00000100
mSCI1CR1_WAKE:      equ    %00001000
mSCI1CR1_M:         equ    %00010000
mSCI1CR1_RSRC:      equ    %00100000
mSCI1CR1_SCISWAI:   equ    %01000000
mSCI1CR1_LOOPS:     equ    %10000000


;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
SCI1CR2:            equ    $000000D3                                ;*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1CR2_SBK:        equ    0                                         ; Send Break Bit
SCI1CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI1CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI1CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI1CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI1CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI1CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI1CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI1CR2_SBK:       equ    %00000001
mSCI1CR2_RWU:       equ    %00000010
mSCI1CR2_RE:        equ    %00000100
mSCI1CR2_TE:        equ    %00001000
mSCI1CR2_ILIE:      equ    %00010000
mSCI1CR2_RIE:       equ    %00100000
mSCI1CR2_TCIE:      equ    %01000000
mSCI1CR2_TIE:       equ    %10000000


;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
SCI1SR1:            equ    $000000D4                                ;*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR1_PF:         equ    0                                         ; Parity Error Flag
SCI1SR1_FE:         equ    1                                         ; Framing Error Flag
SCI1SR1_NF:         equ    2                                         ; Noise Flag
SCI1SR1_OR:         equ    3                                         ; Overrun Flag
SCI1SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI1SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI1SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI1SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI1SR1_PF:        equ    %00000001
mSCI1SR1_FE:        equ    %00000010
mSCI1SR1_NF:        equ    %00000100
mSCI1SR1_OR:        equ    %00001000
mSCI1SR1_IDLE:      equ    %00010000
mSCI1SR1_RDRF:      equ    %00100000
mSCI1SR1_TC:        equ    %01000000
mSCI1SR1_TDRE:      equ    %10000000


;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
SCI1SR2:            equ    $000000D5                                ;*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI1SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI1SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI1SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI1SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI1SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI1SR2_RAF:       equ    %00000001
mSCI1SR2_TXDIR:     equ    %00000010
mSCI1SR2_BRK13:     equ    %00000100
mSCI1SR2_RXPOL:     equ    %00001000
mSCI1SR2_TXPOL:     equ    %00010000
mSCI1SR2_AMAP:      equ    %10000000


;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
SCI1DRH:            equ    $000000D6                                ;*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI1DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI1DRH_T8:        equ    %01000000
mSCI1DRH_R8:        equ    %10000000


;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
SCI1DRL:            equ    $000000D7                                ;*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI1DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI1DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI1DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI1DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI1DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI1DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI1DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI1DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI1DRL_R0_T0:     equ    %00000001
mSCI1DRL_R1_T1:     equ    %00000010
mSCI1DRL_R2_T2:     equ    %00000100
mSCI1DRL_R3_T3:     equ    %00001000
mSCI1DRL_R4_T4:     equ    %00010000
mSCI1DRL_R5_T5:     equ    %00100000
mSCI1DRL_R6_T6:     equ    %01000000
mSCI1DRL_R7_T7:     equ    %10000000


;*** SPI0CR1 - SPI 0 Control Register; 0x000000D8 ***
SPI0CR1:            equ    $000000D8                                ;*** SPI0CR1 - SPI 0 Control Register; 0x000000D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI0CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI0CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI0CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI0CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI0CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI0CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI0CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI0CR1_LSBFE:     equ    %00000001
mSPI0CR1_SSOE:      equ    %00000010
mSPI0CR1_CPHA:      equ    %00000100
mSPI0CR1_CPOL:      equ    %00001000
mSPI0CR1_MSTR:      equ    %00010000
mSPI0CR1_SPTIE:     equ    %00100000
mSPI0CR1_SPE:       equ    %01000000
mSPI0CR1_SPIE:      equ    %10000000


;*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***
SPI0CR2:            equ    $000000D9                                ;*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI0CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI0CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI0CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPI0CR2_SPC0:      equ    %00000001
mSPI0CR2_SPISWAI:   equ    %00000010
mSPI0CR2_BIDIROE:   equ    %00001000
mSPI0CR2_MODFEN:    equ    %00010000


;*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***
SPI0BR:             equ    $000000DA                                ;*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI0BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI0BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI0BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI0BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI0BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI0BR_SPR0:       equ    %00000001
mSPI0BR_SPR1:       equ    %00000010
mSPI0BR_SPR2:       equ    %00000100
mSPI0BR_SPPR0:      equ    %00010000
mSPI0BR_SPPR1:      equ    %00100000
mSPI0BR_SPPR2:      equ    %01000000


;*** SPI0SR - SPI 0 Status Register; 0x000000DB ***
SPI0SR:             equ    $000000DB                                ;*** SPI0SR - SPI 0 Status Register; 0x000000DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI0SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI0SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI0SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI0SR_MODF:       equ    %00010000
mSPI0SR_SPTEF:      equ    %00100000
mSPI0SR_SPIF:       equ    %10000000


;*** SPI0DR - SPI 0 Data Register; 0x000000DD ***
SPI0DR:             equ    $000000DD                                ;*** SPI0DR - SPI 0 Data Register; 0x000000DD ***


;*** IIC0_IBAD - IIC 0 Address Register; 0x000000E0 ***
IIC0_IBAD:          equ    $000000E0                                ;*** IIC0_IBAD - IIC 0 Address Register; 0x000000E0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBAD_ADR1:     equ    1                                         ; Slave Address Bit 1
IIC0_IBAD_ADR2:     equ    2                                         ; Slave Address Bit 2
IIC0_IBAD_ADR3:     equ    3                                         ; Slave Address Bit 3
IIC0_IBAD_ADR4:     equ    4                                         ; Slave Address Bit 4
IIC0_IBAD_ADR5:     equ    5                                         ; Slave Address Bit 5
IIC0_IBAD_ADR6:     equ    6                                         ; Slave Address Bit 6
IIC0_IBAD_ADR7:     equ    7                                         ; Slave Address Bit 7
; bit position masks
mIIC0_IBAD_ADR1:    equ    %00000010
mIIC0_IBAD_ADR2:    equ    %00000100
mIIC0_IBAD_ADR3:    equ    %00001000
mIIC0_IBAD_ADR4:    equ    %00010000
mIIC0_IBAD_ADR5:    equ    %00100000
mIIC0_IBAD_ADR6:    equ    %01000000
mIIC0_IBAD_ADR7:    equ    %10000000


;*** IIC0_IBFD - IIC 0 Frequency Divider Register; 0x000000E1 ***
IIC0_IBFD:          equ    $000000E1                                ;*** IIC0_IBFD - IIC 0 Frequency Divider Register; 0x000000E1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBFD_IBC0:     equ    0                                         ; I-Bus Clock Rate 0
IIC0_IBFD_IBC1:     equ    1                                         ; I-Bus Clock Rate 1
IIC0_IBFD_IBC2:     equ    2                                         ; I-Bus Clock Rate 2
IIC0_IBFD_IBC3:     equ    3                                         ; I-Bus Clock Rate 3
IIC0_IBFD_IBC4:     equ    4                                         ; I-Bus Clock Rate 4
IIC0_IBFD_IBC5:     equ    5                                         ; I-Bus Clock Rate 5
IIC0_IBFD_IBC6:     equ    6                                         ; I-Bus Clock Rate 6
IIC0_IBFD_IBC7:     equ    7                                         ; I-Bus Clock Rate 7
; bit position masks
mIIC0_IBFD_IBC0:    equ    %00000001
mIIC0_IBFD_IBC1:    equ    %00000010
mIIC0_IBFD_IBC2:    equ    %00000100
mIIC0_IBFD_IBC3:    equ    %00001000
mIIC0_IBFD_IBC4:    equ    %00010000
mIIC0_IBFD_IBC5:    equ    %00100000
mIIC0_IBFD_IBC6:    equ    %01000000
mIIC0_IBFD_IBC7:    equ    %10000000


;*** IIC0_IBCR - IIC 0 Control Register; 0x000000E2 ***
IIC0_IBCR:          equ    $000000E2                                ;*** IIC0_IBCR - IIC 0 Control Register; 0x000000E2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBCR_IBSWAI:   equ    0                                         ; I-Bus Interface Stop in WAIT mode
IIC0_IBCR_RSTA:     equ    2                                         ; Repeat Start
IIC0_IBCR_TXAK:     equ    3                                         ; Transmit Acknowledge enable
IIC0_IBCR_TX_RX:    equ    4                                         ; Transmit/Receive mode select bit
IIC0_IBCR_MS_SL:    equ    5                                         ; Master/Slave mode select bit
IIC0_IBCR_IBIE:     equ    6                                         ; I-Bus Interrupt Enable
IIC0_IBCR_IBEN:     equ    7                                         ; I-Bus Enable
; bit position masks
mIIC0_IBCR_IBSWAI:  equ    %00000001
mIIC0_IBCR_RSTA:    equ    %00000100
mIIC0_IBCR_TXAK:    equ    %00001000
mIIC0_IBCR_TX_RX:   equ    %00010000
mIIC0_IBCR_MS_SL:   equ    %00100000
mIIC0_IBCR_IBIE:    equ    %01000000
mIIC0_IBCR_IBEN:    equ    %10000000


;*** IIC0_IBSR - IIC 0 Status Register; 0x000000E3 ***
IIC0_IBSR:          equ    $000000E3                                ;*** IIC0_IBSR - IIC 0 Status Register; 0x000000E3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBSR_RXAK:     equ    0                                         ; Received Acknowledge
IIC0_IBSR_IBIF:     equ    1                                         ; I-Bus Interrupt
IIC0_IBSR_SRW:      equ    2                                         ; Slave Read/Write
IIC0_IBSR_IBAL:     equ    4                                         ; Arbitration Lost
IIC0_IBSR_IBB:      equ    5                                         ; Bus busy bit
IIC0_IBSR_IAAS:     equ    6                                         ; Addressed as a slave bit
IIC0_IBSR_TCF:      equ    7                                         ; Data transferring bit
; bit position masks
mIIC0_IBSR_RXAK:    equ    %00000001
mIIC0_IBSR_IBIF:    equ    %00000010
mIIC0_IBSR_SRW:     equ    %00000100
mIIC0_IBSR_IBAL:    equ    %00010000
mIIC0_IBSR_IBB:     equ    %00100000
mIIC0_IBSR_IAAS:    equ    %01000000
mIIC0_IBSR_TCF:     equ    %10000000


;*** IIC0_IBDR - IIC 0 Data I/O Register; 0x000000E4 ***
IIC0_IBDR:          equ    $000000E4                                ;*** IIC0_IBDR - IIC 0 Data I/O Register; 0x000000E4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IIC0_IBDR_D0:       equ    0                                         ; IIC Data Bit 0
IIC0_IBDR_D1:       equ    1                                         ; IIC Data Bit 1
IIC0_IBDR_D2:       equ    2                                         ; IIC Data Bit 2
IIC0_IBDR_D3:       equ    3                                         ; IIC Data Bit 3
IIC0_IBDR_D4:       equ    4                                         ; IIC Data Bit 4
IIC0_IBDR_D5:       equ    5                                         ; IIC Data Bit 5
IIC0_IBDR_D6:       equ    6                                         ; IIC Data Bit 6
IIC0_IBDR_D7:       equ    7                                         ; IIC Data Bit 7
; bit position masks
mIIC0_IBDR_D0:      equ    %00000001
mIIC0_IBDR_D1:      equ    %00000010
mIIC0_IBDR_D2:      equ    %00000100
mIIC0_IBDR_D3:      equ    %00001000
mIIC0_IBDR_D4:      equ    %00010000
mIIC0_IBDR_D5:      equ    %00100000
mIIC0_IBDR_D6:      equ    %01000000
mIIC0_IBDR_D7:      equ    %10000000


;*** SPI1CR1 - SPI 1 Control Register; 0x000000F0 ***
SPI1CR1:            equ    $000000F0                                ;*** SPI1CR1 - SPI 1 Control Register; 0x000000F0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI1CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI1CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI1CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI1CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI1CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI1CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI1CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI1CR1_LSBFE:     equ    %00000001
mSPI1CR1_SSOE:      equ    %00000010
mSPI1CR1_CPHA:      equ    %00000100
mSPI1CR1_CPOL:      equ    %00001000
mSPI1CR1_MSTR:      equ    %00010000
mSPI1CR1_SPTIE:     equ    %00100000
mSPI1CR1_SPE:       equ    %01000000
mSPI1CR1_SPIE:      equ    %10000000


;*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***
SPI1CR2:            equ    $000000F1                                ;*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI1CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI1CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI1CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPI1CR2_SPC0:      equ    %00000001
mSPI1CR2_SPISWAI:   equ    %00000010
mSPI1CR2_BIDIROE:   equ    %00001000
mSPI1CR2_MODFEN:    equ    %00010000


;*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***
SPI1BR:             equ    $000000F2                                ;*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI1BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI1BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI1BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI1BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI1BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI1BR_SPR0:       equ    %00000001
mSPI1BR_SPR1:       equ    %00000010
mSPI1BR_SPR2:       equ    %00000100
mSPI1BR_SPPR0:      equ    %00010000
mSPI1BR_SPPR1:      equ    %00100000
mSPI1BR_SPPR2:      equ    %01000000


;*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***
SPI1SR:             equ    $000000F3                                ;*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI1SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI1SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI1SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI1SR_MODF:       equ    %00010000
mSPI1SR_SPTEF:      equ    %00100000
mSPI1SR_SPIF:       equ    %10000000


;*** SPI1DR - SPI 1 Data Register; 0x000000F5 ***
SPI1DR:             equ    $000000F5                                ;*** SPI1DR - SPI 1 Data Register; 0x000000F5 ***


;*** SPI2CR1 - SPI 2 Control Register; 0x000000F8 ***
SPI2CR1:            equ    $000000F8                                ;*** SPI2CR1 - SPI 2 Control Register; 0x000000F8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2CR1_LSBFE:      equ    0                                         ; SPI LSB-First Enable
SPI2CR1_SSOE:       equ    1                                         ; Slave Select Output Enable
SPI2CR1_CPHA:       equ    2                                         ; SPI Clock Phase Bit
SPI2CR1_CPOL:       equ    3                                         ; SPI Clock Polarity Bit
SPI2CR1_MSTR:       equ    4                                         ; SPI Master/Slave Mode Select Bit
SPI2CR1_SPTIE:      equ    5                                         ; SPI Transmit Interrupt Enable
SPI2CR1_SPE:        equ    6                                         ; SPI System Enable Bit
SPI2CR1_SPIE:       equ    7                                         ; SPI Interrupt Enable Bit
; bit position masks
mSPI2CR1_LSBFE:     equ    %00000001
mSPI2CR1_SSOE:      equ    %00000010
mSPI2CR1_CPHA:      equ    %00000100
mSPI2CR1_CPOL:      equ    %00001000
mSPI2CR1_MSTR:      equ    %00010000
mSPI2CR1_SPTIE:     equ    %00100000
mSPI2CR1_SPE:       equ    %01000000
mSPI2CR1_SPIE:      equ    %10000000


;*** SPI2CR2 - SPI 2 Control Register 2; 0x000000F9 ***
SPI2CR2:            equ    $000000F9                                ;*** SPI2CR2 - SPI 2 Control Register 2; 0x000000F9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2CR2_SPC0:       equ    0                                         ; Serial Pin Control Bit 0
SPI2CR2_SPISWAI:    equ    1                                         ; SPI Stop in Wait Mode Bit
SPI2CR2_BIDIROE:    equ    3                                         ; Output enable in the Bidirectional mode of operation
SPI2CR2_MODFEN:     equ    4                                         ; Mode Fault Enable Bit
; bit position masks
mSPI2CR2_SPC0:      equ    %00000001
mSPI2CR2_SPISWAI:   equ    %00000010
mSPI2CR2_BIDIROE:   equ    %00001000
mSPI2CR2_MODFEN:    equ    %00010000


;*** SPI2BR - SPI 2 Baud Rate Register; 0x000000FA ***
SPI2BR:             equ    $000000FA                                ;*** SPI2BR - SPI 2 Baud Rate Register; 0x000000FA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2BR_SPR0:        equ    0                                         ; SPI Baud Rate Selection Bit 0
SPI2BR_SPR1:        equ    1                                         ; SPI Baud Rate Selection Bit 1
SPI2BR_SPR2:        equ    2                                         ; SPI Baud Rate Selection Bit 2
SPI2BR_SPPR0:       equ    4                                         ; SPI Baud Rate Preselection Bits 0
SPI2BR_SPPR1:       equ    5                                         ; SPI Baud Rate Preselection Bits 1
SPI2BR_SPPR2:       equ    6                                         ; SPI Baud Rate Preselection Bits 2
; bit position masks
mSPI2BR_SPR0:       equ    %00000001
mSPI2BR_SPR1:       equ    %00000010
mSPI2BR_SPR2:       equ    %00000100
mSPI2BR_SPPR0:      equ    %00010000
mSPI2BR_SPPR1:      equ    %00100000
mSPI2BR_SPPR2:      equ    %01000000


;*** SPI2SR - SPI 2 Status Register; 0x000000FB ***
SPI2SR:             equ    $000000FB                                ;*** SPI2SR - SPI 2 Status Register; 0x000000FB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPI2SR_MODF:        equ    4                                         ; Mode Fault Flag
SPI2SR_SPTEF:       equ    5                                         ; SPI Transmit Empty Interrupt Flag
SPI2SR_SPIF:        equ    7                                         ; SPIF Receive Interrupt Flag
; bit position masks
mSPI2SR_MODF:       equ    %00010000
mSPI2SR_SPTEF:      equ    %00100000
mSPI2SR_SPIF:       equ    %10000000


;*** SPI2DR - SPI 2 Data Register; 0x000000FD ***
SPI2DR:             equ    $000000FD                                ;*** SPI2DR - SPI 2 Data Register; 0x000000FD ***


;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
FCLKDIV:            equ    $00000100                                ;*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCLKDIV_FDIV0:      equ    0                                         ; Flash Clock Divider Bit 0
FCLKDIV_FDIV1:      equ    1                                         ; Flash Clock Divider Bit 1
FCLKDIV_FDIV2:      equ    2                                         ; Flash Clock Divider Bit 2
FCLKDIV_FDIV3:      equ    3                                         ; Flash Clock Divider Bit 3
FCLKDIV_FDIV4:      equ    4                                         ; Flash Clock Divider Bit 4
FCLKDIV_FDIV5:      equ    5                                         ; Flash Clock Divider Bit 5
FCLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
FCLKDIV_FDIVLD:     equ    7                                         ; Flash Clock Divider Loaded
; bit position masks
mFCLKDIV_FDIV0:     equ    %00000001
mFCLKDIV_FDIV1:     equ    %00000010
mFCLKDIV_FDIV2:     equ    %00000100
mFCLKDIV_FDIV3:     equ    %00001000
mFCLKDIV_FDIV4:     equ    %00010000
mFCLKDIV_FDIV5:     equ    %00100000
mFCLKDIV_PRDIV8:    equ    %01000000
mFCLKDIV_FDIVLD:    equ    %10000000


;*** FSEC - Flash Security Register; 0x00000101 ***
FSEC:               equ    $00000101                                ;*** FSEC - Flash Security Register; 0x00000101 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSEC_SEC0:          equ    0                                         ; Memory security bit 0
FSEC_SEC1:          equ    1                                         ; Memory security bit 1
FSEC_RNV2:          equ    2                                         ; Reserved Non Volatile flag bit 2
FSEC_RNV3:          equ    3                                         ; Reserved Non Volatile flag bit 3
FSEC_RNV4:          equ    4                                         ; Reserved Non Volatile flag bit 4
FSEC_RNV5:          equ    5                                         ; Reserved Non Volatile flag bit 5
FSEC_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FSEC_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFSEC_SEC0:         equ    %00000001
mFSEC_SEC1:         equ    %00000010
mFSEC_RNV2:         equ    %00000100
mFSEC_RNV3:         equ    %00001000
mFSEC_RNV4:         equ    %00010000
mFSEC_RNV5:         equ    %00100000
mFSEC_KEYEN0:       equ    %01000000
mFSEC_KEYEN1:       equ    %10000000


;*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***
FTSTMOD:            equ    $00000102                                ;*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FTSTMOD_WRALL:      equ    4                                         ; Write to all register banks
FTSTMOD_MRDS:       equ    5                                         ; Margin Read Setting
; bit position masks
mFTSTMOD_WRALL:     equ    %00010000
mFTSTMOD_MRDS:      equ    %01100000


;*** FCNFG - Flash Configuration Register; 0x00000103 ***
FCNFG:              equ    $00000103                                ;*** FCNFG - Flash Configuration Register; 0x00000103 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_BKSEL0:       equ    0                                         ; Register bank select 0 (Special mode only)
FCNFG_BKSEL1:       equ    1                                         ; Register bank select 1 (Special mode only)
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
FCNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
FCNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mFCNFG_BKSEL0:      equ    %00000001
mFCNFG_BKSEL1:      equ    %00000010
mFCNFG_KEYACC:      equ    %00100000
mFCNFG_CCIE:        equ    %01000000
mFCNFG_CBEIE:       equ    %10000000


;*** FPROT - Flash Protection Register; 0x00000104 ***
FPROT:              equ    $00000104                                ;*** FPROT - Flash Protection Register; 0x00000104 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPLS0:        equ    0                                         ; Flash Protection Lower Address size 0
FPROT_FPLS1:        equ    1                                         ; Flash Protection Lower Address size 1
FPROT_FPLDIS:       equ    2                                         ; Flash Protection Lower address range disable
FPROT_FPHS0:        equ    3                                         ; Flash Protection Higher address size 0
FPROT_FPHS1:        equ    4                                         ; Flash Protection Higher address size 1
FPROT_FPHDIS:       equ    5                                         ; Flash Protection Higher address range disable
FPROT_RNV6:         equ    6                                         ; Reserved Non-Volatile Bit
FPROT_FPOPEN:       equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mFPROT_FPLS0:       equ    %00000001
mFPROT_FPLS1:       equ    %00000010
mFPROT_FPLDIS:      equ    %00000100
mFPROT_FPHS0:       equ    %00001000
mFPROT_FPHS1:       equ    %00010000
mFPROT_FPHDIS:      equ    %00100000
mFPROT_RNV6:        equ    %01000000
mFPROT_FPOPEN:      equ    %10000000


;*** FSTAT - Flash Status Register; 0x00000105 ***
FSTAT:              equ    $00000105                                ;*** FSTAT - Flash Status Register; 0x00000105 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_FAIL:         equ    1                                         ; Failed Flash Operation Flag (Special mode only)
FSTAT_BLANK:        equ    2                                         ; Blank Verify Flag
FSTAT_ACCERR:       equ    4                                         ; Access error
FSTAT_PVIOL:        equ    5                                         ; Protection violation
FSTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
FSTAT_CBEIF:        equ    7                                         ; Command Buffers Empty Interrupt Flag
; bit position masks
mFSTAT_FAIL:        equ    %00000010
mFSTAT_BLANK:       equ    %00000100
mFSTAT_ACCERR:      equ    %00010000
mFSTAT_PVIOL:       equ    %00100000
mFSTAT_CCIF:        equ    %01000000
mFSTAT_CBEIF:       equ    %10000000


;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
FCMD:               equ    $00000106                                ;*** FCMD - Flash Command Buffer and Register; 0x00000106 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_CMDB0:         equ    0                                         ; NVM User Mode Command Bit 0
FCMD_CMDB1:         equ    1                                         ; NVM User Mode Command Bit 1
FCMD_CMDB2:         equ    2                                         ; NVM User Mode Command Bit 2
FCMD_CMDB3:         equ    3                                         ; NVM User Mode Command Bit 3
FCMD_CMDB4:         equ    4                                         ; NVM User Mode Command Bit 4
FCMD_CMDB5:         equ    5                                         ; NVM User Mode Command Bit 5
FCMD_CMDB6:         equ    6                                         ; NVM User Mode Command Bit 6
; bit position masks
mFCMD_CMDB0:        equ    %00000001
mFCMD_CMDB1:        equ    %00000010
mFCMD_CMDB2:        equ    %00000100
mFCMD_CMDB3:        equ    %00001000
mFCMD_CMDB4:        equ    %00010000
mFCMD_CMDB5:        equ    %00100000
mFCMD_CMDB6:        equ    %01000000


;*** FCTL - Flash Control Register; 0x00000107 ***
FCTL:               equ    $00000107                                ;*** FCTL - Flash Control Register; 0x00000107 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCTL_NV0:           equ    0                                         ; Non-volatile bit 0
FCTL_NV1:           equ    1                                         ; Non-volatile bit 1
FCTL_NV2:           equ    2                                         ; Non-volatile bit 2
FCTL_NV3:           equ    3                                         ; Non-volatile bit 3
FCTL_NV4:           equ    4                                         ; Non-volatile bit 4
FCTL_NV5:           equ    5                                         ; Non-volatile bit 5
FCTL_NV6:           equ    6                                         ; Non-volatile bit 6
FCTL_NV7:           equ    7                                         ; Non-volatile bit 7
; bit position masks
mFCTL_NV0:          equ    %00000001
mFCTL_NV1:          equ    %00000010
mFCTL_NV2:          equ    %00000100
mFCTL_NV3:          equ    %00001000
mFCTL_NV4:          equ    %00010000
mFCTL_NV5:          equ    %00100000
mFCTL_NV6:          equ    %01000000
mFCTL_NV7:          equ    %10000000


;*** FADDR - Flash Address Register; 0x00000108 ***
FADDR:              equ    $00000108                                ;*** FADDR - Flash Address Register; 0x00000108 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FADDR_FADDRLO:      equ    0                                         ; Flash Address Bits
FADDR_FADDRHI:      equ    8                                         ; Flash Address Bits
; bit position masks
mFADDR_FADDRLO:     equ    %11111111
mFADDR_FADDRHI:     equ    %1111111100000000


;*** FADDRHI - Flash Address High Register; 0x00000108 ***
FADDRHI:            equ    $00000108                                ;*** FADDRHI - Flash Address High Register; 0x00000108 ***


;*** FADDRLO - Flash Address Low Register; 0x00000109 ***
FADDRLO:            equ    $00000109                                ;*** FADDRLO - Flash Address Low Register; 0x00000109 ***


;*** FDATA - Flash Data Register; 0x0000010A ***
FDATA:              equ    $0000010A                                ;*** FDATA - Flash Data Register; 0x0000010A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FDATA_FDATALO:      equ    0                                         ; Flash Data Bits
FDATA_FDATAHI:      equ    8                                         ; Flash Data Bits
; bit position masks
mFDATA_FDATALO:     equ    %11111111
mFDATA_FDATAHI:     equ    %1111111100000000


;*** FDATAHI - Flash Data High Register; 0x0000010A ***
FDATAHI:            equ    $0000010A                                ;*** FDATAHI - Flash Data High Register; 0x0000010A ***


;*** FDATALO - Flash Data Low Register; 0x0000010B ***
FDATALO:            equ    $0000010B                                ;*** FDATALO - Flash Data Low Register; 0x0000010B ***


;*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***
ECLKDIV:            equ    $00000110                                ;*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECLKDIV_EDIV0:      equ    0                                         ; EEPROM Clock Divider 0
ECLKDIV_EDIV1:      equ    1                                         ; EEPROM Clock Divider 1
ECLKDIV_EDIV2:      equ    2                                         ; EEPROM Clock Divider 2
ECLKDIV_EDIV3:      equ    3                                         ; EEPROM Clock Divider 3
ECLKDIV_EDIV4:      equ    4                                         ; EEPROM Clock Divider 4
ECLKDIV_EDIV5:      equ    5                                         ; EEPROM Clock Divider 5
ECLKDIV_PRDIV8:     equ    6                                         ; Enable Prescaler by 8
ECLKDIV_EDIVLD:     equ    7                                         ; EEPROM Clock Divider Loaded
; bit position masks
mECLKDIV_EDIV0:     equ    %00000001
mECLKDIV_EDIV1:     equ    %00000010
mECLKDIV_EDIV2:     equ    %00000100
mECLKDIV_EDIV3:     equ    %00001000
mECLKDIV_EDIV4:     equ    %00010000
mECLKDIV_EDIV5:     equ    %00100000
mECLKDIV_PRDIV8:    equ    %01000000
mECLKDIV_EDIVLD:    equ    %10000000


;*** ECNFG - EEPROM Configuration Register; 0x00000113 ***
ECNFG:              equ    $00000113                                ;*** ECNFG - EEPROM Configuration Register; 0x00000113 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECNFG_CCIE:         equ    6                                         ; Command Complete Interrupt Enable
ECNFG_CBEIE:        equ    7                                         ; Command Buffers Empty Interrupt Enable
; bit position masks
mECNFG_CCIE:        equ    %01000000
mECNFG_CBEIE:       equ    %10000000


;*** EPROT - EEPROM Protection Register; 0x00000114 ***
EPROT:              equ    $00000114                                ;*** EPROT - EEPROM Protection Register; 0x00000114 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EPROT_EPS0:         equ    0                                         ; EEPROM Protection address size 0
EPROT_EPS1:         equ    1                                         ; EEPROM Protection address size 1
EPROT_EPS2:         equ    2                                         ; EEPROM Protection address size 2
EPROT_EPDIS:        equ    3                                         ; EEPROM Protection disable
EPROT_RNV4:         equ    4                                         ; EEPROM Protection address size 4
EPROT_RNV5:         equ    5                                         ; EEPROM Protection address size 5
EPROT_RNV6:         equ    6                                         ; EEPROM Protection address size 6
EPROT_EPOPEN:       equ    7                                         ; Opens the EEPROM block or a subsection of it for program or erase
; bit position masks
mEPROT_EPS0:        equ    %00000001
mEPROT_EPS1:        equ    %00000010
mEPROT_EPS2:        equ    %00000100
mEPROT_EPDIS:       equ    %00001000
mEPROT_RNV4:        equ    %00010000
mEPROT_RNV5:        equ    %00100000
mEPROT_RNV6:        equ    %01000000
mEPROT_EPOPEN:      equ    %10000000


;*** ESTAT - EEPROM Status Register; 0x00000115 ***
ESTAT:              equ    $00000115                                ;*** ESTAT - EEPROM Status Register; 0x00000115 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ESTAT_FAIL:         equ    1                                         ; Failed EEPROM Operation Flag (Special mode only)
ESTAT_BLANK:        equ    2                                         ; Blank Verify Flag
ESTAT_ACCERR:       equ    4                                         ; Access error
ESTAT_PVIOL:        equ    5                                         ; Protection violation
ESTAT_CCIF:         equ    6                                         ; Command Complete Interrupt Flag
ESTAT_CBEIF:        equ    7                                         ; Command Buffer Empty Interrupt Flag
; bit position masks
mESTAT_FAIL:        equ    %00000010
mESTAT_BLANK:       equ    %00000100
mESTAT_ACCERR:      equ    %00010000
mESTAT_PVIOL:       equ    %00100000
mESTAT_CCIF:        equ    %01000000
mESTAT_CBEIF:       equ    %10000000


;*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***
ECMD:               equ    $00000116                                ;*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ECMD_CMDB:          equ    0                                         ; EEPROM command
; bit position masks
mECMD_CMDB:         equ    %01111111


;*** EADDR - EEPROM Address Register; 0x00000118 ***
EADDR:              equ    $00000118                                ;*** EADDR - EEPROM Address Register; 0x00000118 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EADDR_EABLO:        equ    0                                         ; EEPROM Address Bits
EADDR_EABHI:        equ    8                                         ; EEPROM Address Bits
; bit position masks
mEADDR_EABLO:       equ    %11111111
mEADDR_EABHI:       equ    %11100000000


;*** EADDRHI - EEPROM Address High Register; 0x00000118 ***
EADDRHI:            equ    $00000118                                ;*** EADDRHI - EEPROM Address High Register; 0x00000118 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EADDRHI_EABHI:      equ    0                                         ; EEPROM Address High Bits
; bit position masks
mEADDRHI_EABHI:     equ    %00000111


;*** EADDRLO - EEPROM Address Low Register; 0x00000119 ***
EADDRLO:            equ    $00000119                                ;*** EADDRLO - EEPROM Address Low Register; 0x00000119 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EADDRLO_EABLO:      equ    0                                         ; EEPROM Address Low Bits
; bit position masks
mEADDRLO_EABLO:     equ    %11111111


;*** EDATA - EEPROM Data Register; 0x0000011A ***
EDATA:              equ    $0000011A                                ;*** EDATA - EEPROM Data Register; 0x0000011A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EDATA_EDLO:         equ    0                                         ; EEPROM Data Bits
EDATA_EDHI:         equ    8                                         ; EEPROM Data Bits
; bit position masks
mEDATA_EDLO:        equ    %11111111
mEDATA_EDHI:        equ    %1111111100000000


;*** EDATAHI - EEPROM Data High Register; 0x0000011A ***
EDATAHI:            equ    $0000011A                                ;*** EDATAHI - EEPROM Data High Register; 0x0000011A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EDATAHI_EDHI:       equ    0                                         ; EEPROM Data High Bits
; bit position masks
mEDATAHI_EDHI:      equ    %11111111


;*** EDATALO - EEPROM Data Low Register; 0x0000011B ***
EDATALO:            equ    $0000011B                                ;*** EDATALO - EEPROM Data Low Register; 0x0000011B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
EDATALO_EDLO:       equ    0                                         ; EEPROM Data Low Bits
; bit position masks
mEDATALO_EDLO:      equ    %11111111


;*** RAMWPC - RAM Write Protection Control Register; 0x0000011C ***
RAMWPC:             equ    $0000011C                                ;*** RAMWPC - RAM Write Protection Control Register; 0x0000011C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RAMWPC_AVIF:        equ    0                                         ; S12X_CPU Access Violation Interrupt Flag
RAMWPC_AVIE:        equ    1                                         ; S12X_CPU Access Violation Interrupt Enable
RAMWPC_RWPE:        equ    7                                         ; RAM Write Protection Enable
; bit position masks
mRAMWPC_AVIF:       equ    %00000001
mRAMWPC_AVIE:       equ    %00000010
mRAMWPC_RWPE:       equ    %10000000


;*** RAMXGU - RAM XGATE Upper Boundary Register; 0x0000011D ***
RAMXGU:             equ    $0000011D                                ;*** RAMXGU - RAM XGATE Upper Boundary Register; 0x0000011D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RAMXGU_XGU0:        equ    0                                         ; XGATE Region Upper Boundary Bit 0
RAMXGU_XGU1:        equ    1                                         ; XGATE Region Upper Boundary Bit 1
RAMXGU_XGU2:        equ    2                                         ; XGATE Region Upper Boundary Bit 2
RAMXGU_XGU3:        equ    3                                         ; XGATE Region Upper Boundary Bit 3
RAMXGU_XGU4:        equ    4                                         ; XGATE Region Upper Boundary Bit 4
RAMXGU_XGU5:        equ    5                                         ; XGATE Region Upper Boundary Bit 5
RAMXGU_XGU6:        equ    6                                         ; XGATE Region Upper Boundary Bit 6
; bit position masks
mRAMXGU_XGU0:       equ    %00000001
mRAMXGU_XGU1:       equ    %00000010
mRAMXGU_XGU2:       equ    %00000100
mRAMXGU_XGU3:       equ    %00001000
mRAMXGU_XGU4:       equ    %00010000
mRAMXGU_XGU5:       equ    %00100000
mRAMXGU_XGU6:       equ    %01000000


;*** RAMSHL - RAM Shared Region Lower Boundary Register; 0x0000011E ***
RAMSHL:             equ    $0000011E                                ;*** RAMSHL - RAM Shared Region Lower Boundary Register; 0x0000011E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RAMSHL_SHL0:        equ    0                                         ; RAM Shared Region Lower Boundary Bit 0
RAMSHL_SHL1:        equ    1                                         ; RAM Shared Region Lower Boundary Bit 1
RAMSHL_SHL2:        equ    2                                         ; RAM Shared Region Lower Boundary Bit 2
RAMSHL_SHL3:        equ    3                                         ; RAM Shared Region Lower Boundary Bit 3
RAMSHL_SHL4:        equ    4                                         ; RAM Shared Region Lower Boundary Bit 4
RAMSHL_SHL5:        equ    5                                         ; RAM Shared Region Lower Boundary Bit 5
RAMSHL_SHL6:        equ    6                                         ; RAM Shared Region Lower Boundary Bit 6
; bit position masks
mRAMSHL_SHL0:       equ    %00000001
mRAMSHL_SHL1:       equ    %00000010
mRAMSHL_SHL2:       equ    %00000100
mRAMSHL_SHL3:       equ    %00001000
mRAMSHL_SHL4:       equ    %00010000
mRAMSHL_SHL5:       equ    %00100000
mRAMSHL_SHL6:       equ    %01000000


;*** RAMSHU - RAM Shared Region Upper Boundary Register; 0x0000011F ***
RAMSHU:             equ    $0000011F                                ;*** RAMSHU - RAM Shared Region Upper Boundary Register; 0x0000011F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RAMSHU_SHU0:        equ    0                                         ; RAM Shared Region Upper Boundary Bit 0
RAMSHU_SHU1:        equ    1                                         ; RAM Shared Region Upper Boundary Bit 1
RAMSHU_SHU2:        equ    2                                         ; RAM Shared Region Upper Boundary Bit 2
RAMSHU_SHU3:        equ    3                                         ; RAM Shared Region Upper Boundary Bit 3
RAMSHU_SHU4:        equ    4                                         ; RAM Shared Region Upper Boundary Bit 4
RAMSHU_SHU5:        equ    5                                         ; RAM Shared Region Upper Boundary Bit 5
RAMSHU_SHU6:        equ    6                                         ; RAM Shared Region Upper Boundary Bit 6
; bit position masks
mRAMSHU_SHU0:       equ    %00000001
mRAMSHU_SHU1:       equ    %00000010
mRAMSHU_SHU2:       equ    %00000100
mRAMSHU_SHU3:       equ    %00001000
mRAMSHU_SHU4:       equ    %00010000
mRAMSHU_SHU5:       equ    %00100000
mRAMSHU_SHU6:       equ    %01000000


;*** IVBR - Interrupt Vector Base Register; 0x00000121 ***
IVBR:               equ    $00000121                                ;*** IVBR - Interrupt Vector Base Register; 0x00000121 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IVBR_IVB_ADDR:      equ    0                                         ; Interrupt vector base address bits
; bit position masks
mIVBR_IVB_ADDR:     equ    %11111111


;*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x00000126 ***
INT_XGPRIO:         equ    $00000126                                ;*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x00000126 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_XGPRIO_XILVL:   equ    0                                         ; XGATE Interrupt Priority Level
; bit position masks
mINT_XGPRIO_XILVL:  equ    %00000111


;*** INT_CFADDR - Interrupt Configuration Address Register; 0x00000127 ***
INT_CFADDR:         equ    $00000127                                ;*** INT_CFADDR - Interrupt Configuration Address Register; 0x00000127 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFADDR_INT_CFADDR: equ    4                                      ; Interrupt Request Configuration Data Register select bits
; bit position masks
mINT_CFADDR_INT_CFADDR: equ    %11110000


;*** INT_CFDATA0 - Interrupt Configuration Data Register 0; 0x00000128 ***
INT_CFDATA0:        equ    $00000128                                ;*** INT_CFDATA0 - Interrupt Configuration Data Register 0; 0x00000128 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA0_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA0_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA0_PRIOLVL: equ    %00000111
mINT_CFDATA0_RQST:  equ    %10000000


;*** INT_CFDATA1 - Interrupt Configuration Data Register 1; 0x00000129 ***
INT_CFDATA1:        equ    $00000129                                ;*** INT_CFDATA1 - Interrupt Configuration Data Register 1; 0x00000129 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA1_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA1_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA1_PRIOLVL: equ    %00000111
mINT_CFDATA1_RQST:  equ    %10000000


;*** INT_CFDATA2 - Interrupt Configuration Data Register 2; 0x0000012A ***
INT_CFDATA2:        equ    $0000012A                                ;*** INT_CFDATA2 - Interrupt Configuration Data Register 2; 0x0000012A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA2_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA2_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA2_PRIOLVL: equ    %00000111
mINT_CFDATA2_RQST:  equ    %10000000


;*** INT_CFDATA3 - Interrupt Configuration Data Register 3; 0x0000012B ***
INT_CFDATA3:        equ    $0000012B                                ;*** INT_CFDATA3 - Interrupt Configuration Data Register 3; 0x0000012B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA3_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA3_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA3_PRIOLVL: equ    %00000111
mINT_CFDATA3_RQST:  equ    %10000000


;*** INT_CFDATA4 - Interrupt Configuration Data Register 4; 0x0000012C ***
INT_CFDATA4:        equ    $0000012C                                ;*** INT_CFDATA4 - Interrupt Configuration Data Register 4; 0x0000012C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA4_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA4_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA4_PRIOLVL: equ    %00000111
mINT_CFDATA4_RQST:  equ    %10000000


;*** INT_CFDATA5 - Interrupt Configuration Data Register 5; 0x0000012D ***
INT_CFDATA5:        equ    $0000012D                                ;*** INT_CFDATA5 - Interrupt Configuration Data Register 5; 0x0000012D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA5_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA5_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA5_PRIOLVL: equ    %00000111
mINT_CFDATA5_RQST:  equ    %10000000


;*** INT_CFDATA6 - Interrupt Configuration Data Register 6; 0x0000012E ***
INT_CFDATA6:        equ    $0000012E                                ;*** INT_CFDATA6 - Interrupt Configuration Data Register 6; 0x0000012E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA6_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA6_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA6_PRIOLVL: equ    %00000111
mINT_CFDATA6_RQST:  equ    %10000000


;*** INT_CFDATA7 - Interrupt Configuration Data Register 7; 0x0000012F ***
INT_CFDATA7:        equ    $0000012F                                ;*** INT_CFDATA7 - Interrupt Configuration Data Register 7; 0x0000012F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
INT_CFDATA7_PRIOLVL: equ    0                                        ; Interrupt Request Priority Level Bits
INT_CFDATA7_RQST:   equ    7                                         ; XGATE Request Enable
; bit position masks
mINT_CFDATA7_PRIOLVL: equ    %00000111
mINT_CFDATA7_RQST:  equ    %10000000


;*** SCI4BD - SCI 4 Baud Rate Register; 0x00000130 ***
SCI4BD:             equ    $00000130                                ;*** SCI4BD - SCI 4 Baud Rate Register; 0x00000130 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI4BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI4BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI4BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI4BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI4BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI4BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI4BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI4BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI4BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI4BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI4BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI4BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI4BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI4BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI4BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI4BD_SBR0:       equ    %00000001
mSCI4BD_SBR1:       equ    %00000010
mSCI4BD_SBR2:       equ    %00000100
mSCI4BD_SBR3:       equ    %00001000
mSCI4BD_SBR4:       equ    %00010000
mSCI4BD_SBR5:       equ    %00100000
mSCI4BD_SBR6:       equ    %01000000
mSCI4BD_SBR7:       equ    %10000000
mSCI4BD_SBR8:       equ    %100000000
mSCI4BD_SBR9:       equ    %1000000000
mSCI4BD_SBR10:      equ    %10000000000
mSCI4BD_SBR11:      equ    %100000000000
mSCI4BD_SBR12:      equ    %1000000000000
mSCI4BD_TNP0:       equ    %10000000000000
mSCI4BD_TNP1:       equ    %100000000000000
mSCI4BD_IREN:       equ    %1000000000000000


;*** SCI4ASR1 - SCI 4 Alternative Status Register 1; 0x00000130 ***
SCI4ASR1:           equ    $00000130                                ;*** SCI4ASR1 - SCI 4 Alternative Status Register 1; 0x00000130 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI4ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI4ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI4ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI4ASR1_BKDIF:    equ    %00000001
mSCI4ASR1_BERRIF:   equ    %00000010
mSCI4ASR1_BERRV:    equ    %00000100
mSCI4ASR1_RXEDGIF:  equ    %10000000


;*** SCI4BDH - SCI 4 Baud Rate Register High; 0x00000130 ***
SCI4BDH:            equ    $00000130                                ;*** SCI4BDH - SCI 4 Baud Rate Register High; 0x00000130 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI4BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI4BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI4BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI4BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI4BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI4BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI4BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI4BDH_SBR8:      equ    %00000001
mSCI4BDH_SBR9:      equ    %00000010
mSCI4BDH_SBR10:     equ    %00000100
mSCI4BDH_SBR11:     equ    %00001000
mSCI4BDH_SBR12:     equ    %00010000
mSCI4BDH_TNP0:      equ    %00100000
mSCI4BDH_TNP1:      equ    %01000000
mSCI4BDH_IREN:      equ    %10000000


;*** SCI4ACR1 - SCI 4 Alternative Control Register 1; 0x00000131 ***
SCI4ACR1:           equ    $00000131                                ;*** SCI4ACR1 - SCI 4 Alternative Control Register 1; 0x00000131 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI4ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI4ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI4ACR1_BKDIE:    equ    %00000001
mSCI4ACR1_BERRIE:   equ    %00000010
mSCI4ACR1_RXEDGIE:  equ    %10000000


;*** SCI4BDL - SCI 4 Baud Rate Register Low; 0x00000131 ***
SCI4BDL:            equ    $00000131                                ;*** SCI4BDL - SCI 4 Baud Rate Register Low; 0x00000131 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI4BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI4BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI4BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI4BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI4BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI4BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI4BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI4BDL_SBR0:      equ    %00000001
mSCI4BDL_SBR1:      equ    %00000010
mSCI4BDL_SBR2:      equ    %00000100
mSCI4BDL_SBR3:      equ    %00001000
mSCI4BDL_SBR4:      equ    %00010000
mSCI4BDL_SBR5:      equ    %00100000
mSCI4BDL_SBR6:      equ    %01000000
mSCI4BDL_SBR7:      equ    %10000000


;*** SCI4ACR2 - SCI 4 Alternative Control Register 2; 0x00000132 ***
SCI4ACR2:           equ    $00000132                                ;*** SCI4ACR2 - SCI 4 Alternative Control Register 2; 0x00000132 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI4ACR2_BERRM0:    equ    1                                         ; Bit Error Mode Bit 0
SCI4ACR2_BERRM1:    equ    2                                         ; Bit Error Mode Bit 1
; bit position masks
mSCI4ACR2_BKDFE:    equ    %00000001
mSCI4ACR2_BERRM0:   equ    %00000010
mSCI4ACR2_BERRM1:   equ    %00000100


;*** SCI4CR1 - SCI 4 Control Register 1; 0x00000132 ***
SCI4CR1:            equ    $00000132                                ;*** SCI4CR1 - SCI 4 Control Register 1; 0x00000132 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4CR1_PT:         equ    0                                         ; Parity Type Bit
SCI4CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI4CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI4CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI4CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI4CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI4CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI4CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI4CR1_PT:        equ    %00000001
mSCI4CR1_PE:        equ    %00000010
mSCI4CR1_ILT:       equ    %00000100
mSCI4CR1_WAKE:      equ    %00001000
mSCI4CR1_M:         equ    %00010000
mSCI4CR1_RSRC:      equ    %00100000
mSCI4CR1_SCISWAI:   equ    %01000000
mSCI4CR1_LOOPS:     equ    %10000000


;*** SCI4CR2 - SCI 4 Control Register 2; 0x00000133 ***
SCI4CR2:            equ    $00000133                                ;*** SCI4CR2 - SCI 4 Control Register 2; 0x00000133 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4CR2_SBK:        equ    0                                         ; Send Break Bit
SCI4CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI4CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI4CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI4CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI4CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI4CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI4CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI4CR2_SBK:       equ    %00000001
mSCI4CR2_RWU:       equ    %00000010
mSCI4CR2_RE:        equ    %00000100
mSCI4CR2_TE:        equ    %00001000
mSCI4CR2_ILIE:      equ    %00010000
mSCI4CR2_RIE:       equ    %00100000
mSCI4CR2_TCIE:      equ    %01000000
mSCI4CR2_TIE:       equ    %10000000


;*** SCI4SR1 - SCI 4 Status Register 1; 0x00000134 ***
SCI4SR1:            equ    $00000134                                ;*** SCI4SR1 - SCI 4 Status Register 1; 0x00000134 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4SR1_PF:         equ    0                                         ; Parity Error Flag
SCI4SR1_FE:         equ    1                                         ; Framing Error Flag
SCI4SR1_NF:         equ    2                                         ; Noise Flag
SCI4SR1_OR:         equ    3                                         ; Overrun Flag
SCI4SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI4SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI4SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI4SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI4SR1_PF:        equ    %00000001
mSCI4SR1_FE:        equ    %00000010
mSCI4SR1_NF:        equ    %00000100
mSCI4SR1_OR:        equ    %00001000
mSCI4SR1_IDLE:      equ    %00010000
mSCI4SR1_RDRF:      equ    %00100000
mSCI4SR1_TC:        equ    %01000000
mSCI4SR1_TDRE:      equ    %10000000


;*** SCI4SR2 - SCI 4 Status Register 2; 0x00000135 ***
SCI4SR2:            equ    $00000135                                ;*** SCI4SR2 - SCI 4 Status Register 2; 0x00000135 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI4SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI4SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI4SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI4SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI4SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI4SR2_RAF:       equ    %00000001
mSCI4SR2_TXDIR:     equ    %00000010
mSCI4SR2_BRK13:     equ    %00000100
mSCI4SR2_RXPOL:     equ    %00001000
mSCI4SR2_TXPOL:     equ    %00010000
mSCI4SR2_AMAP:      equ    %10000000


;*** SCI4DRH - SCI 4 Data Register High; 0x00000136 ***
SCI4DRH:            equ    $00000136                                ;*** SCI4DRH - SCI 4 Data Register High; 0x00000136 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI4DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI4DRH_T8:        equ    %01000000
mSCI4DRH_R8:        equ    %10000000


;*** SCI4DRL - SCI 4 Data Register Low; 0x00000137 ***
SCI4DRL:            equ    $00000137                                ;*** SCI4DRL - SCI 4 Data Register Low; 0x00000137 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI4DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI4DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI4DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI4DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI4DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI4DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI4DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI4DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI4DRL_R0_T0:     equ    %00000001
mSCI4DRL_R1_T1:     equ    %00000010
mSCI4DRL_R2_T2:     equ    %00000100
mSCI4DRL_R3_T3:     equ    %00001000
mSCI4DRL_R4_T4:     equ    %00010000
mSCI4DRL_R5_T5:     equ    %00100000
mSCI4DRL_R6_T6:     equ    %01000000
mSCI4DRL_R7_T7:     equ    %10000000


;*** SCI5BD - SCI 5 Baud Rate Register; 0x00000138 ***
SCI5BD:             equ    $00000138                                ;*** SCI5BD - SCI 5 Baud Rate Register; 0x00000138 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5BD_SBR0:        equ    0                                         ; SCI Baud Rate Bit 0
SCI5BD_SBR1:        equ    1                                         ; SCI Baud Rate Bit 1
SCI5BD_SBR2:        equ    2                                         ; SCI Baud Rate Bit 2
SCI5BD_SBR3:        equ    3                                         ; SCI Baud Rate Bit 3
SCI5BD_SBR4:        equ    4                                         ; SCI Baud Rate Bit 4
SCI5BD_SBR5:        equ    5                                         ; SCI Baud Rate Bit 5
SCI5BD_SBR6:        equ    6                                         ; SCI Baud Rate Bit 6
SCI5BD_SBR7:        equ    7                                         ; SCI Baud Rate Bit 7
SCI5BD_SBR8:        equ    8                                         ; SCI Baud Rate Bit 8
SCI5BD_SBR9:        equ    9                                         ; SCI Baud Rate Bit 9
SCI5BD_SBR10:       equ    10                                        ; SCI Baud Rate Bit 10
SCI5BD_SBR11:       equ    11                                        ; SCI Baud Rate Bit 11
SCI5BD_SBR12:       equ    12                                        ; SCI Baud Rate Bit 12
SCI5BD_TNP0:        equ    13                                        ; Transmitter Narrow Pulse Bit 0
SCI5BD_TNP1:        equ    14                                        ; Transmitter Narrow Pulse Bit 1
SCI5BD_IREN:        equ    15                                        ; Infrared Enable Bit
; bit position masks
mSCI5BD_SBR0:       equ    %00000001
mSCI5BD_SBR1:       equ    %00000010
mSCI5BD_SBR2:       equ    %00000100
mSCI5BD_SBR3:       equ    %00001000
mSCI5BD_SBR4:       equ    %00010000
mSCI5BD_SBR5:       equ    %00100000
mSCI5BD_SBR6:       equ    %01000000
mSCI5BD_SBR7:       equ    %10000000
mSCI5BD_SBR8:       equ    %100000000
mSCI5BD_SBR9:       equ    %1000000000
mSCI5BD_SBR10:      equ    %10000000000
mSCI5BD_SBR11:      equ    %100000000000
mSCI5BD_SBR12:      equ    %1000000000000
mSCI5BD_TNP0:       equ    %10000000000000
mSCI5BD_TNP1:       equ    %100000000000000
mSCI5BD_IREN:       equ    %1000000000000000


;*** SCI5ASR1 - SCI 5 Alternative Status Register 1; 0x00000138 ***
SCI5ASR1:           equ    $00000138                                ;*** SCI5ASR1 - SCI 5 Alternative Status Register 1; 0x00000138 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5ASR1_BKDIF:     equ    0                                         ; Break Detect Interrupt Flag
SCI5ASR1_BERRIF:    equ    1                                         ; Bit Error Interrupt Flag
SCI5ASR1_BERRV:     equ    2                                         ; Bit Error Value
SCI5ASR1_RXEDGIF:   equ    7                                         ; Receive Input Active Edge Interrupt Flag
; bit position masks
mSCI5ASR1_BKDIF:    equ    %00000001
mSCI5ASR1_BERRIF:   equ    %00000010
mSCI5ASR1_BERRV:    equ    %00000100
mSCI5ASR1_RXEDGIF:  equ    %10000000


;*** SCI5BDH - SCI 5 Baud Rate Register High; 0x00000138 ***
SCI5BDH:            equ    $00000138                                ;*** SCI5BDH - SCI 5 Baud Rate Register High; 0x00000138 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5BDH_SBR8:       equ    0                                         ; SCI Baud Rate Bit 8
SCI5BDH_SBR9:       equ    1                                         ; SCI Baud Rate Bit 9
SCI5BDH_SBR10:      equ    2                                         ; SCI Baud Rate Bit 10
SCI5BDH_SBR11:      equ    3                                         ; SCI Baud Rate Bit 11
SCI5BDH_SBR12:      equ    4                                         ; SCI Baud Rate Bit 12
SCI5BDH_TNP0:       equ    5                                         ; Transmitter Narrow Pulse Bit 0
SCI5BDH_TNP1:       equ    6                                         ; Transmitter Narrow Pulse Bit 1
SCI5BDH_IREN:       equ    7                                         ; Infrared Enable Bit
; bit position masks
mSCI5BDH_SBR8:      equ    %00000001
mSCI5BDH_SBR9:      equ    %00000010
mSCI5BDH_SBR10:     equ    %00000100
mSCI5BDH_SBR11:     equ    %00001000
mSCI5BDH_SBR12:     equ    %00010000
mSCI5BDH_TNP0:      equ    %00100000
mSCI5BDH_TNP1:      equ    %01000000
mSCI5BDH_IREN:      equ    %10000000


;*** SCI5ACR1 - SCI 5 Alternative Control Register 1; 0x00000139 ***
SCI5ACR1:           equ    $00000139                                ;*** SCI5ACR1 - SCI 5 Alternative Control Register 1; 0x00000139 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5ACR1_BKDIE:     equ    0                                         ; Break Detect Interrupt Enable
SCI5ACR1_BERRIE:    equ    1                                         ; Bit Error Interrupt Enable
SCI5ACR1_RXEDGIE:   equ    7                                         ; Receive Input Active Edge Interrupt Enable
; bit position masks
mSCI5ACR1_BKDIE:    equ    %00000001
mSCI5ACR1_BERRIE:   equ    %00000010
mSCI5ACR1_RXEDGIE:  equ    %10000000


;*** SCI5BDL - SCI 5 Baud Rate Register Low; 0x00000139 ***
SCI5BDL:            equ    $00000139                                ;*** SCI5BDL - SCI 5 Baud Rate Register Low; 0x00000139 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5BDL_SBR0:       equ    0                                         ; SCI Baud Rate Bit 0
SCI5BDL_SBR1:       equ    1                                         ; SCI Baud Rate Bit 1
SCI5BDL_SBR2:       equ    2                                         ; SCI Baud Rate Bit 2
SCI5BDL_SBR3:       equ    3                                         ; SCI Baud Rate Bit 3
SCI5BDL_SBR4:       equ    4                                         ; SCI Baud Rate Bit 4
SCI5BDL_SBR5:       equ    5                                         ; SCI Baud Rate Bit 5
SCI5BDL_SBR6:       equ    6                                         ; SCI Baud Rate Bit 6
SCI5BDL_SBR7:       equ    7                                         ; SCI Baud Rate Bit 7
; bit position masks
mSCI5BDL_SBR0:      equ    %00000001
mSCI5BDL_SBR1:      equ    %00000010
mSCI5BDL_SBR2:      equ    %00000100
mSCI5BDL_SBR3:      equ    %00001000
mSCI5BDL_SBR4:      equ    %00010000
mSCI5BDL_SBR5:      equ    %00100000
mSCI5BDL_SBR6:      equ    %01000000
mSCI5BDL_SBR7:      equ    %10000000


;*** SCI5ACR2 - SCI 5 Alternative Control Register 2; 0x0000013A ***
SCI5ACR2:           equ    $0000013A                                ;*** SCI5ACR2 - SCI 5 Alternative Control Register 2; 0x0000013A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5ACR2_BKDFE:     equ    0                                         ; Break Detect Feature Enable
SCI5ACR2_BERRM0:    equ    1                                         ; Bit Error Mode Bit 0
SCI5ACR2_BERRM1:    equ    2                                         ; Bit Error Mode Bit 1
; bit position masks
mSCI5ACR2_BKDFE:    equ    %00000001
mSCI5ACR2_BERRM0:   equ    %00000010
mSCI5ACR2_BERRM1:   equ    %00000100


;*** SCI5CR1 - SCI 5 Control Register 1; 0x0000013A ***
SCI5CR1:            equ    $0000013A                                ;*** SCI5CR1 - SCI 5 Control Register 1; 0x0000013A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5CR1_PT:         equ    0                                         ; Parity Type Bit
SCI5CR1_PE:         equ    1                                         ; Parity Enable Bit
SCI5CR1_ILT:        equ    2                                         ; Idle Line Type Bit
SCI5CR1_WAKE:       equ    3                                         ; Wakeup Condition Bit
SCI5CR1_M:          equ    4                                         ; Data Format Mode Bit
SCI5CR1_RSRC:       equ    5                                         ; Receiver Source Bit
SCI5CR1_SCISWAI:    equ    6                                         ; SCI Stop in Wait Mode Bit
SCI5CR1_LOOPS:      equ    7                                         ; Loop Select Bit
; bit position masks
mSCI5CR1_PT:        equ    %00000001
mSCI5CR1_PE:        equ    %00000010
mSCI5CR1_ILT:       equ    %00000100
mSCI5CR1_WAKE:      equ    %00001000
mSCI5CR1_M:         equ    %00010000
mSCI5CR1_RSRC:      equ    %00100000
mSCI5CR1_SCISWAI:   equ    %01000000
mSCI5CR1_LOOPS:     equ    %10000000


;*** SCI5CR2 - SCI 5 Control Register 2; 0x0000013B ***
SCI5CR2:            equ    $0000013B                                ;*** SCI5CR2 - SCI 5 Control Register 2; 0x0000013B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5CR2_SBK:        equ    0                                         ; Send Break Bit
SCI5CR2_RWU:        equ    1                                         ; Receiver Wakeup Bit
SCI5CR2_RE:         equ    2                                         ; Receiver Enable Bit
SCI5CR2_TE:         equ    3                                         ; Transmitter Enable Bit
SCI5CR2_ILIE:       equ    4                                         ; Idle Line Interrupt Enable Bit
SCI5CR2_RIE:        equ    5                                         ; Receiver Full Interrupt Enable Bit
SCI5CR2_TCIE:       equ    6                                         ; Transmission Complete Interrupt Enable Bit
SCI5CR2_TIE:        equ    7                                         ; Transmitter Interrupt Enable Bit
; bit position masks
mSCI5CR2_SBK:       equ    %00000001
mSCI5CR2_RWU:       equ    %00000010
mSCI5CR2_RE:        equ    %00000100
mSCI5CR2_TE:        equ    %00001000
mSCI5CR2_ILIE:      equ    %00010000
mSCI5CR2_RIE:       equ    %00100000
mSCI5CR2_TCIE:      equ    %01000000
mSCI5CR2_TIE:       equ    %10000000


;*** SCI5SR1 - SCI 5 Status Register 1; 0x0000013C ***
SCI5SR1:            equ    $0000013C                                ;*** SCI5SR1 - SCI 5 Status Register 1; 0x0000013C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5SR1_PF:         equ    0                                         ; Parity Error Flag
SCI5SR1_FE:         equ    1                                         ; Framing Error Flag
SCI5SR1_NF:         equ    2                                         ; Noise Flag
SCI5SR1_OR:         equ    3                                         ; Overrun Flag
SCI5SR1_IDLE:       equ    4                                         ; Idle Line Flag
SCI5SR1_RDRF:       equ    5                                         ; Receive Data Register Full Flag
SCI5SR1_TC:         equ    6                                         ; Transmit Complete Flag
SCI5SR1_TDRE:       equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCI5SR1_PF:        equ    %00000001
mSCI5SR1_FE:        equ    %00000010
mSCI5SR1_NF:        equ    %00000100
mSCI5SR1_OR:        equ    %00001000
mSCI5SR1_IDLE:      equ    %00010000
mSCI5SR1_RDRF:      equ    %00100000
mSCI5SR1_TC:        equ    %01000000
mSCI5SR1_TDRE:      equ    %10000000


;*** SCI5SR2 - SCI 5 Status Register 2; 0x0000013D ***
SCI5SR2:            equ    $0000013D                                ;*** SCI5SR2 - SCI 5 Status Register 2; 0x0000013D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5SR2_RAF:        equ    0                                         ; Receiver Active Flag
SCI5SR2_TXDIR:      equ    1                                         ; Transmitter pin data direction in Single-Wire mode
SCI5SR2_BRK13:      equ    2                                         ; Break Transmit character length
SCI5SR2_RXPOL:      equ    3                                         ; Receive Polarity
SCI5SR2_TXPOL:      equ    4                                         ; Transmit Polarity
SCI5SR2_AMAP:       equ    7                                         ; Alternative Map
; bit position masks
mSCI5SR2_RAF:       equ    %00000001
mSCI5SR2_TXDIR:     equ    %00000010
mSCI5SR2_BRK13:     equ    %00000100
mSCI5SR2_RXPOL:     equ    %00001000
mSCI5SR2_TXPOL:     equ    %00010000
mSCI5SR2_AMAP:      equ    %10000000


;*** SCI5DRH - SCI 5 Data Register High; 0x0000013E ***
SCI5DRH:            equ    $0000013E                                ;*** SCI5DRH - SCI 5 Data Register High; 0x0000013E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5DRH_T8:         equ    6                                         ; Transmit Bit 8
SCI5DRH_R8:         equ    7                                         ; Received Bit 8
; bit position masks
mSCI5DRH_T8:        equ    %01000000
mSCI5DRH_R8:        equ    %10000000


;*** SCI5DRL - SCI 5 Data Register Low; 0x0000013F ***
SCI5DRL:            equ    $0000013F                                ;*** SCI5DRL - SCI 5 Data Register Low; 0x0000013F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCI5DRL_R0_T0:      equ    0                                         ; Received bit 0 or Transmit bit 0
SCI5DRL_R1_T1:      equ    1                                         ; Received bit 1 or Transmit bit 1
SCI5DRL_R2_T2:      equ    2                                         ; Received bit 2 or Transmit bit 2
SCI5DRL_R3_T3:      equ    3                                         ; Received bit 3 or Transmit bit 3
SCI5DRL_R4_T4:      equ    4                                         ; Received bit 4 or Transmit bit 4
SCI5DRL_R5_T5:      equ    5                                         ; Received bit 5 or Transmit bit 5
SCI5DRL_R6_T6:      equ    6                                         ; Received bit 6 or Transmit bit 6
SCI5DRL_R7_T7:      equ    7                                         ; Received bit 7 or Transmit bit 7
; bit position masks
mSCI5DRL_R0_T0:     equ    %00000001
mSCI5DRL_R1_T1:     equ    %00000010
mSCI5DRL_R2_T2:     equ    %00000100
mSCI5DRL_R3_T3:     equ    %00001000
mSCI5DRL_R4_T4:     equ    %00010000
mSCI5DRL_R5_T5:     equ    %00100000
mSCI5DRL_R6_T6:     equ    %01000000
mSCI5DRL_R7_T7:     equ    %10000000


;*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***
CAN0CTL0:           equ    $00000140                                ;*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN0CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN0CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN0CTL0_TIME:      equ    3                                         ; Timer Enable
CAN0CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN0CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN0CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN0CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN0CTL0_INITRQ:   equ    %00000001
mCAN0CTL0_SLPRQ:    equ    %00000010
mCAN0CTL0_WUPE:     equ    %00000100
mCAN0CTL0_TIME:     equ    %00001000
mCAN0CTL0_SYNCH:    equ    %00010000
mCAN0CTL0_CSWAI:    equ    %00100000
mCAN0CTL0_RXACT:    equ    %01000000
mCAN0CTL0_RXFRM:    equ    %10000000


;*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***
CAN0CTL1:           equ    $00000141                                ;*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN0CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN0CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN0CTL1_BORM:      equ    3                                         ; Bus-Off Recovery Mode
CAN0CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN0CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN0CTL1_CLKSRC:    equ    6                                         ; MSCAN 0 Clock Source
CAN0CTL1_CANE:      equ    7                                         ; MSCAN 0 Enable
; bit position masks
mCAN0CTL1_INITAK:   equ    %00000001
mCAN0CTL1_SLPAK:    equ    %00000010
mCAN0CTL1_WUPM:     equ    %00000100
mCAN0CTL1_BORM:     equ    %00001000
mCAN0CTL1_LISTEN:   equ    %00010000
mCAN0CTL1_LOOPB:    equ    %00100000
mCAN0CTL1_CLKSRC:   equ    %01000000
mCAN0CTL1_CANE:     equ    %10000000


;*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***
CAN0BTR0:           equ    $00000142                                ;*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN0BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN0BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN0BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN0BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN0BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN0BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN0BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN0BTR0_BRP0:     equ    %00000001
mCAN0BTR0_BRP1:     equ    %00000010
mCAN0BTR0_BRP2:     equ    %00000100
mCAN0BTR0_BRP3:     equ    %00001000
mCAN0BTR0_BRP4:     equ    %00010000
mCAN0BTR0_BRP5:     equ    %00100000
mCAN0BTR0_SJW0:     equ    %01000000
mCAN0BTR0_SJW1:     equ    %10000000


;*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***
CAN0BTR1:           equ    $00000143                                ;*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN0BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN0BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN0BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN0BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN0BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN0BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN0BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN0BTR1_TSEG10:   equ    %00000001
mCAN0BTR1_TSEG11:   equ    %00000010
mCAN0BTR1_TSEG12:   equ    %00000100
mCAN0BTR1_TSEG13:   equ    %00001000
mCAN0BTR1_TSEG20:   equ    %00010000
mCAN0BTR1_TSEG21:   equ    %00100000
mCAN0BTR1_TSEG22:   equ    %01000000
mCAN0BTR1_SAMP:     equ    %10000000


;*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***
CAN0RFLG:           equ    $00000144                                ;*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN0RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN0RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN0RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN0RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN0RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN0RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN0RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN0RFLG_RXF:      equ    %00000001
mCAN0RFLG_OVRIF:    equ    %00000010
mCAN0RFLG_TSTAT0:   equ    %00000100
mCAN0RFLG_TSTAT1:   equ    %00001000
mCAN0RFLG_RSTAT0:   equ    %00010000
mCAN0RFLG_RSTAT1:   equ    %00100000
mCAN0RFLG_CSCIF:    equ    %01000000
mCAN0RFLG_WUPIF:    equ    %10000000


;*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***
CAN0RIER:           equ    $00000145                                ;*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN0RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN0RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN0RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN0RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN0RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN0RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN0RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN0RIER_RXFIE:    equ    %00000001
mCAN0RIER_OVRIE:    equ    %00000010
mCAN0RIER_TSTATE0:  equ    %00000100
mCAN0RIER_TSTATE1:  equ    %00001000
mCAN0RIER_RSTATE0:  equ    %00010000
mCAN0RIER_RSTATE1:  equ    %00100000
mCAN0RIER_CSCIE:    equ    %01000000
mCAN0RIER_WUPIE:    equ    %10000000


;*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***
CAN0TFLG:           equ    $00000146                                ;*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN0TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN0TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN0TFLG_TXE0:     equ    %00000001
mCAN0TFLG_TXE1:     equ    %00000010
mCAN0TFLG_TXE2:     equ    %00000100


;*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***
CAN0TIER:           equ    $00000147                                ;*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN0TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN0TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN0TIER_TXEIE0:   equ    %00000001
mCAN0TIER_TXEIE1:   equ    %00000010
mCAN0TIER_TXEIE2:   equ    %00000100


;*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***
CAN0TARQ:           equ    $00000148                                ;*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN0TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN0TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN0TARQ_ABTRQ0:   equ    %00000001
mCAN0TARQ_ABTRQ1:   equ    %00000010
mCAN0TARQ_ABTRQ2:   equ    %00000100


;*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***
CAN0TAAK:           equ    $00000149                                ;*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN0TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN0TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN0TAAK_ABTAK0:   equ    %00000001
mCAN0TAAK_ABTAK1:   equ    %00000010
mCAN0TAAK_ABTAK2:   equ    %00000100


;*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***
CAN0TBSEL:          equ    $0000014A                                ;*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN0TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN0TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN0TBSEL_TX0:     equ    %00000001
mCAN0TBSEL_TX1:     equ    %00000010
mCAN0TBSEL_TX2:     equ    %00000100


;*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***
CAN0IDAC:           equ    $0000014B                                ;*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN0IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN0IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN0IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN0IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN0IDAC_IDHIT0:   equ    %00000001
mCAN0IDAC_IDHIT1:   equ    %00000010
mCAN0IDAC_IDHIT2:   equ    %00000100
mCAN0IDAC_IDAM0:    equ    %00010000
mCAN0IDAC_IDAM1:    equ    %00100000


;*** CAN0MISC - MSCAN 0 Miscellaneous Register; 0x0000014D ***
CAN0MISC:           equ    $0000014D                                ;*** CAN0MISC - MSCAN 0 Miscellaneous Register; 0x0000014D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0MISC_BOHOLD:    equ    0                                         ; Bus-Off state Hold until user request
; bit position masks
mCAN0MISC_BOHOLD:   equ    %00000001


;*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***
CAN0RXERR:          equ    $0000014E                                ;*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN0RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN0RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN0RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN0RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN0RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN0RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN0RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0RXERR_RXERR0:  equ    %00000001
mCAN0RXERR_RXERR1:  equ    %00000010
mCAN0RXERR_RXERR2:  equ    %00000100
mCAN0RXERR_RXERR3:  equ    %00001000
mCAN0RXERR_RXERR4:  equ    %00010000
mCAN0RXERR_RXERR5:  equ    %00100000
mCAN0RXERR_RXERR6:  equ    %01000000
mCAN0RXERR_RXERR7:  equ    %10000000


;*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***
CAN0TXERR:          equ    $0000014F                                ;*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN0TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN0TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN0TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN0TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN0TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN0TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN0TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN0TXERR_TXERR0:  equ    %00000001
mCAN0TXERR_TXERR1:  equ    %00000010
mCAN0TXERR_TXERR2:  equ    %00000100
mCAN0TXERR_TXERR3:  equ    %00001000
mCAN0TXERR_TXERR4:  equ    %00010000
mCAN0TXERR_TXERR5:  equ    %00100000
mCAN0TXERR_TXERR6:  equ    %01000000
mCAN0TXERR_TXERR7:  equ    %10000000


;*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***
CAN0IDAR0:          equ    $00000150                                ;*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR0_AC0:     equ    %00000001
mCAN0IDAR0_AC1:     equ    %00000010
mCAN0IDAR0_AC2:     equ    %00000100
mCAN0IDAR0_AC3:     equ    %00001000
mCAN0IDAR0_AC4:     equ    %00010000
mCAN0IDAR0_AC5:     equ    %00100000
mCAN0IDAR0_AC6:     equ    %01000000
mCAN0IDAR0_AC7:     equ    %10000000


;*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***
CAN0IDAR1:          equ    $00000151                                ;*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR1_AC0:     equ    %00000001
mCAN0IDAR1_AC1:     equ    %00000010
mCAN0IDAR1_AC2:     equ    %00000100
mCAN0IDAR1_AC3:     equ    %00001000
mCAN0IDAR1_AC4:     equ    %00010000
mCAN0IDAR1_AC5:     equ    %00100000
mCAN0IDAR1_AC6:     equ    %01000000
mCAN0IDAR1_AC7:     equ    %10000000


;*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***
CAN0IDAR2:          equ    $00000152                                ;*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR2_AC0:     equ    %00000001
mCAN0IDAR2_AC1:     equ    %00000010
mCAN0IDAR2_AC2:     equ    %00000100
mCAN0IDAR2_AC3:     equ    %00001000
mCAN0IDAR2_AC4:     equ    %00010000
mCAN0IDAR2_AC5:     equ    %00100000
mCAN0IDAR2_AC6:     equ    %01000000
mCAN0IDAR2_AC7:     equ    %10000000


;*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***
CAN0IDAR3:          equ    $00000153                                ;*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR3_AC0:     equ    %00000001
mCAN0IDAR3_AC1:     equ    %00000010
mCAN0IDAR3_AC2:     equ    %00000100
mCAN0IDAR3_AC3:     equ    %00001000
mCAN0IDAR3_AC4:     equ    %00010000
mCAN0IDAR3_AC5:     equ    %00100000
mCAN0IDAR3_AC6:     equ    %01000000
mCAN0IDAR3_AC7:     equ    %10000000


;*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***
CAN0IDMR0:          equ    $00000154                                ;*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR0_AM0:     equ    %00000001
mCAN0IDMR0_AM1:     equ    %00000010
mCAN0IDMR0_AM2:     equ    %00000100
mCAN0IDMR0_AM3:     equ    %00001000
mCAN0IDMR0_AM4:     equ    %00010000
mCAN0IDMR0_AM5:     equ    %00100000
mCAN0IDMR0_AM6:     equ    %01000000
mCAN0IDMR0_AM7:     equ    %10000000


;*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***
CAN0IDMR1:          equ    $00000155                                ;*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR1_AM0:     equ    %00000001
mCAN0IDMR1_AM1:     equ    %00000010
mCAN0IDMR1_AM2:     equ    %00000100
mCAN0IDMR1_AM3:     equ    %00001000
mCAN0IDMR1_AM4:     equ    %00010000
mCAN0IDMR1_AM5:     equ    %00100000
mCAN0IDMR1_AM6:     equ    %01000000
mCAN0IDMR1_AM7:     equ    %10000000


;*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***
CAN0IDMR2:          equ    $00000156                                ;*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR2_AM0:     equ    %00000001
mCAN0IDMR2_AM1:     equ    %00000010
mCAN0IDMR2_AM2:     equ    %00000100
mCAN0IDMR2_AM3:     equ    %00001000
mCAN0IDMR2_AM4:     equ    %00010000
mCAN0IDMR2_AM5:     equ    %00100000
mCAN0IDMR2_AM6:     equ    %01000000
mCAN0IDMR2_AM7:     equ    %10000000


;*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***
CAN0IDMR3:          equ    $00000157                                ;*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR3_AM0:     equ    %00000001
mCAN0IDMR3_AM1:     equ    %00000010
mCAN0IDMR3_AM2:     equ    %00000100
mCAN0IDMR3_AM3:     equ    %00001000
mCAN0IDMR3_AM4:     equ    %00010000
mCAN0IDMR3_AM5:     equ    %00100000
mCAN0IDMR3_AM6:     equ    %01000000
mCAN0IDMR3_AM7:     equ    %10000000


;*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***
CAN0IDAR4:          equ    $00000158                                ;*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR4_AC0:     equ    %00000001
mCAN0IDAR4_AC1:     equ    %00000010
mCAN0IDAR4_AC2:     equ    %00000100
mCAN0IDAR4_AC3:     equ    %00001000
mCAN0IDAR4_AC4:     equ    %00010000
mCAN0IDAR4_AC5:     equ    %00100000
mCAN0IDAR4_AC6:     equ    %01000000
mCAN0IDAR4_AC7:     equ    %10000000


;*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***
CAN0IDAR5:          equ    $00000159                                ;*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR5_AC0:     equ    %00000001
mCAN0IDAR5_AC1:     equ    %00000010
mCAN0IDAR5_AC2:     equ    %00000100
mCAN0IDAR5_AC3:     equ    %00001000
mCAN0IDAR5_AC4:     equ    %00010000
mCAN0IDAR5_AC5:     equ    %00100000
mCAN0IDAR5_AC6:     equ    %01000000
mCAN0IDAR5_AC7:     equ    %10000000


;*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***
CAN0IDAR6:          equ    $0000015A                                ;*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR6_AC0:     equ    %00000001
mCAN0IDAR6_AC1:     equ    %00000010
mCAN0IDAR6_AC2:     equ    %00000100
mCAN0IDAR6_AC3:     equ    %00001000
mCAN0IDAR6_AC4:     equ    %00010000
mCAN0IDAR6_AC5:     equ    %00100000
mCAN0IDAR6_AC6:     equ    %01000000
mCAN0IDAR6_AC7:     equ    %10000000


;*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***
CAN0IDAR7:          equ    $0000015B                                ;*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN0IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN0IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN0IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN0IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN0IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN0IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN0IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN0IDAR7_AC0:     equ    %00000001
mCAN0IDAR7_AC1:     equ    %00000010
mCAN0IDAR7_AC2:     equ    %00000100
mCAN0IDAR7_AC3:     equ    %00001000
mCAN0IDAR7_AC4:     equ    %00010000
mCAN0IDAR7_AC5:     equ    %00100000
mCAN0IDAR7_AC6:     equ    %01000000
mCAN0IDAR7_AC7:     equ    %10000000


;*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***
CAN0IDMR4:          equ    $0000015C                                ;*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR4_AM0:     equ    %00000001
mCAN0IDMR4_AM1:     equ    %00000010
mCAN0IDMR4_AM2:     equ    %00000100
mCAN0IDMR4_AM3:     equ    %00001000
mCAN0IDMR4_AM4:     equ    %00010000
mCAN0IDMR4_AM5:     equ    %00100000
mCAN0IDMR4_AM6:     equ    %01000000
mCAN0IDMR4_AM7:     equ    %10000000


;*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***
CAN0IDMR5:          equ    $0000015D                                ;*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR5_AM0:     equ    %00000001
mCAN0IDMR5_AM1:     equ    %00000010
mCAN0IDMR5_AM2:     equ    %00000100
mCAN0IDMR5_AM3:     equ    %00001000
mCAN0IDMR5_AM4:     equ    %00010000
mCAN0IDMR5_AM5:     equ    %00100000
mCAN0IDMR5_AM6:     equ    %01000000
mCAN0IDMR5_AM7:     equ    %10000000


;*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***
CAN0IDMR6:          equ    $0000015E                                ;*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR6_AM0:     equ    %00000001
mCAN0IDMR6_AM1:     equ    %00000010
mCAN0IDMR6_AM2:     equ    %00000100
mCAN0IDMR6_AM3:     equ    %00001000
mCAN0IDMR6_AM4:     equ    %00010000
mCAN0IDMR6_AM5:     equ    %00100000
mCAN0IDMR6_AM6:     equ    %01000000
mCAN0IDMR6_AM7:     equ    %10000000


;*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***
CAN0IDMR7:          equ    $0000015F                                ;*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN0IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN0IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN0IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN0IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN0IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN0IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN0IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN0IDMR7_AM0:     equ    %00000001
mCAN0IDMR7_AM1:     equ    %00000010
mCAN0IDMR7_AM2:     equ    %00000100
mCAN0IDMR7_AM3:     equ    %00001000
mCAN0IDMR7_AM4:     equ    %00010000
mCAN0IDMR7_AM5:     equ    %00100000
mCAN0IDMR7_AM6:     equ    %01000000
mCAN0IDMR7_AM7:     equ    %10000000


;*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***
CAN0RXIDR0:         equ    $00000160                                ;*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0RXIDR0_ID21:   equ    %00000001
mCAN0RXIDR0_ID22:   equ    %00000010
mCAN0RXIDR0_ID23:   equ    %00000100
mCAN0RXIDR0_ID24:   equ    %00001000
mCAN0RXIDR0_ID25:   equ    %00010000
mCAN0RXIDR0_ID26:   equ    %00100000
mCAN0RXIDR0_ID27:   equ    %01000000
mCAN0RXIDR0_ID28:   equ    %10000000


;*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***
CAN0RXIDR1:         equ    $00000161                                ;*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0RXIDR1_ID15:   equ    %00000001
mCAN0RXIDR1_ID16:   equ    %00000010
mCAN0RXIDR1_ID17:   equ    %00000100
mCAN0RXIDR1_IDE:    equ    %00001000
mCAN0RXIDR1_SRR:    equ    %00010000
mCAN0RXIDR1_ID18:   equ    %00100000
mCAN0RXIDR1_ID19:   equ    %01000000
mCAN0RXIDR1_ID20:   equ    %10000000


;*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***
CAN0RXIDR2:         equ    $00000162                                ;*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0RXIDR2_ID7:    equ    %00000001
mCAN0RXIDR2_ID8:    equ    %00000010
mCAN0RXIDR2_ID9:    equ    %00000100
mCAN0RXIDR2_ID10:   equ    %00001000
mCAN0RXIDR2_ID11:   equ    %00010000
mCAN0RXIDR2_ID12:   equ    %00100000
mCAN0RXIDR2_ID13:   equ    %01000000
mCAN0RXIDR2_ID14:   equ    %10000000


;*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***
CAN0RXIDR3:         equ    $00000163                                ;*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0RXIDR3_RTR:    equ    %00000001
mCAN0RXIDR3_ID0:    equ    %00000010
mCAN0RXIDR3_ID1:    equ    %00000100
mCAN0RXIDR3_ID2:    equ    %00001000
mCAN0RXIDR3_ID3:    equ    %00010000
mCAN0RXIDR3_ID4:    equ    %00100000
mCAN0RXIDR3_ID5:    equ    %01000000
mCAN0RXIDR3_ID6:    equ    %10000000


;*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***
CAN0RXDSR0:         equ    $00000164                                ;*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR0_DB0:    equ    %00000001
mCAN0RXDSR0_DB1:    equ    %00000010
mCAN0RXDSR0_DB2:    equ    %00000100
mCAN0RXDSR0_DB3:    equ    %00001000
mCAN0RXDSR0_DB4:    equ    %00010000
mCAN0RXDSR0_DB5:    equ    %00100000
mCAN0RXDSR0_DB6:    equ    %01000000
mCAN0RXDSR0_DB7:    equ    %10000000


;*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***
CAN0RXDSR1:         equ    $00000165                                ;*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR1_DB0:    equ    %00000001
mCAN0RXDSR1_DB1:    equ    %00000010
mCAN0RXDSR1_DB2:    equ    %00000100
mCAN0RXDSR1_DB3:    equ    %00001000
mCAN0RXDSR1_DB4:    equ    %00010000
mCAN0RXDSR1_DB5:    equ    %00100000
mCAN0RXDSR1_DB6:    equ    %01000000
mCAN0RXDSR1_DB7:    equ    %10000000


;*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***
CAN0RXDSR2:         equ    $00000166                                ;*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR2_DB0:    equ    %00000001
mCAN0RXDSR2_DB1:    equ    %00000010
mCAN0RXDSR2_DB2:    equ    %00000100
mCAN0RXDSR2_DB3:    equ    %00001000
mCAN0RXDSR2_DB4:    equ    %00010000
mCAN0RXDSR2_DB5:    equ    %00100000
mCAN0RXDSR2_DB6:    equ    %01000000
mCAN0RXDSR2_DB7:    equ    %10000000


;*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***
CAN0RXDSR3:         equ    $00000167                                ;*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR3_DB0:    equ    %00000001
mCAN0RXDSR3_DB1:    equ    %00000010
mCAN0RXDSR3_DB2:    equ    %00000100
mCAN0RXDSR3_DB3:    equ    %00001000
mCAN0RXDSR3_DB4:    equ    %00010000
mCAN0RXDSR3_DB5:    equ    %00100000
mCAN0RXDSR3_DB6:    equ    %01000000
mCAN0RXDSR3_DB7:    equ    %10000000


;*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***
CAN0RXDSR4:         equ    $00000168                                ;*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR4_DB0:    equ    %00000001
mCAN0RXDSR4_DB1:    equ    %00000010
mCAN0RXDSR4_DB2:    equ    %00000100
mCAN0RXDSR4_DB3:    equ    %00001000
mCAN0RXDSR4_DB4:    equ    %00010000
mCAN0RXDSR4_DB5:    equ    %00100000
mCAN0RXDSR4_DB6:    equ    %01000000
mCAN0RXDSR4_DB7:    equ    %10000000


;*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***
CAN0RXDSR5:         equ    $00000169                                ;*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR5_DB0:    equ    %00000001
mCAN0RXDSR5_DB1:    equ    %00000010
mCAN0RXDSR5_DB2:    equ    %00000100
mCAN0RXDSR5_DB3:    equ    %00001000
mCAN0RXDSR5_DB4:    equ    %00010000
mCAN0RXDSR5_DB5:    equ    %00100000
mCAN0RXDSR5_DB6:    equ    %01000000
mCAN0RXDSR5_DB7:    equ    %10000000


;*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***
CAN0RXDSR6:         equ    $0000016A                                ;*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR6_DB0:    equ    %00000001
mCAN0RXDSR6_DB1:    equ    %00000010
mCAN0RXDSR6_DB2:    equ    %00000100
mCAN0RXDSR6_DB3:    equ    %00001000
mCAN0RXDSR6_DB4:    equ    %00010000
mCAN0RXDSR6_DB5:    equ    %00100000
mCAN0RXDSR6_DB6:    equ    %01000000
mCAN0RXDSR6_DB7:    equ    %10000000


;*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***
CAN0RXDSR7:         equ    $0000016B                                ;*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0RXDSR7_DB0:    equ    %00000001
mCAN0RXDSR7_DB1:    equ    %00000010
mCAN0RXDSR7_DB2:    equ    %00000100
mCAN0RXDSR7_DB3:    equ    %00001000
mCAN0RXDSR7_DB4:    equ    %00010000
mCAN0RXDSR7_DB5:    equ    %00100000
mCAN0RXDSR7_DB6:    equ    %01000000
mCAN0RXDSR7_DB7:    equ    %10000000


;*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***
CAN0RXDLR:          equ    $0000016C                                ;*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0RXDLR_DLC0:    equ    %00000001
mCAN0RXDLR_DLC1:    equ    %00000010
mCAN0RXDLR_DLC2:    equ    %00000100
mCAN0RXDLR_DLC3:    equ    %00001000


;*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***
CAN0RXTSR:          equ    $0000016E                                ;*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSR_TSR0:    equ    %00000001
mCAN0RXTSR_TSR1:    equ    %00000010
mCAN0RXTSR_TSR2:    equ    %00000100
mCAN0RXTSR_TSR3:    equ    %00001000
mCAN0RXTSR_TSR4:    equ    %00010000
mCAN0RXTSR_TSR5:    equ    %00100000
mCAN0RXTSR_TSR6:    equ    %01000000
mCAN0RXTSR_TSR7:    equ    %10000000
mCAN0RXTSR_TSR8:    equ    %100000000
mCAN0RXTSR_TSR9:    equ    %1000000000
mCAN0RXTSR_TSR10:   equ    %10000000000
mCAN0RXTSR_TSR11:   equ    %100000000000
mCAN0RXTSR_TSR12:   equ    %1000000000000
mCAN0RXTSR_TSR13:   equ    %10000000000000
mCAN0RXTSR_TSR14:   equ    %100000000000000
mCAN0RXTSR_TSR15:   equ    %1000000000000000


;*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***
CAN0RXTSRH:         equ    $0000016E                                ;*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0RXTSRH_TSR8:   equ    %00000001
mCAN0RXTSRH_TSR9:   equ    %00000010
mCAN0RXTSRH_TSR10:  equ    %00000100
mCAN0RXTSRH_TSR11:  equ    %00001000
mCAN0RXTSRH_TSR12:  equ    %00010000
mCAN0RXTSRH_TSR13:  equ    %00100000
mCAN0RXTSRH_TSR14:  equ    %01000000
mCAN0RXTSRH_TSR15:  equ    %10000000


;*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***
CAN0RXTSRL:         equ    $0000016F                                ;*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0RXTSRL_TSR0:   equ    %00000001
mCAN0RXTSRL_TSR1:   equ    %00000010
mCAN0RXTSRL_TSR2:   equ    %00000100
mCAN0RXTSRL_TSR3:   equ    %00001000
mCAN0RXTSRL_TSR4:   equ    %00010000
mCAN0RXTSRL_TSR5:   equ    %00100000
mCAN0RXTSRL_TSR6:   equ    %01000000
mCAN0RXTSRL_TSR7:   equ    %10000000


;*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***
CAN0TXIDR0:         equ    $00000170                                ;*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN0TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN0TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN0TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN0TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN0TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN0TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN0TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN0TXIDR0_ID21:   equ    %00000001
mCAN0TXIDR0_ID22:   equ    %00000010
mCAN0TXIDR0_ID23:   equ    %00000100
mCAN0TXIDR0_ID24:   equ    %00001000
mCAN0TXIDR0_ID25:   equ    %00010000
mCAN0TXIDR0_ID26:   equ    %00100000
mCAN0TXIDR0_ID27:   equ    %01000000
mCAN0TXIDR0_ID28:   equ    %10000000


;*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***
CAN0TXIDR1:         equ    $00000171                                ;*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN0TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN0TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN0TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN0TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN0TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN0TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN0TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN0TXIDR1_ID15:   equ    %00000001
mCAN0TXIDR1_ID16:   equ    %00000010
mCAN0TXIDR1_ID17:   equ    %00000100
mCAN0TXIDR1_IDE:    equ    %00001000
mCAN0TXIDR1_SRR:    equ    %00010000
mCAN0TXIDR1_ID18:   equ    %00100000
mCAN0TXIDR1_ID19:   equ    %01000000
mCAN0TXIDR1_ID20:   equ    %10000000


;*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***
CAN0TXIDR2:         equ    $00000172                                ;*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN0TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN0TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN0TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN0TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN0TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN0TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN0TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN0TXIDR2_ID7:    equ    %00000001
mCAN0TXIDR2_ID8:    equ    %00000010
mCAN0TXIDR2_ID9:    equ    %00000100
mCAN0TXIDR2_ID10:   equ    %00001000
mCAN0TXIDR2_ID11:   equ    %00010000
mCAN0TXIDR2_ID12:   equ    %00100000
mCAN0TXIDR2_ID13:   equ    %01000000
mCAN0TXIDR2_ID14:   equ    %10000000


;*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***
CAN0TXIDR3:         equ    $00000173                                ;*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN0TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN0TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN0TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN0TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN0TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN0TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN0TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN0TXIDR3_RTR:    equ    %00000001
mCAN0TXIDR3_ID0:    equ    %00000010
mCAN0TXIDR3_ID1:    equ    %00000100
mCAN0TXIDR3_ID2:    equ    %00001000
mCAN0TXIDR3_ID3:    equ    %00010000
mCAN0TXIDR3_ID4:    equ    %00100000
mCAN0TXIDR3_ID5:    equ    %01000000
mCAN0TXIDR3_ID6:    equ    %10000000


;*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***
CAN0TXDSR0:         equ    $00000174                                ;*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR0_DB0:    equ    %00000001
mCAN0TXDSR0_DB1:    equ    %00000010
mCAN0TXDSR0_DB2:    equ    %00000100
mCAN0TXDSR0_DB3:    equ    %00001000
mCAN0TXDSR0_DB4:    equ    %00010000
mCAN0TXDSR0_DB5:    equ    %00100000
mCAN0TXDSR0_DB6:    equ    %01000000
mCAN0TXDSR0_DB7:    equ    %10000000


;*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***
CAN0TXDSR1:         equ    $00000175                                ;*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR1_DB0:    equ    %00000001
mCAN0TXDSR1_DB1:    equ    %00000010
mCAN0TXDSR1_DB2:    equ    %00000100
mCAN0TXDSR1_DB3:    equ    %00001000
mCAN0TXDSR1_DB4:    equ    %00010000
mCAN0TXDSR1_DB5:    equ    %00100000
mCAN0TXDSR1_DB6:    equ    %01000000
mCAN0TXDSR1_DB7:    equ    %10000000


;*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***
CAN0TXDSR2:         equ    $00000176                                ;*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR2_DB0:    equ    %00000001
mCAN0TXDSR2_DB1:    equ    %00000010
mCAN0TXDSR2_DB2:    equ    %00000100
mCAN0TXDSR2_DB3:    equ    %00001000
mCAN0TXDSR2_DB4:    equ    %00010000
mCAN0TXDSR2_DB5:    equ    %00100000
mCAN0TXDSR2_DB6:    equ    %01000000
mCAN0TXDSR2_DB7:    equ    %10000000


;*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***
CAN0TXDSR3:         equ    $00000177                                ;*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR3_DB0:    equ    %00000001
mCAN0TXDSR3_DB1:    equ    %00000010
mCAN0TXDSR3_DB2:    equ    %00000100
mCAN0TXDSR3_DB3:    equ    %00001000
mCAN0TXDSR3_DB4:    equ    %00010000
mCAN0TXDSR3_DB5:    equ    %00100000
mCAN0TXDSR3_DB6:    equ    %01000000
mCAN0TXDSR3_DB7:    equ    %10000000


;*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***
CAN0TXDSR4:         equ    $00000178                                ;*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR4_DB0:    equ    %00000001
mCAN0TXDSR4_DB1:    equ    %00000010
mCAN0TXDSR4_DB2:    equ    %00000100
mCAN0TXDSR4_DB3:    equ    %00001000
mCAN0TXDSR4_DB4:    equ    %00010000
mCAN0TXDSR4_DB5:    equ    %00100000
mCAN0TXDSR4_DB6:    equ    %01000000
mCAN0TXDSR4_DB7:    equ    %10000000


;*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***
CAN0TXDSR5:         equ    $00000179                                ;*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR5_DB0:    equ    %00000001
mCAN0TXDSR5_DB1:    equ    %00000010
mCAN0TXDSR5_DB2:    equ    %00000100
mCAN0TXDSR5_DB3:    equ    %00001000
mCAN0TXDSR5_DB4:    equ    %00010000
mCAN0TXDSR5_DB5:    equ    %00100000
mCAN0TXDSR5_DB6:    equ    %01000000
mCAN0TXDSR5_DB7:    equ    %10000000


;*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***
CAN0TXDSR6:         equ    $0000017A                                ;*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR6_DB0:    equ    %00000001
mCAN0TXDSR6_DB1:    equ    %00000010
mCAN0TXDSR6_DB2:    equ    %00000100
mCAN0TXDSR6_DB3:    equ    %00001000
mCAN0TXDSR6_DB4:    equ    %00010000
mCAN0TXDSR6_DB5:    equ    %00100000
mCAN0TXDSR6_DB6:    equ    %01000000
mCAN0TXDSR6_DB7:    equ    %10000000


;*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***
CAN0TXDSR7:         equ    $0000017B                                ;*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN0TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN0TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN0TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN0TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN0TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN0TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN0TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN0TXDSR7_DB0:    equ    %00000001
mCAN0TXDSR7_DB1:    equ    %00000010
mCAN0TXDSR7_DB2:    equ    %00000100
mCAN0TXDSR7_DB3:    equ    %00001000
mCAN0TXDSR7_DB4:    equ    %00010000
mCAN0TXDSR7_DB5:    equ    %00100000
mCAN0TXDSR7_DB6:    equ    %01000000
mCAN0TXDSR7_DB7:    equ    %10000000


;*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***
CAN0TXDLR:          equ    $0000017C                                ;*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN0TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN0TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN0TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN0TXDLR_DLC0:    equ    %00000001
mCAN0TXDLR_DLC1:    equ    %00000010
mCAN0TXDLR_DLC2:    equ    %00000100
mCAN0TXDLR_DLC3:    equ    %00001000


;*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***
CAN0TXTBPR:         equ    $0000017D                                ;*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN0TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN0TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN0TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN0TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN0TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN0TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN0TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN0TXTBPR_PRIO0:  equ    %00000001
mCAN0TXTBPR_PRIO1:  equ    %00000010
mCAN0TXTBPR_PRIO2:  equ    %00000100
mCAN0TXTBPR_PRIO3:  equ    %00001000
mCAN0TXTBPR_PRIO4:  equ    %00010000
mCAN0TXTBPR_PRIO5:  equ    %00100000
mCAN0TXTBPR_PRIO6:  equ    %01000000
mCAN0TXTBPR_PRIO7:  equ    %10000000


;*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***
CAN0TXTSR:          equ    $0000017E                                ;*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN0TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN0TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN0TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN0TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN0TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN0TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN0TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN0TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN0TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN0TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN0TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN0TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN0TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN0TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN0TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSR_TSR0:    equ    %00000001
mCAN0TXTSR_TSR1:    equ    %00000010
mCAN0TXTSR_TSR2:    equ    %00000100
mCAN0TXTSR_TSR3:    equ    %00001000
mCAN0TXTSR_TSR4:    equ    %00010000
mCAN0TXTSR_TSR5:    equ    %00100000
mCAN0TXTSR_TSR6:    equ    %01000000
mCAN0TXTSR_TSR7:    equ    %10000000
mCAN0TXTSR_TSR8:    equ    %100000000
mCAN0TXTSR_TSR9:    equ    %1000000000
mCAN0TXTSR_TSR10:   equ    %10000000000
mCAN0TXTSR_TSR11:   equ    %100000000000
mCAN0TXTSR_TSR12:   equ    %1000000000000
mCAN0TXTSR_TSR13:   equ    %10000000000000
mCAN0TXTSR_TSR14:   equ    %100000000000000
mCAN0TXTSR_TSR15:   equ    %1000000000000000


;*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***
CAN0TXTSRH:         equ    $0000017E                                ;*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN0TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN0TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN0TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN0TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN0TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN0TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN0TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN0TXTSRH_TSR8:   equ    %00000001
mCAN0TXTSRH_TSR9:   equ    %00000010
mCAN0TXTSRH_TSR10:  equ    %00000100
mCAN0TXTSRH_TSR11:  equ    %00001000
mCAN0TXTSRH_TSR12:  equ    %00010000
mCAN0TXTSRH_TSR13:  equ    %00100000
mCAN0TXTSRH_TSR14:  equ    %01000000
mCAN0TXTSRH_TSR15:  equ    %10000000


;*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***
CAN0TXTSRL:         equ    $0000017F                                ;*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN0TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN0TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN0TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN0TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN0TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN0TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN0TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN0TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN0TXTSRL_TSR0:   equ    %00000001
mCAN0TXTSRL_TSR1:   equ    %00000010
mCAN0TXTSRL_TSR2:   equ    %00000100
mCAN0TXTSRL_TSR3:   equ    %00001000
mCAN0TXTSRL_TSR4:   equ    %00010000
mCAN0TXTSRL_TSR5:   equ    %00100000
mCAN0TXTSRL_TSR6:   equ    %01000000
mCAN0TXTSRL_TSR7:   equ    %10000000


;*** CAN1CTL0 - MSCAN 1 Control 0 Register; 0x00000180 ***
CAN1CTL0:           equ    $00000180                                ;*** CAN1CTL0 - MSCAN 1 Control 0 Register; 0x00000180 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN1CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN1CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN1CTL0_TIME:      equ    3                                         ; Timer Enable
CAN1CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN1CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN1CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN1CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN1CTL0_INITRQ:   equ    %00000001
mCAN1CTL0_SLPRQ:    equ    %00000010
mCAN1CTL0_WUPE:     equ    %00000100
mCAN1CTL0_TIME:     equ    %00001000
mCAN1CTL0_SYNCH:    equ    %00010000
mCAN1CTL0_CSWAI:    equ    %00100000
mCAN1CTL0_RXACT:    equ    %01000000
mCAN1CTL0_RXFRM:    equ    %10000000


;*** CAN1CTL1 - MSCAN 1 Control 1 Register; 0x00000181 ***
CAN1CTL1:           equ    $00000181                                ;*** CAN1CTL1 - MSCAN 1 Control 1 Register; 0x00000181 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN1CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN1CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN1CTL1_BORM:      equ    3                                         ; Bus-Off Recovery Mode
CAN1CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN1CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN1CTL1_CLKSRC:    equ    6                                         ; MSCAN 1 Clock Source
CAN1CTL1_CANE:      equ    7                                         ; MSCAN 1 Enable
; bit position masks
mCAN1CTL1_INITAK:   equ    %00000001
mCAN1CTL1_SLPAK:    equ    %00000010
mCAN1CTL1_WUPM:     equ    %00000100
mCAN1CTL1_BORM:     equ    %00001000
mCAN1CTL1_LISTEN:   equ    %00010000
mCAN1CTL1_LOOPB:    equ    %00100000
mCAN1CTL1_CLKSRC:   equ    %01000000
mCAN1CTL1_CANE:     equ    %10000000


;*** CAN1BTR0 - MSCAN 1 Bus Timing Register 0; 0x00000182 ***
CAN1BTR0:           equ    $00000182                                ;*** CAN1BTR0 - MSCAN 1 Bus Timing Register 0; 0x00000182 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN1BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN1BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN1BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN1BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN1BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN1BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN1BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN1BTR0_BRP0:     equ    %00000001
mCAN1BTR0_BRP1:     equ    %00000010
mCAN1BTR0_BRP2:     equ    %00000100
mCAN1BTR0_BRP3:     equ    %00001000
mCAN1BTR0_BRP4:     equ    %00010000
mCAN1BTR0_BRP5:     equ    %00100000
mCAN1BTR0_SJW0:     equ    %01000000
mCAN1BTR0_SJW1:     equ    %10000000


;*** CAN1BTR1 - MSCAN 1 Bus Timing Register 1; 0x00000183 ***
CAN1BTR1:           equ    $00000183                                ;*** CAN1BTR1 - MSCAN 1 Bus Timing Register 1; 0x00000183 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN1BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN1BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN1BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN1BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN1BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN1BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN1BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN1BTR1_TSEG10:   equ    %00000001
mCAN1BTR1_TSEG11:   equ    %00000010
mCAN1BTR1_TSEG12:   equ    %00000100
mCAN1BTR1_TSEG13:   equ    %00001000
mCAN1BTR1_TSEG20:   equ    %00010000
mCAN1BTR1_TSEG21:   equ    %00100000
mCAN1BTR1_TSEG22:   equ    %01000000
mCAN1BTR1_SAMP:     equ    %10000000


;*** CAN1RFLG - MSCAN 1 Receiver Flag Register; 0x00000184 ***
CAN1RFLG:           equ    $00000184                                ;*** CAN1RFLG - MSCAN 1 Receiver Flag Register; 0x00000184 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN1RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN1RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN1RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN1RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN1RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN1RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN1RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN1RFLG_RXF:      equ    %00000001
mCAN1RFLG_OVRIF:    equ    %00000010
mCAN1RFLG_TSTAT0:   equ    %00000100
mCAN1RFLG_TSTAT1:   equ    %00001000
mCAN1RFLG_RSTAT0:   equ    %00010000
mCAN1RFLG_RSTAT1:   equ    %00100000
mCAN1RFLG_CSCIF:    equ    %01000000
mCAN1RFLG_WUPIF:    equ    %10000000


;*** CAN1RIER - MSCAN 1 Receiver Interrupt Enable Register; 0x00000185 ***
CAN1RIER:           equ    $00000185                                ;*** CAN1RIER - MSCAN 1 Receiver Interrupt Enable Register; 0x00000185 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN1RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN1RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN1RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN1RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN1RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN1RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN1RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN1RIER_RXFIE:    equ    %00000001
mCAN1RIER_OVRIE:    equ    %00000010
mCAN1RIER_TSTATE0:  equ    %00000100
mCAN1RIER_TSTATE1:  equ    %00001000
mCAN1RIER_RSTATE0:  equ    %00010000
mCAN1RIER_RSTATE1:  equ    %00100000
mCAN1RIER_CSCIE:    equ    %01000000
mCAN1RIER_WUPIE:    equ    %10000000


;*** CAN1TFLG - MSCAN 1 Transmitter Flag Register; 0x00000186 ***
CAN1TFLG:           equ    $00000186                                ;*** CAN1TFLG - MSCAN 1 Transmitter Flag Register; 0x00000186 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN1TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN1TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN1TFLG_TXE0:     equ    %00000001
mCAN1TFLG_TXE1:     equ    %00000010
mCAN1TFLG_TXE2:     equ    %00000100


;*** CAN1TIER - MSCAN 1 Transmitter Interrupt Enable Register; 0x00000187 ***
CAN1TIER:           equ    $00000187                                ;*** CAN1TIER - MSCAN 1 Transmitter Interrupt Enable Register; 0x00000187 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN1TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN1TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN1TIER_TXEIE0:   equ    %00000001
mCAN1TIER_TXEIE1:   equ    %00000010
mCAN1TIER_TXEIE2:   equ    %00000100


;*** CAN1TARQ - MSCAN 1 Transmitter Message Abort Request; 0x00000188 ***
CAN1TARQ:           equ    $00000188                                ;*** CAN1TARQ - MSCAN 1 Transmitter Message Abort Request; 0x00000188 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN1TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN1TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN1TARQ_ABTRQ0:   equ    %00000001
mCAN1TARQ_ABTRQ1:   equ    %00000010
mCAN1TARQ_ABTRQ2:   equ    %00000100


;*** CAN1TAAK - MSCAN 1 Transmitter Message Abort Control; 0x00000189 ***
CAN1TAAK:           equ    $00000189                                ;*** CAN1TAAK - MSCAN 1 Transmitter Message Abort Control; 0x00000189 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN1TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN1TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN1TAAK_ABTAK0:   equ    %00000001
mCAN1TAAK_ABTAK1:   equ    %00000010
mCAN1TAAK_ABTAK2:   equ    %00000100


;*** CAN1TBSEL - MSCAN 1 Transmit Buffer Selection; 0x0000018A ***
CAN1TBSEL:          equ    $0000018A                                ;*** CAN1TBSEL - MSCAN 1 Transmit Buffer Selection; 0x0000018A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN1TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN1TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN1TBSEL_TX0:     equ    %00000001
mCAN1TBSEL_TX1:     equ    %00000010
mCAN1TBSEL_TX2:     equ    %00000100


;*** CAN1IDAC - MSCAN 1 Identifier Acceptance Control Register; 0x0000018B ***
CAN1IDAC:           equ    $0000018B                                ;*** CAN1IDAC - MSCAN 1 Identifier Acceptance Control Register; 0x0000018B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN1IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN1IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN1IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN1IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN1IDAC_IDHIT0:   equ    %00000001
mCAN1IDAC_IDHIT1:   equ    %00000010
mCAN1IDAC_IDHIT2:   equ    %00000100
mCAN1IDAC_IDAM0:    equ    %00010000
mCAN1IDAC_IDAM1:    equ    %00100000


;*** CAN1MISC - MSCAN 1 Miscellaneous Register; 0x0000018D ***
CAN1MISC:           equ    $0000018D                                ;*** CAN1MISC - MSCAN 1 Miscellaneous Register; 0x0000018D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1MISC_BOHOLD:    equ    0                                         ; Bus-Off state Hold until user request
; bit position masks
mCAN1MISC_BOHOLD:   equ    %00000001


;*** CAN1RXERR - MSCAN 1 Receive Error Counter Register; 0x0000018E ***
CAN1RXERR:          equ    $0000018E                                ;*** CAN1RXERR - MSCAN 1 Receive Error Counter Register; 0x0000018E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN1RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN1RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN1RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN1RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN1RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN1RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN1RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN1RXERR_RXERR0:  equ    %00000001
mCAN1RXERR_RXERR1:  equ    %00000010
mCAN1RXERR_RXERR2:  equ    %00000100
mCAN1RXERR_RXERR3:  equ    %00001000
mCAN1RXERR_RXERR4:  equ    %00010000
mCAN1RXERR_RXERR5:  equ    %00100000
mCAN1RXERR_RXERR6:  equ    %01000000
mCAN1RXERR_RXERR7:  equ    %10000000


;*** CAN1TXERR - MSCAN 1 Transmit Error Counter Register; 0x0000018F ***
CAN1TXERR:          equ    $0000018F                                ;*** CAN1TXERR - MSCAN 1 Transmit Error Counter Register; 0x0000018F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN1TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN1TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN1TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN1TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN1TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN1TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN1TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN1TXERR_TXERR0:  equ    %00000001
mCAN1TXERR_TXERR1:  equ    %00000010
mCAN1TXERR_TXERR2:  equ    %00000100
mCAN1TXERR_TXERR3:  equ    %00001000
mCAN1TXERR_TXERR4:  equ    %00010000
mCAN1TXERR_TXERR5:  equ    %00100000
mCAN1TXERR_TXERR6:  equ    %01000000
mCAN1TXERR_TXERR7:  equ    %10000000


;*** CAN1IDAR0 - MSCAN 1 Identifier Acceptance Register 0; 0x00000190 ***
CAN1IDAR0:          equ    $00000190                                ;*** CAN1IDAR0 - MSCAN 1 Identifier Acceptance Register 0; 0x00000190 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR0_AC0:     equ    %00000001
mCAN1IDAR0_AC1:     equ    %00000010
mCAN1IDAR0_AC2:     equ    %00000100
mCAN1IDAR0_AC3:     equ    %00001000
mCAN1IDAR0_AC4:     equ    %00010000
mCAN1IDAR0_AC5:     equ    %00100000
mCAN1IDAR0_AC6:     equ    %01000000
mCAN1IDAR0_AC7:     equ    %10000000


;*** CAN1IDAR1 - MSCAN 1 Identifier Acceptance Register 1; 0x00000191 ***
CAN1IDAR1:          equ    $00000191                                ;*** CAN1IDAR1 - MSCAN 1 Identifier Acceptance Register 1; 0x00000191 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR1_AC0:     equ    %00000001
mCAN1IDAR1_AC1:     equ    %00000010
mCAN1IDAR1_AC2:     equ    %00000100
mCAN1IDAR1_AC3:     equ    %00001000
mCAN1IDAR1_AC4:     equ    %00010000
mCAN1IDAR1_AC5:     equ    %00100000
mCAN1IDAR1_AC6:     equ    %01000000
mCAN1IDAR1_AC7:     equ    %10000000


;*** CAN1IDAR2 - MSCAN 1 Identifier Acceptance Register 2; 0x00000192 ***
CAN1IDAR2:          equ    $00000192                                ;*** CAN1IDAR2 - MSCAN 1 Identifier Acceptance Register 2; 0x00000192 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR2_AC0:     equ    %00000001
mCAN1IDAR2_AC1:     equ    %00000010
mCAN1IDAR2_AC2:     equ    %00000100
mCAN1IDAR2_AC3:     equ    %00001000
mCAN1IDAR2_AC4:     equ    %00010000
mCAN1IDAR2_AC5:     equ    %00100000
mCAN1IDAR2_AC6:     equ    %01000000
mCAN1IDAR2_AC7:     equ    %10000000


;*** CAN1IDAR3 - MSCAN 1 Identifier Acceptance Register 3; 0x00000193 ***
CAN1IDAR3:          equ    $00000193                                ;*** CAN1IDAR3 - MSCAN 1 Identifier Acceptance Register 3; 0x00000193 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR3_AC0:     equ    %00000001
mCAN1IDAR3_AC1:     equ    %00000010
mCAN1IDAR3_AC2:     equ    %00000100
mCAN1IDAR3_AC3:     equ    %00001000
mCAN1IDAR3_AC4:     equ    %00010000
mCAN1IDAR3_AC5:     equ    %00100000
mCAN1IDAR3_AC6:     equ    %01000000
mCAN1IDAR3_AC7:     equ    %10000000


;*** CAN1IDMR0 - MSCAN 1 Identifier Mask Register 0; 0x00000194 ***
CAN1IDMR0:          equ    $00000194                                ;*** CAN1IDMR0 - MSCAN 1 Identifier Mask Register 0; 0x00000194 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR0_AM0:     equ    %00000001
mCAN1IDMR0_AM1:     equ    %00000010
mCAN1IDMR0_AM2:     equ    %00000100
mCAN1IDMR0_AM3:     equ    %00001000
mCAN1IDMR0_AM4:     equ    %00010000
mCAN1IDMR0_AM5:     equ    %00100000
mCAN1IDMR0_AM6:     equ    %01000000
mCAN1IDMR0_AM7:     equ    %10000000


;*** CAN1IDMR1 - MSCAN 1 Identifier Mask Register 1; 0x00000195 ***
CAN1IDMR1:          equ    $00000195                                ;*** CAN1IDMR1 - MSCAN 1 Identifier Mask Register 1; 0x00000195 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR1_AM0:     equ    %00000001
mCAN1IDMR1_AM1:     equ    %00000010
mCAN1IDMR1_AM2:     equ    %00000100
mCAN1IDMR1_AM3:     equ    %00001000
mCAN1IDMR1_AM4:     equ    %00010000
mCAN1IDMR1_AM5:     equ    %00100000
mCAN1IDMR1_AM6:     equ    %01000000
mCAN1IDMR1_AM7:     equ    %10000000


;*** CAN1IDMR2 - MSCAN 1 Identifier Mask Register 2; 0x00000196 ***
CAN1IDMR2:          equ    $00000196                                ;*** CAN1IDMR2 - MSCAN 1 Identifier Mask Register 2; 0x00000196 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR2_AM0:     equ    %00000001
mCAN1IDMR2_AM1:     equ    %00000010
mCAN1IDMR2_AM2:     equ    %00000100
mCAN1IDMR2_AM3:     equ    %00001000
mCAN1IDMR2_AM4:     equ    %00010000
mCAN1IDMR2_AM5:     equ    %00100000
mCAN1IDMR2_AM6:     equ    %01000000
mCAN1IDMR2_AM7:     equ    %10000000


;*** CAN1IDMR3 - MSCAN 1 Identifier Mask Register 3; 0x00000197 ***
CAN1IDMR3:          equ    $00000197                                ;*** CAN1IDMR3 - MSCAN 1 Identifier Mask Register 3; 0x00000197 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR3_AM0:     equ    %00000001
mCAN1IDMR3_AM1:     equ    %00000010
mCAN1IDMR3_AM2:     equ    %00000100
mCAN1IDMR3_AM3:     equ    %00001000
mCAN1IDMR3_AM4:     equ    %00010000
mCAN1IDMR3_AM5:     equ    %00100000
mCAN1IDMR3_AM6:     equ    %01000000
mCAN1IDMR3_AM7:     equ    %10000000


;*** CAN1IDAR4 - MSCAN 1 Identifier Acceptance Register 4; 0x00000198 ***
CAN1IDAR4:          equ    $00000198                                ;*** CAN1IDAR4 - MSCAN 1 Identifier Acceptance Register 4; 0x00000198 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR4_AC0:     equ    %00000001
mCAN1IDAR4_AC1:     equ    %00000010
mCAN1IDAR4_AC2:     equ    %00000100
mCAN1IDAR4_AC3:     equ    %00001000
mCAN1IDAR4_AC4:     equ    %00010000
mCAN1IDAR4_AC5:     equ    %00100000
mCAN1IDAR4_AC6:     equ    %01000000
mCAN1IDAR4_AC7:     equ    %10000000


;*** CAN1IDAR5 - MSCAN 1 Identifier Acceptance Register 5; 0x00000199 ***
CAN1IDAR5:          equ    $00000199                                ;*** CAN1IDAR5 - MSCAN 1 Identifier Acceptance Register 5; 0x00000199 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR5_AC0:     equ    %00000001
mCAN1IDAR5_AC1:     equ    %00000010
mCAN1IDAR5_AC2:     equ    %00000100
mCAN1IDAR5_AC3:     equ    %00001000
mCAN1IDAR5_AC4:     equ    %00010000
mCAN1IDAR5_AC5:     equ    %00100000
mCAN1IDAR5_AC6:     equ    %01000000
mCAN1IDAR5_AC7:     equ    %10000000


;*** CAN1IDAR6 - MSCAN 1 Identifier Acceptance Register 6; 0x0000019A ***
CAN1IDAR6:          equ    $0000019A                                ;*** CAN1IDAR6 - MSCAN 1 Identifier Acceptance Register 6; 0x0000019A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR6_AC0:     equ    %00000001
mCAN1IDAR6_AC1:     equ    %00000010
mCAN1IDAR6_AC2:     equ    %00000100
mCAN1IDAR6_AC3:     equ    %00001000
mCAN1IDAR6_AC4:     equ    %00010000
mCAN1IDAR6_AC5:     equ    %00100000
mCAN1IDAR6_AC6:     equ    %01000000
mCAN1IDAR6_AC7:     equ    %10000000


;*** CAN1IDAR7 - MSCAN 1 Identifier Acceptance Register 7; 0x0000019B ***
CAN1IDAR7:          equ    $0000019B                                ;*** CAN1IDAR7 - MSCAN 1 Identifier Acceptance Register 7; 0x0000019B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN1IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN1IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN1IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN1IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN1IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN1IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN1IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN1IDAR7_AC0:     equ    %00000001
mCAN1IDAR7_AC1:     equ    %00000010
mCAN1IDAR7_AC2:     equ    %00000100
mCAN1IDAR7_AC3:     equ    %00001000
mCAN1IDAR7_AC4:     equ    %00010000
mCAN1IDAR7_AC5:     equ    %00100000
mCAN1IDAR7_AC6:     equ    %01000000
mCAN1IDAR7_AC7:     equ    %10000000


;*** CAN1IDMR4 - MSCAN 1 Identifier Mask Register 4; 0x0000019C ***
CAN1IDMR4:          equ    $0000019C                                ;*** CAN1IDMR4 - MSCAN 1 Identifier Mask Register 4; 0x0000019C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR4_AM0:     equ    %00000001
mCAN1IDMR4_AM1:     equ    %00000010
mCAN1IDMR4_AM2:     equ    %00000100
mCAN1IDMR4_AM3:     equ    %00001000
mCAN1IDMR4_AM4:     equ    %00010000
mCAN1IDMR4_AM5:     equ    %00100000
mCAN1IDMR4_AM6:     equ    %01000000
mCAN1IDMR4_AM7:     equ    %10000000


;*** CAN1IDMR5 - MSCAN 1 Identifier Mask Register 5; 0x0000019D ***
CAN1IDMR5:          equ    $0000019D                                ;*** CAN1IDMR5 - MSCAN 1 Identifier Mask Register 5; 0x0000019D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR5_AM0:     equ    %00000001
mCAN1IDMR5_AM1:     equ    %00000010
mCAN1IDMR5_AM2:     equ    %00000100
mCAN1IDMR5_AM3:     equ    %00001000
mCAN1IDMR5_AM4:     equ    %00010000
mCAN1IDMR5_AM5:     equ    %00100000
mCAN1IDMR5_AM6:     equ    %01000000
mCAN1IDMR5_AM7:     equ    %10000000


;*** CAN1IDMR6 - MSCAN 1 Identifier Mask Register 6; 0x0000019E ***
CAN1IDMR6:          equ    $0000019E                                ;*** CAN1IDMR6 - MSCAN 1 Identifier Mask Register 6; 0x0000019E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR6_AM0:     equ    %00000001
mCAN1IDMR6_AM1:     equ    %00000010
mCAN1IDMR6_AM2:     equ    %00000100
mCAN1IDMR6_AM3:     equ    %00001000
mCAN1IDMR6_AM4:     equ    %00010000
mCAN1IDMR6_AM5:     equ    %00100000
mCAN1IDMR6_AM6:     equ    %01000000
mCAN1IDMR6_AM7:     equ    %10000000


;*** CAN1IDMR7 - MSCAN 1 Identifier Mask Register 7; 0x0000019F ***
CAN1IDMR7:          equ    $0000019F                                ;*** CAN1IDMR7 - MSCAN 1 Identifier Mask Register 7; 0x0000019F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN1IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN1IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN1IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN1IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN1IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN1IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN1IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN1IDMR7_AM0:     equ    %00000001
mCAN1IDMR7_AM1:     equ    %00000010
mCAN1IDMR7_AM2:     equ    %00000100
mCAN1IDMR7_AM3:     equ    %00001000
mCAN1IDMR7_AM4:     equ    %00010000
mCAN1IDMR7_AM5:     equ    %00100000
mCAN1IDMR7_AM6:     equ    %01000000
mCAN1IDMR7_AM7:     equ    %10000000


;*** CAN1RXIDR0 - MSCAN 1 Receive Identifier Register 0; 0x000001A0 ***
CAN1RXIDR0:         equ    $000001A0                                ;*** CAN1RXIDR0 - MSCAN 1 Receive Identifier Register 0; 0x000001A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN1RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN1RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN1RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN1RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN1RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN1RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN1RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN1RXIDR0_ID21:   equ    %00000001
mCAN1RXIDR0_ID22:   equ    %00000010
mCAN1RXIDR0_ID23:   equ    %00000100
mCAN1RXIDR0_ID24:   equ    %00001000
mCAN1RXIDR0_ID25:   equ    %00010000
mCAN1RXIDR0_ID26:   equ    %00100000
mCAN1RXIDR0_ID27:   equ    %01000000
mCAN1RXIDR0_ID28:   equ    %10000000


;*** CAN1RXIDR1 - MSCAN 1 Receive Identifier Register 1; 0x000001A1 ***
CAN1RXIDR1:         equ    $000001A1                                ;*** CAN1RXIDR1 - MSCAN 1 Receive Identifier Register 1; 0x000001A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN1RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN1RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN1RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN1RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN1RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN1RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN1RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN1RXIDR1_ID15:   equ    %00000001
mCAN1RXIDR1_ID16:   equ    %00000010
mCAN1RXIDR1_ID17:   equ    %00000100
mCAN1RXIDR1_IDE:    equ    %00001000
mCAN1RXIDR1_SRR:    equ    %00010000
mCAN1RXIDR1_ID18:   equ    %00100000
mCAN1RXIDR1_ID19:   equ    %01000000
mCAN1RXIDR1_ID20:   equ    %10000000


;*** CAN1RXIDR2 - MSCAN 1 Receive Identifier Register 2; 0x000001A2 ***
CAN1RXIDR2:         equ    $000001A2                                ;*** CAN1RXIDR2 - MSCAN 1 Receive Identifier Register 2; 0x000001A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN1RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN1RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN1RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN1RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN1RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN1RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN1RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN1RXIDR2_ID7:    equ    %00000001
mCAN1RXIDR2_ID8:    equ    %00000010
mCAN1RXIDR2_ID9:    equ    %00000100
mCAN1RXIDR2_ID10:   equ    %00001000
mCAN1RXIDR2_ID11:   equ    %00010000
mCAN1RXIDR2_ID12:   equ    %00100000
mCAN1RXIDR2_ID13:   equ    %01000000
mCAN1RXIDR2_ID14:   equ    %10000000


;*** CAN1RXIDR3 - MSCAN 1 Receive Identifier Register 3; 0x000001A3 ***
CAN1RXIDR3:         equ    $000001A3                                ;*** CAN1RXIDR3 - MSCAN 1 Receive Identifier Register 3; 0x000001A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN1RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN1RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN1RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN1RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN1RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN1RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN1RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN1RXIDR3_RTR:    equ    %00000001
mCAN1RXIDR3_ID0:    equ    %00000010
mCAN1RXIDR3_ID1:    equ    %00000100
mCAN1RXIDR3_ID2:    equ    %00001000
mCAN1RXIDR3_ID3:    equ    %00010000
mCAN1RXIDR3_ID4:    equ    %00100000
mCAN1RXIDR3_ID5:    equ    %01000000
mCAN1RXIDR3_ID6:    equ    %10000000


;*** CAN1RXDSR0 - MSCAN 1 Receive Data Segment Register 0; 0x000001A4 ***
CAN1RXDSR0:         equ    $000001A4                                ;*** CAN1RXDSR0 - MSCAN 1 Receive Data Segment Register 0; 0x000001A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR0_DB0:    equ    %00000001
mCAN1RXDSR0_DB1:    equ    %00000010
mCAN1RXDSR0_DB2:    equ    %00000100
mCAN1RXDSR0_DB3:    equ    %00001000
mCAN1RXDSR0_DB4:    equ    %00010000
mCAN1RXDSR0_DB5:    equ    %00100000
mCAN1RXDSR0_DB6:    equ    %01000000
mCAN1RXDSR0_DB7:    equ    %10000000


;*** CAN1RXDSR1 - MSCAN 1 Receive Data Segment Register 1; 0x000001A5 ***
CAN1RXDSR1:         equ    $000001A5                                ;*** CAN1RXDSR1 - MSCAN 1 Receive Data Segment Register 1; 0x000001A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR1_DB0:    equ    %00000001
mCAN1RXDSR1_DB1:    equ    %00000010
mCAN1RXDSR1_DB2:    equ    %00000100
mCAN1RXDSR1_DB3:    equ    %00001000
mCAN1RXDSR1_DB4:    equ    %00010000
mCAN1RXDSR1_DB5:    equ    %00100000
mCAN1RXDSR1_DB6:    equ    %01000000
mCAN1RXDSR1_DB7:    equ    %10000000


;*** CAN1RXDSR2 - MSCAN 1 Receive Data Segment Register 2; 0x000001A6 ***
CAN1RXDSR2:         equ    $000001A6                                ;*** CAN1RXDSR2 - MSCAN 1 Receive Data Segment Register 2; 0x000001A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR2_DB0:    equ    %00000001
mCAN1RXDSR2_DB1:    equ    %00000010
mCAN1RXDSR2_DB2:    equ    %00000100
mCAN1RXDSR2_DB3:    equ    %00001000
mCAN1RXDSR2_DB4:    equ    %00010000
mCAN1RXDSR2_DB5:    equ    %00100000
mCAN1RXDSR2_DB6:    equ    %01000000
mCAN1RXDSR2_DB7:    equ    %10000000


;*** CAN1RXDSR3 - MSCAN 1 Receive Data Segment Register 3; 0x000001A7 ***
CAN1RXDSR3:         equ    $000001A7                                ;*** CAN1RXDSR3 - MSCAN 1 Receive Data Segment Register 3; 0x000001A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR3_DB0:    equ    %00000001
mCAN1RXDSR3_DB1:    equ    %00000010
mCAN1RXDSR3_DB2:    equ    %00000100
mCAN1RXDSR3_DB3:    equ    %00001000
mCAN1RXDSR3_DB4:    equ    %00010000
mCAN1RXDSR3_DB5:    equ    %00100000
mCAN1RXDSR3_DB6:    equ    %01000000
mCAN1RXDSR3_DB7:    equ    %10000000


;*** CAN1RXDSR4 - MSCAN 1 Receive Data Segment Register 4; 0x000001A8 ***
CAN1RXDSR4:         equ    $000001A8                                ;*** CAN1RXDSR4 - MSCAN 1 Receive Data Segment Register 4; 0x000001A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR4_DB0:    equ    %00000001
mCAN1RXDSR4_DB1:    equ    %00000010
mCAN1RXDSR4_DB2:    equ    %00000100
mCAN1RXDSR4_DB3:    equ    %00001000
mCAN1RXDSR4_DB4:    equ    %00010000
mCAN1RXDSR4_DB5:    equ    %00100000
mCAN1RXDSR4_DB6:    equ    %01000000
mCAN1RXDSR4_DB7:    equ    %10000000


;*** CAN1RXDSR5 - MSCAN 1 Receive Data Segment Register 5; 0x000001A9 ***
CAN1RXDSR5:         equ    $000001A9                                ;*** CAN1RXDSR5 - MSCAN 1 Receive Data Segment Register 5; 0x000001A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR5_DB0:    equ    %00000001
mCAN1RXDSR5_DB1:    equ    %00000010
mCAN1RXDSR5_DB2:    equ    %00000100
mCAN1RXDSR5_DB3:    equ    %00001000
mCAN1RXDSR5_DB4:    equ    %00010000
mCAN1RXDSR5_DB5:    equ    %00100000
mCAN1RXDSR5_DB6:    equ    %01000000
mCAN1RXDSR5_DB7:    equ    %10000000


;*** CAN1RXDSR6 - MSCAN 1 Receive Data Segment Register 6; 0x000001AA ***
CAN1RXDSR6:         equ    $000001AA                                ;*** CAN1RXDSR6 - MSCAN 1 Receive Data Segment Register 6; 0x000001AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR6_DB0:    equ    %00000001
mCAN1RXDSR6_DB1:    equ    %00000010
mCAN1RXDSR6_DB2:    equ    %00000100
mCAN1RXDSR6_DB3:    equ    %00001000
mCAN1RXDSR6_DB4:    equ    %00010000
mCAN1RXDSR6_DB5:    equ    %00100000
mCAN1RXDSR6_DB6:    equ    %01000000
mCAN1RXDSR6_DB7:    equ    %10000000


;*** CAN1RXDSR7 - MSCAN 1 Receive Data Segment Register 7; 0x000001AB ***
CAN1RXDSR7:         equ    $000001AB                                ;*** CAN1RXDSR7 - MSCAN 1 Receive Data Segment Register 7; 0x000001AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN1RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN1RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN1RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN1RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN1RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN1RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN1RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1RXDSR7_DB0:    equ    %00000001
mCAN1RXDSR7_DB1:    equ    %00000010
mCAN1RXDSR7_DB2:    equ    %00000100
mCAN1RXDSR7_DB3:    equ    %00001000
mCAN1RXDSR7_DB4:    equ    %00010000
mCAN1RXDSR7_DB5:    equ    %00100000
mCAN1RXDSR7_DB6:    equ    %01000000
mCAN1RXDSR7_DB7:    equ    %10000000


;*** CAN1RXDLR - MSCAN 1 Receive Data Length Register; 0x000001AC ***
CAN1RXDLR:          equ    $000001AC                                ;*** CAN1RXDLR - MSCAN 1 Receive Data Length Register; 0x000001AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN1RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN1RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN1RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN1RXDLR_DLC0:    equ    %00000001
mCAN1RXDLR_DLC1:    equ    %00000010
mCAN1RXDLR_DLC2:    equ    %00000100
mCAN1RXDLR_DLC3:    equ    %00001000


;*** CAN1RXTSR - MSCAN 1 Receive Time Stamp Register; 0x000001AE ***
CAN1RXTSR:          equ    $000001AE                                ;*** CAN1RXTSR - MSCAN 1 Receive Time Stamp Register; 0x000001AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN1RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN1RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN1RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN1RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN1RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN1RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN1RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN1RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN1RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN1RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN1RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN1RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN1RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN1RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN1RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN1RXTSR_TSR0:    equ    %00000001
mCAN1RXTSR_TSR1:    equ    %00000010
mCAN1RXTSR_TSR2:    equ    %00000100
mCAN1RXTSR_TSR3:    equ    %00001000
mCAN1RXTSR_TSR4:    equ    %00010000
mCAN1RXTSR_TSR5:    equ    %00100000
mCAN1RXTSR_TSR6:    equ    %01000000
mCAN1RXTSR_TSR7:    equ    %10000000
mCAN1RXTSR_TSR8:    equ    %100000000
mCAN1RXTSR_TSR9:    equ    %1000000000
mCAN1RXTSR_TSR10:   equ    %10000000000
mCAN1RXTSR_TSR11:   equ    %100000000000
mCAN1RXTSR_TSR12:   equ    %1000000000000
mCAN1RXTSR_TSR13:   equ    %10000000000000
mCAN1RXTSR_TSR14:   equ    %100000000000000
mCAN1RXTSR_TSR15:   equ    %1000000000000000


;*** CAN1RXTSRH - MSCAN 1 Receive Time Stamp Register High; 0x000001AE ***
CAN1RXTSRH:         equ    $000001AE                                ;*** CAN1RXTSRH - MSCAN 1 Receive Time Stamp Register High; 0x000001AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN1RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN1RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN1RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN1RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN1RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN1RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN1RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN1RXTSRH_TSR8:   equ    %00000001
mCAN1RXTSRH_TSR9:   equ    %00000010
mCAN1RXTSRH_TSR10:  equ    %00000100
mCAN1RXTSRH_TSR11:  equ    %00001000
mCAN1RXTSRH_TSR12:  equ    %00010000
mCAN1RXTSRH_TSR13:  equ    %00100000
mCAN1RXTSRH_TSR14:  equ    %01000000
mCAN1RXTSRH_TSR15:  equ    %10000000


;*** CAN1RXTSRL - MSCAN 1 Receive Time Stamp Register Low; 0x000001AF ***
CAN1RXTSRL:         equ    $000001AF                                ;*** CAN1RXTSRL - MSCAN 1 Receive Time Stamp Register Low; 0x000001AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN1RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN1RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN1RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN1RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN1RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN1RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN1RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN1RXTSRL_TSR0:   equ    %00000001
mCAN1RXTSRL_TSR1:   equ    %00000010
mCAN1RXTSRL_TSR2:   equ    %00000100
mCAN1RXTSRL_TSR3:   equ    %00001000
mCAN1RXTSRL_TSR4:   equ    %00010000
mCAN1RXTSRL_TSR5:   equ    %00100000
mCAN1RXTSRL_TSR6:   equ    %01000000
mCAN1RXTSRL_TSR7:   equ    %10000000


;*** CAN1TXIDR0 - MSCAN 1 Transmit Identifier Register 0; 0x000001B0 ***
CAN1TXIDR0:         equ    $000001B0                                ;*** CAN1TXIDR0 - MSCAN 1 Transmit Identifier Register 0; 0x000001B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN1TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN1TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN1TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN1TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN1TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN1TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN1TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN1TXIDR0_ID21:   equ    %00000001
mCAN1TXIDR0_ID22:   equ    %00000010
mCAN1TXIDR0_ID23:   equ    %00000100
mCAN1TXIDR0_ID24:   equ    %00001000
mCAN1TXIDR0_ID25:   equ    %00010000
mCAN1TXIDR0_ID26:   equ    %00100000
mCAN1TXIDR0_ID27:   equ    %01000000
mCAN1TXIDR0_ID28:   equ    %10000000


;*** CAN1TXIDR1 - MSCAN 1 Transmit Identifier Register 1; 0x000001B1 ***
CAN1TXIDR1:         equ    $000001B1                                ;*** CAN1TXIDR1 - MSCAN 1 Transmit Identifier Register 1; 0x000001B1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN1TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN1TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN1TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN1TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN1TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN1TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN1TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN1TXIDR1_ID15:   equ    %00000001
mCAN1TXIDR1_ID16:   equ    %00000010
mCAN1TXIDR1_ID17:   equ    %00000100
mCAN1TXIDR1_IDE:    equ    %00001000
mCAN1TXIDR1_SRR:    equ    %00010000
mCAN1TXIDR1_ID18:   equ    %00100000
mCAN1TXIDR1_ID19:   equ    %01000000
mCAN1TXIDR1_ID20:   equ    %10000000


;*** CAN1TXIDR2 - MSCAN 1 Transmit Identifier Register 2; 0x000001B2 ***
CAN1TXIDR2:         equ    $000001B2                                ;*** CAN1TXIDR2 - MSCAN 1 Transmit Identifier Register 2; 0x000001B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN1TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN1TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN1TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN1TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN1TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN1TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN1TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN1TXIDR2_ID7:    equ    %00000001
mCAN1TXIDR2_ID8:    equ    %00000010
mCAN1TXIDR2_ID9:    equ    %00000100
mCAN1TXIDR2_ID10:   equ    %00001000
mCAN1TXIDR2_ID11:   equ    %00010000
mCAN1TXIDR2_ID12:   equ    %00100000
mCAN1TXIDR2_ID13:   equ    %01000000
mCAN1TXIDR2_ID14:   equ    %10000000


;*** CAN1TXIDR3 - MSCAN 1 Transmit Identifier Register 3; 0x000001B3 ***
CAN1TXIDR3:         equ    $000001B3                                ;*** CAN1TXIDR3 - MSCAN 1 Transmit Identifier Register 3; 0x000001B3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN1TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN1TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN1TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN1TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN1TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN1TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN1TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN1TXIDR3_RTR:    equ    %00000001
mCAN1TXIDR3_ID0:    equ    %00000010
mCAN1TXIDR3_ID1:    equ    %00000100
mCAN1TXIDR3_ID2:    equ    %00001000
mCAN1TXIDR3_ID3:    equ    %00010000
mCAN1TXIDR3_ID4:    equ    %00100000
mCAN1TXIDR3_ID5:    equ    %01000000
mCAN1TXIDR3_ID6:    equ    %10000000


;*** CAN1TXDSR0 - MSCAN 1 Transmit Data Segment Register 0; 0x000001B4 ***
CAN1TXDSR0:         equ    $000001B4                                ;*** CAN1TXDSR0 - MSCAN 1 Transmit Data Segment Register 0; 0x000001B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR0_DB0:    equ    %00000001
mCAN1TXDSR0_DB1:    equ    %00000010
mCAN1TXDSR0_DB2:    equ    %00000100
mCAN1TXDSR0_DB3:    equ    %00001000
mCAN1TXDSR0_DB4:    equ    %00010000
mCAN1TXDSR0_DB5:    equ    %00100000
mCAN1TXDSR0_DB6:    equ    %01000000
mCAN1TXDSR0_DB7:    equ    %10000000


;*** CAN1TXDSR1 - MSCAN 1 Transmit Data Segment Register 1; 0x000001B5 ***
CAN1TXDSR1:         equ    $000001B5                                ;*** CAN1TXDSR1 - MSCAN 1 Transmit Data Segment Register 1; 0x000001B5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR1_DB0:    equ    %00000001
mCAN1TXDSR1_DB1:    equ    %00000010
mCAN1TXDSR1_DB2:    equ    %00000100
mCAN1TXDSR1_DB3:    equ    %00001000
mCAN1TXDSR1_DB4:    equ    %00010000
mCAN1TXDSR1_DB5:    equ    %00100000
mCAN1TXDSR1_DB6:    equ    %01000000
mCAN1TXDSR1_DB7:    equ    %10000000


;*** CAN1TXDSR2 - MSCAN 1 Transmit Data Segment Register 2; 0x000001B6 ***
CAN1TXDSR2:         equ    $000001B6                                ;*** CAN1TXDSR2 - MSCAN 1 Transmit Data Segment Register 2; 0x000001B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR2_DB0:    equ    %00000001
mCAN1TXDSR2_DB1:    equ    %00000010
mCAN1TXDSR2_DB2:    equ    %00000100
mCAN1TXDSR2_DB3:    equ    %00001000
mCAN1TXDSR2_DB4:    equ    %00010000
mCAN1TXDSR2_DB5:    equ    %00100000
mCAN1TXDSR2_DB6:    equ    %01000000
mCAN1TXDSR2_DB7:    equ    %10000000


;*** CAN1TXDSR3 - MSCAN 1 Transmit Data Segment Register 3; 0x000001B7 ***
CAN1TXDSR3:         equ    $000001B7                                ;*** CAN1TXDSR3 - MSCAN 1 Transmit Data Segment Register 3; 0x000001B7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR3_DB0:    equ    %00000001
mCAN1TXDSR3_DB1:    equ    %00000010
mCAN1TXDSR3_DB2:    equ    %00000100
mCAN1TXDSR3_DB3:    equ    %00001000
mCAN1TXDSR3_DB4:    equ    %00010000
mCAN1TXDSR3_DB5:    equ    %00100000
mCAN1TXDSR3_DB6:    equ    %01000000
mCAN1TXDSR3_DB7:    equ    %10000000


;*** CAN1TXDSR4 - MSCAN 1 Transmit Data Segment Register 4; 0x000001B8 ***
CAN1TXDSR4:         equ    $000001B8                                ;*** CAN1TXDSR4 - MSCAN 1 Transmit Data Segment Register 4; 0x000001B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR4_DB0:    equ    %00000001
mCAN1TXDSR4_DB1:    equ    %00000010
mCAN1TXDSR4_DB2:    equ    %00000100
mCAN1TXDSR4_DB3:    equ    %00001000
mCAN1TXDSR4_DB4:    equ    %00010000
mCAN1TXDSR4_DB5:    equ    %00100000
mCAN1TXDSR4_DB6:    equ    %01000000
mCAN1TXDSR4_DB7:    equ    %10000000


;*** CAN1TXDSR5 - MSCAN 1 Transmit Data Segment Register 5; 0x000001B9 ***
CAN1TXDSR5:         equ    $000001B9                                ;*** CAN1TXDSR5 - MSCAN 1 Transmit Data Segment Register 5; 0x000001B9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR5_DB0:    equ    %00000001
mCAN1TXDSR5_DB1:    equ    %00000010
mCAN1TXDSR5_DB2:    equ    %00000100
mCAN1TXDSR5_DB3:    equ    %00001000
mCAN1TXDSR5_DB4:    equ    %00010000
mCAN1TXDSR5_DB5:    equ    %00100000
mCAN1TXDSR5_DB6:    equ    %01000000
mCAN1TXDSR5_DB7:    equ    %10000000


;*** CAN1TXDSR6 - MSCAN 1 Transmit Data Segment Register 6; 0x000001BA ***
CAN1TXDSR6:         equ    $000001BA                                ;*** CAN1TXDSR6 - MSCAN 1 Transmit Data Segment Register 6; 0x000001BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR6_DB0:    equ    %00000001
mCAN1TXDSR6_DB1:    equ    %00000010
mCAN1TXDSR6_DB2:    equ    %00000100
mCAN1TXDSR6_DB3:    equ    %00001000
mCAN1TXDSR6_DB4:    equ    %00010000
mCAN1TXDSR6_DB5:    equ    %00100000
mCAN1TXDSR6_DB6:    equ    %01000000
mCAN1TXDSR6_DB7:    equ    %10000000


;*** CAN1TXDSR7 - MSCAN 1 Transmit Data Segment Register 7; 0x000001BB ***
CAN1TXDSR7:         equ    $000001BB                                ;*** CAN1TXDSR7 - MSCAN 1 Transmit Data Segment Register 7; 0x000001BB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN1TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN1TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN1TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN1TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN1TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN1TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN1TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN1TXDSR7_DB0:    equ    %00000001
mCAN1TXDSR7_DB1:    equ    %00000010
mCAN1TXDSR7_DB2:    equ    %00000100
mCAN1TXDSR7_DB3:    equ    %00001000
mCAN1TXDSR7_DB4:    equ    %00010000
mCAN1TXDSR7_DB5:    equ    %00100000
mCAN1TXDSR7_DB6:    equ    %01000000
mCAN1TXDSR7_DB7:    equ    %10000000


;*** CAN1TXDLR - MSCAN 1 Transmit Data Length Register; 0x000001BC ***
CAN1TXDLR:          equ    $000001BC                                ;*** CAN1TXDLR - MSCAN 1 Transmit Data Length Register; 0x000001BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN1TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN1TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN1TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN1TXDLR_DLC0:    equ    %00000001
mCAN1TXDLR_DLC1:    equ    %00000010
mCAN1TXDLR_DLC2:    equ    %00000100
mCAN1TXDLR_DLC3:    equ    %00001000


;*** CAN1TXTBPR - MSCAN 1 Transmit Buffer Priority; 0x000001BD ***
CAN1TXTBPR:         equ    $000001BD                                ;*** CAN1TXTBPR - MSCAN 1 Transmit Buffer Priority; 0x000001BD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN1TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN1TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN1TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN1TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN1TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN1TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN1TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN1TXTBPR_PRIO0:  equ    %00000001
mCAN1TXTBPR_PRIO1:  equ    %00000010
mCAN1TXTBPR_PRIO2:  equ    %00000100
mCAN1TXTBPR_PRIO3:  equ    %00001000
mCAN1TXTBPR_PRIO4:  equ    %00010000
mCAN1TXTBPR_PRIO5:  equ    %00100000
mCAN1TXTBPR_PRIO6:  equ    %01000000
mCAN1TXTBPR_PRIO7:  equ    %10000000


;*** CAN1TXTSR - MSCAN 1 Transmit Time Stamp Register; 0x000001BE ***
CAN1TXTSR:          equ    $000001BE                                ;*** CAN1TXTSR - MSCAN 1 Transmit Time Stamp Register; 0x000001BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN1TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN1TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN1TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN1TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN1TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN1TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN1TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN1TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN1TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN1TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN1TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN1TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN1TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN1TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN1TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN1TXTSR_TSR0:    equ    %00000001
mCAN1TXTSR_TSR1:    equ    %00000010
mCAN1TXTSR_TSR2:    equ    %00000100
mCAN1TXTSR_TSR3:    equ    %00001000
mCAN1TXTSR_TSR4:    equ    %00010000
mCAN1TXTSR_TSR5:    equ    %00100000
mCAN1TXTSR_TSR6:    equ    %01000000
mCAN1TXTSR_TSR7:    equ    %10000000
mCAN1TXTSR_TSR8:    equ    %100000000
mCAN1TXTSR_TSR9:    equ    %1000000000
mCAN1TXTSR_TSR10:   equ    %10000000000
mCAN1TXTSR_TSR11:   equ    %100000000000
mCAN1TXTSR_TSR12:   equ    %1000000000000
mCAN1TXTSR_TSR13:   equ    %10000000000000
mCAN1TXTSR_TSR14:   equ    %100000000000000
mCAN1TXTSR_TSR15:   equ    %1000000000000000


;*** CAN1TXTSRH - MSCAN 1 Transmit Time Stamp Register High; 0x000001BE ***
CAN1TXTSRH:         equ    $000001BE                                ;*** CAN1TXTSRH - MSCAN 1 Transmit Time Stamp Register High; 0x000001BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN1TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN1TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN1TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN1TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN1TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN1TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN1TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN1TXTSRH_TSR8:   equ    %00000001
mCAN1TXTSRH_TSR9:   equ    %00000010
mCAN1TXTSRH_TSR10:  equ    %00000100
mCAN1TXTSRH_TSR11:  equ    %00001000
mCAN1TXTSRH_TSR12:  equ    %00010000
mCAN1TXTSRH_TSR13:  equ    %00100000
mCAN1TXTSRH_TSR14:  equ    %01000000
mCAN1TXTSRH_TSR15:  equ    %10000000


;*** CAN1TXTSRL - MSCAN 1 Transmit Time Stamp Register Low; 0x000001BF ***
CAN1TXTSRL:         equ    $000001BF                                ;*** CAN1TXTSRL - MSCAN 1 Transmit Time Stamp Register Low; 0x000001BF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN1TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN1TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN1TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN1TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN1TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN1TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN1TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN1TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN1TXTSRL_TSR0:   equ    %00000001
mCAN1TXTSRL_TSR1:   equ    %00000010
mCAN1TXTSRL_TSR2:   equ    %00000100
mCAN1TXTSRL_TSR3:   equ    %00001000
mCAN1TXTSRL_TSR4:   equ    %00010000
mCAN1TXTSRL_TSR5:   equ    %00100000
mCAN1TXTSRL_TSR6:   equ    %01000000
mCAN1TXTSRL_TSR7:   equ    %10000000


;*** PTT - Port T I/O Register; 0x00000240 ***
PTT:                equ    $00000240                                ;*** PTT - Port T I/O Register; 0x00000240 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTT_PTT0:           equ    0                                         ; Port T Bit 0
PTT_PTT1:           equ    1                                         ; Port T Bit 1
PTT_PTT2:           equ    2                                         ; Port T Bit 2
PTT_PTT3:           equ    3                                         ; Port T Bit 3
PTT_PTT4:           equ    4                                         ; Port T Bit 4
PTT_PTT5:           equ    5                                         ; Port T Bit 5
PTT_PTT6:           equ    6                                         ; Port T Bit 6
PTT_PTT7:           equ    7                                         ; Port T Bit 7
; bit position masks
mPTT_PTT0:          equ    %00000001
mPTT_PTT1:          equ    %00000010
mPTT_PTT2:          equ    %00000100
mPTT_PTT3:          equ    %00001000
mPTT_PTT4:          equ    %00010000
mPTT_PTT5:          equ    %00100000
mPTT_PTT6:          equ    %01000000
mPTT_PTT7:          equ    %10000000


;*** PTIT - Port T Input Register; 0x00000241 ***
PTIT:               equ    $00000241                                ;*** PTIT - Port T Input Register; 0x00000241 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIT_PTIT0:         equ    0                                         ; Port T Bit 0
PTIT_PTIT1:         equ    1                                         ; Port T Bit 1
PTIT_PTIT2:         equ    2                                         ; Port T Bit 2
PTIT_PTIT3:         equ    3                                         ; Port T Bit 3
PTIT_PTIT4:         equ    4                                         ; Port T Bit 4
PTIT_PTIT5:         equ    5                                         ; Port T Bit 5
PTIT_PTIT6:         equ    6                                         ; Port T Bit 6
PTIT_PTIT7:         equ    7                                         ; Port T Bit 7
; bit position masks
mPTIT_PTIT0:        equ    %00000001
mPTIT_PTIT1:        equ    %00000010
mPTIT_PTIT2:        equ    %00000100
mPTIT_PTIT3:        equ    %00001000
mPTIT_PTIT4:        equ    %00010000
mPTIT_PTIT5:        equ    %00100000
mPTIT_PTIT6:        equ    %01000000
mPTIT_PTIT7:        equ    %10000000


;*** DDRT - Port T Data Direction Register; 0x00000242 ***
DDRT:               equ    $00000242                                ;*** DDRT - Port T Data Direction Register; 0x00000242 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRT_DDRT0:         equ    0                                         ; Data Direction Port T Bit 0
DDRT_DDRT1:         equ    1                                         ; Data Direction Port T Bit 1
DDRT_DDRT2:         equ    2                                         ; Data Direction Port T Bit 2
DDRT_DDRT3:         equ    3                                         ; Data Direction Port T Bit 3
DDRT_DDRT4:         equ    4                                         ; Data Direction Port T Bit 4
DDRT_DDRT5:         equ    5                                         ; Data Direction Port T Bit 5
DDRT_DDRT6:         equ    6                                         ; Data Direction Port T Bit 6
DDRT_DDRT7:         equ    7                                         ; Data Direction Port T Bit 7
; bit position masks
mDDRT_DDRT0:        equ    %00000001
mDDRT_DDRT1:        equ    %00000010
mDDRT_DDRT2:        equ    %00000100
mDDRT_DDRT3:        equ    %00001000
mDDRT_DDRT4:        equ    %00010000
mDDRT_DDRT5:        equ    %00100000
mDDRT_DDRT6:        equ    %01000000
mDDRT_DDRT7:        equ    %10000000


;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
RDRT:               equ    $00000243                                ;*** RDRT - Port T Reduced Drive Register; 0x00000243 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRT_RDRT0:         equ    0                                         ; Reduced Drive Port T Bit 0
RDRT_RDRT1:         equ    1                                         ; Reduced Drive Port T Bit 1
RDRT_RDRT2:         equ    2                                         ; Reduced Drive Port T Bit 2
RDRT_RDRT3:         equ    3                                         ; Reduced Drive Port T Bit 3
RDRT_RDRT4:         equ    4                                         ; Reduced Drive Port T Bit 4
RDRT_RDRT5:         equ    5                                         ; Reduced Drive Port T Bit 5
RDRT_RDRT6:         equ    6                                         ; Reduced Drive Port T Bit 6
RDRT_RDRT7:         equ    7                                         ; Reduced Drive Port T Bit 7
; bit position masks
mRDRT_RDRT0:        equ    %00000001
mRDRT_RDRT1:        equ    %00000010
mRDRT_RDRT2:        equ    %00000100
mRDRT_RDRT3:        equ    %00001000
mRDRT_RDRT4:        equ    %00010000
mRDRT_RDRT5:        equ    %00100000
mRDRT_RDRT6:        equ    %01000000
mRDRT_RDRT7:        equ    %10000000


;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
PERT:               equ    $00000244                                ;*** PERT - Port T Pull Device Enable Register; 0x00000244 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERT_PERT0:         equ    0                                         ; Pull Device Enable Port T Bit 0
PERT_PERT1:         equ    1                                         ; Pull Device Enable Port T Bit 1
PERT_PERT2:         equ    2                                         ; Pull Device Enable Port T Bit 2
PERT_PERT3:         equ    3                                         ; Pull Device Enable Port T Bit 3
PERT_PERT4:         equ    4                                         ; Pull Device Enable Port T Bit 4
PERT_PERT5:         equ    5                                         ; Pull Device Enable Port T Bit 5
PERT_PERT6:         equ    6                                         ; Pull Device Enable Port T Bit 6
PERT_PERT7:         equ    7                                         ; Pull Device Enable Port T Bit 7
; bit position masks
mPERT_PERT0:        equ    %00000001
mPERT_PERT1:        equ    %00000010
mPERT_PERT2:        equ    %00000100
mPERT_PERT3:        equ    %00001000
mPERT_PERT4:        equ    %00010000
mPERT_PERT5:        equ    %00100000
mPERT_PERT6:        equ    %01000000
mPERT_PERT7:        equ    %10000000


;*** PPST - Port T Polarity Select Register; 0x00000245 ***
PPST:               equ    $00000245                                ;*** PPST - Port T Polarity Select Register; 0x00000245 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPST_PPST0:         equ    0                                         ; Pull Select Port T Bit 0
PPST_PPST1:         equ    1                                         ; Pull Select Port T Bit 1
PPST_PPST2:         equ    2                                         ; Pull Select Port T Bit 2
PPST_PPST3:         equ    3                                         ; Pull Select Port T Bit 3
PPST_PPST4:         equ    4                                         ; Pull Select Port T Bit 4
PPST_PPST5:         equ    5                                         ; Pull Select Port T Bit 5
PPST_PPST6:         equ    6                                         ; Pull Select Port T Bit 6
PPST_PPST7:         equ    7                                         ; Pull Select Port T Bit 7
; bit position masks
mPPST_PPST0:        equ    %00000001
mPPST_PPST1:        equ    %00000010
mPPST_PPST2:        equ    %00000100
mPPST_PPST3:        equ    %00001000
mPPST_PPST4:        equ    %00010000
mPPST_PPST5:        equ    %00100000
mPPST_PPST6:        equ    %01000000
mPPST_PPST7:        equ    %10000000


;*** PTS - Port S I/O Register; 0x00000248 ***
PTS:                equ    $00000248                                ;*** PTS - Port S I/O Register; 0x00000248 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTS_PTS0:           equ    0                                         ; Port S Bit 0
PTS_PTS1:           equ    1                                         ; Port S Bit 1
PTS_PTS2:           equ    2                                         ; Port S Bit 2
PTS_PTS3:           equ    3                                         ; Port S Bit 3
PTS_PTS4:           equ    4                                         ; Port S Bit 4
PTS_PTS5:           equ    5                                         ; Port S Bit 5
PTS_PTS6:           equ    6                                         ; Port S Bit 6
PTS_PTS7:           equ    7                                         ; Port S Bit 7
; bit position masks
mPTS_PTS0:          equ    %00000001
mPTS_PTS1:          equ    %00000010
mPTS_PTS2:          equ    %00000100
mPTS_PTS3:          equ    %00001000
mPTS_PTS4:          equ    %00010000
mPTS_PTS5:          equ    %00100000
mPTS_PTS6:          equ    %01000000
mPTS_PTS7:          equ    %10000000


;*** PTIS - Port S Input Register; 0x00000249 ***
PTIS:               equ    $00000249                                ;*** PTIS - Port S Input Register; 0x00000249 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIS_PTIS0:         equ    0                                         ; Port S Bit 0
PTIS_PTIS1:         equ    1                                         ; Port S Bit 1
PTIS_PTIS2:         equ    2                                         ; Port S Bit 2
PTIS_PTIS3:         equ    3                                         ; Port S Bit 3
PTIS_PTIS4:         equ    4                                         ; Port S Bit 4
PTIS_PTIS5:         equ    5                                         ; Port S Bit 5
PTIS_PTIS6:         equ    6                                         ; Port S Bit 6
PTIS_PTIS7:         equ    7                                         ; Port S Bit 7
; bit position masks
mPTIS_PTIS0:        equ    %00000001
mPTIS_PTIS1:        equ    %00000010
mPTIS_PTIS2:        equ    %00000100
mPTIS_PTIS3:        equ    %00001000
mPTIS_PTIS4:        equ    %00010000
mPTIS_PTIS5:        equ    %00100000
mPTIS_PTIS6:        equ    %01000000
mPTIS_PTIS7:        equ    %10000000


;*** DDRS - Port S Data Direction Register; 0x0000024A ***
DDRS:               equ    $0000024A                                ;*** DDRS - Port S Data Direction Register; 0x0000024A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRS_DDRS0:         equ    0                                         ; Data Direction Port S Bit 0
DDRS_DDRS1:         equ    1                                         ; Data Direction Port S Bit 1
DDRS_DDRS2:         equ    2                                         ; Data Direction Port S Bit 2
DDRS_DDRS3:         equ    3                                         ; Data Direction Port S Bit 3
DDRS_DDRS4:         equ    4                                         ; Data Direction Port S Bit 4
DDRS_DDRS5:         equ    5                                         ; Data Direction Port S Bit 5
DDRS_DDRS6:         equ    6                                         ; Data Direction Port S Bit 6
DDRS_DDRS7:         equ    7                                         ; Data Direction Port S Bit 7
; bit position masks
mDDRS_DDRS0:        equ    %00000001
mDDRS_DDRS1:        equ    %00000010
mDDRS_DDRS2:        equ    %00000100
mDDRS_DDRS3:        equ    %00001000
mDDRS_DDRS4:        equ    %00010000
mDDRS_DDRS5:        equ    %00100000
mDDRS_DDRS6:        equ    %01000000
mDDRS_DDRS7:        equ    %10000000


;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
RDRS:               equ    $0000024B                                ;*** RDRS - Port S Reduced Drive Register; 0x0000024B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRS_RDRS0:         equ    0                                         ; Reduced Drive Port S Bit 0
RDRS_RDRS1:         equ    1                                         ; Reduced Drive Port S Bit 1
RDRS_RDRS2:         equ    2                                         ; Reduced Drive Port S Bit 2
RDRS_RDRS3:         equ    3                                         ; Reduced Drive Port S Bit 3
RDRS_RDRS4:         equ    4                                         ; Reduced Drive Port S Bit 4
RDRS_RDRS5:         equ    5                                         ; Reduced Drive Port S Bit 5
RDRS_RDRS6:         equ    6                                         ; Reduced Drive Port S Bit 6
RDRS_RDRS7:         equ    7                                         ; Reduced Drive Port S Bit 7
; bit position masks
mRDRS_RDRS0:        equ    %00000001
mRDRS_RDRS1:        equ    %00000010
mRDRS_RDRS2:        equ    %00000100
mRDRS_RDRS3:        equ    %00001000
mRDRS_RDRS4:        equ    %00010000
mRDRS_RDRS5:        equ    %00100000
mRDRS_RDRS6:        equ    %01000000
mRDRS_RDRS7:        equ    %10000000


;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
PERS:               equ    $0000024C                                ;*** PERS - Port S Pull Device Enable Register; 0x0000024C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERS_PERS0:         equ    0                                         ; Pull Device Enable Port S Bit 0
PERS_PERS1:         equ    1                                         ; Pull Device Enable Port S Bit 1
PERS_PERS2:         equ    2                                         ; Pull Device Enable Port S Bit 2
PERS_PERS3:         equ    3                                         ; Pull Device Enable Port S Bit 3
PERS_PERS4:         equ    4                                         ; Pull Device Enable Port S Bit 4
PERS_PERS5:         equ    5                                         ; Pull Device Enable Port S Bit 5
PERS_PERS6:         equ    6                                         ; Pull Device Enable Port S Bit 6
PERS_PERS7:         equ    7                                         ; Pull Device Enable Port S Bit 7
; bit position masks
mPERS_PERS0:        equ    %00000001
mPERS_PERS1:        equ    %00000010
mPERS_PERS2:        equ    %00000100
mPERS_PERS3:        equ    %00001000
mPERS_PERS4:        equ    %00010000
mPERS_PERS5:        equ    %00100000
mPERS_PERS6:        equ    %01000000
mPERS_PERS7:        equ    %10000000


;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
PPSS:               equ    $0000024D                                ;*** PPSS - Port S Polarity Select Register; 0x0000024D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSS_PPSS0:         equ    0                                         ; Pull Select Port S Bit 0
PPSS_PPSS1:         equ    1                                         ; Pull Select Port S Bit 1
PPSS_PPSS2:         equ    2                                         ; Pull Select Port S Bit 2
PPSS_PPSS3:         equ    3                                         ; Pull Select Port S Bit 3
PPSS_PPSS4:         equ    4                                         ; Pull Select Port S Bit 4
PPSS_PPSS5:         equ    5                                         ; Pull Select Port S Bit 5
PPSS_PPSS6:         equ    6                                         ; Pull Select Port S Bit 6
PPSS_PPSS7:         equ    7                                         ; Pull Select Port S Bit 7
; bit position masks
mPPSS_PPSS0:        equ    %00000001
mPPSS_PPSS1:        equ    %00000010
mPPSS_PPSS2:        equ    %00000100
mPPSS_PPSS3:        equ    %00001000
mPPSS_PPSS4:        equ    %00010000
mPPSS_PPSS5:        equ    %00100000
mPPSS_PPSS6:        equ    %01000000
mPPSS_PPSS7:        equ    %10000000


;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
WOMS:               equ    $0000024E                                ;*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMS_WOMS0:         equ    0                                         ; Wired-Or Mode Port S Bit 0
WOMS_WOMS1:         equ    1                                         ; Wired-Or Mode Port S Bit 1
WOMS_WOMS2:         equ    2                                         ; Wired-Or Mode Port S Bit 2
WOMS_WOMS3:         equ    3                                         ; Wired-Or Mode Port S Bit 3
WOMS_WOMS4:         equ    4                                         ; Wired-Or Mode Port S Bit 4
WOMS_WOMS5:         equ    5                                         ; Wired-Or Mode Port S Bit 5
WOMS_WOMS6:         equ    6                                         ; Wired-Or Mode Port S Bit 6
WOMS_WOMS7:         equ    7                                         ; Wired-Or Mode Port S Bit 7
; bit position masks
mWOMS_WOMS0:        equ    %00000001
mWOMS_WOMS1:        equ    %00000010
mWOMS_WOMS2:        equ    %00000100
mWOMS_WOMS3:        equ    %00001000
mWOMS_WOMS4:        equ    %00010000
mWOMS_WOMS5:        equ    %00100000
mWOMS_WOMS6:        equ    %01000000
mWOMS_WOMS7:        equ    %10000000


;*** PTM - Port M I/O Register; 0x00000250 ***
PTM:                equ    $00000250                                ;*** PTM - Port M I/O Register; 0x00000250 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTM_PTM0:           equ    0                                         ; Port M Bit 0
PTM_PTM1:           equ    1                                         ; Port M Bit 1
PTM_PTM2:           equ    2                                         ; Port M Bit 2
PTM_PTM3:           equ    3                                         ; Port M Bit 3
PTM_PTM4:           equ    4                                         ; Port M Bit 4
PTM_PTM5:           equ    5                                         ; Port M Bit 5
PTM_PTM6:           equ    6                                         ; Port M Bit 6
PTM_PTM7:           equ    7                                         ; Port M Bit 7
; bit position masks
mPTM_PTM0:          equ    %00000001
mPTM_PTM1:          equ    %00000010
mPTM_PTM2:          equ    %00000100
mPTM_PTM3:          equ    %00001000
mPTM_PTM4:          equ    %00010000
mPTM_PTM5:          equ    %00100000
mPTM_PTM6:          equ    %01000000
mPTM_PTM7:          equ    %10000000


;*** PTIM - Port M Input Register; 0x00000251 ***
PTIM:               equ    $00000251                                ;*** PTIM - Port M Input Register; 0x00000251 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIM_PTIM0:         equ    0                                         ; Port M Bit 0
PTIM_PTIM1:         equ    1                                         ; Port M Bit 1
PTIM_PTIM2:         equ    2                                         ; Port M Bit 2
PTIM_PTIM3:         equ    3                                         ; Port M Bit 3
PTIM_PTIM4:         equ    4                                         ; Port M Bit 4
PTIM_PTIM5:         equ    5                                         ; Port M Bit 5
PTIM_PTIM6:         equ    6                                         ; Port M Bit 6
PTIM_PTIM7:         equ    7                                         ; Port M Bit 7
; bit position masks
mPTIM_PTIM0:        equ    %00000001
mPTIM_PTIM1:        equ    %00000010
mPTIM_PTIM2:        equ    %00000100
mPTIM_PTIM3:        equ    %00001000
mPTIM_PTIM4:        equ    %00010000
mPTIM_PTIM5:        equ    %00100000
mPTIM_PTIM6:        equ    %01000000
mPTIM_PTIM7:        equ    %10000000


;*** DDRM - Port M Data Direction Register; 0x00000252 ***
DDRM:               equ    $00000252                                ;*** DDRM - Port M Data Direction Register; 0x00000252 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRM_DDRM0:         equ    0                                         ; Data Direction Port M Bit 0
DDRM_DDRM1:         equ    1                                         ; Data Direction Port M Bit 1
DDRM_DDRM2:         equ    2                                         ; Data Direction Port M Bit 2
DDRM_DDRM3:         equ    3                                         ; Data Direction Port M Bit 3
DDRM_DDRM4:         equ    4                                         ; Data Direction Port M Bit 4
DDRM_DDRM5:         equ    5                                         ; Data Direction Port M Bit 5
DDRM_DDRM6:         equ    6                                         ; Data Direction Port M Bit 6
DDRM_DDRM7:         equ    7                                         ; Data Direction Port M Bit 7
; bit position masks
mDDRM_DDRM0:        equ    %00000001
mDDRM_DDRM1:        equ    %00000010
mDDRM_DDRM2:        equ    %00000100
mDDRM_DDRM3:        equ    %00001000
mDDRM_DDRM4:        equ    %00010000
mDDRM_DDRM5:        equ    %00100000
mDDRM_DDRM6:        equ    %01000000
mDDRM_DDRM7:        equ    %10000000


;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
RDRM:               equ    $00000253                                ;*** RDRM - Port M Reduced Drive Register; 0x00000253 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRM_RDRM0:         equ    0                                         ; Reduced Drive Port M Bit 0
RDRM_RDRM1:         equ    1                                         ; Reduced Drive Port M Bit 1
RDRM_RDRM2:         equ    2                                         ; Reduced Drive Port M Bit 2
RDRM_RDRM3:         equ    3                                         ; Reduced Drive Port M Bit 3
RDRM_RDRM4:         equ    4                                         ; Reduced Drive Port M Bit 4
RDRM_RDRM5:         equ    5                                         ; Reduced Drive Port M Bit 5
RDRM_RDRM6:         equ    6                                         ; Reduced Drive Port M Bit 6
RDRM_RDRM7:         equ    7                                         ; Reduced Drive Port M Bit 7
; bit position masks
mRDRM_RDRM0:        equ    %00000001
mRDRM_RDRM1:        equ    %00000010
mRDRM_RDRM2:        equ    %00000100
mRDRM_RDRM3:        equ    %00001000
mRDRM_RDRM4:        equ    %00010000
mRDRM_RDRM5:        equ    %00100000
mRDRM_RDRM6:        equ    %01000000
mRDRM_RDRM7:        equ    %10000000


;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
PERM:               equ    $00000254                                ;*** PERM - Port M Pull Device Enable Register; 0x00000254 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERM_PERM0:         equ    0                                         ; Pull Device Enable Port M Bit 0
PERM_PERM1:         equ    1                                         ; Pull Device Enable Port M Bit 1
PERM_PERM2:         equ    2                                         ; Pull Device Enable Port M Bit 2
PERM_PERM3:         equ    3                                         ; Pull Device Enable Port M Bit 3
PERM_PERM4:         equ    4                                         ; Pull Device Enable Port M Bit 4
PERM_PERM5:         equ    5                                         ; Pull Device Enable Port M Bit 5
PERM_PERM6:         equ    6                                         ; Pull Device Enable Port M Bit 6
PERM_PERM7:         equ    7                                         ; Pull Device Enable Port M Bit 7
; bit position masks
mPERM_PERM0:        equ    %00000001
mPERM_PERM1:        equ    %00000010
mPERM_PERM2:        equ    %00000100
mPERM_PERM3:        equ    %00001000
mPERM_PERM4:        equ    %00010000
mPERM_PERM5:        equ    %00100000
mPERM_PERM6:        equ    %01000000
mPERM_PERM7:        equ    %10000000


;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
PPSM:               equ    $00000255                                ;*** PPSM - Port M Polarity Select Register; 0x00000255 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSM_PPSM0:         equ    0                                         ; Pull Select Port M Bit 0
PPSM_PPSM1:         equ    1                                         ; Pull Select Port M Bit 1
PPSM_PPSM2:         equ    2                                         ; Pull Select Port M Bit 2
PPSM_PPSM3:         equ    3                                         ; Pull Select Port M Bit 3
PPSM_PPSM4:         equ    4                                         ; Pull Select Port M Bit 4
PPSM_PPSM5:         equ    5                                         ; Pull Select Port M Bit 5
PPSM_PPSM6:         equ    6                                         ; Pull Select Port M Bit 6
PPSM_PPSM7:         equ    7                                         ; Pull Select Port M Bit 7
; bit position masks
mPPSM_PPSM0:        equ    %00000001
mPPSM_PPSM1:        equ    %00000010
mPPSM_PPSM2:        equ    %00000100
mPPSM_PPSM3:        equ    %00001000
mPPSM_PPSM4:        equ    %00010000
mPPSM_PPSM5:        equ    %00100000
mPPSM_PPSM6:        equ    %01000000
mPPSM_PPSM7:        equ    %10000000


;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
WOMM:               equ    $00000256                                ;*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
WOMM_WOMM0:         equ    0                                         ; Wired-Or Mode Port M Bit 0
WOMM_WOMM1:         equ    1                                         ; Wired-Or Mode Port M Bit 1
WOMM_WOMM2:         equ    2                                         ; Wired-Or Mode Port M Bit 2
WOMM_WOMM3:         equ    3                                         ; Wired-Or Mode Port M Bit 3
WOMM_WOMM4:         equ    4                                         ; Wired-Or Mode Port M Bit 4
WOMM_WOMM5:         equ    5                                         ; Wired-Or Mode Port M Bit 5
WOMM_WOMM6:         equ    6                                         ; Wired-Or Mode Port M Bit 6
WOMM_WOMM7:         equ    7                                         ; Wired-Or Mode Port M Bit 7
; bit position masks
mWOMM_WOMM0:        equ    %00000001
mWOMM_WOMM1:        equ    %00000010
mWOMM_WOMM2:        equ    %00000100
mWOMM_WOMM3:        equ    %00001000
mWOMM_WOMM4:        equ    %00010000
mWOMM_WOMM5:        equ    %00100000
mWOMM_WOMM6:        equ    %01000000
mWOMM_WOMM7:        equ    %10000000


;*** MODRR - Module Routing Register; 0x00000257 ***
MODRR:              equ    $00000257                                ;*** MODRR - Module Routing Register; 0x00000257 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MODRR_MODRR0:       equ    0                                         ; CAN0 Routing Bit 0
MODRR_MODRR1:       equ    1                                         ; CAN0 Routing Bit 1
MODRR_MODRR2:       equ    2                                         ; CAN4 Routing Bit 0
MODRR_MODRR3:       equ    3                                         ; CAN4 Routing Bit 1
MODRR_MODRR4:       equ    4                                         ; SPI0 Routing
MODRR_MODRR5:       equ    5                                         ; SPI1 Routing
MODRR_MODRR6:       equ    6                                         ; SPI2 Routing
; bit position masks
mMODRR_MODRR0:      equ    %00000001
mMODRR_MODRR1:      equ    %00000010
mMODRR_MODRR2:      equ    %00000100
mMODRR_MODRR3:      equ    %00001000
mMODRR_MODRR4:      equ    %00010000
mMODRR_MODRR5:      equ    %00100000
mMODRR_MODRR6:      equ    %01000000


;*** PTP - Port P I/O Register; 0x00000258 ***
PTP:                equ    $00000258                                ;*** PTP - Port P I/O Register; 0x00000258 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTP_PTP0:           equ    0                                         ; Port P Bit 0
PTP_PTP1:           equ    1                                         ; Port P Bit 1
PTP_PTP2:           equ    2                                         ; Port P Bit 2
PTP_PTP3:           equ    3                                         ; Port P Bit 3
PTP_PTP4:           equ    4                                         ; Port P Bit 4
PTP_PTP5:           equ    5                                         ; Port P Bit 5
PTP_PTP6:           equ    6                                         ; Port P Bit 6
PTP_PTP7:           equ    7                                         ; Port P Bit 7
; bit position masks
mPTP_PTP0:          equ    %00000001
mPTP_PTP1:          equ    %00000010
mPTP_PTP2:          equ    %00000100
mPTP_PTP3:          equ    %00001000
mPTP_PTP4:          equ    %00010000
mPTP_PTP5:          equ    %00100000
mPTP_PTP6:          equ    %01000000
mPTP_PTP7:          equ    %10000000


;*** PTIP - Port P Input Register; 0x00000259 ***
PTIP:               equ    $00000259                                ;*** PTIP - Port P Input Register; 0x00000259 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIP_PTIP0:         equ    0                                         ; Port P Bit 0
PTIP_PTIP1:         equ    1                                         ; Port P Bit 1
PTIP_PTIP2:         equ    2                                         ; Port P Bit 2
PTIP_PTIP3:         equ    3                                         ; Port P Bit 3
PTIP_PTIP4:         equ    4                                         ; Port P Bit 4
PTIP_PTIP5:         equ    5                                         ; Port P Bit 5
PTIP_PTIP6:         equ    6                                         ; Port P Bit 6
PTIP_PTIP7:         equ    7                                         ; Port P Bit 7
; bit position masks
mPTIP_PTIP0:        equ    %00000001
mPTIP_PTIP1:        equ    %00000010
mPTIP_PTIP2:        equ    %00000100
mPTIP_PTIP3:        equ    %00001000
mPTIP_PTIP4:        equ    %00010000
mPTIP_PTIP5:        equ    %00100000
mPTIP_PTIP6:        equ    %01000000
mPTIP_PTIP7:        equ    %10000000


;*** DDRP - Port P Data Direction Register; 0x0000025A ***
DDRP:               equ    $0000025A                                ;*** DDRP - Port P Data Direction Register; 0x0000025A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRP_DDRP0:         equ    0                                         ; Data Direction Port P Bit 0
DDRP_DDRP1:         equ    1                                         ; Data Direction Port P Bit 1
DDRP_DDRP2:         equ    2                                         ; Data Direction Port P Bit 2
DDRP_DDRP3:         equ    3                                         ; Data Direction Port P Bit 3
DDRP_DDRP4:         equ    4                                         ; Data Direction Port P Bit 4
DDRP_DDRP5:         equ    5                                         ; Data Direction Port P Bit 5
DDRP_DDRP6:         equ    6                                         ; Data Direction Port P Bit 6
DDRP_DDRP7:         equ    7                                         ; Data Direction Port P Bit 7
; bit position masks
mDDRP_DDRP0:        equ    %00000001
mDDRP_DDRP1:        equ    %00000010
mDDRP_DDRP2:        equ    %00000100
mDDRP_DDRP3:        equ    %00001000
mDDRP_DDRP4:        equ    %00010000
mDDRP_DDRP5:        equ    %00100000
mDDRP_DDRP6:        equ    %01000000
mDDRP_DDRP7:        equ    %10000000


;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
RDRP:               equ    $0000025B                                ;*** RDRP - Port P Reduced Drive Register; 0x0000025B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRP_RDRP0:         equ    0                                         ; Reduced Drive Port P Bit 0
RDRP_RDRP1:         equ    1                                         ; Reduced Drive Port P Bit 1
RDRP_RDRP2:         equ    2                                         ; Reduced Drive Port P Bit 2
RDRP_RDRP3:         equ    3                                         ; Reduced Drive Port P Bit 3
RDRP_RDRP4:         equ    4                                         ; Reduced Drive Port P Bit 4
RDRP_RDRP5:         equ    5                                         ; Reduced Drive Port P Bit 5
RDRP_RDRP6:         equ    6                                         ; Reduced Drive Port P Bit 6
RDRP_RDRP7:         equ    7                                         ; Reduced Drive Port P Bit 7
; bit position masks
mRDRP_RDRP0:        equ    %00000001
mRDRP_RDRP1:        equ    %00000010
mRDRP_RDRP2:        equ    %00000100
mRDRP_RDRP3:        equ    %00001000
mRDRP_RDRP4:        equ    %00010000
mRDRP_RDRP5:        equ    %00100000
mRDRP_RDRP6:        equ    %01000000
mRDRP_RDRP7:        equ    %10000000


;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
PERP:               equ    $0000025C                                ;*** PERP - Port P Pull Device Enable Register; 0x0000025C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERP_PERP0:         equ    0                                         ; Pull Device Enable Port P Bit 0
PERP_PERP1:         equ    1                                         ; Pull Device Enable Port P Bit 1
PERP_PERP2:         equ    2                                         ; Pull Device Enable Port P Bit 2
PERP_PERP3:         equ    3                                         ; Pull Device Enable Port P Bit 3
PERP_PERP4:         equ    4                                         ; Pull Device Enable Port P Bit 4
PERP_PERP5:         equ    5                                         ; Pull Device Enable Port P Bit 5
PERP_PERP6:         equ    6                                         ; Pull Device Enable Port P Bit 6
PERP_PERP7:         equ    7                                         ; Pull Device Enable Port P Bit 7
; bit position masks
mPERP_PERP0:        equ    %00000001
mPERP_PERP1:        equ    %00000010
mPERP_PERP2:        equ    %00000100
mPERP_PERP3:        equ    %00001000
mPERP_PERP4:        equ    %00010000
mPERP_PERP5:        equ    %00100000
mPERP_PERP6:        equ    %01000000
mPERP_PERP7:        equ    %10000000


;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
PPSP:               equ    $0000025D                                ;*** PPSP - Port P Polarity Select Register; 0x0000025D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSP_PPSP0:         equ    0                                         ; Pull Select Port P Bit 0
PPSP_PPSP1:         equ    1                                         ; Pull Select Port P Bit 1
PPSP_PPSP2:         equ    2                                         ; Pull Select Port P Bit 2
PPSP_PPSP3:         equ    3                                         ; Pull Select Port P Bit 3
PPSP_PPSP4:         equ    4                                         ; Pull Select Port P Bit 4
PPSP_PPSP5:         equ    5                                         ; Pull Select Port P Bit 5
PPSP_PPSP6:         equ    6                                         ; Pull Select Port P Bit 6
PPSP_PPSP7:         equ    7                                         ; Pull Select Port P Bit 7
; bit position masks
mPPSP_PPSP0:        equ    %00000001
mPPSP_PPSP1:        equ    %00000010
mPPSP_PPSP2:        equ    %00000100
mPPSP_PPSP3:        equ    %00001000
mPPSP_PPSP4:        equ    %00010000
mPPSP_PPSP5:        equ    %00100000
mPPSP_PPSP6:        equ    %01000000
mPPSP_PPSP7:        equ    %10000000


;*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***
PIEP:               equ    $0000025E                                ;*** PIEP - Port P Interrupt Enable Register; 0x0000025E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEP_PIEP0:         equ    0                                         ; Interrupt Enable Port P Bit 0
PIEP_PIEP1:         equ    1                                         ; Interrupt Enable Port P Bit 1
PIEP_PIEP2:         equ    2                                         ; Interrupt Enable Port P Bit 2
PIEP_PIEP3:         equ    3                                         ; Interrupt Enable Port P Bit 3
PIEP_PIEP4:         equ    4                                         ; Interrupt Enable Port P Bit 4
PIEP_PIEP5:         equ    5                                         ; Interrupt Enable Port P Bit 5
PIEP_PIEP6:         equ    6                                         ; Interrupt Enable Port P Bit 6
PIEP_PIEP7:         equ    7                                         ; Interrupt Enable Port P Bit 7
; bit position masks
mPIEP_PIEP0:        equ    %00000001
mPIEP_PIEP1:        equ    %00000010
mPIEP_PIEP2:        equ    %00000100
mPIEP_PIEP3:        equ    %00001000
mPIEP_PIEP4:        equ    %00010000
mPIEP_PIEP5:        equ    %00100000
mPIEP_PIEP6:        equ    %01000000
mPIEP_PIEP7:        equ    %10000000


;*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***
PIFP:               equ    $0000025F                                ;*** PIFP - Port P Interrupt Flag Register; 0x0000025F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFP_PIFP0:         equ    0                                         ; Interrupt Flags Port P Bit 0
PIFP_PIFP1:         equ    1                                         ; Interrupt Flags Port P Bit 1
PIFP_PIFP2:         equ    2                                         ; Interrupt Flags Port P Bit 2
PIFP_PIFP3:         equ    3                                         ; Interrupt Flags Port P Bit 3
PIFP_PIFP4:         equ    4                                         ; Interrupt Flags Port P Bit 4
PIFP_PIFP5:         equ    5                                         ; Interrupt Flags Port P Bit 5
PIFP_PIFP6:         equ    6                                         ; Interrupt Flags Port P Bit 6
PIFP_PIFP7:         equ    7                                         ; Interrupt Flags Port P Bit 7
; bit position masks
mPIFP_PIFP0:        equ    %00000001
mPIFP_PIFP1:        equ    %00000010
mPIFP_PIFP2:        equ    %00000100
mPIFP_PIFP3:        equ    %00001000
mPIFP_PIFP4:        equ    %00010000
mPIFP_PIFP5:        equ    %00100000
mPIFP_PIFP6:        equ    %01000000
mPIFP_PIFP7:        equ    %10000000


;*** PTH - Port H I/O Register; 0x00000260 ***
PTH:                equ    $00000260                                ;*** PTH - Port H I/O Register; 0x00000260 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTH_PTH0:           equ    0                                         ; Port H Bit 0
PTH_PTH1:           equ    1                                         ; Port H Bit 1
PTH_PTH2:           equ    2                                         ; Port H Bit 2
PTH_PTH3:           equ    3                                         ; Port H Bit 3
PTH_PTH4:           equ    4                                         ; Port H Bit 4
PTH_PTH5:           equ    5                                         ; Port H Bit 5
PTH_PTH6:           equ    6                                         ; Port H Bit 6
PTH_PTH7:           equ    7                                         ; Port H Bit 7
; bit position masks
mPTH_PTH0:          equ    %00000001
mPTH_PTH1:          equ    %00000010
mPTH_PTH2:          equ    %00000100
mPTH_PTH3:          equ    %00001000
mPTH_PTH4:          equ    %00010000
mPTH_PTH5:          equ    %00100000
mPTH_PTH6:          equ    %01000000
mPTH_PTH7:          equ    %10000000


;*** PTIH - Port H Input Register; 0x00000261 ***
PTIH:               equ    $00000261                                ;*** PTIH - Port H Input Register; 0x00000261 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIH_PTIH0:         equ    0                                         ; Port H Bit 0
PTIH_PTIH1:         equ    1                                         ; Port H Bit 1
PTIH_PTIH2:         equ    2                                         ; Port H Bit 2
PTIH_PTIH3:         equ    3                                         ; Port H Bit 3
PTIH_PTIH4:         equ    4                                         ; Port H Bit 4
PTIH_PTIH5:         equ    5                                         ; Port H Bit 5
PTIH_PTIH6:         equ    6                                         ; Port H Bit 6
PTIH_PTIH7:         equ    7                                         ; Port H Bit 7
; bit position masks
mPTIH_PTIH0:        equ    %00000001
mPTIH_PTIH1:        equ    %00000010
mPTIH_PTIH2:        equ    %00000100
mPTIH_PTIH3:        equ    %00001000
mPTIH_PTIH4:        equ    %00010000
mPTIH_PTIH5:        equ    %00100000
mPTIH_PTIH6:        equ    %01000000
mPTIH_PTIH7:        equ    %10000000


;*** DDRH - Port H Data Direction Register; 0x00000262 ***
DDRH:               equ    $00000262                                ;*** DDRH - Port H Data Direction Register; 0x00000262 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRH_DDRH0:         equ    0                                         ; Data Direction Port H Bit 0
DDRH_DDRH1:         equ    1                                         ; Data Direction Port H Bit 1
DDRH_DDRH2:         equ    2                                         ; Data Direction Port H Bit 2
DDRH_DDRH3:         equ    3                                         ; Data Direction Port H Bit 3
DDRH_DDRH4:         equ    4                                         ; Data Direction Port H Bit 4
DDRH_DDRH5:         equ    5                                         ; Data Direction Port H Bit 5
DDRH_DDRH6:         equ    6                                         ; Data Direction Port H Bit 6
DDRH_DDRH7:         equ    7                                         ; Data Direction Port H Bit 7
; bit position masks
mDDRH_DDRH0:        equ    %00000001
mDDRH_DDRH1:        equ    %00000010
mDDRH_DDRH2:        equ    %00000100
mDDRH_DDRH3:        equ    %00001000
mDDRH_DDRH4:        equ    %00010000
mDDRH_DDRH5:        equ    %00100000
mDDRH_DDRH6:        equ    %01000000
mDDRH_DDRH7:        equ    %10000000


;*** RDRH - Port H Reduced Drive Register; 0x00000263 ***
RDRH:               equ    $00000263                                ;*** RDRH - Port H Reduced Drive Register; 0x00000263 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRH_RDRH0:         equ    0                                         ; Reduced Drive Port H Bit 0
RDRH_RDRH1:         equ    1                                         ; Reduced Drive Port H Bit 1
RDRH_RDRH2:         equ    2                                         ; Reduced Drive Port H Bit 2
RDRH_RDRH3:         equ    3                                         ; Reduced Drive Port H Bit 3
RDRH_RDRH4:         equ    4                                         ; Reduced Drive Port H Bit 4
RDRH_RDRH5:         equ    5                                         ; Reduced Drive Port H Bit 5
RDRH_RDRH6:         equ    6                                         ; Reduced Drive Port H Bit 6
RDRH_RDRH7:         equ    7                                         ; Reduced Drive Port H Bit 7
; bit position masks
mRDRH_RDRH0:        equ    %00000001
mRDRH_RDRH1:        equ    %00000010
mRDRH_RDRH2:        equ    %00000100
mRDRH_RDRH3:        equ    %00001000
mRDRH_RDRH4:        equ    %00010000
mRDRH_RDRH5:        equ    %00100000
mRDRH_RDRH6:        equ    %01000000
mRDRH_RDRH7:        equ    %10000000


;*** PERH - Port H Pull Device Enable Register; 0x00000264 ***
PERH:               equ    $00000264                                ;*** PERH - Port H Pull Device Enable Register; 0x00000264 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERH_PERH0:         equ    0                                         ; Pull Device Enable Port H Bit 0
PERH_PERH1:         equ    1                                         ; Pull Device Enable Port H Bit 1
PERH_PERH2:         equ    2                                         ; Pull Device Enable Port H Bit 2
PERH_PERH3:         equ    3                                         ; Pull Device Enable Port H Bit 3
PERH_PERH4:         equ    4                                         ; Pull Device Enable Port H Bit 4
PERH_PERH5:         equ    5                                         ; Pull Device Enable Port H Bit 5
PERH_PERH6:         equ    6                                         ; Pull Device Enable Port H Bit 6
PERH_PERH7:         equ    7                                         ; Pull Device Enable Port H Bit 7
; bit position masks
mPERH_PERH0:        equ    %00000001
mPERH_PERH1:        equ    %00000010
mPERH_PERH2:        equ    %00000100
mPERH_PERH3:        equ    %00001000
mPERH_PERH4:        equ    %00010000
mPERH_PERH5:        equ    %00100000
mPERH_PERH6:        equ    %01000000
mPERH_PERH7:        equ    %10000000


;*** PPSH - Port H Polarity Select Register; 0x00000265 ***
PPSH:               equ    $00000265                                ;*** PPSH - Port H Polarity Select Register; 0x00000265 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSH_PPSH0:         equ    0                                         ; Pull Select Port H Bit 0
PPSH_PPSH1:         equ    1                                         ; Pull Select Port H Bit 1
PPSH_PPSH2:         equ    2                                         ; Pull Select Port H Bit 2
PPSH_PPSH3:         equ    3                                         ; Pull Select Port H Bit 3
PPSH_PPSH4:         equ    4                                         ; Pull Select Port H Bit 4
PPSH_PPSH5:         equ    5                                         ; Pull Select Port H Bit 5
PPSH_PPSH6:         equ    6                                         ; Pull Select Port H Bit 6
PPSH_PPSH7:         equ    7                                         ; Pull Select Port H Bit 7
; bit position masks
mPPSH_PPSH0:        equ    %00000001
mPPSH_PPSH1:        equ    %00000010
mPPSH_PPSH2:        equ    %00000100
mPPSH_PPSH3:        equ    %00001000
mPPSH_PPSH4:        equ    %00010000
mPPSH_PPSH5:        equ    %00100000
mPPSH_PPSH6:        equ    %01000000
mPPSH_PPSH7:        equ    %10000000


;*** PIEH - Port H Interrupt Enable Register; 0x00000266 ***
PIEH:               equ    $00000266                                ;*** PIEH - Port H Interrupt Enable Register; 0x00000266 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEH_PIEH0:         equ    0                                         ; Interrupt Enable Port H Bit 0
PIEH_PIEH1:         equ    1                                         ; Interrupt Enable Port H Bit 1
PIEH_PIEH2:         equ    2                                         ; Interrupt Enable Port H Bit 2
PIEH_PIEH3:         equ    3                                         ; Interrupt Enable Port H Bit 3
PIEH_PIEH4:         equ    4                                         ; Interrupt Enable Port H Bit 4
PIEH_PIEH5:         equ    5                                         ; Interrupt Enable Port H Bit 5
PIEH_PIEH6:         equ    6                                         ; Interrupt Enable Port H Bit 6
PIEH_PIEH7:         equ    7                                         ; Interrupt Enable Port H Bit 7
; bit position masks
mPIEH_PIEH0:        equ    %00000001
mPIEH_PIEH1:        equ    %00000010
mPIEH_PIEH2:        equ    %00000100
mPIEH_PIEH3:        equ    %00001000
mPIEH_PIEH4:        equ    %00010000
mPIEH_PIEH5:        equ    %00100000
mPIEH_PIEH6:        equ    %01000000
mPIEH_PIEH7:        equ    %10000000


;*** PIFH - Port H Interrupt Flag Register; 0x00000267 ***
PIFH:               equ    $00000267                                ;*** PIFH - Port H Interrupt Flag Register; 0x00000267 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFH_PIFH0:         equ    0                                         ; Interrupt Flags Port H Bit 0
PIFH_PIFH1:         equ    1                                         ; Interrupt Flags Port H Bit 1
PIFH_PIFH2:         equ    2                                         ; Interrupt Flags Port H Bit 2
PIFH_PIFH3:         equ    3                                         ; Interrupt Flags Port H Bit 3
PIFH_PIFH4:         equ    4                                         ; Interrupt Flags Port H Bit 4
PIFH_PIFH5:         equ    5                                         ; Interrupt Flags Port H Bit 5
PIFH_PIFH6:         equ    6                                         ; Interrupt Flags Port H Bit 6
PIFH_PIFH7:         equ    7                                         ; Interrupt Flags Port H Bit 7
; bit position masks
mPIFH_PIFH0:        equ    %00000001
mPIFH_PIFH1:        equ    %00000010
mPIFH_PIFH2:        equ    %00000100
mPIFH_PIFH3:        equ    %00001000
mPIFH_PIFH4:        equ    %00010000
mPIFH_PIFH5:        equ    %00100000
mPIFH_PIFH6:        equ    %01000000
mPIFH_PIFH7:        equ    %10000000


;*** PTJ - Port J I/O Register; 0x00000268 ***
PTJ:                equ    $00000268                                ;*** PTJ - Port J I/O Register; 0x00000268 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTJ_PTJ0:           equ    0                                         ; Port J Bit 0
PTJ_PTJ1:           equ    1                                         ; Port J Bit 1
PTJ_PTJ2:           equ    2                                         ; Port J Bit 2
PTJ_PTJ4:           equ    4                                         ; Port J Bit 4
PTJ_PTJ5:           equ    5                                         ; Port J Bit 5
PTJ_PTJ6:           equ    6                                         ; Port J Bit 6
PTJ_PTJ7:           equ    7                                         ; Port J Bit 7
; bit position masks
mPTJ_PTJ0:          equ    %00000001
mPTJ_PTJ1:          equ    %00000010
mPTJ_PTJ2:          equ    %00000100
mPTJ_PTJ4:          equ    %00010000
mPTJ_PTJ5:          equ    %00100000
mPTJ_PTJ6:          equ    %01000000
mPTJ_PTJ7:          equ    %10000000


;*** PTIJ - Port J Input Register; 0x00000269 ***
PTIJ:               equ    $00000269                                ;*** PTIJ - Port J Input Register; 0x00000269 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTIJ_PTIJ0:         equ    0                                         ; Port J Bit 0
PTIJ_PTIJ1:         equ    1                                         ; Port J Bit 1
PTIJ_PTIJ2:         equ    2                                         ; Port J Bit 2
PTIJ_PTIJ4:         equ    4                                         ; Port J Bit 4
PTIJ_PTIJ5:         equ    5                                         ; Port J Bit 5
PTIJ_PTIJ6:         equ    6                                         ; Port J Bit 6
PTIJ_PTIJ7:         equ    7                                         ; Port J Bit 7
; bit position masks
mPTIJ_PTIJ0:        equ    %00000001
mPTIJ_PTIJ1:        equ    %00000010
mPTIJ_PTIJ2:        equ    %00000100
mPTIJ_PTIJ4:        equ    %00010000
mPTIJ_PTIJ5:        equ    %00100000
mPTIJ_PTIJ6:        equ    %01000000
mPTIJ_PTIJ7:        equ    %10000000


;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
DDRJ:               equ    $0000026A                                ;*** DDRJ - Port J Data Direction Register; 0x0000026A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDRJ_DDRJ0:         equ    0                                         ; Data Direction Port J Bit 0
DDRJ_DDRJ1:         equ    1                                         ; Data Direction Port J Bit 1
DDRJ_DDRJ2:         equ    2                                         ; Data Direction Port J Bit 2
DDRJ_DDRJ4:         equ    4                                         ; Data Direction Port J Bit 4
DDRJ_DDRJ5:         equ    5                                         ; Data Direction Port J Bit 5
DDRJ_DDRJ6:         equ    6                                         ; Data Direction Port J Bit 6
DDRJ_DDRJ7:         equ    7                                         ; Data Direction Port J Bit 7
; bit position masks
mDDRJ_DDRJ0:        equ    %00000001
mDDRJ_DDRJ1:        equ    %00000010
mDDRJ_DDRJ2:        equ    %00000100
mDDRJ_DDRJ4:        equ    %00010000
mDDRJ_DDRJ5:        equ    %00100000
mDDRJ_DDRJ6:        equ    %01000000
mDDRJ_DDRJ7:        equ    %10000000


;*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***
RDRJ:               equ    $0000026B                                ;*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDRJ_RDRJ0:         equ    0                                         ; Reduced Drive Port J Bit 0
RDRJ_RDRJ1:         equ    1                                         ; Reduced Drive Port J Bit 1
RDRJ_RDRJ2:         equ    2                                         ; Reduced Drive Port J Bit 2
RDRJ_RDRJ4:         equ    4                                         ; Reduced Drive Port J Bit 4
RDRJ_RDRJ5:         equ    5                                         ; Reduced Drive Port J Bit 5
RDRJ_RDRJ6:         equ    6                                         ; Reduced Drive Port J Bit 6
RDRJ_RDRJ7:         equ    7                                         ; Reduced Drive Port J Bit 7
; bit position masks
mRDRJ_RDRJ0:        equ    %00000001
mRDRJ_RDRJ1:        equ    %00000010
mRDRJ_RDRJ2:        equ    %00000100
mRDRJ_RDRJ4:        equ    %00010000
mRDRJ_RDRJ5:        equ    %00100000
mRDRJ_RDRJ6:        equ    %01000000
mRDRJ_RDRJ7:        equ    %10000000


;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
PERJ:               equ    $0000026C                                ;*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PERJ_PERJ0:         equ    0                                         ; Pull Device Enable Port J Bit 0
PERJ_PERJ1:         equ    1                                         ; Pull Device Enable Port J Bit 1
PERJ_PERJ2:         equ    2                                         ; Pull Device Enable Port J Bit 2
PERJ_PERJ4:         equ    4                                         ; Pull Device Enable Port J Bit 4
PERJ_PERJ5:         equ    5                                         ; Pull Device Enable Port J Bit 5
PERJ_PERJ6:         equ    6                                         ; Pull Device Enable Port J Bit 6
PERJ_PERJ7:         equ    7                                         ; Pull Device Enable Port J Bit 7
; bit position masks
mPERJ_PERJ0:        equ    %00000001
mPERJ_PERJ1:        equ    %00000010
mPERJ_PERJ2:        equ    %00000100
mPERJ_PERJ4:        equ    %00010000
mPERJ_PERJ5:        equ    %00100000
mPERJ_PERJ6:        equ    %01000000
mPERJ_PERJ7:        equ    %10000000


;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
PPSJ:               equ    $0000026D                                ;*** PPSJ - Port J Polarity Select Register; 0x0000026D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPSJ_PPSJ0:         equ    0                                         ; Pull Select Port J Bit 0
PPSJ_PPSJ1:         equ    1                                         ; Pull Select Port J Bit 1
PPSJ_PPSJ2:         equ    2                                         ; Pull Select Port J Bit 2
PPSJ_PPSJ4:         equ    4                                         ; Pull Select Port J Bit 4
PPSJ_PPSJ5:         equ    5                                         ; Pull Select Port J Bit 5
PPSJ_PPSJ6:         equ    6                                         ; Pull Select Port J Bit 6
PPSJ_PPSJ7:         equ    7                                         ; Pull Select Port J Bit 7
; bit position masks
mPPSJ_PPSJ0:        equ    %00000001
mPPSJ_PPSJ1:        equ    %00000010
mPPSJ_PPSJ2:        equ    %00000100
mPPSJ_PPSJ4:        equ    %00010000
mPPSJ_PPSJ5:        equ    %00100000
mPPSJ_PPSJ6:        equ    %01000000
mPPSJ_PPSJ7:        equ    %10000000


;*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***
PIEJ:               equ    $0000026E                                ;*** PIEJ - Port J Interrupt Enable Register; 0x0000026E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIEJ_PIEJ0:         equ    0                                         ; Interrupt Enable Port J Bit 0
PIEJ_PIEJ1:         equ    1                                         ; Interrupt Enable Port J Bit 1
PIEJ_PIEJ2:         equ    2                                         ; Interrupt Enable Port J Bit 2
PIEJ_PIEJ4:         equ    4                                         ; Interrupt Enable Port J Bit 4
PIEJ_PIEJ5:         equ    5                                         ; Interrupt Enable Port J Bit 5
PIEJ_PIEJ6:         equ    6                                         ; Interrupt Enable Port J Bit 6
PIEJ_PIEJ7:         equ    7                                         ; Interrupt Enable Port J Bit 7
; bit position masks
mPIEJ_PIEJ0:        equ    %00000001
mPIEJ_PIEJ1:        equ    %00000010
mPIEJ_PIEJ2:        equ    %00000100
mPIEJ_PIEJ4:        equ    %00010000
mPIEJ_PIEJ5:        equ    %00100000
mPIEJ_PIEJ6:        equ    %01000000
mPIEJ_PIEJ7:        equ    %10000000


;*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***
PIFJ:               equ    $0000026F                                ;*** PIFJ - Port J Interrupt Flag Register; 0x0000026F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PIFJ_PIFJ0:         equ    0                                         ; Interrupt Flags Port J Bit 0
PIFJ_PIFJ1:         equ    1                                         ; Interrupt Flags Port J Bit 1
PIFJ_PIFJ2:         equ    2                                         ; Interrupt Flags Port J Bit 2
PIFJ_PIFJ4:         equ    4                                         ; Interrupt Flags Port J Bit 4
PIFJ_PIFJ5:         equ    5                                         ; Interrupt Flags Port J Bit 5
PIFJ_PIFJ6:         equ    6                                         ; Interrupt Flags Port J Bit 6
PIFJ_PIFJ7:         equ    7                                         ; Interrupt Flags Port J Bit 7
; bit position masks
mPIFJ_PIFJ0:        equ    %00000001
mPIFJ_PIFJ1:        equ    %00000010
mPIFJ_PIFJ2:        equ    %00000100
mPIFJ_PIFJ4:        equ    %00010000
mPIFJ_PIFJ5:        equ    %00100000
mPIFJ_PIFJ6:        equ    %01000000
mPIFJ_PIFJ7:        equ    %10000000


;*** PT1AD0 - Port AD0 Data Register 1; 0x00000271 ***
PT1AD0:             equ    $00000271                                ;*** PT1AD0 - Port AD0 Data Register 1; 0x00000271 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT1AD0_PT1AD00:     equ    0                                         ; Port AD0 Data Bit 0
PT1AD0_PT1AD01:     equ    1                                         ; Port AD0 Data Bit 1
PT1AD0_PT1AD02:     equ    2                                         ; Port AD0 Data Bit 2
PT1AD0_PT1AD03:     equ    3                                         ; Port AD0 Data Bit 3
PT1AD0_PT1AD04:     equ    4                                         ; Port AD0 Data Bit 4
PT1AD0_PT1AD05:     equ    5                                         ; Port AD0 Data Bit 5
PT1AD0_PT1AD06:     equ    6                                         ; Port AD0 Data Bit 6
PT1AD0_PT1AD07:     equ    7                                         ; Port AD0 Data Bit 7
; bit position masks
mPT1AD0_PT1AD00:    equ    %00000001
mPT1AD0_PT1AD01:    equ    %00000010
mPT1AD0_PT1AD02:    equ    %00000100
mPT1AD0_PT1AD03:    equ    %00001000
mPT1AD0_PT1AD04:    equ    %00010000
mPT1AD0_PT1AD05:    equ    %00100000
mPT1AD0_PT1AD06:    equ    %01000000
mPT1AD0_PT1AD07:    equ    %10000000


;*** DDR1AD0 - Port AD0 Data Direction Register 1; 0x00000273 ***
DDR1AD0:            equ    $00000273                                ;*** DDR1AD0 - Port AD0 Data Direction Register 1; 0x00000273 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR1AD0_DDR1AD00:   equ    0                                         ; Port AD0 Data Direction Bit 0
DDR1AD0_DDR1AD01:   equ    1                                         ; Port AD0 Data Direction Bit 1
DDR1AD0_DDR1AD02:   equ    2                                         ; Port AD0 Data Direction Bit 2
DDR1AD0_DDR1AD03:   equ    3                                         ; Port AD0 Data Direction Bit 3
DDR1AD0_DDR1AD04:   equ    4                                         ; Port AD0 Data Direction Bit 4
DDR1AD0_DDR1AD05:   equ    5                                         ; Port AD0 Data Direction Bit 5
DDR1AD0_DDR1AD06:   equ    6                                         ; Port AD0 Data Direction Bit 6
DDR1AD0_DDR1AD07:   equ    7                                         ; Port AD0 Data Direction Bit 7
; bit position masks
mDDR1AD0_DDR1AD00:  equ    %00000001
mDDR1AD0_DDR1AD01:  equ    %00000010
mDDR1AD0_DDR1AD02:  equ    %00000100
mDDR1AD0_DDR1AD03:  equ    %00001000
mDDR1AD0_DDR1AD04:  equ    %00010000
mDDR1AD0_DDR1AD05:  equ    %00100000
mDDR1AD0_DDR1AD06:  equ    %01000000
mDDR1AD0_DDR1AD07:  equ    %10000000


;*** RDR1AD0 - Port AD0 Reduced Drive Register 1; 0x00000275 ***
RDR1AD0:            equ    $00000275                                ;*** RDR1AD0 - Port AD0 Reduced Drive Register 1; 0x00000275 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDR1AD0_RDR1AD00:   equ    0                                         ; Port AD0 Reduced Drive Bit 0
RDR1AD0_RDR1AD01:   equ    1                                         ; Port AD0 Reduced Drive Bit 1
RDR1AD0_RDR1AD02:   equ    2                                         ; Port AD0 Reduced Drive Bit 2
RDR1AD0_RDR1AD03:   equ    3                                         ; Port AD0 Reduced Drive Bit 3
RDR1AD0_RDR1AD04:   equ    4                                         ; Port AD0 Reduced Drive Bit 4
RDR1AD0_RDR1AD05:   equ    5                                         ; Port AD0 Reduced Drive Bit 5
RDR1AD0_RDR1AD06:   equ    6                                         ; Port AD0 Reduced Drive Bit 6
RDR1AD0_RDR1AD07:   equ    7                                         ; Port AD0 Reduced Drive Bit 7
; bit position masks
mRDR1AD0_RDR1AD00:  equ    %00000001
mRDR1AD0_RDR1AD01:  equ    %00000010
mRDR1AD0_RDR1AD02:  equ    %00000100
mRDR1AD0_RDR1AD03:  equ    %00001000
mRDR1AD0_RDR1AD04:  equ    %00010000
mRDR1AD0_RDR1AD05:  equ    %00100000
mRDR1AD0_RDR1AD06:  equ    %01000000
mRDR1AD0_RDR1AD07:  equ    %10000000


;*** PER1AD0 - Port AD0 Pull Up Enable Register 1; 0x00000277 ***
PER1AD0:            equ    $00000277                                ;*** PER1AD0 - Port AD0 Pull Up Enable Register 1; 0x00000277 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER1AD0_PER1AD00:   equ    0                                         ; Port AD0 Pull Up Enable Bit 0
PER1AD0_PER1AD01:   equ    1                                         ; Port AD0 Pull Up Enable Bit 1
PER1AD0_PER1AD02:   equ    2                                         ; Port AD0 Pull Up Enable Bit 2
PER1AD0_PER1AD03:   equ    3                                         ; Port AD0 Pull Up Enable Bit 3
PER1AD0_PER1AD04:   equ    4                                         ; Port AD0 Pull Up Enable Bit 4
PER1AD0_PER1AD05:   equ    5                                         ; Port AD0 Pull Up Enable Bit 5
PER1AD0_PER1AD06:   equ    6                                         ; Port AD0 Pull Up Enable Bit 6
PER1AD0_PER1AD07:   equ    7                                         ; Port AD0 Pull Up Enable Bit 7
; bit position masks
mPER1AD0_PER1AD00:  equ    %00000001
mPER1AD0_PER1AD01:  equ    %00000010
mPER1AD0_PER1AD02:  equ    %00000100
mPER1AD0_PER1AD03:  equ    %00001000
mPER1AD0_PER1AD04:  equ    %00010000
mPER1AD0_PER1AD05:  equ    %00100000
mPER1AD0_PER1AD06:  equ    %01000000
mPER1AD0_PER1AD07:  equ    %10000000


;*** PT01AD1 - Port AD1 Data Register; 0x00000278 ***
PT01AD1:            equ    $00000278                                ;*** PT01AD1 - Port AD1 Data Register; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT01AD1_PT1AD18:    equ    0                                         ; Port AD1 Data Bit 8
PT01AD1_PT1AD19:    equ    1                                         ; Port AD1 Data Bit 9
PT01AD1_PT1AD110:   equ    2                                         ; Port AD1 Data Bit 10
PT01AD1_PT1AD111:   equ    3                                         ; Port AD1 Data Bit 11
PT01AD1_PT1AD112:   equ    4                                         ; Port AD1 Data Bit 12
PT01AD1_PT1AD113:   equ    5                                         ; Port AD1 Data Bit 13
PT01AD1_PT1AD114:   equ    6                                         ; Port AD1 Data Bit 14
PT01AD1_PT1AD115:   equ    7                                         ; Port AD1 Data Bit 15
PT01AD1_PT0AD116:   equ    8                                         ; Port AD1 Data Bit 16
PT01AD1_PT0AD117:   equ    9                                         ; Port AD1 Data Bit 17
PT01AD1_PT0AD118:   equ    10                                        ; Port AD1 Data Bit 18
PT01AD1_PT0AD119:   equ    11                                        ; Port AD1 Data Bit 19
PT01AD1_PT0AD120:   equ    12                                        ; Port AD1 Data Bit 20
PT01AD1_PT0AD121:   equ    13                                        ; Port AD1 Data Bit 21
PT01AD1_PT0AD122:   equ    14                                        ; Port AD1 Data Bit 22
PT01AD1_PT0AD123:   equ    15                                        ; Port AD1 Data Bit 23
; bit position masks
mPT01AD1_PT1AD18:   equ    %00000001
mPT01AD1_PT1AD19:   equ    %00000010
mPT01AD1_PT1AD110:  equ    %00000100
mPT01AD1_PT1AD111:  equ    %00001000
mPT01AD1_PT1AD112:  equ    %00010000
mPT01AD1_PT1AD113:  equ    %00100000
mPT01AD1_PT1AD114:  equ    %01000000
mPT01AD1_PT1AD115:  equ    %10000000
mPT01AD1_PT0AD116:  equ    %100000000
mPT01AD1_PT0AD117:  equ    %1000000000
mPT01AD1_PT0AD118:  equ    %10000000000
mPT01AD1_PT0AD119:  equ    %100000000000
mPT01AD1_PT0AD120:  equ    %1000000000000
mPT01AD1_PT0AD121:  equ    %10000000000000
mPT01AD1_PT0AD122:  equ    %100000000000000
mPT01AD1_PT0AD123:  equ    %1000000000000000


;*** PT0AD1 - Port AD1 Data Register 0; 0x00000278 ***
PT0AD1:             equ    $00000278                                ;*** PT0AD1 - Port AD1 Data Register 0; 0x00000278 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT0AD1_PT0AD116:    equ    0                                         ; Port AD1 Data Bit 16
PT0AD1_PT0AD117:    equ    1                                         ; Port AD1 Data Bit 17
PT0AD1_PT0AD118:    equ    2                                         ; Port AD1 Data Bit 18
PT0AD1_PT0AD119:    equ    3                                         ; Port AD1 Data Bit 19
PT0AD1_PT0AD120:    equ    4                                         ; Port AD1 Data Bit 20
PT0AD1_PT0AD121:    equ    5                                         ; Port AD1 Data Bit 21
PT0AD1_PT0AD122:    equ    6                                         ; Port AD1 Data Bit 22
PT0AD1_PT0AD123:    equ    7                                         ; Port AD1 Data Bit 23
; bit position masks
mPT0AD1_PT0AD116:   equ    %00000001
mPT0AD1_PT0AD117:   equ    %00000010
mPT0AD1_PT0AD118:   equ    %00000100
mPT0AD1_PT0AD119:   equ    %00001000
mPT0AD1_PT0AD120:   equ    %00010000
mPT0AD1_PT0AD121:   equ    %00100000
mPT0AD1_PT0AD122:   equ    %01000000
mPT0AD1_PT0AD123:   equ    %10000000


;*** PT1AD1 - Port AD1 Data Register 1; 0x00000279 ***
PT1AD1:             equ    $00000279                                ;*** PT1AD1 - Port AD1 Data Register 1; 0x00000279 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PT1AD1_PT1AD18:     equ    0                                         ; Port AD1 Data Bit 8
PT1AD1_PT1AD19:     equ    1                                         ; Port AD1 Data Bit 9
PT1AD1_PT1AD110:    equ    2                                         ; Port AD1 Data Bit 10
PT1AD1_PT1AD111:    equ    3                                         ; Port AD1 Data Bit 11
PT1AD1_PT1AD112:    equ    4                                         ; Port AD1 Data Bit 12
PT1AD1_PT1AD113:    equ    5                                         ; Port AD1 Data Bit 13
PT1AD1_PT1AD114:    equ    6                                         ; Port AD1 Data Bit 14
PT1AD1_PT1AD115:    equ    7                                         ; Port AD1 Data Bit 15
; bit position masks
mPT1AD1_PT1AD18:    equ    %00000001
mPT1AD1_PT1AD19:    equ    %00000010
mPT1AD1_PT1AD110:   equ    %00000100
mPT1AD1_PT1AD111:   equ    %00001000
mPT1AD1_PT1AD112:   equ    %00010000
mPT1AD1_PT1AD113:   equ    %00100000
mPT1AD1_PT1AD114:   equ    %01000000
mPT1AD1_PT1AD115:   equ    %10000000


;*** DDR01AD1 - Port AD1 Data Direction Register; 0x0000027A ***
DDR01AD1:           equ    $0000027A                                ;*** DDR01AD1 - Port AD1 Data Direction Register; 0x0000027A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR01AD1_DDR1AD18:  equ    0                                         ; Port AD1 Data Direction Bit 8
DDR01AD1_DDR1AD19:  equ    1                                         ; Port AD1 Data Direction Bit 9
DDR01AD1_DDR1AD110: equ    2                                         ; Port AD1 Data Direction Bit 10
DDR01AD1_DDR1AD111: equ    3                                         ; Port AD1 Data Direction Bit 11
DDR01AD1_DDR1AD112: equ    4                                         ; Port AD1 Data Direction Bit 12
DDR01AD1_DDR1AD113: equ    5                                         ; Port AD1 Data Direction Bit 13
DDR01AD1_DDR1AD114: equ    6                                         ; Port AD1 Data Direction Bit 14
DDR01AD1_DDR1AD115: equ    7                                         ; Port AD1 Data Direction Bit 15
DDR01AD1_DDR0AD116: equ    8                                         ; Port AD1 Data Direction Bit 16
DDR01AD1_DDR0AD117: equ    9                                         ; Port AD1 Data Direction Bit 17
DDR01AD1_DDR0AD118: equ    10                                        ; Port AD1 Data Direction Bit 18
DDR01AD1_DDR0AD119: equ    11                                        ; Port AD1 Data Direction Bit 19
DDR01AD1_DDR0AD120: equ    12                                        ; Port AD1 Data Direction Bit 20
DDR01AD1_DDR0AD121: equ    13                                        ; Port AD1 Data Direction Bit 21
DDR01AD1_DDR0AD122: equ    14                                        ; Port AD1 Data Direction Bit 22
DDR01AD1_DDR0AD123: equ    15                                        ; Port AD1 Data Direction Bit 23
; bit position masks
mDDR01AD1_DDR1AD18: equ    %00000001
mDDR01AD1_DDR1AD19: equ    %00000010
mDDR01AD1_DDR1AD110: equ    %00000100
mDDR01AD1_DDR1AD111: equ    %00001000
mDDR01AD1_DDR1AD112: equ    %00010000
mDDR01AD1_DDR1AD113: equ    %00100000
mDDR01AD1_DDR1AD114: equ    %01000000
mDDR01AD1_DDR1AD115: equ    %10000000
mDDR01AD1_DDR0AD116: equ    %100000000
mDDR01AD1_DDR0AD117: equ    %1000000000
mDDR01AD1_DDR0AD118: equ    %10000000000
mDDR01AD1_DDR0AD119: equ    %100000000000
mDDR01AD1_DDR0AD120: equ    %1000000000000
mDDR01AD1_DDR0AD121: equ    %10000000000000
mDDR01AD1_DDR0AD122: equ    %100000000000000
mDDR01AD1_DDR0AD123: equ    %1000000000000000


;*** DDR0AD1 - Port AD1 Data Direction Register 0; 0x0000027A ***
DDR0AD1:            equ    $0000027A                                ;*** DDR0AD1 - Port AD1 Data Direction Register 0; 0x0000027A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR0AD1_DDR0AD116:  equ    0                                         ; Port AD1 Data Direction Bit 16
DDR0AD1_DDR0AD117:  equ    1                                         ; Port AD1 Data Direction Bit 17
DDR0AD1_DDR0AD118:  equ    2                                         ; Port AD1 Data Direction Bit 18
DDR0AD1_DDR0AD119:  equ    3                                         ; Port AD1 Data Direction Bit 19
DDR0AD1_DDR0AD120:  equ    4                                         ; Port AD1 Data Direction Bit 20
DDR0AD1_DDR0AD121:  equ    5                                         ; Port AD1 Data Direction Bit 21
DDR0AD1_DDR0AD122:  equ    6                                         ; Port AD1 Data Direction Bit 22
DDR0AD1_DDR0AD123:  equ    7                                         ; Port AD1 Data Direction Bit 23
; bit position masks
mDDR0AD1_DDR0AD116: equ    %00000001
mDDR0AD1_DDR0AD117: equ    %00000010
mDDR0AD1_DDR0AD118: equ    %00000100
mDDR0AD1_DDR0AD119: equ    %00001000
mDDR0AD1_DDR0AD120: equ    %00010000
mDDR0AD1_DDR0AD121: equ    %00100000
mDDR0AD1_DDR0AD122: equ    %01000000
mDDR0AD1_DDR0AD123: equ    %10000000


;*** DDR1AD1 - Port AD1 Data Direction Register 1; 0x0000027B ***
DDR1AD1:            equ    $0000027B                                ;*** DDR1AD1 - Port AD1 Data Direction Register 1; 0x0000027B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DDR1AD1_DDR1AD18:   equ    0                                         ; Port AD1 Data Direction Bit 8
DDR1AD1_DDR1AD19:   equ    1                                         ; Port AD1 Data Direction Bit 9
DDR1AD1_DDR1AD110:  equ    2                                         ; Port AD1 Data Direction Bit 10
DDR1AD1_DDR1AD111:  equ    3                                         ; Port AD1 Data Direction Bit 11
DDR1AD1_DDR1AD112:  equ    4                                         ; Port AD1 Data Direction Bit 12
DDR1AD1_DDR1AD113:  equ    5                                         ; Port AD1 Data Direction Bit 13
DDR1AD1_DDR1AD114:  equ    6                                         ; Port AD1 Data Direction Bit 14
DDR1AD1_DDR1AD115:  equ    7                                         ; Port AD1 Data Direction Bit 15
; bit position masks
mDDR1AD1_DDR1AD18:  equ    %00000001
mDDR1AD1_DDR1AD19:  equ    %00000010
mDDR1AD1_DDR1AD110: equ    %00000100
mDDR1AD1_DDR1AD111: equ    %00001000
mDDR1AD1_DDR1AD112: equ    %00010000
mDDR1AD1_DDR1AD113: equ    %00100000
mDDR1AD1_DDR1AD114: equ    %01000000
mDDR1AD1_DDR1AD115: equ    %10000000


;*** RDR01AD1 - Port AD1 Reduced Drive Register; 0x0000027C ***
RDR01AD1:           equ    $0000027C                                ;*** RDR01AD1 - Port AD1 Reduced Drive Register; 0x0000027C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDR01AD1_RDR1AD18:  equ    0                                         ; Port AD1 Reduced Drive Bit 8
RDR01AD1_RDR1AD19:  equ    1                                         ; Port AD1 Reduced Drive Bit 9
RDR01AD1_RDR1AD110: equ    2                                         ; Port AD1 Reduced Drive Bit 10
RDR01AD1_RDR1AD111: equ    3                                         ; Port AD1 Reduced Drive Bit 11
RDR01AD1_RDR1AD112: equ    4                                         ; Port AD1 Reduced Drive Bit 12
RDR01AD1_RDR1AD113: equ    5                                         ; Port AD1 Reduced Drive Bit 13
RDR01AD1_RDR1AD114: equ    6                                         ; Port AD1 Reduced Drive Bit 14
RDR01AD1_RDR1AD115: equ    7                                         ; Port AD1 Reduced Drive Bit 15
RDR01AD1_RDR0AD116: equ    8                                         ; Port AD1 Reduced Drive Bit 16
RDR01AD1_RDR0AD117: equ    9                                         ; Port AD1 Reduced Drive Bit 17
RDR01AD1_RDR0AD118: equ    10                                        ; Port AD1 Reduced Drive Bit 18
RDR01AD1_RDR0AD119: equ    11                                        ; Port AD1 Reduced Drive Bit 19
RDR01AD1_RDR0AD120: equ    12                                        ; Port AD1 Reduced Drive Bit 20
RDR01AD1_RDR0AD121: equ    13                                        ; Port AD1 Reduced Drive Bit 21
RDR01AD1_RDR0AD122: equ    14                                        ; Port AD1 Reduced Drive Bit 22
RDR01AD1_RDR0AD123: equ    15                                        ; Port AD1 Reduced Drive Bit 23
; bit position masks
mRDR01AD1_RDR1AD18: equ    %00000001
mRDR01AD1_RDR1AD19: equ    %00000010
mRDR01AD1_RDR1AD110: equ    %00000100
mRDR01AD1_RDR1AD111: equ    %00001000
mRDR01AD1_RDR1AD112: equ    %00010000
mRDR01AD1_RDR1AD113: equ    %00100000
mRDR01AD1_RDR1AD114: equ    %01000000
mRDR01AD1_RDR1AD115: equ    %10000000
mRDR01AD1_RDR0AD116: equ    %100000000
mRDR01AD1_RDR0AD117: equ    %1000000000
mRDR01AD1_RDR0AD118: equ    %10000000000
mRDR01AD1_RDR0AD119: equ    %100000000000
mRDR01AD1_RDR0AD120: equ    %1000000000000
mRDR01AD1_RDR0AD121: equ    %10000000000000
mRDR01AD1_RDR0AD122: equ    %100000000000000
mRDR01AD1_RDR0AD123: equ    %1000000000000000


;*** RDR0AD1 - Port AD1 Reduced Drive Register 0; 0x0000027C ***
RDR0AD1:            equ    $0000027C                                ;*** RDR0AD1 - Port AD1 Reduced Drive Register 0; 0x0000027C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDR0AD1_RDR0AD116:  equ    0                                         ; Port AD1 Reduced Drive Bit 16
RDR0AD1_RDR0AD117:  equ    1                                         ; Port AD1 Reduced Drive Bit 17
RDR0AD1_RDR0AD118:  equ    2                                         ; Port AD1 Reduced Drive Bit 18
RDR0AD1_RDR0AD119:  equ    3                                         ; Port AD1 Reduced Drive Bit 19
RDR0AD1_RDR0AD120:  equ    4                                         ; Port AD1 Reduced Drive Bit 20
RDR0AD1_RDR0AD121:  equ    5                                         ; Port AD1 Reduced Drive Bit 21
RDR0AD1_RDR0AD122:  equ    6                                         ; Port AD1 Reduced Drive Bit 22
RDR0AD1_RDR0AD123:  equ    7                                         ; Port AD1 Reduced Drive Bit 23
; bit position masks
mRDR0AD1_RDR0AD116: equ    %00000001
mRDR0AD1_RDR0AD117: equ    %00000010
mRDR0AD1_RDR0AD118: equ    %00000100
mRDR0AD1_RDR0AD119: equ    %00001000
mRDR0AD1_RDR0AD120: equ    %00010000
mRDR0AD1_RDR0AD121: equ    %00100000
mRDR0AD1_RDR0AD122: equ    %01000000
mRDR0AD1_RDR0AD123: equ    %10000000


;*** RDR1AD1 - Port AD1 Reduced Drive Register 1; 0x0000027D ***
RDR1AD1:            equ    $0000027D                                ;*** RDR1AD1 - Port AD1 Reduced Drive Register 1; 0x0000027D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RDR1AD1_RDR1AD18:   equ    0                                         ; Port AD1 Reduced Drive Bit 8
RDR1AD1_RDR1AD19:   equ    1                                         ; Port AD1 Reduced Drive Bit 9
RDR1AD1_RDR1AD110:  equ    2                                         ; Port AD1 Reduced Drive Bit 10
RDR1AD1_RDR1AD111:  equ    3                                         ; Port AD1 Reduced Drive Bit 11
RDR1AD1_RDR1AD112:  equ    4                                         ; Port AD1 Reduced Drive Bit 12
RDR1AD1_RDR1AD113:  equ    5                                         ; Port AD1 Reduced Drive Bit 13
RDR1AD1_RDR1AD114:  equ    6                                         ; Port AD1 Reduced Drive Bit 14
RDR1AD1_RDR1AD115:  equ    7                                         ; Port AD1 Reduced Drive Bit 15
; bit position masks
mRDR1AD1_RDR1AD18:  equ    %00000001
mRDR1AD1_RDR1AD19:  equ    %00000010
mRDR1AD1_RDR1AD110: equ    %00000100
mRDR1AD1_RDR1AD111: equ    %00001000
mRDR1AD1_RDR1AD112: equ    %00010000
mRDR1AD1_RDR1AD113: equ    %00100000
mRDR1AD1_RDR1AD114: equ    %01000000
mRDR1AD1_RDR1AD115: equ    %10000000


;*** PER01AD1 - Port AD1 Pull Up Enable Register; 0x0000027E ***
PER01AD1:           equ    $0000027E                                ;*** PER01AD1 - Port AD1 Pull Up Enable Register; 0x0000027E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER01AD1_PER1AD18:  equ    0                                         ; Port AD1 Pull Up Enable Bit 8
PER01AD1_PER1AD19:  equ    1                                         ; Port AD1 Pull Up Enable Bit 9
PER01AD1_PER1AD110: equ    2                                         ; Port AD1 Pull Up Enable Bit 10
PER01AD1_PER1AD111: equ    3                                         ; Port AD1 Pull Up Enable Bit 11
PER01AD1_PER1AD112: equ    4                                         ; Port AD1 Pull Up Enable Bit 12
PER01AD1_PER1AD113: equ    5                                         ; Port AD1 Pull Up Enable Bit 13
PER01AD1_PER1AD114: equ    6                                         ; Port AD1 Pull Up Enable Bit 14
PER01AD1_PER1AD115: equ    7                                         ; Port AD1 Pull Up Enable Bit 15
PER01AD1_PER0AD116: equ    8                                         ; Port AD1 Pull Up Enable Bit 16
PER01AD1_PER0AD117: equ    9                                         ; Port AD1 Pull Up Enable Bit 17
PER01AD1_PER0AD118: equ    10                                        ; Port AD1 Pull Up Enable Bit 18
PER01AD1_PER0AD119: equ    11                                        ; Port AD1 Pull Up Enable Bit 19
PER01AD1_PER0AD120: equ    12                                        ; Port AD1 Pull Up Enable Bit 20
PER01AD1_PER0AD121: equ    13                                        ; Port AD1 Pull Up Enable Bit 21
PER01AD1_PER0AD122: equ    14                                        ; Port AD1 Pull Up Enable Bit 22
PER01AD1_PER0AD123: equ    15                                        ; Port AD1 Pull Up Enable Bit 23
; bit position masks
mPER01AD1_PER1AD18: equ    %00000001
mPER01AD1_PER1AD19: equ    %00000010
mPER01AD1_PER1AD110: equ    %00000100
mPER01AD1_PER1AD111: equ    %00001000
mPER01AD1_PER1AD112: equ    %00010000
mPER01AD1_PER1AD113: equ    %00100000
mPER01AD1_PER1AD114: equ    %01000000
mPER01AD1_PER1AD115: equ    %10000000
mPER01AD1_PER0AD116: equ    %100000000
mPER01AD1_PER0AD117: equ    %1000000000
mPER01AD1_PER0AD118: equ    %10000000000
mPER01AD1_PER0AD119: equ    %100000000000
mPER01AD1_PER0AD120: equ    %1000000000000
mPER01AD1_PER0AD121: equ    %10000000000000
mPER01AD1_PER0AD122: equ    %100000000000000
mPER01AD1_PER0AD123: equ    %1000000000000000


;*** PER0AD1 - Port AD1 Pull Up Enable Register 0; 0x0000027E ***
PER0AD1:            equ    $0000027E                                ;*** PER0AD1 - Port AD1 Pull Up Enable Register 0; 0x0000027E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER0AD1_PER0AD116:  equ    0                                         ; Port AD1 Pull Up Enable Bit 16
PER0AD1_PER0AD117:  equ    1                                         ; Port AD1 Pull Up Enable Bit 17
PER0AD1_PER0AD118:  equ    2                                         ; Port AD1 Pull Up Enable Bit 18
PER0AD1_PER0AD119:  equ    3                                         ; Port AD1 Pull Up Enable Bit 19
PER0AD1_PER0AD120:  equ    4                                         ; Port AD1 Pull Up Enable Bit 20
PER0AD1_PER0AD121:  equ    5                                         ; Port AD1 Pull Up Enable Bit 21
PER0AD1_PER0AD122:  equ    6                                         ; Port AD1 Pull Up Enable Bit 22
PER0AD1_PER0AD123:  equ    7                                         ; Port AD1 Pull Up Enable Bit 23
; bit position masks
mPER0AD1_PER0AD116: equ    %00000001
mPER0AD1_PER0AD117: equ    %00000010
mPER0AD1_PER0AD118: equ    %00000100
mPER0AD1_PER0AD119: equ    %00001000
mPER0AD1_PER0AD120: equ    %00010000
mPER0AD1_PER0AD121: equ    %00100000
mPER0AD1_PER0AD122: equ    %01000000
mPER0AD1_PER0AD123: equ    %10000000


;*** PER1AD1 - Port AD1 Pull Up Enable Register 1; 0x0000027F ***
PER1AD1:            equ    $0000027F                                ;*** PER1AD1 - Port AD1 Pull Up Enable Register 1; 0x0000027F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PER1AD1_PER1AD18:   equ    0                                         ; Port AD1 Pull Up Enable Bit 8
PER1AD1_PER1AD19:   equ    1                                         ; Port AD1 Pull Up Enable Bit 9
PER1AD1_PER1AD110:  equ    2                                         ; Port AD1 Pull Up Enable Bit 10
PER1AD1_PER1AD111:  equ    3                                         ; Port AD1 Pull Up Enable Bit 11
PER1AD1_PER1AD112:  equ    4                                         ; Port AD1 Pull Up Enable Bit 12
PER1AD1_PER1AD113:  equ    5                                         ; Port AD1 Pull Up Enable Bit 13
PER1AD1_PER1AD114:  equ    6                                         ; Port AD1 Pull Up Enable Bit 14
PER1AD1_PER1AD115:  equ    7                                         ; Port AD1 Pull Up Enable Bit 15
; bit position masks
mPER1AD1_PER1AD18:  equ    %00000001
mPER1AD1_PER1AD19:  equ    %00000010
mPER1AD1_PER1AD110: equ    %00000100
mPER1AD1_PER1AD111: equ    %00001000
mPER1AD1_PER1AD112: equ    %00010000
mPER1AD1_PER1AD113: equ    %00100000
mPER1AD1_PER1AD114: equ    %01000000
mPER1AD1_PER1AD115: equ    %10000000


;*** CAN4CTL0 - MSCAN 4 Control 0 Register; 0x00000280 ***
CAN4CTL0:           equ    $00000280                                ;*** CAN4CTL0 - MSCAN 4 Control 0 Register; 0x00000280 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4CTL0_INITRQ:    equ    0                                         ; Initialization Mode Request
CAN4CTL0_SLPRQ:     equ    1                                         ; Sleep Mode Request
CAN4CTL0_WUPE:      equ    2                                         ; Wake-Up Enable
CAN4CTL0_TIME:      equ    3                                         ; Timer Enable
CAN4CTL0_SYNCH:     equ    4                                         ; Synchronized Status
CAN4CTL0_CSWAI:     equ    5                                         ; CAN Stops in Wait Mode
CAN4CTL0_RXACT:     equ    6                                         ; Receiver Active Status
CAN4CTL0_RXFRM:     equ    7                                         ; Received Frame Flag
; bit position masks
mCAN4CTL0_INITRQ:   equ    %00000001
mCAN4CTL0_SLPRQ:    equ    %00000010
mCAN4CTL0_WUPE:     equ    %00000100
mCAN4CTL0_TIME:     equ    %00001000
mCAN4CTL0_SYNCH:    equ    %00010000
mCAN4CTL0_CSWAI:    equ    %00100000
mCAN4CTL0_RXACT:    equ    %01000000
mCAN4CTL0_RXFRM:    equ    %10000000


;*** CAN4CTL1 - MSCAN 4 Control 1 Register; 0x00000281 ***
CAN4CTL1:           equ    $00000281                                ;*** CAN4CTL1 - MSCAN 4 Control 1 Register; 0x00000281 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4CTL1_INITAK:    equ    0                                         ; Initialization Mode Acknowledge
CAN4CTL1_SLPAK:     equ    1                                         ; Sleep Mode Acknowledge
CAN4CTL1_WUPM:      equ    2                                         ; Wake-Up Mode
CAN4CTL1_BORM:      equ    3                                         ; Bus-Off Recovery Mode
CAN4CTL1_LISTEN:    equ    4                                         ; Listen Only Mode
CAN4CTL1_LOOPB:     equ    5                                         ; Loop Back Self Test Mode
CAN4CTL1_CLKSRC:    equ    6                                         ; MSCAN 4 Clock Source
CAN4CTL1_CANE:      equ    7                                         ; MSCAN 4 Enable
; bit position masks
mCAN4CTL1_INITAK:   equ    %00000001
mCAN4CTL1_SLPAK:    equ    %00000010
mCAN4CTL1_WUPM:     equ    %00000100
mCAN4CTL1_BORM:     equ    %00001000
mCAN4CTL1_LISTEN:   equ    %00010000
mCAN4CTL1_LOOPB:    equ    %00100000
mCAN4CTL1_CLKSRC:   equ    %01000000
mCAN4CTL1_CANE:     equ    %10000000


;*** CAN4BTR0 - MSCAN 4 Bus Timing Register 0; 0x00000282 ***
CAN4BTR0:           equ    $00000282                                ;*** CAN4BTR0 - MSCAN 4 Bus Timing Register 0; 0x00000282 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4BTR0_BRP0:      equ    0                                         ; Baud Rate Prescaler 0
CAN4BTR0_BRP1:      equ    1                                         ; Baud Rate Prescaler 1
CAN4BTR0_BRP2:      equ    2                                         ; Baud Rate Prescaler 2
CAN4BTR0_BRP3:      equ    3                                         ; Baud Rate Prescaler 3
CAN4BTR0_BRP4:      equ    4                                         ; Baud Rate Prescaler 4
CAN4BTR0_BRP5:      equ    5                                         ; Baud Rate Prescaler 5
CAN4BTR0_SJW0:      equ    6                                         ; Synchronization Jump Width 0
CAN4BTR0_SJW1:      equ    7                                         ; Synchronization Jump Width 1
; bit position masks
mCAN4BTR0_BRP0:     equ    %00000001
mCAN4BTR0_BRP1:     equ    %00000010
mCAN4BTR0_BRP2:     equ    %00000100
mCAN4BTR0_BRP3:     equ    %00001000
mCAN4BTR0_BRP4:     equ    %00010000
mCAN4BTR0_BRP5:     equ    %00100000
mCAN4BTR0_SJW0:     equ    %01000000
mCAN4BTR0_SJW1:     equ    %10000000


;*** CAN4BTR1 - MSCAN 4 Bus Timing Register 1; 0x00000283 ***
CAN4BTR1:           equ    $00000283                                ;*** CAN4BTR1 - MSCAN 4 Bus Timing Register 1; 0x00000283 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4BTR1_TSEG10:    equ    0                                         ; Time Segment 10
CAN4BTR1_TSEG11:    equ    1                                         ; Time Segment 11
CAN4BTR1_TSEG12:    equ    2                                         ; Time Segment 12
CAN4BTR1_TSEG13:    equ    3                                         ; Time Segment 13
CAN4BTR1_TSEG20:    equ    4                                         ; Time Segment 20
CAN4BTR1_TSEG21:    equ    5                                         ; Time Segment 21
CAN4BTR1_TSEG22:    equ    6                                         ; Time Segment 22
CAN4BTR1_SAMP:      equ    7                                         ; Sampling
; bit position masks
mCAN4BTR1_TSEG10:   equ    %00000001
mCAN4BTR1_TSEG11:   equ    %00000010
mCAN4BTR1_TSEG12:   equ    %00000100
mCAN4BTR1_TSEG13:   equ    %00001000
mCAN4BTR1_TSEG20:   equ    %00010000
mCAN4BTR1_TSEG21:   equ    %00100000
mCAN4BTR1_TSEG22:   equ    %01000000
mCAN4BTR1_SAMP:     equ    %10000000


;*** CAN4RFLG - MSCAN 4 Receiver Flag Register; 0x00000284 ***
CAN4RFLG:           equ    $00000284                                ;*** CAN4RFLG - MSCAN 4 Receiver Flag Register; 0x00000284 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RFLG_RXF:       equ    0                                         ; Receive Buffer Full
CAN4RFLG_OVRIF:     equ    1                                         ; Overrun Interrupt Flag
CAN4RFLG_TSTAT0:    equ    2                                         ; Transmitter Status Bit 0
CAN4RFLG_TSTAT1:    equ    3                                         ; Transmitter Status Bit 1
CAN4RFLG_RSTAT0:    equ    4                                         ; Receiver Status Bit 0
CAN4RFLG_RSTAT1:    equ    5                                         ; Receiver Status Bit 1
CAN4RFLG_CSCIF:     equ    6                                         ; CAN Status Change Interrupt Flag
CAN4RFLG_WUPIF:     equ    7                                         ; Wake-up Interrupt Flag
; bit position masks
mCAN4RFLG_RXF:      equ    %00000001
mCAN4RFLG_OVRIF:    equ    %00000010
mCAN4RFLG_TSTAT0:   equ    %00000100
mCAN4RFLG_TSTAT1:   equ    %00001000
mCAN4RFLG_RSTAT0:   equ    %00010000
mCAN4RFLG_RSTAT1:   equ    %00100000
mCAN4RFLG_CSCIF:    equ    %01000000
mCAN4RFLG_WUPIF:    equ    %10000000


;*** CAN4RIER - MSCAN 4 Receiver Interrupt Enable Register; 0x00000285 ***
CAN4RIER:           equ    $00000285                                ;*** CAN4RIER - MSCAN 4 Receiver Interrupt Enable Register; 0x00000285 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RIER_RXFIE:     equ    0                                         ; Receiver Full Interrupt Enable
CAN4RIER_OVRIE:     equ    1                                         ; Overrun Interrupt Enable
CAN4RIER_TSTATE0:   equ    2                                         ; Transmitter Status Change Enable 0
CAN4RIER_TSTATE1:   equ    3                                         ; Transmitter Status Change Enable 1
CAN4RIER_RSTATE0:   equ    4                                         ; Receiver Status Change Enable 0
CAN4RIER_RSTATE1:   equ    5                                         ; Receiver Status Change Enable 1
CAN4RIER_CSCIE:     equ    6                                         ; CAN Status Change Interrupt Enable
CAN4RIER_WUPIE:     equ    7                                         ; Wake-up Interrupt Enable
; bit position masks
mCAN4RIER_RXFIE:    equ    %00000001
mCAN4RIER_OVRIE:    equ    %00000010
mCAN4RIER_TSTATE0:  equ    %00000100
mCAN4RIER_TSTATE1:  equ    %00001000
mCAN4RIER_RSTATE0:  equ    %00010000
mCAN4RIER_RSTATE1:  equ    %00100000
mCAN4RIER_CSCIE:    equ    %01000000
mCAN4RIER_WUPIE:    equ    %10000000


;*** CAN4TFLG - MSCAN 4 Transmitter Flag Register; 0x00000286 ***
CAN4TFLG:           equ    $00000286                                ;*** CAN4TFLG - MSCAN 4 Transmitter Flag Register; 0x00000286 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TFLG_TXE0:      equ    0                                         ; Transmitter Buffer Empty 0
CAN4TFLG_TXE1:      equ    1                                         ; Transmitter Buffer Empty 1
CAN4TFLG_TXE2:      equ    2                                         ; Transmitter Buffer Empty 2
; bit position masks
mCAN4TFLG_TXE0:     equ    %00000001
mCAN4TFLG_TXE1:     equ    %00000010
mCAN4TFLG_TXE2:     equ    %00000100


;*** CAN4TIER - MSCAN 4 Transmitter Interrupt Enable Register; 0x00000287 ***
CAN4TIER:           equ    $00000287                                ;*** CAN4TIER - MSCAN 4 Transmitter Interrupt Enable Register; 0x00000287 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TIER_TXEIE0:    equ    0                                         ; Transmitter Empty Interrupt Enable 0
CAN4TIER_TXEIE1:    equ    1                                         ; Transmitter Empty Interrupt Enable 1
CAN4TIER_TXEIE2:    equ    2                                         ; Transmitter Empty Interrupt Enable 2
; bit position masks
mCAN4TIER_TXEIE0:   equ    %00000001
mCAN4TIER_TXEIE1:   equ    %00000010
mCAN4TIER_TXEIE2:   equ    %00000100


;*** CAN4TARQ - MSCAN 4 Transmitter Message Abort Request; 0x00000288 ***
CAN4TARQ:           equ    $00000288                                ;*** CAN4TARQ - MSCAN 4 Transmitter Message Abort Request; 0x00000288 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TARQ_ABTRQ0:    equ    0                                         ; Abort Request 0
CAN4TARQ_ABTRQ1:    equ    1                                         ; Abort Request 1
CAN4TARQ_ABTRQ2:    equ    2                                         ; Abort Request 2
; bit position masks
mCAN4TARQ_ABTRQ0:   equ    %00000001
mCAN4TARQ_ABTRQ1:   equ    %00000010
mCAN4TARQ_ABTRQ2:   equ    %00000100


;*** CAN4TAAK - MSCAN 4 Transmitter Message Abort Control; 0x00000289 ***
CAN4TAAK:           equ    $00000289                                ;*** CAN4TAAK - MSCAN 4 Transmitter Message Abort Control; 0x00000289 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TAAK_ABTAK0:    equ    0                                         ; Abort Acknowledge 0
CAN4TAAK_ABTAK1:    equ    1                                         ; Abort Acknowledge 1
CAN4TAAK_ABTAK2:    equ    2                                         ; Abort Acknowledge 2
; bit position masks
mCAN4TAAK_ABTAK0:   equ    %00000001
mCAN4TAAK_ABTAK1:   equ    %00000010
mCAN4TAAK_ABTAK2:   equ    %00000100


;*** CAN4TBSEL - MSCAN 4 Transmit Buffer Selection; 0x0000028A ***
CAN4TBSEL:          equ    $0000028A                                ;*** CAN4TBSEL - MSCAN 4 Transmit Buffer Selection; 0x0000028A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TBSEL_TX0:      equ    0                                         ; Transmit Buffer Select 0
CAN4TBSEL_TX1:      equ    1                                         ; Transmit Buffer Select 1
CAN4TBSEL_TX2:      equ    2                                         ; Transmit Buffer Select 2
; bit position masks
mCAN4TBSEL_TX0:     equ    %00000001
mCAN4TBSEL_TX1:     equ    %00000010
mCAN4TBSEL_TX2:     equ    %00000100


;*** CAN4IDAC - MSCAN 4 Identifier Acceptance Control Register; 0x0000028B ***
CAN4IDAC:           equ    $0000028B                                ;*** CAN4IDAC - MSCAN 4 Identifier Acceptance Control Register; 0x0000028B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAC_IDHIT0:    equ    0                                         ; Identifier Acceptance Hit Indicator 0
CAN4IDAC_IDHIT1:    equ    1                                         ; Identifier Acceptance Hit Indicator 1
CAN4IDAC_IDHIT2:    equ    2                                         ; Identifier Acceptance Hit Indicator 2
CAN4IDAC_IDAM0:     equ    4                                         ; Identifier Acceptance Mode 0
CAN4IDAC_IDAM1:     equ    5                                         ; Identifier Acceptance Mode 1
; bit position masks
mCAN4IDAC_IDHIT0:   equ    %00000001
mCAN4IDAC_IDHIT1:   equ    %00000010
mCAN4IDAC_IDHIT2:   equ    %00000100
mCAN4IDAC_IDAM0:    equ    %00010000
mCAN4IDAC_IDAM1:    equ    %00100000


;*** CAN4MISC - MSCAN 4 Miscellaneous Register; 0x0000028D ***
CAN4MISC:           equ    $0000028D                                ;*** CAN4MISC - MSCAN 4 Miscellaneous Register; 0x0000028D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4MISC_BOHOLD:    equ    0                                         ; Bus-Off state Hold until user request
; bit position masks
mCAN4MISC_BOHOLD:   equ    %00000001


;*** CAN4RXERR - MSCAN 4 Receive Error Counter Register; 0x0000028E ***
CAN4RXERR:          equ    $0000028E                                ;*** CAN4RXERR - MSCAN 4 Receive Error Counter Register; 0x0000028E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXERR_RXERR0:   equ    0                                         ; Bit 0
CAN4RXERR_RXERR1:   equ    1                                         ; Bit 1
CAN4RXERR_RXERR2:   equ    2                                         ; Bit 2
CAN4RXERR_RXERR3:   equ    3                                         ; Bit 3
CAN4RXERR_RXERR4:   equ    4                                         ; Bit 4
CAN4RXERR_RXERR5:   equ    5                                         ; Bit 5
CAN4RXERR_RXERR6:   equ    6                                         ; Bit 6
CAN4RXERR_RXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN4RXERR_RXERR0:  equ    %00000001
mCAN4RXERR_RXERR1:  equ    %00000010
mCAN4RXERR_RXERR2:  equ    %00000100
mCAN4RXERR_RXERR3:  equ    %00001000
mCAN4RXERR_RXERR4:  equ    %00010000
mCAN4RXERR_RXERR5:  equ    %00100000
mCAN4RXERR_RXERR6:  equ    %01000000
mCAN4RXERR_RXERR7:  equ    %10000000


;*** CAN4TXERR - MSCAN 4 Transmit Error Counter Register; 0x0000028F ***
CAN4TXERR:          equ    $0000028F                                ;*** CAN4TXERR - MSCAN 4 Transmit Error Counter Register; 0x0000028F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXERR_TXERR0:   equ    0                                         ; Bit 0
CAN4TXERR_TXERR1:   equ    1                                         ; Bit 1
CAN4TXERR_TXERR2:   equ    2                                         ; Bit 2
CAN4TXERR_TXERR3:   equ    3                                         ; Bit 3
CAN4TXERR_TXERR4:   equ    4                                         ; Bit 4
CAN4TXERR_TXERR5:   equ    5                                         ; Bit 5
CAN4TXERR_TXERR6:   equ    6                                         ; Bit 6
CAN4TXERR_TXERR7:   equ    7                                         ; Bit 7
; bit position masks
mCAN4TXERR_TXERR0:  equ    %00000001
mCAN4TXERR_TXERR1:  equ    %00000010
mCAN4TXERR_TXERR2:  equ    %00000100
mCAN4TXERR_TXERR3:  equ    %00001000
mCAN4TXERR_TXERR4:  equ    %00010000
mCAN4TXERR_TXERR5:  equ    %00100000
mCAN4TXERR_TXERR6:  equ    %01000000
mCAN4TXERR_TXERR7:  equ    %10000000


;*** CAN4IDAR0 - MSCAN 4 Identifier Acceptance Register 0; 0x00000290 ***
CAN4IDAR0:          equ    $00000290                                ;*** CAN4IDAR0 - MSCAN 4 Identifier Acceptance Register 0; 0x00000290 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR0_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR0_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR0_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR0_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR0_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR0_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR0_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR0_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR0_AC0:     equ    %00000001
mCAN4IDAR0_AC1:     equ    %00000010
mCAN4IDAR0_AC2:     equ    %00000100
mCAN4IDAR0_AC3:     equ    %00001000
mCAN4IDAR0_AC4:     equ    %00010000
mCAN4IDAR0_AC5:     equ    %00100000
mCAN4IDAR0_AC6:     equ    %01000000
mCAN4IDAR0_AC7:     equ    %10000000


;*** CAN4IDAR1 - MSCAN 4 Identifier Acceptance Register 1; 0x00000291 ***
CAN4IDAR1:          equ    $00000291                                ;*** CAN4IDAR1 - MSCAN 4 Identifier Acceptance Register 1; 0x00000291 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR1_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR1_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR1_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR1_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR1_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR1_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR1_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR1_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR1_AC0:     equ    %00000001
mCAN4IDAR1_AC1:     equ    %00000010
mCAN4IDAR1_AC2:     equ    %00000100
mCAN4IDAR1_AC3:     equ    %00001000
mCAN4IDAR1_AC4:     equ    %00010000
mCAN4IDAR1_AC5:     equ    %00100000
mCAN4IDAR1_AC6:     equ    %01000000
mCAN4IDAR1_AC7:     equ    %10000000


;*** CAN4IDAR2 - MSCAN 4 Identifier Acceptance Register 2; 0x00000292 ***
CAN4IDAR2:          equ    $00000292                                ;*** CAN4IDAR2 - MSCAN 4 Identifier Acceptance Register 2; 0x00000292 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR2_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR2_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR2_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR2_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR2_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR2_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR2_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR2_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR2_AC0:     equ    %00000001
mCAN4IDAR2_AC1:     equ    %00000010
mCAN4IDAR2_AC2:     equ    %00000100
mCAN4IDAR2_AC3:     equ    %00001000
mCAN4IDAR2_AC4:     equ    %00010000
mCAN4IDAR2_AC5:     equ    %00100000
mCAN4IDAR2_AC6:     equ    %01000000
mCAN4IDAR2_AC7:     equ    %10000000


;*** CAN4IDAR3 - MSCAN 4 Identifier Acceptance Register 3; 0x00000293 ***
CAN4IDAR3:          equ    $00000293                                ;*** CAN4IDAR3 - MSCAN 4 Identifier Acceptance Register 3; 0x00000293 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR3_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR3_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR3_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR3_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR3_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR3_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR3_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR3_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR3_AC0:     equ    %00000001
mCAN4IDAR3_AC1:     equ    %00000010
mCAN4IDAR3_AC2:     equ    %00000100
mCAN4IDAR3_AC3:     equ    %00001000
mCAN4IDAR3_AC4:     equ    %00010000
mCAN4IDAR3_AC5:     equ    %00100000
mCAN4IDAR3_AC6:     equ    %01000000
mCAN4IDAR3_AC7:     equ    %10000000


;*** CAN4IDMR0 - MSCAN 4 Identifier Mask Register 0; 0x00000294 ***
CAN4IDMR0:          equ    $00000294                                ;*** CAN4IDMR0 - MSCAN 4 Identifier Mask Register 0; 0x00000294 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR0_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR0_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR0_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR0_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR0_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR0_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR0_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR0_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR0_AM0:     equ    %00000001
mCAN4IDMR0_AM1:     equ    %00000010
mCAN4IDMR0_AM2:     equ    %00000100
mCAN4IDMR0_AM3:     equ    %00001000
mCAN4IDMR0_AM4:     equ    %00010000
mCAN4IDMR0_AM5:     equ    %00100000
mCAN4IDMR0_AM6:     equ    %01000000
mCAN4IDMR0_AM7:     equ    %10000000


;*** CAN4IDMR1 - MSCAN 4 Identifier Mask Register 1; 0x00000295 ***
CAN4IDMR1:          equ    $00000295                                ;*** CAN4IDMR1 - MSCAN 4 Identifier Mask Register 1; 0x00000295 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR1_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR1_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR1_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR1_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR1_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR1_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR1_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR1_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR1_AM0:     equ    %00000001
mCAN4IDMR1_AM1:     equ    %00000010
mCAN4IDMR1_AM2:     equ    %00000100
mCAN4IDMR1_AM3:     equ    %00001000
mCAN4IDMR1_AM4:     equ    %00010000
mCAN4IDMR1_AM5:     equ    %00100000
mCAN4IDMR1_AM6:     equ    %01000000
mCAN4IDMR1_AM7:     equ    %10000000


;*** CAN4IDMR2 - MSCAN 4 Identifier Mask Register 2; 0x00000296 ***
CAN4IDMR2:          equ    $00000296                                ;*** CAN4IDMR2 - MSCAN 4 Identifier Mask Register 2; 0x00000296 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR2_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR2_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR2_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR2_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR2_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR2_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR2_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR2_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR2_AM0:     equ    %00000001
mCAN4IDMR2_AM1:     equ    %00000010
mCAN4IDMR2_AM2:     equ    %00000100
mCAN4IDMR2_AM3:     equ    %00001000
mCAN4IDMR2_AM4:     equ    %00010000
mCAN4IDMR2_AM5:     equ    %00100000
mCAN4IDMR2_AM6:     equ    %01000000
mCAN4IDMR2_AM7:     equ    %10000000


;*** CAN4IDMR3 - MSCAN 4 Identifier Mask Register 3; 0x00000297 ***
CAN4IDMR3:          equ    $00000297                                ;*** CAN4IDMR3 - MSCAN 4 Identifier Mask Register 3; 0x00000297 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR3_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR3_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR3_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR3_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR3_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR3_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR3_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR3_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR3_AM0:     equ    %00000001
mCAN4IDMR3_AM1:     equ    %00000010
mCAN4IDMR3_AM2:     equ    %00000100
mCAN4IDMR3_AM3:     equ    %00001000
mCAN4IDMR3_AM4:     equ    %00010000
mCAN4IDMR3_AM5:     equ    %00100000
mCAN4IDMR3_AM6:     equ    %01000000
mCAN4IDMR3_AM7:     equ    %10000000


;*** CAN4IDAR4 - MSCAN 4 Identifier Acceptance Register 4; 0x00000298 ***
CAN4IDAR4:          equ    $00000298                                ;*** CAN4IDAR4 - MSCAN 4 Identifier Acceptance Register 4; 0x00000298 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR4_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR4_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR4_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR4_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR4_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR4_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR4_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR4_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR4_AC0:     equ    %00000001
mCAN4IDAR4_AC1:     equ    %00000010
mCAN4IDAR4_AC2:     equ    %00000100
mCAN4IDAR4_AC3:     equ    %00001000
mCAN4IDAR4_AC4:     equ    %00010000
mCAN4IDAR4_AC5:     equ    %00100000
mCAN4IDAR4_AC6:     equ    %01000000
mCAN4IDAR4_AC7:     equ    %10000000


;*** CAN4IDAR5 - MSCAN 4 Identifier Acceptance Register 5; 0x00000299 ***
CAN4IDAR5:          equ    $00000299                                ;*** CAN4IDAR5 - MSCAN 4 Identifier Acceptance Register 5; 0x00000299 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR5_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR5_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR5_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR5_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR5_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR5_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR5_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR5_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR5_AC0:     equ    %00000001
mCAN4IDAR5_AC1:     equ    %00000010
mCAN4IDAR5_AC2:     equ    %00000100
mCAN4IDAR5_AC3:     equ    %00001000
mCAN4IDAR5_AC4:     equ    %00010000
mCAN4IDAR5_AC5:     equ    %00100000
mCAN4IDAR5_AC6:     equ    %01000000
mCAN4IDAR5_AC7:     equ    %10000000


;*** CAN4IDAR6 - MSCAN 4 Identifier Acceptance Register 6; 0x0000029A ***
CAN4IDAR6:          equ    $0000029A                                ;*** CAN4IDAR6 - MSCAN 4 Identifier Acceptance Register 6; 0x0000029A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR6_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR6_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR6_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR6_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR6_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR6_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR6_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR6_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR6_AC0:     equ    %00000001
mCAN4IDAR6_AC1:     equ    %00000010
mCAN4IDAR6_AC2:     equ    %00000100
mCAN4IDAR6_AC3:     equ    %00001000
mCAN4IDAR6_AC4:     equ    %00010000
mCAN4IDAR6_AC5:     equ    %00100000
mCAN4IDAR6_AC6:     equ    %01000000
mCAN4IDAR6_AC7:     equ    %10000000


;*** CAN4IDAR7 - MSCAN 4 Identifier Acceptance Register 7; 0x0000029B ***
CAN4IDAR7:          equ    $0000029B                                ;*** CAN4IDAR7 - MSCAN 4 Identifier Acceptance Register 7; 0x0000029B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDAR7_AC0:      equ    0                                         ; Acceptance Code Bit 0
CAN4IDAR7_AC1:      equ    1                                         ; Acceptance Code Bit 1
CAN4IDAR7_AC2:      equ    2                                         ; Acceptance Code Bit 2
CAN4IDAR7_AC3:      equ    3                                         ; Acceptance Code Bit 3
CAN4IDAR7_AC4:      equ    4                                         ; Acceptance Code Bit 4
CAN4IDAR7_AC5:      equ    5                                         ; Acceptance Code Bit 5
CAN4IDAR7_AC6:      equ    6                                         ; Acceptance Code Bit 6
CAN4IDAR7_AC7:      equ    7                                         ; Acceptance Code Bit 7
; bit position masks
mCAN4IDAR7_AC0:     equ    %00000001
mCAN4IDAR7_AC1:     equ    %00000010
mCAN4IDAR7_AC2:     equ    %00000100
mCAN4IDAR7_AC3:     equ    %00001000
mCAN4IDAR7_AC4:     equ    %00010000
mCAN4IDAR7_AC5:     equ    %00100000
mCAN4IDAR7_AC6:     equ    %01000000
mCAN4IDAR7_AC7:     equ    %10000000


;*** CAN4IDMR4 - MSCAN 4 Identifier Mask Register 4; 0x0000029C ***
CAN4IDMR4:          equ    $0000029C                                ;*** CAN4IDMR4 - MSCAN 4 Identifier Mask Register 4; 0x0000029C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR4_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR4_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR4_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR4_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR4_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR4_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR4_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR4_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR4_AM0:     equ    %00000001
mCAN4IDMR4_AM1:     equ    %00000010
mCAN4IDMR4_AM2:     equ    %00000100
mCAN4IDMR4_AM3:     equ    %00001000
mCAN4IDMR4_AM4:     equ    %00010000
mCAN4IDMR4_AM5:     equ    %00100000
mCAN4IDMR4_AM6:     equ    %01000000
mCAN4IDMR4_AM7:     equ    %10000000


;*** CAN4IDMR5 - MSCAN 4 Identifier Mask Register 5; 0x0000029D ***
CAN4IDMR5:          equ    $0000029D                                ;*** CAN4IDMR5 - MSCAN 4 Identifier Mask Register 5; 0x0000029D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR5_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR5_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR5_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR5_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR5_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR5_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR5_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR5_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR5_AM0:     equ    %00000001
mCAN4IDMR5_AM1:     equ    %00000010
mCAN4IDMR5_AM2:     equ    %00000100
mCAN4IDMR5_AM3:     equ    %00001000
mCAN4IDMR5_AM4:     equ    %00010000
mCAN4IDMR5_AM5:     equ    %00100000
mCAN4IDMR5_AM6:     equ    %01000000
mCAN4IDMR5_AM7:     equ    %10000000


;*** CAN4IDMR6 - MSCAN 4 Identifier Mask Register 6; 0x0000029E ***
CAN4IDMR6:          equ    $0000029E                                ;*** CAN4IDMR6 - MSCAN 4 Identifier Mask Register 6; 0x0000029E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR6_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR6_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR6_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR6_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR6_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR6_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR6_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR6_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR6_AM0:     equ    %00000001
mCAN4IDMR6_AM1:     equ    %00000010
mCAN4IDMR6_AM2:     equ    %00000100
mCAN4IDMR6_AM3:     equ    %00001000
mCAN4IDMR6_AM4:     equ    %00010000
mCAN4IDMR6_AM5:     equ    %00100000
mCAN4IDMR6_AM6:     equ    %01000000
mCAN4IDMR6_AM7:     equ    %10000000


;*** CAN4IDMR7 - MSCAN 4 Identifier Mask Register 7; 0x0000029F ***
CAN4IDMR7:          equ    $0000029F                                ;*** CAN4IDMR7 - MSCAN 4 Identifier Mask Register 7; 0x0000029F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4IDMR7_AM0:      equ    0                                         ; Acceptance Mask Bit 0
CAN4IDMR7_AM1:      equ    1                                         ; Acceptance Mask Bit 1
CAN4IDMR7_AM2:      equ    2                                         ; Acceptance Mask Bit 2
CAN4IDMR7_AM3:      equ    3                                         ; Acceptance Mask Bit 3
CAN4IDMR7_AM4:      equ    4                                         ; Acceptance Mask Bit 4
CAN4IDMR7_AM5:      equ    5                                         ; Acceptance Mask Bit 5
CAN4IDMR7_AM6:      equ    6                                         ; Acceptance Mask Bit 6
CAN4IDMR7_AM7:      equ    7                                         ; Acceptance Mask Bit 7
; bit position masks
mCAN4IDMR7_AM0:     equ    %00000001
mCAN4IDMR7_AM1:     equ    %00000010
mCAN4IDMR7_AM2:     equ    %00000100
mCAN4IDMR7_AM3:     equ    %00001000
mCAN4IDMR7_AM4:     equ    %00010000
mCAN4IDMR7_AM5:     equ    %00100000
mCAN4IDMR7_AM6:     equ    %01000000
mCAN4IDMR7_AM7:     equ    %10000000


;*** CAN4RXIDR0 - MSCAN 4 Receive Identifier Register 0; 0x000002A0 ***
CAN4RXIDR0:         equ    $000002A0                                ;*** CAN4RXIDR0 - MSCAN 4 Receive Identifier Register 0; 0x000002A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN4RXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN4RXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN4RXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN4RXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN4RXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN4RXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN4RXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN4RXIDR0_ID21:   equ    %00000001
mCAN4RXIDR0_ID22:   equ    %00000010
mCAN4RXIDR0_ID23:   equ    %00000100
mCAN4RXIDR0_ID24:   equ    %00001000
mCAN4RXIDR0_ID25:   equ    %00010000
mCAN4RXIDR0_ID26:   equ    %00100000
mCAN4RXIDR0_ID27:   equ    %01000000
mCAN4RXIDR0_ID28:   equ    %10000000


;*** CAN4RXIDR1 - MSCAN 4 Receive Identifier Register 1; 0x000002A1 ***
CAN4RXIDR1:         equ    $000002A1                                ;*** CAN4RXIDR1 - MSCAN 4 Receive Identifier Register 1; 0x000002A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN4RXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN4RXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN4RXIDR1_IDE:     equ    3                                         ; ID Extended
CAN4RXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN4RXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN4RXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN4RXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN4RXIDR1_ID15:   equ    %00000001
mCAN4RXIDR1_ID16:   equ    %00000010
mCAN4RXIDR1_ID17:   equ    %00000100
mCAN4RXIDR1_IDE:    equ    %00001000
mCAN4RXIDR1_SRR:    equ    %00010000
mCAN4RXIDR1_ID18:   equ    %00100000
mCAN4RXIDR1_ID19:   equ    %01000000
mCAN4RXIDR1_ID20:   equ    %10000000


;*** CAN4RXIDR2 - MSCAN 4 Receive Identifier Register 2; 0x000002A2 ***
CAN4RXIDR2:         equ    $000002A2                                ;*** CAN4RXIDR2 - MSCAN 4 Receive Identifier Register 2; 0x000002A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN4RXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN4RXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN4RXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN4RXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN4RXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN4RXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN4RXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN4RXIDR2_ID7:    equ    %00000001
mCAN4RXIDR2_ID8:    equ    %00000010
mCAN4RXIDR2_ID9:    equ    %00000100
mCAN4RXIDR2_ID10:   equ    %00001000
mCAN4RXIDR2_ID11:   equ    %00010000
mCAN4RXIDR2_ID12:   equ    %00100000
mCAN4RXIDR2_ID13:   equ    %01000000
mCAN4RXIDR2_ID14:   equ    %10000000


;*** CAN4RXIDR3 - MSCAN 4 Receive Identifier Register 3; 0x000002A3 ***
CAN4RXIDR3:         equ    $000002A3                                ;*** CAN4RXIDR3 - MSCAN 4 Receive Identifier Register 3; 0x000002A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN4RXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN4RXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN4RXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN4RXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN4RXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN4RXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN4RXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN4RXIDR3_RTR:    equ    %00000001
mCAN4RXIDR3_ID0:    equ    %00000010
mCAN4RXIDR3_ID1:    equ    %00000100
mCAN4RXIDR3_ID2:    equ    %00001000
mCAN4RXIDR3_ID3:    equ    %00010000
mCAN4RXIDR3_ID4:    equ    %00100000
mCAN4RXIDR3_ID5:    equ    %01000000
mCAN4RXIDR3_ID6:    equ    %10000000


;*** CAN4RXDSR0 - MSCAN 4 Receive Data Segment Register 0; 0x000002A4 ***
CAN4RXDSR0:         equ    $000002A4                                ;*** CAN4RXDSR0 - MSCAN 4 Receive Data Segment Register 0; 0x000002A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR0_DB0:    equ    %00000001
mCAN4RXDSR0_DB1:    equ    %00000010
mCAN4RXDSR0_DB2:    equ    %00000100
mCAN4RXDSR0_DB3:    equ    %00001000
mCAN4RXDSR0_DB4:    equ    %00010000
mCAN4RXDSR0_DB5:    equ    %00100000
mCAN4RXDSR0_DB6:    equ    %01000000
mCAN4RXDSR0_DB7:    equ    %10000000


;*** CAN4RXDSR1 - MSCAN 4 Receive Data Segment Register 1; 0x000002A5 ***
CAN4RXDSR1:         equ    $000002A5                                ;*** CAN4RXDSR1 - MSCAN 4 Receive Data Segment Register 1; 0x000002A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR1_DB0:    equ    %00000001
mCAN4RXDSR1_DB1:    equ    %00000010
mCAN4RXDSR1_DB2:    equ    %00000100
mCAN4RXDSR1_DB3:    equ    %00001000
mCAN4RXDSR1_DB4:    equ    %00010000
mCAN4RXDSR1_DB5:    equ    %00100000
mCAN4RXDSR1_DB6:    equ    %01000000
mCAN4RXDSR1_DB7:    equ    %10000000


;*** CAN4RXDSR2 - MSCAN 4 Receive Data Segment Register 2; 0x000002A6 ***
CAN4RXDSR2:         equ    $000002A6                                ;*** CAN4RXDSR2 - MSCAN 4 Receive Data Segment Register 2; 0x000002A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR2_DB0:    equ    %00000001
mCAN4RXDSR2_DB1:    equ    %00000010
mCAN4RXDSR2_DB2:    equ    %00000100
mCAN4RXDSR2_DB3:    equ    %00001000
mCAN4RXDSR2_DB4:    equ    %00010000
mCAN4RXDSR2_DB5:    equ    %00100000
mCAN4RXDSR2_DB6:    equ    %01000000
mCAN4RXDSR2_DB7:    equ    %10000000


;*** CAN4RXDSR3 - MSCAN 4 Receive Data Segment Register 3; 0x000002A7 ***
CAN4RXDSR3:         equ    $000002A7                                ;*** CAN4RXDSR3 - MSCAN 4 Receive Data Segment Register 3; 0x000002A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR3_DB0:    equ    %00000001
mCAN4RXDSR3_DB1:    equ    %00000010
mCAN4RXDSR3_DB2:    equ    %00000100
mCAN4RXDSR3_DB3:    equ    %00001000
mCAN4RXDSR3_DB4:    equ    %00010000
mCAN4RXDSR3_DB5:    equ    %00100000
mCAN4RXDSR3_DB6:    equ    %01000000
mCAN4RXDSR3_DB7:    equ    %10000000


;*** CAN4RXDSR4 - MSCAN 4 Receive Data Segment Register 4; 0x000002A8 ***
CAN4RXDSR4:         equ    $000002A8                                ;*** CAN4RXDSR4 - MSCAN 4 Receive Data Segment Register 4; 0x000002A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR4_DB0:    equ    %00000001
mCAN4RXDSR4_DB1:    equ    %00000010
mCAN4RXDSR4_DB2:    equ    %00000100
mCAN4RXDSR4_DB3:    equ    %00001000
mCAN4RXDSR4_DB4:    equ    %00010000
mCAN4RXDSR4_DB5:    equ    %00100000
mCAN4RXDSR4_DB6:    equ    %01000000
mCAN4RXDSR4_DB7:    equ    %10000000


;*** CAN4RXDSR5 - MSCAN 4 Receive Data Segment Register 5; 0x000002A9 ***
CAN4RXDSR5:         equ    $000002A9                                ;*** CAN4RXDSR5 - MSCAN 4 Receive Data Segment Register 5; 0x000002A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR5_DB0:    equ    %00000001
mCAN4RXDSR5_DB1:    equ    %00000010
mCAN4RXDSR5_DB2:    equ    %00000100
mCAN4RXDSR5_DB3:    equ    %00001000
mCAN4RXDSR5_DB4:    equ    %00010000
mCAN4RXDSR5_DB5:    equ    %00100000
mCAN4RXDSR5_DB6:    equ    %01000000
mCAN4RXDSR5_DB7:    equ    %10000000


;*** CAN4RXDSR6 - MSCAN 4 Receive Data Segment Register 6; 0x000002AA ***
CAN4RXDSR6:         equ    $000002AA                                ;*** CAN4RXDSR6 - MSCAN 4 Receive Data Segment Register 6; 0x000002AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR6_DB0:    equ    %00000001
mCAN4RXDSR6_DB1:    equ    %00000010
mCAN4RXDSR6_DB2:    equ    %00000100
mCAN4RXDSR6_DB3:    equ    %00001000
mCAN4RXDSR6_DB4:    equ    %00010000
mCAN4RXDSR6_DB5:    equ    %00100000
mCAN4RXDSR6_DB6:    equ    %01000000
mCAN4RXDSR6_DB7:    equ    %10000000


;*** CAN4RXDSR7 - MSCAN 4 Receive Data Segment Register 7; 0x000002AB ***
CAN4RXDSR7:         equ    $000002AB                                ;*** CAN4RXDSR7 - MSCAN 4 Receive Data Segment Register 7; 0x000002AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN4RXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN4RXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN4RXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN4RXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN4RXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN4RXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN4RXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4RXDSR7_DB0:    equ    %00000001
mCAN4RXDSR7_DB1:    equ    %00000010
mCAN4RXDSR7_DB2:    equ    %00000100
mCAN4RXDSR7_DB3:    equ    %00001000
mCAN4RXDSR7_DB4:    equ    %00010000
mCAN4RXDSR7_DB5:    equ    %00100000
mCAN4RXDSR7_DB6:    equ    %01000000
mCAN4RXDSR7_DB7:    equ    %10000000


;*** CAN4RXDLR - MSCAN 4 Receive Data Length Register; 0x000002AC ***
CAN4RXDLR:          equ    $000002AC                                ;*** CAN4RXDLR - MSCAN 4 Receive Data Length Register; 0x000002AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN4RXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN4RXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN4RXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN4RXDLR_DLC0:    equ    %00000001
mCAN4RXDLR_DLC1:    equ    %00000010
mCAN4RXDLR_DLC2:    equ    %00000100
mCAN4RXDLR_DLC3:    equ    %00001000


;*** CAN4RXTSR - MSCAN 4 Receive Time Stamp Register; 0x000002AE ***
CAN4RXTSR:          equ    $000002AE                                ;*** CAN4RXTSR - MSCAN 4 Receive Time Stamp Register; 0x000002AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN4RXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN4RXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN4RXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN4RXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN4RXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN4RXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN4RXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN4RXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN4RXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN4RXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN4RXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN4RXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN4RXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN4RXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN4RXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN4RXTSR_TSR0:    equ    %00000001
mCAN4RXTSR_TSR1:    equ    %00000010
mCAN4RXTSR_TSR2:    equ    %00000100
mCAN4RXTSR_TSR3:    equ    %00001000
mCAN4RXTSR_TSR4:    equ    %00010000
mCAN4RXTSR_TSR5:    equ    %00100000
mCAN4RXTSR_TSR6:    equ    %01000000
mCAN4RXTSR_TSR7:    equ    %10000000
mCAN4RXTSR_TSR8:    equ    %100000000
mCAN4RXTSR_TSR9:    equ    %1000000000
mCAN4RXTSR_TSR10:   equ    %10000000000
mCAN4RXTSR_TSR11:   equ    %100000000000
mCAN4RXTSR_TSR12:   equ    %1000000000000
mCAN4RXTSR_TSR13:   equ    %10000000000000
mCAN4RXTSR_TSR14:   equ    %100000000000000
mCAN4RXTSR_TSR15:   equ    %1000000000000000


;*** CAN4RXTSRH - MSCAN 4 Receive Time Stamp Register High; 0x000002AE ***
CAN4RXTSRH:         equ    $000002AE                                ;*** CAN4RXTSRH - MSCAN 4 Receive Time Stamp Register High; 0x000002AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN4RXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN4RXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN4RXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN4RXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN4RXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN4RXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN4RXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN4RXTSRH_TSR8:   equ    %00000001
mCAN4RXTSRH_TSR9:   equ    %00000010
mCAN4RXTSRH_TSR10:  equ    %00000100
mCAN4RXTSRH_TSR11:  equ    %00001000
mCAN4RXTSRH_TSR12:  equ    %00010000
mCAN4RXTSRH_TSR13:  equ    %00100000
mCAN4RXTSRH_TSR14:  equ    %01000000
mCAN4RXTSRH_TSR15:  equ    %10000000


;*** CAN4RXTSRL - MSCAN 4 Receive Time Stamp Register Low; 0x000002AF ***
CAN4RXTSRL:         equ    $000002AF                                ;*** CAN4RXTSRL - MSCAN 4 Receive Time Stamp Register Low; 0x000002AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4RXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN4RXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN4RXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN4RXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN4RXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN4RXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN4RXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN4RXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN4RXTSRL_TSR0:   equ    %00000001
mCAN4RXTSRL_TSR1:   equ    %00000010
mCAN4RXTSRL_TSR2:   equ    %00000100
mCAN4RXTSRL_TSR3:   equ    %00001000
mCAN4RXTSRL_TSR4:   equ    %00010000
mCAN4RXTSRL_TSR5:   equ    %00100000
mCAN4RXTSRL_TSR6:   equ    %01000000
mCAN4RXTSRL_TSR7:   equ    %10000000


;*** CAN4TXIDR0 - MSCAN 4 Transmit Identifier Register 0; 0x000002B0 ***
CAN4TXIDR0:         equ    $000002B0                                ;*** CAN4TXIDR0 - MSCAN 4 Transmit Identifier Register 0; 0x000002B0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXIDR0_ID21:    equ    0                                         ; Extended format identifier Bit 21
CAN4TXIDR0_ID22:    equ    1                                         ; Extended format identifier Bit 22
CAN4TXIDR0_ID23:    equ    2                                         ; Extended format identifier Bit 23
CAN4TXIDR0_ID24:    equ    3                                         ; Extended format identifier Bit 24
CAN4TXIDR0_ID25:    equ    4                                         ; Extended format identifier Bit 25
CAN4TXIDR0_ID26:    equ    5                                         ; Extended format identifier Bit 26
CAN4TXIDR0_ID27:    equ    6                                         ; Extended format identifier Bit 27
CAN4TXIDR0_ID28:    equ    7                                         ; Extended format identifier Bit 28
; bit position masks
mCAN4TXIDR0_ID21:   equ    %00000001
mCAN4TXIDR0_ID22:   equ    %00000010
mCAN4TXIDR0_ID23:   equ    %00000100
mCAN4TXIDR0_ID24:   equ    %00001000
mCAN4TXIDR0_ID25:   equ    %00010000
mCAN4TXIDR0_ID26:   equ    %00100000
mCAN4TXIDR0_ID27:   equ    %01000000
mCAN4TXIDR0_ID28:   equ    %10000000


;*** CAN4TXIDR1 - MSCAN 4 Transmit Identifier Register 1; 0x000002B1 ***
CAN4TXIDR1:         equ    $000002B1                                ;*** CAN4TXIDR1 - MSCAN 4 Transmit Identifier Register 1; 0x000002B1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXIDR1_ID15:    equ    0                                         ; Extended format identifier Bit 15
CAN4TXIDR1_ID16:    equ    1                                         ; Extended format identifier Bit 16
CAN4TXIDR1_ID17:    equ    2                                         ; Extended format identifier Bit 17
CAN4TXIDR1_IDE:     equ    3                                         ; ID Extended
CAN4TXIDR1_SRR:     equ    4                                         ; Substitute Remote Request
CAN4TXIDR1_ID18:    equ    5                                         ; Extended format identifier Bit 18
CAN4TXIDR1_ID19:    equ    6                                         ; Extended format identifier Bit 19
CAN4TXIDR1_ID20:    equ    7                                         ; Extended format identifier Bit 20
; bit position masks
mCAN4TXIDR1_ID15:   equ    %00000001
mCAN4TXIDR1_ID16:   equ    %00000010
mCAN4TXIDR1_ID17:   equ    %00000100
mCAN4TXIDR1_IDE:    equ    %00001000
mCAN4TXIDR1_SRR:    equ    %00010000
mCAN4TXIDR1_ID18:   equ    %00100000
mCAN4TXIDR1_ID19:   equ    %01000000
mCAN4TXIDR1_ID20:   equ    %10000000


;*** CAN4TXIDR2 - MSCAN 4 Transmit Identifier Register 2; 0x000002B2 ***
CAN4TXIDR2:         equ    $000002B2                                ;*** CAN4TXIDR2 - MSCAN 4 Transmit Identifier Register 2; 0x000002B2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXIDR2_ID7:     equ    0                                         ; Extended format identifier Bit 7
CAN4TXIDR2_ID8:     equ    1                                         ; Extended format identifier Bit 8
CAN4TXIDR2_ID9:     equ    2                                         ; Extended format identifier Bit 9
CAN4TXIDR2_ID10:    equ    3                                         ; Extended format identifier Bit 10
CAN4TXIDR2_ID11:    equ    4                                         ; Extended format identifier Bit 11
CAN4TXIDR2_ID12:    equ    5                                         ; Extended format identifier Bit 12
CAN4TXIDR2_ID13:    equ    6                                         ; Extended format identifier Bit 13
CAN4TXIDR2_ID14:    equ    7                                         ; Extended format identifier Bit 14
; bit position masks
mCAN4TXIDR2_ID7:    equ    %00000001
mCAN4TXIDR2_ID8:    equ    %00000010
mCAN4TXIDR2_ID9:    equ    %00000100
mCAN4TXIDR2_ID10:   equ    %00001000
mCAN4TXIDR2_ID11:   equ    %00010000
mCAN4TXIDR2_ID12:   equ    %00100000
mCAN4TXIDR2_ID13:   equ    %01000000
mCAN4TXIDR2_ID14:   equ    %10000000


;*** CAN4TXIDR3 - MSCAN 4 Transmit Identifier Register 3; 0x000002B3 ***
CAN4TXIDR3:         equ    $000002B3                                ;*** CAN4TXIDR3 - MSCAN 4 Transmit Identifier Register 3; 0x000002B3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXIDR3_RTR:     equ    0                                         ; Remote Transmission Request
CAN4TXIDR3_ID0:     equ    1                                         ; Extended format identifier Bit 0
CAN4TXIDR3_ID1:     equ    2                                         ; Extended format identifier Bit 1
CAN4TXIDR3_ID2:     equ    3                                         ; Extended format identifier Bit 2
CAN4TXIDR3_ID3:     equ    4                                         ; Extended format identifier Bit 3
CAN4TXIDR3_ID4:     equ    5                                         ; Extended format identifier Bit 4
CAN4TXIDR3_ID5:     equ    6                                         ; Extended format identifier Bit 5
CAN4TXIDR3_ID6:     equ    7                                         ; Extended format identifier Bit 6
; bit position masks
mCAN4TXIDR3_RTR:    equ    %00000001
mCAN4TXIDR3_ID0:    equ    %00000010
mCAN4TXIDR3_ID1:    equ    %00000100
mCAN4TXIDR3_ID2:    equ    %00001000
mCAN4TXIDR3_ID3:    equ    %00010000
mCAN4TXIDR3_ID4:    equ    %00100000
mCAN4TXIDR3_ID5:    equ    %01000000
mCAN4TXIDR3_ID6:    equ    %10000000


;*** CAN4TXDSR0 - MSCAN 4 Transmit Data Segment Register 0; 0x000002B4 ***
CAN4TXDSR0:         equ    $000002B4                                ;*** CAN4TXDSR0 - MSCAN 4 Transmit Data Segment Register 0; 0x000002B4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR0_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR0_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR0_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR0_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR0_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR0_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR0_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR0_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR0_DB0:    equ    %00000001
mCAN4TXDSR0_DB1:    equ    %00000010
mCAN4TXDSR0_DB2:    equ    %00000100
mCAN4TXDSR0_DB3:    equ    %00001000
mCAN4TXDSR0_DB4:    equ    %00010000
mCAN4TXDSR0_DB5:    equ    %00100000
mCAN4TXDSR0_DB6:    equ    %01000000
mCAN4TXDSR0_DB7:    equ    %10000000


;*** CAN4TXDSR1 - MSCAN 4 Transmit Data Segment Register 1; 0x000002B5 ***
CAN4TXDSR1:         equ    $000002B5                                ;*** CAN4TXDSR1 - MSCAN 4 Transmit Data Segment Register 1; 0x000002B5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR1_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR1_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR1_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR1_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR1_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR1_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR1_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR1_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR1_DB0:    equ    %00000001
mCAN4TXDSR1_DB1:    equ    %00000010
mCAN4TXDSR1_DB2:    equ    %00000100
mCAN4TXDSR1_DB3:    equ    %00001000
mCAN4TXDSR1_DB4:    equ    %00010000
mCAN4TXDSR1_DB5:    equ    %00100000
mCAN4TXDSR1_DB6:    equ    %01000000
mCAN4TXDSR1_DB7:    equ    %10000000


;*** CAN4TXDSR2 - MSCAN 4 Transmit Data Segment Register 2; 0x000002B6 ***
CAN4TXDSR2:         equ    $000002B6                                ;*** CAN4TXDSR2 - MSCAN 4 Transmit Data Segment Register 2; 0x000002B6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR2_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR2_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR2_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR2_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR2_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR2_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR2_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR2_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR2_DB0:    equ    %00000001
mCAN4TXDSR2_DB1:    equ    %00000010
mCAN4TXDSR2_DB2:    equ    %00000100
mCAN4TXDSR2_DB3:    equ    %00001000
mCAN4TXDSR2_DB4:    equ    %00010000
mCAN4TXDSR2_DB5:    equ    %00100000
mCAN4TXDSR2_DB6:    equ    %01000000
mCAN4TXDSR2_DB7:    equ    %10000000


;*** CAN4TXDSR3 - MSCAN 4 Transmit Data Segment Register 3; 0x000002B7 ***
CAN4TXDSR3:         equ    $000002B7                                ;*** CAN4TXDSR3 - MSCAN 4 Transmit Data Segment Register 3; 0x000002B7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR3_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR3_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR3_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR3_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR3_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR3_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR3_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR3_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR3_DB0:    equ    %00000001
mCAN4TXDSR3_DB1:    equ    %00000010
mCAN4TXDSR3_DB2:    equ    %00000100
mCAN4TXDSR3_DB3:    equ    %00001000
mCAN4TXDSR3_DB4:    equ    %00010000
mCAN4TXDSR3_DB5:    equ    %00100000
mCAN4TXDSR3_DB6:    equ    %01000000
mCAN4TXDSR3_DB7:    equ    %10000000


;*** CAN4TXDSR4 - MSCAN 4 Transmit Data Segment Register 4; 0x000002B8 ***
CAN4TXDSR4:         equ    $000002B8                                ;*** CAN4TXDSR4 - MSCAN 4 Transmit Data Segment Register 4; 0x000002B8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR4_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR4_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR4_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR4_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR4_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR4_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR4_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR4_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR4_DB0:    equ    %00000001
mCAN4TXDSR4_DB1:    equ    %00000010
mCAN4TXDSR4_DB2:    equ    %00000100
mCAN4TXDSR4_DB3:    equ    %00001000
mCAN4TXDSR4_DB4:    equ    %00010000
mCAN4TXDSR4_DB5:    equ    %00100000
mCAN4TXDSR4_DB6:    equ    %01000000
mCAN4TXDSR4_DB7:    equ    %10000000


;*** CAN4TXDSR5 - MSCAN 4 Transmit Data Segment Register 5; 0x000002B9 ***
CAN4TXDSR5:         equ    $000002B9                                ;*** CAN4TXDSR5 - MSCAN 4 Transmit Data Segment Register 5; 0x000002B9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR5_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR5_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR5_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR5_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR5_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR5_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR5_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR5_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR5_DB0:    equ    %00000001
mCAN4TXDSR5_DB1:    equ    %00000010
mCAN4TXDSR5_DB2:    equ    %00000100
mCAN4TXDSR5_DB3:    equ    %00001000
mCAN4TXDSR5_DB4:    equ    %00010000
mCAN4TXDSR5_DB5:    equ    %00100000
mCAN4TXDSR5_DB6:    equ    %01000000
mCAN4TXDSR5_DB7:    equ    %10000000


;*** CAN4TXDSR6 - MSCAN 4 Transmit Data Segment Register 6; 0x000002BA ***
CAN4TXDSR6:         equ    $000002BA                                ;*** CAN4TXDSR6 - MSCAN 4 Transmit Data Segment Register 6; 0x000002BA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR6_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR6_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR6_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR6_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR6_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR6_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR6_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR6_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR6_DB0:    equ    %00000001
mCAN4TXDSR6_DB1:    equ    %00000010
mCAN4TXDSR6_DB2:    equ    %00000100
mCAN4TXDSR6_DB3:    equ    %00001000
mCAN4TXDSR6_DB4:    equ    %00010000
mCAN4TXDSR6_DB5:    equ    %00100000
mCAN4TXDSR6_DB6:    equ    %01000000
mCAN4TXDSR6_DB7:    equ    %10000000


;*** CAN4TXDSR7 - MSCAN 4 Transmit Data Segment Register 7; 0x000002BB ***
CAN4TXDSR7:         equ    $000002BB                                ;*** CAN4TXDSR7 - MSCAN 4 Transmit Data Segment Register 7; 0x000002BB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDSR7_DB0:     equ    0                                         ; Data Bit 0
CAN4TXDSR7_DB1:     equ    1                                         ; Data Bit 1
CAN4TXDSR7_DB2:     equ    2                                         ; Data Bit 2
CAN4TXDSR7_DB3:     equ    3                                         ; Data Bit 3
CAN4TXDSR7_DB4:     equ    4                                         ; Data Bit 4
CAN4TXDSR7_DB5:     equ    5                                         ; Data Bit 5
CAN4TXDSR7_DB6:     equ    6                                         ; Data Bit 6
CAN4TXDSR7_DB7:     equ    7                                         ; Data Bit 7
; bit position masks
mCAN4TXDSR7_DB0:    equ    %00000001
mCAN4TXDSR7_DB1:    equ    %00000010
mCAN4TXDSR7_DB2:    equ    %00000100
mCAN4TXDSR7_DB3:    equ    %00001000
mCAN4TXDSR7_DB4:    equ    %00010000
mCAN4TXDSR7_DB5:    equ    %00100000
mCAN4TXDSR7_DB6:    equ    %01000000
mCAN4TXDSR7_DB7:    equ    %10000000


;*** CAN4TXDLR - MSCAN 4 Transmit Data Length Register; 0x000002BC ***
CAN4TXDLR:          equ    $000002BC                                ;*** CAN4TXDLR - MSCAN 4 Transmit Data Length Register; 0x000002BC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXDLR_DLC0:     equ    0                                         ; Data Length Code Bit 0
CAN4TXDLR_DLC1:     equ    1                                         ; Data Length Code Bit 1
CAN4TXDLR_DLC2:     equ    2                                         ; Data Length Code Bit 2
CAN4TXDLR_DLC3:     equ    3                                         ; Data Length Code Bit 3
; bit position masks
mCAN4TXDLR_DLC0:    equ    %00000001
mCAN4TXDLR_DLC1:    equ    %00000010
mCAN4TXDLR_DLC2:    equ    %00000100
mCAN4TXDLR_DLC3:    equ    %00001000


;*** CAN4TXTBPR - MSCAN 4 Transmit Buffer Priority; 0x000002BD ***
CAN4TXTBPR:         equ    $000002BD                                ;*** CAN4TXTBPR - MSCAN 4 Transmit Buffer Priority; 0x000002BD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXTBPR_PRIO0:   equ    0                                         ; Transmit Buffer Priority Bit 0
CAN4TXTBPR_PRIO1:   equ    1                                         ; Transmit Buffer Priority Bit 1
CAN4TXTBPR_PRIO2:   equ    2                                         ; Transmit Buffer Priority Bit 2
CAN4TXTBPR_PRIO3:   equ    3                                         ; Transmit Buffer Priority Bit 3
CAN4TXTBPR_PRIO4:   equ    4                                         ; Transmit Buffer Priority Bit 4
CAN4TXTBPR_PRIO5:   equ    5                                         ; Transmit Buffer Priority Bit 5
CAN4TXTBPR_PRIO6:   equ    6                                         ; Transmit Buffer Priority Bit 6
CAN4TXTBPR_PRIO7:   equ    7                                         ; Transmit Buffer Priority Bit 7
; bit position masks
mCAN4TXTBPR_PRIO0:  equ    %00000001
mCAN4TXTBPR_PRIO1:  equ    %00000010
mCAN4TXTBPR_PRIO2:  equ    %00000100
mCAN4TXTBPR_PRIO3:  equ    %00001000
mCAN4TXTBPR_PRIO4:  equ    %00010000
mCAN4TXTBPR_PRIO5:  equ    %00100000
mCAN4TXTBPR_PRIO6:  equ    %01000000
mCAN4TXTBPR_PRIO7:  equ    %10000000


;*** CAN4TXTSR - MSCAN 4 Transmit Time Stamp Register; 0x000002BE ***
CAN4TXTSR:          equ    $000002BE                                ;*** CAN4TXTSR - MSCAN 4 Transmit Time Stamp Register; 0x000002BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXTSR_TSR0:     equ    0                                         ; Time Stamp Bit 0
CAN4TXTSR_TSR1:     equ    1                                         ; Time Stamp Bit 1
CAN4TXTSR_TSR2:     equ    2                                         ; Time Stamp Bit 2
CAN4TXTSR_TSR3:     equ    3                                         ; Time Stamp Bit 3
CAN4TXTSR_TSR4:     equ    4                                         ; Time Stamp Bit 4
CAN4TXTSR_TSR5:     equ    5                                         ; Time Stamp Bit 5
CAN4TXTSR_TSR6:     equ    6                                         ; Time Stamp Bit 6
CAN4TXTSR_TSR7:     equ    7                                         ; Time Stamp Bit 7
CAN4TXTSR_TSR8:     equ    8                                         ; Time Stamp Bit 8
CAN4TXTSR_TSR9:     equ    9                                         ; Time Stamp Bit 9
CAN4TXTSR_TSR10:    equ    10                                        ; Time Stamp Bit 10
CAN4TXTSR_TSR11:    equ    11                                        ; Time Stamp Bit 11
CAN4TXTSR_TSR12:    equ    12                                        ; Time Stamp Bit 12
CAN4TXTSR_TSR13:    equ    13                                        ; Time Stamp Bit 13
CAN4TXTSR_TSR14:    equ    14                                        ; Time Stamp Bit 14
CAN4TXTSR_TSR15:    equ    15                                        ; Time Stamp Bit 15
; bit position masks
mCAN4TXTSR_TSR0:    equ    %00000001
mCAN4TXTSR_TSR1:    equ    %00000010
mCAN4TXTSR_TSR2:    equ    %00000100
mCAN4TXTSR_TSR3:    equ    %00001000
mCAN4TXTSR_TSR4:    equ    %00010000
mCAN4TXTSR_TSR5:    equ    %00100000
mCAN4TXTSR_TSR6:    equ    %01000000
mCAN4TXTSR_TSR7:    equ    %10000000
mCAN4TXTSR_TSR8:    equ    %100000000
mCAN4TXTSR_TSR9:    equ    %1000000000
mCAN4TXTSR_TSR10:   equ    %10000000000
mCAN4TXTSR_TSR11:   equ    %100000000000
mCAN4TXTSR_TSR12:   equ    %1000000000000
mCAN4TXTSR_TSR13:   equ    %10000000000000
mCAN4TXTSR_TSR14:   equ    %100000000000000
mCAN4TXTSR_TSR15:   equ    %1000000000000000


;*** CAN4TXTSRH - MSCAN 4 Transmit Time Stamp Register High; 0x000002BE ***
CAN4TXTSRH:         equ    $000002BE                                ;*** CAN4TXTSRH - MSCAN 4 Transmit Time Stamp Register High; 0x000002BE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXTSRH_TSR8:    equ    0                                         ; Time Stamp Bit 8
CAN4TXTSRH_TSR9:    equ    1                                         ; Time Stamp Bit 9
CAN4TXTSRH_TSR10:   equ    2                                         ; Time Stamp Bit 10
CAN4TXTSRH_TSR11:   equ    3                                         ; Time Stamp Bit 11
CAN4TXTSRH_TSR12:   equ    4                                         ; Time Stamp Bit 12
CAN4TXTSRH_TSR13:   equ    5                                         ; Time Stamp Bit 13
CAN4TXTSRH_TSR14:   equ    6                                         ; Time Stamp Bit 14
CAN4TXTSRH_TSR15:   equ    7                                         ; Time Stamp Bit 15
; bit position masks
mCAN4TXTSRH_TSR8:   equ    %00000001
mCAN4TXTSRH_TSR9:   equ    %00000010
mCAN4TXTSRH_TSR10:  equ    %00000100
mCAN4TXTSRH_TSR11:  equ    %00001000
mCAN4TXTSRH_TSR12:  equ    %00010000
mCAN4TXTSRH_TSR13:  equ    %00100000
mCAN4TXTSRH_TSR14:  equ    %01000000
mCAN4TXTSRH_TSR15:  equ    %10000000


;*** CAN4TXTSRL - MSCAN 4 Transmit Time Stamp Register Low; 0x000002BF ***
CAN4TXTSRL:         equ    $000002BF                                ;*** CAN4TXTSRL - MSCAN 4 Transmit Time Stamp Register Low; 0x000002BF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CAN4TXTSRL_TSR0:    equ    0                                         ; Time Stamp Bit 0
CAN4TXTSRL_TSR1:    equ    1                                         ; Time Stamp Bit 1
CAN4TXTSRL_TSR2:    equ    2                                         ; Time Stamp Bit 2
CAN4TXTSRL_TSR3:    equ    3                                         ; Time Stamp Bit 3
CAN4TXTSRL_TSR4:    equ    4                                         ; Time Stamp Bit 4
CAN4TXTSRL_TSR5:    equ    5                                         ; Time Stamp Bit 5
CAN4TXTSRL_TSR6:    equ    6                                         ; Time Stamp Bit 6
CAN4TXTSRL_TSR7:    equ    7                                         ; Time Stamp Bit 7
; bit position masks
mCAN4TXTSRL_TSR0:   equ    %00000001
mCAN4TXTSRL_TSR1:   equ    %00000010
mCAN4TXTSRL_TSR2:   equ    %00000100
mCAN4TXTSRL_TSR3:   equ    %00001000
mCAN4TXTSRL_TSR4:   equ    %00010000
mCAN4TXTSRL_TSR5:   equ    %00100000
mCAN4TXTSRL_TSR6:   equ    %01000000
mCAN4TXTSRL_TSR7:   equ    %10000000


;*** ATD0CTL01 - ATD 0 Control Register 01; 0x000002C0 ***
ATD0CTL01:          equ    $000002C0                                ;*** ATD0CTL01 - ATD 0 Control Register 01; 0x000002C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL01_ETRIGCH0: equ    0                                         ; External Trigger Channel Select Bit 0
ATD0CTL01_ETRIGCH1: equ    1                                         ; External Trigger Channel Select Bit 1
ATD0CTL01_ETRIGCH2: equ    2                                         ; External Trigger Channel Select Bit 2
ATD0CTL01_ETRIGSEL: equ    7                                         ; External Trigger Source Select
ATD0CTL01_WRAP0:    equ    8                                         ; Wrap Around Channel Select Bit 0
ATD0CTL01_WRAP1:    equ    9                                         ; Wrap Around Channel Select Bit 1
ATD0CTL01_WRAP2:    equ    10                                        ; Wrap Around Channel Select Bit 2
; bit position masks
mATD0CTL01_ETRIGCH0: equ    %00000001
mATD0CTL01_ETRIGCH1: equ    %00000010
mATD0CTL01_ETRIGCH2: equ    %00000100
mATD0CTL01_ETRIGSEL: equ    %10000000
mATD0CTL01_WRAP0:   equ    %100000000
mATD0CTL01_WRAP1:   equ    %1000000000
mATD0CTL01_WRAP2:   equ    %10000000000


;*** ATD0CTL0 - ATD 0 Control Register 0; 0x000002C0 ***
ATD0CTL0:           equ    $000002C0                                ;*** ATD0CTL0 - ATD 0 Control Register 0; 0x000002C0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL0_WRAP0:     equ    0                                         ; Wrap Around Channel Select Bit 0
ATD0CTL0_WRAP1:     equ    1                                         ; Wrap Around Channel Select Bit 1
ATD0CTL0_WRAP2:     equ    2                                         ; Wrap Around Channel Select Bit 2
; bit position masks
mATD0CTL0_WRAP0:    equ    %00000001
mATD0CTL0_WRAP1:    equ    %00000010
mATD0CTL0_WRAP2:    equ    %00000100


;*** ATD0CTL1 - ATD0 Control Register 1; 0x000002C1 ***
ATD0CTL1:           equ    $000002C1                                ;*** ATD0CTL1 - ATD0 Control Register 1; 0x000002C1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL1_ETRIGCH0:  equ    0                                         ; External Trigger Channel Select Bit 0
ATD0CTL1_ETRIGCH1:  equ    1                                         ; External Trigger Channel Select Bit 1
ATD0CTL1_ETRIGCH2:  equ    2                                         ; External Trigger Channel Select Bit 2
ATD0CTL1_ETRIGSEL:  equ    7                                         ; External Trigger Source Select
; bit position masks
mATD0CTL1_ETRIGCH0: equ    %00000001
mATD0CTL1_ETRIGCH1: equ    %00000010
mATD0CTL1_ETRIGCH2: equ    %00000100
mATD0CTL1_ETRIGSEL: equ    %10000000


;*** ATD0CTL23 - ATD 0 Control Register 23; 0x000002C2 ***
ATD0CTL23:          equ    $000002C2                                ;*** ATD0CTL23 - ATD 0 Control Register 23; 0x000002C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL23_FRZ0:     equ    0                                         ; Background Debug Freeze Enable Bit 0
ATD0CTL23_FRZ1:     equ    1                                         ; Background Debug Freeze Enable Bit 1
ATD0CTL23_FIFO:     equ    2                                         ; Result Register FIFO Mode
ATD0CTL23_S1C:      equ    3                                         ; Conversion Sequence Length 1
ATD0CTL23_S2C:      equ    4                                         ; Conversion Sequence Length 2
ATD0CTL23_S4C:      equ    5                                         ; Conversion Sequence Length 4
ATD0CTL23_S8C:      equ    6                                         ; Conversion Sequence Length 8
ATD0CTL23_ASCIF:    equ    8                                         ; ATD 0 Sequence Complete Interrupt Flag
ATD0CTL23_ASCIE:    equ    9                                         ; ATD 0 Sequence Complete Interrupt Enable
ATD0CTL23_ETRIGE:   equ    10                                        ; External Trigger Mode enable
ATD0CTL23_ETRIGP:   equ    11                                        ; External Trigger Polarity
ATD0CTL23_ETRIGLE:  equ    12                                        ; External Trigger Level/Edge control
ATD0CTL23_AWAI:     equ    13                                        ; ATD Power Down in Wait Mode
ATD0CTL23_AFFC:     equ    14                                        ; ATD Fast Conversion Complete Flag Clear
ATD0CTL23_ADPU:     equ    15                                        ; ATD Disable / Power Down
; bit position masks
mATD0CTL23_FRZ0:    equ    %00000001
mATD0CTL23_FRZ1:    equ    %00000010
mATD0CTL23_FIFO:    equ    %00000100
mATD0CTL23_S1C:     equ    %00001000
mATD0CTL23_S2C:     equ    %00010000
mATD0CTL23_S4C:     equ    %00100000
mATD0CTL23_S8C:     equ    %01000000
mATD0CTL23_ASCIF:   equ    %100000000
mATD0CTL23_ASCIE:   equ    %1000000000
mATD0CTL23_ETRIGE:  equ    %10000000000
mATD0CTL23_ETRIGP:  equ    %100000000000
mATD0CTL23_ETRIGLE: equ    %1000000000000
mATD0CTL23_AWAI:    equ    %10000000000000
mATD0CTL23_AFFC:    equ    %100000000000000
mATD0CTL23_ADPU:    equ    %1000000000000000


;*** ATD0CTL2 - ATD 0 Control Register 2; 0x000002C2 ***
ATD0CTL2:           equ    $000002C2                                ;*** ATD0CTL2 - ATD 0 Control Register 2; 0x000002C2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL2_ASCIF:     equ    0                                         ; ATD 0 Sequence Complete Interrupt Flag
ATD0CTL2_ASCIE:     equ    1                                         ; ATD 0 Sequence Complete Interrupt Enable
ATD0CTL2_ETRIGE:    equ    2                                         ; External Trigger Mode enable
ATD0CTL2_ETRIGP:    equ    3                                         ; External Trigger Polarity
ATD0CTL2_ETRIGLE:   equ    4                                         ; External Trigger Level/Edge control
ATD0CTL2_AWAI:      equ    5                                         ; ATD Power Down in Wait Mode
ATD0CTL2_AFFC:      equ    6                                         ; ATD Fast Conversion Complete Flag Clear
ATD0CTL2_ADPU:      equ    7                                         ; ATD Disable / Power Down
; bit position masks
mATD0CTL2_ASCIF:    equ    %00000001
mATD0CTL2_ASCIE:    equ    %00000010
mATD0CTL2_ETRIGE:   equ    %00000100
mATD0CTL2_ETRIGP:   equ    %00001000
mATD0CTL2_ETRIGLE:  equ    %00010000
mATD0CTL2_AWAI:     equ    %00100000
mATD0CTL2_AFFC:     equ    %01000000
mATD0CTL2_ADPU:     equ    %10000000


;*** ATD0CTL3 - ATD 0 Control Register 3; 0x000002C3 ***
ATD0CTL3:           equ    $000002C3                                ;*** ATD0CTL3 - ATD 0 Control Register 3; 0x000002C3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL3_FRZ0:      equ    0                                         ; Background Debug Freeze Enable Bit 0
ATD0CTL3_FRZ1:      equ    1                                         ; Background Debug Freeze Enable Bit 1
ATD0CTL3_FIFO:      equ    2                                         ; Result Register FIFO Mode
ATD0CTL3_S1C:       equ    3                                         ; Conversion Sequence Length 1
ATD0CTL3_S2C:       equ    4                                         ; Conversion Sequence Length 2
ATD0CTL3_S4C:       equ    5                                         ; Conversion Sequence Length 4
ATD0CTL3_S8C:       equ    6                                         ; Conversion Sequence Length 8
; bit position masks
mATD0CTL3_FRZ0:     equ    %00000001
mATD0CTL3_FRZ1:     equ    %00000010
mATD0CTL3_FIFO:     equ    %00000100
mATD0CTL3_S1C:      equ    %00001000
mATD0CTL3_S2C:      equ    %00010000
mATD0CTL3_S4C:      equ    %00100000
mATD0CTL3_S8C:      equ    %01000000


;*** ATD0CTL45 - ATD 0 Control Register 45; 0x000002C4 ***
ATD0CTL45:          equ    $000002C4                                ;*** ATD0CTL45 - ATD 0 Control Register 45; 0x000002C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL45_CA:       equ    0                                         ; Analog Input Channel Select Code A
ATD0CTL45_CB:       equ    1                                         ; Analog Input Channel Select Code B
ATD0CTL45_CC:       equ    2                                         ; Analog Input Channel Select Code C
ATD0CTL45_MULT:     equ    4                                         ; Multi-Channel Sample Mode
ATD0CTL45_SCAN:     equ    5                                         ; Continuous Conversion Sequence Mode
ATD0CTL45_DSGN:     equ    6                                         ; Signed/Unsigned Result Data Mode
ATD0CTL45_DJM:      equ    7                                         ; Result Register Data Justification Mode
ATD0CTL45_PRS0:     equ    8                                         ; ATD Clock Prescaler 0
ATD0CTL45_PRS1:     equ    9                                         ; ATD Clock Prescaler 1
ATD0CTL45_PRS2:     equ    10                                        ; ATD Clock Prescaler 2
ATD0CTL45_PRS3:     equ    11                                        ; ATD Clock Prescaler 3
ATD0CTL45_PRS4:     equ    12                                        ; ATD Clock Prescaler 4
ATD0CTL45_SMP0:     equ    13                                        ; Sample Time Select 0
ATD0CTL45_SMP1:     equ    14                                        ; Sample Time Select 1
ATD0CTL45_SRES8:    equ    15                                        ; ATD Resolution Select
; bit position masks
mATD0CTL45_CA:      equ    %00000001
mATD0CTL45_CB:      equ    %00000010
mATD0CTL45_CC:      equ    %00000100
mATD0CTL45_MULT:    equ    %00010000
mATD0CTL45_SCAN:    equ    %00100000
mATD0CTL45_DSGN:    equ    %01000000
mATD0CTL45_DJM:     equ    %10000000
mATD0CTL45_PRS0:    equ    %100000000
mATD0CTL45_PRS1:    equ    %1000000000
mATD0CTL45_PRS2:    equ    %10000000000
mATD0CTL45_PRS3:    equ    %100000000000
mATD0CTL45_PRS4:    equ    %1000000000000
mATD0CTL45_SMP0:    equ    %10000000000000
mATD0CTL45_SMP1:    equ    %100000000000000
mATD0CTL45_SRES8:   equ    %1000000000000000


;*** ATD0CTL4 - ATD 0 Control Register 4; 0x000002C4 ***
ATD0CTL4:           equ    $000002C4                                ;*** ATD0CTL4 - ATD 0 Control Register 4; 0x000002C4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL4_PRS0:      equ    0                                         ; ATD Clock Prescaler 0
ATD0CTL4_PRS1:      equ    1                                         ; ATD Clock Prescaler 1
ATD0CTL4_PRS2:      equ    2                                         ; ATD Clock Prescaler 2
ATD0CTL4_PRS3:      equ    3                                         ; ATD Clock Prescaler 3
ATD0CTL4_PRS4:      equ    4                                         ; ATD Clock Prescaler 4
ATD0CTL4_SMP0:      equ    5                                         ; Sample Time Select 0
ATD0CTL4_SMP1:      equ    6                                         ; Sample Time Select 1
ATD0CTL4_SRES8:     equ    7                                         ; ATD Resolution Select
; bit position masks
mATD0CTL4_PRS0:     equ    %00000001
mATD0CTL4_PRS1:     equ    %00000010
mATD0CTL4_PRS2:     equ    %00000100
mATD0CTL4_PRS3:     equ    %00001000
mATD0CTL4_PRS4:     equ    %00010000
mATD0CTL4_SMP0:     equ    %00100000
mATD0CTL4_SMP1:     equ    %01000000
mATD0CTL4_SRES8:    equ    %10000000


;*** ATD0CTL5 - ATD 0 Control Register 5; 0x000002C5 ***
ATD0CTL5:           equ    $000002C5                                ;*** ATD0CTL5 - ATD 0 Control Register 5; 0x000002C5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0CTL5_CA:        equ    0                                         ; Analog Input Channel Select Code A
ATD0CTL5_CB:        equ    1                                         ; Analog Input Channel Select Code B
ATD0CTL5_CC:        equ    2                                         ; Analog Input Channel Select Code C
ATD0CTL5_MULT:      equ    4                                         ; Multi-Channel Sample Mode
ATD0CTL5_SCAN:      equ    5                                         ; Continuous Conversion Sequence Mode
ATD0CTL5_DSGN:      equ    6                                         ; Signed/Unsigned Result Data Mode
ATD0CTL5_DJM:       equ    7                                         ; Result Register Data Justification Mode
; bit position masks
mATD0CTL5_CA:       equ    %00000001
mATD0CTL5_CB:       equ    %00000010
mATD0CTL5_CC:       equ    %00000100
mATD0CTL5_MULT:     equ    %00010000
mATD0CTL5_SCAN:     equ    %00100000
mATD0CTL5_DSGN:     equ    %01000000
mATD0CTL5_DJM:      equ    %10000000


;*** ATD0STAT0 - ATD 0 Status Register 0; 0x000002C6 ***
ATD0STAT0:          equ    $000002C6                                ;*** ATD0STAT0 - ATD 0 Status Register 0; 0x000002C6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0STAT0_CC0:      equ    0                                         ; Conversion Counter 0
ATD0STAT0_CC1:      equ    1                                         ; Conversion Counter 1
ATD0STAT0_CC2:      equ    2                                         ; Conversion Counter 2
ATD0STAT0_FIFOR:    equ    4                                         ; FIFO Over Run Flag
ATD0STAT0_ETORF:    equ    5                                         ; External Trigger Overrun Flag
ATD0STAT0_SCF:      equ    7                                         ; Sequence Complete Flag
; bit position masks
mATD0STAT0_CC0:     equ    %00000001
mATD0STAT0_CC1:     equ    %00000010
mATD0STAT0_CC2:     equ    %00000100
mATD0STAT0_FIFOR:   equ    %00010000
mATD0STAT0_ETORF:   equ    %00100000
mATD0STAT0_SCF:     equ    %10000000


;*** ATD0TEST1 - ATD0 Test Register; 0x000002C9 ***
ATD0TEST1:          equ    $000002C9                                ;*** ATD0TEST1 - ATD0 Test Register; 0x000002C9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0TEST1_SC:       equ    0                                         ; Special Channel Conversion Bit
; bit position masks
mATD0TEST1_SC:      equ    %00000001


;*** ATD0STAT1 - ATD 0 Status Register 1; 0x000002CB ***
ATD0STAT1:          equ    $000002CB                                ;*** ATD0STAT1 - ATD 0 Status Register 1; 0x000002CB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0STAT1_CCF0:     equ    0                                         ; Conversion Complete Flag 0
ATD0STAT1_CCF1:     equ    1                                         ; Conversion Complete Flag 1
ATD0STAT1_CCF2:     equ    2                                         ; Conversion Complete Flag 2
ATD0STAT1_CCF3:     equ    3                                         ; Conversion Complete Flag 3
ATD0STAT1_CCF4:     equ    4                                         ; Conversion Complete Flag 4
ATD0STAT1_CCF5:     equ    5                                         ; Conversion Complete Flag 5
ATD0STAT1_CCF6:     equ    6                                         ; Conversion Complete Flag 6
ATD0STAT1_CCF7:     equ    7                                         ; Conversion Complete Flag 7
; bit position masks
mATD0STAT1_CCF0:    equ    %00000001
mATD0STAT1_CCF1:    equ    %00000010
mATD0STAT1_CCF2:    equ    %00000100
mATD0STAT1_CCF3:    equ    %00001000
mATD0STAT1_CCF4:    equ    %00010000
mATD0STAT1_CCF5:    equ    %00100000
mATD0STAT1_CCF6:    equ    %01000000
mATD0STAT1_CCF7:    equ    %10000000


;*** ATD0DIEN - ATD 0 Input Enable Register; 0x000002CD ***
ATD0DIEN:           equ    $000002CD                                ;*** ATD0DIEN - ATD 0 Input Enable Register; 0x000002CD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DIEN_IEN0:      equ    0                                         ; ATD Digital Input Enable on channel 0
ATD0DIEN_IEN1:      equ    1                                         ; ATD Digital Input Enable on channel 1
ATD0DIEN_IEN2:      equ    2                                         ; ATD Digital Input Enable on channel 2
ATD0DIEN_IEN3:      equ    3                                         ; ATD Digital Input Enable on channel 3
ATD0DIEN_IEN4:      equ    4                                         ; ATD Digital Input Enable on channel 4
ATD0DIEN_IEN5:      equ    5                                         ; ATD Digital Input Enable on channel 5
ATD0DIEN_IEN6:      equ    6                                         ; ATD Digital Input Enable on channel 6
ATD0DIEN_IEN7:      equ    7                                         ; ATD Digital Input Enable on channel 7
; bit position masks
mATD0DIEN_IEN0:     equ    %00000001
mATD0DIEN_IEN1:     equ    %00000010
mATD0DIEN_IEN2:     equ    %00000100
mATD0DIEN_IEN3:     equ    %00001000
mATD0DIEN_IEN4:     equ    %00010000
mATD0DIEN_IEN5:     equ    %00100000
mATD0DIEN_IEN6:     equ    %01000000
mATD0DIEN_IEN7:     equ    %10000000


;*** ATD0PTAD0 - ATD 0 Port AD0 Register; 0x000002CF ***
ATD0PTAD0:          equ    $000002CF                                ;*** ATD0PTAD0 - ATD 0 Port AD0 Register; 0x000002CF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0PTAD0_PTAD0:    equ    0                                         ; A/D Channel 0 (AN0) Digital Input
ATD0PTAD0_PTAD1:    equ    1                                         ; A/D Channel 1 (AN1) Digital Input
ATD0PTAD0_PTAD2:    equ    2                                         ; A/D Channel 2 (AN2) Digital Input
ATD0PTAD0_PTAD3:    equ    3                                         ; A/D Channel 3 (AN3) Digital Input
ATD0PTAD0_PTAD4:    equ    4                                         ; A/D Channel 4 (AN4) Digital Input
ATD0PTAD0_PTAD5:    equ    5                                         ; A/D Channel 5 (AN5) Digital Input
ATD0PTAD0_PTAD6:    equ    6                                         ; A/D Channel 6 (AN6) Digital Input
ATD0PTAD0_PTAD7:    equ    7                                         ; A/D Channel 7 (AN7) Digital Input
; bit position masks
mATD0PTAD0_PTAD0:   equ    %00000001
mATD0PTAD0_PTAD1:   equ    %00000010
mATD0PTAD0_PTAD2:   equ    %00000100
mATD0PTAD0_PTAD3:   equ    %00001000
mATD0PTAD0_PTAD4:   equ    %00010000
mATD0PTAD0_PTAD5:   equ    %00100000
mATD0PTAD0_PTAD6:   equ    %01000000
mATD0PTAD0_PTAD7:   equ    %10000000


;*** ATD0DR0 - ATD 0 Conversion Result Register 0; 0x000002D0 ***
ATD0DR0:            equ    $000002D0                                ;*** ATD0DR0 - ATD 0 Conversion Result Register 0; 0x000002D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR0_BIT6:       equ    6                                         ; Bit 6
ATD0DR0_BIT7:       equ    7                                         ; Bit 7
ATD0DR0_BIT8:       equ    8                                         ; Bit 8
ATD0DR0_BIT9:       equ    9                                         ; Bit 9
ATD0DR0_BIT10:      equ    10                                        ; Bit 10
ATD0DR0_BIT11:      equ    11                                        ; Bit 11
ATD0DR0_BIT12:      equ    12                                        ; Bit 12
ATD0DR0_BIT13:      equ    13                                        ; Bit 13
ATD0DR0_BIT14:      equ    14                                        ; Bit 14
ATD0DR0_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR0_BIT6:      equ    %01000000
mATD0DR0_BIT7:      equ    %10000000
mATD0DR0_BIT8:      equ    %100000000
mATD0DR0_BIT9:      equ    %1000000000
mATD0DR0_BIT10:     equ    %10000000000
mATD0DR0_BIT11:     equ    %100000000000
mATD0DR0_BIT12:     equ    %1000000000000
mATD0DR0_BIT13:     equ    %10000000000000
mATD0DR0_BIT14:     equ    %100000000000000
mATD0DR0_BIT15:     equ    %1000000000000000


;*** ATD0DR0H - ATD 0 Conversion Result Register 0 High; 0x000002D0 ***
ATD0DR0H:           equ    $000002D0                                ;*** ATD0DR0H - ATD 0 Conversion Result Register 0 High; 0x000002D0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR0H_BIT8:      equ    0                                         ; Bit 8
ATD0DR0H_BIT9:      equ    1                                         ; Bit 9
ATD0DR0H_BIT10:     equ    2                                         ; Bit 10
ATD0DR0H_BIT11:     equ    3                                         ; Bit 11
ATD0DR0H_BIT12:     equ    4                                         ; Bit 12
ATD0DR0H_BIT13:     equ    5                                         ; Bit 13
ATD0DR0H_BIT14:     equ    6                                         ; Bit 14
ATD0DR0H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR0H_BIT8:     equ    %00000001
mATD0DR0H_BIT9:     equ    %00000010
mATD0DR0H_BIT10:    equ    %00000100
mATD0DR0H_BIT11:    equ    %00001000
mATD0DR0H_BIT12:    equ    %00010000
mATD0DR0H_BIT13:    equ    %00100000
mATD0DR0H_BIT14:    equ    %01000000
mATD0DR0H_BIT15:    equ    %10000000


;*** ATD0DR0L - ATD 0 Conversion Result Register 0 Low; 0x000002D1 ***
ATD0DR0L:           equ    $000002D1                                ;*** ATD0DR0L - ATD 0 Conversion Result Register 0 Low; 0x000002D1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR0L_BIT6:      equ    6                                         ; Bit 6
ATD0DR0L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR0L_BIT6:     equ    %01000000
mATD0DR0L_BIT7:     equ    %10000000


;*** ATD0DR1 - ATD 0 Conversion Result Register 1; 0x000002D2 ***
ATD0DR1:            equ    $000002D2                                ;*** ATD0DR1 - ATD 0 Conversion Result Register 1; 0x000002D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR1_BIT6:       equ    6                                         ; Bit 6
ATD0DR1_BIT7:       equ    7                                         ; Bit 7
ATD0DR1_BIT8:       equ    8                                         ; Bit 8
ATD0DR1_BIT9:       equ    9                                         ; Bit 9
ATD0DR1_BIT10:      equ    10                                        ; Bit 10
ATD0DR1_BIT11:      equ    11                                        ; Bit 11
ATD0DR1_BIT12:      equ    12                                        ; Bit 12
ATD0DR1_BIT13:      equ    13                                        ; Bit 13
ATD0DR1_BIT14:      equ    14                                        ; Bit 14
ATD0DR1_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR1_BIT6:      equ    %01000000
mATD0DR1_BIT7:      equ    %10000000
mATD0DR1_BIT8:      equ    %100000000
mATD0DR1_BIT9:      equ    %1000000000
mATD0DR1_BIT10:     equ    %10000000000
mATD0DR1_BIT11:     equ    %100000000000
mATD0DR1_BIT12:     equ    %1000000000000
mATD0DR1_BIT13:     equ    %10000000000000
mATD0DR1_BIT14:     equ    %100000000000000
mATD0DR1_BIT15:     equ    %1000000000000000


;*** ATD0DR1H - ATD 0 Conversion Result Register 1 High; 0x000002D2 ***
ATD0DR1H:           equ    $000002D2                                ;*** ATD0DR1H - ATD 0 Conversion Result Register 1 High; 0x000002D2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR1H_BIT8:      equ    0                                         ; Bit 8
ATD0DR1H_BIT9:      equ    1                                         ; Bit 9
ATD0DR1H_BIT10:     equ    2                                         ; Bit 10
ATD0DR1H_BIT11:     equ    3                                         ; Bit 11
ATD0DR1H_BIT12:     equ    4                                         ; Bit 12
ATD0DR1H_BIT13:     equ    5                                         ; Bit 13
ATD0DR1H_BIT14:     equ    6                                         ; Bit 14
ATD0DR1H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR1H_BIT8:     equ    %00000001
mATD0DR1H_BIT9:     equ    %00000010
mATD0DR1H_BIT10:    equ    %00000100
mATD0DR1H_BIT11:    equ    %00001000
mATD0DR1H_BIT12:    equ    %00010000
mATD0DR1H_BIT13:    equ    %00100000
mATD0DR1H_BIT14:    equ    %01000000
mATD0DR1H_BIT15:    equ    %10000000


;*** ATD0DR1L - ATD 0 Conversion Result Register 1 Low; 0x000002D3 ***
ATD0DR1L:           equ    $000002D3                                ;*** ATD0DR1L - ATD 0 Conversion Result Register 1 Low; 0x000002D3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR1L_BIT6:      equ    6                                         ; Bit 6
ATD0DR1L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR1L_BIT6:     equ    %01000000
mATD0DR1L_BIT7:     equ    %10000000


;*** ATD0DR2 - ATD 0 Conversion Result Register 2; 0x000002D4 ***
ATD0DR2:            equ    $000002D4                                ;*** ATD0DR2 - ATD 0 Conversion Result Register 2; 0x000002D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR2_BIT6:       equ    6                                         ; Bit 6
ATD0DR2_BIT7:       equ    7                                         ; Bit 7
ATD0DR2_BIT8:       equ    8                                         ; Bit 8
ATD0DR2_BIT9:       equ    9                                         ; Bit 9
ATD0DR2_BIT10:      equ    10                                        ; Bit 10
ATD0DR2_BIT11:      equ    11                                        ; Bit 11
ATD0DR2_BIT12:      equ    12                                        ; Bit 12
ATD0DR2_BIT13:      equ    13                                        ; Bit 13
ATD0DR2_BIT14:      equ    14                                        ; Bit 14
ATD0DR2_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR2_BIT6:      equ    %01000000
mATD0DR2_BIT7:      equ    %10000000
mATD0DR2_BIT8:      equ    %100000000
mATD0DR2_BIT9:      equ    %1000000000
mATD0DR2_BIT10:     equ    %10000000000
mATD0DR2_BIT11:     equ    %100000000000
mATD0DR2_BIT12:     equ    %1000000000000
mATD0DR2_BIT13:     equ    %10000000000000
mATD0DR2_BIT14:     equ    %100000000000000
mATD0DR2_BIT15:     equ    %1000000000000000


;*** ATD0DR2H - ATD 0 Conversion Result Register 2 High; 0x000002D4 ***
ATD0DR2H:           equ    $000002D4                                ;*** ATD0DR2H - ATD 0 Conversion Result Register 2 High; 0x000002D4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR2H_BIT8:      equ    0                                         ; Bit 8
ATD0DR2H_BIT9:      equ    1                                         ; Bit 9
ATD0DR2H_BIT10:     equ    2                                         ; Bit 10
ATD0DR2H_BIT11:     equ    3                                         ; Bit 11
ATD0DR2H_BIT12:     equ    4                                         ; Bit 12
ATD0DR2H_BIT13:     equ    5                                         ; Bit 13
ATD0DR2H_BIT14:     equ    6                                         ; Bit 14
ATD0DR2H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR2H_BIT8:     equ    %00000001
mATD0DR2H_BIT9:     equ    %00000010
mATD0DR2H_BIT10:    equ    %00000100
mATD0DR2H_BIT11:    equ    %00001000
mATD0DR2H_BIT12:    equ    %00010000
mATD0DR2H_BIT13:    equ    %00100000
mATD0DR2H_BIT14:    equ    %01000000
mATD0DR2H_BIT15:    equ    %10000000


;*** ATD0DR2L - ATD 0 Conversion Result Register 2 Low; 0x000002D5 ***
ATD0DR2L:           equ    $000002D5                                ;*** ATD0DR2L - ATD 0 Conversion Result Register 2 Low; 0x000002D5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR2L_BIT6:      equ    6                                         ; Bit 6
ATD0DR2L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR2L_BIT6:     equ    %01000000
mATD0DR2L_BIT7:     equ    %10000000


;*** ATD0DR3 - ATD 0 Conversion Result Register 3; 0x000002D6 ***
ATD0DR3:            equ    $000002D6                                ;*** ATD0DR3 - ATD 0 Conversion Result Register 3; 0x000002D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR3_BIT6:       equ    6                                         ; Bit 6
ATD0DR3_BIT7:       equ    7                                         ; Bit 7
ATD0DR3_BIT8:       equ    8                                         ; Bit 8
ATD0DR3_BIT9:       equ    9                                         ; Bit 9
ATD0DR3_BIT10:      equ    10                                        ; Bit 10
ATD0DR3_BIT11:      equ    11                                        ; Bit 11
ATD0DR3_BIT12:      equ    12                                        ; Bit 12
ATD0DR3_BIT13:      equ    13                                        ; Bit 13
ATD0DR3_BIT14:      equ    14                                        ; Bit 14
ATD0DR3_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR3_BIT6:      equ    %01000000
mATD0DR3_BIT7:      equ    %10000000
mATD0DR3_BIT8:      equ    %100000000
mATD0DR3_BIT9:      equ    %1000000000
mATD0DR3_BIT10:     equ    %10000000000
mATD0DR3_BIT11:     equ    %100000000000
mATD0DR3_BIT12:     equ    %1000000000000
mATD0DR3_BIT13:     equ    %10000000000000
mATD0DR3_BIT14:     equ    %100000000000000
mATD0DR3_BIT15:     equ    %1000000000000000


;*** ATD0DR3H - ATD 0 Conversion Result Register 3 High; 0x000002D6 ***
ATD0DR3H:           equ    $000002D6                                ;*** ATD0DR3H - ATD 0 Conversion Result Register 3 High; 0x000002D6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR3H_BIT8:      equ    0                                         ; Bit 8
ATD0DR3H_BIT9:      equ    1                                         ; Bit 9
ATD0DR3H_BIT10:     equ    2                                         ; Bit 10
ATD0DR3H_BIT11:     equ    3                                         ; Bit 11
ATD0DR3H_BIT12:     equ    4                                         ; Bit 12
ATD0DR3H_BIT13:     equ    5                                         ; Bit 13
ATD0DR3H_BIT14:     equ    6                                         ; Bit 14
ATD0DR3H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR3H_BIT8:     equ    %00000001
mATD0DR3H_BIT9:     equ    %00000010
mATD0DR3H_BIT10:    equ    %00000100
mATD0DR3H_BIT11:    equ    %00001000
mATD0DR3H_BIT12:    equ    %00010000
mATD0DR3H_BIT13:    equ    %00100000
mATD0DR3H_BIT14:    equ    %01000000
mATD0DR3H_BIT15:    equ    %10000000


;*** ATD0DR3L - ATD 0 Conversion Result Register 3 Low; 0x000002D7 ***
ATD0DR3L:           equ    $000002D7                                ;*** ATD0DR3L - ATD 0 Conversion Result Register 3 Low; 0x000002D7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR3L_BIT6:      equ    6                                         ; Bit 6
ATD0DR3L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR3L_BIT6:     equ    %01000000
mATD0DR3L_BIT7:     equ    %10000000


;*** ATD0DR4 - ATD 0 Conversion Result Register 4; 0x000002D8 ***
ATD0DR4:            equ    $000002D8                                ;*** ATD0DR4 - ATD 0 Conversion Result Register 4; 0x000002D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR4_BIT6:       equ    6                                         ; Bit 6
ATD0DR4_BIT7:       equ    7                                         ; Bit 7
ATD0DR4_BIT8:       equ    8                                         ; Bit 8
ATD0DR4_BIT9:       equ    9                                         ; Bit 9
ATD0DR4_BIT10:      equ    10                                        ; Bit 10
ATD0DR4_BIT11:      equ    11                                        ; Bit 11
ATD0DR4_BIT12:      equ    12                                        ; Bit 12
ATD0DR4_BIT13:      equ    13                                        ; Bit 13
ATD0DR4_BIT14:      equ    14                                        ; Bit 14
ATD0DR4_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR4_BIT6:      equ    %01000000
mATD0DR4_BIT7:      equ    %10000000
mATD0DR4_BIT8:      equ    %100000000
mATD0DR4_BIT9:      equ    %1000000000
mATD0DR4_BIT10:     equ    %10000000000
mATD0DR4_BIT11:     equ    %100000000000
mATD0DR4_BIT12:     equ    %1000000000000
mATD0DR4_BIT13:     equ    %10000000000000
mATD0DR4_BIT14:     equ    %100000000000000
mATD0DR4_BIT15:     equ    %1000000000000000


;*** ATD0DR4H - ATD 0 Conversion Result Register 4 High; 0x000002D8 ***
ATD0DR4H:           equ    $000002D8                                ;*** ATD0DR4H - ATD 0 Conversion Result Register 4 High; 0x000002D8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR4H_BIT8:      equ    0                                         ; Bit 8
ATD0DR4H_BIT9:      equ    1                                         ; Bit 9
ATD0DR4H_BIT10:     equ    2                                         ; Bit 10
ATD0DR4H_BIT11:     equ    3                                         ; Bit 11
ATD0DR4H_BIT12:     equ    4                                         ; Bit 12
ATD0DR4H_BIT13:     equ    5                                         ; Bit 13
ATD0DR4H_BIT14:     equ    6                                         ; Bit 14
ATD0DR4H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR4H_BIT8:     equ    %00000001
mATD0DR4H_BIT9:     equ    %00000010
mATD0DR4H_BIT10:    equ    %00000100
mATD0DR4H_BIT11:    equ    %00001000
mATD0DR4H_BIT12:    equ    %00010000
mATD0DR4H_BIT13:    equ    %00100000
mATD0DR4H_BIT14:    equ    %01000000
mATD0DR4H_BIT15:    equ    %10000000


;*** ATD0DR4L - ATD 0 Conversion Result Register 4 Low; 0x000002D9 ***
ATD0DR4L:           equ    $000002D9                                ;*** ATD0DR4L - ATD 0 Conversion Result Register 4 Low; 0x000002D9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR4L_BIT6:      equ    6                                         ; Bit 6
ATD0DR4L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR4L_BIT6:     equ    %01000000
mATD0DR4L_BIT7:     equ    %10000000


;*** ATD0DR5 - ATD 0 Conversion Result Register 5; 0x000002DA ***
ATD0DR5:            equ    $000002DA                                ;*** ATD0DR5 - ATD 0 Conversion Result Register 5; 0x000002DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR5_BIT6:       equ    6                                         ; Bit 6
ATD0DR5_BIT7:       equ    7                                         ; Bit 7
ATD0DR5_BIT8:       equ    8                                         ; Bit 8
ATD0DR5_BIT9:       equ    9                                         ; Bit 9
ATD0DR5_BIT10:      equ    10                                        ; Bit 10
ATD0DR5_BIT11:      equ    11                                        ; Bit 11
ATD0DR5_BIT12:      equ    12                                        ; Bit 12
ATD0DR5_BIT13:      equ    13                                        ; Bit 13
ATD0DR5_BIT14:      equ    14                                        ; Bit 14
ATD0DR5_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR5_BIT6:      equ    %01000000
mATD0DR5_BIT7:      equ    %10000000
mATD0DR5_BIT8:      equ    %100000000
mATD0DR5_BIT9:      equ    %1000000000
mATD0DR5_BIT10:     equ    %10000000000
mATD0DR5_BIT11:     equ    %100000000000
mATD0DR5_BIT12:     equ    %1000000000000
mATD0DR5_BIT13:     equ    %10000000000000
mATD0DR5_BIT14:     equ    %100000000000000
mATD0DR5_BIT15:     equ    %1000000000000000


;*** ATD0DR5H - ATD 0 Conversion Result Register 5 High; 0x000002DA ***
ATD0DR5H:           equ    $000002DA                                ;*** ATD0DR5H - ATD 0 Conversion Result Register 5 High; 0x000002DA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR5H_BIT8:      equ    0                                         ; Bit 8
ATD0DR5H_BIT9:      equ    1                                         ; Bit 9
ATD0DR5H_BIT10:     equ    2                                         ; Bit 10
ATD0DR5H_BIT11:     equ    3                                         ; Bit 11
ATD0DR5H_BIT12:     equ    4                                         ; Bit 12
ATD0DR5H_BIT13:     equ    5                                         ; Bit 13
ATD0DR5H_BIT14:     equ    6                                         ; Bit 14
ATD0DR5H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR5H_BIT8:     equ    %00000001
mATD0DR5H_BIT9:     equ    %00000010
mATD0DR5H_BIT10:    equ    %00000100
mATD0DR5H_BIT11:    equ    %00001000
mATD0DR5H_BIT12:    equ    %00010000
mATD0DR5H_BIT13:    equ    %00100000
mATD0DR5H_BIT14:    equ    %01000000
mATD0DR5H_BIT15:    equ    %10000000


;*** ATD0DR5L - ATD 0 Conversion Result Register 5 Low; 0x000002DB ***
ATD0DR5L:           equ    $000002DB                                ;*** ATD0DR5L - ATD 0 Conversion Result Register 5 Low; 0x000002DB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR5L_BIT6:      equ    6                                         ; Bit 6
ATD0DR5L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR5L_BIT6:     equ    %01000000
mATD0DR5L_BIT7:     equ    %10000000


;*** ATD0DR6 - ATD 0 Conversion Result Register 6; 0x000002DC ***
ATD0DR6:            equ    $000002DC                                ;*** ATD0DR6 - ATD 0 Conversion Result Register 6; 0x000002DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR6_BIT6:       equ    6                                         ; Bit 6
ATD0DR6_BIT7:       equ    7                                         ; Bit 7
ATD0DR6_BIT8:       equ    8                                         ; Bit 8
ATD0DR6_BIT9:       equ    9                                         ; Bit 9
ATD0DR6_BIT10:      equ    10                                        ; Bit 10
ATD0DR6_BIT11:      equ    11                                        ; Bit 11
ATD0DR6_BIT12:      equ    12                                        ; Bit 12
ATD0DR6_BIT13:      equ    13                                        ; Bit 13
ATD0DR6_BIT14:      equ    14                                        ; Bit 14
ATD0DR6_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR6_BIT6:      equ    %01000000
mATD0DR6_BIT7:      equ    %10000000
mATD0DR6_BIT8:      equ    %100000000
mATD0DR6_BIT9:      equ    %1000000000
mATD0DR6_BIT10:     equ    %10000000000
mATD0DR6_BIT11:     equ    %100000000000
mATD0DR6_BIT12:     equ    %1000000000000
mATD0DR6_BIT13:     equ    %10000000000000
mATD0DR6_BIT14:     equ    %100000000000000
mATD0DR6_BIT15:     equ    %1000000000000000


;*** ATD0DR6H - ATD 0 Conversion Result Register 6 High; 0x000002DC ***
ATD0DR6H:           equ    $000002DC                                ;*** ATD0DR6H - ATD 0 Conversion Result Register 6 High; 0x000002DC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR6H_BIT8:      equ    0                                         ; Bit 8
ATD0DR6H_BIT9:      equ    1                                         ; Bit 9
ATD0DR6H_BIT10:     equ    2                                         ; Bit 10
ATD0DR6H_BIT11:     equ    3                                         ; Bit 11
ATD0DR6H_BIT12:     equ    4                                         ; Bit 12
ATD0DR6H_BIT13:     equ    5                                         ; Bit 13
ATD0DR6H_BIT14:     equ    6                                         ; Bit 14
ATD0DR6H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR6H_BIT8:     equ    %00000001
mATD0DR6H_BIT9:     equ    %00000010
mATD0DR6H_BIT10:    equ    %00000100
mATD0DR6H_BIT11:    equ    %00001000
mATD0DR6H_BIT12:    equ    %00010000
mATD0DR6H_BIT13:    equ    %00100000
mATD0DR6H_BIT14:    equ    %01000000
mATD0DR6H_BIT15:    equ    %10000000


;*** ATD0DR6L - ATD 0 Conversion Result Register 6 Low; 0x000002DD ***
ATD0DR6L:           equ    $000002DD                                ;*** ATD0DR6L - ATD 0 Conversion Result Register 6 Low; 0x000002DD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR6L_BIT6:      equ    6                                         ; Bit 6
ATD0DR6L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR6L_BIT6:     equ    %01000000
mATD0DR6L_BIT7:     equ    %10000000


;*** ATD0DR7 - ATD 0 Conversion Result Register 7; 0x000002DE ***
ATD0DR7:            equ    $000002DE                                ;*** ATD0DR7 - ATD 0 Conversion Result Register 7; 0x000002DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR7_BIT6:       equ    6                                         ; Bit 6
ATD0DR7_BIT7:       equ    7                                         ; Bit 7
ATD0DR7_BIT8:       equ    8                                         ; Bit 8
ATD0DR7_BIT9:       equ    9                                         ; Bit 9
ATD0DR7_BIT10:      equ    10                                        ; Bit 10
ATD0DR7_BIT11:      equ    11                                        ; Bit 11
ATD0DR7_BIT12:      equ    12                                        ; Bit 12
ATD0DR7_BIT13:      equ    13                                        ; Bit 13
ATD0DR7_BIT14:      equ    14                                        ; Bit 14
ATD0DR7_BIT15:      equ    15                                        ; Bit 15
; bit position masks
mATD0DR7_BIT6:      equ    %01000000
mATD0DR7_BIT7:      equ    %10000000
mATD0DR7_BIT8:      equ    %100000000
mATD0DR7_BIT9:      equ    %1000000000
mATD0DR7_BIT10:     equ    %10000000000
mATD0DR7_BIT11:     equ    %100000000000
mATD0DR7_BIT12:     equ    %1000000000000
mATD0DR7_BIT13:     equ    %10000000000000
mATD0DR7_BIT14:     equ    %100000000000000
mATD0DR7_BIT15:     equ    %1000000000000000


;*** ATD0DR7H - ATD 0 Conversion Result Register 7 High; 0x000002DE ***
ATD0DR7H:           equ    $000002DE                                ;*** ATD0DR7H - ATD 0 Conversion Result Register 7 High; 0x000002DE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR7H_BIT8:      equ    0                                         ; Bit 8
ATD0DR7H_BIT9:      equ    1                                         ; Bit 9
ATD0DR7H_BIT10:     equ    2                                         ; Bit 10
ATD0DR7H_BIT11:     equ    3                                         ; Bit 11
ATD0DR7H_BIT12:     equ    4                                         ; Bit 12
ATD0DR7H_BIT13:     equ    5                                         ; Bit 13
ATD0DR7H_BIT14:     equ    6                                         ; Bit 14
ATD0DR7H_BIT15:     equ    7                                         ; Bit 15
; bit position masks
mATD0DR7H_BIT8:     equ    %00000001
mATD0DR7H_BIT9:     equ    %00000010
mATD0DR7H_BIT10:    equ    %00000100
mATD0DR7H_BIT11:    equ    %00001000
mATD0DR7H_BIT12:    equ    %00010000
mATD0DR7H_BIT13:    equ    %00100000
mATD0DR7H_BIT14:    equ    %01000000
mATD0DR7H_BIT15:    equ    %10000000


;*** ATD0DR7L - ATD 0 Conversion Result Register 7 Low; 0x000002DF ***
ATD0DR7L:           equ    $000002DF                                ;*** ATD0DR7L - ATD 0 Conversion Result Register 7 Low; 0x000002DF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ATD0DR7L_BIT6:      equ    6                                         ; Bit 6
ATD0DR7L_BIT7:      equ    7                                         ; Bit 7
; bit position masks
mATD0DR7L_BIT6:     equ    %01000000
mATD0DR7L_BIT7:     equ    %10000000


;*** VREGCTRL - VREG_3V3 - Control Register; 0x000002F1 ***
VREGCTRL:           equ    $000002F1                                ;*** VREGCTRL - VREG_3V3 - Control Register; 0x000002F1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGCTRL_LVIF:      equ    0                                         ; Low Voltage Interrupt Flag
VREGCTRL_LVIE:      equ    1                                         ; Low Voltage Interrupt Enable Bit
VREGCTRL_LVDS:      equ    2                                         ; Low Voltage Detect Status Bit
; bit position masks
mVREGCTRL_LVIF:     equ    %00000001
mVREGCTRL_LVIE:     equ    %00000010
mVREGCTRL_LVDS:     equ    %00000100


;*** VREGAPICL - VREG_3V3 - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
VREGAPICL:          equ    $000002F2                                ;*** VREGAPICL - VREG_3V3 - Autonomous Periodical Interrupt Control Register; 0x000002F2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPICL_APIF:     equ    0                                         ; Autonomous Periodical Interrupt Flag
VREGAPICL_APIE:     equ    1                                         ; Autonomous Periodical Interrupt Enable Bit
VREGAPICL_APIFE:    equ    2                                         ; Autonomous Periodical Interrupt Feature Enable Bit
VREGAPICL_APICLK:   equ    7                                         ; Autonomous Periodical Interrupt Clock Select Bit
; bit position masks
mVREGAPICL_APIF:    equ    %00000001
mVREGAPICL_APIE:    equ    %00000010
mVREGAPICL_APIFE:   equ    %00000100
mVREGAPICL_APICLK:  equ    %10000000


;*** VREGAPITR - VREG_3V3 - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***
VREGAPITR:          equ    $000002F3                                ;*** VREGAPITR - VREG_3V3 - Autonomous Periodical Interrupt Trimming Register; 0x000002F3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPITR_APITR0:   equ    2                                         ; Autonomous Periodical Interrupt Period Trimming Bit 0
VREGAPITR_APITR1:   equ    3                                         ; Autonomous Periodical Interrupt Period Trimming Bit 1
VREGAPITR_APITR2:   equ    4                                         ; Autonomous Periodical Interrupt Period Trimming Bit 2
VREGAPITR_APITR3:   equ    5                                         ; Autonomous Periodical Interrupt Period Trimming Bit 3
VREGAPITR_APITR4:   equ    6                                         ; Autonomous Periodical Interrupt Period Trimming Bit 4
VREGAPITR_APITR5:   equ    7                                         ; Autonomous Periodical Interrupt Period Trimming Bit 5
; bit position masks
mVREGAPITR_APITR0:  equ    %00000100
mVREGAPITR_APITR1:  equ    %00001000
mVREGAPITR_APITR2:  equ    %00010000
mVREGAPITR_APITR3:  equ    %00100000
mVREGAPITR_APITR4:  equ    %01000000
mVREGAPITR_APITR5:  equ    %10000000


;*** VREGAPIR - VREG_3V3 - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
VREGAPIR:           equ    $000002F4                                ;*** VREGAPIR - VREG_3V3 - Autonomous Periodical Interrupt Rate Register; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIR_APIR0:     equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
VREGAPIR_APIR1:     equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
VREGAPIR_APIR2:     equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
VREGAPIR_APIR3:     equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
VREGAPIR_APIR4:     equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
VREGAPIR_APIR5:     equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
VREGAPIR_APIR6:     equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
VREGAPIR_APIR7:     equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
VREGAPIR_APIR8:     equ    8                                         ; Autonomous Periodical Interrupt Rate Bit 8
VREGAPIR_APIR9:     equ    9                                         ; Autonomous Periodical Interrupt Rate Bit 9
VREGAPIR_APIR10:    equ    10                                        ; Autonomous Periodical Interrupt Rate Bit 10
VREGAPIR_APIR11:    equ    11                                        ; Autonomous Periodical Interrupt Rate Bit 11
; bit position masks
mVREGAPIR_APIR0:    equ    %00000001
mVREGAPIR_APIR1:    equ    %00000010
mVREGAPIR_APIR2:    equ    %00000100
mVREGAPIR_APIR3:    equ    %00001000
mVREGAPIR_APIR4:    equ    %00010000
mVREGAPIR_APIR5:    equ    %00100000
mVREGAPIR_APIR6:    equ    %01000000
mVREGAPIR_APIR7:    equ    %10000000
mVREGAPIR_APIR8:    equ    %100000000
mVREGAPIR_APIR9:    equ    %1000000000
mVREGAPIR_APIR10:   equ    %10000000000
mVREGAPIR_APIR11:   equ    %100000000000


;*** VREGAPIRH - VREG_3V3 - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
VREGAPIRH:          equ    $000002F4                                ;*** VREGAPIRH - VREG_3V3 - Autonomous Periodical Interrupt Rate Register High; 0x000002F4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIRH_APIR8:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 8
VREGAPIRH_APIR9:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 9
VREGAPIRH_APIR10:   equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 10
VREGAPIRH_APIR11:   equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 11
; bit position masks
mVREGAPIRH_APIR8:   equ    %00000001
mVREGAPIRH_APIR9:   equ    %00000010
mVREGAPIRH_APIR10:  equ    %00000100
mVREGAPIRH_APIR11:  equ    %00001000


;*** VREGAPIRL - VREG_3V3 - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
VREGAPIRL:          equ    $000002F5                                ;*** VREGAPIRL - VREG_3V3 - Autonomous Periodical Interrupt Rate Register Low; 0x000002F5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
VREGAPIRL_APIR0:    equ    0                                         ; Autonomous Periodical Interrupt Rate Bit 0
VREGAPIRL_APIR1:    equ    1                                         ; Autonomous Periodical Interrupt Rate Bit 1
VREGAPIRL_APIR2:    equ    2                                         ; Autonomous Periodical Interrupt Rate Bit 2
VREGAPIRL_APIR3:    equ    3                                         ; Autonomous Periodical Interrupt Rate Bit 3
VREGAPIRL_APIR4:    equ    4                                         ; Autonomous Periodical Interrupt Rate Bit 4
VREGAPIRL_APIR5:    equ    5                                         ; Autonomous Periodical Interrupt Rate Bit 5
VREGAPIRL_APIR6:    equ    6                                         ; Autonomous Periodical Interrupt Rate Bit 6
VREGAPIRL_APIR7:    equ    7                                         ; Autonomous Periodical Interrupt Rate Bit 7
; bit position masks
mVREGAPIRL_APIR0:   equ    %00000001
mVREGAPIRL_APIR1:   equ    %00000010
mVREGAPIRL_APIR2:   equ    %00000100
mVREGAPIRL_APIR3:   equ    %00001000
mVREGAPIRL_APIR4:   equ    %00010000
mVREGAPIRL_APIR5:   equ    %00100000
mVREGAPIRL_APIR6:   equ    %01000000
mVREGAPIRL_APIR7:   equ    %10000000


;*** PWME - PWM Enable Register; 0x00000300 ***
PWME:               equ    $00000300                                ;*** PWME - PWM Enable Register; 0x00000300 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWME_PWME0:         equ    0                                         ; Pulse Width Channel 0 Enable
PWME_PWME1:         equ    1                                         ; Pulse Width Channel 1 Enable
PWME_PWME2:         equ    2                                         ; Pulse Width Channel 2 Enable
PWME_PWME3:         equ    3                                         ; Pulse Width Channel 3 Enable
PWME_PWME4:         equ    4                                         ; Pulse Width Channel 4 Enable
PWME_PWME5:         equ    5                                         ; Pulse Width Channel 5 Enable
PWME_PWME6:         equ    6                                         ; Pulse Width Channel 6 Enable
PWME_PWME7:         equ    7                                         ; Pulse Width Channel 7 Enable
; bit position masks
mPWME_PWME0:        equ    %00000001
mPWME_PWME1:        equ    %00000010
mPWME_PWME2:        equ    %00000100
mPWME_PWME3:        equ    %00001000
mPWME_PWME4:        equ    %00010000
mPWME_PWME5:        equ    %00100000
mPWME_PWME6:        equ    %01000000
mPWME_PWME7:        equ    %10000000


;*** PWMPOL - PWM Polarity Register; 0x00000301 ***
PWMPOL:             equ    $00000301                                ;*** PWMPOL - PWM Polarity Register; 0x00000301 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPOL_PPOL0:       equ    0                                         ; Pulse Width Channel 0 Polarity
PWMPOL_PPOL1:       equ    1                                         ; Pulse Width Channel 1 Polarity
PWMPOL_PPOL2:       equ    2                                         ; Pulse Width Channel 2 Polarity
PWMPOL_PPOL3:       equ    3                                         ; Pulse Width Channel 3 Polarity
PWMPOL_PPOL4:       equ    4                                         ; Pulse Width Channel 4 Polarity
PWMPOL_PPOL5:       equ    5                                         ; Pulse Width Channel 5 Polarity
PWMPOL_PPOL6:       equ    6                                         ; Pulse Width Channel 6 Polarity
PWMPOL_PPOL7:       equ    7                                         ; Pulse Width Channel 7 Polarity
; bit position masks
mPWMPOL_PPOL0:      equ    %00000001
mPWMPOL_PPOL1:      equ    %00000010
mPWMPOL_PPOL2:      equ    %00000100
mPWMPOL_PPOL3:      equ    %00001000
mPWMPOL_PPOL4:      equ    %00010000
mPWMPOL_PPOL5:      equ    %00100000
mPWMPOL_PPOL6:      equ    %01000000
mPWMPOL_PPOL7:      equ    %10000000


;*** PWMCLK - PWM Clock Select Register; 0x00000302 ***
PWMCLK:             equ    $00000302                                ;*** PWMCLK - PWM Clock Select Register; 0x00000302 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCLK_PCLK0:       equ    0                                         ; Pulse Width Channel 0 Clock Select
PWMCLK_PCLK1:       equ    1                                         ; Pulse Width Channel 1 Clock Select
PWMCLK_PCLK2:       equ    2                                         ; Pulse Width Channel 2 Clock Select
PWMCLK_PCLK3:       equ    3                                         ; Pulse Width Channel 3 Clock Select
PWMCLK_PCLK4:       equ    4                                         ; Pulse Width Channel 4 Clock Select
PWMCLK_PCLK5:       equ    5                                         ; Pulse Width Channel 5 Clock Select
PWMCLK_PCLK6:       equ    6                                         ; Pulse Width Channel 6 Clock Select
PWMCLK_PCLK7:       equ    7                                         ; Pulse Width Channel 7 Clock Select
; bit position masks
mPWMCLK_PCLK0:      equ    %00000001
mPWMCLK_PCLK1:      equ    %00000010
mPWMCLK_PCLK2:      equ    %00000100
mPWMCLK_PCLK3:      equ    %00001000
mPWMCLK_PCLK4:      equ    %00010000
mPWMCLK_PCLK5:      equ    %00100000
mPWMCLK_PCLK6:      equ    %01000000
mPWMCLK_PCLK7:      equ    %10000000


;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x00000303 ***
PWMPRCLK:           equ    $00000303                                ;*** PWMPRCLK - PWM Prescale Clock Select Register; 0x00000303 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMPRCLK_PCKA0:     equ    0                                         ; Prescaler Select for Clock A 0
PWMPRCLK_PCKA1:     equ    1                                         ; Prescaler Select for Clock A 1
PWMPRCLK_PCKA2:     equ    2                                         ; Prescaler Select for Clock A 2
PWMPRCLK_PCKB0:     equ    4                                         ; Prescaler Select for Clock B 0
PWMPRCLK_PCKB1:     equ    5                                         ; Prescaler Select for Clock B 1
PWMPRCLK_PCKB2:     equ    6                                         ; Prescaler Select for Clock B 2
; bit position masks
mPWMPRCLK_PCKA0:    equ    %00000001
mPWMPRCLK_PCKA1:    equ    %00000010
mPWMPRCLK_PCKA2:    equ    %00000100
mPWMPRCLK_PCKB0:    equ    %00010000
mPWMPRCLK_PCKB1:    equ    %00100000
mPWMPRCLK_PCKB2:    equ    %01000000


;*** PWMCAE - PWM Center Align Enable Register; 0x00000304 ***
PWMCAE:             equ    $00000304                                ;*** PWMCAE - PWM Center Align Enable Register; 0x00000304 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCAE_CAE0:        equ    0                                         ; Center Aligned Output Mode on channel 0
PWMCAE_CAE1:        equ    1                                         ; Center Aligned Output Mode on channel 1
PWMCAE_CAE2:        equ    2                                         ; Center Aligned Output Mode on channel 2
PWMCAE_CAE3:        equ    3                                         ; Center Aligned Output Mode on channel 3
PWMCAE_CAE4:        equ    4                                         ; Center Aligned Output Mode on channel 4
PWMCAE_CAE5:        equ    5                                         ; Center Aligned Output Mode on channel 5
PWMCAE_CAE6:        equ    6                                         ; Center Aligned Output Mode on channel 6
PWMCAE_CAE7:        equ    7                                         ; Center Aligned Output Mode on channel 7
; bit position masks
mPWMCAE_CAE0:       equ    %00000001
mPWMCAE_CAE1:       equ    %00000010
mPWMCAE_CAE2:       equ    %00000100
mPWMCAE_CAE3:       equ    %00001000
mPWMCAE_CAE4:       equ    %00010000
mPWMCAE_CAE5:       equ    %00100000
mPWMCAE_CAE6:       equ    %01000000
mPWMCAE_CAE7:       equ    %10000000


;*** PWMCTL - PWM Control Register; 0x00000305 ***
PWMCTL:             equ    $00000305                                ;*** PWMCTL - PWM Control Register; 0x00000305 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMCTL_PFRZ:        equ    2                                         ; PWM Counters Stop in Freeze Mode
PWMCTL_PSWAI:       equ    3                                         ; PWM Stops in Wait Mode
PWMCTL_CON01:       equ    4                                         ; Concatenate channels 0 and 1
PWMCTL_CON23:       equ    5                                         ; Concatenate channels 2 and 3
PWMCTL_CON45:       equ    6                                         ; Concatenate channels 4 and 5
PWMCTL_CON67:       equ    7                                         ; Concatenate channels 6 and 7
; bit position masks
mPWMCTL_PFRZ:       equ    %00000100
mPWMCTL_PSWAI:      equ    %00001000
mPWMCTL_CON01:      equ    %00010000
mPWMCTL_CON23:      equ    %00100000
mPWMCTL_CON45:      equ    %01000000
mPWMCTL_CON67:      equ    %10000000


;*** PWMSCLA - PWM Scale A Register; 0x00000308 ***
PWMSCLA:            equ    $00000308                                ;*** PWMSCLA - PWM Scale A Register; 0x00000308 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLA_BIT0:       equ    0                                         ; PWM Scale A Bit 0
PWMSCLA_BIT1:       equ    1                                         ; PWM Scale A Bit 1
PWMSCLA_BIT2:       equ    2                                         ; PWM Scale A Bit 2
PWMSCLA_BIT3:       equ    3                                         ; PWM Scale A Bit 3
PWMSCLA_BIT4:       equ    4                                         ; PWM Scale A Bit 4
PWMSCLA_BIT5:       equ    5                                         ; PWM Scale A Bit 5
PWMSCLA_BIT6:       equ    6                                         ; PWM Scale A Bit 6
PWMSCLA_BIT7:       equ    7                                         ; PWM Scale A Bit 7
; bit position masks
mPWMSCLA_BIT0:      equ    %00000001
mPWMSCLA_BIT1:      equ    %00000010
mPWMSCLA_BIT2:      equ    %00000100
mPWMSCLA_BIT3:      equ    %00001000
mPWMSCLA_BIT4:      equ    %00010000
mPWMSCLA_BIT5:      equ    %00100000
mPWMSCLA_BIT6:      equ    %01000000
mPWMSCLA_BIT7:      equ    %10000000


;*** PWMSCLB - PWM Scale B Register; 0x00000309 ***
PWMSCLB:            equ    $00000309                                ;*** PWMSCLB - PWM Scale B Register; 0x00000309 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSCLB_BIT0:       equ    0                                         ; PWM Scale B Bit 0
PWMSCLB_BIT1:       equ    1                                         ; PWM Scale B Bit 1
PWMSCLB_BIT2:       equ    2                                         ; PWM Scale B Bit 2
PWMSCLB_BIT3:       equ    3                                         ; PWM Scale B Bit 3
PWMSCLB_BIT4:       equ    4                                         ; PWM Scale B Bit 4
PWMSCLB_BIT5:       equ    5                                         ; PWM Scale B Bit 5
PWMSCLB_BIT6:       equ    6                                         ; PWM Scale B Bit 6
PWMSCLB_BIT7:       equ    7                                         ; PWM Scale B Bit 7
; bit position masks
mPWMSCLB_BIT0:      equ    %00000001
mPWMSCLB_BIT1:      equ    %00000010
mPWMSCLB_BIT2:      equ    %00000100
mPWMSCLB_BIT3:      equ    %00001000
mPWMSCLB_BIT4:      equ    %00010000
mPWMSCLB_BIT5:      equ    %00100000
mPWMSCLB_BIT6:      equ    %01000000
mPWMSCLB_BIT7:      equ    %10000000


;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x0000030C ***
PWMCNT01:           equ    $0000030C                                ;*** PWMCNT01 - PWM Channel Counter 01 Register; 0x0000030C ***


;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x0000030C ***
PWMCNT0:            equ    $0000030C                                ;*** PWMCNT0 - PWM Channel Counter 0 Register; 0x0000030C ***


;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x0000030D ***
PWMCNT1:            equ    $0000030D                                ;*** PWMCNT1 - PWM Channel Counter 1 Register; 0x0000030D ***


;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x0000030E ***
PWMCNT23:           equ    $0000030E                                ;*** PWMCNT23 - PWM Channel Counter 23 Register; 0x0000030E ***


;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x0000030E ***
PWMCNT2:            equ    $0000030E                                ;*** PWMCNT2 - PWM Channel Counter 2 Register; 0x0000030E ***


;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x0000030F ***
PWMCNT3:            equ    $0000030F                                ;*** PWMCNT3 - PWM Channel Counter 3 Register; 0x0000030F ***


;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x00000310 ***
PWMCNT45:           equ    $00000310                                ;*** PWMCNT45 - PWM Channel Counter 45 Register; 0x00000310 ***


;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x00000310 ***
PWMCNT4:            equ    $00000310                                ;*** PWMCNT4 - PWM Channel Counter 4 Register; 0x00000310 ***


;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x00000311 ***
PWMCNT5:            equ    $00000311                                ;*** PWMCNT5 - PWM Channel Counter 5 Register; 0x00000311 ***


;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x00000312 ***
PWMCNT67:           equ    $00000312                                ;*** PWMCNT67 - PWM Channel Counter 67 Register; 0x00000312 ***


;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x00000312 ***
PWMCNT6:            equ    $00000312                                ;*** PWMCNT6 - PWM Channel Counter 6 Register; 0x00000312 ***


;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x00000313 ***
PWMCNT7:            equ    $00000313                                ;*** PWMCNT7 - PWM Channel Counter 7 Register; 0x00000313 ***


;*** PWMPER01 - PWM Channel Period 01 Register; 0x00000314 ***
PWMPER01:           equ    $00000314                                ;*** PWMPER01 - PWM Channel Period 01 Register; 0x00000314 ***


;*** PWMPER0 - PWM Channel Period 0 Register; 0x00000314 ***
PWMPER0:            equ    $00000314                                ;*** PWMPER0 - PWM Channel Period 0 Register; 0x00000314 ***


;*** PWMPER1 - PWM Channel Period 1 Register; 0x00000315 ***
PWMPER1:            equ    $00000315                                ;*** PWMPER1 - PWM Channel Period 1 Register; 0x00000315 ***


;*** PWMPER23 - PWM Channel Period 23 Register; 0x00000316 ***
PWMPER23:           equ    $00000316                                ;*** PWMPER23 - PWM Channel Period 23 Register; 0x00000316 ***


;*** PWMPER2 - PWM Channel Period 2 Register; 0x00000316 ***
PWMPER2:            equ    $00000316                                ;*** PWMPER2 - PWM Channel Period 2 Register; 0x00000316 ***


;*** PWMPER3 - PWM Channel Period 3 Register; 0x00000317 ***
PWMPER3:            equ    $00000317                                ;*** PWMPER3 - PWM Channel Period 3 Register; 0x00000317 ***


;*** PWMPER45 - PWM Channel Period 45 Register; 0x00000318 ***
PWMPER45:           equ    $00000318                                ;*** PWMPER45 - PWM Channel Period 45 Register; 0x00000318 ***


;*** PWMPER4 - PWM Channel Period 4 Register; 0x00000318 ***
PWMPER4:            equ    $00000318                                ;*** PWMPER4 - PWM Channel Period 4 Register; 0x00000318 ***


;*** PWMPER5 - PWM Channel Period 5 Register; 0x00000319 ***
PWMPER5:            equ    $00000319                                ;*** PWMPER5 - PWM Channel Period 5 Register; 0x00000319 ***


;*** PWMPER67 - PWM Channel Period 67 Register; 0x0000031A ***
PWMPER67:           equ    $0000031A                                ;*** PWMPER67 - PWM Channel Period 67 Register; 0x0000031A ***


;*** PWMPER6 - PWM Channel Period 6 Register; 0x0000031A ***
PWMPER6:            equ    $0000031A                                ;*** PWMPER6 - PWM Channel Period 6 Register; 0x0000031A ***


;*** PWMPER7 - PWM Channel Period 7 Register; 0x0000031B ***
PWMPER7:            equ    $0000031B                                ;*** PWMPER7 - PWM Channel Period 7 Register; 0x0000031B ***


;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x0000031C ***
PWMDTY01:           equ    $0000031C                                ;*** PWMDTY01 - PWM Channel Duty 01 Register; 0x0000031C ***


;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x0000031C ***
PWMDTY0:            equ    $0000031C                                ;*** PWMDTY0 - PWM Channel Duty 0 Register; 0x0000031C ***


;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x0000031D ***
PWMDTY1:            equ    $0000031D                                ;*** PWMDTY1 - PWM Channel Duty 1 Register; 0x0000031D ***


;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x0000031E ***
PWMDTY23:           equ    $0000031E                                ;*** PWMDTY23 - PWM Channel Duty 23 Register; 0x0000031E ***


;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x0000031E ***
PWMDTY2:            equ    $0000031E                                ;*** PWMDTY2 - PWM Channel Duty 2 Register; 0x0000031E ***


;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x0000031F ***
PWMDTY3:            equ    $0000031F                                ;*** PWMDTY3 - PWM Channel Duty 3 Register; 0x0000031F ***


;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x00000320 ***
PWMDTY45:           equ    $00000320                                ;*** PWMDTY45 - PWM Channel Duty 45 Register; 0x00000320 ***


;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x00000320 ***
PWMDTY4:            equ    $00000320                                ;*** PWMDTY4 - PWM Channel Duty 4 Register; 0x00000320 ***


;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x00000321 ***
PWMDTY5:            equ    $00000321                                ;*** PWMDTY5 - PWM Channel Duty 5 Register; 0x00000321 ***


;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x00000322 ***
PWMDTY67:           equ    $00000322                                ;*** PWMDTY67 - PWM Channel Duty 67 Register; 0x00000322 ***


;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x00000322 ***
PWMDTY6:            equ    $00000322                                ;*** PWMDTY6 - PWM Channel Duty 6 Register; 0x00000322 ***


;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x00000323 ***
PWMDTY7:            equ    $00000323                                ;*** PWMDTY7 - PWM Channel Duty 7 Register; 0x00000323 ***


;*** PWMSDN - PWM Shutdown Register; 0x00000324 ***
PWMSDN:             equ    $00000324                                ;*** PWMSDN - PWM Shutdown Register; 0x00000324 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PWMSDN_PWM7ENA:     equ    0                                         ; PWM emergency shutdown Enable
PWMSDN_PWM7INL:     equ    1                                         ; PWM shutdown active input level for ch. 7
PWMSDN_PWM7IN:      equ    2                                         ; PWM channel 7 input status
PWMSDN_PWMLVL:      equ    4                                         ; PWM shutdown output Level
PWMSDN_PWMRSTRT:    equ    5                                         ; PWM Restart
PWMSDN_PWMIE:       equ    6                                         ; PWM Interrupt Enable
PWMSDN_PWMIF:       equ    7                                         ; PWM Interrupt Flag
; bit position masks
mPWMSDN_PWM7ENA:    equ    %00000001
mPWMSDN_PWM7INL:    equ    %00000010
mPWMSDN_PWM7IN:     equ    %00000100
mPWMSDN_PWMLVL:     equ    %00010000
mPWMSDN_PWMRSTRT:   equ    %00100000
mPWMSDN_PWMIE:      equ    %01000000
mPWMSDN_PWMIF:      equ    %10000000


;*** PITCFLMT - PIT Control and Force Load Micro Timer Register; 0x00000340 ***
PITCFLMT:           equ    $00000340                                ;*** PITCFLMT - PIT Control and Force Load Micro Timer Register; 0x00000340 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITCFLMT_PFLMT0:    equ    0                                         ; PIT Force Load Bits for Micro Timer 0
PITCFLMT_PFLMT1:    equ    1                                         ; PIT Force Load Bits for Micro Timer 1
PITCFLMT_PITFRZ:    equ    5                                         ; PIT Counter Freeze while in Freeze Mode Bit
PITCFLMT_PITSWAI:   equ    6                                         ; PIT Stop in Wait Mode Bit
PITCFLMT_PITE:      equ    7                                         ; PIT Module Enable Bit
; bit position masks
mPITCFLMT_PFLMT0:   equ    %00000001
mPITCFLMT_PFLMT1:   equ    %00000010
mPITCFLMT_PITFRZ:   equ    %00100000
mPITCFLMT_PITSWAI:  equ    %01000000
mPITCFLMT_PITE:     equ    %10000000


;*** PITFLT - PIT Force Load Timer Register; 0x00000341 ***
PITFLT:             equ    $00000341                                ;*** PITFLT - PIT Force Load Timer Register; 0x00000341 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITFLT_PFLT0:       equ    0                                         ; PIT Force Load Bits for Timer 0
PITFLT_PFLT1:       equ    1                                         ; PIT Force Load Bits for Timer 1
PITFLT_PFLT2:       equ    2                                         ; PIT Force Load Bits for Timer 2
PITFLT_PFLT3:       equ    3                                         ; PIT Force Load Bits for Timer 3
; bit position masks
mPITFLT_PFLT0:      equ    %00000001
mPITFLT_PFLT1:      equ    %00000010
mPITFLT_PFLT2:      equ    %00000100
mPITFLT_PFLT3:      equ    %00001000


;*** PITCE - PIT Channel Enable Register; 0x00000342 ***
PITCE:              equ    $00000342                                ;*** PITCE - PIT Channel Enable Register; 0x00000342 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITCE_PCE0:         equ    0                                         ; PIT Enable Bits for Timer Channel 0
PITCE_PCE1:         equ    1                                         ; PIT Enable Bits for Timer Channel 1
PITCE_PCE2:         equ    2                                         ; PIT Enable Bits for Timer Channel 2
PITCE_PCE3:         equ    3                                         ; PIT Enable Bits for Timer Channel 3
; bit position masks
mPITCE_PCE0:        equ    %00000001
mPITCE_PCE1:        equ    %00000010
mPITCE_PCE2:        equ    %00000100
mPITCE_PCE3:        equ    %00001000


;*** PITMUX - PIT Multiplex Register; 0x00000343 ***
PITMUX:             equ    $00000343                                ;*** PITMUX - PIT Multiplex Register; 0x00000343 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMUX_PMUX0:       equ    0                                         ; PIT Multiplex Bits for Timer Channel 0
PITMUX_PMUX1:       equ    1                                         ; PIT Multiplex Bits for Timer Channel 1
PITMUX_PMUX2:       equ    2                                         ; PIT Multiplex Bits for Timer Channel 2
PITMUX_PMUX3:       equ    3                                         ; PIT Multiplex Bits for Timer Channel 3
; bit position masks
mPITMUX_PMUX0:      equ    %00000001
mPITMUX_PMUX1:      equ    %00000010
mPITMUX_PMUX2:      equ    %00000100
mPITMUX_PMUX3:      equ    %00001000


;*** PITINTE - PIT Interrupt Enable Register; 0x00000344 ***
PITINTE:            equ    $00000344                                ;*** PITINTE - PIT Interrupt Enable Register; 0x00000344 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITINTE_PINTE0:     equ    0                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 0
PITINTE_PINTE1:     equ    1                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 1
PITINTE_PINTE2:     equ    2                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 2
PITINTE_PINTE3:     equ    3                                         ; PIT Time-out Interrupt Enable Bits for Timer Channel 3
; bit position masks
mPITINTE_PINTE0:    equ    %00000001
mPITINTE_PINTE1:    equ    %00000010
mPITINTE_PINTE2:    equ    %00000100
mPITINTE_PINTE3:    equ    %00001000


;*** PITTF - PIT Time-out Flag Register; 0x00000345 ***
PITTF:              equ    $00000345                                ;*** PITTF - PIT Time-out Flag Register; 0x00000345 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITTF_PTF0:         equ    0                                         ; PIT Time-out Flag Bits for Timer Channel 0
PITTF_PTF1:         equ    1                                         ; PIT Time-out Flag Bits for Timer Channel 1
PITTF_PTF2:         equ    2                                         ; PIT Time-out Flag Bits for Timer Channel 2
PITTF_PTF3:         equ    3                                         ; PIT Time-out Flag Bits for Timer Channel 3
; bit position masks
mPITTF_PTF0:        equ    %00000001
mPITTF_PTF1:        equ    %00000010
mPITTF_PTF2:        equ    %00000100
mPITTF_PTF3:        equ    %00001000


;*** PITMTLD0 - PIT Micro Timer Load Register 0; 0x00000346 ***
PITMTLD0:           equ    $00000346                                ;*** PITMTLD0 - PIT Micro Timer Load Register 0; 0x00000346 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMTLD0_PMTLD0:    equ    0                                         ; PIT Micro Timer Load Bit 0
PITMTLD0_PMTLD1:    equ    1                                         ; PIT Micro Timer Load Bit 1
PITMTLD0_PMTLD2:    equ    2                                         ; PIT Micro Timer Load Bit 2
PITMTLD0_PMTLD3:    equ    3                                         ; PIT Micro Timer Load Bit 3
PITMTLD0_PMTLD4:    equ    4                                         ; PIT Micro Timer Load Bit 4
PITMTLD0_PMTLD5:    equ    5                                         ; PIT Micro Timer Load Bit 5
PITMTLD0_PMTLD6:    equ    6                                         ; PIT Micro Timer Load Bit 6
PITMTLD0_PMTLD7:    equ    7                                         ; PIT Micro Timer Load Bit 7
; bit position masks
mPITMTLD0_PMTLD0:   equ    %00000001
mPITMTLD0_PMTLD1:   equ    %00000010
mPITMTLD0_PMTLD2:   equ    %00000100
mPITMTLD0_PMTLD3:   equ    %00001000
mPITMTLD0_PMTLD4:   equ    %00010000
mPITMTLD0_PMTLD5:   equ    %00100000
mPITMTLD0_PMTLD6:   equ    %01000000
mPITMTLD0_PMTLD7:   equ    %10000000


;*** PITMTLD1 - PIT Micro Timer Load Register 1; 0x00000347 ***
PITMTLD1:           equ    $00000347                                ;*** PITMTLD1 - PIT Micro Timer Load Register 1; 0x00000347 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PITMTLD1_PMTLD0:    equ    0                                         ; PIT Micro Timer Load Bit 0
PITMTLD1_PMTLD1:    equ    1                                         ; PIT Micro Timer Load Bit 1
PITMTLD1_PMTLD2:    equ    2                                         ; PIT Micro Timer Load Bit 2
PITMTLD1_PMTLD3:    equ    3                                         ; PIT Micro Timer Load Bit 3
PITMTLD1_PMTLD4:    equ    4                                         ; PIT Micro Timer Load Bit 4
PITMTLD1_PMTLD5:    equ    5                                         ; PIT Micro Timer Load Bit 5
PITMTLD1_PMTLD6:    equ    6                                         ; PIT Micro Timer Load Bit 6
PITMTLD1_PMTLD7:    equ    7                                         ; PIT Micro Timer Load Bit 7
; bit position masks
mPITMTLD1_PMTLD0:   equ    %00000001
mPITMTLD1_PMTLD1:   equ    %00000010
mPITMTLD1_PMTLD2:   equ    %00000100
mPITMTLD1_PMTLD3:   equ    %00001000
mPITMTLD1_PMTLD4:   equ    %00010000
mPITMTLD1_PMTLD5:   equ    %00100000
mPITMTLD1_PMTLD6:   equ    %01000000
mPITMTLD1_PMTLD7:   equ    %10000000


;*** PITLD0 - PIT Load Register 0; 0x00000348 ***
PITLD0:             equ    $00000348                                ;*** PITLD0 - PIT Load Register 0; 0x00000348 ***


;*** PITCNT0 - PIT Count Register 0; 0x0000034A ***
PITCNT0:            equ    $0000034A                                ;*** PITCNT0 - PIT Count Register 0; 0x0000034A ***


;*** PITLD1 - PIT Load Register 1; 0x0000034C ***
PITLD1:             equ    $0000034C                                ;*** PITLD1 - PIT Load Register 1; 0x0000034C ***


;*** PITCNT1 - PIT Count Register 1; 0x0000034E ***
PITCNT1:            equ    $0000034E                                ;*** PITCNT1 - PIT Count Register 1; 0x0000034E ***


;*** PITLD2 - PIT Load Register 2; 0x00000350 ***
PITLD2:             equ    $00000350                                ;*** PITLD2 - PIT Load Register 2; 0x00000350 ***


;*** PITCNT2 - PIT Count Register 2; 0x00000352 ***
PITCNT2:            equ    $00000352                                ;*** PITCNT2 - PIT Count Register 2; 0x00000352 ***


;*** PITLD3 - PIT Load Register 3; 0x00000354 ***
PITLD3:             equ    $00000354                                ;*** PITLD3 - PIT Load Register 3; 0x00000354 ***


;*** PITCNT3 - PIT Count Register 3; 0x00000356 ***
PITCNT3:            equ    $00000356                                ;*** PITCNT3 - PIT Count Register 3; 0x00000356 ***


;*** XGMCTL - XGATE Module Control Register; 0x00000380 ***
XGMCTL:             equ    $00000380                                ;*** XGMCTL - XGATE Module Control Register; 0x00000380 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGMCTL_XGIE:        equ    0                                         ; XGATE Interrupt Enable
XGMCTL_XGSWEIF:     equ    1                                         ; XGATE Software Error Interrupt Flag
XGMCTL_XGFACT:      equ    3                                         ; Fake XGATE Activity
XGMCTL_XGSS:        equ    4                                         ; XGATE Single Step
XGMCTL_XGDBG:       equ    5                                         ; XGATE Debug Mode
XGMCTL_XGFRZ:       equ    6                                         ; Halt XGATE in Freeze Mode
XGMCTL_XGE:         equ    7                                         ; XGATE Module Enable
XGMCTL_XGIEM:       equ    8                                         ; XGIE Mask
XGMCTL_XGSWEIFM:    equ    9                                         ; XGSWEIF Mask
XGMCTL_XGFACTM:     equ    11                                        ; XGFACT Mask
XGMCTL_XGSSM:       equ    12                                        ; XGSS Mask
XGMCTL_XGDBGM:      equ    13                                        ; XGDBG Mask
XGMCTL_XGFRZM:      equ    14                                        ; XGFRZ Mask
XGMCTL_XGEM:        equ    15                                        ; XGE Mask
; bit position masks
mXGMCTL_XGIE:       equ    %00000001
mXGMCTL_XGSWEIF:    equ    %00000010
mXGMCTL_XGFACT:     equ    %00001000
mXGMCTL_XGSS:       equ    %00010000
mXGMCTL_XGDBG:      equ    %00100000
mXGMCTL_XGFRZ:      equ    %01000000
mXGMCTL_XGE:        equ    %10000000
mXGMCTL_XGIEM:      equ    %100000000
mXGMCTL_XGSWEIFM:   equ    %1000000000
mXGMCTL_XGFACTM:    equ    %100000000000
mXGMCTL_XGSSM:      equ    %1000000000000
mXGMCTL_XGDBGM:     equ    %10000000000000
mXGMCTL_XGFRZM:     equ    %100000000000000
mXGMCTL_XGEM:       equ    %1000000000000000


;*** XGCHID - XGATE Channel ID Register; 0x00000382 ***
XGCHID:             equ    $00000382                                ;*** XGCHID - XGATE Channel ID Register; 0x00000382 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGCHID_XGCHID:      equ    0                                         ; Request Identifier
; bit position masks
mXGCHID_XGCHID:     equ    %01111111


;*** XGVBR - XGATE Vector Base Address Register; 0x00000386 ***
XGVBR:              equ    $00000386                                ;*** XGVBR - XGATE Vector Base Address Register; 0x00000386 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGVBR_XGVBR:        equ    1                                         ; Vector Base Address
; bit position masks
mXGVBR_XGVBR:       equ    %1111111111111110


;*** XGIF_7F_70 - XGATE Channel Interrupt Flag Vector 0; 0x00000388 ***
XGIF_7F_70:         equ    $00000388                                ;*** XGIF_7F_70 - XGATE Channel Interrupt Flag Vector 0; 0x00000388 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_7F_70_XGIF_70: equ    0                                         ; Channel Interrupt Flag 70
XGIF_7F_70_XGIF_71: equ    1                                         ; Channel Interrupt Flag 71
XGIF_7F_70_XGIF_72: equ    2                                         ; Channel Interrupt Flag 72
XGIF_7F_70_XGIF_73: equ    3                                         ; Channel Interrupt Flag 73
XGIF_7F_70_XGIF_74: equ    4                                         ; Channel Interrupt Flag 74
XGIF_7F_70_XGIF_75: equ    5                                         ; Channel Interrupt Flag 75
XGIF_7F_70_XGIF_76: equ    6                                         ; Channel Interrupt Flag 76
XGIF_7F_70_XGIF_77: equ    7                                         ; Channel Interrupt Flag 77
XGIF_7F_70_XGIF_78: equ    8                                         ; Channel Interrupt Flag 78
; bit position masks
mXGIF_7F_70_XGIF_70: equ    %00000001
mXGIF_7F_70_XGIF_71: equ    %00000010
mXGIF_7F_70_XGIF_72: equ    %00000100
mXGIF_7F_70_XGIF_73: equ    %00001000
mXGIF_7F_70_XGIF_74: equ    %00010000
mXGIF_7F_70_XGIF_75: equ    %00100000
mXGIF_7F_70_XGIF_76: equ    %01000000
mXGIF_7F_70_XGIF_77: equ    %10000000
mXGIF_7F_70_XGIF_78: equ    %100000000


;*** XGIF_6F_60 - XGATE Channel Interrupt Flag Vector 1; 0x0000038A ***
XGIF_6F_60:         equ    $0000038A                                ;*** XGIF_6F_60 - XGATE Channel Interrupt Flag Vector 1; 0x0000038A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_6F_60_XGIF_60: equ    0                                         ; Channel Interrupt Flag 60
XGIF_6F_60_XGIF_61: equ    1                                         ; Channel Interrupt Flag 61
XGIF_6F_60_XGIF_62: equ    2                                         ; Channel Interrupt Flag 62
XGIF_6F_60_XGIF_63: equ    3                                         ; Channel Interrupt Flag 63
XGIF_6F_60_XGIF_64: equ    4                                         ; Channel Interrupt Flag 64
XGIF_6F_60_XGIF_65: equ    5                                         ; Channel Interrupt Flag 65
XGIF_6F_60_XGIF_66: equ    6                                         ; Channel Interrupt Flag 66
XGIF_6F_60_XGIF_67: equ    7                                         ; Channel Interrupt Flag 67
XGIF_6F_60_XGIF_68: equ    8                                         ; Channel Interrupt Flag 68
XGIF_6F_60_XGIF_69: equ    9                                         ; Channel Interrupt Flag 69
XGIF_6F_60_XGIF_6A: equ    10                                        ; Channel Interrupt Flag 6A
XGIF_6F_60_XGIF_6B: equ    11                                        ; Channel Interrupt Flag 6B
XGIF_6F_60_XGIF_6C: equ    12                                        ; Channel Interrupt Flag 6C
XGIF_6F_60_XGIF_6D: equ    13                                        ; Channel Interrupt Flag 6D
XGIF_6F_60_XGIF_6E: equ    14                                        ; Channel Interrupt Flag 6E
XGIF_6F_60_XGIF_6F: equ    15                                        ; Channel Interrupt Flag 6F
; bit position masks
mXGIF_6F_60_XGIF_60: equ    %00000001
mXGIF_6F_60_XGIF_61: equ    %00000010
mXGIF_6F_60_XGIF_62: equ    %00000100
mXGIF_6F_60_XGIF_63: equ    %00001000
mXGIF_6F_60_XGIF_64: equ    %00010000
mXGIF_6F_60_XGIF_65: equ    %00100000
mXGIF_6F_60_XGIF_66: equ    %01000000
mXGIF_6F_60_XGIF_67: equ    %10000000
mXGIF_6F_60_XGIF_68: equ    %100000000
mXGIF_6F_60_XGIF_69: equ    %1000000000
mXGIF_6F_60_XGIF_6A: equ    %10000000000
mXGIF_6F_60_XGIF_6B: equ    %100000000000
mXGIF_6F_60_XGIF_6C: equ    %1000000000000
mXGIF_6F_60_XGIF_6D: equ    %10000000000000
mXGIF_6F_60_XGIF_6E: equ    %100000000000000
mXGIF_6F_60_XGIF_6F: equ    %1000000000000000


;*** XGIF_5F_50 - XGATE Channel Interrupt Flag Vector 2; 0x0000038C ***
XGIF_5F_50:         equ    $0000038C                                ;*** XGIF_5F_50 - XGATE Channel Interrupt Flag Vector 2; 0x0000038C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_5F_50_XGIF_50: equ    0                                         ; Channel Interrupt Flag 50
XGIF_5F_50_XGIF_51: equ    1                                         ; Channel Interrupt Flag 51
XGIF_5F_50_XGIF_52: equ    2                                         ; Channel Interrupt Flag 52
XGIF_5F_50_XGIF_53: equ    3                                         ; Channel Interrupt Flag 53
XGIF_5F_50_XGIF_54: equ    4                                         ; Channel Interrupt Flag 54
XGIF_5F_50_XGIF_55: equ    5                                         ; Channel Interrupt Flag 55
XGIF_5F_50_XGIF_56: equ    6                                         ; Channel Interrupt Flag 56
XGIF_5F_50_XGIF_57: equ    7                                         ; Channel Interrupt Flag 57
XGIF_5F_50_XGIF_58: equ    8                                         ; Channel Interrupt Flag 58
XGIF_5F_50_XGIF_59: equ    9                                         ; Channel Interrupt Flag 59
XGIF_5F_50_XGIF_5A: equ    10                                        ; Channel Interrupt Flag 5A
XGIF_5F_50_XGIF_5B: equ    11                                        ; Channel Interrupt Flag 5B
XGIF_5F_50_XGIF_5C: equ    12                                        ; Channel Interrupt Flag 5C
XGIF_5F_50_XGIF_5D: equ    13                                        ; Channel Interrupt Flag 5D
XGIF_5F_50_XGIF_5E: equ    14                                        ; Channel Interrupt Flag 5E
XGIF_5F_50_XGIF_5F: equ    15                                        ; Channel Interrupt Flag 5F
; bit position masks
mXGIF_5F_50_XGIF_50: equ    %00000001
mXGIF_5F_50_XGIF_51: equ    %00000010
mXGIF_5F_50_XGIF_52: equ    %00000100
mXGIF_5F_50_XGIF_53: equ    %00001000
mXGIF_5F_50_XGIF_54: equ    %00010000
mXGIF_5F_50_XGIF_55: equ    %00100000
mXGIF_5F_50_XGIF_56: equ    %01000000
mXGIF_5F_50_XGIF_57: equ    %10000000
mXGIF_5F_50_XGIF_58: equ    %100000000
mXGIF_5F_50_XGIF_59: equ    %1000000000
mXGIF_5F_50_XGIF_5A: equ    %10000000000
mXGIF_5F_50_XGIF_5B: equ    %100000000000
mXGIF_5F_50_XGIF_5C: equ    %1000000000000
mXGIF_5F_50_XGIF_5D: equ    %10000000000000
mXGIF_5F_50_XGIF_5E: equ    %100000000000000
mXGIF_5F_50_XGIF_5F: equ    %1000000000000000


;*** XGIF_4F_40 - XGATE Channel Interrupt Flag Vector 3; 0x0000038E ***
XGIF_4F_40:         equ    $0000038E                                ;*** XGIF_4F_40 - XGATE Channel Interrupt Flag Vector 3; 0x0000038E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_4F_40_XGIF_40: equ    0                                         ; Channel Interrupt Flag 40
XGIF_4F_40_XGIF_41: equ    1                                         ; Channel Interrupt Flag 41
XGIF_4F_40_XGIF_42: equ    2                                         ; Channel Interrupt Flag 42
XGIF_4F_40_XGIF_43: equ    3                                         ; Channel Interrupt Flag 43
XGIF_4F_40_XGIF_44: equ    4                                         ; Channel Interrupt Flag 44
XGIF_4F_40_XGIF_45: equ    5                                         ; Channel Interrupt Flag 45
XGIF_4F_40_XGIF_46: equ    6                                         ; Channel Interrupt Flag 46
XGIF_4F_40_XGIF_47: equ    7                                         ; Channel Interrupt Flag 47
XGIF_4F_40_XGIF_48: equ    8                                         ; Channel Interrupt Flag 48
XGIF_4F_40_XGIF_49: equ    9                                         ; Channel Interrupt Flag 49
XGIF_4F_40_XGIF_4A: equ    10                                        ; Channel Interrupt Flag 4A
XGIF_4F_40_XGIF_4B: equ    11                                        ; Channel Interrupt Flag 4B
XGIF_4F_40_XGIF_4C: equ    12                                        ; Channel Interrupt Flag 4C
XGIF_4F_40_XGIF_4D: equ    13                                        ; Channel Interrupt Flag 4D
XGIF_4F_40_XGIF_4E: equ    14                                        ; Channel Interrupt Flag 4E
XGIF_4F_40_XGIF_4F: equ    15                                        ; Channel Interrupt Flag 4F
; bit position masks
mXGIF_4F_40_XGIF_40: equ    %00000001
mXGIF_4F_40_XGIF_41: equ    %00000010
mXGIF_4F_40_XGIF_42: equ    %00000100
mXGIF_4F_40_XGIF_43: equ    %00001000
mXGIF_4F_40_XGIF_44: equ    %00010000
mXGIF_4F_40_XGIF_45: equ    %00100000
mXGIF_4F_40_XGIF_46: equ    %01000000
mXGIF_4F_40_XGIF_47: equ    %10000000
mXGIF_4F_40_XGIF_48: equ    %100000000
mXGIF_4F_40_XGIF_49: equ    %1000000000
mXGIF_4F_40_XGIF_4A: equ    %10000000000
mXGIF_4F_40_XGIF_4B: equ    %100000000000
mXGIF_4F_40_XGIF_4C: equ    %1000000000000
mXGIF_4F_40_XGIF_4D: equ    %10000000000000
mXGIF_4F_40_XGIF_4E: equ    %100000000000000
mXGIF_4F_40_XGIF_4F: equ    %1000000000000000


;*** XGIF_3F_30 - XGATE Channel Interrupt Flag Vector 4; 0x00000390 ***
XGIF_3F_30:         equ    $00000390                                ;*** XGIF_3F_30 - XGATE Channel Interrupt Flag Vector 4; 0x00000390 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_3F_30_XGIF_30: equ    0                                         ; Channel Interrupt Flag 30
XGIF_3F_30_XGIF_31: equ    1                                         ; Channel Interrupt Flag 31
XGIF_3F_30_XGIF_32: equ    2                                         ; Channel Interrupt Flag 32
XGIF_3F_30_XGIF_33: equ    3                                         ; Channel Interrupt Flag 33
XGIF_3F_30_XGIF_34: equ    4                                         ; Channel Interrupt Flag 34
XGIF_3F_30_XGIF_35: equ    5                                         ; Channel Interrupt Flag 35
XGIF_3F_30_XGIF_36: equ    6                                         ; Channel Interrupt Flag 36
XGIF_3F_30_XGIF_37: equ    7                                         ; Channel Interrupt Flag 37
XGIF_3F_30_XGIF_38: equ    8                                         ; Channel Interrupt Flag 38
XGIF_3F_30_XGIF_39: equ    9                                         ; Channel Interrupt Flag 39
XGIF_3F_30_XGIF_3A: equ    10                                        ; Channel Interrupt Flag 3A
XGIF_3F_30_XGIF_3B: equ    11                                        ; Channel Interrupt Flag 3B
XGIF_3F_30_XGIF_3C: equ    12                                        ; Channel Interrupt Flag 3C
XGIF_3F_30_XGIF_3D: equ    13                                        ; Channel Interrupt Flag 3D
XGIF_3F_30_XGIF_3E: equ    14                                        ; Channel Interrupt Flag 3E
XGIF_3F_30_XGIF_3F: equ    15                                        ; Channel Interrupt Flag 3F
; bit position masks
mXGIF_3F_30_XGIF_30: equ    %00000001
mXGIF_3F_30_XGIF_31: equ    %00000010
mXGIF_3F_30_XGIF_32: equ    %00000100
mXGIF_3F_30_XGIF_33: equ    %00001000
mXGIF_3F_30_XGIF_34: equ    %00010000
mXGIF_3F_30_XGIF_35: equ    %00100000
mXGIF_3F_30_XGIF_36: equ    %01000000
mXGIF_3F_30_XGIF_37: equ    %10000000
mXGIF_3F_30_XGIF_38: equ    %100000000
mXGIF_3F_30_XGIF_39: equ    %1000000000
mXGIF_3F_30_XGIF_3A: equ    %10000000000
mXGIF_3F_30_XGIF_3B: equ    %100000000000
mXGIF_3F_30_XGIF_3C: equ    %1000000000000
mXGIF_3F_30_XGIF_3D: equ    %10000000000000
mXGIF_3F_30_XGIF_3E: equ    %100000000000000
mXGIF_3F_30_XGIF_3F: equ    %1000000000000000


;*** XGIF_2F_20 - XGATE Channel Interrupt Flag Vector 5; 0x00000392 ***
XGIF_2F_20:         equ    $00000392                                ;*** XGIF_2F_20 - XGATE Channel Interrupt Flag Vector 5; 0x00000392 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_2F_20_XGIF_20: equ    0                                         ; Channel Interrupt Flag 20
XGIF_2F_20_XGIF_21: equ    1                                         ; Channel Interrupt Flag 21
XGIF_2F_20_XGIF_22: equ    2                                         ; Channel Interrupt Flag 22
XGIF_2F_20_XGIF_23: equ    3                                         ; Channel Interrupt Flag 23
XGIF_2F_20_XGIF_24: equ    4                                         ; Channel Interrupt Flag 24
XGIF_2F_20_XGIF_25: equ    5                                         ; Channel Interrupt Flag 25
XGIF_2F_20_XGIF_26: equ    6                                         ; Channel Interrupt Flag 26
XGIF_2F_20_XGIF_27: equ    7                                         ; Channel Interrupt Flag 27
XGIF_2F_20_XGIF_28: equ    8                                         ; Channel Interrupt Flag 28
XGIF_2F_20_XGIF_29: equ    9                                         ; Channel Interrupt Flag 29
XGIF_2F_20_XGIF_2A: equ    10                                        ; Channel Interrupt Flag 2A
XGIF_2F_20_XGIF_2B: equ    11                                        ; Channel Interrupt Flag 2B
XGIF_2F_20_XGIF_2C: equ    12                                        ; Channel Interrupt Flag 2C
XGIF_2F_20_XGIF_2D: equ    13                                        ; Channel Interrupt Flag 2D
XGIF_2F_20_XGIF_2E: equ    14                                        ; Channel Interrupt Flag 2E
XGIF_2F_20_XGIF_2F: equ    15                                        ; Channel Interrupt Flag 2F
; bit position masks
mXGIF_2F_20_XGIF_20: equ    %00000001
mXGIF_2F_20_XGIF_21: equ    %00000010
mXGIF_2F_20_XGIF_22: equ    %00000100
mXGIF_2F_20_XGIF_23: equ    %00001000
mXGIF_2F_20_XGIF_24: equ    %00010000
mXGIF_2F_20_XGIF_25: equ    %00100000
mXGIF_2F_20_XGIF_26: equ    %01000000
mXGIF_2F_20_XGIF_27: equ    %10000000
mXGIF_2F_20_XGIF_28: equ    %100000000
mXGIF_2F_20_XGIF_29: equ    %1000000000
mXGIF_2F_20_XGIF_2A: equ    %10000000000
mXGIF_2F_20_XGIF_2B: equ    %100000000000
mXGIF_2F_20_XGIF_2C: equ    %1000000000000
mXGIF_2F_20_XGIF_2D: equ    %10000000000000
mXGIF_2F_20_XGIF_2E: equ    %100000000000000
mXGIF_2F_20_XGIF_2F: equ    %1000000000000000


;*** XGIF_1F_10 - XGATE Channel Interrupt Flag Vector 6; 0x00000394 ***
XGIF_1F_10:         equ    $00000394                                ;*** XGIF_1F_10 - XGATE Channel Interrupt Flag Vector 6; 0x00000394 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_1F_10_XGIF_10: equ    0                                         ; Channel Interrupt Flag 10
XGIF_1F_10_XGIF_11: equ    1                                         ; Channel Interrupt Flag 11
XGIF_1F_10_XGIF_12: equ    2                                         ; Channel Interrupt Flag 12
XGIF_1F_10_XGIF_13: equ    3                                         ; Channel Interrupt Flag 13
XGIF_1F_10_XGIF_14: equ    4                                         ; Channel Interrupt Flag 14
XGIF_1F_10_XGIF_15: equ    5                                         ; Channel Interrupt Flag 15
XGIF_1F_10_XGIF_16: equ    6                                         ; Channel Interrupt Flag 16
XGIF_1F_10_XGIF_17: equ    7                                         ; Channel Interrupt Flag 17
XGIF_1F_10_XGIF_18: equ    8                                         ; Channel Interrupt Flag 18
XGIF_1F_10_XGIF_19: equ    9                                         ; Channel Interrupt Flag 19
XGIF_1F_10_XGIF_1A: equ    10                                        ; Channel Interrupt Flag 1A
XGIF_1F_10_XGIF_1B: equ    11                                        ; Channel Interrupt Flag 1B
XGIF_1F_10_XGIF_1C: equ    12                                        ; Channel Interrupt Flag 1C
XGIF_1F_10_XGIF_1D: equ    13                                        ; Channel Interrupt Flag 1D
XGIF_1F_10_XGIF_1E: equ    14                                        ; Channel Interrupt Flag 1E
XGIF_1F_10_XGIF_1F: equ    15                                        ; Channel Interrupt Flag 1F
; bit position masks
mXGIF_1F_10_XGIF_10: equ    %00000001
mXGIF_1F_10_XGIF_11: equ    %00000010
mXGIF_1F_10_XGIF_12: equ    %00000100
mXGIF_1F_10_XGIF_13: equ    %00001000
mXGIF_1F_10_XGIF_14: equ    %00010000
mXGIF_1F_10_XGIF_15: equ    %00100000
mXGIF_1F_10_XGIF_16: equ    %01000000
mXGIF_1F_10_XGIF_17: equ    %10000000
mXGIF_1F_10_XGIF_18: equ    %100000000
mXGIF_1F_10_XGIF_19: equ    %1000000000
mXGIF_1F_10_XGIF_1A: equ    %10000000000
mXGIF_1F_10_XGIF_1B: equ    %100000000000
mXGIF_1F_10_XGIF_1C: equ    %1000000000000
mXGIF_1F_10_XGIF_1D: equ    %10000000000000
mXGIF_1F_10_XGIF_1E: equ    %100000000000000
mXGIF_1F_10_XGIF_1F: equ    %1000000000000000


;*** XGIF_0F_00 - XGATE Channel Interrupt Flag Vector 7; 0x00000396 ***
XGIF_0F_00:         equ    $00000396                                ;*** XGIF_0F_00 - XGATE Channel Interrupt Flag Vector 7; 0x00000396 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGIF_0F_00_XGIF_09: equ    9                                         ; Channel Interrupt Flag 09
XGIF_0F_00_XGIF_0A: equ    10                                        ; Channel Interrupt Flag 0A
XGIF_0F_00_XGIF_0B: equ    11                                        ; Channel Interrupt Flag 0B
XGIF_0F_00_XGIF_0C: equ    12                                        ; Channel Interrupt Flag 0C
XGIF_0F_00_XGIF_0D: equ    13                                        ; Channel Interrupt Flag 0D
XGIF_0F_00_XGIF_0E: equ    14                                        ; Channel Interrupt Flag 0E
XGIF_0F_00_XGIF_0F: equ    15                                        ; Channel Interrupt Flag 0F
; bit position masks
mXGIF_0F_00_XGIF_09: equ    %1000000000
mXGIF_0F_00_XGIF_0A: equ    %10000000000
mXGIF_0F_00_XGIF_0B: equ    %100000000000
mXGIF_0F_00_XGIF_0C: equ    %1000000000000
mXGIF_0F_00_XGIF_0D: equ    %10000000000000
mXGIF_0F_00_XGIF_0E: equ    %100000000000000
mXGIF_0F_00_XGIF_0F: equ    %1000000000000000


;*** XGSWT - XGATE Software Trigger Register; 0x00000398 ***
XGSWT:              equ    $00000398                                ;*** XGSWT - XGATE Software Trigger Register; 0x00000398 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGSWT_XGSWT:        equ    0                                         ; Software Trigger Bits
XGSWT_XGSWTM:       equ    8                                         ; Software Trigger Mask
; bit position masks
mXGSWT_XGSWT:       equ    %11111111
mXGSWT_XGSWTM:      equ    %1111111100000000


;*** XGSEM - XGATE Semaphore Register; 0x0000039A ***
XGSEM:              equ    $0000039A                                ;*** XGSEM - XGATE Semaphore Register; 0x0000039A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGSEM_XGSEM:        equ    0                                         ; Semaphore Bits
XGSEM_XGSEMM:       equ    8                                         ; Semaphore Mask
; bit position masks
mXGSEM_XGSEM:       equ    %11111111
mXGSEM_XGSEMM:      equ    %1111111100000000


;*** XGCCR - XGATE Condition Code Register; 0x0000039D ***
XGCCR:              equ    $0000039D                                ;*** XGCCR - XGATE Condition Code Register; 0x0000039D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
XGCCR_XGC:          equ    0                                         ; Carry Flag
XGCCR_XGV:          equ    1                                         ; Overflow Flag
XGCCR_XGZ:          equ    2                                         ; Zero Flag
XGCCR_XGN:          equ    3                                         ; Sign Flag
; bit position masks
mXGCCR_XGC:         equ    %00000001
mXGCCR_XGV:         equ    %00000010
mXGCCR_XGZ:         equ    %00000100
mXGCCR_XGN:         equ    %00001000


;*** XGPC - XGATE Program Counter Register; 0x0000039E ***
XGPC:               equ    $0000039E                                ;*** XGPC - XGATE Program Counter Register; 0x0000039E ***


;*** XGR1 - XGATE Register 1; 0x000003A2 ***
XGR1:               equ    $000003A2                                ;*** XGR1 - XGATE Register 1; 0x000003A2 ***


;*** XGR2 - XGATE Register 2; 0x000003A4 ***
XGR2:               equ    $000003A4                                ;*** XGR2 - XGATE Register 2; 0x000003A4 ***


;*** XGR3 - XGATE Register 3; 0x000003A6 ***
XGR3:               equ    $000003A6                                ;*** XGR3 - XGATE Register 3; 0x000003A6 ***


;*** XGR4 - XGATE Register 4; 0x000003A8 ***
XGR4:               equ    $000003A8                                ;*** XGR4 - XGATE Register 4; 0x000003A8 ***


;*** XGR5 - XGATE Register 5; 0x000003AA ***
XGR5:               equ    $000003AA                                ;*** XGR5 - XGATE Register 5; 0x000003AA ***


;*** XGR6 - XGATE Register 6; 0x000003AC ***
XGR6:               equ    $000003AC                                ;*** XGR6 - XGATE Register 6; 0x000003AC ***


;*** XGR7 - XGATE Register 7; 0x000003AE ***
XGR7:               equ    $000003AE                                ;*** XGR7 - XGATE Register 7; 0x000003AE ***


;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
BAKEY0:             equ    $0000FF00                                ;*** BAKEY0 - Backdoor Access Key 0; 0x0000FF00 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY0_KEY:         equ    0                                         ; Backdoor Access Key bits
; bit position masks
mBAKEY0_KEY:        equ    %1111111111111111


;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
BAKEY1:             equ    $0000FF02                                ;*** BAKEY1 - Backdoor Access Key 1; 0x0000FF02 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY1_KEY:         equ    0                                         ; Backdoor Access Key bits
; bit position masks
mBAKEY1_KEY:        equ    %1111111111111111


;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
BAKEY2:             equ    $0000FF04                                ;*** BAKEY2 - Backdoor Access Key 2; 0x0000FF04 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY2_KEY:         equ    0                                         ; Backdoor Access Key bits
; bit position masks
mBAKEY2_KEY:        equ    %1111111111111111


;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
BAKEY3:             equ    $0000FF06                                ;*** BAKEY3 - Backdoor Access Key 3; 0x0000FF06 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
BAKEY3_KEY:         equ    0                                         ; Backdoor Access Key bits
; bit position masks
mBAKEY3_KEY:        equ    %1111111111111111


;*** NVFPROT - Non volatile Flash Protection Register; 0x0000FF0D ***
NVFPROT:            equ    $0000FF0D                                ;*** NVFPROT - Non volatile Flash Protection Register; 0x0000FF0D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFPROT_FPLS0:      equ    0                                         ; Flash Protection Lower Address size 0
NVFPROT_FPLS1:      equ    1                                         ; Flash Protection Lower Address size 1
NVFPROT_FPLDIS:     equ    2                                         ; Flash Protection Lower address range disable
NVFPROT_FPHS0:      equ    3                                         ; Flash Protection Higher address size 0
NVFPROT_FPHS1:      equ    4                                         ; Flash Protection Higher address size 1
NVFPROT_FPHDIS:     equ    5                                         ; Flash Protection Higher address range disable
NVFPROT_RNV6:       equ    6                                         ; Non Volatile Flag Bit
NVFPROT_FPOPEN:     equ    7                                         ; Opens the flash block or subsections of it for program or erase
; bit position masks
mNVFPROT_FPLS0:     equ    %00000001
mNVFPROT_FPLS1:     equ    %00000010
mNVFPROT_FPLDIS:    equ    %00000100
mNVFPROT_FPHS0:     equ    %00001000
mNVFPROT_FPHS1:     equ    %00010000
mNVFPROT_FPHDIS:    equ    %00100000
mNVFPROT_RNV6:      equ    %01000000
mNVFPROT_FPOPEN:    equ    %10000000


;*** NVFCTL - Non Volatile Flash Control Register; 0x0000FF0E ***
NVFCTL:             equ    $0000FF0E                                ;*** NVFCTL - Non Volatile Flash Control Register; 0x0000FF0E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFCTL_NV0:         equ    0                                         ; Non-volatile bit 0
NVFCTL_NV1:         equ    1                                         ; Non-volatile bit 1
NVFCTL_NV2:         equ    2                                         ; Non-volatile bit 2
NVFCTL_NV3:         equ    3                                         ; Non-volatile bit 3
NVFCTL_NV4:         equ    4                                         ; Non-volatile bit 4
NVFCTL_NV5:         equ    5                                         ; Non-volatile bit 5
NVFCTL_NV6:         equ    6                                         ; Non-volatile bit 6
NVFCTL_NV7:         equ    7                                         ; Non-volatile bit 7
; bit position masks
mNVFCTL_NV0:        equ    %00000001
mNVFCTL_NV1:        equ    %00000010
mNVFCTL_NV2:        equ    %00000100
mNVFCTL_NV3:        equ    %00001000
mNVFCTL_NV4:        equ    %00010000
mNVFCTL_NV5:        equ    %00100000
mNVFCTL_NV6:        equ    %01000000
mNVFCTL_NV7:        equ    %10000000


;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
NVFSEC:             equ    $0000FF0F                                ;*** NVFSEC - Non volatile Flash Security Register; 0x0000FF0F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFSEC_SEC0:        equ    0                                         ; Memory security bit 0
NVFSEC_SEC1:        equ    1                                         ; Memory security bit 1
NVFSEC_RNV2:        equ    2                                         ; Non Volatile flag bit 2
NVFSEC_RNV3:        equ    3                                         ; Non Volatile flag bit 3
NVFSEC_RNV4:        equ    4                                         ; Non Volatile flag bit 4
NVFSEC_RNV5:        equ    5                                         ; Non Volatile flag bit 5
NVFSEC_KEYEN0:      equ    6                                         ; Backdoor Key Security Enable bit 0
NVFSEC_KEYEN1:      equ    7                                         ; Backdoor Key Security Enable bit 1
; bit position masks
mNVFSEC_SEC0:       equ    %00000001
mNVFSEC_SEC1:       equ    %00000010
mNVFSEC_RNV2:       equ    %00000100
mNVFSEC_RNV3:       equ    %00001000
mNVFSEC_RNV4:       equ    %00010000
mNVFSEC_RNV5:       equ    %00100000
mNVFSEC_KEYEN0:     equ    %01000000
mNVFSEC_KEYEN1:     equ    %10000000



;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF
; ---------------------------------------------------------------------------
; The following symbols were removed, because they were invalid or irrelevant
; ---------------------------------------------------------------------------


; **** 4.9.2007 11:05:17

DBGXDH_BIT0:                             equ        DBGXDH_BIT8
DBGXDH_BIT1:                             equ        DBGXDH_BIT9
DBGXDH_BIT2:                             equ        DBGXDH_BIT10
DBGXDH_BIT3:                             equ        DBGXDH_BIT11
DBGXDH_BIT4:                             equ        DBGXDH_BIT12
DBGXDH_BIT5:                             equ        DBGXDH_BIT13
DBGXDH_BIT6:                             equ        DBGXDH_BIT14
DBGXDH_BIT7:                             equ        DBGXDH_BIT15
mDBGXDH_BIT0:                            equ        mDBGXDH_BIT8
mDBGXDH_BIT1:                            equ        mDBGXDH_BIT9
mDBGXDH_BIT2:                            equ        mDBGXDH_BIT10
mDBGXDH_BIT3:                            equ        mDBGXDH_BIT11
mDBGXDH_BIT4:                            equ        mDBGXDH_BIT12
mDBGXDH_BIT5:                            equ        mDBGXDH_BIT13
mDBGXDH_BIT6:                            equ        mDBGXDH_BIT14
mDBGXDH_BIT7:                            equ        mDBGXDH_BIT15
        IFNDEF __GENERATE_APPLICATION__
PA32H_BIT0:                              equ        This_symb_has_been_depreciated
PA32H_BIT1:                              equ        This_symb_has_been_depreciated
PA32H_BIT2:                              equ        This_symb_has_been_depreciated
PA32H_BIT3:                              equ        This_symb_has_been_depreciated
PA32H_BIT4:                              equ        This_symb_has_been_depreciated
PA32H_BIT5:                              equ        This_symb_has_been_depreciated
PA32H_BIT6:                              equ        This_symb_has_been_depreciated
PA32H_BIT7:                              equ        This_symb_has_been_depreciated
PA32H_BIT8:                              equ        This_symb_has_been_depreciated
PA32H_BIT9:                              equ        This_symb_has_been_depreciated
PA32H_BIT10:                             equ        This_symb_has_been_depreciated
PA32H_BIT11:                             equ        This_symb_has_been_depreciated
PA32H_BIT12:                             equ        This_symb_has_been_depreciated
PA32H_BIT13:                             equ        This_symb_has_been_depreciated
PA32H_BIT14:                             equ        This_symb_has_been_depreciated
PA32H_BIT15:                             equ        This_symb_has_been_depreciated
mPA32H_BIT0:                             equ        This_symb_has_been_depreciated
mPA32H_BIT1:                             equ        This_symb_has_been_depreciated
mPA32H_BIT2:                             equ        This_symb_has_been_depreciated
mPA32H_BIT3:                             equ        This_symb_has_been_depreciated
mPA32H_BIT4:                             equ        This_symb_has_been_depreciated
mPA32H_BIT5:                             equ        This_symb_has_been_depreciated
mPA32H_BIT6:                             equ        This_symb_has_been_depreciated
mPA32H_BIT7:                             equ        This_symb_has_been_depreciated
mPA32H_BIT8:                             equ        This_symb_has_been_depreciated
mPA32H_BIT9:                             equ        This_symb_has_been_depreciated
mPA32H_BIT10:                            equ        This_symb_has_been_depreciated
mPA32H_BIT11:                            equ        This_symb_has_been_depreciated
mPA32H_BIT12:                            equ        This_symb_has_been_depreciated
mPA32H_BIT13:                            equ        This_symb_has_been_depreciated
mPA32H_BIT14:                            equ        This_symb_has_been_depreciated
mPA32H_BIT15:                            equ        This_symb_has_been_depreciated
PA3H_BIT0:                               equ        This_symb_has_been_depreciated
PA3H_BIT1:                               equ        This_symb_has_been_depreciated
PA3H_BIT2:                               equ        This_symb_has_been_depreciated
PA3H_BIT3:                               equ        This_symb_has_been_depreciated
PA3H_BIT4:                               equ        This_symb_has_been_depreciated
PA3H_BIT5:                               equ        This_symb_has_been_depreciated
PA3H_BIT6:                               equ        This_symb_has_been_depreciated
PA3H_BIT7:                               equ        This_symb_has_been_depreciated
mPA3H_BIT0:                              equ        This_symb_has_been_depreciated
mPA3H_BIT1:                              equ        This_symb_has_been_depreciated
mPA3H_BIT2:                              equ        This_symb_has_been_depreciated
mPA3H_BIT3:                              equ        This_symb_has_been_depreciated
mPA3H_BIT4:                              equ        This_symb_has_been_depreciated
mPA3H_BIT5:                              equ        This_symb_has_been_depreciated
mPA3H_BIT6:                              equ        This_symb_has_been_depreciated
mPA3H_BIT7:                              equ        This_symb_has_been_depreciated
PA2H_BIT0:                               equ        This_symb_has_been_depreciated
PA2H_BIT1:                               equ        This_symb_has_been_depreciated
PA2H_BIT2:                               equ        This_symb_has_been_depreciated
PA2H_BIT3:                               equ        This_symb_has_been_depreciated
PA2H_BIT4:                               equ        This_symb_has_been_depreciated
PA2H_BIT5:                               equ        This_symb_has_been_depreciated
PA2H_BIT6:                               equ        This_symb_has_been_depreciated
PA2H_BIT7:                               equ        This_symb_has_been_depreciated
mPA2H_BIT0:                              equ        This_symb_has_been_depreciated
mPA2H_BIT1:                              equ        This_symb_has_been_depreciated
mPA2H_BIT2:                              equ        This_symb_has_been_depreciated
mPA2H_BIT3:                              equ        This_symb_has_been_depreciated
mPA2H_BIT4:                              equ        This_symb_has_been_depreciated
mPA2H_BIT5:                              equ        This_symb_has_been_depreciated
mPA2H_BIT6:                              equ        This_symb_has_been_depreciated
mPA2H_BIT7:                              equ        This_symb_has_been_depreciated
PA10H_BIT0:                              equ        This_symb_has_been_depreciated
PA10H_BIT1:                              equ        This_symb_has_been_depreciated
PA10H_BIT2:                              equ        This_symb_has_been_depreciated
PA10H_BIT3:                              equ        This_symb_has_been_depreciated
PA10H_BIT4:                              equ        This_symb_has_been_depreciated
PA10H_BIT5:                              equ        This_symb_has_been_depreciated
PA10H_BIT6:                              equ        This_symb_has_been_depreciated
PA10H_BIT7:                              equ        This_symb_has_been_depreciated
PA10H_BIT8:                              equ        This_symb_has_been_depreciated
PA10H_BIT9:                              equ        This_symb_has_been_depreciated
PA10H_BIT10:                             equ        This_symb_has_been_depreciated
PA10H_BIT11:                             equ        This_symb_has_been_depreciated
PA10H_BIT12:                             equ        This_symb_has_been_depreciated
PA10H_BIT13:                             equ        This_symb_has_been_depreciated
PA10H_BIT14:                             equ        This_symb_has_been_depreciated
PA10H_BIT15:                             equ        This_symb_has_been_depreciated
mPA10H_BIT0:                             equ        This_symb_has_been_depreciated
mPA10H_BIT1:                             equ        This_symb_has_been_depreciated
mPA10H_BIT2:                             equ        This_symb_has_been_depreciated
mPA10H_BIT3:                             equ        This_symb_has_been_depreciated
mPA10H_BIT4:                             equ        This_symb_has_been_depreciated
mPA10H_BIT5:                             equ        This_symb_has_been_depreciated
mPA10H_BIT6:                             equ        This_symb_has_been_depreciated
mPA10H_BIT7:                             equ        This_symb_has_been_depreciated
mPA10H_BIT8:                             equ        This_symb_has_been_depreciated
mPA10H_BIT9:                             equ        This_symb_has_been_depreciated
mPA10H_BIT10:                            equ        This_symb_has_been_depreciated
mPA10H_BIT11:                            equ        This_symb_has_been_depreciated
mPA10H_BIT12:                            equ        This_symb_has_been_depreciated
mPA10H_BIT13:                            equ        This_symb_has_been_depreciated
mPA10H_BIT14:                            equ        This_symb_has_been_depreciated
mPA10H_BIT15:                            equ        This_symb_has_been_depreciated
PA1H_BIT0:                               equ        This_symb_has_been_depreciated
PA1H_BIT1:                               equ        This_symb_has_been_depreciated
PA1H_BIT2:                               equ        This_symb_has_been_depreciated
PA1H_BIT3:                               equ        This_symb_has_been_depreciated
PA1H_BIT4:                               equ        This_symb_has_been_depreciated
PA1H_BIT5:                               equ        This_symb_has_been_depreciated
PA1H_BIT6:                               equ        This_symb_has_been_depreciated
PA1H_BIT7:                               equ        This_symb_has_been_depreciated
mPA1H_BIT0:                              equ        This_symb_has_been_depreciated
mPA1H_BIT1:                              equ        This_symb_has_been_depreciated
mPA1H_BIT2:                              equ        This_symb_has_been_depreciated
mPA1H_BIT3:                              equ        This_symb_has_been_depreciated
mPA1H_BIT4:                              equ        This_symb_has_been_depreciated
mPA1H_BIT5:                              equ        This_symb_has_been_depreciated
mPA1H_BIT6:                              equ        This_symb_has_been_depreciated
mPA1H_BIT7:                              equ        This_symb_has_been_depreciated
PA0H_BIT0:                               equ        This_symb_has_been_depreciated
PA0H_BIT1:                               equ        This_symb_has_been_depreciated
PA0H_BIT2:                               equ        This_symb_has_been_depreciated
PA0H_BIT3:                               equ        This_symb_has_been_depreciated
PA0H_BIT4:                               equ        This_symb_has_been_depreciated
PA0H_BIT5:                               equ        This_symb_has_been_depreciated
PA0H_BIT6:                               equ        This_symb_has_been_depreciated
PA0H_BIT7:                               equ        This_symb_has_been_depreciated
mPA0H_BIT0:                              equ        This_symb_has_been_depreciated
mPA0H_BIT1:                              equ        This_symb_has_been_depreciated
mPA0H_BIT2:                              equ        This_symb_has_been_depreciated
mPA0H_BIT3:                              equ        This_symb_has_been_depreciated
mPA0H_BIT4:                              equ        This_symb_has_been_depreciated
mPA0H_BIT5:                              equ        This_symb_has_been_depreciated
mPA0H_BIT6:                              equ        This_symb_has_been_depreciated
mPA0H_BIT7:                              equ        This_symb_has_been_depreciated
TC0H_BIT0:                               equ        This_symb_has_been_depreciated
TC0H_BIT1:                               equ        This_symb_has_been_depreciated
TC0H_BIT2:                               equ        This_symb_has_been_depreciated
TC0H_BIT3:                               equ        This_symb_has_been_depreciated
TC0H_BIT4:                               equ        This_symb_has_been_depreciated
TC0H_BIT5:                               equ        This_symb_has_been_depreciated
TC0H_BIT6:                               equ        This_symb_has_been_depreciated
TC0H_BIT7:                               equ        This_symb_has_been_depreciated
TC0H_BIT8:                               equ        This_symb_has_been_depreciated
TC0H_BIT9:                               equ        This_symb_has_been_depreciated
TC0H_BIT10:                              equ        This_symb_has_been_depreciated
TC0H_BIT11:                              equ        This_symb_has_been_depreciated
TC0H_BIT12:                              equ        This_symb_has_been_depreciated
TC0H_BIT13:                              equ        This_symb_has_been_depreciated
TC0H_BIT14:                              equ        This_symb_has_been_depreciated
TC0H_BIT15:                              equ        This_symb_has_been_depreciated
mTC0H_BIT0:                              equ        This_symb_has_been_depreciated
mTC0H_BIT1:                              equ        This_symb_has_been_depreciated
mTC0H_BIT2:                              equ        This_symb_has_been_depreciated
mTC0H_BIT3:                              equ        This_symb_has_been_depreciated
mTC0H_BIT4:                              equ        This_symb_has_been_depreciated
mTC0H_BIT5:                              equ        This_symb_has_been_depreciated
mTC0H_BIT6:                              equ        This_symb_has_been_depreciated
mTC0H_BIT7:                              equ        This_symb_has_been_depreciated
mTC0H_BIT8:                              equ        This_symb_has_been_depreciated
mTC0H_BIT9:                              equ        This_symb_has_been_depreciated
mTC0H_BIT10:                             equ        This_symb_has_been_depreciated
mTC0H_BIT11:                             equ        This_symb_has_been_depreciated
mTC0H_BIT12:                             equ        This_symb_has_been_depreciated
mTC0H_BIT13:                             equ        This_symb_has_been_depreciated
mTC0H_BIT14:                             equ        This_symb_has_been_depreciated
mTC0H_BIT15:                             equ        This_symb_has_been_depreciated
TC0Hhi_BIT8:                             equ        This_symb_has_been_depreciated
TC0Hhi_BIT9:                             equ        This_symb_has_been_depreciated
TC0Hhi_BIT10:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT11:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT12:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT13:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT14:                            equ        This_symb_has_been_depreciated
TC0Hhi_BIT15:                            equ        This_symb_has_been_depreciated
mTC0Hhi_BIT8:                            equ        This_symb_has_been_depreciated
mTC0Hhi_BIT9:                            equ        This_symb_has_been_depreciated
mTC0Hhi_BIT10:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT11:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT12:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT13:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT14:                           equ        This_symb_has_been_depreciated
mTC0Hhi_BIT15:                           equ        This_symb_has_been_depreciated
TC0Hlo_BIT0:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT1:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT2:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT3:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT4:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT5:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT6:                             equ        This_symb_has_been_depreciated
TC0Hlo_BIT7:                             equ        This_symb_has_been_depreciated
mTC0Hlo_BIT0:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT1:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT2:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT3:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT4:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT5:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT6:                            equ        This_symb_has_been_depreciated
mTC0Hlo_BIT7:                            equ        This_symb_has_been_depreciated
TC1H_BIT0:                               equ        This_symb_has_been_depreciated
TC1H_BIT1:                               equ        This_symb_has_been_depreciated
TC1H_BIT2:                               equ        This_symb_has_been_depreciated
TC1H_BIT3:                               equ        This_symb_has_been_depreciated
TC1H_BIT4:                               equ        This_symb_has_been_depreciated
TC1H_BIT5:                               equ        This_symb_has_been_depreciated
TC1H_BIT6:                               equ        This_symb_has_been_depreciated
TC1H_BIT7:                               equ        This_symb_has_been_depreciated
TC1H_BIT8:                               equ        This_symb_has_been_depreciated
TC1H_BIT9:                               equ        This_symb_has_been_depreciated
TC1H_BIT10:                              equ        This_symb_has_been_depreciated
TC1H_BIT11:                              equ        This_symb_has_been_depreciated
TC1H_BIT12:                              equ        This_symb_has_been_depreciated
TC1H_BIT13:                              equ        This_symb_has_been_depreciated
TC1H_BIT14:                              equ        This_symb_has_been_depreciated
TC1H_BIT15:                              equ        This_symb_has_been_depreciated
mTC1H_BIT0:                              equ        This_symb_has_been_depreciated
mTC1H_BIT1:                              equ        This_symb_has_been_depreciated
mTC1H_BIT2:                              equ        This_symb_has_been_depreciated
mTC1H_BIT3:                              equ        This_symb_has_been_depreciated
mTC1H_BIT4:                              equ        This_symb_has_been_depreciated
mTC1H_BIT5:                              equ        This_symb_has_been_depreciated
mTC1H_BIT6:                              equ        This_symb_has_been_depreciated
mTC1H_BIT7:                              equ        This_symb_has_been_depreciated
mTC1H_BIT8:                              equ        This_symb_has_been_depreciated
mTC1H_BIT9:                              equ        This_symb_has_been_depreciated
mTC1H_BIT10:                             equ        This_symb_has_been_depreciated
mTC1H_BIT11:                             equ        This_symb_has_been_depreciated
mTC1H_BIT12:                             equ        This_symb_has_been_depreciated
mTC1H_BIT13:                             equ        This_symb_has_been_depreciated
mTC1H_BIT14:                             equ        This_symb_has_been_depreciated
mTC1H_BIT15:                             equ        This_symb_has_been_depreciated
TC1Hhi_BIT8:                             equ        This_symb_has_been_depreciated
TC1Hhi_BIT9:                             equ        This_symb_has_been_depreciated
TC1Hhi_BIT10:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT11:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT12:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT13:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT14:                            equ        This_symb_has_been_depreciated
TC1Hhi_BIT15:                            equ        This_symb_has_been_depreciated
mTC1Hhi_BIT8:                            equ        This_symb_has_been_depreciated
mTC1Hhi_BIT9:                            equ        This_symb_has_been_depreciated
mTC1Hhi_BIT10:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT11:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT12:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT13:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT14:                           equ        This_symb_has_been_depreciated
mTC1Hhi_BIT15:                           equ        This_symb_has_been_depreciated
TC1Hlo_BIT0:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT1:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT2:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT3:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT4:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT5:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT6:                             equ        This_symb_has_been_depreciated
TC1Hlo_BIT7:                             equ        This_symb_has_been_depreciated
mTC1Hlo_BIT0:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT1:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT2:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT3:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT4:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT5:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT6:                            equ        This_symb_has_been_depreciated
mTC1Hlo_BIT7:                            equ        This_symb_has_been_depreciated
TC2H_BIT0:                               equ        This_symb_has_been_depreciated
TC2H_BIT1:                               equ        This_symb_has_been_depreciated
TC2H_BIT2:                               equ        This_symb_has_been_depreciated
TC2H_BIT3:                               equ        This_symb_has_been_depreciated
TC2H_BIT4:                               equ        This_symb_has_been_depreciated
TC2H_BIT5:                               equ        This_symb_has_been_depreciated
TC2H_BIT6:                               equ        This_symb_has_been_depreciated
TC2H_BIT7:                               equ        This_symb_has_been_depreciated
TC2H_BIT8:                               equ        This_symb_has_been_depreciated
TC2H_BIT9:                               equ        This_symb_has_been_depreciated
TC2H_BIT10:                              equ        This_symb_has_been_depreciated
TC2H_BIT11:                              equ        This_symb_has_been_depreciated
TC2H_BIT12:                              equ        This_symb_has_been_depreciated
TC2H_BIT13:                              equ        This_symb_has_been_depreciated
TC2H_BIT14:                              equ        This_symb_has_been_depreciated
TC2H_BIT15:                              equ        This_symb_has_been_depreciated
mTC2H_BIT0:                              equ        This_symb_has_been_depreciated
mTC2H_BIT1:                              equ        This_symb_has_been_depreciated
mTC2H_BIT2:                              equ        This_symb_has_been_depreciated
mTC2H_BIT3:                              equ        This_symb_has_been_depreciated
mTC2H_BIT4:                              equ        This_symb_has_been_depreciated
mTC2H_BIT5:                              equ        This_symb_has_been_depreciated
mTC2H_BIT6:                              equ        This_symb_has_been_depreciated
mTC2H_BIT7:                              equ        This_symb_has_been_depreciated
mTC2H_BIT8:                              equ        This_symb_has_been_depreciated
mTC2H_BIT9:                              equ        This_symb_has_been_depreciated
mTC2H_BIT10:                             equ        This_symb_has_been_depreciated
mTC2H_BIT11:                             equ        This_symb_has_been_depreciated
mTC2H_BIT12:                             equ        This_symb_has_been_depreciated
mTC2H_BIT13:                             equ        This_symb_has_been_depreciated
mTC2H_BIT14:                             equ        This_symb_has_been_depreciated
mTC2H_BIT15:                             equ        This_symb_has_been_depreciated
TC2Hhi_BIT8:                             equ        This_symb_has_been_depreciated
TC2Hhi_BIT9:                             equ        This_symb_has_been_depreciated
TC2Hhi_BIT10:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT11:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT12:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT13:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT14:                            equ        This_symb_has_been_depreciated
TC2Hhi_BIT15:                            equ        This_symb_has_been_depreciated
mTC2Hhi_BIT8:                            equ        This_symb_has_been_depreciated
mTC2Hhi_BIT9:                            equ        This_symb_has_been_depreciated
mTC2Hhi_BIT10:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT11:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT12:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT13:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT14:                           equ        This_symb_has_been_depreciated
mTC2Hhi_BIT15:                           equ        This_symb_has_been_depreciated
TC2Hlo_BIT0:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT1:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT2:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT3:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT4:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT5:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT6:                             equ        This_symb_has_been_depreciated
TC2Hlo_BIT7:                             equ        This_symb_has_been_depreciated
mTC2Hlo_BIT0:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT1:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT2:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT3:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT4:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT5:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT6:                            equ        This_symb_has_been_depreciated
mTC2Hlo_BIT7:                            equ        This_symb_has_been_depreciated
TC3H_BIT0:                               equ        This_symb_has_been_depreciated
TC3H_BIT1:                               equ        This_symb_has_been_depreciated
TC3H_BIT2:                               equ        This_symb_has_been_depreciated
TC3H_BIT3:                               equ        This_symb_has_been_depreciated
TC3H_BIT4:                               equ        This_symb_has_been_depreciated
TC3H_BIT5:                               equ        This_symb_has_been_depreciated
TC3H_BIT6:                               equ        This_symb_has_been_depreciated
TC3H_BIT7:                               equ        This_symb_has_been_depreciated
TC3H_BIT8:                               equ        This_symb_has_been_depreciated
TC3H_BIT9:                               equ        This_symb_has_been_depreciated
TC3H_BIT10:                              equ        This_symb_has_been_depreciated
TC3H_BIT11:                              equ        This_symb_has_been_depreciated
TC3H_BIT12:                              equ        This_symb_has_been_depreciated
TC3H_BIT13:                              equ        This_symb_has_been_depreciated
TC3H_BIT14:                              equ        This_symb_has_been_depreciated
TC3H_BIT15:                              equ        This_symb_has_been_depreciated
mTC3H_BIT0:                              equ        This_symb_has_been_depreciated
mTC3H_BIT1:                              equ        This_symb_has_been_depreciated
mTC3H_BIT2:                              equ        This_symb_has_been_depreciated
mTC3H_BIT3:                              equ        This_symb_has_been_depreciated
mTC3H_BIT4:                              equ        This_symb_has_been_depreciated
mTC3H_BIT5:                              equ        This_symb_has_been_depreciated
mTC3H_BIT6:                              equ        This_symb_has_been_depreciated
mTC3H_BIT7:                              equ        This_symb_has_been_depreciated
mTC3H_BIT8:                              equ        This_symb_has_been_depreciated
mTC3H_BIT9:                              equ        This_symb_has_been_depreciated
mTC3H_BIT10:                             equ        This_symb_has_been_depreciated
mTC3H_BIT11:                             equ        This_symb_has_been_depreciated
mTC3H_BIT12:                             equ        This_symb_has_been_depreciated
mTC3H_BIT13:                             equ        This_symb_has_been_depreciated
mTC3H_BIT14:                             equ        This_symb_has_been_depreciated
mTC3H_BIT15:                             equ        This_symb_has_been_depreciated
TC3Hhi_BIT8:                             equ        This_symb_has_been_depreciated
TC3Hhi_BIT9:                             equ        This_symb_has_been_depreciated
TC3Hhi_BIT10:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT11:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT12:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT13:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT14:                            equ        This_symb_has_been_depreciated
TC3Hhi_BIT15:                            equ        This_symb_has_been_depreciated
mTC3Hhi_BIT8:                            equ        This_symb_has_been_depreciated
mTC3Hhi_BIT9:                            equ        This_symb_has_been_depreciated
mTC3Hhi_BIT10:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT11:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT12:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT13:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT14:                           equ        This_symb_has_been_depreciated
mTC3Hhi_BIT15:                           equ        This_symb_has_been_depreciated
TC3Hlo_BIT0:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT1:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT2:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT3:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT4:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT5:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT6:                             equ        This_symb_has_been_depreciated
TC3Hlo_BIT7:                             equ        This_symb_has_been_depreciated
mTC3Hlo_BIT0:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT1:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT2:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT3:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT4:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT5:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT6:                            equ        This_symb_has_been_depreciated
mTC3Hlo_BIT7:                            equ        This_symb_has_been_depreciated
        ENDIF
XGCHID_XGCHIDGrp:                        equ        XGCHID_XGCHID
mXGCHID_XGCHIDGrp:                       equ        mXGCHID_XGCHID
XGVBR_XGVBRGrp:                          equ        XGVBR_XGVBR
mXGVBR_XGVBRGrp:                         equ        mXGVBR_XGVBR
XGIF0:                                   equ        XGIF_7F_70
XGIF0_XGIF_70:                           equ        XGIF_7F_70_XGIF_70
XGIF0_XGIF_71:                           equ        XGIF_7F_70_XGIF_71
XGIF0_XGIF_72:                           equ        XGIF_7F_70_XGIF_72
XGIF0_XGIF_73:                           equ        XGIF_7F_70_XGIF_73
XGIF0_XGIF_74:                           equ        XGIF_7F_70_XGIF_74
XGIF0_XGIF_75:                           equ        XGIF_7F_70_XGIF_75
XGIF0_XGIF_76:                           equ        XGIF_7F_70_XGIF_76
XGIF0_XGIF_77:                           equ        XGIF_7F_70_XGIF_77
XGIF0_XGIF_78:                           equ        XGIF_7F_70_XGIF_78
mXGIF0_XGIF_70:                          equ        mXGIF_7F_70_XGIF_70
mXGIF0_XGIF_71:                          equ        mXGIF_7F_70_XGIF_71
mXGIF0_XGIF_72:                          equ        mXGIF_7F_70_XGIF_72
mXGIF0_XGIF_73:                          equ        mXGIF_7F_70_XGIF_73
mXGIF0_XGIF_74:                          equ        mXGIF_7F_70_XGIF_74
mXGIF0_XGIF_75:                          equ        mXGIF_7F_70_XGIF_75
mXGIF0_XGIF_76:                          equ        mXGIF_7F_70_XGIF_76
mXGIF0_XGIF_77:                          equ        mXGIF_7F_70_XGIF_77
mXGIF0_XGIF_78:                          equ        mXGIF_7F_70_XGIF_78
XGIF1:                                   equ        XGIF_6F_60
XGIF1_XGIF_60:                           equ        XGIF_6F_60_XGIF_60
XGIF1_XGIF_61:                           equ        XGIF_6F_60_XGIF_61
XGIF1_XGIF_62:                           equ        XGIF_6F_60_XGIF_62
XGIF1_XGIF_63:                           equ        XGIF_6F_60_XGIF_63
XGIF1_XGIF_64:                           equ        XGIF_6F_60_XGIF_64
XGIF1_XGIF_65:                           equ        XGIF_6F_60_XGIF_65
XGIF1_XGIF_66:                           equ        XGIF_6F_60_XGIF_66
XGIF1_XGIF_67:                           equ        XGIF_6F_60_XGIF_67
XGIF1_XGIF_68:                           equ        XGIF_6F_60_XGIF_68
XGIF1_XGIF_69:                           equ        XGIF_6F_60_XGIF_69
XGIF1_XGIF_6A:                           equ        XGIF_6F_60_XGIF_6A
XGIF1_XGIF_6B:                           equ        XGIF_6F_60_XGIF_6B
XGIF1_XGIF_6C:                           equ        XGIF_6F_60_XGIF_6C
XGIF1_XGIF_6D:                           equ        XGIF_6F_60_XGIF_6D
XGIF1_XGIF_6E:                           equ        XGIF_6F_60_XGIF_6E
XGIF1_XGIF_6F:                           equ        XGIF_6F_60_XGIF_6F
mXGIF1_XGIF_60:                          equ        mXGIF_6F_60_XGIF_60
mXGIF1_XGIF_61:                          equ        mXGIF_6F_60_XGIF_61
mXGIF1_XGIF_62:                          equ        mXGIF_6F_60_XGIF_62
mXGIF1_XGIF_63:                          equ        mXGIF_6F_60_XGIF_63
mXGIF1_XGIF_64:                          equ        mXGIF_6F_60_XGIF_64
mXGIF1_XGIF_65:                          equ        mXGIF_6F_60_XGIF_65
mXGIF1_XGIF_66:                          equ        mXGIF_6F_60_XGIF_66
mXGIF1_XGIF_67:                          equ        mXGIF_6F_60_XGIF_67
mXGIF1_XGIF_68:                          equ        mXGIF_6F_60_XGIF_68
mXGIF1_XGIF_69:                          equ        mXGIF_6F_60_XGIF_69
mXGIF1_XGIF_6A:                          equ        mXGIF_6F_60_XGIF_6A
mXGIF1_XGIF_6B:                          equ        mXGIF_6F_60_XGIF_6B
mXGIF1_XGIF_6C:                          equ        mXGIF_6F_60_XGIF_6C
mXGIF1_XGIF_6D:                          equ        mXGIF_6F_60_XGIF_6D
mXGIF1_XGIF_6E:                          equ        mXGIF_6F_60_XGIF_6E
mXGIF1_XGIF_6F:                          equ        mXGIF_6F_60_XGIF_6F
XGIF2:                                   equ        XGIF_5F_50
XGIF2_XGIF_50:                           equ        XGIF_5F_50_XGIF_50
XGIF2_XGIF_51:                           equ        XGIF_5F_50_XGIF_51
XGIF2_XGIF_52:                           equ        XGIF_5F_50_XGIF_52
XGIF2_XGIF_53:                           equ        XGIF_5F_50_XGIF_53
XGIF2_XGIF_54:                           equ        XGIF_5F_50_XGIF_54
XGIF2_XGIF_55:                           equ        XGIF_5F_50_XGIF_55
XGIF2_XGIF_56:                           equ        XGIF_5F_50_XGIF_56
XGIF2_XGIF_57:                           equ        XGIF_5F_50_XGIF_57
XGIF2_XGIF_58:                           equ        XGIF_5F_50_XGIF_58
XGIF2_XGIF_59:                           equ        XGIF_5F_50_XGIF_59
XGIF2_XGIF_5A:                           equ        XGIF_5F_50_XGIF_5A
XGIF2_XGIF_5B:                           equ        XGIF_5F_50_XGIF_5B
XGIF2_XGIF_5C:                           equ        XGIF_5F_50_XGIF_5C
XGIF2_XGIF_5D:                           equ        XGIF_5F_50_XGIF_5D
XGIF2_XGIF_5E:                           equ        XGIF_5F_50_XGIF_5E
XGIF2_XGIF_5F:                           equ        XGIF_5F_50_XGIF_5F
mXGIF2_XGIF_50:                          equ        mXGIF_5F_50_XGIF_50
mXGIF2_XGIF_51:                          equ        mXGIF_5F_50_XGIF_51
mXGIF2_XGIF_52:                          equ        mXGIF_5F_50_XGIF_52
mXGIF2_XGIF_53:                          equ        mXGIF_5F_50_XGIF_53
mXGIF2_XGIF_54:                          equ        mXGIF_5F_50_XGIF_54
mXGIF2_XGIF_55:                          equ        mXGIF_5F_50_XGIF_55
mXGIF2_XGIF_56:                          equ        mXGIF_5F_50_XGIF_56
mXGIF2_XGIF_57:                          equ        mXGIF_5F_50_XGIF_57
mXGIF2_XGIF_58:                          equ        mXGIF_5F_50_XGIF_58
mXGIF2_XGIF_59:                          equ        mXGIF_5F_50_XGIF_59
mXGIF2_XGIF_5A:                          equ        mXGIF_5F_50_XGIF_5A
mXGIF2_XGIF_5B:                          equ        mXGIF_5F_50_XGIF_5B
mXGIF2_XGIF_5C:                          equ        mXGIF_5F_50_XGIF_5C
mXGIF2_XGIF_5D:                          equ        mXGIF_5F_50_XGIF_5D
mXGIF2_XGIF_5E:                          equ        mXGIF_5F_50_XGIF_5E
mXGIF2_XGIF_5F:                          equ        mXGIF_5F_50_XGIF_5F
XGIF3:                                   equ        XGIF_4F_40
XGIF3_XGIF_40:                           equ        XGIF_4F_40_XGIF_40
XGIF3_XGIF_41:                           equ        XGIF_4F_40_XGIF_41
XGIF3_XGIF_42:                           equ        XGIF_4F_40_XGIF_42
XGIF3_XGIF_43:                           equ        XGIF_4F_40_XGIF_43
XGIF3_XGIF_44:                           equ        XGIF_4F_40_XGIF_44
XGIF3_XGIF_45:                           equ        XGIF_4F_40_XGIF_45
XGIF3_XGIF_46:                           equ        XGIF_4F_40_XGIF_46
XGIF3_XGIF_47:                           equ        XGIF_4F_40_XGIF_47
XGIF3_XGIF_48:                           equ        XGIF_4F_40_XGIF_48
XGIF3_XGIF_49:                           equ        XGIF_4F_40_XGIF_49
XGIF3_XGIF_4A:                           equ        XGIF_4F_40_XGIF_4A
XGIF3_XGIF_4B:                           equ        XGIF_4F_40_XGIF_4B
XGIF3_XGIF_4C:                           equ        XGIF_4F_40_XGIF_4C
XGIF3_XGIF_4D:                           equ        XGIF_4F_40_XGIF_4D
XGIF3_XGIF_4E:                           equ        XGIF_4F_40_XGIF_4E
XGIF3_XGIF_4F:                           equ        XGIF_4F_40_XGIF_4F
mXGIF3_XGIF_40:                          equ        mXGIF_4F_40_XGIF_40
mXGIF3_XGIF_41:                          equ        mXGIF_4F_40_XGIF_41
mXGIF3_XGIF_42:                          equ        mXGIF_4F_40_XGIF_42
mXGIF3_XGIF_43:                          equ        mXGIF_4F_40_XGIF_43
mXGIF3_XGIF_44:                          equ        mXGIF_4F_40_XGIF_44
mXGIF3_XGIF_45:                          equ        mXGIF_4F_40_XGIF_45
mXGIF3_XGIF_46:                          equ        mXGIF_4F_40_XGIF_46
mXGIF3_XGIF_47:                          equ        mXGIF_4F_40_XGIF_47
mXGIF3_XGIF_48:                          equ        mXGIF_4F_40_XGIF_48
mXGIF3_XGIF_49:                          equ        mXGIF_4F_40_XGIF_49
mXGIF3_XGIF_4A:                          equ        mXGIF_4F_40_XGIF_4A
mXGIF3_XGIF_4B:                          equ        mXGIF_4F_40_XGIF_4B
mXGIF3_XGIF_4C:                          equ        mXGIF_4F_40_XGIF_4C
mXGIF3_XGIF_4D:                          equ        mXGIF_4F_40_XGIF_4D
mXGIF3_XGIF_4E:                          equ        mXGIF_4F_40_XGIF_4E
mXGIF3_XGIF_4F:                          equ        mXGIF_4F_40_XGIF_4F
XGIF4:                                   equ        XGIF_3F_30
XGIF4_XGIF_30:                           equ        XGIF_3F_30_XGIF_30
XGIF4_XGIF_31:                           equ        XGIF_3F_30_XGIF_31
XGIF4_XGIF_32:                           equ        XGIF_3F_30_XGIF_32
XGIF4_XGIF_33:                           equ        XGIF_3F_30_XGIF_33
XGIF4_XGIF_34:                           equ        XGIF_3F_30_XGIF_34
XGIF4_XGIF_35:                           equ        XGIF_3F_30_XGIF_35
XGIF4_XGIF_36:                           equ        XGIF_3F_30_XGIF_36
XGIF4_XGIF_37:                           equ        XGIF_3F_30_XGIF_37
XGIF4_XGIF_38:                           equ        XGIF_3F_30_XGIF_38
XGIF4_XGIF_39:                           equ        XGIF_3F_30_XGIF_39
XGIF4_XGIF_3A:                           equ        XGIF_3F_30_XGIF_3A
XGIF4_XGIF_3B:                           equ        XGIF_3F_30_XGIF_3B
XGIF4_XGIF_3C:                           equ        XGIF_3F_30_XGIF_3C
XGIF4_XGIF_3D:                           equ        XGIF_3F_30_XGIF_3D
XGIF4_XGIF_3E:                           equ        XGIF_3F_30_XGIF_3E
XGIF4_XGIF_3F:                           equ        XGIF_3F_30_XGIF_3F
mXGIF4_XGIF_30:                          equ        mXGIF_3F_30_XGIF_30
mXGIF4_XGIF_31:                          equ        mXGIF_3F_30_XGIF_31
mXGIF4_XGIF_32:                          equ        mXGIF_3F_30_XGIF_32
mXGIF4_XGIF_33:                          equ        mXGIF_3F_30_XGIF_33
mXGIF4_XGIF_34:                          equ        mXGIF_3F_30_XGIF_34
mXGIF4_XGIF_35:                          equ        mXGIF_3F_30_XGIF_35
mXGIF4_XGIF_36:                          equ        mXGIF_3F_30_XGIF_36
mXGIF4_XGIF_37:                          equ        mXGIF_3F_30_XGIF_37
mXGIF4_XGIF_38:                          equ        mXGIF_3F_30_XGIF_38
mXGIF4_XGIF_39:                          equ        mXGIF_3F_30_XGIF_39
mXGIF4_XGIF_3A:                          equ        mXGIF_3F_30_XGIF_3A
mXGIF4_XGIF_3B:                          equ        mXGIF_3F_30_XGIF_3B
mXGIF4_XGIF_3C:                          equ        mXGIF_3F_30_XGIF_3C
mXGIF4_XGIF_3D:                          equ        mXGIF_3F_30_XGIF_3D
mXGIF4_XGIF_3E:                          equ        mXGIF_3F_30_XGIF_3E
mXGIF4_XGIF_3F:                          equ        mXGIF_3F_30_XGIF_3F
XGIF5:                                   equ        XGIF_2F_20
XGIF5_XGIF_20:                           equ        XGIF_2F_20_XGIF_20
XGIF5_XGIF_21:                           equ        XGIF_2F_20_XGIF_21
XGIF5_XGIF_22:                           equ        XGIF_2F_20_XGIF_22
XGIF5_XGIF_23:                           equ        XGIF_2F_20_XGIF_23
XGIF5_XGIF_24:                           equ        XGIF_2F_20_XGIF_24
XGIF5_XGIF_25:                           equ        XGIF_2F_20_XGIF_25
XGIF5_XGIF_26:                           equ        XGIF_2F_20_XGIF_26
XGIF5_XGIF_27:                           equ        XGIF_2F_20_XGIF_27
XGIF5_XGIF_28:                           equ        XGIF_2F_20_XGIF_28
XGIF5_XGIF_29:                           equ        XGIF_2F_20_XGIF_29
XGIF5_XGIF_2A:                           equ        XGIF_2F_20_XGIF_2A
XGIF5_XGIF_2B:                           equ        XGIF_2F_20_XGIF_2B
XGIF5_XGIF_2C:                           equ        XGIF_2F_20_XGIF_2C
XGIF5_XGIF_2D:                           equ        XGIF_2F_20_XGIF_2D
XGIF5_XGIF_2E:                           equ        XGIF_2F_20_XGIF_2E
XGIF5_XGIF_2F:                           equ        XGIF_2F_20_XGIF_2F
mXGIF5_XGIF_20:                          equ        mXGIF_2F_20_XGIF_20
mXGIF5_XGIF_21:                          equ        mXGIF_2F_20_XGIF_21
mXGIF5_XGIF_22:                          equ        mXGIF_2F_20_XGIF_22
mXGIF5_XGIF_23:                          equ        mXGIF_2F_20_XGIF_23
mXGIF5_XGIF_24:                          equ        mXGIF_2F_20_XGIF_24
mXGIF5_XGIF_25:                          equ        mXGIF_2F_20_XGIF_25
mXGIF5_XGIF_26:                          equ        mXGIF_2F_20_XGIF_26
mXGIF5_XGIF_27:                          equ        mXGIF_2F_20_XGIF_27
mXGIF5_XGIF_28:                          equ        mXGIF_2F_20_XGIF_28
mXGIF5_XGIF_29:                          equ        mXGIF_2F_20_XGIF_29
mXGIF5_XGIF_2A:                          equ        mXGIF_2F_20_XGIF_2A
mXGIF5_XGIF_2B:                          equ        mXGIF_2F_20_XGIF_2B
mXGIF5_XGIF_2C:                          equ        mXGIF_2F_20_XGIF_2C
mXGIF5_XGIF_2D:                          equ        mXGIF_2F_20_XGIF_2D
mXGIF5_XGIF_2E:                          equ        mXGIF_2F_20_XGIF_2E
mXGIF5_XGIF_2F:                          equ        mXGIF_2F_20_XGIF_2F
XGIF6:                                   equ        XGIF_1F_10
XGIF6_XGIF_10:                           equ        XGIF_1F_10_XGIF_10
XGIF6_XGIF_11:                           equ        XGIF_1F_10_XGIF_11
XGIF6_XGIF_12:                           equ        XGIF_1F_10_XGIF_12
XGIF6_XGIF_13:                           equ        XGIF_1F_10_XGIF_13
XGIF6_XGIF_14:                           equ        XGIF_1F_10_XGIF_14
XGIF6_XGIF_15:                           equ        XGIF_1F_10_XGIF_15
XGIF6_XGIF_16:                           equ        XGIF_1F_10_XGIF_16
XGIF6_XGIF_17:                           equ        XGIF_1F_10_XGIF_17
XGIF6_XGIF_18:                           equ        XGIF_1F_10_XGIF_18
XGIF6_XGIF_19:                           equ        XGIF_1F_10_XGIF_19
XGIF6_XGIF_1A:                           equ        XGIF_1F_10_XGIF_1A
XGIF6_XGIF_1B:                           equ        XGIF_1F_10_XGIF_1B
XGIF6_XGIF_1C:                           equ        XGIF_1F_10_XGIF_1C
XGIF6_XGIF_1D:                           equ        XGIF_1F_10_XGIF_1D
XGIF6_XGIF_1E:                           equ        XGIF_1F_10_XGIF_1E
XGIF6_XGIF_1F:                           equ        XGIF_1F_10_XGIF_1F
mXGIF6_XGIF_10:                          equ        mXGIF_1F_10_XGIF_10
mXGIF6_XGIF_11:                          equ        mXGIF_1F_10_XGIF_11
mXGIF6_XGIF_12:                          equ        mXGIF_1F_10_XGIF_12
mXGIF6_XGIF_13:                          equ        mXGIF_1F_10_XGIF_13
mXGIF6_XGIF_14:                          equ        mXGIF_1F_10_XGIF_14
mXGIF6_XGIF_15:                          equ        mXGIF_1F_10_XGIF_15
mXGIF6_XGIF_16:                          equ        mXGIF_1F_10_XGIF_16
mXGIF6_XGIF_17:                          equ        mXGIF_1F_10_XGIF_17
mXGIF6_XGIF_18:                          equ        mXGIF_1F_10_XGIF_18
mXGIF6_XGIF_19:                          equ        mXGIF_1F_10_XGIF_19
mXGIF6_XGIF_1A:                          equ        mXGIF_1F_10_XGIF_1A
mXGIF6_XGIF_1B:                          equ        mXGIF_1F_10_XGIF_1B
mXGIF6_XGIF_1C:                          equ        mXGIF_1F_10_XGIF_1C
mXGIF6_XGIF_1D:                          equ        mXGIF_1F_10_XGIF_1D
mXGIF6_XGIF_1E:                          equ        mXGIF_1F_10_XGIF_1E
mXGIF6_XGIF_1F:                          equ        mXGIF_1F_10_XGIF_1F
XGIF7:                                   equ        XGIF_0F_00
XGIF7_XGIF_09:                           equ        XGIF_0F_00_XGIF_09
XGIF7_XGIF_0A:                           equ        XGIF_0F_00_XGIF_0A
XGIF7_XGIF_0B:                           equ        XGIF_0F_00_XGIF_0B
XGIF7_XGIF_0C:                           equ        XGIF_0F_00_XGIF_0C
XGIF7_XGIF_0D:                           equ        XGIF_0F_00_XGIF_0D
XGIF7_XGIF_0E:                           equ        XGIF_0F_00_XGIF_0E
XGIF7_XGIF_0F:                           equ        XGIF_0F_00_XGIF_0F
mXGIF7_XGIF_09:                          equ        mXGIF_0F_00_XGIF_09
mXGIF7_XGIF_0A:                          equ        mXGIF_0F_00_XGIF_0A
mXGIF7_XGIF_0B:                          equ        mXGIF_0F_00_XGIF_0B
mXGIF7_XGIF_0C:                          equ        mXGIF_0F_00_XGIF_0C
mXGIF7_XGIF_0D:                          equ        mXGIF_0F_00_XGIF_0D
mXGIF7_XGIF_0E:                          equ        mXGIF_0F_00_XGIF_0E
mXGIF7_XGIF_0F:                          equ        mXGIF_0F_00_XGIF_0F
XGSWT_XGSWTGrp:                          equ        XGSWT_XGSWT
mXGSWT_XGSWTGrp:                         equ        mXGSWT_XGSWT
XGSEM_XGSEMGrp:                          equ        XGSEM_XGSEM
mXGSEM_XGSEMGrp:                         equ        mXGSEM_XGSEM


; **** 6.9.2007 7:43:55

INT_CFADDR_INT_CFADDRGrp:                equ        INT_CFADDR_INT_CFADDR
mINT_CFADDR_INT_CFADDRGrp:               equ        mINT_CFADDR_INT_CFADDR
NVFPROT_NV6:                             equ        NVFPROT_RNV6
mNVFPROT_NV6:                            equ        mNVFPROT_RNV6
NVFSEC_NV2:                              equ        NVFSEC_RNV2
NVFSEC_NV3:                              equ        NVFSEC_RNV3
NVFSEC_NV4:                              equ        NVFSEC_RNV4
NVFSEC_NV5:                              equ        NVFSEC_RNV5
NVFSEC_NV6:                              equ        NVFSEC_KEYEN0
NVFSEC_KEYEN:                            equ        NVFSEC_KEYEN1
mNVFSEC_NV2:                             equ        mNVFSEC_RNV2
mNVFSEC_NV3:                             equ        mNVFSEC_RNV3
mNVFSEC_NV4:                             equ        mNVFSEC_RNV4
mNVFSEC_NV5:                             equ        mNVFSEC_RNV5
mNVFSEC_NV6:                             equ        mNVFSEC_KEYEN0
mNVFSEC_KEYEN:                           equ        mNVFSEC_KEYEN1


; **** 1.10.2007 13:52:39

SCI2CR2_SCTIE:                           equ        SCI2CR2_TIE
mSCI2CR2_SCTIE:                          equ        mSCI2CR2_TIE
SCI3CR2_SCTIE:                           equ        SCI3CR2_TIE
mSCI3CR2_SCTIE:                          equ        mSCI3CR2_TIE
SCI0CR2_SCTIE:                           equ        SCI0CR2_TIE
mSCI0CR2_SCTIE:                          equ        mSCI0CR2_TIE
SCI1CR2_SCTIE:                           equ        SCI1CR2_TIE
mSCI1CR2_SCTIE:                          equ        mSCI1CR2_TIE
SCI4CR2_SCTIE:                           equ        SCI4CR2_TIE
mSCI4CR2_SCTIE:                          equ        mSCI4CR2_TIE
SCI5CR2_SCTIE:                           equ        SCI5CR2_TIE
mSCI5CR2_SCTIE:                          equ        mSCI5CR2_TIE

; EOF
