/* Based on CPU DB MC9S12XDP512_144, version 2.87.300 (RegistersPrg V2.32) */
/*
** ###################################################################
**     Filename  : mc9s12xdp512.h
**     Processor : MC9S12XDP512BCFV
**     FileFormat: V2.32
**     DataSheet : MC9S12XDP512RMV2 Rev. 2.18 May 2008
**     Compiler  : CodeWarrior compiler
**     Date/Time : 7.6.2010, 15:24
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**      - 24.05.2006, V2.87.141:
**              - Removed bits MCCNTlo_BIT0..MCCNTlo_BIT7 and MCCNThi_BIT8.. MCCNThi_BIT15. REASON: Bug-fix (#3166 in Issue Manager)
**      - 29.08.2007, V2.87.239:
**              -  Added bit DBGXCTL_BRK, Renamed bits DBGXDH_BIT0..7 ==> DBGXDH_BIT8..15. REASON: Bug-fix (#5173 in Issue Manager).
**      - 29.08.2007, V2.87.242:
**              - Added register XGCCR, Renamed groups XGCHID_XGCHIDGrp ==> XGCHID_XGCHID, 
**              - XGVBR_XGVBRGrp ==> XGVBR_XGVBR,
**              - XGSWT_XGSWTGrp ==> XGSWT_XGSWT,
**              - XGSEM_XGSEMGrp ==> XGSEM_XGSEM, Renamed registers XGIFn ==> XGIF_nF_n0. REASON: Bug-fix (#5180 in Issue Manager).
**      - 29.08.2007, V2.87.244:
**              - Added register DBGMFR. REASON: Bug-fix(#5173 in the Issue Manager).
**      - 03.09.2007, V2.87.249:
**              - Removed bits PAxH_BIT0..BIT7/15, TCxH..BIT0..BIT7/15. REASON: Access to the individual bits is not necessary (issue #5192 in Issue Manager).
**      - 05.09.2007, V2.87.269:
**              - Added registers FCTL, NVFCTL, EADDR, EDATA, FADDR, FDATA. Added bits EDATAHI_EDHI0..7, EDATALO_EDLO0..7, COPCTL_WRTMASK, MMCCTL0_CS3E, FCNFG_BKSEL0..1, FSTAT_FAIL, ESTAT_FAIL. Renamed group INT_CFADDRGrp ==> INT_CFADDR, Renamed bit NVFPROT_NV6 ==> NVFPROT_RNV6.
**              - Corrected bits in register NVFSEC[SEC0:1,NV2:NV6,KEYEN] ==> NVFSEC[SEC0:1,RNV2:RNV5,KEYEN0:1].
**              - REASON: Bug-fix (issue #5204 in the Issue Manager).
**      - 14.11.2008, V2.87.301:
**              - Corrected definition of depreciated symbols.
**              -   REASON: Bug-fix(#6592 in Issue Manager).
**
**     File-Format-Revisions:
**      - 27.10.2006, V2.10 :
**               - __RESET_WATCHDOG improved formating and re-definition
**      - 23.11.2006, V2.11 :
**               - Changes have not affected this file (because they are related to another family)
**      - 22.01.2007, V2.12 :
**               - Fixed declaration of non volatile registers. Now it does not require (but allows) their initialization, see issue #4086.
**      - 01.03.2007, V2.13 :
**               - Flash commands constants values converted to HEX format
**      - 02.03.2007, V2.14 :
**               - Interrupt vector numbers added into .H, see VectorNumber_*
**      - 26.03.2007, V2.15 :
**               - Changes have not affected this file (because they are related to another family)
**      - 10.05.2007, V2.16 :
**               - Changes have not affected this file (because they are related to another family)
**      - 05.06.2007, V2.17 :
**               - Changes have not affected this file (because they are related to another family)
**      - 19.07.2007, V2.18 :
**               - Improved number of blanked lines inside register structures
**      - 06.08.2007, V2.19 :
**               - CPUDB revisions generated ahead of the file-format revisions.
**      - 11.09.2007, V2.20 :
**               - Added comment about initialization of unbonded pins.
**      - 02.01.2008, V2.21 :
**               - Changes have not affected this file (because they are related to another family)
**      - 13.02.2008, V2.22 :
**               - Changes have not affected this file (because they are related to another family)
**      - 20.02.2008, V2.23 :
**               - Termination of pragma V30toV31Compatible added, #5708
**      - 03.07.2008, V2.24 :
**               - Added support for bits with name starting with number (like "1HZ")
**      - 28.11.2008, V2.25 :
**               - StandBy RAM array declaration for ANSI-C added
**      - 1.12.2008, V2.26 :
**               - Duplication of bit (or bit-group) name with register name is not marked as a problem, is register is internal only and it is not displayed in I/O map.
**      - 17.3.2009, V2.27 :
**               - Merged bit-group is not generated, if the name matches with another bit name in the register
**      - 6.4.2009, V2.28 :
**               - Fixed generation of merged bits for bit-groups with a digit at the end, if group-name is defined in CPUDB
**      - 3.8.2009, V2.29 :
**               - If there is just one bits group matching register name, single bits are not generated
**      - 10.9.2009, V2.30 :
**               - Fixed generation of registers arrays.
**      - 15.10.2009, V2.31 :
**               - Changes have not affected this file (because they are related to another family)
**      - 18.05.2010, V2.32 :
**               - MISRA compliance: U/UL suffixes added to all numbers (_MASK,_BITNUM and addresses)
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S12XDP512_H
#define _MC9S12XDP512_H

/*lint -save  -e950 -esym(960,18.4) -e46 -esym(961,19.7) Disable MISRA rule (1.1,18.4,6.4,19.7) checking. */
/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295" /*this guarantee correct bitfield positions*/

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vsi                119U
#define VectorNumber_Reserved119        118U
#define VectorNumber_Reserved118        117U
#define VectorNumber_Reserved117        116U
#define VectorNumber_Reserved116        115U
#define VectorNumber_Reserved115        114U
#define VectorNumber_Reserved114        113U
#define VectorNumber_Reserved113        112U
#define VectorNumber_Reserved112        111U
#define VectorNumber_Reserved111        110U
#define VectorNumber_Reserved110        109U
#define VectorNumber_Reserved109        108U
#define VectorNumber_Reserved108        107U
#define VectorNumber_Reserved107        106U
#define VectorNumber_Reserved106        105U
#define VectorNumber_Reserved105        104U
#define VectorNumber_Reserved104        103U
#define VectorNumber_Reserved103        102U
#define VectorNumber_Reserved102        101U
#define VectorNumber_Reserved101        100U
#define VectorNumber_Reserved100        99U
#define VectorNumber_Reserved99         98U
#define VectorNumber_Reserved98         97U
#define VectorNumber_Reserved97         96U
#define VectorNumber_Reserved96         95U
#define VectorNumber_Reserved95         94U
#define VectorNumber_Reserved94         93U
#define VectorNumber_Reserved93         92U
#define VectorNumber_Reserved92         91U
#define VectorNumber_Reserved91         90U
#define VectorNumber_Reserved90         89U
#define VectorNumber_Reserved89         88U
#define VectorNumber_Reserved88         87U
#define VectorNumber_Reserved87         86U
#define VectorNumber_Reserved86         85U
#define VectorNumber_Reserved85         84U
#define VectorNumber_Reserved84         83U
#define VectorNumber_Reserved83         82U
#define VectorNumber_Reserved82         81U
#define VectorNumber_Reserved81         80U
#define VectorNumber_Vxsramav           79U
#define VectorNumber_Vxsei              78U
#define VectorNumber_Vxst7              77U
#define VectorNumber_Vxst6              76U
#define VectorNumber_Vxst5              75U
#define VectorNumber_Vxst4              74U
#define VectorNumber_Vxst3              73U
#define VectorNumber_Vxst2              72U
#define VectorNumber_Vxst1              71U
#define VectorNumber_Vxst0              70U
#define VectorNumber_Vpit3              69U
#define VectorNumber_Vpit2              68U
#define VectorNumber_Vpit1              67U
#define VectorNumber_Vpit0              66U
#define VectorNumber_VReserved65        65U
#define VectorNumber_Vapi               64U
#define VectorNumber_Vlvi               63U
#define VectorNumber_Viic1              62U
#define VectorNumber_Vsci5              61U
#define VectorNumber_Vsci4              60U
#define VectorNumber_Vsci3              59U
#define VectorNumber_Vsci2              58U
#define VectorNumber_Vpwmesdn           57U
#define VectorNumber_Vportp             56U
#define VectorNumber_Vcan4tx            55U
#define VectorNumber_Vcan4rx            54U
#define VectorNumber_Vcan4err           53U
#define VectorNumber_Vcan4wkup          52U
#define VectorNumber_Vcan3tx            51U
#define VectorNumber_Vcan3rx            50U
#define VectorNumber_Vcan3err           49U
#define VectorNumber_Vcan3wkup          48U
#define VectorNumber_Vcan2tx            47U
#define VectorNumber_Vcan2rx            46U
#define VectorNumber_Vcan2err           45U
#define VectorNumber_Vcan2wkup          44U
#define VectorNumber_Vcan1tx            43U
#define VectorNumber_Vcan1rx            42U
#define VectorNumber_Vcan1err           41U
#define VectorNumber_Vcan1wkup          40U
#define VectorNumber_Vcan0tx            39U
#define VectorNumber_Vcan0rx            38U
#define VectorNumber_Vcan0err           37U
#define VectorNumber_Vcan0wkup          36U
#define VectorNumber_Vflash             35U
#define VectorNumber_Veeprom            34U
#define VectorNumber_Vspi2              33U
#define VectorNumber_Vspi1              32U
#define VectorNumber_Viic0              31U
#define VectorNumber_VReserved30        30U
#define VectorNumber_Vcrgscm            29U
#define VectorNumber_Vcrgplllck         28U
#define VectorNumber_Vtimpabovf         27U
#define VectorNumber_Vtimmdcu           26U
#define VectorNumber_Vporth             25U
#define VectorNumber_Vportj             24U
#define VectorNumber_Vatd1              23U
#define VectorNumber_Vatd0              22U
#define VectorNumber_Vsci1              21U
#define VectorNumber_Vsci0              20U
#define VectorNumber_Vspi0              19U
#define VectorNumber_Vtimpaie           18U
#define VectorNumber_Vtimpaaovf         17U
#define VectorNumber_Vtimovf            16U
#define VectorNumber_Vtimch7            15U
#define VectorNumber_Vtimch6            14U
#define VectorNumber_Vtimch5            13U
#define VectorNumber_Vtimch4            12U
#define VectorNumber_Vtimch3            11U
#define VectorNumber_Vtimch2            10U
#define VectorNumber_Vtimch1            9U
#define VectorNumber_Vtimch0            8U
#define VectorNumber_Vrti               7U
#define VectorNumber_Virq               6U
#define VectorNumber_Vxirq              5U
#define VectorNumber_Vswi               4U
#define VectorNumber_Vtrap              3U
#define VectorNumber_Vcop               2U
#define VectorNumber_Vclkmon            1U
#define VectorNumber_Vreset             0U

/**************** interrupt vector table ****************/
#define Vsi                             0xFF10U
#define Reserved119                     0xFF12U
#define Reserved118                     0xFF14U
#define Reserved117                     0xFF16U
#define Reserved116                     0xFF18U
#define Reserved115                     0xFF1AU
#define Reserved114                     0xFF1CU
#define Reserved113                     0xFF1EU
#define Reserved112                     0xFF20U
#define Reserved111                     0xFF22U
#define Reserved110                     0xFF24U
#define Reserved109                     0xFF26U
#define Reserved108                     0xFF28U
#define Reserved107                     0xFF2AU
#define Reserved106                     0xFF2CU
#define Reserved105                     0xFF2EU
#define Reserved104                     0xFF30U
#define Reserved103                     0xFF32U
#define Reserved102                     0xFF34U
#define Reserved101                     0xFF36U
#define Reserved100                     0xFF38U
#define Reserved99                      0xFF3AU
#define Reserved98                      0xFF3CU
#define Reserved97                      0xFF3EU
#define Reserved96                      0xFF40U
#define Reserved95                      0xFF42U
#define Reserved94                      0xFF44U
#define Reserved93                      0xFF46U
#define Reserved92                      0xFF48U
#define Reserved91                      0xFF4AU
#define Reserved90                      0xFF4CU
#define Reserved89                      0xFF4EU
#define Reserved88                      0xFF50U
#define Reserved87                      0xFF52U
#define Reserved86                      0xFF54U
#define Reserved85                      0xFF56U
#define Reserved84                      0xFF58U
#define Reserved83                      0xFF5AU
#define Reserved82                      0xFF5CU
#define Reserved81                      0xFF5EU
#define Vxsramav                        0xFF60U
#define Vxsei                           0xFF62U
#define Vxst7                           0xFF64U
#define Vxst6                           0xFF66U
#define Vxst5                           0xFF68U
#define Vxst4                           0xFF6AU
#define Vxst3                           0xFF6CU
#define Vxst2                           0xFF6EU
#define Vxst1                           0xFF70U
#define Vxst0                           0xFF72U
#define Vpit3                           0xFF74U
#define Vpit2                           0xFF76U
#define Vpit1                           0xFF78U
#define Vpit0                           0xFF7AU
#define VReserved65                     0xFF7CU
#define Vapi                            0xFF7EU
#define Vlvi                            0xFF80U
#define Viic1                           0xFF82U
#define Vsci5                           0xFF84U
#define Vsci4                           0xFF86U
#define Vsci3                           0xFF88U
#define Vsci2                           0xFF8AU
#define Vpwmesdn                        0xFF8CU
#define Vportp                          0xFF8EU
#define Vcan4tx                         0xFF90U
#define Vcan4rx                         0xFF92U
#define Vcan4err                        0xFF94U
#define Vcan4wkup                       0xFF96U
#define Vcan3tx                         0xFF98U
#define Vcan3rx                         0xFF9AU
#define Vcan3err                        0xFF9CU
#define Vcan3wkup                       0xFF9EU
#define Vcan2tx                         0xFFA0U
#define Vcan2rx                         0xFFA2U
#define Vcan2err                        0xFFA4U
#define Vcan2wkup                       0xFFA6U
#define Vcan1tx                         0xFFA8U
#define Vcan1rx                         0xFFAAU
#define Vcan1err                        0xFFACU
#define Vcan1wkup                       0xFFAEU
#define Vcan0tx                         0xFFB0U
#define Vcan0rx                         0xFFB2U
#define Vcan0err                        0xFFB4U
#define Vcan0wkup                       0xFFB6U
#define Vflash                          0xFFB8U
#define Veeprom                         0xFFBAU
#define Vspi2                           0xFFBCU
#define Vspi1                           0xFFBEU
#define Viic0                           0xFFC0U
#define VReserved30                     0xFFC2U
#define Vcrgscm                         0xFFC4U
#define Vcrgplllck                      0xFFC6U
#define Vtimpabovf                      0xFFC8U
#define Vtimmdcu                        0xFFCAU
#define Vporth                          0xFFCCU
#define Vportj                          0xFFCEU
#define Vatd1                           0xFFD0U
#define Vatd0                           0xFFD2U
#define Vsci1                           0xFFD4U
#define Vsci0                           0xFFD6U
#define Vspi0                           0xFFD8U
#define Vtimpaie                        0xFFDAU
#define Vtimpaaovf                      0xFFDCU
#define Vtimovf                         0xFFDEU
#define Vtimch7                         0xFFE0U
#define Vtimch6                         0xFFE2U
#define Vtimch5                         0xFFE4U
#define Vtimch4                         0xFFE6U
#define Vtimch3                         0xFFE8U
#define Vtimch2                         0xFFEAU
#define Vtimch1                         0xFFECU
#define Vtimch0                         0xFFEEU
#define Vrti                            0xFFF0U
#define Virq                            0xFFF2U
#define Vxirq                           0xFFF4U
#define Vswi                            0xFFF6U
#define Vtrap                           0xFFF8U
#define Vcop                            0xFFFAU
#define Vclkmon                         0xFFFCU
#define Vreset                          0xFFFEU

/**************** registers I/O map ****************/

/*** PORTAB - Port AB; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte PA0         :1;                                       /* Port A Bit 0 */
        byte PA1         :1;                                       /* Port A Bit 1 */
        byte PA2         :1;                                       /* Port A Bit 2 */
        byte PA3         :1;                                       /* Port A Bit 3 */
        byte PA4         :1;                                       /* Port A Bit 4 */
        byte PA5         :1;                                       /* Port A Bit 5 */
        byte PA6         :1;                                       /* Port A Bit 6 */
        byte PA7         :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_PA0                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA0
    #define PORTA_PA1                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA1
    #define PORTA_PA2                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA2
    #define PORTA_PA3                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA3
    #define PORTA_PA4                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA4
    #define PORTA_PA5                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA5
    #define PORTA_PA6                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA6
    #define PORTA_PA7                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA7
    
    #define PORTA_PA0_MASK              1U
    #define PORTA_PA1_MASK              2U
    #define PORTA_PA2_MASK              4U
    #define PORTA_PA3_MASK              8U
    #define PORTA_PA4_MASK              16U
    #define PORTA_PA5_MASK              32U
    #define PORTA_PA6_MASK              64U
    #define PORTA_PA7_MASK              128U
    

    /*** PORTB - Port B Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte PB0         :1;                                       /* Port B Bit 0 */
        byte PB1         :1;                                       /* Port B Bit 1 */
        byte PB2         :1;                                       /* Port B Bit 2 */
        byte PB3         :1;                                       /* Port B Bit 3 */
        byte PB4         :1;                                       /* Port B Bit 4 */
        byte PB5         :1;                                       /* Port B Bit 5 */
        byte PB6         :1;                                       /* Port B Bit 6 */
        byte PB7         :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_PB0                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB0
    #define PORTB_PB1                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB1
    #define PORTB_PB2                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB2
    #define PORTB_PB3                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB3
    #define PORTB_PB4                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB4
    #define PORTB_PB5                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB5
    #define PORTB_PB6                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB6
    #define PORTB_PB7                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB7
    
    #define PORTB_PB0_MASK              1U
    #define PORTB_PB1_MASK              2U
    #define PORTB_PB2_MASK              4U
    #define PORTB_PB3_MASK              8U
    #define PORTB_PB4_MASK              16U
    #define PORTB_PB5_MASK              32U
    #define PORTB_PB6_MASK              64U
    #define PORTB_PB7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PB0         :1;                                       /* Port B Bit 0 */
    word PB1         :1;                                       /* Port B Bit 1 */
    word PB2         :1;                                       /* Port B Bit 2 */
    word PB3         :1;                                       /* Port B Bit 3 */
    word PB4         :1;                                       /* Port B Bit 4 */
    word PB5         :1;                                       /* Port B Bit 5 */
    word PB6         :1;                                       /* Port B Bit 6 */
    word PB7         :1;                                       /* Port B Bit 7 */
    word PA0         :1;                                       /* Port A Bit 0 */
    word PA1         :1;                                       /* Port A Bit 1 */
    word PA2         :1;                                       /* Port A Bit 2 */
    word PA3         :1;                                       /* Port A Bit 3 */
    word PA4         :1;                                       /* Port A Bit 4 */
    word PA5         :1;                                       /* Port A Bit 5 */
    word PA6         :1;                                       /* Port A Bit 6 */
    word PA7         :1;                                       /* Port A Bit 7 */
  } Bits;
  struct {
    word grpPB   :8;
    word grpPA   :8;
  } MergedBits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000UL);
#define PORTAB                          _PORTAB.Word
#define PORTAB_PB0                      _PORTAB.Bits.PB0
#define PORTAB_PB1                      _PORTAB.Bits.PB1
#define PORTAB_PB2                      _PORTAB.Bits.PB2
#define PORTAB_PB3                      _PORTAB.Bits.PB3
#define PORTAB_PB4                      _PORTAB.Bits.PB4
#define PORTAB_PB5                      _PORTAB.Bits.PB5
#define PORTAB_PB6                      _PORTAB.Bits.PB6
#define PORTAB_PB7                      _PORTAB.Bits.PB7
#define PORTAB_PA0                      _PORTAB.Bits.PA0
#define PORTAB_PA1                      _PORTAB.Bits.PA1
#define PORTAB_PA2                      _PORTAB.Bits.PA2
#define PORTAB_PA3                      _PORTAB.Bits.PA3
#define PORTAB_PA4                      _PORTAB.Bits.PA4
#define PORTAB_PA5                      _PORTAB.Bits.PA5
#define PORTAB_PA6                      _PORTAB.Bits.PA6
#define PORTAB_PA7                      _PORTAB.Bits.PA7
#define PORTAB_PB                       _PORTAB.MergedBits.grpPB
#define PORTAB_PA                       _PORTAB.MergedBits.grpPA

#define PORTAB_PB0_MASK                 1U
#define PORTAB_PB1_MASK                 2U
#define PORTAB_PB2_MASK                 4U
#define PORTAB_PB3_MASK                 8U
#define PORTAB_PB4_MASK                 16U
#define PORTAB_PB5_MASK                 32U
#define PORTAB_PB6_MASK                 64U
#define PORTAB_PB7_MASK                 128U
#define PORTAB_PA0_MASK                 256U
#define PORTAB_PA1_MASK                 512U
#define PORTAB_PA2_MASK                 1024U
#define PORTAB_PA3_MASK                 2048U
#define PORTAB_PA4_MASK                 4096U
#define PORTAB_PA5_MASK                 8192U
#define PORTAB_PA6_MASK                 16384U
#define PORTAB_PA7_MASK                 32768U
#define PORTAB_PB_MASK                  255U
#define PORTAB_PB_BITNUM                0U
#define PORTAB_PA_MASK                  65280U
#define PORTAB_PA_BITNUM                8U


/*** DDRAB - Port AB Data Direction; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
        byte DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
        byte DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
        byte DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
        byte DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
        byte DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
        byte DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
        byte DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_DDRA0                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA0
    #define DDRA_DDRA1                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA1
    #define DDRA_DDRA2                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA2
    #define DDRA_DDRA3                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA3
    #define DDRA_DDRA4                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA4
    #define DDRA_DDRA5                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA5
    #define DDRA_DDRA6                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA6
    #define DDRA_DDRA7                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA7
    
    #define DDRA_DDRA0_MASK             1U
    #define DDRA_DDRA1_MASK             2U
    #define DDRA_DDRA2_MASK             4U
    #define DDRA_DDRA3_MASK             8U
    #define DDRA_DDRA4_MASK             16U
    #define DDRA_DDRA5_MASK             32U
    #define DDRA_DDRA6_MASK             64U
    #define DDRA_DDRA7_MASK             128U
    

    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
        byte DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
        byte DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
        byte DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
        byte DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
        byte DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
        byte DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
        byte DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_DDRB0                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB0
    #define DDRB_DDRB1                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB1
    #define DDRB_DDRB2                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB2
    #define DDRB_DDRB3                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB3
    #define DDRB_DDRB4                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB4
    #define DDRB_DDRB5                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB5
    #define DDRB_DDRB6                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB6
    #define DDRB_DDRB7                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB7
    
    #define DDRB_DDRB0_MASK             1U
    #define DDRB_DDRB1_MASK             2U
    #define DDRB_DDRB2_MASK             4U
    #define DDRB_DDRB3_MASK             8U
    #define DDRB_DDRB4_MASK             16U
    #define DDRB_DDRB5_MASK             32U
    #define DDRB_DDRB6_MASK             64U
    #define DDRB_DDRB7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
    word DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
    word DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
    word DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
    word DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
    word DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
    word DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
    word DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
    word DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
    word DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
    word DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
    word DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
    word DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
    word DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
    word DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
    word DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
  struct {
    word grpDDRB :8;
    word grpDDRA :8;
  } MergedBits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002UL);
#define DDRAB                           _DDRAB.Word
#define DDRAB_DDRB0                     _DDRAB.Bits.DDRB0
#define DDRAB_DDRB1                     _DDRAB.Bits.DDRB1
#define DDRAB_DDRB2                     _DDRAB.Bits.DDRB2
#define DDRAB_DDRB3                     _DDRAB.Bits.DDRB3
#define DDRAB_DDRB4                     _DDRAB.Bits.DDRB4
#define DDRAB_DDRB5                     _DDRAB.Bits.DDRB5
#define DDRAB_DDRB6                     _DDRAB.Bits.DDRB6
#define DDRAB_DDRB7                     _DDRAB.Bits.DDRB7
#define DDRAB_DDRA0                     _DDRAB.Bits.DDRA0
#define DDRAB_DDRA1                     _DDRAB.Bits.DDRA1
#define DDRAB_DDRA2                     _DDRAB.Bits.DDRA2
#define DDRAB_DDRA3                     _DDRAB.Bits.DDRA3
#define DDRAB_DDRA4                     _DDRAB.Bits.DDRA4
#define DDRAB_DDRA5                     _DDRAB.Bits.DDRA5
#define DDRAB_DDRA6                     _DDRAB.Bits.DDRA6
#define DDRAB_DDRA7                     _DDRAB.Bits.DDRA7
#define DDRAB_DDRB                      _DDRAB.MergedBits.grpDDRB
#define DDRAB_DDRA                      _DDRAB.MergedBits.grpDDRA

#define DDRAB_DDRB0_MASK                1U
#define DDRAB_DDRB1_MASK                2U
#define DDRAB_DDRB2_MASK                4U
#define DDRAB_DDRB3_MASK                8U
#define DDRAB_DDRB4_MASK                16U
#define DDRAB_DDRB5_MASK                32U
#define DDRAB_DDRB6_MASK                64U
#define DDRAB_DDRB7_MASK                128U
#define DDRAB_DDRA0_MASK                256U
#define DDRAB_DDRA1_MASK                512U
#define DDRAB_DDRA2_MASK                1024U
#define DDRAB_DDRA3_MASK                2048U
#define DDRAB_DDRA4_MASK                4096U
#define DDRAB_DDRA5_MASK                8192U
#define DDRAB_DDRA6_MASK                16384U
#define DDRAB_DDRA7_MASK                32768U
#define DDRAB_DDRB_MASK                 255U
#define DDRAB_DDRB_BITNUM               0U
#define DDRAB_DDRA_MASK                 65280U
#define DDRAB_DDRA_BITNUM               8U


/*** PORTCD - Port CD; 0x00000004 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTC - Port C Register; 0x00000004 ***/
    union {
      byte Byte;
      struct {
        byte PC0         :1;                                       /* Port C Bit 0 */
        byte PC1         :1;                                       /* Port C Bit 1 */
        byte PC2         :1;                                       /* Port C Bit 2 */
        byte PC3         :1;                                       /* Port C Bit 3 */
        byte PC4         :1;                                       /* Port C Bit 4 */
        byte PC5         :1;                                       /* Port C Bit 5 */
        byte PC6         :1;                                       /* Port C Bit 6 */
        byte PC7         :1;                                       /* Port C Bit 7 */
      } Bits;
    } PORTCSTR;
    #define PORTC                       _PORTCD.Overlap_STR.PORTCSTR.Byte
    #define PORTC_PC0                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC0
    #define PORTC_PC1                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC1
    #define PORTC_PC2                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC2
    #define PORTC_PC3                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC3
    #define PORTC_PC4                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC4
    #define PORTC_PC5                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC5
    #define PORTC_PC6                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC6
    #define PORTC_PC7                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC7
    
    #define PORTC_PC0_MASK              1U
    #define PORTC_PC1_MASK              2U
    #define PORTC_PC2_MASK              4U
    #define PORTC_PC3_MASK              8U
    #define PORTC_PC4_MASK              16U
    #define PORTC_PC5_MASK              32U
    #define PORTC_PC6_MASK              64U
    #define PORTC_PC7_MASK              128U
    

    /*** PORTD - Port D Register; 0x00000005 ***/
    union {
      byte Byte;
      struct {
        byte PD0         :1;                                       /* Port D Bit 0 */
        byte PD1         :1;                                       /* Port D Bit 1 */
        byte PD2         :1;                                       /* Port D Bit 2 */
        byte PD3         :1;                                       /* Port D Bit 3 */
        byte PD4         :1;                                       /* Port D Bit 4 */
        byte PD5         :1;                                       /* Port D Bit 5 */
        byte PD6         :1;                                       /* Port D Bit 6 */
        byte PD7         :1;                                       /* Port D Bit 7 */
      } Bits;
    } PORTDSTR;
    #define PORTD                       _PORTCD.Overlap_STR.PORTDSTR.Byte
    #define PORTD_PD0                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD0
    #define PORTD_PD1                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD1
    #define PORTD_PD2                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD2
    #define PORTD_PD3                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD3
    #define PORTD_PD4                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD4
    #define PORTD_PD5                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD5
    #define PORTD_PD6                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD6
    #define PORTD_PD7                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD7
    
    #define PORTD_PD0_MASK              1U
    #define PORTD_PD1_MASK              2U
    #define PORTD_PD2_MASK              4U
    #define PORTD_PD3_MASK              8U
    #define PORTD_PD4_MASK              16U
    #define PORTD_PD5_MASK              32U
    #define PORTD_PD6_MASK              64U
    #define PORTD_PD7_MASK              128U
    
  } Overlap_STR;

  struct {
    word PD0         :1;                                       /* Port D Bit 0 */
    word PD1         :1;                                       /* Port D Bit 1 */
    word PD2         :1;                                       /* Port D Bit 2 */
    word PD3         :1;                                       /* Port D Bit 3 */
    word PD4         :1;                                       /* Port D Bit 4 */
    word PD5         :1;                                       /* Port D Bit 5 */
    word PD6         :1;                                       /* Port D Bit 6 */
    word PD7         :1;                                       /* Port D Bit 7 */
    word PC0         :1;                                       /* Port C Bit 0 */
    word PC1         :1;                                       /* Port C Bit 1 */
    word PC2         :1;                                       /* Port C Bit 2 */
    word PC3         :1;                                       /* Port C Bit 3 */
    word PC4         :1;                                       /* Port C Bit 4 */
    word PC5         :1;                                       /* Port C Bit 5 */
    word PC6         :1;                                       /* Port C Bit 6 */
    word PC7         :1;                                       /* Port C Bit 7 */
  } Bits;
  struct {
    word grpPD   :8;
    word grpPC   :8;
  } MergedBits;
} PORTCDSTR;
extern volatile PORTCDSTR _PORTCD @(REG_BASE + 0x00000004UL);
#define PORTCD                          _PORTCD.Word
#define PORTCD_PD0                      _PORTCD.Bits.PD0
#define PORTCD_PD1                      _PORTCD.Bits.PD1
#define PORTCD_PD2                      _PORTCD.Bits.PD2
#define PORTCD_PD3                      _PORTCD.Bits.PD3
#define PORTCD_PD4                      _PORTCD.Bits.PD4
#define PORTCD_PD5                      _PORTCD.Bits.PD5
#define PORTCD_PD6                      _PORTCD.Bits.PD6
#define PORTCD_PD7                      _PORTCD.Bits.PD7
#define PORTCD_PC0                      _PORTCD.Bits.PC0
#define PORTCD_PC1                      _PORTCD.Bits.PC1
#define PORTCD_PC2                      _PORTCD.Bits.PC2
#define PORTCD_PC3                      _PORTCD.Bits.PC3
#define PORTCD_PC4                      _PORTCD.Bits.PC4
#define PORTCD_PC5                      _PORTCD.Bits.PC5
#define PORTCD_PC6                      _PORTCD.Bits.PC6
#define PORTCD_PC7                      _PORTCD.Bits.PC7
#define PORTCD_PD                       _PORTCD.MergedBits.grpPD
#define PORTCD_PC                       _PORTCD.MergedBits.grpPC

#define PORTCD_PD0_MASK                 1U
#define PORTCD_PD1_MASK                 2U
#define PORTCD_PD2_MASK                 4U
#define PORTCD_PD3_MASK                 8U
#define PORTCD_PD4_MASK                 16U
#define PORTCD_PD5_MASK                 32U
#define PORTCD_PD6_MASK                 64U
#define PORTCD_PD7_MASK                 128U
#define PORTCD_PC0_MASK                 256U
#define PORTCD_PC1_MASK                 512U
#define PORTCD_PC2_MASK                 1024U
#define PORTCD_PC3_MASK                 2048U
#define PORTCD_PC4_MASK                 4096U
#define PORTCD_PC5_MASK                 8192U
#define PORTCD_PC6_MASK                 16384U
#define PORTCD_PC7_MASK                 32768U
#define PORTCD_PD_MASK                  255U
#define PORTCD_PD_BITNUM                0U
#define PORTCD_PC_MASK                  65280U
#define PORTCD_PC_BITNUM                8U


/*** DDRCD - Port CD Data Direction; 0x00000006 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRC - Port C Data Direction Register; 0x00000006 ***/
    union {
      byte Byte;
      struct {
        byte DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
        byte DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
        byte DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
        byte DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
        byte DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
        byte DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
        byte DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
        byte DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
      } Bits;
    } DDRCSTR;
    #define DDRC                        _DDRCD.Overlap_STR.DDRCSTR.Byte
    #define DDRC_DDRC0                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC0
    #define DDRC_DDRC1                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC1
    #define DDRC_DDRC2                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC2
    #define DDRC_DDRC3                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC3
    #define DDRC_DDRC4                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC4
    #define DDRC_DDRC5                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC5
    #define DDRC_DDRC6                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC6
    #define DDRC_DDRC7                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC7
    
    #define DDRC_DDRC0_MASK             1U
    #define DDRC_DDRC1_MASK             2U
    #define DDRC_DDRC2_MASK             4U
    #define DDRC_DDRC3_MASK             8U
    #define DDRC_DDRC4_MASK             16U
    #define DDRC_DDRC5_MASK             32U
    #define DDRC_DDRC6_MASK             64U
    #define DDRC_DDRC7_MASK             128U
    

    /*** DDRD - Port D Data Direction Register; 0x00000007 ***/
    union {
      byte Byte;
      struct {
        byte DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
        byte DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
        byte DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
        byte DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
        byte DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
        byte DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
        byte DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
        byte DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
      } Bits;
    } DDRDSTR;
    #define DDRD                        _DDRCD.Overlap_STR.DDRDSTR.Byte
    #define DDRD_DDRD0                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD0
    #define DDRD_DDRD1                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD1
    #define DDRD_DDRD2                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD2
    #define DDRD_DDRD3                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD3
    #define DDRD_DDRD4                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD4
    #define DDRD_DDRD5                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD5
    #define DDRD_DDRD6                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD6
    #define DDRD_DDRD7                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD7
    
    #define DDRD_DDRD0_MASK             1U
    #define DDRD_DDRD1_MASK             2U
    #define DDRD_DDRD2_MASK             4U
    #define DDRD_DDRD3_MASK             8U
    #define DDRD_DDRD4_MASK             16U
    #define DDRD_DDRD5_MASK             32U
    #define DDRD_DDRD6_MASK             64U
    #define DDRD_DDRD7_MASK             128U
    
  } Overlap_STR;

  struct {
    word DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
    word DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
    word DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
    word DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
    word DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
    word DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
    word DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
    word DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
    word DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
    word DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
    word DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
    word DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
    word DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
    word DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
    word DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
    word DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
  } Bits;
  struct {
    word grpDDRD :8;
    word grpDDRC :8;
  } MergedBits;
} DDRCDSTR;
extern volatile DDRCDSTR _DDRCD @(REG_BASE + 0x00000006UL);
#define DDRCD                           _DDRCD.Word
#define DDRCD_DDRD0                     _DDRCD.Bits.DDRD0
#define DDRCD_DDRD1                     _DDRCD.Bits.DDRD1
#define DDRCD_DDRD2                     _DDRCD.Bits.DDRD2
#define DDRCD_DDRD3                     _DDRCD.Bits.DDRD3
#define DDRCD_DDRD4                     _DDRCD.Bits.DDRD4
#define DDRCD_DDRD5                     _DDRCD.Bits.DDRD5
#define DDRCD_DDRD6                     _DDRCD.Bits.DDRD6
#define DDRCD_DDRD7                     _DDRCD.Bits.DDRD7
#define DDRCD_DDRC0                     _DDRCD.Bits.DDRC0
#define DDRCD_DDRC1                     _DDRCD.Bits.DDRC1
#define DDRCD_DDRC2                     _DDRCD.Bits.DDRC2
#define DDRCD_DDRC3                     _DDRCD.Bits.DDRC3
#define DDRCD_DDRC4                     _DDRCD.Bits.DDRC4
#define DDRCD_DDRC5                     _DDRCD.Bits.DDRC5
#define DDRCD_DDRC6                     _DDRCD.Bits.DDRC6
#define DDRCD_DDRC7                     _DDRCD.Bits.DDRC7
#define DDRCD_DDRD                      _DDRCD.MergedBits.grpDDRD
#define DDRCD_DDRC                      _DDRCD.MergedBits.grpDDRC

#define DDRCD_DDRD0_MASK                1U
#define DDRCD_DDRD1_MASK                2U
#define DDRCD_DDRD2_MASK                4U
#define DDRCD_DDRD3_MASK                8U
#define DDRCD_DDRD4_MASK                16U
#define DDRCD_DDRD5_MASK                32U
#define DDRCD_DDRD6_MASK                64U
#define DDRCD_DDRD7_MASK                128U
#define DDRCD_DDRC0_MASK                256U
#define DDRCD_DDRC1_MASK                512U
#define DDRCD_DDRC2_MASK                1024U
#define DDRCD_DDRC3_MASK                2048U
#define DDRCD_DDRC4_MASK                4096U
#define DDRCD_DDRC5_MASK                8192U
#define DDRCD_DDRC6_MASK                16384U
#define DDRCD_DDRC7_MASK                32768U
#define DDRCD_DDRD_MASK                 255U
#define DDRCD_DDRD_BITNUM               0U
#define DDRCD_DDRC_MASK                 65280U
#define DDRCD_DDRC_BITNUM               8U


/*** PORTE - Port E Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Port E Bit 0 */
    byte PE1         :1;                                       /* Port E Bit 1 */
    byte PE2         :1;                                       /* Port E Bit 2 */
    byte PE3         :1;                                       /* Port E Bit 3 */
    byte PE4         :1;                                       /* Port E Bit 4 */
    byte PE5         :1;                                       /* Port E Bit 5 */
    byte PE6         :1;                                       /* Port E Bit 6 */
    byte PE7         :1;                                       /* Port E Bit 7 */
  } Bits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008UL);
#define PORTE                           _PORTE.Byte
#define PORTE_PE0                       _PORTE.Bits.PE0
#define PORTE_PE1                       _PORTE.Bits.PE1
#define PORTE_PE2                       _PORTE.Bits.PE2
#define PORTE_PE3                       _PORTE.Bits.PE3
#define PORTE_PE4                       _PORTE.Bits.PE4
#define PORTE_PE5                       _PORTE.Bits.PE5
#define PORTE_PE6                       _PORTE.Bits.PE6
#define PORTE_PE7                       _PORTE.Bits.PE7

#define PORTE_PE0_MASK                  1U
#define PORTE_PE1_MASK                  2U
#define PORTE_PE2_MASK                  4U
#define PORTE_PE3_MASK                  8U
#define PORTE_PE4_MASK                  16U
#define PORTE_PE5_MASK                  32U
#define PORTE_PE6_MASK                  64U
#define PORTE_PE7_MASK                  128U


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte DDRE2       :1;                                       /* Data Direction Port E Bit 2 */
    byte DDRE3       :1;                                       /* Data Direction Port E Bit 3 */
    byte DDRE4       :1;                                       /* Data Direction Port E Bit 4 */
    byte DDRE5       :1;                                       /* Data Direction Port E Bit 5 */
    byte DDRE6       :1;                                       /* Data Direction Port E Bit 6 */
    byte DDRE7       :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpDDRE_2 :6;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009UL);
#define DDRE                            _DDRE.Byte
#define DDRE_DDRE2                      _DDRE.Bits.DDRE2
#define DDRE_DDRE3                      _DDRE.Bits.DDRE3
#define DDRE_DDRE4                      _DDRE.Bits.DDRE4
#define DDRE_DDRE5                      _DDRE.Bits.DDRE5
#define DDRE_DDRE6                      _DDRE.Bits.DDRE6
#define DDRE_DDRE7                      _DDRE.Bits.DDRE7
#define DDRE_DDRE_2                     _DDRE.MergedBits.grpDDRE_2

#define DDRE_DDRE2_MASK                 4U
#define DDRE_DDRE3_MASK                 8U
#define DDRE_DDRE4_MASK                 16U
#define DDRE_DDRE5_MASK                 32U
#define DDRE_DDRE6_MASK                 64U
#define DDRE_DDRE7_MASK                 128U
#define DDRE_DDRE_2_MASK                252U
#define DDRE_DDRE_2_BITNUM              2U


/*** MMCCTL0 - S12X_MMC Control Register 0; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte CS0E        :1;                                       /* Chip Select Enable 0 */
    byte CS1E        :1;                                       /* Chip Select Enable 1 */
    byte CS2E        :1;                                       /* Chip Select Enable 2 */
    byte CS3E        :1;                                       /* Chip Select Enable 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MMCCTL0STR;
extern volatile MMCCTL0STR _MMCCTL0 @(REG_BASE + 0x0000000AUL);
#define MMCCTL0                         _MMCCTL0.Byte
#define MMCCTL0_CS0E                    _MMCCTL0.Bits.CS0E
#define MMCCTL0_CS1E                    _MMCCTL0.Bits.CS1E
#define MMCCTL0_CS2E                    _MMCCTL0.Bits.CS2E
#define MMCCTL0_CS3E                    _MMCCTL0.Bits.CS3E

#define MMCCTL0_CS0E_MASK               1U
#define MMCCTL0_CS1E_MASK               2U
#define MMCCTL0_CS2E_MASK               4U
#define MMCCTL0_CS3E_MASK               8U


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit A */
    byte MODB        :1;                                       /* Mode Select Bit B */
    byte MODC        :1;                                       /* Mode Select Bit C */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000BUL);
#define MODE                            _MODE.Byte
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_MODA_MASK                  32U
#define MODE_MODB_MASK                  64U
#define MODE_MODC_MASK                  128U
#define MODE_MODx_MASK                  224U
#define MODE_MODx_BITNUM                5U


/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-Up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-Up Port B Enable */
    byte PUPCE       :1;                                       /* Pull-Up Port C Enable */
    byte PUPDE       :1;                                       /* Pull-Up Port D Enable */
    byte PUPEE       :1;                                       /* Pull-Up Port E Enable */
    byte             :1; 
    byte BKPUE       :1;                                       /* BKGD and VREGEN Pin Pull-up Enable */
    byte PUPKE       :1;                                       /* Pull-Up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000CUL);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPCE                      _PUCR.Bits.PUPCE
#define PUCR_PUPDE                      _PUCR.Bits.PUPDE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_BKPUE                      _PUCR.Bits.BKPUE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1U
#define PUCR_PUPBE_MASK                 2U
#define PUCR_PUPCE_MASK                 4U
#define PUCR_PUPDE_MASK                 8U
#define PUCR_PUPEE_MASK                 16U
#define PUCR_BKPUE_MASK                 64U
#define PUCR_PUPKE_MASK                 128U


/*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte RDPC        :1;                                       /* Reduced Drive of Port C */
    byte RDPD        :1;                                       /* Reduced Drive of Port D */
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000DUL);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPC                      _RDRIV.Bits.RDPC
#define RDRIV_RDPD                      _RDRIV.Bits.RDPD
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1U
#define RDRIV_RDPB_MASK                 2U
#define RDRIV_RDPC_MASK                 4U
#define RDRIV_RDPD_MASK                 8U
#define RDRIV_RDPE_MASK                 16U
#define RDRIV_RDPK_MASK                 128U
#define RDRIV_RDPx_MASK                 31U
#define RDRIV_RDPx_BITNUM               0U


/*** EBICTL0 - External Bus Interface Control Register 0; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte ASIZ0       :1;                                       /* External Address Bus Size Bit 0 */
    byte ASIZ1       :1;                                       /* External Address Bus Size Bit 1 */
    byte ASIZ2       :1;                                       /* External Address Bus Size Bit 2 */
    byte ASIZ3       :1;                                       /* External Address Bus Size Bit 3 */
    byte ASIZ4       :1;                                       /* External Address Bus Size Bit 4 */
    byte HDBE        :1;                                       /* High Data Byte Enable */
    byte             :1; 
    byte ITHRS       :1;                                       /* Reduced Input Threshold */
  } Bits;
  struct {
    byte grpASIZ :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} EBICTL0STR;
extern volatile EBICTL0STR _EBICTL0 @(REG_BASE + 0x0000000EUL);
#define EBICTL0                         _EBICTL0.Byte
#define EBICTL0_ASIZ0                   _EBICTL0.Bits.ASIZ0
#define EBICTL0_ASIZ1                   _EBICTL0.Bits.ASIZ1
#define EBICTL0_ASIZ2                   _EBICTL0.Bits.ASIZ2
#define EBICTL0_ASIZ3                   _EBICTL0.Bits.ASIZ3
#define EBICTL0_ASIZ4                   _EBICTL0.Bits.ASIZ4
#define EBICTL0_HDBE                    _EBICTL0.Bits.HDBE
#define EBICTL0_ITHRS                   _EBICTL0.Bits.ITHRS
/* EBICTL_ARR: Access 2 EBICTLx registers in an array */
#define EBICTL_ARR                      ((volatile byte *) &EBICTL0)
#define EBICTL0_ASIZ                    _EBICTL0.MergedBits.grpASIZ

#define EBICTL0_ASIZ0_MASK              1U
#define EBICTL0_ASIZ1_MASK              2U
#define EBICTL0_ASIZ2_MASK              4U
#define EBICTL0_ASIZ3_MASK              8U
#define EBICTL0_ASIZ4_MASK              16U
#define EBICTL0_HDBE_MASK               32U
#define EBICTL0_ITHRS_MASK              128U
#define EBICTL0_ASIZ_MASK               31U
#define EBICTL0_ASIZ_BITNUM             0U


/*** EBICTL1 - External Bus Interface Control Register 1; 0x0000000F ***/
typedef union {
  byte Byte;
  struct {
    byte EXSTR0      :1;                                       /* External Access Stretch Bit 0 */
    byte EXSTR1      :1;                                       /* External Access Stretch Bit 1 */
    byte EXSTR2      :1;                                       /* External Access Stretch Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte EWAITE      :1;                                       /* External Wait Enable */
  } Bits;
  struct {
    byte grpEXSTR :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} EBICTL1STR;
extern volatile EBICTL1STR _EBICTL1 @(REG_BASE + 0x0000000FUL);
#define EBICTL1                         _EBICTL1.Byte
#define EBICTL1_EXSTR0                  _EBICTL1.Bits.EXSTR0
#define EBICTL1_EXSTR1                  _EBICTL1.Bits.EXSTR1
#define EBICTL1_EXSTR2                  _EBICTL1.Bits.EXSTR2
#define EBICTL1_EWAITE                  _EBICTL1.Bits.EWAITE
#define EBICTL1_EXSTR                   _EBICTL1.MergedBits.grpEXSTR

#define EBICTL1_EXSTR0_MASK             1U
#define EBICTL1_EXSTR1_MASK             2U
#define EBICTL1_EXSTR2_MASK             4U
#define EBICTL1_EWAITE_MASK             128U
#define EBICTL1_EXSTR_MASK              7U
#define EBICTL1_EXSTR_BITNUM            0U


/*** GPAGE - Global Page Index Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte GP0         :1;                                       /* Global Page Index Bit 0 */
    byte GP1         :1;                                       /* Global Page Index Bit 1 */
    byte GP2         :1;                                       /* Global Page Index Bit 2 */
    byte GP3         :1;                                       /* Global Page Index Bit 3 */
    byte GP4         :1;                                       /* Global Page Index Bit 4 */
    byte GP5         :1;                                       /* Global Page Index Bit 5 */
    byte GP6         :1;                                       /* Global Page Index Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpGP   :7;
    byte         :1;
  } MergedBits;
} GPAGESTR;
extern volatile GPAGESTR _GPAGE @(REG_BASE + 0x00000010UL);
#define GPAGE                           _GPAGE.Byte
#define GPAGE_GP0                       _GPAGE.Bits.GP0
#define GPAGE_GP1                       _GPAGE.Bits.GP1
#define GPAGE_GP2                       _GPAGE.Bits.GP2
#define GPAGE_GP3                       _GPAGE.Bits.GP3
#define GPAGE_GP4                       _GPAGE.Bits.GP4
#define GPAGE_GP5                       _GPAGE.Bits.GP5
#define GPAGE_GP6                       _GPAGE.Bits.GP6
#define GPAGE_GP                        _GPAGE.MergedBits.grpGP

#define GPAGE_GP0_MASK                  1U
#define GPAGE_GP1_MASK                  2U
#define GPAGE_GP2_MASK                  4U
#define GPAGE_GP3_MASK                  8U
#define GPAGE_GP4_MASK                  16U
#define GPAGE_GP5_MASK                  32U
#define GPAGE_GP6_MASK                  64U
#define GPAGE_GP_MASK                   127U
#define GPAGE_GP_BITNUM                 0U


/*** DIRECT - Direct Page Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Bit 8 */
    byte DP9         :1;                                       /* Direct Page Bit 9 */
    byte DP10        :1;                                       /* Direct Page Bit 10 */
    byte DP11        :1;                                       /* Direct Page Bit 11 */
    byte DP12        :1;                                       /* Direct Page Bit 12 */
    byte DP13        :1;                                       /* Direct Page Bit 13 */
    byte DP14        :1;                                       /* Direct Page Bit 14 */
    byte DP15        :1;                                       /* Direct Page Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000011UL);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1U
#define DIRECT_DP9_MASK                 2U
#define DIRECT_DP10_MASK                4U
#define DIRECT_DP11_MASK                8U
#define DIRECT_DP12_MASK                16U
#define DIRECT_DP13_MASK                32U
#define DIRECT_DP14_MASK                64U
#define DIRECT_DP15_MASK                128U


/*** MMCCTL1 - S12X_MMC Control Register 1; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable FLASH or ROM in the memory map */
    byte ROMHM       :1;                                       /* FLASH or ROM only in higher Half of Memory Map */
    byte EROMON      :1;                                       /* Enables emulated FLASH or ROM memory in the memory map. */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} MMCCTL1STR;
extern volatile MMCCTL1STR _MMCCTL1 @(REG_BASE + 0x00000013UL);
#define MMCCTL1                         _MMCCTL1.Byte
#define MMCCTL1_ROMON                   _MMCCTL1.Bits.ROMON
#define MMCCTL1_ROMHM                   _MMCCTL1.Bits.ROMHM
#define MMCCTL1_EROMON                  _MMCCTL1.Bits.EROMON

#define MMCCTL1_ROMON_MASK              1U
#define MMCCTL1_ROMHM_MASK              2U
#define MMCCTL1_EROMON_MASK             4U


/*** RPAGE - RAM Page Index Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte RP0         :1;                                       /* RAM Page Index Bit 0 */
    byte RP1         :1;                                       /* RAM Page Index Bit 1 */
    byte RP2         :1;                                       /* RAM Page Index Bit 2 */
    byte RP3         :1;                                       /* RAM Page Index Bit 3 */
    byte RP4         :1;                                       /* RAM Page Index Bit 4 */
    byte RP5         :1;                                       /* RAM Page Index Bit 5 */
    byte RP6         :1;                                       /* RAM Page Index Bit 6 */
    byte RP7         :1;                                       /* RAM Page Index Bit 7 */
  } Bits;
} RPAGESTR;
extern volatile RPAGESTR _RPAGE @(REG_BASE + 0x00000016UL);
#define RPAGE                           _RPAGE.Byte
#define RPAGE_RP0                       _RPAGE.Bits.RP0
#define RPAGE_RP1                       _RPAGE.Bits.RP1
#define RPAGE_RP2                       _RPAGE.Bits.RP2
#define RPAGE_RP3                       _RPAGE.Bits.RP3
#define RPAGE_RP4                       _RPAGE.Bits.RP4
#define RPAGE_RP5                       _RPAGE.Bits.RP5
#define RPAGE_RP6                       _RPAGE.Bits.RP6
#define RPAGE_RP7                       _RPAGE.Bits.RP7

#define RPAGE_RP0_MASK                  1U
#define RPAGE_RP1_MASK                  2U
#define RPAGE_RP2_MASK                  4U
#define RPAGE_RP3_MASK                  8U
#define RPAGE_RP4_MASK                  16U
#define RPAGE_RP5_MASK                  32U
#define RPAGE_RP6_MASK                  64U
#define RPAGE_RP7_MASK                  128U


/*** EPAGE - EEPROM Page Index Register; 0x00000017 ***/
typedef union {
  byte Byte;
  struct {
    byte EP0         :1;                                       /* EEPROM Page Index Bit 0 */
    byte EP1         :1;                                       /* EEPROM Page Index Bit 1 */
    byte EP2         :1;                                       /* EEPROM Page Index Bit 2 */
    byte EP3         :1;                                       /* EEPROM Page Index Bit 3 */
    byte EP4         :1;                                       /* EEPROM Page Index Bit 4 */
    byte EP5         :1;                                       /* EEPROM Page Index Bit 5 */
    byte EP6         :1;                                       /* EEPROM Page Index Bit 6 */
    byte EP7         :1;                                       /* EEPROM Page Index Bit 7 */
  } Bits;
} EPAGESTR;
extern volatile EPAGESTR _EPAGE @(REG_BASE + 0x00000017UL);
#define EPAGE                           _EPAGE.Byte
#define EPAGE_EP0                       _EPAGE.Bits.EP0
#define EPAGE_EP1                       _EPAGE.Bits.EP1
#define EPAGE_EP2                       _EPAGE.Bits.EP2
#define EPAGE_EP3                       _EPAGE.Bits.EP3
#define EPAGE_EP4                       _EPAGE.Bits.EP4
#define EPAGE_EP5                       _EPAGE.Bits.EP5
#define EPAGE_EP6                       _EPAGE.Bits.EP6
#define EPAGE_EP7                       _EPAGE.Bits.EP7

#define EPAGE_EP0_MASK                  1U
#define EPAGE_EP1_MASK                  2U
#define EPAGE_EP2_MASK                  4U
#define EPAGE_EP3_MASK                  8U
#define EPAGE_EP4_MASK                  16U
#define EPAGE_EP5_MASK                  32U
#define EPAGE_EP6_MASK                  64U
#define EPAGE_EP7_MASK                  128U


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    #define PARTIDH_ID8_MASK            1U
    #define PARTIDH_ID9_MASK            2U
    #define PARTIDH_ID10_MASK           4U
    #define PARTIDH_ID11_MASK           8U
    #define PARTIDH_ID12_MASK           16U
    #define PARTIDH_ID13_MASK           32U
    #define PARTIDH_ID14_MASK           64U
    #define PARTIDH_ID15_MASK           128U
    

    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    #define PARTIDL_ID0_MASK            1U
    #define PARTIDL_ID1_MASK            2U
    #define PARTIDL_ID2_MASK            4U
    #define PARTIDL_ID3_MASK            8U
    #define PARTIDL_ID4_MASK            16U
    #define PARTIDL_ID5_MASK            32U
    #define PARTIDL_ID6_MASK            64U
    #define PARTIDL_ID7_MASK            128U
    
  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001AUL);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1U
#define PARTID_ID1_MASK                 2U
#define PARTID_ID2_MASK                 4U
#define PARTID_ID3_MASK                 8U
#define PARTID_ID4_MASK                 16U
#define PARTID_ID5_MASK                 32U
#define PARTID_ID6_MASK                 64U
#define PARTID_ID7_MASK                 128U
#define PARTID_ID8_MASK                 256U
#define PARTID_ID9_MASK                 512U
#define PARTID_ID10_MASK                1024U
#define PARTID_ID11_MASK                2048U
#define PARTID_ID12_MASK                4096U
#define PARTID_ID13_MASK                8192U
#define PARTID_ID14_MASK                16384U
#define PARTID_ID15_MASK                32768U


/*** ECLKCTL - ECLK Control Register; 0x0000001C ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* Free-running ECLK Divider Bit 0 */
    byte EDIV1       :1;                                       /* Free-running ECLK Divider Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte NCLKX2      :1;                                       /* No ECLKX2 */
    byte NECLK       :1;                                       /* No ECLK */
  } Bits;
  struct {
    byte grpEDIV :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpNCLKX_2 :1;
    byte         :1;
  } MergedBits;
} ECLKCTLSTR;
extern volatile ECLKCTLSTR _ECLKCTL @(REG_BASE + 0x0000001CUL);
#define ECLKCTL                         _ECLKCTL.Byte
#define ECLKCTL_EDIV0                   _ECLKCTL.Bits.EDIV0
#define ECLKCTL_EDIV1                   _ECLKCTL.Bits.EDIV1
#define ECLKCTL_NCLKX2                  _ECLKCTL.Bits.NCLKX2
#define ECLKCTL_NECLK                   _ECLKCTL.Bits.NECLK
#define ECLKCTL_EDIV                    _ECLKCTL.MergedBits.grpEDIV

#define ECLKCTL_EDIV0_MASK              1U
#define ECLKCTL_EDIV1_MASK              2U
#define ECLKCTL_NCLKX2_MASK             64U
#define ECLKCTL_NECLK_MASK              128U
#define ECLKCTL_EDIV_MASK               3U
#define ECLKCTL_EDIV_BITNUM             0U


/*** IRQCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} IRQCRSTR;
extern volatile IRQCRSTR _IRQCR @(REG_BASE + 0x0000001EUL);
#define IRQCR                           _IRQCR.Byte
#define IRQCR_IRQEN                     _IRQCR.Bits.IRQEN
#define IRQCR_IRQE                      _IRQCR.Bits.IRQE

#define IRQCR_IRQEN_MASK                64U
#define IRQCR_IRQE_MASK                 128U


/*** DBGC1 - Debug Control Register 1; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte COMRV       :2;                                       /* Comparator Register Visibility Bits */
    byte DBGBRK      :2;                                       /* S12X_DBG Breakpoint Enable Bits */
    byte BDM         :1;                                       /* Background Debug Mode Enable */
    byte XGSBPE      :1;                                       /* XGATE S/W Breakpoint Enable */
    byte TRIG        :1;                                       /* Immediate Trigger Request Bit */
    byte ARM         :1;                                       /* Arm Bit */
  } Bits;
} DBGC1STR;
extern volatile DBGC1STR _DBGC1 @(REG_BASE + 0x00000020UL);
#define DBGC1                           _DBGC1.Byte
#define DBGC1_COMRV                     _DBGC1.Bits.COMRV
#define DBGC1_DBGBRK                    _DBGC1.Bits.DBGBRK
#define DBGC1_BDM                       _DBGC1.Bits.BDM
#define DBGC1_XGSBPE                    _DBGC1.Bits.XGSBPE
#define DBGC1_TRIG                      _DBGC1.Bits.TRIG
#define DBGC1_ARM                       _DBGC1.Bits.ARM

#define DBGC1_COMRV_MASK                3U
#define DBGC1_COMRV_BITNUM              0U
#define DBGC1_DBGBRK_MASK               12U
#define DBGC1_DBGBRK_BITNUM             2U
#define DBGC1_BDM_MASK                  16U
#define DBGC1_XGSBPE_MASK               32U
#define DBGC1_TRIG_MASK                 64U
#define DBGC1_ARM_MASK                  128U


/*** DBGSR - Debug Status Register; 0x00000021 ***/
typedef union {
  byte Byte;
  struct {
    byte SSF0        :1;                                       /* State Sequencer Flag Bit 0 */
    byte SSF1        :1;                                       /* State Sequencer Flag Bit 1 */
    byte SSF2        :1;                                       /* State Sequencer Flag Bit 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte EXTF        :1;                                       /* External Tag Hit Flag */
    byte TBF         :1;                                       /* Trace Buffer Full */
  } Bits;
  struct {
    byte grpSSF  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} DBGSRSTR;
extern volatile DBGSRSTR _DBGSR @(REG_BASE + 0x00000021UL);
#define DBGSR                           _DBGSR.Byte
#define DBGSR_SSF0                      _DBGSR.Bits.SSF0
#define DBGSR_SSF1                      _DBGSR.Bits.SSF1
#define DBGSR_SSF2                      _DBGSR.Bits.SSF2
#define DBGSR_EXTF                      _DBGSR.Bits.EXTF
#define DBGSR_TBF                       _DBGSR.Bits.TBF
#define DBGSR_SSF                       _DBGSR.MergedBits.grpSSF

#define DBGSR_SSF0_MASK                 1U
#define DBGSR_SSF1_MASK                 2U
#define DBGSR_SSF2_MASK                 4U
#define DBGSR_EXTF_MASK                 64U
#define DBGSR_TBF_MASK                  128U
#define DBGSR_SSF_MASK                  7U
#define DBGSR_SSF_BITNUM                0U


/*** DBGTCR - Debug Trace Control Register; 0x00000022 ***/
typedef union {
  byte Byte;
  struct {
    byte TALIGN      :2;                                       /* Trigger Align Bits */
    byte TRCMOD      :2;                                       /* Trace Mode Bits */
    byte TRANGE      :2;                                       /* Trace Range Bits */
    byte TSOURCE     :2;                                       /* Trace Source Control Bits */
  } Bits;
} DBGTCRSTR;
extern volatile DBGTCRSTR _DBGTCR @(REG_BASE + 0x00000022UL);
#define DBGTCR                          _DBGTCR.Byte
#define DBGTCR_TALIGN                   _DBGTCR.Bits.TALIGN
#define DBGTCR_TRCMOD                   _DBGTCR.Bits.TRCMOD
#define DBGTCR_TRANGE                   _DBGTCR.Bits.TRANGE
#define DBGTCR_TSOURCE                  _DBGTCR.Bits.TSOURCE

#define DBGTCR_TALIGN_MASK              3U
#define DBGTCR_TALIGN_BITNUM            0U
#define DBGTCR_TRCMOD_MASK              12U
#define DBGTCR_TRCMOD_BITNUM            2U
#define DBGTCR_TRANGE_MASK              48U
#define DBGTCR_TRANGE_BITNUM            4U
#define DBGTCR_TSOURCE_MASK             192U
#define DBGTCR_TSOURCE_BITNUM           6U


/*** DBGC2 - Debug Control Register 2; 0x00000023 ***/
typedef union {
  byte Byte;
  struct {
    byte ABCM        :2;                                       /* A and B Comparator Match Control */
    byte CDCM        :2;                                       /* C and D Comparator Match Control */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} DBGC2STR;
extern volatile DBGC2STR _DBGC2 @(REG_BASE + 0x00000023UL);
#define DBGC2                           _DBGC2.Byte
#define DBGC2_ABCM                      _DBGC2.Bits.ABCM
#define DBGC2_CDCM                      _DBGC2.Bits.CDCM

#define DBGC2_ABCM_MASK                 3U
#define DBGC2_ABCM_BITNUM               0U
#define DBGC2_CDCM_MASK                 12U
#define DBGC2_CDCM_BITNUM               2U


/*** DBGTB - Debug Trace Buffer Register; 0x00000024 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DBGTBH - Debug Trace Buffer Register High; 0x00000024 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Debug Trace Buffer Bit 8 */
        byte BIT9        :1;                                       /* Debug Trace Buffer Bit 9 */
        byte BIT10       :1;                                       /* Debug Trace Buffer Bit 10 */
        byte BIT11       :1;                                       /* Debug Trace Buffer Bit 11 */
        byte BIT12       :1;                                       /* Debug Trace Buffer Bit 12 */
        byte BIT13       :1;                                       /* Debug Trace Buffer Bit 13 */
        byte BIT14       :1;                                       /* Debug Trace Buffer Bit 14 */
        byte BIT15       :1;                                       /* Debug Trace Buffer Bit 15 */
      } Bits;
    } DBGTBHSTR;
    #define DBGTBH                      _DBGTB.Overlap_STR.DBGTBHSTR.Byte
    #define DBGTBH_BIT8                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT8
    #define DBGTBH_BIT9                 _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT9
    #define DBGTBH_BIT10                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT10
    #define DBGTBH_BIT11                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT11
    #define DBGTBH_BIT12                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT12
    #define DBGTBH_BIT13                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT13
    #define DBGTBH_BIT14                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT14
    #define DBGTBH_BIT15                _DBGTB.Overlap_STR.DBGTBHSTR.Bits.BIT15
    
    #define DBGTBH_BIT8_MASK            1U
    #define DBGTBH_BIT9_MASK            2U
    #define DBGTBH_BIT10_MASK           4U
    #define DBGTBH_BIT11_MASK           8U
    #define DBGTBH_BIT12_MASK           16U
    #define DBGTBH_BIT13_MASK           32U
    #define DBGTBH_BIT14_MASK           64U
    #define DBGTBH_BIT15_MASK           128U
    

    /*** DBGTBL - Debug Trace Buffer Register Low; 0x00000025 ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Debug Trace Buffer Bit 0 */
        byte BIT1        :1;                                       /* Debug Trace Buffer Bit 1 */
        byte BIT2        :1;                                       /* Debug Trace Buffer Bit 2 */
        byte BIT3        :1;                                       /* Debug Trace Buffer Bit 3 */
        byte BIT4        :1;                                       /* Debug Trace Buffer Bit 4 */
        byte BIT5        :1;                                       /* Debug Trace Buffer Bit 5 */
        byte BIT6        :1;                                       /* Debug Trace Buffer Bit 6 */
        byte BIT7        :1;                                       /* Debug Trace Buffer Bit 7 */
      } Bits;
    } DBGTBLSTR;
    #define DBGTBL                      _DBGTB.Overlap_STR.DBGTBLSTR.Byte
    #define DBGTBL_BIT0                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT0
    #define DBGTBL_BIT1                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT1
    #define DBGTBL_BIT2                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT2
    #define DBGTBL_BIT3                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT3
    #define DBGTBL_BIT4                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT4
    #define DBGTBL_BIT5                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT5
    #define DBGTBL_BIT6                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT6
    #define DBGTBL_BIT7                 _DBGTB.Overlap_STR.DBGTBLSTR.Bits.BIT7
    
    #define DBGTBL_BIT0_MASK            1U
    #define DBGTBL_BIT1_MASK            2U
    #define DBGTBL_BIT2_MASK            4U
    #define DBGTBL_BIT3_MASK            8U
    #define DBGTBL_BIT4_MASK            16U
    #define DBGTBL_BIT5_MASK            32U
    #define DBGTBL_BIT6_MASK            64U
    #define DBGTBL_BIT7_MASK            128U
    
  } Overlap_STR;

  struct {
    word BIT0        :1;                                       /* Debug Trace Buffer Bit 0 */
    word BIT1        :1;                                       /* Debug Trace Buffer Bit 1 */
    word BIT2        :1;                                       /* Debug Trace Buffer Bit 2 */
    word BIT3        :1;                                       /* Debug Trace Buffer Bit 3 */
    word BIT4        :1;                                       /* Debug Trace Buffer Bit 4 */
    word BIT5        :1;                                       /* Debug Trace Buffer Bit 5 */
    word BIT6        :1;                                       /* Debug Trace Buffer Bit 6 */
    word BIT7        :1;                                       /* Debug Trace Buffer Bit 7 */
    word BIT8        :1;                                       /* Debug Trace Buffer Bit 8 */
    word BIT9        :1;                                       /* Debug Trace Buffer Bit 9 */
    word BIT10       :1;                                       /* Debug Trace Buffer Bit 10 */
    word BIT11       :1;                                       /* Debug Trace Buffer Bit 11 */
    word BIT12       :1;                                       /* Debug Trace Buffer Bit 12 */
    word BIT13       :1;                                       /* Debug Trace Buffer Bit 13 */
    word BIT14       :1;                                       /* Debug Trace Buffer Bit 14 */
    word BIT15       :1;                                       /* Debug Trace Buffer Bit 15 */
  } Bits;
} DBGTBSTR;
extern volatile DBGTBSTR _DBGTB @(REG_BASE + 0x00000024UL);
#define DBGTB                           _DBGTB.Word
#define DBGTB_BIT0                      _DBGTB.Bits.BIT0
#define DBGTB_BIT1                      _DBGTB.Bits.BIT1
#define DBGTB_BIT2                      _DBGTB.Bits.BIT2
#define DBGTB_BIT3                      _DBGTB.Bits.BIT3
#define DBGTB_BIT4                      _DBGTB.Bits.BIT4
#define DBGTB_BIT5                      _DBGTB.Bits.BIT5
#define DBGTB_BIT6                      _DBGTB.Bits.BIT6
#define DBGTB_BIT7                      _DBGTB.Bits.BIT7
#define DBGTB_BIT8                      _DBGTB.Bits.BIT8
#define DBGTB_BIT9                      _DBGTB.Bits.BIT9
#define DBGTB_BIT10                     _DBGTB.Bits.BIT10
#define DBGTB_BIT11                     _DBGTB.Bits.BIT11
#define DBGTB_BIT12                     _DBGTB.Bits.BIT12
#define DBGTB_BIT13                     _DBGTB.Bits.BIT13
#define DBGTB_BIT14                     _DBGTB.Bits.BIT14
#define DBGTB_BIT15                     _DBGTB.Bits.BIT15

#define DBGTB_BIT0_MASK                 1U
#define DBGTB_BIT1_MASK                 2U
#define DBGTB_BIT2_MASK                 4U
#define DBGTB_BIT3_MASK                 8U
#define DBGTB_BIT4_MASK                 16U
#define DBGTB_BIT5_MASK                 32U
#define DBGTB_BIT6_MASK                 64U
#define DBGTB_BIT7_MASK                 128U
#define DBGTB_BIT8_MASK                 256U
#define DBGTB_BIT9_MASK                 512U
#define DBGTB_BIT10_MASK                1024U
#define DBGTB_BIT11_MASK                2048U
#define DBGTB_BIT12_MASK                4096U
#define DBGTB_BIT13_MASK                8192U
#define DBGTB_BIT14_MASK                16384U
#define DBGTB_BIT15_MASK                32768U


/*** DBGCNT - Debug Count Register; 0x00000026 ***/
typedef union {
  byte Byte;
  struct {
    byte CNT         :7;                                       /* Count value */
    byte             :1; 
  } Bits;
} DBGCNTSTR;
extern volatile DBGCNTSTR _DBGCNT @(REG_BASE + 0x00000026UL);
#define DBGCNT                          _DBGCNT.Byte
#define DBGCNT_CNT                      _DBGCNT.Bits.CNT

#define DBGCNT_CNT_MASK                 127U
#define DBGCNT_CNT_BITNUM               0U


/*** DBGSCRX - Debug State Control Register 0; 0x00000027 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** DBGSCRX - Debug State Control Register 0; Several registers at the same address ***/
    union {
      struct {
        byte SC0         :1;                                       /* These bit (0) select the targeted next state whilst in StateX, based upon the match event */
        byte SC1         :1;                                       /* These bit (1) select the targeted next state whilst in StateX, based upon the match event */
        byte SC2         :1;                                       /* These bit (2) select the targeted next state whilst in StateX, based upon the match event */
        byte SC3         :1;                                       /* These bit (3) select the targeted next state whilst in StateX, based upon the match event */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpSC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGSCRXSTR;
    #define DBGSCRX                     _DBGSCRX.Byte
    #define DBGSCRX_SC0                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC0
    #define DBGSCRX_SC1                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC1
    #define DBGSCRX_SC2                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC2
    #define DBGSCRX_SC3                 _DBGSCRX.SameAddr_STR.DBGSCRXSTR.Bits.SC3
    #define DBGSCRX_SC                  _DBGSCRX.SameAddr_STR.DBGSCRXSTR.MergedBits.grpSC
    
    #define DBGSCRX_SC0_MASK            1U
    #define DBGSCRX_SC1_MASK            2U
    #define DBGSCRX_SC2_MASK            4U
    #define DBGSCRX_SC3_MASK            8U
    #define DBGSCRX_SC_MASK             15U
    #define DBGSCRX_SC_BITNUM           0U
    
    /*** DBGMFR - Debug Match Flag Register; Several registers at the same address ***/
    union {
      struct {
        byte MC0         :1;                                       /* Debug Match Flag Bit 0 */
        byte MC1         :1;                                       /* Debug Match Flag Bit 1 */
        byte MC2         :1;                                       /* Debug Match Flag Bit 2 */
        byte MC3         :1;                                       /* Debug Match Flag Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpMC :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } DBGMFRSTR;
    #define DBGMFR                      _DBGSCRX.Byte
    #define DBGMFR_MC0                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC0
    #define DBGMFR_MC1                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC1
    #define DBGMFR_MC2                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC2
    #define DBGMFR_MC3                  _DBGSCRX.SameAddr_STR.DBGMFRSTR.Bits.MC3
    #define DBGMFR_MC                   _DBGSCRX.SameAddr_STR.DBGMFRSTR.MergedBits.grpMC
    
    #define DBGMFR_MC0_MASK             1U
    #define DBGMFR_MC1_MASK             2U
    #define DBGMFR_MC2_MASK             4U
    #define DBGMFR_MC3_MASK             8U
    #define DBGMFR_MC_MASK              15U
    #define DBGMFR_MC_BITNUM            0U
    
  } SameAddr_STR; /*Several registers at the same address */

} DBGSCRXSTR;
extern volatile DBGSCRXSTR _DBGSCRX @(REG_BASE + 0x00000027UL);


/*** DBGXCTL - Debug Comparator Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte COMPE       :1;                                       /* Determines if comparator is enabled */
    byte SRC         :1;                                       /* Determines mapping of comparator to S12X_CPU or XGATE */
    byte RWE         :1;                                       /* Read/Write Enable Bit */
    byte RW          :1;                                       /* Read/Write Comparator Value Bit */
    byte BRK         :1;                                       /* Break */
    byte TAG         :1;                                       /* Tag select */
    byte NDB_SZ      :1;                                       /* Not Data Bus Compare (for comparators A and C), Size Comparator Value Bit (for comparators B and D) */
    byte SZE         :1;                                       /* Size Comparator Enable Bit (for comparators B and D) */
  } Bits;
} DBGXCTLSTR;
extern volatile DBGXCTLSTR _DBGXCTL @(REG_BASE + 0x00000028UL);
#define DBGXCTL                         _DBGXCTL.Byte
#define DBGXCTL_COMPE                   _DBGXCTL.Bits.COMPE
#define DBGXCTL_SRC                     _DBGXCTL.Bits.SRC
#define DBGXCTL_RWE                     _DBGXCTL.Bits.RWE
#define DBGXCTL_RW                      _DBGXCTL.Bits.RW
#define DBGXCTL_BRK                     _DBGXCTL.Bits.BRK
#define DBGXCTL_TAG                     _DBGXCTL.Bits.TAG
#define DBGXCTL_NDB_SZ                  _DBGXCTL.Bits.NDB_SZ
#define DBGXCTL_SZE                     _DBGXCTL.Bits.SZE

#define DBGXCTL_COMPE_MASK              1U
#define DBGXCTL_SRC_MASK                2U
#define DBGXCTL_RWE_MASK                4U
#define DBGXCTL_RW_MASK                 8U
#define DBGXCTL_BRK_MASK                16U
#define DBGXCTL_TAG_MASK                32U
#define DBGXCTL_NDB_SZ_MASK             64U
#define DBGXCTL_SZE_MASK                128U


/*** DBGXAH - Debug Comparator Address High Register; 0x00000029 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT16       :1;                                       /* Comparator Address High Compare Bit 16 */
    byte BIT17       :1;                                       /* Comparator Address High Compare Bit 17 */
    byte BIT18       :1;                                       /* Comparator Address High Compare Bit 18 */
    byte BIT19       :1;                                       /* Comparator Address High Compare Bit 19 */
    byte BIT20       :1;                                       /* Comparator Address High Compare Bit 20 */
    byte BIT21       :1;                                       /* Comparator Address High Compare Bit 21 */
    byte BIT22       :1;                                       /* Comparator Address High Compare Bit 22 */
    byte             :1; 
  } Bits;
  struct {
    byte grpBIT_16 :7;
    byte         :1;
  } MergedBits;
} DBGXAHSTR;
extern volatile DBGXAHSTR _DBGXAH @(REG_BASE + 0x00000029UL);
#define DBGXAH                          _DBGXAH.Byte
#define DBGXAH_BIT16                    _DBGXAH.Bits.BIT16
#define DBGXAH_BIT17                    _DBGXAH.Bits.BIT17
#define DBGXAH_BIT18                    _DBGXAH.Bits.BIT18
#define DBGXAH_BIT19                    _DBGXAH.Bits.BIT19
#define DBGXAH_BIT20                    _DBGXAH.Bits.BIT20
#define DBGXAH_BIT21                    _DBGXAH.Bits.BIT21
#define DBGXAH_BIT22                    _DBGXAH.Bits.BIT22
#define DBGXAH_BIT_16                   _DBGXAH.MergedBits.grpBIT_16
#define DBGXAH_BIT                      DBGXAH_BIT_16

#define DBGXAH_BIT16_MASK               1U
#define DBGXAH_BIT17_MASK               2U
#define DBGXAH_BIT18_MASK               4U
#define DBGXAH_BIT19_MASK               8U
#define DBGXAH_BIT20_MASK               16U
#define DBGXAH_BIT21_MASK               32U
#define DBGXAH_BIT22_MASK               64U
#define DBGXAH_BIT_16_MASK              127U
#define DBGXAH_BIT_16_BITNUM            0U


/*** DBGXAM - Debug Comparator Address Mid Register; 0x0000002A ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Address Mid Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator Address Mid Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator Address Mid Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator Address Mid Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator Address Mid Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator Address Mid Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator Address Mid Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator Address Mid Compare Bit 15 */
  } Bits;
} DBGXAMSTR;
extern volatile DBGXAMSTR _DBGXAM @(REG_BASE + 0x0000002AUL);
#define DBGXAM                          _DBGXAM.Byte
#define DBGXAM_BIT8                     _DBGXAM.Bits.BIT8
#define DBGXAM_BIT9                     _DBGXAM.Bits.BIT9
#define DBGXAM_BIT10                    _DBGXAM.Bits.BIT10
#define DBGXAM_BIT11                    _DBGXAM.Bits.BIT11
#define DBGXAM_BIT12                    _DBGXAM.Bits.BIT12
#define DBGXAM_BIT13                    _DBGXAM.Bits.BIT13
#define DBGXAM_BIT14                    _DBGXAM.Bits.BIT14
#define DBGXAM_BIT15                    _DBGXAM.Bits.BIT15

#define DBGXAM_BIT8_MASK                1U
#define DBGXAM_BIT9_MASK                2U
#define DBGXAM_BIT10_MASK               4U
#define DBGXAM_BIT11_MASK               8U
#define DBGXAM_BIT12_MASK               16U
#define DBGXAM_BIT13_MASK               32U
#define DBGXAM_BIT14_MASK               64U
#define DBGXAM_BIT15_MASK               128U


/*** DBGXAL - Debug Comparator Address Low Register; 0x0000002B ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXALSTR;
extern volatile DBGXALSTR _DBGXAL @(REG_BASE + 0x0000002BUL);
#define DBGXAL                          _DBGXAL.Byte
#define DBGXAL_BIT0                     _DBGXAL.Bits.BIT0
#define DBGXAL_BIT1                     _DBGXAL.Bits.BIT1
#define DBGXAL_BIT2                     _DBGXAL.Bits.BIT2
#define DBGXAL_BIT3                     _DBGXAL.Bits.BIT3
#define DBGXAL_BIT4                     _DBGXAL.Bits.BIT4
#define DBGXAL_BIT5                     _DBGXAL.Bits.BIT5
#define DBGXAL_BIT6                     _DBGXAL.Bits.BIT6
#define DBGXAL_BIT7                     _DBGXAL.Bits.BIT7

#define DBGXAL_BIT0_MASK                1U
#define DBGXAL_BIT1_MASK                2U
#define DBGXAL_BIT2_MASK                4U
#define DBGXAL_BIT3_MASK                8U
#define DBGXAL_BIT4_MASK                16U
#define DBGXAL_BIT5_MASK                32U
#define DBGXAL_BIT6_MASK                64U
#define DBGXAL_BIT7_MASK                128U


/*** DBGXDH - Debug Comparator Data High Register; 0x0000002C ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator A Compare Bit 8 */
    byte BIT9        :1;                                       /* Comparator A Compare Bit 9 */
    byte BIT10       :1;                                       /* Comparator A Compare Bit 10 */
    byte BIT11       :1;                                       /* Comparator A Compare Bit 11 */
    byte BIT12       :1;                                       /* Comparator A Compare Bit 12 */
    byte BIT13       :1;                                       /* Comparator A Compare Bit 13 */
    byte BIT14       :1;                                       /* Comparator A Compare Bit 14 */
    byte BIT15       :1;                                       /* Comparator A Compare Bit 15 */
  } Bits;
} DBGXDHSTR;
extern volatile DBGXDHSTR _DBGXDH @(REG_BASE + 0x0000002CUL);
#define DBGXDH                          _DBGXDH.Byte
#define DBGXDH_BIT8                     _DBGXDH.Bits.BIT8
#define DBGXDH_BIT9                     _DBGXDH.Bits.BIT9
#define DBGXDH_BIT10                    _DBGXDH.Bits.BIT10
#define DBGXDH_BIT11                    _DBGXDH.Bits.BIT11
#define DBGXDH_BIT12                    _DBGXDH.Bits.BIT12
#define DBGXDH_BIT13                    _DBGXDH.Bits.BIT13
#define DBGXDH_BIT14                    _DBGXDH.Bits.BIT14
#define DBGXDH_BIT15                    _DBGXDH.Bits.BIT15

#define DBGXDH_BIT8_MASK                1U
#define DBGXDH_BIT9_MASK                2U
#define DBGXDH_BIT10_MASK               4U
#define DBGXDH_BIT11_MASK               8U
#define DBGXDH_BIT12_MASK               16U
#define DBGXDH_BIT13_MASK               32U
#define DBGXDH_BIT14_MASK               64U
#define DBGXDH_BIT15_MASK               128U


/*** DBGXDL - Debug Comparator Data Low Register; 0x0000002D ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Address Low Compare Bit 0 */
    byte BIT1        :1;                                       /* Comparator Address Low Compare Bit 1 */
    byte BIT2        :1;                                       /* Comparator Address Low Compare Bit 2 */
    byte BIT3        :1;                                       /* Comparator Address Low Compare Bit 3 */
    byte BIT4        :1;                                       /* Comparator Address Low Compare Bit 4 */
    byte BIT5        :1;                                       /* Comparator Address Low Compare Bit 5 */
    byte BIT6        :1;                                       /* Comparator Address Low Compare Bit 6 */
    byte BIT7        :1;                                       /* Comparator Address Low Compare Bit 7 */
  } Bits;
} DBGXDLSTR;
extern volatile DBGXDLSTR _DBGXDL @(REG_BASE + 0x0000002DUL);
#define DBGXDL                          _DBGXDL.Byte
#define DBGXDL_BIT0                     _DBGXDL.Bits.BIT0
#define DBGXDL_BIT1                     _DBGXDL.Bits.BIT1
#define DBGXDL_BIT2                     _DBGXDL.Bits.BIT2
#define DBGXDL_BIT3                     _DBGXDL.Bits.BIT3
#define DBGXDL_BIT4                     _DBGXDL.Bits.BIT4
#define DBGXDL_BIT5                     _DBGXDL.Bits.BIT5
#define DBGXDL_BIT6                     _DBGXDL.Bits.BIT6
#define DBGXDL_BIT7                     _DBGXDL.Bits.BIT7

#define DBGXDL_BIT0_MASK                1U
#define DBGXDL_BIT1_MASK                2U
#define DBGXDL_BIT2_MASK                4U
#define DBGXDL_BIT3_MASK                8U
#define DBGXDL_BIT4_MASK                16U
#define DBGXDL_BIT5_MASK                32U
#define DBGXDL_BIT6_MASK                64U
#define DBGXDL_BIT7_MASK                128U


/*** DBGXDHM - Debug Comparator Data High Mask Register; 0x0000002E ***/
typedef union {
  byte Byte;
  struct {
    byte BIT8        :1;                                       /* Comparator Data High Mask Bit 8 */
    byte BIT9        :1;                                       /* Comparator Data High Mask Bit 9 */
    byte BIT10       :1;                                       /* Comparator Data High Mask Bit 10 */
    byte BIT11       :1;                                       /* Comparator Data High Mask Bit 11 */
    byte BIT12       :1;                                       /* Comparator Data High Mask Bit 12 */
    byte BIT13       :1;                                       /* Comparator Data High Mask Bit 13 */
    byte BIT14       :1;                                       /* Comparator Data High Mask Bit 14 */
    byte BIT15       :1;                                       /* Comparator Data High Mask Bit 15 */
  } Bits;
} DBGXDHMSTR;
extern volatile DBGXDHMSTR _DBGXDHM @(REG_BASE + 0x0000002EUL);
#define DBGXDHM                         _DBGXDHM.Byte
#define DBGXDHM_BIT8                    _DBGXDHM.Bits.BIT8
#define DBGXDHM_BIT9                    _DBGXDHM.Bits.BIT9
#define DBGXDHM_BIT10                   _DBGXDHM.Bits.BIT10
#define DBGXDHM_BIT11                   _DBGXDHM.Bits.BIT11
#define DBGXDHM_BIT12                   _DBGXDHM.Bits.BIT12
#define DBGXDHM_BIT13                   _DBGXDHM.Bits.BIT13
#define DBGXDHM_BIT14                   _DBGXDHM.Bits.BIT14
#define DBGXDHM_BIT15                   _DBGXDHM.Bits.BIT15

#define DBGXDHM_BIT8_MASK               1U
#define DBGXDHM_BIT9_MASK               2U
#define DBGXDHM_BIT10_MASK              4U
#define DBGXDHM_BIT11_MASK              8U
#define DBGXDHM_BIT12_MASK              16U
#define DBGXDHM_BIT13_MASK              32U
#define DBGXDHM_BIT14_MASK              64U
#define DBGXDHM_BIT15_MASK              128U


/*** DBGXDLM - Debug Comparator Data Low Mask Register; 0x0000002F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Comparator Data High Mask Bit 0 */
    byte BIT1        :1;                                       /* Comparator Data High Mask Bit 1 */
    byte BIT2        :1;                                       /* Comparator Data High Mask Bit 2 */
    byte BIT3        :1;                                       /* Comparator Data High Mask Bit 3 */
    byte BIT4        :1;                                       /* Comparator Data High Mask Bit 4 */
    byte BIT5        :1;                                       /* Comparator Data High Mask Bit 5 */
    byte BIT6        :1;                                       /* Comparator Data High Mask Bit 6 */
    byte BIT7        :1;                                       /* Comparator Data High Mask Bit 7 */
  } Bits;
} DBGXDLMSTR;
extern volatile DBGXDLMSTR _DBGXDLM @(REG_BASE + 0x0000002FUL);
#define DBGXDLM                         _DBGXDLM.Byte
#define DBGXDLM_BIT0                    _DBGXDLM.Bits.BIT0
#define DBGXDLM_BIT1                    _DBGXDLM.Bits.BIT1
#define DBGXDLM_BIT2                    _DBGXDLM.Bits.BIT2
#define DBGXDLM_BIT3                    _DBGXDLM.Bits.BIT3
#define DBGXDLM_BIT4                    _DBGXDLM.Bits.BIT4
#define DBGXDLM_BIT5                    _DBGXDLM.Bits.BIT5
#define DBGXDLM_BIT6                    _DBGXDLM.Bits.BIT6
#define DBGXDLM_BIT7                    _DBGXDLM.Bits.BIT7

#define DBGXDLM_BIT0_MASK               1U
#define DBGXDLM_BIT1_MASK               2U
#define DBGXDLM_BIT2_MASK               4U
#define DBGXDLM_BIT3_MASK               8U
#define DBGXDLM_BIT4_MASK               16U
#define DBGXDLM_BIT5_MASK               32U
#define DBGXDLM_BIT6_MASK               64U
#define DBGXDLM_BIT7_MASK               128U


/*** PPAGE - Program Page Index Register; 0x00000030 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte PIX4        :1;                                       /* Program Page Index Bit 4 */
    byte PIX5        :1;                                       /* Program Page Index Bit 5 */
    byte PIX6        :1;                                       /* Program Page Index Bit 6 */
    byte PIX7        :1;                                       /* Program Page Index Bit 7 */
  } Bits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000030UL);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX6                      _PPAGE.Bits.PIX6
#define PPAGE_PIX7                      _PPAGE.Bits.PIX7

#define PPAGE_PIX0_MASK                 1U
#define PPAGE_PIX1_MASK                 2U
#define PPAGE_PIX2_MASK                 4U
#define PPAGE_PIX3_MASK                 8U
#define PPAGE_PIX4_MASK                 16U
#define PPAGE_PIX5_MASK                 32U
#define PPAGE_PIX6_MASK                 64U
#define PPAGE_PIX7_MASK                 128U


/*** PORTK - Port K Data Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte PK0         :1;                                       /* Port K Bit 0 */
    byte PK1         :1;                                       /* Port K Bit 1 */
    byte PK2         :1;                                       /* Port K Bit 2 */
    byte PK3         :1;                                       /* Port K Bit 3 */
    byte PK4         :1;                                       /* Port K Bit 4 */
    byte PK5         :1;                                       /* Port K Bit 5 */
    byte PK6         :1;                                       /* Port K Bit 6 */
    byte PK7         :1;                                       /* Port K Bit 7 */
  } Bits;
} PORTKSTR;
extern volatile PORTKSTR _PORTK @(REG_BASE + 0x00000032UL);
#define PORTK                           _PORTK.Byte
#define PORTK_PK0                       _PORTK.Bits.PK0
#define PORTK_PK1                       _PORTK.Bits.PK1
#define PORTK_PK2                       _PORTK.Bits.PK2
#define PORTK_PK3                       _PORTK.Bits.PK3
#define PORTK_PK4                       _PORTK.Bits.PK4
#define PORTK_PK5                       _PORTK.Bits.PK5
#define PORTK_PK6                       _PORTK.Bits.PK6
#define PORTK_PK7                       _PORTK.Bits.PK7

#define PORTK_PK0_MASK                  1U
#define PORTK_PK1_MASK                  2U
#define PORTK_PK2_MASK                  4U
#define PORTK_PK3_MASK                  8U
#define PORTK_PK4_MASK                  16U
#define PORTK_PK5_MASK                  32U
#define PORTK_PK6_MASK                  64U
#define PORTK_PK7_MASK                  128U


/*** DDRK - Port K Data Direction Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRK0       :1;                                       /* Port K Data Direction Bit 0 */
    byte DDRK1       :1;                                       /* Port K Data Direction Bit 1 */
    byte DDRK2       :1;                                       /* Port K Data Direction Bit 2 */
    byte DDRK3       :1;                                       /* Port K Data Direction Bit 3 */
    byte DDRK4       :1;                                       /* Port K Data Direction Bit 4 */
    byte DDRK5       :1;                                       /* Port K Data Direction Bit 5 */
    byte DDRK6       :1;                                       /* Port K Data Direction Bit 6 */
    byte DDRK7       :1;                                       /* Port K Data Direction Bit 7 */
  } Bits;
} DDRKSTR;
extern volatile DDRKSTR _DDRK @(REG_BASE + 0x00000033UL);
#define DDRK                            _DDRK.Byte
#define DDRK_DDRK0                      _DDRK.Bits.DDRK0
#define DDRK_DDRK1                      _DDRK.Bits.DDRK1
#define DDRK_DDRK2                      _DDRK.Bits.DDRK2
#define DDRK_DDRK3                      _DDRK.Bits.DDRK3
#define DDRK_DDRK4                      _DDRK.Bits.DDRK4
#define DDRK_DDRK5                      _DDRK.Bits.DDRK5
#define DDRK_DDRK6                      _DDRK.Bits.DDRK6
#define DDRK_DDRK7                      _DDRK.Bits.DDRK7

#define DDRK_DDRK0_MASK                 1U
#define DDRK_DDRK1_MASK                 2U
#define DDRK_DDRK2_MASK                 4U
#define DDRK_DDRK3_MASK                 8U
#define DDRK_DDRK4_MASK                 16U
#define DDRK_DDRK5_MASK                 32U
#define DDRK_DDRK6_MASK                 64U
#define DDRK_DDRK7_MASK                 128U


/*** SYNR - CRG Synthesizer Register; 0x00000034 ***/
typedef union {
  byte Byte;
  struct {
    byte SYN0        :1;                                       /* CRG Synthesizer Bit 0 */
    byte SYN1        :1;                                       /* CRG Synthesizer Bit 1 */
    byte SYN2        :1;                                       /* CRG Synthesizer Bit 2 */
    byte SYN3        :1;                                       /* CRG Synthesizer Bit 3 */
    byte SYN4        :1;                                       /* CRG Synthesizer Bit 4 */
    byte SYN5        :1;                                       /* CRG Synthesizer Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpSYN  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} SYNRSTR;
extern volatile SYNRSTR _SYNR @(REG_BASE + 0x00000034UL);
#define SYNR                            _SYNR.Byte
#define SYNR_SYN0                       _SYNR.Bits.SYN0
#define SYNR_SYN1                       _SYNR.Bits.SYN1
#define SYNR_SYN2                       _SYNR.Bits.SYN2
#define SYNR_SYN3                       _SYNR.Bits.SYN3
#define SYNR_SYN4                       _SYNR.Bits.SYN4
#define SYNR_SYN5                       _SYNR.Bits.SYN5
#define SYNR_SYN                        _SYNR.MergedBits.grpSYN

#define SYNR_SYN0_MASK                  1U
#define SYNR_SYN1_MASK                  2U
#define SYNR_SYN2_MASK                  4U
#define SYNR_SYN3_MASK                  8U
#define SYNR_SYN4_MASK                  16U
#define SYNR_SYN5_MASK                  32U
#define SYNR_SYN_MASK                   63U
#define SYNR_SYN_BITNUM                 0U


/*** REFDV - CRG Reference Divider Register; 0x00000035 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDV0      :1;                                       /* CRG Reference Divider Bit 0 */
    byte REFDV1      :1;                                       /* CRG Reference Divider Bit 1 */
    byte REFDV2      :1;                                       /* CRG Reference Divider Bit 2 */
    byte REFDV3      :1;                                       /* CRG Reference Divider Bit 3 */
    byte REFDV4      :1;                                       /* CRG Reference Divider Bit 4 */
    byte REFDV5      :1;                                       /* CRG Reference Divider Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpREFDV :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} REFDVSTR;
extern volatile REFDVSTR _REFDV @(REG_BASE + 0x00000035UL);
#define REFDV                           _REFDV.Byte
#define REFDV_REFDV0                    _REFDV.Bits.REFDV0
#define REFDV_REFDV1                    _REFDV.Bits.REFDV1
#define REFDV_REFDV2                    _REFDV.Bits.REFDV2
#define REFDV_REFDV3                    _REFDV.Bits.REFDV3
#define REFDV_REFDV4                    _REFDV.Bits.REFDV4
#define REFDV_REFDV5                    _REFDV.Bits.REFDV5
#define REFDV_REFDV                     _REFDV.MergedBits.grpREFDV

#define REFDV_REFDV0_MASK               1U
#define REFDV_REFDV1_MASK               2U
#define REFDV_REFDV2_MASK               4U
#define REFDV_REFDV3_MASK               8U
#define REFDV_REFDV4_MASK               16U
#define REFDV_REFDV5_MASK               32U
#define REFDV_REFDV_MASK                63U
#define REFDV_REFDV_BITNUM              0U


/*** CRGFLG - CRG Flags Register; 0x00000037 ***/
typedef union {
  byte Byte;
  struct {
    byte SCM         :1;                                       /* Self-clock mode Status */
    byte SCMIF       :1;                                       /* Self-clock mode Interrupt Flag */
    byte TRACK       :1;                                       /* Track Status */
    byte LOCK        :1;                                       /* Lock Status */
    byte LOCKIF      :1;                                       /* PLL Lock Interrupt Flag */
    byte LVRF        :1;                                       /* Low Voltage Reset Flag */
    byte PORF        :1;                                       /* Power on Reset Flag */
    byte RTIF        :1;                                       /* Real Time Interrupt Flag */
  } Bits;
} CRGFLGSTR;
extern volatile CRGFLGSTR _CRGFLG @(REG_BASE + 0x00000037UL);
#define CRGFLG                          _CRGFLG.Byte
#define CRGFLG_SCM                      _CRGFLG.Bits.SCM
#define CRGFLG_SCMIF                    _CRGFLG.Bits.SCMIF
#define CRGFLG_TRACK                    _CRGFLG.Bits.TRACK
#define CRGFLG_LOCK                     _CRGFLG.Bits.LOCK
#define CRGFLG_LOCKIF                   _CRGFLG.Bits.LOCKIF
#define CRGFLG_LVRF                     _CRGFLG.Bits.LVRF
#define CRGFLG_PORF                     _CRGFLG.Bits.PORF
#define CRGFLG_RTIF                     _CRGFLG.Bits.RTIF

#define CRGFLG_SCM_MASK                 1U
#define CRGFLG_SCMIF_MASK               2U
#define CRGFLG_TRACK_MASK               4U
#define CRGFLG_LOCK_MASK                8U
#define CRGFLG_LOCKIF_MASK              16U
#define CRGFLG_LVRF_MASK                32U
#define CRGFLG_PORF_MASK                64U
#define CRGFLG_RTIF_MASK                128U


/*** CRGINT - CRG Interrupt Enable Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SCMIE       :1;                                       /* Self-clock mode Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte LOCKIE      :1;                                       /* Lock Interrupt Enable */
    byte             :1; 
    byte ILAF        :1;                                       /* Illegal Address Reset Flag */
    byte RTIE        :1;                                       /* Real Time Interrupt Enable */
  } Bits;
} CRGINTSTR;
extern volatile CRGINTSTR _CRGINT @(REG_BASE + 0x00000038UL);
#define CRGINT                          _CRGINT.Byte
#define CRGINT_SCMIE                    _CRGINT.Bits.SCMIE
#define CRGINT_LOCKIE                   _CRGINT.Bits.LOCKIE
#define CRGINT_ILAF                     _CRGINT.Bits.ILAF
#define CRGINT_RTIE                     _CRGINT.Bits.RTIE

#define CRGINT_SCMIE_MASK               2U
#define CRGINT_LOCKIE_MASK              16U
#define CRGINT_ILAF_MASK                64U
#define CRGINT_RTIE_MASK                128U


/*** CLKSEL - CRG Clock Select Register; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte COPWAI      :1;                                       /* COP stops in WAIT mode */
    byte RTIWAI      :1;                                       /* RTI stops in WAIT mode */
    byte             :1; 
    byte PLLWAI      :1;                                       /* PLL stops in WAIT mode */
    byte             :1; 
    byte             :1; 
    byte PSTP        :1;                                       /* Pseudo Stop */
    byte PLLSEL      :1;                                       /* PLL selected for system clock */
  } Bits;
} CLKSELSTR;
extern volatile CLKSELSTR _CLKSEL @(REG_BASE + 0x00000039UL);
#define CLKSEL                          _CLKSEL.Byte
#define CLKSEL_COPWAI                   _CLKSEL.Bits.COPWAI
#define CLKSEL_RTIWAI                   _CLKSEL.Bits.RTIWAI
#define CLKSEL_PLLWAI                   _CLKSEL.Bits.PLLWAI
#define CLKSEL_PSTP                     _CLKSEL.Bits.PSTP
#define CLKSEL_PLLSEL                   _CLKSEL.Bits.PLLSEL

#define CLKSEL_COPWAI_MASK              1U
#define CLKSEL_RTIWAI_MASK              2U
#define CLKSEL_PLLWAI_MASK              8U
#define CLKSEL_PSTP_MASK                64U
#define CLKSEL_PLLSEL_MASK              128U


/*** PLLCTL - CRG PLL Control Register; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte SCME        :1;                                       /* Self-clock mode enable */
    byte PCE         :1;                                       /* COP Enable during Pseudo Stop Bit */
    byte PRE         :1;                                       /* RTI Enable during Pseudo Stop Bit */
    byte FSTWKP      :1;                                       /* Fast Wake-up from Full Stop Bit */
    byte ACQ         :1;                                       /* Acquisition */
    byte AUTO        :1;                                       /* Automatic Bandwidth Control */
    byte PLLON       :1;                                       /* Phase Lock Loop On */
    byte CME         :1;                                       /* Clock Monitor Enable */
  } Bits;
} PLLCTLSTR;
extern volatile PLLCTLSTR _PLLCTL @(REG_BASE + 0x0000003AUL);
#define PLLCTL                          _PLLCTL.Byte
#define PLLCTL_SCME                     _PLLCTL.Bits.SCME
#define PLLCTL_PCE                      _PLLCTL.Bits.PCE
#define PLLCTL_PRE                      _PLLCTL.Bits.PRE
#define PLLCTL_FSTWKP                   _PLLCTL.Bits.FSTWKP
#define PLLCTL_ACQ                      _PLLCTL.Bits.ACQ
#define PLLCTL_AUTO                     _PLLCTL.Bits.AUTO
#define PLLCTL_PLLON                    _PLLCTL.Bits.PLLON
#define PLLCTL_CME                      _PLLCTL.Bits.CME

#define PLLCTL_SCME_MASK                1U
#define PLLCTL_PCE_MASK                 2U
#define PLLCTL_PRE_MASK                 4U
#define PLLCTL_FSTWKP_MASK              8U
#define PLLCTL_ACQ_MASK                 16U
#define PLLCTL_AUTO_MASK                32U
#define PLLCTL_PLLON_MASK               64U
#define PLLCTL_CME_MASK                 128U


/*** RTICTL - CRG RTI Control Register; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte RTR0        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 0 */
    byte RTR1        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 1 */
    byte RTR2        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 2 */
    byte RTR3        :1;                                       /* Real Time Interrupt Modulus Counter Select Bit 3 */
    byte RTR4        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 4 */
    byte RTR5        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 5 */
    byte RTR6        :1;                                       /* Real Time Interrupt Prescale Rate Select Bit 6 */
    byte RTDEC       :1;                                       /* Decimal or Binary Divider Select Bit */
  } Bits;
  struct {
    byte grpRTR  :7;
    byte         :1;
  } MergedBits;
} RTICTLSTR;
extern volatile RTICTLSTR _RTICTL @(REG_BASE + 0x0000003BUL);
#define RTICTL                          _RTICTL.Byte
#define RTICTL_RTR0                     _RTICTL.Bits.RTR0
#define RTICTL_RTR1                     _RTICTL.Bits.RTR1
#define RTICTL_RTR2                     _RTICTL.Bits.RTR2
#define RTICTL_RTR3                     _RTICTL.Bits.RTR3
#define RTICTL_RTR4                     _RTICTL.Bits.RTR4
#define RTICTL_RTR5                     _RTICTL.Bits.RTR5
#define RTICTL_RTR6                     _RTICTL.Bits.RTR6
#define RTICTL_RTDEC                    _RTICTL.Bits.RTDEC
#define RTICTL_RTR                      _RTICTL.MergedBits.grpRTR

#define RTICTL_RTR0_MASK                1U
#define RTICTL_RTR1_MASK                2U
#define RTICTL_RTR2_MASK                4U
#define RTICTL_RTR3_MASK                8U
#define RTICTL_RTR4_MASK                16U
#define RTICTL_RTR5_MASK                32U
#define RTICTL_RTR6_MASK                64U
#define RTICTL_RTDEC_MASK               128U
#define RTICTL_RTR_MASK                 127U
#define RTICTL_RTR_BITNUM               0U


/*** COPCTL - CRG COP Control Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte CR0         :1;                                       /* COP Watchdog Timer Rate select Bit 0 */
    byte CR1         :1;                                       /* COP Watchdog Timer Rate select Bit 1 */
    byte CR2         :1;                                       /* COP Watchdog Timer Rate select Bit 2 */
    byte             :1; 
    byte             :1; 
    byte WRTMASK     :1;                                       /* Write Mask for WCOP and CR[2:0] Bit */
    byte RSBCK       :1;                                       /* COP and RTI stop in Active BDM mode Bit */
    byte WCOP        :1;                                       /* Window COP mode */
  } Bits;
  struct {
    byte grpCR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @(REG_BASE + 0x0000003CUL);
#define COPCTL                          _COPCTL.Byte
#define COPCTL_CR0                      _COPCTL.Bits.CR0
#define COPCTL_CR1                      _COPCTL.Bits.CR1
#define COPCTL_CR2                      _COPCTL.Bits.CR2
#define COPCTL_WRTMASK                  _COPCTL.Bits.WRTMASK
#define COPCTL_RSBCK                    _COPCTL.Bits.RSBCK
#define COPCTL_WCOP                     _COPCTL.Bits.WCOP
#define COPCTL_CR                       _COPCTL.MergedBits.grpCR

#define COPCTL_CR0_MASK                 1U
#define COPCTL_CR1_MASK                 2U
#define COPCTL_CR2_MASK                 4U
#define COPCTL_WRTMASK_MASK             32U
#define COPCTL_RSBCK_MASK               64U
#define COPCTL_WCOP_MASK                128U
#define COPCTL_CR_MASK                  7U
#define COPCTL_CR_BITNUM                0U


/*** ARMCOP - CRG COP Timer Arm/Reset Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* CRG COP Timer Arm/Reset Bit 0 */
    byte BIT1        :1;                                       /* CRG COP Timer Arm/Reset Bit 1 */
    byte BIT2        :1;                                       /* CRG COP Timer Arm/Reset Bit 2 */
    byte BIT3        :1;                                       /* CRG COP Timer Arm/Reset Bit 3 */
    byte BIT4        :1;                                       /* CRG COP Timer Arm/Reset Bit 4 */
    byte BIT5        :1;                                       /* CRG COP Timer Arm/Reset Bit 5 */
    byte BIT6        :1;                                       /* CRG COP Timer Arm/Reset Bit 6 */
    byte BIT7        :1;                                       /* CRG COP Timer Arm/Reset Bit 7 */
  } Bits;
} ARMCOPSTR;
extern volatile ARMCOPSTR _ARMCOP @(REG_BASE + 0x0000003FUL);
#define ARMCOP                          _ARMCOP.Byte
#define ARMCOP_BIT0                     _ARMCOP.Bits.BIT0
#define ARMCOP_BIT1                     _ARMCOP.Bits.BIT1
#define ARMCOP_BIT2                     _ARMCOP.Bits.BIT2
#define ARMCOP_BIT3                     _ARMCOP.Bits.BIT3
#define ARMCOP_BIT4                     _ARMCOP.Bits.BIT4
#define ARMCOP_BIT5                     _ARMCOP.Bits.BIT5
#define ARMCOP_BIT6                     _ARMCOP.Bits.BIT6
#define ARMCOP_BIT7                     _ARMCOP.Bits.BIT7

#define ARMCOP_BIT0_MASK                1U
#define ARMCOP_BIT1_MASK                2U
#define ARMCOP_BIT2_MASK                4U
#define ARMCOP_BIT3_MASK                8U
#define ARMCOP_BIT4_MASK                16U
#define ARMCOP_BIT5_MASK                32U
#define ARMCOP_BIT6_MASK                64U
#define ARMCOP_BIT7_MASK                128U


/*** TIOS - Timer Input Capture/Output Compare Select; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte IOS0        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 0 */
    byte IOS1        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 1 */
    byte IOS2        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 2 */
    byte IOS3        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 3 */
    byte IOS4        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 4 */
    byte IOS5        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 5 */
    byte IOS6        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 6 */
    byte IOS7        :1;                                       /* Input Capture or Output Compare Channel Configuration Bit 7 */
  } Bits;
} TIOSSTR;
extern volatile TIOSSTR _TIOS @(REG_BASE + 0x00000040UL);
#define TIOS                            _TIOS.Byte
#define TIOS_IOS0                       _TIOS.Bits.IOS0
#define TIOS_IOS1                       _TIOS.Bits.IOS1
#define TIOS_IOS2                       _TIOS.Bits.IOS2
#define TIOS_IOS3                       _TIOS.Bits.IOS3
#define TIOS_IOS4                       _TIOS.Bits.IOS4
#define TIOS_IOS5                       _TIOS.Bits.IOS5
#define TIOS_IOS6                       _TIOS.Bits.IOS6
#define TIOS_IOS7                       _TIOS.Bits.IOS7

#define TIOS_IOS0_MASK                  1U
#define TIOS_IOS1_MASK                  2U
#define TIOS_IOS2_MASK                  4U
#define TIOS_IOS3_MASK                  8U
#define TIOS_IOS4_MASK                  16U
#define TIOS_IOS5_MASK                  32U
#define TIOS_IOS6_MASK                  64U
#define TIOS_IOS7_MASK                  128U


/*** CFORC - Timer Compare Force Register; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte FOC0        :1;                                       /* Force Output Compare Action for Channel 0 */
    byte FOC1        :1;                                       /* Force Output Compare Action for Channel 1 */
    byte FOC2        :1;                                       /* Force Output Compare Action for Channel 2 */
    byte FOC3        :1;                                       /* Force Output Compare Action for Channel 3 */
    byte FOC4        :1;                                       /* Force Output Compare Action for Channel 4 */
    byte FOC5        :1;                                       /* Force Output Compare Action for Channel 5 */
    byte FOC6        :1;                                       /* Force Output Compare Action for Channel 6 */
    byte FOC7        :1;                                       /* Force Output Compare Action for Channel 7 */
  } Bits;
} CFORCSTR;
extern volatile CFORCSTR _CFORC @(REG_BASE + 0x00000041UL);
#define CFORC                           _CFORC.Byte
#define CFORC_FOC0                      _CFORC.Bits.FOC0
#define CFORC_FOC1                      _CFORC.Bits.FOC1
#define CFORC_FOC2                      _CFORC.Bits.FOC2
#define CFORC_FOC3                      _CFORC.Bits.FOC3
#define CFORC_FOC4                      _CFORC.Bits.FOC4
#define CFORC_FOC5                      _CFORC.Bits.FOC5
#define CFORC_FOC6                      _CFORC.Bits.FOC6
#define CFORC_FOC7                      _CFORC.Bits.FOC7

#define CFORC_FOC0_MASK                 1U
#define CFORC_FOC1_MASK                 2U
#define CFORC_FOC2_MASK                 4U
#define CFORC_FOC3_MASK                 8U
#define CFORC_FOC4_MASK                 16U
#define CFORC_FOC5_MASK                 32U
#define CFORC_FOC6_MASK                 64U
#define CFORC_FOC7_MASK                 128U


/*** OC7M - Output Compare 7 Mask Register; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte OC7M0       :1;                                       /* Output Compare 7 Mask Bit 0 */
    byte OC7M1       :1;                                       /* Output Compare 7 Mask Bit 1 */
    byte OC7M2       :1;                                       /* Output Compare 7 Mask Bit 2 */
    byte OC7M3       :1;                                       /* Output Compare 7 Mask Bit 3 */
    byte OC7M4       :1;                                       /* Output Compare 7 Mask Bit 4 */
    byte OC7M5       :1;                                       /* Output Compare 7 Mask Bit 5 */
    byte OC7M6       :1;                                       /* Output Compare 7 Mask Bit 6 */
    byte OC7M7       :1;                                       /* Output Compare 7 Mask Bit 7 */
  } Bits;
} OC7MSTR;
extern volatile OC7MSTR _OC7M @(REG_BASE + 0x00000042UL);
#define OC7M                            _OC7M.Byte
#define OC7M_OC7M0                      _OC7M.Bits.OC7M0
#define OC7M_OC7M1                      _OC7M.Bits.OC7M1
#define OC7M_OC7M2                      _OC7M.Bits.OC7M2
#define OC7M_OC7M3                      _OC7M.Bits.OC7M3
#define OC7M_OC7M4                      _OC7M.Bits.OC7M4
#define OC7M_OC7M5                      _OC7M.Bits.OC7M5
#define OC7M_OC7M6                      _OC7M.Bits.OC7M6
#define OC7M_OC7M7                      _OC7M.Bits.OC7M7

#define OC7M_OC7M0_MASK                 1U
#define OC7M_OC7M1_MASK                 2U
#define OC7M_OC7M2_MASK                 4U
#define OC7M_OC7M3_MASK                 8U
#define OC7M_OC7M4_MASK                 16U
#define OC7M_OC7M5_MASK                 32U
#define OC7M_OC7M6_MASK                 64U
#define OC7M_OC7M7_MASK                 128U


/*** OC7D - Output Compare 7 Data Register; 0x00000043 ***/
typedef union {
  byte Byte;
} OC7DSTR;
extern volatile OC7DSTR _OC7D @(REG_BASE + 0x00000043UL);
#define OC7D                            _OC7D.Byte


/*** TCNT - Timer Count Register; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCNTHi - Timer Count Register High; 0x00000044 ***/
    union {
      byte Byte;
    } TCNTHiSTR;
    #define TCNTHi                      _TCNT.Overlap_STR.TCNTHiSTR.Byte
    

    /*** TCNTLo - Timer Count Register Low; 0x00000045 ***/
    union {
      byte Byte;
    } TCNTLoSTR;
    #define TCNTLo                      _TCNT.Overlap_STR.TCNTLoSTR.Byte
    
  } Overlap_STR;

} TCNTSTR;
extern volatile TCNTSTR _TCNT @(REG_BASE + 0x00000044UL);
#define TCNT                            _TCNT.Word


/*** TSCR1 - Timer System Control Register1; 0x00000046 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PRNT        :1;                                       /* Precision Timer */
    byte TFFCA       :1;                                       /* Timer Fast Flag Clear All */
    byte TSFRZ       :1;                                       /* Timer and Modulus Counter Stop While in Freeze Mode */
    byte TSWAI       :1;                                       /* Timer Module Stops While in Wait */
    byte TEN         :1;                                       /* Timer Enable */
  } Bits;
} TSCR1STR;
extern volatile TSCR1STR _TSCR1 @(REG_BASE + 0x00000046UL);
#define TSCR1                           _TSCR1.Byte
#define TSCR1_PRNT                      _TSCR1.Bits.PRNT
#define TSCR1_TFFCA                     _TSCR1.Bits.TFFCA
#define TSCR1_TSFRZ                     _TSCR1.Bits.TSFRZ
#define TSCR1_TSWAI                     _TSCR1.Bits.TSWAI
#define TSCR1_TEN                       _TSCR1.Bits.TEN

#define TSCR1_PRNT_MASK                 8U
#define TSCR1_TFFCA_MASK                16U
#define TSCR1_TSFRZ_MASK                32U
#define TSCR1_TSWAI_MASK                64U
#define TSCR1_TEN_MASK                  128U


/*** TTOV - Timer Toggle On Overflow Register; 0x00000047 ***/
typedef union {
  byte Byte;
  struct {
    byte TOV0        :1;                                       /* Toggle On Overflow Bit 0 */
    byte TOV1        :1;                                       /* Toggle On Overflow Bit 1 */
    byte TOV2        :1;                                       /* Toggle On Overflow Bit 2 */
    byte TOV3        :1;                                       /* Toggle On Overflow Bit 3 */
    byte TOV4        :1;                                       /* Toggle On Overflow Bit 4 */
    byte TOV5        :1;                                       /* Toggle On Overflow Bit 5 */
    byte TOV6        :1;                                       /* Toggle On Overflow Bit 6 */
    byte TOV7        :1;                                       /* Toggle On Overflow Bit 7 */
  } Bits;
} TTOVSTR;
extern volatile TTOVSTR _TTOV @(REG_BASE + 0x00000047UL);
#define TTOV                            _TTOV.Byte
#define TTOV_TOV0                       _TTOV.Bits.TOV0
#define TTOV_TOV1                       _TTOV.Bits.TOV1
#define TTOV_TOV2                       _TTOV.Bits.TOV2
#define TTOV_TOV3                       _TTOV.Bits.TOV3
#define TTOV_TOV4                       _TTOV.Bits.TOV4
#define TTOV_TOV5                       _TTOV.Bits.TOV5
#define TTOV_TOV6                       _TTOV.Bits.TOV6
#define TTOV_TOV7                       _TTOV.Bits.TOV7

#define TTOV_TOV0_MASK                  1U
#define TTOV_TOV1_MASK                  2U
#define TTOV_TOV2_MASK                  4U
#define TTOV_TOV3_MASK                  8U
#define TTOV_TOV4_MASK                  16U
#define TTOV_TOV5_MASK                  32U
#define TTOV_TOV6_MASK                  64U
#define TTOV_TOV7_MASK                  128U


/*** TCTL1 - Timer Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte OL4         :1;                                       /* Output Level Bit 4 */
    byte OM4         :1;                                       /* Output Mode Bit 4 */
    byte OL5         :1;                                       /* Output Level Bit 5 */
    byte OM5         :1;                                       /* Output Mode Bit 5 */
    byte OL6         :1;                                       /* Output Level Bit 6 */
    byte OM6         :1;                                       /* Output Mode Bit 6 */
    byte OL7         :1;                                       /* Output Level Bit 7 */
    byte OM7         :1;                                       /* Output Mode Bit 7 */
  } Bits;
} TCTL1STR;
extern volatile TCTL1STR _TCTL1 @(REG_BASE + 0x00000048UL);
#define TCTL1                           _TCTL1.Byte
#define TCTL1_OL4                       _TCTL1.Bits.OL4
#define TCTL1_OM4                       _TCTL1.Bits.OM4
#define TCTL1_OL5                       _TCTL1.Bits.OL5
#define TCTL1_OM5                       _TCTL1.Bits.OM5
#define TCTL1_OL6                       _TCTL1.Bits.OL6
#define TCTL1_OM6                       _TCTL1.Bits.OM6
#define TCTL1_OL7                       _TCTL1.Bits.OL7
#define TCTL1_OM7                       _TCTL1.Bits.OM7

#define TCTL1_OL4_MASK                  1U
#define TCTL1_OM4_MASK                  2U
#define TCTL1_OL5_MASK                  4U
#define TCTL1_OM5_MASK                  8U
#define TCTL1_OL6_MASK                  16U
#define TCTL1_OM6_MASK                  32U
#define TCTL1_OL7_MASK                  64U
#define TCTL1_OM7_MASK                  128U


/*** TCTL2 - Timer Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte OL0         :1;                                       /* Output Level Bit 0 */
    byte OM0         :1;                                       /* Output Mode Bit 0 */
    byte OL1         :1;                                       /* Output Level Bit 1 */
    byte OM1         :1;                                       /* Output Mode Bit 1 */
    byte OL2         :1;                                       /* Output Level Bit 2 */
    byte OM2         :1;                                       /* Output Mode Bit 2 */
    byte OL3         :1;                                       /* Output Level Bit 3 */
    byte OM3         :1;                                       /* Output Mode Bit 3 */
  } Bits;
} TCTL2STR;
extern volatile TCTL2STR _TCTL2 @(REG_BASE + 0x00000049UL);
#define TCTL2                           _TCTL2.Byte
#define TCTL2_OL0                       _TCTL2.Bits.OL0
#define TCTL2_OM0                       _TCTL2.Bits.OM0
#define TCTL2_OL1                       _TCTL2.Bits.OL1
#define TCTL2_OM1                       _TCTL2.Bits.OM1
#define TCTL2_OL2                       _TCTL2.Bits.OL2
#define TCTL2_OM2                       _TCTL2.Bits.OM2
#define TCTL2_OL3                       _TCTL2.Bits.OL3
#define TCTL2_OM3                       _TCTL2.Bits.OM3

#define TCTL2_OL0_MASK                  1U
#define TCTL2_OM0_MASK                  2U
#define TCTL2_OL1_MASK                  4U
#define TCTL2_OM1_MASK                  8U
#define TCTL2_OL2_MASK                  16U
#define TCTL2_OM2_MASK                  32U
#define TCTL2_OL3_MASK                  64U
#define TCTL2_OM3_MASK                  128U


/*** TCTL3 - Timer Control Register 3; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte EDG4A       :1;                                       /* Input Capture Edge Control 4A */
    byte EDG4B       :1;                                       /* Input Capture Edge Control 4B */
    byte EDG5A       :1;                                       /* Input Capture Edge Control 5A */
    byte EDG5B       :1;                                       /* Input Capture Edge Control 5B */
    byte EDG6A       :1;                                       /* Input Capture Edge Control 6A */
    byte EDG6B       :1;                                       /* Input Capture Edge Control 6B */
    byte EDG7A       :1;                                       /* Input Capture Edge Control 7A */
    byte EDG7B       :1;                                       /* Input Capture Edge Control 7B */
  } Bits;
  struct {
    byte grpEDG4x :2;
    byte grpEDG5x :2;
    byte grpEDG6x :2;
    byte grpEDG7x :2;
  } MergedBits;
} TCTL3STR;
extern volatile TCTL3STR _TCTL3 @(REG_BASE + 0x0000004AUL);
#define TCTL3                           _TCTL3.Byte
#define TCTL3_EDG4A                     _TCTL3.Bits.EDG4A
#define TCTL3_EDG4B                     _TCTL3.Bits.EDG4B
#define TCTL3_EDG5A                     _TCTL3.Bits.EDG5A
#define TCTL3_EDG5B                     _TCTL3.Bits.EDG5B
#define TCTL3_EDG6A                     _TCTL3.Bits.EDG6A
#define TCTL3_EDG6B                     _TCTL3.Bits.EDG6B
#define TCTL3_EDG7A                     _TCTL3.Bits.EDG7A
#define TCTL3_EDG7B                     _TCTL3.Bits.EDG7B
#define TCTL3_EDG4x                     _TCTL3.MergedBits.grpEDG4x
#define TCTL3_EDG5x                     _TCTL3.MergedBits.grpEDG5x
#define TCTL3_EDG6x                     _TCTL3.MergedBits.grpEDG6x
#define TCTL3_EDG7x                     _TCTL3.MergedBits.grpEDG7x

#define TCTL3_EDG4A_MASK                1U
#define TCTL3_EDG4B_MASK                2U
#define TCTL3_EDG5A_MASK                4U
#define TCTL3_EDG5B_MASK                8U
#define TCTL3_EDG6A_MASK                16U
#define TCTL3_EDG6B_MASK                32U
#define TCTL3_EDG7A_MASK                64U
#define TCTL3_EDG7B_MASK                128U
#define TCTL3_EDG4x_MASK                3U
#define TCTL3_EDG4x_BITNUM              0U
#define TCTL3_EDG5x_MASK                12U
#define TCTL3_EDG5x_BITNUM              2U
#define TCTL3_EDG6x_MASK                48U
#define TCTL3_EDG6x_BITNUM              4U
#define TCTL3_EDG7x_MASK                192U
#define TCTL3_EDG7x_BITNUM              6U


/*** TCTL4 - Timer Control Register 4; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte EDG0A       :1;                                       /* Input Capture Edge Control 0A */
    byte EDG0B       :1;                                       /* Input Capture Edge Control 0B */
    byte EDG1A       :1;                                       /* Input Capture Edge Control 1A */
    byte EDG1B       :1;                                       /* Input Capture Edge Control 1B */
    byte EDG2A       :1;                                       /* Input Capture Edge Control 2A */
    byte EDG2B       :1;                                       /* Input Capture Edge Control 2B */
    byte EDG3A       :1;                                       /* Input Capture Edge Control 3A */
    byte EDG3B       :1;                                       /* Input Capture Edge Control 3B */
  } Bits;
  struct {
    byte grpEDG0x :2;
    byte grpEDG1x :2;
    byte grpEDG2x :2;
    byte grpEDG3x :2;
  } MergedBits;
} TCTL4STR;
extern volatile TCTL4STR _TCTL4 @(REG_BASE + 0x0000004BUL);
#define TCTL4                           _TCTL4.Byte
#define TCTL4_EDG0A                     _TCTL4.Bits.EDG0A
#define TCTL4_EDG0B                     _TCTL4.Bits.EDG0B
#define TCTL4_EDG1A                     _TCTL4.Bits.EDG1A
#define TCTL4_EDG1B                     _TCTL4.Bits.EDG1B
#define TCTL4_EDG2A                     _TCTL4.Bits.EDG2A
#define TCTL4_EDG2B                     _TCTL4.Bits.EDG2B
#define TCTL4_EDG3A                     _TCTL4.Bits.EDG3A
#define TCTL4_EDG3B                     _TCTL4.Bits.EDG3B
#define TCTL4_EDG0x                     _TCTL4.MergedBits.grpEDG0x
#define TCTL4_EDG1x                     _TCTL4.MergedBits.grpEDG1x
#define TCTL4_EDG2x                     _TCTL4.MergedBits.grpEDG2x
#define TCTL4_EDG3x                     _TCTL4.MergedBits.grpEDG3x

#define TCTL4_EDG0A_MASK                1U
#define TCTL4_EDG0B_MASK                2U
#define TCTL4_EDG1A_MASK                4U
#define TCTL4_EDG1B_MASK                8U
#define TCTL4_EDG2A_MASK                16U
#define TCTL4_EDG2B_MASK                32U
#define TCTL4_EDG3A_MASK                64U
#define TCTL4_EDG3B_MASK                128U
#define TCTL4_EDG0x_MASK                3U
#define TCTL4_EDG0x_BITNUM              0U
#define TCTL4_EDG1x_MASK                12U
#define TCTL4_EDG1x_BITNUM              2U
#define TCTL4_EDG2x_MASK                48U
#define TCTL4_EDG2x_BITNUM              4U
#define TCTL4_EDG3x_MASK                192U
#define TCTL4_EDG3x_BITNUM              6U


/*** TIE - Timer Interrupt Enable Register; 0x0000004C ***/
typedef union {
  byte Byte;
  struct {
    byte C0I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 0 */
    byte C1I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 1 */
    byte C2I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 2 */
    byte C3I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 3 */
    byte C4I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 4 */
    byte C5I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 5 */
    byte C6I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 6 */
    byte C7I         :1;                                       /* Input Capture/Output Compare Interrupt Enable Bit 7 */
  } Bits;
} TIESTR;
extern volatile TIESTR _TIE @(REG_BASE + 0x0000004CUL);
#define TIE                             _TIE.Byte
#define TIE_C0I                         _TIE.Bits.C0I
#define TIE_C1I                         _TIE.Bits.C1I
#define TIE_C2I                         _TIE.Bits.C2I
#define TIE_C3I                         _TIE.Bits.C3I
#define TIE_C4I                         _TIE.Bits.C4I
#define TIE_C5I                         _TIE.Bits.C5I
#define TIE_C6I                         _TIE.Bits.C6I
#define TIE_C7I                         _TIE.Bits.C7I

#define TIE_C0I_MASK                    1U
#define TIE_C1I_MASK                    2U
#define TIE_C2I_MASK                    4U
#define TIE_C3I_MASK                    8U
#define TIE_C4I_MASK                    16U
#define TIE_C5I_MASK                    32U
#define TIE_C6I_MASK                    64U
#define TIE_C7I_MASK                    128U


/*** TSCR2 - Timer System Control Register 2; 0x0000004D ***/
typedef union {
  byte Byte;
  struct {
    byte PR0         :1;                                       /* Timer Prescaler Select Bit 0 */
    byte PR1         :1;                                       /* Timer Prescaler Select Bit 1 */
    byte PR2         :1;                                       /* Timer Prescaler Select Bit 2 */
    byte TCRE        :1;                                       /* Timer Counter Reset Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOI         :1;                                       /* Timer Overflow Interrupt Enable */
  } Bits;
  struct {
    byte grpPR   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSCR2STR;
extern volatile TSCR2STR _TSCR2 @(REG_BASE + 0x0000004DUL);
#define TSCR2                           _TSCR2.Byte
#define TSCR2_PR0                       _TSCR2.Bits.PR0
#define TSCR2_PR1                       _TSCR2.Bits.PR1
#define TSCR2_PR2                       _TSCR2.Bits.PR2
#define TSCR2_TCRE                      _TSCR2.Bits.TCRE
#define TSCR2_TOI                       _TSCR2.Bits.TOI
#define TSCR2_PR                        _TSCR2.MergedBits.grpPR

#define TSCR2_PR0_MASK                  1U
#define TSCR2_PR1_MASK                  2U
#define TSCR2_PR2_MASK                  4U
#define TSCR2_TCRE_MASK                 8U
#define TSCR2_TOI_MASK                  128U
#define TSCR2_PR_MASK                   7U
#define TSCR2_PR_BITNUM                 0U


/*** TFLG1 - Main Timer Interrupt Flag 1; 0x0000004E ***/
typedef union {
  byte Byte;
  struct {
    byte C0F         :1;                                       /* Input Capture/Output Compare Channel Flag 0 */
    byte C1F         :1;                                       /* Input Capture/Output Compare Channel Flag 1 */
    byte C2F         :1;                                       /* Input Capture/Output Compare Channel Flag 2 */
    byte C3F         :1;                                       /* Input Capture/Output Compare Channel Flag 3 */
    byte C4F         :1;                                       /* Input Capture/Output Compare Channel Flag 4 */
    byte C5F         :1;                                       /* Input Capture/Output Compare Channel Flag 5 */
    byte C6F         :1;                                       /* Input Capture/Output Compare Channel Flag 6 */
    byte C7F         :1;                                       /* Input Capture/Output Compare Channel Flag 7 */
  } Bits;
} TFLG1STR;
extern volatile TFLG1STR _TFLG1 @(REG_BASE + 0x0000004EUL);
#define TFLG1                           _TFLG1.Byte
#define TFLG1_C0F                       _TFLG1.Bits.C0F
#define TFLG1_C1F                       _TFLG1.Bits.C1F
#define TFLG1_C2F                       _TFLG1.Bits.C2F
#define TFLG1_C3F                       _TFLG1.Bits.C3F
#define TFLG1_C4F                       _TFLG1.Bits.C4F
#define TFLG1_C5F                       _TFLG1.Bits.C5F
#define TFLG1_C6F                       _TFLG1.Bits.C6F
#define TFLG1_C7F                       _TFLG1.Bits.C7F

#define TFLG1_C0F_MASK                  1U
#define TFLG1_C1F_MASK                  2U
#define TFLG1_C2F_MASK                  4U
#define TFLG1_C3F_MASK                  8U
#define TFLG1_C4F_MASK                  16U
#define TFLG1_C5F_MASK                  32U
#define TFLG1_C6F_MASK                  64U
#define TFLG1_C7F_MASK                  128U


/*** TFLG2 - Main Timer Interrupt Flag 2; 0x0000004F ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
} TFLG2STR;
extern volatile TFLG2STR _TFLG2 @(REG_BASE + 0x0000004FUL);
#define TFLG2                           _TFLG2.Byte
#define TFLG2_TOF                       _TFLG2.Bits.TOF

#define TFLG2_TOF_MASK                  128U


/*** TC0 - Timer Input Capture/Output Compare Register 0; 0x00000050 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hi - Timer Input Capture/Output Compare Register 0 High; 0x00000050 ***/
    union {
      byte Byte;
    } TC0HiSTR;
    #define TC0Hi                       _TC0.Overlap_STR.TC0HiSTR.Byte
    

    /*** TC0Lo - Timer Input Capture/Output Compare Register 0 Low; 0x00000051 ***/
    union {
      byte Byte;
    } TC0LoSTR;
    #define TC0Lo                       _TC0.Overlap_STR.TC0LoSTR.Byte
    
  } Overlap_STR;

} TC0STR;
extern volatile TC0STR _TC0 @(REG_BASE + 0x00000050UL);
#define TC0                             _TC0.Word
/* TC_ARR: Access 8 TCx registers in an array */
#define TC_ARR                          ((volatile word *) &TC0)


/*** TC1 - Timer Input Capture/Output Compare Register 1; 0x00000052 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hi - Timer Input Capture/Output Compare Register 1 High; 0x00000052 ***/
    union {
      byte Byte;
    } TC1HiSTR;
    #define TC1Hi                       _TC1.Overlap_STR.TC1HiSTR.Byte
    

    /*** TC1Lo - Timer Input Capture/Output Compare Register 1 Low; 0x00000053 ***/
    union {
      byte Byte;
    } TC1LoSTR;
    #define TC1Lo                       _TC1.Overlap_STR.TC1LoSTR.Byte
    
  } Overlap_STR;

} TC1STR;
extern volatile TC1STR _TC1 @(REG_BASE + 0x00000052UL);
#define TC1                             _TC1.Word


/*** TC2 - Timer Input Capture/Output Compare Register 2; 0x00000054 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hi - Timer Input Capture/Output Compare Register 2 High; 0x00000054 ***/
    union {
      byte Byte;
    } TC2HiSTR;
    #define TC2Hi                       _TC2.Overlap_STR.TC2HiSTR.Byte
    

    /*** TC2Lo - Timer Input Capture/Output Compare Register 2 Low; 0x00000055 ***/
    union {
      byte Byte;
    } TC2LoSTR;
    #define TC2Lo                       _TC2.Overlap_STR.TC2LoSTR.Byte
    
  } Overlap_STR;

} TC2STR;
extern volatile TC2STR _TC2 @(REG_BASE + 0x00000054UL);
#define TC2                             _TC2.Word


/*** TC3 - Timer Input Capture/Output Compare Register 3; 0x00000056 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hi - Timer Input Capture/Output Compare Register 3 High; 0x00000056 ***/
    union {
      byte Byte;
    } TC3HiSTR;
    #define TC3Hi                       _TC3.Overlap_STR.TC3HiSTR.Byte
    

    /*** TC3Lo - Timer Input Capture/Output Compare Register 3 Low; 0x00000057 ***/
    union {
      byte Byte;
    } TC3LoSTR;
    #define TC3Lo                       _TC3.Overlap_STR.TC3LoSTR.Byte
    
  } Overlap_STR;

} TC3STR;
extern volatile TC3STR _TC3 @(REG_BASE + 0x00000056UL);
#define TC3                             _TC3.Word


/*** TC4 - Timer Input Capture/Output Compare Register 4; 0x00000058 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC4Hi - Timer Input Capture/Output Compare Register 4 High; 0x00000058 ***/
    union {
      byte Byte;
    } TC4HiSTR;
    #define TC4Hi                       _TC4.Overlap_STR.TC4HiSTR.Byte
    

    /*** TC4Lo - Timer Input Capture/Output Compare Register 4 Low; 0x00000059 ***/
    union {
      byte Byte;
    } TC4LoSTR;
    #define TC4Lo                       _TC4.Overlap_STR.TC4LoSTR.Byte
    
  } Overlap_STR;

} TC4STR;
extern volatile TC4STR _TC4 @(REG_BASE + 0x00000058UL);
#define TC4                             _TC4.Word


/*** TC5 - Timer Input Capture/Output Compare Register 5; 0x0000005A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC5Hi - Timer Input Capture/Output Compare Register 5 High; 0x0000005A ***/
    union {
      byte Byte;
    } TC5HiSTR;
    #define TC5Hi                       _TC5.Overlap_STR.TC5HiSTR.Byte
    

    /*** TC5Lo - Timer Input Capture/Output Compare Register 5 Low; 0x0000005B ***/
    union {
      byte Byte;
    } TC5LoSTR;
    #define TC5Lo                       _TC5.Overlap_STR.TC5LoSTR.Byte
    
  } Overlap_STR;

} TC5STR;
extern volatile TC5STR _TC5 @(REG_BASE + 0x0000005AUL);
#define TC5                             _TC5.Word


/*** TC6 - Timer Input Capture/Output Compare Register 6; 0x0000005C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC6Hi - Timer Input Capture/Output Compare Register 6 High; 0x0000005C ***/
    union {
      byte Byte;
    } TC6HiSTR;
    #define TC6Hi                       _TC6.Overlap_STR.TC6HiSTR.Byte
    

    /*** TC6Lo - Timer Input Capture/Output Compare Register 6 Low; 0x0000005D ***/
    union {
      byte Byte;
    } TC6LoSTR;
    #define TC6Lo                       _TC6.Overlap_STR.TC6LoSTR.Byte
    
  } Overlap_STR;

} TC6STR;
extern volatile TC6STR _TC6 @(REG_BASE + 0x0000005CUL);
#define TC6                             _TC6.Word


/*** TC7 - Timer Input Capture/Output Compare Register 7; 0x0000005E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC7Hi - Timer Input Capture/Output Compare Register 7 High; 0x0000005E ***/
    union {
      byte Byte;
    } TC7HiSTR;
    #define TC7Hi                       _TC7.Overlap_STR.TC7HiSTR.Byte
    

    /*** TC7Lo - Timer Input Capture/Output Compare Register 7 Low; 0x0000005F ***/
    union {
      byte Byte;
    } TC7LoSTR;
    #define TC7Lo                       _TC7.Overlap_STR.TC7LoSTR.Byte
    
  } Overlap_STR;

} TC7STR;
extern volatile TC7STR _TC7 @(REG_BASE + 0x0000005EUL);
#define TC7                             _TC7.Word


/*** PACTL - 16-Bit Pulse Accumulator A Control Register; 0x00000060 ***/
typedef union {
  byte Byte;
  struct {
    byte PAI         :1;                                       /* Pulse Accumulator Input Interrupt enable */
    byte PAOVI       :1;                                       /* Pulse Accumulator A Overflow Interrupt enable */
    byte CLK0        :1;                                       /* Clock Select Bit 0 */
    byte CLK1        :1;                                       /* Clock Select Bit 1 */
    byte PEDGE       :1;                                       /* Pulse Accumulator Edge Control */
    byte PAMOD       :1;                                       /* Pulse Accumulator Mode */
    byte PAEN        :1;                                       /* Pulse Accumulator A System Enable */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLK  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PACTLSTR;
extern volatile PACTLSTR _PACTL @(REG_BASE + 0x00000060UL);
#define PACTL                           _PACTL.Byte
#define PACTL_PAI                       _PACTL.Bits.PAI
#define PACTL_PAOVI                     _PACTL.Bits.PAOVI
#define PACTL_CLK0                      _PACTL.Bits.CLK0
#define PACTL_CLK1                      _PACTL.Bits.CLK1
#define PACTL_PEDGE                     _PACTL.Bits.PEDGE
#define PACTL_PAMOD                     _PACTL.Bits.PAMOD
#define PACTL_PAEN                      _PACTL.Bits.PAEN
#define PACTL_CLK                       _PACTL.MergedBits.grpCLK

#define PACTL_PAI_MASK                  1U
#define PACTL_PAOVI_MASK                2U
#define PACTL_CLK0_MASK                 4U
#define PACTL_CLK1_MASK                 8U
#define PACTL_PEDGE_MASK                16U
#define PACTL_PAMOD_MASK                32U
#define PACTL_PAEN_MASK                 64U
#define PACTL_CLK_MASK                  12U
#define PACTL_CLK_BITNUM                2U


/*** PAFLG - Pulse Accumulator A Flag Register; 0x00000061 ***/
typedef union {
  byte Byte;
  struct {
    byte PAIF        :1;                                       /* Pulse Accumulator Input edge Flag */
    byte PAOVF       :1;                                       /* Pulse Accumulator A Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PAFLGSTR;
extern volatile PAFLGSTR _PAFLG @(REG_BASE + 0x00000061UL);
#define PAFLG                           _PAFLG.Byte
#define PAFLG_PAIF                      _PAFLG.Bits.PAIF
#define PAFLG_PAOVF                     _PAFLG.Bits.PAOVF

#define PAFLG_PAIF_MASK                 1U
#define PAFLG_PAOVF_MASK                2U


/*** PACN32 - Pulse Accumulators Count 32 Register; 0x00000062 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PACN3 - Pulse Accumulators Count 3 Register; 0x00000062 ***/
    union {
      byte Byte;
    } PACN3STR;
    #define PACN3                       _PACN32.Overlap_STR.PACN3STR.Byte
    

    /*** PACN2 - Pulse Accumulators Count 2 Register; 0x00000063 ***/
    union {
      byte Byte;
    } PACN2STR;
    #define PACN2                       _PACN32.Overlap_STR.PACN2STR.Byte
    
  } Overlap_STR;

} PACN32STR;
extern volatile PACN32STR _PACN32 @(REG_BASE + 0x00000062UL);
#define PACN32                          _PACN32.Word


/*** PACN10 - Pulse Accumulators Count 10 Register; 0x00000064 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PACN1 - Pulse Accumulators Count 1 Register; 0x00000064 ***/
    union {
      byte Byte;
    } PACN1STR;
    #define PACN1                       _PACN10.Overlap_STR.PACN1STR.Byte
    

    /*** PACN0 - Pulse Accumulators Count 0 Register; 0x00000065 ***/
    union {
      byte Byte;
    } PACN0STR;
    #define PACN0                       _PACN10.Overlap_STR.PACN0STR.Byte
    
  } Overlap_STR;

} PACN10STR;
extern volatile PACN10STR _PACN10 @(REG_BASE + 0x00000064UL);
#define PACN10                          _PACN10.Word


/*** MCCTL - Modulus Down Counter underflow; 0x00000066 ***/
typedef union {
  byte Byte;
  struct {
    byte MCPR0       :1;                                       /* Modulus Counter Prescaler select 0 */
    byte MCPR1       :1;                                       /* Modulus Counter Prescaler select 1 */
    byte MCEN        :1;                                       /* Modulus Down-Counter Enable */
    byte FLMC        :1;                                       /* Force Load Register into the Modulus Counter Count Register */
    byte ICLAT       :1;                                       /* Input Capture Force Latch Action */
    byte RDMCL       :1;                                       /* Read Modulus Down-Counter Load */
    byte MODMC       :1;                                       /* Modulus Mode Enable */
    byte MCZI        :1;                                       /* Modulus Counter Underflow Interrupt Enable */
  } Bits;
  struct {
    byte grpMCPR :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MCCTLSTR;
extern volatile MCCTLSTR _MCCTL @(REG_BASE + 0x00000066UL);
#define MCCTL                           _MCCTL.Byte
#define MCCTL_MCPR0                     _MCCTL.Bits.MCPR0
#define MCCTL_MCPR1                     _MCCTL.Bits.MCPR1
#define MCCTL_MCEN                      _MCCTL.Bits.MCEN
#define MCCTL_FLMC                      _MCCTL.Bits.FLMC
#define MCCTL_ICLAT                     _MCCTL.Bits.ICLAT
#define MCCTL_RDMCL                     _MCCTL.Bits.RDMCL
#define MCCTL_MODMC                     _MCCTL.Bits.MODMC
#define MCCTL_MCZI                      _MCCTL.Bits.MCZI
#define MCCTL_MCPR                      _MCCTL.MergedBits.grpMCPR

#define MCCTL_MCPR0_MASK                1U
#define MCCTL_MCPR1_MASK                2U
#define MCCTL_MCEN_MASK                 4U
#define MCCTL_FLMC_MASK                 8U
#define MCCTL_ICLAT_MASK                16U
#define MCCTL_RDMCL_MASK                32U
#define MCCTL_MODMC_MASK                64U
#define MCCTL_MCZI_MASK                 128U
#define MCCTL_MCPR_MASK                 3U
#define MCCTL_MCPR_BITNUM               0U


/*** MCFLG - 16-Bit Modulus Down Counter Flag Register; 0x00000067 ***/
typedef union {
  byte Byte;
  struct {
    byte POLF0       :1;                                       /* First Input Capture Polarity Status 0 */
    byte POLF1       :1;                                       /* First Input Capture Polarity Status 1 */
    byte POLF2       :1;                                       /* First Input Capture Polarity Status 2 */
    byte POLF3       :1;                                       /* First Input Capture Polarity Status 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MCZF        :1;                                       /* Modulus Counter Underflow Flag */
  } Bits;
  struct {
    byte grpPOLF :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} MCFLGSTR;
extern volatile MCFLGSTR _MCFLG @(REG_BASE + 0x00000067UL);
#define MCFLG                           _MCFLG.Byte
#define MCFLG_POLF0                     _MCFLG.Bits.POLF0
#define MCFLG_POLF1                     _MCFLG.Bits.POLF1
#define MCFLG_POLF2                     _MCFLG.Bits.POLF2
#define MCFLG_POLF3                     _MCFLG.Bits.POLF3
#define MCFLG_MCZF                      _MCFLG.Bits.MCZF
#define MCFLG_POLF                      _MCFLG.MergedBits.grpPOLF

#define MCFLG_POLF0_MASK                1U
#define MCFLG_POLF1_MASK                2U
#define MCFLG_POLF2_MASK                4U
#define MCFLG_POLF3_MASK                8U
#define MCFLG_MCZF_MASK                 128U
#define MCFLG_POLF_MASK                 15U
#define MCFLG_POLF_BITNUM               0U


/*** ICPAR - Input Control Pulse Accumulator Register; 0x00000068 ***/
typedef union {
  byte Byte;
  struct {
    byte PA0EN       :1;                                       /* 8-Bit Pulse Accumulator 0 Enable */
    byte PA1EN       :1;                                       /* 8-Bit Pulse Accumulator 1 Enable */
    byte PA2EN       :1;                                       /* 8-Bit Pulse Accumulator 2 Enable */
    byte PA3EN       :1;                                       /* 8-Bit Pulse Accumulator 3 Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ICPARSTR;
extern volatile ICPARSTR _ICPAR @(REG_BASE + 0x00000068UL);
#define ICPAR                           _ICPAR.Byte
#define ICPAR_PA0EN                     _ICPAR.Bits.PA0EN
#define ICPAR_PA1EN                     _ICPAR.Bits.PA1EN
#define ICPAR_PA2EN                     _ICPAR.Bits.PA2EN
#define ICPAR_PA3EN                     _ICPAR.Bits.PA3EN

#define ICPAR_PA0EN_MASK                1U
#define ICPAR_PA1EN_MASK                2U
#define ICPAR_PA2EN_MASK                4U
#define ICPAR_PA3EN_MASK                8U


/*** DLYCT - Delay Counter Control Register; 0x00000069 ***/
typedef union {
  byte Byte;
  struct {
    byte DLY0        :1;                                       /* Delay Counter Select Bit 0 */
    byte DLY1        :1;                                       /* Delay Counter Select Bit 1 */
    byte DLY2        :1;                                       /* Delay Counter Select Bit 2 */
    byte DLY3        :1;                                       /* Delay Counter Select Bit 3 */
    byte DLY4        :1;                                       /* Delay Counter Select Bit 4 */
    byte DLY5        :1;                                       /* Delay Counter Select Bit 5 */
    byte DLY6        :1;                                       /* Delay Counter Select Bit 6 */
    byte DLY7        :1;                                       /* Delay Counter Select Bit 7 */
  } Bits;
} DLYCTSTR;
extern volatile DLYCTSTR _DLYCT @(REG_BASE + 0x00000069UL);
#define DLYCT                           _DLYCT.Byte
#define DLYCT_DLY0                      _DLYCT.Bits.DLY0
#define DLYCT_DLY1                      _DLYCT.Bits.DLY1
#define DLYCT_DLY2                      _DLYCT.Bits.DLY2
#define DLYCT_DLY3                      _DLYCT.Bits.DLY3
#define DLYCT_DLY4                      _DLYCT.Bits.DLY4
#define DLYCT_DLY5                      _DLYCT.Bits.DLY5
#define DLYCT_DLY6                      _DLYCT.Bits.DLY6
#define DLYCT_DLY7                      _DLYCT.Bits.DLY7

#define DLYCT_DLY0_MASK                 1U
#define DLYCT_DLY1_MASK                 2U
#define DLYCT_DLY2_MASK                 4U
#define DLYCT_DLY3_MASK                 8U
#define DLYCT_DLY4_MASK                 16U
#define DLYCT_DLY5_MASK                 32U
#define DLYCT_DLY6_MASK                 64U
#define DLYCT_DLY7_MASK                 128U


/*** ICOVW - Input Control Overwrite Register; 0x0000006A ***/
typedef union {
  byte Byte;
  struct {
    byte NOVW0       :1;                                       /* No Input Capture Overwrite 0 */
    byte NOVW1       :1;                                       /* No Input Capture Overwrite 1 */
    byte NOVW2       :1;                                       /* No Input Capture Overwrite 2 */
    byte NOVW3       :1;                                       /* No Input Capture Overwrite 3 */
    byte NOVW4       :1;                                       /* No Input Capture Overwrite 4 */
    byte NOVW5       :1;                                       /* No Input Capture Overwrite 5 */
    byte NOVW6       :1;                                       /* No Input Capture Overwrite 6 */
    byte NOVW7       :1;                                       /* No Input Capture Overwrite 7 */
  } Bits;
} ICOVWSTR;
extern volatile ICOVWSTR _ICOVW @(REG_BASE + 0x0000006AUL);
#define ICOVW                           _ICOVW.Byte
#define ICOVW_NOVW0                     _ICOVW.Bits.NOVW0
#define ICOVW_NOVW1                     _ICOVW.Bits.NOVW1
#define ICOVW_NOVW2                     _ICOVW.Bits.NOVW2
#define ICOVW_NOVW3                     _ICOVW.Bits.NOVW3
#define ICOVW_NOVW4                     _ICOVW.Bits.NOVW4
#define ICOVW_NOVW5                     _ICOVW.Bits.NOVW5
#define ICOVW_NOVW6                     _ICOVW.Bits.NOVW6
#define ICOVW_NOVW7                     _ICOVW.Bits.NOVW7

#define ICOVW_NOVW0_MASK                1U
#define ICOVW_NOVW1_MASK                2U
#define ICOVW_NOVW2_MASK                4U
#define ICOVW_NOVW3_MASK                8U
#define ICOVW_NOVW4_MASK                16U
#define ICOVW_NOVW5_MASK                32U
#define ICOVW_NOVW6_MASK                64U
#define ICOVW_NOVW7_MASK                128U


/*** ICSYS - Input Control System Control Register; 0x0000006B ***/
typedef union {
  byte Byte;
  struct {
    byte LATQ        :1;                                       /* Input Control Latch or Queue Mode Enable */
    byte BUFEN       :1;                                       /* IC Buffer Enable */
    byte PACMX       :1;                                       /* 8-Bit Pulse Accumulators Maximum Count */
    byte TFMOD       :1;                                       /* Timer Flag-setting Mode */
    byte SH04        :1;                                       /* Share Input action of Input Capture Channels 0 and 4 */
    byte SH15        :1;                                       /* Share Input action of Input Capture Channels 1 and 5 */
    byte SH26        :1;                                       /* Share Input action of Input Capture Channels 2 and 6 */
    byte SH37        :1;                                       /* Share Input action of Input Capture Channels 3 and 7 */
  } Bits;
} ICSYSSTR;
extern volatile ICSYSSTR _ICSYS @(REG_BASE + 0x0000006BUL);
#define ICSYS                           _ICSYS.Byte
#define ICSYS_LATQ                      _ICSYS.Bits.LATQ
#define ICSYS_BUFEN                     _ICSYS.Bits.BUFEN
#define ICSYS_PACMX                     _ICSYS.Bits.PACMX
#define ICSYS_TFMOD                     _ICSYS.Bits.TFMOD
#define ICSYS_SH04                      _ICSYS.Bits.SH04
#define ICSYS_SH15                      _ICSYS.Bits.SH15
#define ICSYS_SH26                      _ICSYS.Bits.SH26
#define ICSYS_SH37                      _ICSYS.Bits.SH37

#define ICSYS_LATQ_MASK                 1U
#define ICSYS_BUFEN_MASK                2U
#define ICSYS_PACMX_MASK                4U
#define ICSYS_TFMOD_MASK                8U
#define ICSYS_SH04_MASK                 16U
#define ICSYS_SH15_MASK                 32U
#define ICSYS_SH26_MASK                 64U
#define ICSYS_SH37_MASK                 128U


/*** PTPSR - Precision Timer Prescaler Select; 0x0000006E ***/
typedef union {
  byte Byte;
  struct {
    byte PTPS0       :1;                                       /* Precision Timer Prescaler Select Bit 0 */
    byte PTPS1       :1;                                       /* Precision Timer Prescaler Select Bit 1 */
    byte PTPS2       :1;                                       /* Precision Timer Prescaler Select Bit 2 */
    byte PTPS3       :1;                                       /* Precision Timer Prescaler Select Bit 3 */
    byte PTPS4       :1;                                       /* Precision Timer Prescaler Select Bit 4 */
    byte PTPS5       :1;                                       /* Precision Timer Prescaler Select Bit 5 */
    byte PTPS6       :1;                                       /* Precision Timer Prescaler Select Bit 6 */
    byte PTPS7       :1;                                       /* Precision Timer Prescaler Select Bit 7 */
  } Bits;
} PTPSRSTR;
extern volatile PTPSRSTR _PTPSR @(REG_BASE + 0x0000006EUL);
#define PTPSR                           _PTPSR.Byte
#define PTPSR_PTPS0                     _PTPSR.Bits.PTPS0
#define PTPSR_PTPS1                     _PTPSR.Bits.PTPS1
#define PTPSR_PTPS2                     _PTPSR.Bits.PTPS2
#define PTPSR_PTPS3                     _PTPSR.Bits.PTPS3
#define PTPSR_PTPS4                     _PTPSR.Bits.PTPS4
#define PTPSR_PTPS5                     _PTPSR.Bits.PTPS5
#define PTPSR_PTPS6                     _PTPSR.Bits.PTPS6
#define PTPSR_PTPS7                     _PTPSR.Bits.PTPS7

#define PTPSR_PTPS0_MASK                1U
#define PTPSR_PTPS1_MASK                2U
#define PTPSR_PTPS2_MASK                4U
#define PTPSR_PTPS3_MASK                8U
#define PTPSR_PTPS4_MASK                16U
#define PTPSR_PTPS5_MASK                32U
#define PTPSR_PTPS6_MASK                64U
#define PTPSR_PTPS7_MASK                128U


/*** PTMCPSR - Precision Timer Modulus Counter Prescaler Select Register; 0x0000006F ***/
typedef union {
  byte Byte;
  struct {
    byte PTMPS0      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 0 */
    byte PTMPS1      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 1 */
    byte PTMPS2      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 2 */
    byte PTMPS3      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 3 */
    byte PTMPS4      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 4 */
    byte PTMPS5      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 5 */
    byte PTMPS6      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 6 */
    byte PTMPS7      :1;                                       /* Precision Timer Modulus Counter Prescaler Select bit 7 */
  } Bits;
} PTMCPSRSTR;
extern volatile PTMCPSRSTR _PTMCPSR @(REG_BASE + 0x0000006FUL);
#define PTMCPSR                         _PTMCPSR.Byte
#define PTMCPSR_PTMPS0                  _PTMCPSR.Bits.PTMPS0
#define PTMCPSR_PTMPS1                  _PTMCPSR.Bits.PTMPS1
#define PTMCPSR_PTMPS2                  _PTMCPSR.Bits.PTMPS2
#define PTMCPSR_PTMPS3                  _PTMCPSR.Bits.PTMPS3
#define PTMCPSR_PTMPS4                  _PTMCPSR.Bits.PTMPS4
#define PTMCPSR_PTMPS5                  _PTMCPSR.Bits.PTMPS5
#define PTMCPSR_PTMPS6                  _PTMCPSR.Bits.PTMPS6
#define PTMCPSR_PTMPS7                  _PTMCPSR.Bits.PTMPS7

#define PTMCPSR_PTMPS0_MASK             1U
#define PTMCPSR_PTMPS1_MASK             2U
#define PTMCPSR_PTMPS2_MASK             4U
#define PTMCPSR_PTMPS3_MASK             8U
#define PTMCPSR_PTMPS4_MASK             16U
#define PTMCPSR_PTMPS5_MASK             32U
#define PTMCPSR_PTMPS6_MASK             64U
#define PTMCPSR_PTMPS7_MASK             128U


/*** PBCTL - 16-Bit Pulse Accumulator B Control Register; 0x00000070 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PBOVI       :1;                                       /* Pulse Accumulator B Overflow Interrupt enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PBEN        :1;                                       /* Pulse Accumulator B System Enable */
    byte             :1; 
  } Bits;
} PBCTLSTR;
extern volatile PBCTLSTR _PBCTL @(REG_BASE + 0x00000070UL);
#define PBCTL                           _PBCTL.Byte
#define PBCTL_PBOVI                     _PBCTL.Bits.PBOVI
#define PBCTL_PBEN                      _PBCTL.Bits.PBEN

#define PBCTL_PBOVI_MASK                2U
#define PBCTL_PBEN_MASK                 64U


/*** PBFLG - Pulse Accumulator B Flag Register; 0x00000071 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte PBOVF       :1;                                       /* Pulse Accumulator B Overflow Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PBFLGSTR;
extern volatile PBFLGSTR _PBFLG @(REG_BASE + 0x00000071UL);
#define PBFLG                           _PBFLG.Byte
#define PBFLG_PBOVF                     _PBFLG.Bits.PBOVF

#define PBFLG_PBOVF_MASK                2U


/*** PA32H - 8-Bit Pulse Accumulators Holding 32 Register; 0x00000072 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PA3H - 8-Bit Pulse Accumulators Holding 3 Register; 0x00000072 ***/
    union {
      byte Byte;
    } PA3HSTR;
    #define PA3H                        _PA32H.Overlap_STR.PA3HSTR.Byte
    

    /*** PA2H - 8-Bit Pulse Accumulators Holding 2 Register; 0x00000073 ***/
    union {
      byte Byte;
    } PA2HSTR;
    #define PA2H                        _PA32H.Overlap_STR.PA2HSTR.Byte
    
  } Overlap_STR;

} PA32HSTR;
extern volatile PA32HSTR _PA32H @(REG_BASE + 0x00000072UL);
#define PA32H                           _PA32H.Word


/*** PA10H - 8-Bit Pulse Accumulators Holding 10 Register; 0x00000074 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PA1H - 8-Bit Pulse Accumulators Holding 1 Register; 0x00000074 ***/
    union {
      byte Byte;
    } PA1HSTR;
    #define PA1H                        _PA10H.Overlap_STR.PA1HSTR.Byte
    

    /*** PA0H - 8-Bit Pulse Accumulators Holding 0 Register; 0x00000075 ***/
    union {
      byte Byte;
    } PA0HSTR;
    #define PA0H                        _PA10H.Overlap_STR.PA0HSTR.Byte
    
  } Overlap_STR;

} PA10HSTR;
extern volatile PA10HSTR _PA10H @(REG_BASE + 0x00000074UL);
#define PA10H                           _PA10H.Word


/*** MCCNT - Modulus Down-Counter Count Register; 0x00000076 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MCCNThi - Modulus Down-Counter Count Register High; 0x00000076 ***/
    union {
      byte Byte;
    } MCCNThiSTR;
    #define MCCNThi                     _MCCNT.Overlap_STR.MCCNThiSTR.Byte
    

    /*** MCCNTlo - Modulus Down-Counter Count Register Low; 0x00000077 ***/
    union {
      byte Byte;
    } MCCNTloSTR;
    #define MCCNTlo                     _MCCNT.Overlap_STR.MCCNTloSTR.Byte
    
  } Overlap_STR;

} MCCNTSTR;
extern volatile MCCNTSTR _MCCNT @(REG_BASE + 0x00000076UL);
#define MCCNT                           _MCCNT.Word


/*** TC0H - Timer Input Capture Holding Registers 0; 0x00000078 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC0Hhi - Timer Input Capture Holding Registers 0 High; 0x00000078 ***/
    union {
      byte Byte;
    } TC0HhiSTR;
    #define TC0Hhi                      _TC0H.Overlap_STR.TC0HhiSTR.Byte
    

    /*** TC0Hlo - Timer Input Capture Holding Registers 0 Low; 0x00000079 ***/
    union {
      byte Byte;
    } TC0HloSTR;
    #define TC0Hlo                      _TC0H.Overlap_STR.TC0HloSTR.Byte
    
  } Overlap_STR;

} TC0HSTR;
extern volatile TC0HSTR _TC0H @(REG_BASE + 0x00000078UL);
#define TC0H                            _TC0H.Word


/*** TC1H - Timer Input Capture Holding Registers 1; 0x0000007A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC1Hhi - Timer Input Capture Holding Registers 1 High; 0x0000007A ***/
    union {
      byte Byte;
    } TC1HhiSTR;
    #define TC1Hhi                      _TC1H.Overlap_STR.TC1HhiSTR.Byte
    

    /*** TC1Hlo - Timer Input Capture Holding Registers 1 Low; 0x0000007B ***/
    union {
      byte Byte;
    } TC1HloSTR;
    #define TC1Hlo                      _TC1H.Overlap_STR.TC1HloSTR.Byte
    
  } Overlap_STR;

} TC1HSTR;
extern volatile TC1HSTR _TC1H @(REG_BASE + 0x0000007AUL);
#define TC1H                            _TC1H.Word


/*** TC2H - Timer Input Capture Holding Registers 2; 0x0000007C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC2Hhi - Timer Input Capture Holding Registers 2 High; 0x0000007C ***/
    union {
      byte Byte;
    } TC2HhiSTR;
    #define TC2Hhi                      _TC2H.Overlap_STR.TC2HhiSTR.Byte
    

    /*** TC2Hlo - Timer Input Capture Holding Registers 2 Low; 0x0000007D ***/
    union {
      byte Byte;
    } TC2HloSTR;
    #define TC2Hlo                      _TC2H.Overlap_STR.TC2HloSTR.Byte
    
  } Overlap_STR;

} TC2HSTR;
extern volatile TC2HSTR _TC2H @(REG_BASE + 0x0000007CUL);
#define TC2H                            _TC2H.Word


/*** TC3H - Timer Input Capture Holding Registers 3; 0x0000007E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TC3Hhi - Timer Input Capture Holding Registers 3 High; 0x0000007E ***/
    union {
      byte Byte;
    } TC3HhiSTR;
    #define TC3Hhi                      _TC3H.Overlap_STR.TC3HhiSTR.Byte
    

    /*** TC3Hlo - Timer Input Capture Holding Registers 3 Low; 0x0000007F ***/
    union {
      byte Byte;
    } TC3HloSTR;
    #define TC3Hlo                      _TC3H.Overlap_STR.TC3HloSTR.Byte
    
  } Overlap_STR;

} TC3HSTR;
extern volatile TC3HSTR _TC3H @(REG_BASE + 0x0000007EUL);
#define TC3H                            _TC3H.Word


/*** ATD1CTL01 - ATD 1 Control Register 01; 0x00000080 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL0 - ATD 1 Control Register 0; 0x00000080 ***/
    union {
      byte Byte;
      struct {
        byte WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
        byte WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
        byte WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
        byte WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpWRAP :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL0STR;
    #define ATD1CTL0                    _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Byte
    #define ATD1CTL0_WRAP0              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP0
    #define ATD1CTL0_WRAP1              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP1
    #define ATD1CTL0_WRAP2              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP2
    #define ATD1CTL0_WRAP3              _ATD1CTL01.Overlap_STR.ATD1CTL0STR.Bits.WRAP3
    /* ATD1CTL_ARR: Access 6 ATD1CTLx registers in an array */
    #define ATD1CTL_ARR                 ((volatile byte *) &ATD1CTL0)
    #define ATD1CTL0_WRAP               _ATD1CTL01.Overlap_STR.ATD1CTL0STR.MergedBits.grpWRAP
    
    #define ATD1CTL0_WRAP0_MASK         1U
    #define ATD1CTL0_WRAP1_MASK         2U
    #define ATD1CTL0_WRAP2_MASK         4U
    #define ATD1CTL0_WRAP3_MASK         8U
    #define ATD1CTL0_WRAP_MASK          15U
    #define ATD1CTL0_WRAP_BITNUM        0U
    

    /*** ATD1CTL1 - ATD1 Control Register 1; 0x00000081 ***/
    union {
      byte Byte;
      struct {
        byte ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
        byte ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
        byte ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
        byte ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte ETRIGSEL    :1;                                       /* External Trigger Source Select */
      } Bits;
      struct {
        byte grpETRIGCH :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL1STR;
    #define ATD1CTL1                    _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Byte
    #define ATD1CTL1_ETRIGCH0           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH0
    #define ATD1CTL1_ETRIGCH1           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH1
    #define ATD1CTL1_ETRIGCH2           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH2
    #define ATD1CTL1_ETRIGCH3           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGCH3
    #define ATD1CTL1_ETRIGSEL           _ATD1CTL01.Overlap_STR.ATD1CTL1STR.Bits.ETRIGSEL
    #define ATD1CTL1_ETRIGCH            _ATD1CTL01.Overlap_STR.ATD1CTL1STR.MergedBits.grpETRIGCH
    
    #define ATD1CTL1_ETRIGCH0_MASK      1U
    #define ATD1CTL1_ETRIGCH1_MASK      2U
    #define ATD1CTL1_ETRIGCH2_MASK      4U
    #define ATD1CTL1_ETRIGCH3_MASK      8U
    #define ATD1CTL1_ETRIGSEL_MASK      128U
    #define ATD1CTL1_ETRIGCH_MASK       15U
    #define ATD1CTL1_ETRIGCH_BITNUM     0U
    
  } Overlap_STR;

  struct {
    word ETRIGCH0    :1;                                       /* External Trigger Channel Select Bit 0 */
    word ETRIGCH1    :1;                                       /* External Trigger Channel Select Bit 1 */
    word ETRIGCH2    :1;                                       /* External Trigger Channel Select Bit 2 */
    word ETRIGCH3    :1;                                       /* External Trigger Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word ETRIGSEL    :1;                                       /* External Trigger Source Select */
    word WRAP0       :1;                                       /* Wrap Around Channel Select Bit 0 */
    word WRAP1       :1;                                       /* Wrap Around Channel Select Bit 1 */
    word WRAP2       :1;                                       /* Wrap Around Channel Select Bit 2 */
    word WRAP3       :1;                                       /* Wrap Around Channel Select Bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpETRIGCH :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpWRAP :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATD1CTL01STR;
extern volatile ATD1CTL01STR _ATD1CTL01 @(REG_BASE + 0x00000080UL);
#define ATD1CTL01                       _ATD1CTL01.Word
#define ATD1CTL01_ETRIGCH0              _ATD1CTL01.Bits.ETRIGCH0
#define ATD1CTL01_ETRIGCH1              _ATD1CTL01.Bits.ETRIGCH1
#define ATD1CTL01_ETRIGCH2              _ATD1CTL01.Bits.ETRIGCH2
#define ATD1CTL01_ETRIGCH3              _ATD1CTL01.Bits.ETRIGCH3
#define ATD1CTL01_ETRIGSEL              _ATD1CTL01.Bits.ETRIGSEL
#define ATD1CTL01_WRAP0                 _ATD1CTL01.Bits.WRAP0
#define ATD1CTL01_WRAP1                 _ATD1CTL01.Bits.WRAP1
#define ATD1CTL01_WRAP2                 _ATD1CTL01.Bits.WRAP2
#define ATD1CTL01_WRAP3                 _ATD1CTL01.Bits.WRAP3
#define ATD1CTL01_ETRIGCH               _ATD1CTL01.MergedBits.grpETRIGCH
#define ATD1CTL01_WRAP                  _ATD1CTL01.MergedBits.grpWRAP

#define ATD1CTL01_ETRIGCH0_MASK         1U
#define ATD1CTL01_ETRIGCH1_MASK         2U
#define ATD1CTL01_ETRIGCH2_MASK         4U
#define ATD1CTL01_ETRIGCH3_MASK         8U
#define ATD1CTL01_ETRIGSEL_MASK         128U
#define ATD1CTL01_WRAP0_MASK            256U
#define ATD1CTL01_WRAP1_MASK            512U
#define ATD1CTL01_WRAP2_MASK            1024U
#define ATD1CTL01_WRAP3_MASK            2048U
#define ATD1CTL01_ETRIGCH_MASK          15U
#define ATD1CTL01_ETRIGCH_BITNUM        0U
#define ATD1CTL01_WRAP_MASK             3840U
#define ATD1CTL01_WRAP_BITNUM           8U


/*** ATD1CTL23 - ATD 1 Control Register 23; 0x00000082 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL2 - ATD 1 Control Register 2; 0x00000082 ***/
    union {
      byte Byte;
      struct {
        byte ASCIF       :1;                                       /* ATD 1 Sequence Complete Interrupt Flag */
        byte ASCIE       :1;                                       /* ATD 1 Sequence Complete Interrupt Enable */
        byte ETRIGE      :1;                                       /* External Trigger Mode enable */
        byte ETRIGP      :1;                                       /* External Trigger Polarity */
        byte ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
        byte AWAI        :1;                                       /* ATD Power Down in Wait Mode */
        byte AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
        byte ADPU        :1;                                       /* ATD Disable / Power Down */
      } Bits;
    } ATD1CTL2STR;
    #define ATD1CTL2                    _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Byte
    #define ATD1CTL2_ASCIF              _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ASCIF
    #define ATD1CTL2_ASCIE              _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ASCIE
    #define ATD1CTL2_ETRIGE             _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGE
    #define ATD1CTL2_ETRIGP             _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGP
    #define ATD1CTL2_ETRIGLE            _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ETRIGLE
    #define ATD1CTL2_AWAI               _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.AWAI
    #define ATD1CTL2_AFFC               _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.AFFC
    #define ATD1CTL2_ADPU               _ATD1CTL23.Overlap_STR.ATD1CTL2STR.Bits.ADPU
    
    #define ATD1CTL2_ASCIF_MASK         1U
    #define ATD1CTL2_ASCIE_MASK         2U
    #define ATD1CTL2_ETRIGE_MASK        4U
    #define ATD1CTL2_ETRIGP_MASK        8U
    #define ATD1CTL2_ETRIGLE_MASK       16U
    #define ATD1CTL2_AWAI_MASK          32U
    #define ATD1CTL2_AFFC_MASK          64U
    #define ATD1CTL2_ADPU_MASK          128U
    

    /*** ATD1CTL3 - ATD 1 Control Register 3; 0x00000083 ***/
    union {
      byte Byte;
      struct {
        byte FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
        byte FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
        byte FIFO        :1;                                       /* Result Register FIFO Mode */
        byte S1C         :1;                                       /* Conversion Sequence Length 1 */
        byte S2C         :1;                                       /* Conversion Sequence Length 2 */
        byte S4C         :1;                                       /* Conversion Sequence Length 4 */
        byte S8C         :1;                                       /* Conversion Sequence Length 8 */
        byte             :1; 
      } Bits;
      struct {
        byte grpFRZ :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL3STR;
    #define ATD1CTL3                    _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Byte
    #define ATD1CTL3_FRZ0               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FRZ0
    #define ATD1CTL3_FRZ1               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FRZ1
    #define ATD1CTL3_FIFO               _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.FIFO
    #define ATD1CTL3_S1C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S1C
    #define ATD1CTL3_S2C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S2C
    #define ATD1CTL3_S4C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S4C
    #define ATD1CTL3_S8C                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.Bits.S8C
    #define ATD1CTL3_FRZ                _ATD1CTL23.Overlap_STR.ATD1CTL3STR.MergedBits.grpFRZ
    
    #define ATD1CTL3_FRZ0_MASK          1U
    #define ATD1CTL3_FRZ1_MASK          2U
    #define ATD1CTL3_FIFO_MASK          4U
    #define ATD1CTL3_S1C_MASK           8U
    #define ATD1CTL3_S2C_MASK           16U
    #define ATD1CTL3_S4C_MASK           32U
    #define ATD1CTL3_S8C_MASK           64U
    #define ATD1CTL3_FRZ_MASK           3U
    #define ATD1CTL3_FRZ_BITNUM         0U
    
  } Overlap_STR;

  struct {
    word FRZ0        :1;                                       /* Background Debug Freeze Enable Bit 0 */
    word FRZ1        :1;                                       /* Background Debug Freeze Enable Bit 1 */
    word FIFO        :1;                                       /* Result Register FIFO Mode */
    word S1C         :1;                                       /* Conversion Sequence Length 1 */
    word S2C         :1;                                       /* Conversion Sequence Length 2 */
    word S4C         :1;                                       /* Conversion Sequence Length 4 */
    word S8C         :1;                                       /* Conversion Sequence Length 8 */
    word             :1; 
    word ASCIF       :1;                                       /* ATD 1 Sequence Complete Interrupt Flag */
    word ASCIE       :1;                                       /* ATD 1 Sequence Complete Interrupt Enable */
    word ETRIGE      :1;                                       /* External Trigger Mode enable */
    word ETRIGP      :1;                                       /* External Trigger Polarity */
    word ETRIGLE     :1;                                       /* External Trigger Level/Edge control */
    word AWAI        :1;                                       /* ATD Power Down in Wait Mode */
    word AFFC        :1;                                       /* ATD Fast Conversion Complete Flag Clear */
    word ADPU        :1;                                       /* ATD Disable / Power Down */
  } Bits;
  struct {
    word grpFRZ  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} ATD1CTL23STR;
extern volatile ATD1CTL23STR _ATD1CTL23 @(REG_BASE + 0x00000082UL);
#define ATD1CTL23                       _ATD1CTL23.Word
#define ATD1CTL23_FRZ0                  _ATD1CTL23.Bits.FRZ0
#define ATD1CTL23_FRZ1                  _ATD1CTL23.Bits.FRZ1
#define ATD1CTL23_FIFO                  _ATD1CTL23.Bits.FIFO
#define ATD1CTL23_S1C                   _ATD1CTL23.Bits.S1C
#define ATD1CTL23_S2C                   _ATD1CTL23.Bits.S2C
#define ATD1CTL23_S4C                   _ATD1CTL23.Bits.S4C
#define ATD1CTL23_S8C                   _ATD1CTL23.Bits.S8C
#define ATD1CTL23_ASCIF                 _ATD1CTL23.Bits.ASCIF
#define ATD1CTL23_ASCIE                 _ATD1CTL23.Bits.ASCIE
#define ATD1CTL23_ETRIGE                _ATD1CTL23.Bits.ETRIGE
#define ATD1CTL23_ETRIGP                _ATD1CTL23.Bits.ETRIGP
#define ATD1CTL23_ETRIGLE               _ATD1CTL23.Bits.ETRIGLE
#define ATD1CTL23_AWAI                  _ATD1CTL23.Bits.AWAI
#define ATD1CTL23_AFFC                  _ATD1CTL23.Bits.AFFC
#define ATD1CTL23_ADPU                  _ATD1CTL23.Bits.ADPU
#define ATD1CTL23_FRZ                   _ATD1CTL23.MergedBits.grpFRZ

#define ATD1CTL23_FRZ0_MASK             1U
#define ATD1CTL23_FRZ1_MASK             2U
#define ATD1CTL23_FIFO_MASK             4U
#define ATD1CTL23_S1C_MASK              8U
#define ATD1CTL23_S2C_MASK              16U
#define ATD1CTL23_S4C_MASK              32U
#define ATD1CTL23_S8C_MASK              64U
#define ATD1CTL23_ASCIF_MASK            256U
#define ATD1CTL23_ASCIE_MASK            512U
#define ATD1CTL23_ETRIGE_MASK           1024U
#define ATD1CTL23_ETRIGP_MASK           2048U
#define ATD1CTL23_ETRIGLE_MASK          4096U
#define ATD1CTL23_AWAI_MASK             8192U
#define ATD1CTL23_AFFC_MASK             16384U
#define ATD1CTL23_ADPU_MASK             32768U
#define ATD1CTL23_FRZ_MASK              3U
#define ATD1CTL23_FRZ_BITNUM            0U


/*** ATD1CTL45 - ATD 1 Control Register 45; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1CTL4 - ATD 1 Control Register 4; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte PRS0        :1;                                       /* ATD Clock Prescaler 0 */
        byte PRS1        :1;                                       /* ATD Clock Prescaler 1 */
        byte PRS2        :1;                                       /* ATD Clock Prescaler 2 */
        byte PRS3        :1;                                       /* ATD Clock Prescaler 3 */
        byte PRS4        :1;                                       /* ATD Clock Prescaler 4 */
        byte SMP0        :1;                                       /* Sample Time Select 0 */
        byte SMP1        :1;                                       /* Sample Time Select 1 */
        byte SRES8       :1;                                       /* ATD Resolution Select */
      } Bits;
      struct {
        byte grpPRS :5;
        byte grpSMP :2;
        byte grpSRES_8 :1;
      } MergedBits;
    } ATD1CTL4STR;
    #define ATD1CTL4                    _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Byte
    #define ATD1CTL4_PRS0               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS0
    #define ATD1CTL4_PRS1               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS1
    #define ATD1CTL4_PRS2               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS2
    #define ATD1CTL4_PRS3               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS3
    #define ATD1CTL4_PRS4               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.PRS4
    #define ATD1CTL4_SMP0               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SMP0
    #define ATD1CTL4_SMP1               _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SMP1
    #define ATD1CTL4_SRES8              _ATD1CTL45.Overlap_STR.ATD1CTL4STR.Bits.SRES8
    #define ATD1CTL4_PRS                _ATD1CTL45.Overlap_STR.ATD1CTL4STR.MergedBits.grpPRS
    #define ATD1CTL4_SMP                _ATD1CTL45.Overlap_STR.ATD1CTL4STR.MergedBits.grpSMP
    
    #define ATD1CTL4_PRS0_MASK          1U
    #define ATD1CTL4_PRS1_MASK          2U
    #define ATD1CTL4_PRS2_MASK          4U
    #define ATD1CTL4_PRS3_MASK          8U
    #define ATD1CTL4_PRS4_MASK          16U
    #define ATD1CTL4_SMP0_MASK          32U
    #define ATD1CTL4_SMP1_MASK          64U
    #define ATD1CTL4_SRES8_MASK         128U
    #define ATD1CTL4_PRS_MASK           31U
    #define ATD1CTL4_PRS_BITNUM         0U
    #define ATD1CTL4_SMP_MASK           96U
    #define ATD1CTL4_SMP_BITNUM         5U
    

    /*** ATD1CTL5 - ATD 1 Control Register 5; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte CA          :1;                                       /* Analog Input Channel Select Code A */
        byte CB          :1;                                       /* Analog Input Channel Select Code B */
        byte CC          :1;                                       /* Analog Input Channel Select Code C */
        byte CD          :1;                                       /* Analog Input Channel Select Code D */
        byte MULT        :1;                                       /* Multi-Channel Sample Mode */
        byte SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
        byte DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
        byte DJM         :1;                                       /* Result Register Data Justification Mode */
      } Bits;
      struct {
        byte grpCx :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ATD1CTL5STR;
    #define ATD1CTL5                    _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Byte
    #define ATD1CTL5_CA                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CA
    #define ATD1CTL5_CB                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CB
    #define ATD1CTL5_CC                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CC
    #define ATD1CTL5_CD                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.CD
    #define ATD1CTL5_MULT               _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.MULT
    #define ATD1CTL5_SCAN               _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.SCAN
    #define ATD1CTL5_DSGN               _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.DSGN
    #define ATD1CTL5_DJM                _ATD1CTL45.Overlap_STR.ATD1CTL5STR.Bits.DJM
    #define ATD1CTL5_Cx                 _ATD1CTL45.Overlap_STR.ATD1CTL5STR.MergedBits.grpCx
    
    #define ATD1CTL5_CA_MASK            1U
    #define ATD1CTL5_CB_MASK            2U
    #define ATD1CTL5_CC_MASK            4U
    #define ATD1CTL5_CD_MASK            8U
    #define ATD1CTL5_MULT_MASK          16U
    #define ATD1CTL5_SCAN_MASK          32U
    #define ATD1CTL5_DSGN_MASK          64U
    #define ATD1CTL5_DJM_MASK           128U
    #define ATD1CTL5_Cx_MASK            15U
    #define ATD1CTL5_Cx_BITNUM          0U
    
  } Overlap_STR;

  struct {
    word CA          :1;                                       /* Analog Input Channel Select Code A */
    word CB          :1;                                       /* Analog Input Channel Select Code B */
    word CC          :1;                                       /* Analog Input Channel Select Code C */
    word CD          :1;                                       /* Analog Input Channel Select Code D */
    word MULT        :1;                                       /* Multi-Channel Sample Mode */
    word SCAN        :1;                                       /* Continuous Conversion Sequence Mode */
    word DSGN        :1;                                       /* Signed/Unsigned Result Data Mode */
    word DJM         :1;                                       /* Result Register Data Justification Mode */
    word PRS0        :1;                                       /* ATD Clock Prescaler 0 */
    word PRS1        :1;                                       /* ATD Clock Prescaler 1 */
    word PRS2        :1;                                       /* ATD Clock Prescaler 2 */
    word PRS3        :1;                                       /* ATD Clock Prescaler 3 */
    word PRS4        :1;                                       /* ATD Clock Prescaler 4 */
    word SMP0        :1;                                       /* Sample Time Select 0 */
    word SMP1        :1;                                       /* Sample Time Select 1 */
    word SRES8       :1;                                       /* ATD Resolution Select */
  } Bits;
  struct {
    word grpCx   :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRS  :5;
    word grpSMP  :2;
    word grpSRES_8 :1;
  } MergedBits;
} ATD1CTL45STR;
extern volatile ATD1CTL45STR _ATD1CTL45 @(REG_BASE + 0x00000084UL);
#define ATD1CTL45                       _ATD1CTL45.Word
#define ATD1CTL45_CA                    _ATD1CTL45.Bits.CA
#define ATD1CTL45_CB                    _ATD1CTL45.Bits.CB
#define ATD1CTL45_CC                    _ATD1CTL45.Bits.CC
#define ATD1CTL45_CD                    _ATD1CTL45.Bits.CD
#define ATD1CTL45_MULT                  _ATD1CTL45.Bits.MULT
#define ATD1CTL45_SCAN                  _ATD1CTL45.Bits.SCAN
#define ATD1CTL45_DSGN                  _ATD1CTL45.Bits.DSGN
#define ATD1CTL45_DJM                   _ATD1CTL45.Bits.DJM
#define ATD1CTL45_PRS0                  _ATD1CTL45.Bits.PRS0
#define ATD1CTL45_PRS1                  _ATD1CTL45.Bits.PRS1
#define ATD1CTL45_PRS2                  _ATD1CTL45.Bits.PRS2
#define ATD1CTL45_PRS3                  _ATD1CTL45.Bits.PRS3
#define ATD1CTL45_PRS4                  _ATD1CTL45.Bits.PRS4
#define ATD1CTL45_SMP0                  _ATD1CTL45.Bits.SMP0
#define ATD1CTL45_SMP1                  _ATD1CTL45.Bits.SMP1
#define ATD1CTL45_SRES8                 _ATD1CTL45.Bits.SRES8
#define ATD1CTL45_Cx                    _ATD1CTL45.MergedBits.grpCx
#define ATD1CTL45_PRS                   _ATD1CTL45.MergedBits.grpPRS
#define ATD1CTL45_SMP                   _ATD1CTL45.MergedBits.grpSMP

#define ATD1CTL45_CA_MASK               1U
#define ATD1CTL45_CB_MASK               2U
#define ATD1CTL45_CC_MASK               4U
#define ATD1CTL45_CD_MASK               8U
#define ATD1CTL45_MULT_MASK             16U
#define ATD1CTL45_SCAN_MASK             32U
#define ATD1CTL45_DSGN_MASK             64U
#define ATD1CTL45_DJM_MASK              128U
#define ATD1CTL45_PRS0_MASK             256U
#define ATD1CTL45_PRS1_MASK             512U
#define ATD1CTL45_PRS2_MASK             1024U
#define ATD1CTL45_PRS3_MASK             2048U
#define ATD1CTL45_PRS4_MASK             4096U
#define ATD1CTL45_SMP0_MASK             8192U
#define ATD1CTL45_SMP1_MASK             16384U
#define ATD1CTL45_SRES8_MASK            32768U
#define ATD1CTL45_Cx_MASK               15U
#define ATD1CTL45_Cx_BITNUM             0U
#define ATD1CTL45_PRS_MASK              7936U
#define ATD1CTL45_PRS_BITNUM            8U
#define ATD1CTL45_SMP_MASK              24576U
#define ATD1CTL45_SMP_BITNUM            13U


/*** ATD1STAT0 - ATD 1 Status Register 0; 0x00000086 ***/
typedef union {
  byte Byte;
  struct {
    byte CC0         :1;                                       /* Conversion Counter 0 */
    byte CC1         :1;                                       /* Conversion Counter 1 */
    byte CC2         :1;                                       /* Conversion Counter 2 */
    byte CC3         :1;                                       /* Conversion Counter 3 */
    byte FIFOR       :1;                                       /* FIFO Over Run Flag */
    byte ETORF       :1;                                       /* External Trigger Overrun Flag */
    byte             :1; 
    byte SCF         :1;                                       /* Sequence Complete Flag */
  } Bits;
  struct {
    byte grpCC   :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ATD1STAT0STR;
extern volatile ATD1STAT0STR _ATD1STAT0 @(REG_BASE + 0x00000086UL);
#define ATD1STAT0                       _ATD1STAT0.Byte
#define ATD1STAT0_CC0                   _ATD1STAT0.Bits.CC0
#define ATD1STAT0_CC1                   _ATD1STAT0.Bits.CC1
#define ATD1STAT0_CC2                   _ATD1STAT0.Bits.CC2
#define ATD1STAT0_CC3                   _ATD1STAT0.Bits.CC3
#define ATD1STAT0_FIFOR                 _ATD1STAT0.Bits.FIFOR
#define ATD1STAT0_ETORF                 _ATD1STAT0.Bits.ETORF
#define ATD1STAT0_SCF                   _ATD1STAT0.Bits.SCF
#define ATD1STAT0_CC                    _ATD1STAT0.MergedBits.grpCC

#define ATD1STAT0_CC0_MASK              1U
#define ATD1STAT0_CC1_MASK              2U
#define ATD1STAT0_CC2_MASK              4U
#define ATD1STAT0_CC3_MASK              8U
#define ATD1STAT0_FIFOR_MASK            16U
#define ATD1STAT0_ETORF_MASK            32U
#define ATD1STAT0_SCF_MASK              128U
#define ATD1STAT0_CC_MASK               15U
#define ATD1STAT0_CC_BITNUM             0U


/*** ATD1TEST1 - ATD1 Test Register; 0x00000089 ***/
typedef union {
  byte Byte;
  struct {
    byte SC          :1;                                       /* Special Channel Conversion Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} ATD1TEST1STR;
extern volatile ATD1TEST1STR _ATD1TEST1 @(REG_BASE + 0x00000089UL);
#define ATD1TEST1                       _ATD1TEST1.Byte
#define ATD1TEST1_SC                    _ATD1TEST1.Bits.SC

#define ATD1TEST1_SC_MASK               1U


/*** ATD1STAT2 - ATD 1 Status Register 2; 0x0000008A ***/
typedef union {
  byte Byte;
  struct {
    byte CCF8        :1;                                       /* Conversion Complete Flag 8 */
    byte CCF9        :1;                                       /* Conversion Complete Flag 9 */
    byte CCF10       :1;                                       /* Conversion Complete Flag 10 */
    byte CCF11       :1;                                       /* Conversion Complete Flag 11 */
    byte CCF12       :1;                                       /* Conversion Complete Flag 12 */
    byte CCF13       :1;                                       /* Conversion Complete Flag 13 */
    byte CCF14       :1;                                       /* Conversion Complete Flag 14 */
    byte CCF15       :1;                                       /* Conversion Complete Flag 15 */
  } Bits;
} ATD1STAT2STR;
extern volatile ATD1STAT2STR _ATD1STAT2 @(REG_BASE + 0x0000008AUL);
#define ATD1STAT2                       _ATD1STAT2.Byte
#define ATD1STAT2_CCF8                  _ATD1STAT2.Bits.CCF8
#define ATD1STAT2_CCF9                  _ATD1STAT2.Bits.CCF9
#define ATD1STAT2_CCF10                 _ATD1STAT2.Bits.CCF10
#define ATD1STAT2_CCF11                 _ATD1STAT2.Bits.CCF11
#define ATD1STAT2_CCF12                 _ATD1STAT2.Bits.CCF12
#define ATD1STAT2_CCF13                 _ATD1STAT2.Bits.CCF13
#define ATD1STAT2_CCF14                 _ATD1STAT2.Bits.CCF14
#define ATD1STAT2_CCF15                 _ATD1STAT2.Bits.CCF15

#define ATD1STAT2_CCF8_MASK             1U
#define ATD1STAT2_CCF9_MASK             2U
#define ATD1STAT2_CCF10_MASK            4U
#define ATD1STAT2_CCF11_MASK            8U
#define ATD1STAT2_CCF12_MASK            16U
#define ATD1STAT2_CCF13_MASK            32U
#define ATD1STAT2_CCF14_MASK            64U
#define ATD1STAT2_CCF15_MASK            128U


/*** ATD1STAT1 - ATD 1 Status Register 1; 0x0000008B ***/
typedef union {
  byte Byte;
  struct {
    byte CCF0        :1;                                       /* Conversion Complete Flag 0 */
    byte CCF1        :1;                                       /* Conversion Complete Flag 1 */
    byte CCF2        :1;                                       /* Conversion Complete Flag 2 */
    byte CCF3        :1;                                       /* Conversion Complete Flag 3 */
    byte CCF4        :1;                                       /* Conversion Complete Flag 4 */
    byte CCF5        :1;                                       /* Conversion Complete Flag 5 */
    byte CCF6        :1;                                       /* Conversion Complete Flag 6 */
    byte CCF7        :1;                                       /* Conversion Complete Flag 7 */
  } Bits;
} ATD1STAT1STR;
extern volatile ATD1STAT1STR _ATD1STAT1 @(REG_BASE + 0x0000008BUL);
#define ATD1STAT1                       _ATD1STAT1.Byte
#define ATD1STAT1_CCF0                  _ATD1STAT1.Bits.CCF0
#define ATD1STAT1_CCF1                  _ATD1STAT1.Bits.CCF1
#define ATD1STAT1_CCF2                  _ATD1STAT1.Bits.CCF2
#define ATD1STAT1_CCF3                  _ATD1STAT1.Bits.CCF3
#define ATD1STAT1_CCF4                  _ATD1STAT1.Bits.CCF4
#define ATD1STAT1_CCF5                  _ATD1STAT1.Bits.CCF5
#define ATD1STAT1_CCF6                  _ATD1STAT1.Bits.CCF6
#define ATD1STAT1_CCF7                  _ATD1STAT1.Bits.CCF7

#define ATD1STAT1_CCF0_MASK             1U
#define ATD1STAT1_CCF1_MASK             2U
#define ATD1STAT1_CCF2_MASK             4U
#define ATD1STAT1_CCF3_MASK             8U
#define ATD1STAT1_CCF4_MASK             16U
#define ATD1STAT1_CCF5_MASK             32U
#define ATD1STAT1_CCF6_MASK             64U
#define ATD1STAT1_CCF7_MASK             128U


/*** ATD1DIEN - ATD 1 Input Enable Register; 0x0000008C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DIEN0 - ATD 1 Input Enable Register 0; 0x0000008C ***/
    union {
      byte Byte;
      struct {
        byte IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
        byte IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
        byte IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
        byte IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
        byte IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
        byte IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
        byte IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
        byte IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
      } Bits;
    } ATD1DIEN0STR;
    #define ATD1DIEN0                   _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Byte
    #define ATD1DIEN0_IEN8              _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN8
    #define ATD1DIEN0_IEN9              _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN9
    #define ATD1DIEN0_IEN10             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN10
    #define ATD1DIEN0_IEN11             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN11
    #define ATD1DIEN0_IEN12             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN12
    #define ATD1DIEN0_IEN13             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN13
    #define ATD1DIEN0_IEN14             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN14
    #define ATD1DIEN0_IEN15             _ATD1DIEN.Overlap_STR.ATD1DIEN0STR.Bits.IEN15
    /* ATD1DIEN_ARR: Access 2 ATD1DIENx registers in an array */
    #define ATD1DIEN_ARR                ((volatile byte *) &ATD1DIEN0)
    
    #define ATD1DIEN0_IEN8_MASK         1U
    #define ATD1DIEN0_IEN9_MASK         2U
    #define ATD1DIEN0_IEN10_MASK        4U
    #define ATD1DIEN0_IEN11_MASK        8U
    #define ATD1DIEN0_IEN12_MASK        16U
    #define ATD1DIEN0_IEN13_MASK        32U
    #define ATD1DIEN0_IEN14_MASK        64U
    #define ATD1DIEN0_IEN15_MASK        128U
    

    /*** ATD1DIEN1 - ATD 1 Input Enable Register 1; 0x0000008D ***/
    union {
      byte Byte;
      struct {
        byte IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
        byte IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
        byte IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
        byte IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
        byte IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
        byte IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
        byte IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
        byte IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
      } Bits;
    } ATD1DIEN1STR;
    #define ATD1DIEN1                   _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Byte
    #define ATD1DIEN1_IEN0              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN0
    #define ATD1DIEN1_IEN1              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN1
    #define ATD1DIEN1_IEN2              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN2
    #define ATD1DIEN1_IEN3              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN3
    #define ATD1DIEN1_IEN4              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN4
    #define ATD1DIEN1_IEN5              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN5
    #define ATD1DIEN1_IEN6              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN6
    #define ATD1DIEN1_IEN7              _ATD1DIEN.Overlap_STR.ATD1DIEN1STR.Bits.IEN7
    
    #define ATD1DIEN1_IEN0_MASK         1U
    #define ATD1DIEN1_IEN1_MASK         2U
    #define ATD1DIEN1_IEN2_MASK         4U
    #define ATD1DIEN1_IEN3_MASK         8U
    #define ATD1DIEN1_IEN4_MASK         16U
    #define ATD1DIEN1_IEN5_MASK         32U
    #define ATD1DIEN1_IEN6_MASK         64U
    #define ATD1DIEN1_IEN7_MASK         128U
    
  } Overlap_STR;

  struct {
    word IEN0        :1;                                       /* ATD Digital Input Enable on channel 0 */
    word IEN1        :1;                                       /* ATD Digital Input Enable on channel 1 */
    word IEN2        :1;                                       /* ATD Digital Input Enable on channel 2 */
    word IEN3        :1;                                       /* ATD Digital Input Enable on channel 3 */
    word IEN4        :1;                                       /* ATD Digital Input Enable on channel 4 */
    word IEN5        :1;                                       /* ATD Digital Input Enable on channel 5 */
    word IEN6        :1;                                       /* ATD Digital Input Enable on channel 6 */
    word IEN7        :1;                                       /* ATD Digital Input Enable on channel 7 */
    word IEN8        :1;                                       /* ATD Digital Input Enable on channel 8 */
    word IEN9        :1;                                       /* ATD Digital Input Enable on channel 9 */
    word IEN10       :1;                                       /* ATD Digital Input Enable on channel 10 */
    word IEN11       :1;                                       /* ATD Digital Input Enable on channel 11 */
    word IEN12       :1;                                       /* ATD Digital Input Enable on channel 12 */
    word IEN13       :1;                                       /* ATD Digital Input Enable on channel 13 */
    word IEN14       :1;                                       /* ATD Digital Input Enable on channel 14 */
    word IEN15       :1;                                       /* ATD Digital Input Enable on channel 15 */
  } Bits;
} ATD1DIENSTR;
extern volatile ATD1DIENSTR _ATD1DIEN @(REG_BASE + 0x0000008CUL);
#define ATD1DIEN                        _ATD1DIEN.Word
#define ATD1DIEN_IEN0                   _ATD1DIEN.Bits.IEN0
#define ATD1DIEN_IEN1                   _ATD1DIEN.Bits.IEN1
#define ATD1DIEN_IEN2                   _ATD1DIEN.Bits.IEN2
#define ATD1DIEN_IEN3                   _ATD1DIEN.Bits.IEN3
#define ATD1DIEN_IEN4                   _ATD1DIEN.Bits.IEN4
#define ATD1DIEN_IEN5                   _ATD1DIEN.Bits.IEN5
#define ATD1DIEN_IEN6                   _ATD1DIEN.Bits.IEN6
#define ATD1DIEN_IEN7                   _ATD1DIEN.Bits.IEN7
#define ATD1DIEN_IEN8                   _ATD1DIEN.Bits.IEN8
#define ATD1DIEN_IEN9                   _ATD1DIEN.Bits.IEN9
#define ATD1DIEN_IEN10                  _ATD1DIEN.Bits.IEN10
#define ATD1DIEN_IEN11                  _ATD1DIEN.Bits.IEN11
#define ATD1DIEN_IEN12                  _ATD1DIEN.Bits.IEN12
#define ATD1DIEN_IEN13                  _ATD1DIEN.Bits.IEN13
#define ATD1DIEN_IEN14                  _ATD1DIEN.Bits.IEN14
#define ATD1DIEN_IEN15                  _ATD1DIEN.Bits.IEN15

#define ATD1DIEN_IEN0_MASK              1U
#define ATD1DIEN_IEN1_MASK              2U
#define ATD1DIEN_IEN2_MASK              4U
#define ATD1DIEN_IEN3_MASK              8U
#define ATD1DIEN_IEN4_MASK              16U
#define ATD1DIEN_IEN5_MASK              32U
#define ATD1DIEN_IEN6_MASK              64U
#define ATD1DIEN_IEN7_MASK              128U
#define ATD1DIEN_IEN8_MASK              256U
#define ATD1DIEN_IEN9_MASK              512U
#define ATD1DIEN_IEN10_MASK             1024U
#define ATD1DIEN_IEN11_MASK             2048U
#define ATD1DIEN_IEN12_MASK             4096U
#define ATD1DIEN_IEN13_MASK             8192U
#define ATD1DIEN_IEN14_MASK             16384U
#define ATD1DIEN_IEN15_MASK             32768U


/*** ATD1PTAD - ATD1 Port AD Register; 0x0000008E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1PTAD0 - ATD1 Port AD0 Register; 0x0000008E ***/
    union {
      byte Byte;
      struct {
        byte PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
        byte PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
        byte PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
        byte PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
        byte PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
        byte PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
        byte PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
        byte PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
      } Bits;
    } ATD1PTAD0STR;
    #define ATD1PTAD0                   _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Byte
    #define ATD1PTAD0_PTAD8             _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD8
    #define ATD1PTAD0_PTAD9             _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD9
    #define ATD1PTAD0_PTAD10            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD10
    #define ATD1PTAD0_PTAD11            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD11
    #define ATD1PTAD0_PTAD12            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD12
    #define ATD1PTAD0_PTAD13            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD13
    #define ATD1PTAD0_PTAD14            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD14
    #define ATD1PTAD0_PTAD15            _ATD1PTAD.Overlap_STR.ATD1PTAD0STR.Bits.PTAD15
    /* ATD1PTAD_ARR: Access 2 ATD1PTADx registers in an array */
    #define ATD1PTAD_ARR                ((volatile byte *) &ATD1PTAD0)
    
    #define ATD1PTAD0_PTAD8_MASK        1U
    #define ATD1PTAD0_PTAD9_MASK        2U
    #define ATD1PTAD0_PTAD10_MASK       4U
    #define ATD1PTAD0_PTAD11_MASK       8U
    #define ATD1PTAD0_PTAD12_MASK       16U
    #define ATD1PTAD0_PTAD13_MASK       32U
    #define ATD1PTAD0_PTAD14_MASK       64U
    #define ATD1PTAD0_PTAD15_MASK       128U
    

    /*** ATD1PTAD1 - ATD1 Port AD1 Register; 0x0000008F ***/
    union {
      byte Byte;
      struct {
        byte PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
        byte PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
        byte PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
        byte PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
        byte PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
        byte PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
        byte PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
        byte PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
      } Bits;
    } ATD1PTAD1STR;
    #define ATD1PTAD1                   _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Byte
    #define ATD1PTAD1_PTAD0             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD0
    #define ATD1PTAD1_PTAD1             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD1
    #define ATD1PTAD1_PTAD2             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD2
    #define ATD1PTAD1_PTAD3             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD3
    #define ATD1PTAD1_PTAD4             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD4
    #define ATD1PTAD1_PTAD5             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD5
    #define ATD1PTAD1_PTAD6             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD6
    #define ATD1PTAD1_PTAD7             _ATD1PTAD.Overlap_STR.ATD1PTAD1STR.Bits.PTAD7
    
    #define ATD1PTAD1_PTAD0_MASK        1U
    #define ATD1PTAD1_PTAD1_MASK        2U
    #define ATD1PTAD1_PTAD2_MASK        4U
    #define ATD1PTAD1_PTAD3_MASK        8U
    #define ATD1PTAD1_PTAD4_MASK        16U
    #define ATD1PTAD1_PTAD5_MASK        32U
    #define ATD1PTAD1_PTAD6_MASK        64U
    #define ATD1PTAD1_PTAD7_MASK        128U
    
  } Overlap_STR;

  struct {
    word PTAD0       :1;                                       /* A/D Channel 0 (AN0) Digital Input */
    word PTAD1       :1;                                       /* A/D Channel 1 (AN1) Digital Input */
    word PTAD2       :1;                                       /* A/D Channel 2 (AN2) Digital Input */
    word PTAD3       :1;                                       /* A/D Channel 3 (AN3) Digital Input */
    word PTAD4       :1;                                       /* A/D Channel 4 (AN4) Digital Input */
    word PTAD5       :1;                                       /* A/D Channel 5 (AN5) Digital Input */
    word PTAD6       :1;                                       /* A/D Channel 6 (AN6) Digital Input */
    word PTAD7       :1;                                       /* A/D Channel 7 (AN7) Digital Input */
    word PTAD8       :1;                                       /* A/D Channel 8 (AN8) Digital Input */
    word PTAD9       :1;                                       /* A/D Channel 9 (AN9) Digital Input */
    word PTAD10      :1;                                       /* A/D Channel 10 (AN10) Digital Input */
    word PTAD11      :1;                                       /* A/D Channel 11 (AN11) Digital Input */
    word PTAD12      :1;                                       /* A/D Channel 12 (AN12) Digital Input */
    word PTAD13      :1;                                       /* A/D Channel 13 (AN13) Digital Input */
    word PTAD14      :1;                                       /* A/D Channel 14 (AN14) Digital Input */
    word PTAD15      :1;                                       /* A/D Channel 15 (AN15) Digital Input */
  } Bits;
} ATD1PTADSTR;
extern volatile ATD1PTADSTR _ATD1PTAD @(REG_BASE + 0x0000008EUL);
#define ATD1PTAD                        _ATD1PTAD.Word
#define ATD1PTAD_PTAD0                  _ATD1PTAD.Bits.PTAD0
#define ATD1PTAD_PTAD1                  _ATD1PTAD.Bits.PTAD1
#define ATD1PTAD_PTAD2                  _ATD1PTAD.Bits.PTAD2
#define ATD1PTAD_PTAD3                  _ATD1PTAD.Bits.PTAD3
#define ATD1PTAD_PTAD4                  _ATD1PTAD.Bits.PTAD4
#define ATD1PTAD_PTAD5                  _ATD1PTAD.Bits.PTAD5
#define ATD1PTAD_PTAD6                  _ATD1PTAD.Bits.PTAD6
#define ATD1PTAD_PTAD7                  _ATD1PTAD.Bits.PTAD7
#define ATD1PTAD_PTAD8                  _ATD1PTAD.Bits.PTAD8
#define ATD1PTAD_PTAD9                  _ATD1PTAD.Bits.PTAD9
#define ATD1PTAD_PTAD10                 _ATD1PTAD.Bits.PTAD10
#define ATD1PTAD_PTAD11                 _ATD1PTAD.Bits.PTAD11
#define ATD1PTAD_PTAD12                 _ATD1PTAD.Bits.PTAD12
#define ATD1PTAD_PTAD13                 _ATD1PTAD.Bits.PTAD13
#define ATD1PTAD_PTAD14                 _ATD1PTAD.Bits.PTAD14
#define ATD1PTAD_PTAD15                 _ATD1PTAD.Bits.PTAD15

#define ATD1PTAD_PTAD0_MASK             1U
#define ATD1PTAD_PTAD1_MASK             2U
#define ATD1PTAD_PTAD2_MASK             4U
#define ATD1PTAD_PTAD3_MASK             8U
#define ATD1PTAD_PTAD4_MASK             16U
#define ATD1PTAD_PTAD5_MASK             32U
#define ATD1PTAD_PTAD6_MASK             64U
#define ATD1PTAD_PTAD7_MASK             128U
#define ATD1PTAD_PTAD8_MASK             256U
#define ATD1PTAD_PTAD9_MASK             512U
#define ATD1PTAD_PTAD10_MASK            1024U
#define ATD1PTAD_PTAD11_MASK            2048U
#define ATD1PTAD_PTAD12_MASK            4096U
#define ATD1PTAD_PTAD13_MASK            8192U
#define ATD1PTAD_PTAD14_MASK            16384U
#define ATD1PTAD_PTAD15_MASK            32768U


/*** ATD1DR0 - ATD 1 Conversion Result Register 0; 0x00000090 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR0H - ATD 1 Conversion Result Register 0 High; 0x00000090 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR0HSTR;
    #define ATD1DR0H                    _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Byte
    #define ATD1DR0H_BIT8               _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT8
    #define ATD1DR0H_BIT9               _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT9
    #define ATD1DR0H_BIT10              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT10
    #define ATD1DR0H_BIT11              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT11
    #define ATD1DR0H_BIT12              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT12
    #define ATD1DR0H_BIT13              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT13
    #define ATD1DR0H_BIT14              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT14
    #define ATD1DR0H_BIT15              _ATD1DR0.Overlap_STR.ATD1DR0HSTR.Bits.BIT15
    
    #define ATD1DR0H_BIT8_MASK          1U
    #define ATD1DR0H_BIT9_MASK          2U
    #define ATD1DR0H_BIT10_MASK         4U
    #define ATD1DR0H_BIT11_MASK         8U
    #define ATD1DR0H_BIT12_MASK         16U
    #define ATD1DR0H_BIT13_MASK         32U
    #define ATD1DR0H_BIT14_MASK         64U
    #define ATD1DR0H_BIT15_MASK         128U
    

    /*** ATD1DR0L - ATD 1 Conversion Result Register 0 Low; 0x00000091 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR0LSTR;
    #define ATD1DR0L                    _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Byte
    #define ATD1DR0L_BIT6               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT6
    #define ATD1DR0L_BIT7               _ATD1DR0.Overlap_STR.ATD1DR0LSTR.Bits.BIT7
    #define ATD1DR0L_BIT_6              _ATD1DR0.Overlap_STR.ATD1DR0LSTR.MergedBits.grpBIT_6
    #define ATD1DR0L_BIT                ATD1DR0L_BIT_6
    
    #define ATD1DR0L_BIT6_MASK          64U
    #define ATD1DR0L_BIT7_MASK          128U
    #define ATD1DR0L_BIT_6_MASK         192U
    #define ATD1DR0L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR0STR;
extern volatile ATD1DR0STR _ATD1DR0 @(REG_BASE + 0x00000090UL);
#define ATD1DR0                         _ATD1DR0.Word
#define ATD1DR0_BIT6                    _ATD1DR0.Bits.BIT6
#define ATD1DR0_BIT7                    _ATD1DR0.Bits.BIT7
#define ATD1DR0_BIT8                    _ATD1DR0.Bits.BIT8
#define ATD1DR0_BIT9                    _ATD1DR0.Bits.BIT9
#define ATD1DR0_BIT10                   _ATD1DR0.Bits.BIT10
#define ATD1DR0_BIT11                   _ATD1DR0.Bits.BIT11
#define ATD1DR0_BIT12                   _ATD1DR0.Bits.BIT12
#define ATD1DR0_BIT13                   _ATD1DR0.Bits.BIT13
#define ATD1DR0_BIT14                   _ATD1DR0.Bits.BIT14
#define ATD1DR0_BIT15                   _ATD1DR0.Bits.BIT15
/* ATD1DR_ARR: Access 16 ATD1DRx registers in an array */
#define ATD1DR_ARR                      ((volatile word *) &ATD1DR0)
#define ATD1DR0_BIT_6                   _ATD1DR0.MergedBits.grpBIT_6
#define ATD1DR0_BIT                     ATD1DR0_BIT_6

#define ATD1DR0_BIT6_MASK               64U
#define ATD1DR0_BIT7_MASK               128U
#define ATD1DR0_BIT8_MASK               256U
#define ATD1DR0_BIT9_MASK               512U
#define ATD1DR0_BIT10_MASK              1024U
#define ATD1DR0_BIT11_MASK              2048U
#define ATD1DR0_BIT12_MASK              4096U
#define ATD1DR0_BIT13_MASK              8192U
#define ATD1DR0_BIT14_MASK              16384U
#define ATD1DR0_BIT15_MASK              32768U
#define ATD1DR0_BIT_6_MASK              65472U
#define ATD1DR0_BIT_6_BITNUM            6U


/*** ATD1DR1 - ATD 1 Conversion Result Register 1; 0x00000092 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR1H - ATD 1 Conversion Result Register 1 High; 0x00000092 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR1HSTR;
    #define ATD1DR1H                    _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Byte
    #define ATD1DR1H_BIT8               _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT8
    #define ATD1DR1H_BIT9               _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT9
    #define ATD1DR1H_BIT10              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT10
    #define ATD1DR1H_BIT11              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT11
    #define ATD1DR1H_BIT12              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT12
    #define ATD1DR1H_BIT13              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT13
    #define ATD1DR1H_BIT14              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT14
    #define ATD1DR1H_BIT15              _ATD1DR1.Overlap_STR.ATD1DR1HSTR.Bits.BIT15
    
    #define ATD1DR1H_BIT8_MASK          1U
    #define ATD1DR1H_BIT9_MASK          2U
    #define ATD1DR1H_BIT10_MASK         4U
    #define ATD1DR1H_BIT11_MASK         8U
    #define ATD1DR1H_BIT12_MASK         16U
    #define ATD1DR1H_BIT13_MASK         32U
    #define ATD1DR1H_BIT14_MASK         64U
    #define ATD1DR1H_BIT15_MASK         128U
    

    /*** ATD1DR1L - ATD 1 Conversion Result Register 1 Low; 0x00000093 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR1LSTR;
    #define ATD1DR1L                    _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Byte
    #define ATD1DR1L_BIT6               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT6
    #define ATD1DR1L_BIT7               _ATD1DR1.Overlap_STR.ATD1DR1LSTR.Bits.BIT7
    #define ATD1DR1L_BIT_6              _ATD1DR1.Overlap_STR.ATD1DR1LSTR.MergedBits.grpBIT_6
    #define ATD1DR1L_BIT                ATD1DR1L_BIT_6
    
    #define ATD1DR1L_BIT6_MASK          64U
    #define ATD1DR1L_BIT7_MASK          128U
    #define ATD1DR1L_BIT_6_MASK         192U
    #define ATD1DR1L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR1STR;
extern volatile ATD1DR1STR _ATD1DR1 @(REG_BASE + 0x00000092UL);
#define ATD1DR1                         _ATD1DR1.Word
#define ATD1DR1_BIT6                    _ATD1DR1.Bits.BIT6
#define ATD1DR1_BIT7                    _ATD1DR1.Bits.BIT7
#define ATD1DR1_BIT8                    _ATD1DR1.Bits.BIT8
#define ATD1DR1_BIT9                    _ATD1DR1.Bits.BIT9
#define ATD1DR1_BIT10                   _ATD1DR1.Bits.BIT10
#define ATD1DR1_BIT11                   _ATD1DR1.Bits.BIT11
#define ATD1DR1_BIT12                   _ATD1DR1.Bits.BIT12
#define ATD1DR1_BIT13                   _ATD1DR1.Bits.BIT13
#define ATD1DR1_BIT14                   _ATD1DR1.Bits.BIT14
#define ATD1DR1_BIT15                   _ATD1DR1.Bits.BIT15
#define ATD1DR1_BIT_6                   _ATD1DR1.MergedBits.grpBIT_6
#define ATD1DR1_BIT                     ATD1DR1_BIT_6

#define ATD1DR1_BIT6_MASK               64U
#define ATD1DR1_BIT7_MASK               128U
#define ATD1DR1_BIT8_MASK               256U
#define ATD1DR1_BIT9_MASK               512U
#define ATD1DR1_BIT10_MASK              1024U
#define ATD1DR1_BIT11_MASK              2048U
#define ATD1DR1_BIT12_MASK              4096U
#define ATD1DR1_BIT13_MASK              8192U
#define ATD1DR1_BIT14_MASK              16384U
#define ATD1DR1_BIT15_MASK              32768U
#define ATD1DR1_BIT_6_MASK              65472U
#define ATD1DR1_BIT_6_BITNUM            6U


/*** ATD1DR2 - ATD 1 Conversion Result Register 2; 0x00000094 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR2H - ATD 1 Conversion Result Register 2 High; 0x00000094 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR2HSTR;
    #define ATD1DR2H                    _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Byte
    #define ATD1DR2H_BIT8               _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT8
    #define ATD1DR2H_BIT9               _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT9
    #define ATD1DR2H_BIT10              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT10
    #define ATD1DR2H_BIT11              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT11
    #define ATD1DR2H_BIT12              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT12
    #define ATD1DR2H_BIT13              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT13
    #define ATD1DR2H_BIT14              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT14
    #define ATD1DR2H_BIT15              _ATD1DR2.Overlap_STR.ATD1DR2HSTR.Bits.BIT15
    
    #define ATD1DR2H_BIT8_MASK          1U
    #define ATD1DR2H_BIT9_MASK          2U
    #define ATD1DR2H_BIT10_MASK         4U
    #define ATD1DR2H_BIT11_MASK         8U
    #define ATD1DR2H_BIT12_MASK         16U
    #define ATD1DR2H_BIT13_MASK         32U
    #define ATD1DR2H_BIT14_MASK         64U
    #define ATD1DR2H_BIT15_MASK         128U
    

    /*** ATD1DR2L - ATD 1 Conversion Result Register 2 Low; 0x00000095 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR2LSTR;
    #define ATD1DR2L                    _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Byte
    #define ATD1DR2L_BIT6               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT6
    #define ATD1DR2L_BIT7               _ATD1DR2.Overlap_STR.ATD1DR2LSTR.Bits.BIT7
    #define ATD1DR2L_BIT_6              _ATD1DR2.Overlap_STR.ATD1DR2LSTR.MergedBits.grpBIT_6
    #define ATD1DR2L_BIT                ATD1DR2L_BIT_6
    
    #define ATD1DR2L_BIT6_MASK          64U
    #define ATD1DR2L_BIT7_MASK          128U
    #define ATD1DR2L_BIT_6_MASK         192U
    #define ATD1DR2L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR2STR;
extern volatile ATD1DR2STR _ATD1DR2 @(REG_BASE + 0x00000094UL);
#define ATD1DR2                         _ATD1DR2.Word
#define ATD1DR2_BIT6                    _ATD1DR2.Bits.BIT6
#define ATD1DR2_BIT7                    _ATD1DR2.Bits.BIT7
#define ATD1DR2_BIT8                    _ATD1DR2.Bits.BIT8
#define ATD1DR2_BIT9                    _ATD1DR2.Bits.BIT9
#define ATD1DR2_BIT10                   _ATD1DR2.Bits.BIT10
#define ATD1DR2_BIT11                   _ATD1DR2.Bits.BIT11
#define ATD1DR2_BIT12                   _ATD1DR2.Bits.BIT12
#define ATD1DR2_BIT13                   _ATD1DR2.Bits.BIT13
#define ATD1DR2_BIT14                   _ATD1DR2.Bits.BIT14
#define ATD1DR2_BIT15                   _ATD1DR2.Bits.BIT15
#define ATD1DR2_BIT_6                   _ATD1DR2.MergedBits.grpBIT_6
#define ATD1DR2_BIT                     ATD1DR2_BIT_6

#define ATD1DR2_BIT6_MASK               64U
#define ATD1DR2_BIT7_MASK               128U
#define ATD1DR2_BIT8_MASK               256U
#define ATD1DR2_BIT9_MASK               512U
#define ATD1DR2_BIT10_MASK              1024U
#define ATD1DR2_BIT11_MASK              2048U
#define ATD1DR2_BIT12_MASK              4096U
#define ATD1DR2_BIT13_MASK              8192U
#define ATD1DR2_BIT14_MASK              16384U
#define ATD1DR2_BIT15_MASK              32768U
#define ATD1DR2_BIT_6_MASK              65472U
#define ATD1DR2_BIT_6_BITNUM            6U


/*** ATD1DR3 - ATD 1 Conversion Result Register 3; 0x00000096 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR3H - ATD 1 Conversion Result Register 3 High; 0x00000096 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR3HSTR;
    #define ATD1DR3H                    _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Byte
    #define ATD1DR3H_BIT8               _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT8
    #define ATD1DR3H_BIT9               _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT9
    #define ATD1DR3H_BIT10              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT10
    #define ATD1DR3H_BIT11              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT11
    #define ATD1DR3H_BIT12              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT12
    #define ATD1DR3H_BIT13              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT13
    #define ATD1DR3H_BIT14              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT14
    #define ATD1DR3H_BIT15              _ATD1DR3.Overlap_STR.ATD1DR3HSTR.Bits.BIT15
    
    #define ATD1DR3H_BIT8_MASK          1U
    #define ATD1DR3H_BIT9_MASK          2U
    #define ATD1DR3H_BIT10_MASK         4U
    #define ATD1DR3H_BIT11_MASK         8U
    #define ATD1DR3H_BIT12_MASK         16U
    #define ATD1DR3H_BIT13_MASK         32U
    #define ATD1DR3H_BIT14_MASK         64U
    #define ATD1DR3H_BIT15_MASK         128U
    

    /*** ATD1DR3L - ATD 1 Conversion Result Register 3 Low; 0x00000097 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR3LSTR;
    #define ATD1DR3L                    _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Byte
    #define ATD1DR3L_BIT6               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT6
    #define ATD1DR3L_BIT7               _ATD1DR3.Overlap_STR.ATD1DR3LSTR.Bits.BIT7
    #define ATD1DR3L_BIT_6              _ATD1DR3.Overlap_STR.ATD1DR3LSTR.MergedBits.grpBIT_6
    #define ATD1DR3L_BIT                ATD1DR3L_BIT_6
    
    #define ATD1DR3L_BIT6_MASK          64U
    #define ATD1DR3L_BIT7_MASK          128U
    #define ATD1DR3L_BIT_6_MASK         192U
    #define ATD1DR3L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR3STR;
extern volatile ATD1DR3STR _ATD1DR3 @(REG_BASE + 0x00000096UL);
#define ATD1DR3                         _ATD1DR3.Word
#define ATD1DR3_BIT6                    _ATD1DR3.Bits.BIT6
#define ATD1DR3_BIT7                    _ATD1DR3.Bits.BIT7
#define ATD1DR3_BIT8                    _ATD1DR3.Bits.BIT8
#define ATD1DR3_BIT9                    _ATD1DR3.Bits.BIT9
#define ATD1DR3_BIT10                   _ATD1DR3.Bits.BIT10
#define ATD1DR3_BIT11                   _ATD1DR3.Bits.BIT11
#define ATD1DR3_BIT12                   _ATD1DR3.Bits.BIT12
#define ATD1DR3_BIT13                   _ATD1DR3.Bits.BIT13
#define ATD1DR3_BIT14                   _ATD1DR3.Bits.BIT14
#define ATD1DR3_BIT15                   _ATD1DR3.Bits.BIT15
#define ATD1DR3_BIT_6                   _ATD1DR3.MergedBits.grpBIT_6
#define ATD1DR3_BIT                     ATD1DR3_BIT_6

#define ATD1DR3_BIT6_MASK               64U
#define ATD1DR3_BIT7_MASK               128U
#define ATD1DR3_BIT8_MASK               256U
#define ATD1DR3_BIT9_MASK               512U
#define ATD1DR3_BIT10_MASK              1024U
#define ATD1DR3_BIT11_MASK              2048U
#define ATD1DR3_BIT12_MASK              4096U
#define ATD1DR3_BIT13_MASK              8192U
#define ATD1DR3_BIT14_MASK              16384U
#define ATD1DR3_BIT15_MASK              32768U
#define ATD1DR3_BIT_6_MASK              65472U
#define ATD1DR3_BIT_6_BITNUM            6U


/*** ATD1DR4 - ATD 1 Conversion Result Register 4; 0x00000098 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR4H - ATD 1 Conversion Result Register 4 High; 0x00000098 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR4HSTR;
    #define ATD1DR4H                    _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Byte
    #define ATD1DR4H_BIT8               _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT8
    #define ATD1DR4H_BIT9               _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT9
    #define ATD1DR4H_BIT10              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT10
    #define ATD1DR4H_BIT11              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT11
    #define ATD1DR4H_BIT12              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT12
    #define ATD1DR4H_BIT13              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT13
    #define ATD1DR4H_BIT14              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT14
    #define ATD1DR4H_BIT15              _ATD1DR4.Overlap_STR.ATD1DR4HSTR.Bits.BIT15
    
    #define ATD1DR4H_BIT8_MASK          1U
    #define ATD1DR4H_BIT9_MASK          2U
    #define ATD1DR4H_BIT10_MASK         4U
    #define ATD1DR4H_BIT11_MASK         8U
    #define ATD1DR4H_BIT12_MASK         16U
    #define ATD1DR4H_BIT13_MASK         32U
    #define ATD1DR4H_BIT14_MASK         64U
    #define ATD1DR4H_BIT15_MASK         128U
    

    /*** ATD1DR4L - ATD 1 Conversion Result Register 4 Low; 0x00000099 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR4LSTR;
    #define ATD1DR4L                    _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Byte
    #define ATD1DR4L_BIT6               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT6
    #define ATD1DR4L_BIT7               _ATD1DR4.Overlap_STR.ATD1DR4LSTR.Bits.BIT7
    #define ATD1DR4L_BIT_6              _ATD1DR4.Overlap_STR.ATD1DR4LSTR.MergedBits.grpBIT_6
    #define ATD1DR4L_BIT                ATD1DR4L_BIT_6
    
    #define ATD1DR4L_BIT6_MASK          64U
    #define ATD1DR4L_BIT7_MASK          128U
    #define ATD1DR4L_BIT_6_MASK         192U
    #define ATD1DR4L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR4STR;
extern volatile ATD1DR4STR _ATD1DR4 @(REG_BASE + 0x00000098UL);
#define ATD1DR4                         _ATD1DR4.Word
#define ATD1DR4_BIT6                    _ATD1DR4.Bits.BIT6
#define ATD1DR4_BIT7                    _ATD1DR4.Bits.BIT7
#define ATD1DR4_BIT8                    _ATD1DR4.Bits.BIT8
#define ATD1DR4_BIT9                    _ATD1DR4.Bits.BIT9
#define ATD1DR4_BIT10                   _ATD1DR4.Bits.BIT10
#define ATD1DR4_BIT11                   _ATD1DR4.Bits.BIT11
#define ATD1DR4_BIT12                   _ATD1DR4.Bits.BIT12
#define ATD1DR4_BIT13                   _ATD1DR4.Bits.BIT13
#define ATD1DR4_BIT14                   _ATD1DR4.Bits.BIT14
#define ATD1DR4_BIT15                   _ATD1DR4.Bits.BIT15
#define ATD1DR4_BIT_6                   _ATD1DR4.MergedBits.grpBIT_6
#define ATD1DR4_BIT                     ATD1DR4_BIT_6

#define ATD1DR4_BIT6_MASK               64U
#define ATD1DR4_BIT7_MASK               128U
#define ATD1DR4_BIT8_MASK               256U
#define ATD1DR4_BIT9_MASK               512U
#define ATD1DR4_BIT10_MASK              1024U
#define ATD1DR4_BIT11_MASK              2048U
#define ATD1DR4_BIT12_MASK              4096U
#define ATD1DR4_BIT13_MASK              8192U
#define ATD1DR4_BIT14_MASK              16384U
#define ATD1DR4_BIT15_MASK              32768U
#define ATD1DR4_BIT_6_MASK              65472U
#define ATD1DR4_BIT_6_BITNUM            6U


/*** ATD1DR5 - ATD 1 Conversion Result Register 5; 0x0000009A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR5H - ATD 1 Conversion Result Register 5 High; 0x0000009A ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR5HSTR;
    #define ATD1DR5H                    _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Byte
    #define ATD1DR5H_BIT8               _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT8
    #define ATD1DR5H_BIT9               _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT9
    #define ATD1DR5H_BIT10              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT10
    #define ATD1DR5H_BIT11              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT11
    #define ATD1DR5H_BIT12              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT12
    #define ATD1DR5H_BIT13              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT13
    #define ATD1DR5H_BIT14              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT14
    #define ATD1DR5H_BIT15              _ATD1DR5.Overlap_STR.ATD1DR5HSTR.Bits.BIT15
    
    #define ATD1DR5H_BIT8_MASK          1U
    #define ATD1DR5H_BIT9_MASK          2U
    #define ATD1DR5H_BIT10_MASK         4U
    #define ATD1DR5H_BIT11_MASK         8U
    #define ATD1DR5H_BIT12_MASK         16U
    #define ATD1DR5H_BIT13_MASK         32U
    #define ATD1DR5H_BIT14_MASK         64U
    #define ATD1DR5H_BIT15_MASK         128U
    

    /*** ATD1DR5L - ATD 1 Conversion Result Register 5 Low; 0x0000009B ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR5LSTR;
    #define ATD1DR5L                    _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Byte
    #define ATD1DR5L_BIT6               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT6
    #define ATD1DR5L_BIT7               _ATD1DR5.Overlap_STR.ATD1DR5LSTR.Bits.BIT7
    #define ATD1DR5L_BIT_6              _ATD1DR5.Overlap_STR.ATD1DR5LSTR.MergedBits.grpBIT_6
    #define ATD1DR5L_BIT                ATD1DR5L_BIT_6
    
    #define ATD1DR5L_BIT6_MASK          64U
    #define ATD1DR5L_BIT7_MASK          128U
    #define ATD1DR5L_BIT_6_MASK         192U
    #define ATD1DR5L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR5STR;
extern volatile ATD1DR5STR _ATD1DR5 @(REG_BASE + 0x0000009AUL);
#define ATD1DR5                         _ATD1DR5.Word
#define ATD1DR5_BIT6                    _ATD1DR5.Bits.BIT6
#define ATD1DR5_BIT7                    _ATD1DR5.Bits.BIT7
#define ATD1DR5_BIT8                    _ATD1DR5.Bits.BIT8
#define ATD1DR5_BIT9                    _ATD1DR5.Bits.BIT9
#define ATD1DR5_BIT10                   _ATD1DR5.Bits.BIT10
#define ATD1DR5_BIT11                   _ATD1DR5.Bits.BIT11
#define ATD1DR5_BIT12                   _ATD1DR5.Bits.BIT12
#define ATD1DR5_BIT13                   _ATD1DR5.Bits.BIT13
#define ATD1DR5_BIT14                   _ATD1DR5.Bits.BIT14
#define ATD1DR5_BIT15                   _ATD1DR5.Bits.BIT15
#define ATD1DR5_BIT_6                   _ATD1DR5.MergedBits.grpBIT_6
#define ATD1DR5_BIT                     ATD1DR5_BIT_6

#define ATD1DR5_BIT6_MASK               64U
#define ATD1DR5_BIT7_MASK               128U
#define ATD1DR5_BIT8_MASK               256U
#define ATD1DR5_BIT9_MASK               512U
#define ATD1DR5_BIT10_MASK              1024U
#define ATD1DR5_BIT11_MASK              2048U
#define ATD1DR5_BIT12_MASK              4096U
#define ATD1DR5_BIT13_MASK              8192U
#define ATD1DR5_BIT14_MASK              16384U
#define ATD1DR5_BIT15_MASK              32768U
#define ATD1DR5_BIT_6_MASK              65472U
#define ATD1DR5_BIT_6_BITNUM            6U


/*** ATD1DR6 - ATD 1 Conversion Result Register 6; 0x0000009C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR6H - ATD 1 Conversion Result Register 6 High; 0x0000009C ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR6HSTR;
    #define ATD1DR6H                    _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Byte
    #define ATD1DR6H_BIT8               _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT8
    #define ATD1DR6H_BIT9               _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT9
    #define ATD1DR6H_BIT10              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT10
    #define ATD1DR6H_BIT11              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT11
    #define ATD1DR6H_BIT12              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT12
    #define ATD1DR6H_BIT13              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT13
    #define ATD1DR6H_BIT14              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT14
    #define ATD1DR6H_BIT15              _ATD1DR6.Overlap_STR.ATD1DR6HSTR.Bits.BIT15
    
    #define ATD1DR6H_BIT8_MASK          1U
    #define ATD1DR6H_BIT9_MASK          2U
    #define ATD1DR6H_BIT10_MASK         4U
    #define ATD1DR6H_BIT11_MASK         8U
    #define ATD1DR6H_BIT12_MASK         16U
    #define ATD1DR6H_BIT13_MASK         32U
    #define ATD1DR6H_BIT14_MASK         64U
    #define ATD1DR6H_BIT15_MASK         128U
    

    /*** ATD1DR6L - ATD 1 Conversion Result Register 6 Low; 0x0000009D ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR6LSTR;
    #define ATD1DR6L                    _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Byte
    #define ATD1DR6L_BIT6               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT6
    #define ATD1DR6L_BIT7               _ATD1DR6.Overlap_STR.ATD1DR6LSTR.Bits.BIT7
    #define ATD1DR6L_BIT_6              _ATD1DR6.Overlap_STR.ATD1DR6LSTR.MergedBits.grpBIT_6
    #define ATD1DR6L_BIT                ATD1DR6L_BIT_6
    
    #define ATD1DR6L_BIT6_MASK          64U
    #define ATD1DR6L_BIT7_MASK          128U
    #define ATD1DR6L_BIT_6_MASK         192U
    #define ATD1DR6L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR6STR;
extern volatile ATD1DR6STR _ATD1DR6 @(REG_BASE + 0x0000009CUL);
#define ATD1DR6                         _ATD1DR6.Word
#define ATD1DR6_BIT6                    _ATD1DR6.Bits.BIT6
#define ATD1DR6_BIT7                    _ATD1DR6.Bits.BIT7
#define ATD1DR6_BIT8                    _ATD1DR6.Bits.BIT8
#define ATD1DR6_BIT9                    _ATD1DR6.Bits.BIT9
#define ATD1DR6_BIT10                   _ATD1DR6.Bits.BIT10
#define ATD1DR6_BIT11                   _ATD1DR6.Bits.BIT11
#define ATD1DR6_BIT12                   _ATD1DR6.Bits.BIT12
#define ATD1DR6_BIT13                   _ATD1DR6.Bits.BIT13
#define ATD1DR6_BIT14                   _ATD1DR6.Bits.BIT14
#define ATD1DR6_BIT15                   _ATD1DR6.Bits.BIT15
#define ATD1DR6_BIT_6                   _ATD1DR6.MergedBits.grpBIT_6
#define ATD1DR6_BIT                     ATD1DR6_BIT_6

#define ATD1DR6_BIT6_MASK               64U
#define ATD1DR6_BIT7_MASK               128U
#define ATD1DR6_BIT8_MASK               256U
#define ATD1DR6_BIT9_MASK               512U
#define ATD1DR6_BIT10_MASK              1024U
#define ATD1DR6_BIT11_MASK              2048U
#define ATD1DR6_BIT12_MASK              4096U
#define ATD1DR6_BIT13_MASK              8192U
#define ATD1DR6_BIT14_MASK              16384U
#define ATD1DR6_BIT15_MASK              32768U
#define ATD1DR6_BIT_6_MASK              65472U
#define ATD1DR6_BIT_6_BITNUM            6U


/*** ATD1DR7 - ATD 1 Conversion Result Register 7; 0x0000009E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR7H - ATD 1 Conversion Result Register 7 High; 0x0000009E ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR7HSTR;
    #define ATD1DR7H                    _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Byte
    #define ATD1DR7H_BIT8               _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT8
    #define ATD1DR7H_BIT9               _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT9
    #define ATD1DR7H_BIT10              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT10
    #define ATD1DR7H_BIT11              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT11
    #define ATD1DR7H_BIT12              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT12
    #define ATD1DR7H_BIT13              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT13
    #define ATD1DR7H_BIT14              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT14
    #define ATD1DR7H_BIT15              _ATD1DR7.Overlap_STR.ATD1DR7HSTR.Bits.BIT15
    
    #define ATD1DR7H_BIT8_MASK          1U
    #define ATD1DR7H_BIT9_MASK          2U
    #define ATD1DR7H_BIT10_MASK         4U
    #define ATD1DR7H_BIT11_MASK         8U
    #define ATD1DR7H_BIT12_MASK         16U
    #define ATD1DR7H_BIT13_MASK         32U
    #define ATD1DR7H_BIT14_MASK         64U
    #define ATD1DR7H_BIT15_MASK         128U
    

    /*** ATD1DR7L - ATD 1 Conversion Result Register 7 Low; 0x0000009F ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR7LSTR;
    #define ATD1DR7L                    _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Byte
    #define ATD1DR7L_BIT6               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT6
    #define ATD1DR7L_BIT7               _ATD1DR7.Overlap_STR.ATD1DR7LSTR.Bits.BIT7
    #define ATD1DR7L_BIT_6              _ATD1DR7.Overlap_STR.ATD1DR7LSTR.MergedBits.grpBIT_6
    #define ATD1DR7L_BIT                ATD1DR7L_BIT_6
    
    #define ATD1DR7L_BIT6_MASK          64U
    #define ATD1DR7L_BIT7_MASK          128U
    #define ATD1DR7L_BIT_6_MASK         192U
    #define ATD1DR7L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR7STR;
extern volatile ATD1DR7STR _ATD1DR7 @(REG_BASE + 0x0000009EUL);
#define ATD1DR7                         _ATD1DR7.Word
#define ATD1DR7_BIT6                    _ATD1DR7.Bits.BIT6
#define ATD1DR7_BIT7                    _ATD1DR7.Bits.BIT7
#define ATD1DR7_BIT8                    _ATD1DR7.Bits.BIT8
#define ATD1DR7_BIT9                    _ATD1DR7.Bits.BIT9
#define ATD1DR7_BIT10                   _ATD1DR7.Bits.BIT10
#define ATD1DR7_BIT11                   _ATD1DR7.Bits.BIT11
#define ATD1DR7_BIT12                   _ATD1DR7.Bits.BIT12
#define ATD1DR7_BIT13                   _ATD1DR7.Bits.BIT13
#define ATD1DR7_BIT14                   _ATD1DR7.Bits.BIT14
#define ATD1DR7_BIT15                   _ATD1DR7.Bits.BIT15
#define ATD1DR7_BIT_6                   _ATD1DR7.MergedBits.grpBIT_6
#define ATD1DR7_BIT                     ATD1DR7_BIT_6

#define ATD1DR7_BIT6_MASK               64U
#define ATD1DR7_BIT7_MASK               128U
#define ATD1DR7_BIT8_MASK               256U
#define ATD1DR7_BIT9_MASK               512U
#define ATD1DR7_BIT10_MASK              1024U
#define ATD1DR7_BIT11_MASK              2048U
#define ATD1DR7_BIT12_MASK              4096U
#define ATD1DR7_BIT13_MASK              8192U
#define ATD1DR7_BIT14_MASK              16384U
#define ATD1DR7_BIT15_MASK              32768U
#define ATD1DR7_BIT_6_MASK              65472U
#define ATD1DR7_BIT_6_BITNUM            6U


/*** ATD1DR8 - ATD 1 Conversion Result Register 8; 0x000000A0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR8H - ATD 1 Conversion Result Register 8 High; 0x000000A0 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR8HSTR;
    #define ATD1DR8H                    _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Byte
    #define ATD1DR8H_BIT8               _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT8
    #define ATD1DR8H_BIT9               _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT9
    #define ATD1DR8H_BIT10              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT10
    #define ATD1DR8H_BIT11              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT11
    #define ATD1DR8H_BIT12              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT12
    #define ATD1DR8H_BIT13              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT13
    #define ATD1DR8H_BIT14              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT14
    #define ATD1DR8H_BIT15              _ATD1DR8.Overlap_STR.ATD1DR8HSTR.Bits.BIT15
    
    #define ATD1DR8H_BIT8_MASK          1U
    #define ATD1DR8H_BIT9_MASK          2U
    #define ATD1DR8H_BIT10_MASK         4U
    #define ATD1DR8H_BIT11_MASK         8U
    #define ATD1DR8H_BIT12_MASK         16U
    #define ATD1DR8H_BIT13_MASK         32U
    #define ATD1DR8H_BIT14_MASK         64U
    #define ATD1DR8H_BIT15_MASK         128U
    

    /*** ATD1DR8L - ATD 1 Conversion Result Register 8 Low; 0x000000A1 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR8LSTR;
    #define ATD1DR8L                    _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Byte
    #define ATD1DR8L_BIT6               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT6
    #define ATD1DR8L_BIT7               _ATD1DR8.Overlap_STR.ATD1DR8LSTR.Bits.BIT7
    #define ATD1DR8L_BIT_6              _ATD1DR8.Overlap_STR.ATD1DR8LSTR.MergedBits.grpBIT_6
    #define ATD1DR8L_BIT                ATD1DR8L_BIT_6
    
    #define ATD1DR8L_BIT6_MASK          64U
    #define ATD1DR8L_BIT7_MASK          128U
    #define ATD1DR8L_BIT_6_MASK         192U
    #define ATD1DR8L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR8STR;
extern volatile ATD1DR8STR _ATD1DR8 @(REG_BASE + 0x000000A0UL);
#define ATD1DR8                         _ATD1DR8.Word
#define ATD1DR8_BIT6                    _ATD1DR8.Bits.BIT6
#define ATD1DR8_BIT7                    _ATD1DR8.Bits.BIT7
#define ATD1DR8_BIT8                    _ATD1DR8.Bits.BIT8
#define ATD1DR8_BIT9                    _ATD1DR8.Bits.BIT9
#define ATD1DR8_BIT10                   _ATD1DR8.Bits.BIT10
#define ATD1DR8_BIT11                   _ATD1DR8.Bits.BIT11
#define ATD1DR8_BIT12                   _ATD1DR8.Bits.BIT12
#define ATD1DR8_BIT13                   _ATD1DR8.Bits.BIT13
#define ATD1DR8_BIT14                   _ATD1DR8.Bits.BIT14
#define ATD1DR8_BIT15                   _ATD1DR8.Bits.BIT15
#define ATD1DR8_BIT_6                   _ATD1DR8.MergedBits.grpBIT_6
#define ATD1DR8_BIT                     ATD1DR8_BIT_6

#define ATD1DR8_BIT6_MASK               64U
#define ATD1DR8_BIT7_MASK               128U
#define ATD1DR8_BIT8_MASK               256U
#define ATD1DR8_BIT9_MASK               512U
#define ATD1DR8_BIT10_MASK              1024U
#define ATD1DR8_BIT11_MASK              2048U
#define ATD1DR8_BIT12_MASK              4096U
#define ATD1DR8_BIT13_MASK              8192U
#define ATD1DR8_BIT14_MASK              16384U
#define ATD1DR8_BIT15_MASK              32768U
#define ATD1DR8_BIT_6_MASK              65472U
#define ATD1DR8_BIT_6_BITNUM            6U


/*** ATD1DR9 - ATD 1 Conversion Result Register 9; 0x000000A2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR9H - ATD 1 Conversion Result Register 9 High; 0x000000A2 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR9HSTR;
    #define ATD1DR9H                    _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Byte
    #define ATD1DR9H_BIT8               _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT8
    #define ATD1DR9H_BIT9               _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT9
    #define ATD1DR9H_BIT10              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT10
    #define ATD1DR9H_BIT11              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT11
    #define ATD1DR9H_BIT12              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT12
    #define ATD1DR9H_BIT13              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT13
    #define ATD1DR9H_BIT14              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT14
    #define ATD1DR9H_BIT15              _ATD1DR9.Overlap_STR.ATD1DR9HSTR.Bits.BIT15
    
    #define ATD1DR9H_BIT8_MASK          1U
    #define ATD1DR9H_BIT9_MASK          2U
    #define ATD1DR9H_BIT10_MASK         4U
    #define ATD1DR9H_BIT11_MASK         8U
    #define ATD1DR9H_BIT12_MASK         16U
    #define ATD1DR9H_BIT13_MASK         32U
    #define ATD1DR9H_BIT14_MASK         64U
    #define ATD1DR9H_BIT15_MASK         128U
    

    /*** ATD1DR9L - ATD 1 Conversion Result Register 9 Low; 0x000000A3 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR9LSTR;
    #define ATD1DR9L                    _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Byte
    #define ATD1DR9L_BIT6               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT6
    #define ATD1DR9L_BIT7               _ATD1DR9.Overlap_STR.ATD1DR9LSTR.Bits.BIT7
    #define ATD1DR9L_BIT_6              _ATD1DR9.Overlap_STR.ATD1DR9LSTR.MergedBits.grpBIT_6
    #define ATD1DR9L_BIT                ATD1DR9L_BIT_6
    
    #define ATD1DR9L_BIT6_MASK          64U
    #define ATD1DR9L_BIT7_MASK          128U
    #define ATD1DR9L_BIT_6_MASK         192U
    #define ATD1DR9L_BIT_6_BITNUM       6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR9STR;
extern volatile ATD1DR9STR _ATD1DR9 @(REG_BASE + 0x000000A2UL);
#define ATD1DR9                         _ATD1DR9.Word
#define ATD1DR9_BIT6                    _ATD1DR9.Bits.BIT6
#define ATD1DR9_BIT7                    _ATD1DR9.Bits.BIT7
#define ATD1DR9_BIT8                    _ATD1DR9.Bits.BIT8
#define ATD1DR9_BIT9                    _ATD1DR9.Bits.BIT9
#define ATD1DR9_BIT10                   _ATD1DR9.Bits.BIT10
#define ATD1DR9_BIT11                   _ATD1DR9.Bits.BIT11
#define ATD1DR9_BIT12                   _ATD1DR9.Bits.BIT12
#define ATD1DR9_BIT13                   _ATD1DR9.Bits.BIT13
#define ATD1DR9_BIT14                   _ATD1DR9.Bits.BIT14
#define ATD1DR9_BIT15                   _ATD1DR9.Bits.BIT15
#define ATD1DR9_BIT_6                   _ATD1DR9.MergedBits.grpBIT_6
#define ATD1DR9_BIT                     ATD1DR9_BIT_6

#define ATD1DR9_BIT6_MASK               64U
#define ATD1DR9_BIT7_MASK               128U
#define ATD1DR9_BIT8_MASK               256U
#define ATD1DR9_BIT9_MASK               512U
#define ATD1DR9_BIT10_MASK              1024U
#define ATD1DR9_BIT11_MASK              2048U
#define ATD1DR9_BIT12_MASK              4096U
#define ATD1DR9_BIT13_MASK              8192U
#define ATD1DR9_BIT14_MASK              16384U
#define ATD1DR9_BIT15_MASK              32768U
#define ATD1DR9_BIT_6_MASK              65472U
#define ATD1DR9_BIT_6_BITNUM            6U


/*** ATD1DR10 - ATD 1 Conversion Result Register 10; 0x000000A4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR10H - ATD 1 Conversion Result Register 10 High; 0x000000A4 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR10HSTR;
    #define ATD1DR10H                   _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Byte
    #define ATD1DR10H_BIT8              _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT8
    #define ATD1DR10H_BIT9              _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT9
    #define ATD1DR10H_BIT10             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT10
    #define ATD1DR10H_BIT11             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT11
    #define ATD1DR10H_BIT12             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT12
    #define ATD1DR10H_BIT13             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT13
    #define ATD1DR10H_BIT14             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT14
    #define ATD1DR10H_BIT15             _ATD1DR10.Overlap_STR.ATD1DR10HSTR.Bits.BIT15
    
    #define ATD1DR10H_BIT8_MASK         1U
    #define ATD1DR10H_BIT9_MASK         2U
    #define ATD1DR10H_BIT10_MASK        4U
    #define ATD1DR10H_BIT11_MASK        8U
    #define ATD1DR10H_BIT12_MASK        16U
    #define ATD1DR10H_BIT13_MASK        32U
    #define ATD1DR10H_BIT14_MASK        64U
    #define ATD1DR10H_BIT15_MASK        128U
    

    /*** ATD1DR10L - ATD 1 Conversion Result Register 10 Low; 0x000000A5 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR10LSTR;
    #define ATD1DR10L                   _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Byte
    #define ATD1DR10L_BIT6              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT6
    #define ATD1DR10L_BIT7              _ATD1DR10.Overlap_STR.ATD1DR10LSTR.Bits.BIT7
    #define ATD1DR10L_BIT_6             _ATD1DR10.Overlap_STR.ATD1DR10LSTR.MergedBits.grpBIT_6
    #define ATD1DR10L_BIT               ATD1DR10L_BIT_6
    
    #define ATD1DR10L_BIT6_MASK         64U
    #define ATD1DR10L_BIT7_MASK         128U
    #define ATD1DR10L_BIT_6_MASK        192U
    #define ATD1DR10L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR10STR;
extern volatile ATD1DR10STR _ATD1DR10 @(REG_BASE + 0x000000A4UL);
#define ATD1DR10                        _ATD1DR10.Word
#define ATD1DR10_BIT6                   _ATD1DR10.Bits.BIT6
#define ATD1DR10_BIT7                   _ATD1DR10.Bits.BIT7
#define ATD1DR10_BIT8                   _ATD1DR10.Bits.BIT8
#define ATD1DR10_BIT9                   _ATD1DR10.Bits.BIT9
#define ATD1DR10_BIT10                  _ATD1DR10.Bits.BIT10
#define ATD1DR10_BIT11                  _ATD1DR10.Bits.BIT11
#define ATD1DR10_BIT12                  _ATD1DR10.Bits.BIT12
#define ATD1DR10_BIT13                  _ATD1DR10.Bits.BIT13
#define ATD1DR10_BIT14                  _ATD1DR10.Bits.BIT14
#define ATD1DR10_BIT15                  _ATD1DR10.Bits.BIT15
#define ATD1DR10_BIT_6                  _ATD1DR10.MergedBits.grpBIT_6
#define ATD1DR10_BIT                    ATD1DR10_BIT_6

#define ATD1DR10_BIT6_MASK              64U
#define ATD1DR10_BIT7_MASK              128U
#define ATD1DR10_BIT8_MASK              256U
#define ATD1DR10_BIT9_MASK              512U
#define ATD1DR10_BIT10_MASK             1024U
#define ATD1DR10_BIT11_MASK             2048U
#define ATD1DR10_BIT12_MASK             4096U
#define ATD1DR10_BIT13_MASK             8192U
#define ATD1DR10_BIT14_MASK             16384U
#define ATD1DR10_BIT15_MASK             32768U
#define ATD1DR10_BIT_6_MASK             65472U
#define ATD1DR10_BIT_6_BITNUM           6U


/*** ATD1DR11 - ATD 1 Conversion Result Register 11; 0x000000A6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR11H - ATD 1 Conversion Result Register 11 High; 0x000000A6 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR11HSTR;
    #define ATD1DR11H                   _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Byte
    #define ATD1DR11H_BIT8              _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT8
    #define ATD1DR11H_BIT9              _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT9
    #define ATD1DR11H_BIT10             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT10
    #define ATD1DR11H_BIT11             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT11
    #define ATD1DR11H_BIT12             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT12
    #define ATD1DR11H_BIT13             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT13
    #define ATD1DR11H_BIT14             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT14
    #define ATD1DR11H_BIT15             _ATD1DR11.Overlap_STR.ATD1DR11HSTR.Bits.BIT15
    
    #define ATD1DR11H_BIT8_MASK         1U
    #define ATD1DR11H_BIT9_MASK         2U
    #define ATD1DR11H_BIT10_MASK        4U
    #define ATD1DR11H_BIT11_MASK        8U
    #define ATD1DR11H_BIT12_MASK        16U
    #define ATD1DR11H_BIT13_MASK        32U
    #define ATD1DR11H_BIT14_MASK        64U
    #define ATD1DR11H_BIT15_MASK        128U
    

    /*** ATD1DR11L - ATD 1 Conversion Result Register 11 Low; 0x000000A7 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR11LSTR;
    #define ATD1DR11L                   _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Byte
    #define ATD1DR11L_BIT6              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT6
    #define ATD1DR11L_BIT7              _ATD1DR11.Overlap_STR.ATD1DR11LSTR.Bits.BIT7
    #define ATD1DR11L_BIT_6             _ATD1DR11.Overlap_STR.ATD1DR11LSTR.MergedBits.grpBIT_6
    #define ATD1DR11L_BIT               ATD1DR11L_BIT_6
    
    #define ATD1DR11L_BIT6_MASK         64U
    #define ATD1DR11L_BIT7_MASK         128U
    #define ATD1DR11L_BIT_6_MASK        192U
    #define ATD1DR11L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR11STR;
extern volatile ATD1DR11STR _ATD1DR11 @(REG_BASE + 0x000000A6UL);
#define ATD1DR11                        _ATD1DR11.Word
#define ATD1DR11_BIT6                   _ATD1DR11.Bits.BIT6
#define ATD1DR11_BIT7                   _ATD1DR11.Bits.BIT7
#define ATD1DR11_BIT8                   _ATD1DR11.Bits.BIT8
#define ATD1DR11_BIT9                   _ATD1DR11.Bits.BIT9
#define ATD1DR11_BIT10                  _ATD1DR11.Bits.BIT10
#define ATD1DR11_BIT11                  _ATD1DR11.Bits.BIT11
#define ATD1DR11_BIT12                  _ATD1DR11.Bits.BIT12
#define ATD1DR11_BIT13                  _ATD1DR11.Bits.BIT13
#define ATD1DR11_BIT14                  _ATD1DR11.Bits.BIT14
#define ATD1DR11_BIT15                  _ATD1DR11.Bits.BIT15
#define ATD1DR11_BIT_6                  _ATD1DR11.MergedBits.grpBIT_6
#define ATD1DR11_BIT                    ATD1DR11_BIT_6

#define ATD1DR11_BIT6_MASK              64U
#define ATD1DR11_BIT7_MASK              128U
#define ATD1DR11_BIT8_MASK              256U
#define ATD1DR11_BIT9_MASK              512U
#define ATD1DR11_BIT10_MASK             1024U
#define ATD1DR11_BIT11_MASK             2048U
#define ATD1DR11_BIT12_MASK             4096U
#define ATD1DR11_BIT13_MASK             8192U
#define ATD1DR11_BIT14_MASK             16384U
#define ATD1DR11_BIT15_MASK             32768U
#define ATD1DR11_BIT_6_MASK             65472U
#define ATD1DR11_BIT_6_BITNUM           6U


/*** ATD1DR12 - ATD 1 Conversion Result Register 12; 0x000000A8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR12H - ATD 1 Conversion Result Register 12 High; 0x000000A8 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR12HSTR;
    #define ATD1DR12H                   _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Byte
    #define ATD1DR12H_BIT8              _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT8
    #define ATD1DR12H_BIT9              _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT9
    #define ATD1DR12H_BIT10             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT10
    #define ATD1DR12H_BIT11             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT11
    #define ATD1DR12H_BIT12             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT12
    #define ATD1DR12H_BIT13             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT13
    #define ATD1DR12H_BIT14             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT14
    #define ATD1DR12H_BIT15             _ATD1DR12.Overlap_STR.ATD1DR12HSTR.Bits.BIT15
    
    #define ATD1DR12H_BIT8_MASK         1U
    #define ATD1DR12H_BIT9_MASK         2U
    #define ATD1DR12H_BIT10_MASK        4U
    #define ATD1DR12H_BIT11_MASK        8U
    #define ATD1DR12H_BIT12_MASK        16U
    #define ATD1DR12H_BIT13_MASK        32U
    #define ATD1DR12H_BIT14_MASK        64U
    #define ATD1DR12H_BIT15_MASK        128U
    

    /*** ATD1DR12L - ATD 1 Conversion Result Register 12 Low; 0x000000A9 ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR12LSTR;
    #define ATD1DR12L                   _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Byte
    #define ATD1DR12L_BIT6              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT6
    #define ATD1DR12L_BIT7              _ATD1DR12.Overlap_STR.ATD1DR12LSTR.Bits.BIT7
    #define ATD1DR12L_BIT_6             _ATD1DR12.Overlap_STR.ATD1DR12LSTR.MergedBits.grpBIT_6
    #define ATD1DR12L_BIT               ATD1DR12L_BIT_6
    
    #define ATD1DR12L_BIT6_MASK         64U
    #define ATD1DR12L_BIT7_MASK         128U
    #define ATD1DR12L_BIT_6_MASK        192U
    #define ATD1DR12L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR12STR;
extern volatile ATD1DR12STR _ATD1DR12 @(REG_BASE + 0x000000A8UL);
#define ATD1DR12                        _ATD1DR12.Word
#define ATD1DR12_BIT6                   _ATD1DR12.Bits.BIT6
#define ATD1DR12_BIT7                   _ATD1DR12.Bits.BIT7
#define ATD1DR12_BIT8                   _ATD1DR12.Bits.BIT8
#define ATD1DR12_BIT9                   _ATD1DR12.Bits.BIT9
#define ATD1DR12_BIT10                  _ATD1DR12.Bits.BIT10
#define ATD1DR12_BIT11                  _ATD1DR12.Bits.BIT11
#define ATD1DR12_BIT12                  _ATD1DR12.Bits.BIT12
#define ATD1DR12_BIT13                  _ATD1DR12.Bits.BIT13
#define ATD1DR12_BIT14                  _ATD1DR12.Bits.BIT14
#define ATD1DR12_BIT15                  _ATD1DR12.Bits.BIT15
#define ATD1DR12_BIT_6                  _ATD1DR12.MergedBits.grpBIT_6
#define ATD1DR12_BIT                    ATD1DR12_BIT_6

#define ATD1DR12_BIT6_MASK              64U
#define ATD1DR12_BIT7_MASK              128U
#define ATD1DR12_BIT8_MASK              256U
#define ATD1DR12_BIT9_MASK              512U
#define ATD1DR12_BIT10_MASK             1024U
#define ATD1DR12_BIT11_MASK             2048U
#define ATD1DR12_BIT12_MASK             4096U
#define ATD1DR12_BIT13_MASK             8192U
#define ATD1DR12_BIT14_MASK             16384U
#define ATD1DR12_BIT15_MASK             32768U
#define ATD1DR12_BIT_6_MASK             65472U
#define ATD1DR12_BIT_6_BITNUM           6U


/*** ATD1DR13 - ATD 1 Conversion Result Register 13; 0x000000AA ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR13H - ATD 1 Conversion Result Register 13 High; 0x000000AA ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR13HSTR;
    #define ATD1DR13H                   _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Byte
    #define ATD1DR13H_BIT8              _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT8
    #define ATD1DR13H_BIT9              _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT9
    #define ATD1DR13H_BIT10             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT10
    #define ATD1DR13H_BIT11             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT11
    #define ATD1DR13H_BIT12             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT12
    #define ATD1DR13H_BIT13             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT13
    #define ATD1DR13H_BIT14             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT14
    #define ATD1DR13H_BIT15             _ATD1DR13.Overlap_STR.ATD1DR13HSTR.Bits.BIT15
    
    #define ATD1DR13H_BIT8_MASK         1U
    #define ATD1DR13H_BIT9_MASK         2U
    #define ATD1DR13H_BIT10_MASK        4U
    #define ATD1DR13H_BIT11_MASK        8U
    #define ATD1DR13H_BIT12_MASK        16U
    #define ATD1DR13H_BIT13_MASK        32U
    #define ATD1DR13H_BIT14_MASK        64U
    #define ATD1DR13H_BIT15_MASK        128U
    

    /*** ATD1DR13L - ATD 1 Conversion Result Register 13 Low; 0x000000AB ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR13LSTR;
    #define ATD1DR13L                   _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Byte
    #define ATD1DR13L_BIT6              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT6
    #define ATD1DR13L_BIT7              _ATD1DR13.Overlap_STR.ATD1DR13LSTR.Bits.BIT7
    #define ATD1DR13L_BIT_6             _ATD1DR13.Overlap_STR.ATD1DR13LSTR.MergedBits.grpBIT_6
    #define ATD1DR13L_BIT               ATD1DR13L_BIT_6
    
    #define ATD1DR13L_BIT6_MASK         64U
    #define ATD1DR13L_BIT7_MASK         128U
    #define ATD1DR13L_BIT_6_MASK        192U
    #define ATD1DR13L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR13STR;
extern volatile ATD1DR13STR _ATD1DR13 @(REG_BASE + 0x000000AAUL);
#define ATD1DR13                        _ATD1DR13.Word
#define ATD1DR13_BIT6                   _ATD1DR13.Bits.BIT6
#define ATD1DR13_BIT7                   _ATD1DR13.Bits.BIT7
#define ATD1DR13_BIT8                   _ATD1DR13.Bits.BIT8
#define ATD1DR13_BIT9                   _ATD1DR13.Bits.BIT9
#define ATD1DR13_BIT10                  _ATD1DR13.Bits.BIT10
#define ATD1DR13_BIT11                  _ATD1DR13.Bits.BIT11
#define ATD1DR13_BIT12                  _ATD1DR13.Bits.BIT12
#define ATD1DR13_BIT13                  _ATD1DR13.Bits.BIT13
#define ATD1DR13_BIT14                  _ATD1DR13.Bits.BIT14
#define ATD1DR13_BIT15                  _ATD1DR13.Bits.BIT15
#define ATD1DR13_BIT_6                  _ATD1DR13.MergedBits.grpBIT_6
#define ATD1DR13_BIT                    ATD1DR13_BIT_6

#define ATD1DR13_BIT6_MASK              64U
#define ATD1DR13_BIT7_MASK              128U
#define ATD1DR13_BIT8_MASK              256U
#define ATD1DR13_BIT9_MASK              512U
#define ATD1DR13_BIT10_MASK             1024U
#define ATD1DR13_BIT11_MASK             2048U
#define ATD1DR13_BIT12_MASK             4096U
#define ATD1DR13_BIT13_MASK             8192U
#define ATD1DR13_BIT14_MASK             16384U
#define ATD1DR13_BIT15_MASK             32768U
#define ATD1DR13_BIT_6_MASK             65472U
#define ATD1DR13_BIT_6_BITNUM           6U


/*** ATD1DR14 - ATD 1 Conversion Result Register 14; 0x000000AC ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR14H - ATD 1 Conversion Result Register 14 High; 0x000000AC ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR14HSTR;
    #define ATD1DR14H                   _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Byte
    #define ATD1DR14H_BIT8              _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT8
    #define ATD1DR14H_BIT9              _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT9
    #define ATD1DR14H_BIT10             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT10
    #define ATD1DR14H_BIT11             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT11
    #define ATD1DR14H_BIT12             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT12
    #define ATD1DR14H_BIT13             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT13
    #define ATD1DR14H_BIT14             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT14
    #define ATD1DR14H_BIT15             _ATD1DR14.Overlap_STR.ATD1DR14HSTR.Bits.BIT15
    
    #define ATD1DR14H_BIT8_MASK         1U
    #define ATD1DR14H_BIT9_MASK         2U
    #define ATD1DR14H_BIT10_MASK        4U
    #define ATD1DR14H_BIT11_MASK        8U
    #define ATD1DR14H_BIT12_MASK        16U
    #define ATD1DR14H_BIT13_MASK        32U
    #define ATD1DR14H_BIT14_MASK        64U
    #define ATD1DR14H_BIT15_MASK        128U
    

    /*** ATD1DR14L - ATD 1 Conversion Result Register 14 Low; 0x000000AD ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR14LSTR;
    #define ATD1DR14L                   _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Byte
    #define ATD1DR14L_BIT6              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT6
    #define ATD1DR14L_BIT7              _ATD1DR14.Overlap_STR.ATD1DR14LSTR.Bits.BIT7
    #define ATD1DR14L_BIT_6             _ATD1DR14.Overlap_STR.ATD1DR14LSTR.MergedBits.grpBIT_6
    #define ATD1DR14L_BIT               ATD1DR14L_BIT_6
    
    #define ATD1DR14L_BIT6_MASK         64U
    #define ATD1DR14L_BIT7_MASK         128U
    #define ATD1DR14L_BIT_6_MASK        192U
    #define ATD1DR14L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR14STR;
extern volatile ATD1DR14STR _ATD1DR14 @(REG_BASE + 0x000000ACUL);
#define ATD1DR14                        _ATD1DR14.Word
#define ATD1DR14_BIT6                   _ATD1DR14.Bits.BIT6
#define ATD1DR14_BIT7                   _ATD1DR14.Bits.BIT7
#define ATD1DR14_BIT8                   _ATD1DR14.Bits.BIT8
#define ATD1DR14_BIT9                   _ATD1DR14.Bits.BIT9
#define ATD1DR14_BIT10                  _ATD1DR14.Bits.BIT10
#define ATD1DR14_BIT11                  _ATD1DR14.Bits.BIT11
#define ATD1DR14_BIT12                  _ATD1DR14.Bits.BIT12
#define ATD1DR14_BIT13                  _ATD1DR14.Bits.BIT13
#define ATD1DR14_BIT14                  _ATD1DR14.Bits.BIT14
#define ATD1DR14_BIT15                  _ATD1DR14.Bits.BIT15
#define ATD1DR14_BIT_6                  _ATD1DR14.MergedBits.grpBIT_6
#define ATD1DR14_BIT                    ATD1DR14_BIT_6

#define ATD1DR14_BIT6_MASK              64U
#define ATD1DR14_BIT7_MASK              128U
#define ATD1DR14_BIT8_MASK              256U
#define ATD1DR14_BIT9_MASK              512U
#define ATD1DR14_BIT10_MASK             1024U
#define ATD1DR14_BIT11_MASK             2048U
#define ATD1DR14_BIT12_MASK             4096U
#define ATD1DR14_BIT13_MASK             8192U
#define ATD1DR14_BIT14_MASK             16384U
#define ATD1DR14_BIT15_MASK             32768U
#define ATD1DR14_BIT_6_MASK             65472U
#define ATD1DR14_BIT_6_BITNUM           6U


/*** ATD1DR15 - ATD 1 Conversion Result Register 15; 0x000000AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ATD1DR15H - ATD 1 Conversion Result Register 15 High; 0x000000AE ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Bit 8 */
        byte BIT9        :1;                                       /* Bit 9 */
        byte BIT10       :1;                                       /* Bit 10 */
        byte BIT11       :1;                                       /* Bit 11 */
        byte BIT12       :1;                                       /* Bit 12 */
        byte BIT13       :1;                                       /* Bit 13 */
        byte BIT14       :1;                                       /* Bit 14 */
        byte BIT15       :1;                                       /* Bit 15 */
      } Bits;
    } ATD1DR15HSTR;
    #define ATD1DR15H                   _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Byte
    #define ATD1DR15H_BIT8              _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT8
    #define ATD1DR15H_BIT9              _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT9
    #define ATD1DR15H_BIT10             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT10
    #define ATD1DR15H_BIT11             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT11
    #define ATD1DR15H_BIT12             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT12
    #define ATD1DR15H_BIT13             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT13
    #define ATD1DR15H_BIT14             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT14
    #define ATD1DR15H_BIT15             _ATD1DR15.Overlap_STR.ATD1DR15HSTR.Bits.BIT15
    
    #define ATD1DR15H_BIT8_MASK         1U
    #define ATD1DR15H_BIT9_MASK         2U
    #define ATD1DR15H_BIT10_MASK        4U
    #define ATD1DR15H_BIT11_MASK        8U
    #define ATD1DR15H_BIT12_MASK        16U
    #define ATD1DR15H_BIT13_MASK        32U
    #define ATD1DR15H_BIT14_MASK        64U
    #define ATD1DR15H_BIT15_MASK        128U
    

    /*** ATD1DR15L - ATD 1 Conversion Result Register 15 Low; 0x000000AF ***/
    union {
      byte Byte;
      struct {
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte BIT6        :1;                                       /* Bit 6 */
        byte BIT7        :1;                                       /* Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte grpBIT_6 :2;
      } MergedBits;
    } ATD1DR15LSTR;
    #define ATD1DR15L                   _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Byte
    #define ATD1DR15L_BIT6              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT6
    #define ATD1DR15L_BIT7              _ATD1DR15.Overlap_STR.ATD1DR15LSTR.Bits.BIT7
    #define ATD1DR15L_BIT_6             _ATD1DR15.Overlap_STR.ATD1DR15LSTR.MergedBits.grpBIT_6
    #define ATD1DR15L_BIT               ATD1DR15L_BIT_6
    
    #define ATD1DR15L_BIT6_MASK         64U
    #define ATD1DR15L_BIT7_MASK         128U
    #define ATD1DR15L_BIT_6_MASK        192U
    #define ATD1DR15L_BIT_6_BITNUM      6U
    
  } Overlap_STR;

  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BIT6        :1;                                       /* Bit 6 */
    word BIT7        :1;                                       /* Bit 7 */
    word BIT8        :1;                                       /* Bit 8 */
    word BIT9        :1;                                       /* Bit 9 */
    word BIT10       :1;                                       /* Bit 10 */
    word BIT11       :1;                                       /* Bit 11 */
    word BIT12       :1;                                       /* Bit 12 */
    word BIT13       :1;                                       /* Bit 13 */
    word BIT14       :1;                                       /* Bit 14 */
    word BIT15       :1;                                       /* Bit 15 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpBIT_6 :10;
  } MergedBits;
} ATD1DR15STR;
extern volatile ATD1DR15STR _ATD1DR15 @(REG_BASE + 0x000000AEUL);
#define ATD1DR15                        _ATD1DR15.Word
#define ATD1DR15_BIT6                   _ATD1DR15.Bits.BIT6
#define ATD1DR15_BIT7                   _ATD1DR15.Bits.BIT7
#define ATD1DR15_BIT8                   _ATD1DR15.Bits.BIT8
#define ATD1DR15_BIT9                   _ATD1DR15.Bits.BIT9
#define ATD1DR15_BIT10                  _ATD1DR15.Bits.BIT10
#define ATD1DR15_BIT11                  _ATD1DR15.Bits.BIT11
#define ATD1DR15_BIT12                  _ATD1DR15.Bits.BIT12
#define ATD1DR15_BIT13                  _ATD1DR15.Bits.BIT13
#define ATD1DR15_BIT14                  _ATD1DR15.Bits.BIT14
#define ATD1DR15_BIT15                  _ATD1DR15.Bits.BIT15
#define ATD1DR15_BIT_6                  _ATD1DR15.MergedBits.grpBIT_6
#define ATD1DR15_BIT                    ATD1DR15_BIT_6

#define ATD1DR15_BIT6_MASK              64U
#define ATD1DR15_BIT7_MASK              128U
#define ATD1DR15_BIT8_MASK              256U
#define ATD1DR15_BIT9_MASK              512U
#define ATD1DR15_BIT10_MASK             1024U
#define ATD1DR15_BIT11_MASK             2048U
#define ATD1DR15_BIT12_MASK             4096U
#define ATD1DR15_BIT13_MASK             8192U
#define ATD1DR15_BIT14_MASK             16384U
#define ATD1DR15_BIT15_MASK             32768U
#define ATD1DR15_BIT_6_MASK             65472U
#define ATD1DR15_BIT_6_BITNUM           6U


/*** IIC1_IBAD - IIC 1 Address Register; 0x000000B0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IIC1_IBADSTR;
extern volatile IIC1_IBADSTR _IIC1_IBAD @(REG_BASE + 0x000000B0UL);
#define IIC1_IBAD                       _IIC1_IBAD.Byte
#define IIC1_IBAD_ADR1                  _IIC1_IBAD.Bits.ADR1
#define IIC1_IBAD_ADR2                  _IIC1_IBAD.Bits.ADR2
#define IIC1_IBAD_ADR3                  _IIC1_IBAD.Bits.ADR3
#define IIC1_IBAD_ADR4                  _IIC1_IBAD.Bits.ADR4
#define IIC1_IBAD_ADR5                  _IIC1_IBAD.Bits.ADR5
#define IIC1_IBAD_ADR6                  _IIC1_IBAD.Bits.ADR6
#define IIC1_IBAD_ADR7                  _IIC1_IBAD.Bits.ADR7
#define IIC1_IBAD_ADR_1                 _IIC1_IBAD.MergedBits.grpADR_1
#define IIC1_IBAD_ADR                   IIC1_IBAD_ADR_1

#define IIC1_IBAD_ADR1_MASK             2U
#define IIC1_IBAD_ADR2_MASK             4U
#define IIC1_IBAD_ADR3_MASK             8U
#define IIC1_IBAD_ADR4_MASK             16U
#define IIC1_IBAD_ADR5_MASK             32U
#define IIC1_IBAD_ADR6_MASK             64U
#define IIC1_IBAD_ADR7_MASK             128U
#define IIC1_IBAD_ADR_1_MASK            254U
#define IIC1_IBAD_ADR_1_BITNUM          1U


/*** IIC1_IBFD - IIC 1 Frequency Divider Register; 0x000000B1 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IIC1_IBFDSTR;
extern volatile IIC1_IBFDSTR _IIC1_IBFD @(REG_BASE + 0x000000B1UL);
#define IIC1_IBFD                       _IIC1_IBFD.Byte
#define IIC1_IBFD_IBC0                  _IIC1_IBFD.Bits.IBC0
#define IIC1_IBFD_IBC1                  _IIC1_IBFD.Bits.IBC1
#define IIC1_IBFD_IBC2                  _IIC1_IBFD.Bits.IBC2
#define IIC1_IBFD_IBC3                  _IIC1_IBFD.Bits.IBC3
#define IIC1_IBFD_IBC4                  _IIC1_IBFD.Bits.IBC4
#define IIC1_IBFD_IBC5                  _IIC1_IBFD.Bits.IBC5
#define IIC1_IBFD_IBC6                  _IIC1_IBFD.Bits.IBC6
#define IIC1_IBFD_IBC7                  _IIC1_IBFD.Bits.IBC7

#define IIC1_IBFD_IBC0_MASK             1U
#define IIC1_IBFD_IBC1_MASK             2U
#define IIC1_IBFD_IBC2_MASK             4U
#define IIC1_IBFD_IBC3_MASK             8U
#define IIC1_IBFD_IBC4_MASK             16U
#define IIC1_IBFD_IBC5_MASK             32U
#define IIC1_IBFD_IBC6_MASK             64U
#define IIC1_IBFD_IBC7_MASK             128U


/*** IIC1_IBCR - IIC 1 Control Register; 0x000000B2 ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IIC1_IBCRSTR;
extern volatile IIC1_IBCRSTR _IIC1_IBCR @(REG_BASE + 0x000000B2UL);
#define IIC1_IBCR                       _IIC1_IBCR.Byte
#define IIC1_IBCR_IBSWAI                _IIC1_IBCR.Bits.IBSWAI
#define IIC1_IBCR_RSTA                  _IIC1_IBCR.Bits.RSTA
#define IIC1_IBCR_TXAK                  _IIC1_IBCR.Bits.TXAK
#define IIC1_IBCR_TX_RX                 _IIC1_IBCR.Bits.TX_RX
#define IIC1_IBCR_MS_SL                 _IIC1_IBCR.Bits.MS_SL
#define IIC1_IBCR_IBIE                  _IIC1_IBCR.Bits.IBIE
#define IIC1_IBCR_IBEN                  _IIC1_IBCR.Bits.IBEN

#define IIC1_IBCR_IBSWAI_MASK           1U
#define IIC1_IBCR_RSTA_MASK             4U
#define IIC1_IBCR_TXAK_MASK             8U
#define IIC1_IBCR_TX_RX_MASK            16U
#define IIC1_IBCR_MS_SL_MASK            32U
#define IIC1_IBCR_IBIE_MASK             64U
#define IIC1_IBCR_IBEN_MASK             128U


/*** IIC1_IBSR - IIC 1 Status Register; 0x000000B3 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IIC1_IBSRSTR;
extern volatile IIC1_IBSRSTR _IIC1_IBSR @(REG_BASE + 0x000000B3UL);
#define IIC1_IBSR                       _IIC1_IBSR.Byte
#define IIC1_IBSR_RXAK                  _IIC1_IBSR.Bits.RXAK
#define IIC1_IBSR_IBIF                  _IIC1_IBSR.Bits.IBIF
#define IIC1_IBSR_SRW                   _IIC1_IBSR.Bits.SRW
#define IIC1_IBSR_IBAL                  _IIC1_IBSR.Bits.IBAL
#define IIC1_IBSR_IBB                   _IIC1_IBSR.Bits.IBB
#define IIC1_IBSR_IAAS                  _IIC1_IBSR.Bits.IAAS
#define IIC1_IBSR_TCF                   _IIC1_IBSR.Bits.TCF

#define IIC1_IBSR_RXAK_MASK             1U
#define IIC1_IBSR_IBIF_MASK             2U
#define IIC1_IBSR_SRW_MASK              4U
#define IIC1_IBSR_IBAL_MASK             16U
#define IIC1_IBSR_IBB_MASK              32U
#define IIC1_IBSR_IAAS_MASK             64U
#define IIC1_IBSR_TCF_MASK              128U


/*** IIC1_IBDR - IIC 1 Data I/O Register; 0x000000B4 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IIC1_IBDRSTR;
extern volatile IIC1_IBDRSTR _IIC1_IBDR @(REG_BASE + 0x000000B4UL);
#define IIC1_IBDR                       _IIC1_IBDR.Byte
#define IIC1_IBDR_D0                    _IIC1_IBDR.Bits.D0
#define IIC1_IBDR_D1                    _IIC1_IBDR.Bits.D1
#define IIC1_IBDR_D2                    _IIC1_IBDR.Bits.D2
#define IIC1_IBDR_D3                    _IIC1_IBDR.Bits.D3
#define IIC1_IBDR_D4                    _IIC1_IBDR.Bits.D4
#define IIC1_IBDR_D5                    _IIC1_IBDR.Bits.D5
#define IIC1_IBDR_D6                    _IIC1_IBDR.Bits.D6
#define IIC1_IBDR_D7                    _IIC1_IBDR.Bits.D7

#define IIC1_IBDR_D0_MASK               1U
#define IIC1_IBDR_D1_MASK               2U
#define IIC1_IBDR_D2_MASK               4U
#define IIC1_IBDR_D3_MASK               8U
#define IIC1_IBDR_D4_MASK               16U
#define IIC1_IBDR_D5_MASK               32U
#define IIC1_IBDR_D6_MASK               64U
#define IIC1_IBDR_D7_MASK               128U


/*** SCI2BD - SCI 2 Baud Rate Register; 0x000000B8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI2ASR1 - SCI 2 Alternative Status Register 1; 0x000000B8 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI2ASR1 - SCI 2 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI2ASR1STR;
        #define SCI2ASR1                _SCI2BD.Overlap_STR.SCI2ASR1STR.Byte
        #define SCI2ASR1_BKDIF          _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2ASR1STR.Bits.BKDIF
        #define SCI2ASR1_BERRIF         _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2ASR1STR.Bits.BERRIF
        #define SCI2ASR1_BERRV          _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2ASR1STR.Bits.BERRV
        #define SCI2ASR1_RXEDGIF        _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2ASR1STR.Bits.RXEDGIF
        
        #define SCI2ASR1_BKDIF_MASK     1U
        #define SCI2ASR1_BERRIF_MASK    2U
        #define SCI2ASR1_BERRV_MASK     4U
        #define SCI2ASR1_RXEDGIF_MASK   128U
        
        /*** SCI2BDH - SCI 2 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI2BDHSTR;
        #define SCI2BDH                 _SCI2BD.Overlap_STR.SCI2ASR1STR.Byte
        #define SCI2BDH_SBR8            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR8
        #define SCI2BDH_SBR9            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR9
        #define SCI2BDH_SBR10           _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR10
        #define SCI2BDH_SBR11           _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR11
        #define SCI2BDH_SBR12           _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.SBR12
        #define SCI2BDH_TNP0            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.TNP0
        #define SCI2BDH_TNP1            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.TNP1
        #define SCI2BDH_IREN            _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.Bits.IREN
        #define SCI2BDH_SBR_8           _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.MergedBits.grpSBR_8
        #define SCI2BDH_TNP             _SCI2BD.Overlap_STR.SCI2ASR1STR.SameAddr_STR.SCI2BDHSTR.MergedBits.grpTNP
        #define SCI2BDH_SBR             SCI2BDH_SBR_8
        
        #define SCI2BDH_SBR8_MASK       1U
        #define SCI2BDH_SBR9_MASK       2U
        #define SCI2BDH_SBR10_MASK      4U
        #define SCI2BDH_SBR11_MASK      8U
        #define SCI2BDH_SBR12_MASK      16U
        #define SCI2BDH_TNP0_MASK       32U
        #define SCI2BDH_TNP1_MASK       64U
        #define SCI2BDH_IREN_MASK       128U
        #define SCI2BDH_SBR_8_MASK      31U
        #define SCI2BDH_SBR_8_BITNUM    0U
        #define SCI2BDH_TNP_MASK        96U
        #define SCI2BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI2ASR1STR;
    

    /*** SCI2ACR1 - SCI 2 Alternative Control Register 1; 0x000000B9 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI2ACR1 - SCI 2 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI2ACR1STR;
        #define SCI2ACR1                _SCI2BD.Overlap_STR.SCI2ACR1STR.Byte
        #define SCI2ACR1_BKDIE          _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2ACR1STR.Bits.BKDIE
        #define SCI2ACR1_BERRIE         _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2ACR1STR.Bits.BERRIE
        #define SCI2ACR1_RXEDGIE        _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2ACR1STR.Bits.RXEDGIE
        
        #define SCI2ACR1_BKDIE_MASK     1U
        #define SCI2ACR1_BERRIE_MASK    2U
        #define SCI2ACR1_RXEDGIE_MASK   128U
        
        /*** SCI2BDL - SCI 2 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI2BDLSTR;
        #define SCI2BDL                 _SCI2BD.Overlap_STR.SCI2ACR1STR.Byte
        #define SCI2BDL_SBR0            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR0
        #define SCI2BDL_SBR1            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR1
        #define SCI2BDL_SBR2            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR2
        #define SCI2BDL_SBR3            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR3
        #define SCI2BDL_SBR4            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR4
        #define SCI2BDL_SBR5            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR5
        #define SCI2BDL_SBR6            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR6
        #define SCI2BDL_SBR7            _SCI2BD.Overlap_STR.SCI2ACR1STR.SameAddr_STR.SCI2BDLSTR.Bits.SBR7
        
        #define SCI2BDL_SBR0_MASK       1U
        #define SCI2BDL_SBR1_MASK       2U
        #define SCI2BDL_SBR2_MASK       4U
        #define SCI2BDL_SBR3_MASK       8U
        #define SCI2BDL_SBR4_MASK       16U
        #define SCI2BDL_SBR5_MASK       32U
        #define SCI2BDL_SBR6_MASK       64U
        #define SCI2BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI2ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI2BDSTR;
extern volatile SCI2BDSTR _SCI2BD @(REG_BASE + 0x000000B8UL);
#define SCI2BD                          _SCI2BD.Word
#define SCI2BD_SBR0                     _SCI2BD.Bits.SBR0
#define SCI2BD_SBR1                     _SCI2BD.Bits.SBR1
#define SCI2BD_SBR2                     _SCI2BD.Bits.SBR2
#define SCI2BD_SBR3                     _SCI2BD.Bits.SBR3
#define SCI2BD_SBR4                     _SCI2BD.Bits.SBR4
#define SCI2BD_SBR5                     _SCI2BD.Bits.SBR5
#define SCI2BD_SBR6                     _SCI2BD.Bits.SBR6
#define SCI2BD_SBR7                     _SCI2BD.Bits.SBR7
#define SCI2BD_SBR8                     _SCI2BD.Bits.SBR8
#define SCI2BD_SBR9                     _SCI2BD.Bits.SBR9
#define SCI2BD_SBR10                    _SCI2BD.Bits.SBR10
#define SCI2BD_SBR11                    _SCI2BD.Bits.SBR11
#define SCI2BD_SBR12                    _SCI2BD.Bits.SBR12
#define SCI2BD_TNP0                     _SCI2BD.Bits.TNP0
#define SCI2BD_TNP1                     _SCI2BD.Bits.TNP1
#define SCI2BD_IREN                     _SCI2BD.Bits.IREN
#define SCI2BD_SBR                      _SCI2BD.MergedBits.grpSBR
#define SCI2BD_TNP                      _SCI2BD.MergedBits.grpTNP

#define SCI2BD_SBR0_MASK                1U
#define SCI2BD_SBR1_MASK                2U
#define SCI2BD_SBR2_MASK                4U
#define SCI2BD_SBR3_MASK                8U
#define SCI2BD_SBR4_MASK                16U
#define SCI2BD_SBR5_MASK                32U
#define SCI2BD_SBR6_MASK                64U
#define SCI2BD_SBR7_MASK                128U
#define SCI2BD_SBR8_MASK                256U
#define SCI2BD_SBR9_MASK                512U
#define SCI2BD_SBR10_MASK               1024U
#define SCI2BD_SBR11_MASK               2048U
#define SCI2BD_SBR12_MASK               4096U
#define SCI2BD_TNP0_MASK                8192U
#define SCI2BD_TNP1_MASK                16384U
#define SCI2BD_IREN_MASK                32768U
#define SCI2BD_SBR_MASK                 8191U
#define SCI2BD_SBR_BITNUM               0U
#define SCI2BD_TNP_MASK                 24576U
#define SCI2BD_TNP_BITNUM               13U


/*** SCI2ACR2 - SCI 2 Alternative Control Register 2; 0x000000BA ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI2ACR2 - SCI 2 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode Bit 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode Bit 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI2ACR2STR;
    #define SCI2ACR2                    _SCI2ACR2.Byte
    #define SCI2ACR2_BKDFE              _SCI2ACR2.SameAddr_STR.SCI2ACR2STR.Bits.BKDFE
    #define SCI2ACR2_BERRM0             _SCI2ACR2.SameAddr_STR.SCI2ACR2STR.Bits.BERRM0
    #define SCI2ACR2_BERRM1             _SCI2ACR2.SameAddr_STR.SCI2ACR2STR.Bits.BERRM1
    #define SCI2ACR2_BERRM              _SCI2ACR2.SameAddr_STR.SCI2ACR2STR.MergedBits.grpBERRM
    
    #define SCI2ACR2_BKDFE_MASK         1U
    #define SCI2ACR2_BERRM0_MASK        2U
    #define SCI2ACR2_BERRM1_MASK        4U
    #define SCI2ACR2_BERRM_MASK         6U
    #define SCI2ACR2_BERRM_BITNUM       1U
    
    /*** SCI2CR1 - SCI 2 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI2CR1STR;
    #define SCI2CR1                     _SCI2ACR2.Byte
    #define SCI2CR1_PT                  _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.PT
    #define SCI2CR1_PE                  _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.PE
    #define SCI2CR1_ILT                 _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.ILT
    #define SCI2CR1_WAKE                _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.WAKE
    #define SCI2CR1_M                   _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.M
    #define SCI2CR1_RSRC                _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.RSRC
    #define SCI2CR1_SCISWAI             _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.SCISWAI
    #define SCI2CR1_LOOPS               _SCI2ACR2.SameAddr_STR.SCI2CR1STR.Bits.LOOPS
    
    #define SCI2CR1_PT_MASK             1U
    #define SCI2CR1_PE_MASK             2U
    #define SCI2CR1_ILT_MASK            4U
    #define SCI2CR1_WAKE_MASK           8U
    #define SCI2CR1_M_MASK              16U
    #define SCI2CR1_RSRC_MASK           32U
    #define SCI2CR1_SCISWAI_MASK        64U
    #define SCI2CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI2ACR2STR;
extern volatile SCI2ACR2STR _SCI2ACR2 @(REG_BASE + 0x000000BAUL);


/*** SCI2CR2 - SCI 2 Control Register 2; 0x000000BB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI2CR2STR;
extern volatile SCI2CR2STR _SCI2CR2 @(REG_BASE + 0x000000BBUL);
#define SCI2CR2                         _SCI2CR2.Byte
#define SCI2CR2_SBK                     _SCI2CR2.Bits.SBK
#define SCI2CR2_RWU                     _SCI2CR2.Bits.RWU
#define SCI2CR2_RE                      _SCI2CR2.Bits.RE
#define SCI2CR2_TE                      _SCI2CR2.Bits.TE
#define SCI2CR2_ILIE                    _SCI2CR2.Bits.ILIE
#define SCI2CR2_RIE                     _SCI2CR2.Bits.RIE
#define SCI2CR2_TCIE                    _SCI2CR2.Bits.TCIE
#define SCI2CR2_TIE                     _SCI2CR2.Bits.TIE_bit

#define SCI2CR2_SBK_MASK                1U
#define SCI2CR2_RWU_MASK                2U
#define SCI2CR2_RE_MASK                 4U
#define SCI2CR2_TE_MASK                 8U
#define SCI2CR2_ILIE_MASK               16U
#define SCI2CR2_RIE_MASK                32U
#define SCI2CR2_TCIE_MASK               64U
#define SCI2CR2_TIE_MASK                128U


/*** SCI2SR1 - SCI 2 Status Register 1; 0x000000BC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI2SR1STR;
extern volatile SCI2SR1STR _SCI2SR1 @(REG_BASE + 0x000000BCUL);
#define SCI2SR1                         _SCI2SR1.Byte
#define SCI2SR1_PF                      _SCI2SR1.Bits.PF
#define SCI2SR1_FE                      _SCI2SR1.Bits.FE
#define SCI2SR1_NF                      _SCI2SR1.Bits.NF
#define SCI2SR1_OR                      _SCI2SR1.Bits.OR
#define SCI2SR1_IDLE                    _SCI2SR1.Bits.IDLE
#define SCI2SR1_RDRF                    _SCI2SR1.Bits.RDRF
#define SCI2SR1_TC                      _SCI2SR1.Bits.TC
#define SCI2SR1_TDRE                    _SCI2SR1.Bits.TDRE

#define SCI2SR1_PF_MASK                 1U
#define SCI2SR1_FE_MASK                 2U
#define SCI2SR1_NF_MASK                 4U
#define SCI2SR1_OR_MASK                 8U
#define SCI2SR1_IDLE_MASK               16U
#define SCI2SR1_RDRF_MASK               32U
#define SCI2SR1_TC_MASK                 64U
#define SCI2SR1_TDRE_MASK               128U


/*** SCI2SR2 - SCI 2 Status Register 2; 0x000000BD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI2SR2STR;
extern volatile SCI2SR2STR _SCI2SR2 @(REG_BASE + 0x000000BDUL);
#define SCI2SR2                         _SCI2SR2.Byte
#define SCI2SR2_RAF                     _SCI2SR2.Bits.RAF
#define SCI2SR2_TXDIR                   _SCI2SR2.Bits.TXDIR
#define SCI2SR2_BRK13                   _SCI2SR2.Bits.BRK13
#define SCI2SR2_RXPOL                   _SCI2SR2.Bits.RXPOL
#define SCI2SR2_TXPOL                   _SCI2SR2.Bits.TXPOL
#define SCI2SR2_AMAP                    _SCI2SR2.Bits.AMAP

#define SCI2SR2_RAF_MASK                1U
#define SCI2SR2_TXDIR_MASK              2U
#define SCI2SR2_BRK13_MASK              4U
#define SCI2SR2_RXPOL_MASK              8U
#define SCI2SR2_TXPOL_MASK              16U
#define SCI2SR2_AMAP_MASK               128U


/*** SCI2DRH - SCI 2 Data Register High; 0x000000BE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI2DRHSTR;
extern volatile SCI2DRHSTR _SCI2DRH @(REG_BASE + 0x000000BEUL);
#define SCI2DRH                         _SCI2DRH.Byte
#define SCI2DRH_T8                      _SCI2DRH.Bits.T8
#define SCI2DRH_R8                      _SCI2DRH.Bits.R8

#define SCI2DRH_T8_MASK                 64U
#define SCI2DRH_R8_MASK                 128U


/*** SCI2DRL - SCI 2 Data Register Low; 0x000000BF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI2DRLSTR;
extern volatile SCI2DRLSTR _SCI2DRL @(REG_BASE + 0x000000BFUL);
#define SCI2DRL                         _SCI2DRL.Byte
#define SCI2DRL_R0_T0                   _SCI2DRL.Bits.R0_T0
#define SCI2DRL_R1_T1                   _SCI2DRL.Bits.R1_T1
#define SCI2DRL_R2_T2                   _SCI2DRL.Bits.R2_T2
#define SCI2DRL_R3_T3                   _SCI2DRL.Bits.R3_T3
#define SCI2DRL_R4_T4                   _SCI2DRL.Bits.R4_T4
#define SCI2DRL_R5_T5                   _SCI2DRL.Bits.R5_T5
#define SCI2DRL_R6_T6                   _SCI2DRL.Bits.R6_T6
#define SCI2DRL_R7_T7                   _SCI2DRL.Bits.R7_T7

#define SCI2DRL_R0_T0_MASK              1U
#define SCI2DRL_R1_T1_MASK              2U
#define SCI2DRL_R2_T2_MASK              4U
#define SCI2DRL_R3_T3_MASK              8U
#define SCI2DRL_R4_T4_MASK              16U
#define SCI2DRL_R5_T5_MASK              32U
#define SCI2DRL_R6_T6_MASK              64U
#define SCI2DRL_R7_T7_MASK              128U


/*** SCI3BD - SCI 3 Baud Rate Register; 0x000000C0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI3ASR1 - SCI 3 Alternative Status Register 1; 0x000000C0 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI3ASR1 - SCI 3 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI3ASR1STR;
        #define SCI3ASR1                _SCI3BD.Overlap_STR.SCI3ASR1STR.Byte
        #define SCI3ASR1_BKDIF          _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3ASR1STR.Bits.BKDIF
        #define SCI3ASR1_BERRIF         _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3ASR1STR.Bits.BERRIF
        #define SCI3ASR1_BERRV          _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3ASR1STR.Bits.BERRV
        #define SCI3ASR1_RXEDGIF        _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3ASR1STR.Bits.RXEDGIF
        
        #define SCI3ASR1_BKDIF_MASK     1U
        #define SCI3ASR1_BERRIF_MASK    2U
        #define SCI3ASR1_BERRV_MASK     4U
        #define SCI3ASR1_RXEDGIF_MASK   128U
        
        /*** SCI3BDH - SCI 3 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI3BDHSTR;
        #define SCI3BDH                 _SCI3BD.Overlap_STR.SCI3ASR1STR.Byte
        #define SCI3BDH_SBR8            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR8
        #define SCI3BDH_SBR9            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR9
        #define SCI3BDH_SBR10           _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR10
        #define SCI3BDH_SBR11           _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR11
        #define SCI3BDH_SBR12           _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.SBR12
        #define SCI3BDH_TNP0            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.TNP0
        #define SCI3BDH_TNP1            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.TNP1
        #define SCI3BDH_IREN            _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.Bits.IREN
        #define SCI3BDH_SBR_8           _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.MergedBits.grpSBR_8
        #define SCI3BDH_TNP             _SCI3BD.Overlap_STR.SCI3ASR1STR.SameAddr_STR.SCI3BDHSTR.MergedBits.grpTNP
        #define SCI3BDH_SBR             SCI3BDH_SBR_8
        
        #define SCI3BDH_SBR8_MASK       1U
        #define SCI3BDH_SBR9_MASK       2U
        #define SCI3BDH_SBR10_MASK      4U
        #define SCI3BDH_SBR11_MASK      8U
        #define SCI3BDH_SBR12_MASK      16U
        #define SCI3BDH_TNP0_MASK       32U
        #define SCI3BDH_TNP1_MASK       64U
        #define SCI3BDH_IREN_MASK       128U
        #define SCI3BDH_SBR_8_MASK      31U
        #define SCI3BDH_SBR_8_BITNUM    0U
        #define SCI3BDH_TNP_MASK        96U
        #define SCI3BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI3ASR1STR;
    

    /*** SCI3ACR1 - SCI 3 Alternative Control Register 1; 0x000000C1 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI3ACR1 - SCI 3 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI3ACR1STR;
        #define SCI3ACR1                _SCI3BD.Overlap_STR.SCI3ACR1STR.Byte
        #define SCI3ACR1_BKDIE          _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3ACR1STR.Bits.BKDIE
        #define SCI3ACR1_BERRIE         _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3ACR1STR.Bits.BERRIE
        #define SCI3ACR1_RXEDGIE        _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3ACR1STR.Bits.RXEDGIE
        
        #define SCI3ACR1_BKDIE_MASK     1U
        #define SCI3ACR1_BERRIE_MASK    2U
        #define SCI3ACR1_RXEDGIE_MASK   128U
        
        /*** SCI3BDL - SCI 3 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI3BDLSTR;
        #define SCI3BDL                 _SCI3BD.Overlap_STR.SCI3ACR1STR.Byte
        #define SCI3BDL_SBR0            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR0
        #define SCI3BDL_SBR1            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR1
        #define SCI3BDL_SBR2            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR2
        #define SCI3BDL_SBR3            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR3
        #define SCI3BDL_SBR4            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR4
        #define SCI3BDL_SBR5            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR5
        #define SCI3BDL_SBR6            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR6
        #define SCI3BDL_SBR7            _SCI3BD.Overlap_STR.SCI3ACR1STR.SameAddr_STR.SCI3BDLSTR.Bits.SBR7
        
        #define SCI3BDL_SBR0_MASK       1U
        #define SCI3BDL_SBR1_MASK       2U
        #define SCI3BDL_SBR2_MASK       4U
        #define SCI3BDL_SBR3_MASK       8U
        #define SCI3BDL_SBR4_MASK       16U
        #define SCI3BDL_SBR5_MASK       32U
        #define SCI3BDL_SBR6_MASK       64U
        #define SCI3BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI3ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI3BDSTR;
extern volatile SCI3BDSTR _SCI3BD @(REG_BASE + 0x000000C0UL);
#define SCI3BD                          _SCI3BD.Word
#define SCI3BD_SBR0                     _SCI3BD.Bits.SBR0
#define SCI3BD_SBR1                     _SCI3BD.Bits.SBR1
#define SCI3BD_SBR2                     _SCI3BD.Bits.SBR2
#define SCI3BD_SBR3                     _SCI3BD.Bits.SBR3
#define SCI3BD_SBR4                     _SCI3BD.Bits.SBR4
#define SCI3BD_SBR5                     _SCI3BD.Bits.SBR5
#define SCI3BD_SBR6                     _SCI3BD.Bits.SBR6
#define SCI3BD_SBR7                     _SCI3BD.Bits.SBR7
#define SCI3BD_SBR8                     _SCI3BD.Bits.SBR8
#define SCI3BD_SBR9                     _SCI3BD.Bits.SBR9
#define SCI3BD_SBR10                    _SCI3BD.Bits.SBR10
#define SCI3BD_SBR11                    _SCI3BD.Bits.SBR11
#define SCI3BD_SBR12                    _SCI3BD.Bits.SBR12
#define SCI3BD_TNP0                     _SCI3BD.Bits.TNP0
#define SCI3BD_TNP1                     _SCI3BD.Bits.TNP1
#define SCI3BD_IREN                     _SCI3BD.Bits.IREN
#define SCI3BD_SBR                      _SCI3BD.MergedBits.grpSBR
#define SCI3BD_TNP                      _SCI3BD.MergedBits.grpTNP

#define SCI3BD_SBR0_MASK                1U
#define SCI3BD_SBR1_MASK                2U
#define SCI3BD_SBR2_MASK                4U
#define SCI3BD_SBR3_MASK                8U
#define SCI3BD_SBR4_MASK                16U
#define SCI3BD_SBR5_MASK                32U
#define SCI3BD_SBR6_MASK                64U
#define SCI3BD_SBR7_MASK                128U
#define SCI3BD_SBR8_MASK                256U
#define SCI3BD_SBR9_MASK                512U
#define SCI3BD_SBR10_MASK               1024U
#define SCI3BD_SBR11_MASK               2048U
#define SCI3BD_SBR12_MASK               4096U
#define SCI3BD_TNP0_MASK                8192U
#define SCI3BD_TNP1_MASK                16384U
#define SCI3BD_IREN_MASK                32768U
#define SCI3BD_SBR_MASK                 8191U
#define SCI3BD_SBR_BITNUM               0U
#define SCI3BD_TNP_MASK                 24576U
#define SCI3BD_TNP_BITNUM               13U


/*** SCI3ACR2 - SCI 3 Alternative Control Register 2; 0x000000C2 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI3ACR2 - SCI 3 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode Bit 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode Bit 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI3ACR2STR;
    #define SCI3ACR2                    _SCI3ACR2.Byte
    #define SCI3ACR2_BKDFE              _SCI3ACR2.SameAddr_STR.SCI3ACR2STR.Bits.BKDFE
    #define SCI3ACR2_BERRM0             _SCI3ACR2.SameAddr_STR.SCI3ACR2STR.Bits.BERRM0
    #define SCI3ACR2_BERRM1             _SCI3ACR2.SameAddr_STR.SCI3ACR2STR.Bits.BERRM1
    #define SCI3ACR2_BERRM              _SCI3ACR2.SameAddr_STR.SCI3ACR2STR.MergedBits.grpBERRM
    
    #define SCI3ACR2_BKDFE_MASK         1U
    #define SCI3ACR2_BERRM0_MASK        2U
    #define SCI3ACR2_BERRM1_MASK        4U
    #define SCI3ACR2_BERRM_MASK         6U
    #define SCI3ACR2_BERRM_BITNUM       1U
    
    /*** SCI3CR1 - SCI 3 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI3CR1STR;
    #define SCI3CR1                     _SCI3ACR2.Byte
    #define SCI3CR1_PT                  _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.PT
    #define SCI3CR1_PE                  _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.PE
    #define SCI3CR1_ILT                 _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.ILT
    #define SCI3CR1_WAKE                _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.WAKE
    #define SCI3CR1_M                   _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.M
    #define SCI3CR1_RSRC                _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.RSRC
    #define SCI3CR1_SCISWAI             _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.SCISWAI
    #define SCI3CR1_LOOPS               _SCI3ACR2.SameAddr_STR.SCI3CR1STR.Bits.LOOPS
    
    #define SCI3CR1_PT_MASK             1U
    #define SCI3CR1_PE_MASK             2U
    #define SCI3CR1_ILT_MASK            4U
    #define SCI3CR1_WAKE_MASK           8U
    #define SCI3CR1_M_MASK              16U
    #define SCI3CR1_RSRC_MASK           32U
    #define SCI3CR1_SCISWAI_MASK        64U
    #define SCI3CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI3ACR2STR;
extern volatile SCI3ACR2STR _SCI3ACR2 @(REG_BASE + 0x000000C2UL);


/*** SCI3CR2 - SCI 3 Control Register 2; 0x000000C3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI3CR2STR;
extern volatile SCI3CR2STR _SCI3CR2 @(REG_BASE + 0x000000C3UL);
#define SCI3CR2                         _SCI3CR2.Byte
#define SCI3CR2_SBK                     _SCI3CR2.Bits.SBK
#define SCI3CR2_RWU                     _SCI3CR2.Bits.RWU
#define SCI3CR2_RE                      _SCI3CR2.Bits.RE
#define SCI3CR2_TE                      _SCI3CR2.Bits.TE
#define SCI3CR2_ILIE                    _SCI3CR2.Bits.ILIE
#define SCI3CR2_RIE                     _SCI3CR2.Bits.RIE
#define SCI3CR2_TCIE                    _SCI3CR2.Bits.TCIE
#define SCI3CR2_TIE                     _SCI3CR2.Bits.TIE_bit

#define SCI3CR2_SBK_MASK                1U
#define SCI3CR2_RWU_MASK                2U
#define SCI3CR2_RE_MASK                 4U
#define SCI3CR2_TE_MASK                 8U
#define SCI3CR2_ILIE_MASK               16U
#define SCI3CR2_RIE_MASK                32U
#define SCI3CR2_TCIE_MASK               64U
#define SCI3CR2_TIE_MASK                128U


/*** SCI3SR1 - SCI 3 Status Register 1; 0x000000C4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI3SR1STR;
extern volatile SCI3SR1STR _SCI3SR1 @(REG_BASE + 0x000000C4UL);
#define SCI3SR1                         _SCI3SR1.Byte
#define SCI3SR1_PF                      _SCI3SR1.Bits.PF
#define SCI3SR1_FE                      _SCI3SR1.Bits.FE
#define SCI3SR1_NF                      _SCI3SR1.Bits.NF
#define SCI3SR1_OR                      _SCI3SR1.Bits.OR
#define SCI3SR1_IDLE                    _SCI3SR1.Bits.IDLE
#define SCI3SR1_RDRF                    _SCI3SR1.Bits.RDRF
#define SCI3SR1_TC                      _SCI3SR1.Bits.TC
#define SCI3SR1_TDRE                    _SCI3SR1.Bits.TDRE

#define SCI3SR1_PF_MASK                 1U
#define SCI3SR1_FE_MASK                 2U
#define SCI3SR1_NF_MASK                 4U
#define SCI3SR1_OR_MASK                 8U
#define SCI3SR1_IDLE_MASK               16U
#define SCI3SR1_RDRF_MASK               32U
#define SCI3SR1_TC_MASK                 64U
#define SCI3SR1_TDRE_MASK               128U


/*** SCI3SR2 - SCI 3 Status Register 2; 0x000000C5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI3SR2STR;
extern volatile SCI3SR2STR _SCI3SR2 @(REG_BASE + 0x000000C5UL);
#define SCI3SR2                         _SCI3SR2.Byte
#define SCI3SR2_RAF                     _SCI3SR2.Bits.RAF
#define SCI3SR2_TXDIR                   _SCI3SR2.Bits.TXDIR
#define SCI3SR2_BRK13                   _SCI3SR2.Bits.BRK13
#define SCI3SR2_RXPOL                   _SCI3SR2.Bits.RXPOL
#define SCI3SR2_TXPOL                   _SCI3SR2.Bits.TXPOL
#define SCI3SR2_AMAP                    _SCI3SR2.Bits.AMAP

#define SCI3SR2_RAF_MASK                1U
#define SCI3SR2_TXDIR_MASK              2U
#define SCI3SR2_BRK13_MASK              4U
#define SCI3SR2_RXPOL_MASK              8U
#define SCI3SR2_TXPOL_MASK              16U
#define SCI3SR2_AMAP_MASK               128U


/*** SCI3DRH - SCI 3 Data Register High; 0x000000C6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI3DRHSTR;
extern volatile SCI3DRHSTR _SCI3DRH @(REG_BASE + 0x000000C6UL);
#define SCI3DRH                         _SCI3DRH.Byte
#define SCI3DRH_T8                      _SCI3DRH.Bits.T8
#define SCI3DRH_R8                      _SCI3DRH.Bits.R8

#define SCI3DRH_T8_MASK                 64U
#define SCI3DRH_R8_MASK                 128U


/*** SCI3DRL - SCI 3 Data Register Low; 0x000000C7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI3DRLSTR;
extern volatile SCI3DRLSTR _SCI3DRL @(REG_BASE + 0x000000C7UL);
#define SCI3DRL                         _SCI3DRL.Byte
#define SCI3DRL_R0_T0                   _SCI3DRL.Bits.R0_T0
#define SCI3DRL_R1_T1                   _SCI3DRL.Bits.R1_T1
#define SCI3DRL_R2_T2                   _SCI3DRL.Bits.R2_T2
#define SCI3DRL_R3_T3                   _SCI3DRL.Bits.R3_T3
#define SCI3DRL_R4_T4                   _SCI3DRL.Bits.R4_T4
#define SCI3DRL_R5_T5                   _SCI3DRL.Bits.R5_T5
#define SCI3DRL_R6_T6                   _SCI3DRL.Bits.R6_T6
#define SCI3DRL_R7_T7                   _SCI3DRL.Bits.R7_T7

#define SCI3DRL_R0_T0_MASK              1U
#define SCI3DRL_R1_T1_MASK              2U
#define SCI3DRL_R2_T2_MASK              4U
#define SCI3DRL_R3_T3_MASK              8U
#define SCI3DRL_R4_T4_MASK              16U
#define SCI3DRL_R5_T5_MASK              32U
#define SCI3DRL_R6_T6_MASK              64U
#define SCI3DRL_R7_T7_MASK              128U


/*** SCI0BD - SCI 0 Baud Rate Register; 0x000000C8 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; 0x000000C8 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ASR1 - SCI 0 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI0ASR1STR;
        #define SCI0ASR1                _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0ASR1_BKDIF          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BKDIF
        #define SCI0ASR1_BERRIF         _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRIF
        #define SCI0ASR1_BERRV          _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.BERRV
        #define SCI0ASR1_RXEDGIF        _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0ASR1STR.Bits.RXEDGIF
        
        #define SCI0ASR1_BKDIF_MASK     1U
        #define SCI0ASR1_BERRIF_MASK    2U
        #define SCI0ASR1_BERRV_MASK     4U
        #define SCI0ASR1_RXEDGIF_MASK   128U
        
        /*** SCI0BDH - SCI 0 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI0BDHSTR;
        #define SCI0BDH                 _SCI0BD.Overlap_STR.SCI0ASR1STR.Byte
        #define SCI0BDH_SBR8            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR8
        #define SCI0BDH_SBR9            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR9
        #define SCI0BDH_SBR10           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR10
        #define SCI0BDH_SBR11           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR11
        #define SCI0BDH_SBR12           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.SBR12
        #define SCI0BDH_TNP0            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP0
        #define SCI0BDH_TNP1            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.TNP1
        #define SCI0BDH_IREN            _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.Bits.IREN
        #define SCI0BDH_SBR_8           _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpSBR_8
        #define SCI0BDH_TNP             _SCI0BD.Overlap_STR.SCI0ASR1STR.SameAddr_STR.SCI0BDHSTR.MergedBits.grpTNP
        #define SCI0BDH_SBR             SCI0BDH_SBR_8
        
        #define SCI0BDH_SBR8_MASK       1U
        #define SCI0BDH_SBR9_MASK       2U
        #define SCI0BDH_SBR10_MASK      4U
        #define SCI0BDH_SBR11_MASK      8U
        #define SCI0BDH_SBR12_MASK      16U
        #define SCI0BDH_TNP0_MASK       32U
        #define SCI0BDH_TNP1_MASK       64U
        #define SCI0BDH_IREN_MASK       128U
        #define SCI0BDH_SBR_8_MASK      31U
        #define SCI0BDH_SBR_8_BITNUM    0U
        #define SCI0BDH_TNP_MASK        96U
        #define SCI0BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ASR1STR;
    

    /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; 0x000000C9 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI0ACR1 - SCI 0 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI0ACR1STR;
        #define SCI0ACR1                _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0ACR1_BKDIE          _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BKDIE
        #define SCI0ACR1_BERRIE         _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.BERRIE
        #define SCI0ACR1_RXEDGIE        _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0ACR1STR.Bits.RXEDGIE
        
        #define SCI0ACR1_BKDIE_MASK     1U
        #define SCI0ACR1_BERRIE_MASK    2U
        #define SCI0ACR1_RXEDGIE_MASK   128U
        
        /*** SCI0BDL - SCI 0 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI0BDLSTR;
        #define SCI0BDL                 _SCI0BD.Overlap_STR.SCI0ACR1STR.Byte
        #define SCI0BDL_SBR0            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR0
        #define SCI0BDL_SBR1            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR1
        #define SCI0BDL_SBR2            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR2
        #define SCI0BDL_SBR3            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR3
        #define SCI0BDL_SBR4            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR4
        #define SCI0BDL_SBR5            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR5
        #define SCI0BDL_SBR6            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR6
        #define SCI0BDL_SBR7            _SCI0BD.Overlap_STR.SCI0ACR1STR.SameAddr_STR.SCI0BDLSTR.Bits.SBR7
        
        #define SCI0BDL_SBR0_MASK       1U
        #define SCI0BDL_SBR1_MASK       2U
        #define SCI0BDL_SBR2_MASK       4U
        #define SCI0BDL_SBR3_MASK       8U
        #define SCI0BDL_SBR4_MASK       16U
        #define SCI0BDL_SBR5_MASK       32U
        #define SCI0BDL_SBR6_MASK       64U
        #define SCI0BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI0ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @(REG_BASE + 0x000000C8UL);
#define SCI0BD                          _SCI0BD.Word
#define SCI0BD_SBR0                     _SCI0BD.Bits.SBR0
#define SCI0BD_SBR1                     _SCI0BD.Bits.SBR1
#define SCI0BD_SBR2                     _SCI0BD.Bits.SBR2
#define SCI0BD_SBR3                     _SCI0BD.Bits.SBR3
#define SCI0BD_SBR4                     _SCI0BD.Bits.SBR4
#define SCI0BD_SBR5                     _SCI0BD.Bits.SBR5
#define SCI0BD_SBR6                     _SCI0BD.Bits.SBR6
#define SCI0BD_SBR7                     _SCI0BD.Bits.SBR7
#define SCI0BD_SBR8                     _SCI0BD.Bits.SBR8
#define SCI0BD_SBR9                     _SCI0BD.Bits.SBR9
#define SCI0BD_SBR10                    _SCI0BD.Bits.SBR10
#define SCI0BD_SBR11                    _SCI0BD.Bits.SBR11
#define SCI0BD_SBR12                    _SCI0BD.Bits.SBR12
#define SCI0BD_TNP0                     _SCI0BD.Bits.TNP0
#define SCI0BD_TNP1                     _SCI0BD.Bits.TNP1
#define SCI0BD_IREN                     _SCI0BD.Bits.IREN
#define SCI0BD_SBR                      _SCI0BD.MergedBits.grpSBR
#define SCI0BD_TNP                      _SCI0BD.MergedBits.grpTNP

#define SCI0BD_SBR0_MASK                1U
#define SCI0BD_SBR1_MASK                2U
#define SCI0BD_SBR2_MASK                4U
#define SCI0BD_SBR3_MASK                8U
#define SCI0BD_SBR4_MASK                16U
#define SCI0BD_SBR5_MASK                32U
#define SCI0BD_SBR6_MASK                64U
#define SCI0BD_SBR7_MASK                128U
#define SCI0BD_SBR8_MASK                256U
#define SCI0BD_SBR9_MASK                512U
#define SCI0BD_SBR10_MASK               1024U
#define SCI0BD_SBR11_MASK               2048U
#define SCI0BD_SBR12_MASK               4096U
#define SCI0BD_TNP0_MASK                8192U
#define SCI0BD_TNP1_MASK                16384U
#define SCI0BD_IREN_MASK                32768U
#define SCI0BD_SBR_MASK                 8191U
#define SCI0BD_SBR_BITNUM               0U
#define SCI0BD_TNP_MASK                 24576U
#define SCI0BD_TNP_BITNUM               13U


/*** SCI0ACR2 - SCI 0 Alternative Control Register 2; 0x000000CA ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI0ACR2 - SCI 0 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode Bit 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode Bit 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI0ACR2STR;
    #define SCI0ACR2                    _SCI0ACR2.Byte
    #define SCI0ACR2_BKDFE              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BKDFE
    #define SCI0ACR2_BERRM0             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM0
    #define SCI0ACR2_BERRM1             _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.Bits.BERRM1
    #define SCI0ACR2_BERRM              _SCI0ACR2.SameAddr_STR.SCI0ACR2STR.MergedBits.grpBERRM
    
    #define SCI0ACR2_BKDFE_MASK         1U
    #define SCI0ACR2_BERRM0_MASK        2U
    #define SCI0ACR2_BERRM1_MASK        4U
    #define SCI0ACR2_BERRM_MASK         6U
    #define SCI0ACR2_BERRM_BITNUM       1U
    
    /*** SCI0CR1 - SCI 0 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI0CR1STR;
    #define SCI0CR1                     _SCI0ACR2.Byte
    #define SCI0CR1_PT                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PT
    #define SCI0CR1_PE                  _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.PE
    #define SCI0CR1_ILT                 _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.ILT
    #define SCI0CR1_WAKE                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.WAKE
    #define SCI0CR1_M                   _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.M
    #define SCI0CR1_RSRC                _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.RSRC
    #define SCI0CR1_SCISWAI             _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.SCISWAI
    #define SCI0CR1_LOOPS               _SCI0ACR2.SameAddr_STR.SCI0CR1STR.Bits.LOOPS
    
    #define SCI0CR1_PT_MASK             1U
    #define SCI0CR1_PE_MASK             2U
    #define SCI0CR1_ILT_MASK            4U
    #define SCI0CR1_WAKE_MASK           8U
    #define SCI0CR1_M_MASK              16U
    #define SCI0CR1_RSRC_MASK           32U
    #define SCI0CR1_SCISWAI_MASK        64U
    #define SCI0CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI0ACR2STR;
extern volatile SCI0ACR2STR _SCI0ACR2 @(REG_BASE + 0x000000CAUL);


/*** SCI0CR2 - SCI 0 Control Register 2; 0x000000CB ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI0CR2STR;
extern volatile SCI0CR2STR _SCI0CR2 @(REG_BASE + 0x000000CBUL);
#define SCI0CR2                         _SCI0CR2.Byte
#define SCI0CR2_SBK                     _SCI0CR2.Bits.SBK
#define SCI0CR2_RWU                     _SCI0CR2.Bits.RWU
#define SCI0CR2_RE                      _SCI0CR2.Bits.RE
#define SCI0CR2_TE                      _SCI0CR2.Bits.TE
#define SCI0CR2_ILIE                    _SCI0CR2.Bits.ILIE
#define SCI0CR2_RIE                     _SCI0CR2.Bits.RIE
#define SCI0CR2_TCIE                    _SCI0CR2.Bits.TCIE
#define SCI0CR2_TIE                     _SCI0CR2.Bits.TIE_bit

#define SCI0CR2_SBK_MASK                1U
#define SCI0CR2_RWU_MASK                2U
#define SCI0CR2_RE_MASK                 4U
#define SCI0CR2_TE_MASK                 8U
#define SCI0CR2_ILIE_MASK               16U
#define SCI0CR2_RIE_MASK                32U
#define SCI0CR2_TCIE_MASK               64U
#define SCI0CR2_TIE_MASK                128U


/*** SCI0SR1 - SCI 0 Status Register 1; 0x000000CC ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0SR1STR;
extern volatile SCI0SR1STR _SCI0SR1 @(REG_BASE + 0x000000CCUL);
#define SCI0SR1                         _SCI0SR1.Byte
#define SCI0SR1_PF                      _SCI0SR1.Bits.PF
#define SCI0SR1_FE                      _SCI0SR1.Bits.FE
#define SCI0SR1_NF                      _SCI0SR1.Bits.NF
#define SCI0SR1_OR                      _SCI0SR1.Bits.OR
#define SCI0SR1_IDLE                    _SCI0SR1.Bits.IDLE
#define SCI0SR1_RDRF                    _SCI0SR1.Bits.RDRF
#define SCI0SR1_TC                      _SCI0SR1.Bits.TC
#define SCI0SR1_TDRE                    _SCI0SR1.Bits.TDRE

#define SCI0SR1_PF_MASK                 1U
#define SCI0SR1_FE_MASK                 2U
#define SCI0SR1_NF_MASK                 4U
#define SCI0SR1_OR_MASK                 8U
#define SCI0SR1_IDLE_MASK               16U
#define SCI0SR1_RDRF_MASK               32U
#define SCI0SR1_TC_MASK                 64U
#define SCI0SR1_TDRE_MASK               128U


/*** SCI0SR2 - SCI 0 Status Register 2; 0x000000CD ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI0SR2STR;
extern volatile SCI0SR2STR _SCI0SR2 @(REG_BASE + 0x000000CDUL);
#define SCI0SR2                         _SCI0SR2.Byte
#define SCI0SR2_RAF                     _SCI0SR2.Bits.RAF
#define SCI0SR2_TXDIR                   _SCI0SR2.Bits.TXDIR
#define SCI0SR2_BRK13                   _SCI0SR2.Bits.BRK13
#define SCI0SR2_RXPOL                   _SCI0SR2.Bits.RXPOL
#define SCI0SR2_TXPOL                   _SCI0SR2.Bits.TXPOL
#define SCI0SR2_AMAP                    _SCI0SR2.Bits.AMAP

#define SCI0SR2_RAF_MASK                1U
#define SCI0SR2_TXDIR_MASK              2U
#define SCI0SR2_BRK13_MASK              4U
#define SCI0SR2_RXPOL_MASK              8U
#define SCI0SR2_TXPOL_MASK              16U
#define SCI0SR2_AMAP_MASK               128U


/*** SCI0DRH - SCI 0 Data Register High; 0x000000CE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI0DRHSTR;
extern volatile SCI0DRHSTR _SCI0DRH @(REG_BASE + 0x000000CEUL);
#define SCI0DRH                         _SCI0DRH.Byte
#define SCI0DRH_T8                      _SCI0DRH.Bits.T8
#define SCI0DRH_R8                      _SCI0DRH.Bits.R8

#define SCI0DRH_T8_MASK                 64U
#define SCI0DRH_R8_MASK                 128U


/*** SCI0DRL - SCI 0 Data Register Low; 0x000000CF ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI0DRLSTR;
extern volatile SCI0DRLSTR _SCI0DRL @(REG_BASE + 0x000000CFUL);
#define SCI0DRL                         _SCI0DRL.Byte
#define SCI0DRL_R0_T0                   _SCI0DRL.Bits.R0_T0
#define SCI0DRL_R1_T1                   _SCI0DRL.Bits.R1_T1
#define SCI0DRL_R2_T2                   _SCI0DRL.Bits.R2_T2
#define SCI0DRL_R3_T3                   _SCI0DRL.Bits.R3_T3
#define SCI0DRL_R4_T4                   _SCI0DRL.Bits.R4_T4
#define SCI0DRL_R5_T5                   _SCI0DRL.Bits.R5_T5
#define SCI0DRL_R6_T6                   _SCI0DRL.Bits.R6_T6
#define SCI0DRL_R7_T7                   _SCI0DRL.Bits.R7_T7

#define SCI0DRL_R0_T0_MASK              1U
#define SCI0DRL_R1_T1_MASK              2U
#define SCI0DRL_R2_T2_MASK              4U
#define SCI0DRL_R3_T3_MASK              8U
#define SCI0DRL_R4_T4_MASK              16U
#define SCI0DRL_R5_T5_MASK              32U
#define SCI0DRL_R6_T6_MASK              64U
#define SCI0DRL_R7_T7_MASK              128U


/*** SCI1BD - SCI 1 Baud Rate Register; 0x000000D0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; 0x000000D0 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ASR1 - SCI 1 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI1ASR1STR;
        #define SCI1ASR1                _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1ASR1_BKDIF          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BKDIF
        #define SCI1ASR1_BERRIF         _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRIF
        #define SCI1ASR1_BERRV          _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.BERRV
        #define SCI1ASR1_RXEDGIF        _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1ASR1STR.Bits.RXEDGIF
        
        #define SCI1ASR1_BKDIF_MASK     1U
        #define SCI1ASR1_BERRIF_MASK    2U
        #define SCI1ASR1_BERRV_MASK     4U
        #define SCI1ASR1_RXEDGIF_MASK   128U
        
        /*** SCI1BDH - SCI 1 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI1BDHSTR;
        #define SCI1BDH                 _SCI1BD.Overlap_STR.SCI1ASR1STR.Byte
        #define SCI1BDH_SBR8            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR8
        #define SCI1BDH_SBR9            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR9
        #define SCI1BDH_SBR10           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR10
        #define SCI1BDH_SBR11           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR11
        #define SCI1BDH_SBR12           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.SBR12
        #define SCI1BDH_TNP0            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP0
        #define SCI1BDH_TNP1            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.TNP1
        #define SCI1BDH_IREN            _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.Bits.IREN
        #define SCI1BDH_SBR_8           _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpSBR_8
        #define SCI1BDH_TNP             _SCI1BD.Overlap_STR.SCI1ASR1STR.SameAddr_STR.SCI1BDHSTR.MergedBits.grpTNP
        #define SCI1BDH_SBR             SCI1BDH_SBR_8
        
        #define SCI1BDH_SBR8_MASK       1U
        #define SCI1BDH_SBR9_MASK       2U
        #define SCI1BDH_SBR10_MASK      4U
        #define SCI1BDH_SBR11_MASK      8U
        #define SCI1BDH_SBR12_MASK      16U
        #define SCI1BDH_TNP0_MASK       32U
        #define SCI1BDH_TNP1_MASK       64U
        #define SCI1BDH_IREN_MASK       128U
        #define SCI1BDH_SBR_8_MASK      31U
        #define SCI1BDH_SBR_8_BITNUM    0U
        #define SCI1BDH_TNP_MASK        96U
        #define SCI1BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ASR1STR;
    

    /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; 0x000000D1 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI1ACR1 - SCI 1 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI1ACR1STR;
        #define SCI1ACR1                _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1ACR1_BKDIE          _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BKDIE
        #define SCI1ACR1_BERRIE         _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.BERRIE
        #define SCI1ACR1_RXEDGIE        _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1ACR1STR.Bits.RXEDGIE
        
        #define SCI1ACR1_BKDIE_MASK     1U
        #define SCI1ACR1_BERRIE_MASK    2U
        #define SCI1ACR1_RXEDGIE_MASK   128U
        
        /*** SCI1BDL - SCI 1 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI1BDLSTR;
        #define SCI1BDL                 _SCI1BD.Overlap_STR.SCI1ACR1STR.Byte
        #define SCI1BDL_SBR0            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR0
        #define SCI1BDL_SBR1            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR1
        #define SCI1BDL_SBR2            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR2
        #define SCI1BDL_SBR3            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR3
        #define SCI1BDL_SBR4            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR4
        #define SCI1BDL_SBR5            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR5
        #define SCI1BDL_SBR6            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR6
        #define SCI1BDL_SBR7            _SCI1BD.Overlap_STR.SCI1ACR1STR.SameAddr_STR.SCI1BDLSTR.Bits.SBR7
        
        #define SCI1BDL_SBR0_MASK       1U
        #define SCI1BDL_SBR1_MASK       2U
        #define SCI1BDL_SBR2_MASK       4U
        #define SCI1BDL_SBR3_MASK       8U
        #define SCI1BDL_SBR4_MASK       16U
        #define SCI1BDL_SBR5_MASK       32U
        #define SCI1BDL_SBR6_MASK       64U
        #define SCI1BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI1ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI1BDSTR;
extern volatile SCI1BDSTR _SCI1BD @(REG_BASE + 0x000000D0UL);
#define SCI1BD                          _SCI1BD.Word
#define SCI1BD_SBR0                     _SCI1BD.Bits.SBR0
#define SCI1BD_SBR1                     _SCI1BD.Bits.SBR1
#define SCI1BD_SBR2                     _SCI1BD.Bits.SBR2
#define SCI1BD_SBR3                     _SCI1BD.Bits.SBR3
#define SCI1BD_SBR4                     _SCI1BD.Bits.SBR4
#define SCI1BD_SBR5                     _SCI1BD.Bits.SBR5
#define SCI1BD_SBR6                     _SCI1BD.Bits.SBR6
#define SCI1BD_SBR7                     _SCI1BD.Bits.SBR7
#define SCI1BD_SBR8                     _SCI1BD.Bits.SBR8
#define SCI1BD_SBR9                     _SCI1BD.Bits.SBR9
#define SCI1BD_SBR10                    _SCI1BD.Bits.SBR10
#define SCI1BD_SBR11                    _SCI1BD.Bits.SBR11
#define SCI1BD_SBR12                    _SCI1BD.Bits.SBR12
#define SCI1BD_TNP0                     _SCI1BD.Bits.TNP0
#define SCI1BD_TNP1                     _SCI1BD.Bits.TNP1
#define SCI1BD_IREN                     _SCI1BD.Bits.IREN
#define SCI1BD_SBR                      _SCI1BD.MergedBits.grpSBR
#define SCI1BD_TNP                      _SCI1BD.MergedBits.grpTNP

#define SCI1BD_SBR0_MASK                1U
#define SCI1BD_SBR1_MASK                2U
#define SCI1BD_SBR2_MASK                4U
#define SCI1BD_SBR3_MASK                8U
#define SCI1BD_SBR4_MASK                16U
#define SCI1BD_SBR5_MASK                32U
#define SCI1BD_SBR6_MASK                64U
#define SCI1BD_SBR7_MASK                128U
#define SCI1BD_SBR8_MASK                256U
#define SCI1BD_SBR9_MASK                512U
#define SCI1BD_SBR10_MASK               1024U
#define SCI1BD_SBR11_MASK               2048U
#define SCI1BD_SBR12_MASK               4096U
#define SCI1BD_TNP0_MASK                8192U
#define SCI1BD_TNP1_MASK                16384U
#define SCI1BD_IREN_MASK                32768U
#define SCI1BD_SBR_MASK                 8191U
#define SCI1BD_SBR_BITNUM               0U
#define SCI1BD_TNP_MASK                 24576U
#define SCI1BD_TNP_BITNUM               13U


/*** SCI1ACR2 - SCI 1 Alternative Control Register 2; 0x000000D2 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI1ACR2 - SCI 1 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode Bit 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode Bit 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI1ACR2STR;
    #define SCI1ACR2                    _SCI1ACR2.Byte
    #define SCI1ACR2_BKDFE              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BKDFE
    #define SCI1ACR2_BERRM0             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM0
    #define SCI1ACR2_BERRM1             _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.Bits.BERRM1
    #define SCI1ACR2_BERRM              _SCI1ACR2.SameAddr_STR.SCI1ACR2STR.MergedBits.grpBERRM
    
    #define SCI1ACR2_BKDFE_MASK         1U
    #define SCI1ACR2_BERRM0_MASK        2U
    #define SCI1ACR2_BERRM1_MASK        4U
    #define SCI1ACR2_BERRM_MASK         6U
    #define SCI1ACR2_BERRM_BITNUM       1U
    
    /*** SCI1CR1 - SCI 1 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI1CR1STR;
    #define SCI1CR1                     _SCI1ACR2.Byte
    #define SCI1CR1_PT                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PT
    #define SCI1CR1_PE                  _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.PE
    #define SCI1CR1_ILT                 _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.ILT
    #define SCI1CR1_WAKE                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.WAKE
    #define SCI1CR1_M                   _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.M
    #define SCI1CR1_RSRC                _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.RSRC
    #define SCI1CR1_SCISWAI             _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.SCISWAI
    #define SCI1CR1_LOOPS               _SCI1ACR2.SameAddr_STR.SCI1CR1STR.Bits.LOOPS
    
    #define SCI1CR1_PT_MASK             1U
    #define SCI1CR1_PE_MASK             2U
    #define SCI1CR1_ILT_MASK            4U
    #define SCI1CR1_WAKE_MASK           8U
    #define SCI1CR1_M_MASK              16U
    #define SCI1CR1_RSRC_MASK           32U
    #define SCI1CR1_SCISWAI_MASK        64U
    #define SCI1CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI1ACR2STR;
extern volatile SCI1ACR2STR _SCI1ACR2 @(REG_BASE + 0x000000D2UL);


/*** SCI1CR2 - SCI 1 Control Register 2; 0x000000D3 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI1CR2STR;
extern volatile SCI1CR2STR _SCI1CR2 @(REG_BASE + 0x000000D3UL);
#define SCI1CR2                         _SCI1CR2.Byte
#define SCI1CR2_SBK                     _SCI1CR2.Bits.SBK
#define SCI1CR2_RWU                     _SCI1CR2.Bits.RWU
#define SCI1CR2_RE                      _SCI1CR2.Bits.RE
#define SCI1CR2_TE                      _SCI1CR2.Bits.TE
#define SCI1CR2_ILIE                    _SCI1CR2.Bits.ILIE
#define SCI1CR2_RIE                     _SCI1CR2.Bits.RIE
#define SCI1CR2_TCIE                    _SCI1CR2.Bits.TCIE
#define SCI1CR2_TIE                     _SCI1CR2.Bits.TIE_bit

#define SCI1CR2_SBK_MASK                1U
#define SCI1CR2_RWU_MASK                2U
#define SCI1CR2_RE_MASK                 4U
#define SCI1CR2_TE_MASK                 8U
#define SCI1CR2_ILIE_MASK               16U
#define SCI1CR2_RIE_MASK                32U
#define SCI1CR2_TCIE_MASK               64U
#define SCI1CR2_TIE_MASK                128U


/*** SCI1SR1 - SCI 1 Status Register 1; 0x000000D4 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI1SR1STR;
extern volatile SCI1SR1STR _SCI1SR1 @(REG_BASE + 0x000000D4UL);
#define SCI1SR1                         _SCI1SR1.Byte
#define SCI1SR1_PF                      _SCI1SR1.Bits.PF
#define SCI1SR1_FE                      _SCI1SR1.Bits.FE
#define SCI1SR1_NF                      _SCI1SR1.Bits.NF
#define SCI1SR1_OR                      _SCI1SR1.Bits.OR
#define SCI1SR1_IDLE                    _SCI1SR1.Bits.IDLE
#define SCI1SR1_RDRF                    _SCI1SR1.Bits.RDRF
#define SCI1SR1_TC                      _SCI1SR1.Bits.TC
#define SCI1SR1_TDRE                    _SCI1SR1.Bits.TDRE

#define SCI1SR1_PF_MASK                 1U
#define SCI1SR1_FE_MASK                 2U
#define SCI1SR1_NF_MASK                 4U
#define SCI1SR1_OR_MASK                 8U
#define SCI1SR1_IDLE_MASK               16U
#define SCI1SR1_RDRF_MASK               32U
#define SCI1SR1_TC_MASK                 64U
#define SCI1SR1_TDRE_MASK               128U


/*** SCI1SR2 - SCI 1 Status Register 2; 0x000000D5 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI1SR2STR;
extern volatile SCI1SR2STR _SCI1SR2 @(REG_BASE + 0x000000D5UL);
#define SCI1SR2                         _SCI1SR2.Byte
#define SCI1SR2_RAF                     _SCI1SR2.Bits.RAF
#define SCI1SR2_TXDIR                   _SCI1SR2.Bits.TXDIR
#define SCI1SR2_BRK13                   _SCI1SR2.Bits.BRK13
#define SCI1SR2_RXPOL                   _SCI1SR2.Bits.RXPOL
#define SCI1SR2_TXPOL                   _SCI1SR2.Bits.TXPOL
#define SCI1SR2_AMAP                    _SCI1SR2.Bits.AMAP

#define SCI1SR2_RAF_MASK                1U
#define SCI1SR2_TXDIR_MASK              2U
#define SCI1SR2_BRK13_MASK              4U
#define SCI1SR2_RXPOL_MASK              8U
#define SCI1SR2_TXPOL_MASK              16U
#define SCI1SR2_AMAP_MASK               128U


/*** SCI1DRH - SCI 1 Data Register High; 0x000000D6 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI1DRHSTR;
extern volatile SCI1DRHSTR _SCI1DRH @(REG_BASE + 0x000000D6UL);
#define SCI1DRH                         _SCI1DRH.Byte
#define SCI1DRH_T8                      _SCI1DRH.Bits.T8
#define SCI1DRH_R8                      _SCI1DRH.Bits.R8

#define SCI1DRH_T8_MASK                 64U
#define SCI1DRH_R8_MASK                 128U


/*** SCI1DRL - SCI 1 Data Register Low; 0x000000D7 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI1DRLSTR;
extern volatile SCI1DRLSTR _SCI1DRL @(REG_BASE + 0x000000D7UL);
#define SCI1DRL                         _SCI1DRL.Byte
#define SCI1DRL_R0_T0                   _SCI1DRL.Bits.R0_T0
#define SCI1DRL_R1_T1                   _SCI1DRL.Bits.R1_T1
#define SCI1DRL_R2_T2                   _SCI1DRL.Bits.R2_T2
#define SCI1DRL_R3_T3                   _SCI1DRL.Bits.R3_T3
#define SCI1DRL_R4_T4                   _SCI1DRL.Bits.R4_T4
#define SCI1DRL_R5_T5                   _SCI1DRL.Bits.R5_T5
#define SCI1DRL_R6_T6                   _SCI1DRL.Bits.R6_T6
#define SCI1DRL_R7_T7                   _SCI1DRL.Bits.R7_T7

#define SCI1DRL_R0_T0_MASK              1U
#define SCI1DRL_R1_T1_MASK              2U
#define SCI1DRL_R2_T2_MASK              4U
#define SCI1DRL_R3_T3_MASK              8U
#define SCI1DRL_R4_T4_MASK              16U
#define SCI1DRL_R5_T5_MASK              32U
#define SCI1DRL_R6_T6_MASK              64U
#define SCI1DRL_R7_T7_MASK              128U


/*** SPI0CR1 - SPI 0 Control Register; 0x000000D8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI0CR1STR;
extern volatile SPI0CR1STR _SPI0CR1 @(REG_BASE + 0x000000D8UL);
#define SPI0CR1                         _SPI0CR1.Byte
#define SPI0CR1_LSBFE                   _SPI0CR1.Bits.LSBFE
#define SPI0CR1_SSOE                    _SPI0CR1.Bits.SSOE
#define SPI0CR1_CPHA                    _SPI0CR1.Bits.CPHA
#define SPI0CR1_CPOL                    _SPI0CR1.Bits.CPOL
#define SPI0CR1_MSTR                    _SPI0CR1.Bits.MSTR
#define SPI0CR1_SPTIE                   _SPI0CR1.Bits.SPTIE
#define SPI0CR1_SPE                     _SPI0CR1.Bits.SPE
#define SPI0CR1_SPIE                    _SPI0CR1.Bits.SPIE

#define SPI0CR1_LSBFE_MASK              1U
#define SPI0CR1_SSOE_MASK               2U
#define SPI0CR1_CPHA_MASK               4U
#define SPI0CR1_CPOL_MASK               8U
#define SPI0CR1_MSTR_MASK               16U
#define SPI0CR1_SPTIE_MASK              32U
#define SPI0CR1_SPE_MASK                64U
#define SPI0CR1_SPIE_MASK               128U


/*** SPI0CR2 - SPI 0 Control Register 2; 0x000000D9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI0CR2STR;
extern volatile SPI0CR2STR _SPI0CR2 @(REG_BASE + 0x000000D9UL);
#define SPI0CR2                         _SPI0CR2.Byte
#define SPI0CR2_SPC0                    _SPI0CR2.Bits.SPC0
#define SPI0CR2_SPISWAI                 _SPI0CR2.Bits.SPISWAI
#define SPI0CR2_BIDIROE                 _SPI0CR2.Bits.BIDIROE
#define SPI0CR2_MODFEN                  _SPI0CR2.Bits.MODFEN

#define SPI0CR2_SPC0_MASK               1U
#define SPI0CR2_SPISWAI_MASK            2U
#define SPI0CR2_BIDIROE_MASK            8U
#define SPI0CR2_MODFEN_MASK             16U


/*** SPI0BR - SPI 0 Baud Rate Register; 0x000000DA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI0BRSTR;
extern volatile SPI0BRSTR _SPI0BR @(REG_BASE + 0x000000DAUL);
#define SPI0BR                          _SPI0BR.Byte
#define SPI0BR_SPR0                     _SPI0BR.Bits.SPR0
#define SPI0BR_SPR1                     _SPI0BR.Bits.SPR1
#define SPI0BR_SPR2                     _SPI0BR.Bits.SPR2
#define SPI0BR_SPPR0                    _SPI0BR.Bits.SPPR0
#define SPI0BR_SPPR1                    _SPI0BR.Bits.SPPR1
#define SPI0BR_SPPR2                    _SPI0BR.Bits.SPPR2
#define SPI0BR_SPR                      _SPI0BR.MergedBits.grpSPR
#define SPI0BR_SPPR                     _SPI0BR.MergedBits.grpSPPR

#define SPI0BR_SPR0_MASK                1U
#define SPI0BR_SPR1_MASK                2U
#define SPI0BR_SPR2_MASK                4U
#define SPI0BR_SPPR0_MASK               16U
#define SPI0BR_SPPR1_MASK               32U
#define SPI0BR_SPPR2_MASK               64U
#define SPI0BR_SPR_MASK                 7U
#define SPI0BR_SPR_BITNUM               0U
#define SPI0BR_SPPR_MASK                112U
#define SPI0BR_SPPR_BITNUM              4U


/*** SPI0SR - SPI 0 Status Register; 0x000000DB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI0SRSTR;
extern volatile SPI0SRSTR _SPI0SR @(REG_BASE + 0x000000DBUL);
#define SPI0SR                          _SPI0SR.Byte
#define SPI0SR_MODF                     _SPI0SR.Bits.MODF
#define SPI0SR_SPTEF                    _SPI0SR.Bits.SPTEF
#define SPI0SR_SPIF                     _SPI0SR.Bits.SPIF

#define SPI0SR_MODF_MASK                16U
#define SPI0SR_SPTEF_MASK               32U
#define SPI0SR_SPIF_MASK                128U


/*** SPI0DR - SPI 0 Data Register; 0x000000DD ***/
typedef union {
  byte Byte;
} SPI0DRSTR;
extern volatile SPI0DRSTR _SPI0DR @(REG_BASE + 0x000000DDUL);
#define SPI0DR                          _SPI0DR.Byte


/*** IIC0_IBAD - IIC 0 Address Register; 0x000000E0 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte ADR1        :1;                                       /* Slave Address Bit 1 */
    byte ADR2        :1;                                       /* Slave Address Bit 2 */
    byte ADR3        :1;                                       /* Slave Address Bit 3 */
    byte ADR4        :1;                                       /* Slave Address Bit 4 */
    byte ADR5        :1;                                       /* Slave Address Bit 5 */
    byte ADR6        :1;                                       /* Slave Address Bit 6 */
    byte ADR7        :1;                                       /* Slave Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpADR_1 :7;
  } MergedBits;
} IIC0_IBADSTR;
extern volatile IIC0_IBADSTR _IIC0_IBAD @(REG_BASE + 0x000000E0UL);
#define IIC0_IBAD                       _IIC0_IBAD.Byte
#define IIC0_IBAD_ADR1                  _IIC0_IBAD.Bits.ADR1
#define IIC0_IBAD_ADR2                  _IIC0_IBAD.Bits.ADR2
#define IIC0_IBAD_ADR3                  _IIC0_IBAD.Bits.ADR3
#define IIC0_IBAD_ADR4                  _IIC0_IBAD.Bits.ADR4
#define IIC0_IBAD_ADR5                  _IIC0_IBAD.Bits.ADR5
#define IIC0_IBAD_ADR6                  _IIC0_IBAD.Bits.ADR6
#define IIC0_IBAD_ADR7                  _IIC0_IBAD.Bits.ADR7
#define IIC0_IBAD_ADR_1                 _IIC0_IBAD.MergedBits.grpADR_1
#define IIC0_IBAD_ADR                   IIC0_IBAD_ADR_1

#define IIC0_IBAD_ADR1_MASK             2U
#define IIC0_IBAD_ADR2_MASK             4U
#define IIC0_IBAD_ADR3_MASK             8U
#define IIC0_IBAD_ADR4_MASK             16U
#define IIC0_IBAD_ADR5_MASK             32U
#define IIC0_IBAD_ADR6_MASK             64U
#define IIC0_IBAD_ADR7_MASK             128U
#define IIC0_IBAD_ADR_1_MASK            254U
#define IIC0_IBAD_ADR_1_BITNUM          1U


/*** IIC0_IBFD - IIC 0 Frequency Divider Register; 0x000000E1 ***/
typedef union {
  byte Byte;
  struct {
    byte IBC0        :1;                                       /* I-Bus Clock Rate 0 */
    byte IBC1        :1;                                       /* I-Bus Clock Rate 1 */
    byte IBC2        :1;                                       /* I-Bus Clock Rate 2 */
    byte IBC3        :1;                                       /* I-Bus Clock Rate 3 */
    byte IBC4        :1;                                       /* I-Bus Clock Rate 4 */
    byte IBC5        :1;                                       /* I-Bus Clock Rate 5 */
    byte IBC6        :1;                                       /* I-Bus Clock Rate 6 */
    byte IBC7        :1;                                       /* I-Bus Clock Rate 7 */
  } Bits;
} IIC0_IBFDSTR;
extern volatile IIC0_IBFDSTR _IIC0_IBFD @(REG_BASE + 0x000000E1UL);
#define IIC0_IBFD                       _IIC0_IBFD.Byte
#define IIC0_IBFD_IBC0                  _IIC0_IBFD.Bits.IBC0
#define IIC0_IBFD_IBC1                  _IIC0_IBFD.Bits.IBC1
#define IIC0_IBFD_IBC2                  _IIC0_IBFD.Bits.IBC2
#define IIC0_IBFD_IBC3                  _IIC0_IBFD.Bits.IBC3
#define IIC0_IBFD_IBC4                  _IIC0_IBFD.Bits.IBC4
#define IIC0_IBFD_IBC5                  _IIC0_IBFD.Bits.IBC5
#define IIC0_IBFD_IBC6                  _IIC0_IBFD.Bits.IBC6
#define IIC0_IBFD_IBC7                  _IIC0_IBFD.Bits.IBC7

#define IIC0_IBFD_IBC0_MASK             1U
#define IIC0_IBFD_IBC1_MASK             2U
#define IIC0_IBFD_IBC2_MASK             4U
#define IIC0_IBFD_IBC3_MASK             8U
#define IIC0_IBFD_IBC4_MASK             16U
#define IIC0_IBFD_IBC5_MASK             32U
#define IIC0_IBFD_IBC6_MASK             64U
#define IIC0_IBFD_IBC7_MASK             128U


/*** IIC0_IBCR - IIC 0 Control Register; 0x000000E2 ***/
typedef union {
  byte Byte;
  struct {
    byte IBSWAI      :1;                                       /* I-Bus Interface Stop in WAIT mode */
    byte             :1; 
    byte RSTA        :1;                                       /* Repeat Start */
    byte TXAK        :1;                                       /* Transmit Acknowledge enable */
    byte TX_RX       :1;                                       /* Transmit/Receive mode select bit */
    byte MS_SL       :1;                                       /* Master/Slave mode select bit */
    byte IBIE        :1;                                       /* I-Bus Interrupt Enable */
    byte IBEN        :1;                                       /* I-Bus Enable */
  } Bits;
} IIC0_IBCRSTR;
extern volatile IIC0_IBCRSTR _IIC0_IBCR @(REG_BASE + 0x000000E2UL);
#define IIC0_IBCR                       _IIC0_IBCR.Byte
#define IIC0_IBCR_IBSWAI                _IIC0_IBCR.Bits.IBSWAI
#define IIC0_IBCR_RSTA                  _IIC0_IBCR.Bits.RSTA
#define IIC0_IBCR_TXAK                  _IIC0_IBCR.Bits.TXAK
#define IIC0_IBCR_TX_RX                 _IIC0_IBCR.Bits.TX_RX
#define IIC0_IBCR_MS_SL                 _IIC0_IBCR.Bits.MS_SL
#define IIC0_IBCR_IBIE                  _IIC0_IBCR.Bits.IBIE
#define IIC0_IBCR_IBEN                  _IIC0_IBCR.Bits.IBEN

#define IIC0_IBCR_IBSWAI_MASK           1U
#define IIC0_IBCR_RSTA_MASK             4U
#define IIC0_IBCR_TXAK_MASK             8U
#define IIC0_IBCR_TX_RX_MASK            16U
#define IIC0_IBCR_MS_SL_MASK            32U
#define IIC0_IBCR_IBIE_MASK             64U
#define IIC0_IBCR_IBEN_MASK             128U


/*** IIC0_IBSR - IIC 0 Status Register; 0x000000E3 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Received Acknowledge */
    byte IBIF        :1;                                       /* I-Bus Interrupt */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte IBAL        :1;                                       /* Arbitration Lost */
    byte IBB         :1;                                       /* Bus busy bit */
    byte IAAS        :1;                                       /* Addressed as a slave bit */
    byte TCF         :1;                                       /* Data transferring bit */
  } Bits;
} IIC0_IBSRSTR;
extern volatile IIC0_IBSRSTR _IIC0_IBSR @(REG_BASE + 0x000000E3UL);
#define IIC0_IBSR                       _IIC0_IBSR.Byte
#define IIC0_IBSR_RXAK                  _IIC0_IBSR.Bits.RXAK
#define IIC0_IBSR_IBIF                  _IIC0_IBSR.Bits.IBIF
#define IIC0_IBSR_SRW                   _IIC0_IBSR.Bits.SRW
#define IIC0_IBSR_IBAL                  _IIC0_IBSR.Bits.IBAL
#define IIC0_IBSR_IBB                   _IIC0_IBSR.Bits.IBB
#define IIC0_IBSR_IAAS                  _IIC0_IBSR.Bits.IAAS
#define IIC0_IBSR_TCF                   _IIC0_IBSR.Bits.TCF

#define IIC0_IBSR_RXAK_MASK             1U
#define IIC0_IBSR_IBIF_MASK             2U
#define IIC0_IBSR_SRW_MASK              4U
#define IIC0_IBSR_IBAL_MASK             16U
#define IIC0_IBSR_IBB_MASK              32U
#define IIC0_IBSR_IAAS_MASK             64U
#define IIC0_IBSR_TCF_MASK              128U


/*** IIC0_IBDR - IIC 0 Data I/O Register; 0x000000E4 ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* IIC Data Bit 0 */
    byte D1          :1;                                       /* IIC Data Bit 1 */
    byte D2          :1;                                       /* IIC Data Bit 2 */
    byte D3          :1;                                       /* IIC Data Bit 3 */
    byte D4          :1;                                       /* IIC Data Bit 4 */
    byte D5          :1;                                       /* IIC Data Bit 5 */
    byte D6          :1;                                       /* IIC Data Bit 6 */
    byte D7          :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IIC0_IBDRSTR;
extern volatile IIC0_IBDRSTR _IIC0_IBDR @(REG_BASE + 0x000000E4UL);
#define IIC0_IBDR                       _IIC0_IBDR.Byte
#define IIC0_IBDR_D0                    _IIC0_IBDR.Bits.D0
#define IIC0_IBDR_D1                    _IIC0_IBDR.Bits.D1
#define IIC0_IBDR_D2                    _IIC0_IBDR.Bits.D2
#define IIC0_IBDR_D3                    _IIC0_IBDR.Bits.D3
#define IIC0_IBDR_D4                    _IIC0_IBDR.Bits.D4
#define IIC0_IBDR_D5                    _IIC0_IBDR.Bits.D5
#define IIC0_IBDR_D6                    _IIC0_IBDR.Bits.D6
#define IIC0_IBDR_D7                    _IIC0_IBDR.Bits.D7

#define IIC0_IBDR_D0_MASK               1U
#define IIC0_IBDR_D1_MASK               2U
#define IIC0_IBDR_D2_MASK               4U
#define IIC0_IBDR_D3_MASK               8U
#define IIC0_IBDR_D4_MASK               16U
#define IIC0_IBDR_D5_MASK               32U
#define IIC0_IBDR_D6_MASK               64U
#define IIC0_IBDR_D7_MASK               128U


/*** SPI1CR1 - SPI 1 Control Register; 0x000000F0 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI1CR1STR;
extern volatile SPI1CR1STR _SPI1CR1 @(REG_BASE + 0x000000F0UL);
#define SPI1CR1                         _SPI1CR1.Byte
#define SPI1CR1_LSBFE                   _SPI1CR1.Bits.LSBFE
#define SPI1CR1_SSOE                    _SPI1CR1.Bits.SSOE
#define SPI1CR1_CPHA                    _SPI1CR1.Bits.CPHA
#define SPI1CR1_CPOL                    _SPI1CR1.Bits.CPOL
#define SPI1CR1_MSTR                    _SPI1CR1.Bits.MSTR
#define SPI1CR1_SPTIE                   _SPI1CR1.Bits.SPTIE
#define SPI1CR1_SPE                     _SPI1CR1.Bits.SPE
#define SPI1CR1_SPIE                    _SPI1CR1.Bits.SPIE

#define SPI1CR1_LSBFE_MASK              1U
#define SPI1CR1_SSOE_MASK               2U
#define SPI1CR1_CPHA_MASK               4U
#define SPI1CR1_CPOL_MASK               8U
#define SPI1CR1_MSTR_MASK               16U
#define SPI1CR1_SPTIE_MASK              32U
#define SPI1CR1_SPE_MASK                64U
#define SPI1CR1_SPIE_MASK               128U


/*** SPI1CR2 - SPI 1 Control Register 2; 0x000000F1 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI1CR2STR;
extern volatile SPI1CR2STR _SPI1CR2 @(REG_BASE + 0x000000F1UL);
#define SPI1CR2                         _SPI1CR2.Byte
#define SPI1CR2_SPC0                    _SPI1CR2.Bits.SPC0
#define SPI1CR2_SPISWAI                 _SPI1CR2.Bits.SPISWAI
#define SPI1CR2_BIDIROE                 _SPI1CR2.Bits.BIDIROE
#define SPI1CR2_MODFEN                  _SPI1CR2.Bits.MODFEN

#define SPI1CR2_SPC0_MASK               1U
#define SPI1CR2_SPISWAI_MASK            2U
#define SPI1CR2_BIDIROE_MASK            8U
#define SPI1CR2_MODFEN_MASK             16U


/*** SPI1BR - SPI 1 Baud Rate Register; 0x000000F2 ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI1BRSTR;
extern volatile SPI1BRSTR _SPI1BR @(REG_BASE + 0x000000F2UL);
#define SPI1BR                          _SPI1BR.Byte
#define SPI1BR_SPR0                     _SPI1BR.Bits.SPR0
#define SPI1BR_SPR1                     _SPI1BR.Bits.SPR1
#define SPI1BR_SPR2                     _SPI1BR.Bits.SPR2
#define SPI1BR_SPPR0                    _SPI1BR.Bits.SPPR0
#define SPI1BR_SPPR1                    _SPI1BR.Bits.SPPR1
#define SPI1BR_SPPR2                    _SPI1BR.Bits.SPPR2
#define SPI1BR_SPR                      _SPI1BR.MergedBits.grpSPR
#define SPI1BR_SPPR                     _SPI1BR.MergedBits.grpSPPR

#define SPI1BR_SPR0_MASK                1U
#define SPI1BR_SPR1_MASK                2U
#define SPI1BR_SPR2_MASK                4U
#define SPI1BR_SPPR0_MASK               16U
#define SPI1BR_SPPR1_MASK               32U
#define SPI1BR_SPPR2_MASK               64U
#define SPI1BR_SPR_MASK                 7U
#define SPI1BR_SPR_BITNUM               0U
#define SPI1BR_SPPR_MASK                112U
#define SPI1BR_SPPR_BITNUM              4U


/*** SPI1SR - SPI 1 Status Register; 0x000000F3 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI1SRSTR;
extern volatile SPI1SRSTR _SPI1SR @(REG_BASE + 0x000000F3UL);
#define SPI1SR                          _SPI1SR.Byte
#define SPI1SR_MODF                     _SPI1SR.Bits.MODF
#define SPI1SR_SPTEF                    _SPI1SR.Bits.SPTEF
#define SPI1SR_SPIF                     _SPI1SR.Bits.SPIF

#define SPI1SR_MODF_MASK                16U
#define SPI1SR_SPTEF_MASK               32U
#define SPI1SR_SPIF_MASK                128U


/*** SPI1DR - SPI 1 Data Register; 0x000000F5 ***/
typedef union {
  byte Byte;
} SPI1DRSTR;
extern volatile SPI1DRSTR _SPI1DR @(REG_BASE + 0x000000F5UL);
#define SPI1DR                          _SPI1DR.Byte


/*** SPI2CR1 - SPI 2 Control Register; 0x000000F8 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* SPI LSB-First Enable */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* SPI Clock Phase Bit */
    byte CPOL        :1;                                       /* SPI Clock Polarity Bit */
    byte MSTR        :1;                                       /* SPI Master/Slave Mode Select Bit */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable Bit */
    byte SPIE        :1;                                       /* SPI Interrupt Enable Bit */
  } Bits;
} SPI2CR1STR;
extern volatile SPI2CR1STR _SPI2CR1 @(REG_BASE + 0x000000F8UL);
#define SPI2CR1                         _SPI2CR1.Byte
#define SPI2CR1_LSBFE                   _SPI2CR1.Bits.LSBFE
#define SPI2CR1_SSOE                    _SPI2CR1.Bits.SSOE
#define SPI2CR1_CPHA                    _SPI2CR1.Bits.CPHA
#define SPI2CR1_CPOL                    _SPI2CR1.Bits.CPOL
#define SPI2CR1_MSTR                    _SPI2CR1.Bits.MSTR
#define SPI2CR1_SPTIE                   _SPI2CR1.Bits.SPTIE
#define SPI2CR1_SPE                     _SPI2CR1.Bits.SPE
#define SPI2CR1_SPIE                    _SPI2CR1.Bits.SPIE

#define SPI2CR1_LSBFE_MASK              1U
#define SPI2CR1_SSOE_MASK               2U
#define SPI2CR1_CPHA_MASK               4U
#define SPI2CR1_CPOL_MASK               8U
#define SPI2CR1_MSTR_MASK               16U
#define SPI2CR1_SPTIE_MASK              32U
#define SPI2CR1_SPE_MASK                64U
#define SPI2CR1_SPIE_MASK               128U


/*** SPI2CR2 - SPI 2 Control Register 2; 0x000000F9 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* Serial Pin Control Bit 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode Bit */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Output enable in the Bidirectional mode of operation */
    byte MODFEN      :1;                                       /* Mode Fault Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI2CR2STR;
extern volatile SPI2CR2STR _SPI2CR2 @(REG_BASE + 0x000000F9UL);
#define SPI2CR2                         _SPI2CR2.Byte
#define SPI2CR2_SPC0                    _SPI2CR2.Bits.SPC0
#define SPI2CR2_SPISWAI                 _SPI2CR2.Bits.SPISWAI
#define SPI2CR2_BIDIROE                 _SPI2CR2.Bits.BIDIROE
#define SPI2CR2_MODFEN                  _SPI2CR2.Bits.MODFEN

#define SPI2CR2_SPC0_MASK               1U
#define SPI2CR2_SPISWAI_MASK            2U
#define SPI2CR2_BIDIROE_MASK            8U
#define SPI2CR2_MODFEN_MASK             16U


/*** SPI2BR - SPI 2 Baud Rate Register; 0x000000FA ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Selection Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Selection Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Selection Bit 2 */
    byte             :1; 
    byte SPPR0       :1;                                       /* SPI Baud Rate Preselection Bits 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Preselection Bits 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Preselection Bits 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :3;
    byte         :1;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI2BRSTR;
extern volatile SPI2BRSTR _SPI2BR @(REG_BASE + 0x000000FAUL);
#define SPI2BR                          _SPI2BR.Byte
#define SPI2BR_SPR0                     _SPI2BR.Bits.SPR0
#define SPI2BR_SPR1                     _SPI2BR.Bits.SPR1
#define SPI2BR_SPR2                     _SPI2BR.Bits.SPR2
#define SPI2BR_SPPR0                    _SPI2BR.Bits.SPPR0
#define SPI2BR_SPPR1                    _SPI2BR.Bits.SPPR1
#define SPI2BR_SPPR2                    _SPI2BR.Bits.SPPR2
#define SPI2BR_SPR                      _SPI2BR.MergedBits.grpSPR
#define SPI2BR_SPPR                     _SPI2BR.MergedBits.grpSPPR

#define SPI2BR_SPR0_MASK                1U
#define SPI2BR_SPR1_MASK                2U
#define SPI2BR_SPR2_MASK                4U
#define SPI2BR_SPPR0_MASK               16U
#define SPI2BR_SPPR1_MASK               32U
#define SPI2BR_SPPR2_MASK               64U
#define SPI2BR_SPR_MASK                 7U
#define SPI2BR_SPR_BITNUM               0U
#define SPI2BR_SPPR_MASK                112U
#define SPI2BR_SPPR_BITNUM              4U


/*** SPI2SR - SPI 2 Status Register; 0x000000FB ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Empty Interrupt Flag */
    byte             :1; 
    byte SPIF        :1;                                       /* SPIF Receive Interrupt Flag */
  } Bits;
} SPI2SRSTR;
extern volatile SPI2SRSTR _SPI2SR @(REG_BASE + 0x000000FBUL);
#define SPI2SR                          _SPI2SR.Byte
#define SPI2SR_MODF                     _SPI2SR.Bits.MODF
#define SPI2SR_SPTEF                    _SPI2SR.Bits.SPTEF
#define SPI2SR_SPIF                     _SPI2SR.Bits.SPIF

#define SPI2SR_MODF_MASK                16U
#define SPI2SR_SPTEF_MASK               32U
#define SPI2SR_SPIF_MASK                128U


/*** SPI2DR - SPI 2 Data Register; 0x000000FD ***/
typedef union {
  byte Byte;
} SPI2DRSTR;
extern volatile SPI2DRSTR _SPI2DR @(REG_BASE + 0x000000FDUL);
#define SPI2DR                          _SPI2DR.Byte


/*** FCLKDIV - Flash Clock Divider Register; 0x00000100 ***/
typedef union {
  byte Byte;
  struct {
    byte FDIV0       :1;                                       /* Flash Clock Divider Bit 0 */
    byte FDIV1       :1;                                       /* Flash Clock Divider Bit 1 */
    byte FDIV2       :1;                                       /* Flash Clock Divider Bit 2 */
    byte FDIV3       :1;                                       /* Flash Clock Divider Bit 3 */
    byte FDIV4       :1;                                       /* Flash Clock Divider Bit 4 */
    byte FDIV5       :1;                                       /* Flash Clock Divider Bit 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte FDIVLD      :1;                                       /* Flash Clock Divider Loaded */
  } Bits;
  struct {
    byte grpFDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} FCLKDIVSTR;
extern volatile FCLKDIVSTR _FCLKDIV @(REG_BASE + 0x00000100UL);
#define FCLKDIV                         _FCLKDIV.Byte
#define FCLKDIV_FDIV0                   _FCLKDIV.Bits.FDIV0
#define FCLKDIV_FDIV1                   _FCLKDIV.Bits.FDIV1
#define FCLKDIV_FDIV2                   _FCLKDIV.Bits.FDIV2
#define FCLKDIV_FDIV3                   _FCLKDIV.Bits.FDIV3
#define FCLKDIV_FDIV4                   _FCLKDIV.Bits.FDIV4
#define FCLKDIV_FDIV5                   _FCLKDIV.Bits.FDIV5
#define FCLKDIV_PRDIV8                  _FCLKDIV.Bits.PRDIV8
#define FCLKDIV_FDIVLD                  _FCLKDIV.Bits.FDIVLD
#define FCLKDIV_FDIV                    _FCLKDIV.MergedBits.grpFDIV

#define FCLKDIV_FDIV0_MASK              1U
#define FCLKDIV_FDIV1_MASK              2U
#define FCLKDIV_FDIV2_MASK              4U
#define FCLKDIV_FDIV3_MASK              8U
#define FCLKDIV_FDIV4_MASK              16U
#define FCLKDIV_FDIV5_MASK              32U
#define FCLKDIV_PRDIV8_MASK             64U
#define FCLKDIV_FDIVLD_MASK             128U
#define FCLKDIV_FDIV_MASK               63U
#define FCLKDIV_FDIV_BITNUM             0U


/*** FSEC - Flash Security Register; 0x00000101 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Memory security bit 0 */
    byte SEC1        :1;                                       /* Memory security bit 1 */
    byte RNV2        :1;                                       /* Reserved Non Volatile flag bit 2 */
    byte RNV3        :1;                                       /* Reserved Non Volatile flag bit 3 */
    byte RNV4        :1;                                       /* Reserved Non Volatile flag bit 4 */
    byte RNV5        :1;                                       /* Reserved Non Volatile flag bit 5 */
    byte KEYEN0      :1;                                       /* Backdoor Key Security Enable Bit 0 */
    byte KEYEN1      :1;                                       /* Backdoor Key Security Enable Bit 1 */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte grpRNV_2 :4;
    byte grpKEYEN :2;
  } MergedBits;
} FSECSTR;
extern volatile FSECSTR _FSEC @(REG_BASE + 0x00000101UL);
#define FSEC                            _FSEC.Byte
#define FSEC_SEC0                       _FSEC.Bits.SEC0
#define FSEC_SEC1                       _FSEC.Bits.SEC1
#define FSEC_RNV2                       _FSEC.Bits.RNV2
#define FSEC_RNV3                       _FSEC.Bits.RNV3
#define FSEC_RNV4                       _FSEC.Bits.RNV4
#define FSEC_RNV5                       _FSEC.Bits.RNV5
#define FSEC_KEYEN0                     _FSEC.Bits.KEYEN0
#define FSEC_KEYEN1                     _FSEC.Bits.KEYEN1
#define FSEC_SEC                        _FSEC.MergedBits.grpSEC
#define FSEC_RNV_2                      _FSEC.MergedBits.grpRNV_2
#define FSEC_KEYEN                      _FSEC.MergedBits.grpKEYEN
#define FSEC_RNV                        FSEC_RNV_2

#define FSEC_SEC0_MASK                  1U
#define FSEC_SEC1_MASK                  2U
#define FSEC_RNV2_MASK                  4U
#define FSEC_RNV3_MASK                  8U
#define FSEC_RNV4_MASK                  16U
#define FSEC_RNV5_MASK                  32U
#define FSEC_KEYEN0_MASK                64U
#define FSEC_KEYEN1_MASK                128U
#define FSEC_SEC_MASK                   3U
#define FSEC_SEC_BITNUM                 0U
#define FSEC_RNV_2_MASK                 60U
#define FSEC_RNV_2_BITNUM               2U
#define FSEC_KEYEN_MASK                 192U
#define FSEC_KEYEN_BITNUM               6U


/*** FTSTMOD - Flash Test Mode Register; 0x00000102 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte WRALL       :1;                                       /* Write to all register banks */
    byte MRDS        :2;                                       /* Margin Read Setting */
    byte             :1; 
  } Bits;
} FTSTMODSTR;
extern volatile FTSTMODSTR _FTSTMOD @(REG_BASE + 0x00000102UL);
#define FTSTMOD                         _FTSTMOD.Byte
#define FTSTMOD_WRALL                   _FTSTMOD.Bits.WRALL
#define FTSTMOD_MRDS                    _FTSTMOD.Bits.MRDS

#define FTSTMOD_WRALL_MASK              16U
#define FTSTMOD_MRDS_MASK               96U
#define FTSTMOD_MRDS_BITNUM             5U


/*** FCNFG - Flash Configuration Register; 0x00000103 ***/
typedef union {
  byte Byte;
  struct {
    byte BKSEL0      :1;                                       /* Register bank select 0 (Special mode only) */
    byte BKSEL1      :1;                                       /* Register bank select 1 (Special mode only) */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte KEYACC      :1;                                       /* Enable Security Key Writing */
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
  struct {
    byte grpBKSEL :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @(REG_BASE + 0x00000103UL);
#define FCNFG                           _FCNFG.Byte
#define FCNFG_BKSEL0                    _FCNFG.Bits.BKSEL0
#define FCNFG_BKSEL1                    _FCNFG.Bits.BKSEL1
#define FCNFG_KEYACC                    _FCNFG.Bits.KEYACC
#define FCNFG_CCIE                      _FCNFG.Bits.CCIE
#define FCNFG_CBEIE                     _FCNFG.Bits.CBEIE
#define FCNFG_BKSEL                     _FCNFG.MergedBits.grpBKSEL

#define FCNFG_BKSEL0_MASK               1U
#define FCNFG_BKSEL1_MASK               2U
#define FCNFG_KEYACC_MASK               32U
#define FCNFG_CCIE_MASK                 64U
#define FCNFG_CBEIE_MASK                128U
#define FCNFG_BKSEL_MASK                3U
#define FCNFG_BKSEL_BITNUM              0U


/*** FPROT - Flash Protection Register; 0x00000104 ***/
typedef union {
  byte Byte;
  struct {
    byte FPLS0       :1;                                       /* Flash Protection Lower Address size 0 */
    byte FPLS1       :1;                                       /* Flash Protection Lower Address size 1 */
    byte FPLDIS      :1;                                       /* Flash Protection Lower address range disable */
    byte FPHS0       :1;                                       /* Flash Protection Higher address size 0 */
    byte FPHS1       :1;                                       /* Flash Protection Higher address size 1 */
    byte FPHDIS      :1;                                       /* Flash Protection Higher address range disable */
    byte RNV6        :1;                                       /* Reserved Non-Volatile Bit */
    byte FPOPEN      :1;                                       /* Opens the flash block or subsections of it for program or erase */
  } Bits;
  struct {
    byte grpFPLS :2;
    byte         :1;
    byte grpFPHS :2;
    byte         :1;
    byte grpRNV_6 :1;
    byte         :1;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @(REG_BASE + 0x00000104UL);
#define FPROT                           _FPROT.Byte
#define FPROT_FPLS0                     _FPROT.Bits.FPLS0
#define FPROT_FPLS1                     _FPROT.Bits.FPLS1
#define FPROT_FPLDIS                    _FPROT.Bits.FPLDIS
#define FPROT_FPHS0                     _FPROT.Bits.FPHS0
#define FPROT_FPHS1                     _FPROT.Bits.FPHS1
#define FPROT_FPHDIS                    _FPROT.Bits.FPHDIS
#define FPROT_RNV6                      _FPROT.Bits.RNV6
#define FPROT_FPOPEN                    _FPROT.Bits.FPOPEN
#define FPROT_FPLS                      _FPROT.MergedBits.grpFPLS
#define FPROT_FPHS                      _FPROT.MergedBits.grpFPHS

#define FPROT_FPLS0_MASK                1U
#define FPROT_FPLS1_MASK                2U
#define FPROT_FPLDIS_MASK               4U
#define FPROT_FPHS0_MASK                8U
#define FPROT_FPHS1_MASK                16U
#define FPROT_FPHDIS_MASK               32U
#define FPROT_RNV6_MASK                 64U
#define FPROT_FPOPEN_MASK               128U
#define FPROT_FPLS_MASK                 3U
#define FPROT_FPLS_BITNUM               0U
#define FPROT_FPHS_MASK                 24U
#define FPROT_FPHS_BITNUM               3U


/*** FSTAT - Flash Status Register; 0x00000105 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte FAIL        :1;                                       /* Failed Flash Operation Flag (Special mode only) */
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffers Empty Interrupt Flag */
  } Bits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @(REG_BASE + 0x00000105UL);
#define FSTAT                           _FSTAT.Byte
#define FSTAT_FAIL                      _FSTAT.Bits.FAIL
#define FSTAT_BLANK                     _FSTAT.Bits.BLANK
#define FSTAT_ACCERR                    _FSTAT.Bits.ACCERR
#define FSTAT_PVIOL                     _FSTAT.Bits.PVIOL
#define FSTAT_CCIF                      _FSTAT.Bits.CCIF
#define FSTAT_CBEIF                     _FSTAT.Bits.CBEIF

#define FSTAT_FAIL_MASK                 2U
#define FSTAT_BLANK_MASK                4U
#define FSTAT_ACCERR_MASK               16U
#define FSTAT_PVIOL_MASK                32U
#define FSTAT_CCIF_MASK                 64U
#define FSTAT_CBEIF_MASK                128U


/*** FCMD - Flash Command Buffer and Register; 0x00000106 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB0       :1;                                       /* NVM User Mode Command Bit 0 */
    byte CMDB1       :1;                                       /* NVM User Mode Command Bit 1 */
    byte CMDB2       :1;                                       /* NVM User Mode Command Bit 2 */
    byte CMDB3       :1;                                       /* NVM User Mode Command Bit 3 */
    byte CMDB4       :1;                                       /* NVM User Mode Command Bit 4 */
    byte CMDB5       :1;                                       /* NVM User Mode Command Bit 5 */
    byte CMDB6       :1;                                       /* NVM User Mode Command Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCMDB :7;
    byte         :1;
  } MergedBits;
} FCMDSTR;
extern volatile FCMDSTR _FCMD @(REG_BASE + 0x00000106UL);
#define FCMD                            _FCMD.Byte
#define FCMD_CMDB0                      _FCMD.Bits.CMDB0
#define FCMD_CMDB1                      _FCMD.Bits.CMDB1
#define FCMD_CMDB2                      _FCMD.Bits.CMDB2
#define FCMD_CMDB3                      _FCMD.Bits.CMDB3
#define FCMD_CMDB4                      _FCMD.Bits.CMDB4
#define FCMD_CMDB5                      _FCMD.Bits.CMDB5
#define FCMD_CMDB6                      _FCMD.Bits.CMDB6
#define FCMD_CMDB                       _FCMD.MergedBits.grpCMDB

#define FCMD_CMDB0_MASK                 1U
#define FCMD_CMDB1_MASK                 2U
#define FCMD_CMDB2_MASK                 4U
#define FCMD_CMDB3_MASK                 8U
#define FCMD_CMDB4_MASK                 16U
#define FCMD_CMDB5_MASK                 32U
#define FCMD_CMDB6_MASK                 64U
#define FCMD_CMDB_MASK                  127U
#define FCMD_CMDB_BITNUM                0U


/*** FCTL - Flash Control Register; 0x00000107 ***/
typedef union {
  byte Byte;
  struct {
    byte NV0         :1;                                       /* Non-volatile bit 0 */
    byte NV1         :1;                                       /* Non-volatile bit 1 */
    byte NV2         :1;                                       /* Non-volatile bit 2 */
    byte NV3         :1;                                       /* Non-volatile bit 3 */
    byte NV4         :1;                                       /* Non-volatile bit 4 */
    byte NV5         :1;                                       /* Non-volatile bit 5 */
    byte NV6         :1;                                       /* Non-volatile bit 6 */
    byte NV7         :1;                                       /* Non-volatile bit 7 */
  } Bits;
} FCTLSTR;
extern volatile FCTLSTR _FCTL @(REG_BASE + 0x00000107UL);
#define FCTL                            _FCTL.Byte
#define FCTL_NV0                        _FCTL.Bits.NV0
#define FCTL_NV1                        _FCTL.Bits.NV1
#define FCTL_NV2                        _FCTL.Bits.NV2
#define FCTL_NV3                        _FCTL.Bits.NV3
#define FCTL_NV4                        _FCTL.Bits.NV4
#define FCTL_NV5                        _FCTL.Bits.NV5
#define FCTL_NV6                        _FCTL.Bits.NV6
#define FCTL_NV7                        _FCTL.Bits.NV7

#define FCTL_NV0_MASK                   1U
#define FCTL_NV1_MASK                   2U
#define FCTL_NV2_MASK                   4U
#define FCTL_NV3_MASK                   8U
#define FCTL_NV4_MASK                   16U
#define FCTL_NV5_MASK                   32U
#define FCTL_NV6_MASK                   64U
#define FCTL_NV7_MASK                   128U


/*** FADDR - Flash Address Register; 0x00000108 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FADDRHI - Flash Address High Register; 0x00000108 ***/
    union {
      byte Byte;
    } FADDRHISTR;
    #define FADDRHI                     _FADDR.Overlap_STR.FADDRHISTR.Byte
    

    /*** FADDRLO - Flash Address Low Register; 0x00000109 ***/
    union {
      byte Byte;
    } FADDRLOSTR;
    #define FADDRLO                     _FADDR.Overlap_STR.FADDRLOSTR.Byte
    
  } Overlap_STR;

  struct {
    word FADDRLO_grp :8;                                       /* Flash Address Bits */ /*Warning: group name is duplicated with register name*/
    word FADDRHI_grp :8;                                       /* Flash Address Bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} FADDRSTR;
extern volatile FADDRSTR _FADDR @(REG_BASE + 0x00000108UL);
#define FADDR                           _FADDR.Word
#define FADDR_FADDRLO                   _FADDR.Bits.FADDRLO_grp
#define FADDR_FADDRHI                   _FADDR.Bits.FADDRHI_grp

#define FADDR_FADDRLO_MASK              255U
#define FADDR_FADDRLO_BITNUM            0U
#define FADDR_FADDRHI_MASK              65280U
#define FADDR_FADDRHI_BITNUM            8U


/*** FDATA - Flash Data Register; 0x0000010A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FDATAHI - Flash Data High Register; 0x0000010A ***/
    union {
      byte Byte;
    } FDATAHISTR;
    #define FDATAHI                     _FDATA.Overlap_STR.FDATAHISTR.Byte
    

    /*** FDATALO - Flash Data Low Register; 0x0000010B ***/
    union {
      byte Byte;
    } FDATALOSTR;
    #define FDATALO                     _FDATA.Overlap_STR.FDATALOSTR.Byte
    
  } Overlap_STR;

  struct {
    word FDATALO_grp :8;                                       /* Flash Data Bits */ /*Warning: group name is duplicated with register name*/
    word FDATAHI_grp :8;                                       /* Flash Data Bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} FDATASTR;
extern volatile FDATASTR _FDATA @(REG_BASE + 0x0000010AUL);
#define FDATA                           _FDATA.Word
#define FDATA_FDATALO                   _FDATA.Bits.FDATALO_grp
#define FDATA_FDATAHI                   _FDATA.Bits.FDATAHI_grp

#define FDATA_FDATALO_MASK              255U
#define FDATA_FDATALO_BITNUM            0U
#define FDATA_FDATAHI_MASK              65280U
#define FDATA_FDATAHI_BITNUM            8U


/*** ECLKDIV - EEPROM Clock Divider Register; 0x00000110 ***/
typedef union {
  byte Byte;
  struct {
    byte EDIV0       :1;                                       /* EEPROM Clock Divider 0 */
    byte EDIV1       :1;                                       /* EEPROM Clock Divider 1 */
    byte EDIV2       :1;                                       /* EEPROM Clock Divider 2 */
    byte EDIV3       :1;                                       /* EEPROM Clock Divider 3 */
    byte EDIV4       :1;                                       /* EEPROM Clock Divider 4 */
    byte EDIV5       :1;                                       /* EEPROM Clock Divider 5 */
    byte PRDIV8      :1;                                       /* Enable Prescaler by 8 */
    byte EDIVLD      :1;                                       /* EEPROM Clock Divider Loaded */
  } Bits;
  struct {
    byte grpEDIV :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} ECLKDIVSTR;
extern volatile ECLKDIVSTR _ECLKDIV @(REG_BASE + 0x00000110UL);
#define ECLKDIV                         _ECLKDIV.Byte
#define ECLKDIV_EDIV0                   _ECLKDIV.Bits.EDIV0
#define ECLKDIV_EDIV1                   _ECLKDIV.Bits.EDIV1
#define ECLKDIV_EDIV2                   _ECLKDIV.Bits.EDIV2
#define ECLKDIV_EDIV3                   _ECLKDIV.Bits.EDIV3
#define ECLKDIV_EDIV4                   _ECLKDIV.Bits.EDIV4
#define ECLKDIV_EDIV5                   _ECLKDIV.Bits.EDIV5
#define ECLKDIV_PRDIV8                  _ECLKDIV.Bits.PRDIV8
#define ECLKDIV_EDIVLD                  _ECLKDIV.Bits.EDIVLD
#define ECLKDIV_EDIV                    _ECLKDIV.MergedBits.grpEDIV

#define ECLKDIV_EDIV0_MASK              1U
#define ECLKDIV_EDIV1_MASK              2U
#define ECLKDIV_EDIV2_MASK              4U
#define ECLKDIV_EDIV3_MASK              8U
#define ECLKDIV_EDIV4_MASK              16U
#define ECLKDIV_EDIV5_MASK              32U
#define ECLKDIV_PRDIV8_MASK             64U
#define ECLKDIV_EDIVLD_MASK             128U
#define ECLKDIV_EDIV_MASK               63U
#define ECLKDIV_EDIV_BITNUM             0U


/*** ECNFG - EEPROM Configuration Register; 0x00000113 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte CCIE        :1;                                       /* Command Complete Interrupt Enable */
    byte CBEIE       :1;                                       /* Command Buffers Empty Interrupt Enable */
  } Bits;
} ECNFGSTR;
extern volatile ECNFGSTR _ECNFG @(REG_BASE + 0x00000113UL);
#define ECNFG                           _ECNFG.Byte
#define ECNFG_CCIE                      _ECNFG.Bits.CCIE
#define ECNFG_CBEIE                     _ECNFG.Bits.CBEIE

#define ECNFG_CCIE_MASK                 64U
#define ECNFG_CBEIE_MASK                128U


/*** EPROT - EEPROM Protection Register; 0x00000114 ***/
typedef union {
  byte Byte;
  struct {
    byte EPS0        :1;                                       /* EEPROM Protection address size 0 */
    byte EPS1        :1;                                       /* EEPROM Protection address size 1 */
    byte EPS2        :1;                                       /* EEPROM Protection address size 2 */
    byte EPDIS       :1;                                       /* EEPROM Protection disable */
    byte RNV4        :1;                                       /* EEPROM Protection address size 4 */
    byte RNV5        :1;                                       /* EEPROM Protection address size 5 */
    byte RNV6        :1;                                       /* EEPROM Protection address size 6 */
    byte EPOPEN      :1;                                       /* Opens the EEPROM block or a subsection of it for program or erase */
  } Bits;
  struct {
    byte grpEPS  :3;
    byte         :1;
    byte grpRNV_4 :3;
    byte         :1;
  } MergedBits;
} EPROTSTR;
extern volatile EPROTSTR _EPROT @(REG_BASE + 0x00000114UL);
#define EPROT                           _EPROT.Byte
#define EPROT_EPS0                      _EPROT.Bits.EPS0
#define EPROT_EPS1                      _EPROT.Bits.EPS1
#define EPROT_EPS2                      _EPROT.Bits.EPS2
#define EPROT_EPDIS                     _EPROT.Bits.EPDIS
#define EPROT_RNV4                      _EPROT.Bits.RNV4
#define EPROT_RNV5                      _EPROT.Bits.RNV5
#define EPROT_RNV6                      _EPROT.Bits.RNV6
#define EPROT_EPOPEN                    _EPROT.Bits.EPOPEN
#define EPROT_EPS                       _EPROT.MergedBits.grpEPS
#define EPROT_RNV_4                     _EPROT.MergedBits.grpRNV_4
#define EPROT_RNV                       EPROT_RNV_4

#define EPROT_EPS0_MASK                 1U
#define EPROT_EPS1_MASK                 2U
#define EPROT_EPS2_MASK                 4U
#define EPROT_EPDIS_MASK                8U
#define EPROT_RNV4_MASK                 16U
#define EPROT_RNV5_MASK                 32U
#define EPROT_RNV6_MASK                 64U
#define EPROT_EPOPEN_MASK               128U
#define EPROT_EPS_MASK                  7U
#define EPROT_EPS_BITNUM                0U
#define EPROT_RNV_4_MASK                112U
#define EPROT_RNV_4_BITNUM              4U


/*** ESTAT - EEPROM Status Register; 0x00000115 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte FAIL        :1;                                       /* Failed EEPROM Operation Flag (Special mode only) */
    byte BLANK       :1;                                       /* Blank Verify Flag */
    byte             :1; 
    byte ACCERR      :1;                                       /* Access error */
    byte PVIOL       :1;                                       /* Protection violation */
    byte CCIF        :1;                                       /* Command Complete Interrupt Flag */
    byte CBEIF       :1;                                       /* Command Buffer Empty Interrupt Flag */
  } Bits;
} ESTATSTR;
extern volatile ESTATSTR _ESTAT @(REG_BASE + 0x00000115UL);
#define ESTAT                           _ESTAT.Byte
#define ESTAT_FAIL                      _ESTAT.Bits.FAIL
#define ESTAT_BLANK                     _ESTAT.Bits.BLANK
#define ESTAT_ACCERR                    _ESTAT.Bits.ACCERR
#define ESTAT_PVIOL                     _ESTAT.Bits.PVIOL
#define ESTAT_CCIF                      _ESTAT.Bits.CCIF
#define ESTAT_CBEIF                     _ESTAT.Bits.CBEIF

#define ESTAT_FAIL_MASK                 2U
#define ESTAT_BLANK_MASK                4U
#define ESTAT_ACCERR_MASK               16U
#define ESTAT_PVIOL_MASK                32U
#define ESTAT_CCIF_MASK                 64U
#define ESTAT_CBEIF_MASK                128U


/*** ECMD - EEPROM Command Buffer and Register; 0x00000116 ***/
typedef union {
  byte Byte;
  struct {
    byte CMDB        :7;                                       /* EEPROM command */
    byte             :1; 
  } Bits;
} ECMDSTR;
extern volatile ECMDSTR _ECMD @(REG_BASE + 0x00000116UL);
#define ECMD                            _ECMD.Byte
#define ECMD_CMDB                       _ECMD.Bits.CMDB

#define ECMD_CMDB_MASK                  127U
#define ECMD_CMDB_BITNUM                0U


/*** EADDR - EEPROM Address Register; 0x00000118 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** EADDRHI - EEPROM Address High Register; 0x00000118 ***/
    union {
      byte Byte;
      struct {
        byte EABHI       :3;                                       /* EEPROM Address High Bits */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } EADDRHISTR;
    #define EADDRHI                     _EADDR.Overlap_STR.EADDRHISTR.Byte
    #define EADDRHI_EABHI               _EADDR.Overlap_STR.EADDRHISTR.Bits.EABHI
    
    #define EADDRHI_EABHI_MASK          7U
    #define EADDRHI_EABHI_BITNUM        0U
    

    /*** EADDRLO - EEPROM Address Low Register; 0x00000119 ***/
    union {
      byte Byte;
      struct {
        byte EABLO       :8;                                       /* EEPROM Address Low Bits */
      } Bits;
    } EADDRLOSTR;
    #define EADDRLO                     _EADDR.Overlap_STR.EADDRLOSTR.Byte
    #define EADDRLO_EABLO               _EADDR.Overlap_STR.EADDRLOSTR.Bits.EABLO
    
    #define EADDRLO_EABLO_MASK          255U
    #define EADDRLO_EABLO_BITNUM        0U
    
  } Overlap_STR;

  struct {
    word EABLO       :8;                                       /* EEPROM Address Bits */
    word EABHI       :3;                                       /* EEPROM Address Bits */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} EADDRSTR;
extern volatile EADDRSTR _EADDR @(REG_BASE + 0x00000118UL);
#define EADDR                           _EADDR.Word
#define EADDR_EABLO                     _EADDR.Bits.EABLO
#define EADDR_EABHI                     _EADDR.Bits.EABHI

#define EADDR_EABLO_MASK                255U
#define EADDR_EABLO_BITNUM              0U
#define EADDR_EABHI_MASK                1792U
#define EADDR_EABHI_BITNUM              8U


/*** EDATA - EEPROM Data Register; 0x0000011A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** EDATAHI - EEPROM Data High Register; 0x0000011A ***/
    union {
      byte Byte;
      struct {
        byte EDHI        :8;                                       /* EEPROM Data High Bits */
      } Bits;
    } EDATAHISTR;
    #define EDATAHI                     _EDATA.Overlap_STR.EDATAHISTR.Byte
    #define EDATAHI_EDHI                _EDATA.Overlap_STR.EDATAHISTR.Bits.EDHI
    
    #define EDATAHI_EDHI_MASK           255U
    #define EDATAHI_EDHI_BITNUM         0U
    

    /*** EDATALO - EEPROM Data Low Register; 0x0000011B ***/
    union {
      byte Byte;
      struct {
        byte EDLO        :8;                                       /* EEPROM Data Low Bits */
      } Bits;
    } EDATALOSTR;
    #define EDATALO                     _EDATA.Overlap_STR.EDATALOSTR.Byte
    #define EDATALO_EDLO                _EDATA.Overlap_STR.EDATALOSTR.Bits.EDLO
    
    #define EDATALO_EDLO_MASK           255U
    #define EDATALO_EDLO_BITNUM         0U
    
  } Overlap_STR;

  struct {
    word EDLO        :8;                                       /* EEPROM Data Bits */
    word EDHI        :8;                                       /* EEPROM Data Bits */
  } Bits;
} EDATASTR;
extern volatile EDATASTR _EDATA @(REG_BASE + 0x0000011AUL);
#define EDATA                           _EDATA.Word
#define EDATA_EDLO                      _EDATA.Bits.EDLO
#define EDATA_EDHI                      _EDATA.Bits.EDHI

#define EDATA_EDLO_MASK                 255U
#define EDATA_EDLO_BITNUM               0U
#define EDATA_EDHI_MASK                 65280U
#define EDATA_EDHI_BITNUM               8U


/*** RAMWPC - RAM Write Protection Control Register; 0x0000011C ***/
typedef union {
  byte Byte;
  struct {
    byte AVIF        :1;                                       /* S12X_CPU Access Violation Interrupt Flag */
    byte AVIE        :1;                                       /* S12X_CPU Access Violation Interrupt Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RWPE        :1;                                       /* RAM Write Protection Enable */
  } Bits;
} RAMWPCSTR;
extern volatile RAMWPCSTR _RAMWPC @(REG_BASE + 0x0000011CUL);
#define RAMWPC                          _RAMWPC.Byte
#define RAMWPC_AVIF                     _RAMWPC.Bits.AVIF
#define RAMWPC_AVIE                     _RAMWPC.Bits.AVIE
#define RAMWPC_RWPE                     _RAMWPC.Bits.RWPE

#define RAMWPC_AVIF_MASK                1U
#define RAMWPC_AVIE_MASK                2U
#define RAMWPC_RWPE_MASK                128U


/*** RAMXGU - RAM XGATE Upper Boundary Register; 0x0000011D ***/
typedef union {
  byte Byte;
  struct {
    byte XGU0        :1;                                       /* XGATE Region Upper Boundary Bit 0 */
    byte XGU1        :1;                                       /* XGATE Region Upper Boundary Bit 1 */
    byte XGU2        :1;                                       /* XGATE Region Upper Boundary Bit 2 */
    byte XGU3        :1;                                       /* XGATE Region Upper Boundary Bit 3 */
    byte XGU4        :1;                                       /* XGATE Region Upper Boundary Bit 4 */
    byte XGU5        :1;                                       /* XGATE Region Upper Boundary Bit 5 */
    byte XGU6        :1;                                       /* XGATE Region Upper Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpXGU  :7;
    byte         :1;
  } MergedBits;
} RAMXGUSTR;
extern volatile RAMXGUSTR _RAMXGU @(REG_BASE + 0x0000011DUL);
#define RAMXGU                          _RAMXGU.Byte
#define RAMXGU_XGU0                     _RAMXGU.Bits.XGU0
#define RAMXGU_XGU1                     _RAMXGU.Bits.XGU1
#define RAMXGU_XGU2                     _RAMXGU.Bits.XGU2
#define RAMXGU_XGU3                     _RAMXGU.Bits.XGU3
#define RAMXGU_XGU4                     _RAMXGU.Bits.XGU4
#define RAMXGU_XGU5                     _RAMXGU.Bits.XGU5
#define RAMXGU_XGU6                     _RAMXGU.Bits.XGU6
#define RAMXGU_XGU                      _RAMXGU.MergedBits.grpXGU

#define RAMXGU_XGU0_MASK                1U
#define RAMXGU_XGU1_MASK                2U
#define RAMXGU_XGU2_MASK                4U
#define RAMXGU_XGU3_MASK                8U
#define RAMXGU_XGU4_MASK                16U
#define RAMXGU_XGU5_MASK                32U
#define RAMXGU_XGU6_MASK                64U
#define RAMXGU_XGU_MASK                 127U
#define RAMXGU_XGU_BITNUM               0U


/*** RAMSHL - RAM Shared Region Lower Boundary Register; 0x0000011E ***/
typedef union {
  byte Byte;
  struct {
    byte SHL0        :1;                                       /* RAM Shared Region Lower Boundary Bit 0 */
    byte SHL1        :1;                                       /* RAM Shared Region Lower Boundary Bit 1 */
    byte SHL2        :1;                                       /* RAM Shared Region Lower Boundary Bit 2 */
    byte SHL3        :1;                                       /* RAM Shared Region Lower Boundary Bit 3 */
    byte SHL4        :1;                                       /* RAM Shared Region Lower Boundary Bit 4 */
    byte SHL5        :1;                                       /* RAM Shared Region Lower Boundary Bit 5 */
    byte SHL6        :1;                                       /* RAM Shared Region Lower Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSHL  :7;
    byte         :1;
  } MergedBits;
} RAMSHLSTR;
extern volatile RAMSHLSTR _RAMSHL @(REG_BASE + 0x0000011EUL);
#define RAMSHL                          _RAMSHL.Byte
#define RAMSHL_SHL0                     _RAMSHL.Bits.SHL0
#define RAMSHL_SHL1                     _RAMSHL.Bits.SHL1
#define RAMSHL_SHL2                     _RAMSHL.Bits.SHL2
#define RAMSHL_SHL3                     _RAMSHL.Bits.SHL3
#define RAMSHL_SHL4                     _RAMSHL.Bits.SHL4
#define RAMSHL_SHL5                     _RAMSHL.Bits.SHL5
#define RAMSHL_SHL6                     _RAMSHL.Bits.SHL6
#define RAMSHL_SHL                      _RAMSHL.MergedBits.grpSHL

#define RAMSHL_SHL0_MASK                1U
#define RAMSHL_SHL1_MASK                2U
#define RAMSHL_SHL2_MASK                4U
#define RAMSHL_SHL3_MASK                8U
#define RAMSHL_SHL4_MASK                16U
#define RAMSHL_SHL5_MASK                32U
#define RAMSHL_SHL6_MASK                64U
#define RAMSHL_SHL_MASK                 127U
#define RAMSHL_SHL_BITNUM               0U


/*** RAMSHU - RAM Shared Region Upper Boundary Register; 0x0000011F ***/
typedef union {
  byte Byte;
  struct {
    byte SHU0        :1;                                       /* RAM Shared Region Upper Boundary Bit 0 */
    byte SHU1        :1;                                       /* RAM Shared Region Upper Boundary Bit 1 */
    byte SHU2        :1;                                       /* RAM Shared Region Upper Boundary Bit 2 */
    byte SHU3        :1;                                       /* RAM Shared Region Upper Boundary Bit 3 */
    byte SHU4        :1;                                       /* RAM Shared Region Upper Boundary Bit 4 */
    byte SHU5        :1;                                       /* RAM Shared Region Upper Boundary Bit 5 */
    byte SHU6        :1;                                       /* RAM Shared Region Upper Boundary Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSHU  :7;
    byte         :1;
  } MergedBits;
} RAMSHUSTR;
extern volatile RAMSHUSTR _RAMSHU @(REG_BASE + 0x0000011FUL);
#define RAMSHU                          _RAMSHU.Byte
#define RAMSHU_SHU0                     _RAMSHU.Bits.SHU0
#define RAMSHU_SHU1                     _RAMSHU.Bits.SHU1
#define RAMSHU_SHU2                     _RAMSHU.Bits.SHU2
#define RAMSHU_SHU3                     _RAMSHU.Bits.SHU3
#define RAMSHU_SHU4                     _RAMSHU.Bits.SHU4
#define RAMSHU_SHU5                     _RAMSHU.Bits.SHU5
#define RAMSHU_SHU6                     _RAMSHU.Bits.SHU6
#define RAMSHU_SHU                      _RAMSHU.MergedBits.grpSHU

#define RAMSHU_SHU0_MASK                1U
#define RAMSHU_SHU1_MASK                2U
#define RAMSHU_SHU2_MASK                4U
#define RAMSHU_SHU3_MASK                8U
#define RAMSHU_SHU4_MASK                16U
#define RAMSHU_SHU5_MASK                32U
#define RAMSHU_SHU6_MASK                64U
#define RAMSHU_SHU_MASK                 127U
#define RAMSHU_SHU_BITNUM               0U


/*** IVBR - Interrupt Vector Base Register; 0x00000121 ***/
typedef union {
  byte Byte;
  struct {
    byte IVB_ADDR    :8;                                       /* Interrupt vector base address bits */
  } Bits;
} IVBRSTR;
extern volatile IVBRSTR _IVBR @(REG_BASE + 0x00000121UL);
#define IVBR                            _IVBR.Byte
#define IVBR_IVB_ADDR                   _IVBR.Bits.IVB_ADDR

#define IVBR_IVB_ADDR_MASK              255U
#define IVBR_IVB_ADDR_BITNUM            0U


/*** INT_XGPRIO - XGATE Interrupt Priority Configuration Register; 0x00000126 ***/
typedef union {
  byte Byte;
  struct {
    byte XILVL       :3;                                       /* XGATE Interrupt Priority Level */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} INT_XGPRIOSTR;
extern volatile INT_XGPRIOSTR _INT_XGPRIO @(REG_BASE + 0x00000126UL);
#define INT_XGPRIO                      _INT_XGPRIO.Byte
#define INT_XGPRIO_XILVL                _INT_XGPRIO.Bits.XILVL

#define INT_XGPRIO_XILVL_MASK           7U
#define INT_XGPRIO_XILVL_BITNUM         0U


/*** INT_CFADDR - Interrupt Configuration Address Register; 0x00000127 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte INT_CFADDR_grp :4;                                    /* Interrupt Request Configuration Data Register select bits */ /*Warning: group name is duplicated with register name*/
  } Bits;
} INT_CFADDRSTR;
extern volatile INT_CFADDRSTR _INT_CFADDR @(REG_BASE + 0x00000127UL);
#define INT_CFADDR                      _INT_CFADDR.Byte
#define INT_CFADDR_INT_CFADDR           _INT_CFADDR.Bits.INT_CFADDR_grp

#define INT_CFADDR_INT_CFADDR_MASK      240U
#define INT_CFADDR_INT_CFADDR_BITNUM    4U


/*** INT_CFDATA0 - Interrupt Configuration Data Register 0; 0x00000128 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA0STR;
extern volatile INT_CFDATA0STR _INT_CFDATA0 @(REG_BASE + 0x00000128UL);
#define INT_CFDATA0                     _INT_CFDATA0.Byte
#define INT_CFDATA0_PRIOLVL             _INT_CFDATA0.Bits.PRIOLVL
#define INT_CFDATA0_RQST                _INT_CFDATA0.Bits.RQST
/* INT_CFDATA_ARR: Access 8 INT_CFDATAx registers in an array */
#define INT_CFDATA_ARR                  ((volatile byte *) &INT_CFDATA0)

#define INT_CFDATA0_PRIOLVL_MASK        7U
#define INT_CFDATA0_PRIOLVL_BITNUM      0U
#define INT_CFDATA0_RQST_MASK           128U


/*** INT_CFDATA1 - Interrupt Configuration Data Register 1; 0x00000129 ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA1STR;
extern volatile INT_CFDATA1STR _INT_CFDATA1 @(REG_BASE + 0x00000129UL);
#define INT_CFDATA1                     _INT_CFDATA1.Byte
#define INT_CFDATA1_PRIOLVL             _INT_CFDATA1.Bits.PRIOLVL
#define INT_CFDATA1_RQST                _INT_CFDATA1.Bits.RQST

#define INT_CFDATA1_PRIOLVL_MASK        7U
#define INT_CFDATA1_PRIOLVL_BITNUM      0U
#define INT_CFDATA1_RQST_MASK           128U


/*** INT_CFDATA2 - Interrupt Configuration Data Register 2; 0x0000012A ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA2STR;
extern volatile INT_CFDATA2STR _INT_CFDATA2 @(REG_BASE + 0x0000012AUL);
#define INT_CFDATA2                     _INT_CFDATA2.Byte
#define INT_CFDATA2_PRIOLVL             _INT_CFDATA2.Bits.PRIOLVL
#define INT_CFDATA2_RQST                _INT_CFDATA2.Bits.RQST

#define INT_CFDATA2_PRIOLVL_MASK        7U
#define INT_CFDATA2_PRIOLVL_BITNUM      0U
#define INT_CFDATA2_RQST_MASK           128U


/*** INT_CFDATA3 - Interrupt Configuration Data Register 3; 0x0000012B ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA3STR;
extern volatile INT_CFDATA3STR _INT_CFDATA3 @(REG_BASE + 0x0000012BUL);
#define INT_CFDATA3                     _INT_CFDATA3.Byte
#define INT_CFDATA3_PRIOLVL             _INT_CFDATA3.Bits.PRIOLVL
#define INT_CFDATA3_RQST                _INT_CFDATA3.Bits.RQST

#define INT_CFDATA3_PRIOLVL_MASK        7U
#define INT_CFDATA3_PRIOLVL_BITNUM      0U
#define INT_CFDATA3_RQST_MASK           128U


/*** INT_CFDATA4 - Interrupt Configuration Data Register 4; 0x0000012C ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA4STR;
extern volatile INT_CFDATA4STR _INT_CFDATA4 @(REG_BASE + 0x0000012CUL);
#define INT_CFDATA4                     _INT_CFDATA4.Byte
#define INT_CFDATA4_PRIOLVL             _INT_CFDATA4.Bits.PRIOLVL
#define INT_CFDATA4_RQST                _INT_CFDATA4.Bits.RQST

#define INT_CFDATA4_PRIOLVL_MASK        7U
#define INT_CFDATA4_PRIOLVL_BITNUM      0U
#define INT_CFDATA4_RQST_MASK           128U


/*** INT_CFDATA5 - Interrupt Configuration Data Register 5; 0x0000012D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA5STR;
extern volatile INT_CFDATA5STR _INT_CFDATA5 @(REG_BASE + 0x0000012DUL);
#define INT_CFDATA5                     _INT_CFDATA5.Byte
#define INT_CFDATA5_PRIOLVL             _INT_CFDATA5.Bits.PRIOLVL
#define INT_CFDATA5_RQST                _INT_CFDATA5.Bits.RQST

#define INT_CFDATA5_PRIOLVL_MASK        7U
#define INT_CFDATA5_PRIOLVL_BITNUM      0U
#define INT_CFDATA5_RQST_MASK           128U


/*** INT_CFDATA6 - Interrupt Configuration Data Register 6; 0x0000012E ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA6STR;
extern volatile INT_CFDATA6STR _INT_CFDATA6 @(REG_BASE + 0x0000012EUL);
#define INT_CFDATA6                     _INT_CFDATA6.Byte
#define INT_CFDATA6_PRIOLVL             _INT_CFDATA6.Bits.PRIOLVL
#define INT_CFDATA6_RQST                _INT_CFDATA6.Bits.RQST

#define INT_CFDATA6_PRIOLVL_MASK        7U
#define INT_CFDATA6_PRIOLVL_BITNUM      0U
#define INT_CFDATA6_RQST_MASK           128U


/*** INT_CFDATA7 - Interrupt Configuration Data Register 7; 0x0000012F ***/
typedef union {
  byte Byte;
  struct {
    byte PRIOLVL     :3;                                       /* Interrupt Request Priority Level Bits */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RQST        :1;                                       /* XGATE Request Enable */
  } Bits;
} INT_CFDATA7STR;
extern volatile INT_CFDATA7STR _INT_CFDATA7 @(REG_BASE + 0x0000012FUL);
#define INT_CFDATA7                     _INT_CFDATA7.Byte
#define INT_CFDATA7_PRIOLVL             _INT_CFDATA7.Bits.PRIOLVL
#define INT_CFDATA7_RQST                _INT_CFDATA7.Bits.RQST

#define INT_CFDATA7_PRIOLVL_MASK        7U
#define INT_CFDATA7_PRIOLVL_BITNUM      0U
#define INT_CFDATA7_RQST_MASK           128U


/*** SCI4BD - SCI 4 Baud Rate Register; 0x00000130 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI4ASR1 - SCI 4 Alternative Status Register 1; 0x00000130 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI4ASR1 - SCI 4 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI4ASR1STR;
        #define SCI4ASR1                _SCI4BD.Overlap_STR.SCI4ASR1STR.Byte
        #define SCI4ASR1_BKDIF          _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4ASR1STR.Bits.BKDIF
        #define SCI4ASR1_BERRIF         _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4ASR1STR.Bits.BERRIF
        #define SCI4ASR1_BERRV          _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4ASR1STR.Bits.BERRV
        #define SCI4ASR1_RXEDGIF        _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4ASR1STR.Bits.RXEDGIF
        
        #define SCI4ASR1_BKDIF_MASK     1U
        #define SCI4ASR1_BERRIF_MASK    2U
        #define SCI4ASR1_BERRV_MASK     4U
        #define SCI4ASR1_RXEDGIF_MASK   128U
        
        /*** SCI4BDH - SCI 4 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI4BDHSTR;
        #define SCI4BDH                 _SCI4BD.Overlap_STR.SCI4ASR1STR.Byte
        #define SCI4BDH_SBR8            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR8
        #define SCI4BDH_SBR9            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR9
        #define SCI4BDH_SBR10           _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR10
        #define SCI4BDH_SBR11           _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR11
        #define SCI4BDH_SBR12           _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.SBR12
        #define SCI4BDH_TNP0            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.TNP0
        #define SCI4BDH_TNP1            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.TNP1
        #define SCI4BDH_IREN            _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.Bits.IREN
        #define SCI4BDH_SBR_8           _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.MergedBits.grpSBR_8
        #define SCI4BDH_TNP             _SCI4BD.Overlap_STR.SCI4ASR1STR.SameAddr_STR.SCI4BDHSTR.MergedBits.grpTNP
        #define SCI4BDH_SBR             SCI4BDH_SBR_8
        
        #define SCI4BDH_SBR8_MASK       1U
        #define SCI4BDH_SBR9_MASK       2U
        #define SCI4BDH_SBR10_MASK      4U
        #define SCI4BDH_SBR11_MASK      8U
        #define SCI4BDH_SBR12_MASK      16U
        #define SCI4BDH_TNP0_MASK       32U
        #define SCI4BDH_TNP1_MASK       64U
        #define SCI4BDH_IREN_MASK       128U
        #define SCI4BDH_SBR_8_MASK      31U
        #define SCI4BDH_SBR_8_BITNUM    0U
        #define SCI4BDH_TNP_MASK        96U
        #define SCI4BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI4ASR1STR;
    

    /*** SCI4ACR1 - SCI 4 Alternative Control Register 1; 0x00000131 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI4ACR1 - SCI 4 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI4ACR1STR;
        #define SCI4ACR1                _SCI4BD.Overlap_STR.SCI4ACR1STR.Byte
        #define SCI4ACR1_BKDIE          _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4ACR1STR.Bits.BKDIE
        #define SCI4ACR1_BERRIE         _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4ACR1STR.Bits.BERRIE
        #define SCI4ACR1_RXEDGIE        _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4ACR1STR.Bits.RXEDGIE
        
        #define SCI4ACR1_BKDIE_MASK     1U
        #define SCI4ACR1_BERRIE_MASK    2U
        #define SCI4ACR1_RXEDGIE_MASK   128U
        
        /*** SCI4BDL - SCI 4 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI4BDLSTR;
        #define SCI4BDL                 _SCI4BD.Overlap_STR.SCI4ACR1STR.Byte
        #define SCI4BDL_SBR0            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR0
        #define SCI4BDL_SBR1            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR1
        #define SCI4BDL_SBR2            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR2
        #define SCI4BDL_SBR3            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR3
        #define SCI4BDL_SBR4            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR4
        #define SCI4BDL_SBR5            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR5
        #define SCI4BDL_SBR6            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR6
        #define SCI4BDL_SBR7            _SCI4BD.Overlap_STR.SCI4ACR1STR.SameAddr_STR.SCI4BDLSTR.Bits.SBR7
        
        #define SCI4BDL_SBR0_MASK       1U
        #define SCI4BDL_SBR1_MASK       2U
        #define SCI4BDL_SBR2_MASK       4U
        #define SCI4BDL_SBR3_MASK       8U
        #define SCI4BDL_SBR4_MASK       16U
        #define SCI4BDL_SBR5_MASK       32U
        #define SCI4BDL_SBR6_MASK       64U
        #define SCI4BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI4ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI4BDSTR;
extern volatile SCI4BDSTR _SCI4BD @(REG_BASE + 0x00000130UL);
#define SCI4BD                          _SCI4BD.Word
#define SCI4BD_SBR0                     _SCI4BD.Bits.SBR0
#define SCI4BD_SBR1                     _SCI4BD.Bits.SBR1
#define SCI4BD_SBR2                     _SCI4BD.Bits.SBR2
#define SCI4BD_SBR3                     _SCI4BD.Bits.SBR3
#define SCI4BD_SBR4                     _SCI4BD.Bits.SBR4
#define SCI4BD_SBR5                     _SCI4BD.Bits.SBR5
#define SCI4BD_SBR6                     _SCI4BD.Bits.SBR6
#define SCI4BD_SBR7                     _SCI4BD.Bits.SBR7
#define SCI4BD_SBR8                     _SCI4BD.Bits.SBR8
#define SCI4BD_SBR9                     _SCI4BD.Bits.SBR9
#define SCI4BD_SBR10                    _SCI4BD.Bits.SBR10
#define SCI4BD_SBR11                    _SCI4BD.Bits.SBR11
#define SCI4BD_SBR12                    _SCI4BD.Bits.SBR12
#define SCI4BD_TNP0                     _SCI4BD.Bits.TNP0
#define SCI4BD_TNP1                     _SCI4BD.Bits.TNP1
#define SCI4BD_IREN                     _SCI4BD.Bits.IREN
#define SCI4BD_SBR                      _SCI4BD.MergedBits.grpSBR
#define SCI4BD_TNP                      _SCI4BD.MergedBits.grpTNP

#define SCI4BD_SBR0_MASK                1U
#define SCI4BD_SBR1_MASK                2U
#define SCI4BD_SBR2_MASK                4U
#define SCI4BD_SBR3_MASK                8U
#define SCI4BD_SBR4_MASK                16U
#define SCI4BD_SBR5_MASK                32U
#define SCI4BD_SBR6_MASK                64U
#define SCI4BD_SBR7_MASK                128U
#define SCI4BD_SBR8_MASK                256U
#define SCI4BD_SBR9_MASK                512U
#define SCI4BD_SBR10_MASK               1024U
#define SCI4BD_SBR11_MASK               2048U
#define SCI4BD_SBR12_MASK               4096U
#define SCI4BD_TNP0_MASK                8192U
#define SCI4BD_TNP1_MASK                16384U
#define SCI4BD_IREN_MASK                32768U
#define SCI4BD_SBR_MASK                 8191U
#define SCI4BD_SBR_BITNUM               0U
#define SCI4BD_TNP_MASK                 24576U
#define SCI4BD_TNP_BITNUM               13U


/*** SCI4ACR2 - SCI 4 Alternative Control Register 2; 0x00000132 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI4ACR2 - SCI 4 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode Bit 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode Bit 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI4ACR2STR;
    #define SCI4ACR2                    _SCI4ACR2.Byte
    #define SCI4ACR2_BKDFE              _SCI4ACR2.SameAddr_STR.SCI4ACR2STR.Bits.BKDFE
    #define SCI4ACR2_BERRM0             _SCI4ACR2.SameAddr_STR.SCI4ACR2STR.Bits.BERRM0
    #define SCI4ACR2_BERRM1             _SCI4ACR2.SameAddr_STR.SCI4ACR2STR.Bits.BERRM1
    #define SCI4ACR2_BERRM              _SCI4ACR2.SameAddr_STR.SCI4ACR2STR.MergedBits.grpBERRM
    
    #define SCI4ACR2_BKDFE_MASK         1U
    #define SCI4ACR2_BERRM0_MASK        2U
    #define SCI4ACR2_BERRM1_MASK        4U
    #define SCI4ACR2_BERRM_MASK         6U
    #define SCI4ACR2_BERRM_BITNUM       1U
    
    /*** SCI4CR1 - SCI 4 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI4CR1STR;
    #define SCI4CR1                     _SCI4ACR2.Byte
    #define SCI4CR1_PT                  _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.PT
    #define SCI4CR1_PE                  _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.PE
    #define SCI4CR1_ILT                 _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.ILT
    #define SCI4CR1_WAKE                _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.WAKE
    #define SCI4CR1_M                   _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.M
    #define SCI4CR1_RSRC                _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.RSRC
    #define SCI4CR1_SCISWAI             _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.SCISWAI
    #define SCI4CR1_LOOPS               _SCI4ACR2.SameAddr_STR.SCI4CR1STR.Bits.LOOPS
    
    #define SCI4CR1_PT_MASK             1U
    #define SCI4CR1_PE_MASK             2U
    #define SCI4CR1_ILT_MASK            4U
    #define SCI4CR1_WAKE_MASK           8U
    #define SCI4CR1_M_MASK              16U
    #define SCI4CR1_RSRC_MASK           32U
    #define SCI4CR1_SCISWAI_MASK        64U
    #define SCI4CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI4ACR2STR;
extern volatile SCI4ACR2STR _SCI4ACR2 @(REG_BASE + 0x00000132UL);


/*** SCI4CR2 - SCI 4 Control Register 2; 0x00000133 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI4CR2STR;
extern volatile SCI4CR2STR _SCI4CR2 @(REG_BASE + 0x00000133UL);
#define SCI4CR2                         _SCI4CR2.Byte
#define SCI4CR2_SBK                     _SCI4CR2.Bits.SBK
#define SCI4CR2_RWU                     _SCI4CR2.Bits.RWU
#define SCI4CR2_RE                      _SCI4CR2.Bits.RE
#define SCI4CR2_TE                      _SCI4CR2.Bits.TE
#define SCI4CR2_ILIE                    _SCI4CR2.Bits.ILIE
#define SCI4CR2_RIE                     _SCI4CR2.Bits.RIE
#define SCI4CR2_TCIE                    _SCI4CR2.Bits.TCIE
#define SCI4CR2_TIE                     _SCI4CR2.Bits.TIE_bit

#define SCI4CR2_SBK_MASK                1U
#define SCI4CR2_RWU_MASK                2U
#define SCI4CR2_RE_MASK                 4U
#define SCI4CR2_TE_MASK                 8U
#define SCI4CR2_ILIE_MASK               16U
#define SCI4CR2_RIE_MASK                32U
#define SCI4CR2_TCIE_MASK               64U
#define SCI4CR2_TIE_MASK                128U


/*** SCI4SR1 - SCI 4 Status Register 1; 0x00000134 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI4SR1STR;
extern volatile SCI4SR1STR _SCI4SR1 @(REG_BASE + 0x00000134UL);
#define SCI4SR1                         _SCI4SR1.Byte
#define SCI4SR1_PF                      _SCI4SR1.Bits.PF
#define SCI4SR1_FE                      _SCI4SR1.Bits.FE
#define SCI4SR1_NF                      _SCI4SR1.Bits.NF
#define SCI4SR1_OR                      _SCI4SR1.Bits.OR
#define SCI4SR1_IDLE                    _SCI4SR1.Bits.IDLE
#define SCI4SR1_RDRF                    _SCI4SR1.Bits.RDRF
#define SCI4SR1_TC                      _SCI4SR1.Bits.TC
#define SCI4SR1_TDRE                    _SCI4SR1.Bits.TDRE

#define SCI4SR1_PF_MASK                 1U
#define SCI4SR1_FE_MASK                 2U
#define SCI4SR1_NF_MASK                 4U
#define SCI4SR1_OR_MASK                 8U
#define SCI4SR1_IDLE_MASK               16U
#define SCI4SR1_RDRF_MASK               32U
#define SCI4SR1_TC_MASK                 64U
#define SCI4SR1_TDRE_MASK               128U


/*** SCI4SR2 - SCI 4 Status Register 2; 0x00000135 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI4SR2STR;
extern volatile SCI4SR2STR _SCI4SR2 @(REG_BASE + 0x00000135UL);
#define SCI4SR2                         _SCI4SR2.Byte
#define SCI4SR2_RAF                     _SCI4SR2.Bits.RAF
#define SCI4SR2_TXDIR                   _SCI4SR2.Bits.TXDIR
#define SCI4SR2_BRK13                   _SCI4SR2.Bits.BRK13
#define SCI4SR2_RXPOL                   _SCI4SR2.Bits.RXPOL
#define SCI4SR2_TXPOL                   _SCI4SR2.Bits.TXPOL
#define SCI4SR2_AMAP                    _SCI4SR2.Bits.AMAP

#define SCI4SR2_RAF_MASK                1U
#define SCI4SR2_TXDIR_MASK              2U
#define SCI4SR2_BRK13_MASK              4U
#define SCI4SR2_RXPOL_MASK              8U
#define SCI4SR2_TXPOL_MASK              16U
#define SCI4SR2_AMAP_MASK               128U


/*** SCI4DRH - SCI 4 Data Register High; 0x00000136 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI4DRHSTR;
extern volatile SCI4DRHSTR _SCI4DRH @(REG_BASE + 0x00000136UL);
#define SCI4DRH                         _SCI4DRH.Byte
#define SCI4DRH_T8                      _SCI4DRH.Bits.T8
#define SCI4DRH_R8                      _SCI4DRH.Bits.R8

#define SCI4DRH_T8_MASK                 64U
#define SCI4DRH_R8_MASK                 128U


/*** SCI4DRL - SCI 4 Data Register Low; 0x00000137 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI4DRLSTR;
extern volatile SCI4DRLSTR _SCI4DRL @(REG_BASE + 0x00000137UL);
#define SCI4DRL                         _SCI4DRL.Byte
#define SCI4DRL_R0_T0                   _SCI4DRL.Bits.R0_T0
#define SCI4DRL_R1_T1                   _SCI4DRL.Bits.R1_T1
#define SCI4DRL_R2_T2                   _SCI4DRL.Bits.R2_T2
#define SCI4DRL_R3_T3                   _SCI4DRL.Bits.R3_T3
#define SCI4DRL_R4_T4                   _SCI4DRL.Bits.R4_T4
#define SCI4DRL_R5_T5                   _SCI4DRL.Bits.R5_T5
#define SCI4DRL_R6_T6                   _SCI4DRL.Bits.R6_T6
#define SCI4DRL_R7_T7                   _SCI4DRL.Bits.R7_T7

#define SCI4DRL_R0_T0_MASK              1U
#define SCI4DRL_R1_T1_MASK              2U
#define SCI4DRL_R2_T2_MASK              4U
#define SCI4DRL_R3_T3_MASK              8U
#define SCI4DRL_R4_T4_MASK              16U
#define SCI4DRL_R5_T5_MASK              32U
#define SCI4DRL_R6_T6_MASK              64U
#define SCI4DRL_R7_T7_MASK              128U


/*** SCI5BD - SCI 5 Baud Rate Register; 0x00000138 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI5ASR1 - SCI 5 Alternative Status Register 1; 0x00000138 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI5ASR1 - SCI 5 Alternative Status Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIF       :1;                                       /* Break Detect Interrupt Flag */
            byte BERRIF      :1;                                       /* Bit Error Interrupt Flag */
            byte BERRV       :1;                                       /* Bit Error Value */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIF     :1;                                       /* Receive Input Active Edge Interrupt Flag */
          } Bits;
        } SCI5ASR1STR;
        #define SCI5ASR1                _SCI5BD.Overlap_STR.SCI5ASR1STR.Byte
        #define SCI5ASR1_BKDIF          _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5ASR1STR.Bits.BKDIF
        #define SCI5ASR1_BERRIF         _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5ASR1STR.Bits.BERRIF
        #define SCI5ASR1_BERRV          _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5ASR1STR.Bits.BERRV
        #define SCI5ASR1_RXEDGIF        _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5ASR1STR.Bits.RXEDGIF
        
        #define SCI5ASR1_BKDIF_MASK     1U
        #define SCI5ASR1_BERRIF_MASK    2U
        #define SCI5ASR1_BERRV_MASK     4U
        #define SCI5ASR1_RXEDGIF_MASK   128U
        
        /*** SCI5BDH - SCI 5 Baud Rate Register High; Several registers at the same address ***/
        union {
          struct {
            byte SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
            byte SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
            byte SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
            byte SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
            byte SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
            byte TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
            byte TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
            byte IREN        :1;                                       /* Infrared Enable Bit */
          } Bits;
          struct {
            byte grpSBR_8 :5;
            byte grpTNP :2;
            byte :1;
          } MergedBits;
        } SCI5BDHSTR;
        #define SCI5BDH                 _SCI5BD.Overlap_STR.SCI5ASR1STR.Byte
        #define SCI5BDH_SBR8            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR8
        #define SCI5BDH_SBR9            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR9
        #define SCI5BDH_SBR10           _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR10
        #define SCI5BDH_SBR11           _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR11
        #define SCI5BDH_SBR12           _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.SBR12
        #define SCI5BDH_TNP0            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.TNP0
        #define SCI5BDH_TNP1            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.TNP1
        #define SCI5BDH_IREN            _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.Bits.IREN
        #define SCI5BDH_SBR_8           _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.MergedBits.grpSBR_8
        #define SCI5BDH_TNP             _SCI5BD.Overlap_STR.SCI5ASR1STR.SameAddr_STR.SCI5BDHSTR.MergedBits.grpTNP
        #define SCI5BDH_SBR             SCI5BDH_SBR_8
        
        #define SCI5BDH_SBR8_MASK       1U
        #define SCI5BDH_SBR9_MASK       2U
        #define SCI5BDH_SBR10_MASK      4U
        #define SCI5BDH_SBR11_MASK      8U
        #define SCI5BDH_SBR12_MASK      16U
        #define SCI5BDH_TNP0_MASK       32U
        #define SCI5BDH_TNP1_MASK       64U
        #define SCI5BDH_IREN_MASK       128U
        #define SCI5BDH_SBR_8_MASK      31U
        #define SCI5BDH_SBR_8_BITNUM    0U
        #define SCI5BDH_TNP_MASK        96U
        #define SCI5BDH_TNP_BITNUM      5U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI5ASR1STR;
    

    /*** SCI5ACR1 - SCI 5 Alternative Control Register 1; 0x00000139 ***/
    union {
      byte Byte;
      union { /* Several registers at the same address */
        /*** SCI5ACR1 - SCI 5 Alternative Control Register 1; Several registers at the same address ***/
        union {
          struct {
            byte BKDIE       :1;                                       /* Break Detect Interrupt Enable */
            byte BERRIE      :1;                                       /* Bit Error Interrupt Enable */
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte             :1; 
            byte RXEDGIE     :1;                                       /* Receive Input Active Edge Interrupt Enable */
          } Bits;
        } SCI5ACR1STR;
        #define SCI5ACR1                _SCI5BD.Overlap_STR.SCI5ACR1STR.Byte
        #define SCI5ACR1_BKDIE          _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5ACR1STR.Bits.BKDIE
        #define SCI5ACR1_BERRIE         _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5ACR1STR.Bits.BERRIE
        #define SCI5ACR1_RXEDGIE        _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5ACR1STR.Bits.RXEDGIE
        
        #define SCI5ACR1_BKDIE_MASK     1U
        #define SCI5ACR1_BERRIE_MASK    2U
        #define SCI5ACR1_RXEDGIE_MASK   128U
        
        /*** SCI5BDL - SCI 5 Baud Rate Register Low; Several registers at the same address ***/
        union {
          struct {
            byte SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
            byte SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
            byte SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
            byte SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
            byte SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
            byte SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
            byte SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
            byte SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
          } Bits;
        } SCI5BDLSTR;
        #define SCI5BDL                 _SCI5BD.Overlap_STR.SCI5ACR1STR.Byte
        #define SCI5BDL_SBR0            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR0
        #define SCI5BDL_SBR1            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR1
        #define SCI5BDL_SBR2            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR2
        #define SCI5BDL_SBR3            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR3
        #define SCI5BDL_SBR4            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR4
        #define SCI5BDL_SBR5            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR5
        #define SCI5BDL_SBR6            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR6
        #define SCI5BDL_SBR7            _SCI5BD.Overlap_STR.SCI5ACR1STR.SameAddr_STR.SCI5BDLSTR.Bits.SBR7
        
        #define SCI5BDL_SBR0_MASK       1U
        #define SCI5BDL_SBR1_MASK       2U
        #define SCI5BDL_SBR2_MASK       4U
        #define SCI5BDL_SBR3_MASK       8U
        #define SCI5BDL_SBR4_MASK       16U
        #define SCI5BDL_SBR5_MASK       32U
        #define SCI5BDL_SBR6_MASK       64U
        #define SCI5BDL_SBR7_MASK       128U
        
      } SameAddr_STR; /*Several registers at the same address */
    
    } SCI5ACR1STR;
    
  } Overlap_STR;

  struct {
    word SBR0        :1;                                       /* SCI Baud Rate Bit 0 */
    word SBR1        :1;                                       /* SCI Baud Rate Bit 1 */
    word SBR2        :1;                                       /* SCI Baud Rate Bit 2 */
    word SBR3        :1;                                       /* SCI Baud Rate Bit 3 */
    word SBR4        :1;                                       /* SCI Baud Rate Bit 4 */
    word SBR5        :1;                                       /* SCI Baud Rate Bit 5 */
    word SBR6        :1;                                       /* SCI Baud Rate Bit 6 */
    word SBR7        :1;                                       /* SCI Baud Rate Bit 7 */
    word SBR8        :1;                                       /* SCI Baud Rate Bit 8 */
    word SBR9        :1;                                       /* SCI Baud Rate Bit 9 */
    word SBR10       :1;                                       /* SCI Baud Rate Bit 10 */
    word SBR11       :1;                                       /* SCI Baud Rate Bit 11 */
    word SBR12       :1;                                       /* SCI Baud Rate Bit 12 */
    word TNP0        :1;                                       /* Transmitter Narrow Pulse Bit 0 */
    word TNP1        :1;                                       /* Transmitter Narrow Pulse Bit 1 */
    word IREN        :1;                                       /* Infrared Enable Bit */
  } Bits;
  struct {
    word grpSBR  :13;
    word grpTNP  :2;
    word         :1;
  } MergedBits;
} SCI5BDSTR;
extern volatile SCI5BDSTR _SCI5BD @(REG_BASE + 0x00000138UL);
#define SCI5BD                          _SCI5BD.Word
#define SCI5BD_SBR0                     _SCI5BD.Bits.SBR0
#define SCI5BD_SBR1                     _SCI5BD.Bits.SBR1
#define SCI5BD_SBR2                     _SCI5BD.Bits.SBR2
#define SCI5BD_SBR3                     _SCI5BD.Bits.SBR3
#define SCI5BD_SBR4                     _SCI5BD.Bits.SBR4
#define SCI5BD_SBR5                     _SCI5BD.Bits.SBR5
#define SCI5BD_SBR6                     _SCI5BD.Bits.SBR6
#define SCI5BD_SBR7                     _SCI5BD.Bits.SBR7
#define SCI5BD_SBR8                     _SCI5BD.Bits.SBR8
#define SCI5BD_SBR9                     _SCI5BD.Bits.SBR9
#define SCI5BD_SBR10                    _SCI5BD.Bits.SBR10
#define SCI5BD_SBR11                    _SCI5BD.Bits.SBR11
#define SCI5BD_SBR12                    _SCI5BD.Bits.SBR12
#define SCI5BD_TNP0                     _SCI5BD.Bits.TNP0
#define SCI5BD_TNP1                     _SCI5BD.Bits.TNP1
#define SCI5BD_IREN                     _SCI5BD.Bits.IREN
#define SCI5BD_SBR                      _SCI5BD.MergedBits.grpSBR
#define SCI5BD_TNP                      _SCI5BD.MergedBits.grpTNP

#define SCI5BD_SBR0_MASK                1U
#define SCI5BD_SBR1_MASK                2U
#define SCI5BD_SBR2_MASK                4U
#define SCI5BD_SBR3_MASK                8U
#define SCI5BD_SBR4_MASK                16U
#define SCI5BD_SBR5_MASK                32U
#define SCI5BD_SBR6_MASK                64U
#define SCI5BD_SBR7_MASK                128U
#define SCI5BD_SBR8_MASK                256U
#define SCI5BD_SBR9_MASK                512U
#define SCI5BD_SBR10_MASK               1024U
#define SCI5BD_SBR11_MASK               2048U
#define SCI5BD_SBR12_MASK               4096U
#define SCI5BD_TNP0_MASK                8192U
#define SCI5BD_TNP1_MASK                16384U
#define SCI5BD_IREN_MASK                32768U
#define SCI5BD_SBR_MASK                 8191U
#define SCI5BD_SBR_BITNUM               0U
#define SCI5BD_TNP_MASK                 24576U
#define SCI5BD_TNP_BITNUM               13U


/*** SCI5ACR2 - SCI 5 Alternative Control Register 2; 0x0000013A ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** SCI5ACR2 - SCI 5 Alternative Control Register 2; Several registers at the same address ***/
    union {
      struct {
        byte BKDFE       :1;                                       /* Break Detect Feature Enable */
        byte BERRM0      :1;                                       /* Bit Error Mode Bit 0 */
        byte BERRM1      :1;                                       /* Bit Error Mode Bit 1 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte     :1;
        byte grpBERRM :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI5ACR2STR;
    #define SCI5ACR2                    _SCI5ACR2.Byte
    #define SCI5ACR2_BKDFE              _SCI5ACR2.SameAddr_STR.SCI5ACR2STR.Bits.BKDFE
    #define SCI5ACR2_BERRM0             _SCI5ACR2.SameAddr_STR.SCI5ACR2STR.Bits.BERRM0
    #define SCI5ACR2_BERRM1             _SCI5ACR2.SameAddr_STR.SCI5ACR2STR.Bits.BERRM1
    #define SCI5ACR2_BERRM              _SCI5ACR2.SameAddr_STR.SCI5ACR2STR.MergedBits.grpBERRM
    
    #define SCI5ACR2_BKDFE_MASK         1U
    #define SCI5ACR2_BERRM0_MASK        2U
    #define SCI5ACR2_BERRM1_MASK        4U
    #define SCI5ACR2_BERRM_MASK         6U
    #define SCI5ACR2_BERRM_BITNUM       1U
    
    /*** SCI5CR1 - SCI 5 Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte PT          :1;                                       /* Parity Type Bit */
        byte PE          :1;                                       /* Parity Enable Bit */
        byte ILT         :1;                                       /* Idle Line Type Bit */
        byte WAKE        :1;                                       /* Wakeup Condition Bit */
        byte M           :1;                                       /* Data Format Mode Bit */
        byte RSRC        :1;                                       /* Receiver Source Bit */
        byte SCISWAI     :1;                                       /* SCI Stop in Wait Mode Bit */
        byte LOOPS       :1;                                       /* Loop Select Bit */
      } Bits;
    } SCI5CR1STR;
    #define SCI5CR1                     _SCI5ACR2.Byte
    #define SCI5CR1_PT                  _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.PT
    #define SCI5CR1_PE                  _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.PE
    #define SCI5CR1_ILT                 _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.ILT
    #define SCI5CR1_WAKE                _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.WAKE
    #define SCI5CR1_M                   _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.M
    #define SCI5CR1_RSRC                _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.RSRC
    #define SCI5CR1_SCISWAI             _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.SCISWAI
    #define SCI5CR1_LOOPS               _SCI5ACR2.SameAddr_STR.SCI5CR1STR.Bits.LOOPS
    
    #define SCI5CR1_PT_MASK             1U
    #define SCI5CR1_PE_MASK             2U
    #define SCI5CR1_ILT_MASK            4U
    #define SCI5CR1_WAKE_MASK           8U
    #define SCI5CR1_M_MASK              16U
    #define SCI5CR1_RSRC_MASK           32U
    #define SCI5CR1_SCISWAI_MASK        64U
    #define SCI5CR1_LOOPS_MASK          128U
    
  } SameAddr_STR; /*Several registers at the same address */

} SCI5ACR2STR;
extern volatile SCI5ACR2STR _SCI5ACR2 @(REG_BASE + 0x0000013AUL);


/*** SCI5CR2 - SCI 5 Control Register 2; 0x0000013B ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break Bit */
    byte RWU         :1;                                       /* Receiver Wakeup Bit */
    byte RE          :1;                                       /* Receiver Enable Bit */
    byte TE          :1;                                       /* Transmitter Enable Bit */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable Bit */
    byte RIE         :1;                                       /* Receiver Full Interrupt Enable Bit */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable Bit */
    byte TIE_bit     :1;                                       /* Transmitter Interrupt Enable Bit */ /*Warning: bit name is duplicated with register name*/
  } Bits;
} SCI5CR2STR;
extern volatile SCI5CR2STR _SCI5CR2 @(REG_BASE + 0x0000013BUL);
#define SCI5CR2                         _SCI5CR2.Byte
#define SCI5CR2_SBK                     _SCI5CR2.Bits.SBK
#define SCI5CR2_RWU                     _SCI5CR2.Bits.RWU
#define SCI5CR2_RE                      _SCI5CR2.Bits.RE
#define SCI5CR2_TE                      _SCI5CR2.Bits.TE
#define SCI5CR2_ILIE                    _SCI5CR2.Bits.ILIE
#define SCI5CR2_RIE                     _SCI5CR2.Bits.RIE
#define SCI5CR2_TCIE                    _SCI5CR2.Bits.TCIE
#define SCI5CR2_TIE                     _SCI5CR2.Bits.TIE_bit

#define SCI5CR2_SBK_MASK                1U
#define SCI5CR2_RWU_MASK                2U
#define SCI5CR2_RE_MASK                 4U
#define SCI5CR2_TE_MASK                 8U
#define SCI5CR2_ILIE_MASK               16U
#define SCI5CR2_RIE_MASK                32U
#define SCI5CR2_TCIE_MASK               64U
#define SCI5CR2_TIE_MASK                128U


/*** SCI5SR1 - SCI 5 Status Register 1; 0x0000013C ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmit Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI5SR1STR;
extern volatile SCI5SR1STR _SCI5SR1 @(REG_BASE + 0x0000013CUL);
#define SCI5SR1                         _SCI5SR1.Byte
#define SCI5SR1_PF                      _SCI5SR1.Bits.PF
#define SCI5SR1_FE                      _SCI5SR1.Bits.FE
#define SCI5SR1_NF                      _SCI5SR1.Bits.NF
#define SCI5SR1_OR                      _SCI5SR1.Bits.OR
#define SCI5SR1_IDLE                    _SCI5SR1.Bits.IDLE
#define SCI5SR1_RDRF                    _SCI5SR1.Bits.RDRF
#define SCI5SR1_TC                      _SCI5SR1.Bits.TC
#define SCI5SR1_TDRE                    _SCI5SR1.Bits.TDRE

#define SCI5SR1_PF_MASK                 1U
#define SCI5SR1_FE_MASK                 2U
#define SCI5SR1_NF_MASK                 4U
#define SCI5SR1_OR_MASK                 8U
#define SCI5SR1_IDLE_MASK               16U
#define SCI5SR1_RDRF_MASK               32U
#define SCI5SR1_TC_MASK                 64U
#define SCI5SR1_TDRE_MASK               128U


/*** SCI5SR2 - SCI 5 Status Register 2; 0x0000013D ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte TXDIR       :1;                                       /* Transmitter pin data direction in Single-Wire mode */
    byte BRK13       :1;                                       /* Break Transmit character length */
    byte RXPOL       :1;                                       /* Receive Polarity */
    byte TXPOL       :1;                                       /* Transmit Polarity */
    byte             :1; 
    byte             :1; 
    byte AMAP        :1;                                       /* Alternative Map */
  } Bits;
} SCI5SR2STR;
extern volatile SCI5SR2STR _SCI5SR2 @(REG_BASE + 0x0000013DUL);
#define SCI5SR2                         _SCI5SR2.Byte
#define SCI5SR2_RAF                     _SCI5SR2.Bits.RAF
#define SCI5SR2_TXDIR                   _SCI5SR2.Bits.TXDIR
#define SCI5SR2_BRK13                   _SCI5SR2.Bits.BRK13
#define SCI5SR2_RXPOL                   _SCI5SR2.Bits.RXPOL
#define SCI5SR2_TXPOL                   _SCI5SR2.Bits.TXPOL
#define SCI5SR2_AMAP                    _SCI5SR2.Bits.AMAP

#define SCI5SR2_RAF_MASK                1U
#define SCI5SR2_TXDIR_MASK              2U
#define SCI5SR2_BRK13_MASK              4U
#define SCI5SR2_RXPOL_MASK              8U
#define SCI5SR2_TXPOL_MASK              16U
#define SCI5SR2_AMAP_MASK               128U


/*** SCI5DRH - SCI 5 Data Register High; 0x0000013E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte T8          :1;                                       /* Transmit Bit 8 */
    byte R8          :1;                                       /* Received Bit 8 */
  } Bits;
} SCI5DRHSTR;
extern volatile SCI5DRHSTR _SCI5DRH @(REG_BASE + 0x0000013EUL);
#define SCI5DRH                         _SCI5DRH.Byte
#define SCI5DRH_T8                      _SCI5DRH.Bits.T8
#define SCI5DRH_R8                      _SCI5DRH.Bits.R8

#define SCI5DRH_T8_MASK                 64U
#define SCI5DRH_R8_MASK                 128U


/*** SCI5DRL - SCI 5 Data Register Low; 0x0000013F ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Received bit 0 or Transmit bit 0 */
    byte R1_T1       :1;                                       /* Received bit 1 or Transmit bit 1 */
    byte R2_T2       :1;                                       /* Received bit 2 or Transmit bit 2 */
    byte R3_T3       :1;                                       /* Received bit 3 or Transmit bit 3 */
    byte R4_T4       :1;                                       /* Received bit 4 or Transmit bit 4 */
    byte R5_T5       :1;                                       /* Received bit 5 or Transmit bit 5 */
    byte R6_T6       :1;                                       /* Received bit 6 or Transmit bit 6 */
    byte R7_T7       :1;                                       /* Received bit 7 or Transmit bit 7 */
  } Bits;
} SCI5DRLSTR;
extern volatile SCI5DRLSTR _SCI5DRL @(REG_BASE + 0x0000013FUL);
#define SCI5DRL                         _SCI5DRL.Byte
#define SCI5DRL_R0_T0                   _SCI5DRL.Bits.R0_T0
#define SCI5DRL_R1_T1                   _SCI5DRL.Bits.R1_T1
#define SCI5DRL_R2_T2                   _SCI5DRL.Bits.R2_T2
#define SCI5DRL_R3_T3                   _SCI5DRL.Bits.R3_T3
#define SCI5DRL_R4_T4                   _SCI5DRL.Bits.R4_T4
#define SCI5DRL_R5_T5                   _SCI5DRL.Bits.R5_T5
#define SCI5DRL_R6_T6                   _SCI5DRL.Bits.R6_T6
#define SCI5DRL_R7_T7                   _SCI5DRL.Bits.R7_T7

#define SCI5DRL_R0_T0_MASK              1U
#define SCI5DRL_R1_T1_MASK              2U
#define SCI5DRL_R2_T2_MASK              4U
#define SCI5DRL_R3_T3_MASK              8U
#define SCI5DRL_R4_T4_MASK              16U
#define SCI5DRL_R5_T5_MASK              32U
#define SCI5DRL_R6_T6_MASK              64U
#define SCI5DRL_R7_T7_MASK              128U


/*** CAN0CTL0 - MSCAN 0 Control 0 Register; 0x00000140 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN0CTL0STR;
extern volatile CAN0CTL0STR _CAN0CTL0 @(REG_BASE + 0x00000140UL);
#define CAN0CTL0                        _CAN0CTL0.Byte
#define CAN0CTL0_INITRQ                 _CAN0CTL0.Bits.INITRQ
#define CAN0CTL0_SLPRQ                  _CAN0CTL0.Bits.SLPRQ
#define CAN0CTL0_WUPE                   _CAN0CTL0.Bits.WUPE
#define CAN0CTL0_TIME                   _CAN0CTL0.Bits.TIME
#define CAN0CTL0_SYNCH                  _CAN0CTL0.Bits.SYNCH
#define CAN0CTL0_CSWAI                  _CAN0CTL0.Bits.CSWAI
#define CAN0CTL0_RXACT                  _CAN0CTL0.Bits.RXACT
#define CAN0CTL0_RXFRM                  _CAN0CTL0.Bits.RXFRM
/* CAN0CTL_ARR: Access 2 CAN0CTLx registers in an array */
#define CAN0CTL_ARR                     ((volatile byte *) &CAN0CTL0)

#define CAN0CTL0_INITRQ_MASK            1U
#define CAN0CTL0_SLPRQ_MASK             2U
#define CAN0CTL0_WUPE_MASK              4U
#define CAN0CTL0_TIME_MASK              8U
#define CAN0CTL0_SYNCH_MASK             16U
#define CAN0CTL0_CSWAI_MASK             32U
#define CAN0CTL0_RXACT_MASK             64U
#define CAN0CTL0_RXFRM_MASK             128U


/*** CAN0CTL1 - MSCAN 0 Control 1 Register; 0x00000141 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN 0 Clock Source */
    byte CANE        :1;                                       /* MSCAN 0 Enable */
  } Bits;
} CAN0CTL1STR;
extern volatile CAN0CTL1STR _CAN0CTL1 @(REG_BASE + 0x00000141UL);
#define CAN0CTL1                        _CAN0CTL1.Byte
#define CAN0CTL1_INITAK                 _CAN0CTL1.Bits.INITAK
#define CAN0CTL1_SLPAK                  _CAN0CTL1.Bits.SLPAK
#define CAN0CTL1_WUPM                   _CAN0CTL1.Bits.WUPM
#define CAN0CTL1_BORM                   _CAN0CTL1.Bits.BORM
#define CAN0CTL1_LISTEN                 _CAN0CTL1.Bits.LISTEN
#define CAN0CTL1_LOOPB                  _CAN0CTL1.Bits.LOOPB
#define CAN0CTL1_CLKSRC                 _CAN0CTL1.Bits.CLKSRC
#define CAN0CTL1_CANE                   _CAN0CTL1.Bits.CANE

#define CAN0CTL1_INITAK_MASK            1U
#define CAN0CTL1_SLPAK_MASK             2U
#define CAN0CTL1_WUPM_MASK              4U
#define CAN0CTL1_BORM_MASK              8U
#define CAN0CTL1_LISTEN_MASK            16U
#define CAN0CTL1_LOOPB_MASK             32U
#define CAN0CTL1_CLKSRC_MASK            64U
#define CAN0CTL1_CANE_MASK              128U


/*** CAN0BTR0 - MSCAN 0 Bus Timing Register 0; 0x00000142 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN0BTR0STR;
extern volatile CAN0BTR0STR _CAN0BTR0 @(REG_BASE + 0x00000142UL);
#define CAN0BTR0                        _CAN0BTR0.Byte
#define CAN0BTR0_BRP0                   _CAN0BTR0.Bits.BRP0
#define CAN0BTR0_BRP1                   _CAN0BTR0.Bits.BRP1
#define CAN0BTR0_BRP2                   _CAN0BTR0.Bits.BRP2
#define CAN0BTR0_BRP3                   _CAN0BTR0.Bits.BRP3
#define CAN0BTR0_BRP4                   _CAN0BTR0.Bits.BRP4
#define CAN0BTR0_BRP5                   _CAN0BTR0.Bits.BRP5
#define CAN0BTR0_SJW0                   _CAN0BTR0.Bits.SJW0
#define CAN0BTR0_SJW1                   _CAN0BTR0.Bits.SJW1
/* CAN0BTR_ARR: Access 2 CAN0BTRx registers in an array */
#define CAN0BTR_ARR                     ((volatile byte *) &CAN0BTR0)
#define CAN0BTR0_BRP                    _CAN0BTR0.MergedBits.grpBRP
#define CAN0BTR0_SJW                    _CAN0BTR0.MergedBits.grpSJW

#define CAN0BTR0_BRP0_MASK              1U
#define CAN0BTR0_BRP1_MASK              2U
#define CAN0BTR0_BRP2_MASK              4U
#define CAN0BTR0_BRP3_MASK              8U
#define CAN0BTR0_BRP4_MASK              16U
#define CAN0BTR0_BRP5_MASK              32U
#define CAN0BTR0_SJW0_MASK              64U
#define CAN0BTR0_SJW1_MASK              128U
#define CAN0BTR0_BRP_MASK               63U
#define CAN0BTR0_BRP_BITNUM             0U
#define CAN0BTR0_SJW_MASK               192U
#define CAN0BTR0_SJW_BITNUM             6U


/*** CAN0BTR1 - MSCAN 0 Bus Timing Register 1; 0x00000143 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN0BTR1STR;
extern volatile CAN0BTR1STR _CAN0BTR1 @(REG_BASE + 0x00000143UL);
#define CAN0BTR1                        _CAN0BTR1.Byte
#define CAN0BTR1_TSEG10                 _CAN0BTR1.Bits.TSEG10
#define CAN0BTR1_TSEG11                 _CAN0BTR1.Bits.TSEG11
#define CAN0BTR1_TSEG12                 _CAN0BTR1.Bits.TSEG12
#define CAN0BTR1_TSEG13                 _CAN0BTR1.Bits.TSEG13
#define CAN0BTR1_TSEG20                 _CAN0BTR1.Bits.TSEG20
#define CAN0BTR1_TSEG21                 _CAN0BTR1.Bits.TSEG21
#define CAN0BTR1_TSEG22                 _CAN0BTR1.Bits.TSEG22
#define CAN0BTR1_SAMP                   _CAN0BTR1.Bits.SAMP
#define CAN0BTR1_TSEG_10                _CAN0BTR1.MergedBits.grpTSEG_10
#define CAN0BTR1_TSEG_20                _CAN0BTR1.MergedBits.grpTSEG_20
#define CAN0BTR1_TSEG                   CAN0BTR1_TSEG_10

#define CAN0BTR1_TSEG10_MASK            1U
#define CAN0BTR1_TSEG11_MASK            2U
#define CAN0BTR1_TSEG12_MASK            4U
#define CAN0BTR1_TSEG13_MASK            8U
#define CAN0BTR1_TSEG20_MASK            16U
#define CAN0BTR1_TSEG21_MASK            32U
#define CAN0BTR1_TSEG22_MASK            64U
#define CAN0BTR1_SAMP_MASK              128U
#define CAN0BTR1_TSEG_10_MASK           15U
#define CAN0BTR1_TSEG_10_BITNUM         0U
#define CAN0BTR1_TSEG_20_MASK           112U
#define CAN0BTR1_TSEG_20_BITNUM         4U


/*** CAN0RFLG - MSCAN 0 Receiver Flag Register; 0x00000144 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RFLGSTR;
extern volatile CAN0RFLGSTR _CAN0RFLG @(REG_BASE + 0x00000144UL);
#define CAN0RFLG                        _CAN0RFLG.Byte
#define CAN0RFLG_RXF                    _CAN0RFLG.Bits.RXF
#define CAN0RFLG_OVRIF                  _CAN0RFLG.Bits.OVRIF
#define CAN0RFLG_TSTAT0                 _CAN0RFLG.Bits.TSTAT0
#define CAN0RFLG_TSTAT1                 _CAN0RFLG.Bits.TSTAT1
#define CAN0RFLG_RSTAT0                 _CAN0RFLG.Bits.RSTAT0
#define CAN0RFLG_RSTAT1                 _CAN0RFLG.Bits.RSTAT1
#define CAN0RFLG_CSCIF                  _CAN0RFLG.Bits.CSCIF
#define CAN0RFLG_WUPIF                  _CAN0RFLG.Bits.WUPIF
#define CAN0RFLG_TSTAT                  _CAN0RFLG.MergedBits.grpTSTAT
#define CAN0RFLG_RSTAT                  _CAN0RFLG.MergedBits.grpRSTAT

#define CAN0RFLG_RXF_MASK               1U
#define CAN0RFLG_OVRIF_MASK             2U
#define CAN0RFLG_TSTAT0_MASK            4U
#define CAN0RFLG_TSTAT1_MASK            8U
#define CAN0RFLG_RSTAT0_MASK            16U
#define CAN0RFLG_RSTAT1_MASK            32U
#define CAN0RFLG_CSCIF_MASK             64U
#define CAN0RFLG_WUPIF_MASK             128U
#define CAN0RFLG_TSTAT_MASK             12U
#define CAN0RFLG_TSTAT_BITNUM           2U
#define CAN0RFLG_RSTAT_MASK             48U
#define CAN0RFLG_RSTAT_BITNUM           4U


/*** CAN0RIER - MSCAN 0 Receiver Interrupt Enable Register; 0x00000145 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RIERSTR;
extern volatile CAN0RIERSTR _CAN0RIER @(REG_BASE + 0x00000145UL);
#define CAN0RIER                        _CAN0RIER.Byte
#define CAN0RIER_RXFIE                  _CAN0RIER.Bits.RXFIE
#define CAN0RIER_OVRIE                  _CAN0RIER.Bits.OVRIE
#define CAN0RIER_TSTATE0                _CAN0RIER.Bits.TSTATE0
#define CAN0RIER_TSTATE1                _CAN0RIER.Bits.TSTATE1
#define CAN0RIER_RSTATE0                _CAN0RIER.Bits.RSTATE0
#define CAN0RIER_RSTATE1                _CAN0RIER.Bits.RSTATE1
#define CAN0RIER_CSCIE                  _CAN0RIER.Bits.CSCIE
#define CAN0RIER_WUPIE                  _CAN0RIER.Bits.WUPIE
#define CAN0RIER_TSTATE                 _CAN0RIER.MergedBits.grpTSTATE
#define CAN0RIER_RSTATE                 _CAN0RIER.MergedBits.grpRSTATE

#define CAN0RIER_RXFIE_MASK             1U
#define CAN0RIER_OVRIE_MASK             2U
#define CAN0RIER_TSTATE0_MASK           4U
#define CAN0RIER_TSTATE1_MASK           8U
#define CAN0RIER_RSTATE0_MASK           16U
#define CAN0RIER_RSTATE1_MASK           32U
#define CAN0RIER_CSCIE_MASK             64U
#define CAN0RIER_WUPIE_MASK             128U
#define CAN0RIER_TSTATE_MASK            12U
#define CAN0RIER_TSTATE_BITNUM          2U
#define CAN0RIER_RSTATE_MASK            48U
#define CAN0RIER_RSTATE_BITNUM          4U


/*** CAN0TFLG - MSCAN 0 Transmitter Flag Register; 0x00000146 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TFLGSTR;
extern volatile CAN0TFLGSTR _CAN0TFLG @(REG_BASE + 0x00000146UL);
#define CAN0TFLG                        _CAN0TFLG.Byte
#define CAN0TFLG_TXE0                   _CAN0TFLG.Bits.TXE0
#define CAN0TFLG_TXE1                   _CAN0TFLG.Bits.TXE1
#define CAN0TFLG_TXE2                   _CAN0TFLG.Bits.TXE2
#define CAN0TFLG_TXE                    _CAN0TFLG.MergedBits.grpTXE

#define CAN0TFLG_TXE0_MASK              1U
#define CAN0TFLG_TXE1_MASK              2U
#define CAN0TFLG_TXE2_MASK              4U
#define CAN0TFLG_TXE_MASK               7U
#define CAN0TFLG_TXE_BITNUM             0U


/*** CAN0TIER - MSCAN 0 Transmitter Interrupt Enable Register; 0x00000147 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TIERSTR;
extern volatile CAN0TIERSTR _CAN0TIER @(REG_BASE + 0x00000147UL);
#define CAN0TIER                        _CAN0TIER.Byte
#define CAN0TIER_TXEIE0                 _CAN0TIER.Bits.TXEIE0
#define CAN0TIER_TXEIE1                 _CAN0TIER.Bits.TXEIE1
#define CAN0TIER_TXEIE2                 _CAN0TIER.Bits.TXEIE2
#define CAN0TIER_TXEIE                  _CAN0TIER.MergedBits.grpTXEIE

#define CAN0TIER_TXEIE0_MASK            1U
#define CAN0TIER_TXEIE1_MASK            2U
#define CAN0TIER_TXEIE2_MASK            4U
#define CAN0TIER_TXEIE_MASK             7U
#define CAN0TIER_TXEIE_BITNUM           0U


/*** CAN0TARQ - MSCAN 0 Transmitter Message Abort Request; 0x00000148 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TARQSTR;
extern volatile CAN0TARQSTR _CAN0TARQ @(REG_BASE + 0x00000148UL);
#define CAN0TARQ                        _CAN0TARQ.Byte
#define CAN0TARQ_ABTRQ0                 _CAN0TARQ.Bits.ABTRQ0
#define CAN0TARQ_ABTRQ1                 _CAN0TARQ.Bits.ABTRQ1
#define CAN0TARQ_ABTRQ2                 _CAN0TARQ.Bits.ABTRQ2
#define CAN0TARQ_ABTRQ                  _CAN0TARQ.MergedBits.grpABTRQ

#define CAN0TARQ_ABTRQ0_MASK            1U
#define CAN0TARQ_ABTRQ1_MASK            2U
#define CAN0TARQ_ABTRQ2_MASK            4U
#define CAN0TARQ_ABTRQ_MASK             7U
#define CAN0TARQ_ABTRQ_BITNUM           0U


/*** CAN0TAAK - MSCAN 0 Transmitter Message Abort Control; 0x00000149 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TAAKSTR;
extern volatile CAN0TAAKSTR _CAN0TAAK @(REG_BASE + 0x00000149UL);
#define CAN0TAAK                        _CAN0TAAK.Byte
#define CAN0TAAK_ABTAK0                 _CAN0TAAK.Bits.ABTAK0
#define CAN0TAAK_ABTAK1                 _CAN0TAAK.Bits.ABTAK1
#define CAN0TAAK_ABTAK2                 _CAN0TAAK.Bits.ABTAK2
#define CAN0TAAK_ABTAK                  _CAN0TAAK.MergedBits.grpABTAK

#define CAN0TAAK_ABTAK0_MASK            1U
#define CAN0TAAK_ABTAK1_MASK            2U
#define CAN0TAAK_ABTAK2_MASK            4U
#define CAN0TAAK_ABTAK_MASK             7U
#define CAN0TAAK_ABTAK_BITNUM           0U


/*** CAN0TBSEL - MSCAN 0 Transmit Buffer Selection; 0x0000014A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TBSELSTR;
extern volatile CAN0TBSELSTR _CAN0TBSEL @(REG_BASE + 0x0000014AUL);
#define CAN0TBSEL                       _CAN0TBSEL.Byte
#define CAN0TBSEL_TX0                   _CAN0TBSEL.Bits.TX0
#define CAN0TBSEL_TX1                   _CAN0TBSEL.Bits.TX1
#define CAN0TBSEL_TX2                   _CAN0TBSEL.Bits.TX2
#define CAN0TBSEL_TX                    _CAN0TBSEL.MergedBits.grpTX

#define CAN0TBSEL_TX0_MASK              1U
#define CAN0TBSEL_TX1_MASK              2U
#define CAN0TBSEL_TX2_MASK              4U
#define CAN0TBSEL_TX_MASK               7U
#define CAN0TBSEL_TX_BITNUM             0U


/*** CAN0IDAC - MSCAN 0 Identifier Acceptance Control Register; 0x0000014B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0IDACSTR;
extern volatile CAN0IDACSTR _CAN0IDAC @(REG_BASE + 0x0000014BUL);
#define CAN0IDAC                        _CAN0IDAC.Byte
#define CAN0IDAC_IDHIT0                 _CAN0IDAC.Bits.IDHIT0
#define CAN0IDAC_IDHIT1                 _CAN0IDAC.Bits.IDHIT1
#define CAN0IDAC_IDHIT2                 _CAN0IDAC.Bits.IDHIT2
#define CAN0IDAC_IDAM0                  _CAN0IDAC.Bits.IDAM0
#define CAN0IDAC_IDAM1                  _CAN0IDAC.Bits.IDAM1
#define CAN0IDAC_IDHIT                  _CAN0IDAC.MergedBits.grpIDHIT
#define CAN0IDAC_IDAM                   _CAN0IDAC.MergedBits.grpIDAM

#define CAN0IDAC_IDHIT0_MASK            1U
#define CAN0IDAC_IDHIT1_MASK            2U
#define CAN0IDAC_IDHIT2_MASK            4U
#define CAN0IDAC_IDAM0_MASK             16U
#define CAN0IDAC_IDAM1_MASK             32U
#define CAN0IDAC_IDHIT_MASK             7U
#define CAN0IDAC_IDHIT_BITNUM           0U
#define CAN0IDAC_IDAM_MASK              48U
#define CAN0IDAC_IDAM_BITNUM            4U


/*** CAN0MISC - MSCAN 0 Miscellaneous Register; 0x0000014D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-Off state Hold until user request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN0MISCSTR;
extern volatile CAN0MISCSTR _CAN0MISC @(REG_BASE + 0x0000014DUL);
#define CAN0MISC                        _CAN0MISC.Byte
#define CAN0MISC_BOHOLD                 _CAN0MISC.Bits.BOHOLD

#define CAN0MISC_BOHOLD_MASK            1U


/*** CAN0RXERR - MSCAN 0 Receive Error Counter Register; 0x0000014E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0RXERRSTR;
extern volatile CAN0RXERRSTR _CAN0RXERR @(REG_BASE + 0x0000014EUL);
#define CAN0RXERR                       _CAN0RXERR.Byte
#define CAN0RXERR_RXERR0                _CAN0RXERR.Bits.RXERR0
#define CAN0RXERR_RXERR1                _CAN0RXERR.Bits.RXERR1
#define CAN0RXERR_RXERR2                _CAN0RXERR.Bits.RXERR2
#define CAN0RXERR_RXERR3                _CAN0RXERR.Bits.RXERR3
#define CAN0RXERR_RXERR4                _CAN0RXERR.Bits.RXERR4
#define CAN0RXERR_RXERR5                _CAN0RXERR.Bits.RXERR5
#define CAN0RXERR_RXERR6                _CAN0RXERR.Bits.RXERR6
#define CAN0RXERR_RXERR7                _CAN0RXERR.Bits.RXERR7

#define CAN0RXERR_RXERR0_MASK           1U
#define CAN0RXERR_RXERR1_MASK           2U
#define CAN0RXERR_RXERR2_MASK           4U
#define CAN0RXERR_RXERR3_MASK           8U
#define CAN0RXERR_RXERR4_MASK           16U
#define CAN0RXERR_RXERR5_MASK           32U
#define CAN0RXERR_RXERR6_MASK           64U
#define CAN0RXERR_RXERR7_MASK           128U


/*** CAN0TXERR - MSCAN 0 Transmit Error Counter Register; 0x0000014F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN0TXERRSTR;
extern volatile CAN0TXERRSTR _CAN0TXERR @(REG_BASE + 0x0000014FUL);
#define CAN0TXERR                       _CAN0TXERR.Byte
#define CAN0TXERR_TXERR0                _CAN0TXERR.Bits.TXERR0
#define CAN0TXERR_TXERR1                _CAN0TXERR.Bits.TXERR1
#define CAN0TXERR_TXERR2                _CAN0TXERR.Bits.TXERR2
#define CAN0TXERR_TXERR3                _CAN0TXERR.Bits.TXERR3
#define CAN0TXERR_TXERR4                _CAN0TXERR.Bits.TXERR4
#define CAN0TXERR_TXERR5                _CAN0TXERR.Bits.TXERR5
#define CAN0TXERR_TXERR6                _CAN0TXERR.Bits.TXERR6
#define CAN0TXERR_TXERR7                _CAN0TXERR.Bits.TXERR7

#define CAN0TXERR_TXERR0_MASK           1U
#define CAN0TXERR_TXERR1_MASK           2U
#define CAN0TXERR_TXERR2_MASK           4U
#define CAN0TXERR_TXERR3_MASK           8U
#define CAN0TXERR_TXERR4_MASK           16U
#define CAN0TXERR_TXERR5_MASK           32U
#define CAN0TXERR_TXERR6_MASK           64U
#define CAN0TXERR_TXERR7_MASK           128U


/*** CAN0IDAR0 - MSCAN 0 Identifier Acceptance Register 0; 0x00000150 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR0STR;
extern volatile CAN0IDAR0STR _CAN0IDAR0 @(REG_BASE + 0x00000150UL);
#define CAN0IDAR0                       _CAN0IDAR0.Byte
#define CAN0IDAR0_AC0                   _CAN0IDAR0.Bits.AC0
#define CAN0IDAR0_AC1                   _CAN0IDAR0.Bits.AC1
#define CAN0IDAR0_AC2                   _CAN0IDAR0.Bits.AC2
#define CAN0IDAR0_AC3                   _CAN0IDAR0.Bits.AC3
#define CAN0IDAR0_AC4                   _CAN0IDAR0.Bits.AC4
#define CAN0IDAR0_AC5                   _CAN0IDAR0.Bits.AC5
#define CAN0IDAR0_AC6                   _CAN0IDAR0.Bits.AC6
#define CAN0IDAR0_AC7                   _CAN0IDAR0.Bits.AC7
/* CAN0IDAR_ARR: Access 4 CAN0IDARx registers in an array */
#define CAN0IDAR_ARR                    ((volatile byte *) &CAN0IDAR0)

#define CAN0IDAR0_AC0_MASK              1U
#define CAN0IDAR0_AC1_MASK              2U
#define CAN0IDAR0_AC2_MASK              4U
#define CAN0IDAR0_AC3_MASK              8U
#define CAN0IDAR0_AC4_MASK              16U
#define CAN0IDAR0_AC5_MASK              32U
#define CAN0IDAR0_AC6_MASK              64U
#define CAN0IDAR0_AC7_MASK              128U


/*** CAN0IDAR1 - MSCAN 0 Identifier Acceptance Register 1; 0x00000151 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR1STR;
extern volatile CAN0IDAR1STR _CAN0IDAR1 @(REG_BASE + 0x00000151UL);
#define CAN0IDAR1                       _CAN0IDAR1.Byte
#define CAN0IDAR1_AC0                   _CAN0IDAR1.Bits.AC0
#define CAN0IDAR1_AC1                   _CAN0IDAR1.Bits.AC1
#define CAN0IDAR1_AC2                   _CAN0IDAR1.Bits.AC2
#define CAN0IDAR1_AC3                   _CAN0IDAR1.Bits.AC3
#define CAN0IDAR1_AC4                   _CAN0IDAR1.Bits.AC4
#define CAN0IDAR1_AC5                   _CAN0IDAR1.Bits.AC5
#define CAN0IDAR1_AC6                   _CAN0IDAR1.Bits.AC6
#define CAN0IDAR1_AC7                   _CAN0IDAR1.Bits.AC7

#define CAN0IDAR1_AC0_MASK              1U
#define CAN0IDAR1_AC1_MASK              2U
#define CAN0IDAR1_AC2_MASK              4U
#define CAN0IDAR1_AC3_MASK              8U
#define CAN0IDAR1_AC4_MASK              16U
#define CAN0IDAR1_AC5_MASK              32U
#define CAN0IDAR1_AC6_MASK              64U
#define CAN0IDAR1_AC7_MASK              128U


/*** CAN0IDAR2 - MSCAN 0 Identifier Acceptance Register 2; 0x00000152 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR2STR;
extern volatile CAN0IDAR2STR _CAN0IDAR2 @(REG_BASE + 0x00000152UL);
#define CAN0IDAR2                       _CAN0IDAR2.Byte
#define CAN0IDAR2_AC0                   _CAN0IDAR2.Bits.AC0
#define CAN0IDAR2_AC1                   _CAN0IDAR2.Bits.AC1
#define CAN0IDAR2_AC2                   _CAN0IDAR2.Bits.AC2
#define CAN0IDAR2_AC3                   _CAN0IDAR2.Bits.AC3
#define CAN0IDAR2_AC4                   _CAN0IDAR2.Bits.AC4
#define CAN0IDAR2_AC5                   _CAN0IDAR2.Bits.AC5
#define CAN0IDAR2_AC6                   _CAN0IDAR2.Bits.AC6
#define CAN0IDAR2_AC7                   _CAN0IDAR2.Bits.AC7

#define CAN0IDAR2_AC0_MASK              1U
#define CAN0IDAR2_AC1_MASK              2U
#define CAN0IDAR2_AC2_MASK              4U
#define CAN0IDAR2_AC3_MASK              8U
#define CAN0IDAR2_AC4_MASK              16U
#define CAN0IDAR2_AC5_MASK              32U
#define CAN0IDAR2_AC6_MASK              64U
#define CAN0IDAR2_AC7_MASK              128U


/*** CAN0IDAR3 - MSCAN 0 Identifier Acceptance Register 3; 0x00000153 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR3STR;
extern volatile CAN0IDAR3STR _CAN0IDAR3 @(REG_BASE + 0x00000153UL);
#define CAN0IDAR3                       _CAN0IDAR3.Byte
#define CAN0IDAR3_AC0                   _CAN0IDAR3.Bits.AC0
#define CAN0IDAR3_AC1                   _CAN0IDAR3.Bits.AC1
#define CAN0IDAR3_AC2                   _CAN0IDAR3.Bits.AC2
#define CAN0IDAR3_AC3                   _CAN0IDAR3.Bits.AC3
#define CAN0IDAR3_AC4                   _CAN0IDAR3.Bits.AC4
#define CAN0IDAR3_AC5                   _CAN0IDAR3.Bits.AC5
#define CAN0IDAR3_AC6                   _CAN0IDAR3.Bits.AC6
#define CAN0IDAR3_AC7                   _CAN0IDAR3.Bits.AC7

#define CAN0IDAR3_AC0_MASK              1U
#define CAN0IDAR3_AC1_MASK              2U
#define CAN0IDAR3_AC2_MASK              4U
#define CAN0IDAR3_AC3_MASK              8U
#define CAN0IDAR3_AC4_MASK              16U
#define CAN0IDAR3_AC5_MASK              32U
#define CAN0IDAR3_AC6_MASK              64U
#define CAN0IDAR3_AC7_MASK              128U


/*** CAN0IDMR0 - MSCAN 0 Identifier Mask Register 0; 0x00000154 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR0STR;
extern volatile CAN0IDMR0STR _CAN0IDMR0 @(REG_BASE + 0x00000154UL);
#define CAN0IDMR0                       _CAN0IDMR0.Byte
#define CAN0IDMR0_AM0                   _CAN0IDMR0.Bits.AM0
#define CAN0IDMR0_AM1                   _CAN0IDMR0.Bits.AM1
#define CAN0IDMR0_AM2                   _CAN0IDMR0.Bits.AM2
#define CAN0IDMR0_AM3                   _CAN0IDMR0.Bits.AM3
#define CAN0IDMR0_AM4                   _CAN0IDMR0.Bits.AM4
#define CAN0IDMR0_AM5                   _CAN0IDMR0.Bits.AM5
#define CAN0IDMR0_AM6                   _CAN0IDMR0.Bits.AM6
#define CAN0IDMR0_AM7                   _CAN0IDMR0.Bits.AM7
/* CAN0IDMR_ARR: Access 4 CAN0IDMRx registers in an array */
#define CAN0IDMR_ARR                    ((volatile byte *) &CAN0IDMR0)

#define CAN0IDMR0_AM0_MASK              1U
#define CAN0IDMR0_AM1_MASK              2U
#define CAN0IDMR0_AM2_MASK              4U
#define CAN0IDMR0_AM3_MASK              8U
#define CAN0IDMR0_AM4_MASK              16U
#define CAN0IDMR0_AM5_MASK              32U
#define CAN0IDMR0_AM6_MASK              64U
#define CAN0IDMR0_AM7_MASK              128U


/*** CAN0IDMR1 - MSCAN 0 Identifier Mask Register 1; 0x00000155 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR1STR;
extern volatile CAN0IDMR1STR _CAN0IDMR1 @(REG_BASE + 0x00000155UL);
#define CAN0IDMR1                       _CAN0IDMR1.Byte
#define CAN0IDMR1_AM0                   _CAN0IDMR1.Bits.AM0
#define CAN0IDMR1_AM1                   _CAN0IDMR1.Bits.AM1
#define CAN0IDMR1_AM2                   _CAN0IDMR1.Bits.AM2
#define CAN0IDMR1_AM3                   _CAN0IDMR1.Bits.AM3
#define CAN0IDMR1_AM4                   _CAN0IDMR1.Bits.AM4
#define CAN0IDMR1_AM5                   _CAN0IDMR1.Bits.AM5
#define CAN0IDMR1_AM6                   _CAN0IDMR1.Bits.AM6
#define CAN0IDMR1_AM7                   _CAN0IDMR1.Bits.AM7

#define CAN0IDMR1_AM0_MASK              1U
#define CAN0IDMR1_AM1_MASK              2U
#define CAN0IDMR1_AM2_MASK              4U
#define CAN0IDMR1_AM3_MASK              8U
#define CAN0IDMR1_AM4_MASK              16U
#define CAN0IDMR1_AM5_MASK              32U
#define CAN0IDMR1_AM6_MASK              64U
#define CAN0IDMR1_AM7_MASK              128U


/*** CAN0IDMR2 - MSCAN 0 Identifier Mask Register 2; 0x00000156 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR2STR;
extern volatile CAN0IDMR2STR _CAN0IDMR2 @(REG_BASE + 0x00000156UL);
#define CAN0IDMR2                       _CAN0IDMR2.Byte
#define CAN0IDMR2_AM0                   _CAN0IDMR2.Bits.AM0
#define CAN0IDMR2_AM1                   _CAN0IDMR2.Bits.AM1
#define CAN0IDMR2_AM2                   _CAN0IDMR2.Bits.AM2
#define CAN0IDMR2_AM3                   _CAN0IDMR2.Bits.AM3
#define CAN0IDMR2_AM4                   _CAN0IDMR2.Bits.AM4
#define CAN0IDMR2_AM5                   _CAN0IDMR2.Bits.AM5
#define CAN0IDMR2_AM6                   _CAN0IDMR2.Bits.AM6
#define CAN0IDMR2_AM7                   _CAN0IDMR2.Bits.AM7

#define CAN0IDMR2_AM0_MASK              1U
#define CAN0IDMR2_AM1_MASK              2U
#define CAN0IDMR2_AM2_MASK              4U
#define CAN0IDMR2_AM3_MASK              8U
#define CAN0IDMR2_AM4_MASK              16U
#define CAN0IDMR2_AM5_MASK              32U
#define CAN0IDMR2_AM6_MASK              64U
#define CAN0IDMR2_AM7_MASK              128U


/*** CAN0IDMR3 - MSCAN 0 Identifier Mask Register 3; 0x00000157 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR3STR;
extern volatile CAN0IDMR3STR _CAN0IDMR3 @(REG_BASE + 0x00000157UL);
#define CAN0IDMR3                       _CAN0IDMR3.Byte
#define CAN0IDMR3_AM0                   _CAN0IDMR3.Bits.AM0
#define CAN0IDMR3_AM1                   _CAN0IDMR3.Bits.AM1
#define CAN0IDMR3_AM2                   _CAN0IDMR3.Bits.AM2
#define CAN0IDMR3_AM3                   _CAN0IDMR3.Bits.AM3
#define CAN0IDMR3_AM4                   _CAN0IDMR3.Bits.AM4
#define CAN0IDMR3_AM5                   _CAN0IDMR3.Bits.AM5
#define CAN0IDMR3_AM6                   _CAN0IDMR3.Bits.AM6
#define CAN0IDMR3_AM7                   _CAN0IDMR3.Bits.AM7

#define CAN0IDMR3_AM0_MASK              1U
#define CAN0IDMR3_AM1_MASK              2U
#define CAN0IDMR3_AM2_MASK              4U
#define CAN0IDMR3_AM3_MASK              8U
#define CAN0IDMR3_AM4_MASK              16U
#define CAN0IDMR3_AM5_MASK              32U
#define CAN0IDMR3_AM6_MASK              64U
#define CAN0IDMR3_AM7_MASK              128U


/*** CAN0IDAR4 - MSCAN 0 Identifier Acceptance Register 4; 0x00000158 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR4STR;
extern volatile CAN0IDAR4STR _CAN0IDAR4 @(REG_BASE + 0x00000158UL);
#define CAN0IDAR4                       _CAN0IDAR4.Byte
#define CAN0IDAR4_AC0                   _CAN0IDAR4.Bits.AC0
#define CAN0IDAR4_AC1                   _CAN0IDAR4.Bits.AC1
#define CAN0IDAR4_AC2                   _CAN0IDAR4.Bits.AC2
#define CAN0IDAR4_AC3                   _CAN0IDAR4.Bits.AC3
#define CAN0IDAR4_AC4                   _CAN0IDAR4.Bits.AC4
#define CAN0IDAR4_AC5                   _CAN0IDAR4.Bits.AC5
#define CAN0IDAR4_AC6                   _CAN0IDAR4.Bits.AC6
#define CAN0IDAR4_AC7                   _CAN0IDAR4.Bits.AC7

#define CAN0IDAR4_AC0_MASK              1U
#define CAN0IDAR4_AC1_MASK              2U
#define CAN0IDAR4_AC2_MASK              4U
#define CAN0IDAR4_AC3_MASK              8U
#define CAN0IDAR4_AC4_MASK              16U
#define CAN0IDAR4_AC5_MASK              32U
#define CAN0IDAR4_AC6_MASK              64U
#define CAN0IDAR4_AC7_MASK              128U


/*** CAN0IDAR5 - MSCAN 0 Identifier Acceptance Register 5; 0x00000159 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR5STR;
extern volatile CAN0IDAR5STR _CAN0IDAR5 @(REG_BASE + 0x00000159UL);
#define CAN0IDAR5                       _CAN0IDAR5.Byte
#define CAN0IDAR5_AC0                   _CAN0IDAR5.Bits.AC0
#define CAN0IDAR5_AC1                   _CAN0IDAR5.Bits.AC1
#define CAN0IDAR5_AC2                   _CAN0IDAR5.Bits.AC2
#define CAN0IDAR5_AC3                   _CAN0IDAR5.Bits.AC3
#define CAN0IDAR5_AC4                   _CAN0IDAR5.Bits.AC4
#define CAN0IDAR5_AC5                   _CAN0IDAR5.Bits.AC5
#define CAN0IDAR5_AC6                   _CAN0IDAR5.Bits.AC6
#define CAN0IDAR5_AC7                   _CAN0IDAR5.Bits.AC7

#define CAN0IDAR5_AC0_MASK              1U
#define CAN0IDAR5_AC1_MASK              2U
#define CAN0IDAR5_AC2_MASK              4U
#define CAN0IDAR5_AC3_MASK              8U
#define CAN0IDAR5_AC4_MASK              16U
#define CAN0IDAR5_AC5_MASK              32U
#define CAN0IDAR5_AC6_MASK              64U
#define CAN0IDAR5_AC7_MASK              128U


/*** CAN0IDAR6 - MSCAN 0 Identifier Acceptance Register 6; 0x0000015A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR6STR;
extern volatile CAN0IDAR6STR _CAN0IDAR6 @(REG_BASE + 0x0000015AUL);
#define CAN0IDAR6                       _CAN0IDAR6.Byte
#define CAN0IDAR6_AC0                   _CAN0IDAR6.Bits.AC0
#define CAN0IDAR6_AC1                   _CAN0IDAR6.Bits.AC1
#define CAN0IDAR6_AC2                   _CAN0IDAR6.Bits.AC2
#define CAN0IDAR6_AC3                   _CAN0IDAR6.Bits.AC3
#define CAN0IDAR6_AC4                   _CAN0IDAR6.Bits.AC4
#define CAN0IDAR6_AC5                   _CAN0IDAR6.Bits.AC5
#define CAN0IDAR6_AC6                   _CAN0IDAR6.Bits.AC6
#define CAN0IDAR6_AC7                   _CAN0IDAR6.Bits.AC7

#define CAN0IDAR6_AC0_MASK              1U
#define CAN0IDAR6_AC1_MASK              2U
#define CAN0IDAR6_AC2_MASK              4U
#define CAN0IDAR6_AC3_MASK              8U
#define CAN0IDAR6_AC4_MASK              16U
#define CAN0IDAR6_AC5_MASK              32U
#define CAN0IDAR6_AC6_MASK              64U
#define CAN0IDAR6_AC7_MASK              128U


/*** CAN0IDAR7 - MSCAN 0 Identifier Acceptance Register 7; 0x0000015B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN0IDAR7STR;
extern volatile CAN0IDAR7STR _CAN0IDAR7 @(REG_BASE + 0x0000015BUL);
#define CAN0IDAR7                       _CAN0IDAR7.Byte
#define CAN0IDAR7_AC0                   _CAN0IDAR7.Bits.AC0
#define CAN0IDAR7_AC1                   _CAN0IDAR7.Bits.AC1
#define CAN0IDAR7_AC2                   _CAN0IDAR7.Bits.AC2
#define CAN0IDAR7_AC3                   _CAN0IDAR7.Bits.AC3
#define CAN0IDAR7_AC4                   _CAN0IDAR7.Bits.AC4
#define CAN0IDAR7_AC5                   _CAN0IDAR7.Bits.AC5
#define CAN0IDAR7_AC6                   _CAN0IDAR7.Bits.AC6
#define CAN0IDAR7_AC7                   _CAN0IDAR7.Bits.AC7

#define CAN0IDAR7_AC0_MASK              1U
#define CAN0IDAR7_AC1_MASK              2U
#define CAN0IDAR7_AC2_MASK              4U
#define CAN0IDAR7_AC3_MASK              8U
#define CAN0IDAR7_AC4_MASK              16U
#define CAN0IDAR7_AC5_MASK              32U
#define CAN0IDAR7_AC6_MASK              64U
#define CAN0IDAR7_AC7_MASK              128U


/*** CAN0IDMR4 - MSCAN 0 Identifier Mask Register 4; 0x0000015C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR4STR;
extern volatile CAN0IDMR4STR _CAN0IDMR4 @(REG_BASE + 0x0000015CUL);
#define CAN0IDMR4                       _CAN0IDMR4.Byte
#define CAN0IDMR4_AM0                   _CAN0IDMR4.Bits.AM0
#define CAN0IDMR4_AM1                   _CAN0IDMR4.Bits.AM1
#define CAN0IDMR4_AM2                   _CAN0IDMR4.Bits.AM2
#define CAN0IDMR4_AM3                   _CAN0IDMR4.Bits.AM3
#define CAN0IDMR4_AM4                   _CAN0IDMR4.Bits.AM4
#define CAN0IDMR4_AM5                   _CAN0IDMR4.Bits.AM5
#define CAN0IDMR4_AM6                   _CAN0IDMR4.Bits.AM6
#define CAN0IDMR4_AM7                   _CAN0IDMR4.Bits.AM7

#define CAN0IDMR4_AM0_MASK              1U
#define CAN0IDMR4_AM1_MASK              2U
#define CAN0IDMR4_AM2_MASK              4U
#define CAN0IDMR4_AM3_MASK              8U
#define CAN0IDMR4_AM4_MASK              16U
#define CAN0IDMR4_AM5_MASK              32U
#define CAN0IDMR4_AM6_MASK              64U
#define CAN0IDMR4_AM7_MASK              128U


/*** CAN0IDMR5 - MSCAN 0 Identifier Mask Register 5; 0x0000015D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR5STR;
extern volatile CAN0IDMR5STR _CAN0IDMR5 @(REG_BASE + 0x0000015DUL);
#define CAN0IDMR5                       _CAN0IDMR5.Byte
#define CAN0IDMR5_AM0                   _CAN0IDMR5.Bits.AM0
#define CAN0IDMR5_AM1                   _CAN0IDMR5.Bits.AM1
#define CAN0IDMR5_AM2                   _CAN0IDMR5.Bits.AM2
#define CAN0IDMR5_AM3                   _CAN0IDMR5.Bits.AM3
#define CAN0IDMR5_AM4                   _CAN0IDMR5.Bits.AM4
#define CAN0IDMR5_AM5                   _CAN0IDMR5.Bits.AM5
#define CAN0IDMR5_AM6                   _CAN0IDMR5.Bits.AM6
#define CAN0IDMR5_AM7                   _CAN0IDMR5.Bits.AM7

#define CAN0IDMR5_AM0_MASK              1U
#define CAN0IDMR5_AM1_MASK              2U
#define CAN0IDMR5_AM2_MASK              4U
#define CAN0IDMR5_AM3_MASK              8U
#define CAN0IDMR5_AM4_MASK              16U
#define CAN0IDMR5_AM5_MASK              32U
#define CAN0IDMR5_AM6_MASK              64U
#define CAN0IDMR5_AM7_MASK              128U


/*** CAN0IDMR6 - MSCAN 0 Identifier Mask Register 6; 0x0000015E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR6STR;
extern volatile CAN0IDMR6STR _CAN0IDMR6 @(REG_BASE + 0x0000015EUL);
#define CAN0IDMR6                       _CAN0IDMR6.Byte
#define CAN0IDMR6_AM0                   _CAN0IDMR6.Bits.AM0
#define CAN0IDMR6_AM1                   _CAN0IDMR6.Bits.AM1
#define CAN0IDMR6_AM2                   _CAN0IDMR6.Bits.AM2
#define CAN0IDMR6_AM3                   _CAN0IDMR6.Bits.AM3
#define CAN0IDMR6_AM4                   _CAN0IDMR6.Bits.AM4
#define CAN0IDMR6_AM5                   _CAN0IDMR6.Bits.AM5
#define CAN0IDMR6_AM6                   _CAN0IDMR6.Bits.AM6
#define CAN0IDMR6_AM7                   _CAN0IDMR6.Bits.AM7

#define CAN0IDMR6_AM0_MASK              1U
#define CAN0IDMR6_AM1_MASK              2U
#define CAN0IDMR6_AM2_MASK              4U
#define CAN0IDMR6_AM3_MASK              8U
#define CAN0IDMR6_AM4_MASK              16U
#define CAN0IDMR6_AM5_MASK              32U
#define CAN0IDMR6_AM6_MASK              64U
#define CAN0IDMR6_AM7_MASK              128U


/*** CAN0IDMR7 - MSCAN 0 Identifier Mask Register 7; 0x0000015F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN0IDMR7STR;
extern volatile CAN0IDMR7STR _CAN0IDMR7 @(REG_BASE + 0x0000015FUL);
#define CAN0IDMR7                       _CAN0IDMR7.Byte
#define CAN0IDMR7_AM0                   _CAN0IDMR7.Bits.AM0
#define CAN0IDMR7_AM1                   _CAN0IDMR7.Bits.AM1
#define CAN0IDMR7_AM2                   _CAN0IDMR7.Bits.AM2
#define CAN0IDMR7_AM3                   _CAN0IDMR7.Bits.AM3
#define CAN0IDMR7_AM4                   _CAN0IDMR7.Bits.AM4
#define CAN0IDMR7_AM5                   _CAN0IDMR7.Bits.AM5
#define CAN0IDMR7_AM6                   _CAN0IDMR7.Bits.AM6
#define CAN0IDMR7_AM7                   _CAN0IDMR7.Bits.AM7

#define CAN0IDMR7_AM0_MASK              1U
#define CAN0IDMR7_AM1_MASK              2U
#define CAN0IDMR7_AM2_MASK              4U
#define CAN0IDMR7_AM3_MASK              8U
#define CAN0IDMR7_AM4_MASK              16U
#define CAN0IDMR7_AM5_MASK              32U
#define CAN0IDMR7_AM6_MASK              64U
#define CAN0IDMR7_AM7_MASK              128U


/*** CAN0RXIDR0 - MSCAN 0 Receive Identifier Register 0; 0x00000160 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0RXIDR0STR;
extern volatile CAN0RXIDR0STR _CAN0RXIDR0 @(REG_BASE + 0x00000160UL);
#define CAN0RXIDR0                      _CAN0RXIDR0.Byte
#define CAN0RXIDR0_ID21                 _CAN0RXIDR0.Bits.ID21
#define CAN0RXIDR0_ID22                 _CAN0RXIDR0.Bits.ID22
#define CAN0RXIDR0_ID23                 _CAN0RXIDR0.Bits.ID23
#define CAN0RXIDR0_ID24                 _CAN0RXIDR0.Bits.ID24
#define CAN0RXIDR0_ID25                 _CAN0RXIDR0.Bits.ID25
#define CAN0RXIDR0_ID26                 _CAN0RXIDR0.Bits.ID26
#define CAN0RXIDR0_ID27                 _CAN0RXIDR0.Bits.ID27
#define CAN0RXIDR0_ID28                 _CAN0RXIDR0.Bits.ID28
/* CAN0RXIDR_ARR: Access 4 CAN0RXIDRx registers in an array */
#define CAN0RXIDR_ARR                   ((volatile byte *) &CAN0RXIDR0)

#define CAN0RXIDR0_ID21_MASK            1U
#define CAN0RXIDR0_ID22_MASK            2U
#define CAN0RXIDR0_ID23_MASK            4U
#define CAN0RXIDR0_ID24_MASK            8U
#define CAN0RXIDR0_ID25_MASK            16U
#define CAN0RXIDR0_ID26_MASK            32U
#define CAN0RXIDR0_ID27_MASK            64U
#define CAN0RXIDR0_ID28_MASK            128U


/*** CAN0RXIDR1 - MSCAN 0 Receive Identifier Register 1; 0x00000161 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0RXIDR1STR;
extern volatile CAN0RXIDR1STR _CAN0RXIDR1 @(REG_BASE + 0x00000161UL);
#define CAN0RXIDR1                      _CAN0RXIDR1.Byte
#define CAN0RXIDR1_ID15                 _CAN0RXIDR1.Bits.ID15
#define CAN0RXIDR1_ID16                 _CAN0RXIDR1.Bits.ID16
#define CAN0RXIDR1_ID17                 _CAN0RXIDR1.Bits.ID17
#define CAN0RXIDR1_IDE                  _CAN0RXIDR1.Bits.IDE
#define CAN0RXIDR1_SRR                  _CAN0RXIDR1.Bits.SRR
#define CAN0RXIDR1_ID18                 _CAN0RXIDR1.Bits.ID18
#define CAN0RXIDR1_ID19                 _CAN0RXIDR1.Bits.ID19
#define CAN0RXIDR1_ID20                 _CAN0RXIDR1.Bits.ID20
#define CAN0RXIDR1_ID_15                _CAN0RXIDR1.MergedBits.grpID_15
#define CAN0RXIDR1_ID_18                _CAN0RXIDR1.MergedBits.grpID_18
#define CAN0RXIDR1_ID                   CAN0RXIDR1_ID_15

#define CAN0RXIDR1_ID15_MASK            1U
#define CAN0RXIDR1_ID16_MASK            2U
#define CAN0RXIDR1_ID17_MASK            4U
#define CAN0RXIDR1_IDE_MASK             8U
#define CAN0RXIDR1_SRR_MASK             16U
#define CAN0RXIDR1_ID18_MASK            32U
#define CAN0RXIDR1_ID19_MASK            64U
#define CAN0RXIDR1_ID20_MASK            128U
#define CAN0RXIDR1_ID_15_MASK           7U
#define CAN0RXIDR1_ID_15_BITNUM         0U
#define CAN0RXIDR1_ID_18_MASK           224U
#define CAN0RXIDR1_ID_18_BITNUM         5U


/*** CAN0RXIDR2 - MSCAN 0 Receive Identifier Register 2; 0x00000162 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0RXIDR2STR;
extern volatile CAN0RXIDR2STR _CAN0RXIDR2 @(REG_BASE + 0x00000162UL);
#define CAN0RXIDR2                      _CAN0RXIDR2.Byte
#define CAN0RXIDR2_ID7                  _CAN0RXIDR2.Bits.ID7
#define CAN0RXIDR2_ID8                  _CAN0RXIDR2.Bits.ID8
#define CAN0RXIDR2_ID9                  _CAN0RXIDR2.Bits.ID9
#define CAN0RXIDR2_ID10                 _CAN0RXIDR2.Bits.ID10
#define CAN0RXIDR2_ID11                 _CAN0RXIDR2.Bits.ID11
#define CAN0RXIDR2_ID12                 _CAN0RXIDR2.Bits.ID12
#define CAN0RXIDR2_ID13                 _CAN0RXIDR2.Bits.ID13
#define CAN0RXIDR2_ID14                 _CAN0RXIDR2.Bits.ID14

#define CAN0RXIDR2_ID7_MASK             1U
#define CAN0RXIDR2_ID8_MASK             2U
#define CAN0RXIDR2_ID9_MASK             4U
#define CAN0RXIDR2_ID10_MASK            8U
#define CAN0RXIDR2_ID11_MASK            16U
#define CAN0RXIDR2_ID12_MASK            32U
#define CAN0RXIDR2_ID13_MASK            64U
#define CAN0RXIDR2_ID14_MASK            128U


/*** CAN0RXIDR3 - MSCAN 0 Receive Identifier Register 3; 0x00000163 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0RXIDR3STR;
extern volatile CAN0RXIDR3STR _CAN0RXIDR3 @(REG_BASE + 0x00000163UL);
#define CAN0RXIDR3                      _CAN0RXIDR3.Byte
#define CAN0RXIDR3_RTR                  _CAN0RXIDR3.Bits.RTR
#define CAN0RXIDR3_ID0                  _CAN0RXIDR3.Bits.ID0
#define CAN0RXIDR3_ID1                  _CAN0RXIDR3.Bits.ID1
#define CAN0RXIDR3_ID2                  _CAN0RXIDR3.Bits.ID2
#define CAN0RXIDR3_ID3                  _CAN0RXIDR3.Bits.ID3
#define CAN0RXIDR3_ID4                  _CAN0RXIDR3.Bits.ID4
#define CAN0RXIDR3_ID5                  _CAN0RXIDR3.Bits.ID5
#define CAN0RXIDR3_ID6                  _CAN0RXIDR3.Bits.ID6
#define CAN0RXIDR3_ID                   _CAN0RXIDR3.MergedBits.grpID

#define CAN0RXIDR3_RTR_MASK             1U
#define CAN0RXIDR3_ID0_MASK             2U
#define CAN0RXIDR3_ID1_MASK             4U
#define CAN0RXIDR3_ID2_MASK             8U
#define CAN0RXIDR3_ID3_MASK             16U
#define CAN0RXIDR3_ID4_MASK             32U
#define CAN0RXIDR3_ID5_MASK             64U
#define CAN0RXIDR3_ID6_MASK             128U
#define CAN0RXIDR3_ID_MASK              254U
#define CAN0RXIDR3_ID_BITNUM            1U


/*** CAN0RXDSR0 - MSCAN 0 Receive Data Segment Register 0; 0x00000164 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR0STR;
extern volatile CAN0RXDSR0STR _CAN0RXDSR0 @(REG_BASE + 0x00000164UL);
#define CAN0RXDSR0                      _CAN0RXDSR0.Byte
#define CAN0RXDSR0_DB0                  _CAN0RXDSR0.Bits.DB0
#define CAN0RXDSR0_DB1                  _CAN0RXDSR0.Bits.DB1
#define CAN0RXDSR0_DB2                  _CAN0RXDSR0.Bits.DB2
#define CAN0RXDSR0_DB3                  _CAN0RXDSR0.Bits.DB3
#define CAN0RXDSR0_DB4                  _CAN0RXDSR0.Bits.DB4
#define CAN0RXDSR0_DB5                  _CAN0RXDSR0.Bits.DB5
#define CAN0RXDSR0_DB6                  _CAN0RXDSR0.Bits.DB6
#define CAN0RXDSR0_DB7                  _CAN0RXDSR0.Bits.DB7
/* CAN0RXDSR_ARR: Access 8 CAN0RXDSRx registers in an array */
#define CAN0RXDSR_ARR                   ((volatile byte *) &CAN0RXDSR0)

#define CAN0RXDSR0_DB0_MASK             1U
#define CAN0RXDSR0_DB1_MASK             2U
#define CAN0RXDSR0_DB2_MASK             4U
#define CAN0RXDSR0_DB3_MASK             8U
#define CAN0RXDSR0_DB4_MASK             16U
#define CAN0RXDSR0_DB5_MASK             32U
#define CAN0RXDSR0_DB6_MASK             64U
#define CAN0RXDSR0_DB7_MASK             128U


/*** CAN0RXDSR1 - MSCAN 0 Receive Data Segment Register 1; 0x00000165 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR1STR;
extern volatile CAN0RXDSR1STR _CAN0RXDSR1 @(REG_BASE + 0x00000165UL);
#define CAN0RXDSR1                      _CAN0RXDSR1.Byte
#define CAN0RXDSR1_DB0                  _CAN0RXDSR1.Bits.DB0
#define CAN0RXDSR1_DB1                  _CAN0RXDSR1.Bits.DB1
#define CAN0RXDSR1_DB2                  _CAN0RXDSR1.Bits.DB2
#define CAN0RXDSR1_DB3                  _CAN0RXDSR1.Bits.DB3
#define CAN0RXDSR1_DB4                  _CAN0RXDSR1.Bits.DB4
#define CAN0RXDSR1_DB5                  _CAN0RXDSR1.Bits.DB5
#define CAN0RXDSR1_DB6                  _CAN0RXDSR1.Bits.DB6
#define CAN0RXDSR1_DB7                  _CAN0RXDSR1.Bits.DB7

#define CAN0RXDSR1_DB0_MASK             1U
#define CAN0RXDSR1_DB1_MASK             2U
#define CAN0RXDSR1_DB2_MASK             4U
#define CAN0RXDSR1_DB3_MASK             8U
#define CAN0RXDSR1_DB4_MASK             16U
#define CAN0RXDSR1_DB5_MASK             32U
#define CAN0RXDSR1_DB6_MASK             64U
#define CAN0RXDSR1_DB7_MASK             128U


/*** CAN0RXDSR2 - MSCAN 0 Receive Data Segment Register 2; 0x00000166 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR2STR;
extern volatile CAN0RXDSR2STR _CAN0RXDSR2 @(REG_BASE + 0x00000166UL);
#define CAN0RXDSR2                      _CAN0RXDSR2.Byte
#define CAN0RXDSR2_DB0                  _CAN0RXDSR2.Bits.DB0
#define CAN0RXDSR2_DB1                  _CAN0RXDSR2.Bits.DB1
#define CAN0RXDSR2_DB2                  _CAN0RXDSR2.Bits.DB2
#define CAN0RXDSR2_DB3                  _CAN0RXDSR2.Bits.DB3
#define CAN0RXDSR2_DB4                  _CAN0RXDSR2.Bits.DB4
#define CAN0RXDSR2_DB5                  _CAN0RXDSR2.Bits.DB5
#define CAN0RXDSR2_DB6                  _CAN0RXDSR2.Bits.DB6
#define CAN0RXDSR2_DB7                  _CAN0RXDSR2.Bits.DB7

#define CAN0RXDSR2_DB0_MASK             1U
#define CAN0RXDSR2_DB1_MASK             2U
#define CAN0RXDSR2_DB2_MASK             4U
#define CAN0RXDSR2_DB3_MASK             8U
#define CAN0RXDSR2_DB4_MASK             16U
#define CAN0RXDSR2_DB5_MASK             32U
#define CAN0RXDSR2_DB6_MASK             64U
#define CAN0RXDSR2_DB7_MASK             128U


/*** CAN0RXDSR3 - MSCAN 0 Receive Data Segment Register 3; 0x00000167 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR3STR;
extern volatile CAN0RXDSR3STR _CAN0RXDSR3 @(REG_BASE + 0x00000167UL);
#define CAN0RXDSR3                      _CAN0RXDSR3.Byte
#define CAN0RXDSR3_DB0                  _CAN0RXDSR3.Bits.DB0
#define CAN0RXDSR3_DB1                  _CAN0RXDSR3.Bits.DB1
#define CAN0RXDSR3_DB2                  _CAN0RXDSR3.Bits.DB2
#define CAN0RXDSR3_DB3                  _CAN0RXDSR3.Bits.DB3
#define CAN0RXDSR3_DB4                  _CAN0RXDSR3.Bits.DB4
#define CAN0RXDSR3_DB5                  _CAN0RXDSR3.Bits.DB5
#define CAN0RXDSR3_DB6                  _CAN0RXDSR3.Bits.DB6
#define CAN0RXDSR3_DB7                  _CAN0RXDSR3.Bits.DB7

#define CAN0RXDSR3_DB0_MASK             1U
#define CAN0RXDSR3_DB1_MASK             2U
#define CAN0RXDSR3_DB2_MASK             4U
#define CAN0RXDSR3_DB3_MASK             8U
#define CAN0RXDSR3_DB4_MASK             16U
#define CAN0RXDSR3_DB5_MASK             32U
#define CAN0RXDSR3_DB6_MASK             64U
#define CAN0RXDSR3_DB7_MASK             128U


/*** CAN0RXDSR4 - MSCAN 0 Receive Data Segment Register 4; 0x00000168 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR4STR;
extern volatile CAN0RXDSR4STR _CAN0RXDSR4 @(REG_BASE + 0x00000168UL);
#define CAN0RXDSR4                      _CAN0RXDSR4.Byte
#define CAN0RXDSR4_DB0                  _CAN0RXDSR4.Bits.DB0
#define CAN0RXDSR4_DB1                  _CAN0RXDSR4.Bits.DB1
#define CAN0RXDSR4_DB2                  _CAN0RXDSR4.Bits.DB2
#define CAN0RXDSR4_DB3                  _CAN0RXDSR4.Bits.DB3
#define CAN0RXDSR4_DB4                  _CAN0RXDSR4.Bits.DB4
#define CAN0RXDSR4_DB5                  _CAN0RXDSR4.Bits.DB5
#define CAN0RXDSR4_DB6                  _CAN0RXDSR4.Bits.DB6
#define CAN0RXDSR4_DB7                  _CAN0RXDSR4.Bits.DB7

#define CAN0RXDSR4_DB0_MASK             1U
#define CAN0RXDSR4_DB1_MASK             2U
#define CAN0RXDSR4_DB2_MASK             4U
#define CAN0RXDSR4_DB3_MASK             8U
#define CAN0RXDSR4_DB4_MASK             16U
#define CAN0RXDSR4_DB5_MASK             32U
#define CAN0RXDSR4_DB6_MASK             64U
#define CAN0RXDSR4_DB7_MASK             128U


/*** CAN0RXDSR5 - MSCAN 0 Receive Data Segment Register 5; 0x00000169 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR5STR;
extern volatile CAN0RXDSR5STR _CAN0RXDSR5 @(REG_BASE + 0x00000169UL);
#define CAN0RXDSR5                      _CAN0RXDSR5.Byte
#define CAN0RXDSR5_DB0                  _CAN0RXDSR5.Bits.DB0
#define CAN0RXDSR5_DB1                  _CAN0RXDSR5.Bits.DB1
#define CAN0RXDSR5_DB2                  _CAN0RXDSR5.Bits.DB2
#define CAN0RXDSR5_DB3                  _CAN0RXDSR5.Bits.DB3
#define CAN0RXDSR5_DB4                  _CAN0RXDSR5.Bits.DB4
#define CAN0RXDSR5_DB5                  _CAN0RXDSR5.Bits.DB5
#define CAN0RXDSR5_DB6                  _CAN0RXDSR5.Bits.DB6
#define CAN0RXDSR5_DB7                  _CAN0RXDSR5.Bits.DB7

#define CAN0RXDSR5_DB0_MASK             1U
#define CAN0RXDSR5_DB1_MASK             2U
#define CAN0RXDSR5_DB2_MASK             4U
#define CAN0RXDSR5_DB3_MASK             8U
#define CAN0RXDSR5_DB4_MASK             16U
#define CAN0RXDSR5_DB5_MASK             32U
#define CAN0RXDSR5_DB6_MASK             64U
#define CAN0RXDSR5_DB7_MASK             128U


/*** CAN0RXDSR6 - MSCAN 0 Receive Data Segment Register 6; 0x0000016A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR6STR;
extern volatile CAN0RXDSR6STR _CAN0RXDSR6 @(REG_BASE + 0x0000016AUL);
#define CAN0RXDSR6                      _CAN0RXDSR6.Byte
#define CAN0RXDSR6_DB0                  _CAN0RXDSR6.Bits.DB0
#define CAN0RXDSR6_DB1                  _CAN0RXDSR6.Bits.DB1
#define CAN0RXDSR6_DB2                  _CAN0RXDSR6.Bits.DB2
#define CAN0RXDSR6_DB3                  _CAN0RXDSR6.Bits.DB3
#define CAN0RXDSR6_DB4                  _CAN0RXDSR6.Bits.DB4
#define CAN0RXDSR6_DB5                  _CAN0RXDSR6.Bits.DB5
#define CAN0RXDSR6_DB6                  _CAN0RXDSR6.Bits.DB6
#define CAN0RXDSR6_DB7                  _CAN0RXDSR6.Bits.DB7

#define CAN0RXDSR6_DB0_MASK             1U
#define CAN0RXDSR6_DB1_MASK             2U
#define CAN0RXDSR6_DB2_MASK             4U
#define CAN0RXDSR6_DB3_MASK             8U
#define CAN0RXDSR6_DB4_MASK             16U
#define CAN0RXDSR6_DB5_MASK             32U
#define CAN0RXDSR6_DB6_MASK             64U
#define CAN0RXDSR6_DB7_MASK             128U


/*** CAN0RXDSR7 - MSCAN 0 Receive Data Segment Register 7; 0x0000016B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0RXDSR7STR;
extern volatile CAN0RXDSR7STR _CAN0RXDSR7 @(REG_BASE + 0x0000016BUL);
#define CAN0RXDSR7                      _CAN0RXDSR7.Byte
#define CAN0RXDSR7_DB0                  _CAN0RXDSR7.Bits.DB0
#define CAN0RXDSR7_DB1                  _CAN0RXDSR7.Bits.DB1
#define CAN0RXDSR7_DB2                  _CAN0RXDSR7.Bits.DB2
#define CAN0RXDSR7_DB3                  _CAN0RXDSR7.Bits.DB3
#define CAN0RXDSR7_DB4                  _CAN0RXDSR7.Bits.DB4
#define CAN0RXDSR7_DB5                  _CAN0RXDSR7.Bits.DB5
#define CAN0RXDSR7_DB6                  _CAN0RXDSR7.Bits.DB6
#define CAN0RXDSR7_DB7                  _CAN0RXDSR7.Bits.DB7

#define CAN0RXDSR7_DB0_MASK             1U
#define CAN0RXDSR7_DB1_MASK             2U
#define CAN0RXDSR7_DB2_MASK             4U
#define CAN0RXDSR7_DB3_MASK             8U
#define CAN0RXDSR7_DB4_MASK             16U
#define CAN0RXDSR7_DB5_MASK             32U
#define CAN0RXDSR7_DB6_MASK             64U
#define CAN0RXDSR7_DB7_MASK             128U


/*** CAN0RXDLR - MSCAN 0 Receive Data Length Register; 0x0000016C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0RXDLRSTR;
extern volatile CAN0RXDLRSTR _CAN0RXDLR @(REG_BASE + 0x0000016CUL);
#define CAN0RXDLR                       _CAN0RXDLR.Byte
#define CAN0RXDLR_DLC0                  _CAN0RXDLR.Bits.DLC0
#define CAN0RXDLR_DLC1                  _CAN0RXDLR.Bits.DLC1
#define CAN0RXDLR_DLC2                  _CAN0RXDLR.Bits.DLC2
#define CAN0RXDLR_DLC3                  _CAN0RXDLR.Bits.DLC3
#define CAN0RXDLR_DLC                   _CAN0RXDLR.MergedBits.grpDLC

#define CAN0RXDLR_DLC0_MASK             1U
#define CAN0RXDLR_DLC1_MASK             2U
#define CAN0RXDLR_DLC2_MASK             4U
#define CAN0RXDLR_DLC3_MASK             8U
#define CAN0RXDLR_DLC_MASK              15U
#define CAN0RXDLR_DLC_BITNUM            0U


/*** CAN0RXTSR - MSCAN 0 Receive Time Stamp Register; 0x0000016E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0RXTSRH - MSCAN 0 Receive Time Stamp Register High; 0x0000016E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0RXTSRHSTR;
    #define CAN0RXTSRH                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Byte
    #define CAN0RXTSRH_TSR8             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR8
    #define CAN0RXTSRH_TSR9             _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR9
    #define CAN0RXTSRH_TSR10            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR10
    #define CAN0RXTSRH_TSR11            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR11
    #define CAN0RXTSRH_TSR12            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR12
    #define CAN0RXTSRH_TSR13            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR13
    #define CAN0RXTSRH_TSR14            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR14
    #define CAN0RXTSRH_TSR15            _CAN0RXTSR.Overlap_STR.CAN0RXTSRHSTR.Bits.TSR15
    
    #define CAN0RXTSRH_TSR8_MASK        1U
    #define CAN0RXTSRH_TSR9_MASK        2U
    #define CAN0RXTSRH_TSR10_MASK       4U
    #define CAN0RXTSRH_TSR11_MASK       8U
    #define CAN0RXTSRH_TSR12_MASK       16U
    #define CAN0RXTSRH_TSR13_MASK       32U
    #define CAN0RXTSRH_TSR14_MASK       64U
    #define CAN0RXTSRH_TSR15_MASK       128U
    

    /*** CAN0RXTSRL - MSCAN 0 Receive Time Stamp Register Low; 0x0000016F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0RXTSRLSTR;
    #define CAN0RXTSRL                  _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Byte
    #define CAN0RXTSRL_TSR0             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR0
    #define CAN0RXTSRL_TSR1             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR1
    #define CAN0RXTSRL_TSR2             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR2
    #define CAN0RXTSRL_TSR3             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR3
    #define CAN0RXTSRL_TSR4             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR4
    #define CAN0RXTSRL_TSR5             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR5
    #define CAN0RXTSRL_TSR6             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR6
    #define CAN0RXTSRL_TSR7             _CAN0RXTSR.Overlap_STR.CAN0RXTSRLSTR.Bits.TSR7
    
    #define CAN0RXTSRL_TSR0_MASK        1U
    #define CAN0RXTSRL_TSR1_MASK        2U
    #define CAN0RXTSRL_TSR2_MASK        4U
    #define CAN0RXTSRL_TSR3_MASK        8U
    #define CAN0RXTSRL_TSR4_MASK        16U
    #define CAN0RXTSRL_TSR5_MASK        32U
    #define CAN0RXTSRL_TSR6_MASK        64U
    #define CAN0RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0RXTSRSTR;
extern volatile CAN0RXTSRSTR _CAN0RXTSR @(REG_BASE + 0x0000016EUL);
#define CAN0RXTSR                       _CAN0RXTSR.Word
#define CAN0RXTSR_TSR0                  _CAN0RXTSR.Bits.TSR0
#define CAN0RXTSR_TSR1                  _CAN0RXTSR.Bits.TSR1
#define CAN0RXTSR_TSR2                  _CAN0RXTSR.Bits.TSR2
#define CAN0RXTSR_TSR3                  _CAN0RXTSR.Bits.TSR3
#define CAN0RXTSR_TSR4                  _CAN0RXTSR.Bits.TSR4
#define CAN0RXTSR_TSR5                  _CAN0RXTSR.Bits.TSR5
#define CAN0RXTSR_TSR6                  _CAN0RXTSR.Bits.TSR6
#define CAN0RXTSR_TSR7                  _CAN0RXTSR.Bits.TSR7
#define CAN0RXTSR_TSR8                  _CAN0RXTSR.Bits.TSR8
#define CAN0RXTSR_TSR9                  _CAN0RXTSR.Bits.TSR9
#define CAN0RXTSR_TSR10                 _CAN0RXTSR.Bits.TSR10
#define CAN0RXTSR_TSR11                 _CAN0RXTSR.Bits.TSR11
#define CAN0RXTSR_TSR12                 _CAN0RXTSR.Bits.TSR12
#define CAN0RXTSR_TSR13                 _CAN0RXTSR.Bits.TSR13
#define CAN0RXTSR_TSR14                 _CAN0RXTSR.Bits.TSR14
#define CAN0RXTSR_TSR15                 _CAN0RXTSR.Bits.TSR15

#define CAN0RXTSR_TSR0_MASK             1U
#define CAN0RXTSR_TSR1_MASK             2U
#define CAN0RXTSR_TSR2_MASK             4U
#define CAN0RXTSR_TSR3_MASK             8U
#define CAN0RXTSR_TSR4_MASK             16U
#define CAN0RXTSR_TSR5_MASK             32U
#define CAN0RXTSR_TSR6_MASK             64U
#define CAN0RXTSR_TSR7_MASK             128U
#define CAN0RXTSR_TSR8_MASK             256U
#define CAN0RXTSR_TSR9_MASK             512U
#define CAN0RXTSR_TSR10_MASK            1024U
#define CAN0RXTSR_TSR11_MASK            2048U
#define CAN0RXTSR_TSR12_MASK            4096U
#define CAN0RXTSR_TSR13_MASK            8192U
#define CAN0RXTSR_TSR14_MASK            16384U
#define CAN0RXTSR_TSR15_MASK            32768U


/*** CAN0TXIDR0 - MSCAN 0 Transmit Identifier Register 0; 0x00000170 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN0TXIDR0STR;
extern volatile CAN0TXIDR0STR _CAN0TXIDR0 @(REG_BASE + 0x00000170UL);
#define CAN0TXIDR0                      _CAN0TXIDR0.Byte
#define CAN0TXIDR0_ID21                 _CAN0TXIDR0.Bits.ID21
#define CAN0TXIDR0_ID22                 _CAN0TXIDR0.Bits.ID22
#define CAN0TXIDR0_ID23                 _CAN0TXIDR0.Bits.ID23
#define CAN0TXIDR0_ID24                 _CAN0TXIDR0.Bits.ID24
#define CAN0TXIDR0_ID25                 _CAN0TXIDR0.Bits.ID25
#define CAN0TXIDR0_ID26                 _CAN0TXIDR0.Bits.ID26
#define CAN0TXIDR0_ID27                 _CAN0TXIDR0.Bits.ID27
#define CAN0TXIDR0_ID28                 _CAN0TXIDR0.Bits.ID28
/* CAN0TXIDR_ARR: Access 4 CAN0TXIDRx registers in an array */
#define CAN0TXIDR_ARR                   ((volatile byte *) &CAN0TXIDR0)

#define CAN0TXIDR0_ID21_MASK            1U
#define CAN0TXIDR0_ID22_MASK            2U
#define CAN0TXIDR0_ID23_MASK            4U
#define CAN0TXIDR0_ID24_MASK            8U
#define CAN0TXIDR0_ID25_MASK            16U
#define CAN0TXIDR0_ID26_MASK            32U
#define CAN0TXIDR0_ID27_MASK            64U
#define CAN0TXIDR0_ID28_MASK            128U


/*** CAN0TXIDR1 - MSCAN 0 Transmit Identifier Register 1; 0x00000171 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN0TXIDR1STR;
extern volatile CAN0TXIDR1STR _CAN0TXIDR1 @(REG_BASE + 0x00000171UL);
#define CAN0TXIDR1                      _CAN0TXIDR1.Byte
#define CAN0TXIDR1_ID15                 _CAN0TXIDR1.Bits.ID15
#define CAN0TXIDR1_ID16                 _CAN0TXIDR1.Bits.ID16
#define CAN0TXIDR1_ID17                 _CAN0TXIDR1.Bits.ID17
#define CAN0TXIDR1_IDE                  _CAN0TXIDR1.Bits.IDE
#define CAN0TXIDR1_SRR                  _CAN0TXIDR1.Bits.SRR
#define CAN0TXIDR1_ID18                 _CAN0TXIDR1.Bits.ID18
#define CAN0TXIDR1_ID19                 _CAN0TXIDR1.Bits.ID19
#define CAN0TXIDR1_ID20                 _CAN0TXIDR1.Bits.ID20
#define CAN0TXIDR1_ID_15                _CAN0TXIDR1.MergedBits.grpID_15
#define CAN0TXIDR1_ID_18                _CAN0TXIDR1.MergedBits.grpID_18
#define CAN0TXIDR1_ID                   CAN0TXIDR1_ID_15

#define CAN0TXIDR1_ID15_MASK            1U
#define CAN0TXIDR1_ID16_MASK            2U
#define CAN0TXIDR1_ID17_MASK            4U
#define CAN0TXIDR1_IDE_MASK             8U
#define CAN0TXIDR1_SRR_MASK             16U
#define CAN0TXIDR1_ID18_MASK            32U
#define CAN0TXIDR1_ID19_MASK            64U
#define CAN0TXIDR1_ID20_MASK            128U
#define CAN0TXIDR1_ID_15_MASK           7U
#define CAN0TXIDR1_ID_15_BITNUM         0U
#define CAN0TXIDR1_ID_18_MASK           224U
#define CAN0TXIDR1_ID_18_BITNUM         5U


/*** CAN0TXIDR2 - MSCAN 0 Transmit Identifier Register 2; 0x00000172 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN0TXIDR2STR;
extern volatile CAN0TXIDR2STR _CAN0TXIDR2 @(REG_BASE + 0x00000172UL);
#define CAN0TXIDR2                      _CAN0TXIDR2.Byte
#define CAN0TXIDR2_ID7                  _CAN0TXIDR2.Bits.ID7
#define CAN0TXIDR2_ID8                  _CAN0TXIDR2.Bits.ID8
#define CAN0TXIDR2_ID9                  _CAN0TXIDR2.Bits.ID9
#define CAN0TXIDR2_ID10                 _CAN0TXIDR2.Bits.ID10
#define CAN0TXIDR2_ID11                 _CAN0TXIDR2.Bits.ID11
#define CAN0TXIDR2_ID12                 _CAN0TXIDR2.Bits.ID12
#define CAN0TXIDR2_ID13                 _CAN0TXIDR2.Bits.ID13
#define CAN0TXIDR2_ID14                 _CAN0TXIDR2.Bits.ID14

#define CAN0TXIDR2_ID7_MASK             1U
#define CAN0TXIDR2_ID8_MASK             2U
#define CAN0TXIDR2_ID9_MASK             4U
#define CAN0TXIDR2_ID10_MASK            8U
#define CAN0TXIDR2_ID11_MASK            16U
#define CAN0TXIDR2_ID12_MASK            32U
#define CAN0TXIDR2_ID13_MASK            64U
#define CAN0TXIDR2_ID14_MASK            128U


/*** CAN0TXIDR3 - MSCAN 0 Transmit Identifier Register 3; 0x00000173 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN0TXIDR3STR;
extern volatile CAN0TXIDR3STR _CAN0TXIDR3 @(REG_BASE + 0x00000173UL);
#define CAN0TXIDR3                      _CAN0TXIDR3.Byte
#define CAN0TXIDR3_RTR                  _CAN0TXIDR3.Bits.RTR
#define CAN0TXIDR3_ID0                  _CAN0TXIDR3.Bits.ID0
#define CAN0TXIDR3_ID1                  _CAN0TXIDR3.Bits.ID1
#define CAN0TXIDR3_ID2                  _CAN0TXIDR3.Bits.ID2
#define CAN0TXIDR3_ID3                  _CAN0TXIDR3.Bits.ID3
#define CAN0TXIDR3_ID4                  _CAN0TXIDR3.Bits.ID4
#define CAN0TXIDR3_ID5                  _CAN0TXIDR3.Bits.ID5
#define CAN0TXIDR3_ID6                  _CAN0TXIDR3.Bits.ID6
#define CAN0TXIDR3_ID                   _CAN0TXIDR3.MergedBits.grpID

#define CAN0TXIDR3_RTR_MASK             1U
#define CAN0TXIDR3_ID0_MASK             2U
#define CAN0TXIDR3_ID1_MASK             4U
#define CAN0TXIDR3_ID2_MASK             8U
#define CAN0TXIDR3_ID3_MASK             16U
#define CAN0TXIDR3_ID4_MASK             32U
#define CAN0TXIDR3_ID5_MASK             64U
#define CAN0TXIDR3_ID6_MASK             128U
#define CAN0TXIDR3_ID_MASK              254U
#define CAN0TXIDR3_ID_BITNUM            1U


/*** CAN0TXDSR0 - MSCAN 0 Transmit Data Segment Register 0; 0x00000174 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR0STR;
extern volatile CAN0TXDSR0STR _CAN0TXDSR0 @(REG_BASE + 0x00000174UL);
#define CAN0TXDSR0                      _CAN0TXDSR0.Byte
#define CAN0TXDSR0_DB0                  _CAN0TXDSR0.Bits.DB0
#define CAN0TXDSR0_DB1                  _CAN0TXDSR0.Bits.DB1
#define CAN0TXDSR0_DB2                  _CAN0TXDSR0.Bits.DB2
#define CAN0TXDSR0_DB3                  _CAN0TXDSR0.Bits.DB3
#define CAN0TXDSR0_DB4                  _CAN0TXDSR0.Bits.DB4
#define CAN0TXDSR0_DB5                  _CAN0TXDSR0.Bits.DB5
#define CAN0TXDSR0_DB6                  _CAN0TXDSR0.Bits.DB6
#define CAN0TXDSR0_DB7                  _CAN0TXDSR0.Bits.DB7
/* CAN0TXDSR_ARR: Access 8 CAN0TXDSRx registers in an array */
#define CAN0TXDSR_ARR                   ((volatile byte *) &CAN0TXDSR0)

#define CAN0TXDSR0_DB0_MASK             1U
#define CAN0TXDSR0_DB1_MASK             2U
#define CAN0TXDSR0_DB2_MASK             4U
#define CAN0TXDSR0_DB3_MASK             8U
#define CAN0TXDSR0_DB4_MASK             16U
#define CAN0TXDSR0_DB5_MASK             32U
#define CAN0TXDSR0_DB6_MASK             64U
#define CAN0TXDSR0_DB7_MASK             128U


/*** CAN0TXDSR1 - MSCAN 0 Transmit Data Segment Register 1; 0x00000175 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR1STR;
extern volatile CAN0TXDSR1STR _CAN0TXDSR1 @(REG_BASE + 0x00000175UL);
#define CAN0TXDSR1                      _CAN0TXDSR1.Byte
#define CAN0TXDSR1_DB0                  _CAN0TXDSR1.Bits.DB0
#define CAN0TXDSR1_DB1                  _CAN0TXDSR1.Bits.DB1
#define CAN0TXDSR1_DB2                  _CAN0TXDSR1.Bits.DB2
#define CAN0TXDSR1_DB3                  _CAN0TXDSR1.Bits.DB3
#define CAN0TXDSR1_DB4                  _CAN0TXDSR1.Bits.DB4
#define CAN0TXDSR1_DB5                  _CAN0TXDSR1.Bits.DB5
#define CAN0TXDSR1_DB6                  _CAN0TXDSR1.Bits.DB6
#define CAN0TXDSR1_DB7                  _CAN0TXDSR1.Bits.DB7

#define CAN0TXDSR1_DB0_MASK             1U
#define CAN0TXDSR1_DB1_MASK             2U
#define CAN0TXDSR1_DB2_MASK             4U
#define CAN0TXDSR1_DB3_MASK             8U
#define CAN0TXDSR1_DB4_MASK             16U
#define CAN0TXDSR1_DB5_MASK             32U
#define CAN0TXDSR1_DB6_MASK             64U
#define CAN0TXDSR1_DB7_MASK             128U


/*** CAN0TXDSR2 - MSCAN 0 Transmit Data Segment Register 2; 0x00000176 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR2STR;
extern volatile CAN0TXDSR2STR _CAN0TXDSR2 @(REG_BASE + 0x00000176UL);
#define CAN0TXDSR2                      _CAN0TXDSR2.Byte
#define CAN0TXDSR2_DB0                  _CAN0TXDSR2.Bits.DB0
#define CAN0TXDSR2_DB1                  _CAN0TXDSR2.Bits.DB1
#define CAN0TXDSR2_DB2                  _CAN0TXDSR2.Bits.DB2
#define CAN0TXDSR2_DB3                  _CAN0TXDSR2.Bits.DB3
#define CAN0TXDSR2_DB4                  _CAN0TXDSR2.Bits.DB4
#define CAN0TXDSR2_DB5                  _CAN0TXDSR2.Bits.DB5
#define CAN0TXDSR2_DB6                  _CAN0TXDSR2.Bits.DB6
#define CAN0TXDSR2_DB7                  _CAN0TXDSR2.Bits.DB7

#define CAN0TXDSR2_DB0_MASK             1U
#define CAN0TXDSR2_DB1_MASK             2U
#define CAN0TXDSR2_DB2_MASK             4U
#define CAN0TXDSR2_DB3_MASK             8U
#define CAN0TXDSR2_DB4_MASK             16U
#define CAN0TXDSR2_DB5_MASK             32U
#define CAN0TXDSR2_DB6_MASK             64U
#define CAN0TXDSR2_DB7_MASK             128U


/*** CAN0TXDSR3 - MSCAN 0 Transmit Data Segment Register 3; 0x00000177 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR3STR;
extern volatile CAN0TXDSR3STR _CAN0TXDSR3 @(REG_BASE + 0x00000177UL);
#define CAN0TXDSR3                      _CAN0TXDSR3.Byte
#define CAN0TXDSR3_DB0                  _CAN0TXDSR3.Bits.DB0
#define CAN0TXDSR3_DB1                  _CAN0TXDSR3.Bits.DB1
#define CAN0TXDSR3_DB2                  _CAN0TXDSR3.Bits.DB2
#define CAN0TXDSR3_DB3                  _CAN0TXDSR3.Bits.DB3
#define CAN0TXDSR3_DB4                  _CAN0TXDSR3.Bits.DB4
#define CAN0TXDSR3_DB5                  _CAN0TXDSR3.Bits.DB5
#define CAN0TXDSR3_DB6                  _CAN0TXDSR3.Bits.DB6
#define CAN0TXDSR3_DB7                  _CAN0TXDSR3.Bits.DB7

#define CAN0TXDSR3_DB0_MASK             1U
#define CAN0TXDSR3_DB1_MASK             2U
#define CAN0TXDSR3_DB2_MASK             4U
#define CAN0TXDSR3_DB3_MASK             8U
#define CAN0TXDSR3_DB4_MASK             16U
#define CAN0TXDSR3_DB5_MASK             32U
#define CAN0TXDSR3_DB6_MASK             64U
#define CAN0TXDSR3_DB7_MASK             128U


/*** CAN0TXDSR4 - MSCAN 0 Transmit Data Segment Register 4; 0x00000178 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR4STR;
extern volatile CAN0TXDSR4STR _CAN0TXDSR4 @(REG_BASE + 0x00000178UL);
#define CAN0TXDSR4                      _CAN0TXDSR4.Byte
#define CAN0TXDSR4_DB0                  _CAN0TXDSR4.Bits.DB0
#define CAN0TXDSR4_DB1                  _CAN0TXDSR4.Bits.DB1
#define CAN0TXDSR4_DB2                  _CAN0TXDSR4.Bits.DB2
#define CAN0TXDSR4_DB3                  _CAN0TXDSR4.Bits.DB3
#define CAN0TXDSR4_DB4                  _CAN0TXDSR4.Bits.DB4
#define CAN0TXDSR4_DB5                  _CAN0TXDSR4.Bits.DB5
#define CAN0TXDSR4_DB6                  _CAN0TXDSR4.Bits.DB6
#define CAN0TXDSR4_DB7                  _CAN0TXDSR4.Bits.DB7

#define CAN0TXDSR4_DB0_MASK             1U
#define CAN0TXDSR4_DB1_MASK             2U
#define CAN0TXDSR4_DB2_MASK             4U
#define CAN0TXDSR4_DB3_MASK             8U
#define CAN0TXDSR4_DB4_MASK             16U
#define CAN0TXDSR4_DB5_MASK             32U
#define CAN0TXDSR4_DB6_MASK             64U
#define CAN0TXDSR4_DB7_MASK             128U


/*** CAN0TXDSR5 - MSCAN 0 Transmit Data Segment Register 5; 0x00000179 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR5STR;
extern volatile CAN0TXDSR5STR _CAN0TXDSR5 @(REG_BASE + 0x00000179UL);
#define CAN0TXDSR5                      _CAN0TXDSR5.Byte
#define CAN0TXDSR5_DB0                  _CAN0TXDSR5.Bits.DB0
#define CAN0TXDSR5_DB1                  _CAN0TXDSR5.Bits.DB1
#define CAN0TXDSR5_DB2                  _CAN0TXDSR5.Bits.DB2
#define CAN0TXDSR5_DB3                  _CAN0TXDSR5.Bits.DB3
#define CAN0TXDSR5_DB4                  _CAN0TXDSR5.Bits.DB4
#define CAN0TXDSR5_DB5                  _CAN0TXDSR5.Bits.DB5
#define CAN0TXDSR5_DB6                  _CAN0TXDSR5.Bits.DB6
#define CAN0TXDSR5_DB7                  _CAN0TXDSR5.Bits.DB7

#define CAN0TXDSR5_DB0_MASK             1U
#define CAN0TXDSR5_DB1_MASK             2U
#define CAN0TXDSR5_DB2_MASK             4U
#define CAN0TXDSR5_DB3_MASK             8U
#define CAN0TXDSR5_DB4_MASK             16U
#define CAN0TXDSR5_DB5_MASK             32U
#define CAN0TXDSR5_DB6_MASK             64U
#define CAN0TXDSR5_DB7_MASK             128U


/*** CAN0TXDSR6 - MSCAN 0 Transmit Data Segment Register 6; 0x0000017A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR6STR;
extern volatile CAN0TXDSR6STR _CAN0TXDSR6 @(REG_BASE + 0x0000017AUL);
#define CAN0TXDSR6                      _CAN0TXDSR6.Byte
#define CAN0TXDSR6_DB0                  _CAN0TXDSR6.Bits.DB0
#define CAN0TXDSR6_DB1                  _CAN0TXDSR6.Bits.DB1
#define CAN0TXDSR6_DB2                  _CAN0TXDSR6.Bits.DB2
#define CAN0TXDSR6_DB3                  _CAN0TXDSR6.Bits.DB3
#define CAN0TXDSR6_DB4                  _CAN0TXDSR6.Bits.DB4
#define CAN0TXDSR6_DB5                  _CAN0TXDSR6.Bits.DB5
#define CAN0TXDSR6_DB6                  _CAN0TXDSR6.Bits.DB6
#define CAN0TXDSR6_DB7                  _CAN0TXDSR6.Bits.DB7

#define CAN0TXDSR6_DB0_MASK             1U
#define CAN0TXDSR6_DB1_MASK             2U
#define CAN0TXDSR6_DB2_MASK             4U
#define CAN0TXDSR6_DB3_MASK             8U
#define CAN0TXDSR6_DB4_MASK             16U
#define CAN0TXDSR6_DB5_MASK             32U
#define CAN0TXDSR6_DB6_MASK             64U
#define CAN0TXDSR6_DB7_MASK             128U


/*** CAN0TXDSR7 - MSCAN 0 Transmit Data Segment Register 7; 0x0000017B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN0TXDSR7STR;
extern volatile CAN0TXDSR7STR _CAN0TXDSR7 @(REG_BASE + 0x0000017BUL);
#define CAN0TXDSR7                      _CAN0TXDSR7.Byte
#define CAN0TXDSR7_DB0                  _CAN0TXDSR7.Bits.DB0
#define CAN0TXDSR7_DB1                  _CAN0TXDSR7.Bits.DB1
#define CAN0TXDSR7_DB2                  _CAN0TXDSR7.Bits.DB2
#define CAN0TXDSR7_DB3                  _CAN0TXDSR7.Bits.DB3
#define CAN0TXDSR7_DB4                  _CAN0TXDSR7.Bits.DB4
#define CAN0TXDSR7_DB5                  _CAN0TXDSR7.Bits.DB5
#define CAN0TXDSR7_DB6                  _CAN0TXDSR7.Bits.DB6
#define CAN0TXDSR7_DB7                  _CAN0TXDSR7.Bits.DB7

#define CAN0TXDSR7_DB0_MASK             1U
#define CAN0TXDSR7_DB1_MASK             2U
#define CAN0TXDSR7_DB2_MASK             4U
#define CAN0TXDSR7_DB3_MASK             8U
#define CAN0TXDSR7_DB4_MASK             16U
#define CAN0TXDSR7_DB5_MASK             32U
#define CAN0TXDSR7_DB6_MASK             64U
#define CAN0TXDSR7_DB7_MASK             128U


/*** CAN0TXDLR - MSCAN 0 Transmit Data Length Register; 0x0000017C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN0TXDLRSTR;
extern volatile CAN0TXDLRSTR _CAN0TXDLR @(REG_BASE + 0x0000017CUL);
#define CAN0TXDLR                       _CAN0TXDLR.Byte
#define CAN0TXDLR_DLC0                  _CAN0TXDLR.Bits.DLC0
#define CAN0TXDLR_DLC1                  _CAN0TXDLR.Bits.DLC1
#define CAN0TXDLR_DLC2                  _CAN0TXDLR.Bits.DLC2
#define CAN0TXDLR_DLC3                  _CAN0TXDLR.Bits.DLC3
#define CAN0TXDLR_DLC                   _CAN0TXDLR.MergedBits.grpDLC

#define CAN0TXDLR_DLC0_MASK             1U
#define CAN0TXDLR_DLC1_MASK             2U
#define CAN0TXDLR_DLC2_MASK             4U
#define CAN0TXDLR_DLC3_MASK             8U
#define CAN0TXDLR_DLC_MASK              15U
#define CAN0TXDLR_DLC_BITNUM            0U


/*** CAN0TXTBPR - MSCAN 0 Transmit Buffer Priority; 0x0000017D ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN0TXTBPRSTR;
extern volatile CAN0TXTBPRSTR _CAN0TXTBPR @(REG_BASE + 0x0000017DUL);
#define CAN0TXTBPR                      _CAN0TXTBPR.Byte
#define CAN0TXTBPR_PRIO0                _CAN0TXTBPR.Bits.PRIO0
#define CAN0TXTBPR_PRIO1                _CAN0TXTBPR.Bits.PRIO1
#define CAN0TXTBPR_PRIO2                _CAN0TXTBPR.Bits.PRIO2
#define CAN0TXTBPR_PRIO3                _CAN0TXTBPR.Bits.PRIO3
#define CAN0TXTBPR_PRIO4                _CAN0TXTBPR.Bits.PRIO4
#define CAN0TXTBPR_PRIO5                _CAN0TXTBPR.Bits.PRIO5
#define CAN0TXTBPR_PRIO6                _CAN0TXTBPR.Bits.PRIO6
#define CAN0TXTBPR_PRIO7                _CAN0TXTBPR.Bits.PRIO7

#define CAN0TXTBPR_PRIO0_MASK           1U
#define CAN0TXTBPR_PRIO1_MASK           2U
#define CAN0TXTBPR_PRIO2_MASK           4U
#define CAN0TXTBPR_PRIO3_MASK           8U
#define CAN0TXTBPR_PRIO4_MASK           16U
#define CAN0TXTBPR_PRIO5_MASK           32U
#define CAN0TXTBPR_PRIO6_MASK           64U
#define CAN0TXTBPR_PRIO7_MASK           128U


/*** CAN0TXTSR - MSCAN 0 Transmit Time Stamp Register; 0x0000017E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN0TXTSRH - MSCAN 0 Transmit Time Stamp Register High; 0x0000017E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN0TXTSRHSTR;
    #define CAN0TXTSRH                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Byte
    #define CAN0TXTSRH_TSR8             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR8
    #define CAN0TXTSRH_TSR9             _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR9
    #define CAN0TXTSRH_TSR10            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR10
    #define CAN0TXTSRH_TSR11            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR11
    #define CAN0TXTSRH_TSR12            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR12
    #define CAN0TXTSRH_TSR13            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR13
    #define CAN0TXTSRH_TSR14            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR14
    #define CAN0TXTSRH_TSR15            _CAN0TXTSR.Overlap_STR.CAN0TXTSRHSTR.Bits.TSR15
    
    #define CAN0TXTSRH_TSR8_MASK        1U
    #define CAN0TXTSRH_TSR9_MASK        2U
    #define CAN0TXTSRH_TSR10_MASK       4U
    #define CAN0TXTSRH_TSR11_MASK       8U
    #define CAN0TXTSRH_TSR12_MASK       16U
    #define CAN0TXTSRH_TSR13_MASK       32U
    #define CAN0TXTSRH_TSR14_MASK       64U
    #define CAN0TXTSRH_TSR15_MASK       128U
    

    /*** CAN0TXTSRL - MSCAN 0 Transmit Time Stamp Register Low; 0x0000017F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN0TXTSRLSTR;
    #define CAN0TXTSRL                  _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Byte
    #define CAN0TXTSRL_TSR0             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR0
    #define CAN0TXTSRL_TSR1             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR1
    #define CAN0TXTSRL_TSR2             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR2
    #define CAN0TXTSRL_TSR3             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR3
    #define CAN0TXTSRL_TSR4             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR4
    #define CAN0TXTSRL_TSR5             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR5
    #define CAN0TXTSRL_TSR6             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR6
    #define CAN0TXTSRL_TSR7             _CAN0TXTSR.Overlap_STR.CAN0TXTSRLSTR.Bits.TSR7
    
    #define CAN0TXTSRL_TSR0_MASK        1U
    #define CAN0TXTSRL_TSR1_MASK        2U
    #define CAN0TXTSRL_TSR2_MASK        4U
    #define CAN0TXTSRL_TSR3_MASK        8U
    #define CAN0TXTSRL_TSR4_MASK        16U
    #define CAN0TXTSRL_TSR5_MASK        32U
    #define CAN0TXTSRL_TSR6_MASK        64U
    #define CAN0TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN0TXTSRSTR;
extern volatile CAN0TXTSRSTR _CAN0TXTSR @(REG_BASE + 0x0000017EUL);
#define CAN0TXTSR                       _CAN0TXTSR.Word
#define CAN0TXTSR_TSR0                  _CAN0TXTSR.Bits.TSR0
#define CAN0TXTSR_TSR1                  _CAN0TXTSR.Bits.TSR1
#define CAN0TXTSR_TSR2                  _CAN0TXTSR.Bits.TSR2
#define CAN0TXTSR_TSR3                  _CAN0TXTSR.Bits.TSR3
#define CAN0TXTSR_TSR4                  _CAN0TXTSR.Bits.TSR4
#define CAN0TXTSR_TSR5                  _CAN0TXTSR.Bits.TSR5
#define CAN0TXTSR_TSR6                  _CAN0TXTSR.Bits.TSR6
#define CAN0TXTSR_TSR7                  _CAN0TXTSR.Bits.TSR7
#define CAN0TXTSR_TSR8                  _CAN0TXTSR.Bits.TSR8
#define CAN0TXTSR_TSR9                  _CAN0TXTSR.Bits.TSR9
#define CAN0TXTSR_TSR10                 _CAN0TXTSR.Bits.TSR10
#define CAN0TXTSR_TSR11                 _CAN0TXTSR.Bits.TSR11
#define CAN0TXTSR_TSR12                 _CAN0TXTSR.Bits.TSR12
#define CAN0TXTSR_TSR13                 _CAN0TXTSR.Bits.TSR13
#define CAN0TXTSR_TSR14                 _CAN0TXTSR.Bits.TSR14
#define CAN0TXTSR_TSR15                 _CAN0TXTSR.Bits.TSR15

#define CAN0TXTSR_TSR0_MASK             1U
#define CAN0TXTSR_TSR1_MASK             2U
#define CAN0TXTSR_TSR2_MASK             4U
#define CAN0TXTSR_TSR3_MASK             8U
#define CAN0TXTSR_TSR4_MASK             16U
#define CAN0TXTSR_TSR5_MASK             32U
#define CAN0TXTSR_TSR6_MASK             64U
#define CAN0TXTSR_TSR7_MASK             128U
#define CAN0TXTSR_TSR8_MASK             256U
#define CAN0TXTSR_TSR9_MASK             512U
#define CAN0TXTSR_TSR10_MASK            1024U
#define CAN0TXTSR_TSR11_MASK            2048U
#define CAN0TXTSR_TSR12_MASK            4096U
#define CAN0TXTSR_TSR13_MASK            8192U
#define CAN0TXTSR_TSR14_MASK            16384U
#define CAN0TXTSR_TSR15_MASK            32768U


/*** CAN1CTL0 - MSCAN 1 Control 0 Register; 0x00000180 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN1CTL0STR;
extern volatile CAN1CTL0STR _CAN1CTL0 @(REG_BASE + 0x00000180UL);
#define CAN1CTL0                        _CAN1CTL0.Byte
#define CAN1CTL0_INITRQ                 _CAN1CTL0.Bits.INITRQ
#define CAN1CTL0_SLPRQ                  _CAN1CTL0.Bits.SLPRQ
#define CAN1CTL0_WUPE                   _CAN1CTL0.Bits.WUPE
#define CAN1CTL0_TIME                   _CAN1CTL0.Bits.TIME
#define CAN1CTL0_SYNCH                  _CAN1CTL0.Bits.SYNCH
#define CAN1CTL0_CSWAI                  _CAN1CTL0.Bits.CSWAI
#define CAN1CTL0_RXACT                  _CAN1CTL0.Bits.RXACT
#define CAN1CTL0_RXFRM                  _CAN1CTL0.Bits.RXFRM
/* CAN1CTL_ARR: Access 2 CAN1CTLx registers in an array */
#define CAN1CTL_ARR                     ((volatile byte *) &CAN1CTL0)

#define CAN1CTL0_INITRQ_MASK            1U
#define CAN1CTL0_SLPRQ_MASK             2U
#define CAN1CTL0_WUPE_MASK              4U
#define CAN1CTL0_TIME_MASK              8U
#define CAN1CTL0_SYNCH_MASK             16U
#define CAN1CTL0_CSWAI_MASK             32U
#define CAN1CTL0_RXACT_MASK             64U
#define CAN1CTL0_RXFRM_MASK             128U


/*** CAN1CTL1 - MSCAN 1 Control 1 Register; 0x00000181 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN 1 Clock Source */
    byte CANE        :1;                                       /* MSCAN 1 Enable */
  } Bits;
} CAN1CTL1STR;
extern volatile CAN1CTL1STR _CAN1CTL1 @(REG_BASE + 0x00000181UL);
#define CAN1CTL1                        _CAN1CTL1.Byte
#define CAN1CTL1_INITAK                 _CAN1CTL1.Bits.INITAK
#define CAN1CTL1_SLPAK                  _CAN1CTL1.Bits.SLPAK
#define CAN1CTL1_WUPM                   _CAN1CTL1.Bits.WUPM
#define CAN1CTL1_BORM                   _CAN1CTL1.Bits.BORM
#define CAN1CTL1_LISTEN                 _CAN1CTL1.Bits.LISTEN
#define CAN1CTL1_LOOPB                  _CAN1CTL1.Bits.LOOPB
#define CAN1CTL1_CLKSRC                 _CAN1CTL1.Bits.CLKSRC
#define CAN1CTL1_CANE                   _CAN1CTL1.Bits.CANE

#define CAN1CTL1_INITAK_MASK            1U
#define CAN1CTL1_SLPAK_MASK             2U
#define CAN1CTL1_WUPM_MASK              4U
#define CAN1CTL1_BORM_MASK              8U
#define CAN1CTL1_LISTEN_MASK            16U
#define CAN1CTL1_LOOPB_MASK             32U
#define CAN1CTL1_CLKSRC_MASK            64U
#define CAN1CTL1_CANE_MASK              128U


/*** CAN1BTR0 - MSCAN 1 Bus Timing Register 0; 0x00000182 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN1BTR0STR;
extern volatile CAN1BTR0STR _CAN1BTR0 @(REG_BASE + 0x00000182UL);
#define CAN1BTR0                        _CAN1BTR0.Byte
#define CAN1BTR0_BRP0                   _CAN1BTR0.Bits.BRP0
#define CAN1BTR0_BRP1                   _CAN1BTR0.Bits.BRP1
#define CAN1BTR0_BRP2                   _CAN1BTR0.Bits.BRP2
#define CAN1BTR0_BRP3                   _CAN1BTR0.Bits.BRP3
#define CAN1BTR0_BRP4                   _CAN1BTR0.Bits.BRP4
#define CAN1BTR0_BRP5                   _CAN1BTR0.Bits.BRP5
#define CAN1BTR0_SJW0                   _CAN1BTR0.Bits.SJW0
#define CAN1BTR0_SJW1                   _CAN1BTR0.Bits.SJW1
/* CAN1BTR_ARR: Access 2 CAN1BTRx registers in an array */
#define CAN1BTR_ARR                     ((volatile byte *) &CAN1BTR0)
#define CAN1BTR0_BRP                    _CAN1BTR0.MergedBits.grpBRP
#define CAN1BTR0_SJW                    _CAN1BTR0.MergedBits.grpSJW

#define CAN1BTR0_BRP0_MASK              1U
#define CAN1BTR0_BRP1_MASK              2U
#define CAN1BTR0_BRP2_MASK              4U
#define CAN1BTR0_BRP3_MASK              8U
#define CAN1BTR0_BRP4_MASK              16U
#define CAN1BTR0_BRP5_MASK              32U
#define CAN1BTR0_SJW0_MASK              64U
#define CAN1BTR0_SJW1_MASK              128U
#define CAN1BTR0_BRP_MASK               63U
#define CAN1BTR0_BRP_BITNUM             0U
#define CAN1BTR0_SJW_MASK               192U
#define CAN1BTR0_SJW_BITNUM             6U


/*** CAN1BTR1 - MSCAN 1 Bus Timing Register 1; 0x00000183 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN1BTR1STR;
extern volatile CAN1BTR1STR _CAN1BTR1 @(REG_BASE + 0x00000183UL);
#define CAN1BTR1                        _CAN1BTR1.Byte
#define CAN1BTR1_TSEG10                 _CAN1BTR1.Bits.TSEG10
#define CAN1BTR1_TSEG11                 _CAN1BTR1.Bits.TSEG11
#define CAN1BTR1_TSEG12                 _CAN1BTR1.Bits.TSEG12
#define CAN1BTR1_TSEG13                 _CAN1BTR1.Bits.TSEG13
#define CAN1BTR1_TSEG20                 _CAN1BTR1.Bits.TSEG20
#define CAN1BTR1_TSEG21                 _CAN1BTR1.Bits.TSEG21
#define CAN1BTR1_TSEG22                 _CAN1BTR1.Bits.TSEG22
#define CAN1BTR1_SAMP                   _CAN1BTR1.Bits.SAMP
#define CAN1BTR1_TSEG_10                _CAN1BTR1.MergedBits.grpTSEG_10
#define CAN1BTR1_TSEG_20                _CAN1BTR1.MergedBits.grpTSEG_20
#define CAN1BTR1_TSEG                   CAN1BTR1_TSEG_10

#define CAN1BTR1_TSEG10_MASK            1U
#define CAN1BTR1_TSEG11_MASK            2U
#define CAN1BTR1_TSEG12_MASK            4U
#define CAN1BTR1_TSEG13_MASK            8U
#define CAN1BTR1_TSEG20_MASK            16U
#define CAN1BTR1_TSEG21_MASK            32U
#define CAN1BTR1_TSEG22_MASK            64U
#define CAN1BTR1_SAMP_MASK              128U
#define CAN1BTR1_TSEG_10_MASK           15U
#define CAN1BTR1_TSEG_10_BITNUM         0U
#define CAN1BTR1_TSEG_20_MASK           112U
#define CAN1BTR1_TSEG_20_BITNUM         4U


/*** CAN1RFLG - MSCAN 1 Receiver Flag Register; 0x00000184 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RFLGSTR;
extern volatile CAN1RFLGSTR _CAN1RFLG @(REG_BASE + 0x00000184UL);
#define CAN1RFLG                        _CAN1RFLG.Byte
#define CAN1RFLG_RXF                    _CAN1RFLG.Bits.RXF
#define CAN1RFLG_OVRIF                  _CAN1RFLG.Bits.OVRIF
#define CAN1RFLG_TSTAT0                 _CAN1RFLG.Bits.TSTAT0
#define CAN1RFLG_TSTAT1                 _CAN1RFLG.Bits.TSTAT1
#define CAN1RFLG_RSTAT0                 _CAN1RFLG.Bits.RSTAT0
#define CAN1RFLG_RSTAT1                 _CAN1RFLG.Bits.RSTAT1
#define CAN1RFLG_CSCIF                  _CAN1RFLG.Bits.CSCIF
#define CAN1RFLG_WUPIF                  _CAN1RFLG.Bits.WUPIF
#define CAN1RFLG_TSTAT                  _CAN1RFLG.MergedBits.grpTSTAT
#define CAN1RFLG_RSTAT                  _CAN1RFLG.MergedBits.grpRSTAT

#define CAN1RFLG_RXF_MASK               1U
#define CAN1RFLG_OVRIF_MASK             2U
#define CAN1RFLG_TSTAT0_MASK            4U
#define CAN1RFLG_TSTAT1_MASK            8U
#define CAN1RFLG_RSTAT0_MASK            16U
#define CAN1RFLG_RSTAT1_MASK            32U
#define CAN1RFLG_CSCIF_MASK             64U
#define CAN1RFLG_WUPIF_MASK             128U
#define CAN1RFLG_TSTAT_MASK             12U
#define CAN1RFLG_TSTAT_BITNUM           2U
#define CAN1RFLG_RSTAT_MASK             48U
#define CAN1RFLG_RSTAT_BITNUM           4U


/*** CAN1RIER - MSCAN 1 Receiver Interrupt Enable Register; 0x00000185 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RIERSTR;
extern volatile CAN1RIERSTR _CAN1RIER @(REG_BASE + 0x00000185UL);
#define CAN1RIER                        _CAN1RIER.Byte
#define CAN1RIER_RXFIE                  _CAN1RIER.Bits.RXFIE
#define CAN1RIER_OVRIE                  _CAN1RIER.Bits.OVRIE
#define CAN1RIER_TSTATE0                _CAN1RIER.Bits.TSTATE0
#define CAN1RIER_TSTATE1                _CAN1RIER.Bits.TSTATE1
#define CAN1RIER_RSTATE0                _CAN1RIER.Bits.RSTATE0
#define CAN1RIER_RSTATE1                _CAN1RIER.Bits.RSTATE1
#define CAN1RIER_CSCIE                  _CAN1RIER.Bits.CSCIE
#define CAN1RIER_WUPIE                  _CAN1RIER.Bits.WUPIE
#define CAN1RIER_TSTATE                 _CAN1RIER.MergedBits.grpTSTATE
#define CAN1RIER_RSTATE                 _CAN1RIER.MergedBits.grpRSTATE

#define CAN1RIER_RXFIE_MASK             1U
#define CAN1RIER_OVRIE_MASK             2U
#define CAN1RIER_TSTATE0_MASK           4U
#define CAN1RIER_TSTATE1_MASK           8U
#define CAN1RIER_RSTATE0_MASK           16U
#define CAN1RIER_RSTATE1_MASK           32U
#define CAN1RIER_CSCIE_MASK             64U
#define CAN1RIER_WUPIE_MASK             128U
#define CAN1RIER_TSTATE_MASK            12U
#define CAN1RIER_TSTATE_BITNUM          2U
#define CAN1RIER_RSTATE_MASK            48U
#define CAN1RIER_RSTATE_BITNUM          4U


/*** CAN1TFLG - MSCAN 1 Transmitter Flag Register; 0x00000186 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TFLGSTR;
extern volatile CAN1TFLGSTR _CAN1TFLG @(REG_BASE + 0x00000186UL);
#define CAN1TFLG                        _CAN1TFLG.Byte
#define CAN1TFLG_TXE0                   _CAN1TFLG.Bits.TXE0
#define CAN1TFLG_TXE1                   _CAN1TFLG.Bits.TXE1
#define CAN1TFLG_TXE2                   _CAN1TFLG.Bits.TXE2
#define CAN1TFLG_TXE                    _CAN1TFLG.MergedBits.grpTXE

#define CAN1TFLG_TXE0_MASK              1U
#define CAN1TFLG_TXE1_MASK              2U
#define CAN1TFLG_TXE2_MASK              4U
#define CAN1TFLG_TXE_MASK               7U
#define CAN1TFLG_TXE_BITNUM             0U


/*** CAN1TIER - MSCAN 1 Transmitter Interrupt Enable Register; 0x00000187 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TIERSTR;
extern volatile CAN1TIERSTR _CAN1TIER @(REG_BASE + 0x00000187UL);
#define CAN1TIER                        _CAN1TIER.Byte
#define CAN1TIER_TXEIE0                 _CAN1TIER.Bits.TXEIE0
#define CAN1TIER_TXEIE1                 _CAN1TIER.Bits.TXEIE1
#define CAN1TIER_TXEIE2                 _CAN1TIER.Bits.TXEIE2
#define CAN1TIER_TXEIE                  _CAN1TIER.MergedBits.grpTXEIE

#define CAN1TIER_TXEIE0_MASK            1U
#define CAN1TIER_TXEIE1_MASK            2U
#define CAN1TIER_TXEIE2_MASK            4U
#define CAN1TIER_TXEIE_MASK             7U
#define CAN1TIER_TXEIE_BITNUM           0U


/*** CAN1TARQ - MSCAN 1 Transmitter Message Abort Request; 0x00000188 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TARQSTR;
extern volatile CAN1TARQSTR _CAN1TARQ @(REG_BASE + 0x00000188UL);
#define CAN1TARQ                        _CAN1TARQ.Byte
#define CAN1TARQ_ABTRQ0                 _CAN1TARQ.Bits.ABTRQ0
#define CAN1TARQ_ABTRQ1                 _CAN1TARQ.Bits.ABTRQ1
#define CAN1TARQ_ABTRQ2                 _CAN1TARQ.Bits.ABTRQ2
#define CAN1TARQ_ABTRQ                  _CAN1TARQ.MergedBits.grpABTRQ

#define CAN1TARQ_ABTRQ0_MASK            1U
#define CAN1TARQ_ABTRQ1_MASK            2U
#define CAN1TARQ_ABTRQ2_MASK            4U
#define CAN1TARQ_ABTRQ_MASK             7U
#define CAN1TARQ_ABTRQ_BITNUM           0U


/*** CAN1TAAK - MSCAN 1 Transmitter Message Abort Control; 0x00000189 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TAAKSTR;
extern volatile CAN1TAAKSTR _CAN1TAAK @(REG_BASE + 0x00000189UL);
#define CAN1TAAK                        _CAN1TAAK.Byte
#define CAN1TAAK_ABTAK0                 _CAN1TAAK.Bits.ABTAK0
#define CAN1TAAK_ABTAK1                 _CAN1TAAK.Bits.ABTAK1
#define CAN1TAAK_ABTAK2                 _CAN1TAAK.Bits.ABTAK2
#define CAN1TAAK_ABTAK                  _CAN1TAAK.MergedBits.grpABTAK

#define CAN1TAAK_ABTAK0_MASK            1U
#define CAN1TAAK_ABTAK1_MASK            2U
#define CAN1TAAK_ABTAK2_MASK            4U
#define CAN1TAAK_ABTAK_MASK             7U
#define CAN1TAAK_ABTAK_BITNUM           0U


/*** CAN1TBSEL - MSCAN 1 Transmit Buffer Selection; 0x0000018A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TBSELSTR;
extern volatile CAN1TBSELSTR _CAN1TBSEL @(REG_BASE + 0x0000018AUL);
#define CAN1TBSEL                       _CAN1TBSEL.Byte
#define CAN1TBSEL_TX0                   _CAN1TBSEL.Bits.TX0
#define CAN1TBSEL_TX1                   _CAN1TBSEL.Bits.TX1
#define CAN1TBSEL_TX2                   _CAN1TBSEL.Bits.TX2
#define CAN1TBSEL_TX                    _CAN1TBSEL.MergedBits.grpTX

#define CAN1TBSEL_TX0_MASK              1U
#define CAN1TBSEL_TX1_MASK              2U
#define CAN1TBSEL_TX2_MASK              4U
#define CAN1TBSEL_TX_MASK               7U
#define CAN1TBSEL_TX_BITNUM             0U


/*** CAN1IDAC - MSCAN 1 Identifier Acceptance Control Register; 0x0000018B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1IDACSTR;
extern volatile CAN1IDACSTR _CAN1IDAC @(REG_BASE + 0x0000018BUL);
#define CAN1IDAC                        _CAN1IDAC.Byte
#define CAN1IDAC_IDHIT0                 _CAN1IDAC.Bits.IDHIT0
#define CAN1IDAC_IDHIT1                 _CAN1IDAC.Bits.IDHIT1
#define CAN1IDAC_IDHIT2                 _CAN1IDAC.Bits.IDHIT2
#define CAN1IDAC_IDAM0                  _CAN1IDAC.Bits.IDAM0
#define CAN1IDAC_IDAM1                  _CAN1IDAC.Bits.IDAM1
#define CAN1IDAC_IDHIT                  _CAN1IDAC.MergedBits.grpIDHIT
#define CAN1IDAC_IDAM                   _CAN1IDAC.MergedBits.grpIDAM

#define CAN1IDAC_IDHIT0_MASK            1U
#define CAN1IDAC_IDHIT1_MASK            2U
#define CAN1IDAC_IDHIT2_MASK            4U
#define CAN1IDAC_IDAM0_MASK             16U
#define CAN1IDAC_IDAM1_MASK             32U
#define CAN1IDAC_IDHIT_MASK             7U
#define CAN1IDAC_IDHIT_BITNUM           0U
#define CAN1IDAC_IDAM_MASK              48U
#define CAN1IDAC_IDAM_BITNUM            4U


/*** CAN1MISC - MSCAN 1 Miscellaneous Register; 0x0000018D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-Off state Hold until user request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN1MISCSTR;
extern volatile CAN1MISCSTR _CAN1MISC @(REG_BASE + 0x0000018DUL);
#define CAN1MISC                        _CAN1MISC.Byte
#define CAN1MISC_BOHOLD                 _CAN1MISC.Bits.BOHOLD

#define CAN1MISC_BOHOLD_MASK            1U


/*** CAN1RXERR - MSCAN 1 Receive Error Counter Register; 0x0000018E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN1RXERRSTR;
extern volatile CAN1RXERRSTR _CAN1RXERR @(REG_BASE + 0x0000018EUL);
#define CAN1RXERR                       _CAN1RXERR.Byte
#define CAN1RXERR_RXERR0                _CAN1RXERR.Bits.RXERR0
#define CAN1RXERR_RXERR1                _CAN1RXERR.Bits.RXERR1
#define CAN1RXERR_RXERR2                _CAN1RXERR.Bits.RXERR2
#define CAN1RXERR_RXERR3                _CAN1RXERR.Bits.RXERR3
#define CAN1RXERR_RXERR4                _CAN1RXERR.Bits.RXERR4
#define CAN1RXERR_RXERR5                _CAN1RXERR.Bits.RXERR5
#define CAN1RXERR_RXERR6                _CAN1RXERR.Bits.RXERR6
#define CAN1RXERR_RXERR7                _CAN1RXERR.Bits.RXERR7

#define CAN1RXERR_RXERR0_MASK           1U
#define CAN1RXERR_RXERR1_MASK           2U
#define CAN1RXERR_RXERR2_MASK           4U
#define CAN1RXERR_RXERR3_MASK           8U
#define CAN1RXERR_RXERR4_MASK           16U
#define CAN1RXERR_RXERR5_MASK           32U
#define CAN1RXERR_RXERR6_MASK           64U
#define CAN1RXERR_RXERR7_MASK           128U


/*** CAN1TXERR - MSCAN 1 Transmit Error Counter Register; 0x0000018F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN1TXERRSTR;
extern volatile CAN1TXERRSTR _CAN1TXERR @(REG_BASE + 0x0000018FUL);
#define CAN1TXERR                       _CAN1TXERR.Byte
#define CAN1TXERR_TXERR0                _CAN1TXERR.Bits.TXERR0
#define CAN1TXERR_TXERR1                _CAN1TXERR.Bits.TXERR1
#define CAN1TXERR_TXERR2                _CAN1TXERR.Bits.TXERR2
#define CAN1TXERR_TXERR3                _CAN1TXERR.Bits.TXERR3
#define CAN1TXERR_TXERR4                _CAN1TXERR.Bits.TXERR4
#define CAN1TXERR_TXERR5                _CAN1TXERR.Bits.TXERR5
#define CAN1TXERR_TXERR6                _CAN1TXERR.Bits.TXERR6
#define CAN1TXERR_TXERR7                _CAN1TXERR.Bits.TXERR7

#define CAN1TXERR_TXERR0_MASK           1U
#define CAN1TXERR_TXERR1_MASK           2U
#define CAN1TXERR_TXERR2_MASK           4U
#define CAN1TXERR_TXERR3_MASK           8U
#define CAN1TXERR_TXERR4_MASK           16U
#define CAN1TXERR_TXERR5_MASK           32U
#define CAN1TXERR_TXERR6_MASK           64U
#define CAN1TXERR_TXERR7_MASK           128U


/*** CAN1IDAR0 - MSCAN 1 Identifier Acceptance Register 0; 0x00000190 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR0STR;
extern volatile CAN1IDAR0STR _CAN1IDAR0 @(REG_BASE + 0x00000190UL);
#define CAN1IDAR0                       _CAN1IDAR0.Byte
#define CAN1IDAR0_AC0                   _CAN1IDAR0.Bits.AC0
#define CAN1IDAR0_AC1                   _CAN1IDAR0.Bits.AC1
#define CAN1IDAR0_AC2                   _CAN1IDAR0.Bits.AC2
#define CAN1IDAR0_AC3                   _CAN1IDAR0.Bits.AC3
#define CAN1IDAR0_AC4                   _CAN1IDAR0.Bits.AC4
#define CAN1IDAR0_AC5                   _CAN1IDAR0.Bits.AC5
#define CAN1IDAR0_AC6                   _CAN1IDAR0.Bits.AC6
#define CAN1IDAR0_AC7                   _CAN1IDAR0.Bits.AC7
/* CAN1IDAR_ARR: Access 4 CAN1IDARx registers in an array */
#define CAN1IDAR_ARR                    ((volatile byte *) &CAN1IDAR0)

#define CAN1IDAR0_AC0_MASK              1U
#define CAN1IDAR0_AC1_MASK              2U
#define CAN1IDAR0_AC2_MASK              4U
#define CAN1IDAR0_AC3_MASK              8U
#define CAN1IDAR0_AC4_MASK              16U
#define CAN1IDAR0_AC5_MASK              32U
#define CAN1IDAR0_AC6_MASK              64U
#define CAN1IDAR0_AC7_MASK              128U


/*** CAN1IDAR1 - MSCAN 1 Identifier Acceptance Register 1; 0x00000191 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR1STR;
extern volatile CAN1IDAR1STR _CAN1IDAR1 @(REG_BASE + 0x00000191UL);
#define CAN1IDAR1                       _CAN1IDAR1.Byte
#define CAN1IDAR1_AC0                   _CAN1IDAR1.Bits.AC0
#define CAN1IDAR1_AC1                   _CAN1IDAR1.Bits.AC1
#define CAN1IDAR1_AC2                   _CAN1IDAR1.Bits.AC2
#define CAN1IDAR1_AC3                   _CAN1IDAR1.Bits.AC3
#define CAN1IDAR1_AC4                   _CAN1IDAR1.Bits.AC4
#define CAN1IDAR1_AC5                   _CAN1IDAR1.Bits.AC5
#define CAN1IDAR1_AC6                   _CAN1IDAR1.Bits.AC6
#define CAN1IDAR1_AC7                   _CAN1IDAR1.Bits.AC7

#define CAN1IDAR1_AC0_MASK              1U
#define CAN1IDAR1_AC1_MASK              2U
#define CAN1IDAR1_AC2_MASK              4U
#define CAN1IDAR1_AC3_MASK              8U
#define CAN1IDAR1_AC4_MASK              16U
#define CAN1IDAR1_AC5_MASK              32U
#define CAN1IDAR1_AC6_MASK              64U
#define CAN1IDAR1_AC7_MASK              128U


/*** CAN1IDAR2 - MSCAN 1 Identifier Acceptance Register 2; 0x00000192 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR2STR;
extern volatile CAN1IDAR2STR _CAN1IDAR2 @(REG_BASE + 0x00000192UL);
#define CAN1IDAR2                       _CAN1IDAR2.Byte
#define CAN1IDAR2_AC0                   _CAN1IDAR2.Bits.AC0
#define CAN1IDAR2_AC1                   _CAN1IDAR2.Bits.AC1
#define CAN1IDAR2_AC2                   _CAN1IDAR2.Bits.AC2
#define CAN1IDAR2_AC3                   _CAN1IDAR2.Bits.AC3
#define CAN1IDAR2_AC4                   _CAN1IDAR2.Bits.AC4
#define CAN1IDAR2_AC5                   _CAN1IDAR2.Bits.AC5
#define CAN1IDAR2_AC6                   _CAN1IDAR2.Bits.AC6
#define CAN1IDAR2_AC7                   _CAN1IDAR2.Bits.AC7

#define CAN1IDAR2_AC0_MASK              1U
#define CAN1IDAR2_AC1_MASK              2U
#define CAN1IDAR2_AC2_MASK              4U
#define CAN1IDAR2_AC3_MASK              8U
#define CAN1IDAR2_AC4_MASK              16U
#define CAN1IDAR2_AC5_MASK              32U
#define CAN1IDAR2_AC6_MASK              64U
#define CAN1IDAR2_AC7_MASK              128U


/*** CAN1IDAR3 - MSCAN 1 Identifier Acceptance Register 3; 0x00000193 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR3STR;
extern volatile CAN1IDAR3STR _CAN1IDAR3 @(REG_BASE + 0x00000193UL);
#define CAN1IDAR3                       _CAN1IDAR3.Byte
#define CAN1IDAR3_AC0                   _CAN1IDAR3.Bits.AC0
#define CAN1IDAR3_AC1                   _CAN1IDAR3.Bits.AC1
#define CAN1IDAR3_AC2                   _CAN1IDAR3.Bits.AC2
#define CAN1IDAR3_AC3                   _CAN1IDAR3.Bits.AC3
#define CAN1IDAR3_AC4                   _CAN1IDAR3.Bits.AC4
#define CAN1IDAR3_AC5                   _CAN1IDAR3.Bits.AC5
#define CAN1IDAR3_AC6                   _CAN1IDAR3.Bits.AC6
#define CAN1IDAR3_AC7                   _CAN1IDAR3.Bits.AC7

#define CAN1IDAR3_AC0_MASK              1U
#define CAN1IDAR3_AC1_MASK              2U
#define CAN1IDAR3_AC2_MASK              4U
#define CAN1IDAR3_AC3_MASK              8U
#define CAN1IDAR3_AC4_MASK              16U
#define CAN1IDAR3_AC5_MASK              32U
#define CAN1IDAR3_AC6_MASK              64U
#define CAN1IDAR3_AC7_MASK              128U


/*** CAN1IDMR0 - MSCAN 1 Identifier Mask Register 0; 0x00000194 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR0STR;
extern volatile CAN1IDMR0STR _CAN1IDMR0 @(REG_BASE + 0x00000194UL);
#define CAN1IDMR0                       _CAN1IDMR0.Byte
#define CAN1IDMR0_AM0                   _CAN1IDMR0.Bits.AM0
#define CAN1IDMR0_AM1                   _CAN1IDMR0.Bits.AM1
#define CAN1IDMR0_AM2                   _CAN1IDMR0.Bits.AM2
#define CAN1IDMR0_AM3                   _CAN1IDMR0.Bits.AM3
#define CAN1IDMR0_AM4                   _CAN1IDMR0.Bits.AM4
#define CAN1IDMR0_AM5                   _CAN1IDMR0.Bits.AM5
#define CAN1IDMR0_AM6                   _CAN1IDMR0.Bits.AM6
#define CAN1IDMR0_AM7                   _CAN1IDMR0.Bits.AM7
/* CAN1IDMR_ARR: Access 4 CAN1IDMRx registers in an array */
#define CAN1IDMR_ARR                    ((volatile byte *) &CAN1IDMR0)

#define CAN1IDMR0_AM0_MASK              1U
#define CAN1IDMR0_AM1_MASK              2U
#define CAN1IDMR0_AM2_MASK              4U
#define CAN1IDMR0_AM3_MASK              8U
#define CAN1IDMR0_AM4_MASK              16U
#define CAN1IDMR0_AM5_MASK              32U
#define CAN1IDMR0_AM6_MASK              64U
#define CAN1IDMR0_AM7_MASK              128U


/*** CAN1IDMR1 - MSCAN 1 Identifier Mask Register 1; 0x00000195 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR1STR;
extern volatile CAN1IDMR1STR _CAN1IDMR1 @(REG_BASE + 0x00000195UL);
#define CAN1IDMR1                       _CAN1IDMR1.Byte
#define CAN1IDMR1_AM0                   _CAN1IDMR1.Bits.AM0
#define CAN1IDMR1_AM1                   _CAN1IDMR1.Bits.AM1
#define CAN1IDMR1_AM2                   _CAN1IDMR1.Bits.AM2
#define CAN1IDMR1_AM3                   _CAN1IDMR1.Bits.AM3
#define CAN1IDMR1_AM4                   _CAN1IDMR1.Bits.AM4
#define CAN1IDMR1_AM5                   _CAN1IDMR1.Bits.AM5
#define CAN1IDMR1_AM6                   _CAN1IDMR1.Bits.AM6
#define CAN1IDMR1_AM7                   _CAN1IDMR1.Bits.AM7

#define CAN1IDMR1_AM0_MASK              1U
#define CAN1IDMR1_AM1_MASK              2U
#define CAN1IDMR1_AM2_MASK              4U
#define CAN1IDMR1_AM3_MASK              8U
#define CAN1IDMR1_AM4_MASK              16U
#define CAN1IDMR1_AM5_MASK              32U
#define CAN1IDMR1_AM6_MASK              64U
#define CAN1IDMR1_AM7_MASK              128U


/*** CAN1IDMR2 - MSCAN 1 Identifier Mask Register 2; 0x00000196 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR2STR;
extern volatile CAN1IDMR2STR _CAN1IDMR2 @(REG_BASE + 0x00000196UL);
#define CAN1IDMR2                       _CAN1IDMR2.Byte
#define CAN1IDMR2_AM0                   _CAN1IDMR2.Bits.AM0
#define CAN1IDMR2_AM1                   _CAN1IDMR2.Bits.AM1
#define CAN1IDMR2_AM2                   _CAN1IDMR2.Bits.AM2
#define CAN1IDMR2_AM3                   _CAN1IDMR2.Bits.AM3
#define CAN1IDMR2_AM4                   _CAN1IDMR2.Bits.AM4
#define CAN1IDMR2_AM5                   _CAN1IDMR2.Bits.AM5
#define CAN1IDMR2_AM6                   _CAN1IDMR2.Bits.AM6
#define CAN1IDMR2_AM7                   _CAN1IDMR2.Bits.AM7

#define CAN1IDMR2_AM0_MASK              1U
#define CAN1IDMR2_AM1_MASK              2U
#define CAN1IDMR2_AM2_MASK              4U
#define CAN1IDMR2_AM3_MASK              8U
#define CAN1IDMR2_AM4_MASK              16U
#define CAN1IDMR2_AM5_MASK              32U
#define CAN1IDMR2_AM6_MASK              64U
#define CAN1IDMR2_AM7_MASK              128U


/*** CAN1IDMR3 - MSCAN 1 Identifier Mask Register 3; 0x00000197 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR3STR;
extern volatile CAN1IDMR3STR _CAN1IDMR3 @(REG_BASE + 0x00000197UL);
#define CAN1IDMR3                       _CAN1IDMR3.Byte
#define CAN1IDMR3_AM0                   _CAN1IDMR3.Bits.AM0
#define CAN1IDMR3_AM1                   _CAN1IDMR3.Bits.AM1
#define CAN1IDMR3_AM2                   _CAN1IDMR3.Bits.AM2
#define CAN1IDMR3_AM3                   _CAN1IDMR3.Bits.AM3
#define CAN1IDMR3_AM4                   _CAN1IDMR3.Bits.AM4
#define CAN1IDMR3_AM5                   _CAN1IDMR3.Bits.AM5
#define CAN1IDMR3_AM6                   _CAN1IDMR3.Bits.AM6
#define CAN1IDMR3_AM7                   _CAN1IDMR3.Bits.AM7

#define CAN1IDMR3_AM0_MASK              1U
#define CAN1IDMR3_AM1_MASK              2U
#define CAN1IDMR3_AM2_MASK              4U
#define CAN1IDMR3_AM3_MASK              8U
#define CAN1IDMR3_AM4_MASK              16U
#define CAN1IDMR3_AM5_MASK              32U
#define CAN1IDMR3_AM6_MASK              64U
#define CAN1IDMR3_AM7_MASK              128U


/*** CAN1IDAR4 - MSCAN 1 Identifier Acceptance Register 4; 0x00000198 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR4STR;
extern volatile CAN1IDAR4STR _CAN1IDAR4 @(REG_BASE + 0x00000198UL);
#define CAN1IDAR4                       _CAN1IDAR4.Byte
#define CAN1IDAR4_AC0                   _CAN1IDAR4.Bits.AC0
#define CAN1IDAR4_AC1                   _CAN1IDAR4.Bits.AC1
#define CAN1IDAR4_AC2                   _CAN1IDAR4.Bits.AC2
#define CAN1IDAR4_AC3                   _CAN1IDAR4.Bits.AC3
#define CAN1IDAR4_AC4                   _CAN1IDAR4.Bits.AC4
#define CAN1IDAR4_AC5                   _CAN1IDAR4.Bits.AC5
#define CAN1IDAR4_AC6                   _CAN1IDAR4.Bits.AC6
#define CAN1IDAR4_AC7                   _CAN1IDAR4.Bits.AC7

#define CAN1IDAR4_AC0_MASK              1U
#define CAN1IDAR4_AC1_MASK              2U
#define CAN1IDAR4_AC2_MASK              4U
#define CAN1IDAR4_AC3_MASK              8U
#define CAN1IDAR4_AC4_MASK              16U
#define CAN1IDAR4_AC5_MASK              32U
#define CAN1IDAR4_AC6_MASK              64U
#define CAN1IDAR4_AC7_MASK              128U


/*** CAN1IDAR5 - MSCAN 1 Identifier Acceptance Register 5; 0x00000199 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR5STR;
extern volatile CAN1IDAR5STR _CAN1IDAR5 @(REG_BASE + 0x00000199UL);
#define CAN1IDAR5                       _CAN1IDAR5.Byte
#define CAN1IDAR5_AC0                   _CAN1IDAR5.Bits.AC0
#define CAN1IDAR5_AC1                   _CAN1IDAR5.Bits.AC1
#define CAN1IDAR5_AC2                   _CAN1IDAR5.Bits.AC2
#define CAN1IDAR5_AC3                   _CAN1IDAR5.Bits.AC3
#define CAN1IDAR5_AC4                   _CAN1IDAR5.Bits.AC4
#define CAN1IDAR5_AC5                   _CAN1IDAR5.Bits.AC5
#define CAN1IDAR5_AC6                   _CAN1IDAR5.Bits.AC6
#define CAN1IDAR5_AC7                   _CAN1IDAR5.Bits.AC7

#define CAN1IDAR5_AC0_MASK              1U
#define CAN1IDAR5_AC1_MASK              2U
#define CAN1IDAR5_AC2_MASK              4U
#define CAN1IDAR5_AC3_MASK              8U
#define CAN1IDAR5_AC4_MASK              16U
#define CAN1IDAR5_AC5_MASK              32U
#define CAN1IDAR5_AC6_MASK              64U
#define CAN1IDAR5_AC7_MASK              128U


/*** CAN1IDAR6 - MSCAN 1 Identifier Acceptance Register 6; 0x0000019A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR6STR;
extern volatile CAN1IDAR6STR _CAN1IDAR6 @(REG_BASE + 0x0000019AUL);
#define CAN1IDAR6                       _CAN1IDAR6.Byte
#define CAN1IDAR6_AC0                   _CAN1IDAR6.Bits.AC0
#define CAN1IDAR6_AC1                   _CAN1IDAR6.Bits.AC1
#define CAN1IDAR6_AC2                   _CAN1IDAR6.Bits.AC2
#define CAN1IDAR6_AC3                   _CAN1IDAR6.Bits.AC3
#define CAN1IDAR6_AC4                   _CAN1IDAR6.Bits.AC4
#define CAN1IDAR6_AC5                   _CAN1IDAR6.Bits.AC5
#define CAN1IDAR6_AC6                   _CAN1IDAR6.Bits.AC6
#define CAN1IDAR6_AC7                   _CAN1IDAR6.Bits.AC7

#define CAN1IDAR6_AC0_MASK              1U
#define CAN1IDAR6_AC1_MASK              2U
#define CAN1IDAR6_AC2_MASK              4U
#define CAN1IDAR6_AC3_MASK              8U
#define CAN1IDAR6_AC4_MASK              16U
#define CAN1IDAR6_AC5_MASK              32U
#define CAN1IDAR6_AC6_MASK              64U
#define CAN1IDAR6_AC7_MASK              128U


/*** CAN1IDAR7 - MSCAN 1 Identifier Acceptance Register 7; 0x0000019B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN1IDAR7STR;
extern volatile CAN1IDAR7STR _CAN1IDAR7 @(REG_BASE + 0x0000019BUL);
#define CAN1IDAR7                       _CAN1IDAR7.Byte
#define CAN1IDAR7_AC0                   _CAN1IDAR7.Bits.AC0
#define CAN1IDAR7_AC1                   _CAN1IDAR7.Bits.AC1
#define CAN1IDAR7_AC2                   _CAN1IDAR7.Bits.AC2
#define CAN1IDAR7_AC3                   _CAN1IDAR7.Bits.AC3
#define CAN1IDAR7_AC4                   _CAN1IDAR7.Bits.AC4
#define CAN1IDAR7_AC5                   _CAN1IDAR7.Bits.AC5
#define CAN1IDAR7_AC6                   _CAN1IDAR7.Bits.AC6
#define CAN1IDAR7_AC7                   _CAN1IDAR7.Bits.AC7

#define CAN1IDAR7_AC0_MASK              1U
#define CAN1IDAR7_AC1_MASK              2U
#define CAN1IDAR7_AC2_MASK              4U
#define CAN1IDAR7_AC3_MASK              8U
#define CAN1IDAR7_AC4_MASK              16U
#define CAN1IDAR7_AC5_MASK              32U
#define CAN1IDAR7_AC6_MASK              64U
#define CAN1IDAR7_AC7_MASK              128U


/*** CAN1IDMR4 - MSCAN 1 Identifier Mask Register 4; 0x0000019C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR4STR;
extern volatile CAN1IDMR4STR _CAN1IDMR4 @(REG_BASE + 0x0000019CUL);
#define CAN1IDMR4                       _CAN1IDMR4.Byte
#define CAN1IDMR4_AM0                   _CAN1IDMR4.Bits.AM0
#define CAN1IDMR4_AM1                   _CAN1IDMR4.Bits.AM1
#define CAN1IDMR4_AM2                   _CAN1IDMR4.Bits.AM2
#define CAN1IDMR4_AM3                   _CAN1IDMR4.Bits.AM3
#define CAN1IDMR4_AM4                   _CAN1IDMR4.Bits.AM4
#define CAN1IDMR4_AM5                   _CAN1IDMR4.Bits.AM5
#define CAN1IDMR4_AM6                   _CAN1IDMR4.Bits.AM6
#define CAN1IDMR4_AM7                   _CAN1IDMR4.Bits.AM7

#define CAN1IDMR4_AM0_MASK              1U
#define CAN1IDMR4_AM1_MASK              2U
#define CAN1IDMR4_AM2_MASK              4U
#define CAN1IDMR4_AM3_MASK              8U
#define CAN1IDMR4_AM4_MASK              16U
#define CAN1IDMR4_AM5_MASK              32U
#define CAN1IDMR4_AM6_MASK              64U
#define CAN1IDMR4_AM7_MASK              128U


/*** CAN1IDMR5 - MSCAN 1 Identifier Mask Register 5; 0x0000019D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR5STR;
extern volatile CAN1IDMR5STR _CAN1IDMR5 @(REG_BASE + 0x0000019DUL);
#define CAN1IDMR5                       _CAN1IDMR5.Byte
#define CAN1IDMR5_AM0                   _CAN1IDMR5.Bits.AM0
#define CAN1IDMR5_AM1                   _CAN1IDMR5.Bits.AM1
#define CAN1IDMR5_AM2                   _CAN1IDMR5.Bits.AM2
#define CAN1IDMR5_AM3                   _CAN1IDMR5.Bits.AM3
#define CAN1IDMR5_AM4                   _CAN1IDMR5.Bits.AM4
#define CAN1IDMR5_AM5                   _CAN1IDMR5.Bits.AM5
#define CAN1IDMR5_AM6                   _CAN1IDMR5.Bits.AM6
#define CAN1IDMR5_AM7                   _CAN1IDMR5.Bits.AM7

#define CAN1IDMR5_AM0_MASK              1U
#define CAN1IDMR5_AM1_MASK              2U
#define CAN1IDMR5_AM2_MASK              4U
#define CAN1IDMR5_AM3_MASK              8U
#define CAN1IDMR5_AM4_MASK              16U
#define CAN1IDMR5_AM5_MASK              32U
#define CAN1IDMR5_AM6_MASK              64U
#define CAN1IDMR5_AM7_MASK              128U


/*** CAN1IDMR6 - MSCAN 1 Identifier Mask Register 6; 0x0000019E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR6STR;
extern volatile CAN1IDMR6STR _CAN1IDMR6 @(REG_BASE + 0x0000019EUL);
#define CAN1IDMR6                       _CAN1IDMR6.Byte
#define CAN1IDMR6_AM0                   _CAN1IDMR6.Bits.AM0
#define CAN1IDMR6_AM1                   _CAN1IDMR6.Bits.AM1
#define CAN1IDMR6_AM2                   _CAN1IDMR6.Bits.AM2
#define CAN1IDMR6_AM3                   _CAN1IDMR6.Bits.AM3
#define CAN1IDMR6_AM4                   _CAN1IDMR6.Bits.AM4
#define CAN1IDMR6_AM5                   _CAN1IDMR6.Bits.AM5
#define CAN1IDMR6_AM6                   _CAN1IDMR6.Bits.AM6
#define CAN1IDMR6_AM7                   _CAN1IDMR6.Bits.AM7

#define CAN1IDMR6_AM0_MASK              1U
#define CAN1IDMR6_AM1_MASK              2U
#define CAN1IDMR6_AM2_MASK              4U
#define CAN1IDMR6_AM3_MASK              8U
#define CAN1IDMR6_AM4_MASK              16U
#define CAN1IDMR6_AM5_MASK              32U
#define CAN1IDMR6_AM6_MASK              64U
#define CAN1IDMR6_AM7_MASK              128U


/*** CAN1IDMR7 - MSCAN 1 Identifier Mask Register 7; 0x0000019F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN1IDMR7STR;
extern volatile CAN1IDMR7STR _CAN1IDMR7 @(REG_BASE + 0x0000019FUL);
#define CAN1IDMR7                       _CAN1IDMR7.Byte
#define CAN1IDMR7_AM0                   _CAN1IDMR7.Bits.AM0
#define CAN1IDMR7_AM1                   _CAN1IDMR7.Bits.AM1
#define CAN1IDMR7_AM2                   _CAN1IDMR7.Bits.AM2
#define CAN1IDMR7_AM3                   _CAN1IDMR7.Bits.AM3
#define CAN1IDMR7_AM4                   _CAN1IDMR7.Bits.AM4
#define CAN1IDMR7_AM5                   _CAN1IDMR7.Bits.AM5
#define CAN1IDMR7_AM6                   _CAN1IDMR7.Bits.AM6
#define CAN1IDMR7_AM7                   _CAN1IDMR7.Bits.AM7

#define CAN1IDMR7_AM0_MASK              1U
#define CAN1IDMR7_AM1_MASK              2U
#define CAN1IDMR7_AM2_MASK              4U
#define CAN1IDMR7_AM3_MASK              8U
#define CAN1IDMR7_AM4_MASK              16U
#define CAN1IDMR7_AM5_MASK              32U
#define CAN1IDMR7_AM6_MASK              64U
#define CAN1IDMR7_AM7_MASK              128U


/*** CAN1RXIDR0 - MSCAN 1 Receive Identifier Register 0; 0x000001A0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN1RXIDR0STR;
extern volatile CAN1RXIDR0STR _CAN1RXIDR0 @(REG_BASE + 0x000001A0UL);
#define CAN1RXIDR0                      _CAN1RXIDR0.Byte
#define CAN1RXIDR0_ID21                 _CAN1RXIDR0.Bits.ID21
#define CAN1RXIDR0_ID22                 _CAN1RXIDR0.Bits.ID22
#define CAN1RXIDR0_ID23                 _CAN1RXIDR0.Bits.ID23
#define CAN1RXIDR0_ID24                 _CAN1RXIDR0.Bits.ID24
#define CAN1RXIDR0_ID25                 _CAN1RXIDR0.Bits.ID25
#define CAN1RXIDR0_ID26                 _CAN1RXIDR0.Bits.ID26
#define CAN1RXIDR0_ID27                 _CAN1RXIDR0.Bits.ID27
#define CAN1RXIDR0_ID28                 _CAN1RXIDR0.Bits.ID28
/* CAN1RXIDR_ARR: Access 4 CAN1RXIDRx registers in an array */
#define CAN1RXIDR_ARR                   ((volatile byte *) &CAN1RXIDR0)

#define CAN1RXIDR0_ID21_MASK            1U
#define CAN1RXIDR0_ID22_MASK            2U
#define CAN1RXIDR0_ID23_MASK            4U
#define CAN1RXIDR0_ID24_MASK            8U
#define CAN1RXIDR0_ID25_MASK            16U
#define CAN1RXIDR0_ID26_MASK            32U
#define CAN1RXIDR0_ID27_MASK            64U
#define CAN1RXIDR0_ID28_MASK            128U


/*** CAN1RXIDR1 - MSCAN 1 Receive Identifier Register 1; 0x000001A1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN1RXIDR1STR;
extern volatile CAN1RXIDR1STR _CAN1RXIDR1 @(REG_BASE + 0x000001A1UL);
#define CAN1RXIDR1                      _CAN1RXIDR1.Byte
#define CAN1RXIDR1_ID15                 _CAN1RXIDR1.Bits.ID15
#define CAN1RXIDR1_ID16                 _CAN1RXIDR1.Bits.ID16
#define CAN1RXIDR1_ID17                 _CAN1RXIDR1.Bits.ID17
#define CAN1RXIDR1_IDE                  _CAN1RXIDR1.Bits.IDE
#define CAN1RXIDR1_SRR                  _CAN1RXIDR1.Bits.SRR
#define CAN1RXIDR1_ID18                 _CAN1RXIDR1.Bits.ID18
#define CAN1RXIDR1_ID19                 _CAN1RXIDR1.Bits.ID19
#define CAN1RXIDR1_ID20                 _CAN1RXIDR1.Bits.ID20
#define CAN1RXIDR1_ID_15                _CAN1RXIDR1.MergedBits.grpID_15
#define CAN1RXIDR1_ID_18                _CAN1RXIDR1.MergedBits.grpID_18
#define CAN1RXIDR1_ID                   CAN1RXIDR1_ID_15

#define CAN1RXIDR1_ID15_MASK            1U
#define CAN1RXIDR1_ID16_MASK            2U
#define CAN1RXIDR1_ID17_MASK            4U
#define CAN1RXIDR1_IDE_MASK             8U
#define CAN1RXIDR1_SRR_MASK             16U
#define CAN1RXIDR1_ID18_MASK            32U
#define CAN1RXIDR1_ID19_MASK            64U
#define CAN1RXIDR1_ID20_MASK            128U
#define CAN1RXIDR1_ID_15_MASK           7U
#define CAN1RXIDR1_ID_15_BITNUM         0U
#define CAN1RXIDR1_ID_18_MASK           224U
#define CAN1RXIDR1_ID_18_BITNUM         5U


/*** CAN1RXIDR2 - MSCAN 1 Receive Identifier Register 2; 0x000001A2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN1RXIDR2STR;
extern volatile CAN1RXIDR2STR _CAN1RXIDR2 @(REG_BASE + 0x000001A2UL);
#define CAN1RXIDR2                      _CAN1RXIDR2.Byte
#define CAN1RXIDR2_ID7                  _CAN1RXIDR2.Bits.ID7
#define CAN1RXIDR2_ID8                  _CAN1RXIDR2.Bits.ID8
#define CAN1RXIDR2_ID9                  _CAN1RXIDR2.Bits.ID9
#define CAN1RXIDR2_ID10                 _CAN1RXIDR2.Bits.ID10
#define CAN1RXIDR2_ID11                 _CAN1RXIDR2.Bits.ID11
#define CAN1RXIDR2_ID12                 _CAN1RXIDR2.Bits.ID12
#define CAN1RXIDR2_ID13                 _CAN1RXIDR2.Bits.ID13
#define CAN1RXIDR2_ID14                 _CAN1RXIDR2.Bits.ID14

#define CAN1RXIDR2_ID7_MASK             1U
#define CAN1RXIDR2_ID8_MASK             2U
#define CAN1RXIDR2_ID9_MASK             4U
#define CAN1RXIDR2_ID10_MASK            8U
#define CAN1RXIDR2_ID11_MASK            16U
#define CAN1RXIDR2_ID12_MASK            32U
#define CAN1RXIDR2_ID13_MASK            64U
#define CAN1RXIDR2_ID14_MASK            128U


/*** CAN1RXIDR3 - MSCAN 1 Receive Identifier Register 3; 0x000001A3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN1RXIDR3STR;
extern volatile CAN1RXIDR3STR _CAN1RXIDR3 @(REG_BASE + 0x000001A3UL);
#define CAN1RXIDR3                      _CAN1RXIDR3.Byte
#define CAN1RXIDR3_RTR                  _CAN1RXIDR3.Bits.RTR
#define CAN1RXIDR3_ID0                  _CAN1RXIDR3.Bits.ID0
#define CAN1RXIDR3_ID1                  _CAN1RXIDR3.Bits.ID1
#define CAN1RXIDR3_ID2                  _CAN1RXIDR3.Bits.ID2
#define CAN1RXIDR3_ID3                  _CAN1RXIDR3.Bits.ID3
#define CAN1RXIDR3_ID4                  _CAN1RXIDR3.Bits.ID4
#define CAN1RXIDR3_ID5                  _CAN1RXIDR3.Bits.ID5
#define CAN1RXIDR3_ID6                  _CAN1RXIDR3.Bits.ID6
#define CAN1RXIDR3_ID                   _CAN1RXIDR3.MergedBits.grpID

#define CAN1RXIDR3_RTR_MASK             1U
#define CAN1RXIDR3_ID0_MASK             2U
#define CAN1RXIDR3_ID1_MASK             4U
#define CAN1RXIDR3_ID2_MASK             8U
#define CAN1RXIDR3_ID3_MASK             16U
#define CAN1RXIDR3_ID4_MASK             32U
#define CAN1RXIDR3_ID5_MASK             64U
#define CAN1RXIDR3_ID6_MASK             128U
#define CAN1RXIDR3_ID_MASK              254U
#define CAN1RXIDR3_ID_BITNUM            1U


/*** CAN1RXDSR0 - MSCAN 1 Receive Data Segment Register 0; 0x000001A4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR0STR;
extern volatile CAN1RXDSR0STR _CAN1RXDSR0 @(REG_BASE + 0x000001A4UL);
#define CAN1RXDSR0                      _CAN1RXDSR0.Byte
#define CAN1RXDSR0_DB0                  _CAN1RXDSR0.Bits.DB0
#define CAN1RXDSR0_DB1                  _CAN1RXDSR0.Bits.DB1
#define CAN1RXDSR0_DB2                  _CAN1RXDSR0.Bits.DB2
#define CAN1RXDSR0_DB3                  _CAN1RXDSR0.Bits.DB3
#define CAN1RXDSR0_DB4                  _CAN1RXDSR0.Bits.DB4
#define CAN1RXDSR0_DB5                  _CAN1RXDSR0.Bits.DB5
#define CAN1RXDSR0_DB6                  _CAN1RXDSR0.Bits.DB6
#define CAN1RXDSR0_DB7                  _CAN1RXDSR0.Bits.DB7
/* CAN1RXDSR_ARR: Access 8 CAN1RXDSRx registers in an array */
#define CAN1RXDSR_ARR                   ((volatile byte *) &CAN1RXDSR0)

#define CAN1RXDSR0_DB0_MASK             1U
#define CAN1RXDSR0_DB1_MASK             2U
#define CAN1RXDSR0_DB2_MASK             4U
#define CAN1RXDSR0_DB3_MASK             8U
#define CAN1RXDSR0_DB4_MASK             16U
#define CAN1RXDSR0_DB5_MASK             32U
#define CAN1RXDSR0_DB6_MASK             64U
#define CAN1RXDSR0_DB7_MASK             128U


/*** CAN1RXDSR1 - MSCAN 1 Receive Data Segment Register 1; 0x000001A5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR1STR;
extern volatile CAN1RXDSR1STR _CAN1RXDSR1 @(REG_BASE + 0x000001A5UL);
#define CAN1RXDSR1                      _CAN1RXDSR1.Byte
#define CAN1RXDSR1_DB0                  _CAN1RXDSR1.Bits.DB0
#define CAN1RXDSR1_DB1                  _CAN1RXDSR1.Bits.DB1
#define CAN1RXDSR1_DB2                  _CAN1RXDSR1.Bits.DB2
#define CAN1RXDSR1_DB3                  _CAN1RXDSR1.Bits.DB3
#define CAN1RXDSR1_DB4                  _CAN1RXDSR1.Bits.DB4
#define CAN1RXDSR1_DB5                  _CAN1RXDSR1.Bits.DB5
#define CAN1RXDSR1_DB6                  _CAN1RXDSR1.Bits.DB6
#define CAN1RXDSR1_DB7                  _CAN1RXDSR1.Bits.DB7

#define CAN1RXDSR1_DB0_MASK             1U
#define CAN1RXDSR1_DB1_MASK             2U
#define CAN1RXDSR1_DB2_MASK             4U
#define CAN1RXDSR1_DB3_MASK             8U
#define CAN1RXDSR1_DB4_MASK             16U
#define CAN1RXDSR1_DB5_MASK             32U
#define CAN1RXDSR1_DB6_MASK             64U
#define CAN1RXDSR1_DB7_MASK             128U


/*** CAN1RXDSR2 - MSCAN 1 Receive Data Segment Register 2; 0x000001A6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR2STR;
extern volatile CAN1RXDSR2STR _CAN1RXDSR2 @(REG_BASE + 0x000001A6UL);
#define CAN1RXDSR2                      _CAN1RXDSR2.Byte
#define CAN1RXDSR2_DB0                  _CAN1RXDSR2.Bits.DB0
#define CAN1RXDSR2_DB1                  _CAN1RXDSR2.Bits.DB1
#define CAN1RXDSR2_DB2                  _CAN1RXDSR2.Bits.DB2
#define CAN1RXDSR2_DB3                  _CAN1RXDSR2.Bits.DB3
#define CAN1RXDSR2_DB4                  _CAN1RXDSR2.Bits.DB4
#define CAN1RXDSR2_DB5                  _CAN1RXDSR2.Bits.DB5
#define CAN1RXDSR2_DB6                  _CAN1RXDSR2.Bits.DB6
#define CAN1RXDSR2_DB7                  _CAN1RXDSR2.Bits.DB7

#define CAN1RXDSR2_DB0_MASK             1U
#define CAN1RXDSR2_DB1_MASK             2U
#define CAN1RXDSR2_DB2_MASK             4U
#define CAN1RXDSR2_DB3_MASK             8U
#define CAN1RXDSR2_DB4_MASK             16U
#define CAN1RXDSR2_DB5_MASK             32U
#define CAN1RXDSR2_DB6_MASK             64U
#define CAN1RXDSR2_DB7_MASK             128U


/*** CAN1RXDSR3 - MSCAN 1 Receive Data Segment Register 3; 0x000001A7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR3STR;
extern volatile CAN1RXDSR3STR _CAN1RXDSR3 @(REG_BASE + 0x000001A7UL);
#define CAN1RXDSR3                      _CAN1RXDSR3.Byte
#define CAN1RXDSR3_DB0                  _CAN1RXDSR3.Bits.DB0
#define CAN1RXDSR3_DB1                  _CAN1RXDSR3.Bits.DB1
#define CAN1RXDSR3_DB2                  _CAN1RXDSR3.Bits.DB2
#define CAN1RXDSR3_DB3                  _CAN1RXDSR3.Bits.DB3
#define CAN1RXDSR3_DB4                  _CAN1RXDSR3.Bits.DB4
#define CAN1RXDSR3_DB5                  _CAN1RXDSR3.Bits.DB5
#define CAN1RXDSR3_DB6                  _CAN1RXDSR3.Bits.DB6
#define CAN1RXDSR3_DB7                  _CAN1RXDSR3.Bits.DB7

#define CAN1RXDSR3_DB0_MASK             1U
#define CAN1RXDSR3_DB1_MASK             2U
#define CAN1RXDSR3_DB2_MASK             4U
#define CAN1RXDSR3_DB3_MASK             8U
#define CAN1RXDSR3_DB4_MASK             16U
#define CAN1RXDSR3_DB5_MASK             32U
#define CAN1RXDSR3_DB6_MASK             64U
#define CAN1RXDSR3_DB7_MASK             128U


/*** CAN1RXDSR4 - MSCAN 1 Receive Data Segment Register 4; 0x000001A8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR4STR;
extern volatile CAN1RXDSR4STR _CAN1RXDSR4 @(REG_BASE + 0x000001A8UL);
#define CAN1RXDSR4                      _CAN1RXDSR4.Byte
#define CAN1RXDSR4_DB0                  _CAN1RXDSR4.Bits.DB0
#define CAN1RXDSR4_DB1                  _CAN1RXDSR4.Bits.DB1
#define CAN1RXDSR4_DB2                  _CAN1RXDSR4.Bits.DB2
#define CAN1RXDSR4_DB3                  _CAN1RXDSR4.Bits.DB3
#define CAN1RXDSR4_DB4                  _CAN1RXDSR4.Bits.DB4
#define CAN1RXDSR4_DB5                  _CAN1RXDSR4.Bits.DB5
#define CAN1RXDSR4_DB6                  _CAN1RXDSR4.Bits.DB6
#define CAN1RXDSR4_DB7                  _CAN1RXDSR4.Bits.DB7

#define CAN1RXDSR4_DB0_MASK             1U
#define CAN1RXDSR4_DB1_MASK             2U
#define CAN1RXDSR4_DB2_MASK             4U
#define CAN1RXDSR4_DB3_MASK             8U
#define CAN1RXDSR4_DB4_MASK             16U
#define CAN1RXDSR4_DB5_MASK             32U
#define CAN1RXDSR4_DB6_MASK             64U
#define CAN1RXDSR4_DB7_MASK             128U


/*** CAN1RXDSR5 - MSCAN 1 Receive Data Segment Register 5; 0x000001A9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR5STR;
extern volatile CAN1RXDSR5STR _CAN1RXDSR5 @(REG_BASE + 0x000001A9UL);
#define CAN1RXDSR5                      _CAN1RXDSR5.Byte
#define CAN1RXDSR5_DB0                  _CAN1RXDSR5.Bits.DB0
#define CAN1RXDSR5_DB1                  _CAN1RXDSR5.Bits.DB1
#define CAN1RXDSR5_DB2                  _CAN1RXDSR5.Bits.DB2
#define CAN1RXDSR5_DB3                  _CAN1RXDSR5.Bits.DB3
#define CAN1RXDSR5_DB4                  _CAN1RXDSR5.Bits.DB4
#define CAN1RXDSR5_DB5                  _CAN1RXDSR5.Bits.DB5
#define CAN1RXDSR5_DB6                  _CAN1RXDSR5.Bits.DB6
#define CAN1RXDSR5_DB7                  _CAN1RXDSR5.Bits.DB7

#define CAN1RXDSR5_DB0_MASK             1U
#define CAN1RXDSR5_DB1_MASK             2U
#define CAN1RXDSR5_DB2_MASK             4U
#define CAN1RXDSR5_DB3_MASK             8U
#define CAN1RXDSR5_DB4_MASK             16U
#define CAN1RXDSR5_DB5_MASK             32U
#define CAN1RXDSR5_DB6_MASK             64U
#define CAN1RXDSR5_DB7_MASK             128U


/*** CAN1RXDSR6 - MSCAN 1 Receive Data Segment Register 6; 0x000001AA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR6STR;
extern volatile CAN1RXDSR6STR _CAN1RXDSR6 @(REG_BASE + 0x000001AAUL);
#define CAN1RXDSR6                      _CAN1RXDSR6.Byte
#define CAN1RXDSR6_DB0                  _CAN1RXDSR6.Bits.DB0
#define CAN1RXDSR6_DB1                  _CAN1RXDSR6.Bits.DB1
#define CAN1RXDSR6_DB2                  _CAN1RXDSR6.Bits.DB2
#define CAN1RXDSR6_DB3                  _CAN1RXDSR6.Bits.DB3
#define CAN1RXDSR6_DB4                  _CAN1RXDSR6.Bits.DB4
#define CAN1RXDSR6_DB5                  _CAN1RXDSR6.Bits.DB5
#define CAN1RXDSR6_DB6                  _CAN1RXDSR6.Bits.DB6
#define CAN1RXDSR6_DB7                  _CAN1RXDSR6.Bits.DB7

#define CAN1RXDSR6_DB0_MASK             1U
#define CAN1RXDSR6_DB1_MASK             2U
#define CAN1RXDSR6_DB2_MASK             4U
#define CAN1RXDSR6_DB3_MASK             8U
#define CAN1RXDSR6_DB4_MASK             16U
#define CAN1RXDSR6_DB5_MASK             32U
#define CAN1RXDSR6_DB6_MASK             64U
#define CAN1RXDSR6_DB7_MASK             128U


/*** CAN1RXDSR7 - MSCAN 1 Receive Data Segment Register 7; 0x000001AB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1RXDSR7STR;
extern volatile CAN1RXDSR7STR _CAN1RXDSR7 @(REG_BASE + 0x000001ABUL);
#define CAN1RXDSR7                      _CAN1RXDSR7.Byte
#define CAN1RXDSR7_DB0                  _CAN1RXDSR7.Bits.DB0
#define CAN1RXDSR7_DB1                  _CAN1RXDSR7.Bits.DB1
#define CAN1RXDSR7_DB2                  _CAN1RXDSR7.Bits.DB2
#define CAN1RXDSR7_DB3                  _CAN1RXDSR7.Bits.DB3
#define CAN1RXDSR7_DB4                  _CAN1RXDSR7.Bits.DB4
#define CAN1RXDSR7_DB5                  _CAN1RXDSR7.Bits.DB5
#define CAN1RXDSR7_DB6                  _CAN1RXDSR7.Bits.DB6
#define CAN1RXDSR7_DB7                  _CAN1RXDSR7.Bits.DB7

#define CAN1RXDSR7_DB0_MASK             1U
#define CAN1RXDSR7_DB1_MASK             2U
#define CAN1RXDSR7_DB2_MASK             4U
#define CAN1RXDSR7_DB3_MASK             8U
#define CAN1RXDSR7_DB4_MASK             16U
#define CAN1RXDSR7_DB5_MASK             32U
#define CAN1RXDSR7_DB6_MASK             64U
#define CAN1RXDSR7_DB7_MASK             128U


/*** CAN1RXDLR - MSCAN 1 Receive Data Length Register; 0x000001AC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1RXDLRSTR;
extern volatile CAN1RXDLRSTR _CAN1RXDLR @(REG_BASE + 0x000001ACUL);
#define CAN1RXDLR                       _CAN1RXDLR.Byte
#define CAN1RXDLR_DLC0                  _CAN1RXDLR.Bits.DLC0
#define CAN1RXDLR_DLC1                  _CAN1RXDLR.Bits.DLC1
#define CAN1RXDLR_DLC2                  _CAN1RXDLR.Bits.DLC2
#define CAN1RXDLR_DLC3                  _CAN1RXDLR.Bits.DLC3
#define CAN1RXDLR_DLC                   _CAN1RXDLR.MergedBits.grpDLC

#define CAN1RXDLR_DLC0_MASK             1U
#define CAN1RXDLR_DLC1_MASK             2U
#define CAN1RXDLR_DLC2_MASK             4U
#define CAN1RXDLR_DLC3_MASK             8U
#define CAN1RXDLR_DLC_MASK              15U
#define CAN1RXDLR_DLC_BITNUM            0U


/*** CAN1RXTSR - MSCAN 1 Receive Time Stamp Register; 0x000001AE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN1RXTSRH - MSCAN 1 Receive Time Stamp Register High; 0x000001AE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN1RXTSRHSTR;
    #define CAN1RXTSRH                  _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Byte
    #define CAN1RXTSRH_TSR8             _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR8
    #define CAN1RXTSRH_TSR9             _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR9
    #define CAN1RXTSRH_TSR10            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR10
    #define CAN1RXTSRH_TSR11            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR11
    #define CAN1RXTSRH_TSR12            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR12
    #define CAN1RXTSRH_TSR13            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR13
    #define CAN1RXTSRH_TSR14            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR14
    #define CAN1RXTSRH_TSR15            _CAN1RXTSR.Overlap_STR.CAN1RXTSRHSTR.Bits.TSR15
    
    #define CAN1RXTSRH_TSR8_MASK        1U
    #define CAN1RXTSRH_TSR9_MASK        2U
    #define CAN1RXTSRH_TSR10_MASK       4U
    #define CAN1RXTSRH_TSR11_MASK       8U
    #define CAN1RXTSRH_TSR12_MASK       16U
    #define CAN1RXTSRH_TSR13_MASK       32U
    #define CAN1RXTSRH_TSR14_MASK       64U
    #define CAN1RXTSRH_TSR15_MASK       128U
    

    /*** CAN1RXTSRL - MSCAN 1 Receive Time Stamp Register Low; 0x000001AF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN1RXTSRLSTR;
    #define CAN1RXTSRL                  _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Byte
    #define CAN1RXTSRL_TSR0             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR0
    #define CAN1RXTSRL_TSR1             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR1
    #define CAN1RXTSRL_TSR2             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR2
    #define CAN1RXTSRL_TSR3             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR3
    #define CAN1RXTSRL_TSR4             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR4
    #define CAN1RXTSRL_TSR5             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR5
    #define CAN1RXTSRL_TSR6             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR6
    #define CAN1RXTSRL_TSR7             _CAN1RXTSR.Overlap_STR.CAN1RXTSRLSTR.Bits.TSR7
    
    #define CAN1RXTSRL_TSR0_MASK        1U
    #define CAN1RXTSRL_TSR1_MASK        2U
    #define CAN1RXTSRL_TSR2_MASK        4U
    #define CAN1RXTSRL_TSR3_MASK        8U
    #define CAN1RXTSRL_TSR4_MASK        16U
    #define CAN1RXTSRL_TSR5_MASK        32U
    #define CAN1RXTSRL_TSR6_MASK        64U
    #define CAN1RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN1RXTSRSTR;
extern volatile CAN1RXTSRSTR _CAN1RXTSR @(REG_BASE + 0x000001AEUL);
#define CAN1RXTSR                       _CAN1RXTSR.Word
#define CAN1RXTSR_TSR0                  _CAN1RXTSR.Bits.TSR0
#define CAN1RXTSR_TSR1                  _CAN1RXTSR.Bits.TSR1
#define CAN1RXTSR_TSR2                  _CAN1RXTSR.Bits.TSR2
#define CAN1RXTSR_TSR3                  _CAN1RXTSR.Bits.TSR3
#define CAN1RXTSR_TSR4                  _CAN1RXTSR.Bits.TSR4
#define CAN1RXTSR_TSR5                  _CAN1RXTSR.Bits.TSR5
#define CAN1RXTSR_TSR6                  _CAN1RXTSR.Bits.TSR6
#define CAN1RXTSR_TSR7                  _CAN1RXTSR.Bits.TSR7
#define CAN1RXTSR_TSR8                  _CAN1RXTSR.Bits.TSR8
#define CAN1RXTSR_TSR9                  _CAN1RXTSR.Bits.TSR9
#define CAN1RXTSR_TSR10                 _CAN1RXTSR.Bits.TSR10
#define CAN1RXTSR_TSR11                 _CAN1RXTSR.Bits.TSR11
#define CAN1RXTSR_TSR12                 _CAN1RXTSR.Bits.TSR12
#define CAN1RXTSR_TSR13                 _CAN1RXTSR.Bits.TSR13
#define CAN1RXTSR_TSR14                 _CAN1RXTSR.Bits.TSR14
#define CAN1RXTSR_TSR15                 _CAN1RXTSR.Bits.TSR15

#define CAN1RXTSR_TSR0_MASK             1U
#define CAN1RXTSR_TSR1_MASK             2U
#define CAN1RXTSR_TSR2_MASK             4U
#define CAN1RXTSR_TSR3_MASK             8U
#define CAN1RXTSR_TSR4_MASK             16U
#define CAN1RXTSR_TSR5_MASK             32U
#define CAN1RXTSR_TSR6_MASK             64U
#define CAN1RXTSR_TSR7_MASK             128U
#define CAN1RXTSR_TSR8_MASK             256U
#define CAN1RXTSR_TSR9_MASK             512U
#define CAN1RXTSR_TSR10_MASK            1024U
#define CAN1RXTSR_TSR11_MASK            2048U
#define CAN1RXTSR_TSR12_MASK            4096U
#define CAN1RXTSR_TSR13_MASK            8192U
#define CAN1RXTSR_TSR14_MASK            16384U
#define CAN1RXTSR_TSR15_MASK            32768U


/*** CAN1TXIDR0 - MSCAN 1 Transmit Identifier Register 0; 0x000001B0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN1TXIDR0STR;
extern volatile CAN1TXIDR0STR _CAN1TXIDR0 @(REG_BASE + 0x000001B0UL);
#define CAN1TXIDR0                      _CAN1TXIDR0.Byte
#define CAN1TXIDR0_ID21                 _CAN1TXIDR0.Bits.ID21
#define CAN1TXIDR0_ID22                 _CAN1TXIDR0.Bits.ID22
#define CAN1TXIDR0_ID23                 _CAN1TXIDR0.Bits.ID23
#define CAN1TXIDR0_ID24                 _CAN1TXIDR0.Bits.ID24
#define CAN1TXIDR0_ID25                 _CAN1TXIDR0.Bits.ID25
#define CAN1TXIDR0_ID26                 _CAN1TXIDR0.Bits.ID26
#define CAN1TXIDR0_ID27                 _CAN1TXIDR0.Bits.ID27
#define CAN1TXIDR0_ID28                 _CAN1TXIDR0.Bits.ID28
/* CAN1TXIDR_ARR: Access 4 CAN1TXIDRx registers in an array */
#define CAN1TXIDR_ARR                   ((volatile byte *) &CAN1TXIDR0)

#define CAN1TXIDR0_ID21_MASK            1U
#define CAN1TXIDR0_ID22_MASK            2U
#define CAN1TXIDR0_ID23_MASK            4U
#define CAN1TXIDR0_ID24_MASK            8U
#define CAN1TXIDR0_ID25_MASK            16U
#define CAN1TXIDR0_ID26_MASK            32U
#define CAN1TXIDR0_ID27_MASK            64U
#define CAN1TXIDR0_ID28_MASK            128U


/*** CAN1TXIDR1 - MSCAN 1 Transmit Identifier Register 1; 0x000001B1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN1TXIDR1STR;
extern volatile CAN1TXIDR1STR _CAN1TXIDR1 @(REG_BASE + 0x000001B1UL);
#define CAN1TXIDR1                      _CAN1TXIDR1.Byte
#define CAN1TXIDR1_ID15                 _CAN1TXIDR1.Bits.ID15
#define CAN1TXIDR1_ID16                 _CAN1TXIDR1.Bits.ID16
#define CAN1TXIDR1_ID17                 _CAN1TXIDR1.Bits.ID17
#define CAN1TXIDR1_IDE                  _CAN1TXIDR1.Bits.IDE
#define CAN1TXIDR1_SRR                  _CAN1TXIDR1.Bits.SRR
#define CAN1TXIDR1_ID18                 _CAN1TXIDR1.Bits.ID18
#define CAN1TXIDR1_ID19                 _CAN1TXIDR1.Bits.ID19
#define CAN1TXIDR1_ID20                 _CAN1TXIDR1.Bits.ID20
#define CAN1TXIDR1_ID_15                _CAN1TXIDR1.MergedBits.grpID_15
#define CAN1TXIDR1_ID_18                _CAN1TXIDR1.MergedBits.grpID_18
#define CAN1TXIDR1_ID                   CAN1TXIDR1_ID_15

#define CAN1TXIDR1_ID15_MASK            1U
#define CAN1TXIDR1_ID16_MASK            2U
#define CAN1TXIDR1_ID17_MASK            4U
#define CAN1TXIDR1_IDE_MASK             8U
#define CAN1TXIDR1_SRR_MASK             16U
#define CAN1TXIDR1_ID18_MASK            32U
#define CAN1TXIDR1_ID19_MASK            64U
#define CAN1TXIDR1_ID20_MASK            128U
#define CAN1TXIDR1_ID_15_MASK           7U
#define CAN1TXIDR1_ID_15_BITNUM         0U
#define CAN1TXIDR1_ID_18_MASK           224U
#define CAN1TXIDR1_ID_18_BITNUM         5U


/*** CAN1TXIDR2 - MSCAN 1 Transmit Identifier Register 2; 0x000001B2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN1TXIDR2STR;
extern volatile CAN1TXIDR2STR _CAN1TXIDR2 @(REG_BASE + 0x000001B2UL);
#define CAN1TXIDR2                      _CAN1TXIDR2.Byte
#define CAN1TXIDR2_ID7                  _CAN1TXIDR2.Bits.ID7
#define CAN1TXIDR2_ID8                  _CAN1TXIDR2.Bits.ID8
#define CAN1TXIDR2_ID9                  _CAN1TXIDR2.Bits.ID9
#define CAN1TXIDR2_ID10                 _CAN1TXIDR2.Bits.ID10
#define CAN1TXIDR2_ID11                 _CAN1TXIDR2.Bits.ID11
#define CAN1TXIDR2_ID12                 _CAN1TXIDR2.Bits.ID12
#define CAN1TXIDR2_ID13                 _CAN1TXIDR2.Bits.ID13
#define CAN1TXIDR2_ID14                 _CAN1TXIDR2.Bits.ID14

#define CAN1TXIDR2_ID7_MASK             1U
#define CAN1TXIDR2_ID8_MASK             2U
#define CAN1TXIDR2_ID9_MASK             4U
#define CAN1TXIDR2_ID10_MASK            8U
#define CAN1TXIDR2_ID11_MASK            16U
#define CAN1TXIDR2_ID12_MASK            32U
#define CAN1TXIDR2_ID13_MASK            64U
#define CAN1TXIDR2_ID14_MASK            128U


/*** CAN1TXIDR3 - MSCAN 1 Transmit Identifier Register 3; 0x000001B3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN1TXIDR3STR;
extern volatile CAN1TXIDR3STR _CAN1TXIDR3 @(REG_BASE + 0x000001B3UL);
#define CAN1TXIDR3                      _CAN1TXIDR3.Byte
#define CAN1TXIDR3_RTR                  _CAN1TXIDR3.Bits.RTR
#define CAN1TXIDR3_ID0                  _CAN1TXIDR3.Bits.ID0
#define CAN1TXIDR3_ID1                  _CAN1TXIDR3.Bits.ID1
#define CAN1TXIDR3_ID2                  _CAN1TXIDR3.Bits.ID2
#define CAN1TXIDR3_ID3                  _CAN1TXIDR3.Bits.ID3
#define CAN1TXIDR3_ID4                  _CAN1TXIDR3.Bits.ID4
#define CAN1TXIDR3_ID5                  _CAN1TXIDR3.Bits.ID5
#define CAN1TXIDR3_ID6                  _CAN1TXIDR3.Bits.ID6
#define CAN1TXIDR3_ID                   _CAN1TXIDR3.MergedBits.grpID

#define CAN1TXIDR3_RTR_MASK             1U
#define CAN1TXIDR3_ID0_MASK             2U
#define CAN1TXIDR3_ID1_MASK             4U
#define CAN1TXIDR3_ID2_MASK             8U
#define CAN1TXIDR3_ID3_MASK             16U
#define CAN1TXIDR3_ID4_MASK             32U
#define CAN1TXIDR3_ID5_MASK             64U
#define CAN1TXIDR3_ID6_MASK             128U
#define CAN1TXIDR3_ID_MASK              254U
#define CAN1TXIDR3_ID_BITNUM            1U


/*** CAN1TXDSR0 - MSCAN 1 Transmit Data Segment Register 0; 0x000001B4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR0STR;
extern volatile CAN1TXDSR0STR _CAN1TXDSR0 @(REG_BASE + 0x000001B4UL);
#define CAN1TXDSR0                      _CAN1TXDSR0.Byte
#define CAN1TXDSR0_DB0                  _CAN1TXDSR0.Bits.DB0
#define CAN1TXDSR0_DB1                  _CAN1TXDSR0.Bits.DB1
#define CAN1TXDSR0_DB2                  _CAN1TXDSR0.Bits.DB2
#define CAN1TXDSR0_DB3                  _CAN1TXDSR0.Bits.DB3
#define CAN1TXDSR0_DB4                  _CAN1TXDSR0.Bits.DB4
#define CAN1TXDSR0_DB5                  _CAN1TXDSR0.Bits.DB5
#define CAN1TXDSR0_DB6                  _CAN1TXDSR0.Bits.DB6
#define CAN1TXDSR0_DB7                  _CAN1TXDSR0.Bits.DB7
/* CAN1TXDSR_ARR: Access 8 CAN1TXDSRx registers in an array */
#define CAN1TXDSR_ARR                   ((volatile byte *) &CAN1TXDSR0)

#define CAN1TXDSR0_DB0_MASK             1U
#define CAN1TXDSR0_DB1_MASK             2U
#define CAN1TXDSR0_DB2_MASK             4U
#define CAN1TXDSR0_DB3_MASK             8U
#define CAN1TXDSR0_DB4_MASK             16U
#define CAN1TXDSR0_DB5_MASK             32U
#define CAN1TXDSR0_DB6_MASK             64U
#define CAN1TXDSR0_DB7_MASK             128U


/*** CAN1TXDSR1 - MSCAN 1 Transmit Data Segment Register 1; 0x000001B5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR1STR;
extern volatile CAN1TXDSR1STR _CAN1TXDSR1 @(REG_BASE + 0x000001B5UL);
#define CAN1TXDSR1                      _CAN1TXDSR1.Byte
#define CAN1TXDSR1_DB0                  _CAN1TXDSR1.Bits.DB0
#define CAN1TXDSR1_DB1                  _CAN1TXDSR1.Bits.DB1
#define CAN1TXDSR1_DB2                  _CAN1TXDSR1.Bits.DB2
#define CAN1TXDSR1_DB3                  _CAN1TXDSR1.Bits.DB3
#define CAN1TXDSR1_DB4                  _CAN1TXDSR1.Bits.DB4
#define CAN1TXDSR1_DB5                  _CAN1TXDSR1.Bits.DB5
#define CAN1TXDSR1_DB6                  _CAN1TXDSR1.Bits.DB6
#define CAN1TXDSR1_DB7                  _CAN1TXDSR1.Bits.DB7

#define CAN1TXDSR1_DB0_MASK             1U
#define CAN1TXDSR1_DB1_MASK             2U
#define CAN1TXDSR1_DB2_MASK             4U
#define CAN1TXDSR1_DB3_MASK             8U
#define CAN1TXDSR1_DB4_MASK             16U
#define CAN1TXDSR1_DB5_MASK             32U
#define CAN1TXDSR1_DB6_MASK             64U
#define CAN1TXDSR1_DB7_MASK             128U


/*** CAN1TXDSR2 - MSCAN 1 Transmit Data Segment Register 2; 0x000001B6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR2STR;
extern volatile CAN1TXDSR2STR _CAN1TXDSR2 @(REG_BASE + 0x000001B6UL);
#define CAN1TXDSR2                      _CAN1TXDSR2.Byte
#define CAN1TXDSR2_DB0                  _CAN1TXDSR2.Bits.DB0
#define CAN1TXDSR2_DB1                  _CAN1TXDSR2.Bits.DB1
#define CAN1TXDSR2_DB2                  _CAN1TXDSR2.Bits.DB2
#define CAN1TXDSR2_DB3                  _CAN1TXDSR2.Bits.DB3
#define CAN1TXDSR2_DB4                  _CAN1TXDSR2.Bits.DB4
#define CAN1TXDSR2_DB5                  _CAN1TXDSR2.Bits.DB5
#define CAN1TXDSR2_DB6                  _CAN1TXDSR2.Bits.DB6
#define CAN1TXDSR2_DB7                  _CAN1TXDSR2.Bits.DB7

#define CAN1TXDSR2_DB0_MASK             1U
#define CAN1TXDSR2_DB1_MASK             2U
#define CAN1TXDSR2_DB2_MASK             4U
#define CAN1TXDSR2_DB3_MASK             8U
#define CAN1TXDSR2_DB4_MASK             16U
#define CAN1TXDSR2_DB5_MASK             32U
#define CAN1TXDSR2_DB6_MASK             64U
#define CAN1TXDSR2_DB7_MASK             128U


/*** CAN1TXDSR3 - MSCAN 1 Transmit Data Segment Register 3; 0x000001B7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR3STR;
extern volatile CAN1TXDSR3STR _CAN1TXDSR3 @(REG_BASE + 0x000001B7UL);
#define CAN1TXDSR3                      _CAN1TXDSR3.Byte
#define CAN1TXDSR3_DB0                  _CAN1TXDSR3.Bits.DB0
#define CAN1TXDSR3_DB1                  _CAN1TXDSR3.Bits.DB1
#define CAN1TXDSR3_DB2                  _CAN1TXDSR3.Bits.DB2
#define CAN1TXDSR3_DB3                  _CAN1TXDSR3.Bits.DB3
#define CAN1TXDSR3_DB4                  _CAN1TXDSR3.Bits.DB4
#define CAN1TXDSR3_DB5                  _CAN1TXDSR3.Bits.DB5
#define CAN1TXDSR3_DB6                  _CAN1TXDSR3.Bits.DB6
#define CAN1TXDSR3_DB7                  _CAN1TXDSR3.Bits.DB7

#define CAN1TXDSR3_DB0_MASK             1U
#define CAN1TXDSR3_DB1_MASK             2U
#define CAN1TXDSR3_DB2_MASK             4U
#define CAN1TXDSR3_DB3_MASK             8U
#define CAN1TXDSR3_DB4_MASK             16U
#define CAN1TXDSR3_DB5_MASK             32U
#define CAN1TXDSR3_DB6_MASK             64U
#define CAN1TXDSR3_DB7_MASK             128U


/*** CAN1TXDSR4 - MSCAN 1 Transmit Data Segment Register 4; 0x000001B8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR4STR;
extern volatile CAN1TXDSR4STR _CAN1TXDSR4 @(REG_BASE + 0x000001B8UL);
#define CAN1TXDSR4                      _CAN1TXDSR4.Byte
#define CAN1TXDSR4_DB0                  _CAN1TXDSR4.Bits.DB0
#define CAN1TXDSR4_DB1                  _CAN1TXDSR4.Bits.DB1
#define CAN1TXDSR4_DB2                  _CAN1TXDSR4.Bits.DB2
#define CAN1TXDSR4_DB3                  _CAN1TXDSR4.Bits.DB3
#define CAN1TXDSR4_DB4                  _CAN1TXDSR4.Bits.DB4
#define CAN1TXDSR4_DB5                  _CAN1TXDSR4.Bits.DB5
#define CAN1TXDSR4_DB6                  _CAN1TXDSR4.Bits.DB6
#define CAN1TXDSR4_DB7                  _CAN1TXDSR4.Bits.DB7

#define CAN1TXDSR4_DB0_MASK             1U
#define CAN1TXDSR4_DB1_MASK             2U
#define CAN1TXDSR4_DB2_MASK             4U
#define CAN1TXDSR4_DB3_MASK             8U
#define CAN1TXDSR4_DB4_MASK             16U
#define CAN1TXDSR4_DB5_MASK             32U
#define CAN1TXDSR4_DB6_MASK             64U
#define CAN1TXDSR4_DB7_MASK             128U


/*** CAN1TXDSR5 - MSCAN 1 Transmit Data Segment Register 5; 0x000001B9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR5STR;
extern volatile CAN1TXDSR5STR _CAN1TXDSR5 @(REG_BASE + 0x000001B9UL);
#define CAN1TXDSR5                      _CAN1TXDSR5.Byte
#define CAN1TXDSR5_DB0                  _CAN1TXDSR5.Bits.DB0
#define CAN1TXDSR5_DB1                  _CAN1TXDSR5.Bits.DB1
#define CAN1TXDSR5_DB2                  _CAN1TXDSR5.Bits.DB2
#define CAN1TXDSR5_DB3                  _CAN1TXDSR5.Bits.DB3
#define CAN1TXDSR5_DB4                  _CAN1TXDSR5.Bits.DB4
#define CAN1TXDSR5_DB5                  _CAN1TXDSR5.Bits.DB5
#define CAN1TXDSR5_DB6                  _CAN1TXDSR5.Bits.DB6
#define CAN1TXDSR5_DB7                  _CAN1TXDSR5.Bits.DB7

#define CAN1TXDSR5_DB0_MASK             1U
#define CAN1TXDSR5_DB1_MASK             2U
#define CAN1TXDSR5_DB2_MASK             4U
#define CAN1TXDSR5_DB3_MASK             8U
#define CAN1TXDSR5_DB4_MASK             16U
#define CAN1TXDSR5_DB5_MASK             32U
#define CAN1TXDSR5_DB6_MASK             64U
#define CAN1TXDSR5_DB7_MASK             128U


/*** CAN1TXDSR6 - MSCAN 1 Transmit Data Segment Register 6; 0x000001BA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR6STR;
extern volatile CAN1TXDSR6STR _CAN1TXDSR6 @(REG_BASE + 0x000001BAUL);
#define CAN1TXDSR6                      _CAN1TXDSR6.Byte
#define CAN1TXDSR6_DB0                  _CAN1TXDSR6.Bits.DB0
#define CAN1TXDSR6_DB1                  _CAN1TXDSR6.Bits.DB1
#define CAN1TXDSR6_DB2                  _CAN1TXDSR6.Bits.DB2
#define CAN1TXDSR6_DB3                  _CAN1TXDSR6.Bits.DB3
#define CAN1TXDSR6_DB4                  _CAN1TXDSR6.Bits.DB4
#define CAN1TXDSR6_DB5                  _CAN1TXDSR6.Bits.DB5
#define CAN1TXDSR6_DB6                  _CAN1TXDSR6.Bits.DB6
#define CAN1TXDSR6_DB7                  _CAN1TXDSR6.Bits.DB7

#define CAN1TXDSR6_DB0_MASK             1U
#define CAN1TXDSR6_DB1_MASK             2U
#define CAN1TXDSR6_DB2_MASK             4U
#define CAN1TXDSR6_DB3_MASK             8U
#define CAN1TXDSR6_DB4_MASK             16U
#define CAN1TXDSR6_DB5_MASK             32U
#define CAN1TXDSR6_DB6_MASK             64U
#define CAN1TXDSR6_DB7_MASK             128U


/*** CAN1TXDSR7 - MSCAN 1 Transmit Data Segment Register 7; 0x000001BB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN1TXDSR7STR;
extern volatile CAN1TXDSR7STR _CAN1TXDSR7 @(REG_BASE + 0x000001BBUL);
#define CAN1TXDSR7                      _CAN1TXDSR7.Byte
#define CAN1TXDSR7_DB0                  _CAN1TXDSR7.Bits.DB0
#define CAN1TXDSR7_DB1                  _CAN1TXDSR7.Bits.DB1
#define CAN1TXDSR7_DB2                  _CAN1TXDSR7.Bits.DB2
#define CAN1TXDSR7_DB3                  _CAN1TXDSR7.Bits.DB3
#define CAN1TXDSR7_DB4                  _CAN1TXDSR7.Bits.DB4
#define CAN1TXDSR7_DB5                  _CAN1TXDSR7.Bits.DB5
#define CAN1TXDSR7_DB6                  _CAN1TXDSR7.Bits.DB6
#define CAN1TXDSR7_DB7                  _CAN1TXDSR7.Bits.DB7

#define CAN1TXDSR7_DB0_MASK             1U
#define CAN1TXDSR7_DB1_MASK             2U
#define CAN1TXDSR7_DB2_MASK             4U
#define CAN1TXDSR7_DB3_MASK             8U
#define CAN1TXDSR7_DB4_MASK             16U
#define CAN1TXDSR7_DB5_MASK             32U
#define CAN1TXDSR7_DB6_MASK             64U
#define CAN1TXDSR7_DB7_MASK             128U


/*** CAN1TXDLR - MSCAN 1 Transmit Data Length Register; 0x000001BC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN1TXDLRSTR;
extern volatile CAN1TXDLRSTR _CAN1TXDLR @(REG_BASE + 0x000001BCUL);
#define CAN1TXDLR                       _CAN1TXDLR.Byte
#define CAN1TXDLR_DLC0                  _CAN1TXDLR.Bits.DLC0
#define CAN1TXDLR_DLC1                  _CAN1TXDLR.Bits.DLC1
#define CAN1TXDLR_DLC2                  _CAN1TXDLR.Bits.DLC2
#define CAN1TXDLR_DLC3                  _CAN1TXDLR.Bits.DLC3
#define CAN1TXDLR_DLC                   _CAN1TXDLR.MergedBits.grpDLC

#define CAN1TXDLR_DLC0_MASK             1U
#define CAN1TXDLR_DLC1_MASK             2U
#define CAN1TXDLR_DLC2_MASK             4U
#define CAN1TXDLR_DLC3_MASK             8U
#define CAN1TXDLR_DLC_MASK              15U
#define CAN1TXDLR_DLC_BITNUM            0U


/*** CAN1TXTBPR - MSCAN 1 Transmit Buffer Priority; 0x000001BD ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN1TXTBPRSTR;
extern volatile CAN1TXTBPRSTR _CAN1TXTBPR @(REG_BASE + 0x000001BDUL);
#define CAN1TXTBPR                      _CAN1TXTBPR.Byte
#define CAN1TXTBPR_PRIO0                _CAN1TXTBPR.Bits.PRIO0
#define CAN1TXTBPR_PRIO1                _CAN1TXTBPR.Bits.PRIO1
#define CAN1TXTBPR_PRIO2                _CAN1TXTBPR.Bits.PRIO2
#define CAN1TXTBPR_PRIO3                _CAN1TXTBPR.Bits.PRIO3
#define CAN1TXTBPR_PRIO4                _CAN1TXTBPR.Bits.PRIO4
#define CAN1TXTBPR_PRIO5                _CAN1TXTBPR.Bits.PRIO5
#define CAN1TXTBPR_PRIO6                _CAN1TXTBPR.Bits.PRIO6
#define CAN1TXTBPR_PRIO7                _CAN1TXTBPR.Bits.PRIO7

#define CAN1TXTBPR_PRIO0_MASK           1U
#define CAN1TXTBPR_PRIO1_MASK           2U
#define CAN1TXTBPR_PRIO2_MASK           4U
#define CAN1TXTBPR_PRIO3_MASK           8U
#define CAN1TXTBPR_PRIO4_MASK           16U
#define CAN1TXTBPR_PRIO5_MASK           32U
#define CAN1TXTBPR_PRIO6_MASK           64U
#define CAN1TXTBPR_PRIO7_MASK           128U


/*** CAN1TXTSR - MSCAN 1 Transmit Time Stamp Register; 0x000001BE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN1TXTSRH - MSCAN 1 Transmit Time Stamp Register High; 0x000001BE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN1TXTSRHSTR;
    #define CAN1TXTSRH                  _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Byte
    #define CAN1TXTSRH_TSR8             _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR8
    #define CAN1TXTSRH_TSR9             _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR9
    #define CAN1TXTSRH_TSR10            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR10
    #define CAN1TXTSRH_TSR11            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR11
    #define CAN1TXTSRH_TSR12            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR12
    #define CAN1TXTSRH_TSR13            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR13
    #define CAN1TXTSRH_TSR14            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR14
    #define CAN1TXTSRH_TSR15            _CAN1TXTSR.Overlap_STR.CAN1TXTSRHSTR.Bits.TSR15
    
    #define CAN1TXTSRH_TSR8_MASK        1U
    #define CAN1TXTSRH_TSR9_MASK        2U
    #define CAN1TXTSRH_TSR10_MASK       4U
    #define CAN1TXTSRH_TSR11_MASK       8U
    #define CAN1TXTSRH_TSR12_MASK       16U
    #define CAN1TXTSRH_TSR13_MASK       32U
    #define CAN1TXTSRH_TSR14_MASK       64U
    #define CAN1TXTSRH_TSR15_MASK       128U
    

    /*** CAN1TXTSRL - MSCAN 1 Transmit Time Stamp Register Low; 0x000001BF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN1TXTSRLSTR;
    #define CAN1TXTSRL                  _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Byte
    #define CAN1TXTSRL_TSR0             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR0
    #define CAN1TXTSRL_TSR1             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR1
    #define CAN1TXTSRL_TSR2             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR2
    #define CAN1TXTSRL_TSR3             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR3
    #define CAN1TXTSRL_TSR4             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR4
    #define CAN1TXTSRL_TSR5             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR5
    #define CAN1TXTSRL_TSR6             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR6
    #define CAN1TXTSRL_TSR7             _CAN1TXTSR.Overlap_STR.CAN1TXTSRLSTR.Bits.TSR7
    
    #define CAN1TXTSRL_TSR0_MASK        1U
    #define CAN1TXTSRL_TSR1_MASK        2U
    #define CAN1TXTSRL_TSR2_MASK        4U
    #define CAN1TXTSRL_TSR3_MASK        8U
    #define CAN1TXTSRL_TSR4_MASK        16U
    #define CAN1TXTSRL_TSR5_MASK        32U
    #define CAN1TXTSRL_TSR6_MASK        64U
    #define CAN1TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN1TXTSRSTR;
extern volatile CAN1TXTSRSTR _CAN1TXTSR @(REG_BASE + 0x000001BEUL);
#define CAN1TXTSR                       _CAN1TXTSR.Word
#define CAN1TXTSR_TSR0                  _CAN1TXTSR.Bits.TSR0
#define CAN1TXTSR_TSR1                  _CAN1TXTSR.Bits.TSR1
#define CAN1TXTSR_TSR2                  _CAN1TXTSR.Bits.TSR2
#define CAN1TXTSR_TSR3                  _CAN1TXTSR.Bits.TSR3
#define CAN1TXTSR_TSR4                  _CAN1TXTSR.Bits.TSR4
#define CAN1TXTSR_TSR5                  _CAN1TXTSR.Bits.TSR5
#define CAN1TXTSR_TSR6                  _CAN1TXTSR.Bits.TSR6
#define CAN1TXTSR_TSR7                  _CAN1TXTSR.Bits.TSR7
#define CAN1TXTSR_TSR8                  _CAN1TXTSR.Bits.TSR8
#define CAN1TXTSR_TSR9                  _CAN1TXTSR.Bits.TSR9
#define CAN1TXTSR_TSR10                 _CAN1TXTSR.Bits.TSR10
#define CAN1TXTSR_TSR11                 _CAN1TXTSR.Bits.TSR11
#define CAN1TXTSR_TSR12                 _CAN1TXTSR.Bits.TSR12
#define CAN1TXTSR_TSR13                 _CAN1TXTSR.Bits.TSR13
#define CAN1TXTSR_TSR14                 _CAN1TXTSR.Bits.TSR14
#define CAN1TXTSR_TSR15                 _CAN1TXTSR.Bits.TSR15

#define CAN1TXTSR_TSR0_MASK             1U
#define CAN1TXTSR_TSR1_MASK             2U
#define CAN1TXTSR_TSR2_MASK             4U
#define CAN1TXTSR_TSR3_MASK             8U
#define CAN1TXTSR_TSR4_MASK             16U
#define CAN1TXTSR_TSR5_MASK             32U
#define CAN1TXTSR_TSR6_MASK             64U
#define CAN1TXTSR_TSR7_MASK             128U
#define CAN1TXTSR_TSR8_MASK             256U
#define CAN1TXTSR_TSR9_MASK             512U
#define CAN1TXTSR_TSR10_MASK            1024U
#define CAN1TXTSR_TSR11_MASK            2048U
#define CAN1TXTSR_TSR12_MASK            4096U
#define CAN1TXTSR_TSR13_MASK            8192U
#define CAN1TXTSR_TSR14_MASK            16384U
#define CAN1TXTSR_TSR15_MASK            32768U


/*** CAN2CTL0 - MSCAN 2 Control 0 Register; 0x000001C0 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN2CTL0STR;
extern volatile CAN2CTL0STR _CAN2CTL0 @(REG_BASE + 0x000001C0UL);
#define CAN2CTL0                        _CAN2CTL0.Byte
#define CAN2CTL0_INITRQ                 _CAN2CTL0.Bits.INITRQ
#define CAN2CTL0_SLPRQ                  _CAN2CTL0.Bits.SLPRQ
#define CAN2CTL0_WUPE                   _CAN2CTL0.Bits.WUPE
#define CAN2CTL0_TIME                   _CAN2CTL0.Bits.TIME
#define CAN2CTL0_SYNCH                  _CAN2CTL0.Bits.SYNCH
#define CAN2CTL0_CSWAI                  _CAN2CTL0.Bits.CSWAI
#define CAN2CTL0_RXACT                  _CAN2CTL0.Bits.RXACT
#define CAN2CTL0_RXFRM                  _CAN2CTL0.Bits.RXFRM
/* CAN2CTL_ARR: Access 2 CAN2CTLx registers in an array */
#define CAN2CTL_ARR                     ((volatile byte *) &CAN2CTL0)

#define CAN2CTL0_INITRQ_MASK            1U
#define CAN2CTL0_SLPRQ_MASK             2U
#define CAN2CTL0_WUPE_MASK              4U
#define CAN2CTL0_TIME_MASK              8U
#define CAN2CTL0_SYNCH_MASK             16U
#define CAN2CTL0_CSWAI_MASK             32U
#define CAN2CTL0_RXACT_MASK             64U
#define CAN2CTL0_RXFRM_MASK             128U


/*** CAN2CTL1 - MSCAN 2 Control 1 Register; 0x000001C1 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN 2 Clock Source */
    byte CANE        :1;                                       /* MSCAN 2 Enable */
  } Bits;
} CAN2CTL1STR;
extern volatile CAN2CTL1STR _CAN2CTL1 @(REG_BASE + 0x000001C1UL);
#define CAN2CTL1                        _CAN2CTL1.Byte
#define CAN2CTL1_INITAK                 _CAN2CTL1.Bits.INITAK
#define CAN2CTL1_SLPAK                  _CAN2CTL1.Bits.SLPAK
#define CAN2CTL1_WUPM                   _CAN2CTL1.Bits.WUPM
#define CAN2CTL1_BORM                   _CAN2CTL1.Bits.BORM
#define CAN2CTL1_LISTEN                 _CAN2CTL1.Bits.LISTEN
#define CAN2CTL1_LOOPB                  _CAN2CTL1.Bits.LOOPB
#define CAN2CTL1_CLKSRC                 _CAN2CTL1.Bits.CLKSRC
#define CAN2CTL1_CANE                   _CAN2CTL1.Bits.CANE

#define CAN2CTL1_INITAK_MASK            1U
#define CAN2CTL1_SLPAK_MASK             2U
#define CAN2CTL1_WUPM_MASK              4U
#define CAN2CTL1_BORM_MASK              8U
#define CAN2CTL1_LISTEN_MASK            16U
#define CAN2CTL1_LOOPB_MASK             32U
#define CAN2CTL1_CLKSRC_MASK            64U
#define CAN2CTL1_CANE_MASK              128U


/*** CAN2BTR0 - MSCAN 2 Bus Timing Register 0; 0x000001C2 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN2BTR0STR;
extern volatile CAN2BTR0STR _CAN2BTR0 @(REG_BASE + 0x000001C2UL);
#define CAN2BTR0                        _CAN2BTR0.Byte
#define CAN2BTR0_BRP0                   _CAN2BTR0.Bits.BRP0
#define CAN2BTR0_BRP1                   _CAN2BTR0.Bits.BRP1
#define CAN2BTR0_BRP2                   _CAN2BTR0.Bits.BRP2
#define CAN2BTR0_BRP3                   _CAN2BTR0.Bits.BRP3
#define CAN2BTR0_BRP4                   _CAN2BTR0.Bits.BRP4
#define CAN2BTR0_BRP5                   _CAN2BTR0.Bits.BRP5
#define CAN2BTR0_SJW0                   _CAN2BTR0.Bits.SJW0
#define CAN2BTR0_SJW1                   _CAN2BTR0.Bits.SJW1
/* CAN2BTR_ARR: Access 2 CAN2BTRx registers in an array */
#define CAN2BTR_ARR                     ((volatile byte *) &CAN2BTR0)
#define CAN2BTR0_BRP                    _CAN2BTR0.MergedBits.grpBRP
#define CAN2BTR0_SJW                    _CAN2BTR0.MergedBits.grpSJW

#define CAN2BTR0_BRP0_MASK              1U
#define CAN2BTR0_BRP1_MASK              2U
#define CAN2BTR0_BRP2_MASK              4U
#define CAN2BTR0_BRP3_MASK              8U
#define CAN2BTR0_BRP4_MASK              16U
#define CAN2BTR0_BRP5_MASK              32U
#define CAN2BTR0_SJW0_MASK              64U
#define CAN2BTR0_SJW1_MASK              128U
#define CAN2BTR0_BRP_MASK               63U
#define CAN2BTR0_BRP_BITNUM             0U
#define CAN2BTR0_SJW_MASK               192U
#define CAN2BTR0_SJW_BITNUM             6U


/*** CAN2BTR1 - MSCAN 2 Bus Timing Register 1; 0x000001C3 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN2BTR1STR;
extern volatile CAN2BTR1STR _CAN2BTR1 @(REG_BASE + 0x000001C3UL);
#define CAN2BTR1                        _CAN2BTR1.Byte
#define CAN2BTR1_TSEG10                 _CAN2BTR1.Bits.TSEG10
#define CAN2BTR1_TSEG11                 _CAN2BTR1.Bits.TSEG11
#define CAN2BTR1_TSEG12                 _CAN2BTR1.Bits.TSEG12
#define CAN2BTR1_TSEG13                 _CAN2BTR1.Bits.TSEG13
#define CAN2BTR1_TSEG20                 _CAN2BTR1.Bits.TSEG20
#define CAN2BTR1_TSEG21                 _CAN2BTR1.Bits.TSEG21
#define CAN2BTR1_TSEG22                 _CAN2BTR1.Bits.TSEG22
#define CAN2BTR1_SAMP                   _CAN2BTR1.Bits.SAMP
#define CAN2BTR1_TSEG_10                _CAN2BTR1.MergedBits.grpTSEG_10
#define CAN2BTR1_TSEG_20                _CAN2BTR1.MergedBits.grpTSEG_20
#define CAN2BTR1_TSEG                   CAN2BTR1_TSEG_10

#define CAN2BTR1_TSEG10_MASK            1U
#define CAN2BTR1_TSEG11_MASK            2U
#define CAN2BTR1_TSEG12_MASK            4U
#define CAN2BTR1_TSEG13_MASK            8U
#define CAN2BTR1_TSEG20_MASK            16U
#define CAN2BTR1_TSEG21_MASK            32U
#define CAN2BTR1_TSEG22_MASK            64U
#define CAN2BTR1_SAMP_MASK              128U
#define CAN2BTR1_TSEG_10_MASK           15U
#define CAN2BTR1_TSEG_10_BITNUM         0U
#define CAN2BTR1_TSEG_20_MASK           112U
#define CAN2BTR1_TSEG_20_BITNUM         4U


/*** CAN2RFLG - MSCAN 2 Receiver Flag Register; 0x000001C4 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2RFLGSTR;
extern volatile CAN2RFLGSTR _CAN2RFLG @(REG_BASE + 0x000001C4UL);
#define CAN2RFLG                        _CAN2RFLG.Byte
#define CAN2RFLG_RXF                    _CAN2RFLG.Bits.RXF
#define CAN2RFLG_OVRIF                  _CAN2RFLG.Bits.OVRIF
#define CAN2RFLG_TSTAT0                 _CAN2RFLG.Bits.TSTAT0
#define CAN2RFLG_TSTAT1                 _CAN2RFLG.Bits.TSTAT1
#define CAN2RFLG_RSTAT0                 _CAN2RFLG.Bits.RSTAT0
#define CAN2RFLG_RSTAT1                 _CAN2RFLG.Bits.RSTAT1
#define CAN2RFLG_CSCIF                  _CAN2RFLG.Bits.CSCIF
#define CAN2RFLG_WUPIF                  _CAN2RFLG.Bits.WUPIF
#define CAN2RFLG_TSTAT                  _CAN2RFLG.MergedBits.grpTSTAT
#define CAN2RFLG_RSTAT                  _CAN2RFLG.MergedBits.grpRSTAT

#define CAN2RFLG_RXF_MASK               1U
#define CAN2RFLG_OVRIF_MASK             2U
#define CAN2RFLG_TSTAT0_MASK            4U
#define CAN2RFLG_TSTAT1_MASK            8U
#define CAN2RFLG_RSTAT0_MASK            16U
#define CAN2RFLG_RSTAT1_MASK            32U
#define CAN2RFLG_CSCIF_MASK             64U
#define CAN2RFLG_WUPIF_MASK             128U
#define CAN2RFLG_TSTAT_MASK             12U
#define CAN2RFLG_TSTAT_BITNUM           2U
#define CAN2RFLG_RSTAT_MASK             48U
#define CAN2RFLG_RSTAT_BITNUM           4U


/*** CAN2RIER - MSCAN 2 Receiver Interrupt Enable Register; 0x000001C5 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2RIERSTR;
extern volatile CAN2RIERSTR _CAN2RIER @(REG_BASE + 0x000001C5UL);
#define CAN2RIER                        _CAN2RIER.Byte
#define CAN2RIER_RXFIE                  _CAN2RIER.Bits.RXFIE
#define CAN2RIER_OVRIE                  _CAN2RIER.Bits.OVRIE
#define CAN2RIER_TSTATE0                _CAN2RIER.Bits.TSTATE0
#define CAN2RIER_TSTATE1                _CAN2RIER.Bits.TSTATE1
#define CAN2RIER_RSTATE0                _CAN2RIER.Bits.RSTATE0
#define CAN2RIER_RSTATE1                _CAN2RIER.Bits.RSTATE1
#define CAN2RIER_CSCIE                  _CAN2RIER.Bits.CSCIE
#define CAN2RIER_WUPIE                  _CAN2RIER.Bits.WUPIE
#define CAN2RIER_TSTATE                 _CAN2RIER.MergedBits.grpTSTATE
#define CAN2RIER_RSTATE                 _CAN2RIER.MergedBits.grpRSTATE

#define CAN2RIER_RXFIE_MASK             1U
#define CAN2RIER_OVRIE_MASK             2U
#define CAN2RIER_TSTATE0_MASK           4U
#define CAN2RIER_TSTATE1_MASK           8U
#define CAN2RIER_RSTATE0_MASK           16U
#define CAN2RIER_RSTATE1_MASK           32U
#define CAN2RIER_CSCIE_MASK             64U
#define CAN2RIER_WUPIE_MASK             128U
#define CAN2RIER_TSTATE_MASK            12U
#define CAN2RIER_TSTATE_BITNUM          2U
#define CAN2RIER_RSTATE_MASK            48U
#define CAN2RIER_RSTATE_BITNUM          4U


/*** CAN2TFLG - MSCAN 2 Transmitter Flag Register; 0x000001C6 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2TFLGSTR;
extern volatile CAN2TFLGSTR _CAN2TFLG @(REG_BASE + 0x000001C6UL);
#define CAN2TFLG                        _CAN2TFLG.Byte
#define CAN2TFLG_TXE0                   _CAN2TFLG.Bits.TXE0
#define CAN2TFLG_TXE1                   _CAN2TFLG.Bits.TXE1
#define CAN2TFLG_TXE2                   _CAN2TFLG.Bits.TXE2
#define CAN2TFLG_TXE                    _CAN2TFLG.MergedBits.grpTXE

#define CAN2TFLG_TXE0_MASK              1U
#define CAN2TFLG_TXE1_MASK              2U
#define CAN2TFLG_TXE2_MASK              4U
#define CAN2TFLG_TXE_MASK               7U
#define CAN2TFLG_TXE_BITNUM             0U


/*** CAN2TIER - MSCAN 2 Transmitter Interrupt Enable Register; 0x000001C7 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2TIERSTR;
extern volatile CAN2TIERSTR _CAN2TIER @(REG_BASE + 0x000001C7UL);
#define CAN2TIER                        _CAN2TIER.Byte
#define CAN2TIER_TXEIE0                 _CAN2TIER.Bits.TXEIE0
#define CAN2TIER_TXEIE1                 _CAN2TIER.Bits.TXEIE1
#define CAN2TIER_TXEIE2                 _CAN2TIER.Bits.TXEIE2
#define CAN2TIER_TXEIE                  _CAN2TIER.MergedBits.grpTXEIE

#define CAN2TIER_TXEIE0_MASK            1U
#define CAN2TIER_TXEIE1_MASK            2U
#define CAN2TIER_TXEIE2_MASK            4U
#define CAN2TIER_TXEIE_MASK             7U
#define CAN2TIER_TXEIE_BITNUM           0U


/*** CAN2TARQ - MSCAN 2 Transmitter Message Abort Request; 0x000001C8 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2TARQSTR;
extern volatile CAN2TARQSTR _CAN2TARQ @(REG_BASE + 0x000001C8UL);
#define CAN2TARQ                        _CAN2TARQ.Byte
#define CAN2TARQ_ABTRQ0                 _CAN2TARQ.Bits.ABTRQ0
#define CAN2TARQ_ABTRQ1                 _CAN2TARQ.Bits.ABTRQ1
#define CAN2TARQ_ABTRQ2                 _CAN2TARQ.Bits.ABTRQ2
#define CAN2TARQ_ABTRQ                  _CAN2TARQ.MergedBits.grpABTRQ

#define CAN2TARQ_ABTRQ0_MASK            1U
#define CAN2TARQ_ABTRQ1_MASK            2U
#define CAN2TARQ_ABTRQ2_MASK            4U
#define CAN2TARQ_ABTRQ_MASK             7U
#define CAN2TARQ_ABTRQ_BITNUM           0U


/*** CAN2TAAK - MSCAN 2 Transmitter Message Abort Control; 0x000001C9 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2TAAKSTR;
extern volatile CAN2TAAKSTR _CAN2TAAK @(REG_BASE + 0x000001C9UL);
#define CAN2TAAK                        _CAN2TAAK.Byte
#define CAN2TAAK_ABTAK0                 _CAN2TAAK.Bits.ABTAK0
#define CAN2TAAK_ABTAK1                 _CAN2TAAK.Bits.ABTAK1
#define CAN2TAAK_ABTAK2                 _CAN2TAAK.Bits.ABTAK2
#define CAN2TAAK_ABTAK                  _CAN2TAAK.MergedBits.grpABTAK

#define CAN2TAAK_ABTAK0_MASK            1U
#define CAN2TAAK_ABTAK1_MASK            2U
#define CAN2TAAK_ABTAK2_MASK            4U
#define CAN2TAAK_ABTAK_MASK             7U
#define CAN2TAAK_ABTAK_BITNUM           0U


/*** CAN2TBSEL - MSCAN 2 Transmit Buffer Selection; 0x000001CA ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2TBSELSTR;
extern volatile CAN2TBSELSTR _CAN2TBSEL @(REG_BASE + 0x000001CAUL);
#define CAN2TBSEL                       _CAN2TBSEL.Byte
#define CAN2TBSEL_TX0                   _CAN2TBSEL.Bits.TX0
#define CAN2TBSEL_TX1                   _CAN2TBSEL.Bits.TX1
#define CAN2TBSEL_TX2                   _CAN2TBSEL.Bits.TX2
#define CAN2TBSEL_TX                    _CAN2TBSEL.MergedBits.grpTX

#define CAN2TBSEL_TX0_MASK              1U
#define CAN2TBSEL_TX1_MASK              2U
#define CAN2TBSEL_TX2_MASK              4U
#define CAN2TBSEL_TX_MASK               7U
#define CAN2TBSEL_TX_BITNUM             0U


/*** CAN2IDAC - MSCAN 2 Identifier Acceptance Control Register; 0x000001CB ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2IDACSTR;
extern volatile CAN2IDACSTR _CAN2IDAC @(REG_BASE + 0x000001CBUL);
#define CAN2IDAC                        _CAN2IDAC.Byte
#define CAN2IDAC_IDHIT0                 _CAN2IDAC.Bits.IDHIT0
#define CAN2IDAC_IDHIT1                 _CAN2IDAC.Bits.IDHIT1
#define CAN2IDAC_IDHIT2                 _CAN2IDAC.Bits.IDHIT2
#define CAN2IDAC_IDAM0                  _CAN2IDAC.Bits.IDAM0
#define CAN2IDAC_IDAM1                  _CAN2IDAC.Bits.IDAM1
#define CAN2IDAC_IDHIT                  _CAN2IDAC.MergedBits.grpIDHIT
#define CAN2IDAC_IDAM                   _CAN2IDAC.MergedBits.grpIDAM

#define CAN2IDAC_IDHIT0_MASK            1U
#define CAN2IDAC_IDHIT1_MASK            2U
#define CAN2IDAC_IDHIT2_MASK            4U
#define CAN2IDAC_IDAM0_MASK             16U
#define CAN2IDAC_IDAM1_MASK             32U
#define CAN2IDAC_IDHIT_MASK             7U
#define CAN2IDAC_IDHIT_BITNUM           0U
#define CAN2IDAC_IDAM_MASK              48U
#define CAN2IDAC_IDAM_BITNUM            4U


/*** CAN2MISC - MSCAN 2 Miscellaneous Register; 0x000001CD ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-Off state Hold until user request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN2MISCSTR;
extern volatile CAN2MISCSTR _CAN2MISC @(REG_BASE + 0x000001CDUL);
#define CAN2MISC                        _CAN2MISC.Byte
#define CAN2MISC_BOHOLD                 _CAN2MISC.Bits.BOHOLD

#define CAN2MISC_BOHOLD_MASK            1U


/*** CAN2RXERR - MSCAN 2 Receive Error Counter Register; 0x000001CE ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN2RXERRSTR;
extern volatile CAN2RXERRSTR _CAN2RXERR @(REG_BASE + 0x000001CEUL);
#define CAN2RXERR                       _CAN2RXERR.Byte
#define CAN2RXERR_RXERR0                _CAN2RXERR.Bits.RXERR0
#define CAN2RXERR_RXERR1                _CAN2RXERR.Bits.RXERR1
#define CAN2RXERR_RXERR2                _CAN2RXERR.Bits.RXERR2
#define CAN2RXERR_RXERR3                _CAN2RXERR.Bits.RXERR3
#define CAN2RXERR_RXERR4                _CAN2RXERR.Bits.RXERR4
#define CAN2RXERR_RXERR5                _CAN2RXERR.Bits.RXERR5
#define CAN2RXERR_RXERR6                _CAN2RXERR.Bits.RXERR6
#define CAN2RXERR_RXERR7                _CAN2RXERR.Bits.RXERR7

#define CAN2RXERR_RXERR0_MASK           1U
#define CAN2RXERR_RXERR1_MASK           2U
#define CAN2RXERR_RXERR2_MASK           4U
#define CAN2RXERR_RXERR3_MASK           8U
#define CAN2RXERR_RXERR4_MASK           16U
#define CAN2RXERR_RXERR5_MASK           32U
#define CAN2RXERR_RXERR6_MASK           64U
#define CAN2RXERR_RXERR7_MASK           128U


/*** CAN2TXERR - MSCAN 2 Transmit Error Counter Register; 0x000001CF ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN2TXERRSTR;
extern volatile CAN2TXERRSTR _CAN2TXERR @(REG_BASE + 0x000001CFUL);
#define CAN2TXERR                       _CAN2TXERR.Byte
#define CAN2TXERR_TXERR0                _CAN2TXERR.Bits.TXERR0
#define CAN2TXERR_TXERR1                _CAN2TXERR.Bits.TXERR1
#define CAN2TXERR_TXERR2                _CAN2TXERR.Bits.TXERR2
#define CAN2TXERR_TXERR3                _CAN2TXERR.Bits.TXERR3
#define CAN2TXERR_TXERR4                _CAN2TXERR.Bits.TXERR4
#define CAN2TXERR_TXERR5                _CAN2TXERR.Bits.TXERR5
#define CAN2TXERR_TXERR6                _CAN2TXERR.Bits.TXERR6
#define CAN2TXERR_TXERR7                _CAN2TXERR.Bits.TXERR7

#define CAN2TXERR_TXERR0_MASK           1U
#define CAN2TXERR_TXERR1_MASK           2U
#define CAN2TXERR_TXERR2_MASK           4U
#define CAN2TXERR_TXERR3_MASK           8U
#define CAN2TXERR_TXERR4_MASK           16U
#define CAN2TXERR_TXERR5_MASK           32U
#define CAN2TXERR_TXERR6_MASK           64U
#define CAN2TXERR_TXERR7_MASK           128U


/*** CAN2IDAR0 - MSCAN 2 Identifier Acceptance Register 0; 0x000001D0 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN2IDAR0STR;
extern volatile CAN2IDAR0STR _CAN2IDAR0 @(REG_BASE + 0x000001D0UL);
#define CAN2IDAR0                       _CAN2IDAR0.Byte
#define CAN2IDAR0_AC0                   _CAN2IDAR0.Bits.AC0
#define CAN2IDAR0_AC1                   _CAN2IDAR0.Bits.AC1
#define CAN2IDAR0_AC2                   _CAN2IDAR0.Bits.AC2
#define CAN2IDAR0_AC3                   _CAN2IDAR0.Bits.AC3
#define CAN2IDAR0_AC4                   _CAN2IDAR0.Bits.AC4
#define CAN2IDAR0_AC5                   _CAN2IDAR0.Bits.AC5
#define CAN2IDAR0_AC6                   _CAN2IDAR0.Bits.AC6
#define CAN2IDAR0_AC7                   _CAN2IDAR0.Bits.AC7
/* CAN2IDAR_ARR: Access 4 CAN2IDARx registers in an array */
#define CAN2IDAR_ARR                    ((volatile byte *) &CAN2IDAR0)

#define CAN2IDAR0_AC0_MASK              1U
#define CAN2IDAR0_AC1_MASK              2U
#define CAN2IDAR0_AC2_MASK              4U
#define CAN2IDAR0_AC3_MASK              8U
#define CAN2IDAR0_AC4_MASK              16U
#define CAN2IDAR0_AC5_MASK              32U
#define CAN2IDAR0_AC6_MASK              64U
#define CAN2IDAR0_AC7_MASK              128U


/*** CAN2IDAR1 - MSCAN 2 Identifier Acceptance Register 1; 0x000001D1 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN2IDAR1STR;
extern volatile CAN2IDAR1STR _CAN2IDAR1 @(REG_BASE + 0x000001D1UL);
#define CAN2IDAR1                       _CAN2IDAR1.Byte
#define CAN2IDAR1_AC0                   _CAN2IDAR1.Bits.AC0
#define CAN2IDAR1_AC1                   _CAN2IDAR1.Bits.AC1
#define CAN2IDAR1_AC2                   _CAN2IDAR1.Bits.AC2
#define CAN2IDAR1_AC3                   _CAN2IDAR1.Bits.AC3
#define CAN2IDAR1_AC4                   _CAN2IDAR1.Bits.AC4
#define CAN2IDAR1_AC5                   _CAN2IDAR1.Bits.AC5
#define CAN2IDAR1_AC6                   _CAN2IDAR1.Bits.AC6
#define CAN2IDAR1_AC7                   _CAN2IDAR1.Bits.AC7

#define CAN2IDAR1_AC0_MASK              1U
#define CAN2IDAR1_AC1_MASK              2U
#define CAN2IDAR1_AC2_MASK              4U
#define CAN2IDAR1_AC3_MASK              8U
#define CAN2IDAR1_AC4_MASK              16U
#define CAN2IDAR1_AC5_MASK              32U
#define CAN2IDAR1_AC6_MASK              64U
#define CAN2IDAR1_AC7_MASK              128U


/*** CAN2IDAR2 - MSCAN 2 Identifier Acceptance Register 2; 0x000001D2 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN2IDAR2STR;
extern volatile CAN2IDAR2STR _CAN2IDAR2 @(REG_BASE + 0x000001D2UL);
#define CAN2IDAR2                       _CAN2IDAR2.Byte
#define CAN2IDAR2_AC0                   _CAN2IDAR2.Bits.AC0
#define CAN2IDAR2_AC1                   _CAN2IDAR2.Bits.AC1
#define CAN2IDAR2_AC2                   _CAN2IDAR2.Bits.AC2
#define CAN2IDAR2_AC3                   _CAN2IDAR2.Bits.AC3
#define CAN2IDAR2_AC4                   _CAN2IDAR2.Bits.AC4
#define CAN2IDAR2_AC5                   _CAN2IDAR2.Bits.AC5
#define CAN2IDAR2_AC6                   _CAN2IDAR2.Bits.AC6
#define CAN2IDAR2_AC7                   _CAN2IDAR2.Bits.AC7

#define CAN2IDAR2_AC0_MASK              1U
#define CAN2IDAR2_AC1_MASK              2U
#define CAN2IDAR2_AC2_MASK              4U
#define CAN2IDAR2_AC3_MASK              8U
#define CAN2IDAR2_AC4_MASK              16U
#define CAN2IDAR2_AC5_MASK              32U
#define CAN2IDAR2_AC6_MASK              64U
#define CAN2IDAR2_AC7_MASK              128U


/*** CAN2IDAR3 - MSCAN 2 Identifier Acceptance Register 3; 0x000001D3 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN2IDAR3STR;
extern volatile CAN2IDAR3STR _CAN2IDAR3 @(REG_BASE + 0x000001D3UL);
#define CAN2IDAR3                       _CAN2IDAR3.Byte
#define CAN2IDAR3_AC0                   _CAN2IDAR3.Bits.AC0
#define CAN2IDAR3_AC1                   _CAN2IDAR3.Bits.AC1
#define CAN2IDAR3_AC2                   _CAN2IDAR3.Bits.AC2
#define CAN2IDAR3_AC3                   _CAN2IDAR3.Bits.AC3
#define CAN2IDAR3_AC4                   _CAN2IDAR3.Bits.AC4
#define CAN2IDAR3_AC5                   _CAN2IDAR3.Bits.AC5
#define CAN2IDAR3_AC6                   _CAN2IDAR3.Bits.AC6
#define CAN2IDAR3_AC7                   _CAN2IDAR3.Bits.AC7

#define CAN2IDAR3_AC0_MASK              1U
#define CAN2IDAR3_AC1_MASK              2U
#define CAN2IDAR3_AC2_MASK              4U
#define CAN2IDAR3_AC3_MASK              8U
#define CAN2IDAR3_AC4_MASK              16U
#define CAN2IDAR3_AC5_MASK              32U
#define CAN2IDAR3_AC6_MASK              64U
#define CAN2IDAR3_AC7_MASK              128U


/*** CAN2IDMR0 - MSCAN 2 Identifier Mask Register 0; 0x000001D4 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN2IDMR0STR;
extern volatile CAN2IDMR0STR _CAN2IDMR0 @(REG_BASE + 0x000001D4UL);
#define CAN2IDMR0                       _CAN2IDMR0.Byte
#define CAN2IDMR0_AM0                   _CAN2IDMR0.Bits.AM0
#define CAN2IDMR0_AM1                   _CAN2IDMR0.Bits.AM1
#define CAN2IDMR0_AM2                   _CAN2IDMR0.Bits.AM2
#define CAN2IDMR0_AM3                   _CAN2IDMR0.Bits.AM3
#define CAN2IDMR0_AM4                   _CAN2IDMR0.Bits.AM4
#define CAN2IDMR0_AM5                   _CAN2IDMR0.Bits.AM5
#define CAN2IDMR0_AM6                   _CAN2IDMR0.Bits.AM6
#define CAN2IDMR0_AM7                   _CAN2IDMR0.Bits.AM7
/* CAN2IDMR_ARR: Access 4 CAN2IDMRx registers in an array */
#define CAN2IDMR_ARR                    ((volatile byte *) &CAN2IDMR0)

#define CAN2IDMR0_AM0_MASK              1U
#define CAN2IDMR0_AM1_MASK              2U
#define CAN2IDMR0_AM2_MASK              4U
#define CAN2IDMR0_AM3_MASK              8U
#define CAN2IDMR0_AM4_MASK              16U
#define CAN2IDMR0_AM5_MASK              32U
#define CAN2IDMR0_AM6_MASK              64U
#define CAN2IDMR0_AM7_MASK              128U


/*** CAN2IDMR1 - MSCAN 2 Identifier Mask Register 1; 0x000001D5 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN2IDMR1STR;
extern volatile CAN2IDMR1STR _CAN2IDMR1 @(REG_BASE + 0x000001D5UL);
#define CAN2IDMR1                       _CAN2IDMR1.Byte
#define CAN2IDMR1_AM0                   _CAN2IDMR1.Bits.AM0
#define CAN2IDMR1_AM1                   _CAN2IDMR1.Bits.AM1
#define CAN2IDMR1_AM2                   _CAN2IDMR1.Bits.AM2
#define CAN2IDMR1_AM3                   _CAN2IDMR1.Bits.AM3
#define CAN2IDMR1_AM4                   _CAN2IDMR1.Bits.AM4
#define CAN2IDMR1_AM5                   _CAN2IDMR1.Bits.AM5
#define CAN2IDMR1_AM6                   _CAN2IDMR1.Bits.AM6
#define CAN2IDMR1_AM7                   _CAN2IDMR1.Bits.AM7

#define CAN2IDMR1_AM0_MASK              1U
#define CAN2IDMR1_AM1_MASK              2U
#define CAN2IDMR1_AM2_MASK              4U
#define CAN2IDMR1_AM3_MASK              8U
#define CAN2IDMR1_AM4_MASK              16U
#define CAN2IDMR1_AM5_MASK              32U
#define CAN2IDMR1_AM6_MASK              64U
#define CAN2IDMR1_AM7_MASK              128U


/*** CAN2IDMR2 - MSCAN 2 Identifier Mask Register 2; 0x000001D6 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN2IDMR2STR;
extern volatile CAN2IDMR2STR _CAN2IDMR2 @(REG_BASE + 0x000001D6UL);
#define CAN2IDMR2                       _CAN2IDMR2.Byte
#define CAN2IDMR2_AM0                   _CAN2IDMR2.Bits.AM0
#define CAN2IDMR2_AM1                   _CAN2IDMR2.Bits.AM1
#define CAN2IDMR2_AM2                   _CAN2IDMR2.Bits.AM2
#define CAN2IDMR2_AM3                   _CAN2IDMR2.Bits.AM3
#define CAN2IDMR2_AM4                   _CAN2IDMR2.Bits.AM4
#define CAN2IDMR2_AM5                   _CAN2IDMR2.Bits.AM5
#define CAN2IDMR2_AM6                   _CAN2IDMR2.Bits.AM6
#define CAN2IDMR2_AM7                   _CAN2IDMR2.Bits.AM7

#define CAN2IDMR2_AM0_MASK              1U
#define CAN2IDMR2_AM1_MASK              2U
#define CAN2IDMR2_AM2_MASK              4U
#define CAN2IDMR2_AM3_MASK              8U
#define CAN2IDMR2_AM4_MASK              16U
#define CAN2IDMR2_AM5_MASK              32U
#define CAN2IDMR2_AM6_MASK              64U
#define CAN2IDMR2_AM7_MASK              128U


/*** CAN2IDMR3 - MSCAN 2 Identifier Mask Register 3; 0x000001D7 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN2IDMR3STR;
extern volatile CAN2IDMR3STR _CAN2IDMR3 @(REG_BASE + 0x000001D7UL);
#define CAN2IDMR3                       _CAN2IDMR3.Byte
#define CAN2IDMR3_AM0                   _CAN2IDMR3.Bits.AM0
#define CAN2IDMR3_AM1                   _CAN2IDMR3.Bits.AM1
#define CAN2IDMR3_AM2                   _CAN2IDMR3.Bits.AM2
#define CAN2IDMR3_AM3                   _CAN2IDMR3.Bits.AM3
#define CAN2IDMR3_AM4                   _CAN2IDMR3.Bits.AM4
#define CAN2IDMR3_AM5                   _CAN2IDMR3.Bits.AM5
#define CAN2IDMR3_AM6                   _CAN2IDMR3.Bits.AM6
#define CAN2IDMR3_AM7                   _CAN2IDMR3.Bits.AM7

#define CAN2IDMR3_AM0_MASK              1U
#define CAN2IDMR3_AM1_MASK              2U
#define CAN2IDMR3_AM2_MASK              4U
#define CAN2IDMR3_AM3_MASK              8U
#define CAN2IDMR3_AM4_MASK              16U
#define CAN2IDMR3_AM5_MASK              32U
#define CAN2IDMR3_AM6_MASK              64U
#define CAN2IDMR3_AM7_MASK              128U


/*** CAN2IDAR4 - MSCAN 2 Identifier Acceptance Register 4; 0x000001D8 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN2IDAR4STR;
extern volatile CAN2IDAR4STR _CAN2IDAR4 @(REG_BASE + 0x000001D8UL);
#define CAN2IDAR4                       _CAN2IDAR4.Byte
#define CAN2IDAR4_AC0                   _CAN2IDAR4.Bits.AC0
#define CAN2IDAR4_AC1                   _CAN2IDAR4.Bits.AC1
#define CAN2IDAR4_AC2                   _CAN2IDAR4.Bits.AC2
#define CAN2IDAR4_AC3                   _CAN2IDAR4.Bits.AC3
#define CAN2IDAR4_AC4                   _CAN2IDAR4.Bits.AC4
#define CAN2IDAR4_AC5                   _CAN2IDAR4.Bits.AC5
#define CAN2IDAR4_AC6                   _CAN2IDAR4.Bits.AC6
#define CAN2IDAR4_AC7                   _CAN2IDAR4.Bits.AC7

#define CAN2IDAR4_AC0_MASK              1U
#define CAN2IDAR4_AC1_MASK              2U
#define CAN2IDAR4_AC2_MASK              4U
#define CAN2IDAR4_AC3_MASK              8U
#define CAN2IDAR4_AC4_MASK              16U
#define CAN2IDAR4_AC5_MASK              32U
#define CAN2IDAR4_AC6_MASK              64U
#define CAN2IDAR4_AC7_MASK              128U


/*** CAN2IDAR5 - MSCAN 2 Identifier Acceptance Register 5; 0x000001D9 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN2IDAR5STR;
extern volatile CAN2IDAR5STR _CAN2IDAR5 @(REG_BASE + 0x000001D9UL);
#define CAN2IDAR5                       _CAN2IDAR5.Byte
#define CAN2IDAR5_AC0                   _CAN2IDAR5.Bits.AC0
#define CAN2IDAR5_AC1                   _CAN2IDAR5.Bits.AC1
#define CAN2IDAR5_AC2                   _CAN2IDAR5.Bits.AC2
#define CAN2IDAR5_AC3                   _CAN2IDAR5.Bits.AC3
#define CAN2IDAR5_AC4                   _CAN2IDAR5.Bits.AC4
#define CAN2IDAR5_AC5                   _CAN2IDAR5.Bits.AC5
#define CAN2IDAR5_AC6                   _CAN2IDAR5.Bits.AC6
#define CAN2IDAR5_AC7                   _CAN2IDAR5.Bits.AC7

#define CAN2IDAR5_AC0_MASK              1U
#define CAN2IDAR5_AC1_MASK              2U
#define CAN2IDAR5_AC2_MASK              4U
#define CAN2IDAR5_AC3_MASK              8U
#define CAN2IDAR5_AC4_MASK              16U
#define CAN2IDAR5_AC5_MASK              32U
#define CAN2IDAR5_AC6_MASK              64U
#define CAN2IDAR5_AC7_MASK              128U


/*** CAN2IDAR6 - MSCAN 2 Identifier Acceptance Register 6; 0x000001DA ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN2IDAR6STR;
extern volatile CAN2IDAR6STR _CAN2IDAR6 @(REG_BASE + 0x000001DAUL);
#define CAN2IDAR6                       _CAN2IDAR6.Byte
#define CAN2IDAR6_AC0                   _CAN2IDAR6.Bits.AC0
#define CAN2IDAR6_AC1                   _CAN2IDAR6.Bits.AC1
#define CAN2IDAR6_AC2                   _CAN2IDAR6.Bits.AC2
#define CAN2IDAR6_AC3                   _CAN2IDAR6.Bits.AC3
#define CAN2IDAR6_AC4                   _CAN2IDAR6.Bits.AC4
#define CAN2IDAR6_AC5                   _CAN2IDAR6.Bits.AC5
#define CAN2IDAR6_AC6                   _CAN2IDAR6.Bits.AC6
#define CAN2IDAR6_AC7                   _CAN2IDAR6.Bits.AC7

#define CAN2IDAR6_AC0_MASK              1U
#define CAN2IDAR6_AC1_MASK              2U
#define CAN2IDAR6_AC2_MASK              4U
#define CAN2IDAR6_AC3_MASK              8U
#define CAN2IDAR6_AC4_MASK              16U
#define CAN2IDAR6_AC5_MASK              32U
#define CAN2IDAR6_AC6_MASK              64U
#define CAN2IDAR6_AC7_MASK              128U


/*** CAN2IDAR7 - MSCAN 2 Identifier Acceptance Register 7; 0x000001DB ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN2IDAR7STR;
extern volatile CAN2IDAR7STR _CAN2IDAR7 @(REG_BASE + 0x000001DBUL);
#define CAN2IDAR7                       _CAN2IDAR7.Byte
#define CAN2IDAR7_AC0                   _CAN2IDAR7.Bits.AC0
#define CAN2IDAR7_AC1                   _CAN2IDAR7.Bits.AC1
#define CAN2IDAR7_AC2                   _CAN2IDAR7.Bits.AC2
#define CAN2IDAR7_AC3                   _CAN2IDAR7.Bits.AC3
#define CAN2IDAR7_AC4                   _CAN2IDAR7.Bits.AC4
#define CAN2IDAR7_AC5                   _CAN2IDAR7.Bits.AC5
#define CAN2IDAR7_AC6                   _CAN2IDAR7.Bits.AC6
#define CAN2IDAR7_AC7                   _CAN2IDAR7.Bits.AC7

#define CAN2IDAR7_AC0_MASK              1U
#define CAN2IDAR7_AC1_MASK              2U
#define CAN2IDAR7_AC2_MASK              4U
#define CAN2IDAR7_AC3_MASK              8U
#define CAN2IDAR7_AC4_MASK              16U
#define CAN2IDAR7_AC5_MASK              32U
#define CAN2IDAR7_AC6_MASK              64U
#define CAN2IDAR7_AC7_MASK              128U


/*** CAN2IDMR4 - MSCAN 2 Identifier Mask Register 4; 0x000001DC ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN2IDMR4STR;
extern volatile CAN2IDMR4STR _CAN2IDMR4 @(REG_BASE + 0x000001DCUL);
#define CAN2IDMR4                       _CAN2IDMR4.Byte
#define CAN2IDMR4_AM0                   _CAN2IDMR4.Bits.AM0
#define CAN2IDMR4_AM1                   _CAN2IDMR4.Bits.AM1
#define CAN2IDMR4_AM2                   _CAN2IDMR4.Bits.AM2
#define CAN2IDMR4_AM3                   _CAN2IDMR4.Bits.AM3
#define CAN2IDMR4_AM4                   _CAN2IDMR4.Bits.AM4
#define CAN2IDMR4_AM5                   _CAN2IDMR4.Bits.AM5
#define CAN2IDMR4_AM6                   _CAN2IDMR4.Bits.AM6
#define CAN2IDMR4_AM7                   _CAN2IDMR4.Bits.AM7

#define CAN2IDMR4_AM0_MASK              1U
#define CAN2IDMR4_AM1_MASK              2U
#define CAN2IDMR4_AM2_MASK              4U
#define CAN2IDMR4_AM3_MASK              8U
#define CAN2IDMR4_AM4_MASK              16U
#define CAN2IDMR4_AM5_MASK              32U
#define CAN2IDMR4_AM6_MASK              64U
#define CAN2IDMR4_AM7_MASK              128U


/*** CAN2IDMR5 - MSCAN 2 Identifier Mask Register 5; 0x000001DD ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN2IDMR5STR;
extern volatile CAN2IDMR5STR _CAN2IDMR5 @(REG_BASE + 0x000001DDUL);
#define CAN2IDMR5                       _CAN2IDMR5.Byte
#define CAN2IDMR5_AM0                   _CAN2IDMR5.Bits.AM0
#define CAN2IDMR5_AM1                   _CAN2IDMR5.Bits.AM1
#define CAN2IDMR5_AM2                   _CAN2IDMR5.Bits.AM2
#define CAN2IDMR5_AM3                   _CAN2IDMR5.Bits.AM3
#define CAN2IDMR5_AM4                   _CAN2IDMR5.Bits.AM4
#define CAN2IDMR5_AM5                   _CAN2IDMR5.Bits.AM5
#define CAN2IDMR5_AM6                   _CAN2IDMR5.Bits.AM6
#define CAN2IDMR5_AM7                   _CAN2IDMR5.Bits.AM7

#define CAN2IDMR5_AM0_MASK              1U
#define CAN2IDMR5_AM1_MASK              2U
#define CAN2IDMR5_AM2_MASK              4U
#define CAN2IDMR5_AM3_MASK              8U
#define CAN2IDMR5_AM4_MASK              16U
#define CAN2IDMR5_AM5_MASK              32U
#define CAN2IDMR5_AM6_MASK              64U
#define CAN2IDMR5_AM7_MASK              128U


/*** CAN2IDMR6 - MSCAN 2 Identifier Mask Register 6; 0x000001DE ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN2IDMR6STR;
extern volatile CAN2IDMR6STR _CAN2IDMR6 @(REG_BASE + 0x000001DEUL);
#define CAN2IDMR6                       _CAN2IDMR6.Byte
#define CAN2IDMR6_AM0                   _CAN2IDMR6.Bits.AM0
#define CAN2IDMR6_AM1                   _CAN2IDMR6.Bits.AM1
#define CAN2IDMR6_AM2                   _CAN2IDMR6.Bits.AM2
#define CAN2IDMR6_AM3                   _CAN2IDMR6.Bits.AM3
#define CAN2IDMR6_AM4                   _CAN2IDMR6.Bits.AM4
#define CAN2IDMR6_AM5                   _CAN2IDMR6.Bits.AM5
#define CAN2IDMR6_AM6                   _CAN2IDMR6.Bits.AM6
#define CAN2IDMR6_AM7                   _CAN2IDMR6.Bits.AM7

#define CAN2IDMR6_AM0_MASK              1U
#define CAN2IDMR6_AM1_MASK              2U
#define CAN2IDMR6_AM2_MASK              4U
#define CAN2IDMR6_AM3_MASK              8U
#define CAN2IDMR6_AM4_MASK              16U
#define CAN2IDMR6_AM5_MASK              32U
#define CAN2IDMR6_AM6_MASK              64U
#define CAN2IDMR6_AM7_MASK              128U


/*** CAN2IDMR7 - MSCAN 2 Identifier Mask Register 7; 0x000001DF ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN2IDMR7STR;
extern volatile CAN2IDMR7STR _CAN2IDMR7 @(REG_BASE + 0x000001DFUL);
#define CAN2IDMR7                       _CAN2IDMR7.Byte
#define CAN2IDMR7_AM0                   _CAN2IDMR7.Bits.AM0
#define CAN2IDMR7_AM1                   _CAN2IDMR7.Bits.AM1
#define CAN2IDMR7_AM2                   _CAN2IDMR7.Bits.AM2
#define CAN2IDMR7_AM3                   _CAN2IDMR7.Bits.AM3
#define CAN2IDMR7_AM4                   _CAN2IDMR7.Bits.AM4
#define CAN2IDMR7_AM5                   _CAN2IDMR7.Bits.AM5
#define CAN2IDMR7_AM6                   _CAN2IDMR7.Bits.AM6
#define CAN2IDMR7_AM7                   _CAN2IDMR7.Bits.AM7

#define CAN2IDMR7_AM0_MASK              1U
#define CAN2IDMR7_AM1_MASK              2U
#define CAN2IDMR7_AM2_MASK              4U
#define CAN2IDMR7_AM3_MASK              8U
#define CAN2IDMR7_AM4_MASK              16U
#define CAN2IDMR7_AM5_MASK              32U
#define CAN2IDMR7_AM6_MASK              64U
#define CAN2IDMR7_AM7_MASK              128U


/*** CAN2RXIDR0 - MSCAN 2 Receive Identifier Register 0; 0x000001E0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN2RXIDR0STR;
extern volatile CAN2RXIDR0STR _CAN2RXIDR0 @(REG_BASE + 0x000001E0UL);
#define CAN2RXIDR0                      _CAN2RXIDR0.Byte
#define CAN2RXIDR0_ID21                 _CAN2RXIDR0.Bits.ID21
#define CAN2RXIDR0_ID22                 _CAN2RXIDR0.Bits.ID22
#define CAN2RXIDR0_ID23                 _CAN2RXIDR0.Bits.ID23
#define CAN2RXIDR0_ID24                 _CAN2RXIDR0.Bits.ID24
#define CAN2RXIDR0_ID25                 _CAN2RXIDR0.Bits.ID25
#define CAN2RXIDR0_ID26                 _CAN2RXIDR0.Bits.ID26
#define CAN2RXIDR0_ID27                 _CAN2RXIDR0.Bits.ID27
#define CAN2RXIDR0_ID28                 _CAN2RXIDR0.Bits.ID28
/* CAN2RXIDR_ARR: Access 4 CAN2RXIDRx registers in an array */
#define CAN2RXIDR_ARR                   ((volatile byte *) &CAN2RXIDR0)

#define CAN2RXIDR0_ID21_MASK            1U
#define CAN2RXIDR0_ID22_MASK            2U
#define CAN2RXIDR0_ID23_MASK            4U
#define CAN2RXIDR0_ID24_MASK            8U
#define CAN2RXIDR0_ID25_MASK            16U
#define CAN2RXIDR0_ID26_MASK            32U
#define CAN2RXIDR0_ID27_MASK            64U
#define CAN2RXIDR0_ID28_MASK            128U


/*** CAN2RXIDR1 - MSCAN 2 Receive Identifier Register 1; 0x000001E1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN2RXIDR1STR;
extern volatile CAN2RXIDR1STR _CAN2RXIDR1 @(REG_BASE + 0x000001E1UL);
#define CAN2RXIDR1                      _CAN2RXIDR1.Byte
#define CAN2RXIDR1_ID15                 _CAN2RXIDR1.Bits.ID15
#define CAN2RXIDR1_ID16                 _CAN2RXIDR1.Bits.ID16
#define CAN2RXIDR1_ID17                 _CAN2RXIDR1.Bits.ID17
#define CAN2RXIDR1_IDE                  _CAN2RXIDR1.Bits.IDE
#define CAN2RXIDR1_SRR                  _CAN2RXIDR1.Bits.SRR
#define CAN2RXIDR1_ID18                 _CAN2RXIDR1.Bits.ID18
#define CAN2RXIDR1_ID19                 _CAN2RXIDR1.Bits.ID19
#define CAN2RXIDR1_ID20                 _CAN2RXIDR1.Bits.ID20
#define CAN2RXIDR1_ID_15                _CAN2RXIDR1.MergedBits.grpID_15
#define CAN2RXIDR1_ID_18                _CAN2RXIDR1.MergedBits.grpID_18
#define CAN2RXIDR1_ID                   CAN2RXIDR1_ID_15

#define CAN2RXIDR1_ID15_MASK            1U
#define CAN2RXIDR1_ID16_MASK            2U
#define CAN2RXIDR1_ID17_MASK            4U
#define CAN2RXIDR1_IDE_MASK             8U
#define CAN2RXIDR1_SRR_MASK             16U
#define CAN2RXIDR1_ID18_MASK            32U
#define CAN2RXIDR1_ID19_MASK            64U
#define CAN2RXIDR1_ID20_MASK            128U
#define CAN2RXIDR1_ID_15_MASK           7U
#define CAN2RXIDR1_ID_15_BITNUM         0U
#define CAN2RXIDR1_ID_18_MASK           224U
#define CAN2RXIDR1_ID_18_BITNUM         5U


/*** CAN2RXIDR2 - MSCAN 2 Receive Identifier Register 2; 0x000001E2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN2RXIDR2STR;
extern volatile CAN2RXIDR2STR _CAN2RXIDR2 @(REG_BASE + 0x000001E2UL);
#define CAN2RXIDR2                      _CAN2RXIDR2.Byte
#define CAN2RXIDR2_ID7                  _CAN2RXIDR2.Bits.ID7
#define CAN2RXIDR2_ID8                  _CAN2RXIDR2.Bits.ID8
#define CAN2RXIDR2_ID9                  _CAN2RXIDR2.Bits.ID9
#define CAN2RXIDR2_ID10                 _CAN2RXIDR2.Bits.ID10
#define CAN2RXIDR2_ID11                 _CAN2RXIDR2.Bits.ID11
#define CAN2RXIDR2_ID12                 _CAN2RXIDR2.Bits.ID12
#define CAN2RXIDR2_ID13                 _CAN2RXIDR2.Bits.ID13
#define CAN2RXIDR2_ID14                 _CAN2RXIDR2.Bits.ID14

#define CAN2RXIDR2_ID7_MASK             1U
#define CAN2RXIDR2_ID8_MASK             2U
#define CAN2RXIDR2_ID9_MASK             4U
#define CAN2RXIDR2_ID10_MASK            8U
#define CAN2RXIDR2_ID11_MASK            16U
#define CAN2RXIDR2_ID12_MASK            32U
#define CAN2RXIDR2_ID13_MASK            64U
#define CAN2RXIDR2_ID14_MASK            128U


/*** CAN2RXIDR3 - MSCAN 2 Receive Identifier Register 3; 0x000001E3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN2RXIDR3STR;
extern volatile CAN2RXIDR3STR _CAN2RXIDR3 @(REG_BASE + 0x000001E3UL);
#define CAN2RXIDR3                      _CAN2RXIDR3.Byte
#define CAN2RXIDR3_RTR                  _CAN2RXIDR3.Bits.RTR
#define CAN2RXIDR3_ID0                  _CAN2RXIDR3.Bits.ID0
#define CAN2RXIDR3_ID1                  _CAN2RXIDR3.Bits.ID1
#define CAN2RXIDR3_ID2                  _CAN2RXIDR3.Bits.ID2
#define CAN2RXIDR3_ID3                  _CAN2RXIDR3.Bits.ID3
#define CAN2RXIDR3_ID4                  _CAN2RXIDR3.Bits.ID4
#define CAN2RXIDR3_ID5                  _CAN2RXIDR3.Bits.ID5
#define CAN2RXIDR3_ID6                  _CAN2RXIDR3.Bits.ID6
#define CAN2RXIDR3_ID                   _CAN2RXIDR3.MergedBits.grpID

#define CAN2RXIDR3_RTR_MASK             1U
#define CAN2RXIDR3_ID0_MASK             2U
#define CAN2RXIDR3_ID1_MASK             4U
#define CAN2RXIDR3_ID2_MASK             8U
#define CAN2RXIDR3_ID3_MASK             16U
#define CAN2RXIDR3_ID4_MASK             32U
#define CAN2RXIDR3_ID5_MASK             64U
#define CAN2RXIDR3_ID6_MASK             128U
#define CAN2RXIDR3_ID_MASK              254U
#define CAN2RXIDR3_ID_BITNUM            1U


/*** CAN2RXDSR0 - MSCAN 2 Receive Data Segment Register 0; 0x000001E4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2RXDSR0STR;
extern volatile CAN2RXDSR0STR _CAN2RXDSR0 @(REG_BASE + 0x000001E4UL);
#define CAN2RXDSR0                      _CAN2RXDSR0.Byte
#define CAN2RXDSR0_DB0                  _CAN2RXDSR0.Bits.DB0
#define CAN2RXDSR0_DB1                  _CAN2RXDSR0.Bits.DB1
#define CAN2RXDSR0_DB2                  _CAN2RXDSR0.Bits.DB2
#define CAN2RXDSR0_DB3                  _CAN2RXDSR0.Bits.DB3
#define CAN2RXDSR0_DB4                  _CAN2RXDSR0.Bits.DB4
#define CAN2RXDSR0_DB5                  _CAN2RXDSR0.Bits.DB5
#define CAN2RXDSR0_DB6                  _CAN2RXDSR0.Bits.DB6
#define CAN2RXDSR0_DB7                  _CAN2RXDSR0.Bits.DB7
/* CAN2RXDSR_ARR: Access 8 CAN2RXDSRx registers in an array */
#define CAN2RXDSR_ARR                   ((volatile byte *) &CAN2RXDSR0)

#define CAN2RXDSR0_DB0_MASK             1U
#define CAN2RXDSR0_DB1_MASK             2U
#define CAN2RXDSR0_DB2_MASK             4U
#define CAN2RXDSR0_DB3_MASK             8U
#define CAN2RXDSR0_DB4_MASK             16U
#define CAN2RXDSR0_DB5_MASK             32U
#define CAN2RXDSR0_DB6_MASK             64U
#define CAN2RXDSR0_DB7_MASK             128U


/*** CAN2RXDSR1 - MSCAN 2 Receive Data Segment Register 1; 0x000001E5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2RXDSR1STR;
extern volatile CAN2RXDSR1STR _CAN2RXDSR1 @(REG_BASE + 0x000001E5UL);
#define CAN2RXDSR1                      _CAN2RXDSR1.Byte
#define CAN2RXDSR1_DB0                  _CAN2RXDSR1.Bits.DB0
#define CAN2RXDSR1_DB1                  _CAN2RXDSR1.Bits.DB1
#define CAN2RXDSR1_DB2                  _CAN2RXDSR1.Bits.DB2
#define CAN2RXDSR1_DB3                  _CAN2RXDSR1.Bits.DB3
#define CAN2RXDSR1_DB4                  _CAN2RXDSR1.Bits.DB4
#define CAN2RXDSR1_DB5                  _CAN2RXDSR1.Bits.DB5
#define CAN2RXDSR1_DB6                  _CAN2RXDSR1.Bits.DB6
#define CAN2RXDSR1_DB7                  _CAN2RXDSR1.Bits.DB7

#define CAN2RXDSR1_DB0_MASK             1U
#define CAN2RXDSR1_DB1_MASK             2U
#define CAN2RXDSR1_DB2_MASK             4U
#define CAN2RXDSR1_DB3_MASK             8U
#define CAN2RXDSR1_DB4_MASK             16U
#define CAN2RXDSR1_DB5_MASK             32U
#define CAN2RXDSR1_DB6_MASK             64U
#define CAN2RXDSR1_DB7_MASK             128U


/*** CAN2RXDSR2 - MSCAN 2 Receive Data Segment Register 2; 0x000001E6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2RXDSR2STR;
extern volatile CAN2RXDSR2STR _CAN2RXDSR2 @(REG_BASE + 0x000001E6UL);
#define CAN2RXDSR2                      _CAN2RXDSR2.Byte
#define CAN2RXDSR2_DB0                  _CAN2RXDSR2.Bits.DB0
#define CAN2RXDSR2_DB1                  _CAN2RXDSR2.Bits.DB1
#define CAN2RXDSR2_DB2                  _CAN2RXDSR2.Bits.DB2
#define CAN2RXDSR2_DB3                  _CAN2RXDSR2.Bits.DB3
#define CAN2RXDSR2_DB4                  _CAN2RXDSR2.Bits.DB4
#define CAN2RXDSR2_DB5                  _CAN2RXDSR2.Bits.DB5
#define CAN2RXDSR2_DB6                  _CAN2RXDSR2.Bits.DB6
#define CAN2RXDSR2_DB7                  _CAN2RXDSR2.Bits.DB7

#define CAN2RXDSR2_DB0_MASK             1U
#define CAN2RXDSR2_DB1_MASK             2U
#define CAN2RXDSR2_DB2_MASK             4U
#define CAN2RXDSR2_DB3_MASK             8U
#define CAN2RXDSR2_DB4_MASK             16U
#define CAN2RXDSR2_DB5_MASK             32U
#define CAN2RXDSR2_DB6_MASK             64U
#define CAN2RXDSR2_DB7_MASK             128U


/*** CAN2RXDSR3 - MSCAN 2 Receive Data Segment Register 3; 0x000001E7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2RXDSR3STR;
extern volatile CAN2RXDSR3STR _CAN2RXDSR3 @(REG_BASE + 0x000001E7UL);
#define CAN2RXDSR3                      _CAN2RXDSR3.Byte
#define CAN2RXDSR3_DB0                  _CAN2RXDSR3.Bits.DB0
#define CAN2RXDSR3_DB1                  _CAN2RXDSR3.Bits.DB1
#define CAN2RXDSR3_DB2                  _CAN2RXDSR3.Bits.DB2
#define CAN2RXDSR3_DB3                  _CAN2RXDSR3.Bits.DB3
#define CAN2RXDSR3_DB4                  _CAN2RXDSR3.Bits.DB4
#define CAN2RXDSR3_DB5                  _CAN2RXDSR3.Bits.DB5
#define CAN2RXDSR3_DB6                  _CAN2RXDSR3.Bits.DB6
#define CAN2RXDSR3_DB7                  _CAN2RXDSR3.Bits.DB7

#define CAN2RXDSR3_DB0_MASK             1U
#define CAN2RXDSR3_DB1_MASK             2U
#define CAN2RXDSR3_DB2_MASK             4U
#define CAN2RXDSR3_DB3_MASK             8U
#define CAN2RXDSR3_DB4_MASK             16U
#define CAN2RXDSR3_DB5_MASK             32U
#define CAN2RXDSR3_DB6_MASK             64U
#define CAN2RXDSR3_DB7_MASK             128U


/*** CAN2RXDSR4 - MSCAN 2 Receive Data Segment Register 4; 0x000001E8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2RXDSR4STR;
extern volatile CAN2RXDSR4STR _CAN2RXDSR4 @(REG_BASE + 0x000001E8UL);
#define CAN2RXDSR4                      _CAN2RXDSR4.Byte
#define CAN2RXDSR4_DB0                  _CAN2RXDSR4.Bits.DB0
#define CAN2RXDSR4_DB1                  _CAN2RXDSR4.Bits.DB1
#define CAN2RXDSR4_DB2                  _CAN2RXDSR4.Bits.DB2
#define CAN2RXDSR4_DB3                  _CAN2RXDSR4.Bits.DB3
#define CAN2RXDSR4_DB4                  _CAN2RXDSR4.Bits.DB4
#define CAN2RXDSR4_DB5                  _CAN2RXDSR4.Bits.DB5
#define CAN2RXDSR4_DB6                  _CAN2RXDSR4.Bits.DB6
#define CAN2RXDSR4_DB7                  _CAN2RXDSR4.Bits.DB7

#define CAN2RXDSR4_DB0_MASK             1U
#define CAN2RXDSR4_DB1_MASK             2U
#define CAN2RXDSR4_DB2_MASK             4U
#define CAN2RXDSR4_DB3_MASK             8U
#define CAN2RXDSR4_DB4_MASK             16U
#define CAN2RXDSR4_DB5_MASK             32U
#define CAN2RXDSR4_DB6_MASK             64U
#define CAN2RXDSR4_DB7_MASK             128U


/*** CAN2RXDSR5 - MSCAN 2 Receive Data Segment Register 5; 0x000001E9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2RXDSR5STR;
extern volatile CAN2RXDSR5STR _CAN2RXDSR5 @(REG_BASE + 0x000001E9UL);
#define CAN2RXDSR5                      _CAN2RXDSR5.Byte
#define CAN2RXDSR5_DB0                  _CAN2RXDSR5.Bits.DB0
#define CAN2RXDSR5_DB1                  _CAN2RXDSR5.Bits.DB1
#define CAN2RXDSR5_DB2                  _CAN2RXDSR5.Bits.DB2
#define CAN2RXDSR5_DB3                  _CAN2RXDSR5.Bits.DB3
#define CAN2RXDSR5_DB4                  _CAN2RXDSR5.Bits.DB4
#define CAN2RXDSR5_DB5                  _CAN2RXDSR5.Bits.DB5
#define CAN2RXDSR5_DB6                  _CAN2RXDSR5.Bits.DB6
#define CAN2RXDSR5_DB7                  _CAN2RXDSR5.Bits.DB7

#define CAN2RXDSR5_DB0_MASK             1U
#define CAN2RXDSR5_DB1_MASK             2U
#define CAN2RXDSR5_DB2_MASK             4U
#define CAN2RXDSR5_DB3_MASK             8U
#define CAN2RXDSR5_DB4_MASK             16U
#define CAN2RXDSR5_DB5_MASK             32U
#define CAN2RXDSR5_DB6_MASK             64U
#define CAN2RXDSR5_DB7_MASK             128U


/*** CAN2RXDSR6 - MSCAN 2 Receive Data Segment Register 6; 0x000001EA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2RXDSR6STR;
extern volatile CAN2RXDSR6STR _CAN2RXDSR6 @(REG_BASE + 0x000001EAUL);
#define CAN2RXDSR6                      _CAN2RXDSR6.Byte
#define CAN2RXDSR6_DB0                  _CAN2RXDSR6.Bits.DB0
#define CAN2RXDSR6_DB1                  _CAN2RXDSR6.Bits.DB1
#define CAN2RXDSR6_DB2                  _CAN2RXDSR6.Bits.DB2
#define CAN2RXDSR6_DB3                  _CAN2RXDSR6.Bits.DB3
#define CAN2RXDSR6_DB4                  _CAN2RXDSR6.Bits.DB4
#define CAN2RXDSR6_DB5                  _CAN2RXDSR6.Bits.DB5
#define CAN2RXDSR6_DB6                  _CAN2RXDSR6.Bits.DB6
#define CAN2RXDSR6_DB7                  _CAN2RXDSR6.Bits.DB7

#define CAN2RXDSR6_DB0_MASK             1U
#define CAN2RXDSR6_DB1_MASK             2U
#define CAN2RXDSR6_DB2_MASK             4U
#define CAN2RXDSR6_DB3_MASK             8U
#define CAN2RXDSR6_DB4_MASK             16U
#define CAN2RXDSR6_DB5_MASK             32U
#define CAN2RXDSR6_DB6_MASK             64U
#define CAN2RXDSR6_DB7_MASK             128U


/*** CAN2RXDSR7 - MSCAN 2 Receive Data Segment Register 7; 0x000001EB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2RXDSR7STR;
extern volatile CAN2RXDSR7STR _CAN2RXDSR7 @(REG_BASE + 0x000001EBUL);
#define CAN2RXDSR7                      _CAN2RXDSR7.Byte
#define CAN2RXDSR7_DB0                  _CAN2RXDSR7.Bits.DB0
#define CAN2RXDSR7_DB1                  _CAN2RXDSR7.Bits.DB1
#define CAN2RXDSR7_DB2                  _CAN2RXDSR7.Bits.DB2
#define CAN2RXDSR7_DB3                  _CAN2RXDSR7.Bits.DB3
#define CAN2RXDSR7_DB4                  _CAN2RXDSR7.Bits.DB4
#define CAN2RXDSR7_DB5                  _CAN2RXDSR7.Bits.DB5
#define CAN2RXDSR7_DB6                  _CAN2RXDSR7.Bits.DB6
#define CAN2RXDSR7_DB7                  _CAN2RXDSR7.Bits.DB7

#define CAN2RXDSR7_DB0_MASK             1U
#define CAN2RXDSR7_DB1_MASK             2U
#define CAN2RXDSR7_DB2_MASK             4U
#define CAN2RXDSR7_DB3_MASK             8U
#define CAN2RXDSR7_DB4_MASK             16U
#define CAN2RXDSR7_DB5_MASK             32U
#define CAN2RXDSR7_DB6_MASK             64U
#define CAN2RXDSR7_DB7_MASK             128U


/*** CAN2RXDLR - MSCAN 2 Receive Data Length Register; 0x000001EC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2RXDLRSTR;
extern volatile CAN2RXDLRSTR _CAN2RXDLR @(REG_BASE + 0x000001ECUL);
#define CAN2RXDLR                       _CAN2RXDLR.Byte
#define CAN2RXDLR_DLC0                  _CAN2RXDLR.Bits.DLC0
#define CAN2RXDLR_DLC1                  _CAN2RXDLR.Bits.DLC1
#define CAN2RXDLR_DLC2                  _CAN2RXDLR.Bits.DLC2
#define CAN2RXDLR_DLC3                  _CAN2RXDLR.Bits.DLC3
#define CAN2RXDLR_DLC                   _CAN2RXDLR.MergedBits.grpDLC

#define CAN2RXDLR_DLC0_MASK             1U
#define CAN2RXDLR_DLC1_MASK             2U
#define CAN2RXDLR_DLC2_MASK             4U
#define CAN2RXDLR_DLC3_MASK             8U
#define CAN2RXDLR_DLC_MASK              15U
#define CAN2RXDLR_DLC_BITNUM            0U


/*** CAN2RXTSR - MSCAN 2 Receive Time Stamp Register; 0x000001EE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN2RXTSRH - MSCAN 2 Receive Time Stamp Register High; 0x000001EE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN2RXTSRHSTR;
    #define CAN2RXTSRH                  _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Byte
    #define CAN2RXTSRH_TSR8             _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Bits.TSR8
    #define CAN2RXTSRH_TSR9             _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Bits.TSR9
    #define CAN2RXTSRH_TSR10            _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Bits.TSR10
    #define CAN2RXTSRH_TSR11            _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Bits.TSR11
    #define CAN2RXTSRH_TSR12            _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Bits.TSR12
    #define CAN2RXTSRH_TSR13            _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Bits.TSR13
    #define CAN2RXTSRH_TSR14            _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Bits.TSR14
    #define CAN2RXTSRH_TSR15            _CAN2RXTSR.Overlap_STR.CAN2RXTSRHSTR.Bits.TSR15
    
    #define CAN2RXTSRH_TSR8_MASK        1U
    #define CAN2RXTSRH_TSR9_MASK        2U
    #define CAN2RXTSRH_TSR10_MASK       4U
    #define CAN2RXTSRH_TSR11_MASK       8U
    #define CAN2RXTSRH_TSR12_MASK       16U
    #define CAN2RXTSRH_TSR13_MASK       32U
    #define CAN2RXTSRH_TSR14_MASK       64U
    #define CAN2RXTSRH_TSR15_MASK       128U
    

    /*** CAN2RXTSRL - MSCAN 2 Receive Time Stamp Register Low; 0x000001EF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN2RXTSRLSTR;
    #define CAN2RXTSRL                  _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Byte
    #define CAN2RXTSRL_TSR0             _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Bits.TSR0
    #define CAN2RXTSRL_TSR1             _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Bits.TSR1
    #define CAN2RXTSRL_TSR2             _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Bits.TSR2
    #define CAN2RXTSRL_TSR3             _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Bits.TSR3
    #define CAN2RXTSRL_TSR4             _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Bits.TSR4
    #define CAN2RXTSRL_TSR5             _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Bits.TSR5
    #define CAN2RXTSRL_TSR6             _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Bits.TSR6
    #define CAN2RXTSRL_TSR7             _CAN2RXTSR.Overlap_STR.CAN2RXTSRLSTR.Bits.TSR7
    
    #define CAN2RXTSRL_TSR0_MASK        1U
    #define CAN2RXTSRL_TSR1_MASK        2U
    #define CAN2RXTSRL_TSR2_MASK        4U
    #define CAN2RXTSRL_TSR3_MASK        8U
    #define CAN2RXTSRL_TSR4_MASK        16U
    #define CAN2RXTSRL_TSR5_MASK        32U
    #define CAN2RXTSRL_TSR6_MASK        64U
    #define CAN2RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN2RXTSRSTR;
extern volatile CAN2RXTSRSTR _CAN2RXTSR @(REG_BASE + 0x000001EEUL);
#define CAN2RXTSR                       _CAN2RXTSR.Word
#define CAN2RXTSR_TSR0                  _CAN2RXTSR.Bits.TSR0
#define CAN2RXTSR_TSR1                  _CAN2RXTSR.Bits.TSR1
#define CAN2RXTSR_TSR2                  _CAN2RXTSR.Bits.TSR2
#define CAN2RXTSR_TSR3                  _CAN2RXTSR.Bits.TSR3
#define CAN2RXTSR_TSR4                  _CAN2RXTSR.Bits.TSR4
#define CAN2RXTSR_TSR5                  _CAN2RXTSR.Bits.TSR5
#define CAN2RXTSR_TSR6                  _CAN2RXTSR.Bits.TSR6
#define CAN2RXTSR_TSR7                  _CAN2RXTSR.Bits.TSR7
#define CAN2RXTSR_TSR8                  _CAN2RXTSR.Bits.TSR8
#define CAN2RXTSR_TSR9                  _CAN2RXTSR.Bits.TSR9
#define CAN2RXTSR_TSR10                 _CAN2RXTSR.Bits.TSR10
#define CAN2RXTSR_TSR11                 _CAN2RXTSR.Bits.TSR11
#define CAN2RXTSR_TSR12                 _CAN2RXTSR.Bits.TSR12
#define CAN2RXTSR_TSR13                 _CAN2RXTSR.Bits.TSR13
#define CAN2RXTSR_TSR14                 _CAN2RXTSR.Bits.TSR14
#define CAN2RXTSR_TSR15                 _CAN2RXTSR.Bits.TSR15

#define CAN2RXTSR_TSR0_MASK             1U
#define CAN2RXTSR_TSR1_MASK             2U
#define CAN2RXTSR_TSR2_MASK             4U
#define CAN2RXTSR_TSR3_MASK             8U
#define CAN2RXTSR_TSR4_MASK             16U
#define CAN2RXTSR_TSR5_MASK             32U
#define CAN2RXTSR_TSR6_MASK             64U
#define CAN2RXTSR_TSR7_MASK             128U
#define CAN2RXTSR_TSR8_MASK             256U
#define CAN2RXTSR_TSR9_MASK             512U
#define CAN2RXTSR_TSR10_MASK            1024U
#define CAN2RXTSR_TSR11_MASK            2048U
#define CAN2RXTSR_TSR12_MASK            4096U
#define CAN2RXTSR_TSR13_MASK            8192U
#define CAN2RXTSR_TSR14_MASK            16384U
#define CAN2RXTSR_TSR15_MASK            32768U


/*** CAN2TXIDR0 - MSCAN 2 Transmit Identifier Register 0; 0x000001F0 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN2TXIDR0STR;
extern volatile CAN2TXIDR0STR _CAN2TXIDR0 @(REG_BASE + 0x000001F0UL);
#define CAN2TXIDR0                      _CAN2TXIDR0.Byte
#define CAN2TXIDR0_ID21                 _CAN2TXIDR0.Bits.ID21
#define CAN2TXIDR0_ID22                 _CAN2TXIDR0.Bits.ID22
#define CAN2TXIDR0_ID23                 _CAN2TXIDR0.Bits.ID23
#define CAN2TXIDR0_ID24                 _CAN2TXIDR0.Bits.ID24
#define CAN2TXIDR0_ID25                 _CAN2TXIDR0.Bits.ID25
#define CAN2TXIDR0_ID26                 _CAN2TXIDR0.Bits.ID26
#define CAN2TXIDR0_ID27                 _CAN2TXIDR0.Bits.ID27
#define CAN2TXIDR0_ID28                 _CAN2TXIDR0.Bits.ID28
/* CAN2TXIDR_ARR: Access 4 CAN2TXIDRx registers in an array */
#define CAN2TXIDR_ARR                   ((volatile byte *) &CAN2TXIDR0)

#define CAN2TXIDR0_ID21_MASK            1U
#define CAN2TXIDR0_ID22_MASK            2U
#define CAN2TXIDR0_ID23_MASK            4U
#define CAN2TXIDR0_ID24_MASK            8U
#define CAN2TXIDR0_ID25_MASK            16U
#define CAN2TXIDR0_ID26_MASK            32U
#define CAN2TXIDR0_ID27_MASK            64U
#define CAN2TXIDR0_ID28_MASK            128U


/*** CAN2TXIDR1 - MSCAN 2 Transmit Identifier Register 1; 0x000001F1 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN2TXIDR1STR;
extern volatile CAN2TXIDR1STR _CAN2TXIDR1 @(REG_BASE + 0x000001F1UL);
#define CAN2TXIDR1                      _CAN2TXIDR1.Byte
#define CAN2TXIDR1_ID15                 _CAN2TXIDR1.Bits.ID15
#define CAN2TXIDR1_ID16                 _CAN2TXIDR1.Bits.ID16
#define CAN2TXIDR1_ID17                 _CAN2TXIDR1.Bits.ID17
#define CAN2TXIDR1_IDE                  _CAN2TXIDR1.Bits.IDE
#define CAN2TXIDR1_SRR                  _CAN2TXIDR1.Bits.SRR
#define CAN2TXIDR1_ID18                 _CAN2TXIDR1.Bits.ID18
#define CAN2TXIDR1_ID19                 _CAN2TXIDR1.Bits.ID19
#define CAN2TXIDR1_ID20                 _CAN2TXIDR1.Bits.ID20
#define CAN2TXIDR1_ID_15                _CAN2TXIDR1.MergedBits.grpID_15
#define CAN2TXIDR1_ID_18                _CAN2TXIDR1.MergedBits.grpID_18
#define CAN2TXIDR1_ID                   CAN2TXIDR1_ID_15

#define CAN2TXIDR1_ID15_MASK            1U
#define CAN2TXIDR1_ID16_MASK            2U
#define CAN2TXIDR1_ID17_MASK            4U
#define CAN2TXIDR1_IDE_MASK             8U
#define CAN2TXIDR1_SRR_MASK             16U
#define CAN2TXIDR1_ID18_MASK            32U
#define CAN2TXIDR1_ID19_MASK            64U
#define CAN2TXIDR1_ID20_MASK            128U
#define CAN2TXIDR1_ID_15_MASK           7U
#define CAN2TXIDR1_ID_15_BITNUM         0U
#define CAN2TXIDR1_ID_18_MASK           224U
#define CAN2TXIDR1_ID_18_BITNUM         5U


/*** CAN2TXIDR2 - MSCAN 2 Transmit Identifier Register 2; 0x000001F2 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN2TXIDR2STR;
extern volatile CAN2TXIDR2STR _CAN2TXIDR2 @(REG_BASE + 0x000001F2UL);
#define CAN2TXIDR2                      _CAN2TXIDR2.Byte
#define CAN2TXIDR2_ID7                  _CAN2TXIDR2.Bits.ID7
#define CAN2TXIDR2_ID8                  _CAN2TXIDR2.Bits.ID8
#define CAN2TXIDR2_ID9                  _CAN2TXIDR2.Bits.ID9
#define CAN2TXIDR2_ID10                 _CAN2TXIDR2.Bits.ID10
#define CAN2TXIDR2_ID11                 _CAN2TXIDR2.Bits.ID11
#define CAN2TXIDR2_ID12                 _CAN2TXIDR2.Bits.ID12
#define CAN2TXIDR2_ID13                 _CAN2TXIDR2.Bits.ID13
#define CAN2TXIDR2_ID14                 _CAN2TXIDR2.Bits.ID14

#define CAN2TXIDR2_ID7_MASK             1U
#define CAN2TXIDR2_ID8_MASK             2U
#define CAN2TXIDR2_ID9_MASK             4U
#define CAN2TXIDR2_ID10_MASK            8U
#define CAN2TXIDR2_ID11_MASK            16U
#define CAN2TXIDR2_ID12_MASK            32U
#define CAN2TXIDR2_ID13_MASK            64U
#define CAN2TXIDR2_ID14_MASK            128U


/*** CAN2TXIDR3 - MSCAN 2 Transmit Identifier Register 3; 0x000001F3 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN2TXIDR3STR;
extern volatile CAN2TXIDR3STR _CAN2TXIDR3 @(REG_BASE + 0x000001F3UL);
#define CAN2TXIDR3                      _CAN2TXIDR3.Byte
#define CAN2TXIDR3_RTR                  _CAN2TXIDR3.Bits.RTR
#define CAN2TXIDR3_ID0                  _CAN2TXIDR3.Bits.ID0
#define CAN2TXIDR3_ID1                  _CAN2TXIDR3.Bits.ID1
#define CAN2TXIDR3_ID2                  _CAN2TXIDR3.Bits.ID2
#define CAN2TXIDR3_ID3                  _CAN2TXIDR3.Bits.ID3
#define CAN2TXIDR3_ID4                  _CAN2TXIDR3.Bits.ID4
#define CAN2TXIDR3_ID5                  _CAN2TXIDR3.Bits.ID5
#define CAN2TXIDR3_ID6                  _CAN2TXIDR3.Bits.ID6
#define CAN2TXIDR3_ID                   _CAN2TXIDR3.MergedBits.grpID

#define CAN2TXIDR3_RTR_MASK             1U
#define CAN2TXIDR3_ID0_MASK             2U
#define CAN2TXIDR3_ID1_MASK             4U
#define CAN2TXIDR3_ID2_MASK             8U
#define CAN2TXIDR3_ID3_MASK             16U
#define CAN2TXIDR3_ID4_MASK             32U
#define CAN2TXIDR3_ID5_MASK             64U
#define CAN2TXIDR3_ID6_MASK             128U
#define CAN2TXIDR3_ID_MASK              254U
#define CAN2TXIDR3_ID_BITNUM            1U


/*** CAN2TXDSR0 - MSCAN 2 Transmit Data Segment Register 0; 0x000001F4 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2TXDSR0STR;
extern volatile CAN2TXDSR0STR _CAN2TXDSR0 @(REG_BASE + 0x000001F4UL);
#define CAN2TXDSR0                      _CAN2TXDSR0.Byte
#define CAN2TXDSR0_DB0                  _CAN2TXDSR0.Bits.DB0
#define CAN2TXDSR0_DB1                  _CAN2TXDSR0.Bits.DB1
#define CAN2TXDSR0_DB2                  _CAN2TXDSR0.Bits.DB2
#define CAN2TXDSR0_DB3                  _CAN2TXDSR0.Bits.DB3
#define CAN2TXDSR0_DB4                  _CAN2TXDSR0.Bits.DB4
#define CAN2TXDSR0_DB5                  _CAN2TXDSR0.Bits.DB5
#define CAN2TXDSR0_DB6                  _CAN2TXDSR0.Bits.DB6
#define CAN2TXDSR0_DB7                  _CAN2TXDSR0.Bits.DB7
/* CAN2TXDSR_ARR: Access 8 CAN2TXDSRx registers in an array */
#define CAN2TXDSR_ARR                   ((volatile byte *) &CAN2TXDSR0)

#define CAN2TXDSR0_DB0_MASK             1U
#define CAN2TXDSR0_DB1_MASK             2U
#define CAN2TXDSR0_DB2_MASK             4U
#define CAN2TXDSR0_DB3_MASK             8U
#define CAN2TXDSR0_DB4_MASK             16U
#define CAN2TXDSR0_DB5_MASK             32U
#define CAN2TXDSR0_DB6_MASK             64U
#define CAN2TXDSR0_DB7_MASK             128U


/*** CAN2TXDSR1 - MSCAN 2 Transmit Data Segment Register 1; 0x000001F5 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2TXDSR1STR;
extern volatile CAN2TXDSR1STR _CAN2TXDSR1 @(REG_BASE + 0x000001F5UL);
#define CAN2TXDSR1                      _CAN2TXDSR1.Byte
#define CAN2TXDSR1_DB0                  _CAN2TXDSR1.Bits.DB0
#define CAN2TXDSR1_DB1                  _CAN2TXDSR1.Bits.DB1
#define CAN2TXDSR1_DB2                  _CAN2TXDSR1.Bits.DB2
#define CAN2TXDSR1_DB3                  _CAN2TXDSR1.Bits.DB3
#define CAN2TXDSR1_DB4                  _CAN2TXDSR1.Bits.DB4
#define CAN2TXDSR1_DB5                  _CAN2TXDSR1.Bits.DB5
#define CAN2TXDSR1_DB6                  _CAN2TXDSR1.Bits.DB6
#define CAN2TXDSR1_DB7                  _CAN2TXDSR1.Bits.DB7

#define CAN2TXDSR1_DB0_MASK             1U
#define CAN2TXDSR1_DB1_MASK             2U
#define CAN2TXDSR1_DB2_MASK             4U
#define CAN2TXDSR1_DB3_MASK             8U
#define CAN2TXDSR1_DB4_MASK             16U
#define CAN2TXDSR1_DB5_MASK             32U
#define CAN2TXDSR1_DB6_MASK             64U
#define CAN2TXDSR1_DB7_MASK             128U


/*** CAN2TXDSR2 - MSCAN 2 Transmit Data Segment Register 2; 0x000001F6 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2TXDSR2STR;
extern volatile CAN2TXDSR2STR _CAN2TXDSR2 @(REG_BASE + 0x000001F6UL);
#define CAN2TXDSR2                      _CAN2TXDSR2.Byte
#define CAN2TXDSR2_DB0                  _CAN2TXDSR2.Bits.DB0
#define CAN2TXDSR2_DB1                  _CAN2TXDSR2.Bits.DB1
#define CAN2TXDSR2_DB2                  _CAN2TXDSR2.Bits.DB2
#define CAN2TXDSR2_DB3                  _CAN2TXDSR2.Bits.DB3
#define CAN2TXDSR2_DB4                  _CAN2TXDSR2.Bits.DB4
#define CAN2TXDSR2_DB5                  _CAN2TXDSR2.Bits.DB5
#define CAN2TXDSR2_DB6                  _CAN2TXDSR2.Bits.DB6
#define CAN2TXDSR2_DB7                  _CAN2TXDSR2.Bits.DB7

#define CAN2TXDSR2_DB0_MASK             1U
#define CAN2TXDSR2_DB1_MASK             2U
#define CAN2TXDSR2_DB2_MASK             4U
#define CAN2TXDSR2_DB3_MASK             8U
#define CAN2TXDSR2_DB4_MASK             16U
#define CAN2TXDSR2_DB5_MASK             32U
#define CAN2TXDSR2_DB6_MASK             64U
#define CAN2TXDSR2_DB7_MASK             128U


/*** CAN2TXDSR3 - MSCAN 2 Transmit Data Segment Register 3; 0x000001F7 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2TXDSR3STR;
extern volatile CAN2TXDSR3STR _CAN2TXDSR3 @(REG_BASE + 0x000001F7UL);
#define CAN2TXDSR3                      _CAN2TXDSR3.Byte
#define CAN2TXDSR3_DB0                  _CAN2TXDSR3.Bits.DB0
#define CAN2TXDSR3_DB1                  _CAN2TXDSR3.Bits.DB1
#define CAN2TXDSR3_DB2                  _CAN2TXDSR3.Bits.DB2
#define CAN2TXDSR3_DB3                  _CAN2TXDSR3.Bits.DB3
#define CAN2TXDSR3_DB4                  _CAN2TXDSR3.Bits.DB4
#define CAN2TXDSR3_DB5                  _CAN2TXDSR3.Bits.DB5
#define CAN2TXDSR3_DB6                  _CAN2TXDSR3.Bits.DB6
#define CAN2TXDSR3_DB7                  _CAN2TXDSR3.Bits.DB7

#define CAN2TXDSR3_DB0_MASK             1U
#define CAN2TXDSR3_DB1_MASK             2U
#define CAN2TXDSR3_DB2_MASK             4U
#define CAN2TXDSR3_DB3_MASK             8U
#define CAN2TXDSR3_DB4_MASK             16U
#define CAN2TXDSR3_DB5_MASK             32U
#define CAN2TXDSR3_DB6_MASK             64U
#define CAN2TXDSR3_DB7_MASK             128U


/*** CAN2TXDSR4 - MSCAN 2 Transmit Data Segment Register 4; 0x000001F8 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2TXDSR4STR;
extern volatile CAN2TXDSR4STR _CAN2TXDSR4 @(REG_BASE + 0x000001F8UL);
#define CAN2TXDSR4                      _CAN2TXDSR4.Byte
#define CAN2TXDSR4_DB0                  _CAN2TXDSR4.Bits.DB0
#define CAN2TXDSR4_DB1                  _CAN2TXDSR4.Bits.DB1
#define CAN2TXDSR4_DB2                  _CAN2TXDSR4.Bits.DB2
#define CAN2TXDSR4_DB3                  _CAN2TXDSR4.Bits.DB3
#define CAN2TXDSR4_DB4                  _CAN2TXDSR4.Bits.DB4
#define CAN2TXDSR4_DB5                  _CAN2TXDSR4.Bits.DB5
#define CAN2TXDSR4_DB6                  _CAN2TXDSR4.Bits.DB6
#define CAN2TXDSR4_DB7                  _CAN2TXDSR4.Bits.DB7

#define CAN2TXDSR4_DB0_MASK             1U
#define CAN2TXDSR4_DB1_MASK             2U
#define CAN2TXDSR4_DB2_MASK             4U
#define CAN2TXDSR4_DB3_MASK             8U
#define CAN2TXDSR4_DB4_MASK             16U
#define CAN2TXDSR4_DB5_MASK             32U
#define CAN2TXDSR4_DB6_MASK             64U
#define CAN2TXDSR4_DB7_MASK             128U


/*** CAN2TXDSR5 - MSCAN 2 Transmit Data Segment Register 5; 0x000001F9 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2TXDSR5STR;
extern volatile CAN2TXDSR5STR _CAN2TXDSR5 @(REG_BASE + 0x000001F9UL);
#define CAN2TXDSR5                      _CAN2TXDSR5.Byte
#define CAN2TXDSR5_DB0                  _CAN2TXDSR5.Bits.DB0
#define CAN2TXDSR5_DB1                  _CAN2TXDSR5.Bits.DB1
#define CAN2TXDSR5_DB2                  _CAN2TXDSR5.Bits.DB2
#define CAN2TXDSR5_DB3                  _CAN2TXDSR5.Bits.DB3
#define CAN2TXDSR5_DB4                  _CAN2TXDSR5.Bits.DB4
#define CAN2TXDSR5_DB5                  _CAN2TXDSR5.Bits.DB5
#define CAN2TXDSR5_DB6                  _CAN2TXDSR5.Bits.DB6
#define CAN2TXDSR5_DB7                  _CAN2TXDSR5.Bits.DB7

#define CAN2TXDSR5_DB0_MASK             1U
#define CAN2TXDSR5_DB1_MASK             2U
#define CAN2TXDSR5_DB2_MASK             4U
#define CAN2TXDSR5_DB3_MASK             8U
#define CAN2TXDSR5_DB4_MASK             16U
#define CAN2TXDSR5_DB5_MASK             32U
#define CAN2TXDSR5_DB6_MASK             64U
#define CAN2TXDSR5_DB7_MASK             128U


/*** CAN2TXDSR6 - MSCAN 2 Transmit Data Segment Register 6; 0x000001FA ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2TXDSR6STR;
extern volatile CAN2TXDSR6STR _CAN2TXDSR6 @(REG_BASE + 0x000001FAUL);
#define CAN2TXDSR6                      _CAN2TXDSR6.Byte
#define CAN2TXDSR6_DB0                  _CAN2TXDSR6.Bits.DB0
#define CAN2TXDSR6_DB1                  _CAN2TXDSR6.Bits.DB1
#define CAN2TXDSR6_DB2                  _CAN2TXDSR6.Bits.DB2
#define CAN2TXDSR6_DB3                  _CAN2TXDSR6.Bits.DB3
#define CAN2TXDSR6_DB4                  _CAN2TXDSR6.Bits.DB4
#define CAN2TXDSR6_DB5                  _CAN2TXDSR6.Bits.DB5
#define CAN2TXDSR6_DB6                  _CAN2TXDSR6.Bits.DB6
#define CAN2TXDSR6_DB7                  _CAN2TXDSR6.Bits.DB7

#define CAN2TXDSR6_DB0_MASK             1U
#define CAN2TXDSR6_DB1_MASK             2U
#define CAN2TXDSR6_DB2_MASK             4U
#define CAN2TXDSR6_DB3_MASK             8U
#define CAN2TXDSR6_DB4_MASK             16U
#define CAN2TXDSR6_DB5_MASK             32U
#define CAN2TXDSR6_DB6_MASK             64U
#define CAN2TXDSR6_DB7_MASK             128U


/*** CAN2TXDSR7 - MSCAN 2 Transmit Data Segment Register 7; 0x000001FB ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN2TXDSR7STR;
extern volatile CAN2TXDSR7STR _CAN2TXDSR7 @(REG_BASE + 0x000001FBUL);
#define CAN2TXDSR7                      _CAN2TXDSR7.Byte
#define CAN2TXDSR7_DB0                  _CAN2TXDSR7.Bits.DB0
#define CAN2TXDSR7_DB1                  _CAN2TXDSR7.Bits.DB1
#define CAN2TXDSR7_DB2                  _CAN2TXDSR7.Bits.DB2
#define CAN2TXDSR7_DB3                  _CAN2TXDSR7.Bits.DB3
#define CAN2TXDSR7_DB4                  _CAN2TXDSR7.Bits.DB4
#define CAN2TXDSR7_DB5                  _CAN2TXDSR7.Bits.DB5
#define CAN2TXDSR7_DB6                  _CAN2TXDSR7.Bits.DB6
#define CAN2TXDSR7_DB7                  _CAN2TXDSR7.Bits.DB7

#define CAN2TXDSR7_DB0_MASK             1U
#define CAN2TXDSR7_DB1_MASK             2U
#define CAN2TXDSR7_DB2_MASK             4U
#define CAN2TXDSR7_DB3_MASK             8U
#define CAN2TXDSR7_DB4_MASK             16U
#define CAN2TXDSR7_DB5_MASK             32U
#define CAN2TXDSR7_DB6_MASK             64U
#define CAN2TXDSR7_DB7_MASK             128U


/*** CAN2TXDLR - MSCAN 2 Transmit Data Length Register; 0x000001FC ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN2TXDLRSTR;
extern volatile CAN2TXDLRSTR _CAN2TXDLR @(REG_BASE + 0x000001FCUL);
#define CAN2TXDLR                       _CAN2TXDLR.Byte
#define CAN2TXDLR_DLC0                  _CAN2TXDLR.Bits.DLC0
#define CAN2TXDLR_DLC1                  _CAN2TXDLR.Bits.DLC1
#define CAN2TXDLR_DLC2                  _CAN2TXDLR.Bits.DLC2
#define CAN2TXDLR_DLC3                  _CAN2TXDLR.Bits.DLC3
#define CAN2TXDLR_DLC                   _CAN2TXDLR.MergedBits.grpDLC

#define CAN2TXDLR_DLC0_MASK             1U
#define CAN2TXDLR_DLC1_MASK             2U
#define CAN2TXDLR_DLC2_MASK             4U
#define CAN2TXDLR_DLC3_MASK             8U
#define CAN2TXDLR_DLC_MASK              15U
#define CAN2TXDLR_DLC_BITNUM            0U


/*** CAN2TXTBPR - MSCAN 2 Transmit Buffer Priority; 0x000001FD ***/
typedef union {
  byte Byte;
  struct {
    byte PRIO0       :1;                                       /* Transmit Buffer Priority Bit 0 */
    byte PRIO1       :1;                                       /* Transmit Buffer Priority Bit 1 */
    byte PRIO2       :1;                                       /* Transmit Buffer Priority Bit 2 */
    byte PRIO3       :1;                                       /* Transmit Buffer Priority Bit 3 */
    byte PRIO4       :1;                                       /* Transmit Buffer Priority Bit 4 */
    byte PRIO5       :1;                                       /* Transmit Buffer Priority Bit 5 */
    byte PRIO6       :1;                                       /* Transmit Buffer Priority Bit 6 */
    byte PRIO7       :1;                                       /* Transmit Buffer Priority Bit 7 */
  } Bits;
} CAN2TXTBPRSTR;
extern volatile CAN2TXTBPRSTR _CAN2TXTBPR @(REG_BASE + 0x000001FDUL);
#define CAN2TXTBPR                      _CAN2TXTBPR.Byte
#define CAN2TXTBPR_PRIO0                _CAN2TXTBPR.Bits.PRIO0
#define CAN2TXTBPR_PRIO1                _CAN2TXTBPR.Bits.PRIO1
#define CAN2TXTBPR_PRIO2                _CAN2TXTBPR.Bits.PRIO2
#define CAN2TXTBPR_PRIO3                _CAN2TXTBPR.Bits.PRIO3
#define CAN2TXTBPR_PRIO4                _CAN2TXTBPR.Bits.PRIO4
#define CAN2TXTBPR_PRIO5                _CAN2TXTBPR.Bits.PRIO5
#define CAN2TXTBPR_PRIO6                _CAN2TXTBPR.Bits.PRIO6
#define CAN2TXTBPR_PRIO7                _CAN2TXTBPR.Bits.PRIO7

#define CAN2TXTBPR_PRIO0_MASK           1U
#define CAN2TXTBPR_PRIO1_MASK           2U
#define CAN2TXTBPR_PRIO2_MASK           4U
#define CAN2TXTBPR_PRIO3_MASK           8U
#define CAN2TXTBPR_PRIO4_MASK           16U
#define CAN2TXTBPR_PRIO5_MASK           32U
#define CAN2TXTBPR_PRIO6_MASK           64U
#define CAN2TXTBPR_PRIO7_MASK           128U


/*** CAN2TXTSR - MSCAN 2 Transmit Time Stamp Register; 0x000001FE ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN2TXTSRH - MSCAN 2 Transmit Time Stamp Register High; 0x000001FE ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN2TXTSRHSTR;
    #define CAN2TXTSRH                  _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Byte
    #define CAN2TXTSRH_TSR8             _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Bits.TSR8
    #define CAN2TXTSRH_TSR9             _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Bits.TSR9
    #define CAN2TXTSRH_TSR10            _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Bits.TSR10
    #define CAN2TXTSRH_TSR11            _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Bits.TSR11
    #define CAN2TXTSRH_TSR12            _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Bits.TSR12
    #define CAN2TXTSRH_TSR13            _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Bits.TSR13
    #define CAN2TXTSRH_TSR14            _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Bits.TSR14
    #define CAN2TXTSRH_TSR15            _CAN2TXTSR.Overlap_STR.CAN2TXTSRHSTR.Bits.TSR15
    
    #define CAN2TXTSRH_TSR8_MASK        1U
    #define CAN2TXTSRH_TSR9_MASK        2U
    #define CAN2TXTSRH_TSR10_MASK       4U
    #define CAN2TXTSRH_TSR11_MASK       8U
    #define CAN2TXTSRH_TSR12_MASK       16U
    #define CAN2TXTSRH_TSR13_MASK       32U
    #define CAN2TXTSRH_TSR14_MASK       64U
    #define CAN2TXTSRH_TSR15_MASK       128U
    

    /*** CAN2TXTSRL - MSCAN 2 Transmit Time Stamp Register Low; 0x000001FF ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN2TXTSRLSTR;
    #define CAN2TXTSRL                  _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Byte
    #define CAN2TXTSRL_TSR0             _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Bits.TSR0
    #define CAN2TXTSRL_TSR1             _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Bits.TSR1
    #define CAN2TXTSRL_TSR2             _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Bits.TSR2
    #define CAN2TXTSRL_TSR3             _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Bits.TSR3
    #define CAN2TXTSRL_TSR4             _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Bits.TSR4
    #define CAN2TXTSRL_TSR5             _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Bits.TSR5
    #define CAN2TXTSRL_TSR6             _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Bits.TSR6
    #define CAN2TXTSRL_TSR7             _CAN2TXTSR.Overlap_STR.CAN2TXTSRLSTR.Bits.TSR7
    
    #define CAN2TXTSRL_TSR0_MASK        1U
    #define CAN2TXTSRL_TSR1_MASK        2U
    #define CAN2TXTSRL_TSR2_MASK        4U
    #define CAN2TXTSRL_TSR3_MASK        8U
    #define CAN2TXTSRL_TSR4_MASK        16U
    #define CAN2TXTSRL_TSR5_MASK        32U
    #define CAN2TXTSRL_TSR6_MASK        64U
    #define CAN2TXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN2TXTSRSTR;
extern volatile CAN2TXTSRSTR _CAN2TXTSR @(REG_BASE + 0x000001FEUL);
#define CAN2TXTSR                       _CAN2TXTSR.Word
#define CAN2TXTSR_TSR0                  _CAN2TXTSR.Bits.TSR0
#define CAN2TXTSR_TSR1                  _CAN2TXTSR.Bits.TSR1
#define CAN2TXTSR_TSR2                  _CAN2TXTSR.Bits.TSR2
#define CAN2TXTSR_TSR3                  _CAN2TXTSR.Bits.TSR3
#define CAN2TXTSR_TSR4                  _CAN2TXTSR.Bits.TSR4
#define CAN2TXTSR_TSR5                  _CAN2TXTSR.Bits.TSR5
#define CAN2TXTSR_TSR6                  _CAN2TXTSR.Bits.TSR6
#define CAN2TXTSR_TSR7                  _CAN2TXTSR.Bits.TSR7
#define CAN2TXTSR_TSR8                  _CAN2TXTSR.Bits.TSR8
#define CAN2TXTSR_TSR9                  _CAN2TXTSR.Bits.TSR9
#define CAN2TXTSR_TSR10                 _CAN2TXTSR.Bits.TSR10
#define CAN2TXTSR_TSR11                 _CAN2TXTSR.Bits.TSR11
#define CAN2TXTSR_TSR12                 _CAN2TXTSR.Bits.TSR12
#define CAN2TXTSR_TSR13                 _CAN2TXTSR.Bits.TSR13
#define CAN2TXTSR_TSR14                 _CAN2TXTSR.Bits.TSR14
#define CAN2TXTSR_TSR15                 _CAN2TXTSR.Bits.TSR15

#define CAN2TXTSR_TSR0_MASK             1U
#define CAN2TXTSR_TSR1_MASK             2U
#define CAN2TXTSR_TSR2_MASK             4U
#define CAN2TXTSR_TSR3_MASK             8U
#define CAN2TXTSR_TSR4_MASK             16U
#define CAN2TXTSR_TSR5_MASK             32U
#define CAN2TXTSR_TSR6_MASK             64U
#define CAN2TXTSR_TSR7_MASK             128U
#define CAN2TXTSR_TSR8_MASK             256U
#define CAN2TXTSR_TSR9_MASK             512U
#define CAN2TXTSR_TSR10_MASK            1024U
#define CAN2TXTSR_TSR11_MASK            2048U
#define CAN2TXTSR_TSR12_MASK            4096U
#define CAN2TXTSR_TSR13_MASK            8192U
#define CAN2TXTSR_TSR14_MASK            16384U
#define CAN2TXTSR_TSR15_MASK            32768U


/*** CAN3CTL0 - MSCAN 3 Control 0 Register; 0x00000200 ***/
typedef union {
  byte Byte;
  struct {
    byte INITRQ      :1;                                       /* Initialization Mode Request */
    byte SLPRQ       :1;                                       /* Sleep Mode Request */
    byte WUPE        :1;                                       /* Wake-Up Enable */
    byte TIME        :1;                                       /* Timer Enable */
    byte SYNCH       :1;                                       /* Synchronized Status */
    byte CSWAI       :1;                                       /* CAN Stops in Wait Mode */
    byte RXACT       :1;                                       /* Receiver Active Status */
    byte RXFRM       :1;                                       /* Received Frame Flag */
  } Bits;
} CAN3CTL0STR;
extern volatile CAN3CTL0STR _CAN3CTL0 @(REG_BASE + 0x00000200UL);
#define CAN3CTL0                        _CAN3CTL0.Byte
#define CAN3CTL0_INITRQ                 _CAN3CTL0.Bits.INITRQ
#define CAN3CTL0_SLPRQ                  _CAN3CTL0.Bits.SLPRQ
#define CAN3CTL0_WUPE                   _CAN3CTL0.Bits.WUPE
#define CAN3CTL0_TIME                   _CAN3CTL0.Bits.TIME
#define CAN3CTL0_SYNCH                  _CAN3CTL0.Bits.SYNCH
#define CAN3CTL0_CSWAI                  _CAN3CTL0.Bits.CSWAI
#define CAN3CTL0_RXACT                  _CAN3CTL0.Bits.RXACT
#define CAN3CTL0_RXFRM                  _CAN3CTL0.Bits.RXFRM
/* CAN3CTL_ARR: Access 2 CAN3CTLx registers in an array */
#define CAN3CTL_ARR                     ((volatile byte *) &CAN3CTL0)

#define CAN3CTL0_INITRQ_MASK            1U
#define CAN3CTL0_SLPRQ_MASK             2U
#define CAN3CTL0_WUPE_MASK              4U
#define CAN3CTL0_TIME_MASK              8U
#define CAN3CTL0_SYNCH_MASK             16U
#define CAN3CTL0_CSWAI_MASK             32U
#define CAN3CTL0_RXACT_MASK             64U
#define CAN3CTL0_RXFRM_MASK             128U


/*** CAN3CTL1 - MSCAN 3 Control 1 Register; 0x00000201 ***/
typedef union {
  byte Byte;
  struct {
    byte INITAK      :1;                                       /* Initialization Mode Acknowledge */
    byte SLPAK       :1;                                       /* Sleep Mode Acknowledge */
    byte WUPM        :1;                                       /* Wake-Up Mode */
    byte BORM        :1;                                       /* Bus-Off Recovery Mode */
    byte LISTEN      :1;                                       /* Listen Only Mode */
    byte LOOPB       :1;                                       /* Loop Back Self Test Mode */
    byte CLKSRC      :1;                                       /* MSCAN 3 Clock Source */
    byte CANE        :1;                                       /* MSCAN 3 Enable */
  } Bits;
} CAN3CTL1STR;
extern volatile CAN3CTL1STR _CAN3CTL1 @(REG_BASE + 0x00000201UL);
#define CAN3CTL1                        _CAN3CTL1.Byte
#define CAN3CTL1_INITAK                 _CAN3CTL1.Bits.INITAK
#define CAN3CTL1_SLPAK                  _CAN3CTL1.Bits.SLPAK
#define CAN3CTL1_WUPM                   _CAN3CTL1.Bits.WUPM
#define CAN3CTL1_BORM                   _CAN3CTL1.Bits.BORM
#define CAN3CTL1_LISTEN                 _CAN3CTL1.Bits.LISTEN
#define CAN3CTL1_LOOPB                  _CAN3CTL1.Bits.LOOPB
#define CAN3CTL1_CLKSRC                 _CAN3CTL1.Bits.CLKSRC
#define CAN3CTL1_CANE                   _CAN3CTL1.Bits.CANE

#define CAN3CTL1_INITAK_MASK            1U
#define CAN3CTL1_SLPAK_MASK             2U
#define CAN3CTL1_WUPM_MASK              4U
#define CAN3CTL1_BORM_MASK              8U
#define CAN3CTL1_LISTEN_MASK            16U
#define CAN3CTL1_LOOPB_MASK             32U
#define CAN3CTL1_CLKSRC_MASK            64U
#define CAN3CTL1_CANE_MASK              128U


/*** CAN3BTR0 - MSCAN 3 Bus Timing Register 0; 0x00000202 ***/
typedef union {
  byte Byte;
  struct {
    byte BRP0        :1;                                       /* Baud Rate Prescaler 0 */
    byte BRP1        :1;                                       /* Baud Rate Prescaler 1 */
    byte BRP2        :1;                                       /* Baud Rate Prescaler 2 */
    byte BRP3        :1;                                       /* Baud Rate Prescaler 3 */
    byte BRP4        :1;                                       /* Baud Rate Prescaler 4 */
    byte BRP5        :1;                                       /* Baud Rate Prescaler 5 */
    byte SJW0        :1;                                       /* Synchronization Jump Width 0 */
    byte SJW1        :1;                                       /* Synchronization Jump Width 1 */
  } Bits;
  struct {
    byte grpBRP  :6;
    byte grpSJW  :2;
  } MergedBits;
} CAN3BTR0STR;
extern volatile CAN3BTR0STR _CAN3BTR0 @(REG_BASE + 0x00000202UL);
#define CAN3BTR0                        _CAN3BTR0.Byte
#define CAN3BTR0_BRP0                   _CAN3BTR0.Bits.BRP0
#define CAN3BTR0_BRP1                   _CAN3BTR0.Bits.BRP1
#define CAN3BTR0_BRP2                   _CAN3BTR0.Bits.BRP2
#define CAN3BTR0_BRP3                   _CAN3BTR0.Bits.BRP3
#define CAN3BTR0_BRP4                   _CAN3BTR0.Bits.BRP4
#define CAN3BTR0_BRP5                   _CAN3BTR0.Bits.BRP5
#define CAN3BTR0_SJW0                   _CAN3BTR0.Bits.SJW0
#define CAN3BTR0_SJW1                   _CAN3BTR0.Bits.SJW1
/* CAN3BTR_ARR: Access 2 CAN3BTRx registers in an array */
#define CAN3BTR_ARR                     ((volatile byte *) &CAN3BTR0)
#define CAN3BTR0_BRP                    _CAN3BTR0.MergedBits.grpBRP
#define CAN3BTR0_SJW                    _CAN3BTR0.MergedBits.grpSJW

#define CAN3BTR0_BRP0_MASK              1U
#define CAN3BTR0_BRP1_MASK              2U
#define CAN3BTR0_BRP2_MASK              4U
#define CAN3BTR0_BRP3_MASK              8U
#define CAN3BTR0_BRP4_MASK              16U
#define CAN3BTR0_BRP5_MASK              32U
#define CAN3BTR0_SJW0_MASK              64U
#define CAN3BTR0_SJW1_MASK              128U
#define CAN3BTR0_BRP_MASK               63U
#define CAN3BTR0_BRP_BITNUM             0U
#define CAN3BTR0_SJW_MASK               192U
#define CAN3BTR0_SJW_BITNUM             6U


/*** CAN3BTR1 - MSCAN 3 Bus Timing Register 1; 0x00000203 ***/
typedef union {
  byte Byte;
  struct {
    byte TSEG10      :1;                                       /* Time Segment 10 */
    byte TSEG11      :1;                                       /* Time Segment 11 */
    byte TSEG12      :1;                                       /* Time Segment 12 */
    byte TSEG13      :1;                                       /* Time Segment 13 */
    byte TSEG20      :1;                                       /* Time Segment 20 */
    byte TSEG21      :1;                                       /* Time Segment 21 */
    byte TSEG22      :1;                                       /* Time Segment 22 */
    byte SAMP        :1;                                       /* Sampling */
  } Bits;
  struct {
    byte grpTSEG_10 :4;
    byte grpTSEG_20 :3;
    byte         :1;
  } MergedBits;
} CAN3BTR1STR;
extern volatile CAN3BTR1STR _CAN3BTR1 @(REG_BASE + 0x00000203UL);
#define CAN3BTR1                        _CAN3BTR1.Byte
#define CAN3BTR1_TSEG10                 _CAN3BTR1.Bits.TSEG10
#define CAN3BTR1_TSEG11                 _CAN3BTR1.Bits.TSEG11
#define CAN3BTR1_TSEG12                 _CAN3BTR1.Bits.TSEG12
#define CAN3BTR1_TSEG13                 _CAN3BTR1.Bits.TSEG13
#define CAN3BTR1_TSEG20                 _CAN3BTR1.Bits.TSEG20
#define CAN3BTR1_TSEG21                 _CAN3BTR1.Bits.TSEG21
#define CAN3BTR1_TSEG22                 _CAN3BTR1.Bits.TSEG22
#define CAN3BTR1_SAMP                   _CAN3BTR1.Bits.SAMP
#define CAN3BTR1_TSEG_10                _CAN3BTR1.MergedBits.grpTSEG_10
#define CAN3BTR1_TSEG_20                _CAN3BTR1.MergedBits.grpTSEG_20
#define CAN3BTR1_TSEG                   CAN3BTR1_TSEG_10

#define CAN3BTR1_TSEG10_MASK            1U
#define CAN3BTR1_TSEG11_MASK            2U
#define CAN3BTR1_TSEG12_MASK            4U
#define CAN3BTR1_TSEG13_MASK            8U
#define CAN3BTR1_TSEG20_MASK            16U
#define CAN3BTR1_TSEG21_MASK            32U
#define CAN3BTR1_TSEG22_MASK            64U
#define CAN3BTR1_SAMP_MASK              128U
#define CAN3BTR1_TSEG_10_MASK           15U
#define CAN3BTR1_TSEG_10_BITNUM         0U
#define CAN3BTR1_TSEG_20_MASK           112U
#define CAN3BTR1_TSEG_20_BITNUM         4U


/*** CAN3RFLG - MSCAN 3 Receiver Flag Register; 0x00000204 ***/
typedef union {
  byte Byte;
  struct {
    byte RXF         :1;                                       /* Receive Buffer Full */
    byte OVRIF       :1;                                       /* Overrun Interrupt Flag */
    byte TSTAT0      :1;                                       /* Transmitter Status Bit 0 */
    byte TSTAT1      :1;                                       /* Transmitter Status Bit 1 */
    byte RSTAT0      :1;                                       /* Receiver Status Bit 0 */
    byte RSTAT1      :1;                                       /* Receiver Status Bit 1 */
    byte CSCIF       :1;                                       /* CAN Status Change Interrupt Flag */
    byte WUPIF       :1;                                       /* Wake-up Interrupt Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTAT :2;
    byte grpRSTAT :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3RFLGSTR;
extern volatile CAN3RFLGSTR _CAN3RFLG @(REG_BASE + 0x00000204UL);
#define CAN3RFLG                        _CAN3RFLG.Byte
#define CAN3RFLG_RXF                    _CAN3RFLG.Bits.RXF
#define CAN3RFLG_OVRIF                  _CAN3RFLG.Bits.OVRIF
#define CAN3RFLG_TSTAT0                 _CAN3RFLG.Bits.TSTAT0
#define CAN3RFLG_TSTAT1                 _CAN3RFLG.Bits.TSTAT1
#define CAN3RFLG_RSTAT0                 _CAN3RFLG.Bits.RSTAT0
#define CAN3RFLG_RSTAT1                 _CAN3RFLG.Bits.RSTAT1
#define CAN3RFLG_CSCIF                  _CAN3RFLG.Bits.CSCIF
#define CAN3RFLG_WUPIF                  _CAN3RFLG.Bits.WUPIF
#define CAN3RFLG_TSTAT                  _CAN3RFLG.MergedBits.grpTSTAT
#define CAN3RFLG_RSTAT                  _CAN3RFLG.MergedBits.grpRSTAT

#define CAN3RFLG_RXF_MASK               1U
#define CAN3RFLG_OVRIF_MASK             2U
#define CAN3RFLG_TSTAT0_MASK            4U
#define CAN3RFLG_TSTAT1_MASK            8U
#define CAN3RFLG_RSTAT0_MASK            16U
#define CAN3RFLG_RSTAT1_MASK            32U
#define CAN3RFLG_CSCIF_MASK             64U
#define CAN3RFLG_WUPIF_MASK             128U
#define CAN3RFLG_TSTAT_MASK             12U
#define CAN3RFLG_TSTAT_BITNUM           2U
#define CAN3RFLG_RSTAT_MASK             48U
#define CAN3RFLG_RSTAT_BITNUM           4U


/*** CAN3RIER - MSCAN 3 Receiver Interrupt Enable Register; 0x00000205 ***/
typedef union {
  byte Byte;
  struct {
    byte RXFIE       :1;                                       /* Receiver Full Interrupt Enable */
    byte OVRIE       :1;                                       /* Overrun Interrupt Enable */
    byte TSTATE0     :1;                                       /* Transmitter Status Change Enable 0 */
    byte TSTATE1     :1;                                       /* Transmitter Status Change Enable 1 */
    byte RSTATE0     :1;                                       /* Receiver Status Change Enable 0 */
    byte RSTATE1     :1;                                       /* Receiver Status Change Enable 1 */
    byte CSCIE       :1;                                       /* CAN Status Change Interrupt Enable */
    byte WUPIE       :1;                                       /* Wake-up Interrupt Enable */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpTSTATE :2;
    byte grpRSTATE :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3RIERSTR;
extern volatile CAN3RIERSTR _CAN3RIER @(REG_BASE + 0x00000205UL);
#define CAN3RIER                        _CAN3RIER.Byte
#define CAN3RIER_RXFIE                  _CAN3RIER.Bits.RXFIE
#define CAN3RIER_OVRIE                  _CAN3RIER.Bits.OVRIE
#define CAN3RIER_TSTATE0                _CAN3RIER.Bits.TSTATE0
#define CAN3RIER_TSTATE1                _CAN3RIER.Bits.TSTATE1
#define CAN3RIER_RSTATE0                _CAN3RIER.Bits.RSTATE0
#define CAN3RIER_RSTATE1                _CAN3RIER.Bits.RSTATE1
#define CAN3RIER_CSCIE                  _CAN3RIER.Bits.CSCIE
#define CAN3RIER_WUPIE                  _CAN3RIER.Bits.WUPIE
#define CAN3RIER_TSTATE                 _CAN3RIER.MergedBits.grpTSTATE
#define CAN3RIER_RSTATE                 _CAN3RIER.MergedBits.grpRSTATE

#define CAN3RIER_RXFIE_MASK             1U
#define CAN3RIER_OVRIE_MASK             2U
#define CAN3RIER_TSTATE0_MASK           4U
#define CAN3RIER_TSTATE1_MASK           8U
#define CAN3RIER_RSTATE0_MASK           16U
#define CAN3RIER_RSTATE1_MASK           32U
#define CAN3RIER_CSCIE_MASK             64U
#define CAN3RIER_WUPIE_MASK             128U
#define CAN3RIER_TSTATE_MASK            12U
#define CAN3RIER_TSTATE_BITNUM          2U
#define CAN3RIER_RSTATE_MASK            48U
#define CAN3RIER_RSTATE_BITNUM          4U


/*** CAN3TFLG - MSCAN 3 Transmitter Flag Register; 0x00000206 ***/
typedef union {
  byte Byte;
  struct {
    byte TXE0        :1;                                       /* Transmitter Buffer Empty 0 */
    byte TXE1        :1;                                       /* Transmitter Buffer Empty 1 */
    byte TXE2        :1;                                       /* Transmitter Buffer Empty 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXE  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3TFLGSTR;
extern volatile CAN3TFLGSTR _CAN3TFLG @(REG_BASE + 0x00000206UL);
#define CAN3TFLG                        _CAN3TFLG.Byte
#define CAN3TFLG_TXE0                   _CAN3TFLG.Bits.TXE0
#define CAN3TFLG_TXE1                   _CAN3TFLG.Bits.TXE1
#define CAN3TFLG_TXE2                   _CAN3TFLG.Bits.TXE2
#define CAN3TFLG_TXE                    _CAN3TFLG.MergedBits.grpTXE

#define CAN3TFLG_TXE0_MASK              1U
#define CAN3TFLG_TXE1_MASK              2U
#define CAN3TFLG_TXE2_MASK              4U
#define CAN3TFLG_TXE_MASK               7U
#define CAN3TFLG_TXE_BITNUM             0U


/*** CAN3TIER - MSCAN 3 Transmitter Interrupt Enable Register; 0x00000207 ***/
typedef union {
  byte Byte;
  struct {
    byte TXEIE0      :1;                                       /* Transmitter Empty Interrupt Enable 0 */
    byte TXEIE1      :1;                                       /* Transmitter Empty Interrupt Enable 1 */
    byte TXEIE2      :1;                                       /* Transmitter Empty Interrupt Enable 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTXEIE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3TIERSTR;
extern volatile CAN3TIERSTR _CAN3TIER @(REG_BASE + 0x00000207UL);
#define CAN3TIER                        _CAN3TIER.Byte
#define CAN3TIER_TXEIE0                 _CAN3TIER.Bits.TXEIE0
#define CAN3TIER_TXEIE1                 _CAN3TIER.Bits.TXEIE1
#define CAN3TIER_TXEIE2                 _CAN3TIER.Bits.TXEIE2
#define CAN3TIER_TXEIE                  _CAN3TIER.MergedBits.grpTXEIE

#define CAN3TIER_TXEIE0_MASK            1U
#define CAN3TIER_TXEIE1_MASK            2U
#define CAN3TIER_TXEIE2_MASK            4U
#define CAN3TIER_TXEIE_MASK             7U
#define CAN3TIER_TXEIE_BITNUM           0U


/*** CAN3TARQ - MSCAN 3 Transmitter Message Abort Request; 0x00000208 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTRQ0      :1;                                       /* Abort Request 0 */
    byte ABTRQ1      :1;                                       /* Abort Request 1 */
    byte ABTRQ2      :1;                                       /* Abort Request 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTRQ :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3TARQSTR;
extern volatile CAN3TARQSTR _CAN3TARQ @(REG_BASE + 0x00000208UL);
#define CAN3TARQ                        _CAN3TARQ.Byte
#define CAN3TARQ_ABTRQ0                 _CAN3TARQ.Bits.ABTRQ0
#define CAN3TARQ_ABTRQ1                 _CAN3TARQ.Bits.ABTRQ1
#define CAN3TARQ_ABTRQ2                 _CAN3TARQ.Bits.ABTRQ2
#define CAN3TARQ_ABTRQ                  _CAN3TARQ.MergedBits.grpABTRQ

#define CAN3TARQ_ABTRQ0_MASK            1U
#define CAN3TARQ_ABTRQ1_MASK            2U
#define CAN3TARQ_ABTRQ2_MASK            4U
#define CAN3TARQ_ABTRQ_MASK             7U
#define CAN3TARQ_ABTRQ_BITNUM           0U


/*** CAN3TAAK - MSCAN 3 Transmitter Message Abort Control; 0x00000209 ***/
typedef union {
  byte Byte;
  struct {
    byte ABTAK0      :1;                                       /* Abort Acknowledge 0 */
    byte ABTAK1      :1;                                       /* Abort Acknowledge 1 */
    byte ABTAK2      :1;                                       /* Abort Acknowledge 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpABTAK :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3TAAKSTR;
extern volatile CAN3TAAKSTR _CAN3TAAK @(REG_BASE + 0x00000209UL);
#define CAN3TAAK                        _CAN3TAAK.Byte
#define CAN3TAAK_ABTAK0                 _CAN3TAAK.Bits.ABTAK0
#define CAN3TAAK_ABTAK1                 _CAN3TAAK.Bits.ABTAK1
#define CAN3TAAK_ABTAK2                 _CAN3TAAK.Bits.ABTAK2
#define CAN3TAAK_ABTAK                  _CAN3TAAK.MergedBits.grpABTAK

#define CAN3TAAK_ABTAK0_MASK            1U
#define CAN3TAAK_ABTAK1_MASK            2U
#define CAN3TAAK_ABTAK2_MASK            4U
#define CAN3TAAK_ABTAK_MASK             7U
#define CAN3TAAK_ABTAK_BITNUM           0U


/*** CAN3TBSEL - MSCAN 3 Transmit Buffer Selection; 0x0000020A ***/
typedef union {
  byte Byte;
  struct {
    byte TX0         :1;                                       /* Transmit Buffer Select 0 */
    byte TX1         :1;                                       /* Transmit Buffer Select 1 */
    byte TX2         :1;                                       /* Transmit Buffer Select 2 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpTX   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3TBSELSTR;
extern volatile CAN3TBSELSTR _CAN3TBSEL @(REG_BASE + 0x0000020AUL);
#define CAN3TBSEL                       _CAN3TBSEL.Byte
#define CAN3TBSEL_TX0                   _CAN3TBSEL.Bits.TX0
#define CAN3TBSEL_TX1                   _CAN3TBSEL.Bits.TX1
#define CAN3TBSEL_TX2                   _CAN3TBSEL.Bits.TX2
#define CAN3TBSEL_TX                    _CAN3TBSEL.MergedBits.grpTX

#define CAN3TBSEL_TX0_MASK              1U
#define CAN3TBSEL_TX1_MASK              2U
#define CAN3TBSEL_TX2_MASK              4U
#define CAN3TBSEL_TX_MASK               7U
#define CAN3TBSEL_TX_BITNUM             0U


/*** CAN3IDAC - MSCAN 3 Identifier Acceptance Control Register; 0x0000020B ***/
typedef union {
  byte Byte;
  struct {
    byte IDHIT0      :1;                                       /* Identifier Acceptance Hit Indicator 0 */
    byte IDHIT1      :1;                                       /* Identifier Acceptance Hit Indicator 1 */
    byte IDHIT2      :1;                                       /* Identifier Acceptance Hit Indicator 2 */
    byte             :1; 
    byte IDAM0       :1;                                       /* Identifier Acceptance Mode 0 */
    byte IDAM1       :1;                                       /* Identifier Acceptance Mode 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpIDHIT :3;
    byte         :1;
    byte grpIDAM :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3IDACSTR;
extern volatile CAN3IDACSTR _CAN3IDAC @(REG_BASE + 0x0000020BUL);
#define CAN3IDAC                        _CAN3IDAC.Byte
#define CAN3IDAC_IDHIT0                 _CAN3IDAC.Bits.IDHIT0
#define CAN3IDAC_IDHIT1                 _CAN3IDAC.Bits.IDHIT1
#define CAN3IDAC_IDHIT2                 _CAN3IDAC.Bits.IDHIT2
#define CAN3IDAC_IDAM0                  _CAN3IDAC.Bits.IDAM0
#define CAN3IDAC_IDAM1                  _CAN3IDAC.Bits.IDAM1
#define CAN3IDAC_IDHIT                  _CAN3IDAC.MergedBits.grpIDHIT
#define CAN3IDAC_IDAM                   _CAN3IDAC.MergedBits.grpIDAM

#define CAN3IDAC_IDHIT0_MASK            1U
#define CAN3IDAC_IDHIT1_MASK            2U
#define CAN3IDAC_IDHIT2_MASK            4U
#define CAN3IDAC_IDAM0_MASK             16U
#define CAN3IDAC_IDAM1_MASK             32U
#define CAN3IDAC_IDHIT_MASK             7U
#define CAN3IDAC_IDHIT_BITNUM           0U
#define CAN3IDAC_IDAM_MASK              48U
#define CAN3IDAC_IDAM_BITNUM            4U


/*** CAN3MISC - MSCAN 3 Miscellaneous Register; 0x0000020D ***/
typedef union {
  byte Byte;
  struct {
    byte BOHOLD      :1;                                       /* Bus-Off state Hold until user request */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} CAN3MISCSTR;
extern volatile CAN3MISCSTR _CAN3MISC @(REG_BASE + 0x0000020DUL);
#define CAN3MISC                        _CAN3MISC.Byte
#define CAN3MISC_BOHOLD                 _CAN3MISC.Bits.BOHOLD

#define CAN3MISC_BOHOLD_MASK            1U


/*** CAN3RXERR - MSCAN 3 Receive Error Counter Register; 0x0000020E ***/
typedef union {
  byte Byte;
  struct {
    byte RXERR0      :1;                                       /* Bit 0 */
    byte RXERR1      :1;                                       /* Bit 1 */
    byte RXERR2      :1;                                       /* Bit 2 */
    byte RXERR3      :1;                                       /* Bit 3 */
    byte RXERR4      :1;                                       /* Bit 4 */
    byte RXERR5      :1;                                       /* Bit 5 */
    byte RXERR6      :1;                                       /* Bit 6 */
    byte RXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN3RXERRSTR;
extern volatile CAN3RXERRSTR _CAN3RXERR @(REG_BASE + 0x0000020EUL);
#define CAN3RXERR                       _CAN3RXERR.Byte
#define CAN3RXERR_RXERR0                _CAN3RXERR.Bits.RXERR0
#define CAN3RXERR_RXERR1                _CAN3RXERR.Bits.RXERR1
#define CAN3RXERR_RXERR2                _CAN3RXERR.Bits.RXERR2
#define CAN3RXERR_RXERR3                _CAN3RXERR.Bits.RXERR3
#define CAN3RXERR_RXERR4                _CAN3RXERR.Bits.RXERR4
#define CAN3RXERR_RXERR5                _CAN3RXERR.Bits.RXERR5
#define CAN3RXERR_RXERR6                _CAN3RXERR.Bits.RXERR6
#define CAN3RXERR_RXERR7                _CAN3RXERR.Bits.RXERR7

#define CAN3RXERR_RXERR0_MASK           1U
#define CAN3RXERR_RXERR1_MASK           2U
#define CAN3RXERR_RXERR2_MASK           4U
#define CAN3RXERR_RXERR3_MASK           8U
#define CAN3RXERR_RXERR4_MASK           16U
#define CAN3RXERR_RXERR5_MASK           32U
#define CAN3RXERR_RXERR6_MASK           64U
#define CAN3RXERR_RXERR7_MASK           128U


/*** CAN3TXERR - MSCAN 3 Transmit Error Counter Register; 0x0000020F ***/
typedef union {
  byte Byte;
  struct {
    byte TXERR0      :1;                                       /* Bit 0 */
    byte TXERR1      :1;                                       /* Bit 1 */
    byte TXERR2      :1;                                       /* Bit 2 */
    byte TXERR3      :1;                                       /* Bit 3 */
    byte TXERR4      :1;                                       /* Bit 4 */
    byte TXERR5      :1;                                       /* Bit 5 */
    byte TXERR6      :1;                                       /* Bit 6 */
    byte TXERR7      :1;                                       /* Bit 7 */
  } Bits;
} CAN3TXERRSTR;
extern volatile CAN3TXERRSTR _CAN3TXERR @(REG_BASE + 0x0000020FUL);
#define CAN3TXERR                       _CAN3TXERR.Byte
#define CAN3TXERR_TXERR0                _CAN3TXERR.Bits.TXERR0
#define CAN3TXERR_TXERR1                _CAN3TXERR.Bits.TXERR1
#define CAN3TXERR_TXERR2                _CAN3TXERR.Bits.TXERR2
#define CAN3TXERR_TXERR3                _CAN3TXERR.Bits.TXERR3
#define CAN3TXERR_TXERR4                _CAN3TXERR.Bits.TXERR4
#define CAN3TXERR_TXERR5                _CAN3TXERR.Bits.TXERR5
#define CAN3TXERR_TXERR6                _CAN3TXERR.Bits.TXERR6
#define CAN3TXERR_TXERR7                _CAN3TXERR.Bits.TXERR7

#define CAN3TXERR_TXERR0_MASK           1U
#define CAN3TXERR_TXERR1_MASK           2U
#define CAN3TXERR_TXERR2_MASK           4U
#define CAN3TXERR_TXERR3_MASK           8U
#define CAN3TXERR_TXERR4_MASK           16U
#define CAN3TXERR_TXERR5_MASK           32U
#define CAN3TXERR_TXERR6_MASK           64U
#define CAN3TXERR_TXERR7_MASK           128U


/*** CAN3IDAR0 - MSCAN 3 Identifier Acceptance Register 0; 0x00000210 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN3IDAR0STR;
extern volatile CAN3IDAR0STR _CAN3IDAR0 @(REG_BASE + 0x00000210UL);
#define CAN3IDAR0                       _CAN3IDAR0.Byte
#define CAN3IDAR0_AC0                   _CAN3IDAR0.Bits.AC0
#define CAN3IDAR0_AC1                   _CAN3IDAR0.Bits.AC1
#define CAN3IDAR0_AC2                   _CAN3IDAR0.Bits.AC2
#define CAN3IDAR0_AC3                   _CAN3IDAR0.Bits.AC3
#define CAN3IDAR0_AC4                   _CAN3IDAR0.Bits.AC4
#define CAN3IDAR0_AC5                   _CAN3IDAR0.Bits.AC5
#define CAN3IDAR0_AC6                   _CAN3IDAR0.Bits.AC6
#define CAN3IDAR0_AC7                   _CAN3IDAR0.Bits.AC7
/* CAN3IDAR_ARR: Access 4 CAN3IDARx registers in an array */
#define CAN3IDAR_ARR                    ((volatile byte *) &CAN3IDAR0)

#define CAN3IDAR0_AC0_MASK              1U
#define CAN3IDAR0_AC1_MASK              2U
#define CAN3IDAR0_AC2_MASK              4U
#define CAN3IDAR0_AC3_MASK              8U
#define CAN3IDAR0_AC4_MASK              16U
#define CAN3IDAR0_AC5_MASK              32U
#define CAN3IDAR0_AC6_MASK              64U
#define CAN3IDAR0_AC7_MASK              128U


/*** CAN3IDAR1 - MSCAN 3 Identifier Acceptance Register 1; 0x00000211 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN3IDAR1STR;
extern volatile CAN3IDAR1STR _CAN3IDAR1 @(REG_BASE + 0x00000211UL);
#define CAN3IDAR1                       _CAN3IDAR1.Byte
#define CAN3IDAR1_AC0                   _CAN3IDAR1.Bits.AC0
#define CAN3IDAR1_AC1                   _CAN3IDAR1.Bits.AC1
#define CAN3IDAR1_AC2                   _CAN3IDAR1.Bits.AC2
#define CAN3IDAR1_AC3                   _CAN3IDAR1.Bits.AC3
#define CAN3IDAR1_AC4                   _CAN3IDAR1.Bits.AC4
#define CAN3IDAR1_AC5                   _CAN3IDAR1.Bits.AC5
#define CAN3IDAR1_AC6                   _CAN3IDAR1.Bits.AC6
#define CAN3IDAR1_AC7                   _CAN3IDAR1.Bits.AC7

#define CAN3IDAR1_AC0_MASK              1U
#define CAN3IDAR1_AC1_MASK              2U
#define CAN3IDAR1_AC2_MASK              4U
#define CAN3IDAR1_AC3_MASK              8U
#define CAN3IDAR1_AC4_MASK              16U
#define CAN3IDAR1_AC5_MASK              32U
#define CAN3IDAR1_AC6_MASK              64U
#define CAN3IDAR1_AC7_MASK              128U


/*** CAN3IDAR2 - MSCAN 3 Identifier Acceptance Register 2; 0x00000212 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN3IDAR2STR;
extern volatile CAN3IDAR2STR _CAN3IDAR2 @(REG_BASE + 0x00000212UL);
#define CAN3IDAR2                       _CAN3IDAR2.Byte
#define CAN3IDAR2_AC0                   _CAN3IDAR2.Bits.AC0
#define CAN3IDAR2_AC1                   _CAN3IDAR2.Bits.AC1
#define CAN3IDAR2_AC2                   _CAN3IDAR2.Bits.AC2
#define CAN3IDAR2_AC3                   _CAN3IDAR2.Bits.AC3
#define CAN3IDAR2_AC4                   _CAN3IDAR2.Bits.AC4
#define CAN3IDAR2_AC5                   _CAN3IDAR2.Bits.AC5
#define CAN3IDAR2_AC6                   _CAN3IDAR2.Bits.AC6
#define CAN3IDAR2_AC7                   _CAN3IDAR2.Bits.AC7

#define CAN3IDAR2_AC0_MASK              1U
#define CAN3IDAR2_AC1_MASK              2U
#define CAN3IDAR2_AC2_MASK              4U
#define CAN3IDAR2_AC3_MASK              8U
#define CAN3IDAR2_AC4_MASK              16U
#define CAN3IDAR2_AC5_MASK              32U
#define CAN3IDAR2_AC6_MASK              64U
#define CAN3IDAR2_AC7_MASK              128U


/*** CAN3IDAR3 - MSCAN 3 Identifier Acceptance Register 3; 0x00000213 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN3IDAR3STR;
extern volatile CAN3IDAR3STR _CAN3IDAR3 @(REG_BASE + 0x00000213UL);
#define CAN3IDAR3                       _CAN3IDAR3.Byte
#define CAN3IDAR3_AC0                   _CAN3IDAR3.Bits.AC0
#define CAN3IDAR3_AC1                   _CAN3IDAR3.Bits.AC1
#define CAN3IDAR3_AC2                   _CAN3IDAR3.Bits.AC2
#define CAN3IDAR3_AC3                   _CAN3IDAR3.Bits.AC3
#define CAN3IDAR3_AC4                   _CAN3IDAR3.Bits.AC4
#define CAN3IDAR3_AC5                   _CAN3IDAR3.Bits.AC5
#define CAN3IDAR3_AC6                   _CAN3IDAR3.Bits.AC6
#define CAN3IDAR3_AC7                   _CAN3IDAR3.Bits.AC7

#define CAN3IDAR3_AC0_MASK              1U
#define CAN3IDAR3_AC1_MASK              2U
#define CAN3IDAR3_AC2_MASK              4U
#define CAN3IDAR3_AC3_MASK              8U
#define CAN3IDAR3_AC4_MASK              16U
#define CAN3IDAR3_AC5_MASK              32U
#define CAN3IDAR3_AC6_MASK              64U
#define CAN3IDAR3_AC7_MASK              128U


/*** CAN3IDMR0 - MSCAN 3 Identifier Mask Register 0; 0x00000214 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN3IDMR0STR;
extern volatile CAN3IDMR0STR _CAN3IDMR0 @(REG_BASE + 0x00000214UL);
#define CAN3IDMR0                       _CAN3IDMR0.Byte
#define CAN3IDMR0_AM0                   _CAN3IDMR0.Bits.AM0
#define CAN3IDMR0_AM1                   _CAN3IDMR0.Bits.AM1
#define CAN3IDMR0_AM2                   _CAN3IDMR0.Bits.AM2
#define CAN3IDMR0_AM3                   _CAN3IDMR0.Bits.AM3
#define CAN3IDMR0_AM4                   _CAN3IDMR0.Bits.AM4
#define CAN3IDMR0_AM5                   _CAN3IDMR0.Bits.AM5
#define CAN3IDMR0_AM6                   _CAN3IDMR0.Bits.AM6
#define CAN3IDMR0_AM7                   _CAN3IDMR0.Bits.AM7
/* CAN3IDMR_ARR: Access 4 CAN3IDMRx registers in an array */
#define CAN3IDMR_ARR                    ((volatile byte *) &CAN3IDMR0)

#define CAN3IDMR0_AM0_MASK              1U
#define CAN3IDMR0_AM1_MASK              2U
#define CAN3IDMR0_AM2_MASK              4U
#define CAN3IDMR0_AM3_MASK              8U
#define CAN3IDMR0_AM4_MASK              16U
#define CAN3IDMR0_AM5_MASK              32U
#define CAN3IDMR0_AM6_MASK              64U
#define CAN3IDMR0_AM7_MASK              128U


/*** CAN3IDMR1 - MSCAN 3 Identifier Mask Register 1; 0x00000215 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN3IDMR1STR;
extern volatile CAN3IDMR1STR _CAN3IDMR1 @(REG_BASE + 0x00000215UL);
#define CAN3IDMR1                       _CAN3IDMR1.Byte
#define CAN3IDMR1_AM0                   _CAN3IDMR1.Bits.AM0
#define CAN3IDMR1_AM1                   _CAN3IDMR1.Bits.AM1
#define CAN3IDMR1_AM2                   _CAN3IDMR1.Bits.AM2
#define CAN3IDMR1_AM3                   _CAN3IDMR1.Bits.AM3
#define CAN3IDMR1_AM4                   _CAN3IDMR1.Bits.AM4
#define CAN3IDMR1_AM5                   _CAN3IDMR1.Bits.AM5
#define CAN3IDMR1_AM6                   _CAN3IDMR1.Bits.AM6
#define CAN3IDMR1_AM7                   _CAN3IDMR1.Bits.AM7

#define CAN3IDMR1_AM0_MASK              1U
#define CAN3IDMR1_AM1_MASK              2U
#define CAN3IDMR1_AM2_MASK              4U
#define CAN3IDMR1_AM3_MASK              8U
#define CAN3IDMR1_AM4_MASK              16U
#define CAN3IDMR1_AM5_MASK              32U
#define CAN3IDMR1_AM6_MASK              64U
#define CAN3IDMR1_AM7_MASK              128U


/*** CAN3IDMR2 - MSCAN 3 Identifier Mask Register 2; 0x00000216 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN3IDMR2STR;
extern volatile CAN3IDMR2STR _CAN3IDMR2 @(REG_BASE + 0x00000216UL);
#define CAN3IDMR2                       _CAN3IDMR2.Byte
#define CAN3IDMR2_AM0                   _CAN3IDMR2.Bits.AM0
#define CAN3IDMR2_AM1                   _CAN3IDMR2.Bits.AM1
#define CAN3IDMR2_AM2                   _CAN3IDMR2.Bits.AM2
#define CAN3IDMR2_AM3                   _CAN3IDMR2.Bits.AM3
#define CAN3IDMR2_AM4                   _CAN3IDMR2.Bits.AM4
#define CAN3IDMR2_AM5                   _CAN3IDMR2.Bits.AM5
#define CAN3IDMR2_AM6                   _CAN3IDMR2.Bits.AM6
#define CAN3IDMR2_AM7                   _CAN3IDMR2.Bits.AM7

#define CAN3IDMR2_AM0_MASK              1U
#define CAN3IDMR2_AM1_MASK              2U
#define CAN3IDMR2_AM2_MASK              4U
#define CAN3IDMR2_AM3_MASK              8U
#define CAN3IDMR2_AM4_MASK              16U
#define CAN3IDMR2_AM5_MASK              32U
#define CAN3IDMR2_AM6_MASK              64U
#define CAN3IDMR2_AM7_MASK              128U


/*** CAN3IDMR3 - MSCAN 3 Identifier Mask Register 3; 0x00000217 ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN3IDMR3STR;
extern volatile CAN3IDMR3STR _CAN3IDMR3 @(REG_BASE + 0x00000217UL);
#define CAN3IDMR3                       _CAN3IDMR3.Byte
#define CAN3IDMR3_AM0                   _CAN3IDMR3.Bits.AM0
#define CAN3IDMR3_AM1                   _CAN3IDMR3.Bits.AM1
#define CAN3IDMR3_AM2                   _CAN3IDMR3.Bits.AM2
#define CAN3IDMR3_AM3                   _CAN3IDMR3.Bits.AM3
#define CAN3IDMR3_AM4                   _CAN3IDMR3.Bits.AM4
#define CAN3IDMR3_AM5                   _CAN3IDMR3.Bits.AM5
#define CAN3IDMR3_AM6                   _CAN3IDMR3.Bits.AM6
#define CAN3IDMR3_AM7                   _CAN3IDMR3.Bits.AM7

#define CAN3IDMR3_AM0_MASK              1U
#define CAN3IDMR3_AM1_MASK              2U
#define CAN3IDMR3_AM2_MASK              4U
#define CAN3IDMR3_AM3_MASK              8U
#define CAN3IDMR3_AM4_MASK              16U
#define CAN3IDMR3_AM5_MASK              32U
#define CAN3IDMR3_AM6_MASK              64U
#define CAN3IDMR3_AM7_MASK              128U


/*** CAN3IDAR4 - MSCAN 3 Identifier Acceptance Register 4; 0x00000218 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN3IDAR4STR;
extern volatile CAN3IDAR4STR _CAN3IDAR4 @(REG_BASE + 0x00000218UL);
#define CAN3IDAR4                       _CAN3IDAR4.Byte
#define CAN3IDAR4_AC0                   _CAN3IDAR4.Bits.AC0
#define CAN3IDAR4_AC1                   _CAN3IDAR4.Bits.AC1
#define CAN3IDAR4_AC2                   _CAN3IDAR4.Bits.AC2
#define CAN3IDAR4_AC3                   _CAN3IDAR4.Bits.AC3
#define CAN3IDAR4_AC4                   _CAN3IDAR4.Bits.AC4
#define CAN3IDAR4_AC5                   _CAN3IDAR4.Bits.AC5
#define CAN3IDAR4_AC6                   _CAN3IDAR4.Bits.AC6
#define CAN3IDAR4_AC7                   _CAN3IDAR4.Bits.AC7

#define CAN3IDAR4_AC0_MASK              1U
#define CAN3IDAR4_AC1_MASK              2U
#define CAN3IDAR4_AC2_MASK              4U
#define CAN3IDAR4_AC3_MASK              8U
#define CAN3IDAR4_AC4_MASK              16U
#define CAN3IDAR4_AC5_MASK              32U
#define CAN3IDAR4_AC6_MASK              64U
#define CAN3IDAR4_AC7_MASK              128U


/*** CAN3IDAR5 - MSCAN 3 Identifier Acceptance Register 5; 0x00000219 ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN3IDAR5STR;
extern volatile CAN3IDAR5STR _CAN3IDAR5 @(REG_BASE + 0x00000219UL);
#define CAN3IDAR5                       _CAN3IDAR5.Byte
#define CAN3IDAR5_AC0                   _CAN3IDAR5.Bits.AC0
#define CAN3IDAR5_AC1                   _CAN3IDAR5.Bits.AC1
#define CAN3IDAR5_AC2                   _CAN3IDAR5.Bits.AC2
#define CAN3IDAR5_AC3                   _CAN3IDAR5.Bits.AC3
#define CAN3IDAR5_AC4                   _CAN3IDAR5.Bits.AC4
#define CAN3IDAR5_AC5                   _CAN3IDAR5.Bits.AC5
#define CAN3IDAR5_AC6                   _CAN3IDAR5.Bits.AC6
#define CAN3IDAR5_AC7                   _CAN3IDAR5.Bits.AC7

#define CAN3IDAR5_AC0_MASK              1U
#define CAN3IDAR5_AC1_MASK              2U
#define CAN3IDAR5_AC2_MASK              4U
#define CAN3IDAR5_AC3_MASK              8U
#define CAN3IDAR5_AC4_MASK              16U
#define CAN3IDAR5_AC5_MASK              32U
#define CAN3IDAR5_AC6_MASK              64U
#define CAN3IDAR5_AC7_MASK              128U


/*** CAN3IDAR6 - MSCAN 3 Identifier Acceptance Register 6; 0x0000021A ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN3IDAR6STR;
extern volatile CAN3IDAR6STR _CAN3IDAR6 @(REG_BASE + 0x0000021AUL);
#define CAN3IDAR6                       _CAN3IDAR6.Byte
#define CAN3IDAR6_AC0                   _CAN3IDAR6.Bits.AC0
#define CAN3IDAR6_AC1                   _CAN3IDAR6.Bits.AC1
#define CAN3IDAR6_AC2                   _CAN3IDAR6.Bits.AC2
#define CAN3IDAR6_AC3                   _CAN3IDAR6.Bits.AC3
#define CAN3IDAR6_AC4                   _CAN3IDAR6.Bits.AC4
#define CAN3IDAR6_AC5                   _CAN3IDAR6.Bits.AC5
#define CAN3IDAR6_AC6                   _CAN3IDAR6.Bits.AC6
#define CAN3IDAR6_AC7                   _CAN3IDAR6.Bits.AC7

#define CAN3IDAR6_AC0_MASK              1U
#define CAN3IDAR6_AC1_MASK              2U
#define CAN3IDAR6_AC2_MASK              4U
#define CAN3IDAR6_AC3_MASK              8U
#define CAN3IDAR6_AC4_MASK              16U
#define CAN3IDAR6_AC5_MASK              32U
#define CAN3IDAR6_AC6_MASK              64U
#define CAN3IDAR6_AC7_MASK              128U


/*** CAN3IDAR7 - MSCAN 3 Identifier Acceptance Register 7; 0x0000021B ***/
typedef union {
  byte Byte;
  struct {
    byte AC0         :1;                                       /* Acceptance Code Bit 0 */
    byte AC1         :1;                                       /* Acceptance Code Bit 1 */
    byte AC2         :1;                                       /* Acceptance Code Bit 2 */
    byte AC3         :1;                                       /* Acceptance Code Bit 3 */
    byte AC4         :1;                                       /* Acceptance Code Bit 4 */
    byte AC5         :1;                                       /* Acceptance Code Bit 5 */
    byte AC6         :1;                                       /* Acceptance Code Bit 6 */
    byte AC7         :1;                                       /* Acceptance Code Bit 7 */
  } Bits;
} CAN3IDAR7STR;
extern volatile CAN3IDAR7STR _CAN3IDAR7 @(REG_BASE + 0x0000021BUL);
#define CAN3IDAR7                       _CAN3IDAR7.Byte
#define CAN3IDAR7_AC0                   _CAN3IDAR7.Bits.AC0
#define CAN3IDAR7_AC1                   _CAN3IDAR7.Bits.AC1
#define CAN3IDAR7_AC2                   _CAN3IDAR7.Bits.AC2
#define CAN3IDAR7_AC3                   _CAN3IDAR7.Bits.AC3
#define CAN3IDAR7_AC4                   _CAN3IDAR7.Bits.AC4
#define CAN3IDAR7_AC5                   _CAN3IDAR7.Bits.AC5
#define CAN3IDAR7_AC6                   _CAN3IDAR7.Bits.AC6
#define CAN3IDAR7_AC7                   _CAN3IDAR7.Bits.AC7

#define CAN3IDAR7_AC0_MASK              1U
#define CAN3IDAR7_AC1_MASK              2U
#define CAN3IDAR7_AC2_MASK              4U
#define CAN3IDAR7_AC3_MASK              8U
#define CAN3IDAR7_AC4_MASK              16U
#define CAN3IDAR7_AC5_MASK              32U
#define CAN3IDAR7_AC6_MASK              64U
#define CAN3IDAR7_AC7_MASK              128U


/*** CAN3IDMR4 - MSCAN 3 Identifier Mask Register 4; 0x0000021C ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN3IDMR4STR;
extern volatile CAN3IDMR4STR _CAN3IDMR4 @(REG_BASE + 0x0000021CUL);
#define CAN3IDMR4                       _CAN3IDMR4.Byte
#define CAN3IDMR4_AM0                   _CAN3IDMR4.Bits.AM0
#define CAN3IDMR4_AM1                   _CAN3IDMR4.Bits.AM1
#define CAN3IDMR4_AM2                   _CAN3IDMR4.Bits.AM2
#define CAN3IDMR4_AM3                   _CAN3IDMR4.Bits.AM3
#define CAN3IDMR4_AM4                   _CAN3IDMR4.Bits.AM4
#define CAN3IDMR4_AM5                   _CAN3IDMR4.Bits.AM5
#define CAN3IDMR4_AM6                   _CAN3IDMR4.Bits.AM6
#define CAN3IDMR4_AM7                   _CAN3IDMR4.Bits.AM7

#define CAN3IDMR4_AM0_MASK              1U
#define CAN3IDMR4_AM1_MASK              2U
#define CAN3IDMR4_AM2_MASK              4U
#define CAN3IDMR4_AM3_MASK              8U
#define CAN3IDMR4_AM4_MASK              16U
#define CAN3IDMR4_AM5_MASK              32U
#define CAN3IDMR4_AM6_MASK              64U
#define CAN3IDMR4_AM7_MASK              128U


/*** CAN3IDMR5 - MSCAN 3 Identifier Mask Register 5; 0x0000021D ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN3IDMR5STR;
extern volatile CAN3IDMR5STR _CAN3IDMR5 @(REG_BASE + 0x0000021DUL);
#define CAN3IDMR5                       _CAN3IDMR5.Byte
#define CAN3IDMR5_AM0                   _CAN3IDMR5.Bits.AM0
#define CAN3IDMR5_AM1                   _CAN3IDMR5.Bits.AM1
#define CAN3IDMR5_AM2                   _CAN3IDMR5.Bits.AM2
#define CAN3IDMR5_AM3                   _CAN3IDMR5.Bits.AM3
#define CAN3IDMR5_AM4                   _CAN3IDMR5.Bits.AM4
#define CAN3IDMR5_AM5                   _CAN3IDMR5.Bits.AM5
#define CAN3IDMR5_AM6                   _CAN3IDMR5.Bits.AM6
#define CAN3IDMR5_AM7                   _CAN3IDMR5.Bits.AM7

#define CAN3IDMR5_AM0_MASK              1U
#define CAN3IDMR5_AM1_MASK              2U
#define CAN3IDMR5_AM2_MASK              4U
#define CAN3IDMR5_AM3_MASK              8U
#define CAN3IDMR5_AM4_MASK              16U
#define CAN3IDMR5_AM5_MASK              32U
#define CAN3IDMR5_AM6_MASK              64U
#define CAN3IDMR5_AM7_MASK              128U


/*** CAN3IDMR6 - MSCAN 3 Identifier Mask Register 6; 0x0000021E ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN3IDMR6STR;
extern volatile CAN3IDMR6STR _CAN3IDMR6 @(REG_BASE + 0x0000021EUL);
#define CAN3IDMR6                       _CAN3IDMR6.Byte
#define CAN3IDMR6_AM0                   _CAN3IDMR6.Bits.AM0
#define CAN3IDMR6_AM1                   _CAN3IDMR6.Bits.AM1
#define CAN3IDMR6_AM2                   _CAN3IDMR6.Bits.AM2
#define CAN3IDMR6_AM3                   _CAN3IDMR6.Bits.AM3
#define CAN3IDMR6_AM4                   _CAN3IDMR6.Bits.AM4
#define CAN3IDMR6_AM5                   _CAN3IDMR6.Bits.AM5
#define CAN3IDMR6_AM6                   _CAN3IDMR6.Bits.AM6
#define CAN3IDMR6_AM7                   _CAN3IDMR6.Bits.AM7

#define CAN3IDMR6_AM0_MASK              1U
#define CAN3IDMR6_AM1_MASK              2U
#define CAN3IDMR6_AM2_MASK              4U
#define CAN3IDMR6_AM3_MASK              8U
#define CAN3IDMR6_AM4_MASK              16U
#define CAN3IDMR6_AM5_MASK              32U
#define CAN3IDMR6_AM6_MASK              64U
#define CAN3IDMR6_AM7_MASK              128U


/*** CAN3IDMR7 - MSCAN 3 Identifier Mask Register 7; 0x0000021F ***/
typedef union {
  byte Byte;
  struct {
    byte AM0         :1;                                       /* Acceptance Mask Bit 0 */
    byte AM1         :1;                                       /* Acceptance Mask Bit 1 */
    byte AM2         :1;                                       /* Acceptance Mask Bit 2 */
    byte AM3         :1;                                       /* Acceptance Mask Bit 3 */
    byte AM4         :1;                                       /* Acceptance Mask Bit 4 */
    byte AM5         :1;                                       /* Acceptance Mask Bit 5 */
    byte AM6         :1;                                       /* Acceptance Mask Bit 6 */
    byte AM7         :1;                                       /* Acceptance Mask Bit 7 */
  } Bits;
} CAN3IDMR7STR;
extern volatile CAN3IDMR7STR _CAN3IDMR7 @(REG_BASE + 0x0000021FUL);
#define CAN3IDMR7                       _CAN3IDMR7.Byte
#define CAN3IDMR7_AM0                   _CAN3IDMR7.Bits.AM0
#define CAN3IDMR7_AM1                   _CAN3IDMR7.Bits.AM1
#define CAN3IDMR7_AM2                   _CAN3IDMR7.Bits.AM2
#define CAN3IDMR7_AM3                   _CAN3IDMR7.Bits.AM3
#define CAN3IDMR7_AM4                   _CAN3IDMR7.Bits.AM4
#define CAN3IDMR7_AM5                   _CAN3IDMR7.Bits.AM5
#define CAN3IDMR7_AM6                   _CAN3IDMR7.Bits.AM6
#define CAN3IDMR7_AM7                   _CAN3IDMR7.Bits.AM7

#define CAN3IDMR7_AM0_MASK              1U
#define CAN3IDMR7_AM1_MASK              2U
#define CAN3IDMR7_AM2_MASK              4U
#define CAN3IDMR7_AM3_MASK              8U
#define CAN3IDMR7_AM4_MASK              16U
#define CAN3IDMR7_AM5_MASK              32U
#define CAN3IDMR7_AM6_MASK              64U
#define CAN3IDMR7_AM7_MASK              128U


/*** CAN3RXIDR0 - MSCAN 3 Receive Identifier Register 0; 0x00000220 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN3RXIDR0STR;
extern volatile CAN3RXIDR0STR _CAN3RXIDR0 @(REG_BASE + 0x00000220UL);
#define CAN3RXIDR0                      _CAN3RXIDR0.Byte
#define CAN3RXIDR0_ID21                 _CAN3RXIDR0.Bits.ID21
#define CAN3RXIDR0_ID22                 _CAN3RXIDR0.Bits.ID22
#define CAN3RXIDR0_ID23                 _CAN3RXIDR0.Bits.ID23
#define CAN3RXIDR0_ID24                 _CAN3RXIDR0.Bits.ID24
#define CAN3RXIDR0_ID25                 _CAN3RXIDR0.Bits.ID25
#define CAN3RXIDR0_ID26                 _CAN3RXIDR0.Bits.ID26
#define CAN3RXIDR0_ID27                 _CAN3RXIDR0.Bits.ID27
#define CAN3RXIDR0_ID28                 _CAN3RXIDR0.Bits.ID28
/* CAN3RXIDR_ARR: Access 4 CAN3RXIDRx registers in an array */
#define CAN3RXIDR_ARR                   ((volatile byte *) &CAN3RXIDR0)

#define CAN3RXIDR0_ID21_MASK            1U
#define CAN3RXIDR0_ID22_MASK            2U
#define CAN3RXIDR0_ID23_MASK            4U
#define CAN3RXIDR0_ID24_MASK            8U
#define CAN3RXIDR0_ID25_MASK            16U
#define CAN3RXIDR0_ID26_MASK            32U
#define CAN3RXIDR0_ID27_MASK            64U
#define CAN3RXIDR0_ID28_MASK            128U


/*** CAN3RXIDR1 - MSCAN 3 Receive Identifier Register 1; 0x00000221 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN3RXIDR1STR;
extern volatile CAN3RXIDR1STR _CAN3RXIDR1 @(REG_BASE + 0x00000221UL);
#define CAN3RXIDR1                      _CAN3RXIDR1.Byte
#define CAN3RXIDR1_ID15                 _CAN3RXIDR1.Bits.ID15
#define CAN3RXIDR1_ID16                 _CAN3RXIDR1.Bits.ID16
#define CAN3RXIDR1_ID17                 _CAN3RXIDR1.Bits.ID17
#define CAN3RXIDR1_IDE                  _CAN3RXIDR1.Bits.IDE
#define CAN3RXIDR1_SRR                  _CAN3RXIDR1.Bits.SRR
#define CAN3RXIDR1_ID18                 _CAN3RXIDR1.Bits.ID18
#define CAN3RXIDR1_ID19                 _CAN3RXIDR1.Bits.ID19
#define CAN3RXIDR1_ID20                 _CAN3RXIDR1.Bits.ID20
#define CAN3RXIDR1_ID_15                _CAN3RXIDR1.MergedBits.grpID_15
#define CAN3RXIDR1_ID_18                _CAN3RXIDR1.MergedBits.grpID_18
#define CAN3RXIDR1_ID                   CAN3RXIDR1_ID_15

#define CAN3RXIDR1_ID15_MASK            1U
#define CAN3RXIDR1_ID16_MASK            2U
#define CAN3RXIDR1_ID17_MASK            4U
#define CAN3RXIDR1_IDE_MASK             8U
#define CAN3RXIDR1_SRR_MASK             16U
#define CAN3RXIDR1_ID18_MASK            32U
#define CAN3RXIDR1_ID19_MASK            64U
#define CAN3RXIDR1_ID20_MASK            128U
#define CAN3RXIDR1_ID_15_MASK           7U
#define CAN3RXIDR1_ID_15_BITNUM         0U
#define CAN3RXIDR1_ID_18_MASK           224U
#define CAN3RXIDR1_ID_18_BITNUM         5U


/*** CAN3RXIDR2 - MSCAN 3 Receive Identifier Register 2; 0x00000222 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN3RXIDR2STR;
extern volatile CAN3RXIDR2STR _CAN3RXIDR2 @(REG_BASE + 0x00000222UL);
#define CAN3RXIDR2                      _CAN3RXIDR2.Byte
#define CAN3RXIDR2_ID7                  _CAN3RXIDR2.Bits.ID7
#define CAN3RXIDR2_ID8                  _CAN3RXIDR2.Bits.ID8
#define CAN3RXIDR2_ID9                  _CAN3RXIDR2.Bits.ID9
#define CAN3RXIDR2_ID10                 _CAN3RXIDR2.Bits.ID10
#define CAN3RXIDR2_ID11                 _CAN3RXIDR2.Bits.ID11
#define CAN3RXIDR2_ID12                 _CAN3RXIDR2.Bits.ID12
#define CAN3RXIDR2_ID13                 _CAN3RXIDR2.Bits.ID13
#define CAN3RXIDR2_ID14                 _CAN3RXIDR2.Bits.ID14

#define CAN3RXIDR2_ID7_MASK             1U
#define CAN3RXIDR2_ID8_MASK             2U
#define CAN3RXIDR2_ID9_MASK             4U
#define CAN3RXIDR2_ID10_MASK            8U
#define CAN3RXIDR2_ID11_MASK            16U
#define CAN3RXIDR2_ID12_MASK            32U
#define CAN3RXIDR2_ID13_MASK            64U
#define CAN3RXIDR2_ID14_MASK            128U


/*** CAN3RXIDR3 - MSCAN 3 Receive Identifier Register 3; 0x00000223 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN3RXIDR3STR;
extern volatile CAN3RXIDR3STR _CAN3RXIDR3 @(REG_BASE + 0x00000223UL);
#define CAN3RXIDR3                      _CAN3RXIDR3.Byte
#define CAN3RXIDR3_RTR                  _CAN3RXIDR3.Bits.RTR
#define CAN3RXIDR3_ID0                  _CAN3RXIDR3.Bits.ID0
#define CAN3RXIDR3_ID1                  _CAN3RXIDR3.Bits.ID1
#define CAN3RXIDR3_ID2                  _CAN3RXIDR3.Bits.ID2
#define CAN3RXIDR3_ID3                  _CAN3RXIDR3.Bits.ID3
#define CAN3RXIDR3_ID4                  _CAN3RXIDR3.Bits.ID4
#define CAN3RXIDR3_ID5                  _CAN3RXIDR3.Bits.ID5
#define CAN3RXIDR3_ID6                  _CAN3RXIDR3.Bits.ID6
#define CAN3RXIDR3_ID                   _CAN3RXIDR3.MergedBits.grpID

#define CAN3RXIDR3_RTR_MASK             1U
#define CAN3RXIDR3_ID0_MASK             2U
#define CAN3RXIDR3_ID1_MASK             4U
#define CAN3RXIDR3_ID2_MASK             8U
#define CAN3RXIDR3_ID3_MASK             16U
#define CAN3RXIDR3_ID4_MASK             32U
#define CAN3RXIDR3_ID5_MASK             64U
#define CAN3RXIDR3_ID6_MASK             128U
#define CAN3RXIDR3_ID_MASK              254U
#define CAN3RXIDR3_ID_BITNUM            1U


/*** CAN3RXDSR0 - MSCAN 3 Receive Data Segment Register 0; 0x00000224 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN3RXDSR0STR;
extern volatile CAN3RXDSR0STR _CAN3RXDSR0 @(REG_BASE + 0x00000224UL);
#define CAN3RXDSR0                      _CAN3RXDSR0.Byte
#define CAN3RXDSR0_DB0                  _CAN3RXDSR0.Bits.DB0
#define CAN3RXDSR0_DB1                  _CAN3RXDSR0.Bits.DB1
#define CAN3RXDSR0_DB2                  _CAN3RXDSR0.Bits.DB2
#define CAN3RXDSR0_DB3                  _CAN3RXDSR0.Bits.DB3
#define CAN3RXDSR0_DB4                  _CAN3RXDSR0.Bits.DB4
#define CAN3RXDSR0_DB5                  _CAN3RXDSR0.Bits.DB5
#define CAN3RXDSR0_DB6                  _CAN3RXDSR0.Bits.DB6
#define CAN3RXDSR0_DB7                  _CAN3RXDSR0.Bits.DB7
/* CAN3RXDSR_ARR: Access 8 CAN3RXDSRx registers in an array */
#define CAN3RXDSR_ARR                   ((volatile byte *) &CAN3RXDSR0)

#define CAN3RXDSR0_DB0_MASK             1U
#define CAN3RXDSR0_DB1_MASK             2U
#define CAN3RXDSR0_DB2_MASK             4U
#define CAN3RXDSR0_DB3_MASK             8U
#define CAN3RXDSR0_DB4_MASK             16U
#define CAN3RXDSR0_DB5_MASK             32U
#define CAN3RXDSR0_DB6_MASK             64U
#define CAN3RXDSR0_DB7_MASK             128U


/*** CAN3RXDSR1 - MSCAN 3 Receive Data Segment Register 1; 0x00000225 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN3RXDSR1STR;
extern volatile CAN3RXDSR1STR _CAN3RXDSR1 @(REG_BASE + 0x00000225UL);
#define CAN3RXDSR1                      _CAN3RXDSR1.Byte
#define CAN3RXDSR1_DB0                  _CAN3RXDSR1.Bits.DB0
#define CAN3RXDSR1_DB1                  _CAN3RXDSR1.Bits.DB1
#define CAN3RXDSR1_DB2                  _CAN3RXDSR1.Bits.DB2
#define CAN3RXDSR1_DB3                  _CAN3RXDSR1.Bits.DB3
#define CAN3RXDSR1_DB4                  _CAN3RXDSR1.Bits.DB4
#define CAN3RXDSR1_DB5                  _CAN3RXDSR1.Bits.DB5
#define CAN3RXDSR1_DB6                  _CAN3RXDSR1.Bits.DB6
#define CAN3RXDSR1_DB7                  _CAN3RXDSR1.Bits.DB7

#define CAN3RXDSR1_DB0_MASK             1U
#define CAN3RXDSR1_DB1_MASK             2U
#define CAN3RXDSR1_DB2_MASK             4U
#define CAN3RXDSR1_DB3_MASK             8U
#define CAN3RXDSR1_DB4_MASK             16U
#define CAN3RXDSR1_DB5_MASK             32U
#define CAN3RXDSR1_DB6_MASK             64U
#define CAN3RXDSR1_DB7_MASK             128U


/*** CAN3RXDSR2 - MSCAN 3 Receive Data Segment Register 2; 0x00000226 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN3RXDSR2STR;
extern volatile CAN3RXDSR2STR _CAN3RXDSR2 @(REG_BASE + 0x00000226UL);
#define CAN3RXDSR2                      _CAN3RXDSR2.Byte
#define CAN3RXDSR2_DB0                  _CAN3RXDSR2.Bits.DB0
#define CAN3RXDSR2_DB1                  _CAN3RXDSR2.Bits.DB1
#define CAN3RXDSR2_DB2                  _CAN3RXDSR2.Bits.DB2
#define CAN3RXDSR2_DB3                  _CAN3RXDSR2.Bits.DB3
#define CAN3RXDSR2_DB4                  _CAN3RXDSR2.Bits.DB4
#define CAN3RXDSR2_DB5                  _CAN3RXDSR2.Bits.DB5
#define CAN3RXDSR2_DB6                  _CAN3RXDSR2.Bits.DB6
#define CAN3RXDSR2_DB7                  _CAN3RXDSR2.Bits.DB7

#define CAN3RXDSR2_DB0_MASK             1U
#define CAN3RXDSR2_DB1_MASK             2U
#define CAN3RXDSR2_DB2_MASK             4U
#define CAN3RXDSR2_DB3_MASK             8U
#define CAN3RXDSR2_DB4_MASK             16U
#define CAN3RXDSR2_DB5_MASK             32U
#define CAN3RXDSR2_DB6_MASK             64U
#define CAN3RXDSR2_DB7_MASK             128U


/*** CAN3RXDSR3 - MSCAN 3 Receive Data Segment Register 3; 0x00000227 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN3RXDSR3STR;
extern volatile CAN3RXDSR3STR _CAN3RXDSR3 @(REG_BASE + 0x00000227UL);
#define CAN3RXDSR3                      _CAN3RXDSR3.Byte
#define CAN3RXDSR3_DB0                  _CAN3RXDSR3.Bits.DB0
#define CAN3RXDSR3_DB1                  _CAN3RXDSR3.Bits.DB1
#define CAN3RXDSR3_DB2                  _CAN3RXDSR3.Bits.DB2
#define CAN3RXDSR3_DB3                  _CAN3RXDSR3.Bits.DB3
#define CAN3RXDSR3_DB4                  _CAN3RXDSR3.Bits.DB4
#define CAN3RXDSR3_DB5                  _CAN3RXDSR3.Bits.DB5
#define CAN3RXDSR3_DB6                  _CAN3RXDSR3.Bits.DB6
#define CAN3RXDSR3_DB7                  _CAN3RXDSR3.Bits.DB7

#define CAN3RXDSR3_DB0_MASK             1U
#define CAN3RXDSR3_DB1_MASK             2U
#define CAN3RXDSR3_DB2_MASK             4U
#define CAN3RXDSR3_DB3_MASK             8U
#define CAN3RXDSR3_DB4_MASK             16U
#define CAN3RXDSR3_DB5_MASK             32U
#define CAN3RXDSR3_DB6_MASK             64U
#define CAN3RXDSR3_DB7_MASK             128U


/*** CAN3RXDSR4 - MSCAN 3 Receive Data Segment Register 4; 0x00000228 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN3RXDSR4STR;
extern volatile CAN3RXDSR4STR _CAN3RXDSR4 @(REG_BASE + 0x00000228UL);
#define CAN3RXDSR4                      _CAN3RXDSR4.Byte
#define CAN3RXDSR4_DB0                  _CAN3RXDSR4.Bits.DB0
#define CAN3RXDSR4_DB1                  _CAN3RXDSR4.Bits.DB1
#define CAN3RXDSR4_DB2                  _CAN3RXDSR4.Bits.DB2
#define CAN3RXDSR4_DB3                  _CAN3RXDSR4.Bits.DB3
#define CAN3RXDSR4_DB4                  _CAN3RXDSR4.Bits.DB4
#define CAN3RXDSR4_DB5                  _CAN3RXDSR4.Bits.DB5
#define CAN3RXDSR4_DB6                  _CAN3RXDSR4.Bits.DB6
#define CAN3RXDSR4_DB7                  _CAN3RXDSR4.Bits.DB7

#define CAN3RXDSR4_DB0_MASK             1U
#define CAN3RXDSR4_DB1_MASK             2U
#define CAN3RXDSR4_DB2_MASK             4U
#define CAN3RXDSR4_DB3_MASK             8U
#define CAN3RXDSR4_DB4_MASK             16U
#define CAN3RXDSR4_DB5_MASK             32U
#define CAN3RXDSR4_DB6_MASK             64U
#define CAN3RXDSR4_DB7_MASK             128U


/*** CAN3RXDSR5 - MSCAN 3 Receive Data Segment Register 5; 0x00000229 ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN3RXDSR5STR;
extern volatile CAN3RXDSR5STR _CAN3RXDSR5 @(REG_BASE + 0x00000229UL);
#define CAN3RXDSR5                      _CAN3RXDSR5.Byte
#define CAN3RXDSR5_DB0                  _CAN3RXDSR5.Bits.DB0
#define CAN3RXDSR5_DB1                  _CAN3RXDSR5.Bits.DB1
#define CAN3RXDSR5_DB2                  _CAN3RXDSR5.Bits.DB2
#define CAN3RXDSR5_DB3                  _CAN3RXDSR5.Bits.DB3
#define CAN3RXDSR5_DB4                  _CAN3RXDSR5.Bits.DB4
#define CAN3RXDSR5_DB5                  _CAN3RXDSR5.Bits.DB5
#define CAN3RXDSR5_DB6                  _CAN3RXDSR5.Bits.DB6
#define CAN3RXDSR5_DB7                  _CAN3RXDSR5.Bits.DB7

#define CAN3RXDSR5_DB0_MASK             1U
#define CAN3RXDSR5_DB1_MASK             2U
#define CAN3RXDSR5_DB2_MASK             4U
#define CAN3RXDSR5_DB3_MASK             8U
#define CAN3RXDSR5_DB4_MASK             16U
#define CAN3RXDSR5_DB5_MASK             32U
#define CAN3RXDSR5_DB6_MASK             64U
#define CAN3RXDSR5_DB7_MASK             128U


/*** CAN3RXDSR6 - MSCAN 3 Receive Data Segment Register 6; 0x0000022A ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN3RXDSR6STR;
extern volatile CAN3RXDSR6STR _CAN3RXDSR6 @(REG_BASE + 0x0000022AUL);
#define CAN3RXDSR6                      _CAN3RXDSR6.Byte
#define CAN3RXDSR6_DB0                  _CAN3RXDSR6.Bits.DB0
#define CAN3RXDSR6_DB1                  _CAN3RXDSR6.Bits.DB1
#define CAN3RXDSR6_DB2                  _CAN3RXDSR6.Bits.DB2
#define CAN3RXDSR6_DB3                  _CAN3RXDSR6.Bits.DB3
#define CAN3RXDSR6_DB4                  _CAN3RXDSR6.Bits.DB4
#define CAN3RXDSR6_DB5                  _CAN3RXDSR6.Bits.DB5
#define CAN3RXDSR6_DB6                  _CAN3RXDSR6.Bits.DB6
#define CAN3RXDSR6_DB7                  _CAN3RXDSR6.Bits.DB7

#define CAN3RXDSR6_DB0_MASK             1U
#define CAN3RXDSR6_DB1_MASK             2U
#define CAN3RXDSR6_DB2_MASK             4U
#define CAN3RXDSR6_DB3_MASK             8U
#define CAN3RXDSR6_DB4_MASK             16U
#define CAN3RXDSR6_DB5_MASK             32U
#define CAN3RXDSR6_DB6_MASK             64U
#define CAN3RXDSR6_DB7_MASK             128U


/*** CAN3RXDSR7 - MSCAN 3 Receive Data Segment Register 7; 0x0000022B ***/
typedef union {
  byte Byte;
  struct {
    byte DB0         :1;                                       /* Data Bit 0 */
    byte DB1         :1;                                       /* Data Bit 1 */
    byte DB2         :1;                                       /* Data Bit 2 */
    byte DB3         :1;                                       /* Data Bit 3 */
    byte DB4         :1;                                       /* Data Bit 4 */
    byte DB5         :1;                                       /* Data Bit 5 */
    byte DB6         :1;                                       /* Data Bit 6 */
    byte DB7         :1;                                       /* Data Bit 7 */
  } Bits;
} CAN3RXDSR7STR;
extern volatile CAN3RXDSR7STR _CAN3RXDSR7 @(REG_BASE + 0x0000022BUL);
#define CAN3RXDSR7                      _CAN3RXDSR7.Byte
#define CAN3RXDSR7_DB0                  _CAN3RXDSR7.Bits.DB0
#define CAN3RXDSR7_DB1                  _CAN3RXDSR7.Bits.DB1
#define CAN3RXDSR7_DB2                  _CAN3RXDSR7.Bits.DB2
#define CAN3RXDSR7_DB3                  _CAN3RXDSR7.Bits.DB3
#define CAN3RXDSR7_DB4                  _CAN3RXDSR7.Bits.DB4
#define CAN3RXDSR7_DB5                  _CAN3RXDSR7.Bits.DB5
#define CAN3RXDSR7_DB6                  _CAN3RXDSR7.Bits.DB6
#define CAN3RXDSR7_DB7                  _CAN3RXDSR7.Bits.DB7

#define CAN3RXDSR7_DB0_MASK             1U
#define CAN3RXDSR7_DB1_MASK             2U
#define CAN3RXDSR7_DB2_MASK             4U
#define CAN3RXDSR7_DB3_MASK             8U
#define CAN3RXDSR7_DB4_MASK             16U
#define CAN3RXDSR7_DB5_MASK             32U
#define CAN3RXDSR7_DB6_MASK             64U
#define CAN3RXDSR7_DB7_MASK             128U


/*** CAN3RXDLR - MSCAN 3 Receive Data Length Register; 0x0000022C ***/
typedef union {
  byte Byte;
  struct {
    byte DLC0        :1;                                       /* Data Length Code Bit 0 */
    byte DLC1        :1;                                       /* Data Length Code Bit 1 */
    byte DLC2        :1;                                       /* Data Length Code Bit 2 */
    byte DLC3        :1;                                       /* Data Length Code Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDLC  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CAN3RXDLRSTR;
extern volatile CAN3RXDLRSTR _CAN3RXDLR @(REG_BASE + 0x0000022CUL);
#define CAN3RXDLR                       _CAN3RXDLR.Byte
#define CAN3RXDLR_DLC0                  _CAN3RXDLR.Bits.DLC0
#define CAN3RXDLR_DLC1                  _CAN3RXDLR.Bits.DLC1
#define CAN3RXDLR_DLC2                  _CAN3RXDLR.Bits.DLC2
#define CAN3RXDLR_DLC3                  _CAN3RXDLR.Bits.DLC3
#define CAN3RXDLR_DLC                   _CAN3RXDLR.MergedBits.grpDLC

#define CAN3RXDLR_DLC0_MASK             1U
#define CAN3RXDLR_DLC1_MASK             2U
#define CAN3RXDLR_DLC2_MASK             4U
#define CAN3RXDLR_DLC3_MASK             8U
#define CAN3RXDLR_DLC_MASK              15U
#define CAN3RXDLR_DLC_BITNUM            0U


/*** CAN3RXTSR - MSCAN 3 Receive Time Stamp Register; 0x0000022E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CAN3RXTSRH - MSCAN 3 Receive Time Stamp Register High; 0x0000022E ***/
    union {
      byte Byte;
      struct {
        byte TSR8        :1;                                       /* Time Stamp Bit 8 */
        byte TSR9        :1;                                       /* Time Stamp Bit 9 */
        byte TSR10       :1;                                       /* Time Stamp Bit 10 */
        byte TSR11       :1;                                       /* Time Stamp Bit 11 */
        byte TSR12       :1;                                       /* Time Stamp Bit 12 */
        byte TSR13       :1;                                       /* Time Stamp Bit 13 */
        byte TSR14       :1;                                       /* Time Stamp Bit 14 */
        byte TSR15       :1;                                       /* Time Stamp Bit 15 */
      } Bits;
    } CAN3RXTSRHSTR;
    #define CAN3RXTSRH                  _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Byte
    #define CAN3RXTSRH_TSR8             _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Bits.TSR8
    #define CAN3RXTSRH_TSR9             _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Bits.TSR9
    #define CAN3RXTSRH_TSR10            _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Bits.TSR10
    #define CAN3RXTSRH_TSR11            _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Bits.TSR11
    #define CAN3RXTSRH_TSR12            _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Bits.TSR12
    #define CAN3RXTSRH_TSR13            _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Bits.TSR13
    #define CAN3RXTSRH_TSR14            _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Bits.TSR14
    #define CAN3RXTSRH_TSR15            _CAN3RXTSR.Overlap_STR.CAN3RXTSRHSTR.Bits.TSR15
    
    #define CAN3RXTSRH_TSR8_MASK        1U
    #define CAN3RXTSRH_TSR9_MASK        2U
    #define CAN3RXTSRH_TSR10_MASK       4U
    #define CAN3RXTSRH_TSR11_MASK       8U
    #define CAN3RXTSRH_TSR12_MASK       16U
    #define CAN3RXTSRH_TSR13_MASK       32U
    #define CAN3RXTSRH_TSR14_MASK       64U
    #define CAN3RXTSRH_TSR15_MASK       128U
    

    /*** CAN3RXTSRL - MSCAN 3 Receive Time Stamp Register Low; 0x0000022F ***/
    union {
      byte Byte;
      struct {
        byte TSR0        :1;                                       /* Time Stamp Bit 0 */
        byte TSR1        :1;                                       /* Time Stamp Bit 1 */
        byte TSR2        :1;                                       /* Time Stamp Bit 2 */
        byte TSR3        :1;                                       /* Time Stamp Bit 3 */
        byte TSR4        :1;                                       /* Time Stamp Bit 4 */
        byte TSR5        :1;                                       /* Time Stamp Bit 5 */
        byte TSR6        :1;                                       /* Time Stamp Bit 6 */
        byte TSR7        :1;                                       /* Time Stamp Bit 7 */
      } Bits;
    } CAN3RXTSRLSTR;
    #define CAN3RXTSRL                  _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Byte
    #define CAN3RXTSRL_TSR0             _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Bits.TSR0
    #define CAN3RXTSRL_TSR1             _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Bits.TSR1
    #define CAN3RXTSRL_TSR2             _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Bits.TSR2
    #define CAN3RXTSRL_TSR3             _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Bits.TSR3
    #define CAN3RXTSRL_TSR4             _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Bits.TSR4
    #define CAN3RXTSRL_TSR5             _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Bits.TSR5
    #define CAN3RXTSRL_TSR6             _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Bits.TSR6
    #define CAN3RXTSRL_TSR7             _CAN3RXTSR.Overlap_STR.CAN3RXTSRLSTR.Bits.TSR7
    
    #define CAN3RXTSRL_TSR0_MASK        1U
    #define CAN3RXTSRL_TSR1_MASK        2U
    #define CAN3RXTSRL_TSR2_MASK        4U
    #define CAN3RXTSRL_TSR3_MASK        8U
    #define CAN3RXTSRL_TSR4_MASK        16U
    #define CAN3RXTSRL_TSR5_MASK        32U
    #define CAN3RXTSRL_TSR6_MASK        64U
    #define CAN3RXTSRL_TSR7_MASK        128U
    
  } Overlap_STR;

  struct {
    word TSR0        :1;                                       /* Time Stamp Bit 0 */
    word TSR1        :1;                                       /* Time Stamp Bit 1 */
    word TSR2        :1;                                       /* Time Stamp Bit 2 */
    word TSR3        :1;                                       /* Time Stamp Bit 3 */
    word TSR4        :1;                                       /* Time Stamp Bit 4 */
    word TSR5        :1;                                       /* Time Stamp Bit 5 */
    word TSR6        :1;                                       /* Time Stamp Bit 6 */
    word TSR7        :1;                                       /* Time Stamp Bit 7 */
    word TSR8        :1;                                       /* Time Stamp Bit 8 */
    word TSR9        :1;                                       /* Time Stamp Bit 9 */
    word TSR10       :1;                                       /* Time Stamp Bit 10 */
    word TSR11       :1;                                       /* Time Stamp Bit 11 */
    word TSR12       :1;                                       /* Time Stamp Bit 12 */
    word TSR13       :1;                                       /* Time Stamp Bit 13 */
    word TSR14       :1;                                       /* Time Stamp Bit 14 */
    word TSR15       :1;                                       /* Time Stamp Bit 15 */
  } Bits;
} CAN3RXTSRSTR;
extern volatile CAN3RXTSRSTR _CAN3RXTSR @(REG_BASE + 0x0000022EUL);
#define CAN3RXTSR                       _CAN3RXTSR.Word
#define CAN3RXTSR_TSR0                  _CAN3RXTSR.Bits.TSR0
#define CAN3RXTSR_TSR1                  _CAN3RXTSR.Bits.TSR1
#define CAN3RXTSR_TSR2                  _CAN3RXTSR.Bits.TSR2
#define CAN3RXTSR_TSR3                  _CAN3RXTSR.Bits.TSR3
#define CAN3RXTSR_TSR4                  _CAN3RXTSR.Bits.TSR4
#define CAN3RXTSR_TSR5                  _CAN3RXTSR.Bits.TSR5
#define CAN3RXTSR_TSR6                  _CAN3RXTSR.Bits.TSR6
#define CAN3RXTSR_TSR7                  _CAN3RXTSR.Bits.TSR7
#define CAN3RXTSR_TSR8                  _CAN3RXTSR.Bits.TSR8
#define CAN3RXTSR_TSR9                  _CAN3RXTSR.Bits.TSR9
#define CAN3RXTSR_TSR10                 _CAN3RXTSR.Bits.TSR10
#define CAN3RXTSR_TSR11                 _CAN3RXTSR.Bits.TSR11
#define CAN3RXTSR_TSR12                 _CAN3RXTSR.Bits.TSR12
#define CAN3RXTSR_TSR13                 _CAN3RXTSR.Bits.TSR13
#define CAN3RXTSR_TSR14                 _CAN3RXTSR.Bits.TSR14
#define CAN3RXTSR_TSR15                 _CAN3RXTSR.Bits.TSR15

#define CAN3RXTSR_TSR0_MASK             1U
#define CAN3RXTSR_TSR1_MASK             2U
#define CAN3RXTSR_TSR2_MASK             4U
#define CAN3RXTSR_TSR3_MASK             8U
#define CAN3RXTSR_TSR4_MASK             16U
#define CAN3RXTSR_TSR5_MASK             32U
#define CAN3RXTSR_TSR6_MASK             64U
#define CAN3RXTSR_TSR7_MASK             128U
#define CAN3RXTSR_TSR8_MASK             256U
#define CAN3RXTSR_TSR9_MASK             512U
#define CAN3RXTSR_TSR10_MASK            1024U
#define CAN3RXTSR_TSR11_MASK            2048U
#define CAN3RXTSR_TSR12_MASK            4096U
#define CAN3RXTSR_TSR13_MASK            8192U
#define CAN3RXTSR_TSR14_MASK            16384U
#define CAN3RXTSR_TSR15_MASK            32768U


/*** CAN3TXIDR0 - MSCAN 3 Transmit Identifier Register 0; 0x00000230 ***/
typedef union {
  byte Byte;
  struct {
    byte ID21        :1;                                       /* Extended format identifier Bit 21 */
    byte ID22        :1;                                       /* Extended format identifier Bit 22 */
    byte ID23        :1;                                       /* Extended format identifier Bit 23 */
    byte ID24        :1;                                       /* Extended format identifier Bit 24 */
    byte ID25        :1;                                       /* Extended format identifier Bit 25 */
    byte ID26        :1;                                       /* Extended format identifier Bit 26 */
    byte ID27        :1;                                       /* Extended format identifier Bit 27 */
    byte ID28        :1;                                       /* Extended format identifier Bit 28 */
  } Bits;
} CAN3TXIDR0STR;
extern volatile CAN3TXIDR0STR _CAN3TXIDR0 @(REG_BASE + 0x00000230UL);
#define CAN3TXIDR0                      _CAN3TXIDR0.Byte
#define CAN3TXIDR0_ID21                 _CAN3TXIDR0.Bits.ID21
#define CAN3TXIDR0_ID22                 _CAN3TXIDR0.Bits.ID22
#define CAN3TXIDR0_ID23                 _CAN3TXIDR0.Bits.ID23
#define CAN3TXIDR0_ID24                 _CAN3TXIDR0.Bits.ID24
#define CAN3TXIDR0_ID25                 _CAN3TXIDR0.Bits.ID25
#define CAN3TXIDR0_ID26                 _CAN3TXIDR0.Bits.ID26
#define CAN3TXIDR0_ID27                 _CAN3TXIDR0.Bits.ID27
#define CAN3TXIDR0_ID28                 _CAN3TXIDR0.Bits.ID28
/* CAN3TXIDR_ARR: Access 4 CAN3TXIDRx registers in an array */
#define CAN3TXIDR_ARR                   ((volatile byte *) &CAN3TXIDR0)

#define CAN3TXIDR0_ID21_MASK            1U
#define CAN3TXIDR0_ID22_MASK            2U
#define CAN3TXIDR0_ID23_MASK            4U
#define CAN3TXIDR0_ID24_MASK            8U
#define CAN3TXIDR0_ID25_MASK            16U
#define CAN3TXIDR0_ID26_MASK            32U
#define CAN3TXIDR0_ID27_MASK            64U
#define CAN3TXIDR0_ID28_MASK            128U


/*** CAN3TXIDR1 - MSCAN 3 Transmit Identifier Register 1; 0x00000231 ***/
typedef union {
  byte Byte;
  struct {
    byte ID15        :1;                                       /* Extended format identifier Bit 15 */
    byte ID16        :1;                                       /* Extended format identifier Bit 16 */
    byte ID17        :1;                                       /* Extended format identifier Bit 17 */
    byte IDE         :1;                                       /* ID Extended */
    byte SRR         :1;                                       /* Substitute Remote Request */
    byte ID18        :1;                                       /* Extended format identifier Bit 18 */
    byte ID19        :1;                                       /* Extended format identifier Bit 19 */
    byte ID20        :1;                                       /* Extended format identifier Bit 20 */
  } Bits;
  struct {
    byte grpID_15 :3;
    byte         :1;
    byte         :1;
    byte grpID_18 :3;
  } MergedBits;
} CAN3TXIDR1STR;
extern volatile CAN3TXIDR1STR _CAN3TXIDR1 @(REG_BASE + 0x00000231UL);
#define CAN3TXIDR1                      _CAN3TXIDR1.Byte
#define CAN3TXIDR1_ID15                 _CAN3TXIDR1.Bits.ID15
#define CAN3TXIDR1_ID16                 _CAN3TXIDR1.Bits.ID16
#define CAN3TXIDR1_ID17                 _CAN3TXIDR1.Bits.ID17
#define CAN3TXIDR1_IDE                  _CAN3TXIDR1.Bits.IDE
#define CAN3TXIDR1_SRR                  _CAN3TXIDR1.Bits.SRR
#define CAN3TXIDR1_ID18                 _CAN3TXIDR1.Bits.ID18
#define CAN3TXIDR1_ID19                 _CAN3TXIDR1.Bits.ID19
#define CAN3TXIDR1_ID20                 _CAN3TXIDR1.Bits.ID20
#define CAN3TXIDR1_ID_15                _CAN3TXIDR1.MergedBits.grpID_15
#define CAN3TXIDR1_ID_18                _CAN3TXIDR1.MergedBits.grpID_18
#define CAN3TXIDR1_ID                   CAN3TXIDR1_ID_15

#define CAN3TXIDR1_ID15_MASK            1U
#define CAN3TXIDR1_ID16_MASK            2U
#define CAN3TXIDR1_ID17_MASK            4U
#define CAN3TXIDR1_IDE_MASK             8U
#define CAN3TXIDR1_SRR_MASK             16U
#define CAN3TXIDR1_ID18_MASK            32U
#define CAN3TXIDR1_ID19_MASK            64U
#define CAN3TXIDR1_ID20_MASK            128U
#define CAN3TXIDR1_ID_15_MASK           7U
#define CAN3TXIDR1_ID_15_BITNUM         0U
#define CAN3TXIDR1_ID_18_MASK           224U
#define CAN3TXIDR1_ID_18_BITNUM         5U


/*** CAN3TXIDR2 - MSCAN 3 Transmit Identifier Register 2; 0x00000232 ***/
typedef union {
  byte Byte;
  struct {
    byte ID7         :1;                                       /* Extended format identifier Bit 7 */
    byte ID8         :1;                                       /* Extended format identifier Bit 8 */
    byte ID9         :1;                                       /* Extended format identifier Bit 9 */
    byte ID10        :1;                                       /* Extended format identifier Bit 10 */
    byte ID11        :1;                                       /* Extended format identifier Bit 11 */
    byte ID12        :1;                                       /* Extended format identifier Bit 12 */
    byte ID13        :1;                                       /* Extended format identifier Bit 13 */
    byte ID14        :1;                                       /* Extended format identifier Bit 14 */
  } Bits;
} CAN3TXIDR2STR;
extern volatile CAN3TXIDR2STR _CAN3TXIDR2 @(REG_BASE + 0x00000232UL);
#define CAN3TXIDR2                      _CAN3TXIDR2.Byte
#define CAN3TXIDR2_ID7                  _CAN3TXIDR2.Bits.ID7
#define CAN3TXIDR2_ID8                  _CAN3TXIDR2.Bits.ID8
#define CAN3TXIDR2_ID9                  _CAN3TXIDR2.Bits.ID9
#define CAN3TXIDR2_ID10                 _CAN3TXIDR2.Bits.ID10
#define CAN3TXIDR2_ID11                 _CAN3TXIDR2.Bits.ID11
#define CAN3TXIDR2_ID12                 _CAN3TXIDR2.Bits.ID12
#define CAN3TXIDR2_ID13                 _CAN3TXIDR2.Bits.ID13
#define CAN3TXIDR2_ID14                 _CAN3TXIDR2.Bits.ID14

#define CAN3TXIDR2_ID7_MASK             1U
#define CAN3TXIDR2_ID8_MASK             2U
#define CAN3TXIDR2_ID9_MASK             4U
#define CAN3TXIDR2_ID10_MASK            8U
#define CAN3TXIDR2_ID11_MASK            16U
#define CAN3TXIDR2_ID12_MASK            32U
#define CAN3TXIDR2_ID13_MASK            64U
#define CAN3TXIDR2_ID14_MASK            128U


/*** CAN3TXIDR3 - MSCAN 3 Transmit Identifier Register 3; 0x00000233 ***/
typedef union {
  byte Byte;
  struct {
    byte RTR         :1;                                       /* Remote Transmission Request */
    byte ID0         :1;                                       /* Extended format identifier Bit 0 */
    byte ID1         :1;                                       /* Extended format identifier Bit 1 */
    byte ID2         :1;                                       /* Extended format identifier Bit 2 */
    byte ID3         :1;                                       /* Extended format identifier Bit 3 */
    byte ID4         :1;                                       /* Extended format identifier Bit 4 */
    byte ID5         :1;                                       /* Extended format identifier Bit 5 */
    byte ID6         :1;                                       /* Extended format identifier Bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpID   :7;
  } MergedBits;
} CAN3TXIDR3STR;
extern volatile CAN